LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\app\\scripts\\constants\\contracts.ts", {"../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cconstants%5Ccontracts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SINGLE_CALL_BALANCES_ADDRESSES = void 0;
var _network = require("../../../shared/constants/network");
const SINGLE_CALL_BALANCES_ADDRESSES = exports.SINGLE_CALL_BALANCES_ADDRESSES = {
  [_network.CHAIN_IDS.MAINNET]: '0xb1f8e55c7f64d203c1400b9d8555d050f94adf39',
  [_network.CHAIN_IDS.GOERLI]: '0x9788C4E93f9002a7ad8e72633b11E8d1ecd51f9b',
  // TODO(SEPOLIA) There is currently no balance call address for Sepolia
  // [CHAIN_IDS.SEPOLIA]: '',
  [_network.CHAIN_IDS.BSC]: '0x2352c63A83f9Fd126af8676146721Fa00924d7e4',
  [_network.CHAIN_IDS.OPTIMISM]: '0xB1c568e9C3E6bdaf755A60c7418C269eb11524FC',
  [_network.CHAIN_IDS.POLYGON]: '0x2352c63A83f9Fd126af8676146721Fa00924d7e4',
  [_network.CHAIN_IDS.AVALANCHE]: '0xD023D153a0DFa485130ECFdE2FAA7e612EF94818',
  [_network.CHAIN_IDS.FANTOM]: '0x07f697424ABe762bB808c109860c04eA488ff92B',
  [_network.CHAIN_IDS.ARBITRUM]: '0x151E24A486D7258dd7C33Fb67E4bB01919B7B32c',
  [_network.CHAIN_IDS.BLAST]: '0xfd5730e96f9dffae40d99b77015bd42816280998',
  [_network.CHAIN_IDS.LINEA_GOERLI]: '0x10dAd7Ca3921471f616db788D9300DC97Db01783',
  [_network.CHAIN_IDS.LINEA_MAINNET]: '0xF62e6a41561b3650a69Bb03199C735e3E3328c0D',
  [_network.CHAIN_IDS.AURORA]: '0x1286415D333855237f89Df27D388127181448538',
  [_network.CHAIN_IDS.BASE]: '0x6AA75276052D96696134252587894ef5FFA520af',
  [_network.CHAIN_IDS.ZKSYNC_ERA]: '0x458fEd3144680a5b8bcfaa0F9594aa19B4Ea2D34'
};

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\constants\\contracts.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\constants\\marketing-site-whitelist.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cconstants%5Cmarketing-site-whitelist.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.COOKIE_ID_MARKETING_WHITELIST_ORIGINS = exports.COOKIE_ID_MARKETING_WHITELIST = void 0;
const COOKIE_ID_MARKETING_WHITELIST = exports.COOKIE_ID_MARKETING_WHITELIST = ['https://metamask.io', 'https://learn.metamask.io', 'https://mmi-support.zendesk.com', 'https://community.metamask.io', 'https://support.metamask.io'];
if (false) {
  COOKIE_ID_MARKETING_WHITELIST.push('http://127.0.0.1:8080');
}

// Extract the origin of each URL in the whitelist
const COOKIE_ID_MARKETING_WHITELIST_ORIGINS = exports.COOKIE_ID_MARKETING_WHITELIST_ORIGINS = COOKIE_ID_MARKETING_WHITELIST.map(url => new URL(url).origin);

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\constants\\marketing-site-whitelist.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\constants\\snaps.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cconstants%5Csnaps.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PREINSTALLED_SNAPS_URLS = void 0;
var _self$document, _self$document2, _self$document3, _self$document4;
// Needed for webpack to analyze the preinstalled snaps
const PREINSTALLED_SNAPS_URLS = exports.PREINSTALLED_SNAPS_URLS = [new URL("\\snaps\\message-signing-snap.json", ((_self$document = self.document) === null || _self$document === void 0 ? void 0 : _self$document.baseURI) || self.location.href), new URL("\\snaps\\ens-resolver-snap.json", ((_self$document2 = self.document) === null || _self$document2 === void 0 ? void 0 : _self$document2.baseURI) || self.location.href), new URL("\\snaps\\institutional-wallet-snap.json", ((_self$document3 = self.document) === null || _self$document3 === void 0 ? void 0 : _self$document3.baseURI) || self.location.href), new URL("\\snaps\\solana-wallet-snap.json", ((_self$document4 = self.document) === null || _self$document4 === void 0 ? void 0 : _self$document4.baseURI) || self.location.href)];

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\constants\\snaps.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\constants\\stream.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cconstants%5Cstream.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PHISHING_WARNING_PAGE = exports.PHISHING_STREAM = exports.PHISHING_SAFELIST = exports.METAMASK_INPAGE = exports.METAMASK_EIP_1193_PROVIDER = exports.METAMASK_COOKIE_HANDLER = exports.METAMASK_CAIP_MULTICHAIN_PROVIDER = exports.LEGACY_PUBLIC_CONFIG = exports.LEGACY_PROVIDER = exports.LEGACY_INPAGE = exports.LEGACY_CONTENT_SCRIPT = exports.CONTENT_SCRIPT = void 0;
// contexts
const CONTENT_SCRIPT = exports.CONTENT_SCRIPT = 'aeriswallet-contentscript';
const METAMASK_INPAGE = exports.METAMASK_INPAGE = 'aeriswallet-inpage';
const PHISHING_WARNING_PAGE = exports.PHISHING_WARNING_PAGE = 'metamask-phishing-warning-page';

// stream channels
const METAMASK_COOKIE_HANDLER = exports.METAMASK_COOKIE_HANDLER = 'metamask-cookie-handler';
const METAMASK_EIP_1193_PROVIDER = exports.METAMASK_EIP_1193_PROVIDER = 'metamask-provider';
const METAMASK_CAIP_MULTICHAIN_PROVIDER = exports.METAMASK_CAIP_MULTICHAIN_PROVIDER = 'metamask-multichain-provider';
const PHISHING_SAFELIST = exports.PHISHING_SAFELIST = 'metamask-phishing-safelist';
const PHISHING_STREAM = exports.PHISHING_STREAM = 'phishing';

// For more information about these legacy streams, see here:
// https://github.com/MetaMask/metamask-extension/issues/15491
// TODO:LegacyProvider: Delete
const LEGACY_CONTENT_SCRIPT = exports.LEGACY_CONTENT_SCRIPT = 'contentscript';
const LEGACY_INPAGE = exports.LEGACY_INPAGE = 'inpage';
const LEGACY_PROVIDER = exports.LEGACY_PROVIDER = 'provider';
const LEGACY_PUBLIC_CONFIG = exports.LEGACY_PUBLIC_CONFIG = 'publicConfig';

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\constants\\stream.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\account-order-controller-init.ts", {"../controllers/account-order":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\account-order.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Caccount-order-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountOrderControllerInit = void 0;
var _accountOrder = require("../controllers/account-order");
/**
 * Initialize the accountOrder controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state to use for the
 * controller.
 * @returns The initialized controller.
 */
const AccountOrderControllerInit = ({
  controllerMessenger,
  persistedState
}) => {
  const controller = new _accountOrder.AccountOrderController({
    messenger: controllerMessenger,
    state: persistedState.AccountOrderController
  });
  return {
    controller
  };
};
exports.AccountOrderControllerInit = AccountOrderControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\account-order-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\account-tracker-controller-init.ts", {"../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../controllers/account-tracker-controller":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\account-tracker-controller.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Caccount-tracker-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountTrackerControllerInit = void 0;
var _utils = require("@metamask/utils");
var _networks = require("../../../shared/modules/selectors/networks");
var _network = require("../../../shared/constants/network");
var _accountTrackerController = _interopRequireDefault(require("../controllers/account-tracker-controller"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Initialize the account tracker controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.initMessenger - The messenger to use for initialization.
 * @returns The initialized controller.
 */
const AccountTrackerControllerInit = ({
  controllerMessenger,
  initMessenger
}) => {
  const {
    provider,
    blockTracker
  } = initMessenger.call('NetworkController:getSelectedNetworkClient') ?? {};
  (0, _utils.assert)(provider, 'Provider is required to initialize AccountTrackerController.');
  (0, _utils.assert)(blockTracker, 'Block tracker is required to initialize AccountTrackerController.');
  const controller = new _accountTrackerController.default({
    state: {
      accounts: {}
    },
    messenger: controllerMessenger,
    provider,
    blockTracker,
    getNetworkIdentifier: providerConfig => {
      const metamask = initMessenger.call('NetworkController:getState');
      const config = providerConfig ?? (0, _networks.getProviderConfig)({
        metamask
      });
      return config.type === _network.NETWORK_TYPES.RPC && config.rpcUrl ? config.rpcUrl : config.type;
    },
    accountsApiChainIds: () => {
      var _state$remoteFeatureF;
      const state = initMessenger.call('RemoteFeatureFlagController:getState');
      const featureFlagForAccountApiBalances = state === null || state === void 0 || (_state$remoteFeatureF = state.remoteFeatureFlags) === null || _state$remoteFeatureF === void 0 ? void 0 : _state$remoteFeatureF.assetsAccountApiBalances;
      return Array.isArray(featureFlagForAccountApiBalances) ? featureFlagForAccountApiBalances : [];
    }
  });

  // Ensure `AccountTrackerController` updates balances after network change.
  initMessenger.subscribe('NetworkController:networkDidChange', () => {
    controller.updateAccounts();
  });
  return {
    persistedStateKey: null,
    memStateKey: null,
    controller
  };
};
exports.AccountTrackerControllerInit = AccountTrackerControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\account-tracker-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\accounts-controller-init.ts", {"@metamask/accounts-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\accounts-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Caccounts-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountsControllerInit = void 0;
var _accountsController = require("@metamask/accounts-controller");
/**
 * Initialize the accounts controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state to use for the
 * controller.
 * @returns The initialized controller.
 */
const AccountsControllerInit = ({
  controllerMessenger,
  persistedState
}) => {
  const controller = new _accountsController.AccountsController({
    messenger: controllerMessenger,
    // @ts-expect-error: Accounts controller does not accept partial state.
    state: persistedState.AccountsController
  });
  return {
    controller
  };
};
exports.AccountsControllerInit = AccountsControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\accounts-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\accounts\\account-tree-controller-init.ts", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","@metamask/account-tree-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Caccounts%5Caccount-tree-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountTreeControllerInit = void 0;
var _accountTreeController = require("@metamask/account-tree-controller");
var _trace = require("../../../../shared/lib/trace");
var _metametrics = require("../../../../shared/constants/metametrics");
/**
 * Initialize the account wallet controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @param request.initMessenger - The init messenger to use for the controller.
 * @returns The initialized controller.
 */
const AccountTreeControllerInit = ({
  controllerMessenger,
  persistedState,
  initMessenger
}) => {
  const controller = new _accountTreeController.AccountTreeController({
    messenger: controllerMessenger,
    state: persistedState.AccountTreeController,
    config: {
      // @ts-expect-error Controller uses string for names rather than enum
      trace: _trace.trace,
      backupAndSync: {
        onBackupAndSyncEvent: event => {
          initMessenger.call('MetaMetricsController:trackEvent', {
            category: _metametrics.MetaMetricsEventCategory.BackupAndSync,
            event: _metametrics.MetaMetricsEventName.ProfileActivityUpdated,
            properties: {
              // @ts-expect-error events coming from the controller are typed and this conflicts with the expected Record<string, Json> type
              event
            }
          });
        }
      },
      accountOrderCallbacks: {
        isHiddenAccount: accountId => {
          const internalAccount = initMessenger.call('AccountsController:getAccount', accountId);
          if (!internalAccount) {
            return false;
          }
          const accountOrderState = initMessenger.call('AccountOrderController:getState');
          return accountOrderState.hiddenAccountList.includes(internalAccount.address);
        },
        isPinnedAccount: accountId => {
          const internalAccount = initMessenger.call('AccountsController:getAccount', accountId);
          if (!internalAccount) {
            return false;
          }
          const accountOrderState = initMessenger.call('AccountOrderController:getState');
          return accountOrderState.pinnedAccountList.includes(internalAccount.address);
        }
      }
    }
  });

  // Re-build initial account wallet tree.
  // FIXME: We cannot do call `init` here, since we need to have the `KeyringController`'s
  // state to be "ready" (thus, unlocked). So we instead follow the same pattern than
  // the `AccountsController.updateAccounts` method and re-construct the tree at the
  // same time.

  return {
    controller
  };
};
exports.AccountTreeControllerInit = AccountTreeControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\accounts\\account-tree-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\accounts\\snap-keyring-builder-init.ts", {"../../lib/snap-keyring/snap-keyring":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\snap-keyring\\snap-keyring.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Caccounts%5Csnap-keyring-builder-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapKeyringBuilderInit = void 0;
var _snapKeyring = require("../../lib/snap-keyring/snap-keyring");
/**
 * Initialize the Snap keyring builder.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the keyring
 * builder.
 * @param request.initMessenger
 * @param request.removeAccount
 * @returns The initialized controller.
 */
const SnapKeyringBuilderInit = ({
  controllerMessenger,
  initMessenger,
  removeAccount
}) => {
  const builder = (0, _snapKeyring.snapKeyringBuilder)(controllerMessenger, {
    persistKeyringHelper: async () => {
      await initMessenger.call('KeyringController:persistAllKeyrings');
      await initMessenger.call('AccountsController:updateAccounts');
    },
    removeAccountHelper: async address => {
      await removeAccount(address);
    },
    trackEvent: initMessenger.call.bind(initMessenger, 'MetaMetricsController:trackEvent')
  });
  return {
    persistedStateKey: null,
    memStateKey: null,
    controller: builder
  };
};
exports.SnapKeyringBuilderInit = SnapKeyringBuilderInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\accounts\\snap-keyring-builder-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\alert-controller-init.ts", {"../controllers/alert-controller":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\alert-controller.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Calert-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertControllerInit = void 0;
var _alertController = require("../controllers/alert-controller");
/**
 * Initialize the alert controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state to use for the
 * controller.
 * @returns The initialized controller.
 */
const AlertControllerInit = ({
  controllerMessenger,
  persistedState
}) => {
  const controller = new _alertController.AlertController({
    state: persistedState.AlertController,
    messenger: controllerMessenger
  });
  return {
    controller
  };
};
exports.AlertControllerInit = AlertControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\alert-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\announcement-controller-init.ts", {"../../../shared/notifications":"D:\\code\\v\\metamask-extension\\shared\\notifications\\index.ts","@metamask/announcement-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\announcement-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cannouncement-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnouncementControllerInit = void 0;
var _announcementController = require("@metamask/announcement-controller");
var _notifications = require("../../../shared/notifications");
/**
 * Initialize the announcement controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state to use for the
 * controller.
 * @returns The initialized controller.
 */
const AnnouncementControllerInit = ({
  controllerMessenger,
  persistedState
}) => {
  const controller = new _announcementController.AnnouncementController({
    messenger: controllerMessenger,
    allAnnouncements: _notifications.UI_NOTIFICATIONS,
    // @ts-expect-error: Announcement controller does not accept partial state.
    state: persistedState.AnnouncementController
  });
  return {
    controller
  };
};
exports.AnnouncementControllerInit = AnnouncementControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\announcement-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\app-metadata-controller-init.ts", {"../controllers/app-metadata":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\app-metadata.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Capp-metadata-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppMetadataControllerInit = void 0;
var _appMetadata = _interopRequireDefault(require("../controllers/app-metadata"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Initialize the appMetadata controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state to use for the
 * controller.
 * @param request.currentMigrationVersion
 * @returns The initialized controller.
 */
const AppMetadataControllerInit = ({
  controllerMessenger,
  persistedState,
  currentMigrationVersion
}) => {
  const controller = new _appMetadata.default({
    state: persistedState.AppMetadataController,
    messenger: controllerMessenger,
    currentAppVersion: "13.6.0",
    currentMigrationVersion
  });
  return {
    controller
  };
};
exports.AppMetadataControllerInit = AppMetadataControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\app-metadata-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\app-state-controller-init.ts", {"../controllers/app-state-controller":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\app-state-controller.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Capp-state-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppStateControllerInit = void 0;
var _appStateController = require("../controllers/app-state-controller");
/**
 * Initialize the app state controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @param request.setLocked - Function to set the app as locked.
 * @param request.extension - The extension browser API.
 * @returns The initialized controller.
 */
const AppStateControllerInit = ({
  controllerMessenger,
  persistedState,
  setLocked,
  extension
}) => {
  const controller = new _appStateController.AppStateController({
    messenger: controllerMessenger,
    state: persistedState.AppStateController,
    onInactiveTimeout: () => setLocked(),
    extension
  });
  return {
    controller
  };
};
exports.AppStateControllerInit = AppStateControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\app-state-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\assets\\assets-contract-controller-init.ts", {"../init-utils":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\init-utils.ts","@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cassets%5Cassets-contract-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetsContractControllerInit = void 0;
var _assetsControllers = require("@metamask/assets-controllers");
var _initUtils = require("../init-utils");
/**
 * Initialize the AssetsContractController.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.initMessenger - The messenger to use for initialization.
 * @returns The initialized controller.
 */
const AssetsContractControllerInit = ({
  controllerMessenger,
  initMessenger
}) => {
  const controller = new _assetsControllers.AssetsContractController({
    messenger: controllerMessenger,
    chainId: (0, _initUtils.getGlobalChainId)(initMessenger)
  });
  return {
    controller,
    memStateKey: null
  };
};
exports.AssetsContractControllerInit = AssetsContractControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\assets\\assets-contract-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\assets\\index.ts", {"./assets-contract-controller-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\assets\\assets-contract-controller-init.ts","./network-order-controller-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\assets\\network-order-controller-init.ts","./nft-controller-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\assets\\nft-controller-init.ts","./nft-detection-controller-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\assets\\nft-detection-controller-init.ts","./token-rates-controller-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\assets\\token-rates-controller-init.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cassets%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AssetsContractControllerInit", {
  enumerable: true,
  get: function () {
    return _assetsContractControllerInit.AssetsContractControllerInit;
  }
});
Object.defineProperty(exports, "NetworkOrderControllerInit", {
  enumerable: true,
  get: function () {
    return _networkOrderControllerInit.NetworkOrderControllerInit;
  }
});
Object.defineProperty(exports, "NftControllerInit", {
  enumerable: true,
  get: function () {
    return _nftControllerInit.NftControllerInit;
  }
});
Object.defineProperty(exports, "NftDetectionControllerInit", {
  enumerable: true,
  get: function () {
    return _nftDetectionControllerInit.NftDetectionControllerInit;
  }
});
Object.defineProperty(exports, "TokenRatesControllerInit", {
  enumerable: true,
  get: function () {
    return _tokenRatesControllerInit.TokenRatesControllerInit;
  }
});
var _tokenRatesControllerInit = require("./token-rates-controller-init");
var _nftControllerInit = require("./nft-controller-init");
var _nftDetectionControllerInit = require("./nft-detection-controller-init");
var _assetsContractControllerInit = require("./assets-contract-controller-init");
var _networkOrderControllerInit = require("./network-order-controller-init");

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\assets\\index.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\assets\\network-enablement-controller-init.ts", {"../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/network-enablement-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-enablement-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cassets%5Cnetwork-enablement-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkEnablementControllerInit = void 0;
var _networkEnablementController = require("@metamask/network-enablement-controller");
var _keyringApi = require("@metamask/keyring-api");
var _utils = require("@metamask/utils");
var _network = require("../../../../shared/constants/network");
/**
 * Generates a map of EVM chain IDs to their enabled status based on NetworkController state.
 *
 * @param networkConfigurationsByChainId - The network configurations from NetworkController
 * @param enabledChainIds - Array of chain IDs that should be enabled
 * @returns Record mapping chain IDs to boolean enabled status
 */
const generateEVMNetworkMap = (networkConfigurationsByChainId, enabledChainIds) => {
  const networkMap = {
    [_utils.KnownCaipNamespace.Eip155]: {}
  };
  Object.keys(networkConfigurationsByChainId).forEach(chainId => {
    networkMap[_utils.KnownCaipNamespace.Eip155][chainId] = enabledChainIds.includes(chainId);
  });
  return networkMap;
};

/**
 * Generates a map of multichain networks organized by network type based on MultichainNetworkController state.
 *
 * @param multichainNetworkConfigurationsByChainId - The multichain network configurations
 * @param enabledNetworks - Array of network IDs that should be enabled (empty by default)
 * @returns Record mapping network types to their network maps
 */
const generateMultichainNetworkMaps = (multichainNetworkConfigurationsByChainId, enabledNetworks = []) => {
  const networkMaps = {};
  Object.keys(multichainNetworkConfigurationsByChainId).forEach(chainId => {
    const isEnabled = enabledNetworks.includes(chainId);
    const {
      namespace
    } = (0, _utils.parseCaipChainId)(chainId);
    (networkMaps[namespace] ?? (networkMaps[namespace] = {}))[chainId] = isEnabled;
  });
  return networkMaps;
};
const generateDefaultNetworkEnablementControllerState = (networkControllerState, multichainNetworkControllerState) => {
  const {
    networkConfigurationsByChainId
  } = networkControllerState;
  const {
    multichainNetworkConfigurationsByChainId
  } = multichainNetworkControllerState;
  if (false) {
    return {
      enabledNetworkMap: {
        ...generateEVMNetworkMap(networkConfigurationsByChainId, [_network.CHAIN_IDS.LOCALHOST]),
        ...generateMultichainNetworkMaps(multichainNetworkConfigurationsByChainId, [])
      }
    };
  } else if (true || "development" === 'test') {
    return {
      enabledNetworkMap: {
        ...generateEVMNetworkMap(networkConfigurationsByChainId, [_network.CHAIN_IDS.SEPOLIA]),
        ...generateMultichainNetworkMaps(multichainNetworkConfigurationsByChainId, [])
      }
    };
  }
  const enabledMultichainNetworks = [_keyringApi.SolScope.Mainnet];
  return {
    enabledNetworkMap: {
      ...generateEVMNetworkMap(networkConfigurationsByChainId, _network.FEATURED_NETWORK_CHAIN_IDS),
      ...generateMultichainNetworkMaps(multichainNetworkConfigurationsByChainId, enabledMultichainNetworks)
    }
  };
};
const NetworkEnablementControllerInit = ({
  controllerMessenger,
  initMessenger,
  persistedState,
  getController
}) => {
  const multichainNetworkControllerState = getController('MultichainNetworkController').state;
  const networkControllerState = getController('NetworkController').state;
  const controller = new _networkEnablementController.NetworkEnablementController({
    messenger: controllerMessenger,
    state: {
      ...generateDefaultNetworkEnablementControllerState(networkControllerState, multichainNetworkControllerState),
      ...persistedState.NetworkEnablementController
    }
  });

  // TODO: Remove this after BIP-44 rollout.
  initMessenger.subscribe('AccountsController:selectedAccountChange', account => {
    if (account.type === _keyringApi.SolAccountType.DataAccount) {
      controller.enableNetworkInNamespace(_keyringApi.SolScope.Mainnet, _utils.KnownCaipNamespace.Solana);
    }
  });
  initMessenger.subscribe('AccountTreeController:selectedAccountGroupChange', () => {
    const solAccounts = initMessenger.call('AccountTreeController:getAccountsFromSelectedAccountGroup', {
      scopes: [_keyringApi.SolScope.Mainnet]
    });
    const allEnabledNetworks = Object.values(controller.state.enabledNetworkMap).reduce((acc, curr) => {
      return {
        ...acc,
        ...curr
      };
    }, {});
    if (Object.keys(allEnabledNetworks).length === 1) {
      const chainId = Object.keys(allEnabledNetworks)[0];
      let shouldEnableMainnetNetworks = false;
      if (chainId === _keyringApi.SolScope.Mainnet && solAccounts.length === 0) {
        shouldEnableMainnetNetworks = true;
      }
      if (shouldEnableMainnetNetworks) {
        controller.enableNetwork('0x1');
      }
    }
  });
  return {
    controller
  };
};
exports.NetworkEnablementControllerInit = NetworkEnablementControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\assets\\network-enablement-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\assets\\network-order-controller-init.ts", {"../../controllers/network-order":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\network-order.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cassets%5Cnetwork-order-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkOrderControllerInit = void 0;
var _networkOrder = require("../../controllers/network-order");
const generateDefaultNetworkOrderControllerState = () => {
  if (true && "development" === 'development' && !false) {
    return {
      orderedNetworkList: []
    };
  }
  return {
    orderedNetworkList: []
  };
};
const NetworkOrderControllerInit = ({
  controllerMessenger,
  persistedState
}) => {
  const controller = new _networkOrder.NetworkOrderController({
    messenger: controllerMessenger,
    state: {
      ...generateDefaultNetworkOrderControllerState(),
      ...persistedState.NetworkOrderController
    }
  });
  return {
    controller
  };
};
exports.NetworkOrderControllerInit = NetworkOrderControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\assets\\network-order-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\assets\\nft-controller-init.ts", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cassets%5Cnft-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NftControllerInit = void 0;
var _assetsControllers = require("@metamask/assets-controllers");
var _bridgeController = require("@metamask/bridge-controller");
var _metametrics = require("../../../../shared/constants/metametrics");
/**
 * Initialize the NFT controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @param request.initMessenger - The messenger used for initialization.
 * @returns The initialized controller.
 */
const NftControllerInit = ({
  controllerMessenger,
  initMessenger,
  persistedState
}) => {
  const controller = new _assetsControllers.NftController({
    state: persistedState.NftController,
    messenger: controllerMessenger,
    onNftAdded: ({
      address,
      symbol,
      tokenId,
      standard,
      source
    }) => initMessenger.call('MetaMetricsController:trackEvent', {
      event: _metametrics.MetaMetricsEventName.NftAdded,
      category: _metametrics.MetaMetricsEventCategory.Wallet,
      sensitiveProperties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_contract_address: address,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_symbol: symbol ?? null,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_id: tokenId,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        token_standard: standard,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        asset_type: _bridgeController.AssetType.NFT,
        source
      }
    })
  });
  return {
    controller
  };
};
exports.NftControllerInit = NftControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\assets\\nft-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\assets\\nft-detection-controller-init.ts", {"@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cassets%5Cnft-detection-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NftDetectionControllerInit = void 0;
var _assetsControllers = require("@metamask/assets-controllers");
/**
 * Initialize the NFT detection controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.getController - The function to get the controller.
 * @returns The initialized controller.
 */
const NftDetectionControllerInit = request => {
  const {
    controllerMessenger,
    getController
  } = request;
  const preferencesController = () => getController('PreferencesController');
  const nftController = () => getController('NftController');
  const controller = new _assetsControllers.NftDetectionController({
    messenger: controllerMessenger,
    addNft: (...args) => nftController().addNft(...args),
    getNftState: () => nftController().state,
    // added this to track previous value of useNftDetection, should be true on very first initializing of controller[]
    disabled: !preferencesController().state.useNftDetection
  });
  return {
    controller
  };
};
exports.NftDetectionControllerInit = NftDetectionControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\assets\\nft-detection-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\assets\\token-rates-controller-init.ts", {"../../lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cassets%5Ctoken-rates-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TokenRatesControllerInit = void 0;
var _assetsControllers = require("@metamask/assets-controllers");
var _util = require("../../lib/util");
/**
 * Initialize the Token Rates controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @returns The initialized controller.
 */
const TokenRatesControllerInit = request => {
  const {
    controllerMessenger,
    initMessenger,
    persistedState
  } = request;
  const preferencesState = initMessenger.call('PreferencesController:getState');
  const controller = new _assetsControllers.TokenRatesController({
    messenger: controllerMessenger,
    state: persistedState.TokenRatesController,
    tokenPricesService: new _assetsControllers.CodefiTokenPricesServiceV2(),
    disabled: !preferencesState.useCurrencyRateCheck
  });
  initMessenger.subscribe('PreferencesController:stateChange', (0, _util.previousValueComparator)((prevState, currState) => {
    const {
      useCurrencyRateCheck: prevUseCurrencyRateCheck
    } = prevState;
    const {
      useCurrencyRateCheck: currUseCurrencyRateCheck
    } = currState;
    if (currUseCurrencyRateCheck && !prevUseCurrencyRateCheck) {
      controller.enable();
    } else if (!currUseCurrencyRateCheck && prevUseCurrencyRateCheck) {
      controller.disable();
    }
    return true;
  }, preferencesState));
  return {
    controller
  };
};
exports.TokenRatesControllerInit = TokenRatesControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\assets\\token-rates-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\bridge-controller-init.ts", {"../../../shared/constants/bridge":"D:\\code\\v\\metamask-extension\\shared\\constants\\bridge.ts","../../../shared/lib/fetch-with-cache":"D:\\code\\v\\metamask-extension\\shared\\lib\\fetch-with-cache.ts","../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cbridge-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BridgeControllerInit = void 0;
var _bridgeController = require("@metamask/bridge-controller");
var _controllerUtils = require("@metamask/controller-utils");
var _bridge = require("../../../shared/constants/bridge");
var _trace = require("../../../shared/lib/trace");
var _fetchWithCache = _interopRequireDefault(require("../../../shared/lib/fetch-with-cache"));
var _util = require("../lib/util");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Initialize the bridge controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.initMessenger - The messenger to use for initialization.
 * @param request.getController
 * @returns The initialized controller.
 */
const BridgeControllerInit = ({
  controllerMessenger,
  initMessenger,
  getController
}) => {
  const transactionController = getController('TransactionController');
  const controller = new _bridgeController.BridgeController({
    messenger: controllerMessenger,
    clientId: _bridgeController.BridgeClientId.EXTENSION,
    clientVersion: "13.6.0",
    // TODO: Remove once TransactionController exports this action type.
    getLayer1GasFee: (...args) => transactionController.getLayer1GasFee(...args),
    fetchFn: async (url, {
      cacheOptions,
      functionName,
      ...requestOptions
    } = {}) => {
      if (functionName === 'fetchBridgeTokens') {
        return await (0, _fetchWithCache.default)({
          url: url.toString(),
          fetchOptions: {
            method: 'GET',
            ...requestOptions
          },
          cacheOptions,
          functionName
        });
      }
      return await (0, _controllerUtils.handleFetch)(url, {
        method: 'GET',
        ...requestOptions
      });
    },
    trackMetaMetricsFn: (event, properties) => {
      const actionId = (Date.now() + Math.random()).toString();
      initMessenger.call('MetaMetricsController:trackEvent', {
        category: _bridgeController.UNIFIED_SWAP_BRIDGE_EVENT_CATEGORY,
        event,
        properties: {
          ...(properties ?? {}),
          environmentType: (0, _util.getEnvironmentType)(),
          actionId
        }
      });
    },
    // @ts-expect-error: `trace` function type does not match the expected type.
    traceFn: (...args) => (0, _trace.trace)(...args),
    config: {
      customBridgeApiBaseUrl: _bridge.BRIDGE_API_BASE_URL
    }
  });
  return {
    persistedStateKey: null,
    memStateKey: null,
    controller
  };
};
exports.BridgeControllerInit = BridgeControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\bridge-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\bridge-status-controller-init.ts", {"../../../shared/constants/bridge":"D:\\code\\v\\metamask-extension\\shared\\constants\\bridge.ts","../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","@metamask/bridge-status-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-status-controller\\dist\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cbridge-status-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BridgeStatusControllerInit = void 0;
var _bridgeStatusController = require("@metamask/bridge-status-controller");
var _controllerUtils = require("@metamask/controller-utils");
var _trace = require("../../../shared/lib/trace");
var _bridge = require("../../../shared/constants/bridge");
/**
 * Initialize the bridge status controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.getController - Function to get other initialized controllers.
 * @param request.persistedState - The persisted state for the controller.
 * @returns The initialized controller.
 */
const BridgeStatusControllerInit = ({
  controllerMessenger,
  persistedState,
  getController
}) => {
  const transactionController = getController('TransactionController');
  const controller = new _bridgeStatusController.BridgeStatusController({
    messenger: controllerMessenger,
    state: persistedState.BridgeStatusController,
    fetchFn: async (url, requestOptions) => {
      return await (0, _controllerUtils.handleFetch)(url, {
        method: 'GET',
        ...requestOptions
      });
    },
    addTransactionFn: (...args) => transactionController.addTransaction(...args),
    addTransactionBatchFn: (...args) => transactionController.addTransactionBatch(...args),
    estimateGasFeeFn: (...args) => transactionController.estimateGasFee(...args),
    updateTransactionFn: (...args) => transactionController.updateTransaction(...args),
    config: {
      customBridgeApiBaseUrl: _bridge.BRIDGE_API_BASE_URL
    },
    // @ts-expect-error: `trace` function type does not match the expected type.
    traceFn: (...args) => (0, _trace.trace)(...args)
  });
  return {
    controller
  };
};
exports.BridgeStatusControllerInit = BridgeStatusControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\bridge-status-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\confirmations\\address-book-controller-init.ts", {"@metamask/address-book-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\address-book-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cconfirmations%5Caddress-book-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddressBookControllerInit = void 0;
var _addressBookController = require("@metamask/address-book-controller");
/**
 * Initialize the address book controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @returns The initialized controller.
 */
const AddressBookControllerInit = ({
  controllerMessenger,
  persistedState
}) => {
  const controller = new _addressBookController.AddressBookController({
    messenger: controllerMessenger,
    state: persistedState.AddressBookController
  });
  return {
    controller
  };
};
exports.AddressBookControllerInit = AddressBookControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\confirmations\\address-book-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\confirmations\\approval-controller-init.ts", {"../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","@metamask/approval-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\approval-controller\\dist\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cconfirmations%5Capproval-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApprovalControllerInit = void 0;
var _approvalController = require("@metamask/approval-controller");
var _controllerUtils = require("@metamask/controller-utils");
var _app = require("../../../../shared/constants/app");
/**
 * Initialize the approval controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.showUserConfirmation
 * @returns The initialized controller.
 */
const ApprovalControllerInit = ({
  controllerMessenger,
  showUserConfirmation
}) => {
  const controller = new _approvalController.ApprovalController({
    messenger: controllerMessenger,
    showApprovalRequest: showUserConfirmation,
    typesExcludedFromRateLimiting: [_controllerUtils.ApprovalType.PersonalSign, _controllerUtils.ApprovalType.EthSignTypedData, _controllerUtils.ApprovalType.Transaction, _controllerUtils.ApprovalType.WatchAsset, _controllerUtils.ApprovalType.EthGetEncryptionPublicKey, _controllerUtils.ApprovalType.EthDecrypt,
    // Exclude Smart TX Status Page from rate limiting to allow sequential
    // transactions.
    _app.SMART_TRANSACTION_CONFIRMATION_TYPES.showSmartTransactionStatusPage]
  });
  return {
    persistedStateKey: null,
    memStateKey: null,
    controller
  };
};
exports.ApprovalControllerInit = ApprovalControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\confirmations\\approval-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\confirmations\\decrypt-message-controller-init.ts", {"../../controllers/decrypt-message":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\decrypt-message.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cconfirmations%5Cdecrypt-message-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DecryptMessageControllerInit = void 0;
var _decryptMessage = _interopRequireDefault(require("../../controllers/decrypt-message"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Initialize the decryptMessage controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.initMessenger - The messenger to use for initialization.
 * @param request.getController - Function to get other initialized controllers.
 * @param request.getUIState - Function to get the UI state.
 * @returns The initialized controller.
 */
const DecryptMessageControllerInit = ({
  controllerMessenger,
  initMessenger,
  getController,
  getUIState
}) => {
  const manager = getController('DecryptMessageManager');
  const controller = new _decryptMessage.default({
    messenger: controllerMessenger,
    manager,
    getState: getUIState,
    metricsEvent: initMessenger.call.bind(initMessenger, 'MetaMetricsController:trackEvent')
  });
  return {
    persistedStateKey: null,
    memStateKey: null,
    controller
  };
};
exports.DecryptMessageControllerInit = DecryptMessageControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\confirmations\\decrypt-message-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\confirmations\\decrypt-message-manager-init.ts", {"@metamask/message-manager":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\message-manager\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cconfirmations%5Cdecrypt-message-manager-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DecryptMessageManagerInit = void 0;
var _messageManager = require("@metamask/message-manager");
/**
 * Initialize the decrypt message manager.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @returns The initialized controller.
 */
const DecryptMessageManagerInit = ({
  controllerMessenger
}) => {
  const controller = new _messageManager.DecryptMessageManager({
    additionalFinishStatuses: ['decrypted'],
    messenger: controllerMessenger
  });
  return {
    persistedStateKey: null,
    memStateKey: null,
    controller
  };
};
exports.DecryptMessageManagerInit = DecryptMessageManagerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\confirmations\\decrypt-message-manager-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\confirmations\\encryption-public-key-controller-init.ts", {"../../controllers/encryption-public-key":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\encryption-public-key.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cconfirmations%5Cencryption-public-key-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EncryptionPublicKeyControllerInit = void 0;
var _encryptionPublicKey = _interopRequireDefault(require("../../controllers/encryption-public-key"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Initialize the encryption public key controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.initMessenger - The messenger to use for initialization.
 * @param request.getController - Function to get other initialized controllers.
 * @param request.getUIState - Function to get the UI state.
 * @returns The initialized controller.
 */
const EncryptionPublicKeyControllerInit = ({
  controllerMessenger,
  initMessenger,
  getController,
  getUIState
}) => {
  const manager = getController('EncryptionPublicKeyManager');
  const keyringController = getController('KeyringController');
  const controller = new _encryptionPublicKey.default({
    messenger: controllerMessenger,
    manager,
    getState: getUIState,
    getAccountKeyringType: account => {
      return keyringController.getAccountKeyringType(account);
    },
    getEncryptionPublicKey: address => {
      return initMessenger.call('KeyringController:getEncryptionPublicKey', address);
    },
    metricsEvent: initMessenger.call.bind(initMessenger, 'MetaMetricsController:trackEvent')
  });
  return {
    persistedStateKey: null,
    memStateKey: null,
    controller
  };
};
exports.EncryptionPublicKeyControllerInit = EncryptionPublicKeyControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\confirmations\\encryption-public-key-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\confirmations\\encryption-public-key-message-manager-init.ts", {"@metamask/message-manager":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\message-manager\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cconfirmations%5Cencryption-public-key-message-manager-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EncryptionPublicKeyManagerInit = void 0;
var _messageManager = require("@metamask/message-manager");
/**
 * Initialize the encryption public key message manager.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @returns The initialized controller.
 */
const EncryptionPublicKeyManagerInit = ({
  controllerMessenger
}) => {
  const controller = new _messageManager.EncryptionPublicKeyManager({
    additionalFinishStatuses: ['received'],
    messenger: controllerMessenger
  });
  return {
    persistedStateKey: null,
    memStateKey: null,
    controller
  };
};
exports.EncryptionPublicKeyManagerInit = EncryptionPublicKeyManagerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\confirmations\\encryption-public-key-message-manager-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\confirmations\\ens-controller-init.ts", {"@metamask/ens-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ens-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cconfirmations%5Cens-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnsControllerInit = void 0;
var _ensController = require("@metamask/ens-controller");
/**
 * Initialize the ENS controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.initMessenger - The messenger to use for initialization.
 * @returns The initialized controller.
 */
const EnsControllerInit = ({
  controllerMessenger,
  initMessenger
}) => {
  const controller = new _ensController.EnsController({
    messenger: controllerMessenger,
    onNetworkDidChange: listener => initMessenger.subscribe('NetworkController:networkDidChange', listener)
  });
  return {
    persistedStateKey: null,
    controller
  };
};
exports.EnsControllerInit = EnsControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\confirmations\\ens-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\confirmations\\gas-fee-controller-init.ts", {"../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../shared/constants/swaps":"D:\\code\\v\\metamask-extension\\shared\\constants\\swaps.ts","../init-utils":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\init-utils.ts","@metamask/gas-fee-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gas-fee-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cconfirmations%5Cgas-fee-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GasFeeControllerInit = void 0;
var _gasFeeController = require("@metamask/gas-fee-controller");
var _swaps = require("../../../../shared/constants/swaps");
var _network = require("../../../../shared/constants/network");
var _initUtils = require("../init-utils");
const GAS_API_URL = false ? _swaps.GAS_DEV_API_BASE_URL : _swaps.GAS_API_BASE_URL;

/**
 * Initialize the gas fee controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @param request.initMessenger
 * @returns The initialized controller.
 */
const GasFeeControllerInit = ({
  controllerMessenger,
  initMessenger,
  persistedState
}) => {
  const controller = new _gasFeeController.GasFeeController({
    // @ts-expect-error: `GasFeeController` does not accept a partial state.
    state: persistedState.GasFeeController,
    messenger: controllerMessenger,
    interval: 10_000,
    clientId: _swaps.SWAPS_CLIENT_ID,
    legacyAPIEndpoint: `${GAS_API_URL}/networks/<chain_id>/gasPrices`,
    EIP1559APIEndpoint: `${GAS_API_URL}/networks/<chain_id>/suggestedGasFees`,
    // @ts-expect-error: `provider` can be `undefined`, but `GasFeeController`
    // expects a defined value.
    getProvider: () => {
      const {
        provider
      } = initMessenger.call('NetworkController:getSelectedNetworkClient') ?? {};
      return provider;
    },
    onNetworkDidChange: eventHandler => {
      // TODO: The listener is never unsubscribed.
      initMessenger.subscribe('NetworkController:networkDidChange', () => {
        const state = initMessenger.call('NetworkController:getState');
        eventHandler(state);
      });
    },
    // @ts-expect-error: `NetworkController:getEIP1559Compatibility` can return
    // `undefined`, but `GasFeeController` expects a defined value.
    getCurrentNetworkEIP1559Compatibility: () => {
      return initMessenger.call('NetworkController:getEIP1559Compatibility');
    },
    getCurrentAccountEIP1559Compatibility: () => true,
    getCurrentNetworkLegacyGasAPICompatibility: () => {
      const chainId = (0, _initUtils.getGlobalChainId)(initMessenger);
      return chainId === _network.CHAIN_IDS.BSC;
    },
    getChainId: _initUtils.getGlobalChainId.bind(_initUtils.getGlobalChainId, initMessenger)
  });
  return {
    controller
  };
};
exports.GasFeeControllerInit = GasFeeControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\confirmations\\gas-fee-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\confirmations\\name-controller-init.ts", {"@metamask/name-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\name-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cconfirmations%5Cname-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NameControllerInit = void 0;
var _nameController = require("@metamask/name-controller");
/**
 * Initialize the name controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @param request.initMessenger
 * @param request.getController
 * @returns The initialized controller.
 */
const NameControllerInit = ({
  controllerMessenger,
  initMessenger,
  persistedState,
  getController
}) => {
  const ensController = getController('EnsController');
  const snapsNameProvider = getController('SnapsNameProvider');
  const isExternalNameSourcesEnabled = () => initMessenger.call('PreferencesController:getState').useExternalNameSources;
  const controller = new _nameController.NameController({
    messenger: controllerMessenger,
    state: persistedState.NameController,
    providers: [new _nameController.ENSNameProvider({
      // This uses a direct reference because `ENSController` doesn't expose
      // any actions through the messenger to do this.
      // @ts-expect-error: `ENSController` returns
      // `Promise<string | undefined>`, but `ENSNameProvider` requires
      // `Promise<string>`.
      reverseLookup: ensController.reverseResolveAddress.bind(ensController)
    }), new _nameController.EtherscanNameProvider({
      isEnabled: isExternalNameSourcesEnabled
    }), new _nameController.TokenNameProvider({
      isEnabled: isExternalNameSourcesEnabled
    }), new _nameController.LensNameProvider({
      isEnabled: isExternalNameSourcesEnabled
    }), snapsNameProvider]
  });
  return {
    controller
  };
};
exports.NameControllerInit = NameControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\confirmations\\name-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\confirmations\\ppom-controller-init.ts", {"../../lib/ppom/indexed-db-backend":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\ppom\\indexed-db-backend.ts","../../lib/ppom/ppom":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\ppom\\ppom.js","../init-utils":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\init-utils.ts","@metamask/ppom-validator":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ppom-validator\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cconfirmations%5Cppom-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPOMControllerInit = void 0;
var _ppomValidator = require("@metamask/ppom-validator");
var _indexedDbBackend = require("../../lib/ppom/indexed-db-backend");
var PPOMModule = _interopRequireWildcard(require("../../lib/ppom/ppom"));
var _initUtils = require("../init-utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PPOMControllerInit = request => {
  const {
    controllerMessenger,
    initMessenger,
    getController,
    persistedState
  } = request;
  const preferencesController = () => getController('PreferencesController');
  const {
    provider
  } = initMessenger.call('NetworkController:getSelectedNetworkClient') ?? {};
  const controller = new _ppomValidator.PPOMController({
    messenger: controllerMessenger,
    storageBackend: new _indexedDbBackend.IndexedDBPPOMStorage('PPOMDB', 1),
    // @ts-expect-error: PPOMController expects `provider` to be defined, but it
    // can be `undefined` here.
    provider,
    ppomProvider: {
      // @ts-expect-error Controller and PPOM wrapper have different argument types in `new` and `validateJsonRpc`
      PPOM: PPOMModule.PPOM,
      ppomInit: () => PPOMModule.default("./ppom_bg.wasm")
    },
    // @ts-expect-error State type is not `Partial` in controller.
    state: persistedState.PPOMController,
    chainId: (0, _initUtils.getGlobalChainId)(initMessenger),
    securityAlertsEnabled: preferencesController().state.securityAlertsEnabled,
    // @ts-expect-error `onPreferencesChange` type signature is incorrect in `PPOMController`
    onPreferencesChange: initMessenger.subscribe.bind(initMessenger, 'PreferencesController:stateChange'),
    // Both values have defaults in `builds.yml` so should always be defined.
    cdnBaseUrl: "static.cx.metamask.io/api/v1/confirmations/ppom",
    blockaidPublicKey: "066ad3e8af5583385e312c156d238055215d5f25247c1e91055afa756cb98a88"
  });
  return {
    controller
  };
};
exports.PPOMControllerInit = PPOMControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\confirmations\\ppom-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\confirmations\\signature-controller-init.ts", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","@metamask/signature-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\signature-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cconfirmations%5Csignature-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SignatureControllerInit = void 0;
var _signatureController = require("@metamask/signature-controller");
var _trace = require("../../../../shared/lib/trace");
var _metametrics = require("../../../../shared/constants/metametrics");
/**
 * Initialize the signature controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.initMessenger
 * @returns The initialized controller.
 */
const SignatureControllerInit = ({
  controllerMessenger,
  initMessenger
}) => {
  const controller = new _signatureController.SignatureController({
    messenger: controllerMessenger,
    decodingApiUrl: "https://signature-insights.api.cx.metamask.io/v1",
    isDecodeSignatureRequestEnabled: () => {
      const state = initMessenger.call('PreferencesController:getState');
      return state.useTransactionSimulations;
    },
    // @ts-expect-error: Types of `TraceRequest` are not the same.
    trace: _trace.trace
  });
  controller.hub.on('cancelWithReason', ({
    metadata: message,
    reason
  }) => {
    initMessenger.call('MetaMetricsController:trackEvent', {
      event: reason,
      category: _metametrics.MetaMetricsEventCategory.Transactions,
      properties: {
        action: 'Sign Request',
        type: message.type
      }
    });
  });
  return {
    persistedStateKey: null,
    memStateKey: null,
    controller
  };
};
exports.SignatureControllerInit = SignatureControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\confirmations\\signature-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\confirmations\\transaction-controller-init.ts", {"../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../../shared/modules/selectors":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\index.ts","../../../../shared/modules/shield":"D:\\code\\v\\metamask-extension\\shared\\modules\\shield.ts","../../lib/smart-transaction/smart-transactions":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\smart-transaction\\smart-transactions.ts","../../lib/transaction/hooks/delegation-7702-publish":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\hooks\\delegation-7702-publish.ts","../../lib/transaction/hooks/enforce-simulation-hook":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\hooks\\enforce-simulation-hook.ts","../../lib/transaction/metrics":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\metrics.ts","../../lib/transaction/sentinel-api":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\sentinel-api.ts","../../lib/transaction/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\util.ts","@metamask/smart-transactions-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\dist\\index.cjs","@metamask/subscription-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\subscription-controller\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","_process":"D:\\code\\v\\metamask-extension\\node_modules\\process\\browser.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cconfirmations%5Ctransaction-controller-init.ts
      return function (require, module, exports) {
(function (process){(function (){
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionControllerInit = void 0;
exports.publishBatchHook = publishBatchHook;
exports.publishHook = publishHook;
var _subscriptionController = require("@metamask/subscription-controller");
var _transactionController = require("@metamask/transaction-controller");
var _smartTransactionsController = require("@metamask/smart-transactions-controller");
var _trace = require("../../../../shared/lib/trace");
var _selectors = require("../../../../shared/modules/selectors");
var _shield = require("../../../../shared/modules/shield");
var _smartTransactions = require("../../lib/smart-transaction/smart-transactions");
var _delegation7702Publish = require("../../lib/transaction/hooks/delegation-7702-publish");
var _enforceSimulationHook = require("../../lib/transaction/hooks/enforce-simulation-hook");
var _metrics = require("../../lib/transaction/metrics");
var _sentinelApi = require("../../lib/transaction/sentinel-api");
var _util = require("../../lib/transaction/util");
const TransactionControllerInit = request => {
  var _process$env$METAMASK;
  const {
    controllerMessenger,
    initMessenger,
    getFlatState,
    getPermittedAccounts,
    getTransactionMetricsRequest,
    updateAccountBalanceForTransactionNetwork,
    persistedState
  } = request;
  const {
    gasFeeController,
    keyringController,
    networkController,
    onboardingController,
    preferencesController,
    smartTransactionsController
  } = getControllers(request);
  const controller = new _transactionController.TransactionController({
    getCurrentNetworkEIP1559Compatibility: () =>
    // @ts-expect-error Controller type does not support undefined return value
    initMessenger.call('NetworkController:getEIP1559Compatibility'),
    getCurrentAccountEIP1559Compatibility: async () => true,
    // @ts-expect-error Mismatched types
    getExternalPendingTransactions: address => getExternalPendingTransactions(smartTransactionsController(), address),
    getGasFeeEstimates: (...args) => gasFeeController().fetchGasFeeEstimates(...args),
    getNetworkClientRegistry: (...args) => networkController().getNetworkClientRegistry(...args),
    getNetworkState: () => networkController().state,
    // @ts-expect-error Controller type does not support undefined return value
    getPermittedAccounts,
    getSavedGasFees: chainId => {
      return preferencesController().state.advancedGasFee[chainId];
    },
    getSimulationConfig: async (url, opts) => {
      var _opts$txMeta;
      const getToken = () => initMessenger.call('AuthenticationController:getBearerToken');
      const getShieldSubscription = () => initMessenger.call('SubscriptionController:getSubscriptionByProduct', _subscriptionController.PRODUCT_TYPES.SHIELD);
      const origin = opts === null || opts === void 0 || (_opts$txMeta = opts.txMeta) === null || _opts$txMeta === void 0 ? void 0 : _opts$txMeta.origin;
      return (0, _shield.getShieldGatewayConfig)(getToken, getShieldSubscription, url, {
        origin
      });
    },
    incomingTransactions: {
      client: `extension-${(_process$env$METAMASK = process.env.METAMASK_VERSION) === null || _process$env$METAMASK === void 0 ? void 0 : _process$env$METAMASK.replace(/\./gu, '-')}`,
      includeTokenTransfers: false,
      isEnabled: () => preferencesController().state.useExternalServices && onboardingController().state.completedOnboarding,
      updateTransactions: true
    },
    isAutomaticGasFeeUpdateEnabled: ({
      type
    }) => {
      // Disables automatic gas fee updates for swap and bridge transactions
      // which provide their own gas parameters when they are submitted
      const disabledTypes = [_transactionController.TransactionType.swap, _transactionController.TransactionType.swapApproval, _transactionController.TransactionType.bridge, _transactionController.TransactionType.bridgeApproval];
      return !type || !disabledTypes.includes(type);
    },
    isEIP7702GasFeeTokensEnabled: async transactionMeta => {
      const {
        chainId
      } = transactionMeta;
      const uiState = getUIState(getFlatState());

      // @ts-expect-error Smart transaction selector types does not match controller state
      return !(0, _selectors.getIsSmartTransaction)(uiState, chainId);
    },
    isFirstTimeInteractionEnabled: () => preferencesController().state.securityAlertsEnabled,
    isSimulationEnabled: () => preferencesController().state.useTransactionSimulations,
    messenger: controllerMessenger,
    pendingTransactions: {
      isResubmitEnabled: () => false
    },
    publicKeyEIP7702: "0x3c7a1cCCe462e96D186B8ca9a1BCB2010C3dABa3",
    testGasFeeFlows: Boolean(false === 'true'),
    // @ts-expect-error Controller uses string for names rather than enum
    trace: _trace.trace,
    hooks: {
      afterSimulate: new _enforceSimulationHook.EnforceSimulationHook({
        messenger: initMessenger
      }).getAfterSimulateHook(),
      beforePublish: transactionMeta => {
        const response = initMessenger.call('InstitutionalSnapController:publishHook', transactionMeta);
        return response;
      },
      beforeSign: new _enforceSimulationHook.EnforceSimulationHook({
        messenger: initMessenger
      }).getBeforeSignHook(),
      beforeCheckPendingTransactions: transactionMeta => {
        const response = initMessenger.call('InstitutionalSnapController:beforeCheckPendingTransactionHook', transactionMeta);
        return response;
      },
      // @ts-expect-error Controller type does not support undefined return value
      publish: (transactionMeta, signedTx) => publishHook({
        flatState: getFlatState(),
        initMessenger,
        signedTx,
        smartTransactionsController: smartTransactionsController(),
        transactionController: controller,
        transactionMeta,
        isOfflineSignTransaction: request.isOfflineSignTransaction
      }),
      publishBatch: async _request => await publishBatchHook({
        transactionController: controller,
        smartTransactionsController: smartTransactionsController(),
        hookControllerMessenger: initMessenger,
        flatState: getFlatState(),
        transactions: _request.transactions
      })
    },
    // @ts-expect-error Keyring controller expects TxData returned but TransactionController expects TypedTransaction
    sign: (...args) => keyringController().signTransaction(...args),
    state: persistedState.TransactionController
  });
  addTransactionControllerListeners(initMessenger, getTransactionMetricsRequest, updateAccountBalanceForTransactionNetwork);
  const api = getApi(controller);
  return {
    controller,
    api,
    memStateKey: 'TxController'
  };
};
exports.TransactionControllerInit = TransactionControllerInit;
function getApi(controller) {
  return {
    abortTransactionSigning: controller.abortTransactionSigning.bind(controller),
    getLayer1GasFee: controller.getLayer1GasFee.bind(controller),
    getTransactions: controller.getTransactions.bind(controller),
    isAtomicBatchSupported: controller.isAtomicBatchSupported.bind(controller),
    startIncomingTransactionPolling: controller.startIncomingTransactionPolling.bind(controller),
    stopIncomingTransactionPolling: controller.stopIncomingTransactionPolling.bind(controller),
    updateAtomicBatchData: controller.updateAtomicBatchData.bind(controller),
    updateBatchTransactions: controller.updateBatchTransactions.bind(controller),
    updateEditableParams: controller.updateEditableParams.bind(controller),
    updatePreviousGasParams: controller.updatePreviousGasParams.bind(controller),
    updateSelectedGasFeeToken: controller.updateSelectedGasFeeToken.bind(controller),
    updateTransactionGasFees: controller.updateTransactionGasFees.bind(controller),
    updateTransactionSendFlowHistory: controller.updateTransactionSendFlowHistory.bind(controller)
  };
}
function getControllers(request) {
  return {
    gasFeeController: () => request.getController('GasFeeController'),
    keyringController: () => request.getController('KeyringController'),
    networkController: () => request.getController('NetworkController'),
    onboardingController: () => request.getController('OnboardingController'),
    preferencesController: () => request.getController('PreferencesController'),
    smartTransactionsController: () => request.getController('SmartTransactionsController'),
    institutionalSnapController: () => request.getController('InstitutionalSnapController')
  };
}
function getExternalPendingTransactions(smartTransactionsController, address) {
  return smartTransactionsController.getTransactions({
    addressFrom: address,
    status: _smartTransactionsController.SmartTransactionStatuses.PENDING
  });
}
function addTransactionControllerListeners(initMessenger, getTransactionMetricsRequest, updateAccountBalanceForTransactionNetwork) {
  const transactionMetricsRequest = getTransactionMetricsRequest();
  initMessenger.subscribe('TransactionController:unapprovedTransactionAdded', updateAccountBalanceForTransactionNetwork);
  initMessenger.subscribe('TransactionController:transactionConfirmed', updateAccountBalanceForTransactionNetwork);
  initMessenger.subscribe('TransactionController:postTransactionBalanceUpdated',
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  _metrics.handlePostTransactionBalanceUpdate.bind(null, transactionMetricsRequest));
  initMessenger.subscribe('TransactionController:unapprovedTransactionAdded',
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  transactionMeta => (0, _metrics.handleTransactionAdded)(transactionMetricsRequest, {
    transactionMeta
  }));
  initMessenger.subscribe('TransactionController:transactionApproved',
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  _metrics.handleTransactionApproved.bind(null, transactionMetricsRequest));
  initMessenger.subscribe('TransactionController:transactionDropped',
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  _metrics.handleTransactionDropped.bind(null, transactionMetricsRequest));
  initMessenger.subscribe('TransactionController:transactionConfirmed',
  // @ts-expect-error Error is string in metrics code but TransactionError in TransactionMeta type from controller
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  _metrics.handleTransactionConfirmed.bind(null, transactionMetricsRequest));
  initMessenger.subscribe('TransactionController:transactionFailed',
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  _metrics.handleTransactionFailed.bind(null, transactionMetricsRequest));
  initMessenger.subscribe('TransactionController:transactionNewSwap', ({
    transactionMeta
  }) =>
  // TODO: This can be called internally by the TransactionController
  // since Swaps Controller registers this action handler
  initMessenger.call('SwapsController:setTradeTxId', transactionMeta.id));
  initMessenger.subscribe('TransactionController:transactionNewSwapApproval', ({
    transactionMeta
  }) =>
  // TODO: This can be called internally by the TransactionController
  // since Swaps Controller registers this action handler
  initMessenger.call('SwapsController:setApproveTxId', transactionMeta.id));
  initMessenger.subscribe('TransactionController:transactionRejected',
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  _metrics.handleTransactionRejected.bind(null, transactionMetricsRequest));
  initMessenger.subscribe('TransactionController:transactionSubmitted',
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  _metrics.handleTransactionSubmitted.bind(null, transactionMetricsRequest));
}
function getUIState(flatState) {
  return {
    metamask: flatState
  };
}
async function publishHook({
  flatState,
  initMessenger,
  signedTx,
  smartTransactionsController,
  transactionController,
  transactionMeta,
  isOfflineSignTransaction
}) {
  // Check if this is an offline sign transaction (eth_signTransaction)
  // If so, skip broadcasting by returning a dummy hash
  // Returning undefined would cause TransactionController to broadcast with default logic
  if (isOfflineSignTransaction !== null && isOfflineSignTransaction !== void 0 && isOfflineSignTransaction(transactionMeta.id)) {
    console.log('[publishHook] ✅ Detected offline sign transaction, returning dummy hash to skip broadcast');
    // Return a dummy transaction hash to prevent default broadcast
    // The actual signed transaction is already stored in transactionMeta.rawTx
    return {
      transactionHash: '0x0000000000000000000000000000000000000000000000000000000000000000'
    };
  }
  const {
    isSmartTransaction,
    featureFlags,
    isHardwareWalletAccount
  } = (0, _smartTransactions.getSmartTransactionCommonParams)(flatState, transactionMeta.chainId);
  const sendBundleSupport = await (0, _sentinelApi.isSendBundleSupported)(transactionMeta.chainId);
  if (!isSmartTransaction || !sendBundleSupport || transactionMeta.isGasFeeSponsored) {
    const hook = new _delegation7702Publish.Delegation7702PublishHook({
      isAtomicBatchSupported: transactionController.isAtomicBatchSupported.bind(transactionController),
      messenger: initMessenger
    }).getHook();
    const result = await hook(transactionMeta, signedTx);
    if (result !== null && result !== void 0 && result.transactionHash) {
      return result;
    }
    // else, fall back to regular regular transaction submission
  }
  if (isSmartTransaction && (sendBundleSupport || transactionMeta.selectedGasFeeToken === undefined)) {
    const result = await (0, _smartTransactions.submitSmartTransactionHook)({
      transactionMeta,
      signedTransactionInHex: signedTx,
      transactionController,
      smartTransactionsController,
      controllerMessenger: initMessenger,
      isSmartTransaction,
      isHardwareWallet: isHardwareWalletAccount,
      // @ts-expect-error Smart transaction selector return type does not match FeatureFlags type from hook
      featureFlags
    });
    if (result !== null && result !== void 0 && result.transactionHash) {
      return result;
    }
    // else, fall back to regular regular transaction submission
  }

  // Default: fall back to regular transaction submission
  return {
    transactionHash: undefined
  };
}
function publishBatchHook({
  transactionController,
  smartTransactionsController,
  hookControllerMessenger,
  flatState,
  transactions
}) {
  // Get transactionMeta based on the last transaction ID
  const lastTransaction = transactions[transactions.length - 1];
  const transactionMeta = (0, _util.getTransactionById)(lastTransaction.id ?? '', transactionController);

  // If we couldn't find the transaction, we should handle that gracefully
  if (!transactionMeta) {
    throw new Error(`publishBatchSmartTransactionHook: Could not find transaction with id ${lastTransaction.id}`);
  }
  const {
    isSmartTransaction,
    featureFlags,
    isHardwareWalletAccount
  } = (0, _smartTransactions.getSmartTransactionCommonParams)(flatState, transactionMeta.chainId);
  if (!isSmartTransaction) {
    return undefined;
  }
  return (0, _smartTransactions.submitBatchSmartTransactionHook)({
    transactions,
    transactionController,
    smartTransactionsController,
    controllerMessenger: hookControllerMessenger,
    isSmartTransaction,
    isHardwareWallet: isHardwareWalletAccount,
    // @ts-expect-error Smart transaction selector return type does not match FeatureFlags type from hook
    featureFlags,
    transactionMeta
  });
}

}).call(this)}).call(this,require('_process'))

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\confirmations\\transaction-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\confirmations\\user-operation-controller-init.ts", {"@metamask/user-operation-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cconfirmations%5Cuser-operation-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserOperationControllerInit = void 0;
var _userOperationController = require("@metamask/user-operation-controller");
/**
 * Initialize the user operation controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state.
 * @param request.getController - Function to get other controllers.
 * @returns The initialized controller.
 */
const UserOperationControllerInit = ({
  controllerMessenger,
  persistedState,
  getController
}) => {
  const gasFeeController = getController('GasFeeController');
  const controller = new _userOperationController.UserOperationController({
    messenger: controllerMessenger,
    state: persistedState.UserOperationController,
    // @ts-expect-error: `UserOperationController` does not accept `undefined`.
    entrypoint: null,
    getGasFeeEstimates: (...args) => gasFeeController.fetchGasFeeEstimates(...args)
  });
  return {
    controller
  };
};
exports.UserOperationControllerInit = UserOperationControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\confirmations\\user-operation-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\core-backend\\account-activity-service-init.ts", {"../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","@metamask/core-backend":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\core-backend\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Ccore-backend%5Caccount-activity-service-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountActivityServiceInit = void 0;
var _coreBackend = require("@metamask/core-backend");
var _trace = require("../../../../shared/lib/trace");
/**
 * Initialize the Account Activity service.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the service.
 * @returns The initialized service.
 */
const AccountActivityServiceInit = ({
  controllerMessenger
}) => {
  const controller = new _coreBackend.AccountActivityService({
    messenger: controllerMessenger,
    // @ts-expect-error: Types of `TraceRequest` are not the same.
    traceFn: _trace.trace
  });
  return {
    memStateKey: null,
    persistedStateKey: null,
    controller
  };
};
exports.AccountActivityServiceInit = AccountActivityServiceInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\core-backend\\account-activity-service-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\core-backend\\backend-websocket-service-init.ts", {"../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","@metamask/core-backend":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\core-backend\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Ccore-backend%5Cbackend-websocket-service-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BackendWebSocketServiceInit = void 0;
var _coreBackend = require("@metamask/core-backend");
var _trace = require("../../../../shared/lib/trace");
/**
 * Initialize the Backend Platform WebSocket service with authentication support.
 * This provides WebSocket connectivity for backend platform services
 * like AccountActivityService and other platform-level integrations.
 *
 * Authentication Flow (simplified with AuthenticationController):
 * 1. Core WebSocketService: Controls WHETHER connections are allowed (AuthenticationController.isSignedIn = yes)
 * 2. Browser/Extension lifecycle: Controls WHEN to connect/disconnect (close = disconnect, open = connect)
 * 3. AuthenticationController.isSignedIn includes BOTH wallet unlock + identity provider authentication
 * 4. Fresh bearer tokens retrieved on each connection attempt (getBearerToken checks wallet unlock internally)
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the service.
 * @param request.initMessenger - The messenger for accessing other controllers.
 * @returns The initialized service.
 */
const BackendWebSocketServiceInit = ({
  controllerMessenger,
  initMessenger
}) => {
  const controller = new _coreBackend.BackendWebSocketService({
    messenger: controllerMessenger,
    url: "wss://gateway.api.cx.metamask.io/v1" || 'wss://gateway.api.cx.metamask.io/v1',
    // Backend Platform optimized configuration
    timeout: 15000,
    // Longer timeout for backend operations
    reconnectDelay: 1000,
    // Conservative reconnect strategy
    maxReconnectDelay: 30000,
    // Allow longer delays for backend stability
    requestTimeout: 20000,
    // Reasonable timeout for backend requests
    // Inject the Sentry-backed trace function from extension platform
    // @ts-expect-error: Types of `TraceRequest` are not the same.
    traceFn: _trace.trace,
    // Feature flag AND app lifecycle integration
    // Service will check this callback before connecting/reconnecting
    isEnabled: () => {
      try {
        const remoteFeatureFlagState = initMessenger === null || initMessenger === void 0 ? void 0 : initMessenger.call('RemoteFeatureFlagController:getState');
        const {
          backendWebSocketConnection
        } = (remoteFeatureFlagState === null || remoteFeatureFlagState === void 0 ? void 0 : remoteFeatureFlagState.remoteFeatureFlags) || {};
        const result = backendWebSocketConnection && typeof backendWebSocketConnection === 'object' && 'value' in backendWebSocketConnection && Boolean(backendWebSocketConnection.value);
        return Boolean(result);
      } catch (error) {
        // If feature flag check fails, default to NOT connecting for safer startup
        console.warn('[BackendWebSocketService] Could not check feature flag, defaulting to NOT connect:', error);
        return false;
      }
    }
  });

  // Authentication and lock/unlock handling is now managed by the core WebSocket service
  // Core service will automatically connect when wallet is unlocked (no manual connect() needed)

  return {
    memStateKey: null,
    persistedStateKey: null,
    controller
  };
};
exports.BackendWebSocketServiceInit = BackendWebSocketServiceInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\core-backend\\backend-websocket-service-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\core-backend\\index.ts", {"./account-activity-service-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\core-backend\\account-activity-service-init.ts","./backend-websocket-service-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\core-backend\\backend-websocket-service-init.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Ccore-backend%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AccountActivityServiceInit", {
  enumerable: true,
  get: function () {
    return _accountActivityServiceInit.AccountActivityServiceInit;
  }
});
Object.defineProperty(exports, "BackendWebSocketServiceInit", {
  enumerable: true,
  get: function () {
    return _backendWebsocketServiceInit.BackendWebSocketServiceInit;
  }
});
var _backendWebsocketServiceInit = require("./backend-websocket-service-init");
var _accountActivityServiceInit = require("./account-activity-service-init");

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\core-backend\\index.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\currency-rate-controller-init.ts", {"@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Ccurrency-rate-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurrencyRateControllerInit = void 0;
var _assetsControllers = require("@metamask/assets-controllers");
/**
 * Initialize the currency rate controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @param request.initMessenger
 * @returns The initialized controller.
 */
const CurrencyRateControllerInit = ({
  controllerMessenger,
  initMessenger,
  persistedState
}) => {
  const controller = new _assetsControllers.CurrencyRateController({
    // @ts-expect-error: `CurrencyRateController` is persisted as
    // `CurrencyController`, but the controller init pattern doesn't
    // allow this in the type of `persistedState`.
    state: persistedState.CurrencyController,
    messenger: controllerMessenger,
    includeUsdRate: true,
    useExternalServices: () => initMessenger.call('PreferencesController:getState').useExternalServices
  });

  // TODO: This logic should be ported to `CurrencyRateController` directly.
  const originalFetchMultiExchangeRate =
  // @ts-expect-error: Accessing private method.
  controller.fetchMultiExchangeRate.bind(controller);

  // @ts-expect-error: Accessing private method.
  controller.fetchMultiExchangeRate = (...args) => {
    const {
      useCurrencyRateCheck
    } = initMessenger.call('PreferencesController:getState');
    if (useCurrencyRateCheck) {
      return originalFetchMultiExchangeRate(...args);
    }
    return {
      conversionRate: null,
      usdConversionRate: null
    };
  };
  return {
    memStateKey: 'CurrencyController',
    persistedStateKey: 'CurrencyController',
    controller
  };
};
exports.CurrencyRateControllerInit = CurrencyRateControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\currency-rate-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\defi-positions\\defi-positions-controller-init.ts", {"@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cdefi-positions%5Cdefi-positions-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeFiPositionsControllerInit = void 0;
var _assetsControllers = require("@metamask/assets-controllers");
const DeFiPositionsControllerInit = ({
  initMessenger,
  controllerMessenger,
  getController
}) => {
  const getPreferencesController = () => getController('PreferencesController');
  const controller = new _assetsControllers.DeFiPositionsController({
    messenger: controllerMessenger,
    isEnabled: () => {
      var _state$remoteFeatureF;
      const preferencesController = getPreferencesController();
      const {
        useExternalServices
      } = preferencesController.state;
      const state = initMessenger.call('RemoteFeatureFlagController:getState');
      const featureFlagForDeFi = Boolean(state === null || state === void 0 || (_state$remoteFeatureF = state.remoteFeatureFlags) === null || _state$remoteFeatureF === void 0 ? void 0 : _state$remoteFeatureF.assetsDefiPositionsEnabled);
      return useExternalServices && featureFlagForDeFi;
    },
    trackEvent: initMessenger.call.bind(initMessenger, 'MetaMetricsController:trackEvent')
  });
  return {
    controller
  };
};
exports.DeFiPositionsControllerInit = DeFiPositionsControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\defi-positions\\defi-positions-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\delegation\\delegation-controller-init.ts", {"../../../../shared/lib/delegation":"D:\\code\\v\\metamask-extension\\shared\\lib\\delegation\\index.ts","@metamask/delegation-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\delegation-controller\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cdelegation%5Cdelegation-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DelegationControllerInit = void 0;
exports.awaitDeleteDelegationEntry = awaitDeleteDelegationEntry;
var _delegationController = require("@metamask/delegation-controller");
var _transactionController = require("@metamask/transaction-controller");
var _delegation = require("../../../../shared/lib/delegation");
const getDelegationEnvironment = chainId => {
  return (0, _delegation.getDeleGatorEnvironment)(Number(chainId));
};

/**
 * Initialize the Delegation controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @param request.initMessenger - The initialization messenger for the controller.
 * @returns The initialized controller.
 */
const DelegationControllerInit = ({
  controllerMessenger,
  persistedState,
  initMessenger
}) => {
  const controller = new _delegationController.DelegationController({
    messenger: controllerMessenger,
    state: persistedState.DelegationController,
    hashDelegation: _delegation.getDelegationHashOffchain,
    getDelegationEnvironment
  });
  controllerMessenger.registerActionHandler('DelegationController:signDelegation', controller.signDelegation.bind(controller));
  return {
    controller,
    api: {
      signDelegation: controller.signDelegation.bind(controller),
      storeDelegationEntry: controller.store.bind(controller),
      listDelegationEntries: controller.list.bind(controller),
      getDelegationEntry: controller.retrieve.bind(controller),
      getDelegationEntryChain: controller.chain.bind(controller),
      deleteDelegationEntry: controller.delete.bind(controller),
      awaitDeleteDelegationEntry: awaitDeleteDelegationEntry.bind(null, controller, initMessenger)
    }
  };
};

/**
 * Awaits for the transaction with txMeta to be confirmed, then
 * deletes the delegation entry with `hash`.
 *
 * @param controller - The DelegationController.
 * @param initMessenger - The initialization messenger for the controller.
 * @param options
 * @param options.hash - The hash of the delegation entry to delete.
 * @param options.txMeta - The transaction meta of the transaction that confirmed the delegation entry.
 * @param options.entryToStore - The delegation entry to store.
 */
exports.DelegationControllerInit = DelegationControllerInit;
async function awaitDeleteDelegationEntry(controller, initMessenger, {
  hash,
  txMeta,
  entryToStore
}) {
  let {
    id
  } = txMeta;
  let action = 'continue';
  const handleTransactionStatusUpdated = ({
    transactionMeta
  }) => {
    // If not our transaction, ignore
    if (transactionMeta.id !== id) {
      return;
    }

    // Check if transaction was replaced
    if (transactionMeta.status === _transactionController.TransactionStatus.dropped && transactionMeta.replacedById) {
      id = transactionMeta.replacedById;
      return;
    }
    switch (transactionMeta.type) {
      case _transactionController.TransactionType.contractInteraction:
      case _transactionController.TransactionType.retry:
        switch (transactionMeta.status) {
          case _transactionController.TransactionStatus.confirmed:
            action = 'delete';
            break;
          case _transactionController.TransactionStatus.dropped:
          case _transactionController.TransactionStatus.failed:
          case _transactionController.TransactionStatus.rejected:
            action = 'unsubscribe';
            break;
          default:
            // Ignore other statuses
            return;
        }
        break;
      case _transactionController.TransactionType.cancel:
        action = 'unsubscribe';
        break;
      default:
        console.warn('awaitDeleteDelegationEntry: Unexpected tx type', transactionMeta.type);
        return;
    }
    if (action === 'delete') {
      controller.delete(hash);
      if (entryToStore) {
        controller.store({
          entry: entryToStore
        });
      }
    }
    if (action === 'unsubscribe' || action === 'delete') {
      initMessenger.unsubscribe('TransactionController:transactionStatusUpdated', handleTransactionStatusUpdated);
    }
  };
  initMessenger.subscribe('TransactionController:transactionStatusUpdated', handleTransactionStatusUpdated);
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\delegation\\delegation-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\error-reporting-service-init.ts", {"../../../shared/lib/sentry":"D:\\code\\v\\metamask-extension\\shared\\lib\\sentry.ts","@metamask/error-reporting-service":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\error-reporting-service\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cerror-reporting-service-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorReportingServiceInit = void 0;
var _errorReportingService = require("@metamask/error-reporting-service");
var _sentry = require("../../../shared/lib/sentry");
/**
 * Initialize the error reporting service.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the service.
 * @returns The initialized controller.
 */
const ErrorReportingServiceInit = ({
  controllerMessenger
}) => {
  const controller = new _errorReportingService.ErrorReportingService({
    messenger: controllerMessenger,
    captureException: _sentry.captureException
  });
  return {
    persistedStateKey: null,
    memStateKey: null,
    controller
  };
};
exports.ErrorReportingServiceInit = ErrorReportingServiceInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\error-reporting-service-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\gator-permissions\\gator-permissions-controller-init.ts", {"../../../../shared/modules/environment":"D:\\code\\v\\metamask-extension\\shared\\modules\\environment.ts","@metamask/gator-permissions-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cgator-permissions%5Cgator-permissions-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GatorPermissionsControllerInit = void 0;
var _gatorPermissionsController = require("@metamask/gator-permissions-controller");
var _snapsUtils = require("@metamask/snaps-utils");
var _environment = require("../../../../shared/modules/environment");
const generateDefaultGatorPermissionsControllerState = () => {
  const gatorPermissionsProviderSnapId = "npm:@metamask/gator-permissions-snap";

  // if GATOR_PERMISSIONS_PROVIDER_SNAP_ID is not specified, GatorPermissionsController will initialize it's default
  if (gatorPermissionsProviderSnapId !== undefined) {
    try {
      (0, _snapsUtils.assertIsValidSnapId)(gatorPermissionsProviderSnapId);
    } catch (error) {
      throw new Error('GATOR_PERMISSIONS_PROVIDER_SNAP_ID must be set to a valid snap id', {
        cause: error
      });
    }
  }
  const isGatorPermissionsEnabled = (0, _environment.isGatorPermissionsFeatureEnabled)();
  const state = {
    isGatorPermissionsEnabled
  };
  if (gatorPermissionsProviderSnapId) {
    state.gatorPermissionsProviderSnapId = gatorPermissionsProviderSnapId;
  }
  return state;
};
const GatorPermissionsControllerInit = ({
  controllerMessenger,
  persistedState
}) => {
  const controller = new _gatorPermissionsController.GatorPermissionsController({
    // Type mismatch due to different BaseController versions, GatorPermissionsController uses 8.3.0 while extension uses 8.2.0.
    // We can remove once extension BaseController version is updated to 8.3.0.
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    messenger: controllerMessenger,
    state: {
      ...generateDefaultGatorPermissionsControllerState(),
      ...persistedState.GatorPermissionsController
    }
  });
  return {
    controller,
    api: {
      fetchAndUpdateGatorPermissions: controller.fetchAndUpdateGatorPermissions.bind(controller)
    }
  };
};
exports.GatorPermissionsControllerInit = GatorPermissionsControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\gator-permissions\\gator-permissions-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\identity\\authentication-controller-init.ts", {"@metamask/profile-sync-controller/auth":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\profile-sync-controller\\dist\\controllers\\authentication\\index.cjs","@metamask/profile-sync-controller/sdk":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\profile-sync-controller\\dist\\sdk\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cidentity%5Cauthentication-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthenticationControllerInit = void 0;
var _auth = require("@metamask/profile-sync-controller/auth");
var _sdk = require("@metamask/profile-sync-controller/sdk");
/**
 * Initialize the Authentication controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @param request.initMessenger - The messenger to use for initialization.
 * @returns The initialized controller.
 */
const AuthenticationControllerInit = ({
  controllerMessenger,
  initMessenger,
  persistedState
}) => {
  const controller = new _auth.Controller({
    messenger: controllerMessenger,
    state: persistedState.AuthenticationController,
    metametrics: {
      getMetaMetricsId: initMessenger.call.bind(initMessenger, 'MetaMetricsController:getMetaMetricsId'),
      agent: _sdk.Platform.EXTENSION
    }
  });
  return {
    controller
  };
};
exports.AuthenticationControllerInit = AuthenticationControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\identity\\authentication-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\identity\\user-storage-controller-init.ts", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/lib/sentry":"D:\\code\\v\\metamask-extension\\shared\\lib\\sentry.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","@metamask/profile-sync-controller/user-storage":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\profile-sync-controller\\dist\\controllers\\user-storage\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cidentity%5Cuser-storage-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserStorageControllerInit = void 0;
var _userStorage = require("@metamask/profile-sync-controller/user-storage");
var _metametrics = require("../../../../shared/constants/metametrics");
var _trace = require("../../../../shared/lib/trace");
var _sentry = require("../../../../shared/lib/sentry");
/**
 * Initialize the UserStorage controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @returns The initialized controller.
 */
const UserStorageControllerInit = request => {
  const {
    controllerMessenger,
    initMessenger,
    persistedState
  } = request;
  const controller = new _userStorage.Controller({
    messenger: controllerMessenger,
    state: persistedState.UserStorageController,
    // @ts-expect-error Controller uses string for names rather than enum
    trace: _trace.trace,
    config: {
      contactSyncing: {
        onContactUpdated: profileId => {
          initMessenger.call('MetaMetricsController:trackEvent', {
            category: _metametrics.MetaMetricsEventCategory.BackupAndSync,
            event: _metametrics.MetaMetricsEventName.ProfileActivityUpdated,
            properties: {
              // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
              // eslint-disable-next-line @typescript-eslint/naming-convention
              profile_id: profileId,
              // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
              // eslint-disable-next-line @typescript-eslint/naming-convention
              feature_name: 'Backup And Sync',
              action: 'Contacts Sync Contact Updated'
            }
          });
        },
        onContactDeleted: profileId => {
          initMessenger.call('MetaMetricsController:trackEvent', {
            category: _metametrics.MetaMetricsEventCategory.BackupAndSync,
            event: _metametrics.MetaMetricsEventName.ProfileActivityUpdated,
            properties: {
              // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
              // eslint-disable-next-line @typescript-eslint/naming-convention
              profile_id: profileId,
              // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
              // eslint-disable-next-line @typescript-eslint/naming-convention
              feature_name: 'Backup And Sync',
              action: 'Contacts Sync Contact Deleted'
            }
          });
        },
        onContactSyncErroneousSituation: (profileId, situationMessage, sentryContext) => {
          (0, _sentry.captureException)(new Error(`Contact sync - ${situationMessage}`), sentryContext);
          initMessenger.call('MetaMetricsController:trackEvent', {
            category: _metametrics.MetaMetricsEventCategory.BackupAndSync,
            event: _metametrics.MetaMetricsEventName.ProfileActivityUpdated,
            properties: {
              // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
              // eslint-disable-next-line @typescript-eslint/naming-convention
              profile_id: profileId,
              // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
              // eslint-disable-next-line @typescript-eslint/naming-convention
              feature_name: 'Backup And Sync',
              action: 'Contacts Sync Erroneous Situation',
              // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
              // eslint-disable-next-line @typescript-eslint/naming-convention
              additional_description: situationMessage
            }
          });
        }
      }
    }
  });
  return {
    controller
  };
};
exports.UserStorageControllerInit = UserStorageControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\identity\\user-storage-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\init-utils.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cinit-utils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGlobalChainId = getGlobalChainId;
/**
 * Get the global chain ID from the network controller's state.
 *
 * This is extracted from the `MetaMaskController` to be reused in controller
 * initialization functions.
 *
 * @param initMessenger - The messenger to use to call the network controller.
 * This messenger must be permitted to call `NetworkController:getState` and
 * `NetworkController:getNetworkClientById`.
 * @returns The global chain ID.
 * @deprecated Avoid using this function in new code. Instead, call the network
 * controller directly from within your controller.
 */
function getGlobalChainId(initMessenger) {
  const networkState = initMessenger.call('NetworkController:getState');
  const networkClientId = networkState.selectedNetworkClientId;
  const {
    chainId
  } = initMessenger.call('NetworkController:getNetworkClientById', networkClientId).configuration;
  return chainId;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\init-utils.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\institutional-snap\\institutional-snap-controller-init.ts", {"../../controllers/institutional-snap/InstitutionalSnapController":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\institutional-snap\\InstitutionalSnapController.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cinstitutional-snap%5Cinstitutional-snap-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstitutionalSnapControllerInit = void 0;
var _InstitutionalSnapController = require("../../controllers/institutional-snap/InstitutionalSnapController");
const InstitutionalSnapControllerInit = request => {
  const controller = new _InstitutionalSnapController.InstitutionalSnapController({
    messenger: request.controllerMessenger
  });
  return {
    controller
  };
};
exports.InstitutionalSnapControllerInit = InstitutionalSnapControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\institutional-snap\\institutional-snap-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\keyring-controller-init.ts", {"../../../shared/modules/mv3.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\mv3.utils.js","../lib/encryptor-factory":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\encryptor-factory.ts","../lib/hardware-keyring-builder-factory":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\hardware-keyring-builder-factory.ts","../lib/offscreen-bridge/lattice-offscreen-keyring":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\offscreen-bridge\\lattice-offscreen-keyring.ts","../lib/offscreen-bridge/ledger-offscreen-bridge":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\offscreen-bridge\\ledger-offscreen-bridge.ts","../lib/offscreen-bridge/trezor-offscreen-bridge":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\offscreen-bridge\\trezor-offscreen-bridge.ts","../lib/qr-keyring-builder-factory":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\qr-keyring-builder-factory.ts","@metamask/eth-ledger-bridge-keyring":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\index.cjs","@metamask/eth-qr-keyring":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-qr-keyring\\dist\\index.cjs","@metamask/eth-trezor-keyring":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-trezor-keyring\\dist\\index.cjs","@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs","eth-lattice-keyring":"D:\\code\\v\\metamask-extension\\node_modules\\eth-lattice-keyring\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Ckeyring-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KeyringControllerInit = void 0;
var _keyringController = require("@metamask/keyring-controller");
var _ethQrKeyring = require("@metamask/eth-qr-keyring");
var _ethLatticeKeyring = _interopRequireDefault(require("eth-lattice-keyring"));
var _ethTrezorKeyring = require("@metamask/eth-trezor-keyring");
var _ethLedgerBridgeKeyring = require("@metamask/eth-ledger-bridge-keyring");
var _hardwareKeyringBuilderFactory = require("../lib/hardware-keyring-builder-factory");
var _mv = require("../../../shared/modules/mv3.utils");
var _qrKeyringBuilderFactory = require("../lib/qr-keyring-builder-factory");
var _encryptorFactory = require("../lib/encryptor-factory");
var _trezorOffscreenBridge = require("../lib/offscreen-bridge/trezor-offscreen-bridge");
var _ledgerOffscreenBridge = require("../lib/offscreen-bridge/ledger-offscreen-bridge");
var _latticeOffscreenKeyring = require("../lib/offscreen-bridge/lattice-offscreen-keyring");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Initialize the keyring controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state to use for the
 * controller.
 * @param request.initMessenger - The messenger to use for initialization
 * actions.
 * @param request.keyringOverrides - Optional overrides for keyring classes and
 * bridges.
 * @param request.encryptor - Optional encryptor to use for the controller.
 * @param request.getController - Function to get other controllers.
 * @returns The initialized controller.
 */
const KeyringControllerInit = ({
  controllerMessenger,
  persistedState,
  initMessenger,
  keyringOverrides,
  encryptor,
  getController
}) => {
  const additionalKeyrings = [(0, _qrKeyringBuilderFactory.qrKeyringBuilderFactory)((keyringOverrides === null || keyringOverrides === void 0 ? void 0 : keyringOverrides.qr) || _ethQrKeyring.QrKeyring, (keyringOverrides === null || keyringOverrides === void 0 ? void 0 : keyringOverrides.qrBridge) || _ethQrKeyring.QrKeyringScannerBridge, {
    requestScan: async request => initMessenger.call('AppStateController:requestQrCodeScan', request)
  })];
  if (_mv.isManifestV3 === false) {
    additionalKeyrings.push((0, _keyringController.keyringBuilderFactory)((keyringOverrides === null || keyringOverrides === void 0 ? void 0 : keyringOverrides.lattice) || _ethLatticeKeyring.default), (0, _hardwareKeyringBuilderFactory.hardwareKeyringBuilderFactory)(_ethTrezorKeyring.TrezorKeyring, (keyringOverrides === null || keyringOverrides === void 0 ? void 0 : keyringOverrides.trezorBridge) || _ethTrezorKeyring.TrezorConnectBridge), (0, _hardwareKeyringBuilderFactory.hardwareKeyringBuilderFactory)(_ethTrezorKeyring.OneKeyKeyring, (keyringOverrides === null || keyringOverrides === void 0 ? void 0 : keyringOverrides.oneKey) || _ethTrezorKeyring.TrezorConnectBridge), (0, _hardwareKeyringBuilderFactory.hardwareKeyringBuilderFactory)(_ethLedgerBridgeKeyring.LedgerKeyring, (keyringOverrides === null || keyringOverrides === void 0 ? void 0 : keyringOverrides.ledgerBridge) || _ethLedgerBridgeKeyring.LedgerIframeBridge));
  } else {
    additionalKeyrings.push((0, _hardwareKeyringBuilderFactory.hardwareKeyringBuilderFactory)(_ethTrezorKeyring.TrezorKeyring, (keyringOverrides === null || keyringOverrides === void 0 ? void 0 : keyringOverrides.trezorBridge) || _trezorOffscreenBridge.TrezorOffscreenBridge), (0, _hardwareKeyringBuilderFactory.hardwareKeyringBuilderFactory)(_ethTrezorKeyring.OneKeyKeyring, (keyringOverrides === null || keyringOverrides === void 0 ? void 0 : keyringOverrides.oneKey) || _trezorOffscreenBridge.TrezorOffscreenBridge), (0, _hardwareKeyringBuilderFactory.hardwareKeyringBuilderFactory)(_ethLedgerBridgeKeyring.LedgerKeyring, (keyringOverrides === null || keyringOverrides === void 0 ? void 0 : keyringOverrides.ledgerBridge) || _ledgerOffscreenBridge.LedgerOffscreenBridge), (0, _keyringController.keyringBuilderFactory)(_latticeOffscreenKeyring.LatticeKeyringOffscreen));
  }

  ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
  const snapKeyringBuilder = getController('SnapKeyringBuilder');

  // @ts-expect-error: `addAccounts` is missing in `SnapKeyring` type.
  additionalKeyrings.push(snapKeyringBuilder);
  ///: END:ONLY_INCLUDE_IF

  // @ts-expect-error: The types for the encryptor are not correct.
  const controller = new _keyringController.KeyringController({
    state: persistedState.KeyringController,
    messenger: controllerMessenger,
    cacheEncryptionKey: true,
    keyringBuilders: additionalKeyrings,
    encryptor: encryptor || (0, _encryptorFactory.encryptorFactory)(600_000)
  });
  return {
    controller
  };
};
exports.KeyringControllerInit = KeyringControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\keyring-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\logging-controller-init.ts", {"../../../shared/constants/logs":"D:\\code\\v\\metamask-extension\\shared\\constants\\logs.ts","@metamask/logging-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\logging-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Clogging-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoggingControllerInit = void 0;
var _loggingController = require("@metamask/logging-controller");
var _logs = require("../../../shared/constants/logs");
/**
 * Initialize the logging controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state to use for the
 * controller.
 * @param request.extension
 * @returns The initialized controller.
 */
const LoggingControllerInit = ({
  controllerMessenger,
  persistedState,
  extension
}) => {
  const controller = new _loggingController.LoggingController({
    messenger: controllerMessenger,
    state: persistedState.LoggingController
  });
  extension.runtime.onInstalled.addListener(details => {
    if (details.reason === 'update') {
      controller.add({
        type: _loggingController.LogType.GenericLog,
        data: {
          event: _logs.LOG_EVENT.VERSION_UPDATE,
          previousVersion: details.previousVersion,
          version: "13.6.0"
        }
      });
    }
  });
  return {
    controller
  };
};
exports.LoggingControllerInit = LoggingControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\logging-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\account-order-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Caccount-order-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAccountOrderControllerMessenger = getAccountOrderControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * account order controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getAccountOrderControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'AccountOrderController',
    // This controller does not call any actions or subscribe to any events.
    allowedActions: [],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\account-order-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\account-tracker-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Caccount-tracker-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAccountTrackerControllerInitMessenger = getAccountTrackerControllerInitMessenger;
exports.getAccountTrackerControllerMessenger = getAccountTrackerControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * account tracker controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getAccountTrackerControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'AccountTrackerController',
    allowedActions: ['AccountsController:getSelectedAccount', 'NetworkController:getState', 'NetworkController:getNetworkClientById', 'OnboardingController:getState', 'PreferencesController:getState', 'RemoteFeatureFlagController:getState'],
    allowedEvents: ['AccountsController:selectedEvmAccountChange', 'OnboardingController:stateChange', 'KeyringController:accountRemoved']
  });
}
/**
 * Create a messenger restricted to the allowed actions and events needed to
 * initialize the account tracker controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getAccountTrackerControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'AccountTrackerControllerInit',
    allowedActions: ['NetworkController:getSelectedNetworkClient', 'NetworkController:getState', 'RemoteFeatureFlagController:getState', 'PreferencesController:getState'],
    allowedEvents: ['NetworkController:networkDidChange']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\account-tracker-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\accounts-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Caccounts-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAccountsControllerMessenger = getAccountsControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * accounts controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getAccountsControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'AccountsController',
    allowedActions: ['KeyringController:getState', 'KeyringController:getKeyringsByType'],
    allowedEvents: ['SnapController:stateChange', 'KeyringController:stateChange', 'SnapKeyring:accountAssetListUpdated', 'SnapKeyring:accountBalancesUpdated', 'SnapKeyring:accountTransactionsUpdated', 'MultichainNetworkController:networkDidChange']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\accounts-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\accounts\\account-tree-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Caccounts%5Caccount-tree-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAccountTreeControllerInitMessenger = getAccountTreeControllerInitMessenger;
exports.getAccountTreeControllerMessenger = getAccountTreeControllerMessenger;
/**
 * Get a restricted messenger for the account tree controller. This is scoped to the
 * actions and events that this controller is allowed to handle.
 *
 * @param messenger - The controller messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getAccountTreeControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'AccountTreeController',
    allowedEvents: ['AccountsController:accountAdded', 'AccountsController:accountRemoved', 'AccountsController:selectedAccountChange', 'UserStorageController:stateChange', 'MultichainAccountService:walletStatusChange'],
    allowedActions: ['AccountsController:listMultichainAccounts', 'AccountsController:getAccount', 'AccountsController:getSelectedMultichainAccount', 'AccountsController:setSelectedAccount', 'UserStorageController:getState', 'UserStorageController:performGetStorage', 'UserStorageController:performGetStorageAllFeatureEntries', 'UserStorageController:performSetStorage', 'UserStorageController:performBatchSetStorage', 'AuthenticationController:getSessionProfile', 'MultichainAccountService:createMultichainAccountGroup', 'SnapController:get', 'KeyringController:getState']
  });
}
/**
 * Get a restricted messenger for the account tree controller. This is scoped to the
 * actions and events that this controller is allowed to handle.
 *
 * @param messenger - The controller messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getAccountTreeControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'AccountTreeControllerInit',
    allowedActions: ['MetaMetricsController:trackEvent', 'AccountsController:getAccount', 'AccountOrderController:getState'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\accounts\\account-tree-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\accounts\\index.ts", {"./account-tree-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\accounts\\account-tree-controller-messenger.ts","./institutional-snap-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\accounts\\institutional-snap-controller-messenger.ts","./multichain-account-service-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\accounts\\multichain-account-service-messenger.ts","./snap-keyring-builder-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\accounts\\snap-keyring-builder-messenger.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Caccounts%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "getAccountTreeControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _accountTreeControllerMessenger.getAccountTreeControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getAccountTreeControllerMessenger", {
  enumerable: true,
  get: function () {
    return _accountTreeControllerMessenger.getAccountTreeControllerMessenger;
  }
});
Object.defineProperty(exports, "getInstitutionalSnapControllerMessenger", {
  enumerable: true,
  get: function () {
    return _institutionalSnapControllerMessenger.getInstitutionalSnapControllerMessenger;
  }
});
Object.defineProperty(exports, "getMultichainAccountServiceInitMessenger", {
  enumerable: true,
  get: function () {
    return _multichainAccountServiceMessenger.getMultichainAccountServiceInitMessenger;
  }
});
Object.defineProperty(exports, "getMultichainAccountServiceMessenger", {
  enumerable: true,
  get: function () {
    return _multichainAccountServiceMessenger.getMultichainAccountServiceMessenger;
  }
});
Object.defineProperty(exports, "getSnapKeyringBuilderInitMessenger", {
  enumerable: true,
  get: function () {
    return _snapKeyringBuilderMessenger.getSnapKeyringBuilderInitMessenger;
  }
});
Object.defineProperty(exports, "getSnapKeyringBuilderMessenger", {
  enumerable: true,
  get: function () {
    return _snapKeyringBuilderMessenger.getSnapKeyringBuilderMessenger;
  }
});
var _accountTreeControllerMessenger = require("./account-tree-controller-messenger");
var _multichainAccountServiceMessenger = require("./multichain-account-service-messenger");
var _institutionalSnapControllerMessenger = require("./institutional-snap-controller-messenger");
var _snapKeyringBuilderMessenger = require("./snap-keyring-builder-messenger");

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\accounts\\index.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\accounts\\institutional-snap-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Caccounts%5Cinstitutional-snap-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInstitutionalSnapControllerMessenger = getInstitutionalSnapControllerMessenger;
const controllerName = 'InstitutionalSnapController';
/**
 * Get a restricted controller messenger for the rate limit controller. This is
 * scoped to the actions and events that the rate limit controller is allowed to
 * handle.
 *
 * @param messenger - The messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getInstitutionalSnapControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'InstitutionalSnapController',
    allowedActions: ['AccountsController:getAccountByAddress', 'SnapController:handleRequest', 'TransactionController:updateCustodialTransaction'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\accounts\\institutional-snap-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\accounts\\multichain-account-service-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Caccounts%5Cmultichain-account-service-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMultichainAccountServiceInitMessenger = getMultichainAccountServiceInitMessenger;
exports.getMultichainAccountServiceMessenger = getMultichainAccountServiceMessenger;
/**
 * Get a restricted messenger for the account wallet controller. This is scoped to the
 * actions and events that this controller is allowed to handle.
 *
 * @param messenger - The controller messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getMultichainAccountServiceMessenger(messenger) {
  return messenger.getRestricted({
    name: 'MultichainAccountService',
    allowedEvents: ['KeyringController:stateChange', 'AccountsController:accountAdded', 'AccountsController:accountRemoved', 'RemoteFeatureFlagController:stateChange'],
    allowedActions: ['AccountsController:listMultichainAccounts', 'AccountsController:getAccountByAddress', 'AccountsController:getAccount', 'SnapController:handleRequest', 'KeyringController:getState', 'KeyringController:withKeyring', 'KeyringController:addNewKeyring', 'KeyringController:getKeyringsByType', 'NetworkController:getNetworkClientById', 'NetworkController:findNetworkClientIdByChainId']
  });
}
/**
 * Get a restricted messenger for the account wallet controller. This is scoped to the
 * actions and events that this controller is allowed to handle.
 *
 * @param messenger - The controller messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getMultichainAccountServiceInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'MultichainAccountServiceInit',
    allowedActions: ['PreferencesController:getState', 'RemoteFeatureFlagController:getState'],
    allowedEvents: ['PreferencesController:stateChange']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\accounts\\multichain-account-service-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\accounts\\snap-keyring-builder-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Caccounts%5Csnap-keyring-builder-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSnapKeyringBuilderInitMessenger = getSnapKeyringBuilderInitMessenger;
exports.getSnapKeyringBuilderMessenger = getSnapKeyringBuilderMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * Snap keyring.
 *
 * @param messenger - The controller messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getSnapKeyringBuilderMessenger(messenger) {
  return messenger.getRestricted({
    name: 'SnapKeyring',
    allowedActions: ['ApprovalController:addRequest', 'ApprovalController:acceptRequest', 'ApprovalController:rejectRequest', 'ApprovalController:startFlow', 'ApprovalController:endFlow', 'ApprovalController:showSuccess', 'ApprovalController:showError', 'PhishingController:testOrigin', 'PhishingController:maybeUpdateState', 'KeyringController:getAccounts', 'AccountsController:setSelectedAccount', 'AccountsController:getAccountByAddress', 'AccountsController:setAccountName', 'AccountsController:listMultichainAccounts', 'SnapController:handleRequest', 'SnapController:get', 'SnapController:isMinimumPlatformVersion', 'PreferencesController:getState'],
    allowedEvents: []
  });
}
/**
 * Create a messenger restricted to the allowed actions and events needed to
 * initialize the Snap keyring.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getSnapKeyringBuilderInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'SnapKeyringInit',
    allowedActions: ['AccountsController:updateAccounts', 'KeyringController:persistAllKeyrings', 'MetaMetricsController:trackEvent'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\accounts\\snap-keyring-builder-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\address-book-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Caddress-book-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAddressBookControllerMessenger = getAddressBookControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * address book controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getAddressBookControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'AddressBookController',
    // This controller does not call any actions or subscribe to any events.
    allowedActions: [],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\address-book-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\alert-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Calert-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertControllerMessenger = getAlertControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * alert controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getAlertControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'AlertController',
    allowedActions: ['AccountsController:getSelectedAccount'],
    allowedEvents: ['AccountsController:selectedAccountChange']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\alert-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\announcement-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cannouncement-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnnouncementControllerMessenger = getAnnouncementControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * announcement controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getAnnouncementControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'AnnouncementController',
    // This controller does not call any actions or subscribe to any events.
    allowedActions: [],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\announcement-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\app-metadata-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Capp-metadata-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAppMetadataControllerMessenger = getAppMetadataControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * app metadata controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getAppMetadataControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'AppMetadataController',
    // This controller does not call any actions or subscribe to any events.
    allowedActions: [],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\app-metadata-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\app-state-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Capp-state-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAppStateControllerMessenger = getAppStateControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * app state controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getAppStateControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'AppStateController',
    allowedActions: ['ApprovalController:addRequest', 'ApprovalController:acceptRequest', 'KeyringController:getState', 'PreferencesController:getState'],
    allowedEvents: ['KeyringController:unlock', 'PreferencesController:stateChange']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\app-state-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\approval-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Capproval-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApprovalControllerMessenger = getApprovalControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * approval controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getApprovalControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'ApprovalController',
    // This controller does not call any actions or subscribe to any events.
    allowedActions: [],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\approval-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\assets\\assets-contract-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cassets%5Cassets-contract-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAssetsContractControllerInitMessenger = getAssetsContractControllerInitMessenger;
exports.getAssetsContractControllerMessenger = getAssetsContractControllerMessenger;
/**
 * Get a restricted messenger for the AssetsContractController. This is scoped to the
 * actions and events that the AssetsContractController is allowed to handle.
 *
 * @param messenger - The controller messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getAssetsContractControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'AssetsContractController',
    allowedActions: ['NetworkController:getNetworkClientById', 'NetworkController:getNetworkConfigurationByNetworkClientId', 'NetworkController:getSelectedNetworkClient', 'NetworkController:getState'],
    allowedEvents: ['PreferencesController:stateChange', 'NetworkController:networkDidChange']
  });
}
/**
 * Get a restricted messenger for initializing the AssetsContractController.
 * This is scoped to the actions and events that are needed during initialization.
 *
 * @param messenger - The controller messenger to restrict.
 * @returns The restricted controller messenger for initialization.
 */
function getAssetsContractControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'AssetsContractControllerInit',
    allowedActions: ['NetworkController:getNetworkClientById', 'NetworkController:getState'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\assets\\assets-contract-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\assets\\index.ts", {"./assets-contract-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\assets\\assets-contract-controller-messenger.ts","./network-enablement-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\assets\\network-enablement-controller-messenger.ts","./network-order-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\assets\\network-order-controller-messenger.ts","./nft-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\assets\\nft-controller-messenger.ts","./nft-detection-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\assets\\nft-detection-controller-messenger.ts","./token-rates-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\assets\\token-rates-controller-messenger.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cassets%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "getAssetsContractControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _assetsContractControllerMessenger.getAssetsContractControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getAssetsContractControllerMessenger", {
  enumerable: true,
  get: function () {
    return _assetsContractControllerMessenger.getAssetsContractControllerMessenger;
  }
});
Object.defineProperty(exports, "getNetworkEnablementControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _networkEnablementControllerMessenger.getNetworkEnablementControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getNetworkEnablementControllerMessenger", {
  enumerable: true,
  get: function () {
    return _networkEnablementControllerMessenger.getNetworkEnablementControllerMessenger;
  }
});
Object.defineProperty(exports, "getNetworkOrderControllerMessenger", {
  enumerable: true,
  get: function () {
    return _networkOrderControllerMessenger.getNetworkOrderControllerMessenger;
  }
});
Object.defineProperty(exports, "getNftControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _nftControllerMessenger.getNftControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getNftControllerMessenger", {
  enumerable: true,
  get: function () {
    return _nftControllerMessenger.getNftControllerMessenger;
  }
});
Object.defineProperty(exports, "getNftDetectionControllerMessenger", {
  enumerable: true,
  get: function () {
    return _nftDetectionControllerMessenger.getNftDetectionControllerMessenger;
  }
});
Object.defineProperty(exports, "getTokenRatesControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _tokenRatesControllerMessenger.getTokenRatesControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getTokenRatesControllerMessenger", {
  enumerable: true,
  get: function () {
    return _tokenRatesControllerMessenger.getTokenRatesControllerMessenger;
  }
});
var _tokenRatesControllerMessenger = require("./token-rates-controller-messenger");
var _nftControllerMessenger = require("./nft-controller-messenger");
var _nftDetectionControllerMessenger = require("./nft-detection-controller-messenger");
var _assetsContractControllerMessenger = require("./assets-contract-controller-messenger");
var _networkOrderControllerMessenger = require("./network-order-controller-messenger");
var _networkEnablementControllerMessenger = require("./network-enablement-controller-messenger");

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\assets\\index.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\assets\\network-enablement-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cassets%5Cnetwork-enablement-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNetworkEnablementControllerInitMessenger = getNetworkEnablementControllerInitMessenger;
exports.getNetworkEnablementControllerMessenger = getNetworkEnablementControllerMessenger;
function getNetworkEnablementControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'NetworkEnablementController',
    allowedActions: ['NetworkController:getState', 'MultichainNetworkController:getState'],
    allowedEvents: ['NetworkController:networkAdded', 'NetworkController:networkRemoved', 'NetworkController:stateChange', 'TransactionController:transactionSubmitted']
  });
}
/**
 * Create a messenger restricted to the allowed initialization events of the
 * network enablement controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getNetworkEnablementControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'NetworkEnablementControllerInit',
    allowedActions: ['AccountTreeController:getAccountsFromSelectedAccountGroup'],
    allowedEvents: ['AccountsController:selectedAccountChange', 'AccountTreeController:selectedAccountGroupChange']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\assets\\network-enablement-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\assets\\network-order-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cassets%5Cnetwork-order-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNetworkOrderControllerMessenger = getNetworkOrderControllerMessenger;
function getNetworkOrderControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'NetworkOrderController',
    allowedEvents: ['NetworkController:stateChange', 'NetworkController:networkRemoved'],
    allowedActions: ['NetworkController:getState', 'NetworkController:setActiveNetwork']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\assets\\network-order-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\assets\\nft-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cassets%5Cnft-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNftControllerInitMessenger = getNftControllerInitMessenger;
exports.getNftControllerMessenger = getNftControllerMessenger;
/**
 * Get a restricted messenger for the NFT controller. This is scoped to the
 * actions and events that the NFT controller is allowed to handle.
 *
 * @param messenger - The controller messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getNftControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'NftController',
    allowedEvents: ['PreferencesController:stateChange', 'AccountsController:selectedEvmAccountChange'],
    allowedActions: ['ApprovalController:addRequest', 'NetworkController:getNetworkClientById', 'AccountsController:getSelectedAccount', 'AccountsController:getAccount', 'AssetsContractController:getERC721AssetName', 'AssetsContractController:getERC721AssetSymbol', 'AssetsContractController:getERC721TokenURI', 'AssetsContractController:getERC721OwnerOf', 'AssetsContractController:getERC1155BalanceOf', 'AssetsContractController:getERC1155TokenURI', 'NetworkController:findNetworkClientIdByChainId', 'PhishingController:bulkScanUrls']
  });
}
/**
 * Get a restricted messenger for initializing the NFT controller. This is scoped
 * to the actions that are allowed during controller initialization.
 *
 * @param messenger - The controller messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getNftControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'NftControllerInit',
    allowedActions: ['MetaMetricsController:trackEvent'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\assets\\nft-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\assets\\nft-detection-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cassets%5Cnft-detection-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNftDetectionControllerMessenger = getNftDetectionControllerMessenger;
/**
 * Get a restricted messenger for the NFT detection controller. This is scoped to the
 * actions and events that the NFT controller is allowed to handle.
 *
 * @param messenger - The controller messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getNftDetectionControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'NftDetectionController',
    allowedEvents: ['NetworkController:stateChange', 'PreferencesController:stateChange'],
    allowedActions: ['ApprovalController:addRequest', 'NetworkController:getState', 'NetworkController:getNetworkClientById', 'AccountsController:getSelectedAccount', 'NetworkController:findNetworkClientIdByChainId', 'PhishingController:bulkScanUrls']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\assets\\nft-detection-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\assets\\token-rates-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cassets%5Ctoken-rates-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTokenRatesControllerInitMessenger = getTokenRatesControllerInitMessenger;
exports.getTokenRatesControllerMessenger = getTokenRatesControllerMessenger;
/**
 * Get a restricted messenger for the Token Rates controller. This is scoped to the
 * actions and events that the Token Rates controller is allowed to handle.
 *
 * @param messenger - The controller messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getTokenRatesControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'TokenRatesController',
    allowedActions: ['TokensController:getState', 'NetworkController:getNetworkClientById', 'NetworkController:getState', 'AccountsController:getAccount', 'AccountsController:getSelectedAccount'],
    allowedEvents: ['NetworkController:stateChange', 'AccountsController:selectedEvmAccountChange', 'PreferencesController:stateChange', 'TokensController:stateChange']
  });
}
/**
 * Get a restricted messenger for the token rates controller initialization.
 * This is scoped to the actions and events that the initialization is allowed
 * to handle.
 *
 * @param messenger - The controller messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getTokenRatesControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'TokenRatesControllerInit',
    allowedActions: ['PreferencesController:getState'],
    allowedEvents: ['PreferencesController:stateChange']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\assets\\token-rates-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\bridge-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cbridge-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBridgeControllerInitMessenger = getBridgeControllerInitMessenger;
exports.getBridgeControllerMessenger = getBridgeControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * bridge controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getBridgeControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'BridgeController',
    allowedActions: ['AccountsController:getAccountByAddress', 'SnapController:handleRequest', 'NetworkController:getState', 'NetworkController:getNetworkClientById', 'NetworkController:findNetworkClientIdByChainId', 'TokenRatesController:getState', 'MultichainAssetsRatesController:getState', 'RemoteFeatureFlagController:getState', 'CurrencyRateController:getState'],
    allowedEvents: []
  });
}
/**
 * Create a messenger restricted to the allowed actions and events needed to
 * initialize the bridge controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getBridgeControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'BridgeControllerInit',
    allowedActions: ['MetaMetricsController:trackEvent'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\bridge-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\bridge-status-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cbridge-status-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBridgeStatusControllerMessenger = getBridgeStatusControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * bridge status controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getBridgeStatusControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'BridgeStatusController',
    allowedActions: ['AccountsController:getAccountByAddress', 'NetworkController:getNetworkClientById', 'NetworkController:findNetworkClientIdByChainId', 'NetworkController:getState', 'BridgeController:getBridgeERC20Allowance', 'BridgeController:trackUnifiedSwapBridgeEvent', 'BridgeController:stopPollingForQuotes', 'GasFeeController:getState', 'AccountsController:getAccountByAddress', 'SnapController:handleRequest', 'TransactionController:getState', 'RemoteFeatureFlagController:getState'],
    allowedEvents: ['MultichainTransactionsController:transactionConfirmed', 'TransactionController:transactionFailed', 'TransactionController:transactionConfirmed']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\bridge-status-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\core-backend\\account-activity-service-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Ccore-backend%5Caccount-activity-service-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAccountActivityServiceMessenger = getAccountActivityServiceMessenger;
/**
 * Get a restricted messenger for the Account Activity service. This is scoped to the
 * actions and events that the Account Activity service is allowed to handle.
 *
 * @param messenger - The main controller messenger.
 * @returns The restricted messenger.
 */
function getAccountActivityServiceMessenger(messenger) {
  return messenger.getRestricted({
    name: 'AccountActivityService',
    allowedActions: ['AccountsController:getSelectedAccount', 'BackendWebSocketService:connect', 'BackendWebSocketService:disconnect', 'BackendWebSocketService:subscribe', 'BackendWebSocketService:getConnectionInfo', 'BackendWebSocketService:channelHasSubscription', 'BackendWebSocketService:getSubscriptionsByChannel', 'BackendWebSocketService:findSubscriptionsByChannelPrefix', 'BackendWebSocketService:addChannelCallback', 'BackendWebSocketService:removeChannelCallback'],
    allowedEvents: ['AccountsController:selectedAccountChange', 'BackendWebSocketService:connectionStateChanged']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\core-backend\\account-activity-service-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\core-backend\\backend-websocket-service-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Ccore-backend%5Cbackend-websocket-service-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBackendWebSocketServiceInitMessenger = getBackendWebSocketServiceInitMessenger;
exports.getBackendWebSocketServiceMessenger = getBackendWebSocketServiceMessenger;
/**
 * Get a restricted messenger for the Backend Platform WebSocket service.
 * This is scoped to backend platform operations and services.
 *
 * @param messenger - The main controller messenger.
 * @returns The restricted messenger.
 */
function getBackendWebSocketServiceMessenger(
// eslint-disable-next-line @typescript-eslint/no-explicit-any
messenger // Using any to avoid type conflicts with the main messenger
) {
  return messenger.getRestricted({
    name: 'BackendWebSocketService',
    allowedActions: ['AuthenticationController:getBearerToken' // Get auth token (includes wallet unlock check)
    ],
    allowedEvents: ['AuthenticationController:stateChange',
    // Listen for authentication state (sign in/out)
    'KeyringController:lock',
    // Listen for wallet lock
    'KeyringController:unlock' // Listen for wallet unlock
    ]
  });
}
function getBackendWebSocketServiceInitMessenger(
// eslint-disable-next-line @typescript-eslint/no-explicit-any
messenger) {
  return messenger.getRestricted({
    name: 'BackendWebSocketServiceInit',
    allowedEvents: [],
    allowedActions: ['RemoteFeatureFlagController:getState', 'AuthenticationController:getBearerToken']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\core-backend\\backend-websocket-service-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\core-backend\\index.ts", {"./account-activity-service-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\core-backend\\account-activity-service-messenger.ts","./backend-websocket-service-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\core-backend\\backend-websocket-service-messenger.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Ccore-backend%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "getAccountActivityServiceMessenger", {
  enumerable: true,
  get: function () {
    return _accountActivityServiceMessenger.getAccountActivityServiceMessenger;
  }
});
Object.defineProperty(exports, "getBackendWebSocketServiceInitMessenger", {
  enumerable: true,
  get: function () {
    return _backendWebsocketServiceMessenger.getBackendWebSocketServiceInitMessenger;
  }
});
Object.defineProperty(exports, "getBackendWebSocketServiceMessenger", {
  enumerable: true,
  get: function () {
    return _backendWebsocketServiceMessenger.getBackendWebSocketServiceMessenger;
  }
});
var _backendWebsocketServiceMessenger = require("./backend-websocket-service-messenger");
var _accountActivityServiceMessenger = require("./account-activity-service-messenger");

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\core-backend\\index.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\currency-rate-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Ccurrency-rate-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCurrencyRateControllerInitMessenger = getCurrencyRateControllerInitMessenger;
exports.getCurrencyRateControllerMessenger = getCurrencyRateControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * currency rate controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getCurrencyRateControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'CurrencyRateController',
    allowedActions: ['NetworkController:getNetworkClientById'],
    allowedEvents: []
  });
}
/**
 * Create a messenger restricted to the allowed actions and events needed to
 * initialize the currency rate controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getCurrencyRateControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'CurrencyRateControllerInit',
    allowedActions: ['PreferencesController:getState'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\currency-rate-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\decrypt-message-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cdecrypt-message-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDecryptMessageControllerInitMessenger = getDecryptMessageControllerInitMessenger;
exports.getDecryptMessageControllerMessenger = getDecryptMessageControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * decrypt message controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getDecryptMessageControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'DecryptMessageController',
    allowedActions: ['ApprovalController:addRequest', 'ApprovalController:acceptRequest', 'ApprovalController:rejectRequest', 'KeyringController:decryptMessage'],
    allowedEvents: ['DecryptMessageManager:stateChange', 'DecryptMessageManager:unapprovedMessage']
  });
}
/**
 * Create a messenger restricted to the allowed actions and events needed to
 * initialize the decrypt message controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getDecryptMessageControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'DecryptMessageControllerInit',
    allowedActions: ['MetaMetricsController:trackEvent'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\decrypt-message-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\decrypt-message-manager-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cdecrypt-message-manager-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDecryptMessageManagerMessenger = getDecryptMessageManagerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * decrypt message manager.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getDecryptMessageManagerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'DecryptMessageManager',
    // This controller does not call any actions or subscribe to any events.
    allowedActions: [],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\decrypt-message-manager-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\defi-positions\\defi-positions-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cdefi-positions%5Cdefi-positions-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDeFiPositionsControllerInitMessenger = getDeFiPositionsControllerInitMessenger;
exports.getDeFiPositionsControllerMessenger = getDeFiPositionsControllerMessenger;
/**
 * Get a restricted messenger for the Defi Positions controller. This is scoped to the
 * actions and events that the Defi Positions controller is allowed to handle.
 *
 * @param messenger - The controller messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getDeFiPositionsControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'DeFiPositionsController',
    allowedActions: ['AccountsController:listAccounts'],
    allowedEvents: ['KeyringController:unlock', 'KeyringController:lock', 'TransactionController:transactionConfirmed', 'AccountsController:accountAdded']
  });
}
function getDeFiPositionsControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'DeFiPositionsControllerInit',
    allowedEvents: [],
    allowedActions: ['RemoteFeatureFlagController:getState', 'MetaMetricsController:trackEvent']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\defi-positions\\defi-positions-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\defi-positions\\index.ts", {"./defi-positions-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\defi-positions\\defi-positions-controller-messenger.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cdefi-positions%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "getDeFiPositionsControllerMessenger", {
  enumerable: true,
  get: function () {
    return _defiPositionsControllerMessenger.getDeFiPositionsControllerMessenger;
  }
});
var _defiPositionsControllerMessenger = require("./defi-positions-controller-messenger");

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\defi-positions\\index.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\delegation\\delegation-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cdelegation%5Cdelegation-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDelegationControllerInitMessenger = getDelegationControllerInitMessenger;
exports.getDelegationControllerMessenger = getDelegationControllerMessenger;
function getDelegationControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'DelegationController',
    allowedActions: ['AccountsController:getSelectedAccount', 'KeyringController:signTypedMessage'],
    allowedEvents: ['TransactionController:transactionStatusUpdated']
  });
}
function getDelegationControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'DelegationControllerInit',
    allowedEvents: ['TransactionController:transactionStatusUpdated'],
    allowedActions: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\delegation\\delegation-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\encryption-public-key-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cencryption-public-key-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEncryptionPublicKeyControllerInitMessenger = getEncryptionPublicKeyControllerInitMessenger;
exports.getEncryptionPublicKeyControllerMessenger = getEncryptionPublicKeyControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * encryption public key controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getEncryptionPublicKeyControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'EncryptionPublicKeyController',
    allowedActions: ['ApprovalController:addRequest', 'ApprovalController:acceptRequest', 'ApprovalController:rejectRequest'],
    allowedEvents: ['EncryptionPublicKeyManager:stateChange', 'EncryptionPublicKeyManager:unapprovedMessage']
  });
}
/**
 * Create a messenger restricted to the allowed actions and events needed to
 * initialize the encryption public key controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getEncryptionPublicKeyControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'EncryptionPublicKeyControllerInit',
    allowedActions: ['KeyringController:getEncryptionPublicKey', 'MetaMetricsController:trackEvent'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\encryption-public-key-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\encryption-public-key-manager-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cencryption-public-key-manager-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEncryptionPublicKeyManagerMessenger = getEncryptionPublicKeyManagerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * encryption public key manager.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getEncryptionPublicKeyManagerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'EncryptionPublicKeyManager',
    // This controller does not call any actions or subscribe to any events.
    allowedActions: [],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\encryption-public-key-manager-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\ens-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cens-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEnsControllerInitMessenger = getEnsControllerInitMessenger;
exports.getEnsControllerMessenger = getEnsControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the ENS
 * controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getEnsControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'EnsController',
    allowedActions: ['NetworkController:getNetworkClientById', 'NetworkController:getState'],
    allowedEvents: []
  });
}
/**
 * Create a messenger restricted to the allowed actions and events needed during
 * initialization of the ENS controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getEnsControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'EnsControllerInit',
    allowedActions: [],
    allowedEvents: ['NetworkController:networkDidChange']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\ens-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\error-reporting-service-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cerror-reporting-service-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getErrorReportingServiceMessenger = getErrorReportingServiceMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * error reporting service.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getErrorReportingServiceMessenger(messenger) {
  return messenger.getRestricted({
    name: 'ErrorReportingService',
    // This service does not call any actions or subscribe to any events.
    allowedActions: [],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\error-reporting-service-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\gas-fee-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cgas-fee-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGasFeeControllerInitMessenger = getGasFeeControllerInitMessenger;
exports.getGasFeeControllerMessenger = getGasFeeControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * gas fee controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getGasFeeControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'GasFeeController',
    allowedActions: ['NetworkController:getEIP1559Compatibility', 'NetworkController:getNetworkClientById', 'NetworkController:getState'],
    allowedEvents: ['NetworkController:stateChange']
  });
}
/**
 * Create a messenger restricted to the allowed actions and events needed to
 * initialize the currency rate controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getGasFeeControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'GasFeeControllerInit',
    allowedActions: ['NetworkController:getEIP1559Compatibility', 'NetworkController:getNetworkClientById', 'NetworkController:getSelectedNetworkClient', 'NetworkController:getState'],
    allowedEvents: ['NetworkController:networkDidChange']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\gas-fee-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\gator-permissions\\gator-permissions-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cgator-permissions%5Cgator-permissions-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGatorPermissionsControllerMessenger = getGatorPermissionsControllerMessenger;
/**
 * Get a restricted messenger for the Gator Permissions controller. This is scoped to the
 * actions and events that the Gator Permissions controller is allowed to handle.
 *
 * @param messenger - The messenger to restrict.
 * @returns The restricted messenger.
 */
function getGatorPermissionsControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'GatorPermissionsController',
    allowedActions: ['SnapController:handleRequest', 'SnapController:has'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\gator-permissions\\gator-permissions-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\identity\\authentication-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cidentity%5Cauthentication-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAuthenticationControllerInitMessenger = getAuthenticationControllerInitMessenger;
exports.getAuthenticationControllerMessenger = getAuthenticationControllerMessenger;
/**
 * Get a restricted messenger for the Authentication controller. This is scoped to the
 * actions and events that the Authentication controller is allowed to handle.
 *
 * @param messenger - The messenger to restrict.
 * @returns The restricted messenger.
 */
function getAuthenticationControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'AuthenticationController',
    allowedActions: ['KeyringController:getState', 'SnapController:handleRequest'],
    allowedEvents: ['KeyringController:lock', 'KeyringController:unlock']
  });
}
/**
 * Get a restricted messenger for the Authentication controller to be used during
 * initialization. This is scoped to the actions that the controller needs
 * during initialization.
 *
 * @param messenger - The messenger to restrict.
 * @returns The restricted messenger.
 */
function getAuthenticationControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'AuthenticationController',
    allowedActions: ['MetaMetricsController:getMetaMetricsId'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\identity\\authentication-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\identity\\index.ts", {"./authentication-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\identity\\authentication-controller-messenger.ts","./user-storage-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\identity\\user-storage-controller-messenger.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cidentity%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "getAuthenticationControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _authenticationControllerMessenger.getAuthenticationControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getAuthenticationControllerMessenger", {
  enumerable: true,
  get: function () {
    return _authenticationControllerMessenger.getAuthenticationControllerMessenger;
  }
});
Object.defineProperty(exports, "getUserStorageControllerMessenger", {
  enumerable: true,
  get: function () {
    return _userStorageControllerMessenger.getUserStorageControllerMessenger;
  }
});
var _authenticationControllerMessenger = require("./authentication-controller-messenger");
var _userStorageControllerMessenger = require("./user-storage-controller-messenger");

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\identity\\index.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\identity\\user-storage-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cidentity%5Cuser-storage-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUserStorageControllerInitMessenger = getUserStorageControllerInitMessenger;
exports.getUserStorageControllerMessenger = getUserStorageControllerMessenger;
/**
 * Get a restricted messenger for the User Storage controller. This is scoped to the
 * actions and events that the User Storage controller is allowed to handle.
 *
 * @param messenger - The messenger to restrict.
 * @returns The restricted messenger.
 */
function getUserStorageControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'UserStorageController',
    allowedActions: [
    // Keyring Controller Requests
    'KeyringController:getState',
    // Snap Controller Requests
    'SnapController:handleRequest',
    // Auth Controller Requests
    'AuthenticationController:getBearerToken', 'AuthenticationController:getSessionProfile', 'AuthenticationController:isSignedIn', 'AuthenticationController:performSignIn',
    // Address Book Controller Requests
    'AddressBookController:list', 'AddressBookController:set', 'AddressBookController:delete'],
    allowedEvents: [
    // Keyring Controller Events
    'KeyringController:lock', 'KeyringController:unlock',
    // Address Book Controller Events
    'AddressBookController:contactUpdated', 'AddressBookController:contactDeleted',
    // Network Controller Events
    'NetworkController:networkRemoved']
  });
}
/**
 * Get a restricted messenger for initializing the User Storage controller.
 * This is scoped to the actions that are allowed during controller
 * initialization.
 *
 * @param messenger - The messenger to restrict.
 * @returns The restricted messenger.
 */
function getUserStorageControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'UserStorageControllerInit',
    allowedActions: ['MetaMetricsController:trackEvent'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\identity\\user-storage-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\index.ts", {"./account-order-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\account-order-controller-messenger.ts","./account-tracker-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\account-tracker-controller-messenger.ts","./accounts":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\accounts\\index.ts","./accounts-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\accounts-controller-messenger.ts","./accounts/institutional-snap-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\accounts\\institutional-snap-controller-messenger.ts","./address-book-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\address-book-controller-messenger.ts","./alert-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\alert-controller-messenger.ts","./announcement-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\announcement-controller-messenger.ts","./app-metadata-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\app-metadata-controller-messenger.ts","./app-state-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\app-state-controller-messenger.ts","./approval-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\approval-controller-messenger.ts","./assets":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\assets\\index.ts","./bridge-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\bridge-controller-messenger.ts","./bridge-status-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\bridge-status-controller-messenger.ts","./core-backend":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\core-backend\\index.ts","./currency-rate-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\currency-rate-controller-messenger.ts","./decrypt-message-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\decrypt-message-controller-messenger.ts","./decrypt-message-manager-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\decrypt-message-manager-messenger.ts","./defi-positions":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\defi-positions\\index.ts","./defi-positions/defi-positions-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\defi-positions\\defi-positions-controller-messenger.ts","./delegation/delegation-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\delegation\\delegation-controller-messenger.ts","./encryption-public-key-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\encryption-public-key-controller-messenger.ts","./encryption-public-key-manager-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\encryption-public-key-manager-messenger.ts","./ens-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\ens-controller-messenger.ts","./error-reporting-service-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\error-reporting-service-messenger.ts","./gas-fee-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\gas-fee-controller-messenger.ts","./gator-permissions/gator-permissions-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\gator-permissions\\gator-permissions-controller-messenger.ts","./identity":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\identity\\index.ts","./identity/user-storage-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\identity\\user-storage-controller-messenger.ts","./keyring-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\keyring-controller-messenger.ts","./logging-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\logging-controller-messenger.ts","./metametrics-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\metametrics-controller-messenger.ts","./metametrics-data-deletion-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\metametrics-data-deletion-controller-messenger.ts","./multichain":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\multichain\\index.ts","./name-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\name-controller-messenger.ts","./network-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\network-controller-messenger.ts","./notifications":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\notifications\\index.ts","./onboarding-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\onboarding-controller-messenger.ts","./permission-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\permission-controller-messenger.ts","./permission-log-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\permission-log-controller-messenger.ts","./phishing-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\phishing-controller-messenger.ts","./ppom-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\ppom-controller-messenger.ts","./preferences-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\preferences-controller-messenger.ts","./rates-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\rates-controller-messenger.ts","./remote-feature-flag-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\remote-feature-flag-controller-messenger.ts","./seedless-onboarding":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\seedless-onboarding\\index.ts","./selected-network-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\selected-network-controller-messenger.ts","./shield/shield-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\shield\\shield-controller-messenger.ts","./signature-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\signature-controller-messenger.ts","./smart-transactions-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\smart-transactions-controller-messenger.ts","./snaps":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\snaps\\index.ts","./subject-metadata-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\subject-metadata-controller-messenger.ts","./subscription":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\subscription\\index.ts","./subscription/subscription-service-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\subscription\\subscription-service-messenger.ts","./swaps-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\swaps-controller-messenger.ts","./token-balances-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\token-balances-controller-messenger.ts","./token-detection-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\token-detection-controller-messenger.ts","./token-list-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\token-list-controller-messenger.ts","./tokens-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\tokens-controller-messenger.ts","./transaction-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\transaction-controller-messenger.ts","./user-operation-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\user-operation-controller-messenger.ts","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CONTROLLER_MESSENGERS = void 0;
Object.defineProperty(exports, "getAccountOrderControllerMessenger", {
  enumerable: true,
  get: function () {
    return _accountOrderControllerMessenger.getAccountOrderControllerMessenger;
  }
});
Object.defineProperty(exports, "getAccountTrackerControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _accountTrackerControllerMessenger.getAccountTrackerControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getAccountTrackerControllerMessenger", {
  enumerable: true,
  get: function () {
    return _accountTrackerControllerMessenger.getAccountTrackerControllerMessenger;
  }
});
Object.defineProperty(exports, "getAccountsControllerMessenger", {
  enumerable: true,
  get: function () {
    return _accountsControllerMessenger.getAccountsControllerMessenger;
  }
});
Object.defineProperty(exports, "getAddressBookControllerMessenger", {
  enumerable: true,
  get: function () {
    return _addressBookControllerMessenger.getAddressBookControllerMessenger;
  }
});
Object.defineProperty(exports, "getAlertControllerMessenger", {
  enumerable: true,
  get: function () {
    return _alertControllerMessenger.getAlertControllerMessenger;
  }
});
Object.defineProperty(exports, "getAnnouncementControllerMessenger", {
  enumerable: true,
  get: function () {
    return _announcementControllerMessenger.getAnnouncementControllerMessenger;
  }
});
Object.defineProperty(exports, "getAppMetadataControllerMessenger", {
  enumerable: true,
  get: function () {
    return _appMetadataControllerMessenger.getAppMetadataControllerMessenger;
  }
});
Object.defineProperty(exports, "getAppStateControllerMessenger", {
  enumerable: true,
  get: function () {
    return _appStateControllerMessenger.getAppStateControllerMessenger;
  }
});
Object.defineProperty(exports, "getApprovalControllerMessenger", {
  enumerable: true,
  get: function () {
    return _approvalControllerMessenger.getApprovalControllerMessenger;
  }
});
Object.defineProperty(exports, "getBridgeControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _bridgeControllerMessenger.getBridgeControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getBridgeControllerMessenger", {
  enumerable: true,
  get: function () {
    return _bridgeControllerMessenger.getBridgeControllerMessenger;
  }
});
Object.defineProperty(exports, "getBridgeStatusControllerMessenger", {
  enumerable: true,
  get: function () {
    return _bridgeStatusControllerMessenger.getBridgeStatusControllerMessenger;
  }
});
Object.defineProperty(exports, "getCurrencyRateControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _currencyRateControllerMessenger.getCurrencyRateControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getCurrencyRateControllerMessenger", {
  enumerable: true,
  get: function () {
    return _currencyRateControllerMessenger.getCurrencyRateControllerMessenger;
  }
});
Object.defineProperty(exports, "getDecryptMessageControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _decryptMessageControllerMessenger.getDecryptMessageControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getDecryptMessageControllerMessenger", {
  enumerable: true,
  get: function () {
    return _decryptMessageControllerMessenger.getDecryptMessageControllerMessenger;
  }
});
Object.defineProperty(exports, "getDecryptMessageManagerMessenger", {
  enumerable: true,
  get: function () {
    return _decryptMessageManagerMessenger.getDecryptMessageManagerMessenger;
  }
});
Object.defineProperty(exports, "getEncryptionPublicKeyControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _encryptionPublicKeyControllerMessenger.getEncryptionPublicKeyControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getEncryptionPublicKeyControllerMessenger", {
  enumerable: true,
  get: function () {
    return _encryptionPublicKeyControllerMessenger.getEncryptionPublicKeyControllerMessenger;
  }
});
Object.defineProperty(exports, "getEncryptionPublicKeyManagerMessenger", {
  enumerable: true,
  get: function () {
    return _encryptionPublicKeyManagerMessenger.getEncryptionPublicKeyManagerMessenger;
  }
});
Object.defineProperty(exports, "getEnsControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _ensControllerMessenger.getEnsControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getEnsControllerMessenger", {
  enumerable: true,
  get: function () {
    return _ensControllerMessenger.getEnsControllerMessenger;
  }
});
Object.defineProperty(exports, "getErrorReportingServiceMessenger", {
  enumerable: true,
  get: function () {
    return _errorReportingServiceMessenger.getErrorReportingServiceMessenger;
  }
});
Object.defineProperty(exports, "getGasFeeControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _gasFeeControllerMessenger.getGasFeeControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getGasFeeControllerMessenger", {
  enumerable: true,
  get: function () {
    return _gasFeeControllerMessenger.getGasFeeControllerMessenger;
  }
});
Object.defineProperty(exports, "getKeyringControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _keyringControllerMessenger.getKeyringControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getKeyringControllerMessenger", {
  enumerable: true,
  get: function () {
    return _keyringControllerMessenger.getKeyringControllerMessenger;
  }
});
Object.defineProperty(exports, "getLoggingControllerMessenger", {
  enumerable: true,
  get: function () {
    return _loggingControllerMessenger.getLoggingControllerMessenger;
  }
});
Object.defineProperty(exports, "getMetaMetricsControllerMessenger", {
  enumerable: true,
  get: function () {
    return _metametricsControllerMessenger.getMetaMetricsControllerMessenger;
  }
});
Object.defineProperty(exports, "getMetaMetricsDataDeletionControllerMessenger", {
  enumerable: true,
  get: function () {
    return _metametricsDataDeletionControllerMessenger.getMetaMetricsDataDeletionControllerMessenger;
  }
});
Object.defineProperty(exports, "getNameControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _nameControllerMessenger.getNameControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getNameControllerMessenger", {
  enumerable: true,
  get: function () {
    return _nameControllerMessenger.getNameControllerMessenger;
  }
});
Object.defineProperty(exports, "getNetworkControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _networkControllerMessenger.getNetworkControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getNetworkControllerMessenger", {
  enumerable: true,
  get: function () {
    return _networkControllerMessenger.getNetworkControllerMessenger;
  }
});
Object.defineProperty(exports, "getOnboardingControllerMessenger", {
  enumerable: true,
  get: function () {
    return _onboardingControllerMessenger.getOnboardingControllerMessenger;
  }
});
Object.defineProperty(exports, "getPermissionControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _permissionControllerMessenger.getPermissionControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getPermissionControllerMessenger", {
  enumerable: true,
  get: function () {
    return _permissionControllerMessenger.getPermissionControllerMessenger;
  }
});
Object.defineProperty(exports, "getPermissionLogControllerMessenger", {
  enumerable: true,
  get: function () {
    return _permissionLogControllerMessenger.getPermissionLogControllerMessenger;
  }
});
Object.defineProperty(exports, "getPhishingControllerMessenger", {
  enumerable: true,
  get: function () {
    return _phishingControllerMessenger.getPhishingControllerMessenger;
  }
});
Object.defineProperty(exports, "getPreferencesControllerMessenger", {
  enumerable: true,
  get: function () {
    return _preferencesControllerMessenger.getPreferencesControllerMessenger;
  }
});
Object.defineProperty(exports, "getRatesControllerMessenger", {
  enumerable: true,
  get: function () {
    return _ratesControllerMessenger.getRatesControllerMessenger;
  }
});
Object.defineProperty(exports, "getRemoteFeatureFlagControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _remoteFeatureFlagControllerMessenger.getRemoteFeatureFlagControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getRemoteFeatureFlagControllerMessenger", {
  enumerable: true,
  get: function () {
    return _remoteFeatureFlagControllerMessenger.getRemoteFeatureFlagControllerMessenger;
  }
});
Object.defineProperty(exports, "getSelectedNetworkControllerMessenger", {
  enumerable: true,
  get: function () {
    return _selectedNetworkControllerMessenger.getSelectedNetworkControllerMessenger;
  }
});
Object.defineProperty(exports, "getSignatureControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _signatureControllerMessenger.getSignatureControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getSignatureControllerMessenger", {
  enumerable: true,
  get: function () {
    return _signatureControllerMessenger.getSignatureControllerMessenger;
  }
});
Object.defineProperty(exports, "getSubjectMetadataControllerMessenger", {
  enumerable: true,
  get: function () {
    return _subjectMetadataControllerMessenger.getSubjectMetadataControllerMessenger;
  }
});
Object.defineProperty(exports, "getSwapsControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _swapsControllerMessenger.getSwapsControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getSwapsControllerMessenger", {
  enumerable: true,
  get: function () {
    return _swapsControllerMessenger.getSwapsControllerMessenger;
  }
});
Object.defineProperty(exports, "getTokenBalancesControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _tokenBalancesControllerMessenger.getTokenBalancesControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getTokenBalancesControllerMessenger", {
  enumerable: true,
  get: function () {
    return _tokenBalancesControllerMessenger.getTokenBalancesControllerMessenger;
  }
});
Object.defineProperty(exports, "getTokenDetectionControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _tokenDetectionControllerMessenger.getTokenDetectionControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getTokenDetectionControllerMessenger", {
  enumerable: true,
  get: function () {
    return _tokenDetectionControllerMessenger.getTokenDetectionControllerMessenger;
  }
});
Object.defineProperty(exports, "getTokenListControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _tokenListControllerMessenger.getTokenListControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getTokenListControllerMessenger", {
  enumerable: true,
  get: function () {
    return _tokenListControllerMessenger.getTokenListControllerMessenger;
  }
});
Object.defineProperty(exports, "getTokensControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _tokensControllerMessenger.getTokensControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getTokensControllerMessenger", {
  enumerable: true,
  get: function () {
    return _tokensControllerMessenger.getTokensControllerMessenger;
  }
});
Object.defineProperty(exports, "getUserOperationControllerMessenger", {
  enumerable: true,
  get: function () {
    return _userOperationControllerMessenger.getUserOperationControllerMessenger;
  }
});
var _lodash = require("lodash");
var _ppomControllerMessenger = require("./ppom-controller-messenger");
var _snaps = require("./snaps");
var _transactionControllerMessenger = require("./transaction-controller-messenger");
var _coreBackend = require("./core-backend");
var _multichain = require("./multichain");
var _institutionalSnapControllerMessenger = require("./accounts/institutional-snap-controller-messenger");
var _identity = require("./identity");
var _assets = require("./assets");
var _notifications = require("./notifications");
var _defiPositions = require("./defi-positions");
var _defiPositionsControllerMessenger = require("./defi-positions/defi-positions-controller-messenger");
var _delegationControllerMessenger = require("./delegation/delegation-controller-messenger");
var _accounts = require("./accounts");
var _seedlessOnboarding = require("./seedless-onboarding");
var _smartTransactionsControllerMessenger = require("./smart-transactions-controller-messenger");
var _shieldControllerMessenger = require("./shield/shield-controller-messenger");
var _subscription = require("./subscription");
var _gatorPermissionsControllerMessenger = require("./gator-permissions/gator-permissions-controller-messenger");
var _metametricsControllerMessenger = require("./metametrics-controller-messenger");
var _userStorageControllerMessenger = require("./identity/user-storage-controller-messenger");
var _tokenListControllerMessenger = require("./token-list-controller-messenger");
var _tokenDetectionControllerMessenger = require("./token-detection-controller-messenger");
var _tokensControllerMessenger = require("./tokens-controller-messenger");
var _tokenBalancesControllerMessenger = require("./token-balances-controller-messenger");
var _ratesControllerMessenger = require("./rates-controller-messenger");
var _currencyRateControllerMessenger = require("./currency-rate-controller-messenger");
var _ensControllerMessenger = require("./ens-controller-messenger");
var _nameControllerMessenger = require("./name-controller-messenger");
var _gasFeeControllerMessenger = require("./gas-fee-controller-messenger");
var _selectedNetworkControllerMessenger = require("./selected-network-controller-messenger");
var _accountTrackerControllerMessenger = require("./account-tracker-controller-messenger");
var _onboardingControllerMessenger = require("./onboarding-controller-messenger");
var _remoteFeatureFlagControllerMessenger = require("./remote-feature-flag-controller-messenger");
var _swapsControllerMessenger = require("./swaps-controller-messenger");
var _bridgeControllerMessenger = require("./bridge-controller-messenger");
var _bridgeStatusControllerMessenger = require("./bridge-status-controller-messenger");
var _preferencesControllerMessenger = require("./preferences-controller-messenger");
var _appStateControllerMessenger = require("./app-state-controller-messenger");
var _permissionControllerMessenger = require("./permission-controller-messenger");
var _subjectMetadataControllerMessenger = require("./subject-metadata-controller-messenger");
var _keyringControllerMessenger = require("./keyring-controller-messenger");
var _permissionLogControllerMessenger = require("./permission-log-controller-messenger");
var _networkControllerMessenger = require("./network-controller-messenger");
var _subscriptionServiceMessenger = require("./subscription/subscription-service-messenger");
var _announcementControllerMessenger = require("./announcement-controller-messenger");
var _accountOrderControllerMessenger = require("./account-order-controller-messenger");
var _accountsControllerMessenger = require("./accounts-controller-messenger");
var _phishingControllerMessenger = require("./phishing-controller-messenger");
var _alertControllerMessenger = require("./alert-controller-messenger");
var _metametricsDataDeletionControllerMessenger = require("./metametrics-data-deletion-controller-messenger");
var _loggingControllerMessenger = require("./logging-controller-messenger");
var _appMetadataControllerMessenger = require("./app-metadata-controller-messenger");
var _errorReportingServiceMessenger = require("./error-reporting-service-messenger");
var _approvalControllerMessenger = require("./approval-controller-messenger");
var _addressBookControllerMessenger = require("./address-book-controller-messenger");
var _decryptMessageManagerMessenger = require("./decrypt-message-manager-messenger");
var _decryptMessageControllerMessenger = require("./decrypt-message-controller-messenger");
var _encryptionPublicKeyControllerMessenger = require("./encryption-public-key-controller-messenger");
var _encryptionPublicKeyManagerMessenger = require("./encryption-public-key-manager-messenger");
var _signatureControllerMessenger = require("./signature-controller-messenger");
var _userOperationControllerMessenger = require("./user-operation-controller-messenger");
const CONTROLLER_MESSENGERS = exports.CONTROLLER_MESSENGERS = {
  AccountOrderController: {
    getMessenger: _accountOrderControllerMessenger.getAccountOrderControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  AccountTrackerController: {
    getMessenger: _accountTrackerControllerMessenger.getAccountTrackerControllerMessenger,
    getInitMessenger: _accountTrackerControllerMessenger.getAccountTrackerControllerInitMessenger
  },
  AccountsController: {
    getMessenger: _accountsControllerMessenger.getAccountsControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  AddressBookController: {
    getMessenger: _addressBookControllerMessenger.getAddressBookControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  AlertController: {
    getMessenger: _alertControllerMessenger.getAlertControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  AnnouncementController: {
    getMessenger: _announcementControllerMessenger.getAnnouncementControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  AppMetadataController: {
    getMessenger: _appMetadataControllerMessenger.getAppMetadataControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  ApprovalController: {
    getMessenger: _approvalControllerMessenger.getApprovalControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  AppStateController: {
    getMessenger: _appStateControllerMessenger.getAppStateControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  AuthenticationController: {
    getMessenger: _identity.getAuthenticationControllerMessenger,
    getInitMessenger: _identity.getAuthenticationControllerInitMessenger
  },
  BridgeController: {
    getMessenger: _bridgeControllerMessenger.getBridgeControllerMessenger,
    getInitMessenger: _bridgeControllerMessenger.getBridgeControllerInitMessenger
  },
  BridgeStatusController: {
    getMessenger: _bridgeStatusControllerMessenger.getBridgeStatusControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  CronjobController: {
    getMessenger: _snaps.getCronjobControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  CurrencyRateController: {
    getMessenger: _currencyRateControllerMessenger.getCurrencyRateControllerMessenger,
    getInitMessenger: _currencyRateControllerMessenger.getCurrencyRateControllerInitMessenger
  },
  DecryptMessageController: {
    getMessenger: _decryptMessageControllerMessenger.getDecryptMessageControllerMessenger,
    getInitMessenger: _decryptMessageControllerMessenger.getDecryptMessageControllerInitMessenger
  },
  DecryptMessageManager: {
    getMessenger: _decryptMessageManagerMessenger.getDecryptMessageManagerMessenger,
    getInitMessenger: _lodash.noop
  },
  DeFiPositionsController: {
    getMessenger: _defiPositions.getDeFiPositionsControllerMessenger,
    getInitMessenger: _defiPositionsControllerMessenger.getDeFiPositionsControllerInitMessenger
  },
  DelegationController: {
    getMessenger: _delegationControllerMessenger.getDelegationControllerMessenger,
    getInitMessenger: _delegationControllerMessenger.getDelegationControllerInitMessenger
  },
  EncryptionPublicKeyController: {
    getMessenger: _encryptionPublicKeyControllerMessenger.getEncryptionPublicKeyControllerMessenger,
    getInitMessenger: _encryptionPublicKeyControllerMessenger.getEncryptionPublicKeyControllerInitMessenger
  },
  EncryptionPublicKeyManager: {
    getMessenger: _encryptionPublicKeyManagerMessenger.getEncryptionPublicKeyManagerMessenger,
    getInitMessenger: _lodash.noop
  },
  EnsController: {
    getMessenger: _ensControllerMessenger.getEnsControllerMessenger,
    getInitMessenger: _ensControllerMessenger.getEnsControllerInitMessenger
  },
  ErrorReportingService: {
    getMessenger: _errorReportingServiceMessenger.getErrorReportingServiceMessenger,
    getInitMessenger: _lodash.noop
  },
  ExecutionService: {
    getMessenger: _snaps.getExecutionServiceMessenger,
    getInitMessenger: _lodash.noop
  },
  GasFeeController: {
    getMessenger: _gasFeeControllerMessenger.getGasFeeControllerMessenger,
    getInitMessenger: _gasFeeControllerMessenger.getGasFeeControllerInitMessenger
  },
  GatorPermissionsController: {
    getMessenger: _gatorPermissionsControllerMessenger.getGatorPermissionsControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  InstitutionalSnapController: {
    getMessenger: _institutionalSnapControllerMessenger.getInstitutionalSnapControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  KeyringController: {
    getMessenger: _keyringControllerMessenger.getKeyringControllerMessenger,
    getInitMessenger: _keyringControllerMessenger.getKeyringControllerInitMessenger
  },
  LoggingController: {
    getMessenger: _loggingControllerMessenger.getLoggingControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  MetaMetricsController: {
    getMessenger: _metametricsControllerMessenger.getMetaMetricsControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  MetaMetricsDataDeletionController: {
    getMessenger: _metametricsDataDeletionControllerMessenger.getMetaMetricsDataDeletionControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  MultichainAssetsController: {
    getMessenger: _multichain.getMultichainAssetsControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  MultichainAssetsRatesController: {
    getMessenger: _multichain.getMultichainAssetsRatesControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  MultichainBalancesController: {
    getMessenger: _multichain.getMultichainBalancesControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  MultichainTransactionsController: {
    getMessenger: _multichain.getMultichainTransactionsControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  MultichainNetworkController: {
    getMessenger: _multichain.getMultichainNetworkControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
  MultichainRouter: {
    getMessenger: _snaps.getMultichainRouterMessenger,
    getInitMessenger: _lodash.noop
  },
  ///: END:ONLY_INCLUDE_IF
  NameController: {
    getMessenger: _nameControllerMessenger.getNameControllerMessenger,
    getInitMessenger: _nameControllerMessenger.getNameControllerInitMessenger
  },
  NetworkController: {
    getMessenger: _networkControllerMessenger.getNetworkControllerMessenger,
    getInitMessenger: _networkControllerMessenger.getNetworkControllerInitMessenger
  },
  NotificationServicesController: {
    getMessenger: _notifications.getNotificationServicesControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  NotificationServicesPushController: {
    getMessenger: _notifications.getNotificationServicesPushControllerMessenger,
    getInitMessenger: _notifications.getNotificationServicesPushControllerInitMessenger
  },
  OAuthService: {
    getMessenger: _seedlessOnboarding.getOAuthServiceMessenger,
    getInitMessenger: _lodash.noop
  },
  OnboardingController: {
    getMessenger: _onboardingControllerMessenger.getOnboardingControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  PermissionController: {
    getMessenger: _permissionControllerMessenger.getPermissionControllerMessenger,
    getInitMessenger: _permissionControllerMessenger.getPermissionControllerInitMessenger
  },
  PermissionLogController: {
    getMessenger: _permissionLogControllerMessenger.getPermissionLogControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  PhishingController: {
    getMessenger: _phishingControllerMessenger.getPhishingControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  RateLimitController: {
    getMessenger: _snaps.getRateLimitControllerMessenger,
    getInitMessenger: _snaps.getRateLimitControllerInitMessenger
  },
  RatesController: {
    getMessenger: _ratesControllerMessenger.getRatesControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  RemoteFeatureFlagController: {
    getMessenger: _remoteFeatureFlagControllerMessenger.getRemoteFeatureFlagControllerMessenger,
    getInitMessenger: _remoteFeatureFlagControllerMessenger.getRemoteFeatureFlagControllerInitMessenger
  },
  SeedlessOnboardingController: {
    getMessenger: _seedlessOnboarding.getSeedlessOnboardingControllerMessenger,
    getInitMessenger: _seedlessOnboarding.getSeedlessOnboardingControllerInitMessenger
  },
  SelectedNetworkController: {
    getMessenger: _selectedNetworkControllerMessenger.getSelectedNetworkControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  ShieldController: {
    getMessenger: _shieldControllerMessenger.getShieldControllerMessenger,
    getInitMessenger: _shieldControllerMessenger.getShieldControllerInitMessenger
  },
  SignatureController: {
    getMessenger: _signatureControllerMessenger.getSignatureControllerMessenger,
    getInitMessenger: _signatureControllerMessenger.getSignatureControllerInitMessenger
  },
  SnapsNameProvider: {
    getMessenger: _snaps.getSnapsNameProviderMessenger,
    getInitMessenger: _lodash.noop
  },
  SnapsRegistry: {
    getMessenger: _snaps.getSnapsRegistryMessenger,
    getInitMessenger: _lodash.noop
  },
  SnapController: {
    getMessenger: _snaps.getSnapControllerMessenger,
    getInitMessenger: _snaps.getSnapControllerInitMessenger
  },
  SnapInsightsController: {
    getMessenger: _snaps.getSnapInsightsControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  SnapInterfaceController: {
    getMessenger: _snaps.getSnapInterfaceControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  SnapKeyringBuilder: {
    getMessenger: _accounts.getSnapKeyringBuilderMessenger,
    getInitMessenger: _accounts.getSnapKeyringBuilderInitMessenger
  },
  SubjectMetadataController: {
    getMessenger: _subjectMetadataControllerMessenger.getSubjectMetadataControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  SubscriptionController: {
    getMessenger: _subscription.getSubscriptionControllerMessenger,
    getInitMessenger: _subscription.getSubscriptionControllerInitMessenger
  },
  SubscriptionService: {
    getMessenger: _subscriptionServiceMessenger.getSubscriptionServiceMessenger,
    getInitMessenger: _lodash.noop
  },
  SwapsController: {
    getMessenger: _swapsControllerMessenger.getSwapsControllerMessenger,
    getInitMessenger: _swapsControllerMessenger.getSwapsControllerInitMessenger
  },
  PPOMController: {
    getMessenger: _ppomControllerMessenger.getPPOMControllerMessenger,
    getInitMessenger: _ppomControllerMessenger.getPPOMControllerInitMessenger
  },
  PreferencesController: {
    getMessenger: _preferencesControllerMessenger.getPreferencesControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  TokenBalancesController: {
    getMessenger: _tokenBalancesControllerMessenger.getTokenBalancesControllerMessenger,
    getInitMessenger: _tokenBalancesControllerMessenger.getTokenBalancesControllerInitMessenger
  },
  TokenDetectionController: {
    getMessenger: _tokenDetectionControllerMessenger.getTokenDetectionControllerMessenger,
    getInitMessenger: _tokenDetectionControllerMessenger.getTokenDetectionControllerInitMessenger
  },
  TokenListController: {
    getMessenger: _tokenListControllerMessenger.getTokenListControllerMessenger,
    getInitMessenger: _tokenListControllerMessenger.getTokenListControllerInitMessenger
  },
  TokensController: {
    getMessenger: _tokensControllerMessenger.getTokensControllerMessenger,
    getInitMessenger: _tokensControllerMessenger.getTokensControllerInitMessenger
  },
  TransactionController: {
    getMessenger: _transactionControllerMessenger.getTransactionControllerMessenger,
    getInitMessenger: _transactionControllerMessenger.getTransactionControllerInitMessenger
  },
  UserOperationController: {
    getMessenger: _userOperationControllerMessenger.getUserOperationControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  UserStorageController: {
    getMessenger: _identity.getUserStorageControllerMessenger,
    getInitMessenger: _userStorageControllerMessenger.getUserStorageControllerInitMessenger
  },
  TokenRatesController: {
    getMessenger: _assets.getTokenRatesControllerMessenger,
    getInitMessenger: _assets.getTokenRatesControllerInitMessenger
  },
  NftController: {
    getMessenger: _assets.getNftControllerMessenger,
    getInitMessenger: _assets.getNftControllerInitMessenger
  },
  NftDetectionController: {
    getMessenger: _assets.getNftDetectionControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  AssetsContractController: {
    getMessenger: _assets.getAssetsContractControllerMessenger,
    getInitMessenger: _assets.getAssetsContractControllerInitMessenger
  },
  AccountTreeController: {
    getMessenger: _accounts.getAccountTreeControllerMessenger,
    getInitMessenger: _accounts.getAccountTreeControllerInitMessenger
  },
  WebSocketService: {
    getMessenger: _snaps.getWebSocketServiceMessenger,
    getInitMessenger: _lodash.noop
  },
  BackendWebSocketService: {
    getMessenger: _coreBackend.getBackendWebSocketServiceMessenger,
    getInitMessenger: _coreBackend.getBackendWebSocketServiceInitMessenger
  },
  AccountActivityService: {
    getMessenger: _coreBackend.getAccountActivityServiceMessenger,
    getInitMessenger: _lodash.noop
  },
  SmartTransactionsController: {
    getMessenger: _smartTransactionsControllerMessenger.getSmartTransactionsControllerMessenger,
    getInitMessenger: _smartTransactionsControllerMessenger.getSmartTransactionsControllerInitMessenger
  },
  MultichainAccountService: {
    getMessenger: _accounts.getMultichainAccountServiceMessenger,
    getInitMessenger: _accounts.getMultichainAccountServiceInitMessenger
  },
  NetworkOrderController: {
    getMessenger: _assets.getNetworkOrderControllerMessenger,
    getInitMessenger: _lodash.noop
  },
  NetworkEnablementController: {
    getMessenger: _assets.getNetworkEnablementControllerMessenger,
    getInitMessenger: _assets.getNetworkEnablementControllerInitMessenger
  }
};

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\index.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\keyring-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Ckeyring-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getKeyringControllerInitMessenger = getKeyringControllerInitMessenger;
exports.getKeyringControllerMessenger = getKeyringControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * keyring controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getKeyringControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'KeyringController',
    // This controller does not call any actions or subscribe to any events.
    allowedActions: [],
    allowedEvents: []
  });
}
/**
 * Create a messenger restricted to the allowed actions and events needed to
 * initialize the keyring controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getKeyringControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'KeyringControllerInit',
    allowedActions: ['AppStateController:requestQrCodeScan'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\keyring-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\logging-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Clogging-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLoggingControllerMessenger = getLoggingControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * logging controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getLoggingControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'LoggingController',
    // This controller does not call any actions or subscribe to any events.
    allowedActions: [],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\logging-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\metametrics-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cmetametrics-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMetaMetricsControllerMessenger = getMetaMetricsControllerMessenger;
function getMetaMetricsControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'MetaMetricsController',
    allowedActions: ['NetworkController:getNetworkClientById', 'NetworkController:getState', 'PreferencesController:getState'],
    allowedEvents: ['PreferencesController:stateChange', 'NetworkController:networkDidChange']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\metametrics-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\metametrics-data-deletion-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cmetametrics-data-deletion-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMetaMetricsDataDeletionControllerMessenger = getMetaMetricsDataDeletionControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * MetaMetrics data deletion controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getMetaMetricsDataDeletionControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'MetaMetricsDataDeletionController',
    allowedActions: ['MetaMetricsController:getState'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\metametrics-data-deletion-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\multichain\\index.ts", {"./multichain-assets-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\multichain\\multichain-assets-controller-messenger.ts","./multichain-assets-rates-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\multichain\\multichain-assets-rates-controller-messenger.ts","./multichain-balances-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\multichain\\multichain-balances-controller-messenger.ts","./multichain-network-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\multichain\\multichain-network-controller-messenger.ts","./multichain-transactions-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\multichain\\multichain-transactions-controller-messenger.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cmultichain%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "getMultichainAssetsControllerMessenger", {
  enumerable: true,
  get: function () {
    return _multichainAssetsControllerMessenger.getMultichainAssetsControllerMessenger;
  }
});
Object.defineProperty(exports, "getMultichainAssetsRatesControllerMessenger", {
  enumerable: true,
  get: function () {
    return _multichainAssetsRatesControllerMessenger.getMultichainAssetsRatesControllerMessenger;
  }
});
Object.defineProperty(exports, "getMultichainBalancesControllerMessenger", {
  enumerable: true,
  get: function () {
    return _multichainBalancesControllerMessenger.getMultichainBalancesControllerMessenger;
  }
});
Object.defineProperty(exports, "getMultichainNetworkControllerMessenger", {
  enumerable: true,
  get: function () {
    return _multichainNetworkControllerMessenger.getMultichainNetworkControllerMessenger;
  }
});
Object.defineProperty(exports, "getMultichainTransactionsControllerMessenger", {
  enumerable: true,
  get: function () {
    return _multichainTransactionsControllerMessenger.getMultichainTransactionsControllerMessenger;
  }
});
var _multichainAssetsControllerMessenger = require("./multichain-assets-controller-messenger");
var _multichainAssetsRatesControllerMessenger = require("./multichain-assets-rates-controller-messenger");
var _multichainBalancesControllerMessenger = require("./multichain-balances-controller-messenger");
var _multichainTransactionsControllerMessenger = require("./multichain-transactions-controller-messenger");
var _multichainNetworkControllerMessenger = require("./multichain-network-controller-messenger");

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\multichain\\index.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\multichain\\multichain-assets-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cmultichain%5Cmultichain-assets-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMultichainAssetsControllerMessenger = getMultichainAssetsControllerMessenger;
/**
 * Get a restricted messenger for the Multichain Assets controller. This is scoped to the
 * actions and events that the multichain Assets controller is allowed to handle.
 *
 * @param messenger - The controller messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getMultichainAssetsControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'MultichainAssetsController',
    allowedEvents: ['AccountsController:accountAdded', 'AccountsController:accountRemoved', 'AccountsController:accountAssetListUpdated'],
    allowedActions: ['PermissionController:getPermissions', 'SnapController:handleRequest', 'SnapController:getAll', 'AccountsController:listMultichainAccounts']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\multichain\\multichain-assets-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\multichain\\multichain-assets-rates-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cmultichain%5Cmultichain-assets-rates-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMultichainAssetsRatesControllerMessenger = getMultichainAssetsRatesControllerMessenger;
/**
 * Get a restricted messenger for the Multichain Assets Rate controller. This is scoped to the
 * actions and events that the multichain Assets Rate controller is allowed to handle.
 *
 * @param messenger - The controller messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getMultichainAssetsRatesControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'MultichainAssetsRatesController',
    allowedEvents: ['AccountsController:accountAdded', 'KeyringController:lock', 'KeyringController:unlock', 'CurrencyRateController:stateChange', 'MultichainAssetsController:accountAssetListUpdated'],
    allowedActions: ['AccountsController:listMultichainAccounts', 'SnapController:handleRequest', 'CurrencyRateController:getState', 'MultichainAssetsController:getState', 'AccountsController:getSelectedMultichainAccount']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\multichain\\multichain-assets-rates-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\multichain\\multichain-balances-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cmultichain%5Cmultichain-balances-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMultichainBalancesControllerMessenger = getMultichainBalancesControllerMessenger;
/**
 * Get a restricted messenger for the Multichain Balances controller. This is scoped to the
 * actions and events that the Multichain Balances controller is allowed to handle.
 *
 * @param messenger - The controller messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getMultichainBalancesControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'MultichainBalancesController',
    allowedEvents: ['AccountsController:accountAdded', 'AccountsController:accountRemoved', 'AccountsController:accountBalancesUpdated', 'MultichainAssetsController:accountAssetListUpdated'],
    allowedActions: ['AccountsController:listMultichainAccounts', 'SnapController:handleRequest', 'MultichainAssetsController:getState', 'KeyringController:getState']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\multichain\\multichain-balances-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\multichain\\multichain-network-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cmultichain%5Cmultichain-network-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMultichainNetworkControllerMessenger = getMultichainNetworkControllerMessenger;
/**
 * Get a restricted messenger for the Multichain Network controller. This is scoped to the
 * actions and events that the Multichain Network controller is allowed to handle.
 *
 * @param messenger - The controller messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getMultichainNetworkControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'MultichainNetworkController',
    allowedActions: ['NetworkController:setActiveNetwork', 'NetworkController:getState', 'NetworkController:removeNetwork', 'NetworkController:findNetworkClientIdByChainId', 'NetworkController:getSelectedChainId', 'AccountsController:listMultichainAccounts'],
    allowedEvents: ['AccountsController:selectedAccountChange']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\multichain\\multichain-network-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\multichain\\multichain-transactions-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cmultichain%5Cmultichain-transactions-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMultichainTransactionsControllerMessenger = getMultichainTransactionsControllerMessenger;
/**
 * Get a restricted messenger for the Multichain Transactions controller. This is scoped to the
 * actions and events that the Multichain Transactions controller is allowed to handle.
 *
 * @param messenger - The controller messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getMultichainTransactionsControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'MultichainTransactionsController',
    allowedEvents: ['AccountsController:accountAdded', 'AccountsController:accountRemoved', 'AccountsController:accountTransactionsUpdated'],
    allowedActions: ['AccountsController:listMultichainAccounts', 'SnapController:handleRequest', 'KeyringController:getState']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\multichain\\multichain-transactions-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\name-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cname-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNameControllerInitMessenger = getNameControllerInitMessenger;
exports.getNameControllerMessenger = getNameControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the name
 * controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getNameControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'NameController',
    // This controller does not call any actions or subscribe to any events.
    allowedActions: [],
    allowedEvents: []
  });
}
/**
 * Create a messenger restricted to the allowed actions and events needed during
 * initialization of the name controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getNameControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'NameControllerInit',
    allowedActions: ['PreferencesController:getState'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\name-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\network-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cnetwork-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNetworkControllerInitMessenger = getNetworkControllerInitMessenger;
exports.getNetworkControllerMessenger = getNetworkControllerMessenger;
/**
 * Get a messenger restricted to actions the NetworkController needs.
 *
 * @param messenger - The messenger to restrict.
 * @returns The restricted messenger.
 */
function getNetworkControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'NetworkController',
    allowedActions: ['ErrorReportingService:captureException'],
    allowedEvents: []
  });
}
/**
 * Get a messenger restricted to actions the NetworkController needs during
 * initialization.
 *
 * @param messenger - The messenger to restrict.
 * @returns The restricted messenger.
 */
function getNetworkControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'NetworkControllerInit',
    allowedActions: ['MetaMetricsController:getMetaMetricsId', 'MetaMetricsController:trackEvent'],
    allowedEvents: ['NetworkController:rpcEndpointUnavailable', 'NetworkController:rpcEndpointDegraded', 'RemoteFeatureFlagController:stateChange']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\network-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\notifications\\index.ts", {"./notification-services-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\notifications\\notification-services-controller-messenger.ts","./notification-services-push-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\notifications\\notification-services-push-controller-messenger.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cnotifications%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "getNotificationServicesControllerMessenger", {
  enumerable: true,
  get: function () {
    return _notificationServicesControllerMessenger.getNotificationServicesControllerMessenger;
  }
});
Object.defineProperty(exports, "getNotificationServicesPushControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _notificationServicesPushControllerMessenger.getNotificationServicesPushControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getNotificationServicesPushControllerMessenger", {
  enumerable: true,
  get: function () {
    return _notificationServicesPushControllerMessenger.getNotificationServicesPushControllerMessenger;
  }
});
var _notificationServicesControllerMessenger = require("./notification-services-controller-messenger");
var _notificationServicesPushControllerMessenger = require("./notification-services-push-controller-messenger");

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\notifications\\index.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\notifications\\notification-services-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cnotifications%5Cnotification-services-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNotificationServicesControllerMessenger = getNotificationServicesControllerMessenger;
function getNotificationServicesControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'NotificationServicesController',
    allowedActions: [
    // Keyring Actions
    'KeyringController:getState',
    // Auth Actions
    'AuthenticationController:getBearerToken', 'AuthenticationController:isSignedIn', 'AuthenticationController:performSignIn',
    // Push Actions
    'NotificationServicesPushController:enablePushNotifications', 'NotificationServicesPushController:disablePushNotifications', 'NotificationServicesPushController:subscribeToPushNotifications'],
    allowedEvents: [
    // Keyring Events
    'KeyringController:stateChange', 'KeyringController:lock', 'KeyringController:unlock',
    // Push Notification Events
    'NotificationServicesPushController:onNewNotifications', 'NotificationServicesPushController:stateChange']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\notifications\\notification-services-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\notifications\\notification-services-push-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cnotifications%5Cnotification-services-push-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNotificationServicesPushControllerInitMessenger = getNotificationServicesPushControllerInitMessenger;
exports.getNotificationServicesPushControllerMessenger = getNotificationServicesPushControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * notification services push controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 * @returns The restricted messenger.
 */
function getNotificationServicesPushControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'NotificationServicesPushController',
    allowedActions: ['AuthenticationController:getBearerToken'],
    allowedEvents: []
  });
}
/**
 * Create a messenger restricted to the allowed initialization actions of the
 * notification services push controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 * @returns The restricted messenger.
 */
function getNotificationServicesPushControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'NotificationServicesPushControllerInit',
    allowedActions: ['MetaMetricsController:trackEvent'],
    allowedEvents: ['NotificationServicesPushController:onNewNotifications', 'NotificationServicesPushController:pushNotificationClicked']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\notifications\\notification-services-push-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\onboarding-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Conboarding-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOnboardingControllerMessenger = getOnboardingControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * onboarding controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getOnboardingControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'OnboardingController',
    // This controller doesn't call any actions or subscribe to any events.
    allowedActions: [],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\onboarding-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\permission-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cpermission-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPermissionControllerInitMessenger = getPermissionControllerInitMessenger;
exports.getPermissionControllerMessenger = getPermissionControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * permission controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getPermissionControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'PermissionController',
    allowedActions: ['ApprovalController:addRequest', 'ApprovalController:hasRequest', 'ApprovalController:acceptRequest', 'ApprovalController:rejectRequest', 'SnapController:getPermitted', 'SnapController:install', 'SubjectMetadataController:getSubjectMetadata'],
    allowedEvents: []
  });
}
/**
 * Create a messenger restricted to the allowed actions and events needed to
 * initialize the permission controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getPermissionControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'PermissionControllerInit',
    allowedActions: ['AppStateController:getUnlockPromise', 'AccountsController:listAccounts', 'CurrencyRateController:getState', 'KeyringController:getKeyringsByType', 'KeyringController:withKeyring', 'MultichainRouter:isSupportedScope', 'MultichainRouter:getSupportedAccounts', 'NetworkController:findNetworkClientIdByChainId', 'PhishingController:maybeUpdateState', 'PhishingController:testOrigin', 'PreferencesController:getState', 'RateLimitController:call', 'SnapController:clearSnapState', 'SnapController:get', 'SnapController:getSnapState', 'SnapController:handleRequest', 'SnapController:updateSnapState', 'SnapInterfaceController:createInterface', 'SnapInterfaceController:getInterface'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\permission-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\permission-log-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cpermission-log-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPermissionLogControllerMessenger = getPermissionLogControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * permission log controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getPermissionLogControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'PermissionLogController',
    // This controller does not call any actions or subscribe to any events.
    allowedActions: [],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\permission-log-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\phishing-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cphishing-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPhishingControllerMessenger = getPhishingControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * phishing controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getPhishingControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'PhishingController',
    allowedActions: [],
    allowedEvents: ['TransactionController:stateChange']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\phishing-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\ppom-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cppom-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPPOMControllerInitMessenger = getPPOMControllerInitMessenger;
exports.getPPOMControllerMessenger = getPPOMControllerMessenger;
function getPPOMControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'PPOMController',
    allowedEvents: ['NetworkController:stateChange', 'NetworkController:networkDidChange'],
    allowedActions: ['NetworkController:getNetworkClientById']
  });
}
function getPPOMControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'PPOMControllerInit',
    allowedEvents: ['PreferencesController:stateChange'],
    allowedActions: ['NetworkController:getNetworkClientById', 'NetworkController:getSelectedNetworkClient', 'NetworkController:getState']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\ppom-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\preferences-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cpreferences-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPreferencesControllerMessenger = getPreferencesControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * preferences controller.
 *
 * @param messenger - The controller messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getPreferencesControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'PreferencesController',
    allowedActions: ['AccountsController:setSelectedAccount', 'AccountsController:getSelectedAccount', 'AccountsController:getAccountByAddress', 'AccountsController:setAccountName', 'NetworkController:getState'],
    allowedEvents: ['AccountsController:stateChange']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\preferences-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\rates-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Crates-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRatesControllerMessenger = getRatesControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * rates controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getRatesControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'RatesController',
    // This controller does not call any actions or subscribe to any events.
    allowedActions: [],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\rates-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\remote-feature-flag-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cremote-feature-flag-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRemoteFeatureFlagControllerInitMessenger = getRemoteFeatureFlagControllerInitMessenger;
exports.getRemoteFeatureFlagControllerMessenger = getRemoteFeatureFlagControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * remote feature flag controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getRemoteFeatureFlagControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'RemoteFeatureFlagController',
    // This controller does not call any actions or subscribe to any events.
    allowedActions: [],
    allowedEvents: []
  });
}
/**
 * Create a messenger restricted to the allowed actions and events needed to
 * initialize the account tracker controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getRemoteFeatureFlagControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'RemoteFeatureFlagControllerInit',
    allowedActions: ['MetaMetricsController:getMetaMetricsId', 'PreferencesController:getState'],
    allowedEvents: ['PreferencesController:stateChange']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\remote-feature-flag-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\seedless-onboarding\\index.ts", {"./oauth-service-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\seedless-onboarding\\oauth-service-messenger.ts","./seedless-onboarding-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\seedless-onboarding\\seedless-onboarding-controller-messenger.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cseedless-onboarding%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "getOAuthServiceMessenger", {
  enumerable: true,
  get: function () {
    return _oauthServiceMessenger.getOAuthServiceMessenger;
  }
});
Object.defineProperty(exports, "getSeedlessOnboardingControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _seedlessOnboardingControllerMessenger.getSeedlessOnboardingControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getSeedlessOnboardingControllerMessenger", {
  enumerable: true,
  get: function () {
    return _seedlessOnboardingControllerMessenger.getSeedlessOnboardingControllerMessenger;
  }
});
var _oauthServiceMessenger = require("./oauth-service-messenger");
var _seedlessOnboardingControllerMessenger = require("./seedless-onboarding-controller-messenger");

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\seedless-onboarding\\index.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\seedless-onboarding\\oauth-service-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cseedless-onboarding%5Coauth-service-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOAuthServiceMessenger = getOAuthServiceMessenger;
/**
 * Get a restricted messenger for the OAuthService. This is scoped to the
 * actions and events that the OAuthService is allowed to handle.
 *
 * @param messenger - The messenger to restrict.
 * @returns The restricted messenger.
 */
function getOAuthServiceMessenger(messenger) {
  return messenger.getRestricted({
    name: 'OAuthService',
    allowedActions: ['SeedlessOnboardingController:getState'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\seedless-onboarding\\oauth-service-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\seedless-onboarding\\seedless-onboarding-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cseedless-onboarding%5Cseedless-onboarding-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSeedlessOnboardingControllerInitMessenger = getSeedlessOnboardingControllerInitMessenger;
exports.getSeedlessOnboardingControllerMessenger = getSeedlessOnboardingControllerMessenger;
/**
 * Get a restricted messenger for the Seedless Onboarding controller. This is scoped to the
 * actions and events that the Seedless Onboarding controller is allowed to handle.
 *
 * @param messenger - The messenger to restrict.
 * @returns The restricted messenger.
 */
function getSeedlessOnboardingControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'SeedlessOnboardingController',
    allowedActions: [],
    allowedEvents: []
  });
}
/**
 * Get a restricted messenger for the seedless onboarding controller init. This
 * is scoped to the actions and events that the seedless onboarding controller
 * init is allowed to handle.
 *
 * @param messenger - The messenger to restrict.
 * @returns The restricted messenger.
 */
function getSeedlessOnboardingControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'SeedlessOnboardingControllerInit',
    allowedEvents: [],
    allowedActions: ['OAuthService:getNewRefreshToken', 'OAuthService:revokeRefreshToken', 'OAuthService:renewRefreshToken']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\seedless-onboarding\\seedless-onboarding-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\selected-network-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cselected-network-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSelectedNetworkControllerMessenger = getSelectedNetworkControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * selected network controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getSelectedNetworkControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'SelectedNetworkController',
    allowedActions: ['NetworkController:getNetworkClientById', 'NetworkController:getState', 'NetworkController:getSelectedNetworkClient', 'PermissionController:hasPermissions', 'PermissionController:getSubjectNames'],
    allowedEvents: ['NetworkController:stateChange', 'PermissionController:stateChange']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\selected-network-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\shield\\shield-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cshield%5Cshield-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getShieldControllerInitMessenger = getShieldControllerInitMessenger;
exports.getShieldControllerMessenger = getShieldControllerMessenger;
/**
 * Get a restricted messenger for the Shield controller. This is scoped to the
 * actions and events that the Shield controller is allowed to handle.
 *
 * @param messenger - The messenger to restrict.
 * @returns The restricted messenger.
 */
function getShieldControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'ShieldController',
    allowedActions: [],
    allowedEvents: ['SignatureController:stateChange', 'TransactionController:stateChange']
  });
}
function getShieldControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'ShieldControllerInit',
    allowedEvents: [],
    allowedActions: ['AuthenticationController:getBearerToken']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\shield\\shield-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\signature-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Csignature-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSignatureControllerInitMessenger = getSignatureControllerInitMessenger;
exports.getSignatureControllerMessenger = getSignatureControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * signature controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getSignatureControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'SignatureController',
    allowedActions: ['AccountsController:getState', 'ApprovalController:addRequest', 'KeyringController:signMessage', 'KeyringController:signPersonalMessage', 'KeyringController:signTypedMessage', 'LoggingController:add', 'NetworkController:getNetworkClientById', 'GatorPermissionsController:decodePermissionFromPermissionContextForOrigin'],
    allowedEvents: []
  });
}
/**
 * Create a messenger restricted to the allowed actions and events needed to
 * initialize the signature controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getSignatureControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'SignatureControllerInit',
    allowedActions: ['MetaMetricsController:trackEvent', 'PreferencesController:getState'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\signature-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\smart-transactions-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Csmart-transactions-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSmartTransactionsControllerInitMessenger = getSmartTransactionsControllerInitMessenger;
exports.getSmartTransactionsControllerMessenger = getSmartTransactionsControllerMessenger;
function getSmartTransactionsControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'SmartTransactionsController',
    allowedActions: ['NetworkController:getNetworkClientById', 'NetworkController:getState', 'TransactionController:getNonceLock', 'TransactionController:confirmExternalTransaction', 'TransactionController:getTransactions', 'TransactionController:updateTransaction'],
    allowedEvents: ['NetworkController:stateChange']
  });
}
/**
 * Get a restricted messenger for initializing the smart transactions controller.
 * This is scoped to the actions that are allowed during controller
 * initialization.
 *
 * @param messenger - The controller messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getSmartTransactionsControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'SmartTransactionsControllerInit',
    allowedActions: ['MetaMetricsController:trackEvent'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\smart-transactions-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\snaps\\cronjob-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Csnaps%5Ccronjob-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCronjobControllerMessenger = getCronjobControllerMessenger;
/**
 * Get a restricted messenger for the cronjob controller. This is scoped to the
 * actions and events that the cronjob controller is allowed to handle.
 *
 * @param messenger - The controller messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getCronjobControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'CronjobController',
    allowedEvents: ['SnapController:snapInstalled', 'SnapController:snapUpdated', 'SnapController:snapUninstalled', 'SnapController:snapEnabled', 'SnapController:snapDisabled'],
    allowedActions: ['PermissionController:getPermissions', 'SnapController:handleRequest']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\snaps\\cronjob-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\snaps\\execution-service-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Csnaps%5Cexecution-service-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExecutionServiceMessenger = getExecutionServiceMessenger;
/**
 * Get a restricted messenger for the execution service. This is scoped to the
 * actions and events that the execution service is allowed to handle.
 *
 * @param messenger - The messenger to restrict.
 * @returns The restricted messenger.
 */
function getExecutionServiceMessenger(messenger) {
  return messenger.getRestricted({
    name: 'ExecutionService',
    allowedEvents: [],
    allowedActions: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\snaps\\execution-service-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\snaps\\index.ts", {"./cronjob-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\snaps\\cronjob-controller-messenger.ts","./execution-service-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\snaps\\execution-service-messenger.ts","./multichain-router-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\snaps\\multichain-router-messenger.ts","./rate-limit-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\snaps\\rate-limit-controller-messenger.ts","./snap-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\snaps\\snap-controller-messenger.ts","./snap-insights-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\snaps\\snap-insights-controller-messenger.ts","./snap-interface-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\snaps\\snap-interface-controller-messenger.ts","./snaps-name-provider-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\snaps\\snaps-name-provider-messenger.ts","./snaps-registry-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\snaps\\snaps-registry-messenger.ts","./websocket-service-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\snaps\\websocket-service-messenger.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Csnaps%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "getCronjobControllerMessenger", {
  enumerable: true,
  get: function () {
    return _cronjobControllerMessenger.getCronjobControllerMessenger;
  }
});
Object.defineProperty(exports, "getExecutionServiceMessenger", {
  enumerable: true,
  get: function () {
    return _executionServiceMessenger.getExecutionServiceMessenger;
  }
});
Object.defineProperty(exports, "getMultichainRouterMessenger", {
  enumerable: true,
  get: function () {
    return _multichainRouterMessenger.getMultichainRouterMessenger;
  }
});
Object.defineProperty(exports, "getRateLimitControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _rateLimitControllerMessenger.getRateLimitControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getRateLimitControllerMessenger", {
  enumerable: true,
  get: function () {
    return _rateLimitControllerMessenger.getRateLimitControllerMessenger;
  }
});
Object.defineProperty(exports, "getSnapControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _snapControllerMessenger.getSnapControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getSnapControllerMessenger", {
  enumerable: true,
  get: function () {
    return _snapControllerMessenger.getSnapControllerMessenger;
  }
});
Object.defineProperty(exports, "getSnapInsightsControllerMessenger", {
  enumerable: true,
  get: function () {
    return _snapInsightsControllerMessenger.getSnapInsightsControllerMessenger;
  }
});
Object.defineProperty(exports, "getSnapInterfaceControllerMessenger", {
  enumerable: true,
  get: function () {
    return _snapInterfaceControllerMessenger.getSnapInterfaceControllerMessenger;
  }
});
Object.defineProperty(exports, "getSnapsNameProviderMessenger", {
  enumerable: true,
  get: function () {
    return _snapsNameProviderMessenger.getSnapsNameProviderMessenger;
  }
});
Object.defineProperty(exports, "getSnapsRegistryMessenger", {
  enumerable: true,
  get: function () {
    return _snapsRegistryMessenger.getSnapsRegistryMessenger;
  }
});
Object.defineProperty(exports, "getWebSocketServiceMessenger", {
  enumerable: true,
  get: function () {
    return _websocketServiceMessenger.getWebSocketServiceMessenger;
  }
});
var _cronjobControllerMessenger = require("./cronjob-controller-messenger");
var _executionServiceMessenger = require("./execution-service-messenger");
var _multichainRouterMessenger = require("./multichain-router-messenger");
var _rateLimitControllerMessenger = require("./rate-limit-controller-messenger");
var _snapControllerMessenger = require("./snap-controller-messenger");
var _snapInsightsControllerMessenger = require("./snap-insights-controller-messenger");
var _snapInterfaceControllerMessenger = require("./snap-interface-controller-messenger");
var _snapsNameProviderMessenger = require("./snaps-name-provider-messenger");
var _snapsRegistryMessenger = require("./snaps-registry-messenger");
var _websocketServiceMessenger = require("./websocket-service-messenger");

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\snaps\\index.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\snaps\\multichain-router-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Csnaps%5Cmultichain-router-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMultichainRouterMessenger = getMultichainRouterMessenger;
/**
 * Get a restricted messenger for the multichain router. This is scoped to the
 * actions and events that the multichain router is allowed to handle.
 *
 * @param messenger - The messenger to restrict.
 * @returns The restricted messenger.
 */
function getMultichainRouterMessenger(messenger) {
  return messenger.getRestricted({
    name: 'MultichainRouter',
    allowedActions: ['SnapController:getAll', 'SnapController:handleRequest', 'PermissionController:getPermissions', 'AccountsController:listMultichainAccounts'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\snaps\\multichain-router-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\snaps\\rate-limit-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Csnaps%5Crate-limit-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRateLimitControllerInitMessenger = getRateLimitControllerInitMessenger;
exports.getRateLimitControllerMessenger = getRateLimitControllerMessenger;
/**
 * Get a restricted controller messenger for the rate limit controller. This is
 * scoped to the actions and events that the rate limit controller is allowed to
 * handle.
 *
 * @param messenger - The messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getRateLimitControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'RateLimitController',
    allowedEvents: [],
    allowedActions: []
  });
}
/**
 * Get a restricted controller messenger for the rate limit controller. This is
 * scoped to the actions and events that the rate limit controller is allowed to
 * handle.
 *
 * @param messenger - The messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getRateLimitControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'RateLimitController',
    allowedActions: ['SubjectMetadataController:getState', 'NotificationServicesController:updateMetamaskNotificationsList'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\snaps\\rate-limit-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\snaps\\snap-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Csnaps%5Csnap-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSnapControllerInitMessenger = getSnapControllerInitMessenger;
exports.getSnapControllerMessenger = getSnapControllerMessenger;
/**
 * Get a restricted messenger for the Snap controller. This is scoped to the
 * actions and events that the Snap controller is allowed to handle.
 *
 * @param messenger - The messenger to restrict.
 * @returns The restricted messenger.
 */
function getSnapControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'SnapController',
    allowedEvents: ['ExecutionService:unhandledError', 'ExecutionService:outboundRequest', 'ExecutionService:outboundResponse', 'KeyringController:lock'],
    allowedActions: ['PermissionController:getEndowments', 'PermissionController:getPermissions', 'PermissionController:hasPermission', 'PermissionController:hasPermissions', 'PermissionController:requestPermissions', 'PermissionController:revokeAllPermissions', 'PermissionController:revokePermissions', 'PermissionController:revokePermissionForAllSubjects', 'PermissionController:getSubjectNames', 'PermissionController:updateCaveat', 'ApprovalController:addRequest', 'ApprovalController:updateRequestState', 'PermissionController:grantPermissions', 'SubjectMetadataController:getSubjectMetadata', 'SubjectMetadataController:addSubjectMetadata', 'ExecutionService:executeSnap', 'ExecutionService:terminateSnap', 'ExecutionService:terminateAllSnaps', 'ExecutionService:handleRpcRequest', 'NetworkController:getNetworkClientById', 'SelectedNetworkController:getNetworkClientIdForDomain', 'SnapsRegistry:get', 'SnapsRegistry:getMetadata', 'SnapsRegistry:update', 'SnapsRegistry:resolveVersion', 'SnapInterfaceController:createInterface', 'SnapInterfaceController:getInterface']
  });
}
/**
 * Get a restricted messenger for the Snap controller init. This is scoped to
 * the actions and events that the Snap controller init is allowed to handle.
 *
 * @param messenger - The messenger to restrict.
 * @returns The restricted messenger.
 */
function getSnapControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'SnapControllerInit',
    allowedEvents: [],
    allowedActions: ['KeyringController:getKeyringsByType', 'PreferencesController:getState', 'MetaMetricsController:trackEvent']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\snaps\\snap-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\snaps\\snap-insights-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Csnaps%5Csnap-insights-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSnapInsightsControllerMessenger = getSnapInsightsControllerMessenger;
/**
 * Get a restricted messenger for the Snap insights controller. This is scoped
 * to the actions and events that the Snap insights controller is allowed to
 * handle.
 *
 * @param messenger - The messenger to restrict.
 * @returns The restricted messenger.
 */
function getSnapInsightsControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'SnapInsightsController',
    allowedActions: ['SnapController:handleRequest', 'SnapController:getAll', 'PermissionController:getPermissions', 'SnapInterfaceController:deleteInterface'],
    allowedEvents: ['TransactionController:unapprovedTransactionAdded', 'TransactionController:transactionStatusUpdated', 'SignatureController:stateChange']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\snaps\\snap-insights-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\snaps\\snap-interface-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Csnaps%5Csnap-interface-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSnapInterfaceControllerMessenger = getSnapInterfaceControllerMessenger;
/**
 * Get a restricted messenger for the Snap interface controller. This is scoped
 * to the actions and events that the Snap interface controller is allowed to
 * handle.
 *
 * @param messenger - The messenger to restrict.
 * @returns The restricted messenger.
 */
function getSnapInterfaceControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'SnapInterfaceController',
    allowedActions: [`PhishingController:maybeUpdateState`, `PhishingController:testOrigin`, `ApprovalController:hasRequest`, `ApprovalController:acceptRequest`, `SnapController:get`, 'MultichainAssetsController:getState', `AccountsController:getSelectedMultichainAccount`, `AccountsController:getAccountByAddress`, `AccountsController:listMultichainAccounts`],
    allowedEvents: ['NotificationServicesController:notificationsListUpdated']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\snaps\\snap-interface-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\snaps\\snaps-name-provider-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Csnaps%5Csnaps-name-provider-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSnapsNameProviderMessenger = getSnapsNameProviderMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the Snaps
 * name provider.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getSnapsNameProviderMessenger(messenger) {
  return messenger.getRestricted({
    name: 'SnapsNameProvider',
    allowedActions: ['SnapController:getAll', 'SnapController:get', 'SnapController:handleRequest', 'PermissionController:getState'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\snaps\\snaps-name-provider-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\snaps\\snaps-registry-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Csnaps%5Csnaps-registry-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSnapsRegistryMessenger = getSnapsRegistryMessenger;
/**
 * Get a restricted messenger for the Snaps registry. This is scoped to the
 * actions and events that the Snaps registry is allowed to handle.
 *
 * @param controllerMessenger - The messenger to restrict.
 * @returns The restricted messenger.
 */
function getSnapsRegistryMessenger(controllerMessenger) {
  return controllerMessenger.getRestricted({
    name: 'SnapsRegistry',
    allowedEvents: [],
    allowedActions: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\snaps\\snaps-registry-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\snaps\\websocket-service-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Csnaps%5Cwebsocket-service-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getWebSocketServiceMessenger = getWebSocketServiceMessenger;
/**
 * Get a restricted messenger for the WebSocket service. This is scoped to the
 * actions and events that the WebSocket service is allowed to handle.
 *
 * @param messenger - The messenger to restrict.
 * @returns The restricted messenger.
 */
function getWebSocketServiceMessenger(messenger) {
  return messenger.getRestricted({
    name: 'WebSocketService',
    allowedActions: ['SnapController:handleRequest'],
    allowedEvents: ['SnapController:snapUpdated', 'SnapController:snapUninstalled', 'SnapController:snapInstalled']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\snaps\\websocket-service-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\subject-metadata-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Csubject-metadata-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSubjectMetadataControllerMessenger = getSubjectMetadataControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * subject metadata controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getSubjectMetadataControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'SubjectMetadataController',
    allowedActions: ['PermissionController:hasPermissions'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\subject-metadata-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\subscription\\index.ts", {"./subscription-controller-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\subscription\\subscription-controller-messenger.ts","./subscription-service-messenger":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\subscription\\subscription-service-messenger.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Csubscription%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "getSubscriptionControllerInitMessenger", {
  enumerable: true,
  get: function () {
    return _subscriptionControllerMessenger.getSubscriptionControllerInitMessenger;
  }
});
Object.defineProperty(exports, "getSubscriptionControllerMessenger", {
  enumerable: true,
  get: function () {
    return _subscriptionControllerMessenger.getSubscriptionControllerMessenger;
  }
});
Object.defineProperty(exports, "getSubscriptionServiceMessenger", {
  enumerable: true,
  get: function () {
    return _subscriptionServiceMessenger.getSubscriptionServiceMessenger;
  }
});
var _subscriptionControllerMessenger = require("./subscription-controller-messenger");
var _subscriptionServiceMessenger = require("./subscription-service-messenger");

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\subscription\\index.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\subscription\\subscription-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Csubscription%5Csubscription-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSubscriptionControllerInitMessenger = getSubscriptionControllerInitMessenger;
exports.getSubscriptionControllerMessenger = getSubscriptionControllerMessenger;
/**
 * Get a restricted messenger for the Subscription controller. This is scoped to the
 * actions and events that the Subscription controller is allowed to handle.
 *
 * @param messenger - The controller messenger to restrict.
 * @returns The restricted controller messenger.
 */
function getSubscriptionControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'SubscriptionController',
    allowedEvents: ['AuthenticationController:stateChange'],
    allowedActions: ['AuthenticationController:getBearerToken', 'AuthenticationController:performSignOut']
  });
}
function getSubscriptionControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'SubscriptionControllerInit',
    allowedEvents: [],
    allowedActions: ['AuthenticationController:getBearerToken']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\subscription\\subscription-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\subscription\\subscription-service-messenger.ts", {"../../../services/subscription/types":"D:\\code\\v\\metamask-extension\\app\\scripts\\services\\subscription\\types.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Csubscription%5Csubscription-service-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSubscriptionServiceMessenger = getSubscriptionServiceMessenger;
var _types = require("../../../services/subscription/types");
/**
 * Get a restricted messenger for the SubscriptionService. This is scoped to the
 * actions and events that the SubscriptionService is allowed to handle.
 *
 * @param messenger - The messenger to restrict.
 * @returns The restricted messenger.
 */
function getSubscriptionServiceMessenger(messenger) {
  return messenger.getRestricted({
    name: _types.SERVICE_NAME,
    allowedActions: ['SubscriptionController:getPricing', 'SubscriptionController:getSubscriptions', 'SubscriptionController:startShieldSubscriptionWithCard', 'SubscriptionController:updatePaymentMethod', 'SubscriptionController:getCryptoApproveTransactionParams', 'SubscriptionController:getBillingPortalUrl', 'AuthenticationController:getBearerToken'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\subscription\\subscription-service-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\swaps-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cswaps-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSwapsControllerInitMessenger = getSwapsControllerInitMessenger;
exports.getSwapsControllerMessenger = getSwapsControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * swaps controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getSwapsControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'SwapsController',
    allowedActions: ['NetworkController:getNetworkClientById', 'NetworkController:getState', 'TokenRatesController:getState'],
    allowedEvents: []
  });
}
/**
 * Create a messenger restricted to the allowed actions and events needed to
 * initialize the swaps controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getSwapsControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'SwapsControllerInit',
    allowedActions: ['MetaMetricsController:trackEvent', 'NetworkController:getState'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\swaps-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\token-balances-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Ctoken-balances-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTokenBalancesControllerInitMessenger = getTokenBalancesControllerInitMessenger;
exports.getTokenBalancesControllerMessenger = getTokenBalancesControllerMessenger;
// Not exported from `@metamask/assets-controllers`.

/**
 * Create a messenger restricted to the allowed actions and events of the
 * token balances controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getTokenBalancesControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'TokenBalancesController',
    allowedActions: ['NetworkController:getState', 'NetworkController:getNetworkClientById', 'TokensController:getState', 'PreferencesController:getState', 'AccountsController:getSelectedAccount', 'AccountsController:listAccounts', 'AccountTrackerController:getState', 'AccountTrackerController:updateNativeBalances', 'AccountTrackerController:updateStakedBalances', 'TokenDetectionController:addDetectedTokensViaWs'],
    allowedEvents: ['PreferencesController:stateChange', 'TokensController:stateChange', 'NetworkController:stateChange', 'KeyringController:accountRemoved', 'AccountActivityService:statusChanged', 'AccountActivityService:balanceUpdated']
  });
}
/**
 * Create a messenger restricted to the allowed actions and events needed during
 * initialization of the token balances controller.
 *
 * @param messenger
 */
function getTokenBalancesControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'TokenBalancesControllerInit',
    allowedActions: ['PreferencesController:getState', 'RemoteFeatureFlagController:getState'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\token-balances-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\token-detection-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Ctoken-detection-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTokenDetectionControllerInitMessenger = getTokenDetectionControllerInitMessenger;
exports.getTokenDetectionControllerMessenger = getTokenDetectionControllerMessenger;
// Not exported from `@metamask/assets-controllers`.

/**
 * Create a messenger restricted to the allowed actions and events of the
 * token detection controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getTokenDetectionControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'TokenDetectionController',
    allowedActions: ['AccountsController:getAccount', 'AccountsController:getSelectedAccount', 'KeyringController:getState', 'NetworkController:getNetworkClientById', 'NetworkController:getNetworkConfigurationByNetworkClientId', 'NetworkController:getState', 'PreferencesController:getState', 'TokenListController:getState', 'TokensController:getState', 'TokensController:addDetectedTokens', 'TokensController:addTokens', 'NetworkController:findNetworkClientIdByChainId'],
    allowedEvents: ['AccountsController:selectedEvmAccountChange', 'KeyringController:lock', 'KeyringController:unlock', 'NetworkController:networkDidChange', 'PreferencesController:stateChange', 'TokenListController:stateChange', 'TransactionController:transactionConfirmed']
  });
}
/**
 * Create a messenger restricted to the allowed actions and events needed during
 * initialization of the token detection controller.
 *
 * @param messenger
 */
function getTokenDetectionControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'TokenDetectionControllerInit',
    allowedActions: ['AssetsContractController:getBalancesInSingleCall', 'MetaMetricsController:trackEvent', 'PreferencesController:getState'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\token-detection-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\token-list-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Ctoken-list-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTokenListControllerInitMessenger = getTokenListControllerInitMessenger;
exports.getTokenListControllerMessenger = getTokenListControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * token list controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getTokenListControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'TokenListController',
    allowedActions: ['NetworkController:getNetworkClientById'],
    allowedEvents: ['NetworkController:stateChange']
  });
}
/**
 * Create a messenger restricted to the allowed actions and events needed during
 * initialization of the token list controller.
 *
 * @param messenger
 */
function getTokenListControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'TokenListControllerInit',
    allowedActions: ['NetworkController:getNetworkClientById', 'NetworkController:getState', 'PreferencesController:getState'],
    allowedEvents: ['PreferencesController:stateChange']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\token-list-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\tokens-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Ctokens-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTokensControllerInitMessenger = getTokensControllerInitMessenger;
exports.getTokensControllerMessenger = getTokensControllerMessenger;
// Not exported from `@metamask/assets-controllers`.

/**
 * Create a messenger restricted to the allowed actions and events of the
 * tokens controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getTokensControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'TokensController',
    allowedActions: ['AccountsController:getAccount', 'AccountsController:getSelectedAccount', 'AccountsController:listAccounts', 'ApprovalController:addRequest', 'NetworkController:getNetworkClientById'],
    allowedEvents: ['AccountsController:selectedEvmAccountChange', 'KeyringController:accountRemoved', 'NetworkController:networkDidChange', 'NetworkController:stateChange', 'PreferencesController:stateChange', 'TokenListController:stateChange']
  });
}
/**
 * Create a messenger restricted to the allowed actions and events needed during
 * initialization of the tokens controller.
 *
 * @param messenger
 */
function getTokensControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'TokensControllerInit',
    allowedActions: ['NetworkController:getNetworkClientById', 'NetworkController:getSelectedNetworkClient', 'NetworkController:getState'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\tokens-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\transaction-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Ctransaction-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransactionControllerInitMessenger = getTransactionControllerInitMessenger;
exports.getTransactionControllerMessenger = getTransactionControllerMessenger;
function getTransactionControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'TransactionController',
    allowedActions: ['AccountsController:getSelectedAccount', 'AccountsController:getState', `ApprovalController:addRequest`, 'KeyringController:signEip7702Authorization', 'NetworkController:findNetworkClientIdByChainId', 'NetworkController:getNetworkClientById', 'RemoteFeatureFlagController:getState'],
    allowedEvents: [`NetworkController:stateChange`]
  });
}
function getTransactionControllerInitMessenger(messenger) {
  return messenger.getRestricted({
    name: 'TransactionControllerInit',
    allowedEvents: ['SmartTransactionsController:smartTransaction', 'TransactionController:transactionApproved', 'TransactionController:transactionConfirmed', 'TransactionController:transactionDropped', 'TransactionController:transactionFailed', 'TransactionController:transactionNewSwapApproval', 'TransactionController:transactionNewSwap', 'TransactionController:transactionRejected', 'TransactionController:transactionSubmitted', 'TransactionController:postTransactionBalanceUpdated', 'TransactionController:unapprovedTransactionAdded'],
    allowedActions: ['ApprovalController:acceptRequest', 'ApprovalController:addRequest', 'ApprovalController:endFlow', 'ApprovalController:startFlow', 'ApprovalController:updateRequestState', 'AppStateController:getState', 'AuthenticationController:getBearerToken', 'DelegationController:signDelegation', 'InstitutionalSnapController:beforeCheckPendingTransactionHook', 'InstitutionalSnapController:publishHook', 'KeyringController:signEip7702Authorization', 'KeyringController:signTypedMessage', 'NetworkController:getEIP1559Compatibility', 'RemoteFeatureFlagController:getState', 'SwapsController:setApproveTxId', 'SwapsController:setTradeTxId', 'TransactionController:estimateGas', 'TransactionController:getState', 'SubscriptionController:getSubscriptionByProduct']
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\transaction-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\user-operation-controller-messenger.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmessengers%5Cuser-operation-controller-messenger.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUserOperationControllerMessenger = getUserOperationControllerMessenger;
/**
 * Create a messenger restricted to the allowed actions and events of the
 * user operation controller.
 *
 * @param messenger - The base messenger used to create the restricted
 * messenger.
 */
function getUserOperationControllerMessenger(messenger) {
  return messenger.getRestricted({
    name: 'UserOperationController',
    allowedActions: ['ApprovalController:addRequest', 'NetworkController:getNetworkClientById', 'KeyringController:prepareUserOperation', 'KeyringController:patchUserOperation', 'KeyringController:signUserOperation'],
    allowedEvents: []
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\messengers\\user-operation-controller-messenger.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\metametrics-controller-init.ts", {"../../../shared/lib/sentry":"D:\\code\\v\\metamask-extension\\shared\\lib\\sentry.ts","../controllers/metametrics-controller":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\metametrics-controller.ts","../lib/segment":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\segment\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmetametrics-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetaMetricsControllerInit = void 0;
var _metametricsController = _interopRequireDefault(require("../controllers/metametrics-controller"));
var _segment = require("../lib/segment");
var _sentry = require("../../../shared/lib/sentry");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Initialize the MetaMetrics controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @param request.extension
 * @returns The initialized controller.
 */
const MetaMetricsControllerInit = ({
  controllerMessenger,
  extension,
  persistedState
}) => {
  const controller = new _metametricsController.default({
    state: persistedState.MetaMetricsController,
    messenger: controllerMessenger,
    version: "13.6.0",
    environment: "development",
    segment: _segment.segment,
    extension,
    captureException: _sentry.captureException
  });
  return {
    controller
  };
};
exports.MetaMetricsControllerInit = MetaMetricsControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\metametrics-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\metametrics-data-deletion-controller-init.ts", {"../controllers/metametrics-data-deletion/metametrics-data-deletion":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\metametrics-data-deletion\\metametrics-data-deletion.ts","../services/data-deletion-service":"D:\\code\\v\\metamask-extension\\app\\scripts\\services\\data-deletion-service.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmetametrics-data-deletion-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetaMetricsDataDeletionControllerInit = void 0;
var _metametricsDataDeletion = require("../controllers/metametrics-data-deletion/metametrics-data-deletion");
var _dataDeletionService = require("../services/data-deletion-service");
/**
 * Initialize the MetaMetrics data deletion controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state to use for the
 * controller.
 * @returns The initialized controller.
 */
const MetaMetricsDataDeletionControllerInit = ({
  controllerMessenger,
  persistedState
}) => {
  const dataDeletionService = new _dataDeletionService.DataDeletionService();
  const controller = new _metametricsDataDeletion.MetaMetricsDataDeletionController({
    messenger: controllerMessenger,
    state: persistedState.MetaMetricsDataDeletionController,
    dataDeletionService
  });
  return {
    controller
  };
};
exports.MetaMetricsDataDeletionControllerInit = MetaMetricsDataDeletionControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\metametrics-data-deletion-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\multichain\\index.ts", {"./multichain-account-service-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\multichain\\multichain-account-service-init.ts","./multichain-assets-controller-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\multichain\\multichain-assets-controller-init.ts","./multichain-balances-controller-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\multichain\\multichain-balances-controller-init.ts","./multichain-network-controller-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\multichain\\multichain-network-controller-init.ts","./multichain-rates-assets-controller-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\multichain\\multichain-rates-assets-controller-init.ts","./multichain-transactions-controller-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\multichain\\multichain-transactions-controller-init.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmultichain%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "MultichainAccountServiceInit", {
  enumerable: true,
  get: function () {
    return _multichainAccountServiceInit.MultichainAccountServiceInit;
  }
});
Object.defineProperty(exports, "MultichainAssetsControllerInit", {
  enumerable: true,
  get: function () {
    return _multichainAssetsControllerInit.MultichainAssetsControllerInit;
  }
});
Object.defineProperty(exports, "MultichainAssetsRatesControllerInit", {
  enumerable: true,
  get: function () {
    return _multichainRatesAssetsControllerInit.MultichainAssetsRatesControllerInit;
  }
});
Object.defineProperty(exports, "MultichainBalancesControllerInit", {
  enumerable: true,
  get: function () {
    return _multichainBalancesControllerInit.MultichainBalancesControllerInit;
  }
});
Object.defineProperty(exports, "MultichainNetworkControllerInit", {
  enumerable: true,
  get: function () {
    return _multichainNetworkControllerInit.MultichainNetworkControllerInit;
  }
});
Object.defineProperty(exports, "MultichainTransactionsControllerInit", {
  enumerable: true,
  get: function () {
    return _multichainTransactionsControllerInit.MultichainTransactionsControllerInit;
  }
});
var _multichainAccountServiceInit = require("./multichain-account-service-init");
var _multichainAssetsControllerInit = require("./multichain-assets-controller-init");
var _multichainBalancesControllerInit = require("./multichain-balances-controller-init");
var _multichainTransactionsControllerInit = require("./multichain-transactions-controller-init");
var _multichainNetworkControllerInit = require("./multichain-network-controller-init");
var _multichainRatesAssetsControllerInit = require("./multichain-rates-assets-controller-init");

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\multichain\\index.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\multichain\\multichain-account-service-init.ts", {"../../../../shared/lib/multichain-accounts/remote-feature-flag":"D:\\code\\v\\metamask-extension\\shared\\lib\\multichain-accounts\\remote-feature-flag.ts","../../lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","@metamask/multichain-account-service":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmultichain%5Cmultichain-account-service-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainAccountServiceInit = void 0;
var _multichainAccountService = require("@metamask/multichain-account-service");
var _util = require("../../lib/util");
var _remoteFeatureFlag = require("../../../../shared/lib/multichain-accounts/remote-feature-flag");
/**
 * Initialize the multichain account service.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.initMessenger - The messenger to use for initialization.
 * @returns The initialized service.
 */
const MultichainAccountServiceInit = ({
  controllerMessenger,
  initMessenger
}) => {
  const controller = new _multichainAccountService.MultichainAccountService({
    messenger: controllerMessenger,
    providers: []
  });
  const preferencesState = initMessenger.call('PreferencesController:getState');
  initMessenger.subscribe('PreferencesController:stateChange', (0, _util.previousValueComparator)((prevState, currState) => {
    const {
      useExternalServices: prevUseExternalServices
    } = prevState;
    const {
      useExternalServices: currUseExternalServices
    } = currState;
    if (prevUseExternalServices !== currUseExternalServices) {
      // Only call MultichainAccountService if State 2 (BIP-44 multichain accounts) is enabled
      // to prevent unwanted account alignment from running
      const {
        remoteFeatureFlags
      } = initMessenger.call('RemoteFeatureFlagController:getState');
      const multichainAccountsFeatureFlag = remoteFeatureFlags === null || remoteFeatureFlags === void 0 ? void 0 : remoteFeatureFlags.enableMultichainAccountsState2;
      if ((0, _remoteFeatureFlag.isMultichainAccountsFeatureEnabled)(multichainAccountsFeatureFlag, _remoteFeatureFlag.FEATURE_VERSION_2)) {
        // Set basic functionality and trigger alignment when enabled
        // This single call handles both provider disable/enable and alignment.
        controller.setBasicFunctionality(currUseExternalServices).catch(error => {
          console.error('Failed to set basic functionality on MultichainAccountService:', error);
        });
      }
    }
    return true;
  }, preferencesState));
  return {
    memStateKey: null,
    persistedStateKey: null,
    controller
  };
};
exports.MultichainAccountServiceInit = MultichainAccountServiceInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\multichain\\multichain-account-service-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\multichain\\multichain-assets-controller-init.ts", {"@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmultichain%5Cmultichain-assets-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainAssetsControllerInit = void 0;
var _assetsControllers = require("@metamask/assets-controllers");
/**
 * Initialize the Multichain Assets controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @returns The initialized controller.
 */
const MultichainAssetsControllerInit = ({
  controllerMessenger,
  persistedState
}) => {
  const controller = new _assetsControllers.MultichainAssetsController({
    messenger: controllerMessenger,
    state: persistedState.MultichainAssetsController
  });
  return {
    controller
  };
};
exports.MultichainAssetsControllerInit = MultichainAssetsControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\multichain\\multichain-assets-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\multichain\\multichain-balances-controller-init.ts", {"@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmultichain%5Cmultichain-balances-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainBalancesControllerInit = void 0;
var _assetsControllers = require("@metamask/assets-controllers");
/**
 * Initialize the Multichain Balances controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @returns The initialized controller.
 */
const MultichainBalancesControllerInit = ({
  controllerMessenger,
  persistedState
}) => {
  const controller = new _assetsControllers.MultichainBalancesController({
    messenger: controllerMessenger,
    state: persistedState.MultichainBalancesController
  });
  return {
    controller
  };
};
exports.MultichainBalancesControllerInit = MultichainBalancesControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\multichain\\multichain-balances-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\multichain\\multichain-network-controller-init.ts", {"./multichain-network-service-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\multichain\\multichain-network-service-init.ts","@metamask/multichain-network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmultichain%5Cmultichain-network-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainNetworkControllerInit = void 0;
var _multichainNetworkController = require("@metamask/multichain-network-controller");
var _multichainNetworkServiceInit = require("./multichain-network-service-init");
/**
 * Initialize the Multichain Network controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @returns The initialized controller.
 */
const MultichainNetworkControllerInit = ({
  controllerMessenger,
  persistedState
}) => {
  const networkService = (0, _multichainNetworkServiceInit.MultichainNetworkServiceInit)();
  const controller = new _multichainNetworkController.MultichainNetworkController({
    messenger: controllerMessenger,
    state: persistedState.MultichainNetworkController,
    networkService
  });
  return {
    controller
  };
};
exports.MultichainNetworkControllerInit = MultichainNetworkControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\multichain\\multichain-network-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\multichain\\multichain-network-service-init.ts", {"@metamask/multichain-network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmultichain%5Cmultichain-network-service-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainNetworkServiceInit = void 0;
var _multichainNetworkController = require("@metamask/multichain-network-controller");
/**
 * Initialize the Multichain Network service controller.
 *
 * @returns The initialized controller.
 */

const MultichainNetworkServiceInit = () => new _multichainNetworkController.MultichainNetworkService({
  fetch: window.fetch.bind(window)
});
exports.MultichainNetworkServiceInit = MultichainNetworkServiceInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\multichain\\multichain-network-service-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\multichain\\multichain-rates-assets-controller-init.ts", {"@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmultichain%5Cmultichain-rates-assets-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainAssetsRatesControllerInit = void 0;
var _assetsControllers = require("@metamask/assets-controllers");
/**
 * Initialize the Multichain Assets Rate controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @returns The initialized controller.
 */
const MultichainAssetsRatesControllerInit = ({
  controllerMessenger,
  persistedState
}) => {
  const controller = new _assetsControllers.MultichainAssetsRatesController({
    messenger: controllerMessenger,
    state: persistedState.MultichainAssetsRatesController,
    interval: 1000 * 60 * 3 // 3 mins
  });
  return {
    controller
  };
};
exports.MultichainAssetsRatesControllerInit = MultichainAssetsRatesControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\multichain\\multichain-rates-assets-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\multichain\\multichain-transactions-controller-init.ts", {"@metamask/multichain-transactions-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-transactions-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cmultichain%5Cmultichain-transactions-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainTransactionsControllerInit = void 0;
var _multichainTransactionsController = require("@metamask/multichain-transactions-controller");
/**
 * Initialize the Multichain Transactions controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @returns The initialized controller.
 */
const MultichainTransactionsControllerInit = ({
  controllerMessenger,
  persistedState
}) => {
  const controller = new _multichainTransactionsController.MultichainTransactionsController({
    messenger: controllerMessenger,
    state: persistedState.MultichainTransactionsController
  });
  return {
    controller
  };
};
exports.MultichainTransactionsControllerInit = MultichainTransactionsControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\multichain\\multichain-transactions-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\network-controller-init.ts", {"../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../shared/lib/network-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\network-utils.ts","../../../shared/lib/sentry":"D:\\code\\v\\metamask-extension\\shared\\lib\\sentry.ts","../lib/network-controller/messenger-action-handlers":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\network-controller\\messenger-action-handlers.ts","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cnetwork-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkControllerInit = exports.ADDITIONAL_DEFAULT_NETWORKS = void 0;
var _networkController = require("@metamask/network-controller");
var _controllerUtils = require("@metamask/controller-utils");
var _utils = require("@metamask/utils");
var _time = require("../../../shared/constants/time");
var _networkUtils = require("../../../shared/lib/network-utils");
var _messengerActionHandlers = require("../lib/network-controller/messenger-action-handlers");
var _network = require("../../../shared/constants/network");
var _sentry = require("../../../shared/lib/sentry");
const ADDITIONAL_DEFAULT_NETWORKS = exports.ADDITIONAL_DEFAULT_NETWORKS = [_controllerUtils.ChainId['megaeth-testnet'], _controllerUtils.ChainId['monad-testnet']];
function getInitialState(initialState) {
  let initialNetworkControllerState = initialState;
  if (!initialNetworkControllerState) {
    initialNetworkControllerState = (0, _networkController.getDefaultNetworkControllerState)(ADDITIONAL_DEFAULT_NETWORKS);
    const networks = initialNetworkControllerState.networkConfigurationsByChainId ?? {};

    // TODO: Consider changing `getDefaultNetworkControllerState` on the
    // controller side to include some of these tweaks.

    Object.values(networks).forEach(network => {
      const id = network.rpcEndpoints[0].networkClientId;
      // Process only if the default network has a corresponding networkClientId
      // in BlockExplorerUrl.
      if ((0, _utils.hasProperty)(_controllerUtils.BlockExplorerUrl, id)) {
        network.blockExplorerUrls = [_controllerUtils.BlockExplorerUrl[id]];
      }
      network.defaultBlockExplorerUrlIndex = 0;
    });

    // Add failovers for default Infura RPC endpoints
    networks[_network.CHAIN_IDS.MAINNET].rpcEndpoints[0].failoverUrls = (0, _network.getFailoverUrlsForInfuraNetwork)('ethereum-mainnet');
    networks[_network.CHAIN_IDS.LINEA_MAINNET].rpcEndpoints[0].failoverUrls = (0, _network.getFailoverUrlsForInfuraNetwork)('linea-mainnet');
    networks[_network.CHAIN_IDS.BASE].rpcEndpoints[0].failoverUrls = (0, _network.getFailoverUrlsForInfuraNetwork)('base-mainnet');

    // Update default popular network names.
    networks[_network.CHAIN_IDS.MAINNET].name = 'Ethereum';
    networks[_network.CHAIN_IDS.LINEA_MAINNET].name = 'Linea';
    networks[_network.CHAIN_IDS.BASE].name = 'Base';
    let network;
    if (false) {
      network = {
        chainId: _network.CHAIN_IDS.LOCALHOST,
        name: 'Localhost 8545',
        nativeCurrency: 'ETH',
        blockExplorerUrls: [],
        defaultRpcEndpointIndex: 0,
        rpcEndpoints: [{
          networkClientId: 'networkConfigurationId',
          url: 'http://localhost:8545',
          type: _networkController.RpcEndpointType.Custom,
          failoverUrls: []
        }]
      };
      networks[_network.CHAIN_IDS.LOCALHOST] = network;
    } else if (true || "development" === 'test') {
      network = networks[_network.CHAIN_IDS.SEPOLIA];
    } else {
      network = networks[_network.CHAIN_IDS.MAINNET];
    }
    initialNetworkControllerState.selectedNetworkClientId = network.rpcEndpoints[network.defaultRpcEndpointIndex].networkClientId;
  }

  // Fix the network controller state (selectedNetworkClientId) if it is invalid and report the error
  if (initialNetworkControllerState.networkConfigurationsByChainId && !Object.values(initialNetworkControllerState.networkConfigurationsByChainId).flatMap(networkConfiguration => networkConfiguration.rpcEndpoints.map(rpcEndpoint => rpcEndpoint.networkClientId)).includes(initialNetworkControllerState.selectedNetworkClientId)) {
    (0, _sentry.captureException)(new Error(`NetworkController state is invalid: \`selectedNetworkClientId\` '${initialNetworkControllerState.selectedNetworkClientId}' does not refer to an RPC endpoint within a network configuration`));
    initialNetworkControllerState.selectedNetworkClientId = initialNetworkControllerState.networkConfigurationsByChainId[_network.CHAIN_IDS.MAINNET].rpcEndpoints[0].networkClientId;
  }
  return initialNetworkControllerState;
}

/**
 * Initialize the network controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @param request.infuraProjectId - The Infura project ID to use.
 * @param request.initMessenger
 * @returns The initialized controller.
 */
const NetworkControllerInit = ({
  controllerMessenger,
  infuraProjectId,
  initMessenger,
  persistedState
}) => {
  const initialState = getInitialState(persistedState.NetworkController);
  const getBlockTrackerOptions = () => {
    return false ? {} : {
      pollingInterval: 20 * _time.SECOND,
      // The retry timeout is pretty short by default, and if the endpoint is
      // down, it will end up exhausting the max number of consecutive
      // failures quickly.
      retryTimeout: 20 * _time.SECOND
    };
  };
  const getRpcServiceOptions = rpcEndpointUrl => {
    const maxRetries = 4;
    const commonOptions = {
      fetch: globalThis.fetch.bind(globalThis),
      btoa: globalThis.btoa.bind(globalThis)
    };
    if ((0, _networkUtils.getIsQuicknodeEndpointUrl)(rpcEndpointUrl)) {
      return {
        ...commonOptions,
        policyOptions: {
          maxRetries,
          // When we fail over to Quicknode, we expect it to be down at
          // first while it is being automatically activated. If an endpoint
          // is down, the failover logic enters a "cooldown period" of 30
          // minutes. We'd really rather not enter that for Quicknode, so
          // keep retrying longer.
          maxConsecutiveFailures: (maxRetries + 1) * 14
        }
      };
    }
    return {
      ...commonOptions,
      policyOptions: {
        maxRetries,
        // Ensure that the circuit does not break too quickly.
        maxConsecutiveFailures: (maxRetries + 1) * 7
      }
    };
  };
  const controller = new _networkController.NetworkController({
    messenger: controllerMessenger,
    state: initialState,
    infuraProjectId,
    getBlockTrackerOptions,
    getRpcServiceOptions,
    additionalDefaultNetworks: ADDITIONAL_DEFAULT_NETWORKS
  });
  initMessenger.subscribe('NetworkController:rpcEndpointUnavailable', async ({
    chainId,
    endpointUrl,
    error
  }) => {
    (0, _messengerActionHandlers.onRpcEndpointUnavailable)({
      chainId,
      endpointUrl,
      error,
      infuraProjectId,
      trackEvent: initMessenger.call.bind(initMessenger, 'MetaMetricsController:trackEvent'),
      metaMetricsId: initMessenger.call('MetaMetricsController:getMetaMetricsId')
    });
  });
  initMessenger.subscribe('NetworkController:rpcEndpointDegraded', async ({
    chainId,
    endpointUrl,
    error
  }) => {
    (0, _messengerActionHandlers.onRpcEndpointDegraded)({
      chainId,
      endpointUrl,
      error,
      infuraProjectId,
      trackEvent: initMessenger.call.bind(initMessenger, 'MetaMetricsController:trackEvent'),
      metaMetricsId: initMessenger.call('MetaMetricsController:getMetaMetricsId')
    });
  });
  initMessenger.subscribe('RemoteFeatureFlagController:stateChange', isRpcFailoverEnabled => {
    if (isRpcFailoverEnabled) {
      console.log('Enabling RPC failover.');
      controller.enableRpcFailover();
    } else {
      console.log('Disabling RPC failover.');
      controller.disableRpcFailover();
    }
  }, state => state.remoteFeatureFlags.walletFrameworkRpcFailoverEnabled);
  controller.initializeProvider();
  return {
    controller
  };
};
exports.NetworkControllerInit = NetworkControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\network-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\notifications\\notification-services-controller-init.ts", {"../../../../package.json":"D:\\code\\v\\metamask-extension\\package.json","@metamask/notification-services-controller/notification-services":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\NotificationServicesController\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cnotifications%5Cnotification-services-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationServicesControllerInit = void 0;
var _notificationServices = require("@metamask/notification-services-controller/notification-services");
var _package = _interopRequireDefault(require("../../../../package.json"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const APP_VERSION = _package.default.version;
const NotificationServicesControllerInit = ({
  controllerMessenger,
  persistedState
}) => {
  const controller = new _notificationServices.Controller({
    messenger: controllerMessenger,
    state: persistedState.NotificationServicesController,
    env: {
      featureAnnouncements: {
        platform: 'extension',
        spaceId: null ?? ':spaceId',
        accessToken: null ?? ':accessToken',
        platformVersion: APP_VERSION
      }
    }
  });
  return {
    controller
  };
};
exports.NotificationServicesControllerInit = NotificationServicesControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\notifications\\notification-services-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\notifications\\notification-services-push-controller-init.ts", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/modules/mv3.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\mv3.utils.js","../../controllers/push-notifications":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\push-notifications\\index.ts","@metamask/notification-services-controller/push-services":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\NotificationServicesPushController\\index.cjs","@metamask/notification-services-controller/push-services/web":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\NotificationServicesPushController\\web\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cnotifications%5Cnotification-services-push-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNormalisedLocale = exports.NotificationServicesPushControllerInit = void 0;
var _pushServices = require("@metamask/notification-services-controller/push-services");
var _web = require("@metamask/notification-services-controller/push-services/web");
var _utils = require("@metamask/utils");
var _mv = require("../../../../shared/modules/mv3.utils");
var _pushNotifications = require("../../controllers/push-notifications");
var _metametrics = require("../../../../shared/constants/metametrics");
/**
 * normalises the extension locale path to use hyphens ('-') instead of underscores ('_')
 *
 * @param locale - extension locale
 * @returns normalised locale
 */
const getNormalisedLocale = locale => locale.replace('_', '-');
exports.getNormalisedLocale = getNormalisedLocale;
const NotificationServicesPushControllerInit = ({
  controllerMessenger,
  initMessenger,
  persistedState,
  getController
}) => {
  const controller = new _pushServices.Controller({
    messenger: controllerMessenger,
    state: {
      ..._pushServices.defaultState,
      ...persistedState.NotificationServicesPushController
    },
    env: {
      apiKey: null ?? '',
      authDomain: null ?? '',
      storageBucket: null ?? '',
      projectId: null ?? '',
      messagingSenderId: null ?? '',
      appId: null ?? '',
      measurementId: null ?? '',
      vapidKey: null ?? ''
    },
    config: {
      isPushFeatureEnabled: _mv.isManifestV3 && !false,
      platform: 'extension',
      pushService: {
        createRegToken: _web.createRegToken,
        deleteRegToken: _web.deleteRegToken,
        subscribeToPushNotifications: (0, _web.createSubscribeToPushNotifications)({
          messenger: controllerMessenger,
          onReceivedHandler: _pushNotifications.onPushNotificationReceived,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
          // eslint-disable-next-line @typescript-eslint/no-misused-promises
          onClickHandler: _pushNotifications.onPushNotificationClicked
        })
      },
      getLocale: () => getNormalisedLocale(getController('PreferencesController').state.currentLocale)
    }
  });
  initMessenger.subscribe('NotificationServicesPushController:onNewNotifications', notification => {
    const chainId = (0, _utils.hasProperty)(notification, 'chain_id') ? notification.chain_id : null;
    initMessenger.call('MetaMetricsController:trackEvent', {
      category: _metametrics.MetaMetricsEventCategory.PushNotifications,
      event: _metametrics.MetaMetricsEventName.PushNotificationReceived,
      properties: {
        /* eslint-disable @typescript-eslint/naming-convention */
        notification_id: notification.id,
        notification_type: notification.type,
        chain_id: chainId
        /* eslint-enable @typescript-eslint/naming-convention */
      }
    });
  });
  initMessenger.subscribe('NotificationServicesPushController:pushNotificationClicked', notification => {
    const chainId = (0, _utils.hasProperty)(notification, 'chain_id') ? notification.chain_id : null;
    initMessenger.call('MetaMetricsController:trackEvent', {
      category: _metametrics.MetaMetricsEventCategory.PushNotifications,
      event: _metametrics.MetaMetricsEventName.PushNotificationClicked,
      properties: {
        /* eslint-disable @typescript-eslint/naming-convention */
        notification_id: notification.id,
        notification_type: notification.type,
        chain_id: chainId
        /* eslint-enable @typescript-eslint/naming-convention */
      }
    });
  });
  return {
    controller
  };
};
exports.NotificationServicesPushControllerInit = NotificationServicesPushControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\notifications\\notification-services-push-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\onboarding-controller-init.ts", {"../controllers/onboarding":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\onboarding.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Conboarding-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnboardingControllerInit = void 0;
var _onboarding = _interopRequireDefault(require("../controllers/onboarding"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Initialize the onboarding controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @returns The initialized controller.
 */
const OnboardingControllerInit = ({
  controllerMessenger,
  persistedState
}) => {
  const controller = new _onboarding.default({
    state: persistedState.OnboardingController,
    messenger: controllerMessenger
  });
  return {
    controller
  };
};
exports.OnboardingControllerInit = OnboardingControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\onboarding-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\permission-controller-init.ts", {"../controllers/permissions":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\permissions\\index.js","../controllers/permissions/snaps/specifications":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\permissions\\snaps\\specifications.ts","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cpermission-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PermissionControllerInit = void 0;
var _permissionController = require("@metamask/permission-controller");
var _permissions = require("../controllers/permissions");
var _specifications = require("../controllers/permissions/snaps/specifications");
/**
 * Initialize the permission controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @param request.initMessenger
 * @param request.getController
 * @returns The initialized controller.
 */
const PermissionControllerInit = ({
  controllerMessenger,
  persistedState,
  initMessenger,
  getController
}) => {
  const approvalController = getController('ApprovalController');
  const keyringController = getController('KeyringController');
  const controller = new _permissionController.PermissionController({
    state: persistedState.PermissionController,
    // @ts-expect-error: The permission controller needs certain actions that
    // are not declared in the messenger's type.
    messenger: controllerMessenger,
    caveatSpecifications: (0, _permissions.getCaveatSpecifications)({
      listAccounts: initMessenger.call.bind(initMessenger, 'AccountsController:listAccounts'),
      findNetworkClientIdByChainId: initMessenger.call.bind(initMessenger, 'NetworkController:findNetworkClientIdByChainId'),
      isNonEvmScopeSupported: initMessenger.call.bind(initMessenger, 'MultichainRouter:isSupportedScope'),
      getNonEvmAccountAddresses: initMessenger.call.bind(initMessenger, 'MultichainRouter:getSupportedAccounts')
    }),
    permissionSpecifications: {
      ...(0, _permissions.getPermissionSpecifications)(),
      ...(0, _specifications.getSnapPermissionSpecifications)(initMessenger, {
        addAndShowApprovalRequest: approvalController.addAndShowApprovalRequest.bind(approvalController),
        addNewKeyring: keyringController.addNewKeyring.bind(keyringController)
      })
    },
    unrestrictedMethods: _permissions.unrestrictedMethods
  });
  return {
    controller
  };
};
exports.PermissionControllerInit = PermissionControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\permission-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\permission-log-controller-init.ts", {"../../../shared/constants/permissions":"D:\\code\\v\\metamask-extension\\shared\\constants\\permissions.ts","@metamask/permission-log-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-log-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cpermission-log-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PermissionLogControllerInit = void 0;
var _permissionLogController = require("@metamask/permission-log-controller");
var _permissions = require("../../../shared/constants/permissions");
/**
 * Initialize the permission log controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @returns The initialized controller.
 */
const PermissionLogControllerInit = ({
  controllerMessenger,
  persistedState
}) => {
  const controller = new _permissionLogController.PermissionLogController({
    messenger: controllerMessenger,
    state: persistedState.PermissionLogController,
    restrictedMethods: new Set(Object.keys(_permissions.RestrictedMethods))
  });
  return {
    controller
  };
};
exports.PermissionLogControllerInit = PermissionLogControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\permission-log-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\phishing-controller-init.ts", {"@metamask/phishing-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\phishing-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cphishing-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PhishingControllerInit = void 0;
var _phishingController = require("@metamask/phishing-controller");
var _utils = require("@metamask/utils");
/**
 * Initialize the phishing controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state to use for the
 * controller.
 * @returns The initialized controller.
 */
const PhishingControllerInit = ({
  controllerMessenger,
  persistedState
}) => {
  const controller = new _phishingController.PhishingController({
    messenger: controllerMessenger,
    state: persistedState.PhishingController,
    hotlistRefreshInterval: false ? (0, _utils.inMilliseconds)(5, _utils.Duration.Second) : undefined,
    stalelistRefreshInterval: false ? (0, _utils.inMilliseconds)(30, _utils.Duration.Second) : undefined
  });
  return {
    controller
  };
};
exports.PhishingControllerInit = PhishingControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\phishing-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\preferences-controller-init.ts", {"../controllers/preferences-controller":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\preferences-controller.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cpreferences-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreferencesControllerInit = void 0;
var _preferencesController = require("../controllers/preferences-controller");
/**
 * Initialize the preferences controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @param request.initLangCode
 * @returns The initialized controller.
 */
const PreferencesControllerInit = ({
  controllerMessenger,
  persistedState,
  initLangCode
}) => {
  const controller = new _preferencesController.PreferencesController({
    state: {
      currentLocale: initLangCode ?? '',
      ...persistedState.PreferencesController
    },
    messenger: controllerMessenger
  });
  return {
    controller
  };
};
exports.PreferencesControllerInit = PreferencesControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\preferences-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\rates-controller-init.ts", {"@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Crates-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RatesControllerInit = void 0;
var _assetsControllers = require("@metamask/assets-controllers");
/**
 * Initialize the rates controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @returns The initialized controller.
 */
const RatesControllerInit = ({
  controllerMessenger,
  persistedState
}) => {
  const controller = new _assetsControllers.RatesController({
    // @ts-expect-error: `RatesController` is persisted as
    // `MultichainRatesController`, but the controller init pattern doesn't
    // allow this in the type of `persistedState`.
    state: persistedState.MultichainRatesController,
    messenger: controllerMessenger,
    includeUsdRate: true
  });
  return {
    memStateKey: 'MultichainRatesController',
    persistedStateKey: 'MultichainRatesController',
    controller
  };
};
exports.RatesControllerInit = RatesControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\rates-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\remote-feature-flag-controller-init.ts", {"../../../development/build/constants":"D:\\code\\v\\metamask-extension\\development\\build\\constants.js","../lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","@metamask/remote-feature-flag-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\remote-feature-flag-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cremote-feature-flag-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteFeatureFlagControllerInit = void 0;
exports.getConfigForRemoteFeatureFlagRequest = getConfigForRemoteFeatureFlagRequest;
var _utils = require("@metamask/utils");
var _remoteFeatureFlagController = require("@metamask/remote-feature-flag-controller");
var _constants = require("../../../development/build/constants");
var _util = require("../lib/util");
const BUILD_TYPE_MAPPING = {
  flask: _remoteFeatureFlagController.DistributionType.Flask,
  main: _remoteFeatureFlagController.DistributionType.Main,
  beta: _remoteFeatureFlagController.DistributionType.Beta,
  // Experimental builds use main distribution.
  experimental: _remoteFeatureFlagController.DistributionType.Main
};
const ENVIRONMENT_MAPPING = {
  [_constants.ENVIRONMENT.DEVELOPMENT]: _remoteFeatureFlagController.EnvironmentType.Development,
  [_constants.ENVIRONMENT.RELEASE_CANDIDATE]: _remoteFeatureFlagController.EnvironmentType.ReleaseCandidate,
  [_constants.ENVIRONMENT.PRODUCTION]: _remoteFeatureFlagController.EnvironmentType.Production
};
function getConfigForRemoteFeatureFlagRequest() {
  (0, _utils.assert)("main", 'METAMASK_BUILD_TYPE is not defined');
  (0, _utils.assert)("development", 'METAMASK_ENVIRONMENT is not defined');
  const distribution = BUILD_TYPE_MAPPING["main"] || _remoteFeatureFlagController.DistributionType.Main;
  const environment = ENVIRONMENT_MAPPING["development"] || _remoteFeatureFlagController.EnvironmentType.Development;
  return {
    distribution,
    environment
  };
}

/**
 * Initialize the remote feature flag controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.initMessenger - The messenger to use for initialization.
 * @returns The initialized controller.
 */
const RemoteFeatureFlagControllerInit = ({
  controllerMessenger,
  initMessenger
}) => {
  const preferencesState = initMessenger.call('PreferencesController:getState');
  const {
    distribution,
    environment
  } = getConfigForRemoteFeatureFlagRequest();
  const controller = new _remoteFeatureFlagController.RemoteFeatureFlagController({
    messenger: controllerMessenger,
    fetchInterval: 15 * 60 * 1000,
    // 15 minutes in milliseconds
    disabled: !preferencesState.useExternalServices,
    getMetaMetricsId: () => initMessenger.call('MetaMetricsController:getMetaMetricsId'),
    clientConfigApiService: new _remoteFeatureFlagController.ClientConfigApiService({
      fetch: globalThis.fetch.bind(globalThis),
      config: {
        client: _remoteFeatureFlagController.ClientType.Extension,
        distribution,
        environment
      }
    })
  });
  initMessenger.subscribe('PreferencesController:stateChange', (0, _util.previousValueComparator)((prevState, currState) => {
    const {
      useExternalServices: prevUseExternalServices
    } = prevState;
    const {
      useExternalServices: currUseExternalServices
    } = currState;
    if (currUseExternalServices && !prevUseExternalServices) {
      controller.enable();
      controller.updateRemoteFeatureFlags().catch(error => {
        console.error('Failed to update remote feature flags:', error);
      });
    } else if (!currUseExternalServices && prevUseExternalServices) {
      controller.disable();
    }
    return true;
  }, preferencesState));
  return {
    controller
  };
};
exports.RemoteFeatureFlagControllerInit = RemoteFeatureFlagControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\remote-feature-flag-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\seedless-onboarding\\index.ts", {"./oauth-service-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\seedless-onboarding\\oauth-service-init.ts","./seedless-onboarding-controller-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\seedless-onboarding\\seedless-onboarding-controller-init.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cseedless-onboarding%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "OAuthServiceInit", {
  enumerable: true,
  get: function () {
    return _oauthServiceInit.OAuthServiceInit;
  }
});
Object.defineProperty(exports, "SeedlessOnboardingControllerInit", {
  enumerable: true,
  get: function () {
    return _seedlessOnboardingControllerInit.SeedlessOnboardingControllerInit;
  }
});
var _oauthServiceInit = require("./oauth-service-init");
var _seedlessOnboardingControllerInit = require("./seedless-onboarding-controller-init");

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\seedless-onboarding\\index.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\seedless-onboarding\\oauth-service-init.ts", {"../../services/oauth/oauth-service":"D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\oauth-service.ts","../../services/oauth/web-authenticator-factory":"D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\web-authenticator-factory.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cseedless-onboarding%5Coauth-service-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OAuthServiceInit = void 0;
var _oauthService = _interopRequireDefault(require("../../services/oauth/oauth-service"));
var _webAuthenticatorFactory = require("../../services/oauth/web-authenticator-factory");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const OAuthServiceInit = request => {
  const {
    controllerMessenger,
    getController
  } = request;
  const metaMetricsController = getController('MetaMetricsController');
  const service = new _oauthService.default({
    messenger: controllerMessenger,
    env: {
      googleClientId: "" ?? '',
      appleClientId: "" ?? ''
    },
    webAuthenticator: (0, _webAuthenticatorFactory.webAuthenticatorFactory)(),
    // @ts-expect-error: TODO: Investigate type mismatch.
    bufferedTrace: metaMetricsController.bufferedTrace.bind(metaMetricsController),
    // @ts-expect-error: TODO: Investigate type mismatch.
    bufferedEndTrace: metaMetricsController.bufferedEndTrace.bind(metaMetricsController)
  });
  return {
    controller: service,
    memStateKey: null,
    persistedStateKey: null
  };
};
exports.OAuthServiceInit = OAuthServiceInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\seedless-onboarding\\oauth-service-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\seedless-onboarding\\seedless-onboarding-controller-init.ts", {"../../lib/encryptor-factory":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\encryptor-factory.ts","../../services/oauth/config":"D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\config.ts","@metamask/seedless-onboarding-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cseedless-onboarding%5Cseedless-onboarding-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeedlessOnboardingControllerInit = void 0;
var _seedlessOnboardingController = require("@metamask/seedless-onboarding-controller");
var _encryptorFactory = require("../../lib/encryptor-factory");
var _config = require("../../services/oauth/config");
const loadWeb3AuthNetwork = () => {
  return (0, _config.isDevOrTestBuild)() ? _seedlessOnboardingController.Web3AuthNetwork.Devnet : _seedlessOnboardingController.Web3AuthNetwork.Mainnet;
};
const SeedlessOnboardingControllerInit = request => {
  const {
    initMessenger,
    controllerMessenger,
    persistedState
  } = request;
  const encryptor = (0, _encryptorFactory.encryptorFactory)(600_000);
  const network = loadWeb3AuthNetwork();
  const controller = new _seedlessOnboardingController.SeedlessOnboardingController({
    messenger: controllerMessenger,
    state: persistedState.SeedlessOnboardingController,
    network,
    passwordOutdatedCacheTTL: 15_000,
    // 15 seconds

    // This is a temporary workaround to allow the OAuthService to be used
    // in the seedless onboarding controller. Ideally the controller calls the
    // service directly using the messenger system, but that requires some
    // further refactoring in the controller.
    refreshJWTToken: (...args) => initMessenger.call('OAuthService:getNewRefreshToken', ...args),
    revokeRefreshToken: (...args) => initMessenger.call('OAuthService:revokeRefreshToken', ...args),
    renewRefreshToken: (...args) => initMessenger.call('OAuthService:renewRefreshToken', ...args),
    encryptor: {
      decrypt: (key, encryptedData) => encryptor.decrypt(key, encryptedData),
      decryptWithDetail: (key, encryptedData) => encryptor.decryptWithDetail(key, encryptedData),
      decryptWithKey(key, encryptedData) {
        let payload;
        if (typeof encryptedData === 'string') {
          payload = JSON.parse(encryptedData);
        } else {
          payload = encryptedData;
        }
        return encryptor.decryptWithKey(key, payload);
      },
      encrypt: (key, data) => encryptor.encrypt(key, data),
      encryptWithDetail: (key, data) => encryptor.encryptWithDetail(key, data),
      importKey: key => encryptor.importKey(key)
    }
  });
  return {
    controller
  };
};
exports.SeedlessOnboardingControllerInit = SeedlessOnboardingControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\seedless-onboarding\\seedless-onboarding-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\selected-network-controller-init.ts", {"../lib/WeakRefObjectMap":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\WeakRefObjectMap.ts","@metamask/selected-network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\selected-network-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cselected-network-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectedNetworkControllerInit = void 0;
var _selectedNetworkController = require("@metamask/selected-network-controller");
var _WeakRefObjectMap = require("../lib/WeakRefObjectMap");
/**
 * Initialize the selected network controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @returns The initialized controller.
 */
const SelectedNetworkControllerInit = ({
  controllerMessenger,
  persistedState
}) => {
  const controller = new _selectedNetworkController.SelectedNetworkController({
    // @ts-expect-error: `SelectedNetworkController` expects the full state, but
    // the persisted state may be partial.
    state: persistedState.SelectedNetworkController,
    messenger: controllerMessenger,
    domainProxyMap: new _WeakRefObjectMap.WeakRefObjectMap()
  });
  return {
    controller
  };
};
exports.SelectedNetworkControllerInit = SelectedNetworkControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\selected-network-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\shield\\shield-controller-init.ts", {"@metamask/shield-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\shield-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cshield%5Cshield-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShieldControllerInit = void 0;
var _shieldController = require("@metamask/shield-controller");
const ShieldControllerInit = request => {
  const {
    controllerMessenger,
    initMessenger,
    persistedState
  } = request;
  const baseUrl = "https://ruleset-engine.dev-api.cx.metamask.io" ?? 'https://shield-rule-engine.dev-api.cx.metamask.io';
  const getAccessToken = () => initMessenger.call('AuthenticationController:getBearerToken');
  const controller = new _shieldController.ShieldController({
    messenger: controllerMessenger,
    state: persistedState.ShieldController,
    backend: new _shieldController.ShieldRemoteBackend({
      getAccessToken,
      fetch: (input, init) => {
        // From https://github.com/MetaMask/metamask-extension/pull/35588/
        // Without wrapping fetch, the requests are not sent as expected. More
        // investigation is needed.
        return fetch(input, init);
      },
      baseUrl
    })
  });
  return {
    controller
  };
};
exports.ShieldControllerInit = ShieldControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\shield\\shield-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\smart-transactions\\smart-transactions-controller-init.ts", {"../../../../shared/constants/smartTransactions":"D:\\code\\v\\metamask-extension\\shared\\constants\\smartTransactions.ts","../../../../shared/modules/selectors":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\index.ts","@metamask/smart-transactions-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Csmart-transactions%5Csmart-transactions-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SmartTransactionsControllerInit = void 0;
var _smartTransactionsController = require("@metamask/smart-transactions-controller");
var _smartTransactions = require("../../../../shared/constants/smartTransactions");
var _selectors = require("../../../../shared/modules/selectors");
// This import is only used for the type.
// eslint-disable-next-line import/no-restricted-paths

const SmartTransactionsControllerInit = request => {
  const {
    controllerMessenger,
    initMessenger,
    persistedState,
    getUIState,
    getAccountType,
    getDeviceModel,
    getHardwareTypeForMetric,
    trace
  } = request;
  const smartTransactionsController = new _smartTransactionsController.SmartTransactionsController({
    supportedChainIds: (0, _smartTransactions.getAllowedSmartTransactionsChainIds)(),
    clientId: _smartTransactionsController.ClientId.Extension,
    trackMetaMetricsEvent: initMessenger.call.bind(initMessenger, 'MetaMetricsController:trackEvent'),
    state: persistedState.SmartTransactionsController,
    messenger: controllerMessenger,
    getFeatureFlags: () => {
      const state = {
        metamask: getUIState()
      };
      return (0, _selectors.getFeatureFlagsByChainId)(state);
    },
    getMetaMetricsProps: async () => {
      var _internalAccounts$acc;
      const metamask = getUIState();
      const {
        internalAccounts
      } = metamask;
      const selectedAccountId = internalAccounts === null || internalAccounts === void 0 ? void 0 : internalAccounts.selectedAccount;
      const selectedAccount = selectedAccountId ? internalAccounts === null || internalAccounts === void 0 || (_internalAccounts$acc = internalAccounts.accounts) === null || _internalAccounts$acc === void 0 ? void 0 : _internalAccounts$acc[selectedAccountId] : null;
      const selectedAddress = (selectedAccount === null || selectedAccount === void 0 ? void 0 : selectedAccount.address) ?? '';
      if (!selectedAddress) {
        return {
          accountHardwareType: undefined,
          accountType: undefined,
          deviceModel: undefined
        };
      }
      const accountHardwareType = await getHardwareTypeForMetric(selectedAddress);
      const accountType = await getAccountType(selectedAddress);
      const deviceModel = await getDeviceModel(selectedAddress);
      return {
        accountHardwareType,
        accountType,
        deviceModel
      };
    },
    trace
  });
  return {
    controller: smartTransactionsController
  };
};
exports.SmartTransactionsControllerInit = SmartTransactionsControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\smart-transactions\\smart-transactions-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\snaps\\cronjob-controller-init.ts", {"@metamask/snaps-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Csnaps%5Ccronjob-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CronjobControllerInit = void 0;
var _snapsControllers = require("@metamask/snaps-controllers");
/**
 * Initialize the cronjob controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @param request.getCronjobControllerStorageManager - Get the storage manager for the
 * CronjobController.
 * @returns The initialized controller.
 */
const CronjobControllerInit = ({
  controllerMessenger,
  persistedState,
  getCronjobControllerStorageManager
}) => {
  const controller = new _snapsControllers.CronjobController({
    // @ts-expect-error: `persistedState.CronjobController` is not compatible
    // with the expected type.
    // TODO: Look into the type mismatch.
    state: persistedState.CronjobController,
    messenger: controllerMessenger,
    // @ts-expect-error TODO: fix incompatible types
    stateManager: getCronjobControllerStorageManager()
  });
  return {
    controller,
    persistedStateKey: null
  };
};
exports.CronjobControllerInit = CronjobControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\snaps\\cronjob-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\snaps\\execution-service-init.ts", {"../../../../shared/modules/mv3.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\mv3.utils.js","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/snaps-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Csnaps%5Cexecution-service-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecutionServiceInit = void 0;
var _snapsControllers = require("@metamask/snaps-controllers");
var _utils = require("@metamask/utils");
var _permissionController = require("@metamask/permission-controller");
var _mv = require("../../../../shared/modules/mv3.utils");
/**
 * Initialize the Snaps execution service.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the service.
 * @param request.offscreenPromise - The promise that resolves when the
 * offscreen document is ready.
 * @param request.setupUntrustedCommunicationEip1193 - The setup function for
 * EIP-1193 communication.
 * @returns The initialized controller.
 */
const ExecutionServiceInit = ({
  controllerMessenger,
  offscreenPromise,
  setupUntrustedCommunicationEip1193
}) => {
  const useOffscreenDocument = _mv.isManifestV3 && typeof chrome !== 'undefined' && typeof chrome.offscreen !== 'undefined';

  /**
   * Set up the EIP-1193 provider for the given Snap.
   *
   * @param snapId - The ID of the Snap.
   * @param connectionStream - The stream to connect to the Snap.
   */
  function setupSnapProvider(snapId, connectionStream) {
    setupUntrustedCommunicationEip1193({
      connectionStream,
      sender: {
        snapId
      },
      subjectType: _permissionController.SubjectType.Snap
    });
  }
  if (useOffscreenDocument) {
    return {
      memStateKey: null,
      persistedStateKey: null,
      controller: new _snapsControllers.OffscreenExecutionService({
        messenger: controllerMessenger,
        setupSnapProvider,
        offscreenPromise
      })
    };
  }
  const iframeUrl = "https://execution.metamask.io/iframe/10.2.2/index.html";
  (0, _utils.assert)(iframeUrl, 'Missing iframe URL.');
  return {
    memStateKey: null,
    persistedStateKey: null,
    controller: new _snapsControllers.IframeExecutionService({
      messenger: controllerMessenger,
      iframeUrl: new URL(iframeUrl),
      setupSnapProvider
    })
  };
};
exports.ExecutionServiceInit = ExecutionServiceInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\snaps\\execution-service-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\snaps\\index.ts", {"./cronjob-controller-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\snaps\\cronjob-controller-init.ts","./execution-service-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\snaps\\execution-service-init.ts","./multichain-router-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\snaps\\multichain-router-init.ts","./rate-limit-controller-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\snaps\\rate-limit-controller-init.ts","./snap-controller-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\snaps\\snap-controller-init.ts","./snap-insights-controller-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\snaps\\snap-insights-controller-init.ts","./snap-interface-controller-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\snaps\\snap-interface-controller-init.ts","./snaps-name-provider-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\snaps\\snaps-name-provider-init.ts","./snaps-registry-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\snaps\\snaps-registry-init.ts","./websocket-service-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\snaps\\websocket-service-init.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Csnaps%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "CronjobControllerInit", {
  enumerable: true,
  get: function () {
    return _cronjobControllerInit.CronjobControllerInit;
  }
});
Object.defineProperty(exports, "ExecutionServiceInit", {
  enumerable: true,
  get: function () {
    return _executionServiceInit.ExecutionServiceInit;
  }
});
Object.defineProperty(exports, "MultichainRouterInit", {
  enumerable: true,
  get: function () {
    return _multichainRouterInit.MultichainRouterInit;
  }
});
Object.defineProperty(exports, "RateLimitControllerInit", {
  enumerable: true,
  get: function () {
    return _rateLimitControllerInit.RateLimitControllerInit;
  }
});
Object.defineProperty(exports, "SnapControllerInit", {
  enumerable: true,
  get: function () {
    return _snapControllerInit.SnapControllerInit;
  }
});
Object.defineProperty(exports, "SnapInsightsControllerInit", {
  enumerable: true,
  get: function () {
    return _snapInsightsControllerInit.SnapInsightsControllerInit;
  }
});
Object.defineProperty(exports, "SnapInterfaceControllerInit", {
  enumerable: true,
  get: function () {
    return _snapInterfaceControllerInit.SnapInterfaceControllerInit;
  }
});
Object.defineProperty(exports, "SnapsNameProviderInit", {
  enumerable: true,
  get: function () {
    return _snapsNameProviderInit.SnapsNameProviderInit;
  }
});
Object.defineProperty(exports, "SnapsRegistryInit", {
  enumerable: true,
  get: function () {
    return _snapsRegistryInit.SnapsRegistryInit;
  }
});
Object.defineProperty(exports, "WebSocketServiceInit", {
  enumerable: true,
  get: function () {
    return _websocketServiceInit.WebSocketServiceInit;
  }
});
var _cronjobControllerInit = require("./cronjob-controller-init");
var _executionServiceInit = require("./execution-service-init");
var _multichainRouterInit = require("./multichain-router-init");
var _rateLimitControllerInit = require("./rate-limit-controller-init");
var _snapControllerInit = require("./snap-controller-init");
var _snapInsightsControllerInit = require("./snap-insights-controller-init");
var _snapInterfaceControllerInit = require("./snap-interface-controller-init");
var _snapsNameProviderInit = require("./snaps-name-provider-init");
var _snapsRegistryInit = require("./snaps-registry-init");
var _websocketServiceInit = require("./websocket-service-init");

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\snaps\\index.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\snaps\\multichain-router-init.ts", {"../../../../shared/constants/keyring":"D:\\code\\v\\metamask-extension\\shared\\constants\\keyring.ts","@metamask/snaps-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Csnaps%5Cmultichain-router-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainRouterInit = void 0;
var _snapsControllers = require("@metamask/snaps-controllers");
var _keyring = require("../../../../shared/constants/keyring");
/**
 * Initialize the multichain router.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the service.
 * @param request.getController
 * @returns The initialized service.
 */
const MultichainRouterInit = ({
  controllerMessenger,
  getController
}) => {
  const keyringController = getController('KeyringController');
  const getSnapKeyring = async () => {
    // TODO: Use `withKeyring` instead
    let [snapKeyring] = keyringController.getKeyringsByType(_keyring.KeyringType.snap);
    if (!snapKeyring) {
      await keyringController.addNewKeyring(_keyring.KeyringType.snap);
      // TODO: Use `withKeyring` instead
      [snapKeyring] = keyringController.getKeyringsByType(_keyring.KeyringType.snap);
    }
    return snapKeyring;
  };

  // @TODO(snaps): This fixes an issue where `withKeyring` would lock the
  // `KeyringController` mutex. That meant that if a snap requested a keyring
  // operation (like requesting entropy) while the `KeyringController` was
  // locked, it would cause a deadlock. This is a temporary fix until we can
  // refactor how we handle requests to the Snaps Keyring.
  // @ts-expect-error: Types of `SnapKeyring` are incompatible.
  const withSnapKeyring = async operation => {
    const keyring = await getSnapKeyring();
    return operation({
      keyring
    });
  };
  const controller = new _snapsControllers.MultichainRouter({
    messenger: controllerMessenger,
    withSnapKeyring
  });
  return {
    memStateKey: null,
    persistedStateKey: null,
    controller
  };
};
exports.MultichainRouterInit = MultichainRouterInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\snaps\\multichain-router-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\snaps\\rate-limit-controller-init.ts", {"@metamask/notification-services-controller/notification-services":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\NotificationServicesController\\index.cjs","@metamask/rate-limit-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rate-limit-controller\\dist\\index.cjs","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Csnaps%5Crate-limit-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RateLimitControllerInit = void 0;
var _rateLimitController = require("@metamask/rate-limit-controller");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _notificationServices = require("@metamask/notification-services-controller/notification-services");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Initialize the rate limit controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The controller messenger to use for the
 * controller.
 * @param request.persistedState - The persisted state of the extension.
 * @param request.initMessenger - The init messenger. This has access to
 * different functions than the controller messenger, and should be used for
 * initialization purposes only.
 * @param request.showNotification - Function to show a notification.
 * @returns The initialized controller.
 */
const RateLimitControllerInit = ({
  controllerMessenger,
  initMessenger,
  persistedState,
  showNotification
}) => {
  const controller = new _rateLimitController.RateLimitController({
    state: persistedState.RateLimitController,
    messenger: controllerMessenger,
    implementations: {
      showNativeNotification: {
        method: (origin, message) => {
          const subjectMetadataState = initMessenger.call('SubjectMetadataController:getState');
          const originMetadata = subjectMetadataState.subjectMetadata[origin];
          showNotification((originMetadata === null || originMetadata === void 0 ? void 0 : originMetadata.name) ?? origin, message).catch(error => {
            _loglevel.default.error('Failed to create notification', error);
          });
          return null;
        },
        // 2 calls per 5 minutes
        rateLimitCount: 2,
        rateLimitTimeout: 300_000
      },
      showInAppNotification: {
        method: (origin, args) => {
          const {
            message,
            title,
            footerLink,
            interfaceId
          } = args;
          const detailedView = {
            title,
            ...(footerLink ? {
              footerLink
            } : {}),
            interfaceId
          };
          const notification = {
            data: {
              message,
              origin,
              ...(interfaceId ? {
                detailedView
              } : {})
            },
            type: _notificationServices.TRIGGER_TYPES.SNAP,
            readDate: null
          };
          initMessenger.call('NotificationServicesController:updateMetamaskNotificationsList',
          // @ts-expect-error: `notification` is not compatible with the
          // expected type.
          // TODO: Look into the type mismatch.
          notification);
          return null;
        },
        // 5 calls per minute
        rateLimitCount: 5,
        rateLimitTimeout: 60_000
      }
    }
  });
  return {
    controller,
    memStateKey: null,
    persistedStateKey: null
  };
};
exports.RateLimitControllerInit = RateLimitControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\snaps\\rate-limit-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\snaps\\snap-controller-init.ts", {"../../../../shared/constants/keyring":"D:\\code\\v\\metamask-extension\\shared\\constants\\keyring.ts","../../../../shared/constants/snaps/permissions":"D:\\code\\v\\metamask-extension\\shared\\constants\\snaps\\permissions.ts","../../lib/encryptor-factory":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\encryptor-factory.ts","../../lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","@metamask/snaps-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Csnaps%5Csnap-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapControllerInit = void 0;
var _snapsControllers = require("@metamask/snaps-controllers");
var _utils = require("@metamask/utils");
var _permissions = require("../../../../shared/constants/snaps/permissions");
var _encryptorFactory = require("../../lib/encryptor-factory");
var _keyring = require("../../../../shared/constants/keyring");
var _util = require("../../lib/util");
// Copied from `@metamask/snaps-controllers`, since it is not exported.

/**
 * Initialize the Snap controller.
 *
 * @param request - The request object.
 * @param request.initMessenger - The init messenger. This has access to
 * different functions than the controller messenger, and should be used for
 * initialization purposes only.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @param request.removeAllConnections - Function to remove all connections for
 * a given origin.
 * @param request.preinstalledSnaps - The list of preinstalled Snaps.
 * @returns The initialized controller.
 */
const SnapControllerInit = ({
  initMessenger,
  controllerMessenger,
  persistedState,
  removeAllConnections,
  preinstalledSnaps
}) => {
  const allowLocalSnaps = (0, _util.getBooleanFlag)(false);
  const requireAllowlist = (0, _util.getBooleanFlag)(true);
  const rejectInvalidPlatformVersion = (0, _util.getBooleanFlag)(true);
  async function getMnemonicSeed() {
    const keyrings = initMessenger.call('KeyringController:getKeyringsByType', _keyring.KeyringType.hdKeyTree);
    if (!keyrings[0] || !(0, _utils.hasProperty)(keyrings[0], 'seed') || !(keyrings[0].seed instanceof Uint8Array)) {
      throw new Error('Primary keyring mnemonic unavailable.');
    }
    return keyrings[0].seed;
  }

  /**
   * Get the feature flags for the `SnapController.
   *
   * @returns The feature flags.
   */
  function getFeatureFlags() {
    const preferences = initMessenger.call('PreferencesController:getState');
    return {
      disableSnaps: preferences.useExternalServices === false
    };
  }
  const controller = new _snapsControllers.SnapController({
    dynamicPermissions: ['endowment:caip25'],
    environmentEndowmentPermissions: Object.values(_permissions.EndowmentPermissions),
    excludedPermissions: {
      ..._permissions.ExcludedSnapPermissions,
      ..._permissions.ExcludedSnapEndowments
    },
    closeAllConnections: removeAllConnections,
    // @ts-expect-error: `persistedState.SnapController` is not compatible with
    // the expected type.
    // TODO: Look into the type mismatch.
    state: persistedState.SnapController,
    // @ts-expect-error: `controllerMessenger` is not compatible with the
    // expected type.
    // TODO: Look into the type mismatch.
    messenger: controllerMessenger,
    featureFlags: {
      allowLocalSnaps,
      requireAllowlist,
      rejectInvalidPlatformVersion
    },
    // @ts-expect-error: `encryptorFactory` is not compatible with the expected
    // type.
    // TODO: Look into the type mismatch.
    encryptor: (0, _encryptorFactory.encryptorFactory)(600_000),
    getMnemonicSeed,
    preinstalledSnaps,
    getFeatureFlags,
    // `TrackEventHook` from `snaps-controllers` uses `Json | undefined` for
    // properties, but `MetaMetricsEventPayload` uses `Json`, even though
    // `undefined` is supported.
    trackEvent: initMessenger.call.bind(initMessenger, 'MetaMetricsController:trackEvent')
  });
  return {
    controller
  };
};
exports.SnapControllerInit = SnapControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\snaps\\snap-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\snaps\\snap-insights-controller-init.ts", {"@metamask/snaps-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Csnaps%5Csnap-insights-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapInsightsControllerInit = void 0;
var _snapsControllers = require("@metamask/snaps-controllers");
/**
 * Initialize the Snap insights controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @returns The initialized controller.
 */
const SnapInsightsControllerInit = ({
  controllerMessenger,
  persistedState
}) => {
  const controller = new _snapsControllers.SnapInsightsController({
    // @ts-expect-error: `persistedState.SnapInsightsController` is not
    // compatible with the expected type.
    // TODO: Look into the type mismatch.
    state: persistedState.SnapInsightsController,
    messenger: controllerMessenger
  });
  return {
    controller
  };
};
exports.SnapInsightsControllerInit = SnapInsightsControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\snaps\\snap-insights-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\snaps\\snap-interface-controller-init.ts", {"@metamask/snaps-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Csnaps%5Csnap-interface-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapInterfaceControllerInit = void 0;
var _snapsControllers = require("@metamask/snaps-controllers");
/**
 * Initialize the Snap interface controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @returns The initialized controller.
 */
const SnapInterfaceControllerInit = ({
  controllerMessenger,
  persistedState
}) => {
  const controller = new _snapsControllers.SnapInterfaceController({
    // @ts-expect-error: `persistedState.SnapInterfaceController` is not compatible
    // with the expected type.
    // TODO: Look into the type mismatch.
    state: persistedState.SnapInterfaceController,
    // @ts-expect-error: `controllerMessenger` is not compatible with the
    // expected type.
    // TODO: Look into the type mismatch.
    messenger: controllerMessenger
  });
  return {
    controller
  };
};
exports.SnapInterfaceControllerInit = SnapInterfaceControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\snaps\\snap-interface-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\snaps\\snaps-name-provider-init.ts", {"../../lib/SnapsNameProvider":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\SnapsNameProvider.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Csnaps%5Csnaps-name-provider-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapsNameProviderInit = void 0;
var _SnapsNameProvider = require("../../lib/SnapsNameProvider");
/**
 * Initialize the Snaps name provider.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the provider.
 * @returns The initialized provider.
 */
const SnapsNameProviderInit = ({
  controllerMessenger
}) => {
  const controller = new _SnapsNameProvider.SnapsNameProvider({
    messenger: controllerMessenger
  });
  return {
    persistedStateKey: null,
    memStateKey: null,
    controller
  };
};
exports.SnapsNameProviderInit = SnapsNameProviderInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\snaps\\snaps-name-provider-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\snaps\\snaps-registry-init.ts", {"../../lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","@metamask/snaps-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Csnaps%5Csnaps-registry-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapsRegistryInit = void 0;
var _snapsControllers = require("@metamask/snaps-controllers");
var _util = require("../../lib/util");
/**
 * Initialize the Snaps registry controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @returns The initialized controller.
 */
const SnapsRegistryInit = ({
  controllerMessenger,
  persistedState
}) => {
  const requireAllowlist = (0, _util.getBooleanFlag)(true);
  const controller = new _snapsControllers.JsonSnapsRegistry({
    // @ts-expect-error: `persistedState.SnapsRegistry` is not compatible
    // with the expected type.
    // TODO: Look into the type mismatch.
    state: persistedState.SnapsRegistry,
    messenger: controllerMessenger,
    refetchOnAllowlistMiss: requireAllowlist
  });
  return {
    controller
  };
};
exports.SnapsRegistryInit = SnapsRegistryInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\snaps\\snaps-registry-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\snaps\\websocket-service-init.ts", {"@metamask/snaps-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Csnaps%5Cwebsocket-service-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WebSocketServiceInit = void 0;
var _snapsControllers = require("@metamask/snaps-controllers");
/**
 * Initialize the WebSocket service.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the service.
 * @returns The initialized service.
 */
const WebSocketServiceInit = ({
  controllerMessenger
}) => {
  const controller = new _snapsControllers.WebSocketService({
    messenger: controllerMessenger
  });
  return {
    memStateKey: null,
    persistedStateKey: null,
    controller
  };
};
exports.WebSocketServiceInit = WebSocketServiceInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\snaps\\websocket-service-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\subject-metadata-controller-init.ts", {"@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Csubject-metadata-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubjectMetadataControllerInit = void 0;
var _permissionController = require("@metamask/permission-controller");
/**
 * Initialize the subject metadata controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.persistedState - The persisted state of the extension.
 * @returns The initialized controller.
 */
const SubjectMetadataControllerInit = ({
  controllerMessenger,
  persistedState
}) => {
  const controller = new _permissionController.SubjectMetadataController({
    state: persistedState.SubjectMetadataController,
    messenger: controllerMessenger,
    subjectCacheLimit: 100
  });
  return {
    controller
  };
};
exports.SubjectMetadataControllerInit = SubjectMetadataControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\subject-metadata-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\subscription\\index.ts", {"./subscription-controller-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\subscription\\subscription-controller-init.ts","./subscription-service-init":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\subscription\\subscription-service-init.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Csubscription%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "SubscriptionControllerInit", {
  enumerable: true,
  get: function () {
    return _subscriptionControllerInit.SubscriptionControllerInit;
  }
});
Object.defineProperty(exports, "SubscriptionServiceInit", {
  enumerable: true,
  get: function () {
    return _subscriptionServiceInit.SubscriptionServiceInit;
  }
});
var _subscriptionControllerInit = require("./subscription-controller-init");
var _subscriptionServiceInit = require("./subscription-service-init");

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\subscription\\index.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\subscription\\subscription-controller-init.ts", {"../../../../development/build/constants":"D:\\code\\v\\metamask-extension\\development\\build\\constants.js","@metamask/subscription-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\subscription-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Csubscription%5Csubscription-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubscriptionControllerInit = void 0;
var _subscriptionController = require("@metamask/subscription-controller");
var _constants = require("../../../../development/build/constants");
/**
 * Check if the build is a Development or Test build.
 *
 * @returns true if the build is a Development or Test build, false otherwise
 */
function isDevOrTestBuild() {
  return "development" === _constants.ENVIRONMENT.DEVELOPMENT || "development" === _constants.ENVIRONMENT.TESTING;
}
const SubscriptionControllerInit = request => {
  const {
    initMessenger,
    controllerMessenger,
    persistedState
  } = request;
  const subscriptionService = new _subscriptionController.SubscriptionService({
    env: isDevOrTestBuild() ? _subscriptionController.Env.DEV : _subscriptionController.Env.PRD,
    auth: {
      getAccessToken: () => initMessenger.call('AuthenticationController:getBearerToken')
    }
  });
  const controller = new _subscriptionController.SubscriptionController({
    messenger: controllerMessenger,
    state: persistedState.SubscriptionController,
    subscriptionService
  });
  return {
    controller
  };
};
exports.SubscriptionControllerInit = SubscriptionControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\subscription\\subscription-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\subscription\\subscription-service-init.ts", {"../../services/oauth/web-authenticator-factory":"D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\web-authenticator-factory.ts","../../services/subscription/subscription-service":"D:\\code\\v\\metamask-extension\\app\\scripts\\services\\subscription\\subscription-service.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Csubscription%5Csubscription-service-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubscriptionServiceInit = void 0;
var _subscriptionService = require("../../services/subscription/subscription-service");
var _webAuthenticatorFactory = require("../../services/oauth/web-authenticator-factory");
const SubscriptionServiceInit = request => {
  const {
    controllerMessenger,
    platform
  } = request;
  const service = new _subscriptionService.SubscriptionService({
    messenger: controllerMessenger,
    platform,
    webAuthenticator: (0, _webAuthenticatorFactory.webAuthenticatorFactory)()
  });
  return {
    controller: service,
    memStateKey: null,
    persistedStateKey: null
  };
};
exports.SubscriptionServiceInit = SubscriptionServiceInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\subscription\\subscription-service-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\swaps-controller-init.ts", {"../controllers/swaps":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\swaps\\index.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cswaps-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SwapsControllerInit = void 0;
var _swaps = _interopRequireDefault(require("../controllers/swaps"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Initialize the swaps controller.
 *
 * @param request - The request object.
 * @param request.controllerMessenger - The messenger to use for the controller.
 * @param request.initMessenger - The messenger to use for initialization.
 * @param request.persistedState
 * @param request.getController
 * @returns The initialized controller.
 */
const SwapsControllerInit = ({
  controllerMessenger,
  initMessenger,
  persistedState,
  getController
}) => {
  const gasFeeController = getController('GasFeeController');
  const transactionController = getController('TransactionController');
  const controller = new _swaps.default({
    messenger: controllerMessenger,
    // @ts-expect-error: Type of `simulationFails` does not match.
    getBufferedGasLimit: async (txMeta, multiplier) => {
      const networkState = initMessenger.call('NetworkController:getState');
      const {
        gas: gasLimit,
        simulationFails
      } = await transactionController.estimateGasBuffered(txMeta.txParams, multiplier, networkState.selectedNetworkClientId);
      return {
        gasLimit,
        simulationFails
      };
    },
    // TODO: Remove once GasFeeController exports this action type
    getEIP1559GasFeeEstimates: (...args) => gasFeeController.fetchGasFeeEstimates(...args),
    // TODO: Remove once TransactionController exports this action type.
    getLayer1GasFee: (...args) =>
    // @ts-expect-error: `getLayer1GasFee` can return undefined, but the
    // swaps controller expects a string.
    transactionController.getLayer1GasFee(...args),
    trackMetaMetricsEvent: initMessenger.call.bind(initMessenger, 'MetaMetricsController:trackEvent')
  }, persistedState.SwapsController);
  return {
    controller
  };
};
exports.SwapsControllerInit = SwapsControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\swaps-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\token-balances-controller-init.ts", {"@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Ctoken-balances-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TokenBalancesControllerInit = void 0;
var _assetsControllers = require("@metamask/assets-controllers");
const TokenBalancesControllerInit = ({
  controllerMessenger,
  initMessenger,
  persistedState
}) => {
  const {
    useMultiAccountBalanceChecker
  } = initMessenger.call('PreferencesController:getState');
  const controller = new _assetsControllers.TokenBalancesController({
    // @ts-expect-error: `TokenBalancesController` uses the wrong type for
    // the preferences controller state.
    messenger: controllerMessenger,
    state: persistedState.TokenBalancesController,
    queryMultipleAccounts: useMultiAccountBalanceChecker,
    interval: 30_000,
    allowExternalServices: () => initMessenger.call('PreferencesController:getState').useExternalServices,
    accountsApiChainIds: () => {
      var _state$remoteFeatureF;
      const state = initMessenger.call('RemoteFeatureFlagController:getState');
      const featureFlagForAccountApiBalances = state === null || state === void 0 || (_state$remoteFeatureF = state.remoteFeatureFlags) === null || _state$remoteFeatureF === void 0 ? void 0 : _state$remoteFeatureF.assetsAccountApiBalances;
      return Array.isArray(featureFlagForAccountApiBalances) ? featureFlagForAccountApiBalances : [];
    }
  });
  return {
    controller
  };
};
exports.TokenBalancesControllerInit = TokenBalancesControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\token-balances-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\token-detection-controller-init.ts", {"@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Ctoken-detection-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TokenDetectionControllerInit = void 0;
var _assetsControllers = require("@metamask/assets-controllers");
const TokenDetectionControllerInit = ({
  controllerMessenger,
  initMessenger
}) => {
  const controller = new _assetsControllers.TokenDetectionController({
    // @ts-expect-error: TODO: Investigate type mismatch.
    messenger: controllerMessenger,
    getBalancesInSingleCall: (...args) => initMessenger.call('AssetsContractController:getBalancesInSingleCall', ...args),
    trackMetaMetricsEvent: (...args) => initMessenger.call('MetaMetricsController:trackEvent', ...args),
    useAccountsAPI: true,
    platform: 'extension',
    useTokenDetection: () => initMessenger.call('PreferencesController:getState').useTokenDetection,
    useExternalServices: () => initMessenger.call('PreferencesController:getState').useExternalServices
  });
  return {
    memStateKey: null,
    persistedStateKey: null,
    controller
  };
};
exports.TokenDetectionControllerInit = TokenDetectionControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\token-detection-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\token-list-controller-init.ts", {"../lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","./init-utils":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\init-utils.ts","@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Ctoken-list-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TokenListControllerInit = void 0;
var _assetsControllers = require("@metamask/assets-controllers");
var _util = require("../lib/util");
var _initUtils = require("./init-utils");
const TokenListControllerInit = ({
  controllerMessenger,
  initMessenger,
  persistedState
}) => {
  const preferencesControllerState = initMessenger.call('PreferencesController:getState');

  /**
   * Determine whether token list polling is required based on the provided
   * state of the preferences controller.
   *
   * @param state - The state of the preferences controller to check.
   * @returns Whether token list polling is required.
   */
  const isTokenListPollingRequired = state => {
    const {
      useTokenDetection,
      useTransactionSimulations,
      preferences
    } = state ?? {};
    const {
      petnamesEnabled
    } = preferences ?? {};
    return useTokenDetection || petnamesEnabled || useTransactionSimulations;
  };
  const controller = new _assetsControllers.TokenListController({
    messenger: controllerMessenger,
    state: persistedState.TokenListController,
    preventPollingOnNetworkRestart: !isTokenListPollingRequired(preferencesControllerState),
    chainId: (0, _initUtils.getGlobalChainId)(initMessenger)
  });

  /**
   * Enable or disable token list polling based on whether any feature that
   * requires it is enabled.
   *
   * @param currentState - The current state of the preferences controller to
   * check.
   * @param previousState - The previous state of the preferences controller to
   * check.
   */
  const checkTokenListPolling = (currentState, previousState) => {
    const previousEnabled = isTokenListPollingRequired(previousState);
    const newEnabled = isTokenListPollingRequired(currentState);
    if (previousEnabled === newEnabled) {
      return;
    }
    controller.updatePreventPollingOnNetworkRestart(!newEnabled);
  };
  initMessenger.subscribe('PreferencesController:stateChange', (0, _util.previousValueComparator)((previousState, currentState) => {
    checkTokenListPolling(currentState, previousState);
    return true;
  }, preferencesControllerState));
  return {
    controller
  };
};
exports.TokenListControllerInit = TokenListControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\token-list-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\tokens-controller-init.ts", {"./init-utils":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\init-utils.ts","@metamask/assets-controllers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Ctokens-controller-init.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TokensControllerInit = void 0;
var _assetsControllers = require("@metamask/assets-controllers");
var _utils = require("@metamask/utils");
var _initUtils = require("./init-utils");
const TokensControllerInit = ({
  controllerMessenger,
  initMessenger,
  persistedState
}) => {
  const {
    provider
  } = initMessenger.call('NetworkController:getSelectedNetworkClient') ?? {};
  (0, _utils.assert)(provider, 'Provider is required to initialize TokensController.');
  const controller = new _assetsControllers.TokensController({
    messenger: controllerMessenger,
    state: persistedState.TokensController,
    provider,
    chainId: (0, _initUtils.getGlobalChainId)(initMessenger)
  });
  return {
    controller
  };
};
exports.TokensControllerInit = TokensControllerInit;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\tokens-controller-init.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\types.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Ctypes.ts
      return function (require, module, exports) {
"use strict";

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\types.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\utils.ts", {"./messengers":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\messengers\\index.ts","./types":"D:\\code\\v\\metamask-extension\\app\\scripts\\controller-init\\types.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontroller-init%5Cutils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initControllers = initControllers;
var _utils = require("@metamask/utils");
var _types = require("./types");
var _messengers = require("./messengers");
const log = (0, _utils.createProjectLogger)('controller-init');

/** Result of initializing controllers. */

/**
 * Initialize the controllers according to the provided init objects.
 * Each init object can be a function that returns a controller, or a `ControllerInit` instance.
 *
 * @param options - Options bag.
 * @param options.baseControllerMessenger - Unrestricted base controller messenger.
 * @param options.existingControllers - All required controllers that have already been initialized.
 * @param options.initFunctions - Map of init functions keyed by controller name.
 * @param options.initRequest - Base request used to initialize the controllers.
 * Excluding the properties that are generated by this function.
 * @returns The initialized controllers and associated data.
 */
function initControllers({
  baseControllerMessenger,
  existingControllers = [],
  initFunctions,
  initRequest
}) {
  log('Initializing controllers', Object.keys(initFunctions).length);
  const partialControllersByName = existingControllers.reduce((acc, controller) => {
    // @ts-expect-error: Union too complex.
    acc[controller.name] = controller;
    return acc;
  }, {});
  const controllerPersistedState = {};
  const controllerMemState = {};
  let controllerApi = {};
  const getController = name => getControllerOrThrow(partialControllersByName, name);
  for (const [key, value] of Object.entries(initFunctions)) {
    const controllerName = key;
    const initFunction = value;
    const messengerCallbacks = _messengers.CONTROLLER_MESSENGERS[controllerName];
    const controllerMessengerCallback = messengerCallbacks === null || messengerCallbacks === void 0 ? void 0 : messengerCallbacks.getMessenger;
    const initMessengerCallback = messengerCallbacks === null || messengerCallbacks === void 0 ? void 0 : messengerCallbacks.getInitMessenger;
    const controllerMessenger = controllerMessengerCallback === null || controllerMessengerCallback === void 0 ? void 0 : controllerMessengerCallback(baseControllerMessenger);
    const initMessenger = initMessengerCallback === null || initMessengerCallback === void 0 ? void 0 : initMessengerCallback(baseControllerMessenger);
    const finalInitRequest = {
      ...initRequest,
      controllerMessenger,
      getController,
      initMessenger
    };
    const result = initFunction({
      ...finalInitRequest,
      controllerMessenger: finalInitRequest.controllerMessenger
    });
    const {
      controller,
      persistedStateKey: persistedStateKeyRaw,
      memStateKey: memStateKeyRaw
    } = result;
    const api = result.api ?? {};
    const persistedStateKey = persistedStateKeyRaw === null ? undefined : persistedStateKeyRaw ?? controllerName;
    const memStateKey = memStateKeyRaw === null ? undefined : memStateKeyRaw ?? controllerName;

    // @ts-expect-error: Union too complex.
    partialControllersByName[controllerName] = controller;
    controllerApi = {
      ...controllerApi,
      ...api
    };
    if (persistedStateKey) {
      controllerPersistedState[persistedStateKey] = controller;
    }
    if (memStateKey) {
      controllerMemState[memStateKey] = controller;
    }
    log('Initialized controller', controllerName, {
      api: Object.keys(api),
      persistedStateKey,
      memStateKey
    });
  }
  return {
    controllerApi,
    controllerMemState,
    controllerPersistedState,
    controllersByName: partialControllersByName
  };
}
function getControllerOrThrow(controllersByName, name) {
  const controller = controllersByName[name];
  if (!controller) {
    throw new Error(`Controller requested before it was initialized: ${name}`);
  }
  return controller;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controller-init\\utils.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\account-order.ts", {"@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontrollers%5Caccount-order.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountOrderController = void 0;
var _baseController = require("@metamask/base-controller");
// Unique name for the controller
const controllerName = 'AccountOrderController';

/**
 * The account ID of a account.
 */

// State shape for AccountOrderController

// Describes the action for updating the accounts list

// Describes the action for updating the accounts list

// Union of all possible actions for the messenger

// Type for the messenger of AccountOrderController

// Default state for the controller
const defaultState = {
  pinnedAccountList: [],
  hiddenAccountList: []
};

// Metadata for the controller state
const metadata = {
  pinnedAccountList: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  hiddenAccountList: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  }
};

/**
 * Controller that updates the order of the account list.
 * This controller subscribes to account state changes and ensures
 * that the account list is updated based on the latest account configurations.
 */
class AccountOrderController extends _baseController.BaseController {
  /**
   * Creates a AccountOrderController instance.
   *
   * @param args - The arguments to this function.
   * @param args.messenger - Messenger used to communicate with BaseV2 controller.
   * @param args.state - Initial state to set on this controller.
   */
  constructor({
    messenger,
    state
  }) {
    // Call the constructor of BaseControllerV2
    super({
      messenger,
      metadata,
      name: controllerName,
      state: {
        ...defaultState,
        ...state
      }
    });
  }

  /**
   * Updates the accounts list in the state with the provided list of accounts.
   *
   * @param accountList - The list of accounts to update in the state.
   */

  updateAccountsList(accountList) {
    this.update(state => {
      state.pinnedAccountList = accountList;
      return state;
    });
  }

  /**
   * Hides the accounts list in the state with the provided list of accounts.
   *
   * @param accountList - The list of accounts to hide in the state.
   */

  updateHiddenAccountsList(accountList) {
    this.update(state => {
      state.hiddenAccountList = accountList;
      return state;
    });
  }
}
exports.AccountOrderController = AccountOrderController;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controllers\\account-order.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\account-tracker-controller.ts", {"../../../shared/constants/accounts":"D:\\code\\v\\metamask-extension\\shared\\constants\\accounts.ts","../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../constants/contracts":"D:\\code\\v\\metamask-extension\\app\\scripts\\constants\\contracts.ts","../lib/batch-utils":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\batch-utils.ts","../lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","@ethersproject/contracts":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\contracts\\lib\\index.js","@ethersproject/providers":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\providers\\lib\\index.js","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","single-call-balance-checker-abi":"D:\\code\\v\\metamask-extension\\node_modules\\single-call-balance-checker-abi\\index.js","uuid":"D:\\code\\v\\metamask-extension\\node_modules\\uuid\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontrollers%5Caccount-tracker-controller.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultAccountTrackerControllerState = exports.default = void 0;
var _uuid = require("uuid");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _providers = require("@ethersproject/providers");
var _contracts = require("@ethersproject/contracts");
var _singleCallBalanceCheckerAbi = _interopRequireDefault(require("single-call-balance-checker-abi"));
var _lodash = require("lodash");
var _utils = require("@metamask/utils");
var _baseController = require("@metamask/base-controller");
var _controllerUtils = require("@metamask/controller-utils");
var _network = require("../../../shared/constants/network");
var _contracts2 = require("../constants/contracts");
var _accounts2 = require("../../../shared/constants/accounts");
var _util = require("../lib/util");
var _batchUtils = require("../lib/batch-utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /* Account Tracker
 *
 * This module is responsible for tracking any number of accounts
 * and caching their current balances & transaction counts.
 *
 * It also tracks transaction hashes, and checks their inclusion status
 * on each new block.
 */
// Unique name for the controller
const controllerName = 'AccountTrackerController';

// Maximum number of accounts per Account API request to avoid API limits
const ACCOUNT_API_BATCH_SIZE = 50;

/**
 * The state of the {@link AccountTrackerController}
 *
 * @property accounts - The accounts currently stored in this AccountTrackerController
 * @property accountsByChainId - The accounts currently stored in this AccountTrackerController keyed by chain id
 * @property currentBlockGasLimit - A hex string indicating the gas limit of the current block
 * @property currentBlockGasLimitByChainId - A hex string indicating the gas limit of the current block keyed by chain id
 */

/**
 * {@link AccountTrackerController}'s metadata.
 *
 * This allows us to choose if fields of the state should be persisted or not
 * using the `persist` flag; and if they can be sent to Sentry or not, using
 * the `anonymous` flag.
 */
const controllerMetadata = {
  accounts: {
    includeInStateLogs: false,
    persist: true,
    anonymous: false,
    usedInUi: true
  },
  currentBlockGasLimit: {
    includeInStateLogs: false,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  accountsByChainId: {
    includeInStateLogs: false,
    persist: true,
    anonymous: false,
    usedInUi: true
  },
  currentBlockGasLimitByChainId: {
    includeInStateLogs: false,
    persist: true,
    anonymous: true,
    usedInUi: true
  }
};

/**
 * Function to get default state of the {@link AccountTrackerController}.
 */
const getDefaultAccountTrackerControllerState = () => ({
  accounts: {},
  currentBlockGasLimit: '',
  accountsByChainId: {},
  currentBlockGasLimitByChainId: {}
});

/**
 * Returns the state of the {@link AccountTrackerController}.
 */

/**
 * Action to update native balances.
 */

/**
 * Action to update staked balances.
 */

/**
 * Actions exposed by the {@link AccountTrackerController}.
 */

/**
 * Event emitted when the state of the {@link AccountTrackerController} changes.
 */

/**
 * Events emitted by {@link AccountTrackerController}.
 */

/**
 * Actions that this controller is allowed to call.
 */

/**
 * Events that this controller is allowed to subscribe.
 */

/**
 * Messenger type for the {@link AccountTrackerController}.
 */
exports.getDefaultAccountTrackerControllerState = getDefaultAccountTrackerControllerState;
var _pollingTokenSets = /*#__PURE__*/new WeakMap();
var _listeners = /*#__PURE__*/new WeakMap();
var _provider = /*#__PURE__*/new WeakMap();
var _blockTracker = /*#__PURE__*/new WeakMap();
var _currentBlockNumberByChainId = /*#__PURE__*/new WeakMap();
var _getNetworkIdentifier = /*#__PURE__*/new WeakMap();
var _selectedAccount = /*#__PURE__*/new WeakMap();
var _accountsApiChainIds = /*#__PURE__*/new WeakMap();
var _AccountTrackerController_brand = /*#__PURE__*/new WeakSet();
var _updateForBlock = /*#__PURE__*/new WeakMap();
/**
 * This module is responsible for tracking any number of accounts and caching their current balances & transaction
 * counts.
 *
 * It also tracks transaction hashes, and checks their inclusion status on each new block.
 *
 */
class AccountTrackerController extends _baseController.BaseController {
  /**
   * @param options - Options for initializing the controller
   * @param options.state - Initial controller state.
   * @param options.messenger - Messenger used to communicate with BaseV2 controller.
   * @param options.provider - An EIP-1193 provider instance that uses the current global network
   * @param options.blockTracker - A block tracker, which emits events for each new block
   * @param options.getNetworkIdentifier - A function that returns the current network or passed network configuration
   * @param options.preferencesControllerState - The state of preferences controller
   */
  constructor(options) {
    super({
      name: controllerName,
      metadata: controllerMetadata,
      state: {
        ...getDefaultAccountTrackerControllerState(),
        ...options.state
      },
      messenger: options.messenger
    });
    /**
     * Gets the current chain ID.
     */
    _classPrivateMethodInitSpec(this, _AccountTrackerController_brand);
    _classPrivateFieldInitSpec(this, _pollingTokenSets, new Map());
    _classPrivateFieldInitSpec(this, _listeners, {});
    _classPrivateFieldInitSpec(this, _provider, void 0);
    _classPrivateFieldInitSpec(this, _blockTracker, void 0);
    _classPrivateFieldInitSpec(this, _currentBlockNumberByChainId, {});
    _classPrivateFieldInitSpec(this, _getNetworkIdentifier, void 0);
    _classPrivateFieldInitSpec(this, _selectedAccount, void 0);
    _classPrivateFieldInitSpec(this, _accountsApiChainIds, void 0);
    /**
     * Given a block, updates this AccountTrackerController currentBlockGasLimit and currentBlockGasLimitByChainId and then updates
     * each local account's balance via Provider
     *
     * @private
     * @param blockNumber - the block number to update to.
     * @fires 'block' The updated state, if all account updates are successful
     */
    _classPrivateFieldInitSpec(this, _updateForBlock, async blockNumber => {
      await _assertClassBrand(_AccountTrackerController_brand, this, _updateForBlockByNetworkClientId).call(this, undefined, blockNumber);
    });
    _classPrivateFieldSet(_provider, this, options.provider);
    _classPrivateFieldSet(_blockTracker, this, options.blockTracker);
    _classPrivateFieldSet(_getNetworkIdentifier, this, options.getNetworkIdentifier);

    // Initialize account API configuration
    _classPrivateFieldSet(_accountsApiChainIds, this, options.accountsApiChainIds ?? (() => []));

    // subscribe to account removal
    this.messagingSystem.subscribe('KeyringController:accountRemoved', address => this.removeAccounts([address]));
    const onboardingState = this.messagingSystem.call('OnboardingController:getState');
    this.messagingSystem.subscribe('OnboardingController:stateChange', (0, _util.previousValueComparator)((prevState, currState) => {
      const {
        completedOnboarding: prevCompletedOnboarding
      } = prevState;
      const {
        completedOnboarding: currCompletedOnboarding
      } = currState;
      if (!prevCompletedOnboarding && currCompletedOnboarding) {
        this.updateAccountsAllActiveNetworks();
      }
      return true;
    }, onboardingState));
    _classPrivateFieldSet(_selectedAccount, this, this.messagingSystem.call('AccountsController:getSelectedAccount'));
    this.messagingSystem.subscribe('AccountsController:selectedEvmAccountChange', newAccount => {
      const {
        useMultiAccountBalanceChecker
      } = this.messagingSystem.call('PreferencesController:getState');
      if (_classPrivateFieldGet(_selectedAccount, this).id !== newAccount.id && !useMultiAccountBalanceChecker) {
        _classPrivateFieldSet(_selectedAccount, this, newAccount);
        this.updateAccountsAllActiveNetworks();
      }
    });

    // Register message handlers
    this._registerMessageHandlers();
  }
  resetState() {
    const {
      accounts,
      accountsByChainId,
      currentBlockGasLimit,
      currentBlockGasLimitByChainId
    } = getDefaultAccountTrackerControllerState();
    this.update(state => {
      state.accounts = accounts;
      state.accountsByChainId = accountsByChainId;
      state.currentBlockGasLimit = currentBlockGasLimit;
      state.currentBlockGasLimitByChainId = currentBlockGasLimitByChainId;
    });
  }

  /**
   * Starts polling with global selected network
   */
  start() {
    // blockTracker.currentBlock may be null
    _classPrivateFieldSet(_currentBlockNumberByChainId, this, {
      [_assertClassBrand(_AccountTrackerController_brand, this, _getCurrentChainId).call(this)]: _classPrivateFieldGet(_blockTracker, this).getCurrentBlock()
    });
    _classPrivateFieldGet(_blockTracker, this).once('latest', blockNumber => {
      _classPrivateFieldGet(_currentBlockNumberByChainId, this)[_assertClassBrand(_AccountTrackerController_brand, this, _getCurrentChainId).call(this)] = blockNumber;
    });

    // remove first to avoid double add
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    _classPrivateFieldGet(_blockTracker, this).removeListener('latest', _classPrivateFieldGet(_updateForBlock, this));
    // add listener
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    _classPrivateFieldGet(_blockTracker, this).addListener('latest', _classPrivateFieldGet(_updateForBlock, this));
    // fetch account balances
    this.updateAccounts();
  }

  /**
   * Stops polling with global selected network
   */
  stop() {
    // remove listener
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    _classPrivateFieldGet(_blockTracker, this).removeListener('latest', _classPrivateFieldGet(_updateForBlock, this));
  }
  /**
   * Starts polling for a networkClientId
   *
   * @param networkClientId - The networkClientId to start polling for
   * @returns pollingToken
   */
  startPollingByNetworkClientId(networkClientId) {
    const pollToken = (0, _uuid.v4)();
    const pollingTokenSet = _classPrivateFieldGet(_pollingTokenSets, this).get(networkClientId);
    if (pollingTokenSet) {
      pollingTokenSet.add(pollToken);
    } else {
      const set = new Set();
      set.add(pollToken);
      _classPrivateFieldGet(_pollingTokenSets, this).set(networkClientId, set);
      _assertClassBrand(_AccountTrackerController_brand, this, _subscribeWithNetworkClientId).call(this, networkClientId);
    }
    return pollToken;
  }

  /**
   * Stops polling for all networkClientIds
   */
  stopAllPolling() {
    this.stop();
    _classPrivateFieldGet(_pollingTokenSets, this).forEach((tokenSet, _networkClientId) => {
      tokenSet.forEach(token => {
        this.stopPollingByPollingToken(token);
      });
    });
  }

  /**
   * Stops polling for a networkClientId
   *
   * @param pollingToken - The polling token to stop polling for
   */
  stopPollingByPollingToken(pollingToken) {
    if (!pollingToken) {
      throw new Error('pollingToken required');
    }
    _classPrivateFieldGet(_pollingTokenSets, this).forEach((tokenSet, key) => {
      if (tokenSet.has(pollingToken)) {
        tokenSet.delete(pollingToken);
        if (tokenSet.size === 0) {
          _classPrivateFieldGet(_pollingTokenSets, this).delete(key);
          _assertClassBrand(_AccountTrackerController_brand, this, _unsubscribeWithNetworkClientId).call(this, key);
        }
      }
    });
  }

  /**
   * Subscribes from the block tracker for the given networkClientId if not currently subscribed
   *
   * @param networkClientId - network client ID to fetch a block tracker with
   */

  /**
   * Ensures that the locally stored accounts are in sync with a set of accounts stored externally to this
   * AccountTrackerController.
   *
   * Once this AccountTrackerController accounts are up to date with those referenced by the passed addresses, each
   * of these accounts are given an updated balance via Provider.
   *
   * @param addresses - The array of hex addresses for accounts with which this AccountTrackerController accounts should be
   * in sync
   */
  syncWithAddresses(addresses) {
    const {
      accounts
    } = this.state;
    const locals = Object.keys(accounts);
    const accountsToAdd = [];
    addresses.forEach(upstream => {
      if (!locals.includes(upstream)) {
        accountsToAdd.push(upstream);
      }
    });
    const accountsToRemove = [];
    locals.forEach(local => {
      if (!addresses.includes(local)) {
        accountsToRemove.push(local);
      }
    });
    this.addAccounts(accountsToAdd);
    this.removeAccounts(accountsToRemove);
  }

  /**
   * Adds new addresses to track the balances of
   * given a balance as long this.#currentBlockNumberByChainId is defined for the chainId.
   *
   * @param addresses - An array of hex addresses of new accounts to track
   */
  addAccounts(addresses) {
    const {
      accounts: _accounts,
      accountsByChainId: _accountsByChainId
    } = this.state;
    const accounts = (0, _lodash.cloneDeep)(_accounts);
    const accountsByChainId = (0, _lodash.cloneDeep)(_accountsByChainId);

    // add initial state for addresses
    addresses.forEach(address => {
      accounts[address] = {};
    });
    Object.keys(accountsByChainId).forEach(chainId => {
      addresses.forEach(address => {
        accountsByChainId[chainId][address] = {};
      });
    });
    // save accounts state
    this.update(state => {
      state.accounts = accounts;
      state.accountsByChainId = accountsByChainId;
    });

    // fetch balances for the accounts if there is block number ready
    if (_classPrivateFieldGet(_currentBlockNumberByChainId, this)[_assertClassBrand(_AccountTrackerController_brand, this, _getCurrentChainId).call(this)]) {
      this.updateAccounts();
    }
    _classPrivateFieldGet(_pollingTokenSets, this).forEach((_tokenSet, networkClientId) => {
      const {
        chainId
      } = _assertClassBrand(_AccountTrackerController_brand, this, _getCorrectNetworkClient).call(this, networkClientId);
      if (_classPrivateFieldGet(_currentBlockNumberByChainId, this)[chainId]) {
        this.updateAccounts(networkClientId);
      }
    });
  }

  /**
   * Removes accounts from being tracked
   *
   * @param addresses - An array of hex addresses to stop tracking.
   */
  removeAccounts(addresses) {
    const {
      accounts: _accounts,
      accountsByChainId: _accountsByChainId
    } = this.state;
    const accounts = (0, _lodash.cloneDeep)(_accounts);
    const accountsByChainId = (0, _lodash.cloneDeep)(_accountsByChainId);

    // remove each state object
    addresses.forEach(address => {
      delete accounts[address];
    });
    Object.keys(accountsByChainId).forEach(chainId => {
      addresses.forEach(address => {
        delete accountsByChainId[chainId][address];
      });
    });
    // save accounts state
    this.update(state => {
      state.accounts = accounts;
      state.accountsByChainId = accountsByChainId;
    });
  }

  /**
   * Removes all addresses and associated balances
   */
  clearAccounts() {
    this.update(state => {
      state.accounts = {};
      state.accountsByChainId = {
        [_assertClassBrand(_AccountTrackerController_brand, this, _getCurrentChainId).call(this)]: {}
      };
    });
  }
  /**
   * Updates accounts for the globally selected network
   * and all networks that are currently being polled.
   * Uses v4 multiaccount API when possible for efficiency.
   */
  async updateAccountsAllActiveNetworks() {
    const {
      completedOnboarding
    } = this.messagingSystem.call('OnboardingController:getState');
    if (!completedOnboarding) {
      return;
    }
    const {
      useMultiAccountBalanceChecker
    } = this.messagingSystem.call('PreferencesController:getState');
    let addresses = [];
    if (useMultiAccountBalanceChecker) {
      const {
        accounts
      } = this.state;
      addresses = Object.keys(accounts);
    } else {
      const selectedAddress = this.messagingSystem.call('AccountsController:getSelectedAccount').address;
      addresses = [selectedAddress];
    }

    // Try multichain API first if we have supported chains and multiple accounts
    const {
      useExternalServices: allowExternalServices
    } = this.messagingSystem.call('PreferencesController:getState');
    const hasAccountApiChains = _classPrivateFieldGet(_accountsApiChainIds, this).call(this).length > 0;
    if (hasAccountApiChains && allowExternalServices && useMultiAccountBalanceChecker) {
      try {
        const success = await _assertClassBrand(_AccountTrackerController_brand, this, _updateAccountsAllChainsViaApi).call(this, addresses);
        if (success) {
          _loglevel.default.debug('Successfully updated all accounts via multiaccount API v4');
          return;
        }
      } catch (error) {
        _loglevel.default.warn('Multiaccount API failed, falling back to individual requests:', error);
      }
    }

    // Fallback to individual network requests
    await this.updateAccounts();
    await Promise.all(Array.from(_classPrivateFieldGet(_pollingTokenSets, this)).map(([networkClientId]) => {
      return this.updateAccounts(networkClientId);
    }));
  }

  /**
   * balanceChecker is deployed on main eth (test)nets and requires a single call
   * for all other networks, calls this.#updateAccount for each account in this.store
   *
   * @param networkClientId - optional network client ID to use instead of the globally selected network.
   */
  async updateAccounts(networkClientId) {
    const {
      completedOnboarding
    } = this.messagingSystem.call('OnboardingController:getState');
    if (!completedOnboarding) {
      return;
    }
    const {
      chainId,
      provider,
      identifier
    } = _assertClassBrand(_AccountTrackerController_brand, this, _getCorrectNetworkClient).call(this, networkClientId);
    const {
      useMultiAccountBalanceChecker,
      useExternalServices
    } = this.messagingSystem.call('PreferencesController:getState');
    let addresses = [];
    if (useMultiAccountBalanceChecker) {
      const {
        accounts
      } = this.state;
      addresses = Object.keys(accounts);
    } else {
      const selectedAddress = this.messagingSystem.call('AccountsController:getSelectedAccount').address;
      addresses = [selectedAddress];
    }

    // Try account API first if chain is supported by feature flag
    let accountApiSuccess = false;
    const isChainSupported = _classPrivateFieldGet(_accountsApiChainIds, this).call(this).includes(chainId);
    if (isChainSupported && useExternalServices && useMultiAccountBalanceChecker) {
      try {
        accountApiSuccess = await _assertClassBrand(_AccountTrackerController_brand, this, _updateAccountsViaApi).call(this, addresses, chainId);
        if (accountApiSuccess) {
          _loglevel.default.debug(`Successfully updated balances via multiaccount API v4 for chain ${chainId}`);
          return;
        }
      } catch (error) {
        _loglevel.default.warn('Account API failed, falling back to RPC/balance checker:', error);
      }
    }

    // Fallback to existing methods if account API wasn't successful
    const rpcUrl = 'http://127.0.0.1:8545';
    if (identifier === _network.LOCALHOST_RPC_URL || identifier === rpcUrl || !(id => id in _contracts2.SINGLE_CALL_BALANCES_ADDRESSES)(chainId)) {
      await Promise.all(addresses.map(address => _assertClassBrand(_AccountTrackerController_brand, this, _updateAccount).call(this, address, provider, chainId)));
    } else {
      await _assertClassBrand(_AccountTrackerController_brand, this, _updateAccountsViaBalanceChecker).call(this, addresses, _contracts2.SINGLE_CALL_BALANCES_ADDRESSES[chainId], provider, chainId);
    }
  }
  async updateAccountByAddress({
    address,
    networkClientId
  } = {}) {
    const {
      completedOnboarding
    } = this.messagingSystem.call('OnboardingController:getState');
    if (!completedOnboarding) {
      return;
    }
    const selectedAddress =
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    address || this.messagingSystem.call('AccountsController:getSelectedAccount').address;
    if (!selectedAddress) {
      return;
    }
    const {
      chainId,
      provider
    } = _assertClassBrand(_AccountTrackerController_brand, this, _getCorrectNetworkClient).call(this, networkClientId);
    await _assertClassBrand(_AccountTrackerController_brand, this, _updateAccount).call(this, selectedAddress, provider, chainId);
  }

  /**
   * Updates the current balance of an account.
   *
   * @private
   * @param address - A hex address of a the account to be updated
   * @param provider - The provider instance to fetch the balance with
   * @param chainId - The chain ID to update in state
   */

  /**
   * Updates the balances of multiple native tokens in a single batch operation.
   * This is more efficient than calling updateNativeToken multiple times as it
   * triggers only one state update.
   *
   * @param balances - Array of balance updates, each containing address, chainId, and balance.
   */
  updateNativeBalances(balances) {
    this.update(state => {
      balances.forEach(({
        address,
        chainId,
        balance
      }) => {
        // Temporary until moving AccountTrackerController in core with an normalized format
        // accountsByChainId works with lowercase addresses, this is just a safe guard in case address is in checksum format
        // Convert address to lowercase to match extension's accountsByChainId format
        const lowercaseAddress = address.toLowerCase();

        // Ensure the chainId exists in the state
        if (!state.accountsByChainId[chainId]) {
          state.accountsByChainId[chainId] = {};
        }
        // Ensure the address exists for this chain
        if (!state.accountsByChainId[chainId][lowercaseAddress]) {
          state.accountsByChainId[chainId][lowercaseAddress] = {
            address: lowercaseAddress,
            balance: '0x0'
          };
        }
        // Update the balance
        if (balance) {
          state.accountsByChainId[chainId][lowercaseAddress].balance = (0, _controllerUtils.toHex)(balance);
        }
      });
    });
  }

  /**
   * Updates the staked balances of multiple accounts in a single batch operation.
   * This is more efficient than updating staked balances individually as it
   * triggers only one state update.
   *
   * @param stakedBalances - Array of staked balance updates, each containing address, chainId, and stakedBalance.
   */
  updateStakedBalances(stakedBalances) {
    this.update(state => {
      stakedBalances.forEach(({
        address,
        chainId,
        stakedBalance
      }) => {
        // Ensure the chainId exists in the state
        if (!state.accountsByChainId[chainId]) {
          state.accountsByChainId[chainId] = {};
        }
        // Ensure the address exists for this chain
        if (!state.accountsByChainId[chainId][address]) {
          state.accountsByChainId[chainId][address] = {
            address,
            balance: '0x0'
          };
        }
        // Update the staked balance
        if (stakedBalance) {
          state.accountsByChainId[chainId][address].stakedBalance = (0, _controllerUtils.toHex)(stakedBalance);
        }
      });
    });
  }

  /**
   * Fetches account balances from the account API service (v4 multiaccount endpoint)
   * Supports multichain and multiAccount requests with automatic batching
   * Uses CAIP format for addresses: eip155:0:0x...
   * Batches requests to maximum of 50 accounts per API call to avoid API limits
   *
   * @private
   * @param addresses - Array of account addresses (hex format, will be converted to CAIP)
   * @param chainIds - Array of chain IDs to fetch balances for
   * @returns Promise resolving to account balance data or null if failed
   */

  _registerMessageHandlers() {
    this.messagingSystem.registerActionHandler(`${controllerName}:updateNativeBalances`, this.updateNativeBalances.bind(this));
    this.messagingSystem.registerActionHandler(`${controllerName}:updateStakedBalances`, this.updateStakedBalances.bind(this));
  }
}
exports.default = AccountTrackerController;
function _getCurrentChainId() {
  const {
    selectedNetworkClientId
  } = this.messagingSystem.call('NetworkController:getState');
  const {
    configuration: {
      chainId
    }
  } = this.messagingSystem.call('NetworkController:getNetworkClientById', selectedNetworkClientId);
  return chainId;
}
/**
 * Resolves a networkClientId to a network client config
 * or globally selected network config if not provided
 *
 * @param networkClientId - Optional networkClientId to fetch a network client with
 * @returns network client config
 */
function _getCorrectNetworkClient(networkClientId) {
  if (networkClientId) {
    const {
      configuration,
      provider,
      blockTracker
    } = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId);
    return {
      chainId: configuration.chainId,
      provider,
      blockTracker,
      identifier: _classPrivateFieldGet(_getNetworkIdentifier, this).call(this, configuration)
    };
  }
  return {
    chainId: _assertClassBrand(_AccountTrackerController_brand, this, _getCurrentChainId).call(this),
    provider: _classPrivateFieldGet(_provider, this),
    blockTracker: _classPrivateFieldGet(_blockTracker, this),
    identifier: _classPrivateFieldGet(_getNetworkIdentifier, this).call(this)
  };
}
function _subscribeWithNetworkClientId(networkClientId) {
  if (_classPrivateFieldGet(_listeners, this)[networkClientId]) {
    return;
  }
  const {
    blockTracker
  } = _assertClassBrand(_AccountTrackerController_brand, this, _getCorrectNetworkClient).call(this, networkClientId);
  const updateForBlock = blockNumber => _assertClassBrand(_AccountTrackerController_brand, this, _updateForBlockByNetworkClientId).call(this, networkClientId, blockNumber);
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  blockTracker.addListener('latest', updateForBlock);
  _classPrivateFieldGet(_listeners, this)[networkClientId] = updateForBlock;
  this.updateAccounts(networkClientId);
}
/**
 * Unsubscribes from the block tracker for the given networkClientId if currently subscribed
 *
 * @param networkClientId - The network client ID to fetch a block tracker with
 */
function _unsubscribeWithNetworkClientId(networkClientId) {
  if (!_classPrivateFieldGet(_listeners, this)[networkClientId]) {
    return;
  }
  const {
    blockTracker
  } = _assertClassBrand(_AccountTrackerController_brand, this, _getCorrectNetworkClient).call(this, networkClientId);
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  blockTracker.removeListener('latest', _classPrivateFieldGet(_listeners, this)[networkClientId]);
  delete _classPrivateFieldGet(_listeners, this)[networkClientId];
}
/**
 * Returns the accounts object for the chain ID, or initializes it from the globally selected
 * if it doesn't already exist.
 *
 * @param chainId - The chain ID
 */
function _getAccountsForChainId(chainId) {
  const {
    accounts,
    accountsByChainId
  } = this.state;
  if (accountsByChainId[chainId]) {
    return (0, _lodash.cloneDeep)(accountsByChainId[chainId]);
  }
  const newAccounts = {};
  Object.keys(accounts).forEach(address => {
    newAccounts[address] = {};
  });
  return newAccounts;
}
/**
 * Given a block, updates this AccountTrackerController currentBlockGasLimitByChainId, and then updates each local account's balance
 * via Provider
 *
 * @private
 * @param networkClientId - optional network client ID to use instead of the globally selected network.
 * @param blockNumber - the block number to update to.
 * @fires 'block' The updated state, if all account updates are successful
 */
async function _updateForBlockByNetworkClientId(networkClientId, blockNumber) {
  const {
    chainId,
    provider
  } = _assertClassBrand(_AccountTrackerController_brand, this, _getCorrectNetworkClient).call(this, networkClientId);
  _classPrivateFieldGet(_currentBlockNumberByChainId, this)[chainId] = blockNumber;

  // block gasLimit polling shouldn't be in account-tracker shouldn't be here...
  const currentBlock = await provider.request({
    method: 'eth_getBlockByNumber',
    params: [blockNumber, false]
  });
  if (!currentBlock) {
    return;
  }
  const currentBlockGasLimit = currentBlock.gasLimit;
  this.update(state => {
    if (chainId === _assertClassBrand(_AccountTrackerController_brand, this, _getCurrentChainId).call(this)) {
      state.currentBlockGasLimit = currentBlockGasLimit;
    }
    state.currentBlockGasLimitByChainId[chainId] = currentBlockGasLimit;
  });
  try {
    await this.updateAccounts(networkClientId);
  } catch (err) {
    _loglevel.default.error(err);
  }
}
async function _updateAccount(address, provider, chainId) {
  const {
    useMultiAccountBalanceChecker
  } = this.messagingSystem.call('PreferencesController:getState');
  let balance = '0x0';

  // query balance
  try {
    balance = await provider.request({
      method: 'eth_getBalance',
      params: [address, 'latest']
    });
  } catch (error) {
    if (error && typeof error === 'object' && (0, _utils.hasProperty)(error, 'data') && error.data && (0, _utils.hasProperty)(error.data, 'request') && error.data.request && (0, _utils.hasProperty)(error.data.request, 'method') && error.data.request.method !== 'eth_getBalance') {
      throw error;
    }
  }
  const result = {
    address,
    balance
  };
  // update accounts state
  const accounts = _assertClassBrand(_AccountTrackerController_brand, this, _getAccountsForChainId).call(this, chainId);
  // only populate if the entry is still present
  if (!accounts[address]) {
    return;
  }
  let newAccounts = accounts;
  if (!useMultiAccountBalanceChecker) {
    newAccounts = {};
    Object.keys(accounts).forEach(accountAddress => {
      if (address !== accountAddress) {
        newAccounts[accountAddress] = {
          address: accountAddress,
          balance: null
        };
      }
    });
  }
  newAccounts[address] = result;
  this.update(state => {
    if (chainId === _assertClassBrand(_AccountTrackerController_brand, this, _getCurrentChainId).call(this)) {
      state.accounts = newAccounts;
    }
    state.accountsByChainId[chainId] = newAccounts;
  });
}
/**
 * Updates current address balances from balanceChecker deployed contract instance
 *
 * @private
 * @param addresses - A hex addresses of a the accounts to be updated
 * @param deployedContractAddress - The contract address to fetch balances with
 * @param provider - The provider instance to fetch the balance with
 * @param chainId - The chain ID to update in state
 */
async function _updateAccountsViaBalanceChecker(addresses, deployedContractAddress, provider, chainId) {
  const ethContract = await new _contracts.Contract(deployedContractAddress, _singleCallBalanceCheckerAbi.default, new _providers.Web3Provider(provider));
  const ethBalance = ['0x0000000000000000000000000000000000000000'];
  try {
    const balances = await ethContract.balances(addresses, ethBalance);
    const accounts = _assertClassBrand(_AccountTrackerController_brand, this, _getAccountsForChainId).call(this, chainId);
    const newAccounts = {};
    Object.keys(accounts).forEach(address => {
      if (!addresses.includes(address)) {
        newAccounts[address] = {
          address,
          balance: null
        };
      }
    });
    addresses.forEach((address, index) => {
      const balance = balances[index] ? balances[index].toHexString() : '0x0';
      newAccounts[address] = {
        address,
        balance
      };
    });
    this.update(state => {
      if (chainId === _assertClassBrand(_AccountTrackerController_brand, this, _getCurrentChainId).call(this)) {
        state.accounts = newAccounts;
      }
      state.accountsByChainId[chainId] = newAccounts;
    });
  } catch (error) {
    _loglevel.default.warn(`MetaMask - Account Tracker single call balance fetch failed`, error);
    Promise.allSettled(addresses.map(address => _assertClassBrand(_AccountTrackerController_brand, this, _updateAccount).call(this, address, provider, chainId)));
  }
}
async function _fetchAccountBalancesFromApi(addresses, chainIds) {
  try {
    // Check if external services are allowed
    const {
      useExternalServices
    } = this.messagingSystem.call('PreferencesController:getState');
    if (!useExternalServices) {
      return null;
    }

    // Filter chain IDs by feature flag support (hex format), then convert to decimal for API
    const supportedChainIds = chainIds.filter(chainId => _classPrivateFieldGet(_accountsApiChainIds, this).call(this).includes(chainId)).map(chainId => chainId);
    if (supportedChainIds.length === 0) {
      return null;
    }

    // Use batch utility to process addresses in parallel using Promise.all
    const result = await (0, _batchUtils.fetchAccountBalancesInBatches)({
      addresses,
      supportedChainIds,
      accountApiBaseUrl: _accounts2.ACCOUNTS_PROD_API_BASE_URL,
      batchSize: ACCOUNT_API_BATCH_SIZE,
      logger: {
        warn: message => _loglevel.default.warn(message),
        debug: message => _loglevel.default.debug(message)
      }
    });
    return result;
  } catch (error) {
    _loglevel.default.warn('Failed to fetch balances from account API:', error);
    return null;
  }
}
/**
 * Updates account balances using data from the account API (v4 multiaccount)
 *
 * @private
 * @param addresses - Array of account addresses
 * @param chainId - Single chain ID to fetch balances for
 * @returns Promise resolving to true if successful, false otherwise
 */
async function _updateAccountsViaApiMultichain(addresses, chainId) {
  try {
    const apiData = await _assertClassBrand(_AccountTrackerController_brand, this, _fetchAccountBalancesFromApi).call(this, addresses, [chainId]);
    if (!(apiData !== null && apiData !== void 0 && apiData.balances)) {
      return false;
    }

    // Process API data and update state for the chain
    this.update(state => {
      const accounts = _assertClassBrand(_AccountTrackerController_brand, this, _getAccountsForChainId).call(this, chainId);
      const newAccounts = {};

      // Initialize all accounts with null balance first
      Object.keys(accounts).forEach(address => {
        if (!addresses.includes(address)) {
          newAccounts[address] = {
            address,
            balance: null
          };
        }
      });

      // Update with API data if available
      // The API returns token objects indexed by numbers, not by chain ID
      addresses.forEach(address => {
        // Convert address to CAIP format for API lookup
        const caipAddress = (0, _utils.toCaipAccountId)('eip155', chainId, address);

        // Find the native token for this address in the API response
        let nativeToken = null;
        for (const tokenKey in apiData.balances) {
          if (Object.prototype.hasOwnProperty.call(apiData.balances, tokenKey)) {
            const token = apiData.balances[tokenKey];
            if (token.accountAddress === caipAddress && token.type === 'native' && token.address === '0x0000000000000000000000000000000000000000') {
              nativeToken = token;
              break;
            }
          }
        }
        if (nativeToken) {
          // Convert decimal balance to hex
          const balanceInWei = BigInt(Math.floor(parseFloat(nativeToken.balance) * Math.pow(10, nativeToken.decimals)));
          newAccounts[address] = {
            address,
            balance: `0x${balanceInWei.toString(16)}`
          };
        } else {
          // No API data for this address - keep existing balance or set to null
          const existingAccount = accounts[address];
          newAccounts[address] = existingAccount || {
            address,
            balance: null
          };
        }
      });

      // Update state for this chain
      if (chainId === _assertClassBrand(_AccountTrackerController_brand, this, _getCurrentChainId).call(this)) {
        state.accounts = newAccounts;
      }
      state.accountsByChainId[chainId] = newAccounts;
    });
    return true;
  } catch (error) {
    _loglevel.default.warn('Failed to update accounts via multiaccount API:', error);
    return false;
  }
}
/**
 * Updates account balances using data from the account API (single chain)
 * Fallback method for single-chain requests
 *
 * @private
 * @param addresses - Array of account addresses
 * @param chainId - The chain ID
 * @returns Promise resolving to true if successful, false otherwise
 */
async function _updateAccountsViaApi(addresses, chainId) {
  return _assertClassBrand(_AccountTrackerController_brand, this, _updateAccountsViaApiMultichain).call(this, addresses, chainId);
}
/**
 * Updates account balances for all active networks using v4 multiaccount API
 *
 * @private
 * @param addresses - Array of account addresses
 * @returns Promise resolving to true if successful, false otherwise
 */
async function _updateAccountsAllChainsViaApi(addresses) {
  try {
    // Get all active chain IDs from pollingTokenSets and current chain
    const activeChainIds = new Set();
    activeChainIds.add(_assertClassBrand(_AccountTrackerController_brand, this, _getCurrentChainId).call(this));

    // Add chain IDs from all actively polled networks
    _classPrivateFieldGet(_pollingTokenSets, this).forEach((_tokenSet, networkClientId) => {
      const {
        chainId
      } = _assertClassBrand(_AccountTrackerController_brand, this, _getCorrectNetworkClient).call(this, networkClientId);
      activeChainIds.add(chainId);
    });

    // Update each chain individually
    const chainIdsArray = Array.from(activeChainIds);
    let allSuccessful = true;
    for (const chainId of chainIdsArray) {
      const success = await _assertClassBrand(_AccountTrackerController_brand, this, _updateAccountsViaApiMultichain).call(this, addresses, chainId);
      if (!success) {
        allSuccessful = false;
      }
    }
    return allSuccessful;
  } catch (error) {
    _loglevel.default.warn('Failed to update accounts for all chains via multiaccount API:', error);
    return false;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controllers\\account-tracker-controller.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\alert-controller.ts", {"../../../shared/constants/alerts":"D:\\code\\v\\metamask-extension\\shared\\constants\\alerts.ts","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontrollers%5Calert-controller.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultAlertControllerState = exports.AlertController = void 0;
var _baseController = require("@metamask/base-controller");
var _alerts = require("../../../shared/constants/alerts");
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
const controllerName = 'AlertController';

/**
 * Returns the state of the {@link AlertController}.
 */

/**
 * Actions exposed by the {@link AlertController}.
 */

/**
 * Event emitted when the state of the {@link AlertController} changes.
 */

/**
 * Events emitted by {@link AlertController}.
 */

/**
 * Actions that this controller is allowed to call.
 */

/**
 * Events that this controller is allowed to subscribe.
 */

/**
 * The alert controller state type
 *
 * @property alertEnabledness - A map of alerts IDs to booleans, where
 * `true` indicates that the alert is enabled and shown, and `false` the opposite.
 * @property unconnectedAccountAlertShownOrigins - A map of origin
 * strings to booleans indicating whether the "switch to connected" alert has
 * been shown (`true`) or otherwise (`false`).
 */

/**
 * The alert controller options
 *
 * @property state - The initial controller state
 * @property messenger - The controller messenger
 */

/**
 * Function to get default state of the {@link AlertController}.
 */
const getDefaultAlertControllerState = () => ({
  alertEnabledness: _alerts.TOGGLEABLE_ALERT_TYPES.reduce((alertEnabledness, alertType) => {
    alertEnabledness[alertType] = true;
    return alertEnabledness;
  }, {}),
  unconnectedAccountAlertShownOrigins: {},
  web3ShimUsageOrigins: {}
});

/**
 * {@link AlertController}'s metadata.
 *
 * This allows us to choose if fields of the state should be persisted or not
 * using the `persist` flag; and if they can be sent to Sentry or not, using
 * the `anonymous` flag.
 */
exports.getDefaultAlertControllerState = getDefaultAlertControllerState;
const controllerMetadata = {
  alertEnabledness: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  unconnectedAccountAlertShownOrigins: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: true
  },
  web3ShimUsageOrigins: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: true
  }
};

/**
 * Controller responsible for maintaining alert-related state.
 */
var _selectedAddress = /*#__PURE__*/new WeakMap();
var _AlertController_brand = /*#__PURE__*/new WeakSet();
class AlertController extends _baseController.BaseController {
  constructor(opts) {
    super({
      messenger: opts.messenger,
      metadata: controllerMetadata,
      name: controllerName,
      state: {
        ...getDefaultAlertControllerState(),
        ...opts.state
      }
    });
    /**
     * @param origin - The origin to set the state for.
     * @param value - The state value to set.
     */
    _classPrivateMethodInitSpec(this, _AlertController_brand);
    _classPrivateFieldInitSpec(this, _selectedAddress, void 0);
    _classPrivateFieldSet(_selectedAddress, this, this.messagingSystem.call('AccountsController:getSelectedAccount').address);
    this.messagingSystem.subscribe('AccountsController:selectedAccountChange', account => {
      const currentState = this.state;
      if (currentState.unconnectedAccountAlertShownOrigins && _classPrivateFieldGet(_selectedAddress, this) !== account.address) {
        _classPrivateFieldSet(_selectedAddress, this, account.address);
        this.update(state => {
          state.unconnectedAccountAlertShownOrigins = {};
        });
      }
    });
  }
  setAlertEnabledness(alertId, enabledness) {
    this.update(state => {
      state.alertEnabledness[alertId] = enabledness;
    });
  }

  /**
   * Sets the "switch to connected" alert as shown for the given origin
   *
   * @param origin - The origin the alert has been shown for
   */
  setUnconnectedAccountAlertShown(origin) {
    this.update(state => {
      state.unconnectedAccountAlertShownOrigins[origin] = true;
    });
  }

  /**
   * Gets the web3 shim usage state for the given origin.
   *
   * @param origin - The origin to get the web3 shim usage state for.
   * @returns The web3 shim usage state for the given
   * origin, or undefined.
   */
  getWeb3ShimUsageState(origin) {
    var _this$state$web3ShimU;
    return (_this$state$web3ShimU = this.state.web3ShimUsageOrigins) === null || _this$state$web3ShimU === void 0 ? void 0 : _this$state$web3ShimU[origin];
  }

  /**
   * Sets the web3 shim usage state for the given origin to RECORDED.
   *
   * @param origin - The origin the that used the web3 shim.
   */
  setWeb3ShimUsageRecorded(origin) {
    _assertClassBrand(_AlertController_brand, this, _setWeb3ShimUsageState).call(this, origin, _alerts.Web3ShimUsageAlertStates.recorded);
  }

  /**
   * Sets the web3 shim usage state for the given origin to DISMISSED.
   *
   * @param origin - The origin that the web3 shim notification was
   * dismissed for.
   */
  setWeb3ShimUsageAlertDismissed(origin) {
    _assertClassBrand(_AlertController_brand, this, _setWeb3ShimUsageState).call(this, origin, _alerts.Web3ShimUsageAlertStates.dismissed);
  }
}
exports.AlertController = AlertController;
function _setWeb3ShimUsageState(origin, value) {
  this.update(state => {
    if (state.web3ShimUsageOrigins) {
      state.web3ShimUsageOrigins[origin] = value;
    }
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controllers\\alert-controller.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\app-metadata.ts", {"@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontrollers%5Capp-metadata.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultAppMetadataControllerState = exports.default = void 0;
var _baseController = require("@metamask/base-controller");
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
// Unique name for the controller
const controllerName = 'AppMetadataController';

/**
 * The options that AppMetadataController takes.
 */

/**
 * The state of the AppMetadataController
 */

/**
 * Function to get default state of the {@link AppMetadataController}.
 */
const getDefaultAppMetadataControllerState = () => ({
  currentAppVersion: '',
  previousAppVersion: '',
  previousMigrationVersion: 0,
  currentMigrationVersion: 0
});

/**
 * Returns the state of the {@link AppMetadataController}.
 */

/**
 * Actions exposed by the {@link AppMetadataController}.
 */

/**
 * Event emitted when the state of the {@link AppMetadataController} changes.
 */

/**
 * Actions that this controller is allowed to call.
 */

/**
 * Events that this controller is allowed to subscribe.
 */

/**
 * Messenger type for the {@link AppMetadataController}.
 */
exports.getDefaultAppMetadataControllerState = getDefaultAppMetadataControllerState;
/**
 * {@link AppMetadataController}'s metadata.
 *
 * This allows us to choose if fields of the state should be persisted or not
 * using the `persist` flag; and if they can be sent to Sentry or not, using
 * the `anonymous` flag.
 */
const controllerMetadata = {
  currentAppVersion: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: false
  },
  previousAppVersion: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: false
  },
  previousMigrationVersion: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: false
  },
  currentMigrationVersion: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: false
  }
};

/**
 * The AppMetadata controller stores metadata about the current extension instance,
 * including the currently and previously installed versions, and the most recently
 * run migration.
 *
 */
var _AppMetadataController_brand = /*#__PURE__*/new WeakSet();
class AppMetadataController extends _baseController.BaseController {
  /**
   * Constructs a AppMetadata controller.
   *
   * @param options - the controller options
   * @param options.state - Initial controller state.
   * @param options.messenger - Messenger used to communicate with BaseV2 controller.
   * @param options.currentMigrationVersion
   * @param options.currentAppVersion
   */
  constructor({
    state: _state = {},
    messenger,
    currentAppVersion = '',
    currentMigrationVersion = 0
  }) {
    super({
      name: controllerName,
      metadata: controllerMetadata,
      state: {
        ...getDefaultAppMetadataControllerState(),
        ..._state
      },
      messenger
    });
    /**
     * Updates the currentAppVersion in state, and sets the previousAppVersion to the old currentAppVersion.
     *
     * @param maybeNewAppVersion
     */
    _classPrivateMethodInitSpec(this, _AppMetadataController_brand);
    _assertClassBrand(_AppMetadataController_brand, this, _maybeUpdateAppVersion).call(this, currentAppVersion);
    _assertClassBrand(_AppMetadataController_brand, this, _maybeUpdateMigrationVersion).call(this, currentMigrationVersion);
  }
}
exports.default = AppMetadataController;
function _maybeUpdateAppVersion(maybeNewAppVersion) {
  const oldCurrentAppVersion = this.state.currentAppVersion;
  if (maybeNewAppVersion !== oldCurrentAppVersion) {
    this.update(state => {
      state.currentAppVersion = maybeNewAppVersion;
      state.previousAppVersion = oldCurrentAppVersion;
    });
  }
}
/**
 * Updates the migrationVersion in state.
 *
 * @param maybeNewMigrationVersion
 */
function _maybeUpdateMigrationVersion(maybeNewMigrationVersion) {
  const oldCurrentMigrationVersion = this.state.currentMigrationVersion;
  if (maybeNewMigrationVersion !== oldCurrentMigrationVersion) {
    this.update(state => {
      state.previousMigrationVersion = oldCurrentMigrationVersion;
      state.currentMigrationVersion = maybeNewMigrationVersion;
    });
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controllers\\app-metadata.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\app-state-controller.ts", {"../../../shared/constants/alarms":"D:\\code\\v\\metamask-extension\\shared\\constants\\alarms.js","../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../shared/constants/preferences":"D:\\code\\v\\metamask-extension\\shared\\constants\\preferences.ts","../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../shared/modules/mv3.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\mv3.utils.js","../../../ui/helpers/utils/build-types":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\build-types.js","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","uuid":"D:\\code\\v\\metamask-extension\\node_modules\\uuid\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontrollers%5Capp-state-controller.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppStateController = void 0;
var _uuid = require("uuid");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _controllerUtils = require("@metamask/controller-utils");
var _baseController = require("@metamask/base-controller");
var _utils = require("@metamask/utils");
var _time = require("../../../shared/constants/time");
var _alarms = require("../../../shared/constants/alarms");
var _mv = require("../../../shared/modules/mv3.utils");
var _buildTypes = require("../../../ui/helpers/utils/build-types");
var _app = require("../../../shared/constants/app");
var _preferences = require("../../../shared/constants/preferences");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } // TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths
const controllerName = 'AppStateController';

/**
 * Returns the state of the {@link AppStateController}.
 */

/**
 * Actions exposed by the {@link AppStateController}.
 */

/**
 * Actions that this controller is allowed to call.
 */

/**
 * Event emitted when the state of the {@link AppStateController} changes.
 */

/**
 * Events emitted by {@link AppStateController}.
 */

/**
 * Events that this controller is allowed to subscribe.
 */

const getDefaultAppStateControllerState = () => ({
  activeQrCodeScanRequest: null,
  browserEnvironment: {},
  connectedStatusPopoverHasBeenShown: true,
  defaultHomeActiveTabName: null,
  enableEnforcedSimulations: true,
  enableEnforcedSimulationsForTransactions: {},
  enforcedSimulationsSlippage: 10,
  enforcedSimulationsSlippageForTransactions: {},
  fullScreenGasPollTokens: [],
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
  // eslint-disable-next-line @typescript-eslint/naming-convention
  hadAdvancedGasFeesSetPriorToMigration92_3: false,
  isRampCardClosed: false,
  isUpdateAvailable: false,
  lastUpdatedAt: null,
  lastViewedUserSurvey: null,
  newPrivacyPolicyToastClickedOrClosed: null,
  newPrivacyPolicyToastShownDate: null,
  nftsDetectionNoticeDismissed: false,
  notificationGasPollTokens: [],
  onboardingDate: null,
  outdatedBrowserWarningLastShown: null,
  popupGasPollTokens: [],
  productTour: 'accountIcon',
  recoveryPhraseReminderHasBeenShown: false,
  recoveryPhraseReminderLastShown: new Date().getTime(),
  showAccountBanner: true,
  showBetaHeader: (0, _buildTypes.isBeta)(),
  showDownloadMobileAppSlide: true,
  showNetworkBanner: true,
  showPermissionsTour: true,
  showTestnetMessageInDropdown: true,
  slides: [],
  surveyLinkLastClickedOrClosed: null,
  shieldEndingToastLastClickedOrClosed: null,
  shieldPausedToastLastClickedOrClosed: null,
  throttledOrigins: {},
  timeoutMinutes: _preferences.DEFAULT_AUTO_LOCK_TIME_LIMIT,
  trezorModel: null,
  updateModalLastDismissedAt: null,
  hasShownMultichainAccountsIntroModal: false,
  showShieldEntryModalOnce: null,
  ...getInitialStateOverrides()
});

/**
 * Return initial state for properties that should overwrite persisted state.
 *
 * TODO: Stop persisting state that we want to override, so that we can remove this function.
 *
 * @returns Initial state for properties that should overwrite persisted state.
 */
function getInitialStateOverrides() {
  return {
    addressSecurityAlertResponses: {},
    currentExtensionPopupId: 0,
    nftsDropdownState: {},
    signatureSecurityAlertResponses: {},
    networkConnectionBanner: {
      status: 'unknown'
    }
  };
}
const controllerMetadata = {
  activeQrCodeScanRequest: {
    includeInStateLogs: false,
    persist: false,
    anonymous: true,
    usedInUi: true
  },
  addressSecurityAlertResponses: {
    includeInStateLogs: true,
    persist: false,
    anonymous: true,
    usedInUi: true
  },
  browserEnvironment: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  connectedStatusPopoverHasBeenShown: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  currentExtensionPopupId: {
    includeInStateLogs: true,
    persist: false,
    anonymous: true,
    usedInUi: true
  },
  currentPopupId: {
    includeInStateLogs: true,
    persist: false,
    anonymous: true,
    usedInUi: true
  },
  defaultHomeActiveTabName: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  enableEnforcedSimulations: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  enableEnforcedSimulationsForTransactions: {
    includeInStateLogs: true,
    persist: false,
    anonymous: true,
    usedInUi: true
  },
  enforcedSimulationsSlippage: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  enforcedSimulationsSlippageForTransactions: {
    includeInStateLogs: true,
    persist: false,
    anonymous: true,
    usedInUi: true
  },
  fullScreenGasPollTokens: {
    includeInStateLogs: true,
    persist: false,
    anonymous: true,
    usedInUi: true
  },
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
  // eslint-disable-next-line @typescript-eslint/naming-convention
  hadAdvancedGasFeesSetPriorToMigration92_3: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: false
  },
  isRampCardClosed: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  isUpdateAvailable: {
    includeInStateLogs: true,
    persist: false,
    anonymous: true,
    usedInUi: true
  },
  lastInteractedConfirmationInfo: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  lastUpdatedAt: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  lastViewedUserSurvey: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  networkConnectionBanner: {
    includeInStateLogs: false,
    persist: false,
    anonymous: false,
    usedInUi: true
  },
  newPrivacyPolicyToastClickedOrClosed: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  newPrivacyPolicyToastShownDate: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  nftsDetectionNoticeDismissed: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: false
  },
  nftsDropdownState: {
    includeInStateLogs: true,
    persist: false,
    anonymous: true,
    usedInUi: true
  },
  notificationGasPollTokens: {
    includeInStateLogs: true,
    persist: false,
    anonymous: true,
    usedInUi: true
  },
  onboardingDate: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  outdatedBrowserWarningLastShown: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  popupGasPollTokens: {
    includeInStateLogs: true,
    persist: false,
    anonymous: true,
    usedInUi: true
  },
  productTour: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  recoveryPhraseReminderHasBeenShown: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  recoveryPhraseReminderLastShown: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  showAccountBanner: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  showBetaHeader: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  showDownloadMobileAppSlide: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  showNetworkBanner: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  showPermissionsTour: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  showTestnetMessageInDropdown: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: false
  },
  signatureSecurityAlertResponses: {
    includeInStateLogs: true,
    persist: false,
    anonymous: true,
    usedInUi: true
  },
  slides: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  snapsInstallPrivacyWarningShown: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  surveyLinkLastClickedOrClosed: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  shieldEndingToastLastClickedOrClosed: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  shieldPausedToastLastClickedOrClosed: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  termsOfUseLastAgreed: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  throttledOrigins: {
    includeInStateLogs: true,
    persist: false,
    anonymous: true,
    usedInUi: true
  },
  timeoutMinutes: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: false
  },
  trezorModel: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: false
  },
  updateModalLastDismissedAt: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  hasShownMultichainAccountsIntroModal: {
    persist: true,
    anonymous: true,
    usedInUi: true,
    includeInStateLogs: true
  },
  showShieldEntryModalOnce: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  }
};
var _extension = /*#__PURE__*/new WeakMap();
var _onInactiveTimeout = /*#__PURE__*/new WeakMap();
var _timer = /*#__PURE__*/new WeakMap();
var _approvalRequestId = /*#__PURE__*/new WeakMap();
var _qrCodeScanPromise = /*#__PURE__*/new WeakMap();
var _AppStateController_brand = /*#__PURE__*/new WeakSet();
class AppStateController extends _baseController.BaseController {
  constructor({
    state: _state = {},
    messenger,
    onInactiveTimeout,
    extension
  }) {
    super({
      name: controllerName,
      metadata: controllerMetadata,
      state: {
        ...getDefaultAppStateControllerState(),
        ..._state,
        ...getInitialStateOverrides()
      },
      messenger
    });
    /**
     * Adds a Promise's resolve function to the waitingForUnlock queue.
     * Also opens the extension popup if specified.
     *
     * @param resolve - A Promise's resolve function that will
     * be called when the extension is unlocked.
     * @param shouldShowUnlockRequest - Whether the extension notification
     * popup should be opened.
     */
    _classPrivateMethodInitSpec(this, _AppStateController_brand);
    _classPrivateFieldInitSpec(this, _extension, void 0);
    _classPrivateFieldInitSpec(this, _onInactiveTimeout, void 0);
    _classPrivateFieldInitSpec(this, _timer, void 0);
    _defineProperty(this, "waitingForUnlock", void 0);
    _classPrivateFieldInitSpec(this, _approvalRequestId, void 0);
    _classPrivateFieldInitSpec(this, _qrCodeScanPromise, null);
    _defineProperty(this, "getAddressSecurityAlertResponse", address => {
      const cached = this.state.addressSecurityAlertResponses[address.toLowerCase()];
      if (!cached) {
        return undefined;
      }

      // Check if the cached response has expired (15 minute TTL)
      const now = Date.now();
      const ADDRESS_SECURITY_ALERT_TTL = 15 * _time.MINUTE;
      if (now - cached.timestamp > ADDRESS_SECURITY_ALERT_TTL) {
        // Remove expired entry
        this.update(state => {
          delete state.addressSecurityAlertResponses[address.toLowerCase()];
        });
        return undefined;
      }

      // Return the response without the timestamp
      const {
        timestamp,
        ...response
      } = cached;
      return response;
    });
    _defineProperty(this, "addAddressSecurityAlertResponse", (address, addressSecurityAlertResponse) => {
      this.update(state => {
        state.addressSecurityAlertResponses[address.toLowerCase()] = {
          ...addressSecurityAlertResponse,
          timestamp: Date.now()
        };
      });
    });
    _classPrivateFieldSet(_extension, this, extension);
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    _classPrivateFieldSet(_onInactiveTimeout, this, onInactiveTimeout || (() => undefined));
    _classPrivateFieldSet(_timer, this, null);
    this.waitingForUnlock = [];
    messenger.subscribe('KeyringController:unlock', _assertClassBrand(_AppStateController_brand, this, _handleUnlock).bind(this));
    messenger.subscribe('PreferencesController:stateChange', ({
      preferences
    }) => {
      const currentState = this.state;
      if (typeof (preferences === null || preferences === void 0 ? void 0 : preferences.autoLockTimeLimit) === 'number' && currentState.timeoutMinutes !== preferences.autoLockTimeLimit) {
        _assertClassBrand(_AppStateController_brand, this, _setInactiveTimeout).call(this, preferences.autoLockTimeLimit);
      }
    });
    const {
      preferences
    } = messenger.call('PreferencesController:getState');
    if (typeof preferences.autoLockTimeLimit === 'number') {
      _assertClassBrand(_AppStateController_brand, this, _setInactiveTimeout).call(this, preferences.autoLockTimeLimit);
    }
    this.messagingSystem.registerActionHandler('AppStateController:getUnlockPromise', this.getUnlockPromise.bind(this));
    this.messagingSystem.registerActionHandler('AppStateController:requestQrCodeScan', _assertClassBrand(_AppStateController_brand, this, _requestQrCodeScan).bind(this));
    _classPrivateFieldSet(_approvalRequestId, this, null);
  }

  /**
   * Get a Promise that resolves when the extension is unlocked.
   * This Promise will never reject.
   *
   * @param shouldShowUnlockRequest - Whether the extension notification
   * popup should be opened.
   * @returns A promise that resolves when the extension is
   * unlocked, or immediately if the extension is already unlocked.
   */
  getUnlockPromise(shouldShowUnlockRequest) {
    return new Promise(resolve => {
      const {
        isUnlocked
      } = this.messagingSystem.call('KeyringController:getState');
      if (isUnlocked) {
        resolve();
      } else {
        _assertClassBrand(_AppStateController_brand, this, _waitForUnlock).call(this, resolve, shouldShowUnlockRequest);
      }
    });
  }
  /**
   * Sets the default home tab
   *
   * @param defaultHomeActiveTabName - the tab name
   */
  setDefaultHomeActiveTabName(defaultHomeActiveTabName) {
    this.update(state => {
      state.defaultHomeActiveTabName = defaultHomeActiveTabName;
    });
  }

  /**
   * Record that the user has seen the connected status info popover
   */
  setConnectedStatusPopoverHasBeenShown() {
    this.update(state => {
      state.connectedStatusPopoverHasBeenShown = true;
    });
  }

  /**
   * Record that the user has been shown the recovery phrase reminder.
   */
  setRecoveryPhraseReminderHasBeenShown() {
    this.update(state => {
      state.recoveryPhraseReminderHasBeenShown = true;
    });
  }
  setSurveyLinkLastClickedOrClosed(time) {
    this.update(state => {
      state.surveyLinkLastClickedOrClosed = time;
    });
  }
  setOnboardingDate() {
    this.update(state => {
      state.onboardingDate = Date.now();
    });
  }
  setLastViewedUserSurvey(id) {
    this.update(state => {
      state.lastViewedUserSurvey = id;
    });
  }
  setRampCardClosed() {
    this.update(state => {
      state.isRampCardClosed = true;
    });
  }
  setNewPrivacyPolicyToastClickedOrClosed() {
    this.update(state => {
      state.newPrivacyPolicyToastClickedOrClosed = true;
    });
  }
  setNewPrivacyPolicyToastShownDate(time) {
    this.update(state => {
      state.newPrivacyPolicyToastShownDate = time;
    });
  }
  setShieldPausedToastLastClickedOrClosed(time) {
    this.update(state => {
      state.shieldPausedToastLastClickedOrClosed = time;
    });
  }
  setShieldEndingToastLastClickedOrClosed(time) {
    this.update(state => {
      state.shieldEndingToastLastClickedOrClosed = time;
    });
  }

  /**
   * Replaces slides in state with new slides. If a slide with the same id
   * already exists, it will be merged with the new slide.
   *
   * @param slides - Array of new slides
   */
  updateSlides(slides) {
    this.update(state => {
      const currentSlides = state.slides || [];
      const newSlides = slides.map(slide => {
        const existingSlide = currentSlides.find(s => s.id === slide.id);
        if (existingSlide) {
          return {
            ...existingSlide,
            ...slide
          };
        }
        return slide;
      });
      state.slides = [...newSlides];
    });
  }

  /**
   * Marks a slide as dismissed by ID
   *
   * @param id - ID of the slide to dismiss
   */
  removeSlide(id) {
    this.update(state => {
      const slides = state.slides || [];
      state.slides = slides.map(slide => {
        if (slide.id === id) {
          return {
            ...slide,
            dismissed: true
          };
        }
        return slide;
      });
      if (id === _app.DOWNLOAD_MOBILE_APP_SLIDE_ID) {
        state.showDownloadMobileAppSlide = false;
      }
    });
  }

  /**
   * Record the timestamp of the last time the user has seen the recovery phrase reminder
   *
   * @param lastShown - timestamp when user was last shown the reminder.
   */
  setRecoveryPhraseReminderLastShown(lastShown) {
    this.update(state => {
      state.recoveryPhraseReminderLastShown = lastShown;
    });
  }

  /**
   * Record the timestamp of the last time the user has acceoted the terms of use
   *
   * @param lastAgreed - timestamp when user last accepted the terms of use
   */
  setTermsOfUseLastAgreed(lastAgreed) {
    this.update(state => {
      state.termsOfUseLastAgreed = lastAgreed;
    });
  }

  /**
   * Record if popover for snaps privacy warning has been shown
   * on the first install of a snap.
   *
   * @param shown - shown status
   */
  setSnapsInstallPrivacyWarningShownStatus(shown) {
    this.update(state => {
      state.snapsInstallPrivacyWarningShown = shown;
    });
  }

  /**
   * Record the timestamp of the last time the user has seen the outdated browser warning
   *
   * @param lastShown - Timestamp (in milliseconds) of when the user was last shown the warning.
   */
  setOutdatedBrowserWarningLastShown(lastShown) {
    this.update(state => {
      state.outdatedBrowserWarningLastShown = lastShown;
    });
  }

  /**
   * Sets the last active time to the current time.
   */
  setLastActiveTime() {
    _assertClassBrand(_AppStateController_brand, this, _resetTimer).call(this);
  }

  /**
   * Set whether or not there is an update available
   *
   * @param isUpdateAvailable - Whether or not there is an update available
   */
  setIsUpdateAvailable(isUpdateAvailable) {
    this.update(state => {
      state.isUpdateAvailable = isUpdateAvailable;
    });
  }

  /**
   * Record the timestamp of the last time the user has dismissed the update modal
   *
   * @param updateModalLastDismissedAt - timestamp of the last time the user has dismissed the update modal.
   */
  setUpdateModalLastDismissedAt(updateModalLastDismissedAt) {
    this.update(state => {
      state.updateModalLastDismissedAt = updateModalLastDismissedAt;
    });
  }

  /**
   * Record the timestamp of the last time the user has updated
   *
   * @param lastUpdatedAt - timestamp of the last time the user has updated
   */
  setLastUpdatedAt(lastUpdatedAt) {
    this.update(state => {
      state.lastUpdatedAt = lastUpdatedAt;
    });
  }

  /**
   * Sets the inactive timeout for the app
   *
   * @param timeoutMinutes - The inactive timeout in minutes.
   */

  /**
   * Sets the current browser and OS environment
   *
   * @param os
   * @param browser
   */
  setBrowserEnvironment(os, browser) {
    this.update(state => {
      state.browserEnvironment = {
        os,
        browser
      };
    });
  }

  /**
   * Adds a pollingToken for a given environmentType
   *
   * @param pollingToken
   * @param pollingTokenType
   */
  addPollingToken(pollingToken, pollingTokenType) {
    if (pollingTokenType.toString() !== _app.POLLING_TOKEN_ENVIRONMENT_TYPES[_app.ENVIRONMENT_TYPE_BACKGROUND]) {
      if (_assertClassBrand(_AppStateController_brand, this, _isValidPollingTokenType).call(this, pollingTokenType)) {
        _assertClassBrand(_AppStateController_brand, this, _updatePollingTokens).call(this, pollingToken, pollingTokenType);
      }
    }
  }

  /**
   * Updates the polling token in the state.
   *
   * @param pollingToken
   * @param pollingTokenType
   */

  /**
   * removes a pollingToken for a given environmentType
   *
   * @param pollingToken
   * @param pollingTokenType
   */
  removePollingToken(pollingToken, pollingTokenType) {
    if (pollingTokenType.toString() !== _app.POLLING_TOKEN_ENVIRONMENT_TYPES[_app.ENVIRONMENT_TYPE_BACKGROUND]) {
      const currentTokens = this.state[pollingTokenType];
      if (_assertClassBrand(_AppStateController_brand, this, _isValidPollingTokenType).call(this, pollingTokenType)) {
        this.update(state => {
          state[pollingTokenType] = currentTokens.filter(token => token !== pollingToken);
        });
      }
    }
  }

  /**
   * Validates whether the given polling token type is a valid one.
   *
   * @param pollingTokenType
   * @returns true if valid, false otherwise.
   */

  /**
   * clears all pollingTokens
   */
  clearPollingTokens() {
    this.update(state => {
      state.popupGasPollTokens = [];
      state.notificationGasPollTokens = [];
      state.fullScreenGasPollTokens = [];
    });
  }

  /**
   * Sets whether the testnet dismissal link should be shown in the network dropdown
   *
   * @param showTestnetMessageInDropdown
   */
  setShowTestnetMessageInDropdown(showTestnetMessageInDropdown) {
    this.update(state => {
      state.showTestnetMessageInDropdown = showTestnetMessageInDropdown;
    });
  }

  /**
   * Sets whether the beta notification heading on the home page
   *
   * @param showBetaHeader
   */
  setShowBetaHeader(showBetaHeader) {
    this.update(state => {
      state.showBetaHeader = showBetaHeader;
    });
  }

  /**
   * Sets whether the permissions tour should be shown to the user
   *
   * @param showPermissionsTour
   */
  setShowPermissionsTour(showPermissionsTour) {
    this.update(state => {
      state.showPermissionsTour = showPermissionsTour;
    });
  }

  /**
   * Sets whether the multichain intro modal has been shown to the user
   *
   * @param hasShown - Whether the modal has been shown
   */
  setHasShownMultichainAccountsIntroModal(hasShown) {
    this.update(state => {
      state.hasShownMultichainAccountsIntroModal = hasShown;
    });
  }

  /**
   * Sets the product tour to be shown to the user
   *
   * @param productTour - Tour name to show (e.g., 'accountIcon') or empty string to hide
   */
  setProductTour(productTour) {
    this.update(state => {
      state.productTour = productTour;
    });
  }

  /**
   * Sets whether the Network Banner should be shown
   *
   * @param showNetworkBanner
   */
  setShowNetworkBanner(showNetworkBanner) {
    this.update(state => {
      state.showNetworkBanner = showNetworkBanner;
    });
  }

  /**
   * Updates the network connection banner state
   *
   * @param networkConnectionBanner - The new banner state
   */
  updateNetworkConnectionBanner(networkConnectionBanner) {
    this.update(state => {
      state.networkConnectionBanner = networkConnectionBanner;
    });
  }

  /**
   * Sets whether the Account Banner should be shown
   *
   * @param showAccountBanner
   */
  setShowAccountBanner(showAccountBanner) {
    this.update(state => {
      state.showAccountBanner = showAccountBanner;
    });
  }

  /**
   * Sets a unique ID for the current extension popup
   *
   * @param currentExtensionPopupId
   */
  setCurrentExtensionPopupId(currentExtensionPopupId) {
    this.update(state => {
      state.currentExtensionPopupId = currentExtensionPopupId;
    });
  }

  /**
   * Sets a property indicating the model of the user's Trezor hardware wallet
   *
   * @param trezorModel - The Trezor model.
   */
  setTrezorModel(trezorModel) {
    this.update(state => {
      state.trezorModel = trezorModel;
    });
  }

  /**
   * A setter for the `nftsDropdownState` property
   *
   * @param nftsDropdownState
   */
  updateNftDropDownState(nftsDropdownState) {
    this.update(state => {
      // @ts-expect-error this is caused by a bug in Immer, not being able to handle recursive types like Json
      state.nftsDropdownState = nftsDropdownState;
    });
  }
  getSignatureSecurityAlertResponse(securityAlertId) {
    return this.state.signatureSecurityAlertResponses[securityAlertId];
  }
  addSignatureSecurityAlertResponse(securityAlertResponse) {
    if (securityAlertResponse.securityAlertId) {
      this.update(state => {
        state.signatureSecurityAlertResponses[String(securityAlertResponse.securityAlertId)] = securityAlertResponse;
      });
    }
  }
  /**
   * A setter for the currentPopupId which indicates the id of popup window that's currently active
   *
   * @param currentPopupId
   */
  setCurrentPopupId(currentPopupId) {
    this.update(state => {
      state.currentPopupId = currentPopupId;
    });
  }

  /**
   * The function returns information about the last confirmation user interacted with
   */
  getLastInteractedConfirmationInfo() {
    return this.state.lastInteractedConfirmationInfo;
  }

  /**
   * Update the information about the last confirmation user interacted with
   *
   * @param lastInteractedConfirmationInfo
   */
  setLastInteractedConfirmationInfo(lastInteractedConfirmationInfo) {
    this.update(state => {
      state.lastInteractedConfirmationInfo = lastInteractedConfirmationInfo;
    });
  }

  /**
   * A getter to retrieve currentPopupId saved in the appState
   */
  getCurrentPopupId() {
    return this.state.currentPopupId;
  }
  getThrottledOriginState(origin) {
    return this.state.throttledOrigins[origin];
  }
  updateThrottledOriginState(origin, throttledOriginState) {
    this.update(state => {
      state.throttledOrigins[origin] = throttledOriginState;
    });
  }

  /**
   * Completes a QR code scan by resolving the promise with the scanned data.
   *
   * @param scannedData - The data that was scanned from the QR code.
   * @throws If no QR code scan is in progress.
   */
  completeQrCodeScan(scannedData) {
    if (!_classPrivateFieldGet(_qrCodeScanPromise, this)) {
      throw new Error('No QR code scan is in progress.');
    }
    this.update(state => {
      state.activeQrCodeScanRequest = null;
    });
    _classPrivateFieldGet(_qrCodeScanPromise, this).resolve(scannedData);
    _classPrivateFieldSet(_qrCodeScanPromise, this, null);
  }

  /**
   * Cancels the current QR code scan, if one is in progress.
   * This will reject the promise with an error.
   *
   * @param error - The error to reject the promise with.
   * @throws If no QR code scan is in progress.
   */
  cancelQrCodeScan(error) {
    if (!_classPrivateFieldGet(_qrCodeScanPromise, this)) {
      throw new Error('No QR code scan is in progress.');
    }
    this.update(state => {
      state.activeQrCodeScanRequest = null;
    });
    _classPrivateFieldGet(_qrCodeScanPromise, this).reject(error || new Error('Scan cancelled'));
    _classPrivateFieldSet(_qrCodeScanPromise, this, null);
  }

  /**
   * Requests a QR code scan and returns a promise that resolves with the scanned data.
   * If a scan is already in progress, it returns the existing promise.
   *
   * @param request - The QR code scan request.
   * @returns The scanned QR code data.
   */

  setEnableEnforcedSimulations(enabled) {
    this.update(state => {
      state.enableEnforcedSimulations = enabled;
    });
  }
  setEnableEnforcedSimulationsForTransaction(transactionId, enabled) {
    this.update(state => {
      state.enableEnforcedSimulationsForTransactions[transactionId] = enabled;
    });
  }
  setEnforcedSimulationsSlippage(value) {
    this.update(state => {
      state.enforcedSimulationsSlippage = value;
    });
  }
  setEnforcedSimulationsSlippageForTransaction(transactionId, value) {
    this.update(state => {
      state.enforcedSimulationsSlippageForTransactions[transactionId] = value;
    });
  }
  setShowShieldEntryModalOnce(showShieldEntryModalOnce) {
    this.update(state => {
      state.showShieldEntryModalOnce = showShieldEntryModalOnce;
    });
  }
}
exports.AppStateController = AppStateController;
function _waitForUnlock(resolve, shouldShowUnlockRequest) {
  this.waitingForUnlock.push({
    resolve
  });
  this.messagingSystem.publish('AppStateController:unlockChange');
  if (shouldShowUnlockRequest) {
    _assertClassBrand(_AppStateController_brand, this, _requestApproval).call(this);
  }
}
/**
 * Drains the waitingForUnlock queue, resolving all the related Promises.
 */
function _handleUnlock() {
  if (this.waitingForUnlock.length > 0) {
    while (this.waitingForUnlock.length > 0) {
      var _this$waitingForUnloc;
      (_this$waitingForUnloc = this.waitingForUnlock.shift()) === null || _this$waitingForUnloc === void 0 || _this$waitingForUnloc.resolve();
    }
    this.messagingSystem.publish('AppStateController:unlockChange');
  }
  _assertClassBrand(_AppStateController_brand, this, _acceptApproval).call(this);
}
function _setInactiveTimeout(timeoutMinutes) {
  this.update(state => {
    state.timeoutMinutes = timeoutMinutes;
  });
  _assertClassBrand(_AppStateController_brand, this, _resetTimer).call(this);
}
/**
 * Resets the internal inactive timer
 *
 * If the {@code timeoutMinutes} state is falsy (i.e., zero) then a new
 * timer will not be created.
 *
 */
function _resetTimer() {
  const {
    timeoutMinutes
  } = this.state;
  if (_classPrivateFieldGet(_timer, this)) {
    clearTimeout(_classPrivateFieldGet(_timer, this));
  } else if (_mv.isManifestV3) {
    _classPrivateFieldGet(_extension, this).alarms.clear(_alarms.AUTO_LOCK_TIMEOUT_ALARM);
  }
  if (!timeoutMinutes) {
    return;
  }

  // This is a temporary fix until we add a state migration.
  // Due to a bug in ui/pages/settings/advanced-tab/advanced-tab.component.js,
  // it was possible for timeoutMinutes to be saved as a string, as explained
  // in PR 25109. `alarms.create` will fail in that case. We are
  // converting this to a number here to prevent that failure. Once
  // we add a migration to update the malformed state to the right type,
  // we will remove this conversion.
  const timeoutToSet = Number(timeoutMinutes);
  if (_mv.isManifestV3) {
    _classPrivateFieldGet(_extension, this).alarms.create(_alarms.AUTO_LOCK_TIMEOUT_ALARM, {
      delayInMinutes: timeoutToSet,
      periodInMinutes: timeoutToSet
    });
    _classPrivateFieldGet(_extension, this).alarms.onAlarm.addListener(alarmInfo => {
      if (alarmInfo.name === _alarms.AUTO_LOCK_TIMEOUT_ALARM) {
        _classPrivateFieldGet(_onInactiveTimeout, this).call(this);
        _classPrivateFieldGet(_extension, this).alarms.clear(_alarms.AUTO_LOCK_TIMEOUT_ALARM);
      }
    });
  } else {
    _classPrivateFieldSet(_timer, this, setTimeout(() => _classPrivateFieldGet(_onInactiveTimeout, this).call(this), timeoutToSet * _time.MINUTE));
  }
}
function _updatePollingTokens(pollingToken, pollingTokenType) {
  this.update(state => {
    state[pollingTokenType].push(pollingToken);
  });
}
function _isValidPollingTokenType(pollingTokenType) {
  const validTokenTypes = ['popupGasPollTokens', 'notificationGasPollTokens', 'fullScreenGasPollTokens'];
  return validTokenTypes.includes(pollingTokenType);
}
function _requestApproval() {
  // If we already have a pending request this is a no-op
  if (_classPrivateFieldGet(_approvalRequestId, this)) {
    return;
  }
  _classPrivateFieldSet(_approvalRequestId, this, (0, _uuid.v4)());
  this.messagingSystem.call('ApprovalController:addRequest', {
    id: _classPrivateFieldGet(_approvalRequestId, this),
    origin: _app.ORIGIN_METAMASK,
    type: _controllerUtils.ApprovalType.Unlock
  }, true).catch(() => {
    // If the promise fails, we allow a new popup to be triggered
    _classPrivateFieldSet(_approvalRequestId, this, null);
  });
}
function _acceptApproval() {
  if (!_classPrivateFieldGet(_approvalRequestId, this)) {
    return;
  }
  try {
    this.messagingSystem.call('ApprovalController:acceptRequest', _classPrivateFieldGet(_approvalRequestId, this));
  } catch (error) {
    _loglevel.default.error('Failed to unlock approval request', error);
  }
  _classPrivateFieldSet(_approvalRequestId, this, null);
}
function _requestQrCodeScan(request) {
  if (_classPrivateFieldGet(_qrCodeScanPromise, this)) {
    return _classPrivateFieldGet(_qrCodeScanPromise, this).promise;
  }
  const deferredPromise = (0, _utils.createDeferredPromise)();
  _classPrivateFieldSet(_qrCodeScanPromise, this, deferredPromise);
  this.update(state => {
    state.activeQrCodeScanRequest = request;
  });
  return deferredPromise.promise;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controllers\\app-state-controller.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\decrypt-message.ts", {"../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontrollers%5Cdecrypt-message.ts
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isEIP1024EncryptedMessage = exports.getDefaultState = exports.default = void 0;
var _loglevel = _interopRequireDefault(require("loglevel"));
var _baseController = require("@metamask/base-controller");
var _controllerUtils = require("@metamask/controller-utils");
var _utils = require("@metamask/utils");
var _metametrics = require("../../../shared/constants/metametrics");
var _hexstringUtils = require("../../../shared/modules/hexstring-utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
// This import is only used for the type.
// eslint-disable-next-line import/no-restricted-paths

const controllerName = 'DecryptMessageController';
const stateMetadata = {
  unapprovedDecryptMsgs: {
    includeInStateLogs: true,
    persist: false,
    anonymous: false,
    usedInUi: true
  },
  unapprovedDecryptMsgCount: {
    includeInStateLogs: true,
    persist: false,
    anonymous: false,
    usedInUi: true
  }
};

/**
 * Type guard that checks for the presence of the required properties
 * for EIP-1024 encrypted data.
 *
 * See: https://eips.ethereum.org/EIPS/eip-1024
 *
 * @param message - The message to check.
 * @param message.from - The sender of the message.
 * @param message.data - The EIP-1024 encrypted data.
 * @returns Whether the message is an EIP-1024 encrypted message.
 */
const isEIP1024EncryptedMessage = message => {
  if ((0, _utils.isObject)(message.data) && (0, _utils.hasProperty)(message.data, 'version') && (0, _utils.hasProperty)(message.data, 'nonce') && (0, _utils.hasProperty)(message.data, 'ephemPublicKey') && (0, _utils.hasProperty)(message.data, 'ciphertext')) {
    return true;
  }
  return false;
};
exports.isEIP1024EncryptedMessage = isEIP1024EncryptedMessage;
const getDefaultState = () => ({
  unapprovedDecryptMsgs: {},
  unapprovedDecryptMsgCount: 0
});
exports.getDefaultState = getDefaultState;
/**
 * Controller for decrypt signing requests requiring user approval.
 */
class DecryptMessageController extends _baseController.BaseController {
  /**
   * Construct a DecryptMessage controller.
   *
   * @param options - The controller options.
   * @param options.getState - Callback to retrieve all user state.
   * @param options.messenger - A reference to the messaging system.
   * @param options.metricsEvent - A function for emitting a metric event.
   * @param options.manager - A reference to the message manager.
   */
  constructor({
    getState,
    metricsEvent,
    messenger,
    manager
  }) {
    super({
      metadata: stateMetadata,
      messenger,
      name: controllerName,
      state: getDefaultState()
    });
    _defineProperty(this, "_getState", void 0);
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    _defineProperty(this, "_metricsEvent", void 0);
    _defineProperty(this, "_decryptMessageManager", void 0);
    this._getState = getState;
    this._metricsEvent = metricsEvent;
    this._decryptMessageManager = manager;
    messenger.subscribe('DecryptMessageManager:unapprovedMessage', this._requestApproval.bind(this));
    this._subscribeToMessageState(messenger, (state, newMessages, messageCount) => {
      state.unapprovedDecryptMsgs = newMessages;
      state.unapprovedDecryptMsgCount = messageCount;
    });
  }

  /**
   * A getter for the number of 'unapproved' Messages in the DecryptMessageManager.
   *
   * @returns The number of 'unapproved' Messages in the DecryptMessageManager.
   */
  get unapprovedDecryptMsgCount() {
    return this._decryptMessageManager.getUnapprovedMessagesCount();
  }

  /**
   * Reset the controller state to the initial state.
   */
  resetState() {
    this.update(() => getDefaultState());
  }

  /**
   * Clears all unapproved messages from memory.
   */
  clearUnapproved() {
    this._decryptMessageManager.clearUnapprovedMessages();
  }

  /**
   * Called when a dapp uses the eth_decrypt method
   *
   * @param messageParams - The params passed to eth_decrypt.
   * @param req - The original request, containing the origin.
   * @returns Promise resolving to the raw data of the signature request.
   */
  async newRequestDecryptMessage(messageParams, req) {
    return this._decryptMessageManager.addUnapprovedMessageAsync(messageParams, req);
  }

  /**
   * Signifies a user's approval to decrypt a message in queue.
   * Triggers decrypt, and the callback function from newUnsignedDecryptMessage.
   *
   * @param messageParams - The params of the message to decrypt & return to the Dapp.
   * @returns A full state update.
   */
  async decryptMessage(messageParams) {
    const messageId = messageParams.metamaskId;
    try {
      const cleanMessageParams = await this._decryptMessageManager.approveMessage(messageParams);
      cleanMessageParams.data = this._parseMessageData(cleanMessageParams.data);
      if (!isEIP1024EncryptedMessage(cleanMessageParams)) {
        throw new Error('Invalid encrypted data.');
      }
      const rawMessage = await this.messagingSystem.call('KeyringController:decryptMessage', cleanMessageParams);
      this._decryptMessageManager.setMessageStatusAndResult(messageId, rawMessage, 'decrypted');
      this._acceptApproval(messageId);
    } catch (error) {
      _loglevel.default.info('MetaMaskController - eth_decrypt failed.', error);
      this._cancelAbstractMessage(this._decryptMessageManager, messageId);
      throw error;
    }
    return this._getState();
  }

  /**
   * Only decrypt message and don't touch transaction state
   *
   * @param messageParams - The params of the message to decrypt.
   * @returns A full state update.
   */
  async decryptMessageInline(messageParams) {
    const messageId = messageParams.metamaskId;
    messageParams.data = this._parseMessageData(messageParams.data);
    if (!isEIP1024EncryptedMessage(messageParams)) {
      throw new Error('Invalid encrypted data.');
    }
    const rawMessage = await this.messagingSystem.call('KeyringController:decryptMessage', messageParams);
    this._decryptMessageManager.setResult(messageId, rawMessage);
    return this._getState();
  }

  /**
   * Used to cancel a eth_decrypt type message.
   *
   * @param messageId - The ID of the message to cancel.
   * @returns A full state update.
   */
  cancelDecryptMessage(messageId) {
    this._decryptMessageManager.rejectMessage(messageId);
    this._rejectApproval(messageId);
    return this._getState();
  }

  /**
   * Reject all unapproved messages of any type.
   *
   * @param reason - A message to indicate why.
   */
  rejectUnapproved(reason) {
    Object.keys(this._decryptMessageManager.getUnapprovedMessages()).forEach(messageId => {
      this._cancelAbstractMessage(this._decryptMessageManager, messageId, reason);
    });
  }
  _acceptApproval(messageId) {
    this.messagingSystem.call('ApprovalController:acceptRequest', messageId);
  }
  _cancelAbstractMessage(messageManager, messageId, reason) {
    if (reason) {
      this._metricsEvent({
        event: reason,
        category: _metametrics.MetaMetricsEventCategory.Messages,
        properties: {
          action: 'Decrypt Message Request'
        }
      });
    }
    messageManager.rejectMessage(messageId);
    this._rejectApproval(messageId);
    return this._getState();
  }
  _subscribeToMessageState(controllerMessenger, updateState) {
    controllerMessenger.subscribe('DecryptMessageManager:stateChange', state => {
      const newMessages = this._migrateMessages(
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      state.unapprovedMessages);
      this.update(draftState => {
        updateState(draftState, newMessages, state.unapprovedMessagesCount);
      });
    });
  }
  _migrateMessages(coreMessages) {
    const stateMessages = {};
    for (const messageId of Object.keys(coreMessages)) {
      const coreMessage = coreMessages[messageId];
      const stateMessage = this._migrateMessage(coreMessage);
      stateMessages[messageId] = stateMessage;
    }
    return stateMessages;
  }
  _migrateMessage(coreMessage) {
    const {
      messageParams,
      ...coreMessageData
    } = coreMessage;
    const stateMessage = {
      ...coreMessageData,
      rawSig: coreMessage.rawSig,
      msgParams: messageParams,
      origin: messageParams.origin
    };
    return stateMessage;
  }
  _requestApproval(messageParams) {
    const id = messageParams.metamaskId;
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    const origin = messageParams.origin || _controllerUtils.ORIGIN_METAMASK;
    try {
      this.messagingSystem.call('ApprovalController:addRequest', {
        id,
        origin,
        type: _controllerUtils.ApprovalType.EthDecrypt
      }, true);
    } catch (error) {
      _loglevel.default.info('Error adding request to approval controller', error);
    }
  }
  _parseMessageData(data) {
    const stripped = (0, _hexstringUtils.stripHexPrefix)(data);
    const buff = Buffer.from(stripped, 'hex');
    return JSON.parse(buff.toString('utf8'));
  }
  _rejectApproval(messageId) {
    try {
      this.messagingSystem.call('ApprovalController:rejectRequest', messageId, 'Cancel');
    } catch (error) {
      _loglevel.default.info('Error rejecting request to approval controller', error);
    }
  }
}
exports.default = DecryptMessageController;

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controllers\\decrypt-message.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\encryption-public-key.ts", {"../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../shared/constants/keyring":"D:\\code\\v\\metamask-extension\\shared\\constants\\keyring.ts","../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontrollers%5Cencryption-public-key.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _loglevel = _interopRequireDefault(require("loglevel"));
var _baseController = require("@metamask/base-controller");
var _metametrics = require("../../../shared/constants/metametrics");
var _keyring = require("../../../shared/constants/keyring");
var _app = require("../../../shared/constants/app");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
const controllerName = 'EncryptionPublicKeyController';
const methodNameGetEncryptionPublicKey = 'eth_getEncryptionPublicKey';
const stateMetadata = {
  unapprovedEncryptionPublicKeyMsgs: {
    includeInStateLogs: true,
    persist: false,
    anonymous: false,
    usedInUi: true
  },
  unapprovedEncryptionPublicKeyMsgCount: {
    includeInStateLogs: true,
    persist: false,
    anonymous: false,
    usedInUi: true
  }
};
const getDefaultState = () => ({
  unapprovedEncryptionPublicKeyMsgs: {},
  unapprovedEncryptionPublicKeyMsgCount: 0
});
/**
 * Controller for requesting encryption public key requests requiring user approval.
 */
class EncryptionPublicKeyController extends _baseController.BaseController {
  /**
   * Construct a EncryptionPublicKey controller.
   *
   * @param options - The controller options.
   * @param options.messenger - The restricted controller messenger for the EncryptionPublicKey controller.
   * @param options.getEncryptionPublicKey - Callback to get the keyring encryption public key.
   * @param options.getAccountKeyringType - Callback to get the keyring type.
   * @param options.getState - Callback to retrieve all user state.
   * @param options.metricsEvent - A function for emitting a metric event.
   * @param options.manager - A reference to the encryption public key manager.
   */
  constructor({
    messenger,
    manager,
    getEncryptionPublicKey,
    getAccountKeyringType,
    getState,
    metricsEvent
  }) {
    super({
      name: controllerName,
      metadata: stateMetadata,
      messenger,
      state: getDefaultState()
    });
    _defineProperty(this, "_getEncryptionPublicKey", void 0);
    _defineProperty(this, "_getAccountKeyringType", void 0);
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    _defineProperty(this, "_getState", void 0);
    _defineProperty(this, "_encryptionPublicKeyManager", void 0);
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    _defineProperty(this, "_metricsEvent", void 0);
    this._getEncryptionPublicKey = getEncryptionPublicKey;
    this._getAccountKeyringType = getAccountKeyringType;
    this._getState = getState;
    this._metricsEvent = metricsEvent;
    this._encryptionPublicKeyManager = manager;
    this.messagingSystem.subscribe('EncryptionPublicKeyManager:unapprovedMessage', this._requestApproval.bind(this));
    this._subscribeToMessageState(messenger, (state, newMessages, messageCount) => {
      state.unapprovedEncryptionPublicKeyMsgs = newMessages;
      state.unapprovedEncryptionPublicKeyMsgCount = messageCount;
    });
  }

  /**
   * A getter for the number of 'unapproved' Messages in this.messages
   *
   * @returns The number of 'unapproved' Messages in this.messages
   */
  get unapprovedMsgCount() {
    return this._encryptionPublicKeyManager.getUnapprovedMessagesCount();
  }

  /**
   * Reset the controller state to the initial state.
   */
  resetState() {
    this.update(() => getDefaultState());
  }

  /**
   * Called when a Dapp uses the eth_getEncryptionPublicKey method, to request user approval.
   *
   * @param address - The address from the encryption public key will be extracted.
   * @param [req] - The original request, containing the origin.
   */
  async newRequestEncryptionPublicKey(address, req) {
    const keyringType = await this._getAccountKeyringType(address);
    switch (keyringType) {
      case _keyring.KeyringType.ledger:
        {
          return new Promise((_, reject) => {
            reject(new Error('Ledger does not support eth_getEncryptionPublicKey.'));
          });
        }
      case _keyring.KeyringType.trezor:
        {
          return new Promise((_, reject) => {
            reject(new Error('Trezor does not support eth_getEncryptionPublicKey.'));
          });
        }
      case _keyring.KeyringType.lattice:
        {
          return new Promise((_, reject) => {
            reject(new Error('Lattice does not support eth_getEncryptionPublicKey.'));
          });
        }
      case _keyring.KeyringType.qr:
        {
          return Promise.reject(new Error('QR hardware does not support eth_getEncryptionPublicKey.'));
        }
      default:
        {
          return this._encryptionPublicKeyManager.addUnapprovedMessageAsync({
            from: address
          }, req);
        }
    }
  }

  /**
   * Signifies a user's approval to receiving encryption public key in queue.
   *
   * @param msgParams - The params of the message to receive & return to the Dapp.
   * @returns A full state update.
   */
  async encryptionPublicKey(msgParams) {
    _loglevel.default.info('MetaMaskController - encryptionPublicKey');
    const messageId = msgParams.metamaskId;
    // sets the status op the message to 'approved'
    // and removes the metamaskId for decryption
    try {
      const cleanMessageParams = await this._encryptionPublicKeyManager.approveMessage(msgParams);

      // EncryptionPublicKey message
      const publicKey = await this._getEncryptionPublicKey(cleanMessageParams.from);

      // tells the listener that the message has been processed
      // and can be returned to the dapp
      this._encryptionPublicKeyManager.setMessageStatusAndResult(messageId, publicKey, 'received');
      this._acceptApproval(messageId);
      return this._getState();
    } catch (error) {
      _loglevel.default.info('MetaMaskController - eth_getEncryptionPublicKey failed.', error);
      this._cancelAbstractMessage(this._encryptionPublicKeyManager, messageId);
      throw error;
    }
  }

  /**
   * Used to cancel a message submitted via eth_getEncryptionPublicKey.
   *
   * @param msgId - The id of the message to cancel.
   */
  cancelEncryptionPublicKey(msgId) {
    return this._cancelAbstractMessage(this._encryptionPublicKeyManager, msgId);
  }

  /**
   * Reject all unapproved messages of any type.
   *
   * @param reason - A message to indicate why.
   */
  rejectUnapproved(reason) {
    Object.keys(this._encryptionPublicKeyManager.getUnapprovedMessages()).forEach(messageId => {
      this._cancelAbstractMessage(this._encryptionPublicKeyManager, messageId, reason);
    });
  }

  /**
   * Clears all unapproved messages from memory.
   */
  clearUnapproved() {
    this._encryptionPublicKeyManager.clearUnapprovedMessages();
  }
  _cancelAbstractMessage(messageManager, messageId, reason) {
    if (reason) {
      this._metricsEvent({
        event: reason,
        category: _metametrics.MetaMetricsEventCategory.Messages,
        properties: {
          action: 'Encryption public key Request'
        }
      });
    }
    messageManager.rejectMessage(messageId);
    this._rejectApproval(messageId);
    return this._getState();
  }
  _subscribeToMessageState(controllerMessenger, updateState) {
    controllerMessenger.subscribe('EncryptionPublicKeyManager:stateChange', state => {
      const newMessages = this._migrateMessages(
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      state.unapprovedMessages);
      this.update(draftState => {
        updateState(draftState, newMessages, state.unapprovedMessagesCount);
      });
    });
  }
  _migrateMessages(coreMessages) {
    const stateMessages = {};
    for (const messageId of Object.keys(coreMessages)) {
      const coreMessage = coreMessages[messageId];
      const stateMessage = this._migrateMessage(coreMessage);
      stateMessages[messageId] = stateMessage;
    }
    return stateMessages;
  }
  _migrateMessage(coreMessage) {
    const {
      messageParams,
      ...coreMessageData
    } = coreMessage;

    // Core message managers use messageParams but frontend uses msgParams with lots of references
    const stateMessage = {
      ...coreMessageData,
      rawSig: coreMessage.rawSig,
      msgParams: messageParams.from,
      origin: messageParams.origin
    };
    return stateMessage;
  }
  _requestApproval(msgParams) {
    const id = msgParams.metamaskId;
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    const origin = msgParams.origin || _app.ORIGIN_METAMASK;
    this.messagingSystem.call('ApprovalController:addRequest', {
      id,
      origin,
      type: methodNameGetEncryptionPublicKey
    }, true).catch(() => {
      // Intentionally ignored as promise not currently used
    });
  }
  _acceptApproval(messageId) {
    this.messagingSystem.call('ApprovalController:acceptRequest', messageId);
  }
  _rejectApproval(messageId) {
    this.messagingSystem.call('ApprovalController:rejectRequest', messageId, 'Cancel');
  }
}
exports.default = EncryptionPublicKeyController;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controllers\\encryption-public-key.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\institutional-snap\\InstitutionalSnapController.ts", {"../../../../shared/lib/accounts/institutional-wallet-snap":"D:\\code\\v\\metamask-extension\\shared\\lib\\accounts\\institutional-wallet-snap.ts","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontrollers%5Cinstitutional-snap%5CInstitutionalSnapController.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstitutionalSnapController = void 0;
var _transactionController = require("@metamask/transaction-controller");
var _snapsUtils = require("@metamask/snaps-utils");
var _baseController = require("@metamask/base-controller");
var _controllerUtils = require("@metamask/controller-utils");
var _institutionalWalletSnap = require("../../../../shared/lib/accounts/institutional-wallet-snap");
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
const SNAP_ID = _institutionalWalletSnap.INSTITUTIONAL_WALLET_SNAP_ID;
const controllerName = 'InstitutionalSnapController';
const metadata = {};
var _InstitutionalSnapController_brand = /*#__PURE__*/new WeakSet();
class InstitutionalSnapController extends _baseController.BaseController {
  constructor({
    messenger
  }) {
    super({
      messenger,
      name: controllerName,
      state: {},
      metadata
    });
    _classPrivateMethodInitSpec(this, _InstitutionalSnapController_brand);
    _assertClassBrand(_InstitutionalSnapController_brand, this, _registerMessageHandlers).call(this);
  }
  async deferPublicationHook(transactionMeta) {
    const shouldDefer = await _assertClassBrand(_InstitutionalSnapController_brand, this, _shouldDeferPublication).call(this, transactionMeta);
    if (shouldDefer) {
      const updatedTransactionParameters = await _assertClassBrand(_InstitutionalSnapController_brand, this, _getUpdatedTransactionParameters).call(this, transactionMeta);
      await _assertClassBrand(_InstitutionalSnapController_brand, this, _updateTransaction).call(this, transactionMeta.id, updatedTransactionParameters);
      return false;
    }
    return true;
  }
  async beforeCheckPendingTransactionHook(transactionMeta) {
    return !(await _assertClassBrand(_InstitutionalSnapController_brand, this, _shouldDeferPublication).call(this, transactionMeta));
  }
}
exports.InstitutionalSnapController = InstitutionalSnapController;
function _registerMessageHandlers() {
  this.messagingSystem.registerActionHandler(`${controllerName}:publishHook`, this.deferPublicationHook.bind(this));
  this.messagingSystem.registerActionHandler(`${controllerName}:beforeCheckPendingTransactionHook`, this.beforeCheckPendingTransactionHook.bind(this));
}
async function _handleSnapRequest(args) {
  const response = await this.messagingSystem.call('SnapController:handleRequest', args);
  return response;
}
async function _getUpdatedTransactionParameters(transactionMeta) {
  const searchParams = {
    from: transactionMeta.txParams.from,
    to: transactionMeta.txParams.to,
    value: transactionMeta.txParams.value,
    data: transactionMeta.txParams.data,
    chainId: transactionMeta.chainId
  };
  const snapGetMutableTransactionParamsPayload = {
    snapId: SNAP_ID,
    origin: _controllerUtils.ORIGIN_METAMASK,
    handler: _snapsUtils.HandlerType.OnRpcRequest,
    request: {
      method: 'transactions.getMutableTransactionParameters',
      params: searchParams
    }
  };
  const snapResponse = await _assertClassBrand(_InstitutionalSnapController_brand, this, _handleSnapRequest).call(this, snapGetMutableTransactionParamsPayload);
  const hash = snapResponse.transaction.transactionHash;
  return {
    hash,
    nonce: snapResponse.transaction.nonce,
    gasLimit: snapResponse.transaction.gasLimit,
    maxFeePerGas: snapResponse.transaction.maxFeePerGas,
    maxPriorityFeePerGas: snapResponse.transaction.maxPriorityFeePerGas,
    type: snapResponse.transaction.type,
    status: _transactionController.TransactionStatus.submitted
  };
}
async function _updateTransaction(transactionId, {
  status,
  hash,
  nonce,
  gasLimit,
  maxFeePerGas,
  maxPriorityFeePerGas,
  type
}) {
  const response = await this.messagingSystem.call('TransactionController:updateCustodialTransaction', {
    transactionId,
    status,
    hash,
    nonce,
    gasLimit,
    maxFeePerGas,
    maxPriorityFeePerGas,
    type
  });
  return response;
}
async function _shouldDeferPublication(transactionMeta) {
  var _account$options$cust;
  const account = await this.messagingSystem.call('AccountsController:getAccountByAddress', transactionMeta.txParams.from);
  return account === null || account === void 0 || (_account$options$cust = account.options.custodian) === null || _account$options$cust === void 0 ? void 0 : _account$options$cust.deferPublication;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controllers\\institutional-snap\\InstitutionalSnapController.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\metametrics-controller.ts", {"../../../development/build/constants":"D:\\code\\v\\metamask-extension\\development\\build\\constants.js","../../../shared/constants/alarms":"D:\\code\\v\\metamask-extension\\shared\\constants\\alarms.js","../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../shared/constants/keyring":"D:\\code\\v\\metamask-extension\\shared\\constants\\keyring.ts","../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../shared/modules/mv3.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\mv3.utils.js","../lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/name-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\name-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js","ethereumjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\ethereumjs-util\\dist.browser\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","uuid":"D:\\code\\v\\metamask-extension\\node_modules\\uuid\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontrollers%5Cmetametrics-controller.ts
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.overrideAnonymousEventNames = exports.getDefaultMetaMetricsControllerState = exports.default = void 0;
var _lodash = require("lodash");
var _ethereumjsUtil = require("ethereumjs-util");
var _uuid = require("uuid");
var _nameController = require("@metamask/name-controller");
var _utils = require("@metamask/utils");
var _baseController = require("@metamask/base-controller");
var _app = require("../../../shared/constants/app");
var _metametrics = require("../../../shared/constants/metametrics");
var _time = require("../../../shared/constants/time");
var _mv = require("../../../shared/modules/mv3.utils");
var _alarms = require("../../../shared/constants/alarms");
var _util = require("../lib/util");
var _transaction = require("../../../shared/constants/transaction");
var _trace = require("../../../shared/lib/trace");
var _constants = require("../../../development/build/constants");
var _keyring = require("../../../shared/constants/keyring");
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } ///: BEGIN:ONLY_INCLUDE_IF(build-main)
///: END:ONLY_INCLUDE_IF
// Unique name for the controller
const controllerName = 'MetaMetricsController';
const EXTENSION_UNINSTALL_URL = 'https://metamask.io/uninstalled';
const overrideAnonymousEventNames = exports.overrideAnonymousEventNames = {
  [_transaction.TransactionMetaMetricsEvent.added]: _transaction.AnonymousTransactionMetaMetricsEvent.added,
  [_transaction.TransactionMetaMetricsEvent.approved]: _transaction.AnonymousTransactionMetaMetricsEvent.approved,
  [_transaction.TransactionMetaMetricsEvent.finalized]: _transaction.AnonymousTransactionMetaMetricsEvent.finalized,
  [_transaction.TransactionMetaMetricsEvent.rejected]: _transaction.AnonymousTransactionMetaMetricsEvent.rejected,
  [_transaction.TransactionMetaMetricsEvent.submitted]: _transaction.AnonymousTransactionMetaMetricsEvent.submitted,
  [_metametrics.MetaMetricsEventName.SignatureRequested]: _metametrics.MetaMetricsEventName.SignatureRequestedAnon,
  [_metametrics.MetaMetricsEventName.SignatureApproved]: _metametrics.MetaMetricsEventName.SignatureApprovedAnon,
  [_metametrics.MetaMetricsEventName.SignatureRejected]: _metametrics.MetaMetricsEventName.SignatureRejectedAnon
};
const defaultCaptureException = err => {
  // throw error on clean stack so its captured by platform integrations (eg sentry)
  // but does not interrupt the call stack
  setTimeout(() => {
    throw err;
  });
};

// The function is used to build a unique messageId for segment messages
// It uses actionId and uniqueIdentifier from event if present
const buildUniqueMessageId = args => {
  const messageIdParts = [];
  if (args.uniqueIdentifier) {
    messageIdParts.push(args.uniqueIdentifier);
  }
  if (args.actionId) {
    messageIdParts.push(args.actionId);
  }
  if (messageIdParts.length && args.isDuplicateAnonymizedEvent) {
    messageIdParts.push('0x000');
  }
  if (messageIdParts.length) {
    return messageIdParts.join('-');
  }
  return (0, _util.generateRandomId)();
};
const exceptionsToFilter = {
  [`You must pass either an "anonymousId" or a "userId".`]: true
};

/**
 * The type of a Segment event to create.
 *
 * Must correspond to the name of a method in {@link Analytics}.
 */

/**
 * Represents a buffered trace that is stored before user consent.
 * Simplified for JSON serialization - doesn't include callback functions.
 */

// TODO: Complete MetaMaskState by adding the full state definition and relocate it after the background is converted to TypeScript.

/**
 * {@link MetaMetricsController}'s metadata.
 *
 * This allows us to choose if fields of the state should be persisted or not
 * using the `persist` flag; and if they can be sent to Sentry or not, using
 * the `anonymous` flag.
 */
const controllerMetadata = {
  metaMetricsId: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  participateInMetaMetrics: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  latestNonAnonymousEventTimestamp: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  fragments: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: true
  },
  eventsBeforeMetricsOptIn: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: false
  },
  tracesBeforeMetricsOptIn: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: false
  },
  traits: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: false
  },
  dataCollectionForMarketing: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: true
  },
  marketingCampaignCookieId: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: false
  },
  segmentApiCalls: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: false
  }
};

/**
 * The state that MetaMetricsController stores.
 *
 * @property metaMetricsId - The user's metaMetricsId that will be attached to all non-anonymized event payloads
 * @property participateInMetaMetrics - The user's preference for participating in the MetaMetrics analytics program.
 * This setting controls whether or not events are tracked
 * @property latestNonAnonymousEventTimestamp - The timestamp at which last non anonymous event is tracked.
 * @property fragments - Object keyed by UUID with stored fragments as values.
 * @property eventsBeforeMetricsOptIn - Array of queued events added before a user opts into metrics.
 * @property tracesBeforeMetricsOptIn - Array of queued traces added before a user opts into metrics.
 * @property traits - Traits that are not derived from other state keys.
 * @property dataCollectionForMarketing - Flag to determine if data collection for marketing is enabled.
 * @property marketingCampaignCookieId - The marketing campaign cookie id.
 * @property segmentApiCalls - Object keyed by messageId with segment event type and payload as values.
 */

/**
 * Returns the state of the {@link MetaMetricsController}.
 */

/**
 * Actions exposed by the {@link MetaMetricsController}.
 */

/**
 * Event emitted when the state of the {@link MetaMetricsController} changes.
 */

/**
 * Actions that this controller is allowed to call.
 */

/**
 * Events that this controller is allowed to subscribe.
 */

/**
 * Messenger type for the {@link MetaMetricsController}.
 */

/**
 * Function to get default state of the {@link MetaMetricsController}.
 */
const getDefaultMetaMetricsControllerState = () => ({
  participateInMetaMetrics: null,
  metaMetricsId: null,
  dataCollectionForMarketing: null,
  marketingCampaignCookieId: null,
  latestNonAnonymousEventTimestamp: 0,
  eventsBeforeMetricsOptIn: [],
  tracesBeforeMetricsOptIn: [],
  traits: {},
  fragments: {},
  segmentApiCalls: {}
});
exports.getDefaultMetaMetricsControllerState = getDefaultMetaMetricsControllerState;
var _captureException = /*#__PURE__*/new WeakMap();
var _extension = /*#__PURE__*/new WeakMap();
var _environment = /*#__PURE__*/new WeakMap();
var _segment = /*#__PURE__*/new WeakMap();
var _MetaMetricsController_brand = /*#__PURE__*/new WeakSet();
var _getAllNFTsFlattened = /*#__PURE__*/new WeakMap();
class MetaMetricsController extends _baseController.BaseController {
  /**
   * @param options
   * @param options.state - Initial controller state.
   * @param options.messenger - Messenger used to communicate with BaseV2 controller.
   * @param options.segment - an instance of analytics for tracking
   * events that conform to the new MetaMetrics tracking plan.
   * @param options.version - The version of the extension
   * @param options.environment - The environment the extension is running in
   * @param options.extension - webextension-polyfill
   * @param options.captureException
   */
  constructor({
    state: _state = {},
    messenger,
    segment,
    version,
    environment,
    extension,
    captureException = defaultCaptureException
  }) {
    super({
      name: controllerName,
      metadata: controllerMetadata,
      state: {
        ...getDefaultMetaMetricsControllerState(),
        ..._state
      },
      messenger
    });
    /**
     * Gets the current chain ID.
     *
     * @param networkClientId - The network client ID to get the chain ID for.
     */
    _classPrivateMethodInitSpec(this, _MetaMetricsController_brand);
    _classPrivateFieldInitSpec(this, _captureException, void 0);
    _defineProperty(this, "chainId", void 0);
    _defineProperty(this, "locale", void 0);
    _defineProperty(this, "previousUserTraits", void 0);
    _defineProperty(this, "version", void 0);
    _classPrivateFieldInitSpec(this, _extension, void 0);
    _classPrivateFieldInitSpec(this, _environment, void 0);
    _classPrivateFieldInitSpec(this, _segment, void 0);
    /**
     * Returns an array of all of the NFTs the user
     * possesses across all networks and accounts.
     *
     * @param allNfts
     */
    _classPrivateFieldInitSpec(this, _getAllNFTsFlattened, (0, _lodash.memoize)((allNfts = {}) => {
      return Object.values(allNfts).reduce((result, chainNFTs) => {
        return result.concat(...Object.values(chainNFTs));
      }, []);
    }));
    _classPrivateFieldSet(_captureException, this, err => {
      const message = (0, _utils.getErrorMessage)(err);
      // This is a temporary measure. Currently there are errors flooding sentry due to a problem in how we are tracking anonymousId
      // We intend on removing this as soon as we understand how to correctly solve that problem.
      if (!exceptionsToFilter[message]) {
        captureException(err);
      }
    });
    this.chainId = _assertClassBrand(_MetaMetricsController_brand, this, _getCurrentChainId).call(this);
    const preferencesControllerState = this.messagingSystem.call('PreferencesController:getState');
    this.locale = preferencesControllerState.currentLocale.replace('_', '-');
    this.version = environment === 'production' ? version : `${version}-${environment}`;
    _classPrivateFieldSet(_extension, this, extension);
    _classPrivateFieldSet(_environment, this, environment);
    this.messagingSystem.registerActionHandler('MetaMetricsController:trackEvent', this.trackEvent.bind(this));
    this.messagingSystem.registerActionHandler('MetaMetricsController:getMetaMetricsId', this.getMetaMetricsId.bind(this));
    this.messagingSystem.registerActionHandler('MetaMetricsController:createEventFragment', this.createEventFragment.bind(this));
    this.messagingSystem.registerActionHandler('MetaMetricsController:getEventFragmentById', this.getEventFragmentById.bind(this));
    this.messagingSystem.registerActionHandler('MetaMetricsController:updateEventFragment', this.updateEventFragment.bind(this));
    this.messagingSystem.registerActionHandler('MetaMetricsController:deleteEventFragment', this.deleteEventFragment.bind(this));
    this.messagingSystem.registerActionHandler('MetaMetricsController:finalizeEventFragment', this.finalizeEventFragment.bind(this));
    const abandonedFragments = (0, _lodash.omitBy)(_state.fragments, 'persist');
    this.messagingSystem.subscribe('PreferencesController:stateChange', ({
      currentLocale
    }) => {
      this.locale = currentLocale === null || currentLocale === void 0 ? void 0 : currentLocale.replace('_', '-');
    });
    this.messagingSystem.subscribe('NetworkController:networkDidChange', ({
      selectedNetworkClientId
    }) => {
      this.chainId = _assertClassBrand(_MetaMetricsController_brand, this, _getCurrentChainId).call(this, selectedNetworkClientId);
    });
    _classPrivateFieldSet(_segment, this, segment);

    // Track abandoned fragments that weren't properly cleaned up.
    // Abandoned fragments are those that were stored in persistent memory
    // and are available at controller instance creation, but do not have the
    // 'persist' flag set. This means anytime the extension is unlocked, any
    // fragments that are not marked as persistent will be purged and the
    // failure event will be emitted.
    Object.values(abandonedFragments).forEach(fragment => {
      this.processAbandonedFragment(fragment);
    });

    // Code below submits any pending segmentApiCalls to Segment if/when the controller is re-instantiated
    if (_mv.isManifestV3) {
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      Object.values(_state.segmentApiCalls || {}).forEach(({
        eventType,
        payload
      }) => {
        try {
          _assertClassBrand(_MetaMetricsController_brand, this, _submitSegmentAPICall).call(this, eventType, payload);
        } catch (error) {
          _classPrivateFieldGet(_captureException, this).call(this, error);
        }
      });
    }

    // Close out event fragments that were created but not progressed. An
    // interval is used to routinely check if a fragment has not been updated
    // within the fragment's timeout window. When creating a new event fragment
    // a timeout can be specified that will cause an abandoned event to be
    // tracked if the event isn't progressed within that amount of time.
    if (_mv.isManifestV3) {
      /* eslint-disable no-undef */
      _classPrivateFieldGet(_extension, this).alarms.getAll().then(alarms => {
        const hasAlarm = (0, _util.checkAlarmExists)(alarms, _alarms.METAMETRICS_FINALIZE_EVENT_FRAGMENT_ALARM);
        if (!hasAlarm) {
          _classPrivateFieldGet(_extension, this).alarms.create(_alarms.METAMETRICS_FINALIZE_EVENT_FRAGMENT_ALARM, {
            delayInMinutes: 1,
            periodInMinutes: 1
          });
        }
      });
      _classPrivateFieldGet(_extension, this).alarms.onAlarm.addListener(alarmInfo => {
        if (alarmInfo.name === _alarms.METAMETRICS_FINALIZE_EVENT_FRAGMENT_ALARM) {
          this.finalizeAbandonedFragments();
        }
      });
    } else {
      setInterval(() => {
        this.finalizeAbandonedFragments();
      }, _time.SECOND * 30);
    }
  }
  finalizeAbandonedFragments() {
    Object.values(this.state.fragments).forEach(fragment => {
      if (fragment.timeout && fragment.lastUpdated && Date.now() - fragment.lastUpdated / 1000 > fragment.timeout) {
        this.processAbandonedFragment(fragment);
      }
    });
  }
  generateMetaMetricsId() {
    return (0, _ethereumjsUtil.bufferToHex)((0, _ethereumjsUtil.keccak)(Buffer.from(String(Date.now()) + String(Math.round(Math.random() * Number.MAX_SAFE_INTEGER)))));
  }

  /**
   * Create an event fragment in state and returns the event fragment object.
   *
   * @param options - Fragment settings and properties to initiate the fragment with.
   */
  createEventFragment(options) {
    if (!options.successEvent) {
      throw new Error(`Must specify success event. Success event was: ${options.event
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
      // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
      }. Payload keys were: ${Object.keys(options)}. ${typeof options.properties === 'object' ?
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
      // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
      `Payload property keys were: ${Object.keys(options.properties)}` : ''}`);
    }
    const {
      fragments
    } = this.state;
    const id = options.uniqueIdentifier ?? (0, _uuid.v4)();
    const fragment = {
      id,
      ...options,
      lastUpdated: Date.now()
    };

    /**
     * HACK: "transaction-submitted-<id>" fragment hack
     * A "transaction-submitted-<id>" fragment may exist following the "Transaction Added"
     * event to persist accumulated event fragment props to the "Transaction Submitted" event
     * which fires after a user confirms a transaction. Rejecting a confirmation does not fire the
     * "Transaction Submitted" event. In this case, these abandoned fragments will be deleted
     * instead of finalized with canDeleteIfAbandoned set to true.
     */
    const hasExistingSubmittedFragment = options.initialEvent === _transaction.TransactionMetaMetricsEvent.submitted && fragments[id];
    const additionalFragmentProps = hasExistingSubmittedFragment ? {
      ...fragments[id],
      canDeleteIfAbandoned: false
    } : {};
    this.update(state => {
      state.fragments[id] = (0, _lodash.merge)({}, additionalFragmentProps, fragment);
    });
    if (fragment.initialEvent) {
      this.trackEvent({
        event: fragment.initialEvent,
        category: fragment.category,
        properties: fragment.properties,
        sensitiveProperties: fragment.sensitiveProperties,
        page: fragment.page,
        referrer: fragment.referrer,
        revenue: fragment.revenue,
        value: fragment.value,
        currency: fragment.currency,
        environmentType: fragment.environmentType,
        actionId: options.actionId,
        uniqueIdentifier: options.uniqueIdentifier
      });
    }
    return fragment;
  }

  /**
   * Returns the fragment stored in memory with provided id or undefined if it
   * does not exist.
   *
   * @param id - id of fragment to retrieve
   */
  getEventFragmentById(id) {
    return this.state.fragments[id];
  }

  /**
   * Deletes to finalizes event fragment based on the canDeleteIfAbandoned property.
   *
   * @param fragment
   */
  processAbandonedFragment(fragment) {
    if (fragment.canDeleteIfAbandoned) {
      this.deleteEventFragment(fragment.id);
    } else {
      this.finalizeEventFragment(fragment.id, {
        abandoned: true
      });
    }
  }

  /**
   * Updates an event fragment in state
   *
   * @param id - The fragment id to update
   * @param payload - Fragment settings and properties to initiate the fragment with.
   */
  updateEventFragment(id, payload) {
    const {
      fragments
    } = this.state;
    const fragment = fragments[id];

    /**
     * HACK: "transaction-submitted-<id>" fragment hack
     * Creates a "transaction-submitted-<id>" fragment if it does not exist to persist
     * accumulated event metrics. In the case it is unused, the abandoned fragment will
     * eventually be deleted with canDeleteIfAbandoned set to true.
     */
    const createIfNotFound = !fragment && id.includes('transaction-submitted-');
    if (createIfNotFound) {
      this.update(state => {
        state.fragments[id] = {
          canDeleteIfAbandoned: true,
          category: _metametrics.MetaMetricsEventCategory.Transactions,
          successEvent: _transaction.TransactionMetaMetricsEvent.finalized,
          id,
          ...payload,
          lastUpdated: Date.now()
        };
      });
      return;
    } else if (!fragment) {
      throw new Error(`Event fragment with id ${id} does not exist.`);
    }
    this.update(state => {
      state.fragments[id] = (0, _lodash.merge)(state.fragments[id], {
        ...payload,
        lastUpdated: Date.now()
      });
    });
  }

  /**
   * Deletes an event fragment from state
   *
   * @param id - The fragment id to delete
   */
  deleteEventFragment(id) {
    if (this.state.fragments[id]) {
      this.update(state => {
        delete state.fragments[id];
      });
    }
  }

  /**
   * Finalizes a fragment, tracking either a success event or failure Event
   * and then removes the fragment from state.
   *
   * @param id - UUID of the event fragment to be closed
   * @param options
   * @param options.abandoned - if true track the failure event instead of the success event
   * @param options.page - page the final event occurred on. This will override whatever is set on the fragment
   * @param options.referrer - Dapp that originated the fragment. This is for fallback only, the fragment referrer
   * property will take precedence.
   */
  finalizeEventFragment(id, {
    abandoned = false,
    page,
    referrer
  } = {}) {
    const fragment = this.state.fragments[id];
    if (!fragment) {
      throw new Error(`Funnel with id ${id} does not exist.`);
    }
    const eventName = abandoned ? fragment.failureEvent : fragment.successEvent;
    this.trackEvent({
      event: eventName ?? '',
      category: fragment.category,
      properties: fragment.properties,
      sensitiveProperties: fragment.sensitiveProperties,
      page: page ?? fragment.page,
      referrer: fragment.referrer ?? referrer,
      revenue: fragment.revenue,
      value: fragment.value,
      currency: fragment.currency,
      environmentType: fragment.environmentType,
      actionId: fragment.actionId,
      // We append success or failure to the unique-identifier so that the
      // messageId can still be idempotent, but so that it differs from the
      // initial event fired. The initial event was preventing new events from
      // making it to mixpanel because they were using the same unique ID as
      // the events processed in other parts of the fragment lifecycle.
      uniqueIdentifier: fragment.uniqueIdentifier ? `${fragment.uniqueIdentifier}-${abandoned ? 'failure' : 'success'}` : undefined
    });
    this.update(state => {
      delete state.fragments[id];
    });
  }

  /**
   * Calls this._identify with validated metaMetricsId and user traits if user is participating
   * in the MetaMetrics analytics program
   *
   * @param userTraits
   */
  identify(userTraits) {
    const {
      metaMetricsId,
      participateInMetaMetrics
    } = this.state;
    if (!participateInMetaMetrics || !metaMetricsId || !userTraits) {
      return;
    }
    if (typeof userTraits !== 'object') {
      console.warn(`MetaMetricsController#identify: userTraits parameter must be an object. Received type: ${typeof userTraits}`);
      return;
    }
    const allValidTraits = _assertClassBrand(_MetaMetricsController_brand, this, _buildValidTraits).call(this, userTraits);
    _assertClassBrand(_MetaMetricsController_brand, this, _identify).call(this, allValidTraits);
  }

  // It sets an uninstall URL ("Sorry to see you go!" page),
  // which is opened if a user uninstalls the extension.
  updateExtensionUninstallUrl(participateInMetaMetrics, metaMetricsId) {
    const query = {
      av: this.version
    };
    if (participateInMetaMetrics) {
      // We only want to track these things if a user opted into metrics.
      query.mmi = Buffer.from(metaMetricsId).toString('base64');
      query.env = _classPrivateFieldGet(_environment, this);
    }
    const queryString = new URLSearchParams(query);

    // this.extension not currently defined in tests
    if (_classPrivateFieldGet(_extension, this) && _classPrivateFieldGet(_extension, this).runtime) {
      _classPrivateFieldGet(_extension, this).runtime.setUninstallURL(
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
      // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
      `${EXTENSION_UNINSTALL_URL}?${queryString}`);
    }
  }

  /**
   * Setter for the `participateInMetaMetrics` property
   *
   * @param participateInMetaMetrics - Whether or not the user wants to participate in MetaMetrics if not set
   * @returns The string of the new metametrics id, or null
   */
  async setParticipateInMetaMetrics(participateInMetaMetrics) {
    const {
      metaMetricsId: existingMetaMetricsId
    } = this.state;
    const metaMetricsId = participateInMetaMetrics && !existingMetaMetricsId ? this.generateMetaMetricsId() : existingMetaMetricsId;
    this.update(state => {
      state.participateInMetaMetrics = participateInMetaMetrics;
      state.metaMetricsId = metaMetricsId;
    });
    if (participateInMetaMetrics) {
      this.trackEventsAfterMetricsOptIn();
      this.clearEventsAfterMetricsOptIn();
      this.trackTracesAfterMetricsOptIn();
      this.clearTracesAfterMetricsOptIn();
    } else if (this.state.marketingCampaignCookieId) {
      this.setMarketingCampaignCookieId(null);
    }

    ///: BEGIN:ONLY_INCLUDE_IF(build-main)
    if (_classPrivateFieldGet(_environment, this) !== _constants.ENVIRONMENT.DEVELOPMENT && metaMetricsId !== null) {
      this.updateExtensionUninstallUrl(participateInMetaMetrics, metaMetricsId);
    }
    ///: END:ONLY_INCLUDE_IF

    return metaMetricsId;
  }
  setDataCollectionForMarketing(dataCollectionForMarketing) {
    const {
      metaMetricsId
    } = this.state;
    this.update(state => {
      state.dataCollectionForMarketing = dataCollectionForMarketing;
    });
    if (!dataCollectionForMarketing && this.state.marketingCampaignCookieId) {
      this.setMarketingCampaignCookieId(null);
    }
    return metaMetricsId;
  }
  setMarketingCampaignCookieId(marketingCampaignCookieId) {
    this.update(state => {
      state.marketingCampaignCookieId = marketingCampaignCookieId;
    });
  }

  /**
   * track a page view with Segment
   *
   * @param payload - details of the page viewed.
   * @param options - options for handling the page view.
   */
  trackPage(payload, options) {
    try {
      if (this.state.participateInMetaMetrics === false) {
        return;
      }
      if (this.state.participateInMetaMetrics === null && !(options !== null && options !== void 0 && options.isOptInPath)) {
        return;
      }
      const {
        name,
        params,
        environmentType,
        page,
        referrer,
        actionId
      } = payload;
      const {
        metaMetricsId
      } = this.state;
      const idTrait = metaMetricsId ? 'userId' : 'anonymousId';
      const idValue = metaMetricsId ?? _metametrics.METAMETRICS_ANONYMOUS_ID;
      _assertClassBrand(_MetaMetricsController_brand, this, _submitSegmentAPICall).call(this, 'page', {
        messageId: buildUniqueMessageId({
          actionId
        }),
        [idTrait]: idValue,
        name,
        properties: {
          params,
          locale: this.locale,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          chain_id: this.chainId,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          environment_type: environmentType
        },
        context: _assertClassBrand(_MetaMetricsController_brand, this, _buildContext).call(this, referrer, page)
      });
    } catch (err) {
      _classPrivateFieldGet(_captureException, this).call(this, err);
    }
  }

  /**
   * submits a metametrics event, not waiting for it to complete or allowing its error to bubble up
   *
   * @param payload - details of the event
   * @param options - options for handling/routing the event
   */
  trackEvent(payload, options) {
    // validation is not caught and handled
    _assertClassBrand(_MetaMetricsController_brand, this, _validatePayload).call(this, payload);
    _assertClassBrand(_MetaMetricsController_brand, this, _submitEvent).call(this, payload, options).catch(err => {
      _classPrivateFieldGet(_captureException, this).call(this, err);
    });
  }

  /**
   * submits (or queues for submission) a metametrics event, performing necessary payload manipulation and
   * routing the event to the appropriate segment source. Will split events
   * with sensitiveProperties into two events, tracking the sensitiveProperties
   * with the anonymousId only.
   *
   * @param payload - details of the event
   * @param options - options for handling/routing the event
   */

  handleMetaMaskStateUpdate(newState) {
    const userTraits = this._buildUserTraitsObject(newState);
    if (userTraits) {
      this.identify(userTraits);
    }
  }

  // Track all queued events after a user opted into metrics.
  trackEventsAfterMetricsOptIn() {
    const {
      eventsBeforeMetricsOptIn
    } = this.state;
    eventsBeforeMetricsOptIn.forEach(eventBeforeMetricsOptIn => {
      this.trackEvent(eventBeforeMetricsOptIn);
    });
  }

  // Once we track queued events after a user opts into metrics, we want to clear the event queue.
  clearEventsAfterMetricsOptIn() {
    this.update(state => {
      state.eventsBeforeMetricsOptIn = [];
    });
  }

  // It adds an event into a queue, which is only tracked if a user opts into metrics.
  addEventBeforeMetricsOptIn(event) {
    this.update(state => {
      state.eventsBeforeMetricsOptIn.push(event);
    });
  }

  // Track all queued traces after a user opted into metrics.
  trackTracesAfterMetricsOptIn() {
    const {
      tracesBeforeMetricsOptIn
    } = this.state;
    tracesBeforeMetricsOptIn.forEach(bufferedTrace => {
      if (bufferedTrace.type === 'start') {
        (0, _trace.trace)(bufferedTrace.request);
      } else if (bufferedTrace.type === 'end') {
        (0, _trace.endTrace)(bufferedTrace.request);
      }
    });
  }

  // Once we track queued traces after a user opts into metrics, we want to clear the trace queue.
  clearTracesAfterMetricsOptIn() {
    this.update(state => {
      state.tracesBeforeMetricsOptIn = [];
    });
  }

  // It adds a trace into a queue, which is only tracked if a user opts into metrics.
  addTraceBeforeMetricsOptIn(traceData) {
    this.update(state => {
      state.tracesBeforeMetricsOptIn.push(traceData);
    });
  }

  /**
   * Buffered trace method that checks consent and either buffers or executes immediately
   *
   * @param request - The trace request
   * @param fn - Optional callback function to trace
   * @returns The result of the trace callback or undefined if buffered
   */
  bufferedTrace(request, fn) {
    if (this.state.participateInMetaMetrics) {
      return fn ? (0, _trace.trace)(request, fn) : (0, _trace.trace)(request);
    }

    // Extract parent trace name if parentContext exists
    let parentTraceName;
    if (request.parentContext && typeof request.parentContext === 'object') {
      const parentSpan = request.parentContext;
      parentTraceName = parentSpan === null || parentSpan === void 0 ? void 0 : parentSpan._name;
    }
    this.addTraceBeforeMetricsOptIn({
      type: 'start',
      request: {
        ...request,
        parentContext: undefined,
        // Remove original parentContext to avoid invalid references
        // Use Date.now() as performance.timeOrigin is only valid for measuring durations within
        // the same session; it won't produce valid event times for Sentry if buffered and flushed later
        startTime: request.startTime ?? Date.now()
      },
      parentTraceName // Store the parent trace name for later reconnection
    });
    return undefined;
  }

  /**
   * Buffered end trace method that checks consent and either buffers or executes immediately
   *
   * @param request - The end trace request
   */
  bufferedEndTrace(request) {
    if (this.state.participateInMetaMetrics) {
      (0, _trace.endTrace)(request);
    } else {
      this.addTraceBeforeMetricsOptIn({
        type: 'end',
        request: {
          ...request,
          // Use Date.now() as performance.timeOrigin is only valid for measuring durations within
          // the same session; it won't produce valid event times for Sentry if buffered and flushed later
          timestamp: request.timestamp ?? Date.now()
        }
      });
    }
  }

  // Add or update traits for tracking.
  updateTraits(newTraits) {
    this.update(state => {
      state.traits = {
        ...state.traits,
        ...newTraits
      };
    });
  }

  // Retrieve (or generate if doesn't exist) the client metametrics id
  getMetaMetricsId() {
    let {
      metaMetricsId
    } = this.state;
    if (!metaMetricsId) {
      metaMetricsId = this.generateMetaMetricsId();
      this.update(state => {
        state.metaMetricsId = metaMetricsId;
      });
    }
    return metaMetricsId;
  }

  /** PRIVATE METHODS */

  /**
   * Build the context object to attach to page and track events.
   *
   * @private
   * @param referrer - dapp origin that initialized
   * the notification window.
   * @param page - page object describing the current
   * view of the extension. Defaults to the background-process object.
   */

  /**
   * This method generates the MetaMetrics user traits object, omitting any
   * traits that have not changed since the last invocation of this method.
   *
   * @param metamaskState - Full metamask state object.
   * @returns traits that have changed since last update
   */
  _buildUserTraitsObject(metamaskState) {
    var _this$previousUserTra, _metamaskState$tokenS, _Object$entries;
    const {
      traits
    } = this.state;
    const currentTraits = {
      [_metametrics.MetaMetricsUserTrait.AddressBookEntries]: (0, _lodash.sum)(Object.values(metamaskState.addressBook).map(_lodash.size)),
      [_metametrics.MetaMetricsUserTrait.InstallDateExt]:
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      traits[_metametrics.MetaMetricsUserTrait.InstallDateExt] || '',
      [_metametrics.MetaMetricsUserTrait.LedgerConnectionType]: metamaskState.ledgerTransportType,
      [_metametrics.MetaMetricsUserTrait.NetworksAdded]: Object.values(metamaskState.networkConfigurationsByChainId).map(networkConfiguration => networkConfiguration.chainId),
      [_metametrics.MetaMetricsUserTrait.NetworksWithoutTicker]: Object.values(metamaskState.networkConfigurationsByChainId).filter(({
        nativeCurrency
      }) => !nativeCurrency).map(({
        chainId
      }) => chainId),
      // caip-2 formatted
      [_metametrics.MetaMetricsUserTrait.ChainIdList]: [...Object.keys(metamaskState.networkConfigurationsByChainId).map(hexChainId => `eip155:${parseInt(hexChainId, 16)}`), ...Object.keys(metamaskState.multichainNetworkConfigurationsByChainId) // the state here is already caip-2 formatted
      ],
      [_metametrics.MetaMetricsUserTrait.NftAutodetectionEnabled]: metamaskState.useNftDetection,
      [_metametrics.MetaMetricsUserTrait.NumberOfAccounts]: Object.values(metamaskState.internalAccounts.accounts).length,
      [_metametrics.MetaMetricsUserTrait.NumberOfNftCollections]: _assertClassBrand(_MetaMetricsController_brand, this, _getAllUniqueNFTAddressesLength).call(this, metamaskState.allNfts),
      [_metametrics.MetaMetricsUserTrait.NumberOfNfts]: _classPrivateFieldGet(_getAllNFTsFlattened, this).call(this, metamaskState.allNfts).length,
      [_metametrics.MetaMetricsUserTrait.NumberOfTokens]: _assertClassBrand(_MetaMetricsController_brand, this, _getNumberOfTokens).call(this, metamaskState.allTokens),
      [_metametrics.MetaMetricsUserTrait.NumberOfHDEntropies]: _assertClassBrand(_MetaMetricsController_brand, this, _getNumberOfHDEntropies).call(this, metamaskState) ?? ((_this$previousUserTra = this.previousUserTraits) === null || _this$previousUserTra === void 0 ? void 0 : _this$previousUserTra.number_of_hd_entropies),
      [_metametrics.MetaMetricsUserTrait.OpenSeaApiEnabled]: metamaskState.openSeaEnabled,
      [_metametrics.MetaMetricsUserTrait.ThreeBoxEnabled]: false,
      // deprecated, hard-coded as false
      [_metametrics.MetaMetricsUserTrait.Theme]: metamaskState.theme || 'default',
      [_metametrics.MetaMetricsUserTrait.TokenDetectionEnabled]: metamaskState.useTokenDetection,
      [_metametrics.MetaMetricsUserTrait.ShowNativeTokenAsMainBalance]: metamaskState.ShowNativeTokenAsMainBalance,
      [_metametrics.MetaMetricsUserTrait.CurrentCurrency]: metamaskState.currentCurrency,
      [_metametrics.MetaMetricsUserTrait.SecurityProviders]: metamaskState.securityAlertsEnabled ? ['blockaid'] : [],
      [_metametrics.MetaMetricsUserTrait.PetnameAddressCount]: _assertClassBrand(_MetaMetricsController_brand, this, _getPetnameAddressCount).call(this, metamaskState),
      [_metametrics.MetaMetricsUserTrait.IsMetricsOptedIn]: metamaskState.participateInMetaMetrics,
      [_metametrics.MetaMetricsUserTrait.HasMarketingConsent]: metamaskState.dataCollectionForMarketing,
      [_metametrics.MetaMetricsUserTrait.TokenSortPreference]: ((_metamaskState$tokenS = metamaskState.tokenSortConfig) === null || _metamaskState$tokenS === void 0 ? void 0 : _metamaskState$tokenS.key) || '',
      [_metametrics.MetaMetricsUserTrait.PrivacyModeEnabled]: metamaskState.preferences.privacyMode,
      [_metametrics.MetaMetricsUserTrait.NetworkFilterPreference]: Object.keys(metamaskState.preferences.tokenNetworkFilter || {}),
      [_metametrics.MetaMetricsUserTrait.ProfileId]: (_Object$entries = Object.entries(metamaskState.srpSessionData || {})) === null || _Object$entries === void 0 || (_Object$entries = _Object$entries[0]) === null || _Object$entries === void 0 || (_Object$entries = _Object$entries[1]) === null || _Object$entries === void 0 || (_Object$entries = _Object$entries.profile) === null || _Object$entries === void 0 ? void 0 : _Object$entries.profileId
    };
    if (!this.previousUserTraits && metamaskState.participateInMetaMetrics) {
      this.previousUserTraits = currentTraits;
      return currentTraits;
    }
    if (this.previousUserTraits && !(0, _lodash.isEqual)(this.previousUserTraits, currentTraits)) {
      const updates = (0, _lodash.pickBy)(currentTraits, (v, k) => {
        // @ts-expect-error It's okay that `k` may not be a key of `this.previousUserTraits`, because we assume `isEqual` can handle it
        const previous = this.previousUserTraits[k];
        return !(0, _lodash.isEqual)(previous, v);
      });
      if (metamaskState.participateInMetaMetrics) {
        this.previousUserTraits = currentTraits;
      }
      return updates;
    }
    return null;
  }

  /**
   * Returns a new object of all valid user traits. For dates, we transform them into ISO-8601 timestamp strings.
   *
   * @see {@link https://segment.com/docs/connections/spec/common/#timestamps}
   * @param userTraits
   */
}
exports.default = MetaMetricsController;
function _getCurrentChainId(networkClientId) {
  const selectedNetworkClientId =
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  networkClientId || this.messagingSystem.call('NetworkController:getState').selectedNetworkClientId;
  const {
    configuration: {
      chainId
    }
  } = this.messagingSystem.call('NetworkController:getNetworkClientById', selectedNetworkClientId);
  return chainId;
}
async function _submitEvent(payload, options) {
  if (!this.state.participateInMetaMetrics && !(options !== null && options !== void 0 && options.isOptIn)) {
    return;
  }

  // We might track multiple events if sensitiveProperties is included, this array will hold
  // the promises returned from this._track.
  const events = [];
  if (payload.sensitiveProperties) {
    // sensitiveProperties will only be tracked using the anonymousId property and generic id
    // If the event options already specify to exclude the metaMetricsId we throw an error as
    // a signal to the developer that the event was implemented incorrectly
    if ((options === null || options === void 0 ? void 0 : options.excludeMetaMetricsId) === true) {
      throw new Error('sensitiveProperties was specified in an event payload that also set the excludeMetaMetricsId flag');
    }

    // change anonymous event names
    const anonymousEventName =
    // @ts-expect-error This property may not exist. We check for it below.
    overrideAnonymousEventNames[`${payload.event}`];
    const anonymousPayload = {
      ...payload,
      event: anonymousEventName ?? payload.event
    };
    const combinedProperties = (0, _lodash.merge)({
      ...anonymousPayload.sensitiveProperties
    }, {
      ...anonymousPayload.properties
    });
    events.push(_assertClassBrand(_MetaMetricsController_brand, this, _track).call(this, _assertClassBrand(_MetaMetricsController_brand, this, _buildEventPayload).call(this, {
      ...anonymousPayload,
      properties: combinedProperties,
      isDuplicateAnonymizedEvent: true
    }), {
      ...options,
      excludeMetaMetricsId: true
    }));
  }
  events.push(_assertClassBrand(_MetaMetricsController_brand, this, _track).call(this, _assertClassBrand(_MetaMetricsController_brand, this, _buildEventPayload).call(this, payload), options));
  await Promise.all(events);
}
/**
 * validates a metametrics event
 *
 * @param payload - details of the event
 */
function _validatePayload(payload) {
  // event and category are required fields for all payloads
  if (!payload.event) {
    throw new Error(`Must specify event. Event was: ${payload.event
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    }. Payload keys were: ${Object.keys(payload)}. ${typeof payload.properties === 'object' ?
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    `Payload property keys were: ${Object.keys(payload.properties)}` : ''}`);
  }
}
function _buildContext(referrer, page = _metametrics.METAMETRICS_BACKGROUND_PAGE_OBJECT) {
  return {
    app: {
      name: 'MetaMask Extension',
      version: this.version
    },
    userAgent: window.navigator.userAgent,
    page,
    referrer,
    marketingCampaignCookieId: this.state.marketingCampaignCookieId
  };
}
/**
 * Build's the event payload, processing all fields into a format that can be
 * fed to Segment's track method
 *
 * @private
 * @param rawPayload - raw payload provided to trackEvent
 * @returns formatted event payload for segment
 */
function _buildEventPayload(rawPayload) {
  const {
    event,
    properties,
    revenue,
    value,
    currency,
    category,
    page,
    referrer,
    environmentType = _app.ENVIRONMENT_TYPE_BACKGROUND
  } = rawPayload;
  let chainId;
  if (properties && 'chain_id_caip' in properties && typeof properties.chain_id_caip === 'string') {
    chainId = null;
  } else if (properties && 'chain_id' in properties && typeof properties.chain_id === 'string') {
    chainId = properties.chain_id;
  } else {
    chainId = this.chainId;
  }
  return {
    event,
    messageId: buildUniqueMessageId(rawPayload),
    properties: {
      // These values are omitted from properties because they have special meaning
      // in segment. https://segment.com/docs/connections/spec/track/#properties.
      // to avoid accidentally using these inappropriately, you must add them as top
      // level properties on the event payload. We also exclude locale to prevent consumers
      // from overwriting this context level property. We track it as a property
      // because not all destinations map locale from context.
      ...(0, _lodash.omit)(properties, ['revenue', 'locale', 'currency', 'value']),
      revenue,
      value,
      currency,
      category,
      locale: this.locale,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      chain_id: chainId,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      environment_type: environmentType
    },
    context: _assertClassBrand(_MetaMetricsController_brand, this, _buildContext).call(this, referrer, page)
  };
}
function _buildValidTraits(userTraits) {
  return Object.entries(userTraits).reduce((validTraits, [key, value]) => {
    if (_assertClassBrand(_MetaMetricsController_brand, this, _isValidTraitDate).call(this, value)) {
      return {
        ...validTraits,
        [key]: value.toISOString()
      };
    } else if (_assertClassBrand(_MetaMetricsController_brand, this, _isValidTrait).call(this, value)) {
      return {
        ...validTraits,
        [key]: value
      };
    }
    console.warn(`MetaMetricsController: "${key}" value is not a valid trait type`);
    return validTraits;
  }, {});
}
/**
 * Returns the number of unique NFT addresses the user
 * possesses across all networks and accounts.
 *
 * @param allNfts
 */
function _getAllUniqueNFTAddressesLength(allNfts = {}) {
  const allNFTAddresses = _classPrivateFieldGet(_getAllNFTsFlattened, this).call(this, allNfts).map(nft => nft.address);
  const uniqueAddresses = new Set(allNFTAddresses);
  return uniqueAddresses.size;
}
/**
 * @param allTokens
 * @returns number of unique token addresses
 */
function _getNumberOfTokens(allTokens) {
  return Object.values(allTokens).reduce((result, accountsByChain) => {
    return result + (0, _lodash.sum)(Object.values(accountsByChain).map(_lodash.size));
  }, 0);
}
/**
 * Returns the number of HD Entropies the user has.
 *
 * @param metamaskState
 */
function _getNumberOfHDEntropies(metamaskState) {
  var _metamaskState$keyrin;
  return ((_metamaskState$keyrin = metamaskState.keyrings) === null || _metamaskState$keyrin === void 0 ? void 0 : _metamaskState$keyrin.filter(keyring => keyring.type === _keyring.KeyringType.hdKeyTree).length) ?? 0;
}
/**
 * Calls segment.identify with given user traits
 *
 * @see {@link https://segment.com/docs/connections/sources/catalog/libraries/server/node/#identify}
 * @param userTraits
 */
function _identify(userTraits) {
  const {
    metaMetricsId
  } = this.state;
  if (!userTraits || Object.keys(userTraits).length === 0) {
    console.warn('MetaMetricsController#_identify: No userTraits found');
    return;
  }
  try {
    _assertClassBrand(_MetaMetricsController_brand, this, _submitSegmentAPICall).call(this, 'identify', {
      userId: metaMetricsId ?? undefined,
      traits: userTraits
    });
  } catch (err) {
    _classPrivateFieldGet(_captureException, this).call(this, err);
  }
}
/**
 * Validates the trait value. Segment accepts any data type. We are adding validation here to
 * support data types for our Segment destination(s) e.g. MixPanel
 *
 * @param value
 */
function _isValidTrait(value) {
  const type = typeof value;
  return type === 'string' || type === 'boolean' || type === 'number' || _assertClassBrand(_MetaMetricsController_brand, this, _isValidTraitArray).call(this, value) || _assertClassBrand(_MetaMetricsController_brand, this, _isValidTraitDate).call(this, value);
}
/**
 * Segment accepts any data type value. We have special logic to validate arrays.
 *
 * @param value
 */
function _isValidTraitArray(value) {
  return Array.isArray(value) && (value.every(element => {
    return typeof element === 'string';
  }) || value.every(element => {
    return typeof element === 'boolean';
  }) || value.every(element => {
    return typeof element === 'number';
  }));
}
/**
 * Returns true if the value is an accepted date type
 *
 * @param value
 */
function _isValidTraitDate(value) {
  return Object.prototype.toString.call(value) === '[object Date]';
}
/**
 * Perform validation on the payload and update the id type to use before
 * sending to Segment. Also examines the options to route and handle the
 * event appropriately.
 *
 * @private
 * @param payload - properties to attach to event
 * @param options - options for routing and handling the event
 */
function _track(payload, options) {
  const {
    isOptIn,
    metaMetricsId: metaMetricsIdOverride,
    matomoEvent,
    flushImmediately
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  } = options || {};
  let idType = 'userId';
  let idValue = this.state.metaMetricsId;
  let excludeMetaMetricsId = (options === null || options === void 0 ? void 0 : options.excludeMetaMetricsId) ?? false;
  // This is carried over from the old implementation, and will likely need
  // to be updated to work with the new tracking plan. I think we should use
  // a config setting for this instead of trying to match the event name
  const isSendFlow = Boolean(payload.event.match(/^send|^confirm/iu));
  // do not filter if excludeMetaMetricsId is explicitly set to false
  if ((options === null || options === void 0 ? void 0 : options.excludeMetaMetricsId) !== false && isSendFlow) {
    excludeMetaMetricsId = true;
  }
  // If we are tracking sensitive data we will always use the anonymousId
  // property as well as our METAMETRICS_ANONYMOUS_ID. This prevents us from
  // associating potentially identifiable information with a specific id.
  // During the opt in flow we will track all events, but do so with the
  // anonymous id. The one exception to that rule is after the user opts in
  // to MetaMetrics. When that happens we receive back the user's new
  // MetaMetrics id before it is fully persisted to state. To avoid a race
  // condition we explicitly pass the new id to the track method. In that
  // case we will track the opt in event to the user's id. In all other cases
  // we use the metaMetricsId from state.
  if (excludeMetaMetricsId || isOptIn && !metaMetricsIdOverride) {
    idType = 'anonymousId';
    idValue = _metametrics.METAMETRICS_ANONYMOUS_ID;
  } else if (isOptIn && metaMetricsIdOverride) {
    idValue = metaMetricsIdOverride;
  }
  payload[idType] = idValue ?? undefined;

  // If this is an event on the old matomo schema, add a key to the payload
  // to designate it as such
  if (matomoEvent === true) {
    payload.properties.legacy_event = true;
  }

  // Promises will only resolve when the event is sent to segment. For any
  // event that relies on this promise being fulfilled before performing UI
  // updates, or otherwise delaying user interaction, supply the
  // 'flushImmediately' flag to the trackEvent method.
  return new Promise((resolve, reject) => {
    const callback = err => {
      if (err) {
        const message = (0, _utils.isErrorWithMessage)(err) ? err.message : '';
        const stack = (0, _utils.isErrorWithStack)(err) ? err.stack : undefined;
        // The error that segment gives us has some manipulation done to it
        // that seemingly breaks with lockdown enabled. Creating a new error
        // here prevents the system from freezing when the network request to
        // segment fails for any reason.
        const safeError = new Error(message);
        if (stack) {
          safeError.stack = stack;
        }
        return reject(safeError);
      }
      return resolve();
    };
    _assertClassBrand(_MetaMetricsController_brand, this, _submitSegmentAPICall).call(this, 'track', payload, callback);
    if (flushImmediately) {
      _classPrivateFieldGet(_segment, this).flush();
    }
  });
}
/*
 * Method below submits the request to analytics SDK.
 * It will also add event to controller store
 * and pass a callback to remove it from store once request is submitted to segment
 * Saving segmentApiCalls in controller store in MV3 ensures that events are tracked
 * even if service worker terminates before events are submitted to segment.
 */
function _submitSegmentAPICall(eventType, payload, callback) {
  const {
    metaMetricsId,
    latestNonAnonymousEventTimestamp,
    participateInMetaMetrics
  } = this.state;
  if (!participateInMetaMetrics || !metaMetricsId) {
    return;
  }

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  const messageId = payload.messageId || (0, _util.generateRandomId)();
  let timestamp = new Date();
  if (payload.timestamp) {
    const payloadDate = new Date(payload.timestamp);
    if ((0, _util.isValidDate)(payloadDate)) {
      timestamp = payloadDate;
    }
  }
  const modifiedPayload = {
    ...payload,
    messageId,
    timestamp
  };
  this.update(state => {
    state.latestNonAnonymousEventTimestamp = modifiedPayload.anonymousId === _metametrics.METAMETRICS_ANONYMOUS_ID ? latestNonAnonymousEventTimestamp : timestamp.valueOf();
    state.segmentApiCalls[messageId] = {
      eventType,
      // @ts-expect-error The reason this is needed is that the event property in the payload can be missing,
      // whereas the state expects it to be present. It's unclear how best to handle this discrepancy.
      payload: {
        ...modifiedPayload,
        timestamp: modifiedPayload.timestamp.toString()
      }
    };
  });
  const modifiedCallback = result => {
    this.update(state => {
      delete state.segmentApiCalls[messageId];
    });
    return callback === null || callback === void 0 ? void 0 : callback(result);
  };
  _classPrivateFieldGet(_segment, this)[eventType](modifiedPayload, modifiedCallback);
}
/**
 * Returns the total number of Ethereum addresses with saved petnames,
 * including all chain ID variations.
 *
 * @param metamaskState
 */
function _getPetnameAddressCount(metamaskState) {
  var _metamaskState$names;
  const addressNames = ((_metamaskState$names = metamaskState.names) === null || _metamaskState$names === void 0 ? void 0 : _metamaskState$names[_nameController.NameType.ETHEREUM_ADDRESS]) ?? {};
  return Object.keys(addressNames).reduce((totalCount, address) => {
    const addressEntry = addressNames[address];
    const addressNameCount = Object.keys(addressEntry).reduce((count, chainId) => {
      var _addressEntry$chainId;
      const hasName = Boolean((_addressEntry$chainId = addressEntry[chainId].name) === null || _addressEntry$chainId === void 0 ? void 0 : _addressEntry$chainId.length);
      return count + (hasName ? 1 : 0);
    }, 0);
    return totalCount + addressNameCount;
  }, 0);
}

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controllers\\metametrics-controller.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\metametrics-data-deletion\\metametrics-data-deletion.ts", {"@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontrollers%5Cmetametrics-data-deletion%5Cmetametrics-data-deletion.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetaMetricsDataDeletionController = void 0;
var _baseController = require("@metamask/base-controller");
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
// Unique name for the controller
const controllerName = 'MetaMetricsDataDeletionController';

/**
 * Timestamp at which regulation response is returned.
 */

/**
 * Regulation Id retuned while creating a delete regulation.
 */

/**
 * MetaMetricsDataDeletionController controller state
 * metaMetricsDataDeletionId - Regulation Id retuned while creating a delete regulation.
 * metaMetricsDataDeletionTimestamp - Timestamp at which the most recent regulation is created/requested for.
 * metaMetricsDataDeletionStatus - Status of the current delete regulation.
 */

const getDefaultState = () => {
  return {
    metaMetricsDataDeletionId: null,
    metaMetricsDataDeletionTimestamp: 0
  };
};

// Metadata for the controller state
const metadata = {
  metaMetricsDataDeletionId: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  metaMetricsDataDeletionTimestamp: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  metaMetricsDataDeletionStatus: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  }
};

// Describes the action creating the delete regulation task

// Describes the action to check the existing regulation status

// Union of all possible actions for the messenger

/**
 * Actions that this controller is allowed to call.
 */

/**
 * Events that this controller is allowed to subscribe.
 */

// Type for the messenger of MetaMetricsDataDeletionController
var _dataDeletionService = /*#__PURE__*/new WeakMap();
var _MetaMetricsDataDeletionController_brand = /*#__PURE__*/new WeakSet();
/**
 * Controller responsible for maintaining
 * state related to Metametrics data deletion
 */
class MetaMetricsDataDeletionController extends _baseController.BaseController {
  /**
   * Creates a MetaMetricsDataDeletionController instance.
   *
   * @param args - The arguments to this function.
   * @param args.dataDeletionService - The service used for deleting data.
   * @param args.messenger - Messenger used to communicate with BaseV2 controller.
   * @param args.state - Initial state to set on this controller.
   */
  constructor({
    dataDeletionService,
    messenger,
    state
  }) {
    // Call the constructor of BaseControllerV2
    super({
      messenger,
      metadata,
      name: controllerName,
      state: {
        ...getDefaultState(),
        ...state
      }
    });
    /**
     * Constructor helper for registering this controller's messaging system
     * actions.
     */
    _classPrivateMethodInitSpec(this, _MetaMetricsDataDeletionController_brand);
    _classPrivateFieldInitSpec(this, _dataDeletionService, void 0);
    _classPrivateFieldSet(_dataDeletionService, this, dataDeletionService);
    _assertClassBrand(_MetaMetricsDataDeletionController_brand, this, _registerMessageHandlers).call(this);
  }
  /**
   * Creating the delete regulation using source regulation
   *
   */
  async createMetaMetricsDataDeletionTask() {
    const {
      metaMetricsId
    } = this.messagingSystem.call('MetaMetricsController:getState');
    if (!metaMetricsId) {
      throw new Error('MetaMetrics ID not found');
    }
    const deleteRegulateId = await _classPrivateFieldGet(_dataDeletionService, this).createDataDeletionRegulationTask(metaMetricsId);
    this.update(state => {
      state.metaMetricsDataDeletionId = deleteRegulateId ?? null;
      state.metaMetricsDataDeletionTimestamp = Date.now();
    });
    await this.updateDataDeletionTaskStatus();
  }

  /**
   * To check the status of the current delete regulation.
   */
  async updateDataDeletionTaskStatus() {
    const deleteRegulationId = this.state.metaMetricsDataDeletionId;
    if (!deleteRegulationId) {
      throw new Error('Delete Regulation id not found');
    }
    const deletionStatus = await _classPrivateFieldGet(_dataDeletionService, this).fetchDeletionRegulationStatus(deleteRegulationId);
    this.update(state => {
      state.metaMetricsDataDeletionStatus = deletionStatus ?? undefined;
    });
  }
}
exports.MetaMetricsDataDeletionController = MetaMetricsDataDeletionController;
function _registerMessageHandlers() {
  this.messagingSystem.registerActionHandler(`${controllerName}:createMetaMetricsDataDeletionTask`, this.createMetaMetricsDataDeletionTask.bind(this));
  this.messagingSystem.registerActionHandler(`${controllerName}:updateDataDeletionTaskStatus`, this.updateDataDeletionTaskStatus.bind(this));
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controllers\\metametrics-data-deletion\\metametrics-data-deletion.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\network-order.ts", {"../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/multichain-network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontrollers%5Cnetwork-order.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkOrderController = void 0;
var _keyringApi = require("@metamask/keyring-api");
var _baseController = require("@metamask/base-controller");
var _multichainNetworkController = require("@metamask/multichain-network-controller");
var _network = require("../../../shared/constants/network");
// Unique name for the controller
const controllerName = 'NetworkOrderController';

/**
 * Information about an ordered network.
 */

// State shape for NetworkOrderController

// Describes the structure of a state change event

// Describes the action for updating the networks list

// Union of all possible actions for the messenger

// Type for the messenger of NetworkOrderController

// Default state for the controller
const defaultState = {
  orderedNetworkList: []
};

// Metadata for the controller state
const metadata = {
  orderedNetworkList: {
    includeInStateLogs: false,
    persist: true,
    anonymous: true,
    usedInUi: true
  }
};

/**
 * Controller that updates the order of the network list.
 * This controller subscribes to network state changes and ensures
 * that the network list is updated based on the latest network configurations.
 */
class NetworkOrderController extends _baseController.BaseController {
  /**
   * Creates a NetworkOrderController instance.
   *
   * @param args - The arguments to this function.
   * @param args.messenger - Messenger used to communicate with BaseV2 controller.
   * @param args.state - Initial state to set on this controller.
   */
  constructor({
    messenger,
    state
  }) {
    // Call the constructor of BaseControllerV2
    super({
      messenger,
      metadata,
      name: controllerName,
      state: {
        ...defaultState,
        ...state
      }
    });

    // Subscribe to network state changes
    this.messagingSystem.subscribe('NetworkController:stateChange', networkControllerState => {
      this.onNetworkControllerStateChange(networkControllerState);
    });
  }

  /**
   * Handles the state change of the network controller and updates the networks list.
   *
   * @param networkControllerState - The state of the network controller.
   * @param networkControllerState.networkConfigurationsByChainId
   */
  onNetworkControllerStateChange({
    networkConfigurationsByChainId
  }) {
    this.update(state => {
      // Filter out testnets, which are in the state but not orderable
      const hexChainIds = Object.keys(networkConfigurationsByChainId).filter(chainId => !_network.TEST_CHAINS.includes(chainId));
      const chainIds = hexChainIds.map(_multichainNetworkController.toEvmCaipChainId);
      const nonEvmChainIds = [_keyringApi.BtcScope.Mainnet, _keyringApi.SolScope.Mainnet];
      const newNetworks = chainIds.filter(chainId => !state.orderedNetworkList.some(({
        networkId
      }) => networkId === chainId)).map(chainId => ({
        networkId: chainId
      }));
      state.orderedNetworkList = state.orderedNetworkList
      // Filter out deleted networks
      .filter(({
        networkId
      }) => chainIds.includes(networkId) ||
      // Since Bitcoin and Solana are not part of the @metamask/network-controller, we have
      // to add a second check to make sure it is not filtered out.
      // TODO: Update this logic to @metamask/multichain-network-controller once all networks are migrated.
      nonEvmChainIds.includes(networkId))
      // Append new networks to the end
      .concat(newNetworks);
    });
  }

  /**
   * Updates the networks list in the state with the provided list of networks.
   *
   * @param networkList - The list of networks to update in the state.
   */

  updateNetworksList(chainIds) {
    this.update(state => {
      state.orderedNetworkList = chainIds.map(chainId => ({
        networkId: chainId
      }));
    });
  }
}
exports.NetworkOrderController = NetworkOrderController;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controllers\\network-order.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\onboarding.ts", {"../../../shared/constants/onboarding":"D:\\code\\v\\metamask-extension\\shared\\constants\\onboarding.ts","../../../shared/modules/environment":"D:\\code\\v\\metamask-extension\\shared\\modules\\environment.ts","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontrollers%5Conboarding.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultOnboardingControllerState = exports.default = void 0;
var _baseController = require("@metamask/base-controller");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _onboarding = require("../../../shared/constants/onboarding");
var _environment = require("../../../shared/modules/environment");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
// Unique name for the controller
const controllerName = 'OnboardingController';

/**
 * The state of the {@link OnboardingController}
 */

/**
 * Function to get default state of the {@link OnboardingController}.
 */
const getDefaultOnboardingControllerState = () => ({
  seedPhraseBackedUp: null,
  firstTimeFlowType: null,
  completedOnboarding: false
});
exports.getDefaultOnboardingControllerState = getDefaultOnboardingControllerState;
const defaultTransientState = {
  onboardingTabs: {}
};

/**
 * {@link OnboardingController}'s metadata.
 *
 * This allows us to choose if fields of the state should be persisted or not
 * using the `persist` flag; and if they can be sent to Sentry or not, using
 * the `anonymous` flag.
 */
const controllerMetadata = {
  seedPhraseBackedUp: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  firstTimeFlowType: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  completedOnboarding: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  onboardingTabs: {
    includeInStateLogs: true,
    persist: false,
    anonymous: false,
    usedInUi: true
  }
};

/**
 * Returns the state of the {@link OnboardingController}.
 */

/**
 * Actions exposed by the {@link OnboardingController}.
 */

/**
 * Event emitted when the state of the {@link OnboardingController} changes.
 */

/**
 * Events emitted by {@link OnboardingController}.
 */

/**
 * Actions that this controller is allowed to call.
 */

/**
 * Events that this controller is allowed to subscribe.
 */

/**
 * Messenger type for the {@link OnboardingController}.
 */

/**
 * Controller responsible for maintaining
 * state related to onboarding
 */
class OnboardingController extends _baseController.BaseController {
  /**
   * Constructs a Onboarding  controller.
   *
   * @param options - the controller options
   * @param options.messenger - Messenger used to communicate with BaseV2 controller.
   * @param options.state - Initial controller state.
   */
  constructor({
    messenger,
    state: _state
  }) {
    super({
      messenger,
      metadata: controllerMetadata,
      name: controllerName,
      state: {
        ...getDefaultOnboardingControllerState(),
        ..._state,
        ...defaultTransientState
      }
    });
    /**
     * Registering a site as having initiated onboarding
     *
     * @param location - The location of the site registering
     * @param tabId - The id of the tab registering
     */
    _defineProperty(this, "registerOnboarding", async (location, tabId) => {
      if (this.state.completedOnboarding) {
        _loglevel.default.debug('Ignoring registerOnboarding; user already onboarded');
        return;
      }
      const {
        onboardingTabs
      } = {
        ...(this.state ?? {})
      };
      if (!onboardingTabs) {
        return;
      }
      if (!onboardingTabs[location] || onboardingTabs[location] !== tabId) {
        _loglevel.default.debug(`Registering onboarding tab at location '${location}' with tabId '${tabId}'`);
        this.update(state => {
          state.onboardingTabs = {
            ...onboardingTabs,
            [location]: tabId
          };
        });
      }
    });
  }

  /**
   * Setter for the `seedPhraseBackedUp` property
   *
   * @param newSeedPhraseBackUpState - Indicates if the seedphrase is backup by the user or not
   */
  setSeedPhraseBackedUp(newSeedPhraseBackUpState) {
    this.update(state => {
      state.seedPhraseBackedUp = newSeedPhraseBackUpState;
    });
  }

  /**
   * Sets the completedOnboarding state to true, indicating that the user has completed the
   * onboarding process.
   */
  completeOnboarding() {
    this.update(state => {
      state.completedOnboarding = true;
    });
    return true;
  }

  /**
   * Setter for the `firstTimeFlowType` property
   *
   * @param type - Indicates the type of first time flow - create or import - the user wishes to follow
   */
  setFirstTimeFlowType(type) {
    this.update(state => {
      state.firstTimeFlowType = type;
    });
  }
  /**
   * Check if the user onboarding flow is Social login flow or not.
   *
   * @returns true if the user onboarding flow is Social loing flow, otherwise false.
   */
  getIsSocialLoginFlow() {
    const isSocialLoginFeatureEnabled = (0, _environment.getIsSeedlessOnboardingFeatureEnabled)();
    if (!isSocialLoginFeatureEnabled) {
      return false;
    }
    const {
      firstTimeFlowType
    } = this.state;
    return firstTimeFlowType === _onboarding.FirstTimeFlowType.socialCreate || firstTimeFlowType === _onboarding.FirstTimeFlowType.socialImport;
  }
}
exports.default = OnboardingController;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controllers\\onboarding.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\permissions\\snaps\\specifications.ts", {"../../../../../shared/constants/keyring":"D:\\code\\v\\metamask-extension\\shared\\constants\\keyring.ts","../../../../../shared/constants/snaps/permissions":"D:\\code\\v\\metamask-extension\\shared\\constants\\snaps\\permissions.ts","@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs","@metamask/snaps-rpc-methods":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontrollers%5Cpermissions%5Csnaps%5Cspecifications.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSnapPermissionSpecifications = getSnapPermissionSpecifications;
var _snapsRpcMethods = require("@metamask/snaps-rpc-methods");
var _keyringController = require("@metamask/keyring-controller");
var _utils = require("@metamask/utils");
var _permissions = require("../../../../../shared/constants/snaps/permissions");
var _keyring = require("../../../../../shared/constants/keyring");
/**
 * Get the permission specifications for Snaps.
 *
 * @param messenger - The messenger to use for communication with other
 * controllers.
 * @param hooks - Hooks for various operations. This is needed since some
 * controllers don't expose the required methods over the messenger yet.
 */
function getSnapPermissionSpecifications(messenger, hooks) {
  return {
    ...(0, _snapsRpcMethods.buildSnapEndowmentSpecifications)(Object.keys(_permissions.ExcludedSnapEndowments)),
    ...(0, _snapsRpcMethods.buildSnapRestrictedMethodSpecifications)(Object.keys(_permissions.ExcludedSnapPermissions), {
      /**
       * Get user preferences.
       *
       * @returns An object containing the preferences relevant to Snaps. This
       * is a subset of the full preferences state.
       */
      getPreferences: () => {
        const currency = messenger.call('CurrencyRateController:getState').currentCurrency;
        const {
          currentLocale: locale,
          openSeaEnabled,
          preferences: {
            privacyMode,
            showTestNetworks
          },
          securityAlertsEnabled,
          useCurrencyRateCheck,
          useTransactionSimulations,
          useTokenDetection,
          useMultiAccountBalanceChecker,
          useNftDetection
        } = messenger.call('PreferencesController:getState');
        return {
          locale,
          currency,
          hideBalances: privacyMode,
          useSecurityAlerts: securityAlertsEnabled,
          useExternalPricingData: useCurrencyRateCheck,
          simulateOnChainActions: useTransactionSimulations,
          useTokenDetection,
          batchCheckBalances: useMultiAccountBalanceChecker,
          displayNftMedia: openSeaEnabled,
          useNftDetection,
          showTestnets: showTestNetworks
        };
      },
      clearSnapState: messenger.call.bind(messenger, 'SnapController:clearSnapState'),
      /**
       * Get the mnemonic for a given entropy source. If no source is
       * provided, the primary HD keyring's mnemonic will be returned.
       *
       * @param source - The ID of the entropy source keyring.
       * @returns The mnemonic.
       */
      getMnemonic: async source => {
        if (!source) {
          const [keyring] = messenger.call('KeyringController:getKeyringsByType', _keyring.KeyringType.hdKeyTree);
          if (!keyring.mnemonic) {
            throw new Error('Primary keyring mnemonic unavailable.');
          }
          return keyring.mnemonic;
        }
        try {
          const {
            type,
            mnemonic
          } = await messenger.call('KeyringController:withKeyring', {
            id: source
          }, async ({
            keyring
          }) => ({
            type: keyring.type,
            mnemonic: (0, _utils.hasProperty)(keyring, 'mnemonic') ? keyring.mnemonic : undefined
          }));
          if (type !== _keyringController.KeyringTypes.hd || !mnemonic) {
            // The keyring isn't guaranteed to have a mnemonic (e.g.,
            // hardware wallets, which can't be used as entropy sources),
            // so we throw an error if it doesn't.
            throw new Error(`Entropy source with ID "${source}" not found.`);
          }
          return mnemonic;
        } catch {
          throw new Error(`Entropy source with ID "${source}" not found.`);
        }
      },
      /**
       * Get the mnemonic seed for a given entropy source. If no source is
       * provided, the primary HD keyring's mnemonic seed will be returned.
       *
       * @param source - The ID of the entropy source keyring.
       * @returns The mnemonic seed.
       */
      getMnemonicSeed: async source => {
        if (!source) {
          const [keyring] = messenger.call('KeyringController:getKeyringsByType', _keyring.KeyringType.hdKeyTree);
          if (!keyring.seed) {
            throw new Error('Primary keyring mnemonic unavailable.');
          }
          return keyring.seed;
        }
        try {
          const {
            type,
            seed
          } = await messenger.call('KeyringController:withKeyring', {
            id: source
          }, async ({
            keyring
          }) => ({
            type: keyring.type,
            seed: (0, _utils.hasProperty)(keyring, 'seed') ? keyring.seed : undefined
          }));
          if (type !== _keyringController.KeyringTypes.hd || !seed) {
            // The keyring isn't guaranteed to have a mnemonic (e.g.,
            // hardware wallets, which can't be used as entropy sources),
            // so we throw an error if it doesn't.
            throw new Error(`Entropy source with ID "${source}" not found.`);
          }
          return seed;
        } catch {
          throw new Error(`Entropy source with ID "${source}" not found.`);
        }
      },
      getUnlockPromise: messenger.call.bind(messenger, 'AppStateController:getUnlockPromise'),
      getSnap: messenger.call.bind(messenger, 'SnapController:get'),
      handleSnapRpcRequest: messenger.call.bind(messenger, 'SnapController:handleRequest'),
      getSnapState: messenger.call.bind(messenger, 'SnapController:getSnapState'),
      requestUserApproval: hooks.addAndShowApprovalRequest,
      /**
       * Show a native (system) notification.
       *
       * @param origin - The origin requesting the notification.
       * @param args - The notification arguments.
       * @param args.message - The notification message.
       * @returns A promise that resolves when the notification is shown.
       */
      showNativeNotification: (origin, args) => messenger.call('RateLimitController:call', origin, 'showNativeNotification',
      // @ts-expect-error: `RateLimitController` methods aren't properly
      // typed yet.
      origin, args.message),
      /**
       * Show an in-app notification.
       *
       * @param origin - The origin requesting the notification.
       * @param args - The notification arguments.
       * @param args.message - The notification message.
       * @param args.title - The notification title.
       * @param args.footerLink - The notification footer link.
       * @param args.content - The notification content identifier.
       * @returns A promise that resolves when the notification is shown.
       */
      showInAppNotification: (origin, args) => {
        const {
          content,
          message,
          title,
          footerLink
        } = args;
        const notificationArgs = {
          interfaceId: content,
          message,
          title,
          footerLink
        };
        return messenger.call('RateLimitController:call', origin, 'showInAppNotification',
        // @ts-expect-error: `RateLimitController` methods aren't properly
        // typed yet.
        origin, notificationArgs);
      },
      updateSnapState: messenger.call.bind(messenger, 'SnapController:updateSnapState'),
      /**
       * If phishing detection is enabled, check for an updated phishing
       * list.
       */
      maybeUpdatePhishingList: () => {
        const {
          usePhishDetect
        } = messenger.call('PreferencesController:getState');
        if (!usePhishDetect) {
          return;
        }
        messenger.call('PhishingController:maybeUpdateState');
      },
      /**
       * Check whether a URL is on the phishing list.
       *
       * @param url - The URL to check.
       * @returns A boolean indicating whether the URL is on the phishing
       * list. If phishing detection is disabled, false is returned.
       */
      isOnPhishingList: url => {
        const {
          usePhishDetect
        } = messenger.call('PreferencesController:getState');
        if (!usePhishDetect) {
          return false;
        }
        return messenger.call('PhishingController:testOrigin', url).result;
      },
      createInterface: messenger.call.bind(messenger, 'SnapInterfaceController:createInterface'),
      getInterface: messenger.call.bind(messenger, 'SnapInterfaceController:getInterface'),
      /**
       * Get custom cryptography implementations for the client.
       *
       * @returns An object containing custom cryptography implementations.
       * We currently don't use any specific implementations, so this is an
       * empty object.
       */
      getClientCryptography: () => ({}),
      ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
      getSnapKeyring: async () => {
        // TODO: Use `withKeyring` instead.
        const [snapKeyring] = messenger.call('KeyringController:getKeyringsByType', _keyring.KeyringType.snap);
        if (!snapKeyring) {
          await hooks.addNewKeyring(_keyring.KeyringType.snap);
          return messenger.call('KeyringController:getKeyringsByType', _keyring.KeyringType.snap)[0];
        }
        return snapKeyring;
      }
      ///: END:ONLY_INCLUDE_IF
    })
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controllers\\permissions\\snaps\\specifications.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\preferences-controller.ts", {"../../../shared/constants/hardware-wallets":"D:\\code\\v\\metamask-extension\\shared\\constants\\hardware-wallets.ts","../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../shared/constants/preferences":"D:\\code\\v\\metamask-extension\\shared\\constants\\preferences.ts","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontrollers%5Cpreferences-controller.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultPreferencesControllerState = exports.ReferralStatus = exports.PreferencesController = void 0;
var _baseController = require("@metamask/base-controller");
var _network = require("../../../shared/constants/network");
var _hardwareWallets = require("../../../shared/constants/hardware-wallets");
var _preferences = require("../../../shared/constants/preferences");
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
/**
 * Referral status for an account (currently used for Hyperliquid referrals)
 */
let ReferralStatus = exports.ReferralStatus = /*#__PURE__*/function (ReferralStatus) {
  ReferralStatus["Approved"] = "approved";
  ReferralStatus["Passed"] = "passed";
  ReferralStatus["Declined"] = "declined";
  return ReferralStatus;
}({});
const controllerName = 'PreferencesController';

/**
 * Returns the state of the {@link PreferencesController}.
 */

/**
 * Actions exposed by the {@link PreferencesController}.
 */

/**
 * Event emitted when the state of the {@link PreferencesController} changes.
 */

/**
 * Events emitted by {@link PreferencesController}.
 */

/**
 * Actions that this controller is allowed to call.
 */

/**
 * Events that this controller is allowed to subscribe.
 */

// Omitting properties that already exist in the PreferencesState, as part of the preferences property.

/**
 * Function to get default state of the {@link PreferencesController}.
 */
const getDefaultPreferencesControllerState = () => ({
  ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
  addSnapAccountEnabled: false,
  ///: END:ONLY_INCLUDE_IF
  advancedGasFee: {},
  currentLocale: '',
  dismissSeedBackUpReminder: false,
  enableMV3TimestampSave: true,
  featureFlags: {},
  forgottenPassword: false,
  identities: {},
  // ENS decentralized website resolution
  ipfsGateway: _network.IPFS_DEFAULT_GATEWAY_URL,
  isIpfsGatewayEnabled: true,
  // from core PreferencesController
  isMultiAccountBalancesEnabled: true,
  knownMethodData: {},
  // Ledger transport type is deprecated. We currently only support webhid
  // on chrome, and u2f on firefox.
  ledgerTransportType: window.navigator.hid ? _hardwareWallets.LedgerTransportTypes.webhid : _hardwareWallets.LedgerTransportTypes.u2f,
  lostIdentities: {},
  manageInstitutionalWallets: false,
  openSeaEnabled: true,
  overrideContentSecurityPolicyHeader: true,
  preferences: {
    autoLockTimeLimit: undefined,
    avatarType: 'maskicon',
    dismissSmartAccountSuggestionEnabled: false,
    featureNotificationsEnabled: false,
    hideZeroBalanceTokens: false,
    petnamesEnabled: true,
    privacyMode: false,
    showConfirmationAdvancedDetails: false,
    showExtensionInFullSizeView: false,
    showFiatInTestnets: false,
    showMultiRpcModal: false,
    showNativeTokenAsMainBalance: false,
    showTestNetworks: false,
    skipDeepLinkInterstitial: false,
    smartAccountOptIn: true,
    smartTransactionsOptInStatus: true,
    smartTransactionsMigrationApplied: false,
    tokenNetworkFilter: {},
    tokenSortConfig: {
      key: 'tokenFiatAmount',
      order: 'dsc',
      sortCallback: 'stringNumeric'
    },
    useNativeCurrencyAsPrimaryCurrency: true
  },
  securityAlertsEnabled: true,
  selectedAddress: '',
  snapRegistryList: {},
  ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
  snapsAddSnapAccountModalDismissed: false,
  ///: END:ONLY_INCLUDE_IF
  theme: _preferences.ThemeType.os,
  use4ByteResolution: true,
  useAddressBarEnsResolution: true,
  useBlockie: false,
  useCurrencyRateCheck: true,
  useExternalNameSources: true,
  // Turning OFF basic functionality toggle means turning OFF this useExternalServices flag.
  // Whenever useExternalServices is false, certain features will be disabled.
  // The flag is true by Default, meaning the toggle is ON by default.
  useExternalServices: true,
  useMultiAccountBalanceChecker: true,
  useNftDetection: true,
  usePhishDetect: true,
  useSafeChainsListValidation: true,
  // set to true means the dynamic list from the API is being used
  // set to false will be using the static list from contract-metadata
  useTokenDetection: true,
  useTransactionSimulations: true,
  watchEthereumAccountEnabled: false,
  referrals: {
    hyperliquid: {}
  }
});

/**
 * {@link PreferencesController}'s metadata.
 *
 * This allows us to choose if fields of the state should be persisted or not
 * using the `persist` flag; and if they can be sent to Sentry or not, using
 * the `anonymous` flag.
 */
exports.getDefaultPreferencesControllerState = getDefaultPreferencesControllerState;
const controllerMetadata = {
  addSnapAccountEnabled: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: true
  },
  advancedGasFee: {
    persist: true,
    includeInStateLogs: true,
    anonymous: true,
    usedInUi: true
  },
  currentLocale: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  dismissSeedBackUpReminder: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  enableMV3TimestampSave: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  featureFlags: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  forgottenPassword: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  identities: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: true
  },
  ipfsGateway: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: true
  },
  isIpfsGatewayEnabled: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: true
  },
  isMultiAccountBalancesEnabled: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  knownMethodData: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: true
  },
  ledgerTransportType: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  lostIdentities: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: true
  },
  manageInstitutionalWallets: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: true
  },
  openSeaEnabled: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  overrideContentSecurityPolicyHeader: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  preferences: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  securityAlertsEnabled: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: true
  },
  selectedAddress: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: true
  },
  snapRegistryList: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: true
  },
  snapsAddSnapAccountModalDismissed: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: true
  },
  textDirection: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: true
  },
  theme: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  use4ByteResolution: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  useAddressBarEnsResolution: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  /** @deprecated Use avatarType instead */
  useBlockie: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  useCurrencyRateCheck: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  useExternalNameSources: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: true
  },
  useExternalServices: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: true
  },
  useMultiAccountBalanceChecker: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  useNftDetection: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  usePhishDetect: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  useSafeChainsListValidation: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: true
  },
  useTokenDetection: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  useTransactionSimulations: {
    includeInStateLogs: true,
    persist: true,
    anonymous: true,
    usedInUi: true
  },
  watchEthereumAccountEnabled: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: true
  },
  referrals: {
    includeInStateLogs: true,
    persist: true,
    anonymous: false,
    usedInUi: true
  }
};
var _PreferencesController_brand = /*#__PURE__*/new WeakSet();
class PreferencesController extends _baseController.BaseController {
  /**
   * Constructs a Preferences controller.
   *
   * @param options - the controller options
   * @param options.messenger - The controller messenger
   * @param options.state - The initial controller state
   */
  constructor({
    messenger,
    state: _state
  }) {
    const defaultState = getDefaultPreferencesControllerState();
    const mergedState = {
      ...defaultState,
      ..._state,
      preferences: {
        ...defaultState.preferences,
        ...(_state === null || _state === void 0 ? void 0 : _state.preferences)
      }
    };
    super({
      messenger,
      metadata: controllerMetadata,
      name: controllerName,
      state: mergedState
    });
    ///: END:ONLY_INCLUDE_IF
    _classPrivateMethodInitSpec(this, _PreferencesController_brand);
    this.messagingSystem.subscribe('AccountsController:stateChange', _assertClassBrand(_PreferencesController_brand, this, _handleAccountsControllerSync).bind(this));
    globalThis.setPreference = (key, value) => {
      return this.setFeatureFlag(key, value);
    };
  }

  /**
   * Sets the {@code forgottenPassword} state property
   *
   * @param forgottenPassword - whether or not the user has forgotten their password
   */
  setPasswordForgotten(forgottenPassword) {
    this.update(state => {
      state.forgottenPassword = forgottenPassword;
    });
  }

  /**
   * Setter for the `useBlockie` property
   *
   * @deprecated Use setAvatarType instead
   * @param val - Whether or not the user prefers blockie indicators
   */
  setUseBlockie(val) {
    this.update(state => {
      state.useBlockie = val;
    });
  }

  /**
   * Setter for the `usePhishDetect` property
   *
   * @param val - Whether or not the user prefers phishing domain protection
   */
  setUsePhishDetect(val) {
    this.update(state => {
      state.usePhishDetect = val;
    });
  }

  /**
   * Setter for the `useMultiAccountBalanceChecker` property
   *
   * @param val - Whether or not the user prefers to turn off/on all security settings
   */
  setUseMultiAccountBalanceChecker(val) {
    this.update(state => {
      state.useMultiAccountBalanceChecker = val;
    });
  }

  /**
   * Setter for the `useSafeChainsListValidation` property
   *
   * @param val - Whether or not the user prefers to turn off/on validation for manually adding networks
   */
  setUseSafeChainsListValidation(val) {
    this.update(state => {
      state.useSafeChainsListValidation = val;
    });
  }
  toggleExternalServices(useExternalServices) {
    this.update(state => {
      state.useExternalServices = useExternalServices;
    });
    this.setUseTokenDetection(useExternalServices);
    this.setUseCurrencyRateCheck(useExternalServices);
    this.setUsePhishDetect(useExternalServices);
    this.setUseAddressBarEnsResolution(useExternalServices);
    this.setOpenSeaEnabled(useExternalServices);
    this.setUseNftDetection(useExternalServices);
    this.setUseSafeChainsListValidation(useExternalServices);
  }

  /**
   * Setter for the `useTokenDetection` property
   *
   * @param val - Whether or not the user prefers to use the static token list or dynamic token list from the API
   */
  setUseTokenDetection(val) {
    this.update(state => {
      state.useTokenDetection = val;
    });
  }

  /**
   * Setter for the `useNftDetection` property
   *
   * @param useNftDetection - Whether or not the user prefers to autodetect NFTs.
   */
  setUseNftDetection(useNftDetection) {
    this.update(state => {
      state.useNftDetection = useNftDetection;
    });
  }

  /**
   * Setter for the `use4ByteResolution` property
   *
   * @param use4ByteResolution - (Privacy) Whether or not the user prefers to have smart contract name details resolved with 4byte.directory
   */
  setUse4ByteResolution(use4ByteResolution) {
    this.update(state => {
      state.use4ByteResolution = use4ByteResolution;
    });
  }

  /**
   * Setter for the `useCurrencyRateCheck` property
   *
   * @param val - Whether or not the user prefers to use currency rate check for ETH and tokens.
   */
  setUseCurrencyRateCheck(val) {
    this.update(state => {
      state.useCurrencyRateCheck = val;
    });
  }

  /**
   * Setter for the `openSeaEnabled` property
   *
   * @param openSeaEnabled - Whether or not the user prefers to use the OpenSea API for NFTs data.
   */
  setOpenSeaEnabled(openSeaEnabled) {
    this.update(state => {
      state.openSeaEnabled = openSeaEnabled;
    });
  }

  /**
   * Setter for the `securityAlertsEnabled` property
   *
   * @param securityAlertsEnabled - Whether or not the user prefers to use the security alerts.
   */
  setSecurityAlertsEnabled(securityAlertsEnabled) {
    this.update(state => {
      state.securityAlertsEnabled = securityAlertsEnabled;
    });
  }

  ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
  /**
   * Setter for the `addSnapAccountEnabled` property.
   *
   * @param addSnapAccountEnabled - Whether or not the user wants to
   * enable the "Add Snap accounts" button.
   */
  setAddSnapAccountEnabled(addSnapAccountEnabled) {
    this.update(state => {
      state.addSnapAccountEnabled = addSnapAccountEnabled;
    });
  }
  ///: END:ONLY_INCLUDE_IF

  /**
   * Setter for the `useExternalNameSources` property
   *
   * @param useExternalNameSources - Whether or not to use external name providers in the name controller.
   */
  setUseExternalNameSources(useExternalNameSources) {
    this.update(state => {
      state.useExternalNameSources = useExternalNameSources;
    });
  }

  /**
   * Setter for the `useTransactionSimulations` property
   *
   * @param useTransactionSimulations - Whether or not to use simulations in the transaction confirmations.
   */
  setUseTransactionSimulations(useTransactionSimulations) {
    this.update(state => {
      state.useTransactionSimulations = useTransactionSimulations;
    });
  }

  /**
   * Setter for the `advancedGasFee` property
   *
   * @param options
   * @param options.chainId - The chainId the advancedGasFees should be set on
   * @param options.gasFeePreferences - The advancedGasFee options to set
   */
  setAdvancedGasFee({
    chainId,
    gasFeePreferences
  }) {
    const {
      advancedGasFee
    } = this.state;
    this.update(state => {
      state.advancedGasFee = {
        ...advancedGasFee,
        [chainId]: gasFeePreferences
      };
    });
  }

  /**
   * Setter for the `theme` property
   *
   * @param val - 'default' or 'dark' value based on the mode selected by user.
   */
  setTheme(val) {
    this.update(state => {
      state.theme = val;
    });
  }

  /**
   * Add new methodData to state, to avoid requesting this information again through Infura
   *
   * @param fourBytePrefix - Four-byte method signature
   * @param methodData - Corresponding data method
   */
  addKnownMethodData(fourBytePrefix, methodData) {
    const {
      knownMethodData
    } = this.state;
    const updatedKnownMethodData = {
      ...knownMethodData
    };
    updatedKnownMethodData[fourBytePrefix] = methodData;
    this.update(state => {
      state.knownMethodData = updatedKnownMethodData;
    });
  }

  /**
   * Setter for the `currentLocale` property
   *
   * @param key - he preferred language locale key
   */
  setCurrentLocale(key) {
    const textDirection = ['ar', 'dv', 'fa', 'he', 'ku'].includes(key) ? 'rtl' : 'auto';
    this.update(state => {
      state.currentLocale = key;
      state.textDirection = textDirection;
    });
    return textDirection;
  }

  /**
   * Setter for the `selectedAddress` property
   *
   * @deprecated - Use setSelectedAccount from the AccountsController
   * @param address - A new hex address for an account
   */
  setSelectedAddress(address) {
    const account = this.messagingSystem.call('AccountsController:getAccountByAddress', address);
    if (!account) {
      throw new Error(`Identity for '${address} not found`);
    }
    this.messagingSystem.call('AccountsController:setSelectedAccount', account.id);
  }

  /**
   * Getter for the `selectedAddress` property
   *
   * @deprecated - Use the getSelectedAccount from the AccountsController
   * @returns The hex address for the currently selected account
   */
  getSelectedAddress() {
    const selectedAccount = this.messagingSystem.call('AccountsController:getSelectedAccount');
    return selectedAccount.address;
  }

  /**
   * Sets a custom label for an account
   *
   * @deprecated - Use setAccountName from the AccountsController
   * @param address - the account to set a label for
   * @param label - the custom label for the account
   * @returns the account label
   */
  setAccountLabel(address, label) {
    if (!address) {
      throw new Error(`setAccountLabel requires a valid address, got ${String(address)}`);
    }
    const account = this.messagingSystem.call('AccountsController:getAccountByAddress', address);
    if (account) {
      this.messagingSystem.call('AccountsController:setAccountName', account.id, label);
      return label;
    }
    return undefined;
  }

  /**
   * Updates the `featureFlags` property, which is an object. One property within that object will be set to a boolean.
   *
   * @param feature - A key that corresponds to a UI feature.
   * @param activated - Indicates whether or not the UI feature should be displayed
   * @returns the updated featureFlags object.
   */
  setFeatureFlag(feature, activated) {
    const currentFeatureFlags = this.state.featureFlags;
    const updatedFeatureFlags = {
      ...currentFeatureFlags,
      [feature]: activated
    };
    this.update(state => {
      state.featureFlags = updatedFeatureFlags;
    });
    return updatedFeatureFlags;
  }

  /**
   * Updates the `preferences` property, which is an object. These are user-controlled features
   * found in the settings page.
   *
   * @param preference - The preference to enable or disable.
   * @param value - Indicates whether or not the preference should be enabled or disabled.
   * @returns Promises a updated Preferences object.
   */
  setPreference(preference, value) {
    const currentPreferences = this.getPreferences();
    const updatedPreferences = {
      ...currentPreferences,
      [preference]: value
    };
    this.update(state => {
      state.preferences = updatedPreferences;
    });
    return updatedPreferences;
  }

  /**
   * A getter for the `preferences` property
   *
   * @returns A map of user-selected preferences.
   */
  getPreferences() {
    return this.state.preferences;
  }

  /**
   * A getter for the `ipfsGateway` property
   *
   * @returns The current IPFS gateway domain
   */
  getIpfsGateway() {
    return this.state.ipfsGateway;
  }

  /**
   * A setter for the `ipfsGateway` property
   *
   * @param domain - The new IPFS gateway domain
   * @returns the update IPFS gateway domain
   */
  setIpfsGateway(domain) {
    this.update(state => {
      state.ipfsGateway = domain;
    });
    return domain;
  }

  /**
   * A setter for the `isIpfsGatewayEnabled` property
   *
   * @param enabled - Whether or not IPFS is enabled
   */
  setIsIpfsGatewayEnabled(enabled) {
    this.update(state => {
      state.isIpfsGatewayEnabled = enabled;
    });
  }

  /**
   * A setter for the `useAddressBarEnsResolution` property
   *
   * @param useAddressBarEnsResolution - Whether or not user prefers IPFS resolution for domains
   */
  setUseAddressBarEnsResolution(useAddressBarEnsResolution) {
    this.update(state => {
      state.useAddressBarEnsResolution = useAddressBarEnsResolution;
    });
  }

  /**
   * A setter for the `ledgerTransportType` property.
   *
   * @deprecated We no longer support specifying a ledger transport type other
   * than webhid, therefore managing a preference is no longer necessary.
   * @param ledgerTransportType - 'webhid'
   * @returns The transport type that was set.
   */
  setLedgerTransportPreference(ledgerTransportType) {
    this.update(state => {
      state.ledgerTransportType = ledgerTransportType;
    });
    return ledgerTransportType;
  }

  /**
   * A setter for the user preference to dismiss the seed phrase backup reminder
   *
   * @param dismissSeedBackUpReminder - User preference for dismissing the back up reminder.
   */
  setDismissSeedBackUpReminder(dismissSeedBackUpReminder) {
    this.update(state => {
      state.dismissSeedBackUpReminder = dismissSeedBackUpReminder;
    });
  }

  /**
   * A setter for the user preference to override the Content-Security-Policy header
   *
   * @param overrideContentSecurityPolicyHeader - User preference for overriding the Content-Security-Policy header.
   */
  setOverrideContentSecurityPolicyHeader(overrideContentSecurityPolicyHeader) {
    this.update(state => {
      state.overrideContentSecurityPolicyHeader = overrideContentSecurityPolicyHeader;
    });
  }

  /**
   * A setter for the user preference to manage institutional wallets
   *
   * @param manageInstitutionalWallets - User preference for managing institutional wallets.
   */
  setManageInstitutionalWallets(manageInstitutionalWallets) {
    this.update(state => {
      state.manageInstitutionalWallets = manageInstitutionalWallets;
    });
  }
  setServiceWorkerKeepAlivePreference(value) {
    this.update(state => {
      state.enableMV3TimestampSave = value;
    });
  }

  ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
  setSnapsAddSnapAccountModalDismissed(value) {
    this.update(state => {
      state.snapsAddSnapAccountModalDismissed = value;
    });
  }
  addReferralApprovedAccount(accountAddress) {
    this.update(state => {
      state.referrals.hyperliquid[accountAddress] = ReferralStatus.Approved;
    });
  }
  addReferralPassedAccount(accountAddress) {
    this.update(state => {
      state.referrals.hyperliquid[accountAddress] = ReferralStatus.Passed;
    });
  }
  addReferralDeclinedAccount(accountAddress) {
    this.update(state => {
      state.referrals.hyperliquid[accountAddress] = ReferralStatus.Declined;
    });
  }
  removeReferralDeclinedAccount(accountAddress) {
    this.update(state => {
      delete state.referrals.hyperliquid[accountAddress];
    });
  }
  setAccountsReferralApproved(accountAddresses) {
    this.update(state => {
      accountAddresses.forEach(address => {
        state.referrals.hyperliquid[address] = ReferralStatus.Approved;
      });
    });
  }
}
exports.PreferencesController = PreferencesController;
function _handleAccountsControllerSync(newAccountsControllerState) {
  const {
    accounts,
    selectedAccount: selectedAccountId
  } = newAccountsControllerState.internalAccounts;
  const selectedAccount = accounts[selectedAccountId];
  const {
    identities,
    lostIdentities
  } = this.state;
  const addresses = Object.values(accounts).map(account => account.address.toLowerCase());
  const updatedLostIdentities = Object.keys(identities).reduce((acc, identity) => {
    if (addresses.includes(identity.toLowerCase())) {
      acc[identity] = identities[identity];
    }
    return acc;
  }, {
    ...(lostIdentities ?? {})
  });
  const updatedIdentities = Object.values(accounts).reduce((identitiesMap, account) => {
    identitiesMap[account.address] = {
      address: account.address,
      name: account.metadata.name,
      lastSelected: account.metadata.lastSelected
    };
    return identitiesMap;
  }, {});
  this.update(state => {
    state.identities = updatedIdentities;
    state.lostIdentities = updatedLostIdentities;
    state.selectedAddress = (selectedAccount === null || selectedAccount === void 0 ? void 0 : selectedAccount.address) || ''; // it will be an empty string during onboarding
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controllers\\preferences-controller.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\push-notifications\\get-notification-image.ts", {"webextension-polyfill":"D:\\code\\v\\metamask-extension\\node_modules\\webextension-polyfill\\dist\\browser-polyfill.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontrollers%5Cpush-notifications%5Cget-notification-image.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNotificationImage = getNotificationImage;
var _webextensionPolyfill = _interopRequireDefault(require("webextension-polyfill"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
async function getNotificationImage() {
  const iconUrl = await _webextensionPolyfill.default.runtime.getURL('../../images/icon-64.png');
  return iconUrl;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controllers\\push-notifications\\get-notification-image.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\push-notifications\\get-notification-message.ts", {"../../../../shared/lib/translate":"D:\\code\\v\\metamask-extension\\shared\\lib\\translate.ts","@metamask/notification-services-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontrollers%5Cpush-notifications%5Cget-notification-message.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createNotificationMessage = createNotificationMessage;
var _notificationServicesController = require("@metamask/notification-services-controller");
var _translate = require("../../../../shared/lib/translate");
const t = (...args) => (0, _translate.t)(...args) ?? '';
const walletNotifTranslations = {
  pushPlatformNotificationsFundsSentTitle: () => t('pushPlatformNotificationsFundsSentTitle'),
  pushPlatformNotificationsFundsSentDescriptionDefault: () => t('pushPlatformNotificationsFundsSentDescriptionDefault'),
  pushPlatformNotificationsFundsSentDescription: (amount, symbol) => t('pushPlatformNotificationsFundsSentDescription', amount, symbol),
  pushPlatformNotificationsFundsReceivedTitle: () => t('pushPlatformNotificationsFundsReceivedTitle'),
  pushPlatformNotificationsFundsReceivedDescriptionDefault: () => t('pushPlatformNotificationsFundsReceivedDescriptionDefault'),
  pushPlatformNotificationsFundsReceivedDescription: (amount, symbol) => t('pushPlatformNotificationsFundsReceivedDescription', amount, symbol),
  pushPlatformNotificationsSwapCompletedTitle: () => t('pushPlatformNotificationsSwapCompletedTitle'),
  pushPlatformNotificationsSwapCompletedDescription: () => t('pushPlatformNotificationsSwapCompletedDescription'),
  pushPlatformNotificationsNftSentTitle: () => t('pushPlatformNotificationsNftSentTitle'),
  pushPlatformNotificationsNftSentDescription: () => t('pushPlatformNotificationsNftSentDescription'),
  pushPlatformNotificationsNftReceivedTitle: () => t('pushPlatformNotificationsNftReceivedTitle'),
  pushPlatformNotificationsNftReceivedDescription: () => t('pushPlatformNotificationsNftReceivedDescription'),
  pushPlatformNotificationsStakingRocketpoolStakeCompletedTitle: () => t('pushPlatformNotificationsStakingRocketpoolStakeCompletedTitle'),
  pushPlatformNotificationsStakingRocketpoolStakeCompletedDescription: () => t('pushPlatformNotificationsStakingRocketpoolStakeCompletedDescription'),
  pushPlatformNotificationsStakingRocketpoolUnstakeCompletedTitle: () => t('pushPlatformNotificationsStakingRocketpoolUnstakeCompletedTitle'),
  pushPlatformNotificationsStakingRocketpoolUnstakeCompletedDescription: () => t('pushPlatformNotificationsStakingRocketpoolUnstakeCompletedDescription'),
  pushPlatformNotificationsStakingLidoStakeCompletedTitle: () => t('pushPlatformNotificationsStakingLidoStakeCompletedTitle'),
  pushPlatformNotificationsStakingLidoStakeCompletedDescription: () => t('pushPlatformNotificationsStakingLidoStakeCompletedDescription'),
  pushPlatformNotificationsStakingLidoStakeReadyToBeWithdrawnTitle: () => t('pushPlatformNotificationsStakingLidoStakeReadyToBeWithdrawnTitle'),
  pushPlatformNotificationsStakingLidoStakeReadyToBeWithdrawnDescription: () => t('pushPlatformNotificationsStakingLidoStakeReadyToBeWithdrawnDescription'),
  pushPlatformNotificationsStakingLidoWithdrawalRequestedTitle: () => t('pushPlatformNotificationsStakingLidoWithdrawalRequestedTitle'),
  pushPlatformNotificationsStakingLidoWithdrawalRequestedDescription: () => t('pushPlatformNotificationsStakingLidoWithdrawalRequestedDescription'),
  pushPlatformNotificationsStakingLidoWithdrawalCompletedTitle: () => t('pushPlatformNotificationsStakingLidoWithdrawalCompletedTitle'),
  pushPlatformNotificationsStakingLidoWithdrawalCompletedDescription: () => t('pushPlatformNotificationsStakingLidoWithdrawalCompletedDescription')
};
const perpsTranslations = {
  PositionLiquidatedTitle: () => t('pushNotificationPositionLiquidatedTitle'),
  PositionLiquidatedDescriptionLong: symbol => t('pushNotificationPositionLiquidatedDescriptionLong', symbol),
  PositionLiquidatedDescriptionShort: symbol => t('pushNotificationPositionLiquidatedDescriptionShort', symbol),
  StopLossTriggeredTitle: () => t('pushNotificationStopLossTriggeredTitle'),
  StopLossTriggeredDescriptionLong: symbol => t('pushNotificationStopLossTriggeredDescriptionLong', symbol),
  StopLossTriggeredDescriptionShort: symbol => t('pushNotificationStopLossTriggeredDescriptionShort', symbol),
  TakeProfitTriggeredTitle: () => t('pushNotificationTakeProfitTriggeredTitle'),
  TakeProfitTriggeredDescriptionLong: symbol => t('pushNotificationTakeProfitTriggeredDescriptionLong', symbol),
  TakeProfitTriggeredDescriptionShort: symbol => t('pushNotificationTakeProfitTriggeredDescriptionShort', symbol),
  LimitOrderFilledTitle: () => t('pushNotificationLimitOrderFilledTitle'),
  LimitOrderFilledDescriptionLong: symbol => t('pushNotificationLimitOrderFilledDescriptionLong', symbol),
  LimitOrderFilledDescriptionShort: symbol => t('pushNotificationLimitOrderFilledDescriptionShort', symbol)
};
const translations = {
  ...walletNotifTranslations,
  ...perpsTranslations
};
function createNotificationMessage(n) {
  return _notificationServicesController.NotificationServicesPushController.Utils.createOnChainPushNotificationMessage(n, translations);
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controllers\\push-notifications\\get-notification-message.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\push-notifications\\index.ts", {"../../platforms/extension":"D:\\code\\v\\metamask-extension\\app\\scripts\\platforms\\extension.js","./get-notification-image":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\push-notifications\\get-notification-image.ts","./get-notification-message":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\push-notifications\\get-notification-message.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontrollers%5Cpush-notifications%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onPushNotificationClicked = onPushNotificationClicked;
exports.onPushNotificationReceived = onPushNotificationReceived;
var _extension = _interopRequireDefault(require("../../platforms/extension"));
var _getNotificationImage = require("./get-notification-image");
var _getNotificationMessage = require("./get-notification-message");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// We are defining that this file uses a webworker global scope.
// eslint-disable-next-line spaced-comment
/// <reference lib="webworker" />

const sw = self;
const extensionPlatform = new _extension.default();
async function onPushNotificationReceived(notification) {
  const notificationMessage = (0, _getNotificationMessage.createNotificationMessage)(notification);
  if (!notificationMessage) {
    return;
  }
  const registration = sw === null || sw === void 0 ? void 0 : sw.registration;
  if (!registration) {
    return;
  }
  const iconUrl = await (0, _getNotificationImage.getNotificationImage)();
  await registration.showNotification(notificationMessage.title, {
    body: notificationMessage.description,
    icon: iconUrl,
    tag: notification === null || notification === void 0 ? void 0 : notification.id,
    data: notification
  });
}
async function onPushNotificationClicked(event, notification) {
  var _event$notification;
  // Close notification
  event.notification.close();

  // Get Data
  const data = notification ?? (event === null || event === void 0 || (_event$notification = event.notification) === null || _event$notification === void 0 ? void 0 : _event$notification.data);

  // Navigate
  const destination = `${extensionPlatform.getExtensionURL(null, null)}#notifications/${data.id}`;
  event.waitUntil(sw.clients.openWindow(destination));
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controllers\\push-notifications\\index.ts",}]],[],{})

//# sourceMappingURL=data:application/json;charset=utf8;base64,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