LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\swaps\\index.ts", {"../../../../shared/constants/common":"D:\\code\\v\\metamask-extension\\shared\\constants\\common.ts","../../../../shared/constants/gas":"D:\\code\\v\\metamask-extension\\shared\\constants\\gas.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../shared/constants/smartTransactions":"D:\\code\\v\\metamask-extension\\shared\\constants\\smartTransactions.ts","../../../../shared/constants/swaps":"D:\\code\\v\\metamask-extension\\shared\\constants\\swaps.ts","../../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../../shared/lib/fetch-with-cache":"D:\\code\\v\\metamask-extension\\shared\\lib\\fetch-with-cache.ts","../../../../shared/lib/sentry":"D:\\code\\v\\metamask-extension\\shared\\lib\\sentry.ts","../../../../shared/lib/swaps-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\swaps-utils.js","../../../../shared/lib/transactions-controller-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\transactions-controller-utils.js","../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts","../../../../shared/modules/swaps.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\swaps.utils.js","./swaps.constants":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\swaps\\swaps.constants.ts","./swaps.utils":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\swaps\\swaps.utils.ts","@ethersproject/contracts":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\contracts\\lib\\index.js","@ethersproject/providers":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\providers\\lib\\index.js","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","human-standard-token-abi":"D:\\code\\v\\metamask-extension\\node_modules\\human-standard-token-abi\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontrollers%5Cswaps%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _contracts = require("@ethersproject/contracts");
var _providers = require("@ethersproject/providers");
var _baseController = require("@metamask/base-controller");
var _bignumber = require("bignumber.js");
var _humanStandardTokenAbi = _interopRequireDefault(require("human-standard-token-abi"));
var _lodash = require("lodash");
var _sentry = require("../../../../shared/lib/sentry");
var _common = require("../../../../shared/constants/common");
var _gas = require("../../../../shared/constants/gas");
var _metametrics = require("../../../../shared/constants/metametrics");
var _network2 = require("../../../../shared/constants/network");
var _smartTransactions = require("../../../../shared/constants/smartTransactions");
var _swaps = require("../../../../shared/constants/swaps");
var _time = require("../../../../shared/constants/time");
var _fetchWithCache = _interopRequireDefault(require("../../../../shared/lib/fetch-with-cache"));
var _swapsUtils = require("../../../../shared/lib/swaps-utils");
var _transactionsControllerUtils = require("../../../../shared/lib/transactions-controller-utils");
var _conversion = require("../../../../shared/modules/conversion.utils");
var _Numeric = require("../../../../shared/modules/Numeric");
var _stringUtils = require("../../../../shared/modules/string-utils");
var _swaps2 = require("../../../../shared/modules/swaps.utils");
var _swaps3 = require("./swaps.constants");
var _swaps4 = require("./swaps.utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
const metadata = {
  swapsState: {
    includeInStateLogs: true,
    persist: false,
    anonymous: false,
    usedInUi: true
  }
};
var _indexOfNewestCallInFlight = /*#__PURE__*/new WeakMap();
var _pollCount = /*#__PURE__*/new WeakMap();
var _pollingTimeout = /*#__PURE__*/new WeakMap();
var _getEIP1559GasFeeEstimates = /*#__PURE__*/new WeakMap();
var _getLayer1GasFee = /*#__PURE__*/new WeakMap();
var _network = /*#__PURE__*/new WeakMap();
var _SwapsController_brand = /*#__PURE__*/new WeakSet();
class SwapsController extends _baseController.BaseController {
  constructor(opts, state) {
    var _state$swapsState;
    super({
      name: _swaps3.controllerName,
      metadata,
      messenger: opts.messenger,
      state: {
        swapsState: {
          ...(0, _swaps3.getDefaultSwapsControllerState)().swapsState,
          swapsFeatureFlags: (state === null || state === void 0 || (_state$swapsState = state.swapsState) === null || _state$swapsState === void 0 ? void 0 : _state$swapsState.swapsFeatureFlags) || {}
        }
      }
    });
    _classPrivateMethodInitSpec(this, _SwapsController_brand);
    _defineProperty(this, "getBufferedGasLimit", void 0);
    _defineProperty(this, "resetState", void 0);
    _defineProperty(this, "trackMetaMetricsEvent", void 0);
    _classPrivateFieldInitSpec(this, _indexOfNewestCallInFlight, void 0);
    _classPrivateFieldInitSpec(this, _pollCount, void 0);
    _classPrivateFieldInitSpec(this, _pollingTimeout, null);
    _classPrivateFieldInitSpec(this, _getEIP1559GasFeeEstimates, void 0);
    _classPrivateFieldInitSpec(this, _getLayer1GasFee, void 0);
    _classPrivateFieldInitSpec(this, _network, void 0);
    _defineProperty(this, "_fetchTradesInfo", _swapsUtils.fetchTradesInfo);
    /**
     * This method is used to update the state of the controller for testing purposes.
     * DO NOT USE OUTSIDE OF TESTING
     *
     * @param newState - The new state to set
     */
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    _defineProperty(this, "__test__updateState", newState => {
      this.update(oldState => {
        return {
          swapsState: {
            ...oldState.swapsState,
            ...newState.swapsState
          }
        };
      });
    });
    this.messagingSystem.registerActionHandler(`SwapsController:fetchAndSetQuotes`, this.fetchAndSetQuotes.bind(this));
    this.messagingSystem.registerActionHandler(`SwapsController:setSelectedQuoteAggId`, this.setSelectedQuoteAggId.bind(this));
    this.messagingSystem.registerActionHandler(`SwapsController:resetSwapsState`, this.resetSwapsState.bind(this));
    this.messagingSystem.registerActionHandler(`SwapsController:setSwapsTokens`, this.setSwapsTokens.bind(this));
    this.messagingSystem.registerActionHandler(`SwapsController:clearSwapsQuotes`, this.clearSwapsQuotes.bind(this));
    this.messagingSystem.registerActionHandler(`SwapsController:setApproveTxId`, this.setApproveTxId.bind(this));
    this.messagingSystem.registerActionHandler(`SwapsController:setTradeTxId`, this.setTradeTxId.bind(this));
    this.messagingSystem.registerActionHandler(`SwapsController:setSwapsTxGasPrice`, this.setSwapsTxGasPrice.bind(this));
    this.messagingSystem.registerActionHandler(`SwapsController:setSwapsTxGasLimit`, this.setSwapsTxGasLimit.bind(this));
    this.messagingSystem.registerActionHandler(`SwapsController:setSwapsTxMaxFeePerGas`, this.setSwapsTxMaxFeePerGas.bind(this));
    this.messagingSystem.registerActionHandler(`SwapsController:setSwapsTxMaxFeePriorityPerGas`, this.setSwapsTxMaxFeePriorityPerGas.bind(this));
    this.messagingSystem.registerActionHandler(`SwapsController:safeRefetchQuotes`, this.safeRefetchQuotes.bind(this));
    this.messagingSystem.registerActionHandler(`SwapsController:stopPollingForQuotes`, this.stopPollingForQuotes.bind(this));
    this.messagingSystem.registerActionHandler(`SwapsController:setBackgroundSwapRouteState`, this.setBackgroundSwapRouteState.bind(this));
    this.messagingSystem.registerActionHandler(`SwapsController:resetPostFetchState`, this.resetPostFetchState.bind(this));
    this.messagingSystem.registerActionHandler(`SwapsController:setSwapsErrorKey`, this.setSwapsErrorKey.bind(this));
    this.messagingSystem.registerActionHandler(`SwapsController:setInitialGasEstimate`, this.setInitialGasEstimate.bind(this));
    this.messagingSystem.registerActionHandler(`SwapsController:setCustomApproveTxData`, this.setCustomApproveTxData.bind(this));
    this.messagingSystem.registerActionHandler(`SwapsController:setSwapsLiveness`, this.setSwapsLiveness.bind(this));
    this.messagingSystem.registerActionHandler(`SwapsController:setSwapsFeatureFlags`, this.setSwapsFeatureFlags.bind(this));
    this.messagingSystem.registerActionHandler(`SwapsController:setSwapsUserFeeLevel`, this.setSwapsUserFeeLevel.bind(this));
    this.messagingSystem.registerActionHandler(`SwapsController:setSwapsQuotesPollingLimitEnabled`, this.setSwapsQuotesPollingLimitEnabled.bind(this));
    this.getBufferedGasLimit = opts.getBufferedGasLimit;
    this.trackMetaMetricsEvent = opts.trackMetaMetricsEvent;

    // The resetState function is used to reset the state to the initial state, but keep the swapsFeatureFlags
    this.resetState = () => {
      this.update(_state => {
        _state.swapsState = {
          ...(0, _swaps3.getDefaultSwapsControllerState)().swapsState,
          swapsFeatureFlags: _state === null || _state === void 0 ? void 0 : _state.swapsState.swapsFeatureFlags
        };
      });
    };
    _classPrivateFieldSet(_getEIP1559GasFeeEstimates, this, opts.getEIP1559GasFeeEstimates);
    _classPrivateFieldSet(_getLayer1GasFee, this, opts.getLayer1GasFee);
    _classPrivateFieldSet(_indexOfNewestCallInFlight, this, 0);
    _classPrivateFieldSet(_pollCount, this, 0);

    // TODO: this should be private, but since a lot of tests depends on spying on it
    // we cannot enforce privacy 100%
    this._fetchTradesInfo = opts.fetchTradesInfo || _swapsUtils.fetchTradesInfo;
  }
  clearSwapsQuotes() {
    this.update(_state => {
      _state.swapsState.quotes = {};
      _state.swapsState.selectedAggId = null;
      _state.swapsState.topAggId = null;
    });
  }
  async fetchAndSetQuotes(fetchParams, fetchParamsMetaData, isPolledRequest = false) {
    var _classPrivateFieldGet2;
    if (!fetchParams) {
      return null;
    }
    let network;
    if (((_classPrivateFieldGet2 = _classPrivateFieldGet(_network, this)) === null || _classPrivateFieldGet2 === void 0 ? void 0 : _classPrivateFieldGet2.clientId) === fetchParamsMetaData.networkClientId) {
      network = _classPrivateFieldGet(_network, this);
    } else {
      network = _assertClassBrand(_SwapsController_brand, this, _setNetwork).call(this, fetchParamsMetaData.networkClientId);
    }
    const {
      quotesPollingLimitEnabled,
      saveFetchedQuotes
    } = this.state.swapsState;

    // Every time we get a new request that is not from the polling, we reset the poll count so we can poll for up to three more sets of quotes with these new params.
    if (!isPolledRequest) {
      _classPrivateFieldSet(_pollCount, this, 0);
    }

    // If there are any pending poll requests, clear them so that they don't get call while this new fetch is in process
    if (_classPrivateFieldGet(_pollingTimeout, this)) {
      clearTimeout(_classPrivateFieldGet(_pollingTimeout, this));
    }
    if (!isPolledRequest) {
      this.setSwapsErrorKey('');
    }
    const indexOfCurrentCall = _classPrivateFieldGet(_indexOfNewestCallInFlight, this) + 1;
    _classPrivateFieldSet(_indexOfNewestCallInFlight, this, indexOfCurrentCall);
    if (!saveFetchedQuotes) {
      this._setSaveFetchedQuotes(true);
    }
    let [newQuotes] = await Promise.all([this._fetchTradesInfo(fetchParams, {
      chainId: network.chainId
    }), this._setSwapsNetworkConfig(network)]);
    const {
      saveFetchedQuotes: saveFetchedQuotesAfterResponse
    } = this.state.swapsState;

    // If saveFetchedQuotesAfterResponse is false, it means a user left Swaps (we cleaned the state)
    // and we don't want to set any API response with quotes into state.
    if (!saveFetchedQuotesAfterResponse) {
      return [{},
      // quotes
      null // selectedAggId
      ];
    }
    newQuotes = (0, _lodash.mapValues)(newQuotes, quote => ({
      ...quote,
      sourceTokenInfo: fetchParamsMetaData === null || fetchParamsMetaData === void 0 ? void 0 : fetchParamsMetaData.sourceTokenInfo,
      destinationTokenInfo: fetchParamsMetaData === null || fetchParamsMetaData === void 0 ? void 0 : fetchParamsMetaData.destinationTokenInfo
    }));
    const isOptimism = network.chainId === _network2.CHAIN_IDS.OPTIMISM.toString();
    const isBase = network.chainId === _network2.CHAIN_IDS.BASE.toString();
    if ((isOptimism || isBase) && Object.values(newQuotes).length > 0) {
      await Promise.all(Object.values(newQuotes).map(async quote => {
        if (quote.trade) {
          const multiLayerL1TradeFeeTotal = await _classPrivateFieldGet(_getLayer1GasFee, this).call(this, {
            transactionParams: quote.trade,
            networkClientId: network.clientId
          });
          quote.multiLayerL1TradeFeeTotal = multiLayerL1TradeFeeTotal;
        }
        return quote;
      }));
    }
    const quotesLastFetched = Date.now();
    let approvalRequired = false;
    if (!(0, _swaps2.isSwapsDefaultTokenAddress)(fetchParams.sourceToken, network.chainId) && Object.values(newQuotes).length) {
      const allowance = await this._getERC20Allowance(fetchParams.sourceToken, fetchParams.fromAddress, network);
      const [firstQuote] = Object.values(newQuotes);

      // For a user to be able to swap a token, they need to have approved the MetaSwap contract to withdraw that token.
      // _getERC20Allowance() returns the amount of the token they have approved for withdrawal. If that amount is either
      // zero or less than the sourceAmount of the swap, a new call of the ERC-20 approve method is required.
      approvalRequired = firstQuote.approvalNeeded && (allowance.eq(0) || allowance.lt(firstQuote.sourceAmount)) && firstQuote.aggregator !== 'wrappedNative';
      if (!approvalRequired) {
        newQuotes = (0, _lodash.mapValues)(newQuotes, quote => ({
          ...quote,
          approvalNeeded: null
        }));
      } else if (!isPolledRequest && firstQuote.approvalNeeded) {
        const {
          gasLimit: approvalGas
        } = await this._timedoutGasReturn(firstQuote.approvalNeeded, firstQuote.aggregator);
        newQuotes = (0, _lodash.mapValues)(newQuotes, quote => quote.approvalNeeded ? {
          ...quote,
          approvalNeeded: {
            // approvalNeeded is guaranteed to be defined here because of the conditional above, since all quotes are from the same source token
            // the approvalNeeded object will be present for all quotes
            ...quote.approvalNeeded,
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
            // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
            gas: approvalGas || _swaps.DEFAULT_ERC20_APPROVE_GAS
          }
        } : quote);
      }
    }
    let topAggId = null;

    // We can reduce time on the loading screen by only doing this after the
    // loading screen and best quote have rendered.
    if (!approvalRequired && !(fetchParams !== null && fetchParams !== void 0 && fetchParams.balanceError)) {
      newQuotes = await this._getAllQuotesWithGasEstimates(newQuotes);
    }
    if (Object.values(newQuotes).length === 0) {
      this.setSwapsErrorKey(_swaps.QUOTES_NOT_AVAILABLE_ERROR);
    } else {
      const topQuoteAndSavings = await this.getTopQuoteWithCalculatedSavings({
        quotes: newQuotes
      });
      if (Array.isArray(topQuoteAndSavings)) {
        topAggId = topQuoteAndSavings[0];
        newQuotes = topQuoteAndSavings[1];
      }
    }

    // If a newer call has been made, don't update state with old information
    // Prevents timing conflicts between fetches
    if (_classPrivateFieldGet(_indexOfNewestCallInFlight, this) !== indexOfCurrentCall) {
      throw new Error(_swaps.SWAPS_FETCH_ORDER_CONFLICT);
    }
    let {
      selectedAggId
    } = this.state.swapsState;
    if (!selectedAggId || !newQuotes[selectedAggId]) {
      selectedAggId = null;
    }
    this.update(_state => {
      _state.swapsState.quotes = newQuotes;
      _state.swapsState.fetchParams = {
        ...fetchParams,
        metaData: fetchParamsMetaData
      };
      _state.swapsState.quotesLastFetched = quotesLastFetched;
      _state.swapsState.selectedAggId = selectedAggId;
      _state.swapsState.topAggId = topAggId;
    });
    if (quotesPollingLimitEnabled) {
      // We only want to do up to a maximum of three requests from polling if polling limit is enabled.
      // Otherwise we won't increase #pollCount, so polling will run without a limit.
      _classPrivateFieldSet(_pollCount, this, _classPrivateFieldGet(_pollCount, this) + 1);
    }
    if (!quotesPollingLimitEnabled || _classPrivateFieldGet(_pollCount, this) < _swaps3.POLL_COUNT_LIMIT + 1) {
      this._pollForNewQuotes();
    } else {
      this.resetPostFetchState();
      this.setSwapsErrorKey(_swaps.QUOTES_EXPIRED_ERROR);
      return null;
    }
    return [newQuotes, topAggId];
  }
  async getTopQuoteWithCalculatedSavings({
    quotes,
    networkClientId
  }) {
    var _newQuotes$topAggId2;
    let chainId;
    if (networkClientId) {
      const networkClient = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId);
      chainId = networkClient.configuration.chainId;
    } else if (_classPrivateFieldGet(_network, this) === undefined) {
      throw new Error('There is no network set');
    } else {
      chainId = _classPrivateFieldGet(_network, this).chainId;
    }
    const {
      marketData
    } = this._getTokenRatesState();
    const tokenConversionRates = (marketData === null || marketData === void 0 ? void 0 : marketData[chainId]) ?? {};
    const {
      customGasPrice,
      customMaxPriorityFeePerGas
    } = this.state.swapsState;
    const numQuotes = Object.keys(quotes).length;
    if (numQuotes === 0) {
      return {};
    }
    const newQuotes = (0, _lodash.cloneDeep)(quotes);
    const {
      gasFeeEstimates,
      gasEstimateType
    } = await _classPrivateFieldGet(_getEIP1559GasFeeEstimates, this).call(this, {
      networkClientId
    });
    let usedGasPrice = '0x0';
    if (gasEstimateType === _gas.GasEstimateTypes.feeMarket) {
      const {
        high: {
          suggestedMaxPriorityFeePerGas
        },
        estimatedBaseFee
      } = gasFeeEstimates;
      const suggestedMaxPriorityFeePerGasInHexWEI = (0, _conversion.decGWEIToHexWEI)(Number(suggestedMaxPriorityFeePerGas));
      const estimatedBaseFeeNumeric = new _Numeric.Numeric(estimatedBaseFee, 10, _common.EtherDenomination.GWEI).toDenomination(_common.EtherDenomination.WEI);
      usedGasPrice = new _Numeric.Numeric(
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      customMaxPriorityFeePerGas || suggestedMaxPriorityFeePerGasInHexWEI, 16).add(estimatedBaseFeeNumeric).round(6).toString();
    } else if (gasEstimateType === _gas.GasEstimateTypes.legacy) {
      usedGasPrice =
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      customGasPrice || (0, _conversion.decGWEIToHexWEI)(Number(gasFeeEstimates.high));
    } else if (gasEstimateType === _gas.GasEstimateTypes.ethGasPrice) {
      usedGasPrice =
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      customGasPrice || (0, _conversion.decGWEIToHexWEI)(Number(gasFeeEstimates.gasPrice));
    }
    let topAggId = '';
    let overallValueOfBestQuoteForSorting;
    Object.values(newQuotes).forEach(quote => {
      const {
        aggregator,
        approvalNeeded,
        averageGas,
        destinationAmount,
        destinationToken,
        destinationTokenInfo,
        gasEstimateWithRefund,
        sourceAmount,
        sourceToken,
        trade,
        fee: metaMaskFee,
        multiLayerL1TradeFeeTotal
      } = quote;
      if (!trade || !destinationToken) {
        return;
      }
      const tradeGasLimitForCalculation = gasEstimateWithRefund ? new _bignumber.BigNumber(gasEstimateWithRefund, 16) : new _bignumber.BigNumber(averageGas || _swaps3.MAX_GAS_LIMIT, 10);
      const totalGasLimitForCalculation = tradeGasLimitForCalculation
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      .plus((approvalNeeded === null || approvalNeeded === void 0 ? void 0 : approvalNeeded.gas) || '0x0', 16).toString(16);
      let gasTotalInWeiHex = (0, _transactionsControllerUtils.calcGasTotal)(totalGasLimitForCalculation, usedGasPrice);
      if (multiLayerL1TradeFeeTotal !== null) {
        gasTotalInWeiHex = (0, _conversion.sumHexes)(gasTotalInWeiHex || '0x0',
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        multiLayerL1TradeFeeTotal || '0x0');
      }

      // trade.value is a sum of different values depending on the transaction.
      // It always includes any external fees charged by the quote source. In
      // addition, if the source asset is the selected chain's default token, trade.value
      // includes the amount of that token.
      const totalWeiCost = new _Numeric.Numeric(gasTotalInWeiHex, 16, _common.EtherDenomination.WEI).add(new _Numeric.Numeric(trade.value, 16, _common.EtherDenomination.WEI));
      const totalEthCost = totalWeiCost.toDenomination(_common.EtherDenomination.ETH).round(6).value;

      // The total fee is aggregator/exchange fees plus gas fees.
      // If the swap is from the selected chain's default token, subtract
      // the sourceAmount from the total cost. Otherwise, the total fee
      // is simply trade.value plus gas fees.
      const ethFee = (0, _swaps2.isSwapsDefaultTokenAddress)(sourceToken, chainId) ? totalWeiCost.minus(new _Numeric.Numeric(sourceAmount, 10)).toDenomination(_common.EtherDenomination.ETH).round(6).value : totalEthCost;
      const decimalAdjustedDestinationAmount = (0, _transactionsControllerUtils.calcTokenAmount)(destinationAmount ?? '0', destinationTokenInfo.decimals);
      const tokenPercentageOfPreFeeDestAmount = new _bignumber.BigNumber(100, 10).minus(metaMaskFee, 10).div(100);
      const destinationAmountBeforeMetaMaskFee = decimalAdjustedDestinationAmount.div(tokenPercentageOfPreFeeDestAmount);
      const metaMaskFeeInTokens = destinationAmountBeforeMetaMaskFee.minus(decimalAdjustedDestinationAmount);
      const tokenConversionRateKey = Object.keys(tokenConversionRates).find(tokenAddress => (0, _stringUtils.isEqualCaseInsensitive)(tokenAddress, destinationToken));
      const tokenConversionRate = tokenConversionRateKey ? tokenConversionRates[tokenConversionRateKey] : null;

      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      const conversionRateForSorting = (tokenConversionRate === null || tokenConversionRate === void 0 ? void 0 : tokenConversionRate.price) || 1;
      const ethValueOfTokens = decimalAdjustedDestinationAmount.times(conversionRateForSorting.toString(10), 10);
      const conversionRateForCalculations = (0, _swaps2.isSwapsDefaultTokenAddress)(destinationToken, chainId) ? 1 : tokenConversionRate === null || tokenConversionRate === void 0 ? void 0 : tokenConversionRate.price;
      const overallValueOfQuoteForSorting = conversionRateForCalculations ? ethValueOfTokens.minus(ethFee, 10) : ethValueOfTokens;
      quote.ethFee = ethFee.toString(10);
      if (conversionRateForCalculations) {
        quote.ethValueOfTokens = ethValueOfTokens.toString(10);
        quote.overallValueOfQuote = overallValueOfQuoteForSorting.toString(10);
        quote.metaMaskFeeInEth = metaMaskFeeInTokens.times(conversionRateForCalculations.toString(10)).toString(10);
      }
      if (!overallValueOfBestQuoteForSorting || overallValueOfQuoteForSorting.gt(overallValueOfBestQuoteForSorting || 0)) {
        topAggId = aggregator;
        overallValueOfBestQuoteForSorting = overallValueOfQuoteForSorting;
      }
    });
    const tokenConversionRateKey = Object.keys(tokenConversionRates).find(tokenAddress => {
      var _newQuotes$topAggId;
      return (0, _stringUtils.isEqualCaseInsensitive)(tokenAddress, (_newQuotes$topAggId = newQuotes[topAggId]) === null || _newQuotes$topAggId === void 0 ? void 0 : _newQuotes$topAggId.destinationToken);
    });
    const tokenConversionRate = tokenConversionRateKey ? tokenConversionRates[tokenConversionRateKey] : null;
    const isBest = (0, _swaps2.isSwapsDefaultTokenAddress)((_newQuotes$topAggId2 = newQuotes[topAggId]) === null || _newQuotes$topAggId2 === void 0 ? void 0 : _newQuotes$topAggId2.destinationToken, chainId) || Boolean(tokenConversionRate === null || tokenConversionRate === void 0 ? void 0 : tokenConversionRate.price);
    if (isBest) {
      const bestQuote = newQuotes[topAggId];
      const {
        ethFee: medianEthFee,
        metaMaskFeeInEth: medianMetaMaskFee,
        ethValueOfTokens: medianEthValueOfTokens
      } = (0, _swaps4.getMedianEthValueQuote)(Object.values(newQuotes));

      // Performance savings are calculated as:
      //   (ethValueOfTokens for the best trade) - (ethValueOfTokens for the media trade)
      const savingsPerformance = new _bignumber.BigNumber(bestQuote.ethValueOfTokens, 10).minus(medianEthValueOfTokens, 10).toString(10);

      // Fee savings are calculated as:
      //   (fee for the median trade) - (fee for the best trade)
      const fee = new _bignumber.BigNumber(medianEthFee).minus(bestQuote.ethFee, 10).toString(10);
      const metaMaskFee = bestQuote.metaMaskFeeInEth;

      // Total savings are calculated as:
      //   performance savings + fee savings - metamask fee
      const total = new _bignumber.BigNumber(savingsPerformance).plus(fee).minus(metaMaskFee).toString(10);
      const savings = {
        performance: savingsPerformance,
        fee,
        total,
        metaMaskFee,
        medianMetaMaskFee
      };
      newQuotes[topAggId].isBestQuote = true;
      newQuotes[topAggId].savings = savings;
    }
    return [topAggId, newQuotes];
  }
  resetPostFetchState() {
    this.update(_state => {
      _state.swapsState = {
        ...(0, _swaps3.getDefaultSwapsControllerState)().swapsState,
        tokens: _state.swapsState.tokens,
        fetchParams: _state.swapsState.fetchParams,
        swapsFeatureIsLive: _state.swapsState.swapsFeatureIsLive,
        swapsQuoteRefreshTime: _state.swapsState.swapsQuoteRefreshTime,
        swapsQuotePrefetchingRefreshTime: _state.swapsState.swapsQuotePrefetchingRefreshTime,
        swapsFeatureFlags: _state.swapsState.swapsFeatureFlags
      };
    });
    if (_classPrivateFieldGet(_pollingTimeout, this)) {
      clearTimeout(_classPrivateFieldGet(_pollingTimeout, this));
    }
  }
  resetSwapsState() {
    this.update(_state => {
      _state.swapsState = {
        ...(0, _swaps3.getDefaultSwapsControllerState)().swapsState,
        swapsQuoteRefreshTime: _state.swapsState.swapsQuoteRefreshTime,
        swapsQuotePrefetchingRefreshTime: _state.swapsState.swapsQuotePrefetchingRefreshTime,
        swapsFeatureFlags: _state.swapsState.swapsFeatureFlags
      };
    });
    if (_classPrivateFieldGet(_pollingTimeout, this)) {
      clearTimeout(_classPrivateFieldGet(_pollingTimeout, this));
    }
  }
  safeRefetchQuotes() {
    if (!_classPrivateFieldGet(_pollingTimeout, this) && this.state.swapsState.fetchParams) {
      this.fetchAndSetQuotes(this.state.swapsState.fetchParams, {
        ...this.state.swapsState.fetchParams.metaData
      });
    }
  }
  setApproveTxId(approveTxId) {
    this.update(_state => {
      _state.swapsState.approveTxId = approveTxId;
    });
  }
  setBackgroundSwapRouteState(routeState) {
    this.update(_state => {
      _state.swapsState.routeState = routeState;
    });
  }
  setCustomApproveTxData(customApproveTxData) {
    this.update(_state => {
      _state.swapsState.customApproveTxData = customApproveTxData;
    });
  }
  async setInitialGasEstimate(initialAggId) {
    const quoteToUpdate = {
      ...this.state.swapsState.quotes[initialAggId]
    };
    const {
      gasLimit: newGasEstimate,
      simulationFails
    } = quoteToUpdate.trade ? await this._timedoutGasReturn(quoteToUpdate.trade, quoteToUpdate.aggregator) : {
      gasLimit: null,
      simulationFails: true
    };
    if (newGasEstimate && !simulationFails) {
      const gasEstimateWithRefund = (0, _swaps4.calculateGasEstimateWithRefund)(quoteToUpdate.maxGas, quoteToUpdate.estimatedRefund, newGasEstimate);
      quoteToUpdate.gasEstimate = newGasEstimate;
      quoteToUpdate.gasEstimateWithRefund = gasEstimateWithRefund;
    }
    this.update(_state => {
      _state.swapsState.quotes = {
        ..._state.swapsState.quotes,
        [initialAggId]: quoteToUpdate
      };
    });
  }
  setSelectedQuoteAggId(selectedAggId) {
    this.update(_state => {
      _state.swapsState.selectedAggId = selectedAggId;
    });
  }
  setSwapsFeatureFlags(swapsFeatureFlags) {
    this.update(_state => {
      _state.swapsState.swapsFeatureFlags = swapsFeatureFlags;
    });
  }
  setSwapsErrorKey(errorKey) {
    this.update(_state => {
      _state.swapsState.errorKey = errorKey;
    });
  }
  setSwapsLiveness(swapsLiveness) {
    const {
      swapsFeatureIsLive
    } = swapsLiveness;
    this.update(_state => {
      _state.swapsState.swapsFeatureIsLive = swapsFeatureIsLive;
    });
  }
  setSwapsQuotesPollingLimitEnabled(quotesPollingLimitEnabled) {
    this.update(_state => {
      _state.swapsState.quotesPollingLimitEnabled = quotesPollingLimitEnabled;
    });
  }
  setSwapsTokens(tokens) {
    this.update(_state => {
      _state.swapsState.tokens = tokens;
    });
  }
  setSwapsTxGasLimit(customMaxGas) {
    this.update(_state => {
      _state.swapsState.customMaxGas = customMaxGas;
    });
  }
  setSwapsTxGasPrice(customGasPrice) {
    this.update(_state => {
      _state.swapsState.customGasPrice = customGasPrice;
    });
  }
  setSwapsTxMaxFeePerGas(customMaxFeePerGas) {
    this.update(_state => {
      _state.swapsState.customMaxFeePerGas = customMaxFeePerGas;
    });
  }
  setSwapsTxMaxFeePriorityPerGas(customMaxPriorityFeePerGas) {
    this.update(_state => {
      _state.swapsState.customMaxPriorityFeePerGas = customMaxPriorityFeePerGas;
    });
  }
  setSwapsUserFeeLevel(swapsUserFeeLevel) {
    this.update(_state => {
      _state.swapsState.swapsUserFeeLevel = swapsUserFeeLevel;
    });
  }
  setTradeTxId(tradeTxId) {
    this.update(_state => {
      _state.swapsState.tradeTxId = tradeTxId;
    });
  }

  /**
   * Once quotes are fetched, we poll for new ones to keep the quotes up to date.
   * Market and aggregator contract conditions can change fast enough that quotes
   * will no longer be available after 1 or 2 minutes. When `fetchAndSetQuotes` is
   * first called, it receives fetch parameters that are stored in state. These stored
   * parameters are used on subsequent calls made during polling.
   *
   * Note: We stop polling after 3 requests, until new quotes are explicitly asked for.
   * The logic that enforces that maximum is in the body of `fetchAndSetQuotes`.
   */
  stopPollingForQuotes() {
    if (_classPrivateFieldGet(_pollingTimeout, this)) {
      clearTimeout(_classPrivateFieldGet(_pollingTimeout, this));
    }
  }
  // Private Methods
  async _fetchSwapsNetworkConfig(network) {
    const response = await (0, _fetchWithCache.default)({
      url: (0, _swapsUtils.getBaseApi)('network', network.chainId),
      fetchOptions: {
        method: 'GET'
      },
      cacheOptions: {
        cacheRefreshTime: 600000
      },
      functionName: '_fetchSwapsNetworkConfig'
    });
    const {
      refreshRates,
      parameters = {}
    } = response || {};
    if (!refreshRates || typeof refreshRates.quotes !== 'number' || typeof refreshRates.quotesPrefetching !== 'number') {
      throw new Error(`MetaMask - invalid response for refreshRates: ${response}`);
    }
    // We presently use milliseconds in the UI.
    return {
      quotes: refreshRates.quotes * 1000,
      quotesPrefetching: refreshRates.quotesPrefetching * 1000,
      stxGetTransactions: refreshRates.stxGetTransactions * 1000,
      stxBatchStatus: refreshRates.stxBatchStatus * 1000,
      stxStatusDeadline: refreshRates.stxStatusDeadline,
      stxMaxFeeMultiplier: parameters.stxMaxFeeMultiplier
    };
  }
  async _getAllQuotesWithGasEstimates(quotes) {
    const quoteGasData = await Promise.all(Object.values(quotes).map(async quote => {
      if (!quote.trade) {
        return {
          gasLimit: null,
          simulationFails: true,
          aggId: quote.aggregator
        };
      }
      const {
        gasLimit,
        simulationFails
      } = await this._timedoutGasReturn(quote.trade, quote.aggregator);
      return {
        gasLimit,
        simulationFails,
        aggId: quote.aggregator
      };
    }));
    const newQuotes = {};
    quoteGasData.forEach(({
      gasLimit,
      simulationFails,
      aggId
    }) => {
      if (gasLimit && !simulationFails) {
        const gasEstimateWithRefund = (0, _swaps4.calculateGasEstimateWithRefund)(quotes[aggId].maxGas, quotes[aggId].estimatedRefund, gasLimit);

        // add to newQuotes object

        newQuotes[aggId] = {
          ...quotes[aggId],
          gasEstimate: gasLimit,
          gasEstimateWithRefund
        };
      } else if (quotes[aggId].approvalNeeded) {
        // If gas estimation fails, but an ERC-20 approve is needed, then we do not add any estimate property to the quote object
        // Such quotes will rely on the maxGas and averageGas properties from the api
        newQuotes[aggId] = quotes[aggId];
      }
      // If gas estimation fails and no approval is needed, then we filter that quote out, so that it is not shown to the user
    });
    return newQuotes;
  }
  async _getERC20Allowance(contractAddress, walletAddress, network) {
    const contract = new _contracts.Contract(contractAddress, _humanStandardTokenAbi.default, network.ethersProvider);
    return await contract.allowance(walletAddress, _swaps.SWAPS_CHAINID_CONTRACT_ADDRESS_MAP[network.chainId]);
  }
  _getTokenRatesState() {
    const {
      marketData
    } = this.messagingSystem.call('TokenRatesController:getState');
    return {
      marketData
    };
  }
  _pollForNewQuotes() {
    const {
      swapsQuoteRefreshTime,
      swapsQuotePrefetchingRefreshTime,
      quotesPollingLimitEnabled
    } = this.state.swapsState;
    // swapsQuoteRefreshTime is used on the View Quote page, swapsQuotePrefetchingRefreshTime is used on the Build Quote page.
    const quotesRefreshRateInMs = quotesPollingLimitEnabled ? swapsQuoteRefreshTime : swapsQuotePrefetchingRefreshTime;
    _classPrivateFieldSet(_pollingTimeout, this, setTimeout(() => {
      var _this$state$swapsStat;
      this.fetchAndSetQuotes(this.state.swapsState.fetchParams, (_this$state$swapsStat = this.state.swapsState.fetchParams) === null || _this$state$swapsStat === void 0 ? void 0 : _this$state$swapsStat.metaData, true);
    }, quotesRefreshRateInMs));
  }
  _setSaveFetchedQuotes(status) {
    this.update(_state => {
      _state.swapsState.saveFetchedQuotes = status;
    });
  }

  // Sets the network config from the MetaSwap API.
  async _setSwapsNetworkConfig(network) {
    let swapsNetworkConfig = null;
    try {
      swapsNetworkConfig = await this._fetchSwapsNetworkConfig(network);
    } catch (e) {
      console.error('Request for Swaps network config failed: ', e);
    }
    this.update(_state => {
      var _swapsNetworkConfig, _swapsNetworkConfig2, _swapsNetworkConfig3, _swapsNetworkConfig4, _swapsNetworkConfig5, _swapsNetworkConfig6;
      _state.swapsState.swapsQuoteRefreshTime =
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      ((_swapsNetworkConfig = swapsNetworkConfig) === null || _swapsNetworkConfig === void 0 ? void 0 : _swapsNetworkConfig.quotes) || _swaps3.FALLBACK_QUOTE_REFRESH_TIME;
      _state.swapsState.swapsQuotePrefetchingRefreshTime =
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      ((_swapsNetworkConfig2 = swapsNetworkConfig) === null || _swapsNetworkConfig2 === void 0 ? void 0 : _swapsNetworkConfig2.quotesPrefetching) || _swaps3.FALLBACK_QUOTE_REFRESH_TIME;
      _state.swapsState.swapsStxGetTransactionsRefreshTime =
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      ((_swapsNetworkConfig3 = swapsNetworkConfig) === null || _swapsNetworkConfig3 === void 0 ? void 0 : _swapsNetworkConfig3.stxGetTransactions) || _smartTransactions.FALLBACK_SMART_TRANSACTIONS_REFRESH_TIME;
      _state.swapsState.swapsStxBatchStatusRefreshTime =
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      ((_swapsNetworkConfig4 = swapsNetworkConfig) === null || _swapsNetworkConfig4 === void 0 ? void 0 : _swapsNetworkConfig4.stxBatchStatus) || _smartTransactions.FALLBACK_SMART_TRANSACTIONS_REFRESH_TIME;
      _state.swapsState.swapsStxMaxFeeMultiplier =
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      ((_swapsNetworkConfig5 = swapsNetworkConfig) === null || _swapsNetworkConfig5 === void 0 ? void 0 : _swapsNetworkConfig5.stxMaxFeeMultiplier) || _smartTransactions.FALLBACK_SMART_TRANSACTIONS_MAX_FEE_MULTIPLIER;
      _state.swapsState.swapsStxStatusDeadline =
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
      // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
      ((_swapsNetworkConfig6 = swapsNetworkConfig) === null || _swapsNetworkConfig6 === void 0 ? void 0 : _swapsNetworkConfig6.stxStatusDeadline) || _smartTransactions.FALLBACK_SMART_TRANSACTIONS_DEADLINE;
    });
  }
  _timedoutGasReturn(tradeTxParams, aggregator = '') {
    return new Promise(resolve => {
      let gasTimedOut = false;
      const gasTimeout = setTimeout(() => {
        gasTimedOut = true;
        this.trackMetaMetricsEvent({
          event: _metametrics.MetaMetricsEventName.QuoteError,
          category: _metametrics.MetaMetricsEventCategory.Swaps,
          properties: {
            // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
            // eslint-disable-next-line @typescript-eslint/naming-convention
            error_type: _metametrics.MetaMetricsEventErrorType.GasTimeout,
            aggregator
          }
        });
        resolve({
          gasLimit: null,
          simulationFails: true
        });
      }, _time.SECOND * 5);

      // Remove gas from params that will be passed to the `estimateGas` call
      // Including it can cause the estimate to fail if the actual gas needed
      // exceeds the passed gas
      const tradeTxParamsForGasEstimate = {
        data: tradeTxParams.data,
        from: tradeTxParams.from,
        to: tradeTxParams.to,
        value: tradeTxParams.value
      };
      this.getBufferedGasLimit({
        txParams: tradeTxParamsForGasEstimate
      }, 1).then(({
        gasLimit,
        simulationFails
      }) => {
        if (!gasTimedOut) {
          clearTimeout(gasTimeout);
          resolve({
            gasLimit,
            simulationFails
          });
        }
      }).catch(e => {
        (0, _sentry.captureException)(e, {
          extra: {
            aggregator
          }
        });
        if (!gasTimedOut) {
          clearTimeout(gasTimeout);
          resolve({
            gasLimit: null,
            simulationFails: true
          });
        }
      });
    });
  }
}
exports.default = SwapsController;
function _setNetwork(networkClientId) {
  const networkClient = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId);
  const {
    chainId
  } = networkClient.configuration;
  // Web3Provider (via JsonRpcProvider) creates two extra network requests, so
  // we cache the object so that we can reuse it for subsequent contract
  // interactions for the same network
  const ethersProvider = new _providers.Web3Provider(networkClient.provider);
  const network = {
    client: networkClient,
    clientId: networkClientId,
    chainId,
    ethersProvider
  };
  _classPrivateFieldSet(_network, this, network);
  return network;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controllers\\swaps\\index.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\swaps\\swaps.constants.ts", {"../../../../shared/constants/smartTransactions":"D:\\code\\v\\metamask-extension\\shared\\constants\\smartTransactions.ts","../../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontrollers%5Cswaps%5Cswaps.constants.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.controllerName = exports.POLL_COUNT_LIMIT = exports.MAX_GAS_LIMIT = exports.FALLBACK_QUOTE_REFRESH_TIME = void 0;
exports.getDefaultSwapsControllerState = getDefaultSwapsControllerState;
var _smartTransactions = require("../../../../shared/constants/smartTransactions");
var _time = require("../../../../shared/constants/time");
const controllerName = exports.controllerName = 'SwapsController';

// The MAX_GAS_LIMIT is a number that is higher than the maximum gas costs we have observed on any aggregator
const MAX_GAS_LIMIT = exports.MAX_GAS_LIMIT = 2500000;

// To ensure that our serves are not spammed if MetaMask is left idle, we limit the number of fetches for quotes that are made on timed intervals.
// 3 seems to be an appropriate balance of giving users the time they need when MetaMask is not left idle, and turning polling off when it is.
const POLL_COUNT_LIMIT = exports.POLL_COUNT_LIMIT = 3;

// If for any reason the MetaSwap API fails to provide a refresh time,
// provide a reasonable fallback to avoid further errors
const FALLBACK_QUOTE_REFRESH_TIME = exports.FALLBACK_QUOTE_REFRESH_TIME = _time.MINUTE;
function getDefaultSwapsControllerState() {
  return {
    swapsState: {
      quotes: {},
      quotesPollingLimitEnabled: false,
      fetchParams: null,
      tokens: null,
      tradeTxId: null,
      approveTxId: null,
      quotesLastFetched: null,
      customMaxGas: '',
      customGasPrice: null,
      customMaxFeePerGas: null,
      customMaxPriorityFeePerGas: null,
      swapsUserFeeLevel: '',
      selectedAggId: null,
      customApproveTxData: '',
      errorKey: '',
      topAggId: null,
      routeState: '',
      swapsFeatureIsLive: true,
      saveFetchedQuotes: false,
      swapsQuoteRefreshTime: FALLBACK_QUOTE_REFRESH_TIME,
      swapsQuotePrefetchingRefreshTime: FALLBACK_QUOTE_REFRESH_TIME,
      swapsStxBatchStatusRefreshTime: _smartTransactions.FALLBACK_SMART_TRANSACTIONS_REFRESH_TIME,
      swapsStxStatusDeadline: _smartTransactions.FALLBACK_SMART_TRANSACTIONS_DEADLINE,
      swapsStxGetTransactionsRefreshTime: _smartTransactions.FALLBACK_SMART_TRANSACTIONS_REFRESH_TIME,
      swapsStxMaxFeeMultiplier: _smartTransactions.FALLBACK_SMART_TRANSACTIONS_MAX_FEE_MULTIPLIER,
      swapsFeatureFlags: {}
    }
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controllers\\swaps\\swaps.constants.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\swaps\\swaps.utils.ts", {"./swaps.constants":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\swaps\\swaps.constants.ts","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Ccontrollers%5Cswaps%5Cswaps.utils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateGasEstimateWithRefund = calculateGasEstimateWithRefund;
exports.getMedianEthValueQuote = getMedianEthValueQuote;
exports.meansOfQuotesFeesAndValue = meansOfQuotesFeesAndValue;
var _bignumber = require("bignumber.js");
var _swaps = require("./swaps.constants");
/**
 * Calculates the median overallValueOfQuote of a sample of quotes.
 *
 * @param _quotes - A sample of quote objects with overallValueOfQuote, ethFee, metaMaskFeeInEth, and ethValueOfTokens properties
 * @returns An object with the ethValueOfTokens, ethFee, and metaMaskFeeInEth of the quote with the median overallValueOfQuote
 */
function getMedianEthValueQuote(_quotes) {
  if (!Array.isArray(_quotes) || _quotes.length === 0) {
    throw new Error('Expected non-empty array param.');
  }
  const quotes = [..._quotes];
  quotes.sort((quoteA, quoteB) => {
    const overallValueOfQuoteA = new _bignumber.BigNumber(quoteA.overallValueOfQuote, 10);
    const overallValueOfQuoteB = new _bignumber.BigNumber(quoteB.overallValueOfQuote, 10);
    if (overallValueOfQuoteA.equals(overallValueOfQuoteB)) {
      return 0;
    }
    return overallValueOfQuoteA.lessThan(overallValueOfQuoteB) ? -1 : 1;
  });
  if (quotes.length % 2 === 1) {
    // return middle values
    const medianOverallValue = quotes[(quotes.length - 1) / 2].overallValueOfQuote;
    const quotesMatchingMedianQuoteValue = quotes.filter(quote => medianOverallValue === quote.overallValueOfQuote);
    return meansOfQuotesFeesAndValue(quotesMatchingMedianQuoteValue);
  }

  // return mean of middle two values
  const upperIndex = quotes.length / 2;
  const lowerIndex = upperIndex - 1;
  const overallValueAtUpperIndex = quotes[upperIndex].overallValueOfQuote;
  const overallValueAtLowerIndex = quotes[lowerIndex].overallValueOfQuote;
  const quotesMatchingUpperIndexValue = quotes.filter(quote => overallValueAtUpperIndex === quote.overallValueOfQuote);
  const quotesMatchingLowerIndexValue = quotes.filter(quote => overallValueAtLowerIndex === quote.overallValueOfQuote);
  const feesAndValueAtUpperIndex = meansOfQuotesFeesAndValue(quotesMatchingUpperIndexValue);
  const feesAndValueAtLowerIndex = meansOfQuotesFeesAndValue(quotesMatchingLowerIndexValue);
  return {
    ethFee: new _bignumber.BigNumber(feesAndValueAtUpperIndex.ethFee, 10).plus(feesAndValueAtLowerIndex.ethFee, 10).dividedBy(2).toString(10),
    metaMaskFeeInEth: new _bignumber.BigNumber(feesAndValueAtUpperIndex.metaMaskFeeInEth, 10).plus(feesAndValueAtLowerIndex.metaMaskFeeInEth, 10).dividedBy(2).toString(10),
    ethValueOfTokens: new _bignumber.BigNumber(feesAndValueAtUpperIndex.ethValueOfTokens, 10).plus(feesAndValueAtLowerIndex.ethValueOfTokens, 10).dividedBy(2).toString(10)
  };
}

/**
 * Calculates the arithmetic mean for each of three properties - ethFee, metaMaskFeeInEth and ethValueOfTokens - across
 * an array of objects containing those properties.
 *
 * @param quotes - A sample of quote objects with overallValueOfQuote, ethFee, metaMaskFeeInEth and
 * ethValueOfTokens properties
 * @returns An object with the arithmetic mean each of the ethFee, metaMaskFeeInEth and ethValueOfTokens of
 * the passed quote objects
 */
function meansOfQuotesFeesAndValue(quotes) {
  const feeAndValueSumsAsBigNumbers = quotes.reduce((feeAndValueSums, quote) => ({
    ethFee: feeAndValueSums.ethFee.plus(quote.ethFee, 10),
    metaMaskFeeInEth: feeAndValueSums.metaMaskFeeInEth.plus(quote.metaMaskFeeInEth, 10),
    ethValueOfTokens: feeAndValueSums.ethValueOfTokens.plus(quote.ethValueOfTokens, 10)
  }), {
    ethFee: new _bignumber.BigNumber(0, 10),
    metaMaskFeeInEth: new _bignumber.BigNumber(0, 10),
    ethValueOfTokens: new _bignumber.BigNumber(0, 10)
  });
  return {
    ethFee: feeAndValueSumsAsBigNumbers.ethFee.div(quotes.length, 10).toString(10),
    metaMaskFeeInEth: feeAndValueSumsAsBigNumbers.metaMaskFeeInEth.div(quotes.length, 10).toString(10),
    ethValueOfTokens: feeAndValueSumsAsBigNumbers.ethValueOfTokens.div(quotes.length, 10).toString(10)
  };
}

/**
 * Calculates the gas estimate after subtracting a refund from the maximum gas limit.
 *
 * @param maxGas - The maximum gas limit, defaulting to MAX_GAS_LIMIT.
 * @param estimatedRefund - The estimated refund to subtract from the maximum gas limit, represented as a string.
 * @param estimatedGas - The estimated gas required for the transaction, represented as a string.
 * @returns The gas estimate with refund applied, represented as a hexadecimal string. If the subtraction
 * results in a negative value or is less than the estimated gas, returns the estimated gas.
 */
function calculateGasEstimateWithRefund(maxGas = _swaps.MAX_GAS_LIMIT, estimatedRefund = '0', estimatedGas = '0') {
  const maxGasMinusRefund = new _bignumber.BigNumber(maxGas, 10).minus(estimatedRefund, 10);
  const isMaxGasMinusRefundNegative = maxGasMinusRefund.lt(0);
  const gasEstimateWithRefund = !isMaxGasMinusRefundNegative && maxGasMinusRefund.lt(estimatedGas, 16) ? `0x${maxGasMinusRefund.toString(16)}` : estimatedGas;
  return gasEstimateWithRefund;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\controllers\\swaps\\swaps.utils.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\detect-multiple-instances.js", {"../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","./lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","webextension-polyfill":"D:\\code\\v\\metamask-extension\\node_modules\\webextension-polyfill\\dist\\browser-polyfill.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cdetect-multiple-instances.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onMessageReceived = exports.checkForMultipleVersionsRunning = void 0;
var _webextensionPolyfill = _interopRequireDefault(require("webextension-polyfill"));
var _app = require("../../shared/constants/app");
var _util = require("./lib/util");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Sets up two-way communication between the
 * mainline version of extension and Flask build
 * in order to detect & warn if there are two different
 * versions running simultaneously.
 */

const MESSAGE_TEXT = 'isRunning';
const showWarning = () => console.warn('Warning! You have multiple instances of MetaMask running!');

/**
 * Handles the ping message sent from other extension.
 * Displays console warning if it's active.
 *
 * @param message - The message received from the other extension
 */
const onMessageReceived = message => {
  if (message === MESSAGE_TEXT) {
    showWarning();
  }
};

/**
 * Sends the ping message sent to other extensions to detect whether it's active or not.
 */
exports.onMessageReceived = onMessageReceived;
const checkForMultipleVersionsRunning = async () => {
  if ((0, _util.getPlatform)() !== _app.PLATFORM_CHROME && (0, _util.getPlatform)() !== _app.PLATFORM_FIREFOX) {
    return;
  }
  const buildIds = (0, _util.getPlatform)() === _app.PLATFORM_CHROME ? _app.CHROME_BUILD_IDS : _app.FIREFOX_BUILD_IDS;
  const thisBuild = _webextensionPolyfill.default.runtime.id;
  for (const id of buildIds) {
    if (id !== thisBuild) {
      try {
        await _webextensionPolyfill.default.runtime.sendMessage(id, MESSAGE_TEXT);
      } catch (error) {
        // Should do nothing if receiving end was not reached (no other instances running)
      }
    }
  }
};
exports.checkForMultipleVersionsRunning = checkForMultipleVersionsRunning;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\detect-multiple-instances.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\first-time-state.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cfirst-time-state.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
/**
 * @typedef {object} FirstTimeState
 * @property {object} config Initial configuration parameters
 */

/**
 * @type {FirstTimeState}
 */
const initialState = {
  config: {}
};
var _default = exports.default = initialState;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\first-time-state.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\fixtures\\generate-wallet-state.js", {"../../../shared/notifications":"D:\\code\\v\\metamask-extension\\shared\\notifications\\index.ts","../../../test/e2e/constants":"D:\\code\\v\\metamask-extension\\test\\e2e\\constants.ts","../../../test/e2e/default-fixture":"D:\\code\\v\\metamask-extension\\test\\e2e\\default-fixture.js","../../../test/e2e/fixture-builder":"D:\\code\\v\\metamask-extension\\test\\e2e\\fixture-builder.js","../lib/encryptor-factory":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\encryptor-factory.ts","./with-address-book":"D:\\code\\v\\metamask-extension\\app\\scripts\\fixtures\\with-address-book.js","./with-app-state":"D:\\code\\v\\metamask-extension\\app\\scripts\\fixtures\\with-app-state.js","./with-confirmed-transactions":"D:\\code\\v\\metamask-extension\\app\\scripts\\fixtures\\with-confirmed-transactions.js","./with-erc20-tokens":"D:\\code\\v\\metamask-extension\\app\\scripts\\fixtures\\with-erc20-tokens.js","./with-networks":"D:\\code\\v\\metamask-extension\\app\\scripts\\fixtures\\with-networks.js","./with-preferences":"D:\\code\\v\\metamask-extension\\app\\scripts\\fixtures\\with-preferences.js","./with-unread-notifications":"D:\\code\\v\\metamask-extension\\app\\scripts\\fixtures\\with-unread-notifications.js","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs","@metamask/scure-bip39/dist/wordlists/english":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\scure-bip39\\dist\\wordlists\\english.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cfixtures%5Cgenerate-wallet-state.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateWalletState = generateWalletState;
var _baseController = require("@metamask/base-controller");
var _keyringController = require("@metamask/keyring-controller");
var _english = require("@metamask/scure-bip39/dist/wordlists/english");
var _notifications = require("../../../shared/notifications");
var _constants = require("../../../test/e2e/constants");
var _defaultFixture = require("../../../test/e2e/default-fixture");
var _fixtureBuilder = _interopRequireDefault(require("../../../test/e2e/fixture-builder"));
var _encryptorFactory = require("../lib/encryptor-factory");
var _withAddressBook = require("./with-address-book");
var _withAppState = require("./with-app-state");
var _withConfirmedTransactions = require("./with-confirmed-transactions");
var _withErc20Tokens = require("./with-erc20-tokens");
var _withNetworks = require("./with-networks");
var _withPreferences = require("./with-preferences");
var _withUnreadNotifications = require("./with-unread-notifications");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
let FIXTURES_CONFIG = {};

/**
 * Generates the wallet state based on the fixtures set in the environment variable.
 *
 * @param {object} withState - The fixture configuration state
 * @param {boolean} fromTest - Whether this is being called from a test
 * @returns {Promise<FixtureBuilder>} The generated FixtureBuilder object
 */
async function generateWalletState(withState, fromTest) {
  const fixtureBuilder = new _fixtureBuilder.default({
    inputChainId: '0xaa36a7'
  });
  if (withState) {
    FIXTURES_CONFIG = withState;
  }
  const {
    vault,
    accounts
  } = await generateVaultAndAccount(null || _defaultFixture.E2E_SRP, fromTest ? _constants.WALLET_PASSWORD : null);
  fixtureBuilder.withAccountsController(generateAccountsControllerState(accounts)).withAddressBookController(generateAddressBookControllerState()).withAnnouncementController(generateAnnouncementControllerState()).withAppStateController(_withAppState.FIXTURES_APP_STATE).withKeyringController(generateKeyringControllerState(vault)).withNetworkController(generateNetworkControllerState()).withNotificationServicesController(generateNotificationControllerState(accounts[0])).withPreferencesController(generatePreferencesControllerState(accounts)).withTokensController(generateTokensControllerState(accounts[0])).withTransactionController(generateTransactionControllerState(accounts[0]));
  return fixtureBuilder;
}

/**
 * Generates a new vault and account based on the provided seed phrase and password.
 *
 * @param {string} encodedSeedPhrase - The encoded seed phrase.
 * @param {string} password - The password for the vault.
 * @returns {Promise<{vault: object, accounts: Array<string>}>} The generated vault and account.
 */
async function generateVaultAndAccount(encodedSeedPhrase, password) {
  const messenger = new _baseController.Messenger();
  const keyringControllerMessenger = messenger.getRestricted({
    name: 'KeyringController'
  });
  const krCtrl = new _keyringController.KeyringController({
    encryptor: (0, _encryptorFactory.encryptorFactory)(600_000),
    messenger: keyringControllerMessenger
  });
  const seedPhraseAsBuffer = Buffer.from(encodedSeedPhrase);
  const _convertMnemonicToWordlistIndices = mnemonic => {
    const indices = mnemonic.toString().split(' ').map(word => _english.wordlist.indexOf(word));
    return new Uint8Array(new Uint16Array(indices).buffer);
  };
  await krCtrl.createNewVaultAndRestore(password, _convertMnemonicToWordlistIndices(seedPhraseAsBuffer));
  const accounts = [];
  const account = krCtrl.state.keyrings[0].accounts[0];
  accounts.push(account);
  for (let i = 1; i < FIXTURES_CONFIG.withAccounts; i++) {
    const newAccount = await krCtrl.addNewAccount(i);
    accounts.push(newAccount);
  }
  const {
    vault
  } = krCtrl.state;
  return {
    vault,
    accounts
  };
}

/**
 * Generates the state for the KeyringController.
 *
 * @param {object} vault - The vault object.
 * @returns {object} The generated KeyringController state.
 */
function generateKeyringControllerState(vault) {
  console.log('Generating KeyringController state');
  return {
    ...(0, _defaultFixture.defaultFixture)().data.KeyringController,
    vault
  };
}

/**
 * Generates the state for the AccountsController.
 *
 * @param {Array<string>} accounts - The account addresses.
 * @returns {object} The generated AccountsController state.
 */
function generateAccountsControllerState(accounts) {
  console.log('Generating AccountsController state');
  const internalAccounts = {
    selectedAccount: 'account-id',
    accounts: {}
  };
  accounts.forEach((account, index) => {
    internalAccounts.accounts[`acount-id-${index}`] = {
      selectedAccount: 'account-id',
      id: 'account-id',
      address: account,
      metadata: {
        name: `Account ${index + 1}`,
        lastSelected: 1665507600000,
        keyring: {
          type: 'HD Key Tree'
        }
      },
      options: {},
      methods: ['personal_sign', 'eth_signTransaction', 'eth_signTypedData_v1', 'eth_signTypedData_v3', 'eth_signTypedData_v4'],
      type: 'eip155:eoa'
    };
  });
  return {
    internalAccounts
  };
}

/**
 * Generates the state for the AddressBookController.
 *
 * @returns {object} The generated AddressBookController state.
 */
function generateAddressBookControllerState() {
  console.log('Generating AddressBookController state');
  const numEntries = FIXTURES_CONFIG.withContacts;
  if (numEntries > 0) {
    return (0, _withAddressBook.withAddressBook)(numEntries);
  }
  return {};
}

/**
 * Generates the state for the AnnouncementController.
 * All the what's new modals are dismissed for convenience.
 *
 * @returns {object} The generated AnnouncementController state.
 */
function generateAnnouncementControllerState() {
  console.log('Generating AnnouncementController state');
  const allAnnouncementsAlreadyShown = Object.keys(_notifications.UI_NOTIFICATIONS).reduce((acc, val) => {
    acc[val] = {
      ..._notifications.UI_NOTIFICATIONS[val],
      isShown: true
    };
    return acc;
  }, {});
  return allAnnouncementsAlreadyShown;
}

/**
 * Generates the state for the NotificationController.
 *
 * @param {string} account - The account address to add the notifications to.
 * @returns {object} The generated NotificationController state.
 */
function generateNotificationControllerState(account) {
  console.log('Generating NotificationController state');
  let notifications = {};
  if (FIXTURES_CONFIG.withUnreadNotifications > 0) {
    notifications = (0, _withUnreadNotifications.withUnreadNotifications)(account, FIXTURES_CONFIG.withUnreadNotifications);
  }
  return notifications;
}

/**
 * Generates the state for the NetworkController.
 * Sepolia is always pre-loaded and set as the active provider.
 *
 * @returns {object} The generated NetworkController state.
 */
function generateNetworkControllerState() {
  console.log('Generating NetworkController state');
  const defaultNetworkState = {
    ...(0, _defaultFixture.defaultFixture)().data.NetworkController,
    networkConfigurations: {},
    networksMetadata: {
      sepolia: {
        EIPS: {
          1559: true
        },
        status: 'available'
      }
    },
    selectedNetworkClientId: 'sepolia'
  };
  if (FIXTURES_CONFIG.withNetworks) {
    return {
      ...defaultNetworkState,
      ..._withNetworks.FIXTURES_NETWORKS
    };
  }
  return defaultNetworkState;
}

/**
 * Generates the state for the PreferencesController.
 *
 * @param {Array<string>} accounts - The account addresses.
 * @returns {object} The generated PreferencesController state.
 */
function generatePreferencesControllerState(accounts) {
  console.log('Generating PreferencesController state');
  let preferencesControllerState = {};
  if (FIXTURES_CONFIG.withPreferences) {
    preferencesControllerState = _withPreferences.FIXTURES_PREFERENCES;
  }

  // Add account identities
  preferencesControllerState.identities = Object.assign(...accounts.map((address, index) => ({
    [address]: {
      address,
      lastSelected: 1725363500048,
      name: `Account ${index + 1}`
    }
  })));
  preferencesControllerState.lostIdentities = Object.assign(...accounts.map((address, index) => ({
    [address]: {
      address,
      lastSelected: 1725363500048,
      name: `Account ${index + 1}`
    }
  })));
  return preferencesControllerState;
}

/**
 * Generates the state for the TokensController.
 *
 * @param {string} account - The account address to add the transactions to.
 * @returns {object} The generated TokensController state.
 */
function generateTokensControllerState(account) {
  console.log('Generating TokensController state');
  const tokens = _withErc20Tokens.FIXTURES_ERC20_TOKENS;
  if (FIXTURES_CONFIG.withErc20Tokens) {
    // Update `myAccount` key for the account address
    for (const network of Object.values(tokens.allTokens)) {
      network[account] = network.myAccount;
      delete network.myAccount;
    }
    return tokens;
  }
  return {};
}

/**
 * Generates the state for the TransactionController.
 *
 * @param {string} account - The account address to add the transactions to.
 * @returns {object} The generated TransactionController state.
 */
function generateTransactionControllerState(account) {
  console.log('Generating TransactionController state');
  let transactions = {};
  if (FIXTURES_CONFIG.withConfirmedTransactions > 0) {
    transactions = (0, _withConfirmedTransactions.withConfirmedTransactions)(account, FIXTURES_CONFIG.withConfirmedTransactions);
  }
  return transactions;
}

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\fixtures\\generate-wallet-state.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\fixtures\\with-address-book.js", {"../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cfixtures%5Cwith-address-book.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withAddressBook = void 0;
var _network = require("../../../shared/constants/network");
/**
 * Generates a random Ethereum address.
 *
 * @returns {string} A randomly generated Ethereum address.
 */
const generateRandomAddress = () => {
  const hexChars = '0123456789abcdef';
  let address = '0x';
  for (let i = 0; i < 40; i++) {
    address += hexChars[Math.floor(Math.random() * 16)];
  }
  return address;
};

/**
 * Generates an address book with a specified number of entries, for the supported networks.
 *
 * @param {number} numEntries - The number of address book entries to generate for each network.
 * @returns {object} The generated address book object.
 */
const withAddressBook = numEntries => {
  const networks = [_network.CHAIN_IDS.MAINNET, _network.CHAIN_IDS.SEPOLIA];
  const addressBook = {};
  networks.forEach(network => {
    addressBook[network] = {};
    for (let i = 1; i <= numEntries; i++) {
      const address = generateRandomAddress();
      addressBook[network][address] = {
        address,
        chainId: network,
        isEns: false,
        memo: '',
        name: `Contact ${i}`
      };
    }
  });
  return {
    addressBook
  };
};
exports.withAddressBook = withAddressBook;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\fixtures\\with-address-book.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\fixtures\\with-app-state.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cfixtures%5Cwith-app-state.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FIXTURES_APP_STATE = void 0;
const FIXTURES_APP_STATE = exports.FIXTURES_APP_STATE = {
  showProductTour: false
};

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\fixtures\\with-app-state.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\fixtures\\with-confirmed-transactions.js", {"../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","uuid":"D:\\code\\v\\metamask-extension\\node_modules\\uuid\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cfixtures%5Cwith-confirmed-transactions.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withConfirmedTransactions = void 0;
var _uuid = require("uuid");
var _network = require("../../../shared/constants/network");
/**
 * Generates a specified number of confirmed transactions for each network.
 *
 * @param {string} from - The address from which the transactions are sent.
 * @param {number} numEntries - The number of transactions to generate for each network.
 * @returns {object} The generated transactions object.
 */
const withConfirmedTransactions = (from, numEntries) => {
  const networks = [_network.CHAIN_IDS.MAINNET, _network.CHAIN_IDS.SEPOLIA];
  const transactions = {};
  networks.forEach(network => {
    for (let i = 0; i < numEntries; i++) {
      const id = (0, _uuid.v4)();
      const transaction = {
        chainId: network,
        dappSuggestedGasFees: {
          gas: '0x5208',
          maxFeePerGas: '0x59682f0c',
          maxPriorityFeePerGas: '0x59682f00'
        },
        history: [{
          chainId: network,
          dappSuggestedGasFees: {
            gas: '0x5208',
            maxFeePerGas: '0x59682f0c',
            maxPriorityFeePerGas: '0x59682f00'
          },
          id,
          loadingDefaults: true,
          origin: 'https://metamask.github.io',
          status: 'confirmed',
          time: Date.now(),
          txParams: {
            from,
            gas: '0x5208',
            maxFeePerGas: '0x59682f0c',
            maxPriorityFeePerGas: '0x59682f00',
            to: '0x2f318c334780961fb129d2a6c30d0763d9a5c970',
            value: '0x29a2241af62c0000'
          },
          type: 'simpleSend'
        }, [{
          note: 'Added new confirmed transaction.',
          op: 'replace',
          path: '/loadingDefaults',
          timestamp: Date.now(),
          value: false
        }, {
          op: 'add',
          path: '/simulationData',
          value: {
            error: {
              code: 'disabled',
              message: 'Simulation disabled'
            },
            tokenBalanceChanges: []
          },
          note: 'TransactionController#updateSimulationData - Update simulation data',
          timestamp: Date.now()
        }]],
        simulationData: {
          error: {
            code: 'disabled',
            message: 'Simulation disabled'
          },
          tokenBalanceChanges: []
        },
        id,
        loadingDefaults: false,
        origin: 'https://metamask.github.io',
        status: 'confirmed',
        time: Date.now(),
        txParams: {
          from,
          gas: '0x5208',
          maxFeePerGas: '0x59682f0c',
          maxPriorityFeePerGas: '0x59682f00',
          to: '0x2f318c334780961fb129d2a6c30d0763d9a5c970',
          value: '0x29a2241af62c0000'
        },
        type: 'simpleSend'
      };
      transactions[id] = transaction;
    }
  });
  return {
    transactions
  };
};
exports.withConfirmedTransactions = withConfirmedTransactions;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\fixtures\\with-confirmed-transactions.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\fixtures\\with-erc20-tokens.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cfixtures%5Cwith-erc20-tokens.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FIXTURES_ERC20_TOKENS = void 0;
const _TOKENS = [{
  address: '0x6B175474E89094C44Da98b954EedeAC495271d0F',
  symbol: 'DAI',
  decimals: 18,
  image: 'https://static.metafi.codefi.network/api/v1/tokenIcons/1/0x6b175474e89094c44da98b954eedeac495271d0f.png',
  isERC721: false,
  aggregators: []
}, {
  address: '0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48',
  symbol: 'USDC',
  decimals: 6,
  image: 'https://static.metafi.codefi.network/api/v1/tokenIcons/1/0xa0b86991c6218b36c1d19d4a2e9eb0ce3606eb48.png',
  isERC721: false,
  aggregators: []
}, {
  address: '0xdAC17F958D2ee523a2206206994597C13D831ec7',
  symbol: 'USDT',
  decimals: 6,
  image: 'https://static.metafi.codefi.network/api/v1/tokenIcons/1/0xdAC17F958D2ee523a2206206994597C13D831ec7.png',
  isERC721: false,
  aggregators: []
}, {
  address: '0xC011a73ee8576Fb46F5E1c5751cA3B9Fe0af2a6F',
  symbol: 'SNX',
  decimals: 18,
  image: 'https://static.metafi.codefi.network/api/v1/tokenIcons/1/0xC011a73ee8576Fb46F5E1c5751cA3B9Fe0af2a6F.png',
  isERC721: false,
  aggregators: []
}, {
  address: '0x111111111117dC0aa78b770fA6A738034120C302',
  symbol: '1INCH',
  decimals: 18,
  image: 'https://static.metafi.codefi.network/api/v1/tokenIcons/1/0x111111111117dC0aa78b770fA6A738034120C302.png',
  isERC721: false,
  aggregators: []
}, {
  address: '0x7D1AfA7B718fb893dB30A3aBc0Cfc608AaCfeBB0',
  symbol: 'MATIC',
  decimals: 18,
  image: 'https://static.metafi.codefi.network/api/v1/tokenIcons/1/0x7D1AfA7B718fb893dB30A3aBc0Cfc608AaCfeBB0.png',
  isERC721: false,
  aggregators: []
}, {
  address: '0x95aD61b0a150d79219dCF64E1E6Cc01f0B64C4cE',
  symbol: 'SHIB',
  decimals: 18,
  image: 'https://static.metafi.codefi.network/api/v1/tokenIcons/1/0x95aD61b0a150d79219dCF64E1E6Cc01f0B64C4cE.png',
  isERC721: false,
  aggregators: []
}, {
  address: '0xFd09911130e6930Bf87F2B0554c44F400bD80D3e',
  symbol: 'ETHIX',
  decimals: 18,
  image: 'https://static.metafi.codefi.network/api/v1/tokenIcons/1/0xFd09911130e6930Bf87F2B0554c44F400bD80D3e.png',
  isERC721: false,
  aggregators: []
}];
const FIXTURES_ERC20_TOKENS = exports.FIXTURES_ERC20_TOKENS = {
  tokens: _TOKENS,
  ignoredTokens: [],
  detectedTokens: [],
  allTokens: {
    '0x1': {
      myAccount: _TOKENS
    }
  },
  allIgnoredTokens: {},
  allDetectedTokens: {}
};

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\fixtures\\with-erc20-tokens.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\fixtures\\with-networks.js", {"../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cfixtures%5Cwith-networks.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FIXTURES_NETWORKS = void 0;
var _network = require("../../../shared/constants/network");
const FIXTURES_NETWORKS = exports.FIXTURES_NETWORKS = {
  providerConfig: {
    chainId: '0xaa36a7',
    rpcPrefs: {
      blockExplorerUrl: 'https://sepolia.etherscan.io'
    },
    ticker: 'SepoliaETH',
    type: 'sepolia'
  },
  networkConfigurations: {
    networkConfigurationId: {
      chainId: '0xaa36a7',
      nickname: _network.SEPOLIA_DISPLAY_NAME,
      rpcPrefs: {},
      rpcUrl: 'https://sepolia.infura.io/v3/',
      ticker: 'SepoliaETH',
      networkConfigurationId: 'networkConfigurationId'
    },
    optimism: {
      chainId: '0xa',
      id: 'optimism',
      nickname: _network.OPTIMISM_DISPLAY_NAME,
      rpcPrefs: {
        blockExplorerUrl: 'https://optimistic.etherscan.io/',
        imageUrl: './images/optimism.svg'
      },
      rpcUrl: 'https://optimism-mainnet.infura.io/v3/',
      ticker: 'ETH'
    },
    base: {
      chainId: '0x2105',
      id: 'base',
      nickname: _network.BASE_DISPLAY_NAME,
      rpcPrefs: {
        blockExplorerUrl: 'https://basescan.org',
        imageUrl: './images/base.svg'
      },
      rpcUrl: 'https://mainnet.base.org',
      ticker: 'ETH'
    },
    polygon: {
      chainId: '0x89',
      id: 'polygon',
      nickname: _network.POLYGON_DISPLAY_NAME,
      rpcPrefs: {
        blockExplorerUrl: 'https://polygonscan.com/',
        imageUrl: './images/matic-token.svg'
      },
      rpcUrl: 'https://polygon-mainnet.infura.io/v3/',
      ticker: 'MATIC'
    },
    binance: {
      chainId: '0x38',
      id: 'binance',
      nickname: _network.BNB_DISPLAY_NAME,
      rpcPrefs: {
        blockExplorerUrl: 'https://bscscan.com/',
        imageUrl: './images/bnb.svg'
      },
      rpcUrl: 'https://bsc-dataseed.binance.org/',
      ticker: 'BNB'
    },
    gnosis: {
      id: 'gnosis',
      rpcUrl: 'https://rpc.gnosischain.com',
      chainId: '0x64',
      ticker: 'XDAI',
      nickname: _network.GNOSIS_DISPLAY_NAME,
      rpcPrefs: {
        blockExplorerUrl: 'https://gnosisscan.io',
        imageUrl: './images/gnosis.svg'
      }
    },
    arbitrum: {
      id: 'arbitrum',
      rpcUrl: 'https://arbitrum-mainnet.infura.io/v3/',
      chainId: '0xa4b1',
      ticker: 'ETH',
      nickname: _network.ARBITRUM_DISPLAY_NAME,
      rpcPrefs: {
        blockExplorerUrl: 'https://explorer.arbitrum.io',
        imageUrl: './images/arbitrum.svg'
      }
    },
    avalanche: {
      id: 'avalanche',
      rpcUrl: 'https://avalanche-mainnet.infura.io/v3/',
      chainId: '0xa86a',
      ticker: 'AVAX',
      nickname: _network.AVALANCHE_DISPLAY_NAME,
      rpcPrefs: {
        blockExplorerUrl: 'https://snowtrace.io/',
        imageUrl: './images/avax-token.svg'
      }
    },
    celo: {
      id: 'celo',
      rpcUrl: 'https://celo-mainnet.infura.io/v3/',
      chainId: '0xa4ec',
      ticker: 'CELO',
      nickname: _network.CELO_DISPLAY_NAME,
      rpcPrefs: {
        blockExplorerUrl: 'https://celoscan.io',
        imageUrl: './images/celo.svg'
      }
    },
    zkSync: {
      id: 'zkSync',
      rpcUrl: 'https://mainnet.era.zksync.io',
      chainId: '0x144',
      ticker: 'ETH',
      nickname: _network.ZK_SYNC_ERA_DISPLAY_NAME,
      rpcPrefs: {
        blockExplorerUrl: 'https://explorer.zksync.io/',
        imageUrl: './images/zk-sync.svg'
      }
    },
    localhost: {
      id: 'localhost',
      rpcUrl: 'http://localhost:8545',
      chainId: '0x539',
      ticker: 'ETH',
      nickname: _network.LOCALHOST_DISPLAY_NAME,
      rpcPrefs: {
        blockExplorerUrl: '',
        imageUrl: ''
      }
    }
  }
};

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\fixtures\\with-networks.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\fixtures\\with-preferences.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cfixtures%5Cwith-preferences.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FIXTURES_PREFERENCES = void 0;
const FIXTURES_PREFERENCES = exports.FIXTURES_PREFERENCES = {
  preferences: {
    hideZeroBalanceTokens: false,
    showExtensionInFullSizeView: false,
    showFiatInTestnets: true,
    showTestNetworks: true,
    smartTransactionsOptInStatus: true,
    useNativeCurrencyAsPrimaryCurrency: true,
    petnamesEnabled: true,
    featureNotificationsEnabled: true,
    showTokenAutodetectModal: false,
    showNftAutodetectModal: false,
    showConfirmationAdvancedDetails: false,
    privacyMode: false
  },
  featureFlags: {
    sendHexData: true
  },
  firstTimeFlowType: 'import',
  completedOnboarding: true,
  currentLocale: 'en',
  knownMethodData: {},
  use4ByteResolution: true,
  participateInMetaMetrics: true,
  dataCollectionForMarketing: true,
  useNftDetection: true,
  usePhishDetect: true,
  useTokenDetection: true,
  useCurrencyRateCheck: true,
  useMultiAccountBalanceChecker: true,
  theme: 'light',
  useExternalNameSources: true,
  useTransactionSimulations: true,
  enableMV3TimestampSave: true,
  useExternalServices: true,
  isBackupAndSyncEnabled: true,
  isAccountSyncingEnabled: true
};

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\fixtures\\with-preferences.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\fixtures\\with-unread-notifications.js", {"uuid":"D:\\code\\v\\metamask-extension\\node_modules\\uuid\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cfixtures%5Cwith-unread-notifications.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withUnreadNotifications = void 0;
var _uuid = require("uuid");
/**
 * Generates a specified number of unread notifications for the given account.
 *
 * @param {string} account - The account address to use in the notifications.
 * @param {number} numNotifications - The number of unread notifications to generate.
 * @returns {object} The generated unread notifications object.
 */
const withUnreadNotifications = (account, numNotifications) => {
  const notifications = [];
  for (let i = 0; i < numNotifications; i++) {
    const id = (0, _uuid.v4)();
    const triggerId = (0, _uuid.v4)();
    const txHash = `0x${(0, _uuid.v4)().replace(/-/gu, '').padEnd(64, '0')}`;
    const notification = {
      address: account,
      block_number: 59796924,
      block_timestamp: '1721922504',
      chain_id: 1,
      created_at: new Date().toISOString(),
      data: {
        to: account,
        from: account,
        kind: 'eth_received',
        amount: {
          eth: '0.000100000000000000',
          usd: '0.27'
        },
        network_fee: {
          gas_price: '30000000078',
          native_token_price_in_usd: '0.497927'
        }
      },
      id,
      trigger_id: triggerId,
      tx_hash: txHash,
      unread: true,
      type: 'eth_received',
      createdAt: new Date().toISOString(),
      isRead: false
    };
    notifications.push(notification);
  }
  const notificationServicesController = {
    isFeatureAnnouncementsEnabled: true,
    isMetamaskNotificationsFeatureSeen: true,
    isNotificationServicesEnabled: true,
    metamaskNotificationsReadList: [],
    metamaskNotificationsList: notifications
  };
  return notificationServicesController;
};
exports.withUnreadNotifications = withUnreadNotifications;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\fixtures\\with-unread-notifications.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\AbstractPetnamesBridge.ts", {"@metamask/name-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\name-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CAbstractPetnamesBridge.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangeType = exports.AbstractPetnamesBridge = void 0;
var _nameController2 = require("@metamask/name-controller");
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
// Use the same type for both the source entries and the argument to NameController::setName.
// The type of change that occurred.
let ChangeType = exports.ChangeType = /*#__PURE__*/function (ChangeType) {
  ChangeType["ADDED"] = "ADDED";
  ChangeType["UPDATED"] = "UPDATED";
  ChangeType["DELETED"] = "DELETED";
  return ChangeType;
}({});
var SyncDirection = /*#__PURE__*/function (SyncDirection) {
  SyncDirection["SOURCE_TO_PETNAMES"] = "Source->Petnames";
  SyncDirection["PETNAMES_TO_SOURCE"] = "Petnames->Source";
  return SyncDirection;
}(SyncDirection || {}); // A list of changes, grouped by type.
/**
 * Get a string key for the given entry.
 *
 * @param entry
 * @param entry.type
 * @param entry.variation
 * @param entry.value
 */
function getKey({
  type,
  variation,
  value
}) {
  const normalizedValue = type === _nameController2.NameType.ETHEREUM_ADDRESS ? value.toLowerCase() : value;
  return `${type}/${variation}/${normalizedValue}`;
}

/**
 * Abstract class representing a bridge between petnames and a data source.
 * Provides methods for synchronizing petnames with the data source and handling changes.
 */
var _isTwoWay = /*#__PURE__*/new WeakMap();
var _nameController = /*#__PURE__*/new WeakMap();
var _synchronizingDirection = /*#__PURE__*/new WeakMap();
var _AbstractPetnamesBridge_brand = /*#__PURE__*/new WeakSet();
class AbstractPetnamesBridge {
  /**
   * @param options
   * @param options.isTwoWay - Indicates whether the bridge is two-way or not. One-way bridges are Source->Petnames only.
   * @param options.nameController
   * @param options.messenger
   */
  constructor({
    isTwoWay,
    nameController,
    messenger
  }) {
    /**
     * Synchronizes Petnames with the Source or vice versa, depending on the direction.
     *
     * @param direction - The direction to synchronize in.
     */
    _classPrivateMethodInitSpec(this, _AbstractPetnamesBridge_brand);
    _classPrivateFieldInitSpec(this, _isTwoWay, void 0);
    _classPrivateFieldInitSpec(this, _nameController, void 0);
    _classPrivateFieldInitSpec(this, _synchronizingDirection, null);
    _defineProperty(this, "messenger", void 0);
    _classPrivateFieldSet(_isTwoWay, this, isTwoWay);
    _classPrivateFieldSet(_nameController, this, nameController);
    this.messenger = messenger;
  }

  // Initializes listeners
  init() {
    if (_classPrivateFieldGet(_isTwoWay, this)) {
      this.messenger.subscribe('NameController:stateChange', () => _assertClassBrand(_AbstractPetnamesBridge_brand, this, _synchronize).call(this, SyncDirection.PETNAMES_TO_SOURCE));
    }
    this.onSourceChange(() => _assertClassBrand(_AbstractPetnamesBridge_brand, this, _synchronize).call(this, SyncDirection.SOURCE_TO_PETNAMES));
  }

  /**
   * Adds a listener for source change events.
   *
   * @param listener - The listener function to be called when a source change event occurs.
   */

  /**
   * Retrieves the source entries.
   *
   * @returns An array of PetnameEntry objects representing the source entries.
   */

  /**
   * Update the Source with the given entry. To be overridden by two-way subclasses.
   *
   * @param _type
   * @param _entry
   */
  updateSourceEntry(_type, _entry) {
    throw new Error('updateSourceEntry must be overridden for two-way bridges');
  }

  /**
   * This predicate describes a subset of Petnames state that is relevant
   * to the bridge.
   *
   * By default, the shouldSyncPetname method returns true for all Petnames,
   * meaning every PetnameEntry in the NameController state is considered for
   * synchronization. This would result in Petnames state being a mirror of
   * the source entries or vice versa after synchronization.
   *
   * If you override this method to return false for some Petnames, those
   * entries are effectively 'masked' or excluded from the synchronization
   * process. This has a couple of implications:
   *
   * Source->Petnames direction: Masked Petname entries will not be deleted.
   * If shouldSyncPetname returns false for some target Petname,that entry
   * will not be deleted from Petnames state during synchronization.
   *
   * Petnames->Source direction: Masked Petname entries will not be added to
   * Source.  If shouldSyncPetname returns false for some Petname, that entry
   * will not be added to the Source list during synchronization.
   *
   * @param _targetEntry - The entry from Petname state to check for membership.
   * @returns true iff the target Petname entry should participate in synchronization.
   */
  shouldSyncPetname(_targetEntry) {
    // All petname entries are sync participants by default.
    return true;
  }
}
exports.AbstractPetnamesBridge = AbstractPetnamesBridge;
function _synchronize(direction) {
  if (_classPrivateFieldGet(_synchronizingDirection, this) === direction) {
    throw new Error(`Attempted to synchronize recursively in same direction: ${direction}`);
  }
  if (_classPrivateFieldGet(_synchronizingDirection, this) !== null) {
    return; // Ignore calls while updating in the opposite direction
  }
  _classPrivateFieldSet(_synchronizingDirection, this, direction);
  const [newEntries, prevEntries] = direction === 'Source->Petnames' ? [this.getSourceEntries(), _assertClassBrand(_AbstractPetnamesBridge_brand, this, _getPetnameEntries).call(this)] : [_assertClassBrand(_AbstractPetnamesBridge_brand, this, _getPetnameEntries).call(this), this.getSourceEntries()];
  const changeList = _assertClassBrand(_AbstractPetnamesBridge_brand, this, _computeChangeList).call(this, prevEntries, newEntries);
  _assertClassBrand(_AbstractPetnamesBridge_brand, this, _applyChangeList).call(this, changeList);
  _classPrivateFieldSet(_synchronizingDirection, this, null);
}
/**
 * Extract PetnameEntry objects from the name controller state.
 */
function _getPetnameEntries() {
  const {
    names
  } = _classPrivateFieldGet(_nameController, this).state;
  const entries = [];
  for (const type of Object.values(_nameController2.NameType)) {
    for (const value of Object.keys(names[type])) {
      for (const variation of Object.keys(names[type][value])) {
        const {
          name,
          sourceId,
          origin
        } = names[type][value][variation];
        if (!name) {
          continue;
        }
        const entry = {
          value,
          type,
          name,
          variation,
          sourceId: sourceId ?? undefined,
          origin: origin ?? undefined
        };
        if (this.shouldSyncPetname(entry)) {
          entries.push(entry);
        }
      }
    }
  }
  return entries;
}
/**
 * Updates Petnames with the given entry.
 *
 * @param type - The type of change that occurred.
 * @param entry - The entry to update the name controller with.
 */
function _updatePetnameEntry(type, entry) {
  if (type === ChangeType.DELETED) {
    delete entry.sourceId;
    delete entry.origin;
    _classPrivateFieldGet(_nameController, this).setName({
      ...entry,
      name: null
    });
  } else {
    // ADDED or UPDATED
    _classPrivateFieldGet(_nameController, this).setName(entry);
  }
}
/**
 * Computes the list of changes between the previous and new entries.
 *
 * @param prevEntries - The previous entries.
 * @param newEntries - The new entries.
 * @returns A ChangeList object representing the changes that occurred between prevEntries and newEntries.
 */
function _computeChangeList(prevEntries, newEntries) {
  const added = [];
  const updated = [];
  const deleted = [];
  const prevEntriesMap = new Map(prevEntries.map(e => [getKey(e), e]));
  const newEntriesMap = new Map(newEntries.map(e => [getKey(e), e]));
  newEntriesMap.forEach((newEntry, newKey) => {
    const oldEntry = prevEntriesMap.get(newKey);
    if (oldEntry) {
      if (newEntry.name !== oldEntry.name) {
        updated.push(newEntry);
      }
    } else {
      added.push(newEntry);
    }
  });
  prevEntriesMap.forEach((oldEntry, oldKey) => {
    if (!newEntriesMap.has(oldKey)) {
      deleted.push(oldEntry);
    }
  });
  return {
    [ChangeType.ADDED]: added,
    [ChangeType.UPDATED]: updated,
    [ChangeType.DELETED]: deleted
  };
}
/**
 * Applies the given change list to either the Petnames or Source, depending on the current synchrnoization direction.
 *
 * @param changeList
 */
function _applyChangeList(changeList) {
  const applyChange = _classPrivateFieldGet(_synchronizingDirection, this) === SyncDirection.SOURCE_TO_PETNAMES ? _assertClassBrand(_AbstractPetnamesBridge_brand, this, _updatePetnameEntry).bind(this) : this.updateSourceEntry.bind(this);
  for (const type of Object.values(ChangeType)) {
    for (const entry of changeList[type]) {
      applyChange(type, entry);
    }
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\AbstractPetnamesBridge.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\AccountIdentitiesPetnamesBridge.ts", {"./AbstractPetnamesBridge":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\AbstractPetnamesBridge.ts","@metamask/name-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\name-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CAccountIdentitiesPetnamesBridge.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountIdentitiesPetnamesBridge = void 0;
var _nameController = require("@metamask/name-controller");
var _AbstractPetnamesBridge = require("./AbstractPetnamesBridge");
/**
 * A petnames bridge that uses the account identities from the preferences controller as the source.
 */
class AccountIdentitiesPetnamesBridge extends _AbstractPetnamesBridge.AbstractPetnamesBridge {
  constructor({
    nameController,
    messenger
  }) {
    super({
      isTwoWay: false,
      nameController,
      messenger
    });
  }

  /**
   * @override
   */
  getSourceEntries() {
    const internalAccounts = this.messenger.call('AccountsController:listAccounts');
    return internalAccounts.map(internalAccount => ({
      value: internalAccount.address,
      type: _nameController.NameType.ETHEREUM_ADDRESS,
      name: internalAccount.metadata.name,
      sourceId: undefined,
      variation: _nameController.FALLBACK_VARIATION,
      origin: _nameController.NameOrigin.ACCOUNT_IDENTITY
    }));
  }

  /**
   * @override
   */
  onSourceChange(listener) {
    this.messenger.subscribe('AccountsController:stateChange', listener);
  }

  /**
   * @override
   */
  shouldSyncPetname(targetEntry) {
    return targetEntry.origin === _nameController.NameOrigin.ACCOUNT_IDENTITY;
  }
}
exports.AccountIdentitiesPetnamesBridge = AccountIdentitiesPetnamesBridge;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\AccountIdentitiesPetnamesBridge.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\AddressBookPetnamesBridge.ts", {"./AbstractPetnamesBridge":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\AbstractPetnamesBridge.ts","@metamask/name-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\name-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CAddressBookPetnamesBridge.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddressBookPetnamesBridge = void 0;
var _nameController = require("@metamask/name-controller");
var _utils = require("@metamask/utils");
var _AbstractPetnamesBridge = require("./AbstractPetnamesBridge");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
var _addressBookController = /*#__PURE__*/new WeakMap();
class AddressBookPetnamesBridge extends _AbstractPetnamesBridge.AbstractPetnamesBridge {
  constructor({
    addressBookController,
    nameController,
    messenger
  }) {
    super({
      isTwoWay: true,
      nameController,
      messenger
    });
    _classPrivateFieldInitSpec(this, _addressBookController, void 0);
    _classPrivateFieldSet(_addressBookController, this, addressBookController);
  }

  /**
   * @override
   */
  getSourceEntries() {
    const entries = [];
    const {
      state
    } = _classPrivateFieldGet(_addressBookController, this);
    for (const chainId of Object.keys(state.addressBook)) {
      if (!(0, _utils.isStrictHexString)(chainId)) {
        continue;
      }
      const chainEntries = state.addressBook[chainId];
      for (const address of Object.keys(chainEntries)) {
        const entry = state.addressBook[chainId][address];
        const normalizedChainId = chainId.toLowerCase();
        const {
          name,
          isEns
        } = entry;
        if (!(name !== null && name !== void 0 && name.length) || !(address !== null && address !== void 0 && address.length)) {
          continue;
        }
        entries.push({
          value: address,
          name,
          variation: normalizedChainId,
          type: _nameController.NameType.ETHEREUM_ADDRESS,
          sourceId: isEns ? 'ens' : undefined,
          origin: _nameController.NameOrigin.ADDRESS_BOOK
        });
      }
    }
    return entries;
  }

  /**
   * @override
   */
  updateSourceEntry(type, entry) {
    if (type === _AbstractPetnamesBridge.ChangeType.DELETED) {
      _classPrivateFieldGet(_addressBookController, this).delete(entry.variation, entry.value);
    } else {
      _classPrivateFieldGet(_addressBookController, this).set(entry.value, entry.name, entry.variation);
    }
  }

  /**
   * @override
   */
  onSourceChange(listener) {
    this.messenger.subscribe('AddressBookController:stateChange', listener);
  }
}
exports.AddressBookPetnamesBridge = AddressBookPetnamesBridge;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\AddressBookPetnamesBridge.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\ComposableObservableStore.js", {"@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/obs-store":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\obs-store\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CComposableObservableStore.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _obsStore = require("@metamask/obs-store");
var _baseController = require("@metamask/base-controller");
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
/**
 * @typedef {__import__('@metamask/base-controller').Messenger} Messenger
 * @typedef {__import__('@metamask/base-controller').StateMetadataConstraint} StateMetadataConstraint
 * @typedef {__import__('immer').Patch} Patch
 */
/**
 * An ObservableStore that can composes a flat
 * structure of child stores based on configuration
 */
var _ComposableObservableStore_brand = /*#__PURE__*/new WeakSet();
class ComposableObservableStore extends _obsStore.ObservableStore {
  /**
   * Create a new store
   *
   * @param {object} options
   * @param {object} [options.config] - Map of internal state keys to child stores
   * @param {Messenger} options.controllerMessenger - The controller
   *   messenger, used for subscribing to events from BaseControllerV2-based
   *   controllers.
   * @param {object} [options.state] - The initial store state
   * @param {boolean} [options.persist] - Whether or not to apply the persistence for v2 controllers
   */
  constructor({
    config,
    controllerMessenger,
    state,
    persist
  }) {
    super(state);
    _classPrivateMethodInitSpec(this, _ComposableObservableStore_brand);
    /**
     * Describes which stores are being composed. The key is the name of the
     * store, and the value is either an ObserableStore, or a controller that
     * extends one of the two base controllers in the `@metamask/base-controller`
     * package.
     *
     * @type {Record<string, object>}
     */
    _defineProperty(this, "config", {});
    this.persist = persist;
    this.controllerMessenger = controllerMessenger;
    if (config) {
      this.updateStructure(config);
    }
  }

  /**
   * Composes a new internal store subscription structure
   *
   * @param {Record<string, object>} config - Describes which stores are being
   *   composed. The key is the name of the store, and the value is either an
   *   ObserableStore, or a controller that extends one of the two base
   *   controllers in the `@metamask/base-controller` package.
   */
  updateStructure(config) {
    this.config = config;
    this.removeAllListeners();
    const initialState = {};
    for (const key of Object.keys(config)) {
      var _store$getState;
      if (!config[key]) {
        throw new Error(`Undefined '${key}'`);
      }
      const store = config[key];
      if (store.subscribe) {
        config[key].subscribe(state => {
          _assertClassBrand(_ComposableObservableStore_brand, this, _onStateChange).call(this, key, state);
        });
      } else if (this.persist) {
        this.controllerMessenger.subscribe(`${store.name}:stateChange`, (state, patches) => {
          if (_assertClassBrand(_ComposableObservableStore_brand, this, _changedPersistedProperty).call(this, config[key].metadata, patches)) {
            _assertClassBrand(_ComposableObservableStore_brand, this, _onStateChange).call(this, key, (0, _baseController.getPersistentState)(state, config[key].metadata), patches);
          }
        });
      } else {
        this.controllerMessenger.subscribe(`${store.name}:stateChange`, (state, patches) => _assertClassBrand(_ComposableObservableStore_brand, this, _onStateChange).call(this, key, state, patches));
      }
      const initialStoreState = store.state ?? ((_store$getState = store.getState) === null || _store$getState === void 0 ? void 0 : _store$getState.call(store));
      initialState[key] = this.persist && config[key].metadata ? (0, _baseController.getPersistentState)(initialStoreState, config[key].metadata) : initialStoreState;
    }
    this.updateState(initialState);
  }

  /**
   * Merges all child store state into a single object rather than
   * returning an object keyed by child store class name
   *
   * @returns {object} Object containing merged child store state
   */
  getFlatState() {
    if (!this.config) {
      return {};
    }
    let flatState = {};
    for (const key of Object.keys(this.config)) {
      const controller = this.config[key];
      const state = controller.getState ? controller.getState() : controller.state;
      flatState = {
        ...flatState,
        ...state
      };
    }
    return flatState;
  }
}
exports.default = ComposableObservableStore;
function _onStateChange(controllerKey, newState, patches) {
  const oldState = this.getState()[controllerKey];
  this.updateState({
    [controllerKey]: newState
  });
  this.emit('stateChange', {
    controllerKey,
    newState,
    oldState,
    patches
  });
}
/**
 * Returns true if the given set of patches makes changes to a persisted property.
 *
 * Note that we assume at least one property is persisted, so a complete replacement patch
 * always returns true.
 *
 * @param {StateMetadataConstraint} metadata - Controller metadata.
 * @param {Patch[]} patches - A list of patches, corresponding to a single state update.
 * @returns True if the patches contain a change to persisted state, false otherwise.
 */
function _changedPersistedProperty(metadata, patches) {
  return patches.some(patch => {
    // Complete state replacement
    if (patch.path.length === 0) {
      return true;
    }
    const topLevelProperty = patch.path[0];
    // Missing metadata, return true out of caution
    if (!metadata[topLevelProperty]) {
      return true;
    }
    return metadata[topLevelProperty].persist;
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\ComposableObservableStore.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\CronjobControllerStorageManager.ts", {"webextension-polyfill":"D:\\code\\v\\metamask-extension\\node_modules\\webextension-polyfill\\dist\\browser-polyfill.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CCronjobControllerStorageManager.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CronjobControllerStorageManager = exports.CronjobControllerStorageKey = void 0;
var _webextensionPolyfill = _interopRequireDefault(require("webextension-polyfill"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
const CronjobControllerStorageKey = exports.CronjobControllerStorageKey = 'temp-cronjob-storage';

/**
 * A storage manager for CronjobController state.
 *
 * @deprecated This is a temporary fix, please do not use this class (or any
 * similar patterns) elsewhere.
 */
var _initialStorage = /*#__PURE__*/new WeakMap();
var _initialized = /*#__PURE__*/new WeakMap();
class CronjobControllerStorageManager {
  constructor() {
    /**
     * The initial CronjobController data.
     */
    _classPrivateFieldInitSpec(this, _initialStorage, null);
    /**
     * Whether the storage manager has been initialized or not.
     */
    _classPrivateFieldInitSpec(this, _initialized, false);
  }
  /**
   * Initialize the storage manager.
   */
  async init() {
    _classPrivateFieldSet(_initialStorage, this, (await _webextensionPolyfill.default.storage.local.get(CronjobControllerStorageKey))[CronjobControllerStorageKey]);
    _classPrivateFieldSet(_initialized, this, true);
  }

  /**
   * Get the initial CronjobController state.
   *
   * @returns The initial CronjobController state.
   */
  getInitialState() {
    if (!_classPrivateFieldGet(_initialized, this)) {
      throw new Error('CronjobControllerStorageManager not yet initialized');
    }
    return _classPrivateFieldGet(_initialStorage, this);
  }

  /**
   * Set the CronjobController state.
   *
   * @param data - The CronjobController state to set.
   */
  set(data) {
    if (!_classPrivateFieldGet(_initialized, this)) {
      throw new Error('CronjobControllerStorageManager not yet initialized');
    }
    _webextensionPolyfill.default.storage.local.set({
      [CronjobControllerStorageKey]: data
    }).catch(console.error);
  }
}
exports.CronjobControllerStorageManager = CronjobControllerStorageManager;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\CronjobControllerStorageManager.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\PatchStore.ts", {"./state-utils":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\state-utils.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","uuid":"D:\\code\\v\\metamask-extension\\node_modules\\uuid\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CPatchStore.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PatchStore = void 0;
var _utils = require("@metamask/utils");
var _uuid = require("uuid");
var _lodash = require("lodash");
var _stateUtils = require("./state-utils");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
const log = (0, _utils.createProjectLogger)('patch-store');
class PatchStore {
  constructor(observableStore) {
    _defineProperty(this, "id", void 0);
    _defineProperty(this, "observableStore", void 0);
    _defineProperty(this, "pendingPatches", []);
    _defineProperty(this, "listener", void 0);
    this.id = (0, _uuid.v4)();
    this.observableStore = observableStore;
    this.listener = this._onStateChange.bind(this);
    this.observableStore.on('stateChange', this.listener);
    log('Created', this.id);
  }
  flushPendingPatches() {
    const patches = this.pendingPatches;
    this.pendingPatches = [];
    for (const patch of patches) {
      log('Flushed', patch.path.join('.'), this.id, patch);
    }
    return patches;
  }
  destroy() {
    this.observableStore.removeListener('stateChange', this.listener);
    log('Destroyed', this.id);
  }
  _onStateChange({
    newState,
    oldState,
    patches: eventPatches
  }) {
    let patches = [];
    if (eventPatches) {
      const normalizedPatches = this._normalizeEventPatches(eventPatches, oldState);
      patches = (0, _stateUtils.sanitizePatches)(normalizedPatches ?? []);
    } else {
      const sanitizedNewState = (0, _stateUtils.sanitizeUIState)(newState);
      patches = this._generatePatches(oldState, sanitizedNewState);
    }
    const isInitialized = Boolean(newState.vault);
    if (isInitialized) {
      patches.push({
        op: 'replace',
        path: ['isInitialized'],
        value: isInitialized
      });
    }
    if (!patches.length) {
      return;
    }
    for (const patch of patches) {
      const path = patch.path.join('.');
      this.pendingPatches.push(patch);
      log('Added', path, this.id, patch);
    }
  }
  _generatePatches(oldState, newState) {
    return Object.keys(newState).map(key => {
      const oldData = oldState[key];
      const newData = newState[key];
      if (oldData === newData) {
        return null;
      }
      return {
        op: 'replace',
        path: [key],
        value: newData
      };
    }).filter(Boolean);
  }

  /**
   * Normalize patches from a controller.
   * Converts any root-level patches into multiple property patches
   * to prevent removing state from other controllers.
   *
   * @param eventPatches - Patches from the controller.
   * @param oldState - The previous state of the controller.
   * @returns
   */
  _normalizeEventPatches(eventPatches, oldState) {
    return eventPatches === null || eventPatches === void 0 ? void 0 : eventPatches.flatMap(patch => {
      if (patch.path.length > 0) {
        return [patch];
      }
      const stateProperties = (0, _lodash.uniq)([...Object.keys(oldState), ...Object.keys(patch.value)]);
      return stateProperties.map(key => ({
        op: key in patch.value ? 'replace' : 'remove',
        path: [key],
        ...(key in patch.value ? {
          value: patch.value[key]
        } : {})
      }));
    });
  }
}
exports.PatchStore = PatchStore;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\PatchStore.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\SnapsNameProvider.ts", {"@metamask/name-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\name-controller\\dist\\index.cjs","@metamask/snaps-rpc-methods":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CSnapsNameProvider.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapsNameProvider = void 0;
var _nameController = require("@metamask/name-controller");
var _snapsUtils = require("@metamask/snaps-utils");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _snapsRpcMethods = require("@metamask/snaps-rpc-methods");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
var _messenger = /*#__PURE__*/new WeakMap();
var _SnapsNameProvider_brand = /*#__PURE__*/new WeakSet();
class SnapsNameProvider {
  constructor({
    messenger
  }) {
    _classPrivateMethodInitSpec(this, _SnapsNameProvider_brand);
    // These fields are required for modular initialisation.
    _defineProperty(this, "name", 'SnapsNameProvider');
    _defineProperty(this, "state", null);
    _classPrivateFieldInitSpec(this, _messenger, void 0);
    _classPrivateFieldSet(_messenger, this, messenger);
  }
  getMetadata() {
    const snaps = _assertClassBrand(_SnapsNameProvider_brand, this, _getNameLookupSnaps).call(this);
    const sourceIds = {
      [_nameController.NameType.ETHEREUM_ADDRESS]: snaps.map(snap => snap.id)
    };
    const sourceLabels = snaps.reduce((acc, snap) => {
      const snapDetails = _classPrivateFieldGet(_messenger, this).call('SnapController:get', snap.id);
      const snapName = snapDetails === null || snapDetails === void 0 ? void 0 : snapDetails.manifest.proposedName;
      return {
        ...acc,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        [snap.id]: snapName || snap.id
      };
    }, {});
    return {
      sourceIds,
      sourceLabels
    };
  }
  async getProposedNames(request) {
    const {
      variation: chainIdHex,
      value
    } = request;
    const caipChainId = `eip155:${parseInt(chainIdHex, 16)}`;
    const nameSnaps = _assertClassBrand(_SnapsNameProvider_brand, this, _getNameLookupSnaps).call(this, caipChainId);
    const snapResults = await Promise.all(nameSnaps.map(snap => _assertClassBrand(_SnapsNameProvider_brand, this, _getSnapProposedName).call(this, snap.id, caipChainId, value)));
    const results = snapResults.reduce((acc, snapResult) => {
      const {
        sourceId,
        result
      } = snapResult;
      return {
        ...acc,
        [sourceId]: result
      };
    }, {});
    return {
      results
    };
  }
}
exports.SnapsNameProvider = SnapsNameProvider;
function _getNameLookupSnaps(chainId) {
  const permissionSubjects = _classPrivateFieldGet(_messenger, this).call('PermissionController:getState').subjects;
  const snaps = _classPrivateFieldGet(_messenger, this).call('SnapController:getAll');
  return snaps.filter(({
    id
  }) => {
    var _permissionSubjects$i;
    const permission = (_permissionSubjects$i = permissionSubjects[id]) === null || _permissionSubjects$i === void 0 ? void 0 : _permissionSubjects$i.permissions['endowment:name-lookup'];
    if (!permission) {
      return false;
    }
    const chainIdCaveat = (0, _snapsRpcMethods.getChainIdsCaveat)(permission);
    if (chainId && chainIdCaveat && !chainIdCaveat.includes(chainId)) {
      return false;
    }
    return true;
  });
}
async function _getSnapProposedName(snapId, caipChainId, address) {
  const sourceId = snapId;
  const nameLookupRequest = {
    chainId: caipChainId,
    address
  };
  let proposedNames;
  let resultError;
  try {
    const result = await _classPrivateFieldGet(_messenger, this).call('SnapController:handleRequest', {
      snapId,
      origin: 'metamask',
      handler: _snapsUtils.HandlerType.OnNameLookup,
      request: {
        jsonrpc: '2.0',
        method: ' ',
        params: nameLookupRequest
      }
    });
    const domains = result === null || result === void 0 ? void 0 : result.resolvedDomains;

    // TODO: Determine if this is what we want.
    proposedNames = domains ? [...new Set(domains.map(domain => domain.resolvedDomain))] : [];
  } catch (error) {
    _loglevel.default.error('Snap name provider request failed', {
      snapId,
      request: nameLookupRequest,
      error
    });
    resultError = error;
  }
  return {
    sourceId,
    result: {
      proposedNames,
      error: resultError
    }
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\SnapsNameProvider.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\WeakRefObjectMap.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CWeakRefObjectMap.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WeakRefObjectMap = void 0;
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * `WeakRefObjectMap` is a custom map-like structure designed to hold key-value pairs where the values are objects.
 * Unlike a standard `Map`, this implementation stores each property of the value objects as weak references.
 * This means that the properties of the objects are not prevented from being garbage collected when there are no other
 * references to them outside of this map.
 *
 * It is important to note that while the map itself behaves similarly to a standard `Map`, the weak references apply
 * to each property of the objects stored as values. This means that individual properties of these objects may become
 * unavailable (i.e., garbage collected) independently of one another. Users of this map should be prepared to handle
 * cases where a property's value has been collected and is therefore `undefined`.
 *
 * This class was implemented to help with memory management of network client proxies used by the SelectedNetworkController
 * to keep per domain selected networks in sync. The properties of the NetworkClient object (provider and blockTracker) are weakly
 * referenced so that they can be garbage collected if/when a dapp connection ends without effective cleanup.
 */

class WeakRefObjectMap {
  constructor() {
    /**
     * Internal map to store keys and their corresponding weakly referenced object values.
     */
    _defineProperty(this, "map", void 0);
    this.map = new Map();
  }

  /**
   * Associates a key with a value in the map. If the key already exists, its associated value is updated.
   * The values are stored as weak references.
   *
   * @param key - The key under which to store the value.
   * @param value - The value to store under the specified key. Must be an object.
   * @returns The `WeakRefObjectMap` instance.
   */
  set(key, value) {
    const weakRefValue = {};
    for (const keyValue in value) {
      if (!Object.prototype.hasOwnProperty.call(value, keyValue)) {
        continue;
      }
      const item = value[keyValue];
      if (typeof item === 'object' && item !== null) {
        weakRefValue[keyValue] = new WeakRef(item);
      } else {
        throw new Error(`Property ${String(keyValue)} is not an object and cannot be weakly referenced.`);
      }
    }
    this.map.set(key, weakRefValue);
    return this;
  }

  /**
   * Retrieves the value associated with the specified key. The value is dereferenced before being returned.
   * If the key does not exist or the value has been garbage collected, `undefined` is returned.
   *
   * @param key - The key whose associated value is to be returned.
   * @returns The dereferenced value associated with the key, or `undefined`.
   */
  get(key) {
    const weakRefValue = this.map.get(key);
    if (!weakRefValue) {
      return undefined;
    }
    const deRefValue = {};
    for (const keyValue in weakRefValue) {
      if (!Object.prototype.hasOwnProperty.call(weakRefValue, keyValue)) {
        continue;
      }
      const deref = weakRefValue[keyValue].deref();
      if (deref === undefined) {
        this.map.delete(key);
        return undefined;
      }
      deRefValue[keyValue] = deref;
    }
    return deRefValue;
  }

  /**
   * Checks whether the map contains the specified key.
   *
   * @param key - The key to check for presence in the map.
   * @returns `true` if the map contains the key, otherwise `false`.
   */
  has(key) {
    return this.get(key) !== undefined;
  }

  /**
   * Removes the specified key and its associated value from the map.
   *
   * @param key - The key to remove along with its associated value.
   * @returns `true` if the element was successfully removed, otherwise `false`.
   */
  delete(key) {
    const value = this.get(key);
    if (value !== undefined) {
      return this.map.delete(key);
    }
    return false;
  }

  /**
   * Removes all key-value pairs from the map.
   */
  clear() {
    this.map.clear();
  }

  /**
   * Returns the number of key-value pairs present in the map.
   */
  get size() {
    return this.map.size;
  }

  /**
   * Returns a new iterator object that contains an array of `[key, value]` for each element in the map.
   * The values are dereferenced before being returned.
   */
  entries() {
    const entries = [];
    this.map.forEach((_, key) => {
      const derefValue = this.get(key);
      if (derefValue !== undefined) {
        entries.push([key, derefValue]);
      }
    });
    return entries.values();
  }

  /**
   * Returns a new iterator object that contains the keys for each element in the map.
   */
  keys() {
    return this.map.keys();
  }

  /**
   * Returns a new iterator object that contains the values for each element in the map.
   * The values are dereferenced before being returned.
   */
  values() {
    const values = [];
    this.map.forEach((_, key) => {
      const derefValue = this.get(key);
      if (derefValue !== undefined) {
        values.push(derefValue);
      }
    });
    return values.values();
  }

  /**
   * Returns a new iterator object that contains an array of `[key, value]` for each element in the map,
   * making the map itself iterable.
   */
  [Symbol.iterator]() {
    return this.entries();
  }

  /**
   * Returns a string representing the map. This is used when converting the map to a string,
   * e.g., by `Object.prototype.toString`.
   */
  get [Symbol.toStringTag]() {
    return 'WeakRefObjectMap';
  }

  /**
   * Executes a provided function once for each key-value pair in the map, in insertion order.
   * Note that the values passed to the callback function are the `WeakRefObject`s,
   * not the dereferenced objects. This allows consumers to manage dereferencing according to their needs,
   * acknowledging that some references may have been garbage collected.
   *
   * @param callback - Function to execute for each element, taking three arguments:
   * - `value`: The value part of the key-value pair. Note that this is the weakly referenced object,
   * encapsulated within a `WeakRefObject`, allowing for manual dereferencing.
   * -`key`: The key part of the key-value pair.
   * - `map`: The `WeakRefObjectMap` instance that the `forEach` method was called on.
   * @param thisArg - Optional. Value to use as `this` when executing `callback`.
   */
  forEach(callback,
  // this is an unbound method, so the this value is unknown.
  // Also the Map type this is based on uses any for this parameter as well.

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  thisArg) {
    this.map.forEach((_, key) => {
      const deRefValue = this.get(key);
      if (deRefValue === undefined) {
        return;
      }
      if (thisArg) {
        callback.call(thisArg, deRefValue, key, this);
      } else {
        callback(deRefValue, key, this);
      }
    });
  }
}
exports.WeakRefObjectMap = WeakRefObjectMap;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\WeakRefObjectMap.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\approval\\utils.ts", {"../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-rpc-methods":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Capproval%5Cutils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rejectAllApprovals = rejectAllApprovals;
exports.rejectOriginApprovals = rejectOriginApprovals;
var _controllerUtils = require("@metamask/controller-utils");
var _snapsRpcMethods = require("@metamask/snaps-rpc-methods");
var _rpcErrors = require("@metamask/rpc-errors");
var _utils = require("@metamask/utils");
var _app = require("../../../../shared/constants/app");
///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)

///: END:ONLY_INCLUDE_IF

const log = (0, _utils.createProjectLogger)('approval-utils');
function rejectAllApprovals({
  approvalController,
  deleteInterface
}) {
  const approvalRequestsById = approvalController.state.pendingApprovals;
  const approvalRequests = Object.values(approvalRequestsById);
  for (const approvalRequest of approvalRequests) {
    rejectApproval({
      approvalController,
      approvalRequest,
      deleteInterface
    });
  }
}
function rejectOriginApprovals({
  approvalController,
  deleteInterface,
  origin
}) {
  const approvalRequestsById = approvalController.state.pendingApprovals;
  const approvalRequests = Object.values(approvalRequestsById);
  const originApprovalRequests = approvalRequests.filter(approvalRequest => approvalRequest.origin === origin);
  for (const approvalRequest of originApprovalRequests) {
    rejectApproval({
      approvalController,
      approvalRequest,
      deleteInterface
    });
  }
}
function rejectApproval({
  approvalController,
  approvalRequest,
  deleteInterface
}) {
  var _approvalRequest$requ;
  const {
    id,
    type,
    origin
  } = approvalRequest;
  const interfaceId = (_approvalRequest$requ = approvalRequest.requestData) === null || _approvalRequest$requ === void 0 ? void 0 : _approvalRequest$requ.id;
  switch (type) {
    case _controllerUtils.ApprovalType.SnapDialogAlert:
    case _controllerUtils.ApprovalType.SnapDialogPrompt:
    case _snapsRpcMethods.DIALOG_APPROVAL_TYPES.default:
      log('Rejecting snap dialog', {
        id,
        interfaceId,
        origin,
        type
      });
      approvalController.accept(id, null);
      deleteInterface === null || deleteInterface === void 0 || deleteInterface(interfaceId);
      break;
    case _controllerUtils.ApprovalType.SnapDialogConfirmation:
      log('Rejecting snap confirmation', {
        id,
        interfaceId,
        origin,
        type
      });
      approvalController.accept(id, false);
      deleteInterface === null || deleteInterface === void 0 || deleteInterface(interfaceId);
      break;

    ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
    case _app.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.confirmAccountCreation:
    case _app.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.confirmAccountRemoval:
    case _app.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.showSnapAccountRedirect:
      log('Rejecting snap account confirmation', {
        id,
        origin,
        type
      });
      approvalController.accept(id, false);
      break;
    ///: END:ONLY_INCLUDE_IF

    default:
      log('Rejecting pending approval', {
        id,
        origin,
        type
      });
      approvalController.reject(id, _rpcErrors.providerErrors.userRejectedRequest({
        data: {
          cause: 'rejectAllApprovals'
        }
      }));
      break;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\approval\\utils.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\backup.js", {"../../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Cbackup.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _stringUtils = require("../../../shared/modules/string-utils");
class Backup {
  constructor(opts = {}) {
    const {
      preferencesController,
      addressBookController,
      accountsController,
      networkController,
      trackMetaMetricsEvent
    } = opts;
    this.preferencesController = preferencesController;
    this.accountsController = accountsController;
    this.addressBookController = addressBookController;
    this.networkController = networkController;
    this._trackMetaMetricsEvent = trackMetaMetricsEvent;
  }
  async restoreUserData(jsonString) {
    const existingPreferences = this.preferencesController.state;
    const {
      preferences,
      addressBook,
      network,
      internalAccounts
    } = JSON.parse(jsonString);
    if (preferences) {
      preferences.identities = existingPreferences.identities;
      preferences.lostIdentities = existingPreferences.lostIdentities;
      preferences.selectedAddress = existingPreferences.selectedAddress;
      this.preferencesController.update(preferences);
    }
    if (addressBook) {
      this.addressBookController.update(addressBook, true);
    }
    if (network) {
      this.networkController.loadBackup(network);
    }
    if (internalAccounts) {
      this.accountsController.loadBackup(internalAccounts);
    }
    if (preferences || addressBook || network || internalAccounts) {
      this._trackMetaMetricsEvent({
        event: 'User Data Imported',
        category: 'Backup'
      });
    }
  }
  async backupUserData() {
    const userData = {
      preferences: {
        ...this.preferencesController.state
      },
      internalAccounts: {
        internalAccounts: this.accountsController.state.internalAccounts
      },
      addressBook: {
        ...this.addressBookController.state
      },
      network: {
        networkConfigurationsByChainId: this.networkController.state.networkConfigurationsByChainId
      }
    };

    /**
     * We can remove these properties since we will won't be restoring identities from backup
     */
    delete userData.preferences.identities;
    delete userData.preferences.lostIdentities;
    delete userData.preferences.selectedAddress;
    const result = JSON.stringify(userData);
    const date = new Date();
    const prefixZero = num => (0, _stringUtils.prependZero)(num, 2);

    /*
     * userData.YYYY_MM_DD_HH_mm_SS e.g userData.2022_01_13_13_45_56
     * */
    const userDataFileName = `MetaMaskUserData.${date.getFullYear()}_${prefixZero(date.getMonth() + 1)}_${prefixZero(date.getDay())}_${prefixZero(date.getHours())}_${prefixZero(date.getMinutes())}_${prefixZero(date.getDay())}.json`;
    return {
      fileName: userDataFileName,
      data: result
    };
  }
}
exports.default = Backup;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\backup.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\batch-utils.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Cbatch-utils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchAccountBalancesInBatches = fetchAccountBalancesInBatches;
exports.processInBatches = processInBatches;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
/**
 * Options for batch processing with Promise.all
 */

/**
 * Processes an array of items in parallel batches using Promise.all.
 * Filters out failed batches and optionally merges successful results.
 *
 * @param options - Configuration options for batch processing
 * @returns Promise resolving to merged result or null if all batches failed
 * @example
 * ```typescript
 * const addresses = ['0x1', '0x2', '0x3', ...];
 *
 * const result = await processInBatches({
 *   items: addresses,
 *   batchSize: 50,
 *   processBatch: async (addressBatch) => {
 *     const response = await fetch(`/api/balances?addresses=${addressBatch.join(',')}`);
 *     return response.ok ? await response.json() : null;
 *   },
 *   mergeResults: (results) => ({
 *     balances: results.reduce((acc, result) => ({ ...acc, ...result.balances }), {})
 *   }),
 *   logger: console
 * });
 * ```
 */
async function processInBatches(options) {
  const {
    items,
    batchSize,
    processBatch,
    mergeResults,
    logger
  } = options;
  if (items.length === 0) {
    return null;
  }

  // Split items into batches
  const batches = (0, _lodash.chunk)(items, batchSize);
  logger === null || logger === void 0 || logger.debug(`Processing ${items.length} items in ${batches.length} batches of max ${batchSize} each`);
  try {
    // Execute all batches in parallel using Promise.all
    const batchResults = await Promise.all(batches.map(async (batch, index) => {
      try {
        const result = await processBatch(batch);
        if (result === null) {
          logger === null || logger === void 0 || logger.warn(`Batch ${index + 1} failed and returned null`);
        }
        return result;
      } catch (error) {
        logger === null || logger === void 0 || logger.warn(`Batch ${index + 1} failed with error: ${String(error)}`);
        return null;
      }
    }));

    // Filter out failed batches
    const successfulResults = [];
    for (const result of batchResults) {
      if (result !== null) {
        successfulResults.push(result);
      }
    }
    if (successfulResults.length <= 0) {
      logger === null || logger === void 0 || logger.warn('All batches failed');
      return null;
    }
    logger === null || logger === void 0 || logger.debug(`Successfully processed ${successfulResults.length}/${batches.length} batches`);

    // Merge results if a merge function is provided
    if (mergeResults) {
      return mergeResults(successfulResults);
    }

    // If no merge function provided, return the first successful result
    const firstResult = successfulResults[0] || null;
    return firstResult;
  } catch (error) {
    logger === null || logger === void 0 || logger.warn(`Batch processing failed: ${String(error)}`);
    return null;
  }
}

/**
 * Utility function specifically for processing Account API balance requests in batches.
 * This is a specialized wrapper around processInBatches for the common use case
 * of fetching account balances from the MetaMask Account API.
 */

/**
 * Fetches account balances from MetaMask Account API in batches using Promise.all.
 * Automatically handles CAIP address formatting and result merging.
 *
 * @param options - Configuration for Account API batch requests
 * @returns Promise resolving to merged account balance data or null if failed
 */
async function fetchAccountBalancesInBatches(options) {
  const {
    addresses,
    supportedChainIds,
    accountApiBaseUrl,
    batchSize = 50,
    logger
  } = options;
  const networksParam = supportedChainIds.join(',');
  return processInBatches({
    items: addresses,
    batchSize,
    processBatch: async addressBatch => {
      // Convert addresses to CAIP format: eip155:{chainId}:0x...
      // Note: supportedChainIds are in decimal format, so we use the first one for CAIP
      // since all addresses in a batch are for the same chain
      const chainId = supportedChainIds[0];
      const accountAddressesParam = addressBatch.map(address => (0, _utils.toCaipAccountId)('eip155', chainId, address)).join(',');
      const url = `${accountApiBaseUrl}/v4/multiaccount/balances?networks=${networksParam}&accountAddresses=${accountAddressesParam}`;
      const response = await fetch(url, {
        method: 'GET',
        headers: {
          Accept: 'application/json'
        }
      });
      if (!response.ok) {
        logger === null || logger === void 0 || logger.warn(`Account API batch request failed with status ${response.status}: ${response.statusText}`);
        return null;
      }
      const jsonResponse = await response.json();
      return jsonResponse;
    },
    mergeResults: results => {
      // Merge all batch results into a single response
      const mergedResponse = {
        balances: {}
      };
      results.forEach(batchResult => {
        // The API returns balances as a flat Record<string, TokenInfo> where keys are token identifiers
        // Simply merge all token entries from all batches
        Object.assign(mergedResponse.balances, batchResult.balances);
      });
      return mergedResponse;
    },
    logger
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\batch-utils.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\createDupeReqFilterStream.ts", {"../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","readable-stream":"D:\\code\\v\\metamask-extension\\node_modules\\readable-stream\\readable-browser.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CcreateDupeReqFilterStream.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.THREE_MINUTES = void 0;
exports.default = createDupeReqFilterStream;
var _readableStream = require("readable-stream");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _time = require("../../../shared/constants/time");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const THREE_MINUTES = exports.THREE_MINUTES = _time.MINUTE * 3;

/**
 * Creates a set abstraction whose values expire after three minutes.
 *
 * @returns The expiry set.
 */
const makeExpirySet = () => {
  const map = new Map();
  setInterval(() => {
    const cutoffTime = Date.now() - THREE_MINUTES;
    for (const [id, timestamp] of map.entries()) {
      if (timestamp <= cutoffTime) {
        map.delete(id);
      } else {
        break;
      }
    }
  }, THREE_MINUTES);
  return {
    /**
     * Attempts to add a value to the set.
     *
     * @param value - The value to add.
     * @returns `true` if the value was added, and `false` if it already existed.
     */
    add(value) {
      if (!map.has(value)) {
        map.set(value, Date.now());
        return true;
      }
      return false;
    }
  };
};

/**
 * Returns a transform stream that filters out requests whose ids we've already seen.
 * Ignores JSON-RPC notifications, i.e. requests with an `undefined` id.
 *
 * @returns The stream object.
 */
function createDupeReqFilterStream() {
  const seenRequestIds = makeExpirySet();
  return new _readableStream.Transform({
    transform(chunk, _, cb) {
      // JSON-RPC notifications have no ids; our only recourse is to let them through.
      const hasNoId = chunk.id === undefined;
      const requestNotYetSeen = seenRequestIds.add(chunk.id);
      if (hasNoId || requestNotYetSeen) {
        cb(null, chunk);
      } else {
        _loglevel.default.debug(`RPC request with id "${chunk.id}" already seen.`);
        cb();
      }
    },
    objectMode: true
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\createDupeReqFilterStream.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\createEvmMethodsToNonEvmAccountReqFilterMiddleware.ts", {"../../../shared/constants/permissions":"D:\\code\\v\\metamask-extension\\shared\\constants\\permissions.ts","../controllers/permissions":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\permissions\\index.js","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CcreateEvmMethodsToNonEvmAccountReqFilterMiddleware.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createEvmMethodsToNonEvmAccountReqFilterMiddleware;
var _keyringApi = require("@metamask/keyring-api");
var _permissions = require("../../../shared/constants/permissions");
var _permissions2 = require("../controllers/permissions");
const METHODS_TO_CHECK = [...Object.values(_permissions.RestrictedEthMethods), ..._permissions2.unrestrictedEthSigningMethods];

/**
 * Returns a middleware that filters out requests whose requests are restricted to EVM accounts.
 *
 * @param opt - The middleware options.
 * @param opt.messenger - The messenger object.
 * @returns The middleware function.
 */
function createEvmMethodsToNonEvmAccountReqFilterMiddleware({
  messenger
}) {
  return function filterEvmRequestToNonEvmAccountsMiddleware(req, _res, next, end) {
    if (req.method === 'eth_signTransaction') {
      console.log('🛡️ [EvmFilter] eth_signTransaction 到达此 middleware');
    }
    const selectedAccount = messenger.call('AccountsController:getSelectedAccount');
    if (req.method === 'eth_signTransaction') {
      console.log('🛡️ [EvmFilter] 账户类型:', selectedAccount.type);
      console.log('🛡️ [EvmFilter] 是否为 EVM 账户?', (0, _keyringApi.isEvmAccountType)(selectedAccount.type));
    }

    // If it's an EVM account, there nothing to filter, so jump to the next
    // middleware directly.
    if ((0, _keyringApi.isEvmAccountType)(selectedAccount.type)) {
      if (req.method === 'eth_signTransaction') {
        console.log('🛡️ [EvmFilter] 是 EVM 账户，调用 next() 传递给下一个 middleware');
      }
      return next();
    }
    const ethMethodsRequiringEthAccount = METHODS_TO_CHECK.includes(req.method);
    if (ethMethodsRequiringEthAccount) {
      return end(new Error(`Non-EVM account cannot request this method: ${req.method}`));
    }

    // https://docs.metamask.io/wallet/reference/wallet_requestpermissions/
    // wallet_requestPermissions param is an array with one object. The object may contain
    // multiple keys that represent the permissions being requested.

    // Example:
    // {
    //   "method": "wallet_requestPermissions",
    //   "params": [
    //     {
    //       "eth_accounts": {},
    //       "anotherPermission": {}
    //     }
    //   ]
    // }

    // TODO: Convert this to superstruct schema
    const isWalletRequestPermission = req.method === 'wallet_requestPermissions';
    if (isWalletRequestPermission && req !== null && req !== void 0 && req.params && Array.isArray(req.params) && req.params.length > 0 && req.params[0]) {
      const permissionsMethodRequest = Object.keys(req.params[0]);
      const isEvmPermissionRequest = METHODS_TO_CHECK.some(method => permissionsMethodRequest.includes(method));
      if (isEvmPermissionRequest) {
        return end(new Error(`Non-EVM account cannot request this method: ${permissionsMethodRequest.toString()}`));
      }
    }
    return next();
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\createEvmMethodsToNonEvmAccountReqFilterMiddleware.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\createHyperliquidReferralMiddleware.ts", {"../../../shared/constants/referrals":"D:\\code\\v\\metamask-extension\\shared\\constants\\referrals.ts","@metamask/json-rpc-engine":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-engine\\dist\\index.cjs","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CcreateHyperliquidReferralMiddleware.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HyperliquidPermissionTriggerType = void 0;
exports.createHyperliquidReferralMiddleware = createHyperliquidReferralMiddleware;
var _jsonRpcEngine = require("@metamask/json-rpc-engine");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _referrals = require("../../../shared/constants/referrals");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
let HyperliquidPermissionTriggerType = exports.HyperliquidPermissionTriggerType = /*#__PURE__*/function (HyperliquidPermissionTriggerType) {
  HyperliquidPermissionTriggerType["NewConnection"] = "new_connection";
  HyperliquidPermissionTriggerType["OnNavigateConnectedTab"] = "on_navigate_connected_tab";
  return HyperliquidPermissionTriggerType;
}({});
function isExtendedJSONRPCRequest(req) {
  return Boolean(req.origin) && Boolean(req.tabId);
}

/**
 * Creates middleware that monitors permission requests for Hyperliquid.
 * When a permission is granted to Hyperliquid, it triggers the referral flow.
 *
 * @param handleHyperliquidReferral - Function to handle the referral flow
 * @returns Middleware function
 */
function createHyperliquidReferralMiddleware(handleHyperliquidReferral) {
  return (0, _jsonRpcEngine.createAsyncMiddleware)(async (req, res, next) => {
    // First, call next to process the request
    await next();
    if (!isExtendedJSONRPCRequest(req)) {
      return;
    }

    // After the request is processed, check if it was a successful permission grant for Hyperliquid
    const isHyperliquidConnectionRequest = req.method === 'wallet_requestPermissions' && req.origin === _referrals.HYPERLIQUID_ORIGIN;
    const arePermissionsGranted = Array.isArray(res.result) && res.result.some(permission => (permission === null || permission === void 0 ? void 0 : permission.parentCapability) === 'eth_accounts');
    if (isHyperliquidConnectionRequest && arePermissionsGranted) {
      handleHyperliquidReferral(req.tabId, HyperliquidPermissionTriggerType.NewConnection).catch(error => {
        _loglevel.default.error('Failed to handle Hyperliquid referral after wallet_requestPermissions grant: ', error);
      });
    }
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\createHyperliquidReferralMiddleware.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\createLoggerMiddleware.js", {"loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CcreateLoggerMiddleware.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createLoggerMiddleware;
var _loglevel = _interopRequireDefault(require("loglevel"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Returns a middleware that logs RPC activity. Logging is detailed in
 * development builds, but more limited in production builds.
 *
 * @param {{ origin: string }} opts - The middleware options
 * @returns {Function}
 */
function createLoggerMiddleware(opts) {
  return function loggerMiddleware(/** @type {any} */req, /** @type {any} */res, /** @type {Function} */next) {
    next((/** @type {Function} */cb) => {
      if (res.error) {
        _loglevel.default.debug('Error in RPC response:\n', res);
      }
      if (req.isMetamaskInternal) {
        return;
      }
      if (true) {
        _loglevel.default.info(`RPC (${opts.origin}):`, req, '->', res);
      } else {
        _loglevel.default.info(`RPC (${opts.origin}): ${req.method} -> ${res.error ? 'error' : 'success'}`);
      }
      cb();
    });
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\createLoggerMiddleware.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\createMainFrameOriginMiddleware.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CcreateMainFrameOriginMiddleware.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createMainFrameOriginMiddleware;
// Request and responses are currently untyped.

/**
 * Returns a middleware that appends the mainFrameOrigin to request
 *
 * @param {{ mainFrameOrigin: string }} opts - The middleware options
 * @returns {Function}
 */

function createMainFrameOriginMiddleware({
  mainFrameOrigin
}) {
  return function mainFrameOriginMiddleware(
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  req,
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  _res, next) {
    req.mainFrameOrigin = mainFrameOrigin;
    next();
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\createMainFrameOriginMiddleware.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\createMetaRPCHandler.js", {"./stream-utils":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\stream-utils.js","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CcreateMetaRPCHandler.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _rpcErrors = require("@metamask/rpc-errors");
var _streamUtils = require("./stream-utils");
const createMetaRPCHandler = (api, outStream) => {
  return async data => {
    if (!(0, _streamUtils.isStreamWritable)(outStream)) {
      return;
    }
    if (!api[data.method]) {
      outStream.write({
        jsonrpc: '2.0',
        error: _rpcErrors.rpcErrors.methodNotFound({
          message: `${data.method} not found`
        }),
        id: data.id
      });
      return;
    }
    let result;
    let error;
    try {
      result = await api[data.method](...data.params);
    } catch (err) {
      error = err;
    }
    if (!(0, _streamUtils.isStreamWritable)(outStream)) {
      if (error) {
        console.error(error);
      }
      return;
    }
    if (error) {
      outStream.write({
        jsonrpc: '2.0',
        error: (0, _rpcErrors.serializeError)(error, {
          shouldIncludeStack: true
        }),
        id: data.id
      });
    } else {
      outStream.write({
        jsonrpc: '2.0',
        result,
        id: data.id
      });
    }
  };
};
var _default = exports.default = createMetaRPCHandler;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\createMetaRPCHandler.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\createMetamaskMiddleware.js", {"./middleware/pending":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\middleware\\pending.js","@metamask/eth-json-rpc-middleware":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-json-rpc-middleware\\dist\\index.js","@metamask/json-rpc-engine":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-engine\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CcreateMetamaskMiddleware.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createMetamaskMiddleware;
var _jsonRpcEngine = require("@metamask/json-rpc-engine");
var _ethJsonRpcMiddleware = require("@metamask/eth-json-rpc-middleware");
var _pending = require("./middleware/pending");
function createMetamaskMiddleware({
  version,
  getAccounts,
  processTransaction,
  processSignTransaction,
  processTypedMessage,
  processTypedMessageV3,
  processTypedMessageV4,
  processPersonalMessage,
  processDecryptMessage,
  processEncryptionPublicKey,
  getPendingNonce,
  getPendingTransactionByHash,
  processRequestExecutionPermissions
}) {
  const metamaskMiddleware = (0, _jsonRpcEngine.mergeMiddleware)([(0, _jsonRpcEngine.createScaffoldMiddleware)({
    eth_syncing: false,
    web3_clientVersion: `MetaMask/v${version}`
  }), (0, _ethJsonRpcMiddleware.createWalletMiddleware)({
    getAccounts,
    processTransaction,
    processSignTransaction,
    processTypedMessage,
    processTypedMessageV3,
    processTypedMessageV4,
    processPersonalMessage,
    processDecryptMessage,
    processEncryptionPublicKey,
    processRequestExecutionPermissions
  }), (0, _pending.createPendingNonceMiddleware)({
    getPendingNonce
  }), (0, _pending.createPendingTxMiddleware)({
    getPendingTransactionByHash
  })]);
  return metamaskMiddleware;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\createMetamaskMiddleware.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\createOnboardingMiddleware.js", {"loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","webextension-polyfill":"D:\\code\\v\\metamask-extension\\node_modules\\webextension-polyfill\\dist\\browser-polyfill.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CcreateOnboardingMiddleware.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createOnboardingMiddleware;
var _loglevel = _interopRequireDefault(require("loglevel"));
var _webextensionPolyfill = _interopRequireDefault(require("webextension-polyfill"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Returns a middleware that intercepts `wallet_registerOnboarding` messages
 *
 * @param {{ location: string, registerOnboarding: Function }} opts - The middleware options
 * @returns {(req: any, res: any, next: Function, end: Function) => void}
 */
function createOnboardingMiddleware({
  location,
  registerOnboarding
}) {
  return async function originMiddleware(req, res, next, end) {
    try {
      if (req.method !== 'wallet_registerOnboarding') {
        next();
        return;
      }
      if (req.tabId && req.tabId !== _webextensionPolyfill.default.tabs.TAB_ID_NONE) {
        await registerOnboarding(location, req.tabId);
      } else {
        _loglevel.default.debug(`'wallet_registerOnboarding' message from ${location} ignored due to missing tabId`);
      }
      res.result = true;
      end();
    } catch (error) {
      end(error);
    }
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\createOnboardingMiddleware.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\createOriginMiddleware.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CcreateOriginMiddleware.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createOriginMiddleware;
/**
 * Returns a middleware that appends the DApp origin to request
 *
 * @param {{ origin: string }} opts - The middleware options
 * @returns {Function}
 */
function createOriginMiddleware(opts) {
  return function originMiddleware(/** @type {any} */req, /** @type {any} */_, /** @type {Function} */next) {
    req.origin = opts.origin;
    next();
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\createOriginMiddleware.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\createOriginThrottlingMiddleware.ts", {"../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CcreateOriginThrottlingMiddleware.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SPAM_FILTER_ACTIVATED_ERROR = exports.REJECTION_THRESHOLD_IN_MS = exports.NUMBER_OF_REJECTIONS_THRESHOLD = exports.BLOCKING_THRESHOLD_IN_MS = exports.BLOCKABLE_METHODS = void 0;
exports.default = createOriginThrottlingMiddleware;
var _rpcErrors = require("@metamask/rpc-errors");
var _app = require("../../../shared/constants/app");
const NUMBER_OF_REJECTIONS_THRESHOLD = exports.NUMBER_OF_REJECTIONS_THRESHOLD = 3;
const REJECTION_THRESHOLD_IN_MS = exports.REJECTION_THRESHOLD_IN_MS = 30000;
const BLOCKING_THRESHOLD_IN_MS = exports.BLOCKING_THRESHOLD_IN_MS = 60000;
const BLOCKABLE_METHODS = exports.BLOCKABLE_METHODS = new Set([_app.MESSAGE_TYPE.ADD_ETHEREUM_CHAIN, _app.MESSAGE_TYPE.ETH_SEND_TRANSACTION, _app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA, _app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V1, _app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3, _app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4, _app.MESSAGE_TYPE.PERSONAL_SIGN, _app.MESSAGE_TYPE.SWITCH_ETHEREUM_CHAIN, _app.MESSAGE_TYPE.WALLET_SEND_CALLS, _app.MESSAGE_TYPE.WATCH_ASSET]);
const TEST_ORIGINS = ['http://127.0.0.1:8080', 'http://127.0.0.1:8081', 'http://127.0.0.1:8082', 'http://localhost:8080', 'http://localhost:8081', 'http://localhost:8082'];
const SPAM_FILTER_ACTIVATED_ERROR = exports.SPAM_FILTER_ACTIVATED_ERROR = _rpcErrors.providerErrors.unauthorized('Request blocked due to spam filter.');
const isUserRejectedError = error => error.code === _rpcErrors.errorCodes.provider.userRejectedRequest;
function createOriginThrottlingMiddleware({
  getThrottledOriginState,
  updateThrottledOriginState
}) {
  return function originThrottlingMiddleware(req, res, next, end) {
    const {
      method,
      origin
    } = req;
    const isBlockableRPCMethod = BLOCKABLE_METHODS.has(method);

    // We don't want to throttle requests in e2e tests
    if (!isBlockableRPCMethod || TEST_ORIGINS.includes(origin)) {
      next();
      return;
    }
    const currentOriginState = getThrottledOriginState(origin);
    const isDappBlocked = isOriginBlockedForConfirmations(currentOriginState);
    if (isDappBlocked) {
      end(SPAM_FILTER_ACTIVATED_ERROR);
      return;
    }
    next(callback => {
      if ('error' in res && res.error && isUserRejectedError(res.error)) {
        var _res$error;
        const extraData = (_res$error = res.error) === null || _res$error === void 0 ? void 0 : _res$error.data;
        // Any rejection caused by rejectAllApprovals is not evaluated as user rejection for now
        if ((extraData === null || extraData === void 0 ? void 0 : extraData.cause) === 'rejectAllApprovals') {
          callback();
          return;
        }

        // User rejected the request
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
        // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
        const throttledOriginState = getThrottledOriginState(origin) || {
          rejections: 0,
          lastRejection: 0
        };
        const currentTime = Date.now();
        const isUnderThreshold = currentTime - throttledOriginState.lastRejection < REJECTION_THRESHOLD_IN_MS;
        const newRejections = isUnderThreshold ? throttledOriginState.rejections + 1 : 1;
        updateThrottledOriginState(origin, {
          rejections: newRejections,
          lastRejection: currentTime
        });
      } else {
        // User accepted the request
        const throttledOriginState = getThrottledOriginState(origin);
        const hasOriginThrottled = Boolean(throttledOriginState);
        if (hasOriginThrottled) {
          updateThrottledOriginState(origin, {
            rejections: 0,
            lastRejection: 0
          });
        }
      }
      callback();
    });
  };
}
function isOriginBlockedForConfirmations(throttledOriginState) {
  if (!throttledOriginState) {
    return false;
  }
  const currentTime = Date.now();
  const {
    rejections,
    lastRejection
  } = throttledOriginState;
  const isWithinOneMinute = currentTime - lastRejection <= BLOCKING_THRESHOLD_IN_MS;
  return rejections >= NUMBER_OF_REJECTIONS_THRESHOLD && isWithinOneMinute;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\createOriginThrottlingMiddleware.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\createRPCMethodTrackingMiddleware.js", {"../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../shared/constants/security-provider":"D:\\code\\v\\metamask-extension\\shared\\constants\\security-provider.ts","../../../shared/constants/signatures":"D:\\code\\v\\metamask-extension\\shared\\constants\\signatures.ts","../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../shared/lib/confirmation.utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\confirmation.utils.ts","../../../shared/lib/snaps/snaps":"D:\\code\\v\\metamask-extension\\shared\\lib\\snaps\\snaps.ts","../../../shared/modules/error":"D:\\code\\v\\metamask-extension\\shared\\modules\\error.ts","../../../shared/modules/transaction.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\transaction.utils.ts","../../../ui/helpers/utils/metrics":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\metrics.js","./snap-keyring/metrics":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\snap-keyring\\metrics.ts","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","ethereumjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\ethereumjs-util\\dist.browser\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CcreateRPCMethodTrackingMiddleware.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createRPCMethodTrackingMiddleware;
var _controllerUtils = require("@metamask/controller-utils");
var _rpcErrors = require("@metamask/rpc-errors");
var _ethereumjsUtil = require("ethereumjs-util");
var _app = require("../../../shared/constants/app");
var _metametrics = require("../../../shared/constants/metametrics");
var _transaction = require("../../../shared/modules/transaction.utils");
var _securityProvider = require("../../../shared/constants/security-provider");
var _signatures = require("../../../shared/constants/signatures");
var _transaction2 = require("../../../shared/constants/transaction");
var _error = require("../../../shared/modules/error");
var _metrics = require("../../../ui/helpers/utils/metrics");
var _confirmation = require("../../../shared/lib/confirmation.utils");
var _snaps = require("../../../shared/lib/snaps/snaps");
var _metrics2 = require("./snap-keyring/metrics");
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

/**
 * These types determine how the method tracking middleware handles incoming
 * requests based on the method name.
 */
const RATE_LIMIT_TYPES = {
  TIMEOUT: 'timeout',
  BLOCKED: 'blocked',
  NON_RATE_LIMITED: 'non_rate_limited',
  RANDOM_SAMPLE: 'random_sample'
};
const STAGE = {
  REQUESTED: 'REQUESTED',
  APPROVED: 'APPROVED',
  REJECTED: 'REJECTED'
};

/**
 * This object maps a method name to a RATE_LIMIT_TYPE. If not in this map the
 * default is RANDOM_SAMPLE
 */
const RATE_LIMIT_MAP = {
  [_app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA]: RATE_LIMIT_TYPES.NON_RATE_LIMITED,
  [_app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3]: RATE_LIMIT_TYPES.NON_RATE_LIMITED,
  [_app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4]: RATE_LIMIT_TYPES.NON_RATE_LIMITED,
  [_app.MESSAGE_TYPE.PERSONAL_SIGN]: RATE_LIMIT_TYPES.NON_RATE_LIMITED,
  [_app.MESSAGE_TYPE.ETH_DECRYPT]: RATE_LIMIT_TYPES.NON_RATE_LIMITED,
  [_app.MESSAGE_TYPE.ETH_GET_ENCRYPTION_PUBLIC_KEY]: RATE_LIMIT_TYPES.NON_RATE_LIMITED,
  [_app.MESSAGE_TYPE.ADD_ETHEREUM_CHAIN]: RATE_LIMIT_TYPES.NON_RATE_LIMITED,
  [_app.MESSAGE_TYPE.SWITCH_ETHEREUM_CHAIN]: RATE_LIMIT_TYPES.NON_RATE_LIMITED,
  [_app.MESSAGE_TYPE.ETH_REQUEST_ACCOUNTS]: RATE_LIMIT_TYPES.TIMEOUT,
  [_app.MESSAGE_TYPE.WALLET_REQUEST_PERMISSIONS]: RATE_LIMIT_TYPES.TIMEOUT,
  [_app.MESSAGE_TYPE.WALLET_CREATE_SESSION]: RATE_LIMIT_TYPES.NON_RATE_LIMITED,
  [_app.MESSAGE_TYPE.SEND_METADATA]: RATE_LIMIT_TYPES.BLOCKED,
  [_app.MESSAGE_TYPE.ETH_CHAIN_ID]: RATE_LIMIT_TYPES.BLOCKED,
  [_app.MESSAGE_TYPE.ETH_ACCOUNTS]: RATE_LIMIT_TYPES.BLOCKED,
  [_app.MESSAGE_TYPE.LOG_WEB3_SHIM_USAGE]: RATE_LIMIT_TYPES.BLOCKED,
  [_app.MESSAGE_TYPE.GET_PROVIDER_STATE]: RATE_LIMIT_TYPES.BLOCKED,
  [_app.MESSAGE_TYPE.WALLET_GET_CALLS_STATUS]: RATE_LIMIT_TYPES.NON_RATE_LIMITED,
  [_app.MESSAGE_TYPE.WALLET_GET_CAPABILITIES]: RATE_LIMIT_TYPES.NON_RATE_LIMITED,
  [_app.MESSAGE_TYPE.WALLET_SEND_CALLS]: RATE_LIMIT_TYPES.NON_RATE_LIMITED
};
const MESSAGE_TYPE_TO_APPROVAL_TYPE = {
  [_app.MESSAGE_TYPE.PERSONAL_SIGN]: _controllerUtils.ApprovalType.PersonalSign,
  [_app.MESSAGE_TYPE.SIGN]: _controllerUtils.ApprovalType.SignTransaction,
  [_app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA]: _controllerUtils.ApprovalType.EthSignTypedData,
  [_app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V1]: _controllerUtils.ApprovalType.EthSignTypedData,
  [_app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3]: _controllerUtils.ApprovalType.EthSignTypedData,
  [_app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4]: _controllerUtils.ApprovalType.EthSignTypedData
};

/**
 * For events with user interaction (approve / reject | cancel) this map will
 * return an object with APPROVED, REJECTED, REQUESTED, and FAILED keys that map to the
 * appropriate event names.
 */
const EVENT_NAME_MAP = {
  [_app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA]: {
    APPROVED: _metametrics.MetaMetricsEventName.SignatureApproved,
    REJECTED: _metametrics.MetaMetricsEventName.SignatureRejected,
    REQUESTED: _metametrics.MetaMetricsEventName.SignatureRequested
  },
  [_app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3]: {
    APPROVED: _metametrics.MetaMetricsEventName.SignatureApproved,
    REJECTED: _metametrics.MetaMetricsEventName.SignatureRejected,
    REQUESTED: _metametrics.MetaMetricsEventName.SignatureRequested
  },
  [_app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4]: {
    APPROVED: _metametrics.MetaMetricsEventName.SignatureApproved,
    REJECTED: _metametrics.MetaMetricsEventName.SignatureRejected,
    REQUESTED: _metametrics.MetaMetricsEventName.SignatureRequested
  },
  [_app.MESSAGE_TYPE.PERSONAL_SIGN]: {
    APPROVED: _metametrics.MetaMetricsEventName.SignatureApproved,
    REJECTED: _metametrics.MetaMetricsEventName.SignatureRejected,
    REQUESTED: _metametrics.MetaMetricsEventName.SignatureRequested
  },
  [_app.MESSAGE_TYPE.ETH_DECRYPT]: {
    APPROVED: _metametrics.MetaMetricsEventName.DecryptionApproved,
    REJECTED: _metametrics.MetaMetricsEventName.DecryptionRejected,
    REQUESTED: _metametrics.MetaMetricsEventName.DecryptionRequested
  },
  [_app.MESSAGE_TYPE.ETH_GET_ENCRYPTION_PUBLIC_KEY]: {
    APPROVED: _metametrics.MetaMetricsEventName.EncryptionPublicKeyApproved,
    REJECTED: _metametrics.MetaMetricsEventName.EncryptionPublicKeyRejected,
    REQUESTED: _metametrics.MetaMetricsEventName.EncryptionPublicKeyRequested
  },
  [_app.MESSAGE_TYPE.ETH_REQUEST_ACCOUNTS]: {
    APPROVED: _metametrics.MetaMetricsEventName.PermissionsApproved,
    REJECTED: _metametrics.MetaMetricsEventName.PermissionsRejected,
    REQUESTED: _metametrics.MetaMetricsEventName.PermissionsRequested
  },
  [_app.MESSAGE_TYPE.WALLET_REQUEST_PERMISSIONS]: {
    APPROVED: _metametrics.MetaMetricsEventName.PermissionsApproved,
    REJECTED: _metametrics.MetaMetricsEventName.PermissionsRejected,
    REQUESTED: _metametrics.MetaMetricsEventName.PermissionsRequested
  },
  [_app.MESSAGE_TYPE.WALLET_CREATE_SESSION]: {
    APPROVED: _metametrics.MetaMetricsEventName.PermissionsApproved,
    REJECTED: _metametrics.MetaMetricsEventName.PermissionsRejected,
    REQUESTED: _metametrics.MetaMetricsEventName.PermissionsRequested
  },
  [_app.MESSAGE_TYPE.WALLET_GET_CALLS_STATUS]: {
    REQUESTED: _metametrics.MetaMetricsEventName.Wallet5792Called
  },
  [_app.MESSAGE_TYPE.WALLET_GET_CAPABILITIES]: {
    REQUESTED: _metametrics.MetaMetricsEventName.Wallet5792Called
  },
  [_app.MESSAGE_TYPE.WALLET_SEND_CALLS]: {
    REQUESTED: _metametrics.MetaMetricsEventName.Wallet5792Called
  }
};

/**
 * This object maps a method name to a function that accept the method params and
 * returns a non-sensitive version that can be included in tracked events.
 * The default is to return undefined.
 */
const TRANSFORM_PARAMS_MAP = {
  [_app.MESSAGE_TYPE.WATCH_ASSET]: ({
    type
  }) => ({
    type
  }),
  [_app.MESSAGE_TYPE.ADD_ETHEREUM_CHAIN]: ([{
    chainId
  }]) => ({
    chainId
  }),
  [_app.MESSAGE_TYPE.SWITCH_ETHEREUM_CHAIN]: ([{
    chainId
  }]) => ({
    chainId
  })
};
const CUSTOM_PROPERTIES_MAP = {
  [_app.MESSAGE_TYPE.WALLET_SEND_CALLS]: getWalletSendCallsProperties,
  [_app.MESSAGE_TYPE.WALLET_CREATE_SESSION]: getWalletCreateSessionProperties
};
const rateLimitTimeoutsByMethod = {};
let globalRateLimitCount = 0;

/**
 * Create signature request event fragment with an assigned unique identifier
 *
 * @param {MetaMetricsController} metaMetricsController
 * @param {OriginalRequest} req
 * @param {Partial<MetaMetricsEventFragment>} fragmentPayload
 * @param {MetaMetricsEventCategory} eventCategory
 */
function createSignatureFragment(metaMetricsController, req, fragmentPayload, eventCategory) {
  metaMetricsController.createEventFragment({
    category: eventCategory,
    initialEvent: _metametrics.MetaMetricsEventName.SignatureRequested,
    successEvent: _metametrics.MetaMetricsEventName.SignatureApproved,
    failureEvent: _metametrics.MetaMetricsEventName.SignatureRejected,
    uniqueIdentifier: (0, _metrics.generateSignatureUniqueId)(req.id),
    persist: true,
    referrer: {
      url: req.origin
    },
    ...fragmentPayload
  });
}

/**
 * Updates and finalizes event fragment for signature requests
 *
 * @param {MetaMetricsController} metaMetricsController
 * @param {OriginalRequest} req
 * @param {MetaMetricsFinalizeEventFragmentOptions}  finalizeEventOptions
 * @param {Partial<MetaMetricsEventFragment>} fragmentPayload
 */
function finalizeSignatureFragment(metaMetricsController, req, finalizeEventOptions, fragmentPayload) {
  const signatureUniqueId = (0, _metrics.generateSignatureUniqueId)(req.id);
  metaMetricsController.updateEventFragment(signatureUniqueId, fragmentPayload);
  metaMetricsController.finalizeEventFragment(signatureUniqueId, finalizeEventOptions);
}
function isMultichainRequestMethod(method) {
  return [_app.MESSAGE_TYPE.WALLET_CREATE_SESSION, _app.MESSAGE_TYPE.WALLET_INVOKE_METHOD].includes(method);
}

/**
 * Returns a middleware that tracks inpage_provider usage using sampling for
 * each type of event except those that require user interaction, such as
 * signature requests
 *
 * @param {object} opts - options for the rpc method tracking middleware
 * @param {number} [opts.rateLimitTimeout] - time, in milliseconds, to wait before
 *  allowing another set of events to be tracked for methods rate limited by timeout.
 * @param {number} [opts.rateLimitSamplePercent] - percentage, in decimal, of events
 *  that should be tracked for methods rate limited by random sample.
 * @param {Function} opts.getAccountType
 * @param {Function} opts.getDeviceModel
 * @param {Function} opts.getHardwareTypeForMetric
 * @param {RestrictedMessenger} opts.snapAndHardwareMessenger
 * @param {number} [opts.globalRateLimitTimeout] - time, in milliseconds, of the sliding
 * time window that should limit the number of method calls tracked to globalRateLimitMaxAmount.
 * @param {number} [opts.globalRateLimitMaxAmount] - max number of method calls that should
 * tracked within the globalRateLimitTimeout time window.
 * @param {AppStateController} [opts.appStateController]
 * @param {MetaMetricsController} [opts.metaMetricsController]
 * @returns {Function}
 */

function createRPCMethodTrackingMiddleware({
  rateLimitTimeout = 60 * 5 * 1000,
  // 5 minutes
  rateLimitSamplePercent = 0.001,
  // 0.1%
  globalRateLimitTimeout = 60 * 5 * 1000,
  // 5 minutes
  globalRateLimitMaxAmount = 10,
  // max of events in the globalRateLimitTimeout window. pass 0 for no global rate limit
  getAccountType,
  getDeviceModel,
  getHardwareTypeForMetric,
  snapAndHardwareMessenger,
  appStateController,
  metaMetricsController,
  getHDEntropyIndex
}) {
  return async function rpcMethodTrackingMiddleware(/** @type {any} */req, /** @type {any} */res, /** @type {Function} */next) {
    const {
      origin,
      method,
      params
    } = req;
    const isMultichainRequest = isMultichainRequestMethod(method);
    // requestedThrough and eventCategory are currently redundant so we will want to
    // disentangle them in the future
    const requestedThrough = isMultichainRequest ? _metametrics.MetaMetricsRequestedThrough.MultichainApi : _metametrics.MetaMetricsRequestedThrough.EthereumProvider;
    const eventCategory = isMultichainRequest ? _metametrics.MetaMetricsEventCategory.MultichainApi : _metametrics.MetaMetricsEventCategory.InpageProvider;
    let invokedMethod = method;
    let multichainApiRequestScope;
    // if the request is through the multichain api, the method is nested in the params
    if (method === _app.MESSAGE_TYPE.WALLET_INVOKE_METHOD) {
      var _params$request;
      invokedMethod = params === null || params === void 0 || (_params$request = params.request) === null || _params$request === void 0 ? void 0 : _params$request.method;
      multichainApiRequestScope = params === null || params === void 0 ? void 0 : params.scope;
    }
    const rateLimitType = RATE_LIMIT_MAP[invokedMethod];
    let isRateLimited;
    switch (rateLimitType) {
      case RATE_LIMIT_TYPES.TIMEOUT:
        isRateLimited = typeof rateLimitTimeoutsByMethod[invokedMethod] !== 'undefined';
        break;
      case RATE_LIMIT_TYPES.NON_RATE_LIMITED:
        isRateLimited = false;
        break;
      case RATE_LIMIT_TYPES.BLOCKED:
        isRateLimited = true;
        break;
      default:
      case RATE_LIMIT_TYPES.RANDOM_SAMPLE:
        isRateLimited = Math.random() >= rateLimitSamplePercent;
        break;
    }
    const isGlobalRateLimited = globalRateLimitMaxAmount > 0 && globalRateLimitCount >= globalRateLimitMaxAmount;

    // Get the participateInMetaMetrics state to determine if we should track
    // anything. This is extra redundancy because this value is checked in
    // the metametrics controller's trackEvent method as well.
    const userParticipatingInMetaMetrics = metaMetricsController.state.participateInMetaMetrics === true;

    // Get the event type, each of which has APPROVED, REJECTED and REQUESTED
    // keys for the various events in the flow.
    const eventType = EVENT_NAME_MAP[invokedMethod];
    const eventProperties = {
      api_source: requestedThrough
    };
    if (multichainApiRequestScope) {
      eventProperties.chain_id_caip = multichainApiRequestScope;
    }
    let sensitiveEventProperties;
    const isPreinstalledSnap = (0, _snaps.isSnapPreinstalled)(origin);

    // Boolean variable that reduces code duplication and increases legibility
    const shouldTrackEvent =
    // Don't track if the request came from our own UI or background
    origin !== _app.ORIGIN_METAMASK &&
    // Don't track requests coming from preinstalled Snaps
    !isPreinstalledSnap &&
    // Don't track if the rate limit has been hit
    !isRateLimited &&
    // Don't track if the global rate limit has been hit
    !isGlobalRateLimited &&
    // Don't track if the user isn't participating in metametrics
    userParticipatingInMetaMetrics === true;
    if (shouldTrackEvent) {
      var _CUSTOM_PROPERTIES_MA;
      // We track an initial "requested" event as soon as the dapp calls the
      // provider method. For the events not special cased this is the only
      // event that will be fired and the event name will be
      // 'Provider Method Called'.
      const event = eventType ? eventType.REQUESTED : _metametrics.MetaMetricsEventName.ProviderMethodCalled;
      if (event === _metametrics.MetaMetricsEventName.SignatureRequested) {
        var _req$params, _req$securityAlertRes, _req$securityAlertRes2, _req$securityAlertRes3, _req$securityAlertRes4;
        eventProperties.signature_type = invokedMethod;
        eventProperties.hd_entropy_index = getHDEntropyIndex();

        // In personal messages the first param is data while in typed messages second param is data
        // if condition below is added to ensure that the right params are captured as data and address.
        let data;
        if ((0, _ethereumjsUtil.isValidAddress)(req === null || req === void 0 || (_req$params = req.params) === null || _req$params === void 0 ? void 0 : _req$params[1])) {
          var _req$params2;
          data = req === null || req === void 0 || (_req$params2 = req.params) === null || _req$params2 === void 0 ? void 0 : _req$params2[0];
        } else {
          var _req$params3;
          data = req === null || req === void 0 || (_req$params3 = req.params) === null || _req$params3 === void 0 ? void 0 : _req$params3[1];
        }
        if ((_req$securityAlertRes = req.securityAlertResponse) !== null && _req$securityAlertRes !== void 0 && _req$securityAlertRes.providerRequestsCount) {
          Object.keys(req.securityAlertResponse.providerRequestsCount).forEach(key => {
            const metricKey = `ppom_${key}_count`;
            eventProperties[metricKey] = req.securityAlertResponse.providerRequestsCount[key];
          });
        }
        eventProperties.security_alert_response = ((_req$securityAlertRes2 = req.securityAlertResponse) === null || _req$securityAlertRes2 === void 0 ? void 0 : _req$securityAlertRes2.result_type) ?? _securityProvider.BlockaidResultType.NotApplicable;
        eventProperties.security_alert_reason = ((_req$securityAlertRes3 = req.securityAlertResponse) === null || _req$securityAlertRes3 === void 0 ? void 0 : _req$securityAlertRes3.reason) ?? _securityProvider.BlockaidReason.notApplicable;
        if ((_req$securityAlertRes4 = req.securityAlertResponse) !== null && _req$securityAlertRes4 !== void 0 && _req$securityAlertRes4.description) {
          eventProperties.security_alert_description = req.securityAlertResponse.description;
        }
        if ((0, _confirmation.shouldUseRedesignForSignatures)({
          approvalType: MESSAGE_TYPE_TO_APPROVAL_TYPE[invokedMethod]
        })) {
          eventProperties.ui_customizations = [...(eventProperties.ui_customizations || []), _metametrics.MetaMetricsEventUiCustomization.RedesignedConfirmation];
        }
        const snapAndHardwareInfo = await (0, _metrics2.getSnapAndHardwareInfoForMetrics)(getAccountType, getDeviceModel, getHardwareTypeForMetric, snapAndHardwareMessenger);

        // merge the snapAndHardwareInfo into eventProperties
        Object.assign(eventProperties, snapAndHardwareInfo);
        try {
          if (invokedMethod === _app.MESSAGE_TYPE.PERSONAL_SIGN) {
            const {
              isSIWEMessage
            } = (0, _controllerUtils.detectSIWE)({
              data
            });
            if (isSIWEMessage) {
              eventProperties.ui_customizations = [...(eventProperties.ui_customizations || []), _metametrics.MetaMetricsEventUiCustomization.Siwe];
            }
          } else if (invokedMethod === _app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4) {
            const parsedMessageData = (0, _transaction.parseTypedDataMessage)(data);
            sensitiveEventProperties = {};
            eventProperties.eip712_primary_type = parsedMessageData.primaryType;
            sensitiveEventProperties.eip712_verifyingContract = parsedMessageData.domain.verifyingContract;
            sensitiveEventProperties.eip712_domain_version = parsedMessageData.domain.version;
            sensitiveEventProperties.eip712_domain_name = parsedMessageData.domain.name;
            if (_signatures.PRIMARY_TYPES_PERMIT.includes(parsedMessageData.primaryType)) {
              eventProperties.ui_customizations = [...(eventProperties.ui_customizations || []), _metametrics.MetaMetricsEventUiCustomization.Permit];
            } else if (_signatures.PRIMARY_TYPES_ORDER.includes(parsedMessageData.primaryType)) {
              eventProperties.ui_customizations = [...(eventProperties.ui_customizations || []), _metametrics.MetaMetricsEventUiCustomization.Order];
            }
          }
        } catch (e) {
          console.warn(`createRPCMethodTrackingMiddleware: Errored - ${e}`);
        }
      } else {
        eventProperties.method = invokedMethod;
      }
      const transformParams = TRANSFORM_PARAMS_MAP[invokedMethod];
      if (transformParams) {
        eventProperties.params = transformParams(params);
      }
      (_CUSTOM_PROPERTIES_MA = CUSTOM_PROPERTIES_MAP[invokedMethod]) === null || _CUSTOM_PROPERTIES_MA === void 0 || _CUSTOM_PROPERTIES_MA.call(CUSTOM_PROPERTIES_MAP, req, undefined, STAGE.REQUESTED, eventProperties);
      if (event === _metametrics.MetaMetricsEventName.SignatureRequested) {
        const fragmentPayload = {
          properties: eventProperties,
          sensitiveProperties: sensitiveEventProperties
        };
        createSignatureFragment(metaMetricsController, req, fragmentPayload, eventCategory);
      } else {
        metaMetricsController.trackEvent({
          event,
          category: eventCategory,
          referrer: {
            url: origin
          },
          properties: eventProperties
        });
      }
      if (rateLimitType === RATE_LIMIT_TYPES.TIMEOUT) {
        rateLimitTimeoutsByMethod[invokedMethod] = setTimeout(() => {
          delete rateLimitTimeoutsByMethod[invokedMethod];
        }, rateLimitTimeout);
      }
      globalRateLimitCount += 1;
      setTimeout(() => {
        globalRateLimitCount -= 1;
      }, globalRateLimitTimeout);
    }
    next(async callback => {
      var _res$error, _res$error2, _res$error3, _CUSTOM_PROPERTIES_MA2;
      if (shouldTrackEvent === false || typeof eventType === 'undefined') {
        return callback();
      }
      const location = (_res$error = res.error) === null || _res$error === void 0 || (_res$error = _res$error.data) === null || _res$error === void 0 ? void 0 : _res$error.location;
      let event;
      let stage;
      const errorMessage = (0, _error.getErrorMessage)(res.error);
      if (((_res$error2 = res.error) === null || _res$error2 === void 0 ? void 0 : _res$error2.code) === _rpcErrors.errorCodes.provider.userRejectedRequest) {
        event = eventType.REJECTED;
        stage = STAGE.REJECTED;
      } else if (((_res$error3 = res.error) === null || _res$error3 === void 0 ? void 0 : _res$error3.code) === _rpcErrors.errorCodes.rpc.internal && [errorMessage, res.error.message].includes('Request rejected by user or snap.')) {
        // The signature was approved in MetaMask but rejected in the snap
        event = eventType.REJECTED;
        stage = STAGE.REJECTED;
        eventProperties.status = errorMessage;
      } else {
        event = eventType.APPROVED;
        stage = STAGE.APPROVED;
      }
      if (!event) {
        return callback();
      }
      (_CUSTOM_PROPERTIES_MA2 = CUSTOM_PROPERTIES_MAP[invokedMethod]) === null || _CUSTOM_PROPERTIES_MA2 === void 0 || _CUSTOM_PROPERTIES_MA2.call(CUSTOM_PROPERTIES_MAP, req, res, stage, eventProperties);
      if (eventType.REQUESTED === _metametrics.MetaMetricsEventName.SignatureRequested) {
        // get the snap and hardware info again in case we were not able to during the initial request
        // because the KeyringController was locked
        const snapAndHardwareInfo = await (0, _metrics2.getSnapAndHardwareInfoForMetrics)(getAccountType, getDeviceModel, getHardwareTypeForMetric, snapAndHardwareMessenger);

        // merge the snapAndHardwareInfo into eventProperties
        Object.assign(eventProperties, snapAndHardwareInfo);
      }
      let blockaidMetricProps = {};
      if (_transaction2.SIGNING_METHODS.includes(invokedMethod)) {
        var _req$securityAlertRes5;
        const securityAlertResponse = appStateController.getSignatureSecurityAlertResponse((_req$securityAlertRes5 = req.securityAlertResponse) === null || _req$securityAlertRes5 === void 0 ? void 0 : _req$securityAlertRes5.securityAlertId);
        blockaidMetricProps = (0, _metrics.getBlockaidMetricsProps)({
          securityAlertResponse
        });
      }
      const properties = {
        ...eventProperties,
        ...blockaidMetricProps,
        location
      };
      if (event === _metametrics.MetaMetricsEventName.SignatureRejected || event === _metametrics.MetaMetricsEventName.SignatureApproved) {
        const finalizeOptions = {
          abandoned: event === eventType.REJECTED
        };
        const fragmentPayload = {
          properties: {
            ...properties,
            hd_entropy_index: getHDEntropyIndex()
          },
          sensitiveProperties: sensitiveEventProperties
        };
        finalizeSignatureFragment(metaMetricsController, req, finalizeOptions, fragmentPayload);
      } else {
        metaMetricsController.trackEvent({
          event,
          category: eventCategory,
          referrer: {
            url: origin
          },
          properties
        });
      }
      return callback();
    });
  };
}
function getWalletSendCallsProperties(req, _res, stage, eventProperties) {
  var _params$;
  if (stage !== STAGE.REQUESTED) {
    return;
  }
  const {
    params
  } = req;
  const callCount = params === null || params === void 0 || (_params$ = params[0]) === null || _params$ === void 0 || (_params$ = _params$.calls) === null || _params$ === void 0 ? void 0 : _params$.length;
  if (callCount) {
    eventProperties.batch_transaction_count = callCount;
  }
}
function getWalletCreateSessionProperties(req, res, stage, eventProperties) {
  if (stage === STAGE.REQUESTED) {
    const {
      params
    } = req;
    const requiredScopes = (params === null || params === void 0 ? void 0 : params.requiredScopes) || {};
    const optionalScopes = (params === null || params === void 0 ? void 0 : params.optionalScopes) || {};
    const scopeSet = new Set();
    for (const key of Object.keys(requiredScopes)) {
      scopeSet.add(key);
    }
    for (const key of Object.keys(optionalScopes)) {
      scopeSet.add(key);
    }
    eventProperties.chain_id_list = Array.from(scopeSet);
  } else if (stage === STAGE.APPROVED) {
    const {
      result
    } = res;
    const scopes = Object.keys((result === null || result === void 0 ? void 0 : result.sessionScopes) || {});
    eventProperties.chain_id_list = scopes;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\createRPCMethodTrackingMiddleware.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\createTabIdMiddleware.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CcreateTabIdMiddleware.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createTabIdMiddleware;
/**
 * Returns a middleware that appends the DApp TabId to the request
 *
 * @param {{ tabId: number }} opts - The middleware options
 * @returns {Function}
 */
function createTabIdMiddleware(opts) {
  return function tabIdMiddleware(/** @type {any} */req, /** @type {any} */_, /** @type {Function} */next) {
    req.tabId = opts.tabId;
    next();
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\createTabIdMiddleware.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\createTracingMiddleware.ts", {"../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CcreateTracingMiddleware.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createTracingMiddleware;
var _app = require("../../../shared/constants/app");
var _trace = require("../../../shared/lib/trace");
// Request and responses are currently untyped.

const METHOD_TYPE_TO_TRACE_NAME = {
  [_app.MESSAGE_TYPE.ETH_SEND_TRANSACTION]: _trace.TraceName.Transaction,
  [_app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA]: _trace.TraceName.Signature,
  [_app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V1]: _trace.TraceName.Signature,
  [_app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3]: _trace.TraceName.Signature,
  [_app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4]: _trace.TraceName.Signature,
  [_app.MESSAGE_TYPE.PERSONAL_SIGN]: _trace.TraceName.Signature
};
const METHOD_TYPE_TO_TAGS = {
  [_app.MESSAGE_TYPE.ETH_SEND_TRANSACTION]: {
    source: 'dapp'
  }
};
function createTracingMiddleware() {
  return async function tracingMiddleware(
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  req,
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  _res, next) {
    const {
      id,
      method
    } = req;
    const traceName = METHOD_TYPE_TO_TRACE_NAME[method];
    if (traceName) {
      req.traceContext = await (0, _trace.trace)({
        name: traceName,
        id,
        tags: METHOD_TYPE_TO_TAGS[method]
      });
      await (0, _trace.trace)({
        name: _trace.TraceName.Middleware,
        id,
        parentContext: req.traceContext
      });
    }
    next();
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\createTracingMiddleware.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\deep-links\\deep-link-router.ts", {"../../../../shared/lib/deep-links/constants":"D:\\code\\v\\metamask-extension\\shared\\lib\\deep-links\\constants.ts","../../../../shared/lib/deep-links/parse":"D:\\code\\v\\metamask-extension\\shared\\lib\\deep-links\\parse.ts","../../../../shared/lib/deep-links/routes/route":"D:\\code\\v\\metamask-extension\\shared\\lib\\deep-links\\routes\\route.ts","../../../../shared/lib/deep-links/verify":"D:\\code\\v\\metamask-extension\\shared\\lib\\deep-links\\verify.ts","../../../../shared/modules/mv3.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\mv3.utils.js","events":"D:\\code\\v\\metamask-extension\\node_modules\\events\\events.js","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","webextension-polyfill":"D:\\code\\v\\metamask-extension\\node_modules\\webextension-polyfill\\dist\\browser-polyfill.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Cdeep-links%5Cdeep-link-router.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeepLinkRouter = void 0;
var _events = _interopRequireDefault(require("events"));
var _webextensionPolyfill = _interopRequireDefault(require("webextension-polyfill"));
var _loglevel = _interopRequireDefault(require("loglevel"));
var _mv = require("../../../../shared/modules/mv3.utils");
var _parse = require("../../../../shared/lib/deep-links/parse");
var _constants = require("../../../../shared/lib/deep-links/constants");
var _route = require("../../../../shared/lib/deep-links/routes/route");
var _verify = require("../../../../shared/lib/deep-links/verify");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
// `routes.ts` seem to require routes have a leading slash, but then the
// UI always redirects it to the non-slashed version. So we just use the
// non-slashed version here to skip that redirect step.
const slashRe = /^\//u;
const TRIMMED_DEEP_LINK_ROUTE = _route.DEEP_LINK_ROUTE.replace(slashRe, '');
/**
 * Handles deep links by intercepting requests to the deep link host,
 * parsing the URL, and redirecting to the appropriate internal route.
 *
 * This class extends `EventEmitter` to allow other parts of the application
 * to listen for navigation events and errors.
 */
class DeepLinkRouter extends _events.default {
  constructor({
    getExtensionURL,
    getState
  }) {
    super();
    /**
     * The function to get the extension URL @see {@link ExtensionPlatform.getExtensionURL}
     */
    _defineProperty(this, "getExtensionURL", void 0);
    /**
     * The function to get the current state of the application.
     */
    _defineProperty(this, "getState", void 0);
    /**
     * Handles the `onBeforeRequest` event for web requests.
     *
     * @param details
     * @param details.tabId - The ID of the tab making the request.
     * @param details.url - The URL being requested.
     */
    _defineProperty(this, "handleBeforeRequest", ({
      tabId,
      url
    }) => {
      if (tabId === _webextensionPolyfill.default.tabs.TAB_ID_NONE) {
        return {};
      }
      return this.tryNavigateTo(tabId, url);
    });
    this.getExtensionURL = getExtensionURL;
    this.getState = getState;
  }

  /**
   * Formats the URL parameters for the deep link interstitial page
   *
   * @param url - The URL to format.
   * @returns The formatted URL string. This should be used as the `u` parameter
   * for the interstitial page.
   */
  formatUrlForInterstitialPage(url) {
    return url.pathname + url.search;
  }

  /**
   * Returns the URL to the 404 error page for deep links.
   *
   * @param originalUrl - The original URL that caused the error, if available.
   * @returns The URL to the 404 error page with appropriate query parameters.
   */
  get404ErrorURL(originalUrl) {
    const params = new URLSearchParams({
      errorCode: '404'
    });
    if (originalUrl) {
      params.set('u', this.formatUrlForInterstitialPage(originalUrl));
    }
    return this.getExtensionURL(TRIMMED_DEEP_LINK_ROUTE, params.toString());
  }

  /**
   * Redirects the tab to the specified URL.
   *
   * @param tabId - The ID of the tab to redirect.
   * @param url - The URL to redirect the tab to.
   */
  async redirectTab(tabId, url) {
    try {
      await _webextensionPolyfill.default.tabs.update(tabId, {
        url
      });
    } catch (error) {
      _loglevel.default.error('Error redirecting tab:', error);
      this.emit('error', error);
    }
  }
  /**
   * Installs the deep link router by adding a listener for
   * `onBeforeRequest` events for the deep link host.
   */
  install() {
    _webextensionPolyfill.default.webRequest.onBeforeRequest.addListener(this.handleBeforeRequest, {
      urls: [`*://*.${_constants.DEEP_LINK_HOST}/*`],
      // redirect only top level frames, ignore all others.
      types: ['main_frame']
    },
    // blocking is only in MV2, but is better because it lets us completely
    // replace the URL before any requests are made.
    _mv.isManifestV3 ? [] : ['blocking']);
  }

  /**
   * Uninstalls the deep link router by removing the listener
   * for `onBeforeRequest` events.
   */
  uninstall() {
    _webextensionPolyfill.default.webRequest.onBeforeRequest.removeListener(this.handleBeforeRequest);
  }

  /**
   * Attempts to navigate to the specified URL by parsing it and
   * redirecting to the appropriate internal route.
   * If the URL is invalid or too long, it redirects to the 404 error page.
   *
   * @param tabId - The ID of the tab to redirect.
   * @param urlStr - The URL string to navigate to.
   */
  async tryNavigateTo(tabId, urlStr) {
    if (urlStr.length > _constants.DEEP_LINK_MAX_LENGTH) {
      _loglevel.default.debug('Url is too long, skipping deep link handling');
      return {};
    }
    let link;
    try {
      const url = new URL(urlStr);
      const parsed = await (0, _parse.parse)(url);
      if (parsed) {
        this.emit('navigate', {
          url,
          parsed
        });
        if ('redirectTo' in parsed.destination) {
          link = parsed.destination.redirectTo.toString();
        } else if (this.canSkipInterstitial(parsed.signature)) {
          // signed links than can and should skip the interstitial page
          link = this.getExtensionURL(parsed.destination.path, parsed.destination.query.toString());
        } else {
          // unsigned links or signed links that don't skip the interstitial
          const search = new URLSearchParams({
            u: this.formatUrlForInterstitialPage(url)
          });
          link = this.getExtensionURL(TRIMMED_DEEP_LINK_ROUTE, search.toString());
        }
      } else {
        // unable to parse, show error page
        link = this.get404ErrorURL(url);
      }
    } catch (error) {
      _loglevel.default.error('Invalid URL:', urlStr, error);
      this.emit('error', error);
      // we got a route we can't handle for some reason, and we can't just
      // swallow it, so we just show the 404 error page.
      link = this.get404ErrorURL();
    }
    this.redirectTab(tabId, link);
    if (_mv.isManifestV3) {
      // We need to use the redirect API in MV3, because the webRequest API does
      // not support blocking redirects.
      return {};
    }

    // In MV2 we can't just return a `redirectUrl`, as the browser blocks the
    // redirect when requested this way. Instead, we can `cancel` the navigation
    // request, and then use our `redirectTab` method to complete the redirect.
    // This is better than the MV3 way because it avoids any network requests
    // to the deep link host, which aren't necessary so and best to avoid.
    return {
      cancel: true
    };
  }

  /**
   * Checks if the interstitial page can be skipped based on the signature status.
   * If the signature is valid and the user has opted to skip the interstitial,
   * it returns true.
   *
   * @param signatureStatus - The signature status of the deep link.
   */
  canSkipInterstitial(signatureStatus) {
    var _this$getState$prefer;
    if (signatureStatus !== _verify.VALID) {
      return false;
    }
    return Boolean((_this$getState$prefer = this.getState().preferences) === null || _this$getState$prefer === void 0 ? void 0 : _this$getState$prefer.skipDeepLinkInterstitial);
  }
}
exports.DeepLinkRouter = DeepLinkRouter;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\deep-links\\deep-link-router.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\deep-links\\metrics.ts", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Cdeep-links%5Cmetrics.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEvent = createEvent;
var _metametrics = require("../../../../shared/constants/metametrics");
const UTM_PARAMETERS = new Set(['utm_campaign', 'utm_content', 'utm_medium', 'utm_source', 'utm_term']);
/**
 * Creates a trackable Event Payload representing deep link usage.
 *
 * If the route has query params, and the query params have duplicate keys,
 * only the last value will be used in the properties.
 *
 * @param route - The parameters for the tracking event.
 * @param route.url - The original full URL of the deep link.
 * @param route.signature - Whether the deep link has a signature, and if it is
 * valid.
 */
function createEvent({
  signature,
  url
}) {
  const properties = {
    route: url.pathname,
    signature
  };
  const sensitiveProperties = {};
  for (const [key, value] of url.searchParams.entries()) {
    if (key === 'sig') {
      // don't need to include the signature itself in the properties, utm
      // params are much more useful, so `sig` would be redundant.
      continue;
    }
    if (key === 'attributionId') {
      properties.attribution_id = value;
    } else if (UTM_PARAMETERS.has(key)) {
      properties[key] = value;
    } else {
      sensitiveProperties[key] = value;
    }
  }
  return {
    category: _metametrics.MetaMetricsEventCategory.DeepLink,
    event: _metametrics.MetaMetricsEventName.DeepLinkUsed,
    properties,
    sensitiveProperties
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\deep-links\\metrics.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\encryptor-factory.ts", {"@metamask/browser-passworder":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\browser-passworder\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Cencryptor-factory.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.encryptorFactory = void 0;
var _browserPassworder = require("@metamask/browser-passworder");
/**
 * A factory function for the encrypt method of the browser-passworder library,
 * that encrypts with a given number of iterations.
 *
 * @param iterations - The number of iterations to use for the PBKDF2 algorithm.
 * @returns A function that encrypts with the given number of iterations.
 */
const encryptFactory = iterations => async (password, data, key, salt) => (0, _browserPassworder.encrypt)(password, data, key, salt, {
  algorithm: 'PBKDF2',
  params: {
    iterations
  }
});

/**
 * A factory function for the encryptWithDetail method of the browser-passworder library,
 * that encrypts with a given number of iterations.
 *
 * @param iterations - The number of iterations to use for the PBKDF2 algorithm.
 * @returns A function that encrypts with the given number of iterations.
 */
const encryptWithDetailFactory = iterations => async (password, object, salt) => (0, _browserPassworder.encryptWithDetail)(password, object, salt, {
  algorithm: 'PBKDF2',
  params: {
    iterations
  }
});

/**
 * A factory function for the keyFromPassword method of the browser-passworder library,
 * that generates a key from a password and a salt.
 *
 * This factory function overrides the default key derivation options with the specified
 * number of iterations, unless existing key derivation options are passed in.
 *
 * @param iterations - The number of iterations to use for the PBKDF2 algorithm.
 * @returns A function that generates a key with a potentially overriden number of iterations.
 */
const keyFromPasswordFactory = iterations => async (password, salt, exportable, opts) => (0, _browserPassworder.keyFromPassword)(password, salt, exportable, opts ?? {
  algorithm: 'PBKDF2',
  params: {
    iterations
  }
});

/**
 * A factory function for the isVaultUpdated method of the browser-passworder library,
 * that checks if the given vault was encrypted with the given number of iterations.
 *
 * @param iterations - The number of iterations to use for the PBKDF2 algorithm.
 * @returns A function that checks if the vault was encrypted with the given number of iterations.
 */
const isVaultUpdatedFactory = iterations => vault => (0, _browserPassworder.isVaultUpdated)(vault, {
  algorithm: 'PBKDF2',
  params: {
    iterations
  }
});

/**
 * A factory function that returns an encryptor with the given number of iterations.
 *
 * The returned encryptor is a wrapper around the browser-passworder library, that
 * calls the encrypt and encryptWithDetail methods with the given number of iterations.
 *
 * @param iterations - The number of iterations to use for the PBKDF2 algorithm.
 * @returns An encryptor set with the given number of iterations.
 */
const encryptorFactory = iterations => ({
  encrypt: encryptFactory(iterations),
  encryptWithKey: _browserPassworder.encryptWithKey,
  encryptWithDetail: encryptWithDetailFactory(iterations),
  decrypt: _browserPassworder.decrypt,
  decryptWithKey: _browserPassworder.decryptWithKey,
  decryptWithDetail: _browserPassworder.decryptWithDetail,
  keyFromPassword: keyFromPasswordFactory(iterations),
  isVaultUpdated: isVaultUpdatedFactory(iterations),
  importKey: _browserPassworder.importKey,
  exportKey: _browserPassworder.exportKey,
  generateSalt: _browserPassworder.generateSalt
});
exports.encryptorFactory = encryptorFactory;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\encryptor-factory.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\ens-ipfs\\contracts\\registry.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Cens-ipfs%5Ccontracts%5Cregistry.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
const abi = [{
  constant: true,
  inputs: [{
    name: 'node',
    type: 'bytes32'
  }],
  name: 'resolver',
  outputs: [{
    name: '',
    type: 'address'
  }],
  payable: false,
  type: 'function'
}, {
  constant: true,
  inputs: [{
    name: 'node',
    type: 'bytes32'
  }],
  name: 'owner',
  outputs: [{
    name: '',
    type: 'address'
  }],
  payable: false,
  type: 'function'
}, {
  constant: false,
  inputs: [{
    name: 'node',
    type: 'bytes32'
  }, {
    name: 'label',
    type: 'bytes32'
  }, {
    name: 'owner',
    type: 'address'
  }],
  name: 'setSubnodeOwner',
  outputs: [],
  payable: false,
  type: 'function'
}, {
  constant: false,
  inputs: [{
    name: 'node',
    type: 'bytes32'
  }, {
    name: 'ttl',
    type: 'uint64'
  }],
  name: 'setTTL',
  outputs: [],
  payable: false,
  type: 'function'
}, {
  constant: true,
  inputs: [{
    name: 'node',
    type: 'bytes32'
  }],
  name: 'ttl',
  outputs: [{
    name: '',
    type: 'uint64'
  }],
  payable: false,
  type: 'function'
}, {
  constant: false,
  inputs: [{
    name: 'node',
    type: 'bytes32'
  }, {
    name: 'resolver',
    type: 'address'
  }],
  name: 'setResolver',
  outputs: [],
  payable: false,
  type: 'function'
}, {
  constant: false,
  inputs: [{
    name: 'node',
    type: 'bytes32'
  }, {
    name: 'owner',
    type: 'address'
  }],
  name: 'setOwner',
  outputs: [],
  payable: false,
  type: 'function'
}, {
  anonymous: false,
  inputs: [{
    indexed: true,
    name: 'node',
    type: 'bytes32'
  }, {
    indexed: false,
    name: 'owner',
    type: 'address'
  }],
  name: 'Transfer',
  type: 'event'
}, {
  anonymous: false,
  inputs: [{
    indexed: true,
    name: 'node',
    type: 'bytes32'
  }, {
    indexed: true,
    name: 'label',
    type: 'bytes32'
  }, {
    indexed: false,
    name: 'owner',
    type: 'address'
  }],
  name: 'NewOwner',
  type: 'event'
}, {
  anonymous: false,
  inputs: [{
    indexed: true,
    name: 'node',
    type: 'bytes32'
  }, {
    indexed: false,
    name: 'resolver',
    type: 'address'
  }],
  name: 'NewResolver',
  type: 'event'
}, {
  anonymous: false,
  inputs: [{
    indexed: true,
    name: 'node',
    type: 'bytes32'
  }, {
    indexed: false,
    name: 'ttl',
    type: 'uint64'
  }],
  name: 'NewTTL',
  type: 'event'
}];
var _default = exports.default = abi;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\ens-ipfs\\contracts\\registry.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\ens-ipfs\\contracts\\resolver.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Cens-ipfs%5Ccontracts%5Cresolver.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
const abi = [{
  constant: false,
  inputs: [{
    name: 'node',
    type: 'bytes32'
  }, {
    name: 'hash',
    type: 'bytes32'
  }],
  name: 'setContent',
  outputs: [],
  payable: false,
  stateMutability: 'nonpayable',
  type: 'function'
}, {
  constant: true,
  inputs: [{
    name: 'node',
    type: 'bytes32'
  }],
  name: 'content',
  outputs: [{
    name: '',
    type: 'bytes32'
  }],
  payable: false,
  stateMutability: 'view',
  type: 'function'
}, {
  constant: true,
  inputs: [{
    name: 'interfaceID',
    type: 'bytes4'
  }],
  name: 'supportsInterface',
  outputs: [{
    name: '',
    type: 'bool'
  }],
  payable: false,
  stateMutability: 'pure',
  type: 'function'
}, {
  constant: false,
  inputs: [{
    name: 'node',
    type: 'bytes32'
  }, {
    name: 'key',
    type: 'string'
  }, {
    name: 'value',
    type: 'string'
  }],
  name: 'setText',
  outputs: [],
  payable: false,
  stateMutability: 'nonpayable',
  type: 'function'
}, {
  constant: true,
  inputs: [{
    name: 'node',
    type: 'bytes32'
  }, {
    name: 'contentTypes',
    type: 'uint256'
  }],
  name: 'ABI',
  outputs: [{
    name: 'contentType',
    type: 'uint256'
  }, {
    name: 'data',
    type: 'bytes'
  }],
  payable: false,
  stateMutability: 'view',
  type: 'function'
}, {
  constant: false,
  inputs: [{
    name: 'node',
    type: 'bytes32'
  }, {
    name: 'x',
    type: 'bytes32'
  }, {
    name: 'y',
    type: 'bytes32'
  }],
  name: 'setPubkey',
  outputs: [],
  payable: false,
  stateMutability: 'nonpayable',
  type: 'function'
}, {
  constant: false,
  inputs: [{
    name: 'node',
    type: 'bytes32'
  }, {
    name: 'hash',
    type: 'bytes'
  }],
  name: 'setContenthash',
  outputs: [],
  payable: false,
  stateMutability: 'nonpayable',
  type: 'function'
}, {
  constant: true,
  inputs: [{
    name: 'node',
    type: 'bytes32'
  }],
  name: 'addr',
  outputs: [{
    name: '',
    type: 'address'
  }],
  payable: false,
  stateMutability: 'view',
  type: 'function'
}, {
  constant: true,
  inputs: [{
    name: 'node',
    type: 'bytes32'
  }, {
    name: 'key',
    type: 'string'
  }],
  name: 'text',
  outputs: [{
    name: '',
    type: 'string'
  }],
  payable: false,
  stateMutability: 'view',
  type: 'function'
}, {
  constant: false,
  inputs: [{
    name: 'node',
    type: 'bytes32'
  }, {
    name: 'contentType',
    type: 'uint256'
  }, {
    name: 'data',
    type: 'bytes'
  }],
  name: 'setABI',
  outputs: [],
  payable: false,
  stateMutability: 'nonpayable',
  type: 'function'
}, {
  constant: true,
  inputs: [{
    name: 'node',
    type: 'bytes32'
  }],
  name: 'name',
  outputs: [{
    name: '',
    type: 'string'
  }],
  payable: false,
  stateMutability: 'view',
  type: 'function'
}, {
  constant: false,
  inputs: [{
    name: 'node',
    type: 'bytes32'
  }, {
    name: 'name',
    type: 'string'
  }],
  name: 'setName',
  outputs: [],
  payable: false,
  stateMutability: 'nonpayable',
  type: 'function'
}, {
  constant: true,
  inputs: [{
    name: 'node',
    type: 'bytes32'
  }],
  name: 'contenthash',
  outputs: [{
    name: '',
    type: 'bytes'
  }],
  payable: false,
  stateMutability: 'view',
  type: 'function'
}, {
  constant: true,
  inputs: [{
    name: 'node',
    type: 'bytes32'
  }],
  name: 'pubkey',
  outputs: [{
    name: 'x',
    type: 'bytes32'
  }, {
    name: 'y',
    type: 'bytes32'
  }],
  payable: false,
  stateMutability: 'view',
  type: 'function'
}, {
  constant: false,
  inputs: [{
    name: 'node',
    type: 'bytes32'
  }, {
    name: 'addr',
    type: 'address'
  }],
  name: 'setAddr',
  outputs: [],
  payable: false,
  stateMutability: 'nonpayable',
  type: 'function'
}, {
  inputs: [{
    name: 'ensAddr',
    type: 'address'
  }],
  payable: false,
  stateMutability: 'nonpayable',
  type: 'constructor'
}, {
  anonymous: false,
  inputs: [{
    indexed: true,
    name: 'node',
    type: 'bytes32'
  }, {
    indexed: false,
    name: 'a',
    type: 'address'
  }],
  name: 'AddrChanged',
  type: 'event'
}, {
  anonymous: false,
  inputs: [{
    indexed: true,
    name: 'node',
    type: 'bytes32'
  }, {
    indexed: false,
    name: 'name',
    type: 'string'
  }],
  name: 'NameChanged',
  type: 'event'
}, {
  anonymous: false,
  inputs: [{
    indexed: true,
    name: 'node',
    type: 'bytes32'
  }, {
    indexed: true,
    name: 'contentType',
    type: 'uint256'
  }],
  name: 'ABIChanged',
  type: 'event'
}, {
  anonymous: false,
  inputs: [{
    indexed: true,
    name: 'node',
    type: 'bytes32'
  }, {
    indexed: false,
    name: 'x',
    type: 'bytes32'
  }, {
    indexed: false,
    name: 'y',
    type: 'bytes32'
  }],
  name: 'PubkeyChanged',
  type: 'event'
}, {
  anonymous: false,
  inputs: [{
    indexed: true,
    name: 'node',
    type: 'bytes32'
  }, {
    indexed: false,
    name: 'indexedKey',
    type: 'string'
  }, {
    indexed: false,
    name: 'key',
    type: 'string'
  }],
  name: 'TextChanged',
  type: 'event'
}, {
  anonymous: false,
  inputs: [{
    indexed: true,
    name: 'node',
    type: 'bytes32'
  }, {
    indexed: false,
    name: 'hash',
    type: 'bytes'
  }],
  name: 'ContenthashChanged',
  type: 'event'
}];
var _default = exports.default = abi;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\ens-ipfs\\contracts\\resolver.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\ens-ipfs\\resolver.js", {"./contracts/registry":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\ens-ipfs\\contracts\\registry.js","./contracts/resolver":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\ens-ipfs\\contracts\\resolver.js","@ensdomains/content-hash":"D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\src\\index.js","@ethersproject/contracts":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\contracts\\lib\\index.js","@ethersproject/providers":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\providers\\lib\\index.js","eth-ens-namehash":"D:\\code\\v\\metamask-extension\\node_modules\\eth-ens-namehash\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Cens-ipfs%5Cresolver.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = resolveEnsToIpfsContentId;
var _ethEnsNamehash = _interopRequireDefault(require("eth-ens-namehash"));
var _contentHash = _interopRequireDefault(require("@ensdomains/content-hash"));
var _providers = require("@ethersproject/providers");
var _contracts = require("@ethersproject/contracts");
var _registry = _interopRequireDefault(require("./contracts/registry"));
var _resolver = _interopRequireDefault(require("./contracts/resolver"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
async function resolveEnsToIpfsContentId({
  provider,
  name
}) {
  const hash = _ethEnsNamehash.default.hash(name);

  // lookup registry
  const chainId = Number.parseInt(await provider.request({
    method: 'net_version'
  }), 10);
  const registryAddress = getRegistryForChainId(chainId);
  if (!registryAddress) {
    throw new Error(`EnsIpfsResolver - no known ens-ipfs registry for chainId "${chainId}"`);
  }
  const web3Provider = new _providers.Web3Provider(provider);
  const registryContract = new _contracts.Contract(registryAddress, _registry.default, web3Provider);
  // lookup resolver
  const resolverAddress = await registryContract.resolver(hash);
  if (hexValueIsEmpty(resolverAddress)) {
    throw new Error(`EnsIpfsResolver - no resolver found for name "${name}"`);
  }
  const resolverContract = new _contracts.Contract(resolverAddress, _resolver.default, web3Provider);
  const isEIP1577Compliant = await resolverContract.supportsInterface('0xbc1c58d1');
  const isLegacyResolver = await resolverContract.supportsInterface('0xd8389dc5');
  if (isEIP1577Compliant) {
    const rawContentHash = await resolverContract.contenthash(hash);
    let decodedContentHash = _contentHash.default.decode(rawContentHash);
    const type = _contentHash.default.getCodec(rawContentHash);
    if (type === 'ipfs-ns' || type === 'ipns-ns') {
      decodedContentHash = _contentHash.default.helpers.cidV0ToV1Base32(decodedContentHash);
    }
    return {
      type,
      hash: decodedContentHash
    };
  }
  if (isLegacyResolver) {
    // lookup content id
    const content = await resolverContract.content(hash);
    if (hexValueIsEmpty(content)) {
      throw new Error(`EnsIpfsResolver - no content ID found for name "${name}"`);
    }
    return {
      type: 'swarm-ns',
      hash: content.slice(2)
    };
  }
  throw new Error(`EnsIpfsResolver - the resolver for name "${name}" is not standard, it should either supports contenthash() or content()`);
}
function hexValueIsEmpty(value) {
  return [undefined, null, '0x', '0x0', '0x0000000000000000000000000000000000000000000000000000000000000000'].includes(value);
}

/**
 * Returns the registry address for the given chain ID
 *
 * @param {number} chainId - the chain ID
 * @returns {string|null} the registry address if known, null otherwise
 */
function getRegistryForChainId(chainId) {
  switch (chainId) {
    case 1:
    case 3:
    case 4:
    case 5:
    case 6:
      // Mainnet and Goerli, respectively, use the same address
      return '0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e';
    default:
      return null;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\ens-ipfs\\resolver.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\ens-ipfs\\setup.js", {"../../../../shared/modules/fetch-with-timeout":"D:\\code\\v\\metamask-extension\\shared\\modules\\fetch-with-timeout.ts","./resolver":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\ens-ipfs\\resolver.js","base32-encode":"D:\\code\\v\\metamask-extension\\node_modules\\base32-encode\\index.js","base64-js":"D:\\code\\v\\metamask-extension\\node_modules\\base64-js\\index.js","webextension-polyfill":"D:\\code\\v\\metamask-extension\\node_modules\\webextension-polyfill\\dist\\browser-polyfill.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Cens-ipfs%5Csetup.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = setupEnsIpfsResolver;
var _base32Encode = _interopRequireDefault(require("base32-encode"));
var _base64Js = _interopRequireDefault(require("base64-js"));
var _webextensionPolyfill = _interopRequireDefault(require("webextension-polyfill"));
var _fetchWithTimeout = _interopRequireDefault(require("../../../../shared/modules/fetch-with-timeout"));
var _resolver = _interopRequireDefault(require("./resolver"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const fetchWithTimeout = (0, _fetchWithTimeout.default)();
const supportedTopLevelDomains = ['eth'];
function setupEnsIpfsResolver({
  provider,
  getCurrentChainId,
  getIpfsGateway,
  getUseAddressBarEnsResolution
}) {
  // install listener
  const urlPatterns = supportedTopLevelDomains.map(tld => `*://*.${tld}/*`);
  _webextensionPolyfill.default.webRequest.onErrorOccurred.addListener(webRequestDidFail, {
    urls: urlPatterns,
    types: ['main_frame']
  });

  // return api object
  return {
    // uninstall listener
    remove() {
      _webextensionPolyfill.default.webRequest.onErrorOccurred.removeListener(webRequestDidFail);
    }
  };
  async function webRequestDidFail(details) {
    const {
      tabId,
      url
    } = details;
    // ignore requests that are not associated with tabs
    // only attempt ENS resolution on mainnet
    if ((tabId === -1 || getCurrentChainId() !== '0x1') &&
    // E2E tests use a chain other than 0x1, so for testing,
    // allow the reuqest to pass through
    !false) {
      return;
    }
    // parse ens name
    const {
      hostname: name,
      pathname,
      search,
      hash: fragment
    } = new URL(url);
    const domainParts = name.split('.');
    const topLevelDomain = domainParts[domainParts.length - 1];
    // if unsupported TLD, abort
    if (!supportedTopLevelDomains.includes(topLevelDomain)) {
      return;
    }
    // otherwise attempt resolve
    attemptResolve({
      tabId,
      name,
      pathname,
      search,
      fragment
    });
  }
  async function attemptResolve({
    tabId,
    name,
    pathname,
    search,
    fragment
  }) {
    const ipfsGateway = getIpfsGateway();
    const useAddressBarEnsResolution = getUseAddressBarEnsResolution();
    const ensSiteUrl = `https://app.ens.domains/name/${name}`;

    // We cannot show this if useAddressBarEnsResolution is off...
    if (useAddressBarEnsResolution && ipfsGateway) {
      await _webextensionPolyfill.default.tabs.update(tabId, {
        url: 'loading.html'
      });
    }
    let url = ensSiteUrl;

    // If we're testing ENS domain resolution support,
    // we assume the ENS domains URL
    if (false) {
      if (useAddressBarEnsResolution || ipfsGateway) {
        await _webextensionPolyfill.default.tabs.update(tabId, {
          url
        });
      }
      return;
    }
    try {
      const {
        type,
        hash
      } = await (0, _resolver.default)({
        provider,
        name
      });
      if (type === 'ipfs-ns' || type === 'ipns-ns') {
        // If the ENS is via IPFS and that setting is disabled,
        // Do not resolve the ENS
        if (ipfsGateway === '') {
          url = null;
          return;
        }
        const resolvedUrl = `https://${hash}.${type.slice(0, 4)}.${ipfsGateway}${pathname}${search || ''}${fragment || ''}`;
        try {
          // check if ipfs gateway has result
          const response = await fetchWithTimeout(resolvedUrl, {
            method: 'HEAD'
          });
          if (response.status === 200) {
            url = resolvedUrl;
          }
        } catch (err) {
          console.warn(err);
        }
      } else if (type === 'swarm-ns') {
        url = `https://swarm-gateways.net/bzz:/${hash}${pathname}${search || ''}${fragment || ''}`;
      } else if (type === 'onion' || type === 'onion3') {
        url = `http://${hash}.onion${pathname}${search || ''}${fragment || ''}`;
      } else if (type === 'zeronet') {
        url = `http://127.0.0.1:43110/${hash}${pathname}${search || ''}${fragment || ''}`;
      } else if (type === 'skynet-ns') {
        const padded = hash.padEnd(hash.length + 4 - hash.length % 4, '=');
        const decoded = _base64Js.default.toByteArray(padded);
        const options = {
          padding: false
        };
        const base32EncodedSkylink = (0, _base32Encode.default)(decoded, 'RFC4648-HEX', options).toLowerCase();
        url = `https://${base32EncodedSkylink}.siasky.net${pathname}${search || ''}${fragment || ''}`;
      }
    } catch (err) {
      console.warn(err);
    } finally {
      // Only forward to destination URL if a URL exists and
      // useAddressBarEnsResolution is properly
      if (url && (useAddressBarEnsResolution || !useAddressBarEnsResolution && url !== ensSiteUrl)) {
        await _webextensionPolyfill.default.tabs.update(tabId, {
          url
        });
      }
    }
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\ens-ipfs\\setup.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\forwardRequestToSnap.ts", {"@metamask/snaps-sdk":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CforwardRequestToSnap.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.forwardRequestToSnap = forwardRequestToSnap;
var _snapsUtils = require("@metamask/snaps-utils");
var _snapsSdk = require("@metamask/snaps-sdk");
/**
 * Forwards a JSON-RPC request to a specified Snap by invoking its `handleRequest` method.
 * Throws an error if no snapId is provided.
 *
 * @param config - The config for forwarding the request.
 * @param config.handleRequest - The SnapController's handleRequest function.
 * @param config.snapId - The ID of the Snap to forward the request to.
 * @param _params - Additional parameters, including the request ID.
 * @param _params.id - The request ID.
 * @param req - The JSON-RPC request object.
 * @returns The response from the Snap as JSON.
 */
async function forwardRequestToSnap(config, _params, req) {
  const {
    method,
    params,
    origin
  } = req;
  const {
    handleRequest,
    snapId
  } = config;
  if (!snapId) {
    throw new _snapsSdk.InternalError(`No snapId configured for method ${method}`);
  }
  if (!origin) {
    throw new _snapsSdk.InternalError(`No origin specified for method ${method}`);
  }
  const response = await handleRequest({
    snapId,
    origin,
    handler: _snapsUtils.HandlerType.OnRpcRequest,
    request: {
      jsonrpc: '2.0',
      method,
      params
    }
  });
  return response;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\forwardRequestToSnap.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\getObjStructure.js", {"lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CgetObjStructure.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getObjStructure;
var _lodash = require("lodash");
// This will create an object that represents the structure of the given object
// it replaces all values with the result of their type

// {
//   "data": {
//     "CurrencyController": {
//       "currentCurrency": "string"
//       "currencyRates": {
//         "ETH": {
//           "conversionDate": "number",
//           "conversionRate": "number",
//           "usdConversionRate": "number",
//         }
//       },
//     }
// }

/**
 * Creates an object that represents the structure of the given object. It replaces all values with the result of their
 * type.
 *
 * @param {object} obj - The object for which a 'structure' will be returned. Usually a plain object and not a class.
 * @returns {object} The "mapped" version of a deep clone of the passed object, with each non-object property value
 * replaced with the javascript type of that value.
 */
function getObjStructure(obj) {
  const structure = (0, _lodash.cloneDeep)(obj);
  return deepMap(structure, value => {
    return value === null ? 'null' : typeof value;
  });
}

/**
 * Modifies all the properties and deeply nested of a passed object. Iterates recursively over all nested objects and
 * their properties, and covers the entire depth of the object. At each property value which is not an object is modified.
 *
 * @param {object} target - The object to modify
 * @param {Function} visit - The modifier to apply to each non-object property value
 * @returns {object} The modified object
 */
function deepMap(target = {}, visit) {
  Object.entries(target).forEach(([key, value]) => {
    if (typeof value === 'object' && value !== null) {
      target[key] = deepMap(value, visit);
    } else {
      target[key] = visit(value);
    }
  });
  return target;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\getObjStructure.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\hardware-keyring-builder-factory.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Chardware-keyring-builder-factory.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hardwareKeyringBuilderFactory = hardwareKeyringBuilderFactory;
/**
 * A transport bridge between the keyring and the hardware device.
 */

/**
 * Get builder function for Hardware keyrings which require an additional `opts`
 * parameter, used to pass the transport bridge used by the keyring.
 *
 * Returns a builder function for `Keyring` with a `type` property.
 *
 * @param Keyring - The Keyring class for the builder.
 * @param Bridge - The transport bridge class to use for the given Keyring.
 * @returns A builder function for the given Keyring.
 */
function hardwareKeyringBuilderFactory(Keyring, Bridge) {
  const builder = () => new Keyring({
    bridge: new Bridge()
  });
  builder.type = Keyring.type;
  return builder;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\hardware-keyring-builder-factory.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\middleware\\pending.js", {"../util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","@metamask/json-rpc-engine":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-engine\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Cmiddleware%5Cpending.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPendingNonceMiddleware = createPendingNonceMiddleware;
exports.createPendingTxMiddleware = createPendingTxMiddleware;
var _jsonRpcEngine = require("@metamask/json-rpc-engine");
var _util = require("../util");
function createPendingNonceMiddleware({
  getPendingNonce
}) {
  return (0, _jsonRpcEngine.createAsyncMiddleware)(async (req, res, next) => {
    const {
      method,
      params
    } = req;
    if (method !== 'eth_getTransactionCount') {
      next();
      return;
    }
    const [param, blockRef] = params;
    if (blockRef !== 'pending') {
      next();
      return;
    }
    res.result = await getPendingNonce(param, req.networkClientId);
  });
}
function createPendingTxMiddleware({
  getPendingTransactionByHash
}) {
  return (0, _jsonRpcEngine.createAsyncMiddleware)(async (req, res, next) => {
    const {
      method,
      params
    } = req;
    if (method !== 'eth_getTransactionByHash') {
      next();
      return;
    }
    const [hash] = params;
    const txMeta = getPendingTransactionByHash(hash);
    if (!txMeta) {
      next();
      return;
    }
    res.result = (0, _util.formatTxMetaForRpcResult)(txMeta);
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\middleware\\pending.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\migrator\\index.js", {"events":"D:\\code\\v\\metamask-extension\\node_modules\\events\\events.js","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Cmigrator%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _events = _interopRequireDefault(require("events"));
var _loglevel = _interopRequireDefault(require("loglevel"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * @typedef {object} Migration
 * @property {number} version - The migration version
 * @property {Function} migrate - Returns a promise of the migrated data
 */

/**
 * @typedef {object} MigratorOptions
 * @property {Array<Migration>} [migrations] - The list of migrations to apply
 * @property {number} [defaultVersion] - The version to use in the initial state
 */

class Migrator extends _events.default {
  /**
   * @param {MigratorOptions} opts
   */
  constructor(opts = {}) {
    super();
    const migrations = opts.migrations || [];
    // sort migrations by version
    this.migrations = migrations.sort((a, b) => a.version - b.version);
    // grab migration with highest version
    const lastMigration = this.migrations.slice(-1)[0];
    // use specified defaultVersion or highest migration version
    this.defaultVersion = opts.defaultVersion || lastMigration && lastMigration.version || 0;
  }

  // run all pending migrations on meta in place
  async migrateData(versionedData = this.generateInitialState()) {
    // get all migrations that have not yet been run
    const pendingMigrations = this.migrations.filter(migrationIsPending);

    // perform each migration
    for (const migration of pendingMigrations) {
      try {
        _loglevel.default.info(`Running migration ${migration.version}...`);

        // attempt migration and validate
        const migratedData = await migration.migrate(versionedData);
        if (!migratedData.data) {
          throw new Error('Migrator - migration returned empty data');
        }
        if (migratedData.version !== undefined && migratedData.meta.version !== migration.version) {
          throw new Error('Migrator - Migration did not update version number correctly');
        }
        // accept the migration as good
        // eslint-disable-next-line no-param-reassign
        versionedData = migratedData;
        _loglevel.default.info(`Migration ${migration.version} complete`);
      } catch (err) {
        // rewrite error message to add context without clobbering stack
        const originalErrorMessage = err.message;
        err.message = `MetaMask Migration Error #${migration.version}: ${originalErrorMessage}`;
        // emit error instead of throw so as to not break the run (gracefully fail)
        this.emit('error', err);
        // stop migrating and use state as is
        return versionedData;
      }
    }
    return versionedData;

    /**
     * Returns whether or not the migration is pending
     *
     * A migration is considered "pending" if it has a higher
     * version number than the current version.
     *
     * @param {Migration} migration
     * @returns {boolean}
     */
    function migrationIsPending(migration) {
      return migration.version > versionedData.meta.version;
    }
  }

  /**
   * Returns the initial state for the migrator
   *
   * @param {object} [data] - The data for the initial state
   * @returns {{data: object, meta: {version: number}}}
   */
  generateInitialState(data) {
    return {
      data,
      meta: {
        version: this.defaultVersion
      }
    };
  }
}
exports.default = Migrator;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\migrator\\index.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\network-controller\\messenger-action-handlers.ts", {"../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/lib/network-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\network-utils.ts","../../../../shared/lib/only-keep-host":"D:\\code\\v\\metamask-extension\\shared\\lib\\only-keep-host.ts","./utils":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\network-controller\\utils.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Cnetwork-controller%5Cmessenger-action-handlers.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onRpcEndpointDegraded = onRpcEndpointDegraded;
exports.onRpcEndpointUnavailable = onRpcEndpointUnavailable;
exports.trackRpcEndpointEvent = trackRpcEndpointEvent;
var _loglevel = _interopRequireDefault(require("loglevel"));
var _utils = require("@metamask/utils");
var _metametrics = require("../../../../shared/constants/metametrics");
var _onlyKeepHost = require("../../../../shared/lib/only-keep-host");
var _networkUtils = require("../../../../shared/lib/network-utils");
var _utils2 = require("./utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Called when an endpoint is determined to be "unavailable". Creates a Segment
 * event so we can understand failures better and so that we can automatically
 * activate Quicknode when Infura is down.
 *
 * Note that in production we do not create events *every* time an endpoint is
 * unavailable. In the case where the endpoint is truly down, this would create
 * millions of events and we would blow past our Segment quota. Instead we only
 * create an event 1% of the time.
 *
 * @param args - The arguments.
 * @param args.chainId - The chain ID that the endpoint represents.
 * @param args.endpointUrl - The URL of the endpoint.
 * @param args.error - The connection or response error encountered after making
 * a request to the RPC endpoint.
 * @param args.infuraProjectId - Our Infura project ID.
 * @param args.metaMetricsId - The MetaMetrics ID of the user.
 * @param args.trackEvent - The function that will create the Segment event.
 */
function onRpcEndpointUnavailable({
  chainId,
  endpointUrl,
  error,
  infuraProjectId,
  metaMetricsId,
  trackEvent
}) {
  trackRpcEndpointEvent(_metametrics.MetaMetricsEventName.RpcServiceUnavailable, {
    chainId,
    endpointUrl,
    error,
    infuraProjectId,
    metaMetricsId,
    trackEvent
  });
}

/**
 * Called when an endpoint is determined to be "degraded". Creates a Segment
 * event so we can understand failures better.
 *
 * Note that in production we do not create events *every* time an endpoint is
 * unavailable. In the case where the endpoint is down, this would create
 * millions of events and we would blow past our Segment quota. Instead we only
 * create an event 1% of the time.
 *
 * @param args - The arguments.
 * @param args.chainId - The chain ID that the endpoint represents.
 * @param args.endpointUrl - The URL of the endpoint.
 * @param args.error - The connection or response error encountered after making
 * a request to the RPC endpoint.
 * @param args.infuraProjectId - Our Infura project ID.
 * @param args.metaMetricsId - The MetaMetrics ID of the user.
 * @param args.trackEvent - The function that will create the Segment event.
 */
function onRpcEndpointDegraded({
  chainId,
  endpointUrl,
  error,
  infuraProjectId,
  metaMetricsId,
  trackEvent
}) {
  trackRpcEndpointEvent(_metametrics.MetaMetricsEventName.RpcServiceDegraded, {
    chainId,
    endpointUrl,
    error,
    infuraProjectId,
    metaMetricsId,
    trackEvent
  });
}

/**
 * Creates a Segment event when an RPC endpoint is determined to be degraded or
 * unavailable.
 *
 * @param event - The Segment event to create.
 * @param args - The remaining arguments.
 * @param args.chainId - The chain ID that the endpoint represents.
 * @param args.endpointUrl - The URL of the endpoint.
 * @param args.error - The connection or response error encountered after making
 * a request to the RPC endpoint.
 * @param args.infuraProjectId - Our Infura project ID.
 * @param args.metaMetricsId - The MetaMetrics ID of the user.
 * @param args.trackEvent - The function that will create the Segment event.
 */
function trackRpcEndpointEvent(event, {
  chainId,
  endpointUrl,
  error,
  infuraProjectId,
  trackEvent,
  metaMetricsId
}) {
  if (!(0, _utils2.shouldCreateRpcServiceEvents)({
    error,
    metaMetricsId
  })) {
    return;
  }

  // The names of Segment properties have a particular case.
  /* eslint-disable @typescript-eslint/naming-convention */
  const properties = {
    chain_id_caip: `eip155:${(0, _utils.hexToNumber)(chainId)}`,
    rpc_endpoint_url: (0, _networkUtils.isPublicEndpointUrl)(endpointUrl, infuraProjectId) ? (0, _onlyKeepHost.onlyKeepHost)(endpointUrl) : 'custom',
    ...((0, _utils.isObject)(error) && 'httpStatus' in error && (0, _utils.isValidJson)(error.httpStatus) ? {
      http_status: error.httpStatus
    } : {})
  };
  /* eslint-enable @typescript-eslint/naming-convention */

  _loglevel.default.debug(`Creating Segment event "${event}" with ${JSON.stringify(properties)}`);
  trackEvent({
    category: _metametrics.MetaMetricsEventCategory.Network,
    event,
    properties
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\network-controller\\messenger-action-handlers.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\network-controller\\utils.ts", {"../../../../development/build/constants":"D:\\code\\v\\metamask-extension\\development\\build\\constants.js","@metamask/network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-controller\\dist\\index.cjs","@metamask/remote-feature-flag-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\remote-feature-flag-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Cnetwork-controller%5Cutils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PRODUCTION_LIKE_ENVIRONMENTS = void 0;
exports.shouldCreateRpcServiceEvents = shouldCreateRpcServiceEvents;
var _networkController = require("@metamask/network-controller");
var _remoteFeatureFlagController = require("@metamask/remote-feature-flag-controller");
var _constants = require("../../../../development/build/constants");
/**
 * We capture Segment events for degraded or unavailable RPC endpoints for 1%
 * of our userbase.
 */
const SAMPLING_RATE = 0.01;

/**
 * Environments that are expected to resemble production, or production itself.
 */
const PRODUCTION_LIKE_ENVIRONMENTS = exports.PRODUCTION_LIKE_ENVIRONMENTS = [_constants.ENVIRONMENT.PRODUCTION, _constants.ENVIRONMENT.RELEASE_CANDIDATE];

/**
 * Events should only be created in Segment when an RPC endpoint is detected to
 * be degraded or unavailable if:
 *
 * - The RPC endpoint is slow
 * - The user does not have local connectivity issues
 * - The user is in the MetaMetrics sample
 *
 * @param args - The arguments.
 * @param args.error - The connection or response error encountered after making
 * a request to the RPC endpoint.
 * @param args.metaMetricsId - The MetaMetrics ID of the user.
 * @returns True if Segment events should be created, false otherwise.
 */
function shouldCreateRpcServiceEvents({
  error,
  metaMetricsId
}) {
  return (!error || !(0, _networkController.isConnectionError)(error)) && metaMetricsId !== undefined && metaMetricsId !== null && isSamplingMetaMetricsUser(metaMetricsId);
}

/**
 * Determines whether the user is included in the sample for MetaMetrics.
 *
 * In production and for a release candidate, we sample only 1% of the available
 * events; in development and testing we create every event.
 *
 * @param metaMetricsId - The MetaMetrics ID of the user.
 * @returns True if the user is included in the sample for MetaMetrics, false
 * otherwise.
 */
function isSamplingMetaMetricsUser(metaMetricsId) {
  if ("development" === undefined) {
    return false;
  }
  if (PRODUCTION_LIKE_ENVIRONMENTS.includes("development")) {
    return (0, _remoteFeatureFlagController.generateDeterministicRandomNumber)(metaMetricsId) < SAMPLING_RATE;
  }
  return true;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\network-controller\\utils.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\notification-manager.js", {"../../../shared/constants/notifications":"D:\\code\\v\\metamask-extension\\shared\\constants\\notifications.ts","../platforms/extension":"D:\\code\\v\\metamask-extension\\app\\scripts\\platforms\\extension.js","@metamask/safe-event-emitter":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\safe-event-emitter\\dist\\cjs\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Cnotification-manager.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.NOTIFICATION_MANAGER_EVENTS = void 0;
var _safeEventEmitter = _interopRequireDefault(require("@metamask/safe-event-emitter"));
var _extension = _interopRequireDefault(require("../platforms/extension"));
var _notifications = require("../../../shared/constants/notifications");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NOTIFICATION_MANAGER_EVENTS = exports.NOTIFICATION_MANAGER_EVENTS = {
  POPUP_CLOSED: 'onPopupClosed'
};

/**
 * A collection of methods for controlling the showing and hiding of the notification popup.
 */
class NotificationManager extends _safeEventEmitter.default {
  constructor() {
    super();
    this.platform = new _extension.default();
    this.platform.addOnRemovedListener(this._onWindowClosed.bind(this));
  }

  /**
   * Mark the notification popup as having been automatically closed.
   *
   * This lets us differentiate between the cases where we close the
   * notification popup v.s. when the user closes the popup window directly.
   */
  markAsAutomaticallyClosed() {
    this._popupAutomaticallyClosed = true;
  }

  /**
   * Either brings an existing MetaMask notification window into focus, or creates a new notification window. New
   * notification windows are given a 'popup' type.
   *
   * @param {Function} setCurrentPopupId - setter of current popup id from appStateController
   * @param {number} currentPopupId - id of current opened metamask popup window
   */
  async showPopup(setCurrentPopupId, currentPopupId) {
    this._popupId = currentPopupId;
    this._setCurrentPopupId = setCurrentPopupId;
    const popup = await this._getPopup(currentPopupId);
    // Bring focus to chrome popup
    if (popup) {
      // bring focus to existing chrome popup
      await this.platform.focusWindow(popup.id);
    } else {
      // create new notification popup
      let left = 0;
      let top = 0;
      try {
        const lastFocused = await this.platform.getLastFocusedWindow();
        // Position window in top right corner of lastFocused window.
        top = lastFocused.top;
        // - this is to make sure no error is triggered from polyfill
        // error eg: Invalid value for bounds. Bounds must be at least 50% within visible screen space.
        left = Math.max(lastFocused.left + (lastFocused.width - _notifications.NOTIFICATION_WIDTH), 0);
      } catch (_) {
        // The following properties are more than likely 0, due to being
        // opened from the background chrome process for the extension that
        // has no physical dimensions
        const {
          screenX,
          screenY,
          outerWidth
        } = window;
        top = Math.max(screenY, 0);
        left = Math.max(screenX + (outerWidth - _notifications.NOTIFICATION_WIDTH), 0);
      }
      const popupWindow = await this.platform.openWindow({
        url: 'notification.html',
        type: 'popup',
        width: _notifications.NOTIFICATION_WIDTH,
        height: _notifications.NOTIFICATION_HEIGHT,
        left,
        top
      });

      // Firefox currently ignores left/top for create, but it works for update
      if (popupWindow.left !== left && popupWindow.state !== 'fullscreen') {
        await this.platform.updateWindowPosition(popupWindow.id, left, top);
      }
      // pass new created popup window id to appController setter
      // and store the id to private variable this._popupId for future access
      this._setCurrentPopupId(popupWindow.id);
      this._popupId = popupWindow.id;
    }
  }
  _onWindowClosed(windowId) {
    if (windowId === this._popupId) {
      this._setCurrentPopupId(undefined);
      this._popupId = undefined;
      this.emit(NOTIFICATION_MANAGER_EVENTS.POPUP_CLOSED, {
        automaticallyClosed: this._popupAutomaticallyClosed
      });
      this._popupAutomaticallyClosed = undefined;
    }
  }

  /**
   * Checks all open MetaMask windows, and returns the first one it finds that is a notification window (i.e. has the
   * type 'popup')
   *
   * @private
   */
  async _getPopup() {
    const windows = await this.platform.getAllWindows();
    return this._getPopupIn(windows);
  }

  /**
   * Given an array of windows, returns the 'popup' that has been opened by MetaMask, or null if no such window exists.
   *
   * @private
   * @param {Array} windows - An array of objects containing data about the open MetaMask extension windows.
   */
  _getPopupIn(windows) {
    return windows ? windows.find(win => {
      // Returns notification popup
      return win && win.type === 'popup' && win.id === this._popupId;
    }) : null;
  }
}
exports.default = NotificationManager;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\notification-manager.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\offscreen-bridge\\lattice-offscreen-keyring.ts", {"../../../../shared/constants/offscreen-communication":"D:\\code\\v\\metamask-extension\\shared\\constants\\offscreen-communication.ts","eth-lattice-keyring":"D:\\code\\v\\metamask-extension\\node_modules\\eth-lattice-keyring\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Coffscreen-bridge%5Clattice-offscreen-keyring.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LatticeKeyringOffscreen = void 0;
var _ethLatticeKeyring = _interopRequireDefault(require("eth-lattice-keyring"));
var _offscreenCommunication = require("../../../../shared/constants/offscreen-communication");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * This keyring extends the default keyring but uses a overwritten _getCreds
 * method to alter the mechanism by which the device is connected to. The main
 * reason for this is because in MV3 the window method to open a new tab will
 * not execute in the service worker as there is no DOM. The original keyring
 * _getCreds method calls into window.open to open a new window for the lattice
 * connector. The solution here is to split the keyring execution so that the
 * portion that requires a normal functioning DOM is executed in the offscreen
 * document. The lattice.ts file in the offscreen directory is responsible for
 * the latter half of the original keyrings execution. The main difference in
 * the first half that this overwritten method is responsible for is just to
 * use the chrome.runtime.sendMessage method to send a message to the offscreen
 * document which picks up on the execution of opening the new window to the
 * lattice connector. Note that this file differs from the ledger and trezor
 * offscreen bridges because this keyring requires no bridge to function
 * appropriately.
 */
class LatticeKeyringOffscreen extends _ethLatticeKeyring.default {
  constructor(opts = {}) {
    super(opts);
  }
  async _getCreds() {
    try {
      // If we are not aware of what Lattice we should be talking to,
      // we need to open a window that lets the user go through the
      // pairing or connection process.
      const name = this.appName ? this.appName : 'Unknown';
      const url = `${_offscreenCommunication.KnownOrigins.lattice}?keyring=${name}&forceLogin=true`;

      // send a msg to the render process to open lattice connector
      // and collect the credentials
      const creds = await new Promise((resolve, reject) => {
        chrome.runtime.sendMessage({
          target: _offscreenCommunication.OffscreenCommunicationTarget.latticeOffscreen,
          params: {
            url
          }
        }, response => {
          if (response.error) {
            reject(response.error);
          }
          resolve(response.result);
        });
      });
      return creds;
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
    } catch (err) {
      throw new Error(err);
    }
  }
}
exports.LatticeKeyringOffscreen = LatticeKeyringOffscreen;
_defineProperty(LatticeKeyringOffscreen, "type", void 0);
LatticeKeyringOffscreen.type = _ethLatticeKeyring.default.type;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\offscreen-bridge\\lattice-offscreen-keyring.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\offscreen-bridge\\ledger-offscreen-bridge.ts", {"../../../../shared/constants/offscreen-communication":"D:\\code\\v\\metamask-extension\\shared\\constants\\offscreen-communication.ts","@ledgerhq/errors":"D:\\code\\v\\metamask-extension\\node_modules\\@ledgerhq\\errors\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Coffscreen-bridge%5Cledger-offscreen-bridge.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LedgerOffscreenBridge = void 0;
var _errors = require("@ledgerhq/errors");
var _offscreenCommunication = require("../../../../shared/constants/offscreen-communication");
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
const MESSAGE_TIMEOUT = 4000;

/**
 * The options for the LedgerOffscreenBridge are empty because the bridge
 * doesn't require any options to be passed in.
 */
var _LedgerOffscreenBridge_brand = /*#__PURE__*/new WeakSet();
/**
 * This class is used as a custom bridge for the Ledger connection. Every
 * hardware wallet keyring also requires a bridge that has a known interface
 * that the keyring can call into for specific functions. The bridge then makes
 * whatever calls or requests it needs to in order to fulfill the request from
 * the keyring. In this case, the bridge is used to communicate with the
 * Offscreen Document. Inside the Offscreen document the ledger script is
 * loaded and registers a listener for these calls and communicate with the
 * ledger device via the ledger keyring iframe. The ledger keyring iframe is
 * added to the offscreen.html file directly.
 */
class LedgerOffscreenBridge {
  constructor() {
    _classPrivateMethodInitSpec(this, _LedgerOffscreenBridge_brand);
    _defineProperty(this, "isDeviceConnected", false);
  }
  init() {
    chrome.runtime.onMessage.addListener(msg => {
      if (msg.target === _offscreenCommunication.OffscreenCommunicationTarget.extension && msg.event === _offscreenCommunication.OffscreenCommunicationEvents.ledgerDeviceConnect) {
        this.isDeviceConnected = true;
      }
    });
    return Promise.resolve();
  }
  destroy() {
    // TODO: remove listener
    return Promise.resolve();
  }
  getOptions() {
    return Promise.resolve({});
  }
  setOptions() {
    return Promise.resolve();
  }
  attemptMakeApp() {
    return _assertClassBrand(_LedgerOffscreenBridge_brand, this, _sendMessage).call(this, {
      action: _offscreenCommunication.LedgerAction.makeApp
    }, {
      timeout: MESSAGE_TIMEOUT
    });
  }
  updateTransportMethod(transportType) {
    return _assertClassBrand(_LedgerOffscreenBridge_brand, this, _sendMessage).call(this, {
      action: _offscreenCommunication.LedgerAction.updateTransport,
      params: {
        transportType
      }
    }, {
      timeout: MESSAGE_TIMEOUT
    });
  }
  getPublicKey(params) {
    return _assertClassBrand(_LedgerOffscreenBridge_brand, this, _sendMessage).call(this, {
      action: _offscreenCommunication.LedgerAction.getPublicKey,
      params
    });
  }
  deviceSignTransaction(params) {
    return _assertClassBrand(_LedgerOffscreenBridge_brand, this, _sendMessage).call(this, {
      action: _offscreenCommunication.LedgerAction.signTransaction,
      params
    });
  }
  deviceSignMessage(params) {
    return _assertClassBrand(_LedgerOffscreenBridge_brand, this, _sendMessage).call(this, {
      action: _offscreenCommunication.LedgerAction.signPersonalMessage,
      params
    });
  }
  deviceSignTypedData(params) {
    return _assertClassBrand(_LedgerOffscreenBridge_brand, this, _sendMessage).call(this, {
      action: _offscreenCommunication.LedgerAction.signTypedData,
      params
    });
  }
}
exports.LedgerOffscreenBridge = LedgerOffscreenBridge;
async function _sendMessage(message, {
  timeout
} = {}) {
  return new Promise((resolve, reject) => {
    let responseTimeout;
    if (timeout) {
      responseTimeout = setTimeout(() => {
        reject(new Error('Ledger iframe timeout'));
      }, timeout);
    }
    chrome.runtime.sendMessage({
      ...message,
      target: _offscreenCommunication.OffscreenCommunicationTarget.ledgerOffscreen
    }, response => {
      clearTimeout(responseTimeout);
      if (response !== null && response !== void 0 && response.success) {
        resolve(response.payload || response.success);
      } else {
        var _response$payload;
        // Need to process the payload to get the error
        // and then reject with the error
        const error = response === null || response === void 0 || (_response$payload = response.payload) === null || _response$payload === void 0 ? void 0 : _response$payload.error;
        if (error && typeof error.statusCode === 'number' && error.statusCode > 0) {
          // This is TransportStatusError, convert the SerializedLedgerError to a TransportStatusError
          // TransportStatusError will regenerate the error message based on the statusCode
          const transportStatusError = new _errors.TransportStatusError(error.statusCode);
          reject(transportStatusError);
        } else if (error !== null && error !== void 0 && error.message) {
          // Regenerate the error based on the SerializedLedgerError
          const newError = new Error(error.message, {
            cause: error
          });
          reject(newError);
        } else {
          // Fallback for unknown Ledger errors when error information is not available
          reject(new Error('Unknown Ledger error occurred'));
        }
      }
    });
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\offscreen-bridge\\ledger-offscreen-bridge.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\offscreen-bridge\\trezor-offscreen-bridge.ts", {"../../../../shared/constants/offscreen-communication":"D:\\code\\v\\metamask-extension\\shared\\constants\\offscreen-communication.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Coffscreen-bridge%5Ctrezor-offscreen-bridge.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TrezorOffscreenBridge = void 0;
var _offscreenCommunication = require("../../../../shared/constants/offscreen-communication");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * This class is used as a custom bridge for the Trezor connection. Every
 * hardware wallet keyring also requires a bridge that has a known interface
 * that the keyring can call into for specific functions. The bridge then makes
 * whatever calls or requests it needs to in order to fulfill the request from
 * the keyring. In this case, the bridge is used to communicate with the
 * Offscreen Document. Inside the Offscreen document the trezor script is
 * loaded and registers a listener for these calls and communicate with the
 * trezor/connect-web library.
 */
class TrezorOffscreenBridge {
  constructor() {
    _defineProperty(this, "model", void 0);
    _defineProperty(this, "minorVersion", void 0);
  }
  init(settings) {
    chrome.runtime.onMessage.addListener(msg => {
      if (msg.target === _offscreenCommunication.OffscreenCommunicationTarget.extension && msg.event === _offscreenCommunication.OffscreenCommunicationEvents.trezorDeviceConnect) {
        this.model = msg.payload.model;
        this.minorVersion = msg.payload.minorVersion;
      }
    });
    return new Promise(resolve => {
      chrome.runtime.sendMessage({
        target: _offscreenCommunication.OffscreenCommunicationTarget.trezorOffscreen,
        action: _offscreenCommunication.TrezorAction.init,
        params: settings
      }, () => {
        resolve();
      });
    });
  }
  dispose() {
    return new Promise(resolve => {
      chrome.runtime.sendMessage({
        target: _offscreenCommunication.OffscreenCommunicationTarget.trezorOffscreen,
        action: _offscreenCommunication.TrezorAction.dispose
      }, () => {
        resolve();
      });
    });
  }
  getPublicKey(params) {
    return new Promise(resolve => {
      chrome.runtime.sendMessage({
        target: _offscreenCommunication.OffscreenCommunicationTarget.trezorOffscreen,
        action: _offscreenCommunication.TrezorAction.getPublicKey,
        params
      }, response => {
        resolve(response);
      });
    });
  }
  ethereumSignTransaction(params) {
    return new Promise(resolve => {
      chrome.runtime.sendMessage({
        target: _offscreenCommunication.OffscreenCommunicationTarget.trezorOffscreen,
        action: _offscreenCommunication.TrezorAction.signTransaction,
        params
      }, response => {
        resolve(response);
      });
    });
  }
  ethereumSignMessage(params) {
    return new Promise(resolve => {
      chrome.runtime.sendMessage({
        target: _offscreenCommunication.OffscreenCommunicationTarget.trezorOffscreen,
        action: _offscreenCommunication.TrezorAction.signMessage,
        params
      }, response => {
        resolve(response);
      });
    });
  }

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
  // eslint-disable-next-line @typescript-eslint/naming-convention
  ethereumSignTypedData(params) {
    return new Promise(resolve => {
      chrome.runtime.sendMessage({
        target: _offscreenCommunication.OffscreenCommunicationTarget.trezorOffscreen,
        action: _offscreenCommunication.TrezorAction.signTypedData,
        params
      }, response => {
        resolve(response);
      });
    });
  }
}
exports.TrezorOffscreenBridge = TrezorOffscreenBridge;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\offscreen-bridge\\trezor-offscreen-bridge.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\open-update-tab-and-reload.ts", {"webextension-polyfill":"D:\\code\\v\\metamask-extension\\node_modules\\webextension-polyfill\\dist\\browser-polyfill.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Copen-update-tab-and-reload.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openUpdateTabAndReload = openUpdateTabAndReload;
var _webextensionPolyfill = _interopRequireDefault(require("webextension-polyfill"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Opens the "Updating" page in a new tab and then triggers a safe extension reload.
 *
 * Used when an update is available to reload the extension.
 *
 * If opening the tab fails, the error is logged, and the reload proceeds anyway.
 *
 * @param requestSafeReload - A function from MetamaskController that initiates a safe reload
 * of the extension without disrupting user state.
 */
async function openUpdateTabAndReload(requestSafeReload) {
  try {
    await _webextensionPolyfill.default.tabs.create({
      url: 'https://metamask.io/updating',
      active: true
    });
  } catch (error) {
    console.error(error);
  }
  await requestSafeReload();
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\open-update-tab-and-reload.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\operation-safener.ts", {"../../../shared/lib/promise-with-resolvers":"D:\\code\\v\\metamask-extension\\shared\\lib\\promise-with-resolvers.ts","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Coperation-safener.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OperationSafener = void 0;
var _lodash = require("lodash");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _promiseWithResolvers = require("../../../shared/lib/promise-with-resolvers");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
// eslint-disable-next-line @typescript-eslint/no-explicit-any
/**
 * A type representing a generic operation that can be executed.
 */
/**
 * Options for the lock used in the OperationSafener.
 */
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
var _bouncer = /*#__PURE__*/new WeakMap();
var _evacuating = /*#__PURE__*/new WeakMap();
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
class OperationSafener {
  /**
   * Creates an instance of OperationSafener.
   *
   * This class is designed to safely execute operations that may be
   * invoked frequently or in quick succession. It debounces the execution of
   * the operation, ensuring that it is only executed once within a specified
   * wait time.
   *
   * Additionally, it ensures that no two operations are executed
   * at the same time, if any operation might take longer than the `wait` time
   * to complete.
   *
   * Finally, it provides a method to evacuate the current operation queue,
   * executing the latest pending operation and preventing any future
   * operations from being queued.
   *
   * @param config - Configuration object for the OperationSafener.
   * @param config.op
   * @param config.wait
   * @param config.options
   * @example
   * ```ts
   * const operationSafener = new OperationSafener({
   *   op: async (data) => {
   *     // Perform some operation with data
   *     console.log('Operation executed with:', data);
   *   },
   *   wait: 1000, // Wait for 1 second before executing the operation
   * });
   * // queued
   * operationSafener.execute('example data 1');
   * // queued, previous call is removed
   * operationSafener.execute('example data 2');
   * // _immediately_ logs `example data 2` _only_
   * await operationSafener.evacuate();
   * // never logs, call to `evacuate` prevents any future operations.
   * operationSafener.execute('example data 3');
   * ```
   */
  constructor({
    op,
    wait,
    options
  }) {
    /**
     * A debounced function that wraps the operation to be executed.
     * It ensures that the operation is not called too frequently. And that no
     * two operations are ever executed at the same time.
     */
    _classPrivateFieldInitSpec(this, _bouncer, void 0);
    /**
     * Tracks whether the OperationSafener is currently evacuating.
     */
    _classPrivateFieldInitSpec(this, _evacuating, null);
    /**
     * Evacuates the current operation queue, executing the latest pending
     * operation and preventing any future operations from being queued.
     *
     * @returns A Promise that resolves when the evacuation is complete.
     */
    _defineProperty(this, "evacuate", () => {
      if (_classPrivateFieldGet(_evacuating, this)) {
        _loglevel.default.warn('already evacuating');
        return _classPrivateFieldGet(_evacuating, this);
      }

      // execute the final operation in the queue, if any
      const finalInvocation = _classPrivateFieldGet(_bouncer, this).flush();
      if (finalInvocation) {
        // ensure that `evacuate` always resolves successfully, AND that a
        // rejection from running `this.#bouncer.flush()` *is* an unhandled
        // rejection; we want it to bubble up to the process/window's
        // `unhandledRejection` listener, i.e., Sentry.
        const {
          promise,
          resolve
        } = (0, _promiseWithResolvers.withResolvers)();
        finalInvocation.finally(resolve);
        _classPrivateFieldSet(_evacuating, this, promise);
      } else {
        _classPrivateFieldSet(_evacuating, this, Promise.resolve());
      }
      return _classPrivateFieldGet(_evacuating, this);
    });
    /**
     * Executes the operation with the provided parameters, debouncing it if
     * necessary.
     *
     * If the OperationSafener is currently evacuating or has been evacuated,
     * this method will return false and not queue the operation.
     *
     * @param params - Parameters to pass to the operation.
     * @returns A boolean indicating whether the operation was queued for
     * execution.
     */
    _defineProperty(this, "execute", (...params) => {
      if (_classPrivateFieldGet(_evacuating, this)) {
        _loglevel.default.warn('evacuating, ignoring call to `execute`');
        return false;
      }

      // fire and forget; the return value for a `debounce`d function is the
      // _previous_ invocation's return value, not the current one.
      _classPrivateFieldGet(_bouncer, this).call(this, ...params);
      return true;
    });
    const opts = {
      mode: 'exclusive'
    };
    const func = (...params) => navigator.locks.request('operation-safener-lock', opts, () => op(...params));
    _classPrivateFieldSet(_bouncer, this, (0, _lodash.debounce)(func, wait, options));
  }
}
exports.OperationSafener = OperationSafener;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\operation-safener.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\ppom\\indexed-db-backend.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Cppom%5Cindexed-db-backend.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexedDBPPOMStorage = void 0;
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
const validateChecksum = async (key, data, checksum) => {
  const hash = await crypto.subtle.digest('SHA-256', data);
  const hashString = Array.from(new Uint8Array(hash)).map(b => b.toString(16).padStart(2, '0')).join('');
  if (hashString !== checksum) {
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    throw new Error(`Checksum mismatch for key ${key}`);
  }
};
var _IndexedDBPPOMStorage_brand = /*#__PURE__*/new WeakSet();
class IndexedDBPPOMStorage {
  constructor(storeName, dbVersion) {
    _classPrivateMethodInitSpec(this, _IndexedDBPPOMStorage_brand);
    _defineProperty(this, "storeName", void 0);
    _defineProperty(this, "dbVersion", void 0);
    this.storeName = storeName;
    this.dbVersion = dbVersion;
  }
  async objectStoreAction(method,
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  args, mode = 'readonly'
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  ) {
    return new Promise((resolve, reject) => {
      _assertClassBrand(_IndexedDBPPOMStorage_brand, this, _getObjectStore).call(this, mode).then(objectStore => {
        const request = objectStore[method](args);
        request.onsuccess = async event => {
          resolve(event);
        };
        request.onerror = event => {
          var _event$target;
          reject(new Error(`Error in indexDB operation ${method}: ${// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
          // eslint-disable-next-line @typescript-eslint/no-explicit-any
          (_event$target = event.target) === null || _event$target === void 0 ? void 0 : _event$target.error}`));
        };
      }).catch(error => {
        reject(error);
      });
    });
  }
  async read(key, checksum) {
    var _event$target2;
    const event = await this.objectStoreAction('get', [key.name, key.chainId]);
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    const data = (_event$target2 = event.target) === null || _event$target2 === void 0 || (_event$target2 = _event$target2.result) === null || _event$target2 === void 0 ? void 0 : _event$target2.data;
    await validateChecksum(key, data, checksum);
    return data;
  }
  async write(key, data, checksum) {
    await validateChecksum(key, data, checksum);
    await this.objectStoreAction('put', {
      ...key,
      data
    }, 'readwrite');
  }
  async delete(key) {
    await this.objectStoreAction('delete', [key.name, key.chainId], 'readwrite');
  }
  async dir() {
    var _event$target3;
    const event = await this.objectStoreAction('getAllKeys');
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return (_event$target3 = event.target) === null || _event$target3 === void 0 ? void 0 : _event$target3.result.map(([name, chainId]) => ({
      name,
      chainId
    }));
  }
}
exports.IndexedDBPPOMStorage = IndexedDBPPOMStorage;
function _getObjectStore(mode) {
  return new Promise((resolve, reject) => {
    const request = indexedDB.open(this.storeName, this.dbVersion);
    request.onerror = event => {
      var _event$target4;
      reject(new Error(`Failed to open database ${this.storeName}: ${// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      (_event$target4 = event.target) === null || _event$target4 === void 0 ? void 0 : _event$target4.error}`));
    };
    request.onupgradeneeded = event => {
      const db = event.target.result;
      if (!db.objectStoreNames.contains(this.storeName)) {
        db.createObjectStore(this.storeName, {
          keyPath: ['name', 'chainId']
        });
      }
    };
    request.onsuccess = event => {
      const db = event.target.result;
      const transaction = db.transaction([this.storeName], mode);
      const objectStore = transaction.objectStore(this.storeName);
      resolve(objectStore);
    };
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\ppom\\indexed-db-backend.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\ppom\\ppom-middleware.ts", {"../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/security-provider":"D:\\code\\v\\metamask-extension\\shared\\constants\\security-provider.ts","../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","./ppom-util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\ppom\\ppom-util.ts","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Cppom%5Cppom-middleware.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPPOMMiddleware = createPPOMMiddleware;
var _controllerUtils = require("@metamask/controller-utils");
var _app = require("../../../../shared/constants/app");
var _transaction = require("../../../../shared/constants/transaction");
var _trace = require("../../../../shared/lib/trace");
var _securityProvider = require("../../../../shared/constants/security-provider");
var _ppomUtil = require("./ppom-util");
const CONFIRMATION_METHODS = Object.freeze(['eth_sendRawTransaction', 'eth_sendTransaction', ..._transaction.SIGNING_METHODS]);
/**
 * Middleware function that handles JSON RPC requests.
 * This function will be called for every JSON RPC request.
 * It will call the PPOM to check if the request is malicious or benign.
 * If the request is benign, it will be forwarded to the next middleware.
 * If the request is malicious or warning, it will trigger the PPOM alert dialog,
 * after the user has confirmed or rejected the request,
 * the request will be forwarded to the next middleware, together with the PPOM response.
 *
 * @param ppomController - Instance of PPOMController.
 * @param preferencesController - Instance of PreferenceController.
 * @param networkController - Instance of NetworkController.
 * @param appStateController
 * @param accountsController - Instance of AccountsController.
 * @param updateSecurityAlertResponse
 * @param getSecurityAlertsConfig - Optional method to get transaction security alerts parameters.
 * @returns PPOMMiddleware function.
 */
function createPPOMMiddleware(ppomController, preferencesController, networkController, appStateController, accountsController, updateSecurityAlertResponse, getSecurityAlertsConfig) {
  return async (req, _res, next) => {
    try {
      const {
        securityAlertsEnabled
      } = preferencesController.state;
      const {
        chainId
      } = networkController.getNetworkConfigurationByNetworkClientId(req.networkClientId) ?? {};
      if (!chainId) {
        throw Error('ChainID not found for networkClientId');
      }
      if (!securityAlertsEnabled || !CONFIRMATION_METHODS.includes(req.method)) {
        return;
      }
      const data = req.params[0];
      if (typeof data === 'string') {
        const {
          isSIWEMessage
        } = (0, _controllerUtils.detectSIWE)({
          data
        });
        if (isSIWEMessage) {
          return;
        }
      } else if (req.method === _app.MESSAGE_TYPE.ETH_SEND_TRANSACTION) {
        const {
          to: toAddress
        } = data ?? {};
        const internalAccounts = accountsController.listAccounts();
        const isToInternalAccount = internalAccounts.some(({
          address
        }) => (address === null || address === void 0 ? void 0 : address.toLowerCase()) === (toAddress === null || toAddress === void 0 ? void 0 : toAddress.toLowerCase()));
        if (isToInternalAccount) {
          return;
        }
      }
      const securityAlertId = (0, _ppomUtil.generateSecurityAlertId)();
      (0, _trace.trace)({
        name: _trace.TraceName.PPOMValidation,
        parentContext: req.traceContext
      }, () => (0, _ppomUtil.validateRequestWithPPOM)({
        ppomController,
        request: req,
        securityAlertId,
        chainId: chainId,
        updateSecurityAlertResponse,
        getSecurityAlertsConfig
      }));
      const securityAlertResponseLoading = {
        ..._securityProvider.LOADING_SECURITY_ALERT_RESPONSE,
        securityAlertId
      };
      if (_transaction.SIGNING_METHODS.includes(req.method)) {
        appStateController.addSignatureSecurityAlertResponse(securityAlertResponseLoading);
      }
      req.securityAlertResponse = securityAlertResponseLoading;
    } catch (error) {
      req.securityAlertResponse = (0, _ppomUtil.handlePPOMError)(error, 'Error createPPOMMiddleware: ');
    } finally {
      next();
    }
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\ppom\\ppom-middleware.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\ppom\\ppom-util.ts", {"../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/security-provider":"D:\\code\\v\\metamask-extension\\shared\\constants\\security-provider.ts","../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../shared/modules/transaction.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\transaction.utils.ts","../../../../shared/modules/typed-signature":"D:\\code\\v\\metamask-extension\\shared\\modules\\typed-signature.ts","./security-alerts-api":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\ppom\\security-alerts-api.ts","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","uuid":"D:\\code\\v\\metamask-extension\\node_modules\\uuid\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Cppom%5Cppom-util.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateSecurityAlertId = generateSecurityAlertId;
exports.handlePPOMError = handlePPOMError;
exports.updateSecurityAlertResponse = updateSecurityAlertResponse;
exports.validateRequestWithPPOM = validateRequestWithPPOM;
var _transactionController = require("@metamask/transaction-controller");
var _utils = require("@metamask/utils");
var _uuid = require("uuid");
var _lodash = require("lodash");
var _securityProvider = require("../../../../shared/constants/security-provider");
var _transaction = require("../../../../shared/constants/transaction");
var _typedSignature = require("../../../../shared/modules/typed-signature");
var _transaction2 = require("../../../../shared/modules/transaction.utils");
var _app = require("../../../../shared/constants/app");
var _securityAlertsApi = require("./security-alerts-api");
const log = (0, _utils.createProjectLogger)('ppom-util');
const {
  sentry
} = global;
const SECURITY_ALERT_RESPONSE_ERROR = {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
  // eslint-disable-next-line @typescript-eslint/naming-convention
  result_type: _securityProvider.BlockaidResultType.Errored,
  reason: _securityProvider.BlockaidReason.errored
};
async function validateRequestWithPPOM({
  ppomController,
  request,
  securityAlertId,
  chainId,
  updateSecurityAlertResponse: updateSecurityResponse,
  getSecurityAlertsConfig
}) {
  try {
    const controllerObject = await updateSecurityResponse(request.method, securityAlertId, _securityProvider.LOADING_SECURITY_ALERT_RESPONSE);
    const normalizedRequest = normalizePPOMRequest(request, controllerObject);
    log('Normalized request', normalizedRequest);
    const ppomResponse = (0, _securityAlertsApi.isSecurityAlertsAPIEnabled)() ? await validateWithAPI(ppomController, chainId, normalizedRequest, getSecurityAlertsConfig) : await validateWithController(ppomController, normalizedRequest, chainId);
    await updateSecurityResponse(request.method, securityAlertId, ppomResponse);
  } catch (error) {
    log('Error', error);
    await updateSecurityResponse(request.method, securityAlertId, handlePPOMError(error, 'Error validating JSON RPC using PPOM: '));
  }
}
function generateSecurityAlertId() {
  return (0, _uuid.v4)();
}
async function updateSecurityAlertResponse({
  appStateController,
  messenger,
  method,
  securityAlertId,
  securityAlertResponse,
  signatureController,
  transactionController
}) {
  const isSignatureRequest = _transaction.SIGNING_METHODS.includes(method);
  if (isSignatureRequest) {
    const signatureRequest = await waitForSignatureRequest(signatureController, securityAlertId, messenger);
    appStateController.addSignatureSecurityAlertResponse({
      ...securityAlertResponse,
      securityAlertId
    });
    return signatureRequest;
  }
  const transactionMeta = await waitForTransactionMetadata(transactionController, securityAlertId, messenger);
  transactionController.updateSecurityAlertResponse(transactionMeta.id, {
    ...securityAlertResponse,
    securityAlertId
  });
  return transactionMeta;
}
function handlePPOMError(error, logMessage, source = _securityProvider.SecurityAlertSource.API) {
  const errorData = getErrorData(error);
  const description = getErrorMessage(error);
  if (source === _securityProvider.SecurityAlertSource.Local) {
    sentry === null || sentry === void 0 || sentry.captureException(error);
  }
  console.error(logMessage, errorData);
  return {
    ...SECURITY_ALERT_RESPONSE_ERROR,
    description,
    source
  };
}
function normalizePPOMRequest(request, controllerObject) {
  let normalizedRequest = (0, _lodash.cloneDeep)(request);
  normalizedRequest = normalizeSignatureRequest(normalizedRequest);
  normalizedRequest = normalizeTransactionRequest(normalizedRequest, controllerObject);
  const {
    delegationMock,
    id,
    jsonrpc,
    method,
    origin,
    params
  } = normalizedRequest;
  return {
    delegationMock,
    id,
    jsonrpc,
    method,
    origin,
    params
  };
}
function normalizeTransactionRequest(request, transactionMeta) {
  if (request.method !== _app.MESSAGE_TYPE.ETH_SEND_TRANSACTION) {
    return request;
  }
  if (!Array.isArray(request.params) || !request.params[0]) {
    return request;
  }
  const txParams = request.params[0];
  txParams.gas = transactionMeta.txParams.gas;
  txParams.gasPrice = transactionMeta.txParams.maxFeePerGas ?? transactionMeta.txParams.gasPrice;
  delete txParams.gasLimit;
  delete txParams.maxFeePerGas;
  delete txParams.maxPriorityFeePerGas;
  delete txParams.type;
  const normalizedParams = (0, _transactionController.normalizeTransactionParams)(txParams);
  log('Normalized transaction params', normalizedParams);
  return {
    ...request,
    params: [normalizedParams]
  };
}
function normalizeSignatureRequest(request) {
  // This is a temporary fix to prevent a PPOM bypass
  if (request.method !== _app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3 && request.method !== _app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4) {
    return request;
  }
  if (!Array.isArray(request.params) || !request.params[1]) {
    return request;
  }
  const typedDataMessage = (0, _transaction2.parseTypedDataMessage)(request.params[1]);
  const sanitizedMessageRecursively = (0, _typedSignature.sanitizeMessageRecursively)(typedDataMessage.message, typedDataMessage.types, typedDataMessage.primaryType);
  return {
    ...request,
    params: [request.params[0], JSON.stringify({
      ...typedDataMessage,
      message: sanitizedMessageRecursively
    })]
  };
}
function getErrorMessage(error) {
  if (error instanceof Error) {
    return `${error.name}: ${error.message}`;
  }
  return JSON.stringify(error);
}
function getErrorData(error) {
  if (typeof error === 'object' || typeof error === 'string') {
    return error;
  }
  return JSON.stringify(error);
}
async function validateWithController(ppomController, request, chainId) {
  try {
    const response = await ppomController.usePPOM(ppom => ppom.validateJsonRpc(request), chainId);
    return {
      ...response,
      source: _securityProvider.SecurityAlertSource.Local
    };
  } catch (error) {
    return handlePPOMError(error, `Error validating request with PPOM controller`, _securityProvider.SecurityAlertSource.Local);
  }
}
async function validateWithAPI(ppomController, chainId, request, getSecurityAlertsConfig) {
  try {
    const response = await (0, _securityAlertsApi.validateWithSecurityAlertsAPI)(chainId, request, getSecurityAlertsConfig);
    return {
      ...response,
      source: _securityProvider.SecurityAlertSource.API
    };
  } catch (error) {
    handlePPOMError(error, `Error validating request with security alerts API`);
    return await validateWithController(ppomController, request, chainId);
  }
}
async function waitForTransactionMetadata(transactionController, securityAlertId, messenger) {
  const transactionFilter = meta => {
    var _meta$securityAlertRe;
    return ((_meta$securityAlertRe = meta.securityAlertResponse) === null || _meta$securityAlertRe === void 0 ? void 0 : _meta$securityAlertRe.securityAlertId) === securityAlertId;
  };
  return new Promise(resolve => {
    const transactionMeta = transactionController.state.transactions.find(transactionFilter);
    if (transactionMeta) {
      resolve(transactionMeta);
      return;
    }
    const callback = event => {
      if (!transactionFilter(event)) {
        return;
      }
      log('Found transaction metadata', event);
      messenger.unsubscribe('TransactionController:unapprovedTransactionAdded', callback);
      resolve(event);
    };
    log('Waiting for transaction metadata', securityAlertId);
    messenger.subscribe('TransactionController:unapprovedTransactionAdded', callback);
  });
}
async function waitForSignatureRequest(signatureController, securityAlertId, messenger) {
  const signatureFilter = state => Object.values(state.signatureRequests).find(request => {
    var _request$securityAler;
    return ((_request$securityAler = request.securityAlertResponse) === null || _request$securityAler === void 0 ? void 0 : _request$securityAler.securityAlertId) === securityAlertId;
  });
  return new Promise(resolve => {
    const signatureRequest = signatureFilter(signatureController.state);
    if (signatureRequest) {
      resolve(signatureRequest);
      return;
    }
    const callback = state => {
      const request = signatureFilter(state);
      if (!request) {
        return;
      }
      log('Found signature request', request);
      messenger.unsubscribe('SignatureController:stateChange', callback);
      resolve(request);
    };
    log('Waiting for signature request', securityAlertId);
    messenger.subscribe('SignatureController:stateChange', callback);
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\ppom\\ppom-util.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\ppom\\ppom.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Cppom%5Cppom.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.PPOM = void 0;
exports.initSync = initSync;
exports.main = main;
/* eslint-disable */

// This file is provided by Blockaid team. The file will be audited and should not be changed thereafter.

let wasm;
const cachedTextDecoder = typeof TextDecoder !== 'undefined' ? new TextDecoder('utf-8', {
  ignoreBOM: true,
  fatal: true
}) : {
  decode: () => {
    throw Error('TextDecoder not available');
  }
};
if (typeof TextDecoder !== 'undefined') {
  cachedTextDecoder.decode();
}
;
let cachedUint8Memory0 = null;
function getUint8Memory0() {
  if (cachedUint8Memory0 === null || cachedUint8Memory0.byteLength === 0) {
    cachedUint8Memory0 = new Uint8Array(wasm.memory.buffer);
  }
  return cachedUint8Memory0;
}
function getStringFromWasm0(ptr, len) {
  ptr = ptr >>> 0;
  return cachedTextDecoder.decode(getUint8Memory0().subarray(ptr, ptr + len));
}
const heap = new Array(128).fill(undefined);
heap.push(undefined, null, true, false);
let heap_next = heap.length;
function addHeapObject(obj) {
  if (heap_next === heap.length) heap.push(heap.length + 1);
  const idx = heap_next;
  heap_next = heap[idx];
  heap[idx] = obj;
  return idx;
}
function getObject(idx) {
  return heap[idx];
}
function dropObject(idx) {
  if (idx < 132) return;
  heap[idx] = heap_next;
  heap_next = idx;
}
function takeObject(idx) {
  const ret = getObject(idx);
  dropObject(idx);
  return ret;
}
let WASM_VECTOR_LEN = 0;
const cachedTextEncoder = typeof TextEncoder !== 'undefined' ? new TextEncoder('utf-8') : {
  encode: () => {
    throw Error('TextEncoder not available');
  }
};
const encodeString = typeof cachedTextEncoder.encodeInto === 'function' ? function (arg, view) {
  return cachedTextEncoder.encodeInto(arg, view);
} : function (arg, view) {
  const buf = cachedTextEncoder.encode(arg);
  view.set(buf);
  return {
    read: arg.length,
    written: buf.length
  };
};
function passStringToWasm0(arg, malloc, realloc) {
  if (realloc === undefined) {
    const buf = cachedTextEncoder.encode(arg);
    const ptr = malloc(buf.length, 1) >>> 0;
    getUint8Memory0().subarray(ptr, ptr + buf.length).set(buf);
    WASM_VECTOR_LEN = buf.length;
    return ptr;
  }
  let len = arg.length;
  let ptr = malloc(len, 1) >>> 0;
  const mem = getUint8Memory0();
  let offset = 0;
  for (; offset < len; offset++) {
    const code = arg.charCodeAt(offset);
    if (code > 0x7F) break;
    mem[ptr + offset] = code;
  }
  if (offset !== len) {
    if (offset !== 0) {
      arg = arg.slice(offset);
    }
    ptr = realloc(ptr, len, len = offset + arg.length * 3, 1) >>> 0;
    const view = getUint8Memory0().subarray(ptr + offset, ptr + len);
    const ret = encodeString(arg, view);
    offset += ret.written;
  }
  WASM_VECTOR_LEN = offset;
  return ptr;
}
function isLikeNone(x) {
  return x === undefined || x === null;
}
let cachedInt32Memory0 = null;
function getInt32Memory0() {
  if (cachedInt32Memory0 === null || cachedInt32Memory0.byteLength === 0) {
    cachedInt32Memory0 = new Int32Array(wasm.memory.buffer);
  }
  return cachedInt32Memory0;
}
function debugString(val) {
  // primitive types
  const type = typeof val;
  if (type == 'number' || type == 'boolean' || val == null) {
    return `${val}`;
  }
  if (type == 'string') {
    return `"${val}"`;
  }
  if (type == 'symbol') {
    const description = val.description;
    if (description == null) {
      return 'Symbol';
    } else {
      return `Symbol(${description})`;
    }
  }
  if (type == 'function') {
    const name = val.name;
    if (typeof name == 'string' && name.length > 0) {
      return `Function(${name})`;
    } else {
      return 'Function';
    }
  }
  // objects
  if (Array.isArray(val)) {
    const length = val.length;
    let debug = '[';
    if (length > 0) {
      debug += debugString(val[0]);
    }
    for (let i = 1; i < length; i++) {
      debug += ', ' + debugString(val[i]);
    }
    debug += ']';
    return debug;
  }
  // Test for built-in
  const builtInMatches = /\[object ([^\]]+)\]/.exec(toString.call(val));
  let className;
  if (builtInMatches.length > 1) {
    className = builtInMatches[1];
  } else {
    // Failed to match the standard '[object ClassName]'
    return toString.call(val);
  }
  if (className == 'Object') {
    // we're a user defined class or Object
    // JSON.stringify avoids problems with cycles, and is generally much
    // easier than looping through ownProperties of `val`.
    try {
      return 'Object(' + JSON.stringify(val) + ')';
    } catch (_) {
      return 'Object';
    }
  }
  // errors
  if (val instanceof Error) {
    return `${val.name}: ${val.message}\n${val.stack}`;
  }
  // TODO we could test for more things here, like `Set`s and `Map`s.
  return className;
}
function makeMutClosure(arg0, arg1, dtor, f) {
  const state = {
    a: arg0,
    b: arg1,
    cnt: 1
  };
  const real = (...args) => {
    // First up with a closure we increment the internal reference
    // count. This ensures that the Rust closure environment won't
    // be deallocated while we're invoking it.
    state.cnt++;
    const a = state.a;
    state.a = 0;
    try {
      return f(a, state.b, ...args);
    } finally {
      if (--state.cnt === 0) {
        dtor(a, state.b);
      } else {
        state.a = a;
      }
    }
  };
  real.original = state;
  return real;
}
function __wbg_adapter_20(arg0, arg1, arg2) {
  wasm.wasm_bindgen__convert__closures__invoke1_mut(arg0, arg1, addHeapObject(arg2));
}
function __wbg_adapter_21(arg0, arg1) {
  wasm._dyn_core__ops__function__FnMut__A____Output___R_as_wasm_bindgen__closure__WasmClosure___describe__destroy(arg0, arg1);
}

/**
*/
function main() {
  wasm.main();
}
let cachedUint32Memory0 = null;
function getUint32Memory0() {
  if (cachedUint32Memory0 === null || cachedUint32Memory0.byteLength === 0) {
    cachedUint32Memory0 = new Uint32Array(wasm.memory.buffer);
  }
  return cachedUint32Memory0;
}
function passArrayJsValueToWasm0(array, malloc) {
  const ptr = malloc(array.length * 4, 4) >>> 0;
  const mem = getUint32Memory0();
  for (let i = 0; i < array.length; i++) {
    mem[ptr / 4 + i] = addHeapObject(array[i]);
  }
  WASM_VECTOR_LEN = array.length;
  return ptr;
}
function handleError(f, args) {
  try {
    return f.apply(this, args);
  } catch (e) {
    wasm.__wbindgen_exn_store(addHeapObject(e));
  }
}
function __wbg_adapter_40(arg0, arg1, arg2, arg3) {
  wasm.wasm_bindgen__convert__closures__invoke2_mut(arg0, arg1, addHeapObject(arg2), addHeapObject(arg3));
}

/**
* JavaScript wrapper for [`PPOM`]
*/
class PPOM {
  static __wrap(ptr) {
    ptr = ptr >>> 0;
    const obj = Object.create(PPOM.prototype);
    obj.__wbg_ptr = ptr;
    return obj;
  }
  __destroy_into_raw() {
    const ptr = this.__wbg_ptr;
    this.__wbg_ptr = 0;
    return ptr;
  }
  free() {
    const ptr = this.__destroy_into_raw();
    wasm.__wbg_ppom_free(ptr);
  }
  /**
  * @param {Function} json_rpc_callback
  * @param {any[]} files
  * @returns {Promise<PPOM>}
  */
  static new(json_rpc_callback, files) {
    const ptr0 = passArrayJsValueToWasm0(files, wasm.__wbindgen_malloc);
    const len0 = WASM_VECTOR_LEN;
    const ret = wasm.ppom_new(addHeapObject(json_rpc_callback), ptr0, len0);
    return takeObject(ret);
  }
  /**
  * @param {any} request
  * @returns {Promise<any>}
  */
  validateJsonRpc(request) {
    const ret = wasm.ppom_validateJsonRpc(this.__wbg_ptr, addHeapObject(request));
    return takeObject(ret);
  }
  /**
  * @returns {string}
  */
  static version() {
    const ret = wasm.ppom_version();
    return takeObject(ret);
  }
}
exports.PPOM = PPOM;
async function __wbg_load(module, imports) {
  if (typeof Response === 'function' && module instanceof Response) {
    if (typeof WebAssembly.instantiateStreaming === 'function') {
      try {
        return await WebAssembly.instantiateStreaming(module, imports);
      } catch (e) {
        if (module.headers.get('Content-Type') != 'application/wasm') {
          console.warn("`WebAssembly.instantiateStreaming` failed because your server does not serve wasm with `application/wasm` MIME type. Falling back to `WebAssembly.instantiate` which is slower. Original error:\n", e);
        } else {
          throw e;
        }
      }
    }
    const bytes = await module.arrayBuffer();
    return await WebAssembly.instantiate(bytes, imports);
  } else {
    const instance = await WebAssembly.instantiate(module, imports);
    if (instance instanceof WebAssembly.Instance) {
      return {
        instance,
        module
      };
    } else {
      return instance;
    }
  }
}
function __wbg_get_imports() {
  const imports = {};
  imports.wbg = {};
  imports.wbg.__wbg_buffer_085ec1f694018c4f = function (arg0) {
    const ret = getObject(arg0).buffer;
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_call_01734de55d61e11d = function () {
    return handleError(function (arg0, arg1, arg2) {
      const ret = getObject(arg0).call(getObject(arg1), getObject(arg2));
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_call_4c92f6aec1e1d6e6 = function () {
    return handleError(function (arg0, arg1, arg2, arg3) {
      const ret = getObject(arg0).call(getObject(arg1), getObject(arg2), getObject(arg3));
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_from_d7c216d4616bb368 = function (arg0) {
    const ret = Array.from(getObject(arg0));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_get_44be0491f933a435 = function (arg0, arg1) {
    const ret = getObject(arg0)[arg1 >>> 0];
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_length_72e2208bbc0efc61 = function (arg0) {
    const ret = getObject(arg0).length;
    return ret;
  };
  imports.wbg.__wbg_length_d813e535247d427e = function (arg0) {
    const ret = getObject(arg0).length;
    return ret;
  };
  imports.wbg.__wbg_length_fff51ee6522a1a18 = function (arg0) {
    const ret = getObject(arg0).length;
    return ret;
  };
  imports.wbg.__wbg_new_43f1b47c28813cbd = function (arg0, arg1) {
    try {
      var state0 = {
        a: arg0,
        b: arg1
      };
      var cb0 = (arg0, arg1) => {
        const a = state0.a;
        state0.a = 0;
        try {
          return __wbg_adapter_40(a, state0.b, arg0, arg1);
        } finally {
          state0.a = a;
        }
      };
      const ret = new Promise(cb0);
      return addHeapObject(ret);
    } finally {
      state0.a = state0.b = 0;
    }
  };
  imports.wbg.__wbg_new_8125e318e6245eed = function (arg0) {
    const ret = new Uint8Array(getObject(arg0));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_parse_670c19d4e984792e = function () {
    return handleError(function (arg0, arg1) {
      const ret = JSON.parse(getStringFromWasm0(arg0, arg1));
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_ppom_new = function (arg0) {
    const ret = PPOM.__wrap(arg0);
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_resolve_53698b95aaf7fcf8 = function (arg0) {
    const ret = Promise.resolve(getObject(arg0));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_set_5cf90238115182c3 = function (arg0, arg1, arg2) {
    getObject(arg0).set(getObject(arg1), arg2 >>> 0);
  };
  imports.wbg.__wbg_stringify_e25465938f3f611f = function () {
    return handleError(function (arg0) {
      const ret = JSON.stringify(getObject(arg0));
      return addHeapObject(ret);
    }, arguments);
  };
  imports.wbg.__wbg_then_b2267541e2a73865 = function (arg0, arg1, arg2) {
    const ret = getObject(arg0).then(getObject(arg1), getObject(arg2));
    return addHeapObject(ret);
  };
  imports.wbg.__wbg_then_f7e06ee3c11698eb = function (arg0, arg1) {
    const ret = getObject(arg0).then(getObject(arg1));
    return addHeapObject(ret);
  };
  imports.wbg.__wbindgen_cb_drop = function (arg0) {
    const obj = takeObject(arg0).original;
    if (obj.cnt-- == 1) {
      obj.a = 0;
      return true;
    }
    const ret = false;
    return ret;
  };
  imports.wbg.__wbindgen_closure_wrapper_wasm_bindgen__closure__Closure_T___wrap__breaks_if_inlined = function (arg0, arg1, arg2) {
    const ret = makeMutClosure(arg0, arg1, __wbg_adapter_21, __wbg_adapter_20);
    return addHeapObject(ret);
  };
  imports.wbg.__wbindgen_debug_string = function (arg0, arg1) {
    const ret = debugString(getObject(arg1));
    const ptr1 = passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len1 = WASM_VECTOR_LEN;
    getInt32Memory0()[arg0 / 4 + 1] = len1;
    getInt32Memory0()[arg0 / 4 + 0] = ptr1;
  };
  imports.wbg.__wbindgen_error_new = function (arg0, arg1) {
    const ret = new Error(getStringFromWasm0(arg0, arg1));
    return addHeapObject(ret);
  };
  imports.wbg.__wbindgen_is_undefined = function (arg0) {
    const ret = getObject(arg0) === undefined;
    return ret;
  };
  imports.wbg.__wbindgen_memory = function () {
    const ret = wasm.memory;
    return addHeapObject(ret);
  };
  imports.wbg.__wbindgen_object_drop_ref = function (arg0) {
    takeObject(arg0);
  };
  imports.wbg.__wbindgen_string_get = function (arg0, arg1) {
    const obj = getObject(arg1);
    const ret = typeof obj === 'string' ? obj : undefined;
    var ptr1 = isLikeNone(ret) ? 0 : passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    var len1 = WASM_VECTOR_LEN;
    getInt32Memory0()[arg0 / 4 + 1] = len1;
    getInt32Memory0()[arg0 / 4 + 0] = ptr1;
  };
  imports.wbg.__wbindgen_string_new = function (arg0, arg1) {
    const ret = getStringFromWasm0(arg0, arg1);
    return addHeapObject(ret);
  };
  imports.wbg.__wbindgen_throw = function (arg0, arg1) {
    throw new Error(getStringFromWasm0(arg0, arg1));
  };
  return imports;
}
function __wbg_init_memory(imports, maybe_memory) {}
function __wbg_finalize_init(instance, module) {
  wasm = instance.exports;
  __wbg_init.__wbindgen_wasm_module = module;
  cachedInt32Memory0 = null;
  cachedUint32Memory0 = null;
  cachedUint8Memory0 = null;
  wasm.__wbindgen_start();
  return wasm;
}
function initSync(module) {
  if (wasm !== undefined) return wasm;
  const imports = __wbg_get_imports();
  __wbg_init_memory(imports);
  if (!(module instanceof WebAssembly.Module)) {
    module = new WebAssembly.Module(module);
  }
  const instance = new WebAssembly.Instance(module, imports);
  return __wbg_finalize_init(instance, module);
}
async function __wbg_init(input) {
  if (wasm !== undefined) return wasm;
  const imports = __wbg_get_imports();
  if (typeof input === 'string' || typeof Request === 'function' && input instanceof Request || typeof URL === 'function' && input instanceof URL) {
    input = fetch(input);
  }
  __wbg_init_memory(imports);
  const {
    instance,
    module
  } = await __wbg_load(await input, imports);
  return __wbg_finalize_init(instance, module);
}
var _default = exports.default = __wbg_init;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\ppom\\ppom.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\qr-keyring-builder-factory.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Cqr-keyring-builder-factory.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.qrKeyringBuilderFactory = qrKeyringBuilderFactory;
/**
 * Get builder function for a QR-based keyring, that requires a bridge
 * set up with hooks to request scanning of QR codes.
 *
 * @param Keyring - The Keyring class for the builder.
 * @param Bridge - The transport bridge class to use for the given Keyring.
 * @param bridgeHooks - The hooks to use for the bridge.
 * @returns Returns a builder function for `Keyring` with a `type` property.
 */
function qrKeyringBuilderFactory(Keyring, Bridge, bridgeHooks) {
  const builder = () => new Keyring({
    bridge: new Bridge(bridgeHooks)
  });
  builder.type = Keyring.type;
  return builder;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\qr-keyring-builder-factory.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\createMethodMiddleware.js", {"./handlers":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\index.ts","./handlers/wallet-getPermissions":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\wallet-getPermissions.ts","./handlers/wallet-requestPermissions":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\wallet-requestPermissions.ts","./handlers/wallet-revokePermissions":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\wallet-revokePermissions.ts","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-rpc-methods":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Crpc-method-middleware%5CcreateMethodMiddleware.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMultichainMethodMiddleware = exports.createEthAccountsMethodMiddleware = exports.createEip1193MethodMiddleware = void 0;
exports.makeMethodMiddlewareMaker = makeMethodMiddlewareMaker;
var _rpcErrors = require("@metamask/rpc-errors");
var _snapsRpcMethods = require("@metamask/snaps-rpc-methods");
var _utils = require("@metamask/utils");
var _handlers = require("./handlers");
var _walletGetPermissions = require("./handlers/wallet-getPermissions");
var _walletRequestPermissions = require("./handlers/wallet-requestPermissions");
var _walletRevokePermissions = require("./handlers/wallet-revokePermissions");
// The primary home of RPC method implementations for the injected 1193 provider API. MUST be subsequent
// to our permissioning logic in the EIP-1193 JSON-RPC middleware pipeline.
const createEip1193MethodMiddleware = exports.createEip1193MethodMiddleware = makeMethodMiddlewareMaker([..._handlers.handlers, ..._handlers.eip1193OnlyHandlers,
// EIP-2255 Permission handlers
_walletGetPermissions.getPermissionsHandler, _walletRequestPermissions.requestPermissionsHandler, _walletRevokePermissions.revokePermissionsHandler]);

// A collection of RPC method implementations that, for legacy reasons, MAY precede
// our permissioning logic in the EIP-1193 JSON-RPC middleware pipeline.
const createEthAccountsMethodMiddleware = exports.createEthAccountsMethodMiddleware = makeMethodMiddlewareMaker([_handlers.ethAccountsHandler]);

// The primary home of RPC method implementations for the MultiChain API.
const createMultichainMethodMiddleware = exports.createMultichainMethodMiddleware = makeMethodMiddlewareMaker(_handlers.handlers);

/**
 * Creates a method middleware factory function given a set of method handlers.
 *
 * @param {Record<string, __import__('@metamask/permission-controller').PermittedHandlerExport>} handlers - The RPC method
 * handler implementations.
 * @returns The method middleware factory function.
 */
function makeMethodMiddlewareMaker(handlers) {
  // 为每个 Handler Map 生成唯一ID以追踪
  const mapId = `Map-${Math.random().toString(36).substring(2, 8)}`;
  console.log(`🔥🔥🔥 [${mapId}] makeMethodMiddlewareMaker 被调用`);
  console.log(`📋 [${mapId}] handlers 数组长度:`, handlers.length);
  const handlerMap = handlers.reduce((map, handler) => {
    for (const methodName of handler.methodNames) {
      map[methodName] = handler;
      if (methodName === 'eth_signTransaction') {
        console.log(`   ✅ [${mapId}] 已添加: eth_signTransaction -> handler`);
      }
    }
    return map;
  }, {});
  const hasSignTx = 'eth_signTransaction' in handlerMap;
  console.log(`🔍 [${mapId}] Handler Map 中有 eth_signTransaction?`, hasSignTx);
  const expectedHookNames = new Set(handlers.flatMap(({
    hookNames
  }) => Object.getOwnPropertyNames(hookNames)));

  /**
   * Creates a json-rpc-engine middleware of RPC method implementations.
   *
   * Handlers consume functions that hook into the background, and only depend
   * on their signatures, not e.g. controller internals.
   *
   * @param  {Record<string, (...args: unknown[]) => unknown | Promise<unknown>>} hooks - Required "hooks" into our
   * controllers.
   * @returns {__import__('@metamask/json-rpc-engine').JsonRpcMiddleware<unknown, unknown>} The method middleware function.
   */
  const makeMethodMiddleware = hooks => {
    assertExpectedHook(hooks, expectedHookNames);
    console.log(`🎨 [${mapId}] 创建 middleware 实例，hooks:`, Object.keys(hooks).slice(0, 5));
    const methodMiddleware = async (req, res, next, end) => {
      const handler = handlerMap[req.method];

      // 添加详细的方法查找日志
      if (req.method === 'eth_signTransaction') {
        console.log(`🔍 [${mapId}] 检测到 eth_signTransaction 请求`);
        console.log(`🌐 [${mapId}] 请求来源:`, req.origin);
        console.log(`📋 [${mapId}] Handler Map 包含此方法?`, req.method in handlerMap);
        console.log(`🔧 [${mapId}] Handler:`, handler);
        console.log(`🗺️ [${mapId}] Handler Map 所有方法:`, Object.keys(handlerMap));
      }
      if (handler) {
        const {
          implementation,
          hookNames
        } = handler;
        if (req.method === 'eth_signTransaction') {
          console.log(`✅ [${mapId}] 找到 handler，准备调用 implementation`);
        }
        try {
          // Implementations may or may not be async, so we must await them.
          return await implementation(req, res, next, end, (0, _snapsRpcMethods.selectHooks)(hooks, hookNames));
        } catch (error) {
          if (req.method === 'eth_signTransaction') {
            console.error(`❌ [${mapId}] Handler 执行出错:`, error);
          }
          if (true) {
            console.error(error);
          }
          return end(error instanceof Error ? error : _rpcErrors.rpcErrors.internal({
            data: error
          }));
        }
      }
      if (req.method === 'eth_signTransaction') {
        console.warn(`⚠️ [${mapId}] 未找到 eth_signTransaction 的 handler，调用 next()`);
        console.log(`🔄 [${mapId}] 正在调用 next()，传递给下一个 middleware...`);
      }
      const nextResult = await next();
      if (req.method === 'eth_signTransaction') {
        console.log(`↩️ [${mapId}] next() 返回，结果:`, nextResult);
        console.log(`📋 [${mapId}] res.result:`, res.result);
      }
      return nextResult;
    };
    return methodMiddleware;
  };
  return makeMethodMiddleware;
}

/**
 * Asserts that the specified hooks object only has all expected hooks and no extraneous ones.
 *
 * @param {Record<string, unknown>} hooks - Required "hooks" into our controllers.
 * @param {string[]} expectedHookNames - The expected hook names.
 */
function assertExpectedHook(hooks, expectedHookNames) {
  const missingHookNames = [];
  expectedHookNames.forEach(hookName => {
    if (!(0, _utils.hasProperty)(hooks, hookName)) {
      missingHookNames.push(hookName);
    }
  });
  if (missingHookNames.length > 0) {
    throw new Error(`Missing expected hooks:\n\n${missingHookNames.join('\n')}\n`);
  }
  const extraneousHookNames = Object.getOwnPropertyNames(hooks).filter(hookName => !expectedHookNames.has(hookName));
  if (extraneousHookNames.length > 0) {
    throw new Error(`Received unexpected hooks:\n\n${extraneousHookNames.join('\n')}\n`);
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\rpc-method-middleware\\createMethodMiddleware.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\createUnsupportedMethodMiddleware.ts", {"../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Crpc-method-middleware%5CcreateUnsupportedMethodMiddleware.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUnsupportedMethodMiddleware = createUnsupportedMethodMiddleware;
var _rpcErrors = require("@metamask/rpc-errors");
var _network = require("../../../../shared/constants/network");
/**
 * Creates a middleware that rejects explicitly unsupported RPC methods with the
 * appropriate error.
 *
 * @param methods - The list of unsupported RPC methods.
 */
function createUnsupportedMethodMiddleware(methods = _network.UNSUPPORTED_RPC_METHODS) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async function unsupportedMethodMiddleware(req, _res, next, end) {
    if (methods.has(req.method)) {
      return end(_rpcErrors.rpcErrors.methodNotSupported());
    }
    return next();
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\rpc-method-middleware\\createUnsupportedMethodMiddleware.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\add-ethereum-chain.js", {"../../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","./ethereum-chain-utils":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\ethereum-chain-utils.js","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","uri-js":"D:\\code\\v\\metamask-extension\\node_modules\\uri-js\\dist\\es5\\uri.all.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Crpc-method-middleware%5Chandlers%5Cadd-ethereum-chain.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var URI = _interopRequireWildcard(require("uri-js"));
var _controllerUtils = require("@metamask/controller-utils");
var _networkController = require("@metamask/network-controller");
var _rpcErrors = require("@metamask/rpc-errors");
var _lodash = require("lodash");
var _app = require("../../../../../shared/constants/app");
var _ethereumChainUtils = require("./ethereum-chain-utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const addEthereumChain = {
  methodNames: [_app.MESSAGE_TYPE.ADD_ETHEREUM_CHAIN],
  implementation: addEthereumChainHandler,
  hookNames: {
    addNetwork: true,
    updateNetwork: true,
    getNetworkConfigurationByChainId: true,
    setActiveNetwork: true,
    requestUserApproval: true,
    getCurrentChainIdForDomain: true,
    getCaveat: true,
    requestPermittedChainsPermissionIncrementalForOrigin: true,
    rejectApprovalRequestsForOrigin: true,
    setTokenNetworkFilter: true,
    setEnabledNetworks: true,
    getEnabledNetworks: true
  }
};
var _default = exports.default = addEthereumChain;
async function addEthereumChainHandler(req, res, _next, end, {
  addNetwork,
  updateNetwork,
  getNetworkConfigurationByChainId,
  setActiveNetwork,
  requestUserApproval,
  getCurrentChainIdForDomain,
  getCaveat,
  requestPermittedChainsPermissionIncrementalForOrigin,
  rejectApprovalRequestsForOrigin,
  setTokenNetworkFilter,
  setEnabledNetworks,
  getEnabledNetworks
}) {
  let validParams;
  try {
    validParams = (0, _ethereumChainUtils.validateAddEthereumChainParams)(req.params[0]);
  } catch (error) {
    return end(error);
  }
  const {
    chainId,
    chainName,
    firstValidBlockExplorerUrl,
    firstValidRPCUrl,
    ticker
  } = validParams;
  const {
    origin
  } = req;
  const currentChainIdForDomain = getCurrentChainIdForDomain(origin);
  const existingNetwork = getNetworkConfigurationByChainId(chainId);
  if (existingNetwork && existingNetwork.chainId === chainId && existingNetwork.nativeCurrency !== ticker) {
    return end(_rpcErrors.rpcErrors.invalidParams({
      message: `nativeCurrency.symbol does not match currency symbol for a network the user already has added with the same chainId. Received:\n${ticker}`
    }));
  }
  let updatedNetwork = existingNetwork;
  let rpcIndex = existingNetwork === null || existingNetwork === void 0 ? void 0 : existingNetwork.rpcEndpoints.findIndex(({
    url
  }) => URI.equal(url, firstValidRPCUrl));
  let blockExplorerIndex = firstValidBlockExplorerUrl ? existingNetwork === null || existingNetwork === void 0 ? void 0 : existingNetwork.blockExplorerUrls.findIndex(url => URI.equal(url, firstValidBlockExplorerUrl)) : undefined;

  // If there's something to add or update

  const shouldAddOrUpdateNetwork = !existingNetwork || rpcIndex !== existingNetwork.defaultRpcEndpointIndex || firstValidBlockExplorerUrl && blockExplorerIndex !== existingNetwork.defaultBlockExplorerUrlIndex;
  if (shouldAddOrUpdateNetwork) {
    try {
      await requestUserApproval({
        origin,
        type: _controllerUtils.ApprovalType.AddEthereumChain,
        requestData: {
          chainId,
          rpcPrefs: {
            blockExplorerUrl: firstValidBlockExplorerUrl
          },
          chainName,
          rpcUrl: firstValidRPCUrl,
          ticker
        }
      });
      if (existingNetwork) {
        // A network for this chain id already exists.
        // Update it with any new information.

        const clonedNetwork = (0, _lodash.cloneDeep)(existingNetwork);

        // If the RPC endpoint doesn't exist, add a new one
        if (rpcIndex === -1) {
          clonedNetwork.rpcEndpoints = [...clonedNetwork.rpcEndpoints, {
            url: firstValidRPCUrl,
            type: _networkController.RpcEndpointType.Custom,
            name: chainName
          }];
          rpcIndex = clonedNetwork.rpcEndpoints.length - 1;
        }

        // The provided rpc endpoint becomes the default
        clonedNetwork.defaultRpcEndpointIndex = rpcIndex;
        if (firstValidBlockExplorerUrl) {
          // If a block explorer was provided and it doesn't exist, add a new one
          if (blockExplorerIndex === -1) {
            clonedNetwork.blockExplorerUrls = [...clonedNetwork.blockExplorerUrls, firstValidBlockExplorerUrl];
            blockExplorerIndex = clonedNetwork.blockExplorerUrls.length - 1;
          }

          // The provided block explorer becomes the default
          clonedNetwork.defaultBlockExplorerUrlIndex = blockExplorerIndex;
        }
        updatedNetwork = await updateNetwork(clonedNetwork.chainId, clonedNetwork, currentChainIdForDomain === chainId ? {
          replacementSelectedRpcEndpointIndex: clonedNetwork.defaultRpcEndpointIndex
        } : undefined);
      } else {
        // A network for this chain id does not exist, so add a new network
        updatedNetwork = await addNetwork({
          blockExplorerUrls: firstValidBlockExplorerUrl ? [firstValidBlockExplorerUrl] : [],
          defaultBlockExplorerUrlIndex: firstValidBlockExplorerUrl ? 0 : undefined,
          chainId,
          defaultRpcEndpointIndex: 0,
          name: chainName,
          nativeCurrency: ticker,
          rpcEndpoints: [{
            url: firstValidRPCUrl,
            name: chainName,
            type: _networkController.RpcEndpointType.Custom
          }]
        });
      }
    } catch (error) {
      return end(error);
    }
  }
  const {
    networkClientId
  } = updatedNetwork.rpcEndpoints[updatedNetwork.defaultRpcEndpointIndex];
  return (0, _ethereumChainUtils.switchChain)(res, end, chainId, networkClientId, {
    isAddFlow: true,
    autoApprove: shouldAddOrUpdateNetwork,
    setActiveNetwork,
    getCaveat,
    requestPermittedChainsPermissionIncrementalForOrigin,
    rejectApprovalRequestsForOrigin,
    setTokenNetworkFilter,
    setEnabledNetworks,
    getEnabledNetworks
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\rpc-method-middleware\\handlers\\add-ethereum-chain.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\eth-accounts.ts", {"../../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Crpc-method-middleware%5Chandlers%5Ceth-accounts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _app = require("../../../../../shared/constants/app");
/**
 * A wrapper for `eth_accounts` that returns an empty array when permission is denied.
 */
const ethAccounts = {
  methodNames: [_app.MESSAGE_TYPE.ETH_ACCOUNTS],
  implementation: ethAccountsHandler,
  hookNames: {
    getAccounts: true
  }
};
var _default = exports.default = ethAccounts;
/**
 *
 * @param _req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The json-rpc-engine 'next' callback.
 * @param end - The json-rpc-engine 'end' callback.
 * @param options - The RPC method hooks.
 * @param options.getAccounts - A hook that returns the permitted eth accounts for the origin sorted by lastSelected.
 */
async function ethAccountsHandler(_req, res, _next, end, {
  getAccounts
}) {
  res.result = getAccounts();
  return end();
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\rpc-method-middleware\\handlers\\eth-accounts.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\eth-sign-transaction.ts", {"@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Crpc-method-middleware%5Chandlers%5Ceth-sign-transaction.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _rpcErrors = require("@metamask/rpc-errors");
/**
 * eth_signTransaction 交易参数类型
 */

/**
 * eth_signTransaction Handler 选项类型
 */

/**
 * eth_signTransaction 方法约束类型
 */

/**
 * 处理 eth_signTransaction 请求
 *
 * @param req - JSON-RPC 请求对象
 * @param res - JSON-RPC 响应对象
 * @param _next - json-rpc-engine 'next' 回调
 * @param end - json-rpc-engine 'end' 回调
 * @param options - RPC 方法钩子
 * @param options.signTransaction - 签名交易的钩子函数
 * @param options.requestUserApproval - 请求用户批准的钩子函数
 */
async function ethSignTransactionHandler(req, res, _next, end, {
  signTransaction
}) {
  console.log('🔥🔥🔥 [eth_signTransaction] Handler 被调用！');
  console.log('📝 [eth_signTransaction] 请求:', req);
  console.log('🌐 [eth_signTransaction] 来源:', req.origin);
  console.log('📋 [eth_signTransaction] 参数:', req.params);
  console.log('🔧 [eth_signTransaction] Hooks 可用:', {
    hasSignTransaction: typeof signTransaction === 'function'
  });

  // 1. 验证参数
  const params = req.params;
  if (!params || !params[0]) {
    return end(_rpcErrors.rpcErrors.invalidParams({
      message: 'Missing transaction object'
    }));
  }
  const txParams = params[0];

  // 验证必需字段
  if (!txParams.from) {
    console.error('❌ [eth_signTransaction] 缺少 from 字段');
    return end(_rpcErrors.rpcErrors.invalidParams({
      message: 'Missing "from" field in transaction'
    }));
  }
  console.log('✅ [eth_signTransaction] 参数验证通过');
  console.log('📄 [eth_signTransaction] 交易参数:', txParams);
  console.log('🌐 [eth_signTransaction] 请求来源:', req.origin);
  try {
    console.log('🔄 [eth_signTransaction] 开始签名交易（会自动弹出确认窗口）...');

    // signTransaction hook 内部会:
    // 1. 调用 addDappTransaction (触发确认弹窗)
    // 2. 调用 approveTransaction (用户确认后签名)
    // 3. 返回 rawTx
    // 4. 清理交易 (不广播)
    const signedTx = await signTransaction(txParams, req.origin);
    console.log('✅ [eth_signTransaction] 交易签名成功！');
    console.log('📝 [eth_signTransaction] 签名结果:', signedTx);

    // 返回签名后的交易
    res.result = signedTx;
    console.log('🎉 [eth_signTransaction] 完成，返回签名交易');
    return end();
  } catch (error) {
    console.error('❌ [eth_signTransaction] 发生错误:', error);
    // 处理用户拒绝或其他错误
    if (error && typeof error === 'object' && 'code' in error && error.code === 4001) {
      console.warn('⚠️ [eth_signTransaction] 用户拒绝了交易');
      return end(_rpcErrors.providerErrors.userRejectedRequest({
        message: 'User rejected the transaction signature request'
      }));
    }
    console.error('❌ [eth_signTransaction] 未知错误，返回给调用者');
    return end(error);
  }
}

/**
 * eth_signTransaction RPC 方法处理器
 *
 * 实现离线交易签名功能：
 * 1. 验证交易参数
 * 2. 调用 signTransaction hook（内部会触发用户确认弹窗）
 * 3. 返回签名后的交易（但不广播）
 */
const ethSignTransaction = {
  methodNames: ['eth_signTransaction'],
  implementation: ethSignTransactionHandler,
  hookNames: {
    signTransaction: true
  }
};
console.log('✅ [eth_signTransaction] Handler 已注册:', ethSignTransaction.methodNames);
var _default = exports.default = ethSignTransaction;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\rpc-method-middleware\\handlers\\eth-sign-transaction.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\ethereum-chain-utils.js", {"../../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../../shared/modules/network.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\network.utils.ts","../../util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Crpc-method-middleware%5Chandlers%5Cethereum-chain-utils.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.switchChain = switchChain;
exports.validateAddEthereumChainParams = validateAddEthereumChainParams;
exports.validateChainId = validateChainId;
exports.validateSwitchEthereumChainParams = validateSwitchEthereumChainParams;
var _controllerUtils = require("@metamask/controller-utils");
var _rpcErrors = require("@metamask/rpc-errors");
var _chainAgnosticPermission = require("@metamask/chain-agnostic-permission");
var _utils = require("@metamask/utils");
var _snapsUtils = require("@metamask/snaps-utils");
var _network = require("../../../../../shared/modules/network.utils");
var _app = require("../../../../../shared/constants/app");
var _util = require("../../util");
function validateChainId(chainId) {
  const lowercasedChainId = typeof chainId === 'string' ? chainId.toLowerCase() : null;
  if (!(0, _network.isPrefixedFormattedHexString)(lowercasedChainId)) {
    throw _rpcErrors.rpcErrors.invalidParams({
      message: `Expected 0x-prefixed, unpadded, non-zero hexadecimal string 'chainId'. Received:\n${chainId}`
    });
  }
  if (!(0, _network.isSafeChainId)(parseInt(chainId, 16))) {
    throw _rpcErrors.rpcErrors.invalidParams({
      message: `Invalid chain ID "${lowercasedChainId}": numerical value greater than max safe value. Received:\n${chainId}`
    });
  }
  return lowercasedChainId;
}
function validateSwitchEthereumChainParams(req) {
  var _req$params;
  if (!((_req$params = req.params) !== null && _req$params !== void 0 && _req$params[0]) || typeof req.params[0] !== 'object') {
    throw _rpcErrors.rpcErrors.invalidParams({
      message: `Expected single, object parameter. Received:\n${JSON.stringify(req.params)}`
    });
  }
  const {
    chainId,
    ...otherParams
  } = req.params[0];
  if (Object.keys(otherParams).length > 0) {
    throw _rpcErrors.rpcErrors.invalidParams({
      message: `Received unexpected keys on object parameter. Unsupported keys:\n${Object.keys(otherParams)}`
    });
  }
  return validateChainId(chainId);
}
function validateAddEthereumChainParams(params) {
  if (!params || typeof params !== 'object') {
    throw _rpcErrors.rpcErrors.invalidParams({
      message: `Expected single, object parameter. Received:\n${JSON.stringify(params)}`
    });
  }
  const {
    chainId,
    chainName,
    blockExplorerUrls,
    nativeCurrency,
    rpcUrls,
    ...otherParams
  } = params;
  const otherKeys = Object.keys(otherParams).filter(
  // iconUrls is a valid optional but not currently used parameter
  v => !['iconUrls'].includes(v));
  if (otherKeys.length > 0) {
    throw _rpcErrors.rpcErrors.invalidParams({
      message: `Received unexpected keys on object parameter. Unsupported keys:\n${otherKeys}`
    });
  }
  const _chainId = validateChainId(chainId);
  if (!rpcUrls || !Array.isArray(rpcUrls) || rpcUrls.length === 0) {
    throw _rpcErrors.rpcErrors.invalidParams({
      message: `Expected an array with at least one valid string HTTPS url 'rpcUrls', Received:\n${rpcUrls}`
    });
  }
  const isLocalhostOrHttps = urlString => {
    const url = (0, _util.getValidUrl)(urlString);
    return url !== null && (url.hostname === 'localhost' || url.hostname === '127.0.0.1' || url.protocol === 'https:');
  };
  const firstValidRPCUrl = rpcUrls.find(rpcUrl => isLocalhostOrHttps(rpcUrl));
  const firstValidBlockExplorerUrl = Array.isArray(blockExplorerUrls) ? blockExplorerUrls.find(blockExplorerUrl => isLocalhostOrHttps(blockExplorerUrl)) : null;
  if (!firstValidRPCUrl) {
    throw _rpcErrors.rpcErrors.invalidParams({
      message: `Expected an array with at least one valid string HTTPS url 'rpcUrls', Received:\n${rpcUrls}`
    });
  }
  if (typeof chainName !== 'string' || !chainName) {
    throw _rpcErrors.rpcErrors.invalidParams({
      message: `Expected non-empty string 'chainName'. Received:\n${chainName}`
    });
  }
  const _chainName = chainName.length > 100 ? chainName.substring(0, 100) : chainName;
  if (nativeCurrency !== null) {
    if (typeof nativeCurrency !== 'object' || Array.isArray(nativeCurrency)) {
      throw _rpcErrors.rpcErrors.invalidParams({
        message: `Expected null or object 'nativeCurrency'. Received:\n${nativeCurrency}`
      });
    }
    if (nativeCurrency.decimals !== 18) {
      throw _rpcErrors.rpcErrors.invalidParams({
        message: `Expected the number 18 for 'nativeCurrency.decimals' when 'nativeCurrency' is provided. Received: ${nativeCurrency.decimals}`
      });
    }
    if (!nativeCurrency.symbol || typeof nativeCurrency.symbol !== 'string') {
      throw _rpcErrors.rpcErrors.invalidParams({
        message: `Expected a string 'nativeCurrency.symbol'. Received: ${nativeCurrency.symbol}`
      });
    }
  }
  const ticker = (nativeCurrency === null || nativeCurrency === void 0 ? void 0 : nativeCurrency.symbol) || _app.UNKNOWN_TICKER_SYMBOL;
  if (ticker !== _app.UNKNOWN_TICKER_SYMBOL && (typeof ticker !== 'string' || ticker.length < 1 || ticker.length > 6)) {
    throw _rpcErrors.rpcErrors.invalidParams({
      message: `Expected 1-6 character string 'nativeCurrency.symbol'. Received:\n${ticker}`
    });
  }
  return {
    chainId: _chainId,
    chainName: _chainName,
    firstValidBlockExplorerUrl,
    firstValidRPCUrl,
    ticker
  };
}

/**
 * Switches the active network for the origin if already permitted
 * otherwise requests approval to update permission first.
 *
 * @param response - The JSON RPC request's response object.
 * @param end - The JSON RPC request's end callback.
 * @param {string} chainId - The chainId being switched to.
 * @param {string} networkClientId - The network client being switched to.
 * @param {object} hooks - The hooks object.
 * @param {string} hooks.origin - The origin sending this request.
 * @param {boolean} hooks.isAddFlow - Variable to check if its add flow.
 * @param {boolean} hooks.isSwitchFlow - Variable to check if its switch flow.
 * @param {boolean} [hooks.autoApprove] - A boolean indicating whether the request should prompt the user or be automatically approved.
 * @param {Function} hooks.setActiveNetwork - The callback to change the current network for the origin.
 * @param {Function} hooks.getCaveat - The callback to get the CAIP-25 caveat for the origin.
 * @param {Function} hooks.requestPermittedChainsPermissionIncrementalForOrigin - The callback to add a new chain to the permittedChains-equivalent CAIP-25 permission.
 * @param {Function} hooks.setTokenNetworkFilter - The callback to set the token network filter.
 * @param {Function} hooks.setEnabledNetworks - The callback to set the enabled networks.
 * @param {Function} hooks.getEnabledNetworks - The callback to get the current enabled networks for a namespace.
 * @param {Function} hooks.rejectApprovalRequestsForOrigin - The callback to reject all pending approval requests for the origin.
 * @param {Function} hooks.requestUserApproval - The callback to trigger user approval flow.
 * @param {Function} hooks.hasApprovalRequestsForOrigin - Function to check if there are pending approval requests from the origin.
 * @param {object} hooks.toNetworkConfiguration - Network configutation of network switching to.
 * @param {object} hooks.fromNetworkConfiguration - Network configutation of network switching from.
 * @returns a null response on success or an error if user rejects an approval when autoApprove is false or on unexpected errors.
 */
async function switchChain(response, end, chainId, networkClientId, {
  origin,
  isAddFlow,
  isSwitchFlow,
  autoApprove,
  setActiveNetwork,
  getCaveat,
  requestPermittedChainsPermissionIncrementalForOrigin,
  setTokenNetworkFilter,
  setEnabledNetworks,
  getEnabledNetworks,
  rejectApprovalRequestsForOrigin,
  requestUserApproval,
  hasApprovalRequestsForOrigin,
  toNetworkConfiguration,
  fromNetworkConfiguration
}) {
  try {
    const caip25Caveat = getCaveat({
      target: _chainAgnosticPermission.Caip25EndowmentPermissionName,
      caveatType: _chainAgnosticPermission.Caip25CaveatType
    });
    if (caip25Caveat) {
      const ethChainIds = (0, _chainAgnosticPermission.getPermittedEthChainIds)(caip25Caveat.value);
      if (!ethChainIds.includes(chainId)) {
        let metadata;
        if (isSwitchFlow) {
          metadata = {
            isSwitchEthereumChain: true
          };
        }
        await requestPermittedChainsPermissionIncrementalForOrigin({
          chainId,
          autoApprove,
          metadata
        });
      } else if (hasApprovalRequestsForOrigin !== null && hasApprovalRequestsForOrigin !== void 0 && hasApprovalRequestsForOrigin() && !isAddFlow && !autoApprove) {
        await requestUserApproval({
          origin,
          type: _controllerUtils.ApprovalType.SwitchEthereumChain,
          requestData: {
            toNetworkConfiguration,
            fromNetworkConfiguration
          }
        });
      }
    } else {
      await requestPermittedChainsPermissionIncrementalForOrigin({
        chainId,
        autoApprove
      });
    }
    if (!(0, _snapsUtils.isSnapId)(origin)) {
      rejectApprovalRequestsForOrigin === null || rejectApprovalRequestsForOrigin === void 0 || rejectApprovalRequestsForOrigin();
    }
    await setActiveNetwork(networkClientId);

    // FIXME: `setTokenNetworkFilter` and `getEnabledNetworks` is currently breaking Snaps flow when ENS Snap
    // calls `wallet_switchEthereumChain` to auto-adjusts its network if necessary. For now we add this guard
    // but we want to come back and add remove the bandaid in favour of a more future proof solution for
    // this edge case. issue: https://github.com/MetaMask/metamask-extension/issues/35409
    if (!(0, _snapsUtils.isSnapId)(origin)) {
      // keeping this for backward compatibility in case we need to rollback REMOVE_GNS feature flag
      // this will keep tokenNetworkFilter in sync with enabledNetworkMap while we roll this feature out
      setTokenNetworkFilter(chainId);
      if ((0, _network.isPrefixedFormattedHexString)(chainId)) {
        const existingEnabledNetworks = getEnabledNetworks(_utils.KnownCaipNamespace.Eip155);
        const existingChainIds = Object.keys(existingEnabledNetworks);
        if (!existingChainIds.includes(chainId)) {
          setEnabledNetworks(chainId);
        }
      } else {
        const {
          namespace
        } = (0, _utils.parseCaipChainId)(chainId);
        const existingEnabledNetworks = getEnabledNetworks(namespace);
        const existingChainIds = Object.keys(existingEnabledNetworks);
        if (!existingChainIds.includes(chainId)) {
          setEnabledNetworks(chainId);
        }
      }
    }
    response.result = null;
    return end();
  } catch (error) {
    return end(error);
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\rpc-method-middleware\\handlers\\ethereum-chain-utils.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\get-provider-state.ts", {"../../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Crpc-method-middleware%5Chandlers%5Cget-provider-state.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _app = require("../../../../../shared/constants/app");
/**
 * @property chainId - The current chain ID.
 * @property isUnlocked - Whether the extension is unlocked or not.
 * @property networkVersion - The current network ID.
 * @property accounts - List of permitted accounts for the specified origin.
 */

/**
 * This RPC method gets background state relevant to the provider.
 * The background sends RPC notifications on state changes, but the provider
 * first requests state on initialization.
 */
const getProviderState = {
  methodNames: [_app.MESSAGE_TYPE.GET_PROVIDER_STATE],
  implementation: getProviderStateHandler,
  hookNames: {
    getProviderState: true
  }
};
var _default = exports.default = getProviderState;
/**
 * @param req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The json-rpc-engine 'next' callback.
 * @param end - The json-rpc-engine 'end' callback.
 * @param options
 * @param options.getProviderState - An async function that gets the current provider state.
 */
async function getProviderStateHandler(req, res, _next, end, {
  getProviderState: _getProviderState
}) {
  var _req$params;
  const isInitializingStreamProvider = (_req$params = req.params) === null || _req$params === void 0 ? void 0 : _req$params.isInitializingStreamProvider;
  res.result = {
    ...(await _getProviderState(req.origin, {
      isInitializingStreamProvider
    }))
  };
  return end();
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\rpc-method-middleware\\handlers\\get-provider-state.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\index.ts", {"./add-ethereum-chain":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\add-ethereum-chain.js","./eth-accounts":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\eth-accounts.ts","./eth-sign-transaction":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\eth-sign-transaction.ts","./get-provider-state":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\get-provider-state.ts","./log-web3-shim-usage":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\log-web3-shim-usage.ts","./request-accounts":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\request-accounts.ts","./send-metadata":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\send-metadata.ts","./switch-ethereum-chain":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\switch-ethereum-chain.js","./watch-asset":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\watch-asset.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Crpc-method-middleware%5Chandlers%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handlers = exports.ethAccountsHandler = exports.eip1193OnlyHandlers = void 0;
var _addEthereumChain = _interopRequireDefault(require("./add-ethereum-chain"));
var _ethAccounts = _interopRequireDefault(require("./eth-accounts"));
var _ethSignTransaction = _interopRequireDefault(require("./eth-sign-transaction"));
var _getProviderState = _interopRequireDefault(require("./get-provider-state"));
var _logWeb3ShimUsage = _interopRequireDefault(require("./log-web3-shim-usage"));
var _requestAccounts = _interopRequireDefault(require("./request-accounts"));
var _sendMetadata = _interopRequireDefault(require("./send-metadata"));
var _switchEthereumChain = _interopRequireDefault(require("./switch-ethereum-chain"));
var _watchAsset = _interopRequireDefault(require("./watch-asset"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const handlers = exports.handlers = [_addEthereumChain.default, _getProviderState.default, _logWeb3ShimUsage.default, _sendMetadata.default, _watchAsset.default];
const eip1193OnlyHandlers = exports.eip1193OnlyHandlers = [_switchEthereumChain.default, _ethAccounts.default, _requestAccounts.default, _ethSignTransaction.default];
console.log('🔥🔥🔥 [Handlers] eip1193OnlyHandlers 数组:', eip1193OnlyHandlers);
console.log('✅ [Handlers] eip1193OnlyHandlers 已注册:', eip1193OnlyHandlers.map(h => h.methodNames).flat());
console.log('🔍 [Handlers] ethSignTransaction handler:', _ethSignTransaction.default);
console.log('🔍 [Handlers] ethSignTransaction.methodNames:', _ethSignTransaction.default.methodNames);
const ethAccountsHandler = exports.ethAccountsHandler = _ethAccounts.default;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\rpc-method-middleware\\handlers\\index.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\log-web3-shim-usage.ts", {"../../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Crpc-method-middleware%5Chandlers%5Clog-web3-shim-usage.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _app = require("../../../../../shared/constants/app");
/**
 * This RPC method is called by the inpage provider whenever it detects the
 * accessing of a non-existent property on our window.web3 shim. We use this
 * to alert the user that they are using a legacy dapp, and will have to take
 * further steps to be able to use it.
 */
const logWeb3ShimUsage = {
  methodNames: [_app.MESSAGE_TYPE.LOG_WEB3_SHIM_USAGE],
  implementation: logWeb3ShimUsageHandler,
  hookNames: {
    getWeb3ShimUsageState: true,
    setWeb3ShimUsageRecorded: true
  }
};
var _default = exports.default = logWeb3ShimUsage;
/**
 * @param req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The json-rpc-engine 'next' callback.
 * @param end - The json-rpc-engine 'end' callback.
 * @param options
 * @param options.getWeb3ShimUsageState - A function that gets web3 shim
 * usage state for the given origin.
 * @param options.setWeb3ShimUsageRecorded - A function that records web3 shim
 * usage for a particular origin.
 */
function logWeb3ShimUsageHandler(req, res, _next, end, {
  getWeb3ShimUsageState,
  setWeb3ShimUsageRecorded
}) {
  const {
    origin
  } = req;
  if (getWeb3ShimUsageState(origin) === undefined) {
    setWeb3ShimUsageRecorded(origin);
  }
  res.result = true;
  return end();
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\rpc-method-middleware\\handlers\\log-web3-shim-usage.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\request-accounts.ts", {"../../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Crpc-method-middleware%5Chandlers%5Crequest-accounts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _rpcErrors = require("@metamask/rpc-errors");
var _app = require("../../../../../shared/constants/app");
var _metametrics = require("../../../../../shared/constants/metametrics");
var _util = require("../../util");
const requestEthereumAccounts = {
  methodNames: [_app.MESSAGE_TYPE.ETH_REQUEST_ACCOUNTS],
  implementation: requestEthereumAccountsHandler,
  hookNames: {
    getAccounts: true,
    sendMetrics: true,
    metamaskState: true,
    getCaip25PermissionFromLegacyPermissionsForOrigin: true,
    requestPermissionsForOrigin: true
  }
};
var _default = exports.default = requestEthereumAccounts; // Used to rate-limit pending requests to one per origin
const locks = new Set();

/**
 * This method attempts to retrieve the Ethereum accounts available to the
 * requester, or initiate a request for account access if none are currently
 * available. It is essentially a wrapper of wallet_requestPermissions that
 * only errors if the user rejects the request. We maintain the method for
 * backwards compatibility reasons.
 *
 * @param req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The json-rpc-engine 'next' callback.
 * @param end - The json-rpc-engine 'end' callback.
 * @param options - The RPC method hooks.
 * @param options.getAccounts - Gets the accounts for the requesting origin.
 * @param options.sendMetrics - submits a metametrics event, not waiting for it to complete or allowing its error to bubble up
 * @param options.metamaskState
 * @param options.getCaip25PermissionFromLegacyPermissionsForOrigin - A hook that returns a CAIP-25 permission from a legacy `eth_accounts` and `endowment:permitted-chains` permission.
 * @param options.requestPermissionsForOrigin - A hook that requests CAIP-25 permissions for the origin.
 */
async function requestEthereumAccountsHandler(req, res, _next, end, {
  getAccounts,
  sendMetrics,
  metamaskState,
  getCaip25PermissionFromLegacyPermissionsForOrigin,
  requestPermissionsForOrigin
}) {
  const {
    origin
  } = req ?? {};
  if (locks.has(origin)) {
    res.error = _rpcErrors.rpcErrors.resourceUnavailable(`Already processing ${_app.MESSAGE_TYPE.ETH_REQUEST_ACCOUNTS}. Please wait.`);
    return end();
  }
  let ethAccounts = getAccounts(origin);
  if (ethAccounts.length > 0) {
    // We wait for the extension to unlock in this case only, because permission
    // requests are handled when the extension is unlocked, regardless of the
    // lock state when they were received.
    try {
      locks.add(origin);
      res.result = ethAccounts;
      end();
    } catch (error) {
      end(error);
    } finally {
      locks.delete(origin);
    }
    return undefined;
  }
  try {
    const caip25Permission = getCaip25PermissionFromLegacyPermissionsForOrigin();
    await requestPermissionsForOrigin(caip25Permission);
  } catch (error) {
    return end(error);
  }

  // We cannot derive ethAccounts directly from the CAIP-25 permission
  // because the accounts will not be in order of lastSelected
  ethAccounts = getAccounts(origin);

  // first time connection to dapp will lead to no log in the permissionHistory
  // and if user has connected to dapp before, the dapp origin will be included in the permissionHistory state
  // we will leverage that to identify `is_first_visit` for metrics
  if ((0, _util.shouldEmitDappViewedEvent)(metamaskState.metaMetricsId)) {
    const isFirstVisit = !Object.keys(metamaskState.permissionHistory).includes(origin);
    sendMetrics({
      event: _metametrics.MetaMetricsEventName.DappViewed,
      category: _metametrics.MetaMetricsEventCategory.InpageProvider,
      referrer: {
        url: origin
      },
      properties: {
        // eslint-disable-next-line @typescript-eslint/naming-convention
        is_first_visit: isFirstVisit,
        // eslint-disable-next-line @typescript-eslint/naming-convention
        number_of_accounts: Object.keys(metamaskState.accounts).length,
        // eslint-disable-next-line @typescript-eslint/naming-convention
        number_of_accounts_connected: ethAccounts.length
      }
    }, {
      excludeMetaMetricsId: true
    });
  }
  res.result = ethAccounts;
  return end();
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\rpc-method-middleware\\handlers\\request-accounts.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\send-metadata.ts", {"../../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Crpc-method-middleware%5Chandlers%5Csend-metadata.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _rpcErrors = require("@metamask/rpc-errors");
var _utils = require("@metamask/utils");
var _app = require("../../../../../shared/constants/app");
/**
 * This internal method is used by our external provider to send metadata about
 * permission subjects so that we can e.g. display a proper name and icon in
 * our UI.
 */
const sendMetadata = {
  methodNames: [_app.MESSAGE_TYPE.SEND_METADATA],
  implementation: sendMetadataHandler,
  hookNames: {
    addSubjectMetadata: true,
    subjectType: true
  }
};
var _default = exports.default = sendMetadata;
/**
 * @param req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The json-rpc-engine 'next' callback.
 * @param end - The json-rpc-engine 'end' callback.
 * @param options
 * @param options.addSubjectMetadata - A function that records subject
 * metadata, bound to the requesting origin.
 * @param options.subjectType - The type of the requesting origin / subject.
 */
function sendMetadataHandler(req, res, _next, end, {
  addSubjectMetadata,
  subjectType
}) {
  const {
    origin,
    params
  } = req;
  if ((0, _utils.isObject)(params)) {
    const {
      icon = null,
      name = null,
      ...remainingParams
    } = params;
    addSubjectMetadata({
      ...remainingParams,
      iconUrl: icon,
      name,
      subjectType,
      origin
    });
  } else {
    return end(_rpcErrors.rpcErrors.invalidParams({
      data: params
    }));
  }
  res.result = true;
  return end();
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\rpc-method-middleware\\handlers\\send-metadata.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\switch-ethereum-chain.js", {"../../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","./ethereum-chain-utils":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\ethereum-chain-utils.js","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Crpc-method-middleware%5Chandlers%5Cswitch-ethereum-chain.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _rpcErrors = require("@metamask/rpc-errors");
var _snapsUtils = require("@metamask/snaps-utils");
var _app = require("../../../../../shared/constants/app");
var _ethereumChainUtils = require("./ethereum-chain-utils");
const switchEthereumChain = {
  methodNames: [_app.MESSAGE_TYPE.SWITCH_ETHEREUM_CHAIN],
  implementation: switchEthereumChainHandler,
  hookNames: {
    getNetworkConfigurationByChainId: true,
    setActiveNetwork: true,
    requestUserApproval: true,
    getCaveat: true,
    getCurrentChainIdForDomain: true,
    requestPermittedChainsPermissionIncrementalForOrigin: true,
    rejectApprovalRequestsForOrigin: true,
    setTokenNetworkFilter: true,
    setEnabledNetworks: true,
    getEnabledNetworks: true,
    hasApprovalRequestsForOrigin: true
  }
};
var _default = exports.default = switchEthereumChain;
async function switchEthereumChainHandler(req, res, _next, end, {
  getNetworkConfigurationByChainId,
  setActiveNetwork,
  requestUserApproval,
  getCaveat,
  getCurrentChainIdForDomain,
  requestPermittedChainsPermissionIncrementalForOrigin,
  rejectApprovalRequestsForOrigin,
  setTokenNetworkFilter,
  setEnabledNetworks,
  getEnabledNetworks,
  hasApprovalRequestsForOrigin
}) {
  let chainId;
  try {
    chainId = (0, _ethereumChainUtils.validateSwitchEthereumChainParams)(req);
  } catch (error) {
    return end(error);
  }
  const {
    origin
  } = req;
  const currentChainIdForOrigin = getCurrentChainIdForDomain(origin);
  if (currentChainIdForOrigin === chainId) {
    res.result = null;
    return end();
  }
  const networkConfigurationForRequestedChainId = getNetworkConfigurationByChainId(chainId);
  const networkClientIdToSwitchTo = networkConfigurationForRequestedChainId === null || networkConfigurationForRequestedChainId === void 0 ? void 0 : networkConfigurationForRequestedChainId.rpcEndpoints[networkConfigurationForRequestedChainId.defaultRpcEndpointIndex].networkClientId;
  if (!networkClientIdToSwitchTo) {
    return end(_rpcErrors.providerErrors.custom({
      code: 4902,
      message: `Unrecognized chain ID "${chainId}". Try adding the chain using ${_app.MESSAGE_TYPE.ADD_ETHEREUM_CHAIN} first.`
    }));
  }
  const fromNetworkConfiguration = getNetworkConfigurationByChainId(currentChainIdForOrigin);
  const toNetworkConfiguration = getNetworkConfigurationByChainId(chainId);
  return (0, _ethereumChainUtils.switchChain)(res, end, chainId, networkClientIdToSwitchTo, {
    origin,
    isSwitchFlow: true,
    autoApprove: (0, _snapsUtils.isSnapId)(origin),
    setActiveNetwork,
    getCaveat,
    requestPermittedChainsPermissionIncrementalForOrigin,
    rejectApprovalRequestsForOrigin,
    setTokenNetworkFilter,
    setEnabledNetworks,
    getEnabledNetworks,
    requestUserApproval,
    hasApprovalRequestsForOrigin,
    toNetworkConfiguration,
    fromNetworkConfiguration
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\rpc-method-middleware\\handlers\\switch-ethereum-chain.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\wallet-getPermissions.ts", {"../../../../../shared/constants/permissions":"D:\\code\\v\\metamask-extension\\shared\\constants\\permissions.ts","../../../controllers/permissions":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\permissions\\index.js","@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Crpc-method-middleware%5Chandlers%5Cwallet-getPermissions.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPermissionsHandler = void 0;
var _permissionController = require("@metamask/permission-controller");
var _chainAgnosticPermission = require("@metamask/chain-agnostic-permission");
var _permissions = require("../../../controllers/permissions");
var _permissions2 = require("../../../../../shared/constants/permissions");
const getPermissionsHandler = exports.getPermissionsHandler = {
  methodNames: [_permissionController.MethodNames.GetPermissions],
  implementation: getPermissionsImplementation,
  hookNames: {
    getPermissionsForOrigin: true,
    getAccounts: true
  }
};

/**
 * Get Permissions implementation to be used in JsonRpcEngine middleware.
 *
 * @param _req - The JsonRpcEngine request - unused
 * @param res - The JsonRpcEngine result object
 * @param _next - JsonRpcEngine next() callback - unused
 * @param end - JsonRpcEngine end() callback
 * @param options - Method hooks passed to the method implementation
 * @param options.getPermissionsForOrigin - The specific method hook needed for this method implementation
 * @param options.getAccounts - A hook that returns the permitted eth accounts for the origin sorted by lastSelected.
 * @returns A promise that resolves to nothing
 */
async function getPermissionsImplementation(_req, res, _next, end, {
  getPermissionsForOrigin,
  getAccounts
}) {
  var _caip25Endowment$cave;
  const permissions = {
    ...getPermissionsForOrigin()
  };
  const caip25Endowment = permissions[_chainAgnosticPermission.Caip25EndowmentPermissionName];
  const caip25CaveatValue = caip25Endowment === null || caip25Endowment === void 0 || (_caip25Endowment$cave = caip25Endowment.caveats) === null || _caip25Endowment$cave === void 0 || (_caip25Endowment$cave = _caip25Endowment$cave.find(({
    type
  }) => type === _chainAgnosticPermission.Caip25CaveatType)) === null || _caip25Endowment$cave === void 0 ? void 0 : _caip25Endowment$cave.value;
  delete permissions[_chainAgnosticPermission.Caip25EndowmentPermissionName];
  if (caip25CaveatValue) {
    // We cannot derive ethAccounts directly from the CAIP-25 permission
    // because the accounts will not be in order of lastSelected
    const ethAccounts = getAccounts();
    if (ethAccounts.length > 0) {
      permissions[_permissions2.RestrictedMethods.eth_accounts] = {
        ...caip25Endowment,
        parentCapability: _permissions2.RestrictedMethods.eth_accounts,
        caveats: [{
          type: _permissions2.CaveatTypes.restrictReturnedAccounts,
          value: ethAccounts
        }]
      };
    }
    const ethChainIds = (0, _chainAgnosticPermission.getPermittedEthChainIds)(caip25CaveatValue);
    if (ethChainIds.length > 0) {
      permissions[_permissions.PermissionNames.permittedChains] = {
        ...caip25Endowment,
        parentCapability: _permissions.PermissionNames.permittedChains,
        caveats: [{
          type: _permissions2.CaveatTypes.restrictNetworkSwitching,
          value: ethChainIds
        }]
      };
    }
  }
  res.result = Object.values(permissions);
  return end();
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\rpc-method-middleware\\handlers\\wallet-getPermissions.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\wallet-requestPermissions.ts", {"../../../../../shared/constants/permissions":"D:\\code\\v\\metamask-extension\\shared\\constants\\permissions.ts","../../../controllers/permissions":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\permissions\\index.js","@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Crpc-method-middleware%5Chandlers%5Cwallet-requestPermissions.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requestPermissionsHandler = void 0;
var _lodash = require("lodash");
var _controllerUtils = require("@metamask/controller-utils");
var _permissionController = require("@metamask/permission-controller");
var _chainAgnosticPermission = require("@metamask/chain-agnostic-permission");
var _permissions = require("../../../../../shared/constants/permissions");
var _permissions2 = require("../../../controllers/permissions");
const requestPermissionsHandler = exports.requestPermissionsHandler = {
  methodNames: [_permissionController.MethodNames.RequestPermissions],
  implementation: requestPermissionsImplementation,
  hookNames: {
    getAccounts: true,
    requestPermissionsForOrigin: true,
    getCaip25PermissionFromLegacyPermissionsForOrigin: true
  }
};

/**
 * Request Permissions implementation to be used in JsonRpcEngine middleware.
 *
 * @param req - The JsonRpcEngine request
 * @param res - The JsonRpcEngine result object
 * @param _next - JsonRpcEngine next() callback - unused
 * @param end - JsonRpcEngine end() callback
 * @param options - Method hooks passed to the method implementation
 * @param options.getAccounts - A hook that returns the permitted eth accounts for the origin sorted by lastSelected.
 * @param options.getCaip25PermissionFromLegacyPermissionsForOrigin - A hook that returns a CAIP-25 permission from a legacy `eth_accounts` and `endowment:permitted-chains` permission.
 * @param options.requestPermissionsForOrigin - A hook that requests CAIP-25 permissions for the origin.
 * @returns A promise that resolves to nothing
 */
async function requestPermissionsImplementation(req, res, _next, end, {
  getAccounts,
  requestPermissionsForOrigin,
  getCaip25PermissionFromLegacyPermissionsForOrigin
}) {
  const {
    params
  } = req;
  if (!Array.isArray(params) || !(0, _controllerUtils.isPlainObject)(params[0])) {
    return end((0, _permissionController.invalidParams)({
      data: {
        request: req
      }
    }));
  }
  let [requestedPermissions] = params;
  delete requestedPermissions[_chainAgnosticPermission.Caip25EndowmentPermissionName];
  const caip25EquivalentPermissions = (0, _lodash.pick)(requestedPermissions, [_permissions.RestrictedMethods.eth_accounts, _permissions2.PermissionNames.permittedChains]);
  delete requestedPermissions[_permissions.RestrictedMethods.eth_accounts];
  delete requestedPermissions[_permissions2.PermissionNames.permittedChains];
  const hasCaip25EquivalentPermissions = Object.keys(caip25EquivalentPermissions).length > 0;
  if (hasCaip25EquivalentPermissions) {
    const caip25Permission = getCaip25PermissionFromLegacyPermissionsForOrigin(caip25EquivalentPermissions);
    requestedPermissions = {
      ...requestedPermissions,
      ...caip25Permission
    };
  }
  let grantedPermissions = {};
  const [frozenGrantedPermissions] = await requestPermissionsForOrigin(requestedPermissions);
  grantedPermissions = {
    ...frozenGrantedPermissions
  };
  if (hasCaip25EquivalentPermissions) {
    var _caip25Endowment$cave;
    const caip25Endowment = grantedPermissions[_chainAgnosticPermission.Caip25EndowmentPermissionName];
    if (!caip25Endowment) {
      throw new Error(`could not find ${_chainAgnosticPermission.Caip25EndowmentPermissionName} permission.`);
    }
    const caip25CaveatValue = (_caip25Endowment$cave = caip25Endowment.caveats) === null || _caip25Endowment$cave === void 0 || (_caip25Endowment$cave = _caip25Endowment$cave.find(({
      type
    }) => type === _chainAgnosticPermission.Caip25CaveatType)) === null || _caip25Endowment$cave === void 0 ? void 0 : _caip25Endowment$cave.value;
    if (!caip25CaveatValue) {
      throw new Error(`could not find ${_chainAgnosticPermission.Caip25CaveatType} in granted ${_chainAgnosticPermission.Caip25EndowmentPermissionName} permission.`);
    }
    delete grantedPermissions[_chainAgnosticPermission.Caip25EndowmentPermissionName];
    // We cannot derive correct eth_accounts value directly from the CAIP-25 permission
    // because the accounts will not be in order of lastSelected
    const ethAccounts = getAccounts(origin);
    grantedPermissions[_permissions.RestrictedMethods.eth_accounts] = {
      ...caip25Endowment,
      parentCapability: _permissions.RestrictedMethods.eth_accounts,
      caveats: [{
        type: _permissions.CaveatTypes.restrictReturnedAccounts,
        value: ethAccounts
      }]
    };
    const ethChainIds = (0, _chainAgnosticPermission.getPermittedEthChainIds)(caip25CaveatValue);
    if (ethChainIds.length > 0) {
      grantedPermissions[_permissions2.PermissionNames.permittedChains] = {
        ...caip25Endowment,
        parentCapability: _permissions2.PermissionNames.permittedChains,
        caveats: [{
          type: _permissions.CaveatTypes.restrictNetworkSwitching,
          value: ethChainIds
        }]
      };
    }
  }
  res.result = Object.values(grantedPermissions).filter(permission => permission !== undefined);
  return end();
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\rpc-method-middleware\\handlers\\wallet-requestPermissions.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\wallet-revokePermissions.ts", {"../../../../../shared/constants/permissions":"D:\\code\\v\\metamask-extension\\shared\\constants\\permissions.ts","../../../controllers/permissions":"D:\\code\\v\\metamask-extension\\app\\scripts\\controllers\\permissions\\index.js","@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Crpc-method-middleware%5Chandlers%5Cwallet-revokePermissions.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.revokePermissionsHandler = void 0;
var _permissionController = require("@metamask/permission-controller");
var _utils = require("@metamask/utils");
var _chainAgnosticPermission = require("@metamask/chain-agnostic-permission");
var _permissions = require("../../../../../shared/constants/permissions");
var _permissions2 = require("../../../controllers/permissions");
const revokePermissionsHandler = exports.revokePermissionsHandler = {
  methodNames: [_permissionController.MethodNames.RevokePermissions],
  implementation: revokePermissionsImplementation,
  hookNames: {
    revokePermissionsForOrigin: true,
    rejectApprovalRequestsForOrigin: true,
    updateCaveat: true
  }
};

/**
 * Revoke Permissions implementation to be used in JsonRpcEngine middleware.
 *
 * @param req - The JsonRpcEngine request
 * @param res - The JsonRpcEngine result object
 * @param _next - JsonRpcEngine next() callback - unused
 * @param end - JsonRpcEngine end() callback
 * @param options - Method hooks passed to the method implementation
 * @param options.revokePermissionsForOrigin - A hook that revokes given permission keys for an origin
 * @param options.rejectApprovalRequestsForOrigin - A hook that rejects pending confirmation for an origin
 * @returns A promise that resolves to nothing
 */
function revokePermissionsImplementation(req, res, _next, end, {
  revokePermissionsForOrigin,
  rejectApprovalRequestsForOrigin
}) {
  const {
    params
  } = req;
  const param = params === null || params === void 0 ? void 0 : params[0];
  if (!param) {
    return end((0, _permissionController.invalidParams)({
      data: {
        request: req
      }
    }));
  }

  // For now, this API revokes the entire permission key
  // even if caveats are specified.
  const permissionKeys = Object.keys(param).filter(name => name !== _chainAgnosticPermission.Caip25EndowmentPermissionName);
  if (!(0, _utils.isNonEmptyArray)(permissionKeys)) {
    return end((0, _permissionController.invalidParams)({
      data: {
        request: req
      }
    }));
  }
  const caip25EquivalentPermissions = [_permissions.RestrictedMethods.eth_accounts, _permissions2.PermissionNames.permittedChains];
  const relevantPermissionKeys = permissionKeys.filter(name => !caip25EquivalentPermissions.includes(name));
  const shouldRevokeLegacyPermission = relevantPermissionKeys.length !== permissionKeys.length;
  if (shouldRevokeLegacyPermission) {
    relevantPermissionKeys.push(_chainAgnosticPermission.Caip25EndowmentPermissionName);
  }
  revokePermissionsForOrigin(relevantPermissionKeys);
  rejectApprovalRequestsForOrigin();
  res.result = null;
  return end();
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\rpc-method-middleware\\handlers\\wallet-revokePermissions.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\handlers\\watch-asset.ts", {"../../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Crpc-method-middleware%5Chandlers%5Cwatch-asset.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _rpcErrors = require("@metamask/rpc-errors");
var _controllerUtils = require("@metamask/controller-utils");
var _app = require("../../../../../shared/constants/app");
const watchAsset = {
  methodNames: [_app.MESSAGE_TYPE.WATCH_ASSET, _app.MESSAGE_TYPE.WATCH_ASSET_LEGACY],
  implementation: watchAssetHandler,
  hookNames: {
    handleWatchAssetRequest: true
  }
};
var _default = exports.default = watchAsset;
/**
 * @param req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The json-rpc-engine 'next' callback.
 * @param end - The json-rpc-engine 'end' callback.
 * @param options
 * @param options.handleWatchAssetRequest - The wallet_watchAsset method implementation.
 */
async function watchAssetHandler(req, res, _next, end, {
  handleWatchAssetRequest
}) {
  try {
    const {
      params: {
        options: asset,
        type
      },
      origin,
      networkClientId
    } = req;
    const {
      tokenId
    } = asset;
    if ([_controllerUtils.ERC721, _controllerUtils.ERC1155].includes(type) && tokenId !== undefined && typeof tokenId !== 'string') {
      return end(_rpcErrors.rpcErrors.invalidParams({
        message: `Expected parameter 'tokenId' to be type 'string'. Received type '${typeof tokenId}'`
      }));
    }
    await handleWatchAssetRequest({
      asset,
      type,
      origin: origin ?? '',
      networkClientId: networkClientId ?? ''
    });
    res.result = true;
    return end();
  } catch (error) {
    return end(error);
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\rpc-method-middleware\\handlers\\watch-asset.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\index.js", {"./createMethodMiddleware":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\createMethodMiddleware.js","./createUnsupportedMethodMiddleware":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\rpc-method-middleware\\createUnsupportedMethodMiddleware.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Crpc-method-middleware%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _createMethodMiddleware = require("./createMethodMiddleware");
Object.keys(_createMethodMiddleware).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _createMethodMiddleware[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _createMethodMiddleware[key];
    }
  });
});
var _createUnsupportedMethodMiddleware = require("./createUnsupportedMethodMiddleware");
Object.keys(_createUnsupportedMethodMiddleware).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _createUnsupportedMethodMiddleware[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _createUnsupportedMethodMiddleware[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\rpc-method-middleware\\index.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\safe-reload.ts", {"./operation-safener":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\operation-safener.ts","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","webextension-polyfill":"D:\\code\\v\\metamask-extension\\node_modules\\webextension-polyfill\\dist\\browser-polyfill.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Csafe-reload.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRequestSafeReload = getRequestSafeReload;
var _webextensionPolyfill = _interopRequireDefault(require("webextension-polyfill"));
var _loglevel = _interopRequireDefault(require("loglevel"));
var _operationSafener = require("./operation-safener");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const {
  sentry
} = global;

/**
 * Creates a request-safe reload mechanism for the given persistence manager.
 *
 * @param persistenceManager - The PersistenceManager instance to be used for
 * updates.
 */
function getRequestSafeReload(persistenceManager) {
  const operationSafener = new _operationSafener.OperationSafener({
    op: async state => {
      try {
        await persistenceManager.set(state);
      } catch (error) {
        // unlikely to have an error here, as `persistenceManager.set` handles
        // nearly all error cases internally already.
        _loglevel.default.error('MetaMask - Persistence failed', error);
        sentry === null || sentry === void 0 || sentry.captureException(error);
      }
    },
    wait: 1000
  });
  return {
    /**
     * Safely updates the persistence manager with the provided parameters.
     *
     * @param params - Parameters to be passed to the persistence manager's
     * `set` method.
     * @returns true if the update was queued, false if writes are not allowed.
     */
    update: async (...params) => {
      return operationSafener.execute(...params);
    },
    /**
     * Requests a safe reload of the browser. It prevents any new updates from
     * being sent to the persistence manager, and waits for any
     * pending updates to complete before calling `browser.runtime.reload()`.
     */
    requestSafeReload: async () => {
      await operationSafener.evacuate();
      _webextensionPolyfill.default.runtime.reload();
    }
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\safe-reload.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\segment\\analytics.js", {"../util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","@segment/loosely-validate-event":"D:\\code\\v\\metamask-extension\\node_modules\\@segment\\loosely-validate-event\\index.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js","is-retry-allowed":"D:\\code\\v\\metamask-extension\\node_modules\\is-retry-allowed\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","remove-trailing-slash":"D:\\code\\v\\metamask-extension\\node_modules\\remove-trailing-slash\\index.js","timers":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\timers-browserify\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Csegment%5Canalytics.js
      return function (require, module, exports) {
(function (Buffer,setImmediate){(function (){
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _removeTrailingSlash = _interopRequireDefault(require("remove-trailing-slash"));
var _looselyValidateEvent = _interopRequireDefault(require("@segment/loosely-validate-event"));
var _lodash = require("lodash");
var _isRetryAllowed = _interopRequireDefault(require("is-retry-allowed"));
var _util = require("../util");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const noop = () => ({});

// Method below is inspired from axios-retry https://github.com/softonic/axios-retry
function isNetworkError(error) {
  return !error.response && Boolean(error.code) &&
  // Prevents retrying cancelled requests
  error.code !== 'ECONNABORTED' &&
  // Prevents retrying timed out requests
  (0, _isRetryAllowed.default)(error); // Prevents retrying unsafe errors
}
class Analytics {
  /**
   * Initialize a new `Analytics` with Segment project's `writeKey` and an
   * optional dictionary of `options`.
   *
   * @param {string} writeKey
   * @param {object} [options] - (optional)
   * @property {number} [flushAt] (default: 20)
   * @property {number} [flushInterval] (default: 10000)
   * @property {string} [host] (default: 'https://api.segment.io')
   */
  constructor(writeKey, options = {}) {
    this.writeKey = writeKey;
    this.host = (0, _removeTrailingSlash.default)(options.host || 'https://api.segment.io');
    this.flushInterval = options.flushInterval || 10000;
    this.flushAt = options.flushAt || Math.max(options.flushAt, 1) || 20;
    this.queue = [];
    this.path = '/v1/batch';
    this.maxQueueSize = 1024 * 450;
    this.flushed = false;
    this.retryCount = 3;
    Object.defineProperty(this, 'enable', {
      configurable: false,
      writable: false,
      enumerable: true,
      value: true
    });
  }
  _validate(message, type) {
    (0, _looselyValidateEvent.default)(message, type);
  }
  _message(type, message, callback) {
    this._validate(message, type);
    this.enqueue(type, message, callback);
    return this;
  }

  /**
   * Send an identify `message`.
   *
   * @param {object} message
   * @param {Function} [callback] - (optional)
   * @returns {Analytics}
   */
  identify(message, callback) {
    return this._message('identify', message, callback);
  }

  /**
   * Send a track `message`.
   *
   * @param {object} message
   * @param {Function} [callback] - (optional)
   * @returns {Analytics}
   */
  track(message, callback) {
    return this._message('track', message, callback);
  }

  /**
   * Send a page `message`.
   *
   * @param {object} message
   * @param {Function} [callback] - (optional)
   * @returns {Analytics}
   */
  page(message, callback) {
    return this._message('page', message, callback);
  }

  /**
   * Add a `message` of type `type` to the queue and
   * check whether it should be flushed.
   *
   * @param {string} type
   * @param {object} msg
   * @param {Function} [callback] - (optional)
   */
  enqueue(type, msg, callback = noop) {
    if (!this.enable) {
      setImmediate(callback);
      return;
    }
    const message = {
      ...msg,
      type
    };

    // Specifying library here helps segment to understand structure of request.
    // Currently segment seems to support these source libraries only.
    message.context = {
      ...message.context,
      library: {
        name: 'analytics-node'
      }
    };
    if (!message.timestamp) {
      message.timestamp = new Date();
    }
    if (!message.messageId) {
      message.messageId = (0, _util.generateRandomId)();
    }
    if (message.anonymousId && !(0, _lodash.isString)(message.anonymousId)) {
      message.anonymousId = JSON.stringify(message.anonymousId);
    }
    if (message.userId && !(0, _lodash.isString)(message.userId)) {
      message.userId = JSON.stringify(message.userId);
    }
    this.queue.push({
      message,
      callback
    });
    if (!this.flushed) {
      this.flushed = true;
      this.flush();
      return;
    }
    const hasReachedFlushAt = this.queue.length >= this.flushAt;
    const hasReachedQueueSize = this.queue.reduce((acc, item) => acc + JSON.stringify(item).length, 0) >= this.maxQueueSize;
    if (hasReachedFlushAt || hasReachedQueueSize) {
      this.flush();
    }
    if (this.flushInterval && !this.timer) {
      this.timer = setTimeout(this.flush.bind(this), this.flushInterval);
    }
  }

  /**
   * Flush the current queue
   *
   * @param {Function} [callback] - (optional)
   */
  flush(callback = noop) {
    if (!this.enable) {
      setImmediate(callback);
      return Promise.resolve();
    }
    if (this.timer) {
      clearTimeout(this.timer);
      this.timer = null;
    }
    if (!this.queue.length) {
      setImmediate(callback);
      return Promise.resolve();
    }
    const items = this.queue.splice(0, this.flushAt);
    const callbacks = items.map(item => item.callback);
    const messages = items.map(item => item.message);
    const data = {
      batch: messages,
      timestamp: new Date(),
      sentAt: new Date()
    };
    const done = err => {
      setImmediate(() => {
        callbacks.forEach(fn => fn(err, data));
        callback(err, data);
      });
    };
    const headers = {
      Authorization: `Basic ${Buffer.from(this.writeKey, 'utf8').toString('base64')}`
    };
    return this._sendRequest(`${this.host}${this.path}`, {
      method: 'POST',
      body: JSON.stringify(data),
      headers
    }, done, 0);
  }
  _retryRequest(url, body, done, retryNo) {
    const delay = Math.pow(2, retryNo) * 100;
    setTimeout(() => {
      this._sendRequest(url, body, done, retryNo + 1);
    }, delay);
  }
  async _sendRequest(url, body, done, retryNo) {
    return fetch(url, body).then(async response => {
      if (response.ok) {
        done();
      } else if (this._isErrorRetryable({
        response
      }) && retryNo <= this.retryCount) {
        this._retryRequest(url, body, done, retryNo);
      } else {
        const error = new Error(response.statusText);
        done(error);
      }
    }).catch(error => {
      if (this._isErrorRetryable(error) && retryNo <= this.retryCount) {
        this._retryRequest(url, body, done, retryNo);
      } else {
        done(error);
      }
    });
  }
  _isErrorRetryable(error) {
    // Retry Network Errors.
    if (isNetworkError(error)) {
      return true;
    }
    if (!error.response) {
      // Cannot determine if the request can be retried
      return false;
    }

    // Retry Server Errors (5xx).
    if (error.response.status >= 500 && error.response.status <= 599) {
      return true;
    }

    // Retry if rate limited.
    if (error.response.status === 429) {
      return true;
    }
    return false;
  }
}
exports.default = Analytics;

}).call(this)}).call(this,require("buffer").Buffer,require("timers").setImmediate)

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\segment\\analytics.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\segment\\index.js", {"../../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","./analytics":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\segment\\analytics.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Csegment%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.segment = exports.createSegmentMock = void 0;
var _time = require("../../../../shared/constants/time");
var _analytics = _interopRequireDefault(require("./analytics"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const SEGMENT_WRITE_KEY = "" ?? null;
const SEGMENT_HOST = null ?? null;

// flushAt controls how many events are sent to segment at once. Segment will
// hold onto a queue of events until it hits this number, then it sends them as
// a batch. This setting defaults to 20, but in development we likely want to
// see events in real time for debugging, so this is set to 1 to disable the
// queueing mechanism.
const SEGMENT_FLUSH_AT = "development" === 'production' ? undefined : 1;

// flushInterval controls how frequently the queue is flushed to segment.
// This happens regardless of the size of the queue. The default setting is
// 10,000ms (10 seconds). This default is rather high, though thankfully
// using the background process as our event handler means we don't have to
// deal with short lived sessions that happen faster than the interval
// e.g confirmations. This is set to 5,000ms (5 seconds) arbitrarily with the
// intent of having a value less than 10 seconds.
const SEGMENT_FLUSH_INTERVAL = _time.SECOND * 5;

/**
 * Creates a mock segment module for usage in test environments. This is used
 * when building the application in test mode to catch event calls and prevent
 * them from being sent to segment. It is also used in unit tests to mock and
 * spy on the methods to ensure proper behavior
 *
 * @param {number} flushAt - number of events to queue before sending to segment
 * @returns {SegmentInterface}
 */
const createSegmentMock = (flushAt = SEGMENT_FLUSH_AT) => {
  const segmentMock = {
    // Internal queue to keep track of events and properly mimic segment's
    // queueing behavior.
    queue: [],
    /**
     * Used to immediately send all queued events and reset the queue to zero.
     * For our purposes this simply triggers the callback method registered with
     * the event.
     */
    flush() {
      segmentMock.queue.forEach(([_, callback]) => {
        callback();
      });
      segmentMock.queue = [];
    },
    /**
     * Track an event and add it to the queue. If the queue size reaches the
     * flushAt threshold, flush the queue.
     *
     * @param payload
     * @param callback
     */
    track(payload, callback = () => undefined) {
      segmentMock.queue.push([payload, callback]);
      if (segmentMock.queue.length >= flushAt) {
        segmentMock.flush();
      }
    },
    /**
     * A true NOOP, these methods are either not used or do not await callback
     * and therefore require no functionality.
     */
    page() {
      // noop
    },
    identify() {
      // noop
    }
  };
  return segmentMock;
};
exports.createSegmentMock = createSegmentMock;
const segment = exports.segment = SEGMENT_WRITE_KEY ? new _analytics.default(SEGMENT_WRITE_KEY, {
  host: SEGMENT_HOST,
  flushAt: SEGMENT_FLUSH_AT,
  flushInterval: SEGMENT_FLUSH_INTERVAL
}) : createSegmentMock(SEGMENT_FLUSH_AT, SEGMENT_FLUSH_INTERVAL);

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\segment\\index.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\signature\\util.ts", {"../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Csignature%5Cutil.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addPersonalMessage = addPersonalMessage;
exports.addTypedMessage = addTypedMessage;
var _trace = require("../../../../shared/lib/trace");
async function handleSignature(signatureParams, signatureController, functionName) {
  const [, signatureRequest] = signatureParams;
  const {
    id
  } = signatureRequest;
  const actionId = id === null || id === void 0 ? void 0 : id.toString();
  (0, _trace.endTrace)({
    name: _trace.TraceName.Middleware,
    id: actionId
  });

  // eslint-disable-next-line @typescript-eslint/ban-ts-comment
  // @ts-ignore: Expected 4-5 arguments, but got 2.
  const hash = await signatureController[functionName](...signatureParams);
  (0, _trace.endTrace)({
    name: _trace.TraceName.Signature,
    id: actionId
  });
  return hash;
}
async function addTypedMessage({
  signatureParams,
  signatureController
}) {
  return handleSignature(signatureParams, signatureController, 'newUnsignedTypedMessage');
}
async function addPersonalMessage({
  signatureParams,
  signatureController
}) {
  return handleSignature(signatureParams, signatureController, 'newUnsignedPersonalMessage');
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\signature\\util.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\smart-transaction\\smart-transactions.ts", {"../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/smartTransactions":"D:\\code\\v\\metamask-extension\\shared\\constants\\smartTransactions.ts","../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../shared/modules/selectors":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\index.ts","../../../../shared/modules/transaction.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\transaction.utils.ts","@metamask/smart-transactions-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Csmart-transaction%5Csmart-transactions.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSmartTransactionCommonParams = getSmartTransactionCommonParams;
exports.submitSmartTransactionHook = exports.submitBatchSmartTransactionHook = void 0;
var _smartTransactionsController2 = require("@metamask/smart-transactions-controller");
var _transactionController2 = require("@metamask/transaction-controller");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _app = require("../../../../shared/constants/app");
var _smartTransactions = require("../../../../shared/constants/smartTransactions");
var _conversion = require("../../../../shared/modules/conversion.utils");
var _selectors = require("../../../../shared/modules/selectors");
var _transaction = require("../../../../shared/modules/transaction.utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
const namespace = 'SmartTransactions';
var _approvalFlowEnded = /*#__PURE__*/new WeakMap();
var _approvalFlowId = /*#__PURE__*/new WeakMap();
var _chainId = /*#__PURE__*/new WeakMap();
var _controllerMessenger = /*#__PURE__*/new WeakMap();
var _featureFlags = /*#__PURE__*/new WeakMap();
var _isDapp = /*#__PURE__*/new WeakMap();
var _isSmartTransaction = /*#__PURE__*/new WeakMap();
var _smartTransactionsController = /*#__PURE__*/new WeakMap();
var _transactionController = /*#__PURE__*/new WeakMap();
var _transactionMeta = /*#__PURE__*/new WeakMap();
var _signedTransactionInHex = /*#__PURE__*/new WeakMap();
var _transactions = /*#__PURE__*/new WeakMap();
var _txParams = /*#__PURE__*/new WeakMap();
var _shouldShowStatusPage = /*#__PURE__*/new WeakMap();
var _SmartTransactionHook_brand = /*#__PURE__*/new WeakSet();
class SmartTransactionHook {
  constructor(request) {
    _classPrivateMethodInitSpec(this, _SmartTransactionHook_brand);
    _classPrivateFieldInitSpec(this, _approvalFlowEnded, void 0);
    _classPrivateFieldInitSpec(this, _approvalFlowId, void 0);
    _classPrivateFieldInitSpec(this, _chainId, void 0);
    _classPrivateFieldInitSpec(this, _controllerMessenger, void 0);
    _classPrivateFieldInitSpec(this, _featureFlags, void 0);
    _classPrivateFieldInitSpec(this, _isDapp, void 0);
    _classPrivateFieldInitSpec(this, _isSmartTransaction, void 0);
    _classPrivateFieldInitSpec(this, _smartTransactionsController, void 0);
    _classPrivateFieldInitSpec(this, _transactionController, void 0);
    _classPrivateFieldInitSpec(this, _transactionMeta, void 0);
    _classPrivateFieldInitSpec(this, _signedTransactionInHex, void 0);
    _classPrivateFieldInitSpec(this, _transactions, void 0);
    _classPrivateFieldInitSpec(this, _txParams, void 0);
    _classPrivateFieldInitSpec(this, _shouldShowStatusPage, void 0);
    const {
      transactionMeta,
      signedTransactionInHex,
      smartTransactionsController,
      transactionController,
      isSmartTransaction,
      controllerMessenger,
      featureFlags,
      transactions
    } = request;
    _classPrivateFieldSet(_approvalFlowId, this, '');
    _classPrivateFieldSet(_approvalFlowEnded, this, false);
    _classPrivateFieldSet(_transactionMeta, this, transactionMeta);
    _classPrivateFieldSet(_signedTransactionInHex, this, signedTransactionInHex);
    _classPrivateFieldSet(_smartTransactionsController, this, smartTransactionsController);
    _classPrivateFieldSet(_transactionController, this, transactionController);
    _classPrivateFieldSet(_isSmartTransaction, this, isSmartTransaction);
    _classPrivateFieldSet(_controllerMessenger, this, controllerMessenger);
    _classPrivateFieldSet(_featureFlags, this, featureFlags);
    _classPrivateFieldSet(_isDapp, this, transactionMeta.origin !== _app.ORIGIN_METAMASK);
    _classPrivateFieldSet(_chainId, this, transactionMeta.chainId);
    _classPrivateFieldSet(_txParams, this, transactionMeta.txParams);
    _classPrivateFieldSet(_transactions, this, transactions);
    _classPrivateFieldSet(_shouldShowStatusPage, this, Boolean(transactionMeta.type !== _transactionController2.TransactionType.bridge || _classPrivateFieldGet(_transactions, this) && _classPrivateFieldGet(_transactions, this).length > 0));
  }
  async submit() {
    const isUnsupportedTransactionTypeForSmartTransaction = _classPrivateFieldGet(_transactionMeta, this).type ? [_transactionController2.TransactionType.swapAndSend, _transactionController2.TransactionType.swapApproval, _transactionController2.TransactionType.bridgeApproval].includes(_classPrivateFieldGet(_transactionMeta, this).type) : false;

    // Will cause TransactionController to publish to the RPC provider as normal.
    const useRegularTransactionSubmit = {
      transactionHash: undefined
    };
    if (!_classPrivateFieldGet(_isSmartTransaction, this) || isUnsupportedTransactionTypeForSmartTransaction || (0, _transaction.isLegacyTransaction)(_classPrivateFieldGet(_transactionMeta, this))) {
      return useRegularTransactionSubmit;
    }
    if (_classPrivateFieldGet(_shouldShowStatusPage, this)) {
      await _assertClassBrand(_SmartTransactionHook_brand, this, _startApprovalFlow).call(this);
    }
    let getFeesResponse;
    try {
      getFeesResponse = await _classPrivateFieldGet(_smartTransactionsController, this).getFees({
        ..._classPrivateFieldGet(_txParams, this),
        chainId: _classPrivateFieldGet(_chainId, this)
      }, undefined, {
        networkClientId: _classPrivateFieldGet(_transactionMeta, this).networkClientId
      });
    } catch (error) {
      _loglevel.default.error('Error in smart transaction publish hook, falling back to regular transaction submission', error);
      _assertClassBrand(_SmartTransactionHook_brand, this, _onApproveOrReject).call(this);
      return useRegularTransactionSubmit; // Fallback to regular transaction submission.
    }
    try {
      var _classPrivateFieldGet2;
      const submitTransactionResponse = await _assertClassBrand(_SmartTransactionHook_brand, this, _signAndSubmitTransactions).call(this, {
        getFeesResponse
      });
      const uuid = submitTransactionResponse === null || submitTransactionResponse === void 0 ? void 0 : submitTransactionResponse.uuid;
      if (!uuid) {
        throw new Error('No smart transaction UUID');
      }
      await _assertClassBrand(_SmartTransactionHook_brand, this, _processApprovalIfNeeded).call(this, uuid);
      const extensionReturnTxHashAsap = (_classPrivateFieldGet2 = _classPrivateFieldGet(_featureFlags, this)) === null || _classPrivateFieldGet2 === void 0 || (_classPrivateFieldGet2 = _classPrivateFieldGet2.smartTransactions) === null || _classPrivateFieldGet2 === void 0 ? void 0 : _classPrivateFieldGet2.extensionReturnTxHashAsap;
      let transactionHash;
      if (extensionReturnTxHashAsap && submitTransactionResponse !== null && submitTransactionResponse !== void 0 && submitTransactionResponse.txHash) {
        transactionHash = submitTransactionResponse.txHash;
      } else {
        transactionHash = await _assertClassBrand(_SmartTransactionHook_brand, this, _waitForTransactionHash).call(this, {
          uuid
        });
      }
      if (transactionHash === null) {
        throw new Error('Transaction does not have a transaction hash, there was a problem');
      }
      return {
        transactionHash
      };
    } catch (error) {
      _loglevel.default.error('Error in smart transaction publish hook', error);
      _assertClassBrand(_SmartTransactionHook_brand, this, _onApproveOrReject).call(this);
      throw error;
    }
  }
  async submitBatch() {
    // No fallback to regular transaction submission
    if (!_classPrivateFieldGet(_isSmartTransaction, this)) {
      throw new Error('submitBatch: Smart Transaction is required for batch submissions');
    }
    if (_classPrivateFieldGet(_shouldShowStatusPage, this)) {
      await _assertClassBrand(_SmartTransactionHook_brand, this, _startApprovalFlow).call(this);
    }
    try {
      const submitTransactionResponse = await _assertClassBrand(_SmartTransactionHook_brand, this, _signAndSubmitTransactions).call(this);
      const uuid = submitTransactionResponse === null || submitTransactionResponse === void 0 ? void 0 : submitTransactionResponse.uuid;
      if (!uuid) {
        throw new Error('submitBatch: No smart transaction UUID');
      }
      await _assertClassBrand(_SmartTransactionHook_brand, this, _processApprovalIfNeeded).call(this, uuid);
      const transactionHash = await _assertClassBrand(_SmartTransactionHook_brand, this, _waitForTransactionHash).call(this, {
        uuid
      });
      if (transactionHash === null) {
        throw new Error('submitBatch: Transaction does not have a transaction hash, there was a problem');
      }
      let submitBatchResponse;
      if (submitTransactionResponse !== null && submitTransactionResponse !== void 0 && submitTransactionResponse.txHashes) {
        submitBatchResponse = {
          results: submitTransactionResponse.txHashes.map(txHash => ({
            transactionHash: txHash
          }))
        };
      } else {
        submitBatchResponse = {
          results: []
        };
      }
      return submitBatchResponse;
    } catch (error) {
      _loglevel.default.error('submitBatch: Error in smart transaction publish batch hook', error);
      _assertClassBrand(_SmartTransactionHook_brand, this, _onApproveOrReject).call(this);
      throw error;
    }
  }
}
async function _endApprovalFlow(flowId) {
  try {
    await _classPrivateFieldGet(_controllerMessenger, this).call('ApprovalController:endFlow', {
      id: flowId
    });
  } catch (error) {
    // If the flow is already ended, we can ignore the error.
  }
}
async function _endExistingApprovalFlow(approvalFlowId) {
  try {
    // End the existing flow
    await _assertClassBrand(_SmartTransactionHook_brand, this, _endApprovalFlow).call(this, approvalFlowId);

    // Accept the request to close the UI
    await _classPrivateFieldGet(_controllerMessenger, this).call('ApprovalController:acceptRequest', approvalFlowId);
    _sharedApprovalFlowId._ = '';
  } catch (error) {
    _loglevel.default.error('Error ending existing approval flow', error);
  }
}
async function _startApprovalFlow() {
  if (_sharedApprovalFlowId._) {
    await _assertClassBrand(_SmartTransactionHook_brand, this, _endExistingApprovalFlow).call(this, _sharedApprovalFlowId._);
  }

  // Create a new approval flow
  const {
    id: approvalFlowId
  } = await _classPrivateFieldGet(_controllerMessenger, this).call('ApprovalController:startFlow');

  // Store the flow ID both in the instance and in the static property
  _classPrivateFieldSet(_approvalFlowId, this, approvalFlowId);
  _sharedApprovalFlowId._ = approvalFlowId;
}
async function _processApprovalIfNeeded(uuid) {
  if (_classPrivateFieldGet(_shouldShowStatusPage, this)) {
    _assertClassBrand(_SmartTransactionHook_brand, this, _addApprovalRequest).call(this, {
      uuid
    });
    _assertClassBrand(_SmartTransactionHook_brand, this, _addListenerToUpdateStatusPage).call(this, {
      uuid
    });
  }
}
function _onApproveOrReject() {
  if (!_classPrivateFieldGet(_shouldShowStatusPage, this) || _classPrivateFieldGet(_approvalFlowEnded, this)) {
    return;
  }
  _classPrivateFieldSet(_approvalFlowEnded, this, true);
  _assertClassBrand(_SmartTransactionHook_brand, this, _endApprovalFlow).call(this, _classPrivateFieldGet(_approvalFlowId, this));

  // Clear the shared approval flow ID when we end the flow
  if (_sharedApprovalFlowId._ === _classPrivateFieldGet(_approvalFlowId, this)) {
    _sharedApprovalFlowId._ = '';
  }
}
function _addApprovalRequest({
  uuid
}) {
  const onApproveOrRejectWrapper = () => {
    _assertClassBrand(_SmartTransactionHook_brand, this, _onApproveOrReject).call(this);
  };
  _classPrivateFieldGet(_controllerMessenger, this).call('ApprovalController:addRequest', {
    id: _classPrivateFieldGet(_approvalFlowId, this),
    origin,
    type: _app.SMART_TRANSACTION_CONFIRMATION_TYPES.showSmartTransactionStatusPage,
    requestState: {
      smartTransaction: {
        status: _smartTransactionsController2.SmartTransactionStatuses.PENDING,
        creationTime: Date.now(),
        uuid
      },
      isDapp: _classPrivateFieldGet(_isDapp, this),
      txId: _classPrivateFieldGet(_transactionMeta, this).id
    }
  }, true).then(onApproveOrRejectWrapper, onApproveOrRejectWrapper);
}
async function _updateApprovalRequest({
  smartTransaction
}) {
  return await _classPrivateFieldGet(_controllerMessenger, this).call('ApprovalController:updateRequestState', {
    id: _classPrivateFieldGet(_approvalFlowId, this),
    requestState: {
      smartTransaction,
      isDapp: _classPrivateFieldGet(_isDapp, this),
      txId: _classPrivateFieldGet(_transactionMeta, this).id
    }
  });
}
async function _addListenerToUpdateStatusPage({
  uuid
}) {
  _classPrivateFieldGet(_controllerMessenger, this).subscribe('SmartTransactionsController:smartTransaction',
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  async smartTransaction => {
    if (smartTransaction.uuid === uuid) {
      const {
        status
      } = smartTransaction;
      if (!status || status === _smartTransactionsController2.SmartTransactionStatuses.PENDING) {
        return;
      }
      if (!_classPrivateFieldGet(_approvalFlowEnded, this)) {
        await _assertClassBrand(_SmartTransactionHook_brand, this, _updateApprovalRequest).call(this, {
          smartTransaction
        });
      }
    }
  });
}
function _waitForTransactionHash({
  uuid
}) {
  return new Promise(resolve => {
    _classPrivateFieldGet(_controllerMessenger, this).subscribe('SmartTransactionsController:smartTransaction',
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    async smartTransaction => {
      if (smartTransaction.uuid === uuid) {
        const {
          status,
          statusMetadata
        } = smartTransaction;
        if (!status || status === _smartTransactionsController2.SmartTransactionStatuses.PENDING) {
          return;
        }
        _loglevel.default.debug('Smart Transaction: ', smartTransaction);
        if (statusMetadata !== null && statusMetadata !== void 0 && statusMetadata.minedHash) {
          _loglevel.default.debug('Smart Transaction - Received tx hash: ', statusMetadata === null || statusMetadata === void 0 ? void 0 : statusMetadata.minedHash);
          resolve(statusMetadata.minedHash);
        } else {
          resolve(null);
        }
      }
    });
  });
}
async function _signAndSubmitTransactions({
  getFeesResponse
} = {}) {
  let signedTransactions = [];
  if (_classPrivateFieldGet(_transactions, this) && Array.isArray(_classPrivateFieldGet(_transactions, this)) && _classPrivateFieldGet(_transactions, this).length > 0) {
    // Batch transaction mode - extract signed transactions from this.#transactions[].signedTx
    signedTransactions = _classPrivateFieldGet(_transactions, this).filter(tx => tx === null || tx === void 0 ? void 0 : tx.signedTx).map(tx => tx.signedTx);
  } else if (_classPrivateFieldGet(_signedTransactionInHex, this)) {
    // Single transaction mode with pre-signed transaction
    signedTransactions = [_classPrivateFieldGet(_signedTransactionInHex, this)];
  } else if (getFeesResponse) {
    var _getFeesResponse$trad;
    // Single transaction mode requiring signing
    signedTransactions = await _assertClassBrand(_SmartTransactionHook_brand, this, _createSignedTransactions).call(this, ((_getFeesResponse$trad = getFeesResponse.tradeTxFees) === null || _getFeesResponse$trad === void 0 ? void 0 : _getFeesResponse$trad.fees) ?? [], false);
  }
  return await _classPrivateFieldGet(_smartTransactionsController, this).submitSignedTransactions({
    signedTransactions,
    signedCanceledTransactions: [],
    txParams: _classPrivateFieldGet(_txParams, this),
    transactionMeta: _classPrivateFieldGet(_transactionMeta, this),
    networkClientId: _classPrivateFieldGet(_transactionMeta, this).networkClientId
  });
}
function _applyFeeToTransaction(fee, isCancel) {
  if (!_classPrivateFieldGet(_txParams, this)) {
    throw new Error('Transaction params are required');
  }
  const unsignedTransaction = {
    ..._classPrivateFieldGet(_txParams, this),
    maxFeePerGas: `0x${(0, _conversion.decimalToHex)(fee.maxFeePerGas)}`,
    maxPriorityFeePerGas: `0x${(0, _conversion.decimalToHex)(fee.maxPriorityFeePerGas)}`,
    gas: isCancel ? `0x${(0, _conversion.decimalToHex)(_smartTransactions.CANCEL_GAS_LIMIT_DEC)}` // It has to be 21000 for cancel transactions, otherwise the API would reject it.
    : _classPrivateFieldGet(_txParams, this).gas
  };
  if (isCancel) {
    unsignedTransaction.to = unsignedTransaction.from;
    unsignedTransaction.data = '0x';
  }
  return unsignedTransaction;
}
async function _createSignedTransactions(fees, isCancel) {
  if (!_classPrivateFieldGet(_txParams, this) || !_classPrivateFieldGet(_chainId, this)) {
    throw new Error('Transaction params and chainId are required');
  }
  const unsignedTransactions = fees.map(fee => {
    return _assertClassBrand(_SmartTransactionHook_brand, this, _applyFeeToTransaction).call(this, fee, isCancel);
  });
  const transactionsWithChainId = unsignedTransactions.map(tx => ({
    ...tx,
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
    chainId: tx.chainId || _classPrivateFieldGet(_chainId, this)
  }));
  return await _classPrivateFieldGet(_transactionController, this).approveTransactionsWithSameNonce(transactionsWithChainId, {
    hasNonce: true
  });
}
// Static property to store the approval flow ID across instances
var _sharedApprovalFlowId = {
  _: ''
};
const submitSmartTransactionHook = request => {
  const smartTransactionHook = new SmartTransactionHook(request);
  return smartTransactionHook.submit();
};
exports.submitSmartTransactionHook = submitSmartTransactionHook;
const submitBatchSmartTransactionHook = request => {
  const smartTransactionHook = new SmartTransactionHook(request);
  return smartTransactionHook.submitBatch();
};
exports.submitBatchSmartTransactionHook = submitBatchSmartTransactionHook;
function getUIState(flatState) {
  return {
    metamask: flatState
  };
}
function getSmartTransactionCommonParams(flatState, chainId) {
  // UI state is required to support shared selectors to avoid duplicate logic in frontend and backend.
  // Ideally all backend logic would instead rely on messenger event / state subscriptions.
  const uiState = getUIState(flatState);

  // @ts-expect-error Smart transaction selector types does not match controller state
  const isSmartTransaction = (0, _selectors.getIsSmartTransaction)(uiState, chainId);

  // @ts-expect-error Smart transaction selector types does not match controller state
  const featureFlags = (0, _selectors.getFeatureFlagsByChainId)(uiState, chainId);
  const isHardwareWalletAccount = (0, _selectors.isHardwareWallet)(uiState);
  return {
    isSmartTransaction,
    featureFlags,
    isHardwareWalletAccount
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\smart-transaction\\smart-transactions.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\snap-keyring\\index.ts", {"./snap-keyring":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\snap-keyring\\snap-keyring.ts","./utils":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\snap-keyring\\utils.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Csnap-keyring%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "getAccountsBySnapId", {
  enumerable: true,
  get: function () {
    return _utils.getAccountsBySnapId;
  }
});
Object.defineProperty(exports, "snapKeyringBuilder", {
  enumerable: true,
  get: function () {
    return _snapKeyring.snapKeyringBuilder;
  }
});
var _snapKeyring = require("./snap-keyring");
var _utils = require("./utils");

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\snap-keyring\\index.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\snap-keyring\\keyring-snaps-permissions.ts", {"@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Csnap-keyring%5Ckeyring-snaps-permissions.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isProtocolAllowed = isProtocolAllowed;
exports.keyringSnapPermissionsBuilder = keyringSnapPermissionsBuilder;
var _keyringApi = require("@metamask/keyring-api");
var _permissionController = require("@metamask/permission-controller");
/**
 * The origins of the Portfolio dapp.
 */
const PORTFOLIO_ORIGINS = ['https://app.metamask.io'];

/**
 * List of keyring methods MetaMask can call.
 */
const METAMASK_ALLOWED_METHODS = [_keyringApi.KeyringRpcMethod.ListAccounts, _keyringApi.KeyringRpcMethod.GetAccount, _keyringApi.KeyringRpcMethod.FilterAccountChains, _keyringApi.KeyringRpcMethod.DeleteAccount, _keyringApi.KeyringRpcMethod.ListRequests, _keyringApi.KeyringRpcMethod.GetRequest, _keyringApi.KeyringRpcMethod.SubmitRequest, _keyringApi.KeyringRpcMethod.RejectRequest];

/**
 * List of keyring methods a dapp can call.
 * !NOTE: DO NOT INCLUDE `KeyringRpcMethod.SubmitRequest` IN THIS LIST.
 */
const WEBSITE_ALLOWED_METHODS = [_keyringApi.KeyringRpcMethod.ListAccounts, _keyringApi.KeyringRpcMethod.GetAccount, _keyringApi.KeyringRpcMethod.CreateAccount, _keyringApi.KeyringRpcMethod.FilterAccountChains, _keyringApi.KeyringRpcMethod.UpdateAccount, _keyringApi.KeyringRpcMethod.DeleteAccount, _keyringApi.KeyringRpcMethod.ExportAccount, _keyringApi.KeyringRpcMethod.ListRequests, _keyringApi.KeyringRpcMethod.GetRequest, _keyringApi.KeyringRpcMethod.ApproveRequest, _keyringApi.KeyringRpcMethod.RejectRequest];

/**
 * List of keyring methods that Portfolio can call.
 */
const PORTFOLIO_ALLOWED_METHODS = [_keyringApi.KeyringRpcMethod.ListAccounts, _keyringApi.KeyringRpcMethod.GetAccount, _keyringApi.KeyringRpcMethod.GetAccountBalances, _keyringApi.KeyringRpcMethod.SubmitRequest];

/**
 * List of allowed protocols. On Flask, HTTP is also allowed for testing.
 */
const ALLOWED_PROTOCOLS = ['https:'];

/**
 * Checks if the protocol of the origin is allowed.
 *
 * @param origin - The origin to check.
 * @returns `true` if the protocol of the origin is allowed, `false` otherwise.
 */
function isProtocolAllowed(origin) {
  try {
    const url = new URL(origin);
    return ALLOWED_PROTOCOLS.includes(url.protocol);
  } catch (error) {
    return false;
  }
}

/**
 * Builds a function that returns the list of keyring methods an origin can
 * call.
 *
 * @param controller - Reference to the `SubjectMetadataController`.
 * @param origin - The origin itself.
 * @returns A function that returns the list of keyring methods an origin can
 * call.
 */
function keyringSnapPermissionsBuilder(controller, origin) {
  return () => {
    if (origin === 'metamask') {
      return METAMASK_ALLOWED_METHODS;
    }
    if (PORTFOLIO_ORIGINS.includes(origin)) {
      return PORTFOLIO_ALLOWED_METHODS;
    }
    const originMetadata = controller.getSubjectMetadata(origin);
    if ((originMetadata === null || originMetadata === void 0 ? void 0 : originMetadata.subjectType) === _permissionController.SubjectType.Website) {
      return isProtocolAllowed(origin) ? WEBSITE_ALLOWED_METHODS : [];
    }
    return [];
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\snap-keyring\\keyring-snaps-permissions.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\snap-keyring\\metrics.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Csnap-keyring%5Cmetrics.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSnapAndHardwareInfoForMetrics = getSnapAndHardwareInfoForMetrics;
async function getSnapAndHardwareInfoForMetrics(getAccountType, getDeviceModel, getHardwareTypeForMetric, messenger) {
  var _account$metadata$sna, _snap, _snap2;
  // If it's coming from a unit test, there's no messenger
  // Will fix this in a future PR and add proper unit tests
  if (!messenger) {
    return {};
  }
  const account = messenger.call('AccountsController:getSelectedAccount');
  const selectedAddress = account.address;
  let snap;
  if ((_account$metadata$sna = account.metadata.snap) !== null && _account$metadata$sna !== void 0 && _account$metadata$sna.id) {
    var _account$metadata$sna2;
    snap = messenger.call('SnapController:get', (_account$metadata$sna2 = account.metadata.snap) === null || _account$metadata$sna2 === void 0 ? void 0 : _account$metadata$sna2.id);
  }
  let keyringAccountInfo = {};
  const {
    isUnlocked
  } = messenger.call('KeyringController:getState');
  if (isUnlocked) {
    keyringAccountInfo = {
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      account_type: await getAccountType(selectedAddress),
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      device_model: await getDeviceModel(selectedAddress),
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      account_hardware_type: await getHardwareTypeForMetric(selectedAddress)
    };
  }
  return {
    ...keyringAccountInfo,
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    account_snap_type: (_snap = snap) === null || _snap === void 0 ? void 0 : _snap.id,
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    account_snap_version: (_snap2 = snap) === null || _snap2 === void 0 ? void 0 : _snap2.version
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\snap-keyring\\metrics.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\snap-keyring\\snap-keyring.ts", {"../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/lib/accounts":"D:\\code\\v\\metamask-extension\\shared\\lib\\accounts\\index.ts","../../../../shared/lib/accounts/snaps":"D:\\code\\v\\metamask-extension\\shared\\lib\\accounts\\snaps.ts","../../../../shared/lib/snaps/snaps":"D:\\code\\v\\metamask-extension\\shared\\lib\\snaps\\snaps.ts","../../../../shared/lib/translate":"D:\\code\\v\\metamask-extension\\shared\\lib\\translate.ts","../../../../ui/components/component-library/icon":"D:\\code\\v\\metamask-extension\\ui\\components\\component-library\\icon\\index.ts","./utils/isBlockedUrl":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\snap-keyring\\utils\\isBlockedUrl.ts","./utils/showResult":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\snap-keyring\\utils\\showResult.ts","@metamask/eth-snap-keyring":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","webextension-polyfill":"D:\\code\\v\\metamask-extension\\node_modules\\webextension-polyfill\\dist\\browser-polyfill.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Csnap-keyring%5Csnap-keyring.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showAccountCreationDialog = showAccountCreationDialog;
exports.showAccountNameSuggestionDialog = showAccountNameSuggestionDialog;
exports.snapKeyringBuilder = snapKeyringBuilder;
var _ethSnapKeyring = require("@metamask/eth-snap-keyring");
var _webextensionPolyfill = _interopRequireDefault(require("webextension-polyfill"));
var _snapsUtils = require("@metamask/snaps-utils");
var _metametrics = require("../../../../shared/constants/metametrics");
var _app = require("../../../../shared/constants/app");
var _translate = require("../../../../shared/lib/translate");
var _icon = require("../../../../ui/components/component-library/icon");
var _accounts = require("../../../../shared/lib/accounts");
var _snaps = require("../../../../shared/lib/snaps/snaps");
var _snaps2 = require("../../../../shared/lib/accounts/snaps");
var _isBlockedUrl = require("./utils/isBlockedUrl");
var _showResult = require("./utils/showResult");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } // TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths
/**
 * Builder type for the Snap keyring.
 */

/**
 * Helpers for the Snap keyring implementation.
 */

/**
 * Show the account creation dialog for a given Snap.
 * This function will start the approval flow, show the account creation dialog, and end the flow.
 *
 * @param snapId - Snap ID to show the account creation dialog for.
 * @param messenger - The controller messenger instance.
 * @returns The user's confirmation result.
 */
async function showAccountCreationDialog(snapId, messenger) {
  try {
    const confirmationResult = Boolean(await messenger.call('ApprovalController:addRequest', {
      origin: snapId,
      type: _app.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.confirmAccountCreation
    }, true));
    return confirmationResult;
  } catch (e) {
    throw new Error(
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    `Error occurred while showing account creation dialog.\n${e}`);
  }
}

/**
 * Show the account name suggestion confirmation dialog for a given Snap.
 *
 * @param snapId - Snap ID to show the account name suggestion dialog for.
 * @param messenger - The controller messenger instance.
 * @param accountNameSuggestion - Suggested name for the new account.
 * @returns The user's confirmation result.
 */
async function showAccountNameSuggestionDialog(snapId, messenger, accountNameSuggestion) {
  try {
    const confirmationResult = await messenger.call('ApprovalController:addRequest', {
      origin: snapId,
      type: _app.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.showNameSnapAccount,
      requestData: {
        snapSuggestedAccountName: accountNameSuggestion
      }
    }, true);
    return confirmationResult;
  } catch (e) {
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    throw new Error(`Error occurred while showing name account dialog.\n${e}`);
  }
}
var _messenger = /*#__PURE__*/new WeakMap();
var _trackEvent = /*#__PURE__*/new WeakMap();
var _persistKeyringHelper = /*#__PURE__*/new WeakMap();
var _removeAccountHelper = /*#__PURE__*/new WeakMap();
var _SnapKeyringImpl_brand = /*#__PURE__*/new WeakSet();
class SnapKeyringImpl {
  constructor(messenger, {
    trackEvent,
    persistKeyringHelper,
    removeAccountHelper
  }) {
    _classPrivateMethodInitSpec(this, _SnapKeyringImpl_brand);
    _classPrivateFieldInitSpec(this, _messenger, void 0);
    _classPrivateFieldInitSpec(this, _trackEvent, void 0);
    _classPrivateFieldInitSpec(this, _persistKeyringHelper, void 0);
    _classPrivateFieldInitSpec(this, _removeAccountHelper, void 0);
    _classPrivateFieldSet(_messenger, this, messenger);
    _classPrivateFieldSet(_trackEvent, this, trackEvent);
    _classPrivateFieldSet(_persistKeyringHelper, this, persistKeyringHelper);
    _classPrivateFieldSet(_removeAccountHelper, this, removeAccountHelper);
  }
  async addressExists(address) {
    const addresses = await _classPrivateFieldGet(_messenger, this).call('KeyringController:getAccounts');
    return addresses.includes(address.toLowerCase());
  }
  async redirectUser(snapId, url, message) {
    // Either url or message must be defined
    if (url.length > 0 || message.length > 0) {
      const isBlocked = await (0, _isBlockedUrl.isBlockedUrl)(url, async () => {
        return await _classPrivateFieldGet(_messenger, this).call('PhishingController:maybeUpdateState');
      }, urlToTest => {
        return _classPrivateFieldGet(_messenger, this).call('PhishingController:testOrigin', urlToTest);
      });
      const confirmationResult = await _classPrivateFieldGet(_messenger, this).call('ApprovalController:addRequest', {
        origin: snapId,
        requestData: {
          url,
          message,
          isBlockedUrl: isBlocked
        },
        type: _app.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.showSnapAccountRedirect
      }, true);
      if (Boolean(confirmationResult) && url.length > 0) {
        _webextensionPolyfill.default.tabs.create({
          url
        });
      } else {
        console.log('User refused snap account redirection to:', url);
      }
    } else {
      console.log('Error occurred when redirecting snap account. url or message must be defined');
    }
  }
  async saveState() {
    await _classPrivateFieldGet(_persistKeyringHelper, this).call(this);
  }
  async addAccount(address, snapId, handleUserInput, onceSaved, accountNameSuggestion = '', {
    displayConfirmation,
    displayAccountNameSuggestion,
    setSelectedAccount
  } = (0, _ethSnapKeyring.getDefaultInternalOptions)()) {
    (0, _snapsUtils.assertIsValidSnapId)(snapId);

    // If Snap is preinstalled and does not request confirmation, skip the confirmation dialog.
    const skipConfirmationDialog = (0, _snaps.isSnapPreinstalled)(snapId) && !displayConfirmation;

    // Only pre-installed Snaps can skip the account name suggestion dialog.
    const skipAccountNameSuggestionDialog = (0, _snaps.isSnapPreinstalled)(snapId) && !displayAccountNameSuggestion;

    // Only pre-installed Snaps can skip the account from being selected.
    const skipSetSelectedAccountStep = (0, _snaps.isSnapPreinstalled)(snapId) && !setSelectedAccount;
    const skipApprovalFlow = skipConfirmationDialog && skipAccountNameSuggestionDialog;

    // First part of the flow, which includes confirmation dialogs (if not skipped).
    // Once confirmed, we resume the Snap execution.
    const {
      accountName
    } = await _assertClassBrand(_SnapKeyringImpl_brand, this, _addAccountConfirmations).call(this, {
      snapId,
      skipConfirmationDialog,
      skipAccountNameSuggestionDialog,
      skipApprovalFlow,
      accountNameSuggestion,
      handleUserInput
    });

    // The second part is about selecting the newly created account and showing some other
    // confirmation dialogs (or error dialogs if anything goes wrong while persisting the account
    // into the state.
    // eslint-disable-next-line no-void
    void _assertClassBrand(_SnapKeyringImpl_brand, this, _addAccountFinalize).call(this, {
      address,
      snapId,
      skipConfirmationDialog,
      skipSetSelectedAccountStep,
      skipApprovalFlow,
      accountName,
      onceSaved,
      defaultAccountNameChosen: Boolean(accountNameSuggestion) && accountName === accountNameSuggestion
    });
  }
  async removeAccount(address, snapId, handleUserInput) {
    (0, _snapsUtils.assertIsValidSnapId)(snapId);
    const snapName = (0, _snaps2.getSnapName)(snapId, _classPrivateFieldGet(_messenger, this));
    const {
      id: removeAccountApprovalId
    } = _classPrivateFieldGet(_messenger, this).call('ApprovalController:startFlow');
    const learnMoreLink = 'https://support.metamask.io/managing-my-wallet/accounts-and-addresses/how-to-remove-an-account-from-your-metamask-wallet/';
    const trackSnapAccountEvent = event => {
      _classPrivateFieldGet(_trackEvent, this).call(this, {
        event,
        category: _metametrics.MetaMetricsEventCategory.Accounts,
        properties: {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          account_type: _metametrics.MetaMetricsEventAccountType.Snap,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          snap_id: snapId,
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          snap_name: snapName
        }
      });
    };

    // Since we use this in the finally, better to give it a default value if the controller call fails
    let confirmationResult = false;
    try {
      confirmationResult = Boolean(await _classPrivateFieldGet(_messenger, this).call('ApprovalController:addRequest', {
        origin: snapId,
        type: _app.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.confirmAccountRemoval,
        requestData: {
          publicAddress: address
        }
      }, true));
      if (confirmationResult) {
        try {
          await _classPrivateFieldGet(_removeAccountHelper, this).call(this, address);
          await handleUserInput(confirmationResult);
          await _classPrivateFieldGet(_persistKeyringHelper, this).call(this);

          // TODO: Add events tracking to the dialog itself, so that events are more
          // "linked" to UI actions
          // User should now see the "Successfuly removed account" page
          trackSnapAccountEvent(_metametrics.MetaMetricsEventName.RemoveSnapAccountSuccessViewed);
          // This isn't actually an error, but we show it as one for styling reasons
          await (0, _showResult.showError)(_classPrivateFieldGet(_messenger, this), snapId, {
            icon: _icon.IconName.UserCircleRemove,
            title: (0, _translate.t)('snapAccountRemoved')
          }, {
            message: (0, _translate.t)('snapAccountRemovedDescription'),
            learnMoreLink
          });

          // User has clicked on "OK"
          trackSnapAccountEvent(_metametrics.MetaMetricsEventName.RemoveSnapAccountSuccessClicked);
        } catch (e) {
          const error = e.message;
          await (0, _showResult.showError)(_classPrivateFieldGet(_messenger, this), snapId, {
            icon: _icon.IconName.UserCircleRemove,
            title: (0, _translate.t)('snapAccountRemovalFailed')
          }, {
            message: (0, _translate.t)('snapAccountRemovalFailedDescription', snapName),
            learnMoreLink,
            error
          });
          trackSnapAccountEvent(_metametrics.MetaMetricsEventName.AccountRemoveFailed);
          throw new Error(`Error occurred while removing snap account: ${error}`);
        }
      } else {
        await handleUserInput(confirmationResult);
        throw new Error('User denied account removal');
      }
    } finally {
      // We do not have a `else` clause here, as it's used if the request was
      // canceled by the user, thus it's not a "fail" (not an error).
      if (confirmationResult) {
        trackSnapAccountEvent(_metametrics.MetaMetricsEventName.AccountRemoved);
      }
      _classPrivateFieldGet(_messenger, this).call('ApprovalController:endFlow', {
        id: removeAccountApprovalId
      });
    }
  }
}

/**
 * Constructs a SnapKeyring builder with specified handlers for managing Snap accounts.
 *
 * @param messenger - The messenger instace.
 * @param helpers - Helpers required by the Snap keyring implementation.
 * @returns A Snap keyring builder.
 */
async function _withApprovalFlow(run) {
  const {
    id: flowId
  } = _classPrivateFieldGet(_messenger, this).call('ApprovalController:startFlow');
  try {
    return await run(flowId);
  } finally {
    _classPrivateFieldGet(_messenger, this).call('ApprovalController:endFlow', {
      id: flowId
    });
  }
}
/**
 * Get the account name from the user through a dialog.
 *
 * @param snapId - ID of the Snap that created the account.
 * @param accountNameSuggestion - Suggested name for the account.
 * @returns The name that should be used for the account.
 */
async function _getAccountNameFromDialog(snapId, accountNameSuggestion) {
  const {
    success,
    name: accountName
  } = await showAccountNameSuggestionDialog(snapId, _classPrivateFieldGet(_messenger, this), accountNameSuggestion);
  return {
    success,
    accountName
  };
}
/**
 * Use the account name suggestion to decide the name of the account.
 *
 * @param accountNameSuggestion - Suggested name for the account.
 * @returns The name that should be used for the account.
 */
async function _getAccountNameFromSuggestion(accountNameSuggestion) {
  const accounts = await _classPrivateFieldGet(_messenger, this).call('AccountsController:listMultichainAccounts');
  const accountName = (0, _accounts.getUniqueAccountName)(accounts, accountNameSuggestion);
  return {
    success: true,
    accountName
  };
}
async function _addAccountConfirmations({
  snapId,
  skipConfirmationDialog,
  skipAccountNameSuggestionDialog,
  skipApprovalFlow,
  handleUserInput,
  accountNameSuggestion
}) {
  // If both confirmation and name suggestion dialogs are skipped (preinstalled snap
  // without confirmations), don't enter the approval flow at all to avoid
  // unnecessary loader/flow UI. Just compute the name and signal acceptance.
  if (skipApprovalFlow) {
    const {
      success,
      accountName
    } = await _assertClassBrand(_SnapKeyringImpl_brand, this, _getAccountNameFromSuggestion).call(this, accountNameSuggestion);
    await handleUserInput(success);
    if (!success) {
      throw new Error('User denied account creation');
    }
    return {
      accountName
    };
  }
  return await _assertClassBrand(_SnapKeyringImpl_brand, this, _withApprovalFlow).call(this, async _ => {
    // 1. Show the account CREATION confirmation dialog.
    {
      // If confirmation dialog are skipped, we consider the account creation to be confirmed until the account name dialog is closed
      const success = skipConfirmationDialog || (await showAccountCreationDialog(snapId, _classPrivateFieldGet(_messenger, this)));
      if (!success) {
        // User has cancelled account creation
        await handleUserInput(success);
        throw new Error('User denied account creation');
      }
    }

    // 2. Show the account RENAMING confirmation dialog. Note that
    //    pre-installed Snaps can skip this dialog.
    {
      const {
        success,
        accountName
      } = skipAccountNameSuggestionDialog ? await _assertClassBrand(_SnapKeyringImpl_brand, this, _getAccountNameFromSuggestion).call(this, accountNameSuggestion) : await _assertClassBrand(_SnapKeyringImpl_brand, this, _getAccountNameFromDialog).call(this, snapId, accountNameSuggestion);
      await handleUserInput(success);
      if (!success) {
        throw new Error('User denied account creation');
      }
      return {
        accountName
      };
    }
  });
}
async function _addAccountFinalize({
  address,
  snapId,
  skipConfirmationDialog,
  skipSetSelectedAccountStep,
  skipApprovalFlow,
  accountName,
  onceSaved,
  defaultAccountNameChosen
}) {
  const learnMoreLink = 'https://support.metamask.io/managing-my-wallet/accounts-and-addresses/how-to-add-accounts-in-your-wallet/';
  const snapName = (0, _snaps2.getSnapName)(snapId, _classPrivateFieldGet(_messenger, this));
  const trackSnapAccountEvent = event => {
    _classPrivateFieldGet(_trackEvent, this).call(this, {
      event,
      category: _metametrics.MetaMetricsEventCategory.Accounts,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        account_type: _metametrics.MetaMetricsEventAccountType.Snap,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        snap_id: snapId,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        snap_name: snapName,
        ...(event === _metametrics.MetaMetricsEventName.AccountAdded && {
          // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
          // eslint-disable-next-line @typescript-eslint/naming-convention
          is_suggested_name: defaultAccountNameChosen
        })
      }
    });
  };
  const finalizeFn = async () => {
    try {
      // First, wait for the account to be fully saved.
      // NOTE: This might throw, so keep this in the `try` clause.
      const accountId = await onceSaved;

      // From here, we know the account has been saved into the Snap keyring
      // state, so we can safely uses this state to run post-processing.
      // (e.g. renaming the account, select the account, etc...)

      if (!skipSetSelectedAccountStep) {
        // Set the selected account to the new account
        _classPrivateFieldGet(_messenger, this).call('AccountsController:setSelectedAccount', accountId);
      }
      if (accountName) {
        _classPrivateFieldGet(_messenger, this).call('AccountsController:setAccountName', accountId, accountName);
      }
      if (!skipConfirmationDialog) {
        // TODO: Add events tracking to the dialog itself, so that events are more
        // "linked" to UI actions
        // User should now see the "Successfuly added account" page
        trackSnapAccountEvent(_metametrics.MetaMetricsEventName.AddSnapAccountSuccessViewed);
        await (0, _showResult.showSuccess)(_classPrivateFieldGet(_messenger, this), snapId, {
          icon: _icon.IconName.UserCircleAdd,
          title: (0, _translate.t)('snapAccountCreated')
        }, {
          message: (0, _translate.t)('snapAccountCreatedDescription'),
          address,
          learnMoreLink
        });
        // User has clicked on "OK"
        trackSnapAccountEvent(_metametrics.MetaMetricsEventName.AddSnapAccountSuccessClicked);
      }
      trackSnapAccountEvent(_metametrics.MetaMetricsEventName.AccountAdded);
    } catch (e) {
      // Error occurred while naming the account
      const error = e.message;
      await (0, _showResult.showError)(_classPrivateFieldGet(_messenger, this), snapId, {
        icon: _icon.IconName.UserCircleAdd,
        title: (0, _translate.t)('snapAccountCreationFailed')
      }, {
        message: (0, _translate.t)('snapAccountCreationFailedDescription', snapName),
        learnMoreLink,
        error
      });

      // This part of the flow is not awaited, so we just log the error for now:
      console.error('Error occurred while creating snap account:', error);
    }
  };

  // If confirmation was skipped, do not start an approval flow to avoid loader UI.
  if (skipApprovalFlow) {
    await finalizeFn();
    return;
  }
  await _assertClassBrand(_SnapKeyringImpl_brand, this, _withApprovalFlow).call(this, finalizeFn);
}
function snapKeyringBuilder(messenger, helpers) {
  const SnapKeyringBuilder = () => {
    return new _ethSnapKeyring.SnapKeyring({
      messenger,
      callbacks: new SnapKeyringImpl(messenger, helpers)
    });
  };
  SnapKeyringBuilder.state = null;
  SnapKeyringBuilder.type = _ethSnapKeyring.SnapKeyring.type;
  return SnapKeyringBuilder;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\snap-keyring\\snap-keyring.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\snap-keyring\\utils.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Csnap-keyring%5Cutils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAccountsBySnapId = void 0;
/**
 * Get the addresses of the accounts managed by a given Snap.
 *
 * @param getSnapKeyring
 * @param snapId - Snap ID to get accounts for.
 * @returns The addresses of the accounts.
 */
const getAccountsBySnapId = async (getSnapKeyring, snapId) => {
  const snapKeyring = await getSnapKeyring();
  return await snapKeyring.getAccountsBySnapId(snapId);
};
exports.getAccountsBySnapId = getAccountsBySnapId;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\snap-keyring\\utils.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\snap-keyring\\utils\\isBlockedUrl.ts", {"../keyring-snaps-permissions":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\snap-keyring\\keyring-snaps-permissions.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Csnap-keyring%5Cutils%5CisBlockedUrl.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isBlockedUrl = void 0;
var _keyringSnapsPermissions = require("../keyring-snaps-permissions");
/**
 * Checks whether a given URL is blocked due to not using HTTPS or being
 * recognized as a phishing URL.
 *
 * @param url - The URL to check.
 * @param maybeUpdateState - A function that updates the phishing controller state.
 * @param testOrigin - A function that tests if a URL is a phishing URL.
 * @returns Returns a promise which resolves to `true` if the URL is blocked
 * either due to using an insecure protocol (not HTTPS) or being recognized as
 * a phishing URL. Otherwise, resolves to `false`.
 */
const isBlockedUrl = async (url, maybeUpdateState, testOrigin) => {
  try {
    // check if the URL is HTTPS
    if (!(0, _keyringSnapsPermissions.isProtocolAllowed)(url)) {
      return true;
    }

    // check if the url is in the phishing list
    await maybeUpdateState();
    return testOrigin(url).result;
  } catch (error) {
    console.error('Invalid URL passed into snap-keyring:', error);
    return false;
  }
};
exports.isBlockedUrl = isBlockedUrl;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\snap-keyring\\utils\\isBlockedUrl.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\snap-keyring\\utils\\showResult.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Csnap-keyring%5Cutils%5CshowResult.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showSuccess = exports.showError = void 0;
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

const snapAuthorshipHeader = snapId => {
  return {
    name: 'SnapAuthorshipHeader',
    key: 'snapHeader',
    properties: {
      snapId
    }
  };
};

/**
 * Options for result pages.
 */

/**
 * Shows an error result page.
 *
 * @param controllerMessenger - The controller messenger instance.
 * @param snapId - The Snap unique id.
 * @param opts - The result component options (title, icon).
 * @param properties - The properties used by SnapAccountErrorMessage component.
 * @returns Returns a promise that resolves once the user clicks the confirm
 * button.
 */
const showError = (controllerMessenger, snapId, opts, properties) => {
  return controllerMessenger.call('ApprovalController:showError', {
    header: [snapAuthorshipHeader(snapId)],
    title: opts.title,
    icon: opts.icon,
    error: {
      key: 'snapAccountErrorMessage',
      name: 'SnapAccountErrorMessage',
      properties
    }
  });
};

/**
 * Shows a success result page.
 *
 * @param controllerMessenger - The controller messenger instance.
 * @param snapId - The Snap unique id.
 * @param opts - The result component options (title, icon).
 * @param properties - The properties used by SnapAccountSuccessMessage component.
 * @returns Returns a promise that resolves once the user clicks the confirm
 * button.
 */
exports.showError = showError;
const showSuccess = (controllerMessenger, snapId, opts, properties) => {
  return controllerMessenger.call('ApprovalController:showSuccess', {
    header: [snapAuthorshipHeader(snapId)],
    title: opts.title,
    icon: opts.icon,
    message: {
      key: 'snapAccountSuccessMessage',
      name: 'SnapAccountSuccessMessage',
      properties
    }
  });
};
exports.showSuccess = showSuccess;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\snap-keyring\\utils\\showResult.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\start-up-errors\\start-up-errors.ts", {"loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Cstart-up-errors%5Cstart-up-errors.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tryPostMessage = tryPostMessage;
var _loglevel = _interopRequireDefault(require("loglevel"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Attempts to post a `message` to the given `port` via `port.postMessage`. If
 * the postMessage call fails due to an exception it will ignore it by catching
 * and then logging it.
 *
 * @param port - The port to post the message to.
 * @param method - The method to call on the port.
 * @param params - The parameters to include in the message.
 * @returns Returns true if the message was posted successfully, false otherwise.
 */
function tryPostMessage(port, method, params) {
  const message = {
    data: {
      method,
      params
    }
  };
  try {
    port.postMessage(message);
    return true;
  } catch (e) {
    // an exception can occur here if the Window has since disconnected from
    // the background, this might be expected, for example, if the UI is closed
    // while we are still initializing the background (like during a call to
    // `await isInitialized;`)
    _loglevel.default.error('MetaMask - Failed to message to port', e, message);
    return false;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\start-up-errors\\start-up-errors.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\state-corruption\\state-corruption-recovery.ts", {"../../../../shared/constants/start-up-errors":"D:\\code\\v\\metamask-extension\\shared\\constants\\start-up-errors.ts","../../../../shared/constants/state-corruption":"D:\\code\\v\\metamask-extension\\shared\\constants\\state-corruption.ts","../start-up-errors/start-up-errors":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\start-up-errors\\start-up-errors.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Cstate-corruption%5Cstate-corruption-recovery.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CorruptionHandler = void 0;
exports.hasVault = hasVault;
var _utils = require("@metamask/utils");
var _stateCorruption = require("../../../../shared/constants/state-corruption");
var _startUpErrors = require("../start-up-errors/start-up-errors");
var _startUpErrors2 = require("../../../../shared/constants/start-up-errors");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
const REPAIR_LOCK_NAME = 'repairDatabase';

/**
 * Requests a lock for the repair operation. This is used to ensure that only
 * one repair operation is happening at a time. If the lock is available it will
 * call and await the provided `repairDatabase` function then return true. If
 * the lock is not available, it will return false and the callback will *not*
 * be called.
 *
 * @param repairDatabase - A function that is called only when the request is
 * granted.
 */
async function requestRepair(repairDatabase) {
  return await navigator.locks.request(REPAIR_LOCK_NAME, {
    ifAvailable: true
  }, async function requestRepairLockCallback(lock) {
    // something is already repairing the database
    if (lock === null) {
      return false;
    }
    await repairDatabase();
    return true;
  });
}

/**
 * Attempts to get a backup from the database. If the error passed in has a
 * `backup` property, it will use that instead of reading from the database.
 * This is useful for errors that are thrown during the backup process, as
 * they may already have a backup object on them.
 *
 * @param error - The error that caused the state corruption.
 * @param database - The database to get the backup from.
 */
async function maybeGetBackup(error, database) {
  /**
   * A STATE_CORRUPTION_ERROR may have a `backup` property already on it,
   * if it does, we can use it without reading from the DB again.
   */
  let backup = (0, _utils.isObject)(error) && (0, _utils.hasProperty)(error, 'backup') && error.backup !== null ? error.backup : null;
  if (!backup) {
    try {
      backup = (await database.getBackup()) ?? null;
    } catch {
      // ignore errors here since we're already in an error state, we really
      // only care about the error that got us here.
      backup = null;
    }
  }
  return backup;
}

/**
 * Attempts to get the current locale from the backup.
 *
 * @param backup - The backup object to extract the locale from.
 * @returns The current locale if found, otherwise null.
 */
function maybeGetCurrentLocale(backup) {
  // we're overly defensive here because we have no idea what happened to the
  // database, and we don't want to throw another error on some unexpected object.
  if ((0, _utils.isObject)(backup) && (0, _utils.hasProperty)(backup, 'PreferencesController')) {
    const preferencesController = backup.PreferencesController;
    if ((0, _utils.isObject)(preferencesController) && (0, _utils.hasProperty)(preferencesController, 'currentLocale') && typeof preferencesController.currentLocale === 'string') {
      return preferencesController.currentLocale;
    }
  }
  return null;
}

/**
 * Checks if the backup object has a vault.
 *
 * @param backup - The backup object to check for a vault.
 * @returns True if the vault exists, otherwise false.
 */
function hasVault(backup) {
  // we're overly defensive here because we have no idea what happened to the
  // database, and we don't want to throw another error on some unexpected object.
  if ((0, _utils.isObject)(backup) && (0, _utils.hasProperty)(backup, 'KeyringController')) {
    const keyringController = backup.KeyringController;
    if ((0, _utils.isObject)(keyringController) && (0, _utils.hasProperty)(keyringController, 'vault')) {
      return Boolean(keyringController.vault);
    }
  }
  return false;
}
class CorruptionHandler {
  constructor() {
    /**
     * Stores the connected ports that are used to send messages to the UI. This is
     * used to ensure that only one repair operation is happening at a time, and to
     * allow the UI to listen for messages from the background. The ports are stored
     * in a Set to ensure that there are no duplicates. The ports are removed from
     * the Set when they are disconnected.
     */
    _defineProperty(this, "connectedPorts", new Set());
  }
  /**
   * Handles a state corruption error by sending a message to the UI and
   * initiating a repair process if requested by the UI port.
   *
   * @param config - The configuration parameters for handling the state
   * corruption error.
   * @param config.port - The port to send the error message to.
   * @param config.error - The error that caused the state corruption.
   * @param config.database - The database to get the backup from.
   * @param config.repairCallback - The function to call to repair the database.
   */
  async handleStateCorruptionError({
    port,
    error,
    database,
    repairCallback
  }) {
    const {
      connectedPorts
    } = this;
    const backup = await maybeGetBackup(error, database);
    const currentLocale = maybeGetCurrentLocale(backup);
    // it is not worth claiming we have a backup if the vault doesn't actually
    // exist
    const hasBackup = Boolean(hasVault(backup));

    // send the `error` to the UI for this port
    const sent = (0, _startUpErrors.tryPostMessage)(port, _stateCorruption.METHOD_DISPLAY_STATE_CORRUPTION_ERROR, {
      error: {
        message: error.message,
        name: error.name,
        stack: error.stack
      },
      currentLocale,
      hasBackup
    });
    if (!sent) {
      return Promise.resolve();
    }

    // if we successfully sent the error to the UI, listen for a "restore"
    // method call back to us
    return new Promise((resolve, reject) => {
      connectedPorts.add(port);
      port.onDisconnect.addListener(onDisconnect);
      port.onMessage.addListener(restoreVaultListener);

      // remove from `connectedPorts` if the port disconnects. this is
      // automatically called when the UI closes
      function onDisconnect() {
        connectedPorts.delete(port);
        resolve();
      }
      /**
       * Listens for a message from the UI to restore the vault. If the message
       * is received, it will call the `repair` function with the backup and
       * reload the UI. It will also unregister the listener from all UI windows
       * to prevent multiple restore requests.
       *
       * @param message - The message sent from the UI to the background.
       */
      async function restoreVaultListener(message) {
        var _message$data;
        if ((message === null || message === void 0 || (_message$data = message.data) === null || _message$data === void 0 ? void 0 : _message$data.method) === _stateCorruption.METHOD_REPAIR_DATABASE) {
          // only allow the restore process once, unregister
          // `restoreVaultListener` listeners from all UI windows
          connectedPorts.forEach(connectedPort => connectedPort.onMessage.removeListener(restoreVaultListener));
          try {
            await requestRepair(async function repairDatabase() {
              // this callback might be ignored if another repair request
              // is already in progress.

              try {
                await repairCallback(backup);
              } finally {
                // always reload the UI because if `initBackground` worked, the UI
                // will redirect to the login screen, and if it didn't work, it'll
                // show them a new error message (which could be the same as the
                // vault error that sent them here in the first place, but hopefully
                // not!)
                connectedPorts.forEach(connectedPort => {
                  // as each page reloads, it will remove itself from the
                  // `connectedPorts` on disconnection.
                  (0, _startUpErrors.tryPostMessage)(connectedPort, _startUpErrors2.RELOAD_WINDOW);
                });
              }
            });
            resolve();
          } catch (e) {
            reject(e);
          }
        }
      }
    });
  }
}
exports.CorruptionHandler = CorruptionHandler;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\state-corruption\\state-corruption-recovery.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\state-utils.ts", {"lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Cstate-utils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sanitizePatches = sanitizePatches;
exports.sanitizeUIState = sanitizeUIState;
var _lodash = require("lodash");
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any

/*
 * Top-level state keys to not send to UI.
 * Temporary mechanism pending new state metadata property.
 */
const REMOVE_KEYS = [
// KeyringController
'encryptionKey', 'encryptionSalt', 'vault',
// PhishingController
'c2DomainBlocklistLastFetched', 'hotlistLastFetched', 'phishingLists', 'stalelistLastFetched', 'whitelist', 'whitelistPaths',
// SeedlessOnboardingController
'accessToken', 'encryptedKeyringEncryptionKey', 'encryptedSeedlessEncryptionKey', 'metadataAccessToken', 'refreshToken', 'revokeToken', 'vaultEncryptionKey', 'vaultEncryptionSalt',
// SnapController
'snapStates', 'unencryptedSnapStates'];

/*
 * Data to remove from patches.
 * Patches with matching paths will be skipped.
 * Matching data in a patch value will also be removed.
 * Using `true` acts as a wildcard to match any key or index at that level.
 */
const REMOVE_PATHS = [['nodeAuthTokens', true, 'authToken'], ['snaps', true, 'auxiliaryFiles'], ['snaps', true, 'sourceCode'], ['socialBackupsMetadata', true, 'hash'], ['srpSessionData', true, 'token', 'accessToken']];
function sanitizePatches(patches) {
  return patches.filter(patch => {
    if (REMOVE_KEYS.includes(patch.path[0])) {
      return false;
    }
    for (const removePath of REMOVE_PATHS) {
      if (deletePathFromPatch(patch, removePath)) {
        return false;
      }
    }
    return true;
  });
}
function sanitizeUIState(state) {
  const newState = {
    ...state
  };
  for (const key of REMOVE_KEYS) {
    delete newState[key];
  }
  sanitizeSnapData(newState);
  sanitizeAuthenticationControllerState(newState);
  sanitizeSeedlessOnboardingControllerState(newState);
  return newState;
}
function sanitizeSnapData(state) {
  const snapsData = state.snaps;
  if (!snapsData) {
    return;
  }
  state.snaps = Object.values(snapsData).reduce((acc, snap) => {
    acc[snap.id] = stripLargeSnapData(snap);
    return acc;
  }, {});
}
function stripLargeSnapData(snapData) {
  const newData = {
    ...snapData
  };
  delete newData.sourceCode;
  delete newData.auxiliaryFiles;
  return newData;
}
function sanitizeAuthenticationControllerState(state) {
  const srpSessionData = state.srpSessionData;
  if (!srpSessionData) {
    return;
  }
  state.srpSessionData = Object.entries(srpSessionData).reduce((acc, [key, value]) => {
    const token = {
      ...value.token
    };
    // @ts-expect-error - Intentionally sanitizing a required field.
    delete token.accessToken;
    acc[key] = {
      ...value,
      token
    };
    return acc;
  }, {});
}
function sanitizeSeedlessOnboardingControllerState(state) {
  // Manually sanitize the nodeAuthTokens.
  const nodeAuthTokens = state.nodeAuthTokens;
  if (nodeAuthTokens) {
    state.nodeAuthTokens = nodeAuthTokens.map(token => {
      const sanitizedToken = {
        ...token
      };
      // @ts-expect-error - Intentionally sanitizing a required field.
      delete sanitizedToken.authToken;
      return sanitizedToken;
    });
  }

  // Manually sanitize the socialBackupsMetadata.
  const socialBackupsMetadata = state.socialBackupsMetadata;
  if (socialBackupsMetadata) {
    state.socialBackupsMetadata = socialBackupsMetadata.map(backup => {
      const sanitizedBackup = {
        ...backup
      };
      // @ts-expect-error - Intentionally sanitizing a required field.
      delete sanitizedBackup.hash;
      return sanitizedBackup;
    });
  }
}

/**
 * Ensure that a patch does not contain data with a specific path.
 * This checks both the patch path, plus any matching data in the patch value.
 *
 * @param patch - The patch to check and modify.
 * @param removePath - The path to remove, with `true` as a wildcard for any key or index.
 * @returns Whether the entire patch should be removed.
 */
function deletePathFromPatch(patch, removePath) {
  for (let i = 0; i < removePath.length; i++) {
    const key = removePath[i];
    const isLastKey = i === removePath.length - 1;
    const isLastPatchKey = i === patch.path.length - 1;
    const isMatch = patch.path[i] === key || key === true && patch.path[i] !== undefined;

    // Do not delete patch as paths do not match
    if (!isMatch) {
      return false;
    }

    // Delete patch as paths match
    if (isLastKey) {
      return true;
    }

    // Do not delete patch as paths do not match and primitive value
    if (isLastPatchKey && !isObjectOrArray(patch.value)) {
      return false;
    }

    // Remove path may be inside the patch value
    // Do not delete patch but mutate it to delete remove path from the value
    if (isLastPatchKey) {
      const remainingPath = removePath.slice(i + 1);
      patch.value = (0, _lodash.cloneDeep)(patch.value);
      deletePathInObject(patch.value, remainingPath);
      return false;
    }

    // Continue iterating until we reach the end of the remove path or the patch path
  }
  return false;
}

/**
 * Delete a specific path from an object.
 * Uses `true` as a wildcard to match any key or index at that level.
 *
 * @param obj - The object to modify.
 * @param removePath - The path to remove.
 * @param index - The current index in the path.
 */
function deletePathInObject(obj, removePath, index = 0) {
  const key = removePath[index];
  const isLast = index === removePath.length - 1;
  if (isLast && key !== true && key in obj && !Array.isArray(obj)) {
    delete obj[key];
    return;
  }
  if (isLast) {
    return;
  }
  let children = [];
  if (key === true) {
    children = Object.values(obj);
  } else if (!Array.isArray(obj)) {
    children = [obj[key]];
  }
  const validChildren = children.filter(isObjectOrArray);
  for (const child of validChildren) {
    deletePathInObject(child, removePath, index + 1);
  }
}
function isObjectOrArray(value) {
  return typeof value === 'object' && value !== null && value !== undefined;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\state-utils.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\containers\\enforced-simulations.ts", {"../../../../../shared/lib/delegation":"D:\\code\\v\\metamask-extension\\shared\\lib\\delegation\\index.ts","../../../../../shared/lib/delegation/delegation":"D:\\code\\v\\metamask-extension\\shared\\lib\\delegation\\delegation.ts","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Ctransaction%5Ccontainers%5Cenforced-simulations.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enforceSimulations = enforceSimulations;
var _transactionController = require("@metamask/transaction-controller");
var _utils = require("@metamask/utils");
var _bignumber = require("bignumber.js");
var _delegation = require("../../../../../shared/lib/delegation");
var _delegation2 = require("../../../../../shared/lib/delegation/delegation");
const log = (0, _utils.createProjectLogger)('enforced-simulations');
const MOCK_DELEGATION_SIGNATURE = '0x2261a7810ed3e9cde160895909e138e2f68adb2da86fcf98ea0840701df107721fb369ab9b52550ea98832c09f8185284aca4c94bd345e867a4f4461868dd7751b';
async function enforceSimulations({
  messenger,
  transactionMeta,
  useRealSignature = false
}) {
  log('Enforcing simulations', {
    transactionMeta,
    useRealSignature
  });
  const {
    chainId,
    simulationData = {
      tokenBalanceChanges: []
    },
    txParams
  } = transactionMeta;
  const from = txParams.from;
  const chainIdDecimal = (0, _utils.hexToNumber)(chainId);
  const delegationEnvironment = (0, _delegation.getDeleGatorEnvironment)(chainIdDecimal);
  const delegationManagerAddress = delegationEnvironment.DelegationManager;
  const slippage = getSlippage(messenger, transactionMeta.id);
  const delegation = generateDelegation({
    accountAddress: from,
    environment: delegationEnvironment,
    simulationData,
    slippage
  });
  log('Delegation', delegation);
  let delegationSignature = MOCK_DELEGATION_SIGNATURE;
  if (useRealSignature) {
    log('Signing delegation');
    delegationSignature = await messenger.call('DelegationController:signDelegation', {
      chainId,
      delegation
    });
  }
  log('Delegation signature', delegationSignature);
  const data = generateCalldata({
    transaction: txParams,
    delegation: {
      ...delegation,
      signature: delegationSignature
    }
  });
  log('Data', data);
  return {
    updateTransaction: transaction => {
      transaction.txParams.data = data;
      transaction.txParams.to = delegationManagerAddress;
      transaction.txParams.value = '0x0';
    }
  };
}
function generateDelegation({
  accountAddress,
  environment,
  simulationData,
  slippage
}) {
  const caveats = generateCaveats(accountAddress, environment, simulationData, slippage);
  log('Caveats', caveats);
  const delegation = (0, _delegation.createDelegation)({
    from: accountAddress,
    to: accountAddress,
    caveats
  });
  return delegation;
}
function generateCalldata({
  transaction,
  delegation
}) {
  const delegations = [[delegation]];
  const modes = [_delegation.SINGLE_DEFAULT_MODE];
  const executions = [[{
    target: transaction.to,
    callData: transaction.data ?? '0x',
    value: transaction.value ? BigInt(transaction.value) : 0n
  }]];
  return (0, _delegation2.encodeRedeemDelegations)({
    delegations,
    modes,
    executions
  });
}
function generateCaveats(recipient, environment, simulationData, slippage) {
  const caveatBuilder = (0, _delegation.createCaveatBuilder)(environment);
  const {
    nativeBalanceChange,
    tokenBalanceChanges = []
  } = simulationData;
  if (nativeBalanceChange) {
    const {
      difference,
      isDecrease: enforceDecrease
    } = nativeBalanceChange;
    const delta = applySlippage(difference, slippage, enforceDecrease);
    log('Caveat - Native Balance Change', {
      enforceDecrease,
      recipient,
      delta: BigInt(difference),
      slippage,
      deltaWithSlippage: delta
    });
    caveatBuilder.addCaveat('nativeBalanceChange', enforceDecrease, recipient, delta);
  }
  for (const tokenChange of tokenBalanceChanges) {
    const {
      difference,
      isDecrease: enforceDecrease,
      address: token,
      standard,
      id: tokenIdHex
    } = tokenChange;
    const delta = BigInt(difference);
    const deltaWithSlippage = applySlippage(difference, slippage, enforceDecrease);
    const tokenId = tokenIdHex ? BigInt(tokenIdHex) : 0n;
    log('Caveat - Token Balance Change', {
      enforceDecrease,
      token,
      recipient,
      delta,
      slippage,
      deltaWithSlippage
    });
    switch (standard) {
      case _transactionController.SimulationTokenStandard.erc20:
        caveatBuilder.addCaveat('erc20BalanceChange', enforceDecrease, token, recipient, deltaWithSlippage);
        break;
      case _transactionController.SimulationTokenStandard.erc721:
        caveatBuilder.addCaveat('erc721BalanceChange', enforceDecrease, token, recipient, delta);
        break;
      case _transactionController.SimulationTokenStandard.erc1155:
        caveatBuilder.addCaveat('erc1155BalanceChange', enforceDecrease, token, recipient, tokenId, delta);
        break;
      default:
        log('Unsupported token standard', standard);
        break;
    }
  }
  return caveatBuilder.build();
}
function getSlippage(messenger, transactionId) {
  const appControllerState = messenger.call('AppStateController:getState');
  const defaultValue = appControllerState.enforcedSimulationsSlippage;
  const transactionOverride = appControllerState.enforcedSimulationsSlippageForTransactions[transactionId];
  return transactionOverride ?? defaultValue;
}
function applySlippage(value, slippage, isDecrease) {
  const valueBN = new _bignumber.BigNumber(value);
  const slippageMultiplier = (100 + (isDecrease ? slippage : -slippage)) / 100;
  return BigInt(valueBN.mul(slippageMultiplier).toFixed(0));
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\transaction\\containers\\enforced-simulations.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\containers\\util.ts", {"./enforced-simulations":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\containers\\enforced-simulations.ts","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Ctransaction%5Ccontainers%5Cutil.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyTransactionContainers = applyTransactionContainers;
exports.applyTransactionContainersExisting = applyTransactionContainersExisting;
var _transactionController = require("@metamask/transaction-controller");
var _lodash = require("lodash");
var _utils = require("@metamask/utils");
var _enforcedSimulations = require("./enforced-simulations");
const log = (0, _utils.createProjectLogger)('transaction-containers');
async function applyTransactionContainers({
  isApproved,
  messenger,
  transactionMeta,
  types
}) {
  const {
    txParamsOriginal
  } = transactionMeta;
  const finalMetadata = (0, _lodash.cloneDeep)(transactionMeta);
  if (txParamsOriginal) {
    finalMetadata.txParams = (0, _lodash.cloneDeep)(txParamsOriginal);
  }
  if (types.includes(_transactionController.TransactionContainerType.EnforcedSimulations)) {
    const {
      updateTransaction
    } = await (0, _enforcedSimulations.enforceSimulations)({
      messenger,
      transactionMeta: finalMetadata,
      useRealSignature: isApproved
    });
    updateTransaction(finalMetadata);
  }
  let newGas;
  if (!isApproved) {
    const {
      gas
    } = await messenger.call('TransactionController:estimateGas', finalMetadata.txParams, finalMetadata.networkClientId, {
      ignoreDelegationSignatures: true
    });
    log('Estimated gas', gas);
    newGas = gas;
  }
  return {
    updateTransaction: transaction => {
      transaction.containerTypes = types;
      transaction.txParams = (0, _lodash.cloneDeep)(finalMetadata.txParams);
      if (newGas) {
        transaction.txParams.gas = newGas;
      }
    }
  };
}
async function applyTransactionContainersExisting({
  containerTypes,
  transactionId,
  messenger,
  updateEditableParams
}) {
  const transactionControllerState = await messenger.call('TransactionController:getState');
  const transactionMeta = transactionControllerState.transactions.find(tx => tx.id === transactionId);
  if (!transactionMeta) {
    throw new Error(`Transaction with ID ${transactionId} not found.`);
  }
  const {
    updateTransaction
  } = await applyTransactionContainers({
    isApproved: false,
    messenger,
    transactionMeta,
    types: containerTypes
  });
  const newTransactionMeta = (0, _lodash.cloneDeep)(transactionMeta);
  updateTransaction(newTransactionMeta);
  updateEditableParams(transactionId, {
    containerTypes,
    data: newTransactionMeta.txParams.data,
    gas: newTransactionMeta.txParams.gas,
    to: newTransactionMeta.txParams.to,
    value: newTransactionMeta.txParams.value
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\transaction\\containers\\util.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\decode\\four-byte.ts", {"../../../../../shared/lib/four-byte":"D:\\code\\v\\metamask-extension\\shared\\lib\\four-byte.ts","@ethersproject/abi":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\abi\\lib\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","ethereumjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\ethereumjs-util\\dist.browser\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Ctransaction%5Cdecode%5Cfour-byte.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decodeTransactionDataWithFourByte = decodeTransactionDataWithFourByte;
var _ethereumjsUtil = require("ethereumjs-util");
var _abi = require("@ethersproject/abi");
var _utils = require("@metamask/utils");
var _fourByte = require("../../../../../shared/lib/four-byte");
const log = (0, _utils.createProjectLogger)('four-byte');
async function decodeTransactionDataWithFourByte(transactionData) {
  const fourBytePrefix = transactionData.slice(0, 10);
  const signature = await (0, _fourByte.getMethodFrom4Byte)(fourBytePrefix);
  if (!signature) {
    return undefined;
  }
  const name = signature.split('(')[0];
  const inputs = parseSignature(signature);
  log('Generated inputs', inputs);
  const valueData = (0, _ethereumjsUtil.addHexPrefix)(transactionData.slice(10));
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const values = _abi.Interface.getAbiCoder().decode(inputs, valueData);
  const params = inputs.map((input, index) => decodeParam(input, index, values));
  return {
    name,
    params
  };
}
function decodeParam(input, index,
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
values) {
  var _input$components;
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const value = values[index];
  const {
    type,
    name
  } = input;
  let children = (_input$components = input.components) === null || _input$components === void 0 ? void 0 : _input$components.map((child, childIndex) => decodeParam(child, childIndex, value));
  if (type.endsWith('[]')) {
    const childType = type.slice(0, -2);
    children = value.map((_arrayItem, arrayIndex) => {
      const childName = `Item ${arrayIndex + 1}`;
      return decodeParam({
        ...input,
        name: childName,
        type: childType
      }, arrayIndex, value);
    });
  }
  return {
    name,
    type,
    value,
    children
  };
}
function parseSignature(signature) {
  let typeString = signature.slice(signature.indexOf('(') + 1, -1);
  const nested = [];
  while (typeString.includes('(')) {
    const nestedBrackets = findFirstNestedBrackets(typeString);
    if (!nestedBrackets) {
      break;
    }
    nested.push(nestedBrackets.value);
    typeString = `${typeString.slice(0, nestedBrackets.start)}${nested.length - 1}#${typeString.slice(nestedBrackets.end + 1)}`;
  }
  return createInput(typeString, nested);
}
function createInput(typeString, nested) {
  return typeString.split(',').map(value => {
    const parts = value.split('#');
    const nestedIndex = parts.length > 1 ? parseInt(parts[0], 10) : undefined;
    const type = nestedIndex === undefined ? value : `tuple${parts[1] ?? ''}`;
    const components = nestedIndex === undefined ? undefined : createInput(nested[nestedIndex], nested);
    return {
      type,
      components
    };
  });
}
function findFirstNestedBrackets(value) {
  let start = -1;
  for (let i = 0; i < value.length; i++) {
    if (value[i] === '(') {
      start = i;
    } else if (value[i] === ')' && start !== -1) {
      return {
        start,
        end: i,
        value: value.slice(start + 1, i)
      };
    }
  }
  return undefined;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\transaction\\decode\\four-byte.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\decode\\proxy.ts", {"ethereumjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\ethereumjs-util\\dist.browser\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Ctransaction%5Cdecode%5Cproxy.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getContractProxyAddress = getContractProxyAddress;
var _ethereumjsUtil = require("ethereumjs-util");
const IMPLEMENTATION_STORAGE_SLOTS = [
// org.zeppelinos.proxy.implementation
'0x7050c9e0f4ca769c69bd3a8ef740bc37934f8e2c036e5a723fd8ee048ed3f8c3',
// eip1967.proxy.implementation
'0x360894a13ba1a3210667c828492db98dca3e2076cc3735a920a3ca505d382bbc'];
const EMPTY_RESULT = '0'.padEnd(64, '0');
async function getContractProxyAddress(contractAddress, provider) {
  const responses = await Promise.all(IMPLEMENTATION_STORAGE_SLOTS.map(storageSlot => provider.request({
    method: 'eth_getStorageAt',
    params: [contractAddress, storageSlot, 'latest']
  })));
  const result = responses.find(response => (0, _ethereumjsUtil.stripHexPrefix)(response) !== EMPTY_RESULT);
  return result && (0, _ethereumjsUtil.addHexPrefix)(result.slice(26));
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\transaction\\decode\\proxy.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\decode\\sourcify.ts", {"@ethersproject/abi":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\abi\\lib\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Ctransaction%5Cdecode%5Csourcify.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decodeTransactionDataWithSourcify = decodeTransactionDataWithSourcify;
var _abi = require("@ethersproject/abi");
var _utils = require("@metamask/utils");
const log = (0, _utils.createProjectLogger)('sourcify');
async function decodeTransactionDataWithSourcify(transactionData, contractAddress, chainId) {
  var _metadata$output$user, _metadata$output$devd;
  const metadata = await fetchSourcifyMetadata(contractAddress, chainId);
  log('Retrieved Sourcify metadata', {
    contractAddress,
    chainId,
    metadata
  });
  const {
    abi
  } = metadata.output;
  const contractInterface = new _abi.Interface(abi);
  const functionSignature = transactionData.slice(0, 10);
  let functionData;
  try {
    functionData = contractInterface.getFunction(functionSignature);
  } catch (e) {
    // Ignore
  }
  if (!functionData) {
    log('Failed to find function in ABI', functionSignature, abi);
    return undefined;
  }
  const {
    name,
    inputs
  } = functionData;
  const signature = buildSignature(name, inputs);
  const userDoc = (_metadata$output$user = metadata.output.userdoc) === null || _metadata$output$user === void 0 ? void 0 : _metadata$output$user.methods[signature];
  const devDoc = (_metadata$output$devd = metadata.output.devdoc) === null || _metadata$output$devd === void 0 ? void 0 : _metadata$output$devd.methods[signature];
  const description = (userDoc === null || userDoc === void 0 ? void 0 : userDoc.notice) ?? (devDoc === null || devDoc === void 0 ? void 0 : devDoc.details);
  log('Extracted NatSpec', {
    signature,
    userDoc,
    devDoc
  });
  const values = contractInterface.decodeFunctionData(functionSignature, transactionData
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  );
  const params = inputs.map((input, index) => decodeParam(input, index, values, userDoc, devDoc));
  return {
    name,
    description,
    params
  };
}
function decodeParam(input, index,
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
values,
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
userDoc,
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
devDoc) {
  var _userDoc$params, _devDoc$params;
  const {
    name: paramName,
    type,
    components
  } = input;
  const paramDescription = (userDoc === null || userDoc === void 0 || (_userDoc$params = userDoc.params) === null || _userDoc$params === void 0 ? void 0 : _userDoc$params[paramName]) ?? (devDoc === null || devDoc === void 0 || (_devDoc$params = devDoc.params) === null || _devDoc$params === void 0 ? void 0 : _devDoc$params[paramName]);
  const value = values[index];
  let children = components === null || components === void 0 ? void 0 : components.map((child, childIndex) => decodeParam(child, childIndex, value, {}, {}));
  if (type.endsWith('[]')) {
    const childType = type.slice(0, -2);

    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    children = value.map((_arrayItem, arrayIndex) => {
      const childName = `Item ${arrayIndex + 1}`;
      return decodeParam({
        ...input,
        name: childName,
        type: childType
      }, arrayIndex, value, {}, {});
    });
  }
  return {
    name: paramName,
    description: paramDescription,
    type,
    value,
    children
  };
}
async function fetchSourcifyMetadata(address, chainId) {
  var _response$files;
  const response = await fetchSourcifyFiles(address, chainId);
  const metadata = (_response$files = response.files) === null || _response$files === void 0 ? void 0 : _response$files.find(file => file.name.includes('metadata.json'));
  if (!metadata) {
    throw new Error('Metadata not found');
  }
  return JSON.parse(metadata.content);
}
async function fetchSourcifyFiles(address, chainId) {
  const chainIdDecimal = parseInt(chainId, 16);
  const respose = await fetch(`https://sourcify.dev/server/files/any/${chainIdDecimal}/${address}`);
  if (!respose.ok) {
    throw new Error('Failed to fetch Sourcify files');
  }
  return respose.json();
}
function buildSignature(name, inputs) {
  const types = inputs.map(input => {
    var _input$components;
    return (_input$components = input.components) !== null && _input$components !== void 0 && _input$components.length ? `${buildSignature(undefined, input.components)}${input.type.endsWith('[]') ? '[]' : ''}` : input.type;
  });
  return `${name ?? ''}(${types.join(',')})`;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\transaction\\decode\\sourcify.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\decode\\uniswap-commands.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Ctransaction%5Cdecode%5Cuniswap-commands.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNISWAP_ROUTER_COMMANDS = void 0;
const UNISWAP_ROUTER_COMMANDS = exports.UNISWAP_ROUTER_COMMANDS = {
  '0': {
    name: 'V3_SWAP_EXACT_IN',
    params: [{
      type: 'address',
      description: 'The recipient of the output of the trade',
      name: 'recipient'
    }, {
      type: 'uint256',
      description: 'The amount of input tokens for the trade',
      name: 'amountIn'
    }, {
      type: 'uint256',
      description: 'The minimum amount of output tokens the user wants',
      name: 'amountOutMin'
    }, {
      type: 'bytes',
      description: 'The UniswapV3 encoded path to trade along',
      name: 'path'
    }, {
      type: 'bool',
      description: 'A flag for whether the input tokens should come from the msg.sender (through Permit2) or whether the funds are already in the UniversalRouter',
      name: 'payerIsUser'
    }]
  },
  '1': {
    name: 'V3_SWAP_EXACT_OUT',
    params: [{
      type: 'address',
      description: 'The recipient of the output of the trade',
      name: 'recipient'
    }, {
      type: 'uint256',
      description: 'The amount of output tokens to receive',
      name: 'amountOut'
    }, {
      type: 'uint256',
      description: 'The maximum number of input tokens that should be spent',
      name: 'amountInMax'
    }, {
      type: 'bytes',
      description: 'The UniswapV3 encoded path to trade along',
      name: 'path'
    }, {
      type: 'bool',
      description: 'A flag for whether the input tokens should come from the msg.sender (through Permit2) or whether the funds are already in the UniversalRouter',
      name: 'payerIsUser'
    }]
  },
  '2': {
    name: 'PERMIT2_TRANSFER_FROM',
    params: [{
      type: 'address',
      description: 'The token to fetch from Permit2',
      name: 'token'
    }, {
      type: 'address',
      description: 'The recipient of the tokens fetched',
      name: 'recipient'
    }, {
      type: 'uint256',
      description: 'The amount of token to fetch',
      name: 'amount'
    }]
  },
  '3': {
    name: 'PERMIT2_PERMIT_BATCH',
    params: [{
      type: 'bytes',
      description: 'A PermitBatch struct outlining all of the Permit2 permits to execute.',
      name: 'batch'
    }, {
      type: 'bytes',
      description: 'The signature to provide to Permit2',
      name: 'data'
    }]
  },
  '4': {
    name: 'SWEEP',
    params: [{
      type: 'address',
      description: 'The ERC20 token to sweep (or Constants.ETH for ETH)',
      name: 'token'
    }, {
      type: 'address',
      description: 'The recipient of the sweep',
      name: 'recipient'
    }, {
      type: 'uint256',
      description: 'The minimum required tokens to receive from the sweep',
      name: 'amountMin'
    }]
  },
  '5': {
    name: 'TRANSFER',
    params: [{
      type: 'address',
      description: 'The ERC20 token to transfer (or Constants.ETH for ETH)',
      name: 'token'
    }, {
      type: 'address',
      description: 'The recipient of the transfer',
      name: 'recipient'
    }, {
      type: 'uint256',
      description: 'The amount to transfer',
      name: 'value'
    }]
  },
  '6': {
    name: 'PAY_PORTION',
    params: [{
      type: 'address',
      description: 'The ERC20 token to transfer (or Constants.ETH for ETH)',
      name: 'token'
    }, {
      type: 'address',
      description: 'The recipient of the transfer',
      name: 'recipient'
    }, {
      type: 'uint256',
      description: 'In basis points, the percentage of the contract’s balance to transfer',
      name: 'bips'
    }]
  },
  '8': {
    name: 'V2_SWAP_EXACT_IN',
    params: [{
      type: 'address',
      description: 'The recipient of the output of the trade',
      name: 'recipient'
    }, {
      type: 'uint256',
      description: 'The amount of input tokens for the trade',
      name: 'amountIn'
    }, {
      type: 'uint256',
      description: 'The minimum amount of output tokens the user wants',
      name: 'amountOutMin'
    }, {
      type: 'address[]',
      description: 'The UniswapV2 token path to trade along',
      name: 'path'
    }, {
      type: 'bool',
      description: 'A flag for whether the input tokens should come from the msg.sender (through Permit2) or whether the funds are already in the UniversalRouter',
      name: 'payerIsUser'
    }]
  },
  '9': {
    name: 'V2_SWAP_EXACT_OUT',
    params: [{
      type: 'address',
      description: 'The recipient of the output of the trade',
      name: 'recipient'
    }, {
      type: 'uint256',
      description: 'The amount of output tokens to receive',
      name: 'amountOut'
    }, {
      type: 'uint256',
      description: 'The maximum number of input tokens that should be spent',
      name: 'amountInMax'
    }, {
      type: 'address[]',
      description: 'The UniswapV2 token path to trade along',
      name: 'path'
    }, {
      type: 'bool',
      description: 'A flag for whether the input tokens should come from the msg.sender (through Permit2) or whether the funds are already in the UniversalRouter',
      name: 'payerIsUser'
    }]
  },
  '10': {
    name: 'PERMIT2_PERMIT',
    params: [{
      type: 'bytes',
      description: 'A PermitSingle struct outlining the Permit2 permit to execute',
      name: 'permitSingle'
    }, {
      type: 'bytes',
      description: 'The signature to provide to Permit2',
      name: 'signature'
    }]
  },
  '11': {
    name: 'WRAP_ETH',
    params: [{
      type: 'address',
      description: 'The recipient of the WETH',
      name: 'recipient'
    }, {
      type: 'uint256',
      description: 'The amount of ETH to wrap',
      name: 'amountMin'
    }]
  },
  '12': {
    name: 'UNWRAP_WETH',
    params: [{
      type: 'address',
      description: 'The recipient of the ETH',
      name: 'recipient'
    }, {
      type: 'uint256',
      description: 'The minimum required ETH to receive from the unwrapping',
      name: 'amountMin'
    }]
  },
  '13': {
    name: 'PERMIT2_TRANSFER_FROM_BATCH',
    params: [{
      type: 'bytes',
      description: 'An array of AllowanceTransferDetails structs that each describe a Permit2 transfer to perform',
      name: 'batchDetails'
    }]
  },
  '16': {
    name: 'SEAPORT',
    params: [{
      type: 'uint256',
      description: 'The ETH value to forward to the Seaport contract',
      name: 'value'
    }, {
      type: 'bytes',
      description: 'The calldata to use to call the Seaport contract',
      name: 'data'
    }]
  },
  '17': {
    name: 'LOOKS_RARE_721',
    params: [{
      type: 'uint256',
      description: 'The ETH value to forward to the LooksRare contract',
      name: 'value'
    }, {
      type: 'bytes',
      description: 'The calldata to use to call the LooksRare contract',
      name: 'data'
    }, {
      type: 'address',
      description: 'The recipient of the ERC721',
      name: 'recipient'
    }, {
      type: 'address',
      description: 'The ERC721 token address',
      name: 'token'
    }, {
      type: 'uint256',
      description: 'The ID of the ERC721',
      name: 'id'
    }]
  },
  '18': {
    name: 'NFTX',
    params: [{
      type: 'uint256',
      description: 'The ETH value to forward to the NFTX contract',
      name: 'value'
    }, {
      type: 'bytes',
      description: 'The calldata to use to call the NFTX contract',
      name: 'data'
    }]
  },
  '19': {
    name: 'CRYPTOPUNKS',
    params: [{
      type: 'uint256',
      description: 'The PunkID to purchase',
      name: 'punkId'
    }, {
      type: 'address',
      description: 'The recipient for the cryptopunk',
      name: 'recipient'
    }, {
      type: 'uint256',
      description: 'The ETH value to forward to the Cryptopunks contract',
      name: 'value'
    }]
  },
  '20': {
    name: 'LOOKS_RARE_1155',
    params: [{
      type: 'uint256',
      description: 'The ETH value to forward to the LooksRare contract',
      name: 'value'
    }, {
      type: 'bytes',
      description: 'The calldata to use to call the LooksRare contract',
      name: 'data'
    }, {
      type: 'address',
      description: 'The recipient of the ERC1155',
      name: 'recipient'
    }, {
      type: 'address',
      description: 'The ERC1155 token address',
      name: 'token'
    }, {
      type: 'uint256',
      description: 'The ID of the ERC1155',
      name: 'id'
    }, {
      type: 'uint256',
      description: 'The amount of the ERC1155 to transfer',
      name: 'amount'
    }]
  },
  '21': {
    name: 'OWNER_CHECK_721',
    params: [{
      type: 'address',
      description: 'The required owner of the ERC721',
      name: 'owner'
    }, {
      type: 'address',
      description: 'The ERC721 token address',
      name: 'token'
    }, {
      type: 'uint256',
      description: 'The ID of the ERC721',
      name: 'id'
    }]
  },
  '22': {
    name: 'OWNER_CHECK_1155',
    params: [{
      type: 'address',
      description: 'The required owner of the ERC1155',
      name: 'owner'
    }, {
      type: 'address',
      description: 'The ERC721 token address',
      name: 'token'
    }, {
      type: 'uint256',
      description: 'The ID of the ERC1155',
      name: 'id'
    }, {
      type: 'uint256',
      description: 'The minimum required amount of the ERC1155',
      name: 'minBalance'
    }]
  },
  '23': {
    name: 'SWEEP_ERC721',
    params: [{
      type: 'address',
      description: 'The ERC721 token address to transfer',
      name: 'token'
    }, {
      type: 'address',
      description: 'The recipient of the transfer',
      name: 'recipient'
    }, {
      type: 'uint256',
      description: 'The token ID to transfer',
      name: 'id'
    }]
  },
  '24': {
    name: 'X2Y2_721',
    params: [{
      type: 'uint256',
      description: 'The ETH value to forward to the X2Y2 contract',
      name: 'value'
    }, {
      type: 'bytes',
      description: 'The calldata to use to call the X2Y2 contract',
      name: 'data'
    }, {
      type: 'address',
      description: 'The recipient of the ERC721',
      name: 'recipient'
    }, {
      type: 'address',
      description: 'The ERC721 token address',
      name: 'token'
    }, {
      type: 'uint256',
      description: 'The ID of the ERC721',
      name: 'id'
    }]
  },
  '25': {
    name: 'SUDOSWAP',
    params: [{
      type: 'uint256',
      description: 'The ETH value to forward to the Sudoswap contract',
      name: 'value'
    }, {
      type: 'bytes',
      description: 'The calldata to use to call the Sudoswap contract',
      name: 'data'
    }]
  },
  '26': {
    name: 'NFT20',
    params: [{
      type: 'uint256',
      description: 'The ETH value to forward to the NFT20 contract',
      name: 'value'
    }, {
      type: 'bytes',
      description: 'The calldata to use to call the NFT20 contract',
      name: 'data'
    }]
  },
  '27': {
    name: 'X2Y2_1155',
    params: [{
      type: 'uint256',
      description: 'The ETH value to forward to the X2Y2 contract',
      name: 'value'
    }, {
      type: 'bytes',
      description: 'The calldata to use to call the X2Y2 contract',
      name: 'data'
    }, {
      type: 'address',
      description: 'The recipient of the ERC1155',
      name: 'recipient'
    }, {
      type: 'address',
      description: 'The ERC1155 token address',
      name: 'token'
    }, {
      type: 'uint256',
      description: 'The ID of the ERC1155',
      name: 'id'
    }, {
      type: 'uint256',
      description: 'The amount of the ERC1155 to transfer',
      name: 'amount'
    }]
  },
  '28': {
    name: 'FOUNDATION',
    params: [{
      type: 'uint256',
      description: 'The ETH value to forward to the Foundation contract',
      name: 'value'
    }, {
      type: 'bytes',
      description: 'The calldata to use to call the Foundation contract',
      name: 'data'
    }, {
      type: 'address',
      description: 'The recipient of the ERC721',
      name: 'recipient'
    }, {
      type: 'address',
      description: 'The ERC721 token address',
      name: 'token'
    }, {
      type: 'uint256',
      description: 'The ID of the ERC721',
      name: 'id'
    }]
  },
  '29': {
    name: 'SWEEP_ERC1155',
    params: [{
      type: 'address',
      description: 'The ERC1155 token address to sweep',
      name: 'token'
    }, {
      type: 'address',
      description: 'The recipient of the sweep',
      name: 'recipient'
    }, {
      type: 'uint256',
      description: 'The token ID to sweep',
      name: 'id'
    }, {
      type: 'uint256',
      description: 'The minimum required tokens to receive from the sweep',
      name: 'amount'
    }]
  }
};

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\transaction\\decode\\uniswap-commands.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\decode\\uniswap.ts", {"../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","./uniswap-commands":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\decode\\uniswap-commands.ts","@ethersproject/abi":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\abi\\lib\\index.js","ethereumjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\ethereumjs-util\\dist.browser\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Ctransaction%5Cdecode%5Cuniswap.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNISWAP_UNIVERSAL_ROUTER_ADDRESSES = void 0;
exports.decodeUniswapRouterTransactionData = decodeUniswapRouterTransactionData;
var _abi = require("@ethersproject/abi");
var _ethereumjsUtil = require("ethereumjs-util");
var _network = require("../../../../../shared/constants/network");
var _uniswapCommands = require("./uniswap-commands");
const ADDRESS_LENGTH = 40;
const TICK_SPACING_LENGTH = 6;
const UNISWAP_UNIVERSAL_ROUTER_ADDRESSES = exports.UNISWAP_UNIVERSAL_ROUTER_ADDRESSES = {
  [_network.CHAIN_IDS.ARBITRUM]: ['0x4C60051384bd2d3C01bfc845Cf5F4b44bcbE9de5', '0xeC8B0F7Ffe3ae75d7FfAb09429e3675bb63503e4', '0x5E325eDA8064b456f4781070C0738d849c824258'],
  [_network.CHAIN_IDS.AVALANCHE]: ['0x82635AF6146972cD6601161c4472ffe97237D292', '0x4Dae2f939ACf50408e13d58534Ff8c2776d45265'],
  [_network.CHAIN_IDS.BASE]: ['0xeC8B0F7Ffe3ae75d7FfAb09429e3675bb63503e4', '0x3fC91A3afd70395Cd496C647d5a6CC9D4B2b7FAD'],
  [_network.CHAIN_IDS.BSC]: ['0x5Dc88340E1c5c6366864Ee415d6034cadd1A9897', '0xeC8B0F7Ffe3ae75d7FfAb09429e3675bb63503e4', '0x4Dae2f939ACf50408e13d58534Ff8c2776d45265'],
  [_network.CHAIN_IDS.MAINNET]: ['0xEf1c6E67703c7BD7107eed8303Fbe6EC2554BF6B', '0x3fC91A3afd70395Cd496C647d5a6CC9D4B2b7FAD'],
  [_network.CHAIN_IDS.OPTIMISM]: ['0xb555edF5dcF85f42cEeF1f3630a52A108E55A654', '0xeC8B0F7Ffe3ae75d7FfAb09429e3675bb63503e4', '0xCb1355ff08Ab38bBCE60111F1bb2B784bE25D7e8'],
  [_network.CHAIN_IDS.POLYGON]: ['0x4C60051384bd2d3C01bfc845Cf5F4b44bcbE9de5', '0x643770E279d5D0733F21d6DC03A8efbABf3255B4', '0xec7BE89e9d109e7e3Fec59c222CF297125FEFda2'],
  [_network.CHAIN_IDS.SEPOLIA]: ['0x3fC91A3afd70395Cd496C647d5a6CC9D4B2b7FAD']
};
const ABI = [{
  constant: true,
  inputs: [{
    name: 'commands',
    type: 'bytes'
  }, {
    name: 'inputs',
    type: 'bytes[]'
  }, {
    name: 'deadline',
    type: 'uint256'
  }],
  name: 'execute',
  type: 'function'
}, {
  constant: true,
  inputs: [{
    name: 'commands',
    type: 'bytes'
  }, {
    name: 'inputs',
    type: 'bytes[]'
  }],
  name: 'execute',
  type: 'function'
}];
function decodeUniswapRouterTransactionData({
  transactionData,
  contractAddress,
  chainId
}) {
  const supportedAddresses = UNISWAP_UNIVERSAL_ROUTER_ADDRESSES[chainId];
  if (!(supportedAddresses !== null && supportedAddresses !== void 0 && supportedAddresses.map(address => address.toLowerCase()).includes(contractAddress.toLowerCase()))) {
    return undefined;
  }
  const contractInterface = new _abi.Interface(ABI);
  let parsedTransactionData;
  try {
    parsedTransactionData = contractInterface.parseTransaction({
      data: transactionData
    });
  } catch (error) {
    return undefined;
  }
  const commands = parsedTransactionData.args.commands;
  const inputs = parsedTransactionData.args.inputs;
  const commandBytes = commands.slice(2).match(/.{1,2}/gu);
  return commandBytes.map((commandByte, i) => decodeUniswapCommand(commandByte, inputs[i])).filter(command => command !== undefined);
}
function decodeUniswapCommand(commandByte, input) {
  const commandValue = parseInt(commandByte, 16);
  // eslint-disable-next-line no-bitwise
  const commandIndex = commandValue & 0b11111;
  const data = _uniswapCommands.UNISWAP_ROUTER_COMMANDS[String(commandIndex)];
  if (!data) {
    return undefined;
  }
  const types = data.params.map(param => param.type);
  const abiDecoder = _abi.Interface.getAbiCoder();
  const values = abiDecoder.decode(types, input);
  const {
    name
  } = data;
  const params = data.params.map((param, index) => {
    const {
      name: paramName,
      type,
      description
    } = param;
    const rawData = values[index];
    const value = paramName === 'path' ? decodeUniswapPath(rawData) : rawData;
    return {
      name: paramName,
      type,
      value,
      description
    };
  });
  return {
    name,
    params
  };
}
function decodeUniswapPath(rawPath) {
  const pools = [];
  let remainingData = (0, _ethereumjsUtil.stripHexPrefix)(rawPath);
  let currentPool = {};
  let isParsingAddress = true;
  while (remainingData.length) {
    if (isParsingAddress) {
      const address = (0, _ethereumjsUtil.addHexPrefix)(remainingData.slice(0, ADDRESS_LENGTH));
      if (currentPool.firstAddress) {
        currentPool.secondAddress = address;
        pools.push(currentPool);
        currentPool = {
          firstAddress: address
        };
      } else {
        currentPool.firstAddress = address;
      }
      remainingData = remainingData.slice(ADDRESS_LENGTH);
    } else {
      currentPool.tickSpacing = parseInt(remainingData.slice(0, TICK_SPACING_LENGTH), 16);
      remainingData = remainingData.slice(TICK_SPACING_LENGTH);
    }
    isParsingAddress = !isParsingAddress;
  }
  return pools;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\transaction\\decode\\uniswap.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\decode\\util.ts", {"../../../../../shared/types/transaction-decode":"D:\\code\\v\\metamask-extension\\shared\\types\\transaction-decode.ts","./four-byte":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\decode\\four-byte.ts","./proxy":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\decode\\proxy.ts","./sourcify":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\decode\\sourcify.ts","./uniswap":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\decode\\uniswap.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Ctransaction%5Cdecode%5Cutil.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decodeTransactionData = decodeTransactionData;
var _utils = require("@metamask/utils");
var _transactionDecode = require("../../../../../shared/types/transaction-decode");
var _uniswap = require("./uniswap");
var _sourcify = require("./sourcify");
var _proxy = require("./proxy");
var _fourByte = require("./four-byte");
const log = (0, _utils.createProjectLogger)('transaction-decode');
async function decodeTransactionData({
  transactionData,
  contractAddress,
  chainId,
  provider
}) {
  log('Decoding transaction data', {
    transactionData,
    contractAddress,
    chainId
  });
  const uniswapData = (0, _uniswap.decodeUniswapRouterTransactionData)({
    transactionData,
    contractAddress,
    chainId
  });
  if (uniswapData) {
    log('Decoded with Uniswap commands', uniswapData);
    return {
      data: normalizeDecodedMethods(uniswapData),
      source: _transactionDecode.DecodedTransactionDataSource.Uniswap
    };
  }
  const proxyAddress = await (0, _proxy.getContractProxyAddress)(contractAddress, provider);
  if (proxyAddress) {
    log('Retrieved proxy implementation address', proxyAddress);
  }
  const address = proxyAddress ?? contractAddress;
  const sourcifyData = (0, _sourcify.decodeTransactionDataWithSourcify)(transactionData, address, chainId);
  const fourByteData = (0, _fourByte.decodeTransactionDataWithFourByte)(transactionData);
  const [sourcifyResult, fourByteResult] = await Promise.allSettled([sourcifyData, fourByteData]);
  if (sourcifyResult.status === 'fulfilled' && sourcifyResult.value) {
    log('Decoded data with Sourcify', sourcifyResult.value);
    return {
      data: normalizeDecodedMethods([sourcifyResult.value]),
      source: _transactionDecode.DecodedTransactionDataSource.Sourcify
    };
  }
  log('Failed to decode data with Sourcify', sourcifyResult);
  if (fourByteResult.status === 'fulfilled' && fourByteResult.value) {
    log('Decoded data with 4Byte', fourByteResult.value);
    return {
      data: normalizeDecodedMethods([fourByteResult.value]),
      source: _transactionDecode.DecodedTransactionDataSource.FourByte
    };
  }
  log('Failed to decode data with 4Byte', fourByteResult);
  return undefined;
}
function normalizeDecodedMethods(methods) {
  return methods.map(method => normalizeDecodedMethod(method));
}
function normalizeDecodedMethod(method) {
  return {
    ...method,
    params: method.params.map(param => normalizeDecodedParam(param))
  };
}
function normalizeDecodedParam(param) {
  var _param$children;
  return {
    ...param,
    value: normalizeDecodedParamValue(param.value),
    children: (_param$children = param.children) === null || _param$children === void 0 ? void 0 : _param$children.map(child => normalizeDecodedParam(child))
  };
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function normalizeDecodedParamValue(value) {
  const hexValue = value._hex;
  if (hexValue) {
    return BigInt(hexValue).toString();
  }
  return value;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\transaction\\decode\\util.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\hooks\\delegation-7702-publish.ts", {"../../../../../shared/lib/delegation":"D:\\code\\v\\metamask-extension\\shared\\lib\\delegation\\index.ts","../../../../../shared/lib/delegation/caveatBuilder/exactExecutionBuilder":"D:\\code\\v\\metamask-extension\\shared\\lib\\delegation\\caveatBuilder\\exactExecutionBuilder.ts","../../../../../shared/lib/delegation/caveatBuilder/limitedCallsBuilder":"D:\\code\\v\\metamask-extension\\shared\\lib\\delegation\\caveatBuilder\\limitedCallsBuilder.ts","../../../../../shared/lib/delegation/caveatBuilder/specificActionERC20TransferBatchBuilder":"D:\\code\\v\\metamask-extension\\shared\\lib\\delegation\\caveatBuilder\\specificActionERC20TransferBatchBuilder.ts","../../../../../shared/lib/delegation/delegation":"D:\\code\\v\\metamask-extension\\shared\\lib\\delegation\\delegation.ts","../transaction-relay":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\transaction-relay.ts","@ethersproject/abi":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\abi\\lib\\index.js","@metamask/metamask-eth-abis":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\metamask-eth-abis\\dist\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Ctransaction%5Chooks%5Cdelegation-7702-publish.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Delegation7702PublishHook = void 0;
var _abi = require("@ethersproject/abi");
var _metamaskEthAbis = require("@metamask/metamask-eth-abis");
var _utils = require("@metamask/utils");
var _delegation = require("../../../../../shared/lib/delegation");
var _exactExecutionBuilder = require("../../../../../shared/lib/delegation/caveatBuilder/exactExecutionBuilder");
var _limitedCallsBuilder = require("../../../../../shared/lib/delegation/caveatBuilder/limitedCallsBuilder");
var _specificActionERC20TransferBatchBuilder = require("../../../../../shared/lib/delegation/caveatBuilder/specificActionERC20TransferBatchBuilder");
var _delegation2 = require("../../../../../shared/lib/delegation/delegation");
var _transactionRelay = require("../transaction-relay");
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
const EMPTY_HEX = '0x';
const POLLING_INTERVAL_MS = 1000; // 1 Second

const EMPTY_RESULT = {
  transactionHash: undefined
};
const log = (0, _utils.createProjectLogger)('delegation-7702-publish-hook');
var _isAtomicBatchSupported = /*#__PURE__*/new WeakMap();
var _messenger = /*#__PURE__*/new WeakMap();
var _Delegation7702PublishHook_brand = /*#__PURE__*/new WeakSet();
class Delegation7702PublishHook {
  constructor({
    isAtomicBatchSupported,
    messenger
  }) {
    _classPrivateMethodInitSpec(this, _Delegation7702PublishHook_brand);
    _classPrivateFieldInitSpec(this, _isAtomicBatchSupported, void 0);
    _classPrivateFieldInitSpec(this, _messenger, void 0);
    _classPrivateFieldSet(_isAtomicBatchSupported, this, isAtomicBatchSupported);
    _classPrivateFieldSet(_messenger, this, messenger);
  }
  getHook() {
    return _assertClassBrand(_Delegation7702PublishHook_brand, this, _hookWrapper).bind(this);
  }
}
exports.Delegation7702PublishHook = Delegation7702PublishHook;
async function _hookWrapper(transactionMeta, _signedTx) {
  try {
    return await _assertClassBrand(_Delegation7702PublishHook_brand, this, _hook).call(this, transactionMeta, _signedTx);
  } catch (error) {
    log('Error', error);
    throw error;
  }
}
async function _hook(transactionMeta, _signedTx) {
  const {
    chainId,
    gasFeeTokens,
    selectedGasFeeToken,
    txParams
  } = transactionMeta;
  const {
    from
  } = txParams;
  const atomicBatchSupport = await _classPrivateFieldGet(_isAtomicBatchSupported, this).call(this, {
    address: from,
    chainIds: [chainId]
  });
  const atomicBatchChainSupport = atomicBatchSupport.find(result => result.chainId.toLowerCase() === chainId.toLowerCase());
  const isChainSupported = atomicBatchChainSupport && (!atomicBatchChainSupport.delegationAddress || atomicBatchChainSupport.isSupported);
  if (!isChainSupported) {
    log('Skipping as EIP-7702 is not supported', {
      from,
      chainId
    });
    return EMPTY_RESULT;
  }
  const {
    delegationAddress,
    upgradeContractAddress
  } = atomicBatchChainSupport;
  const isGaslessSwap = transactionMeta.isGasFeeIncluded;
  const isSponsored = Boolean(transactionMeta.isGasFeeSponsored);
  if ((!selectedGasFeeToken || !(gasFeeTokens !== null && gasFeeTokens !== void 0 && gasFeeTokens.length)) && !isGaslessSwap && !isSponsored) {
    log('Skipping as no selected gas fee token');
    return EMPTY_RESULT;
  }
  const gasFeeToken = isGaslessSwap || isSponsored ? undefined : gasFeeTokens === null || gasFeeTokens === void 0 ? void 0 : gasFeeTokens.find(token => token.tokenAddress.toLowerCase() === (selectedGasFeeToken === null || selectedGasFeeToken === void 0 ? void 0 : selectedGasFeeToken.toLowerCase()));
  if (!gasFeeToken && !isGaslessSwap && !isSponsored) {
    throw new Error('Selected gas fee token not found');
  }
  const delegationEnvironment = (0, _delegation.getDeleGatorEnvironment)(parseInt(transactionMeta.chainId, 16));
  const delegationManagerAddress = delegationEnvironment.DelegationManager;
  const includeTransfer = !isGaslessSwap && !transactionMeta.isGasFeeSponsored;
  if (includeTransfer && (!gasFeeToken || gasFeeToken === undefined)) {
    throw new Error('Gas fee token not found');
  }
  const delegations = await _assertClassBrand(_Delegation7702PublishHook_brand, this, _buildDelegation).call(this, delegationEnvironment, transactionMeta, gasFeeToken, includeTransfer);
  const modes = [includeTransfer ? _delegation.BATCH_DEFAULT_MODE : _delegation.SINGLE_DEFAULT_MODE];
  const executions = _assertClassBrand(_Delegation7702PublishHook_brand, this, _buildExecutions).call(this, transactionMeta, gasFeeToken, includeTransfer);
  const transactionData = (0, _delegation2.encodeRedeemDelegations)({
    delegations,
    modes,
    executions
  });
  const relayRequest = {
    chainId,
    data: transactionData,
    to: delegationManagerAddress
  };
  if (!delegationAddress) {
    relayRequest.authorizationList = await _assertClassBrand(_Delegation7702PublishHook_brand, this, _buildAuthorizationList).call(this, transactionMeta, upgradeContractAddress);
  }
  log('Relay request', relayRequest);
  const {
    uuid
  } = await (0, _transactionRelay.submitRelayTransaction)(relayRequest);
  const {
    transactionHash,
    status
  } = await (0, _transactionRelay.waitForRelayResult)({
    chainId,
    uuid,
    interval: POLLING_INTERVAL_MS
  });
  if (status !== _transactionRelay.RelayStatus.Success) {
    throw new Error(`Transaction relay error - ${status}`);
  }
  return {
    transactionHash
  };
}
async function _buildDelegation(delegationEnvironment, transactionMeta, gasFeeToken, includeTransfer) {
  const unsignedDelegation = _assertClassBrand(_Delegation7702PublishHook_brand, this, _buildUnsignedDelegation).call(this, delegationEnvironment, transactionMeta, gasFeeToken, includeTransfer);
  log('Signing delegation');
  const delegationSignature = await _classPrivateFieldGet(_messenger, this).call('DelegationController:signDelegation', {
    chainId: transactionMeta.chainId,
    delegation: unsignedDelegation
  });
  log('Delegation signature', delegationSignature);
  const delegations = [[{
    ...unsignedDelegation,
    signature: delegationSignature
  }]];
  return delegations;
}
function _buildExecutions(transactionMeta, gasFeeToken, includeTransfer) {
  const {
    txParams
  } = transactionMeta;
  const {
    data,
    to,
    value
  } = txParams;
  const normalizedData = _assertClassBrand(_Delegation7702PublishHook_brand, this, _normalizeCallData).call(this, data);
  const userExecution = {
    target: to,
    value: BigInt(value ?? '0x0'),
    callData: normalizedData
  };
  if (!includeTransfer) {
    return [[userExecution]];
  }
  if (!gasFeeToken) {
    throw new Error('Selected gas fee token not found');
  }
  const transferExecution = {
    target: gasFeeToken.tokenAddress,
    value: BigInt('0x0'),
    callData: _assertClassBrand(_Delegation7702PublishHook_brand, this, _buildTokenTransferData).call(this, gasFeeToken.recipient, gasFeeToken.amount)
  };
  return [[userExecution, transferExecution]];
}
function _buildUnsignedDelegation(environment, transactionMeta, gasFeeToken, includeTransfer) {
  const caveats = _assertClassBrand(_Delegation7702PublishHook_brand, this, _buildCaveats).call(this, environment, transactionMeta, gasFeeToken, includeTransfer);
  log('Caveats', caveats);
  const delegation = (0, _delegation.createDelegation)({
    from: transactionMeta.txParams.from,
    to: _delegation2.ANY_BENEFICIARY,
    caveats
  });
  log('Delegation', delegation);
  return delegation;
}
function _buildCaveats(environment, transactionMeta, gasFeeToken, includeTransfer) {
  const caveatBuilder = (0, _delegation.createCaveatBuilder)(environment);
  const {
    txParams
  } = transactionMeta;
  const {
    to,
    value,
    data
  } = txParams;
  const normalizedData = _assertClassBrand(_Delegation7702PublishHook_brand, this, _normalizeCallData).call(this, data);
  if (includeTransfer && gasFeeToken !== undefined) {
    const {
      tokenAddress,
      recipient,
      amount
    } = gasFeeToken;

    // contract deployments can't be delegated
    if (to !== undefined) {
      caveatBuilder.addCaveat(_specificActionERC20TransferBatchBuilder.specificActionERC20TransferBatch, tokenAddress, recipient, amount, to, value ?? '0x0', normalizedData);
    }
  } else if (to !== undefined) {
    // contract deployments can't be delegated
    caveatBuilder.addCaveat(_exactExecutionBuilder.exactExecution, to, value ?? '0x0', normalizedData);
  }

  // the relay may only execute this delegation once for security reasons
  caveatBuilder.addCaveat(_limitedCallsBuilder.limitedCalls, 1);
  return caveatBuilder.build();
}
async function _buildAuthorizationList(transactionMeta, upgradeContractAddress) {
  const {
    chainId,
    txParams
  } = transactionMeta;
  const {
    from,
    nonce
  } = txParams;
  log('Including authorization as not upgraded');
  if (!upgradeContractAddress) {
    throw new Error('Upgrade contract address not found');
  }
  const authorizationSignature = await _classPrivateFieldGet(_messenger, this).call('KeyringController:signEip7702Authorization', {
    chainId: parseInt(chainId, 16),
    contractAddress: upgradeContractAddress,
    from,
    nonce: parseInt(nonce, 16)
  });
  const {
    r,
    s,
    yParity
  } = _assertClassBrand(_Delegation7702PublishHook_brand, this, _decodeAuthorizationSignature).call(this, authorizationSignature);
  log('Authorization signature', {
    authorizationSignature,
    r,
    s,
    yParity
  });
  return [{
    address: upgradeContractAddress,
    chainId,
    nonce: nonce,
    r,
    s,
    yParity
  }];
}
function _buildTokenTransferData(recipient, amount) {
  return new _abi.Interface(_metamaskEthAbis.abiERC20).encodeFunctionData('transfer', [recipient, amount]);
}
function _decodeAuthorizationSignature(signature) {
  const r = signature.slice(0, 66);
  const s = `0x${signature.slice(66, 130)}`;
  const v = parseInt(signature.slice(130, 132), 16);
  const yParity = v - 27 === 0 ? '0x' : '0x1';
  return {
    r,
    s,
    yParity
  };
}
function _normalizeCallData(data) {
  if (typeof data !== 'string' || data.length === 0) {
    return EMPTY_HEX;
  }
  const hasHexPrefix = data.slice(0, 2).toLowerCase() === '0x';
  const normalizedData = data.toLowerCase();
  const prefixed = hasHexPrefix ? `0x${normalizedData.slice(2)}` : `0x${normalizedData}`;
  const hexBody = prefixed.slice(2);
  if (hexBody.length === 0) {
    return EMPTY_HEX;
  }
  if (hexBody.length % 2 !== 0) {
    // The EVM works with byte arrays, and each byte is represented by exactly
    // two hexadecimal characters. Ensure the hex string is byte-aligned by
    // prefixing a leading zero.
    return _assertClassBrand(_Delegation7702PublishHook_brand, this, _normalizeCallData).call(this, `0x0${hexBody}`);
  }
  return prefixed;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\transaction\\hooks\\delegation-7702-publish.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\hooks\\enforce-simulation-hook.ts", {"../containers/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\containers\\util.ts","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Ctransaction%5Chooks%5Cenforce-simulation-hook.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnforceSimulationHook = void 0;
var _transactionController = require("@metamask/transaction-controller");
var _utils = require("@metamask/utils");
var _controllerUtils = require("@metamask/controller-utils");
var _util = require("../containers/util");
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
const log = (0, _utils.createProjectLogger)('enforce-simulation-hook');
var _messenger = /*#__PURE__*/new WeakMap();
var _EnforceSimulationHook_brand = /*#__PURE__*/new WeakSet();
class EnforceSimulationHook {
  constructor({
    messenger
  }) {
    _classPrivateMethodInitSpec(this, _EnforceSimulationHook_brand);
    _classPrivateFieldInitSpec(this, _messenger, void 0);
    _classPrivateFieldSet(_messenger, this, messenger);
  }
  getAfterSimulateHook() {
    return _assertClassBrand(_EnforceSimulationHook_brand, this, _hook).bind(this, {});
  }
  getBeforeSignHook() {
    return _assertClassBrand(_EnforceSimulationHook_brand, this, _hook).bind(this, {
      isFinal: true
    });
  }
}
exports.EnforceSimulationHook = EnforceSimulationHook;
async function _hook(options, request) {
  var _simulationData$token;
  const {
    transactionMeta
  } = request;
  const {
    isFinal
  } = options;
  const {
    containerTypes,
    delegationAddress,
    id: transactionId,
    origin,
    simulationData,
    txParamsOriginal
  } = transactionMeta;
  const appState = _classPrivateFieldGet(_messenger, this).call('AppStateController:getState');
  const isUserEnabled = (appState === null || appState === void 0 ? void 0 : appState.enableEnforcedSimulationsForTransactions[transactionId]) ?? (appState === null || appState === void 0 ? void 0 : appState.enableEnforcedSimulations);
  if (!false || !isUserEnabled) {
    log('Skipping as enforced simulations are disabled');
    return {
      skipSimulation: false
    };
  }
  if (containerTypes !== null && containerTypes !== void 0 && containerTypes.includes(_transactionController.TransactionContainerType.EnforcedSimulations) && !isFinal) {
    log('Skipping as simulation already enforced');
    return {};
  }
  if (!origin || origin === _controllerUtils.ORIGIN_METAMASK) {
    log('Skipping as internal transaction');
    return {
      skipSimulation: false
    };
  }
  if (!delegationAddress) {
    log('Skipping as not upgraded account');
    return {
      skipSimulation: false
    };
  }
  if (!(simulationData !== null && simulationData !== void 0 && simulationData.nativeBalanceChange) && !(simulationData !== null && simulationData !== void 0 && (_simulationData$token = simulationData.tokenBalanceChanges) !== null && _simulationData$token !== void 0 && _simulationData$token.length)) {
    log('Skipping as no simulation changes');
    return {
      skipSimulation: false
    };
  }
  if (isFinal && !txParamsOriginal) {
    log('Cannot find original transaction parameters');
    throw new Error('Original transaction parameters not found');
  }
  const newContainerTypes = [...(containerTypes ?? []), _transactionController.TransactionContainerType.EnforcedSimulations];
  const {
    updateTransaction
  } = await (0, _util.applyTransactionContainers)({
    isApproved: isFinal ?? false,
    messenger: _classPrivateFieldGet(_messenger, this),
    transactionMeta,
    types: newContainerTypes
  });
  return {
    skipSimulation: true,
    updateTransaction
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\transaction\\hooks\\enforce-simulation-hook.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\metrics.ts", {"../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/gas":"D:\\code\\v\\metamask-extension\\shared\\constants\\gas.ts","../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../shared/lib/confirmation.utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\confirmation.utils.ts","../../../../shared/lib/transactions-controller-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\transactions-controller-utils.js","../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../shared/modules/gas.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\gas.utils.js","../../../../shared/modules/metametrics":"D:\\code\\v\\metamask-extension\\shared\\modules\\metametrics.ts","../../../../shared/modules/transaction.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\transaction.utils.ts","../../../../ui/helpers/utils/metrics":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\metrics.js","../snap-keyring/metrics":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\snap-keyring\\metrics.ts","../util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js","ethereumjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\ethereumjs-util\\dist.browser\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Ctransaction%5Cmetrics.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleTransactionSubmitted = exports.handleTransactionRejected = exports.handleTransactionFailed = exports.handleTransactionDropped = exports.handleTransactionConfirmed = exports.handleTransactionApproved = exports.handleTransactionAdded = exports.handlePostTransactionBalanceUpdate = exports.createTransactionEventFragmentWithTxId = exports.METRICS_STATUS_FAILED = void 0;
var _bignumber = require("bignumber.js");
var _ethereumjsUtil = require("ethereumjs-util");
var _transactionController = require("@metamask/transaction-controller");
var _utils = require("@metamask/utils");
var _app = require("../../../../shared/constants/app");
var _gas = require("../../../../shared/constants/gas");
var _metametrics = require("../../../../shared/constants/metametrics");
var _transaction = require("../../../../shared/constants/transaction");
var _transactionsControllerUtils = require("../../../../shared/lib/transactions-controller-utils");
var _conversion = require("../../../../shared/modules/conversion.utils");
var _metametrics2 = require("../../../../shared/modules/metametrics");
var _transaction2 = require("../../../../shared/modules/transaction.utils");
var _metrics = require("../../../../ui/helpers/utils/metrics");
var _metrics2 = require("../snap-keyring/metrics");
var _confirmation = require("../../../../shared/lib/confirmation.utils");
var _gas2 = require("../../../../shared/modules/gas.utils");
var _Numeric = require("../../../../shared/modules/Numeric");
var _util = require("../util");
/* eslint-disable @typescript-eslint/naming-convention */

const log = (0, _utils.createProjectLogger)('transaction-metrics');
const METRICS_STATUS_FAILED = exports.METRICS_STATUS_FAILED = 'failed on-chain';
const CONTRACT_INTERACTION_TYPES = [_transactionController.TransactionType.bridge, _transactionController.TransactionType.bridgeApproval, _transactionController.TransactionType.contractInteraction, _transactionController.TransactionType.tokenMethodApprove, _transactionController.TransactionType.tokenMethodIncreaseAllowance, _transactionController.TransactionType.tokenMethodSafeTransferFrom, _transactionController.TransactionType.tokenMethodSetApprovalForAll, _transactionController.TransactionType.tokenMethodTransfer, _transactionController.TransactionType.tokenMethodTransferFrom, _transactionController.TransactionType.swap, _transactionController.TransactionType.swapAndSend, _transactionController.TransactionType.swapApproval];
var MetricsTransactionType = /*#__PURE__*/function (MetricsTransactionType) {
  MetricsTransactionType["swap"] = "mm_swap";
  MetricsTransactionType["bridge"] = "mm_bridge";
  return MetricsTransactionType;
}(MetricsTransactionType || {});
/**
 * This function is called when a transaction is added to the controller.
 *
 * @param transactionMetricsRequest - Contains controller actions needed to create/update/finalize event fragments
 * @param transactionEventPayload - The event payload
 * @param transactionEventPayload.transactionMeta - The transaction meta object
 */
const handleTransactionAdded = async (transactionMetricsRequest, transactionEventPayload) => {
  if (!transactionEventPayload.transactionMeta) {
    return;
  }
  const {
    properties,
    sensitiveProperties
  } = await buildEventFragmentProperties({
    transactionEventPayload,
    transactionMetricsRequest
  });
  createTransactionEventFragment({
    eventName: _transaction.TransactionMetaMetricsEvent.added,
    transactionEventPayload,
    transactionMetricsRequest,
    payload: {
      properties,
      sensitiveProperties
    }
  });
};

/**
 * This function is called when a transaction is approved by the user.
 *
 * @param transactionMetricsRequest - Contains controller actions needed to create/update/finalize event fragments
 * @param transactionEventPayload - The event payload
 * @param transactionEventPayload.transactionMeta - The transaction meta object
 */
exports.handleTransactionAdded = handleTransactionAdded;
const handleTransactionApproved = async (transactionMetricsRequest, transactionEventPayload) => {
  if (!transactionEventPayload.transactionMeta) {
    return;
  }
  await createUpdateFinalizeTransactionEventFragment({
    eventName: _transaction.TransactionMetaMetricsEvent.approved,
    transactionEventPayload,
    transactionMetricsRequest
  });
};

/**
 * This function is called when a transaction is failed.
 *
 * @param transactionMetricsRequest - Contains controller actions needed to create/update/finalize event fragments
 * @param transactionEventPayload - The event payload
 * @param transactionEventPayload.transactionMeta - The transaction meta object
 * @param transactionEventPayload.error - The error message if the transaction failed
 */
exports.handleTransactionApproved = handleTransactionApproved;
const handleTransactionFailed = async (transactionMetricsRequest, transactionEventPayload) => {
  if (!transactionEventPayload.transactionMeta) {
    return;
  }

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const extraParams = {};
  if (transactionEventPayload.error) {
    // This is a failed transaction
    extraParams.error = transactionEventPayload.error;
  }
  await createUpdateFinalizeTransactionEventFragment({
    eventName: _transaction.TransactionMetaMetricsEvent.finalized,
    extraParams,
    transactionEventPayload,
    transactionMetricsRequest
  });
};

/**
 * This function is called when a transaction is confirmed.
 *
 * @param transactionMetricsRequest - Contains controller actions needed to create/update/finalize event fragments
 * @param transactionEventPayload - The event payload
 * @param transactionEventPayload.transactionMeta - The transaction meta object
 * @param transactionEventPayload.error - The error message if the transaction failed
 */
exports.handleTransactionFailed = handleTransactionFailed;
const handleTransactionConfirmed = async (transactionMetricsRequest, transactionEventPayload) => {
  if (Object.keys(transactionEventPayload).length === 0) {
    return;
  }

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const extraParams = {};
  const transactionMeta = {
    ...transactionEventPayload
  };
  const {
    txReceipt
  } = transactionMeta;
  extraParams.gas_used = txReceipt === null || txReceipt === void 0 ? void 0 : txReceipt.gasUsed;
  extraParams.block_number = (txReceipt === null || txReceipt === void 0 ? void 0 : txReceipt.blockNumber) && (0, _conversion.hexToDecimal)(txReceipt.blockNumber);
  const {
    submittedTime,
    blockTimestamp
  } = transactionMeta;
  if (submittedTime) {
    extraParams.completion_time = getTransactionCompletionTime(submittedTime);
  }
  if (submittedTime && blockTimestamp) {
    extraParams.completion_time_onchain = getTransactionOnchainCompletionTime(submittedTime, blockTimestamp);
  }
  if ((txReceipt === null || txReceipt === void 0 ? void 0 : txReceipt.status) === '0x0') {
    extraParams.status = METRICS_STATUS_FAILED;
  }
  await createUpdateFinalizeTransactionEventFragment({
    eventName: _transaction.TransactionMetaMetricsEvent.finalized,
    extraParams,
    transactionEventPayload: {
      actionId: transactionMeta.actionId,
      transactionMeta
    },
    transactionMetricsRequest
  });
};

/**
 * This function is called when a transaction is dropped.
 *
 * @param transactionMetricsRequest - Contains controller actions needed to create/update/finalize event fragments
 * @param transactionEventPayload - The event payload
 * @param transactionEventPayload.transactionMeta - The transaction meta object
 */
exports.handleTransactionConfirmed = handleTransactionConfirmed;
const handleTransactionDropped = async (transactionMetricsRequest, transactionEventPayload) => {
  if (!transactionEventPayload.transactionMeta) {
    return;
  }
  const extraParams = {
    dropped: true
  };
  await createUpdateFinalizeTransactionEventFragment({
    eventName: _transaction.TransactionMetaMetricsEvent.finalized,
    extraParams,
    transactionEventPayload,
    transactionMetricsRequest
  });
};

/**
 * This function is called when a transaction is rejected by the user.
 *
 * @param transactionMetricsRequest - Contains controller actions needed to create/update/finalize event fragments
 * @param transactionEventPayload - The event payload
 * @param transactionEventPayload.transactionMeta - The transaction meta object
 */
exports.handleTransactionDropped = handleTransactionDropped;
const handleTransactionRejected = async (transactionMetricsRequest, transactionEventPayload) => {
  if (!transactionEventPayload.transactionMeta) {
    return;
  }
  await createUpdateFinalizeTransactionEventFragment({
    eventName: _transaction.TransactionMetaMetricsEvent.rejected,
    transactionEventPayload,
    transactionMetricsRequest
  });
};

/**
 * This function is called when a transaction is submitted to the network.
 *
 * @param transactionMetricsRequest - Contains controller actions needed to create/update/finalize event fragments
 * @param transactionEventPayload - The event payload
 * @param transactionEventPayload.transactionMeta - The transaction meta object
 */
exports.handleTransactionRejected = handleTransactionRejected;
const handleTransactionSubmitted = async (transactionMetricsRequest, transactionEventPayload) => {
  if (!transactionEventPayload.transactionMeta) {
    return;
  }
  const {
    properties,
    sensitiveProperties
  } = await buildEventFragmentProperties({
    transactionEventPayload,
    transactionMetricsRequest
  });
  createTransactionEventFragment({
    eventName: _transaction.TransactionMetaMetricsEvent.submitted,
    transactionEventPayload,
    transactionMetricsRequest,
    payload: {
      properties,
      sensitiveProperties
    }
  });
};

/**
 * UI needs this specific create function in order to be sure that event fragment exists when updating transaction gas values.
 *
 * @param transactionMetricsRequest - Contains controller actions needed to create/update/finalize event fragments
 * @param eventPayload - The event payload
 * @param eventPayload.actionId - The action id of the transaction
 * @param eventPayload.transactionId - The transaction id
 */
exports.handleTransactionSubmitted = handleTransactionSubmitted;
const createTransactionEventFragmentWithTxId = async (transactionMetricsRequest, {
  transactionId,
  actionId
}) => {
  const transactionMeta = {
    ...transactionMetricsRequest.getTransaction(transactionId),
    actionId
  };
  const {
    properties,
    sensitiveProperties
  } = await buildEventFragmentProperties({
    transactionEventPayload: {
      transactionMeta
    },
    transactionMetricsRequest
  });
  createTransactionEventFragment({
    eventName: _transaction.TransactionMetaMetricsEvent.approved,
    transactionEventPayload: {
      actionId: transactionMeta.actionId,
      transactionMeta
    },
    transactionMetricsRequest,
    payload: {
      properties,
      sensitiveProperties
    }
  });
};

/**
 * This function is called when a post transaction balance is updated.
 *
 * @param transactionMetricsRequest - Contains controller actions
 * @param transactionMetricsRequest.getParticipateInMetrics - Returns whether the user has opted into metrics
 * @param transactionMetricsRequest.trackEvent - MetaMetrics track event function
 * @param transactionMetricsRequest.getHDEntropyIndex - Returns Index of the currently selected HD Keyring
 * @param transactionEventPayload - The event payload
 * @param transactionEventPayload.transactionMeta - The updated transaction meta
 * @param transactionEventPayload.approvalTransactionMeta - The updated approval transaction meta
 */
exports.createTransactionEventFragmentWithTxId = createTransactionEventFragmentWithTxId;
const handlePostTransactionBalanceUpdate = async ({
  getParticipateInMetrics,
  trackEvent,
  getHDEntropyIndex
}, {
  transactionMeta,
  approvalTransactionMeta
}) => {
  if (getParticipateInMetrics() && transactionMeta.swapMetaData) {
    var _transactionMeta$txRe;
    if (((_transactionMeta$txRe = transactionMeta.txReceipt) === null || _transactionMeta$txRe === void 0 ? void 0 : _transactionMeta$txRe.status) === '0x0') {
      trackEvent({
        event: _metametrics.MetaMetricsEventName.SwapFailed,
        category: _metametrics.MetaMetricsEventCategory.Swaps,
        sensitiveProperties: {
          ...transactionMeta.swapMetaData
        },
        properties: {
          hd_entropy_index: getHDEntropyIndex()
        }
      });
    } else {
      var _transactionMeta$txRe2;
      const tokensReceived = (0, _transactionsControllerUtils.getSwapsTokensReceivedFromTxMeta)(transactionMeta.destinationTokenSymbol, transactionMeta, transactionMeta.destinationTokenAddress, transactionMeta.txParams.from, transactionMeta.destinationTokenDecimals, approvalTransactionMeta, transactionMeta.chainId);
      const quoteVsExecutionRatio = tokensReceived ?
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
      // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
      `${new _bignumber.BigNumber(tokensReceived, 10).div(transactionMeta.swapMetaData.token_to_amount, 10).times(100).round(2)}%` : null;
      const estimatedVsUsedGasRatio = (_transactionMeta$txRe2 = transactionMeta.txReceipt) !== null && _transactionMeta$txRe2 !== void 0 && _transactionMeta$txRe2.gasUsed && transactionMeta.swapMetaData.estimated_gas ?
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
      // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
      `${new _bignumber.BigNumber(transactionMeta.txReceipt.gasUsed, 16).div(transactionMeta.swapMetaData.estimated_gas, 10).times(100).round(2)}%` : null;
      const transactionsCost = calculateTransactionsCost(transactionMeta, approvalTransactionMeta);
      trackEvent({
        event: _metametrics.MetaMetricsEventName.SwapCompleted,
        category: _metametrics.MetaMetricsEventCategory.Swaps,
        sensitiveProperties: {
          ...transactionMeta.swapMetaData,
          token_to_amount_received: tokensReceived,
          quote_vs_executionRatio: quoteVsExecutionRatio,
          estimated_vs_used_gasRatio: estimatedVsUsedGasRatio,
          approval_gas_cost_in_eth: transactionsCost.approvalGasCostInEth,
          trade_gas_cost_in_eth: transactionsCost.tradeGasCostInEth,
          trade_and_approval_gas_cost_in_eth: transactionsCost.tradeAndApprovalGasCostInEth,
          // Firefox and Chrome have different implementations of the APIs
          // that we rely on for communication accross the app. On Chrome big
          // numbers are converted into number strings, on firefox they remain
          // Big Number objects. As such, we convert them here for both
          // browsers.
          token_to_amount: transactionMeta.swapMetaData.token_to_amount.toString(10)
        },
        properties: {
          hd_entropy_index: getHDEntropyIndex()
        }
      });
    }
  }
};
exports.handlePostTransactionBalanceUpdate = handlePostTransactionBalanceUpdate;
function calculateTransactionsCost(transactionMeta, approvalTransactionMeta) {
  var _transactionMeta$txRe3, _transactionMeta$txRe4;
  let approvalGasCost = '0x0';
  if (approvalTransactionMeta !== null && approvalTransactionMeta !== void 0 && approvalTransactionMeta.txReceipt) {
    approvalGasCost = (0, _transactionsControllerUtils.calcGasTotal)(approvalTransactionMeta.txReceipt.gasUsed, approvalTransactionMeta.txReceipt.effectiveGasPrice);
  }
  const tradeGasCost = (0, _transactionsControllerUtils.calcGasTotal)((_transactionMeta$txRe3 = transactionMeta.txReceipt) === null || _transactionMeta$txRe3 === void 0 ? void 0 : _transactionMeta$txRe3.gasUsed, (_transactionMeta$txRe4 = transactionMeta.txReceipt) === null || _transactionMeta$txRe4 === void 0 ? void 0 : _transactionMeta$txRe4.effectiveGasPrice);
  const tradeAndApprovalGasCost = new _bignumber.BigNumber(tradeGasCost, 16).plus(approvalGasCost, 16).toString(16);
  return {
    approvalGasCostInEth: Number((0, _conversion.hexWEIToDecETH)(approvalGasCost)),
    tradeGasCostInEth: Number((0, _conversion.hexWEIToDecETH)(tradeGasCost)),
    tradeAndApprovalGasCostInEth: Number((0, _conversion.hexWEIToDecETH)(tradeAndApprovalGasCost))
  };
}
function createTransactionEventFragment({
  eventName,
  transactionEventPayload: {
    transactionMeta,
    actionId
  },
  transactionMetricsRequest,
  payload
}) {
  if (hasFragment(transactionMetricsRequest.getEventFragmentById, eventName, transactionMeta) &&
  /**
   * HACK: "transaction-submitted-<id>" fragment hack
   * can continue to createEventFragment if "transaction-submitted-<id>"  submitted fragment exists
   */
  eventName !== _transaction.TransactionMetaMetricsEvent.submitted) {
    return;
  }
  const uniqueIdentifier = getUniqueId(eventName, transactionMeta.id);
  switch (eventName) {
    // When a transaction is added to the controller, we know that the user
    // will be presented with a confirmation screen. The user will then
    // either confirm or reject that transaction. Each has an associated
    // event we want to track. While we don't necessarily need an event
    // fragment to model this, having one allows us to record additional
    // properties onto the event from the UI. For example, when the user
    // edits the transactions gas params we can record that property and
    // then get analytics on the number of transactions in which gas edits
    // occur.
    case _transaction.TransactionMetaMetricsEvent.added:
      transactionMetricsRequest.createEventFragment({
        category: _metametrics.MetaMetricsEventCategory.Transactions,
        initialEvent: _transaction.TransactionMetaMetricsEvent.added,
        successEvent: _transaction.TransactionMetaMetricsEvent.approved,
        failureEvent: _transaction.TransactionMetaMetricsEvent.rejected,
        properties: payload.properties,
        sensitiveProperties: payload.sensitiveProperties,
        actionId,
        uniqueIdentifier,
        persist: true
      });
      break;
    // If for some reason an approval or rejection occurs without the added
    // fragment existing in memory, we create the added fragment but without
    // the initialEvent firing. This is to prevent possible duplication of
    // events. A good example why this might occur is if the user had
    // unapproved transactions in memory when updating to the version that
    // includes this change. A migration would have also helped here but this
    // implementation hardens against other possible bugs where a fragment
    // does not exist.
    case _transaction.TransactionMetaMetricsEvent.approved:
    case _transaction.TransactionMetaMetricsEvent.rejected:
      transactionMetricsRequest.createEventFragment({
        category: _metametrics.MetaMetricsEventCategory.Transactions,
        successEvent: _transaction.TransactionMetaMetricsEvent.approved,
        failureEvent: _transaction.TransactionMetaMetricsEvent.rejected,
        properties: payload.properties,
        sensitiveProperties: payload.sensitiveProperties,
        actionId,
        uniqueIdentifier,
        persist: true
      });
      break;
    // When a transaction is submitted it will always result in updating
    // to a finalized state (dropped, failed, confirmed) -- eventually.
    // However having a fragment started at this stage allows augmenting
    // analytics data with user interactions such as speeding up and
    // canceling the transactions. From this controllers perspective a new
    // transaction with a new id is generated for speed up and cancel
    // transactions, but from the UI we could augment the previous ID with
    // supplemental data to show user intent. Such as when they open the
    // cancel UI but don't submit. We can record that this happened and add
    // properties to the transaction event.
    case _transaction.TransactionMetaMetricsEvent.submitted:
      transactionMetricsRequest.createEventFragment({
        category: _metametrics.MetaMetricsEventCategory.Transactions,
        initialEvent: _transaction.TransactionMetaMetricsEvent.submitted,
        successEvent: _transaction.TransactionMetaMetricsEvent.finalized,
        properties: payload.properties,
        sensitiveProperties: payload.sensitiveProperties,
        actionId,
        uniqueIdentifier,
        persist: true
      });
      break;
    // If for some reason a transaction is finalized without the submitted
    // fragment existing in memory, we create the submitted fragment but
    // without the initialEvent firing. This is to prevent possible
    // duplication of events. A good example why this might occur is if th
    // user had pending transactions in memory when updating to the version
    // that includes this change. A migration would have also helped here but
    // this implementation hardens against other possible bugs where a
    // fragment does not exist.
    case _transaction.TransactionMetaMetricsEvent.finalized:
      transactionMetricsRequest.createEventFragment({
        category: _metametrics.MetaMetricsEventCategory.Transactions,
        successEvent: _transaction.TransactionMetaMetricsEvent.finalized,
        properties: payload.properties,
        sensitiveProperties: payload.sensitiveProperties,
        actionId,
        uniqueIdentifier,
        persist: true
      });
      break;
    default:
      break;
  }
}
function updateTransactionEventFragment({
  eventName,
  transactionEventPayload: {
    transactionMeta
  },
  transactionMetricsRequest,
  payload
}) {
  const uniqueId = getUniqueId(eventName, transactionMeta.id);
  switch (eventName) {
    case _transaction.TransactionMetaMetricsEvent.approved:
    case _transaction.TransactionMetaMetricsEvent.rejected:
    case _transaction.TransactionMetaMetricsEvent.finalized:
      transactionMetricsRequest.updateEventFragment(uniqueId, {
        properties: payload.properties,
        sensitiveProperties: payload.sensitiveProperties
      });
      break;
    default:
      break;
  }
}
function finalizeTransactionEventFragment({
  eventName,
  transactionMetricsRequest,
  transactionEventPayload: {
    transactionMeta
  }
}) {
  const uniqueId = getUniqueId(eventName, transactionMeta.id);
  switch (eventName) {
    case _transaction.TransactionMetaMetricsEvent.approved:
    case _transaction.TransactionMetaMetricsEvent.finalized:
      transactionMetricsRequest.finalizeEventFragment(uniqueId);
      break;
    case _transaction.TransactionMetaMetricsEvent.rejected:
      transactionMetricsRequest.finalizeEventFragment(uniqueId, {
        abandoned: true
      });
      break;
    default:
      break;
  }
}
async function createUpdateFinalizeTransactionEventFragment({
  eventName,
  transactionEventPayload,
  transactionMetricsRequest,
  extraParams = {}
}) {
  const {
    properties,
    sensitiveProperties
  } = await buildEventFragmentProperties({
    transactionEventPayload,
    transactionMetricsRequest,
    extraParams
  });
  createTransactionEventFragment({
    eventName,
    transactionEventPayload,
    transactionMetricsRequest,
    payload: {
      properties,
      sensitiveProperties
    }
  });
  updateTransactionEventFragment({
    eventName,
    transactionEventPayload,
    transactionMetricsRequest,
    payload: {
      properties,
      sensitiveProperties
    }
  });
  finalizeTransactionEventFragment({
    eventName,
    transactionEventPayload,
    transactionMetricsRequest
  });
}
function hasFragment(
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
getEventFragmentById, eventName, transactionMeta) {
  const uniqueId = getUniqueId(eventName, transactionMeta.id);
  const fragment = getEventFragmentById(uniqueId);
  return typeof fragment !== 'undefined';
}
function getUniqueId(eventName, transactionId) {
  const isFinalizedOrSubmitted = eventName === _transaction.TransactionMetaMetricsEvent.finalized || eventName === _transaction.TransactionMetaMetricsEvent.submitted;
  const uniqueIdentifier = `transaction-${isFinalizedOrSubmitted ? 'submitted' : 'added'}-${transactionId}`;
  return uniqueIdentifier;
}
async function buildEventFragmentProperties({
  transactionEventPayload: {
    transactionMeta
  },
  transactionMetricsRequest,
  extraParams = {}
}) {
  var _blockaidProperties$u;
  const {
    type,
    time,
    status,
    chainId,
    origin: referrer,
    txParams: {
      gasPrice,
      gas: gasLimit,
      maxFeePerGas,
      maxPriorityFeePerGas,
      estimateSuggested,
      estimateUsed
    },
    defaultGasEstimates,
    originalType,
    replacedById,
    customTokenAmount,
    dappProposedTokenAmount,
    currentTokenBalance,
    originalApprovalAmount,
    finalApprovalAmount,
    securityProviderResponse,
    simulationFails,
    id,
    userFeeLevel
  } = transactionMeta;
  const source = referrer === _app.ORIGIN_METAMASK ? 'user' : 'dapp';
  const gasFeeSelected = userFeeLevel === 'dappSuggested' ? 'dapp_proposed' : userFeeLevel;
  const {
    assetType,
    tokenStandard
  } = await (0, _transaction2.determineTransactionAssetType)(transactionMeta, transactionMetricsRequest.provider, transactionMetricsRequest.getTokenStandardAndDetails);
  let contractMethodName;
  if (transactionMeta.txParams.data) {
    const methodData = await transactionMetricsRequest.getMethodData(transactionMeta.txParams.data);
    contractMethodName = methodData === null || methodData === void 0 ? void 0 : methodData.name;
  }

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const gasParams = {};
  if ((0, _transaction2.isEIP1559Transaction)(transactionMeta)) {
    gasParams.max_fee_per_gas = maxFeePerGas;
    gasParams.max_priority_fee_per_gas = maxPriorityFeePerGas;
  } else {
    gasParams.gas_price = gasPrice;
    gasParams.default_estimate = _metametrics.MetaMetricsEventTransactionEstimateType.DefaultEstimate;
  }
  if (defaultGasEstimates) {
    var _transactionMeta$defa3, _transactionMeta$defa4;
    const {
      estimateType
    } = defaultGasEstimates;
    if (estimateType) {
      var _transactionMeta$defa, _transactionMeta$defa2;
      gasParams.default_estimate = estimateType === _gas.PriorityLevels.dAppSuggested ? _metametrics.MetaMetricsEventTransactionEstimateType.DappProposed : estimateType;
      let defaultMaxFeePerGas = (_transactionMeta$defa = transactionMeta.defaultGasEstimates) === null || _transactionMeta$defa === void 0 ? void 0 : _transactionMeta$defa.maxFeePerGas;
      let defaultMaxPriorityFeePerGas = (_transactionMeta$defa2 = transactionMeta.defaultGasEstimates) === null || _transactionMeta$defa2 === void 0 ? void 0 : _transactionMeta$defa2.maxPriorityFeePerGas;
      if ([_gas.GasRecommendations.low, _gas.GasRecommendations.medium, _gas.GasRecommendations.high].includes(estimateType)) {
        var _gasFeeEstimates$esti, _gasFeeEstimates$esti3;
        const {
          gasFeeEstimates
        } = await transactionMetricsRequest.getEIP1559GasFeeEstimates();
        if (gasFeeEstimates !== null && gasFeeEstimates !== void 0 && (_gasFeeEstimates$esti = gasFeeEstimates[estimateType]) !== null && _gasFeeEstimates$esti !== void 0 && _gasFeeEstimates$esti.suggestedMaxFeePerGas) {
          var _gasFeeEstimates$esti2;
          defaultMaxFeePerGas = (_gasFeeEstimates$esti2 = gasFeeEstimates[estimateType]) === null || _gasFeeEstimates$esti2 === void 0 ? void 0 : _gasFeeEstimates$esti2.suggestedMaxFeePerGas;
          gasParams.default_max_fee_per_gas = defaultMaxFeePerGas;
        }
        if (gasFeeEstimates !== null && gasFeeEstimates !== void 0 && (_gasFeeEstimates$esti3 = gasFeeEstimates[estimateType]) !== null && _gasFeeEstimates$esti3 !== void 0 && _gasFeeEstimates$esti3.suggestedMaxPriorityFeePerGas) {
          var _gasFeeEstimates$esti4;
          defaultMaxPriorityFeePerGas = (_gasFeeEstimates$esti4 = gasFeeEstimates[estimateType]) === null || _gasFeeEstimates$esti4 === void 0 ? void 0 : _gasFeeEstimates$esti4.suggestedMaxPriorityFeePerGas;
          gasParams.default_max_priority_fee_per_gas = defaultMaxPriorityFeePerGas;
        }
      }
    }
    if ((_transactionMeta$defa3 = transactionMeta.defaultGasEstimates) !== null && _transactionMeta$defa3 !== void 0 && _transactionMeta$defa3.gas) {
      gasParams.default_gas = transactionMeta.defaultGasEstimates.gas;
    }
    if ((_transactionMeta$defa4 = transactionMeta.defaultGasEstimates) !== null && _transactionMeta$defa4 !== void 0 && _transactionMeta$defa4.gasPrice) {
      gasParams.default_gas_price = transactionMeta.defaultGasEstimates.gasPrice;
    }
  }
  if (estimateSuggested) {
    gasParams.estimate_suggested = estimateSuggested;
  }
  if (estimateUsed) {
    gasParams.estimate_used = estimateUsed;
  }
  if (extraParams !== null && extraParams !== void 0 && extraParams.gas_used) {
    gasParams.gas_used = extraParams.gas_used;
  }
  const gasParamsInGwei = getGasValuesInGWEI(gasParams);
  let eip1559Version = '0';
  if (transactionMeta.txParams.maxFeePerGas) {
    eip1559Version = '2';
  }
  const contractMethodNames = {
    APPROVE: 'Approve'
  };
  let transactionApprovalAmountType;
  let transactionContractMethod;
  let transactionApprovalAmountVsProposedRatio;
  let transactionApprovalAmountVsBalanceRatio;
  let transactionContractAddress;
  let transactionContractMethod4Byte;
  const {
    transactionType,
    isContractInteraction
  } = determineTransactionTypeAndContractInteraction(type, originalType);
  if (isContractInteraction) {
    var _transactionMeta$txPa, _transactionMeta$txPa2;
    transactionContractMethod = contractMethodName;
    transactionContractAddress = (_transactionMeta$txPa = transactionMeta.txParams) === null || _transactionMeta$txPa === void 0 ? void 0 : _transactionMeta$txPa.to;
    transactionContractMethod4Byte = (_transactionMeta$txPa2 = transactionMeta.txParams) === null || _transactionMeta$txPa2 === void 0 || (_transactionMeta$txPa2 = _transactionMeta$txPa2.data) === null || _transactionMeta$txPa2 === void 0 ? void 0 : _transactionMeta$txPa2.slice(0, 10);
    if (transactionContractMethod === contractMethodNames.APPROVE && tokenStandard === _transaction.TokenStandard.ERC20) {
      if (dappProposedTokenAmount === '0' || customTokenAmount === '0') {
        transactionApprovalAmountType = _transaction.TransactionApprovalAmountType.revoke;
      } else if (customTokenAmount && customTokenAmount !== dappProposedTokenAmount) {
        transactionApprovalAmountType = _transaction.TransactionApprovalAmountType.custom;
      } else if (dappProposedTokenAmount) {
        transactionApprovalAmountType = _transaction.TransactionApprovalAmountType.dappProposed;
      }
      transactionApprovalAmountVsProposedRatio = allowanceAmountInRelationToDappProposedValue(transactionApprovalAmountType, originalApprovalAmount, finalApprovalAmount);
      transactionApprovalAmountVsBalanceRatio = allowanceAmountInRelationToTokenBalance(transactionApprovalAmountType, dappProposedTokenAmount, currentTokenBalance);
    }
  }
  const replacedTransactionMeta = transactionMetricsRequest.getTransaction(replacedById);
  const TRANSACTION_REPLACEMENT_METHODS = {
    RETRY: _transactionController.TransactionType.retry,
    CANCEL: _transactionController.TransactionType.cancel,
    SAME_NONCE: 'other'
  };
  let transactionReplaced;
  if (extraParams !== null && extraParams !== void 0 && extraParams.dropped) {
    transactionReplaced = TRANSACTION_REPLACEMENT_METHODS.SAME_NONCE;
    if ((replacedTransactionMeta === null || replacedTransactionMeta === void 0 ? void 0 : replacedTransactionMeta.type) === _transactionController.TransactionType.cancel) {
      transactionReplaced = TRANSACTION_REPLACEMENT_METHODS.CANCEL;
    } else if ((replacedTransactionMeta === null || replacedTransactionMeta === void 0 ? void 0 : replacedTransactionMeta.type) === _transactionController.TransactionType.retry) {
      transactionReplaced = TRANSACTION_REPLACEMENT_METHODS.RETRY;
    }
  }
  const uiCustomizations = [];
  let isAdvancedDetailsOpen = null;

  /** securityProviderResponse is used by the OpenSea <> Blockaid provider */
  // eslint-disable-next-line no-lonely-if
  if ((securityProviderResponse === null || securityProviderResponse === void 0 ? void 0 : securityProviderResponse.flagAsDangerous) === 1) {
    uiCustomizations.push(_metametrics.MetaMetricsEventUiCustomization.FlaggedAsMalicious);
  } else if ((securityProviderResponse === null || securityProviderResponse === void 0 ? void 0 : securityProviderResponse.flagAsDangerous) === 2) {
    uiCustomizations.push(_metametrics.MetaMetricsEventUiCustomization.FlaggedAsSafetyUnknown);
  }

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const blockaidProperties = (0, _metrics.getBlockaidMetricsProps)(transactionMeta);
  if ((blockaidProperties === null || blockaidProperties === void 0 || (_blockaidProperties$u = blockaidProperties.ui_customizations) === null || _blockaidProperties$u === void 0 ? void 0 : _blockaidProperties$u.length) > 0) {
    uiCustomizations.push(...blockaidProperties.ui_customizations);
  }
  if (simulationFails) {
    uiCustomizations.push(_metametrics.MetaMetricsEventUiCustomization.GasEstimationFailed);
  }
  const isRedesignedForTransaction = (0, _confirmation.shouldUseRedesignForTransactions)({
    transactionMetadataType: transactionMeta.type
  });
  if (isRedesignedForTransaction) {
    uiCustomizations.push(_metametrics.MetaMetricsEventUiCustomization.RedesignedConfirmation);
    isAdvancedDetailsOpen = transactionMetricsRequest.getIsConfirmationAdvancedDetailsOpen();
  }
  const smartTransactionMetricsProperties = (0, _metametrics2.getSmartTransactionMetricsProperties)(transactionMetricsRequest, transactionMeta);
  const swapAndSendMetricsProperties = (0, _metrics.getSwapAndSendMetricsProps)(transactionMeta);

  // Add Entropy Properties
  const hdEntropyProperties = {
    hd_entropy_index: transactionMetricsRequest.getHDEntropyIndex()
  };
  let accountType;
  try {
    accountType = await transactionMetricsRequest.getAccountType(transactionMetricsRequest.getSelectedAddress());
  } catch (error) {
    accountType = 'error';
    log('Error getting account type for transaction metrics:', error);
  }

  /** The transaction status property is not considered sensitive and is now included in the non-anonymous event */
  let properties = {
    chain_id: chainId,
    referrer,
    source,
    status,
    network: `${parseInt(chainId, 16)}`,
    eip_1559_version: eip1559Version,
    gas_edit_type: 'none',
    gas_edit_attempted: 'none',
    gas_estimation_failed: Boolean(simulationFails),
    account_type: accountType,
    device_model: await transactionMetricsRequest.getDeviceModel(transactionMetricsRequest.getSelectedAddress()),
    asset_type: assetType,
    token_standard: tokenStandard,
    transaction_type: transactionType,
    transaction_speed_up: type === _transactionController.TransactionType.retry,
    transaction_internal_id: id,
    gas_fee_selected: gasFeeSelected,
    ...blockaidProperties,
    // ui_customizations must come after ...blockaidProperties
    ui_customizations: uiCustomizations.length > 0 ? uiCustomizations : null,
    transaction_advanced_view: isAdvancedDetailsOpen,
    transaction_contract_method: transactionContractMethod ? [transactionContractMethod] : [],
    ...smartTransactionMetricsProperties,
    ...swapAndSendMetricsProperties,
    ...hdEntropyProperties

    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
  };
  const snapAndHardwareInfo = await (0, _metrics2.getSnapAndHardwareInfoForMetrics)(transactionMetricsRequest.getAccountType, transactionMetricsRequest.getDeviceModel, transactionMetricsRequest.getHardwareTypeForMetric, transactionMetricsRequest.snapAndHardwareMessenger);
  Object.assign(properties, snapAndHardwareInfo);
  if (transactionContractMethod === contractMethodNames.APPROVE || getMMSwapOrBridgeType(type)) {
    var _transactionMeta$asse, _transactionMeta$asse2;
    properties = {
      ...properties,
      simulation_receiving_assets_total_value: properties.simulation_receiving_assets_total_value ?? (transactionMeta === null || transactionMeta === void 0 || (_transactionMeta$asse = transactionMeta.assetsFiatValues) === null || _transactionMeta$asse === void 0 ? void 0 : _transactionMeta$asse.receiving),
      simulation_sending_assets_total_value: properties.simulation_sending_assets_total_value ?? (transactionMeta === null || transactionMeta === void 0 || (_transactionMeta$asse2 = transactionMeta.assetsFiatValues) === null || _transactionMeta$asse2 === void 0 ? void 0 : _transactionMeta$asse2.sending),
      transaction_approval_amount_type: transactionApprovalAmountType
    };
  }
  let sensitiveProperties = {
    transaction_envelope_type: (0, _transaction2.isEIP1559Transaction)(transactionMeta) ? _transactionsControllerUtils.TRANSACTION_ENVELOPE_TYPE_NAMES.FEE_MARKET : _transactionsControllerUtils.TRANSACTION_ENVELOPE_TYPE_NAMES.LEGACY,
    first_seen: time,
    gas_limit: gasLimit,
    transaction_replaced: transactionReplaced,
    transaction_contract_address: transactionContractAddress ? [transactionContractAddress] : [],
    transaction_contract_method_4byte: transactionContractMethod4Byte,
    ...extraParams,
    ...gasParamsInGwei

    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
  };
  if (transactionContractMethod === contractMethodNames.APPROVE) {
    sensitiveProperties = {
      ...sensitiveProperties,
      transaction_approval_amount_vs_balance_ratio: transactionApprovalAmountVsBalanceRatio,
      transaction_approval_amount_vs_proposed_ratio: transactionApprovalAmountVsProposedRatio
    };
  }
  await addBatchProperties(transactionMeta, transactionMetricsRequest.getMethodData, properties, sensitiveProperties);
  addGaslessProperties(transactionMeta, properties, sensitiveProperties, transactionMetricsRequest.getAccountBalance);

  // Only calculate and add domain to properties for "Transaction Submitted" and "Transaction Finalized" events
  if (status === _transactionController.TransactionStatus.submitted || status === _transactionController.TransactionStatus.confirmed) {
    // Get RPC URL from provider
    const rpcUrl = transactionMetricsRequest.getNetworkRpcUrl(transactionMeta.chainId);
    const domain = (0, _util.extractRpcDomain)(rpcUrl);
    properties.rpc_domain = domain;
  }
  return {
    properties,
    sensitiveProperties
  };
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function getGasValuesInGWEI(gasParams) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const gasValuesInGwei = {};
  for (const param in gasParams) {
    if ((0, _ethereumjsUtil.isHexString)(gasParams[param])) {
      gasValuesInGwei[param] = (0, _conversion.hexWEIToDecGWEI)(gasParams[param]);
    } else {
      gasValuesInGwei[param] = gasParams[param];
    }
  }
  return gasValuesInGwei;
}
function getTransactionCompletionTime(submittedTime) {
  return Math.round((Date.now() - submittedTime) / 1000).toString();
}

/**
 * Returns number of seconds (rounded to the hundredths) between submitted time
 * and the block timestamp.
 *
 * @param submittedTimeMs - The UNIX timestamp in milliseconds in which the
 * transaction has been submitted
 * @param blockTimestampHex - The UNIX timestamp in seconds in hexadecimal in which
 * the transaction has been confirmed in a block
 */
function getTransactionOnchainCompletionTime(submittedTimeMs, blockTimestampHex) {
  const DECIMAL_DIGITS = 2;
  const blockTimestampSeconds = Number((0, _conversion.hexToDecimal)(blockTimestampHex));
  const completionTimeSeconds = blockTimestampSeconds - submittedTimeMs / 1000;
  const completionTimeSecondsRounded = Math.round(completionTimeSeconds * 10 ** DECIMAL_DIGITS) / 10 ** DECIMAL_DIGITS;
  return completionTimeSecondsRounded.toString();
}

/**
 * The allowance amount in relation to the dapp proposed amount for specific token
 *
 * @param transactionApprovalAmountType - The transaction approval amount type
 * @param originalApprovalAmount - The original approval amount is the originally dapp proposed token amount
 * @param finalApprovalAmount - The final approval amount is the chosen amount which will be the same as the
 * originally dapp proposed token amount if the user does not edit the amount or will be a custom token amount set by the user
 */
function allowanceAmountInRelationToDappProposedValue(transactionApprovalAmountType, originalApprovalAmount, finalApprovalAmount) {
  if (transactionApprovalAmountType === _transaction.TransactionApprovalAmountType.custom && originalApprovalAmount && finalApprovalAmount) {
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    return `${new _bignumber.BigNumber(originalApprovalAmount, 10).div(finalApprovalAmount, 10).times(100).round(2)}`;
  }
  return null;
}

/**
 * The allowance amount in relation to the balance for that specific token
 *
 * @param transactionApprovalAmountType - The transaction approval amount type
 * @param dappProposedTokenAmount - The dapp proposed token amount
 * @param currentTokenBalance - The balance of the token that is being send
 */
function allowanceAmountInRelationToTokenBalance(transactionApprovalAmountType, dappProposedTokenAmount, currentTokenBalance) {
  if ((transactionApprovalAmountType === _transaction.TransactionApprovalAmountType.custom || transactionApprovalAmountType === _transaction.TransactionApprovalAmountType.dappProposed) && dappProposedTokenAmount && currentTokenBalance) {
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    return `${new _bignumber.BigNumber(dappProposedTokenAmount, 16).div(currentTokenBalance, 10).times(100).round(2)}`;
  }
  return null;
}
async function addBatchProperties(transactionMeta, getMethodData, properties, sensitiveProperties) {
  const isExternal = origin && origin !== _app.ORIGIN_METAMASK;
  const {
    delegationAddress,
    nestedTransactions,
    txParams
  } = transactionMeta;
  const {
    authorizationList
  } = txParams;
  const isBatch = Boolean(nestedTransactions === null || nestedTransactions === void 0 ? void 0 : nestedTransactions.length);
  const isUpgrade = Boolean(authorizationList === null || authorizationList === void 0 ? void 0 : authorizationList.length);
  if (isExternal) {
    properties.api_method = isBatch ? _app.MESSAGE_TYPE.WALLET_SEND_CALLS : _app.MESSAGE_TYPE.ETH_SEND_TRANSACTION;
  }
  if (isBatch) {
    properties.batch_transaction_count = nestedTransactions === null || nestedTransactions === void 0 ? void 0 : nestedTransactions.length;
    properties.batch_transaction_method = 'eip7702';
    properties.transaction_contract_method = await getNestedMethodNames(nestedTransactions ?? [], getMethodData);
    sensitiveProperties.transaction_contract_address = nestedTransactions === null || nestedTransactions === void 0 ? void 0 : nestedTransactions.filter(tx => {
      var _tx$to;
      return CONTRACT_INTERACTION_TYPES.includes(tx.type) && ((_tx$to = tx.to) === null || _tx$to === void 0 ? void 0 : _tx$to.length);
    }).map(tx => tx.to);
  }
  if (transactionMeta.status === _transactionController.TransactionStatus.rejected) {
    const {
      error
    } = transactionMeta;
    properties.eip7702_upgrade_rejection =
    // @ts-expect-error Code has string type in controller
    isUpgrade && error.code === _transaction.EIP5792ErrorCode.RejectedUpgrade;
  }
  properties.eip7702_upgrade_transaction = isUpgrade;
  sensitiveProperties.account_eip7702_upgraded = delegationAddress;
}
function addGaslessProperties(transactionMeta, properties, _sensitiveProperties, getAccountBalance) {
  var _gasFeeTokens$find;
  const {
    gasFeeTokens,
    selectedGasFeeToken
  } = transactionMeta;
  properties.gas_payment_tokens_available = gasFeeTokens === null || gasFeeTokens === void 0 ? void 0 : gasFeeTokens.map(token => token.symbol);
  properties.gas_paid_with = gasFeeTokens === null || gasFeeTokens === void 0 || (_gasFeeTokens$find = gasFeeTokens.find(token => token.tokenAddress.toLowerCase() === (selectedGasFeeToken === null || selectedGasFeeToken === void 0 ? void 0 : selectedGasFeeToken.toLowerCase()))) === null || _gasFeeTokens$find === void 0 ? void 0 : _gasFeeTokens$find.symbol;
  if ((selectedGasFeeToken === null || selectedGasFeeToken === void 0 ? void 0 : selectedGasFeeToken.toLowerCase()) === _transaction.NATIVE_TOKEN_ADDRESS) {
    properties.gas_paid_with = 'pre-funded_ETH';
  }
  properties.gas_insufficient_native_asset = isInsufficientNativeBalance(transactionMeta, getAccountBalance);
}
async function getNestedMethodNames(transactions, getMethodData) {
  const allData = transactions.filter(tx => CONTRACT_INTERACTION_TYPES.includes(tx.type) && tx.data).map(tx => tx.data);
  const results = await Promise.all(allData.map(data => getMethodData(data)));
  const names = results.map(result => result === null || result === void 0 ? void 0 : result.name).filter(name => name === null || name === void 0 ? void 0 : name.length);
  return names;
}
function isInsufficientNativeBalance(transactionMeta, getAccountBalance) {
  const {
    chainId,
    txParams
  } = transactionMeta;
  const {
    from,
    gas,
    gasPrice,
    maxFeePerGas,
    value
  } = txParams;
  const nativeBalance = getAccountBalance(from, chainId);
  const gasCost = (0, _gas2.getMaximumGasTotalInHexWei)({
    gasLimit: gas,
    gasPrice,
    maxFeePerGas
  });
  const totalCost = (0, _utils.add0x)((0, _conversion.addHexes)(gasCost, value ?? '0x0'));
  return new _Numeric.Numeric(totalCost, 16).greaterThan(new _Numeric.Numeric(nativeBalance, 16));
}
function getMMSwapOrBridgeType(type) {
  if (type === _transactionController.TransactionType.swap) {
    return MetricsTransactionType.swap;
  } else if (type === _transactionController.TransactionType.bridge) {
    return MetricsTransactionType.bridge;
  }
  return null;
}

/**
 * Determines the transaction type for metrics and whether it's a contract interaction
 *
 * @param type - The transaction type
 * @param originalType - The original transaction type (for retry transactions)
 * @returns  Object containing final type and whether it's a contract interaction
 */
function determineTransactionTypeAndContractInteraction(type, originalType) {
  const isContractInteraction = type && CONTRACT_INTERACTION_TYPES.includes(type);

  // Direct type assignments
  const directTypeMappings = [_transactionController.TransactionType.swapAndSend, _transactionController.TransactionType.cancel, _transactionController.TransactionType.deployContract, _transactionController.TransactionType.gasPayment, _transactionController.TransactionType.batch];
  if (directTypeMappings.includes(type)) {
    return {
      transactionType: type,
      isContractInteraction
    };
  }

  // Special case for retry transactions
  if (type === _transactionController.TransactionType.retry && originalType) {
    return {
      transactionType: originalType,
      isContractInteraction
    };
  }

  // Contract interaction types
  if (isContractInteraction) {
    const mmSwapOrBridgeType = getMMSwapOrBridgeType(type);
    if (mmSwapOrBridgeType) {
      // This doesn't have to be valid transaction type as it's required to be different values for metrics
      return {
        transactionType: mmSwapOrBridgeType,
        isContractInteraction: true
      };
    }
    return {
      transactionType: _transactionController.TransactionType.contractInteraction,
      isContractInteraction: true
    };
  }

  // Default fallback
  return {
    transactionType: _transactionController.TransactionType.simpleSend,
    isContractInteraction: false
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\transaction\\metrics.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\sentinel-api.ts", {"../../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../../shared/modules/fetch-with-timeout":"D:\\code\\v\\metamask-extension\\shared\\modules\\fetch-with-timeout.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Ctransaction%5Csentinel-api.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildUrl = buildUrl;
exports.getSendBundleSupportedChains = getSendBundleSupportedChains;
exports.getSentinelNetworkFlags = getSentinelNetworkFlags;
exports.isSendBundleSupported = isSendBundleSupported;
var _conversion = require("../../../../shared/modules/conversion.utils");
var _fetchWithTimeout = _interopRequireDefault(require("../../../../shared/modules/fetch-with-timeout"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const BASE_URL = 'https://tx-sentinel-{0}.api.cx.metamask.io/';
const ENDPOINT_NETWORKS = 'networks';
/**
 * Returns all network data.
 */
async function getAllSentinelNetworkFlags() {
  const url = `${buildUrl('ethereum-mainnet')}${ENDPOINT_NETWORKS}`;
  const response = await (0, _fetchWithTimeout.default)()(url);
  return response.json();
}

/**
 * Get Sentinel Network flags by chainId
 *
 * @param chainId - The chain ID to get the network flags for.
 * @returns A promise that resolves to the Sentinel network flags for the given chain ID, or undefined if not found.
 */
async function getSentinelNetworkFlags(chainId) {
  const chainIdDecimal = (0, _conversion.hexToDecimal)(chainId);
  const networks = await getAllSentinelNetworkFlags();
  return networks[chainIdDecimal];
}

/**
 * Returns api base url for a given subdomain.
 *
 * @param subdomain - The subdomain to use in the URL.
 * @returns The complete URL with the subdomain.
 */
function buildUrl(subdomain) {
  return BASE_URL.replace('{0}', subdomain);
}

/**
 * Returns true if this chain supports sendBundle feature.
 *
 * @param chainId - The chain ID to check.
 * @returns A promise that resolves to true if sendBundle is supported, false otherwise.
 */
async function isSendBundleSupported(chainId) {
  const network = await getSentinelNetworkFlags(chainId);
  if (!(network !== null && network !== void 0 && network.sendBundle)) {
    return false;
  }
  return true;
}

/**
 * Returns a map of chain IDs to whether sendBundle is supported for each chain.
 *
 * @param chainIds - The chain IDs to check.
 * @returns A map of chain IDs to their sendBundle support status.
 */
async function getSendBundleSupportedChains(chainIds) {
  const networkData = await getAllSentinelNetworkFlags();
  return chainIds.reduce((acc, chainId) => {
    const chainIdDecimal = (0, _conversion.hexToDecimal)(chainId);
    const network = networkData[chainIdDecimal];
    acc[chainId] = (network === null || network === void 0 ? void 0 : network.sendBundle) ?? false;
    return acc;
  }, {});
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\transaction\\sentinel-api.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\transaction-relay.ts", {"../../../../shared/modules/fetch-with-timeout":"D:\\code\\v\\metamask-extension\\shared\\modules\\fetch-with-timeout.ts","../../../../shared/modules/rpc.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\rpc.utils.js","./sentinel-api":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\sentinel-api.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Ctransaction%5Ctransaction-relay.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelayStatus = exports.RELAY_RPC_METHOD = void 0;
exports.isRelaySupported = isRelaySupported;
exports.submitRelayTransaction = submitRelayTransaction;
exports.waitForRelayResult = waitForRelayResult;
var _utils = require("@metamask/utils");
var _rpc = require("../../../../shared/modules/rpc.utils");
var _fetchWithTimeout = _interopRequireDefault(require("../../../../shared/modules/fetch-with-timeout"));
var _sentinelApi = require("./sentinel-api");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const log = (0, _utils.createProjectLogger)('transaction-relay');
let RelayStatus = exports.RelayStatus = /*#__PURE__*/function (RelayStatus) {
  RelayStatus["Pending"] = "PENDING";
  RelayStatus["Success"] = "VALIDATED";
  return RelayStatus;
}({});
const RELAY_RPC_METHOD = exports.RELAY_RPC_METHOD = 'eth_sendRelayTransaction';
async function submitRelayTransaction(request) {
  const {
    chainId
  } = request;
  const url = await getRelayUrl(chainId);
  if (!url) {
    throw new Error(`Chain not supported by transaction relay - ${chainId}`);
  }
  log('Request', url, request);
  const response = await (0, _rpc.jsonRpcRequest)(url, RELAY_RPC_METHOD, [request]);
  log('Response', response);
  return response;
}
async function waitForRelayResult(request) {
  const {
    chainId,
    interval,
    uuid
  } = request;
  const baseUrl = await getRelayUrl(chainId);
  if (!baseUrl) {
    throw new Error(`Chain not supported by transaction relay - ${chainId}`);
  }
  const url = `${baseUrl}smart-transactions/${uuid}`;
  return new Promise((resolve, reject) => {
    const intervalId = setInterval(async () => {
      try {
        const result = await pollResult(url);
        if (result.status !== RelayStatus.Pending) {
          clearInterval(intervalId);
          resolve(result);
        }
      } catch (error) {
        clearInterval(intervalId);
        reject(error);
      }
    }, interval);
  });
}
async function isRelaySupported(chainId) {
  return Boolean(await getRelayUrl(chainId));
}
async function pollResult(url) {
  log('Polling request', url);
  const response = await (0, _fetchWithTimeout.default)()(url);
  log('Polling response', response);
  if (!response.ok) {
    const errorBody = await response.text();
    throw new Error(`Failed to fetch relay transaction status: ${response.status} - ${errorBody}`);
  }
  const data = await response.json();
  const transaction = data === null || data === void 0 ? void 0 : data.transactions[0];
  const {
    hash: transactionHash,
    status
  } = transaction || {};
  return {
    status,
    transactionHash
  };
}
async function getRelayUrl(chainId) {
  const networkData = await (0, _sentinelApi.getSentinelNetworkFlags)(chainId);
  if (!(networkData !== null && networkData !== void 0 && networkData.relayTransactions)) {
    log('Chain is not supported', chainId);
    return undefined;
  }
  return (0, _sentinelApi.buildUrl)(networkData.network);
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\transaction\\transaction-relay.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\transaction\\util.ts", {"../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/security-provider":"D:\\code\\v\\metamask-extension\\shared\\constants\\security-provider.ts","../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../ppom/ppom-util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\ppom\\ppom-util.ts","../trust-signals/security-alerts-api":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\trust-signals\\security-alerts-api.ts","../trust-signals/trust-signals-util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\trust-signals\\trust-signals-util.ts","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","ethereumjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\ethereumjs-util\\dist.browser\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Ctransaction%5Cutil.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addDappTransaction = addDappTransaction;
exports.addTransaction = addTransaction;
exports.getTransactionById = getTransactionById;
var _keyringApi = require("@metamask/keyring-api");
var _ethereumjsUtil = require("ethereumjs-util");
var _ppomUtil = require("../ppom/ppom-util");
var _securityProvider = require("../../../../shared/constants/security-provider");
var _trace = require("../../../../shared/lib/trace");
var _app = require("../../../../shared/constants/app");
var _securityAlertsApi = require("../trust-signals/security-alerts-api");
var _trustSignalsUtil = require("../trust-signals/trust-signals-util");
async function addDappTransaction(request) {
  const {
    dappRequest
  } = request;
  const {
    id: actionId,
    method,
    origin
  } = dappRequest;
  const {
    securityAlertResponse,
    traceContext
  } = dappRequest;
  const transactionOptions = {
    actionId,
    method,
    origin,
    // This is the default behaviour but specified here for clarity
    requireApproval: true,
    securityAlertResponse
  };
  (0, _trace.endTrace)({
    name: _trace.TraceName.Middleware,
    id: actionId
  });
  const {
    waitForHash
  } = await addTransactionOrUserOperation({
    ...request,
    transactionOptions: {
      ...transactionOptions,
      traceContext
    }
  });
  const hash = await waitForHash();
  (0, _trace.endTrace)({
    name: _trace.TraceName.Transaction,
    id: actionId
  });
  return hash;
}
async function addTransaction(request) {
  await validateSecurity(request);
  const {
    transactionMeta,
    waitForHash
  } = await addTransactionOrUserOperation(request);
  if (!request.waitForSubmit) {
    waitForHash().catch(() => {
      // Not concerned with result.
    });
    return transactionMeta;
  }
  const transactionHash = await waitForHash();
  const finalTransactionMeta = getTransactionByHash(transactionHash, request.transactionController);
  return finalTransactionMeta;
}
async function addTransactionOrUserOperation(request) {
  const {
    selectedAccount
  } = request;
  const isSmartContractAccount = selectedAccount.type === _keyringApi.EthAccountType.Erc4337;
  if (isSmartContractAccount) {
    return addUserOperationWithController(request);
  }
  return addTransactionWithController(request);
}
async function addTransactionWithController(request) {
  const {
    transactionController,
    transactionOptions,
    transactionParams,
    networkClientId
  } = request;
  const {
    result,
    transactionMeta
  } = await transactionController.addTransaction(transactionParams, {
    ...transactionOptions,
    networkClientId
  });
  return {
    transactionMeta,
    waitForHash: () => result
  };
}
async function addUserOperationWithController(request) {
  var _transactionOptions$s;
  const {
    networkClientId,
    transactionController,
    transactionOptions,
    transactionParams,
    userOperationController
  } = request;
  const {
    maxFeePerGas,
    maxPriorityFeePerGas
  } = transactionParams;

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const {
    origin,
    requireApproval,
    type
  } = transactionOptions;
  const normalisedTransaction = {
    ...transactionParams,
    maxFeePerGas: (0, _ethereumjsUtil.addHexPrefix)(maxFeePerGas),
    maxPriorityFeePerGas: (0, _ethereumjsUtil.addHexPrefix)(maxPriorityFeePerGas)
  };
  const swaps = transactionOptions === null || transactionOptions === void 0 || (_transactionOptions$s = transactionOptions.swaps) === null || _transactionOptions$s === void 0 ? void 0 : _transactionOptions$s.meta;
  if (swaps !== null && swaps !== void 0 && swaps.type) {
    delete swaps.type;
  }
  const options = {
    networkClientId,
    origin,
    requireApproval,
    swaps,
    type
  };
  const result = await userOperationController.addUserOperationFromTransaction(normalisedTransaction, options);
  userOperationController.startPollingByNetworkClientId(networkClientId);
  const transactionMeta = getTransactionById(result.id, transactionController);
  return {
    transactionMeta,
    waitForHash: result.transactionHash
  };
}
function getTransactionById(transactionId, transactionController) {
  return transactionController.state.transactions.find(tx => tx.id === transactionId);
}
function getTransactionByHash(transactionHash, transactionController) {
  return transactionController.state.transactions.find(tx => tx.hash === transactionHash);
}
function scanAddressForTrustSignals(request) {
  const {
    getSecurityAlertResponse,
    addSecurityAlertResponse,
    securityAlertsEnabled,
    transactionOptions,
    transactionParams,
    chainId
  } = request;
  const {
    origin
  } = transactionOptions;
  if (origin !== _app.ORIGIN_METAMASK || !securityAlertsEnabled) {
    return;
  }
  const {
    to
  } = transactionParams;
  if (typeof to !== 'string') {
    return;
  }
  const supportedEVMChain = (0, _trustSignalsUtil.mapChainIdToSupportedEVMChain)(chainId);
  if (!supportedEVMChain) {
    return;
  }
  (0, _securityAlertsApi.scanAddressAndAddToCache)(to, getSecurityAlertResponse, addSecurityAlertResponse, supportedEVMChain).catch(error => {
    console.error('[scanAddressForTrustSignals] error scanning address for trust signals:', error);
  });
}
async function validateSecurity(request) {
  const {
    chainId,
    ppomController,
    securityAlertsEnabled,
    transactionOptions,
    transactionParams,
    updateSecurityAlertResponse,
    internalAccounts,
    getSecurityAlertsConfig
  } = request;
  scanAddressForTrustSignals(request);
  const {
    type
  } = transactionOptions;
  const typeIsExcludedFromPPOM = _securityProvider.SECURITY_PROVIDER_EXCLUDED_TRANSACTION_TYPES.includes(type);
  if (!securityAlertsEnabled || typeIsExcludedFromPPOM) {
    return;
  }
  if (internalAccounts.some(({
    address
  }) => {
    var _transactionParams$to;
    return address.toLowerCase() === ((_transactionParams$to = transactionParams.to) === null || _transactionParams$to === void 0 ? void 0 : _transactionParams$to.toLowerCase());
  })) {
    return;
  }
  try {
    const {
      from,
      to,
      value,
      data
    } = transactionParams;
    const {
      actionId,
      origin
    } = transactionOptions;
    const ppomRequest = {
      method: 'eth_sendTransaction',
      id: actionId ?? '',
      origin: origin ?? '',
      params: [{
        from,
        to: to ?? '',
        value: value ?? '',
        data: data ?? ''
      }],
      jsonrpc: '2.0'
    };
    const securityAlertId = (0, _ppomUtil.generateSecurityAlertId)();

    // Intentionally not awaited to avoid blocking the confirmation process while the validation occurs.
    (0, _ppomUtil.validateRequestWithPPOM)({
      ppomController,
      request: ppomRequest,
      securityAlertId,
      chainId,
      updateSecurityAlertResponse,
      getSecurityAlertsConfig
    });
    const securityAlertResponseLoading = {
      ..._securityProvider.LOADING_SECURITY_ALERT_RESPONSE,
      securityAlertId
    };
    request.transactionOptions.securityAlertResponse = securityAlertResponseLoading;
  } catch (error) {
    (0, _ppomUtil.handlePPOMError)(error, 'Error validating JSON RPC using PPOM: ');
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\transaction\\util.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\trust-signals\\security-alerts-api.ts", {"../../../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../../../shared/modules/fetch-with-timeout":"D:\\code\\v\\metamask-extension\\shared\\modules\\fetch-with-timeout.ts","./types":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\trust-signals\\types.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Ctrust-signals%5Csecurity-alerts-api.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scanAddress = scanAddress;
exports.scanAddressAndAddToCache = scanAddressAndAddToCache;
var _time = require("../../../../shared/constants/time");
var _fetchWithTimeout = _interopRequireDefault(require("../../../../shared/modules/fetch-with-timeout"));
var _types = require("./types");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const TIMEOUT = 5 * _time.SECOND;
const ENDPOINT_ADDRESS_SCAN = 'address/evm/scan';
async function scanAddress(chain, address) {
  const baseUrl = "https://security-alerts.api.cx.metamask.io";
  if (!baseUrl) {
    throw new Error('SECURITY_ALERTS_API_URL is not set');
  }
  const endpoint = `${baseUrl}/${ENDPOINT_ADDRESS_SCAN}`;
  const body = {
    chain,
    address
  };
  const response = await (0, _fetchWithTimeout.default)(TIMEOUT)(endpoint, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json'
    },
    body: JSON.stringify(body)
  });
  const data = await response.json();
  return data;
}

/**
 * Scans an address for security alerts, using cached response if available,
 * otherwise making a new API call and caching the result.
 *
 * @param address - The address to scan for security alerts
 * @param getAddressSecurityAlertResponse - Function to retrieve cached security alert response for an address
 * @param addAddressSecurityAlertResponse - Function to add a new security alert response to the cache
 * @param chainId - The chainId that the address exists on
 * @returns Promise that resolves to the security scan response containing result type and label
 */
async function scanAddressAndAddToCache(address, getAddressSecurityAlertResponse, addAddressSecurityAlertResponse, chainId) {
  const cachedResponse = getAddressSecurityAlertResponse(address);
  if (cachedResponse) {
    return cachedResponse;
  }
  const loadingResponse = {
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    result_type: _types.ResultType.Loading,
    label: ''
  };
  addAddressSecurityAlertResponse(address, loadingResponse);
  try {
    const result = await scanAddress(chainId, address);
    addAddressSecurityAlertResponse(address, result);
    return result;
  } catch (error) {
    const errorResponse = {
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      result_type: _types.ResultType.ErrorResult,
      label: ''
    };
    addAddressSecurityAlertResponse(address, errorResponse);
    throw error;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\trust-signals\\security-alerts-api.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\trust-signals\\trust-signals-middleware.ts", {"../../../../shared/modules/transaction.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\transaction.utils.ts","../ppom/security-alerts-api":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\ppom\\security-alerts-api.ts","./security-alerts-api":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\trust-signals\\security-alerts-api.ts","./trust-signals-util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\trust-signals\\trust-signals-util.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Ctrust-signals%5Ctrust-signals-middleware.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTrustSignalsMiddleware = createTrustSignalsMiddleware;
var _transaction = require("../../../../shared/modules/transaction.utils");
var _securityAlertsApi = require("../ppom/security-alerts-api");
var _securityAlertsApi2 = require("./security-alerts-api");
var _trustSignalsUtil = require("./trust-signals-util");
function createTrustSignalsMiddleware(networkController, appStateController, phishingController, preferencesController, getPermittedAccounts) {
  return async (req, _res, next) => {
    try {
      if (!(0, _trustSignalsUtil.isSecurityAlertsEnabledByUser)(preferencesController) || !(0, _securityAlertsApi.isSecurityAlertsAPIEnabled)()) {
        return;
      }
      if ((0, _trustSignalsUtil.isEthSendTransaction)(req)) {
        handleEthSendTransaction(req, appStateController, networkController);
        scanUrl(req, phishingController);
      } else if ((0, _trustSignalsUtil.isEthSignTypedData)(req)) {
        handleEthSignTypedData(req, appStateController, networkController);
        scanUrl(req, phishingController);
      } else if ((0, _trustSignalsUtil.isConnected)(req, getPermittedAccounts)) {
        scanUrl(req, phishingController);
      } else if ((0, _trustSignalsUtil.connectScreenHasBeenPrompted)(req)) {
        scanUrl(req, phishingController);
      }
    } catch (error) {
      console.error('[createTrustSignalsMiddleware] error: ', error);
    } finally {
      next();
    }
  };
}
function scanUrl(req, phishingController) {
  if (req.origin) {
    phishingController.scanUrl(req.origin).catch(error => {
      console.error('[createTrustSignalsMiddleware] error:', error);
    });
  }
}
function handleEthSendTransaction(req, appStateController, networkController) {
  if (!(0, _trustSignalsUtil.hasValidTransactionParams)(req)) {
    return;
  }
  const {
    to
  } = req.params[0];
  let chainId;
  try {
    chainId = (0, _trustSignalsUtil.getChainId)(networkController);
  } catch (error) {
    console.error('[createTrustSignalsMiddleware] error getting chainId:', error);
    return;
  }
  if (!chainId) {
    return;
  }
  (0, _securityAlertsApi2.scanAddressAndAddToCache)(to, appStateController.getAddressSecurityAlertResponse, appStateController.addAddressSecurityAlertResponse, chainId).catch(error => {
    console.error('[createTrustSignalsMiddleware] error scanning address for transaction:', error);
  });
}
function handleEthSignTypedData(req, appStateController, networkController) {
  var _typedDataMessage$dom;
  if (!(0, _trustSignalsUtil.hasValidTypedDataParams)(req)) {
    return;
  }
  const typedDataMessage = (0, _transaction.parseTypedDataMessage)(typeof req.params[1] === 'string' ? req.params[1] : JSON.stringify(req.params[1]));
  const verifyingContract = (_typedDataMessage$dom = typedDataMessage.domain) === null || _typedDataMessage$dom === void 0 ? void 0 : _typedDataMessage$dom.verifyingContract;
  if (!verifyingContract) {
    return;
  }
  let chainId;
  try {
    chainId = (0, _trustSignalsUtil.getChainId)(networkController);
  } catch (error) {
    console.error('[createTrustSignalsMiddleware] error getting chainId:', error);
    return;
  }
  if (!chainId) {
    return;
  }
  (0, _securityAlertsApi2.scanAddressAndAddToCache)(verifyingContract, appStateController.getAddressSecurityAlertResponse, appStateController.addAddressSecurityAlertResponse, chainId).catch(error => {
    console.error('[createTrustSignalsMiddleware] error scanning address for signature:', error);
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\trust-signals\\trust-signals-middleware.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\trust-signals\\trust-signals-util.ts", {"../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","./types":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\trust-signals\\types.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5Ctrust-signals%5Ctrust-signals-util.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connectScreenHasBeenPrompted = connectScreenHasBeenPrompted;
exports.getChainId = getChainId;
exports.hasValidTransactionParams = hasValidTransactionParams;
exports.hasValidTypedDataParams = hasValidTypedDataParams;
exports.isConnected = isConnected;
exports.isEthSendTransaction = isEthSendTransaction;
exports.isEthSignTypedData = isEthSignTypedData;
exports.isSecurityAlertsEnabledByUser = isSecurityAlertsEnabledByUser;
exports.mapChainIdToSupportedEVMChain = mapChainIdToSupportedEVMChain;
var _network = require("../../../../shared/constants/network");
var _networks = require("../../../../shared/modules/selectors/networks");
var _app = require("../../../../shared/constants/app");
var _types = require("./types");
// isSecurityAlertsEnabledByUser is a function that checks if the security alerts are enabled in the preferences controller.
function isSecurityAlertsEnabledByUser(preferencesController) {
  const {
    securityAlertsEnabled
  } = preferencesController.state;
  return securityAlertsEnabled;
}
function isEthSendTransaction(req) {
  return req.method === _app.MESSAGE_TYPE.ETH_SEND_TRANSACTION;
}
function hasValidTransactionParams(req) {
  if (!('params' in req) || !req.params) {
    return false;
  }
  if (!Array.isArray(req.params) || req.params.length === 0) {
    return false;
  }
  const firstParam = req.params[0];
  return typeof firstParam === 'object' && firstParam !== null && 'to' in firstParam;
}
function isEthSignTypedData(req) {
  return req.method === _app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA || req.method === _app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V1 || req.method === _app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V3 || req.method === _app.MESSAGE_TYPE.ETH_SIGN_TYPED_DATA_V4;
}
function isConnected(req, getPermittedAccounts) {
  if (!req.origin || req.method !== _app.MESSAGE_TYPE.ETH_ACCOUNTS) {
    return false;
  }
  const permittedAccounts = getPermittedAccounts(req.origin);
  return Array.isArray(permittedAccounts) && permittedAccounts.length > 0;
}
function connectScreenHasBeenPrompted(req) {
  return req.method === _app.MESSAGE_TYPE.ETH_REQUEST_ACCOUNTS || req.method === _app.MESSAGE_TYPE.WALLET_REQUEST_PERMISSIONS;
}
function hasValidTypedDataParams(req) {
  if (!('params' in req) || !req.params) {
    return false;
  }
  if (!Array.isArray(req.params) || req.params.length < 2) {
    return false;
  }
  return req.params[1] !== undefined && req.params[1] !== null;
}
function getChainId(networkController) {
  var _getProviderConfig;
  const chainId = (_getProviderConfig = (0, _networks.getProviderConfig)({
    metamask: networkController.state
  })) === null || _getProviderConfig === void 0 ? void 0 : _getProviderConfig.chainId;
  if (!chainId) {
    throw new Error('Chain ID not found');
  }
  return mapChainIdToSupportedEVMChain(chainId);
}
const CHAIN_IDS_LOWERCASED = {
  [_network.CHAIN_IDS.ARBITRUM.toLowerCase()]: _types.SupportedEVMChain.Arbitrum,
  [_network.CHAIN_IDS.AVALANCHE.toLowerCase()]: _types.SupportedEVMChain.Avalanche,
  [_network.CHAIN_IDS.BASE.toLowerCase()]: _types.SupportedEVMChain.Base,
  [_network.CHAIN_IDS.BASE_SEPOLIA.toLowerCase()]: _types.SupportedEVMChain.BaseSepolia,
  [_network.CHAIN_IDS.BSC.toLowerCase()]: _types.SupportedEVMChain.Bsc,
  [_network.CHAIN_IDS.MAINNET.toLowerCase()]: _types.SupportedEVMChain.Ethereum,
  [_network.CHAIN_IDS.OPTIMISM.toLowerCase()]: _types.SupportedEVMChain.Optimism,
  [_network.CHAIN_IDS.POLYGON.toLowerCase()]: _types.SupportedEVMChain.Polygon,
  [_network.CHAIN_IDS.ZKSYNC_ERA.toLowerCase()]: _types.SupportedEVMChain.Zksync,
  [_network.CHAIN_IDS.ZK_SYNC_ERA_TESTNET.toLowerCase()]: _types.SupportedEVMChain.ZksyncSepolia,
  '0x76adf1': _types.SupportedEVMChain.Zora,
  [_network.CHAIN_IDS.LINEA_MAINNET.toLowerCase()]: _types.SupportedEVMChain.Linea,
  [_network.CHAIN_IDS.BLAST.toLowerCase()]: _types.SupportedEVMChain.Blast,
  [_network.CHAIN_IDS.SCROLL.toLowerCase()]: _types.SupportedEVMChain.Scroll,
  [_network.CHAIN_IDS.SEPOLIA.toLowerCase()]: _types.SupportedEVMChain.EthereumSepolia,
  '0x27bc86aa': _types.SupportedEVMChain.Degen,
  [_network.CHAIN_IDS.AVALANCHE_TESTNET.toLowerCase()]: _types.SupportedEVMChain.AvalancheFuji,
  '0x343b': _types.SupportedEVMChain.ImmutableZkevm,
  '0x34a1': _types.SupportedEVMChain.ImmutableZkevmTestnet,
  [_network.CHAIN_IDS.GNOSIS.toLowerCase()]: _types.SupportedEVMChain.Gnosis,
  '0x1e0': _types.SupportedEVMChain.Worldchain,
  '0x79a': _types.SupportedEVMChain.SoneiumMinato,
  '0x7e4': _types.SupportedEVMChain.Ronin,
  [_network.CHAIN_IDS.APECHAIN_MAINNET.toLowerCase()]: _types.SupportedEVMChain.ApeChain,
  '0x849ea': _types.SupportedEVMChain.ZeroNetwork,
  [_network.CHAIN_IDS.BERACHAIN.toLowerCase()]: _types.SupportedEVMChain.Berachain,
  '0x138c5': _types.SupportedEVMChain.BerachainBartio,
  [_network.CHAIN_IDS.INK.toLowerCase()]: _types.SupportedEVMChain.Ink,
  [_network.CHAIN_IDS.INK_SEPOLIA.toLowerCase()]: _types.SupportedEVMChain.InkSepolia,
  '0xab5': _types.SupportedEVMChain.Abstract,
  '0x2b74': _types.SupportedEVMChain.AbstractTestnet,
  '0x74c': _types.SupportedEVMChain.Soneium,
  [_network.CHAIN_IDS.UNICHAIN.toLowerCase()]: _types.SupportedEVMChain.Unichain,
  [_network.CHAIN_IDS.SEI.toLowerCase()]: _types.SupportedEVMChain.Sei,
  [_network.CHAIN_IDS.FLOW.toLowerCase()]: _types.SupportedEVMChain.FlowEvm
};
function mapChainIdToSupportedEVMChain(chainId) {
  if (typeof chainId !== 'string' || !chainId) {
    return undefined;
  }
  return CHAIN_IDS_LOWERCASED[chainId.toLowerCase()];
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\trust-signals\\trust-signals-util.ts",}]],[],{})

//# sourceMappingURL=data:application/json;charset=utf8;base64,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