LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\127.ts", {"../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","uri-js":"D:\\code\\v\\metamask-extension\\node_modules\\uri-js\\dist\\es5\\uri.all.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C127.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
var URI = _interopRequireWildcard(require("uri-js"));
var _network = require("../../../shared/constants/network");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Note: This is the library the network controller uses for URL
// validity / equality. Using here to ensure we match its validations.

const version = exports.version = 127;

/**
 * This migration converts the network controller's
 * `networkConfigurations` to a new field `networkConfigurationsByChainId`.
 *
 * Built-in Infura network configurations are now represented in this state,
 * where they weren't before. These Infura configurations are merged with the user's
 * custom configurations.  Then all configurations are grouped by chain id,
 * and merged to produce one network configuration per chain id.
 *
 * The `SelectedNetworkController` is also migrated, so that dapp domains
 * point to the new default RPC endpoint for the chain they were on.
 *
 * The `NetworkOrderController` is also migrated, which manages
 * the user's drag + drop preference order for the network menu.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  var _Object$values$flatMa;
  if (!(0, _utils.hasProperty)(state, 'NetworkController')) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`state.NetworkController is not defined`));
    return state;
  } else if (!(0, _utils.isObject)(state.NetworkController)) {
    var _global$sentry2, _global$sentry2$captu;
    (_global$sentry2 = global.sentry) === null || _global$sentry2 === void 0 || (_global$sentry2$captu = _global$sentry2.captureException) === null || _global$sentry2$captu === void 0 || _global$sentry2$captu.call(_global$sentry2, new Error(`typeof state.NetworkController is ${typeof state.NetworkController}`));
    return state;
  } else if (!(0, _utils.hasProperty)(state, 'TransactionController')) {
    var _global$sentry3, _global$sentry3$captu;
    (_global$sentry3 = global.sentry) === null || _global$sentry3 === void 0 || (_global$sentry3$captu = _global$sentry3.captureException) === null || _global$sentry3$captu === void 0 || _global$sentry3$captu.call(_global$sentry3, new Error(`state.TransactionController is not defined`));
    return state;
  } else if (!(0, _utils.isObject)(state.TransactionController)) {
    var _global$sentry4, _global$sentry4$captu;
    (_global$sentry4 = global.sentry) === null || _global$sentry4 === void 0 || (_global$sentry4$captu = _global$sentry4.captureException) === null || _global$sentry4$captu === void 0 || _global$sentry4$captu.call(_global$sentry4, new Error(`typeof state.TransactionController is ${typeof state.TransactionController}`));
    return state;
  }
  const networkState = state.NetworkController;

  // Get the existing custom network configurations
  let networkConfigurations = (0, _utils.isObject)(networkState.networkConfigurations) ? Object.values(networkState.networkConfigurations) : [];

  // Prepend the built-in Infura network configurations,
  // since they are now included in the network controller state
  networkConfigurations = [{
    type: 'infura',
    id: 'mainnet',
    chainId: '0x1',
    ticker: 'ETH',
    nickname: _network.MAINNET_DISPLAY_NAME,
    rpcUrl: 'https://mainnet.infura.io/v3/{infuraProjectId}',
    rpcPrefs: {
      blockExplorerUrl: 'https://etherscan.io'
    }
  }, {
    type: 'infura',
    id: 'sepolia',
    chainId: '0xaa36a7',
    ticker: 'SepoliaETH',
    nickname: _network.SEPOLIA_DISPLAY_NAME,
    rpcUrl: 'https://sepolia.infura.io/v3/{infuraProjectId}',
    rpcPrefs: {
      blockExplorerUrl: 'https://sepolia.etherscan.io'
    }
  }, {
    type: 'infura',
    id: 'linea-sepolia',
    chainId: '0xe705',
    ticker: 'LineaETH',
    nickname: _network.LINEA_SEPOLIA_DISPLAY_NAME,
    rpcUrl: 'https://linea-sepolia.infura.io/v3/{infuraProjectId}',
    rpcPrefs: {
      blockExplorerUrl: 'https://sepolia.lineascan.build'
    }
  }, {
    type: 'infura',
    id: 'linea-mainnet',
    chainId: '0xe708',
    ticker: 'ETH',
    nickname: _network.LINEA_MAINNET_DISPLAY_NAME,
    rpcUrl: 'https://linea-mainnet.infura.io/v3/{infuraProjectId}',
    rpcPrefs: {
      blockExplorerUrl: 'https://lineascan.build'
    }
  }, ...networkConfigurations];

  // Group the network configurations by by chain id, producing
  // a mapping from chain id to an array of network configurations
  const networkConfigurationArraysByChainId = networkConfigurations.reduce((acc, networkConfiguration) => {
    if ((0, _utils.isObject)(networkConfiguration) && typeof networkConfiguration.chainId === 'string') {
      var _networkConfiguration;
      (acc[_networkConfiguration = networkConfiguration.chainId] ?? (acc[_networkConfiguration] = [])).push(networkConfiguration);
    }
    return acc;
  }, {});

  // Get transaction history in reverse chronological order to help with tie breaks
  const transactions = Array.isArray(state.TransactionController.transactions) ? state.TransactionController.transactions.filter(tx => (0, _utils.isObject)(tx) && typeof tx.time === 'number' && typeof tx.networkClientId === 'string').sort((a, b) => b.time - a.time) : [];

  // For each chain id, merge the array of network configurations
  const networkConfigurationsByChainId = Object.entries(networkConfigurationArraysByChainId).reduce((acc, [chainId, networks]) => {
    var _tieBreaker3, _networks$find, _tieBreaker4, _networks$find2;
    //
    // Calculate the tie breaker network, whose values will be preferred
    let tieBreaker;

    // If one of the networks is the globally selected network, use that
    tieBreaker = networks.find(network => network.id === networkState.selectedNetworkClientId);

    // Otherwise use the network that was most recently transacted on
    if (!tieBreaker) {
      transactions.filter(tx => tx.chainId === chainId).some(tx => tieBreaker = networks.find(network => network.id === tx.networkClientId));
    }

    // If no transactions were found for the chain id, fall back
    // to an arbitrary custom network that is not built in infura
    if (!tieBreaker) {
      tieBreaker = networks.find(network => network.type !== 'infura');
    }

    // Calculate the unique set of valid rpc endpoints for this chain id
    const rpcEndpoints = networks.reduce((endpoints, network) => {
      if (network.id && network.rpcUrl && typeof network.rpcUrl === 'string' && isValidUrl(network.rpcUrl)) {
        // Check if there's a different duplicate that's also the selected
        // network. If so, it will be the preferred one we'll take.
        const duplicateAndSelected = networkConfigurations.some(otherNetwork => (0, _utils.isObject)(otherNetwork) && typeof otherNetwork.rpcUrl === 'string' && typeof network.rpcUrl === 'string' && otherNetwork.id !== network.id &&
        // A different endpoint
        URI.equal(otherNetwork.rpcUrl, network.rpcUrl) &&
        // With the same URL
        otherNetwork.id === networkState.selectedNetworkClientId // That's currently selected
        );

        // Check if there's a duplicate that we've already processed. If none of
        // the duplicates are the selected network, we'll take the first one seen.
        const duplicateAlreadyAdded = [
        // Chains we've already proccessed
        ...Object.values(acc).flatMap(n => (0, _utils.isObject)(n) ? n.rpcEndpoints : []),
        // Or the current chain we're processing
        ...endpoints].some(existingEndpoint => (0, _utils.isObject)(existingEndpoint) && typeof existingEndpoint.url === 'string' && typeof network.rpcUrl === 'string' && URI.equal(existingEndpoint.url, network.rpcUrl));
        if (!duplicateAndSelected && !duplicateAlreadyAdded) {
          // The endpoint is unique and valid, so add it to the list
          endpoints.push({
            networkClientId: network.id,
            url: network.rpcUrl,
            type: network.type === 'infura' ? 'infura' : 'custom',
            ...(network.type !== 'infura' && typeof network.nickname === 'string' &&
            // The old network name becomes the endpoint name
            network.nickname && {
              name: network.nickname
            })
          });
        }
      }
      return endpoints;
    }, []);

    // If there were no valid unique endpoints, then omit the network
    // configuration for this chain id. The network controller requires
    // configurations to have at least 1 endpoint.
    if (rpcEndpoints.length === 0) {
      return acc;
    }

    // Use the tie breaker network as the default rpc endpoint
    const defaultRpcEndpointIndex = Math.max(rpcEndpoints.findIndex(endpoint => {
      var _tieBreaker;
      return endpoint.networkClientId === ((_tieBreaker = tieBreaker) === null || _tieBreaker === void 0 ? void 0 : _tieBreaker.id);
    }),
    // Or arbitrarily default to the first endpoint if we don't have a tie breaker
    0);

    // Calculate the unique array of non-empty block explorer urls
    const blockExplorerUrls = [...networks.reduce((urls, network) => {
      if ((0, _utils.isObject)(network.rpcPrefs) && typeof network.rpcPrefs.blockExplorerUrl === 'string' && network.rpcPrefs.blockExplorerUrl) {
        urls.add(network.rpcPrefs.blockExplorerUrl);
      }
      return urls;
    }, new Set())];

    // Use the tie breaker network as the default block explorer, if it has one
    const defaultBlockExplorerUrlIndex = blockExplorerUrls.length === 0 ? undefined : Math.max(blockExplorerUrls.findIndex(url => {
      var _tieBreaker2;
      return (0, _utils.isObject)((_tieBreaker2 = tieBreaker) === null || _tieBreaker2 === void 0 ? void 0 : _tieBreaker2.rpcPrefs) && url === tieBreaker.rpcPrefs.blockExplorerUrl;
    }),
    // Or arbitrarily default to the first url
    0);

    // Use the cononical network name and currency, if we have constants for them.
    // Otherwise prefer the tie breaker's name + currency, if it defines them.
    // Otherwise fall back to the name + currency from arbitrary networks that define them.
    const name = _network.NETWORK_TO_NAME_MAP[chainId] ?? ((_tieBreaker3 = tieBreaker) === null || _tieBreaker3 === void 0 ? void 0 : _tieBreaker3.nickname) ?? ((_networks$find = networks.find(n => n.nickname)) === null || _networks$find === void 0 ? void 0 : _networks$find.nickname);
    const nativeCurrency = _network.CHAIN_ID_TO_CURRENCY_SYMBOL_MAP[chainId] ?? ((_tieBreaker4 = tieBreaker) === null || _tieBreaker4 === void 0 ? void 0 : _tieBreaker4.ticker) ?? ((_networks$find2 = networks.find(n => n.ticker)) === null || _networks$find2 === void 0 ? void 0 : _networks$find2.ticker);
    acc[chainId] = {
      chainId,
      rpcEndpoints,
      defaultRpcEndpointIndex,
      blockExplorerUrls,
      ...(defaultBlockExplorerUrlIndex !== undefined && {
        defaultBlockExplorerUrlIndex
      }),
      name,
      nativeCurrency
    };
    return acc;
  }, {});

  // Given a network client id, returns the chain id it used to point to
  const networkClientIdToChainId = networkClientId => {
    const networkConfiguration = networkConfigurations.find(n => (0, _utils.isObject)(n) && n.id === networkClientId);
    return (0, _utils.isObject)(networkConfiguration) && typeof (networkConfiguration === null || networkConfiguration === void 0 ? void 0 : networkConfiguration.chainId) === 'string' ? networkConfiguration === null || networkConfiguration === void 0 ? void 0 : networkConfiguration.chainId : undefined;
  };

  // Ensure that selectedNetworkClientId points to
  // some endpoint of some network configuration.
  let selectedNetworkClientId = (_Object$values$flatMa = Object.values(networkConfigurationsByChainId).flatMap(n => (0, _utils.isObject)(n) && Array.isArray(n.rpcEndpoints) ? n.rpcEndpoints : []).find(e => e.networkClientId === networkState.selectedNetworkClientId)) === null || _Object$values$flatMa === void 0 ? void 0 : _Object$values$flatMa.networkClientId;

  // It may not, if it's endpoint was not well formed.
  if (!selectedNetworkClientId) {
    //
    // In that case, try to fallback to the default endpoint for the same chain
    const chainId = networkClientIdToChainId(networkState.selectedNetworkClientId);

    // Or mainnet, if the entire chain had to be omitted due to invalid URLs
    const networkConfiguration = networkConfigurationsByChainId[chainId ?? '0x1'];
    selectedNetworkClientId = (0, _utils.isObject)(networkConfiguration) && Array.isArray(networkConfiguration.rpcEndpoints) && typeof networkConfiguration.defaultRpcEndpointIndex === 'number' ? networkConfiguration.rpcEndpoints[networkConfiguration.defaultRpcEndpointIndex].networkClientId : 'mainnet';
  }

  // Redirect domains in the selected network controller to
  // point to the default RPC endpoint for the corresponding chain
  if ((0, _utils.hasProperty)(state, 'SelectedNetworkController') && (0, _utils.isObject)(state.SelectedNetworkController) && (0, _utils.hasProperty)(state.SelectedNetworkController, 'domains') && (0, _utils.isObject)(state.SelectedNetworkController.domains)) {
    for (const [domain, networkClientId] of Object.entries(state.SelectedNetworkController.domains)) {
      let newNetworkClientId;

      // Fetch the chain id associated with the domain's network client
      const chainId = networkClientIdToChainId(networkClientId);
      if (chainId) {
        // Fetch the default rpc endpoint associated with that chain id
        const networkConfiguration = networkConfigurationsByChainId[chainId];
        if ((0, _utils.isObject)(networkConfiguration) && Array.isArray(networkConfiguration.rpcEndpoints) && typeof networkConfiguration.defaultRpcEndpointIndex === 'number') {
          newNetworkClientId = networkConfiguration.rpcEndpoints[networkConfiguration.defaultRpcEndpointIndex].networkClientId;
        }
      }

      // Point the domain to the chain's default rpc endpoint, or remove the
      // entry if the whole chain had to be deleted due to duplicates/invalidity.
      if (newNetworkClientId) {
        state.SelectedNetworkController.domains[domain] = newNetworkClientId;
      } else {
        delete state.SelectedNetworkController.domains[domain];
      }
    }
  }
  state.NetworkController = {
    selectedNetworkClientId,
    networkConfigurationsByChainId,
    networksMetadata: networkState.networksMetadata ?? {}
  };

  // Set `showMultiRpcModal` based on whether there are any networks with multiple rpc endpoints
  if ((0, _utils.hasProperty)(state, 'PreferencesController') && (0, _utils.isObject)(state.PreferencesController) && (0, _utils.hasProperty)(state.PreferencesController, 'preferences') && (0, _utils.isObject)(state.PreferencesController.preferences)) {
    state.PreferencesController.preferences.showMultiRpcModal = Object.values(networkConfigurationsByChainId).some(networkConfiguration => (0, _utils.isObject)(networkConfiguration) && Array.isArray(networkConfiguration.rpcEndpoints) && networkConfiguration.rpcEndpoints.length > 1);
  }

  // Migrate the user's drag + drop preference order for the network menu
  if ((0, _utils.hasProperty)(state, 'NetworkOrderController') && (0, _utils.isObject)(state.NetworkOrderController) && Array.isArray(state.NetworkOrderController.orderedNetworkList)) {
    // Dedupe the list by chain id, and remove `networkRpcUrl`
    // since it's no longer needed to distinguish networks
    state.NetworkOrderController.orderedNetworkList = [...new Set(state.NetworkOrderController.orderedNetworkList.map(network => network.networkId))].map(networkId => ({
      networkId
    }));
  }
  return state;
}

// Matches network controller validation
function isValidUrl(url) {
  const uri = URI.parse(url);
  return uri.error === undefined && (uri.scheme === 'http' || uri.scheme === 'https');
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\127.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\128.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C128.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 128;

/**
 * This migration removes `useNativeCurrencyAsPrimaryCurrency` from preferences in PreferencesController.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if ((0, _utils.hasProperty)(state, 'PreferencesController') && (0, _utils.isObject)(state.PreferencesController) && (0, _utils.isObject)(state.PreferencesController.preferences)) {
    delete state.PreferencesController.preferences.useNativeCurrencyAsPrimaryCurrency;
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\128.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\129.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C129.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 129;

/**
 * This migration adds `shouldShowAggregatedBalancePopover` to preferences in PreferencesController and set it to true when its undefined.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if ((0, _utils.hasProperty)(state, 'PreferencesController') && (0, _utils.isObject)(state.PreferencesController) && (0, _utils.isObject)(state.PreferencesController.preferences)) {
    if (state.PreferencesController.preferences.shouldShowAggregatedBalancePopover === undefined) {
      state.PreferencesController.preferences.shouldShowAggregatedBalancePopover = true;
    }
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\129.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\130.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C130.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 130;
/**
 * This migration adds a tokenSortConfig to the user's preferences
 *
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if ((0, _utils.hasProperty)(state, 'PreferencesController') && (0, _utils.isObject)(state.PreferencesController) && (0, _utils.hasProperty)(state.PreferencesController, 'preferences') && (0, _utils.isObject)(state.PreferencesController.preferences) && !state.PreferencesController.preferences.tokenSortConfig) {
    state.PreferencesController.preferences.tokenSortConfig = {
      key: 'tokenFiatAmount',
      order: 'dsc',
      sortCallback: 'stringNumeric'
    };
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\130.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\131.1.ts", {"../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","@metamask/network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C131.1.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _networkController = require("@metamask/network-controller");
var _lodash = require("lodash");
var _network = require("../../../shared/constants/network");
const version = exports.version = 131.1;
const BASE_CHAIN_ID = '0x2105';

/**
 * Replace all occurrences of "https://mainnet.base.org" with
 * "https://base-mainnet.infura.io/v3/${infuraProjectId}" in the Base network configuration,
 * if the user already relies on at least one Infura RPC endpoint.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  versionedData.data = transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if ((0, _utils.hasProperty)(state, 'NetworkController') && (0, _utils.isObject)(state.NetworkController) && (0, _utils.hasProperty)(state.NetworkController, 'networkConfigurationsByChainId') && (0, _utils.isObject)(state.NetworkController.networkConfigurationsByChainId)) {
    const {
      networkConfigurationsByChainId
    } = state.NetworkController;

    // Check if at least one network uses an Infura RPC endpoint, excluding testnets
    const usesInfura = Object.entries(networkConfigurationsByChainId).filter(([chainId]) => ![..._network.infuraChainIdsTestNets, _network.CHAIN_IDS.LINEA_MAINNET].includes(chainId)).some(([, networkConfig]) => {
      var _networkConfig$rpcEnd;
      if (!(0, _utils.isObject)(networkConfig) || !Array.isArray(networkConfig.rpcEndpoints) || typeof networkConfig.defaultRpcEndpointIndex !== 'number') {
        return false;
      }

      // Get the default RPC endpoint used by the network
      const defaultRpcEndpoint = networkConfig === null || networkConfig === void 0 || (_networkConfig$rpcEnd = networkConfig.rpcEndpoints) === null || _networkConfig$rpcEnd === void 0 ? void 0 : _networkConfig$rpcEnd[networkConfig === null || networkConfig === void 0 ? void 0 : networkConfig.defaultRpcEndpointIndex];
      if (!(0, _utils.isObject)(defaultRpcEndpoint) || typeof defaultRpcEndpoint.url !== 'string') {
        return false;
      }
      try {
        const urlHost = new URL(defaultRpcEndpoint.url).host;
        return defaultRpcEndpoint.type === _networkController.RpcEndpointType.Infura || _network.allowedInfuraHosts.includes(urlHost);
      } catch {
        return false;
      }
    });
    if (!usesInfura) {
      // If no Infura endpoints are used, return the state unchanged
      return state;
    }

    // Check for Base network configuration (chainId 8453 / 0x2105)
    const baseNetworkConfig = networkConfigurationsByChainId[BASE_CHAIN_ID];
    if ((0, _utils.isObject)(baseNetworkConfig)) {
      const {
        rpcEndpoints
      } = baseNetworkConfig;
      if (Array.isArray(rpcEndpoints)) {
        // Find the first occurrence of "https://mainnet.base.org"
        const index = rpcEndpoints.findIndex(endpoint => (0, _utils.isObject)(endpoint) && endpoint.url === 'https://mainnet.base.org');
        if (index !== -1) {
          // Replace the URL with the new Infura URL
          rpcEndpoints[index] = {
            ...rpcEndpoints[index],
            url: `https://base-mainnet.infura.io/v3/${_network.infuraProjectId}`
          };

          // Update the configuration
          networkConfigurationsByChainId[BASE_CHAIN_ID] = {
            ...baseNetworkConfig,
            rpcEndpoints
          };
          return {
            ...state,
            NetworkController: {
              ...state.NetworkController,
              networkConfigurationsByChainId
            }
          };
        }
      }
    }
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\131.1.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\131.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C131.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
var _loglevel = _interopRequireDefault(require("loglevel"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const version = exports.version = 131;

/**
 * Fix AccountsController state corruption, where the `selectedAccount` state is set to an invalid
 * ID.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if (!(0, _utils.hasProperty)(state, 'AccountsController')) {
    return;
  }
  const accountsControllerState = state.AccountsController;
  if (!(0, _lodash.isObject)(accountsControllerState)) {
    var _global$sentry;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || _global$sentry.captureException(new Error(`Migration ${version}: Invalid AccountsController state of type '${typeof accountsControllerState}'`));
    return;
  } else if (!(0, _utils.hasProperty)(accountsControllerState, 'internalAccounts')) {
    var _global$sentry2;
    (_global$sentry2 = global.sentry) === null || _global$sentry2 === void 0 || _global$sentry2.captureException(new Error(`Migration ${version}: Invalid AccountsController state, missing internalAccounts`));
    return;
  } else if (!(0, _lodash.isObject)(accountsControllerState.internalAccounts)) {
    var _global$sentry3;
    (_global$sentry3 = global.sentry) === null || _global$sentry3 === void 0 || _global$sentry3.captureException(new Error(`Migration ${version}: Invalid AccountsController internalAccounts state of type '${typeof accountsControllerState.internalAccounts}'`));
    return;
  } else if (!(0, _utils.hasProperty)(accountsControllerState.internalAccounts, 'selectedAccount')) {
    var _global$sentry4;
    (_global$sentry4 = global.sentry) === null || _global$sentry4 === void 0 || _global$sentry4.captureException(new Error(`Migration ${version}: Invalid AccountsController internalAccounts state, missing selectedAccount`));
    return;
  } else if (typeof accountsControllerState.internalAccounts.selectedAccount !== 'string') {
    var _global$sentry5;
    (_global$sentry5 = global.sentry) === null || _global$sentry5 === void 0 || _global$sentry5.captureException(new Error(`Migration ${version}: Invalid AccountsController internalAccounts.selectedAccount state of type '${typeof accountsControllerState.internalAccounts.selectedAccount}'`));
    return;
  } else if (!(0, _utils.hasProperty)(accountsControllerState.internalAccounts, 'accounts')) {
    var _global$sentry6;
    (_global$sentry6 = global.sentry) === null || _global$sentry6 === void 0 || _global$sentry6.captureException(new Error(`Migration ${version}: Invalid AccountsController internalAccounts state, missing accounts`));
    return;
  } else if (!(0, _lodash.isObject)(accountsControllerState.internalAccounts.accounts)) {
    var _global$sentry7;
    (_global$sentry7 = global.sentry) === null || _global$sentry7 === void 0 || _global$sentry7.captureException(new Error(`Migration ${version}: Invalid AccountsController internalAccounts.accounts state of type '${typeof accountsControllerState.internalAccounts.accounts}'`));
    return;
  }
  if (Object.keys(accountsControllerState.internalAccounts.accounts).length === 0) {
    // In this case since there aren't any accounts, we set the selected account to the default state to unblock the extension.
    accountsControllerState.internalAccounts.selectedAccount = '';
    return;
  } else if (accountsControllerState.internalAccounts.selectedAccount === '') {
    _loglevel.default.warn(`Migration ${version}: Skipping, no selected account set`);
    return;
  }

  // Safe to use index 0, we already check for the length before.
  const firstAccount = Object.values(accountsControllerState.internalAccounts.accounts)[0];
  if (!(0, _lodash.isObject)(firstAccount)) {
    var _global$sentry8;
    (_global$sentry8 = global.sentry) === null || _global$sentry8 === void 0 || _global$sentry8.captureException(new Error(`Migration ${version}: Invalid AccountsController internalAccounts.accounts state, entry found of type '${typeof firstAccount}'`));
    return;
  } else if (!(0, _utils.hasProperty)(firstAccount, 'id')) {
    var _global$sentry9;
    (_global$sentry9 = global.sentry) === null || _global$sentry9 === void 0 || _global$sentry9.captureException(new Error(`Migration ${version}: Invalid AccountsController internalAccounts.accounts state, entry found that is missing an id`));
    return;
  } else if (typeof firstAccount.id !== 'string') {
    var _global$sentry0;
    (_global$sentry0 = global.sentry) === null || _global$sentry0 === void 0 || _global$sentry0.captureException(new Error(`Migration ${version}: Invalid AccountsController internalAccounts.accounts state, entry found with an id of type '${typeof firstAccount.id}'`));
    return;
  }

  // If the currently selected account ID is not on the `accounts` object, then
  // we fallback to first account of the wallet.
  if (!(0, _utils.hasProperty)(accountsControllerState.internalAccounts.accounts, accountsControllerState.internalAccounts.selectedAccount)) {
    accountsControllerState.internalAccounts.selectedAccount = firstAccount.id;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\131.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\132.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C132.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 132;

/**
 * This migration sets `redesignedTransactionsEnabled` as true by default in preferences in PreferencesController.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  var _state$PreferencesCon;
  if (!(0, _utils.isObject)(state === null || state === void 0 ? void 0 : state.PreferencesController)) {
    return state;
  }
  if (!(0, _utils.isObject)((_state$PreferencesCon = state.PreferencesController) === null || _state$PreferencesCon === void 0 ? void 0 : _state$PreferencesCon.preferences)) {
    state.PreferencesController = {
      ...state.PreferencesController,
      preferences: {}
    };
  }
  const preferencesControllerState = state.PreferencesController;
  const preferences = preferencesControllerState.preferences;

  // `redesignedTransactionsEnabled` was previously set to `false` by
  // default in `124.ts`
  preferences.redesignedTransactionsEnabled = true;
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\132.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\133.1.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C133.1.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 133.1;

/**
 * Removes tokens with `decimals === null` from `allTokens`, `allDetectedTokens`, `tokens`, and `detectedTokens`.
 * Captures exceptions for invalid states using Sentry and logs tokens with `decimals === null`.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to disk.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}

/**
 * Transforms the TokensController state to remove tokens with `decimals === null`.
 *
 * @param state - The persisted MetaMask state.
 */
function transformState(state) {
  if (!(0, _utils.hasProperty)(state, 'TokensController')) {
    return;
  }
  const tokensControllerState = state.TokensController;
  if (!(0, _utils.isObject)(tokensControllerState)) {
    var _global$sentry;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || _global$sentry.captureException(new Error(`Migration ${version}: Invalid TokensController state of type '${typeof tokensControllerState}'`));
    return;
  }

  // Validate and transform `allTokens`
  if ((0, _utils.hasProperty)(tokensControllerState, 'allTokens')) {
    if ((0, _utils.isObject)(tokensControllerState.allTokens)) {
      tokensControllerState.allTokens = transformTokenCollection(tokensControllerState.allTokens, 'allTokens');
    } else {
      var _global$sentry2;
      (_global$sentry2 = global.sentry) === null || _global$sentry2 === void 0 || _global$sentry2.captureException(new Error(`Migration ${version}: Invalid allTokens state of type '${typeof tokensControllerState.allTokens}'`));
    }
  }

  // Validate and transform `allDetectedTokens`
  if ((0, _utils.hasProperty)(tokensControllerState, 'allDetectedTokens')) {
    if ((0, _utils.isObject)(tokensControllerState.allDetectedTokens)) {
      tokensControllerState.allDetectedTokens = transformTokenCollection(tokensControllerState.allDetectedTokens, 'allDetectedTokens');
    } else {
      var _global$sentry3;
      (_global$sentry3 = global.sentry) === null || _global$sentry3 === void 0 || _global$sentry3.captureException(new Error(`Migration ${version}: Invalid allDetectedTokens state of type '${typeof tokensControllerState.allDetectedTokens}'`));
    }
  }

  // Transform `tokens` array
  if ((0, _utils.hasProperty)(tokensControllerState, 'tokens') && Array.isArray(tokensControllerState.tokens)) {
    tokensControllerState.tokens = tokensControllerState.tokens.filter(token => {
      if ((0, _utils.isObject)(token) && (0, _utils.hasProperty)(token, 'decimals') && token.decimals === null && (0, _utils.hasProperty)(token, 'address')) {
        var _global$sentry4;
        (_global$sentry4 = global.sentry) === null || _global$sentry4 === void 0 || _global$sentry4.captureMessage(
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
        // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
        `Migration ${version}: Removed token with decimals === null in tokens. Address: ${token.address}`);
        return false;
      }
      return true;
    });
  } else if ((0, _utils.hasProperty)(tokensControllerState, 'tokens')) {
    var _global$sentry5;
    (_global$sentry5 = global.sentry) === null || _global$sentry5 === void 0 || _global$sentry5.captureException(new Error(`Migration ${version}: Invalid tokens state of type '${typeof tokensControllerState.tokens}'`));
  }

  // Transform `detectedTokens` array
  if ((0, _utils.hasProperty)(tokensControllerState, 'detectedTokens') && Array.isArray(tokensControllerState.detectedTokens)) {
    tokensControllerState.detectedTokens = tokensControllerState.detectedTokens.filter(token => {
      if ((0, _utils.isObject)(token) && (0, _utils.hasProperty)(token, 'decimals') && token.decimals === null && (0, _utils.hasProperty)(token, 'address')) {
        var _global$sentry6;
        (_global$sentry6 = global.sentry) === null || _global$sentry6 === void 0 || _global$sentry6.captureMessage(
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
        // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
        `Migration ${version}: Removed token with decimals === null in detectedTokens. Address: ${token.address}`);
        return false;
      }
      return true;
    });
  } else if ((0, _utils.hasProperty)(tokensControllerState, 'detectedTokens')) {
    var _global$sentry7;
    (_global$sentry7 = global.sentry) === null || _global$sentry7 === void 0 || _global$sentry7.captureException(new Error(`Migration ${version}: Invalid detectedTokens state of type '${typeof tokensControllerState.detectedTokens}'`));
  }
}

/**
 * Removes tokens with `decimals === null` from a token collection and logs their addresses.
 *
 * @param tokenCollection - The token collection to transform.
 * @param propertyName - The name of the property being transformed (for logging purposes).
 * @returns The updated token collection.
 */
function transformTokenCollection(tokenCollection, propertyName) {
  const updatedState = {};
  for (const [chainId, accounts] of Object.entries(tokenCollection)) {
    if ((0, _utils.isObject)(accounts)) {
      const updatedTokensAccounts = {};
      for (const [account, tokens] of Object.entries(accounts)) {
        if (Array.isArray(tokens)) {
          // Filter tokens and log those with `decimals === null`
          const filteredTokens = tokens.filter(token => {
            if ((0, _utils.isObject)(token) && (0, _utils.hasProperty)(token, 'decimals') && token.decimals === null && (0, _utils.hasProperty)(token, 'address')) {
              var _global$sentry8;
              (_global$sentry8 = global.sentry) === null || _global$sentry8 === void 0 || _global$sentry8.captureMessage(
              // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
              // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
              `Migration ${version}: Removed token with decimals === null in ${propertyName}. Address: ${token.address}`);
              return false; // Exclude token
            }
            return (0, _utils.isObject)(token) && (0, _utils.hasProperty)(token, 'decimals') && token.decimals !== null;
          });
          updatedTokensAccounts[account] = filteredTokens;
        }
      }
      updatedState[chainId] = updatedTokensAccounts;
    }
  }
  return updatedState;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\133.1.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\133.2.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C133.2.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 133.2;

/**
 * This migration removes tokens on mainnet with the
 * zero address, since this is not a valid erc20 token.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to disk.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if (!(0, _utils.hasProperty)(state, 'TokensController') || !(0, _utils.isObject)(state.TokensController) || !(0, _utils.isObject)(state.TokensController.allTokens)) {
    return;
  }
  const chainIds = ['0x1'];
  for (const chainId of chainIds) {
    const allTokensOnChain = state.TokensController.allTokens[chainId];
    if ((0, _utils.isObject)(allTokensOnChain)) {
      for (const [account, tokens] of Object.entries(allTokensOnChain)) {
        if (Array.isArray(tokens)) {
          allTokensOnChain[account] = tokens.filter(token => (token === null || token === void 0 ? void 0 : token.address) !== '0x0000000000000000000000000000000000000000');
        }
      }
    }
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\133.2.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\133.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C133.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 133;

/**
 * This migration removes the notification controller from state. Previously used for
 * snap notifications, it is no longer needed now that snap notifications will live in the
 * notification services controller.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}

/**
 * Remove the notification controller from state (and any persisted notifications).
 *
 * @param state - The persisted MetaMask state, keyed by controller.
 */
function transformState(state) {
  // we're removing the NotificationController in favor of the NotificationServicesController
  if ((0, _utils.hasProperty)(state, 'NotificationController')) {
    delete state.NotificationController;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\133.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\134.1.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C134.1.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 134.1;

/**
 * This migration attempts to reset `TokensController.tokens` to the list of tokens
 * found in `TokensController.allTokens[currentChainId][selectedAccount]`. The
 * `currentChainId` is determined by matching the `selectedNetworkClientId` to a
 * chain's RPC endpoints in `networkConfigurationsByChainId`.
 *
 * If any step fails (missing or invalid state), the migration is skipped, and
 * the original state is returned as-is (after logging an error to Sentry).
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to disk.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  versionedData.data = transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if (!(0, _utils.hasProperty)(state, 'AccountsController')) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`Migration ${version}: Missing AccountsController.`));
    return state;
  }
  const accountsControllerState = state.AccountsController;
  if (!(0, _utils.isObject)(accountsControllerState)) {
    var _global$sentry2, _global$sentry2$captu;
    (_global$sentry2 = global.sentry) === null || _global$sentry2 === void 0 || (_global$sentry2$captu = _global$sentry2.captureException) === null || _global$sentry2$captu === void 0 || _global$sentry2$captu.call(_global$sentry2, new Error(`Migration ${version}: AccountsController is type '${typeof accountsControllerState}', expected object.`));
    return state;
  }
  if (!(0, _utils.hasProperty)(accountsControllerState, 'internalAccounts') || !(0, _utils.isObject)(accountsControllerState.internalAccounts)) {
    var _global$sentry3, _global$sentry3$captu;
    (_global$sentry3 = global.sentry) === null || _global$sentry3 === void 0 || (_global$sentry3$captu = _global$sentry3.captureException) === null || _global$sentry3$captu === void 0 || _global$sentry3$captu.call(_global$sentry3, new Error(`Migration ${version}: Missing or invalid AccountsController.internalAccounts.`));
    return state;
  }
  const {
    internalAccounts
  } = accountsControllerState;
  if (!(0, _utils.hasProperty)(internalAccounts, 'selectedAccount') || typeof internalAccounts.selectedAccount !== 'string' || internalAccounts.selectedAccount === '') {
    var _global$sentry4, _global$sentry4$captu;
    (_global$sentry4 = global.sentry) === null || _global$sentry4 === void 0 || (_global$sentry4$captu = _global$sentry4.captureException) === null || _global$sentry4$captu === void 0 || _global$sentry4$captu.call(_global$sentry4, new Error(`Migration ${version}: Invalid or missing selectedAccount.`));
    return state;
  }

  // NEW: Extract the selected account's address from internalAccounts.accounts
  if (!(0, _utils.hasProperty)(internalAccounts, 'accounts') || !(0, _utils.isObject)(internalAccounts.accounts)) {
    var _global$sentry5, _global$sentry5$captu;
    (_global$sentry5 = global.sentry) === null || _global$sentry5 === void 0 || (_global$sentry5$captu = _global$sentry5.captureException) === null || _global$sentry5$captu === void 0 || _global$sentry5$captu.call(_global$sentry5, new Error(`Migration ${version}: Missing or invalid internalAccounts.accounts.`));
    return state;
  }
  const {
    accounts
  } = internalAccounts;
  const selectedAccountKey = internalAccounts.selectedAccount;
  if (!(0, _utils.hasProperty)(accounts, selectedAccountKey) || !(0, _utils.isObject)(accounts[selectedAccountKey])) {
    var _global$sentry6, _global$sentry6$captu;
    (_global$sentry6 = global.sentry) === null || _global$sentry6 === void 0 || (_global$sentry6$captu = _global$sentry6.captureException) === null || _global$sentry6$captu === void 0 || _global$sentry6$captu.call(_global$sentry6, new Error(`Migration ${version}: Selected account entry not found in internalAccounts.accounts.`));
    return state;
  }
  const selectedAccountEntry = accounts[selectedAccountKey];
  if (!(0, _utils.hasProperty)(selectedAccountEntry, 'address') || typeof selectedAccountEntry.address !== 'string' || selectedAccountEntry.address === '') {
    var _global$sentry7, _global$sentry7$captu;
    (_global$sentry7 = global.sentry) === null || _global$sentry7 === void 0 || (_global$sentry7$captu = _global$sentry7.captureException) === null || _global$sentry7$captu === void 0 || _global$sentry7$captu.call(_global$sentry7, new Error(`Migration ${version}: Invalid or missing address in selected account entry.`));
    return state;
  }
  const selectedAccountAddress = selectedAccountEntry.address;
  if (!(0, _utils.hasProperty)(state, 'NetworkController')) {
    var _global$sentry8, _global$sentry8$captu;
    (_global$sentry8 = global.sentry) === null || _global$sentry8 === void 0 || (_global$sentry8$captu = _global$sentry8.captureException) === null || _global$sentry8$captu === void 0 || _global$sentry8$captu.call(_global$sentry8, new Error(`Migration ${version}: Missing NetworkController.`));
    return state;
  }
  const networkControllerState = state.NetworkController;
  if (!(0, _utils.isObject)(networkControllerState)) {
    var _global$sentry9, _global$sentry9$captu;
    (_global$sentry9 = global.sentry) === null || _global$sentry9 === void 0 || (_global$sentry9$captu = _global$sentry9.captureException) === null || _global$sentry9$captu === void 0 || _global$sentry9$captu.call(_global$sentry9, new Error(`Migration ${version}: NetworkController is type '${typeof networkControllerState}', expected object.`));
    return state;
  }
  if (!(0, _utils.hasProperty)(networkControllerState, 'selectedNetworkClientId') || typeof networkControllerState.selectedNetworkClientId !== 'string' || !networkControllerState.selectedNetworkClientId) {
    var _global$sentry0, _global$sentry0$captu;
    (_global$sentry0 = global.sentry) === null || _global$sentry0 === void 0 || (_global$sentry0$captu = _global$sentry0.captureException) === null || _global$sentry0$captu === void 0 || _global$sentry0$captu.call(_global$sentry0, new Error(`Migration ${version}: Invalid or missing selectedNetworkClientId.`));
    return state;
  }
  const {
    selectedNetworkClientId
  } = networkControllerState;
  if (!(0, _utils.hasProperty)(networkControllerState, 'networkConfigurationsByChainId') || !(0, _utils.isObject)(networkControllerState.networkConfigurationsByChainId)) {
    var _global$sentry1, _global$sentry1$captu;
    (_global$sentry1 = global.sentry) === null || _global$sentry1 === void 0 || (_global$sentry1$captu = _global$sentry1.captureException) === null || _global$sentry1$captu === void 0 || _global$sentry1$captu.call(_global$sentry1, new Error(`Migration ${version}: Missing or invalid networkConfigurationsByChainId.`));
    return state;
  }
  const {
    networkConfigurationsByChainId
  } = networkControllerState;
  const currentChainId = getChainIdForNetworkClientId(networkConfigurationsByChainId, selectedNetworkClientId);
  if (!currentChainId) {
    var _global$sentry10, _global$sentry10$capt;
    (_global$sentry10 = global.sentry) === null || _global$sentry10 === void 0 || (_global$sentry10$capt = _global$sentry10.captureException) === null || _global$sentry10$capt === void 0 || _global$sentry10$capt.call(_global$sentry10, new Error(`Migration ${version}: Could not find chainId for networkClientId '${selectedNetworkClientId}'.`));
    return state;
  }
  if (!(0, _utils.hasProperty)(state, 'TokensController')) {
    var _global$sentry11, _global$sentry11$capt;
    (_global$sentry11 = global.sentry) === null || _global$sentry11 === void 0 || (_global$sentry11$capt = _global$sentry11.captureException) === null || _global$sentry11$capt === void 0 || _global$sentry11$capt.call(_global$sentry11, new Error(`Migration ${version}: Missing TokensController.`));
    return state;
  }
  const tokensControllerState = state.TokensController;
  if (!(0, _utils.isObject)(tokensControllerState)) {
    var _global$sentry12, _global$sentry12$capt;
    (_global$sentry12 = global.sentry) === null || _global$sentry12 === void 0 || (_global$sentry12$capt = _global$sentry12.captureException) === null || _global$sentry12$capt === void 0 || _global$sentry12$capt.call(_global$sentry12, new Error(`Migration ${version}: TokensController is type '${typeof tokensControllerState}', expected object.`));
    return state;
  }
  if (!(0, _utils.hasProperty)(tokensControllerState, 'allTokens') || !(0, _utils.isObject)(tokensControllerState.allTokens)) {
    var _global$sentry13, _global$sentry13$capt;
    (_global$sentry13 = global.sentry) === null || _global$sentry13 === void 0 || (_global$sentry13$capt = _global$sentry13.captureException) === null || _global$sentry13$capt === void 0 || _global$sentry13$capt.call(_global$sentry13, new Error(`Migration ${version}: Missing or invalid TokensController.allTokens.`));
    return state;
  }
  const {
    tokens
  } = tokensControllerState;
  const {
    allTokens
  } = tokensControllerState;
  const allTokensForChain = allTokens[currentChainId];
  if (Array.isArray(tokens) && tokens.length > 0 && !(0, _utils.isObject)(allTokensForChain)) {
    var _global$sentry14, _global$sentry14$capt;
    (_global$sentry14 = global.sentry) === null || _global$sentry14 === void 0 || (_global$sentry14$capt = _global$sentry14.captureException) === null || _global$sentry14$capt === void 0 || _global$sentry14$capt.call(_global$sentry14, new Error(`Migration ${version}: tokens is not an empty array, but allTokensForChain is not an object.`));
    return state;
  }
  if (!(0, _utils.isObject)(allTokensForChain)) {
    return state;
  }
  const accountTokens = allTokensForChain[selectedAccountAddress];
  if (!Array.isArray(accountTokens)) {
    return state;
  }
  tokensControllerState.tokens = accountTokens;
  return state;
}
function getChainIdForNetworkClientId(networkConfigurationsByChainId, networkClientId) {
  var _global$sentry15, _global$sentry15$capt;
  for (const [chainId, networkConfiguration] of Object.entries(networkConfigurationsByChainId)) {
    if (Array.isArray(networkConfiguration.rpcEndpoints)) {
      for (const endpoint of networkConfiguration.rpcEndpoints) {
        if (endpoint.networkClientId === networkClientId) {
          return chainId;
        }
      }
    }
  }
  (_global$sentry15 = global.sentry) === null || _global$sentry15 === void 0 || (_global$sentry15$capt = _global$sentry15.captureException) === null || _global$sentry15$capt === void 0 || _global$sentry15$capt.call(_global$sentry15, new Error(`Migration ${version}: No chainId found for "${networkClientId}".`));
  return undefined;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\134.1.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\134.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C134.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 134;

/**
 * This migration removes `usedNetworks` from `AppStateController` state.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if ((0, _utils.hasProperty)(state, 'AppStateController') && (0, _utils.isObject)(state.AppStateController) && (0, _utils.hasProperty)(state.AppStateController, 'usedNetworks')) {
    console.log('Removing usedNetworks from AppStateController');
    delete state.AppStateController.usedNetworks;
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\134.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\135.ts", {"../../../shared/lib/manifestFlags":"D:\\code\\v\\metamask-extension\\shared\\lib\\manifestFlags.ts","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C135.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
var _transactionController = require("@metamask/transaction-controller");
var _manifestFlags = require("../../../shared/lib/manifestFlags");
const version = exports.version = 135;
function transformState(state) {
  var _manifestFlags$testin, _PreferencesControlle;
  // Check if smart transactions migration should be disabled
  const manifestFlags = (0, _manifestFlags.getManifestFlags)();
  if (((_manifestFlags$testin = manifestFlags.testing) === null || _manifestFlags$testin === void 0 ? void 0 : _manifestFlags$testin.disableSmartTransactionsOverride) === true) {
    // Skip the stx override if the flag is enabled
    return state;
  }
  if (!(0, _utils.hasProperty)(state, 'PreferencesController') || !(0, _utils.isObject)(state.PreferencesController)) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`Invalid PreferencesController state: ${typeof state.PreferencesController}`));
    return state;
  }
  const {
    PreferencesController
  } = state;
  const currentOptInStatus = (_PreferencesControlle = PreferencesController.preferences) === null || _PreferencesControlle === void 0 ? void 0 : _PreferencesControlle.smartTransactionsOptInStatus;
  if (currentOptInStatus === undefined || currentOptInStatus === false && !hasExistingSmartTransactions(state)) {
    state.PreferencesController.preferences = {
      ...state.PreferencesController.preferences,
      smartTransactionsOptInStatus: true,
      smartTransactionsMigrationApplied: true
    };
  } else {
    state.PreferencesController.preferences = {
      ...state.PreferencesController.preferences,
      smartTransactionsMigrationApplied: false // Always set it, but false for existing users
    };
  }
  return state;
}
function hasExistingSmartTransactions(state) {
  var _state$SmartTransacti;
  const smartTransactions = state === null || state === void 0 || (_state$SmartTransacti = state.SmartTransactionsController) === null || _state$SmartTransacti === void 0 || (_state$SmartTransacti = _state$SmartTransacti.smartTransactionsState) === null || _state$SmartTransacti === void 0 ? void 0 : _state$SmartTransacti.smartTransactions;
  if (!(0, _utils.isObject)(smartTransactions)) {
    return false;
  }
  return (smartTransactions[_transactionController.CHAIN_IDS.MAINNET] || []).length > 0;
}
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\135.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\136.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C136.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 136;
/**
 * This migration removes the useRequestQueue preference from the user's preferences
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if ((0, _utils.hasProperty)(state, 'PreferencesController') && (0, _utils.isObject)(state.PreferencesController) && (0, _utils.hasProperty)(state.PreferencesController, 'useRequestQueue')) {
    delete state.PreferencesController.useRequestQueue;
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\136.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\137.ts", {"lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C137.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
const version = exports.version = 137;
function transformState(state) {
  return state;
}

/**
 * This migration was setting isAccountSyncingReadyToBeDispatched to true if completedOnboarding is true
 * Since this state property does not exist anymore, this migration is a no-op.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\137.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\138.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C138.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 138;

/**
 * This migration deletes the preference `redesignedTransactionsEnabled` if the
 * user has existing data.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  const preferencesControllerState = state === null || state === void 0 ? void 0 : state.PreferencesController;
  const preferences = preferencesControllerState === null || preferencesControllerState === void 0 ? void 0 : preferencesControllerState.preferences;
  if (preferences && (0, _utils.hasProperty)(preferences, 'redesignedTransactionsEnabled')) {
    delete preferences.redesignedTransactionsEnabled;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\138.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\139.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C139.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 139;

// In-lined from @metamask/multichain
const Caip25CaveatType = 'authorizedScopes';
const Caip25EndowmentPermissionName = 'endowment:caip25';

// Locally defined types

const PermissionNames = {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
  // eslint-disable-next-line @typescript-eslint/naming-convention
  eth_accounts: 'eth_accounts',
  permittedChains: 'endowment:permitted-chains'
};

// a map of the networks built into the extension at the time of this migration to their chain IDs
// copied from shared/constants/network.ts (https://github.com/MetaMask/metamask-extension/blob/5b5c04a16fb7937a6e9d59b1debe4713978ef39d/shared/constants/network.ts#L535)
const BUILT_IN_NETWORKS = new Map([['sepolia', '0xaa36a7'], ['mainnet', '0x1'], ['linea-sepolia', '0xe705'], ['linea-mainnet', '0xe708']]);
const snapsPrefixes = ['npm:', 'local:'];
function isPermissionConstraint(obj) {
  return (0, _utils.isObject)(obj) && obj !== null && (0, _utils.hasProperty)(obj, 'caveats') && Array.isArray(obj.caveats) && obj.caveats.length > 0 && (0, _utils.hasProperty)(obj, 'date') && typeof obj.date === 'number' && (0, _utils.hasProperty)(obj, 'id') && typeof obj.id === 'string' && (0, _utils.hasProperty)(obj, 'invoker') && typeof obj.invoker === 'string' && (0, _utils.hasProperty)(obj, 'parentCapability') && typeof obj.parentCapability === 'string';
}
function isNonEmptyArrayOfStrings(obj) {
  return Array.isArray(obj) && obj.length > 0 && obj.every(item => typeof item === 'string');
}

/**
 * This migration transforms `eth_accounts` and `permittedChains` permissions into
 * an equivalent CAIP-25 permission.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  const newState = transformState(versionedData.data);
  versionedData.data = newState;
  return versionedData;
}
function transformState(oldState) {
  const newState = (0, _lodash.cloneDeep)(oldState);
  if (!(0, _utils.hasProperty)(newState, 'PermissionController')) {
    return oldState;
  }
  if (!(0, _utils.isObject)(newState.PermissionController)) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`Migration ${version}: typeof state.PermissionController is ${typeof newState.PermissionController}`));
    return oldState;
  }
  if (!(0, _utils.hasProperty)(newState, 'NetworkController') || !(0, _utils.isObject)(newState.NetworkController)) {
    var _global$sentry2, _global$sentry2$captu;
    (_global$sentry2 = global.sentry) === null || _global$sentry2 === void 0 || (_global$sentry2$captu = _global$sentry2.captureException) === null || _global$sentry2$captu === void 0 || _global$sentry2$captu.call(_global$sentry2, new Error(`Migration ${version}: typeof state.NetworkController is ${typeof newState.NetworkController}`));
    return oldState;
  }
  if (!(0, _utils.hasProperty)(newState, 'SelectedNetworkController')) {
    console.warn(`Migration ${version}: typeof state.SelectedNetworkController is ${typeof newState.SelectedNetworkController}`);
    // This matches how the `SelectedNetworkController` is initialized
    // See https://github.com/MetaMask/core/blob/e692641040be470f7f4ad2d58692b0668e6443b3/packages/selected-network-controller/src/SelectedNetworkController.ts#L27
    newState.SelectedNetworkController = {
      domains: {}
    };
  }
  if (!(0, _utils.isObject)(newState.SelectedNetworkController)) {
    var _global$sentry3, _global$sentry3$captu;
    (_global$sentry3 = global.sentry) === null || _global$sentry3 === void 0 || (_global$sentry3$captu = _global$sentry3.captureException) === null || _global$sentry3$captu === void 0 || _global$sentry3$captu.call(_global$sentry3, new Error(`Migration ${version}: typeof state.SelectedNetworkController is ${typeof newState.SelectedNetworkController}`));
    return oldState;
  }
  const {
    NetworkController: {
      selectedNetworkClientId,
      networkConfigurationsByChainId
    },
    PermissionController: {
      subjects
    }
  } = newState;
  if (!(0, _utils.isObject)(subjects)) {
    var _global$sentry4, _global$sentry4$captu;
    (_global$sentry4 = global.sentry) === null || _global$sentry4 === void 0 || (_global$sentry4$captu = _global$sentry4.captureException) === null || _global$sentry4$captu === void 0 || _global$sentry4$captu.call(_global$sentry4, new Error(`Migration ${version}: typeof state.PermissionController.subjects is ${typeof subjects}`));
    return oldState;
  }
  if (!selectedNetworkClientId || typeof selectedNetworkClientId !== 'string') {
    var _global$sentry5, _global$sentry5$captu;
    (_global$sentry5 = global.sentry) === null || _global$sentry5 === void 0 || (_global$sentry5$captu = _global$sentry5.captureException) === null || _global$sentry5$captu === void 0 || _global$sentry5$captu.call(_global$sentry5, new Error(`Migration ${version}: typeof state.NetworkController.selectedNetworkClientId is ${typeof selectedNetworkClientId}`));
    return oldState;
  }
  if (!(0, _utils.isObject)(networkConfigurationsByChainId)) {
    var _global$sentry6, _global$sentry6$captu;
    (_global$sentry6 = global.sentry) === null || _global$sentry6 === void 0 || (_global$sentry6$captu = _global$sentry6.captureException) === null || _global$sentry6$captu === void 0 || _global$sentry6$captu.call(_global$sentry6, new Error(`Migration ${version}: typeof state.NetworkController.networkConfigurationsByChainId is ${typeof newState.NetworkController.networkConfigurationsByChainId}`));
    return oldState;
  }
  if (!(0, _utils.hasProperty)(newState.SelectedNetworkController, 'domains') || !(0, _utils.isObject)(newState.SelectedNetworkController.domains)) {
    var _global$sentry7, _global$sentry7$captu;
    const {
      domains
    } = newState.SelectedNetworkController;
    (_global$sentry7 = global.sentry) === null || _global$sentry7 === void 0 || (_global$sentry7$captu = _global$sentry7.captureException) === null || _global$sentry7$captu === void 0 || _global$sentry7$captu.call(_global$sentry7, new Error(`Migration ${version}: typeof state.SelectedNetworkController.domains is ${typeof domains}`));
    return oldState;
  }
  const {
    domains
  } = newState.SelectedNetworkController;
  const getChainIdForNetworkClientId = (networkClientId, propertyName) => {
    let malformedDataErrorFound = false;
    let matchingChainId;
    for (const [chainId, networkConfiguration] of Object.entries(networkConfigurationsByChainId)) {
      if (!(0, _utils.isObject)(networkConfiguration)) {
        var _global$sentry8;
        (_global$sentry8 = global.sentry) === null || _global$sentry8 === void 0 || _global$sentry8.captureException(new Error(`Migration ${version}: typeof state.NetworkController.networkConfigurationsByChainId["${chainId}"] is ${typeof networkConfiguration}`));
        malformedDataErrorFound = true;
        continue;
      }
      if (!Array.isArray(networkConfiguration.rpcEndpoints)) {
        var _global$sentry9;
        (_global$sentry9 = global.sentry) === null || _global$sentry9 === void 0 || _global$sentry9.captureException(new Error(`Migration ${version}: typeof state.NetworkController.networkConfigurationsByChainId["${chainId}"].rpcEndpoints is ${typeof networkConfiguration.rpcEndpoints}`));
        malformedDataErrorFound = true;
        continue;
      }
      for (const rpcEndpoint of networkConfiguration.rpcEndpoints) {
        if (!(0, _utils.isObject)(rpcEndpoint)) {
          var _global$sentry0;
          (_global$sentry0 = global.sentry) === null || _global$sentry0 === void 0 || _global$sentry0.captureException(new Error(`Migration ${version}: typeof state.NetworkController.networkConfigurationsByChainId["${chainId}"].rpcEndpoints[] is ${typeof rpcEndpoint}`));
          malformedDataErrorFound = true;
          continue;
        }
        if (rpcEndpoint.networkClientId === networkClientId) {
          matchingChainId = chainId;
        }
      }
    }
    if (malformedDataErrorFound) {
      return undefined;
    }
    if (matchingChainId) {
      return matchingChainId;
    }
    const builtInChainId = BUILT_IN_NETWORKS.get(networkClientId);
    if (!builtInChainId) {
      var _global$sentry1;
      (_global$sentry1 = global.sentry) === null || _global$sentry1 === void 0 || _global$sentry1.captureException(new Error(`Migration ${version}: No chainId found for ${propertyName} "${networkClientId}"`));
    }
    return builtInChainId;
  };
  const currentChainId = getChainIdForNetworkClientId(selectedNetworkClientId, 'selectedNetworkClientId');
  if (!currentChainId) {
    return oldState;
  }

  // perform mutations on the cloned state
  for (const [origin, subject] of Object.entries(subjects)) {
    var _ethAccountsPermissio;
    if (!(0, _utils.isObject)(subject)) {
      var _global$sentry10, _global$sentry10$capt;
      (_global$sentry10 = global.sentry) === null || _global$sentry10 === void 0 || (_global$sentry10$capt = _global$sentry10.captureException) === null || _global$sentry10$capt === void 0 || _global$sentry10$capt.call(_global$sentry10, new Error(`Migration ${version}: Invalid subject for origin "${origin}" of type ${typeof subject}`));
      return oldState;
    }
    if (!(0, _utils.hasProperty)(subject, 'permissions') || !(0, _utils.isObject)(subject.permissions)) {
      var _global$sentry11, _global$sentry11$capt;
      (_global$sentry11 = global.sentry) === null || _global$sentry11 === void 0 || (_global$sentry11$capt = _global$sentry11.captureException) === null || _global$sentry11$capt === void 0 || _global$sentry11$capt.call(_global$sentry11, new Error(`Migration ${version}: Invalid permissions for origin "${origin}" of type ${typeof subject.permissions}`));
      return oldState;
    }
    const {
      permissions
    } = subject;
    let basePermission;
    let ethAccounts = [];
    const ethAccountsPermission = permissions[PermissionNames.eth_accounts];
    const permittedChainsPermission = permissions[PermissionNames.permittedChains];

    // if there is no eth_accounts permission we can't create a valid CAIP-25 permission so
    // we remove the permitted-chains permission if present and then continue
    if (!ethAccountsPermission) {
      delete permissions[PermissionNames.permittedChains];
      continue;
    }
    if (!isPermissionConstraint(ethAccountsPermission)) {
      var _global$sentry12, _global$sentry12$capt;
      (_global$sentry12 = global.sentry) === null || _global$sentry12 === void 0 || (_global$sentry12$capt = _global$sentry12.captureException) === null || _global$sentry12$capt === void 0 || _global$sentry12$capt.call(_global$sentry12, new Error(`Migration ${version}: Invalid state.PermissionController.subjects[${origin}].permissions[${PermissionNames.eth_accounts}]: ${JSON.stringify(ethAccountsPermission)}`));
      return oldState;
    }
    const accountsCaveatValue = (_ethAccountsPermissio = ethAccountsPermission.caveats) === null || _ethAccountsPermissio === void 0 || (_ethAccountsPermissio = _ethAccountsPermissio[0]) === null || _ethAccountsPermissio === void 0 ? void 0 : _ethAccountsPermissio.value;
    if (!isNonEmptyArrayOfStrings(accountsCaveatValue)) {
      var _global$sentry13, _global$sentry13$capt, _ethAccountsPermissio2;
      (_global$sentry13 = global.sentry) === null || _global$sentry13 === void 0 || (_global$sentry13$capt = _global$sentry13.captureException) === null || _global$sentry13$capt === void 0 || _global$sentry13$capt.call(_global$sentry13, new Error(`Migration ${version}: Invalid state.PermissionController.subjects[${origin}].permissions[${PermissionNames.eth_accounts}].caveats[0].value of type ${typeof ((_ethAccountsPermissio2 = ethAccountsPermission.caveats) === null || _ethAccountsPermissio2 === void 0 || (_ethAccountsPermissio2 = _ethAccountsPermissio2[0]) === null || _ethAccountsPermissio2 === void 0 ? void 0 : _ethAccountsPermissio2.value)}`));
      return oldState;
    }
    ethAccounts = accountsCaveatValue;
    basePermission = ethAccountsPermission;
    delete permissions[PermissionNames.eth_accounts];
    let chainIds = [];
    // this permission is new so it may not exist
    if (permittedChainsPermission) {
      var _permittedChainsPermi;
      if (!isPermissionConstraint(permittedChainsPermission)) {
        var _global$sentry14, _global$sentry14$capt;
        (_global$sentry14 = global.sentry) === null || _global$sentry14 === void 0 || (_global$sentry14$capt = _global$sentry14.captureException) === null || _global$sentry14$capt === void 0 || _global$sentry14$capt.call(_global$sentry14, new Error(`Migration ${version}: Invalid state.PermissionController.subjects[${origin}].permissions[${PermissionNames.permittedChains}]: ${JSON.stringify(permittedChainsPermission)}`));
        return oldState;
      }
      const chainsCaveatValue = (_permittedChainsPermi = permittedChainsPermission.caveats) === null || _permittedChainsPermi === void 0 || (_permittedChainsPermi = _permittedChainsPermi[0]) === null || _permittedChainsPermi === void 0 ? void 0 : _permittedChainsPermi.value;
      if (!isNonEmptyArrayOfStrings(chainsCaveatValue)) {
        var _global$sentry15, _global$sentry15$capt, _permittedChainsPermi2;
        (_global$sentry15 = global.sentry) === null || _global$sentry15 === void 0 || (_global$sentry15$capt = _global$sentry15.captureException) === null || _global$sentry15$capt === void 0 || _global$sentry15$capt.call(_global$sentry15, new Error(`Migration ${version}: Invalid state.PermissionController.subjects[${origin}].permissions[${PermissionNames.permittedChains}].caveats[0].value of type ${typeof ((_permittedChainsPermi2 = permittedChainsPermission.caveats) === null || _permittedChainsPermi2 === void 0 || (_permittedChainsPermi2 = _permittedChainsPermi2[0]) === null || _permittedChainsPermi2 === void 0 ? void 0 : _permittedChainsPermi2.value)}`));
        return oldState;
      }
      chainIds = chainsCaveatValue;
      basePermission ?? (basePermission = permittedChainsPermission);
      delete permissions[PermissionNames.permittedChains];
    }
    if (chainIds.length === 0) {
      chainIds = [currentChainId];
      const networkClientIdForOrigin = domains[origin];
      if (networkClientIdForOrigin && typeof networkClientIdForOrigin === 'string') {
        const chainIdForOrigin = getChainIdForNetworkClientId(networkClientIdForOrigin, 'networkClientIdForOrigin');
        if (chainIdForOrigin) {
          chainIds = [chainIdForOrigin];
        }
      }
    }
    const isSnap = snapsPrefixes.some(prefix => origin.startsWith(prefix));
    const scopes = {};
    const scopeStrings = isSnap ? [] : chainIds.map(chainId => `eip155:${(0, _utils.hexToBigInt)(chainId).toString(10)}`);
    scopeStrings.push('wallet:eip155');
    scopeStrings.forEach(scopeString => {
      const caipAccounts = ethAccounts.map(account => `${scopeString}:${account}`);
      scopes[scopeString] = {
        accounts: caipAccounts
      };
    });
    const caip25Permission = {
      ...basePermission,
      parentCapability: Caip25EndowmentPermissionName,
      caveats: [{
        type: Caip25CaveatType,
        value: {
          requiredScopes: {},
          optionalScopes: scopes,
          isMultichainOrigin: false
        }
      }]
    };
    permissions[Caip25EndowmentPermissionName] = caip25Permission;
  }
  return newState;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\139.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\140.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C140.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 140;

/**
 * This migration deletes properties from state which have been removed in
 * previous commits.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if ((0, _utils.hasProperty)(state, 'AppStateController') && (0, _utils.isObject)(state.AppStateController)) {
    // Removed in 33cc8d587aad05c0b41871ba3676676a3ce5680e with a migration, but
    // still persists for some people for some reason
    // See https://metamask.sentry.io/issues/6223008336/events/723c5195130e4c5584b53a6656a85595/
    delete state.AppStateController.collectiblesDropdownState;
    // Removed in 4ea52511eb7934bf0ce6b9b7d570a525120229ce
    delete state.AppStateController.serviceWorkerLastActiveTime;
    // Removed in 24e0a9030b1a715a008e0c5dfaf9c552bcdb304e with a migration, but
    // still persists for some people for some reason
    // See https://metamask.sentry.io/issues/6223008336/events/a2cc42d6ed79485a8b2e9072d8033720/
    delete state.AppStateController.showPortfolioTooltip;
  }
  if ((0, _utils.hasProperty)(state, 'NetworkController') && (0, _utils.isObject)(state.NetworkController)) {
    // Removed in 555d42b9ead0f4919356ff16e11c663c5e38639e
    delete state.NetworkController.networkConfigurations;
    // Removed in 800a9d3a177446ff2d05e3e95ec06b3658474207 with a migration, but
    // still persists for some people for some reason
    // See: https://metamask.sentry.io/issues/6011869130/events/039861ddb07f4b39b947edba3bbd710e/
    delete state.NetworkController.providerConfig;
  }
  if ((0, _utils.hasProperty)(state, 'PreferencesController') && (0, _utils.isObject)(state.PreferencesController)) {
    // Removed in 6c84e9604c7160dd91c685f301f3c8bd128ad3e3
    delete state.PreferencesController.customNetworkListEnabled;
    // Removed in e6ecd956b054a29481071e4eded2f8cd17d137d2
    delete state.PreferencesController.disabledRpcMethodPreferences;
    // Removed in 8125473dc53476b6685c5e85918f89bce87e3006
    delete state.PreferencesController.eip1559V2Enabled;
    // Removed in 699ddccc76302df6130835dc6655077806bf6335
    delete state.PreferencesController.hasDismissedOpenSeaToBlockaidBanner;
    // I could find references to this in the commit history, but don't know
    // where it was removed
    delete state.PreferencesController.hasMigratedFromOpenSeaToBlockaid;
    // Removed in f988dc1c5ef98ec72212d1f58e736556273b68f7
    delete state.PreferencesController.improvedTokenAllowanceEnabled;
    // Removed in 315c043785cd5d7a4b0f7e974097ccac18a6b241
    delete state.PreferencesController.infuraBlocked;
    // Removed in 4f66dc948fee54b8491227414342ab0d373475f1 with a migration, but
    // still persists for some people for some reason
    // See: https://metamask.sentry.io/issues/6042074159/events/5711f95785d741739e5d0fa5ad19e7c0/
    delete state.PreferencesController.useCollectibleDetection;
    // Removed in eb987a47b51ce410de0047ec883bb4549ce80c85
    delete state.PreferencesController.useStaticTokenList;
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\140.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\141.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C141.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 141;

/**
 * This migration deletes the preference `redesignedConfirmationsEnabled` if the
 * user has existing data.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  const preferencesControllerState = state === null || state === void 0 ? void 0 : state.PreferencesController;
  const preferences = preferencesControllerState === null || preferencesControllerState === void 0 ? void 0 : preferencesControllerState.preferences;
  if (preferences && (0, _utils.hasProperty)(preferences, 'redesignedConfirmationsEnabled')) {
    delete preferences.redesignedConfirmationsEnabled;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\141.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\142.ts", {"lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C142.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
const version = exports.version = 142;

/**
 * This migration deletes the preference `isRedesignedConfirmationsDeveloperEnabled` if the
 * user has existing data.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  const preferencesControllerState = state === null || state === void 0 ? void 0 : state.PreferencesController;
  const preferences = preferencesControllerState === null || preferencesControllerState === void 0 ? void 0 : preferencesControllerState.preferences;
  preferences === null || preferences === void 0 || delete preferences.isRedesignedConfirmationsDeveloperEnabled;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\142.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\143.1.ts", {"lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C143.1.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
const version = exports.version = 143.1;

/**
 * This migration deletes the `previousUserTraits` property from the MetaMetrics Controller state
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  const metaMetricsControllerState = state === null || state === void 0 ? void 0 : state.MetaMetricsController;
  metaMetricsControllerState === null || metaMetricsControllerState === void 0 || delete metaMetricsControllerState.previousUserTraits;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\143.1.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\143.ts", {"lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C143.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
const version = exports.version = 143;

/**
 * This migration deletes the `useNonceField` state property if the user has
 * existing data.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  const preferencesControllerState = state === null || state === void 0 ? void 0 : state.PreferencesController;
  preferencesControllerState === null || preferencesControllerState === void 0 || delete preferencesControllerState.useNonceField;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\143.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\144.ts", {"../../../shared/constants/price-api-currencies":"D:\\code\\v\\metamask-extension\\shared\\constants\\price-api-currencies.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C144.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
var _priceApiCurrencies = require("../../../shared/constants/price-api-currencies");
const version = exports.version = 144;
const DEFAULT_CURRENCY = 'usd';

/**
 * This migration ensures that the `currentCurrency` in `CurrencyController`
 * is set to a valid available currency. If it's missing or invalid, it defaults to "USD".
 *
 * @param originalVersionedData - The original MetaMask extension state.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if (!(0, _utils.hasProperty)(state, 'CurrencyController')) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`Migration ${version}: Missing CurrencyController in state`));
    return;
  }
  const currencyController = state.CurrencyController;
  if (!(0, _lodash.isObject)(currencyController)) {
    var _global$sentry2, _global$sentry2$captu;
    (_global$sentry2 = global.sentry) === null || _global$sentry2 === void 0 || (_global$sentry2$captu = _global$sentry2.captureException) === null || _global$sentry2$captu === void 0 || _global$sentry2$captu.call(_global$sentry2, new Error(`Migration ${version}: Invalid CurrencyController state type '${typeof currencyController}'`));
    return;
  }
  const {
    currentCurrency
  } = currencyController;
  if (!currentCurrency) {
    var _global$sentry3, _global$sentry3$captu;
    (_global$sentry3 = global.sentry) === null || _global$sentry3 === void 0 || (_global$sentry3$captu = _global$sentry3.captureException) === null || _global$sentry3$captu === void 0 || _global$sentry3$captu.call(_global$sentry3, new Error(`Migration ${version}: Missing currentCurrency in CurrencyController, defaulting to ${DEFAULT_CURRENCY}`));
    currencyController.currentCurrency = DEFAULT_CURRENCY;
    return;
  }
  const isValidCurrency = _priceApiCurrencies.PRICE_API_CURRENCIES.some(currency => currency === currentCurrency);
  if (!isValidCurrency) {
    currencyController.currentCurrency = DEFAULT_CURRENCY;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\144.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\145.ts", {"@metamask/multichain-network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C145.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _multichainNetworkController = require("@metamask/multichain-network-controller");
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 145;

/**
 * This migration updates the values of the chain IDs in the NetworkOrderController
 * from Hex to CaipChainId format (CAIP-19).
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to disk.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  // Migrate the user's drag + drop preference order for the network menu
  if ((0, _utils.hasProperty)(state, 'NetworkOrderController') && (0, _utils.isObject)(state.NetworkOrderController) && Array.isArray(state.NetworkOrderController.orderedNetworkList)) {
    state.NetworkOrderController.orderedNetworkList = state.NetworkOrderController.orderedNetworkList.map(({
      networkId
    }) => ({
      networkId: (0, _multichainNetworkController.toEvmCaipChainId)(networkId)
    }));
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\145.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\146.1.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C146.1.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 146.1;

/**
 * This migration sets the selectedNetworkClientId to mainnet if the current selectedNetworkClientId does not exist in the networkConfigurationsByChainId object.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to disk.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  versionedData.data = transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if ((0, _utils.hasProperty)(state, 'NetworkController') && (0, _utils.isObject)(state.NetworkController) && (0, _utils.isObject)(state.NetworkController.networkConfigurationsByChainId) && (0, _utils.hasProperty)(state.NetworkController, 'selectedNetworkClientId')) {
    const networkState = state.NetworkController;
    const allNetworkConfigurations = Object.values(state.NetworkController.networkConfigurationsByChainId);
    const allNetworkClientIds = allNetworkConfigurations.flatMap(n => (0, _utils.isObject)(n) && Array.isArray(n.rpcEndpoints) ? n.rpcEndpoints : []).map(e => e.networkClientId);
    if (!allNetworkClientIds.includes(networkState.selectedNetworkClientId)) {
      state.NetworkController.selectedNetworkClientId = 'mainnet';
    }
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\146.1.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\146.ts", {"@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C146.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _networkController = require("@metamask/network-controller");
var _controllerUtils = require("@metamask/controller-utils");
var _lodash = require("lodash");
const version = exports.version = 146;

/**
 * This migration add MegaETH to the network controller
 * as a default Testnet.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to disk.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  versionedData.data = transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if ((0, _utils.hasProperty)(state, 'NetworkController') && (0, _utils.isObject)(state.NetworkController) && (0, _utils.isObject)(state.NetworkController.networkConfigurationsByChainId)) {
    const megaethTestnet = 'megaeth-testnet';
    const megaethTestnetChainId = _controllerUtils.ChainId[megaethTestnet];
    const megaethTestnetConfiguration = {
      chainId: megaethTestnetChainId,
      name: _controllerUtils.NetworkNickname[megaethTestnet],
      nativeCurrency: _controllerUtils.NetworksTicker[megaethTestnet],
      blockExplorerUrls: [_controllerUtils.BlockExplorerUrl[megaethTestnet]],
      defaultRpcEndpointIndex: 0,
      defaultBlockExplorerUrlIndex: 0,
      rpcEndpoints: [{
        networkClientId: megaethTestnet,
        type: _networkController.RpcEndpointType.Custom,
        url: _controllerUtils.BUILT_IN_CUSTOM_NETWORKS_RPC.MEGAETH_TESTNET
      }]
    };
    state.NetworkController.networkConfigurationsByChainId[megaethTestnetChainId] = megaethTestnetConfiguration;
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\146.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\147.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C147.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention

const version = exports.version = 147;
function transformState(state) {
  if (!(0, _utils.hasProperty)(state, 'AuthenticationController') || !(0, _utils.isObject)(state.AuthenticationController)) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`Invalid AuthenticationController state: ${typeof state.AuthenticationController}`));
    return state;
  }

  // If the sessionData is a previous version, we need to delete it
  if ((0, _utils.hasProperty)(state.AuthenticationController, 'sessionData') && (0, _utils.isObject)(state.AuthenticationController.sessionData) && (0, _utils.hasProperty)(state.AuthenticationController.sessionData, 'accessToken')) {
    state.AuthenticationController.sessionData = undefined;
    state.AuthenticationController.isSignedIn = false;
  }
  return state;
}

/**
 * This migration resets sessionData and isSignedIn if using the old sessionData state shape.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\147.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\148.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C148.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 148;

/**
 * This migration deletes properties from state which have been removed in
 * previous commits.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if ((0, _utils.hasProperty)(state, 'AppStateController') && (0, _utils.isObject)(state.AppStateController)) {
    // See: https://metamask.sentry.io/issues/5975849508/events/7b2c1e15e40b4b94b08030f8b5470f36/
    delete state.AppStateController.enableEIP1559V2NoticeDismissed;
  }
  if ((0, _utils.hasProperty)(state, 'NftController') && (0, _utils.isObject)(state.NftController)) {
    // See: https://metamask.sentry.io/issues/5975849508/events/7b2c1e15e40b4b94b08030f8b5470f36/
    delete state.NftController.collectibles;
    // See: https://metamask.sentry.io/issues/5975849508/events/7b2c1e15e40b4b94b08030f8b5470f36/
    delete state.NftController.collectibleContracts;
  }
  if ((0, _utils.hasProperty)(state, 'PreferencesController') && (0, _utils.isObject)(state.PreferencesController) && (0, _utils.hasProperty)(state.PreferencesController, 'preferences') && (0, _utils.isObject)(state.PreferencesController.preferences)) {
    // Removed in https://github.com/MetaMask/metamask-extension/pull/23460
    // See: https://metamask.sentry.io/issues/6312710272/events/e9f738648e874c7ab7bc974a79c0a048/
    delete state.PreferencesController.preferences.transactionSecurityCheckEnabled;
    // Removed in https://github.com/MetaMask/metamask-extension/pull/29301
    // See: https://metamask.sentry.io/issues/6043753318/events/b610fbc6125d439190845caeba805eb1/
    delete state.PreferencesController.preferences.useRequestQueue;
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\148.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\149.ts", {"@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C149.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _controllerUtils = require("@metamask/controller-utils");
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 149;

/**
 * This migration corrects chain IDs in NetworkController state so that they are
 * hex strings and not decimals.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  try {
    versionedData.data = transformState(versionedData.data);
  } catch (error) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`Migration #${version}: ${(0, _utils.getErrorMessage)(error)}`));
  }
  return versionedData;
}
function transformState(state) {
  const newState = (0, _lodash.cloneDeep)(state);
  if (!(0, _utils.hasProperty)(newState, 'NetworkController')) {
    throw new Error(`newState.NetworkController must be present`);
  }
  if (!(0, _utils.isObject)(newState.NetworkController)) {
    throw new Error(`state.NetworkController must be an object, but is: ${typeof newState.NetworkController}`);
  }
  if (!(0, _utils.hasProperty)(newState.NetworkController, 'networkConfigurationsByChainId')) {
    throw new Error(`state.NetworkController.networkConfigurationsByChainId must be present`);
  }
  if (!(0, _utils.isObject)(newState.NetworkController.networkConfigurationsByChainId)) {
    throw new Error(`state.NetworkController.networkConfigurationsByChainId must be an object, but is: ${typeof newState.NetworkController.networkConfigurationsByChainId}`);
  }
  const {
    networkConfigurationsByChainId
  } = newState.NetworkController;
  for (const [chainId, networkConfiguration] of Object.entries(networkConfigurationsByChainId)) {
    const chainIdAsHex = (0, _controllerUtils.toHex)(chainId);
    if (!(0, _utils.isObject)(networkConfiguration)) {
      throw new Error(`state.NetworkController.networkConfigurationsByChainId has a network configuration under '${chainId}' that must be an object but is: ${typeof networkConfiguration}`);
    }
    if (typeof networkConfiguration.chainId !== 'string') {
      throw new Error(`state.NetworkController.networkConfigurationsByChainId has a network configuration under '${chainId}' with a chainId that must be a string but is: ${typeof networkConfiguration.chainId}`);
    }
    networkConfiguration.chainId = chainIdAsHex;
    if (chainIdAsHex !== chainId) {
      delete networkConfigurationsByChainId[chainId];
      networkConfigurationsByChainId[chainIdAsHex] = networkConfiguration;
    }
  }
  return newState;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\149.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\150.ts", {"lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C150.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
const version = exports.version = 150;

/**
 * This migration deletes the preference `petnamesEnabled` if the user has
 * existing data.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  const preferencesControllerState = state === null || state === void 0 ? void 0 : state.PreferencesController;
  const preferences = preferencesControllerState === null || preferencesControllerState === void 0 ? void 0 : preferencesControllerState.preferences;
  preferences === null || preferences === void 0 || delete preferences.petnamesEnabled;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\150.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\151.ts", {"lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C151.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
const version = exports.version = 151;

/**
 * This migration deletes the preference `petnamesEnabled` if the user has
 * existing data.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  const preferencesControllerState = state === null || state === void 0 ? void 0 : state.PreferencesController;
  preferencesControllerState === null || preferencesControllerState === void 0 || delete preferencesControllerState.incomingTransactionsPreferences;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\151.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\152.1.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C152.1.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TESTNETS = void 0;
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 152.1;

// Since this is a migration, we don't want to rely on data
// from outside packages that could change. Therefore, we'll
// use literal values.
const TESTNETS = exports.TESTNETS = {
  'bip122:000000000933ea01ad0ee984209779ba': {
    chainId: 'bip122:000000000933ea01ad0ee984209779ba',
    name: 'Bitcoin Testnet',
    nativeCurrency: 'bip122:000000000933ea01ad0ee984209779ba/slip44:0',
    isEvm: false
  },
  'bip122:00000008819873e925422c1ff0f99f7c': {
    chainId: 'bip122:00000008819873e925422c1ff0f99f7c',
    name: 'Bitcoin Mutinynet',
    nativeCurrency: 'bip122:00000008819873e925422c1ff0f99f7c/slip44:0',
    isEvm: false
  },
  'solana:4uhcVJyU9pJkvQyS88uRDiswHXSCkY3z': {
    chainId: 'solana:4uhcVJyU9pJkvQyS88uRDiswHXSCkY3z',
    name: 'Solana Testnet',
    nativeCurrency: 'solana:4uhcVJyU9pJkvQyS88uRDiswHXSCkY3z/slip44:501',
    isEvm: false
  },
  'solana:EtWTRABZaYq6iMfeYKouRu166VU2xqa1': {
    chainId: 'solana:EtWTRABZaYq6iMfeYKouRu166VU2xqa1',
    name: 'Solana Devnet',
    nativeCurrency: 'solana:EtWTRABZaYq6iMfeYKouRu166VU2xqa1/slip44:501',
    isEvm: false
  }
};

/**
 * This migration adds test network configurations to the MultichainNetworkController.
 * Networks added: Bitcoin testnet, Bitcoin Signet, Solana testnet, and Solana devnet.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to disk.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if ((0, _utils.hasProperty)(state, 'MultichainNetworkController') && (0, _utils.isObject)(state.MultichainNetworkController) && (0, _utils.isObject)(state.MultichainNetworkController.multichainNetworkConfigurationsByChainId)) {
    state.MultichainNetworkController.multichainNetworkConfigurationsByChainId = {
      ...state.MultichainNetworkController.multichainNetworkConfigurationsByChainId,
      ...TESTNETS
    };
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\152.1.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\152.2.ts", {"lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C152.2.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
const version = exports.version = 152.2;

/**
 * This migration deletes the preference `disabledUpgradeAccountsByChain`, `accountUpgradeDisabledChains` if the user has
 * existing data.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  const preferencesControllerState = state === null || state === void 0 ? void 0 : state.PreferencesController;
  const preferences = preferencesControllerState === null || preferencesControllerState === void 0 ? void 0 : preferencesControllerState.preferences;
  preferences === null || preferences === void 0 || delete preferences.disabledUpgradeAccountsByChain;
  preferences === null || preferences === void 0 || delete preferences.accountUpgradeDisabledChains;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\152.2.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\152.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C152.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
var _utils = require("@metamask/utils");
const version = exports.version = 152;

// inlined from @metamask/chain-agnostic-permission
const Caip25CaveatType = 'authorizedScopes';
const Caip25EndowmentPermissionName = 'endowment:caip25';
/**
 * Add sessionProperties property to CAIP-25 permission caveats
 *
 * @param originalVersionedData - Versioned MetaMask extension state
 * @returns Updated versioned MetaMask extension state
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}

/**
 * Add sessionProperties property to CAIP-25 permission caveats
 *
 * @param state - The MetaMask state
 * @returns The updated MetaMask state
 */
function transformState(state) {
  if (!(0, _utils.hasProperty)(state, 'PermissionController')) {
    return state;
  }
  if (!(0, _utils.isObject)(state.PermissionController)) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`Migration ${version}: typeof state.PermissionController is ${typeof state.PermissionController}`));
    return state;
  }
  const {
    subjects
  } = state.PermissionController;
  if (!(0, _utils.isObject)(subjects)) {
    var _global$sentry2, _global$sentry2$captu;
    (_global$sentry2 = global.sentry) === null || _global$sentry2 === void 0 || (_global$sentry2$captu = _global$sentry2.captureException) === null || _global$sentry2$captu === void 0 || _global$sentry2$captu.call(_global$sentry2, new Error(`Migration ${version}: typeof state.PermissionController.subjects is ${typeof subjects}`));
    return state;
  }
  for (const subject of Object.values(subjects)) {
    if (!(0, _utils.isObject)(subject) || !(0, _utils.hasProperty)(subject, 'permissions') || !(0, _utils.isObject)(subject.permissions)) {
      continue;
    }
    const {
      permissions
    } = subject;
    const caip25Permission = permissions[Caip25EndowmentPermissionName];
    if (!(0, _utils.isObject)(caip25Permission) || !Array.isArray(caip25Permission.caveats)) {
      continue;
    }
    const caip25Caveat = caip25Permission.caveats.find(caveat => caveat.type === Caip25CaveatType);
    if (caip25Caveat && (0, _utils.isObject)(caip25Caveat.value) && !(0, _utils.hasProperty)(caip25Caveat.value, 'sessionProperties')) {
      caip25Caveat.value.sessionProperties = {};
    }
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\152.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\153.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C153.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
var _utils = require("@metamask/utils");
const version = exports.version = 153;

/**
 * This migration removes the `tokens` property from the TokensController state.
 *
 * If the TokensController is not found or is not an object, the migration logs an error,
 * but otherwise leaves the state unchanged.
 *
 * @param originalVersionedData - The versioned extension state.
 * @returns The updated versioned extension state without the tokens property.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  versionedData.data = transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if (!(0, _utils.hasProperty)(state, 'TokensController')) {
    console.warn(`newState.TokensController is not present`);
    return state;
  }
  const tokensControllerState = state.TokensController;
  if (!(0, _utils.isObject)(tokensControllerState)) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`Migration ${version}: TokensController is type '${typeof tokensControllerState}', expected object.`));
    return state;
  }
  if (!(0, _utils.hasProperty)(state, 'TokenListController')) {
    console.warn(`newState.TokenListController is not present`);
    return state;
  }
  const tokenListControllerState = state.TokenListController;
  if (!(0, _utils.isObject)(tokenListControllerState)) {
    var _global$sentry2, _global$sentry2$captu;
    (_global$sentry2 = global.sentry) === null || _global$sentry2 === void 0 || (_global$sentry2$captu = _global$sentry2.captureException) === null || _global$sentry2$captu === void 0 || _global$sentry2$captu.call(_global$sentry2, new Error(`Migration ${version}: TokenListController is type '${typeof tokenListControllerState}', expected object.`));
    return state;
  }
  if ((0, _utils.hasProperty)(tokensControllerState, 'tokens')) {
    // Remove the tokens property from the TokensController state.
    delete tokensControllerState.tokens;
  }
  if ((0, _utils.hasProperty)(tokensControllerState, 'detectedTokens')) {
    // Remove the detectedTokens property from the TokensController state.
    delete tokensControllerState.detectedTokens;
  }
  if ((0, _utils.hasProperty)(tokensControllerState, 'ignoredTokens')) {
    // Remove the ignoredTokens property from the TokensController state.
    delete tokensControllerState.ignoredTokens;
  }
  if ((0, _utils.hasProperty)(tokenListControllerState, 'tokenList')) {
    // Remove the tokenList property from the TokenListController state.
    delete tokenListControllerState.tokenList;
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\153.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\154.ts", {"lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C154.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
const version = exports.version = 154;

/**
 * This migration deletes the QueuedRequestController from the state.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  state === null || state === void 0 || delete state.QueuedRequestController;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\154.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\155.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C155.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
var _utils = require("@metamask/utils");
const version = exports.version = 155;

/**
 * This migration removes the `bridgeStatusState` property from the BridgeStatusController state.
 *
 * If the BridgeStatusController is not found or is not an object, the migration logs an error,
 * but otherwise leaves the state unchanged.
 *
 * @param originalVersionedData - The versioned extension state.
 * @returns The updated versioned extension state without the tokens property.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  versionedData.data = transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if (!(0, _utils.hasProperty)(state, 'BridgeStatusController')) {
    return state;
  }
  const bridgeStatusControllerState = state.BridgeStatusController;
  if (!(0, _utils.isObject)(bridgeStatusControllerState)) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`Migration ${version}: BridgeStatusController is type '${typeof bridgeStatusControllerState}', expected object.`));
    return state;
  }
  if ((0, _utils.hasProperty)(bridgeStatusControllerState, 'bridgeStatusState')) {
    if ((0, _utils.isObject)(bridgeStatusControllerState.bridgeStatusState)) {
      state.BridgeStatusController = {
        ...bridgeStatusControllerState.bridgeStatusState
      };

      // Remove the bridgeStatusState property from the BridgeStatusController state.
      delete bridgeStatusControllerState.bridgeStatusState;
    }
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\155.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\156.1.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C156.1.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 156.1;

/**
 * Remove `keyringsMetadata` from `KeyringController` state.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  versionedData.data = transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  const newState = state;
  if ((0, _utils.hasProperty)(newState, 'KeyringController') && (0, _lodash.isObject)(newState.KeyringController) && (0, _utils.hasProperty)(newState.KeyringController, 'keyringsMetadata')) {
    delete newState.KeyringController.keyringsMetadata;
  }
  return newState;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\156.1.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\156.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C156.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 156;
/**
 * This migration corrects chainIds in NftController state.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  try {
    versionedData.data = transformState(versionedData.data);
  } catch (error) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`Migration #${version}: ${(0, _utils.getErrorMessage)(error)}`));
  }
  return versionedData;
}
function transformState(state) {
  const newState = (0, _lodash.cloneDeep)(state);
  if (!(0, _utils.hasProperty)(newState, 'NftController')) {
    console.warn(`newState.NftController must be present`);
    return state;
  }
  if (!(0, _utils.isObject)(newState.NftController)) {
    throw new Error(`state.NftController must be an object, but is: ${typeof newState.NftController}`);
  }
  if (!(0, _utils.hasProperty)(newState.NftController, 'allNfts')) {
    throw new Error(`state.NftController.allNfts must be present`);
  }
  if (!(0, _utils.isObject)(newState.NftController.allNfts)) {
    throw new Error(`state.NftController.allNfts must be an object, but is: ${typeof newState.NftController.allNfts}`);
  }
  const {
    allNfts
  } = newState.NftController;
  for (const NftsByAccount of Object.values(allNfts)) {
    for (const [chainId, allNftsByChainId] of Object.entries(NftsByAccount)) {
      allNftsByChainId.forEach(single => {
        if (!(single !== null && single !== void 0 && single.chainId)) {
          single.chainId = Number(chainId);
        }
      });
    }
  }
  return newState;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\156.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\157.ts", {"../../../shared/lib/sentry":"D:\\code\\v\\metamask-extension\\shared\\lib\\sentry.ts","@metamask/network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","_process":"D:\\code\\v\\metamask-extension\\node_modules\\process\\browser.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C157.ts
      return function (require, module, exports) {
(function (process){(function (){
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INFURA_CHAINS_WITH_FAILOVERS = void 0;
exports.migrate = migrate;
exports.version = void 0;
var _networkController = require("@metamask/network-controller");
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
var _sentry = require("../../../shared/lib/sentry");
const version = exports.version = 157;

// Chains supported by Infura that are either built in or featured,
// mapped to their corresponding failover URLs.
// Copied from `FEATURED_RPCS` in shared/constants/network.ts:
// <https://github.com/MetaMask/metamask-extension/blob/f28216fad810d138dab8577fe9bdb39f5b6d18d8/shared/constants/network.ts#L1051>
const INFURA_CHAINS_WITH_FAILOVERS = exports.INFURA_CHAINS_WITH_FAILOVERS = new Map([['0x1', {
  subdomain: 'mainnet',
  getFailoverUrl: () => null
}],
// linea mainnet
['0xe708', {
  subdomain: 'linea-mainnet',
  getFailoverUrl: () => null
}], ['0xa4b1', {
  subdomain: 'arbitrum',
  getFailoverUrl: () => null
}], ['0xa86a', {
  subdomain: 'avalanche',
  getFailoverUrl: () => null
}], ['0xa', {
  subdomain: 'optimism',
  getFailoverUrl: () => null
}], ['0x89', {
  subdomain: 'polygon',
  getFailoverUrl: () => null
}], ['0x2105', {
  subdomain: 'base',
  getFailoverUrl: () => null
}]]);

/**
 * This migration ensures that all RPC endpoints that hit Infura and use our API
 * key are assigned failover URLs that point to Quicknode.
 *
 * @param originalVersionedData - The original MetaMask extension state.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  try {
    transformState(versionedData.data);
  } catch (error) {
    console.error(error);
    const newError = new Error(`Migration #${version}: ${(0, _utils.getErrorMessage)(error)}`);
    (0, _sentry.captureException)(newError);
    // Even though we encountered an error, we need the migration to pass for
    // the migrator tests to work
    versionedData.data = originalVersionedData.data;
  }
  return versionedData;
}
function transformState(state) {
  if (!"31b83e13002d4287a8094f4ea8170eac") {
    throw new Error('No INFURA_PROJECT_ID set!');
  }
  if (!(0, _utils.hasProperty)(state, 'NetworkController')) {
    throw new Error('Missing NetworkController state');
  }
  if (!(0, _utils.isObject)(state.NetworkController)) {
    throw new Error(`Expected state.NetworkController to be an object, but is ${typeof state.NetworkController}`);
  }
  if (!(0, _utils.hasProperty)(state.NetworkController, 'networkConfigurationsByChainId')) {
    throw new Error('Missing state.NetworkController.networkConfigurationsByChainId');
  }
  if (!(0, _utils.isObject)(state.NetworkController.networkConfigurationsByChainId)) {
    throw new Error(`Expected state.NetworkController.networkConfigurationsByChainId to be an object, but is ${typeof state.NetworkController.networkConfigurationsByChainId}`);
  }
  const {
    networkConfigurationsByChainId
  } = state.NetworkController;
  for (const [chainId, networkConfiguration] of Object.entries(networkConfigurationsByChainId)) {
    const infuraChainWithFailover = INFURA_CHAINS_WITH_FAILOVERS.get(chainId);
    if (!(0, _utils.isObject)(networkConfiguration) || !(0, _utils.hasProperty)(networkConfiguration, 'rpcEndpoints') || !Array.isArray(networkConfiguration.rpcEndpoints)) {
      continue;
    }
    networkConfiguration.rpcEndpoints = networkConfiguration.rpcEndpoints.map(rpcEndpoint => {
      if (!(0, _utils.isObject)(rpcEndpoint) || !(0, _utils.hasProperty)(rpcEndpoint, 'url') || typeof rpcEndpoint.url !== 'string' || (0, _utils.hasProperty)(rpcEndpoint, 'failoverUrls') && Array.isArray(rpcEndpoint.failoverUrls) && rpcEndpoint.failoverUrls.length > 0) {
        return rpcEndpoint;
      }

      // All featured networks that use Infura get added as custom RPC
      // endpoints, not Infura RPC endpoints
      const match = rpcEndpoint.url.match(new RegExp(`https://(.+?)\\.infura\\.io/v3/${(0, _lodash.escapeRegExp)(process.env.INFURA_PROJECT_ID)}`, 'u'));
      const isInfuraLike = match && infuraChainWithFailover && match[1] === infuraChainWithFailover.subdomain;
      const failoverUrl = infuraChainWithFailover === null || infuraChainWithFailover === void 0 ? void 0 : infuraChainWithFailover.getFailoverUrl();
      if (failoverUrl && (rpcEndpoint.type === _networkController.RpcEndpointType.Infura || isInfuraLike)) {
        return {
          ...rpcEndpoint,
          failoverUrls: [failoverUrl]
        };
      }
      return rpcEndpoint;
    });
  }
}

}).call(this)}).call(this,require('_process'))

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\157.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\158.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C158.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 158;
function transformState(state) {
  if (!(0, _utils.hasProperty)(state, 'UserStorageController') || !(0, _utils.isObject)(state.UserStorageController)) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`Invalid UserStorageController state: ${typeof state.UserStorageController}`));
    return state;
  }
  if ((0, _utils.hasProperty)(state.UserStorageController, 'isProfileSyncingEnabled')) {
    state.UserStorageController.isBackupAndSyncEnabled = Boolean(state.UserStorageController.isProfileSyncingEnabled);
    delete state.UserStorageController.isProfileSyncingEnabled;
  }
  if ((0, _utils.hasProperty)(state.UserStorageController, 'isProfileSyncingUpdateLoading')) {
    state.UserStorageController.isBackupAndSyncUpdateLoading = Boolean(state.UserStorageController.isProfileSyncingUpdateLoading);
    delete state.UserStorageController.isProfileSyncingUpdateLoading;
  }
  return state;
}

/**
 * This migration updates UserStorageController's state to replace the
 * profile syncing state keys with the backup and sync ones.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\158.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\159.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C159.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
var _utils = require("@metamask/utils");
const version = exports.version = 159;

/**
 * This migration removes the `shouldShowAggregatedBalancePopover` property from the PreferencesController state.
 *
 * If the PreferenceController is not valid (not found or is not an object), the migration logs an error,
 * however we will leave the state unchanged.
 *
 * @param originalVersionedData - The versioned extension state.
 * @returns The updated versioned extension state without the `PreferencesController.shouldShowAggregatedBalancePopover` property.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  versionedData.data = transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if (!(0, _utils.hasProperty)(state, 'PreferencesController')) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`Migration ${version}: PreferencesController not found.`));
    return state;
  }
  const preferencesControllerState = state.PreferencesController;
  if (!(0, _utils.isObject)(preferencesControllerState)) {
    var _global$sentry2, _global$sentry2$captu;
    (_global$sentry2 = global.sentry) === null || _global$sentry2 === void 0 || (_global$sentry2$captu = _global$sentry2.captureException) === null || _global$sentry2$captu === void 0 || _global$sentry2$captu.call(_global$sentry2, new Error(`Migration ${version}: PreferencesController is type '${typeof preferencesControllerState}', expected object.`));
    return state;
  }
  if ((0, _utils.hasProperty)(preferencesControllerState, 'shouldShowAggregatedBalancePopover')) {
    delete preferencesControllerState.shouldShowAggregatedBalancePopover;
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\159.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\160.ts", {"@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","@metamask/snaps-rpc-methods":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","nanoid":"D:\\code\\v\\metamask-extension\\node_modules\\nanoid\\index.browser.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C160.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
var _utils = require("@metamask/utils");
var _nanoid = require("nanoid");
var _snapsRpcMethods = require("@metamask/snaps-rpc-methods");
var _chainAgnosticPermission = require("@metamask/chain-agnostic-permission");
const version = exports.version = 160;

/**
 * A map of the networks built into the extension at the time of this migration
 * to their chain IDs.
 *
 * @see https://github.com/MetaMask/metamask-extension/blob/5b5c04a16fb7937a6e9d59b1debe4713978ef39d/shared/constants/network.ts#L535
 */
const BUILT_IN_NETWORKS = new Map([['sepolia', '0xaa36a7'], ['mainnet', '0x1'], ['linea-sepolia', '0xe705'], ['linea-mainnet', '0xe708']]);

/**
 * This migration adds or modifies the `endowment:caip25` permission for all
 * Snaps that have the `endowment:ethereum-provider` permission, and sets the
 * selected chain ID for each Snap to the current selected network chain ID.
 *
 * This is to enable Snaps to change their network which has become necessary
 * since the extension has switched to a per origin selected network system -
 * previously all origins shared the single selected network of the wallet.
 *
 * To simplify the use for Snaps, we automatically add or modify the
 * `endowment:caip25` permission with the current selected network chain ID to
 * all Snaps that have the `endowment:ethereum-provider` permission.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  versionedData.data = transformState(versionedData.data);
  return versionedData;
}

/**
 * Transform the MetaMask extension state to add or modify the
 * `endowment:caip25` permission for all Snaps that have the
 * `endowment:ethereum-provider` permission.
 *
 * If the `NetworkController`, `PermissionController`, or
 * `SelectedNetworkController` state is not found or is not an object, the state
 * is returned as-is.
 *
 * @param state - The MetaMask extension state.
 * @returns The updated MetaMask extension state.
 */
function transformState(state) {
  const {
    NetworkController: networkControllerState,
    PermissionController: permissionControllerState,
    SelectedNetworkController: selectedNetworkControllerState
  } = state;
  if (!networkControllerState || !(0, _utils.isObject)(networkControllerState)) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error('Skipping migration: `NetworkController` state not found or is not an object.'));
    return state;
  }
  if (!(0, _utils.hasProperty)(networkControllerState, 'selectedNetworkClientId') || typeof networkControllerState.selectedNetworkClientId !== 'string') {
    var _global$sentry2, _global$sentry2$captu;
    (_global$sentry2 = global.sentry) === null || _global$sentry2 === void 0 || (_global$sentry2$captu = _global$sentry2.captureException) === null || _global$sentry2$captu === void 0 || _global$sentry2$captu.call(_global$sentry2, new Error('Skipping migration: `NetworkController.selectedNetworkClientId` is not a string.'));
    return state;
  }
  if (!(0, _utils.hasProperty)(networkControllerState, 'networkConfigurationsByChainId') || !(0, _utils.isObject)(networkControllerState.networkConfigurationsByChainId)) {
    var _global$sentry3, _global$sentry3$captu;
    (_global$sentry3 = global.sentry) === null || _global$sentry3 === void 0 || (_global$sentry3$captu = _global$sentry3.captureException) === null || _global$sentry3$captu === void 0 || _global$sentry3$captu.call(_global$sentry3, new Error('Skipping migration: `NetworkController.networkConfigurationsByChainId` is not an object.'));
    return state;
  }
  if (!permissionControllerState || !(0, _utils.isObject)(permissionControllerState)) {
    var _global$sentry4, _global$sentry4$captu;
    (_global$sentry4 = global.sentry) === null || _global$sentry4 === void 0 || (_global$sentry4$captu = _global$sentry4.captureException) === null || _global$sentry4$captu === void 0 || _global$sentry4$captu.call(_global$sentry4, new Error('Skipping migration: `PermissionController` state not found or is not an object.'));
    return state;
  }
  if (!(0, _utils.isObject)(permissionControllerState.subjects)) {
    var _global$sentry5, _global$sentry5$captu;
    (_global$sentry5 = global.sentry) === null || _global$sentry5 === void 0 || (_global$sentry5$captu = _global$sentry5.captureException) === null || _global$sentry5$captu === void 0 || _global$sentry5$captu.call(_global$sentry5, new Error('Skipping migration: `PermissionController.subjects` state is not an object.'));
    return state;
  }
  if (!selectedNetworkControllerState || !(0, _utils.isObject)(selectedNetworkControllerState)) {
    var _global$sentry6, _global$sentry6$captu;
    (_global$sentry6 = global.sentry) === null || _global$sentry6 === void 0 || (_global$sentry6$captu = _global$sentry6.captureException) === null || _global$sentry6$captu === void 0 || _global$sentry6$captu.call(_global$sentry6, new Error('Skipping migration: `SelectedNetworkController` state not found or is not an object.'));
    return state;
  }
  if (!(0, _utils.isObject)(selectedNetworkControllerState.domains)) {
    var _global$sentry7, _global$sentry7$captu;
    (_global$sentry7 = global.sentry) === null || _global$sentry7 === void 0 || (_global$sentry7$captu = _global$sentry7.captureException) === null || _global$sentry7$captu === void 0 || _global$sentry7$captu.call(_global$sentry7, new Error('Skipping migration: `SelectedNetworkController.domains` state is not an object.'));
    return state;
  }
  const currentChainId = getChainId(networkControllerState.selectedNetworkClientId, networkControllerState.networkConfigurationsByChainId);
  if (typeof currentChainId !== 'string') {
    var _global$sentry8, _global$sentry8$captu;
    (_global$sentry8 = global.sentry) === null || _global$sentry8 === void 0 || (_global$sentry8$captu = _global$sentry8.captureException) === null || _global$sentry8$captu === void 0 || _global$sentry8$captu.call(_global$sentry8, new Error('Skipping migration: No currently selected chainId was found, or the chainId resolved from the `NetworkController.selectedNetworkClientId` value is not a string.'));
    return state;
  }
  const updatedSubjects = [];

  // Add permission to use the current globally selected network to all Snaps
  // that have the `endowment:ethereum-provider` permission.
  const entries = Object.entries(permissionControllerState.subjects);
  permissionControllerState.subjects = entries.reduce((accumulator, [key, subject]) => {
    const permissionKeys = Object.keys(subject.permissions);
    const needsMigration = permissionKeys.includes(_snapsRpcMethods.SnapEndowments.EthereumProvider);
    if (!needsMigration) {
      return {
        ...accumulator,
        [key]: subject
      };
    }
    updatedSubjects.push(key);
    const caip25PermissionCaveatWithCurrentChainIdSet = (0, _chainAgnosticPermission.addPermittedEthChainId)(getExistingCaip25PermissionCaveat(subject), currentChainId);
    const {
      date = Date.now(),
      id = (0, _nanoid.nanoid)(),
      invoker = key,
      parentCapability = _chainAgnosticPermission.Caip25EndowmentPermissionName
    } = subject.permissions[_chainAgnosticPermission.Caip25EndowmentPermissionName] ?? {};
    const newSubject = {
      ...subject,
      permissions: {
        ...subject.permissions,
        [_chainAgnosticPermission.Caip25EndowmentPermissionName]: {
          caveats: [{
            type: _chainAgnosticPermission.Caip25CaveatType,
            value: caip25PermissionCaveatWithCurrentChainIdSet
          }],
          date,
          id,
          invoker,
          parentCapability
        }
      }
    };
    return {
      ...accumulator,
      [key]: newSubject
    };
  }, {});
  const currentDomains = selectedNetworkControllerState.domains;
  const domains = Object.fromEntries(updatedSubjects.map(subject => [subject, networkControllerState.selectedNetworkClientId]));
  selectedNetworkControllerState.domains = {
    ...currentDomains,
    ...domains
  };
  return state;
}

/**
 * Get the existing `endowment:caip25` caveat value for a given subject, if any.
 * If the caveat does not exist, a new empty caveat value is returned.
 *
 * This function does not validate the structure of the existing caveat value,
 * and assumes that the existing value is valid.
 *
 * @param subject - The subject to get the existing caveat value for.
 * @returns The existing `endowment:caip25` caveat value.
 */
function getExistingCaip25PermissionCaveat(subject) {
  var _subject$permissions$;
  const existingCaveat = (_subject$permissions$ = subject.permissions[_chainAgnosticPermission.Caip25EndowmentPermissionName]) === null || _subject$permissions$ === void 0 || (_subject$permissions$ = _subject$permissions$.caveats) === null || _subject$permissions$ === void 0 ? void 0 : _subject$permissions$.find(caveat => caveat.type === _chainAgnosticPermission.Caip25CaveatType);
  if (!existingCaveat) {
    return {
      isMultichainOrigin: false,
      optionalScopes: {},
      requiredScopes: {},
      sessionProperties: {}
    };
  }
  return existingCaveat.value;
}
function getChainId(networkClientId, networkConfigurationsByChainId) {
  const matchingNetworkConfigurationEntry = Object.entries(networkConfigurationsByChainId).find(([, config]) => {
    if (!(0, _utils.isObject)(config) || !(0, _utils.hasProperty)(config, 'rpcEndpoints') || !Array.isArray(config.rpcEndpoints)) {
      return false;
    }
    return config.rpcEndpoints.some(endpoint => (0, _utils.isObject)(endpoint) && endpoint.networkClientId === networkClientId);
  });
  if (matchingNetworkConfigurationEntry) {
    // `matchingNetworkConfigurationEntry` is a tuple of [chainId, config], so
    // we return the first element of the tuple, which is the chainId.
    return matchingNetworkConfigurationEntry[0];
  }
  return BUILT_IN_NETWORKS.get(networkClientId);
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\160.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\161.1.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C161.1.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 161.1;
function transformState(state) {
  if (!(0, _utils.hasProperty)(state, 'PreferencesController') || !(0, _utils.isObject)(state.PreferencesController)) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`Invalid PreferencesController state: ${typeof state.PreferencesController}`));
    return state;
  }
  if ((0, _utils.hasProperty)(state.PreferencesController, 'bitcoinSupportEnabled')) {
    delete state.PreferencesController.bitcoinSupportEnabled;
  }
  if ((0, _utils.hasProperty)(state.PreferencesController, 'bitcoinTestnetSupportEnabled')) {
    delete state.PreferencesController.bitcoinTestnetSupportEnabled;
  }
  return state;
}

/**
 * This migration updates PreferencesController's state to remove the
 * bitcoin support enabled.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\161.1.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\161.ts", {"@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C161.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _networkController = require("@metamask/network-controller");
var _controllerUtils = require("@metamask/controller-utils");
var _lodash = require("lodash");
const version = exports.version = 161;

/**
 * This migration add Monad to the network controller
 * as a default Testnet.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to disk.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  versionedData.data = transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if ((0, _utils.hasProperty)(state, 'NetworkController') && (0, _utils.isObject)(state.NetworkController) && (0, _utils.isObject)(state.NetworkController.networkConfigurationsByChainId)) {
    const monadTestnet = 'monad-testnet';
    const monadTestnetChainId = _controllerUtils.ChainId[monadTestnet];
    const monadTestnetConfiguration = {
      chainId: monadTestnetChainId,
      name: _controllerUtils.NetworkNickname[monadTestnet],
      nativeCurrency: _controllerUtils.NetworksTicker[monadTestnet],
      blockExplorerUrls: [_controllerUtils.BlockExplorerUrl[monadTestnet]],
      defaultRpcEndpointIndex: 0,
      defaultBlockExplorerUrlIndex: 0,
      rpcEndpoints: [{
        networkClientId: monadTestnet,
        type: _networkController.RpcEndpointType.Custom,
        url: _controllerUtils.BUILT_IN_CUSTOM_NETWORKS_RPC[monadTestnet]
      }]
    };
    state.NetworkController.networkConfigurationsByChainId[monadTestnetChainId] = monadTestnetConfiguration;
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\161.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\162.ts", {"@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C162.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
var _utils = require("@metamask/utils");
var _keyringApi = require("@metamask/keyring-api");
const version = exports.version = 162;

/**
 * This migration removes from the TokensController state all tokens that belong to an EVM account that has been removed.
 *
 * Also removed from TokenBalancesController all balances that belong to an EVM account that has been removed.
 *
 * If the Tokens is not found or is not an object, the migration logs an error,
 * but otherwise leaves the state unchanged.
 *
 * @param originalVersionedData - The versioned extension state.
 * @returns The updated versioned extension state without the tokens property.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  versionedData.data = transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if (!(0, _utils.hasProperty)(state, 'TokensController')) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`Migration ${version}: TokensController not found.`));
    return state;
  }
  if (!(0, _utils.hasProperty)(state, 'AccountsController')) {
    var _global$sentry2, _global$sentry2$captu;
    (_global$sentry2 = global.sentry) === null || _global$sentry2 === void 0 || (_global$sentry2$captu = _global$sentry2.captureException) === null || _global$sentry2$captu === void 0 || _global$sentry2$captu.call(_global$sentry2, new Error(`Migration ${version}: AccountsController not found.`));
    return state;
  }
  if (!(0, _utils.hasProperty)(state, 'TokenBalancesController')) {
    var _global$sentry3, _global$sentry3$captu;
    (_global$sentry3 = global.sentry) === null || _global$sentry3 === void 0 || (_global$sentry3$captu = _global$sentry3.captureException) === null || _global$sentry3$captu === void 0 || _global$sentry3$captu.call(_global$sentry3, new Error(`Migration ${version}: TokenBalancesController not found.`));
    return state;
  }
  const tokensControllerState = state.TokensController;
  const tokenBalancesControllerState = state.TokenBalancesController;
  const accountsControllerState = state.AccountsController;
  if (!(0, _utils.isObject)(tokensControllerState)) {
    var _global$sentry4, _global$sentry4$captu;
    (_global$sentry4 = global.sentry) === null || _global$sentry4 === void 0 || (_global$sentry4$captu = _global$sentry4.captureException) === null || _global$sentry4$captu === void 0 || _global$sentry4$captu.call(_global$sentry4, new Error(`Migration ${version}: TokensController is type '${typeof tokensControllerState}', expected object.`));
    return state;
  }
  if (!(0, _utils.isObject)(tokenBalancesControllerState)) {
    var _global$sentry5, _global$sentry5$captu;
    (_global$sentry5 = global.sentry) === null || _global$sentry5 === void 0 || (_global$sentry5$captu = _global$sentry5.captureException) === null || _global$sentry5$captu === void 0 || _global$sentry5$captu.call(_global$sentry5, new Error(`Migration ${version}: TokenBalancesController is type '${typeof tokenBalancesControllerState}', expected object.`));
    return state;
  }
  if (!(0, _utils.isObject)(accountsControllerState)) {
    var _global$sentry6, _global$sentry6$captu;
    (_global$sentry6 = global.sentry) === null || _global$sentry6 === void 0 || (_global$sentry6$captu = _global$sentry6.captureException) === null || _global$sentry6$captu === void 0 || _global$sentry6$captu.call(_global$sentry6, new Error(`Migration ${version}: AccountsController is type '${typeof accountsControllerState}', expected object.`));
    return state;
  }
  const {
    internalAccounts
  } = accountsControllerState;
  const accounts = Object.values(internalAccounts.accounts);
  const evmAccounts = accounts.filter(account => (0, _keyringApi.isEvmAccountType)(account.type));
  const evmAccountAddresses = evmAccounts.map(account => account.address);

  // Check and clean up tokens in allTokens that do not belong to any EVM account
  if ((0, _utils.hasProperty)(tokensControllerState, 'allTokens')) {
    for (const chainId of Object.keys(tokensControllerState.allTokens)) {
      const tokensByAccounts = tokensControllerState.allTokens[chainId];
      for (const account of Object.keys(tokensByAccounts)) {
        if (!evmAccountAddresses.includes(account)) {
          delete tokensControllerState.allTokens[chainId][account];
        }
      }
    }
  }

  // Check and clean up tokens in allDetectedTokens that do not belong to any EVM account
  if ((0, _utils.hasProperty)(tokensControllerState, 'allDetectedTokens')) {
    for (const chainId of Object.keys(tokensControllerState.allDetectedTokens)) {
      const tokensByAccounts = tokensControllerState.allDetectedTokens[chainId];
      for (const account of Object.keys(tokensByAccounts)) {
        if (!evmAccountAddresses.includes(account)) {
          delete tokensControllerState.allDetectedTokens[chainId][account];
        }
      }
    }
  }

  // Check and clean up tokens in allIgnoredTokens that do not belong to any EVM account
  if ((0, _utils.hasProperty)(tokensControllerState, 'allIgnoredTokens')) {
    for (const chainId of Object.keys(tokensControllerState.allIgnoredTokens)) {
      const tokensByAccounts = tokensControllerState.allIgnoredTokens[chainId];
      for (const account of Object.keys(tokensByAccounts)) {
        if (!evmAccountAddresses.includes(account)) {
          delete tokensControllerState.allIgnoredTokens[chainId][account];
        }
      }
    }
  }

  // Check and clean up balances in tokenBalancesControllerState that do not belong to any EVM account
  if ((0, _utils.hasProperty)(tokenBalancesControllerState, 'tokenBalances')) {
    for (const accountAddress of Object.keys(tokenBalancesControllerState.tokenBalances)) {
      if (!evmAccountAddresses.includes(accountAddress)) {
        delete tokenBalancesControllerState.tokenBalances[accountAddress];
      }
    }
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\162.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\163.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C163.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
var _utils = require("@metamask/utils");
const version = exports.version = 163;

/**
 * This migration removes the `tokens`, `detectedTokens`, and `ignoredTokens` properties from the TokensController state for users who do not have tokenListController state.
 *
 * If the TokensController is not found or is not an object, the migration logs an error,
 * but otherwise leaves the state unchanged.
 *
 * @param originalVersionedData - The versioned extension state.
 * @returns The updated versioned extension state without the tokens property.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  versionedData.data = transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  // If property TokensController is not present, only log a warning and return the original state.
  if (!(0, _utils.hasProperty)(state, 'TokensController')) {
    console.warn(`newState.TokensController is not present`);
    return state;
  }
  const tokensControllerState = state.TokensController;

  // If property tokensControllerState is there but not an object, capture a sentry error and return state
  if (!(0, _utils.isObject)(tokensControllerState)) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`Migration ${version}: TokensController is type '${typeof tokensControllerState}', expected object.`));
    return state;
  }
  if ((0, _utils.hasProperty)(tokensControllerState, 'tokens')) {
    // Remove the tokens property from the TokensController state.
    delete tokensControllerState.tokens;
  }
  if ((0, _utils.hasProperty)(tokensControllerState, 'detectedTokens')) {
    // Remove the detectedTokens property from the TokensController state.
    delete tokensControllerState.detectedTokens;
  }
  if ((0, _utils.hasProperty)(tokensControllerState, 'ignoredTokens')) {
    // Remove the ignoredTokens property from the TokensController state.
    delete tokensControllerState.ignoredTokens;
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\163.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\164.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C164.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
var _utils = require("@metamask/utils");
const version = exports.version = 164;

// In-lined from @metamask/chain-agnostic-permission
const Caip25CaveatType = 'authorizedScopes';
const Caip25EndowmentPermissionName = 'endowment:caip25';
/**
 * This migration removes from the PermissionController state all permission scopes that reference deleted networks.
 *
 * Specifically, it cleans up `endowment:caip25` permissions by removing any chain-specific scopes (like `eip155:1337`)
 * that reference networks that no longer exist in the NetworkController's `networkConfigurationsByChainId`.
 *
 * If the required controllers are not found or are not objects, the migration logs an error,
 * but otherwise leaves the state unchanged.
 *
 * @param originalVersionedData - The versioned extension state.
 * @returns The updated versioned extension state without orphaned network permissions.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  versionedData.data = transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if (!(0, _utils.hasProperty)(state, 'PermissionController')) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`Migration ${version}: PermissionController not found.`));
    return state;
  }
  if (!(0, _utils.hasProperty)(state, 'NetworkController')) {
    var _global$sentry2, _global$sentry2$captu;
    (_global$sentry2 = global.sentry) === null || _global$sentry2 === void 0 || (_global$sentry2$captu = _global$sentry2.captureException) === null || _global$sentry2$captu === void 0 || _global$sentry2$captu.call(_global$sentry2, new Error(`Migration ${version}: NetworkController not found.`));
    return state;
  }
  const permissionControllerState = state.PermissionController;
  const networkControllerState = state.NetworkController;
  if (!(0, _utils.isObject)(permissionControllerState)) {
    var _global$sentry3, _global$sentry3$captu;
    (_global$sentry3 = global.sentry) === null || _global$sentry3 === void 0 || (_global$sentry3$captu = _global$sentry3.captureException) === null || _global$sentry3$captu === void 0 || _global$sentry3$captu.call(_global$sentry3, new Error(`Migration ${version}: PermissionController is type '${typeof permissionControllerState}', expected object.`));
    return state;
  }
  if (!(0, _utils.isObject)(networkControllerState)) {
    var _global$sentry4, _global$sentry4$captu;
    (_global$sentry4 = global.sentry) === null || _global$sentry4 === void 0 || (_global$sentry4$captu = _global$sentry4.captureException) === null || _global$sentry4$captu === void 0 || _global$sentry4$captu.call(_global$sentry4, new Error(`Migration ${version}: NetworkController is type '${typeof networkControllerState}', expected object.`));
    return state;
  }
  if (!(0, _utils.hasProperty)(networkControllerState, 'networkConfigurationsByChainId')) {
    var _global$sentry5, _global$sentry5$captu;
    (_global$sentry5 = global.sentry) === null || _global$sentry5 === void 0 || (_global$sentry5$captu = _global$sentry5.captureException) === null || _global$sentry5$captu === void 0 || _global$sentry5$captu.call(_global$sentry5, new Error(`Migration ${version}: NetworkController.networkConfigurationsByChainId not found.`));
    return state;
  }
  const {
    networkConfigurationsByChainId
  } = networkControllerState;
  if (!(0, _utils.isObject)(networkConfigurationsByChainId)) {
    var _global$sentry6, _global$sentry6$captu;
    (_global$sentry6 = global.sentry) === null || _global$sentry6 === void 0 || (_global$sentry6$captu = _global$sentry6.captureException) === null || _global$sentry6$captu === void 0 || _global$sentry6$captu.call(_global$sentry6, new Error(`Migration ${version}: NetworkController.networkConfigurationsByChainId is type '${typeof networkConfigurationsByChainId}', expected object.`));
    return state;
  }

  // Get the list of valid chain IDs
  const validChainIds = Object.keys(networkConfigurationsByChainId);

  // Convert hex chain IDs to decimal format for EIP-155 comparison (e.g., "0x1" -> "eip155:1")
  const validEip155ChainIds = validChainIds.map(chainId => {
    const decimal = parseInt(chainId, 16);
    return `eip155:${decimal}`;
  });
  if (!(0, _utils.hasProperty)(permissionControllerState, 'subjects')) {
    // No subjects to clean up
    return state;
  }
  const {
    subjects
  } = permissionControllerState;
  if (!(0, _utils.isObject)(subjects)) {
    var _global$sentry7, _global$sentry7$captu;
    (_global$sentry7 = global.sentry) === null || _global$sentry7 === void 0 || (_global$sentry7$captu = _global$sentry7.captureException) === null || _global$sentry7$captu === void 0 || _global$sentry7$captu.call(_global$sentry7, new Error(`Migration ${version}: PermissionController.subjects is type '${typeof subjects}', expected object.`));
    return state;
  }

  // Clean up permissions for each subject
  for (const subjectKey of Object.keys(subjects)) {
    const subject = subjects[subjectKey];
    if (!(0, _utils.isObject)(subject)) {
      continue;
    }
    if (!(0, _utils.hasProperty)(subject, 'permissions') || !(0, _utils.isObject)(subject.permissions)) {
      continue;
    }
    const {
      permissions
    } = subject;

    // Check if this subject has CAIP-25 permissions
    if (!(0, _utils.hasProperty)(permissions, Caip25EndowmentPermissionName)) {
      continue;
    }
    const caip25Permission = permissions[Caip25EndowmentPermissionName];
    if (!(0, _utils.isObject)(caip25Permission)) {
      continue;
    }
    if (!(0, _utils.hasProperty)(caip25Permission, 'caveats') || !Array.isArray(caip25Permission.caveats)) {
      continue;
    }

    // Find and clean up the authorizedScopes caveat
    for (const caveat of caip25Permission.caveats) {
      if (!(0, _utils.isObject)(caveat) || caveat.type !== Caip25CaveatType) {
        continue;
      }
      if (!(0, _utils.hasProperty)(caveat, 'value') || !(0, _utils.isObject)(caveat.value)) {
        continue;
      }
      const caveatValue = caveat.value;

      // Clean up requiredScopes
      if ((0, _utils.isObject)(caveatValue.requiredScopes)) {
        for (const scopeKey of Object.keys(caveatValue.requiredScopes)) {
          // Skip wallet scopes and other non-chain-specific scopes
          if (scopeKey.startsWith('wallet:') || !scopeKey.startsWith('eip155:')) {
            continue;
          }

          // Remove if this chain ID is not in the valid list
          if (!validEip155ChainIds.includes(scopeKey)) {
            delete caveatValue.requiredScopes[scopeKey];
          }
        }
      }

      // Clean up optionalScopes
      if ((0, _utils.isObject)(caveatValue.optionalScopes)) {
        for (const scopeKey of Object.keys(caveatValue.optionalScopes)) {
          // Skip wallet scopes and other non-chain-specific scopes
          if (scopeKey.startsWith('wallet:') || !scopeKey.startsWith('eip155:')) {
            continue;
          }

          // Remove if this chain ID is not in the valid list
          if (!validEip155ChainIds.includes(scopeKey)) {
            delete caveatValue.optionalScopes[scopeKey];
          }
        }
      }
    }
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\164.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\165.ts", {"@metamask/snaps-rpc-methods":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","cron-parser":"D:\\code\\v\\metamask-extension\\node_modules\\cron-parser\\lib\\parser.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","luxon":"D:\\code\\v\\metamask-extension\\node_modules\\luxon\\build\\cjs-browser\\luxon.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C165.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExecutionDate = getExecutionDate;
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
var _utils = require("@metamask/utils");
var _luxon = require("luxon");
var _cronParser = require("cron-parser");
var _snapsUtils = require("@metamask/snaps-utils");
var _snapsRpcMethods = require("@metamask/snaps-rpc-methods");
/**
 * The versioned data containing the extension state and metadata.
 */

const version = exports.version = 165;

/**
 * This migration updates the `CronjobController` state to remove the `jobs`
 * property from state and combine it with the `events` property. It also adds
 * new properties to the state to support the new `CronjobController` API.
 *
 * @param originalVersionedData - The versioned extension state.
 * @returns The updated versioned extension state without the tokens property.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  versionedData.data = transformState(versionedData.data);
  return versionedData;
}

/**
 * Represents a background event that is scheduled to be executed by the
 * cronjob controller.
 */

/**
 * A cronjob caveat value that contains the jobs to be executed by the
 * cronjob controller.
 */

/**
 * Get the next execution date from a schedule, which should be either:
 *
 * - An ISO 8601 date string, or
 * - A cron expression.
 *
 * @param schedule - The schedule of the event.
 * @returns The parsed ISO 8601 date at which the event should be executed.
 */
// TODO: Export this function from the `@metamask/snaps-controllers` package?
function getExecutionDate(schedule) {
  const date = _luxon.DateTime.fromISO(schedule, {
    setZone: true
  });
  if (date.isValid) {
    const now = Date.now();

    // We round to the nearest second to avoid milliseconds in the output.
    const roundedDate = date.toUTC().startOf('second');
    if (roundedDate.toMillis() < now) {
      throw new Error('Cannot schedule an event in the past.');
    }
    return roundedDate.toISO({
      suppressMilliseconds: true
    });
  }
  try {
    const parsed = (0, _cronParser.parseExpression)(schedule, {
      utc: true
    });
    const next = parsed.next();
    const nextDate = _luxon.DateTime.fromJSDate(next.toDate());
    (0, _utils.assert)(nextDate.isValid);
    return nextDate.toUTC().toISO();
  } catch {
    throw new Error(`Unable to parse "${schedule}" as ISO 8601 date, ISO 8601 duration, or cron expression.`);
  }
}

/**
 * Transform the state of the `CronjobController` to the new unified format.
 * This migration removes the `jobs` property and combines it with the
 * `events` property. It also ensures that the state is in the correct
 * format for the new `CronjobController` API.
 *
 * @param state - The MetaMask extension state.
 * @returns The updated MetaMask extension state with the transformed
 * `CronjobController` state.
 */
function transformState(state) {
  if (!(0, _utils.hasProperty)(state, 'CronjobController') || !(0, _utils.isObject)(state.CronjobController)) {
    console.warn(`Skipping migration ${version}: \`CronjobController\` state not found or is not an object.`);
    return state;
  }
  if (!(0, _utils.hasProperty)(state, 'PermissionController') || !(0, _utils.isObject)(state.PermissionController)) {
    console.warn(new Error(`Skipping migration ${version}: \`PermissionController\` state not found or is not an object.`));
    return state;
  }
  const cronjobControllerState = state.CronjobController;
  const permissionControllerState = state.PermissionController;

  // New events object created from the legacy jobs.
  const eventsFromJobs = Object.fromEntries(Object.values(permissionControllerState.subjects).filter(subject => (0, _snapsUtils.isSnapId)(subject.origin) && subject.permissions[_snapsRpcMethods.SnapEndowments.Cronjob]).flatMap(subject => {
    const {
      caveats
    } = subject.permissions[_snapsRpcMethods.SnapEndowments.Cronjob];
    if (!Array.isArray(caveats)) {
      return [];
    }
    const cronjobCaveat = caveats.find(caveat => caveat.type === _snapsUtils.SnapCaveatType.SnapCronjob);
    if (!(cronjobCaveat !== null && cronjobCaveat !== void 0 && cronjobCaveat.value) || !(0, _utils.isPlainObject)(cronjobCaveat.value) || !(0, _utils.hasProperty)(cronjobCaveat.value, 'jobs') || !Array.isArray(cronjobCaveat.value.jobs)) {
      return [];
    }
    const jobs = cronjobCaveat.value.jobs;
    return jobs.map(({
      expression,
      request
    }, index) => {
      var _cronjobControllerSta;
      const legacyId = `${subject.origin}-${index}`;
      const {
        lastRun
      } = ((_cronjobControllerSta = cronjobControllerState.jobs) === null || _cronjobControllerSta === void 0 ? void 0 : _cronjobControllerSta[legacyId]) ?? {
        lastRun: 0
      };

      // If the cronjob is scheduled to run in the past, we use the
      // last run time to determine the next execution date. This will ensure
      // that the cronjob controller runs the job immediately.
      const parsed = (0, _cronParser.parseExpression)(expression);
      const date = parsed.hasPrev() && parsed.prev().getTime() > lastRun ? parsed.prev().toISOString() : getExecutionDate(expression);
      return {
        id: `cronjob-${subject.origin}-${index}`,
        recurring: true,
        schedule: expression,
        scheduledAt: new Date().toISOString(),
        snapId: subject.origin,
        date,
        request
      };
    });
  }).map(event => [event.id, event]));

  // New events object created from the legacy events.
  const eventsFromLegacyEvents = Object.fromEntries(Object.entries(cronjobControllerState.events ?? {}).map(([id, event]) => {
    return [id, {
      ...event,
      // Legacy background events are never recurring.
      recurring: false,
      // We don't know the original schedule, so we use the parsed date.
      // It's not used for non-recurring events anyway.
      schedule: event.date
    }];
  }));
  cronjobControllerState.events = {
    ...eventsFromLegacyEvents,
    ...eventsFromJobs
  };
  delete cronjobControllerState.jobs;
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\165.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\166.ts", {"../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C166.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBaseNetworkConfiguration = getBaseNetworkConfiguration;
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
var _utils = require("@metamask/utils");
var _network = require("../../../shared/constants/network");
const version = exports.version = 166;

/**
 * This migration adds Base network to the `NetworkController` as it is enabled by default.
 * - It modifies the `NetworkController.state.networkConfigurationsByChainId` to include Base network.
 *
 * @param originalVersionedData - The versioned extension state.
 * @returns The updated versioned extension state with base network added
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  versionedData.data = transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if (!(0, _utils.hasProperty)(state, 'NetworkController')) {
    console.warn(`Migration ${version}: NetworkController not found.`);
    return state;
  }
  const networkState = state.NetworkController;
  if (!(0, _utils.isObject)(networkState)) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`Migration ${version}: NetworkController is not an object: ${typeof networkState}`));
    return state;
  }
  if (!(0, _utils.hasProperty)(networkState, 'networkConfigurationsByChainId')) {
    var _global$sentry2, _global$sentry2$captu;
    (_global$sentry2 = global.sentry) === null || _global$sentry2 === void 0 || (_global$sentry2$captu = _global$sentry2.captureException) === null || _global$sentry2$captu === void 0 || _global$sentry2$captu.call(_global$sentry2, new Error(`Migration ${version}: NetworkController missing property networkConfigurationsByChainId.`));
    return state;
  }
  if (!(0, _utils.isObject)(networkState.networkConfigurationsByChainId)) {
    var _global$sentry3, _global$sentry3$captu;
    (_global$sentry3 = global.sentry) === null || _global$sentry3 === void 0 || (_global$sentry3$captu = _global$sentry3.captureException) === null || _global$sentry3$captu === void 0 || _global$sentry3$captu.call(_global$sentry3, new Error(`Migration ${version}: NetworkController.networkConfigurationsByChainId is not an object: ${typeof networkState.networkConfigurationsByChainId}.`));
    return state;
  }

  // User already has base network added
  if (networkState.networkConfigurationsByChainId[_network.CHAIN_IDS.BASE]) {
    return state;
  }
  networkState.networkConfigurationsByChainId[_network.CHAIN_IDS.BASE] = getBaseNetworkConfiguration();
  return state;
}

// Exported for testing purposes
function getBaseNetworkConfiguration() {
  return {
    blockExplorerUrls: [],
    chainId: '0x2105',
    // toHex(8453) Base Network
    defaultRpcEndpointIndex: 0,
    name: 'Base Mainnet',
    nativeCurrency: 'ETH',
    rpcEndpoints: [{
      failoverUrls: (0, _network.getFailoverUrlsForInfuraNetwork)('base-mainnet'),
      networkClientId: 'base-mainnet',
      type: 'infura',
      url: 'https://base-mainnet.infura.io/v3/{infuraProjectId}'
    }]
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\166.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\167.ts", {"../../../shared/lib/manifestFlags":"D:\\code\\v\\metamask-extension\\shared\\lib\\manifestFlags.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C167.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
var _utils = require("@metamask/utils");
var _manifestFlags = require("../../../shared/lib/manifestFlags");
const version = exports.version = 167;

/**
 * This migration sets `isBackupAndSyncEnabled` and `isAccountSyncingEnabled` to true for all users.
 *
 * If the UserStorageController is not found or is not an object, the migration logs an error,
 * but otherwise leaves the state unchanged.
 *
 * @param originalVersionedData - The versioned extension state.
 * @returns The updated versioned extension state without the tokens property.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  versionedData.data = transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  var _getManifestFlags$tes;
  // If property UserStorageController is not present, only log a warning and return the original state.
  if (!(0, _utils.hasProperty)(state, 'UserStorageController')) {
    console.warn(`newState.UserStorageController is not present`);
    return state;
  }
  const userStorageControllerState = state.UserStorageController;

  // If property userStorageControllerState is there but not an object, capture a sentry error and return state
  if (!(0, _utils.isObject)(userStorageControllerState)) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`Migration ${version}: UserStorageController is type '${typeof userStorageControllerState}', expected object.`));
    return state;
  }
  if ((0, _utils.hasProperty)(userStorageControllerState, 'isBackupAndSyncEnabled')) {
    // Set isBackupAndSyncEnabled to true for all users.
    userStorageControllerState.isBackupAndSyncEnabled = true;
  }
  if ((0, _utils.hasProperty)(userStorageControllerState, 'isAccountSyncingEnabled')) {
    // Set isAccountSyncingEnabled to true for all users.
    userStorageControllerState.isAccountSyncingEnabled = true;
  }

  // If we are using `yarn start:with-state` or running an E2E test with generateWalletState, disable all syncing
  if (null || (_getManifestFlags$tes = (0, _manifestFlags.getManifestFlags)().testing) !== null && _getManifestFlags$tes !== void 0 && _getManifestFlags$tes.disableSync) {
    userStorageControllerState.isBackupAndSyncEnabled = false;
    userStorageControllerState.isAccountSyncingEnabled = false;
    userStorageControllerState.isProfileSyncingEnabled = false;
    userStorageControllerState.isContactSyncingEnabled = false;
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\167.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\168.1.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C168.1.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 168.1;

/**
 * This migration removes the `permissionActivityLog` state
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if ((0, _utils.hasProperty)(state, 'PermissionLogController') && (0, _utils.isObject)(state.PermissionLogController) && (0, _utils.hasProperty)(state.PermissionLogController, 'permissionActivityLog')) {
    delete state.PermissionLogController.permissionActivityLog;
  } else {
    console.warn(`Migration ${version}: 'PermissionLogController.permissionActivityLog' state not found, skipping migration.`);
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\168.1.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\168.ts", {"lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C168.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
const version = exports.version = 168;

/**
 * This migration sets the preference `smartAccountOptIn` to false for existing users.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  const preferencesControllerState = state === null || state === void 0 ? void 0 : state.PreferencesController;
  const preferences = preferencesControllerState === null || preferencesControllerState === void 0 ? void 0 : preferencesControllerState.preferences;
  if (preferences) {
    preferences.smartAccountOptIn = false;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\168.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\169.ts", {"lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C169.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
const version = exports.version = 169;

/**
 * This migration assigns the value of AppStateController `upgradeSplashPageAcknowledgedForAccounts`
 * to PreferencesController preference `smartAccountOptInForAccounts`.
 * And also deletes the AppStateController `upgradeSplashPageAcknowledgedForAccounts`.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  const preferencesControllerState = state === null || state === void 0 ? void 0 : state.PreferencesController;
  const appStateControllerState = state === null || state === void 0 ? void 0 : state.AppStateController;
  if (preferencesControllerState !== null && preferencesControllerState !== void 0 && preferencesControllerState.preferences && appStateControllerState !== null && appStateControllerState !== void 0 && appStateControllerState.upgradeSplashPageAcknowledgedForAccounts) {
    preferencesControllerState.preferences.smartAccountOptInForAccounts = appStateControllerState === null || appStateControllerState === void 0 ? void 0 : appStateControllerState.upgradeSplashPageAcknowledgedForAccounts;
  }
  if (appStateControllerState !== null && appStateControllerState !== void 0 && appStateControllerState.upgradeSplashPageAcknowledgedForAccounts) {
    appStateControllerState === null || appStateControllerState === void 0 || delete appStateControllerState.upgradeSplashPageAcknowledgedForAccounts;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\169.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\170.1.ts", {"lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C170.1.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
const version = exports.version = 170.1;

/**
 * This migration deletes the preference `smartAccountOptInForAccounts`.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  var _preferencesControlle;
  const preferencesControllerState = state === null || state === void 0 ? void 0 : state.PreferencesController;
  if (preferencesControllerState !== null && preferencesControllerState !== void 0 && (_preferencesControlle = preferencesControllerState.preferences) !== null && _preferencesControlle !== void 0 && _preferencesControlle.smartAccountOptInForAccounts) {
    delete preferencesControllerState.preferences.smartAccountOptInForAccounts;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\170.1.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\170.2.ts", {"../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","@metamask/network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C170.2.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _networkController = require("@metamask/network-controller");
var _lodash = require("lodash");
var _network = require("../../../shared/constants/network");
const version = exports.version = 170.2;
const BSC_CHAIN_ID = '0x38';

/**
 * Replace all occurrences of "https://bsc-dataseed.binance.org" with
 * "https://bsc-mainnet.infura.io/v3/${infuraProjectId}" in the BSC network configuration,
 * if the user already relies on at least one Infura RPC endpoint.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  versionedData.data = transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if ((0, _utils.hasProperty)(state, 'NetworkController') && (0, _utils.isObject)(state.NetworkController) && (0, _utils.hasProperty)(state.NetworkController, 'networkConfigurationsByChainId') && (0, _utils.isObject)(state.NetworkController.networkConfigurationsByChainId)) {
    const {
      networkConfigurationsByChainId
    } = state.NetworkController;

    // Check if at least one network uses an Infura RPC endpoint, excluding testnets
    const usesInfura = Object.entries(networkConfigurationsByChainId).filter(([chainId]) => ![..._network.infuraChainIdsTestNets, _network.CHAIN_IDS.LINEA_MAINNET].includes(chainId)).some(([, networkConfig]) => {
      var _networkConfig$rpcEnd;
      if (!(0, _utils.isObject)(networkConfig) || !Array.isArray(networkConfig.rpcEndpoints) || typeof networkConfig.defaultRpcEndpointIndex !== 'number') {
        return false;
      }

      // Get the default RPC endpoint used by the network
      const defaultRpcEndpoint = networkConfig === null || networkConfig === void 0 || (_networkConfig$rpcEnd = networkConfig.rpcEndpoints) === null || _networkConfig$rpcEnd === void 0 ? void 0 : _networkConfig$rpcEnd[networkConfig === null || networkConfig === void 0 ? void 0 : networkConfig.defaultRpcEndpointIndex];
      if (!(0, _utils.isObject)(defaultRpcEndpoint) || typeof defaultRpcEndpoint.url !== 'string') {
        return false;
      }
      try {
        const urlHost = new URL(defaultRpcEndpoint.url).host;
        return defaultRpcEndpoint.type === _networkController.RpcEndpointType.Infura || _network.allowedInfuraHosts.includes(urlHost);
      } catch {
        return false;
      }
    });
    if (!usesInfura) {
      // If no Infura endpoints are used, return the state unchanged
      return state;
    }

    // Check for BSC network configuration (chainId 56 / 0x38)
    const bscNetworkConfig = networkConfigurationsByChainId[BSC_CHAIN_ID];
    if ((0, _utils.isObject)(bscNetworkConfig)) {
      const {
        rpcEndpoints
      } = bscNetworkConfig;
      if (Array.isArray(rpcEndpoints)) {
        // Find the first occurrence of "https://bsc-dataseed.binance.org/"
        const index = rpcEndpoints.findIndex(endpoint => (0, _utils.isObject)(endpoint) && endpoint.url === 'https://bsc-dataseed.binance.org/');
        if (index !== -1) {
          // Replace the URL with the new Infura URL
          rpcEndpoints[index] = {
            ...rpcEndpoints[index],
            url: `https://bsc-mainnet.infura.io/v3/${_network.infuraProjectId}`
          };

          // Update the configuration
          networkConfigurationsByChainId[BSC_CHAIN_ID] = {
            ...bscNetworkConfig,
            rpcEndpoints
          };
          return {
            ...state,
            NetworkController: {
              ...state.NetworkController,
              networkConfigurationsByChainId
            }
          };
        }
      }
    }
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\170.2.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\170.ts", {"lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C170.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
const version = exports.version = 170;

/**
 * This migration deletes the preference `disabledUpgradeAccountsByChain`, `accountUpgradeDisabledChains` if the user has
 * existing data.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  const preferencesControllerState = state === null || state === void 0 ? void 0 : state.PreferencesController;
  preferencesControllerState === null || preferencesControllerState === void 0 || delete preferencesControllerState.disabledUpgradeAccountsByChain;
  preferencesControllerState === null || preferencesControllerState === void 0 || delete preferencesControllerState.accountUpgradeDisabledChains;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\170.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\171.ts", {"@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C171.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
var _utils = require("@metamask/utils");
var _bridgeController = require("@metamask/bridge-controller");
const version = exports.version = 171;

/**
 * This migration migrates tokenNetworkFilter from preferences to enabledNetworkMap.
 *
 * For existing users with tokenNetworkFilter:
 * - The tokenNetworkFilter data will be migrated to enabledNetworkMap
 *
 * For users without tokenNetworkFilter:
 * - No migration will occur (enabledNetworkMap will remain unchanged)
 *
 * @param originalVersionedData - The versioned extension state.
 * @returns The updated versioned extension state with enabledNetworkMap populated from tokenNetworkFilter.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  versionedData.data = transformState(versionedData.data);
  return versionedData;
}

/**
 * Validates that a property exists and is an object
 *
 * @param obj - The object to validate
 * @param propertyName - The name of the property to check
 * @param context - The context for error messages
 * @returns True if the property exists and is an object, false otherwise
 */
function validateObjectProperty(obj, propertyName, context) {
  if (!(0, _utils.hasProperty)(obj, propertyName)) {
    return false;
  }
  if (!(0, _utils.isObject)(obj[propertyName])) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`Migration ${version}: ${propertyName} is type '${typeof obj[propertyName]}', expected object in ${context}.`));
    return false;
  }
  return true;
}

/**
 * Creates enabledNetworkMap from tokenNetworkFilter for EVM networks
 *
 * @param tokenNetworkFilter - The token network filter object
 * @returns The enabled network map for EVM networks
 */
function createEvmEnabledNetworkMap(tokenNetworkFilter) {
  const caipChainId = (0, _bridgeController.formatChainIdToCaip)(Object.keys(tokenNetworkFilter)[0]);
  const {
    namespace: chainNamespace
  } = (0, _utils.parseCaipChainId)(caipChainId);
  const enabledNetworkMap = {
    [chainNamespace]: {
      ...tokenNetworkFilter
    }
  };
  return enabledNetworkMap;
}

/**
 * Creates enabledNetworkMap for non-EVM networks
 *
 * @param selectedMultichainNetworkChainId - The selected multichain network chain ID
 * @returns The enabled network map for non-EVM networks
 */
function createNonEvmEnabledNetworkMap(selectedMultichainNetworkChainId) {
  const caipChainId = (0, _bridgeController.formatChainIdToCaip)(selectedMultichainNetworkChainId);
  const {
    namespace: chainNamespace
  } = (0, _utils.parseCaipChainId)(caipChainId);
  const enabledNetworkMap = {
    [chainNamespace]: {
      [selectedMultichainNetworkChainId]: true
    }
  };
  return enabledNetworkMap;
}
function transformState(state) {
  // Validate NetworkOrderController
  if (!validateObjectProperty(state, 'NetworkOrderController', 'state')) {
    return state;
  }
  const networkOrderControllerState = state.NetworkOrderController;

  // Validate PreferencesController
  if (!validateObjectProperty(state, 'PreferencesController', 'state')) {
    return state;
  }
  const preferencesControllerState = state.PreferencesController;

  // Validate preferences
  if (!validateObjectProperty(preferencesControllerState, 'preferences', 'PreferencesController')) {
    return state;
  }
  const {
    preferences
  } = preferencesControllerState;

  // Check if tokenNetworkFilter exists (optional for this migration)
  if (!(0, _utils.hasProperty)(preferences, 'tokenNetworkFilter')) {
    return state;
  }
  const {
    tokenNetworkFilter
  } = preferences;

  // Validate tokenNetworkFilter
  if (!(0, _utils.isObject)(tokenNetworkFilter)) {
    var _global$sentry2, _global$sentry2$captu;
    (_global$sentry2 = global.sentry) === null || _global$sentry2 === void 0 || (_global$sentry2$captu = _global$sentry2.captureException) === null || _global$sentry2$captu === void 0 || _global$sentry2$captu.call(_global$sentry2, new Error(`Migration ${version}: tokenNetworkFilter is type '${typeof tokenNetworkFilter}', expected object.`));
    return state;
  }
  if (Object.keys(tokenNetworkFilter).length === 0) {
    var _global$sentry3, _global$sentry3$captu;
    (_global$sentry3 = global.sentry) === null || _global$sentry3 === void 0 || (_global$sentry3$captu = _global$sentry3.captureException) === null || _global$sentry3$captu === void 0 || _global$sentry3$captu.call(_global$sentry3, new Error(`Migration ${version}: tokenNetworkFilter is empty, expected at least one network configuration.`));
    return state;
  }
  const {
    MultichainNetworkController: multichainNetworkControllerState
  } = state;
  if (!(0, _utils.isObject)(multichainNetworkControllerState)) {
    var _global$sentry4, _global$sentry4$captu;
    (_global$sentry4 = global.sentry) === null || _global$sentry4 === void 0 || (_global$sentry4$captu = _global$sentry4.captureException) === null || _global$sentry4$captu === void 0 || _global$sentry4$captu.call(_global$sentry4, new Error());
    return state;
  }

  // Extract required state properties
  const {
    selectedMultichainNetworkChainId
  } = multichainNetworkControllerState;

  // Validate selectedMultichainNetworkChainId
  if (!selectedMultichainNetworkChainId || typeof selectedMultichainNetworkChainId !== 'string') {
    var _global$sentry5, _global$sentry5$captu;
    (_global$sentry5 = global.sentry) === null || _global$sentry5 === void 0 || (_global$sentry5$captu = _global$sentry5.captureException) === null || _global$sentry5$captu === void 0 || _global$sentry5$captu.call(_global$sentry5, new Error(`Migration ${version}: selectedMultichainNetworkChainId is type '${typeof selectedMultichainNetworkChainId}', expected string.`));
    return state;
  }

  // Create enabledNetworkMap by merging both EVM and non-EVM networks
  const evmEnabledNetworkMap = createEvmEnabledNetworkMap(tokenNetworkFilter);
  const nonEvmEnabledNetworkMap = createNonEvmEnabledNetworkMap(selectedMultichainNetworkChainId);

  // Merge both maps
  networkOrderControllerState.enabledNetworkMap = {
    ...evmEnabledNetworkMap,
    ...nonEvmEnabledNetworkMap
  };
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\171.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\172.ts", {"lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C172.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
const version = exports.version = 172;

/**
 * This migration adds the `tracesBeforeMetricsOptIn` property to the MetaMetrics Controller state.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  const metaMetricsControllerState = state === null || state === void 0 ? void 0 : state.MetaMetricsController;
  if (metaMetricsControllerState && !metaMetricsControllerState.tracesBeforeMetricsOptIn) {
    metaMetricsControllerState.tracesBeforeMetricsOptIn = [];
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\172.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\173.ts", {"../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C173.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
var _network = require("../../../shared/constants/network");
const version = exports.version = 173;

/**
 * This migration updates the SEI network name from `Sei Network` to `Sei Mainnet`.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  const fromName = 'Sei Network';
  const toName = 'Sei Mainnet';
  const seiChainId = _network.CHAIN_IDS.SEI;

  // We only update the network name if it exists in the state
  // and matches the expected chain ID and name.
  if ((0, _utils.hasProperty)(state, 'NetworkController') && (0, _utils.isObject)(state.NetworkController) && (0, _utils.isObject)(state.NetworkController.networkConfigurationsByChainId) && (0, _utils.hasProperty)(state.NetworkController.networkConfigurationsByChainId, seiChainId) && (0, _utils.isObject)(state.NetworkController.networkConfigurationsByChainId[seiChainId]) && (0, _utils.hasProperty)(state.NetworkController.networkConfigurationsByChainId[seiChainId], 'name') && state.NetworkController.networkConfigurationsByChainId[seiChainId].name === fromName) {
    state.NetworkController.networkConfigurationsByChainId[seiChainId].name = toName;
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\173.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\174.ts", {"../../../shared/lib/sentry":"D:\\code\\v\\metamask-extension\\shared\\lib\\sentry.ts","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C174.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _bridgeController = require("@metamask/bridge-controller");
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
var _sentry = require("../../../shared/lib/sentry");
const version = exports.version = 174;

/**
 * This migration fixes txHistory entries that were added with keys that were not valid
 * Solana tx signatures.
 *
 * For existing txs with invalid keys, the migration will remove the txHistory entry and add
 * it back with a valid key.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  versionedData.data = transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  const bridgeStatusControllerState = state === null || state === void 0 ? void 0 : state.BridgeStatusController;
  if (!(0, _utils.isObject)(bridgeStatusControllerState)) {
    return state;
  }
  const {
    txHistory
  } = bridgeStatusControllerState;
  if (!(0, _utils.isObject)(txHistory)) {
    return state;
  }
  try {
    Object.entries(txHistory).forEach(([key, historyItem]) => {
      var _historyItem$status, _historyItem$status2;
      const isSolanaTx = (0, _bridgeController.isSolanaChainId)((_historyItem$status = historyItem.status) === null || _historyItem$status === void 0 || (_historyItem$status = _historyItem$status.srcChain) === null || _historyItem$status === void 0 ? void 0 : _historyItem$status.chainId);
      const newId = (_historyItem$status2 = historyItem.status) === null || _historyItem$status2 === void 0 || (_historyItem$status2 = _historyItem$status2.srcChain) === null || _historyItem$status2 === void 0 ? void 0 : _historyItem$status2.txHash;
      if (isSolanaTx && newId && newId !== key) {
        txHistory[newId] = {
          ...historyItem,
          txMetaId: newId
        };
        delete txHistory[key];
      }
    });
    return state;
  } catch (error) {
    (0, _sentry.captureException)(new Error(`Migration ${version}: Failed to update bridge txHistory for solana to use txHash as key and txMetaId. Error: ${error.message}`));
    return state;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\174.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\175.ts", {"../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../shared/lib/sentry":"D:\\code\\v\\metamask-extension\\shared\\lib\\sentry.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C175.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
var _network = require("../../../shared/constants/network");
var _sentry = require("../../../shared/lib/sentry");
const version = exports.version = 175;

/**
 * This migration updates the native currency to FRAX for the FRAX network configuration.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  versionedData.data = transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  try {
    const FRAX_TESTNET = '0x9da';
    const networkControllerState = state.NetworkController;
    if ((0, _utils.hasProperty)(state, 'NetworkController') && (0, _utils.isObject)(networkControllerState) && (0, _utils.hasProperty)(networkControllerState, 'networkConfigurationsByChainId') && (0, _utils.isObject)(networkControllerState.networkConfigurationsByChainId)) {
      for (const networkConfiguration of Object.values(networkControllerState.networkConfigurationsByChainId)) {
        if ((0, _utils.isObject)(networkConfiguration) && (networkConfiguration.chainId === _network.CHAIN_IDS.FRAX || networkConfiguration.chainId === FRAX_TESTNET)) {
          // update nativeCurrency to FRAX
          if ((0, _utils.hasProperty)(networkConfiguration, 'nativeCurrency')) {
            networkConfiguration.nativeCurrency = 'FRAX';
          }
        }
      }
    }
    return state;
  } catch (error) {
    (0, _sentry.captureException)(new Error(`Migration ${version}: Failed to update native currency for FRAX network configuration. Error: ${error.message}`));
    return state;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\175.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\176.1.ts", {"../../../shared/lib/sentry":"D:\\code\\v\\metamask-extension\\shared\\lib\\sentry.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C176.1.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
var _sentry = require("../../../shared/lib/sentry");
const version = exports.version = 176.1;

/**
 * This migration clears the legacy addressSecurityAlertResponses cache entries
 * that don't have timestamp fields, preparing for the new TTL-based caching system.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  versionedData.data = transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  try {
    const appStateControllerState = state.AppStateController;
    if ((0, _utils.hasProperty)(state, 'AppStateController') && (0, _utils.isObject)(appStateControllerState) && (0, _utils.hasProperty)(appStateControllerState, 'addressSecurityAlertResponses') && (0, _utils.isObject)(appStateControllerState.addressSecurityAlertResponses)) {
      // Clear all existing cache entries to force fresh fetches with timestamps
      // This ensures all cached entries will have the new timestamp field for TTL tracking
      appStateControllerState.addressSecurityAlertResponses = {};
    }
    return state;
  } catch (error) {
    (0, _sentry.captureException)(new Error(`Migration ${version}: Failed to clear addressSecurityAlertResponses cache. Error: ${error.message}`));
    return state;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\176.1.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\176.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C176.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 176;
const SOLANA_MAINNET_ADDRESS = 'solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp';
/**
 * Validate that the given entry is a valid transaction state entry.
 *
 * @param entry - The entry to validate.
 * @returns True if the entry is valid, false otherwise.
 */
function isValidTransactionStateEntry(entry) {
  return typeof entry === 'object' && entry !== null && (0, _utils.hasProperty)(entry, 'transactions') && (0, _utils.hasProperty)(entry, 'next') && (0, _utils.hasProperty)(entry, 'lastUpdated') && Array.isArray(entry.transactions) && (typeof entry.next === 'string' || entry.next === null) && typeof entry.lastUpdated === 'number';
}

/**
 * This migration transforms the MultichainTransactionsController state structure
 * to support per-chain transaction storage. It moves transactions from directly
 * under the account to be nested under the chainId (Solana in this case).
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to disk.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if (!(0, _utils.hasProperty)(state, 'MultichainTransactionsController') || !(0, _utils.isObject)(state.MultichainTransactionsController)) {
    console.warn('Skipping migration. MultichainTransactionsController state not found.');
    return state;
  }
  const transactionsController = state.MultichainTransactionsController;
  if (!(0, _utils.hasProperty)(transactionsController, 'nonEvmTransactions') || !(0, _utils.isObject)(transactionsController.nonEvmTransactions)) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`Invalid nonEvmTransactions state: ${typeof transactionsController.nonEvmTransactions}`));
    return state;
  }
  const {
    nonEvmTransactions
  } = transactionsController;
  const newNonEvmTransactions = {};

  // Migrate each account's transactions to the new nested structure
  for (const [accountId, accountTransactions] of Object.entries(nonEvmTransactions)) {
    if (!isValidTransactionStateEntry(accountTransactions)) {
      throw new Error(`Invalid transaction state entry for account ${accountId}: expected TransactionStateEntry, got ${typeof accountTransactions}`);
    }

    // Creates the new structure for this account
    // Since we know the transactions are from Solana, we use the Solana chainId
    // 'solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp' is Solana mainnet (the only supported so far)
    newNonEvmTransactions[accountId] = {
      [SOLANA_MAINNET_ADDRESS]: {
        transactions: accountTransactions.transactions,
        next: accountTransactions.next,
        lastUpdated: accountTransactions.lastUpdated
      }
    };
  }

  // Update the state with the new structure
  transactionsController.nonEvmTransactions = newNonEvmTransactions;
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\176.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\177.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C177.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 177;
function transformState(state) {
  if (!(0, _utils.hasProperty)(state, 'UserStorageController') || !(0, _utils.isObject)(state.UserStorageController)) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`Invalid UserStorageController state: ${typeof state.UserStorageController}`));
    return state;
  }
  if ((0, _utils.hasProperty)(state.UserStorageController, 'hasAccountSyncingSyncedAtLeastOnce')) {
    delete state.UserStorageController.hasAccountSyncingSyncedAtLeastOnce;
  }
  if ((0, _utils.hasProperty)(state.UserStorageController, 'isAccountSyncingReadyToBeDispatched')) {
    delete state.UserStorageController.isAccountSyncingReadyToBeDispatched;
  }
  if ((0, _utils.hasProperty)(state.UserStorageController, 'isAccountSyncingInProgress')) {
    delete state.UserStorageController.isAccountSyncingInProgress;
  }
  return state;
}

/**
 * This migration deletes old and unused UserStorageController's state properties.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\177.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\178.ts", {"../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C178.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CHAINS_TO_RENAME = void 0;
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
var _network = require("../../../shared/constants/network");
const version = exports.version = 178;
const CHAINS_TO_RENAME = exports.CHAINS_TO_RENAME = [{
  id: _network.CHAIN_IDS.MAINNET,
  fromName: 'Ethereum Mainnet',
  toName: 'Ethereum'
}, {
  id: _network.CHAIN_IDS.LINEA_MAINNET,
  fromName: 'Linea Mainnet',
  toName: 'Linea'
}, {
  id: _network.CHAIN_IDS.BASE,
  fromName: 'Base Mainnet',
  toName: 'Base'
}, {
  id: _network.CHAIN_IDS.ARBITRUM,
  fromName: 'Arbitrum One',
  toName: 'Arbitrum'
}, {
  id: _network.CHAIN_IDS.AVALANCHE,
  fromName: 'Avalanche Network C-Chain',
  toName: 'Avalanche'
}, {
  id: _network.CHAIN_IDS.BSC,
  fromName: 'Binance Smart Chain',
  toName: 'BNB Chain'
}, {
  id: _network.CHAIN_IDS.OPTIMISM,
  fromName: 'OP Mainnet',
  toName: 'OP'
}, {
  id: _network.CHAIN_IDS.POLYGON,
  fromName: 'Polygon Mainnet',
  toName: 'Polygon'
}, {
  id: _network.CHAIN_IDS.SEI,
  fromName: 'Sei Mainnet',
  toName: 'Sei'
}, {
  id: _network.CHAIN_IDS.ZKSYNC_ERA,
  fromName: 'zkSync Era Mainnet',
  toName: 'zkSync Era'
}];

/**
 * This migration updates network names.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}

/**
 * Modifies all chain names according to CHAINS_TO_RENAME.
 *
 * @param state - The state object to transform.
 */
function transformState(state) {
  // Validate if the NetworkController state exists and has the expected structure.
  if (!((0, _utils.hasProperty)(state, 'NetworkController') && (0, _utils.isObject)(state.NetworkController) && (0, _utils.hasProperty)(state.NetworkController, 'networkConfigurationsByChainId') && (0, _utils.isObject)(state.NetworkController.networkConfigurationsByChainId))) {
    return;
  }
  for (const chain of CHAINS_TO_RENAME) {
    const networkConfigsByChainId = state.NetworkController.networkConfigurationsByChainId;

    // If the chain ID is not found, skip it.
    if (!(0, _utils.hasProperty)(networkConfigsByChainId, chain.id)) {
      continue;
    }

    // If the network configuration for the chain is not found, skip it.
    const networkConfigsForChain = networkConfigsByChainId[chain.id];
    if ((0, _utils.isObject)(networkConfigsForChain) && (0, _utils.hasProperty)(networkConfigsForChain, 'name') && networkConfigsForChain.name === chain.fromName) {
      networkConfigsForChain.name = chain.toName;
    }
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\178.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\179.ts", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C179.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _utils = require("@metamask/utils");
var _lodash = require("lodash");
const version = exports.version = 179;

/**
 * This migration clears the urlScanCache from PhishingController
 *
 * @param originalVersionedData - The original state data to migrate
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if ((0, _utils.hasProperty)(state, 'PhishingController') && (0, _utils.isObject)(state.PhishingController)) {
    const phishingController = state.PhishingController;

    // Clear the urlScanCache if it exists
    if ((0, _utils.hasProperty)(phishingController, 'urlScanCache')) {
      phishingController.urlScanCache = {};
    }
  }
  return state;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\179.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\180.ts", {"../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C180.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBaseNetworkConfiguration = getBaseNetworkConfiguration;
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
var _utils = require("@metamask/utils");
var _network = require("../../../shared/constants/network");
const version = exports.version = 180;

/**
 * This migration adds Base network to the `NetworkController` as it is enabled by default.
 * - It modifies the `NetworkController.state.networkConfigurationsByChainId` to include Base network.
 *
 * @param originalVersionedData - The versioned extension state.
 * @returns The updated versioned extension state with base network added
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  versionedData.data = transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  if (!(0, _utils.hasProperty)(state, 'NetworkController')) {
    console.warn(`Migration ${version}: NetworkController not found.`);
    return state;
  }
  const networkState = state.NetworkController;
  if (!(0, _utils.isObject)(networkState)) {
    var _global$sentry, _global$sentry$captur;
    (_global$sentry = global.sentry) === null || _global$sentry === void 0 || (_global$sentry$captur = _global$sentry.captureException) === null || _global$sentry$captur === void 0 || _global$sentry$captur.call(_global$sentry, new Error(`Migration ${version}: NetworkController is not an object: ${typeof networkState}`));
    return state;
  }
  if (!(0, _utils.hasProperty)(networkState, 'networkConfigurationsByChainId')) {
    var _global$sentry2, _global$sentry2$captu;
    (_global$sentry2 = global.sentry) === null || _global$sentry2 === void 0 || (_global$sentry2$captu = _global$sentry2.captureException) === null || _global$sentry2$captu === void 0 || _global$sentry2$captu.call(_global$sentry2, new Error(`Migration ${version}: NetworkController missing property networkConfigurationsByChainId.`));
    return state;
  }
  if (!(0, _utils.isObject)(networkState.networkConfigurationsByChainId)) {
    var _global$sentry3, _global$sentry3$captu;
    (_global$sentry3 = global.sentry) === null || _global$sentry3 === void 0 || (_global$sentry3$captu = _global$sentry3.captureException) === null || _global$sentry3$captu === void 0 || _global$sentry3$captu.call(_global$sentry3, new Error(`Migration ${version}: NetworkController.networkConfigurationsByChainId is not an object: ${typeof networkState.networkConfigurationsByChainId}.`));
    return state;
  }
  const existingBaseNetwork = networkState.networkConfigurationsByChainId[_network.CHAIN_IDS.BASE];
  if (existingBaseNetwork && (0, _utils.isObject)(existingBaseNetwork)) {
    // Check if Infura endpoint already exists
    const hasInfuraEndpoint = (0, _utils.hasProperty)(existingBaseNetwork, 'rpcEndpoints') && Array.isArray(existingBaseNetwork.rpcEndpoints) && existingBaseNetwork.rpcEndpoints.some(endpoint => (0, _utils.isObject)(endpoint) && (0, _utils.hasProperty)(endpoint, 'networkClientId') && (0, _utils.hasProperty)(endpoint, 'type') && endpoint.networkClientId === 'base-mainnet' && endpoint.type === 'infura');
    if (hasInfuraEndpoint) {
      return state;
    }

    // Add Infura endpoint to existing Base network configuration
    const infuraConfig = getBaseNetworkConfiguration();
    const updatedBaseNetwork = {
      ...existingBaseNetwork,
      rpcEndpoints: [...(Array.isArray(existingBaseNetwork.rpcEndpoints) ? existingBaseNetwork.rpcEndpoints : []), ...infuraConfig.rpcEndpoints]
    };
    networkState.networkConfigurationsByChainId[_network.CHAIN_IDS.BASE] = updatedBaseNetwork;
  } else {
    // No existing Base network, add the complete Infura configuration
    networkState.networkConfigurationsByChainId[_network.CHAIN_IDS.BASE] = getBaseNetworkConfiguration();
  }
  return state;
}

// Exported for testing purposes
function getBaseNetworkConfiguration() {
  return {
    blockExplorerUrls: [],
    chainId: '0x2105',
    // toHex(8453) Base Network
    defaultRpcEndpointIndex: 0,
    name: 'Base',
    nativeCurrency: 'ETH',
    rpcEndpoints: [{
      failoverUrls: (0, _network.getFailoverUrlsForInfuraNetwork)('base-mainnet'),
      networkClientId: 'base-mainnet',
      type: 'infura',
      url: 'https://base-mainnet.infura.io/v3/{infuraProjectId}'
    }]
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\180.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\181.ts", {"lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5C181.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrate = migrate;
exports.version = void 0;
var _lodash = require("lodash");
const version = exports.version = 181;

/**
 * This migration removes the unused `showIncomingTransactions` property from
 * PreferencesController state.
 *
 * @param originalVersionedData - Versioned MetaMask extension state, exactly
 * what we persist to dist.
 * @param originalVersionedData.meta - State metadata.
 * @param originalVersionedData.meta.version - The current state version.
 * @param originalVersionedData.data - The persisted MetaMask state, keyed by
 * controller.
 * @returns Updated versioned MetaMask extension state.
 */
async function migrate(originalVersionedData) {
  const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
  versionedData.meta.version = version;
  transformState(versionedData.data);
  return versionedData;
}
function transformState(state) {
  const preferencesControllerState = state === null || state === void 0 ? void 0 : state.PreferencesController;
  if (preferencesControllerState) {
    delete preferencesControllerState.showIncomingTransactions;
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\181.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\fail-tx.js", {"@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5Cfail-tx.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = failTxsThat;
var _lodash = require("lodash");
var _transactionController = require("@metamask/transaction-controller");
function failTxsThat(version, reason, condition) {
  return function (originalVersionedData) {
    const versionedData = (0, _lodash.cloneDeep)(originalVersionedData);
    versionedData.meta.version = version;
    try {
      const state = versionedData.data;
      const newState = transformState(state, condition, reason);
      versionedData.data = newState;
    } catch (err) {
      console.warn(`MetaMask Migration #${version}${err.stack}`);
    }
    return Promise.resolve(versionedData);
  };
}
function transformState(state, condition, reason) {
  const newState = state;
  const {
    TransactionController
  } = newState;
  if (TransactionController && TransactionController.transactions) {
    const {
      transactions
    } = TransactionController;
    newState.TransactionController.transactions = transactions.map(txMeta => {
      if (!condition(txMeta)) {
        return txMeta;
      }
      txMeta.status = _transactionController.TransactionStatus.failed;
      txMeta.err = {
        message: reason,
        note: `Tx automatically failed by migration because ${reason}`
      };
      return txMeta;
    });
  }
  return newState;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\fail-tx.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\index.js", {"./002":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\002.js","./003":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\003.js","./004":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\004.js","./005":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\005.js","./006":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\006.js","./007":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\007.js","./008":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\008.js","./009":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\009.js","./010":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\010.js","./011":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\011.js","./012":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\012.js","./013":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\013.js","./014":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\014.js","./015":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\015.js","./016":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\016.js","./017":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\017.js","./018":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\018.js","./019":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\019.js","./020":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\020.js","./021":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\021.js","./022":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\022.js","./023":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\023.js","./024":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\024.js","./025":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\025.js","./026":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\026.js","./027":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\027.js","./028":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\028.js","./029":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\029.js","./030":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\030.js","./031":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\031.js","./032":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\032.js","./033":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\033.js","./034":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\034.js","./035":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\035.js","./036":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\036.js","./037":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\037.js","./038":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\038.js","./039":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\039.js","./040":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\040.js","./041":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\041.js","./042":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\042.js","./043":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\043.js","./044":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\044.js","./045":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\045.js","./046":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\046.js","./047":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\047.js","./048":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\048.js","./049":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\049.js","./050":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\050.js","./051":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\051.js","./052":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\052.js","./053":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\053.js","./054":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\054.js","./055":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\055.js","./056":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\056.js","./057":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\057.js","./058":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\058.js","./059":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\059.js","./060":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\060.js","./061":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\061.js","./062":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\062.js","./063":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\063.js","./064":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\064.js","./065":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\065.js","./066":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\066.js","./067":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\067.js","./068":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\068.js","./069":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\069.js","./070":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\070.js","./071":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\071.js","./072":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\072.js","./073":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\073.js","./074":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\074.js","./075":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\075.js","./076":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\076.js","./077":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\077.js","./078":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\078.ts","./079":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\079.js","./080":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\080.js","./081":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\081.ts","./082":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\082.ts","./083":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\083.ts","./084":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\084.ts","./085":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\085.ts","./086":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\086.ts","./087":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\087.ts","./088":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\088.ts","./089":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\089.ts","./090":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\090.ts","./091":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\091.ts","./092":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\092.ts","./092.1":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\092.1.ts","./092.2":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\092.2.ts","./092.3":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\092.3.ts","./093":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\093.ts","./094":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\094.ts","./095":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\095.ts","./096":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\096.ts","./097":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\097.ts","./098":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\098.ts","./099":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\099.ts","./100":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\100.ts","./101":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\101.ts","./102":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\102.ts","./103":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\103.ts","./104":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\104.ts","./105":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\105.ts","./106":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\106.js","./107":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\107.ts","./108":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\108.ts","./109":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\109.ts","./110":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\110.ts","./111":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\111.ts","./112":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\112.ts","./113":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\113.ts","./114":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\114.ts","./115":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\115.ts","./116":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\116.ts","./117":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\117.ts","./118":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\118.ts","./119":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\119.ts","./120":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\120.ts","./120.1":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\120.1.ts","./120.2":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\120.2.ts","./120.4":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\120.4.ts","./120.5":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\120.5.ts","./120.6":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\120.6.ts","./121":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\121.ts","./121.1":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\121.1.ts","./121.2":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\121.2.ts","./122":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\122.ts","./123":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\123.ts","./124":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\124.ts","./125":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\125.ts","./125.1":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\125.1.ts","./126":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\126.ts","./126.1":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\126.1.ts","./127":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\127.ts","./128":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\128.ts","./129":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\129.ts","./130":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\130.ts","./131":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\131.ts","./131.1":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\131.1.ts","./132":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\132.ts","./133":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\133.ts","./133.1":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\133.1.ts","./133.2":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\133.2.ts","./134":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\134.ts","./134.1":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\134.1.ts","./135":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\135.ts","./136":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\136.ts","./137":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\137.ts","./138":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\138.ts","./139":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\139.ts","./140":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\140.ts","./141":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\141.ts","./142":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\142.ts","./143":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\143.ts","./143.1":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\143.1.ts","./144":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\144.ts","./145":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\145.ts","./146":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\146.ts","./146.1":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\146.1.ts","./147":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\147.ts","./148":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\148.ts","./149":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\149.ts","./150":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\150.ts","./151":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\151.ts","./152":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\152.ts","./152.1":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\152.1.ts","./152.2":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\152.2.ts","./153":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\153.ts","./154":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\154.ts","./155":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\155.ts","./156":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\156.ts","./156.1":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\156.1.ts","./157":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\157.ts","./158":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\158.ts","./159":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\159.ts","./160":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\160.ts","./161":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\161.ts","./161.1":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\161.1.ts","./162":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\162.ts","./163":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\163.ts","./164":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\164.ts","./165":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\165.ts","./166":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\166.ts","./167":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\167.ts","./168":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\168.ts","./168.1":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\168.1.ts","./169":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\169.ts","./170":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\170.ts","./170.1":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\170.1.ts","./170.2":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\170.2.ts","./171":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\171.ts","./172":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\172.ts","./173":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\173.ts","./174":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\174.ts","./175":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\175.ts","./176":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\176.ts","./176.1":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\176.1.ts","./177":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\177.ts","./178":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\178.ts","./179":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\179.ts","./180":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\180.ts","./181":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\181.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cmigrations%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
// Migrations must start at version 1 or later.
// They are objects with a `version` number
// and a `migrate` function.
//
// The `migrate` function receives the previous
// config data format, and returns the new one.

/* eslint node/global-require: "off" */
// (we have to turn off that global-require rule for this file in order to do the import-then-export magic)

const migrations = [require('./002').default, require('./003').default, require('./004').default, require('./005').default, require('./006').default, require('./007').default, require('./008').default, require('./009').default, require('./010').default, require('./011').default, require('./012').default, require('./013').default, require('./014').default, require('./015').default, require('./016').default, require('./017').default, require('./018').default, require('./019').default, require('./020').default, require('./021').default, require('./022').default, require('./023').default, require('./024').default, require('./025').default, require('./026').default, require('./027').default, require('./028').default, require('./029').default, require('./030').default, require('./031').default, require('./032').default, require('./033').default, require('./034').default, require('./035').default, require('./036').default, require('./037').default, require('./038').default, require('./039').default, require('./040').default, require('./041').default, require('./042').default, require('./043').default, require('./044').default, require('./045').default, require('./046').default, require('./047').default, require('./048').default, require('./049').default, require('./050').default, require('./051').default, require('./052').default, require('./053').default, require('./054').default, require('./055').default, require('./056').default, require('./057').default, require('./058').default, require('./059').default, require('./060').default, require('./061').default, require('./062').default, require('./063').default, require('./064').default, require('./065').default, require('./066').default, require('./067').default, require('./068').default, require('./069').default, require('./070').default, require('./071').default, require('./072').default, require('./073').default, require('./074').default, require('./075').default, require('./076').default, require('./077').default, require('./078'), require('./079').default, require('./080').default, require('./081'), require('./082'), require('./083'), require('./084'), require('./085'), require('./086'), require('./087'), require('./088'), require('./089'), require('./090'), require('./091'), require('./092'), require('./092.1'), require('./092.2'), require('./092.3'), require('./093'), require('./094'), require('./095'), require('./096'), require('./097'), require('./098'), require('./099'), require('./100'), require('./101'), require('./102'), require('./103'), require('./104'), require('./105'), require('./106'), require('./107'), require('./108'), require('./109'), require('./110'), require('./111'), require('./112'), require('./113'), require('./114'), require('./115'), require('./116'), require('./117'), require('./118'), require('./119'), require('./120'), require('./120.1'), require('./120.2'),
// require('./120.3'), Renamed to 120.6, do not re-use this number
require('./120.4'), require('./120.5'), require('./120.6'), require('./121'), require('./121.1'), require('./121.2'), require('./122'), require('./123'), require('./124'), require('./125'), require('./125.1'), require('./126'), require('./126.1'), require('./127'), require('./128'), require('./129'), require('./130'), require('./131'), require('./131.1'), require('./132'), require('./133'), require('./133.1'), require('./133.2'), require('./134'), require('./134.1'), require('./135'), require('./136'), require('./137'), require('./138'), require('./139'), require('./140'), require('./141'), require('./142'), require('./143'), require('./143.1'), require('./144'), require('./145'), require('./146'), require('./146.1'), require('./147'), require('./148'), require('./149'), require('./150'), require('./151'), require('./152'), require('./152.1'), require('./152.2'), require('./153'), require('./154'), require('./155'), require('./156'), require('./156.1'), require('./157'), require('./158'), require('./159'), require('./160'), require('./161'), require('./161.1'), require('./162'), require('./163'), require('./164'), require('./165'), require('./166'), require('./167'), require('./168'), require('./168.1'), require('./169'), require('./170'), require('./170.1'), require('./170.2'), require('./171'), require('./172'), require('./173'), require('./174'), require('./175'), require('./176'), require('./176.1'), require('./177'), require('./178'), require('./179'), require('./180'), require('./181')];
var _default = exports.default = migrations;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\migrations\\index.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\offscreen.js", {"../../shared/constants/offscreen-communication":"D:\\code\\v\\metamask-extension\\shared\\constants\\offscreen-communication.ts","../../shared/lib/sentry":"D:\\code\\v\\metamask-extension\\shared\\lib\\sentry.ts","../../test/e2e/background-socket/socket-background-to-mocha":"D:\\code\\v\\metamask-extension\\test\\e2e\\background-socket\\socket-background-to-mocha.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Coffscreen.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createOffscreen = createOffscreen;
var _sentry = require("../../shared/lib/sentry");
var _offscreenCommunication = require("../../shared/constants/offscreen-communication");
/**
 * Returns whether the offscreen document already exists or not.
 *
 * See https://developer.chrome.com/docs/extensions/reference/api/offscreen#before_chrome_116_check_if_an_offscreen_document_is_open
 *
 * @returns True if the offscreen document already is has been opened, otherwise false.
 */
async function hasOffscreenDocument() {
  const {
    chrome,
    clients
  } = globalThis;
  // getContexts is only available in Chrome 116+
  if ('getContexts' in chrome.runtime) {
    const contexts = await chrome.runtime.getContexts({
      contextTypes: ['OFFSCREEN_DOCUMENT']
    });
    return contexts.length > 0;
  }
  const matchedClients = await clients.matchAll();
  const url = chrome.runtime.getURL('offscreen.html');
  return matchedClients.some(client => client.url === url);
}

/**
 * Creates an offscreen document that can be used to load additional scripts
 * and iframes that can communicate with the extension through the chrome
 * runtime API. Only one offscreen document may exist, so any iframes required
 * by extension can be embedded in the offscreen.html file. See the offscreen
 * folder for more details.
 */
async function createOffscreen() {
  const {
    chrome
  } = globalThis;
  if (!chrome.offscreen) {
    return;
  }
  let offscreenDocumentLoadedListener;
  const loadPromise = new Promise(resolve => {
    offscreenDocumentLoadedListener = msg => {
      if (msg.target === _offscreenCommunication.OffscreenCommunicationTarget.extensionMain && msg.isBooted) {
        chrome.runtime.onMessage.removeListener(offscreenDocumentLoadedListener);
        resolve();

        // If the Offscreen Document sees `navigator.webdriver === true` and we are in a test environment,
        // start the SocketBackgroundToMocha.
        if (false && msg.webdriverPresent) {
          const {
            getSocketBackgroundToMocha
          } =
          // Use `require` to make it easier to exclude this test code from the Browserify build.
          // eslint-disable-next-line @typescript-eslint/no-require-imports, @typescript-eslint/no-var-requires, node/global-require
          require('../../test/e2e/background-socket/socket-background-to-mocha');
          getSocketBackgroundToMocha();
        }
      }
    };
    chrome.runtime.onMessage.addListener(offscreenDocumentLoadedListener);
  });
  try {
    const offscreenExists = await hasOffscreenDocument();

    // In certain cases the offscreen document may already exist during boot, if it does, we close it and recreate it.
    if (offscreenExists) {
      console.debug('Found existing offscreen document, closing.');
      await chrome.offscreen.closeDocument();
    }
    await chrome.offscreen.createDocument({
      url: './offscreen.html',
      reasons: ['IFRAME_SCRIPTING'],
      justification: 'Used for Hardware Wallet and Snaps scripts to communicate with the extension.'
    });
  } catch (error) {
    if (offscreenDocumentLoadedListener) {
      chrome.runtime.onMessage.removeListener(offscreenDocumentLoadedListener);
    }
    // Report unrecongized errors without halting wallet initialization
    // Failures to create the offscreen document does not compromise wallet data integrity or
    // core functionality, it's just needed for specific features.
    (0, _sentry.captureException)(error);
    return;
  }

  // In case we are in a bad state where the offscreen document is not loading, timeout and let execution continue.
  const timeoutPromise = new Promise(resolve => {
    setTimeout(resolve, _offscreenCommunication.OFFSCREEN_LOAD_TIMEOUT);
  });
  await Promise.race([loadPromise, timeoutPromise]);
  console.debug('Offscreen iframe loaded');
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\offscreen.js",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\services\\data-deletion-service.ts", {"../../../shared/modules/fetch-with-timeout":"D:\\code\\v\\metamask-extension\\shared\\modules\\fetch-with-timeout.ts","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","cockatiel":"D:\\code\\v\\metamask-extension\\node_modules\\cockatiel\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cservices%5Cdata-deletion-service.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RETRIES = exports.MAX_CONSECUTIVE_FAILURES = exports.DataDeletionService = void 0;
var _utils = require("@metamask/utils");
var _cockatiel = require("cockatiel");
var _fetchWithTimeout2 = _interopRequireDefault(require("../../../shared/modules/fetch-with-timeout"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
const inTest = false;
const fallbackSourceId = 'test';
const fallbackDataDeletionEndpoint = 'https://metametrics.metamask.test';
const DEFAULT_ANALYTICS_DATA_DELETION_SOURCE_ID = inTest ? fallbackSourceId : null ?? fallbackSourceId;
const DEFAULT_ANALYTICS_DATA_DELETION_ENDPOINT = inTest ? fallbackDataDeletionEndpoint : null ?? fallbackDataDeletionEndpoint;

/**
 * The number of times we retry a specific failed request to the data deletion API.
 */
const RETRIES = exports.RETRIES = 3;

/**
 * The maximum conseutive failures allowed before treating the server as inaccessible, and
 * breaking the circuit.
 *
 * Each update attempt will result (1 + retries) calls if the server is down.
 */
const MAX_CONSECUTIVE_FAILURES = exports.MAX_CONSECUTIVE_FAILURES = (1 + RETRIES) * 3;

/**
 * When the circuit breaks, we wait for this period of time (in milliseconds) before allowing
 * a request to go through to the API.
 */
const DEFAULT_CIRCUIT_BREAK_DURATION = 30 * 60 * 1000;

/**
 * The threshold (in milliseconds) for when a successful request is considered "degraded".
 */
const DEFAULT_DEGRADED_THRESHOLD = 5_000;

/**
 * Type guard for Fetch network responses with a `statusCode` property.
 *
 * @param response - A suspected Fetch network response.
 * @returns A type checked Fetch network response.
 */
function isValidResponse(response) {
  return (0, _utils.isObject)(response) && (0, _utils.hasProperty)(response, 'statusCode') && typeof response.statusCode === 'number';
}

/**
 * Returns `true` if the parameter is a Fetch network response with a status code that indiciates
 * server failure.
 *
 * @param response - The response to check.
 * @returns `true` if the response indicates a server failure, `false` otherwise.
 */
function onServerFailure(response) {
  return isValidResponse(response) && response.statusCode >= 500;
}

/**
 * Create a Cockatiel retry policy.
 *
 * This policy uses a retry and circuit breaker strategy. Callbacks are accepted for circuit breaks
 * and degraded responses as well.
 *
 * @param args - Arguments
 * @param args.circuitBreakDuration - The amount of time to wait when the circuit breaks
 * from too many consecutive failures.
 * @param args.degradedThreshold - The threshold between "normal" and "degrated" service,
 * in milliseconds.
 * @param args.maximumConsecutiveFailures - The maximum number of consecutive failures
 * allowed before breaking the circuit and pausing further updates.
 * @param args.onBreak - An event handler for when the circuit breaks, useful for capturing
 * metrics about network failures.
 * @param args.onDegraded - An event handler for when the circuit remains closed, but requests
 * are failing or resolving too slowly (i.e. resolving more slowly than the `degradedThreshold`).
 * @param args.retries - Number of retry attempts.
 * @returns A Cockatiel retry policy.
 */
function createRetryPolicy({
  circuitBreakDuration,
  degradedThreshold,
  maximumConsecutiveFailures,
  onBreak,
  onDegraded,
  retries
}) {
  const retryPolicy = (0, _cockatiel.retry)(_cockatiel.handleAll.orWhenResult(onServerFailure), {
    maxAttempts: retries,
    backoff: new _cockatiel.ExponentialBackoff()
  });
  const circuitBreakerPolicy = (0, _cockatiel.circuitBreaker)(_cockatiel.handleAll, {
    halfOpenAfter: circuitBreakDuration,
    breaker: new _cockatiel.ConsecutiveBreaker(maximumConsecutiveFailures)
  });
  if (onBreak) {
    circuitBreakerPolicy.onBreak(onBreak);
  }
  if (onDegraded) {
    retryPolicy.onGiveUp(() => {
      if (circuitBreakerPolicy.state === _cockatiel.CircuitState.Closed) {
        onDegraded();
      }
    });
    retryPolicy.onSuccess(({
      duration
    }) => {
      if (circuitBreakerPolicy.state === _cockatiel.CircuitState.Closed && duration > degradedThreshold) {
        onDegraded();
      }
    });
  }
  return (0, _cockatiel.wrap)(retryPolicy, circuitBreakerPolicy);
}

/**
 * A serivce for requesting the deletion of analytics data.
 */
var _analyticsDataDeletionEndpoint = /*#__PURE__*/new WeakMap();
var _analyticsDataDeletionSourceId = /*#__PURE__*/new WeakMap();
var _fetchStatusPolicy = /*#__PURE__*/new WeakMap();
var _createDataDeletionTaskPolicy = /*#__PURE__*/new WeakMap();
var _fetchWithTimeout = /*#__PURE__*/new WeakMap();
class DataDeletionService {
  /**
   * Construct a data deletion service.
   *
   * @param options - Options.
   * @param options.analyticsDataDeletionEndpoint - The base URL for the data deletion API.
   * @param options.analyticsDataDeletionSourceId - The Segment source ID to delete data from.
   * @param options.circuitBreakDuration - The amount of time to wait when the circuit breaks
   * from too many consecutive failures.
   * @param options.degradedThreshold - The threshold between "normal" and "degrated" service,
   * in milliseconds.
   * @param options.onBreak - An event handler for when the circuit breaks, useful for capturing
   * metrics about network failures.
   * @param options.onDegraded - An event handler for when the circuit remains closed, but requests
   * are failing or resolving too slowly (i.e. resolving more slowly than the `degradedThreshold`).
   * @param options.timeout - The timeout allowed for network calls before they are aborted.
   */
  constructor({
    analyticsDataDeletionEndpoint = DEFAULT_ANALYTICS_DATA_DELETION_ENDPOINT,
    analyticsDataDeletionSourceId = DEFAULT_ANALYTICS_DATA_DELETION_SOURCE_ID,
    circuitBreakDuration = DEFAULT_CIRCUIT_BREAK_DURATION,
    degradedThreshold = DEFAULT_DEGRADED_THRESHOLD,
    onBreak,
    onDegraded,
    timeout
  } = {}) {
    _classPrivateFieldInitSpec(this, _analyticsDataDeletionEndpoint, void 0);
    _classPrivateFieldInitSpec(this, _analyticsDataDeletionSourceId, void 0);
    _classPrivateFieldInitSpec(this, _fetchStatusPolicy, void 0);
    _classPrivateFieldInitSpec(this, _createDataDeletionTaskPolicy, void 0);
    _classPrivateFieldInitSpec(this, _fetchWithTimeout, void 0);
    if (!analyticsDataDeletionEndpoint) {
      throw new Error('Missing ANALYTICS_DATA_DELETION_ENDPOINT');
    } else if (!analyticsDataDeletionSourceId) {
      throw new Error('Missing ANALYTICS_DATA_DELETION_SOURCE_ID');
    }
    _classPrivateFieldSet(_fetchWithTimeout, this, (0, _fetchWithTimeout2.default)(timeout));
    _classPrivateFieldSet(_analyticsDataDeletionEndpoint, this, analyticsDataDeletionEndpoint);
    _classPrivateFieldSet(_analyticsDataDeletionSourceId, this, analyticsDataDeletionSourceId);
    _classPrivateFieldSet(_createDataDeletionTaskPolicy, this, createRetryPolicy({
      circuitBreakDuration,
      degradedThreshold,
      maximumConsecutiveFailures: MAX_CONSECUTIVE_FAILURES,
      onBreak,
      onDegraded,
      retries: RETRIES
    }));
    _classPrivateFieldSet(_fetchStatusPolicy, this, createRetryPolicy({
      circuitBreakDuration,
      degradedThreshold,
      maximumConsecutiveFailures: MAX_CONSECUTIVE_FAILURES,
      onBreak,
      onDegraded,
      retries: RETRIES
    }));
  }

  /**
   * Submit a deletion request.
   *
   * We use Segment for this request. Segment calls this deletion request a "regulation", and
   * returns a "regulation ID" to keep track of this request and get status updates for it.
   * https://docs.segmentapis.com/tag/Deletion-and-Suppression#operation/createSourceRegulation
   *
   * @param metaMetricsId - The ID associated with the analytics data that we will be deleting.
   * @returns The regulation ID for the deletion request.
   */
  async createDataDeletionRegulationTask(metaMetricsId) {
    const response = await _classPrivateFieldGet(_createDataDeletionTaskPolicy, this).execute(() => _classPrivateFieldGet(_fetchWithTimeout, this).call(this, `${_classPrivateFieldGet(_analyticsDataDeletionEndpoint, this)}/regulations/sources/${_classPrivateFieldGet(_analyticsDataDeletionSourceId, this)}`, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/vnd.segment.v1+json'
      },
      body: JSON.stringify({
        regulationType: 'DELETE_ONLY',
        subjectType: 'USER_ID',
        subjectIds: [metaMetricsId]
      })
    }));
    if (!response.ok) {
      throw new Error(`Fetch failed with status '${response.status}' for request`);
    }
    return (await response.json()).data.regulateId;
  }

  /**
   * Fetch the status of the given deletion request.
   * https://docs.segmentapis.com/tag/Deletion-and-Suppression#operation/getRegulation
   *
   * @param deleteRegulationId - The Segment "regulation ID" for the deletion request to check.
   * @returns The status of the given deletion request.
   */
  async fetchDeletionRegulationStatus(deleteRegulationId) {
    const response = await _classPrivateFieldGet(_fetchStatusPolicy, this).execute(() => _classPrivateFieldGet(_fetchWithTimeout, this).call(this, `${_classPrivateFieldGet(_analyticsDataDeletionEndpoint, this)}/regulations/${deleteRegulationId}`, {
      method: 'GET',
      headers: {
        'Content-Type': 'application/vnd.segment.v1+json'
      }
    }));
    if (!response.ok) {
      throw new Error(`Fetch failed with status '${response.status}' for request`);
    }
    return (await response.json()).data.regulation.overallStatus;
  }
}
exports.DataDeletionService = DataDeletionService;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\services\\data-deletion-service.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\apple-login-handler.ts", {"./base-login-handler":"D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\base-login-handler.ts","./utils":"D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\utils.ts","@metamask/seedless-onboarding-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cservices%5Coauth%5Capple-login-handler.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppleLoginHandler = void 0;
var _seedlessOnboardingController = require("@metamask/seedless-onboarding-controller");
var _baseLoginHandler = require("./base-login-handler");
var _utils = require("./utils");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
var _scope = /*#__PURE__*/new WeakMap();
class AppleLoginHandler extends _baseLoginHandler.BaseLoginHandler {
  constructor(options) {
    super(options);
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    _defineProperty(this, "OAUTH_SERVER_URL", void 0);
    _classPrivateFieldInitSpec(this, _scope, ['name', 'email']);
    _defineProperty(this, "serverRedirectUri", void 0);
    this.serverRedirectUri = `${options.authServerUrl}/api/v1/oauth/callback`;

    // since Apple doesn't support PKCE,
    // we will use BFF (backend for frontend) to redirect to apple oauth server
    this.OAUTH_SERVER_URL = `${options.authServerUrl}/api/v1/oauth/initiate`;
  }
  get authConnection() {
    return _seedlessOnboardingController.AuthConnection.Apple;
  }
  get scope() {
    return _classPrivateFieldGet(_scope, this);
  }

  /**
   * Generate the Auth URL to initiate the OAuth login to get the Authorization Code from Apple ID server.
   *
   * @returns The URL to initiate the OAuth login.
   */
  async getAuthUrl() {
    const authUrl = new URL(this.OAUTH_SERVER_URL);
    const redirectUri = this.options.webAuthenticator.getRedirectURL();
    const nonce = this.generateNonce();
    const {
      challenge
    } = await this.generateCodeVerifierChallenge();
    authUrl.searchParams.set('client_id', this.options.oAuthClientId);
    authUrl.searchParams.set('response_type', 'code');
    authUrl.searchParams.set('redirect_uri', redirectUri);
    authUrl.searchParams.set('response_mode', 'form_post');
    authUrl.searchParams.set('prompt', this.prompt);
    authUrl.searchParams.set('state', JSON.stringify({
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      client_redirect_back_uri: this.options.webAuthenticator.getRedirectURL(),
      nonce,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      code_challenge: challenge
    }));
    authUrl.searchParams.set('scope', _classPrivateFieldGet(_scope, this).join(' '));
    return Promise.resolve(authUrl.toString());
  }

  /**
   * Get the JWT Token from the Web3Auth Authentication Server.
   *
   * @returns The JWT Token from the Web3Auth Authentication Server.
   */
  async getAuthIdToken() {
    const requestData = this.generateAuthTokenRequestData();
    const res = await this.requestVerifyAuthToken(requestData);
    return res;
  }

  /**
   * Generate the request body data to get the JWT Token from the Web3Auth Authentication Server.
   *
   * @returns The request data for the Web3Auth Authentication Server.
   */
  generateAuthTokenRequestData() {
    const {
      web3AuthNetwork
    } = this.options;
    const requestData = {
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      code_verifier: this.codeVerifier,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      client_id: this.options.oAuthClientId,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      redirect_uri: this.serverRedirectUri,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      login_provider: this.authConnection,
      network: web3AuthNetwork,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      access_type: 'offline'
    };
    return JSON.stringify(requestData);
  }
  async requestVerifyAuthToken(requestData) {
    const res = await fetch(`${this.options.authServerUrl}/api/v1/oauth/callback/verify`, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json'
      },
      body: requestData
    });
    const data = await res.json();
    return data;
  }

  /**
   * Get the user's information from the JWT Token.
   *
   * @param idToken - The JWT Token from the Web3Auth Authentication Server.
   * @returns The user's information from the JWT Token.
   */
  async getUserInfo(idToken) {
    const jsonPayload = (0, _utils.decodeIdToken)(idToken);
    const payload = JSON.parse(jsonPayload);
    return {
      email: payload.email,
      sub: payload.sub
    };
  }
}
exports.AppleLoginHandler = AppleLoginHandler;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\services\\oauth\\apple-login-handler.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\base-login-handler.ts", {"../../../../shared/modules/error":"D:\\code\\v\\metamask-extension\\shared\\modules\\error.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cservices%5Coauth%5Cbase-login-handler.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BaseLoginHandler = void 0;
var _error = require("../../../../shared/modules/error");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class BaseLoginHandler {
  constructor(options) {
    _defineProperty(this, "options", void 0);
    _defineProperty(this, "codeVerifier", void 0);
    // For the verification of the state (in the client side)
    _defineProperty(this, "nonce", void 0);
    // This prompt value is used to force the user to select an account before OAuth login
    _defineProperty(this, "prompt", 'select_account');
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    _defineProperty(this, "CODE_CHALLENGE_METHOD", 'S256');
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    _defineProperty(this, "AUTH_SERVER_TOKEN_PATH", '/api/v1/oauth/token');
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    _defineProperty(this, "AUTH_SERVER_REVOKE_PATH", '/api/v2/oauth/revoke');
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    _defineProperty(this, "AUTH_SERVER_RENEW_REFRESH_PATH", '/api/v2/oauth/renew_refresh_token');
    this.options = options;
  }

  /**
   * Generate the Auth URL to initiate the OAuth login to get the Authorization Code.
   *
   * @returns The URL to initiate the OAuth login.
   */

  /**
   * Get the JWT Token from the Web3Auth Authentication Server.
   *
   * @param code - The authorization code from the social login provider.
   * @returns The JWT Token from the Web3Auth Authentication Server.
   */

  /**
   * Generate the request body data to get the JWT Token from the Web3Auth Authentication Server.
   *
   * @param code - The authorization code from the social login provider.
   * @returns The request data for the Web3Auth Authentication Server.
   */

  /**
   * Get the user's information from the JWT Token.
   *
   * @param idToken - The JWT Token from the Web3Auth Authentication Server.
   * @returns The user's information from the JWT Token.
   */

  /**
   * Validate the state value from the OAuth login redirect URL.
   *
   * @param url - The OAuth login redirect URL.
   */
  validateState(url) {
    const urlObj = new URL(url);
    const state = urlObj.searchParams.get('state');
    if (typeof state !== 'string') {
      throw new Error(_error.OAuthErrorMessages.INVALID_OAUTH_STATE_ERROR);
    }
    const parsedState = JSON.parse(state);
    if (parsedState.nonce !== this.nonce) {
      throw new Error(_error.OAuthErrorMessages.INVALID_OAUTH_STATE_ERROR);
    }
  }

  /**
   * Refresh the JWT Token using the refresh token.
   *
   * @param refreshToken - The refresh token from the Web3Auth Authentication Server.
   * @returns The JWT Token from the Web3Auth Authentication Server and new refresh token.
   */
  async refreshAuthToken(refreshToken) {
    const {
      web3AuthNetwork
    } = this.options;
    const requestData = {
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      client_id: this.options.oAuthClientId,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      login_provider: this.authConnection,
      network: web3AuthNetwork,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      refresh_token: refreshToken,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      grant_type: 'refresh_token' // specify refresh token flow
    };
    const res = await this.requestAuthToken(JSON.stringify(requestData));
    return res;
  }

  /**
   * Revoke the refresh (revoke token is linked to refresh token) token.
   *
   * @param revokeToken - The revoke token from the Web3Auth Authentication Server.
   */
  async revokeRefreshToken(revokeToken) {
    const requestData = {
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      revoke_token: revokeToken
    };
    const res = await fetch(`${this.options.authServerUrl}${this.AUTH_SERVER_REVOKE_PATH}`, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json'
      },
      body: JSON.stringify(requestData)
    });
    if (!res.ok) {
      throw new Error('Failed to revoke refresh token');
    }
  }

  /**
   * Renew the refresh token.
   *
   * @param revokeToken - The revoke token from the Web3Auth Authentication Server.
   * @returns The new refresh token and revoke token.
   */
  async renewRefreshToken(revokeToken) {
    const requestData = {
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      revoke_token: revokeToken
    };
    const res = await fetch(`${this.options.authServerUrl}${this.AUTH_SERVER_RENEW_REFRESH_PATH}`, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json'
      },
      body: JSON.stringify(requestData)
    });
    if (!res.ok) {
      throw new Error('Failed to renew refresh token');
    }
    const data = await res.json();
    return {
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      refresh_token: data.refresh_token,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      revoke_token: data.revoke_token
    };
  }

  /**
   * Make a request to the Web3Auth Authentication Server to get the JWT Token.
   *
   * @param requestData - The request data for the Web3Auth Authentication Server.
   * @returns The JWT Token from the Web3Auth Authentication Server.
   */
  async requestAuthToken(requestData) {
    const res = await fetch(`${this.options.authServerUrl}${this.AUTH_SERVER_TOKEN_PATH}`, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json'
      },
      body: requestData
    });
    if (!res.ok) {
      throw new Error('Failed to get auth token');
    }
    const data = await res.json();
    return data;
  }

  /**
   * Generate a nonce value.
   *
   * @returns The nonce value.
   */
  generateNonce() {
    this.nonce = this.options.webAuthenticator.generateNonce();
    return this.nonce;
  }

  /**
   * Generate a code verifier and challenge value for PKCE flow.
   *
   * @returns The code verifier and challenge value.
   */
  async generateCodeVerifierChallenge() {
    const {
      codeVerifier,
      challenge
    } = await this.options.webAuthenticator.generateCodeVerifierAndChallenge();
    this.codeVerifier = codeVerifier;
    return {
      codeVerifier,
      challenge
    };
  }
}
exports.BaseLoginHandler = BaseLoginHandler;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\services\\oauth\\base-login-handler.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\config.ts", {"../../../../development/build/constants":"D:\\code\\v\\metamask-extension\\development\\build\\constants.js","@metamask/seedless-onboarding-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cservices%5Coauth%5Cconfig.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OauthConfigMap = exports.BuildTypeEnv = void 0;
exports.isDevOrTestBuild = isDevOrTestBuild;
exports.loadOAuthConfig = loadOAuthConfig;
var _seedlessOnboardingController = require("@metamask/seedless-onboarding-controller");
var _constants = require("../../../../development/build/constants");
let BuildTypeEnv = exports.BuildTypeEnv = /*#__PURE__*/function (BuildTypeEnv) {
  BuildTypeEnv["DevMain"] = "DevMain";
  BuildTypeEnv["DevFlask"] = "DevFlask";
  BuildTypeEnv["UatMain"] = "UatMain";
  BuildTypeEnv["UatFlask"] = "UatFlask";
  BuildTypeEnv["ProdMain"] = "ProdMain";
  BuildTypeEnv["ProdFlask"] = "ProdFlask";
  BuildTypeEnv["Beta"] = "Beta";
  return BuildTypeEnv;
}({});
const OauthConfigMap = exports.OauthConfigMap = {
  [BuildTypeEnv.DevMain]: {
    googleAuthConnectionId: 'mm-google-dev-extension',
    appleAuthConnectionId: 'mm-apple-dev-common',
    googleGroupedAuthConnectionId: 'mm-google-dev',
    appleGroupedAuthConnectionId: 'mm-apple-dev',
    authServerUrl: 'https://auth-service.dev-api.cx.metamask.io',
    web3AuthNetwork: _seedlessOnboardingController.Web3AuthNetwork.Devnet
  },
  [BuildTypeEnv.DevFlask]: {
    googleAuthConnectionId: 'mm-google-flask-dev-extension',
    appleAuthConnectionId: 'mm-apple-flask-dev-common',
    googleGroupedAuthConnectionId: 'mm-google-flask-dev',
    appleGroupedAuthConnectionId: 'mm-apple-flask-dev',
    authServerUrl: 'https://auth-service.dev-api.cx.metamask.io',
    web3AuthNetwork: _seedlessOnboardingController.Web3AuthNetwork.Devnet
  },
  [BuildTypeEnv.UatMain]: {
    googleAuthConnectionId: 'mm-google-uat-extension',
    appleAuthConnectionId: 'mm-apple-uat-common',
    googleGroupedAuthConnectionId: 'mm-google-uat',
    appleGroupedAuthConnectionId: 'mm-apple-uat',
    authServerUrl: 'https://auth-service.uat-api.cx.metamask.io',
    web3AuthNetwork: _seedlessOnboardingController.Web3AuthNetwork.Mainnet
  },
  [BuildTypeEnv.UatFlask]: {
    googleAuthConnectionId: 'mm-google-flask-uat-extension',
    appleAuthConnectionId: 'mm-apple-flask-uat-common',
    googleGroupedAuthConnectionId: 'mm-google-flask-uat',
    appleGroupedAuthConnectionId: 'mm-apple-flask-uat',
    authServerUrl: 'https://auth-service.uat-api.cx.metamask.io',
    web3AuthNetwork: _seedlessOnboardingController.Web3AuthNetwork.Mainnet
  },
  [BuildTypeEnv.ProdMain]: {
    googleAuthConnectionId: 'mm-google-main-extension',
    appleAuthConnectionId: 'mm-apple-main-common',
    googleGroupedAuthConnectionId: 'mm-google-main',
    appleGroupedAuthConnectionId: 'mm-apple-main',
    authServerUrl: 'https://auth-service.api.cx.metamask.io',
    web3AuthNetwork: _seedlessOnboardingController.Web3AuthNetwork.Mainnet
  },
  [BuildTypeEnv.ProdFlask]: {
    googleAuthConnectionId: 'mm-google-flask-main-extension',
    appleAuthConnectionId: 'mm-apple-flask-main-common',
    googleGroupedAuthConnectionId: 'mm-google-flask-main',
    appleGroupedAuthConnectionId: 'mm-apple-flask-main',
    authServerUrl: 'https://auth-service.api.cx.metamask.io',
    web3AuthNetwork: _seedlessOnboardingController.Web3AuthNetwork.Mainnet
  },
  [BuildTypeEnv.Beta]: {
    googleAuthConnectionId: 'mm-google-main-extension',
    appleAuthConnectionId: 'mm-apple-main-common',
    googleGroupedAuthConnectionId: 'mm-google-main',
    appleGroupedAuthConnectionId: 'mm-apple-main',
    authServerUrl: 'https://auth-service.api.cx.metamask.io',
    web3AuthNetwork: _seedlessOnboardingController.Web3AuthNetwork.Mainnet
  }
};

/**
 * Check if the build is a Development or Test build.
 *
 * @returns true if the build is a Development or Test build, false otherwise
 */
function isDevOrTestBuild() {
  return "development" === _constants.ENVIRONMENT.DEVELOPMENT || "development" === _constants.ENVIRONMENT.TESTING;
}

/**
 * Check if the build is a Production build.
 *
 * @returns true if the build is a Production build, false otherwise
 */
function isProductionBuild() {
  return "development" === _constants.ENVIRONMENT.PRODUCTION;
}

/**
 * Check if the build is from the release candidate branch.
 * Example: `release/13.0.0` branch.
 *
 * @returns true if the build is from the release candidate branch, false otherwise
 */
function isReleaseCandidateBuild() {
  return "development" === _constants.ENVIRONMENT.RELEASE_CANDIDATE;
}

/**
 * Load the OAuth config based on the build type and environment.
 *
 * @returns the OAuth config
 */
function loadOAuthConfig() {
  const buildType = "main";
  let buildTypeEnv = BuildTypeEnv.DevMain;
  if (buildType === 'main' || buildType === 'experimental') {
    if (isDevOrTestBuild()) {
      buildTypeEnv = BuildTypeEnv.DevMain;
    } else if (isProductionBuild() || isReleaseCandidateBuild()) {
      buildTypeEnv = BuildTypeEnv.ProdMain;
    } else {
      buildTypeEnv = BuildTypeEnv.UatMain;
    }
  } else if (buildType === 'flask') {
    if (isDevOrTestBuild()) {
      buildTypeEnv = BuildTypeEnv.DevFlask;
    } else if (isProductionBuild() || isReleaseCandidateBuild()) {
      buildTypeEnv = BuildTypeEnv.ProdFlask;
    } else {
      buildTypeEnv = BuildTypeEnv.UatFlask;
    }
  } else if (buildType === 'beta') {
    buildTypeEnv = BuildTypeEnv.Beta;
  }
  return OauthConfigMap[buildTypeEnv];
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\services\\oauth\\config.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\create-login-handler.ts", {"./apple-login-handler":"D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\apple-login-handler.ts","./google-login-handler":"D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\google-login-handler.ts","@metamask/seedless-onboarding-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cservices%5Coauth%5Ccreate-login-handler.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLoginHandler = createLoginHandler;
var _seedlessOnboardingController = require("@metamask/seedless-onboarding-controller");
var _appleLoginHandler = require("./apple-login-handler");
var _googleLoginHandler = require("./google-login-handler");
function createLoginHandler(authConnection, config, webAuthenticator) {
  const commonHandlerOptions = {
    web3AuthNetwork: config.web3AuthNetwork,
    authServerUrl: config.authServerUrl,
    webAuthenticator
  };
  switch (authConnection) {
    case _seedlessOnboardingController.AuthConnection.Google:
      return new _googleLoginHandler.GoogleLoginHandler({
        ...commonHandlerOptions,
        oAuthClientId: config.googleClientId
      });
    case _seedlessOnboardingController.AuthConnection.Apple:
      return new _appleLoginHandler.AppleLoginHandler({
        ...commonHandlerOptions,
        oAuthClientId: config.appleClientId
      });
    default:
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
      // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
      throw new Error(`Invalid social login provider: ${authConnection}`);
  }
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\services\\oauth\\create-login-handler.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\google-login-handler.ts", {"./base-login-handler":"D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\base-login-handler.ts","./utils":"D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\utils.ts","@metamask/seedless-onboarding-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cservices%5Coauth%5Cgoogle-login-handler.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GoogleLoginHandler = void 0;
var _seedlessOnboardingController = require("@metamask/seedless-onboarding-controller");
var _baseLoginHandler = require("./base-login-handler");
var _utils = require("./utils");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
var _scope = /*#__PURE__*/new WeakMap();
class GoogleLoginHandler extends _baseLoginHandler.BaseLoginHandler {
  constructor(...args) {
    super(...args);
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
    // eslint-disable-next-line @typescript-eslint/naming-convention
    _defineProperty(this, "OAUTH_SERVER_URL", 'https://accounts.google.com/o/oauth2/v2/auth');
    _classPrivateFieldInitSpec(this, _scope, ['openid', 'profile', 'email']);
  }
  get authConnection() {
    return _seedlessOnboardingController.AuthConnection.Google;
  }
  get scope() {
    return _classPrivateFieldGet(_scope, this);
  }

  /**
   * Generate the Auth URL to initiate the OAuth login to get the Authorization Code from Google Authorization server.
   *
   * @returns The URL to initiate the OAuth login.
   */
  async getAuthUrl() {
    const authUrl = new URL(this.OAUTH_SERVER_URL);
    const nonce = this.generateNonce();
    const {
      challenge
    } = await this.generateCodeVerifierChallenge();
    const redirectUri = this.options.webAuthenticator.getRedirectURL();
    authUrl.searchParams.set('client_id', this.options.oAuthClientId);
    authUrl.searchParams.set('response_type', 'code');
    authUrl.searchParams.set('scope', _classPrivateFieldGet(_scope, this).join(' '));
    authUrl.searchParams.set('code_challenge_method', this.CODE_CHALLENGE_METHOD);
    authUrl.searchParams.set('code_challenge', challenge);
    authUrl.searchParams.set('state', JSON.stringify({
      nonce
    }));
    authUrl.searchParams.set('redirect_uri', redirectUri);
    authUrl.searchParams.set('prompt', this.prompt);
    return authUrl.toString();
  }

  /**
   * Get the JWT Token from the Web3Auth Authentication Server.
   *
   * @param code - The Authorization Code from the social login provider.
   * @returns The JWT Token from the Web3Auth Authentication Server.
   */
  async getAuthIdToken(code) {
    const requestData = this.generateAuthTokenRequestData(code);
    const res = await this.requestAuthToken(requestData);
    return res;
  }

  /**
   * Generate the request body data to get the JWT Token from the Web3Auth Authentication Server.
   *
   * @param code - The Authorization Code from the social login provider.
   * @returns The request data for the Web3Auth Authentication Server.
   */
  generateAuthTokenRequestData(code) {
    const {
      web3AuthNetwork
    } = this.options;
    const redirectUri = this.options.webAuthenticator.getRedirectURL();
    const requestData = {
      code,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      client_id: this.options.oAuthClientId,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      redirect_uri: redirectUri,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      login_provider: this.authConnection,
      network: web3AuthNetwork,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      code_verifier: this.codeVerifier,
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      access_type: 'offline'
    };
    return JSON.stringify(requestData);
  }

  /**
   * Get the user's information from the JWT Token.
   *
   * @param idToken - The JWT Token from the Web3Auth Authentication Server.
   * @returns The user's information from the JWT Token.
   */
  async getUserInfo(idToken) {
    const jsonPayload = (0, _utils.decodeIdToken)(idToken);
    const payload = JSON.parse(jsonPayload);
    return {
      email: payload.email,
      sub: payload.sub
    };
  }
}
exports.GoogleLoginHandler = GoogleLoginHandler;

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\services\\oauth\\google-login-handler.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\oauth-service.ts", {"../../../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../../../shared/modules/browser-runtime.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\browser-runtime.utils.js","../../../../shared/modules/error":"D:\\code\\v\\metamask-extension\\shared\\modules\\error.ts","../../../../test/e2e/constants":"D:\\code\\v\\metamask-extension\\test\\e2e\\constants.ts","./config":"D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\config.ts","./create-login-handler":"D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\create-login-handler.ts","./types":"D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\types.ts","@metamask/seedless-onboarding-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\index.cjs","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cservices%5Coauth%5Coauth-service.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _seedlessOnboardingController = require("@metamask/seedless-onboarding-controller");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _error = require("../../../../shared/modules/error");
var _browserRuntime = require("../../../../shared/modules/browser-runtime.utils");
var _trace = require("../../../../shared/lib/trace");
var _createLoginHandler = require("./create-login-handler");
var _types = require("./types");
var _config = require("./config");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
const AUTH_SERVER_MARKETING_OPT_IN_STATUS_PATH = '/api/v1/oauth/marketing_opt_in_status';
var _messenger = /*#__PURE__*/new WeakMap();
var _env = /*#__PURE__*/new WeakMap();
var _webAuthenticator = /*#__PURE__*/new WeakMap();
var _bufferedTrace = /*#__PURE__*/new WeakMap();
var _bufferedEndTrace = /*#__PURE__*/new WeakMap();
var _OAuthService_brand = /*#__PURE__*/new WeakSet();
class OAuthService {
  constructor({
    messenger,
    env,
    webAuthenticator,
    bufferedTrace,
    bufferedEndTrace
  }) {
    /**
     * Handle the OAuth login for the given social login type.
     *
     * For Google login, we will use the `PKCE` flow to get the Authorization Code.
     * For Apple login, we will use the `server-redirect` flow to get the Authorization Code.
     *
     * Then, we will use the Authorization Code to get the Jwt Token from the Web3Auth Authentication Server.
     *
     * @param loginHandler - The login handler to use.
     * @returns The login result.
     */
    _classPrivateMethodInitSpec(this, _OAuthService_brand);
    // Required for modular initialisation.
    _defineProperty(this, "name", _types.SERVICE_NAME);
    _defineProperty(this, "state", null);
    _classPrivateFieldInitSpec(this, _messenger, void 0);
    _classPrivateFieldInitSpec(this, _env, void 0);
    _classPrivateFieldInitSpec(this, _webAuthenticator, void 0);
    _classPrivateFieldInitSpec(this, _bufferedTrace, void 0);
    _classPrivateFieldInitSpec(this, _bufferedEndTrace, void 0);
    _classPrivateFieldSet(_messenger, this, messenger);
    const oauthConfig = (0, _config.loadOAuthConfig)();
    _classPrivateFieldSet(_env, this, {
      ...env,
      ...oauthConfig
    });
    _classPrivateFieldSet(_webAuthenticator, this, webAuthenticator);
    _classPrivateFieldSet(_bufferedTrace, this, bufferedTrace);
    _classPrivateFieldSet(_bufferedEndTrace, this, bufferedEndTrace);
    _classPrivateFieldGet(_messenger, this).registerActionHandler(`${_types.SERVICE_NAME}:startOAuthLogin`, this.startOAuthLogin.bind(this));
    _classPrivateFieldGet(_messenger, this).registerActionHandler(`${_types.SERVICE_NAME}:getNewRefreshToken`, this.getNewRefreshToken.bind(this));
    _classPrivateFieldGet(_messenger, this).registerActionHandler(`${_types.SERVICE_NAME}:revokeRefreshToken`, this.revokeRefreshToken.bind(this));
    _classPrivateFieldGet(_messenger, this).registerActionHandler(`${_types.SERVICE_NAME}:renewRefreshToken`, this.renewRefreshToken.bind(this));
  }

  /**
   * Start the OAuth login process for the given social login type.
   *
   * @param authConnection - The social login type to login with.
   * @returns The login result.
   */
  async startOAuthLogin(authConnection) {
    // create the login handler for the given social login type
    // this is to get the Jwt Token in the exchange for the Authorization Code
    const loginHandler = (0, _createLoginHandler.createLoginHandler)(authConnection, _classPrivateFieldGet(_env, this), _classPrivateFieldGet(_webAuthenticator, this));
    return _assertClassBrand(_OAuthService_brand, this, _handleOAuthLogin).call(this, loginHandler);
  }

  /**
   * Get a new refresh token from the Web3Auth Authentication Server.
   *
   * @param options - The options for the get new refresh token.
   * @param options.connection - The social login type to login with.
   * @param options.refreshToken - The refresh token to authenticate the refresh request.
   * @returns The new refresh token.
   */
  async getNewRefreshToken(options) {
    const {
      connection,
      refreshToken
    } = options;
    const loginHandler = (0, _createLoginHandler.createLoginHandler)(connection, _classPrivateFieldGet(_env, this), _classPrivateFieldGet(_webAuthenticator, this));
    const refreshTokenData = await loginHandler.refreshAuthToken(refreshToken);
    const idToken = refreshTokenData.id_token;
    return {
      idTokens: [idToken],
      accessToken: refreshTokenData.access_token,
      metadataAccessToken: refreshTokenData.metadata_access_token
    };
  }

  /**
   * Renew the refresh token - get a new refresh token and revoke token.
   *
   * @param options - The options for the revoke and get new refresh token.
   * @param options.connection - The social login type to login with.
   * @param options.revokeToken - The revoke token to authenticate the request.
   * @returns The new refresh token and revoke token.
   */
  async renewRefreshToken(options) {
    const {
      connection,
      revokeToken
    } = options;
    const loginHandler = (0, _createLoginHandler.createLoginHandler)(connection, _classPrivateFieldGet(_env, this), _classPrivateFieldGet(_webAuthenticator, this));
    const res = await loginHandler.renewRefreshToken(revokeToken);
    return {
      newRefreshToken: res.refresh_token,
      newRevokeToken: res.revoke_token
    };
  }
  async revokeRefreshToken(options) {
    const {
      connection,
      revokeToken
    } = options;
    const loginHandler = (0, _createLoginHandler.createLoginHandler)(connection, _classPrivateFieldGet(_env, this), _classPrivateFieldGet(_webAuthenticator, this));
    await loginHandler.revokeRefreshToken(revokeToken);
  }
  async setMarketingConsent(hasEmailMarketingConsent) {
    const state = _classPrivateFieldGet(_messenger, this).call('SeedlessOnboardingController:getState');
    const {
      accessToken
    } = state;
    if (!accessToken) {
      throw new Error('No access token found');
    }
    const requestData = {
      // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
      // eslint-disable-next-line @typescript-eslint/naming-convention
      opt_in_status: hasEmailMarketingConsent
    };
    const res = await fetch(`${_classPrivateFieldGet(_env, this).authServerUrl}${AUTH_SERVER_MARKETING_OPT_IN_STATUS_PATH}`, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        Authorization: `Bearer ${accessToken}`
      },
      body: JSON.stringify(requestData)
    });
    if (!res.ok) {
      throw new Error('Failed to post marketing opt in status');
    }
    return res.ok;
  }
  async getMarketingConsent() {
    try {
      const state = _classPrivateFieldGet(_messenger, this).call('SeedlessOnboardingController:getState');
      const {
        accessToken
      } = state;
      if (!accessToken) {
        throw new Error('No access token found');
      }
      const res = await fetch(`${_classPrivateFieldGet(_env, this).authServerUrl}${AUTH_SERVER_MARKETING_OPT_IN_STATUS_PATH}`, {
        method: 'GET',
        headers: {
          'Content-Type': 'application/json',
          Authorization: `Bearer ${accessToken}`
        }
      });
      if (!res.ok) {
        throw new Error('Failed to get marketing opt in status');
      }
      const data = await res.json();
      return Boolean((data === null || data === void 0 ? void 0 : data.is_opt_in) ?? false);
    } catch (error) {
      _loglevel.default.error('Failed to get marketing opt in status', error);
      return false;
    }
  }
}
exports.default = OAuthService;
async function _handleOAuthLogin(loginHandler) {
  const authUrl = await loginHandler.getAuthUrl();
  let providerLoginSuccess = false;
  let redirectUrlFromOAuth = null;
  try {
    var _classPrivateFieldGet2;
    (_classPrivateFieldGet2 = _classPrivateFieldGet(_bufferedTrace, this)) === null || _classPrivateFieldGet2 === void 0 || _classPrivateFieldGet2.call(this, {
      name: _trace.TraceName.OnboardingOAuthProviderLogin,
      op: _trace.TraceOperation.OnboardingSecurityOp
    });
    // launch the web auth flow to get the Authorization Code from the social login provider
    redirectUrlFromOAuth = await new Promise((resolve, reject) => {
      // since promise returns aren't supported until MV3, we need to use a callback function to support MV2
      _classPrivateFieldGet(_webAuthenticator, this).launchWebAuthFlow({
        interactive: true,
        url: authUrl
      }, responseUrl => {
        try {
          if (responseUrl) {
            try {
              loginHandler.validateState(responseUrl);
              resolve(responseUrl);
            } catch (error) {
              reject(error);
            }
          } else {
            if (_assertClassBrand(_OAuthService_brand, this, _isUserCancelledLoginError).call(this)) {
              reject(new Error(_error.OAuthErrorMessages.USER_CANCELLED_LOGIN_ERROR));
              return;
            }
            reject(new Error(_error.OAuthErrorMessages.NO_REDIRECT_URL_FOUND_ERROR));
          }
        } catch (error) {
          reject(error);
        }
      });
    });
    providerLoginSuccess = true;
  } catch (error) {
    var _classPrivateFieldGet3, _classPrivateFieldGet4;
    const errorMessage = error instanceof Error ? error.message : 'Unknown error';
    (_classPrivateFieldGet3 = _classPrivateFieldGet(_bufferedTrace, this)) === null || _classPrivateFieldGet3 === void 0 || _classPrivateFieldGet3.call(this, {
      name: _trace.TraceName.OnboardingOAuthProviderLoginError,
      op: _trace.TraceOperation.OnboardingError,
      tags: {
        errorMessage
      }
    });
    (_classPrivateFieldGet4 = _classPrivateFieldGet(_bufferedEndTrace, this)) === null || _classPrivateFieldGet4 === void 0 || _classPrivateFieldGet4.call(this, {
      name: _trace.TraceName.OnboardingOAuthProviderLoginError
    });
    throw error;
  } finally {
    var _classPrivateFieldGet5;
    (_classPrivateFieldGet5 = _classPrivateFieldGet(_bufferedEndTrace, this)) === null || _classPrivateFieldGet5 === void 0 || _classPrivateFieldGet5.call(this, {
      name: _trace.TraceName.OnboardingOAuthProviderLogin,
      data: {
        success: providerLoginSuccess
      }
    });
  }
  let getAuthTokensSuccess = false;
  try {
    var _classPrivateFieldGet6;
    (_classPrivateFieldGet6 = _classPrivateFieldGet(_bufferedTrace, this)) === null || _classPrivateFieldGet6 === void 0 || _classPrivateFieldGet6.call(this, {
      name: _trace.TraceName.OnboardingOAuthBYOAServerGetAuthTokens,
      op: _trace.TraceOperation.OnboardingSecurityOp
    });
    // handle the OAuth response from the social login provider and get the Jwt Token in exchange
    const loginResult = await _assertClassBrand(_OAuthService_brand, this, _handleOAuthResponse).call(this, loginHandler, redirectUrlFromOAuth);
    getAuthTokensSuccess = true;
    return loginResult;
  } catch (error) {
    var _classPrivateFieldGet7, _classPrivateFieldGet8;
    const errorMessage = error instanceof Error ? error.message : 'Unknown error';
    (_classPrivateFieldGet7 = _classPrivateFieldGet(_bufferedTrace, this)) === null || _classPrivateFieldGet7 === void 0 || _classPrivateFieldGet7.call(this, {
      name: _trace.TraceName.OnboardingOAuthBYOAServerGetAuthTokensError,
      op: _trace.TraceOperation.OnboardingError,
      tags: {
        errorMessage
      }
    });
    (_classPrivateFieldGet8 = _classPrivateFieldGet(_bufferedEndTrace, this)) === null || _classPrivateFieldGet8 === void 0 || _classPrivateFieldGet8.call(this, {
      name: _trace.TraceName.OnboardingOAuthBYOAServerGetAuthTokensError
    });
    throw error;
  } finally {
    var _classPrivateFieldGet9;
    (_classPrivateFieldGet9 = _classPrivateFieldGet(_bufferedEndTrace, this)) === null || _classPrivateFieldGet9 === void 0 || _classPrivateFieldGet9.call(this, {
      name: _trace.TraceName.OnboardingOAuthBYOAServerGetAuthTokens,
      data: {
        success: getAuthTokensSuccess
      }
    });
  }
}
/**
 * Handle the OAuth response from the social login provider and get the Jwt Token in exchange.
 *
 * The Social Login Auth Server returned the Authorization Code in the redirect URL.
 * This function will extract the Authorization Code from the redirect URL,
 * use it to get the Jwt Token from the Web3Auth Authentication Server.
 *
 * @param loginHandler - The login handler to use.
 * @param redirectUrl - The redirect URL from webAuthFlow which includes the Authorization Code.
 * @returns The login result.
 */
async function _handleOAuthResponse(loginHandler, redirectUrl) {
  const {
    authConnection
  } = loginHandler;

  // We still need to extract the Authorization Code from the redirect URL for Google login (PKCE flow)
  // For Apple login (BFF flow), the Authorization Code is returned to the Authentication Server in the redirect URL
  const authCode = authConnection === _seedlessOnboardingController.AuthConnection.Google ? _assertClassBrand(_OAuthService_brand, this, _getRedirectUrlAuthCode).call(this, redirectUrl) : null;
  const res = await _assertClassBrand(_OAuthService_brand, this, _getAuthIdToken).call(this, loginHandler, authCode);
  return res;
}
/**
 * Get the Jwt Token from the Web3Auth Authentication Server.
 *
 * @param loginHandler - The login handler to use.
 * @param authCode - The Authorization Code from the social login provider.
 * @returns The login result.
 */
async function _getAuthIdToken(loginHandler, authCode) {
  let authConnectionId = '';
  let groupedAuthConnectionId = '';
  if (false) {
    const {
      MOCK_AUTH_CONNECTION_ID,
      MOCK_GROUPED_AUTH_CONNECTION_ID
    } =
    // Use `require` to make it easier to exclude this test code from the Browserify build.
    // eslint-disable-next-line @typescript-eslint/no-require-imports, @typescript-eslint/no-var-requires, node/global-require
    require('../../../../test/e2e/constants');
    authConnectionId = MOCK_AUTH_CONNECTION_ID;
    groupedAuthConnectionId = MOCK_GROUPED_AUTH_CONNECTION_ID;
  } else if (loginHandler.authConnection === _seedlessOnboardingController.AuthConnection.Google) {
    authConnectionId = _classPrivateFieldGet(_env, this).googleAuthConnectionId;
    groupedAuthConnectionId = _classPrivateFieldGet(_env, this).googleGroupedAuthConnectionId;
  } else if (loginHandler.authConnection === _seedlessOnboardingController.AuthConnection.Apple) {
    authConnectionId = _classPrivateFieldGet(_env, this).appleAuthConnectionId;
    groupedAuthConnectionId = _classPrivateFieldGet(_env, this).appleGroupedAuthConnectionId;
  }
  const authTokenData = await loginHandler.getAuthIdToken(authCode);
  const idToken = authTokenData.id_token;
  const userInfo = await loginHandler.getUserInfo(idToken);
  return {
    authConnectionId,
    groupedAuthConnectionId,
    userId: userInfo.sub || userInfo.email,
    idTokens: [idToken],
    authConnection: loginHandler.authConnection,
    socialLoginEmail: userInfo.email,
    refreshToken: authTokenData.refresh_token,
    revokeToken: authTokenData.revoke_token,
    accessToken: authTokenData.access_token,
    metadataAccessToken: authTokenData.metadata_access_token
  };
}
function _getRedirectUrlAuthCode(redirectUrl) {
  const url = new URL(redirectUrl);
  return url.searchParams.get('code');
}
function _isUserCancelledLoginError() {
  const error = (0, _browserRuntime.checkForLastError)();
  return (error === null || error === void 0 ? void 0 : error.message) === _error.OAuthErrorMessages.USER_CANCELLED_LOGIN_ERROR;
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\services\\oauth\\oauth-service.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\types.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cservices%5Coauth%5Ctypes.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SERVICE_NAME = void 0;
const SERVICE_NAME = exports.SERVICE_NAME = 'OAuthService';

/**
 * Start the OAuth login process for the given social login type.
 */

/**
 * Get a new refresh token from the Web3Auth Authentication Server.
 */

/**
 * Revoke the current refresh token and get a new refresh token.
 */

/**
 * Revoke the current refresh token and get a new refresh token.
 */

/**
 * All possible actions for the OAuthService.
 */

/**
 * All possible events that the OAuthService can emit.
 */

/**
 * The WebAuthenticator is a type that defines the methods for the Web Authenticator API to launch the OAuth2 login flow.
 * It is used to abstract the Web Authenticator API from the OAuthService.
 */

/**
 * The response from the Web3Auth Authentication Server to get the JWT Token.
 *
 * The response is a JSON object with the following properties:
 * - success: boolean - whether the request was successful
 * - message: string - the message from the Web3Auth Authentication Server
 * - jwt_tokens: Record<string, string> - the JWT Tokens issued from the Web3Auth Authentication Server
 */

/**
 * The result of the OAuth login.
 *
 * This is the return value of the {@link OAuthService.startOAuthLogin} method.
 * It contains the user's information and the JWT Tokens issued from the Web3Auth Authentication Server.
 *
 * - authConnection: AuthConnection - the social login type
 * - authConnectionId: string - the ID of the social login type
 * - groupedAuthConnectionId: string - the ID of the grouped social login type
 * - userId: string - the user's ID
 * - idTokens: string[] - the JWT Tokens issued from the Web3Auth Authentication Server
 * - socialLoginEmail: string - the email of the user
 */

/**
 * The result of the OAuth refresh token.
 *
 * This is the return value of the {@link OAuthService.getNewRefreshToken} method.
 * It contains the JWT Tokens issued from the Web3Auth Authentication Server.
 */

/**
 * The user's information extracted from the JWT Token.
 */

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\services\\oauth\\types.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\utils.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cservices%5Coauth%5Cutils.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyUrlSafeReplacementsToBase64String = applyUrlSafeReplacementsToBase64String;
exports.base64urlencode = base64urlencode;
exports.convertUrlSafeBase64StringToBase64String = convertUrlSafeBase64StringToBase64String;
exports.decodeBase64WithSafeUrlReplacements = decodeBase64WithSafeUrlReplacements;
exports.decodeIdToken = decodeIdToken;
exports.padBase64String = padBase64String;
/**
 * Pads a string to a length of 4 characters
 *
 * @param input - The base64 encoded string to pad
 * @returns The padded string
 */
function padBase64String(input) {
  // base64 string length should be a multiple of 4
  const segmentLength = 4;
  const stringLength = input.length;
  // number of characters to pad to make the string length a multiple of 4
  const requiredPadLength = segmentLength - stringLength % segmentLength;
  if (requiredPadLength === segmentLength) {
    // handle the case where the string length is already a multiple of 4
    // in this case, we don't need to pad the string
    return input;
  }

  // total length of the padded string
  const paddedStringLength = stringLength + requiredPadLength;
  const paddedString = input.padEnd(paddedStringLength, '=');
  return paddedString;
}
function applyUrlSafeReplacementsToBase64String(base64String) {
  return base64String.replace(/\+/gu, '-') // Replace '+' with '-'
  .replace(/\//gu, '_') // Replace '/' with '_'
  .replace(/[=]+$/u, ''); // Remove padding characters ('=')
}
function convertUrlSafeBase64StringToBase64String(base64String) {
  return base64String.replace(/-/gu, '+').replace(/_/gu, '/').replace(/[=]/gu, '');
}

/**
 * Encodes a buffer to a base64url encoded string
 *
 * @param buffer - The buffer to encode
 * @returns The base64url encoded string
 */
function base64urlencode(buffer) {
  let str = '';
  const bytes = new Uint8Array(buffer);
  for (let i = 0; i < bytes.byteLength; i++) {
    str += String.fromCharCode(bytes[i]);
  }
  return applyUrlSafeReplacementsToBase64String(btoa(str));
}

/**
 * Decodes a base64url encoded string to a UTF-8 string with URL-safe replacements
 *
 * @param base64String - The base64url encoded string to decode
 * @returns The decoded UTF-8 string
 */
function decodeBase64WithSafeUrlReplacements(base64String) {
  // Apply URL-safe replacements to the base64String BEFORE decoding
  const urlSafeBase64String = convertUrlSafeBase64StringToBase64String(base64String);
  const binaryString = atob(urlSafeBase64String);
  const bytes = Uint8Array.from(binaryString, c => c.charCodeAt(0));
  const utf8String = new TextDecoder().decode(bytes);
  return utf8String;
}
function decodeIdToken(idToken) {
  const [, idTokenPayload] = idToken.split('.');
  const base64String = convertUrlSafeBase64StringToBase64String(padBase64String(idTokenPayload));
  return decodeBase64WithSafeUrlReplacements(base64String);
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\services\\oauth\\utils.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\web-authenticator-factory.ts", {"../../../../test/e2e/helpers/seedless-onboarding/mock-web-authenticator":"D:\\code\\v\\metamask-extension\\test\\e2e\\helpers\\seedless-onboarding\\mock-web-authenticator.ts","./utils":"D:\\code\\v\\metamask-extension\\app\\scripts\\services\\oauth\\utils.ts","webextension-polyfill":"D:\\code\\v\\metamask-extension\\node_modules\\webextension-polyfill\\dist\\browser-polyfill.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cservices%5Coauth%5Cweb-authenticator-factory.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIdentityAPI = getIdentityAPI;
exports.webAuthenticatorFactory = webAuthenticatorFactory;
var _webextensionPolyfill = _interopRequireDefault(require("webextension-polyfill"));
var _utils = require("./utils");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
async function generateCodeVerifierAndChallenge() {
  const bytes = new Uint8Array(32);
  crypto.getRandomValues(bytes);
  const codeVerifier = (0, _utils.base64urlencode)(bytes);
  const challengeBuffer = await crypto.subtle.digest('SHA-256', new TextEncoder().encode(codeVerifier));
  const challenge = (0, _utils.base64urlencode)(challengeBuffer);
  return {
    codeVerifier,
    challenge
  };
}
function generateNonce() {
  return crypto.randomUUID();
}
function getIdentityAPI() {
  var _chrome;
  // if chrome.identity API is available, we will use it
  // note that, in firefox, chrome.identity is available
  // but only some of the methods are supported
  // learn more here {@link https://developer.mozilla.org/en-US/docs/Mozilla/Add-ons/WebExtensions/API/identity#browser_compatibility}
  if ((_chrome = chrome) !== null && _chrome !== void 0 && _chrome.identity && 'getRedirectURL' in chrome.identity && 'launchWebAuthFlow' in chrome.identity) {
    return chrome.identity;
  }

  // otherwise use browser.identity API
  return _webextensionPolyfill.default.identity;
}
async function launchWebAuthFlow(options, callback) {
  const identityAPI = getIdentityAPI();
  return identityAPI.launchWebAuthFlow(options, callback);
}
function getRedirectURL() {
  const identityAPI = getIdentityAPI();
  return identityAPI.getRedirectURL();
}
function webAuthenticatorFactory() {
  if (false) {
    const {
      mockWebAuthenticator
    } =
    // Use `require` to make it easier to exclude this test code from the Browserify build.
    // eslint-disable-next-line @typescript-eslint/no-require-imports, @typescript-eslint/no-var-requires, node/global-require
    require('../../../../test/e2e/helpers/seedless-onboarding/mock-web-authenticator');
    return mockWebAuthenticator();
  }
  return {
    launchWebAuthFlow,
    generateCodeVerifierAndChallenge,
    generateNonce,
    getRedirectURL
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\services\\oauth\\web-authenticator-factory.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\services\\subscription\\subscription-service.ts", {"./types":"D:\\code\\v\\metamask-extension\\app\\scripts\\services\\subscription\\types.ts","@metamask/subscription-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\subscription-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cservices%5Csubscription%5Csubscription-service.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubscriptionService = void 0;
var _subscriptionController = require("@metamask/subscription-controller");
var _types = require("./types");
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
var _messenger = /*#__PURE__*/new WeakMap();
var _platform = /*#__PURE__*/new WeakMap();
var _webAuthenticator = /*#__PURE__*/new WeakMap();
var _SubscriptionService_brand = /*#__PURE__*/new WeakSet();
class SubscriptionService {
  constructor({
    messenger,
    platform,
    webAuthenticator
  }) {
    _classPrivateMethodInitSpec(this, _SubscriptionService_brand);
    // Required for modular initialisation.
    _defineProperty(this, "name", _types.SERVICE_NAME);
    _defineProperty(this, "state", null);
    _classPrivateFieldInitSpec(this, _messenger, void 0);
    _classPrivateFieldInitSpec(this, _platform, void 0);
    _classPrivateFieldInitSpec(this, _webAuthenticator, void 0);
    _classPrivateFieldSet(_messenger, this, messenger);
    _classPrivateFieldSet(_platform, this, platform);
    _classPrivateFieldSet(_webAuthenticator, this, webAuthenticator);
  }
  async updateSubscriptionCardPaymentMethod(params, currentTabId) {
    const {
      paymentType
    } = params;
    if (paymentType !== _subscriptionController.PAYMENT_TYPES.byCard) {
      throw new Error('Only card payment type is supported');
    }
    const redirectUrl = _classPrivateFieldGet(_webAuthenticator, this).getRedirectURL();
    const {
      redirectUrl: checkoutSessionUrl
    } = await _classPrivateFieldGet(_messenger, this).call('SubscriptionController:updatePaymentMethod', {
      ...params,
      successUrl: redirectUrl
    });
    await _assertClassBrand(_SubscriptionService_brand, this, _openAndWaitForTabToClose).call(this, {
      url: checkoutSessionUrl,
      successUrl: redirectUrl
    });
    if (!currentTabId) {
      // open extension browser shield settings if open from pop up (no current tab)
      _classPrivateFieldGet(_platform, this).openExtensionInBrowser('/settings/transaction-shield');
    }
    const subscriptions = await _classPrivateFieldGet(_messenger, this).call('SubscriptionController:getSubscriptions');
    return subscriptions;
  }
  async updateSubscriptionCryptoPaymentMethod(params) {
    const {
      paymentType
    } = params;
    if (paymentType !== _subscriptionController.PAYMENT_TYPES.byCrypto) {
      throw new Error('Only crypto payment type is supported');
    }
    await _classPrivateFieldGet(_messenger, this).call('SubscriptionController:updatePaymentMethod', params);
    const subscriptions = await _classPrivateFieldGet(_messenger, this).call('SubscriptionController:getSubscriptions');
    return subscriptions;
  }
  async startSubscriptionWithCard(params, currentTabId) {
    const redirectUrl = _classPrivateFieldGet(_webAuthenticator, this).getRedirectURL();
    const {
      checkoutSessionUrl
    } = await _classPrivateFieldGet(_messenger, this).call('SubscriptionController:startShieldSubscriptionWithCard', {
      ...params,
      successUrl: redirectUrl
    });
    await _assertClassBrand(_SubscriptionService_brand, this, _openAndWaitForTabToClose).call(this, {
      url: checkoutSessionUrl,
      successUrl: redirectUrl
    });
    if (!currentTabId) {
      // open extension browser shield settings if open from pop up (no current tab)
      _classPrivateFieldGet(_platform, this).openExtensionInBrowser('/settings/transaction-shield');
    }
    const subscriptions = await _classPrivateFieldGet(_messenger, this).call('SubscriptionController:getSubscriptions');
    return subscriptions;
  }
}
exports.SubscriptionService = SubscriptionService;
async function _openAndWaitForTabToClose(params) {
  const openedTab = await _classPrivateFieldGet(_platform, this).openTab({
    url: params.url
  });
  await new Promise((resolve, reject) => {
    let succeeded = false;
    // Set up a listener to watch for navigation on that specific tab
    const onTabUpdatedListener = (tabId, changeInfo) => {
      // We only care about updates to our specific checkout tab
      if (tabId === openedTab.id && changeInfo.url) {
        if (changeInfo.url.startsWith(params.successUrl)) {
          // Payment was successful!
          succeeded = true;

          // Clean up: close the tab
          _classPrivateFieldGet(_platform, this).closeTab(tabId);
        }
        // TODO: handle cancel url ?
      }
    };
    _classPrivateFieldGet(_platform, this).addTabUpdatedListener(onTabUpdatedListener);

    // Set up a listener to watch for tab removal
    const onTabRemovedListener = tabId => {
      const cleanupListeners = () => {
        _classPrivateFieldGet(_platform, this).removeTabUpdatedListener(onTabUpdatedListener);
        _classPrivateFieldGet(_platform, this).removeTabRemovedListener(onTabRemovedListener);
      };
      if (tabId === openedTab.id) {
        cleanupListeners();
        if (succeeded) {
          resolve();
        } else {
          reject(new Error('Tab action failed'));
        }
      }
    };
    _classPrivateFieldGet(_platform, this).addTabRemovedListener(onTabRemovedListener);
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\services\\subscription\\subscription-service.ts",}],
["D:\\code\\v\\metamask-extension\\app\\scripts\\services\\subscription\\types.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cservices%5Csubscription%5Ctypes.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SERVICE_NAME = void 0;
const SERVICE_NAME = exports.SERVICE_NAME = 'SubscriptionService';

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\services\\subscription\\types.ts",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\multibase\\src\\base.js", {"buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@ensdomains%5Ccontent-hash%5Cnode_modules%5Cmultibase%5Csrc%5Cbase.js
      return function (require, module, exports) {
// @ts-check
'use strict'
const { Buffer } = require('buffer')

/**
 * @typedef {Object} Codec
 * @property {function(Uint8Array):string} encode
 * @property {function(string):Uint8Array} decode
 *
 * @typedef {function(string):Codec} CodecFactory
 */

class Base {
  /**
   * @param {string} name
   * @param {string} code
   * @param {CodecFactory} implementation
   * @param {string} alphabet
   */
  constructor (name, code, implementation, alphabet) {
    this.name = name
    this.code = code
    this.codeBuf = Buffer.from(this.code)
    this.alphabet = alphabet
    this.engine = implementation(alphabet)
  }

  /**
   * @param {Uint8Array} buf
   * @returns {string}
   */
  encode (buf) {
    return this.engine.encode(buf)
  }

  /**
   * @param {string} string
   * @returns {Uint8Array}
   */
  decode (string) {
    for (const char of string) {
      if (this.alphabet && this.alphabet.indexOf(char) < 0) {
        throw new Error(`invalid character '${char}' in '${string}'`)
      }
    }
    return this.engine.decode(string)
  }
}

module.exports = Base

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multihashes>multibase",file:"node_modules\\@ensdomains\\content-hash\\node_modules\\multibase\\src\\base.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\multibase\\src\\constants.js", {"./base.js":"D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\multibase\\src\\base.js","./rfc4648":"D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\multibase\\src\\rfc4648.js","./util":"D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\multibase\\src\\util.js","base-x":"D:\\code\\v\\metamask-extension\\node_modules\\base-x\\src\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@ensdomains%5Ccontent-hash%5Cnode_modules%5Cmultibase%5Csrc%5Cconstants.js
      return function (require, module, exports) {
// @ts-check
'use strict'

const baseX = require('base-x')
const Base = require('./base.js')
const rfc4648 = require('./rfc4648')
const { decodeText, encodeText } = require('./util')

const identity = () => {
  return {
    encode: decodeText,
    decode: encodeText
  }
}

/**
 * @typedef {__import__('./base').CodecFactory} CodecFactory
 *
 * name, code, implementation, alphabet
 * @type {Array<[string, string, CodecFactory, string]>}
 */
const constants = [
  ['identity', '\x00', identity, ''],
  ['base2', '0', rfc4648(1), '01'],
  ['base8', '7', rfc4648(3), '01234567'],
  ['base10', '9', baseX, '0123456789'],
  ['base16', 'f', rfc4648(4), '0123456789abcdef'],
  ['base16upper', 'F', rfc4648(4), '0123456789ABCDEF'],
  ['base32hex', 'v', rfc4648(5), '0123456789abcdefghijklmnopqrstuv'],
  ['base32hexupper', 'V', rfc4648(5), '0123456789ABCDEFGHIJKLMNOPQRSTUV'],
  ['base32hexpad', 't', rfc4648(5), '0123456789abcdefghijklmnopqrstuv='],
  ['base32hexpadupper', 'T', rfc4648(5), '0123456789ABCDEFGHIJKLMNOPQRSTUV='],
  ['base32', 'b', rfc4648(5), 'abcdefghijklmnopqrstuvwxyz234567'],
  ['base32upper', 'B', rfc4648(5), 'ABCDEFGHIJKLMNOPQRSTUVWXYZ234567'],
  ['base32pad', 'c', rfc4648(5), 'abcdefghijklmnopqrstuvwxyz234567='],
  ['base32padupper', 'C', rfc4648(5), 'ABCDEFGHIJKLMNOPQRSTUVWXYZ234567='],
  ['base32z', 'h', rfc4648(5), 'ybndrfg8ejkmcpqxot1uwisza345h769'],
  ['base36', 'k', baseX, '0123456789abcdefghijklmnopqrstuvwxyz'],
  ['base36upper', 'K', baseX, '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'],
  ['base58btc', 'z', baseX, '123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz'],
  ['base58flickr', 'Z', baseX, '123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ'],
  ['base64', 'm', rfc4648(6), 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'],
  ['base64pad', 'M', rfc4648(6), 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/='],
  ['base64url', 'u', rfc4648(6), 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_'],
  ['base64urlpad', 'U', rfc4648(6), 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_=']
]

const names = constants.reduce((prev, tupple) => {
  prev[tupple[0]] = new Base(tupple[0], tupple[1], tupple[2], tupple[3])
  return prev
}, {})

const codes = constants.reduce((prev, tupple) => {
  prev[tupple[1]] = names[tupple[0]]
  return prev
}, {})

module.exports = {
  names,
  codes
}

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multihashes>multibase",file:"node_modules\\@ensdomains\\content-hash\\node_modules\\multibase\\src\\constants.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\multibase\\src\\index.js", {"./constants":"D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\multibase\\src\\constants.js","./util":"D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\multibase\\src\\util.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@ensdomains%5Ccontent-hash%5Cnode_modules%5Cmultibase%5Csrc%5Cindex.js
      return function (require, module, exports) {
// @ts-check
/**
 * Implementation of the [multibase](https://github.com/multiformats/multibase) specification.
 *
 * @module Multibase
 */
'use strict'

const { Buffer } = require('buffer')
const constants = require('./constants')
const { decodeText, asBuffer } = require('./util')

/** @typedef {__import__("./base")} Base */

/**
 * Create a new buffer with the multibase varint+code.
 *
 * @param {string|number} nameOrCode - The multibase name or code number.
 * @param {Uint8Array} buf - The data to be prefixed with multibase.
 * @returns {Buffer}
 * @throws {Error} Will throw if the encoding is not supported
 */
function multibase (nameOrCode, buf) {
  if (!buf) {
    throw new Error('requires an encoded buffer')
  }
  const { name, codeBuf } = encoding(nameOrCode)
  validEncode(name, buf)

  const buffer = Buffer.alloc(codeBuf.length + buf.length)
  buffer.set(codeBuf, 0)
  buffer.set(buf, codeBuf.length)

  return buffer
}

/**
 * Encode data with the specified base and add the multibase prefix.
 *
 * @param {string|number} nameOrCode - The multibase name or code number.
 * @param {Uint8Array} buf - The data to be encoded.
 * @returns {Buffer}
 * @throws {Error} Will throw if the encoding is not supported
 *
 */
function encode (nameOrCode, buf) {
  const enc = encoding(nameOrCode)

  return Buffer.concat([enc.codeBuf, Buffer.from(enc.encode(buf))])
}

/**
 * Takes a Uint8Array or string encoded with multibase header, decodes it and
 * returns the decoded buffer
 *
 * @param {Uint8Array|string} data
 * @returns {Buffer}
 * @throws {Error} Will throw if the encoding is not supported
 *
 */
function decode (data) {
  if (ArrayBuffer.isView(data)) {
    data = decodeText(data)
  }
  const prefix = data[0]

  // Make all encodings case-insensitive except the ones that include upper and lower chars in the alphabet
  if (['f', 'F', 'v', 'V', 't', 'T', 'b', 'B', 'c', 'C', 'h', 'k', 'K'].includes(prefix)) {
    data = data.toLowerCase()
  }
  const enc = encoding(data[0])
  return asBuffer(enc.decode(data.substring(1)))
}

/**
 * Is the given data multibase encoded?
 *
 * @param {Uint8Array|string} data
 * @returns {false|string}
 */
function isEncoded (data) {
  if (data instanceof Uint8Array) {
    data = decodeText(data)
  }

  // Ensure bufOrString is a string
  if (Object.prototype.toString.call(data) !== '[object String]') {
    return false
  }

  try {
    const enc = encoding(data[0])
    return enc.name
  } catch (err) {
    return false
  }
}

/**
 * Validate encoded data
 *
 * @param {string} name
 * @param {Uint8Array} buf
 * @returns {void}
 * @throws {Error} Will throw if the encoding is not supported
 */
function validEncode (name, buf) {
  const enc = encoding(name)
  enc.decode(decodeText(buf))
}

/**
 * Get the encoding by name or code
 *
 * @param {string|number} nameOrCode
 * @returns {Base}
 * @throws {Error} Will throw if the encoding is not supported
 */
function encoding (nameOrCode) {
  if (constants.names[nameOrCode]) {
    return constants.names[nameOrCode]
  } else if (constants.codes[nameOrCode]) {
    return constants.codes[nameOrCode]
  } else {
    throw new Error(`Unsupported encoding: ${nameOrCode}`)
  }
}

/**
 * Get encoding from data
 *
 * @param {string|Uint8Array} data
 * @returns {Base}
 * @throws {Error} Will throw if the encoding is not supported
 */
function encodingFromData (data) {
  if (data instanceof Uint8Array) {
    data = decodeText(data)
  }

  return encoding(data[0])
}

exports = module.exports = multibase
exports.encode = encode
exports.decode = decode
exports.isEncoded = isEncoded
exports.encoding = encoding
exports.encodingFromData = encodingFromData
exports.names = Object.freeze(constants.names)
exports.codes = Object.freeze(constants.codes)

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multihashes>multibase",file:"node_modules\\@ensdomains\\content-hash\\node_modules\\multibase\\src\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\multibase\\src\\rfc4648.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@ensdomains%5Ccontent-hash%5Cnode_modules%5Cmultibase%5Csrc%5Crfc4648.js
      return function (require, module, exports) {
// @ts-check
'use strict'

/** @typedef {__import__('./base').CodecFactory} CodecFactory */

/**
 * @param {string} string
 * @param {string} alphabet
 * @param {number} bitsPerChar
 * @returns {Uint8Array}
 */
const decode = (string, alphabet, bitsPerChar) => {
  // Build the character lookup table:
  const codes = {}
  for (let i = 0; i < alphabet.length; ++i) {
    codes[alphabet[i]] = i
  }

  // Count the padding bytes:
  let end = string.length
  while (string[end - 1] === '=') {
    --end
  }

  // Allocate the output:
  const out = new Uint8Array((end * bitsPerChar / 8) | 0)

  // Parse the data:
  let bits = 0 // Number of bits currently in the buffer
  let buffer = 0 // Bits waiting to be written out, MSB first
  let written = 0 // Next byte to write
  for (let i = 0; i < end; ++i) {
    // Read one character from the string:
    const value = codes[string[i]]
    if (value === undefined) {
      throw new SyntaxError('Invalid character ' + string[i])
    }

    // Append the bits to the buffer:
    buffer = (buffer << bitsPerChar) | value
    bits += bitsPerChar

    // Write out some bits if the buffer has a byte's worth:
    if (bits >= 8) {
      bits -= 8
      out[written++] = 0xff & (buffer >> bits)
    }
  }

  // Verify that we have received just enough bits:
  if (bits >= bitsPerChar || 0xff & (buffer << (8 - bits))) {
    throw new SyntaxError('Unexpected end of data')
  }

  return out
}

/**
 * @param {Uint8Array} data
 * @param {string} alphabet
 * @param {number} bitsPerChar
 * @returns {string}
 */
const encode = (data, alphabet, bitsPerChar) => {
  const pad = alphabet[alphabet.length - 1] === '='
  const mask = (1 << bitsPerChar) - 1
  let out = ''

  let bits = 0 // Number of bits currently in the buffer
  let buffer = 0 // Bits waiting to be written out, MSB first
  for (let i = 0; i < data.length; ++i) {
    // Slurp data into the buffer:
    buffer = (buffer << 8) | data[i]
    bits += 8

    // Write out as much as we can:
    while (bits > bitsPerChar) {
      bits -= bitsPerChar
      out += alphabet[mask & (buffer >> bits)]
    }
  }

  // Partial character:
  if (bits) {
    out += alphabet[mask & (buffer << (bitsPerChar - bits))]
  }

  // Add padding characters until we hit a byte boundary:
  if (pad) {
    while ((out.length * bitsPerChar) & 7) {
      out += '='
    }
  }

  return out
}

/**
 * @param {number} bitsPerChar
 * @returns {CodecFactory}
 */
module.exports = (bitsPerChar) => (alphabet) => {
  return {
    /**
     * @param {Uint8Array} input
     * @returns {string}
     */
    encode (input) {
      return encode(input, alphabet, bitsPerChar)
    },
    /**
     * @param {string} input
     * @returns {Uint8Array}
     */
    decode (input) {
      return decode(input, alphabet, bitsPerChar)
    }
  }
}

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multihashes>multibase",file:"node_modules\\@ensdomains\\content-hash\\node_modules\\multibase\\src\\rfc4648.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\multibase\\src\\util.js", {"buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js","web-encoding":"D:\\code\\v\\metamask-extension\\node_modules\\web-encoding\\src\\lib.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@ensdomains%5Ccontent-hash%5Cnode_modules%5Cmultibase%5Csrc%5Cutil.js
      return function (require, module, exports) {
// @ts-check
'use strict'

const { Buffer } = require('buffer')
const { TextEncoder, TextDecoder } = require('web-encoding')

const textDecoder = new TextDecoder()
/**
 * @param {ArrayBufferView|ArrayBuffer} bytes
 * @returns {string}
 */
const decodeText = (bytes) => textDecoder.decode(bytes)

const textEncoder = new TextEncoder()
/**
 * @param {string} text
 * @returns {Uint8Array}
 */
const encodeText = (text) => textEncoder.encode(text)

/**
 * @param {ArrayBufferView} bytes
 * @returns {Buffer}
 */
const asBuffer = ({ buffer, byteLength, byteOffset }) =>
  Buffer.from(buffer, byteOffset, byteLength)

module.exports = { decodeText, encodeText, asBuffer }

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multihashes>multibase",file:"node_modules\\@ensdomains\\content-hash\\node_modules\\multibase\\src\\util.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\multihashes\\src\\constants.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@ensdomains%5Ccontent-hash%5Cnode_modules%5Cmultihashes%5Csrc%5Cconstants.js
      return function (require, module, exports) {
/* eslint quote-props: off */
'use strict'

const names = Object.freeze({
  'identity': 0x00,
  'sha1': 0x11,
  'sha2-256': 0x12,
  'sha2-512': 0x13,
  'sha3-512': 0x14,
  'sha3-384': 0x15,
  'sha3-256': 0x16,
  'sha3-224': 0x17,
  'shake-128': 0x18,
  'shake-256': 0x19,
  'keccak-224': 0x1a,
  'keccak-256': 0x1b,
  'keccak-384': 0x1c,
  'keccak-512': 0x1d,
  'blake3': 0x1e,
  'murmur3-128': 0x22,
  'murmur3-32': 0x23,
  'dbl-sha2-256': 0x56,
  'md4': 0xd4,
  'md5': 0xd5,
  'bmt': 0xd6,
  'sha2-256-trunc254-padded': 0x1012,
  'ripemd-128': 0x1052,
  'ripemd-160': 0x1053,
  'ripemd-256': 0x1054,
  'ripemd-320': 0x1055,
  'x11': 0x1100,
  'sm3-256': 0x534d,
  'blake2b-8': 0xb201,
  'blake2b-16': 0xb202,
  'blake2b-24': 0xb203,
  'blake2b-32': 0xb204,
  'blake2b-40': 0xb205,
  'blake2b-48': 0xb206,
  'blake2b-56': 0xb207,
  'blake2b-64': 0xb208,
  'blake2b-72': 0xb209,
  'blake2b-80': 0xb20a,
  'blake2b-88': 0xb20b,
  'blake2b-96': 0xb20c,
  'blake2b-104': 0xb20d,
  'blake2b-112': 0xb20e,
  'blake2b-120': 0xb20f,
  'blake2b-128': 0xb210,
  'blake2b-136': 0xb211,
  'blake2b-144': 0xb212,
  'blake2b-152': 0xb213,
  'blake2b-160': 0xb214,
  'blake2b-168': 0xb215,
  'blake2b-176': 0xb216,
  'blake2b-184': 0xb217,
  'blake2b-192': 0xb218,
  'blake2b-200': 0xb219,
  'blake2b-208': 0xb21a,
  'blake2b-216': 0xb21b,
  'blake2b-224': 0xb21c,
  'blake2b-232': 0xb21d,
  'blake2b-240': 0xb21e,
  'blake2b-248': 0xb21f,
  'blake2b-256': 0xb220,
  'blake2b-264': 0xb221,
  'blake2b-272': 0xb222,
  'blake2b-280': 0xb223,
  'blake2b-288': 0xb224,
  'blake2b-296': 0xb225,
  'blake2b-304': 0xb226,
  'blake2b-312': 0xb227,
  'blake2b-320': 0xb228,
  'blake2b-328': 0xb229,
  'blake2b-336': 0xb22a,
  'blake2b-344': 0xb22b,
  'blake2b-352': 0xb22c,
  'blake2b-360': 0xb22d,
  'blake2b-368': 0xb22e,
  'blake2b-376': 0xb22f,
  'blake2b-384': 0xb230,
  'blake2b-392': 0xb231,
  'blake2b-400': 0xb232,
  'blake2b-408': 0xb233,
  'blake2b-416': 0xb234,
  'blake2b-424': 0xb235,
  'blake2b-432': 0xb236,
  'blake2b-440': 0xb237,
  'blake2b-448': 0xb238,
  'blake2b-456': 0xb239,
  'blake2b-464': 0xb23a,
  'blake2b-472': 0xb23b,
  'blake2b-480': 0xb23c,
  'blake2b-488': 0xb23d,
  'blake2b-496': 0xb23e,
  'blake2b-504': 0xb23f,
  'blake2b-512': 0xb240,
  'blake2s-8': 0xb241,
  'blake2s-16': 0xb242,
  'blake2s-24': 0xb243,
  'blake2s-32': 0xb244,
  'blake2s-40': 0xb245,
  'blake2s-48': 0xb246,
  'blake2s-56': 0xb247,
  'blake2s-64': 0xb248,
  'blake2s-72': 0xb249,
  'blake2s-80': 0xb24a,
  'blake2s-88': 0xb24b,
  'blake2s-96': 0xb24c,
  'blake2s-104': 0xb24d,
  'blake2s-112': 0xb24e,
  'blake2s-120': 0xb24f,
  'blake2s-128': 0xb250,
  'blake2s-136': 0xb251,
  'blake2s-144': 0xb252,
  'blake2s-152': 0xb253,
  'blake2s-160': 0xb254,
  'blake2s-168': 0xb255,
  'blake2s-176': 0xb256,
  'blake2s-184': 0xb257,
  'blake2s-192': 0xb258,
  'blake2s-200': 0xb259,
  'blake2s-208': 0xb25a,
  'blake2s-216': 0xb25b,
  'blake2s-224': 0xb25c,
  'blake2s-232': 0xb25d,
  'blake2s-240': 0xb25e,
  'blake2s-248': 0xb25f,
  'blake2s-256': 0xb260,
  'skein256-8': 0xb301,
  'skein256-16': 0xb302,
  'skein256-24': 0xb303,
  'skein256-32': 0xb304,
  'skein256-40': 0xb305,
  'skein256-48': 0xb306,
  'skein256-56': 0xb307,
  'skein256-64': 0xb308,
  'skein256-72': 0xb309,
  'skein256-80': 0xb30a,
  'skein256-88': 0xb30b,
  'skein256-96': 0xb30c,
  'skein256-104': 0xb30d,
  'skein256-112': 0xb30e,
  'skein256-120': 0xb30f,
  'skein256-128': 0xb310,
  'skein256-136': 0xb311,
  'skein256-144': 0xb312,
  'skein256-152': 0xb313,
  'skein256-160': 0xb314,
  'skein256-168': 0xb315,
  'skein256-176': 0xb316,
  'skein256-184': 0xb317,
  'skein256-192': 0xb318,
  'skein256-200': 0xb319,
  'skein256-208': 0xb31a,
  'skein256-216': 0xb31b,
  'skein256-224': 0xb31c,
  'skein256-232': 0xb31d,
  'skein256-240': 0xb31e,
  'skein256-248': 0xb31f,
  'skein256-256': 0xb320,
  'skein512-8': 0xb321,
  'skein512-16': 0xb322,
  'skein512-24': 0xb323,
  'skein512-32': 0xb324,
  'skein512-40': 0xb325,
  'skein512-48': 0xb326,
  'skein512-56': 0xb327,
  'skein512-64': 0xb328,
  'skein512-72': 0xb329,
  'skein512-80': 0xb32a,
  'skein512-88': 0xb32b,
  'skein512-96': 0xb32c,
  'skein512-104': 0xb32d,
  'skein512-112': 0xb32e,
  'skein512-120': 0xb32f,
  'skein512-128': 0xb330,
  'skein512-136': 0xb331,
  'skein512-144': 0xb332,
  'skein512-152': 0xb333,
  'skein512-160': 0xb334,
  'skein512-168': 0xb335,
  'skein512-176': 0xb336,
  'skein512-184': 0xb337,
  'skein512-192': 0xb338,
  'skein512-200': 0xb339,
  'skein512-208': 0xb33a,
  'skein512-216': 0xb33b,
  'skein512-224': 0xb33c,
  'skein512-232': 0xb33d,
  'skein512-240': 0xb33e,
  'skein512-248': 0xb33f,
  'skein512-256': 0xb340,
  'skein512-264': 0xb341,
  'skein512-272': 0xb342,
  'skein512-280': 0xb343,
  'skein512-288': 0xb344,
  'skein512-296': 0xb345,
  'skein512-304': 0xb346,
  'skein512-312': 0xb347,
  'skein512-320': 0xb348,
  'skein512-328': 0xb349,
  'skein512-336': 0xb34a,
  'skein512-344': 0xb34b,
  'skein512-352': 0xb34c,
  'skein512-360': 0xb34d,
  'skein512-368': 0xb34e,
  'skein512-376': 0xb34f,
  'skein512-384': 0xb350,
  'skein512-392': 0xb351,
  'skein512-400': 0xb352,
  'skein512-408': 0xb353,
  'skein512-416': 0xb354,
  'skein512-424': 0xb355,
  'skein512-432': 0xb356,
  'skein512-440': 0xb357,
  'skein512-448': 0xb358,
  'skein512-456': 0xb359,
  'skein512-464': 0xb35a,
  'skein512-472': 0xb35b,
  'skein512-480': 0xb35c,
  'skein512-488': 0xb35d,
  'skein512-496': 0xb35e,
  'skein512-504': 0xb35f,
  'skein512-512': 0xb360,
  'skein1024-8': 0xb361,
  'skein1024-16': 0xb362,
  'skein1024-24': 0xb363,
  'skein1024-32': 0xb364,
  'skein1024-40': 0xb365,
  'skein1024-48': 0xb366,
  'skein1024-56': 0xb367,
  'skein1024-64': 0xb368,
  'skein1024-72': 0xb369,
  'skein1024-80': 0xb36a,
  'skein1024-88': 0xb36b,
  'skein1024-96': 0xb36c,
  'skein1024-104': 0xb36d,
  'skein1024-112': 0xb36e,
  'skein1024-120': 0xb36f,
  'skein1024-128': 0xb370,
  'skein1024-136': 0xb371,
  'skein1024-144': 0xb372,
  'skein1024-152': 0xb373,
  'skein1024-160': 0xb374,
  'skein1024-168': 0xb375,
  'skein1024-176': 0xb376,
  'skein1024-184': 0xb377,
  'skein1024-192': 0xb378,
  'skein1024-200': 0xb379,
  'skein1024-208': 0xb37a,
  'skein1024-216': 0xb37b,
  'skein1024-224': 0xb37c,
  'skein1024-232': 0xb37d,
  'skein1024-240': 0xb37e,
  'skein1024-248': 0xb37f,
  'skein1024-256': 0xb380,
  'skein1024-264': 0xb381,
  'skein1024-272': 0xb382,
  'skein1024-280': 0xb383,
  'skein1024-288': 0xb384,
  'skein1024-296': 0xb385,
  'skein1024-304': 0xb386,
  'skein1024-312': 0xb387,
  'skein1024-320': 0xb388,
  'skein1024-328': 0xb389,
  'skein1024-336': 0xb38a,
  'skein1024-344': 0xb38b,
  'skein1024-352': 0xb38c,
  'skein1024-360': 0xb38d,
  'skein1024-368': 0xb38e,
  'skein1024-376': 0xb38f,
  'skein1024-384': 0xb390,
  'skein1024-392': 0xb391,
  'skein1024-400': 0xb392,
  'skein1024-408': 0xb393,
  'skein1024-416': 0xb394,
  'skein1024-424': 0xb395,
  'skein1024-432': 0xb396,
  'skein1024-440': 0xb397,
  'skein1024-448': 0xb398,
  'skein1024-456': 0xb399,
  'skein1024-464': 0xb39a,
  'skein1024-472': 0xb39b,
  'skein1024-480': 0xb39c,
  'skein1024-488': 0xb39d,
  'skein1024-496': 0xb39e,
  'skein1024-504': 0xb39f,
  'skein1024-512': 0xb3a0,
  'skein1024-520': 0xb3a1,
  'skein1024-528': 0xb3a2,
  'skein1024-536': 0xb3a3,
  'skein1024-544': 0xb3a4,
  'skein1024-552': 0xb3a5,
  'skein1024-560': 0xb3a6,
  'skein1024-568': 0xb3a7,
  'skein1024-576': 0xb3a8,
  'skein1024-584': 0xb3a9,
  'skein1024-592': 0xb3aa,
  'skein1024-600': 0xb3ab,
  'skein1024-608': 0xb3ac,
  'skein1024-616': 0xb3ad,
  'skein1024-624': 0xb3ae,
  'skein1024-632': 0xb3af,
  'skein1024-640': 0xb3b0,
  'skein1024-648': 0xb3b1,
  'skein1024-656': 0xb3b2,
  'skein1024-664': 0xb3b3,
  'skein1024-672': 0xb3b4,
  'skein1024-680': 0xb3b5,
  'skein1024-688': 0xb3b6,
  'skein1024-696': 0xb3b7,
  'skein1024-704': 0xb3b8,
  'skein1024-712': 0xb3b9,
  'skein1024-720': 0xb3ba,
  'skein1024-728': 0xb3bb,
  'skein1024-736': 0xb3bc,
  'skein1024-744': 0xb3bd,
  'skein1024-752': 0xb3be,
  'skein1024-760': 0xb3bf,
  'skein1024-768': 0xb3c0,
  'skein1024-776': 0xb3c1,
  'skein1024-784': 0xb3c2,
  'skein1024-792': 0xb3c3,
  'skein1024-800': 0xb3c4,
  'skein1024-808': 0xb3c5,
  'skein1024-816': 0xb3c6,
  'skein1024-824': 0xb3c7,
  'skein1024-832': 0xb3c8,
  'skein1024-840': 0xb3c9,
  'skein1024-848': 0xb3ca,
  'skein1024-856': 0xb3cb,
  'skein1024-864': 0xb3cc,
  'skein1024-872': 0xb3cd,
  'skein1024-880': 0xb3ce,
  'skein1024-888': 0xb3cf,
  'skein1024-896': 0xb3d0,
  'skein1024-904': 0xb3d1,
  'skein1024-912': 0xb3d2,
  'skein1024-920': 0xb3d3,
  'skein1024-928': 0xb3d4,
  'skein1024-936': 0xb3d5,
  'skein1024-944': 0xb3d6,
  'skein1024-952': 0xb3d7,
  'skein1024-960': 0xb3d8,
  'skein1024-968': 0xb3d9,
  'skein1024-976': 0xb3da,
  'skein1024-984': 0xb3db,
  'skein1024-992': 0xb3dc,
  'skein1024-1000': 0xb3dd,
  'skein1024-1008': 0xb3de,
  'skein1024-1016': 0xb3df,
  'skein1024-1024': 0xb3e0,
  'poseidon-bls12_381-a2-fc1': 0xb401,
  'poseidon-bls12_381-a2-fc1-sc': 0xb402
})

module.exports = { names }

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multihashes",file:"node_modules\\@ensdomains\\content-hash\\node_modules\\multihashes\\src\\constants.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\multihashes\\src\\index.js", {"./constants":"D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\multihashes\\src\\constants.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js","multibase":"D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\multibase\\src\\index.js","varint":"D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\varint\\index.js","web-encoding":"D:\\code\\v\\metamask-extension\\node_modules\\web-encoding\\src\\lib.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@ensdomains%5Ccontent-hash%5Cnode_modules%5Cmultihashes%5Csrc%5Cindex.js
      return function (require, module, exports) {
// @ts-check
/* eslint-disable guard-for-in */
/**
 * Multihash implementation in JavaScript.
 *
 * @module multihash
 */
'use strict'

const { Buffer } = require('buffer')
const multibase = require('multibase')
const varint = require('varint')
const { names } = require('./constants')
const { TextDecoder } = require('web-encoding')

const textDecoder = new TextDecoder()
const codes = {}

for (const key in names) {
  codes[names[key]] = key
}
exports.names = names
exports.codes = Object.freeze(codes)

/**
 * Convert the given multihash to a hex encoded string.
 *
 * @param {Uint8Array} hash
 * @returns {string}
 */
exports.toHexString = function toHexString (hash) {
  if (!(hash instanceof Uint8Array)) {
    throw new Error('must be passed a Uint8Array')
  }

  const buffer = Buffer.isBuffer(hash)
    ? hash
    : Buffer.from(hash.buffer, hash.byteOffset, hash.byteLength)

  return buffer.toString('hex')
}

/**
 * Convert the given hex encoded string to a multihash.
 *
 * @param {string} hash
 * @returns {Buffer}
 */
exports.fromHexString = function fromHexString (hash) {
  return Buffer.from(hash, 'hex')
}

/**
 * Convert the given multihash to a base58 encoded string.
 *
 * @param {Uint8Array} hash
 * @returns {string}
 */
exports.toB58String = function toB58String (hash) {
  if (!(hash instanceof Uint8Array)) {
    throw new Error('must be passed a Uint8Array')
  }

  return textDecoder.decode(multibase.encode('base58btc', hash)).slice(1)
}

/**
 * Convert the given base58 encoded string to a multihash.
 *
 * @param {string|Uint8Array} hash
 * @returns {Buffer}
 */
exports.fromB58String = function fromB58String (hash) {
  const encoded = hash instanceof Uint8Array
    ? textDecoder.decode(hash)
    : hash

  return multibase.decode('z' + encoded)
}

/**
 * Decode a hash from the given multihash.
 *
 * @param {Uint8Array} bytes
 * @returns {{code: number, name: string, length: number, digest: Buffer}} result
 */
exports.decode = function decode (bytes) {
  if (!(bytes instanceof Uint8Array)) {
    throw new Error('multihash must be a Uint8Array')
  }
  let buf = Buffer.isBuffer(bytes)
    ? bytes
    : Buffer.from(bytes.buffer, bytes.byteOffset, bytes.byteLength)

  if (buf.length < 2) {
    throw new Error('multihash too short. must be > 2 bytes.')
  }

  const code = varint.decode(buf)
  if (!exports.isValidCode(code)) {
    throw new Error(`multihash unknown function code: 0x${code.toString(16)}`)
  }
  buf = buf.slice(varint.decode.bytes)

  const len = varint.decode(buf)
  if (len < 0) {
    throw new Error(`multihash invalid length: ${len}`)
  }
  buf = buf.slice(varint.decode.bytes)

  if (buf.length !== len) {
    throw new Error(`multihash length inconsistent: 0x${buf.toString('hex')}`)
  }

  return {
    code,
    name: codes[code],
    length: len,
    digest: buf
  }
}

/**
 *  Encode a hash digest along with the specified function code.
 *
 * > **Note:** the length is derived from the length of the digest itself.
 *
 * @param {Uint8Array} digest
 * @param {string|number} code
 * @param {number} [length]
 * @returns {Buffer}
 */
exports.encode = function encode (digest, code, length) {
  if (!digest || code === undefined) {
    throw new Error('multihash encode requires at least two args: digest, code')
  }

  // ensure it's a hashfunction code.
  const hashfn = exports.coerceCode(code)

  if (!(digest instanceof Uint8Array)) {
    throw new Error('digest should be a Uint8Array')
  }

  if (length == null) {
    length = digest.length
  }

  if (length && digest.length !== length) {
    throw new Error('digest length should be equal to specified length.')
  }

  const hash = varint.encode(hashfn)
  const len = varint.encode(length)
  const buffer = Buffer.alloc(hash.length + len.length + digest.length)
  buffer.set(hash, 0)
  buffer.set(len, hash.length)
  buffer.set(digest, hash.length + len.length)
  return buffer
}

/**
 * Converts a hash function name into the matching code.
 * If passed a number it will return the number if it's a valid code.
 * @param {string|number} name
 * @returns {number}
 */
exports.coerceCode = function coerceCode (name) {
  let code = name

  if (typeof name === 'string') {
    if (names[name] === undefined) {
      throw new Error(`Unrecognized hash function named: ${name}`)
    }
    code = names[name]
  }

  if (typeof code !== 'number') {
    throw new Error(`Hash function code should be a number. Got: ${code}`)
  }

  if (codes[code] === undefined && !exports.isAppCode(code)) {
    throw new Error(`Unrecognized function code: ${code}`)
  }

  return code
}

/**
 * Checks wether a code is part of the app range
 *
 * @param {number} code
 * @returns {boolean}
 */
exports.isAppCode = function appCode (code) {
  return code > 0 && code < 0x10
}

/**
 * Checks whether a multihash code is valid.
 *
 * @param {number} code
 * @returns {boolean}
 */
exports.isValidCode = function validCode (code) {
  if (exports.isAppCode(code)) {
    return true
  }

  if (codes[code]) {
    return true
  }

  return false
}

/**
 * Check if the given buffer is a valid multihash. Throws an error if it is not valid.
 *
 * @param {Uint8Array} multihash
 * @returns {void}
 * @throws {Error}
 */
function validate (multihash) {
  exports.decode(multihash) // throws if bad.
}
exports.validate = validate

/**
 * Returns a prefix from a valid multihash. Throws an error if it is not valid.
 *
 * @param {Uint8Array} multihash
 * @returns {Buffer}
 * @throws {Error}
 */
exports.prefix = function prefix (multihash) {
  validate(multihash)

  return Buffer.from(multihash.buffer, multihash.byteOffset, 2)
}

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multihashes",file:"node_modules\\@ensdomains\\content-hash\\node_modules\\multihashes\\src\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\varint\\decode.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@ensdomains%5Ccontent-hash%5Cnode_modules%5Cvarint%5Cdecode.js
      return function (require, module, exports) {
module.exports = read

var MSB = 0x80
  , REST = 0x7F

function read(buf, offset) {
  var res    = 0
    , offset = offset || 0
    , shift  = 0
    , counter = offset
    , b
    , l = buf.length

  do {
    if (counter >= l) {
      read.bytes = 0
      throw new RangeError('Could not decode varint')
    }
    b = buf[counter++]
    res += shift < 28
      ? (b & REST) << shift
      : (b & REST) * Math.pow(2, shift)
    shift += 7
  } while (b >= MSB)

  read.bytes = counter - offset

  return res
}

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multihashes>varint",file:"node_modules\\@ensdomains\\content-hash\\node_modules\\varint\\decode.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\varint\\encode.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@ensdomains%5Ccontent-hash%5Cnode_modules%5Cvarint%5Cencode.js
      return function (require, module, exports) {
module.exports = encode

var MSB = 0x80
  , REST = 0x7F
  , MSBALL = ~REST
  , INT = Math.pow(2, 31)

function encode(num, out, offset) {
  out = out || []
  offset = offset || 0
  var oldOffset = offset

  while(num >= INT) {
    out[offset++] = (num & 0xFF) | MSB
    num /= 128
  }
  while(num & MSBALL) {
    out[offset++] = (num & 0xFF) | MSB
    num >>>= 7
  }
  out[offset] = num | 0
  
  encode.bytes = offset - oldOffset + 1
  
  return out
}

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multihashes>varint",file:"node_modules\\@ensdomains\\content-hash\\node_modules\\varint\\encode.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\varint\\index.js", {"./decode.js":"D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\varint\\decode.js","./encode.js":"D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\varint\\encode.js","./length.js":"D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\varint\\length.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@ensdomains%5Ccontent-hash%5Cnode_modules%5Cvarint%5Cindex.js
      return function (require, module, exports) {
module.exports = {
    encode: require('./encode.js')
  , decode: require('./decode.js')
  , encodingLength: require('./length.js')
}

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multihashes>varint",file:"node_modules\\@ensdomains\\content-hash\\node_modules\\varint\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\varint\\length.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@ensdomains%5Ccontent-hash%5Cnode_modules%5Cvarint%5Clength.js
      return function (require, module, exports) {

var N1 = Math.pow(2,  7)
var N2 = Math.pow(2, 14)
var N3 = Math.pow(2, 21)
var N4 = Math.pow(2, 28)
var N5 = Math.pow(2, 35)
var N6 = Math.pow(2, 42)
var N7 = Math.pow(2, 49)
var N8 = Math.pow(2, 56)
var N9 = Math.pow(2, 63)

module.exports = function (value) {
  return (
    value < N1 ? 1
  : value < N2 ? 2
  : value < N3 ? 3
  : value < N4 ? 4
  : value < N5 ? 5
  : value < N6 ? 6
  : value < N7 ? 7
  : value < N8 ? 8
  : value < N9 ? 9
  :              10
  )
}

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multihashes>varint",file:"node_modules\\@ensdomains\\content-hash\\node_modules\\varint\\length.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\src\\helpers.js", {"cids":"D:\\code\\v\\metamask-extension\\node_modules\\cids\\src\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@ensdomains%5Ccontent-hash%5Csrc%5Chelpers.js
      return function (require, module, exports) {
/*
	ISC License

	Copyright (c) 2019, Pierre-Louis Despaigne

	Permission to use, copy, modify, and/or distribute this software for any
	purpose with or without fee is hereby granted, provided that the above
	copyright notice and this permission notice appear in all copies.

	THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
	WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
	MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
	ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
	WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
	ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
	OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/

const CID = require('cids');

// Label's max length in DNS (https://tools.ietf.org/html/rfc1034#page-7)
const dnsLabelMaxLength = 63;

/**
 * Take any ipfsHash and convert it to DNS-compatible CID
 * @param {string} ipfsHash a regular ipfs hash either a cid v0 or v1
 * @return {string} the resulting ipfs hash as a cid v1
 */
const cidForWeb = (ipfsHash) => {
	let cid = new CID(ipfsHash);
	if (cid.version === 0) {
		cid = cid.toV1();
	}
  let dnsLabel = cid.toString('base32');
  if (dnsLabel.length > dnsLabelMaxLength) {
    const b36 = cid.toString('base36');
    if (b36.length <= dnsLabelMaxLength) {
      return b36;
    }
    throw new TypeError ('CID is longer than DNS limit of 63 characters and is not compatible with public gateways');
  }
	return dnsLabel;
}

exports.cidForWeb = cidForWeb;


/**
 * Take any ipfsHash and convert it to a CID v1 encoded in base32.
 * @param {string} ipfsHash a regular ipfs hash either a cid v0 or v1 (v1 will remain unchanged)
 * @return {string} the resulting ipfs hash as a cid v1
 */
const cidV0ToV1Base32 = (ipfsHash) => {
	let cid = new CID(ipfsHash);
	if (cid.version === 0) {
		cid = cid.toV1();
	}
	return cid.toString('base32');
}

exports.cidV0ToV1Base32 = cidV0ToV1Base32;

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash",file:"node_modules\\@ensdomains\\content-hash\\src\\helpers.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\src\\index.js", {"./helpers":"D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\src\\helpers.js","./profiles":"D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\src\\profiles.js","multicodec":"D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\src\\index.js","multihashes":"D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\multihashes\\src\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@ensdomains%5Ccontent-hash%5Csrc%5Cindex.js
      return function (require, module, exports) {
/*
	ISC License

	Copyright (c) 2019, Pierre-Louis Despaigne

	Permission to use, copy, modify, and/or distribute this software for any
	purpose with or without fee is hereby granted, provided that the above
	copyright notice and this permission notice appear in all copies.

	THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
	WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
	MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
	ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
	WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
	ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
	OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/

const multiC = require('multicodec');
const multiH = require('multihashes');

const { hexStringToBuffer, profiles } = require('./profiles');
const { cidForWeb, cidV0ToV1Base32 } = require('./helpers');

module.exports = {

	//export some helpers functions
	helpers: {
		cidForWeb,
		cidV0ToV1Base32,
	},

	/**
	* Decode a Content Hash.
	* @param {string} hash an hex string containing a content hash
	* @return {string} the decoded content
	*/
	decode: function (contentHash) {
		const buffer = hexStringToBuffer(contentHash);
		const codec = multiC.getCodec(buffer);
		const value = multiC.rmPrefix(buffer);
		let profile = profiles[codec];
		if (!profile) profile = profiles['default'];
		return profile.decode(value);
	},

	/**
	* Encode an IPFS address into a content hash
	* @param {string} ipfsHash string containing an IPFS address
	* @return {string} the resulting content hash
	*/
	fromIpfs: function (ipfsHash) {
		return this.encode('ipfs-ns', ipfsHash);
	},

	/**
	* Encode a Skylink into a content hash
	* @param {string} skylink string containing a Skylink
	* @return {string} the resulting content hash
	*/
	fromSkylink: function (skylink) {
		return this.encode('skynet-ns', skylink);
	},

	/**
	* Encode a Swarm address into a content hash
	* @param {string} swarmHash string containing a Swarm address
	* @return {string} the resulting content hash
	*/
	fromSwarm: function (swarmHash) {
		return this.encode('swarm-ns', swarmHash);
	},

    /**
	* Encode a arweave address into a content hash
	* @param {string} swarmHash string containing a arweave address
	* @return {string} the resulting content hash
	*/
    fromArweave: function(arweave) {
        return this.encode('arweave-ns', arweave);
    },

	/**
	* General purpose encoding function
  * @param {string} codec 
  * @param {string} value 
  */
	encode: function (codec, value) {
		let profile = profiles[codec];
		if (!profile) profile = profiles['default'];
		const encodedValue = profile.encode(value);
		return multiH.toHexString(multiC.addPrefix(codec, encodedValue))
	},

	/**
	* Extract the codec of a content hash
	* @param {string} hash hex string containing a content hash
	* @return {string} the extracted codec
	*/
	getCodec: function (hash) {
		let buffer = hexStringToBuffer(hash);
		return multiC.getCodec(buffer);
	},
}

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash",file:"node_modules\\@ensdomains\\content-hash\\src\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\src\\profiles.js", {"buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js","cids":"D:\\code\\v\\metamask-extension\\node_modules\\cids\\src\\index.js","js-base64":"D:\\code\\v\\metamask-extension\\node_modules\\js-base64\\base64.js","multihashes":"D:\\code\\v\\metamask-extension\\node_modules\\@ensdomains\\content-hash\\node_modules\\multihashes\\src\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@ensdomains%5Ccontent-hash%5Csrc%5Cprofiles.js
      return function (require, module, exports) {
(function (Buffer){(function (){
/*
	ISC License

	Copyright (c) 2019, Pierre-Louis Despaigne

	Permission to use, copy, modify, and/or distribute this software for any
	purpose with or without fee is hereby granted, provided that the above
	copyright notice and this permission notice appear in all copies.

	THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
	WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
	MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
	ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
	WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
	ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
	OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/

const CID = require('cids');
const multiH = require('multihashes');
const base64 = require('js-base64')

/**
 * Convert an hexadecimal string to a Buffer, the string can start with or without '0x'
 * @param {string} hex an hexadecimal value
 * @return {Buffer} the resulting Buffer
 */
const hexStringToBuffer = (hex) => {
	let prefix = hex.slice(0, 2);
	let value = hex.slice(2);
	let res = '';
	if (prefix === '0x') res = value;
	else res = hex;
	return multiH.fromHexString(res);
}

/**
 * Validates IPNS identifier  to safeguard against insecure names.
 * @param {CID} name ised in ipns-ns
 * @return {bool}
 */
const isCryptographicIPNS =  (cid) => {
  try {
    const { multihash } = cid
    // Additional check for identifiers shorter
    // than what inlined ED25519 pubkey would be
    // https://github.com/ensdomains/ens-app/issues/849#issuecomment-777088950
    if (multihash.length < 38) {
      const mh = multiH.decode(multihash)
      // ED25519 pubkeys are inlined using identity hash function
      // and we should not see anything shorter than that
      if (mh.name === 'identity' && mh.length < 36) {
        // One can read inlined string value via:
        // console.log('ipns-ns id:', String(multiH.decode(new CID(value).multihash).digest))
        return false
      }
    }
    // ok, CID looks fine
    return true
  } catch (_) { return false }
}

/**
* list of known encoding,
* encoding should be a function that takes a `string` input,
* and return a `Buffer` result
*/
const encodes = {
  /**
  * @param {string} value
  * @return {Buffer}
  */
  skynet: (value) => {
    return base64.toUint8Array(value)
  },
  /**
  * @param {string} value
  * @return {Buffer}
  */
  swarm: (value) => {
    const multihash = multiH.encode(hexStringToBuffer(value), 'keccak-256');
		return new CID(1, 'swarm-manifest', multihash).bytes;
  },
  /**
  * @param {string} value
  * @return {Buffer}
  */
  ipfs: (value) => {
    return new CID(value).toV1().bytes;
  },
  /**
  * @param {string} value
  * @return {Buffer}
  */
  ipns: (value) => {
    const cid = new CID(value)
    if (!isCryptographicIPNS(cid)) {
        throw Error('ipns-ns allows only valid cryptographic libp2p-key identifiers, try using ED25519 pubkey instead')
    }
    // Represent IPNS name as a CID with libp2p-key codec
    // https://github.com/libp2p/specs/blob/master/RFC/0001-text-peerid-cid.md
    return new CID(1, 'libp2p-key', cid.multihash).bytes
  },
  /**
  * @param {string} value
  * @return {Buffer}
  */
  utf8: (value) => {
    return Buffer.from(value, 'utf8');
  },
  /**
  * @param {string} value
  * @return {Buffer}
  */
  arweave: (value) => {
    return base64.toUint8Array(value)
  },
};

/** 
* list of known decoding,
* decoding should be a function that takes a `Buffer` input,
* and return a `string` result
*/
const decodes = {
  /**
  * @param {Buffer} value 
  */
  hexMultiHash: (value) => {
    const cid = new CID(value);
    return multiH.decode(cid.multihash).digest.toString('hex');
  },
  /**
  * @param {Buffer} value 
  */
  ipfs: (value) => {
    const cid = new CID(value).toV1();
    return cid.toString(cid.codec === 'libp2p-key' ? 'base36' : 'base32')
  },
  /**
  * @param {Buffer} value 
  */
  ipns: (value) => {
    const cid = new CID(value).toV1()
    if (!isCryptographicIPNS(cid)) {
        // Value is not a libp2p-key, return original string
        console.warn('[ensdomains/content-hash] use of non-cryptographic identifiers in ipns-ns is deprecated and will be removed, migrate to ED25519 libp2p-key')
        return String(multiH.decode(new CID(value).multihash).digest)
        // TODO: start throwing an error (after some deprecation period)
        // throw Error('ipns-ns allows only valid cryptographic libp2p-key identifiers, try using ED25519 pubkey instead')
    }
    return cid.toString('base36')
  },
  /**
  * @param {Buffer} value 
  */
  utf8: (value) => {
    return value.toString('utf8');
  },
  base64: (value) => {
    // `true` option makes it URL safe (replaces / and + with - and _ )
    return base64.fromUint8Array(value, true)
  }
};

/**
* list of known encoding/decoding for a given codec,
* `encode` should be chosen among the `encodes` functions
* `decode` should be chosen among the `decodes` functions
*/
const profiles = {
  'skynet-ns': {
    encode: encodes.skynet,
    decode: decodes.base64,
  },
  'swarm-ns': {
    encode: encodes.swarm,
    decode: decodes.hexMultiHash,
  },
  'ipfs-ns': {
    encode: encodes.ipfs,
    decode: decodes.ipfs,
  },
  'ipns-ns': {
    encode: encodes.ipns,
    decode: decodes.ipns,
  },
  'arweave-ns': {
    encode: encodes.arweave,
    decode: decodes.base64,
  },
  'default': {
    encode: encodes.utf8,
    decode: decodes.utf8,
  },
};

exports.hexStringToBuffer = hexStringToBuffer;
exports.profiles = profiles;

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash",file:"node_modules\\@ensdomains\\content-hash\\src\\profiles.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@firebase\\app\\dist\\esm\\index.esm2017.js", {"@firebase/component":"D:\\code\\v\\metamask-extension\\node_modules\\@firebase\\component\\dist\\esm\\index.esm2017.js","@firebase/logger":"D:\\code\\v\\metamask-extension\\node_modules\\@firebase\\logger\\dist\\index.cjs.js","@firebase/util":"D:\\code\\v\\metamask-extension\\node_modules\\@firebase\\util\\dist\\index.esm2017.js","idb":"D:\\code\\v\\metamask-extension\\node_modules\\idb\\build\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@firebase%5Capp%5Cdist%5Cesm%5Cindex.esm2017.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "FirebaseError", {
  enumerable: true,
  get: function () {
    return _util.FirebaseError;
  }
});
exports._DEFAULT_ENTRY_NAME = exports.SDK_VERSION = void 0;
exports._addComponent = _addComponent;
exports._addOrOverwriteComponent = _addOrOverwriteComponent;
exports._apps = void 0;
exports._clearComponents = _clearComponents;
exports._components = void 0;
exports._getProvider = _getProvider;
exports._isFirebaseApp = _isFirebaseApp;
exports._isFirebaseServerApp = _isFirebaseServerApp;
exports._registerComponent = _registerComponent;
exports._removeServiceInstance = _removeServiceInstance;
exports._serverApps = void 0;
exports.deleteApp = deleteApp;
exports.getApp = getApp;
exports.getApps = getApps;
exports.initializeApp = initializeApp;
exports.initializeServerApp = initializeServerApp;
exports.onLog = onLog;
exports.registerVersion = registerVersion;
exports.setLogLevel = setLogLevel;
var _component = require("@firebase/component");
var _logger = require("@firebase/logger");
var _util = require("@firebase/util");
var _idb = require("idb");
/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class PlatformLoggerServiceImpl {
  constructor(container) {
    this.container = container;
  }
  // In initial implementation, this will be called by installations on
  // auth token refresh, and installations will send this string.
  getPlatformInfoString() {
    const providers = this.container.getProviders();
    // Loop through providers and get library/version pairs from any that are
    // version components.
    return providers.map(provider => {
      if (isVersionServiceProvider(provider)) {
        const service = provider.getImmediate();
        return `${service.library}/${service.version}`;
      } else {
        return null;
      }
    }).filter(logString => logString).join(' ');
  }
}
/**
 *
 * @param provider check if this provider provides a VersionService
 *
 * NOTE: Using Provider<'app-version'> is a hack to indicate that the provider
 * provides VersionService. The provider is not necessarily a 'app-version'
 * provider.
 */
function isVersionServiceProvider(provider) {
  const component = provider.getComponent();
  return (component === null || component === void 0 ? void 0 : component.type) === "VERSION" /* ComponentType.VERSION */;
}
const name$q = "@firebase/app";
const version$1 = "0.10.18";

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const logger = new _logger.Logger('@firebase/app');
const name$p = "@firebase/app-compat";
const name$o = "@firebase/analytics-compat";
const name$n = "@firebase/analytics";
const name$m = "@firebase/app-check-compat";
const name$l = "@firebase/app-check";
const name$k = "@firebase/auth";
const name$j = "@firebase/auth-compat";
const name$i = "@firebase/database";
const name$h = "@firebase/data-connect";
const name$g = "@firebase/database-compat";
const name$f = "@firebase/functions";
const name$e = "@firebase/functions-compat";
const name$d = "@firebase/installations";
const name$c = "@firebase/installations-compat";
const name$b = "@firebase/messaging";
const name$a = "@firebase/messaging-compat";
const name$9 = "@firebase/performance";
const name$8 = "@firebase/performance-compat";
const name$7 = "@firebase/remote-config";
const name$6 = "@firebase/remote-config-compat";
const name$5 = "@firebase/storage";
const name$4 = "@firebase/storage-compat";
const name$3 = "@firebase/firestore";
const name$2 = "@firebase/vertexai";
const name$1 = "@firebase/firestore-compat";
const name = "firebase";
const version = "11.2.0";

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * The default app name
 *
 * @internal
 */
const DEFAULT_ENTRY_NAME = exports._DEFAULT_ENTRY_NAME = '[DEFAULT]';
const PLATFORM_LOG_STRING = {
  [name$q]: 'fire-core',
  [name$p]: 'fire-core-compat',
  [name$n]: 'fire-analytics',
  [name$o]: 'fire-analytics-compat',
  [name$l]: 'fire-app-check',
  [name$m]: 'fire-app-check-compat',
  [name$k]: 'fire-auth',
  [name$j]: 'fire-auth-compat',
  [name$i]: 'fire-rtdb',
  [name$h]: 'fire-data-connect',
  [name$g]: 'fire-rtdb-compat',
  [name$f]: 'fire-fn',
  [name$e]: 'fire-fn-compat',
  [name$d]: 'fire-iid',
  [name$c]: 'fire-iid-compat',
  [name$b]: 'fire-fcm',
  [name$a]: 'fire-fcm-compat',
  [name$9]: 'fire-perf',
  [name$8]: 'fire-perf-compat',
  [name$7]: 'fire-rc',
  [name$6]: 'fire-rc-compat',
  [name$5]: 'fire-gcs',
  [name$4]: 'fire-gcs-compat',
  [name$3]: 'fire-fst',
  [name$1]: 'fire-fst-compat',
  [name$2]: 'fire-vertex',
  'fire-js': 'fire-js',
  // Platform identifier for JS SDK.
  [name]: 'fire-js-all'
};

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @internal
 */
const _apps = exports._apps = new Map();
/**
 * @internal
 */
const _serverApps = exports._serverApps = new Map();
/**
 * Registered components.
 *
 * @internal
 */
// eslint-disable-next-line @typescript-eslint/no-explicit-any
const _components = exports._components = new Map();
/**
 * @param component - the component being added to this app's container
 *
 * @internal
 */
function _addComponent(app, component) {
  try {
    app.container.addComponent(component);
  } catch (e) {
    logger.debug(`Component ${component.name} failed to register with FirebaseApp ${app.name}`, e);
  }
}
/**
 *
 * @internal
 */
function _addOrOverwriteComponent(app, component) {
  app.container.addOrOverwriteComponent(component);
}
/**
 *
 * @param component - the component to register
 * @returns whether or not the component is registered successfully
 *
 * @internal
 */
function _registerComponent(component) {
  const componentName = component.name;
  if (_components.has(componentName)) {
    logger.debug(`There were multiple attempts to register component ${componentName}.`);
    return false;
  }
  _components.set(componentName, component);
  // add the component to existing app instances
  for (const app of _apps.values()) {
    _addComponent(app, component);
  }
  for (const serverApp of _serverApps.values()) {
    _addComponent(serverApp, component);
  }
  return true;
}
/**
 *
 * @param app - FirebaseApp instance
 * @param name - service name
 *
 * @returns the provider for the service with the matching name
 *
 * @internal
 */
function _getProvider(app, name) {
  const heartbeatController = app.container.getProvider('heartbeat').getImmediate({
    optional: true
  });
  if (heartbeatController) {
    void heartbeatController.triggerHeartbeat();
  }
  return app.container.getProvider(name);
}
/**
 *
 * @param app - FirebaseApp instance
 * @param name - service name
 * @param instanceIdentifier - service instance identifier in case the service supports multiple instances
 *
 * @internal
 */
function _removeServiceInstance(app, name, instanceIdentifier = DEFAULT_ENTRY_NAME) {
  _getProvider(app, name).clearInstance(instanceIdentifier);
}
/**
 *
 * @param obj - an object of type FirebaseApp or FirebaseOptions.
 *
 * @returns true if the provide object is of type FirebaseApp.
 *
 * @internal
 */
function _isFirebaseApp(obj) {
  return obj.options !== undefined;
}
/**
 *
 * @param obj - an object of type FirebaseApp.
 *
 * @returns true if the provided object is of type FirebaseServerAppImpl.
 *
 * @internal
 */
function _isFirebaseServerApp(obj) {
  return obj.settings !== undefined;
}
/**
 * Test only
 *
 * @internal
 */
function _clearComponents() {
  _components.clear();
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const ERRORS = {
  ["no-app" /* AppError.NO_APP */]: "No Firebase App '{$appName}' has been created - " + 'call initializeApp() first',
  ["bad-app-name" /* AppError.BAD_APP_NAME */]: "Illegal App name: '{$appName}'",
  ["duplicate-app" /* AppError.DUPLICATE_APP */]: "Firebase App named '{$appName}' already exists with different options or config",
  ["app-deleted" /* AppError.APP_DELETED */]: "Firebase App named '{$appName}' already deleted",
  ["server-app-deleted" /* AppError.SERVER_APP_DELETED */]: 'Firebase Server App has been deleted',
  ["no-options" /* AppError.NO_OPTIONS */]: 'Need to provide options, when not being deployed to hosting via source.',
  ["invalid-app-argument" /* AppError.INVALID_APP_ARGUMENT */]: 'firebase.{$appName}() takes either no argument or a ' + 'Firebase App instance.',
  ["invalid-log-argument" /* AppError.INVALID_LOG_ARGUMENT */]: 'First argument to `onLog` must be null or a function.',
  ["idb-open" /* AppError.IDB_OPEN */]: 'Error thrown when opening IndexedDB. Original error: {$originalErrorMessage}.',
  ["idb-get" /* AppError.IDB_GET */]: 'Error thrown when reading from IndexedDB. Original error: {$originalErrorMessage}.',
  ["idb-set" /* AppError.IDB_WRITE */]: 'Error thrown when writing to IndexedDB. Original error: {$originalErrorMessage}.',
  ["idb-delete" /* AppError.IDB_DELETE */]: 'Error thrown when deleting from IndexedDB. Original error: {$originalErrorMessage}.',
  ["finalization-registry-not-supported" /* AppError.FINALIZATION_REGISTRY_NOT_SUPPORTED */]: 'FirebaseServerApp deleteOnDeref field defined but the JS runtime does not support FinalizationRegistry.',
  ["invalid-server-app-environment" /* AppError.INVALID_SERVER_APP_ENVIRONMENT */]: 'FirebaseServerApp is not for use in browser environments.'
};
const ERROR_FACTORY = new _util.ErrorFactory('app', 'Firebase', ERRORS);

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class FirebaseAppImpl {
  constructor(options, config, container) {
    this._isDeleted = false;
    this._options = Object.assign({}, options);
    this._config = Object.assign({}, config);
    this._name = config.name;
    this._automaticDataCollectionEnabled = config.automaticDataCollectionEnabled;
    this._container = container;
    this.container.addComponent(new _component.Component('app', () => this, "PUBLIC" /* ComponentType.PUBLIC */));
  }
  get automaticDataCollectionEnabled() {
    this.checkDestroyed();
    return this._automaticDataCollectionEnabled;
  }
  set automaticDataCollectionEnabled(val) {
    this.checkDestroyed();
    this._automaticDataCollectionEnabled = val;
  }
  get name() {
    this.checkDestroyed();
    return this._name;
  }
  get options() {
    this.checkDestroyed();
    return this._options;
  }
  get config() {
    this.checkDestroyed();
    return this._config;
  }
  get container() {
    return this._container;
  }
  get isDeleted() {
    return this._isDeleted;
  }
  set isDeleted(val) {
    this._isDeleted = val;
  }
  /**
   * This function will throw an Error if the App has already been deleted -
   * use before performing API actions on the App.
   */
  checkDestroyed() {
    if (this.isDeleted) {
      throw ERROR_FACTORY.create("app-deleted" /* AppError.APP_DELETED */, {
        appName: this._name
      });
    }
  }
}

/**
 * @license
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class FirebaseServerAppImpl extends FirebaseAppImpl {
  constructor(options, serverConfig, name, container) {
    // Build configuration parameters for the FirebaseAppImpl base class.
    const automaticDataCollectionEnabled = serverConfig.automaticDataCollectionEnabled !== undefined ? serverConfig.automaticDataCollectionEnabled : false;
    // Create the FirebaseAppSettings object for the FirebaseAppImp constructor.
    const config = {
      name,
      automaticDataCollectionEnabled
    };
    if (options.apiKey !== undefined) {
      // Construct the parent FirebaseAppImp object.
      super(options, config, container);
    } else {
      const appImpl = options;
      super(appImpl.options, config, container);
    }
    // Now construct the data for the FirebaseServerAppImpl.
    this._serverConfig = Object.assign({
      automaticDataCollectionEnabled
    }, serverConfig);
    this._finalizationRegistry = null;
    if (typeof FinalizationRegistry !== 'undefined') {
      this._finalizationRegistry = new FinalizationRegistry(() => {
        this.automaticCleanup();
      });
    }
    this._refCount = 0;
    this.incRefCount(this._serverConfig.releaseOnDeref);
    // Do not retain a hard reference to the dref object, otherwise the FinalizationRegistry
    // will never trigger.
    this._serverConfig.releaseOnDeref = undefined;
    serverConfig.releaseOnDeref = undefined;
    registerVersion(name$q, version$1, 'serverapp');
  }
  toJSON() {
    return undefined;
  }
  get refCount() {
    return this._refCount;
  }
  // Increment the reference count of this server app. If an object is provided, register it
  // with the finalization registry.
  incRefCount(obj) {
    if (this.isDeleted) {
      return;
    }
    this._refCount++;
    if (obj !== undefined && this._finalizationRegistry !== null) {
      this._finalizationRegistry.register(obj, this);
    }
  }
  // Decrement the reference count.
  decRefCount() {
    if (this.isDeleted) {
      return 0;
    }
    return --this._refCount;
  }
  // Invoked by the FinalizationRegistry callback to note that this app should go through its
  // reference counts and delete itself if no reference count remain. The coordinating logic that
  // handles this is in deleteApp(...).
  automaticCleanup() {
    void deleteApp(this);
  }
  get settings() {
    this.checkDestroyed();
    return this._serverConfig;
  }
  /**
   * This function will throw an Error if the App has already been deleted -
   * use before performing API actions on the App.
   */
  checkDestroyed() {
    if (this.isDeleted) {
      throw ERROR_FACTORY.create("server-app-deleted" /* AppError.SERVER_APP_DELETED */);
    }
  }
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * The current SDK version.
 *
 * @public
 */
const SDK_VERSION = exports.SDK_VERSION = version;
function initializeApp(_options, rawConfig = {}) {
  let options = _options;
  if (typeof rawConfig !== 'object') {
    const name = rawConfig;
    rawConfig = {
      name
    };
  }
  const config = Object.assign({
    name: DEFAULT_ENTRY_NAME,
    automaticDataCollectionEnabled: false
  }, rawConfig);
  const name = config.name;
  if (typeof name !== 'string' || !name) {
    throw ERROR_FACTORY.create("bad-app-name" /* AppError.BAD_APP_NAME */, {
      appName: String(name)
    });
  }
  options || (options = (0, _util.getDefaultAppConfig)());
  if (!options) {
    throw ERROR_FACTORY.create("no-options" /* AppError.NO_OPTIONS */);
  }
  const existingApp = _apps.get(name);
  if (existingApp) {
    // return the existing app if options and config deep equal the ones in the existing app.
    if ((0, _util.deepEqual)(options, existingApp.options) && (0, _util.deepEqual)(config, existingApp.config)) {
      return existingApp;
    } else {
      throw ERROR_FACTORY.create("duplicate-app" /* AppError.DUPLICATE_APP */, {
        appName: name
      });
    }
  }
  const container = new _component.ComponentContainer(name);
  for (const component of _components.values()) {
    container.addComponent(component);
  }
  const newApp = new FirebaseAppImpl(options, config, container);
  _apps.set(name, newApp);
  return newApp;
}
function initializeServerApp(_options, _serverAppConfig) {
  if ((0, _util.isBrowser)() && !(0, _util.isWebWorker)()) {
    // FirebaseServerApp isn't designed to be run in browsers.
    throw ERROR_FACTORY.create("invalid-server-app-environment" /* AppError.INVALID_SERVER_APP_ENVIRONMENT */);
  }
  if (_serverAppConfig.automaticDataCollectionEnabled === undefined) {
    _serverAppConfig.automaticDataCollectionEnabled = false;
  }
  let appOptions;
  if (_isFirebaseApp(_options)) {
    appOptions = _options.options;
  } else {
    appOptions = _options;
  }
  // Build an app name based on a hash of the configuration options.
  const nameObj = Object.assign(Object.assign({}, _serverAppConfig), appOptions);
  // However, Do not mangle the name based on releaseOnDeref, since it will vary between the
  // construction of FirebaseServerApp instances. For example, if the object is the request headers.
  if (nameObj.releaseOnDeref !== undefined) {
    delete nameObj.releaseOnDeref;
  }
  const hashCode = s => {
    return [...s].reduce((hash, c) => Math.imul(31, hash) + c.charCodeAt(0) | 0, 0);
  };
  if (_serverAppConfig.releaseOnDeref !== undefined) {
    if (typeof FinalizationRegistry === 'undefined') {
      throw ERROR_FACTORY.create("finalization-registry-not-supported" /* AppError.FINALIZATION_REGISTRY_NOT_SUPPORTED */, {});
    }
  }
  const nameString = '' + hashCode(JSON.stringify(nameObj));
  const existingApp = _serverApps.get(nameString);
  if (existingApp) {
    existingApp.incRefCount(_serverAppConfig.releaseOnDeref);
    return existingApp;
  }
  const container = new _component.ComponentContainer(nameString);
  for (const component of _components.values()) {
    container.addComponent(component);
  }
  const newApp = new FirebaseServerAppImpl(appOptions, _serverAppConfig, nameString, container);
  _serverApps.set(nameString, newApp);
  return newApp;
}
/**
 * Retrieves a {@link @firebase/app#FirebaseApp} instance.
 *
 * When called with no arguments, the default app is returned. When an app name
 * is provided, the app corresponding to that name is returned.
 *
 * An exception is thrown if the app being retrieved has not yet been
 * initialized.
 *
 * @example
 * ```javascript
 * // Return the default app
 * const app = getApp();
 * ```
 *
 * @example
 * ```javascript
 * // Return a named app
 * const otherApp = getApp("otherApp");
 * ```
 *
 * @param name - Optional name of the app to return. If no name is
 *   provided, the default is `"[DEFAULT]"`.
 *
 * @returns The app corresponding to the provided app name.
 *   If no app name is provided, the default app is returned.
 *
 * @public
 */
function getApp(name = DEFAULT_ENTRY_NAME) {
  const app = _apps.get(name);
  if (!app && name === DEFAULT_ENTRY_NAME && (0, _util.getDefaultAppConfig)()) {
    return initializeApp();
  }
  if (!app) {
    throw ERROR_FACTORY.create("no-app" /* AppError.NO_APP */, {
      appName: name
    });
  }
  return app;
}
/**
 * A (read-only) array of all initialized apps.
 * @public
 */
function getApps() {
  return Array.from(_apps.values());
}
/**
 * Renders this app unusable and frees the resources of all associated
 * services.
 *
 * @example
 * ```javascript
 * deleteApp(app)
 *   .then(function() {
 *     console.log("App deleted successfully");
 *   })
 *   .catch(function(error) {
 *     console.log("Error deleting app:", error);
 *   });
 * ```
 *
 * @public
 */
async function deleteApp(app) {
  let cleanupProviders = false;
  const name = app.name;
  if (_apps.has(name)) {
    cleanupProviders = true;
    _apps.delete(name);
  } else if (_serverApps.has(name)) {
    const firebaseServerApp = app;
    if (firebaseServerApp.decRefCount() <= 0) {
      _serverApps.delete(name);
      cleanupProviders = true;
    }
  }
  if (cleanupProviders) {
    await Promise.all(app.container.getProviders().map(provider => provider.delete()));
    app.isDeleted = true;
  }
}
/**
 * Registers a library's name and version for platform logging purposes.
 * @param library - Name of 1p or 3p library (e.g. firestore, angularfire)
 * @param version - Current version of that library.
 * @param variant - Bundle variant, e.g., node, rn, etc.
 *
 * @public
 */
function registerVersion(libraryKeyOrName, version, variant) {
  var _a;
  // TODO: We can use this check to whitelist strings when/if we set up
  // a good whitelist system.
  let library = (_a = PLATFORM_LOG_STRING[libraryKeyOrName]) !== null && _a !== void 0 ? _a : libraryKeyOrName;
  if (variant) {
    library += `-${variant}`;
  }
  const libraryMismatch = library.match(/\s|\//);
  const versionMismatch = version.match(/\s|\//);
  if (libraryMismatch || versionMismatch) {
    const warning = [`Unable to register library "${library}" with version "${version}":`];
    if (libraryMismatch) {
      warning.push(`library name "${library}" contains illegal characters (whitespace or "/")`);
    }
    if (libraryMismatch && versionMismatch) {
      warning.push('and');
    }
    if (versionMismatch) {
      warning.push(`version name "${version}" contains illegal characters (whitespace or "/")`);
    }
    logger.warn(warning.join(' '));
    return;
  }
  _registerComponent(new _component.Component(`${library}-version`, () => ({
    library,
    version
  }), "VERSION" /* ComponentType.VERSION */));
}
/**
 * Sets log handler for all Firebase SDKs.
 * @param logCallback - An optional custom log handler that executes user code whenever
 * the Firebase SDK makes a logging call.
 *
 * @public
 */
function onLog(logCallback, options) {
  if (logCallback !== null && typeof logCallback !== 'function') {
    throw ERROR_FACTORY.create("invalid-log-argument" /* AppError.INVALID_LOG_ARGUMENT */);
  }
  (0, _logger.setUserLogHandler)(logCallback, options);
}
/**
 * Sets log level for all Firebase SDKs.
 *
 * All of the log types above the current log level are captured (i.e. if
 * you set the log level to `info`, errors are logged, but `debug` and
 * `verbose` logs are not).
 *
 * @public
 */
function setLogLevel(logLevel) {
  (0, _logger.setLogLevel)(logLevel);
}

/**
 * @license
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const DB_NAME = 'firebase-heartbeat-database';
const DB_VERSION = 1;
const STORE_NAME = 'firebase-heartbeat-store';
let dbPromise = null;
function getDbPromise() {
  if (!dbPromise) {
    dbPromise = (0, _idb.openDB)(DB_NAME, DB_VERSION, {
      upgrade: (db, oldVersion) => {
        // We don't use 'break' in this switch statement, the fall-through
        // behavior is what we want, because if there are multiple versions between
        // the old version and the current version, we want ALL the migrations
        // that correspond to those versions to run, not only the last one.
        // eslint-disable-next-line default-case
        switch (oldVersion) {
          case 0:
            try {
              db.createObjectStore(STORE_NAME);
            } catch (e) {
              // Safari/iOS browsers throw occasional exceptions on
              // db.createObjectStore() that may be a bug. Avoid blocking
              // the rest of the app functionality.
              console.warn(e);
            }
        }
      }
    }).catch(e => {
      throw ERROR_FACTORY.create("idb-open" /* AppError.IDB_OPEN */, {
        originalErrorMessage: e.message
      });
    });
  }
  return dbPromise;
}
async function readHeartbeatsFromIndexedDB(app) {
  try {
    const db = await getDbPromise();
    const tx = db.transaction(STORE_NAME);
    const result = await tx.objectStore(STORE_NAME).get(computeKey(app));
    // We already have the value but tx.done can throw,
    // so we need to await it here to catch errors
    await tx.done;
    return result;
  } catch (e) {
    if (e instanceof _util.FirebaseError) {
      logger.warn(e.message);
    } else {
      const idbGetError = ERROR_FACTORY.create("idb-get" /* AppError.IDB_GET */, {
        originalErrorMessage: e === null || e === void 0 ? void 0 : e.message
      });
      logger.warn(idbGetError.message);
    }
  }
}
async function writeHeartbeatsToIndexedDB(app, heartbeatObject) {
  try {
    const db = await getDbPromise();
    const tx = db.transaction(STORE_NAME, 'readwrite');
    const objectStore = tx.objectStore(STORE_NAME);
    await objectStore.put(heartbeatObject, computeKey(app));
    await tx.done;
  } catch (e) {
    if (e instanceof _util.FirebaseError) {
      logger.warn(e.message);
    } else {
      const idbGetError = ERROR_FACTORY.create("idb-set" /* AppError.IDB_WRITE */, {
        originalErrorMessage: e === null || e === void 0 ? void 0 : e.message
      });
      logger.warn(idbGetError.message);
    }
  }
}
function computeKey(app) {
  return `${app.name}!${app.options.appId}`;
}

/**
 * @license
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const MAX_HEADER_BYTES = 1024;
// 30 days
const STORED_HEARTBEAT_RETENTION_MAX_MILLIS = 30 * 24 * 60 * 60 * 1000;
class HeartbeatServiceImpl {
  constructor(container) {
    this.container = container;
    /**
     * In-memory cache for heartbeats, used by getHeartbeatsHeader() to generate
     * the header string.
     * Stores one record per date. This will be consolidated into the standard
     * format of one record per user agent string before being sent as a header.
     * Populated from indexedDB when the controller is instantiated and should
     * be kept in sync with indexedDB.
     * Leave public for easier testing.
     */
    this._heartbeatsCache = null;
    const app = this.container.getProvider('app').getImmediate();
    this._storage = new HeartbeatStorageImpl(app);
    this._heartbeatsCachePromise = this._storage.read().then(result => {
      this._heartbeatsCache = result;
      return result;
    });
  }
  /**
   * Called to report a heartbeat. The function will generate
   * a HeartbeatsByUserAgent object, update heartbeatsCache, and persist it
   * to IndexedDB.
   * Note that we only store one heartbeat per day. So if a heartbeat for today is
   * already logged, subsequent calls to this function in the same day will be ignored.
   */
  async triggerHeartbeat() {
    var _a, _b;
    try {
      const platformLogger = this.container.getProvider('platform-logger').getImmediate();
      // This is the "Firebase user agent" string from the platform logger
      // service, not the browser user agent.
      const agent = platformLogger.getPlatformInfoString();
      const date = getUTCDateString();
      if (((_a = this._heartbeatsCache) === null || _a === void 0 ? void 0 : _a.heartbeats) == null) {
        this._heartbeatsCache = await this._heartbeatsCachePromise;
        // If we failed to construct a heartbeats cache, then return immediately.
        if (((_b = this._heartbeatsCache) === null || _b === void 0 ? void 0 : _b.heartbeats) == null) {
          return;
        }
      }
      // Do not store a heartbeat if one is already stored for this day
      // or if a header has already been sent today.
      if (this._heartbeatsCache.lastSentHeartbeatDate === date || this._heartbeatsCache.heartbeats.some(singleDateHeartbeat => singleDateHeartbeat.date === date)) {
        return;
      } else {
        // There is no entry for this date. Create one.
        this._heartbeatsCache.heartbeats.push({
          date,
          agent
        });
      }
      // Remove entries older than 30 days.
      this._heartbeatsCache.heartbeats = this._heartbeatsCache.heartbeats.filter(singleDateHeartbeat => {
        const hbTimestamp = new Date(singleDateHeartbeat.date).valueOf();
        const now = Date.now();
        return now - hbTimestamp <= STORED_HEARTBEAT_RETENTION_MAX_MILLIS;
      });
      return this._storage.overwrite(this._heartbeatsCache);
    } catch (e) {
      logger.warn(e);
    }
  }
  /**
   * Returns a base64 encoded string which can be attached to the heartbeat-specific header directly.
   * It also clears all heartbeats from memory as well as in IndexedDB.
   *
   * NOTE: Consuming product SDKs should not send the header if this method
   * returns an empty string.
   */
  async getHeartbeatsHeader() {
    var _a;
    try {
      if (this._heartbeatsCache === null) {
        await this._heartbeatsCachePromise;
      }
      // If it's still null or the array is empty, there is no data to send.
      if (((_a = this._heartbeatsCache) === null || _a === void 0 ? void 0 : _a.heartbeats) == null || this._heartbeatsCache.heartbeats.length === 0) {
        return '';
      }
      const date = getUTCDateString();
      // Extract as many heartbeats from the cache as will fit under the size limit.
      const {
        heartbeatsToSend,
        unsentEntries
      } = extractHeartbeatsForHeader(this._heartbeatsCache.heartbeats);
      const headerString = (0, _util.base64urlEncodeWithoutPadding)(JSON.stringify({
        version: 2,
        heartbeats: heartbeatsToSend
      }));
      // Store last sent date to prevent another being logged/sent for the same day.
      this._heartbeatsCache.lastSentHeartbeatDate = date;
      if (unsentEntries.length > 0) {
        // Store any unsent entries if they exist.
        this._heartbeatsCache.heartbeats = unsentEntries;
        // This seems more likely than emptying the array (below) to lead to some odd state
        // since the cache isn't empty and this will be called again on the next request,
        // and is probably safest if we await it.
        await this._storage.overwrite(this._heartbeatsCache);
      } else {
        this._heartbeatsCache.heartbeats = [];
        // Do not wait for this, to reduce latency.
        void this._storage.overwrite(this._heartbeatsCache);
      }
      return headerString;
    } catch (e) {
      logger.warn(e);
      return '';
    }
  }
}
function getUTCDateString() {
  const today = new Date();
  // Returns date format 'YYYY-MM-DD'
  return today.toISOString().substring(0, 10);
}
function extractHeartbeatsForHeader(heartbeatsCache, maxSize = MAX_HEADER_BYTES) {
  // Heartbeats grouped by user agent in the standard format to be sent in
  // the header.
  const heartbeatsToSend = [];
  // Single date format heartbeats that are not sent.
  let unsentEntries = heartbeatsCache.slice();
  for (const singleDateHeartbeat of heartbeatsCache) {
    // Look for an existing entry with the same user agent.
    const heartbeatEntry = heartbeatsToSend.find(hb => hb.agent === singleDateHeartbeat.agent);
    if (!heartbeatEntry) {
      // If no entry for this user agent exists, create one.
      heartbeatsToSend.push({
        agent: singleDateHeartbeat.agent,
        dates: [singleDateHeartbeat.date]
      });
      if (countBytes(heartbeatsToSend) > maxSize) {
        // If the header would exceed max size, remove the added heartbeat
        // entry and stop adding to the header.
        heartbeatsToSend.pop();
        break;
      }
    } else {
      heartbeatEntry.dates.push(singleDateHeartbeat.date);
      // If the header would exceed max size, remove the added date
      // and stop adding to the header.
      if (countBytes(heartbeatsToSend) > maxSize) {
        heartbeatEntry.dates.pop();
        break;
      }
    }
    // Pop unsent entry from queue. (Skipped if adding the entry exceeded
    // quota and the loop breaks early.)
    unsentEntries = unsentEntries.slice(1);
  }
  return {
    heartbeatsToSend,
    unsentEntries
  };
}
class HeartbeatStorageImpl {
  constructor(app) {
    this.app = app;
    this._canUseIndexedDBPromise = this.runIndexedDBEnvironmentCheck();
  }
  async runIndexedDBEnvironmentCheck() {
    if (!(0, _util.isIndexedDBAvailable)()) {
      return false;
    } else {
      return (0, _util.validateIndexedDBOpenable)().then(() => true).catch(() => false);
    }
  }
  /**
   * Read all heartbeats.
   */
  async read() {
    const canUseIndexedDB = await this._canUseIndexedDBPromise;
    if (!canUseIndexedDB) {
      return {
        heartbeats: []
      };
    } else {
      const idbHeartbeatObject = await readHeartbeatsFromIndexedDB(this.app);
      if (idbHeartbeatObject === null || idbHeartbeatObject === void 0 ? void 0 : idbHeartbeatObject.heartbeats) {
        return idbHeartbeatObject;
      } else {
        return {
          heartbeats: []
        };
      }
    }
  }
  // overwrite the storage with the provided heartbeats
  async overwrite(heartbeatsObject) {
    var _a;
    const canUseIndexedDB = await this._canUseIndexedDBPromise;
    if (!canUseIndexedDB) {
      return;
    } else {
      const existingHeartbeatsObject = await this.read();
      return writeHeartbeatsToIndexedDB(this.app, {
        lastSentHeartbeatDate: (_a = heartbeatsObject.lastSentHeartbeatDate) !== null && _a !== void 0 ? _a : existingHeartbeatsObject.lastSentHeartbeatDate,
        heartbeats: heartbeatsObject.heartbeats
      });
    }
  }
  // add heartbeats
  async add(heartbeatsObject) {
    var _a;
    const canUseIndexedDB = await this._canUseIndexedDBPromise;
    if (!canUseIndexedDB) {
      return;
    } else {
      const existingHeartbeatsObject = await this.read();
      return writeHeartbeatsToIndexedDB(this.app, {
        lastSentHeartbeatDate: (_a = heartbeatsObject.lastSentHeartbeatDate) !== null && _a !== void 0 ? _a : existingHeartbeatsObject.lastSentHeartbeatDate,
        heartbeats: [...existingHeartbeatsObject.heartbeats, ...heartbeatsObject.heartbeats]
      });
    }
  }
}
/**
 * Calculate bytes of a HeartbeatsByUserAgent array after being wrapped
 * in a platform logging header JSON object, stringified, and converted
 * to base 64.
 */
function countBytes(heartbeatsCache) {
  // base64 has a restricted set of characters, all of which should be 1 byte.
  return (0, _util.base64urlEncodeWithoutPadding)(
  // heartbeatsCache wrapper properties
  JSON.stringify({
    version: 2,
    heartbeats: heartbeatsCache
  })).length;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function registerCoreComponents(variant) {
  _registerComponent(new _component.Component('platform-logger', container => new PlatformLoggerServiceImpl(container), "PRIVATE" /* ComponentType.PRIVATE */));
  _registerComponent(new _component.Component('heartbeat', container => new HeartbeatServiceImpl(container), "PRIVATE" /* ComponentType.PRIVATE */));
  // Register `app` package.
  registerVersion(name$q, version$1, variant);
  // BUILD_TARGET will be replaced by values like esm2017, cjs2017, etc during the compilation
  registerVersion(name$q, version$1, 'esm2017');
  // Register platform SDK identifier (no version).
  registerVersion('fire-js', '');
}

/**
 * Firebase App
 *
 * @remarks This package coordinates the communication between the different Firebase components
 * @packageDocumentation
 */
registerCoreComponents('');

      };
    };
  }
  }
}, {package:"@metamask/notification-services-controller>firebase>@firebase/app",file:"node_modules\\@firebase\\app\\dist\\esm\\index.esm2017.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@firebase\\component\\dist\\esm\\index.esm2017.js", {"@firebase/util":"D:\\code\\v\\metamask-extension\\node_modules\\@firebase\\util\\dist\\index.esm2017.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@firebase%5Ccomponent%5Cdist%5Cesm%5Cindex.esm2017.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Provider = exports.ComponentContainer = exports.Component = void 0;
var _util = require("@firebase/util");
/**
 * Component for service name T, e.g. `auth`, `auth-internal`
 */
class Component {
  /**
   *
   * @param name The public service name, e.g. app, auth, firestore, database
   * @param instanceFactory Service factory responsible for creating the public interface
   * @param type whether the service provided by the component is public or private
   */
  constructor(name, instanceFactory, type) {
    this.name = name;
    this.instanceFactory = instanceFactory;
    this.type = type;
    this.multipleInstances = false;
    /**
     * Properties to be added to the service namespace
     */
    this.serviceProps = {};
    this.instantiationMode = "LAZY" /* InstantiationMode.LAZY */;
    this.onInstanceCreated = null;
  }
  setInstantiationMode(mode) {
    this.instantiationMode = mode;
    return this;
  }
  setMultipleInstances(multipleInstances) {
    this.multipleInstances = multipleInstances;
    return this;
  }
  setServiceProps(props) {
    this.serviceProps = props;
    return this;
  }
  setInstanceCreatedCallback(callback) {
    this.onInstanceCreated = callback;
    return this;
  }
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
exports.Component = Component;
const DEFAULT_ENTRY_NAME = '[DEFAULT]';

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Provider for instance for service name T, e.g. 'auth', 'auth-internal'
 * NameServiceMapping[T] is an alias for the type of the instance
 */
class Provider {
  constructor(name, container) {
    this.name = name;
    this.container = container;
    this.component = null;
    this.instances = new Map();
    this.instancesDeferred = new Map();
    this.instancesOptions = new Map();
    this.onInitCallbacks = new Map();
  }
  /**
   * @param identifier A provider can provide multiple instances of a service
   * if this.component.multipleInstances is true.
   */
  get(identifier) {
    // if multipleInstances is not supported, use the default name
    const normalizedIdentifier = this.normalizeInstanceIdentifier(identifier);
    if (!this.instancesDeferred.has(normalizedIdentifier)) {
      const deferred = new _util.Deferred();
      this.instancesDeferred.set(normalizedIdentifier, deferred);
      if (this.isInitialized(normalizedIdentifier) || this.shouldAutoInitialize()) {
        // initialize the service if it can be auto-initialized
        try {
          const instance = this.getOrInitializeService({
            instanceIdentifier: normalizedIdentifier
          });
          if (instance) {
            deferred.resolve(instance);
          }
        } catch (e) {
          // when the instance factory throws an exception during get(), it should not cause
          // a fatal error. We just return the unresolved promise in this case.
        }
      }
    }
    return this.instancesDeferred.get(normalizedIdentifier).promise;
  }
  getImmediate(options) {
    var _a;
    // if multipleInstances is not supported, use the default name
    const normalizedIdentifier = this.normalizeInstanceIdentifier(options === null || options === void 0 ? void 0 : options.identifier);
    const optional = (_a = options === null || options === void 0 ? void 0 : options.optional) !== null && _a !== void 0 ? _a : false;
    if (this.isInitialized(normalizedIdentifier) || this.shouldAutoInitialize()) {
      try {
        return this.getOrInitializeService({
          instanceIdentifier: normalizedIdentifier
        });
      } catch (e) {
        if (optional) {
          return null;
        } else {
          throw e;
        }
      }
    } else {
      // In case a component is not initialized and should/cannot be auto-initialized at the moment, return null if the optional flag is set, or throw
      if (optional) {
        return null;
      } else {
        throw Error(`Service ${this.name} is not available`);
      }
    }
  }
  getComponent() {
    return this.component;
  }
  setComponent(component) {
    if (component.name !== this.name) {
      throw Error(`Mismatching Component ${component.name} for Provider ${this.name}.`);
    }
    if (this.component) {
      throw Error(`Component for ${this.name} has already been provided`);
    }
    this.component = component;
    // return early without attempting to initialize the component if the component requires explicit initialization (calling `Provider.initialize()`)
    if (!this.shouldAutoInitialize()) {
      return;
    }
    // if the service is eager, initialize the default instance
    if (isComponentEager(component)) {
      try {
        this.getOrInitializeService({
          instanceIdentifier: DEFAULT_ENTRY_NAME
        });
      } catch (e) {
        // when the instance factory for an eager Component throws an exception during the eager
        // initialization, it should not cause a fatal error.
        // TODO: Investigate if we need to make it configurable, because some component may want to cause
        // a fatal error in this case?
      }
    }
    // Create service instances for the pending promises and resolve them
    // NOTE: if this.multipleInstances is false, only the default instance will be created
    // and all promises with resolve with it regardless of the identifier.
    for (const [instanceIdentifier, instanceDeferred] of this.instancesDeferred.entries()) {
      const normalizedIdentifier = this.normalizeInstanceIdentifier(instanceIdentifier);
      try {
        // `getOrInitializeService()` should always return a valid instance since a component is guaranteed. use ! to make typescript happy.
        const instance = this.getOrInitializeService({
          instanceIdentifier: normalizedIdentifier
        });
        instanceDeferred.resolve(instance);
      } catch (e) {
        // when the instance factory throws an exception, it should not cause
        // a fatal error. We just leave the promise unresolved.
      }
    }
  }
  clearInstance(identifier = DEFAULT_ENTRY_NAME) {
    this.instancesDeferred.delete(identifier);
    this.instancesOptions.delete(identifier);
    this.instances.delete(identifier);
  }
  // app.delete() will call this method on every provider to delete the services
  // TODO: should we mark the provider as deleted?
  async delete() {
    const services = Array.from(this.instances.values());
    await Promise.all([...services.filter(service => 'INTERNAL' in service) // legacy services
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    .map(service => service.INTERNAL.delete()), ...services.filter(service => '_delete' in service) // modularized services
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    .map(service => service._delete())]);
  }
  isComponentSet() {
    return this.component != null;
  }
  isInitialized(identifier = DEFAULT_ENTRY_NAME) {
    return this.instances.has(identifier);
  }
  getOptions(identifier = DEFAULT_ENTRY_NAME) {
    return this.instancesOptions.get(identifier) || {};
  }
  initialize(opts = {}) {
    const {
      options = {}
    } = opts;
    const normalizedIdentifier = this.normalizeInstanceIdentifier(opts.instanceIdentifier);
    if (this.isInitialized(normalizedIdentifier)) {
      throw Error(`${this.name}(${normalizedIdentifier}) has already been initialized`);
    }
    if (!this.isComponentSet()) {
      throw Error(`Component ${this.name} has not been registered yet`);
    }
    const instance = this.getOrInitializeService({
      instanceIdentifier: normalizedIdentifier,
      options
    });
    // resolve any pending promise waiting for the service instance
    for (const [instanceIdentifier, instanceDeferred] of this.instancesDeferred.entries()) {
      const normalizedDeferredIdentifier = this.normalizeInstanceIdentifier(instanceIdentifier);
      if (normalizedIdentifier === normalizedDeferredIdentifier) {
        instanceDeferred.resolve(instance);
      }
    }
    return instance;
  }
  /**
   *
   * @param callback - a function that will be invoked  after the provider has been initialized by calling provider.initialize().
   * The function is invoked SYNCHRONOUSLY, so it should not execute any longrunning tasks in order to not block the program.
   *
   * @param identifier An optional instance identifier
   * @returns a function to unregister the callback
   */
  onInit(callback, identifier) {
    var _a;
    const normalizedIdentifier = this.normalizeInstanceIdentifier(identifier);
    const existingCallbacks = (_a = this.onInitCallbacks.get(normalizedIdentifier)) !== null && _a !== void 0 ? _a : new Set();
    existingCallbacks.add(callback);
    this.onInitCallbacks.set(normalizedIdentifier, existingCallbacks);
    const existingInstance = this.instances.get(normalizedIdentifier);
    if (existingInstance) {
      callback(existingInstance, normalizedIdentifier);
    }
    return () => {
      existingCallbacks.delete(callback);
    };
  }
  /**
   * Invoke onInit callbacks synchronously
   * @param instance the service instance`
   */
  invokeOnInitCallbacks(instance, identifier) {
    const callbacks = this.onInitCallbacks.get(identifier);
    if (!callbacks) {
      return;
    }
    for (const callback of callbacks) {
      try {
        callback(instance, identifier);
      } catch (_a) {
        // ignore errors in the onInit callback
      }
    }
  }
  getOrInitializeService({
    instanceIdentifier,
    options = {}
  }) {
    let instance = this.instances.get(instanceIdentifier);
    if (!instance && this.component) {
      instance = this.component.instanceFactory(this.container, {
        instanceIdentifier: normalizeIdentifierForFactory(instanceIdentifier),
        options
      });
      this.instances.set(instanceIdentifier, instance);
      this.instancesOptions.set(instanceIdentifier, options);
      /**
       * Invoke onInit listeners.
       * Note this.component.onInstanceCreated is different, which is used by the component creator,
       * while onInit listeners are registered by consumers of the provider.
       */
      this.invokeOnInitCallbacks(instance, instanceIdentifier);
      /**
       * Order is important
       * onInstanceCreated() should be called after this.instances.set(instanceIdentifier, instance); which
       * makes `isInitialized()` return true.
       */
      if (this.component.onInstanceCreated) {
        try {
          this.component.onInstanceCreated(this.container, instanceIdentifier, instance);
        } catch (_a) {
          // ignore errors in the onInstanceCreatedCallback
        }
      }
    }
    return instance || null;
  }
  normalizeInstanceIdentifier(identifier = DEFAULT_ENTRY_NAME) {
    if (this.component) {
      return this.component.multipleInstances ? identifier : DEFAULT_ENTRY_NAME;
    } else {
      return identifier; // assume multiple instances are supported before the component is provided.
    }
  }
  shouldAutoInitialize() {
    return !!this.component && this.component.instantiationMode !== "EXPLICIT" /* InstantiationMode.EXPLICIT */;
  }
}
// undefined should be passed to the service factory for the default instance
exports.Provider = Provider;
function normalizeIdentifierForFactory(identifier) {
  return identifier === DEFAULT_ENTRY_NAME ? undefined : identifier;
}
function isComponentEager(component) {
  return component.instantiationMode === "EAGER" /* InstantiationMode.EAGER */;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * ComponentContainer that provides Providers for service name T, e.g. `auth`, `auth-internal`
 */
class ComponentContainer {
  constructor(name) {
    this.name = name;
    this.providers = new Map();
  }
  /**
   *
   * @param component Component being added
   * @param overwrite When a component with the same name has already been registered,
   * if overwrite is true: overwrite the existing component with the new component and create a new
   * provider with the new component. It can be useful in tests where you want to use different mocks
   * for different tests.
   * if overwrite is false: throw an exception
   */
  addComponent(component) {
    const provider = this.getProvider(component.name);
    if (provider.isComponentSet()) {
      throw new Error(`Component ${component.name} has already been registered with ${this.name}`);
    }
    provider.setComponent(component);
  }
  addOrOverwriteComponent(component) {
    const provider = this.getProvider(component.name);
    if (provider.isComponentSet()) {
      // delete the existing provider from the container, so we can register the new component
      this.providers.delete(component.name);
    }
    this.addComponent(component);
  }
  /**
   * getProvider provides a type safe interface where it can only be called with a field name
   * present in NameServiceMapping interface.
   *
   * Firebase SDKs providing services should extend NameServiceMapping interface to register
   * themselves.
   */
  getProvider(name) {
    if (this.providers.has(name)) {
      return this.providers.get(name);
    }
    // create a Provider for a service that hasn't registered with Firebase
    const provider = new Provider(name, this);
    this.providers.set(name, provider);
    return provider;
  }
  getProviders() {
    return Array.from(this.providers.values());
  }
}
exports.ComponentContainer = ComponentContainer;

      };
    };
  }
  }
}, {package:"@metamask/notification-services-controller>firebase>@firebase/app>@firebase/component",file:"node_modules\\@firebase\\component\\dist\\esm\\index.esm2017.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@firebase\\installations\\dist\\esm\\index.esm2017.js", {"@firebase/app":"D:\\code\\v\\metamask-extension\\node_modules\\@firebase\\app\\dist\\esm\\index.esm2017.js","@firebase/component":"D:\\code\\v\\metamask-extension\\node_modules\\@firebase\\component\\dist\\esm\\index.esm2017.js","@firebase/util":"D:\\code\\v\\metamask-extension\\node_modules\\@firebase\\util\\dist\\index.esm2017.js","idb":"D:\\code\\v\\metamask-extension\\node_modules\\idb\\build\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@firebase%5Cinstallations%5Cdist%5Cesm%5Cindex.esm2017.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteInstallations = deleteInstallations;
exports.getId = getId;
exports.getInstallations = getInstallations;
exports.getToken = getToken;
exports.onIdChange = onIdChange;
var _app = require("@firebase/app");
var _component = require("@firebase/component");
var _util = require("@firebase/util");
var _idb = require("idb");
const name = "@firebase/installations";
const version = "0.6.12";

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const PENDING_TIMEOUT_MS = 10000;
const PACKAGE_VERSION = `w:${version}`;
const INTERNAL_AUTH_VERSION = 'FIS_v2';
const INSTALLATIONS_API_URL = 'https://firebaseinstallations.googleapis.com/v1';
const TOKEN_EXPIRATION_BUFFER = 60 * 60 * 1000; // One hour
const SERVICE = 'installations';
const SERVICE_NAME = 'Installations';

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const ERROR_DESCRIPTION_MAP = {
  ["missing-app-config-values" /* ErrorCode.MISSING_APP_CONFIG_VALUES */]: 'Missing App configuration value: "{$valueName}"',
  ["not-registered" /* ErrorCode.NOT_REGISTERED */]: 'Firebase Installation is not registered.',
  ["installation-not-found" /* ErrorCode.INSTALLATION_NOT_FOUND */]: 'Firebase Installation not found.',
  ["request-failed" /* ErrorCode.REQUEST_FAILED */]: '{$requestName} request failed with error "{$serverCode} {$serverStatus}: {$serverMessage}"',
  ["app-offline" /* ErrorCode.APP_OFFLINE */]: 'Could not process request. Application offline.',
  ["delete-pending-registration" /* ErrorCode.DELETE_PENDING_REGISTRATION */]: "Can't delete installation while there is a pending registration request."
};
const ERROR_FACTORY = new _util.ErrorFactory(SERVICE, SERVICE_NAME, ERROR_DESCRIPTION_MAP);
/** Returns true if error is a FirebaseError that is based on an error from the server. */
function isServerError(error) {
  return error instanceof _util.FirebaseError && error.code.includes("request-failed" /* ErrorCode.REQUEST_FAILED */);
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function getInstallationsEndpoint({
  projectId
}) {
  return `${INSTALLATIONS_API_URL}/projects/${projectId}/installations`;
}
function extractAuthTokenInfoFromResponse(response) {
  return {
    token: response.token,
    requestStatus: 2 /* RequestStatus.COMPLETED */,
    expiresIn: getExpiresInFromResponseExpiresIn(response.expiresIn),
    creationTime: Date.now()
  };
}
async function getErrorFromResponse(requestName, response) {
  const responseJson = await response.json();
  const errorData = responseJson.error;
  return ERROR_FACTORY.create("request-failed" /* ErrorCode.REQUEST_FAILED */, {
    requestName,
    serverCode: errorData.code,
    serverMessage: errorData.message,
    serverStatus: errorData.status
  });
}
function getHeaders({
  apiKey
}) {
  return new Headers({
    'Content-Type': 'application/json',
    Accept: 'application/json',
    'x-goog-api-key': apiKey
  });
}
function getHeadersWithAuth(appConfig, {
  refreshToken
}) {
  const headers = getHeaders(appConfig);
  headers.append('Authorization', getAuthorizationHeader(refreshToken));
  return headers;
}
/**
 * Calls the passed in fetch wrapper and returns the response.
 * If the returned response has a status of 5xx, re-runs the function once and
 * returns the response.
 */
async function retryIfServerError(fn) {
  const result = await fn();
  if (result.status >= 500 && result.status < 600) {
    // Internal Server Error. Retry request.
    return fn();
  }
  return result;
}
function getExpiresInFromResponseExpiresIn(responseExpiresIn) {
  // This works because the server will never respond with fractions of a second.
  return Number(responseExpiresIn.replace('s', '000'));
}
function getAuthorizationHeader(refreshToken) {
  return `${INTERNAL_AUTH_VERSION} ${refreshToken}`;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
async function createInstallationRequest({
  appConfig,
  heartbeatServiceProvider
}, {
  fid
}) {
  const endpoint = getInstallationsEndpoint(appConfig);
  const headers = getHeaders(appConfig);
  // If heartbeat service exists, add the heartbeat string to the header.
  const heartbeatService = heartbeatServiceProvider.getImmediate({
    optional: true
  });
  if (heartbeatService) {
    const heartbeatsHeader = await heartbeatService.getHeartbeatsHeader();
    if (heartbeatsHeader) {
      headers.append('x-firebase-client', heartbeatsHeader);
    }
  }
  const body = {
    fid,
    authVersion: INTERNAL_AUTH_VERSION,
    appId: appConfig.appId,
    sdkVersion: PACKAGE_VERSION
  };
  const request = {
    method: 'POST',
    headers,
    body: JSON.stringify(body)
  };
  const response = await retryIfServerError(() => fetch(endpoint, request));
  if (response.ok) {
    const responseValue = await response.json();
    const registeredInstallationEntry = {
      fid: responseValue.fid || fid,
      registrationStatus: 2 /* RequestStatus.COMPLETED */,
      refreshToken: responseValue.refreshToken,
      authToken: extractAuthTokenInfoFromResponse(responseValue.authToken)
    };
    return registeredInstallationEntry;
  } else {
    throw await getErrorFromResponse('Create Installation', response);
  }
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Returns a promise that resolves after given time passes. */
function sleep(ms) {
  return new Promise(resolve => {
    setTimeout(resolve, ms);
  });
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function bufferToBase64UrlSafe(array) {
  const b64 = btoa(String.fromCharCode(...array));
  return b64.replace(/\+/g, '-').replace(/\//g, '_');
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const VALID_FID_PATTERN = /^[cdef][\w-]{21}$/;
const INVALID_FID = '';
/**
 * Generates a new FID using random values from Web Crypto API.
 * Returns an empty string if FID generation fails for any reason.
 */
function generateFid() {
  try {
    // A valid FID has exactly 22 base64 characters, which is 132 bits, or 16.5
    // bytes. our implementation generates a 17 byte array instead.
    const fidByteArray = new Uint8Array(17);
    const crypto = self.crypto || self.msCrypto;
    crypto.getRandomValues(fidByteArray);
    // Replace the first 4 random bits with the constant FID header of 0b0111.
    fidByteArray[0] = 0b01110000 + fidByteArray[0] % 0b00010000;
    const fid = encode(fidByteArray);
    return VALID_FID_PATTERN.test(fid) ? fid : INVALID_FID;
  } catch (_a) {
    // FID generation errored
    return INVALID_FID;
  }
}
/** Converts a FID Uint8Array to a base64 string representation. */
function encode(fidByteArray) {
  const b64String = bufferToBase64UrlSafe(fidByteArray);
  // Remove the 23rd character that was added because of the extra 4 bits at the
  // end of our 17 byte array, and the '=' padding.
  return b64String.substr(0, 22);
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Returns a string key that can be used to identify the app. */
function getKey(appConfig) {
  return `${appConfig.appName}!${appConfig.appId}`;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const fidChangeCallbacks = new Map();
/**
 * Calls the onIdChange callbacks with the new FID value, and broadcasts the
 * change to other tabs.
 */
function fidChanged(appConfig, fid) {
  const key = getKey(appConfig);
  callFidChangeCallbacks(key, fid);
  broadcastFidChange(key, fid);
}
function addCallback(appConfig, callback) {
  // Open the broadcast channel if it's not already open,
  // to be able to listen to change events from other tabs.
  getBroadcastChannel();
  const key = getKey(appConfig);
  let callbackSet = fidChangeCallbacks.get(key);
  if (!callbackSet) {
    callbackSet = new Set();
    fidChangeCallbacks.set(key, callbackSet);
  }
  callbackSet.add(callback);
}
function removeCallback(appConfig, callback) {
  const key = getKey(appConfig);
  const callbackSet = fidChangeCallbacks.get(key);
  if (!callbackSet) {
    return;
  }
  callbackSet.delete(callback);
  if (callbackSet.size === 0) {
    fidChangeCallbacks.delete(key);
  }
  // Close broadcast channel if there are no more callbacks.
  closeBroadcastChannel();
}
function callFidChangeCallbacks(key, fid) {
  const callbacks = fidChangeCallbacks.get(key);
  if (!callbacks) {
    return;
  }
  for (const callback of callbacks) {
    callback(fid);
  }
}
function broadcastFidChange(key, fid) {
  const channel = getBroadcastChannel();
  if (channel) {
    channel.postMessage({
      key,
      fid
    });
  }
  closeBroadcastChannel();
}
let broadcastChannel = null;
/** Opens and returns a BroadcastChannel if it is supported by the browser. */
function getBroadcastChannel() {
  if (!broadcastChannel && 'BroadcastChannel' in self) {
    broadcastChannel = new BroadcastChannel('[Firebase] FID Change');
    broadcastChannel.onmessage = e => {
      callFidChangeCallbacks(e.data.key, e.data.fid);
    };
  }
  return broadcastChannel;
}
function closeBroadcastChannel() {
  if (fidChangeCallbacks.size === 0 && broadcastChannel) {
    broadcastChannel.close();
    broadcastChannel = null;
  }
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const DATABASE_NAME = 'firebase-installations-database';
const DATABASE_VERSION = 1;
const OBJECT_STORE_NAME = 'firebase-installations-store';
let dbPromise = null;
function getDbPromise() {
  if (!dbPromise) {
    dbPromise = (0, _idb.openDB)(DATABASE_NAME, DATABASE_VERSION, {
      upgrade: (db, oldVersion) => {
        // We don't use 'break' in this switch statement, the fall-through
        // behavior is what we want, because if there are multiple versions between
        // the old version and the current version, we want ALL the migrations
        // that correspond to those versions to run, not only the last one.
        // eslint-disable-next-line default-case
        switch (oldVersion) {
          case 0:
            db.createObjectStore(OBJECT_STORE_NAME);
        }
      }
    });
  }
  return dbPromise;
}
/** Assigns or overwrites the record for the given key with the given value. */
async function set(appConfig, value) {
  const key = getKey(appConfig);
  const db = await getDbPromise();
  const tx = db.transaction(OBJECT_STORE_NAME, 'readwrite');
  const objectStore = tx.objectStore(OBJECT_STORE_NAME);
  const oldValue = await objectStore.get(key);
  await objectStore.put(value, key);
  await tx.done;
  if (!oldValue || oldValue.fid !== value.fid) {
    fidChanged(appConfig, value.fid);
  }
  return value;
}
/** Removes record(s) from the objectStore that match the given key. */
async function remove(appConfig) {
  const key = getKey(appConfig);
  const db = await getDbPromise();
  const tx = db.transaction(OBJECT_STORE_NAME, 'readwrite');
  await tx.objectStore(OBJECT_STORE_NAME).delete(key);
  await tx.done;
}
/**
 * Atomically updates a record with the result of updateFn, which gets
 * called with the current value. If newValue is undefined, the record is
 * deleted instead.
 * @return Updated value
 */
async function update(appConfig, updateFn) {
  const key = getKey(appConfig);
  const db = await getDbPromise();
  const tx = db.transaction(OBJECT_STORE_NAME, 'readwrite');
  const store = tx.objectStore(OBJECT_STORE_NAME);
  const oldValue = await store.get(key);
  const newValue = updateFn(oldValue);
  if (newValue === undefined) {
    await store.delete(key);
  } else {
    await store.put(newValue, key);
  }
  await tx.done;
  if (newValue && (!oldValue || oldValue.fid !== newValue.fid)) {
    fidChanged(appConfig, newValue.fid);
  }
  return newValue;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Updates and returns the InstallationEntry from the database.
 * Also triggers a registration request if it is necessary and possible.
 */
async function getInstallationEntry(installations) {
  let registrationPromise;
  const installationEntry = await update(installations.appConfig, oldEntry => {
    const installationEntry = updateOrCreateInstallationEntry(oldEntry);
    const entryWithPromise = triggerRegistrationIfNecessary(installations, installationEntry);
    registrationPromise = entryWithPromise.registrationPromise;
    return entryWithPromise.installationEntry;
  });
  if (installationEntry.fid === INVALID_FID) {
    // FID generation failed. Waiting for the FID from the server.
    return {
      installationEntry: await registrationPromise
    };
  }
  return {
    installationEntry,
    registrationPromise
  };
}
/**
 * Creates a new Installation Entry if one does not exist.
 * Also clears timed out pending requests.
 */
function updateOrCreateInstallationEntry(oldEntry) {
  const entry = oldEntry || {
    fid: generateFid(),
    registrationStatus: 0 /* RequestStatus.NOT_STARTED */
  };
  return clearTimedOutRequest(entry);
}
/**
 * If the Firebase Installation is not registered yet, this will trigger the
 * registration and return an InProgressInstallationEntry.
 *
 * If registrationPromise does not exist, the installationEntry is guaranteed
 * to be registered.
 */
function triggerRegistrationIfNecessary(installations, installationEntry) {
  if (installationEntry.registrationStatus === 0 /* RequestStatus.NOT_STARTED */) {
    if (!navigator.onLine) {
      // Registration required but app is offline.
      const registrationPromiseWithError = Promise.reject(ERROR_FACTORY.create("app-offline" /* ErrorCode.APP_OFFLINE */));
      return {
        installationEntry,
        registrationPromise: registrationPromiseWithError
      };
    }
    // Try registering. Change status to IN_PROGRESS.
    const inProgressEntry = {
      fid: installationEntry.fid,
      registrationStatus: 1 /* RequestStatus.IN_PROGRESS */,
      registrationTime: Date.now()
    };
    const registrationPromise = registerInstallation(installations, inProgressEntry);
    return {
      installationEntry: inProgressEntry,
      registrationPromise
    };
  } else if (installationEntry.registrationStatus === 1 /* RequestStatus.IN_PROGRESS */) {
    return {
      installationEntry,
      registrationPromise: waitUntilFidRegistration(installations)
    };
  } else {
    return {
      installationEntry
    };
  }
}
/** This will be executed only once for each new Firebase Installation. */
async function registerInstallation(installations, installationEntry) {
  try {
    const registeredInstallationEntry = await createInstallationRequest(installations, installationEntry);
    return set(installations.appConfig, registeredInstallationEntry);
  } catch (e) {
    if (isServerError(e) && e.customData.serverCode === 409) {
      // Server returned a "FID cannot be used" error.
      // Generate a new ID next time.
      await remove(installations.appConfig);
    } else {
      // Registration failed. Set FID as not registered.
      await set(installations.appConfig, {
        fid: installationEntry.fid,
        registrationStatus: 0 /* RequestStatus.NOT_STARTED */
      });
    }
    throw e;
  }
}
/** Call if FID registration is pending in another request. */
async function waitUntilFidRegistration(installations) {
  // Unfortunately, there is no way of reliably observing when a value in
  // IndexedDB changes (yet, see https://github.com/WICG/indexed-db-observers),
  // so we need to poll.
  let entry = await updateInstallationRequest(installations.appConfig);
  while (entry.registrationStatus === 1 /* RequestStatus.IN_PROGRESS */) {
    // createInstallation request still in progress.
    await sleep(100);
    entry = await updateInstallationRequest(installations.appConfig);
  }
  if (entry.registrationStatus === 0 /* RequestStatus.NOT_STARTED */) {
    // The request timed out or failed in a different call. Try again.
    const {
      installationEntry,
      registrationPromise
    } = await getInstallationEntry(installations);
    if (registrationPromise) {
      return registrationPromise;
    } else {
      // if there is no registrationPromise, entry is registered.
      return installationEntry;
    }
  }
  return entry;
}
/**
 * Called only if there is a CreateInstallation request in progress.
 *
 * Updates the InstallationEntry in the DB based on the status of the
 * CreateInstallation request.
 *
 * Returns the updated InstallationEntry.
 */
function updateInstallationRequest(appConfig) {
  return update(appConfig, oldEntry => {
    if (!oldEntry) {
      throw ERROR_FACTORY.create("installation-not-found" /* ErrorCode.INSTALLATION_NOT_FOUND */);
    }
    return clearTimedOutRequest(oldEntry);
  });
}
function clearTimedOutRequest(entry) {
  if (hasInstallationRequestTimedOut(entry)) {
    return {
      fid: entry.fid,
      registrationStatus: 0 /* RequestStatus.NOT_STARTED */
    };
  }
  return entry;
}
function hasInstallationRequestTimedOut(installationEntry) {
  return installationEntry.registrationStatus === 1 /* RequestStatus.IN_PROGRESS */ && installationEntry.registrationTime + PENDING_TIMEOUT_MS < Date.now();
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
async function generateAuthTokenRequest({
  appConfig,
  heartbeatServiceProvider
}, installationEntry) {
  const endpoint = getGenerateAuthTokenEndpoint(appConfig, installationEntry);
  const headers = getHeadersWithAuth(appConfig, installationEntry);
  // If heartbeat service exists, add the heartbeat string to the header.
  const heartbeatService = heartbeatServiceProvider.getImmediate({
    optional: true
  });
  if (heartbeatService) {
    const heartbeatsHeader = await heartbeatService.getHeartbeatsHeader();
    if (heartbeatsHeader) {
      headers.append('x-firebase-client', heartbeatsHeader);
    }
  }
  const body = {
    installation: {
      sdkVersion: PACKAGE_VERSION,
      appId: appConfig.appId
    }
  };
  const request = {
    method: 'POST',
    headers,
    body: JSON.stringify(body)
  };
  const response = await retryIfServerError(() => fetch(endpoint, request));
  if (response.ok) {
    const responseValue = await response.json();
    const completedAuthToken = extractAuthTokenInfoFromResponse(responseValue);
    return completedAuthToken;
  } else {
    throw await getErrorFromResponse('Generate Auth Token', response);
  }
}
function getGenerateAuthTokenEndpoint(appConfig, {
  fid
}) {
  return `${getInstallationsEndpoint(appConfig)}/${fid}/authTokens:generate`;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Returns a valid authentication token for the installation. Generates a new
 * token if one doesn't exist, is expired or about to expire.
 *
 * Should only be called if the Firebase Installation is registered.
 */
async function refreshAuthToken(installations, forceRefresh = false) {
  let tokenPromise;
  const entry = await update(installations.appConfig, oldEntry => {
    if (!isEntryRegistered(oldEntry)) {
      throw ERROR_FACTORY.create("not-registered" /* ErrorCode.NOT_REGISTERED */);
    }
    const oldAuthToken = oldEntry.authToken;
    if (!forceRefresh && isAuthTokenValid(oldAuthToken)) {
      // There is a valid token in the DB.
      return oldEntry;
    } else if (oldAuthToken.requestStatus === 1 /* RequestStatus.IN_PROGRESS */) {
      // There already is a token request in progress.
      tokenPromise = waitUntilAuthTokenRequest(installations, forceRefresh);
      return oldEntry;
    } else {
      // No token or token expired.
      if (!navigator.onLine) {
        throw ERROR_FACTORY.create("app-offline" /* ErrorCode.APP_OFFLINE */);
      }
      const inProgressEntry = makeAuthTokenRequestInProgressEntry(oldEntry);
      tokenPromise = fetchAuthTokenFromServer(installations, inProgressEntry);
      return inProgressEntry;
    }
  });
  const authToken = tokenPromise ? await tokenPromise : entry.authToken;
  return authToken;
}
/**
 * Call only if FID is registered and Auth Token request is in progress.
 *
 * Waits until the current pending request finishes. If the request times out,
 * tries once in this thread as well.
 */
async function waitUntilAuthTokenRequest(installations, forceRefresh) {
  // Unfortunately, there is no way of reliably observing when a value in
  // IndexedDB changes (yet, see https://github.com/WICG/indexed-db-observers),
  // so we need to poll.
  let entry = await updateAuthTokenRequest(installations.appConfig);
  while (entry.authToken.requestStatus === 1 /* RequestStatus.IN_PROGRESS */) {
    // generateAuthToken still in progress.
    await sleep(100);
    entry = await updateAuthTokenRequest(installations.appConfig);
  }
  const authToken = entry.authToken;
  if (authToken.requestStatus === 0 /* RequestStatus.NOT_STARTED */) {
    // The request timed out or failed in a different call. Try again.
    return refreshAuthToken(installations, forceRefresh);
  } else {
    return authToken;
  }
}
/**
 * Called only if there is a GenerateAuthToken request in progress.
 *
 * Updates the InstallationEntry in the DB based on the status of the
 * GenerateAuthToken request.
 *
 * Returns the updated InstallationEntry.
 */
function updateAuthTokenRequest(appConfig) {
  return update(appConfig, oldEntry => {
    if (!isEntryRegistered(oldEntry)) {
      throw ERROR_FACTORY.create("not-registered" /* ErrorCode.NOT_REGISTERED */);
    }
    const oldAuthToken = oldEntry.authToken;
    if (hasAuthTokenRequestTimedOut(oldAuthToken)) {
      return Object.assign(Object.assign({}, oldEntry), {
        authToken: {
          requestStatus: 0 /* RequestStatus.NOT_STARTED */
        }
      });
    }
    return oldEntry;
  });
}
async function fetchAuthTokenFromServer(installations, installationEntry) {
  try {
    const authToken = await generateAuthTokenRequest(installations, installationEntry);
    const updatedInstallationEntry = Object.assign(Object.assign({}, installationEntry), {
      authToken
    });
    await set(installations.appConfig, updatedInstallationEntry);
    return authToken;
  } catch (e) {
    if (isServerError(e) && (e.customData.serverCode === 401 || e.customData.serverCode === 404)) {
      // Server returned a "FID not found" or a "Invalid authentication" error.
      // Generate a new ID next time.
      await remove(installations.appConfig);
    } else {
      const updatedInstallationEntry = Object.assign(Object.assign({}, installationEntry), {
        authToken: {
          requestStatus: 0 /* RequestStatus.NOT_STARTED */
        }
      });
      await set(installations.appConfig, updatedInstallationEntry);
    }
    throw e;
  }
}
function isEntryRegistered(installationEntry) {
  return installationEntry !== undefined && installationEntry.registrationStatus === 2 /* RequestStatus.COMPLETED */;
}
function isAuthTokenValid(authToken) {
  return authToken.requestStatus === 2 /* RequestStatus.COMPLETED */ && !isAuthTokenExpired(authToken);
}
function isAuthTokenExpired(authToken) {
  const now = Date.now();
  return now < authToken.creationTime || authToken.creationTime + authToken.expiresIn < now + TOKEN_EXPIRATION_BUFFER;
}
/** Returns an updated InstallationEntry with an InProgressAuthToken. */
function makeAuthTokenRequestInProgressEntry(oldEntry) {
  const inProgressAuthToken = {
    requestStatus: 1 /* RequestStatus.IN_PROGRESS */,
    requestTime: Date.now()
  };
  return Object.assign(Object.assign({}, oldEntry), {
    authToken: inProgressAuthToken
  });
}
function hasAuthTokenRequestTimedOut(authToken) {
  return authToken.requestStatus === 1 /* RequestStatus.IN_PROGRESS */ && authToken.requestTime + PENDING_TIMEOUT_MS < Date.now();
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Creates a Firebase Installation if there isn't one for the app and
 * returns the Installation ID.
 * @param installations - The `Installations` instance.
 *
 * @public
 */
async function getId(installations) {
  const installationsImpl = installations;
  const {
    installationEntry,
    registrationPromise
  } = await getInstallationEntry(installationsImpl);
  if (registrationPromise) {
    registrationPromise.catch(console.error);
  } else {
    // If the installation is already registered, update the authentication
    // token if needed.
    refreshAuthToken(installationsImpl).catch(console.error);
  }
  return installationEntry.fid;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Returns a Firebase Installations auth token, identifying the current
 * Firebase Installation.
 * @param installations - The `Installations` instance.
 * @param forceRefresh - Force refresh regardless of token expiration.
 *
 * @public
 */
async function getToken(installations, forceRefresh = false) {
  const installationsImpl = installations;
  await completeInstallationRegistration(installationsImpl);
  // At this point we either have a Registered Installation in the DB, or we've
  // already thrown an error.
  const authToken = await refreshAuthToken(installationsImpl, forceRefresh);
  return authToken.token;
}
async function completeInstallationRegistration(installations) {
  const {
    registrationPromise
  } = await getInstallationEntry(installations);
  if (registrationPromise) {
    // A createInstallation request is in progress. Wait until it finishes.
    await registrationPromise;
  }
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
async function deleteInstallationRequest(appConfig, installationEntry) {
  const endpoint = getDeleteEndpoint(appConfig, installationEntry);
  const headers = getHeadersWithAuth(appConfig, installationEntry);
  const request = {
    method: 'DELETE',
    headers
  };
  const response = await retryIfServerError(() => fetch(endpoint, request));
  if (!response.ok) {
    throw await getErrorFromResponse('Delete Installation', response);
  }
}
function getDeleteEndpoint(appConfig, {
  fid
}) {
  return `${getInstallationsEndpoint(appConfig)}/${fid}`;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Deletes the Firebase Installation and all associated data.
 * @param installations - The `Installations` instance.
 *
 * @public
 */
async function deleteInstallations(installations) {
  const {
    appConfig
  } = installations;
  const entry = await update(appConfig, oldEntry => {
    if (oldEntry && oldEntry.registrationStatus === 0 /* RequestStatus.NOT_STARTED */) {
      // Delete the unregistered entry without sending a deleteInstallation request.
      return undefined;
    }
    return oldEntry;
  });
  if (entry) {
    if (entry.registrationStatus === 1 /* RequestStatus.IN_PROGRESS */) {
      // Can't delete while trying to register.
      throw ERROR_FACTORY.create("delete-pending-registration" /* ErrorCode.DELETE_PENDING_REGISTRATION */);
    } else if (entry.registrationStatus === 2 /* RequestStatus.COMPLETED */) {
      if (!navigator.onLine) {
        throw ERROR_FACTORY.create("app-offline" /* ErrorCode.APP_OFFLINE */);
      } else {
        await deleteInstallationRequest(appConfig, entry);
        await remove(appConfig);
      }
    }
  }
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Sets a new callback that will get called when Installation ID changes.
 * Returns an unsubscribe function that will remove the callback when called.
 * @param installations - The `Installations` instance.
 * @param callback - The callback function that is invoked when FID changes.
 * @returns A function that can be called to unsubscribe.
 *
 * @public
 */
function onIdChange(installations, callback) {
  const {
    appConfig
  } = installations;
  addCallback(appConfig, callback);
  return () => {
    removeCallback(appConfig, callback);
  };
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Returns an instance of {@link Installations} associated with the given
 * {@link @firebase/app#FirebaseApp} instance.
 * @param app - The {@link @firebase/app#FirebaseApp} instance.
 *
 * @public
 */
function getInstallations(app = (0, _app.getApp)()) {
  const installationsImpl = (0, _app._getProvider)(app, 'installations').getImmediate();
  return installationsImpl;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function extractAppConfig(app) {
  if (!app || !app.options) {
    throw getMissingValueError('App Configuration');
  }
  if (!app.name) {
    throw getMissingValueError('App Name');
  }
  // Required app config keys
  const configKeys = ['projectId', 'apiKey', 'appId'];
  for (const keyName of configKeys) {
    if (!app.options[keyName]) {
      throw getMissingValueError(keyName);
    }
  }
  return {
    appName: app.name,
    projectId: app.options.projectId,
    apiKey: app.options.apiKey,
    appId: app.options.appId
  };
}
function getMissingValueError(valueName) {
  return ERROR_FACTORY.create("missing-app-config-values" /* ErrorCode.MISSING_APP_CONFIG_VALUES */, {
    valueName
  });
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const INSTALLATIONS_NAME = 'installations';
const INSTALLATIONS_NAME_INTERNAL = 'installations-internal';
const publicFactory = container => {
  const app = container.getProvider('app').getImmediate();
  // Throws if app isn't configured properly.
  const appConfig = extractAppConfig(app);
  const heartbeatServiceProvider = (0, _app._getProvider)(app, 'heartbeat');
  const installationsImpl = {
    app,
    appConfig,
    heartbeatServiceProvider,
    _delete: () => Promise.resolve()
  };
  return installationsImpl;
};
const internalFactory = container => {
  const app = container.getProvider('app').getImmediate();
  // Internal FIS instance relies on public FIS instance.
  const installations = (0, _app._getProvider)(app, INSTALLATIONS_NAME).getImmediate();
  const installationsInternal = {
    getId: () => getId(installations),
    getToken: forceRefresh => getToken(installations, forceRefresh)
  };
  return installationsInternal;
};
function registerInstallations() {
  (0, _app._registerComponent)(new _component.Component(INSTALLATIONS_NAME, publicFactory, "PUBLIC" /* ComponentType.PUBLIC */));
  (0, _app._registerComponent)(new _component.Component(INSTALLATIONS_NAME_INTERNAL, internalFactory, "PRIVATE" /* ComponentType.PRIVATE */));
}

/**
 * The Firebase Installations Web SDK.
 * This SDK does not work in a Node.js environment.
 *
 * @packageDocumentation
 */
registerInstallations();
(0, _app.registerVersion)(name, version);
// BUILD_TARGET will be replaced by values like esm2017, cjs2017, etc during the compilation
(0, _app.registerVersion)(name, version, 'esm2017');

      };
    };
  }
  }
}, {package:"@metamask/notification-services-controller>firebase>@firebase/installations",file:"node_modules\\@firebase\\installations\\dist\\esm\\index.esm2017.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@firebase\\logger\\dist\\index.cjs.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@firebase%5Clogger%5Cdist%5Cindex.cjs.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A container for all of the Logger instances
 */
const instances = [];
/**
 * The JS SDK supports 5 log levels and also allows a user the ability to
 * silence the logs altogether.
 *
 * The order is a follows:
 * DEBUG < VERBOSE < INFO < WARN < ERROR
 *
 * All of the log types above the current log level will be captured (i.e. if
 * you set the log level to `INFO`, errors will still be logged, but `DEBUG` and
 * `VERBOSE` logs will not)
 */
exports.LogLevel = void 0;
(function (LogLevel) {
  LogLevel[LogLevel["DEBUG"] = 0] = "DEBUG";
  LogLevel[LogLevel["VERBOSE"] = 1] = "VERBOSE";
  LogLevel[LogLevel["INFO"] = 2] = "INFO";
  LogLevel[LogLevel["WARN"] = 3] = "WARN";
  LogLevel[LogLevel["ERROR"] = 4] = "ERROR";
  LogLevel[LogLevel["SILENT"] = 5] = "SILENT";
})(exports.LogLevel || (exports.LogLevel = {}));
const levelStringToEnum = {
  'debug': exports.LogLevel.DEBUG,
  'verbose': exports.LogLevel.VERBOSE,
  'info': exports.LogLevel.INFO,
  'warn': exports.LogLevel.WARN,
  'error': exports.LogLevel.ERROR,
  'silent': exports.LogLevel.SILENT
};
/**
 * The default log level
 */
const defaultLogLevel = exports.LogLevel.INFO;
/**
 * By default, `console.debug` is not displayed in the developer console (in
 * chrome). To avoid forcing users to have to opt-in to these logs twice
 * (i.e. once for firebase, and once in the console), we are sending `DEBUG`
 * logs to the `console.log` function.
 */
const ConsoleMethod = {
  [exports.LogLevel.DEBUG]: 'log',
  [exports.LogLevel.VERBOSE]: 'log',
  [exports.LogLevel.INFO]: 'info',
  [exports.LogLevel.WARN]: 'warn',
  [exports.LogLevel.ERROR]: 'error'
};
/**
 * The default log handler will forward DEBUG, VERBOSE, INFO, WARN, and ERROR
 * messages on to their corresponding console counterparts (if the log method
 * is supported by the current log level)
 */
const defaultLogHandler = (instance, logType, ...args) => {
  if (logType < instance.logLevel) {
    return;
  }
  const now = new Date().toISOString();
  const method = ConsoleMethod[logType];
  if (method) {
    console[method](`[${now}]  ${instance.name}:`, ...args);
  } else {
    throw new Error(`Attempted to log a message with an invalid logType (value: ${logType})`);
  }
};
class Logger {
  /**
   * Gives you an instance of a Logger to capture messages according to
   * Firebase's logging scheme.
   *
   * @param name The name that the logs will be associated with
   */
  constructor(name) {
    this.name = name;
    /**
     * The log level of the given Logger instance.
     */
    this._logLevel = defaultLogLevel;
    /**
     * The main (internal) log handler for the Logger instance.
     * Can be set to a new function in internal package code but not by user.
     */
    this._logHandler = defaultLogHandler;
    /**
     * The optional, additional, user-defined log handler for the Logger instance.
     */
    this._userLogHandler = null;
    /**
     * Capture the current instance for later use
     */
    instances.push(this);
  }
  get logLevel() {
    return this._logLevel;
  }
  set logLevel(val) {
    if (!(val in exports.LogLevel)) {
      throw new TypeError(`Invalid value "${val}" assigned to \`logLevel\``);
    }
    this._logLevel = val;
  }
  // Workaround for setter/getter having to be the same type.
  setLogLevel(val) {
    this._logLevel = typeof val === 'string' ? levelStringToEnum[val] : val;
  }
  get logHandler() {
    return this._logHandler;
  }
  set logHandler(val) {
    if (typeof val !== 'function') {
      throw new TypeError('Value assigned to `logHandler` must be a function');
    }
    this._logHandler = val;
  }
  get userLogHandler() {
    return this._userLogHandler;
  }
  set userLogHandler(val) {
    this._userLogHandler = val;
  }
  /**
   * The functions below are all based on the `console` interface
   */
  debug(...args) {
    this._userLogHandler && this._userLogHandler(this, exports.LogLevel.DEBUG, ...args);
    this._logHandler(this, exports.LogLevel.DEBUG, ...args);
  }
  log(...args) {
    this._userLogHandler && this._userLogHandler(this, exports.LogLevel.VERBOSE, ...args);
    this._logHandler(this, exports.LogLevel.VERBOSE, ...args);
  }
  info(...args) {
    this._userLogHandler && this._userLogHandler(this, exports.LogLevel.INFO, ...args);
    this._logHandler(this, exports.LogLevel.INFO, ...args);
  }
  warn(...args) {
    this._userLogHandler && this._userLogHandler(this, exports.LogLevel.WARN, ...args);
    this._logHandler(this, exports.LogLevel.WARN, ...args);
  }
  error(...args) {
    this._userLogHandler && this._userLogHandler(this, exports.LogLevel.ERROR, ...args);
    this._logHandler(this, exports.LogLevel.ERROR, ...args);
  }
}
function setLogLevel(level) {
  instances.forEach(inst => {
    inst.setLogLevel(level);
  });
}
function setUserLogHandler(logCallback, options) {
  for (const instance of instances) {
    let customLogLevel = null;
    if (options && options.level) {
      customLogLevel = levelStringToEnum[options.level];
    }
    if (logCallback === null) {
      instance.userLogHandler = null;
    } else {
      instance.userLogHandler = (instance, level, ...args) => {
        const message = args.map(arg => {
          if (arg == null) {
            return null;
          } else if (typeof arg === 'string') {
            return arg;
          } else if (typeof arg === 'number' || typeof arg === 'boolean') {
            return arg.toString();
          } else if (arg instanceof Error) {
            return arg.message;
          } else {
            try {
              return JSON.stringify(arg);
            } catch (ignored) {
              return null;
            }
          }
        }).filter(arg => arg).join(' ');
        if (level >= (customLogLevel !== null && customLogLevel !== void 0 ? customLogLevel : instance.logLevel)) {
          logCallback({
            level: exports.LogLevel[level].toLowerCase(),
            message,
            args,
            type: instance.name
          });
        }
      };
    }
  }
}
exports.Logger = Logger;
exports.setLogLevel = setLogLevel;
exports.setUserLogHandler = setUserLogHandler;

      };
    };
  }
  }
}, {package:"@metamask/notification-services-controller>firebase>@firebase/app>@firebase/logger",file:"node_modules\\@firebase\\logger\\dist\\index.cjs.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@firebase\\messaging\\dist\\esm\\index.esm2017.js", {"@firebase/app":"D:\\code\\v\\metamask-extension\\node_modules\\@firebase\\app\\dist\\esm\\index.esm2017.js","@firebase/component":"D:\\code\\v\\metamask-extension\\node_modules\\@firebase\\component\\dist\\esm\\index.esm2017.js","@firebase/installations":"D:\\code\\v\\metamask-extension\\node_modules\\@firebase\\installations\\dist\\esm\\index.esm2017.js","@firebase/util":"D:\\code\\v\\metamask-extension\\node_modules\\@firebase\\util\\dist\\index.esm2017.js","idb":"D:\\code\\v\\metamask-extension\\node_modules\\idb\\build\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@firebase%5Cmessaging%5Cdist%5Cesm%5Cindex.esm2017.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteToken = deleteToken;
exports.getMessaging = getMessagingInWindow;
exports.getToken = getToken;
exports.isSupported = isWindowSupported;
exports.onMessage = onMessage;
require("@firebase/installations");
var _component = require("@firebase/component");
var _idb = require("idb");
var _util = require("@firebase/util");
var _app = require("@firebase/app");
/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const DEFAULT_SW_PATH = '/firebase-messaging-sw.js';
const DEFAULT_SW_SCOPE = '/firebase-cloud-messaging-push-scope';
const DEFAULT_VAPID_KEY = 'BDOU99-h67HcA6JeFXHbSNMu7e2yNNu3RzoMj8TM4W88jITfq7ZmPvIM1Iv-4_l2LxQcYwhqby2xGpWwzjfAnG4';
const ENDPOINT = 'https://fcmregistrations.googleapis.com/v1';
const CONSOLE_CAMPAIGN_ID = 'google.c.a.c_id';
const CONSOLE_CAMPAIGN_NAME = 'google.c.a.c_l';
const CONSOLE_CAMPAIGN_TIME = 'google.c.a.ts';
/** Set to '1' if Analytics is enabled for the campaign */
const CONSOLE_CAMPAIGN_ANALYTICS_ENABLED = 'google.c.a.e';
const DEFAULT_REGISTRATION_TIMEOUT = 10000;
var MessageType$1;
(function (MessageType) {
  MessageType[MessageType["DATA_MESSAGE"] = 1] = "DATA_MESSAGE";
  MessageType[MessageType["DISPLAY_NOTIFICATION"] = 3] = "DISPLAY_NOTIFICATION";
})(MessageType$1 || (MessageType$1 = {}));

/**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
var MessageType;
(function (MessageType) {
  MessageType["PUSH_RECEIVED"] = "push-received";
  MessageType["NOTIFICATION_CLICKED"] = "notification-clicked";
})(MessageType || (MessageType = {}));

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function arrayToBase64(array) {
  const uint8Array = new Uint8Array(array);
  const base64String = btoa(String.fromCharCode(...uint8Array));
  return base64String.replace(/=/g, '').replace(/\+/g, '-').replace(/\//g, '_');
}
function base64ToArray(base64String) {
  const padding = '='.repeat((4 - base64String.length % 4) % 4);
  const base64 = (base64String + padding).replace(/\-/g, '+').replace(/_/g, '/');
  const rawData = atob(base64);
  const outputArray = new Uint8Array(rawData.length);
  for (let i = 0; i < rawData.length; ++i) {
    outputArray[i] = rawData.charCodeAt(i);
  }
  return outputArray;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const OLD_DB_NAME = 'fcm_token_details_db';
/**
 * The last DB version of 'fcm_token_details_db' was 4. This is one higher, so that the upgrade
 * callback is called for all versions of the old DB.
 */
const OLD_DB_VERSION = 5;
const OLD_OBJECT_STORE_NAME = 'fcm_token_object_Store';
async function migrateOldDatabase(senderId) {
  if ('databases' in indexedDB) {
    // indexedDb.databases() is an IndexedDB v3 API and does not exist in all browsers. TODO: Remove
    // typecast when it lands in TS types.
    const databases = await indexedDB.databases();
    const dbNames = databases.map(db => db.name);
    if (!dbNames.includes(OLD_DB_NAME)) {
      // old DB didn't exist, no need to open.
      return null;
    }
  }
  let tokenDetails = null;
  const db = await (0, _idb.openDB)(OLD_DB_NAME, OLD_DB_VERSION, {
    upgrade: async (db, oldVersion, newVersion, upgradeTransaction) => {
      var _a;
      if (oldVersion < 2) {
        // Database too old, skip migration.
        return;
      }
      if (!db.objectStoreNames.contains(OLD_OBJECT_STORE_NAME)) {
        // Database did not exist. Nothing to do.
        return;
      }
      const objectStore = upgradeTransaction.objectStore(OLD_OBJECT_STORE_NAME);
      const value = await objectStore.index('fcmSenderId').get(senderId);
      await objectStore.clear();
      if (!value) {
        // No entry in the database, nothing to migrate.
        return;
      }
      if (oldVersion === 2) {
        const oldDetails = value;
        if (!oldDetails.auth || !oldDetails.p256dh || !oldDetails.endpoint) {
          return;
        }
        tokenDetails = {
          token: oldDetails.fcmToken,
          createTime: (_a = oldDetails.createTime) !== null && _a !== void 0 ? _a : Date.now(),
          subscriptionOptions: {
            auth: oldDetails.auth,
            p256dh: oldDetails.p256dh,
            endpoint: oldDetails.endpoint,
            swScope: oldDetails.swScope,
            vapidKey: typeof oldDetails.vapidKey === 'string' ? oldDetails.vapidKey : arrayToBase64(oldDetails.vapidKey)
          }
        };
      } else if (oldVersion === 3) {
        const oldDetails = value;
        tokenDetails = {
          token: oldDetails.fcmToken,
          createTime: oldDetails.createTime,
          subscriptionOptions: {
            auth: arrayToBase64(oldDetails.auth),
            p256dh: arrayToBase64(oldDetails.p256dh),
            endpoint: oldDetails.endpoint,
            swScope: oldDetails.swScope,
            vapidKey: arrayToBase64(oldDetails.vapidKey)
          }
        };
      } else if (oldVersion === 4) {
        const oldDetails = value;
        tokenDetails = {
          token: oldDetails.fcmToken,
          createTime: oldDetails.createTime,
          subscriptionOptions: {
            auth: arrayToBase64(oldDetails.auth),
            p256dh: arrayToBase64(oldDetails.p256dh),
            endpoint: oldDetails.endpoint,
            swScope: oldDetails.swScope,
            vapidKey: arrayToBase64(oldDetails.vapidKey)
          }
        };
      }
    }
  });
  db.close();
  // Delete all old databases.
  await (0, _idb.deleteDB)(OLD_DB_NAME);
  await (0, _idb.deleteDB)('fcm_vapid_details_db');
  await (0, _idb.deleteDB)('undefined');
  return checkTokenDetails(tokenDetails) ? tokenDetails : null;
}
function checkTokenDetails(tokenDetails) {
  if (!tokenDetails || !tokenDetails.subscriptionOptions) {
    return false;
  }
  const {
    subscriptionOptions
  } = tokenDetails;
  return typeof tokenDetails.createTime === 'number' && tokenDetails.createTime > 0 && typeof tokenDetails.token === 'string' && tokenDetails.token.length > 0 && typeof subscriptionOptions.auth === 'string' && subscriptionOptions.auth.length > 0 && typeof subscriptionOptions.p256dh === 'string' && subscriptionOptions.p256dh.length > 0 && typeof subscriptionOptions.endpoint === 'string' && subscriptionOptions.endpoint.length > 0 && typeof subscriptionOptions.swScope === 'string' && subscriptionOptions.swScope.length > 0 && typeof subscriptionOptions.vapidKey === 'string' && subscriptionOptions.vapidKey.length > 0;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Exported for tests.
const DATABASE_NAME = 'firebase-messaging-database';
const DATABASE_VERSION = 1;
const OBJECT_STORE_NAME = 'firebase-messaging-store';
let dbPromise = null;
function getDbPromise() {
  if (!dbPromise) {
    dbPromise = (0, _idb.openDB)(DATABASE_NAME, DATABASE_VERSION, {
      upgrade: (upgradeDb, oldVersion) => {
        // We don't use 'break' in this switch statement, the fall-through behavior is what we want,
        // because if there are multiple versions between the old version and the current version, we
        // want ALL the migrations that correspond to those versions to run, not only the last one.
        // eslint-disable-next-line default-case
        switch (oldVersion) {
          case 0:
            upgradeDb.createObjectStore(OBJECT_STORE_NAME);
        }
      }
    });
  }
  return dbPromise;
}
/** Gets record(s) from the objectStore that match the given key. */
async function dbGet(firebaseDependencies) {
  const key = getKey(firebaseDependencies);
  const db = await getDbPromise();
  const tokenDetails = await db.transaction(OBJECT_STORE_NAME).objectStore(OBJECT_STORE_NAME).get(key);
  if (tokenDetails) {
    return tokenDetails;
  } else {
    // Check if there is a tokenDetails object in the old DB.
    const oldTokenDetails = await migrateOldDatabase(firebaseDependencies.appConfig.senderId);
    if (oldTokenDetails) {
      await dbSet(firebaseDependencies, oldTokenDetails);
      return oldTokenDetails;
    }
  }
}
/** Assigns or overwrites the record for the given key with the given value. */
async function dbSet(firebaseDependencies, tokenDetails) {
  const key = getKey(firebaseDependencies);
  const db = await getDbPromise();
  const tx = db.transaction(OBJECT_STORE_NAME, 'readwrite');
  await tx.objectStore(OBJECT_STORE_NAME).put(tokenDetails, key);
  await tx.done;
  return tokenDetails;
}
/** Removes record(s) from the objectStore that match the given key. */
async function dbRemove(firebaseDependencies) {
  const key = getKey(firebaseDependencies);
  const db = await getDbPromise();
  const tx = db.transaction(OBJECT_STORE_NAME, 'readwrite');
  await tx.objectStore(OBJECT_STORE_NAME).delete(key);
  await tx.done;
}
function getKey({
  appConfig
}) {
  return appConfig.appId;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const ERROR_MAP = {
  ["missing-app-config-values" /* ErrorCode.MISSING_APP_CONFIG_VALUES */]: 'Missing App configuration value: "{$valueName}"',
  ["only-available-in-window" /* ErrorCode.AVAILABLE_IN_WINDOW */]: 'This method is available in a Window context.',
  ["only-available-in-sw" /* ErrorCode.AVAILABLE_IN_SW */]: 'This method is available in a service worker context.',
  ["permission-default" /* ErrorCode.PERMISSION_DEFAULT */]: 'The notification permission was not granted and dismissed instead.',
  ["permission-blocked" /* ErrorCode.PERMISSION_BLOCKED */]: 'The notification permission was not granted and blocked instead.',
  ["unsupported-browser" /* ErrorCode.UNSUPPORTED_BROWSER */]: "This browser doesn't support the API's required to use the Firebase SDK.",
  ["indexed-db-unsupported" /* ErrorCode.INDEXED_DB_UNSUPPORTED */]: "This browser doesn't support indexedDb.open() (ex. Safari iFrame, Firefox Private Browsing, etc)",
  ["failed-service-worker-registration" /* ErrorCode.FAILED_DEFAULT_REGISTRATION */]: 'We are unable to register the default service worker. {$browserErrorMessage}',
  ["token-subscribe-failed" /* ErrorCode.TOKEN_SUBSCRIBE_FAILED */]: 'A problem occurred while subscribing the user to FCM: {$errorInfo}',
  ["token-subscribe-no-token" /* ErrorCode.TOKEN_SUBSCRIBE_NO_TOKEN */]: 'FCM returned no token when subscribing the user to push.',
  ["token-unsubscribe-failed" /* ErrorCode.TOKEN_UNSUBSCRIBE_FAILED */]: 'A problem occurred while unsubscribing the ' + 'user from FCM: {$errorInfo}',
  ["token-update-failed" /* ErrorCode.TOKEN_UPDATE_FAILED */]: 'A problem occurred while updating the user from FCM: {$errorInfo}',
  ["token-update-no-token" /* ErrorCode.TOKEN_UPDATE_NO_TOKEN */]: 'FCM returned no token when updating the user to push.',
  ["use-sw-after-get-token" /* ErrorCode.USE_SW_AFTER_GET_TOKEN */]: 'The useServiceWorker() method may only be called once and must be ' + 'called before calling getToken() to ensure your service worker is used.',
  ["invalid-sw-registration" /* ErrorCode.INVALID_SW_REGISTRATION */]: 'The input to useServiceWorker() must be a ServiceWorkerRegistration.',
  ["invalid-bg-handler" /* ErrorCode.INVALID_BG_HANDLER */]: 'The input to setBackgroundMessageHandler() must be a function.',
  ["invalid-vapid-key" /* ErrorCode.INVALID_VAPID_KEY */]: 'The public VAPID key must be a string.',
  ["use-vapid-key-after-get-token" /* ErrorCode.USE_VAPID_KEY_AFTER_GET_TOKEN */]: 'The usePublicVapidKey() method may only be called once and must be ' + 'called before calling getToken() to ensure your VAPID key is used.'
};
const ERROR_FACTORY = new _util.ErrorFactory('messaging', 'Messaging', ERROR_MAP);

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
async function requestGetToken(firebaseDependencies, subscriptionOptions) {
  const headers = await getHeaders(firebaseDependencies);
  const body = getBody(subscriptionOptions);
  const subscribeOptions = {
    method: 'POST',
    headers,
    body: JSON.stringify(body)
  };
  let responseData;
  try {
    const response = await fetch(getEndpoint(firebaseDependencies.appConfig), subscribeOptions);
    responseData = await response.json();
  } catch (err) {
    throw ERROR_FACTORY.create("token-subscribe-failed" /* ErrorCode.TOKEN_SUBSCRIBE_FAILED */, {
      errorInfo: err === null || err === void 0 ? void 0 : err.toString()
    });
  }
  if (responseData.error) {
    const message = responseData.error.message;
    throw ERROR_FACTORY.create("token-subscribe-failed" /* ErrorCode.TOKEN_SUBSCRIBE_FAILED */, {
      errorInfo: message
    });
  }
  if (!responseData.token) {
    throw ERROR_FACTORY.create("token-subscribe-no-token" /* ErrorCode.TOKEN_SUBSCRIBE_NO_TOKEN */);
  }
  return responseData.token;
}
async function requestUpdateToken(firebaseDependencies, tokenDetails) {
  const headers = await getHeaders(firebaseDependencies);
  const body = getBody(tokenDetails.subscriptionOptions);
  const updateOptions = {
    method: 'PATCH',
    headers,
    body: JSON.stringify(body)
  };
  let responseData;
  try {
    const response = await fetch(`${getEndpoint(firebaseDependencies.appConfig)}/${tokenDetails.token}`, updateOptions);
    responseData = await response.json();
  } catch (err) {
    throw ERROR_FACTORY.create("token-update-failed" /* ErrorCode.TOKEN_UPDATE_FAILED */, {
      errorInfo: err === null || err === void 0 ? void 0 : err.toString()
    });
  }
  if (responseData.error) {
    const message = responseData.error.message;
    throw ERROR_FACTORY.create("token-update-failed" /* ErrorCode.TOKEN_UPDATE_FAILED */, {
      errorInfo: message
    });
  }
  if (!responseData.token) {
    throw ERROR_FACTORY.create("token-update-no-token" /* ErrorCode.TOKEN_UPDATE_NO_TOKEN */);
  }
  return responseData.token;
}
async function requestDeleteToken(firebaseDependencies, token) {
  const headers = await getHeaders(firebaseDependencies);
  const unsubscribeOptions = {
    method: 'DELETE',
    headers
  };
  try {
    const response = await fetch(`${getEndpoint(firebaseDependencies.appConfig)}/${token}`, unsubscribeOptions);
    const responseData = await response.json();
    if (responseData.error) {
      const message = responseData.error.message;
      throw ERROR_FACTORY.create("token-unsubscribe-failed" /* ErrorCode.TOKEN_UNSUBSCRIBE_FAILED */, {
        errorInfo: message
      });
    }
  } catch (err) {
    throw ERROR_FACTORY.create("token-unsubscribe-failed" /* ErrorCode.TOKEN_UNSUBSCRIBE_FAILED */, {
      errorInfo: err === null || err === void 0 ? void 0 : err.toString()
    });
  }
}
function getEndpoint({
  projectId
}) {
  return `${ENDPOINT}/projects/${projectId}/registrations`;
}
async function getHeaders({
  appConfig,
  installations
}) {
  const authToken = await installations.getToken();
  return new Headers({
    'Content-Type': 'application/json',
    Accept: 'application/json',
    'x-goog-api-key': appConfig.apiKey,
    'x-goog-firebase-installations-auth': `FIS ${authToken}`
  });
}
function getBody({
  p256dh,
  auth,
  endpoint,
  vapidKey
}) {
  const body = {
    web: {
      endpoint,
      auth,
      p256dh
    }
  };
  if (vapidKey !== DEFAULT_VAPID_KEY) {
    body.web.applicationPubKey = vapidKey;
  }
  return body;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// UpdateRegistration will be called once every week.
const TOKEN_EXPIRATION_MS = 7 * 24 * 60 * 60 * 1000; // 7 days
async function getTokenInternal(messaging) {
  const pushSubscription = await getPushSubscription(messaging.swRegistration, messaging.vapidKey);
  const subscriptionOptions = {
    vapidKey: messaging.vapidKey,
    swScope: messaging.swRegistration.scope,
    endpoint: pushSubscription.endpoint,
    auth: arrayToBase64(pushSubscription.getKey('auth')),
    p256dh: arrayToBase64(pushSubscription.getKey('p256dh'))
  };
  const tokenDetails = await dbGet(messaging.firebaseDependencies);
  if (!tokenDetails) {
    // No token, get a new one.
    return getNewToken(messaging.firebaseDependencies, subscriptionOptions);
  } else if (!isTokenValid(tokenDetails.subscriptionOptions, subscriptionOptions)) {
    // Invalid token, get a new one.
    try {
      await requestDeleteToken(messaging.firebaseDependencies, tokenDetails.token);
    } catch (e) {
      // Suppress errors because of #2364
      console.warn(e);
    }
    return getNewToken(messaging.firebaseDependencies, subscriptionOptions);
  } else if (Date.now() >= tokenDetails.createTime + TOKEN_EXPIRATION_MS) {
    // Weekly token refresh
    return updateToken(messaging, {
      token: tokenDetails.token,
      createTime: Date.now(),
      subscriptionOptions
    });
  } else {
    // Valid token, nothing to do.
    return tokenDetails.token;
  }
}
/**
 * This method deletes the token from the database, unsubscribes the token from FCM, and unregisters
 * the push subscription if it exists.
 */
async function deleteTokenInternal(messaging) {
  const tokenDetails = await dbGet(messaging.firebaseDependencies);
  if (tokenDetails) {
    await requestDeleteToken(messaging.firebaseDependencies, tokenDetails.token);
    await dbRemove(messaging.firebaseDependencies);
  }
  // Unsubscribe from the push subscription.
  const pushSubscription = await messaging.swRegistration.pushManager.getSubscription();
  if (pushSubscription) {
    return pushSubscription.unsubscribe();
  }
  // If there's no SW, consider it a success.
  return true;
}
async function updateToken(messaging, tokenDetails) {
  try {
    const updatedToken = await requestUpdateToken(messaging.firebaseDependencies, tokenDetails);
    const updatedTokenDetails = Object.assign(Object.assign({}, tokenDetails), {
      token: updatedToken,
      createTime: Date.now()
    });
    await dbSet(messaging.firebaseDependencies, updatedTokenDetails);
    return updatedToken;
  } catch (e) {
    throw e;
  }
}
async function getNewToken(firebaseDependencies, subscriptionOptions) {
  const token = await requestGetToken(firebaseDependencies, subscriptionOptions);
  const tokenDetails = {
    token,
    createTime: Date.now(),
    subscriptionOptions
  };
  await dbSet(firebaseDependencies, tokenDetails);
  return tokenDetails.token;
}
/**
 * Gets a PushSubscription for the current user.
 */
async function getPushSubscription(swRegistration, vapidKey) {
  const subscription = await swRegistration.pushManager.getSubscription();
  if (subscription) {
    return subscription;
  }
  return swRegistration.pushManager.subscribe({
    userVisibleOnly: true,
    // Chrome <= 75 doesn't support base64-encoded VAPID key. For backward compatibility, VAPID key
    // submitted to pushManager#subscribe must be of type Uint8Array.
    applicationServerKey: base64ToArray(vapidKey)
  });
}
/**
 * Checks if the saved tokenDetails object matches the configuration provided.
 */
function isTokenValid(dbOptions, currentOptions) {
  const isVapidKeyEqual = currentOptions.vapidKey === dbOptions.vapidKey;
  const isEndpointEqual = currentOptions.endpoint === dbOptions.endpoint;
  const isAuthEqual = currentOptions.auth === dbOptions.auth;
  const isP256dhEqual = currentOptions.p256dh === dbOptions.p256dh;
  return isVapidKeyEqual && isEndpointEqual && isAuthEqual && isP256dhEqual;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function externalizePayload(internalPayload) {
  const payload = {
    from: internalPayload.from,
    // eslint-disable-next-line camelcase
    collapseKey: internalPayload.collapse_key,
    // eslint-disable-next-line camelcase
    messageId: internalPayload.fcmMessageId
  };
  propagateNotificationPayload(payload, internalPayload);
  propagateDataPayload(payload, internalPayload);
  propagateFcmOptions(payload, internalPayload);
  return payload;
}
function propagateNotificationPayload(payload, messagePayloadInternal) {
  if (!messagePayloadInternal.notification) {
    return;
  }
  payload.notification = {};
  const title = messagePayloadInternal.notification.title;
  if (!!title) {
    payload.notification.title = title;
  }
  const body = messagePayloadInternal.notification.body;
  if (!!body) {
    payload.notification.body = body;
  }
  const image = messagePayloadInternal.notification.image;
  if (!!image) {
    payload.notification.image = image;
  }
  const icon = messagePayloadInternal.notification.icon;
  if (!!icon) {
    payload.notification.icon = icon;
  }
}
function propagateDataPayload(payload, messagePayloadInternal) {
  if (!messagePayloadInternal.data) {
    return;
  }
  payload.data = messagePayloadInternal.data;
}
function propagateFcmOptions(payload, messagePayloadInternal) {
  var _a, _b, _c, _d, _e;
  // fcmOptions.link value is written into notification.click_action. see more in b/232072111
  if (!messagePayloadInternal.fcmOptions && !((_a = messagePayloadInternal.notification) === null || _a === void 0 ? void 0 : _a.click_action)) {
    return;
  }
  payload.fcmOptions = {};
  const link = (_c = (_b = messagePayloadInternal.fcmOptions) === null || _b === void 0 ? void 0 : _b.link) !== null && _c !== void 0 ? _c : (_d = messagePayloadInternal.notification) === null || _d === void 0 ? void 0 : _d.click_action;
  if (!!link) {
    payload.fcmOptions.link = link;
  }
  // eslint-disable-next-line camelcase
  const analyticsLabel = (_e = messagePayloadInternal.fcmOptions) === null || _e === void 0 ? void 0 : _e.analytics_label;
  if (!!analyticsLabel) {
    payload.fcmOptions.analyticsLabel = analyticsLabel;
  }
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function isConsoleMessage(data) {
  // This message has a campaign ID, meaning it was sent using the Firebase Console.
  return typeof data === 'object' && !!data && CONSOLE_CAMPAIGN_ID in data;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
_mergeStrings('AzSCbw63g1R0nCw85jG8', 'Iaya3yLKwmgvh7cF0q4');
function _mergeStrings(s1, s2) {
  const resultArray = [];
  for (let i = 0; i < s1.length; i++) {
    resultArray.push(s1.charAt(i));
    if (i < s2.length) {
      resultArray.push(s2.charAt(i));
    }
  }
  return resultArray.join('');
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function extractAppConfig(app) {
  if (!app || !app.options) {
    throw getMissingValueError('App Configuration Object');
  }
  if (!app.name) {
    throw getMissingValueError('App Name');
  }
  // Required app config keys
  const configKeys = ['projectId', 'apiKey', 'appId', 'messagingSenderId'];
  const {
    options
  } = app;
  for (const keyName of configKeys) {
    if (!options[keyName]) {
      throw getMissingValueError(keyName);
    }
  }
  return {
    appName: app.name,
    projectId: options.projectId,
    apiKey: options.apiKey,
    appId: options.appId,
    senderId: options.messagingSenderId
  };
}
function getMissingValueError(valueName) {
  return ERROR_FACTORY.create("missing-app-config-values" /* ErrorCode.MISSING_APP_CONFIG_VALUES */, {
    valueName
  });
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class MessagingService {
  constructor(app, installations, analyticsProvider) {
    // logging is only done with end user consent. Default to false.
    this.deliveryMetricsExportedToBigQueryEnabled = false;
    this.onBackgroundMessageHandler = null;
    this.onMessageHandler = null;
    this.logEvents = [];
    this.isLogServiceStarted = false;
    const appConfig = extractAppConfig(app);
    this.firebaseDependencies = {
      app,
      appConfig,
      installations,
      analyticsProvider
    };
  }
  _delete() {
    return Promise.resolve();
  }
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
async function registerDefaultSw(messaging) {
  try {
    messaging.swRegistration = await navigator.serviceWorker.register(DEFAULT_SW_PATH, {
      scope: DEFAULT_SW_SCOPE
    });
    // The timing when browser updates sw when sw has an update is unreliable from experiment. It
    // leads to version conflict when the SDK upgrades to a newer version in the main page, but sw
    // is stuck with the old version. For example,
    // https://github.com/firebase/firebase-js-sdk/issues/2590 The following line reliably updates
    // sw if there was an update.
    messaging.swRegistration.update().catch(() => {
      /* it is non blocking and we don't care if it failed */
    });
    await waitForRegistrationActive(messaging.swRegistration);
  } catch (e) {
    throw ERROR_FACTORY.create("failed-service-worker-registration" /* ErrorCode.FAILED_DEFAULT_REGISTRATION */, {
      browserErrorMessage: e === null || e === void 0 ? void 0 : e.message
    });
  }
}
/**
 * Waits for registration to become active. MDN documentation claims that
 * a service worker registration should be ready to use after awaiting
 * navigator.serviceWorker.register() but that doesn't seem to be the case in
 * practice, causing the SDK to throw errors when calling
 * swRegistration.pushManager.subscribe() too soon after register(). The only
 * solution seems to be waiting for the service worker registration `state`
 * to become "active".
 */
async function waitForRegistrationActive(registration) {
  return new Promise((resolve, reject) => {
    const rejectTimeout = setTimeout(() => reject(new Error(`Service worker not registered after ${DEFAULT_REGISTRATION_TIMEOUT} ms`)), DEFAULT_REGISTRATION_TIMEOUT);
    const incomingSw = registration.installing || registration.waiting;
    if (registration.active) {
      clearTimeout(rejectTimeout);
      resolve();
    } else if (incomingSw) {
      incomingSw.onstatechange = ev => {
        var _a;
        if (((_a = ev.target) === null || _a === void 0 ? void 0 : _a.state) === 'activated') {
          incomingSw.onstatechange = null;
          clearTimeout(rejectTimeout);
          resolve();
        }
      };
    } else {
      clearTimeout(rejectTimeout);
      reject(new Error('No incoming service worker found.'));
    }
  });
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
async function updateSwReg(messaging, swRegistration) {
  if (!swRegistration && !messaging.swRegistration) {
    await registerDefaultSw(messaging);
  }
  if (!swRegistration && !!messaging.swRegistration) {
    return;
  }
  if (!(swRegistration instanceof ServiceWorkerRegistration)) {
    throw ERROR_FACTORY.create("invalid-sw-registration" /* ErrorCode.INVALID_SW_REGISTRATION */);
  }
  messaging.swRegistration = swRegistration;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
async function updateVapidKey(messaging, vapidKey) {
  if (!!vapidKey) {
    messaging.vapidKey = vapidKey;
  } else if (!messaging.vapidKey) {
    messaging.vapidKey = DEFAULT_VAPID_KEY;
  }
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
async function getToken$1(messaging, options) {
  if (!navigator) {
    throw ERROR_FACTORY.create("only-available-in-window" /* ErrorCode.AVAILABLE_IN_WINDOW */);
  }
  if (Notification.permission === 'default') {
    await Notification.requestPermission();
  }
  if (Notification.permission !== 'granted') {
    throw ERROR_FACTORY.create("permission-blocked" /* ErrorCode.PERMISSION_BLOCKED */);
  }
  await updateVapidKey(messaging, options === null || options === void 0 ? void 0 : options.vapidKey);
  await updateSwReg(messaging, options === null || options === void 0 ? void 0 : options.serviceWorkerRegistration);
  return getTokenInternal(messaging);
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
async function logToScion(messaging, messageType, data) {
  const eventType = getEventType(messageType);
  const analytics = await messaging.firebaseDependencies.analyticsProvider.get();
  analytics.logEvent(eventType, {
    /* eslint-disable camelcase */
    message_id: data[CONSOLE_CAMPAIGN_ID],
    message_name: data[CONSOLE_CAMPAIGN_NAME],
    message_time: data[CONSOLE_CAMPAIGN_TIME],
    message_device_time: Math.floor(Date.now() / 1000)
    /* eslint-enable camelcase */
  });
}
function getEventType(messageType) {
  switch (messageType) {
    case MessageType.NOTIFICATION_CLICKED:
      return 'notification_open';
    case MessageType.PUSH_RECEIVED:
      return 'notification_foreground';
    default:
      throw new Error();
  }
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
async function messageEventListener(messaging, event) {
  const internalPayload = event.data;
  if (!internalPayload.isFirebaseMessaging) {
    return;
  }
  if (messaging.onMessageHandler && internalPayload.messageType === MessageType.PUSH_RECEIVED) {
    if (typeof messaging.onMessageHandler === 'function') {
      messaging.onMessageHandler(externalizePayload(internalPayload));
    } else {
      messaging.onMessageHandler.next(externalizePayload(internalPayload));
    }
  }
  // Log to Scion if applicable
  const dataPayload = internalPayload.data;
  if (isConsoleMessage(dataPayload) && dataPayload[CONSOLE_CAMPAIGN_ANALYTICS_ENABLED] === '1') {
    await logToScion(messaging, internalPayload.messageType, dataPayload);
  }
}
const name = "@firebase/messaging";
const version = "0.12.16";

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const WindowMessagingFactory = container => {
  const messaging = new MessagingService(container.getProvider('app').getImmediate(), container.getProvider('installations-internal').getImmediate(), container.getProvider('analytics-internal'));
  navigator.serviceWorker.addEventListener('message', e => messageEventListener(messaging, e));
  return messaging;
};
const WindowMessagingInternalFactory = container => {
  const messaging = container.getProvider('messaging').getImmediate();
  const messagingInternal = {
    getToken: options => getToken$1(messaging, options)
  };
  return messagingInternal;
};
function registerMessagingInWindow() {
  (0, _app._registerComponent)(new _component.Component('messaging', WindowMessagingFactory, "PUBLIC" /* ComponentType.PUBLIC */));
  (0, _app._registerComponent)(new _component.Component('messaging-internal', WindowMessagingInternalFactory, "PRIVATE" /* ComponentType.PRIVATE */));
  (0, _app.registerVersion)(name, version);
  // BUILD_TARGET will be replaced by values like esm2017, cjs2017, etc during the compilation
  (0, _app.registerVersion)(name, version, 'esm2017');
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Checks if all required APIs exist in the browser.
 * @returns a Promise that resolves to a boolean.
 *
 * @public
 */
async function isWindowSupported() {
  try {
    // This throws if open() is unsupported, so adding it to the conditional
    // statement below can cause an uncaught error.
    await (0, _util.validateIndexedDBOpenable)();
  } catch (e) {
    return false;
  }
  // firebase-js-sdk/issues/2393 reveals that idb#open in Safari iframe and Firefox private browsing
  // might be prohibited to run. In these contexts, an error would be thrown during the messaging
  // instantiating phase, informing the developers to import/call isSupported for special handling.
  return typeof window !== 'undefined' && (0, _util.isIndexedDBAvailable)() && (0, _util.areCookiesEnabled)() && 'serviceWorker' in navigator && 'PushManager' in window && 'Notification' in window && 'fetch' in window && ServiceWorkerRegistration.prototype.hasOwnProperty('showNotification') && PushSubscription.prototype.hasOwnProperty('getKey');
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
async function deleteToken$1(messaging) {
  if (!navigator) {
    throw ERROR_FACTORY.create("only-available-in-window" /* ErrorCode.AVAILABLE_IN_WINDOW */);
  }
  if (!messaging.swRegistration) {
    await registerDefaultSw(messaging);
  }
  return deleteTokenInternal(messaging);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function onMessage$1(messaging, nextOrObserver) {
  if (!navigator) {
    throw ERROR_FACTORY.create("only-available-in-window" /* ErrorCode.AVAILABLE_IN_WINDOW */);
  }
  messaging.onMessageHandler = nextOrObserver;
  return () => {
    messaging.onMessageHandler = null;
  };
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Retrieves a Firebase Cloud Messaging instance.
 *
 * @returns The Firebase Cloud Messaging instance associated with the provided firebase app.
 *
 * @public
 */
function getMessagingInWindow(app = (0, _app.getApp)()) {
  // Conscious decision to make this async check non-blocking during the messaging instance
  // initialization phase for performance consideration. An error would be thrown latter for
  // developer's information. Developers can then choose to import and call `isSupported` for
  // special handling.
  isWindowSupported().then(isSupported => {
    // If `isWindowSupported()` resolved, but returned false.
    if (!isSupported) {
      throw ERROR_FACTORY.create("unsupported-browser" /* ErrorCode.UNSUPPORTED_BROWSER */);
    }
  }, _ => {
    // If `isWindowSupported()` rejected.
    throw ERROR_FACTORY.create("indexed-db-unsupported" /* ErrorCode.INDEXED_DB_UNSUPPORTED */);
  });
  return (0, _app._getProvider)((0, _util.getModularInstance)(app), 'messaging').getImmediate();
}
/**
 * Subscribes the {@link Messaging} instance to push notifications. Returns a Firebase Cloud
 * Messaging registration token that can be used to send push messages to that {@link Messaging}
 * instance.
 *
 * If notification permission isn't already granted, this method asks the user for permission. The
 * returned promise rejects if the user does not allow the app to show notifications.
 *
 * @param messaging - The {@link Messaging} instance.
 * @param options - Provides an optional vapid key and an optional service worker registration.
 *
 * @returns The promise resolves with an FCM registration token.
 *
 * @public
 */
async function getToken(messaging, options) {
  messaging = (0, _util.getModularInstance)(messaging);
  return getToken$1(messaging, options);
}
/**
 * Deletes the registration token associated with this {@link Messaging} instance and unsubscribes
 * the {@link Messaging} instance from the push subscription.
 *
 * @param messaging - The {@link Messaging} instance.
 *
 * @returns The promise resolves when the token has been successfully deleted.
 *
 * @public
 */
function deleteToken(messaging) {
  messaging = (0, _util.getModularInstance)(messaging);
  return deleteToken$1(messaging);
}
/**
 * When a push message is received and the user is currently on a page for your origin, the
 * message is passed to the page and an `onMessage()` event is dispatched with the payload of
 * the push message.
 *
 *
 * @param messaging - The {@link Messaging} instance.
 * @param nextOrObserver - This function, or observer object with `next` defined,
 *     is called when a message is received and the user is currently viewing your page.
 * @returns To stop listening for messages execute this returned function.
 *
 * @public
 */
function onMessage(messaging, nextOrObserver) {
  messaging = (0, _util.getModularInstance)(messaging);
  return onMessage$1(messaging, nextOrObserver);
}

/**
 * The Firebase Cloud Messaging Web SDK.
 * This SDK does not work in a Node.js environment.
 *
 * @packageDocumentation
 */
registerMessagingInWindow();

      };
    };
  }
  }
}, {package:"@metamask/notification-services-controller>firebase>@firebase/messaging",file:"node_modules\\@firebase\\messaging\\dist\\esm\\index.esm2017.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@firebase\\messaging\\dist\\index.sw.cjs", {"@firebase/app":"D:\\code\\v\\metamask-extension\\node_modules\\@firebase\\app\\dist\\esm\\index.esm2017.js","@firebase/component":"D:\\code\\v\\metamask-extension\\node_modules\\@firebase\\component\\dist\\esm\\index.esm2017.js","@firebase/installations":"D:\\code\\v\\metamask-extension\\node_modules\\@firebase\\installations\\dist\\esm\\index.esm2017.js","@firebase/util":"D:\\code\\v\\metamask-extension\\node_modules\\@firebase\\util\\dist\\index.esm2017.js","idb":"D:\\code\\v\\metamask-extension\\node_modules\\idb\\build\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@firebase%5Cmessaging%5Cdist%5Cindex.sw.cjs
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
require('@firebase/installations');
var component = require('@firebase/component');
var idb = require('idb');
var util = require('@firebase/util');
var app = require('@firebase/app');

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const DEFAULT_VAPID_KEY = 'BDOU99-h67HcA6JeFXHbSNMu7e2yNNu3RzoMj8TM4W88jITfq7ZmPvIM1Iv-4_l2LxQcYwhqby2xGpWwzjfAnG4';
const ENDPOINT = 'https://fcmregistrations.googleapis.com/v1';
/** Key of FCM Payload in Notification's data field. */
const FCM_MSG = 'FCM_MSG';
const CONSOLE_CAMPAIGN_ID = 'google.c.a.c_id';
// Defined as in proto/messaging_event.proto. Neglecting fields that are supported.
const SDK_PLATFORM_WEB = 3;
const EVENT_MESSAGE_DELIVERED = 1;
var MessageType$1;
(function (MessageType) {
  MessageType[MessageType["DATA_MESSAGE"] = 1] = "DATA_MESSAGE";
  MessageType[MessageType["DISPLAY_NOTIFICATION"] = 3] = "DISPLAY_NOTIFICATION";
})(MessageType$1 || (MessageType$1 = {}));

/**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
var MessageType;
(function (MessageType) {
  MessageType["PUSH_RECEIVED"] = "push-received";
  MessageType["NOTIFICATION_CLICKED"] = "notification-clicked";
})(MessageType || (MessageType = {}));

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function arrayToBase64(array) {
  const uint8Array = new Uint8Array(array);
  const base64String = btoa(String.fromCharCode(...uint8Array));
  return base64String.replace(/=/g, '').replace(/\+/g, '-').replace(/\//g, '_');
}
function base64ToArray(base64String) {
  const padding = '='.repeat((4 - base64String.length % 4) % 4);
  const base64 = (base64String + padding).replace(/\-/g, '+').replace(/_/g, '/');
  const rawData = atob(base64);
  const outputArray = new Uint8Array(rawData.length);
  for (let i = 0; i < rawData.length; ++i) {
    outputArray[i] = rawData.charCodeAt(i);
  }
  return outputArray;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const OLD_DB_NAME = 'fcm_token_details_db';
/**
 * The last DB version of 'fcm_token_details_db' was 4. This is one higher, so that the upgrade
 * callback is called for all versions of the old DB.
 */
const OLD_DB_VERSION = 5;
const OLD_OBJECT_STORE_NAME = 'fcm_token_object_Store';
async function migrateOldDatabase(senderId) {
  if ('databases' in indexedDB) {
    // indexedDb.databases() is an IndexedDB v3 API and does not exist in all browsers. TODO: Remove
    // typecast when it lands in TS types.
    const databases = await indexedDB.databases();
    const dbNames = databases.map(db => db.name);
    if (!dbNames.includes(OLD_DB_NAME)) {
      // old DB didn't exist, no need to open.
      return null;
    }
  }
  let tokenDetails = null;
  const db = await idb.openDB(OLD_DB_NAME, OLD_DB_VERSION, {
    upgrade: async (db, oldVersion, newVersion, upgradeTransaction) => {
      var _a;
      if (oldVersion < 2) {
        // Database too old, skip migration.
        return;
      }
      if (!db.objectStoreNames.contains(OLD_OBJECT_STORE_NAME)) {
        // Database did not exist. Nothing to do.
        return;
      }
      const objectStore = upgradeTransaction.objectStore(OLD_OBJECT_STORE_NAME);
      const value = await objectStore.index('fcmSenderId').get(senderId);
      await objectStore.clear();
      if (!value) {
        // No entry in the database, nothing to migrate.
        return;
      }
      if (oldVersion === 2) {
        const oldDetails = value;
        if (!oldDetails.auth || !oldDetails.p256dh || !oldDetails.endpoint) {
          return;
        }
        tokenDetails = {
          token: oldDetails.fcmToken,
          createTime: (_a = oldDetails.createTime) !== null && _a !== void 0 ? _a : Date.now(),
          subscriptionOptions: {
            auth: oldDetails.auth,
            p256dh: oldDetails.p256dh,
            endpoint: oldDetails.endpoint,
            swScope: oldDetails.swScope,
            vapidKey: typeof oldDetails.vapidKey === 'string' ? oldDetails.vapidKey : arrayToBase64(oldDetails.vapidKey)
          }
        };
      } else if (oldVersion === 3) {
        const oldDetails = value;
        tokenDetails = {
          token: oldDetails.fcmToken,
          createTime: oldDetails.createTime,
          subscriptionOptions: {
            auth: arrayToBase64(oldDetails.auth),
            p256dh: arrayToBase64(oldDetails.p256dh),
            endpoint: oldDetails.endpoint,
            swScope: oldDetails.swScope,
            vapidKey: arrayToBase64(oldDetails.vapidKey)
          }
        };
      } else if (oldVersion === 4) {
        const oldDetails = value;
        tokenDetails = {
          token: oldDetails.fcmToken,
          createTime: oldDetails.createTime,
          subscriptionOptions: {
            auth: arrayToBase64(oldDetails.auth),
            p256dh: arrayToBase64(oldDetails.p256dh),
            endpoint: oldDetails.endpoint,
            swScope: oldDetails.swScope,
            vapidKey: arrayToBase64(oldDetails.vapidKey)
          }
        };
      }
    }
  });
  db.close();
  // Delete all old databases.
  await idb.deleteDB(OLD_DB_NAME);
  await idb.deleteDB('fcm_vapid_details_db');
  await idb.deleteDB('undefined');
  return checkTokenDetails(tokenDetails) ? tokenDetails : null;
}
function checkTokenDetails(tokenDetails) {
  if (!tokenDetails || !tokenDetails.subscriptionOptions) {
    return false;
  }
  const {
    subscriptionOptions
  } = tokenDetails;
  return typeof tokenDetails.createTime === 'number' && tokenDetails.createTime > 0 && typeof tokenDetails.token === 'string' && tokenDetails.token.length > 0 && typeof subscriptionOptions.auth === 'string' && subscriptionOptions.auth.length > 0 && typeof subscriptionOptions.p256dh === 'string' && subscriptionOptions.p256dh.length > 0 && typeof subscriptionOptions.endpoint === 'string' && subscriptionOptions.endpoint.length > 0 && typeof subscriptionOptions.swScope === 'string' && subscriptionOptions.swScope.length > 0 && typeof subscriptionOptions.vapidKey === 'string' && subscriptionOptions.vapidKey.length > 0;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Exported for tests.
const DATABASE_NAME = 'firebase-messaging-database';
const DATABASE_VERSION = 1;
const OBJECT_STORE_NAME = 'firebase-messaging-store';
let dbPromise = null;
function getDbPromise() {
  if (!dbPromise) {
    dbPromise = idb.openDB(DATABASE_NAME, DATABASE_VERSION, {
      upgrade: (upgradeDb, oldVersion) => {
        // We don't use 'break' in this switch statement, the fall-through behavior is what we want,
        // because if there are multiple versions between the old version and the current version, we
        // want ALL the migrations that correspond to those versions to run, not only the last one.
        // eslint-disable-next-line default-case
        switch (oldVersion) {
          case 0:
            upgradeDb.createObjectStore(OBJECT_STORE_NAME);
        }
      }
    });
  }
  return dbPromise;
}
/** Gets record(s) from the objectStore that match the given key. */
async function dbGet(firebaseDependencies) {
  const key = getKey(firebaseDependencies);
  const db = await getDbPromise();
  const tokenDetails = await db.transaction(OBJECT_STORE_NAME).objectStore(OBJECT_STORE_NAME).get(key);
  if (tokenDetails) {
    return tokenDetails;
  } else {
    // Check if there is a tokenDetails object in the old DB.
    const oldTokenDetails = await migrateOldDatabase(firebaseDependencies.appConfig.senderId);
    if (oldTokenDetails) {
      await dbSet(firebaseDependencies, oldTokenDetails);
      return oldTokenDetails;
    }
  }
}
/** Assigns or overwrites the record for the given key with the given value. */
async function dbSet(firebaseDependencies, tokenDetails) {
  const key = getKey(firebaseDependencies);
  const db = await getDbPromise();
  const tx = db.transaction(OBJECT_STORE_NAME, 'readwrite');
  await tx.objectStore(OBJECT_STORE_NAME).put(tokenDetails, key);
  await tx.done;
  return tokenDetails;
}
/** Removes record(s) from the objectStore that match the given key. */
async function dbRemove(firebaseDependencies) {
  const key = getKey(firebaseDependencies);
  const db = await getDbPromise();
  const tx = db.transaction(OBJECT_STORE_NAME, 'readwrite');
  await tx.objectStore(OBJECT_STORE_NAME).delete(key);
  await tx.done;
}
function getKey({
  appConfig
}) {
  return appConfig.appId;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const ERROR_MAP = {
  ["missing-app-config-values" /* ErrorCode.MISSING_APP_CONFIG_VALUES */]: 'Missing App configuration value: "{$valueName}"',
  ["only-available-in-window" /* ErrorCode.AVAILABLE_IN_WINDOW */]: 'This method is available in a Window context.',
  ["only-available-in-sw" /* ErrorCode.AVAILABLE_IN_SW */]: 'This method is available in a service worker context.',
  ["permission-default" /* ErrorCode.PERMISSION_DEFAULT */]: 'The notification permission was not granted and dismissed instead.',
  ["permission-blocked" /* ErrorCode.PERMISSION_BLOCKED */]: 'The notification permission was not granted and blocked instead.',
  ["unsupported-browser" /* ErrorCode.UNSUPPORTED_BROWSER */]: "This browser doesn't support the API's required to use the Firebase SDK.",
  ["indexed-db-unsupported" /* ErrorCode.INDEXED_DB_UNSUPPORTED */]: "This browser doesn't support indexedDb.open() (ex. Safari iFrame, Firefox Private Browsing, etc)",
  ["failed-service-worker-registration" /* ErrorCode.FAILED_DEFAULT_REGISTRATION */]: 'We are unable to register the default service worker. {$browserErrorMessage}',
  ["token-subscribe-failed" /* ErrorCode.TOKEN_SUBSCRIBE_FAILED */]: 'A problem occurred while subscribing the user to FCM: {$errorInfo}',
  ["token-subscribe-no-token" /* ErrorCode.TOKEN_SUBSCRIBE_NO_TOKEN */]: 'FCM returned no token when subscribing the user to push.',
  ["token-unsubscribe-failed" /* ErrorCode.TOKEN_UNSUBSCRIBE_FAILED */]: 'A problem occurred while unsubscribing the ' + 'user from FCM: {$errorInfo}',
  ["token-update-failed" /* ErrorCode.TOKEN_UPDATE_FAILED */]: 'A problem occurred while updating the user from FCM: {$errorInfo}',
  ["token-update-no-token" /* ErrorCode.TOKEN_UPDATE_NO_TOKEN */]: 'FCM returned no token when updating the user to push.',
  ["use-sw-after-get-token" /* ErrorCode.USE_SW_AFTER_GET_TOKEN */]: 'The useServiceWorker() method may only be called once and must be ' + 'called before calling getToken() to ensure your service worker is used.',
  ["invalid-sw-registration" /* ErrorCode.INVALID_SW_REGISTRATION */]: 'The input to useServiceWorker() must be a ServiceWorkerRegistration.',
  ["invalid-bg-handler" /* ErrorCode.INVALID_BG_HANDLER */]: 'The input to setBackgroundMessageHandler() must be a function.',
  ["invalid-vapid-key" /* ErrorCode.INVALID_VAPID_KEY */]: 'The public VAPID key must be a string.',
  ["use-vapid-key-after-get-token" /* ErrorCode.USE_VAPID_KEY_AFTER_GET_TOKEN */]: 'The usePublicVapidKey() method may only be called once and must be ' + 'called before calling getToken() to ensure your VAPID key is used.'
};
const ERROR_FACTORY = new util.ErrorFactory('messaging', 'Messaging', ERROR_MAP);

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
async function requestGetToken(firebaseDependencies, subscriptionOptions) {
  const headers = await getHeaders(firebaseDependencies);
  const body = getBody(subscriptionOptions);
  const subscribeOptions = {
    method: 'POST',
    headers,
    body: JSON.stringify(body)
  };
  let responseData;
  try {
    const response = await fetch(getEndpoint(firebaseDependencies.appConfig), subscribeOptions);
    responseData = await response.json();
  } catch (err) {
    throw ERROR_FACTORY.create("token-subscribe-failed" /* ErrorCode.TOKEN_SUBSCRIBE_FAILED */, {
      errorInfo: err === null || err === void 0 ? void 0 : err.toString()
    });
  }
  if (responseData.error) {
    const message = responseData.error.message;
    throw ERROR_FACTORY.create("token-subscribe-failed" /* ErrorCode.TOKEN_SUBSCRIBE_FAILED */, {
      errorInfo: message
    });
  }
  if (!responseData.token) {
    throw ERROR_FACTORY.create("token-subscribe-no-token" /* ErrorCode.TOKEN_SUBSCRIBE_NO_TOKEN */);
  }
  return responseData.token;
}
async function requestUpdateToken(firebaseDependencies, tokenDetails) {
  const headers = await getHeaders(firebaseDependencies);
  const body = getBody(tokenDetails.subscriptionOptions);
  const updateOptions = {
    method: 'PATCH',
    headers,
    body: JSON.stringify(body)
  };
  let responseData;
  try {
    const response = await fetch(`${getEndpoint(firebaseDependencies.appConfig)}/${tokenDetails.token}`, updateOptions);
    responseData = await response.json();
  } catch (err) {
    throw ERROR_FACTORY.create("token-update-failed" /* ErrorCode.TOKEN_UPDATE_FAILED */, {
      errorInfo: err === null || err === void 0 ? void 0 : err.toString()
    });
  }
  if (responseData.error) {
    const message = responseData.error.message;
    throw ERROR_FACTORY.create("token-update-failed" /* ErrorCode.TOKEN_UPDATE_FAILED */, {
      errorInfo: message
    });
  }
  if (!responseData.token) {
    throw ERROR_FACTORY.create("token-update-no-token" /* ErrorCode.TOKEN_UPDATE_NO_TOKEN */);
  }
  return responseData.token;
}
async function requestDeleteToken(firebaseDependencies, token) {
  const headers = await getHeaders(firebaseDependencies);
  const unsubscribeOptions = {
    method: 'DELETE',
    headers
  };
  try {
    const response = await fetch(`${getEndpoint(firebaseDependencies.appConfig)}/${token}`, unsubscribeOptions);
    const responseData = await response.json();
    if (responseData.error) {
      const message = responseData.error.message;
      throw ERROR_FACTORY.create("token-unsubscribe-failed" /* ErrorCode.TOKEN_UNSUBSCRIBE_FAILED */, {
        errorInfo: message
      });
    }
  } catch (err) {
    throw ERROR_FACTORY.create("token-unsubscribe-failed" /* ErrorCode.TOKEN_UNSUBSCRIBE_FAILED */, {
      errorInfo: err === null || err === void 0 ? void 0 : err.toString()
    });
  }
}
function getEndpoint({
  projectId
}) {
  return `${ENDPOINT}/projects/${projectId}/registrations`;
}
async function getHeaders({
  appConfig,
  installations
}) {
  const authToken = await installations.getToken();
  return new Headers({
    'Content-Type': 'application/json',
    Accept: 'application/json',
    'x-goog-api-key': appConfig.apiKey,
    'x-goog-firebase-installations-auth': `FIS ${authToken}`
  });
}
function getBody({
  p256dh,
  auth,
  endpoint,
  vapidKey
}) {
  const body = {
    web: {
      endpoint,
      auth,
      p256dh
    }
  };
  if (vapidKey !== DEFAULT_VAPID_KEY) {
    body.web.applicationPubKey = vapidKey;
  }
  return body;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// UpdateRegistration will be called once every week.
const TOKEN_EXPIRATION_MS = 7 * 24 * 60 * 60 * 1000; // 7 days
async function getTokenInternal(messaging) {
  const pushSubscription = await getPushSubscription(messaging.swRegistration, messaging.vapidKey);
  const subscriptionOptions = {
    vapidKey: messaging.vapidKey,
    swScope: messaging.swRegistration.scope,
    endpoint: pushSubscription.endpoint,
    auth: arrayToBase64(pushSubscription.getKey('auth')),
    p256dh: arrayToBase64(pushSubscription.getKey('p256dh'))
  };
  const tokenDetails = await dbGet(messaging.firebaseDependencies);
  if (!tokenDetails) {
    // No token, get a new one.
    return getNewToken(messaging.firebaseDependencies, subscriptionOptions);
  } else if (!isTokenValid(tokenDetails.subscriptionOptions, subscriptionOptions)) {
    // Invalid token, get a new one.
    try {
      await requestDeleteToken(messaging.firebaseDependencies, tokenDetails.token);
    } catch (e) {
      // Suppress errors because of #2364
      console.warn(e);
    }
    return getNewToken(messaging.firebaseDependencies, subscriptionOptions);
  } else if (Date.now() >= tokenDetails.createTime + TOKEN_EXPIRATION_MS) {
    // Weekly token refresh
    return updateToken(messaging, {
      token: tokenDetails.token,
      createTime: Date.now(),
      subscriptionOptions
    });
  } else {
    // Valid token, nothing to do.
    return tokenDetails.token;
  }
}
/**
 * This method deletes the token from the database, unsubscribes the token from FCM, and unregisters
 * the push subscription if it exists.
 */
async function deleteTokenInternal(messaging) {
  const tokenDetails = await dbGet(messaging.firebaseDependencies);
  if (tokenDetails) {
    await requestDeleteToken(messaging.firebaseDependencies, tokenDetails.token);
    await dbRemove(messaging.firebaseDependencies);
  }
  // Unsubscribe from the push subscription.
  const pushSubscription = await messaging.swRegistration.pushManager.getSubscription();
  if (pushSubscription) {
    return pushSubscription.unsubscribe();
  }
  // If there's no SW, consider it a success.
  return true;
}
async function updateToken(messaging, tokenDetails) {
  try {
    const updatedToken = await requestUpdateToken(messaging.firebaseDependencies, tokenDetails);
    const updatedTokenDetails = Object.assign(Object.assign({}, tokenDetails), {
      token: updatedToken,
      createTime: Date.now()
    });
    await dbSet(messaging.firebaseDependencies, updatedTokenDetails);
    return updatedToken;
  } catch (e) {
    throw e;
  }
}
async function getNewToken(firebaseDependencies, subscriptionOptions) {
  const token = await requestGetToken(firebaseDependencies, subscriptionOptions);
  const tokenDetails = {
    token,
    createTime: Date.now(),
    subscriptionOptions
  };
  await dbSet(firebaseDependencies, tokenDetails);
  return tokenDetails.token;
}
/**
 * Gets a PushSubscription for the current user.
 */
async function getPushSubscription(swRegistration, vapidKey) {
  const subscription = await swRegistration.pushManager.getSubscription();
  if (subscription) {
    return subscription;
  }
  return swRegistration.pushManager.subscribe({
    userVisibleOnly: true,
    // Chrome <= 75 doesn't support base64-encoded VAPID key. For backward compatibility, VAPID key
    // submitted to pushManager#subscribe must be of type Uint8Array.
    applicationServerKey: base64ToArray(vapidKey)
  });
}
/**
 * Checks if the saved tokenDetails object matches the configuration provided.
 */
function isTokenValid(dbOptions, currentOptions) {
  const isVapidKeyEqual = currentOptions.vapidKey === dbOptions.vapidKey;
  const isEndpointEqual = currentOptions.endpoint === dbOptions.endpoint;
  const isAuthEqual = currentOptions.auth === dbOptions.auth;
  const isP256dhEqual = currentOptions.p256dh === dbOptions.p256dh;
  return isVapidKeyEqual && isEndpointEqual && isAuthEqual && isP256dhEqual;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function externalizePayload(internalPayload) {
  const payload = {
    from: internalPayload.from,
    // eslint-disable-next-line camelcase
    collapseKey: internalPayload.collapse_key,
    // eslint-disable-next-line camelcase
    messageId: internalPayload.fcmMessageId
  };
  propagateNotificationPayload(payload, internalPayload);
  propagateDataPayload(payload, internalPayload);
  propagateFcmOptions(payload, internalPayload);
  return payload;
}
function propagateNotificationPayload(payload, messagePayloadInternal) {
  if (!messagePayloadInternal.notification) {
    return;
  }
  payload.notification = {};
  const title = messagePayloadInternal.notification.title;
  if (!!title) {
    payload.notification.title = title;
  }
  const body = messagePayloadInternal.notification.body;
  if (!!body) {
    payload.notification.body = body;
  }
  const image = messagePayloadInternal.notification.image;
  if (!!image) {
    payload.notification.image = image;
  }
  const icon = messagePayloadInternal.notification.icon;
  if (!!icon) {
    payload.notification.icon = icon;
  }
}
function propagateDataPayload(payload, messagePayloadInternal) {
  if (!messagePayloadInternal.data) {
    return;
  }
  payload.data = messagePayloadInternal.data;
}
function propagateFcmOptions(payload, messagePayloadInternal) {
  var _a, _b, _c, _d, _e;
  // fcmOptions.link value is written into notification.click_action. see more in b/232072111
  if (!messagePayloadInternal.fcmOptions && !((_a = messagePayloadInternal.notification) === null || _a === void 0 ? void 0 : _a.click_action)) {
    return;
  }
  payload.fcmOptions = {};
  const link = (_c = (_b = messagePayloadInternal.fcmOptions) === null || _b === void 0 ? void 0 : _b.link) !== null && _c !== void 0 ? _c : (_d = messagePayloadInternal.notification) === null || _d === void 0 ? void 0 : _d.click_action;
  if (!!link) {
    payload.fcmOptions.link = link;
  }
  // eslint-disable-next-line camelcase
  const analyticsLabel = (_e = messagePayloadInternal.fcmOptions) === null || _e === void 0 ? void 0 : _e.analytics_label;
  if (!!analyticsLabel) {
    payload.fcmOptions.analyticsLabel = analyticsLabel;
  }
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function isConsoleMessage(data) {
  // This message has a campaign ID, meaning it was sent using the Firebase Console.
  return typeof data === 'object' && !!data && CONSOLE_CAMPAIGN_ID in data;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Returns a promise that resolves after given time passes. */
function sleep(ms) {
  return new Promise(resolve => {
    setTimeout(resolve, ms);
  });
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
_mergeStrings('AzSCbw63g1R0nCw85jG8', 'Iaya3yLKwmgvh7cF0q4');
async function stageLog(messaging, internalPayload) {
  const fcmEvent = createFcmEvent(internalPayload, await messaging.firebaseDependencies.installations.getId());
  createAndEnqueueLogEvent(messaging, fcmEvent, internalPayload.productId);
}
function createFcmEvent(internalPayload, fid) {
  var _a, _b;
  const fcmEvent = {};
  /* eslint-disable camelcase */
  // some fields should always be non-null. Still check to ensure.
  if (!!internalPayload.from) {
    fcmEvent.project_number = internalPayload.from;
  }
  if (!!internalPayload.fcmMessageId) {
    fcmEvent.message_id = internalPayload.fcmMessageId;
  }
  fcmEvent.instance_id = fid;
  if (!!internalPayload.notification) {
    fcmEvent.message_type = MessageType$1.DISPLAY_NOTIFICATION.toString();
  } else {
    fcmEvent.message_type = MessageType$1.DATA_MESSAGE.toString();
  }
  fcmEvent.sdk_platform = SDK_PLATFORM_WEB.toString();
  fcmEvent.package_name = self.origin.replace(/(^\w+:|^)\/\//, '');
  if (!!internalPayload.collapse_key) {
    fcmEvent.collapse_key = internalPayload.collapse_key;
  }
  fcmEvent.event = EVENT_MESSAGE_DELIVERED.toString();
  if (!!((_a = internalPayload.fcmOptions) === null || _a === void 0 ? void 0 : _a.analytics_label)) {
    fcmEvent.analytics_label = (_b = internalPayload.fcmOptions) === null || _b === void 0 ? void 0 : _b.analytics_label;
  }
  /* eslint-enable camelcase */
  return fcmEvent;
}
function createAndEnqueueLogEvent(messaging, fcmEvent, productId) {
  const logEvent = {};
  /* eslint-disable camelcase */
  logEvent.event_time_ms = Math.floor(Date.now()).toString();
  logEvent.source_extension_json_proto3 = JSON.stringify({
    messaging_client_event: fcmEvent
  });
  if (!!productId) {
    logEvent.compliance_data = buildComplianceData(productId);
  }
  // eslint-disable-next-line camelcase
  messaging.logEvents.push(logEvent);
}
function buildComplianceData(productId) {
  const complianceData = {
    privacy_context: {
      prequest: {
        origin_associated_product_id: productId
      }
    }
  };
  return complianceData;
}
function _mergeStrings(s1, s2) {
  const resultArray = [];
  for (let i = 0; i < s1.length; i++) {
    resultArray.push(s1.charAt(i));
    if (i < s2.length) {
      resultArray.push(s2.charAt(i));
    }
  }
  return resultArray.join('');
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
async function onSubChange(event, messaging) {
  var _a, _b;
  const {
    newSubscription
  } = event;
  if (!newSubscription) {
    // Subscription revoked, delete token
    await deleteTokenInternal(messaging);
    return;
  }
  const tokenDetails = await dbGet(messaging.firebaseDependencies);
  await deleteTokenInternal(messaging);
  messaging.vapidKey = (_b = (_a = tokenDetails === null || tokenDetails === void 0 ? void 0 : tokenDetails.subscriptionOptions) === null || _a === void 0 ? void 0 : _a.vapidKey) !== null && _b !== void 0 ? _b : DEFAULT_VAPID_KEY;
  await getTokenInternal(messaging);
}
async function onPush(event, messaging) {
  const internalPayload = getMessagePayloadInternal(event);
  if (!internalPayload) {
    // Failed to get parsed MessagePayload from the PushEvent. Skip handling the push.
    return;
  }
  // log to Firelog with user consent
  if (messaging.deliveryMetricsExportedToBigQueryEnabled) {
    await stageLog(messaging, internalPayload);
  }
  // foreground handling: eventually passed to onMessage hook
  const clientList = await getClientList();
  if (hasVisibleClients(clientList)) {
    return sendMessagePayloadInternalToWindows(clientList, internalPayload);
  }
  // background handling: display if possible and pass to onBackgroundMessage hook
  if (!!internalPayload.notification) {
    await showNotification(wrapInternalPayload(internalPayload));
  }
  if (!messaging) {
    return;
  }
  if (!!messaging.onBackgroundMessageHandler) {
    const payload = externalizePayload(internalPayload);
    if (typeof messaging.onBackgroundMessageHandler === 'function') {
      await messaging.onBackgroundMessageHandler(payload);
    } else {
      messaging.onBackgroundMessageHandler.next(payload);
    }
  }
}
async function onNotificationClick(event) {
  var _a, _b;
  const internalPayload = (_b = (_a = event.notification) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b[FCM_MSG];
  if (!internalPayload) {
    return;
  } else if (event.action) {
    // User clicked on an action button. This will allow developers to act on action button clicks
    // by using a custom onNotificationClick listener that they define.
    return;
  }
  // Prevent other listeners from receiving the event
  event.stopImmediatePropagation();
  event.notification.close();
  // Note clicking on a notification with no link set will focus the Chrome's current tab.
  const link = getLink(internalPayload);
  if (!link) {
    return;
  }
  // FM should only open/focus links from app's origin.
  const url = new URL(link, self.location.href);
  const originUrl = new URL(self.location.origin);
  if (url.host !== originUrl.host) {
    return;
  }
  let client = await getWindowClient(url);
  if (!client) {
    client = await self.clients.openWindow(link);
    // Wait three seconds for the client to initialize and set up the message handler so that it
    // can receive the message.
    await sleep(3000);
  } else {
    client = await client.focus();
  }
  if (!client) {
    // Window Client will not be returned if it's for a third party origin.
    return;
  }
  internalPayload.messageType = MessageType.NOTIFICATION_CLICKED;
  internalPayload.isFirebaseMessaging = true;
  return client.postMessage(internalPayload);
}
function wrapInternalPayload(internalPayload) {
  const wrappedInternalPayload = Object.assign({}, internalPayload.notification);
  // Put the message payload under FCM_MSG name so we can identify the notification as being an FCM
  // notification vs a notification from somewhere else (i.e. normal web push or developer generated
  // notification).
  wrappedInternalPayload.data = {
    [FCM_MSG]: internalPayload
  };
  return wrappedInternalPayload;
}
function getMessagePayloadInternal({
  data
}) {
  if (!data) {
    return null;
  }
  try {
    return data.json();
  } catch (err) {
    // Not JSON so not an FCM message.
    return null;
  }
}
/**
 * @param url The URL to look for when focusing a client.
 * @return Returns an existing window client or a newly opened WindowClient.
 */
async function getWindowClient(url) {
  const clientList = await getClientList();
  for (const client of clientList) {
    const clientUrl = new URL(client.url, self.location.href);
    if (url.host === clientUrl.host) {
      return client;
    }
  }
  return null;
}
/**
 * @returns If there is currently a visible WindowClient, this method will resolve to true,
 * otherwise false.
 */
function hasVisibleClients(clientList) {
  return clientList.some(client => client.visibilityState === 'visible' &&
  // Ignore chrome-extension clients as that matches the background pages of extensions, which
  // are always considered visible for some reason.
  !client.url.startsWith('chrome-extension://'));
}
function sendMessagePayloadInternalToWindows(clientList, internalPayload) {
  internalPayload.isFirebaseMessaging = true;
  internalPayload.messageType = MessageType.PUSH_RECEIVED;
  for (const client of clientList) {
    client.postMessage(internalPayload);
  }
}
function getClientList() {
  return self.clients.matchAll({
    type: 'window',
    includeUncontrolled: true
    // TS doesn't know that "type: 'window'" means it'll return WindowClient[]
  });
}
function showNotification(notificationPayloadInternal) {
  var _a;
  // Note: Firefox does not support the maxActions property.
  // https://developer.mozilla.org/en-US/docs/Web/API/notification/maxActions
  const {
    actions
  } = notificationPayloadInternal;
  const {
    maxActions
  } = Notification;
  if (actions && maxActions && actions.length > maxActions) {
    console.warn(`This browser only supports ${maxActions} actions. The remaining actions will not be displayed.`);
  }
  return self.registration.showNotification(/* title= */(_a = notificationPayloadInternal.title) !== null && _a !== void 0 ? _a : '', notificationPayloadInternal);
}
function getLink(payload) {
  var _a, _b, _c;
  // eslint-disable-next-line camelcase
  const link = (_b = (_a = payload.fcmOptions) === null || _a === void 0 ? void 0 : _a.link) !== null && _b !== void 0 ? _b : (_c = payload.notification) === null || _c === void 0 ? void 0 : _c.click_action;
  if (link) {
    return link;
  }
  if (isConsoleMessage(payload.data)) {
    // Notification created in the Firebase Console. Redirect to origin.
    return self.location.origin;
  } else {
    return null;
  }
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function extractAppConfig(app) {
  if (!app || !app.options) {
    throw getMissingValueError('App Configuration Object');
  }
  if (!app.name) {
    throw getMissingValueError('App Name');
  }
  // Required app config keys
  const configKeys = ['projectId', 'apiKey', 'appId', 'messagingSenderId'];
  const {
    options
  } = app;
  for (const keyName of configKeys) {
    if (!options[keyName]) {
      throw getMissingValueError(keyName);
    }
  }
  return {
    appName: app.name,
    projectId: options.projectId,
    apiKey: options.apiKey,
    appId: options.appId,
    senderId: options.messagingSenderId
  };
}
function getMissingValueError(valueName) {
  return ERROR_FACTORY.create("missing-app-config-values" /* ErrorCode.MISSING_APP_CONFIG_VALUES */, {
    valueName
  });
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class MessagingService {
  constructor(app, installations, analyticsProvider) {
    // logging is only done with end user consent. Default to false.
    this.deliveryMetricsExportedToBigQueryEnabled = false;
    this.onBackgroundMessageHandler = null;
    this.onMessageHandler = null;
    this.logEvents = [];
    this.isLogServiceStarted = false;
    const appConfig = extractAppConfig(app);
    this.firebaseDependencies = {
      app,
      appConfig,
      installations,
      analyticsProvider
    };
  }
  _delete() {
    return Promise.resolve();
  }
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const SwMessagingFactory = container => {
  const messaging = new MessagingService(container.getProvider('app').getImmediate(), container.getProvider('installations-internal').getImmediate(), container.getProvider('analytics-internal'));
  self.addEventListener('push', e => {
    e.waitUntil(onPush(e, messaging));
  });
  self.addEventListener('pushsubscriptionchange', e => {
    e.waitUntil(onSubChange(e, messaging));
  });
  self.addEventListener('notificationclick', e => {
    e.waitUntil(onNotificationClick(e));
  });
  return messaging;
};
/**
 * The messaging instance registered in sw is named differently than that of in client. This is
 * because both `registerMessagingInWindow` and `registerMessagingInSw` would be called in
 * `messaging-compat` and component with the same name can only be registered once.
 */
function registerMessagingInSw() {
  app._registerComponent(new component.Component('messaging-sw', SwMessagingFactory, "PUBLIC" /* ComponentType.PUBLIC */));
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Checks whether all required APIs exist within SW Context
 * @returns a Promise that resolves to a boolean.
 *
 * @public
 */
async function isSwSupported() {
  // firebase-js-sdk/issues/2393 reveals that idb#open in Safari iframe and Firefox private browsing
  // might be prohibited to run. In these contexts, an error would be thrown during the messaging
  // instantiating phase, informing the developers to import/call isSupported for special handling.
  return util.isIndexedDBAvailable() && (await util.validateIndexedDBOpenable()) && 'PushManager' in self && 'Notification' in self && ServiceWorkerRegistration.prototype.hasOwnProperty('showNotification') && PushSubscription.prototype.hasOwnProperty('getKey');
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function onBackgroundMessage$1(messaging, nextOrObserver) {
  if (self.document !== undefined) {
    throw ERROR_FACTORY.create("only-available-in-sw" /* ErrorCode.AVAILABLE_IN_SW */);
  }
  messaging.onBackgroundMessageHandler = nextOrObserver;
  return () => {
    messaging.onBackgroundMessageHandler = null;
  };
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function _setDeliveryMetricsExportedToBigQueryEnabled(messaging, enable) {
  messaging.deliveryMetricsExportedToBigQueryEnabled = enable;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Retrieves a Firebase Cloud Messaging instance.
 *
 * @returns The Firebase Cloud Messaging instance associated with the provided firebase app.
 *
 * @public
 */
function getMessagingInSw(app$1 = app.getApp()) {
  // Conscious decision to make this async check non-blocking during the messaging instance
  // initialization phase for performance consideration. An error would be thrown latter for
  // developer's information. Developers can then choose to import and call `isSupported` for
  // special handling.
  isSwSupported().then(isSupported => {
    // If `isSwSupported()` resolved, but returned false.
    if (!isSupported) {
      throw ERROR_FACTORY.create("unsupported-browser" /* ErrorCode.UNSUPPORTED_BROWSER */);
    }
  }, _ => {
    // If `isSwSupported()` rejected.
    throw ERROR_FACTORY.create("indexed-db-unsupported" /* ErrorCode.INDEXED_DB_UNSUPPORTED */);
  });
  return app._getProvider(util.getModularInstance(app$1), 'messaging-sw').getImmediate();
}
/**
 * Called when a message is received while the app is in the background. An app is considered to be
 * in the background if no active window is displayed.
 *
 * @param messaging - The {@link Messaging} instance.
 * @param nextOrObserver - This function, or observer object with `next` defined, is called when a
 * message is received and the app is currently in the background.
 *
 * @returns To stop listening for messages execute this returned function
 *
 * @public
 */
function onBackgroundMessage(messaging, nextOrObserver) {
  messaging = util.getModularInstance(messaging);
  return onBackgroundMessage$1(messaging, nextOrObserver);
}
/**
 * Enables or disables Firebase Cloud Messaging message delivery metrics export to BigQuery. By
 * default, message delivery metrics are not exported to BigQuery. Use this method to enable or
 * disable the export at runtime.
 *
 * @param messaging - The `FirebaseMessaging` instance.
 * @param enable - Whether Firebase Cloud Messaging should export message delivery metrics to
 * BigQuery.
 *
 * @public
 */
function experimentalSetDeliveryMetricsExportedToBigQueryEnabled(messaging, enable) {
  messaging = util.getModularInstance(messaging);
  return _setDeliveryMetricsExportedToBigQueryEnabled(messaging, enable);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
registerMessagingInSw();
exports.experimentalSetDeliveryMetricsExportedToBigQueryEnabled = experimentalSetDeliveryMetricsExportedToBigQueryEnabled;
exports.getMessaging = getMessagingInSw;
exports.isSupported = isSwSupported;
exports.onBackgroundMessage = onBackgroundMessage;

      };
    };
  }
  }
}, {package:"@metamask/notification-services-controller>firebase>@firebase/messaging",file:"node_modules\\@firebase\\messaging\\dist\\index.sw.cjs",}]],[],{})

//# sourceMappingURL=data:application/json;charset=utf8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTI3LnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xMjgudHMiLCJhcHAvc2NyaXB0cy9taWdyYXRpb25zLzEyOS50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTMwLnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xMzEuMS50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTMxLnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xMzIudHMiLCJhcHAvc2NyaXB0cy9taWdyYXRpb25zLzEzMy4xLnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xMzMuMi50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTMzLnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xMzQuMS50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTM0LnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xMzUudHMiLCJhcHAvc2NyaXB0cy9taWdyYXRpb25zLzEzNi50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTM3LnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xMzgudHMiLCJhcHAvc2NyaXB0cy9taWdyYXRpb25zLzEzOS50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTQwLnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xNDEudHMiLCJhcHAvc2NyaXB0cy9taWdyYXRpb25zLzE0Mi50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTQzLjEudHMiLCJhcHAvc2NyaXB0cy9taWdyYXRpb25zLzE0My50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTQ0LnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xNDUudHMiLCJhcHAvc2NyaXB0cy9taWdyYXRpb25zLzE0Ni4xLnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xNDYudHMiLCJhcHAvc2NyaXB0cy9taWdyYXRpb25zLzE0Ny50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTQ4LnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xNDkudHMiLCJhcHAvc2NyaXB0cy9taWdyYXRpb25zLzE1MC50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTUxLnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xNTIuMS50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTUyLjIudHMiLCJhcHAvc2NyaXB0cy9taWdyYXRpb25zLzE1Mi50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTUzLnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xNTQudHMiLCJhcHAvc2NyaXB0cy9taWdyYXRpb25zLzE1NS50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTU2LjEudHMiLCJhcHAvc2NyaXB0cy9taWdyYXRpb25zLzE1Ni50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTU3LnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xNTgudHMiLCJhcHAvc2NyaXB0cy9taWdyYXRpb25zLzE1OS50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTYwLnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xNjEuMS50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTYxLnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xNjIudHMiLCJhcHAvc2NyaXB0cy9taWdyYXRpb25zLzE2My50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTY0LnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xNjUudHMiLCJhcHAvc2NyaXB0cy9taWdyYXRpb25zLzE2Ni50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTY3LnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xNjguMS50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTY4LnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xNjkudHMiLCJhcHAvc2NyaXB0cy9taWdyYXRpb25zLzE3MC4xLnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xNzAuMi50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTcwLnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xNzEudHMiLCJhcHAvc2NyaXB0cy9taWdyYXRpb25zLzE3Mi50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTczLnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xNzQudHMiLCJhcHAvc2NyaXB0cy9taWdyYXRpb25zLzE3NS50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTc2LjEudHMiLCJhcHAvc2NyaXB0cy9taWdyYXRpb25zLzE3Ni50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTc3LnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xNzgudHMiLCJhcHAvc2NyaXB0cy9taWdyYXRpb25zLzE3OS50cyIsImFwcC9zY3JpcHRzL21pZ3JhdGlvbnMvMTgwLnRzIiwiYXBwL3NjcmlwdHMvbWlncmF0aW9ucy8xODEudHMiLCJhcHAvc2NyaXB0cy9taWdyYXRpb25zL2ZhaWwtdHguanMiLCJhcHAvc2NyaXB0cy9taWdyYXRpb25zL2luZGV4LmpzIiwiYXBwL3NjcmlwdHMvb2Zmc2NyZWVuLmpzIiwiYXBwL3NjcmlwdHMvc2VydmljZXMvZGF0YS1kZWxldGlvbi1zZXJ2aWNlLnRzIiwiYXBwL3NjcmlwdHMvc2VydmljZXMvb2F1dGgvYXBwbGUtbG9naW4taGFuZGxlci50cyIsImFwcC9zY3JpcHRzL3NlcnZpY2VzL29hdXRoL2Jhc2UtbG9naW4taGFuZGxlci50cyIsImFwcC9zY3JpcHRzL3NlcnZpY2VzL29hdXRoL2NvbmZpZy50cyIsImFwcC9zY3JpcHRzL3NlcnZpY2VzL29hdXRoL2NyZWF0ZS1sb2dpbi1oYW5kbGVyLnRzIiwiYXBwL3NjcmlwdHMvc2VydmljZXMvb2F1dGgvZ29vZ2xlLWxvZ2luLWhhbmRsZXIudHMiLCJhcHAvc2NyaXB0cy9zZXJ2aWNlcy9vYXV0aC9vYXV0aC1zZXJ2aWNlLnRzIiwiYXBwL3NjcmlwdHMvc2VydmljZXMvb2F1dGgvdHlwZXMudHMiLCJhcHAvc2NyaXB0cy9zZXJ2aWNlcy9vYXV0aC91dGlscy50cyIsImFwcC9zY3JpcHRzL3NlcnZpY2VzL29hdXRoL3dlYi1hdXRoZW50aWNhdG9yLWZhY3RvcnkudHMiLCJhcHAvc2NyaXB0cy9zZXJ2aWNlcy9zdWJzY3JpcHRpb24vc3Vic2NyaXB0aW9uLXNlcnZpY2UudHMiLCJhcHAvc2NyaXB0cy9zZXJ2aWNlcy9zdWJzY3JpcHRpb24vdHlwZXMudHMiLCJub2RlX21vZHVsZXMvQGVuc2RvbWFpbnMvY29udGVudC1oYXNoL25vZGVfbW9kdWxlcy9tdWx0aWJhc2Uvc3JjL2Jhc2UuanMiLCJub2RlX21vZHVsZXMvQGVuc2RvbWFpbnMvY29udGVudC1oYXNoL25vZGVfbW9kdWxlcy9tdWx0aWJhc2Uvc3JjL2NvbnN0YW50cy5qcyIsIm5vZGVfbW9kdWxlcy9AZW5zZG9tYWlucy9jb250ZW50LWhhc2gvbm9kZV9tb2R1bGVzL211bHRpYmFzZS9zcmMvaW5kZXguanMiLCJub2RlX21vZHVsZXMvQGVuc2RvbWFpbnMvY29udGVudC1oYXNoL25vZGVfbW9kdWxlcy9tdWx0aWJhc2Uvc3JjL3JmYzQ2NDguanMiLCJub2RlX21vZHVsZXMvQGVuc2RvbWFpbnMvY29udGVudC1oYXNoL25vZGVfbW9kdWxlcy9tdWx0aWJhc2Uvc3JjL3V0aWwuanMiLCJub2RlX21vZHVsZXMvQGVuc2RvbWFpbnMvY29udGVudC1oYXNoL25vZGVfbW9kdWxlcy9tdWx0aWhhc2hlcy9zcmMvY29uc3RhbnRzLmpzIiwibm9kZV9tb2R1bGVzL0BlbnNkb21haW5zL2NvbnRlbnQtaGFzaC9ub2RlX21vZHVsZXMvbXVsdGloYXNoZXMvc3JjL2luZGV4LmpzIiwibm9kZV9tb2R1bGVzL0BlbnNkb21haW5zL2NvbnRlbnQtaGFzaC9ub2RlX21vZHVsZXMvdmFyaW50L2RlY29kZS5qcyIsIm5vZGVfbW9kdWxlcy9AZW5zZG9tYWlucy9jb250ZW50LWhhc2gvbm9kZV9tb2R1bGVzL3ZhcmludC9lbmNvZGUuanMiLCJub2RlX21vZHVsZXMvQGVuc2RvbWFpbnMvY29udGVudC1oYXNoL25vZGVfbW9kdWxlcy92YXJpbnQvaW5kZXguanMiLCJub2RlX21vZHVsZXMvQGVuc2RvbWFpbnMvY29udGVudC1oYXNoL25vZGVfbW9kdWxlcy92YXJpbnQvbGVuZ3RoLmpzIiwibm9kZV9tb2R1bGVzL0BlbnNkb21haW5zL2NvbnRlbnQtaGFzaC9zcmMvaGVscGVycy5qcyIsIm5vZGVfbW9kdWxlcy9AZW5zZG9tYWlucy9jb250ZW50LWhhc2gvc3JjL2luZGV4LmpzIiwibm9kZV9tb2R1bGVzL0BlbnNkb21haW5zL2NvbnRlbnQtaGFzaC9zcmMvcHJvZmlsZXMuanMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL2FwcC9zcmMvcGxhdGZvcm1Mb2dnZXJTZXJ2aWNlLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9hcHAvc3JjL2xvZ2dlci50cyIsIm5vZGVfbW9kdWxlcy9AZmlyZWJhc2UvYXBwL3NyYy9jb25zdGFudHMudHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL2FwcC9zcmMvaW50ZXJuYWwudHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL2FwcC9zcmMvZXJyb3JzLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9hcHAvc3JjL2ZpcmViYXNlQXBwLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9hcHAvc3JjL2ZpcmViYXNlU2VydmVyQXBwLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9hcHAvc3JjL2FwaS50cyIsIm5vZGVfbW9kdWxlcy9AZmlyZWJhc2UvYXBwL3NyYy9pbmRleGVkZGIudHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL2FwcC9zcmMvaGVhcnRiZWF0U2VydmljZS50cyIsIm5vZGVfbW9kdWxlcy9AZmlyZWJhc2UvYXBwL3NyYy9yZWdpc3RlckNvcmVDb21wb25lbnRzLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9hcHAvc3JjL2luZGV4LnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9jb21wb25lbnQvc3JjL2NvbXBvbmVudC50cyIsIm5vZGVfbW9kdWxlcy9AZmlyZWJhc2UvY29tcG9uZW50L3NyYy9jb25zdGFudHMudHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL2NvbXBvbmVudC9zcmMvcHJvdmlkZXIudHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL2NvbXBvbmVudC9zcmMvY29tcG9uZW50X2NvbnRhaW5lci50cyIsIm5vZGVfbW9kdWxlcy9AZmlyZWJhc2UvaW5zdGFsbGF0aW9ucy9zcmMvdXRpbC9jb25zdGFudHMudHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL2luc3RhbGxhdGlvbnMvc3JjL3V0aWwvZXJyb3JzLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9pbnN0YWxsYXRpb25zL3NyYy9mdW5jdGlvbnMvY29tbW9uLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9pbnN0YWxsYXRpb25zL3NyYy9mdW5jdGlvbnMvY3JlYXRlLWluc3RhbGxhdGlvbi1yZXF1ZXN0LnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9pbnN0YWxsYXRpb25zL3NyYy91dGlsL3NsZWVwLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9pbnN0YWxsYXRpb25zL3NyYy9oZWxwZXJzL2J1ZmZlci10by1iYXNlNjQtdXJsLXNhZmUudHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL2luc3RhbGxhdGlvbnMvc3JjL2hlbHBlcnMvZ2VuZXJhdGUtZmlkLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9pbnN0YWxsYXRpb25zL3NyYy91dGlsL2dldC1rZXkudHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL2luc3RhbGxhdGlvbnMvc3JjL2hlbHBlcnMvZmlkLWNoYW5nZWQudHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL2luc3RhbGxhdGlvbnMvc3JjL2hlbHBlcnMvaWRiLW1hbmFnZXIudHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL2luc3RhbGxhdGlvbnMvc3JjL2hlbHBlcnMvZ2V0LWluc3RhbGxhdGlvbi1lbnRyeS50cyIsIm5vZGVfbW9kdWxlcy9AZmlyZWJhc2UvaW5zdGFsbGF0aW9ucy9zcmMvZnVuY3Rpb25zL2dlbmVyYXRlLWF1dGgtdG9rZW4tcmVxdWVzdC50cyIsIm5vZGVfbW9kdWxlcy9AZmlyZWJhc2UvaW5zdGFsbGF0aW9ucy9zcmMvaGVscGVycy9yZWZyZXNoLWF1dGgtdG9rZW4udHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL2luc3RhbGxhdGlvbnMvc3JjL2FwaS9nZXQtaWQudHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL2luc3RhbGxhdGlvbnMvc3JjL2FwaS9nZXQtdG9rZW4udHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL2luc3RhbGxhdGlvbnMvc3JjL2Z1bmN0aW9ucy9kZWxldGUtaW5zdGFsbGF0aW9uLXJlcXVlc3QudHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL2luc3RhbGxhdGlvbnMvc3JjL2FwaS9kZWxldGUtaW5zdGFsbGF0aW9ucy50cyIsIm5vZGVfbW9kdWxlcy9AZmlyZWJhc2UvaW5zdGFsbGF0aW9ucy9zcmMvYXBpL29uLWlkLWNoYW5nZS50cyIsIm5vZGVfbW9kdWxlcy9AZmlyZWJhc2UvaW5zdGFsbGF0aW9ucy9zcmMvYXBpL2dldC1pbnN0YWxsYXRpb25zLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9pbnN0YWxsYXRpb25zL3NyYy9oZWxwZXJzL2V4dHJhY3QtYXBwLWNvbmZpZy50cyIsIm5vZGVfbW9kdWxlcy9AZmlyZWJhc2UvaW5zdGFsbGF0aW9ucy9zcmMvZnVuY3Rpb25zL2NvbmZpZy50cyIsIm5vZGVfbW9kdWxlcy9AZmlyZWJhc2UvaW5zdGFsbGF0aW9ucy9zcmMvaW5kZXgudHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL2xvZ2dlci9zcmMvbG9nZ2VyLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9tZXNzYWdpbmcvc3JjL3V0aWwvY29uc3RhbnRzLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9tZXNzYWdpbmcvc3JjL2ludGVyZmFjZXMvaW50ZXJuYWwtbWVzc2FnZS1wYXlsb2FkLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9tZXNzYWdpbmcvc3JjL2hlbHBlcnMvYXJyYXktYmFzZTY0LXRyYW5zbGF0b3IudHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL21lc3NhZ2luZy9zcmMvaGVscGVycy9taWdyYXRlLW9sZC1kYXRhYmFzZS50cyIsIm5vZGVfbW9kdWxlcy9AZmlyZWJhc2UvbWVzc2FnaW5nL3NyYy9pbnRlcm5hbHMvaWRiLW1hbmFnZXIudHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL21lc3NhZ2luZy9zcmMvdXRpbC9lcnJvcnMudHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL21lc3NhZ2luZy9zcmMvaW50ZXJuYWxzL3JlcXVlc3RzLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9tZXNzYWdpbmcvc3JjL2ludGVybmFscy90b2tlbi1tYW5hZ2VyLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9tZXNzYWdpbmcvc3JjL2hlbHBlcnMvZXh0ZXJuYWxpemVQYXlsb2FkLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9tZXNzYWdpbmcvc3JjL2hlbHBlcnMvaXMtY29uc29sZS1tZXNzYWdlLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9tZXNzYWdpbmcvc3JjL2hlbHBlcnMvbG9nVG9GaXJlbG9nLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9tZXNzYWdpbmcvc3JjL2hlbHBlcnMvZXh0cmFjdC1hcHAtY29uZmlnLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9tZXNzYWdpbmcvc3JjL21lc3NhZ2luZy1zZXJ2aWNlLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9tZXNzYWdpbmcvc3JjL2hlbHBlcnMvcmVnaXN0ZXJEZWZhdWx0U3cudHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL21lc3NhZ2luZy9zcmMvaGVscGVycy91cGRhdGVTd1JlZy50cyIsIm5vZGVfbW9kdWxlcy9AZmlyZWJhc2UvbWVzc2FnaW5nL3NyYy9oZWxwZXJzL3VwZGF0ZVZhcGlkS2V5LnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9tZXNzYWdpbmcvc3JjL2FwaS9nZXRUb2tlbi50cyIsIm5vZGVfbW9kdWxlcy9AZmlyZWJhc2UvbWVzc2FnaW5nL3NyYy9oZWxwZXJzL2xvZ1RvU2Npb24udHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL21lc3NhZ2luZy9zcmMvbGlzdGVuZXJzL3dpbmRvdy1saXN0ZW5lci50cyIsIm5vZGVfbW9kdWxlcy9AZmlyZWJhc2UvbWVzc2FnaW5nL3NyYy9oZWxwZXJzL3JlZ2lzdGVyLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9tZXNzYWdpbmcvc3JjL2FwaS9pc1N1cHBvcnRlZC50cyIsIm5vZGVfbW9kdWxlcy9AZmlyZWJhc2UvbWVzc2FnaW5nL3NyYy9hcGkvZGVsZXRlVG9rZW4udHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL21lc3NhZ2luZy9zcmMvYXBpL29uTWVzc2FnZS50cyIsIm5vZGVfbW9kdWxlcy9AZmlyZWJhc2UvbWVzc2FnaW5nL3NyYy9hcGkudHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL21lc3NhZ2luZy9zcmMvaW5kZXgudHMiLCJub2RlX21vZHVsZXMvQGZpcmViYXNlL21lc3NhZ2luZy9zcmMvaGVscGVycy9zbGVlcC50cyIsIm5vZGVfbW9kdWxlcy9AZmlyZWJhc2UvbWVzc2FnaW5nL3NyYy9saXN0ZW5lcnMvc3ctbGlzdGVuZXJzLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9tZXNzYWdpbmcvc3JjL2FwaS9vbkJhY2tncm91bmRNZXNzYWdlLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9tZXNzYWdpbmcvc3JjL2FwaS9zZXREZWxpdmVyeU1ldHJpY3NFeHBvcnRlZFRvQmlnUXVlcnlFbmFibGVkLnRzIiwibm9kZV9tb2R1bGVzL0BmaXJlYmFzZS9tZXNzYWdpbmcvc3JjL2luZGV4LnN3LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7OztBQUFBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBR0EsSUFBQSxHQUFBLEdBQUEsdUJBQUEsQ0FBQSxPQUFBO0FBQ0EsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQU8yQyxTQUFBLHlCQUFBLENBQUEsNkJBQUEsT0FBQSxtQkFBQSxDQUFBLE9BQUEsT0FBQSxJQUFBLENBQUEsT0FBQSxPQUFBLFlBQUEsd0JBQUEsWUFBQSxDQUFBLENBQUEsV0FBQSxDQUFBLEdBQUEsQ0FBQSxHQUFBLENBQUEsS0FBQSxDQUFBO0FBQUEsU0FBQSx3QkFBQSxDQUFBLEVBQUEsQ0FBQSxTQUFBLENBQUEsSUFBQSxDQUFBLElBQUEsQ0FBQSxDQUFBLFVBQUEsU0FBQSxDQUFBLGVBQUEsQ0FBQSx1QkFBQSxDQUFBLHlCQUFBLENBQUEsV0FBQSxPQUFBLEVBQUEsQ0FBQSxRQUFBLENBQUEsR0FBQSx3QkFBQSxDQUFBLENBQUEsT0FBQSxDQUFBLElBQUEsQ0FBQSxDQUFBLEdBQUEsQ0FBQSxDQUFBLFVBQUEsQ0FBQSxDQUFBLEdBQUEsQ0FBQSxDQUFBLE9BQUEsQ0FBQSxLQUFBLFNBQUEsVUFBQSxDQUFBLEdBQUEsTUFBQSxDQUFBLGNBQUEsSUFBQSxNQUFBLENBQUEsd0JBQUEsV0FBQSxDQUFBLElBQUEsQ0FBQSxvQkFBQSxDQUFBLE9BQUEsY0FBQSxDQUFBLElBQUEsQ0FBQSxDQUFBLEVBQUEsQ0FBQSxTQUFBLENBQUEsR0FBQSxDQUFBLEdBQUEsTUFBQSxDQUFBLHdCQUFBLENBQUEsQ0FBQSxFQUFBLENBQUEsVUFBQSxDQUFBLEtBQUEsQ0FBQSxDQUFBLEdBQUEsSUFBQSxDQUFBLENBQUEsR0FBQSxJQUFBLE1BQUEsQ0FBQSxjQUFBLENBQUEsQ0FBQSxFQUFBLENBQUEsRUFBQSxDQUFBLElBQUEsQ0FBQSxDQUFBLENBQUEsSUFBQSxDQUFBLENBQUEsQ0FBQSxZQUFBLENBQUEsQ0FBQSxPQUFBLEdBQUEsQ0FBQSxFQUFBLENBQUEsSUFBQSxDQUFBLENBQUEsR0FBQSxDQUFBLENBQUEsRUFBQSxDQUFBLEdBQUEsQ0FBQTtBQVYzQztBQUNBOztBQWdCTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEdBQUc7O0FBRTFCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUMzQixxQkFBb0MsRUFDWjtFQUN4QixNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUNwQyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUNsQyxPQUFPLGFBQWE7QUFDdEI7QUFFQSxTQUFTLGNBQWMsQ0FDckIsS0FBOEIsRUFDTDtFQUFBLElBQUEscUJBQUE7RUFDekIsSUFBSSxDQUFDLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUsbUJBQW1CLENBQUMsRUFBRTtJQUFBLElBQUEsY0FBQSxFQUFBLHFCQUFBO0lBQzVDLENBQUEsY0FBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsY0FBQSxnQkFBQSxxQkFBQSxHQUFiLGNBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxjQUFBLEVBQ0UsSUFBSSxLQUFLLENBQUMsd0NBQXdDLENBQ3BELENBQUM7SUFDRCxPQUFPLEtBQUs7RUFDZCxDQUFDLE1BQU0sSUFBSSxDQUFDLElBQUEsZUFBUSxFQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxFQUFFO0lBQUEsSUFBQSxlQUFBLEVBQUEscUJBQUE7SUFDN0MsQ0FBQSxlQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxlQUFBLGdCQUFBLHFCQUFBLEdBQWIsZUFBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGVBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCxxQ0FBcUMsT0FBTyxLQUFLLENBQUMsaUJBQWlCLEVBQ3JFLENBQ0YsQ0FBQztJQUNELE9BQU8sS0FBSztFQUNkLENBQUMsTUFBTSxJQUFJLENBQUMsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSx1QkFBdUIsQ0FBQyxFQUFFO0lBQUEsSUFBQSxlQUFBLEVBQUEscUJBQUE7SUFDdkQsQ0FBQSxlQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxlQUFBLGdCQUFBLHFCQUFBLEdBQWIsZUFBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGVBQUEsRUFDRSxJQUFJLEtBQUssQ0FBQyw0Q0FBNEMsQ0FDeEQsQ0FBQztJQUNELE9BQU8sS0FBSztFQUNkLENBQUMsTUFBTSxJQUFJLENBQUMsSUFBQSxlQUFRLEVBQUMsS0FBSyxDQUFDLHFCQUFxQixDQUFDLEVBQUU7SUFBQSxJQUFBLGVBQUEsRUFBQSxxQkFBQTtJQUNqRCxDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZ0JBQUEscUJBQUEsR0FBYixlQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsZUFBQSxFQUNFLElBQUksS0FBSyxDQUNQLHlDQUF5QyxPQUFPLEtBQUssQ0FBQyxxQkFBcUIsRUFDN0UsQ0FDRixDQUFDO0lBQ0QsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxNQUFNLFlBQVksR0FBRyxLQUFLLENBQUMsaUJBQWlCOztFQUU1QztFQUNBLElBQUkscUJBQXFCLEdBQUcsSUFBQSxlQUFRLEVBQUMsWUFBWSxDQUFDLHFCQUFxQixDQUFDLEdBQ3BFLE1BQU0sQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLHFCQUFxQixDQUFDLEdBQ2pELEVBQUU7O0VBRU47RUFDQTtFQUNBLHFCQUFxQixHQUFHLENBQ3RCO0lBQ0UsSUFBSSxFQUFFLFFBQVE7SUFDZCxFQUFFLEVBQUUsU0FBUztJQUNiLE9BQU8sRUFBRSxLQUFLO0lBQ2QsTUFBTSxFQUFFLEtBQUs7SUFDYixRQUFRLEVBQUUsNkJBQW9CO0lBQzlCLE1BQU0sRUFBRSxnREFBZ0Q7SUFDeEQsUUFBUSxFQUFFO01BQUUsZ0JBQWdCLEVBQUU7SUFBdUI7RUFDdkQsQ0FBQyxFQUNEO0lBQ0UsSUFBSSxFQUFFLFFBQVE7SUFDZCxFQUFFLEVBQUUsU0FBUztJQUNiLE9BQU8sRUFBRSxVQUFVO0lBQ25CLE1BQU0sRUFBRSxZQUFZO0lBQ3BCLFFBQVEsRUFBRSw2QkFBb0I7SUFDOUIsTUFBTSxFQUFFLGdEQUFnRDtJQUN4RCxRQUFRLEVBQUU7TUFBRSxnQkFBZ0IsRUFBRTtJQUErQjtFQUMvRCxDQUFDLEVBQ0Q7SUFDRSxJQUFJLEVBQUUsUUFBUTtJQUNkLEVBQUUsRUFBRSxlQUFlO0lBQ25CLE9BQU8sRUFBRSxRQUFRO0lBQ2pCLE1BQU0sRUFBRSxVQUFVO0lBQ2xCLFFBQVEsRUFBRSxtQ0FBMEI7SUFDcEMsTUFBTSxFQUFFLHNEQUFzRDtJQUM5RCxRQUFRLEVBQUU7TUFBRSxnQkFBZ0IsRUFBRTtJQUFrQztFQUNsRSxDQUFDLEVBQ0Q7SUFDRSxJQUFJLEVBQUUsUUFBUTtJQUNkLEVBQUUsRUFBRSxlQUFlO0lBQ25CLE9BQU8sRUFBRSxRQUFRO0lBQ2pCLE1BQU0sRUFBRSxLQUFLO0lBQ2IsUUFBUSxFQUFFLG1DQUEwQjtJQUNwQyxNQUFNLEVBQUUsc0RBQXNEO0lBQzlELFFBQVEsRUFBRTtNQUFFLGdCQUFnQixFQUFFO0lBQTBCO0VBQzFELENBQUMsRUFDRCxHQUFHLHFCQUFxQixDQUN6Qjs7RUFFRDtFQUNBO0VBQ0EsTUFBTSxtQ0FBbUMsR0FBRyxxQkFBcUIsQ0FBQyxNQUFNLENBQ3RFLENBQUMsR0FBb0MsRUFBRSxvQkFBb0IsS0FBSztJQUM5RCxJQUNFLElBQUEsZUFBUSxFQUFDLG9CQUFvQixDQUFDLElBQzlCLE9BQU8sb0JBQW9CLENBQUMsT0FBTyxLQUFLLFFBQVEsRUFDaEQ7TUFBQSxJQUFBLHFCQUFBO01BQ0EsQ0FBQyxHQUFHLENBQUEscUJBQUEsR0FBQyxvQkFBb0IsQ0FBQyxPQUFPLENBQUMsS0FBakMsR0FBRyxDQUFBLHFCQUFBLENBQThCLEdBQUssRUFBRSxHQUFFLElBQUksQ0FBQyxvQkFBb0IsQ0FBQztJQUN2RTtJQUNBLE9BQU8sR0FBRztFQUNaLENBQUMsRUFDRCxDQUFDLENBQ0gsQ0FBQzs7RUFFRDtFQUNBLE1BQU0sWUFBNkIsR0FBRyxLQUFLLENBQUMsT0FBTyxDQUNqRCxLQUFLLENBQUMscUJBQXFCLENBQUMsWUFDOUIsQ0FBQyxHQUNHLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxZQUFZLENBQ3JDLE1BQU0sQ0FDSixFQUFFLElBQ0QsSUFBQSxlQUFRLEVBQUMsRUFBRSxDQUFDLElBQ1osT0FBTyxFQUFFLENBQUMsSUFBSSxLQUFLLFFBQVEsSUFDM0IsT0FBTyxFQUFFLENBQUMsZUFBZSxLQUFLLFFBQ2xDLENBQUMsQ0FDQSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUNsQyxFQUFFOztFQUVOO0VBQ0EsTUFBTSw4QkFBOEIsR0FBRyxNQUFNLENBQUMsT0FBTyxDQUNuRCxtQ0FDRixDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsR0FBNEIsRUFBRSxDQUFDLE9BQU8sRUFBRSxRQUFRLENBQUMsS0FBSztJQUFBLElBQUEsWUFBQSxFQUFBLGNBQUEsRUFBQSxZQUFBLEVBQUEsZUFBQTtJQUM5RDtJQUNBO0lBQ0EsSUFBSSxVQUFxQzs7SUFFekM7SUFDQSxVQUFVLEdBQUcsUUFBUSxDQUFDLElBQUksQ0FDdkIsT0FBTyxJQUFLLE9BQU8sQ0FBQyxFQUFFLEtBQUssWUFBWSxDQUFDLHVCQUMzQyxDQUFDOztJQUVEO0lBQ0EsSUFBSSxDQUFDLFVBQVUsRUFBRTtNQUNmLFlBQVksQ0FDVCxNQUFNLENBQUUsRUFBRSxJQUFLLEVBQUUsQ0FBQyxPQUFPLEtBQUssT0FBTyxDQUFDLENBQ3RDLElBQUksQ0FDRixFQUFFLElBQ0EsVUFBVSxHQUFHLFFBQVEsQ0FBQyxJQUFJLENBQ3hCLE9BQU8sSUFBSyxPQUFPLENBQUMsRUFBRSxLQUFLLEVBQUUsQ0FBQyxlQUNqQyxDQUNKLENBQUM7SUFDTDs7SUFFQTtJQUNBO0lBQ0EsSUFBSSxDQUFDLFVBQVUsRUFBRTtNQUNmLFVBQVUsR0FBRyxRQUFRLENBQUMsSUFBSSxDQUFFLE9BQU8sSUFBSyxPQUFPLENBQUMsSUFBSSxLQUFLLFFBQVEsQ0FBQztJQUNwRTs7SUFFQTtJQUNBLE1BQU0sWUFBWSxHQUFHLFFBQVEsQ0FBQyxNQUFNLENBQ2xDLENBQUMsU0FBMEIsRUFBRSxPQUFPLEtBQUs7TUFDdkMsSUFDRSxPQUFPLENBQUMsRUFBRSxJQUNWLE9BQU8sQ0FBQyxNQUFNLElBQ2QsT0FBTyxPQUFPLENBQUMsTUFBTSxLQUFLLFFBQVEsSUFDbEMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsRUFDMUI7UUFDQTtRQUNBO1FBQ0EsTUFBTSxvQkFBb0IsR0FBRyxxQkFBcUIsQ0FBQyxJQUFJLENBQ3BELFlBQVksSUFDWCxJQUFBLGVBQVEsRUFBQyxZQUFZLENBQUMsSUFDdEIsT0FBTyxZQUFZLENBQUMsTUFBTSxLQUFLLFFBQVEsSUFDdkMsT0FBTyxPQUFPLENBQUMsTUFBTSxLQUFLLFFBQVEsSUFDbEMsWUFBWSxDQUFDLEVBQUUsS0FBSyxPQUFPLENBQUMsRUFBRTtRQUFJO1FBQ2xDLEdBQUcsQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLE1BQU0sRUFBRSxPQUFPLENBQUMsTUFBTSxDQUFDO1FBQUk7UUFDbEQsWUFBWSxDQUFDLEVBQUUsS0FBSyxZQUFZLENBQUMsdUJBQXVCLENBQUU7UUFDOUQsQ0FBQzs7UUFFRDtRQUNBO1FBQ0EsTUFBTSxxQkFBcUIsR0FBRztRQUM1QjtRQUNBLEdBQUcsTUFBTSxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FBQyxPQUFPLENBQUUsQ0FBQyxJQUM5QixJQUFBLGVBQVEsRUFBQyxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsWUFBWSxHQUFHLEVBQ2pDLENBQUM7UUFDRDtRQUNBLEdBQUcsU0FBUyxDQUNiLENBQUMsSUFBSSxDQUNILGdCQUFnQixJQUNmLElBQUEsZUFBUSxFQUFDLGdCQUFnQixDQUFDLElBQzFCLE9BQU8sZ0JBQWdCLENBQUMsR0FBRyxLQUFLLFFBQVEsSUFDeEMsT0FBTyxPQUFPLENBQUMsTUFBTSxLQUFLLFFBQVEsSUFDbEMsR0FBRyxDQUFDLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLEVBQUUsT0FBTyxDQUFDLE1BQU0sQ0FDbEQsQ0FBQztRQUVELElBQUksQ0FBQyxvQkFBb0IsSUFBSSxDQUFDLHFCQUFxQixFQUFFO1VBQ25EO1VBQ0EsU0FBUyxDQUFDLElBQUksQ0FBQztZQUNiLGVBQWUsRUFBRSxPQUFPLENBQUMsRUFBRTtZQUMzQixHQUFHLEVBQUUsT0FBTyxDQUFDLE1BQU07WUFDbkIsSUFBSSxFQUFFLE9BQU8sQ0FBQyxJQUFJLEtBQUssUUFBUSxHQUFHLFFBQVEsR0FBRyxRQUFRO1lBQ3JELElBQUksT0FBTyxDQUFDLElBQUksS0FBSyxRQUFRLElBQzNCLE9BQU8sT0FBTyxDQUFDLFFBQVEsS0FBSyxRQUFRO1lBQ3BDO1lBQ0EsT0FBTyxDQUFDLFFBQVEsSUFBSTtjQUFFLElBQUksRUFBRSxPQUFPLENBQUM7WUFBUyxDQUFDO1VBQ2xELENBQUMsQ0FBQztRQUNKO01BQ0Y7TUFDQSxPQUFPLFNBQVM7SUFDbEIsQ0FBQyxFQUNELEVBQ0YsQ0FBQzs7SUFFRDtJQUNBO0lBQ0E7SUFDQSxJQUFJLFlBQVksQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO01BQzdCLE9BQU8sR0FBRztJQUNaOztJQUVBO0lBQ0EsTUFBTSx1QkFBdUIsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUN0QyxZQUFZLENBQUMsU0FBUyxDQUNuQixRQUFRO01BQUEsSUFBQSxXQUFBO01BQUEsT0FBSyxRQUFRLENBQUMsZUFBZSxPQUFBLFdBQUEsR0FBSyxVQUFVLGNBQUEsV0FBQSx1QkFBVixXQUFBLENBQVksRUFBRTtJQUFBLENBQzNELENBQUM7SUFDRDtJQUNBLENBQ0YsQ0FBQzs7SUFFRDtJQUNBLE1BQU0saUJBQWlCLEdBQUcsQ0FDeEIsR0FBRyxRQUFRLENBQUMsTUFBTSxDQUFDLENBQUMsSUFBSSxFQUFFLE9BQU8sS0FBSztNQUNwQyxJQUNFLElBQUEsZUFBUSxFQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUMsSUFDMUIsT0FBTyxPQUFPLENBQUMsUUFBUSxDQUFDLGdCQUFnQixLQUFLLFFBQVEsSUFDckQsT0FBTyxDQUFDLFFBQVEsQ0FBQyxnQkFBZ0IsRUFDakM7UUFDQSxJQUFJLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUMsZ0JBQWdCLENBQUM7TUFDN0M7TUFDQSxPQUFPLElBQUk7SUFDYixDQUFDLEVBQUUsSUFBSSxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQ2Q7O0lBRUQ7SUFDQSxNQUFNLDRCQUE0QixHQUNoQyxpQkFBaUIsQ0FBQyxNQUFNLEtBQUssQ0FBQyxHQUMxQixTQUFTLEdBQ1QsSUFBSSxDQUFDLEdBQUcsQ0FDTixpQkFBaUIsQ0FBQyxTQUFTLENBQ3hCLEdBQUc7TUFBQSxJQUFBLFlBQUE7TUFBQSxPQUNGLElBQUEsZUFBUSxHQUFBLFlBQUEsR0FBQyxVQUFVLGNBQUEsWUFBQSx1QkFBVixZQUFBLENBQVksUUFBUSxDQUFDLElBQzlCLEdBQUcsS0FBSyxVQUFVLENBQUMsUUFBUSxDQUFDLGdCQUFnQjtJQUFBLENBQ2hELENBQUM7SUFDRDtJQUNBLENBQ0YsQ0FBQzs7SUFFUDtJQUNBO0lBQ0E7SUFDQSxNQUFNLElBQUksR0FDUiw0QkFBbUIsQ0FBQyxPQUFPLENBQXFDLE1BQUEsWUFBQSxHQUNoRSxVQUFVLGNBQUEsWUFBQSx1QkFBVixZQUFBLENBQVksUUFBUSxPQUFBLGNBQUEsR0FDcEIsUUFBUSxDQUFDLElBQUksQ0FBRSxDQUFDLElBQUssQ0FBQyxDQUFDLFFBQVEsQ0FBQyxjQUFBLGNBQUEsdUJBQWhDLGNBQUEsQ0FBa0MsUUFBUTtJQUU1QyxNQUFNLGNBQWMsR0FDbEIsd0NBQStCLENBQzdCLE9BQU8sQ0FDUixNQUFBLFlBQUEsR0FDRCxVQUFVLGNBQUEsWUFBQSx1QkFBVixZQUFBLENBQVksTUFBTSxPQUFBLGVBQUEsR0FDbEIsUUFBUSxDQUFDLElBQUksQ0FBRSxDQUFDLElBQUssQ0FBQyxDQUFDLE1BQU0sQ0FBQyxjQUFBLGVBQUEsdUJBQTlCLGVBQUEsQ0FBZ0MsTUFBTTtJQUV4QyxHQUFHLENBQUMsT0FBTyxDQUFDLEdBQUc7TUFDYixPQUFPO01BQ1AsWUFBWTtNQUNaLHVCQUF1QjtNQUN2QixpQkFBaUI7TUFDakIsSUFBSSw0QkFBNEIsS0FBSyxTQUFTLElBQUk7UUFDaEQ7TUFDRixDQUFDLENBQUM7TUFDRixJQUFJO01BQ0o7SUFDRixDQUFDO0lBQ0QsT0FBTyxHQUFHO0VBQ1osQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDOztFQUVOO0VBQ0EsTUFBTSx3QkFBd0IsR0FBSSxlQUF3QixJQUFLO0lBQzdELE1BQU0sb0JBQW9CLEdBQUcscUJBQXFCLENBQUMsSUFBSSxDQUNwRCxDQUFDLElBQUssSUFBQSxlQUFRLEVBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDLEVBQUUsS0FBSyxlQUNqQyxDQUFDO0lBRUQsT0FBTyxJQUFBLGVBQVEsRUFBQyxvQkFBb0IsQ0FBQyxJQUNuQyxRQUFPLG9CQUFvQixhQUFwQixvQkFBb0IsdUJBQXBCLG9CQUFvQixDQUFFLE9BQU8sTUFBSyxRQUFRLEdBQy9DLG9CQUFvQixhQUFwQixvQkFBb0IsdUJBQXBCLG9CQUFvQixDQUFFLE9BQU8sR0FDN0IsU0FBUztFQUNmLENBQUM7O0VBRUQ7RUFDQTtFQUNBLElBQUksdUJBQXVCLElBQUEscUJBQUEsR0FBRyxNQUFNLENBQUMsTUFBTSxDQUFDLDhCQUE4QixDQUFDLENBQ3hFLE9BQU8sQ0FBRSxDQUFDLElBQ1QsSUFBQSxlQUFRLEVBQUMsQ0FBQyxDQUFDLElBQUksS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsWUFBWSxDQUFDLEdBQUcsQ0FBQyxDQUFDLFlBQVksR0FBRyxFQUNsRSxDQUFDLENBQ0EsSUFBSSxDQUNGLENBQUMsSUFBSyxDQUFDLENBQUMsZUFBZSxLQUFLLFlBQVksQ0FBQyx1QkFDNUMsQ0FBQyxjQUFBLHFCQUFBLHVCQU4yQixxQkFBQSxDQU16QixlQUFlOztFQUVwQjtFQUNBLElBQUksQ0FBQyx1QkFBdUIsRUFBRTtJQUM1QjtJQUNBO0lBQ0EsTUFBTSxPQUFPLEdBQUcsd0JBQXdCLENBQ3RDLFlBQVksQ0FBQyx1QkFDZixDQUFDOztJQUVEO0lBQ0EsTUFBTSxvQkFBb0IsR0FDeEIsOEJBQThCLENBQUMsT0FBTyxJQUFJLEtBQUssQ0FBQztJQUVsRCx1QkFBdUIsR0FDckIsSUFBQSxlQUFRLEVBQUMsb0JBQW9CLENBQUMsSUFDOUIsS0FBSyxDQUFDLE9BQU8sQ0FBQyxvQkFBb0IsQ0FBQyxZQUFZLENBQUMsSUFDaEQsT0FBTyxvQkFBb0IsQ0FBQyx1QkFBdUIsS0FBSyxRQUFRLEdBQzVELG9CQUFvQixDQUFDLFlBQVksQ0FDL0Isb0JBQW9CLENBQUMsdUJBQXVCLENBQzdDLENBQUMsZUFBZSxHQUNqQixTQUFTO0VBQ2pCOztFQUVBO0VBQ0E7RUFDQSxJQUNFLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUsMkJBQTJCLENBQUMsSUFDL0MsSUFBQSxlQUFRLEVBQUMsS0FBSyxDQUFDLHlCQUF5QixDQUFDLElBQ3pDLElBQUEsa0JBQVcsRUFBQyxLQUFLLENBQUMseUJBQXlCLEVBQUUsU0FBUyxDQUFDLElBQ3ZELElBQUEsZUFBUSxFQUFDLEtBQUssQ0FBQyx5QkFBeUIsQ0FBQyxPQUFPLENBQUMsRUFDakQ7SUFDQSxLQUFLLE1BQU0sQ0FBQyxNQUFNLEVBQUUsZUFBZSxDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FDcEQsS0FBSyxDQUFDLHlCQUF5QixDQUFDLE9BQ2xDLENBQUMsRUFBRTtNQUNELElBQUksa0JBQWtCOztNQUV0QjtNQUNBLE1BQU0sT0FBTyxHQUFHLHdCQUF3QixDQUFDLGVBQWUsQ0FBQztNQUV6RCxJQUFJLE9BQU8sRUFBRTtRQUNYO1FBQ0EsTUFBTSxvQkFBb0IsR0FBRyw4QkFBOEIsQ0FBQyxPQUFPLENBQUM7UUFDcEUsSUFDRSxJQUFBLGVBQVEsRUFBQyxvQkFBb0IsQ0FBQyxJQUM5QixLQUFLLENBQUMsT0FBTyxDQUFDLG9CQUFvQixDQUFDLFlBQVksQ0FBQyxJQUNoRCxPQUFPLG9CQUFvQixDQUFDLHVCQUF1QixLQUFLLFFBQVEsRUFDaEU7VUFDQSxrQkFBa0IsR0FDaEIsb0JBQW9CLENBQUMsWUFBWSxDQUMvQixvQkFBb0IsQ0FBQyx1QkFBdUIsQ0FDN0MsQ0FBQyxlQUFlO1FBQ3JCO01BQ0Y7O01BRUE7TUFDQTtNQUNBLElBQUksa0JBQWtCLEVBQUU7UUFDdEIsS0FBSyxDQUFDLHlCQUF5QixDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsR0FBRyxrQkFBa0I7TUFDdEUsQ0FBQyxNQUFNO1FBQ0wsT0FBTyxLQUFLLENBQUMseUJBQXlCLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQztNQUN4RDtJQUNGO0VBQ0Y7RUFFQSxLQUFLLENBQUMsaUJBQWlCLEdBQUc7SUFDeEIsdUJBQXVCO0lBQ3ZCLDhCQUE4QjtJQUM5QixnQkFBZ0IsRUFBRSxZQUFZLENBQUMsZ0JBQWdCLElBQUksQ0FBQztFQUN0RCxDQUFDOztFQUVEO0VBQ0EsSUFDRSxJQUFBLGtCQUFXLEVBQUMsS0FBSyxFQUFFLHVCQUF1QixDQUFDLElBQzNDLElBQUEsZUFBUSxFQUFDLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxJQUNyQyxJQUFBLGtCQUFXLEVBQUMsS0FBSyxDQUFDLHFCQUFxQixFQUFFLGFBQWEsQ0FBQyxJQUN2RCxJQUFBLGVBQVEsRUFBQyxLQUFLLENBQUMscUJBQXFCLENBQUMsV0FBVyxDQUFDLEVBQ2pEO0lBQ0EsS0FBSyxDQUFDLHFCQUFxQixDQUFDLFdBQVcsQ0FBQyxpQkFBaUIsR0FBRyxNQUFNLENBQUMsTUFBTSxDQUN2RSw4QkFDRixDQUFDLENBQUMsSUFBSSxDQUNILG9CQUFvQixJQUNuQixJQUFBLGVBQVEsRUFBQyxvQkFBb0IsQ0FBQyxJQUM5QixLQUFLLENBQUMsT0FBTyxDQUFDLG9CQUFvQixDQUFDLFlBQVksQ0FBQyxJQUNoRCxvQkFBb0IsQ0FBQyxZQUFZLENBQUMsTUFBTSxHQUFHLENBQy9DLENBQUM7RUFDSDs7RUFFQTtFQUNBLElBQ0UsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSx3QkFBd0IsQ0FBQyxJQUM1QyxJQUFBLGVBQVEsRUFBQyxLQUFLLENBQUMsc0JBQXNCLENBQUMsSUFDdEMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsc0JBQXNCLENBQUMsa0JBQWtCLENBQUMsRUFDOUQ7SUFDQTtJQUNBO0lBQ0EsS0FBSyxDQUFDLHNCQUFzQixDQUFDLGtCQUFrQixHQUFHLENBQ2hELEdBQUcsSUFBSSxHQUFHLENBQ1IsS0FBSyxDQUFDLHNCQUFzQixDQUFDLGtCQUFrQixDQUFDLEdBQUcsQ0FDaEQsT0FBTyxJQUFLLE9BQU8sQ0FBQyxTQUN2QixDQUNGLENBQUMsQ0FDRixDQUFDLEdBQUcsQ0FBRSxTQUFTLEtBQU07TUFBRTtJQUFVLENBQUMsQ0FBQyxDQUFDO0VBQ3ZDO0VBRUEsT0FBTyxLQUFLO0FBQ2Q7O0FBRUE7QUFDQSxTQUFTLFVBQVUsQ0FBQyxHQUFXLEVBQUU7RUFDL0IsTUFBTSxHQUFHLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUM7RUFDMUIsT0FDRSxHQUFHLENBQUMsS0FBSyxLQUFLLFNBQVMsS0FBSyxHQUFHLENBQUMsTUFBTSxLQUFLLE1BQU0sSUFBSSxHQUFHLENBQUMsTUFBTSxLQUFLLE9BQU8sQ0FBQztBQUVoRjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDcGNBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBT08sTUFBTSxPQUFPLEdBQUEsT0FBQSxDQUFBLE9BQUEsR0FBRyxHQUFHOztBQUUxQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FDM0IscUJBQW9DLEVBQ1o7RUFDeEIsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsY0FBYyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7RUFDbEMsT0FBTyxhQUFhO0FBQ3RCO0FBRUEsU0FBUyxjQUFjLENBQ3JCLEtBQThCLEVBQ0w7RUFDekIsSUFDRSxJQUFBLGtCQUFXLEVBQUMsS0FBSyxFQUFFLHVCQUF1QixDQUFDLElBQzNDLElBQUEsZUFBUSxFQUFDLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxJQUNyQyxJQUFBLGVBQVEsRUFBQyxLQUFLLENBQUMscUJBQXFCLENBQUMsV0FBVyxDQUFDLEVBQ2pEO0lBQ0EsT0FBTyxLQUFLLENBQUMscUJBQXFCLENBQUMsV0FBVyxDQUMzQyxrQ0FBa0M7RUFDdkM7RUFFQSxPQUFPLEtBQUs7QUFDZDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDekNBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBT08sTUFBTSxPQUFPLEdBQUEsT0FBQSxDQUFBLE9BQUEsR0FBRyxHQUFHOztBQUUxQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FDM0IscUJBQW9DLEVBQ1o7RUFDeEIsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsY0FBYyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7RUFDbEMsT0FBTyxhQUFhO0FBQ3RCO0FBRUEsU0FBUyxjQUFjLENBQ3JCLEtBQThCLEVBQ0w7RUFDekIsSUFDRSxJQUFBLGtCQUFXLEVBQUMsS0FBSyxFQUFFLHVCQUF1QixDQUFDLElBQzNDLElBQUEsZUFBUSxFQUFDLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxJQUNyQyxJQUFBLGVBQVEsRUFBQyxLQUFLLENBQUMscUJBQXFCLENBQUMsV0FBVyxDQUFDLEVBQ2pEO0lBQ0EsSUFDRSxLQUFLLENBQUMscUJBQXFCLENBQUMsV0FBVyxDQUNwQyxrQ0FBa0MsS0FBSyxTQUFTLEVBQ25EO01BQ0EsS0FBSyxDQUFDLHFCQUFxQixDQUFDLFdBQVcsQ0FBQyxrQ0FBa0MsR0FBRyxJQUFJO0lBQ25GO0VBQ0Y7RUFFQSxPQUFPLEtBQUs7QUFDZDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDN0NBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBTU8sTUFBTSxPQUFPLEdBQUEsT0FBQSxDQUFBLE9BQUEsR0FBRyxHQUFHO0FBQzFCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sZUFBZSxPQUFPLENBQzNCLHFCQUFvQyxFQUNaO0VBQ3hCLE1BQU0sYUFBYSxHQUFHLElBQUEsaUJBQVMsRUFBQyxxQkFBcUIsQ0FBQztFQUN0RCxhQUFhLENBQUMsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPO0VBQ3BDLGNBQWMsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDO0VBQ2xDLE9BQU8sYUFBYTtBQUN0QjtBQUNBLFNBQVMsY0FBYyxDQUNyQixLQUE4QixFQUNMO0VBQ3pCLElBQ0UsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSx1QkFBdUIsQ0FBQyxJQUMzQyxJQUFBLGVBQVEsRUFBQyxLQUFLLENBQUMscUJBQXFCLENBQUMsSUFDckMsSUFBQSxrQkFBVyxFQUFDLEtBQUssQ0FBQyxxQkFBcUIsRUFBRSxhQUFhLENBQUMsSUFDdkQsSUFBQSxlQUFRLEVBQUMsS0FBSyxDQUFDLHFCQUFxQixDQUFDLFdBQVcsQ0FBQyxJQUNqRCxDQUFDLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxXQUFXLENBQUMsZUFBZSxFQUN4RDtJQUNBLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxXQUFXLENBQUMsZUFBZSxHQUFHO01BQ3hELEdBQUcsRUFBRSxpQkFBaUI7TUFDdEIsS0FBSyxFQUFFLEtBQUs7TUFDWixZQUFZLEVBQUU7SUFDaEIsQ0FBQztFQUNIO0VBQ0EsT0FBTyxLQUFLO0FBQ2Q7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQzNDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxrQkFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQU9PLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsS0FBSztBQUM1QixNQUFNLGFBQWEsR0FBRyxRQUFROztBQUU5QjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUFDLHFCQUc3QixFQUFFO0VBQ0QsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsYUFBYSxDQUFDLElBQUksR0FBRyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUN2RCxPQUFPLGFBQWE7QUFDdEI7QUFFQSxTQUFTLGNBQWMsQ0FBQyxLQUE4QixFQUFFO0VBQ3RELElBQ0UsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSxtQkFBbUIsQ0FBQyxJQUN2QyxJQUFBLGVBQVEsRUFBQyxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFDakMsSUFBQSxrQkFBVyxFQUFDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxnQ0FBZ0MsQ0FBQyxJQUN0RSxJQUFBLGVBQVEsRUFBQyxLQUFLLENBQUMsaUJBQWlCLENBQUMsOEJBQThCLENBQUMsRUFDaEU7SUFDQSxNQUFNO01BQUU7SUFBK0IsQ0FBQyxHQUFHLEtBQUssQ0FBQyxpQkFBaUI7O0lBRWxFO0lBQ0EsTUFBTSxVQUFVLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQyw4QkFBOEIsQ0FBQyxDQUM5RCxNQUFNLENBQ0wsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxLQUNSLENBQUMsQ0FBQyxHQUFHLCtCQUFzQixFQUFFLGtCQUFTLENBQUMsYUFBYSxDQUFDLENBQUMsUUFBUSxDQUM1RCxPQUNGLENBQ0osQ0FBQyxDQUNBLElBQUksQ0FBQyxDQUFDLEdBQUcsYUFBYSxDQUFDLEtBQUs7TUFBQSxJQUFBLHFCQUFBO01BQzNCLElBQ0UsQ0FBQyxJQUFBLGVBQVEsRUFBQyxhQUFhLENBQUMsSUFDeEIsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLGFBQWEsQ0FBQyxZQUFZLENBQUMsSUFDMUMsT0FBTyxhQUFhLENBQUMsdUJBQXVCLEtBQUssUUFBUSxFQUN6RDtRQUNBLE9BQU8sS0FBSztNQUNkOztNQUVBO01BQ0EsTUFBTSxrQkFBa0IsR0FDdEIsYUFBYSxhQUFiLGFBQWEsZ0JBQUEscUJBQUEsR0FBYixhQUFhLENBQUUsWUFBWSxjQUFBLHFCQUFBLHVCQUEzQixxQkFBQSxDQUE4QixhQUFhLGFBQWIsYUFBYSx1QkFBYixhQUFhLENBQUUsdUJBQXVCLENBQUM7TUFFdkUsSUFDRSxDQUFDLElBQUEsZUFBUSxFQUFDLGtCQUFrQixDQUFDLElBQzdCLE9BQU8sa0JBQWtCLENBQUMsR0FBRyxLQUFLLFFBQVEsRUFDMUM7UUFDQSxPQUFPLEtBQUs7TUFDZDtNQUVBLElBQUk7UUFDRixNQUFNLE9BQU8sR0FBRyxJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxHQUFHLENBQUMsQ0FBQyxJQUFJO1FBQ3BELE9BQ0Usa0JBQWtCLENBQUMsSUFBSSxLQUFLLGtDQUFlLENBQUMsTUFBTSxJQUNsRCwyQkFBa0IsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDO01BRXhDLENBQUMsQ0FBQyxNQUFNO1FBQ04sT0FBTyxLQUFLO01BQ2Q7SUFDRixDQUFDLENBQUM7SUFFSixJQUFJLENBQUMsVUFBVSxFQUFFO01BQ2Y7TUFDQSxPQUFPLEtBQUs7SUFDZDs7SUFFQTtJQUNBLE1BQU0saUJBQWlCLEdBQUcsOEJBQThCLENBQUMsYUFBYSxDQUFDO0lBQ3ZFLElBQUksSUFBQSxlQUFRLEVBQUMsaUJBQWlCLENBQUMsRUFBRTtNQUMvQixNQUFNO1FBQUU7TUFBYSxDQUFDLEdBQUcsaUJBQWlCO01BRTFDLElBQUksS0FBSyxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsRUFBRTtRQUMvQjtRQUNBLE1BQU0sS0FBSyxHQUFHLFlBQVksQ0FBQyxTQUFTLENBQ2pDLFFBQVEsSUFDUCxJQUFBLGVBQVEsRUFBQyxRQUFRLENBQUMsSUFBSSxRQUFRLENBQUMsR0FBRyxLQUFLLDBCQUMzQyxDQUFDO1FBRUQsSUFBSSxLQUFLLEtBQUssQ0FBQyxDQUFDLEVBQUU7VUFDaEI7VUFDQSxZQUFZLENBQUMsS0FBSyxDQUFDLEdBQUc7WUFDcEIsR0FBRyxZQUFZLENBQUMsS0FBSyxDQUFDO1lBQ3RCLEdBQUcsRUFBRSxxQ0FBcUMsd0JBQWU7VUFDM0QsQ0FBQzs7VUFFRDtVQUNBLDhCQUE4QixDQUFDLGFBQWEsQ0FBQyxHQUFHO1lBQzlDLEdBQUcsaUJBQWlCO1lBQ3BCO1VBQ0YsQ0FBQztVQUVELE9BQU87WUFDTCxHQUFHLEtBQUs7WUFDUixpQkFBaUIsRUFBRTtjQUNqQixHQUFHLEtBQUssQ0FBQyxpQkFBaUI7Y0FDMUI7WUFDRjtVQUNGLENBQUM7UUFDSDtNQUNGO0lBQ0Y7RUFDRjtFQUVBLE9BQU8sS0FBSztBQUNkOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUMvSEEsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFNBQUEsR0FBQSxzQkFBQSxDQUFBLE9BQUE7QUFBMkIsU0FBQSx1QkFBQSxDQUFBLFdBQUEsQ0FBQSxJQUFBLENBQUEsQ0FBQSxVQUFBLEdBQUEsQ0FBQSxLQUFBLE9BQUEsRUFBQSxDQUFBO0FBT3BCLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsR0FBRzs7QUFFMUI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sZUFBZSxPQUFPLENBQzNCLHFCQUFvQyxFQUNaO0VBQ3hCLE1BQU0sYUFBYSxHQUFHLElBQUEsaUJBQVMsRUFBQyxxQkFBcUIsQ0FBQztFQUN0RCxhQUFhLENBQUMsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPO0VBQ3BDLGNBQWMsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDO0VBQ2xDLE9BQU8sYUFBYTtBQUN0QjtBQUVBLFNBQVMsY0FBYyxDQUFDLEtBQThCLEVBQVE7RUFDNUQsSUFBSSxDQUFDLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUsb0JBQW9CLENBQUMsRUFBRTtJQUM3QztFQUNGO0VBRUEsTUFBTSx1QkFBdUIsR0FBRyxLQUFLLENBQUMsa0JBQWtCO0VBRXhELElBQUksQ0FBQyxJQUFBLGdCQUFRLEVBQUMsdUJBQXVCLENBQUMsRUFBRTtJQUFBLElBQUEsY0FBQTtJQUN0QyxDQUFBLGNBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGNBQUEsZUFBYixjQUFBLENBQWUsZ0JBQWdCLENBQzdCLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTywrQ0FBK0MsT0FBTyx1QkFBdUIsR0FDbkcsQ0FDRixDQUFDO0lBQ0Q7RUFDRixDQUFDLE1BQU0sSUFBSSxDQUFDLElBQUEsa0JBQVcsRUFBQyx1QkFBdUIsRUFBRSxrQkFBa0IsQ0FBQyxFQUFFO0lBQUEsSUFBQSxlQUFBO0lBQ3BFLENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxlQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsQ0FDN0IsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLDhEQUN0QixDQUNGLENBQUM7SUFDRDtFQUNGLENBQUMsTUFBTSxJQUFJLENBQUMsSUFBQSxnQkFBUSxFQUFDLHVCQUF1QixDQUFDLGdCQUFnQixDQUFDLEVBQUU7SUFBQSxJQUFBLGVBQUE7SUFDOUQsQ0FBQSxlQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxlQUFBLGVBQWIsZUFBQSxDQUFlLGdCQUFnQixDQUM3QixJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8sZ0VBQWdFLE9BQU8sdUJBQXVCLENBQUMsZ0JBQWdCLEdBQ3JJLENBQ0YsQ0FBQztJQUNEO0VBQ0YsQ0FBQyxNQUFNLElBQ0wsQ0FBQyxJQUFBLGtCQUFXLEVBQUMsdUJBQXVCLENBQUMsZ0JBQWdCLEVBQUUsaUJBQWlCLENBQUMsRUFDekU7SUFBQSxJQUFBLGVBQUE7SUFDQSxDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZUFBYixlQUFBLENBQWUsZ0JBQWdCLENBQzdCLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTyw4RUFDdEIsQ0FDRixDQUFDO0lBQ0Q7RUFDRixDQUFDLE1BQU0sSUFDTCxPQUFPLHVCQUF1QixDQUFDLGdCQUFnQixDQUFDLGVBQWUsS0FBSyxRQUFRLEVBQzVFO0lBQUEsSUFBQSxlQUFBO0lBQ0EsQ0FBQSxlQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxlQUFBLGVBQWIsZUFBQSxDQUFlLGdCQUFnQixDQUM3QixJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8sZ0ZBQWdGLE9BQU8sdUJBQXVCLENBQy9ILGdCQUFnQixDQUFDLGVBQWUsR0FDckMsQ0FDRixDQUFDO0lBQ0Q7RUFDRixDQUFDLE1BQU0sSUFDTCxDQUFDLElBQUEsa0JBQVcsRUFBQyx1QkFBdUIsQ0FBQyxnQkFBZ0IsRUFBRSxVQUFVLENBQUMsRUFDbEU7SUFBQSxJQUFBLGVBQUE7SUFDQSxDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZUFBYixlQUFBLENBQWUsZ0JBQWdCLENBQzdCLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTyx1RUFDdEIsQ0FDRixDQUFDO0lBQ0Q7RUFDRixDQUFDLE1BQU0sSUFBSSxDQUFDLElBQUEsZ0JBQVEsRUFBQyx1QkFBdUIsQ0FBQyxnQkFBZ0IsQ0FBQyxRQUFRLENBQUMsRUFBRTtJQUFBLElBQUEsZUFBQTtJQUN2RSxDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZUFBYixlQUFBLENBQWUsZ0JBQWdCLENBQzdCLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTyx5RUFBeUUsT0FBTyx1QkFBdUIsQ0FDeEgsZ0JBQWdCLENBQUMsUUFBUSxHQUM5QixDQUNGLENBQUM7SUFDRDtFQUNGO0VBRUEsSUFDRSxNQUFNLENBQUMsSUFBSSxDQUFDLHVCQUF1QixDQUFDLGdCQUFnQixDQUFDLFFBQVEsQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQzNFO0lBQ0E7SUFDQSx1QkFBdUIsQ0FBQyxnQkFBZ0IsQ0FBQyxlQUFlLEdBQUcsRUFBRTtJQUM3RDtFQUNGLENBQUMsTUFBTSxJQUFJLHVCQUF1QixDQUFDLGdCQUFnQixDQUFDLGVBQWUsS0FBSyxFQUFFLEVBQUU7SUFDMUUsaUJBQUcsQ0FBQyxJQUFJLENBQUMsYUFBYSxPQUFPLHFDQUFxQyxDQUFDO0lBQ25FO0VBQ0Y7O0VBRUE7RUFDQSxNQUFNLFlBQVksR0FBRyxNQUFNLENBQUMsTUFBTSxDQUNoQyx1QkFBdUIsQ0FBQyxnQkFBZ0IsQ0FBQyxRQUMzQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0VBQ0osSUFBSSxDQUFDLElBQUEsZ0JBQVEsRUFBQyxZQUFZLENBQUMsRUFBRTtJQUFBLElBQUEsZUFBQTtJQUMzQixDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZUFBYixlQUFBLENBQWUsZ0JBQWdCLENBQzdCLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTyxzRkFBc0YsT0FBTyxZQUFZLEdBQy9ILENBQ0YsQ0FBQztJQUNEO0VBQ0YsQ0FBQyxNQUFNLElBQUksQ0FBQyxJQUFBLGtCQUFXLEVBQUMsWUFBWSxFQUFFLElBQUksQ0FBQyxFQUFFO0lBQUEsSUFBQSxlQUFBO0lBQzNDLENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxlQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsQ0FDN0IsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLGlHQUN0QixDQUNGLENBQUM7SUFDRDtFQUNGLENBQUMsTUFBTSxJQUFJLE9BQU8sWUFBWSxDQUFDLEVBQUUsS0FBSyxRQUFRLEVBQUU7SUFBQSxJQUFBLGVBQUE7SUFDOUMsQ0FBQSxlQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxlQUFBLGVBQWIsZUFBQSxDQUFlLGdCQUFnQixDQUM3QixJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8saUdBQWlHLE9BQU8sWUFBWSxDQUFDLEVBQUUsR0FDN0ksQ0FDRixDQUFDO0lBQ0Q7RUFDRjs7RUFFQTtFQUNBO0VBQ0EsSUFDRSxDQUFDLElBQUEsa0JBQVcsRUFDVix1QkFBdUIsQ0FBQyxnQkFBZ0IsQ0FBQyxRQUFRLEVBQ2pELHVCQUF1QixDQUFDLGdCQUFnQixDQUFDLGVBQzNDLENBQUMsRUFDRDtJQUNBLHVCQUF1QixDQUFDLGdCQUFnQixDQUFDLGVBQWUsR0FBRyxZQUFZLENBQUMsRUFBRTtFQUM1RTtBQUNGOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNsSkEsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFPTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEdBQUc7O0FBRTFCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUMzQixxQkFBb0MsRUFDWjtFQUN4QixNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUNwQyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUNsQyxPQUFPLGFBQWE7QUFDdEI7QUFFQSxTQUFTLGNBQWMsQ0FDckIsS0FBOEIsRUFDTDtFQUFBLElBQUEscUJBQUE7RUFDekIsSUFBSSxDQUFDLElBQUEsZUFBUSxFQUFDLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxxQkFBcUIsQ0FBQyxFQUFFO0lBQzNDLE9BQU8sS0FBSztFQUNkO0VBRUEsSUFBSSxDQUFDLElBQUEsZUFBUSxHQUFBLHFCQUFBLEdBQUMsS0FBSyxDQUFDLHFCQUFxQixjQUFBLHFCQUFBLHVCQUEzQixxQkFBQSxDQUE2QixXQUFXLENBQUMsRUFBRTtJQUN2RCxLQUFLLENBQUMscUJBQXFCLEdBQUc7TUFDNUIsR0FBRyxLQUFLLENBQUMscUJBQXFCO01BQzlCLFdBQVcsRUFBRSxDQUFDO0lBQ2hCLENBQUM7RUFDSDtFQUVBLE1BQU0sMEJBQTBCLEdBQUcsS0FBSyxDQUFDLHFCQUd4QztFQUVELE1BQU0sV0FBVyxHQUFHLDBCQUEwQixDQUFDLFdBRzlDOztFQUVEO0VBQ0E7RUFDQSxXQUFXLENBQUMsNkJBQTZCLEdBQUcsSUFBSTtFQUVoRCxPQUFPLEtBQUs7QUFDZDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDekRBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBT08sTUFBTSxPQUFPLEdBQUEsT0FBQSxDQUFBLE9BQUEsR0FBRyxLQUFLOztBQUU1QjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sZUFBZSxPQUFPLENBQzNCLHFCQUFvQyxFQUNaO0VBQ3hCLE1BQU0sYUFBYSxHQUFHLElBQUEsaUJBQVMsRUFBQyxxQkFBcUIsQ0FBQztFQUN0RCxhQUFhLENBQUMsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPO0VBQ3BDLGNBQWMsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDO0VBQ2xDLE9BQU8sYUFBYTtBQUN0Qjs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUyxjQUFjLENBQUMsS0FBOEIsRUFBUTtFQUM1RCxJQUFJLENBQUMsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSxrQkFBa0IsQ0FBQyxFQUFFO0lBQzNDO0VBQ0Y7RUFFQSxNQUFNLHFCQUFxQixHQUFHLEtBQUssQ0FBQyxnQkFBZ0I7RUFFcEQsSUFBSSxDQUFDLElBQUEsZUFBUSxFQUFDLHFCQUFxQixDQUFDLEVBQUU7SUFBQSxJQUFBLGNBQUE7SUFDcEMsQ0FBQSxjQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxjQUFBLGVBQWIsY0FBQSxDQUFlLGdCQUFnQixDQUM3QixJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8sNkNBQTZDLE9BQU8scUJBQXFCLEdBQy9GLENBQ0YsQ0FBQztJQUNEO0VBQ0Y7O0VBRUE7RUFDQSxJQUFJLElBQUEsa0JBQVcsRUFBQyxxQkFBcUIsRUFBRSxXQUFXLENBQUMsRUFBRTtJQUNuRCxJQUFJLElBQUEsZUFBUSxFQUFDLHFCQUFxQixDQUFDLFNBQVMsQ0FBQyxFQUFFO01BQzdDLHFCQUFxQixDQUFDLFNBQVMsR0FBRyx3QkFBd0IsQ0FDeEQscUJBQXFCLENBQUMsU0FBUyxFQUMvQixXQUNGLENBQUM7SUFDSCxDQUFDLE1BQU07TUFBQSxJQUFBLGVBQUE7TUFDTCxDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZUFBYixlQUFBLENBQWUsZ0JBQWdCLENBQzdCLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTyxzQ0FBc0MsT0FBTyxxQkFBcUIsQ0FBQyxTQUFTLEdBQ2xHLENBQ0YsQ0FBQztJQUNIO0VBQ0Y7O0VBRUE7RUFDQSxJQUFJLElBQUEsa0JBQVcsRUFBQyxxQkFBcUIsRUFBRSxtQkFBbUIsQ0FBQyxFQUFFO0lBQzNELElBQUksSUFBQSxlQUFRLEVBQUMscUJBQXFCLENBQUMsaUJBQWlCLENBQUMsRUFBRTtNQUNyRCxxQkFBcUIsQ0FBQyxpQkFBaUIsR0FBRyx3QkFBd0IsQ0FDaEUscUJBQXFCLENBQUMsaUJBQWlCLEVBQ3ZDLG1CQUNGLENBQUM7SUFDSCxDQUFDLE1BQU07TUFBQSxJQUFBLGVBQUE7TUFDTCxDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZUFBYixlQUFBLENBQWUsZ0JBQWdCLENBQzdCLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTyw4Q0FBOEMsT0FBTyxxQkFBcUIsQ0FBQyxpQkFBaUIsR0FDbEgsQ0FDRixDQUFDO0lBQ0g7RUFDRjs7RUFFQTtFQUNBLElBQ0UsSUFBQSxrQkFBVyxFQUFDLHFCQUFxQixFQUFFLFFBQVEsQ0FBQyxJQUM1QyxLQUFLLENBQUMsT0FBTyxDQUFDLHFCQUFxQixDQUFDLE1BQU0sQ0FBQyxFQUMzQztJQUNBLHFCQUFxQixDQUFDLE1BQU0sR0FBRyxxQkFBcUIsQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUMvRCxLQUFLLElBQUs7TUFDVCxJQUNFLElBQUEsZUFBUSxFQUFDLEtBQUssQ0FBQyxJQUNmLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUsVUFBVSxDQUFDLElBQzlCLEtBQUssQ0FBQyxRQUFRLEtBQUssSUFBSSxJQUN2QixJQUFBLGtCQUFXLEVBQUMsS0FBSyxFQUFFLFNBQVMsQ0FBQyxFQUM3QjtRQUFBLElBQUEsZUFBQTtRQUNBLENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxlQUFiLGVBQUEsQ0FBZSxjQUFjO1FBQzNCO1FBQ0E7UUFDQSxhQUFhLE9BQU8sOERBQThELEtBQUssQ0FBQyxPQUFPLEVBQ2pHLENBQUM7UUFDRCxPQUFPLEtBQUs7TUFDZDtNQUNBLE9BQU8sSUFBSTtJQUNiLENBQ0YsQ0FBQztFQUNILENBQUMsTUFBTSxJQUFJLElBQUEsa0JBQVcsRUFBQyxxQkFBcUIsRUFBRSxRQUFRLENBQUMsRUFBRTtJQUFBLElBQUEsZUFBQTtJQUN2RCxDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZUFBYixlQUFBLENBQWUsZ0JBQWdCLENBQzdCLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTyxtQ0FBbUMsT0FBTyxxQkFBcUIsQ0FBQyxNQUFNLEdBQzVGLENBQ0YsQ0FBQztFQUNIOztFQUVBO0VBQ0EsSUFDRSxJQUFBLGtCQUFXLEVBQUMscUJBQXFCLEVBQUUsZ0JBQWdCLENBQUMsSUFDcEQsS0FBSyxDQUFDLE9BQU8sQ0FBQyxxQkFBcUIsQ0FBQyxjQUFjLENBQUMsRUFDbkQ7SUFDQSxxQkFBcUIsQ0FBQyxjQUFjLEdBQ2xDLHFCQUFxQixDQUFDLGNBQWMsQ0FBQyxNQUFNLENBQUUsS0FBSyxJQUFLO01BQ3JELElBQ0UsSUFBQSxlQUFRLEVBQUMsS0FBSyxDQUFDLElBQ2YsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSxVQUFVLENBQUMsSUFDOUIsS0FBSyxDQUFDLFFBQVEsS0FBSyxJQUFJLElBQ3ZCLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUsU0FBUyxDQUFDLEVBQzdCO1FBQUEsSUFBQSxlQUFBO1FBQ0EsQ0FBQSxlQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxlQUFBLGVBQWIsZUFBQSxDQUFlLGNBQWM7UUFDM0I7UUFDQTtRQUNBLGFBQWEsT0FBTyxzRUFBc0UsS0FBSyxDQUFDLE9BQU8sRUFDekcsQ0FBQztRQUNELE9BQU8sS0FBSztNQUNkO01BQ0EsT0FBTyxJQUFJO0lBQ2IsQ0FBQyxDQUFDO0VBQ04sQ0FBQyxNQUFNLElBQUksSUFBQSxrQkFBVyxFQUFDLHFCQUFxQixFQUFFLGdCQUFnQixDQUFDLEVBQUU7SUFBQSxJQUFBLGVBQUE7SUFDL0QsQ0FBQSxlQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxlQUFBLGVBQWIsZUFBQSxDQUFlLGdCQUFnQixDQUM3QixJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8sMkNBQTJDLE9BQU8scUJBQXFCLENBQUMsY0FBYyxHQUM1RyxDQUNGLENBQUM7RUFDSDtBQUNGOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUyx3QkFBd0IsQ0FDL0IsZUFBd0MsRUFDeEMsWUFBb0IsRUFDcEI7RUFDQSxNQUFNLFlBQXFDLEdBQUcsQ0FBQyxDQUFDO0VBRWhELEtBQUssTUFBTSxDQUFDLE9BQU8sRUFBRSxRQUFRLENBQUMsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLGVBQWUsQ0FBQyxFQUFFO0lBQ2pFLElBQUksSUFBQSxlQUFRLEVBQUMsUUFBUSxDQUFDLEVBQUU7TUFDdEIsTUFBTSxxQkFBZ0QsR0FBRyxDQUFDLENBQUM7TUFFM0QsS0FBSyxNQUFNLENBQUMsT0FBTyxFQUFFLE1BQU0sQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDLEVBQUU7UUFDeEQsSUFBSSxLQUFLLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxFQUFFO1VBQ3pCO1VBQ0EsTUFBTSxjQUFjLEdBQUcsTUFBTSxDQUFDLE1BQU0sQ0FBRSxLQUFLLElBQUs7WUFDOUMsSUFDRSxJQUFBLGVBQVEsRUFBQyxLQUFLLENBQUMsSUFDZixJQUFBLGtCQUFXLEVBQUMsS0FBSyxFQUFFLFVBQVUsQ0FBQyxJQUM5QixLQUFLLENBQUMsUUFBUSxLQUFLLElBQUksSUFDdkIsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSxTQUFTLENBQUMsRUFDN0I7Y0FBQSxJQUFBLGVBQUE7Y0FDQSxDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZUFBYixlQUFBLENBQWUsY0FBYztjQUMzQjtjQUNBO2NBQ0EsYUFBYSxPQUFPLDZDQUE2QyxZQUFZLGNBQWMsS0FBSyxDQUFDLE9BQU8sRUFDMUcsQ0FBQztjQUNELE9BQU8sS0FBSyxDQUFDLENBQUM7WUFDaEI7WUFDQSxPQUNFLElBQUEsZUFBUSxFQUFDLEtBQUssQ0FBQyxJQUNmLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUsVUFBVSxDQUFDLElBQzlCLEtBQUssQ0FBQyxRQUFRLEtBQUssSUFBSTtVQUUzQixDQUFDLENBQUM7VUFFRixxQkFBcUIsQ0FBQyxPQUFPLENBQUMsR0FBRyxjQUFjO1FBQ2pEO01BQ0Y7TUFFQSxZQUFZLENBQUMsT0FBTyxDQUFDLEdBQUcscUJBQXFCO0lBQy9DO0VBQ0Y7RUFFQSxPQUFPLFlBQVk7QUFDckI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ2hNQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQU9PLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsS0FBSzs7QUFFNUI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUMzQixxQkFBb0MsRUFDWjtFQUN4QixNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUNwQyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUNsQyxPQUFPLGFBQWE7QUFDdEI7QUFFQSxTQUFTLGNBQWMsQ0FBQyxLQUE4QixFQUFRO0VBQzVELElBQ0UsQ0FBQyxJQUFBLGtCQUFXLEVBQUMsS0FBSyxFQUFFLGtCQUFrQixDQUFDLElBQ3ZDLENBQUMsSUFBQSxlQUFRLEVBQUMsS0FBSyxDQUFDLGdCQUFnQixDQUFDLElBQ2pDLENBQUMsSUFBQSxlQUFRLEVBQUMsS0FBSyxDQUFDLGdCQUFnQixDQUFDLFNBQVMsQ0FBQyxFQUMzQztJQUNBO0VBQ0Y7RUFFQSxNQUFNLFFBQVEsR0FBRyxDQUFDLEtBQUssQ0FBQztFQUV4QixLQUFLLE1BQU0sT0FBTyxJQUFJLFFBQVEsRUFBRTtJQUM5QixNQUFNLGdCQUFnQixHQUFHLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDO0lBRWxFLElBQUksSUFBQSxlQUFRLEVBQUMsZ0JBQWdCLENBQUMsRUFBRTtNQUM5QixLQUFLLE1BQU0sQ0FBQyxPQUFPLEVBQUUsTUFBTSxDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxFQUFFO1FBQ2hFLElBQUksS0FBSyxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsRUFBRTtVQUN6QixnQkFBZ0IsQ0FBQyxPQUFPLENBQUMsR0FBRyxNQUFNLENBQUMsTUFBTSxDQUN0QyxLQUFLLElBQ0osQ0FBQSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsT0FBTyxNQUFLLDRDQUN2QixDQUFDO1FBQ0g7TUFDRjtJQUNGO0VBQ0Y7QUFDRjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDcERBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBT08sTUFBTSxPQUFPLEdBQUEsT0FBQSxDQUFBLE9BQUEsR0FBRyxHQUFHOztBQUUxQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUMzQixxQkFBb0MsRUFDWjtFQUN4QixNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUNwQyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUNsQyxPQUFPLGFBQWE7QUFDdEI7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVMsY0FBYyxDQUFDLEtBQThCLEVBQVE7RUFDNUQ7RUFDQSxJQUFJLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUsd0JBQXdCLENBQUMsRUFBRTtJQUNoRCxPQUFPLEtBQUssQ0FBQyxzQkFBc0I7RUFDckM7QUFDRjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDeENBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBT08sTUFBTSxPQUFPLEdBQUEsT0FBQSxDQUFBLE9BQUEsR0FBRyxLQUFLOztBQUU1QjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUMzQixxQkFBb0MsRUFDWjtFQUN4QixNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUVwQyxhQUFhLENBQUMsSUFBSSxHQUFHLGNBQWMsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDO0VBRXZELE9BQU8sYUFBYTtBQUN0QjtBQUVBLFNBQVMsY0FBYyxDQUNyQixLQUE4QixFQUNMO0VBQ3pCLElBQUksQ0FBQyxJQUFBLGtCQUFXLEVBQUMsS0FBSyxFQUFFLG9CQUFvQixDQUFDLEVBQUU7SUFBQSxJQUFBLGNBQUEsRUFBQSxxQkFBQTtJQUM3QyxDQUFBLGNBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGNBQUEsZ0JBQUEscUJBQUEsR0FBYixjQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsY0FBQSxFQUNFLElBQUksS0FBSyxDQUFDLGFBQWEsT0FBTywrQkFBK0IsQ0FDL0QsQ0FBQztJQUNELE9BQU8sS0FBSztFQUNkO0VBRUEsTUFBTSx1QkFBdUIsR0FDM0IsS0FBSyxDQUFDLGtCQUF3RDtFQUNoRSxJQUFJLENBQUMsSUFBQSxlQUFRLEVBQUMsdUJBQXVCLENBQUMsRUFBRTtJQUFBLElBQUEsZUFBQSxFQUFBLHFCQUFBO0lBQ3RDLENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxnQkFBQSxxQkFBQSxHQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxlQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLGlDQUFpQyxPQUFPLHVCQUF1QixxQkFDckYsQ0FDRixDQUFDO0lBQ0QsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxJQUNFLENBQUMsSUFBQSxrQkFBVyxFQUFDLHVCQUF1QixFQUFFLGtCQUFrQixDQUFDLElBQ3pELENBQUMsSUFBQSxlQUFRLEVBQUMsdUJBQXVCLENBQUMsZ0JBQWdCLENBQUMsRUFDbkQ7SUFBQSxJQUFBLGVBQUEsRUFBQSxxQkFBQTtJQUNBLENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxnQkFBQSxxQkFBQSxHQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxlQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLDJEQUN0QixDQUNGLENBQUM7SUFDRCxPQUFPLEtBQUs7RUFDZDtFQUVBLE1BQU07SUFBRTtFQUFpQixDQUFDLEdBQUcsdUJBQXVCO0VBQ3BELElBQ0UsQ0FBQyxJQUFBLGtCQUFXLEVBQUMsZ0JBQWdCLEVBQUUsaUJBQWlCLENBQUMsSUFDakQsT0FBTyxnQkFBZ0IsQ0FBQyxlQUFlLEtBQUssUUFBUSxJQUNwRCxnQkFBZ0IsQ0FBQyxlQUFlLEtBQUssRUFBRSxFQUN2QztJQUFBLElBQUEsZUFBQSxFQUFBLHFCQUFBO0lBQ0EsQ0FBQSxlQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxlQUFBLGdCQUFBLHFCQUFBLEdBQWIsZUFBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGVBQUEsRUFDRSxJQUFJLEtBQUssQ0FBQyxhQUFhLE9BQU8sdUNBQXVDLENBQ3ZFLENBQUM7SUFDRCxPQUFPLEtBQUs7RUFDZDs7RUFFQTtFQUNBLElBQ0UsQ0FBQyxJQUFBLGtCQUFXLEVBQUMsZ0JBQWdCLEVBQUUsVUFBVSxDQUFDLElBQzFDLENBQUMsSUFBQSxlQUFRLEVBQUMsZ0JBQWdCLENBQUMsUUFBUSxDQUFDLEVBQ3BDO0lBQUEsSUFBQSxlQUFBLEVBQUEscUJBQUE7SUFDQSxDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZ0JBQUEscUJBQUEsR0FBYixlQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsZUFBQSxFQUNFLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTyxpREFDdEIsQ0FDRixDQUFDO0lBQ0QsT0FBTyxLQUFLO0VBQ2Q7RUFDQSxNQUFNO0lBQUU7RUFBUyxDQUFDLEdBQUcsZ0JBQWdCO0VBQ3JDLE1BQU0sa0JBQWtCLEdBQUcsZ0JBQWdCLENBQUMsZUFBZTtFQUMzRCxJQUNFLENBQUMsSUFBQSxrQkFBVyxFQUFDLFFBQVEsRUFBRSxrQkFBa0IsQ0FBQyxJQUMxQyxDQUFDLElBQUEsZUFBUSxFQUFDLFFBQVEsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLEVBQ3ZDO0lBQUEsSUFBQSxlQUFBLEVBQUEscUJBQUE7SUFDQSxDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZ0JBQUEscUJBQUEsR0FBYixlQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsZUFBQSxFQUNFLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTyxrRUFDdEIsQ0FDRixDQUFDO0lBQ0QsT0FBTyxLQUFLO0VBQ2Q7RUFDQSxNQUFNLG9CQUFvQixHQUFHLFFBQVEsQ0FBQyxrQkFBa0IsQ0FBQztFQUN6RCxJQUNFLENBQUMsSUFBQSxrQkFBVyxFQUFDLG9CQUFvQixFQUFFLFNBQVMsQ0FBQyxJQUM3QyxPQUFPLG9CQUFvQixDQUFDLE9BQU8sS0FBSyxRQUFRLElBQ2hELG9CQUFvQixDQUFDLE9BQU8sS0FBSyxFQUFFLEVBQ25DO0lBQUEsSUFBQSxlQUFBLEVBQUEscUJBQUE7SUFDQSxDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZ0JBQUEscUJBQUEsR0FBYixlQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsZUFBQSxFQUNFLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTyx5REFDdEIsQ0FDRixDQUFDO0lBQ0QsT0FBTyxLQUFLO0VBQ2Q7RUFDQSxNQUFNLHNCQUFzQixHQUFHLG9CQUFvQixDQUFDLE9BQU87RUFFM0QsSUFBSSxDQUFDLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUsbUJBQW1CLENBQUMsRUFBRTtJQUFBLElBQUEsZUFBQSxFQUFBLHFCQUFBO0lBQzVDLENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxnQkFBQSxxQkFBQSxHQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxlQUFBLEVBQ0UsSUFBSSxLQUFLLENBQUMsYUFBYSxPQUFPLDhCQUE4QixDQUM5RCxDQUFDO0lBQ0QsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxNQUFNLHNCQUFzQixHQUFHLEtBQUssQ0FBQyxpQkFBaUI7RUFDdEQsSUFBSSxDQUFDLElBQUEsZUFBUSxFQUFDLHNCQUFzQixDQUFDLEVBQUU7SUFBQSxJQUFBLGVBQUEsRUFBQSxxQkFBQTtJQUNyQyxDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZ0JBQUEscUJBQUEsR0FBYixlQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsZUFBQSxFQUNFLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTyxnQ0FBZ0MsT0FBTyxzQkFBc0IscUJBQ25GLENBQ0YsQ0FBQztJQUNELE9BQU8sS0FBSztFQUNkO0VBRUEsSUFDRSxDQUFDLElBQUEsa0JBQVcsRUFBQyxzQkFBc0IsRUFBRSx5QkFBeUIsQ0FBQyxJQUMvRCxPQUFPLHNCQUFzQixDQUFDLHVCQUF1QixLQUFLLFFBQVEsSUFDbEUsQ0FBQyxzQkFBc0IsQ0FBQyx1QkFBdUIsRUFDL0M7SUFBQSxJQUFBLGVBQUEsRUFBQSxxQkFBQTtJQUNBLENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxnQkFBQSxxQkFBQSxHQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxlQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLCtDQUN0QixDQUNGLENBQUM7SUFDRCxPQUFPLEtBQUs7RUFDZDtFQUVBLE1BQU07SUFBRTtFQUF3QixDQUFDLEdBQUcsc0JBQXNCO0VBRTFELElBQ0UsQ0FBQyxJQUFBLGtCQUFXLEVBQUMsc0JBQXNCLEVBQUUsZ0NBQWdDLENBQUMsSUFDdEUsQ0FBQyxJQUFBLGVBQVEsRUFBQyxzQkFBc0IsQ0FBQyw4QkFBOEIsQ0FBQyxFQUNoRTtJQUFBLElBQUEsZUFBQSxFQUFBLHFCQUFBO0lBQ0EsQ0FBQSxlQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxlQUFBLGdCQUFBLHFCQUFBLEdBQWIsZUFBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGVBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8sc0RBQ3RCLENBQ0YsQ0FBQztJQUNELE9BQU8sS0FBSztFQUNkO0VBRUEsTUFBTTtJQUFFO0VBQStCLENBQUMsR0FBRyxzQkFBc0I7RUFFakUsTUFBTSxjQUFjLEdBQUcsNEJBQTRCLENBQ2pELDhCQUE4QixFQUM5Qix1QkFDRixDQUFDO0VBRUQsSUFBSSxDQUFDLGNBQWMsRUFBRTtJQUFBLElBQUEsZ0JBQUEsRUFBQSxxQkFBQTtJQUNuQixDQUFBLGdCQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxnQkFBQSxnQkFBQSxxQkFBQSxHQUFiLGdCQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsZ0JBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8saURBQWlELHVCQUF1QixJQUM5RixDQUNGLENBQUM7SUFDRCxPQUFPLEtBQUs7RUFDZDtFQUVBLElBQUksQ0FBQyxJQUFBLGtCQUFXLEVBQUMsS0FBSyxFQUFFLGtCQUFrQixDQUFDLEVBQUU7SUFBQSxJQUFBLGdCQUFBLEVBQUEscUJBQUE7SUFDM0MsQ0FBQSxnQkFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZ0JBQUEsZ0JBQUEscUJBQUEsR0FBYixnQkFBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGdCQUFBLEVBQ0UsSUFBSSxLQUFLLENBQUMsYUFBYSxPQUFPLDZCQUE2QixDQUM3RCxDQUFDO0lBQ0QsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxNQUFNLHFCQUFxQixHQUFHLEtBQUssQ0FBQyxnQkFBZ0I7RUFDcEQsSUFBSSxDQUFDLElBQUEsZUFBUSxFQUFDLHFCQUFxQixDQUFDLEVBQUU7SUFBQSxJQUFBLGdCQUFBLEVBQUEscUJBQUE7SUFDcEMsQ0FBQSxnQkFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZ0JBQUEsZ0JBQUEscUJBQUEsR0FBYixnQkFBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGdCQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLCtCQUErQixPQUFPLHFCQUFxQixxQkFDakYsQ0FDRixDQUFDO0lBQ0QsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxJQUNFLENBQUMsSUFBQSxrQkFBVyxFQUFDLHFCQUFxQixFQUFFLFdBQVcsQ0FBQyxJQUNoRCxDQUFDLElBQUEsZUFBUSxFQUFDLHFCQUFxQixDQUFDLFNBQVMsQ0FBQyxFQUMxQztJQUFBLElBQUEsZ0JBQUEsRUFBQSxxQkFBQTtJQUNBLENBQUEsZ0JBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGdCQUFBLGdCQUFBLHFCQUFBLEdBQWIsZ0JBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxnQkFBQSxFQUNFLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTyxrREFDdEIsQ0FDRixDQUFDO0lBQ0QsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxNQUFNO0lBQUU7RUFBTyxDQUFDLEdBQUcscUJBQXFCO0VBQ3hDLE1BQU07SUFBRTtFQUFVLENBQUMsR0FBRyxxQkFBcUI7RUFDM0MsTUFBTSxpQkFBaUIsR0FBRyxTQUFTLENBQUMsY0FBYyxDQUFDO0VBRW5ELElBQ0UsS0FBSyxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsSUFDckIsTUFBTSxDQUFDLE1BQU0sR0FBRyxDQUFDLElBQ2pCLENBQUMsSUFBQSxlQUFRLEVBQUMsaUJBQWlCLENBQUMsRUFDNUI7SUFBQSxJQUFBLGdCQUFBLEVBQUEscUJBQUE7SUFDQSxDQUFBLGdCQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxnQkFBQSxnQkFBQSxxQkFBQSxHQUFiLGdCQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsZ0JBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8seUVBQ3RCLENBQ0YsQ0FBQztJQUNELE9BQU8sS0FBSztFQUNkO0VBRUEsSUFBSSxDQUFDLElBQUEsZUFBUSxFQUFDLGlCQUFpQixDQUFDLEVBQUU7SUFDaEMsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxNQUFNLGFBQWEsR0FBRyxpQkFBaUIsQ0FBQyxzQkFBc0IsQ0FBQztFQUMvRCxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxhQUFhLENBQUMsRUFBRTtJQUNqQyxPQUFPLEtBQUs7RUFDZDtFQUVBLHFCQUFxQixDQUFDLE1BQU0sR0FBRyxhQUFhO0VBQzVDLE9BQU8sS0FBSztBQUNkO0FBRUEsU0FBUyw0QkFBNEIsQ0FDbkMsOEJBQW9FLEVBQ3BFLGVBQXVCLEVBQ0g7RUFBQSxJQUFBLGdCQUFBLEVBQUEscUJBQUE7RUFDcEIsS0FBSyxNQUFNLENBQUMsT0FBTyxFQUFFLG9CQUFvQixDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FDMUQsOEJBQ0YsQ0FBQyxFQUFFO0lBQ0QsSUFBSSxLQUFLLENBQUMsT0FBTyxDQUFDLG9CQUFvQixDQUFDLFlBQVksQ0FBQyxFQUFFO01BQ3BELEtBQUssTUFBTSxRQUFRLElBQUksb0JBQW9CLENBQUMsWUFBWSxFQUFFO1FBQ3hELElBQUksUUFBUSxDQUFDLGVBQWUsS0FBSyxlQUFlLEVBQUU7VUFDaEQsT0FBTyxPQUFPO1FBQ2hCO01BQ0Y7SUFDRjtFQUNGO0VBQ0EsQ0FBQSxnQkFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZ0JBQUEsZ0JBQUEscUJBQUEsR0FBYixnQkFBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGdCQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLDJCQUEyQixlQUFlLElBQ2hFLENBQ0YsQ0FBQztFQUNELE9BQU8sU0FBUztBQUNsQjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDclFBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBT08sTUFBTSxPQUFPLEdBQUEsT0FBQSxDQUFBLE9BQUEsR0FBRyxHQUFHOztBQUUxQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FDM0IscUJBQW9DLEVBQ1o7RUFDeEIsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsY0FBYyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7RUFDbEMsT0FBTyxhQUFhO0FBQ3RCO0FBRUEsU0FBUyxjQUFjLENBQ3JCLEtBQThCLEVBQ0w7RUFDekIsSUFDRSxJQUFBLGtCQUFXLEVBQUMsS0FBSyxFQUFFLG9CQUFvQixDQUFDLElBQ3hDLElBQUEsZUFBUSxFQUFDLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUNsQyxJQUFBLGtCQUFXLEVBQUMsS0FBSyxDQUFDLGtCQUFrQixFQUFFLGNBQWMsQ0FBQyxFQUNyRDtJQUNBLE9BQU8sQ0FBQyxHQUFHLENBQUMsK0NBQStDLENBQUM7SUFDNUQsT0FBTyxLQUFLLENBQUMsa0JBQWtCLENBQUMsWUFBWTtFQUM5QztFQUNBLE9BQU8sS0FBSztBQUNkOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUN4Q0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLHNCQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsY0FBQSxHQUFBLE9BQUE7QUF5Qk8sTUFBTSxPQUFPLEdBQUEsT0FBQSxDQUFBLE9BQUEsR0FBRyxHQUFHO0FBRTFCLFNBQVMsY0FBYyxDQUFDLEtBQTRCLEVBQUU7RUFBQSxJQUFBLHFCQUFBLEVBQUEscUJBQUE7RUFDcEQ7RUFDQSxNQUFNLGFBQWEsR0FBRyxJQUFBLCtCQUFnQixFQUFDLENBQUM7RUFDeEMsSUFBSSxFQUFBLHFCQUFBLEdBQUEsYUFBYSxDQUFDLE9BQU8sY0FBQSxxQkFBQSx1QkFBckIscUJBQUEsQ0FBdUIsZ0NBQWdDLE1BQUssSUFBSSxFQUFFO0lBQ3BFO0lBQ0EsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxJQUNFLENBQUMsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSx1QkFBdUIsQ0FBQyxJQUM1QyxDQUFDLElBQUEsZUFBUSxFQUFDLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxFQUN0QztJQUFBLElBQUEsY0FBQSxFQUFBLHFCQUFBO0lBQ0EsQ0FBQSxjQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxjQUFBLGdCQUFBLHFCQUFBLEdBQWIsY0FBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGNBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCx3Q0FBd0MsT0FBTyxLQUFLLENBQUMscUJBQXFCLEVBQzVFLENBQ0YsQ0FBQztJQUNELE9BQU8sS0FBSztFQUNkO0VBRUEsTUFBTTtJQUFFO0VBQXNCLENBQUMsR0FBRyxLQUFLO0VBQ3ZDLE1BQU0sa0JBQWtCLElBQUEscUJBQUEsR0FDdEIscUJBQXFCLENBQUMsV0FBVyxjQUFBLHFCQUFBLHVCQUFqQyxxQkFBQSxDQUFtQyw0QkFBNEI7RUFFakUsSUFDRSxrQkFBa0IsS0FBSyxTQUFTLElBQy9CLGtCQUFrQixLQUFLLEtBQUssSUFBSSxDQUFDLDRCQUE0QixDQUFDLEtBQUssQ0FBRSxFQUN0RTtJQUNBLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxXQUFXLEdBQUc7TUFDeEMsR0FBRyxLQUFLLENBQUMscUJBQXFCLENBQUMsV0FBVztNQUMxQyw0QkFBNEIsRUFBRSxJQUFJO01BQ2xDLGlDQUFpQyxFQUFFO0lBQ3JDLENBQUM7RUFDSCxDQUFDLE1BQU07SUFDTCxLQUFLLENBQUMscUJBQXFCLENBQUMsV0FBVyxHQUFHO01BQ3hDLEdBQUcsS0FBSyxDQUFDLHFCQUFxQixDQUFDLFdBQVc7TUFDMUMsaUNBQWlDLEVBQUUsS0FBSyxDQUFFO0lBQzVDLENBQUM7RUFDSDtFQUVBLE9BQU8sS0FBSztBQUNkO0FBRUEsU0FBUyw0QkFBNEIsQ0FBQyxLQUE0QixFQUFXO0VBQUEsSUFBQSxxQkFBQTtFQUMzRSxNQUFNLGlCQUFpQixHQUNyQixLQUFLLGFBQUwsS0FBSyxnQkFBQSxxQkFBQSxHQUFMLEtBQUssQ0FBRSwyQkFBMkIsY0FBQSxxQkFBQSxnQkFBQSxxQkFBQSxHQUFsQyxxQkFBQSxDQUFvQyxzQkFBc0IsY0FBQSxxQkFBQSx1QkFBMUQscUJBQUEsQ0FDSSxpQkFBaUI7RUFFdkIsSUFBSSxDQUFDLElBQUEsZUFBUSxFQUFDLGlCQUFpQixDQUFDLEVBQUU7SUFDaEMsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxPQUFPLENBQUMsaUJBQWlCLENBQUMsZ0NBQVMsQ0FBQyxPQUFPLENBQUMsSUFBSSxFQUFFLEVBQUUsTUFBTSxHQUFHLENBQUM7QUFDaEU7QUFFTyxlQUFlLE9BQU8sQ0FDM0IscUJBQW9DLEVBQ1o7RUFDeEIsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsY0FBYyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7RUFDbEMsT0FBTyxhQUFhO0FBQ3RCOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUM3RkEsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFNTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEdBQUc7QUFDMUI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sZUFBZSxPQUFPLENBQzNCLHFCQUFvQyxFQUNaO0VBQ3hCLE1BQU0sYUFBYSxHQUFHLElBQUEsaUJBQVMsRUFBQyxxQkFBcUIsQ0FBQztFQUN0RCxhQUFhLENBQUMsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPO0VBQ3BDLGNBQWMsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDO0VBQ2xDLE9BQU8sYUFBYTtBQUN0QjtBQUNBLFNBQVMsY0FBYyxDQUNyQixLQUE4QixFQUNMO0VBQ3pCLElBQ0UsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSx1QkFBdUIsQ0FBQyxJQUMzQyxJQUFBLGVBQVEsRUFBQyxLQUFLLENBQUMscUJBQXFCLENBQUMsSUFDckMsSUFBQSxrQkFBVyxFQUFDLEtBQUssQ0FBQyxxQkFBcUIsRUFBRSxpQkFBaUIsQ0FBQyxFQUMzRDtJQUNBLE9BQU8sS0FBSyxDQUFDLHFCQUFxQixDQUFDLGVBQWU7RUFDcEQ7RUFDQSxPQUFPLEtBQUs7QUFDZDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDcENBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFTTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEdBQUc7QUFFMUIsU0FBUyxjQUFjLENBQUMsS0FBNEIsRUFBRTtFQUNwRCxPQUFPLEtBQUs7QUFDZDs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUMzQixxQkFBb0MsRUFDWjtFQUN4QixNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUNwQyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUNsQyxPQUFPLGFBQWE7QUFDdEI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ2hDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQU9PLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsR0FBRzs7QUFFMUI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sZUFBZSxPQUFPLENBQzNCLHFCQUFvQyxFQUNaO0VBQ3hCLE1BQU0sYUFBYSxHQUFHLElBQUEsaUJBQVMsRUFBQyxxQkFBcUIsQ0FBQztFQUN0RCxhQUFhLENBQUMsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPO0VBQ3BDLGNBQWMsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDO0VBQ2xDLE9BQU8sYUFBYTtBQUN0QjtBQUVBLFNBQVMsY0FBYyxDQUFDLEtBQThCLEVBQUU7RUFDdEQsTUFBTSwwQkFBMEIsR0FBRyxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUscUJBRTdCO0VBRWIsTUFBTSxXQUFXLEdBQUcsMEJBQTBCLGFBQTFCLDBCQUEwQix1QkFBMUIsMEJBQTBCLENBQUUsV0FFbkM7RUFFYixJQUNFLFdBQVcsSUFDWCxJQUFBLGtCQUFXLEVBQUMsV0FBVyxFQUFFLCtCQUErQixDQUFDLEVBQ3pEO0lBQ0EsT0FBTyxXQUFXLENBQUMsNkJBQTZCO0VBQ2xEO0FBQ0Y7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQzlDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBUUEsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQVlPLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsR0FBRzs7QUFFMUI7QUFDQSxNQUFNLGdCQUFnQixHQUFHLGtCQUFrQjtBQUMzQyxNQUFNLDZCQUE2QixHQUFHLGtCQUFrQjs7QUFleEQ7O0FBT0EsTUFBTSxlQUFlLEdBQUc7RUFDdEI7RUFDQTtFQUNBLFlBQVksRUFBRSxjQUFjO0VBQzVCLGVBQWUsRUFBRTtBQUNuQixDQUFVOztBQUVWO0FBQ0E7QUFDQSxNQUFNLGlCQUEyQyxHQUFHLElBQUksR0FBRyxDQUFDLENBQzFELENBQUMsU0FBUyxFQUFFLFVBQVUsQ0FBQyxFQUN2QixDQUFDLFNBQVMsRUFBRSxLQUFLLENBQUMsRUFDbEIsQ0FBQyxlQUFlLEVBQUUsUUFBUSxDQUFDLEVBQzNCLENBQUMsZUFBZSxFQUFFLFFBQVEsQ0FBQyxDQUM1QixDQUFDO0FBRUYsTUFBTSxhQUFhLEdBQUcsQ0FBQyxNQUFNLEVBQUUsUUFBUSxDQUFVO0FBRWpELFNBQVMsc0JBQXNCLENBQUMsR0FBWSxFQUErQjtFQUN6RSxPQUNFLElBQUEsZUFBUSxFQUFDLEdBQUcsQ0FBQyxJQUNiLEdBQUcsS0FBSyxJQUFJLElBQ1osSUFBQSxrQkFBVyxFQUFDLEdBQUcsRUFBRSxTQUFTLENBQUMsSUFDM0IsS0FBSyxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDLElBQzFCLEdBQUcsQ0FBQyxPQUFPLENBQUMsTUFBTSxHQUFHLENBQUMsSUFDdEIsSUFBQSxrQkFBVyxFQUFDLEdBQUcsRUFBRSxNQUFNLENBQUMsSUFDeEIsT0FBTyxHQUFHLENBQUMsSUFBSSxLQUFLLFFBQVEsSUFDNUIsSUFBQSxrQkFBVyxFQUFDLEdBQUcsRUFBRSxJQUFJLENBQUMsSUFDdEIsT0FBTyxHQUFHLENBQUMsRUFBRSxLQUFLLFFBQVEsSUFDMUIsSUFBQSxrQkFBVyxFQUFDLEdBQUcsRUFBRSxTQUFTLENBQUMsSUFDM0IsT0FBTyxHQUFHLENBQUMsT0FBTyxLQUFLLFFBQVEsSUFDL0IsSUFBQSxrQkFBVyxFQUFDLEdBQUcsRUFBRSxrQkFBa0IsQ0FBQyxJQUNwQyxPQUFPLEdBQUcsQ0FBQyxnQkFBZ0IsS0FBSyxRQUFRO0FBRTVDO0FBRUEsU0FBUyx3QkFBd0IsQ0FBQyxHQUFZLEVBQWdDO0VBQzVFLE9BQ0UsS0FBSyxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsSUFDbEIsR0FBRyxDQUFDLE1BQU0sR0FBRyxDQUFDLElBQ2QsR0FBRyxDQUFDLEtBQUssQ0FBRSxJQUFJLElBQUssT0FBTyxJQUFJLEtBQUssUUFBUSxDQUFDO0FBRWpEOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUMzQixxQkFBb0MsRUFDWjtFQUN4QixNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUVwQyxNQUFNLFFBQVEsR0FBRyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUNuRCxhQUFhLENBQUMsSUFBSSxHQUFHLFFBQW1DO0VBQ3hELE9BQU8sYUFBYTtBQUN0QjtBQUVBLFNBQVMsY0FBYyxDQUFDLFFBQWlDLEVBQUU7RUFDekQsTUFBTSxRQUFRLEdBQUcsSUFBQSxpQkFBUyxFQUFDLFFBQVEsQ0FBQztFQUNwQyxJQUFJLENBQUMsSUFBQSxrQkFBVyxFQUFDLFFBQVEsRUFBRSxzQkFBc0IsQ0FBQyxFQUFFO0lBQ2xELE9BQU8sUUFBUTtFQUNqQjtFQUVBLElBQUksQ0FBQyxJQUFBLGVBQVEsRUFBQyxRQUFRLENBQUMsb0JBQW9CLENBQUMsRUFBRTtJQUFBLElBQUEsY0FBQSxFQUFBLHFCQUFBO0lBQzVDLENBQUEsY0FBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsY0FBQSxnQkFBQSxxQkFBQSxHQUFiLGNBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxjQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLDBDQUEwQyxPQUFPLFFBQVEsQ0FBQyxvQkFBb0IsRUFDcEcsQ0FDRixDQUFDO0lBQ0QsT0FBTyxRQUFRO0VBQ2pCO0VBRUEsSUFDRSxDQUFDLElBQUEsa0JBQVcsRUFBQyxRQUFRLEVBQUUsbUJBQW1CLENBQUMsSUFDM0MsQ0FBQyxJQUFBLGVBQVEsRUFBQyxRQUFRLENBQUMsaUJBQWlCLENBQUMsRUFDckM7SUFBQSxJQUFBLGVBQUEsRUFBQSxxQkFBQTtJQUNBLENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxnQkFBQSxxQkFBQSxHQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxlQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLHVDQUF1QyxPQUFPLFFBQVEsQ0FBQyxpQkFBaUIsRUFDOUYsQ0FDRixDQUFDO0lBQ0QsT0FBTyxRQUFRO0VBQ2pCO0VBRUEsSUFBSSxDQUFDLElBQUEsa0JBQVcsRUFBQyxRQUFRLEVBQUUsMkJBQTJCLENBQUMsRUFBRTtJQUN2RCxPQUFPLENBQUMsSUFBSSxDQUNWLGFBQWEsT0FBTywrQ0FBK0MsT0FBTyxRQUFRLENBQUMseUJBQXlCLEVBQzlHLENBQUM7SUFDRDtJQUNBO0lBQ0EsUUFBUSxDQUFDLHlCQUF5QixHQUFHO01BQ25DLE9BQU8sRUFBRSxDQUFDO0lBQ1osQ0FBQztFQUNIO0VBRUEsSUFBSSxDQUFDLElBQUEsZUFBUSxFQUFDLFFBQVEsQ0FBQyx5QkFBeUIsQ0FBQyxFQUFFO0lBQUEsSUFBQSxlQUFBLEVBQUEscUJBQUE7SUFDakQsQ0FBQSxlQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxlQUFBLGdCQUFBLHFCQUFBLEdBQWIsZUFBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGVBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8sK0NBQStDLE9BQU8sUUFBUSxDQUFDLHlCQUF5QixFQUM5RyxDQUNGLENBQUM7SUFDRCxPQUFPLFFBQVE7RUFDakI7RUFFQSxNQUFNO0lBQ0osaUJBQWlCLEVBQUU7TUFDakIsdUJBQXVCO01BQ3ZCO0lBQ0YsQ0FBQztJQUNELG9CQUFvQixFQUFFO01BQUU7SUFBUztFQUNuQyxDQUFDLEdBQUcsUUFBUTtFQUVaLElBQUksQ0FBQyxJQUFBLGVBQVEsRUFBQyxRQUFRLENBQUMsRUFBRTtJQUFBLElBQUEsZUFBQSxFQUFBLHFCQUFBO0lBQ3ZCLENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxnQkFBQSxxQkFBQSxHQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxlQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLG1EQUFtRCxPQUFPLFFBQVEsRUFDeEYsQ0FDRixDQUFDO0lBQ0QsT0FBTyxRQUFRO0VBQ2pCO0VBRUEsSUFBSSxDQUFDLHVCQUF1QixJQUFJLE9BQU8sdUJBQXVCLEtBQUssUUFBUSxFQUFFO0lBQUEsSUFBQSxlQUFBLEVBQUEscUJBQUE7SUFDM0UsQ0FBQSxlQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxlQUFBLGdCQUFBLHFCQUFBLEdBQWIsZUFBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGVBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8sK0RBQStELE9BQU8sdUJBQXVCLEVBQ25ILENBQ0YsQ0FBQztJQUNELE9BQU8sUUFBUTtFQUNqQjtFQUVBLElBQUksQ0FBQyxJQUFBLGVBQVEsRUFBQyw4QkFBOEIsQ0FBQyxFQUFFO0lBQUEsSUFBQSxlQUFBLEVBQUEscUJBQUE7SUFDN0MsQ0FBQSxlQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxlQUFBLGdCQUFBLHFCQUFBLEdBQWIsZUFBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGVBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8sc0VBQXNFLE9BQU8sUUFBUSxDQUN0RyxpQkFBaUIsQ0FBQyw4QkFBOEIsRUFDckQsQ0FDRixDQUFDO0lBQ0QsT0FBTyxRQUFRO0VBQ2pCO0VBRUEsSUFDRSxDQUFDLElBQUEsa0JBQVcsRUFBQyxRQUFRLENBQUMseUJBQXlCLEVBQUUsU0FBUyxDQUFDLElBQzNELENBQUMsSUFBQSxlQUFRLEVBQUMsUUFBUSxDQUFDLHlCQUF5QixDQUFDLE9BQU8sQ0FBQyxFQUNyRDtJQUFBLElBQUEsZUFBQSxFQUFBLHFCQUFBO0lBQ0EsTUFBTTtNQUFFO0lBQVEsQ0FBQyxHQUFHLFFBQVEsQ0FBQyx5QkFBeUI7SUFDdEQsQ0FBQSxlQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxlQUFBLGdCQUFBLHFCQUFBLEdBQWIsZUFBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGVBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8sdURBQXVELE9BQU8sT0FBTyxFQUMzRixDQUNGLENBQUM7SUFDRCxPQUFPLFFBQVE7RUFDakI7RUFFQSxNQUFNO0lBQUU7RUFBUSxDQUFDLEdBQUcsUUFBUSxDQUFDLHlCQUF5QjtFQUV0RCxNQUFNLDRCQUE0QixHQUFHLENBQ25DLGVBQXVCLEVBQ3ZCLFlBQW9CLEtBQ0c7SUFDdkIsSUFBSSx1QkFBdUIsR0FBRyxLQUFLO0lBQ25DLElBQUksZUFBbUM7SUFDdkMsS0FBSyxNQUFNLENBQUMsT0FBTyxFQUFFLG9CQUFvQixDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FDMUQsOEJBQ0YsQ0FBQyxFQUFFO01BQ0QsSUFBSSxDQUFDLElBQUEsZUFBUSxFQUFDLG9CQUFvQixDQUFDLEVBQUU7UUFBQSxJQUFBLGVBQUE7UUFDbkMsQ0FBQSxlQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxlQUFBLGVBQWIsZUFBQSxDQUFlLGdCQUFnQixDQUM3QixJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8sb0VBQW9FLE9BQU8sU0FBUyxPQUFPLG9CQUFvQixFQUNySSxDQUNGLENBQUM7UUFDRCx1QkFBdUIsR0FBRyxJQUFJO1FBQzlCO01BQ0Y7TUFDQSxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxvQkFBb0IsQ0FBQyxZQUFZLENBQUMsRUFBRTtRQUFBLElBQUEsZUFBQTtRQUNyRCxDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZUFBYixlQUFBLENBQWUsZ0JBQWdCLENBQzdCLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTyxvRUFBb0UsT0FBTyxzQkFBc0IsT0FBTyxvQkFBb0IsQ0FBQyxZQUFZLEVBQy9KLENBQ0YsQ0FBQztRQUNELHVCQUF1QixHQUFHLElBQUk7UUFDOUI7TUFDRjtNQUVBLEtBQUssTUFBTSxXQUFXLElBQUksb0JBQW9CLENBQUMsWUFBWSxFQUFFO1FBQzNELElBQUksQ0FBQyxJQUFBLGVBQVEsRUFBQyxXQUFXLENBQUMsRUFBRTtVQUFBLElBQUEsZUFBQTtVQUMxQixDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZUFBYixlQUFBLENBQWUsZ0JBQWdCLENBQzdCLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTyxvRUFBb0UsT0FBTyx3QkFBd0IsT0FBTyxXQUFXLEVBQzNJLENBQ0YsQ0FBQztVQUNELHVCQUF1QixHQUFHLElBQUk7VUFDOUI7UUFDRjtRQUVBLElBQUksV0FBVyxDQUFDLGVBQWUsS0FBSyxlQUFlLEVBQUU7VUFDbkQsZUFBZSxHQUFHLE9BQU87UUFDM0I7TUFDRjtJQUNGO0lBQ0EsSUFBSSx1QkFBdUIsRUFBRTtNQUMzQixPQUFPLFNBQVM7SUFDbEI7SUFFQSxJQUFJLGVBQWUsRUFBRTtNQUNuQixPQUFPLGVBQWU7SUFDeEI7SUFFQSxNQUFNLGNBQWMsR0FBRyxpQkFBaUIsQ0FBQyxHQUFHLENBQUMsZUFBZSxDQUFDO0lBQzdELElBQUksQ0FBQyxjQUFjLEVBQUU7TUFBQSxJQUFBLGVBQUE7TUFDbkIsQ0FBQSxlQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxlQUFBLGVBQWIsZUFBQSxDQUFlLGdCQUFnQixDQUM3QixJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8sMEJBQTBCLFlBQVksS0FBSyxlQUFlLEdBQ2hGLENBQ0YsQ0FBQztJQUNIO0lBQ0EsT0FBTyxjQUFjO0VBQ3ZCLENBQUM7RUFFRCxNQUFNLGNBQWMsR0FBRyw0QkFBNEIsQ0FDakQsdUJBQXVCLEVBQ3ZCLHlCQUNGLENBQUM7RUFDRCxJQUFJLENBQUMsY0FBYyxFQUFFO0lBQ25CLE9BQU8sUUFBUTtFQUNqQjs7RUFFQTtFQUNBLEtBQUssTUFBTSxDQUFDLE1BQU0sRUFBRSxPQUFPLENBQUMsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLFFBQVEsQ0FBQyxFQUFFO0lBQUEsSUFBQSxxQkFBQTtJQUN4RCxJQUFJLENBQUMsSUFBQSxlQUFRLEVBQUMsT0FBTyxDQUFDLEVBQUU7TUFBQSxJQUFBLGdCQUFBLEVBQUEscUJBQUE7TUFDdEIsQ0FBQSxnQkFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZ0JBQUEsZ0JBQUEscUJBQUEsR0FBYixnQkFBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGdCQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLGlDQUFpQyxNQUFNLGFBQWEsT0FBTyxPQUFPLEVBQ3hGLENBQ0YsQ0FBQztNQUNELE9BQU8sUUFBUTtJQUNqQjtJQUVBLElBQ0UsQ0FBQyxJQUFBLGtCQUFXLEVBQUMsT0FBTyxFQUFFLGFBQWEsQ0FBQyxJQUNwQyxDQUFDLElBQUEsZUFBUSxFQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsRUFDOUI7TUFBQSxJQUFBLGdCQUFBLEVBQUEscUJBQUE7TUFDQSxDQUFBLGdCQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxnQkFBQSxnQkFBQSxxQkFBQSxHQUFiLGdCQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsZ0JBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8scUNBQXFDLE1BQU0sYUFBYSxPQUFPLE9BQU8sQ0FBQyxXQUFXLEVBQ3hHLENBQ0YsQ0FBQztNQUNELE9BQU8sUUFBUTtJQUNqQjtJQUVBLE1BQU07TUFBRTtJQUFZLENBQUMsR0FBRyxPQUFPO0lBRS9CLElBQUksY0FBZ0Q7SUFFcEQsSUFBSSxXQUFxQixHQUFHLEVBQUU7SUFDOUIsTUFBTSxxQkFBcUIsR0FBRyxXQUFXLENBQUMsZUFBZSxDQUFDLFlBQVksQ0FBQztJQUN2RSxNQUFNLHlCQUF5QixHQUM3QixXQUFXLENBQUMsZUFBZSxDQUFDLGVBQWUsQ0FBQzs7SUFFOUM7SUFDQTtJQUNBLElBQUksQ0FBQyxxQkFBcUIsRUFBRTtNQUMxQixPQUFPLFdBQVcsQ0FBQyxlQUFlLENBQUMsZUFBZSxDQUFDO01BQ25EO0lBQ0Y7SUFDQSxJQUFJLENBQUMsc0JBQXNCLENBQUMscUJBQXFCLENBQUMsRUFBRTtNQUFBLElBQUEsZ0JBQUEsRUFBQSxxQkFBQTtNQUNsRCxDQUFBLGdCQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxnQkFBQSxnQkFBQSxxQkFBQSxHQUFiLGdCQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsZ0JBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8saURBQWlELE1BQU0saUJBQ3pFLGVBQWUsQ0FBQyxZQUFZLE1BQ3hCLElBQUksQ0FBQyxTQUFTLENBQUMscUJBQXFCLENBQUMsRUFDN0MsQ0FDRixDQUFDO01BQ0QsT0FBTyxRQUFRO0lBQ2pCO0lBQ0EsTUFBTSxtQkFBbUIsSUFBQSxxQkFBQSxHQUFHLHFCQUFxQixDQUFDLE9BQU8sY0FBQSxxQkFBQSxnQkFBQSxxQkFBQSxHQUE3QixxQkFBQSxDQUFnQyxDQUFDLENBQUMsY0FBQSxxQkFBQSx1QkFBbEMscUJBQUEsQ0FBb0MsS0FBSztJQUNyRSxJQUFJLENBQUMsd0JBQXdCLENBQUMsbUJBQW1CLENBQUMsRUFBRTtNQUFBLElBQUEsZ0JBQUEsRUFBQSxxQkFBQSxFQUFBLHNCQUFBO01BQ2xELENBQUEsZ0JBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGdCQUFBLGdCQUFBLHFCQUFBLEdBQWIsZ0JBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxnQkFBQSxFQUNFLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTyxpREFBaUQsTUFBTSxpQkFDekUsZUFBZSxDQUFDLFlBQVksOEJBQ0EsU0FBQSxzQkFBQSxHQUFPLHFCQUFxQixDQUN2RCxPQUFPLGNBQUEsc0JBQUEsZ0JBQUEsc0JBQUEsR0FEMkIsc0JBQUEsQ0FDeEIsQ0FBQyxDQUFDLGNBQUEsc0JBQUEsdUJBRHNCLHNCQUFBLENBQ3BCLEtBQUssR0FDeEIsQ0FDRixDQUFDO01BQ0QsT0FBTyxRQUFRO0lBQ2pCO0lBQ0EsV0FBVyxHQUFHLG1CQUFtQjtJQUNqQyxjQUFjLEdBQUcscUJBQXFCO0lBRXRDLE9BQU8sV0FBVyxDQUFDLGVBQWUsQ0FBQyxZQUFZLENBQUM7SUFFaEQsSUFBSSxRQUFrQixHQUFHLEVBQUU7SUFDM0I7SUFDQSxJQUFJLHlCQUF5QixFQUFFO01BQUEsSUFBQSxxQkFBQTtNQUM3QixJQUFJLENBQUMsc0JBQXNCLENBQUMseUJBQXlCLENBQUMsRUFBRTtRQUFBLElBQUEsZ0JBQUEsRUFBQSxxQkFBQTtRQUN0RCxDQUFBLGdCQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxnQkFBQSxnQkFBQSxxQkFBQSxHQUFiLGdCQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsZ0JBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8saURBQWlELE1BQU0saUJBQ3pFLGVBQWUsQ0FBQyxlQUFlLE1BQzNCLElBQUksQ0FBQyxTQUFTLENBQUMseUJBQXlCLENBQUMsRUFDakQsQ0FDRixDQUFDO1FBQ0QsT0FBTyxRQUFRO01BQ2pCO01BQ0EsTUFBTSxpQkFBaUIsSUFBQSxxQkFBQSxHQUFHLHlCQUF5QixDQUFDLE9BQU8sY0FBQSxxQkFBQSxnQkFBQSxxQkFBQSxHQUFqQyxxQkFBQSxDQUFvQyxDQUFDLENBQUMsY0FBQSxxQkFBQSx1QkFBdEMscUJBQUEsQ0FBd0MsS0FBSztNQUN2RSxJQUFJLENBQUMsd0JBQXdCLENBQUMsaUJBQWlCLENBQUMsRUFBRTtRQUFBLElBQUEsZ0JBQUEsRUFBQSxxQkFBQSxFQUFBLHNCQUFBO1FBQ2hELENBQUEsZ0JBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGdCQUFBLGdCQUFBLHFCQUFBLEdBQWIsZ0JBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxnQkFBQSxFQUNFLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTyxpREFBaUQsTUFBTSxpQkFDekUsZUFBZSxDQUFDLGVBQWUsOEJBQ0gsU0FBQSxzQkFBQSxHQUFPLHlCQUF5QixDQUMzRCxPQUFPLGNBQUEsc0JBQUEsZ0JBQUEsc0JBQUEsR0FEMkIsc0JBQUEsQ0FDeEIsQ0FBQyxDQUFDLGNBQUEsc0JBQUEsdUJBRHNCLHNCQUFBLENBQ3BCLEtBQUssR0FDeEIsQ0FDRixDQUFDO1FBQ0QsT0FBTyxRQUFRO01BQ2pCO01BQ0EsUUFBUSxHQUFHLGlCQUFpQjtNQUM1QixjQUFjLEtBQWQsY0FBYyxHQUFLLHlCQUF5QjtNQUM1QyxPQUFPLFdBQVcsQ0FBQyxlQUFlLENBQUMsZUFBZSxDQUFDO0lBQ3JEO0lBRUEsSUFBSSxRQUFRLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtNQUN6QixRQUFRLEdBQUcsQ0FBQyxjQUFjLENBQUM7TUFFM0IsTUFBTSx3QkFBd0IsR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDO01BQ2hELElBQ0Usd0JBQXdCLElBQ3hCLE9BQU8sd0JBQXdCLEtBQUssUUFBUSxFQUM1QztRQUNBLE1BQU0sZ0JBQWdCLEdBQUcsNEJBQTRCLENBQ25ELHdCQUF3QixFQUN4QiwwQkFDRixDQUFDO1FBQ0QsSUFBSSxnQkFBZ0IsRUFBRTtVQUNwQixRQUFRLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQztRQUMvQjtNQUNGO0lBQ0Y7SUFFQSxNQUFNLE1BQU0sR0FBRyxhQUFhLENBQUMsSUFBSSxDQUFFLE1BQU0sSUFBSyxNQUFNLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3hFLE1BQU0sTUFBNEIsR0FBRyxDQUFDLENBQUM7SUFDdkMsTUFBTSxZQUEyQixHQUFHLE1BQU0sR0FDdEMsRUFBRSxHQUNGLFFBQVEsQ0FBQyxHQUFHLENBQ1QsT0FBTyxJQUFLLFVBQVUsSUFBQSxrQkFBVyxFQUFDLE9BQU8sQ0FBQyxDQUFDLFFBQVEsQ0FBQyxFQUFFLENBQUMsRUFDMUQsQ0FBQztJQUNMLFlBQVksQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDO0lBRWxDLFlBQVksQ0FBQyxPQUFPLENBQUUsV0FBVyxJQUFLO01BQ3BDLE1BQU0sWUFBWSxHQUFHLFdBQVcsQ0FBQyxHQUFHLENBQ2pDLE9BQU8sSUFBSyxHQUFHLFdBQVcsSUFBSSxPQUFPLEVBQ3hDLENBQUM7TUFDRCxNQUFNLENBQUMsV0FBVyxDQUFDLEdBQUc7UUFDcEIsUUFBUSxFQUFFO01BQ1osQ0FBQztJQUNILENBQUMsQ0FBQztJQUVGLE1BQU0sZ0JBQWtDLEdBQUc7TUFDekMsR0FBRyxjQUFjO01BQ2pCLGdCQUFnQixFQUFFLDZCQUE2QjtNQUMvQyxPQUFPLEVBQUUsQ0FDUDtRQUNFLElBQUksRUFBRSxnQkFBZ0I7UUFDdEIsS0FBSyxFQUFFO1VBQ0wsY0FBYyxFQUFFLENBQUMsQ0FBQztVQUNsQixjQUFjLEVBQUUsTUFBTTtVQUN0QixrQkFBa0IsRUFBRTtRQUN0QjtNQUNGLENBQUM7SUFFTCxDQUFDO0lBRUQsV0FBVyxDQUFDLDZCQUE2QixDQUFDLEdBQUcsZ0JBQWdCO0VBQy9EO0VBRUEsT0FBTyxRQUFRO0FBQ2pCOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNoYkEsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFPTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEdBQUc7O0FBRTFCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUMzQixxQkFBb0MsRUFDWjtFQUN4QixNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUNwQyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUNsQyxPQUFPLGFBQWE7QUFDdEI7QUFFQSxTQUFTLGNBQWMsQ0FBQyxLQUE4QixFQUFFO0VBQ3RELElBQ0UsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSxvQkFBb0IsQ0FBQyxJQUN4QyxJQUFBLGVBQVEsRUFBQyxLQUFLLENBQUMsa0JBQWtCLENBQUMsRUFDbEM7SUFDQTtJQUNBO0lBQ0E7SUFDQSxPQUFPLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyx5QkFBeUI7SUFDekQ7SUFDQSxPQUFPLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQywyQkFBMkI7SUFDM0Q7SUFDQTtJQUNBO0lBQ0EsT0FBTyxLQUFLLENBQUMsa0JBQWtCLENBQUMsb0JBQW9CO0VBQ3REO0VBRUEsSUFDRSxJQUFBLGtCQUFXLEVBQUMsS0FBSyxFQUFFLG1CQUFtQixDQUFDLElBQ3ZDLElBQUEsZUFBUSxFQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxFQUNqQztJQUNBO0lBQ0EsT0FBTyxLQUFLLENBQUMsaUJBQWlCLENBQUMscUJBQXFCO0lBQ3BEO0lBQ0E7SUFDQTtJQUNBLE9BQU8sS0FBSyxDQUFDLGlCQUFpQixDQUFDLGNBQWM7RUFDL0M7RUFFQSxJQUNFLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUsdUJBQXVCLENBQUMsSUFDM0MsSUFBQSxlQUFRLEVBQUMsS0FBSyxDQUFDLHFCQUFxQixDQUFDLEVBQ3JDO0lBQ0E7SUFDQSxPQUFPLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyx3QkFBd0I7SUFDM0Q7SUFDQSxPQUFPLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyw0QkFBNEI7SUFDL0Q7SUFDQSxPQUFPLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxnQkFBZ0I7SUFDbkQ7SUFDQSxPQUFPLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxtQ0FBbUM7SUFDdEU7SUFDQTtJQUNBLE9BQU8sS0FBSyxDQUFDLHFCQUFxQixDQUFDLGdDQUFnQztJQUNuRTtJQUNBLE9BQU8sS0FBSyxDQUFDLHFCQUFxQixDQUFDLDZCQUE2QjtJQUNoRTtJQUNBLE9BQU8sS0FBSyxDQUFDLHFCQUFxQixDQUFDLGFBQWE7SUFDaEQ7SUFDQTtJQUNBO0lBQ0EsT0FBTyxLQUFLLENBQUMscUJBQXFCLENBQUMsdUJBQXVCO0lBQzFEO0lBQ0EsT0FBTyxLQUFLLENBQUMscUJBQXFCLENBQUMsa0JBQWtCO0VBQ3ZEO0VBRUEsT0FBTyxLQUFLO0FBQ2Q7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ3hGQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQU9PLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsR0FBRzs7QUFFMUI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sZUFBZSxPQUFPLENBQzNCLHFCQUFvQyxFQUNaO0VBQ3hCLE1BQU0sYUFBYSxHQUFHLElBQUEsaUJBQVMsRUFBQyxxQkFBcUIsQ0FBQztFQUN0RCxhQUFhLENBQUMsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPO0VBQ3BDLGNBQWMsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDO0VBQ2xDLE9BQU8sYUFBYTtBQUN0QjtBQUVBLFNBQVMsY0FBYyxDQUFDLEtBQThCLEVBQUU7RUFDdEQsTUFBTSwwQkFBMEIsR0FBRyxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUscUJBRTdCO0VBRWIsTUFBTSxXQUFXLEdBQUcsMEJBQTBCLGFBQTFCLDBCQUEwQix1QkFBMUIsMEJBQTBCLENBQUUsV0FFbkM7RUFFYixJQUNFLFdBQVcsSUFDWCxJQUFBLGtCQUFXLEVBQUMsV0FBVyxFQUFFLGdDQUFnQyxDQUFDLEVBQzFEO0lBQ0EsT0FBTyxXQUFXLENBQUMsOEJBQThCO0VBQ25EO0FBQ0Y7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQzlDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBT08sTUFBTSxPQUFPLEdBQUEsT0FBQSxDQUFBLE9BQUEsR0FBRyxHQUFHOztBQUUxQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FDM0IscUJBQW9DLEVBQ1o7RUFDeEIsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsY0FBYyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7RUFDbEMsT0FBTyxhQUFhO0FBQ3RCO0FBRUEsU0FBUyxjQUFjLENBQUMsS0FBOEIsRUFBRTtFQUN0RCxNQUFNLDBCQUEwQixHQUFHLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxxQkFFN0I7RUFFYixNQUFNLFdBQVcsR0FBRywwQkFBMEIsYUFBMUIsMEJBQTBCLHVCQUExQiwwQkFBMEIsQ0FBRSxXQUVuQztFQUVOLFdBQVcsYUFBWCxXQUFXLGVBQWxCLE9BQU8sV0FBVyxDQUFFLHlDQUF5QztBQUMvRDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDeENBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFPTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEtBQUs7O0FBRTVCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FDM0IscUJBQW9DLEVBQ1o7RUFDeEIsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsY0FBYyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7RUFDbEMsT0FBTyxhQUFhO0FBQ3RCO0FBRUEsU0FBUyxjQUFjLENBQUMsS0FBOEIsRUFBRTtFQUN0RCxNQUFNLDBCQUEwQixHQUFHLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxxQkFFN0I7RUFFTiwwQkFBMEIsYUFBMUIsMEJBQTBCLGVBQWpDLE9BQU8sMEJBQTBCLENBQUUsa0JBQWtCO0FBQ3ZEOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNuQ0EsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQU9PLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsR0FBRzs7QUFFMUI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sZUFBZSxPQUFPLENBQzNCLHFCQUFvQyxFQUNaO0VBQ3hCLE1BQU0sYUFBYSxHQUFHLElBQUEsaUJBQVMsRUFBQyxxQkFBcUIsQ0FBQztFQUN0RCxhQUFhLENBQUMsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPO0VBQ3BDLGNBQWMsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDO0VBQ2xDLE9BQU8sYUFBYTtBQUN0QjtBQUVBLFNBQVMsY0FBYyxDQUFDLEtBQThCLEVBQUU7RUFDdEQsTUFBTSwwQkFBMEIsR0FBRyxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUscUJBRTdCO0VBRU4sMEJBQTBCLGFBQTFCLDBCQUEwQixlQUFqQyxPQUFPLDBCQUEwQixDQUFFLGFBQWE7QUFDbEQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ3BDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsbUJBQUEsR0FBQSxPQUFBO0FBV08sTUFBTSxPQUFPLEdBQUEsT0FBQSxDQUFBLE9BQUEsR0FBRyxHQUFHO0FBQzFCLE1BQU0sZ0JBQWdCLEdBQUcsS0FBSzs7QUFFOUI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FDM0IscUJBQW9DLEVBQ1o7RUFDeEIsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsY0FBYyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7RUFDbEMsT0FBTyxhQUFhO0FBQ3RCO0FBRUEsU0FBUyxjQUFjLENBQUMsS0FBOEIsRUFBRTtFQUN0RCxJQUFJLENBQUMsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSxvQkFBb0IsQ0FBQyxFQUFFO0lBQUEsSUFBQSxjQUFBLEVBQUEscUJBQUE7SUFDN0MsQ0FBQSxjQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxjQUFBLGdCQUFBLHFCQUFBLEdBQWIsY0FBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGNBQUEsRUFDRSxJQUFJLEtBQUssQ0FBQyxhQUFhLE9BQU8sdUNBQXVDLENBQ3ZFLENBQUM7SUFDRDtFQUNGO0VBRUEsTUFBTSxrQkFBa0IsR0FBRyxLQUFLLENBQUMsa0JBQXdDO0VBRXpFLElBQUksQ0FBQyxJQUFBLGdCQUFRLEVBQUMsa0JBQWtCLENBQUMsRUFBRTtJQUFBLElBQUEsZUFBQSxFQUFBLHFCQUFBO0lBQ2pDLENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxnQkFBQSxxQkFBQSxHQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxlQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLDRDQUE0QyxPQUFPLGtCQUFrQixHQUMzRixDQUNGLENBQUM7SUFDRDtFQUNGO0VBRUEsTUFBTTtJQUFFO0VBQWdCLENBQUMsR0FBRyxrQkFBa0I7RUFFOUMsSUFBSSxDQUFDLGVBQWUsRUFBRTtJQUFBLElBQUEsZUFBQSxFQUFBLHFCQUFBO0lBQ3BCLENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxnQkFBQSxxQkFBQSxHQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxlQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLGtFQUFrRSxnQkFBZ0IsRUFDeEcsQ0FDRixDQUFDO0lBQ0Qsa0JBQWtCLENBQUMsZUFBZSxHQUFHLGdCQUFnQjtJQUNyRDtFQUNGO0VBRUEsTUFBTSxlQUFlLEdBQUcsd0NBQW9CLENBQUMsSUFBSSxDQUM5QyxRQUFRLElBQUssUUFBUSxLQUFLLGVBQzdCLENBQUM7RUFFRCxJQUFJLENBQUMsZUFBZSxFQUFFO0lBQ3BCLGtCQUFrQixDQUFDLGVBQWUsR0FBRyxnQkFBZ0I7RUFDdkQ7QUFDRjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDdEVBLElBQUEsNEJBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFPTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEdBQUc7O0FBRTFCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FDM0IscUJBQW9DLEVBQ1o7RUFDeEIsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsY0FBYyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7RUFDbEMsT0FBTyxhQUFhO0FBQ3RCO0FBRUEsU0FBUyxjQUFjLENBQ3JCLEtBQThCLEVBQ0w7RUFDekI7RUFDQSxJQUNFLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUsd0JBQXdCLENBQUMsSUFDNUMsSUFBQSxlQUFRLEVBQUMsS0FBSyxDQUFDLHNCQUFzQixDQUFDLElBQ3RDLEtBQUssQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLHNCQUFzQixDQUFDLGtCQUFrQixDQUFDLEVBQzlEO0lBQ0EsS0FBSyxDQUFDLHNCQUFzQixDQUFDLGtCQUFrQixHQUM3QyxLQUFLLENBQUMsc0JBQXNCLENBQUMsa0JBQWtCLENBQUMsR0FBRyxDQUFDLENBQUM7TUFBRTtJQUFVLENBQUMsTUFBTTtNQUN0RSxTQUFTLEVBQUUsSUFBQSw2Q0FBZ0IsRUFBQyxTQUFnQjtJQUM5QyxDQUFDLENBQUMsQ0FBQztFQUNQO0VBRUEsT0FBTyxLQUFLO0FBQ2Q7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQzVDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQU9PLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsS0FBSzs7QUFFNUI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FBQyxxQkFBb0MsRUFBRTtFQUNsRSxNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUNwQyxhQUFhLENBQUMsSUFBSSxHQUFHLGNBQWMsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDO0VBQ3ZELE9BQU8sYUFBYTtBQUN0QjtBQUVBLFNBQVMsY0FBYyxDQUFDLEtBQThCLEVBQUU7RUFDdEQsSUFDRSxJQUFBLGtCQUFXLEVBQUMsS0FBSyxFQUFFLG1CQUFtQixDQUFDLElBQ3ZDLElBQUEsZUFBUSxFQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUNqQyxJQUFBLGVBQVEsRUFBQyxLQUFLLENBQUMsaUJBQWlCLENBQUMsOEJBQThCLENBQUMsSUFDaEUsSUFBQSxrQkFBVyxFQUFDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSx5QkFBeUIsQ0FBQyxFQUMvRDtJQUNBLE1BQU0sWUFBWSxHQUFHLEtBQUssQ0FBQyxpQkFBaUI7SUFDNUMsTUFBTSx3QkFBd0IsR0FBRyxNQUFNLENBQUMsTUFBTSxDQUM1QyxLQUFLLENBQUMsaUJBQWlCLENBQUMsOEJBQzFCLENBQUM7SUFDRCxNQUFNLG1CQUFtQixHQUFHLHdCQUF3QixDQUNqRCxPQUFPLENBQUUsQ0FBQyxJQUNULElBQUEsZUFBUSxFQUFDLENBQUMsQ0FBQyxJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLFlBQVksQ0FBQyxHQUFHLENBQUMsQ0FBQyxZQUFZLEdBQUcsRUFDbEUsQ0FBQyxDQUNBLEdBQUcsQ0FBRSxDQUFDLElBQUssQ0FBQyxDQUFDLGVBQWUsQ0FBQztJQUVoQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsUUFBUSxDQUFDLFlBQVksQ0FBQyx1QkFBdUIsQ0FBQyxFQUFFO01BQ3ZFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyx1QkFBdUIsR0FBRyxTQUFTO0lBQzdEO0VBQ0Y7RUFDQSxPQUFPLEtBQUs7QUFDZDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDOUNBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGtCQUFBLEdBQUEsT0FBQTtBQUlBLElBQUEsZ0JBQUEsR0FBQSxPQUFBO0FBT0EsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQU9PLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsR0FBRzs7QUFFMUI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUFDLHFCQUFvQyxFQUFFO0VBQ2xFLE1BQU0sYUFBYSxHQUFHLElBQUEsaUJBQVMsRUFBQyxxQkFBcUIsQ0FBQztFQUN0RCxhQUFhLENBQUMsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPO0VBQ3BDLGFBQWEsQ0FBQyxJQUFJLEdBQUcsY0FBYyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7RUFDdkQsT0FBTyxhQUFhO0FBQ3RCO0FBRUEsU0FBUyxjQUFjLENBQUMsS0FBOEIsRUFBRTtFQUN0RCxJQUNFLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUsbUJBQW1CLENBQUMsSUFDdkMsSUFBQSxlQUFRLEVBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQ2pDLElBQUEsZUFBUSxFQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyw4QkFBOEIsQ0FBQyxFQUNoRTtJQUNBLE1BQU0sY0FBYyxHQUFHLGlCQUFpQjtJQUN4QyxNQUFNLHFCQUFxQixHQUFHLHdCQUFPLENBQUMsY0FBYyxDQUFDO0lBQ3JELE1BQU0sMkJBQWlELEdBQUc7TUFDeEQsT0FBTyxFQUFFLHFCQUFxQjtNQUM5QixJQUFJLEVBQUUsZ0NBQWUsQ0FBQyxjQUFjLENBQUM7TUFDckMsY0FBYyxFQUFFLCtCQUFjLENBQUMsY0FBYyxDQUFDO01BQzlDLGlCQUFpQixFQUFFLENBQUMsaUNBQWdCLENBQUMsY0FBYyxDQUFDLENBQUM7TUFDckQsdUJBQXVCLEVBQUUsQ0FBQztNQUMxQiw0QkFBNEIsRUFBRSxDQUFDO01BQy9CLFlBQVksRUFBRSxDQUNaO1FBQ0UsZUFBZSxFQUFFLGNBQWM7UUFDL0IsSUFBSSxFQUFFLGtDQUFlLENBQUMsTUFBTTtRQUM1QixHQUFHLEVBQUUsNkNBQTRCLENBQUM7TUFDcEMsQ0FBQztJQUVMLENBQUM7SUFFRCxLQUFLLENBQUMsaUJBQWlCLENBQUMsOEJBQThCLENBQ3BELHFCQUFxQixDQUN0QixHQUFHLDJCQUEyQjtFQUNqQztFQUNBLE9BQU8sS0FBSztBQUNkOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNqRUEsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFFQTtBQUNBOztBQXdCTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEdBQUc7QUFFMUIsU0FBUyxjQUFjLENBQUMsS0FBNEIsRUFBRTtFQUNwRCxJQUNFLENBQUMsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSwwQkFBMEIsQ0FBQyxJQUMvQyxDQUFDLElBQUEsZUFBUSxFQUFDLEtBQUssQ0FBQyx3QkFBd0IsQ0FBQyxFQUN6QztJQUFBLElBQUEsY0FBQSxFQUFBLHFCQUFBO0lBQ0EsQ0FBQSxjQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxjQUFBLGdCQUFBLHFCQUFBLEdBQWIsY0FBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGNBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCwyQ0FBMkMsT0FBTyxLQUFLLENBQUMsd0JBQXdCLEVBQ2xGLENBQ0YsQ0FBQztJQUNELE9BQU8sS0FBSztFQUNkOztFQUVBO0VBQ0EsSUFDRSxJQUFBLGtCQUFXLEVBQUMsS0FBSyxDQUFDLHdCQUF3QixFQUFFLGFBQWEsQ0FBQyxJQUMxRCxJQUFBLGVBQVEsRUFBQyxLQUFLLENBQUMsd0JBQXdCLENBQUMsV0FBVyxDQUFDLElBQ3BELElBQUEsa0JBQVcsRUFBQyxLQUFLLENBQUMsd0JBQXdCLENBQUMsV0FBVyxFQUFFLGFBQWEsQ0FBQyxFQUN0RTtJQUNBLEtBQUssQ0FBQyx3QkFBd0IsQ0FBQyxXQUFXLEdBQUcsU0FBUztJQUN0RCxLQUFLLENBQUMsd0JBQXdCLENBQUMsVUFBVSxHQUFHLEtBQUs7RUFDbkQ7RUFFQSxPQUFPLEtBQUs7QUFDZDs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FDM0IscUJBQW9DLEVBQ1o7RUFDeEIsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsY0FBYyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7RUFDbEMsT0FBTyxhQUFhO0FBQ3RCOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUN4RUEsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFPTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEdBQUc7O0FBRTFCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUMzQixxQkFBb0MsRUFDWjtFQUN4QixNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUNwQyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUNsQyxPQUFPLGFBQWE7QUFDdEI7QUFFQSxTQUFTLGNBQWMsQ0FBQyxLQUE4QixFQUFFO0VBQ3RELElBQ0UsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSxvQkFBb0IsQ0FBQyxJQUN4QyxJQUFBLGVBQVEsRUFBQyxLQUFLLENBQUMsa0JBQWtCLENBQUMsRUFDbEM7SUFDQTtJQUNBLE9BQU8sS0FBSyxDQUFDLGtCQUFrQixDQUFDLDhCQUE4QjtFQUNoRTtFQUVBLElBQUksSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSxlQUFlLENBQUMsSUFBSSxJQUFBLGVBQVEsRUFBQyxLQUFLLENBQUMsYUFBYSxDQUFDLEVBQUU7SUFDeEU7SUFDQSxPQUFPLEtBQUssQ0FBQyxhQUFhLENBQUMsWUFBWTtJQUN2QztJQUNBLE9BQU8sS0FBSyxDQUFDLGFBQWEsQ0FBQyxvQkFBb0I7RUFDakQ7RUFFQSxJQUNFLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUsdUJBQXVCLENBQUMsSUFDM0MsSUFBQSxlQUFRLEVBQUMsS0FBSyxDQUFDLHFCQUFxQixDQUFDLElBQ3JDLElBQUEsa0JBQVcsRUFBQyxLQUFLLENBQUMscUJBQXFCLEVBQUUsYUFBYSxDQUFDLElBQ3ZELElBQUEsZUFBUSxFQUFDLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxXQUFXLENBQUMsRUFDakQ7SUFDQTtJQUNBO0lBQ0EsT0FBTyxLQUFLLENBQUMscUJBQXFCLENBQUMsV0FBVyxDQUMzQywrQkFBK0I7SUFDbEM7SUFDQTtJQUNBLE9BQU8sS0FBSyxDQUFDLHFCQUFxQixDQUFDLFdBQVcsQ0FBQyxlQUFlO0VBQ2hFO0VBRUEsT0FBTyxLQUFLO0FBQ2Q7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQy9EQSxJQUFBLGdCQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBRU8sTUFBTSxPQUFPLEdBQUEsT0FBQSxDQUFBLE9BQUEsR0FBRyxHQUFHOztBQUUxQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUFDLHFCQUc3QixFQUFFO0VBQ0QsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsSUFBSTtJQUNGLGFBQWEsQ0FBQyxJQUFJLEdBQUcsY0FBYyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7RUFDekQsQ0FBQyxDQUFDLE9BQU8sS0FBSyxFQUFFO0lBQUEsSUFBQSxjQUFBLEVBQUEscUJBQUE7SUFDZCxDQUFBLGNBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGNBQUEsZ0JBQUEscUJBQUEsR0FBYixjQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsY0FBQSxFQUNFLElBQUksS0FBSyxDQUFDLGNBQWMsT0FBTyxLQUFLLElBQUEsc0JBQWUsRUFBQyxLQUFLLENBQUMsRUFBRSxDQUM5RCxDQUFDO0VBQ0g7RUFDQSxPQUFPLGFBQWE7QUFDdEI7QUFFQSxTQUFTLGNBQWMsQ0FBQyxLQUE4QixFQUFFO0VBQ3RELE1BQU0sUUFBUSxHQUFHLElBQUEsaUJBQVMsRUFBQyxLQUFLLENBQUM7RUFFakMsSUFBSSxDQUFDLElBQUEsa0JBQVcsRUFBQyxRQUFRLEVBQUUsbUJBQW1CLENBQUMsRUFBRTtJQUMvQyxNQUFNLElBQUksS0FBSyxDQUFDLDRDQUE0QyxDQUFDO0VBQy9EO0VBRUEsSUFBSSxDQUFDLElBQUEsZUFBUSxFQUFDLFFBQVEsQ0FBQyxpQkFBaUIsQ0FBQyxFQUFFO0lBQ3pDLE1BQU0sSUFBSSxLQUFLLENBQ2Isc0RBQXNELE9BQU8sUUFBUSxDQUFDLGlCQUFpQixFQUN6RixDQUFDO0VBQ0g7RUFDQSxJQUNFLENBQUMsSUFBQSxrQkFBVyxFQUFDLFFBQVEsQ0FBQyxpQkFBaUIsRUFBRSxnQ0FBZ0MsQ0FBQyxFQUMxRTtJQUNBLE1BQU0sSUFBSSxLQUFLLENBQ2Isd0VBQ0YsQ0FBQztFQUNIO0VBRUEsSUFBSSxDQUFDLElBQUEsZUFBUSxFQUFDLFFBQVEsQ0FBQyxpQkFBaUIsQ0FBQyw4QkFBOEIsQ0FBQyxFQUFFO0lBQ3hFLE1BQU0sSUFBSSxLQUFLLENBQ2IscUZBQXFGLE9BQU8sUUFBUSxDQUNqRyxpQkFBaUIsQ0FBQyw4QkFBOEIsRUFDckQsQ0FBQztFQUNIO0VBRUEsTUFBTTtJQUFFO0VBQStCLENBQUMsR0FBRyxRQUFRLENBQUMsaUJBQWlCO0VBRXJFLEtBQUssTUFBTSxDQUFDLE9BQU8sRUFBRSxvQkFBb0IsQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQzFELDhCQUNGLENBQUMsRUFBRTtJQUNELE1BQU0sWUFBWSxHQUFHLElBQUEsc0JBQUssRUFBQyxPQUFPLENBQUM7SUFFbkMsSUFBSSxDQUFDLElBQUEsZUFBUSxFQUFDLG9CQUFvQixDQUFDLEVBQUU7TUFDbkMsTUFBTSxJQUFJLEtBQUssQ0FDYiw2RkFBNkYsT0FBTyxvQ0FBb0MsT0FBTyxvQkFBb0IsRUFDckssQ0FBQztJQUNIO0lBRUEsSUFBSSxPQUFPLG9CQUFvQixDQUFDLE9BQU8sS0FBSyxRQUFRLEVBQUU7TUFDcEQsTUFBTSxJQUFJLEtBQUssQ0FDYiw2RkFBNkYsT0FBTyxrREFBa0QsT0FBTyxvQkFBb0IsQ0FBQyxPQUFPLEVBQzNMLENBQUM7SUFDSDtJQUVBLG9CQUFvQixDQUFDLE9BQU8sR0FBRyxZQUFZO0lBRTNDLElBQUksWUFBWSxLQUFLLE9BQU8sRUFBRTtNQUM1QixPQUFPLDhCQUE4QixDQUFDLE9BQU8sQ0FBQztNQUM5Qyw4QkFBOEIsQ0FBQyxZQUFZLENBQUMsR0FBRyxvQkFBb0I7SUFDckU7RUFDRjtFQUVBLE9BQU8sUUFBUTtBQUNqQjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDdkZBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFPTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEdBQUc7O0FBRTFCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUMzQixxQkFBb0MsRUFDWjtFQUN4QixNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUNwQyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUNsQyxPQUFPLGFBQWE7QUFDdEI7QUFFQSxTQUFTLGNBQWMsQ0FBQyxLQUE4QixFQUFFO0VBQ3RELE1BQU0sMEJBQTBCLEdBQUcsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLHFCQUU3QjtFQUViLE1BQU0sV0FBVyxHQUFHLDBCQUEwQixhQUExQiwwQkFBMEIsdUJBQTFCLDBCQUEwQixDQUFFLFdBRW5DO0VBRU4sV0FBVyxhQUFYLFdBQVcsZUFBbEIsT0FBTyxXQUFXLENBQUUsZUFBZTtBQUNyQzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDeENBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFPTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEdBQUc7O0FBRTFCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUMzQixxQkFBb0MsRUFDWjtFQUN4QixNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUNwQyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUNsQyxPQUFPLGFBQWE7QUFDdEI7QUFFQSxTQUFTLGNBQWMsQ0FBQyxLQUE4QixFQUFFO0VBQ3RELE1BQU0sMEJBQTBCLEdBQUcsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLHFCQUU3QjtFQUVOLDBCQUEwQixhQUExQiwwQkFBMEIsZUFBakMsT0FBTywwQkFBMEIsQ0FBRSwrQkFBK0I7QUFDcEU7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNwQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFPTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEtBQUs7O0FBRTVCO0FBQ0E7QUFDQTtBQUNPLE1BQU0sUUFBUSxHQUFBLE9BQUEsQ0FBQSxRQUFBLEdBQUc7RUFDdEIseUNBQXlDLEVBQUU7SUFDekMsT0FBTyxFQUFFLHlDQUF5QztJQUNsRCxJQUFJLEVBQUUsaUJBQWlCO0lBQ3ZCLGNBQWMsRUFBRSxrREFBa0Q7SUFDbEUsS0FBSyxFQUFFO0VBQ1QsQ0FBQztFQUNELHlDQUF5QyxFQUFFO0lBQ3pDLE9BQU8sRUFBRSx5Q0FBeUM7SUFDbEQsSUFBSSxFQUFFLG1CQUFtQjtJQUN6QixjQUFjLEVBQUUsa0RBQWtEO0lBQ2xFLEtBQUssRUFBRTtFQUNULENBQUM7RUFDRCx5Q0FBeUMsRUFBRTtJQUN6QyxPQUFPLEVBQUUseUNBQXlDO0lBQ2xELElBQUksRUFBRSxnQkFBZ0I7SUFDdEIsY0FBYyxFQUFFLG9EQUFvRDtJQUNwRSxLQUFLLEVBQUU7RUFDVCxDQUFDO0VBQ0QseUNBQXlDLEVBQUU7SUFDekMsT0FBTyxFQUFFLHlDQUF5QztJQUNsRCxJQUFJLEVBQUUsZUFBZTtJQUNyQixjQUFjLEVBQUUsb0RBQW9EO0lBQ3BFLEtBQUssRUFBRTtFQUNUO0FBQ0YsQ0FBQzs7QUFFRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sZUFBZSxPQUFPLENBQzNCLHFCQUFvQyxFQUNaO0VBQ3hCLE1BQU0sYUFBYSxHQUFHLElBQUEsaUJBQVMsRUFBQyxxQkFBcUIsQ0FBQztFQUN0RCxhQUFhLENBQUMsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPO0VBQ3BDLGNBQWMsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDO0VBQ2xDLE9BQU8sYUFBYTtBQUN0QjtBQUVBLFNBQVMsY0FBYyxDQUNyQixLQUE4QixFQUNMO0VBQ3pCLElBQ0UsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSw2QkFBNkIsQ0FBQyxJQUNqRCxJQUFBLGVBQVEsRUFBQyxLQUFLLENBQUMsMkJBQTJCLENBQUMsSUFDM0MsSUFBQSxlQUFRLEVBQ04sS0FBSyxDQUFDLDJCQUEyQixDQUM5Qix3Q0FDTCxDQUFDLEVBQ0Q7SUFDQSxLQUFLLENBQUMsMkJBQTJCLENBQUMsd0NBQXdDLEdBQ3hFO01BQ0UsR0FBRyxLQUFLLENBQUMsMkJBQTJCLENBQ2pDLHdDQUF3QztNQUMzQyxHQUFHO0lBQ0wsQ0FBQztFQUNMO0VBRUEsT0FBTyxLQUFLO0FBQ2Q7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQzdFQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBT08sTUFBTSxPQUFPLEdBQUEsT0FBQSxDQUFBLE9BQUEsR0FBRyxLQUFLOztBQUU1QjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FDM0IscUJBQW9DLEVBQ1o7RUFDeEIsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsY0FBYyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7RUFDbEMsT0FBTyxhQUFhO0FBQ3RCO0FBRUEsU0FBUyxjQUFjLENBQUMsS0FBOEIsRUFBRTtFQUN0RCxNQUFNLDBCQUEwQixHQUFHLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxxQkFFN0I7RUFFYixNQUFNLFdBQVcsR0FBRywwQkFBMEIsYUFBMUIsMEJBQTBCLHVCQUExQiwwQkFBMEIsQ0FBRSxXQUVuQztFQUVOLFdBQVcsYUFBWCxXQUFXLGVBQWxCLE9BQU8sV0FBVyxDQUFFLDhCQUE4QjtFQUMzQyxXQUFXLGFBQVgsV0FBVyxlQUFsQixPQUFPLFdBQVcsQ0FBRSw0QkFBNEI7QUFDbEQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ3pDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUVPLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsR0FBRzs7QUFFMUI7QUFDQSxNQUFNLGdCQUFnQixHQUFHLGtCQUFrQjtBQUMzQyxNQUFNLDZCQUE2QixHQUFHLGtCQUFrQjtBQU14RDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FBQyxxQkFBb0MsRUFBRTtFQUNsRSxNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUNwQyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUNsQyxPQUFPLGFBQWE7QUFDdEI7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUyxjQUFjLENBQUMsS0FBNEIsRUFBRTtFQUNwRCxJQUFJLENBQUMsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSxzQkFBc0IsQ0FBQyxFQUFFO0lBQy9DLE9BQU8sS0FBSztFQUNkO0VBRUEsSUFBSSxDQUFDLElBQUEsZUFBUSxFQUFDLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxFQUFFO0lBQUEsSUFBQSxjQUFBLEVBQUEscUJBQUE7SUFDekMsQ0FBQSxjQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxjQUFBLGdCQUFBLHFCQUFBLEdBQWIsY0FBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGNBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8sMENBQTBDLE9BQU8sS0FBSyxDQUFDLG9CQUFvQixFQUNqRyxDQUNGLENBQUM7SUFDRCxPQUFPLEtBQUs7RUFDZDtFQUVBLE1BQU07SUFBRTtFQUFTLENBQUMsR0FBRyxLQUFLLENBQUMsb0JBQW9CO0VBRS9DLElBQUksQ0FBQyxJQUFBLGVBQVEsRUFBQyxRQUFRLENBQUMsRUFBRTtJQUFBLElBQUEsZUFBQSxFQUFBLHFCQUFBO0lBQ3ZCLENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxnQkFBQSxxQkFBQSxHQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxlQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLG1EQUFtRCxPQUFPLFFBQVEsRUFDeEYsQ0FDRixDQUFDO0lBQ0QsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxLQUFLLE1BQU0sT0FBTyxJQUFJLE1BQU0sQ0FBQyxNQUFNLENBQUMsUUFBUSxDQUFDLEVBQUU7SUFDN0MsSUFDRSxDQUFDLElBQUEsZUFBUSxFQUFDLE9BQU8sQ0FBQyxJQUNsQixDQUFDLElBQUEsa0JBQVcsRUFBQyxPQUFPLEVBQUUsYUFBYSxDQUFDLElBQ3BDLENBQUMsSUFBQSxlQUFRLEVBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxFQUM5QjtNQUNBO0lBQ0Y7SUFFQSxNQUFNO01BQUU7SUFBWSxDQUFDLEdBQUcsT0FBTztJQUMvQixNQUFNLGdCQUFnQixHQUFHLFdBQVcsQ0FBQyw2QkFBNkIsQ0FBQztJQUVuRSxJQUNFLENBQUMsSUFBQSxlQUFRLEVBQUMsZ0JBQWdCLENBQUMsSUFDM0IsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLGdCQUFnQixDQUFDLE9BQU8sQ0FBQyxFQUN4QztNQUNBO0lBQ0Y7SUFFQSxNQUFNLFlBQVksR0FBRyxnQkFBZ0IsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUMvQyxNQUFNLElBQUssTUFBTSxDQUFDLElBQUksS0FBSyxnQkFDOUIsQ0FBQztJQUVELElBQ0UsWUFBWSxJQUNaLElBQUEsZUFBUSxFQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsSUFDNUIsQ0FBQyxJQUFBLGtCQUFXLEVBQUMsWUFBWSxDQUFDLEtBQUssRUFBRSxtQkFBbUIsQ0FBQyxFQUNyRDtNQUNBLFlBQVksQ0FBQyxLQUFLLENBQUMsaUJBQWlCLEdBQUcsQ0FBQyxDQUFDO0lBQzNDO0VBQ0Y7RUFFQSxPQUFPLEtBQUs7QUFDZDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDMUZBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBT08sTUFBTSxPQUFPLEdBQUEsT0FBQSxDQUFBLE9BQUEsR0FBRyxHQUFHOztBQUUxQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FDM0IscUJBQW9DLEVBQ1o7RUFDeEIsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFFcEMsYUFBYSxDQUFDLElBQUksR0FBRyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUV2RCxPQUFPLGFBQWE7QUFDdEI7QUFFQSxTQUFTLGNBQWMsQ0FDckIsS0FBOEIsRUFDTDtFQUN6QixJQUFJLENBQUMsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSxrQkFBa0IsQ0FBQyxFQUFFO0lBQzNDLE9BQU8sQ0FBQyxJQUFJLENBQUMsMENBQTBDLENBQUM7SUFDeEQsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxNQUFNLHFCQUFxQixHQUFHLEtBQUssQ0FBQyxnQkFBZ0I7RUFFcEQsSUFBSSxDQUFDLElBQUEsZUFBUSxFQUFDLHFCQUFxQixDQUFDLEVBQUU7SUFBQSxJQUFBLGNBQUEsRUFBQSxxQkFBQTtJQUNwQyxDQUFBLGNBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGNBQUEsZ0JBQUEscUJBQUEsR0FBYixjQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsY0FBQSxFQUNFLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTywrQkFBK0IsT0FBTyxxQkFBcUIscUJBQ2pGLENBQ0YsQ0FBQztJQUNELE9BQU8sS0FBSztFQUNkO0VBRUEsSUFBSSxDQUFDLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUscUJBQXFCLENBQUMsRUFBRTtJQUM5QyxPQUFPLENBQUMsSUFBSSxDQUFDLDZDQUE2QyxDQUFDO0lBQzNELE9BQU8sS0FBSztFQUNkO0VBRUEsTUFBTSx3QkFBd0IsR0FBRyxLQUFLLENBQUMsbUJBQW1CO0VBRTFELElBQUksQ0FBQyxJQUFBLGVBQVEsRUFBQyx3QkFBd0IsQ0FBQyxFQUFFO0lBQUEsSUFBQSxlQUFBLEVBQUEscUJBQUE7SUFDdkMsQ0FBQSxlQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxlQUFBLGdCQUFBLHFCQUFBLEdBQWIsZUFBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGVBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8sa0NBQWtDLE9BQU8sd0JBQXdCLHFCQUN2RixDQUNGLENBQUM7SUFDRCxPQUFPLEtBQUs7RUFDZDtFQUVBLElBQUksSUFBQSxrQkFBVyxFQUFDLHFCQUFxQixFQUFFLFFBQVEsQ0FBQyxFQUFFO0lBQ2hEO0lBQ0EsT0FBTyxxQkFBcUIsQ0FBQyxNQUFNO0VBQ3JDO0VBRUEsSUFBSSxJQUFBLGtCQUFXLEVBQUMscUJBQXFCLEVBQUUsZ0JBQWdCLENBQUMsRUFBRTtJQUN4RDtJQUNBLE9BQU8scUJBQXFCLENBQUMsY0FBYztFQUM3QztFQUVBLElBQUksSUFBQSxrQkFBVyxFQUFDLHFCQUFxQixFQUFFLGVBQWUsQ0FBQyxFQUFFO0lBQ3ZEO0lBQ0EsT0FBTyxxQkFBcUIsQ0FBQyxhQUFhO0VBQzVDO0VBRUEsSUFBSSxJQUFBLGtCQUFXLEVBQUMsd0JBQXdCLEVBQUUsV0FBVyxDQUFDLEVBQUU7SUFDdEQ7SUFDQSxPQUFPLHdCQUF3QixDQUFDLFNBQVM7RUFDM0M7RUFFQSxPQUFPLEtBQUs7QUFDZDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDdEZBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFPTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEdBQUc7O0FBRTFCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FDM0IscUJBQW9DLEVBQ1o7RUFDeEIsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsY0FBYyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7RUFDbEMsT0FBTyxhQUFhO0FBQ3RCO0FBRUEsU0FBUyxjQUFjLENBQUMsS0FBOEIsRUFBRTtFQUMvQyxLQUFLLGFBQUwsS0FBSyxlQUFaLE9BQU8sS0FBSyxDQUFFLHVCQUF1QjtBQUN2Qzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDL0JBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBT08sTUFBTSxPQUFPLEdBQUEsT0FBQSxDQUFBLE9BQUEsR0FBRyxHQUFHOztBQUUxQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FDM0IscUJBQW9DLEVBQ1o7RUFDeEIsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFFcEMsYUFBYSxDQUFDLElBQUksR0FBRyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUV2RCxPQUFPLGFBQWE7QUFDdEI7QUFFQSxTQUFTLGNBQWMsQ0FDckIsS0FBOEIsRUFDTDtFQUN6QixJQUFJLENBQUMsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSx3QkFBd0IsQ0FBQyxFQUFFO0lBQ2pELE9BQU8sS0FBSztFQUNkO0VBRUEsTUFBTSwyQkFBMkIsR0FBRyxLQUFLLENBQUMsc0JBQXNCO0VBRWhFLElBQUksQ0FBQyxJQUFBLGVBQVEsRUFBQywyQkFBMkIsQ0FBQyxFQUFFO0lBQUEsSUFBQSxjQUFBLEVBQUEscUJBQUE7SUFDMUMsQ0FBQSxjQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxjQUFBLGdCQUFBLHFCQUFBLEdBQWIsY0FBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGNBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8scUNBQXFDLE9BQU8sMkJBQTJCLHFCQUM3RixDQUNGLENBQUM7SUFDRCxPQUFPLEtBQUs7RUFDZDtFQUVBLElBQUksSUFBQSxrQkFBVyxFQUFDLDJCQUEyQixFQUFFLG1CQUFtQixDQUFDLEVBQUU7SUFDakUsSUFBSSxJQUFBLGVBQVEsRUFBQywyQkFBMkIsQ0FBQyxpQkFBaUIsQ0FBQyxFQUFFO01BQzNELEtBQUssQ0FBQyxzQkFBc0IsR0FBRztRQUM3QixHQUFHLDJCQUEyQixDQUFDO01BQ2pDLENBQUM7O01BRUQ7TUFDQSxPQUFPLDJCQUEyQixDQUFDLGlCQUFpQjtJQUN0RDtFQUNGO0VBRUEsT0FBTyxLQUFLO0FBQ2Q7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQzVEQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQUVPLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsS0FBSzs7QUFFNUI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sZUFBZSxPQUFPLENBQUMscUJBRzdCLEVBQUU7RUFDRCxNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUNwQyxhQUFhLENBQUMsSUFBSSxHQUFHLGNBQWMsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDO0VBQ3ZELE9BQU8sYUFBYTtBQUN0QjtBQUVBLFNBQVMsY0FBYyxDQUFDLEtBQThCLEVBQUU7RUFDdEQsTUFBTSxRQUFRLEdBQUcsS0FBSztFQUV0QixJQUNFLElBQUEsa0JBQVcsRUFBQyxRQUFRLEVBQUUsbUJBQW1CLENBQUMsSUFDMUMsSUFBQSxnQkFBUSxFQUFDLFFBQVEsQ0FBQyxpQkFBaUIsQ0FBQyxJQUNwQyxJQUFBLGtCQUFXLEVBQUMsUUFBUSxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixDQUFDLEVBQzNEO0lBQ0EsT0FBTyxRQUFRLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCO0VBQ3BEO0VBRUEsT0FBTyxRQUFRO0FBQ2pCOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNuQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFFTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEdBQUc7QUFRMUI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sZUFBZSxPQUFPLENBQUMscUJBRzdCLEVBQUU7RUFDRCxNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUNwQyxJQUFJO0lBQ0YsYUFBYSxDQUFDLElBQUksR0FBRyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUN6RCxDQUFDLENBQUMsT0FBTyxLQUFLLEVBQUU7SUFBQSxJQUFBLGNBQUEsRUFBQSxxQkFBQTtJQUNkLENBQUEsY0FBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsY0FBQSxnQkFBQSxxQkFBQSxHQUFiLGNBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxjQUFBLEVBQ0UsSUFBSSxLQUFLLENBQUMsY0FBYyxPQUFPLEtBQUssSUFBQSxzQkFBZSxFQUFDLEtBQUssQ0FBQyxFQUFFLENBQzlELENBQUM7RUFDSDtFQUNBLE9BQU8sYUFBYTtBQUN0QjtBQUVBLFNBQVMsY0FBYyxDQUFDLEtBQThCLEVBQUU7RUFDdEQsTUFBTSxRQUFRLEdBQUcsSUFBQSxpQkFBUyxFQUFDLEtBQUssQ0FBQztFQUVqQyxJQUFJLENBQUMsSUFBQSxrQkFBVyxFQUFDLFFBQVEsRUFBRSxlQUFlLENBQUMsRUFBRTtJQUMzQyxPQUFPLENBQUMsSUFBSSxDQUFDLHdDQUF3QyxDQUFDO0lBQ3RELE9BQU8sS0FBSztFQUNkO0VBRUEsSUFBSSxDQUFDLElBQUEsZUFBUSxFQUFDLFFBQVEsQ0FBQyxhQUFhLENBQUMsRUFBRTtJQUNyQyxNQUFNLElBQUksS0FBSyxDQUNiLGtEQUFrRCxPQUFPLFFBQVEsQ0FBQyxhQUFhLEVBQ2pGLENBQUM7RUFDSDtFQUNBLElBQUksQ0FBQyxJQUFBLGtCQUFXLEVBQUMsUUFBUSxDQUFDLGFBQWEsRUFBRSxTQUFTLENBQUMsRUFBRTtJQUNuRCxNQUFNLElBQUksS0FBSyxDQUFDLDZDQUE2QyxDQUFDO0VBQ2hFO0VBRUEsSUFBSSxDQUFDLElBQUEsZUFBUSxFQUFDLFFBQVEsQ0FBQyxhQUFhLENBQUMsT0FBTyxDQUFDLEVBQUU7SUFDN0MsTUFBTSxJQUFJLEtBQUssQ0FDYiwwREFBMEQsT0FBTyxRQUFRLENBQ3RFLGFBQWEsQ0FBQyxPQUFPLEVBQzFCLENBQUM7RUFDSDtFQUVBLE1BQU07SUFBRTtFQUFRLENBQUMsR0FBRyxRQUFRLENBQUMsYUFBYTtFQUUxQyxLQUFLLE1BQU0sYUFBYSxJQUFJLE1BQU0sQ0FBQyxNQUFNLENBQUMsT0FBa0IsQ0FBQyxFQUFFO0lBQzdELEtBQUssTUFBTSxDQUFDLE9BQU8sRUFBRSxnQkFBZ0IsQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsYUFBYSxDQUFDLEVBQUU7TUFDdkUsZ0JBQWdCLENBQUMsT0FBTyxDQUFFLE1BQU0sSUFBSztRQUNuQyxJQUFJLEVBQUMsTUFBTSxhQUFOLE1BQU0sZUFBTixNQUFNLENBQUUsT0FBTyxHQUFFO1VBQ3BCLE1BQU0sQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQztRQUNsQztNQUNGLENBQUMsQ0FBQztJQUNKO0VBQ0Y7RUFFQSxPQUFPLFFBQVE7QUFDakI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDMUVBLElBQUEsa0JBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBT08sTUFBTSxPQUFPLEdBQUEsT0FBQSxDQUFBLE9BQUEsR0FBRyxHQUFHOztBQUUxQjtBQUNBO0FBQ0E7QUFDQTtBQUNPLE1BQU0sNEJBR1osR0FBQSxPQUFBLENBQUEsNEJBQUEsR0FBRyxJQUFJLEdBQUcsQ0FBQyxDQUNWLENBQ0UsS0FBSyxFQUNMO0VBQ0UsU0FBUyxFQUFFLFNBQVM7RUFDcEIsY0FBYyxFQUFFLENBQUEsS0FBTSxPQUFPLENBQUMsR0FBRyxDQUFDO0FBQ3BDLENBQUMsQ0FDRjtBQUNEO0FBQ0EsQ0FDRSxRQUFRLEVBQ1I7RUFDRSxTQUFTLEVBQUUsZUFBZTtFQUMxQixjQUFjLEVBQUUsQ0FBQSxLQUFNLE9BQU8sQ0FBQyxHQUFHLENBQUM7QUFDcEMsQ0FBQyxDQUNGLEVBQ0QsQ0FDRSxRQUFRLEVBQ1I7RUFDRSxTQUFTLEVBQUUsVUFBVTtFQUNyQixjQUFjLEVBQUUsQ0FBQSxLQUFNLE9BQU8sQ0FBQyxHQUFHLENBQUM7QUFDcEMsQ0FBQyxDQUNGLEVBQ0QsQ0FDRSxRQUFRLEVBQ1I7RUFDRSxTQUFTLEVBQUUsV0FBVztFQUN0QixjQUFjLEVBQUUsQ0FBQSxLQUFNLE9BQU8sQ0FBQyxHQUFHLENBQUM7QUFDcEMsQ0FBQyxDQUNGLEVBQ0QsQ0FDRSxLQUFLLEVBQ0w7RUFDRSxTQUFTLEVBQUUsVUFBVTtFQUNyQixjQUFjLEVBQUUsQ0FBQSxLQUFNLE9BQU8sQ0FBQyxHQUFHLENBQUM7QUFDcEMsQ0FBQyxDQUNGLEVBQ0QsQ0FDRSxNQUFNLEVBQ047RUFDRSxTQUFTLEVBQUUsU0FBUztFQUNwQixjQUFjLEVBQUUsQ0FBQSxLQUFNLE9BQU8sQ0FBQyxHQUFHLENBQUM7QUFDcEMsQ0FBQyxDQUNGLEVBQ0QsQ0FDRSxRQUFRLEVBQ1I7RUFDRSxTQUFTLEVBQUUsTUFBTTtFQUNqQixjQUFjLEVBQUUsQ0FBQSxLQUFNLE9BQU8sQ0FBQyxHQUFHLENBQUM7QUFDcEMsQ0FBQyxDQUNGLENBQ0YsQ0FBQzs7QUFFRjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUMzQixxQkFBb0MsRUFDWjtFQUN4QixNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUVwQyxJQUFJO0lBQ0YsY0FBYyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7RUFDcEMsQ0FBQyxDQUFDLE9BQU8sS0FBSyxFQUFFO0lBQ2QsT0FBTyxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUM7SUFDcEIsTUFBTSxRQUFRLEdBQUcsSUFBSSxLQUFLLENBQ3hCLGNBQWMsT0FBTyxLQUFLLElBQUEsc0JBQWUsRUFBQyxLQUFLLENBQUMsRUFDbEQsQ0FBQztJQUNELElBQUEsd0JBQWdCLEVBQUMsUUFBUSxDQUFDO0lBQzFCO0lBQ0E7SUFDQSxhQUFhLENBQUMsSUFBSSxHQUFHLHFCQUFxQixDQUFDLElBQUk7RUFDakQ7RUFFQSxPQUFPLGFBQWE7QUFDdEI7QUFFQSxTQUFTLGNBQWMsQ0FBQyxLQUE4QixFQUFFO0VBQ3RELElBQUksQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixFQUFFO0lBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsMkJBQTJCLENBQUM7RUFDOUM7RUFFQSxJQUFJLENBQUMsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSxtQkFBbUIsQ0FBQyxFQUFFO0lBQzVDLE1BQU0sSUFBSSxLQUFLLENBQUMsaUNBQWlDLENBQUM7RUFDcEQ7RUFFQSxJQUFJLENBQUMsSUFBQSxlQUFRLEVBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLEVBQUU7SUFDdEMsTUFBTSxJQUFJLEtBQUssQ0FDYiw0REFBNEQsT0FBTyxLQUFLLENBQUMsaUJBQWlCLEVBQzVGLENBQUM7RUFDSDtFQUVBLElBQUksQ0FBQyxJQUFBLGtCQUFXLEVBQUMsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGdDQUFnQyxDQUFDLEVBQUU7SUFDM0UsTUFBTSxJQUFJLEtBQUssQ0FDYixnRUFDRixDQUFDO0VBQ0g7RUFFQSxJQUFJLENBQUMsSUFBQSxlQUFRLEVBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLDhCQUE4QixDQUFDLEVBQUU7SUFDckUsTUFBTSxJQUFJLEtBQUssQ0FDYiwyRkFBMkYsT0FBTyxLQUFLLENBQ3BHLGlCQUFpQixDQUFDLDhCQUE4QixFQUNyRCxDQUFDO0VBQ0g7RUFFQSxNQUFNO0lBQUU7RUFBK0IsQ0FBQyxHQUFHLEtBQUssQ0FBQyxpQkFBaUI7RUFFbEUsS0FBSyxNQUFNLENBQUMsT0FBTyxFQUFFLG9CQUFvQixDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FDMUQsOEJBQ0YsQ0FBQyxFQUFFO0lBQ0QsTUFBTSx1QkFBdUIsR0FBRyw0QkFBNEIsQ0FBQyxHQUFHLENBQzlELE9BQ0YsQ0FBQztJQUVELElBQ0UsQ0FBQyxJQUFBLGVBQVEsRUFBQyxvQkFBb0IsQ0FBQyxJQUMvQixDQUFDLElBQUEsa0JBQVcsRUFBQyxvQkFBb0IsRUFBRSxjQUFjLENBQUMsSUFDbEQsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLG9CQUFvQixDQUFDLFlBQVksQ0FBQyxFQUNqRDtNQUNBO0lBQ0Y7SUFFQSxvQkFBb0IsQ0FBQyxZQUFZLEdBQUcsb0JBQW9CLENBQUMsWUFBWSxDQUFDLEdBQUcsQ0FDdEUsV0FBVyxJQUFLO01BQ2YsSUFDRSxDQUFDLElBQUEsZUFBUSxFQUFDLFdBQVcsQ0FBQyxJQUN0QixDQUFDLElBQUEsa0JBQVcsRUFBQyxXQUFXLEVBQUUsS0FBSyxDQUFDLElBQ2hDLE9BQU8sV0FBVyxDQUFDLEdBQUcsS0FBSyxRQUFRLElBQ2xDLElBQUEsa0JBQVcsRUFBQyxXQUFXLEVBQUUsY0FBYyxDQUFDLElBQ3ZDLEtBQUssQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLFlBQVksQ0FBQyxJQUN2QyxXQUFXLENBQUMsWUFBWSxDQUFDLE1BQU0sR0FBRyxDQUFFLEVBQ3RDO1FBQ0EsT0FBTyxXQUFXO01BQ3BCOztNQUVBO01BQ0E7TUFDQSxNQUFNLEtBQUssR0FBRyxXQUFXLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FDakMsSUFBSSxNQUFNLENBQ1Isa0NBQWtDLElBQUEsb0JBQVksRUFDNUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFDZCxDQUFDLEVBQUUsRUFDSCxHQUNGLENBQ0YsQ0FBQztNQUNELE1BQU0sWUFBWSxHQUNoQixLQUFLLElBQ0wsdUJBQXVCLElBQ3ZCLEtBQUssQ0FBQyxDQUFDLENBQUMsS0FBSyx1QkFBdUIsQ0FBQyxTQUFTO01BRWhELE1BQU0sV0FBVyxHQUFHLHVCQUF1QixhQUF2Qix1QkFBdUIsdUJBQXZCLHVCQUF1QixDQUFFLGNBQWMsQ0FBQyxDQUFDO01BRTdELElBQ0UsV0FBVyxLQUNWLFdBQVcsQ0FBQyxJQUFJLEtBQUssa0NBQWUsQ0FBQyxNQUFNLElBQUksWUFBWSxDQUFDLEVBQzdEO1FBQ0EsT0FBTztVQUNMLEdBQUcsV0FBVztVQUNkLFlBQVksRUFBRSxDQUFDLFdBQVc7UUFDNUIsQ0FBQztNQUNIO01BRUEsT0FBTyxXQUFXO0lBQ3BCLENBQ0YsQ0FBQztFQUNIO0FBQ0Y7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDN0xBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBaUJPLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsR0FBRztBQUUxQixTQUFTLGNBQWMsQ0FBQyxLQUE0QixFQUFFO0VBQ3BELElBQ0UsQ0FBQyxJQUFBLGtCQUFXLEVBQUMsS0FBSyxFQUFFLHVCQUF1QixDQUFDLElBQzVDLENBQUMsSUFBQSxlQUFRLEVBQUMsS0FBSyxDQUFDLHFCQUFxQixDQUFDLEVBQ3RDO0lBQUEsSUFBQSxjQUFBLEVBQUEscUJBQUE7SUFDQSxDQUFBLGNBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGNBQUEsZ0JBQUEscUJBQUEsR0FBYixjQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsY0FBQSxFQUNFLElBQUksS0FBSyxDQUNQLHdDQUF3QyxPQUFPLEtBQUssQ0FBQyxxQkFBcUIsRUFDNUUsQ0FDRixDQUFDO0lBQ0QsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxJQUFJLElBQUEsa0JBQVcsRUFBQyxLQUFLLENBQUMscUJBQXFCLEVBQUUseUJBQXlCLENBQUMsRUFBRTtJQUN2RSxLQUFLLENBQUMscUJBQXFCLENBQUMsc0JBQXNCLEdBQUcsT0FBTyxDQUMxRCxLQUFLLENBQUMscUJBQXFCLENBQUMsdUJBQzlCLENBQUM7SUFDRCxPQUFPLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyx1QkFBdUI7RUFDNUQ7RUFFQSxJQUNFLElBQUEsa0JBQVcsRUFBQyxLQUFLLENBQUMscUJBQXFCLEVBQUUsK0JBQStCLENBQUMsRUFDekU7SUFDQSxLQUFLLENBQUMscUJBQXFCLENBQUMsNEJBQTRCLEdBQUcsT0FBTyxDQUNoRSxLQUFLLENBQUMscUJBQXFCLENBQUMsNkJBQzlCLENBQUM7SUFDRCxPQUFPLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyw2QkFBNkI7RUFDbEU7RUFFQSxPQUFPLEtBQUs7QUFDZDs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUMzQixxQkFBb0MsRUFDWjtFQUN4QixNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUNwQyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUNsQyxPQUFPLGFBQWE7QUFDdEI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ3RFQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQU9PLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsR0FBRzs7QUFFMUI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sZUFBZSxPQUFPLENBQzNCLHFCQUFvQyxFQUNaO0VBQ3hCLE1BQU0sYUFBYSxHQUFHLElBQUEsaUJBQVMsRUFBQyxxQkFBcUIsQ0FBQztFQUN0RCxhQUFhLENBQUMsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPO0VBRXBDLGFBQWEsQ0FBQyxJQUFJLEdBQUcsY0FBYyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7RUFFdkQsT0FBTyxhQUFhO0FBQ3RCO0FBRUEsU0FBUyxjQUFjLENBQ3JCLEtBQThCLEVBQ0w7RUFDekIsSUFBSSxDQUFDLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUsdUJBQXVCLENBQUMsRUFBRTtJQUFBLElBQUEsY0FBQSxFQUFBLHFCQUFBO0lBQ2hELENBQUEsY0FBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsY0FBQSxnQkFBQSxxQkFBQSxHQUFiLGNBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxjQUFBLEVBQ0UsSUFBSSxLQUFLLENBQUMsYUFBYSxPQUFPLG9DQUFvQyxDQUNwRSxDQUFDO0lBQ0QsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxNQUFNLDBCQUEwQixHQUFHLEtBQUssQ0FBQyxxQkFBcUI7RUFFOUQsSUFBSSxDQUFDLElBQUEsZUFBUSxFQUFDLDBCQUEwQixDQUFDLEVBQUU7SUFBQSxJQUFBLGVBQUEsRUFBQSxxQkFBQTtJQUN6QyxDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZ0JBQUEscUJBQUEsR0FBYixlQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsZUFBQSxFQUNFLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTyxvQ0FBb0MsT0FBTywwQkFBMEIscUJBQzNGLENBQ0YsQ0FBQztJQUNELE9BQU8sS0FBSztFQUNkO0VBRUEsSUFDRSxJQUFBLGtCQUFXLEVBQ1QsMEJBQTBCLEVBQzFCLG9DQUNGLENBQUMsRUFDRDtJQUNBLE9BQU8sMEJBQTBCLENBQUMsa0NBQWtDO0VBQ3RFO0VBRUEsT0FBTyxLQUFLO0FBQ2Q7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQzdEQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFLQSxJQUFBLGdCQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsd0JBQUEsR0FBQSxPQUFBO0FBVU8sTUFBTSxPQUFPLEdBQUEsT0FBQSxDQUFBLE9BQUEsR0FBRyxHQUFHOztBQUUxQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxNQUFNLGlCQUEyQyxHQUFHLElBQUksR0FBRyxDQUFDLENBQzFELENBQUMsU0FBUyxFQUFFLFVBQVUsQ0FBQyxFQUN2QixDQUFDLFNBQVMsRUFBRSxLQUFLLENBQUMsRUFDbEIsQ0FBQyxlQUFlLEVBQUUsUUFBUSxDQUFDLEVBQzNCLENBQUMsZUFBZSxFQUFFLFFBQVEsQ0FBQyxDQUM1QixDQUFDOztBQUVGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUFDLHFCQUc3QixFQUFFO0VBQ0QsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsYUFBYSxDQUFDLElBQUksR0FBRyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUN2RCxPQUFPLGFBQWE7QUFDdEI7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUyxjQUFjLENBQUMsS0FBOEIsRUFBRTtFQUN0RCxNQUFNO0lBQ0osaUJBQWlCLEVBQUUsc0JBQXNCO0lBQ3pDLG9CQUFvQixFQUFFLHlCQUF5QjtJQUMvQyx5QkFBeUIsRUFBRTtFQUM3QixDQUFDLEdBQUcsS0FBSztFQUVULElBQUksQ0FBQyxzQkFBc0IsSUFBSSxDQUFDLElBQUEsZUFBUSxFQUFDLHNCQUFzQixDQUFDLEVBQUU7SUFBQSxJQUFBLGNBQUEsRUFBQSxxQkFBQTtJQUNoRSxDQUFBLGNBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGNBQUEsZ0JBQUEscUJBQUEsR0FBYixjQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsY0FBQSxFQUNFLElBQUksS0FBSyxDQUNQLDhFQUNGLENBQ0YsQ0FBQztJQUVELE9BQU8sS0FBSztFQUNkO0VBRUEsSUFDRSxDQUFDLElBQUEsa0JBQVcsRUFBQyxzQkFBc0IsRUFBRSx5QkFBeUIsQ0FBQyxJQUMvRCxPQUFPLHNCQUFzQixDQUFDLHVCQUF1QixLQUFLLFFBQVEsRUFDbEU7SUFBQSxJQUFBLGVBQUEsRUFBQSxxQkFBQTtJQUNBLENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxnQkFBQSxxQkFBQSxHQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxlQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1Asa0ZBQ0YsQ0FDRixDQUFDO0lBRUQsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxJQUNFLENBQUMsSUFBQSxrQkFBVyxFQUFDLHNCQUFzQixFQUFFLGdDQUFnQyxDQUFDLElBQ3RFLENBQUMsSUFBQSxlQUFRLEVBQUMsc0JBQXNCLENBQUMsOEJBQThCLENBQUMsRUFDaEU7SUFBQSxJQUFBLGVBQUEsRUFBQSxxQkFBQTtJQUNBLENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxnQkFBQSxxQkFBQSxHQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxlQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1AsMEZBQ0YsQ0FDRixDQUFDO0lBRUQsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxJQUFJLENBQUMseUJBQXlCLElBQUksQ0FBQyxJQUFBLGVBQVEsRUFBQyx5QkFBeUIsQ0FBQyxFQUFFO0lBQUEsSUFBQSxlQUFBLEVBQUEscUJBQUE7SUFDdEUsQ0FBQSxlQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxlQUFBLGdCQUFBLHFCQUFBLEdBQWIsZUFBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGVBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCxpRkFDRixDQUNGLENBQUM7SUFFRCxPQUFPLEtBQUs7RUFDZDtFQUVBLElBQUksQ0FBQyxJQUFBLGVBQVEsRUFBQyx5QkFBeUIsQ0FBQyxRQUFRLENBQUMsRUFBRTtJQUFBLElBQUEsZUFBQSxFQUFBLHFCQUFBO0lBQ2pELENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxnQkFBQSxxQkFBQSxHQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxlQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1AsNkVBQ0YsQ0FDRixDQUFDO0lBRUQsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxJQUNFLENBQUMsOEJBQThCLElBQy9CLENBQUMsSUFBQSxlQUFRLEVBQUMsOEJBQThCLENBQUMsRUFDekM7SUFBQSxJQUFBLGVBQUEsRUFBQSxxQkFBQTtJQUNBLENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxnQkFBQSxxQkFBQSxHQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxlQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1Asc0ZBQ0YsQ0FDRixDQUFDO0lBRUQsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxJQUFJLENBQUMsSUFBQSxlQUFRLEVBQUMsOEJBQThCLENBQUMsT0FBTyxDQUFDLEVBQUU7SUFBQSxJQUFBLGVBQUEsRUFBQSxxQkFBQTtJQUNyRCxDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZ0JBQUEscUJBQUEsR0FBYixlQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsZUFBQSxFQUNFLElBQUksS0FBSyxDQUNQLGlGQUNGLENBQ0YsQ0FBQztJQUVELE9BQU8sS0FBSztFQUNkO0VBRUEsTUFBTSxjQUFjLEdBQUcsVUFBVSxDQUMvQixzQkFBc0IsQ0FBQyx1QkFBdUIsRUFDOUMsc0JBQXNCLENBQUMsOEJBQ3pCLENBQUM7RUFFRCxJQUFJLE9BQU8sY0FBYyxLQUFLLFFBQVEsRUFBRTtJQUFBLElBQUEsZUFBQSxFQUFBLHFCQUFBO0lBQ3RDLENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxnQkFBQSxxQkFBQSxHQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxlQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1Asa0tBQ0YsQ0FDRixDQUFDO0lBRUQsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxNQUFNLGVBQXlCLEdBQUcsRUFBRTs7RUFFcEM7RUFDQTtFQUNBLE1BQU0sT0FBTyxHQUFHLE1BQU0sQ0FBQyxPQUFPLENBQUMseUJBQXlCLENBQUMsUUFBUSxDQUc5RDtFQUVILHlCQUF5QixDQUFDLFFBQVEsR0FBRyxPQUFPLENBQUMsTUFBTSxDQUVqRCxDQUFDLFdBQVcsRUFBRSxDQUFDLEdBQUcsRUFBRSxPQUFPLENBQUMsS0FBSztJQUNqQyxNQUFNLGNBQWMsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUM7SUFDdkQsTUFBTSxjQUFjLEdBQUcsY0FBYyxDQUFDLFFBQVEsQ0FDNUMsK0JBQWMsQ0FBQyxnQkFDakIsQ0FBQztJQUVELElBQUksQ0FBQyxjQUFjLEVBQUU7TUFDbkIsT0FBTztRQUNMLEdBQUcsV0FBVztRQUNkLENBQUMsR0FBRyxHQUFHO01BQ1QsQ0FBQztJQUNIO0lBRUEsZUFBZSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUM7SUFFekIsTUFBTSwyQ0FBMkMsR0FBRyxJQUFBLCtDQUFzQixFQUN4RSxpQ0FBaUMsQ0FBQyxPQUFPLENBQUMsRUFDMUMsY0FDRixDQUFDO0lBRUQsTUFBTTtNQUNKLElBQUksR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7TUFDakIsRUFBRSxHQUFHLElBQUEsY0FBTSxFQUFDLENBQUM7TUFDYixPQUFPLEdBQUcsR0FBRztNQUNiLGdCQUFnQixHQUFHO0lBQ3JCLENBQUMsR0FBRyxPQUFPLENBQUMsV0FBVyxDQUFDLHNEQUE2QixDQUFDLElBQUksQ0FBQyxDQUFDO0lBRTVELE1BQU0sVUFBOEMsR0FBRztNQUNyRCxHQUFHLE9BQU87TUFDVixXQUFXLEVBQUU7UUFDWCxHQUFHLE9BQU8sQ0FBQyxXQUFXO1FBQ3RCLENBQUMsc0RBQTZCLEdBQUc7VUFDL0IsT0FBTyxFQUFFLENBQ1A7WUFDRSxJQUFJLEVBQUUseUNBQWdCO1lBQ3RCLEtBQUssRUFBRTtVQUNULENBQUMsQ0FDRjtVQUNELElBQUk7VUFDSixFQUFFO1VBQ0YsT0FBTztVQUNQO1FBQ0Y7TUFDRjtJQUNGLENBQUM7SUFFRCxPQUFPO01BQ0wsR0FBRyxXQUFXO01BQ2QsQ0FBQyxHQUFHLEdBQUc7SUFDVCxDQUFDO0VBQ0gsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO0VBRU4sTUFBTSxjQUFjLEdBQUcsOEJBQThCLENBQUMsT0FBTztFQUM3RCxNQUFNLE9BQU8sR0FBRyxNQUFNLENBQUMsV0FBVyxDQUNoQyxlQUFlLENBQUMsR0FBRyxDQUFFLE9BQU8sSUFBSyxDQUMvQixPQUFPLEVBQ1Asc0JBQXNCLENBQUMsdUJBQXVCLENBQy9DLENBQ0gsQ0FBQztFQUVELDhCQUE4QixDQUFDLE9BQU8sR0FBRztJQUN2QyxHQUFHLGNBQWM7SUFDakIsR0FBRztFQUNMLENBQUM7RUFFRCxPQUFPLEtBQUs7QUFDZDs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVMsaUNBQWlDLENBQ3hDLE9BQTJDLEVBQ3hCO0VBQUEsSUFBQSxxQkFBQTtFQUNuQixNQUFNLGNBQWMsSUFBQSxxQkFBQSxHQUFHLE9BQU8sQ0FBQyxXQUFXLENBQ3hDLHNEQUE2QixDQUM5QixjQUFBLHFCQUFBLGdCQUFBLHFCQUFBLEdBRnNCLHFCQUFBLENBRXBCLE9BQU8sY0FBQSxxQkFBQSx1QkFGYSxxQkFBQSxDQUVYLElBQUksQ0FBRSxNQUFNLElBQUssTUFBTSxDQUFDLElBQUksS0FBSyx5Q0FBZ0IsQ0FBQztFQUU5RCxJQUFJLENBQUMsY0FBYyxFQUFFO0lBQ25CLE9BQU87TUFDTCxrQkFBa0IsRUFBRSxLQUFLO01BQ3pCLGNBQWMsRUFBRSxDQUFDLENBQUM7TUFDbEIsY0FBYyxFQUFFLENBQUMsQ0FBQztNQUNsQixpQkFBaUIsRUFBRSxDQUFDO0lBQ3RCLENBQUM7RUFDSDtFQUVBLE9BQU8sY0FBYyxDQUFDLEtBQUs7QUFDN0I7QUFFQSxTQUFTLFVBQVUsQ0FDakIsZUFBdUIsRUFDdkIsOEJBQTZDLEVBQzVCO0VBQ2pCLE1BQU0saUNBQWlDLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FDdEQsOEJBQ0YsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDLEdBQUcsTUFBTSxDQUFDLEtBQUs7SUFDckIsSUFDRSxDQUFDLElBQUEsZUFBUSxFQUFDLE1BQU0sQ0FBQyxJQUNqQixDQUFDLElBQUEsa0JBQVcsRUFBQyxNQUFNLEVBQUUsY0FBYyxDQUFDLElBQ3BDLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLEVBQ25DO01BQ0EsT0FBTyxLQUFLO0lBQ2Q7SUFFQSxPQUFPLE1BQU0sQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUM1QixRQUFRLElBQ1AsSUFBQSxlQUFRLEVBQUMsUUFBUSxDQUFDLElBQUksUUFBUSxDQUFDLGVBQWUsS0FBSyxlQUN2RCxDQUFDO0VBQ0gsQ0FBQyxDQUFDO0VBRUYsSUFBSSxpQ0FBaUMsRUFBRTtJQUNyQztJQUNBO0lBQ0EsT0FBTyxpQ0FBaUMsQ0FBQyxDQUFDLENBQUM7RUFDN0M7RUFFQSxPQUFPLGlCQUFpQixDQUFDLEdBQUcsQ0FBQyxlQUFlLENBQUM7QUFDL0M7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ3pUQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQWlCTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEtBQUs7QUFFNUIsU0FBUyxjQUFjLENBQUMsS0FBNEIsRUFBRTtFQUNwRCxJQUNFLENBQUMsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSx1QkFBdUIsQ0FBQyxJQUM1QyxDQUFDLElBQUEsZUFBUSxFQUFDLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxFQUN0QztJQUFBLElBQUEsY0FBQSxFQUFBLHFCQUFBO0lBQ0EsQ0FBQSxjQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxjQUFBLGdCQUFBLHFCQUFBLEdBQWIsY0FBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGNBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCx3Q0FBd0MsT0FBTyxLQUFLLENBQUMscUJBQXFCLEVBQzVFLENBQ0YsQ0FBQztJQUNELE9BQU8sS0FBSztFQUNkO0VBRUEsSUFBSSxJQUFBLGtCQUFXLEVBQUMsS0FBSyxDQUFDLHFCQUFxQixFQUFFLHVCQUF1QixDQUFDLEVBQUU7SUFDckUsT0FBTyxLQUFLLENBQUMscUJBQXFCLENBQUMscUJBQXFCO0VBQzFEO0VBRUEsSUFDRSxJQUFBLGtCQUFXLEVBQUMsS0FBSyxDQUFDLHFCQUFxQixFQUFFLDhCQUE4QixDQUFDLEVBQ3hFO0lBQ0EsT0FBTyxLQUFLLENBQUMscUJBQXFCLENBQUMsNEJBQTRCO0VBQ2pFO0VBRUEsT0FBTyxLQUFLO0FBQ2Q7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FDM0IscUJBQW9DLEVBQ1o7RUFDeEIsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsY0FBYyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7RUFDbEMsT0FBTyxhQUFhO0FBQ3RCOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUMvREEsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsa0JBQUEsR0FBQSxPQUFBO0FBSUEsSUFBQSxnQkFBQSxHQUFBLE9BQUE7QUFPQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBT08sTUFBTSxPQUFPLEdBQUEsT0FBQSxDQUFBLE9BQUEsR0FBRyxHQUFHOztBQUUxQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sZUFBZSxPQUFPLENBQUMscUJBQW9DLEVBQUU7RUFDbEUsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsYUFBYSxDQUFDLElBQUksR0FBRyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUN2RCxPQUFPLGFBQWE7QUFDdEI7QUFFQSxTQUFTLGNBQWMsQ0FBQyxLQUE4QixFQUFFO0VBQ3RELElBQ0UsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSxtQkFBbUIsQ0FBQyxJQUN2QyxJQUFBLGVBQVEsRUFBQyxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFDakMsSUFBQSxlQUFRLEVBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLDhCQUE4QixDQUFDLEVBQ2hFO0lBQ0EsTUFBTSxZQUFZLEdBQUcsZUFBZTtJQUNwQyxNQUFNLG1CQUFtQixHQUFHLHdCQUFPLENBQUMsWUFBWSxDQUFDO0lBQ2pELE1BQU0seUJBQStDLEdBQUc7TUFDdEQsT0FBTyxFQUFFLG1CQUFtQjtNQUM1QixJQUFJLEVBQUUsZ0NBQWUsQ0FBQyxZQUFZLENBQUM7TUFDbkMsY0FBYyxFQUFFLCtCQUFjLENBQUMsWUFBWSxDQUFDO01BQzVDLGlCQUFpQixFQUFFLENBQUMsaUNBQWdCLENBQUMsWUFBWSxDQUFDLENBQUM7TUFDbkQsdUJBQXVCLEVBQUUsQ0FBQztNQUMxQiw0QkFBNEIsRUFBRSxDQUFDO01BQy9CLFlBQVksRUFBRSxDQUNaO1FBQ0UsZUFBZSxFQUFFLFlBQVk7UUFDN0IsSUFBSSxFQUFFLGtDQUFlLENBQUMsTUFBTTtRQUM1QixHQUFHLEVBQUUsNkNBQTRCLENBQUMsWUFBWTtNQUNoRCxDQUFDO0lBRUwsQ0FBQztJQUVELEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyw4QkFBOEIsQ0FDcEQsbUJBQW1CLENBQ3BCLEdBQUcseUJBQXlCO0VBQy9CO0VBQ0EsT0FBTyxLQUFLO0FBQ2Q7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ2pFQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFZTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEdBQUc7O0FBRTFCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FDM0IscUJBQW9DLEVBQ1o7RUFDeEIsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFFcEMsYUFBYSxDQUFDLElBQUksR0FBRyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUV2RCxPQUFPLGFBQWE7QUFDdEI7QUFFQSxTQUFTLGNBQWMsQ0FDckIsS0FBOEIsRUFDTDtFQUN6QixJQUFJLENBQUMsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSxrQkFBa0IsQ0FBQyxFQUFFO0lBQUEsSUFBQSxjQUFBLEVBQUEscUJBQUE7SUFDM0MsQ0FBQSxjQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxjQUFBLGdCQUFBLHFCQUFBLEdBQWIsY0FBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGNBQUEsRUFDRSxJQUFJLEtBQUssQ0FBQyxhQUFhLE9BQU8sK0JBQStCLENBQy9ELENBQUM7SUFDRCxPQUFPLEtBQUs7RUFDZDtFQUVBLElBQUksQ0FBQyxJQUFBLGtCQUFXLEVBQUMsS0FBSyxFQUFFLG9CQUFvQixDQUFDLEVBQUU7SUFBQSxJQUFBLGVBQUEsRUFBQSxxQkFBQTtJQUM3QyxDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZ0JBQUEscUJBQUEsR0FBYixlQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsZUFBQSxFQUNFLElBQUksS0FBSyxDQUFDLGFBQWEsT0FBTyxpQ0FBaUMsQ0FDakUsQ0FBQztJQUNELE9BQU8sS0FBSztFQUNkO0VBRUEsSUFBSSxDQUFDLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUseUJBQXlCLENBQUMsRUFBRTtJQUFBLElBQUEsZUFBQSxFQUFBLHFCQUFBO0lBQ2xELENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxnQkFBQSxxQkFBQSxHQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxlQUFBLEVBQ0UsSUFBSSxLQUFLLENBQUMsYUFBYSxPQUFPLHNDQUFzQyxDQUN0RSxDQUFDO0lBQ0QsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxNQUFNLHFCQUFxQixHQUFHLEtBQUssQ0FBQyxnQkFBeUM7RUFDN0UsTUFBTSw0QkFBNEIsR0FDaEMsS0FBSyxDQUFDLHVCQUF1RDtFQUMvRCxNQUFNLHVCQUF1QixHQUMzQixLQUFLLENBQUMsa0JBQTZDO0VBRXJELElBQUksQ0FBQyxJQUFBLGVBQVEsRUFBQyxxQkFBcUIsQ0FBQyxFQUFFO0lBQUEsSUFBQSxlQUFBLEVBQUEscUJBQUE7SUFDcEMsQ0FBQSxlQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxlQUFBLGdCQUFBLHFCQUFBLEdBQWIsZUFBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGVBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8sK0JBQStCLE9BQU8scUJBQXFCLHFCQUNqRixDQUNGLENBQUM7SUFDRCxPQUFPLEtBQUs7RUFDZDtFQUVBLElBQUksQ0FBQyxJQUFBLGVBQVEsRUFBQyw0QkFBNEIsQ0FBQyxFQUFFO0lBQUEsSUFBQSxlQUFBLEVBQUEscUJBQUE7SUFDM0MsQ0FBQSxlQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxlQUFBLGdCQUFBLHFCQUFBLEdBQWIsZUFBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGVBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8sc0NBQXNDLE9BQU8sNEJBQTRCLHFCQUMvRixDQUNGLENBQUM7SUFDRCxPQUFPLEtBQUs7RUFDZDtFQUVBLElBQUksQ0FBQyxJQUFBLGVBQVEsRUFBQyx1QkFBdUIsQ0FBQyxFQUFFO0lBQUEsSUFBQSxlQUFBLEVBQUEscUJBQUE7SUFDdEMsQ0FBQSxlQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxlQUFBLGdCQUFBLHFCQUFBLEdBQWIsZUFBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGVBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8saUNBQWlDLE9BQU8sdUJBQXVCLHFCQUNyRixDQUNGLENBQUM7SUFDRCxPQUFPLEtBQUs7RUFDZDtFQUVBLE1BQU07SUFBRTtFQUFpQixDQUFDLEdBQUcsdUJBQXVCO0VBRXBELE1BQU0sUUFBUSxHQUFHLE1BQU0sQ0FBQyxNQUFNLENBQUMsZ0JBQWdCLENBQUMsUUFBUSxDQUFDO0VBQ3pELE1BQU0sV0FBVyxHQUFHLFFBQVEsQ0FBQyxNQUFNLENBQUUsT0FBTyxJQUMxQyxJQUFBLDRCQUFnQixFQUFDLE9BQU8sQ0FBQyxJQUFJLENBQy9CLENBQUM7RUFDRCxNQUFNLG1CQUFtQixHQUFHLFdBQVcsQ0FBQyxHQUFHLENBQUUsT0FBTyxJQUFLLE9BQU8sQ0FBQyxPQUFPLENBQUM7O0VBRXpFO0VBQ0EsSUFBSSxJQUFBLGtCQUFXLEVBQUMscUJBQXFCLEVBQUUsV0FBVyxDQUFDLEVBQUU7SUFDbkQsS0FBSyxNQUFNLE9BQU8sSUFBSSxNQUFNLENBQUMsSUFBSSxDQUFDLHFCQUFxQixDQUFDLFNBQVMsQ0FBQyxFQUFFO01BQ2xFLE1BQU0sZ0JBQWdCLEdBQ3BCLHFCQUFxQixDQUFDLFNBQVMsQ0FBQyxPQUFPLENBQWtCO01BQzNELEtBQUssTUFBTSxPQUFPLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxFQUFFO1FBQ25ELElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLEVBQUU7VUFDMUMsT0FBTyxxQkFBcUIsQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFrQixDQUM5RCxPQUFPLENBQ1I7UUFDSDtNQUNGO0lBQ0Y7RUFDRjs7RUFFQTtFQUNBLElBQUksSUFBQSxrQkFBVyxFQUFDLHFCQUFxQixFQUFFLG1CQUFtQixDQUFDLEVBQUU7SUFDM0QsS0FBSyxNQUFNLE9BQU8sSUFBSSxNQUFNLENBQUMsSUFBSSxDQUMvQixxQkFBcUIsQ0FBQyxpQkFDeEIsQ0FBQyxFQUFFO01BQ0QsTUFBTSxnQkFBZ0IsR0FDcEIscUJBQXFCLENBQUMsaUJBQWlCLENBQUMsT0FBTyxDQUFrQjtNQUVuRSxLQUFLLE1BQU0sT0FBTyxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsRUFBRTtRQUNuRCxJQUFJLENBQUMsbUJBQW1CLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxFQUFFO1VBQzFDLE9BQU8scUJBQXFCLENBQUMsaUJBQWlCLENBQzVDLE9BQU8sQ0FDUixDQUFDLE9BQU8sQ0FBQztRQUNaO01BQ0Y7SUFDRjtFQUNGOztFQUVBO0VBQ0EsSUFBSSxJQUFBLGtCQUFXLEVBQUMscUJBQXFCLEVBQUUsa0JBQWtCLENBQUMsRUFBRTtJQUMxRCxLQUFLLE1BQU0sT0FBTyxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMscUJBQXFCLENBQUMsZ0JBQWdCLENBQUMsRUFBRTtNQUN6RSxNQUFNLGdCQUFnQixHQUNwQixxQkFBcUIsQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLENBQWtCO01BQ2xFLEtBQUssTUFBTSxPQUFPLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxFQUFFO1FBQ25ELElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLEVBQUU7VUFDMUMsT0FBTyxxQkFBcUIsQ0FBQyxnQkFBZ0IsQ0FDM0MsT0FBTyxDQUNSLENBQUMsT0FBTyxDQUFDO1FBQ1o7TUFDRjtJQUNGO0VBQ0Y7O0VBRUE7RUFDQSxJQUFJLElBQUEsa0JBQVcsRUFBQyw0QkFBNEIsRUFBRSxlQUFlLENBQUMsRUFBRTtJQUM5RCxLQUFLLE1BQU0sY0FBYyxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQ3RDLDRCQUE0QixDQUFDLGFBQy9CLENBQUMsRUFBRTtNQUNELElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxRQUFRLENBQUMsY0FBYyxDQUFDLEVBQUU7UUFDakQsT0FBTyw0QkFBNEIsQ0FBQyxhQUFhLENBQy9DLGNBQWMsQ0FDZjtNQUNIO0lBQ0Y7RUFDRjtFQUVBLE9BQU8sS0FBSztBQUNkOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNyS0EsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFPTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEdBQUc7O0FBRTFCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUMzQixxQkFBb0MsRUFDWjtFQUN4QixNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUVwQyxhQUFhLENBQUMsSUFBSSxHQUFHLGNBQWMsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDO0VBRXZELE9BQU8sYUFBYTtBQUN0QjtBQUVBLFNBQVMsY0FBYyxDQUNyQixLQUE4QixFQUNMO0VBQ3pCO0VBQ0EsSUFBSSxDQUFDLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUsa0JBQWtCLENBQUMsRUFBRTtJQUMzQyxPQUFPLENBQUMsSUFBSSxDQUFDLDBDQUEwQyxDQUFDO0lBQ3hELE9BQU8sS0FBSztFQUNkO0VBRUEsTUFBTSxxQkFBcUIsR0FBRyxLQUFLLENBQUMsZ0JBQWdCOztFQUVwRDtFQUNBLElBQUksQ0FBQyxJQUFBLGVBQVEsRUFBQyxxQkFBcUIsQ0FBQyxFQUFFO0lBQUEsSUFBQSxjQUFBLEVBQUEscUJBQUE7SUFDcEMsQ0FBQSxjQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxjQUFBLGdCQUFBLHFCQUFBLEdBQWIsY0FBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGNBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8sK0JBQStCLE9BQU8scUJBQXFCLHFCQUNqRixDQUNGLENBQUM7SUFDRCxPQUFPLEtBQUs7RUFDZDtFQUVBLElBQUksSUFBQSxrQkFBVyxFQUFDLHFCQUFxQixFQUFFLFFBQVEsQ0FBQyxFQUFFO0lBQ2hEO0lBQ0EsT0FBTyxxQkFBcUIsQ0FBQyxNQUFNO0VBQ3JDO0VBRUEsSUFBSSxJQUFBLGtCQUFXLEVBQUMscUJBQXFCLEVBQUUsZ0JBQWdCLENBQUMsRUFBRTtJQUN4RDtJQUNBLE9BQU8scUJBQXFCLENBQUMsY0FBYztFQUM3QztFQUVBLElBQUksSUFBQSxrQkFBVyxFQUFDLHFCQUFxQixFQUFFLGVBQWUsQ0FBQyxFQUFFO0lBQ3ZEO0lBQ0EsT0FBTyxxQkFBcUIsQ0FBQyxhQUFhO0VBQzVDO0VBRUEsT0FBTyxLQUFLO0FBQ2Q7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ25FQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQVFPLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsR0FBRzs7QUFFMUI7QUFDQSxNQUFNLGdCQUFnQixHQUFHLGtCQUFrQjtBQUMzQyxNQUFNLDZCQUE2QixHQUFHLGtCQUFrQjtBQWV4RDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FDM0IscUJBQW9DLEVBQ1o7RUFDeEIsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFFcEMsYUFBYSxDQUFDLElBQUksR0FBRyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUV2RCxPQUFPLGFBQWE7QUFDdEI7QUFFQSxTQUFTLGNBQWMsQ0FDckIsS0FBOEIsRUFDTDtFQUN6QixJQUFJLENBQUMsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSxzQkFBc0IsQ0FBQyxFQUFFO0lBQUEsSUFBQSxjQUFBLEVBQUEscUJBQUE7SUFDL0MsQ0FBQSxjQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxjQUFBLGdCQUFBLHFCQUFBLEdBQWIsY0FBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGNBQUEsRUFDRSxJQUFJLEtBQUssQ0FBQyxhQUFhLE9BQU8sbUNBQW1DLENBQ25FLENBQUM7SUFDRCxPQUFPLEtBQUs7RUFDZDtFQUVBLElBQUksQ0FBQyxJQUFBLGtCQUFXLEVBQUMsS0FBSyxFQUFFLG1CQUFtQixDQUFDLEVBQUU7SUFBQSxJQUFBLGVBQUEsRUFBQSxxQkFBQTtJQUM1QyxDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZ0JBQUEscUJBQUEsR0FBYixlQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsZUFBQSxFQUNFLElBQUksS0FBSyxDQUFDLGFBQWEsT0FBTyxnQ0FBZ0MsQ0FDaEUsQ0FBQztJQUNELE9BQU8sS0FBSztFQUNkO0VBRUEsTUFBTSx5QkFBeUIsR0FBRyxLQUFLLENBQUMsb0JBQW9CO0VBQzVELE1BQU0sc0JBQXNCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQjtFQUV0RCxJQUFJLENBQUMsSUFBQSxlQUFRLEVBQUMseUJBQXlCLENBQUMsRUFBRTtJQUFBLElBQUEsZUFBQSxFQUFBLHFCQUFBO0lBQ3hDLENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxnQkFBQSxxQkFBQSxHQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxlQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLG1DQUFtQyxPQUFPLHlCQUF5QixxQkFDekYsQ0FDRixDQUFDO0lBQ0QsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxJQUFJLENBQUMsSUFBQSxlQUFRLEVBQUMsc0JBQXNCLENBQUMsRUFBRTtJQUFBLElBQUEsZUFBQSxFQUFBLHFCQUFBO0lBQ3JDLENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxnQkFBQSxxQkFBQSxHQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxlQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLGdDQUFnQyxPQUFPLHNCQUFzQixxQkFDbkYsQ0FDRixDQUFDO0lBQ0QsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxJQUFJLENBQUMsSUFBQSxrQkFBVyxFQUFDLHNCQUFzQixFQUFFLGdDQUFnQyxDQUFDLEVBQUU7SUFBQSxJQUFBLGVBQUEsRUFBQSxxQkFBQTtJQUMxRSxDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZ0JBQUEscUJBQUEsR0FBYixlQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsZUFBQSxFQUNFLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTywrREFDdEIsQ0FDRixDQUFDO0lBQ0QsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxNQUFNO0lBQUU7RUFBK0IsQ0FBQyxHQUFHLHNCQUFzQjtFQUVqRSxJQUFJLENBQUMsSUFBQSxlQUFRLEVBQUMsOEJBQThCLENBQUMsRUFBRTtJQUFBLElBQUEsZUFBQSxFQUFBLHFCQUFBO0lBQzdDLENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxnQkFBQSxxQkFBQSxHQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxlQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLCtEQUErRCxPQUFPLDhCQUE4QixxQkFDMUgsQ0FDRixDQUFDO0lBQ0QsT0FBTyxLQUFLO0VBQ2Q7O0VBRUE7RUFDQSxNQUFNLGFBQWEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLDhCQUE4QixDQUFDOztFQUVqRTtFQUNBLE1BQU0sbUJBQW1CLEdBQUcsYUFBYSxDQUFDLEdBQUcsQ0FBRSxPQUFPLElBQUs7SUFDekQsTUFBTSxPQUFPLEdBQUcsUUFBUSxDQUFDLE9BQU8sRUFBRSxFQUFFLENBQUM7SUFDckMsT0FBTyxVQUFVLE9BQU8sRUFBRTtFQUM1QixDQUFDLENBQUM7RUFFRixJQUFJLENBQUMsSUFBQSxrQkFBVyxFQUFDLHlCQUF5QixFQUFFLFVBQVUsQ0FBQyxFQUFFO0lBQ3ZEO0lBQ0EsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxNQUFNO0lBQUU7RUFBUyxDQUFDLEdBQUcseUJBQXlCO0VBRTlDLElBQUksQ0FBQyxJQUFBLGVBQVEsRUFBQyxRQUFRLENBQUMsRUFBRTtJQUFBLElBQUEsZUFBQSxFQUFBLHFCQUFBO0lBQ3ZCLENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxnQkFBQSxxQkFBQSxHQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxlQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLDRDQUE0QyxPQUFPLFFBQVEscUJBQ2pGLENBQ0YsQ0FBQztJQUNELE9BQU8sS0FBSztFQUNkOztFQUVBO0VBQ0EsS0FBSyxNQUFNLFVBQVUsSUFBSSxNQUFNLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxFQUFFO0lBQzlDLE1BQU0sT0FBTyxHQUFHLFFBQVEsQ0FBQyxVQUFVLENBQUM7SUFFcEMsSUFBSSxDQUFDLElBQUEsZUFBUSxFQUFDLE9BQU8sQ0FBQyxFQUFFO01BQ3RCO0lBQ0Y7SUFFQSxJQUNFLENBQUMsSUFBQSxrQkFBVyxFQUFDLE9BQU8sRUFBRSxhQUFhLENBQUMsSUFDcEMsQ0FBQyxJQUFBLGVBQVEsRUFBQyxPQUFPLENBQUMsV0FBVyxDQUFDLEVBQzlCO01BQ0E7SUFDRjtJQUVBLE1BQU07TUFBRTtJQUFZLENBQUMsR0FBRyxPQUFPOztJQUUvQjtJQUNBLElBQUksQ0FBQyxJQUFBLGtCQUFXLEVBQUMsV0FBVyxFQUFFLDZCQUE2QixDQUFDLEVBQUU7TUFDNUQ7SUFDRjtJQUVBLE1BQU0sZ0JBQWdCLEdBQUcsV0FBVyxDQUFDLDZCQUE2QixDQUFDO0lBRW5FLElBQUksQ0FBQyxJQUFBLGVBQVEsRUFBQyxnQkFBZ0IsQ0FBQyxFQUFFO01BQy9CO0lBQ0Y7SUFFQSxJQUNFLENBQUMsSUFBQSxrQkFBVyxFQUFDLGdCQUFnQixFQUFFLFNBQVMsQ0FBQyxJQUN6QyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsZ0JBQWdCLENBQUMsT0FBTyxDQUFDLEVBQ3hDO01BQ0E7SUFDRjs7SUFFQTtJQUNBLEtBQUssTUFBTSxNQUFNLElBQUksZ0JBQWdCLENBQUMsT0FBTyxFQUFFO01BQzdDLElBQUksQ0FBQyxJQUFBLGVBQVEsRUFBQyxNQUFNLENBQUMsSUFBSSxNQUFNLENBQUMsSUFBSSxLQUFLLGdCQUFnQixFQUFFO1FBQ3pEO01BQ0Y7TUFFQSxJQUFJLENBQUMsSUFBQSxrQkFBVyxFQUFDLE1BQU0sRUFBRSxPQUFPLENBQUMsSUFBSSxDQUFDLElBQUEsZUFBUSxFQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsRUFBRTtRQUM1RDtNQUNGO01BRUEsTUFBTSxXQUFXLEdBQUcsTUFBTSxDQUFDLEtBQTBCOztNQUVyRDtNQUNBLElBQUksSUFBQSxlQUFRLEVBQUMsV0FBVyxDQUFDLGNBQWMsQ0FBQyxFQUFFO1FBQ3hDLEtBQUssTUFBTSxRQUFRLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsY0FBYyxDQUFDLEVBQUU7VUFDOUQ7VUFDQSxJQUNFLFFBQVEsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLElBQzlCLENBQUMsUUFBUSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsRUFDL0I7WUFDQTtVQUNGOztVQUVBO1VBQ0EsSUFBSSxDQUFDLG1CQUFtQixDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsRUFBRTtZQUMzQyxPQUFPLFdBQVcsQ0FBQyxjQUFjLENBQUMsUUFBUSxDQUFnQjtVQUM1RDtRQUNGO01BQ0Y7O01BRUE7TUFDQSxJQUFJLElBQUEsZUFBUSxFQUFDLFdBQVcsQ0FBQyxjQUFjLENBQUMsRUFBRTtRQUN4QyxLQUFLLE1BQU0sUUFBUSxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLGNBQWMsQ0FBQyxFQUFFO1VBQzlEO1VBQ0EsSUFDRSxRQUFRLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxJQUM5QixDQUFDLFFBQVEsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLEVBQy9CO1lBQ0E7VUFDRjs7VUFFQTtVQUNBLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLEVBQUU7WUFDM0MsT0FBTyxXQUFXLENBQUMsY0FBYyxDQUFDLFFBQVEsQ0FBZ0I7VUFDNUQ7UUFDRjtNQUNGO0lBQ0Y7RUFDRjtFQUVBLE9BQU8sS0FBSztBQUNkOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDNU5BLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBUUEsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsV0FBQSxHQUFBLE9BQUE7QUFLQSxJQUFBLFdBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxnQkFBQSxHQUFBLE9BQUE7QUFFQTtBQUNBO0FBQ0E7O0FBbUJPLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsR0FBRzs7QUFFMUI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUMzQixxQkFBb0MsRUFDWjtFQUN4QixNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUVwQyxhQUFhLENBQUMsSUFBSSxHQUFHLGNBQWMsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDO0VBRXZELE9BQU8sYUFBYTtBQUN0Qjs7QUF5QkE7QUFDQTtBQUNBO0FBQ0E7O0FBY0E7QUFDQTtBQUNBO0FBQ0E7O0FBV0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxTQUFTLGdCQUFnQixDQUFDLFFBQWdCLEVBQUU7RUFDakQsTUFBTSxJQUFJLEdBQUcsZUFBUSxDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUU7SUFBRSxPQUFPLEVBQUU7RUFBSyxDQUFDLENBQUM7RUFDMUQsSUFBSSxJQUFJLENBQUMsT0FBTyxFQUFFO0lBQ2hCLE1BQU0sR0FBRyxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQzs7SUFFdEI7SUFDQSxNQUFNLFdBQVcsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDO0lBQ2xELElBQUksV0FBVyxDQUFDLFFBQVEsQ0FBQyxDQUFDLEdBQUcsR0FBRyxFQUFFO01BQ2hDLE1BQU0sSUFBSSxLQUFLLENBQUMsdUNBQXVDLENBQUM7SUFDMUQ7SUFFQSxPQUFPLFdBQVcsQ0FBQyxLQUFLLENBQUM7TUFDdkIsb0JBQW9CLEVBQUU7SUFDeEIsQ0FBQyxDQUFDO0VBQ0o7RUFFQSxJQUFJO0lBQ0YsTUFBTSxNQUFNLEdBQUcsSUFBQSwyQkFBZSxFQUFDLFFBQVEsRUFBRTtNQUFFLEdBQUcsRUFBRTtJQUFLLENBQUMsQ0FBQztJQUN2RCxNQUFNLElBQUksR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDMUIsTUFBTSxRQUFRLEdBQUcsZUFBUSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztJQUVuRCxJQUFBLGFBQU0sRUFBQyxRQUFRLENBQUMsT0FBTyxDQUFDO0lBQ3hCLE9BQU8sUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUM7RUFDakMsQ0FBQyxDQUFDLE1BQU07SUFDTixNQUFNLElBQUksS0FBSyxDQUNiLG9CQUFvQixRQUFRLDREQUM5QixDQUFDO0VBQ0g7QUFDRjs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVMsY0FBYyxDQUNyQixLQUE4QixFQUNMO0VBQ3pCLElBQ0UsQ0FBQyxJQUFBLGtCQUFXLEVBQUMsS0FBSyxFQUFFLG1CQUFtQixDQUFDLElBQ3hDLENBQUMsSUFBQSxlQUFRLEVBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLEVBQ2xDO0lBQ0EsT0FBTyxDQUFDLElBQUksQ0FDVixzQkFBc0IsT0FBTyw4REFDL0IsQ0FBQztJQUVELE9BQU8sS0FBSztFQUNkO0VBRUEsSUFDRSxDQUFDLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUsc0JBQXNCLENBQUMsSUFDM0MsQ0FBQyxJQUFBLGVBQVEsRUFBQyxLQUFLLENBQUMsb0JBQW9CLENBQUMsRUFDckM7SUFDQSxPQUFPLENBQUMsSUFBSSxDQUNWLElBQUksS0FBSyxDQUNQLHNCQUFzQixPQUFPLGlFQUMvQixDQUNGLENBQUM7SUFFRCxPQUFPLEtBQUs7RUFDZDtFQUVBLE1BQU0sc0JBQXNCLEdBQzFCLEtBQUssQ0FBQyxpQkFBaUQ7RUFDekQsTUFBTSx5QkFBeUIsR0FDN0IsS0FBSyxDQUFDLG9CQUF1RTs7RUFFL0U7RUFDQSxNQUFNLGNBQWMsR0FBRyxNQUFNLENBQUMsV0FBVyxDQUN2QyxNQUFNLENBQUMsTUFBTSxDQUFDLHlCQUF5QixDQUFDLFFBQVEsQ0FBQyxDQUM5QyxNQUFNLENBQ0osT0FBTyxJQUNOLElBQUEsb0JBQVEsRUFBQyxPQUFPLENBQUMsTUFBTSxDQUFDLElBQ3hCLE9BQU8sQ0FBQyxXQUFXLENBQUMsK0JBQWMsQ0FBQyxPQUFPLENBQzlDLENBQUMsQ0FDQSxPQUFPLENBQUUsT0FBTyxJQUFLO0lBQ3BCLE1BQU07TUFBRTtJQUFRLENBQUMsR0FBRyxPQUFPLENBQUMsV0FBVyxDQUFDLCtCQUFjLENBQUMsT0FBTyxDQUFDO0lBQy9ELElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUFFO01BQzNCLE9BQU8sRUFBRTtJQUNYO0lBRUEsTUFBTSxhQUFhLEdBQUcsT0FBTyxDQUFDLElBQUksQ0FDL0IsTUFBTSxJQUFLLE1BQU0sQ0FBQyxJQUFJLEtBQUssMEJBQWMsQ0FBQyxXQUM3QyxDQUFDO0lBRUQsSUFDRSxFQUFDLGFBQWEsYUFBYixhQUFhLGVBQWIsYUFBYSxDQUFFLEtBQUssS0FDckIsQ0FBQyxJQUFBLG9CQUFhLEVBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxJQUNuQyxDQUFDLElBQUEsa0JBQVcsRUFBQyxhQUFhLENBQUMsS0FBSyxFQUFFLE1BQU0sQ0FBQyxJQUN6QyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsRUFDeEM7TUFDQSxPQUFPLEVBQUU7SUFDWDtJQUVBLE1BQU0sSUFBSSxHQUFHLGFBQWEsQ0FBQyxLQUFLLENBQUMsSUFBNEI7SUFDN0QsT0FBTyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7TUFBRSxVQUFVO01BQUU7SUFBUSxDQUFDLEVBQUUsS0FBSyxLQUFzQjtNQUFBLElBQUEscUJBQUE7TUFDbkUsTUFBTSxRQUFRLEdBQUcsR0FBRyxPQUFPLENBQUMsTUFBTSxJQUFJLEtBQUssRUFBRTtNQUM3QyxNQUFNO1FBQUU7TUFBUSxDQUFDLEdBQUcsRUFBQSxxQkFBQSxHQUFBLHNCQUFzQixDQUFDLElBQUksY0FBQSxxQkFBQSx1QkFBM0IscUJBQUEsQ0FBOEIsUUFBUSxDQUFDLEtBQUk7UUFDN0QsT0FBTyxFQUFFO01BQ1gsQ0FBQzs7TUFFRDtNQUNBO01BQ0E7TUFDQSxNQUFNLE1BQU0sR0FBRyxJQUFBLDJCQUFlLEVBQUMsVUFBVSxDQUFDO01BQzFDLE1BQU0sSUFBSSxHQUNSLE1BQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQyxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLEdBQUcsT0FBTyxHQUNqRCxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxXQUFXLENBQUMsQ0FBQyxHQUMzQixnQkFBZ0IsQ0FBQyxVQUFVLENBQUM7TUFFbEMsT0FBTztRQUNMLEVBQUUsRUFBRSxXQUFXLE9BQU8sQ0FBQyxNQUFNLElBQUksS0FBSyxFQUFFO1FBQ3hDLFNBQVMsRUFBRSxJQUFJO1FBQ2YsUUFBUSxFQUFFLFVBQVU7UUFDcEIsV0FBVyxFQUFFLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxXQUFXLENBQUMsQ0FBQztRQUNyQyxNQUFNLEVBQUUsT0FBTyxDQUFDLE1BQWdCO1FBQ2hDLElBQUk7UUFDSjtNQUNGLENBQUM7SUFDSCxDQUFDLENBQUM7RUFDSixDQUFDLENBQUMsQ0FDRCxHQUFHLENBQUUsS0FBSyxJQUFLLENBQUMsS0FBSyxDQUFDLEVBQUUsRUFBRSxLQUFLLENBQUMsQ0FDckMsQ0FBQzs7RUFFRDtFQUNBLE1BQU0sc0JBQXNCLEdBQUcsTUFBTSxDQUFDLFdBQVcsQ0FDL0MsTUFBTSxDQUFDLE9BQU8sQ0FBQyxzQkFBc0IsQ0FBQyxNQUFNLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQ3JELENBQUMsQ0FBQyxFQUFFLEVBQUUsS0FBSyxDQUFDLEtBQWdDO0lBQzFDLE9BQU8sQ0FDTCxFQUFFLEVBQ0Y7TUFDRSxHQUFHLEtBQUs7TUFFUjtNQUNBLFNBQVMsRUFBRSxLQUFLO01BRWhCO01BQ0E7TUFDQSxRQUFRLEVBQUUsS0FBSyxDQUFDO0lBQ2xCLENBQUMsQ0FDRjtFQUNILENBQ0YsQ0FDRixDQUFDO0VBRUQsc0JBQXNCLENBQUMsTUFBTSxHQUFHO0lBQzlCLEdBQUcsc0JBQXNCO0lBQ3pCLEdBQUc7RUFDTCxDQUFDO0VBRUQsT0FBTyxzQkFBc0IsQ0FBQyxJQUFJO0VBRWxDLE9BQU8sS0FBSztBQUNkOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDMVJBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQVVPLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsR0FBRzs7QUFFMUI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FDM0IscUJBQW9DLEVBQ1o7RUFDeEIsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFFcEMsYUFBYSxDQUFDLElBQUksR0FBRyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUV2RCxPQUFPLGFBQWE7QUFDdEI7QUFFQSxTQUFTLGNBQWMsQ0FDckIsS0FBOEIsRUFDTDtFQUN6QixJQUFJLENBQUMsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSxtQkFBbUIsQ0FBQyxFQUFFO0lBQzVDLE9BQU8sQ0FBQyxJQUFJLENBQUMsYUFBYSxPQUFPLGdDQUFnQyxDQUFDO0lBQ2xFLE9BQU8sS0FBSztFQUNkO0VBRUEsTUFBTSxZQUFZLEdBQUcsS0FBSyxDQUFDLGlCQUFpQjtFQUM1QyxJQUFJLENBQUMsSUFBQSxlQUFRLEVBQUMsWUFBWSxDQUFDLEVBQUU7SUFBQSxJQUFBLGNBQUEsRUFBQSxxQkFBQTtJQUMzQixDQUFBLGNBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGNBQUEsZ0JBQUEscUJBQUEsR0FBYixjQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsY0FBQSxFQUNFLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTyx5Q0FBeUMsT0FBTyxZQUFZLEVBQ2xGLENBQ0YsQ0FBQztJQUNELE9BQU8sS0FBSztFQUNkO0VBRUEsSUFBSSxDQUFDLElBQUEsa0JBQVcsRUFBQyxZQUFZLEVBQUUsZ0NBQWdDLENBQUMsRUFBRTtJQUFBLElBQUEsZUFBQSxFQUFBLHFCQUFBO0lBQ2hFLENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxnQkFBQSxxQkFBQSxHQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxlQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLHNFQUN0QixDQUNGLENBQUM7SUFDRCxPQUFPLEtBQUs7RUFDZDtFQUVBLElBQUksQ0FBQyxJQUFBLGVBQVEsRUFBQyxZQUFZLENBQUMsOEJBQThCLENBQUMsRUFBRTtJQUFBLElBQUEsZUFBQSxFQUFBLHFCQUFBO0lBQzFELENBQUEsZUFBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsZUFBQSxnQkFBQSxxQkFBQSxHQUFiLGVBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxlQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLHdFQUF3RSxPQUFPLFlBQVksQ0FBQyw4QkFBOEIsR0FDaEosQ0FDRixDQUFDO0lBQ0QsT0FBTyxLQUFLO0VBQ2Q7O0VBRUE7RUFDQSxJQUFJLFlBQVksQ0FBQyw4QkFBOEIsQ0FBQyxrQkFBUyxDQUFDLElBQUksQ0FBQyxFQUFFO0lBQy9ELE9BQU8sS0FBSztFQUNkO0VBRUEsWUFBWSxDQUFDLDhCQUE4QixDQUFDLGtCQUFTLENBQUMsSUFBSSxDQUFDLEdBQ3pELDJCQUEyQixDQUFDLENBQUM7RUFFL0IsT0FBTyxLQUFLO0FBQ2Q7O0FBRUE7QUFDTyxTQUFTLDJCQUEyQixDQUFBLEVBQUc7RUFDNUMsT0FBTztJQUNMLGlCQUFpQixFQUFFLEVBQUU7SUFDckIsT0FBTyxFQUFFLFFBQWlCO0lBQUU7SUFDNUIsdUJBQXVCLEVBQUUsQ0FBQztJQUMxQixJQUFJLEVBQUUsY0FBYztJQUNwQixjQUFjLEVBQUUsS0FBSztJQUNyQixZQUFZLEVBQUUsQ0FDWjtNQUNFLFlBQVksRUFBRSxJQUFBLHdDQUErQixFQUFDLGNBQWMsQ0FBQztNQUM3RCxlQUFlLEVBQUUsY0FBYztNQUMvQixJQUFJLEVBQUUsUUFBUTtNQUNkLEdBQUcsRUFBRTtJQUNQLENBQUM7RUFFTCxDQUFDO0FBQ0g7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ2hHQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsY0FBQSxHQUFBLE9BQUE7QUFPTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEdBQUc7O0FBRTFCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUMzQixxQkFBb0MsRUFDWjtFQUN4QixNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUVwQyxhQUFhLENBQUMsSUFBSSxHQUFHLGNBQWMsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDO0VBRXZELE9BQU8sYUFBYTtBQUN0QjtBQUVBLFNBQVMsY0FBYyxDQUNyQixLQUE4QixFQUNMO0VBQUEsSUFBQSxxQkFBQTtFQUN6QjtFQUNBLElBQUksQ0FBQyxJQUFBLGtCQUFXLEVBQUMsS0FBSyxFQUFFLHVCQUF1QixDQUFDLEVBQUU7SUFDaEQsT0FBTyxDQUFDLElBQUksQ0FBQywrQ0FBK0MsQ0FBQztJQUM3RCxPQUFPLEtBQUs7RUFDZDtFQUVBLE1BQU0sMEJBQTBCLEdBQUcsS0FBSyxDQUFDLHFCQUFxQjs7RUFFOUQ7RUFDQSxJQUFJLENBQUMsSUFBQSxlQUFRLEVBQUMsMEJBQTBCLENBQUMsRUFBRTtJQUFBLElBQUEsY0FBQSxFQUFBLHFCQUFBO0lBQ3pDLENBQUEsY0FBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsY0FBQSxnQkFBQSxxQkFBQSxHQUFiLGNBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxjQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLG9DQUFvQyxPQUFPLDBCQUEwQixxQkFDM0YsQ0FDRixDQUFDO0lBQ0QsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxJQUFJLElBQUEsa0JBQVcsRUFBQywwQkFBMEIsRUFBRSx3QkFBd0IsQ0FBQyxFQUFFO0lBQ3JFO0lBQ0EsMEJBQTBCLENBQUMsc0JBQXNCLEdBQUcsSUFBSTtFQUMxRDtFQUVBLElBQUksSUFBQSxrQkFBVyxFQUFDLDBCQUEwQixFQUFFLHlCQUF5QixDQUFDLEVBQUU7SUFDdEU7SUFDQSwwQkFBMEIsQ0FBQyx1QkFBdUIsR0FBRyxJQUFJO0VBQzNEOztFQUVBO0VBQ0EsSUFBSSxPQUFPLENBQUMsR0FBRyxDQUFDLFVBQVUsS0FBQSxxQkFBQSxHQUFJLElBQUEsK0JBQWdCLEVBQUMsQ0FBQyxDQUFDLE9BQU8sY0FBQSxxQkFBQSxlQUExQixxQkFBQSxDQUE0QixXQUFXLEVBQUU7SUFDckUsMEJBQTBCLENBQUMsc0JBQXNCLEdBQUcsS0FBSztJQUN6RCwwQkFBMEIsQ0FBQyx1QkFBdUIsR0FBRyxLQUFLO0lBQzFELDBCQUEwQixDQUFDLHVCQUF1QixHQUFHLEtBQUs7SUFDMUQsMEJBQTBCLENBQUMsdUJBQXVCLEdBQUcsS0FBSztFQUM1RDtFQUVBLE9BQU8sS0FBSztBQUNkOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUN2RUEsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFPTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEtBQUs7O0FBRTVCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FDM0IscUJBQW9DLEVBQ1o7RUFDeEIsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsY0FBYyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7RUFDbEMsT0FBTyxhQUFhO0FBQ3RCO0FBRUEsU0FBUyxjQUFjLENBQUMsS0FBOEIsRUFBRTtFQUN0RCxJQUNFLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUseUJBQXlCLENBQUMsSUFDN0MsSUFBQSxlQUFRLEVBQUMsS0FBSyxDQUFDLHVCQUF1QixDQUFDLElBQ3ZDLElBQUEsa0JBQVcsRUFBQyxLQUFLLENBQUMsdUJBQXVCLEVBQUUsdUJBQXVCLENBQUMsRUFDbkU7SUFDQSxPQUFPLEtBQUssQ0FBQyx1QkFBdUIsQ0FBQyxxQkFBcUI7RUFDNUQsQ0FBQyxNQUFNO0lBQ0wsT0FBTyxDQUFDLElBQUksQ0FDVixhQUFhLE9BQU8sd0ZBQ3RCLENBQUM7RUFDSDtBQUNGOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUMxQ0EsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQU9PLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsR0FBRzs7QUFFMUI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUMzQixxQkFBb0MsRUFDWjtFQUN4QixNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUNwQyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUNsQyxPQUFPLGFBQWE7QUFDdEI7QUFFQSxTQUFTLGNBQWMsQ0FBQyxLQUE4QixFQUFFO0VBQ3RELE1BQU0sMEJBQTBCLEdBQUcsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLHFCQUU3QjtFQUViLE1BQU0sV0FBVyxHQUFHLDBCQUEwQixhQUExQiwwQkFBMEIsdUJBQTFCLDBCQUEwQixDQUFFLFdBRW5DO0VBRWIsSUFBSSxXQUFXLEVBQUU7SUFDZixXQUFXLENBQUMsaUJBQWlCLEdBQUcsS0FBSztFQUN2QztBQUNGOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUN6Q0EsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQWNPLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsR0FBRzs7QUFFMUI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FDM0IscUJBQW9DLEVBQ1o7RUFDeEIsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsY0FBYyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7RUFDbEMsT0FBTyxhQUFhO0FBQ3RCO0FBRUEsU0FBUyxjQUFjLENBQUMsS0FBOEIsRUFBRTtFQUN0RCxNQUFNLDBCQUEwQixHQUFHLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxxQkFFN0I7RUFFYixNQUFNLHVCQUF1QixHQUFHLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxrQkFFMUI7RUFFYixJQUNFLDBCQUEwQixhQUExQiwwQkFBMEIsZUFBMUIsMEJBQTBCLENBQUUsV0FBVyxJQUN2Qyx1QkFBdUIsYUFBdkIsdUJBQXVCLGVBQXZCLHVCQUF1QixDQUFFLHdDQUF3QyxFQUNqRTtJQUVFLDBCQUEwQixDQUMxQixXQUFXLENBQUMsNEJBQTRCLEdBQ3hDLHVCQUF1QixhQUF2Qix1QkFBdUIsdUJBQXZCLHVCQUF1QixDQUFFLHdDQUFpRDtFQUM5RTtFQUVBLElBQUksdUJBQXVCLGFBQXZCLHVCQUF1QixlQUF2Qix1QkFBdUIsQ0FBRSx3Q0FBd0MsRUFBRTtJQUM5RCx1QkFBdUIsYUFBdkIsdUJBQXVCLGVBQTlCLE9BQU8sdUJBQXVCLENBQUUsd0NBQXdDO0VBQzFFO0FBQ0Y7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQzNEQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBT08sTUFBTSxPQUFPLEdBQUEsT0FBQSxDQUFBLE9BQUEsR0FBRyxLQUFLOztBQUU1QjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sZUFBZSxPQUFPLENBQzNCLHFCQUFvQyxFQUNaO0VBQ3hCLE1BQU0sYUFBYSxHQUFHLElBQUEsaUJBQVMsRUFBQyxxQkFBcUIsQ0FBQztFQUN0RCxhQUFhLENBQUMsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPO0VBQ3BDLGNBQWMsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDO0VBQ2xDLE9BQU8sYUFBYTtBQUN0QjtBQUVBLFNBQVMsY0FBYyxDQUFDLEtBQThCLEVBQUU7RUFBQSxJQUFBLHFCQUFBO0VBQ3RELE1BQU0sMEJBQTBCLEdBQUcsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLHFCQU03QjtFQUViLElBQUksMEJBQTBCLGFBQTFCLDBCQUEwQixnQkFBQSxxQkFBQSxHQUExQiwwQkFBMEIsQ0FBRSxXQUFXLGNBQUEscUJBQUEsZUFBdkMscUJBQUEsQ0FBeUMsNEJBQTRCLEVBQUU7SUFDekUsT0FBTywwQkFBMEIsQ0FBQyxXQUFXLENBQUMsNEJBQTRCO0VBQzVFO0FBQ0Y7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQzFDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxrQkFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQU9PLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsS0FBSztBQUM1QixNQUFNLFlBQVksR0FBRyxNQUFNOztBQUUzQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUFDLHFCQUc3QixFQUFFO0VBQ0QsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsYUFBYSxDQUFDLElBQUksR0FBRyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUN2RCxPQUFPLGFBQWE7QUFDdEI7QUFFQSxTQUFTLGNBQWMsQ0FBQyxLQUE4QixFQUFFO0VBQ3RELElBQ0UsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSxtQkFBbUIsQ0FBQyxJQUN2QyxJQUFBLGVBQVEsRUFBQyxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFDakMsSUFBQSxrQkFBVyxFQUFDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxnQ0FBZ0MsQ0FBQyxJQUN0RSxJQUFBLGVBQVEsRUFBQyxLQUFLLENBQUMsaUJBQWlCLENBQUMsOEJBQThCLENBQUMsRUFDaEU7SUFDQSxNQUFNO01BQUU7SUFBK0IsQ0FBQyxHQUFHLEtBQUssQ0FBQyxpQkFBaUI7O0lBRWxFO0lBQ0EsTUFBTSxVQUFVLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQyw4QkFBOEIsQ0FBQyxDQUM5RCxNQUFNLENBQ0wsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxLQUNSLENBQUMsQ0FBQyxHQUFHLCtCQUFzQixFQUFFLGtCQUFTLENBQUMsYUFBYSxDQUFDLENBQUMsUUFBUSxDQUM1RCxPQUNGLENBQ0osQ0FBQyxDQUNBLElBQUksQ0FBQyxDQUFDLEdBQUcsYUFBYSxDQUFDLEtBQUs7TUFBQSxJQUFBLHFCQUFBO01BQzNCLElBQ0UsQ0FBQyxJQUFBLGVBQVEsRUFBQyxhQUFhLENBQUMsSUFDeEIsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLGFBQWEsQ0FBQyxZQUFZLENBQUMsSUFDMUMsT0FBTyxhQUFhLENBQUMsdUJBQXVCLEtBQUssUUFBUSxFQUN6RDtRQUNBLE9BQU8sS0FBSztNQUNkOztNQUVBO01BQ0EsTUFBTSxrQkFBa0IsR0FDdEIsYUFBYSxhQUFiLGFBQWEsZ0JBQUEscUJBQUEsR0FBYixhQUFhLENBQUUsWUFBWSxjQUFBLHFCQUFBLHVCQUEzQixxQkFBQSxDQUE4QixhQUFhLGFBQWIsYUFBYSx1QkFBYixhQUFhLENBQUUsdUJBQXVCLENBQUM7TUFFdkUsSUFDRSxDQUFDLElBQUEsZUFBUSxFQUFDLGtCQUFrQixDQUFDLElBQzdCLE9BQU8sa0JBQWtCLENBQUMsR0FBRyxLQUFLLFFBQVEsRUFDMUM7UUFDQSxPQUFPLEtBQUs7TUFDZDtNQUVBLElBQUk7UUFDRixNQUFNLE9BQU8sR0FBRyxJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxHQUFHLENBQUMsQ0FBQyxJQUFJO1FBQ3BELE9BQ0Usa0JBQWtCLENBQUMsSUFBSSxLQUFLLGtDQUFlLENBQUMsTUFBTSxJQUNsRCwyQkFBa0IsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDO01BRXhDLENBQUMsQ0FBQyxNQUFNO1FBQ04sT0FBTyxLQUFLO01BQ2Q7SUFDRixDQUFDLENBQUM7SUFFSixJQUFJLENBQUMsVUFBVSxFQUFFO01BQ2Y7TUFDQSxPQUFPLEtBQUs7SUFDZDs7SUFFQTtJQUNBLE1BQU0sZ0JBQWdCLEdBQUcsOEJBQThCLENBQUMsWUFBWSxDQUFDO0lBQ3JFLElBQUksSUFBQSxlQUFRLEVBQUMsZ0JBQWdCLENBQUMsRUFBRTtNQUM5QixNQUFNO1FBQUU7TUFBYSxDQUFDLEdBQUcsZ0JBQWdCO01BRXpDLElBQUksS0FBSyxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsRUFBRTtRQUMvQjtRQUNBLE1BQU0sS0FBSyxHQUFHLFlBQVksQ0FBQyxTQUFTLENBQ2pDLFFBQVEsSUFDUCxJQUFBLGVBQVEsRUFBQyxRQUFRLENBQUMsSUFDbEIsUUFBUSxDQUFDLEdBQUcsS0FBSyxtQ0FDckIsQ0FBQztRQUVELElBQUksS0FBSyxLQUFLLENBQUMsQ0FBQyxFQUFFO1VBQ2hCO1VBQ0EsWUFBWSxDQUFDLEtBQUssQ0FBQyxHQUFHO1lBQ3BCLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztZQUN0QixHQUFHLEVBQUUsb0NBQW9DLHdCQUFlO1VBQzFELENBQUM7O1VBRUQ7VUFDQSw4QkFBOEIsQ0FBQyxZQUFZLENBQUMsR0FBRztZQUM3QyxHQUFHLGdCQUFnQjtZQUNuQjtVQUNGLENBQUM7VUFFRCxPQUFPO1lBQ0wsR0FBRyxLQUFLO1lBQ1IsaUJBQWlCLEVBQUU7Y0FDakIsR0FBRyxLQUFLLENBQUMsaUJBQWlCO2NBQzFCO1lBQ0Y7VUFDRixDQUFDO1FBQ0g7TUFDRjtJQUNGO0VBQ0Y7RUFFQSxPQUFPLEtBQUs7QUFDZDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDaElBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFPTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEdBQUc7O0FBRTFCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUMzQixxQkFBb0MsRUFDWjtFQUN4QixNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUNwQyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUNsQyxPQUFPLGFBQWE7QUFDdEI7QUFFQSxTQUFTLGNBQWMsQ0FBQyxLQUE4QixFQUFFO0VBQ3RELE1BQU0sMEJBQTBCLEdBQUcsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLHFCQUU3QjtFQUVOLDBCQUEwQixhQUExQiwwQkFBMEIsZUFBakMsT0FBTywwQkFBMEIsQ0FBRSw4QkFBOEI7RUFDMUQsMEJBQTBCLGFBQTFCLDBCQUEwQixlQUFqQyxPQUFPLDBCQUEwQixDQUFFLDRCQUE0QjtBQUNqRTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDckNBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxpQkFBQSxHQUFBLE9BQUE7QUFPTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEdBQUc7O0FBRTFCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUMzQixxQkFBb0MsRUFDWjtFQUN4QixNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUVwQyxhQUFhLENBQUMsSUFBSSxHQUFHLGNBQWMsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDO0VBRXZELE9BQU8sYUFBYTtBQUN0Qjs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUyxzQkFBc0IsQ0FDN0IsR0FBNEIsRUFDNUIsWUFBb0IsRUFDcEIsT0FBZSxFQUdmO0VBQ0EsSUFBSSxDQUFDLElBQUEsa0JBQVcsRUFBQyxHQUFHLEVBQUUsWUFBWSxDQUFDLEVBQUU7SUFDbkMsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxJQUFJLENBQUMsSUFBQSxlQUFRLEVBQUMsR0FBRyxDQUFDLFlBQVksQ0FBQyxDQUFDLEVBQUU7SUFBQSxJQUFBLGNBQUEsRUFBQSxxQkFBQTtJQUNoQyxDQUFBLGNBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGNBQUEsZ0JBQUEscUJBQUEsR0FBYixjQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsY0FBQSxFQUNFLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTyxLQUFLLFlBQVksYUFBYSxPQUFPLEdBQUcsQ0FDMUQsWUFBWSxDQUNiLHlCQUF5QixPQUFPLEdBQ25DLENBQ0YsQ0FBQztJQUNELE9BQU8sS0FBSztFQUNkO0VBRUEsT0FBTyxJQUFJO0FBQ2I7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUywwQkFBMEIsQ0FDakMsa0JBQTJDLEVBQ0Y7RUFDekMsTUFBTSxXQUFXLEdBQUcsSUFBQSxxQ0FBbUIsRUFBQyxNQUFNLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7RUFFM0UsTUFBTTtJQUFFLFNBQVMsRUFBRTtFQUFlLENBQUMsR0FBRyxJQUFBLHVCQUFnQixFQUFDLFdBQVcsQ0FBQztFQUVuRSxNQUFNLGlCQUEwRCxHQUFHO0lBQ2pFLENBQUMsY0FBYyxHQUFHO01BQ2hCLEdBQUc7SUFDTDtFQUNGLENBQUM7RUFFRCxPQUFPLGlCQUFpQjtBQUMxQjs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTLDZCQUE2QixDQUNwQyxnQ0FBd0MsRUFDQztFQUN6QyxNQUFNLFdBQVcsR0FBRyxJQUFBLHFDQUFtQixFQUFDLGdDQUFnQyxDQUFDO0VBQ3pFLE1BQU07SUFBRSxTQUFTLEVBQUU7RUFBZSxDQUFDLEdBQUcsSUFBQSx1QkFBZ0IsRUFBQyxXQUFXLENBQUM7RUFFbkUsTUFBTSxpQkFBaUIsR0FBRztJQUN4QixDQUFDLGNBQWMsR0FBRztNQUNoQixDQUFDLGdDQUFnQyxHQUFHO0lBQ3RDO0VBQ0YsQ0FBQztFQUVELE9BQU8saUJBQWlCO0FBQzFCO0FBRUEsU0FBUyxjQUFjLENBQ3JCLEtBQThCLEVBQ0w7RUFDekI7RUFDQSxJQUFJLENBQUMsc0JBQXNCLENBQUMsS0FBSyxFQUFFLHdCQUF3QixFQUFFLE9BQU8sQ0FBQyxFQUFFO0lBQ3JFLE9BQU8sS0FBSztFQUNkO0VBRUEsTUFBTSwyQkFBMkIsR0FBRyxLQUFLLENBQUMsc0JBQXNCOztFQUVoRTtFQUNBLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxLQUFLLEVBQUUsdUJBQXVCLEVBQUUsT0FBTyxDQUFDLEVBQUU7SUFDcEUsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxNQUFNLDBCQUEwQixHQUFHLEtBQUssQ0FBQyxxQkFBcUI7O0VBRTlEO0VBQ0EsSUFDRSxDQUFDLHNCQUFzQixDQUNyQiwwQkFBMEIsRUFDMUIsYUFBYSxFQUNiLHVCQUNGLENBQUMsRUFDRDtJQUNBLE9BQU8sS0FBSztFQUNkO0VBRUEsTUFBTTtJQUFFO0VBQVksQ0FBQyxHQUFHLDBCQUEwQjs7RUFFbEQ7RUFDQSxJQUFJLENBQUMsSUFBQSxrQkFBVyxFQUFDLFdBQVcsRUFBRSxvQkFBb0IsQ0FBQyxFQUFFO0lBQ25ELE9BQU8sS0FBSztFQUNkO0VBRUEsTUFBTTtJQUFFO0VBQW1CLENBQUMsR0FBRyxXQUFXOztFQUUxQztFQUNBLElBQUksQ0FBQyxJQUFBLGVBQVEsRUFBQyxrQkFBa0IsQ0FBQyxFQUFFO0lBQUEsSUFBQSxlQUFBLEVBQUEscUJBQUE7SUFDakMsQ0FBQSxlQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxlQUFBLGdCQUFBLHFCQUFBLEdBQWIsZUFBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGVBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8saUNBQWlDLE9BQU8sa0JBQWtCLHFCQUNoRixDQUNGLENBQUM7SUFDRCxPQUFPLEtBQUs7RUFDZDtFQUVBLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUU7SUFBQSxJQUFBLGVBQUEsRUFBQSxxQkFBQTtJQUNoRCxDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZ0JBQUEscUJBQUEsR0FBYixlQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsZUFBQSxFQUNFLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTyw2RUFDdEIsQ0FDRixDQUFDO0lBQ0QsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxNQUFNO0lBQUUsMkJBQTJCLEVBQUU7RUFBaUMsQ0FBQyxHQUNyRSxLQUFLO0VBRVAsSUFBSSxDQUFDLElBQUEsZUFBUSxFQUFDLGdDQUFnQyxDQUFDLEVBQUU7SUFBQSxJQUFBLGVBQUEsRUFBQSxxQkFBQTtJQUMvQyxDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZ0JBQUEscUJBQUEsR0FBYixlQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsZUFBQSxFQUFrQyxJQUFJLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDOUMsT0FBTyxLQUFLO0VBQ2Q7O0VBRUE7RUFDQSxNQUFNO0lBQUU7RUFBaUMsQ0FBQyxHQUFHLGdDQUFnQzs7RUFFN0U7RUFDQSxJQUNFLENBQUMsZ0NBQWdDLElBQ2pDLE9BQU8sZ0NBQWdDLEtBQUssUUFBUSxFQUNwRDtJQUFBLElBQUEsZUFBQSxFQUFBLHFCQUFBO0lBQ0EsQ0FBQSxlQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxlQUFBLGdCQUFBLHFCQUFBLEdBQWIsZUFBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGVBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8sK0NBQStDLE9BQU8sZ0NBQWdDLHFCQUM1RyxDQUNGLENBQUM7SUFDRCxPQUFPLEtBQUs7RUFDZDs7RUFFQTtFQUNBLE1BQU0sb0JBQW9CLEdBQUcsMEJBQTBCLENBQ3JELGtCQUNGLENBQUM7RUFDRCxNQUFNLHVCQUF1QixHQUFHLDZCQUE2QixDQUMzRCxnQ0FDRixDQUFDOztFQUVEO0VBQ0EsMkJBQTJCLENBQUMsaUJBQWlCLEdBQUc7SUFDOUMsR0FBRyxvQkFBb0I7SUFDdkIsR0FBRztFQUNMLENBQUM7RUFFRCxPQUFPLEtBQUs7QUFDZDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDN01BLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFPTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEdBQUc7O0FBRTFCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FDM0IscUJBQW9DLEVBQ1o7RUFDeEIsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsY0FBYyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7RUFDbEMsT0FBTyxhQUFhO0FBQ3RCO0FBRUEsU0FBUyxjQUFjLENBQUMsS0FBOEIsRUFBRTtFQUN0RCxNQUFNLDBCQUEwQixHQUFHLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxxQkFFN0I7RUFFYixJQUNFLDBCQUEwQixJQUMxQixDQUFDLDBCQUEwQixDQUFDLHdCQUF3QixFQUNwRDtJQUNBLDBCQUEwQixDQUFDLHdCQUF3QixHQUFHLEVBQUU7RUFDMUQ7QUFDRjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDeENBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxRQUFBLEdBQUEsT0FBQTtBQU9PLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsR0FBRzs7QUFFMUI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUMzQixxQkFBb0MsRUFDWjtFQUN4QixNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUNwQyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUNsQyxPQUFPLGFBQWE7QUFDdEI7QUFFQSxTQUFTLGNBQWMsQ0FBQyxLQUE4QixFQUFFO0VBQ3RELE1BQU0sUUFBUSxHQUFHLGFBQWE7RUFDOUIsTUFBTSxNQUFNLEdBQUcsYUFBYTtFQUM1QixNQUFNLFVBQVUsR0FBRyxrQkFBUyxDQUFDLEdBQUc7O0VBRWhDO0VBQ0E7RUFDQSxJQUNFLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUsbUJBQW1CLENBQUMsSUFDdkMsSUFBQSxlQUFRLEVBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQ2pDLElBQUEsZUFBUSxFQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyw4QkFBOEIsQ0FBQyxJQUNoRSxJQUFBLGtCQUFXLEVBQ1QsS0FBSyxDQUFDLGlCQUFpQixDQUFDLDhCQUE4QixFQUN0RCxVQUNGLENBQUMsSUFDRCxJQUFBLGVBQVEsRUFDTixLQUFLLENBQUMsaUJBQWlCLENBQUMsOEJBQThCLENBQUMsVUFBVSxDQUNuRSxDQUFDLElBQ0QsSUFBQSxrQkFBVyxFQUNULEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyw4QkFBOEIsQ0FDcEQsVUFBVSxDQUNYLEVBQ0QsTUFDRixDQUFDLElBRUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLDhCQUE4QixDQUNwRCxVQUFVLENBQ1gsQ0FDRCxJQUFJLEtBQUssUUFBUSxFQUNuQjtJQUVFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyw4QkFBOEIsQ0FDcEQsVUFBVSxDQUNYLENBQ0QsSUFBSSxHQUFHLE1BQU07RUFDakI7RUFDQSxPQUFPLEtBQUs7QUFDZDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDckVBLElBQUEsaUJBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBRU8sTUFBTSxPQUFPLEdBQUEsT0FBQSxDQUFBLE9BQUEsR0FBRyxHQUFHOztBQUUxQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUFDLHFCQUc3QixFQUFFO0VBQ0QsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsYUFBYSxDQUFDLElBQUksR0FBRyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUN2RCxPQUFPLGFBQWE7QUFDdEI7QUFFQSxTQUFTLGNBQWMsQ0FBQyxLQUE4QixFQUFFO0VBQ3RELE1BQU0sMkJBQTJCLEdBQUcsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLHNCQUFzQjtFQUNqRSxJQUFJLENBQUMsSUFBQSxlQUFRLEVBQUMsMkJBQTJCLENBQUMsRUFBRTtJQUMxQyxPQUFPLEtBQUs7RUFDZDtFQUVBLE1BQU07SUFBRTtFQUFVLENBQUMsR0FDakIsMkJBQTBEO0VBQzVELElBQUksQ0FBQyxJQUFBLGVBQVEsRUFBQyxTQUFTLENBQUMsRUFBRTtJQUN4QixPQUFPLEtBQUs7RUFDZDtFQUVBLElBQUk7SUFDRixNQUFNLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsR0FBRyxFQUFFLFdBQVcsQ0FBQyxLQUFLO01BQUEsSUFBQSxtQkFBQSxFQUFBLG9CQUFBO01BQ3hELE1BQU0sVUFBVSxHQUFHLElBQUEsaUNBQWUsR0FBQSxtQkFBQSxHQUFDLFdBQVcsQ0FBQyxNQUFNLGNBQUEsbUJBQUEsZ0JBQUEsbUJBQUEsR0FBbEIsbUJBQUEsQ0FBb0IsUUFBUSxjQUFBLG1CQUFBLHVCQUE1QixtQkFBQSxDQUE4QixPQUFPLENBQUM7TUFDekUsTUFBTSxLQUFLLElBQUEsb0JBQUEsR0FBRyxXQUFXLENBQUMsTUFBTSxjQUFBLG9CQUFBLGdCQUFBLG9CQUFBLEdBQWxCLG9CQUFBLENBQW9CLFFBQVEsY0FBQSxvQkFBQSx1QkFBNUIsb0JBQUEsQ0FBOEIsTUFBTTtNQUNsRCxJQUFJLFVBQVUsSUFBSSxLQUFLLElBQUksS0FBSyxLQUFLLEdBQUcsRUFBRTtRQUN4QyxTQUFTLENBQUMsS0FBSyxDQUFDLEdBQUc7VUFDakIsR0FBRyxXQUFXO1VBQ2QsUUFBUSxFQUFFO1FBQ1osQ0FBQztRQUNELE9BQU8sU0FBUyxDQUFDLEdBQUcsQ0FBQztNQUN2QjtJQUNGLENBQUMsQ0FBQztJQUVGLE9BQU8sS0FBSztFQUNkLENBQUMsQ0FBQyxPQUFPLEtBQUssRUFBRTtJQUNkLElBQUEsd0JBQWdCLEVBQ2QsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLDRGQUE2RixLQUFLLENBQVcsT0FBTyxFQUMxSSxDQUNGLENBQUM7SUFDRCxPQUFPLEtBQUs7RUFDZDtBQUNGOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNqRUEsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQUVPLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsR0FBRzs7QUFFMUI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sZUFBZSxPQUFPLENBQUMscUJBRzdCLEVBQUU7RUFDRCxNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUNwQyxhQUFhLENBQUMsSUFBSSxHQUFHLGNBQWMsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDO0VBQ3ZELE9BQU8sYUFBYTtBQUN0QjtBQUVBLFNBQVMsY0FBYyxDQUFDLEtBQThCLEVBQUU7RUFDdEQsSUFBSTtJQUNGLE1BQU0sWUFBWSxHQUFHLE9BQU87SUFDNUIsTUFBTSxzQkFBc0IsR0FBRyxLQUFLLENBQUMsaUJBQWlCO0lBQ3RELElBQ0UsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSxtQkFBbUIsQ0FBQyxJQUN2QyxJQUFBLGVBQVEsRUFBQyxzQkFBc0IsQ0FBQyxJQUNoQyxJQUFBLGtCQUFXLEVBQUMsc0JBQXNCLEVBQUUsZ0NBQWdDLENBQUMsSUFDckUsSUFBQSxlQUFRLEVBQUMsc0JBQXNCLENBQUMsOEJBQThCLENBQUMsRUFDL0Q7TUFDQSxLQUFLLE1BQU0sb0JBQW9CLElBQUksTUFBTSxDQUFDLE1BQU0sQ0FDOUMsc0JBQXNCLENBQUMsOEJBQ3pCLENBQUMsRUFBRTtRQUNELElBQ0UsSUFBQSxlQUFRLEVBQUMsb0JBQW9CLENBQUMsS0FDN0Isb0JBQW9CLENBQUMsT0FBTyxLQUFLLGtCQUFTLENBQUMsSUFBSSxJQUM5QyxvQkFBb0IsQ0FBQyxPQUFPLEtBQUssWUFBWSxDQUFDLEVBQ2hEO1VBQ0E7VUFDQSxJQUFJLElBQUEsa0JBQVcsRUFBQyxvQkFBb0IsRUFBRSxnQkFBZ0IsQ0FBQyxFQUFFO1lBQ3ZELG9CQUFvQixDQUFDLGNBQWMsR0FBRyxNQUFNO1VBQzlDO1FBQ0Y7TUFDRjtJQUNGO0lBQ0EsT0FBTyxLQUFLO0VBQ2QsQ0FBQyxDQUFDLE9BQU8sS0FBSyxFQUFFO0lBQ2QsSUFBQSx3QkFBZ0IsRUFDZCxJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8sNkVBQThFLEtBQUssQ0FBVyxPQUFPLEVBQzNILENBQ0YsQ0FBQztJQUNELE9BQU8sS0FBSztFQUNkO0FBQ0Y7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQzVEQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFFTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEtBQUs7O0FBRTVCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sZUFBZSxPQUFPLENBQUMscUJBRzdCLEVBQUU7RUFDRCxNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUNwQyxhQUFhLENBQUMsSUFBSSxHQUFHLGNBQWMsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDO0VBQ3ZELE9BQU8sYUFBYTtBQUN0QjtBQUVBLFNBQVMsY0FBYyxDQUFDLEtBQThCLEVBQUU7RUFDdEQsSUFBSTtJQUNGLE1BQU0sdUJBQXVCLEdBQUcsS0FBSyxDQUFDLGtCQUFrQjtJQUN4RCxJQUNFLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUsb0JBQW9CLENBQUMsSUFDeEMsSUFBQSxlQUFRLEVBQUMsdUJBQXVCLENBQUMsSUFDakMsSUFBQSxrQkFBVyxFQUFDLHVCQUF1QixFQUFFLCtCQUErQixDQUFDLElBQ3JFLElBQUEsZUFBUSxFQUFDLHVCQUF1QixDQUFDLDZCQUE2QixDQUFDLEVBQy9EO01BQ0E7TUFDQTtNQUNBLHVCQUF1QixDQUFDLDZCQUE2QixHQUFHLENBQUMsQ0FBQztJQUM1RDtJQUNBLE9BQU8sS0FBSztFQUNkLENBQUMsQ0FBQyxPQUFPLEtBQUssRUFBRTtJQUNkLElBQUEsd0JBQWdCLEVBQ2QsSUFBSSxLQUFLLENBQ1AsYUFBYSxPQUFPLGlFQUFrRSxLQUFLLENBQVcsT0FBTyxFQUMvRyxDQUNGLENBQUM7SUFDRCxPQUFPLEtBQUs7RUFDZDtBQUNGOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNoREEsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFPTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEdBQUc7QUFFMUIsTUFBTSxzQkFBc0IsR0FBRyx5Q0FBeUM7QUFjeEU7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUyw0QkFBNEIsQ0FDbkMsS0FBYyxFQUNrQjtFQUNoQyxPQUNFLE9BQU8sS0FBSyxLQUFLLFFBQVEsSUFDekIsS0FBSyxLQUFLLElBQUksSUFDZCxJQUFBLGtCQUFXLEVBQUMsS0FBSyxFQUFFLGNBQWMsQ0FBQyxJQUNsQyxJQUFBLGtCQUFXLEVBQUMsS0FBSyxFQUFFLE1BQU0sQ0FBQyxJQUMxQixJQUFBLGtCQUFXLEVBQUMsS0FBSyxFQUFFLGFBQWEsQ0FBQyxJQUNqQyxLQUFLLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsS0FDaEMsT0FBTyxLQUFLLENBQUMsSUFBSSxLQUFLLFFBQVEsSUFBSSxLQUFLLENBQUMsSUFBSSxLQUFLLElBQUksQ0FBQyxJQUN2RCxPQUFPLEtBQUssQ0FBQyxXQUFXLEtBQUssUUFBUTtBQUV6Qzs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FDM0IscUJBQW9DLEVBQ1o7RUFDeEIsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsY0FBYyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7RUFDbEMsT0FBTyxhQUFhO0FBQ3RCO0FBRUEsU0FBUyxjQUFjLENBQ3JCLEtBQThCLEVBQ0w7RUFDekIsSUFDRSxDQUFDLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUsa0NBQWtDLENBQUMsSUFDdkQsQ0FBQyxJQUFBLGVBQVEsRUFBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsRUFDakQ7SUFDQSxPQUFPLENBQUMsSUFBSSxDQUNWLHVFQUNGLENBQUM7SUFDRCxPQUFPLEtBQUs7RUFDZDtFQUVBLE1BQU0sc0JBQXNCLEdBQUcsS0FBSyxDQUFDLGdDQUFnQztFQUVyRSxJQUNFLENBQUMsSUFBQSxrQkFBVyxFQUFDLHNCQUFzQixFQUFFLG9CQUFvQixDQUFDLElBQzFELENBQUMsSUFBQSxlQUFRLEVBQUMsc0JBQXNCLENBQUMsa0JBQWtCLENBQUMsRUFDcEQ7SUFBQSxJQUFBLGNBQUEsRUFBQSxxQkFBQTtJQUNBLENBQUEsY0FBQSxHQUFBLE1BQU0sQ0FBQyxNQUFNLGNBQUEsY0FBQSxnQkFBQSxxQkFBQSxHQUFiLGNBQUEsQ0FBZSxnQkFBZ0IsY0FBQSxxQkFBQSxlQUEvQixxQkFBQSxDQUFBLElBQUEsQ0FBQSxjQUFBLEVBQ0UsSUFBSSxLQUFLLENBQ1AscUNBQXFDLE9BQU8sc0JBQXNCLENBQUMsa0JBQWtCLEVBQ3ZGLENBQ0YsQ0FBQztJQUNELE9BQU8sS0FBSztFQUNkO0VBRUEsTUFBTTtJQUFFO0VBQW1CLENBQUMsR0FBRyxzQkFBc0I7RUFDckQsTUFBTSxxQkFBMkMsR0FBRyxDQUFDLENBQUM7O0VBRXREO0VBQ0EsS0FBSyxNQUFNLENBQUMsU0FBUyxFQUFFLG1CQUFtQixDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FDM0Qsa0JBQ0YsQ0FBQyxFQUFFO0lBQ0QsSUFBSSxDQUFDLDRCQUE0QixDQUFDLG1CQUFtQixDQUFDLEVBQUU7TUFDdEQsTUFBTSxJQUFJLEtBQUssQ0FDYiwrQ0FBK0MsU0FBUyx5Q0FBeUMsT0FBTyxtQkFBbUIsRUFDN0gsQ0FBQztJQUNIOztJQUVBO0lBQ0E7SUFDQTtJQUNBLHFCQUFxQixDQUFDLFNBQVMsQ0FBQyxHQUFHO01BQ2pDLENBQUMsc0JBQXNCLEdBQUc7UUFDeEIsWUFBWSxFQUFFLG1CQUFtQixDQUFDLFlBQVk7UUFDOUMsSUFBSSxFQUFFLG1CQUFtQixDQUFDLElBQUk7UUFDOUIsV0FBVyxFQUFFLG1CQUFtQixDQUFDO01BQ25DO0lBQ0YsQ0FBQztFQUNIOztFQUVBO0VBQ0Esc0JBQXNCLENBQUMsa0JBQWtCLEdBQUcscUJBQXFCO0VBRWpFLE9BQU8sS0FBSztBQUNkOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUN2SEEsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFPTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEdBQUc7QUFFMUIsU0FBUyxjQUFjLENBQUMsS0FBNEIsRUFBRTtFQUNwRCxJQUNFLENBQUMsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSx1QkFBdUIsQ0FBQyxJQUM1QyxDQUFDLElBQUEsZUFBUSxFQUFDLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxFQUN0QztJQUFBLElBQUEsY0FBQSxFQUFBLHFCQUFBO0lBQ0EsQ0FBQSxjQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxjQUFBLGdCQUFBLHFCQUFBLEdBQWIsY0FBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGNBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCx3Q0FBd0MsT0FBTyxLQUFLLENBQUMscUJBQXFCLEVBQzVFLENBQ0YsQ0FBQztJQUNELE9BQU8sS0FBSztFQUNkO0VBRUEsSUFDRSxJQUFBLGtCQUFXLEVBQ1QsS0FBSyxDQUFDLHFCQUFxQixFQUMzQixvQ0FDRixDQUFDLEVBQ0Q7SUFDQSxPQUFPLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxrQ0FBa0M7RUFDdkU7RUFFQSxJQUNFLElBQUEsa0JBQVcsRUFDVCxLQUFLLENBQUMscUJBQXFCLEVBQzNCLHFDQUNGLENBQUMsRUFDRDtJQUNBLE9BQU8sS0FBSyxDQUFDLHFCQUFxQixDQUFDLG1DQUFtQztFQUN4RTtFQUVBLElBQUksSUFBQSxrQkFBVyxFQUFDLEtBQUssQ0FBQyxxQkFBcUIsRUFBRSw0QkFBNEIsQ0FBQyxFQUFFO0lBQzFFLE9BQU8sS0FBSyxDQUFDLHFCQUFxQixDQUFDLDBCQUEwQjtFQUMvRDtFQUVBLE9BQU8sS0FBSztBQUNkOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUMzQixxQkFBb0MsRUFDWjtFQUN4QixNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUNwQyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUNsQyxPQUFPLGFBQWE7QUFDdEI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNoRUEsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLFFBQUEsR0FBQSxPQUFBO0FBT08sTUFBTSxPQUFPLEdBQUEsT0FBQSxDQUFBLE9BQUEsR0FBRyxHQUFHO0FBRW5CLE1BQU0sZ0JBSVYsR0FBQSxPQUFBLENBQUEsZ0JBQUEsR0FBRyxDQUNKO0VBQ0UsRUFBRSxFQUFFLGtCQUFTLENBQUMsT0FBTztFQUNyQixRQUFRLEVBQUUsa0JBQWtCO0VBQzVCLE1BQU0sRUFBRTtBQUNWLENBQUMsRUFDRDtFQUNFLEVBQUUsRUFBRSxrQkFBUyxDQUFDLGFBQWE7RUFDM0IsUUFBUSxFQUFFLGVBQWU7RUFDekIsTUFBTSxFQUFFO0FBQ1YsQ0FBQyxFQUNEO0VBQ0UsRUFBRSxFQUFFLGtCQUFTLENBQUMsSUFBSTtFQUNsQixRQUFRLEVBQUUsY0FBYztFQUN4QixNQUFNLEVBQUU7QUFDVixDQUFDLEVBQ0Q7RUFDRSxFQUFFLEVBQUUsa0JBQVMsQ0FBQyxRQUFRO0VBQ3RCLFFBQVEsRUFBRSxjQUFjO0VBQ3hCLE1BQU0sRUFBRTtBQUNWLENBQUMsRUFDRDtFQUNFLEVBQUUsRUFBRSxrQkFBUyxDQUFDLFNBQVM7RUFDdkIsUUFBUSxFQUFFLDJCQUEyQjtFQUNyQyxNQUFNLEVBQUU7QUFDVixDQUFDLEVBQ0Q7RUFDRSxFQUFFLEVBQUUsa0JBQVMsQ0FBQyxHQUFHO0VBQ2pCLFFBQVEsRUFBRSxxQkFBcUI7RUFDL0IsTUFBTSxFQUFFO0FBQ1YsQ0FBQyxFQUNEO0VBQ0UsRUFBRSxFQUFFLGtCQUFTLENBQUMsUUFBUTtFQUN0QixRQUFRLEVBQUUsWUFBWTtFQUN0QixNQUFNLEVBQUU7QUFDVixDQUFDLEVBQ0Q7RUFDRSxFQUFFLEVBQUUsa0JBQVMsQ0FBQyxPQUFPO0VBQ3JCLFFBQVEsRUFBRSxpQkFBaUI7RUFDM0IsTUFBTSxFQUFFO0FBQ1YsQ0FBQyxFQUNEO0VBQ0UsRUFBRSxFQUFFLGtCQUFTLENBQUMsR0FBRztFQUNqQixRQUFRLEVBQUUsYUFBYTtFQUN2QixNQUFNLEVBQUU7QUFDVixDQUFDLEVBQ0Q7RUFDRSxFQUFFLEVBQUUsa0JBQVMsQ0FBQyxVQUFVO0VBQ3hCLFFBQVEsRUFBRSxvQkFBb0I7RUFDOUIsTUFBTSxFQUFFO0FBQ1YsQ0FBQyxDQUNGOztBQUVEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxlQUFlLE9BQU8sQ0FDM0IscUJBQW9DLEVBQ1o7RUFDeEIsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0VBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDcEMsY0FBYyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7RUFDbEMsT0FBTyxhQUFhO0FBQ3RCOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTLGNBQWMsQ0FBQyxLQUE4QixFQUFFO0VBQ3REO0VBQ0EsSUFDRSxFQUNFLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUsbUJBQW1CLENBQUMsSUFDdkMsSUFBQSxlQUFRLEVBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQ2pDLElBQUEsa0JBQVcsRUFBQyxLQUFLLENBQUMsaUJBQWlCLEVBQUUsZ0NBQWdDLENBQUMsSUFDdEUsSUFBQSxlQUFRLEVBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLDhCQUE4QixDQUFDLENBQ2pFLEVBQ0Q7SUFDQTtFQUNGO0VBRUEsS0FBSyxNQUFNLEtBQUssSUFBSSxnQkFBZ0IsRUFBRTtJQUNwQyxNQUFNLHVCQUF1QixHQUMzQixLQUFLLENBQUMsaUJBQWlCLENBQUMsOEJBQThCOztJQUV4RDtJQUNBLElBQUksQ0FBQyxJQUFBLGtCQUFXLEVBQUMsdUJBQXVCLEVBQUUsS0FBSyxDQUFDLEVBQUUsQ0FBQyxFQUFFO01BQ25EO0lBQ0Y7O0lBRUE7SUFDQSxNQUFNLHNCQUFzQixHQUFHLHVCQUF1QixDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUM7SUFDaEUsSUFDRSxJQUFBLGVBQVEsRUFBQyxzQkFBc0IsQ0FBQyxJQUNoQyxJQUFBLGtCQUFXLEVBQUMsc0JBQXNCLEVBQUUsTUFBTSxDQUFDLElBQzNDLHNCQUFzQixDQUFDLElBQUksS0FBSyxLQUFLLENBQUMsUUFBUSxFQUM5QztNQUNBLHNCQUFzQixDQUFDLElBQUksR0FBRyxLQUFLLENBQUMsTUFBTTtJQUM1QztFQUNGO0FBQ0Y7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQzdIQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQU9PLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsR0FBRzs7QUFFMUI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsT0FBTyxDQUMzQixxQkFBb0MsRUFDWjtFQUN4QixNQUFNLGFBQWEsR0FBRyxJQUFBLGlCQUFTLEVBQUMscUJBQXFCLENBQUM7RUFDdEQsYUFBYSxDQUFDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTztFQUNwQyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQztFQUNsQyxPQUFPLGFBQWE7QUFDdEI7QUFFQSxTQUFTLGNBQWMsQ0FBQyxLQUE4QixFQUFFO0VBQ3RELElBQ0UsSUFBQSxrQkFBVyxFQUFDLEtBQUssRUFBRSxvQkFBb0IsQ0FBQyxJQUN4QyxJQUFBLGVBQVEsRUFBQyxLQUFLLENBQUMsa0JBQWtCLENBQUMsRUFDbEM7SUFDQSxNQUFNLGtCQUFrQixHQUFHLEtBQUssQ0FBQyxrQkFHaEM7O0lBRUQ7SUFDQSxJQUFJLElBQUEsa0JBQVcsRUFBQyxrQkFBa0IsRUFBRSxjQUFjLENBQUMsRUFBRTtNQUNuRCxrQkFBa0IsQ0FBQyxZQUFZLEdBQUcsQ0FBQyxDQUFDO0lBQ3RDO0VBQ0Y7RUFFQSxPQUFPLEtBQUs7QUFDZDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ3pDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsUUFBQSxHQUFBLE9BQUE7QUFVTyxNQUFNLE9BQU8sR0FBQSxPQUFBLENBQUEsT0FBQSxHQUFHLEdBQUc7O0FBRTFCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sZUFBZSxPQUFPLENBQzNCLHFCQUFvQyxFQUNaO0VBQ3hCLE1BQU0sYUFBYSxHQUFHLElBQUEsaUJBQVMsRUFBQyxxQkFBcUIsQ0FBQztFQUN0RCxhQUFhLENBQUMsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPO0VBRXBDLGFBQWEsQ0FBQyxJQUFJLEdBQUcsY0FBYyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7RUFFdkQsT0FBTyxhQUFhO0FBQ3RCO0FBRUEsU0FBUyxjQUFjLENBQ3JCLEtBQThCLEVBQ0w7RUFDekIsSUFBSSxDQUFDLElBQUEsa0JBQVcsRUFBQyxLQUFLLEVBQUUsbUJBQW1CLENBQUMsRUFBRTtJQUM1QyxPQUFPLENBQUMsSUFBSSxDQUFDLGFBQWEsT0FBTyxnQ0FBZ0MsQ0FBQztJQUNsRSxPQUFPLEtBQUs7RUFDZDtFQUVBLE1BQU0sWUFBWSxHQUFHLEtBQUssQ0FBQyxpQkFBaUI7RUFDNUMsSUFBSSxDQUFDLElBQUEsZUFBUSxFQUFDLFlBQVksQ0FBQyxFQUFFO0lBQUEsSUFBQSxjQUFBLEVBQUEscUJBQUE7SUFDM0IsQ0FBQSxjQUFBLEdBQUEsTUFBTSxDQUFDLE1BQU0sY0FBQSxjQUFBLGdCQUFBLHFCQUFBLEdBQWIsY0FBQSxDQUFlLGdCQUFnQixjQUFBLHFCQUFBLGVBQS9CLHFCQUFBLENBQUEsSUFBQSxDQUFBLGNBQUEsRUFDRSxJQUFJLEtBQUssQ0FDUCxhQUFhLE9BQU8seUNBQXlDLE9BQU8sWUFBWSxFQUNsRixDQUNGLENBQUM7SUFDRCxPQUFPLEtBQUs7RUFDZDtFQUVBLElBQUksQ0FBQyxJQUFBLGtCQUFXLEVBQUMsWUFBWSxFQUFFLGdDQUFnQyxDQUFDLEVBQUU7SUFBQSxJQUFBLGVBQUEsRUFBQSxxQkFBQTtJQUNoRSxDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZ0JBQUEscUJBQUEsR0FBYixlQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsZUFBQSxFQUNFLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTyxzRUFDdEIsQ0FDRixDQUFDO0lBQ0QsT0FBTyxLQUFLO0VBQ2Q7RUFFQSxJQUFJLENBQUMsSUFBQSxlQUFRLEVBQUMsWUFBWSxDQUFDLDhCQUE4QixDQUFDLEVBQUU7SUFBQSxJQUFBLGVBQUEsRUFBQSxxQkFBQTtJQUMxRCxDQUFBLGVBQUEsR0FBQSxNQUFNLENBQUMsTUFBTSxjQUFBLGVBQUEsZ0JBQUEscUJBQUEsR0FBYixlQUFBLENBQWUsZ0JBQWdCLGNBQUEscUJBQUEsZUFBL0IscUJBQUEsQ0FBQSxJQUFBLENBQUEsZUFBQSxFQUNFLElBQUksS0FBSyxDQUNQLGFBQWEsT0FBTyx3RUFBd0UsT0FBTyxZQUFZLENBQUMsOEJBQThCLEdBQ2hKLENBQ0YsQ0FBQztJQUNELE9BQU8sS0FBSztFQUNkO0VBRUEsTUFBTSxtQkFBbUIsR0FDdkIsWUFBWSxDQUFDLDhCQUE4QixDQUFDLGtCQUFTLENBQUMsSUFBSSxDQUFDO0VBRTdELElBQUksbUJBQW1CLElBQUksSUFBQSxlQUFRLEVBQUMsbUJBQW1CLENBQUMsRUFBRTtJQUN4RDtJQUNBLE1BQU0saUJBQWlCLEdBQ3JCLElBQUEsa0JBQVcsRUFBQyxtQkFBbUIsRUFBRSxjQUFjLENBQUMsSUFDaEQsS0FBSyxDQUFDLE9BQU8sQ0FBQyxtQkFBbUIsQ0FBQyxZQUFZLENBQUMsSUFDL0MsbUJBQW1CLENBQUMsWUFBWSxDQUFDLElBQUksQ0FDbEMsUUFBUSxJQUNQLElBQUEsZUFBUSxFQUFDLFFBQVEsQ0FBQyxJQUNsQixJQUFBLGtCQUFXLEVBQUMsUUFBUSxFQUFFLGlCQUFpQixDQUFDLElBQ3hDLElBQUEsa0JBQVcsRUFBQyxRQUFRLEVBQUUsTUFBTSxDQUFDLElBQzdCLFFBQVEsQ0FBQyxlQUFlLEtBQUssY0FBYyxJQUMzQyxRQUFRLENBQUMsSUFBSSxLQUFLLFFBQ3RCLENBQUM7SUFFSCxJQUFJLGlCQUFpQixFQUFFO01BQ3JCLE9BQU8sS0FBSztJQUNkOztJQUVBO0lBQ0EsTUFBTSxZQUFZLEdBQUcsMkJBQTJCLENBQUMsQ0FBQztJQUNsRCxNQUFNLGtCQUFrQixHQUFHO01BQ3pCLEdBQUcsbUJBQW1CO01BQ3RCLFlBQVksRUFBRSxDQUNaLElBQUksS0FBSyxDQUFDLE9BQU8sQ0FBQyxtQkFBbUIsQ0FBQyxZQUFZLENBQUMsR0FDL0MsbUJBQW1CLENBQUMsWUFBWSxHQUNoQyxFQUFFLENBQUMsRUFDUCxHQUFHLFlBQVksQ0FBQyxZQUFZO0lBRWhDLENBQUM7SUFFRCxZQUFZLENBQUMsOEJBQThCLENBQUMsa0JBQVMsQ0FBQyxJQUFJLENBQUMsR0FDekQsa0JBQWtCO0VBQ3RCLENBQUMsTUFBTTtJQUNMO0lBQ0EsWUFBWSxDQUFDLDhCQUE4QixDQUFDLGtCQUFTLENBQUMsSUFBSSxDQUFDLEdBQ3pELDJCQUEyQixDQUFDLENBQUM7RUFDakM7RUFFQSxPQUFPLEtBQUs7QUFDZDs7QUFFQTtBQUNPLFNBQVMsMkJBQTJCLENBQUEsRUFBRztFQUM1QyxPQUFPO0lBQ0wsaUJBQWlCLEVBQUUsRUFBRTtJQUNyQixPQUFPLEVBQUUsUUFBaUI7SUFBRTtJQUM1Qix1QkFBdUIsRUFBRSxDQUFDO0lBQzFCLElBQUksRUFBRSxNQUFNO0lBQ1osY0FBYyxFQUFFLEtBQUs7SUFDckIsWUFBWSxFQUFFLENBQ1o7TUFDRSxZQUFZLEVBQUUsSUFBQSx3Q0FBK0IsRUFBQyxjQUFjLENBQUM7TUFDN0QsZUFBZSxFQUFFLGNBQWM7TUFDL0IsSUFBSSxFQUFFLFFBQVE7TUFDZCxHQUFHLEVBQUU7SUFDUCxDQUFDO0VBRUwsQ0FBQztBQUNIOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNqSUEsSUFBQSxPQUFBLEdBQUEsT0FBQTtBQU9PLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsR0FBRzs7QUFFMUI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sZUFBZSxPQUFPLENBQzNCLHFCQUFvQyxFQUNaO0VBQ3hCLE1BQU0sYUFBYSxHQUFHLElBQUEsaUJBQVMsRUFBQyxxQkFBcUIsQ0FBQztFQUN0RCxhQUFhLENBQUMsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPO0VBQ3BDLGNBQWMsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDO0VBQ2xDLE9BQU8sYUFBYTtBQUN0QjtBQUVBLFNBQVMsY0FBYyxDQUFDLEtBQThCLEVBQUU7RUFDdEQsTUFBTSwwQkFBMEIsR0FBRyxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUscUJBRTdCO0VBRWIsSUFBSSwwQkFBMEIsRUFBRTtJQUM5QixPQUFPLDBCQUEwQixDQUFDLHdCQUF3QjtFQUM1RDtBQUNGOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ3RDQSxJQUFBLE9BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxzQkFBQSxHQUFBLE9BQUE7QUFFZSxTQUFTLFdBQVcsQ0FBQyxPQUFPLEVBQUUsTUFBTSxFQUFFLFNBQVMsRUFBRTtFQUM5RCxPQUFPLFVBQVUscUJBQXFCLEVBQUU7SUFDdEMsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBUyxFQUFDLHFCQUFxQixDQUFDO0lBQ3RELGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87SUFDcEMsSUFBSTtNQUNGLE1BQU0sS0FBSyxHQUFHLGFBQWEsQ0FBQyxJQUFJO01BQ2hDLE1BQU0sUUFBUSxHQUFHLGNBQWMsQ0FBQyxLQUFLLEVBQUUsU0FBUyxFQUFFLE1BQU0sQ0FBQztNQUN6RCxhQUFhLENBQUMsSUFBSSxHQUFHLFFBQVE7SUFDL0IsQ0FBQyxDQUFDLE9BQU8sR0FBRyxFQUFFO01BQ1osT0FBTyxDQUFDLElBQUksQ0FBQyx1QkFBdUIsT0FBTyxHQUFHLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQztJQUM1RDtJQUNBLE9BQU8sT0FBTyxDQUFDLE9BQU8sQ0FBQyxhQUFhLENBQUM7RUFDdkMsQ0FBQztBQUNIO0FBRUEsU0FBUyxjQUFjLENBQUMsS0FBSyxFQUFFLFNBQVMsRUFBRSxNQUFNLEVBQUU7RUFDaEQsTUFBTSxRQUFRLEdBQUcsS0FBSztFQUN0QixNQUFNO0lBQUU7RUFBc0IsQ0FBQyxHQUFHLFFBQVE7RUFDMUMsSUFBSSxxQkFBcUIsSUFBSSxxQkFBcUIsQ0FBQyxZQUFZLEVBQUU7SUFDL0QsTUFBTTtNQUFFO0lBQWEsQ0FBQyxHQUFHLHFCQUFxQjtJQUU5QyxRQUFRLENBQUMscUJBQXFCLENBQUMsWUFBWSxHQUFHLFlBQVksQ0FBQyxHQUFHLENBQUUsTUFBTSxJQUFLO01BQ3pFLElBQUksQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDdEIsT0FBTyxNQUFNO01BQ2Y7TUFFQSxNQUFNLENBQUMsTUFBTSxHQUFHLHdDQUFpQixDQUFDLE1BQU07TUFDeEMsTUFBTSxDQUFDLEdBQUcsR0FBRztRQUNYLE9BQU8sRUFBRSxNQUFNO1FBQ2YsSUFBSSxFQUFFLGdEQUFnRCxNQUFNO01BQzlELENBQUM7TUFFRCxPQUFPLE1BQU07SUFDZixDQUFDLENBQUM7RUFDSjtFQUNBLE9BQU8sUUFBUTtBQUNqQjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUN2Q0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUEsTUFBTSxVQUFVLEdBQUcsQ0FDakIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFDeEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLENBQUMsT0FBTyxFQUN4QixPQUFPLENBQUMsT0FBTyxDQUFDLENBQUMsT0FBTyxFQUN4QixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsU0FBUyxDQUFDLEVBQ2xCLE9BQU8sQ0FBQyxTQUFTLENBQUMsRUFDbEIsT0FBTyxDQUFDLFNBQVMsQ0FBQyxFQUNsQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxTQUFTLENBQUMsRUFDbEIsT0FBTyxDQUFDLFNBQVMsQ0FBQztBQUNsQjtBQUNBLE9BQU8sQ0FBQyxTQUFTLENBQUMsRUFDbEIsT0FBTyxDQUFDLFNBQVMsQ0FBQyxFQUNsQixPQUFPLENBQUMsU0FBUyxDQUFDLEVBQ2xCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLFNBQVMsQ0FBQyxFQUNsQixPQUFPLENBQUMsU0FBUyxDQUFDLEVBQ2xCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLFNBQVMsQ0FBQyxFQUNsQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxTQUFTLENBQUMsRUFDbEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxTQUFTLENBQUMsRUFDbEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxTQUFTLENBQUMsRUFDbEIsT0FBTyxDQUFDLFNBQVMsQ0FBQyxFQUNsQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxTQUFTLENBQUMsRUFDbEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLFNBQVMsQ0FBQyxFQUNsQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsU0FBUyxDQUFDLEVBQ2xCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxTQUFTLENBQUMsRUFDbEIsT0FBTyxDQUFDLFNBQVMsQ0FBQyxFQUNsQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxTQUFTLENBQUMsRUFDbEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxTQUFTLENBQUMsRUFDbEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsU0FBUyxDQUFDLEVBQ2xCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsU0FBUyxDQUFDLEVBQ2xCLE9BQU8sQ0FBQyxTQUFTLENBQUMsRUFDbEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLFNBQVMsQ0FBQyxFQUNsQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFDaEIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUNoQixPQUFPLENBQUMsT0FBTyxDQUFDLEVBQ2hCLE9BQU8sQ0FBQyxPQUFPLENBQUMsQ0FDakI7QUFBQyxJQUFBLFFBQUEsR0FBQSxPQUFBLENBQUEsT0FBQSxHQUVhLFVBQVU7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDNU56QixJQUFBLE9BQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSx1QkFBQSxHQUFBLE9BQUE7QUFLQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGVBQWUsb0JBQW9CLENBQUEsRUFBRztFQUNwQyxNQUFNO0lBQUUsTUFBTTtJQUFFO0VBQVEsQ0FBQyxHQUFHLFVBQVU7RUFDdEM7RUFDQSxJQUFJLGFBQWEsSUFBSSxNQUFNLENBQUMsT0FBTyxFQUFFO0lBQ25DLE1BQU0sUUFBUSxHQUFHLE1BQU0sTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUM7TUFDaEQsWUFBWSxFQUFFLENBQUMsb0JBQW9CO0lBQ3JDLENBQUMsQ0FBQztJQUNGLE9BQU8sUUFBUSxDQUFDLE1BQU0sR0FBRyxDQUFDO0VBQzVCO0VBQ0EsTUFBTSxjQUFjLEdBQUcsTUFBTSxPQUFPLENBQUMsUUFBUSxDQUFDLENBQUM7RUFDL0MsTUFBTSxHQUFHLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsZ0JBQWdCLENBQUM7RUFDbkQsT0FBTyxjQUFjLENBQUMsSUFBSSxDQUFFLE1BQU0sSUFBSyxNQUFNLENBQUMsR0FBRyxLQUFLLEdBQUcsQ0FBQztBQUM1RDs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLGVBQWUsZUFBZSxDQUFBLEVBQUc7RUFDdEMsTUFBTTtJQUFFO0VBQU8sQ0FBQyxHQUFHLFVBQVU7RUFDN0IsSUFBSSxDQUFDLE1BQU0sQ0FBQyxTQUFTLEVBQUU7SUFDckI7RUFDRjtFQUVBLElBQUksK0JBQStCO0VBQ25DLE1BQU0sV0FBVyxHQUFHLElBQUksT0FBTyxDQUFFLE9BQU8sSUFBSztJQUMzQywrQkFBK0IsR0FBSSxHQUFHLElBQUs7TUFDekMsSUFDRSxHQUFHLENBQUMsTUFBTSxLQUFLLG9EQUE0QixDQUFDLGFBQWEsSUFDekQsR0FBRyxDQUFDLFFBQVEsRUFDWjtRQUNBLE1BQU0sQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLGNBQWMsQ0FDckMsK0JBQ0YsQ0FBQztRQUNELE9BQU8sQ0FBQyxDQUFDOztRQUVUO1FBQ0E7UUFDQSxJQUFJLE9BQU8sQ0FBQyxHQUFHLENBQUMsT0FBTyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsRUFBRTtVQUMvQyxNQUFNO1lBQUU7VUFBMkIsQ0FBQztVQUNsQztVQUNBO1VBQ0EsT0FBTyxDQUFDLDZEQUE2RCxDQUFDO1VBQ3hFLDBCQUEwQixDQUFDLENBQUM7UUFDOUI7TUFDRjtJQUNGLENBQUM7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxXQUFXLENBQUMsK0JBQStCLENBQUM7RUFDdkUsQ0FBQyxDQUFDO0VBRUYsSUFBSTtJQUNGLE1BQU0sZUFBZSxHQUFHLE1BQU0sb0JBQW9CLENBQUMsQ0FBQzs7SUFFcEQ7SUFDQSxJQUFJLGVBQWUsRUFBRTtNQUNuQixPQUFPLENBQUMsS0FBSyxDQUFDLDZDQUE2QyxDQUFDO01BQzVELE1BQU0sTUFBTSxDQUFDLFNBQVMsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUN4QztJQUVBLE1BQU0sTUFBTSxDQUFDLFNBQVMsQ0FBQyxjQUFjLENBQUM7TUFDcEMsR0FBRyxFQUFFLGtCQUFrQjtNQUN2QixPQUFPLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQztNQUM3QixhQUFhLEVBQ1g7SUFDSixDQUFDLENBQUM7RUFDSixDQUFDLENBQUMsT0FBTyxLQUFLLEVBQUU7SUFDZCxJQUFJLCtCQUErQixFQUFFO01BQ25DLE1BQU0sQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLGNBQWMsQ0FBQywrQkFBK0IsQ0FBQztJQUMxRTtJQUNBO0lBQ0E7SUFDQTtJQUNBLElBQUEsd0JBQWdCLEVBQUMsS0FBSyxDQUFDO0lBQ3ZCO0VBQ0Y7O0VBRUE7RUFDQSxNQUFNLGNBQWMsR0FBRyxJQUFJLE9BQU8sQ0FBRSxPQUFPLElBQUs7SUFDOUMsVUFBVSxDQUFDLE9BQU8sRUFBRSw4Q0FBc0IsQ0FBQztFQUM3QyxDQUFDLENBQUM7RUFFRixNQUFNLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQyxXQUFXLEVBQUUsY0FBYyxDQUFDLENBQUM7RUFFakQsT0FBTyxDQUFDLEtBQUssQ0FBQyx5QkFBeUIsQ0FBQztBQUMxQzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNwR0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsVUFBQSxHQUFBLE9BQUE7QUFVQSxJQUFBLGtCQUFBLEdBQUEsc0JBQUEsQ0FBQSxPQUFBO0FBQTZFLFNBQUEsdUJBQUEsQ0FBQSxXQUFBLENBQUEsSUFBQSxDQUFBLENBQUEsVUFBQSxHQUFBLENBQUEsS0FBQSxPQUFBLEVBQUEsQ0FBQTtBQUFBLFNBQUEsMkJBQUEsQ0FBQSxFQUFBLENBQUEsRUFBQSxDQUFBLElBQUEsMEJBQUEsQ0FBQSxDQUFBLEVBQUEsQ0FBQSxHQUFBLENBQUEsQ0FBQSxHQUFBLENBQUEsQ0FBQSxFQUFBLENBQUE7QUFBQSxTQUFBLDJCQUFBLENBQUEsRUFBQSxDQUFBLFFBQUEsQ0FBQSxDQUFBLEdBQUEsQ0FBQSxDQUFBLGFBQUEsU0FBQTtBQUFBLFNBQUEsc0JBQUEsQ0FBQSxFQUFBLENBQUEsV0FBQSxDQUFBLENBQUEsR0FBQSxDQUFBLGlCQUFBLENBQUEsQ0FBQSxFQUFBLENBQUE7QUFBQSxTQUFBLHNCQUFBLENBQUEsRUFBQSxDQUFBLEVBQUEsQ0FBQSxXQUFBLENBQUEsQ0FBQSxHQUFBLENBQUEsaUJBQUEsQ0FBQSxDQUFBLEVBQUEsQ0FBQSxHQUFBLENBQUEsR0FBQSxDQUFBO0FBQUEsU0FBQSxrQkFBQSxDQUFBLEVBQUEsQ0FBQSxFQUFBLENBQUEsNkJBQUEsQ0FBQSxHQUFBLENBQUEsS0FBQSxDQUFBLEdBQUEsQ0FBQSxDQUFBLEdBQUEsQ0FBQSxDQUFBLFVBQUEsU0FBQSxDQUFBLE1BQUEsT0FBQSxDQUFBLEdBQUEsQ0FBQSxZQUFBLFNBQUE7QUFHN0UsTUFBTSxNQUFNLEdBQUcsT0FBTyxDQUFDLEdBQUcsQ0FBQyxPQUFPO0FBQ2xDLE1BQU0sZ0JBQWdCLEdBQUcsTUFBTTtBQUMvQixNQUFNLDRCQUE0QixHQUFHLG1DQUFtQztBQUV4RSxNQUFNLHlDQUF5QyxHQUFHLE1BQU0sR0FDcEQsZ0JBQWdCLEdBQ2YsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQ0FBaUMsSUFBSSxnQkFBaUI7QUFDdkUsTUFBTSx3Q0FBd0MsR0FBRyxNQUFNLEdBQ25ELDRCQUE0QixHQUMzQixPQUFPLENBQUMsR0FBRyxDQUFDLGdDQUFnQyxJQUM3Qyw0QkFBNkI7O0FBRWpDO0FBQ0E7QUFDQTtBQUNPLE1BQU0sT0FBTyxHQUFBLE9BQUEsQ0FBQSxPQUFBLEdBQUcsQ0FBQzs7QUFFeEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sTUFBTSx3QkFBd0IsR0FBQSxPQUFBLENBQUEsd0JBQUEsR0FBRyxDQUFDLENBQUMsR0FBRyxPQUFPLElBQUksQ0FBQzs7QUFFekQ7QUFDQTtBQUNBO0FBQ0E7QUFDQSxNQUFNLDhCQUE4QixHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsSUFBSTs7QUFFckQ7QUFDQTtBQUNBO0FBQ0EsTUFBTSwwQkFBMEIsR0FBRyxLQUFLOztBQUV4QztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTLGVBQWUsQ0FDdEIsUUFBaUIsRUFDbUI7RUFDcEMsT0FDRSxJQUFBLGVBQVEsRUFBQyxRQUFRLENBQUMsSUFDbEIsSUFBQSxrQkFBVyxFQUFDLFFBQVEsRUFBRSxZQUFZLENBQUMsSUFDbkMsT0FBTyxRQUFRLENBQUMsVUFBVSxLQUFLLFFBQVE7QUFFM0M7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTLGVBQWUsQ0FBQyxRQUFpQixFQUFFO0VBQzFDLE9BQU8sZUFBZSxDQUFDLFFBQVEsQ0FBQyxJQUFJLFFBQVEsQ0FBQyxVQUFVLElBQUksR0FBRztBQUNoRTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUyxpQkFBaUIsQ0FBQztFQUN6QixvQkFBb0I7RUFDcEIsaUJBQWlCO0VBQ2pCLDBCQUEwQjtFQUMxQixPQUFPO0VBQ1AsVUFBVTtFQUNWO0FBUUYsQ0FBQyxFQUFFO0VBQ0QsTUFBTSxXQUFXLEdBQUcsSUFBQSxnQkFBSyxFQUFDLG9CQUFTLENBQUMsWUFBWSxDQUFDLGVBQWUsQ0FBQyxFQUFFO0lBQ2pFLFdBQVcsRUFBRSxPQUFPO0lBQ3BCLE9BQU8sRUFBRSxJQUFJLDZCQUFrQixDQUFDO0VBQ2xDLENBQUMsQ0FBQztFQUNGLE1BQU0sb0JBQW9CLEdBQUcsSUFBQSx5QkFBYyxFQUFDLG9CQUFTLEVBQUU7SUFDckQsYUFBYSxFQUFFLG9CQUFvQjtJQUNuQyxPQUFPLEVBQUUsSUFBSSw2QkFBa0IsQ0FBQywwQkFBMEI7RUFDNUQsQ0FBQyxDQUFDO0VBQ0YsSUFBSSxPQUFPLEVBQUU7SUFDWCxvQkFBb0IsQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDO0VBQ3ZDO0VBQ0EsSUFBSSxVQUFVLEVBQUU7SUFDZCxXQUFXLENBQUMsUUFBUSxDQUFDLE1BQU07TUFDekIsSUFBSSxvQkFBb0IsQ0FBQyxLQUFLLEtBQUssdUJBQVksQ0FBQyxNQUFNLEVBQUU7UUFDdEQsVUFBVSxDQUFDLENBQUM7TUFDZDtJQUNGLENBQUMsQ0FBQztJQUNGLFdBQVcsQ0FBQyxTQUFTLENBQUMsQ0FBQztNQUFFO0lBQVMsQ0FBQyxLQUFLO01BQ3RDLElBQ0Usb0JBQW9CLENBQUMsS0FBSyxLQUFLLHVCQUFZLENBQUMsTUFBTSxJQUNsRCxRQUFRLEdBQUcsaUJBQWlCLEVBQzVCO1FBQ0EsVUFBVSxDQUFDLENBQUM7TUFDZDtJQUNGLENBQUMsQ0FBQztFQUNKO0VBQ0EsT0FBTyxJQUFBLGVBQUksRUFBQyxXQUFXLEVBQUUsb0JBQW9CLENBQUM7QUFDaEQ7O0FBRUE7QUFDQTtBQUNBO0FBRkEsSUFBQSw4QkFBQSxvQkFBQSxPQUFBO0FBQUEsSUFBQSw4QkFBQSxvQkFBQSxPQUFBO0FBQUEsSUFBQSxrQkFBQSxvQkFBQSxPQUFBO0FBQUEsSUFBQSw2QkFBQSxvQkFBQSxPQUFBO0FBQUEsSUFBQSxpQkFBQSxvQkFBQSxPQUFBO0FBR08sTUFBTSxtQkFBbUIsQ0FBQztFQVcvQjtBQUNGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtFQUNFLFdBQVcsQ0FBQztJQUNWLDZCQUE2QixHQUFHLHdDQUF3QztJQUN4RSw2QkFBNkIsR0FBRyx5Q0FBeUM7SUFDekUsb0JBQW9CLEdBQUcsOEJBQThCO0lBQ3JELGlCQUFpQixHQUFHLDBCQUEwQjtJQUM5QyxPQUFPO0lBQ1AsVUFBVTtJQUNWO0VBU0YsQ0FBQyxHQUFHLENBQUMsQ0FBQyxFQUFFO0lBMUNSLDBCQUFBLE9BQUEsOEJBQThCO0lBRTlCLDBCQUFBLE9BQUEsOEJBQThCO0lBRTlCLDBCQUFBLE9BQUEsa0JBQWtCO0lBRWxCLDBCQUFBLE9BQUEsNkJBQTZCO0lBRTdCLDBCQUFBLE9BQUEsaUJBQWlCO0lBbUNmLElBQUksQ0FBQyw2QkFBNkIsRUFBRTtNQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLDBDQUEwQyxDQUFDO0lBQzdELENBQUMsTUFBTSxJQUFJLENBQUMsNkJBQTZCLEVBQUU7TUFDekMsTUFBTSxJQUFJLEtBQUssQ0FBQywyQ0FBMkMsQ0FBQztJQUM5RDtJQUNBLHFCQUFBLENBQUssaUJBQWlCLEVBQXRCLElBQUksRUFBcUIsSUFBQSwwQkFBbUIsRUFBQyxPQUFPLENBQS9CLENBQUM7SUFDdEIscUJBQUEsQ0FBSyw4QkFBOEIsRUFBbkMsSUFBSSxFQUFrQyw2QkFBSixDQUFDO0lBQ25DLHFCQUFBLENBQUssOEJBQThCLEVBQW5DLElBQUksRUFBa0MsNkJBQUosQ0FBQztJQUNuQyxxQkFBQSxDQUFLLDZCQUE2QixFQUFsQyxJQUFJLEVBQWlDLGlCQUFpQixDQUFDO01BQ3JELG9CQUFvQjtNQUNwQixpQkFBaUI7TUFDakIsMEJBQTBCLEVBQUUsd0JBQXdCO01BQ3BELE9BQU87TUFDUCxVQUFVO01BQ1YsT0FBTyxFQUFFO0lBQ1gsQ0FBQyxDQVBnQyxDQUFDO0lBUWxDLHFCQUFBLENBQUssa0JBQWtCLEVBQXZCLElBQUksRUFBc0IsaUJBQWlCLENBQUM7TUFDMUMsb0JBQW9CO01BQ3BCLGlCQUFpQjtNQUNqQiwwQkFBMEIsRUFBRSx3QkFBd0I7TUFDcEQsT0FBTztNQUNQLFVBQVU7TUFDVixPQUFPLEVBQUU7SUFDWCxDQUFDLENBUHFCLENBQUM7RUFRekI7O0VBRUE7QUFDRjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7RUFDRSxNQUFNLGdDQUFnQyxDQUNwQyxhQUFxQixFQUNKO0lBQ2pCLE1BQU0sUUFBUSxHQUFHLE1BQU0scUJBQUEsQ0FBSyw2QkFBNkIsRUFBbEMsSUFBaUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxNQUNoRSxxQkFBQSxDQUFLLGlCQUFpQixFQUF0QixJQUFxQixDQUFDLENBQUEsSUFBQSxDQUF0QixJQUFJLEVBQ0YsR0FBRyxxQkFBQSxDQUFLLDhCQUE4QixFQUFuQyxJQUFrQyxDQUFDLHdCQUNwQyxxQkFBQSxDQUFLLDhCQUE4QixFQUFuQyxJQUFrQyxDQUFDLEVBQ25DLEVBQ0Y7TUFDRSxNQUFNLEVBQUUsTUFBTTtNQUNkLE9BQU8sRUFBRTtRQUFFLGNBQWMsRUFBRTtNQUFrQyxDQUFDO01BQzlELElBQUksRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDO1FBQ25CLGNBQWMsRUFBRSxhQUFhO1FBQzdCLFdBQVcsRUFBRSxTQUFTO1FBQ3RCLFVBQVUsRUFBRSxDQUFDLGFBQWE7TUFDNUIsQ0FBQztJQUNILENBQUMsQ0FFTCxDQUFDO0lBQ0QsSUFBSSxDQUFDLFFBQVEsQ0FBQyxFQUFFLEVBQUU7TUFDaEIsTUFBTSxJQUFJLEtBQUssQ0FDYiw2QkFBNkIsUUFBUSxDQUFDLE1BQU0sZUFDOUMsQ0FBQztJQUNIO0lBQ0EsT0FBTyxDQUFDLE1BQU0sUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDLEVBQUUsSUFBSSxDQUFDLFVBQVU7RUFDaEQ7O0VBRUE7QUFDRjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7RUFDRSxNQUFNLDZCQUE2QixDQUNqQyxrQkFBMEIsRUFDTztJQUNqQyxNQUFNLFFBQVEsR0FBRyxNQUFNLHFCQUFBLENBQUssa0JBQWtCLEVBQXZCLElBQXNCLENBQUMsQ0FBQyxPQUFPLENBQUMsTUFDckQscUJBQUEsQ0FBSyxpQkFBaUIsRUFBdEIsSUFBcUIsQ0FBQyxDQUFBLElBQUEsQ0FBdEIsSUFBSSxFQUNGLEdBQ0UscUJBQUEsQ0FBSyw4QkFBOEIsRUFBbkMsSUFBa0MsQ0FBQyxnQkFDckIsa0JBQWtCLEVBQUUsRUFDcEM7TUFDRSxNQUFNLEVBQUUsS0FBSztNQUNiLE9BQU8sRUFBRTtRQUFFLGNBQWMsRUFBRTtNQUFrQztJQUMvRCxDQUFDLENBRUwsQ0FBQztJQUNELElBQUksQ0FBQyxRQUFRLENBQUMsRUFBRSxFQUFFO01BQ2hCLE1BQU0sSUFBSSxLQUFLLENBQ2IsNkJBQTZCLFFBQVEsQ0FBQyxNQUFNLGVBQzlDLENBQUM7SUFDSDtJQUNBLE9BQU8sQ0FBQyxNQUFNLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQyxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsYUFBYTtFQUM5RDtBQUNGO0FBQUMsT0FBQSxDQUFBLG1CQUFBLEdBQUEsbUJBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDdlJELElBQUEsNkJBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxpQkFBQSxHQUFBLE9BQUE7QUFFQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQXdDLFNBQUEsMkJBQUEsQ0FBQSxFQUFBLENBQUEsRUFBQSxDQUFBLElBQUEsMEJBQUEsQ0FBQSxDQUFBLEVBQUEsQ0FBQSxHQUFBLENBQUEsQ0FBQSxHQUFBLENBQUEsQ0FBQSxFQUFBLENBQUE7QUFBQSxTQUFBLDJCQUFBLENBQUEsRUFBQSxDQUFBLFFBQUEsQ0FBQSxDQUFBLEdBQUEsQ0FBQSxDQUFBLGFBQUEsU0FBQTtBQUFBLFNBQUEsZ0JBQUEsQ0FBQSxFQUFBLENBQUEsRUFBQSxDQUFBLFlBQUEsQ0FBQSxHQUFBLGNBQUEsQ0FBQSxDQUFBLE1BQUEsQ0FBQSxHQUFBLE1BQUEsQ0FBQSxjQUFBLENBQUEsQ0FBQSxFQUFBLENBQUEsSUFBQSxLQUFBLEVBQUEsQ0FBQSxFQUFBLFVBQUEsTUFBQSxZQUFBLE1BQUEsUUFBQSxVQUFBLENBQUEsQ0FBQSxDQUFBLElBQUEsQ0FBQSxFQUFBLENBQUE7QUFBQSxTQUFBLGVBQUEsQ0FBQSxRQUFBLENBQUEsR0FBQSxZQUFBLENBQUEsQ0FBQSx1Q0FBQSxDQUFBLEdBQUEsQ0FBQSxHQUFBLENBQUE7QUFBQSxTQUFBLGFBQUEsQ0FBQSxFQUFBLENBQUEsMkJBQUEsQ0FBQSxLQUFBLENBQUEsU0FBQSxDQUFBLE1BQUEsQ0FBQSxHQUFBLENBQUEsQ0FBQSxNQUFBLENBQUEsV0FBQSxrQkFBQSxDQUFBLFFBQUEsQ0FBQSxHQUFBLENBQUEsQ0FBQSxJQUFBLENBQUEsQ0FBQSxFQUFBLENBQUEsdUNBQUEsQ0FBQSxTQUFBLENBQUEsWUFBQSxTQUFBLHlFQUFBLENBQUEsR0FBQSxNQUFBLEdBQUEsTUFBQSxFQUFBLENBQUE7QUFBQSxTQUFBLHNCQUFBLENBQUEsRUFBQSxDQUFBLFdBQUEsQ0FBQSxDQUFBLEdBQUEsQ0FBQSxpQkFBQSxDQUFBLENBQUEsRUFBQSxDQUFBO0FBQUEsU0FBQSxrQkFBQSxDQUFBLEVBQUEsQ0FBQSxFQUFBLENBQUEsNkJBQUEsQ0FBQSxHQUFBLENBQUEsS0FBQSxDQUFBLEdBQUEsQ0FBQSxDQUFBLEdBQUEsQ0FBQSxDQUFBLFVBQUEsU0FBQSxDQUFBLE1BQUEsT0FBQSxDQUFBLEdBQUEsQ0FBQSxZQUFBLFNBQUE7QUFBQSxJQUFBLE1BQUEsb0JBQUEsT0FBQTtBQUVqQyxNQUFNLGlCQUFpQixTQUFTLGtDQUFnQixDQUFDO0VBU3RELFdBQVcsQ0FBQyxPQUE0QixFQUFFO0lBQ3hDLEtBQUssQ0FBQyxPQUFPLENBQUM7SUFUaEI7SUFDQTtJQUFBLGVBQUE7SUFHQSwwQkFBQSxPQUFTLE1BQU0sRUFBRyxDQUFDLE1BQU0sRUFBRSxPQUFPLENBQUM7SUFBQyxlQUFBO0lBT2xDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxHQUFHLE9BQU8sQ0FBQyxhQUFhLHdCQUF3Qjs7SUFFekU7SUFDQTtJQUNBLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxHQUFHLE9BQU8sQ0FBQyxhQUFhLHdCQUF3QjtFQUMxRTtFQUVBLElBQUksY0FBYyxDQUFBLEVBQUc7SUFDbkIsT0FBTyw0Q0FBYyxDQUFDLEtBQUs7RUFDN0I7RUFFQSxJQUFJLEtBQUssQ0FBQSxFQUFHO0lBQ1YsT0FBTyxxQkFBQSxDQUFLLE1BQU0sRUFBWCxJQUFVLENBQUM7RUFDcEI7O0VBRUE7QUFDRjtBQUNBO0FBQ0E7QUFDQTtFQUNFLE1BQU0sVUFBVSxDQUFBLEVBQW9CO0lBQ2xDLE1BQU0sT0FBTyxHQUFHLElBQUksR0FBRyxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztJQUU5QyxNQUFNLFdBQVcsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLGdCQUFnQixDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2xFLE1BQU0sS0FBSyxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNsQyxNQUFNO01BQUU7SUFBVSxDQUFDLEdBQUcsTUFBTSxJQUFJLENBQUMsNkJBQTZCLENBQUMsQ0FBQztJQUVoRSxPQUFPLENBQUMsWUFBWSxDQUFDLEdBQUcsQ0FBQyxXQUFXLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxhQUFhLENBQUM7SUFDakUsT0FBTyxDQUFDLFlBQVksQ0FBQyxHQUFHLENBQUMsZUFBZSxFQUFFLE1BQU0sQ0FBQztJQUNqRCxPQUFPLENBQUMsWUFBWSxDQUFDLEdBQUcsQ0FBQyxjQUFjLEVBQUUsV0FBVyxDQUFDO0lBQ3JELE9BQU8sQ0FBQyxZQUFZLENBQUMsR0FBRyxDQUFDLGVBQWUsRUFBRSxXQUFXLENBQUM7SUFDdEQsT0FBTyxDQUFDLFlBQVksQ0FBQyxHQUFHLENBQUMsUUFBUSxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUM7SUFDL0MsT0FBTyxDQUFDLFlBQVksQ0FBQyxHQUFHLENBQ3RCLE9BQU8sRUFDUCxJQUFJLENBQUMsU0FBUyxDQUFDO01BQ2I7TUFDQTtNQUNBLHdCQUF3QixFQUN0QixJQUFJLENBQUMsT0FBTyxDQUFDLGdCQUFnQixDQUFDLGNBQWMsQ0FBQyxDQUFDO01BQ2hELEtBQUs7TUFDTDtNQUNBO01BQ0EsY0FBYyxFQUFFO0lBQ2xCLENBQUMsQ0FDSCxDQUFDO0lBQ0QsT0FBTyxDQUFDLFlBQVksQ0FBQyxHQUFHLENBQUMsT0FBTyxFQUFFLHFCQUFBLENBQUssTUFBTSxFQUFYLElBQVUsQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUV4RCxPQUFPLE9BQU8sQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7RUFDNUM7O0VBRUE7QUFDRjtBQUNBO0FBQ0E7QUFDQTtFQUNFLE1BQU0sY0FBYyxDQUFBLEVBQStCO0lBQ2pELE1BQU0sV0FBVyxHQUFHLElBQUksQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDO0lBQ3ZELE1BQU0sR0FBRyxHQUFHLE1BQU0sSUFBSSxDQUFDLHNCQUFzQixDQUFDLFdBQVcsQ0FBQztJQUMxRCxPQUFPLEdBQUc7RUFDWjs7RUFFQTtBQUNGO0FBQ0E7QUFDQTtBQUNBO0VBQ0UsNEJBQTRCLENBQUEsRUFBVztJQUNyQyxNQUFNO01BQUU7SUFBZ0IsQ0FBQyxHQUFHLElBQUksQ0FBQyxPQUFPO0lBQ3hDLE1BQU0sV0FBVyxHQUFHO01BQ2xCO01BQ0E7TUFDQSxhQUFhLEVBQUUsSUFBSSxDQUFDLFlBQVk7TUFDaEM7TUFDQTtNQUNBLFNBQVMsRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLGFBQWE7TUFDckM7TUFDQTtNQUNBLFlBQVksRUFBRSxJQUFJLENBQUMsaUJBQWlCO01BQ3BDO01BQ0E7TUFDQSxjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7TUFDbkMsT0FBTyxFQUFFLGVBQWU7TUFDeEI7TUFDQTtNQUNBLFdBQVcsRUFBRTtJQUNmLENBQUM7SUFFRCxPQUFPLElBQUksQ0FBQyxTQUFTLENBQUMsV0FBVyxDQUFDO0VBQ3BDO0VBRUEsTUFBTSxzQkFBc0IsQ0FDMUIsV0FBbUIsRUFDUztJQUM1QixNQUFNLEdBQUcsR0FBRyxNQUFNLEtBQUssQ0FDckIsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLGFBQWEsK0JBQStCLEVBQzVEO01BQ0UsTUFBTSxFQUFFLE1BQU07TUFDZCxPQUFPLEVBQUU7UUFDUCxjQUFjLEVBQUU7TUFDbEIsQ0FBQztNQUNELElBQUksRUFBRTtJQUNSLENBQ0YsQ0FBQztJQUVELE1BQU0sSUFBSSxHQUFHLE1BQU0sR0FBRyxDQUFDLElBQUksQ0FBQyxDQUFDO0lBQzdCLE9BQU8sSUFBSTtFQUNiOztFQUVBO0FBQ0Y7QUFDQTtBQUNBO0FBQ0E7QUFDQTtFQUNFLE1BQU0sV0FBVyxDQUFDLE9BQWUsRUFBMEI7SUFDekQsTUFBTSxXQUFXLEdBQUcsSUFBQSxvQkFBYSxFQUFDLE9BQU8sQ0FBQztJQUMxQyxNQUFNLE9BQU8sR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQztJQUN2QyxPQUFPO01BQ0wsS0FBSyxFQUFFLE9BQU8sQ0FBQyxLQUFLO01BQ3BCLEdBQUcsRUFBRSxPQUFPLENBQUM7SUFDZixDQUFDO0VBQ0g7QUFDRjtBQUFDLE9BQUEsQ0FBQSxpQkFBQSxHQUFBLGlCQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQzFJRCxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQXNFLFNBQUEsZ0JBQUEsQ0FBQSxFQUFBLENBQUEsRUFBQSxDQUFBLFlBQUEsQ0FBQSxHQUFBLGNBQUEsQ0FBQSxDQUFBLE1BQUEsQ0FBQSxHQUFBLE1BQUEsQ0FBQSxjQUFBLENBQUEsQ0FBQSxFQUFBLENBQUEsSUFBQSxLQUFBLEVBQUEsQ0FBQSxFQUFBLFVBQUEsTUFBQSxZQUFBLE1BQUEsUUFBQSxVQUFBLENBQUEsQ0FBQSxDQUFBLElBQUEsQ0FBQSxFQUFBLENBQUE7QUFBQSxTQUFBLGVBQUEsQ0FBQSxRQUFBLENBQUEsR0FBQSxZQUFBLENBQUEsQ0FBQSx1Q0FBQSxDQUFBLEdBQUEsQ0FBQSxHQUFBLENBQUE7QUFBQSxTQUFBLGFBQUEsQ0FBQSxFQUFBLENBQUEsMkJBQUEsQ0FBQSxLQUFBLENBQUEsU0FBQSxDQUFBLE1BQUEsQ0FBQSxHQUFBLENBQUEsQ0FBQSxNQUFBLENBQUEsV0FBQSxrQkFBQSxDQUFBLFFBQUEsQ0FBQSxHQUFBLENBQUEsQ0FBQSxJQUFBLENBQUEsQ0FBQSxFQUFBLENBQUEsdUNBQUEsQ0FBQSxTQUFBLENBQUEsWUFBQSxTQUFBLHlFQUFBLENBQUEsR0FBQSxNQUFBLEdBQUEsTUFBQSxFQUFBLENBQUE7QUFHL0QsTUFBZSxnQkFBZ0IsQ0FBQztFQTRCckMsV0FBVyxDQUFDLE9BQTRCLEVBQUU7SUFBQSxlQUFBO0lBQUEsZUFBQTtJQXZCMUM7SUFBQSxlQUFBO0lBR0E7SUFBQSxlQUFBLGlCQUM0QixnQkFBZ0I7SUFFNUM7SUFDQTtJQUFBLGVBQUEsZ0NBQzJDLE1BQU07SUFFakQ7SUFDQTtJQUFBLGVBQUEsaUNBQzRDLHFCQUFxQjtJQUVqRTtJQUNBO0lBQUEsZUFBQSxrQ0FDNkMsc0JBQXNCO0lBRW5FO0lBQ0E7SUFBQSxlQUFBLHlDQUVFLG1DQUFtQztJQUduQyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU87RUFDeEI7O0VBTUE7QUFDRjtBQUNBO0FBQ0E7QUFDQTs7RUFHRTtBQUNGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0VBR0U7QUFDRjtBQUNBO0FBQ0E7QUFDQTtBQUNBOztFQUdFO0FBQ0Y7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7RUFHRTtBQUNGO0FBQ0E7QUFDQTtBQUNBO0VBQ0UsYUFBYSxDQUFDLEdBQVcsRUFBUTtJQUMvQixNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLENBQUM7SUFDM0IsTUFBTSxLQUFLLEdBQUcsTUFBTSxDQUFDLFlBQVksQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDO0lBRTlDLElBQUksT0FBTyxLQUFLLEtBQUssUUFBUSxFQUFFO01BQzdCLE1BQU0sSUFBSSxLQUFLLENBQUMseUJBQWtCLENBQUMseUJBQXlCLENBQUM7SUFDL0Q7SUFFQSxNQUFNLFdBQVcsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQztJQUVyQyxJQUFJLFdBQVcsQ0FBQyxLQUFLLEtBQUssSUFBSSxDQUFDLEtBQUssRUFBRTtNQUNwQyxNQUFNLElBQUksS0FBSyxDQUFDLHlCQUFrQixDQUFDLHlCQUF5QixDQUFDO0lBQy9EO0VBQ0Y7O0VBRUE7QUFDRjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0VBQ0UsTUFBTSxnQkFBZ0IsQ0FBQyxZQUFvQixFQUE4QjtJQUN2RSxNQUFNO01BQUU7SUFBZ0IsQ0FBQyxHQUFHLElBQUksQ0FBQyxPQUFPO0lBQ3hDLE1BQU0sV0FBVyxHQUFHO01BQ2xCO01BQ0E7TUFDQSxTQUFTLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxhQUFhO01BQ3JDO01BQ0E7TUFDQSxjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7TUFDbkMsT0FBTyxFQUFFLGVBQWU7TUFDeEI7TUFDQTtNQUNBLGFBQWEsRUFBRSxZQUFZO01BQzNCO01BQ0E7TUFDQSxVQUFVLEVBQUUsZUFBZSxDQUFFO0lBQy9CLENBQUM7SUFDRCxNQUFNLEdBQUcsR0FBRyxNQUFNLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQ3BFLE9BQU8sR0FBRztFQUNaOztFQUVBO0FBQ0Y7QUFDQTtBQUNBO0FBQ0E7RUFDRSxNQUFNLGtCQUFrQixDQUFDLFdBQW1CLEVBQWlCO0lBQzNELE1BQU0sV0FBVyxHQUFHO01BQ2xCO01BQ0E7TUFDQSxZQUFZLEVBQUU7SUFDaEIsQ0FBQztJQUVELE1BQU0sR0FBRyxHQUFHLE1BQU0sS0FBSyxDQUNyQixHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsYUFBYSxHQUFHLElBQUksQ0FBQyx1QkFBdUIsRUFBRSxFQUM5RDtNQUNFLE1BQU0sRUFBRSxNQUFNO01BQ2QsT0FBTyxFQUFFO1FBQ1AsY0FBYyxFQUFFO01BQ2xCLENBQUM7TUFDRCxJQUFJLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxXQUFXO0lBQ2xDLENBQ0YsQ0FBQztJQUVELElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxFQUFFO01BQ1gsTUFBTSxJQUFJLEtBQUssQ0FBQyxnQ0FBZ0MsQ0FBQztJQUNuRDtFQUNGOztFQUVBO0FBQ0Y7QUFDQTtBQUNBO0FBQ0E7QUFDQTtFQUNFLE1BQU0saUJBQWlCLENBQUMsV0FBbUIsRUFTeEM7SUFDRCxNQUFNLFdBQVcsR0FBRztNQUNsQjtNQUNBO01BQ0EsWUFBWSxFQUFFO0lBQ2hCLENBQUM7SUFFRCxNQUFNLEdBQUcsR0FBRyxNQUFNLEtBQUssQ0FDckIsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLGFBQWEsR0FBRyxJQUFJLENBQUMsOEJBQThCLEVBQUUsRUFDckU7TUFDRSxNQUFNLEVBQUUsTUFBTTtNQUNkLE9BQU8sRUFBRTtRQUNQLGNBQWMsRUFBRTtNQUNsQixDQUFDO01BQ0QsSUFBSSxFQUFFLElBQUksQ0FBQyxTQUFTLENBQUMsV0FBVztJQUNsQyxDQUNGLENBQUM7SUFFRCxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsRUFBRTtNQUNYLE1BQU0sSUFBSSxLQUFLLENBQUMsK0JBQStCLENBQUM7SUFDbEQ7SUFFQSxNQUFNLElBQUksR0FBRyxNQUFNLEdBQUcsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUM3QixPQUFPO01BQ0w7TUFDQTtNQUNBLGFBQWEsRUFBRSxJQUFJLENBQUMsYUFBYTtNQUNqQztNQUNBO01BQ0EsWUFBWSxFQUFFLElBQUksQ0FBQztJQUNyQixDQUFDO0VBQ0g7O0VBRUE7QUFDRjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0VBQ0UsTUFBZ0IsZ0JBQWdCLENBQzlCLFdBQW1CLEVBQ1M7SUFDNUIsTUFBTSxHQUFHLEdBQUcsTUFBTSxLQUFLLENBQ3JCLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxhQUFhLEdBQUcsSUFBSSxDQUFDLHNCQUFzQixFQUFFLEVBQzdEO01BQ0UsTUFBTSxFQUFFLE1BQU07TUFDZCxPQUFPLEVBQUU7UUFDUCxjQUFjLEVBQUU7TUFDbEIsQ0FBQztNQUNELElBQUksRUFBRTtJQUNSLENBQ0YsQ0FBQztJQUVELElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxFQUFFO01BQ1gsTUFBTSxJQUFJLEtBQUssQ0FBQywwQkFBMEIsQ0FBQztJQUM3QztJQUVBLE1BQU0sSUFBSSxHQUFHLE1BQU0sR0FBRyxDQUFDLElBQUksQ0FBQyxDQUFDO0lBQzdCLE9BQU8sSUFBSTtFQUNiOztFQUVBO0FBQ0Y7QUFDQTtBQUNBO0FBQ0E7RUFDWSxhQUFhLENBQUEsRUFBVztJQUNoQyxJQUFJLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsZ0JBQWdCLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDMUQsT0FBTyxJQUFJLENBQUMsS0FBSztFQUNuQjs7RUFFQTtBQUNGO0FBQ0E7QUFDQTtBQUNBO0VBQ0UsTUFBZ0IsNkJBQTZCLENBQUEsRUFHMUM7SUFDRCxNQUFNO01BQUUsWUFBWTtNQUFFO0lBQVUsQ0FBQyxHQUMvQixNQUFNLElBQUksQ0FBQyxPQUFPLENBQUMsZ0JBQWdCLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztJQUN4RSxJQUFJLENBQUMsWUFBWSxHQUFHLFlBQVk7SUFDaEMsT0FBTztNQUFFLFlBQVk7TUFBRTtJQUFVLENBQUM7RUFDcEM7QUFDRjtBQUFDLE9BQUEsQ0FBQSxnQkFBQSxHQUFBLGdCQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDdFBELElBQUEsNkJBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxVQUFBLEdBQUEsT0FBQTtBQUFzRSxJQUcxRCxZQUFZLEdBQUEsT0FBQSxDQUFBLFlBQUEsMEJBQVosWUFBWTtFQUFaLFlBQVk7RUFBWixZQUFZO0VBQVosWUFBWTtFQUFaLFlBQVk7RUFBWixZQUFZO0VBQVosWUFBWTtFQUFaLFlBQVk7RUFBQSxPQUFaLFlBQVk7QUFBQTtBQTRDakIsTUFBTSxjQUFpRCxHQUFBLE9BQUEsQ0FBQSxjQUFBLEdBQUc7RUFDL0QsQ0FBQyxZQUFZLENBQUMsT0FBTyxHQUFHO0lBQ3RCLHNCQUFzQixFQUFFLHlCQUF5QjtJQUNqRCxxQkFBcUIsRUFBRSxxQkFBcUI7SUFDNUMsNkJBQTZCLEVBQUUsZUFBZTtJQUM5Qyw0QkFBNEIsRUFBRSxjQUFjO0lBQzVDLGFBQWEsRUFBRSw2Q0FBNkM7SUFDNUQsZUFBZSxFQUFFLDZDQUFlLENBQUM7RUFDbkMsQ0FBQztFQUNELENBQUMsWUFBWSxDQUFDLFFBQVEsR0FBRztJQUN2QixzQkFBc0IsRUFBRSwrQkFBK0I7SUFDdkQscUJBQXFCLEVBQUUsMkJBQTJCO0lBQ2xELDZCQUE2QixFQUFFLHFCQUFxQjtJQUNwRCw0QkFBNEIsRUFBRSxvQkFBb0I7SUFDbEQsYUFBYSxFQUFFLDZDQUE2QztJQUM1RCxlQUFlLEVBQUUsNkNBQWUsQ0FBQztFQUNuQyxDQUFDO0VBQ0QsQ0FBQyxZQUFZLENBQUMsT0FBTyxHQUFHO0lBQ3RCLHNCQUFzQixFQUFFLHlCQUF5QjtJQUNqRCxxQkFBcUIsRUFBRSxxQkFBcUI7SUFDNUMsNkJBQTZCLEVBQUUsZUFBZTtJQUM5Qyw0QkFBNEIsRUFBRSxjQUFjO0lBQzVDLGFBQWEsRUFBRSw2Q0FBNkM7SUFDNUQsZUFBZSxFQUFFLDZDQUFlLENBQUM7RUFDbkMsQ0FBQztFQUNELENBQUMsWUFBWSxDQUFDLFFBQVEsR0FBRztJQUN2QixzQkFBc0IsRUFBRSwrQkFBK0I7SUFDdkQscUJBQXFCLEVBQUUsMkJBQTJCO0lBQ2xELDZCQUE2QixFQUFFLHFCQUFxQjtJQUNwRCw0QkFBNEIsRUFBRSxvQkFBb0I7SUFDbEQsYUFBYSxFQUFFLDZDQUE2QztJQUM1RCxlQUFlLEVBQUUsNkNBQWUsQ0FBQztFQUNuQyxDQUFDO0VBQ0QsQ0FBQyxZQUFZLENBQUMsUUFBUSxHQUFHO0lBQ3ZCLHNCQUFzQixFQUFFLDBCQUEwQjtJQUNsRCxxQkFBcUIsRUFBRSxzQkFBc0I7SUFDN0MsNkJBQTZCLEVBQUUsZ0JBQWdCO0lBQy9DLDRCQUE0QixFQUFFLGVBQWU7SUFDN0MsYUFBYSxFQUFFLHlDQUF5QztJQUN4RCxlQUFlLEVBQUUsNkNBQWUsQ0FBQztFQUNuQyxDQUFDO0VBQ0QsQ0FBQyxZQUFZLENBQUMsU0FBUyxHQUFHO0lBQ3hCLHNCQUFzQixFQUFFLGdDQUFnQztJQUN4RCxxQkFBcUIsRUFBRSw0QkFBNEI7SUFDbkQsNkJBQTZCLEVBQUUsc0JBQXNCO0lBQ3JELDRCQUE0QixFQUFFLHFCQUFxQjtJQUNuRCxhQUFhLEVBQUUseUNBQXlDO0lBQ3hELGVBQWUsRUFBRSw2Q0FBZSxDQUFDO0VBQ25DLENBQUM7RUFDRCxDQUFDLFlBQVksQ0FBQyxJQUFJLEdBQUc7SUFDbkIsc0JBQXNCLEVBQUUsMEJBQTBCO0lBQ2xELHFCQUFxQixFQUFFLHNCQUFzQjtJQUM3Qyw2QkFBNkIsRUFBRSxnQkFBZ0I7SUFDL0MsNEJBQTRCLEVBQUUsZUFBZTtJQUM3QyxhQUFhLEVBQUUseUNBQXlDO0lBQ3hELGVBQWUsRUFBRSw2Q0FBZSxDQUFDO0VBQ25DO0FBQ0YsQ0FBQzs7QUFFRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sU0FBUyxnQkFBZ0IsQ0FBQSxFQUFHO0VBQ2pDLE9BQ0UsT0FBTyxDQUFDLEdBQUcsQ0FBQyxvQkFBb0IsS0FBSyxzQkFBVyxDQUFDLFdBQVcsSUFDNUQsT0FBTyxDQUFDLEdBQUcsQ0FBQyxvQkFBb0IsS0FBSyxzQkFBVyxDQUFDLE9BQU87QUFFNUQ7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVMsaUJBQWlCLENBQUEsRUFBRztFQUMzQixPQUFPLE9BQU8sQ0FBQyxHQUFHLENBQUMsb0JBQW9CLEtBQUssc0JBQVcsQ0FBQyxVQUFVO0FBQ3BFOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVMsdUJBQXVCLENBQUEsRUFBRztFQUNqQyxPQUFPLE9BQU8sQ0FBQyxHQUFHLENBQUMsb0JBQW9CLEtBQUssc0JBQVcsQ0FBQyxpQkFBaUI7QUFDM0U7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLFNBQVMsZUFBZSxDQUFBLEVBQWdCO0VBQzdDLE1BQU0sU0FBUyxHQUFHLE9BQU8sQ0FBQyxHQUFHLENBQUMsbUJBQW1CO0VBRWpELElBQUksWUFBWSxHQUFHLFlBQVksQ0FBQyxPQUFPO0VBQ3ZDLElBQUksU0FBUyxLQUFLLE1BQU0sSUFBSSxTQUFTLEtBQUssY0FBYyxFQUFFO0lBQ3hELElBQUksZ0JBQWdCLENBQUMsQ0FBQyxFQUFFO01BQ3RCLFlBQVksR0FBRyxZQUFZLENBQUMsT0FBTztJQUNyQyxDQUFDLE1BQU0sSUFBSSxpQkFBaUIsQ0FBQyxDQUFDLElBQUksdUJBQXVCLENBQUMsQ0FBQyxFQUFFO01BQzNELFlBQVksR0FBRyxZQUFZLENBQUMsUUFBUTtJQUN0QyxDQUFDLE1BQU07TUFDTCxZQUFZLEdBQUcsWUFBWSxDQUFDLE9BQU87SUFDckM7RUFDRixDQUFDLE1BQU0sSUFBSSxTQUFTLEtBQUssT0FBTyxFQUFFO0lBQ2hDLElBQUksZ0JBQWdCLENBQUMsQ0FBQyxFQUFFO01BQ3RCLFlBQVksR0FBRyxZQUFZLENBQUMsUUFBUTtJQUN0QyxDQUFDLE1BQU0sSUFBSSxpQkFBaUIsQ0FBQyxDQUFDLElBQUksdUJBQXVCLENBQUMsQ0FBQyxFQUFFO01BQzNELFlBQVksR0FBRyxZQUFZLENBQUMsU0FBUztJQUN2QyxDQUFDLE1BQU07TUFDTCxZQUFZLEdBQUcsWUFBWSxDQUFDLFFBQVE7SUFDdEM7RUFDRixDQUFDLE1BQU0sSUFBSSxTQUFTLEtBQUssTUFBTSxFQUFFO0lBQy9CLFlBQVksR0FBRyxZQUFZLENBQUMsSUFBSTtFQUNsQztFQUVBLE9BQU8sY0FBYyxDQUFDLFlBQVksQ0FBQztBQUNyQzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUN4S0EsSUFBQSw2QkFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGtCQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsbUJBQUEsR0FBQSxPQUFBO0FBUU8sU0FBUyxrQkFBa0IsQ0FDaEMsY0FBOEIsRUFDOUIsTUFBbUMsRUFDbkMsZ0JBQWtDLEVBQ2xDO0VBQ0EsTUFBTSxvQkFBZ0UsR0FBRztJQUN2RSxlQUFlLEVBQUUsTUFBTSxDQUFDLGVBQWU7SUFDdkMsYUFBYSxFQUFFLE1BQU0sQ0FBQyxhQUFhO0lBQ25DO0VBQ0YsQ0FBQztFQUVELFFBQVEsY0FBYztJQUNwQixLQUFLLDRDQUFjLENBQUMsTUFBTTtNQUN4QixPQUFPLElBQUksc0NBQWtCLENBQUM7UUFDNUIsR0FBRyxvQkFBb0I7UUFDdkIsYUFBYSxFQUFFLE1BQU0sQ0FBQztNQUN4QixDQUFDLENBQUM7SUFDSixLQUFLLDRDQUFjLENBQUMsS0FBSztNQUN2QixPQUFPLElBQUksb0NBQWlCLENBQUM7UUFDM0IsR0FBRyxvQkFBb0I7UUFDdkIsYUFBYSxFQUFFLE1BQU0sQ0FBQztNQUN4QixDQUFDLENBQUM7SUFDSjtNQUNFO01BQ0E7TUFDQSxNQUFNLElBQUksS0FBSyxDQUFDLGtDQUFrQyxjQUFjLEVBQUUsQ0FBQztFQUN2RTtBQUNGOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ3JDQSxJQUFBLDZCQUFBLEdBQUEsT0FBQTtBQUNBLElBQUEsaUJBQUEsR0FBQSxPQUFBO0FBRUEsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUF3QyxTQUFBLDJCQUFBLENBQUEsRUFBQSxDQUFBLEVBQUEsQ0FBQSxJQUFBLDBCQUFBLENBQUEsQ0FBQSxFQUFBLENBQUEsR0FBQSxDQUFBLENBQUEsR0FBQSxDQUFBLENBQUEsRUFBQSxDQUFBO0FBQUEsU0FBQSwyQkFBQSxDQUFBLEVBQUEsQ0FBQSxRQUFBLENBQUEsQ0FBQSxHQUFBLENBQUEsQ0FBQSxhQUFBLFNBQUE7QUFBQSxTQUFBLGdCQUFBLENBQUEsRUFBQSxDQUFBLEVBQUEsQ0FBQSxZQUFBLENBQUEsR0FBQSxjQUFBLENBQUEsQ0FBQSxNQUFBLENBQUEsR0FBQSxNQUFBLENBQUEsY0FBQSxDQUFBLENBQUEsRUFBQSxDQUFBLElBQUEsS0FBQSxFQUFBLENBQUEsRUFBQSxVQUFBLE1BQUEsWUFBQSxNQUFBLFFBQUEsVUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBLENBQUEsRUFBQSxDQUFBO0FBQUEsU0FBQSxlQUFBLENBQUEsUUFBQSxDQUFBLEdBQUEsWUFBQSxDQUFBLENBQUEsdUNBQUEsQ0FBQSxHQUFBLENBQUEsR0FBQSxDQUFBO0FBQUEsU0FBQSxhQUFBLENBQUEsRUFBQSxDQUFBLDJCQUFBLENBQUEsS0FBQSxDQUFBLFNBQUEsQ0FBQSxNQUFBLENBQUEsR0FBQSxDQUFBLENBQUEsTUFBQSxDQUFBLFdBQUEsa0JBQUEsQ0FBQSxRQUFBLENBQUEsR0FBQSxDQUFBLENBQUEsSUFBQSxDQUFBLENBQUEsRUFBQSxDQUFBLHVDQUFBLENBQUEsU0FBQSxDQUFBLFlBQUEsU0FBQSx5RUFBQSxDQUFBLEdBQUEsTUFBQSxHQUFBLE1BQUEsRUFBQSxDQUFBO0FBQUEsU0FBQSxzQkFBQSxDQUFBLEVBQUEsQ0FBQSxXQUFBLENBQUEsQ0FBQSxHQUFBLENBQUEsaUJBQUEsQ0FBQSxDQUFBLEVBQUEsQ0FBQTtBQUFBLFNBQUEsa0JBQUEsQ0FBQSxFQUFBLENBQUEsRUFBQSxDQUFBLDZCQUFBLENBQUEsR0FBQSxDQUFBLEtBQUEsQ0FBQSxHQUFBLENBQUEsQ0FBQSxHQUFBLENBQUEsQ0FBQSxVQUFBLFNBQUEsQ0FBQSxNQUFBLE9BQUEsQ0FBQSxHQUFBLENBQUEsWUFBQSxTQUFBO0FBQUEsSUFBQSxNQUFBLG9CQUFBLE9BQUE7QUFFakMsTUFBTSxrQkFBa0IsU0FBUyxrQ0FBZ0IsQ0FBQztFQUFBLFlBQUEsR0FBQSxJQUFBO0lBQUEsU0FBQSxJQUFBO0lBQ3ZEO0lBQ0E7SUFBQSxlQUFBLDJCQUVFLDhDQUE4QztJQUVoRCwwQkFBQSxPQUFTLE1BQU0sRUFBRyxDQUFDLFFBQVEsRUFBRSxTQUFTLEVBQUUsT0FBTyxDQUFDO0VBQUM7RUFFakQsSUFBSSxjQUFjLENBQUEsRUFBRztJQUNuQixPQUFPLDRDQUFjLENBQUMsTUFBTTtFQUM5QjtFQUVBLElBQUksS0FBSyxDQUFBLEVBQUc7SUFDVixPQUFPLHFCQUFBLENBQUssTUFBTSxFQUFYLElBQVUsQ0FBQztFQUNwQjs7RUFFQTtBQUNGO0FBQ0E7QUFDQTtBQUNBO0VBQ0UsTUFBTSxVQUFVLENBQUEsRUFBb0I7SUFDbEMsTUFBTSxPQUFPLEdBQUcsSUFBSSxHQUFHLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDO0lBRTlDLE1BQU0sS0FBSyxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNsQyxNQUFNO01BQUU7SUFBVSxDQUFDLEdBQUcsTUFBTSxJQUFJLENBQUMsNkJBQTZCLENBQUMsQ0FBQztJQUNoRSxNQUFNLFdBQVcsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLGdCQUFnQixDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBRWxFLE9BQU8sQ0FBQyxZQUFZLENBQUMsR0FBRyxDQUFDLFdBQVcsRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLGFBQWEsQ0FBQztJQUNqRSxPQUFPLENBQUMsWUFBWSxDQUFDLEdBQUcsQ0FBQyxlQUFlLEVBQUUsTUFBTSxDQUFDO0lBQ2pELE9BQU8sQ0FBQyxZQUFZLENBQUMsR0FBRyxDQUFDLE9BQU8sRUFBRSxxQkFBQSxDQUFLLE1BQU0sRUFBWCxJQUFVLENBQUMsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDeEQsT0FBTyxDQUFDLFlBQVksQ0FBQyxHQUFHLENBQ3RCLHVCQUF1QixFQUN2QixJQUFJLENBQUMscUJBQ1AsQ0FBQztJQUNELE9BQU8sQ0FBQyxZQUFZLENBQUMsR0FBRyxDQUFDLGdCQUFnQixFQUFFLFNBQVMsQ0FBQztJQUNyRCxPQUFPLENBQUMsWUFBWSxDQUFDLEdBQUcsQ0FDdEIsT0FBTyxFQUNQLElBQUksQ0FBQyxTQUFTLENBQUM7TUFDYjtJQUNGLENBQUMsQ0FDSCxDQUFDO0lBQ0QsT0FBTyxDQUFDLFlBQVksQ0FBQyxHQUFHLENBQUMsY0FBYyxFQUFFLFdBQVcsQ0FBQztJQUNyRCxPQUFPLENBQUMsWUFBWSxDQUFDLEdBQUcsQ0FBQyxRQUFRLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQztJQUUvQyxPQUFPLE9BQU8sQ0FBQyxRQUFRLENBQUMsQ0FBQztFQUMzQjs7RUFFQTtBQUNGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7RUFDRSxNQUFNLGNBQWMsQ0FBQyxJQUFZLEVBQThCO0lBQzdELE1BQU0sV0FBVyxHQUFHLElBQUksQ0FBQyw0QkFBNEIsQ0FBQyxJQUFJLENBQUM7SUFDM0QsTUFBTSxHQUFHLEdBQUcsTUFBTSxJQUFJLENBQUMsZ0JBQWdCLENBQUMsV0FBVyxDQUFDO0lBQ3BELE9BQU8sR0FBRztFQUNaOztFQUVBO0FBQ0Y7QUFDQTtBQUNBO0FBQ0E7QUFDQTtFQUNFLDRCQUE0QixDQUFDLElBQVksRUFBVTtJQUNqRCxNQUFNO01BQUU7SUFBZ0IsQ0FBQyxHQUFHLElBQUksQ0FBQyxPQUFPO0lBQ3hDLE1BQU0sV0FBVyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsZ0JBQWdCLENBQUMsY0FBYyxDQUFDLENBQUM7SUFFbEUsTUFBTSxXQUFXLEdBQUc7TUFDbEIsSUFBSTtNQUNKO01BQ0E7TUFDQSxTQUFTLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxhQUFhO01BQ3JDO01BQ0E7TUFDQSxZQUFZLEVBQUUsV0FBVztNQUN6QjtNQUNBO01BQ0EsY0FBYyxFQUFFLElBQUksQ0FBQyxjQUFjO01BQ25DLE9BQU8sRUFBRSxlQUFlO01BQ3hCO01BQ0E7TUFDQSxhQUFhLEVBQUUsSUFBSSxDQUFDLFlBQVk7TUFDaEM7TUFDQTtNQUNBLFdBQVcsRUFBRTtJQUNmLENBQUM7SUFFRCxPQUFPLElBQUksQ0FBQyxTQUFTLENBQUMsV0FBVyxDQUFDO0VBQ3BDOztFQUVBO0FBQ0Y7QUFDQTtBQUNBO0FBQ0E7QUFDQTtFQUNFLE1BQU0sV0FBVyxDQUFDLE9BQWUsRUFBMEI7SUFDekQsTUFBTSxXQUFXLEdBQUcsSUFBQSxvQkFBYSxFQUFDLE9BQU8sQ0FBQztJQUMxQyxNQUFNLE9BQU8sR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQztJQUN2QyxPQUFPO01BQ0wsS0FBSyxFQUFFLE9BQU8sQ0FBQyxLQUFLO01BQ3BCLEdBQUcsRUFBRSxPQUFPLENBQUM7SUFDZixDQUFDO0VBQ0g7QUFDRjtBQUFDLE9BQUEsQ0FBQSxrQkFBQSxHQUFBLGtCQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ2hIRCxJQUFBLDZCQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsU0FBQSxHQUFBLHNCQUFBLENBQUEsT0FBQTtBQUNBLElBQUEsTUFBQSxHQUFBLE9BQUE7QUFDQSxJQUFBLGVBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQUVBLElBQUEsbUJBQUEsR0FBQSxPQUFBO0FBQ0EsSUFBQSxNQUFBLEdBQUEsT0FBQTtBQVlBLElBQUEsT0FBQSxHQUFBLE9BQUE7QUFBMkMsU0FBQSx1QkFBQSxDQUFBLFdBQUEsQ0FBQSxJQUFBLENBQUEsQ0FBQSxVQUFBLEdBQUEsQ0FBQSxLQUFBLE9BQUEsRUFBQSxDQUFBO0FBQUEsU0FBQSw0QkFBQSxDQUFBLEVBQUEsQ0FBQSxJQUFBLDBCQUFBLENBQUEsQ0FBQSxFQUFBLENBQUEsR0FBQSxDQUFBLENBQUEsR0FBQSxDQUFBLENBQUE7QUFBQSxTQUFBLDJCQUFBLENBQUEsRUFBQSxDQUFBLEVBQUEsQ0FBQSxJQUFBLDBCQUFBLENBQUEsQ0FBQSxFQUFBLENBQUEsR0FBQSxDQUFBLENBQUEsR0FBQSxDQUFBLENBQUEsRUFBQSxDQUFBO0FBQUEsU0FBQSwyQkFBQSxDQUFBLEVBQUEsQ0FBQSxRQUFBLENBQUEsQ0FBQSxHQUFBLENBQUEsQ0FBQSxhQUFBLFNBQUE7QUFBQSxTQUFBLGdCQUFBLENBQUEsRUFBQSxDQUFBLEVBQUEsQ0FBQSxZQUFBLENBQUEsR0FBQSxjQUFBLENBQUEsQ0FBQSxNQUFBLENBQUEsR0FBQSxNQUFBLENBQUEsY0FBQSxDQUFBLENBQUEsRUFBQSxDQUFBLElBQUEsS0FBQSxFQUFBLENBQUEsRUFBQSxVQUFBLE1BQUEsWUFBQSxNQUFBLFFBQUEsVUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBLENBQUEsRUFBQSxDQUFBO0FBQUEsU0FBQSxlQUFBLENBQUEsUUFBQSxDQUFBLEdBQUEsWUFBQSxDQUFBLENBQUEsdUNBQUEsQ0FBQSxHQUFBLENBQUEsR0FBQSxDQUFBO0FBQUEsU0FBQSxhQUFBLENBQUEsRUFBQSxDQUFBLDJCQUFBLENBQUEsS0FBQSxDQUFBLFNBQUEsQ0FBQSxNQUFBLENBQUEsR0FBQSxDQUFBLENBQUEsTUFBQSxDQUFBLFdBQUEsa0JBQUEsQ0FBQSxRQUFBLENBQUEsR0FBQSxDQUFBLENBQUEsSUFBQSxDQUFBLENBQUEsRUFBQSxDQUFBLHVDQUFBLENBQUEsU0FBQSxDQUFBLFlBQUEsU0FBQSx5RUFBQSxDQUFBLEdBQUEsTUFBQSxHQUFBLE1BQUEsRUFBQSxDQUFBO0FBQUEsU0FBQSxzQkFBQSxDQUFBLEVBQUEsQ0FBQSxXQUFBLENBQUEsQ0FBQSxHQUFBLENBQUEsaUJBQUEsQ0FBQSxDQUFBLEVBQUEsQ0FBQTtBQUFBLFNBQUEsc0JBQUEsQ0FBQSxFQUFBLENBQUEsRUFBQSxDQUFBLFdBQUEsQ0FBQSxDQUFBLEdBQUEsQ0FBQSxpQkFBQSxDQUFBLENBQUEsRUFBQSxDQUFBLEdBQUEsQ0FBQSxHQUFBLENBQUE7QUFBQSxTQUFBLGtCQUFBLENBQUEsRUFBQSxDQUFBLEVBQUEsQ0FBQSw2QkFBQSxDQUFBLEdBQUEsQ0FBQSxLQUFBLENBQUEsR0FBQSxDQUFBLENBQUEsR0FBQSxDQUFBLENBQUEsVUFBQSxTQUFBLENBQUEsTUFBQSxPQUFBLENBQUEsR0FBQSxDQUFBLFlBQUEsU0FBQTtBQUUzQyxNQUFNLHdDQUF3QyxHQUM1Qyx1Q0FBdUM7QUFBQyxJQUFBLFVBQUEsb0JBQUEsT0FBQTtBQUFBLElBQUEsSUFBQSxvQkFBQSxPQUFBO0FBQUEsSUFBQSxpQkFBQSxvQkFBQSxPQUFBO0FBQUEsSUFBQSxjQUFBLG9CQUFBLE9BQUE7QUFBQSxJQUFBLGlCQUFBLG9CQUFBLE9BQUE7QUFBQSxJQUFBLG1CQUFBLG9CQUFBLE9BQUE7QUFFM0IsTUFBTSxZQUFZLENBQUM7RUFzQmhDLFdBQVcsQ0FBQztJQUNWLFNBQVM7SUFDVCxHQUFHO0lBQ0gsZ0JBQWdCO0lBQ2hCLGFBQWE7SUFDYjtFQUNtQixDQUFDLEVBQUU7SUEwSHhCO0FBQ0Y7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7SUFWRSwyQkFBQSxPQUFBLG1CQUFBO0lBckpBO0lBQUEsZUFBQSxlQUNvQixtQkFBWTtJQUFBLGVBQUEsZ0JBRXhCLElBQUk7SUFFWiwwQkFBQSxPQUFBLFVBQVU7SUFRViwwQkFBQSxPQUFBLElBQUk7SUFFSiwwQkFBQSxPQUFBLGlCQUFpQjtJQUVqQiwwQkFBQSxPQUFBLGNBQWM7SUFFZCwwQkFBQSxPQUFBLGlCQUFpQjtJQVNmLHFCQUFBLENBQUssVUFBVSxFQUFmLElBQUksRUFBYyxTQUFKLENBQUM7SUFFZixNQUFNLFdBQVcsR0FBRyxJQUFBLHVCQUFlLEVBQUMsQ0FBQztJQUNyQyxxQkFBQSxDQUFLLElBQUksRUFBVCxJQUFJLEVBQVE7TUFDVixHQUFHLEdBQUc7TUFDTixHQUFHO0lBQ0wsQ0FIUSxDQUFDO0lBSVQscUJBQUEsQ0FBSyxpQkFBaUIsRUFBdEIsSUFBSSxFQUFxQixnQkFBSixDQUFDO0lBQ3RCLHFCQUFBLENBQUssY0FBYyxFQUFuQixJQUFJLEVBQWtCLGFBQUosQ0FBQztJQUNuQixxQkFBQSxDQUFLLGlCQUFpQixFQUF0QixJQUFJLEVBQXFCLGdCQUFKLENBQUM7SUFFdEIscUJBQUEsQ0FBSyxVQUFVLEVBQWYsSUFBYyxDQUFDLENBQUMscUJBQXFCLENBQ25DLEdBQUcsbUJBQVksa0JBQWtCLEVBQ2pDLElBQUksQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLElBQUksQ0FDaEMsQ0FBQztJQUVELHFCQUFBLENBQUssVUFBVSxFQUFmLElBQWMsQ0FBQyxDQUFDLHFCQUFxQixDQUNuQyxHQUFHLG1CQUFZLHFCQUFxQixFQUNwQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLElBQUksQ0FDbkMsQ0FBQztJQUVELHFCQUFBLENBQUssVUFBVSxFQUFmLElBQWMsQ0FBQyxDQUFDLHFCQUFxQixDQUNuQyxHQUFHLG1CQUFZLHFCQUFxQixFQUNwQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLElBQUksQ0FDbkMsQ0FBQztJQUVELHFCQUFBLENBQUssVUFBVSxFQUFmLElBQWMsQ0FBQyxDQUFDLHFCQUFxQixDQUNuQyxHQUFHLG1CQUFZLG9CQUFvQixFQUNuQyxJQUFJLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLElBQUksQ0FDbEMsQ0FBQztFQUNIOztFQUVBO0FBQ0Y7QUFDQTtBQUNBO0FBQ0E7QUFDQTtFQUNFLE1BQU0sZUFBZSxDQUNuQixjQUE4QixFQUNIO0lBQzNCO0lBQ0E7SUFDQSxNQUFNLFlBQVksR0FBRyxJQUFBLHNDQUFrQixFQUNyQyxjQUFjLEVBQ2QscUJBQUEsQ0FBSyxJQUFJLEVBQVQsSUFBUSxDQUFDLEVBQ1QscUJBQUEsQ0FBSyxpQkFBaUIsRUFBdEIsSUFBcUIsQ0FDdkIsQ0FBQztJQUVELE9BQU8saUJBQUEsQ0FBQSxtQkFBQSxNQUFJLEVBQUMsaUJBQWdCLENBQUMsQ0FBQSxJQUFBLENBQXRCLElBQUksRUFBbUIsWUFBWTtFQUM1Qzs7RUFFQTtBQUNGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0VBQ0UsTUFBTSxrQkFBa0IsQ0FBQyxPQUd4QixFQUFvQztJQUNuQyxNQUFNO01BQUUsVUFBVTtNQUFFO0lBQWEsQ0FBQyxHQUFHLE9BQU87SUFDNUMsTUFBTSxZQUFZLEdBQUcsSUFBQSxzQ0FBa0IsRUFDckMsVUFBVSxFQUNWLHFCQUFBLENBQUssSUFBSSxFQUFULElBQVEsQ0FBQyxFQUNULHFCQUFBLENBQUssaUJBQWlCLEVBQXRCLElBQXFCLENBQ3ZCLENBQUM7SUFFRCxNQUFNLGdCQUFnQixHQUFHLE1BQU0sWUFBWSxDQUFDLGdCQUFnQixDQUFDLFlBQVksQ0FBQztJQUMxRSxNQUFNLE9BQU8sR0FBRyxnQkFBZ0IsQ0FBQyxRQUFRO0lBRXpDLE9BQU87TUFDTCxRQUFRLEVBQUUsQ0FBQyxPQUFPLENBQUM7TUFDbkIsV0FBVyxFQUFFLGdCQUFnQixDQUFDLFlBQVk7TUFDMUMsbUJBQW1CLEVBQUUsZ0JBQWdCLENBQUM7SUFDeEMsQ0FBQztFQUNIOztFQUVBO0FBQ0Y7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7RUFDRSxNQUFNLGlCQUFpQixDQUFDLE9BR3ZCLEVBQWdFO0lBQy9ELE1BQU07TUFBRSxVQUFVO01BQUU7SUFBWSxDQUFDLEdBQUcsT0FBTztJQUMzQyxNQUFNLFlBQVksR0FBRyxJQUFBLHNDQUFrQixFQUNyQyxVQUFVLEVBQ1YscUJBQUEsQ0FBSyxJQUFJLEVBQVQsSUFBUSxDQUFDLEVBQ1QscUJBQUEsQ0FBSyxpQkFBaUIsRUFBdEIsSUFBcUIsQ0FDdkIsQ0FBQztJQUVELE1BQU0sR0FBRyxHQUFHLE1BQU0sWUFBWSxDQUFDLGlCQUFpQixDQUFDLFdBQVcsQ0FBQztJQUM3RCxPQUFPO01BQ0wsZUFBZSxFQUFFLEdBQUcsQ0FBQyxhQUFhO01BQ2xDLGNBQWMsRUFBRSxHQUFHLENBQUM7SUFDdEIsQ0FBQztFQUNIO0VBRUEsTUFBTSxrQkFBa0IsQ0FBQyxPQUd4QixFQUFpQjtJQUNoQixNQUFNO01BQUUsVUFBVTtNQUFFO0lBQVksQ0FBQyxHQUFHLE9BQU87SUFDM0MsTUFBTSxZQUFZLEdBQUcsSUFBQSxzQ0FBa0IsRUFDckMsVUFBVSxFQUNWLHFCQUFBLENBQUssSUFBSSxFQUFULElBQVEsQ0FBQyxFQUNULHFCQUFBLENBQUssaUJBQWlCLEVBQXRCLElBQXFCLENBQ3ZCLENBQUM7SUFFRCxNQUFNLFlBQVksQ0FBQyxrQkFBa0IsQ0FBQyxXQUFXLENBQUM7RUFDcEQ7RUF1TUEsTUFBTSxtQkFBbUIsQ0FDdkIsd0JBQWlDLEVBQ2Y7SUFDbEIsTUFBTSxLQUFLLEdBQUcscUJBQUEsQ0FBSyxVQUFVLEVBQWYsSUFBYyxDQUFDLENBQUMsSUFBSSxDQUFDLHVDQUF1QyxDQUFDO0lBQzNFLE1BQU07TUFBRTtJQUFZLENBQUMsR0FBRyxLQUFLO0lBQzdCLElBQUksQ0FBQyxXQUFXLEVBQUU7TUFDaEIsTUFBTSxJQUFJLEtBQUssQ0FBQyx1QkFBdUIsQ0FBQztJQUMxQztJQUVBLE1BQU0sV0FBVyxHQUFHO01BQ2xCO01BQ0E7TUFDQSxhQUFhLEVBQUU7SUFDakIsQ0FBQztJQUVELE1BQU0sR0FBRyxHQUFHLE1BQU0sS0FBSyxDQUNyQixHQUFHLHFCQUFBLENBQUssSUFBSSxFQUFULElBQVEsQ0FBQyxDQUFDLGFBQWEsR0FBRyx3Q0FBd0MsRUFBRSxFQUN2RTtNQUNFLE1BQU0sRUFBRSxNQUFNO01BQ2QsT0FBTyxFQUFFO1FBQ1AsY0FBYyxFQUFFLGtCQUFrQjtRQUNsQyxhQUFhLEVBQUUsVUFBVSxXQUFXO01BQ3RDLENBQUM7TUFDRCxJQUFJLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxXQUFXO0lBQ2xDLENBQ0YsQ0FBQztJQUVELElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxFQUFFO01BQ1gsTUFBTSxJQUFJLEtBQUssQ0FBQyx3Q0FBd0MsQ0FBQztJQUMzRDtJQUVBLE9BQU8sR0FBRyxDQUFDLEVBQUU7RUFDZjtFQUVBLE1BQU0sbUJBQW1CLENBQUEsRUFBcUI7SUFDNUMsSUFBSTtNQUNGLE1BQU0sS0FBSyxHQUFHLHFCQUFBLENBQUssVUFBVSxFQUFmLElBQWMsQ0FBQyxDQUFDLElBQUksQ0FDaEMsdUNBQ0YsQ0FBQztNQUNELE1BQU07UUFBRTtNQUFZLENBQUMsR0FBRyxLQUFLO01BQzdCLElBQUksQ0FBQyxXQUFXLEVBQUU7UUFDaEIsTUFBTSxJQUFJLEtBQUssQ0FBQyx1QkFBdUIsQ0FBQztNQUMxQztNQUVBLE1BQU0sR0FBRyxHQUFHLE1BQU0sS0FBSyxDQUNyQixHQUFHLHFCQUFBLENBQUssSUFBSSxFQUFULElBQVEsQ0FBQyxDQUFDLGFBQWEsR0FBRyx3Q0FBd0MsRUFBRSxFQUN2RTtRQUNFLE1BQU0sRUFBRSxLQUFLO1FBQ2IsT0FBTyxFQUFFO1VBQ1AsY0FBYyxFQUFFLGtCQUFrQjtVQUNsQyxhQUFhLEVBQUUsVUFBVSxXQUFXO1FBQ3RDO01BQ0YsQ0FDRixDQUFDO01BRUQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLEVBQUU7UUFDWCxNQUFNLElBQUksS0FBSyxDQUFDLHVDQUF1QyxDQUFDO01BQzFEO01BRUEsTUFBTSxJQUFJLEdBQUcsTUFBTSxHQUFHLENBQUMsSUFBSSxDQUFDLENBQUM7TUFFN0IsT0FBTyxPQUFPLENBQUMsQ0FBQSxJQUFJLGFBQUosSUFBSSx1QkFBSixJQUFJLENBQUUsU0FBUyxLQUFJLEtBQUssQ0FBQztJQUMxQyxDQUFDLENBQUMsT0FBTyxLQUFLLEVBQUU7TUFDZCxpQkFBRyxDQUFDLEtBQUssQ0FBQyx1Q0FBdUMsRUFBRSxLQUFLLENBQUM7TUFDekQsT0FBTyxLQUFLO0lBQ2Q7RUFDRjtBQUNGO0FBQUMsT0FBQSxDQUFBLE9BQUEsR0FBQSxZQUFBO0FBQUEsZUFBQSxrQkE3UHlCLFlBQThCLEVBQUU7RUFDdEQsTUFBTSxPQUFPLEdBQUcsTUFBTSxZQUFZLENBQUMsVUFBVSxDQUFDLENBQUM7RUFFL0MsSUFBSSxvQkFBb0IsR0FBRyxLQUFLO0VBQ2hDLElBQUksb0JBQW9CLEdBQUcsSUFBSTtFQUMvQixJQUFJO0lBQUEsSUFBQSxzQkFBQTtJQUNGLENBQUEsc0JBQUEsR0FBQSxxQkFBQSxDQUFLLGNBQWMsRUFBbkIsSUFBa0IsQ0FBQyxjQUFBLHNCQUFBLGVBQUEsc0JBQUEsQ0FBQSxJQUFBLENBQW5CLElBQUksRUFBa0I7TUFDcEIsSUFBSSxFQUFFLGdCQUFTLENBQUMsNEJBQTRCO01BQzVDLEVBQUUsRUFBRSxxQkFBYyxDQUFDO0lBQ3JCLENBQUM7SUFDRDtJQUNBLG9CQUFvQixHQUFHLE1BQU0sSUFBSSxPQUFPLENBQVMsQ0FBQyxPQUFPLEVBQUUsTUFBTSxLQUFLO01BQ3BFO01BQ0EscUJBQUEsQ0FBSyxpQkFBaUIsRUFBdEIsSUFBcUIsQ0FBQyxDQUFDLGlCQUFpQixDQUN0QztRQUNFLFdBQVcsRUFBRSxJQUFJO1FBQ2pCLEdBQUcsRUFBRTtNQUNQLENBQUMsRUFDQSxXQUFXLElBQUs7UUFDZixJQUFJO1VBQ0YsSUFBSSxXQUFXLEVBQUU7WUFDZixJQUFJO2NBQ0YsWUFBWSxDQUFDLGFBQWEsQ0FBQyxXQUFXLENBQUM7Y0FDdkMsT0FBTyxDQUFDLFdBQVcsQ0FBQztZQUN0QixDQUFDLENBQUMsT0FBTyxLQUFLLEVBQUU7Y0FDZCxNQUFNLENBQUMsS0FBSyxDQUFDO1lBQ2Y7VUFDRixDQUFDLE1BQU07WUFDTCxJQUFJLGlCQUFBLENBQUEsbUJBQUEsTUFBSSxFQUFDLDBCQUF5QixDQUFDLENBQUEsSUFBQSxDQUEvQixJQUFJLEdBQStCO2NBQ3JDLE1BQU0sQ0FDSixJQUFJLEtBQUssQ0FBQyx5QkFBa0IsQ0FBQywwQkFBMEIsQ0FDekQsQ0FBQztjQUNEO1lBQ0Y7WUFDQSxNQUFNLENBQ0osSUFBSSxLQUFLLENBQUMseUJBQWtCLENBQUMsMkJBQTJCLENBQzFELENBQUM7VUFDSDtRQUNGLENBQUMsQ0FBQyxPQUFPLEtBQWMsRUFBRTtVQUN2QixNQUFNLENBQUMsS0FBSyxDQUFDO1FBQ2Y7TUFDRixDQUNGLENBQUM7SUFDSCxDQUFDLENBQUM7SUFDRixvQkFBb0IsR0FBRyxJQUFJO0VBQzdCLENBQUMsQ0FBQyxPQUFPLEtBQWMsRUFBRTtJQUFBLElBQUEsc0JBQUEsRUFBQSxzQkFBQTtJQUN2QixNQUFNLFlBQVksR0FDaEIsS0FBSyxZQUFZLEtBQUssR0FBRyxLQUFLLENBQUMsT0FBTyxHQUFHLGVBQWU7SUFFMUQsQ0FBQSxzQkFBQSxHQUFBLHFCQUFBLENBQUssY0FBYyxFQUFuQixJQUFrQixDQUFDLGNBQUEsc0JBQUEsZUFBQSxzQkFBQSxDQUFBLElBQUEsQ0FBbkIsSUFBSSxFQUFrQjtNQUNwQixJQUFJLEVBQUUsZ0JBQVMsQ0FBQyxpQ0FBaUM7TUFDakQsRUFBRSxFQUFFLHFCQUFjLENBQUMsZUFBZTtNQUNsQyxJQUFJLEVBQUU7UUFBRTtNQUFhO0lBQ3ZCLENBQUM7SUFDRCxDQUFBLHNCQUFBLEdBQUEscUJBQUEsQ0FBSyxpQkFBaUIsRUFBdEIsSUFBcUIsQ0FBQyxjQUFBLHNCQUFBLGVBQUEsc0JBQUEsQ0FBQSxJQUFBLENBQXRCLElBQUksRUFBcUI7TUFDdkIsSUFBSSxFQUFFLGdCQUFTLENBQUM7SUFDbEIsQ0FBQztJQUVELE1BQU0sS0FBSztFQUNiLENBQUMsU0FBUztJQUFBLElBQUEsc0JBQUE7SUFDUixDQUFBLHNCQUFBLEdBQUEscUJBQUEsQ0FBSyxpQkFBaUIsRUFBdEIsSUFBcUIsQ0FBQyxjQUFBLHNCQUFBLGVBQUEsc0JBQUEsQ0FBQSxJQUFBLENBQXRCLElBQUksRUFBcUI7TUFDdkIsSUFBSSxFQUFFLGdCQUFTLENBQUMsNEJBQTRCO01BQzVDLElBQUksRUFBRTtRQUFFLE9BQU8sRUFBRTtNQUFxQjtJQUN4QyxDQUFDO0VBQ0g7RUFFQSxJQUFJLG9CQUFvQixHQUFHLEtBQUs7RUFDaEMsSUFBSTtJQUFBLElBQUEsc0JBQUE7SUFDRixDQUFBLHNCQUFBLEdBQUEscUJBQUEsQ0FBSyxjQUFjLEVBQW5CLElBQWtCLENBQUMsY0FBQSxzQkFBQSxlQUFBLHNCQUFBLENBQUEsSUFBQSxDQUFuQixJQUFJLEVBQWtCO01BQ3BCLElBQUksRUFBRSxnQkFBUyxDQUFDLHNDQUFzQztNQUN0RCxFQUFFLEVBQUUscUJBQWMsQ0FBQztJQUNyQixDQUFDO0lBQ0Q7SUFDQSxNQUFNLFdBQVcsR0FBRyxNQUFNLGlCQUFBLENBQUEsbUJBQUEsTUFBSSxFQUFDLG9CQUFtQixDQUFDLENBQUEsSUFBQSxDQUF6QixJQUFJLEVBQzVCLFlBQVksRUFDWixvQkFBb0IsQ0FDckI7SUFDRCxvQkFBb0IsR0FBRyxJQUFJO0lBQzNCLE9BQU8sV0FBVztFQUNwQixDQUFDLENBQUMsT0FBTyxLQUFjLEVBQUU7SUFBQSxJQUFBLHNCQUFBLEVBQUEsc0JBQUE7SUFDdkIsTUFBTSxZQUFZLEdBQ2hCLEtBQUssWUFBWSxLQUFLLEdBQUcsS0FBSyxDQUFDLE9BQU8sR0FBRyxlQUFlO0lBRTFELENBQUEsc0JBQUEsR0FBQSxxQkFBQSxDQUFLLGNBQWMsRUFBbkIsSUFBa0IsQ0FBQyxjQUFBLHNCQUFBLGVBQUEsc0JBQUEsQ0FBQSxJQUFBLENBQW5CLElBQUksRUFBa0I7TUFDcEIsSUFBSSxFQUFFLGdCQUFTLENBQUMsMkNBQTJDO01BQzNELEVBQUUsRUFBRSxxQkFBYyxDQUFDLGVBQWU7TUFDbEMsSUFBSSxFQUFFO1FBQUU7TUFBYTtJQUN2QixDQUFDO0lBQ0QsQ0FBQSxzQkFBQSxHQUFBLHFCQUFBLENBQUssaUJBQWlCLEVBQXRCLElBQXFCLENBQUMsY0FBQSxzQkFBQSxlQUFBLHNCQUFBLENBQUEsSUFBQSxDQUF0QixJQUFJLEVBQXFCO01BQ3ZCLElBQUksRUFBRSxnQkFBUyxDQUFDO0lBQ2xCLENBQUM7SUFFRCxNQUFNLEtBQUs7RUFDYixDQUFDLFNBQVM7SUFBQSxJQUFBLHNCQUFBO0lBQ1IsQ0FBQSxzQkFBQSxHQUFBLHFCQUFBLENBQUssaUJBQWlCLEVBQXRCLElBQXFCLENBQUMsY0FBQSxzQkFBQSxlQUFBLHNCQUFBLENBQUEsSUFBQSxDQUF0QixJQUFJLEVBQXFCO01BQ3ZCLElBQUksRUFBRSxnQkFBUyxDQUFDLHNDQUFzQztNQUN0RCxJQUFJLEVBQUU7UUFBRSxPQUFPLEVBQUU7TUFBcUI7SUFDeEMsQ0FBQztFQUNIO0FBQ0Y7QUFFQTtBQUNGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBVkUsZUFBQSxxQkFZRSxZQUE4QixFQUM5QixXQUFtQixFQUNRO0VBQzNCLE1BQU07SUFBRTtFQUFlLENBQUMsR0FBRyxZQUFZOztFQUV2QztFQUNBO0VBQ0EsTUFBTSxRQUFRLEdBQ1osY0FBYyxLQUFLLDRDQUFjLENBQUMsTUFBTSxHQUNwQyxpQkFBQSxDQUFBLG1CQUFBLE1BQUksRUFBQyx1QkFBc0IsQ0FBQyxDQUFBLElBQUEsQ0FBNUIsSUFBSSxFQUF5QixXQUFXLElBQ3hDLElBQUk7RUFFVixNQUFNLEdBQUcsR0FBRyxNQUFNLGlCQUFBLENBQUEsbUJBQUEsTUFBSSxFQUFDLGVBQWMsQ0FBQyxDQUFBLElBQUEsQ0FBcEIsSUFBSSxFQUFpQixZQUFZLEVBQUUsUUFBUSxDQUFDO0VBQzlELE9BQU8sR0FBRztBQUNaO0FBRUE7QUFDRjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFORSxlQUFBLGdCQVFFLFlBQThCLEVBQzlCLFFBQXVCLEVBQ0k7RUFDM0IsSUFBSSxnQkFBZ0IsR0FBRyxFQUFFO0VBQ3pCLElBQUksdUJBQXVCLEdBQUcsRUFBRTtFQUVoQyxJQUFJLE9BQU8sQ0FBQyxHQUFHLENBQUMsT0FBTyxFQUFFO0lBQ3ZCLE1BQU07TUFBRSx1QkFBdUI7TUFBRTtJQUFnQyxDQUFDO0lBQ2hFO0lBQ0E7SUFDQSxPQUFPLENBQUMsZ0NBQWdDLENBQUM7SUFDM0MsZ0JBQWdCLEdBQUcsdUJBQXVCO0lBQzFDLHVCQUF1QixHQUFHLCtCQUErQjtFQUMzRCxDQUFDLE1BQU0sSUFBSSxZQUFZLENBQUMsY0FBYyxLQUFLLDRDQUFjLENBQUMsTUFBTSxFQUFFO0lBQ2hFLGdCQUFnQixHQUFHLHFCQUFBLENBQUssSUFBSSxFQUFULElBQVEsQ0FBQyxDQUFDLHNCQUFzQjtJQUNuRCx1QkFBdUIsR0FBRyxxQkFBQSxDQUFLLElBQUksRUFBVCxJQUFRLENBQUMsQ0FBQyw2QkFBNkI7RUFDbkUsQ0FBQyxNQUFNLElBQUksWUFBWSxDQUFDLGNBQWMsS0FBSyw0Q0FBYyxDQUFDLEtBQUssRUFBRTtJQUMvRCxnQkFBZ0IsR0FBRyxxQkFBQSxDQUFLLElBQUksRUFBVCxJQUFRLENBQUMsQ0FBQyxxQkFBcUI7SUFDbEQsdUJBQXVCLEdBQUcscUJBQUEsQ0FBSyxJQUFJLEVBQVQsSUFBUSxDQUFDLENBQUMsNEJBQTRCO0VBQ2xFO0VBRUEsTUFBTSxhQUFhLEdBQUcsTUFBTSxZQUFZLENBQUMsY0FBYyxDQUFDLFFBQVEsQ0FBQztFQUNqRSxNQUFNLE9BQU8sR0FBRyxhQUFhLENBQUMsUUFBUTtFQUN0QyxNQUFNLFFBQVEsR0FBRyxNQUFNLFlBQVksQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDO0VBRXhELE9BQU87SUFDTCxnQkFBZ0I7SUFDaEIsdUJBQXVCO0lBQ3ZCLE1BQU0sRUFBRSxRQUFRLENBQUMsR0FBRyxJQUFJLFFBQVEsQ0FBQyxLQUFLO0lBQ3RDLFFBQVEsRUFBRSxDQUFDLE9BQU8sQ0FBQztJQUNuQixjQUFjLEVBQUUsWUFBWSxDQUFDLGNBQWM7SUFDM0MsZ0JBQWdCLEVBQUUsUUFBUSxDQUFDLEtBQUs7SUFDaEMsWUFBWSxFQUFFLGFBQWEsQ0FBQyxhQUFhO0lBQ3pDLFdBQVcsRUFBRSxhQUFhLENBQUMsWUFBWTtJQUN2QyxXQUFXLEVBQUUsYUFBYSxDQUFDLFlBQVk7SUFDdkMsbUJBQW1CLEVBQUUsYUFBYSxDQUFDO0VBQ3JDLENBQUM7QUFDSDtBQUFDLFNBQUEsd0JBRXVCLFdBQW1CLEVBQWlCO0VBQzFELE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLFdBQVcsQ0FBQztFQUNoQyxPQUFPLEdBQUcsQ0FBQyxZQUFZLENBQUMsR0FBRyxDQUFDLE1BQU0sQ0FBQztBQUNyQztBQUFDLFNBQUEsMkJBQUEsRUFFcUM7RUFDcEMsTUFBTSxLQUFLLEdBQUcsSUFBQSxpQ0FBaUIsRUFBQyxDQUFDO0VBQ2pDLE9BQU8sQ0FBQSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsT0FBTyxNQUFLLHlCQUFrQixDQUFDLDBCQUEwQjtBQUN6RTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUMzV0ssTUFBTSxZQUFZLEdBQUEsT0FBQSxDQUFBLFlBQUEsR0FBRyxjQUFjOztBQUkxQztBQUNBO0FBQ0E7O0FBTUE7QUFDQTtBQUNBOztBQVNBO0FBQ0E7QUFDQTs7QUFTQTtBQUNBO0FBQ0E7O0FBU0E7QUFDQTtBQUNBOztBQVFBO0FBQ0E7QUFDQTs7QUFHQTtBQUNBO0FBQ0E7QUFDQTs7QUFrSEE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUEwQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBY0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQU1BO0FBQ0E7QUFDQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ2hSQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxTQUFTLGVBQWUsQ0FBQyxLQUFhLEVBQUU7RUFDN0M7RUFDQSxNQUFNLGFBQWEsR0FBRyxDQUFDO0VBQ3ZCLE1BQU0sWUFBWSxHQUFHLEtBQUssQ0FBQyxNQUFNO0VBQ2pDO0VBQ0EsTUFBTSxpQkFBaUIsR0FBRyxhQUFhLEdBQUksWUFBWSxHQUFHLGFBQWM7RUFDeEUsSUFBSSxpQkFBaUIsS0FBSyxhQUFhLEVBQUU7SUFDdkM7SUFDQTtJQUNBLE9BQU8sS0FBSztFQUNkOztFQUVBO0VBQ0EsTUFBTSxrQkFBa0IsR0FBRyxZQUFZLEdBQUcsaUJBQWlCO0VBQzNELE1BQU0sWUFBWSxHQUFHLEtBQUssQ0FBQyxNQUFNLENBQUMsa0JBQWtCLEVBQUUsR0FBRyxDQUFDO0VBQzFELE9BQU8sWUFBWTtBQUNyQjtBQUVPLFNBQVMsc0NBQXNDLENBQUMsWUFBb0IsRUFBRTtFQUMzRSxPQUFPLFlBQVksQ0FDaEIsT0FBTyxDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsQ0FBQztFQUFBLENBQ3JCLE9BQU8sQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLENBQUM7RUFBQSxDQUNyQixPQUFPLENBQUMsUUFBUSxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUM7QUFDNUI7QUFFTyxTQUFTLHdDQUF3QyxDQUFDLFlBQW9CLEVBQUU7RUFDN0UsT0FBTyxZQUFZLENBQ2hCLE9BQU8sQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLENBQ25CLE9BQU8sQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLENBQ25CLE9BQU8sQ0FBQyxPQUFPLEVBQUUsRUFBRSxDQUFDO0FBQ3pCOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLFNBQVMsZUFBZSxDQUFDLE1BQW1CLEVBQUU7RUFDbkQsSUFBSSxHQUFHLEdBQUcsRUFBRTtFQUNaLE1BQU0sS0FBSyxHQUFHLElBQUksVUFBVSxDQUFDLE1BQU0sQ0FBQztFQUNwQyxLQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsS0FBSyxDQUFDLFVBQVUsRUFBRSxDQUFDLEVBQUUsRUFBRTtJQUN6QyxHQUFHLElBQUksTUFBTSxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUM7RUFDdEM7RUFDQSxPQUFPLHNDQUFzQyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztBQUMxRDs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTyxTQUFTLG1DQUFtQyxDQUFDLFlBQW9CLEVBQUU7RUFDeEU7RUFDQSxNQUFNLG1CQUFtQixHQUN2Qix3Q0FBd0MsQ0FBQyxZQUFZLENBQUM7RUFDeEQsTUFBTSxZQUFZLEdBQUcsSUFBSSxDQUFDLG1CQUFtQixDQUFDO0VBQzlDLE1BQU0sS0FBSyxHQUFHLFVBQVUsQ0FBQyxJQUFJLENBQUMsWUFBWSxFQUFHLENBQUMsSUFBSyxDQUFDLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0VBQ25FLE1BQU0sVUFBVSxHQUFHLElBQUksV0FBVyxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDO0VBQ2xELE9BQU8sVUFBVTtBQUNuQjtBQUVPLFNBQVMsYUFBYSxDQUFDLE9BQWUsRUFBVTtFQUNyRCxNQUFNLEdBQUcsY0FBYyxDQUFDLEdBQUcsT0FBTyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUM7RUFDN0MsTUFBTSxZQUFZLEdBQUcsd0NBQXdDLENBQzNELGVBQWUsQ0FBQyxjQUFjLENBQ2hDLENBQUM7RUFFRCxPQUFPLG1DQUFtQyxDQUFDLFlBQVksQ0FBQztBQUMxRDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDNUVBLElBQUEscUJBQUEsR0FBQSxzQkFBQSxDQUFBLE9BQUE7QUFFQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBQTBDLFNBQUEsdUJBQUEsQ0FBQSxXQUFBLENBQUEsSUFBQSxDQUFBLENBQUEsVUFBQSxHQUFBLENBQUEsS0FBQSxPQUFBLEVBQUEsQ0FBQTtBQUUxQyxlQUFlLGdDQUFnQyxDQUFBLEVBRzVDO0VBQ0QsTUFBTSxLQUFLLEdBQUcsSUFBSSxVQUFVLENBQUMsRUFBRSxDQUFDO0VBQ2hDLE1BQU0sQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDO0VBQzdCLE1BQU0sWUFBWSxHQUFHLElBQUEsc0JBQWUsRUFBQyxLQUFLLENBQUM7RUFFM0MsTUFBTSxlQUFlLEdBQUcsTUFBTSxNQUFNLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FDaEQsU0FBUyxFQUNULElBQUksV0FBVyxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUN2QyxDQUFDO0VBRUQsTUFBTSxTQUFTLEdBQUcsSUFBQSxzQkFBZSxFQUFDLGVBQWUsQ0FBQztFQUVsRCxPQUFPO0lBQ0wsWUFBWTtJQUNaO0VBQ0YsQ0FBQztBQUNIO0FBRUEsU0FBUyxhQUFhLENBQUEsRUFBVztFQUMvQixPQUFPLE1BQU0sQ0FBQyxVQUFVLENBQUMsQ0FBQztBQUM1QjtBQUVPLFNBQVMsY0FBYyxDQUFBLEVBRUY7RUFBQSxJQUFBLE9BQUE7RUFDMUI7RUFDQTtFQUNBO0VBQ0E7RUFDQSxJQUNFLENBQUEsT0FBQSxHQUFBLE1BQU0sY0FBQSxPQUFBLGVBQU4sT0FBQSxDQUFRLFFBQVEsSUFDaEIsZ0JBQWdCLElBQUksTUFBTSxDQUFDLFFBQVEsSUFDbkMsbUJBQW1CLElBQUksTUFBTSxDQUFDLFFBQVEsRUFDdEM7SUFDQSxPQUFPLE1BQU0sQ0FBQyxRQUFRO0VBQ3hCOztFQUVBO0VBQ0EsT0FBTyw2QkFBTyxDQUFDLFFBQVE7QUFDekI7QUFFQSxlQUFlLGlCQUFpQixDQUM5QixPQUdDLEVBQ0QsUUFBd0MsRUFDeEM7RUFDQSxNQUFNLFdBQVcsR0FBRyxjQUFjLENBQUMsQ0FBQztFQUNwQyxPQUFPLFdBQVcsQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsUUFBUSxDQUFDO0FBQ3pEO0FBRUEsU0FBUyxjQUFjLENBQUEsRUFBVztFQUNoQyxNQUFNLFdBQVcsR0FBRyxjQUFjLENBQUMsQ0FBQztFQUNwQyxPQUFPLFdBQVcsQ0FBQyxjQUFjLENBQUMsQ0FBQztBQUNyQztBQUVPLFNBQVMsdUJBQXVCLENBQUEsRUFBcUI7RUFDMUQsSUFBSSxPQUFPLENBQUMsR0FBRyxDQUFDLE9BQU8sRUFBRTtJQUN2QixNQUFNO01BQUU7SUFBcUIsQ0FBQztJQUM1QjtJQUNBO0lBQ0EsT0FBTyxDQUFDLHlFQUF5RSxDQUFDO0lBQ3BGLE9BQU8sb0JBQW9CLENBQUMsQ0FBQztFQUMvQjtFQUVBLE9BQU87SUFDTCxpQkFBaUI7SUFDakIsZ0NBQWdDO0lBQ2hDLGFBQWE7SUFDYjtFQUNGLENBQUM7QUFDSDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUM5RUEsSUFBQSx1QkFBQSxHQUFBLE9BQUE7QUFPQSxJQUFBLE1BQUEsR0FBQSxPQUFBO0FBTWlCLFNBQUEsNEJBQUEsQ0FBQSxFQUFBLENBQUEsSUFBQSwwQkFBQSxDQUFBLENBQUEsRUFBQSxDQUFBLEdBQUEsQ0FBQSxDQUFBLEdBQUEsQ0FBQSxDQUFBO0FBQUEsU0FBQSwyQkFBQSxDQUFBLEVBQUEsQ0FBQSxFQUFBLENBQUEsSUFBQSwwQkFBQSxDQUFBLENBQUEsRUFBQSxDQUFBLEdBQUEsQ0FBQSxDQUFBLEdBQUEsQ0FBQSxDQUFBLEVBQUEsQ0FBQTtBQUFBLFNBQUEsMkJBQUEsQ0FBQSxFQUFBLENBQUEsUUFBQSxDQUFBLENBQUEsR0FBQSxDQUFBLENBQUEsYUFBQSxTQUFBO0FBQUEsU0FBQSxnQkFBQSxDQUFBLEVBQUEsQ0FBQSxFQUFBLENBQUEsWUFBQSxDQUFBLEdBQUEsY0FBQSxDQUFBLENBQUEsTUFBQSxDQUFBLEdBQUEsTUFBQSxDQUFBLGNBQUEsQ0FBQSxDQUFBLEVBQUEsQ0FBQSxJQUFBLEtBQUEsRUFBQSxDQUFBLEVBQUEsVUFBQSxNQUFBLFlBQUEsTUFBQSxRQUFBLFVBQUEsQ0FBQSxDQUFBLENBQUEsSUFBQSxDQUFBLEVBQUEsQ0FBQTtBQUFBLFNBQUEsZUFBQSxDQUFBLFFBQUEsQ0FBQSxHQUFBLFlBQUEsQ0FBQSxDQUFBLHVDQUFBLENBQUEsR0FBQSxDQUFBLEdBQUEsQ0FBQTtBQUFBLFNBQUEsYUFBQSxDQUFBLEVBQUEsQ0FBQSwyQkFBQSxDQUFBLEtBQUEsQ0FBQSxTQUFBLENBQUEsTUFBQSxDQUFBLEdBQUEsQ0FBQSxDQUFBLE1BQUEsQ0FBQSxXQUFBLGtCQUFBLENBQUEsUUFBQSxDQUFBLEdBQUEsQ0FBQSxDQUFBLElBQUEsQ0FBQSxDQUFBLEVBQUEsQ0FBQSx1Q0FBQSxDQUFBLFNBQUEsQ0FBQSxZQUFBLFNBQUEseUVBQUEsQ0FBQSxHQUFBLE1BQUEsR0FBQSxNQUFBLEVBQUEsQ0FBQTtBQUFBLFNBQUEsc0JBQUEsQ0FBQSxFQUFBLENBQUEsV0FBQSxDQUFBLENBQUEsR0FBQSxDQUFBLGlCQUFBLENBQUEsQ0FBQSxFQUFBLENBQUE7QUFBQSxTQUFBLHNCQUFBLENBQUEsRUFBQSxDQUFBLEVBQUEsQ0FBQSxXQUFBLENBQUEsQ0FBQSxHQUFBLENBQUEsaUJBQUEsQ0FBQSxDQUFBLEVBQUEsQ0FBQSxHQUFBLENBQUEsR0FBQSxDQUFBO0FBQUEsU0FBQSxrQkFBQSxDQUFBLEVBQUEsQ0FBQSxFQUFBLENBQUEsNkJBQUEsQ0FBQSxHQUFBLENBQUEsS0FBQSxDQUFBLEdBQUEsQ0FBQSxDQUFBLEdBQUEsQ0FBQSxDQUFBLFVBQUEsU0FBQSxDQUFBLE1BQUEsT0FBQSxDQUFBLEdBQUEsQ0FBQSxZQUFBLFNBQUE7QUFBQSxJQUFBLFVBQUEsb0JBQUEsT0FBQTtBQUFBLElBQUEsU0FBQSxvQkFBQSxPQUFBO0FBQUEsSUFBQSxpQkFBQSxvQkFBQSxPQUFBO0FBQUEsSUFBQSwwQkFBQSxvQkFBQSxPQUFBO0FBRVYsTUFBTSxtQkFBbUIsQ0FBQztFQWtCL0IsV0FBVyxDQUFDO0lBQ1YsU0FBUztJQUNULFFBQVE7SUFDUjtFQUMwQixDQUFDLEVBQUU7SUFBQSwyQkFBQSxPQUFBLDBCQUFBO0lBckIvQjtJQUFBLGVBQUEsZUFDb0IsbUJBQVk7SUFBQSxlQUFBLGdCQUV4QixJQUFJO0lBRVosMEJBQUEsT0FBQSxVQUFVO0lBUVYsMEJBQUEsT0FBQSxTQUFTO0lBRVQsMEJBQUEsT0FBQSxpQkFBaUI7SUFPZixxQkFBQSxDQUFLLFVBQVUsRUFBZixJQUFJLEVBQWMsU0FBSixDQUFDO0lBQ2YscUJBQUEsQ0FBSyxTQUFTLEVBQWQsSUFBSSxFQUFhLFFBQUosQ0FBQztJQUNkLHFCQUFBLENBQUssaUJBQWlCLEVBQXRCLElBQUksRUFBcUIsZ0JBQUosQ0FBQztFQUN4QjtFQUVBLE1BQU0sbUNBQW1DLENBQ3ZDLE1BQWlFLEVBQ2pFLFlBQXFCLEVBQ3JCO0lBQ0EsTUFBTTtNQUFFO0lBQVksQ0FBQyxHQUFHLE1BQU07SUFDOUIsSUFBSSxXQUFXLEtBQUsscUNBQWEsQ0FBQyxNQUFNLEVBQUU7TUFDeEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxxQ0FBcUMsQ0FBQztJQUN4RDtJQUVBLE1BQU0sV0FBVyxHQUFHLHFCQUFBLENBQUssaUJBQWlCLEVBQXRCLElBQXFCLENBQUMsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUUzRCxNQUFNO01BQUUsV0FBVyxFQUFFO0lBQW1CLENBQUMsR0FBSSxNQUFNLHFCQUFBLENBQUssVUFBVSxFQUFmLElBQWMsQ0FBQyxDQUFDLElBQUksQ0FDckUsNENBQTRDLEVBQzVDO01BQ0UsR0FBRyxNQUFNO01BQ1QsVUFBVSxFQUFFO0lBQ2QsQ0FDRixDQUE2QjtJQUU3QixNQUFNLGlCQUFBLENBQUEsMEJBQUEsTUFBSSxFQUFDLHlCQUF3QixDQUFDLENBQUEsSUFBQSxDQUE5QixJQUFJLEVBQTJCO01BQ25DLEdBQUcsRUFBRSxrQkFBa0I7TUFDdkIsVUFBVSxFQUFFO0lBQ2QsQ0FBQyxDQUFDO0lBRUYsSUFBSSxDQUFDLFlBQVksRUFBRTtNQUNqQjtNQUNBLHFCQUFBLENBQUssU0FBUyxFQUFkLElBQWEsQ0FBQyxDQUFDLHNCQUFzQixDQUFDLDhCQUE4QixDQUFDO0lBQ3ZFO0lBRUEsTUFBTSxhQUFhLEdBQUcsTUFBTSxxQkFBQSxDQUFLLFVBQVUsRUFBZixJQUFjLENBQUMsQ0FBQyxJQUFJLENBQzlDLHlDQUNGLENBQUM7SUFFRCxPQUFPLGFBQWE7RUFDdEI7RUFFQSxNQUFNLHFDQUFxQyxDQUN6QyxNQUFtRSxFQUNuRTtJQUNBLE1BQU07TUFBRTtJQUFZLENBQUMsR0FBRyxNQUFNO0lBQzlCLElBQUksV0FBVyxLQUFLLHFDQUFhLENBQUMsUUFBUSxFQUFFO01BQzFDLE1BQU0sSUFBSSxLQUFLLENBQUMsdUNBQXVDLENBQUM7SUFDMUQ7SUFFQSxNQUFNLHFCQUFBLENBQUssVUFBVSxFQUFmLElBQWMsQ0FBQyxDQUFDLElBQUksQ0FDeEIsNENBQTRDLEVBQzVDLE1BQ0YsQ0FBQztJQUVELE1BQU0sYUFBYSxHQUFHLE1BQU0scUJBQUEsQ0FBSyxVQUFVLEVBQWYsSUFBYyxDQUFDLENBQUMsSUFBSSxDQUM5Qyx5Q0FDRixDQUFDO0lBRUQsT0FBTyxhQUFhO0VBQ3RCO0VBRUEsTUFBTSx5QkFBeUIsQ0FDN0IsTUFBZ0MsRUFDaEMsWUFBcUIsRUFDckI7SUFDQSxNQUFNLFdBQVcsR0FBRyxxQkFBQSxDQUFLLGlCQUFpQixFQUF0QixJQUFxQixDQUFDLENBQUMsY0FBYyxDQUFDLENBQUM7SUFFM0QsTUFBTTtNQUFFO0lBQW1CLENBQUMsR0FBRyxNQUFNLHFCQUFBLENBQUssVUFBVSxFQUFmLElBQWMsQ0FBQyxDQUFDLElBQUksQ0FDdkQsd0RBQXdELEVBQ3hEO01BQ0UsR0FBRyxNQUFNO01BQ1QsVUFBVSxFQUFFO0lBQ2QsQ0FDRixDQUFDO0lBRUQsTUFBTSxpQkFBQSxDQUFBLDBCQUFBLE1BQUksRUFBQyx5QkFBd0IsQ0FBQyxDQUFBLElBQUEsQ0FBOUIsSUFBSSxFQUEyQjtNQUNuQyxHQUFHLEVBQUUsa0JBQWtCO01BQ3ZCLFVBQVUsRUFBRTtJQUNkLENBQUMsQ0FBQztJQUVGLElBQUksQ0FBQyxZQUFZLEVBQUU7TUFDakI7TUFDQSxxQkFBQSxDQUFLLFNBQVMsRUFBZCxJQUFhLENBQUMsQ0FBQyxzQkFBc0IsQ0FBQyw4QkFBOEIsQ0FBQztJQUN2RTtJQUVBLE1BQU0sYUFBYSxHQUFHLE1BQU0scUJBQUEsQ0FBSyxVQUFVLEVBQWYsSUFBYyxDQUFDLENBQUMsSUFBSSxDQUM5Qyx5Q0FDRixDQUFDO0lBQ0QsT0FBTyxhQUFhO0VBQ3RCO0FBNENGO0FBQUMsT0FBQSxDQUFBLG1CQUFBLEdBQUEsbUJBQUE7QUFBQSxlQUFBLDBCQTFDaUMsTUFBMkMsRUFBRTtFQUMzRSxNQUFNLFNBQVMsR0FBRyxNQUFNLHFCQUFBLENBQUssU0FBUyxFQUFkLElBQWEsQ0FBQyxDQUFDLE9BQU8sQ0FBQztJQUFFLEdBQUcsRUFBRSxNQUFNLENBQUM7RUFBSSxDQUFDLENBQUM7RUFFbkUsTUFBTSxJQUFJLE9BQU8sQ0FBTyxDQUFDLE9BQU8sRUFBRSxNQUFNLEtBQUs7SUFDM0MsSUFBSSxTQUFTLEdBQUcsS0FBSztJQUNyQjtJQUNBLE1BQU0sb0JBQW9CLEdBQUcsQ0FDM0IsS0FBYSxFQUNiLFVBQTJCLEtBQ3hCO01BQ0g7TUFDQSxJQUFJLEtBQUssS0FBSyxTQUFTLENBQUMsRUFBRSxJQUFJLFVBQVUsQ0FBQyxHQUFHLEVBQUU7UUFDNUMsSUFBSSxVQUFVLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLEVBQUU7VUFDaEQ7VUFDQSxTQUFTLEdBQUcsSUFBSTs7VUFFaEI7VUFDQSxxQkFBQSxDQUFLLFNBQVMsRUFBZCxJQUFhLENBQUMsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDO1FBQ2hDO1FBQ0E7TUFDRjtJQUNGLENBQUM7SUFDRCxxQkFBQSxDQUFLLFNBQVMsRUFBZCxJQUFhLENBQUMsQ0FBQyxxQkFBcUIsQ0FBQyxvQkFBb0IsQ0FBQzs7SUFFMUQ7SUFDQSxNQUFNLG9CQUFvQixHQUFJLEtBQWEsSUFBSztNQUM5QyxNQUFNLGdCQUFnQixHQUFHLENBQUEsS0FBTTtRQUM3QixxQkFBQSxDQUFLLFNBQVMsRUFBZCxJQUFhLENBQUMsQ0FBQyx3QkFBd0IsQ0FBQyxvQkFBb0IsQ0FBQztRQUM3RCxxQkFBQSxDQUFLLFNBQVMsRUFBZCxJQUFhLENBQUMsQ0FBQyx3QkFBd0IsQ0FBQyxvQkFBb0IsQ0FBQztNQUMvRCxDQUFDO01BQ0QsSUFBSSxLQUFLLEtBQUssU0FBUyxDQUFDLEVBQUUsRUFBRTtRQUMxQixnQkFBZ0IsQ0FBQyxDQUFDO1FBQ2xCLElBQUksU0FBUyxFQUFFO1VBQ2IsT0FBTyxDQUFDLENBQUM7UUFDWCxDQUFDLE1BQU07VUFDTCxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsbUJBQW1CLENBQUMsQ0FBQztRQUN4QztNQUNGO0lBQ0YsQ0FBQztJQUNELHFCQUFBLENBQUssU0FBUyxFQUFkLElBQWEsQ0FBQyxDQUFDLHFCQUFxQixDQUFDLG9CQUFvQixDQUFDO0VBQzVELENBQUMsQ0FBQztBQUNKOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQzlKSyxNQUFNLFlBQVksR0FBQSxPQUFBLENBQUEsWUFBQSxHQUFHLHFCQUFxQjs7Ozs7Ozs7Ozs7Ozs7QUNiakQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOzs7Ozs7Ozs7Ozs7O0FDbERBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7Ozs7Ozs7Ozs7QUM3REE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7Ozs7Ozs7Ozs7OztBQ3ZKQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7Ozs7Ozs7Ozs7QUN2SEE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7Ozs7Ozs7Ozs7OztBQzVCQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7Ozs7Ozs7Ozs7OztBQ3JXQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7Ozs7Ozs7Ozs7OztBQ2hQQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7Ozs7Ozs7Ozs7QUM3QkE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOzs7Ozs7Ozs7Ozs7O0FDMUJBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7Ozs7Ozs7Ozs7OztBQ0xBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7Ozs7Ozs7Ozs7QUN6QkE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7Ozs7Ozs7Ozs7OztBQzdEQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7Ozs7Ozs7Ozs7O0FDeEdBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDdk1BOzs7Ozs7Ozs7Ozs7Ozs7QUFlRztNQVVVLHlCQUF5QjtFQUNwQyxZQUE2QixTQUE2QjtJQUE3QixJQUFTLENBQUEsU0FBQSxHQUFULFNBQVM7Ozs7RUFHdEMscUJBQXFCLENBQUE7SUFDbkIsTUFBTSxTQUFTLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxZQUFZLEVBQUU7OztJQUcvQyxPQUFPLFNBQVMsQ0FDYixHQUFHLENBQUMsUUFBUSxJQUFHO01BQ2QsSUFBSSx3QkFBd0IsQ0FBQyxRQUFRLENBQUMsRUFBRTtRQUN0QyxNQUFNLE9BQU8sR0FBRyxRQUFRLENBQUMsWUFBWSxFQUFvQjtRQUN6RCxPQUFPLEdBQUcsT0FBTyxDQUFDLE9BQU8sSUFBSSxPQUFPLENBQUMsT0FBTyxFQUFFO09BQy9DLE1BQU07UUFDTCxPQUFPLElBQUk7O0lBRWYsQ0FBQyxDQUFDLENBQ0QsTUFBTSxDQUFDLFNBQVMsSUFBSSxTQUFTLENBQUMsQ0FDOUIsSUFBSSxDQUFDLEdBQUcsQ0FBQzs7QUFFZjtBQUNEOzs7Ozs7O0FBT0c7QUFDSCxTQUFTLHdCQUF3QixDQUFDLFFBQXdCO0VBQ3hELE1BQU0sU0FBUyxHQUFHLFFBQVEsQ0FBQyxZQUFZLEVBQUU7RUFDekMsT0FBTyxDQUFBLFNBQVMsS0FBVCxRQUFBLFNBQVMsdUJBQVQsU0FBUyxDQUFFLElBQUk7QUFDeEI7Ozs7QUN6REE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBSUksTUFBTSxNQUFNLEdBQUcsSUFBSSxjQUFNLENBQUMsZUFBZSxDQUFDOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ25CakQ7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBOEJIOzs7O0FBSUc7QUFDSSxNQUFNLGtCQUFrQixHQUFBLE9BQUEsQ0FBQSxtQkFBQSxHQUFHO0FBRTNCLE1BQU0sbUJBQW1CLEdBQUc7RUFDakMsQ0FBQyxNQUFPLEdBQUcsV0FBVztFQUN0QixDQUFDLE1BQWEsR0FBRyxrQkFBa0I7RUFDbkMsQ0FBQyxNQUFhLEdBQUcsZ0JBQWdCO0VBQ2pDLENBQUMsTUFBbUIsR0FBRyx1QkFBdUI7RUFDOUMsQ0FBQyxNQUFZLEdBQUcsZ0JBQWdCO0VBQ2hDLENBQUMsTUFBa0IsR0FBRyx1QkFBdUI7RUFDN0MsQ0FBQyxNQUFRLEdBQUcsV0FBVztFQUN2QixDQUFDLE1BQWMsR0FBRyxrQkFBa0I7RUFDcEMsQ0FBQyxNQUFZLEdBQUcsV0FBVztFQUMzQixDQUFDLE1BQWUsR0FBRyxtQkFBbUI7RUFDdEMsQ0FBQyxNQUFrQixHQUFHLGtCQUFrQjtFQUN4QyxDQUFDLE1BQWEsR0FBRyxTQUFTO0VBQzFCLENBQUMsTUFBbUIsR0FBRyxnQkFBZ0I7RUFDdkMsQ0FBQyxNQUFpQixHQUFHLFVBQVU7RUFDL0IsQ0FBQyxNQUF1QixHQUFHLGlCQUFpQjtFQUM1QyxDQUFDLE1BQWEsR0FBRyxVQUFVO0VBQzNCLENBQUMsTUFBbUIsR0FBRyxpQkFBaUI7RUFDeEMsQ0FBQyxNQUFlLEdBQUcsV0FBVztFQUM5QixDQUFDLE1BQXFCLEdBQUcsa0JBQWtCO0VBQzNDLENBQUMsTUFBZ0IsR0FBRyxTQUFTO0VBQzdCLENBQUMsTUFBc0IsR0FBRyxnQkFBZ0I7RUFDMUMsQ0FBQyxNQUFXLEdBQUcsVUFBVTtFQUN6QixDQUFDLE1BQWlCLEdBQUcsaUJBQWlCO0VBQ3RDLENBQUMsTUFBYSxHQUFHLFVBQVU7RUFDM0IsQ0FBQyxNQUFtQixHQUFHLGlCQUFpQjtFQUN4QyxDQUFDLE1BQVUsR0FBRyxhQUFhO0VBQzNCLFNBQVMsRUFBRSxTQUFTO0VBQUE7RUFDcEIsQ0FBQyxJQUFXLEdBQUc7Q0FDUDs7QUNqRlY7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBYUg7O0FBRUc7QUFDVSxNQUFBLEtBQUssR0FBQSxPQUFBLENBQUEsS0FBQSxHQUFHLElBQUksR0FBRztBQUU1Qjs7QUFFRztBQUNVLE1BQUEsV0FBVyxHQUFBLE9BQUEsQ0FBQSxXQUFBLEdBQUcsSUFBSSxHQUFHO0FBRWxDOzs7O0FBSUc7QUFDSDtBQUNhLE1BQUEsV0FBVyxHQUFBLE9BQUEsQ0FBQSxXQUFBLEdBQUcsSUFBSSxHQUFHO0FBRWxDOzs7O0FBSUc7QUFDYSxTQUFBLGFBQWEsQ0FDM0IsR0FBZ0IsRUFDaEIsU0FBdUI7RUFFdkIsSUFBSTtJQUNELEdBQXVCLENBQUMsU0FBUyxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUM7R0FDM0QsQ0FBQyxPQUFPLENBQUMsRUFBRTtJQUNWLE1BQU0sQ0FBQyxLQUFLLENBQ1YsYUFBYSxTQUFTLENBQUMsSUFBSSx3Q0FBd0MsR0FBRyxDQUFDLElBQUksRUFBRSxFQUM3RSxDQUFDLENBQ0Y7O0FBRUw7QUFFQTs7O0FBR0c7QUFDYSxTQUFBLHdCQUF3QixDQUN0QyxHQUFnQixFQUNoQixTQUFvQjtFQUVuQixHQUF1QixDQUFDLFNBQVMsQ0FBQyx1QkFBdUIsQ0FBQyxTQUFTLENBQUM7QUFDdkU7QUFFQTs7Ozs7O0FBTUc7QUFDRyxTQUFVLGtCQUFrQixDQUNoQyxTQUF1QjtFQUV2QixNQUFNLGFBQWEsR0FBRyxTQUFTLENBQUMsSUFBSTtFQUNwQyxJQUFJLFdBQVcsQ0FBQyxHQUFHLENBQUMsYUFBYSxDQUFDLEVBQUU7SUFDbEMsTUFBTSxDQUFDLEtBQUssQ0FDVixzREFBc0QsYUFBYSxHQUFHLENBQ3ZFO0lBRUQsT0FBTyxLQUFLOztFQUdkLFdBQVcsQ0FBQyxHQUFHLENBQUMsYUFBYSxFQUFFLFNBQVMsQ0FBQzs7RUFHekMsS0FBSyxNQUFNLEdBQUcsSUFBSSxLQUFLLENBQUMsTUFBTSxFQUFFLEVBQUU7SUFDaEMsYUFBYSxDQUFDLEdBQXNCLEVBQUUsU0FBUyxDQUFDOztFQUdsRCxLQUFLLE1BQU0sU0FBUyxJQUFJLFdBQVcsQ0FBQyxNQUFNLEVBQUUsRUFBRTtJQUM1QyxhQUFhLENBQUMsU0FBa0MsRUFBRSxTQUFTLENBQUM7O0VBRzlELE9BQU8sSUFBSTtBQUNiO0FBRUE7Ozs7Ozs7O0FBUUc7QUFDYSxTQUFBLFlBQVksQ0FDMUIsR0FBZ0IsRUFDaEIsSUFBTztFQUVQLE1BQU0sbUJBQW1CLEdBQUksR0FBdUIsQ0FBQyxTQUFTLENBQzNELFdBQVcsQ0FBQyxXQUFXLENBQUMsQ0FDeEIsWUFBWSxDQUFDO0lBQUUsUUFBUSxFQUFFO0VBQUksQ0FBRSxDQUFDO0VBQ25DLElBQUksbUJBQW1CLEVBQUU7SUFDdkIsS0FBSyxtQkFBbUIsQ0FBQyxnQkFBZ0IsRUFBRTs7RUFFN0MsT0FBUSxHQUF1QixDQUFDLFNBQVMsQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDO0FBQzdEO0FBRUE7Ozs7Ozs7QUFPRztBQUNHLFNBQVUsc0JBQXNCLENBQ3BDLEdBQWdCLEVBQ2hCLElBQU8sRUFDUCxrQkFBQSxHQUE2QixrQkFBa0I7RUFFL0MsWUFBWSxDQUFDLEdBQUcsRUFBRSxJQUFJLENBQUMsQ0FBQyxhQUFhLENBQUMsa0JBQWtCLENBQUM7QUFDM0Q7QUFFQTs7Ozs7OztBQU9HO0FBQ0csU0FBVSxjQUFjLENBQzVCLEdBQWtDO0VBRWxDLE9BQVEsR0FBbUIsQ0FBQyxPQUFPLEtBQUssU0FBUztBQUNuRDtBQUVBOzs7Ozs7O0FBT0c7QUFDRyxTQUFVLG9CQUFvQixDQUNsQyxHQUFvQztFQUVwQyxPQUFRLEdBQXlCLENBQUMsUUFBUSxLQUFLLFNBQVM7QUFDMUQ7QUFFQTs7OztBQUlHO1NBQ2EsZ0JBQWdCLENBQUE7RUFDOUIsV0FBVyxDQUFDLEtBQUssRUFBRTtBQUNyQjs7QUN0TEE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBcUJILE1BQU0sTUFBTSxHQUF1QjtFQUNqQyxrQ0FDRSxrREFBa0QsR0FDbEQsNEJBQTRCO0VBQzlCLDhDQUF5QixnQ0FBZ0M7RUFDekQsZ0RBQ0UsaUZBQWlGO0VBQ25GLDRDQUF3QixpREFBaUQ7RUFDekUsMERBQStCLHNDQUFzQztFQUNyRSwwQ0FDRSx5RUFBeUU7RUFDM0UsOERBQ0Usc0RBQXNELEdBQ3RELHdCQUF3QjtFQUMxQiw4REFDRSx1REFBdUQ7RUFDekQsc0NBQ0UsK0VBQStFO0VBQ2pGLG9DQUNFLG9GQUFvRjtFQUN0RixzQ0FDRSxrRkFBa0Y7RUFDcEYsMENBQ0UscUZBQXFGO0VBQ3ZGLDRGQUNFLHlHQUF5RztFQUMzRyxrRkFDRTtDQUNIO0FBZU0sTUFBTSxhQUFhLEdBQUcsSUFBSSxrQkFBWSxDQUMzQyxLQUFLLEVBQ0wsVUFBVSxFQUNWLE1BQU0sQ0FDUDs7QUNuRkQ7Ozs7Ozs7Ozs7Ozs7OztBQWVHO01BY1UsZUFBZTtFQWMxQixZQUNFLE9BQXdCLEVBQ3hCLE1BQXFDLEVBQ3JDLFNBQTZCO0lBTnJCLElBQVUsQ0FBQSxVQUFBLEdBQUcsS0FBSztJQVExQixJQUFJLENBQUMsUUFBUSxHQUFRLE1BQUEsQ0FBQSxNQUFBLEtBQUEsT0FBTyxDQUFFO0lBQzlCLElBQUksQ0FBQyxPQUFPLEdBQVEsTUFBQSxDQUFBLE1BQUEsS0FBQSxNQUFNLENBQUU7SUFDNUIsSUFBSSxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsSUFBSTtJQUN4QixJQUFJLENBQUMsK0JBQStCLEdBQ2xDLE1BQU0sQ0FBQyw4QkFBOEI7SUFDdkMsSUFBSSxDQUFDLFVBQVUsR0FBRyxTQUFTO0lBQzNCLElBQUksQ0FBQyxTQUFTLENBQUMsWUFBWSxDQUN6QixJQUFJLG9CQUFTLENBQUMsS0FBSyxFQUFFLE1BQU0sSUFBSSxzQ0FBdUIsQ0FDdkQ7O0VBR0gsSUFBSSw4QkFBOEIsQ0FBQTtJQUNoQyxJQUFJLENBQUMsY0FBYyxFQUFFO0lBQ3JCLE9BQU8sSUFBSSxDQUFDLCtCQUErQjs7RUFHN0MsSUFBSSw4QkFBOEIsQ0FBQyxHQUFZO0lBQzdDLElBQUksQ0FBQyxjQUFjLEVBQUU7SUFDckIsSUFBSSxDQUFDLCtCQUErQixHQUFHLEdBQUc7O0VBRzVDLElBQUksSUFBSSxDQUFBO0lBQ04sSUFBSSxDQUFDLGNBQWMsRUFBRTtJQUNyQixPQUFPLElBQUksQ0FBQyxLQUFLOztFQUduQixJQUFJLE9BQU8sQ0FBQTtJQUNULElBQUksQ0FBQyxjQUFjLEVBQUU7SUFDckIsT0FBTyxJQUFJLENBQUMsUUFBUTs7RUFHdEIsSUFBSSxNQUFNLENBQUE7SUFDUixJQUFJLENBQUMsY0FBYyxFQUFFO0lBQ3JCLE9BQU8sSUFBSSxDQUFDLE9BQU87O0VBR3JCLElBQUksU0FBUyxDQUFBO0lBQ1gsT0FBTyxJQUFJLENBQUMsVUFBVTs7RUFHeEIsSUFBSSxTQUFTLENBQUE7SUFDWCxPQUFPLElBQUksQ0FBQyxVQUFVOztFQUd4QixJQUFJLFNBQVMsQ0FBQyxHQUFZO0lBQ3hCLElBQUksQ0FBQyxVQUFVLEdBQUcsR0FBRzs7RUFHdkI7OztBQUdHO0VBQ08sY0FBYyxDQUFBO0lBQ3RCLElBQUksSUFBSSxDQUFDLFNBQVMsRUFBRTtNQUNsQixNQUFNLGFBQWEsQ0FBQyxNQUFNLDJDQUF1QjtRQUFFLE9BQU8sRUFBRSxJQUFJLENBQUM7TUFBSyxDQUFFLENBQUM7OztBQUc5RTs7QUN6R0Q7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBY0csTUFBTyxxQkFDWCxTQUFRLGVBQWU7RUFPdkIsWUFDRSxPQUEwQyxFQUMxQyxZQUF1QyxFQUN2QyxJQUFZLEVBQ1osU0FBNkI7O0lBRzdCLE1BQU0sOEJBQThCLEdBQ2xDLFlBQVksQ0FBQyw4QkFBOEIsS0FBSyxTQUFTLEdBQ3JELFlBQVksQ0FBQyw4QkFBOEIsR0FDM0MsS0FBSzs7SUFHWCxNQUFNLE1BQU0sR0FBa0M7TUFDNUMsSUFBSTtNQUNKO0tBQ0Q7SUFFRCxJQUFLLE9BQTJCLENBQUMsTUFBTSxLQUFLLFNBQVMsRUFBRTs7TUFFckQsS0FBSyxDQUFDLE9BQTBCLEVBQUUsTUFBTSxFQUFFLFNBQVMsQ0FBQztLQUNyRCxNQUFNO01BQ0wsTUFBTSxPQUFPLEdBQW9CLE9BQTBCO01BQzNELEtBQUssQ0FBQyxPQUFPLENBQUMsT0FBTyxFQUFFLE1BQU0sRUFBRSxTQUFTLENBQUM7OztJQUkzQyxJQUFJLENBQUMsYUFBYSxHQUFBLE1BQUEsQ0FBQSxNQUFBO01BQ2hCO0lBQThCLENBQzNCLEVBQUEsWUFBWSxDQUNoQjtJQUVELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxJQUFJO0lBQ2pDLElBQUksT0FBTyxvQkFBb0IsS0FBSyxXQUFXLEVBQUU7TUFDL0MsSUFBSSxDQUFDLHFCQUFxQixHQUFHLElBQUksb0JBQW9CLENBQUMsTUFBSztRQUN6RCxJQUFJLENBQUMsZ0JBQWdCLEVBQUU7TUFDekIsQ0FBQyxDQUFDOztJQUdKLElBQUksQ0FBQyxTQUFTLEdBQUcsQ0FBQztJQUNsQixJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsY0FBYyxDQUFDOzs7SUFJbkQsSUFBSSxDQUFDLGFBQWEsQ0FBQyxjQUFjLEdBQUcsU0FBUztJQUM3QyxZQUFZLENBQUMsY0FBYyxHQUFHLFNBQVM7SUFFdkMsZUFBZSxDQUFDLE1BQVcsRUFBRSxTQUFPLEVBQUUsV0FBVyxDQUFDOztFQUdwRCxNQUFNLENBQUE7SUFDSixPQUFPLFNBQVM7O0VBR2xCLElBQUksUUFBUSxDQUFBO0lBQ1YsT0FBTyxJQUFJLENBQUMsU0FBUzs7OztFQUt2QixXQUFXLENBQUMsR0FBdUI7SUFDakMsSUFBSSxJQUFJLENBQUMsU0FBUyxFQUFFO01BQ2xCOztJQUVGLElBQUksQ0FBQyxTQUFTLEVBQUU7SUFDaEIsSUFBSSxHQUFHLEtBQUssU0FBUyxJQUFJLElBQUksQ0FBQyxxQkFBcUIsS0FBSyxJQUFJLEVBQUU7TUFDNUQsSUFBSSxDQUFDLHFCQUFxQixDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsSUFBSSxDQUFDOzs7O0VBS2xELFdBQVcsQ0FBQTtJQUNULElBQUksSUFBSSxDQUFDLFNBQVMsRUFBRTtNQUNsQixPQUFPLENBQUM7O0lBRVYsT0FBTyxFQUFFLElBQUksQ0FBQyxTQUFTOzs7OztFQU1qQixnQkFBZ0IsQ0FBQTtJQUN0QixLQUFLLFNBQVMsQ0FBQyxJQUFJLENBQUM7O0VBR3RCLElBQUksUUFBUSxDQUFBO0lBQ1YsSUFBSSxDQUFDLGNBQWMsRUFBRTtJQUNyQixPQUFPLElBQUksQ0FBQyxhQUFhOztFQUczQjs7O0FBR0c7RUFDTyxjQUFjLENBQUE7SUFDdEIsSUFBSSxJQUFJLENBQUMsU0FBUyxFQUFFO01BQ2xCLE1BQU0sYUFBYSxDQUFDLE1BQU0sd0RBQTZCOzs7QUFHNUQ7O0FDeElEOzs7Ozs7Ozs7Ozs7Ozs7QUFlRztBQTRDSDs7OztBQUlHO0FBQ0ksTUFBTSxXQUFXLEdBQUEsT0FBQSxDQUFBLFdBQUEsR0FBRyxPQUFBO1NBb0VYLGFBQWEsQ0FDM0IsUUFBMEIsRUFDMUIsU0FBUyxHQUFHLEVBQUU7RUFFZCxJQUFJLE9BQU8sR0FBRyxRQUFRO0VBRXRCLElBQUksT0FBTyxTQUFTLEtBQUssUUFBUSxFQUFFO0lBQ2pDLE1BQU0sSUFBSSxHQUFHLFNBQVM7SUFDdEIsU0FBUyxHQUFHO01BQUU7SUFBSSxDQUFFOztFQUd0QixNQUFNLE1BQU0sR0FBQSxNQUFBLENBQUEsTUFBQTtJQUNWLElBQUksRUFBRSxrQkFBa0I7SUFDeEIsOEJBQThCLEVBQUU7RUFBSyxHQUNsQyxTQUFTLENBQ2I7RUFDRCxNQUFNLElBQUksR0FBRyxNQUFNLENBQUMsSUFBSTtFQUV4QixJQUFJLE9BQU8sSUFBSSxLQUFLLFFBQVEsSUFBSSxDQUFDLElBQUksRUFBRTtJQUNyQyxNQUFNLGFBQWEsQ0FBQyxNQUFNLENBQXdCO01BQ2hELE9BQU8sRUFBRSxNQUFNLENBQUMsSUFBSTtJQUNyQixFQUFDOztFQUdKLE9BQU8sS0FBUCxPQUFPLEdBQUssSUFBQSx5QkFBbUIsR0FBRSxDQUFDO0VBRWxDLElBQUksQ0FBQyxPQUFPLEVBQUU7SUFDWixNQUFNLGFBQWEsQ0FBQyxNQUFNLHdDQUFxQjs7RUFHakQsTUFBTSxXQUFXLEdBQUcsS0FBSyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQW9CO0VBQ3RELElBQUksV0FBVyxFQUFFOztJQUVmLElBQ0UsSUFBQSxlQUFTLEVBQUMsT0FBTyxFQUFFLFdBQVcsQ0FBQyxPQUFPLENBQUMsSUFDdkMsSUFBQSxlQUFTLEVBQUMsTUFBTSxFQUFFLFdBQVcsQ0FBQyxNQUFNLENBQUMsRUFDckM7TUFDQSxPQUFPLFdBQVc7S0FDbkIsTUFBTTtNQUNMLE1BQU0sYUFBYSxDQUFDLE1BQU0sQ0FBeUI7UUFBRSxPQUFPLEVBQUU7TUFBSSxDQUFFLENBQUM7OztFQUl6RSxNQUFNLFNBQVMsR0FBRyxJQUFJLDZCQUFrQixDQUFDLElBQUksQ0FBQztFQUM5QyxLQUFLLE1BQU0sU0FBUyxJQUFJLFdBQVcsQ0FBQyxNQUFNLEVBQUUsRUFBRTtJQUM1QyxTQUFTLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBQzs7RUFHbkMsTUFBTSxNQUFNLEdBQUcsSUFBSSxlQUFlLENBQUMsT0FBTyxFQUFFLE1BQU0sRUFBRSxTQUFTLENBQUM7RUFFOUQsS0FBSyxDQUFDLEdBQUcsQ0FBQyxJQUFJLEVBQUUsTUFBTSxDQUFDO0VBRXZCLE9BQU8sTUFBTTtBQUNmO0FBZ0RnQixTQUFBLG1CQUFtQixDQUNqQyxRQUF1QyxFQUN2QyxnQkFBMkM7RUFFM0MsSUFBSSxJQUFBLGVBQVMsR0FBRSxJQUFJLENBQUMsSUFBQSxpQkFBVyxHQUFFLEVBQUU7O0lBRWpDLE1BQU0sYUFBYSxDQUFDLE1BQU0sZ0ZBQXlDOztFQUdyRSxJQUFJLGdCQUFnQixDQUFDLDhCQUE4QixLQUFLLFNBQVMsRUFBRTtJQUNqRSxnQkFBZ0IsQ0FBQyw4QkFBOEIsR0FBRyxLQUFLOztFQUd6RCxJQUFJLFVBQTJCO0VBQy9CLElBQUksY0FBYyxDQUFDLFFBQVEsQ0FBQyxFQUFFO0lBQzVCLFVBQVUsR0FBRyxRQUFRLENBQUMsT0FBTztHQUM5QixNQUFNO0lBQ0wsVUFBVSxHQUFHLFFBQVE7OztFQUl2QixNQUFNLE9BQU8sR0FDUixNQUFBLENBQUEsTUFBQSxDQUFBLE1BQUEsQ0FBQSxNQUFBLEtBQUEsZ0JBQWdCLENBQ2hCLEVBQUEsVUFBVSxDQUNkOzs7RUFJRCxJQUFJLE9BQU8sQ0FBQyxjQUFjLEtBQUssU0FBUyxFQUFFO0lBQ3hDLE9BQU8sT0FBTyxDQUFDLGNBQWM7O0VBRy9CLE1BQU0sUUFBUSxHQUFJLENBQVMsSUFBWTtJQUNyQyxPQUFPLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQ2xCLENBQUMsSUFBSSxFQUFFLENBQUMsS0FBTSxJQUFJLENBQUMsSUFBSSxDQUFDLEVBQUUsRUFBRSxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxHQUFJLENBQUMsRUFDeEQsQ0FBQyxDQUNGO0VBQ0gsQ0FBQztFQUVELElBQUksZ0JBQWdCLENBQUMsY0FBYyxLQUFLLFNBQVMsRUFBRTtJQUNqRCxJQUFJLE9BQU8sb0JBQW9CLEtBQUssV0FBVyxFQUFFO01BQy9DLE1BQU0sYUFBYSxDQUFDLE1BQU0sQ0FFeEIsNEZBQUUsQ0FDSDs7O0VBSUwsTUFBTSxVQUFVLEdBQUcsRUFBRSxHQUFHLFFBQVEsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQyxDQUFDO0VBQ3pELE1BQU0sV0FBVyxHQUFHLFdBQVcsQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFzQjtFQUNwRSxJQUFJLFdBQVcsRUFBRTtJQUNkLFdBQXFDLENBQUMsV0FBVyxDQUNoRCxnQkFBZ0IsQ0FBQyxjQUFjLENBQ2hDO0lBQ0QsT0FBTyxXQUFXOztFQUdwQixNQUFNLFNBQVMsR0FBRyxJQUFJLDZCQUFrQixDQUFDLFVBQVUsQ0FBQztFQUNwRCxLQUFLLE1BQU0sU0FBUyxJQUFJLFdBQVcsQ0FBQyxNQUFNLEVBQUUsRUFBRTtJQUM1QyxTQUFTLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBQzs7RUFHbkMsTUFBTSxNQUFNLEdBQUcsSUFBSSxxQkFBcUIsQ0FDdEMsVUFBVSxFQUNWLGdCQUFnQixFQUNoQixVQUFVLEVBQ1YsU0FBUyxDQUNWO0VBRUQsV0FBVyxDQUFDLEdBQUcsQ0FBQyxVQUFVLEVBQUUsTUFBTSxDQUFDO0VBRW5DLE9BQU8sTUFBTTtBQUNmO0FBRUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUE0Qkc7QUFDYSxTQUFBLE1BQU0sQ0FBQyxJQUFBLEdBQWUsa0JBQWtCO0VBQ3RELE1BQU0sR0FBRyxHQUFHLEtBQUssQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDO0VBQzNCLElBQUksQ0FBQyxHQUFHLElBQUksSUFBSSxLQUFLLGtCQUFrQixJQUFJLElBQUEseUJBQW1CLEdBQUUsRUFBRTtJQUNoRSxPQUFPLGFBQWEsRUFBRTs7RUFFeEIsSUFBSSxDQUFDLEdBQUcsRUFBRTtJQUNSLE1BQU0sYUFBYSxDQUFDLE1BQU0sQ0FBa0I7TUFBRSxPQUFPLEVBQUU7SUFBSSxDQUFFLENBQUM7O0VBR2hFLE9BQU8sR0FBRztBQUNaO0FBRUE7OztBQUdHO1NBQ2EsT0FBTyxDQUFBO0VBQ3JCLE9BQU8sS0FBSyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxFQUFFLENBQUM7QUFDbkM7QUFFQTs7Ozs7Ozs7Ozs7Ozs7OztBQWdCRztBQUNJLGVBQWUsU0FBUyxDQUFDLEdBQWdCO0VBQzlDLElBQUksZ0JBQWdCLEdBQUcsS0FBSztFQUM1QixNQUFNLElBQUksR0FBRyxHQUFHLENBQUMsSUFBSTtFQUNyQixJQUFJLEtBQUssQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLEVBQUU7SUFDbkIsZ0JBQWdCLEdBQUcsSUFBSTtJQUN2QixLQUFLLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQztHQUNuQixNQUFNLElBQUksV0FBVyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsRUFBRTtJQUNoQyxNQUFNLGlCQUFpQixHQUFHLEdBQTRCO0lBQ3RELElBQUksaUJBQWlCLENBQUMsV0FBVyxFQUFFLElBQUksQ0FBQyxFQUFFO01BQ3hDLFdBQVcsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDO01BQ3hCLGdCQUFnQixHQUFHLElBQUk7OztFQUkzQixJQUFJLGdCQUFnQixFQUFFO0lBQ3BCLE1BQU0sT0FBTyxDQUFDLEdBQUcsQ0FDZCxHQUF1QixDQUFDLFNBQVMsQ0FDL0IsWUFBWSxFQUFFLENBQ2QsR0FBRyxDQUFDLFFBQVEsSUFBSSxRQUFRLENBQUMsTUFBTSxFQUFFLENBQUMsQ0FDdEM7SUFDQSxHQUF1QixDQUFDLFNBQVMsR0FBRyxJQUFJOztBQUU3QztBQUVBOzs7Ozs7O0FBT0c7U0FDYSxlQUFlLENBQzdCLGdCQUF3QixFQUN4QixPQUFlLEVBQ2YsT0FBZ0I7Ozs7RUFJaEIsSUFBSSxPQUFPLEdBQUcsQ0FBQSxFQUFBLEdBQUEsbUJBQW1CLENBQUMsZ0JBQWdCLENBQUMsTUFBSSxRQUFBLEVBQUEsY0FBQSxFQUFBLEdBQUEsZ0JBQWdCO0VBQ3ZFLElBQUksT0FBTyxFQUFFO0lBQ1gsT0FBTyxJQUFJLElBQUksT0FBTyxFQUFFOztFQUUxQixNQUFNLGVBQWUsR0FBRyxPQUFPLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQztFQUM5QyxNQUFNLGVBQWUsR0FBRyxPQUFPLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQztFQUM5QyxJQUFJLGVBQWUsSUFBSSxlQUFlLEVBQUU7SUFDdEMsTUFBTSxPQUFPLEdBQUcsQ0FDZCwrQkFBK0IsT0FBTyxtQkFBbUIsT0FBTyxJQUFJLENBQ3JFO0lBQ0QsSUFBSSxlQUFlLEVBQUU7TUFDbkIsT0FBTyxDQUFDLElBQUksQ0FDVixpQkFBaUIsT0FBTyxtREFBbUQsQ0FDNUU7O0lBRUgsSUFBSSxlQUFlLElBQUksZUFBZSxFQUFFO01BQ3RDLE9BQU8sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDOztJQUVyQixJQUFJLGVBQWUsRUFBRTtNQUNuQixPQUFPLENBQUMsSUFBSSxDQUNWLGlCQUFpQixPQUFPLG1EQUFtRCxDQUM1RTs7SUFFSCxNQUFNLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDOUI7O0VBRUYsa0JBQWtCLENBQ2hCLElBQUksb0JBQVMsQ0FDWCxHQUFHLE9BQU8sVUFBa0IsRUFDNUIsT0FBTztJQUFFLE9BQU87SUFBRTtFQUFPLENBQUUsQ0FBQyx3Q0FFN0IsQ0FDRjtBQUNIO0FBRUE7Ozs7OztBQU1HO0FBQ2EsU0FBQSxLQUFLLENBQ25CLFdBQStCLEVBQy9CLE9BQW9CO0VBRXBCLElBQUksV0FBVyxLQUFLLElBQUksSUFBSSxPQUFPLFdBQVcsS0FBSyxVQUFVLEVBQUU7SUFDN0QsTUFBTSxhQUFhLENBQUMsTUFBTSw0REFBK0I7O0VBRTNELElBQUEseUJBQWlCLEVBQUMsV0FBVyxFQUFFLE9BQU8sQ0FBQztBQUN6QztBQUVBOzs7Ozs7OztBQVFHO0FBQ0csU0FBVSxXQUFXLENBQUMsUUFBd0I7RUFDbEQsSUFBQSxtQkFBZSxFQUFDLFFBQVEsQ0FBQztBQUMzQjs7QUMzZEE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBU0gsTUFBTSxPQUFPLEdBQUcsNkJBQTZCO0FBQzdDLE1BQU0sVUFBVSxHQUFHLENBQUM7QUFDcEIsTUFBTSxVQUFVLEdBQUcsMEJBQTBCO0FBUzdDLElBQUksU0FBUyxHQUF3QyxJQUFJO0FBQ3pELFNBQVMsWUFBWSxDQUFBO0VBQ25CLElBQUksQ0FBQyxTQUFTLEVBQUU7SUFDZCxTQUFTLEdBQUcsSUFBQSxXQUFNLEVBQVEsT0FBTyxFQUFFLFVBQVUsRUFBRTtNQUM3QyxPQUFPLEVBQUUsQ0FBQyxFQUFFLEVBQUUsVUFBVSxLQUFJOzs7Ozs7UUFNMUIsUUFBUSxVQUFVO1VBQ2hCLEtBQUssQ0FBQztZQUNKLElBQUk7Y0FDRixFQUFFLENBQUMsaUJBQWlCLENBQUMsVUFBVSxDQUFDO2FBQ2pDLENBQUMsT0FBTyxDQUFDLEVBQUU7Ozs7Y0FJVixPQUFPLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQzs7OztJQUl4QixFQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsSUFBRztNQUNYLE1BQU0sYUFBYSxDQUFDLE1BQU0sQ0FBb0I7UUFDNUMsb0JBQW9CLEVBQUUsQ0FBQyxDQUFDO01BQ3pCLEVBQUM7SUFDSixDQUFDLENBQUM7O0VBRUosT0FBTyxTQUFTO0FBQ2xCO0FBRU8sZUFBZSwyQkFBMkIsQ0FDL0MsR0FBZ0I7RUFFaEIsSUFBSTtJQUNGLE1BQU0sRUFBRSxHQUFHLE1BQU0sWUFBWSxFQUFFO0lBQy9CLE1BQU0sRUFBRSxHQUFHLEVBQUUsQ0FBQyxXQUFXLENBQUMsVUFBVSxDQUFDO0lBQ3JDLE1BQU0sTUFBTSxHQUFHLE1BQU0sRUFBRSxDQUFDLFdBQVcsQ0FBQyxVQUFVLENBQUMsQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDOzs7SUFHcEUsTUFBTSxFQUFFLENBQUMsSUFBSTtJQUNiLE9BQU8sTUFBTTtHQUNkLENBQUMsT0FBTyxDQUFDLEVBQUU7SUFDVixJQUFJLENBQUMsWUFBWSxtQkFBYSxFQUFFO01BQzlCLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQztLQUN2QixNQUFNO01BQ0wsTUFBTSxXQUFXLEdBQUcsYUFBYSxDQUFDLE1BQU0sQ0FBbUI7UUFDekQsb0JBQW9CLEVBQUcsQ0FBVyxhQUFYLENBQUMsS0FBRCxrQkFBQSxDQUFDLENBQVk7TUFDckMsRUFBQztNQUNGLE1BQU0sQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLE9BQU8sQ0FBQzs7O0FBR3RDO0FBRU8sZUFBZSwwQkFBMEIsQ0FDOUMsR0FBZ0IsRUFDaEIsZUFBc0M7RUFFdEMsSUFBSTtJQUNGLE1BQU0sRUFBRSxHQUFHLE1BQU0sWUFBWSxFQUFFO0lBQy9CLE1BQU0sRUFBRSxHQUFHLEVBQUUsQ0FBQyxXQUFXLENBQUMsVUFBVSxFQUFFLFdBQVcsQ0FBQztJQUNsRCxNQUFNLFdBQVcsR0FBRyxFQUFFLENBQUMsV0FBVyxDQUFDLFVBQVUsQ0FBQztJQUM5QyxNQUFNLFdBQVcsQ0FBQyxHQUFHLENBQUMsZUFBZSxFQUFFLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUN2RCxNQUFNLEVBQUUsQ0FBQyxJQUFJO0dBQ2QsQ0FBQyxPQUFPLENBQUMsRUFBRTtJQUNWLElBQUksQ0FBQyxZQUFZLG1CQUFhLEVBQUU7TUFDOUIsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDO0tBQ3ZCLE1BQU07TUFDTCxNQUFNLFdBQVcsR0FBRyxhQUFhLENBQUMsTUFBTSxDQUFxQjtRQUMzRCxvQkFBb0IsRUFBRyxDQUFXLGFBQVgsQ0FBQyxLQUFELGtCQUFBLENBQUMsQ0FBWTtNQUNyQyxFQUFDO01BQ0YsTUFBTSxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDOzs7QUFHdEM7QUFFQSxTQUFTLFVBQVUsQ0FBQyxHQUFnQjtFQUNsQyxPQUFPLEdBQUcsR0FBRyxDQUFDLElBQUksSUFBSSxHQUFHLENBQUMsT0FBTyxDQUFDLEtBQUssRUFBRTtBQUMzQzs7QUNqSEE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBc0JILE1BQU0sZ0JBQWdCLEdBQUcsSUFBSTtBQUM3QjtBQUNBLE1BQU0scUNBQXFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLElBQUk7TUFFekQsb0JBQW9CO0VBeUIvQixZQUE2QixTQUE2QjtJQUE3QixJQUFTLENBQUEsU0FBQSxHQUFULFNBQVM7SUFsQnRDOzs7Ozs7OztBQVFHO0lBQ0gsSUFBZ0IsQ0FBQSxnQkFBQSxHQUFpQyxJQUFJO0lBVW5ELE1BQU0sR0FBRyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsV0FBVyxDQUFDLEtBQUssQ0FBQyxDQUFDLFlBQVksRUFBRTtJQUM1RCxJQUFJLENBQUMsUUFBUSxHQUFHLElBQUksb0JBQW9CLENBQUMsR0FBRyxDQUFDO0lBQzdDLElBQUksQ0FBQyx1QkFBdUIsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLElBQUksRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFNLElBQUc7TUFDaEUsSUFBSSxDQUFDLGdCQUFnQixHQUFHLE1BQU07TUFDOUIsT0FBTyxNQUFNO0lBQ2YsQ0FBQyxDQUFDOztFQUdKOzs7Ozs7QUFNRztFQUNILE1BQU0sZ0JBQWdCLENBQUE7O0lBQ3BCLElBQUk7TUFDRixNQUFNLGNBQWMsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUNsQyxXQUFXLENBQUMsaUJBQWlCLENBQUMsQ0FDOUIsWUFBWSxFQUFFOzs7TUFJakIsTUFBTSxLQUFLLEdBQUcsY0FBYyxDQUFDLHFCQUFxQixFQUFFO01BQ3BELE1BQU0sSUFBSSxHQUFHLGdCQUFnQixFQUFFO01BQy9CLElBQUksRUFBQSxFQUFBLE9BQUksQ0FBQyxnQkFBZ0IsY0FBQSxFQUFBLHVCQUFBLEVBQUEsQ0FBRSxVQUFVLEtBQUksSUFBSSxFQUFFO1FBQzdDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxNQUFNLElBQUksQ0FBQyx1QkFBdUI7O1FBRTFELElBQUksRUFBQSxFQUFBLE9BQUksQ0FBQyxnQkFBZ0IsY0FBQSxFQUFBLHVCQUFBLEVBQUEsQ0FBRSxVQUFVLEtBQUksSUFBSSxFQUFFO1VBQzdDOzs7OztNQUtKLElBQ0UsSUFBSSxDQUFDLGdCQUFnQixDQUFDLHFCQUFxQixLQUFLLElBQUksSUFDcEQsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQ25DLG1CQUFtQixJQUFJLG1CQUFtQixDQUFDLElBQUksS0FBSyxJQUFJLENBQ3pELEVBQ0Q7UUFDQTtPQUNELE1BQU07O1FBRUwsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7VUFBRSxJQUFJO1VBQUU7UUFBSyxDQUFFLENBQUM7OztNQUd4RCxJQUFJLENBQUMsZ0JBQWdCLENBQUMsVUFBVSxHQUM5QixJQUFJLENBQUMsZ0JBQWdCLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxtQkFBbUIsSUFBRztRQUM1RCxNQUFNLFdBQVcsR0FBRyxJQUFJLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLEVBQUU7UUFDaEUsTUFBTSxHQUFHLEdBQUcsSUFBSSxDQUFDLEdBQUcsRUFBRTtRQUN0QixPQUFPLEdBQUcsR0FBRyxXQUFXLElBQUkscUNBQXFDO01BQ25FLENBQUMsQ0FBQztNQUNKLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDO0tBQ3RELENBQUMsT0FBTyxDQUFDLEVBQUU7TUFDVixNQUFNLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQzs7O0VBSWxCOzs7Ozs7QUFNRztFQUNILE1BQU0sbUJBQW1CLENBQUE7O0lBQ3ZCLElBQUk7TUFDRixJQUFJLElBQUksQ0FBQyxnQkFBZ0IsS0FBSyxJQUFJLEVBQUU7UUFDbEMsTUFBTSxJQUFJLENBQUMsdUJBQXVCOzs7TUFHcEMsSUFDRSxFQUFBLEVBQUEsT0FBSSxDQUFDLGdCQUFnQixNQUFFLFFBQUEsRUFBQSx1QkFBQSxFQUFBLENBQUEsVUFBVSxLQUFJLElBQUksSUFDekMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFVBQVUsQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUM3QztRQUNBLE9BQU8sRUFBRTs7TUFFWCxNQUFNLElBQUksR0FBRyxnQkFBZ0IsRUFBRTs7TUFFL0IsTUFBTTtRQUFFLGdCQUFnQjtRQUFFO01BQWEsQ0FBRSxHQUFHLDBCQUEwQixDQUNwRSxJQUFJLENBQUMsZ0JBQWdCLENBQUMsVUFBVSxDQUNqQztNQUNELE1BQU0sWUFBWSxHQUFHLElBQUEsbUNBQTZCLEVBQ2hELElBQUksQ0FBQyxTQUFTLENBQUM7UUFBRSxPQUFPLEVBQUUsQ0FBQztRQUFFLFVBQVUsRUFBRTtNQUFnQixDQUFFLENBQUMsQ0FDN0Q7O01BRUQsSUFBSSxDQUFDLGdCQUFnQixDQUFDLHFCQUFxQixHQUFHLElBQUk7TUFDbEQsSUFBSSxhQUFhLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRTs7UUFFNUIsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFVBQVUsR0FBRyxhQUFhOzs7O1FBSWhELE1BQU0sSUFBSSxDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDO09BQ3JELE1BQU07UUFDTCxJQUFJLENBQUMsZ0JBQWdCLENBQUMsVUFBVSxHQUFHLEVBQUU7O1FBRXJDLEtBQUssSUFBSSxDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDOztNQUVyRCxPQUFPLFlBQVk7S0FDcEIsQ0FBQyxPQUFPLENBQUMsRUFBRTtNQUNWLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO01BQ2QsT0FBTyxFQUFFOzs7QUFHZDtBQUVELFNBQVMsZ0JBQWdCLENBQUE7RUFDdkIsTUFBTSxLQUFLLEdBQUcsSUFBSSxJQUFJLEVBQUU7O0VBRXhCLE9BQU8sS0FBSyxDQUFDLFdBQVcsRUFBRSxDQUFDLFNBQVMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDO0FBQzdDO1NBRWdCLDBCQUEwQixDQUN4QyxlQUFzQyxFQUN0QyxPQUFPLEdBQUcsZ0JBQWdCOzs7RUFPMUIsTUFBTSxnQkFBZ0IsR0FBNEIsRUFBRTs7RUFFcEQsSUFBSSxhQUFhLEdBQUcsZUFBZSxDQUFDLEtBQUssRUFBRTtFQUMzQyxLQUFLLE1BQU0sbUJBQW1CLElBQUksZUFBZSxFQUFFOztJQUVqRCxNQUFNLGNBQWMsR0FBRyxnQkFBZ0IsQ0FBQyxJQUFJLENBQzFDLEVBQUUsSUFBSSxFQUFFLENBQUMsS0FBSyxLQUFLLG1CQUFtQixDQUFDLEtBQUssQ0FDN0M7SUFDRCxJQUFJLENBQUMsY0FBYyxFQUFFOztNQUVuQixnQkFBZ0IsQ0FBQyxJQUFJLENBQUM7UUFDcEIsS0FBSyxFQUFFLG1CQUFtQixDQUFDLEtBQUs7UUFDaEMsS0FBSyxFQUFFLENBQUMsbUJBQW1CLENBQUMsSUFBSTtNQUNqQyxFQUFDO01BQ0YsSUFBSSxVQUFVLENBQUMsZ0JBQWdCLENBQUMsR0FBRyxPQUFPLEVBQUU7OztRQUcxQyxnQkFBZ0IsQ0FBQyxHQUFHLEVBQUU7UUFDdEI7O0tBRUgsTUFBTTtNQUNMLGNBQWMsQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLG1CQUFtQixDQUFDLElBQUksQ0FBQzs7O01BR25ELElBQUksVUFBVSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsT0FBTyxFQUFFO1FBQzFDLGNBQWMsQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFO1FBQzFCOzs7OztJQUtKLGFBQWEsR0FBRyxhQUFhLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQzs7RUFFeEMsT0FBTztJQUNMLGdCQUFnQjtJQUNoQjtHQUNEO0FBQ0g7TUFFYSxvQkFBb0I7RUFFL0IsWUFBbUIsR0FBZ0I7SUFBaEIsSUFBRyxDQUFBLEdBQUEsR0FBSCxHQUFHO0lBQ3BCLElBQUksQ0FBQyx1QkFBdUIsR0FBRyxJQUFJLENBQUMsNEJBQTRCLEVBQUU7O0VBRXBFLE1BQU0sNEJBQTRCLENBQUE7SUFDaEMsSUFBSSxDQUFDLElBQUEsMEJBQW9CLEdBQUUsRUFBRTtNQUMzQixPQUFPLEtBQUs7S0FDYixNQUFNO01BQ0wsT0FBTyxJQUFBLCtCQUF5QixHQUFFLENBQy9CLElBQUksQ0FBQyxNQUFNLElBQUksQ0FBQyxDQUNoQixLQUFLLENBQUMsTUFBTSxLQUFLLENBQUM7OztFQUd6Qjs7QUFFRztFQUNILE1BQU0sSUFBSSxDQUFBO0lBQ1IsTUFBTSxlQUFlLEdBQUcsTUFBTSxJQUFJLENBQUMsdUJBQXVCO0lBQzFELElBQUksQ0FBQyxlQUFlLEVBQUU7TUFDcEIsT0FBTztRQUFFLFVBQVUsRUFBRTtNQUFFLENBQUU7S0FDMUIsTUFBTTtNQUNMLE1BQU0sa0JBQWtCLEdBQUcsTUFBTSwyQkFBMkIsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDO01BQ3RFLElBQUksa0JBQWtCLGFBQWxCLGtCQUFrQix1QkFBbEIsa0JBQWtCLENBQUUsVUFBVSxFQUFFO1FBQ2xDLE9BQU8sa0JBQWtCO09BQzFCLE1BQU07UUFDTCxPQUFPO1VBQUUsVUFBVSxFQUFFO1FBQUUsQ0FBRTs7Ozs7RUFLL0IsTUFBTSxTQUFTLENBQUMsZ0JBQXVDOztJQUNyRCxNQUFNLGVBQWUsR0FBRyxNQUFNLElBQUksQ0FBQyx1QkFBdUI7SUFDMUQsSUFBSSxDQUFDLGVBQWUsRUFBRTtNQUNwQjtLQUNELE1BQU07TUFDTCxNQUFNLHdCQUF3QixHQUFHLE1BQU0sSUFBSSxDQUFDLElBQUksRUFBRTtNQUNsRCxPQUFPLDBCQUEwQixDQUFDLElBQUksQ0FBQyxHQUFHLEVBQUU7UUFDMUMscUJBQXFCLEVBQ25CLENBQUEsRUFBQSxHQUFBLGdCQUFnQixDQUFDLHFCQUFxQixNQUN0QyxRQUFBLEVBQUEsY0FBQSxFQUFBLEdBQUEsd0JBQXdCLENBQUMscUJBQXFCO1FBQ2hELFVBQVUsRUFBRSxnQkFBZ0IsQ0FBQztNQUM5QixFQUFDOzs7O0VBSU4sTUFBTSxHQUFHLENBQUMsZ0JBQXVDOztJQUMvQyxNQUFNLGVBQWUsR0FBRyxNQUFNLElBQUksQ0FBQyx1QkFBdUI7SUFDMUQsSUFBSSxDQUFDLGVBQWUsRUFBRTtNQUNwQjtLQUNELE1BQU07TUFDTCxNQUFNLHdCQUF3QixHQUFHLE1BQU0sSUFBSSxDQUFDLElBQUksRUFBRTtNQUNsRCxPQUFPLDBCQUEwQixDQUFDLElBQUksQ0FBQyxHQUFHLEVBQUU7UUFDMUMscUJBQXFCLEVBQ25CLENBQUEsRUFBQSxHQUFBLGdCQUFnQixDQUFDLHFCQUFxQixNQUN0QyxRQUFBLEVBQUEsY0FBQSxFQUFBLEdBQUEsd0JBQXdCLENBQUMscUJBQXFCO1FBQ2hELFVBQVUsRUFBRSxDQUNWLEdBQUcsd0JBQXdCLENBQUMsVUFBVSxFQUN0QyxHQUFHLGdCQUFnQixDQUFDLFVBQVU7TUFFakMsRUFBQzs7O0FBR1A7QUFFRDs7OztBQUlHO0FBQ0csU0FBVSxVQUFVLENBQUMsZUFBd0M7O0VBRWpFLE9BQU8sSUFBQSxtQ0FBNkI7O0VBRWxDLElBQUksQ0FBQyxTQUFTLENBQUM7SUFBRSxPQUFPLEVBQUUsQ0FBQztJQUFFLFVBQVUsRUFBRTtFQUFlLENBQUUsQ0FBQyxDQUM1RCxDQUFDLE1BQU07QUFDVjs7QUNoVEE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBU0csU0FBVSxzQkFBc0IsQ0FBQyxPQUFnQjtFQUNyRCxrQkFBa0IsQ0FDaEIsSUFBSSxvQkFBUyxDQUNYLGlCQUFpQixFQUNqQixTQUFTLElBQUksSUFBSSx5QkFBeUIsQ0FBQyxTQUFTLENBQUMsd0NBRXRELENBQ0Y7RUFDRCxrQkFBa0IsQ0FDaEIsSUFBSSxvQkFBUyxDQUNYLFdBQVcsRUFDWCxTQUFTLElBQUksSUFBSSxvQkFBb0IsQ0FBQyxTQUFTLENBQUMsd0NBRWpELENBQ0Y7O0VBR0QsZUFBZSxDQUFDLE1BQUksRUFBRSxTQUFPLEVBQUUsT0FBTyxDQUFDOztFQUV2QyxlQUFlLENBQUMsTUFBSSxFQUFFLFNBQU8sRUFBRSxTQUFrQixDQUFDOztFQUVsRCxlQUFlLENBQUMsU0FBUyxFQUFFLEVBQUUsQ0FBQztBQUNoQzs7QUM5Q0E7Ozs7O0FBS0c7QUF5Qkgsc0JBQXNCLENBQUMsRUFBaUIsQ0FBQzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDTHpDOztBQUVHO01BQ1UsU0FBUztFQVdwQjs7Ozs7QUFLRztFQUNILFlBQ1csSUFBTyxFQUNQLGVBQW1DLEVBQ25DLElBQW1CO0lBRm5CLElBQUksQ0FBQSxJQUFBLEdBQUosSUFBSTtJQUNKLElBQWUsQ0FBQSxlQUFBLEdBQWYsZUFBZTtJQUNmLElBQUksQ0FBQSxJQUFBLEdBQUosSUFBSTtJQW5CZixJQUFpQixDQUFBLGlCQUFBLEdBQUcsS0FBSztJQUN6Qjs7QUFFRztJQUNILElBQVksQ0FBQSxZQUFBLEdBQWUsRUFBRTtJQUU3QixLQUFBLGlCQUFpQixHQUEwQjtJQUUzQyxJQUFpQixDQUFBLGlCQUFBLEdBQXdDLElBQUk7O0VBYzdELG9CQUFvQixDQUFDLElBQXVCO0lBQzFDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxJQUFJO0lBQzdCLE9BQU8sSUFBSTs7RUFHYixvQkFBb0IsQ0FBQyxpQkFBMEI7SUFDN0MsSUFBSSxDQUFDLGlCQUFpQixHQUFHLGlCQUFpQjtJQUMxQyxPQUFPLElBQUk7O0VBR2IsZUFBZSxDQUFDLEtBQWlCO0lBQy9CLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSztJQUN6QixPQUFPLElBQUk7O0VBR2IsMEJBQTBCLENBQUMsUUFBc0M7SUFDL0QsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFFBQVE7SUFDakMsT0FBTyxJQUFJOztBQUVkOztBQ3RFRDs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7QUFmSCxPQUFBLENBQUEsU0FBQSxHQUFBLFNBQUE7QUFpQk8sTUFBTSxrQkFBa0IsR0FBRyxXQUFXOztBQ2pCN0M7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBY0g7OztBQUdHO01BQ1UsUUFBUTtFQVduQixXQUNtQixDQUFBLElBQU8sRUFDUCxTQUE2QjtJQUQ3QixJQUFJLENBQUEsSUFBQSxHQUFKLElBQUk7SUFDSixJQUFTLENBQUEsU0FBQSxHQUFULFNBQVM7SUFacEIsSUFBUyxDQUFBLFNBQUEsR0FBd0IsSUFBSTtJQUM1QixLQUFBLFNBQVMsR0FBdUMsSUFBSSxHQUFHLEVBQUU7SUFDekQsS0FBQSxpQkFBaUIsR0FHOUIsSUFBSSxHQUFHLEVBQUU7SUFDSSxLQUFBLGdCQUFnQixHQUMvQixJQUFJLEdBQUcsRUFBRTtJQUNILEtBQUEsZUFBZSxHQUF3QyxJQUFJLEdBQUcsRUFBRTs7RUFPeEU7OztBQUdHO0VBQ0gsR0FBRyxDQUFDLFVBQW1COztJQUVyQixNQUFNLG9CQUFvQixHQUFHLElBQUksQ0FBQywyQkFBMkIsQ0FBQyxVQUFVLENBQUM7SUFFekUsSUFBSSxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxHQUFHLENBQUMsb0JBQW9CLENBQUMsRUFBRTtNQUNyRCxNQUFNLFFBQVEsR0FBRyxJQUFJLGNBQVEsRUFBeUI7TUFDdEQsSUFBSSxDQUFDLGlCQUFpQixDQUFDLEdBQUcsQ0FBQyxvQkFBb0IsRUFBRSxRQUFRLENBQUM7TUFFMUQsSUFDRSxJQUFJLENBQUMsYUFBYSxDQUFDLG9CQUFvQixDQUFDLElBQ3hDLElBQUksQ0FBQyxvQkFBb0IsRUFBRSxFQUMzQjs7UUFFQSxJQUFJO1VBQ0YsTUFBTSxRQUFRLEdBQUcsSUFBSSxDQUFDLHNCQUFzQixDQUFDO1lBQzNDLGtCQUFrQixFQUFFO1VBQ3JCLEVBQUM7VUFDRixJQUFJLFFBQVEsRUFBRTtZQUNaLFFBQVEsQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDOztTQUU3QixDQUFDLE9BQU8sQ0FBQyxFQUFFOzs7Ozs7SUFPaEIsT0FBTyxJQUFJLENBQUMsaUJBQWlCLENBQUMsR0FBRyxDQUFDLG9CQUFvQixDQUFFLENBQUMsT0FBTzs7RUFtQmxFLFlBQVksQ0FBQyxPQUdaOzs7SUFFQyxNQUFNLG9CQUFvQixHQUFHLElBQUksQ0FBQywyQkFBMkIsQ0FDM0QsT0FBTyxLQUFQLFFBQUEsT0FBTyxLQUFQLGtCQUFBLE9BQU8sQ0FBRSxVQUFVLENBQ3BCO0lBQ0QsTUFBTSxRQUFRLEdBQUcsQ0FBQSxFQUFBLEdBQUEsT0FBTyxLQUFQLFFBQUEsT0FBTyxLQUFQLGtCQUFBLE9BQU8sQ0FBRSxRQUFRLE1BQUksUUFBQSxFQUFBLGNBQUEsRUFBQSxRQUFLO0lBRTNDLElBQ0UsSUFBSSxDQUFDLGFBQWEsQ0FBQyxvQkFBb0IsQ0FBQyxJQUN4QyxJQUFJLENBQUMsb0JBQW9CLEVBQUUsRUFDM0I7TUFDQSxJQUFJO1FBQ0YsT0FBTyxJQUFJLENBQUMsc0JBQXNCLENBQUM7VUFDakMsa0JBQWtCLEVBQUU7UUFDckIsRUFBQztPQUNILENBQUMsT0FBTyxDQUFDLEVBQUU7UUFDVixJQUFJLFFBQVEsRUFBRTtVQUNaLE9BQU8sSUFBSTtTQUNaLE1BQU07VUFDTCxNQUFNLENBQUM7OztLQUdaLE1BQU07O01BRUwsSUFBSSxRQUFRLEVBQUU7UUFDWixPQUFPLElBQUk7T0FDWixNQUFNO1FBQ0wsTUFBTSxLQUFLLENBQUMsV0FBVyxJQUFJLENBQUMsSUFBSSxtQkFBbUIsQ0FBQzs7OztFQUsxRCxZQUFZLENBQUE7SUFDVixPQUFPLElBQUksQ0FBQyxTQUFTOztFQUd2QixZQUFZLENBQUMsU0FBdUI7SUFDbEMsSUFBSSxTQUFTLENBQUMsSUFBSSxLQUFLLElBQUksQ0FBQyxJQUFJLEVBQUU7TUFDaEMsTUFBTSxLQUFLLENBQ1QseUJBQXlCLFNBQVMsQ0FBQyxJQUFJLGlCQUFpQixJQUFJLENBQUMsSUFBSSxHQUFHLENBQ3JFOztJQUdILElBQUksSUFBSSxDQUFDLFNBQVMsRUFBRTtNQUNsQixNQUFNLEtBQUssQ0FBQyxpQkFBaUIsSUFBSSxDQUFDLElBQUksNEJBQTRCLENBQUM7O0lBR3JFLElBQUksQ0FBQyxTQUFTLEdBQUcsU0FBUzs7SUFHMUIsSUFBSSxDQUFDLElBQUksQ0FBQyxvQkFBb0IsRUFBRSxFQUFFO01BQ2hDOzs7SUFJRixJQUFJLGdCQUFnQixDQUFDLFNBQVMsQ0FBQyxFQUFFO01BQy9CLElBQUk7UUFDRixJQUFJLENBQUMsc0JBQXNCLENBQUM7VUFBRSxrQkFBa0IsRUFBRTtRQUFrQixDQUFFLENBQUM7T0FDeEUsQ0FBQyxPQUFPLENBQUMsRUFBRTs7Ozs7Ozs7OztJQVdkLEtBQUssTUFBTSxDQUNULGtCQUFrQixFQUNsQixnQkFBZ0IsQ0FDakIsSUFBSSxJQUFJLENBQUMsaUJBQWlCLENBQUMsT0FBTyxFQUFFLEVBQUU7TUFDckMsTUFBTSxvQkFBb0IsR0FDeEIsSUFBSSxDQUFDLDJCQUEyQixDQUFDLGtCQUFrQixDQUFDO01BRXRELElBQUk7O1FBRUYsTUFBTSxRQUFRLEdBQUcsSUFBSSxDQUFDLHNCQUFzQixDQUFDO1VBQzNDLGtCQUFrQixFQUFFO1FBQ3JCLEVBQUU7UUFDSCxnQkFBZ0IsQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDO09BQ25DLENBQUMsT0FBTyxDQUFDLEVBQUU7Ozs7OztFQU9oQixhQUFhLENBQUMsVUFBQSxHQUFxQixrQkFBa0I7SUFDbkQsSUFBSSxDQUFDLGlCQUFpQixDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUM7SUFDekMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUM7SUFDeEMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDOzs7O0VBS25DLE1BQU0sTUFBTSxDQUFBO0lBQ1YsTUFBTSxRQUFRLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLE1BQU0sRUFBRSxDQUFDO0lBRXBELE1BQU0sT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUNoQixHQUFHLFFBQVEsQ0FDUixNQUFNLENBQUMsT0FBTyxJQUFJLFVBQVUsSUFBSSxPQUFPLENBQUM7O0tBRXhDLEdBQUcsQ0FBQyxPQUFPLElBQUssT0FBZSxDQUFDLFFBQVMsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxFQUN0RCxHQUFHLFFBQVEsQ0FDUixNQUFNLENBQUMsT0FBTyxJQUFJLFNBQVMsSUFBSSxPQUFPLENBQUM7O0tBRXZDLEdBQUcsQ0FBQyxPQUFPLElBQUssT0FBZSxDQUFDLE9BQU8sRUFBRSxDQUFDLENBQzlDLENBQUM7O0VBR0osY0FBYyxDQUFBO0lBQ1osT0FBTyxJQUFJLENBQUMsU0FBUyxJQUFJLElBQUk7O0VBRy9CLGFBQWEsQ0FBQyxVQUFBLEdBQXFCLGtCQUFrQjtJQUNuRCxPQUFPLElBQUksQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQzs7RUFHdkMsVUFBVSxDQUFDLFVBQUEsR0FBcUIsa0JBQWtCO0lBQ2hELE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsSUFBSSxFQUFFOztFQUdwRCxVQUFVLENBQUMsSUFBQSxHQUEwQixFQUFFO0lBQ3JDLE1BQU07TUFBRSxPQUFPLEdBQUc7SUFBRSxDQUFFLEdBQUcsSUFBSTtJQUM3QixNQUFNLG9CQUFvQixHQUFHLElBQUksQ0FBQywyQkFBMkIsQ0FDM0QsSUFBSSxDQUFDLGtCQUFrQixDQUN4QjtJQUNELElBQUksSUFBSSxDQUFDLGFBQWEsQ0FBQyxvQkFBb0IsQ0FBQyxFQUFFO01BQzVDLE1BQU0sS0FBSyxDQUNULEdBQUcsSUFBSSxDQUFDLElBQUksSUFBSSxvQkFBb0IsZ0NBQWdDLENBQ3JFOztJQUdILElBQUksQ0FBQyxJQUFJLENBQUMsY0FBYyxFQUFFLEVBQUU7TUFDMUIsTUFBTSxLQUFLLENBQUMsYUFBYSxJQUFJLENBQUMsSUFBSSw4QkFBOEIsQ0FBQzs7SUFHbkUsTUFBTSxRQUFRLEdBQUcsSUFBSSxDQUFDLHNCQUFzQixDQUFDO01BQzNDLGtCQUFrQixFQUFFLG9CQUFvQjtNQUN4QztJQUNELEVBQUU7O0lBR0gsS0FBSyxNQUFNLENBQ1Qsa0JBQWtCLEVBQ2xCLGdCQUFnQixDQUNqQixJQUFJLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsRUFBRTtNQUNyQyxNQUFNLDRCQUE0QixHQUNoQyxJQUFJLENBQUMsMkJBQTJCLENBQUMsa0JBQWtCLENBQUM7TUFDdEQsSUFBSSxvQkFBb0IsS0FBSyw0QkFBNEIsRUFBRTtRQUN6RCxnQkFBZ0IsQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDOzs7SUFJdEMsT0FBTyxRQUFROztFQUdqQjs7Ozs7OztBQU9HO0VBQ0gsTUFBTSxDQUFDLFFBQTJCLEVBQUUsVUFBbUI7O0lBQ3JELE1BQU0sb0JBQW9CLEdBQUcsSUFBSSxDQUFDLDJCQUEyQixDQUFDLFVBQVUsQ0FBQztJQUN6RSxNQUFNLGlCQUFpQixHQUNyQixDQUFBLEVBQUEsT0FBSSxDQUFDLGVBQWUsQ0FBQyxHQUFHLENBQUMsb0JBQW9CLENBQUMsY0FBQSxFQUFBLGNBQUEsRUFBQSxHQUM5QyxJQUFJLEdBQUcsRUFBcUI7SUFDOUIsaUJBQWlCLENBQUMsR0FBRyxDQUFDLFFBQVEsQ0FBQztJQUMvQixJQUFJLENBQUMsZUFBZSxDQUFDLEdBQUcsQ0FBQyxvQkFBb0IsRUFBRSxpQkFBaUIsQ0FBQztJQUVqRSxNQUFNLGdCQUFnQixHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLG9CQUFvQixDQUFDO0lBQ2pFLElBQUksZ0JBQWdCLEVBQUU7TUFDcEIsUUFBUSxDQUFDLGdCQUFnQixFQUFFLG9CQUFvQixDQUFDOztJQUdsRCxPQUFPLE1BQUs7TUFDVixpQkFBaUIsQ0FBQyxNQUFNLENBQUMsUUFBUSxDQUFDO0lBQ3BDLENBQUM7O0VBR0g7OztBQUdHO0VBQ0sscUJBQXFCLENBQzNCLFFBQStCLEVBQy9CLFVBQWtCO0lBRWxCLE1BQU0sU0FBUyxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQztJQUN0RCxJQUFJLENBQUMsU0FBUyxFQUFFO01BQ2Q7O0lBRUYsS0FBSyxNQUFNLFFBQVEsSUFBSSxTQUFTLEVBQUU7TUFDaEMsSUFBSTtRQUNGLFFBQVEsQ0FBQyxRQUFRLEVBQUUsVUFBVSxDQUFDO09BQy9CLENBQUMsT0FBQSxFQUFBLEVBQU07Ozs7O0VBTUosc0JBQXNCLENBQUM7SUFDN0Isa0JBQWtCO0lBQ2xCLE9BQU8sR0FBRztFQUFFLENBSWI7SUFDQyxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztJQUNyRCxJQUFJLENBQUMsUUFBUSxJQUFJLElBQUksQ0FBQyxTQUFTLEVBQUU7TUFDL0IsUUFBUSxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUU7UUFDeEQsa0JBQWtCLEVBQUUsNkJBQTZCLENBQUMsa0JBQWtCLENBQUM7UUFDckU7TUFDRCxFQUFDO01BQ0YsSUFBSSxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsa0JBQWtCLEVBQUUsUUFBUSxDQUFDO01BQ2hELElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLENBQUMsa0JBQWtCLEVBQUUsT0FBTyxDQUFDO01BRXREOzs7O0FBSUc7TUFDSCxJQUFJLENBQUMscUJBQXFCLENBQUMsUUFBUSxFQUFFLGtCQUFrQixDQUFDO01BRXhEOzs7O0FBSUc7TUFDSCxJQUFJLElBQUksQ0FBQyxTQUFTLENBQUMsaUJBQWlCLEVBQUU7UUFDcEMsSUFBSTtVQUNGLElBQUksQ0FBQyxTQUFTLENBQUMsaUJBQWlCLENBQzlCLElBQUksQ0FBQyxTQUFTLEVBQ2Qsa0JBQWtCLEVBQ2xCLFFBQVEsQ0FDVDtTQUNGLENBQUMsT0FBQSxFQUFBLEVBQU07Ozs7O0lBTVosT0FBTyxRQUFRLElBQUksSUFBSTs7RUFHakIsMkJBQTJCLENBQ2pDLFVBQUEsR0FBcUIsa0JBQWtCO0lBRXZDLElBQUksSUFBSSxDQUFDLFNBQVMsRUFBRTtNQUNsQixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUMsaUJBQWlCLEdBQUcsVUFBVSxHQUFHLGtCQUFrQjtLQUMxRSxNQUFNO01BQ0wsT0FBTyxVQUFVLENBQUM7OztFQUlkLG9CQUFvQixDQUFBO0lBQzFCLE9BQ0UsQ0FBQyxDQUFDLElBQUksQ0FBQyxTQUFTLElBQ2hCLElBQUksQ0FBQyxTQUFTLENBQUMsaUJBQWlCOztBQUdyQztBQUVEO0FBQUEsT0FBQSxDQUFBLFFBQUEsR0FBQSxRQUFBO0FBQ0EsU0FBUyw2QkFBNkIsQ0FBQyxVQUFrQjtFQUN2RCxPQUFPLFVBQVUsS0FBSyxrQkFBa0IsR0FBRyxTQUFTLEdBQUcsVUFBVTtBQUNuRTtBQUVBLFNBQVMsZ0JBQWdCLENBQWlCLFNBQXVCO0VBQy9ELE9BQU8sU0FBUyxDQUFDLGlCQUFpQjtBQUNwQzs7QUN6WEE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBTUg7O0FBRUc7TUFDVSxrQkFBa0I7RUFHN0IsWUFBNkIsSUFBWTtJQUFaLElBQUksQ0FBQSxJQUFBLEdBQUosSUFBSTtJQUZoQixLQUFBLFNBQVMsR0FBRyxJQUFJLEdBQUcsRUFBMEI7O0VBSTlEOzs7Ozs7OztBQVFHO0VBQ0gsWUFBWSxDQUFpQixTQUF1QjtJQUNsRCxNQUFNLFFBQVEsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUM7SUFDakQsSUFBSSxRQUFRLENBQUMsY0FBYyxFQUFFLEVBQUU7TUFDN0IsTUFBTSxJQUFJLEtBQUssQ0FDYixhQUFhLFNBQVMsQ0FBQyxJQUFJLHFDQUFxQyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQzVFOztJQUdILFFBQVEsQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDOztFQUdsQyx1QkFBdUIsQ0FBaUIsU0FBdUI7SUFDN0QsTUFBTSxRQUFRLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDO0lBQ2pELElBQUksUUFBUSxDQUFDLGNBQWMsRUFBRSxFQUFFOztNQUU3QixJQUFJLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDOztJQUd2QyxJQUFJLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBQzs7RUFHOUI7Ozs7OztBQU1HO0VBQ0gsV0FBVyxDQUFpQixJQUFPO0lBQ2pDLElBQUksSUFBSSxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLEVBQUU7TUFDNUIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQTJCOzs7SUFJM0QsTUFBTSxRQUFRLEdBQUcsSUFBSSxRQUFRLENBQUksSUFBSSxFQUFFLElBQUksQ0FBQztJQUM1QyxJQUFJLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxJQUFJLEVBQUUsUUFBcUMsQ0FBQztJQUUvRCxPQUFPLFFBQXVCOztFQUdoQyxZQUFZLENBQUE7SUFDVixPQUFPLEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxNQUFNLEVBQUUsQ0FBQzs7QUFFN0M7QUFBQSxPQUFBLENBQUEsa0JBQUEsR0FBQSxrQkFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ2pGRDs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7QUFJSSxNQUFNLGtCQUFrQixHQUFHLEtBQUs7QUFFaEMsTUFBTSxlQUFlLEdBQUcsS0FBSyxPQUFPLEVBQUU7QUFDdEMsTUFBTSxxQkFBcUIsR0FBRyxRQUFRO0FBRXRDLE1BQU0scUJBQXFCLEdBQ2hDLGlEQUFpRDtBQUU1QyxNQUFNLHVCQUF1QixHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsSUFBSSxDQUFDO0FBRS9DLE1BQU0sT0FBTyxHQUFHLGVBQWU7QUFDL0IsTUFBTSxZQUFZLEdBQUcsZUFBZTs7QUM5QjNDOzs7Ozs7Ozs7Ozs7Ozs7QUFlRztBQWNILE1BQU0scUJBQXFCLEdBQTRDO0VBQ3JFLHlFQUNFLGlEQUFpRDtFQUNuRCxtREFBNEIsMENBQTBDO0VBQ3RFLG1FQUFvQyxrQ0FBa0M7RUFDdEUsbURBQ0UsNEZBQTRGO0VBQzlGLDZDQUF5QixpREFBaUQ7RUFDMUUsNkVBQ0U7Q0FDSDtBQVlNLE1BQU0sYUFBYSxHQUFHLElBQUksa0JBQVksQ0FDM0MsT0FBTyxFQUNQLFlBQVksRUFDWixxQkFBcUIsQ0FDdEI7QUFVRDtBQUNNLFNBQVUsYUFBYSxDQUFDLEtBQWM7RUFDMUMsT0FDRSxLQUFLLFlBQVksbUJBQWEsSUFDOUIsS0FBSyxDQUFDLElBQUksQ0FBQyxRQUFRLGlEQUEwQjtBQUVqRDs7QUN2RUE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBZ0JhLFNBQUEsd0JBQXdCLENBQUM7RUFBRTtBQUFTLENBQWE7RUFDL0QsT0FBTyxHQUFHLHFCQUFxQixhQUFhLFNBQVMsZ0JBQWdCO0FBQ3ZFO0FBRU0sU0FBVSxnQ0FBZ0MsQ0FDOUMsUUFBbUM7RUFFbkMsT0FBTztJQUNMLEtBQUssRUFBRSxRQUFRLENBQUMsS0FBSztJQUNyQixhQUFhLEVBQXlCO0lBQ3RDLFNBQVMsRUFBRSxpQ0FBaUMsQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDO0lBQ2hFLFlBQVksRUFBRSxJQUFJLENBQUMsR0FBRztHQUN2QjtBQUNIO0FBRU8sZUFBZSxvQkFBb0IsQ0FDeEMsV0FBbUIsRUFDbkIsUUFBa0I7RUFFbEIsTUFBTSxZQUFZLEdBQWtCLE1BQU0sUUFBUSxDQUFDLElBQUksRUFBRTtFQUN6RCxNQUFNLFNBQVMsR0FBRyxZQUFZLENBQUMsS0FBSztFQUNwQyxPQUFPLGFBQWEsQ0FBQyxNQUFNLENBQTJCO0lBQ3BELFdBQVc7SUFDWCxVQUFVLEVBQUUsU0FBUyxDQUFDLElBQUk7SUFDMUIsYUFBYSxFQUFFLFNBQVMsQ0FBQyxPQUFPO0lBQ2hDLFlBQVksRUFBRSxTQUFTLENBQUM7RUFDekIsRUFBQztBQUNKO0FBRWdCLFNBQUEsVUFBVSxDQUFDO0VBQUU7QUFBTSxDQUFhO0VBQzlDLE9BQU8sSUFBSSxPQUFPLENBQUM7SUFDakIsY0FBYyxFQUFFLGtCQUFrQjtJQUNsQyxNQUFNLEVBQUUsa0JBQWtCO0lBQzFCLGdCQUFnQixFQUFFO0VBQ25CLEVBQUM7QUFDSjtTQUVnQixrQkFBa0IsQ0FDaEMsU0FBb0IsRUFDcEI7RUFBRTtBQUFZLENBQStCO0VBRTdDLE1BQU0sT0FBTyxHQUFHLFVBQVUsQ0FBQyxTQUFTLENBQUM7RUFDckMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxlQUFlLEVBQUUsc0JBQXNCLENBQUMsWUFBWSxDQUFDLENBQUM7RUFDckUsT0FBTyxPQUFPO0FBQ2hCO0FBVUE7Ozs7QUFJRztBQUNJLGVBQWUsa0JBQWtCLENBQ3RDLEVBQTJCO0VBRTNCLE1BQU0sTUFBTSxHQUFHLE1BQU0sRUFBRSxFQUFFO0VBRXpCLElBQUksTUFBTSxDQUFDLE1BQU0sSUFBSSxHQUFHLElBQUksTUFBTSxDQUFDLE1BQU0sR0FBRyxHQUFHLEVBQUU7O0lBRS9DLE9BQU8sRUFBRSxFQUFFOztFQUdiLE9BQU8sTUFBTTtBQUNmO0FBRUEsU0FBUyxpQ0FBaUMsQ0FBQyxpQkFBeUI7O0VBRWxFLE9BQU8sTUFBTSxDQUFDLGlCQUFpQixDQUFDLE9BQU8sQ0FBQyxHQUFHLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFDdEQ7QUFFQSxTQUFTLHNCQUFzQixDQUFDLFlBQW9CO0VBQ2xELE9BQU8sR0FBRyxxQkFBcUIsSUFBSSxZQUFZLEVBQUU7QUFDbkQ7O0FDOUdBOzs7Ozs7Ozs7Ozs7Ozs7QUFlRztBQWtCSSxlQUFlLHlCQUF5QixDQUM3QztFQUFFLFNBQVM7RUFBRTtBQUF3QixDQUE2QixFQUNsRTtFQUFFO0FBQUcsQ0FBK0I7RUFFcEMsTUFBTSxRQUFRLEdBQUcsd0JBQXdCLENBQUMsU0FBUyxDQUFDO0VBRXBELE1BQU0sT0FBTyxHQUFHLFVBQVUsQ0FBQyxTQUFTLENBQUM7O0VBR3JDLE1BQU0sZ0JBQWdCLEdBQUcsd0JBQXdCLENBQUMsWUFBWSxDQUFDO0lBQzdELFFBQVEsRUFBRTtFQUNYLEVBQUM7RUFDRixJQUFJLGdCQUFnQixFQUFFO0lBQ3BCLE1BQU0sZ0JBQWdCLEdBQUcsTUFBTSxnQkFBZ0IsQ0FBQyxtQkFBbUIsRUFBRTtJQUNyRSxJQUFJLGdCQUFnQixFQUFFO01BQ3BCLE9BQU8sQ0FBQyxNQUFNLENBQUMsbUJBQW1CLEVBQUUsZ0JBQWdCLENBQUM7OztFQUl6RCxNQUFNLElBQUksR0FBRztJQUNYLEdBQUc7SUFDSCxXQUFXLEVBQUUscUJBQXFCO0lBQ2xDLEtBQUssRUFBRSxTQUFTLENBQUMsS0FBSztJQUN0QixVQUFVLEVBQUU7R0FDYjtFQUVELE1BQU0sT0FBTyxHQUFnQjtJQUMzQixNQUFNLEVBQUUsTUFBTTtJQUNkLE9BQU87SUFDUCxJQUFJLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJO0dBQzFCO0VBRUQsTUFBTSxRQUFRLEdBQUcsTUFBTSxrQkFBa0IsQ0FBQyxNQUFNLEtBQUssQ0FBQyxRQUFRLEVBQUUsT0FBTyxDQUFDLENBQUM7RUFDekUsSUFBSSxRQUFRLENBQUMsRUFBRSxFQUFFO0lBQ2YsTUFBTSxhQUFhLEdBQStCLE1BQU0sUUFBUSxDQUFDLElBQUksRUFBRTtJQUN2RSxNQUFNLDJCQUEyQixHQUFnQztNQUMvRCxHQUFHLEVBQUUsYUFBYSxDQUFDLEdBQUcsSUFBSSxHQUFHO01BQzdCLGtCQUFrQixFQUF5QjtNQUMzQyxZQUFZLEVBQUUsYUFBYSxDQUFDLFlBQVk7TUFDeEMsU0FBUyxFQUFFLGdDQUFnQyxDQUFDLGFBQWEsQ0FBQyxTQUFTO0tBQ3BFO0lBQ0QsT0FBTywyQkFBMkI7R0FDbkMsTUFBTTtJQUNMLE1BQU0sTUFBTSxvQkFBb0IsQ0FBQyxxQkFBcUIsRUFBRSxRQUFRLENBQUM7O0FBRXJFOztBQzlFQTs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7QUFFSDtBQUNNLFNBQVUsS0FBSyxDQUFDLEVBQVU7RUFDOUIsT0FBTyxJQUFJLE9BQU8sQ0FBTyxPQUFPLElBQUc7SUFDakMsVUFBVSxDQUFDLE9BQU8sRUFBRSxFQUFFLENBQUM7RUFDekIsQ0FBQyxDQUFDO0FBQ0o7O0FDdEJBOzs7Ozs7Ozs7Ozs7Ozs7QUFlRztBQUVHLFNBQVUscUJBQXFCLENBQUMsS0FBaUI7RUFDckQsTUFBTSxHQUFHLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsR0FBRyxLQUFLLENBQUMsQ0FBQztFQUMvQyxPQUFPLEdBQUcsQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDO0FBQ3BEOztBQ3BCQTs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7QUFJSSxNQUFNLGlCQUFpQixHQUFHLG1CQUFtQjtBQUM3QyxNQUFNLFdBQVcsR0FBRyxFQUFFO0FBRTdCOzs7QUFHRztTQUNhLFdBQVcsQ0FBQTtFQUN6QixJQUFJOzs7SUFHRixNQUFNLFlBQVksR0FBRyxJQUFJLFVBQVUsQ0FBQyxFQUFFLENBQUM7SUFDdkMsTUFBTSxNQUFNLEdBQ1YsSUFBSSxDQUFDLE1BQU0sSUFBSyxJQUF3QyxDQUFDLFFBQVE7SUFDbkUsTUFBTSxDQUFDLGVBQWUsQ0FBQyxZQUFZLENBQUM7O0lBR3BDLFlBQVksQ0FBQyxDQUFDLENBQUMsR0FBRyxVQUFVLEdBQUksWUFBWSxDQUFDLENBQUMsQ0FBQyxHQUFHLFVBQVc7SUFFN0QsTUFBTSxHQUFHLEdBQUcsTUFBTSxDQUFDLFlBQVksQ0FBQztJQUVoQyxPQUFPLGlCQUFpQixDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsR0FBRyxHQUFHLEdBQUcsV0FBVztHQUN2RCxDQUFDLE9BQUEsRUFBQSxFQUFNOztJQUVOLE9BQU8sV0FBVzs7QUFFdEI7QUFFQTtBQUNBLFNBQVMsTUFBTSxDQUFDLFlBQXdCO0VBQ3RDLE1BQU0sU0FBUyxHQUFHLHFCQUFxQixDQUFDLFlBQVksQ0FBQzs7O0VBSXJELE9BQU8sU0FBUyxDQUFDLE1BQU0sQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDO0FBQ2hDOztBQ3REQTs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7QUFJSDtBQUNNLFNBQVUsTUFBTSxDQUFDLFNBQW9CO0VBQ3pDLE9BQU8sR0FBRyxTQUFTLENBQUMsT0FBTyxJQUFJLFNBQVMsQ0FBQyxLQUFLLEVBQUU7QUFDbEQ7O0FDdEJBOzs7Ozs7Ozs7Ozs7Ozs7QUFlRztBQU1ILE1BQU0sa0JBQWtCLEdBQXlDLElBQUksR0FBRyxFQUFFO0FBRTFFOzs7QUFHRztBQUNhLFNBQUEsVUFBVSxDQUFDLFNBQW9CLEVBQUUsR0FBVztFQUMxRCxNQUFNLEdBQUcsR0FBRyxNQUFNLENBQUMsU0FBUyxDQUFDO0VBRTdCLHNCQUFzQixDQUFDLEdBQUcsRUFBRSxHQUFHLENBQUM7RUFDaEMsa0JBQWtCLENBQUMsR0FBRyxFQUFFLEdBQUcsQ0FBQztBQUM5QjtBQUVnQixTQUFBLFdBQVcsQ0FDekIsU0FBb0IsRUFDcEIsUUFBNEI7OztFQUk1QixtQkFBbUIsRUFBRTtFQUVyQixNQUFNLEdBQUcsR0FBRyxNQUFNLENBQUMsU0FBUyxDQUFDO0VBRTdCLElBQUksV0FBVyxHQUFHLGtCQUFrQixDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUM7RUFDN0MsSUFBSSxDQUFDLFdBQVcsRUFBRTtJQUNoQixXQUFXLEdBQUcsSUFBSSxHQUFHLEVBQUU7SUFDdkIsa0JBQWtCLENBQUMsR0FBRyxDQUFDLEdBQUcsRUFBRSxXQUFXLENBQUM7O0VBRTFDLFdBQVcsQ0FBQyxHQUFHLENBQUMsUUFBUSxDQUFDO0FBQzNCO0FBRWdCLFNBQUEsY0FBYyxDQUM1QixTQUFvQixFQUNwQixRQUE0QjtFQUU1QixNQUFNLEdBQUcsR0FBRyxNQUFNLENBQUMsU0FBUyxDQUFDO0VBRTdCLE1BQU0sV0FBVyxHQUFHLGtCQUFrQixDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUM7RUFFL0MsSUFBSSxDQUFDLFdBQVcsRUFBRTtJQUNoQjs7RUFHRixXQUFXLENBQUMsTUFBTSxDQUFDLFFBQVEsQ0FBQztFQUM1QixJQUFJLFdBQVcsQ0FBQyxJQUFJLEtBQUssQ0FBQyxFQUFFO0lBQzFCLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUM7OztFQUloQyxxQkFBcUIsRUFBRTtBQUN6QjtBQUVBLFNBQVMsc0JBQXNCLENBQUMsR0FBVyxFQUFFLEdBQVc7RUFDdEQsTUFBTSxTQUFTLEdBQUcsa0JBQWtCLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQztFQUM3QyxJQUFJLENBQUMsU0FBUyxFQUFFO0lBQ2Q7O0VBR0YsS0FBSyxNQUFNLFFBQVEsSUFBSSxTQUFTLEVBQUU7SUFDaEMsUUFBUSxDQUFDLEdBQUcsQ0FBQzs7QUFFakI7QUFFQSxTQUFTLGtCQUFrQixDQUFDLEdBQVcsRUFBRSxHQUFXO0VBQ2xELE1BQU0sT0FBTyxHQUFHLG1CQUFtQixFQUFFO0VBQ3JDLElBQUksT0FBTyxFQUFFO0lBQ1gsT0FBTyxDQUFDLFdBQVcsQ0FBQztNQUFFLEdBQUc7TUFBRTtJQUFHLENBQUUsQ0FBQzs7RUFFbkMscUJBQXFCLEVBQUU7QUFDekI7QUFFQSxJQUFJLGdCQUFnQixHQUE0QixJQUFJO0FBQ3BEO0FBQ0EsU0FBUyxtQkFBbUIsQ0FBQTtFQUMxQixJQUFJLENBQUMsZ0JBQWdCLElBQUksa0JBQWtCLElBQUksSUFBSSxFQUFFO0lBQ25ELGdCQUFnQixHQUFHLElBQUksZ0JBQWdCLENBQUMsdUJBQXVCLENBQUM7SUFDaEUsZ0JBQWdCLENBQUMsU0FBUyxHQUFHLENBQUMsSUFBRztNQUMvQixzQkFBc0IsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsRUFBRSxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQztJQUNoRCxDQUFDOztFQUVILE9BQU8sZ0JBQWdCO0FBQ3pCO0FBRUEsU0FBUyxxQkFBcUIsQ0FBQTtFQUM1QixJQUFJLGtCQUFrQixDQUFDLElBQUksS0FBSyxDQUFDLElBQUksZ0JBQWdCLEVBQUU7SUFDckQsZ0JBQWdCLENBQUMsS0FBSyxFQUFFO0lBQ3hCLGdCQUFnQixHQUFHLElBQUk7O0FBRTNCOztBQzdHQTs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7QUFRSCxNQUFNLGFBQWEsR0FBRyxpQ0FBaUM7QUFDdkQsTUFBTSxnQkFBZ0IsR0FBRyxDQUFDO0FBQzFCLE1BQU0saUJBQWlCLEdBQUcsOEJBQThCO0FBU3hELElBQUksU0FBUyxHQUFrRCxJQUFJO0FBQ25FLFNBQVMsWUFBWSxDQUFBO0VBQ25CLElBQUksQ0FBQyxTQUFTLEVBQUU7SUFDZCxTQUFTLEdBQUcsSUFBQSxXQUFNLEVBQUMsYUFBYSxFQUFFLGdCQUFnQixFQUFFO01BQ2xELE9BQU8sRUFBRSxDQUFDLEVBQUUsRUFBRSxVQUFVLEtBQUk7Ozs7OztRQU0xQixRQUFRLFVBQVU7VUFDaEIsS0FBSyxDQUFDO1lBQ0osRUFBRSxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixDQUFDOzs7SUFHOUMsRUFBQzs7RUFFSixPQUFPLFNBQVM7QUFDbEI7QUFjQTtBQUNPLGVBQWUsR0FBRyxDQUN2QixTQUFvQixFQUNwQixLQUFnQjtFQUVoQixNQUFNLEdBQUcsR0FBRyxNQUFNLENBQUMsU0FBUyxDQUFDO0VBQzdCLE1BQU0sRUFBRSxHQUFHLE1BQU0sWUFBWSxFQUFFO0VBQy9CLE1BQU0sRUFBRSxHQUFHLEVBQUUsQ0FBQyxXQUFXLENBQUMsaUJBQWlCLEVBQUUsV0FBVyxDQUFDO0VBQ3pELE1BQU0sV0FBVyxHQUFHLEVBQUUsQ0FBQyxXQUFXLENBQUMsaUJBQWlCLENBQUM7RUFDckQsTUFBTSxRQUFRLEdBQUksTUFBTSxXQUFXLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBdUI7RUFDbEUsTUFBTSxXQUFXLENBQUMsR0FBRyxDQUFDLEtBQUssRUFBRSxHQUFHLENBQUM7RUFDakMsTUFBTSxFQUFFLENBQUMsSUFBSTtFQUViLElBQUksQ0FBQyxRQUFRLElBQUksUUFBUSxDQUFDLEdBQUcsS0FBSyxLQUFLLENBQUMsR0FBRyxFQUFFO0lBQzNDLFVBQVUsQ0FBQyxTQUFTLEVBQUUsS0FBSyxDQUFDLEdBQUcsQ0FBQzs7RUFHbEMsT0FBTyxLQUFLO0FBQ2Q7QUFFQTtBQUNPLGVBQWUsTUFBTSxDQUFDLFNBQW9CO0VBQy9DLE1BQU0sR0FBRyxHQUFHLE1BQU0sQ0FBQyxTQUFTLENBQUM7RUFDN0IsTUFBTSxFQUFFLEdBQUcsTUFBTSxZQUFZLEVBQUU7RUFDL0IsTUFBTSxFQUFFLEdBQUcsRUFBRSxDQUFDLFdBQVcsQ0FBQyxpQkFBaUIsRUFBRSxXQUFXLENBQUM7RUFDekQsTUFBTSxFQUFFLENBQUMsV0FBVyxDQUFDLGlCQUFpQixDQUFDLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQztFQUNuRCxNQUFNLEVBQUUsQ0FBQyxJQUFJO0FBQ2Y7QUFFQTs7Ozs7QUFLRztBQUNJLGVBQWUsTUFBTSxDQUMxQixTQUFvQixFQUNwQixRQUFxRTtFQUVyRSxNQUFNLEdBQUcsR0FBRyxNQUFNLENBQUMsU0FBUyxDQUFDO0VBQzdCLE1BQU0sRUFBRSxHQUFHLE1BQU0sWUFBWSxFQUFFO0VBQy9CLE1BQU0sRUFBRSxHQUFHLEVBQUUsQ0FBQyxXQUFXLENBQUMsaUJBQWlCLEVBQUUsV0FBVyxDQUFDO0VBQ3pELE1BQU0sS0FBSyxHQUFHLEVBQUUsQ0FBQyxXQUFXLENBQUMsaUJBQWlCLENBQUM7RUFDL0MsTUFBTSxRQUFRLEdBQW1DLE1BQU0sS0FBSyxDQUFDLEdBQUcsQ0FDOUQsR0FBRyxDQUNrQjtFQUN2QixNQUFNLFFBQVEsR0FBRyxRQUFRLENBQUMsUUFBUSxDQUFDO0VBRW5DLElBQUksUUFBUSxLQUFLLFNBQVMsRUFBRTtJQUMxQixNQUFNLEtBQUssQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDO0dBQ3hCLE1BQU07SUFDTCxNQUFNLEtBQUssQ0FBQyxHQUFHLENBQUMsUUFBUSxFQUFFLEdBQUcsQ0FBQzs7RUFFaEMsTUFBTSxFQUFFLENBQUMsSUFBSTtFQUViLElBQUksUUFBUSxLQUFLLENBQUMsUUFBUSxJQUFJLFFBQVEsQ0FBQyxHQUFHLEtBQUssUUFBUSxDQUFDLEdBQUcsQ0FBQyxFQUFFO0lBQzVELFVBQVUsQ0FBQyxTQUFTLEVBQUUsUUFBUSxDQUFDLEdBQUcsQ0FBQzs7RUFHckMsT0FBTyxRQUFRO0FBQ2pCOztBQzlIQTs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7QUF5Qkg7OztBQUdHO0FBQ0ksZUFBZSxvQkFBb0IsQ0FDeEMsYUFBd0M7RUFFeEMsSUFBSSxtQkFBcUU7RUFFekUsTUFBTSxpQkFBaUIsR0FBRyxNQUFNLE1BQU0sQ0FBQyxhQUFhLENBQUMsU0FBUyxFQUFFLFFBQVEsSUFBRztJQUN6RSxNQUFNLGlCQUFpQixHQUFHLCtCQUErQixDQUFDLFFBQVEsQ0FBQztJQUNuRSxNQUFNLGdCQUFnQixHQUFHLDhCQUE4QixDQUNyRCxhQUFhLEVBQ2IsaUJBQWlCLENBQ2xCO0lBQ0QsbUJBQW1CLEdBQUcsZ0JBQWdCLENBQUMsbUJBQW1CO0lBQzFELE9BQU8sZ0JBQWdCLENBQUMsaUJBQWlCO0VBQzNDLENBQUMsQ0FBQztFQUVGLElBQUksaUJBQWlCLENBQUMsR0FBRyxLQUFLLFdBQVcsRUFBRTs7SUFFekMsT0FBTztNQUFFLGlCQUFpQixFQUFFLE1BQU07SUFBb0IsQ0FBRTs7RUFHMUQsT0FBTztJQUNMLGlCQUFpQjtJQUNqQjtHQUNEO0FBQ0g7QUFFQTs7O0FBR0c7QUFDSCxTQUFTLCtCQUErQixDQUN0QyxRQUF1QztFQUV2QyxNQUFNLEtBQUssR0FBc0IsUUFBUSxJQUFJO0lBQzNDLEdBQUcsRUFBRSxXQUFXLEVBQUU7SUFDbEIsa0JBQWtCLEVBQTJCO0dBQzlDO0VBRUQsT0FBTyxvQkFBb0IsQ0FBQyxLQUFLLENBQUM7QUFDcEM7QUFFQTs7Ozs7O0FBTUc7QUFDSCxTQUFTLDhCQUE4QixDQUNyQyxhQUF3QyxFQUN4QyxpQkFBb0M7RUFFcEMsSUFBSSxpQkFBaUIsQ0FBQyxrQkFBa0Isd0NBQWdDO0lBQ3RFLElBQUksQ0FBQyxTQUFTLENBQUMsTUFBTSxFQUFFOztNQUVyQixNQUFNLDRCQUE0QixHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQ2pELGFBQWEsQ0FBQyxNQUFNLENBQXVCLDJDQUM1QztNQUNELE9BQU87UUFDTCxpQkFBaUI7UUFDakIsbUJBQW1CLEVBQUU7T0FDdEI7OztJQUlILE1BQU0sZUFBZSxHQUFnQztNQUNuRCxHQUFHLEVBQUUsaUJBQWlCLENBQUMsR0FBRztNQUMxQixrQkFBa0IsRUFBMkI7TUFDN0MsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLEdBQUc7S0FDM0I7SUFDRCxNQUFNLG1CQUFtQixHQUFHLG9CQUFvQixDQUM5QyxhQUFhLEVBQ2IsZUFBZSxDQUNoQjtJQUNELE9BQU87TUFBRSxpQkFBaUIsRUFBRSxlQUFlO01BQUU7SUFBbUIsQ0FBRTtHQUNuRSxNQUFNLElBQ0wsaUJBQWlCLENBQUMsa0JBQWtCLHdDQUNwQztJQUNBLE9BQU87TUFDTCxpQkFBaUI7TUFDakIsbUJBQW1CLEVBQUUsd0JBQXdCLENBQUMsYUFBYTtLQUM1RDtHQUNGLE1BQU07SUFDTCxPQUFPO01BQUU7SUFBaUIsQ0FBRTs7QUFFaEM7QUFFQTtBQUNBLGVBQWUsb0JBQW9CLENBQ2pDLGFBQXdDLEVBQ3hDLGlCQUE4QztFQUU5QyxJQUFJO0lBQ0YsTUFBTSwyQkFBMkIsR0FBRyxNQUFNLHlCQUF5QixDQUNqRSxhQUFhLEVBQ2IsaUJBQWlCLENBQ2xCO0lBQ0QsT0FBTyxHQUFHLENBQUMsYUFBYSxDQUFDLFNBQVMsRUFBRSwyQkFBMkIsQ0FBQztHQUNqRSxDQUFDLE9BQU8sQ0FBQyxFQUFFO0lBQ1YsSUFBSSxhQUFhLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLEtBQUssR0FBRyxFQUFFOzs7TUFHdkQsTUFBTSxNQUFNLENBQUMsYUFBYSxDQUFDLFNBQVMsQ0FBQztLQUN0QyxNQUFNOztNQUVMLE1BQU0sR0FBRyxDQUFDLGFBQWEsQ0FBQyxTQUFTLEVBQUU7UUFDakMsR0FBRyxFQUFFLGlCQUFpQixDQUFDLEdBQUc7UUFDMUIsa0JBQWtCLEVBQTJCO01BQzlDLEVBQUM7O0lBRUosTUFBTSxDQUFDOztBQUVYO0FBRUE7QUFDQSxlQUFlLHdCQUF3QixDQUNyQyxhQUF3Qzs7OztFQU14QyxJQUFJLEtBQUssR0FBc0IsTUFBTSx5QkFBeUIsQ0FDNUQsYUFBYSxDQUFDLFNBQVMsQ0FDeEI7RUFDRCxPQUFPLEtBQUssQ0FBQyxrQkFBa0Isd0NBQWdDOztJQUU3RCxNQUFNLEtBQUssQ0FBQyxHQUFHLENBQUM7SUFFaEIsS0FBSyxHQUFHLE1BQU0seUJBQXlCLENBQUMsYUFBYSxDQUFDLFNBQVMsQ0FBQzs7RUFHbEUsSUFBSSxLQUFLLENBQUMsa0JBQWtCLHdDQUFnQzs7SUFFMUQsTUFBTTtNQUFFLGlCQUFpQjtNQUFFO0lBQW1CLENBQUUsR0FDOUMsTUFBTSxvQkFBb0IsQ0FBQyxhQUFhLENBQUM7SUFFM0MsSUFBSSxtQkFBbUIsRUFBRTtNQUN2QixPQUFPLG1CQUFtQjtLQUMzQixNQUFNOztNQUVMLE9BQU8saUJBQWdEOzs7RUFJM0QsT0FBTyxLQUFLO0FBQ2Q7QUFFQTs7Ozs7OztBQU9HO0FBQ0gsU0FBUyx5QkFBeUIsQ0FDaEMsU0FBb0I7RUFFcEIsT0FBTyxNQUFNLENBQUMsU0FBUyxFQUFFLFFBQVEsSUFBRztJQUNsQyxJQUFJLENBQUMsUUFBUSxFQUFFO01BQ2IsTUFBTSxhQUFhLENBQUMsTUFBTSxpRUFBa0M7O0lBRTlELE9BQU8sb0JBQW9CLENBQUMsUUFBUSxDQUFDO0VBQ3ZDLENBQUMsQ0FBQztBQUNKO0FBRUEsU0FBUyxvQkFBb0IsQ0FBQyxLQUF3QjtFQUNwRCxJQUFJLDhCQUE4QixDQUFDLEtBQUssQ0FBQyxFQUFFO0lBQ3pDLE9BQU87TUFDTCxHQUFHLEVBQUUsS0FBSyxDQUFDLEdBQUc7TUFDZCxrQkFBa0IsRUFBMkI7S0FDOUM7O0VBR0gsT0FBTyxLQUFLO0FBQ2Q7QUFFQSxTQUFTLDhCQUE4QixDQUNyQyxpQkFBb0M7RUFFcEMsT0FDRSxpQkFBaUIsQ0FBQyxrQkFBa0IsS0FBOEIscUNBQ2xFLGlCQUFpQixDQUFDLGdCQUFnQixHQUFHLGtCQUFrQixHQUFHLElBQUksQ0FBQyxHQUFHLEVBQUU7QUFFeEU7O0FDck9BOzs7Ozs7Ozs7Ozs7Ozs7QUFlRztBQW9CSSxlQUFlLHdCQUF3QixDQUM1QztFQUFFLFNBQVM7RUFBRTtBQUF3QixDQUE2QixFQUNsRSxpQkFBOEM7RUFFOUMsTUFBTSxRQUFRLEdBQUcsNEJBQTRCLENBQUMsU0FBUyxFQUFFLGlCQUFpQixDQUFDO0VBRTNFLE1BQU0sT0FBTyxHQUFHLGtCQUFrQixDQUFDLFNBQVMsRUFBRSxpQkFBaUIsQ0FBQzs7RUFHaEUsTUFBTSxnQkFBZ0IsR0FBRyx3QkFBd0IsQ0FBQyxZQUFZLENBQUM7SUFDN0QsUUFBUSxFQUFFO0VBQ1gsRUFBQztFQUNGLElBQUksZ0JBQWdCLEVBQUU7SUFDcEIsTUFBTSxnQkFBZ0IsR0FBRyxNQUFNLGdCQUFnQixDQUFDLG1CQUFtQixFQUFFO0lBQ3JFLElBQUksZ0JBQWdCLEVBQUU7TUFDcEIsT0FBTyxDQUFDLE1BQU0sQ0FBQyxtQkFBbUIsRUFBRSxnQkFBZ0IsQ0FBQzs7O0VBSXpELE1BQU0sSUFBSSxHQUFHO0lBQ1gsWUFBWSxFQUFFO01BQ1osVUFBVSxFQUFFLGVBQWU7TUFDM0IsS0FBSyxFQUFFLFNBQVMsQ0FBQztJQUNsQjtHQUNGO0VBRUQsTUFBTSxPQUFPLEdBQWdCO0lBQzNCLE1BQU0sRUFBRSxNQUFNO0lBQ2QsT0FBTztJQUNQLElBQUksRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUk7R0FDMUI7RUFFRCxNQUFNLFFBQVEsR0FBRyxNQUFNLGtCQUFrQixDQUFDLE1BQU0sS0FBSyxDQUFDLFFBQVEsRUFBRSxPQUFPLENBQUMsQ0FBQztFQUN6RSxJQUFJLFFBQVEsQ0FBQyxFQUFFLEVBQUU7SUFDZixNQUFNLGFBQWEsR0FBOEIsTUFBTSxRQUFRLENBQUMsSUFBSSxFQUFFO0lBQ3RFLE1BQU0sa0JBQWtCLEdBQ3RCLGdDQUFnQyxDQUFDLGFBQWEsQ0FBQztJQUNqRCxPQUFPLGtCQUFrQjtHQUMxQixNQUFNO0lBQ0wsTUFBTSxNQUFNLG9CQUFvQixDQUFDLHFCQUFxQixFQUFFLFFBQVEsQ0FBQzs7QUFFckU7QUFFQSxTQUFTLDRCQUE0QixDQUNuQyxTQUFvQixFQUNwQjtFQUFFO0FBQUcsQ0FBK0I7RUFFcEMsT0FBTyxHQUFHLHdCQUF3QixDQUFDLFNBQVMsQ0FBQyxJQUFJLEdBQUcsc0JBQXNCO0FBQzVFOztBQ25GQTs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7QUFvQkg7Ozs7O0FBS0c7QUFDSSxlQUFlLGdCQUFnQixDQUNwQyxhQUF3QyxFQUN4QyxZQUFZLEdBQUcsS0FBSztFQUVwQixJQUFJLFlBQXFEO0VBQ3pELE1BQU0sS0FBSyxHQUFHLE1BQU0sTUFBTSxDQUFDLGFBQWEsQ0FBQyxTQUFTLEVBQUUsUUFBUSxJQUFHO0lBQzdELElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLENBQUMsRUFBRTtNQUNoQyxNQUFNLGFBQWEsQ0FBQyxNQUFNLGlEQUEwQjs7SUFHdEQsTUFBTSxZQUFZLEdBQUcsUUFBUSxDQUFDLFNBQVM7SUFDdkMsSUFBSSxDQUFDLFlBQVksSUFBSSxnQkFBZ0IsQ0FBQyxZQUFZLENBQUMsRUFBRTs7TUFFbkQsT0FBTyxRQUFRO0tBQ2hCLE1BQU0sSUFBSSxZQUFZLENBQUMsYUFBYSx3Q0FBZ0M7O01BRW5FLFlBQVksR0FBRyx5QkFBeUIsQ0FBQyxhQUFhLEVBQUUsWUFBWSxDQUFDO01BQ3JFLE9BQU8sUUFBUTtLQUNoQixNQUFNOztNQUVMLElBQUksQ0FBQyxTQUFTLENBQUMsTUFBTSxFQUFFO1FBQ3JCLE1BQU0sYUFBYSxDQUFDLE1BQU0sMkNBQXVCOztNQUduRCxNQUFNLGVBQWUsR0FBRyxtQ0FBbUMsQ0FBQyxRQUFRLENBQUM7TUFDckUsWUFBWSxHQUFHLHdCQUF3QixDQUFDLGFBQWEsRUFBRSxlQUFlLENBQUM7TUFDdkUsT0FBTyxlQUFlOztFQUUxQixDQUFDLENBQUM7RUFFRixNQUFNLFNBQVMsR0FBRyxZQUFZLEdBQzFCLE1BQU0sWUFBWSxHQUNqQixLQUFLLENBQUMsU0FBZ0M7RUFDM0MsT0FBTyxTQUFTO0FBQ2xCO0FBRUE7Ozs7O0FBS0c7QUFDSCxlQUFlLHlCQUF5QixDQUN0QyxhQUF3QyxFQUN4QyxZQUFxQjs7OztFQU1yQixJQUFJLEtBQUssR0FBRyxNQUFNLHNCQUFzQixDQUFDLGFBQWEsQ0FBQyxTQUFTLENBQUM7RUFDakUsT0FBTyxLQUFLLENBQUMsU0FBUyxDQUFDLGFBQWEsd0NBQWdDOztJQUVsRSxNQUFNLEtBQUssQ0FBQyxHQUFHLENBQUM7SUFFaEIsS0FBSyxHQUFHLE1BQU0sc0JBQXNCLENBQUMsYUFBYSxDQUFDLFNBQVMsQ0FBQzs7RUFHL0QsTUFBTSxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVM7RUFDakMsSUFBSSxTQUFTLENBQUMsYUFBYSx3Q0FBZ0M7O0lBRXpELE9BQU8sZ0JBQWdCLENBQUMsYUFBYSxFQUFFLFlBQVksQ0FBQztHQUNyRCxNQUFNO0lBQ0wsT0FBTyxTQUFTOztBQUVwQjtBQUVBOzs7Ozs7O0FBT0c7QUFDSCxTQUFTLHNCQUFzQixDQUM3QixTQUFvQjtFQUVwQixPQUFPLE1BQU0sQ0FBQyxTQUFTLEVBQUUsUUFBUSxJQUFHO0lBQ2xDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLENBQUMsRUFBRTtNQUNoQyxNQUFNLGFBQWEsQ0FBQyxNQUFNLGlEQUEwQjs7SUFHdEQsTUFBTSxZQUFZLEdBQUcsUUFBUSxDQUFDLFNBQVM7SUFDdkMsSUFBSSwyQkFBMkIsQ0FBQyxZQUFZLENBQUMsRUFBRTtNQUM3QyxPQUNLLE1BQUEsQ0FBQSxNQUFBLENBQUEsTUFBQSxDQUFBLE1BQUEsS0FBQSxRQUFRO1FBQ1gsU0FBUyxFQUFFO1VBQUUsYUFBYTtRQUFBO01BQTZCLENBQ3ZEOztJQUdKLE9BQU8sUUFBUTtFQUNqQixDQUFDLENBQUM7QUFDSjtBQUVBLGVBQWUsd0JBQXdCLENBQ3JDLGFBQXdDLEVBQ3hDLGlCQUE4QztFQUU5QyxJQUFJO0lBQ0YsTUFBTSxTQUFTLEdBQUcsTUFBTSx3QkFBd0IsQ0FDOUMsYUFBYSxFQUNiLGlCQUFpQixDQUNsQjtJQUNELE1BQU0sd0JBQXdCLEdBQ3pCLE1BQUEsQ0FBQSxNQUFBLENBQUEsTUFBQSxDQUFBLE1BQUEsS0FBQSxpQkFBaUIsQ0FDcEI7TUFBQTtJQUFTLEVBQ1Y7SUFDRCxNQUFNLEdBQUcsQ0FBQyxhQUFhLENBQUMsU0FBUyxFQUFFLHdCQUF3QixDQUFDO0lBQzVELE9BQU8sU0FBUztHQUNqQixDQUFDLE9BQU8sQ0FBQyxFQUFFO0lBQ1YsSUFDRSxhQUFhLENBQUMsQ0FBQyxDQUFDLEtBQ2YsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLEtBQUssR0FBRyxJQUFJLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxLQUFLLEdBQUcsQ0FBQyxFQUNwRTs7O01BR0EsTUFBTSxNQUFNLENBQUMsYUFBYSxDQUFDLFNBQVMsQ0FBQztLQUN0QyxNQUFNO01BQ0wsTUFBTSx3QkFBd0IsR0FDekIsTUFBQSxDQUFBLE1BQUEsQ0FBQSxNQUFBLENBQUEsTUFBQSxLQUFBLGlCQUFpQixDQUNwQjtRQUFBLFNBQVMsRUFBRTtVQUFFLGFBQWE7UUFBQTtNQUE2QixFQUN4RDtNQUNELE1BQU0sR0FBRyxDQUFDLGFBQWEsQ0FBQyxTQUFTLEVBQUUsd0JBQXdCLENBQUM7O0lBRTlELE1BQU0sQ0FBQzs7QUFFWDtBQUVBLFNBQVMsaUJBQWlCLENBQ3hCLGlCQUFnRDtFQUVoRCxPQUNFLGlCQUFpQixLQUFLLFNBQVMsSUFDL0IsaUJBQWlCLENBQUMsa0JBQWtCLEtBQTRCO0FBRXBFO0FBRUEsU0FBUyxnQkFBZ0IsQ0FBQyxTQUFvQjtFQUM1QyxPQUNFLFNBQVMsQ0FBQyxhQUFhLEtBQTRCLG1DQUNuRCxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQztBQUVsQztBQUVBLFNBQVMsa0JBQWtCLENBQUMsU0FBNkI7RUFDdkQsTUFBTSxHQUFHLEdBQUcsSUFBSSxDQUFDLEdBQUcsRUFBRTtFQUN0QixPQUNFLEdBQUcsR0FBRyxTQUFTLENBQUMsWUFBWSxJQUM1QixTQUFTLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQyxTQUFTLEdBQUcsR0FBRyxHQUFHLHVCQUF1QjtBQUVoRjtBQUVBO0FBQ0EsU0FBUyxtQ0FBbUMsQ0FDMUMsUUFBcUM7RUFFckMsTUFBTSxtQkFBbUIsR0FBd0I7SUFDL0MsYUFBYSxFQUEyQjtJQUN4QyxXQUFXLEVBQUUsSUFBSSxDQUFDLEdBQUc7R0FDdEI7RUFDRCxPQUFBLE1BQUEsQ0FBQSxNQUFBLENBQUEsTUFBQSxDQUFBLE1BQUEsS0FDSyxRQUFRO0lBQ1gsU0FBUyxFQUFFO0VBQW1CLENBQzlCO0FBQ0o7QUFFQSxTQUFTLDJCQUEyQixDQUFDLFNBQW9CO0VBQ3ZELE9BQ0UsU0FBUyxDQUFDLGFBQWEsS0FBOEIscUNBQ3JELFNBQVMsQ0FBQyxXQUFXLEdBQUcsa0JBQWtCLEdBQUcsSUFBSSxDQUFDLEdBQUcsRUFBRTtBQUUzRDs7QUNyTkE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBT0g7Ozs7OztBQU1HO0FBQ0ksZUFBZSxLQUFLLENBQUMsYUFBNEI7RUFDdEQsTUFBTSxpQkFBaUIsR0FBRyxhQUEwQztFQUNwRSxNQUFNO0lBQUUsaUJBQWlCO0lBQUU7RUFBbUIsQ0FBRSxHQUFHLE1BQU0sb0JBQW9CLENBQzNFLGlCQUFpQixDQUNsQjtFQUVELElBQUksbUJBQW1CLEVBQUU7SUFDdkIsbUJBQW1CLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUM7R0FDekMsTUFBTTs7O0lBR0wsZ0JBQWdCLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQzs7RUFHMUQsT0FBTyxpQkFBaUIsQ0FBQyxHQUFHO0FBQzlCOztBQzVDQTs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7QUFPSDs7Ozs7OztBQU9HO0FBQ0ksZUFBZSxRQUFRLENBQzVCLGFBQTRCLEVBQzVCLFlBQVksR0FBRyxLQUFLO0VBRXBCLE1BQU0saUJBQWlCLEdBQUcsYUFBMEM7RUFDcEUsTUFBTSxnQ0FBZ0MsQ0FBQyxpQkFBaUIsQ0FBQzs7O0VBSXpELE1BQU0sU0FBUyxHQUFHLE1BQU0sZ0JBQWdCLENBQUMsaUJBQWlCLEVBQUUsWUFBWSxDQUFDO0VBQ3pFLE9BQU8sU0FBUyxDQUFDLEtBQUs7QUFDeEI7QUFFQSxlQUFlLGdDQUFnQyxDQUM3QyxhQUF3QztFQUV4QyxNQUFNO0lBQUU7RUFBbUIsQ0FBRSxHQUFHLE1BQU0sb0JBQW9CLENBQUMsYUFBYSxDQUFDO0VBRXpFLElBQUksbUJBQW1CLEVBQUU7O0lBRXZCLE1BQU0sbUJBQW1COztBQUU3Qjs7QUNwREE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBV0ksZUFBZSx5QkFBeUIsQ0FDN0MsU0FBb0IsRUFDcEIsaUJBQThDO0VBRTlDLE1BQU0sUUFBUSxHQUFHLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxpQkFBaUIsQ0FBQztFQUVoRSxNQUFNLE9BQU8sR0FBRyxrQkFBa0IsQ0FBQyxTQUFTLEVBQUUsaUJBQWlCLENBQUM7RUFDaEUsTUFBTSxPQUFPLEdBQWdCO0lBQzNCLE1BQU0sRUFBRSxRQUFRO0lBQ2hCO0dBQ0Q7RUFFRCxNQUFNLFFBQVEsR0FBRyxNQUFNLGtCQUFrQixDQUFDLE1BQU0sS0FBSyxDQUFDLFFBQVEsRUFBRSxPQUFPLENBQUMsQ0FBQztFQUN6RSxJQUFJLENBQUMsUUFBUSxDQUFDLEVBQUUsRUFBRTtJQUNoQixNQUFNLE1BQU0sb0JBQW9CLENBQUMscUJBQXFCLEVBQUUsUUFBUSxDQUFDOztBQUVyRTtBQUVBLFNBQVMsaUJBQWlCLENBQ3hCLFNBQW9CLEVBQ3BCO0VBQUU7QUFBRyxDQUErQjtFQUVwQyxPQUFPLEdBQUcsd0JBQXdCLENBQUMsU0FBUyxDQUFDLElBQUksR0FBRyxFQUFFO0FBQ3hEOztBQ2pEQTs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7QUFTSDs7Ozs7QUFLRztBQUNJLGVBQWUsbUJBQW1CLENBQ3ZDLGFBQTRCO0VBRTVCLE1BQU07SUFBRTtFQUFTLENBQUUsR0FBRyxhQUEwQztFQUVoRSxNQUFNLEtBQUssR0FBRyxNQUFNLE1BQU0sQ0FBQyxTQUFTLEVBQUUsUUFBUSxJQUFHO0lBQy9DLElBQUksUUFBUSxJQUFJLFFBQVEsQ0FBQyxrQkFBa0Isd0NBQWdDOztNQUV6RSxPQUFPLFNBQVM7O0lBRWxCLE9BQU8sUUFBUTtFQUNqQixDQUFDLENBQUM7RUFFRixJQUFJLEtBQUssRUFBRTtJQUNULElBQUksS0FBSyxDQUFDLGtCQUFrQix3Q0FBZ0M7O01BRTFELE1BQU0sYUFBYSxDQUFDLE1BQU0sMkVBQXVDO0tBQ2xFLE1BQU0sSUFBSSxLQUFLLENBQUMsa0JBQWtCLHNDQUE4QjtNQUMvRCxJQUFJLENBQUMsU0FBUyxDQUFDLE1BQU0sRUFBRTtRQUNyQixNQUFNLGFBQWEsQ0FBQyxNQUFNLDJDQUF1QjtPQUNsRCxNQUFNO1FBQ0wsTUFBTSx5QkFBeUIsQ0FBQyxTQUFTLEVBQUUsS0FBSyxDQUFDO1FBQ2pELE1BQU0sTUFBTSxDQUFDLFNBQVMsQ0FBQzs7OztBQUkvQjs7QUN4REE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBbUJIOzs7Ozs7OztBQVFHO0FBQ2EsU0FBQSxVQUFVLENBQ3hCLGFBQTRCLEVBQzVCLFFBQTRCO0VBRTVCLE1BQU07SUFBRTtFQUFTLENBQUUsR0FBRyxhQUEwQztFQUVoRSxXQUFXLENBQUMsU0FBUyxFQUFFLFFBQVEsQ0FBQztFQUNoQyxPQUFPLE1BQUs7SUFDVixjQUFjLENBQUMsU0FBUyxFQUFFLFFBQVEsQ0FBQztFQUNyQyxDQUFDO0FBQ0g7O0FDckRBOzs7Ozs7Ozs7Ozs7Ozs7QUFlRztBQUtIOzs7Ozs7QUFNRztBQUNhLFNBQUEsZ0JBQWdCLENBQUMsR0FBQSxHQUFtQixJQUFBLFdBQU0sR0FBRTtFQUMxRCxNQUFNLGlCQUFpQixHQUFHLElBQUEsaUJBQVksRUFBQyxHQUFHLEVBQUUsZUFBZSxDQUFDLENBQUMsWUFBWSxFQUFFO0VBQzNFLE9BQU8saUJBQWlCO0FBQzFCOztBQzlCQTs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7QUFPRyxTQUFVLGdCQUFnQixDQUFDLEdBQWdCO0VBQy9DLElBQUksQ0FBQyxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsT0FBTyxFQUFFO0lBQ3hCLE1BQU0sb0JBQW9CLENBQUMsbUJBQW1CLENBQUM7O0VBR2pELElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxFQUFFO0lBQ2IsTUFBTSxvQkFBb0IsQ0FBQyxVQUFVLENBQUM7OztFQUl4QyxNQUFNLFVBQVUsR0FBaUMsQ0FDL0MsV0FBVyxFQUNYLFFBQVEsRUFDUixPQUFPLENBQ1I7RUFFRCxLQUFLLE1BQU0sT0FBTyxJQUFJLFVBQVUsRUFBRTtJQUNoQyxJQUFJLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFBRTtNQUN6QixNQUFNLG9CQUFvQixDQUFDLE9BQU8sQ0FBQzs7O0VBSXZDLE9BQU87SUFDTCxPQUFPLEVBQUUsR0FBRyxDQUFDLElBQUk7SUFDakIsU0FBUyxFQUFFLEdBQUcsQ0FBQyxPQUFPLENBQUMsU0FBVTtJQUNqQyxNQUFNLEVBQUUsR0FBRyxDQUFDLE9BQU8sQ0FBQyxNQUFPO0lBQzNCLEtBQUssRUFBRSxHQUFHLENBQUMsT0FBTyxDQUFDO0dBQ3BCO0FBQ0g7QUFFQSxTQUFTLG9CQUFvQixDQUFDLFNBQWlCO0VBQzdDLE9BQU8sYUFBYSxDQUFDLE1BQU0sQ0FBc0M7SUFDL0Q7RUFDRCxFQUFDO0FBQ0o7O0FDeERBOzs7Ozs7Ozs7Ozs7Ozs7QUFlRztBQWNILE1BQU0sa0JBQWtCLEdBQUcsZUFBZTtBQUMxQyxNQUFNLDJCQUEyQixHQUFHLHdCQUF3QjtBQUU1RCxNQUFNLGFBQWEsR0FDakIsU0FBNkIsSUFDM0I7RUFDRixNQUFNLEdBQUcsR0FBRyxTQUFTLENBQUMsV0FBVyxDQUFDLEtBQUssQ0FBQyxDQUFDLFlBQVksRUFBRTs7RUFFdkQsTUFBTSxTQUFTLEdBQUcsZ0JBQWdCLENBQUMsR0FBRyxDQUFDO0VBQ3ZDLE1BQU0sd0JBQXdCLEdBQUcsSUFBQSxpQkFBWSxFQUFDLEdBQUcsRUFBRSxXQUFXLENBQUM7RUFFL0QsTUFBTSxpQkFBaUIsR0FBOEI7SUFDbkQsR0FBRztJQUNILFNBQVM7SUFDVCx3QkFBd0I7SUFDeEIsT0FBTyxFQUFFLENBQUEsS0FBTSxPQUFPLENBQUMsT0FBTztHQUMvQjtFQUNELE9BQU8saUJBQWlCO0FBQzFCLENBQUM7QUFFRCxNQUFNLGVBQWUsR0FDbkIsU0FBNkIsSUFDM0I7RUFDRixNQUFNLEdBQUcsR0FBRyxTQUFTLENBQUMsV0FBVyxDQUFDLEtBQUssQ0FBQyxDQUFDLFlBQVksRUFBRTs7RUFFdkQsTUFBTSxhQUFhLEdBQUcsSUFBQSxpQkFBWSxFQUFDLEdBQUcsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDLFlBQVksRUFBRTtFQUUxRSxNQUFNLHFCQUFxQixHQUFtQztJQUM1RCxLQUFLLEVBQUUsQ0FBQSxLQUFNLEtBQUssQ0FBQyxhQUFhLENBQUM7SUFDakMsUUFBUSxFQUFHLFlBQXNCLElBQUssUUFBUSxDQUFDLGFBQWEsRUFBRSxZQUFZO0dBQzNFO0VBQ0QsT0FBTyxxQkFBcUI7QUFDOUIsQ0FBQztTQUVlLHFCQUFxQixDQUFBO0VBQ25DLElBQUEsdUJBQWtCLEVBQ2hCLElBQUksb0JBQVMsQ0FBQyxrQkFBa0IsRUFBRSxhQUFhLEVBQXVCLHFDQUN2RTtFQUNELElBQUEsdUJBQWtCLEVBQ2hCLElBQUksb0JBQVMsQ0FDWCwyQkFBMkIsRUFDM0IsZUFBZSxFQUVoQix1Q0FDRjtBQUNIOztBQzFFQTs7Ozs7QUFLRztBQTBCSCxxQkFBcUIsRUFBRTtBQUN2QixJQUFBLG9CQUFlLEVBQUMsSUFBSSxFQUFFLE9BQU8sQ0FBQztBQUM5QjtBQUNBLElBQUEsb0JBQWUsRUFBQyxJQUFJLEVBQUUsT0FBTyxFQUFFLFNBQWtCLENBQUM7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDbENsRDs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7QUF1Qkg7O0FBRUc7QUFDSSxNQUFNLFNBQVMsR0FBYSxFQUFFO0FBRXJDOzs7Ozs7Ozs7O0FBVUc7QUFDUyxPQUFBLENBQUEsUUFBQTtBQUFaLFdBQVksUUFBUTtFQUNsQixRQUFBLENBQUEsUUFBQSx3QkFBSztFQUNMLFFBQUEsQ0FBQSxRQUFBLDRCQUFPO0VBQ1AsUUFBQSxDQUFBLFFBQUEsc0JBQUk7RUFDSixRQUFBLENBQUEsUUFBQSxzQkFBSTtFQUNKLFFBQUEsQ0FBQSxRQUFBLHdCQUFLO0VBQ0wsUUFBQSxDQUFBLFFBQUEsMEJBQU07QUFDUixDQUFDLEVBUFcsT0FBQSxDQUFBLFFBQVEsS0FBUixPQUFBLENBQUEsUUFBUSxHQU9uQjtBQUVELE1BQU0saUJBQWlCLEdBQTBDO0VBQy9ELE9BQU8sRUFBRSxPQUFBLENBQUEsUUFBUSxDQUFDLEtBQUs7RUFDdkIsU0FBUyxFQUFFLE9BQUEsQ0FBQSxRQUFRLENBQUMsT0FBTztFQUMzQixNQUFNLEVBQUUsT0FBQSxDQUFBLFFBQVEsQ0FBQyxJQUFJO0VBQ3JCLE1BQU0sRUFBRSxPQUFBLENBQUEsUUFBUSxDQUFDLElBQUk7RUFDckIsT0FBTyxFQUFFLE9BQUEsQ0FBQSxRQUFRLENBQUMsS0FBSztFQUN2QixRQUFRLEVBQUUsT0FBQSxDQUFBLFFBQVEsQ0FBQztDQUNwQjtBQUVEOztBQUVHO0FBQ0gsTUFBTSxlQUFlLEdBQWEsT0FBQSxDQUFBLFFBQVEsQ0FBQyxJQUFJO0FBYS9DOzs7OztBQUtHO0FBQ0gsTUFBTSxhQUFhLEdBQUc7RUFDcEIsQ0FBQyxPQUFBLENBQUEsUUFBUSxDQUFDLEtBQUssR0FBRyxLQUFLO0VBQ3ZCLENBQUMsT0FBQSxDQUFBLFFBQVEsQ0FBQyxPQUFPLEdBQUcsS0FBSztFQUN6QixDQUFDLE9BQUEsQ0FBQSxRQUFRLENBQUMsSUFBSSxHQUFHLE1BQU07RUFDdkIsQ0FBQyxPQUFBLENBQUEsUUFBUSxDQUFDLElBQUksR0FBRyxNQUFNO0VBQ3ZCLENBQUMsT0FBQSxDQUFBLFFBQVEsQ0FBQyxLQUFLLEdBQUc7Q0FDbkI7QUFFRDs7OztBQUlHO0FBQ0gsTUFBTSxpQkFBaUIsR0FBZSxDQUFDLFFBQVEsRUFBRSxPQUFPLEVBQUUsR0FBRyxJQUFJLEtBQVU7RUFDekUsSUFBSSxPQUFPLEdBQUcsUUFBUSxDQUFDLFFBQVEsRUFBRTtJQUMvQjs7RUFFRixNQUFNLEdBQUcsR0FBRyxJQUFJLElBQUksRUFBRSxDQUFDLFdBQVcsRUFBRTtFQUNwQyxNQUFNLE1BQU0sR0FBRyxhQUFhLENBQUMsT0FBcUMsQ0FBQztFQUNuRSxJQUFJLE1BQU0sRUFBRTtJQUNWLE9BQU8sQ0FBQyxNQUEyQyxDQUFDLENBQ2xELElBQUksR0FBRyxNQUFNLFFBQVEsQ0FBQyxJQUFJLEdBQUcsRUFDN0IsR0FBRyxJQUFJLENBQ1I7R0FDRixNQUFNO0lBQ0wsTUFBTSxJQUFJLEtBQUssQ0FDYiw4REFBOEQsT0FBTyxHQUFHLENBQ3pFOztBQUVMLENBQUM7TUFFWSxNQUFNO0VBQ2pCOzs7OztBQUtHO0VBQ0gsWUFBbUIsSUFBWTtJQUFaLElBQUksQ0FBQSxJQUFBLEdBQUosSUFBSTtJQU92Qjs7QUFFRztJQUNLLElBQVMsQ0FBQSxTQUFBLEdBQUcsZUFBZTtJQWtCbkM7OztBQUdHO0lBQ0ssSUFBVyxDQUFBLFdBQUEsR0FBZSxpQkFBaUI7SUFXbkQ7O0FBRUc7SUFDSyxJQUFlLENBQUEsZUFBQSxHQUFzQixJQUFJO0lBN0MvQzs7QUFFRztJQUNILFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDOztFQVF0QixJQUFJLFFBQVEsQ0FBQTtJQUNWLE9BQU8sSUFBSSxDQUFDLFNBQVM7O0VBR3ZCLElBQUksUUFBUSxDQUFDLEdBQWE7SUFDeEIsSUFBSSxFQUFFLEdBQUcsSUFBSSxPQUFBLENBQUEsUUFBUSxDQUFDLEVBQUU7TUFDdEIsTUFBTSxJQUFJLFNBQVMsQ0FBQyxrQkFBa0IsR0FBRyw0QkFBNEIsQ0FBQzs7SUFFeEUsSUFBSSxDQUFDLFNBQVMsR0FBRyxHQUFHOzs7RUFJdEIsV0FBVyxDQUFDLEdBQThCO0lBQ3hDLElBQUksQ0FBQyxTQUFTLEdBQUcsT0FBTyxHQUFHLEtBQUssUUFBUSxHQUFHLGlCQUFpQixDQUFDLEdBQUcsQ0FBQyxHQUFHLEdBQUc7O0VBUXpFLElBQUksVUFBVSxDQUFBO0lBQ1osT0FBTyxJQUFJLENBQUMsV0FBVzs7RUFFekIsSUFBSSxVQUFVLENBQUMsR0FBZTtJQUM1QixJQUFJLE9BQU8sR0FBRyxLQUFLLFVBQVUsRUFBRTtNQUM3QixNQUFNLElBQUksU0FBUyxDQUFDLG1EQUFtRCxDQUFDOztJQUUxRSxJQUFJLENBQUMsV0FBVyxHQUFHLEdBQUc7O0VBT3hCLElBQUksY0FBYyxDQUFBO0lBQ2hCLE9BQU8sSUFBSSxDQUFDLGVBQWU7O0VBRTdCLElBQUksY0FBYyxDQUFDLEdBQXNCO0lBQ3ZDLElBQUksQ0FBQyxlQUFlLEdBQUcsR0FBRzs7RUFHNUI7O0FBRUc7RUFFSCxLQUFLLENBQUMsR0FBRyxJQUFlO0lBQ3RCLElBQUksQ0FBQyxlQUFlLElBQUksSUFBSSxDQUFDLGVBQWUsQ0FBQyxJQUFJLEVBQUUsT0FBQSxDQUFBLFFBQVEsQ0FBQyxLQUFLLEVBQUUsR0FBRyxJQUFJLENBQUM7SUFDM0UsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLEVBQUUsT0FBQSxDQUFBLFFBQVEsQ0FBQyxLQUFLLEVBQUUsR0FBRyxJQUFJLENBQUM7O0VBRWpELEdBQUcsQ0FBQyxHQUFHLElBQWU7SUFDcEIsSUFBSSxDQUFDLGVBQWUsSUFDbEIsSUFBSSxDQUFDLGVBQWUsQ0FBQyxJQUFJLEVBQUUsT0FBQSxDQUFBLFFBQVEsQ0FBQyxPQUFPLEVBQUUsR0FBRyxJQUFJLENBQUM7SUFDdkQsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLEVBQUUsT0FBQSxDQUFBLFFBQVEsQ0FBQyxPQUFPLEVBQUUsR0FBRyxJQUFJLENBQUM7O0VBRW5ELElBQUksQ0FBQyxHQUFHLElBQWU7SUFDckIsSUFBSSxDQUFDLGVBQWUsSUFBSSxJQUFJLENBQUMsZUFBZSxDQUFDLElBQUksRUFBRSxPQUFBLENBQUEsUUFBUSxDQUFDLElBQUksRUFBRSxHQUFHLElBQUksQ0FBQztJQUMxRSxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksRUFBRSxPQUFBLENBQUEsUUFBUSxDQUFDLElBQUksRUFBRSxHQUFHLElBQUksQ0FBQzs7RUFFaEQsSUFBSSxDQUFDLEdBQUcsSUFBZTtJQUNyQixJQUFJLENBQUMsZUFBZSxJQUFJLElBQUksQ0FBQyxlQUFlLENBQUMsSUFBSSxFQUFFLE9BQUEsQ0FBQSxRQUFRLENBQUMsSUFBSSxFQUFFLEdBQUcsSUFBSSxDQUFDO0lBQzFFLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxFQUFFLE9BQUEsQ0FBQSxRQUFRLENBQUMsSUFBSSxFQUFFLEdBQUcsSUFBSSxDQUFDOztFQUVoRCxLQUFLLENBQUMsR0FBRyxJQUFlO0lBQ3RCLElBQUksQ0FBQyxlQUFlLElBQUksSUFBSSxDQUFDLGVBQWUsQ0FBQyxJQUFJLEVBQUUsT0FBQSxDQUFBLFFBQVEsQ0FBQyxLQUFLLEVBQUUsR0FBRyxJQUFJLENBQUM7SUFDM0UsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLEVBQUUsT0FBQSxDQUFBLFFBQVEsQ0FBQyxLQUFLLEVBQUUsR0FBRyxJQUFJLENBQUM7O0FBRWxEO0FBRUssU0FBVSxXQUFXLENBQUMsS0FBZ0M7RUFDMUQsU0FBUyxDQUFDLE9BQU8sQ0FBQyxJQUFJLElBQUc7SUFDdkIsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLENBQUM7RUFDekIsQ0FBQyxDQUFDO0FBQ0o7QUFFZ0IsU0FBQSxpQkFBaUIsQ0FDL0IsV0FBK0IsRUFDL0IsT0FBb0I7RUFFcEIsS0FBSyxNQUFNLFFBQVEsSUFBSSxTQUFTLEVBQUU7SUFDaEMsSUFBSSxjQUFjLEdBQW9CLElBQUk7SUFDMUMsSUFBSSxPQUFPLElBQUksT0FBTyxDQUFDLEtBQUssRUFBRTtNQUM1QixjQUFjLEdBQUcsaUJBQWlCLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQzs7SUFFbkQsSUFBSSxXQUFXLEtBQUssSUFBSSxFQUFFO01BQ3hCLFFBQVEsQ0FBQyxjQUFjLEdBQUcsSUFBSTtLQUMvQixNQUFNO01BQ0wsUUFBUSxDQUFDLGNBQWMsR0FBRyxDQUN4QixRQUFnQixFQUNoQixLQUFlLEVBQ2YsR0FBRyxJQUFlLEtBQ2hCO1FBQ0YsTUFBTSxPQUFPLEdBQUcsSUFBSSxDQUNqQixHQUFHLENBQUMsR0FBRyxJQUFHO1VBQ1QsSUFBSSxHQUFHLElBQUksSUFBSSxFQUFFO1lBQ2YsT0FBTyxJQUFJO1dBQ1osTUFBTSxJQUFJLE9BQU8sR0FBRyxLQUFLLFFBQVEsRUFBRTtZQUNsQyxPQUFPLEdBQUc7V0FDWCxNQUFNLElBQUksT0FBTyxHQUFHLEtBQUssUUFBUSxJQUFJLE9BQU8sR0FBRyxLQUFLLFNBQVMsRUFBRTtZQUM5RCxPQUFPLEdBQUcsQ0FBQyxRQUFRLEVBQUU7V0FDdEIsTUFBTSxJQUFJLEdBQUcsWUFBWSxLQUFLLEVBQUU7WUFDL0IsT0FBTyxHQUFHLENBQUMsT0FBTztXQUNuQixNQUFNO1lBQ0wsSUFBSTtjQUNGLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUM7YUFDM0IsQ0FBQyxPQUFPLE9BQU8sRUFBRTtjQUNoQixPQUFPLElBQUk7OztRQUdqQixDQUFDLENBQUMsQ0FDRCxNQUFNLENBQUMsR0FBRyxJQUFJLEdBQUcsQ0FBQyxDQUNsQixJQUFJLENBQUMsR0FBRyxDQUFDO1FBQ1osSUFBSSxLQUFLLEtBQUssY0FBYyxhQUFkLGNBQWMsY0FBZCxjQUFjLEdBQUksUUFBUSxDQUFDLFFBQVEsQ0FBQyxFQUFFO1VBQ2xELFdBQVcsQ0FBQztZQUNWLEtBQUssRUFBRSxPQUFBLENBQUEsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDLFdBQVcsRUFBb0I7WUFDdEQsT0FBTztZQUNQLElBQUk7WUFDSixJQUFJLEVBQUUsUUFBUSxDQUFDO1VBQ2hCLEVBQUM7O01BRU4sQ0FBQzs7O0FBR1A7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDM1FBOzs7Ozs7Ozs7Ozs7Ozs7QUFlRztBQUVJLE1BQU0sZUFBZSxHQUFHLDJCQUEyQjtBQUNuRCxNQUFNLGdCQUFnQixHQUFHLHNDQUFzQztBQUUvRCxNQUFNLGlCQUFpQixHQUM1Qix5RkFBeUY7QUFFcEYsTUFBTSxRQUFRLEdBQUcsNENBQTRDO0FBSzdELE1BQU0sbUJBQW1CLEdBQUcsaUJBQWlCO0FBQzdDLE1BQU0scUJBQXFCLEdBQUcsZ0JBQWdCO0FBQzlDLE1BQU0scUJBQXFCLEdBQUcsZUFBZTtBQUNwRDtBQUNPLE1BQU0sa0NBQWtDLEdBQUcsY0FBYztBQU16RCxNQUFNLDRCQUE0QixHQUFHLEtBQUs7QUFVakQsSUFBWSxhQUdYO0FBSEQsV0FBWSxXQUFXO0VBQ3JCLFdBQUEsQ0FBQSxXQUFBLHNDQUFnQjtFQUNoQixXQUFBLENBQUEsV0FBQSxzREFBd0I7QUFDMUIsQ0FBQyxFQUhXLGFBQVcsS0FBWCxhQUFXLEdBR3RCOztBQ25ERDs7Ozs7Ozs7Ozs7OztBQWFHO0FBZ0VILElBQVksV0FHWDtBQUhELFdBQVksV0FBVztFQUNyQixXQUFBLG1DQUErQjtFQUMvQixXQUFBLGlEQUE2QztBQUMvQyxDQUFDLEVBSFcsV0FBVyxLQUFYLFdBQVcsR0FHdEI7O0FDaEZEOzs7Ozs7Ozs7Ozs7Ozs7QUFlRztBQUVHLFNBQVUsYUFBYSxDQUFDLEtBQStCO0VBQzNELE1BQU0sVUFBVSxHQUFHLElBQUksVUFBVSxDQUFDLEtBQUssQ0FBQztFQUN4QyxNQUFNLFlBQVksR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxHQUFHLFVBQVUsQ0FBQyxDQUFDO0VBQzdELE9BQU8sWUFBWSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEVBQUUsRUFBRSxDQUFDLENBQUMsT0FBTyxDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQztBQUMvRTtBQUVNLFNBQVUsYUFBYSxDQUFDLFlBQW9CO0VBQ2hELE1BQU0sT0FBTyxHQUFHLEdBQUcsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEdBQUksWUFBWSxDQUFDLE1BQU0sR0FBRyxDQUFFLElBQUksQ0FBQyxDQUFDO0VBQy9ELE1BQU0sTUFBTSxHQUFHLENBQUMsWUFBWSxHQUFHLE9BQU8sRUFDbkMsT0FBTyxDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsQ0FDbkIsT0FBTyxDQUFDLElBQUksRUFBRSxHQUFHLENBQUM7RUFFckIsTUFBTSxPQUFPLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQztFQUM1QixNQUFNLFdBQVcsR0FBRyxJQUFJLFVBQVUsQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDO0VBRWxELEtBQUssSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsR0FBRyxPQUFPLENBQUMsTUFBTSxFQUFFLEVBQUUsQ0FBQyxFQUFFO0lBQ3ZDLFdBQVcsQ0FBQyxDQUFDLENBQUMsR0FBRyxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQzs7RUFFeEMsT0FBTyxXQUFXO0FBQ3BCOztBQ3BDQTs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7QUE4Q0gsTUFBTSxXQUFXLEdBQUcsc0JBQXNCO0FBQzFDOzs7QUFHRztBQUNILE1BQU0sY0FBYyxHQUFHLENBQUM7QUFDeEIsTUFBTSxxQkFBcUIsR0FBRyx3QkFBd0I7QUFFL0MsZUFBZSxrQkFBa0IsQ0FDdEMsUUFBZ0I7RUFFaEIsSUFBSSxXQUFXLElBQUksU0FBUyxFQUFFOzs7SUFHNUIsTUFBTSxTQUFTLEdBQUcsTUFDaEIsU0FHRCxDQUFDLFNBQVMsRUFBRTtJQUNiLE1BQU0sT0FBTyxHQUFHLFNBQVMsQ0FBQyxHQUFHLENBQUMsRUFBRSxJQUFJLEVBQUUsQ0FBQyxJQUFJLENBQUM7SUFFNUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUMsV0FBVyxDQUFDLEVBQUU7O01BRWxDLE9BQU8sSUFBSTs7O0VBSWYsSUFBSSxZQUFZLEdBQXdCLElBQUk7RUFFNUMsTUFBTSxFQUFFLEdBQUcsTUFBTSxJQUFBLFdBQU0sRUFBQyxXQUFXLEVBQUUsY0FBYyxFQUFFO0lBQ25ELE9BQU8sRUFBRSxNQUFBLENBQU8sRUFBRSxFQUFFLFVBQVUsRUFBRSxVQUFVLEVBQUUsa0JBQWtCLEtBQUk7O01BQ2hFLElBQUksVUFBVSxHQUFHLENBQUMsRUFBRTs7UUFFbEI7O01BR0YsSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FBQyxRQUFRLENBQUMscUJBQXFCLENBQUMsRUFBRTs7UUFFeEQ7O01BR0YsTUFBTSxXQUFXLEdBQUcsa0JBQWtCLENBQUMsV0FBVyxDQUFDLHFCQUFxQixDQUFDO01BQ3pFLE1BQU0sS0FBSyxHQUFHLE1BQU0sV0FBVyxDQUFDLEtBQUssQ0FBQyxhQUFhLENBQUMsQ0FBQyxHQUFHLENBQUMsUUFBUSxDQUFDO01BQ2xFLE1BQU0sV0FBVyxDQUFDLEtBQUssRUFBRTtNQUV6QixJQUFJLENBQUMsS0FBSyxFQUFFOztRQUVWOztNQUdGLElBQUksVUFBVSxLQUFLLENBQUMsRUFBRTtRQUNwQixNQUFNLFVBQVUsR0FBRyxLQUF1QjtRQUUxQyxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksSUFBSSxDQUFDLFVBQVUsQ0FBQyxNQUFNLElBQUksQ0FBQyxVQUFVLENBQUMsUUFBUSxFQUFFO1VBQ2xFOztRQUdGLFlBQVksR0FBRztVQUNiLEtBQUssRUFBRSxVQUFVLENBQUMsUUFBUTtVQUMxQixVQUFVLEVBQUUsQ0FBQSxFQUFBLEdBQUEsVUFBVSxDQUFDLFVBQVUsTUFBSSxRQUFBLEVBQUEsY0FBQSxFQUFBLEdBQUEsSUFBSSxDQUFDLEdBQUcsRUFBRTtVQUMvQyxtQkFBbUIsRUFBRTtZQUNuQixJQUFJLEVBQUUsVUFBVSxDQUFDLElBQUk7WUFDckIsTUFBTSxFQUFFLFVBQVUsQ0FBQyxNQUFNO1lBQ3pCLFFBQVEsRUFBRSxVQUFVLENBQUMsUUFBUTtZQUM3QixPQUFPLEVBQUUsVUFBVSxDQUFDLE9BQU87WUFDM0IsUUFBUSxFQUNOLE9BQU8sVUFBVSxDQUFDLFFBQVEsS0FBSyxRQUFRLEdBQ25DLFVBQVUsQ0FBQyxRQUFRLEdBQ25CLGFBQWEsQ0FBQyxVQUFVLENBQUMsUUFBUTtVQUN4QztTQUNGO09BQ0YsTUFBTSxJQUFJLFVBQVUsS0FBSyxDQUFDLEVBQUU7UUFDM0IsTUFBTSxVQUFVLEdBQUcsS0FBdUI7UUFFMUMsWUFBWSxHQUFHO1VBQ2IsS0FBSyxFQUFFLFVBQVUsQ0FBQyxRQUFRO1VBQzFCLFVBQVUsRUFBRSxVQUFVLENBQUMsVUFBVTtVQUNqQyxtQkFBbUIsRUFBRTtZQUNuQixJQUFJLEVBQUUsYUFBYSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7WUFDcEMsTUFBTSxFQUFFLGFBQWEsQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDO1lBQ3hDLFFBQVEsRUFBRSxVQUFVLENBQUMsUUFBUTtZQUM3QixPQUFPLEVBQUUsVUFBVSxDQUFDLE9BQU87WUFDM0IsUUFBUSxFQUFFLGFBQWEsQ0FBQyxVQUFVLENBQUMsUUFBUTtVQUM1QztTQUNGO09BQ0YsTUFBTSxJQUFJLFVBQVUsS0FBSyxDQUFDLEVBQUU7UUFDM0IsTUFBTSxVQUFVLEdBQUcsS0FBdUI7UUFFMUMsWUFBWSxHQUFHO1VBQ2IsS0FBSyxFQUFFLFVBQVUsQ0FBQyxRQUFRO1VBQzFCLFVBQVUsRUFBRSxVQUFVLENBQUMsVUFBVTtVQUNqQyxtQkFBbUIsRUFBRTtZQUNuQixJQUFJLEVBQUUsYUFBYSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7WUFDcEMsTUFBTSxFQUFFLGFBQWEsQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDO1lBQ3hDLFFBQVEsRUFBRSxVQUFVLENBQUMsUUFBUTtZQUM3QixPQUFPLEVBQUUsVUFBVSxDQUFDLE9BQU87WUFDM0IsUUFBUSxFQUFFLGFBQWEsQ0FBQyxVQUFVLENBQUMsUUFBUTtVQUM1QztTQUNGOzs7RUFHTixFQUFDO0VBQ0YsRUFBRSxDQUFDLEtBQUssRUFBRTs7RUFHVixNQUFNLElBQUEsYUFBUSxFQUFDLFdBQVcsQ0FBQztFQUMzQixNQUFNLElBQUEsYUFBUSxFQUFDLHNCQUFzQixDQUFDO0VBQ3RDLE1BQU0sSUFBQSxhQUFRLEVBQUMsV0FBVyxDQUFDO0VBRTNCLE9BQU8saUJBQWlCLENBQUMsWUFBWSxDQUFDLEdBQUcsWUFBWSxHQUFHLElBQUk7QUFDOUQ7QUFFQSxTQUFTLGlCQUFpQixDQUN4QixZQUFpQztFQUVqQyxJQUFJLENBQUMsWUFBWSxJQUFJLENBQUMsWUFBWSxDQUFDLG1CQUFtQixFQUFFO0lBQ3RELE9BQU8sS0FBSzs7RUFFZCxNQUFNO0lBQUU7RUFBbUIsQ0FBRSxHQUFHLFlBQVk7RUFDNUMsT0FDRSxPQUFPLFlBQVksQ0FBQyxVQUFVLEtBQUssUUFBUSxJQUMzQyxZQUFZLENBQUMsVUFBVSxHQUFHLENBQUMsSUFDM0IsT0FBTyxZQUFZLENBQUMsS0FBSyxLQUFLLFFBQVEsSUFDdEMsWUFBWSxDQUFDLEtBQUssQ0FBQyxNQUFNLEdBQUcsQ0FBQyxJQUM3QixPQUFPLG1CQUFtQixDQUFDLElBQUksS0FBSyxRQUFRLElBQzVDLG1CQUFtQixDQUFDLElBQUksQ0FBQyxNQUFNLEdBQUcsQ0FBQyxJQUNuQyxPQUFPLG1CQUFtQixDQUFDLE1BQU0sS0FBSyxRQUFRLElBQzlDLG1CQUFtQixDQUFDLE1BQU0sQ0FBQyxNQUFNLEdBQUcsQ0FBQyxJQUNyQyxPQUFPLG1CQUFtQixDQUFDLFFBQVEsS0FBSyxRQUFRLElBQ2hELG1CQUFtQixDQUFDLFFBQVEsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxJQUN2QyxPQUFPLG1CQUFtQixDQUFDLE9BQU8sS0FBSyxRQUFRLElBQy9DLG1CQUFtQixDQUFDLE9BQU8sQ0FBQyxNQUFNLEdBQUcsQ0FBQyxJQUN0QyxPQUFPLG1CQUFtQixDQUFDLFFBQVEsS0FBSyxRQUFRLElBQ2hELG1CQUFtQixDQUFDLFFBQVEsQ0FBQyxNQUFNLEdBQUcsQ0FBQztBQUUzQzs7QUNwTUE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBUUg7QUFDTyxNQUFNLGFBQWEsR0FBRyw2QkFBNkI7QUFDMUQsTUFBTSxnQkFBZ0IsR0FBRyxDQUFDO0FBQzFCLE1BQU0saUJBQWlCLEdBQUcsMEJBQTBCO0FBU3BELElBQUksU0FBUyxHQUE4QyxJQUFJO0FBQy9ELFNBQVMsWUFBWSxDQUFBO0VBQ25CLElBQUksQ0FBQyxTQUFTLEVBQUU7SUFDZCxTQUFTLEdBQUcsSUFBQSxXQUFNLEVBQUMsYUFBYSxFQUFFLGdCQUFnQixFQUFFO01BQ2xELE9BQU8sRUFBRSxDQUFDLFNBQVMsRUFBRSxVQUFVLEtBQUk7Ozs7O1FBS2pDLFFBQVEsVUFBVTtVQUNoQixLQUFLLENBQUM7WUFDSixTQUFTLENBQUMsaUJBQWlCLENBQUMsaUJBQWlCLENBQUM7OztJQUdyRCxFQUFDOztFQUVKLE9BQU8sU0FBUztBQUNsQjtBQUVBO0FBQ08sZUFBZSxLQUFLLENBQ3pCLG9CQUFrRDtFQUVsRCxNQUFNLEdBQUcsR0FBRyxNQUFNLENBQUMsb0JBQW9CLENBQUM7RUFDeEMsTUFBTSxFQUFFLEdBQUcsTUFBTSxZQUFZLEVBQUU7RUFDL0IsTUFBTSxZQUFZLEdBQUksTUFBTSxFQUFFLENBQzNCLFdBQVcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUM5QixXQUFXLENBQUMsaUJBQWlCLENBQUMsQ0FDOUIsR0FBRyxDQUFDLEdBQUcsQ0FBa0I7RUFFNUIsSUFBSSxZQUFZLEVBQUU7SUFDaEIsT0FBTyxZQUFZO0dBQ3BCLE1BQU07O0lBRUwsTUFBTSxlQUFlLEdBQUcsTUFBTSxrQkFBa0IsQ0FDOUMsb0JBQW9CLENBQUMsU0FBUyxDQUFDLFFBQVEsQ0FDeEM7SUFDRCxJQUFJLGVBQWUsRUFBRTtNQUNuQixNQUFNLEtBQUssQ0FBQyxvQkFBb0IsRUFBRSxlQUFlLENBQUM7TUFDbEQsT0FBTyxlQUFlOzs7QUFHNUI7QUFFQTtBQUNPLGVBQWUsS0FBSyxDQUN6QixvQkFBa0QsRUFDbEQsWUFBMEI7RUFFMUIsTUFBTSxHQUFHLEdBQUcsTUFBTSxDQUFDLG9CQUFvQixDQUFDO0VBQ3hDLE1BQU0sRUFBRSxHQUFHLE1BQU0sWUFBWSxFQUFFO0VBQy9CLE1BQU0sRUFBRSxHQUFHLEVBQUUsQ0FBQyxXQUFXLENBQUMsaUJBQWlCLEVBQUUsV0FBVyxDQUFDO0VBQ3pELE1BQU0sRUFBRSxDQUFDLFdBQVcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDO0VBQzlELE1BQU0sRUFBRSxDQUFDLElBQUk7RUFDYixPQUFPLFlBQVk7QUFDckI7QUFFQTtBQUNPLGVBQWUsUUFBUSxDQUM1QixvQkFBa0Q7RUFFbEQsTUFBTSxHQUFHLEdBQUcsTUFBTSxDQUFDLG9CQUFvQixDQUFDO0VBQ3hDLE1BQU0sRUFBRSxHQUFHLE1BQU0sWUFBWSxFQUFFO0VBQy9CLE1BQU0sRUFBRSxHQUFHLEVBQUUsQ0FBQyxXQUFXLENBQUMsaUJBQWlCLEVBQUUsV0FBVyxDQUFDO0VBQ3pELE1BQU0sRUFBRSxDQUFDLFdBQVcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUM7RUFDbkQsTUFBTSxFQUFFLENBQUMsSUFBSTtBQUNmO0FBV0EsU0FBUyxNQUFNLENBQUM7RUFBRTtBQUFTLENBQWdDO0VBQ3pELE9BQU8sU0FBUyxDQUFDLEtBQUs7QUFDeEI7O0FDbEhBOzs7Ozs7Ozs7Ozs7Ozs7QUFlRztBQXlCSSxNQUFNLFNBQVMsR0FBd0I7RUFDNUMseUVBQ0UsaURBQWlEO0VBQ25ELGtFQUNFLCtDQUErQztFQUNqRCwwREFDRSx1REFBdUQ7RUFDekQsMkRBQ0Usb0VBQW9FO0VBQ3RFLDJEQUNFLGtFQUFrRTtFQUNwRSw2REFDRSwwRUFBMEU7RUFDNUUsbUVBQ0Usa0dBQWtHO0VBQ3BHLG9GQUNFLDhFQUE4RTtFQUNoRixtRUFDRSxvRUFBb0U7RUFDdEUsdUVBQ0UsMERBQTBEO0VBQzVELHVFQUNFLDZDQUE2QyxHQUM3Qyw2QkFBNkI7RUFDL0IsNkRBQ0UsbUVBQW1FO0VBQ3JFLGlFQUNFLHVEQUF1RDtFQUN6RCxtRUFDRSxvRUFBb0UsR0FDcEUseUVBQXlFO0VBQzNFLHFFQUNFLHNFQUFzRTtFQUN4RSwyREFDRSxnRUFBZ0U7RUFDbEUseURBQStCLHdDQUF3QztFQUN2RSxpRkFDRSxxRUFBcUUsR0FDckU7Q0FDSDtBQVlNLE1BQU0sYUFBYSxHQUFHLElBQUksa0JBQVksQ0FDM0MsV0FBVyxFQUNYLFdBQVcsRUFDWCxTQUFTLENBQ1Y7O0FDL0ZEOzs7Ozs7Ozs7Ozs7Ozs7QUFlRztBQXVCSSxlQUFlLGVBQWUsQ0FDbkMsb0JBQWtELEVBQ2xELG1CQUF3QztFQUV4QyxNQUFNLE9BQU8sR0FBRyxNQUFNLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQztFQUN0RCxNQUFNLElBQUksR0FBRyxPQUFPLENBQUMsbUJBQW1CLENBQUM7RUFFekMsTUFBTSxnQkFBZ0IsR0FBRztJQUN2QixNQUFNLEVBQUUsTUFBTTtJQUNkLE9BQU87SUFDUCxJQUFJLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJO0dBQzFCO0VBRUQsSUFBSSxZQUF5QjtFQUM3QixJQUFJO0lBQ0YsTUFBTSxRQUFRLEdBQUcsTUFBTSxLQUFLLENBQzFCLFdBQVcsQ0FBQyxvQkFBb0IsQ0FBQyxTQUFTLENBQUMsRUFDM0MsZ0JBQWdCLENBQ2pCO0lBQ0QsWUFBWSxHQUFHLE1BQU0sUUFBUSxDQUFDLElBQUksRUFBRTtHQUNyQyxDQUFDLE9BQU8sR0FBRyxFQUFFO0lBQ1osTUFBTSxhQUFhLENBQUMsTUFBTSxDQUFtQztNQUMzRCxTQUFTLEVBQUcsR0FBYSxLQUFiLFFBQUEsR0FBRyx1QkFBSCxHQUFHLENBQVksUUFBUTtJQUNwQyxFQUFDOztFQUdKLElBQUksWUFBWSxDQUFDLEtBQUssRUFBRTtJQUN0QixNQUFNLE9BQU8sR0FBRyxZQUFZLENBQUMsS0FBSyxDQUFDLE9BQU87SUFDMUMsTUFBTSxhQUFhLENBQUMsTUFBTSxDQUFtQztNQUMzRCxTQUFTLEVBQUU7SUFDWixFQUFDOztFQUdKLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFO0lBQ3ZCLE1BQU0sYUFBYSxDQUFDLE1BQU0scUVBQW9DOztFQUdoRSxPQUFPLFlBQVksQ0FBQyxLQUFLO0FBQzNCO0FBRU8sZUFBZSxrQkFBa0IsQ0FDdEMsb0JBQWtELEVBQ2xELFlBQTBCO0VBRTFCLE1BQU0sT0FBTyxHQUFHLE1BQU0sVUFBVSxDQUFDLG9CQUFvQixDQUFDO0VBQ3RELE1BQU0sSUFBSSxHQUFHLE9BQU8sQ0FBQyxZQUFZLENBQUMsbUJBQW9CLENBQUM7RUFFdkQsTUFBTSxhQUFhLEdBQUc7SUFDcEIsTUFBTSxFQUFFLE9BQU87SUFDZixPQUFPO0lBQ1AsSUFBSSxFQUFFLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSTtHQUMxQjtFQUVELElBQUksWUFBeUI7RUFDN0IsSUFBSTtJQUNGLE1BQU0sUUFBUSxHQUFHLE1BQU0sS0FBSyxDQUMxQixHQUFHLFdBQVcsQ0FBQyxvQkFBb0IsQ0FBQyxTQUFTLENBQUMsSUFBSSxZQUFZLENBQUMsS0FBSyxFQUFFLEVBQ3RFLGFBQWEsQ0FDZDtJQUNELFlBQVksR0FBRyxNQUFNLFFBQVEsQ0FBQyxJQUFJLEVBQUU7R0FDckMsQ0FBQyxPQUFPLEdBQUcsRUFBRTtJQUNaLE1BQU0sYUFBYSxDQUFDLE1BQU0sQ0FBZ0M7TUFDeEQsU0FBUyxFQUFHLEdBQWEsS0FBYixRQUFBLEdBQUcsdUJBQUgsR0FBRyxDQUFZLFFBQVE7SUFDcEMsRUFBQzs7RUFHSixJQUFJLFlBQVksQ0FBQyxLQUFLLEVBQUU7SUFDdEIsTUFBTSxPQUFPLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQyxPQUFPO0lBQzFDLE1BQU0sYUFBYSxDQUFDLE1BQU0sQ0FBZ0M7TUFDeEQsU0FBUyxFQUFFO0lBQ1osRUFBQzs7RUFHSixJQUFJLENBQUMsWUFBWSxDQUFDLEtBQUssRUFBRTtJQUN2QixNQUFNLGFBQWEsQ0FBQyxNQUFNLCtEQUFpQzs7RUFHN0QsT0FBTyxZQUFZLENBQUMsS0FBSztBQUMzQjtBQUVPLGVBQWUsa0JBQWtCLENBQ3RDLG9CQUFrRCxFQUNsRCxLQUFhO0VBRWIsTUFBTSxPQUFPLEdBQUcsTUFBTSxVQUFVLENBQUMsb0JBQW9CLENBQUM7RUFFdEQsTUFBTSxrQkFBa0IsR0FBRztJQUN6QixNQUFNLEVBQUUsUUFBUTtJQUNoQjtHQUNEO0VBRUQsSUFBSTtJQUNGLE1BQU0sUUFBUSxHQUFHLE1BQU0sS0FBSyxDQUMxQixHQUFHLFdBQVcsQ0FBQyxvQkFBb0IsQ0FBQyxTQUFTLENBQUMsSUFBSSxLQUFLLEVBQUUsRUFDekQsa0JBQWtCLENBQ25CO0lBQ0QsTUFBTSxZQUFZLEdBQWdCLE1BQU0sUUFBUSxDQUFDLElBQUksRUFBRTtJQUN2RCxJQUFJLFlBQVksQ0FBQyxLQUFLLEVBQUU7TUFDdEIsTUFBTSxPQUFPLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQyxPQUFPO01BQzFDLE1BQU0sYUFBYSxDQUFDLE1BQU0sQ0FBcUM7UUFDN0QsU0FBUyxFQUFFO01BQ1osRUFBQzs7R0FFTCxDQUFDLE9BQU8sR0FBRyxFQUFFO0lBQ1osTUFBTSxhQUFhLENBQUMsTUFBTSxDQUFxQztNQUM3RCxTQUFTLEVBQUcsR0FBYSxLQUFiLFFBQUEsR0FBRyx1QkFBSCxHQUFHLENBQVksUUFBUTtJQUNwQyxFQUFDOztBQUVOO0FBRUEsU0FBUyxXQUFXLENBQUM7RUFBRTtBQUFTLENBQWE7RUFDM0MsT0FBTyxHQUFHLFFBQVEsYUFBYSxTQUFVLGdCQUFnQjtBQUMzRDtBQUVBLGVBQWUsVUFBVSxDQUFDO0VBQ3hCLFNBQVM7RUFDVDtBQUFhLENBQ2dCO0VBQzdCLE1BQU0sU0FBUyxHQUFHLE1BQU0sYUFBYSxDQUFDLFFBQVEsRUFBRTtFQUVoRCxPQUFPLElBQUksT0FBTyxDQUFDO0lBQ2pCLGNBQWMsRUFBRSxrQkFBa0I7SUFDbEMsTUFBTSxFQUFFLGtCQUFrQjtJQUMxQixnQkFBZ0IsRUFBRSxTQUFTLENBQUMsTUFBTztJQUNuQyxvQ0FBb0MsRUFBRSxPQUFPLFNBQVM7RUFDdkQsRUFBQztBQUNKO0FBRUEsU0FBUyxPQUFPLENBQUM7RUFDZixNQUFNO0VBQ04sSUFBSTtFQUNKLFFBQVE7RUFDUjtBQUFRLENBQ1k7RUFDcEIsTUFBTSxJQUFJLEdBQW1CO0lBQzNCLEdBQUcsRUFBRTtNQUNILFFBQVE7TUFDUixJQUFJO01BQ0o7SUFDRDtHQUNGO0VBRUQsSUFBSSxRQUFRLEtBQUssaUJBQWlCLEVBQUU7SUFDbEMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsR0FBRyxRQUFROztFQUd2QyxPQUFPLElBQUk7QUFDYjs7QUN6TEE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBaUJIO0FBQ0EsTUFBTSxtQkFBbUIsR0FBRyxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsSUFBSSxDQUFDO0FBRTdDLGVBQWUsZ0JBQWdCLENBQ3BDLFNBQTJCO0VBRTNCLE1BQU0sZ0JBQWdCLEdBQUcsTUFBTSxtQkFBbUIsQ0FDaEQsU0FBUyxDQUFDLGNBQWUsRUFDekIsU0FBUyxDQUFDLFFBQVMsQ0FDcEI7RUFFRCxNQUFNLG1CQUFtQixHQUF3QjtJQUMvQyxRQUFRLEVBQUUsU0FBUyxDQUFDLFFBQVM7SUFDN0IsT0FBTyxFQUFFLFNBQVMsQ0FBQyxjQUFlLENBQUMsS0FBSztJQUN4QyxRQUFRLEVBQUUsZ0JBQWdCLENBQUMsUUFBUTtJQUNuQyxJQUFJLEVBQUUsYUFBYSxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxNQUFNLENBQUUsQ0FBQztJQUNyRCxNQUFNLEVBQUUsYUFBYSxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxRQUFRLENBQUU7R0FDekQ7RUFFRCxNQUFNLFlBQVksR0FBRyxNQUFNLEtBQUssQ0FBQyxTQUFTLENBQUMsb0JBQW9CLENBQUM7RUFDaEUsSUFBSSxDQUFDLFlBQVksRUFBRTs7SUFFakIsT0FBTyxXQUFXLENBQUMsU0FBUyxDQUFDLG9CQUFvQixFQUFFLG1CQUFtQixDQUFDO0dBQ3hFLE1BQU0sSUFDTCxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsbUJBQW9CLEVBQUUsbUJBQW1CLENBQUMsRUFDckU7O0lBRUEsSUFBSTtNQUNGLE1BQU0sa0JBQWtCLENBQ3RCLFNBQVMsQ0FBQyxvQkFBcUIsRUFDL0IsWUFBWSxDQUFDLEtBQUssQ0FDbkI7S0FDRixDQUFDLE9BQU8sQ0FBQyxFQUFFOztNQUVWLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDOztJQUdqQixPQUFPLFdBQVcsQ0FBQyxTQUFTLENBQUMsb0JBQXFCLEVBQUUsbUJBQW1CLENBQUM7R0FDekUsTUFBTSxJQUFJLElBQUksQ0FBQyxHQUFHLEVBQUUsSUFBSSxZQUFZLENBQUMsVUFBVSxHQUFHLG1CQUFtQixFQUFFOztJQUV0RSxPQUFPLFdBQVcsQ0FBQyxTQUFTLEVBQUU7TUFDNUIsS0FBSyxFQUFFLFlBQVksQ0FBQyxLQUFLO01BQ3pCLFVBQVUsRUFBRSxJQUFJLENBQUMsR0FBRyxFQUFFO01BQ3RCO0lBQ0QsRUFBQztHQUNILE1BQU07O0lBRUwsT0FBTyxZQUFZLENBQUMsS0FBSzs7QUFFN0I7QUFFQTs7O0FBR0c7QUFDSSxlQUFlLG1CQUFtQixDQUN2QyxTQUEyQjtFQUUzQixNQUFNLFlBQVksR0FBRyxNQUFNLEtBQUssQ0FBQyxTQUFTLENBQUMsb0JBQW9CLENBQUM7RUFDaEUsSUFBSSxZQUFZLEVBQUU7SUFDaEIsTUFBTSxrQkFBa0IsQ0FDdEIsU0FBUyxDQUFDLG9CQUFvQixFQUM5QixZQUFZLENBQUMsS0FBSyxDQUNuQjtJQUNELE1BQU0sUUFBUSxDQUFDLFNBQVMsQ0FBQyxvQkFBb0IsQ0FBQzs7O0VBSWhELE1BQU0sZ0JBQWdCLEdBQ3BCLE1BQU0sU0FBUyxDQUFDLGNBQWUsQ0FBQyxXQUFXLENBQUMsZUFBZSxFQUFFO0VBQy9ELElBQUksZ0JBQWdCLEVBQUU7SUFDcEIsT0FBTyxnQkFBZ0IsQ0FBQyxXQUFXLEVBQUU7OztFQUl2QyxPQUFPLElBQUk7QUFDYjtBQUVBLGVBQWUsV0FBVyxDQUN4QixTQUEyQixFQUMzQixZQUEwQjtFQUUxQixJQUFJO0lBQ0YsTUFBTSxZQUFZLEdBQUcsTUFBTSxrQkFBa0IsQ0FDM0MsU0FBUyxDQUFDLG9CQUFvQixFQUM5QixZQUFZLENBQ2I7SUFFRCxNQUFNLG1CQUFtQixHQUFBLE1BQUEsQ0FBQSxNQUFBLENBQUEsTUFBQSxDQUFBLE1BQUEsS0FDcEIsWUFBWTtNQUNmLEtBQUssRUFBRSxZQUFZO01BQ25CLFVBQVUsRUFBRSxJQUFJLENBQUMsR0FBRztJQUFFLEVBQ3ZCO0lBRUQsTUFBTSxLQUFLLENBQUMsU0FBUyxDQUFDLG9CQUFvQixFQUFFLG1CQUFtQixDQUFDO0lBQ2hFLE9BQU8sWUFBWTtHQUNwQixDQUFDLE9BQU8sQ0FBQyxFQUFFO0lBQ1YsTUFBTSxDQUFDOztBQUVYO0FBRUEsZUFBZSxXQUFXLENBQ3hCLG9CQUFrRCxFQUNsRCxtQkFBd0M7RUFFeEMsTUFBTSxLQUFLLEdBQUcsTUFBTSxlQUFlLENBQ2pDLG9CQUFvQixFQUNwQixtQkFBbUIsQ0FDcEI7RUFDRCxNQUFNLFlBQVksR0FBaUI7SUFDakMsS0FBSztJQUNMLFVBQVUsRUFBRSxJQUFJLENBQUMsR0FBRyxFQUFFO0lBQ3RCO0dBQ0Q7RUFDRCxNQUFNLEtBQUssQ0FBQyxvQkFBb0IsRUFBRSxZQUFZLENBQUM7RUFDL0MsT0FBTyxZQUFZLENBQUMsS0FBSztBQUMzQjtBQUVBOztBQUVHO0FBQ0gsZUFBZSxtQkFBbUIsQ0FDaEMsY0FBeUMsRUFDekMsUUFBZ0I7RUFFaEIsTUFBTSxZQUFZLEdBQUcsTUFBTSxjQUFjLENBQUMsV0FBVyxDQUFDLGVBQWUsRUFBRTtFQUN2RSxJQUFJLFlBQVksRUFBRTtJQUNoQixPQUFPLFlBQVk7O0VBR3JCLE9BQU8sY0FBYyxDQUFDLFdBQVcsQ0FBQyxTQUFTLENBQUM7SUFDMUMsZUFBZSxFQUFFLElBQUk7OztJQUdyQixvQkFBb0IsRUFBRSxhQUFhLENBQUMsUUFBUTtFQUM3QyxFQUFDO0FBQ0o7QUFFQTs7QUFFRztBQUNILFNBQVMsWUFBWSxDQUNuQixTQUE4QixFQUM5QixjQUFtQztFQUVuQyxNQUFNLGVBQWUsR0FBRyxjQUFjLENBQUMsUUFBUSxLQUFLLFNBQVMsQ0FBQyxRQUFRO0VBQ3RFLE1BQU0sZUFBZSxHQUFHLGNBQWMsQ0FBQyxRQUFRLEtBQUssU0FBUyxDQUFDLFFBQVE7RUFDdEUsTUFBTSxXQUFXLEdBQUcsY0FBYyxDQUFDLElBQUksS0FBSyxTQUFTLENBQUMsSUFBSTtFQUMxRCxNQUFNLGFBQWEsR0FBRyxjQUFjLENBQUMsTUFBTSxLQUFLLFNBQVMsQ0FBQyxNQUFNO0VBRWhFLE9BQU8sZUFBZSxJQUFJLGVBQWUsSUFBSSxXQUFXLElBQUksYUFBYTtBQUMzRTs7QUN2TEE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBS0csU0FBVSxrQkFBa0IsQ0FDaEMsZUFBdUM7RUFFdkMsTUFBTSxPQUFPLEdBQW1CO0lBQzlCLElBQUksRUFBRSxlQUFlLENBQUMsSUFBSTs7SUFFMUIsV0FBVyxFQUFFLGVBQWUsQ0FBQyxZQUFZOztJQUV6QyxTQUFTLEVBQUUsZUFBZSxDQUFDO0dBQ1Y7RUFFbkIsNEJBQTRCLENBQUMsT0FBTyxFQUFFLGVBQWUsQ0FBQztFQUN0RCxvQkFBb0IsQ0FBQyxPQUFPLEVBQUUsZUFBZSxDQUFDO0VBQzlDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSxlQUFlLENBQUM7RUFFN0MsT0FBTyxPQUFPO0FBQ2hCO0FBRUEsU0FBUyw0QkFBNEIsQ0FDbkMsT0FBdUIsRUFDdkIsc0JBQThDO0VBRTlDLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxZQUFZLEVBQUU7SUFDeEM7O0VBR0YsT0FBTyxDQUFDLFlBQVksR0FBRyxFQUFFO0VBRXpCLE1BQU0sS0FBSyxHQUFHLHNCQUFzQixDQUFDLFlBQWEsQ0FBQyxLQUFLO0VBQ3hELElBQUksQ0FBQyxDQUFDLEtBQUssRUFBRTtJQUNYLE9BQU8sQ0FBQyxZQUFhLENBQUMsS0FBSyxHQUFHLEtBQUs7O0VBR3JDLE1BQU0sSUFBSSxHQUFHLHNCQUFzQixDQUFDLFlBQWEsQ0FBQyxJQUFJO0VBQ3RELElBQUksQ0FBQyxDQUFDLElBQUksRUFBRTtJQUNWLE9BQU8sQ0FBQyxZQUFhLENBQUMsSUFBSSxHQUFHLElBQUk7O0VBR25DLE1BQU0sS0FBSyxHQUFHLHNCQUFzQixDQUFDLFlBQWEsQ0FBQyxLQUFLO0VBQ3hELElBQUksQ0FBQyxDQUFDLEtBQUssRUFBRTtJQUNYLE9BQU8sQ0FBQyxZQUFhLENBQUMsS0FBSyxHQUFHLEtBQUs7O0VBR3JDLE1BQU0sSUFBSSxHQUFHLHNCQUFzQixDQUFDLFlBQWEsQ0FBQyxJQUFJO0VBQ3RELElBQUksQ0FBQyxDQUFDLElBQUksRUFBRTtJQUNWLE9BQU8sQ0FBQyxZQUFhLENBQUMsSUFBSSxHQUFHLElBQUk7O0FBRXJDO0FBRUEsU0FBUyxvQkFBb0IsQ0FDM0IsT0FBdUIsRUFDdkIsc0JBQThDO0VBRTlDLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxJQUFJLEVBQUU7SUFDaEM7O0VBR0YsT0FBTyxDQUFDLElBQUksR0FBRyxzQkFBc0IsQ0FBQyxJQUFpQztBQUN6RTtBQUVBLFNBQVMsbUJBQW1CLENBQzFCLE9BQXVCLEVBQ3ZCLHNCQUE4Qzs7O0VBRzlDLElBQ0UsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLElBQ2xDLEVBQUMsQ0FBQSxFQUFBLEdBQUEsc0JBQXNCLENBQUMsWUFBWSxNQUFFLFFBQUEsRUFBQSx1QkFBQSxFQUFBLENBQUEsWUFBWSxHQUNsRDtJQUNBOztFQUdGLE9BQU8sQ0FBQyxVQUFVLEdBQUcsRUFBRTtFQUV2QixNQUFNLElBQUksR0FDUixDQUFBLEVBQUEsSUFBQSxFQUFBLEdBQUEsc0JBQXNCLENBQUMsVUFBVSxjQUFBLEVBQUEsdUJBQUEsRUFBQSxDQUFFLElBQUksY0FBQSxFQUFBLGNBQUEsRUFBQSxHQUN2QyxDQUFBLEVBQUEsR0FBQSxzQkFBc0IsQ0FBQyxZQUFZLGNBQUEsRUFBQSx1QkFBQSxFQUFBLENBQUUsWUFBWTtFQUVuRCxJQUFJLENBQUMsQ0FBQyxJQUFJLEVBQUU7SUFDVixPQUFPLENBQUMsVUFBVyxDQUFDLElBQUksR0FBRyxJQUFJOzs7RUFJakMsTUFBTSxjQUFjLEdBQUcsQ0FBQSxFQUFBLEdBQUEsc0JBQXNCLENBQUMsVUFBVSxjQUFBLEVBQUEsdUJBQUEsRUFBQSxDQUFFLGVBQWU7RUFDekUsSUFBSSxDQUFDLENBQUMsY0FBYyxFQUFFO0lBQ3BCLE9BQU8sQ0FBQyxVQUFXLENBQUMsY0FBYyxHQUFHLGNBQWM7O0FBRXZEOztBQzNHQTs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7QUFLRyxTQUFVLGdCQUFnQixDQUFDLElBQWE7O0VBRTVDLE9BQU8sT0FBTyxJQUFJLEtBQUssUUFBUSxJQUFJLENBQUMsQ0FBQyxJQUFJLElBQUksbUJBQW1CLElBQUksSUFBSTtBQUMxRTs7QUN2QkE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBeUJ1QixhQUFhLENBQ3JDLHNCQUFzQixFQUN0QixxQkFBcUI7QUFnTlAsU0FBQSxhQUFhLENBQUMsRUFBVSxFQUFFLEVBQVU7RUFDbEQsTUFBTSxXQUFXLEdBQUcsRUFBRTtFQUN0QixLQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsRUFBRSxDQUFDLE1BQU0sRUFBRSxDQUFDLEVBQUUsRUFBRTtJQUNsQyxXQUFXLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDOUIsSUFBSSxDQUFDLEdBQUcsRUFBRSxDQUFDLE1BQU0sRUFBRTtNQUNqQixXQUFXLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUM7OztFQUlsQyxPQUFPLFdBQVcsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDO0FBQzdCOztBQ3BRQTs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7QUFRRyxTQUFVLGdCQUFnQixDQUFDLEdBQWdCO0VBQy9DLElBQUksQ0FBQyxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsT0FBTyxFQUFFO0lBQ3hCLE1BQU0sb0JBQW9CLENBQUMsMEJBQTBCLENBQUM7O0VBR3hELElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxFQUFFO0lBQ2IsTUFBTSxvQkFBb0IsQ0FBQyxVQUFVLENBQUM7OztFQUl4QyxNQUFNLFVBQVUsR0FBeUMsQ0FDdkQsV0FBVyxFQUNYLFFBQVEsRUFDUixPQUFPLEVBQ1AsbUJBQW1CLENBQ3BCO0VBRUQsTUFBTTtJQUFFO0VBQU8sQ0FBRSxHQUFHLEdBQUc7RUFDdkIsS0FBSyxNQUFNLE9BQU8sSUFBSSxVQUFVLEVBQUU7SUFDaEMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFBRTtNQUNyQixNQUFNLG9CQUFvQixDQUFDLE9BQU8sQ0FBQzs7O0VBSXZDLE9BQU87SUFDTCxPQUFPLEVBQUUsR0FBRyxDQUFDLElBQUk7SUFDakIsU0FBUyxFQUFFLE9BQU8sQ0FBQyxTQUFVO0lBQzdCLE1BQU0sRUFBRSxPQUFPLENBQUMsTUFBTztJQUN2QixLQUFLLEVBQUUsT0FBTyxDQUFDLEtBQU07SUFDckIsUUFBUSxFQUFFLE9BQU8sQ0FBQztHQUNuQjtBQUNIO0FBRUEsU0FBUyxvQkFBb0IsQ0FBQyxTQUFpQjtFQUM3QyxPQUFPLGFBQWEsQ0FBQyxNQUFNLENBQXNDO0lBQy9EO0VBQ0QsRUFBQztBQUNKOztBQzVEQTs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7TUFZVSxnQkFBZ0I7RUFvQjNCLFlBQ0UsR0FBZ0IsRUFDaEIsYUFBNkMsRUFDN0MsaUJBQTBEOztJQWhCNUQsSUFBd0MsQ0FBQSx3Q0FBQSxHQUFZLEtBQUs7SUFFekQsSUFBMEIsQ0FBQSwwQkFBQSxHQUdmLElBQUk7SUFFZixJQUFnQixDQUFBLGdCQUFBLEdBQ2QsSUFBSTtJQUVOLElBQVMsQ0FBQSxTQUFBLEdBQWUsRUFBRTtJQUMxQixJQUFtQixDQUFBLG1CQUFBLEdBQVksS0FBSztJQU9sQyxNQUFNLFNBQVMsR0FBRyxnQkFBZ0IsQ0FBQyxHQUFHLENBQUM7SUFFdkMsSUFBSSxDQUFDLG9CQUFvQixHQUFHO01BQzFCLEdBQUc7TUFDSCxTQUFTO01BQ1QsYUFBYTtNQUNiO0tBQ0Q7O0VBR0gsT0FBTyxDQUFBO0lBQ0wsT0FBTyxPQUFPLENBQUMsT0FBTyxFQUFFOztBQUUzQjs7QUNqRUQ7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBV0ksZUFBZSxpQkFBaUIsQ0FDckMsU0FBMkI7RUFFM0IsSUFBSTtJQUNGLFNBQVMsQ0FBQyxjQUFjLEdBQUcsTUFBTSxTQUFTLENBQUMsYUFBYSxDQUFDLFFBQVEsQ0FDL0QsZUFBZSxFQUNmO01BQ0UsS0FBSyxFQUFFO0lBQ1IsRUFDRjs7Ozs7O0lBT0QsU0FBUyxDQUFDLGNBQWMsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxLQUFLLENBQUMsTUFBSzs7S0FFNUMsQ0FBQztJQUNGLE1BQU0seUJBQXlCLENBQUMsU0FBUyxDQUFDLGNBQWMsQ0FBQztHQUMxRCxDQUFDLE9BQU8sQ0FBQyxFQUFFO0lBQ1YsTUFBTSxhQUFhLENBQUMsTUFBTSxDQUF3QztNQUNoRSxtQkFBbUIsRUFBRyxDQUFXLGFBQVgsQ0FBQyxLQUFELGtCQUFBLENBQUMsQ0FBWTtJQUNwQyxFQUFDOztBQUVOO0FBRUE7Ozs7Ozs7O0FBUUc7QUFDSCxlQUFlLHlCQUF5QixDQUN0QyxZQUF1QztFQUV2QyxPQUFPLElBQUksT0FBTyxDQUFPLENBQUMsT0FBTyxFQUFFLE1BQU0sS0FBSTtJQUMzQyxNQUFNLGFBQWEsR0FBRyxVQUFVLENBQzlCLE1BQ0UsTUFBTSxDQUNKLElBQUksS0FBSyxDQUNQLHVDQUF1Qyw0QkFBNEIsS0FBSyxDQUN6RSxDQUNGLEVBQ0gsNEJBQTRCLENBQzdCO0lBQ0QsTUFBTSxVQUFVLEdBQUcsWUFBWSxDQUFDLFVBQVUsSUFBSSxZQUFZLENBQUMsT0FBTztJQUNsRSxJQUFJLFlBQVksQ0FBQyxNQUFNLEVBQUU7TUFDdkIsWUFBWSxDQUFDLGFBQWEsQ0FBQztNQUMzQixPQUFPLEVBQUU7S0FDVixNQUFNLElBQUksVUFBVSxFQUFFO01BQ3JCLFVBQVUsQ0FBQyxhQUFhLEdBQUcsRUFBRSxJQUFHOztRQUM5QixJQUFJLEVBQUMsRUFBQSxHQUFBLEVBQUUsQ0FBQyxNQUF3QixjQUFBLEVBQUEsdUJBQUEsRUFBQSxDQUFFLEtBQUssTUFBSyxXQUFXLEVBQUU7VUFDdkQsVUFBVSxDQUFDLGFBQWEsR0FBRyxJQUFJO1VBQy9CLFlBQVksQ0FBQyxhQUFhLENBQUM7VUFDM0IsT0FBTyxFQUFFOztNQUViLENBQUM7S0FDRixNQUFNO01BQ0wsWUFBWSxDQUFDLGFBQWEsQ0FBQztNQUMzQixNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsbUNBQW1DLENBQUMsQ0FBQzs7RUFFMUQsQ0FBQyxDQUFDO0FBQ0o7O0FDNUZBOzs7Ozs7Ozs7Ozs7Ozs7QUFlRztBQU9JLGVBQWUsV0FBVyxDQUMvQixTQUEyQixFQUMzQixjQUFzRDtFQUV0RCxJQUFJLENBQUMsY0FBYyxJQUFJLENBQUMsU0FBUyxDQUFDLGNBQWMsRUFBRTtJQUNoRCxNQUFNLGlCQUFpQixDQUFDLFNBQVMsQ0FBQzs7RUFHcEMsSUFBSSxDQUFDLGNBQWMsSUFBSSxDQUFDLENBQUMsU0FBUyxDQUFDLGNBQWMsRUFBRTtJQUNqRDs7RUFHRixJQUFJLEVBQUUsY0FBYyxZQUFZLHlCQUF5QixDQUFDLEVBQUU7SUFDMUQsTUFBTSxhQUFhLENBQUMsTUFBTSxtRUFBbUM7O0VBRy9ELFNBQVMsQ0FBQyxjQUFjLEdBQUcsY0FBYztBQUMzQzs7QUN2Q0E7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBS0ksZUFBZSxjQUFjLENBQ2xDLFNBQTJCLEVBQzNCLFFBQTZCO0VBRTdCLElBQUksQ0FBQyxDQUFDLFFBQVEsRUFBRTtJQUNkLFNBQVMsQ0FBQyxRQUFRLEdBQUcsUUFBUTtHQUM5QixNQUFNLElBQUksQ0FBQyxTQUFTLENBQUMsUUFBUSxFQUFFO0lBQzlCLFNBQVMsQ0FBQyxRQUFRLEdBQUcsaUJBQWlCOztBQUUxQzs7QUM3QkE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBVUksZUFBZSxVQUFRLENBQzVCLFNBQTJCLEVBQzNCLE9BQXlCO0VBRXpCLElBQUksQ0FBQyxTQUFTLEVBQUU7SUFDZCxNQUFNLGFBQWEsQ0FBQyxNQUFNLGdFQUErQjs7RUFHM0QsSUFBSSxZQUFZLENBQUMsVUFBVSxLQUFLLFNBQVMsRUFBRTtJQUN6QyxNQUFNLFlBQVksQ0FBQyxpQkFBaUIsRUFBRTs7RUFHeEMsSUFBSSxZQUFZLENBQUMsVUFBVSxLQUFLLFNBQVMsRUFBRTtJQUN6QyxNQUFNLGFBQWEsQ0FBQyxNQUFNLHlEQUE4Qjs7RUFHMUQsTUFBTSxjQUFjLENBQUMsU0FBUyxFQUFFLE9BQU8sYUFBUCxPQUFPLHVCQUFQLE9BQU8sQ0FBRSxRQUFRLENBQUM7RUFDbEQsTUFBTSxXQUFXLENBQUMsU0FBUyxFQUFFLE9BQU8sYUFBUCxPQUFPLHVCQUFQLE9BQU8sQ0FBRSx5QkFBeUIsQ0FBQztFQUVoRSxPQUFPLGdCQUFnQixDQUFDLFNBQVMsQ0FBQztBQUNwQzs7QUM3Q0E7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBY0ksZUFBZSxVQUFVLENBQzlCLFNBQTJCLEVBQzNCLFdBQXdCLEVBQ3hCLElBQXdCO0VBRXhCLE1BQU0sU0FBUyxHQUFHLFlBQVksQ0FBQyxXQUFXLENBQUM7RUFDM0MsTUFBTSxTQUFTLEdBQ2IsTUFBTSxTQUFTLENBQUMsb0JBQW9CLENBQUMsaUJBQWlCLENBQUMsR0FBRyxFQUFFO0VBQzlELFNBQVMsQ0FBQyxRQUFRLENBQUMsU0FBUyxFQUFFOztJQUU1QixVQUFVLEVBQUUsSUFBSSxDQUFDLG1CQUFtQixDQUFDO0lBQ3JDLFlBQVksRUFBRSxJQUFJLENBQUMscUJBQXFCLENBQUM7SUFDekMsWUFBWSxFQUFFLElBQUksQ0FBQyxxQkFBcUIsQ0FBQztJQUN6QyxtQkFBbUIsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxHQUFHLEVBQUUsR0FBRyxJQUFJOztFQUVsRCxFQUFDO0FBQ0o7QUFFQSxTQUFTLFlBQVksQ0FBQyxXQUF3QjtFQUM1QyxRQUFRLFdBQVc7SUFDakIsS0FBSyxXQUFXLENBQUMsb0JBQW9CO01BQ25DLE9BQU8sbUJBQW1CO0lBQzVCLEtBQUssV0FBVyxDQUFDLGFBQWE7TUFDNUIsT0FBTyx5QkFBeUI7SUFDbEM7TUFDRSxNQUFNLElBQUksS0FBSyxFQUFFOztBQUV2Qjs7QUN4REE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBYUksZUFBZSxvQkFBb0IsQ0FDeEMsU0FBMkIsRUFDM0IsS0FBbUI7RUFFbkIsTUFBTSxlQUFlLEdBQUcsS0FBSyxDQUFDLElBQThCO0VBRTVELElBQUksQ0FBQyxlQUFlLENBQUMsbUJBQW1CLEVBQUU7SUFDeEM7O0VBR0YsSUFDRSxTQUFTLENBQUMsZ0JBQWdCLElBQzFCLGVBQWUsQ0FBQyxXQUFXLEtBQUssV0FBVyxDQUFDLGFBQWEsRUFDekQ7SUFDQSxJQUFJLE9BQU8sU0FBUyxDQUFDLGdCQUFnQixLQUFLLFVBQVUsRUFBRTtNQUNwRCxTQUFTLENBQUMsZ0JBQWdCLENBQUMsa0JBQWtCLENBQUMsZUFBZSxDQUFDLENBQUM7S0FDaEUsTUFBTTtNQUNMLFNBQVMsQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsZUFBZSxDQUFDLENBQUM7Ozs7RUFLeEUsTUFBTSxXQUFXLEdBQUcsZUFBZSxDQUFDLElBQUk7RUFDeEMsSUFDRSxnQkFBZ0IsQ0FBQyxXQUFXLENBQUMsSUFDN0IsV0FBVyxDQUFDLGtDQUFrQyxDQUFDLEtBQUssR0FBRyxFQUN2RDtJQUNBLE1BQU0sVUFBVSxDQUFDLFNBQVMsRUFBRSxlQUFlLENBQUMsV0FBWSxFQUFFLFdBQVcsQ0FBQzs7QUFFMUU7Ozs7QUN6REE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBd0JILE1BQU0sc0JBQXNCLEdBQzFCLFNBQTZCLElBQzNCO0VBQ0YsTUFBTSxTQUFTLEdBQUcsSUFBSSxnQkFBZ0IsQ0FDcEMsU0FBUyxDQUFDLFdBQVcsQ0FBQyxLQUFLLENBQUMsQ0FBQyxZQUFZLEVBQUUsRUFDM0MsU0FBUyxDQUFDLFdBQVcsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDLFlBQVksRUFBRSxFQUM5RCxTQUFTLENBQUMsV0FBVyxDQUFDLG9CQUFvQixDQUFDLENBQzVDO0VBRUQsU0FBUyxDQUFDLGFBQWEsQ0FBQyxnQkFBZ0IsQ0FBQyxTQUFTLEVBQUUsQ0FBQyxJQUNuRCxvQkFBb0IsQ0FBQyxTQUE2QixFQUFFLENBQUMsQ0FBQyxDQUN2RDtFQUVELE9BQU8sU0FBUztBQUNsQixDQUFDO0FBRUQsTUFBTSw4QkFBOEIsR0FDbEMsU0FBNkIsSUFDM0I7RUFDRixNQUFNLFNBQVMsR0FBRyxTQUFTLENBQ3hCLFdBQVcsQ0FBQyxXQUFXLENBQUMsQ0FDeEIsWUFBWSxFQUFzQjtFQUVyQyxNQUFNLGlCQUFpQixHQUFzQjtJQUMzQyxRQUFRLEVBQUcsT0FBeUIsSUFBSyxVQUFRLENBQUMsU0FBUyxFQUFFLE9BQU87R0FDckU7RUFFRCxPQUFPLGlCQUFpQjtBQUMxQixDQUFDO1NBeUJlLHlCQUF5QixDQUFBO0VBQ3ZDLElBQUEsdUJBQWtCLEVBQ2hCLElBQUksb0JBQVMsQ0FBQyxXQUFXLEVBQUUsc0JBQXNCLEVBQXVCLHFDQUN6RTtFQUVELElBQUEsdUJBQWtCLEVBQ2hCLElBQUksb0JBQVMsQ0FDWCxvQkFBb0IsRUFDcEIsOEJBQThCLEVBRS9CLHVDQUNGO0VBRUQsSUFBQSxvQkFBZSxFQUFDLElBQUksRUFBRSxPQUFPLENBQUM7O0VBRTlCLElBQUEsb0JBQWUsRUFBQyxJQUFJLEVBQUUsT0FBTyxFQUFFLFNBQWtCLENBQUM7QUFDcEQ7O0FDNUdBOzs7Ozs7Ozs7Ozs7Ozs7QUFlRztBQVFIOzs7OztBQUtHO0FBQ0ksZUFBZSxpQkFBaUIsQ0FBQTtFQUNyQyxJQUFJOzs7SUFHRixNQUFNLElBQUEsK0JBQXlCLEdBQUU7R0FDbEMsQ0FBQyxPQUFPLENBQUMsRUFBRTtJQUNWLE9BQU8sS0FBSzs7Ozs7RUFLZCxPQUNFLE9BQU8sTUFBTSxLQUFLLFdBQVcsSUFDN0IsSUFBQSwwQkFBb0IsR0FBRSxJQUN0QixJQUFBLHVCQUFpQixHQUFFLElBQ25CLGVBQWUsSUFBSSxTQUFTLElBQzVCLGFBQWEsSUFBSSxNQUFNLElBQ3ZCLGNBQWMsSUFBSSxNQUFNLElBQ3hCLE9BQU8sSUFBSSxNQUFNLElBQ2pCLHlCQUF5QixDQUFDLFNBQVMsQ0FBQyxjQUFjLENBQUMsa0JBQWtCLENBQUMsSUFDdEUsZ0JBQWdCLENBQUMsU0FBUyxDQUFDLGNBQWMsQ0FBQyxRQUFRLENBQUM7QUFFdkQ7O0FDbkRBOzs7Ozs7Ozs7Ozs7Ozs7QUFlRztBQVFJLGVBQWUsYUFBVyxDQUMvQixTQUEyQjtFQUUzQixJQUFJLENBQUMsU0FBUyxFQUFFO0lBQ2QsTUFBTSxhQUFhLENBQUMsTUFBTSxnRUFBK0I7O0VBRzNELElBQUksQ0FBQyxTQUFTLENBQUMsY0FBYyxFQUFFO0lBQzdCLE1BQU0saUJBQWlCLENBQUMsU0FBUyxDQUFDOztFQUdwQyxPQUFPLG1CQUFtQixDQUFDLFNBQVMsQ0FBQztBQUN2Qzs7QUNuQ0E7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBWWEsU0FBQSxXQUFTLENBQ3ZCLFNBQTJCLEVBQzNCLGNBQWlFO0VBRWpFLElBQUksQ0FBQyxTQUFTLEVBQUU7SUFDZCxNQUFNLGFBQWEsQ0FBQyxNQUFNLGdFQUErQjs7RUFHM0QsU0FBUyxDQUFDLGdCQUFnQixHQUFHLGNBQWM7RUFFM0MsT0FBTyxNQUFLO0lBQ1YsU0FBUyxDQUFDLGdCQUFnQixHQUFHLElBQUk7RUFDbkMsQ0FBQztBQUNIOztBQ3hDQTs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7QUF3Qkg7Ozs7OztBQU1HO0FBQ2EsU0FBQSxvQkFBb0IsQ0FBQyxHQUFBLEdBQW1CLElBQUEsV0FBTSxHQUFFOzs7OztFQUs5RCxpQkFBaUIsRUFBRSxDQUFDLElBQUksQ0FDdEIsV0FBVyxJQUFHOztJQUVaLElBQUksQ0FBQyxXQUFXLEVBQUU7TUFDaEIsTUFBTSxhQUFhLENBQUMsTUFBTSwyREFBK0I7O0dBRTVELEVBQ0QsQ0FBQyxJQUFHOztJQUVGLE1BQU0sYUFBYSxDQUFDLE1BQU0saUVBQWtDO0VBQzlELENBQUMsQ0FDRjtFQUNELE9BQU8sSUFBQSxpQkFBWSxFQUFDLElBQUEsd0JBQWtCLEVBQUMsR0FBRyxDQUFDLEVBQUUsV0FBVyxDQUFDLENBQUMsWUFBWSxFQUFFO0FBQzFFO0FBNkJBOzs7Ozs7Ozs7Ozs7OztBQWNHO0FBQ0ksZUFBZSxRQUFRLENBQzVCLFNBQW9CLEVBQ3BCLE9BQXlCO0VBRXpCLFNBQVMsR0FBRyxJQUFBLHdCQUFrQixFQUFDLFNBQVMsQ0FBQztFQUN6QyxPQUFPLFVBQVMsQ0FBQyxTQUE2QixFQUFFLE9BQU8sQ0FBQztBQUMxRDtBQUVBOzs7Ozs7Ozs7QUFTRztBQUNHLFNBQVUsV0FBVyxDQUFDLFNBQW9CO0VBQzlDLFNBQVMsR0FBRyxJQUFBLHdCQUFrQixFQUFDLFNBQVMsQ0FBQztFQUN6QyxPQUFPLGFBQVksQ0FBQyxTQUE2QixDQUFDO0FBQ3BEO0FBRUE7Ozs7Ozs7Ozs7OztBQVlHO0FBQ2EsU0FBQSxTQUFTLENBQ3ZCLFNBQW9CLEVBQ3BCLGNBQWlFO0VBRWpFLFNBQVMsR0FBRyxJQUFBLHdCQUFrQixFQUFDLFNBQVMsQ0FBQztFQUN6QyxPQUFPLFdBQVUsQ0FBQyxTQUE2QixFQUFFLGNBQWMsQ0FBQztBQUNsRTs7QUN0SkE7Ozs7O0FBS0c7QUF1Q0gseUJBQXlCLEVBQUU7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QXhCNUMzQjs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7QUFLSSxNQUFNLGlCQUFpQixHQUM1Qix5RkFBeUY7QUFFcEYsTUFBTSxRQUFRLEdBQUcsNENBQTRDO0FBRXBFO0FBQ08sTUFBTSxPQUFPLEdBQUcsU0FBUztBQUV6QixNQUFNLG1CQUFtQixHQUFHLGlCQUFpQjtBQWdCcEQ7QUFDTyxNQUFNLGdCQUFnQixHQUFHLENBQUM7QUFDMUIsTUFBTSx1QkFBdUIsR0FBRyxDQUFDO0FBRXhDLElBQVksYUFHWDtBQUhELFdBQVksV0FBVztFQUNyQixXQUFBLENBQUEsV0FBQSxzQ0FBZ0I7RUFDaEIsV0FBQSxDQUFBLFdBQUEsc0RBQXdCO0FBQzFCLENBQUMsRUFIVyxhQUFXLEtBQVgsYUFBVyxHQUd0Qjs7QUNuREQ7Ozs7Ozs7Ozs7Ozs7QUFhRztBQWdFSCxJQUFZLFdBR1g7QUFIRCxXQUFZLFdBQVc7RUFDckIsV0FBQSxtQ0FBK0I7RUFDL0IsV0FBQSxpREFBNkM7QUFDL0MsQ0FBQyxFQUhXLFdBQVcsS0FBWCxXQUFXLEdBR3RCOztBQ2hGRDs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7QUFFRyxTQUFVLGFBQWEsQ0FBQyxLQUErQjtFQUMzRCxNQUFNLFVBQVUsR0FBRyxJQUFJLFVBQVUsQ0FBQyxLQUFLLENBQUM7RUFDeEMsTUFBTSxZQUFZLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsR0FBRyxVQUFVLENBQUMsQ0FBQztFQUM3RCxPQUFPLFlBQVksQ0FBQyxPQUFPLENBQUMsSUFBSSxFQUFFLEVBQUUsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLENBQUMsT0FBTyxDQUFDLEtBQUssRUFBRSxHQUFHLENBQUM7QUFDL0U7QUFFTSxTQUFVLGFBQWEsQ0FBQyxZQUFvQjtFQUNoRCxNQUFNLE9BQU8sR0FBRyxHQUFHLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxHQUFJLFlBQVksQ0FBQyxNQUFNLEdBQUcsQ0FBRSxJQUFJLENBQUMsQ0FBQztFQUMvRCxNQUFNLE1BQU0sR0FBRyxDQUFDLFlBQVksR0FBRyxPQUFPLEVBQ25DLE9BQU8sQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLENBQ25CLE9BQU8sQ0FBQyxJQUFJLEVBQUUsR0FBRyxDQUFDO0VBRXJCLE1BQU0sT0FBTyxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUM7RUFDNUIsTUFBTSxXQUFXLEdBQUcsSUFBSSxVQUFVLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQztFQUVsRCxLQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsT0FBTyxDQUFDLE1BQU0sRUFBRSxFQUFFLENBQUMsRUFBRTtJQUN2QyxXQUFXLENBQUMsQ0FBQyxDQUFDLEdBQUcsT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7O0VBRXhDLE9BQU8sV0FBVztBQUNwQjs7QUNwQ0E7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBOENILE1BQU0sV0FBVyxHQUFHLHNCQUFzQjtBQUMxQzs7O0FBR0c7QUFDSCxNQUFNLGNBQWMsR0FBRyxDQUFDO0FBQ3hCLE1BQU0scUJBQXFCLEdBQUcsd0JBQXdCO0FBRS9DLGVBQWUsa0JBQWtCLENBQ3RDLFFBQWdCO0VBRWhCLElBQUksV0FBVyxJQUFJLFNBQVMsRUFBRTs7O0lBRzVCLE1BQU0sU0FBUyxHQUFHLE1BQ2hCLFNBR0QsQ0FBQyxTQUFTLEVBQUU7SUFDYixNQUFNLE9BQU8sR0FBRyxTQUFTLENBQUMsR0FBRyxDQUFDLEVBQUUsSUFBSSxFQUFFLENBQUMsSUFBSSxDQUFDO0lBRTVDLElBQUksQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDLFdBQVcsQ0FBQyxFQUFFOztNQUVsQyxPQUFPLElBQUk7OztFQUlmLElBQUksWUFBWSxHQUF3QixJQUFJO0VBRTVDLE1BQU0sRUFBRSxHQUFHLE1BQU0sR0FBQSxDQUFBLE1BQU0sQ0FBQyxXQUFXLEVBQUUsY0FBYyxFQUFFO0lBQ25ELE9BQU8sRUFBRSxNQUFBLENBQU8sRUFBRSxFQUFFLFVBQVUsRUFBRSxVQUFVLEVBQUUsa0JBQWtCLEtBQUk7O01BQ2hFLElBQUksVUFBVSxHQUFHLENBQUMsRUFBRTs7UUFFbEI7O01BR0YsSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FBQyxRQUFRLENBQUMscUJBQXFCLENBQUMsRUFBRTs7UUFFeEQ7O01BR0YsTUFBTSxXQUFXLEdBQUcsa0JBQWtCLENBQUMsV0FBVyxDQUFDLHFCQUFxQixDQUFDO01BQ3pFLE1BQU0sS0FBSyxHQUFHLE1BQU0sV0FBVyxDQUFDLEtBQUssQ0FBQyxhQUFhLENBQUMsQ0FBQyxHQUFHLENBQUMsUUFBUSxDQUFDO01BQ2xFLE1BQU0sV0FBVyxDQUFDLEtBQUssRUFBRTtNQUV6QixJQUFJLENBQUMsS0FBSyxFQUFFOztRQUVWOztNQUdGLElBQUksVUFBVSxLQUFLLENBQUMsRUFBRTtRQUNwQixNQUFNLFVBQVUsR0FBRyxLQUF1QjtRQUUxQyxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksSUFBSSxDQUFDLFVBQVUsQ0FBQyxNQUFNLElBQUksQ0FBQyxVQUFVLENBQUMsUUFBUSxFQUFFO1VBQ2xFOztRQUdGLFlBQVksR0FBRztVQUNiLEtBQUssRUFBRSxVQUFVLENBQUMsUUFBUTtVQUMxQixVQUFVLEVBQUUsQ0FBQSxFQUFBLEdBQUEsVUFBVSxDQUFDLFVBQVUsTUFBSSxRQUFBLEVBQUEsY0FBQSxFQUFBLEdBQUEsSUFBSSxDQUFDLEdBQUcsRUFBRTtVQUMvQyxtQkFBbUIsRUFBRTtZQUNuQixJQUFJLEVBQUUsVUFBVSxDQUFDLElBQUk7WUFDckIsTUFBTSxFQUFFLFVBQVUsQ0FBQyxNQUFNO1lBQ3pCLFFBQVEsRUFBRSxVQUFVLENBQUMsUUFBUTtZQUM3QixPQUFPLEVBQUUsVUFBVSxDQUFDLE9BQU87WUFDM0IsUUFBUSxFQUNOLE9BQU8sVUFBVSxDQUFDLFFBQVEsS0FBSyxRQUFRLEdBQ25DLFVBQVUsQ0FBQyxRQUFRLEdBQ25CLGFBQWEsQ0FBQyxVQUFVLENBQUMsUUFBUTtVQUN4QztTQUNGO09BQ0YsTUFBTSxJQUFJLFVBQVUsS0FBSyxDQUFDLEVBQUU7UUFDM0IsTUFBTSxVQUFVLEdBQUcsS0FBdUI7UUFFMUMsWUFBWSxHQUFHO1VBQ2IsS0FBSyxFQUFFLFVBQVUsQ0FBQyxRQUFRO1VBQzFCLFVBQVUsRUFBRSxVQUFVLENBQUMsVUFBVTtVQUNqQyxtQkFBbUIsRUFBRTtZQUNuQixJQUFJLEVBQUUsYUFBYSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7WUFDcEMsTUFBTSxFQUFFLGFBQWEsQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDO1lBQ3hDLFFBQVEsRUFBRSxVQUFVLENBQUMsUUFBUTtZQUM3QixPQUFPLEVBQUUsVUFBVSxDQUFDLE9BQU87WUFDM0IsUUFBUSxFQUFFLGFBQWEsQ0FBQyxVQUFVLENBQUMsUUFBUTtVQUM1QztTQUNGO09BQ0YsTUFBTSxJQUFJLFVBQVUsS0FBSyxDQUFDLEVBQUU7UUFDM0IsTUFBTSxVQUFVLEdBQUcsS0FBdUI7UUFFMUMsWUFBWSxHQUFHO1VBQ2IsS0FBSyxFQUFFLFVBQVUsQ0FBQyxRQUFRO1VBQzFCLFVBQVUsRUFBRSxVQUFVLENBQUMsVUFBVTtVQUNqQyxtQkFBbUIsRUFBRTtZQUNuQixJQUFJLEVBQUUsYUFBYSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7WUFDcEMsTUFBTSxFQUFFLGFBQWEsQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDO1lBQ3hDLFFBQVEsRUFBRSxVQUFVLENBQUMsUUFBUTtZQUM3QixPQUFPLEVBQUUsVUFBVSxDQUFDLE9BQU87WUFDM0IsUUFBUSxFQUFFLGFBQWEsQ0FBQyxVQUFVLENBQUMsUUFBUTtVQUM1QztTQUNGOzs7RUFHTixFQUFDO0VBQ0YsRUFBRSxDQUFDLEtBQUssRUFBRTs7RUFHVixNQUFNLEdBQUEsQ0FBQSxRQUFRLENBQUMsV0FBVyxDQUFDO0VBQzNCLE1BQU0sR0FBQSxDQUFBLFFBQVEsQ0FBQyxzQkFBc0IsQ0FBQztFQUN0QyxNQUFNLEdBQUEsQ0FBQSxRQUFRLENBQUMsV0FBVyxDQUFDO0VBRTNCLE9BQU8saUJBQWlCLENBQUMsWUFBWSxDQUFDLEdBQUcsWUFBWSxHQUFHLElBQUk7QUFDOUQ7QUFFQSxTQUFTLGlCQUFpQixDQUN4QixZQUFpQztFQUVqQyxJQUFJLENBQUMsWUFBWSxJQUFJLENBQUMsWUFBWSxDQUFDLG1CQUFtQixFQUFFO0lBQ3RELE9BQU8sS0FBSzs7RUFFZCxNQUFNO0lBQUU7RUFBbUIsQ0FBRSxHQUFHLFlBQVk7RUFDNUMsT0FDRSxPQUFPLFlBQVksQ0FBQyxVQUFVLEtBQUssUUFBUSxJQUMzQyxZQUFZLENBQUMsVUFBVSxHQUFHLENBQUMsSUFDM0IsT0FBTyxZQUFZLENBQUMsS0FBSyxLQUFLLFFBQVEsSUFDdEMsWUFBWSxDQUFDLEtBQUssQ0FBQyxNQUFNLEdBQUcsQ0FBQyxJQUM3QixPQUFPLG1CQUFtQixDQUFDLElBQUksS0FBSyxRQUFRLElBQzVDLG1CQUFtQixDQUFDLElBQUksQ0FBQyxNQUFNLEdBQUcsQ0FBQyxJQUNuQyxPQUFPLG1CQUFtQixDQUFDLE1BQU0sS0FBSyxRQUFRLElBQzlDLG1CQUFtQixDQUFDLE1BQU0sQ0FBQyxNQUFNLEdBQUcsQ0FBQyxJQUNyQyxPQUFPLG1CQUFtQixDQUFDLFFBQVEsS0FBSyxRQUFRLElBQ2hELG1CQUFtQixDQUFDLFFBQVEsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxJQUN2QyxPQUFPLG1CQUFtQixDQUFDLE9BQU8sS0FBSyxRQUFRLElBQy9DLG1CQUFtQixDQUFDLE9BQU8sQ0FBQyxNQUFNLEdBQUcsQ0FBQyxJQUN0QyxPQUFPLG1CQUFtQixDQUFDLFFBQVEsS0FBSyxRQUFRLElBQ2hELG1CQUFtQixDQUFDLFFBQVEsQ0FBQyxNQUFNLEdBQUcsQ0FBQztBQUUzQzs7QUNwTUE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBUUg7QUFDTyxNQUFNLGFBQWEsR0FBRyw2QkFBNkI7QUFDMUQsTUFBTSxnQkFBZ0IsR0FBRyxDQUFDO0FBQzFCLE1BQU0saUJBQWlCLEdBQUcsMEJBQTBCO0FBU3BELElBQUksU0FBUyxHQUE4QyxJQUFJO0FBQy9ELFNBQVMsWUFBWSxDQUFBO0VBQ25CLElBQUksQ0FBQyxTQUFTLEVBQUU7SUFDZCxTQUFTLEdBQUcsR0FBQSxDQUFBLE1BQU0sQ0FBQyxhQUFhLEVBQUUsZ0JBQWdCLEVBQUU7TUFDbEQsT0FBTyxFQUFFLENBQUMsU0FBUyxFQUFFLFVBQVUsS0FBSTs7Ozs7UUFLakMsUUFBUSxVQUFVO1VBQ2hCLEtBQUssQ0FBQztZQUNKLFNBQVMsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsQ0FBQzs7O0lBR3JELEVBQUM7O0VBRUosT0FBTyxTQUFTO0FBQ2xCO0FBRUE7QUFDTyxlQUFlLEtBQUssQ0FDekIsb0JBQWtEO0VBRWxELE1BQU0sR0FBRyxHQUFHLE1BQU0sQ0FBQyxvQkFBb0IsQ0FBQztFQUN4QyxNQUFNLEVBQUUsR0FBRyxNQUFNLFlBQVksRUFBRTtFQUMvQixNQUFNLFlBQVksR0FBSSxNQUFNLEVBQUUsQ0FDM0IsV0FBVyxDQUFDLGlCQUFpQixDQUFDLENBQzlCLFdBQVcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUM5QixHQUFHLENBQUMsR0FBRyxDQUFrQjtFQUU1QixJQUFJLFlBQVksRUFBRTtJQUNoQixPQUFPLFlBQVk7R0FDcEIsTUFBTTs7SUFFTCxNQUFNLGVBQWUsR0FBRyxNQUFNLGtCQUFrQixDQUM5QyxvQkFBb0IsQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUN4QztJQUNELElBQUksZUFBZSxFQUFFO01BQ25CLE1BQU0sS0FBSyxDQUFDLG9CQUFvQixFQUFFLGVBQWUsQ0FBQztNQUNsRCxPQUFPLGVBQWU7OztBQUc1QjtBQUVBO0FBQ08sZUFBZSxLQUFLLENBQ3pCLG9CQUFrRCxFQUNsRCxZQUEwQjtFQUUxQixNQUFNLEdBQUcsR0FBRyxNQUFNLENBQUMsb0JBQW9CLENBQUM7RUFDeEMsTUFBTSxFQUFFLEdBQUcsTUFBTSxZQUFZLEVBQUU7RUFDL0IsTUFBTSxFQUFFLEdBQUcsRUFBRSxDQUFDLFdBQVcsQ0FBQyxpQkFBaUIsRUFBRSxXQUFXLENBQUM7RUFDekQsTUFBTSxFQUFFLENBQUMsV0FBVyxDQUFDLGlCQUFpQixDQUFDLENBQUMsR0FBRyxDQUFDLFlBQVksRUFBRSxHQUFHLENBQUM7RUFDOUQsTUFBTSxFQUFFLENBQUMsSUFBSTtFQUNiLE9BQU8sWUFBWTtBQUNyQjtBQUVBO0FBQ08sZUFBZSxRQUFRLENBQzVCLG9CQUFrRDtFQUVsRCxNQUFNLEdBQUcsR0FBRyxNQUFNLENBQUMsb0JBQW9CLENBQUM7RUFDeEMsTUFBTSxFQUFFLEdBQUcsTUFBTSxZQUFZLEVBQUU7RUFDL0IsTUFBTSxFQUFFLEdBQUcsRUFBRSxDQUFDLFdBQVcsQ0FBQyxpQkFBaUIsRUFBRSxXQUFXLENBQUM7RUFDekQsTUFBTSxFQUFFLENBQUMsV0FBVyxDQUFDLGlCQUFpQixDQUFDLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQztFQUNuRCxNQUFNLEVBQUUsQ0FBQyxJQUFJO0FBQ2Y7QUFXQSxTQUFTLE1BQU0sQ0FBQztFQUFFO0FBQVMsQ0FBZ0M7RUFDekQsT0FBTyxTQUFTLENBQUMsS0FBSztBQUN4Qjs7QUNsSEE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBeUJJLE1BQU0sU0FBUyxHQUF3QjtFQUM1Qyx5RUFDRSxpREFBaUQ7RUFDbkQsa0VBQ0UsK0NBQStDO0VBQ2pELDBEQUNFLHVEQUF1RDtFQUN6RCwyREFDRSxvRUFBb0U7RUFDdEUsMkRBQ0Usa0VBQWtFO0VBQ3BFLDZEQUNFLDBFQUEwRTtFQUM1RSxtRUFDRSxrR0FBa0c7RUFDcEcsb0ZBQ0UsOEVBQThFO0VBQ2hGLG1FQUNFLG9FQUFvRTtFQUN0RSx1RUFDRSwwREFBMEQ7RUFDNUQsdUVBQ0UsNkNBQTZDLEdBQzdDLDZCQUE2QjtFQUMvQiw2REFDRSxtRUFBbUU7RUFDckUsaUVBQ0UsdURBQXVEO0VBQ3pELG1FQUNFLG9FQUFvRSxHQUNwRSx5RUFBeUU7RUFDM0UscUVBQ0Usc0VBQXNFO0VBQ3hFLDJEQUNFLGdFQUFnRTtFQUNsRSx5REFBK0Isd0NBQXdDO0VBQ3ZFLGlGQUNFLHFFQUFxRSxHQUNyRTtDQUNIO0FBWU0sTUFBTSxhQUFhLEdBQUcsSUFBSSxJQUFBLENBQUEsWUFBWSxDQUMzQyxXQUFXLEVBQ1gsV0FBVyxFQUNYLFNBQVMsQ0FDVjs7QUMvRkQ7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBdUJJLGVBQWUsZUFBZSxDQUNuQyxvQkFBa0QsRUFDbEQsbUJBQXdDO0VBRXhDLE1BQU0sT0FBTyxHQUFHLE1BQU0sVUFBVSxDQUFDLG9CQUFvQixDQUFDO0VBQ3RELE1BQU0sSUFBSSxHQUFHLE9BQU8sQ0FBQyxtQkFBbUIsQ0FBQztFQUV6QyxNQUFNLGdCQUFnQixHQUFHO0lBQ3ZCLE1BQU0sRUFBRSxNQUFNO0lBQ2QsT0FBTztJQUNQLElBQUksRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUk7R0FDMUI7RUFFRCxJQUFJLFlBQXlCO0VBQzdCLElBQUk7SUFDRixNQUFNLFFBQVEsR0FBRyxNQUFNLEtBQUssQ0FDMUIsV0FBVyxDQUFDLG9CQUFvQixDQUFDLFNBQVMsQ0FBQyxFQUMzQyxnQkFBZ0IsQ0FDakI7SUFDRCxZQUFZLEdBQUcsTUFBTSxRQUFRLENBQUMsSUFBSSxFQUFFO0dBQ3JDLENBQUMsT0FBTyxHQUFHLEVBQUU7SUFDWixNQUFNLGFBQWEsQ0FBQyxNQUFNLENBQW1DO01BQzNELFNBQVMsRUFBRyxHQUFhLEtBQWIsUUFBQSxHQUFHLHVCQUFILEdBQUcsQ0FBWSxRQUFRO0lBQ3BDLEVBQUM7O0VBR0osSUFBSSxZQUFZLENBQUMsS0FBSyxFQUFFO0lBQ3RCLE1BQU0sT0FBTyxHQUFHLFlBQVksQ0FBQyxLQUFLLENBQUMsT0FBTztJQUMxQyxNQUFNLGFBQWEsQ0FBQyxNQUFNLENBQW1DO01BQzNELFNBQVMsRUFBRTtJQUNaLEVBQUM7O0VBR0osSUFBSSxDQUFDLFlBQVksQ0FBQyxLQUFLLEVBQUU7SUFDdkIsTUFBTSxhQUFhLENBQUMsTUFBTSxxRUFBb0M7O0VBR2hFLE9BQU8sWUFBWSxDQUFDLEtBQUs7QUFDM0I7QUFFTyxlQUFlLGtCQUFrQixDQUN0QyxvQkFBa0QsRUFDbEQsWUFBMEI7RUFFMUIsTUFBTSxPQUFPLEdBQUcsTUFBTSxVQUFVLENBQUMsb0JBQW9CLENBQUM7RUFDdEQsTUFBTSxJQUFJLEdBQUcsT0FBTyxDQUFDLFlBQVksQ0FBQyxtQkFBb0IsQ0FBQztFQUV2RCxNQUFNLGFBQWEsR0FBRztJQUNwQixNQUFNLEVBQUUsT0FBTztJQUNmLE9BQU87SUFDUCxJQUFJLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJO0dBQzFCO0VBRUQsSUFBSSxZQUF5QjtFQUM3QixJQUFJO0lBQ0YsTUFBTSxRQUFRLEdBQUcsTUFBTSxLQUFLLENBQzFCLEdBQUcsV0FBVyxDQUFDLG9CQUFvQixDQUFDLFNBQVMsQ0FBQyxJQUFJLFlBQVksQ0FBQyxLQUFLLEVBQUUsRUFDdEUsYUFBYSxDQUNkO0lBQ0QsWUFBWSxHQUFHLE1BQU0sUUFBUSxDQUFDLElBQUksRUFBRTtHQUNyQyxDQUFDLE9BQU8sR0FBRyxFQUFFO0lBQ1osTUFBTSxhQUFhLENBQUMsTUFBTSxDQUFnQztNQUN4RCxTQUFTLEVBQUcsR0FBYSxLQUFiLFFBQUEsR0FBRyx1QkFBSCxHQUFHLENBQVksUUFBUTtJQUNwQyxFQUFDOztFQUdKLElBQUksWUFBWSxDQUFDLEtBQUssRUFBRTtJQUN0QixNQUFNLE9BQU8sR0FBRyxZQUFZLENBQUMsS0FBSyxDQUFDLE9BQU87SUFDMUMsTUFBTSxhQUFhLENBQUMsTUFBTSxDQUFnQztNQUN4RCxTQUFTLEVBQUU7SUFDWixFQUFDOztFQUdKLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFO0lBQ3ZCLE1BQU0sYUFBYSxDQUFDLE1BQU0sK0RBQWlDOztFQUc3RCxPQUFPLFlBQVksQ0FBQyxLQUFLO0FBQzNCO0FBRU8sZUFBZSxrQkFBa0IsQ0FDdEMsb0JBQWtELEVBQ2xELEtBQWE7RUFFYixNQUFNLE9BQU8sR0FBRyxNQUFNLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQztFQUV0RCxNQUFNLGtCQUFrQixHQUFHO0lBQ3pCLE1BQU0sRUFBRSxRQUFRO0lBQ2hCO0dBQ0Q7RUFFRCxJQUFJO0lBQ0YsTUFBTSxRQUFRLEdBQUcsTUFBTSxLQUFLLENBQzFCLEdBQUcsV0FBVyxDQUFDLG9CQUFvQixDQUFDLFNBQVMsQ0FBQyxJQUFJLEtBQUssRUFBRSxFQUN6RCxrQkFBa0IsQ0FDbkI7SUFDRCxNQUFNLFlBQVksR0FBZ0IsTUFBTSxRQUFRLENBQUMsSUFBSSxFQUFFO0lBQ3ZELElBQUksWUFBWSxDQUFDLEtBQUssRUFBRTtNQUN0QixNQUFNLE9BQU8sR0FBRyxZQUFZLENBQUMsS0FBSyxDQUFDLE9BQU87TUFDMUMsTUFBTSxhQUFhLENBQUMsTUFBTSxDQUFxQztRQUM3RCxTQUFTLEVBQUU7TUFDWixFQUFDOztHQUVMLENBQUMsT0FBTyxHQUFHLEVBQUU7SUFDWixNQUFNLGFBQWEsQ0FBQyxNQUFNLENBQXFDO01BQzdELFNBQVMsRUFBRyxHQUFhLEtBQWIsUUFBQSxHQUFHLHVCQUFILEdBQUcsQ0FBWSxRQUFRO0lBQ3BDLEVBQUM7O0FBRU47QUFFQSxTQUFTLFdBQVcsQ0FBQztFQUFFO0FBQVMsQ0FBYTtFQUMzQyxPQUFPLEdBQUcsUUFBUSxhQUFhLFNBQVUsZ0JBQWdCO0FBQzNEO0FBRUEsZUFBZSxVQUFVLENBQUM7RUFDeEIsU0FBUztFQUNUO0FBQWEsQ0FDZ0I7RUFDN0IsTUFBTSxTQUFTLEdBQUcsTUFBTSxhQUFhLENBQUMsUUFBUSxFQUFFO0VBRWhELE9BQU8sSUFBSSxPQUFPLENBQUM7SUFDakIsY0FBYyxFQUFFLGtCQUFrQjtJQUNsQyxNQUFNLEVBQUUsa0JBQWtCO0lBQzFCLGdCQUFnQixFQUFFLFNBQVMsQ0FBQyxNQUFPO0lBQ25DLG9DQUFvQyxFQUFFLE9BQU8sU0FBUztFQUN2RCxFQUFDO0FBQ0o7QUFFQSxTQUFTLE9BQU8sQ0FBQztFQUNmLE1BQU07RUFDTixJQUFJO0VBQ0osUUFBUTtFQUNSO0FBQVEsQ0FDWTtFQUNwQixNQUFNLElBQUksR0FBbUI7SUFDM0IsR0FBRyxFQUFFO01BQ0gsUUFBUTtNQUNSLElBQUk7TUFDSjtJQUNEO0dBQ0Y7RUFFRCxJQUFJLFFBQVEsS0FBSyxpQkFBaUIsRUFBRTtJQUNsQyxJQUFJLENBQUMsR0FBRyxDQUFDLGlCQUFpQixHQUFHLFFBQVE7O0VBR3ZDLE9BQU8sSUFBSTtBQUNiOztBQ3pMQTs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7QUFpQkg7QUFDQSxNQUFNLG1CQUFtQixHQUFHLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxJQUFJLENBQUM7QUFFN0MsZUFBZSxnQkFBZ0IsQ0FDcEMsU0FBMkI7RUFFM0IsTUFBTSxnQkFBZ0IsR0FBRyxNQUFNLG1CQUFtQixDQUNoRCxTQUFTLENBQUMsY0FBZSxFQUN6QixTQUFTLENBQUMsUUFBUyxDQUNwQjtFQUVELE1BQU0sbUJBQW1CLEdBQXdCO0lBQy9DLFFBQVEsRUFBRSxTQUFTLENBQUMsUUFBUztJQUM3QixPQUFPLEVBQUUsU0FBUyxDQUFDLGNBQWUsQ0FBQyxLQUFLO0lBQ3hDLFFBQVEsRUFBRSxnQkFBZ0IsQ0FBQyxRQUFRO0lBQ25DLElBQUksRUFBRSxhQUFhLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBRSxDQUFDO0lBQ3JELE1BQU0sRUFBRSxhQUFhLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLFFBQVEsQ0FBRTtHQUN6RDtFQUVELE1BQU0sWUFBWSxHQUFHLE1BQU0sS0FBSyxDQUFDLFNBQVMsQ0FBQyxvQkFBb0IsQ0FBQztFQUNoRSxJQUFJLENBQUMsWUFBWSxFQUFFOztJQUVqQixPQUFPLFdBQVcsQ0FBQyxTQUFTLENBQUMsb0JBQW9CLEVBQUUsbUJBQW1CLENBQUM7R0FDeEUsTUFBTSxJQUNMLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxtQkFBb0IsRUFBRSxtQkFBbUIsQ0FBQyxFQUNyRTs7SUFFQSxJQUFJO01BQ0YsTUFBTSxrQkFBa0IsQ0FDdEIsU0FBUyxDQUFDLG9CQUFxQixFQUMvQixZQUFZLENBQUMsS0FBSyxDQUNuQjtLQUNGLENBQUMsT0FBTyxDQUFDLEVBQUU7O01BRVYsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7O0lBR2pCLE9BQU8sV0FBVyxDQUFDLFNBQVMsQ0FBQyxvQkFBcUIsRUFBRSxtQkFBbUIsQ0FBQztHQUN6RSxNQUFNLElBQUksSUFBSSxDQUFDLEdBQUcsRUFBRSxJQUFJLFlBQVksQ0FBQyxVQUFVLEdBQUcsbUJBQW1CLEVBQUU7O0lBRXRFLE9BQU8sV0FBVyxDQUFDLFNBQVMsRUFBRTtNQUM1QixLQUFLLEVBQUUsWUFBWSxDQUFDLEtBQUs7TUFDekIsVUFBVSxFQUFFLElBQUksQ0FBQyxHQUFHLEVBQUU7TUFDdEI7SUFDRCxFQUFDO0dBQ0gsTUFBTTs7SUFFTCxPQUFPLFlBQVksQ0FBQyxLQUFLOztBQUU3QjtBQUVBOzs7QUFHRztBQUNJLGVBQWUsbUJBQW1CLENBQ3ZDLFNBQTJCO0VBRTNCLE1BQU0sWUFBWSxHQUFHLE1BQU0sS0FBSyxDQUFDLFNBQVMsQ0FBQyxvQkFBb0IsQ0FBQztFQUNoRSxJQUFJLFlBQVksRUFBRTtJQUNoQixNQUFNLGtCQUFrQixDQUN0QixTQUFTLENBQUMsb0JBQW9CLEVBQzlCLFlBQVksQ0FBQyxLQUFLLENBQ25CO0lBQ0QsTUFBTSxRQUFRLENBQUMsU0FBUyxDQUFDLG9CQUFvQixDQUFDOzs7RUFJaEQsTUFBTSxnQkFBZ0IsR0FDcEIsTUFBTSxTQUFTLENBQUMsY0FBZSxDQUFDLFdBQVcsQ0FBQyxlQUFlLEVBQUU7RUFDL0QsSUFBSSxnQkFBZ0IsRUFBRTtJQUNwQixPQUFPLGdCQUFnQixDQUFDLFdBQVcsRUFBRTs7O0VBSXZDLE9BQU8sSUFBSTtBQUNiO0FBRUEsZUFBZSxXQUFXLENBQ3hCLFNBQTJCLEVBQzNCLFlBQTBCO0VBRTFCLElBQUk7SUFDRixNQUFNLFlBQVksR0FBRyxNQUFNLGtCQUFrQixDQUMzQyxTQUFTLENBQUMsb0JBQW9CLEVBQzlCLFlBQVksQ0FDYjtJQUVELE1BQU0sbUJBQW1CLEdBQUEsTUFBQSxDQUFBLE1BQUEsQ0FBQSxNQUFBLENBQUEsTUFBQSxLQUNwQixZQUFZO01BQ2YsS0FBSyxFQUFFLFlBQVk7TUFDbkIsVUFBVSxFQUFFLElBQUksQ0FBQyxHQUFHO0lBQUUsRUFDdkI7SUFFRCxNQUFNLEtBQUssQ0FBQyxTQUFTLENBQUMsb0JBQW9CLEVBQUUsbUJBQW1CLENBQUM7SUFDaEUsT0FBTyxZQUFZO0dBQ3BCLENBQUMsT0FBTyxDQUFDLEVBQUU7SUFDVixNQUFNLENBQUM7O0FBRVg7QUFFQSxlQUFlLFdBQVcsQ0FDeEIsb0JBQWtELEVBQ2xELG1CQUF3QztFQUV4QyxNQUFNLEtBQUssR0FBRyxNQUFNLGVBQWUsQ0FDakMsb0JBQW9CLEVBQ3BCLG1CQUFtQixDQUNwQjtFQUNELE1BQU0sWUFBWSxHQUFpQjtJQUNqQyxLQUFLO0lBQ0wsVUFBVSxFQUFFLElBQUksQ0FBQyxHQUFHLEVBQUU7SUFDdEI7R0FDRDtFQUNELE1BQU0sS0FBSyxDQUFDLG9CQUFvQixFQUFFLFlBQVksQ0FBQztFQUMvQyxPQUFPLFlBQVksQ0FBQyxLQUFLO0FBQzNCO0FBRUE7O0FBRUc7QUFDSCxlQUFlLG1CQUFtQixDQUNoQyxjQUF5QyxFQUN6QyxRQUFnQjtFQUVoQixNQUFNLFlBQVksR0FBRyxNQUFNLGNBQWMsQ0FBQyxXQUFXLENBQUMsZUFBZSxFQUFFO0VBQ3ZFLElBQUksWUFBWSxFQUFFO0lBQ2hCLE9BQU8sWUFBWTs7RUFHckIsT0FBTyxjQUFjLENBQUMsV0FBVyxDQUFDLFNBQVMsQ0FBQztJQUMxQyxlQUFlLEVBQUUsSUFBSTs7O0lBR3JCLG9CQUFvQixFQUFFLGFBQWEsQ0FBQyxRQUFRO0VBQzdDLEVBQUM7QUFDSjtBQUVBOztBQUVHO0FBQ0gsU0FBUyxZQUFZLENBQ25CLFNBQThCLEVBQzlCLGNBQW1DO0VBRW5DLE1BQU0sZUFBZSxHQUFHLGNBQWMsQ0FBQyxRQUFRLEtBQUssU0FBUyxDQUFDLFFBQVE7RUFDdEUsTUFBTSxlQUFlLEdBQUcsY0FBYyxDQUFDLFFBQVEsS0FBSyxTQUFTLENBQUMsUUFBUTtFQUN0RSxNQUFNLFdBQVcsR0FBRyxjQUFjLENBQUMsSUFBSSxLQUFLLFNBQVMsQ0FBQyxJQUFJO0VBQzFELE1BQU0sYUFBYSxHQUFHLGNBQWMsQ0FBQyxNQUFNLEtBQUssU0FBUyxDQUFDLE1BQU07RUFFaEUsT0FBTyxlQUFlLElBQUksZUFBZSxJQUFJLFdBQVcsSUFBSSxhQUFhO0FBQzNFOztBQ3ZMQTs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7QUFLRyxTQUFVLGtCQUFrQixDQUNoQyxlQUF1QztFQUV2QyxNQUFNLE9BQU8sR0FBbUI7SUFDOUIsSUFBSSxFQUFFLGVBQWUsQ0FBQyxJQUFJOztJQUUxQixXQUFXLEVBQUUsZUFBZSxDQUFDLFlBQVk7O0lBRXpDLFNBQVMsRUFBRSxlQUFlLENBQUM7R0FDVjtFQUVuQiw0QkFBNEIsQ0FBQyxPQUFPLEVBQUUsZUFBZSxDQUFDO0VBQ3RELG9CQUFvQixDQUFDLE9BQU8sRUFBRSxlQUFlLENBQUM7RUFDOUMsbUJBQW1CLENBQUMsT0FBTyxFQUFFLGVBQWUsQ0FBQztFQUU3QyxPQUFPLE9BQU87QUFDaEI7QUFFQSxTQUFTLDRCQUE0QixDQUNuQyxPQUF1QixFQUN2QixzQkFBOEM7RUFFOUMsSUFBSSxDQUFDLHNCQUFzQixDQUFDLFlBQVksRUFBRTtJQUN4Qzs7RUFHRixPQUFPLENBQUMsWUFBWSxHQUFHLEVBQUU7RUFFekIsTUFBTSxLQUFLLEdBQUcsc0JBQXNCLENBQUMsWUFBYSxDQUFDLEtBQUs7RUFDeEQsSUFBSSxDQUFDLENBQUMsS0FBSyxFQUFFO0lBQ1gsT0FBTyxDQUFDLFlBQWEsQ0FBQyxLQUFLLEdBQUcsS0FBSzs7RUFHckMsTUFBTSxJQUFJLEdBQUcsc0JBQXNCLENBQUMsWUFBYSxDQUFDLElBQUk7RUFDdEQsSUFBSSxDQUFDLENBQUMsSUFBSSxFQUFFO0lBQ1YsT0FBTyxDQUFDLFlBQWEsQ0FBQyxJQUFJLEdBQUcsSUFBSTs7RUFHbkMsTUFBTSxLQUFLLEdBQUcsc0JBQXNCLENBQUMsWUFBYSxDQUFDLEtBQUs7RUFDeEQsSUFBSSxDQUFDLENBQUMsS0FBSyxFQUFFO0lBQ1gsT0FBTyxDQUFDLFlBQWEsQ0FBQyxLQUFLLEdBQUcsS0FBSzs7RUFHckMsTUFBTSxJQUFJLEdBQUcsc0JBQXNCLENBQUMsWUFBYSxDQUFDLElBQUk7RUFDdEQsSUFBSSxDQUFDLENBQUMsSUFBSSxFQUFFO0lBQ1YsT0FBTyxDQUFDLFlBQWEsQ0FBQyxJQUFJLEdBQUcsSUFBSTs7QUFFckM7QUFFQSxTQUFTLG9CQUFvQixDQUMzQixPQUF1QixFQUN2QixzQkFBOEM7RUFFOUMsSUFBSSxDQUFDLHNCQUFzQixDQUFDLElBQUksRUFBRTtJQUNoQzs7RUFHRixPQUFPLENBQUMsSUFBSSxHQUFHLHNCQUFzQixDQUFDLElBQWlDO0FBQ3pFO0FBRUEsU0FBUyxtQkFBbUIsQ0FDMUIsT0FBdUIsRUFDdkIsc0JBQThDOzs7RUFHOUMsSUFDRSxDQUFDLHNCQUFzQixDQUFDLFVBQVUsSUFDbEMsRUFBQyxDQUFBLEVBQUEsR0FBQSxzQkFBc0IsQ0FBQyxZQUFZLE1BQUUsUUFBQSxFQUFBLHVCQUFBLEVBQUEsQ0FBQSxZQUFZLEdBQ2xEO0lBQ0E7O0VBR0YsT0FBTyxDQUFDLFVBQVUsR0FBRyxFQUFFO0VBRXZCLE1BQU0sSUFBSSxHQUNSLENBQUEsRUFBQSxJQUFBLEVBQUEsR0FBQSxzQkFBc0IsQ0FBQyxVQUFVLGNBQUEsRUFBQSx1QkFBQSxFQUFBLENBQUUsSUFBSSxjQUFBLEVBQUEsY0FBQSxFQUFBLEdBQ3ZDLENBQUEsRUFBQSxHQUFBLHNCQUFzQixDQUFDLFlBQVksY0FBQSxFQUFBLHVCQUFBLEVBQUEsQ0FBRSxZQUFZO0VBRW5ELElBQUksQ0FBQyxDQUFDLElBQUksRUFBRTtJQUNWLE9BQU8sQ0FBQyxVQUFXLENBQUMsSUFBSSxHQUFHLElBQUk7OztFQUlqQyxNQUFNLGNBQWMsR0FBRyxDQUFBLEVBQUEsR0FBQSxzQkFBc0IsQ0FBQyxVQUFVLGNBQUEsRUFBQSx1QkFBQSxFQUFBLENBQUUsZUFBZTtFQUN6RSxJQUFJLENBQUMsQ0FBQyxjQUFjLEVBQUU7SUFDcEIsT0FBTyxDQUFDLFVBQVcsQ0FBQyxjQUFjLEdBQUcsY0FBYzs7QUFFdkQ7O0FDM0dBOzs7Ozs7Ozs7Ozs7Ozs7QUFlRztBQUtHLFNBQVUsZ0JBQWdCLENBQUMsSUFBYTs7RUFFNUMsT0FBTyxPQUFPLElBQUksS0FBSyxRQUFRLElBQUksQ0FBQyxDQUFDLElBQUksSUFBSSxtQkFBbUIsSUFBSSxJQUFJO0FBQzFFOztBZ0J2QkE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBRUg7QUFDTSxTQUFVLEtBQUssQ0FBQyxFQUFVO0VBQzlCLE9BQU8sSUFBSSxPQUFPLENBQU8sT0FBTyxJQUFHO0lBQ2pDLFVBQVUsQ0FBQyxPQUFPLEVBQUUsRUFBRSxDQUFDO0VBQ3pCLENBQUMsQ0FBQztBQUNKOztBZnRCQTs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7QUF5QnVCLGFBQWEsQ0FDckMsc0JBQXNCLEVBQ3RCLHFCQUFxQjtBQStHaEIsZUFBZSxRQUFRLENBQzVCLFNBQTJCLEVBQzNCLGVBQXVDO0VBRXZDLE1BQU0sUUFBUSxHQUFHLGNBQWMsQ0FDN0IsZUFBZSxFQUNmLE1BQU0sU0FBUyxDQUFDLG9CQUFvQixDQUFDLGFBQWEsQ0FBQyxLQUFLLEVBQUUsQ0FDM0Q7RUFFRCx3QkFBd0IsQ0FBQyxTQUFTLEVBQUUsUUFBUSxFQUFFLGVBQWUsQ0FBQyxTQUFTLENBQUM7QUFDMUU7QUFFQSxTQUFTLGNBQWMsQ0FDckIsZUFBdUMsRUFDdkMsR0FBVzs7RUFFWCxNQUFNLFFBQVEsR0FBRyxFQUFjOzs7RUFJL0IsSUFBSSxDQUFDLENBQUMsZUFBZSxDQUFDLElBQUksRUFBRTtJQUMxQixRQUFRLENBQUMsY0FBYyxHQUFHLGVBQWUsQ0FBQyxJQUFJOztFQUdoRCxJQUFJLENBQUMsQ0FBQyxlQUFlLENBQUMsWUFBWSxFQUFFO0lBQ2xDLFFBQVEsQ0FBQyxVQUFVLEdBQUcsZUFBZSxDQUFDLFlBQVk7O0VBR3BELFFBQVEsQ0FBQyxXQUFXLEdBQUcsR0FBRztFQUUxQixJQUFJLENBQUMsQ0FBQyxlQUFlLENBQUMsWUFBWSxFQUFFO0lBQ2xDLFFBQVEsQ0FBQyxZQUFZLEdBQUcsYUFBVyxDQUFDLG9CQUFvQixDQUFDLFFBQVEsRUFBRTtHQUNwRSxNQUFNO0lBQ0wsUUFBUSxDQUFDLFlBQVksR0FBRyxhQUFXLENBQUMsWUFBWSxDQUFDLFFBQVEsRUFBRTs7RUFHN0QsUUFBUSxDQUFDLFlBQVksR0FBRyxnQkFBZ0IsQ0FBQyxRQUFRLEVBQUU7RUFDbkQsUUFBUSxDQUFDLFlBQVksR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxlQUFlLEVBQUUsRUFBRSxDQUFDO0VBRWhFLElBQUksQ0FBQyxDQUFDLGVBQWUsQ0FBQyxZQUFZLEVBQUU7SUFDbEMsUUFBUSxDQUFDLFlBQVksR0FBRyxlQUFlLENBQUMsWUFBWTs7RUFHdEQsUUFBUSxDQUFDLEtBQUssR0FBRyx1QkFBdUIsQ0FBQyxRQUFRLEVBQUU7RUFFbkQsSUFBSSxDQUFDLEVBQUMsQ0FBQSxFQUFBLEdBQUEsZUFBZSxDQUFDLFVBQVUsTUFBRSxRQUFBLEVBQUEsdUJBQUEsRUFBQSxDQUFBLGVBQWUsR0FBRTtJQUNqRCxRQUFRLENBQUMsZUFBZSxHQUFHLENBQUEsRUFBQSxHQUFBLGVBQWUsQ0FBQyxVQUFVLE1BQUUsUUFBQSxFQUFBLHVCQUFBLEVBQUEsQ0FBQSxlQUFlOzs7RUFJeEUsT0FBTyxRQUFRO0FBQ2pCO0FBRUEsU0FBUyx3QkFBd0IsQ0FDL0IsU0FBMkIsRUFDM0IsUUFBa0IsRUFDbEIsU0FBaUI7RUFFakIsTUFBTSxRQUFRLEdBQUcsRUFBYzs7RUFHL0IsUUFBUSxDQUFDLGFBQWEsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxHQUFHLEVBQUUsQ0FBQyxDQUFDLFFBQVEsRUFBRTtFQUMxRCxRQUFRLENBQUMsNEJBQTRCLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUNyRCxzQkFBc0IsRUFBRTtFQUN6QixFQUFDO0VBRUYsSUFBSSxDQUFDLENBQUMsU0FBUyxFQUFFO0lBQ2YsUUFBUSxDQUFDLGVBQWUsR0FBRyxtQkFBbUIsQ0FBQyxTQUFTLENBQUM7OztFQUkzRCxTQUFTLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUM7QUFDcEM7QUFFQSxTQUFTLG1CQUFtQixDQUFDLFNBQWlCO0VBQzVDLE1BQU0sY0FBYyxHQUFtQjtJQUNyQyxlQUFlLEVBQUU7TUFDZixRQUFRLEVBQUU7UUFDUiw0QkFBNEIsRUFBRTtNQUMvQjtJQUNGO0dBQ0Y7RUFFRCxPQUFPLGNBQWM7QUFDdkI7QUFhZ0IsU0FBQSxhQUFhLENBQUMsRUFBVSxFQUFFLEVBQVU7RUFDbEQsTUFBTSxXQUFXLEdBQUcsRUFBRTtFQUN0QixLQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsRUFBRSxDQUFDLE1BQU0sRUFBRSxDQUFDLEVBQUUsRUFBRTtJQUNsQyxXQUFXLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDOUIsSUFBSSxDQUFDLEdBQUcsRUFBRSxDQUFDLE1BQU0sRUFBRTtNQUNqQixXQUFXLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUM7OztFQUlsQyxPQUFPLFdBQVcsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDO0FBQzdCOztBZ0JwUUE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBcUNJLGVBQWUsV0FBVyxDQUMvQixLQUFrQyxFQUNsQyxTQUEyQjs7RUFFM0IsTUFBTTtJQUFFO0VBQWUsQ0FBRSxHQUFHLEtBQUs7RUFDakMsSUFBSSxDQUFDLGVBQWUsRUFBRTs7SUFFcEIsTUFBTSxtQkFBbUIsQ0FBQyxTQUFTLENBQUM7SUFDcEM7O0VBR0YsTUFBTSxZQUFZLEdBQUcsTUFBTSxLQUFLLENBQUMsU0FBUyxDQUFDLG9CQUFvQixDQUFDO0VBQ2hFLE1BQU0sbUJBQW1CLENBQUMsU0FBUyxDQUFDO0VBRXBDLFNBQVMsQ0FBQyxRQUFRLEdBQ2hCLENBQUEsRUFBQSxJQUFBLEVBQUEsR0FBQSxZQUFZLEtBQVosUUFBQSxZQUFZLEtBQVosa0JBQUEsWUFBWSxDQUFFLG1CQUFtQixNQUFFLFFBQUEsRUFBQSx1QkFBQSxFQUFBLENBQUEsUUFBUSxNQUFJLFFBQUEsRUFBQSxjQUFBLEVBQUEsR0FBQSxpQkFBaUI7RUFDbEUsTUFBTSxnQkFBZ0IsQ0FBQyxTQUFTLENBQUM7QUFDbkM7QUFFTyxlQUFlLE1BQU0sQ0FDMUIsS0FBZ0IsRUFDaEIsU0FBMkI7RUFFM0IsTUFBTSxlQUFlLEdBQUcseUJBQXlCLENBQUMsS0FBSyxDQUFDO0VBQ3hELElBQUksQ0FBQyxlQUFlLEVBQUU7O0lBRXBCOzs7RUFJRixJQUFJLFNBQVMsQ0FBQyx3Q0FBd0MsRUFBRTtJQUN0RCxNQUFNLFFBQVEsQ0FBQyxTQUFTLEVBQUUsZUFBZSxDQUFDOzs7RUFJNUMsTUFBTSxVQUFVLEdBQUcsTUFBTSxhQUFhLEVBQUU7RUFDeEMsSUFBSSxpQkFBaUIsQ0FBQyxVQUFVLENBQUMsRUFBRTtJQUNqQyxPQUFPLG1DQUFtQyxDQUFDLFVBQVUsRUFBRSxlQUFlLENBQUM7OztFQUl6RSxJQUFJLENBQUMsQ0FBQyxlQUFlLENBQUMsWUFBWSxFQUFFO0lBQ2xDLE1BQU0sZ0JBQWdCLENBQUMsbUJBQW1CLENBQUMsZUFBZSxDQUFDLENBQUM7O0VBRzlELElBQUksQ0FBQyxTQUFTLEVBQUU7SUFDZDs7RUFHRixJQUFJLENBQUMsQ0FBQyxTQUFTLENBQUMsMEJBQTBCLEVBQUU7SUFDMUMsTUFBTSxPQUFPLEdBQUcsa0JBQWtCLENBQUMsZUFBZSxDQUFDO0lBRW5ELElBQUksT0FBTyxTQUFTLENBQUMsMEJBQTBCLEtBQUssVUFBVSxFQUFFO01BQzlELE1BQU0sU0FBUyxDQUFDLDBCQUEwQixDQUFDLE9BQU8sQ0FBQztLQUNwRCxNQUFNO01BQ0wsU0FBUyxDQUFDLDBCQUEwQixDQUFDLElBQUksQ0FBQyxPQUFPLENBQUM7OztBQUd4RDtBQUVPLGVBQWUsbUJBQW1CLENBQ3ZDLEtBQXdCOztFQUV4QixNQUFNLGVBQWUsR0FDbkIsQ0FBQSxFQUFBLElBQUEsRUFBQSxHQUFBLEtBQUssQ0FBQyxZQUFZLGNBQUEsRUFBQSx1QkFBQSxFQUFBLENBQUUsSUFBSSxjQUFBLEVBQUEsdUJBQUEsRUFBQSxDQUFHLE9BQU8sQ0FBQztFQUVyQyxJQUFJLENBQUMsZUFBZSxFQUFFO0lBQ3BCO0dBQ0QsTUFBTSxJQUFJLEtBQUssQ0FBQyxNQUFNLEVBQUU7OztJQUd2Qjs7O0VBSUYsS0FBSyxDQUFDLHdCQUF3QixFQUFFO0VBQ2hDLEtBQUssQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFOztFQUcxQixNQUFNLElBQUksR0FBRyxPQUFPLENBQUMsZUFBZSxDQUFDO0VBQ3JDLElBQUksQ0FBQyxJQUFJLEVBQUU7SUFDVDs7O0VBSUYsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDO0VBQzdDLE1BQU0sU0FBUyxHQUFHLElBQUksR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDO0VBRS9DLElBQUksR0FBRyxDQUFDLElBQUksS0FBSyxTQUFTLENBQUMsSUFBSSxFQUFFO0lBQy9COztFQUdGLElBQUksTUFBTSxHQUFHLE1BQU0sZUFBZSxDQUFDLEdBQUcsQ0FBQztFQUV2QyxJQUFJLENBQUMsTUFBTSxFQUFFO0lBQ1gsTUFBTSxHQUFHLE1BQU0sSUFBSSxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDOzs7SUFJNUMsTUFBTSxLQUFLLENBQUMsSUFBSSxDQUFDO0dBQ2xCLE1BQU07SUFDTCxNQUFNLEdBQUcsTUFBTSxNQUFNLENBQUMsS0FBSyxFQUFFOztFQUcvQixJQUFJLENBQUMsTUFBTSxFQUFFOztJQUVYOztFQUdGLGVBQWUsQ0FBQyxXQUFXLEdBQUcsV0FBVyxDQUFDLG9CQUFvQjtFQUM5RCxlQUFlLENBQUMsbUJBQW1CLEdBQUcsSUFBSTtFQUMxQyxPQUFPLE1BQU0sQ0FBQyxXQUFXLENBQUMsZUFBZSxDQUFDO0FBQzVDO0FBRUEsU0FBUyxtQkFBbUIsQ0FDMUIsZUFBdUM7RUFFdkMsTUFBTSxzQkFBc0IsR0FDdEIsTUFBQSxDQUFBLE1BQUEsS0FBQSxlQUFlLENBQUMsWUFBdUQsQ0FDNUU7Ozs7RUFLRCxzQkFBc0IsQ0FBQyxJQUFJLEdBQUc7SUFDNUIsQ0FBQyxPQUFPLEdBQUc7R0FDWjtFQUVELE9BQU8sc0JBQXNCO0FBQy9CO0FBRUEsU0FBUyx5QkFBeUIsQ0FBQztFQUNqQztBQUFJLENBQ007RUFDVixJQUFJLENBQUMsSUFBSSxFQUFFO0lBQ1QsT0FBTyxJQUFJOztFQUdiLElBQUk7SUFDRixPQUFPLElBQUksQ0FBQyxJQUFJLEVBQUU7R0FDbkIsQ0FBQyxPQUFPLEdBQUcsRUFBRTs7SUFFWixPQUFPLElBQUk7O0FBRWY7QUFFQTs7O0FBR0c7QUFDSCxlQUFlLGVBQWUsQ0FBQyxHQUFRO0VBQ3JDLE1BQU0sVUFBVSxHQUFHLE1BQU0sYUFBYSxFQUFFO0VBRXhDLEtBQUssTUFBTSxNQUFNLElBQUksVUFBVSxFQUFFO0lBQy9CLE1BQU0sU0FBUyxHQUFHLElBQUksR0FBRyxDQUFDLE1BQU0sQ0FBQyxHQUFHLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUM7SUFFekQsSUFBSSxHQUFHLENBQUMsSUFBSSxLQUFLLFNBQVMsQ0FBQyxJQUFJLEVBQUU7TUFDL0IsT0FBTyxNQUFNOzs7RUFJakIsT0FBTyxJQUFJO0FBQ2I7QUFFQTs7O0FBR0c7QUFDSCxTQUFTLGlCQUFpQixDQUFDLFVBQTBCO0VBQ25ELE9BQU8sVUFBVSxDQUFDLElBQUksQ0FDcEIsTUFBTSxJQUNKLE1BQU0sQ0FBQyxlQUFlLEtBQUssU0FBUzs7O0VBR3BDLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUMsQ0FDaEQ7QUFDSDtBQUVBLFNBQVMsbUNBQW1DLENBQzFDLFVBQTBCLEVBQzFCLGVBQXVDO0VBRXZDLGVBQWUsQ0FBQyxtQkFBbUIsR0FBRyxJQUFJO0VBQzFDLGVBQWUsQ0FBQyxXQUFXLEdBQUcsV0FBVyxDQUFDLGFBQWE7RUFFdkQsS0FBSyxNQUFNLE1BQU0sSUFBSSxVQUFVLEVBQUU7SUFDL0IsTUFBTSxDQUFDLFdBQVcsQ0FBQyxlQUFlLENBQUM7O0FBRXZDO0FBRUEsU0FBUyxhQUFhLENBQUE7RUFDcEIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLFFBQVEsQ0FBQztJQUMzQixJQUFJLEVBQUUsUUFBUTtJQUNkLG1CQUFtQixFQUFFOztFQUV0QixFQUE0QjtBQUMvQjtBQUVBLFNBQVMsZ0JBQWdCLENBQ3ZCLDJCQUF3RDs7OztFQUl4RCxNQUFNO0lBQUU7RUFBTyxDQUFFLEdBQUcsMkJBQTJCO0VBQy9DLE1BQU07SUFBRTtFQUFVLENBQUUsR0FBRyxZQUFtRDtFQUMxRSxJQUFJLE9BQU8sSUFBSSxVQUFVLElBQUksT0FBTyxDQUFDLE1BQU0sR0FBRyxVQUFVLEVBQUU7SUFDeEQsT0FBTyxDQUFDLElBQUksQ0FDViw4QkFBOEIsVUFBVSx3REFBd0QsQ0FDakc7O0VBR0gsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDLGdCQUFnQixDLFlBQzFCLENBQUEsRUFBQSxHQUFBLDJCQUEyQixDQUFDLEtBQUssY0FBQSxFQUFBLGNBQUEsRUFBQSxHQUFJLEVBQUUsRUFDcEQsMkJBQTJCLENBQzVCO0FBQ0g7QUFFQSxTQUFTLE9BQU8sQ0FBQyxPQUErQjs7O0VBRTlDLE1BQU0sSUFBSSxHQUFHLENBQUEsRUFBQSxJQUFBLEVBQUEsR0FBQSxPQUFPLENBQUMsVUFBVSxjQUFBLEVBQUEsdUJBQUEsRUFBQSxDQUFFLElBQUksY0FBQSxFQUFBLGNBQUEsRUFBQSxHQUFJLENBQUEsRUFBQSxHQUFBLE9BQU8sQ0FBQyxZQUFZLGNBQUEsRUFBQSx1QkFBQSxFQUFBLENBQUUsWUFBWTtFQUMzRSxJQUFJLElBQUksRUFBRTtJQUNSLE9BQU8sSUFBSTs7RUFHYixJQUFJLGdCQUFnQixDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsRUFBRTs7SUFFbEMsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDLE1BQU07R0FDNUIsTUFBTTtJQUNMLE9BQU8sSUFBSTs7QUFFZjs7QWYxUkE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBUUcsU0FBVSxnQkFBZ0IsQ0FBQyxHQUFnQjtFQUMvQyxJQUFJLENBQUMsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLE9BQU8sRUFBRTtJQUN4QixNQUFNLG9CQUFvQixDQUFDLDBCQUEwQixDQUFDOztFQUd4RCxJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksRUFBRTtJQUNiLE1BQU0sb0JBQW9CLENBQUMsVUFBVSxDQUFDOzs7RUFJeEMsTUFBTSxVQUFVLEdBQXlDLENBQ3ZELFdBQVcsRUFDWCxRQUFRLEVBQ1IsT0FBTyxFQUNQLG1CQUFtQixDQUNwQjtFQUVELE1BQU07SUFBRTtFQUFPLENBQUUsR0FBRyxHQUFHO0VBQ3ZCLEtBQUssTUFBTSxPQUFPLElBQUksVUFBVSxFQUFFO0lBQ2hDLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLEVBQUU7TUFDckIsTUFBTSxvQkFBb0IsQ0FBQyxPQUFPLENBQUM7OztFQUl2QyxPQUFPO0lBQ0wsT0FBTyxFQUFFLEdBQUcsQ0FBQyxJQUFJO0lBQ2pCLFNBQVMsRUFBRSxPQUFPLENBQUMsU0FBVTtJQUM3QixNQUFNLEVBQUUsT0FBTyxDQUFDLE1BQU87SUFDdkIsS0FBSyxFQUFFLE9BQU8sQ0FBQyxLQUFNO0lBQ3JCLFFBQVEsRUFBRSxPQUFPLENBQUM7R0FDbkI7QUFDSDtBQUVBLFNBQVMsb0JBQW9CLENBQUMsU0FBaUI7RUFDN0MsT0FBTyxhQUFhLENBQUMsTUFBTSxDQUFzQztJQUMvRDtFQUNELEVBQUM7QUFDSjs7QUM1REE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO01BWVUsZ0JBQWdCO0VBb0IzQixZQUNFLEdBQWdCLEVBQ2hCLGFBQTZDLEVBQzdDLGlCQUEwRDs7SUFoQjVELElBQXdDLENBQUEsd0NBQUEsR0FBWSxLQUFLO0lBRXpELElBQTBCLENBQUEsMEJBQUEsR0FHZixJQUFJO0lBRWYsSUFBZ0IsQ0FBQSxnQkFBQSxHQUNkLElBQUk7SUFFTixJQUFTLENBQUEsU0FBQSxHQUFlLEVBQUU7SUFDMUIsSUFBbUIsQ0FBQSxtQkFBQSxHQUFZLEtBQUs7SUFPbEMsTUFBTSxTQUFTLEdBQUcsZ0JBQWdCLENBQUMsR0FBRyxDQUFDO0lBRXZDLElBQUksQ0FBQyxvQkFBb0IsR0FBRztNQUMxQixHQUFHO01BQ0gsU0FBUztNQUNULGFBQWE7TUFDYjtLQUNEOztFQUdILE9BQU8sQ0FBQTtJQUNMLE9BQU8sT0FBTyxDQUFDLE9BQU8sRUFBRTs7QUFFM0I7O0FPakVEOzs7Ozs7Ozs7Ozs7Ozs7QUFlRztBQXVESCxNQUFNLGtCQUFrQixHQUN0QixTQUE2QixJQUMzQjtFQUNGLE1BQU0sU0FBUyxHQUFHLElBQUksZ0JBQWdCLENBQ3BDLFNBQVMsQ0FBQyxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUMsWUFBWSxFQUFFLEVBQzNDLFNBQVMsQ0FBQyxXQUFXLENBQUMsd0JBQXdCLENBQUMsQ0FBQyxZQUFZLEVBQUUsRUFDOUQsU0FBUyxDQUFDLFdBQVcsQ0FBQyxvQkFBb0IsQ0FBQyxDQUM1QztFQUVELElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxJQUFHO0lBQ2hDLENBQUMsQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLENBQUMsRUFBRSxTQUE2QixDQUFDLENBQUM7RUFDdkQsQ0FBQyxDQUFDO0VBQ0YsSUFBSSxDQUFDLGdCQUFnQixDQUFDLHdCQUF3QixFQUFFLENBQUMsSUFBRztJQUNsRCxDQUFDLENBQUMsU0FBUyxDQUFDLFdBQVcsQ0FBQyxDQUFDLEVBQUUsU0FBNkIsQ0FBQyxDQUFDO0VBQzVELENBQUMsQ0FBQztFQUNGLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxtQkFBbUIsRUFBRSxDQUFDLElBQUc7SUFDN0MsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsQ0FBQztFQUNyQyxDQUFDLENBQUM7RUFFRixPQUFPLFNBQVM7QUFDbEIsQ0FBQztBQW9CRDs7OztBQUlHO1NBQ2EscUJBQXFCLENBQUE7RUFDbkMsR0FBQSxDQUFBLGtCQUFrQixDQUNoQixJQUFJLFNBQUEsQ0FBQSxTQUFTLENBQUMsY0FBYyxFQUFFLGtCQUFrQixFQUF1QixxQ0FDeEU7QUFDSDs7QUN2SEE7Ozs7Ozs7Ozs7Ozs7OztBQWVHO0FBc0NIOzs7OztBQUtHO0FBQ0ksZUFBZSxhQUFhLENBQUE7Ozs7RUFJakMsT0FDRSxJQUFBLENBQUEsb0JBQW9CLEVBQUUsS0FDckIsTUFBTSxJQUFBLENBQUEseUJBQXlCLEVBQUUsQ0FBQyxJQUNuQyxhQUFhLElBQUksSUFBSSxJQUNyQixjQUFjLElBQUksSUFBSSxJQUN0Qix5QkFBeUIsQ0FBQyxTQUFTLENBQUMsY0FBYyxDQUFDLGtCQUFrQixDQUFDLElBQ3RFLGdCQUFnQixDQUFDLFNBQVMsQ0FBQyxjQUFjLENBQUMsUUFBUSxDQUFDO0FBRXZEOztBT3ZFQTs7Ozs7Ozs7Ozs7Ozs7O0FBZUc7QUFZYSxTQUFBLHFCQUFtQixDQUNqQyxTQUEyQixFQUMzQixjQUFpRTtFQUVqRSxJQUFJLElBQUksQ0FBQyxRQUFRLEtBQUssU0FBUyxFQUFFO0lBQy9CLE1BQU0sYUFBYSxDQUFDLE1BQU0sd0RBQTJCOztFQUd2RCxTQUFTLENBQUMsMEJBQTBCLEdBQUcsY0FBYztFQUVyRCxPQUFPLE1BQUs7SUFDVixTQUFTLENBQUMsMEJBQTBCLEdBQUcsSUFBSTtFQUM3QyxDQUFDO0FBQ0g7O0FDeENBOzs7Ozs7Ozs7Ozs7Ozs7QUFlRztBQUthLFNBQUEsNENBQTRDLENBQzFELFNBQW9CLEVBQ3BCLE1BQWU7RUFFZCxTQUE4QixDQUFDLHdDQUF3QyxHQUN0RSxNQUFNO0FBQ1Y7O0FMMUJBOzs7Ozs7Ozs7Ozs7Ozs7QUFlRztBQW1ESDs7Ozs7O0FBTUc7QUFDYSxTQUFBLGdCQUFnQixDQUFDLEtBQUEsR0FBbUIsR0FBQSxDQUFBLE1BQU0sRUFBRTs7Ozs7RUFLMUQsYUFBYSxFQUFFLENBQUMsSUFBSSxDQUNsQixXQUFXLElBQUc7O0lBRVosSUFBSSxDQUFDLFdBQVcsRUFBRTtNQUNoQixNQUFNLGFBQWEsQ0FBQyxNQUFNLDJEQUErQjs7R0FFNUQsRUFDRCxDQUFDLElBQUc7O0lBRUYsTUFBTSxhQUFhLENBQUMsTUFBTSxpRUFBa0M7RUFDOUQsQ0FBQyxDQUNGO0VBQ0QsT0FBTyxHQUFBLENBQUEsWUFBWSxDQUFDLElBQUEsQ0FBQSxrQkFBa0IsQ0FBQyxLQUFHLENBQUMsRUFBRSxjQUFjLENBQUMsQ0FBQyxZQUFZLEVBQUU7QUFDN0U7QUE2REE7Ozs7Ozs7Ozs7O0FBV0c7QUFDYSxTQUFBLG1CQUFtQixDQUNqQyxTQUFvQixFQUNwQixjQUFpRTtFQUVqRSxTQUFTLEdBQUcsSUFBQSxDQUFBLGtCQUFrQixDQUFDLFNBQVMsQ0FBQztFQUN6QyxPQUFPLHFCQUFvQixDQUFDLFNBQTZCLEVBQUUsY0FBYyxDQUFDO0FBQzVFO0FBRUE7Ozs7Ozs7Ozs7QUFVRztBQUNhLFNBQUEsdURBQXVELENBQ3JFLFNBQW9CLEVBQ3BCLE1BQWU7RUFFZixTQUFTLEdBQUcsSUFBQSxDQUFBLGtCQUFrQixDQUFDLFNBQVMsQ0FBQztFQUN6QyxPQUFPLDRDQUE0QyxDQUFDLFNBQVMsRUFBRSxNQUFNLENBQUM7QUFDeEU7O0FNN0xBOzs7Ozs7Ozs7Ozs7Ozs7QUFlRztBQXFCSCxxQkFBcUIsRUFBRSIsImZpbGUiOiJiYWNrZ3JvdW5kLTMuanMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBoYXNQcm9wZXJ0eSwgaXNPYmplY3QsIFJ1bnRpbWVPYmplY3QgfSBmcm9tICdAbWV0YW1hc2svdXRpbHMnO1xuaW1wb3J0IHsgY2xvbmVEZWVwIH0gZnJvbSAnbG9kYXNoJztcbi8vIE5vdGU6IFRoaXMgaXMgdGhlIGxpYnJhcnkgdGhlIG5ldHdvcmsgY29udHJvbGxlciB1c2VzIGZvciBVUkxcbi8vIHZhbGlkaXR5IC8gZXF1YWxpdHkuIFVzaW5nIGhlcmUgdG8gZW5zdXJlIHdlIG1hdGNoIGl0cyB2YWxpZGF0aW9ucy5cbmltcG9ydCAqIGFzIFVSSSBmcm9tICd1cmktanMnO1xuaW1wb3J0IHtcbiAgQ0hBSU5fSURfVE9fQ1VSUkVOQ1lfU1lNQk9MX01BUCxcbiAgTElORUFfTUFJTk5FVF9ESVNQTEFZX05BTUUsXG4gIExJTkVBX1NFUE9MSUFfRElTUExBWV9OQU1FLFxuICBNQUlOTkVUX0RJU1BMQVlfTkFNRSxcbiAgTkVUV09SS19UT19OQU1FX01BUCxcbiAgU0VQT0xJQV9ESVNQTEFZX05BTUUsXG59IGZyb20gJy4uLy4uLy4uL3NoYXJlZC9jb25zdGFudHMvbmV0d29yayc7XG5cbnR5cGUgVmVyc2lvbmVkRGF0YSA9IHtcbiAgbWV0YTogeyB2ZXJzaW9uOiBudW1iZXIgfTtcbiAgZGF0YTogUmVjb3JkPHN0cmluZywgdW5rbm93bj47XG59O1xuXG5leHBvcnQgY29uc3QgdmVyc2lvbiA9IDEyNztcblxuLyoqXG4gKiBUaGlzIG1pZ3JhdGlvbiBjb252ZXJ0cyB0aGUgbmV0d29yayBjb250cm9sbGVyJ3NcbiAqIGBuZXR3b3JrQ29uZmlndXJhdGlvbnNgIHRvIGEgbmV3IGZpZWxkIGBuZXR3b3JrQ29uZmlndXJhdGlvbnNCeUNoYWluSWRgLlxuICpcbiAqIEJ1aWx0LWluIEluZnVyYSBuZXR3b3JrIGNvbmZpZ3VyYXRpb25zIGFyZSBub3cgcmVwcmVzZW50ZWQgaW4gdGhpcyBzdGF0ZSxcbiAqIHdoZXJlIHRoZXkgd2VyZW4ndCBiZWZvcmUuIFRoZXNlIEluZnVyYSBjb25maWd1cmF0aW9ucyBhcmUgbWVyZ2VkIHdpdGggdGhlIHVzZXInc1xuICogY3VzdG9tIGNvbmZpZ3VyYXRpb25zLiAgVGhlbiBhbGwgY29uZmlndXJhdGlvbnMgYXJlIGdyb3VwZWQgYnkgY2hhaW4gaWQsXG4gKiBhbmQgbWVyZ2VkIHRvIHByb2R1Y2Ugb25lIG5ldHdvcmsgY29uZmlndXJhdGlvbiBwZXIgY2hhaW4gaWQuXG4gKlxuICogVGhlIGBTZWxlY3RlZE5ldHdvcmtDb250cm9sbGVyYCBpcyBhbHNvIG1pZ3JhdGVkLCBzbyB0aGF0IGRhcHAgZG9tYWluc1xuICogcG9pbnQgdG8gdGhlIG5ldyBkZWZhdWx0IFJQQyBlbmRwb2ludCBmb3IgdGhlIGNoYWluIHRoZXkgd2VyZSBvbi5cbiAqXG4gKiBUaGUgYE5ldHdvcmtPcmRlckNvbnRyb2xsZXJgIGlzIGFsc28gbWlncmF0ZWQsIHdoaWNoIG1hbmFnZXNcbiAqIHRoZSB1c2VyJ3MgZHJhZyArIGRyb3AgcHJlZmVyZW5jZSBvcmRlciBmb3IgdGhlIG5ldHdvcmsgbWVudS5cbiAqXG4gKiBAcGFyYW0gb3JpZ2luYWxWZXJzaW9uZWREYXRhIC0gVmVyc2lvbmVkIE1ldGFNYXNrIGV4dGVuc2lvbiBzdGF0ZSwgZXhhY3RseSB3aGF0IHdlIHBlcnNpc3QgdG8gZGlzdC5cbiAqIEBwYXJhbSBvcmlnaW5hbFZlcnNpb25lZERhdGEubWV0YSAtIFN0YXRlIG1ldGFkYXRhLlxuICogQHBhcmFtIG9yaWdpbmFsVmVyc2lvbmVkRGF0YS5tZXRhLnZlcnNpb24gLSBUaGUgY3VycmVudCBzdGF0ZSB2ZXJzaW9uLlxuICogQHBhcmFtIG9yaWdpbmFsVmVyc2lvbmVkRGF0YS5kYXRhIC0gVGhlIHBlcnNpc3RlZCBNZXRhTWFzayBzdGF0ZSwga2V5ZWQgYnkgY29udHJvbGxlci5cbiAqIEByZXR1cm5zIFVwZGF0ZWQgdmVyc2lvbmVkIE1ldGFNYXNrIGV4dGVuc2lvbiBzdGF0ZS5cbiAqL1xuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIG1pZ3JhdGUoXG4gIG9yaWdpbmFsVmVyc2lvbmVkRGF0YTogVmVyc2lvbmVkRGF0YSxcbik6IFByb21pc2U8VmVyc2lvbmVkRGF0YT4ge1xuICBjb25zdCB2ZXJzaW9uZWREYXRhID0gY2xvbmVEZWVwKG9yaWdpbmFsVmVyc2lvbmVkRGF0YSk7XG4gIHZlcnNpb25lZERhdGEubWV0YS52ZXJzaW9uID0gdmVyc2lvbjtcbiAgdHJhbnNmb3JtU3RhdGUodmVyc2lvbmVkRGF0YS5kYXRhKTtcbiAgcmV0dXJuIHZlcnNpb25lZERhdGE7XG59XG5cbmZ1bmN0aW9uIHRyYW5zZm9ybVN0YXRlKFxuICBzdGF0ZTogUmVjb3JkPHN0cmluZywgdW5rbm93bj4sXG4pOiBSZWNvcmQ8c3RyaW5nLCB1bmtub3duPiB7XG4gIGlmICghaGFzUHJvcGVydHkoc3RhdGUsICdOZXR3b3JrQ29udHJvbGxlcicpKSB7XG4gICAgZ2xvYmFsLnNlbnRyeT8uY2FwdHVyZUV4Y2VwdGlvbj8uKFxuICAgICAgbmV3IEVycm9yKGBzdGF0ZS5OZXR3b3JrQ29udHJvbGxlciBpcyBub3QgZGVmaW5lZGApLFxuICAgICk7XG4gICAgcmV0dXJuIHN0YXRlO1xuICB9IGVsc2UgaWYgKCFpc09iamVjdChzdGF0ZS5OZXR3b3JrQ29udHJvbGxlcikpIHtcbiAgICBnbG9iYWwuc2VudHJ5Py5jYXB0dXJlRXhjZXB0aW9uPy4oXG4gICAgICBuZXcgRXJyb3IoXG4gICAgICAgIGB0eXBlb2Ygc3RhdGUuTmV0d29ya0NvbnRyb2xsZXIgaXMgJHt0eXBlb2Ygc3RhdGUuTmV0d29ya0NvbnRyb2xsZXJ9YCxcbiAgICAgICksXG4gICAgKTtcbiAgICByZXR1cm4gc3RhdGU7XG4gIH0gZWxzZSBpZiAoIWhhc1Byb3BlcnR5KHN0YXRlLCAnVHJhbnNhY3Rpb25Db250cm9sbGVyJykpIHtcbiAgICBnbG9iYWwuc2VudHJ5Py5jYXB0dXJlRXhjZXB0aW9uPy4oXG4gICAgICBuZXcgRXJyb3IoYHN0YXRlLlRyYW5zYWN0aW9uQ29udHJvbGxlciBpcyBub3QgZGVmaW5lZGApLFxuICAgICk7XG4gICAgcmV0dXJuIHN0YXRlO1xuICB9IGVsc2UgaWYgKCFpc09iamVjdChzdGF0ZS5UcmFuc2FjdGlvbkNvbnRyb2xsZXIpKSB7XG4gICAgZ2xvYmFsLnNlbnRyeT8uY2FwdHVyZUV4Y2VwdGlvbj8uKFxuICAgICAgbmV3IEVycm9yKFxuICAgICAgICBgdHlwZW9mIHN0YXRlLlRyYW5zYWN0aW9uQ29udHJvbGxlciBpcyAke3R5cGVvZiBzdGF0ZS5UcmFuc2FjdGlvbkNvbnRyb2xsZXJ9YCxcbiAgICAgICksXG4gICAgKTtcbiAgICByZXR1cm4gc3RhdGU7XG4gIH1cblxuICBjb25zdCBuZXR3b3JrU3RhdGUgPSBzdGF0ZS5OZXR3b3JrQ29udHJvbGxlcjtcblxuICAvLyBHZXQgdGhlIGV4aXN0aW5nIGN1c3RvbSBuZXR3b3JrIGNvbmZpZ3VyYXRpb25zXG4gIGxldCBuZXR3b3JrQ29uZmlndXJhdGlvbnMgPSBpc09iamVjdChuZXR3b3JrU3RhdGUubmV0d29ya0NvbmZpZ3VyYXRpb25zKVxuICAgID8gT2JqZWN0LnZhbHVlcyhuZXR3b3JrU3RhdGUubmV0d29ya0NvbmZpZ3VyYXRpb25zKVxuICAgIDogW107XG5cbiAgLy8gUHJlcGVuZCB0aGUgYnVpbHQtaW4gSW5mdXJhIG5ldHdvcmsgY29uZmlndXJhdGlvbnMsXG4gIC8vIHNpbmNlIHRoZXkgYXJlIG5vdyBpbmNsdWRlZCBpbiB0aGUgbmV0d29yayBjb250cm9sbGVyIHN0YXRlXG4gIG5ldHdvcmtDb25maWd1cmF0aW9ucyA9IFtcbiAgICB7XG4gICAgICB0eXBlOiAnaW5mdXJhJyxcbiAgICAgIGlkOiAnbWFpbm5ldCcsXG4gICAgICBjaGFpbklkOiAnMHgxJyxcbiAgICAgIHRpY2tlcjogJ0VUSCcsXG4gICAgICBuaWNrbmFtZTogTUFJTk5FVF9ESVNQTEFZX05BTUUsXG4gICAgICBycGNVcmw6ICdodHRwczovL21haW5uZXQuaW5mdXJhLmlvL3YzL3tpbmZ1cmFQcm9qZWN0SWR9JyxcbiAgICAgIHJwY1ByZWZzOiB7IGJsb2NrRXhwbG9yZXJVcmw6ICdodHRwczovL2V0aGVyc2Nhbi5pbycgfSxcbiAgICB9LFxuICAgIHtcbiAgICAgIHR5cGU6ICdpbmZ1cmEnLFxuICAgICAgaWQ6ICdzZXBvbGlhJyxcbiAgICAgIGNoYWluSWQ6ICcweGFhMzZhNycsXG4gICAgICB0aWNrZXI6ICdTZXBvbGlhRVRIJyxcbiAgICAgIG5pY2tuYW1lOiBTRVBPTElBX0RJU1BMQVlfTkFNRSxcbiAgICAgIHJwY1VybDogJ2h0dHBzOi8vc2Vwb2xpYS5pbmZ1cmEuaW8vdjMve2luZnVyYVByb2plY3RJZH0nLFxuICAgICAgcnBjUHJlZnM6IHsgYmxvY2tFeHBsb3JlclVybDogJ2h0dHBzOi8vc2Vwb2xpYS5ldGhlcnNjYW4uaW8nIH0sXG4gICAgfSxcbiAgICB7XG4gICAgICB0eXBlOiAnaW5mdXJhJyxcbiAgICAgIGlkOiAnbGluZWEtc2Vwb2xpYScsXG4gICAgICBjaGFpbklkOiAnMHhlNzA1JyxcbiAgICAgIHRpY2tlcjogJ0xpbmVhRVRIJyxcbiAgICAgIG5pY2tuYW1lOiBMSU5FQV9TRVBPTElBX0RJU1BMQVlfTkFNRSxcbiAgICAgIHJwY1VybDogJ2h0dHBzOi8vbGluZWEtc2Vwb2xpYS5pbmZ1cmEuaW8vdjMve2luZnVyYVByb2plY3RJZH0nLFxuICAgICAgcnBjUHJlZnM6IHsgYmxvY2tFeHBsb3JlclVybDogJ2h0dHBzOi8vc2Vwb2xpYS5saW5lYXNjYW4uYnVpbGQnIH0sXG4gICAgfSxcbiAgICB7XG4gICAgICB0eXBlOiAnaW5mdXJhJyxcbiAgICAgIGlkOiAnbGluZWEtbWFpbm5ldCcsXG4gICAgICBjaGFpbklkOiAnMHhlNzA4JyxcbiAgICAgIHRpY2tlcjogJ0VUSCcsXG4gICAgICBuaWNrbmFtZTogTElORUFfTUFJTk5FVF9ESVNQTEFZX05BTUUsXG4gICAgICBycGNVcmw6ICdodHRwczovL2xpbmVhLW1haW5uZXQuaW5mdXJhLmlvL3YzL3tpbmZ1cmFQcm9qZWN0SWR9JyxcbiAgICAgIHJwY1ByZWZzOiB7IGJsb2NrRXhwbG9yZXJVcmw6ICdodHRwczovL2xpbmVhc2Nhbi5idWlsZCcgfSxcbiAgICB9LFxuICAgIC4uLm5ldHdvcmtDb25maWd1cmF0aW9ucyxcbiAgXTtcblxuICAvLyBHcm91cCB0aGUgbmV0d29yayBjb25maWd1cmF0aW9ucyBieSBieSBjaGFpbiBpZCwgcHJvZHVjaW5nXG4gIC8vIGEgbWFwcGluZyBmcm9tIGNoYWluIGlkIHRvIGFuIGFycmF5IG9mIG5ldHdvcmsgY29uZmlndXJhdGlvbnNcbiAgY29uc3QgbmV0d29ya0NvbmZpZ3VyYXRpb25BcnJheXNCeUNoYWluSWQgPSBuZXR3b3JrQ29uZmlndXJhdGlvbnMucmVkdWNlKFxuICAgIChhY2M6IFJlY29yZDxzdHJpbmcsIFJ1bnRpbWVPYmplY3RbXT4sIG5ldHdvcmtDb25maWd1cmF0aW9uKSA9PiB7XG4gICAgICBpZiAoXG4gICAgICAgIGlzT2JqZWN0KG5ldHdvcmtDb25maWd1cmF0aW9uKSAmJlxuICAgICAgICB0eXBlb2YgbmV0d29ya0NvbmZpZ3VyYXRpb24uY2hhaW5JZCA9PT0gJ3N0cmluZydcbiAgICAgICkge1xuICAgICAgICAoYWNjW25ldHdvcmtDb25maWd1cmF0aW9uLmNoYWluSWRdID8/PSBbXSkucHVzaChuZXR3b3JrQ29uZmlndXJhdGlvbik7XG4gICAgICB9XG4gICAgICByZXR1cm4gYWNjO1xuICAgIH0sXG4gICAge30sXG4gICk7XG5cbiAgLy8gR2V0IHRyYW5zYWN0aW9uIGhpc3RvcnkgaW4gcmV2ZXJzZSBjaHJvbm9sb2dpY2FsIG9yZGVyIHRvIGhlbHAgd2l0aCB0aWUgYnJlYWtzXG4gIGNvbnN0IHRyYW5zYWN0aW9uczogUnVudGltZU9iamVjdFtdID0gQXJyYXkuaXNBcnJheShcbiAgICBzdGF0ZS5UcmFuc2FjdGlvbkNvbnRyb2xsZXIudHJhbnNhY3Rpb25zLFxuICApXG4gICAgPyBzdGF0ZS5UcmFuc2FjdGlvbkNvbnRyb2xsZXIudHJhbnNhY3Rpb25zXG4gICAgICAgIC5maWx0ZXIoXG4gICAgICAgICAgKHR4KSA9PlxuICAgICAgICAgICAgaXNPYmplY3QodHgpICYmXG4gICAgICAgICAgICB0eXBlb2YgdHgudGltZSA9PT0gJ251bWJlcicgJiZcbiAgICAgICAgICAgIHR5cGVvZiB0eC5uZXR3b3JrQ2xpZW50SWQgPT09ICdzdHJpbmcnLFxuICAgICAgICApXG4gICAgICAgIC5zb3J0KChhLCBiKSA9PiBiLnRpbWUgLSBhLnRpbWUpXG4gICAgOiBbXTtcblxuICAvLyBGb3IgZWFjaCBjaGFpbiBpZCwgbWVyZ2UgdGhlIGFycmF5IG9mIG5ldHdvcmsgY29uZmlndXJhdGlvbnNcbiAgY29uc3QgbmV0d29ya0NvbmZpZ3VyYXRpb25zQnlDaGFpbklkID0gT2JqZWN0LmVudHJpZXMoXG4gICAgbmV0d29ya0NvbmZpZ3VyYXRpb25BcnJheXNCeUNoYWluSWQsXG4gICkucmVkdWNlKChhY2M6IFJlY29yZDxzdHJpbmcsIHVua25vd24+LCBbY2hhaW5JZCwgbmV0d29ya3NdKSA9PiB7XG4gICAgLy9cbiAgICAvLyBDYWxjdWxhdGUgdGhlIHRpZSBicmVha2VyIG5ldHdvcmssIHdob3NlIHZhbHVlcyB3aWxsIGJlIHByZWZlcnJlZFxuICAgIGxldCB0aWVCcmVha2VyOiBSdW50aW1lT2JqZWN0IHwgdW5kZWZpbmVkO1xuXG4gICAgLy8gSWYgb25lIG9mIHRoZSBuZXR3b3JrcyBpcyB0aGUgZ2xvYmFsbHkgc2VsZWN0ZWQgbmV0d29yaywgdXNlIHRoYXRcbiAgICB0aWVCcmVha2VyID0gbmV0d29ya3MuZmluZChcbiAgICAgIChuZXR3b3JrKSA9PiBuZXR3b3JrLmlkID09PSBuZXR3b3JrU3RhdGUuc2VsZWN0ZWROZXR3b3JrQ2xpZW50SWQsXG4gICAgKTtcblxuICAgIC8vIE90aGVyd2lzZSB1c2UgdGhlIG5ldHdvcmsgdGhhdCB3YXMgbW9zdCByZWNlbnRseSB0cmFuc2FjdGVkIG9uXG4gICAgaWYgKCF0aWVCcmVha2VyKSB7XG4gICAgICB0cmFuc2FjdGlvbnNcbiAgICAgICAgLmZpbHRlcigodHgpID0+IHR4LmNoYWluSWQgPT09IGNoYWluSWQpXG4gICAgICAgIC5zb21lKFxuICAgICAgICAgICh0eCkgPT5cbiAgICAgICAgICAgICh0aWVCcmVha2VyID0gbmV0d29ya3MuZmluZChcbiAgICAgICAgICAgICAgKG5ldHdvcmspID0+IG5ldHdvcmsuaWQgPT09IHR4Lm5ldHdvcmtDbGllbnRJZCxcbiAgICAgICAgICAgICkpLFxuICAgICAgICApO1xuICAgIH1cblxuICAgIC8vIElmIG5vIHRyYW5zYWN0aW9ucyB3ZXJlIGZvdW5kIGZvciB0aGUgY2hhaW4gaWQsIGZhbGwgYmFja1xuICAgIC8vIHRvIGFuIGFyYml0cmFyeSBjdXN0b20gbmV0d29yayB0aGF0IGlzIG5vdCBidWlsdCBpbiBpbmZ1cmFcbiAgICBpZiAoIXRpZUJyZWFrZXIpIHtcbiAgICAgIHRpZUJyZWFrZXIgPSBuZXR3b3Jrcy5maW5kKChuZXR3b3JrKSA9PiBuZXR3b3JrLnR5cGUgIT09ICdpbmZ1cmEnKTtcbiAgICB9XG5cbiAgICAvLyBDYWxjdWxhdGUgdGhlIHVuaXF1ZSBzZXQgb2YgdmFsaWQgcnBjIGVuZHBvaW50cyBmb3IgdGhpcyBjaGFpbiBpZFxuICAgIGNvbnN0IHJwY0VuZHBvaW50cyA9IG5ldHdvcmtzLnJlZHVjZShcbiAgICAgIChlbmRwb2ludHM6IFJ1bnRpbWVPYmplY3RbXSwgbmV0d29yaykgPT4ge1xuICAgICAgICBpZiAoXG4gICAgICAgICAgbmV0d29yay5pZCAmJlxuICAgICAgICAgIG5ldHdvcmsucnBjVXJsICYmXG4gICAgICAgICAgdHlwZW9mIG5ldHdvcmsucnBjVXJsID09PSAnc3RyaW5nJyAmJlxuICAgICAgICAgIGlzVmFsaWRVcmwobmV0d29yay5ycGNVcmwpXG4gICAgICAgICkge1xuICAgICAgICAgIC8vIENoZWNrIGlmIHRoZXJlJ3MgYSBkaWZmZXJlbnQgZHVwbGljYXRlIHRoYXQncyBhbHNvIHRoZSBzZWxlY3RlZFxuICAgICAgICAgIC8vIG5ldHdvcmsuIElmIHNvLCBpdCB3aWxsIGJlIHRoZSBwcmVmZXJyZWQgb25lIHdlJ2xsIHRha2UuXG4gICAgICAgICAgY29uc3QgZHVwbGljYXRlQW5kU2VsZWN0ZWQgPSBuZXR3b3JrQ29uZmlndXJhdGlvbnMuc29tZShcbiAgICAgICAgICAgIChvdGhlck5ldHdvcmspID0+XG4gICAgICAgICAgICAgIGlzT2JqZWN0KG90aGVyTmV0d29yaykgJiZcbiAgICAgICAgICAgICAgdHlwZW9mIG90aGVyTmV0d29yay5ycGNVcmwgPT09ICdzdHJpbmcnICYmXG4gICAgICAgICAgICAgIHR5cGVvZiBuZXR3b3JrLnJwY1VybCA9PT0gJ3N0cmluZycgJiZcbiAgICAgICAgICAgICAgb3RoZXJOZXR3b3JrLmlkICE9PSBuZXR3b3JrLmlkICYmIC8vIEEgZGlmZmVyZW50IGVuZHBvaW50XG4gICAgICAgICAgICAgIFVSSS5lcXVhbChvdGhlck5ldHdvcmsucnBjVXJsLCBuZXR3b3JrLnJwY1VybCkgJiYgLy8gV2l0aCB0aGUgc2FtZSBVUkxcbiAgICAgICAgICAgICAgb3RoZXJOZXR3b3JrLmlkID09PSBuZXR3b3JrU3RhdGUuc2VsZWN0ZWROZXR3b3JrQ2xpZW50SWQsIC8vIFRoYXQncyBjdXJyZW50bHkgc2VsZWN0ZWRcbiAgICAgICAgICApO1xuXG4gICAgICAgICAgLy8gQ2hlY2sgaWYgdGhlcmUncyBhIGR1cGxpY2F0ZSB0aGF0IHdlJ3ZlIGFscmVhZHkgcHJvY2Vzc2VkLiBJZiBub25lIG9mXG4gICAgICAgICAgLy8gdGhlIGR1cGxpY2F0ZXMgYXJlIHRoZSBzZWxlY3RlZCBuZXR3b3JrLCB3ZSdsbCB0YWtlIHRoZSBmaXJzdCBvbmUgc2Vlbi5cbiAgICAgICAgICBjb25zdCBkdXBsaWNhdGVBbHJlYWR5QWRkZWQgPSBbXG4gICAgICAgICAgICAvLyBDaGFpbnMgd2UndmUgYWxyZWFkeSBwcm9jY2Vzc2VkXG4gICAgICAgICAgICAuLi5PYmplY3QudmFsdWVzKGFjYykuZmxhdE1hcCgobikgPT5cbiAgICAgICAgICAgICAgaXNPYmplY3QobikgPyBuLnJwY0VuZHBvaW50cyA6IFtdLFxuICAgICAgICAgICAgKSxcbiAgICAgICAgICAgIC8vIE9yIHRoZSBjdXJyZW50IGNoYWluIHdlJ3JlIHByb2Nlc3NpbmdcbiAgICAgICAgICAgIC4uLmVuZHBvaW50cyxcbiAgICAgICAgICBdLnNvbWUoXG4gICAgICAgICAgICAoZXhpc3RpbmdFbmRwb2ludCkgPT5cbiAgICAgICAgICAgICAgaXNPYmplY3QoZXhpc3RpbmdFbmRwb2ludCkgJiZcbiAgICAgICAgICAgICAgdHlwZW9mIGV4aXN0aW5nRW5kcG9pbnQudXJsID09PSAnc3RyaW5nJyAmJlxuICAgICAgICAgICAgICB0eXBlb2YgbmV0d29yay5ycGNVcmwgPT09ICdzdHJpbmcnICYmXG4gICAgICAgICAgICAgIFVSSS5lcXVhbChleGlzdGluZ0VuZHBvaW50LnVybCwgbmV0d29yay5ycGNVcmwpLFxuICAgICAgICAgICk7XG5cbiAgICAgICAgICBpZiAoIWR1cGxpY2F0ZUFuZFNlbGVjdGVkICYmICFkdXBsaWNhdGVBbHJlYWR5QWRkZWQpIHtcbiAgICAgICAgICAgIC8vIFRoZSBlbmRwb2ludCBpcyB1bmlxdWUgYW5kIHZhbGlkLCBzbyBhZGQgaXQgdG8gdGhlIGxpc3RcbiAgICAgICAgICAgIGVuZHBvaW50cy5wdXNoKHtcbiAgICAgICAgICAgICAgbmV0d29ya0NsaWVudElkOiBuZXR3b3JrLmlkLFxuICAgICAgICAgICAgICB1cmw6IG5ldHdvcmsucnBjVXJsLFxuICAgICAgICAgICAgICB0eXBlOiBuZXR3b3JrLnR5cGUgPT09ICdpbmZ1cmEnID8gJ2luZnVyYScgOiAnY3VzdG9tJyxcbiAgICAgICAgICAgICAgLi4uKG5ldHdvcmsudHlwZSAhPT0gJ2luZnVyYScgJiZcbiAgICAgICAgICAgICAgICB0eXBlb2YgbmV0d29yay5uaWNrbmFtZSA9PT0gJ3N0cmluZycgJiZcbiAgICAgICAgICAgICAgICAvLyBUaGUgb2xkIG5ldHdvcmsgbmFtZSBiZWNvbWVzIHRoZSBlbmRwb2ludCBuYW1lXG4gICAgICAgICAgICAgICAgbmV0d29yay5uaWNrbmFtZSAmJiB7IG5hbWU6IG5ldHdvcmsubmlja25hbWUgfSksXG4gICAgICAgICAgICB9KTtcbiAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIGVuZHBvaW50cztcbiAgICAgIH0sXG4gICAgICBbXSxcbiAgICApO1xuXG4gICAgLy8gSWYgdGhlcmUgd2VyZSBubyB2YWxpZCB1bmlxdWUgZW5kcG9pbnRzLCB0aGVuIG9taXQgdGhlIG5ldHdvcmtcbiAgICAvLyBjb25maWd1cmF0aW9uIGZvciB0aGlzIGNoYWluIGlkLiBUaGUgbmV0d29yayBjb250cm9sbGVyIHJlcXVpcmVzXG4gICAgLy8gY29uZmlndXJhdGlvbnMgdG8gaGF2ZSBhdCBsZWFzdCAxIGVuZHBvaW50LlxuICAgIGlmIChycGNFbmRwb2ludHMubGVuZ3RoID09PSAwKSB7XG4gICAgICByZXR1cm4gYWNjO1xuICAgIH1cblxuICAgIC8vIFVzZSB0aGUgdGllIGJyZWFrZXIgbmV0d29yayBhcyB0aGUgZGVmYXVsdCBycGMgZW5kcG9pbnRcbiAgICBjb25zdCBkZWZhdWx0UnBjRW5kcG9pbnRJbmRleCA9IE1hdGgubWF4KFxuICAgICAgcnBjRW5kcG9pbnRzLmZpbmRJbmRleChcbiAgICAgICAgKGVuZHBvaW50KSA9PiBlbmRwb2ludC5uZXR3b3JrQ2xpZW50SWQgPT09IHRpZUJyZWFrZXI/LmlkLFxuICAgICAgKSxcbiAgICAgIC8vIE9yIGFyYml0cmFyaWx5IGRlZmF1bHQgdG8gdGhlIGZpcnN0IGVuZHBvaW50IGlmIHdlIGRvbid0IGhhdmUgYSB0aWUgYnJlYWtlclxuICAgICAgMCxcbiAgICApO1xuXG4gICAgLy8gQ2FsY3VsYXRlIHRoZSB1bmlxdWUgYXJyYXkgb2Ygbm9uLWVtcHR5IGJsb2NrIGV4cGxvcmVyIHVybHNcbiAgICBjb25zdCBibG9ja0V4cGxvcmVyVXJscyA9IFtcbiAgICAgIC4uLm5ldHdvcmtzLnJlZHVjZSgodXJscywgbmV0d29yaykgPT4ge1xuICAgICAgICBpZiAoXG4gICAgICAgICAgaXNPYmplY3QobmV0d29yay5ycGNQcmVmcykgJiZcbiAgICAgICAgICB0eXBlb2YgbmV0d29yay5ycGNQcmVmcy5ibG9ja0V4cGxvcmVyVXJsID09PSAnc3RyaW5nJyAmJlxuICAgICAgICAgIG5ldHdvcmsucnBjUHJlZnMuYmxvY2tFeHBsb3JlclVybFxuICAgICAgICApIHtcbiAgICAgICAgICB1cmxzLmFkZChuZXR3b3JrLnJwY1ByZWZzLmJsb2NrRXhwbG9yZXJVcmwpO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiB1cmxzO1xuICAgICAgfSwgbmV3IFNldCgpKSxcbiAgICBdO1xuXG4gICAgLy8gVXNlIHRoZSB0aWUgYnJlYWtlciBuZXR3b3JrIGFzIHRoZSBkZWZhdWx0IGJsb2NrIGV4cGxvcmVyLCBpZiBpdCBoYXMgb25lXG4gICAgY29uc3QgZGVmYXVsdEJsb2NrRXhwbG9yZXJVcmxJbmRleCA9XG4gICAgICBibG9ja0V4cGxvcmVyVXJscy5sZW5ndGggPT09IDBcbiAgICAgICAgPyB1bmRlZmluZWRcbiAgICAgICAgOiBNYXRoLm1heChcbiAgICAgICAgICAgIGJsb2NrRXhwbG9yZXJVcmxzLmZpbmRJbmRleChcbiAgICAgICAgICAgICAgKHVybCkgPT5cbiAgICAgICAgICAgICAgICBpc09iamVjdCh0aWVCcmVha2VyPy5ycGNQcmVmcykgJiZcbiAgICAgICAgICAgICAgICB1cmwgPT09IHRpZUJyZWFrZXIucnBjUHJlZnMuYmxvY2tFeHBsb3JlclVybCxcbiAgICAgICAgICAgICksXG4gICAgICAgICAgICAvLyBPciBhcmJpdHJhcmlseSBkZWZhdWx0IHRvIHRoZSBmaXJzdCB1cmxcbiAgICAgICAgICAgIDAsXG4gICAgICAgICAgKTtcblxuICAgIC8vIFVzZSB0aGUgY29ub25pY2FsIG5ldHdvcmsgbmFtZSBhbmQgY3VycmVuY3ksIGlmIHdlIGhhdmUgY29uc3RhbnRzIGZvciB0aGVtLlxuICAgIC8vIE90aGVyd2lzZSBwcmVmZXIgdGhlIHRpZSBicmVha2VyJ3MgbmFtZSArIGN1cnJlbmN5LCBpZiBpdCBkZWZpbmVzIHRoZW0uXG4gICAgLy8gT3RoZXJ3aXNlIGZhbGwgYmFjayB0byB0aGUgbmFtZSArIGN1cnJlbmN5IGZyb20gYXJiaXRyYXJ5IG5ldHdvcmtzIHRoYXQgZGVmaW5lIHRoZW0uXG4gICAgY29uc3QgbmFtZSA9XG4gICAgICBORVRXT1JLX1RPX05BTUVfTUFQW2NoYWluSWQgYXMga2V5b2YgdHlwZW9mIE5FVFdPUktfVE9fTkFNRV9NQVBdID8/XG4gICAgICB0aWVCcmVha2VyPy5uaWNrbmFtZSA/P1xuICAgICAgbmV0d29ya3MuZmluZCgobikgPT4gbi5uaWNrbmFtZSk/Lm5pY2tuYW1lO1xuXG4gICAgY29uc3QgbmF0aXZlQ3VycmVuY3kgPVxuICAgICAgQ0hBSU5fSURfVE9fQ1VSUkVOQ1lfU1lNQk9MX01BUFtcbiAgICAgICAgY2hhaW5JZCBhcyBrZXlvZiB0eXBlb2YgQ0hBSU5fSURfVE9fQ1VSUkVOQ1lfU1lNQk9MX01BUFxuICAgICAgXSA/P1xuICAgICAgdGllQnJlYWtlcj8udGlja2VyID8/XG4gICAgICBuZXR3b3Jrcy5maW5kKChuKSA9PiBuLnRpY2tlcik/LnRpY2tlcjtcblxuICAgIGFjY1tjaGFpbklkXSA9IHtcbiAgICAgIGNoYWluSWQsXG4gICAgICBycGNFbmRwb2ludHMsXG4gICAgICBkZWZhdWx0UnBjRW5kcG9pbnRJbmRleCxcbiAgICAgIGJsb2NrRXhwbG9yZXJVcmxzLFxuICAgICAgLi4uKGRlZmF1bHRCbG9ja0V4cGxvcmVyVXJsSW5kZXggIT09IHVuZGVmaW5lZCAmJiB7XG4gICAgICAgIGRlZmF1bHRCbG9ja0V4cGxvcmVyVXJsSW5kZXgsXG4gICAgICB9KSxcbiAgICAgIG5hbWUsXG4gICAgICBuYXRpdmVDdXJyZW5jeSxcbiAgICB9O1xuICAgIHJldHVybiBhY2M7XG4gIH0sIHt9KTtcblxuICAvLyBHaXZlbiBhIG5ldHdvcmsgY2xpZW50IGlkLC