LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-json-rpc-middleware\\dist\\wallet.js", {"./methods/wallet-request-execution-permissions":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-json-rpc-middleware\\dist\\methods\\wallet-request-execution-permissions.js","./methods/wallet-revoke-execution-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-json-rpc-middleware\\dist\\methods\\wallet-revoke-execution-permission.js","./utils/common":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-json-rpc-middleware\\dist\\utils\\common.js","./utils/normalize":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-json-rpc-middleware\\dist\\utils\\normalize.js","./utils/validation":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-json-rpc-middleware\\dist\\utils\\validation.js","@metamask/eth-sig-util":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-sig-util\\dist\\index.js","@metamask/json-rpc-engine":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-engine\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-json-rpc-middleware%5Cdist%5Cwallet.js
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createWalletMiddleware = void 0;
const sigUtil = __importStar(require("@metamask/eth-sig-util"));
const json_rpc_engine_1 = require("@metamask/json-rpc-engine");
const rpc_errors_1 = require("@metamask/rpc-errors");
const utils_1 = require("@metamask/utils");
const wallet_request_execution_permissions_1 = require("./methods/wallet-request-execution-permissions");
const wallet_revoke_execution_permission_1 = require("./methods/wallet-revoke-execution-permission");
const common_1 = require("./utils/common");
const normalize_1 = require("./utils/normalize");
const validation_1 = require("./utils/validation");
function createWalletMiddleware({ getAccounts, processDecryptMessage, processEncryptionPublicKey, processPersonalMessage, processTransaction, processSignTransaction, processTypedMessage, processTypedMessageV3, processTypedMessageV4, processRequestExecutionPermissions, processRevokeExecutionPermission, }) {
    if (!getAccounts) {
        throw new Error('opts.getAccounts is required');
    }
    return (0, json_rpc_engine_1.createScaffoldMiddleware)({
        // account lookups
        eth_accounts: (0, json_rpc_engine_1.createAsyncMiddleware)(lookupAccounts),
        eth_coinbase: (0, json_rpc_engine_1.createAsyncMiddleware)(lookupDefaultAccount),
        // tx signatures
        eth_sendTransaction: (0, json_rpc_engine_1.createAsyncMiddleware)(sendTransaction),
        eth_signTransaction: (0, json_rpc_engine_1.createAsyncMiddleware)(signTransaction),
        // message signatures
        eth_signTypedData: (0, json_rpc_engine_1.createAsyncMiddleware)(signTypedData),
        eth_signTypedData_v3: (0, json_rpc_engine_1.createAsyncMiddleware)(signTypedDataV3),
        eth_signTypedData_v4: (0, json_rpc_engine_1.createAsyncMiddleware)(signTypedDataV4),
        personal_sign: (0, json_rpc_engine_1.createAsyncMiddleware)(personalSign),
        eth_getEncryptionPublicKey: (0, json_rpc_engine_1.createAsyncMiddleware)(encryptionPublicKey),
        eth_decrypt: (0, json_rpc_engine_1.createAsyncMiddleware)(decryptMessage),
        personal_ecRecover: (0, json_rpc_engine_1.createAsyncMiddleware)(personalRecover),
        // EIP-7715
        wallet_requestExecutionPermissions: (0, json_rpc_engine_1.createAsyncMiddleware)(async (req, res) => (0, wallet_request_execution_permissions_1.walletRequestExecutionPermissions)(req, res, {
            processRequestExecutionPermissions,
        })),
        wallet_revokeExecutionPermission: (0, json_rpc_engine_1.createAsyncMiddleware)(async (req, res) => (0, wallet_revoke_execution_permission_1.walletRevokeExecutionPermission)(req, res, {
            processRevokeExecutionPermission,
        })),
    });
    //
    // account lookups
    //
    async function lookupAccounts(req, res) {
        res.result = await getAccounts(req);
    }
    async function lookupDefaultAccount(req, res) {
        const accounts = await getAccounts(req);
        res.result = accounts[0] || null;
    }
    //
    // transaction signatures
    //
    async function sendTransaction(req, res) {
        if (!processTransaction) {
            throw rpc_errors_1.rpcErrors.methodNotSupported();
        }
        if (!req.params ||
            !Array.isArray(req.params) ||
            !(req.params.length >= 1)) {
            throw rpc_errors_1.rpcErrors.invalidInput();
        }
        const params = req.params[0];
        const txParams = Object.assign(Object.assign({}, params), { from: await validateAndNormalizeKeyholder((params === null || params === void 0 ? void 0 : params.from) || '', req) });
        res.result = await processTransaction(txParams, req);
    }
    async function signTransaction(req, res) {
        if (!processSignTransaction) {
            throw rpc_errors_1.rpcErrors.methodNotSupported();
        }
        if (!req.params ||
            !Array.isArray(req.params) ||
            !(req.params.length >= 1)) {
            throw rpc_errors_1.rpcErrors.invalidInput();
        }
        const params = req.params[0];
        const txParams = Object.assign(Object.assign({}, params), { from: await validateAndNormalizeKeyholder((params === null || params === void 0 ? void 0 : params.from) || '', req) });
        res.result = await processSignTransaction(txParams, req);
    }
    //
    // message signatures
    //
    async function signTypedData(req, res) {
        if (!processTypedMessage) {
            throw rpc_errors_1.rpcErrors.methodNotSupported();
        }
        if (!(req === null || req === void 0 ? void 0 : req.params) ||
            !Array.isArray(req.params) ||
            !(req.params.length >= 2)) {
            throw rpc_errors_1.rpcErrors.invalidInput();
        }
        const params = req.params;
        const message = params[0];
        const address = await validateAndNormalizeKeyholder(params[1], req);
        const version = 'V1';
        const extraParams = params[2] || {};
        const msgParams = Object.assign(Object.assign({}, extraParams), { from: address, data: message, signatureMethod: 'eth_signTypedData', version });
        res.result = await processTypedMessage(msgParams, req, version);
    }
    async function signTypedDataV3(req, res) {
        if (!processTypedMessageV3) {
            throw rpc_errors_1.rpcErrors.methodNotSupported();
        }
        if (!(req === null || req === void 0 ? void 0 : req.params) ||
            !Array.isArray(req.params) ||
            !(req.params.length >= 2)) {
            throw rpc_errors_1.rpcErrors.invalidInput();
        }
        const params = req.params;
        const address = await validateAndNormalizeKeyholder(params[0], req);
        const message = (0, normalize_1.normalizeTypedMessage)(params[1]);
        validatePrimaryType(message);
        validateVerifyingContract(message);
        const version = 'V3';
        const msgParams = {
            data: message,
            from: address,
            version,
            signatureMethod: 'eth_signTypedData_v3',
        };
        res.result = await processTypedMessageV3(msgParams, req, version);
    }
    async function signTypedDataV4(req, res) {
        if (!processTypedMessageV4) {
            throw rpc_errors_1.rpcErrors.methodNotSupported();
        }
        if (!(req === null || req === void 0 ? void 0 : req.params) ||
            !Array.isArray(req.params) ||
            !(req.params.length >= 2)) {
            throw rpc_errors_1.rpcErrors.invalidInput();
        }
        const params = req.params;
        const address = await validateAndNormalizeKeyholder(params[0], req);
        const message = (0, normalize_1.normalizeTypedMessage)(params[1]);
        validatePrimaryType(message);
        validateVerifyingContract(message);
        const version = 'V4';
        const msgParams = {
            data: message,
            from: address,
            version,
            signatureMethod: 'eth_signTypedData_v4',
        };
        res.result = await processTypedMessageV4(msgParams, req, version);
    }
    async function personalSign(req, res) {
        if (!processPersonalMessage) {
            throw rpc_errors_1.rpcErrors.methodNotSupported();
        }
        if (!(req === null || req === void 0 ? void 0 : req.params) ||
            !Array.isArray(req.params) ||
            !(req.params.length >= 2)) {
            throw rpc_errors_1.rpcErrors.invalidInput();
        }
        const params = req.params;
        // process normally
        const firstParam = params[0];
        const secondParam = params[1];
        // non-standard "extraParams" to be appended to our "msgParams" obj
        const extraParams = params[2] || {};
        // We initially incorrectly ordered these parameters.
        // To gracefully respect users who adopted this API early,
        // we are currently gracefully recovering from the wrong param order
        // when it is clearly identifiable.
        //
        // That means when the first param is definitely an address,
        // and the second param is definitely not, but is hex.
        let address, message;
        if ((0, validation_1.resemblesAddress)(firstParam) && !(0, validation_1.resemblesAddress)(secondParam)) {
            let warning = `The eth_personalSign method requires params ordered `;
            warning += `[message, address]. This was previously handled incorrectly, `;
            warning += `and has been corrected automatically. `;
            warning += `Please switch this param order for smooth behavior in the future.`;
            res.warning = warning;
            address = firstParam;
            message = secondParam;
        }
        else {
            message = firstParam;
            address = secondParam;
        }
        address = await validateAndNormalizeKeyholder(address, req);
        const msgParams = Object.assign(Object.assign({}, extraParams), { from: address, data: message, signatureMethod: 'personal_sign' });
        // eslint-disable-next-line require-atomic-updates
        res.result = await processPersonalMessage(msgParams, req);
    }
    async function personalRecover(req, res) {
        if (!(req === null || req === void 0 ? void 0 : req.params) ||
            !Array.isArray(req.params) ||
            !(req.params.length >= 2)) {
            throw rpc_errors_1.rpcErrors.invalidInput();
        }
        const params = req.params;
        const message = params[0];
        const signature = params[1];
        const signerAddress = sigUtil.recoverPersonalSignature({
            data: message,
            signature,
        });
        res.result = signerAddress;
    }
    async function encryptionPublicKey(req, res) {
        if (!processEncryptionPublicKey) {
            throw rpc_errors_1.rpcErrors.methodNotSupported();
        }
        if (!(req === null || req === void 0 ? void 0 : req.params) ||
            !Array.isArray(req.params) ||
            !(req.params.length >= 1)) {
            throw rpc_errors_1.rpcErrors.invalidInput();
        }
        const params = req.params;
        const address = await validateAndNormalizeKeyholder(params[0], req);
        res.result = await processEncryptionPublicKey(address, req);
    }
    async function decryptMessage(req, res) {
        if (!processDecryptMessage) {
            throw rpc_errors_1.rpcErrors.methodNotSupported();
        }
        if (!(req === null || req === void 0 ? void 0 : req.params) ||
            !Array.isArray(req.params) ||
            !(req.params.length >= 1)) {
            throw rpc_errors_1.rpcErrors.invalidInput();
        }
        const params = req.params;
        const ciphertext = params[0];
        const address = await validateAndNormalizeKeyholder(params[1], req);
        const extraParams = params[2] || {};
        const msgParams = Object.assign(Object.assign({}, extraParams), { from: address, data: ciphertext });
        res.result = await processDecryptMessage(msgParams, req);
    }
    //
    // utility
    //
    /**
     * Validates the keyholder address, and returns a normalized (i.e. lowercase)
     * copy of it.
     *
     * @param address - The address to validate and normalize.
     * @param req - The request object.
     * @returns {string} - The normalized address, if valid. Otherwise, throws
     * an error
     */
    async function validateAndNormalizeKeyholder(address, req) {
        return (0, validation_1.validateAndNormalizeKeyholder)(address, req, { getAccounts });
    }
}
exports.createWalletMiddleware = createWalletMiddleware;
/**
 * Validates primary of typedSignMessage, to ensure that it's type definition is present in message.
 *
 * @param data - The data passed in typedSign request.
 */
function validatePrimaryType(data) {
    const { primaryType, types } = (0, normalize_1.parseTypedMessage)(data);
    if (!types) {
        throw rpc_errors_1.rpcErrors.invalidInput();
    }
    // Primary type can be an array.
    const baseType = (0, common_1.stripArrayTypeIfPresent)(primaryType);
    // Return if the base type is not defined in the types
    const baseTypeDefinitions = types[baseType];
    if (!baseTypeDefinitions) {
        throw rpc_errors_1.rpcErrors.invalidInput();
    }
}
/**
 * Validates verifyingContract of typedSignMessage.
 *
 * @param data - The data passed in typedSign request.
 * This function allows the verifyingContract to be either:
 * - A valid hex address
 * - The string "cosmos" (as it is hard-coded in some Cosmos ecosystem's EVM adapters)
 * - An empty string
 */
function validateVerifyingContract(data) {
    const { domain: { verifyingContract } = {} } = (0, normalize_1.parseTypedMessage)(data);
    // Explicit check for cosmos here has been added to address this issue
    // https://github.com/MetaMask/eth-json-rpc-middleware/issues/337
    if (verifyingContract &&
        verifyingContract !== 'cosmos' &&
        !(0, utils_1.isValidHexAddress)(verifyingContract)) {
        throw rpc_errors_1.rpcErrors.invalidInput();
    }
}

      };
    };
  }
  }
}, {package:"@metamask/eth-json-rpc-middleware",file:"node_modules\\@metamask\\eth-json-rpc-middleware\\dist\\wallet.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\index.cjs", {"./ledger-hw-app.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\ledger-hw-app.cjs","./ledger-iframe-bridge.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\ledger-iframe-bridge.cjs","./ledger-keyring.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\ledger-keyring.cjs","./ledger-mobile-bridge.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\ledger-mobile-bridge.cjs","./ledger-transport-middleware.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\ledger-transport-middleware.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-ledger-bridge-keyring%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./ledger-keyring.cjs"), exports);
__exportStar(require("./ledger-iframe-bridge.cjs"), exports);
__exportStar(require("./ledger-mobile-bridge.cjs"), exports);
__exportStar(require("./ledger-transport-middleware.cjs"), exports);
__exportStar(require("./ledger-hw-app.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/eth-ledger-bridge-keyring",file:"node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\ledger-error-handler.cjs", {"./type.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\type.cjs","@ledgerhq/hw-transport":"D:\\code\\v\\metamask-extension\\node_modules\\@ledgerhq\\hw-transport\\lib\\Transport.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-ledger-bridge-keyring%5Cdist%5Cledger-error-handler.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleLedgerTransportError = handleLedgerTransportError;
const hw_transport_1 = require("@ledgerhq/hw-transport");
const type_1 = require("./type.cjs");
/**
 * Central error handler for Ledger TransportStatusError instances.
 * Converts common Ledger transport errors into user-friendly error messages.
 *
 * @param error - The error to handle
 * @param fallbackMessage - Default error message if no specific handling is found
 * @throws Error with appropriate user-friendly message
 */
function handleLedgerTransportError(error, fallbackMessage) {
    if (error instanceof hw_transport_1.TransportStatusError) {
        const transportError = error;
        throw new type_1.LedgerStatusError(transportError.statusCode, getTransportErrorMessageFrom(transportError));
    }
    // For any other error (TransportStatusError not matching patterns or other errors)
    throw error instanceof Error ? error : new Error(fallbackMessage);
}
/**
 * Get the transport error message from the transport error.
 *
 * @param transportError - The transport error
 * @returns The transport error message
 */
function getTransportErrorMessageFrom(transportError) {
    switch (transportError.statusCode) {
        case 0x6985:
            return 'Ledger: User rejected the transaction';
        case 0x6a80:
            return 'Ledger: Blind signing must be enabled';
        case 0x5515:
            return 'Ledger: Device is locked. Unlock it to continue';
        case 0x650f:
            return 'Ledger: Ethereum app closed. Open it to unlock';
        default:
            return transportError.message;
    }
}

      };
    };
  }
  }
}, {package:"@metamask/eth-ledger-bridge-keyring",file:"node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\ledger-error-handler.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\ledger-hw-app.cjs", {"@ledgerhq/hw-app-eth":"D:\\code\\v\\metamask-extension\\node_modules\\@ledgerhq\\hw-app-eth\\lib\\Eth.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-ledger-bridge-keyring%5Cdist%5Cledger-hw-app.cjs
      return function (require, module, exports) {
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetaMaskLedgerHwAppEth = void 0;
const hw_app_eth_1 = __importDefault(require("@ledgerhq/hw-app-eth"));
const buffer_1 = require("buffer");
class MetaMaskLedgerHwAppEth extends hw_app_eth_1.default {
    constructor() {
        super(...arguments);
        this.mainAppName = 'BOLOS';
        this.ethAppName = 'Ethereum';
        this.transportEncoding = 'ascii';
    }
    /**
     * Method to open ethereum application on ledger device.
     *
     */
    async openEthApp() {
        await this.transport.send(0xe0, 0xd8, 0x00, 0x00, buffer_1.Buffer.from(this.ethAppName, this.transportEncoding));
    }
    /**
     * Method to close all running application on ledger device.
     *
     */
    async closeApps() {
        await this.transport.send(0xb0, 0xa7, 0x00, 0x00);
    }
    /**
     * Method to retrieve the name and version of the running application in ledger device.
     *
     * @returns An object contains appName and version.
     */
    async getAppNameAndVersion() {
        const response = await this.transport.send(0xb0, 0x01, 0x00, 0x00);
        if (response[0] !== 1) {
            throw new Error('Incorrect format return from getAppNameAndVersion.');
        }
        let i = 1;
        const nameLength = response[i] ?? 0;
        i += 1;
        const appName = response
            .slice(i, (i += nameLength))
            .toString(this.transportEncoding);
        const versionLength = response[i] ?? 0;
        i += 1;
        const version = response
            .slice(i, (i += versionLength))
            .toString(this.transportEncoding);
        return {
            appName,
            version,
        };
    }
}
exports.MetaMaskLedgerHwAppEth = MetaMaskLedgerHwAppEth;

      };
    };
  }
  }
}, {package:"@metamask/eth-ledger-bridge-keyring",file:"node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\ledger-hw-app.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\ledger-iframe-bridge.cjs", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-ledger-bridge-keyring%5Cdist%5Cledger-iframe-bridge.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var _LedgerIframeBridge_instances, _LedgerIframeBridge_opts, _LedgerIframeBridge_messageResponseHandles, _LedgerIframeBridge_deviceActionMessage, _LedgerIframeBridge_setupIframe, _LedgerIframeBridge_getOrigin, _LedgerIframeBridge_eventListener, _LedgerIframeBridge_sendMessage, _LedgerIframeBridge_validateConfiguration;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LedgerIframeBridge = exports.IFrameMessageAction = void 0;
const utils_1 = require("@metamask/utils");
const LEDGER_IFRAME_ID = 'LEDGER-IFRAME';
const IFRAME_MESSAGE_TIMEOUT = 8000;
var IFrameMessageAction;
(function (IFrameMessageAction) {
    IFrameMessageAction["LedgerIsIframeReady"] = "ledger-is-iframe-ready";
    IFrameMessageAction["LedgerConnectionChange"] = "ledger-connection-change";
    IFrameMessageAction["LedgerUnlock"] = "ledger-unlock";
    IFrameMessageAction["LedgerMakeApp"] = "ledger-make-app";
    IFrameMessageAction["LedgerUpdateTransport"] = "ledger-update-transport";
    IFrameMessageAction["LedgerSignTransaction"] = "ledger-sign-transaction";
    IFrameMessageAction["LedgerSignPersonalMessage"] = "ledger-sign-personal-message";
    IFrameMessageAction["LedgerSignTypedData"] = "ledger-sign-typed-data";
})(IFrameMessageAction || (exports.IFrameMessageAction = IFrameMessageAction = {}));
class LedgerIframeBridge {
    constructor(opts = {
        bridgeUrl: 'https://metamask.github.io/eth-ledger-bridge-keyring',
    }) {
        _LedgerIframeBridge_instances.add(this);
        this.iframeLoaded = false;
        _LedgerIframeBridge_opts.set(this, void 0);
        this.isDeviceConnected = false;
        this.currentMessageId = 0;
        _LedgerIframeBridge_messageResponseHandles.set(this, new Map());
        __classPrivateFieldGet(this, _LedgerIframeBridge_instances, "m", _LedgerIframeBridge_validateConfiguration).call(this, opts);
        __classPrivateFieldSet(this, _LedgerIframeBridge_opts, {
            bridgeUrl: opts?.bridgeUrl,
        }, "f");
    }
    async init() {
        await __classPrivateFieldGet(this, _LedgerIframeBridge_instances, "m", _LedgerIframeBridge_setupIframe).call(this, __classPrivateFieldGet(this, _LedgerIframeBridge_opts, "f").bridgeUrl);
        this.eventListener = __classPrivateFieldGet(this, _LedgerIframeBridge_instances, "m", _LedgerIframeBridge_eventListener).bind(this, __classPrivateFieldGet(this, _LedgerIframeBridge_opts, "f").bridgeUrl);
        window.addEventListener('message', this.eventListener);
    }
    async destroy() {
        if (this.eventListener) {
            window.removeEventListener('message', this.eventListener);
        }
    }
    async getOptions() {
        return __classPrivateFieldGet(this, _LedgerIframeBridge_opts, "f");
    }
    async setOptions(opts) {
        __classPrivateFieldGet(this, _LedgerIframeBridge_instances, "m", _LedgerIframeBridge_validateConfiguration).call(this, opts);
        if (__classPrivateFieldGet(this, _LedgerIframeBridge_opts, "f")?.bridgeUrl !== opts.bridgeUrl) {
            __classPrivateFieldGet(this, _LedgerIframeBridge_opts, "f").bridgeUrl = opts.bridgeUrl;
            await this.destroy();
            await this.init();
        }
    }
    async attemptMakeApp() {
        const response = await __classPrivateFieldGet(this, _LedgerIframeBridge_instances, "m", _LedgerIframeBridge_sendMessage).call(this, {
            action: IFrameMessageAction.LedgerMakeApp,
        }, { timeout: IFRAME_MESSAGE_TIMEOUT });
        if ('success' in response && response.success) {
            return true;
        }
        else if ('error' in response) {
            // Assuming this is using an `Error` type:
            throw response.error;
        }
        else {
            throw new Error('Unknown error occurred');
        }
    }
    async updateTransportMethod(transportType) {
        if (!this.iframeLoaded) {
            throw new Error('The iframe is not loaded yet');
        }
        const response = await __classPrivateFieldGet(this, _LedgerIframeBridge_instances, "m", _LedgerIframeBridge_sendMessage).call(this, {
            action: IFrameMessageAction.LedgerUpdateTransport,
            params: { transportType },
        }, { timeout: IFRAME_MESSAGE_TIMEOUT });
        if ('success' in response && response.success) {
            return true;
        }
        throw new Error('Ledger transport could not be updated');
    }
    async getPublicKey(params) {
        return __classPrivateFieldGet(this, _LedgerIframeBridge_instances, "m", _LedgerIframeBridge_deviceActionMessage).call(this, IFrameMessageAction.LedgerUnlock, params);
    }
    async deviceSignTransaction(params) {
        return __classPrivateFieldGet(this, _LedgerIframeBridge_instances, "m", _LedgerIframeBridge_deviceActionMessage).call(this, IFrameMessageAction.LedgerSignTransaction, params);
    }
    async deviceSignMessage(params) {
        return __classPrivateFieldGet(this, _LedgerIframeBridge_instances, "m", _LedgerIframeBridge_deviceActionMessage).call(this, IFrameMessageAction.LedgerSignPersonalMessage, params);
    }
    async deviceSignTypedData(params) {
        return __classPrivateFieldGet(this, _LedgerIframeBridge_instances, "m", _LedgerIframeBridge_deviceActionMessage).call(this, IFrameMessageAction.LedgerSignTypedData, params);
    }
}
exports.LedgerIframeBridge = LedgerIframeBridge;
_LedgerIframeBridge_opts = new WeakMap(), _LedgerIframeBridge_messageResponseHandles = new WeakMap(), _LedgerIframeBridge_instances = new WeakSet(), _LedgerIframeBridge_deviceActionMessage = async function _LedgerIframeBridge_deviceActionMessage(...[action, params]) {
    const response = await __classPrivateFieldGet(this, _LedgerIframeBridge_instances, "m", _LedgerIframeBridge_sendMessage).call(this, { action, params });
    if ('payload' in response && response.payload) {
        if ('success' in response && response.success) {
            return response.payload;
        }
        if ('error' in response.payload) {
            throw response.payload.error;
        }
    }
    throw new Error('Unknown error occurred');
}, _LedgerIframeBridge_setupIframe = async function _LedgerIframeBridge_setupIframe(bridgeUrl) {
    return new Promise((resolve) => {
        this.iframe = document.createElement('iframe');
        this.iframe.src = bridgeUrl;
        this.iframe.allow = `hid 'src'`;
        this.iframe.onload = async () => {
            this.iframeLoaded = true;
            resolve();
        };
        document.head.appendChild(this.iframe);
    });
}, _LedgerIframeBridge_getOrigin = function _LedgerIframeBridge_getOrigin(bridgeUrl) {
    const tmp = bridgeUrl.split('/');
    tmp.splice(-1, 1);
    return tmp.join('/');
}, _LedgerIframeBridge_eventListener = function _LedgerIframeBridge_eventListener(bridgeUrl, eventMessage) {
    const { origin, data } = eventMessage;
    if (origin !== __classPrivateFieldGet(this, _LedgerIframeBridge_instances, "m", _LedgerIframeBridge_getOrigin).call(this, bridgeUrl)) {
        return;
    }
    if (data) {
        const messageResponseHandle = __classPrivateFieldGet(this, _LedgerIframeBridge_messageResponseHandles, "f").get(data.messageId);
        if (messageResponseHandle) {
            messageResponseHandle.resolve(data);
            __classPrivateFieldGet(this, _LedgerIframeBridge_messageResponseHandles, "f").delete(data.messageId);
        }
        else if (data.action === IFrameMessageAction.LedgerConnectionChange) {
            this.isDeviceConnected = data.payload.connected;
        }
    }
}, _LedgerIframeBridge_sendMessage = async function _LedgerIframeBridge_sendMessage(message, { timeout } = {}) {
    this.currentMessageId += 1;
    const postMsg = {
        ...message,
        messageId: this.currentMessageId,
        target: LEDGER_IFRAME_ID,
    };
    const messageResponseHandle = (0, utils_1.createDeferredPromise)();
    __classPrivateFieldGet(this, _LedgerIframeBridge_messageResponseHandles, "f").set(this.currentMessageId, messageResponseHandle);
    if (!this.iframeLoaded || !this.iframe?.contentWindow) {
        throw new Error('The iframe is not loaded yet');
    }
    if (timeout) {
        setTimeout(() => {
            if (__classPrivateFieldGet(this, _LedgerIframeBridge_messageResponseHandles, "f").has(postMsg.messageId)) {
                __classPrivateFieldGet(this, _LedgerIframeBridge_messageResponseHandles, "f").delete(postMsg.messageId);
                messageResponseHandle.reject(new Error('Ledger iframe message timeout'));
            }
        }, timeout);
    }
    this.iframe.contentWindow.postMessage(postMsg, '*');
    return messageResponseHandle.promise;
}, _LedgerIframeBridge_validateConfiguration = function _LedgerIframeBridge_validateConfiguration(opts) {
    if (typeof opts.bridgeUrl !== 'string' || opts.bridgeUrl.length === 0) {
        throw new Error('bridgeURL is not a valid URL');
    }
};

      };
    };
  }
  }
}, {package:"@metamask/eth-ledger-bridge-keyring",file:"node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\ledger-iframe-bridge.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\ledger-keyring.cjs", {"./ledger-error-handler.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\ledger-error-handler.cjs","@ethereumjs/rlp":"D:\\code\\v\\metamask-extension\\node_modules\\@ethereumjs\\rlp\\dist\\cjs\\index.js","@ethereumjs/tx":"D:\\code\\v\\metamask-extension\\node_modules\\@ethereumjs\\tx\\dist\\cjs\\index.js","@ethereumjs/util":"D:\\code\\v\\metamask-extension\\node_modules\\@ethereumjs\\util\\dist\\cjs\\index.js","@metamask/eth-sig-util":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-sig-util\\dist\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js","hdkey":"D:\\code\\v\\metamask-extension\\node_modules\\hdkey\\lib\\hdkey.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-ledger-bridge-keyring%5Cdist%5Cledger-keyring.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _LedgerKeyring_instances, _LedgerKeyring_migrateAccountDetails, _LedgerKeyring_signTransaction, _LedgerKeyring_getPage, _LedgerKeyring_getAccountsBIP44, _LedgerKeyring_getAccountsLegacy, _LedgerKeyring_addressFromIndex, _LedgerKeyring_pathFromAddress, _LedgerKeyring_getPathForIndex, _LedgerKeyring_isLedgerLiveHdPath, _LedgerKeyring_toLedgerPath, _LedgerKeyring_hasPreviousTransactions, _LedgerKeyring_getApiUrl, _LedgerKeyring_getChecksumHexAddress;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LedgerKeyring = void 0;
const rlp_1 = require("@ethereumjs/rlp");
const tx_1 = require("@ethereumjs/tx");
const util_1 = require("@ethereumjs/util");
const eth_sig_util_1 = require("@metamask/eth-sig-util");
const utils_1 = require("@metamask/utils");
const buffer_1 = require("buffer");
const hdkey_1 = __importDefault(require("hdkey"));
const ledger_error_handler_1 = require("./ledger-error-handler.cjs");
const pathBase = 'm';
const hdPathString = `${pathBase}/44'/60'/0'`;
const keyringType = 'Ledger Hardware';
// This number causes one of our failing tests to run very slowly, as the for loop needs to iterate 1000 times.
const MAX_INDEX = 1000;
var NetworkApiUrls;
(function (NetworkApiUrls) {
    NetworkApiUrls["Ropsten"] = "https://api-ropsten.etherscan.io";
    NetworkApiUrls["Kovan"] = "https://api-kovan.etherscan.io";
    NetworkApiUrls["Rinkeby"] = "https://api-rinkeby.etherscan.io";
    NetworkApiUrls["Mainnet"] = "https://api.etherscan.io";
})(NetworkApiUrls || (NetworkApiUrls = {}));
/**
 * Check if the given transaction is made with ethereumjs-tx or @ethereumjs/tx
 *
 * Transactions built with older versions of ethereumjs-tx have a
 * getChainId method that newer versions do not.
 * Older versions are mutable
 * while newer versions default to being immutable.
 * Expected shape and type
 * of data for v, r and s differ (Buffer (old) vs BN (new)).
 *
 * @param tx - Transaction to check, instance of either ethereumjs-tx or @ethereumjs/tx.
 * @returns Returns `true` if tx is an old-style ethereumjs-tx transaction.
 */
function isOldStyleEthereumjsTx(tx) {
    return 'getChainId' in tx && typeof tx.getChainId === 'function';
}
class LedgerKeyring {
    constructor({ bridge }) {
        _LedgerKeyring_instances.add(this);
        this.deviceId = '';
        this.type = keyringType;
        this.page = 0;
        this.perPage = 5;
        this.unlockedAccount = 0;
        this.accounts = [];
        this.accountDetails = {};
        this.hdk = new hdkey_1.default();
        this.hdPath = hdPathString;
        this.paths = {};
        this.network = NetworkApiUrls.Mainnet;
        this.implementFullBIP44 = false;
        if (!bridge) {
            throw new Error('Bridge is a required dependency for the keyring');
        }
        this.bridge = bridge;
    }
    async init() {
        return this.bridge.init();
    }
    async destroy() {
        return this.bridge.destroy();
    }
    async serialize() {
        return {
            hdPath: this.hdPath,
            accounts: this.accounts.slice(),
            deviceId: this.deviceId,
            accountDetails: this.accountDetails,
            implementFullBIP44: false,
        };
    }
    async deserialize(opts) {
        this.hdPath = opts.hdPath ?? hdPathString;
        this.accounts = opts.accounts ?? [];
        this.deviceId = opts.deviceId ?? '';
        this.accountDetails = opts.accountDetails ?? {};
        if (!opts.accountDetails) {
            __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_migrateAccountDetails).call(this, opts);
        }
        this.implementFullBIP44 = opts.implementFullBIP44 ?? false;
        const keys = new Set(Object.keys(this.accountDetails));
        // Remove accounts that don't have corresponding account details
        this.accounts = this.accounts.filter((account) => keys.has(__classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getChecksumHexAddress).call(this, account)));
        return Promise.resolve();
    }
    setDeviceId(deviceId) {
        this.deviceId = deviceId;
    }
    getDeviceId() {
        return this.deviceId;
    }
    isUnlocked() {
        return Boolean(this.hdk.publicKey);
    }
    isConnected() {
        return this.bridge.isDeviceConnected;
    }
    setAccountToUnlock(index) {
        this.unlockedAccount = index;
    }
    setHdPath(hdPath) {
        // Reset HDKey if the path changes
        if (this.hdPath !== hdPath) {
            this.hdk = new hdkey_1.default();
        }
        this.hdPath = hdPath;
    }
    async unlock(hdPath, updateHdk = true) {
        if (this.isUnlocked() && !hdPath) {
            // if the device is already unlocked and no path is provided,
            // we return the checksummed address of the public key stored in
            // `this.hdk`, which is the root address of the last unlocked path.
            return __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getChecksumHexAddress).call(this, (0, utils_1.bytesToHex)((0, util_1.publicToAddress)(this.hdk.publicKey, true)));
        }
        const path = hdPath ? __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_toLedgerPath).call(this, hdPath) : this.hdPath;
        let payload;
        try {
            payload = await this.bridge.getPublicKey({
                hdPath: path,
            });
        }
        catch (error) {
            (0, ledger_error_handler_1.handleLedgerTransportError)(error, 'Ledger: Unknown error while unlocking account');
        }
        if (updateHdk && payload.chainCode) {
            this.hdk.publicKey = buffer_1.Buffer.from(payload.publicKey, 'hex');
            this.hdk.chainCode = buffer_1.Buffer.from(payload.chainCode, 'hex');
        }
        return (0, utils_1.add0x)(payload.address);
    }
    async addAccounts(amount) {
        return new Promise((resolve, reject) => {
            this.unlock()
                .then(async (_) => {
                const from = this.unlockedAccount;
                const to = from + amount;
                const newAccounts = [];
                for (let i = from; i < to; i++) {
                    const path = __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getPathForIndex).call(this, i);
                    let address;
                    if (__classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_isLedgerLiveHdPath).call(this)) {
                        address = await this.unlock(path);
                    }
                    else {
                        address = __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_addressFromIndex).call(this, pathBase, i);
                    }
                    this.accountDetails[__classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getChecksumHexAddress).call(this, address)] = {
                        // TODO: consider renaming this property, as the current name is misleading
                        // It's currently used to represent whether an account uses the Ledger Live path.
                        bip44: __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_isLedgerLiveHdPath).call(this),
                        hdPath: path,
                    };
                    if (!this.accounts.includes(address)) {
                        this.accounts = [...this.accounts, address];
                        newAccounts.push(address);
                    }
                    this.page = 0;
                }
                resolve(newAccounts);
            })
                .catch(reject);
        });
    }
    getName() {
        return keyringType;
    }
    async getFirstPage() {
        this.page = 0;
        return __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getPage).call(this, 1);
    }
    async getNextPage() {
        return __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getPage).call(this, 1);
    }
    async getPreviousPage() {
        return __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getPage).call(this, -1);
    }
    async getAccounts() {
        return Promise.resolve(this.accounts.slice());
    }
    removeAccount(address) {
        const filteredAccounts = this.accounts.filter((a) => a.toLowerCase() !== address.toLowerCase());
        if (filteredAccounts.length === this.accounts.length) {
            throw new Error(`Address ${address} not found in this keyring`);
        }
        this.accounts = filteredAccounts;
        delete this.accountDetails[__classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getChecksumHexAddress).call(this, address)];
    }
    async attemptMakeApp() {
        return this.bridge.attemptMakeApp();
    }
    async updateTransportMethod(transportType) {
        return this.bridge.updateTransportMethod(transportType);
    }
    // tx is an instance of the ethereumjs-transaction class.
    async signTransaction(address, tx) {
        let rawTxHex;
        // transactions built with older versions of ethereumjs-tx have a
        // getChainId method that newer versions do not. Older versions are mutable
        // while newer versions default to being immutable. Expected shape and type
        // of data for v, r and s differ (Buffer (old) vs BN (new))
        if (isOldStyleEthereumjsTx(tx)) {
            // In this version of ethereumjs-tx we must add the chainId in hex format
            // to the initial v value. The chainId must be included in the serialized
            // transaction which is only communicated to ethereumjs-tx in this
            // value. In newer versions the chainId is communicated via the 'Common'
            // object.
            tx.v = tx.getChainId();
            // @ts-expect-error tx.r should be a Buffer, but we are assigning a string
            tx.r = '0x00';
            // @ts-expect-error tx.s should be a Buffer, but we are assigning a string
            tx.s = '0x00';
            rawTxHex = tx.serialize().toString('hex');
            return __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_signTransaction).call(this, address, rawTxHex, (payload) => {
                tx.v = buffer_1.Buffer.from(payload.v, 'hex');
                tx.r = buffer_1.Buffer.from(payload.r, 'hex');
                tx.s = buffer_1.Buffer.from(payload.s, 'hex');
                return tx;
            });
        }
        // The below `encode` call is only necessary for legacy transactions, as `getMessageToSign`
        // calls `rlp.encode` internally for non-legacy transactions. As per the "Transaction Execution"
        // section of the ethereum yellow paper, transactions need to be "well-formed RLP, with no additional
        // trailing bytes".
        // Note also that `getMessageToSign` will return valid RLP for all transaction types, whereas the
        // `serialize` method will not for any transaction type except legacy. This is because `serialize` includes
        // empty r, s and v values in the encoded rlp. This is why we use `getMessageToSign` here instead of `serialize`.
        const messageToSign = tx.getMessageToSign();
        rawTxHex = Array.isArray(messageToSign)
            ? buffer_1.Buffer.from(rlp_1.RLP.encode(messageToSign)).toString('hex')
            : (0, utils_1.bytesToHex)(messageToSign);
        return __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_signTransaction).call(this, address, rawTxHex, (payload) => {
            // Because tx will be immutable, first get a plain javascript object that
            // represents the transaction. Using txData here as it aligns with the
            // nomenclature of ethereumjs/tx.
            const txData = tx.toJSON();
            // The fromTxData utility expects a type to support transactions with a type other than 0
            txData.type = tx.type;
            // The fromTxData utility expects v,r and s to be hex prefixed
            txData.v = (0, utils_1.add0x)(payload.v);
            txData.r = (0, utils_1.add0x)(payload.r);
            txData.s = (0, utils_1.add0x)(payload.s);
            // Adopt the 'common' option from the original transaction and set the
            // returned object to be frozen if the original is frozen.
            return tx_1.TransactionFactory.fromTxData(txData, {
                common: tx.common,
                freeze: Object.isFrozen(tx),
            });
        });
    }
    async signMessage(withAccount, data) {
        return this.signPersonalMessage(withAccount, data);
    }
    // For personal_sign, we need to prefix the message:
    async signPersonalMessage(withAccount, message) {
        const hdPath = await this.unlockAccountByAddress(withAccount);
        if (!hdPath) {
            throw new Error('Ledger: Unknown error while signing message');
        }
        let payload;
        try {
            payload = await this.bridge.deviceSignMessage({
                hdPath,
                message: (0, utils_1.remove0x)(message),
            });
        }
        catch (error) {
            (0, ledger_error_handler_1.handleLedgerTransportError)(error, 'Ledger: Unknown error while signing message');
        }
        let modifiedV = parseInt(String(payload.v), 10).toString(16);
        if (modifiedV.length < 2) {
            modifiedV = `0${modifiedV}`;
        }
        const signature = `0x${payload.r}${payload.s}${modifiedV}`;
        const addressSignedWith = (0, eth_sig_util_1.recoverPersonalSignature)({
            data: message,
            signature,
        });
        if (__classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getChecksumHexAddress).call(this, addressSignedWith) !==
            __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getChecksumHexAddress).call(this, withAccount)) {
            throw new Error('Ledger: The signature doesnt match the right address');
        }
        return signature;
    }
    async unlockAccountByAddress(address) {
        const checksummedAddress = __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getChecksumHexAddress).call(this, address);
        const accountDetails = this.accountDetails[checksummedAddress];
        if (!accountDetails) {
            throw new Error(`Ledger: Account for address '${checksummedAddress}' not found`);
        }
        const { hdPath } = accountDetails;
        const unlockedAddress = await this.unlock(hdPath, false);
        // unlock resolves to the address for the given hdPath as reported by the ledger device
        // if that address is not the requested address, then this account belongs to a different device or seed
        if (unlockedAddress.toLowerCase() !== address.toLowerCase()) {
            throw new Error(`Ledger: Account ${address} does not belong to the connected device`);
        }
        return hdPath;
    }
    async signTypedData(withAccount, data, options) {
        const { version } = options ?? {};
        const isV4 = version === 'V4';
        if (!isV4) {
            throw new Error('Ledger: Only version 4 of typed data signing is supported');
        }
        const { domain, types, primaryType, message } = eth_sig_util_1.TypedDataUtils.sanitizeData(data);
        const hdPath = await this.unlockAccountByAddress(withAccount);
        if (!hdPath) {
            throw new Error('Ledger: Unknown error while signing message');
        }
        let payload;
        try {
            payload = await this.bridge.deviceSignTypedData({
                hdPath,
                message: {
                    domain: {
                        name: domain.name,
                        chainId: domain.chainId,
                        version: domain.version,
                        verifyingContract: domain.verifyingContract,
                        salt: domain.salt instanceof ArrayBuffer
                            ? buffer_1.Buffer.from(domain.salt).toString('hex')
                            : domain.salt,
                    },
                    types,
                    primaryType: primaryType.toString(),
                    message,
                },
            });
        }
        catch (error) {
            (0, ledger_error_handler_1.handleLedgerTransportError)(error, 'Ledger: Unknown error while signing message');
        }
        let recoveryId = parseInt(String(payload.v), 10).toString(16);
        if (recoveryId.length < 2) {
            recoveryId = `0${recoveryId}`;
        }
        const signature = `0x${payload.r}${payload.s}${recoveryId}`;
        const addressSignedWith = (0, eth_sig_util_1.recoverTypedSignature)({
            data,
            signature,
            version: eth_sig_util_1.SignTypedDataVersion.V4,
        });
        if (__classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getChecksumHexAddress).call(this, addressSignedWith) !==
            __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getChecksumHexAddress).call(this, withAccount)) {
            throw new Error('Ledger: The signature doesnt match the right address');
        }
        return signature;
    }
    forgetDevice() {
        this.deviceId = '';
        this.accounts = [];
        this.page = 0;
        this.unlockedAccount = 0;
        this.paths = {};
        this.accountDetails = {};
        this.hdk = new hdkey_1.default();
    }
}
exports.LedgerKeyring = LedgerKeyring;
_LedgerKeyring_instances = new WeakSet(), _LedgerKeyring_migrateAccountDetails = function _LedgerKeyring_migrateAccountDetails(opts) {
    if (__classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_isLedgerLiveHdPath).call(this) && opts.accountIndexes) {
        for (const [account, index] of Object.entries(opts.accountIndexes)) {
            this.accountDetails[account] = {
                bip44: true,
                hdPath: __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getPathForIndex).call(this, index),
            };
        }
    }
    const keys = new Set(Object.keys(this.accountDetails));
    // try to migrate non-LedgerLive accounts too
    if (!__classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_isLedgerLiveHdPath).call(this)) {
        this.accounts.forEach((account) => {
            const key = __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getChecksumHexAddress).call(this, account);
            if (!keys.has(key)) {
                this.accountDetails[key] = {
                    bip44: false,
                    hdPath: __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_pathFromAddress).call(this, account),
                };
            }
        });
    }
}, _LedgerKeyring_signTransaction = async function _LedgerKeyring_signTransaction(address, rawTxHex, handleSigning) {
    const hdPath = await this.unlockAccountByAddress(address);
    if (!hdPath) {
        throw new Error('Ledger: hdPath is empty while signing transaction');
    }
    let payload;
    try {
        payload = await this.bridge.deviceSignTransaction({
            tx: (0, utils_1.remove0x)(rawTxHex),
            hdPath,
        });
    }
    catch (error) {
        (0, ledger_error_handler_1.handleLedgerTransportError)(error, 'Ledger: Unknown error while signing transaction');
    }
    const newOrMutatedTx = handleSigning(payload);
    const valid = newOrMutatedTx.verifySignature();
    if (valid) {
        return newOrMutatedTx;
    }
    throw new Error('Ledger: The transaction signature is not valid');
}, _LedgerKeyring_getPage = 
/* PRIVATE METHODS */
async function _LedgerKeyring_getPage(increment) {
    this.page += increment;
    if (this.page <= 0) {
        this.page = 1;
    }
    const from = (this.page - 1) * this.perPage;
    const to = from + this.perPage;
    await this.unlock();
    let accounts;
    if (__classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_isLedgerLiveHdPath).call(this)) {
        accounts = await __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getAccountsBIP44).call(this, from, to);
    }
    else {
        accounts = __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getAccountsLegacy).call(this, from, to);
    }
    return accounts;
}, _LedgerKeyring_getAccountsBIP44 = async function _LedgerKeyring_getAccountsBIP44(from, to) {
    const accounts = [];
    for (let i = from; i < to; i++) {
        const path = __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getPathForIndex).call(this, i);
        const address = await this.unlock(path);
        const valid = this.implementFullBIP44
            ? await __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_hasPreviousTransactions).call(this, address)
            : true;
        accounts.push({
            address,
            balance: null,
            index: i,
        });
        // PER BIP44
        // "Software should prevent a creation of an account if
        // a previous account does not have a transaction history
        // (meaning none of its addresses have been used before)."
        if (!valid) {
            break;
        }
    }
    return accounts;
}, _LedgerKeyring_getAccountsLegacy = function _LedgerKeyring_getAccountsLegacy(from, to) {
    const accounts = [];
    for (let i = from; i < to; i++) {
        const address = __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_addressFromIndex).call(this, pathBase, i);
        accounts.push({
            address,
            balance: null,
            index: i,
        });
        this.paths[__classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getChecksumHexAddress).call(this, address)] = i;
    }
    return accounts;
}, _LedgerKeyring_addressFromIndex = function _LedgerKeyring_addressFromIndex(basePath, i) {
    const dkey = this.hdk.derive(`${basePath}/${i}`);
    const address = (0, utils_1.bytesToHex)((0, util_1.publicToAddress)(dkey.publicKey, true));
    return __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getChecksumHexAddress).call(this, address);
}, _LedgerKeyring_pathFromAddress = function _LedgerKeyring_pathFromAddress(address) {
    const checksummedAddress = __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getChecksumHexAddress).call(this, address);
    let index = this.paths[checksummedAddress];
    if (typeof index === 'undefined') {
        for (let i = 0; i < MAX_INDEX; i++) {
            if (checksummedAddress === __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_addressFromIndex).call(this, pathBase, i)) {
                index = i;
                break;
            }
        }
    }
    if (typeof index === 'undefined') {
        throw new Error('Unknown address');
    }
    return __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getPathForIndex).call(this, index);
}, _LedgerKeyring_getPathForIndex = function _LedgerKeyring_getPathForIndex(index) {
    // Check if the path is BIP 44 (Ledger Live)
    return __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_isLedgerLiveHdPath).call(this)
        ? `m/44'/60'/${index}'/0/0`
        : `${this.hdPath}/${index}`;
}, _LedgerKeyring_isLedgerLiveHdPath = function _LedgerKeyring_isLedgerLiveHdPath() {
    return this.hdPath === `m/44'/60'/0'/0/0`;
}, _LedgerKeyring_toLedgerPath = function _LedgerKeyring_toLedgerPath(path) {
    return path.toString().replace('m/', '');
}, _LedgerKeyring_hasPreviousTransactions = async function _LedgerKeyring_hasPreviousTransactions(address) {
    const apiUrl = __classPrivateFieldGet(this, _LedgerKeyring_instances, "m", _LedgerKeyring_getApiUrl).call(this);
    const response = await window.fetch(`${apiUrl}/api?module=account&action=txlist&address=${address}&tag=latest&page=1&offset=1`);
    const parsedResponse = await response.json();
    return parsedResponse.status !== '0' && parsedResponse.result.length > 0;
}, _LedgerKeyring_getApiUrl = function _LedgerKeyring_getApiUrl() {
    return this.network;
}, _LedgerKeyring_getChecksumHexAddress = function _LedgerKeyring_getChecksumHexAddress(address) {
    return (0, utils_1.getChecksumAddress)((0, utils_1.add0x)(address));
};
LedgerKeyring.type = keyringType;

      };
    };
  }
  }
}, {package:"@metamask/eth-ledger-bridge-keyring",file:"node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\ledger-keyring.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\ledger-mobile-bridge.cjs", {"./ledger-hw-app.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\ledger-hw-app.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-ledger-bridge-keyring%5Cdist%5Cledger-mobile-bridge.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _LedgerMobileBridge_instances, _LedgerMobileBridge_transportMiddleware, _LedgerMobileBridge_opts, _LedgerMobileBridge_getTransportMiddleWare, _LedgerMobileBridge_getEthApp;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LedgerMobileBridge = void 0;
const ledger_hw_app_1 = require("./ledger-hw-app.cjs");
/**
 * LedgerMobileBridge is a bridge between the LedgerKeyring and the LedgerTransportMiddleware.
 */
class LedgerMobileBridge {
    constructor(transportMiddleware, opts = {}) {
        _LedgerMobileBridge_instances.add(this);
        _LedgerMobileBridge_transportMiddleware.set(this, void 0);
        _LedgerMobileBridge_opts.set(this, void 0);
        this.isDeviceConnected = false;
        __classPrivateFieldSet(this, _LedgerMobileBridge_opts, opts, "f");
        __classPrivateFieldSet(this, _LedgerMobileBridge_transportMiddleware, transportMiddleware, "f");
    }
    /**
     * Method to initializes the keyring.
     * Mobile ledger doesnt not require init.
     *
     * @returns A promise that will resolve once the bridge is initialized.
     */
    async init() {
        return Promise.resolve();
    }
    /**
     * Method to destroy the keyring.
     * It will dispose the transportmiddleware and set isDeviceConnected to false.
     */
    async destroy() {
        try {
            await __classPrivateFieldGet(this, _LedgerMobileBridge_instances, "m", _LedgerMobileBridge_getTransportMiddleWare).call(this).dispose();
        }
        catch (error) {
            // eslint-disable-next-line no-console
            console.error(error);
        }
        this.isDeviceConnected = false;
    }
    /**
     * Method to sign a string Message.
     * Sending the string message to the device and returning the signed message.
     *
     * @param params - An object contains hdPath and message.
     * @param params.hdPath - The BIP 32 path of the account.
     * @param params.message - The message to sign.
     * @returns Retrieve v, r, s from the signed message.
     */
    async deviceSignMessage({ hdPath, message, }) {
        return __classPrivateFieldGet(this, _LedgerMobileBridge_instances, "m", _LedgerMobileBridge_getEthApp).call(this).signPersonalMessage(hdPath, message);
    }
    /**
     * Method to sign a EIP712 Message.
     * Sending the typed data message to the device and returning the signed message.
     *
     * @param params - An object contains hdPath, domainSeparatorHex and hashStructMessageHex.
     * @param params.hdPath - The BIP 32 path of the account.
     * @param params.message - The EIP712 message to sign.
     * @returns Retrieve v, r, s from the signed message.
     */
    async deviceSignTypedData({ hdPath, message, }) {
        return __classPrivateFieldGet(this, _LedgerMobileBridge_instances, "m", _LedgerMobileBridge_getEthApp).call(this).signEIP712Message(hdPath, message);
    }
    /**
     * Method to sign a transaction
     * Sending the hexadecimal transaction message to the device and returning the signed transaction.
     *
     * @param params - An object contains tx, hdPath.
     * @param params.tx - The raw ethereum transaction in hexadecimal to sign.
     * @param params.hdPath - The BIP 32 path of the account.
     * @returns Retrieve v, r, s from the signed transaction.
     */
    async deviceSignTransaction({ tx, hdPath, }) {
        return __classPrivateFieldGet(this, _LedgerMobileBridge_instances, "m", _LedgerMobileBridge_getEthApp).call(this).clearSignTransaction(hdPath, tx, {
            externalPlugins: true,
            erc20: true,
            nft: true,
        });
    }
    /**
     * Method to retrieve the ethereum address for a given BIP 32 path.
     *
     * @param params - An object contains hdPath.
     * @param params.hdPath - The BIP 32 path of the account.
     * @returns An object contains publicKey, address and chainCode.
     */
    async getPublicKey({ hdPath, }) {
        return await __classPrivateFieldGet(this, _LedgerMobileBridge_instances, "m", _LedgerMobileBridge_getEthApp).call(this).getAddress(hdPath, false, true);
    }
    /**
     * Method to retrieve the current configuration.
     *
     * @returns Retrieve current configuration.
     */
    async getOptions() {
        return __classPrivateFieldGet(this, _LedgerMobileBridge_opts, "f");
    }
    /**
     * Method to set the current configuration.
     *
     * @param opts - An configuration object.
     */
    async setOptions(opts) {
        __classPrivateFieldSet(this, _LedgerMobileBridge_opts, opts, "f");
    }
    /**
     * Method to set the transport object to communicate with the device.
     *
     * @param transport - The communication interface with the Ledger hardware wallet. There are different kind of transports based on the technology (channels like U2F, HID, Bluetooth, Webusb).
     * @returns Retrieve boolean.
     */
    async updateTransportMethod(transport) {
        if (!transport.deviceModel) {
            throw new Error('Property `deviceModel` is not defined in `transport`.');
        }
        if (!transport.deviceModel.id) {
            throw new Error('Property `deviceModel.id` is not defined in `transport`.');
        }
        __classPrivateFieldGet(this, _LedgerMobileBridge_instances, "m", _LedgerMobileBridge_getTransportMiddleWare).call(this).setTransport(transport);
        this.isDeviceConnected = true;
        return Promise.resolve(true);
    }
    /**
     * Method to init eth app object on ledger device.
     * This method is not supported on mobile.
     */
    async attemptMakeApp() {
        throw new Error('Method not supported.');
    }
    /**
     * Method to open ethereum application on ledger device.
     *
     */
    async openEthApp() {
        await __classPrivateFieldGet(this, _LedgerMobileBridge_instances, "m", _LedgerMobileBridge_getEthApp).call(this).openEthApp();
    }
    /**
     * Method to close all running application on ledger device.
     *
     */
    async closeApps() {
        await __classPrivateFieldGet(this, _LedgerMobileBridge_instances, "m", _LedgerMobileBridge_getEthApp).call(this).closeApps();
    }
    /**
     * Method to retrieve the name and version of the running application in ledger device.
     *
     * @returns An object contains appName and version.
     */
    async getAppNameAndVersion() {
        return __classPrivateFieldGet(this, _LedgerMobileBridge_instances, "m", _LedgerMobileBridge_getEthApp).call(this).getAppNameAndVersion();
    }
}
exports.LedgerMobileBridge = LedgerMobileBridge;
_LedgerMobileBridge_transportMiddleware = new WeakMap(), _LedgerMobileBridge_opts = new WeakMap(), _LedgerMobileBridge_instances = new WeakSet(), _LedgerMobileBridge_getTransportMiddleWare = function _LedgerMobileBridge_getTransportMiddleWare() {
    if (__classPrivateFieldGet(this, _LedgerMobileBridge_transportMiddleware, "f")) {
        return __classPrivateFieldGet(this, _LedgerMobileBridge_transportMiddleware, "f");
    }
    throw new Error('Instance `transportMiddleware` is not initialized.');
}, _LedgerMobileBridge_getEthApp = function _LedgerMobileBridge_getEthApp() {
    return __classPrivateFieldGet(this, _LedgerMobileBridge_instances, "m", _LedgerMobileBridge_getTransportMiddleWare).call(this).getEthApp();
};

      };
    };
  }
  }
}, {package:"@metamask/eth-ledger-bridge-keyring",file:"node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\ledger-mobile-bridge.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\ledger-transport-middleware.cjs", {"./ledger-hw-app.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\ledger-hw-app.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-ledger-bridge-keyring%5Cdist%5Cledger-transport-middleware.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _LedgerTransportMiddleware_transport;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LedgerTransportMiddleware = void 0;
const ledger_hw_app_1 = require("./ledger-hw-app.cjs");
/**
 * LedgerTransportMiddleware is a middleware to communicate with the Ledger device via transport or LedgerHwAppEth
 */
class LedgerTransportMiddleware {
    constructor() {
        this.mainAppName = 'BOLOS';
        this.ethAppName = 'Ethereum';
        this.transportEncoding = 'ascii';
        _LedgerTransportMiddleware_transport.set(this, void 0);
    }
    /**
     * Method to close the transport connection.
     */
    async dispose() {
        const transport = this.getTransport();
        await transport.close();
    }
    /**
     * Method to set the transport object.
     *
     * @param transport - The transport object for communicating with a Ledger hardware wallet.
     */
    setTransport(transport) {
        __classPrivateFieldSet(this, _LedgerTransportMiddleware_transport, transport, "f");
    }
    /**
     * Method to retrieve the transport object.
     *
     * @returns An generic interface for communicating with a Ledger hardware wallet.
     */
    getTransport() {
        if (!__classPrivateFieldGet(this, _LedgerTransportMiddleware_transport, "f")) {
            throw new Error('Instance `transport` is not initialized.');
        }
        return __classPrivateFieldGet(this, _LedgerTransportMiddleware_transport, "f");
    }
    /**
     * Method to get a new instance of the eth app object.
     *
     * @returns An generic interface for communicating with a Ledger hardware wallet to perform operation.
     */
    getEthApp() {
        return new ledger_hw_app_1.MetaMaskLedgerHwAppEth(this.getTransport());
    }
}
exports.LedgerTransportMiddleware = LedgerTransportMiddleware;
_LedgerTransportMiddleware_transport = new WeakMap();

      };
    };
  }
  }
}, {package:"@metamask/eth-ledger-bridge-keyring",file:"node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\ledger-transport-middleware.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\type.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-ledger-bridge-keyring%5Cdist%5Ctype.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LedgerStatusError = void 0;
class LedgerStatusError extends Error {
    /**
     * Creates a new LedgerStatusError.
     *
     * @param statusCode - The status code of the error.
     * @param message - The message of the error.
     */
    constructor(statusCode, message) {
        super(message);
        this.statusCode = statusCode;
    }
}
exports.LedgerStatusError = LedgerStatusError;

      };
    };
  }
  }
}, {package:"@metamask/eth-ledger-bridge-keyring",file:"node_modules\\@metamask\\eth-ledger-bridge-keyring\\dist\\type.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-trezor-keyring\\dist\\index.cjs", {"./onekey-keyring.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-trezor-keyring\\dist\\onekey-keyring.cjs","./trezor-connect-bridge.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-trezor-keyring\\dist\\trezor-connect-bridge.cjs","./trezor-keyring.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-trezor-keyring\\dist\\trezor-keyring.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-trezor-keyring%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./trezor-keyring.cjs"), exports);
__exportStar(require("./onekey-keyring.cjs"), exports);
__exportStar(require("./trezor-connect-bridge.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/eth-trezor-keyring",file:"node_modules\\@metamask\\eth-trezor-keyring\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-trezor-keyring\\dist\\onekey-keyring.cjs", {"./trezor-keyring.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-trezor-keyring\\dist\\trezor-keyring.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-trezor-keyring%5Cdist%5Conekey-keyring.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OneKeyKeyring = void 0;
const trezor_keyring_1 = require("./trezor-keyring.cjs");
const oneKeyKeyringType = 'OneKey Hardware';
class OneKeyKeyring extends trezor_keyring_1.TrezorKeyring {
    constructor() {
        super(...arguments);
        this.type = oneKeyKeyringType;
    }
}
exports.OneKeyKeyring = OneKeyKeyring;
OneKeyKeyring.type = oneKeyKeyringType;

      };
    };
  }
  }
}, {package:"@metamask/eth-trezor-keyring",file:"node_modules\\@metamask\\eth-trezor-keyring\\dist\\onekey-keyring.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-trezor-keyring\\dist\\trezor-connect-bridge.cjs", {"@trezor/connect-web":"D:\\code\\v\\metamask-extension\\node_modules\\@trezor\\connect-web\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-trezor-keyring%5Cdist%5Ctrezor-connect-bridge.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrezorConnectBridge = void 0;
const connect_web_1 = __importStar(require("@trezor/connect-web"));
class TrezorConnectBridge {
    constructor() {
        this.trezorConnectInitiated = false;
    }
    async init(settings) {
        connect_web_1.default.on(connect_web_1.DEVICE_EVENT, (event) => {
            var _a;
            if (event.type !== connect_web_1.DEVICE.CONNECT) {
                return;
            }
            this.model = (_a = event.payload.features) === null || _a === void 0 ? void 0 : _a.model;
        });
        if (this.trezorConnectInitiated) {
            return;
        }
        await connect_web_1.default.init(settings);
        this.trezorConnectInitiated = true;
    }
    async dispose() {
        // This removes the Trezor Connect iframe from the DOM
        // This method is not well documented, but the code it calls can be seen
        // here: https://github.com/trezor/connect/blob/dec4a56af8a65a6059fb5f63fa3c6690d2c37e00/src/js/iframe/builder.js#L181
        connect_web_1.default.dispose();
        return Promise.resolve();
    }
    getPublicKey(params) {
        return connect_web_1.default.getPublicKey(params);
    }
    ethereumSignTransaction(params) {
        return connect_web_1.default.ethereumSignTransaction(params);
    }
    ethereumSignMessage(params) {
        return connect_web_1.default.ethereumSignMessage(params);
    }
    ethereumSignTypedData(params) {
        return connect_web_1.default.ethereumSignTypedData(params);
    }
}
exports.TrezorConnectBridge = TrezorConnectBridge;

      };
    };
  }
  }
}, {package:"@metamask/eth-trezor-keyring",file:"node_modules\\@metamask\\eth-trezor-keyring\\dist\\trezor-connect-bridge.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-trezor-keyring\\dist\\trezor-keyring.cjs", {"@ethereumjs/tx":"D:\\code\\v\\metamask-extension\\node_modules\\@ethereumjs\\tx\\dist\\cjs\\index.js","@ethereumjs/util":"D:\\code\\v\\metamask-extension\\node_modules\\@ethereumjs\\util\\dist\\cjs\\index.js","@metamask/eth-sig-util":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-sig-util\\dist\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","@trezor/connect-plugin-ethereum":"D:\\code\\v\\metamask-extension\\node_modules\\@trezor\\connect-plugin-ethereum\\lib\\index.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js","hdkey":"D:\\code\\v\\metamask-extension\\node_modules\\hdkey\\lib\\hdkey.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-trezor-keyring%5Cdist%5Ctrezor-keyring.cjs
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _TrezorKeyring_instances, _TrezorKeyring_getPage, _TrezorKeyring_signTransaction, _TrezorKeyring_normalize, _TrezorKeyring_addressFromIndex, _TrezorKeyring_pathFromAddress;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrezorKeyring = exports.TREZOR_CONNECT_MANIFEST = void 0;
const tx_1 = require("@ethereumjs/tx");
const util_1 = require("@ethereumjs/util");
const eth_sig_util_1 = require("@metamask/eth-sig-util");
const utils_1 = require("@metamask/utils");
const connect_plugin_ethereum_1 = require("@trezor/connect-plugin-ethereum");
const hdkey_1 = __importDefault(require("hdkey"));
const hdPathString = `m/44'/60'/0'/0`;
const SLIP0044TestnetPath = `m/44'/1'/0'/0`;
const legacyMewPath = `m/44'/60'/0'`;
const ALLOWED_HD_PATHS = {
    [hdPathString]: true,
    [legacyMewPath]: true,
    [SLIP0044TestnetPath]: true,
};
const keyringType = 'Trezor Hardware';
const pathBase = 'm';
const MAX_INDEX = 1000;
const DELAY_BETWEEN_POPUPS = 1000;
exports.TREZOR_CONNECT_MANIFEST = {
    appName: 'MetaMask',
    email: 'support@metamask.io',
    appUrl: 'https://metamask.io',
};
async function wait(ms) {
    return new Promise((resolve) => setTimeout(resolve, ms));
}
/**
 * Check if the given transaction is made with ethereumjs-tx or @ethereumjs/tx
 *
 * Transactions built with older versions of ethereumjs-tx have a
 * getChainId method that newer versions do not.
 * Older versions are mutable
 * while newer versions default to being immutable.
 * Expected shape and type
 * of data for v, r and s differ (Buffer (old) vs BN (new)).
 *
 * @param tx
 * @returns Returns `true` if tx is an old-style ethereumjs-tx transaction.
 */
function isOldStyleEthereumjsTx(tx) {
    return typeof tx.getChainId === 'function';
}
class TrezorKeyring {
    constructor({ bridge }) {
        _TrezorKeyring_instances.add(this);
        this.type = keyringType;
        this.accounts = [];
        this.hdk = new hdkey_1.default();
        this.hdPath = hdPathString;
        this.page = 0;
        this.perPage = 5;
        this.unlockedAccount = 0;
        this.paths = {};
        if (!bridge) {
            throw new Error('Bridge is a required dependency for the keyring');
        }
        this.bridge = bridge;
    }
    /**
     * Gets the model, if known.
     * This may be `undefined` if the model hasn't been loaded yet.
     *
     * @returns
     */
    getModel() {
        return this.bridge.model;
    }
    async init() {
        return this.bridge.init({
            manifest: exports.TREZOR_CONNECT_MANIFEST,
            lazyLoad: true,
        });
    }
    async destroy() {
        return this.bridge.dispose();
    }
    async serialize() {
        return Promise.resolve({
            hdPath: this.hdPath,
            accounts: this.accounts.slice(),
            page: this.page,
            paths: this.paths,
            perPage: this.perPage,
            unlockedAccount: this.unlockedAccount,
        });
    }
    async deserialize(opts) {
        var _a, _b, _c, _d;
        this.hdPath = (_a = opts.hdPath) !== null && _a !== void 0 ? _a : hdPathString;
        this.accounts = (_b = opts.accounts) !== null && _b !== void 0 ? _b : [];
        this.page = (_c = opts.page) !== null && _c !== void 0 ? _c : 0;
        this.perPage = (_d = opts.perPage) !== null && _d !== void 0 ? _d : 5;
        return Promise.resolve();
    }
    isUnlocked() {
        var _a;
        return Boolean((_a = this.hdk) === null || _a === void 0 ? void 0 : _a.publicKey);
    }
    async unlock() {
        if (this.isUnlocked()) {
            return Promise.resolve('already unlocked');
        }
        return new Promise((resolve, reject) => {
            this.bridge
                .getPublicKey({
                path: this.hdPath,
                coin: 'ETH',
            })
                .then((response) => {
                var _a;
                if (response.success) {
                    this.hdk.publicKey = Buffer.from(response.payload.publicKey, 'hex');
                    this.hdk.chainCode = Buffer.from(response.payload.chainCode, 'hex');
                    resolve('just unlocked');
                }
                else {
                    reject(new Error(((_a = response.payload) === null || _a === void 0 ? void 0 : _a.error) || 'Unknown error'));
                }
            })
                .catch((e) => {
                reject(new Error((e === null || e === void 0 ? void 0 : e.toString()) || 'Unknown error'));
            });
        });
    }
    setAccountToUnlock(index) {
        this.unlockedAccount = parseInt(String(index), 10);
    }
    async addAccounts(numberOfAccounts) {
        return new Promise((resolve, reject) => {
            this.unlock()
                .then((_) => {
                const from = this.unlockedAccount;
                const to = from + numberOfAccounts;
                const newAccounts = [];
                for (let i = from; i < to; i++) {
                    const address = __classPrivateFieldGet(this, _TrezorKeyring_instances, "m", _TrezorKeyring_addressFromIndex).call(this, pathBase, i);
                    if (!this.accounts.includes(address)) {
                        this.accounts = [...this.accounts, address];
                        newAccounts.push(address);
                    }
                    this.page = 0;
                }
                resolve(newAccounts);
            })
                .catch((e) => {
                reject(e);
            });
        });
    }
    async getFirstPage() {
        this.page = 0;
        return __classPrivateFieldGet(this, _TrezorKeyring_instances, "m", _TrezorKeyring_getPage).call(this, 1);
    }
    async getNextPage() {
        return __classPrivateFieldGet(this, _TrezorKeyring_instances, "m", _TrezorKeyring_getPage).call(this, 1);
    }
    async getPreviousPage() {
        return __classPrivateFieldGet(this, _TrezorKeyring_instances, "m", _TrezorKeyring_getPage).call(this, -1);
    }
    async getAccounts() {
        return Promise.resolve(this.accounts.slice());
    }
    removeAccount(address) {
        if (!this.accounts.map((a) => a.toLowerCase()).includes(address.toLowerCase())) {
            throw new Error(`Address ${address} not found in this keyring`);
        }
        this.accounts = this.accounts.filter((a) => a.toLowerCase() !== address.toLowerCase());
    }
    /**
     * Signs a transaction using Trezor.
     *
     * Accepts either an ethereumjs-tx or @ethereumjs/tx transaction, and returns
     * the same type.
     *
     * @param address - Hex string address.
     * @param tx - Instance of either new-style or old-style ethereumjs transaction.
     * @returns The signed transaction, an instance of either new-style or old-style
     * ethereumjs transaction.
     */
    async signTransaction(address, tx) {
        if (isOldStyleEthereumjsTx(tx)) {
            // In this version of ethereumjs-tx we must add the chainId in hex format
            // to the initial v value. The chainId must be included in the serialized
            // transaction which is only communicated to ethereumjs-tx in this
            // value. In newer versions the chainId is communicated via the 'Common'
            // object.
            return __classPrivateFieldGet(this, _TrezorKeyring_instances, "m", _TrezorKeyring_signTransaction).call(this, address, 
            // @types/ethereumjs-tx and old ethereumjs-tx versions document
            // this function return value as Buffer, but the actual
            // Transaction._chainId will always be a number.
            // See https://github.com/ethereumjs/ethereumjs-tx/blob/v1.3.7/index.js#L126
            tx.getChainId(), tx, (payload) => {
                tx.v = Buffer.from(payload.v, 'hex');
                tx.r = Buffer.from(payload.r, 'hex');
                tx.s = Buffer.from(payload.s, 'hex');
                return tx;
            });
        }
        return __classPrivateFieldGet(this, _TrezorKeyring_instances, "m", _TrezorKeyring_signTransaction).call(this, address, Number(tx.common.chainId()), tx, (payload) => {
            // Because tx will be immutable, first get a plain javascript object that
            // represents the transaction. Using txData here as it aligns with the
            // nomenclature of ethereumjs/tx.
            const txData = tx.toJSON();
            // The fromTxData utility expects a type to support transactions with a type other than 0
            txData.type = tx.type;
            // The fromTxData utility expects v,r and s to be hex prefixed
            txData.v = (0, utils_1.add0x)(payload.v);
            txData.r = (0, utils_1.add0x)(payload.r);
            txData.s = (0, utils_1.add0x)(payload.s);
            // Adopt the 'common' option from the original transaction and set the
            // returned object to be frozen if the original is frozen.
            return tx_1.TransactionFactory.fromTxData(txData, {
                common: tx.common,
                freeze: Object.isFrozen(tx),
            });
        });
    }
    async signMessage(withAccount, data) {
        return this.signPersonalMessage(withAccount, data);
    }
    // For personal_sign, we need to prefix the message:
    async signPersonalMessage(withAccount, message) {
        return new Promise((resolve, reject) => {
            this.unlock()
                .then((status) => {
                setTimeout(() => {
                    this.bridge
                        .ethereumSignMessage({
                        path: __classPrivateFieldGet(this, _TrezorKeyring_instances, "m", _TrezorKeyring_pathFromAddress).call(this, withAccount),
                        message: (0, utils_1.remove0x)(message),
                        hex: true,
                    })
                        .then((response) => {
                        var _a;
                        if (response.success) {
                            if (response.payload.address !==
                                (0, utils_1.getChecksumAddress)(withAccount)) {
                                reject(new Error('signature doesnt match the right address'));
                            }
                            const signature = `0x${response.payload.signature}`;
                            resolve(signature);
                        }
                        else {
                            reject(new Error(((_a = response.payload) === null || _a === void 0 ? void 0 : _a.error) || 'Unknown error'));
                        }
                    })
                        .catch((e) => {
                        reject(new Error((e === null || e === void 0 ? void 0 : e.toString()) || 'Unknown error'));
                    });
                    // This is necessary to avoid popup collision
                    // between the unlock & sign trezor popups
                }, status === 'just unlocked' ? DELAY_BETWEEN_POPUPS : 0);
            })
                .catch((e) => {
                reject(new Error((e === null || e === void 0 ? void 0 : e.toString()) || 'Unknown error'));
            });
        });
    }
    // EIP-712 Sign Typed Data
    async signTypedData(address, data, options) {
        var _a, _b;
        const { version } = options !== null && options !== void 0 ? options : { version: eth_sig_util_1.SignTypedDataVersion.V4 };
        const dataWithHashes = (0, connect_plugin_ethereum_1.transformTypedData)(data, version === eth_sig_util_1.SignTypedDataVersion.V4);
        // set default values for signTypedData
        // Trezor is stricter than @metamask/eth-sig-util in what it accepts
        const { types, message = {}, domain = {}, primaryType, 
        // snake_case since Trezor uses Protobuf naming conventions here
        domain_separator_hash, // eslint-disable-line camelcase
        message_hash, // eslint-disable-line camelcase
         } = dataWithHashes;
        // This is necessary to avoid popup collision
        // between the unlock & sign trezor popups
        const status = await this.unlock();
        await wait(status === 'just unlocked' ? DELAY_BETWEEN_POPUPS : 0);
        const response = await this.bridge.ethereumSignTypedData({
            path: __classPrivateFieldGet(this, _TrezorKeyring_instances, "m", _TrezorKeyring_pathFromAddress).call(this, address),
            data: {
                types: Object.assign(Object.assign({}, types), { EIP712Domain: (_a = types.EIP712Domain) !== null && _a !== void 0 ? _a : [] }),
                message,
                domain,
                primaryType,
            },
            metamask_v4_compat: true, // eslint-disable-line camelcase
            // Trezor 1 only supports blindly signing hashes
            domain_separator_hash, // eslint-disable-line camelcase
            message_hash: message_hash !== null && message_hash !== void 0 ? message_hash : '', // eslint-disable-line camelcase
        });
        if (response.success) {
            if ((0, utils_1.getChecksumAddress)(address) !== response.payload.address) {
                throw new Error('signature doesnt match the right address');
            }
            return response.payload.signature;
        }
        throw new Error(((_b = response.payload) === null || _b === void 0 ? void 0 : _b.error) || 'Unknown error');
    }
    forgetDevice() {
        this.accounts = [];
        this.hdk = new hdkey_1.default();
        this.page = 0;
        this.unlockedAccount = 0;
        this.paths = {};
    }
    /**
     * Set the HD path to be used by the keyring. Only known supported HD paths are allowed.
     *
     * If the given HD path is already the current HD path, nothing happens. Otherwise the new HD
     * path is set, and the wallet state is completely reset.
     *
     * @throws {Error] Throws if the HD path is not supported.
     *
     * @param hdPath - The HD path to set.
     */
    setHdPath(hdPath) {
        if (!ALLOWED_HD_PATHS[hdPath]) {
            throw new Error(`The setHdPath method does not support setting HD Path to ${hdPath}`);
        }
        // Reset HDKey if the path changes
        if (this.hdPath !== hdPath) {
            this.hdk = new hdkey_1.default();
            this.accounts = [];
            this.page = 0;
            this.perPage = 5;
            this.unlockedAccount = 0;
            this.paths = {};
        }
        this.hdPath = hdPath;
    }
}
exports.TrezorKeyring = TrezorKeyring;
_TrezorKeyring_instances = new WeakSet(), _TrezorKeyring_getPage = async function _TrezorKeyring_getPage(increment) {
    this.page += increment;
    if (this.page <= 0) {
        this.page = 1;
    }
    return new Promise((resolve, reject) => {
        this.unlock()
            .then((_) => {
            const from = (this.page - 1) * this.perPage;
            const to = from + this.perPage;
            const accounts = [];
            for (let i = from; i < to; i++) {
                const address = __classPrivateFieldGet(this, _TrezorKeyring_instances, "m", _TrezorKeyring_addressFromIndex).call(this, pathBase, i);
                accounts.push({
                    address,
                    balance: null,
                    index: i,
                });
                this.paths[(0, utils_1.getChecksumAddress)(address)] = i;
            }
            resolve(accounts);
        })
            .catch((e) => {
            reject(e);
        });
    });
}, _TrezorKeyring_signTransaction = 
/**
 *
 * @param address - Hex string address.
 * @param chainId - Chain ID
 * @param tx - Instance of either new-style or old-style ethereumjs transaction.
 * @param handleSigning - Converts signed transaction
 * to the same new-style or old-style ethereumjs-tx.
 * @returns The signed transaction, an instance of either new-style or old-style
 * ethereumjs transaction.
 */
async function _TrezorKeyring_signTransaction(address, chainId, tx, handleSigning) {
    var _a, _b, _c, _d;
    let transaction;
    if (isOldStyleEthereumjsTx(tx)) {
        // legacy transaction from ethereumjs-tx package has no .toJSON() function,
        // so we need to convert to hex-strings manually manually
        transaction = {
            to: __classPrivateFieldGet(this, _TrezorKeyring_instances, "m", _TrezorKeyring_normalize).call(this, tx.to),
            value: __classPrivateFieldGet(this, _TrezorKeyring_instances, "m", _TrezorKeyring_normalize).call(this, tx.value),
            data: __classPrivateFieldGet(this, _TrezorKeyring_instances, "m", _TrezorKeyring_normalize).call(this, tx.data),
            chainId,
            nonce: __classPrivateFieldGet(this, _TrezorKeyring_instances, "m", _TrezorKeyring_normalize).call(this, tx.nonce),
            gasLimit: __classPrivateFieldGet(this, _TrezorKeyring_instances, "m", _TrezorKeyring_normalize).call(this, tx.gasLimit),
            gasPrice: __classPrivateFieldGet(this, _TrezorKeyring_instances, "m", _TrezorKeyring_normalize).call(this, tx.gasPrice),
        };
    }
    else {
        // new-style transaction from @ethereumjs/tx package
        // we can just copy tx.toJSON() for everything except chainId, which must be a number
        transaction = Object.assign(Object.assign({}, tx.toJSON()), { chainId, to: __classPrivateFieldGet(this, _TrezorKeyring_instances, "m", _TrezorKeyring_normalize).call(this, Buffer.from((_b = (_a = tx.to) === null || _a === void 0 ? void 0 : _a.bytes) !== null && _b !== void 0 ? _b : [])) });
    }
    try {
        const status = await this.unlock();
        await wait(status === 'just unlocked' ? DELAY_BETWEEN_POPUPS : 0);
        const response = await this.bridge.ethereumSignTransaction({
            path: __classPrivateFieldGet(this, _TrezorKeyring_instances, "m", _TrezorKeyring_pathFromAddress).call(this, address),
            transaction,
        });
        if (response.success) {
            const newOrMutatedTx = handleSigning(response.payload);
            const addressSignedWith = (0, utils_1.getChecksumAddress)((0, utils_1.add0x)(newOrMutatedTx.getSenderAddress().toString('hex')));
            const correctAddress = (0, utils_1.getChecksumAddress)(address);
            if (addressSignedWith !== correctAddress) {
                throw new Error("signature doesn't match the right address");
            }
            return newOrMutatedTx;
        }
        throw new Error(((_c = response.payload) === null || _c === void 0 ? void 0 : _c.error) || 'Unknown error');
    }
    catch (e) {
        throw new Error((_d = e === null || e === void 0 ? void 0 : e.toString()) !== null && _d !== void 0 ? _d : 'Unknown error');
    }
}, _TrezorKeyring_normalize = function _TrezorKeyring_normalize(buf) {
    return (0, utils_1.bytesToHex)(buf);
}, _TrezorKeyring_addressFromIndex = function _TrezorKeyring_addressFromIndex(basePath, i) {
    const dkey = this.hdk.derive(`${basePath}/${i}`);
    const address = (0, utils_1.bytesToHex)((0, util_1.publicToAddress)(dkey.publicKey, true));
    return (0, util_1.toChecksumAddress)(address);
}, _TrezorKeyring_pathFromAddress = function _TrezorKeyring_pathFromAddress(address) {
    const checksummedAddress = (0, utils_1.getChecksumAddress)(address);
    let index = this.paths[checksummedAddress];
    if (typeof index === 'undefined') {
        for (let i = 0; i < MAX_INDEX; i++) {
            if (checksummedAddress === __classPrivateFieldGet(this, _TrezorKeyring_instances, "m", _TrezorKeyring_addressFromIndex).call(this, pathBase, i)) {
                index = i;
                break;
            }
        }
    }
    if (typeof index === 'undefined') {
        throw new Error('Unknown address');
    }
    return `${this.hdPath}/${index}`;
};
TrezorKeyring.type = keyringType;

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"@metamask/eth-trezor-keyring",file:"node_modules\\@metamask\\eth-trezor-keyring\\dist\\trezor-keyring.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\message-manager\\dist\\AbstractMessageManager.cjs", {"@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","events":"D:\\code\\v\\metamask-extension\\node_modules\\events\\events.js","uuid":"D:\\code\\v\\metamask-extension\\node_modules\\uuid\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmessage-manager%5Cdist%5CAbstractMessageManager.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AbstractMessageManager = void 0;
const base_controller_1 = require("@metamask/base-controller");
// This package purposefully relies on Node's EventEmitter module.
// eslint-disable-next-line import-x/no-nodejs-modules
const events_1 = require("events");
const uuid_1 = require("uuid");
const stateMetadata = {
    unapprovedMessages: {
        includeInStateLogs: true,
        persist: false,
        anonymous: false,
        usedInUi: true,
    },
    unapprovedMessagesCount: {
        includeInStateLogs: true,
        persist: false,
        anonymous: false,
        usedInUi: true,
    },
};
const getDefaultState = () => ({
    unapprovedMessages: {},
    unapprovedMessagesCount: 0,
});
/**
 * Controller in charge of managing - storing, adding, removing, updating - Messages.
 */
class AbstractMessageManager extends base_controller_1.BaseController {
    constructor({ additionalFinishStatuses, messenger, name, securityProviderRequest, state = {}, }) {
        super({
            messenger,
            metadata: stateMetadata,
            name,
            state: {
                ...getDefaultState(),
                ...state,
            },
        });
        this.internalEvents = new events_1.EventEmitter();
        this.messages = [];
        this.securityProviderRequest = securityProviderRequest;
        this.additionalFinishStatuses = additionalFinishStatuses ?? [];
    }
    /**
     * Adds request props to the messsage params and returns a new messageParams object.
     * @param messageParams - The messageParams to add the request props to.
     * @param req - The original request object.
     * @returns The messageParams with the request props added.
     */
    addRequestToMessageParams(messageParams, req) {
        const updatedMessageParams = {
            ...messageParams,
        };
        if (req) {
            updatedMessageParams.requestId = req.id;
            updatedMessageParams.origin = req.origin;
        }
        return updatedMessageParams;
    }
    /**
     * Creates a new Message with a random id and an 'unapproved' status.
     * @param messageParams - The messageParams to add the request props to.
     * @param type - The approval type of the message.
     * @param req - The original request object.
     * @returns The new unapproved message for a specified type.
     */
    createUnapprovedMessage(messageParams, type, req) {
        const messageId = (0, uuid_1.v1)();
        return {
            id: messageId,
            messageParams,
            securityAlertResponse: req?.securityAlertResponse,
            status: 'unapproved',
            time: Date.now(),
            type,
        };
    }
    /**
     * Saves the unapproved messages, and their count to state.
     *
     * @param emitUpdateBadge - Whether to emit the updateBadge event.
     */
    saveMessageList(emitUpdateBadge = true) {
        this.update((state) => {
            state.unapprovedMessages =
                this.getUnapprovedMessages();
            state.unapprovedMessagesCount = this.getUnapprovedMessagesCount();
        });
        if (emitUpdateBadge) {
            this.messagingSystem.publish(`${this.name}:updateBadge`);
        }
    }
    /**
     * Updates the status of a Message in this.messages.
     *
     * @param messageId - The id of the Message to update.
     * @param status - The new status of the Message.
     */
    setMessageStatus(messageId, status) {
        const message = this.getMessage(messageId);
        if (!message) {
            throw new Error(`${this.name}: Message not found for id: ${messageId}.`);
        }
        const updatedMessage = {
            ...message,
            status,
        };
        this.updateMessage(updatedMessage);
        this.internalEvents.emit(`${messageId}:${status}`, updatedMessage);
        if (status === 'rejected' ||
            status === 'signed' ||
            status === 'errored' ||
            this.additionalFinishStatuses.includes(status)) {
            this.internalEvents.emit(`${messageId}:finished`, updatedMessage);
        }
    }
    /**
     * Sets a Message in this.messages to the passed Message if the ids are equal.
     * Then saves the unapprovedMessage list to storage.
     *
     * @param message - A Message that will replace an existing Message (with the id) in this.messages.
     * @param emitUpdateBadge - Whether to emit the updateBadge event.
     */
    updateMessage(message, emitUpdateBadge = true) {
        const index = this.messages.findIndex((msg) => message.id === msg.id);
        /* istanbul ignore next */
        if (index !== -1) {
            this.messages[index] = message;
        }
        this.saveMessageList(emitUpdateBadge);
    }
    /**
     * Verifies a message is malicious or not by checking it against a security provider.
     *
     * @param message - The message to verify.
     * @returns A promise that resolves to a secured message with additional security provider response data.
     */
    async securityCheck(message) {
        if (this.securityProviderRequest) {
            const securityProviderResponse = await this.securityProviderRequest(message, message.type);
            return {
                ...message,
                securityProviderResponse,
            };
        }
        return message;
    }
    clearUnapprovedMessages() {
        this.update((state) => {
            state.unapprovedMessages = {};
            state.unapprovedMessagesCount = 0;
        });
    }
    /**
     * A getter for the number of 'unapproved' Messages in this.messages.
     *
     * @returns The number of 'unapproved' Messages in this.messages.
     */
    getUnapprovedMessagesCount() {
        return Object.keys(this.getUnapprovedMessages()).length;
    }
    /**
     * A getter for the 'unapproved' Messages in state messages.
     *
     * @returns An index of Message ids to Messages, for all 'unapproved' Messages in this.messages.
     */
    getUnapprovedMessages() {
        return this.messages
            .filter((message) => message.status === 'unapproved')
            .reduce((result, message) => {
            result[message.id] = message;
            return result;
        }, {});
    }
    /**
     * Adds a passed Message to this.messages, and calls this.saveMessageList() to save
     * the unapproved Messages from that list to this.messages.
     *
     * @param message - The Message to add to this.messages.
     */
    async addMessage(message) {
        const securedMessage = await this.securityCheck(message);
        this.messages.push(securedMessage);
        this.saveMessageList();
    }
    /**
     * Returns a specified Message.
     *
     * @param messageId - The id of the Message to get.
     * @returns The Message with the id that matches the passed messageId, or undefined
     * if no Message has that id.
     */
    getMessage(messageId) {
        return this.messages.find((message) => message.id === messageId);
    }
    /**
     * Returns all the messages.
     *
     * @returns An array of messages.
     */
    getAllMessages() {
        return this.messages;
    }
    /**
     * Approves a Message. Sets the message status via a call to this.setMessageStatusApproved,
     * and returns a promise with any the message params modified for proper signing.
     *
     * @param messageParams - The messageParams to be used when signing method is called,
     * plus data added by MetaMask.
     * @returns Promise resolving to the messageParams with the metamaskId property removed.
     */
    approveMessage(messageParams) {
        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
        // @ts-ignore
        this.setMessageStatusApproved(messageParams.metamaskId);
        return this.prepMessageForSigning(messageParams);
    }
    /**
     * Sets a Message status to 'approved' via a call to this.setMessageStatus.
     *
     * @param messageId - The id of the Message to approve.
     */
    setMessageStatusApproved(messageId) {
        this.setMessageStatus(messageId, 'approved');
    }
    /**
     * Sets message status to inProgress in order to allow users to use extension
     * while waiting for a custodian signature.
     *
     * @param messageId - The id of the message to set to inProgress
     */
    setMessageStatusInProgress(messageId) {
        this.setMessageStatus(messageId, 'inProgress');
    }
    /**
     * Sets a Message status to 'signed' via a call to this.setMessageStatus and updates
     * that Message in this.messages by adding the raw signature data of the signature
     * request to the Message.
     *
     * @param messageId - The id of the Message to sign.
     * @param rawSig - The raw data of the signature request.
     */
    setMessageStatusSigned(messageId, rawSig) {
        this.setMessageStatusAndResult(messageId, rawSig, 'signed');
    }
    /**
     * Sets the message via a call to this.setResult and updates status of the message.
     *
     * @param messageId - The id of the Message to sign.
     * @param rawSig - The data to update rawSig in the message.
     * @param status - The new message status.
     */
    setMessageStatusAndResult(messageId, rawSig, status) {
        this.setResult(messageId, rawSig);
        this.setMessageStatus(messageId, status);
    }
    /**
     * Sets the message result.
     *
     * @param messageId - The id of the Message to sign.
     * @param result - The data to update result in the message.
     */
    setResult(messageId, result) {
        const message = this.getMessage(messageId);
        /* istanbul ignore if */
        if (!message) {
            return;
        }
        this.updateMessage({
            ...message,
            rawSig: result,
        }, false);
    }
    /**
     * Sets the messsage metadata
     *
     * @param messageId - The id of the Message to update
     * @param metadata - The data with which to replace the metadata property in the message
     */
    setMetadata(messageId, metadata) {
        const message = this.getMessage(messageId);
        if (!message) {
            throw new Error(`${this.name}: Message not found for id: ${messageId}.`);
        }
        this.updateMessage({
            ...message,
            metadata,
        }, false);
    }
    /**
     * Sets a Message status to 'rejected' via a call to this.setMessageStatus.
     *
     * @param messageId - The id of the Message to reject.
     */
    rejectMessage(messageId) {
        this.setMessageStatus(messageId, 'rejected');
    }
    /**
     * Creates a promise which will resolve or reject when the message process is finished.
     *
     * @param messageParamsWithId - The params for the personal_sign call to be made after the message is approved.
     * @param messageName - The name of the message
     * @returns Promise resolving to the raw data of the signature request.
     */
    async waitForFinishStatus(messageParamsWithId, messageName) {
        const { metamaskId: messageId, ...messageParams } = messageParamsWithId;
        return new Promise((resolve, reject) => {
            this.internalEvents.once(`${messageId}:finished`, (data) => {
                switch (data.status) {
                    case 'signed':
                        return resolve(data.rawSig);
                    case 'rejected':
                        return reject(new Error(`MetaMask ${messageName} Signature: User denied message signature.`));
                    case 'errored':
                        return reject(new Error(`MetaMask ${messageName} Signature: ${data.error}`));
                    default:
                        return reject(new Error(`MetaMask ${messageName} Signature: Unknown problem: ${JSON.stringify(messageParams)}`));
                }
            });
        });
    }
}
exports.AbstractMessageManager = AbstractMessageManager;
exports.default = AbstractMessageManager;

      };
    };
  }
  }
}, {package:"@metamask/message-manager",file:"node_modules\\@metamask\\message-manager\\dist\\AbstractMessageManager.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\message-manager\\dist\\DecryptMessageManager.cjs", {"./AbstractMessageManager.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\message-manager\\dist\\AbstractMessageManager.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\message-manager\\dist\\utils.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmessage-manager%5Cdist%5CDecryptMessageManager.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DecryptMessageManager = void 0;
const controller_utils_1 = require("@metamask/controller-utils");
const AbstractMessageManager_1 = require("./AbstractMessageManager.cjs");
const utils_1 = require("./utils.cjs");
const managerName = 'DecryptMessageManager';
/**
 * Controller in charge of managing - storing, adding, removing, updating - DecryptMessages.
 */
class DecryptMessageManager extends AbstractMessageManager_1.AbstractMessageManager {
    constructor({ additionalFinishStatuses, messenger, securityProviderRequest, state, }) {
        super({
            additionalFinishStatuses,
            messenger,
            name: managerName,
            securityProviderRequest,
            state,
        });
    }
    /**
     * Creates a new Message with an 'unapproved' status using the passed messageParams.
     * this.addMessage is called to add the new Message to this.messages, and to save the unapproved Messages.
     *
     * @param messageParams - The params for the personal_sign call to be made after the message is approved.
     * @param req - The original request object possibly containing the origin.
     * @returns Promise resolving to the raw data of the signature request.
     */
    async addUnapprovedMessageAsync(messageParams, req) {
        (0, utils_1.validateDecryptedMessageData)(messageParams);
        const messageId = await this.addUnapprovedMessage(messageParams, req);
        return new Promise((resolve, reject) => {
            this.internalEvents.once(`${messageId}:finished`, (data) => {
                switch (data.status) {
                    case 'decrypted':
                        return resolve(data.rawSig);
                    case 'rejected':
                        return reject(new Error('MetaMask DecryptMessage: User denied message decryption.'));
                    case 'errored':
                        return reject(new Error('MetaMask DecryptMessage: This message cannot be decrypted.'));
                    default:
                        return reject(new Error(`MetaMask DecryptMessage: Unknown problem: ${JSON.stringify(messageParams)}`));
                }
            });
        });
    }
    /**
     * Creates a new Message with an 'unapproved' status using the passed messageParams.
     * this.addMessage is called to add the new Message to this.messages, and to save the
     * unapproved Messages.
     *
     * @param messageParams - The params for the personal_sign call to be made after the message
     * is approved.
     * @param req - The original request object possibly containing the origin.
     * @returns The id of the newly created message.
     */
    async addUnapprovedMessage(messageParams, req) {
        const updatedMessageParams = this.addRequestToMessageParams(messageParams, req);
        messageParams.data = (0, utils_1.normalizeMessageData)(messageParams.data);
        const messageData = this.createUnapprovedMessage(updatedMessageParams, controller_utils_1.ApprovalType.EthDecrypt, req);
        const messageId = messageData.id;
        await this.addMessage(messageData);
        this.messagingSystem.publish(`${managerName}:unapprovedMessage`, {
            ...updatedMessageParams,
            metamaskId: messageId,
        });
        return messageId;
    }
    /**
     * Removes the metamaskId property from passed messageParams and returns a promise which
     * resolves the updated messageParams.
     *
     * @param messageParams - The messageParams to modify.
     * @returns Promise resolving to the messageParams with the metamaskId property removed.
     */
    prepMessageForSigning(messageParams) {
        delete messageParams.metamaskId;
        return Promise.resolve(messageParams);
    }
}
exports.DecryptMessageManager = DecryptMessageManager;

      };
    };
  }
  }
}, {package:"@metamask/message-manager",file:"node_modules\\@metamask\\message-manager\\dist\\DecryptMessageManager.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\message-manager\\dist\\EncryptionPublicKeyManager.cjs", {"./AbstractMessageManager.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\message-manager\\dist\\AbstractMessageManager.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\message-manager\\dist\\utils.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmessage-manager%5Cdist%5CEncryptionPublicKeyManager.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EncryptionPublicKeyManager = void 0;
const controller_utils_1 = require("@metamask/controller-utils");
const AbstractMessageManager_1 = require("./AbstractMessageManager.cjs");
const utils_1 = require("./utils.cjs");
const managerName = 'EncryptionPublicKeyManager';
/**
 * Controller in charge of managing - storing, adding, removing, updating - Messages.
 */
class EncryptionPublicKeyManager extends AbstractMessageManager_1.AbstractMessageManager {
    constructor({ additionalFinishStatuses, messenger, securityProviderRequest, state, }) {
        super({
            additionalFinishStatuses,
            messenger,
            name: managerName,
            securityProviderRequest,
            state,
        });
    }
    /**
     * Creates a new Message with an 'unapproved' status using the passed messageParams.
     * this.addMessage is called to add the new Message to this.messages, and to save the unapproved Messages.
     *
     * @param messageParams - The params for the eth_getEncryptionPublicKey call to be made after the message is approved.
     * @param req - The original request object possibly containing the origin.
     * @returns Promise resolving to the raw data of the request.
     */
    async addUnapprovedMessageAsync(messageParams, req) {
        (0, utils_1.validateEncryptionPublicKeyMessageData)(messageParams);
        const messageId = await this.addUnapprovedMessage(messageParams, req);
        return new Promise((resolve, reject) => {
            this.internalEvents.once(`${messageId}:finished`, (data) => {
                switch (data.status) {
                    case 'received':
                        return resolve(data.rawSig);
                    case 'rejected':
                        return reject(new Error('MetaMask EncryptionPublicKey: User denied message EncryptionPublicKey.'));
                    default:
                        return reject(new Error(`MetaMask EncryptionPublicKey: Unknown problem: ${JSON.stringify(messageParams)}`));
                }
            });
        });
    }
    /**
     * Creates a new Message with an 'unapproved' status using the passed messageParams.
     * this.addMessage is called to add the new Message to this.messages, and to save the
     * unapproved Messages.
     *
     * @param messageParams - The params for the eth_getEncryptionPublicKey call to be made after the message
     * is approved.
     * @param req - The original request object possibly containing the origin.
     * @returns The id of the newly created message.
     */
    async addUnapprovedMessage(messageParams, req) {
        const updatedMessageParams = this.addRequestToMessageParams(messageParams, req);
        const messageData = this.createUnapprovedMessage(updatedMessageParams, controller_utils_1.ApprovalType.EthGetEncryptionPublicKey, req);
        const messageId = messageData.id;
        await this.addMessage(messageData);
        this.messagingSystem.publish(`${this.name}:unapprovedMessage`, {
            ...updatedMessageParams,
            metamaskId: messageId,
        });
        return messageId;
    }
    /**
     * Removes the metamaskId property from passed messageParams and returns a promise which
     * resolves the updated messageParams.
     *
     * @param messageParams - The messageParams to modify.
     * @returns Promise resolving to the messageParams with the metamaskId property removed.
     */
    prepMessageForSigning(messageParams) {
        delete messageParams.metamaskId;
        return Promise.resolve({ from: messageParams.data });
    }
}
exports.EncryptionPublicKeyManager = EncryptionPublicKeyManager;
exports.default = EncryptionPublicKeyManager;

      };
    };
  }
  }
}, {package:"@metamask/message-manager",file:"node_modules\\@metamask\\message-manager\\dist\\EncryptionPublicKeyManager.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\message-manager\\dist\\index.cjs", {"./AbstractMessageManager.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\message-manager\\dist\\AbstractMessageManager.cjs","./DecryptMessageManager.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\message-manager\\dist\\DecryptMessageManager.cjs","./EncryptionPublicKeyManager.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\message-manager\\dist\\EncryptionPublicKeyManager.cjs","./types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\message-manager\\dist\\types.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmessage-manager%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./AbstractMessageManager.cjs"), exports);
__exportStar(require("./EncryptionPublicKeyManager.cjs"), exports);
__exportStar(require("./DecryptMessageManager.cjs"), exports);
__exportStar(require("./types.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/message-manager",file:"node_modules\\@metamask\\message-manager\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\message-manager\\dist\\types.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmessage-manager%5Cdist%5Ctypes.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });

      };
    };
  }
  }
}, {package:"@metamask/message-manager",file:"node_modules\\@metamask\\message-manager\\dist\\types.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\message-manager\\dist\\utils.cjs", {"@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmessage-manager%5Cdist%5Cutils.cjs
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateDecryptedMessageData = exports.validateEncryptionPublicKeyMessageData = exports.normalizeMessageData = void 0;
const controller_utils_1 = require("@metamask/controller-utils");
const utils_1 = require("@metamask/utils");
const hexRe = /^[0-9A-Fa-f]+$/gu;
/**
 * Validates an address string and throws in the event of any validation error.
 *
 * @param address - The address to validate.
 * @param propertyName - The name of the property source to use in the error message.
 */
function validateAddress(address, propertyName) {
    if (!address || typeof address !== 'string' || !(0, controller_utils_1.isValidHexAddress)(address)) {
        throw new Error(`Invalid "${propertyName}" address: ${address} must be a valid string.`);
    }
}
/**
 * A helper function that converts rawmessageData buffer data to a hex, or just returns the data if
 * it is already formatted as a hex.
 *
 * @param data - The buffer data to convert to a hex.
 * @returns A hex string conversion of the buffer data.
 */
function normalizeMessageData(data) {
    try {
        const stripped = (0, utils_1.remove0x)(data);
        if (stripped.match(hexRe)) {
            return (0, utils_1.add0x)(stripped);
        }
    }
    catch (e) {
        /* istanbul ignore next */
    }
    return (0, utils_1.bytesToHex)(Buffer.from(data, 'utf8'));
}
exports.normalizeMessageData = normalizeMessageData;
/**
 * Validates messageData for the eth_getEncryptionPublicKey message and throws in
 * the event of any validation error.
 *
 * @param messageData - address string to validate.
 */
function validateEncryptionPublicKeyMessageData(messageData) {
    const { from } = messageData;
    validateAddress(from, 'from');
}
exports.validateEncryptionPublicKeyMessageData = validateEncryptionPublicKeyMessageData;
/**
 * Validates messageData for the eth_decrypt message and throws in
 * the event of any validation error.
 *
 * @param messageData - address string to validate.
 */
function validateDecryptedMessageData(messageData) {
    const { from } = messageData;
    validateAddress(from, 'from');
}
exports.validateDecryptedMessageData = validateDecryptedMessageData;

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"@metamask/message-manager",file:"node_modules\\@metamask\\message-manager\\dist\\utils.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\MultichainAccountGroup.cjs", {"./logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\logger.cjs","@metamask/account-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-account-service%5Cdist%5CMultichainAccountGroup.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _MultichainAccountGroup_id, _MultichainAccountGroup_wallet, _MultichainAccountGroup_groupIndex, _MultichainAccountGroup_providers, _MultichainAccountGroup_providerToAccounts, _MultichainAccountGroup_accountToProvider, _MultichainAccountGroup_messenger, _MultichainAccountGroup_log, _MultichainAccountGroup_initialized;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultichainAccountGroup = void 0;
const account_api_1 = require("@metamask/account-api");
const account_api_2 = require("@metamask/account-api");
const logger_1 = require("./logger.cjs");
/**
 * A multichain account group that holds multiple accounts.
 */
class MultichainAccountGroup {
    constructor({ groupIndex, wallet, providers, messenger, }) {
        _MultichainAccountGroup_id.set(this, void 0);
        _MultichainAccountGroup_wallet.set(this, void 0);
        _MultichainAccountGroup_groupIndex.set(this, void 0);
        _MultichainAccountGroup_providers.set(this, void 0);
        _MultichainAccountGroup_providerToAccounts.set(this, void 0);
        _MultichainAccountGroup_accountToProvider.set(this, void 0);
        _MultichainAccountGroup_messenger.set(this, void 0);
        _MultichainAccountGroup_log.set(this, void 0);
        // eslint-disable-next-line @typescript-eslint/prefer-readonly
        _MultichainAccountGroup_initialized.set(this, false);
        __classPrivateFieldSet(this, _MultichainAccountGroup_id, (0, account_api_2.toMultichainAccountGroupId)(wallet.id, groupIndex), "f");
        __classPrivateFieldSet(this, _MultichainAccountGroup_groupIndex, groupIndex, "f");
        __classPrivateFieldSet(this, _MultichainAccountGroup_wallet, wallet, "f");
        __classPrivateFieldSet(this, _MultichainAccountGroup_providers, providers, "f");
        __classPrivateFieldSet(this, _MultichainAccountGroup_messenger, messenger, "f");
        __classPrivateFieldSet(this, _MultichainAccountGroup_providerToAccounts, new Map(), "f");
        __classPrivateFieldSet(this, _MultichainAccountGroup_accountToProvider, new Map(), "f");
        __classPrivateFieldSet(this, _MultichainAccountGroup_log, (0, logger_1.createModuleLogger)(logger_1.projectLogger, `[${__classPrivateFieldGet(this, _MultichainAccountGroup_id, "f")}]`), "f");
        this.sync();
        __classPrivateFieldSet(this, _MultichainAccountGroup_initialized, true, "f");
    }
    /**
     * Force multichain account synchronization.
     *
     * This can be used if account providers got new accounts that the multichain
     * account doesn't know about.
     */
    sync() {
        __classPrivateFieldGet(this, _MultichainAccountGroup_log, "f").call(this, 'Synchronizing with account providers...');
        // Clear reverse mapping and re-construct it entirely based on the refreshed
        // list of accounts from each providers.
        __classPrivateFieldGet(this, _MultichainAccountGroup_accountToProvider, "f").clear();
        for (const provider of __classPrivateFieldGet(this, _MultichainAccountGroup_providers, "f")) {
            // Filter account only for that index.
            const accounts = [];
            for (const account of provider.getAccounts()) {
                if (account.options.entropy.id === this.wallet.entropySource &&
                    account.options.entropy.groupIndex === this.groupIndex) {
                    // We only use IDs to always fetch the latest version of accounts.
                    accounts.push(account.id);
                }
            }
            __classPrivateFieldGet(this, _MultichainAccountGroup_providerToAccounts, "f").set(provider, accounts);
            // Reverse-mapping for fast indexing.
            for (const id of accounts) {
                __classPrivateFieldGet(this, _MultichainAccountGroup_accountToProvider, "f").set(id, provider);
            }
        }
        // Emit update event when group is synced (only if initialized)
        if (__classPrivateFieldGet(this, _MultichainAccountGroup_initialized, "f")) {
            __classPrivateFieldGet(this, _MultichainAccountGroup_messenger, "f").publish('MultichainAccountService:multichainAccountGroupUpdated', this);
        }
        __classPrivateFieldGet(this, _MultichainAccountGroup_log, "f").call(this, 'Synchronized');
    }
    /**
     * Gets the multichain account group ID.
     *
     * @returns The multichain account group ID.
     */
    get id() {
        return __classPrivateFieldGet(this, _MultichainAccountGroup_id, "f");
    }
    /**
     * Gets the multichain account group type.
     *
     * @returns The multichain account type.
     */
    get type() {
        return account_api_1.AccountGroupType.MultichainAccount;
    }
    /**
     * Gets the multichain account's wallet reference (parent).
     *
     * @returns The multichain account's wallet.
     */
    get wallet() {
        return __classPrivateFieldGet(this, _MultichainAccountGroup_wallet, "f");
    }
    /**
     * Gets the multichain account group index.
     *
     * @returns The multichain account group index.
     */
    get groupIndex() {
        return __classPrivateFieldGet(this, _MultichainAccountGroup_groupIndex, "f");
    }
    /**
     * Checks if there's any underlying accounts for this multichain accounts.
     *
     * @returns True if there's any underlying accounts, false otherwise.
     */
    hasAccounts() {
        // If there's anything in the reverse-map, it means we have some accounts.
        return __classPrivateFieldGet(this, _MultichainAccountGroup_accountToProvider, "f").size > 0;
    }
    /**
     * Gets the accounts for this multichain account.
     *
     * @returns The accounts.
     */
    getAccounts() {
        const allAccounts = [];
        for (const [provider, accounts] of __classPrivateFieldGet(this, _MultichainAccountGroup_providerToAccounts, "f").entries()) {
            for (const id of accounts) {
                const account = provider.getAccount(id);
                if (account) {
                    // If for some reason we cannot get this account from the provider, it
                    // might means it has been deleted or something, so we just filter it
                    // out.
                    allAccounts.push(account);
                }
            }
        }
        return allAccounts;
    }
    /**
     * Gets the account for a given account ID.
     *
     * @param id - Account ID.
     * @returns The account or undefined if not found.
     */
    getAccount(id) {
        const provider = __classPrivateFieldGet(this, _MultichainAccountGroup_accountToProvider, "f").get(id);
        // If there's nothing in the map, it means we tried to get an account
        // that does not belong to this multichain account.
        if (!provider) {
            return undefined;
        }
        return provider.getAccount(id);
    }
    /**
     * Query an account matching the selector.
     *
     * @param selector - Query selector.
     * @returns The account matching the selector or undefined if not matching.
     * @throws If multiple accounts match the selector.
     */
    get(selector) {
        return (0, account_api_1.selectOne)(this.getAccounts(), selector);
    }
    /**
     * Query accounts matching the selector.
     *
     * @param selector - Query selector.
     * @returns The accounts matching the selector.
     */
    select(selector) {
        return (0, account_api_1.select)(this.getAccounts(), selector);
    }
    /**
     * Align the multichain account group.
     *
     * This will create accounts for providers that don't have any accounts yet.
     */
    async alignAccounts() {
        __classPrivateFieldGet(this, _MultichainAccountGroup_log, "f").call(this, 'Aligning accounts...');
        const results = await Promise.allSettled(__classPrivateFieldGet(this, _MultichainAccountGroup_providers, "f").map(async (provider) => {
            const accounts = __classPrivateFieldGet(this, _MultichainAccountGroup_providerToAccounts, "f").get(provider);
            if (!accounts || accounts.length === 0) {
                __classPrivateFieldGet(this, _MultichainAccountGroup_log, "f").call(this, `Found missing accounts for account provider "${provider.getName()}", creating them now...`);
                const created = await provider.createAccounts({
                    entropySource: this.wallet.entropySource,
                    groupIndex: this.groupIndex,
                });
                __classPrivateFieldGet(this, _MultichainAccountGroup_log, "f").call(this, `Created ${created.length} accounts`);
                return created;
            }
            return Promise.resolve();
        }));
        if (results.some((result) => result.status === 'rejected')) {
            const message = `Failed to fully align multichain account group for entropy ID: ${this.wallet.entropySource} and group index: ${this.groupIndex}, some accounts might be missing`;
            __classPrivateFieldGet(this, _MultichainAccountGroup_log, "f").call(this, `${logger_1.WARNING_PREFIX} ${message}`);
            console.warn(message);
        }
        __classPrivateFieldGet(this, _MultichainAccountGroup_log, "f").call(this, 'Aligned');
    }
}
exports.MultichainAccountGroup = MultichainAccountGroup;
_MultichainAccountGroup_id = new WeakMap(), _MultichainAccountGroup_wallet = new WeakMap(), _MultichainAccountGroup_groupIndex = new WeakMap(), _MultichainAccountGroup_providers = new WeakMap(), _MultichainAccountGroup_providerToAccounts = new WeakMap(), _MultichainAccountGroup_accountToProvider = new WeakMap(), _MultichainAccountGroup_messenger = new WeakMap(), _MultichainAccountGroup_log = new WeakMap(), _MultichainAccountGroup_initialized = new WeakMap();

      };
    };
  }
  }
}, {package:"@metamask/multichain-account-service",file:"node_modules\\@metamask\\multichain-account-service\\dist\\MultichainAccountGroup.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\MultichainAccountService.cjs", {"./MultichainAccountWallet.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\MultichainAccountWallet.cjs","./logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\logger.cjs","./providers/AccountProviderWrapper.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\AccountProviderWrapper.cjs","./providers/EvmAccountProvider.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\EvmAccountProvider.cjs","./providers/SolAccountProvider.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\SolAccountProvider.cjs","@metamask/account-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\index.cjs","@metamask/key-tree":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\index.cjs","@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-account-service%5Cdist%5CMultichainAccountService.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _MultichainAccountService_instances, _MultichainAccountService_messenger, _MultichainAccountService_providers, _MultichainAccountService_wallets, _MultichainAccountService_accountIdToContext, _MultichainAccountService_handleOnAccountAdded, _MultichainAccountService_handleOnAccountRemoved, _MultichainAccountService_getWallet;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultichainAccountService = exports.serviceName = void 0;
const account_api_1 = require("@metamask/account-api");
const key_tree_1 = require("@metamask/key-tree");
const keyring_controller_1 = require("@metamask/keyring-controller");
const utils_1 = require("@metamask/utils");
const logger_1 = require("./logger.cjs");
const MultichainAccountWallet_1 = require("./MultichainAccountWallet.cjs");
const AccountProviderWrapper_1 = require("./providers/AccountProviderWrapper.cjs");
const EvmAccountProvider_1 = require("./providers/EvmAccountProvider.cjs");
const SolAccountProvider_1 = require("./providers/SolAccountProvider.cjs");
exports.serviceName = 'MultichainAccountService';
/**
 * Service to expose multichain accounts capabilities.
 */
class MultichainAccountService {
    /**
     * Constructs a new MultichainAccountService.
     *
     * @param options - The options.
     * @param options.messenger - The messenger suited to this
     * MultichainAccountService.
     * @param options.providers - Optional list of account
     * @param options.providerConfigs - Optional provider configs
     * providers.
     */
    constructor({ messenger, providers = [], providerConfigs, }) {
        _MultichainAccountService_instances.add(this);
        _MultichainAccountService_messenger.set(this, void 0);
        _MultichainAccountService_providers.set(this, void 0);
        _MultichainAccountService_wallets.set(this, void 0);
        _MultichainAccountService_accountIdToContext.set(this, void 0);
        /**
         * The name of the service.
         */
        this.name = exports.serviceName;
        __classPrivateFieldSet(this, _MultichainAccountService_messenger, messenger, "f");
        __classPrivateFieldSet(this, _MultichainAccountService_wallets, new Map(), "f");
        __classPrivateFieldSet(this, _MultichainAccountService_accountIdToContext, new Map(), "f");
        // TODO: Rely on keyring capabilities once the keyring API is used by all keyrings.
        __classPrivateFieldSet(this, _MultichainAccountService_providers, [
            new EvmAccountProvider_1.EvmAccountProvider(__classPrivateFieldGet(this, _MultichainAccountService_messenger, "f"), providerConfigs?.[EvmAccountProvider_1.EvmAccountProvider.NAME]),
            new AccountProviderWrapper_1.AccountProviderWrapper(__classPrivateFieldGet(this, _MultichainAccountService_messenger, "f"), new SolAccountProvider_1.SolAccountProvider(__classPrivateFieldGet(this, _MultichainAccountService_messenger, "f"), providerConfigs?.[SolAccountProvider_1.SolAccountProvider.NAME])),
            // Custom account providers that can be provided by the MetaMask client.
            ...providers,
        ], "f");
        __classPrivateFieldGet(this, _MultichainAccountService_messenger, "f").registerActionHandler('MultichainAccountService:getMultichainAccountGroup', (...args) => this.getMultichainAccountGroup(...args));
        __classPrivateFieldGet(this, _MultichainAccountService_messenger, "f").registerActionHandler('MultichainAccountService:getMultichainAccountGroups', (...args) => this.getMultichainAccountGroups(...args));
        __classPrivateFieldGet(this, _MultichainAccountService_messenger, "f").registerActionHandler('MultichainAccountService:getMultichainAccountWallet', (...args) => this.getMultichainAccountWallet(...args));
        __classPrivateFieldGet(this, _MultichainAccountService_messenger, "f").registerActionHandler('MultichainAccountService:getMultichainAccountWallets', (...args) => this.getMultichainAccountWallets(...args));
        __classPrivateFieldGet(this, _MultichainAccountService_messenger, "f").registerActionHandler('MultichainAccountService:createNextMultichainAccountGroup', (...args) => this.createNextMultichainAccountGroup(...args));
        __classPrivateFieldGet(this, _MultichainAccountService_messenger, "f").registerActionHandler('MultichainAccountService:createMultichainAccountGroup', (...args) => this.createMultichainAccountGroup(...args));
        __classPrivateFieldGet(this, _MultichainAccountService_messenger, "f").registerActionHandler('MultichainAccountService:setBasicFunctionality', (...args) => this.setBasicFunctionality(...args));
        __classPrivateFieldGet(this, _MultichainAccountService_messenger, "f").registerActionHandler('MultichainAccountService:alignWallets', (...args) => this.alignWallets(...args));
        __classPrivateFieldGet(this, _MultichainAccountService_messenger, "f").registerActionHandler('MultichainAccountService:alignWallet', (...args) => this.alignWallet(...args));
        __classPrivateFieldGet(this, _MultichainAccountService_messenger, "f").registerActionHandler('MultichainAccountService:createMultichainAccountWallet', (...args) => this.createMultichainAccountWallet(...args));
        __classPrivateFieldGet(this, _MultichainAccountService_messenger, "f").subscribe('AccountsController:accountAdded', (account) => __classPrivateFieldGet(this, _MultichainAccountService_instances, "m", _MultichainAccountService_handleOnAccountAdded).call(this, account));
        __classPrivateFieldGet(this, _MultichainAccountService_messenger, "f").subscribe('AccountsController:accountRemoved', (id) => __classPrivateFieldGet(this, _MultichainAccountService_instances, "m", _MultichainAccountService_handleOnAccountRemoved).call(this, id));
    }
    /**
     * Initialize the service and constructs the internal reprensentation of
     * multichain accounts and wallets.
     */
    init() {
        (0, logger_1.projectLogger)('Initializing...');
        __classPrivateFieldGet(this, _MultichainAccountService_wallets, "f").clear();
        __classPrivateFieldGet(this, _MultichainAccountService_accountIdToContext, "f").clear();
        // Create initial wallets.
        const { keyrings } = __classPrivateFieldGet(this, _MultichainAccountService_messenger, "f").call('KeyringController:getState');
        for (const keyring of keyrings) {
            if (keyring.type === keyring_controller_1.KeyringTypes.hd) {
                // Only HD keyrings have an entropy source/SRP.
                const entropySource = keyring.metadata.id;
                (0, logger_1.projectLogger)(`Adding new wallet for entropy: "${entropySource}"`);
                // This will automatically "associate" all multichain accounts for that wallet
                // (based on the accounts owned by each account providers).
                const wallet = new MultichainAccountWallet_1.MultichainAccountWallet({
                    entropySource,
                    providers: __classPrivateFieldGet(this, _MultichainAccountService_providers, "f"),
                    messenger: __classPrivateFieldGet(this, _MultichainAccountService_messenger, "f"),
                });
                __classPrivateFieldGet(this, _MultichainAccountService_wallets, "f").set(wallet.id, wallet);
                // Reverse mapping between account ID and their multichain wallet/account:
                for (const group of wallet.getMultichainAccountGroups()) {
                    for (const account of group.getAccounts()) {
                        __classPrivateFieldGet(this, _MultichainAccountService_accountIdToContext, "f").set(account.id, {
                            wallet,
                            group,
                        });
                    }
                }
            }
        }
        (0, logger_1.projectLogger)('Initialized');
    }
    /**
     * Gets the account's context which contains its multichain wallet and
     * multichain account group references.
     *
     * @param id - Account ID.
     * @returns The account context if any, undefined otherwise.
     */
    getAccountContext(id) {
        return __classPrivateFieldGet(this, _MultichainAccountService_accountIdToContext, "f").get(id);
    }
    /**
     * Gets a reference to the multichain account wallet matching this entropy source.
     *
     * @param options - Options.
     * @param options.entropySource - The entropy source of the multichain account.
     * @throws If none multichain account match this entropy.
     * @returns A reference to the multichain account wallet.
     */
    getMultichainAccountWallet({ entropySource, }) {
        return __classPrivateFieldGet(this, _MultichainAccountService_instances, "m", _MultichainAccountService_getWallet).call(this, entropySource);
    }
    /**
     * Gets an array of all multichain account wallets.
     *
     * @returns An array of all multichain account wallets.
     */
    getMultichainAccountWallets() {
        return Array.from(__classPrivateFieldGet(this, _MultichainAccountService_wallets, "f").values());
    }
    /**
     * Creates a new multichain account wallet with the given mnemonic.
     *
     * NOTE: This method should only be called in client code where a mutex lock is acquired.
     * `discoverAndCreateAccounts` should be called after this method to discover and create accounts.
     *
     * @param options - Options.
     * @param options.mnemonic - The mnemonic to use to create the new wallet.
     * @throws If the mnemonic has already been imported.
     * @returns The new multichain account wallet.
     */
    async createMultichainAccountWallet({ mnemonic, }) {
        const existingKeyrings = __classPrivateFieldGet(this, _MultichainAccountService_messenger, "f").call('KeyringController:getKeyringsByType', keyring_controller_1.KeyringTypes.hd);
        const mnemonicAsBytes = (0, key_tree_1.mnemonicPhraseToBytes)(mnemonic);
        const alreadyHasImportedSrp = existingKeyrings.some((keyring) => {
            if (!keyring.mnemonic) {
                return false;
            }
            return (0, utils_1.areUint8ArraysEqual)(keyring.mnemonic, mnemonicAsBytes);
        });
        if (alreadyHasImportedSrp) {
            throw new Error('This Secret Recovery Phrase has already been imported.');
        }
        (0, logger_1.projectLogger)(`Creating new wallet...`);
        const result = await __classPrivateFieldGet(this, _MultichainAccountService_messenger, "f").call('KeyringController:addNewKeyring', keyring_controller_1.KeyringTypes.hd, { mnemonic });
        const wallet = new MultichainAccountWallet_1.MultichainAccountWallet({
            providers: __classPrivateFieldGet(this, _MultichainAccountService_providers, "f"),
            entropySource: result.id,
            messenger: __classPrivateFieldGet(this, _MultichainAccountService_messenger, "f"),
        });
        __classPrivateFieldGet(this, _MultichainAccountService_wallets, "f").set(wallet.id, wallet);
        (0, logger_1.projectLogger)(`Wallet created: [${wallet.id}]`);
        return wallet;
    }
    /**
     * Gets a reference to the multichain account group matching this entropy source
     * and a group index.
     *
     * @param options - Options.
     * @param options.entropySource - The entropy source of the multichain account.
     * @param options.groupIndex - The group index of the multichain account.
     * @throws If none multichain account match this entropy source and group index.
     * @returns A reference to the multichain account.
     */
    getMultichainAccountGroup({ entropySource, groupIndex, }) {
        const multichainAccount = __classPrivateFieldGet(this, _MultichainAccountService_instances, "m", _MultichainAccountService_getWallet).call(this, entropySource).getMultichainAccountGroup(groupIndex);
        if (!multichainAccount) {
            throw new Error(`No multichain account for index: ${groupIndex}`);
        }
        return multichainAccount;
    }
    /**
     * Gets all multichain account groups for a given entropy source.
     *
     * @param options - Options.
     * @param options.entropySource - The entropy source to query.
     * @throws If no multichain accounts match this entropy source.
     * @returns A list of all multichain accounts.
     */
    getMultichainAccountGroups({ entropySource, }) {
        return __classPrivateFieldGet(this, _MultichainAccountService_instances, "m", _MultichainAccountService_getWallet).call(this, entropySource).getMultichainAccountGroups();
    }
    /**
     * Creates the next multichain account group.
     *
     * @param options - Options.
     * @param options.entropySource - The wallet's entropy source.
     * @returns The next multichain account group.
     */
    async createNextMultichainAccountGroup({ entropySource, }) {
        return await __classPrivateFieldGet(this, _MultichainAccountService_instances, "m", _MultichainAccountService_getWallet).call(this, entropySource).createNextMultichainAccountGroup();
    }
    /**
     * Creates a multichain account group.
     *
     * @param options - Options.
     * @param options.groupIndex - The group index to use.
     * @param options.entropySource - The wallet's entropy source.
     * @returns The multichain account group for this group index.
     */
    async createMultichainAccountGroup({ groupIndex, entropySource, }) {
        return await __classPrivateFieldGet(this, _MultichainAccountService_instances, "m", _MultichainAccountService_getWallet).call(this, entropySource).createMultichainAccountGroup(groupIndex);
    }
    /**
     * Set basic functionality state and trigger alignment if enabled.
     * When basic functionality is disabled, snap-based providers are disabled.
     * When enabled, all snap providers are enabled and wallet alignment is triggered.
     * EVM providers are never disabled as they're required for basic wallet functionality.
     *
     * @param enabled - Whether basic functionality is enabled.
     */
    async setBasicFunctionality(enabled) {
        (0, logger_1.projectLogger)(`Turning basic functionality: ${enabled ? 'ON' : 'OFF'}`);
        // Loop through providers and enable/disable only wrapped ones when basic functionality changes
        for (const provider of __classPrivateFieldGet(this, _MultichainAccountService_providers, "f")) {
            if ((0, AccountProviderWrapper_1.isAccountProviderWrapper)(provider)) {
                (0, logger_1.projectLogger)(`${enabled ? 'Enabling' : 'Disabling'} account provider: "${provider.getName()}"`);
                provider.setEnabled(enabled);
            }
            // Regular providers (like EVM) are never disabled for basic functionality
        }
        // Trigger alignment only when basic functionality is enabled
        if (enabled) {
            await this.alignWallets();
        }
    }
    /**
     * Align all multichain account wallets.
     */
    async alignWallets() {
        (0, logger_1.projectLogger)(`Triggering alignment on all wallets...`);
        const wallets = this.getMultichainAccountWallets();
        await Promise.all(wallets.map((w) => w.alignAccounts()));
        (0, logger_1.projectLogger)(`Wallets aligned`);
    }
    /**
     * Align a specific multichain account wallet.
     *
     * @param entropySource - The entropy source of the multichain account wallet.
     */
    async alignWallet(entropySource) {
        const wallet = this.getMultichainAccountWallet({ entropySource });
        (0, logger_1.projectLogger)(`Triggering alignment for wallet: [${wallet.id}]`);
        await wallet.alignAccounts();
        (0, logger_1.projectLogger)(`Wallet [${wallet.id}] aligned`);
    }
}
exports.MultichainAccountService = MultichainAccountService;
_MultichainAccountService_messenger = new WeakMap(), _MultichainAccountService_providers = new WeakMap(), _MultichainAccountService_wallets = new WeakMap(), _MultichainAccountService_accountIdToContext = new WeakMap(), _MultichainAccountService_instances = new WeakSet(), _MultichainAccountService_handleOnAccountAdded = function _MultichainAccountService_handleOnAccountAdded(account) {
    // We completely omit non-BIP-44 accounts!
    if (!(0, account_api_1.isBip44Account)(account)) {
        return;
    }
    let sync = true;
    let wallet = __classPrivateFieldGet(this, _MultichainAccountService_wallets, "f").get((0, account_api_1.toMultichainAccountWalletId)(account.options.entropy.id));
    if (!wallet) {
        (0, logger_1.projectLogger)(`Adding new wallet for entropy: "${account.options.entropy.id}" (for account: "${account.id}")`);
        // That's a new wallet.
        wallet = new MultichainAccountWallet_1.MultichainAccountWallet({
            entropySource: account.options.entropy.id,
            providers: __classPrivateFieldGet(this, _MultichainAccountService_providers, "f"),
            messenger: __classPrivateFieldGet(this, _MultichainAccountService_messenger, "f"),
        });
        __classPrivateFieldGet(this, _MultichainAccountService_wallets, "f").set(wallet.id, wallet);
        // If that's a new wallet wallet. There's nothing to "force-sync".
        sync = false;
    }
    let group = wallet.getMultichainAccountGroup(account.options.entropy.groupIndex);
    if (!group) {
        // This new account is a new multichain account, let the wallet know
        // it has to re-sync with its providers.
        if (sync) {
            wallet.sync();
        }
        group = wallet.getMultichainAccountGroup(account.options.entropy.groupIndex);
        // If that's a new multichain account. There's nothing to "force-sync".
        sync = false;
    }
    // We have to check against `undefined` in case `getMultichainAccount` is
    // not able to find this multichain account (which should not be possible...)
    if (group) {
        if (sync) {
            group.sync();
        }
        // Same here, this account should have been already grouped in that
        // multichain account.
        __classPrivateFieldGet(this, _MultichainAccountService_accountIdToContext, "f").set(account.id, {
            wallet,
            group,
        });
    }
}, _MultichainAccountService_handleOnAccountRemoved = function _MultichainAccountService_handleOnAccountRemoved(id) {
    // Force sync of the appropriate wallet if an account got removed.
    const found = __classPrivateFieldGet(this, _MultichainAccountService_accountIdToContext, "f").get(id);
    if (found) {
        const { wallet } = found;
        (0, logger_1.projectLogger)(`Re-synchronize wallet [${wallet.id}] since account "${id}" got removed`);
        wallet.sync();
    }
    // Safe to call delete even if the `id` was not referencing a BIP-44 account.
    __classPrivateFieldGet(this, _MultichainAccountService_accountIdToContext, "f").delete(id);
}, _MultichainAccountService_getWallet = function _MultichainAccountService_getWallet(entropySource) {
    const wallet = __classPrivateFieldGet(this, _MultichainAccountService_wallets, "f").get((0, account_api_1.toMultichainAccountWalletId)(entropySource));
    if (!wallet) {
        throw new Error('Unknown wallet, no wallet matching this entropy source');
    }
    return wallet;
};

      };
    };
  }
  }
}, {package:"@metamask/multichain-account-service",file:"node_modules\\@metamask\\multichain-account-service\\dist\\MultichainAccountService.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\MultichainAccountWallet.cjs", {"./MultichainAccountGroup.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\MultichainAccountGroup.cjs","./logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\logger.cjs","./providers/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\index.cjs","@metamask/account-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","async-mutex":"D:\\code\\v\\metamask-extension\\node_modules\\async-mutex\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-account-service%5Cdist%5CMultichainAccountWallet.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _MultichainAccountWallet_instances, _MultichainAccountWallet_lock, _MultichainAccountWallet_id, _MultichainAccountWallet_providers, _MultichainAccountWallet_entropySource, _MultichainAccountWallet_accountGroups, _MultichainAccountWallet_messenger, _MultichainAccountWallet_log, _MultichainAccountWallet_initialized, _MultichainAccountWallet_status, _MultichainAccountWallet_withLock, _MultichainAccountWallet_alignAccounts;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultichainAccountWallet = void 0;
const account_api_1 = require("@metamask/account-api");
const utils_1 = require("@metamask/utils");
const async_mutex_1 = require("async-mutex");
const logger_1 = require("./logger.cjs");
const MultichainAccountGroup_1 = require("./MultichainAccountGroup.cjs");
const providers_1 = require("./providers/index.cjs");
/**
 * A multichain account wallet that holds multiple multichain accounts (one multichain account per
 * group index).
 */
class MultichainAccountWallet {
    constructor({ providers, entropySource, messenger, }) {
        _MultichainAccountWallet_instances.add(this);
        _MultichainAccountWallet_lock.set(this, new async_mutex_1.Mutex());
        _MultichainAccountWallet_id.set(this, void 0);
        _MultichainAccountWallet_providers.set(this, void 0);
        _MultichainAccountWallet_entropySource.set(this, void 0);
        _MultichainAccountWallet_accountGroups.set(this, void 0);
        _MultichainAccountWallet_messenger.set(this, void 0);
        _MultichainAccountWallet_log.set(this, void 0);
        // eslint-disable-next-line @typescript-eslint/prefer-readonly
        _MultichainAccountWallet_initialized.set(this, false);
        _MultichainAccountWallet_status.set(this, void 0);
        __classPrivateFieldSet(this, _MultichainAccountWallet_id, (0, account_api_1.toMultichainAccountWalletId)(entropySource), "f");
        __classPrivateFieldSet(this, _MultichainAccountWallet_providers, providers, "f");
        __classPrivateFieldSet(this, _MultichainAccountWallet_entropySource, entropySource, "f");
        __classPrivateFieldSet(this, _MultichainAccountWallet_messenger, messenger, "f");
        __classPrivateFieldSet(this, _MultichainAccountWallet_accountGroups, new Map(), "f");
        __classPrivateFieldSet(this, _MultichainAccountWallet_log, (0, logger_1.createModuleLogger)(logger_1.projectLogger, `[${__classPrivateFieldGet(this, _MultichainAccountWallet_id, "f")}]`), "f");
        // Initial synchronization (don't emit events during initialization).
        __classPrivateFieldSet(this, _MultichainAccountWallet_status, 'uninitialized', "f");
        this.sync();
        __classPrivateFieldSet(this, _MultichainAccountWallet_initialized, true, "f");
        __classPrivateFieldSet(this, _MultichainAccountWallet_status, 'ready', "f");
    }
    /**
     * Force wallet synchronization.
     *
     * This can be used if account providers got new accounts that the wallet
     * doesn't know about.
     */
    sync() {
        __classPrivateFieldGet(this, _MultichainAccountWallet_log, "f").call(this, 'Synchronizing with account providers...');
        for (const provider of __classPrivateFieldGet(this, _MultichainAccountWallet_providers, "f")) {
            for (const account of provider.getAccounts()) {
                const { entropy } = account.options;
                // Filter for this wallet only.
                if (entropy.id !== this.entropySource) {
                    continue;
                }
                // This multichain account might exists already.
                let multichainAccount = __classPrivateFieldGet(this, _MultichainAccountWallet_accountGroups, "f").get(entropy.groupIndex);
                if (!multichainAccount) {
                    multichainAccount = new MultichainAccountGroup_1.MultichainAccountGroup({
                        groupIndex: entropy.groupIndex,
                        wallet: this,
                        providers: __classPrivateFieldGet(this, _MultichainAccountWallet_providers, "f"),
                        messenger: __classPrivateFieldGet(this, _MultichainAccountWallet_messenger, "f"),
                    });
                    // This existing multichain account group might differ from the
                    // `createMultichainAccountGroup` behavior. When creating a new
                    // group, we expect the providers to all succeed. But here, we're
                    // just fetching the account lists from them, so this group might
                    // not be "aligned" yet (e.g having a missing Solana account).
                    //
                    // Since "aligning" is an async operation, it would have to be run
                    // after the first-sync.
                    // TODO: Implement align mechanism to create "missing" accounts.
                    __classPrivateFieldGet(this, _MultichainAccountWallet_log, "f").call(this, `Found a new group: [${multichainAccount.id}]`);
                    __classPrivateFieldGet(this, _MultichainAccountWallet_accountGroups, "f").set(entropy.groupIndex, multichainAccount);
                }
            }
        }
        // Now force-sync all remaining multichain accounts.
        for (const [groupIndex, multichainAccount,] of __classPrivateFieldGet(this, _MultichainAccountWallet_accountGroups, "f").entries()) {
            multichainAccount.sync();
            // Clean up old multichain accounts.
            if (!multichainAccount.hasAccounts()) {
                __classPrivateFieldGet(this, _MultichainAccountWallet_log, "f").call(this, `Deleting group: [${multichainAccount.id}]`);
                __classPrivateFieldGet(this, _MultichainAccountWallet_accountGroups, "f").delete(groupIndex);
            }
        }
        __classPrivateFieldGet(this, _MultichainAccountWallet_log, "f").call(this, 'Synchronized');
    }
    /**
     * Gets the multichain account wallet ID.
     *
     * @returns The multichain account wallet ID.
     */
    get id() {
        return __classPrivateFieldGet(this, _MultichainAccountWallet_id, "f");
    }
    /**
     * Gets the multichain account wallet type, which is always {@link AccountWalletType.Entropy}.
     *
     * @returns The multichain account wallet type.
     */
    get type() {
        return account_api_1.AccountWalletType.Entropy;
    }
    /**
     * Gets the multichain account wallet entropy source.
     *
     * @returns The multichain account wallet entropy source.
     */
    get entropySource() {
        return __classPrivateFieldGet(this, _MultichainAccountWallet_entropySource, "f");
    }
    /**
     * Gets the multichain account wallet current status.
     *
     * @returns The multichain account wallet current status.
     */
    get status() {
        return __classPrivateFieldGet(this, _MultichainAccountWallet_status, "f");
    }
    /**
     * Gets multichain account for a given ID.
     * The default group ID will default to the multichain account with index 0.
     *
     * @param id - Account group ID.
     * @returns Account group.
     */
    getAccountGroup(id) {
        // We consider the "default case" to be mapped to index 0.
        if (id === (0, account_api_1.toDefaultAccountGroupId)(this.id)) {
            return __classPrivateFieldGet(this, _MultichainAccountWallet_accountGroups, "f").get(0);
        }
        // If it is not a valid ID, we cannot extract the group index
        // from it, so we fail fast.
        if (!(0, account_api_1.isMultichainAccountGroupId)(id)) {
            return undefined;
        }
        const groupIndex = (0, account_api_1.getGroupIndexFromMultichainAccountGroupId)(id);
        return __classPrivateFieldGet(this, _MultichainAccountWallet_accountGroups, "f").get(groupIndex);
    }
    /**
     * Gets all multichain accounts. Similar to {@link MultichainAccountWallet.getMultichainAccountGroups}.
     *
     * @returns The multichain accounts.
     */
    getAccountGroups() {
        return this.getMultichainAccountGroups();
    }
    /**
     * Gets multichain account group for a given index.
     *
     * @param groupIndex - Multichain account index.
     * @returns The multichain account associated with the given index.
     */
    getMultichainAccountGroup(groupIndex) {
        return __classPrivateFieldGet(this, _MultichainAccountWallet_accountGroups, "f").get(groupIndex);
    }
    /**
     * Gets all multichain account groups.
     *
     * @returns The multichain accounts.
     */
    getMultichainAccountGroups() {
        return Array.from(__classPrivateFieldGet(this, _MultichainAccountWallet_accountGroups, "f").values()); // TODO: Prevent copy here.
    }
    /**
     * Gets next group index for this wallet.
     *
     * @returns The next group index of this wallet.
     */
    getNextGroupIndex() {
        // We do not check for gaps.
        return (Math.max(-1, // So it will default to 0 if no groups.
        ...__classPrivateFieldGet(this, _MultichainAccountWallet_accountGroups, "f").keys()) + 1);
    }
    /**
     * Creates a multichain account group for a given group index.
     *
     * NOTE: This operation WILL lock the wallet's mutex.
     *
     * @param groupIndex - The group index to use.
     * @param options - Options to configure the account creation.
     * @param options.waitForAllProvidersToFinishCreatingAccounts - Whether to wait for all
     * account providers to finish creating their accounts before returning. If `false`, only
     * the EVM provider will be awaited, while all other providers will create their accounts
     * in the background. Defaults to `false`.
     * @throws If any of the account providers fails to create their accounts and
     * the `waitForAllProvidersToFinishCreatingAccounts` option is set to `true`. If `false`,
     * errors from non-EVM providers will be logged but ignored, and only errors from the
     * EVM provider will be thrown.
     * @returns The multichain account group for this group index.
     */
    async createMultichainAccountGroup(groupIndex, options = { waitForAllProvidersToFinishCreatingAccounts: false }) {
        return await __classPrivateFieldGet(this, _MultichainAccountWallet_instances, "m", _MultichainAccountWallet_withLock).call(this, 'in-progress:create-accounts', async () => {
            const nextGroupIndex = this.getNextGroupIndex();
            if (groupIndex > nextGroupIndex) {
                throw new Error(`You cannot use a group index that is higher than the next available one: expected <=${nextGroupIndex}, got ${groupIndex}`);
            }
            let group = this.getMultichainAccountGroup(groupIndex);
            if (group) {
                // If the group already exists, we just `sync` it and returns the same
                // reference.
                group.sync();
                __classPrivateFieldGet(this, _MultichainAccountWallet_log, "f").call(this, `Trying to re-create existing group: [${group.id}] (idempotent)`);
                return group;
            }
            __classPrivateFieldGet(this, _MultichainAccountWallet_log, "f").call(this, `Creating new group for index ${groupIndex}...`);
            if (options?.waitForAllProvidersToFinishCreatingAccounts) {
                // Create account with all providers and await them.
                const results = await Promise.allSettled(__classPrivateFieldGet(this, _MultichainAccountWallet_providers, "f").map((provider) => provider.createAccounts({
                    entropySource: __classPrivateFieldGet(this, _MultichainAccountWallet_entropySource, "f"),
                    groupIndex,
                })));
                // If any of the provider failed to create their accounts, then we consider the
                // multichain account group to have failed too.
                if (results.some((result) => result.status === 'rejected')) {
                    // NOTE: Some accounts might still have been created on other account providers. We
                    // don't rollback them.
                    const error = `Unable to create multichain account group for index: ${groupIndex}`;
                    let message = `${error}:`;
                    for (const result of results) {
                        if (result.status === 'rejected') {
                            message += `\n- ${result.reason}`;
                        }
                    }
                    __classPrivateFieldGet(this, _MultichainAccountWallet_log, "f").call(this, `${logger_1.WARNING_PREFIX} ${message}`);
                    console.warn(message);
                    throw new Error(error);
                }
            }
            else {
                // Extract the EVM provider from the list of providers.
                // We will only await the EVM provider to create its accounts, while
                // all other providers will be started in the background.
                const [evmProvider, ...otherProviders] = __classPrivateFieldGet(this, _MultichainAccountWallet_providers, "f");
                (0, utils_1.assert)(evmProvider instanceof providers_1.EvmAccountProvider, 'EVM account provider must be first');
                // Create account with the EVM provider first and await it.
                // If it fails, we don't start creating accounts with other providers.
                try {
                    await evmProvider.createAccounts({
                        entropySource: __classPrivateFieldGet(this, _MultichainAccountWallet_entropySource, "f"),
                        groupIndex,
                    });
                }
                catch (error) {
                    const errorMessage = `Unable to create multichain account group for index: ${groupIndex} with provider "${evmProvider.getName()}". Error: ${error.message}`;
                    __classPrivateFieldGet(this, _MultichainAccountWallet_log, "f").call(this, `${logger_1.ERROR_PREFIX} ${errorMessage}:`, error);
                    throw new Error(errorMessage);
                }
                // Create account with other providers in the background
                otherProviders.forEach((provider) => {
                    provider
                        .createAccounts({
                        entropySource: __classPrivateFieldGet(this, _MultichainAccountWallet_entropySource, "f"),
                        groupIndex,
                    })
                        .catch((error) => {
                        // Log errors from background providers but don't fail the operation
                        const errorMessage = `Could not to create account with provider "${provider.getName()}" for multichain account group index: ${groupIndex}`;
                        __classPrivateFieldGet(this, _MultichainAccountWallet_log, "f").call(this, `${logger_1.WARNING_PREFIX} ${errorMessage}:`, error);
                    });
                });
            }
            // --------------------------------------------------------------------------------
            // READ THIS CAREFULLY:
            //
            // Since we're not "fully supporting multichain" for now, we still rely on single
            // :accountCreated events to sync multichain account groups and wallets. Which means
            // that even if of the provider fails, some accounts will still be created on some
            // other providers and will become "available" on the `AccountsController`, like:
            //
            // 1. Creating a multichain account group for index 1
            // 2. EvmAccountProvider.createAccounts returns the EVM account for index 1
            //   * AccountsController WILL fire :accountCreated for this account
            //   * This account WILL BE "available" on the AccountsController state
            // 3. SolAccountProvider.createAccounts fails to create a Solana account for index 1
            //   * AccountsController WON't fire :accountCreated for this account
            //   * This account WON'T be "available" on the Account
            // 4. MultichainAccountService will receive a :accountCreated for the EVM account from
            // step 2 and will create a new multichain account group for index 1, but it won't
            // receive any event for the Solana account of this group. Thus, this group won't be
            // "aligned" (missing "blockchain account" on this group).
            //
            // --------------------------------------------------------------------------------
            // Because of the :accountAdded automatic sync, we might already have created the
            // group, so we first try to get it.
            group = this.getMultichainAccountGroup(groupIndex);
            if (!group) {
                // If for some reason it's still not created, we're creating it explicitly now:
                group = new MultichainAccountGroup_1.MultichainAccountGroup({
                    wallet: this,
                    providers: __classPrivateFieldGet(this, _MultichainAccountWallet_providers, "f"),
                    groupIndex,
                    messenger: __classPrivateFieldGet(this, _MultichainAccountWallet_messenger, "f"),
                });
            }
            // Register the account to our internal map.
            __classPrivateFieldGet(this, _MultichainAccountWallet_accountGroups, "f").set(groupIndex, group); // `group` cannot be undefined here.
            __classPrivateFieldGet(this, _MultichainAccountWallet_log, "f").call(this, `New group created: [${group.id}]`);
            if (__classPrivateFieldGet(this, _MultichainAccountWallet_initialized, "f")) {
                __classPrivateFieldGet(this, _MultichainAccountWallet_messenger, "f").publish('MultichainAccountService:multichainAccountGroupCreated', group);
            }
            return group;
        });
    }
    /**
     * Creates the next multichain account group.
     *
     * @throws If any of the account providers fails to create their accounts.
     * @returns The multichain account group for the next group index available.
     */
    async createNextMultichainAccountGroup() {
        return this.createMultichainAccountGroup(this.getNextGroupIndex(), {
            waitForAllProvidersToFinishCreatingAccounts: true,
        });
    }
    /**
     * Align all accounts from each existing multichain account groups.
     *
     * NOTE: This operation WILL lock the wallet's mutex.
     */
    async alignAccounts() {
        await __classPrivateFieldGet(this, _MultichainAccountWallet_instances, "m", _MultichainAccountWallet_withLock).call(this, 'in-progress:alignment', async () => {
            await __classPrivateFieldGet(this, _MultichainAccountWallet_instances, "m", _MultichainAccountWallet_alignAccounts).call(this);
        });
    }
    /**
     * Align a specific multichain account group.
     *
     * NOTE: This operation WILL lock the wallet's mutex.
     *
     * @param groupIndex - The group index to align.
     */
    async alignAccountsOf(groupIndex) {
        await __classPrivateFieldGet(this, _MultichainAccountWallet_instances, "m", _MultichainAccountWallet_withLock).call(this, 'in-progress:alignment', async () => {
            const group = this.getMultichainAccountGroup(groupIndex);
            if (group) {
                await group.alignAccounts();
            }
        });
    }
    /**
     * Discover and create accounts for all providers.
     *
     * NOTE: This operation WILL lock the wallet's mutex.
     *
     * @returns The discovered accounts for each provider.
     */
    async discoverAccounts() {
        return __classPrivateFieldGet(this, _MultichainAccountWallet_instances, "m", _MultichainAccountWallet_withLock).call(this, 'in-progress:discovery', async () => {
            // Start with the next available group index (so we can resume the discovery
            // from there).
            let maxGroupIndex = this.getNextGroupIndex();
            // One serialized loop per provider; all run concurrently
            const runProviderDiscovery = async (context) => {
                const providerName = context.provider.getName();
                const message = (stepName, groupIndex) => `[${providerName}] Discovery ${stepName} for group index: ${groupIndex}`;
                while (!context.stopped) {
                    // Fast‑forward to current high‑water mark
                    const targetGroupIndex = Math.max(context.groupIndex, maxGroupIndex);
                    (0, logger_1.projectLogger)(message('started', targetGroupIndex));
                    let accounts = [];
                    try {
                        accounts = await context.provider.discoverAccounts({
                            entropySource: __classPrivateFieldGet(this, _MultichainAccountWallet_entropySource, "f"),
                            groupIndex: targetGroupIndex,
                        });
                    }
                    catch (error) {
                        context.stopped = true;
                        console.error(error);
                        (0, logger_1.projectLogger)(message(`failed (with: "${error.message}")`, targetGroupIndex), error);
                        break;
                    }
                    if (!accounts.length) {
                        (0, logger_1.projectLogger)(message('stopped (no accounts got discovered)', targetGroupIndex));
                        context.stopped = true;
                        break;
                    }
                    (0, logger_1.projectLogger)(message('**succeeded**', targetGroupIndex));
                    context.accounts = context.accounts.concat(accounts);
                    const nextGroupIndex = targetGroupIndex + 1;
                    context.groupIndex = nextGroupIndex;
                    if (nextGroupIndex > maxGroupIndex) {
                        maxGroupIndex = nextGroupIndex;
                    }
                }
            };
            const providerContexts = __classPrivateFieldGet(this, _MultichainAccountWallet_providers, "f").map((provider) => ({
                provider,
                stopped: false,
                groupIndex: maxGroupIndex,
                accounts: [],
            }));
            // Start discovery for each providers.
            await Promise.all(providerContexts.map(runProviderDiscovery));
            // Sync the wallet after discovery to ensure that the newly added accounts are added into their groups.
            // We can potentially remove this if we know that this race condition is not an issue in practice.
            this.sync();
            // Align missing accounts from group. This is required to create missing account from non-discovered
            // indexes for some providers.
            await __classPrivateFieldGet(this, _MultichainAccountWallet_instances, "m", _MultichainAccountWallet_alignAccounts).call(this);
            return providerContexts.flatMap((context) => context.accounts);
        });
    }
}
exports.MultichainAccountWallet = MultichainAccountWallet;
_MultichainAccountWallet_lock = new WeakMap(), _MultichainAccountWallet_id = new WeakMap(), _MultichainAccountWallet_providers = new WeakMap(), _MultichainAccountWallet_entropySource = new WeakMap(), _MultichainAccountWallet_accountGroups = new WeakMap(), _MultichainAccountWallet_messenger = new WeakMap(), _MultichainAccountWallet_log = new WeakMap(), _MultichainAccountWallet_initialized = new WeakMap(), _MultichainAccountWallet_status = new WeakMap(), _MultichainAccountWallet_instances = new WeakSet(), _MultichainAccountWallet_withLock = 
/**
 * Set the wallet status and run the associated operation callback.
 *
 * @param status - Wallet status associated with this operation.
 * @param operation - Operation to run.
 * @returns The operation's result.
 * @throws {Error} If the wallet is already running a mutable operation.
 */
async function _MultichainAccountWallet_withLock(status, operation) {
    const release = await __classPrivateFieldGet(this, _MultichainAccountWallet_lock, "f").acquire();
    try {
        __classPrivateFieldGet(this, _MultichainAccountWallet_log, "f").call(this, `Locking wallet with status "${status}"...`);
        __classPrivateFieldSet(this, _MultichainAccountWallet_status, status, "f");
        __classPrivateFieldGet(this, _MultichainAccountWallet_messenger, "f").publish('MultichainAccountService:walletStatusChange', this.id, __classPrivateFieldGet(this, _MultichainAccountWallet_status, "f"));
        return await operation();
    }
    finally {
        __classPrivateFieldSet(this, _MultichainAccountWallet_status, 'ready', "f");
        __classPrivateFieldGet(this, _MultichainAccountWallet_messenger, "f").publish('MultichainAccountService:walletStatusChange', this.id, __classPrivateFieldGet(this, _MultichainAccountWallet_status, "f"));
        release();
        __classPrivateFieldGet(this, _MultichainAccountWallet_log, "f").call(this, `Releasing wallet lock (was "${status}")`);
    }
}, _MultichainAccountWallet_alignAccounts = 
/**
 * Align all multichain account groups.
 *
 * NOTE: This operation WILL NOT lock the wallet's mutex.
 */
async function _MultichainAccountWallet_alignAccounts() {
    const groups = this.getMultichainAccountGroups();
    await Promise.all(groups.map((group) => group.alignAccounts()));
};

      };
    };
  }
  }
}, {package:"@metamask/multichain-account-service",file:"node_modules\\@metamask\\multichain-account-service\\dist\\MultichainAccountWallet.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\index.cjs", {"./MultichainAccountGroup.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\MultichainAccountGroup.cjs","./MultichainAccountService.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\MultichainAccountService.cjs","./MultichainAccountWallet.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\MultichainAccountWallet.cjs","./providers/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-account-service%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultichainAccountService = exports.MultichainAccountGroup = exports.MultichainAccountWallet = exports.TrxAccountProvider = exports.TRX_ACCOUNT_PROVIDER_NAME = exports.BtcAccountProvider = exports.BTC_ACCOUNT_PROVIDER_NAME = exports.SolAccountProvider = exports.SOL_ACCOUNT_PROVIDER_NAME = exports.EvmAccountProvider = exports.EVM_ACCOUNT_PROVIDER_NAME = exports.TimeoutError = exports.SnapAccountProvider = exports.BaseBip44AccountProvider = exports.AccountProviderWrapper = void 0;
var providers_1 = require("./providers/index.cjs");
Object.defineProperty(exports, "AccountProviderWrapper", { enumerable: true, get: function () { return providers_1.AccountProviderWrapper; } });
Object.defineProperty(exports, "BaseBip44AccountProvider", { enumerable: true, get: function () { return providers_1.BaseBip44AccountProvider; } });
Object.defineProperty(exports, "SnapAccountProvider", { enumerable: true, get: function () { return providers_1.SnapAccountProvider; } });
Object.defineProperty(exports, "TimeoutError", { enumerable: true, get: function () { return providers_1.TimeoutError; } });
Object.defineProperty(exports, "EVM_ACCOUNT_PROVIDER_NAME", { enumerable: true, get: function () { return providers_1.EVM_ACCOUNT_PROVIDER_NAME; } });
Object.defineProperty(exports, "EvmAccountProvider", { enumerable: true, get: function () { return providers_1.EvmAccountProvider; } });
Object.defineProperty(exports, "SOL_ACCOUNT_PROVIDER_NAME", { enumerable: true, get: function () { return providers_1.SOL_ACCOUNT_PROVIDER_NAME; } });
Object.defineProperty(exports, "SolAccountProvider", { enumerable: true, get: function () { return providers_1.SolAccountProvider; } });
Object.defineProperty(exports, "BTC_ACCOUNT_PROVIDER_NAME", { enumerable: true, get: function () { return providers_1.BTC_ACCOUNT_PROVIDER_NAME; } });
Object.defineProperty(exports, "BtcAccountProvider", { enumerable: true, get: function () { return providers_1.BtcAccountProvider; } });
Object.defineProperty(exports, "TRX_ACCOUNT_PROVIDER_NAME", { enumerable: true, get: function () { return providers_1.TRX_ACCOUNT_PROVIDER_NAME; } });
Object.defineProperty(exports, "TrxAccountProvider", { enumerable: true, get: function () { return providers_1.TrxAccountProvider; } });
var MultichainAccountWallet_1 = require("./MultichainAccountWallet.cjs");
Object.defineProperty(exports, "MultichainAccountWallet", { enumerable: true, get: function () { return MultichainAccountWallet_1.MultichainAccountWallet; } });
var MultichainAccountGroup_1 = require("./MultichainAccountGroup.cjs");
Object.defineProperty(exports, "MultichainAccountGroup", { enumerable: true, get: function () { return MultichainAccountGroup_1.MultichainAccountGroup; } });
var MultichainAccountService_1 = require("./MultichainAccountService.cjs");
Object.defineProperty(exports, "MultichainAccountService", { enumerable: true, get: function () { return MultichainAccountService_1.MultichainAccountService; } });

      };
    };
  }
  }
}, {package:"@metamask/multichain-account-service",file:"node_modules\\@metamask\\multichain-account-service\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\logger.cjs", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-account-service%5Cdist%5Clogger.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ERROR_PREFIX = exports.WARNING_PREFIX = exports.createModuleLogger = exports.projectLogger = void 0;
const utils_1 = require("@metamask/utils");
Object.defineProperty(exports, "createModuleLogger", { enumerable: true, get: function () { return utils_1.createModuleLogger; } });
exports.projectLogger = (0, utils_1.createProjectLogger)('multichain-account-service');
exports.WARNING_PREFIX = 'WARNING --';
exports.ERROR_PREFIX = 'ERROR --';

      };
    };
  }
  }
}, {package:"@metamask/multichain-account-service",file:"node_modules\\@metamask\\multichain-account-service\\dist\\logger.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\AccountProviderWrapper.cjs", {"./BaseBip44AccountProvider.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\BaseBip44AccountProvider.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-account-service%5Cdist%5Cproviders%5CAccountProviderWrapper.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isAccountProviderWrapper = exports.AccountProviderWrapper = void 0;
const BaseBip44AccountProvider_1 = require("./BaseBip44AccountProvider.cjs");
/**
 * A simple wrapper that adds disable functionality to any BaseBip44AccountProvider.
 * When disabled, the provider will not create new accounts and return empty results.
 */
class AccountProviderWrapper extends BaseBip44AccountProvider_1.BaseBip44AccountProvider {
    constructor(messenger, provider) {
        super(messenger);
        this.isEnabled = true;
        this.provider = provider;
    }
    getName() {
        return this.provider.getName();
    }
    /**
     * Set the enabled state for this provider.
     *
     * @param enabled - Whether the provider should be enabled.
     */
    setEnabled(enabled) {
        this.isEnabled = enabled;
    }
    /**
     * Override getAccounts to return empty array when disabled.
     *
     * @returns Array of accounts, or empty array if disabled.
     */
    getAccounts() {
        if (!this.isEnabled) {
            return [];
        }
        return this.provider.getAccounts();
    }
    /**
     * Override getAccount to throw when disabled.
     *
     * @param id - The account ID to retrieve.
     * @returns The account with the specified ID.
     * @throws When disabled or account not found.
     */
    getAccount(id) {
        if (!this.isEnabled) {
            throw new Error('Provider is disabled');
        }
        return this.provider.getAccount(id);
    }
    /**
     * Implement abstract method: Check if account is compatible.
     * Delegates directly to wrapped provider - no runtime checks needed!
     *
     * @param account - The account to check.
     * @returns True if the account is compatible.
     */
    isAccountCompatible(account) {
        return this.provider.isAccountCompatible(account);
    }
    /**
     * Implement abstract method: Create accounts, returns empty array when disabled.
     *
     * @param options - Account creation options.
     * @param options.entropySource - The entropy source to use.
     * @param options.groupIndex - The group index to use.
     * @returns Promise resolving to created accounts, or empty array if disabled.
     */
    async createAccounts(options) {
        if (!this.isEnabled) {
            return [];
        }
        return this.provider.createAccounts(options);
    }
    /**
     * Implement abstract method: Discover and create accounts, returns empty array when disabled.
     *
     * @param options - Account discovery options.
     * @param options.entropySource - The entropy source to use.
     * @param options.groupIndex - The group index to use.
     * @returns Promise resolving to discovered accounts, or empty array if disabled.
     */
    async discoverAccounts(options) {
        if (!this.isEnabled) {
            return [];
        }
        return this.provider.discoverAccounts(options);
    }
}
exports.AccountProviderWrapper = AccountProviderWrapper;
/**
 * Simple type guard to check if a provider is wrapped.
 *
 * @param provider - The provider to check.
 * @returns True if the provider is an AccountProviderWrapper.
 */
function isAccountProviderWrapper(provider) {
    return provider instanceof AccountProviderWrapper;
}
exports.isAccountProviderWrapper = isAccountProviderWrapper;

      };
    };
  }
  }
}, {package:"@metamask/multichain-account-service",file:"node_modules\\@metamask\\multichain-account-service\\dist\\providers\\AccountProviderWrapper.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\BaseBip44AccountProvider.cjs", {"@metamask/account-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-account-service%5Cdist%5Cproviders%5CBaseBip44AccountProvider.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _BaseBip44AccountProvider_instances, _BaseBip44AccountProvider_getAccounts;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseBip44AccountProvider = exports.assertAreBip44Accounts = exports.assertIsBip44Account = void 0;
const account_api_1 = require("@metamask/account-api");
/**
 * Asserts a keyring account is BIP-44 compatible.
 *
 * @param account - Keyring account to check.
 * @throws If the keyring account is not compatible.
 */
function assertIsBip44Account(account) {
    if (!(0, account_api_1.isBip44Account)(account)) {
        throw new Error('Created account is not BIP-44 compatible');
    }
}
exports.assertIsBip44Account = assertIsBip44Account;
/**
 * Asserts that a list of keyring accounts are all BIP-44 compatible.
 *
 * @param accounts - Keyring accounts to check.
 * @throws If any of the keyring account is not compatible.
 */
function assertAreBip44Accounts(accounts) {
    accounts.forEach(assertIsBip44Account);
}
exports.assertAreBip44Accounts = assertAreBip44Accounts;
class BaseBip44AccountProvider {
    constructor(messenger) {
        _BaseBip44AccountProvider_instances.add(this);
        this.messenger = messenger;
    }
    getAccounts() {
        return __classPrivateFieldGet(this, _BaseBip44AccountProvider_instances, "m", _BaseBip44AccountProvider_getAccounts).call(this);
    }
    getAccount(id) {
        // TODO: Maybe just use a proper find for faster lookup?
        const [found] = __classPrivateFieldGet(this, _BaseBip44AccountProvider_instances, "m", _BaseBip44AccountProvider_getAccounts).call(this, (account) => account.id === id);
        if (!found) {
            throw new Error(`Unable to find account: ${id}`);
        }
        return found;
    }
    async withKeyring(selector, operation) {
        const result = await this.messenger.call('KeyringController:withKeyring', selector, ({ keyring, metadata }) => operation({
            keyring: keyring,
            metadata,
        }));
        return result;
    }
}
exports.BaseBip44AccountProvider = BaseBip44AccountProvider;
_BaseBip44AccountProvider_instances = new WeakSet(), _BaseBip44AccountProvider_getAccounts = function _BaseBip44AccountProvider_getAccounts(filter = () => true) {
    const accounts = [];
    for (const account of this.messenger.call(
    // NOTE: Even though the name is misleading, this only fetches all internal
    // accounts, including EVM and non-EVM. We might wanna change this action
    // name once we fully support multichain accounts.
    'AccountsController:listMultichainAccounts')) {
        if ((0, account_api_1.isBip44Account)(account) &&
            this.isAccountCompatible(account) &&
            filter(account)) {
            accounts.push(account);
        }
    }
    return accounts;
};

      };
    };
  }
  }
}, {package:"@metamask/multichain-account-service",file:"node_modules\\@metamask\\multichain-account-service\\dist\\providers\\BaseBip44AccountProvider.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\BtcAccountProvider.cjs", {"./SnapAccountProvider.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\SnapAccountProvider.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\utils.cjs","@metamask/account-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/keyring-snap-client":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-account-service%5Cdist%5Cproviders%5CBtcAccountProvider.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var _BtcAccountProvider_instances, _BtcAccountProvider_client, _BtcAccountProvider_config, _BtcAccountProvider_getKeyringClientFromSnapId;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BtcAccountProvider = exports.BTC_ACCOUNT_PROVIDER_NAME = void 0;
const account_api_1 = require("@metamask/account-api");
const keyring_api_1 = require("@metamask/keyring-api");
const keyring_snap_client_1 = require("@metamask/keyring-snap-client");
const snaps_utils_1 = require("@metamask/snaps-utils");
const SnapAccountProvider_1 = require("./SnapAccountProvider.cjs");
const utils_1 = require("./utils.cjs");
exports.BTC_ACCOUNT_PROVIDER_NAME = 'Bitcoin';
class BtcAccountProvider extends SnapAccountProvider_1.SnapAccountProvider {
    constructor(messenger, config = {
        createAccounts: {
            timeoutMs: 3000,
        },
        discovery: {
            timeoutMs: 2000,
            maxAttempts: 3,
            backOffMs: 1000,
        },
    }) {
        super(BtcAccountProvider.BTC_SNAP_ID, messenger);
        _BtcAccountProvider_instances.add(this);
        _BtcAccountProvider_client.set(this, void 0);
        _BtcAccountProvider_config.set(this, void 0);
        __classPrivateFieldSet(this, _BtcAccountProvider_client, __classPrivateFieldGet(this, _BtcAccountProvider_instances, "m", _BtcAccountProvider_getKeyringClientFromSnapId).call(this, BtcAccountProvider.BTC_SNAP_ID), "f");
        __classPrivateFieldSet(this, _BtcAccountProvider_config, config, "f");
    }
    getName() {
        return BtcAccountProvider.NAME;
    }
    isAccountCompatible(account) {
        return (account.type === keyring_api_1.BtcAccountType.P2wpkh &&
            Object.values(keyring_api_1.BtcAccountType).includes(account.type));
    }
    async createAccounts({ entropySource, groupIndex: index, }) {
        const createAccount = await this.getRestrictedSnapAccountCreator();
        const account = await (0, utils_1.withTimeout)(createAccount({
            entropySource,
            index,
            addressType: keyring_api_1.BtcAccountType.P2wpkh,
            scope: keyring_api_1.BtcScope.Mainnet,
        }), __classPrivateFieldGet(this, _BtcAccountProvider_config, "f").createAccounts.timeoutMs);
        (0, account_api_1.assertIsBip44Account)(account);
        return [account];
    }
    async discoverAccounts({ entropySource, groupIndex, }) {
        const discoveredAccounts = await (0, utils_1.withRetry)(() => (0, utils_1.withTimeout)(__classPrivateFieldGet(this, _BtcAccountProvider_client, "f").discoverAccounts([keyring_api_1.BtcScope.Mainnet], entropySource, groupIndex), __classPrivateFieldGet(this, _BtcAccountProvider_config, "f").discovery.timeoutMs), {
            maxAttempts: __classPrivateFieldGet(this, _BtcAccountProvider_config, "f").discovery.maxAttempts,
            backOffMs: __classPrivateFieldGet(this, _BtcAccountProvider_config, "f").discovery.backOffMs,
        });
        if (!Array.isArray(discoveredAccounts) || discoveredAccounts.length === 0) {
            return [];
        }
        const createdAccounts = await this.createAccounts({
            entropySource,
            groupIndex,
        });
        return createdAccounts;
    }
}
exports.BtcAccountProvider = BtcAccountProvider;
_BtcAccountProvider_client = new WeakMap(), _BtcAccountProvider_config = new WeakMap(), _BtcAccountProvider_instances = new WeakSet(), _BtcAccountProvider_getKeyringClientFromSnapId = function _BtcAccountProvider_getKeyringClientFromSnapId(snapId) {
    return new keyring_snap_client_1.KeyringClient({
        send: async (request) => {
            const response = await this.messenger.call('SnapController:handleRequest', {
                snapId: snapId,
                origin: 'metamask',
                handler: snaps_utils_1.HandlerType.OnKeyringRequest,
                request,
            });
            return response;
        },
    });
};
BtcAccountProvider.NAME = exports.BTC_ACCOUNT_PROVIDER_NAME;
BtcAccountProvider.BTC_SNAP_ID = 'npm:@metamask/bitcoin-wallet-snap';

      };
    };
  }
  }
}, {package:"@metamask/multichain-account-service",file:"node_modules\\@metamask\\multichain-account-service\\dist\\providers\\BtcAccountProvider.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\EvmAccountProvider.cjs", {"./BaseBip44AccountProvider.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\BaseBip44AccountProvider.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\utils.cjs","@ethereumjs/util":"D:\\code\\v\\metamask-extension\\node_modules\\@ethereumjs\\util\\dist\\cjs\\index.js","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-account-service%5Cdist%5Cproviders%5CEvmAccountProvider.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _EvmAccountProvider_instances, _EvmAccountProvider_config, _EvmAccountProvider_createAccount, _EvmAccountProvider_getTransactionCount, _EvmAccountProvider_getAddressFromGroupIndex;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EvmAccountProvider = exports.EVM_ACCOUNT_PROVIDER_NAME = void 0;
const util_1 = require("@ethereumjs/util");
const keyring_api_1 = require("@metamask/keyring-api");
const keyring_controller_1 = require("@metamask/keyring-controller");
const utils_1 = require("@metamask/utils");
const BaseBip44AccountProvider_1 = require("./BaseBip44AccountProvider.cjs");
const utils_2 = require("./utils.cjs");
const ETH_MAINNET_CHAIN_ID = '0x1';
/**
 * Asserts an internal account exists.
 *
 * @param account - The internal account to check.
 * @throws An error if the internal account does not exist.
 */
function assertInternalAccountExists(account) {
    if (!account) {
        throw new Error('Internal account does not exist');
    }
}
exports.EVM_ACCOUNT_PROVIDER_NAME = 'EVM';
class EvmAccountProvider extends BaseBip44AccountProvider_1.BaseBip44AccountProvider {
    constructor(messenger, config = {
        discovery: {
            maxAttempts: 3,
            timeoutMs: 500,
            backOffMs: 500,
        },
    }) {
        super(messenger);
        _EvmAccountProvider_instances.add(this);
        _EvmAccountProvider_config.set(this, void 0);
        __classPrivateFieldSet(this, _EvmAccountProvider_config, config, "f");
    }
    isAccountCompatible(account) {
        return (account.type === keyring_api_1.EthAccountType.Eoa &&
            account.metadata.keyring.type === keyring_controller_1.KeyringTypes.hd);
    }
    getName() {
        return EvmAccountProvider.NAME;
    }
    /**
     * Get the EVM provider.
     *
     * @returns The EVM provider.
     */
    getEvmProvider() {
        const networkClientId = this.messenger.call('NetworkController:findNetworkClientIdByChainId', ETH_MAINNET_CHAIN_ID);
        const { provider } = this.messenger.call('NetworkController:getNetworkClientById', networkClientId);
        return provider;
    }
    async createAccounts({ entropySource, groupIndex, }) {
        const [address] = await __classPrivateFieldGet(this, _EvmAccountProvider_instances, "m", _EvmAccountProvider_createAccount).call(this, {
            entropySource,
            groupIndex,
            throwOnGap: true,
        });
        const account = this.messenger.call('AccountsController:getAccountByAddress', address);
        // We MUST have the associated internal account.
        assertInternalAccountExists(account);
        const accountsArray = [account];
        (0, BaseBip44AccountProvider_1.assertAreBip44Accounts)(accountsArray);
        return accountsArray;
    }
    /**
     * Discover and create accounts for the EVM provider.
     *
     * @param opts - The options for the discovery and creation of accounts.
     * @param opts.entropySource - The entropy source to use for the discovery and creation of accounts.
     * @param opts.groupIndex - The index of the group to create the accounts for.
     * @returns The accounts for the EVM provider.
     */
    async discoverAccounts(opts) {
        const provider = this.getEvmProvider();
        const { entropySource, groupIndex } = opts;
        const addressFromGroupIndex = await __classPrivateFieldGet(this, _EvmAccountProvider_instances, "m", _EvmAccountProvider_getAddressFromGroupIndex).call(this, {
            entropySource,
            groupIndex,
        });
        const count = await __classPrivateFieldGet(this, _EvmAccountProvider_instances, "m", _EvmAccountProvider_getTransactionCount).call(this, provider, addressFromGroupIndex);
        if (count === 0) {
            return [];
        }
        // We have some activity on this address, we try to create the account.
        const [address] = await __classPrivateFieldGet(this, _EvmAccountProvider_instances, "m", _EvmAccountProvider_createAccount).call(this, {
            entropySource,
            groupIndex,
        });
        (0, utils_1.assert)(addressFromGroupIndex === address, 'Created account does not match address from group index.');
        const account = this.messenger.call('AccountsController:getAccountByAddress', address);
        assertInternalAccountExists(account);
        (0, BaseBip44AccountProvider_1.assertIsBip44Account)(account);
        return [account];
    }
}
exports.EvmAccountProvider = EvmAccountProvider;
_EvmAccountProvider_config = new WeakMap(), _EvmAccountProvider_instances = new WeakSet(), _EvmAccountProvider_createAccount = async function _EvmAccountProvider_createAccount({ entropySource, groupIndex, throwOnGap = false, }) {
    const result = await this.withKeyring({ id: entropySource }, async ({ keyring }) => {
        const existing = await keyring.getAccounts();
        if (groupIndex < existing.length) {
            return [existing[groupIndex], false];
        }
        // If the throwOnGap flag is set, we throw an error to prevent index gaps.
        if (throwOnGap && groupIndex !== existing.length) {
            throw new Error('Trying to create too many accounts');
        }
        const [added] = await keyring.addAccounts(1);
        return [added, true];
    });
    return result;
}, _EvmAccountProvider_getTransactionCount = async function _EvmAccountProvider_getTransactionCount(provider, address) {
    const countHex = await (0, utils_2.withRetry)(() => (0, utils_2.withTimeout)(provider.request({
        method: 'eth_getTransactionCount',
        params: [address, 'latest'],
    }), __classPrivateFieldGet(this, _EvmAccountProvider_config, "f").discovery.timeoutMs), {
        maxAttempts: __classPrivateFieldGet(this, _EvmAccountProvider_config, "f").discovery.maxAttempts,
        backOffMs: __classPrivateFieldGet(this, _EvmAccountProvider_config, "f").discovery.backOffMs,
    });
    return parseInt(countHex, 16);
}, _EvmAccountProvider_getAddressFromGroupIndex = async function _EvmAccountProvider_getAddressFromGroupIndex({ entropySource, groupIndex, }) {
    // NOTE: To avoid exposing this function at keyring level, we just re-use its internal state
    // and compute the derivation here.
    return await this.withKeyring({ id: entropySource }, async ({ keyring }) => {
        // If the account already exist, do not re-derive and just re-use that account.
        const existing = await keyring.getAccounts();
        if (groupIndex < existing.length) {
            return existing[groupIndex];
        }
        // If not, then we just "peek" the next address to avoid creating the account.
        (0, utils_1.assert)(keyring.root, 'Expected HD keyring.root to be set');
        const hdKey = keyring.root.deriveChild(groupIndex);
        (0, utils_1.assert)(hdKey.publicKey, 'Expected public key to be set');
        return (0, utils_1.add0x)((0, utils_1.bytesToHex)((0, util_1.publicToAddress)(hdKey.publicKey, true)).toLowerCase());
    });
};
EvmAccountProvider.NAME = exports.EVM_ACCOUNT_PROVIDER_NAME;

      };
    };
  }
  }
}, {package:"@metamask/multichain-account-service",file:"node_modules\\@metamask\\multichain-account-service\\dist\\providers\\EvmAccountProvider.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\SnapAccountProvider.cjs", {"./BaseBip44AccountProvider.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\BaseBip44AccountProvider.cjs","@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-account-service%5Cdist%5Cproviders%5CSnapAccountProvider.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isSnapAccountProvider = exports.SnapAccountProvider = void 0;
const keyring_controller_1 = require("@metamask/keyring-controller");
const BaseBip44AccountProvider_1 = require("./BaseBip44AccountProvider.cjs");
class SnapAccountProvider extends BaseBip44AccountProvider_1.BaseBip44AccountProvider {
    constructor(snapId, messenger) {
        super(messenger);
        this.snapId = snapId;
    }
    async getRestrictedSnapAccountCreator() {
        // NOTE: We're not supposed to make the keyring instance escape `withKeyring` but
        // we have to use the `SnapKeyring` instance to be able to create Solana account
        // without triggering UI confirmation.
        // Also, creating account that way won't invalidate the Snap keyring state. The
        // account will get created and persisted properly with the Snap account creation
        // flow "asynchronously" (with `notify:accountCreated`).
        const createAccount = await this.withKeyring({ type: keyring_controller_1.KeyringTypes.snap }, async ({ keyring }) => keyring.createAccount.bind(keyring));
        return (options) => createAccount(this.snapId, options, {
            displayAccountNameSuggestion: false,
            displayConfirmation: false,
            setSelectedAccount: false,
        });
    }
}
exports.SnapAccountProvider = SnapAccountProvider;
const isSnapAccountProvider = (provider) => {
    return provider instanceof SnapAccountProvider;
};
exports.isSnapAccountProvider = isSnapAccountProvider;

      };
    };
  }
  }
}, {package:"@metamask/multichain-account-service",file:"node_modules\\@metamask\\multichain-account-service\\dist\\providers\\SnapAccountProvider.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\SolAccountProvider.cjs", {"./SnapAccountProvider.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\SnapAccountProvider.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\utils.cjs","@metamask/account-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs","@metamask/keyring-snap-client":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-account-service%5Cdist%5Cproviders%5CSolAccountProvider.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var _SolAccountProvider_instances, _SolAccountProvider_client, _SolAccountProvider_config, _SolAccountProvider_getKeyringClientFromSnapId, _SolAccountProvider_createAccount;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SolAccountProvider = exports.SOL_ACCOUNT_PROVIDER_NAME = void 0;
const account_api_1 = require("@metamask/account-api");
const keyring_api_1 = require("@metamask/keyring-api");
const keyring_api_2 = require("@metamask/keyring-api");
const keyring_controller_1 = require("@metamask/keyring-controller");
const keyring_snap_client_1 = require("@metamask/keyring-snap-client");
const snaps_utils_1 = require("@metamask/snaps-utils");
const SnapAccountProvider_1 = require("./SnapAccountProvider.cjs");
const utils_1 = require("./utils.cjs");
exports.SOL_ACCOUNT_PROVIDER_NAME = 'Solana';
class SolAccountProvider extends SnapAccountProvider_1.SnapAccountProvider {
    constructor(messenger, config = {
        discovery: {
            timeoutMs: 2000,
            maxAttempts: 3,
            backOffMs: 1000,
        },
        createAccounts: {
            timeoutMs: 3000,
        },
    }) {
        super(SolAccountProvider.SOLANA_SNAP_ID, messenger);
        _SolAccountProvider_instances.add(this);
        _SolAccountProvider_client.set(this, void 0);
        _SolAccountProvider_config.set(this, void 0);
        __classPrivateFieldSet(this, _SolAccountProvider_client, __classPrivateFieldGet(this, _SolAccountProvider_instances, "m", _SolAccountProvider_getKeyringClientFromSnapId).call(this, SolAccountProvider.SOLANA_SNAP_ID), "f");
        __classPrivateFieldSet(this, _SolAccountProvider_config, config, "f");
    }
    getName() {
        return SolAccountProvider.NAME;
    }
    isAccountCompatible(account) {
        return (account.type === keyring_api_2.SolAccountType.DataAccount &&
            account.metadata.keyring.type === keyring_controller_1.KeyringTypes.snap);
    }
    async createAccounts({ entropySource, groupIndex, }) {
        const derivationPath = `m/44'/501'/${groupIndex}'/0'`;
        const account = await __classPrivateFieldGet(this, _SolAccountProvider_instances, "m", _SolAccountProvider_createAccount).call(this, {
            entropySource,
            groupIndex,
            derivationPath,
        });
        return [account];
    }
    async discoverAccounts({ entropySource, groupIndex, }) {
        const discoveredAccounts = await (0, utils_1.withRetry)(() => (0, utils_1.withTimeout)(__classPrivateFieldGet(this, _SolAccountProvider_client, "f").discoverAccounts([keyring_api_1.SolScope.Mainnet], entropySource, groupIndex), __classPrivateFieldGet(this, _SolAccountProvider_config, "f").discovery.timeoutMs), {
            maxAttempts: __classPrivateFieldGet(this, _SolAccountProvider_config, "f").discovery.maxAttempts,
            backOffMs: __classPrivateFieldGet(this, _SolAccountProvider_config, "f").discovery.backOffMs,
        });
        if (!discoveredAccounts.length) {
            return [];
        }
        const createdAccounts = await Promise.all(discoveredAccounts.map((d) => __classPrivateFieldGet(this, _SolAccountProvider_instances, "m", _SolAccountProvider_createAccount).call(this, {
            entropySource,
            groupIndex,
            derivationPath: d.derivationPath,
        })));
        return createdAccounts;
    }
}
exports.SolAccountProvider = SolAccountProvider;
_SolAccountProvider_client = new WeakMap(), _SolAccountProvider_config = new WeakMap(), _SolAccountProvider_instances = new WeakSet(), _SolAccountProvider_getKeyringClientFromSnapId = function _SolAccountProvider_getKeyringClientFromSnapId(snapId) {
    return new keyring_snap_client_1.KeyringClient({
        send: async (request) => {
            const response = await this.messenger.call('SnapController:handleRequest', {
                snapId: snapId,
                origin: 'metamask',
                handler: snaps_utils_1.HandlerType.OnKeyringRequest,
                request,
            });
            return response;
        },
    });
}, _SolAccountProvider_createAccount = async function _SolAccountProvider_createAccount({ entropySource, groupIndex, derivationPath, }) {
    const createAccount = await this.getRestrictedSnapAccountCreator();
    const account = await (0, utils_1.withTimeout)(createAccount({ entropySource, derivationPath }), __classPrivateFieldGet(this, _SolAccountProvider_config, "f").createAccounts.timeoutMs);
    // Ensure entropy is present before type assertion validation
    account.options.entropy = {
        type: keyring_api_2.KeyringAccountEntropyTypeOption.Mnemonic,
        id: entropySource,
        groupIndex,
        derivationPath,
    };
    (0, account_api_1.assertIsBip44Account)(account);
    return account;
};
SolAccountProvider.NAME = exports.SOL_ACCOUNT_PROVIDER_NAME;
SolAccountProvider.SOLANA_SNAP_ID = 'npm:@metamask/solana-wallet-snap';

      };
    };
  }
  }
}, {package:"@metamask/multichain-account-service",file:"node_modules\\@metamask\\multichain-account-service\\dist\\providers\\SolAccountProvider.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\TrxAccountProvider.cjs", {"./SnapAccountProvider.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\SnapAccountProvider.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\utils.cjs","@metamask/account-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs","@metamask/keyring-snap-client":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-account-service%5Cdist%5Cproviders%5CTrxAccountProvider.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var _TrxAccountProvider_instances, _TrxAccountProvider_client, _TrxAccountProvider_config, _TrxAccountProvider_getKeyringClientFromSnapId, _TrxAccountProvider_createAccount;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrxAccountProvider = exports.TRX_ACCOUNT_PROVIDER_NAME = void 0;
const account_api_1 = require("@metamask/account-api");
const keyring_api_1 = require("@metamask/keyring-api");
const keyring_api_2 = require("@metamask/keyring-api");
const keyring_controller_1 = require("@metamask/keyring-controller");
const keyring_snap_client_1 = require("@metamask/keyring-snap-client");
const snaps_utils_1 = require("@metamask/snaps-utils");
const SnapAccountProvider_1 = require("./SnapAccountProvider.cjs");
const utils_1 = require("./utils.cjs");
exports.TRX_ACCOUNT_PROVIDER_NAME = 'Tron';
class TrxAccountProvider extends SnapAccountProvider_1.SnapAccountProvider {
    constructor(messenger, config = {
        discovery: {
            timeoutMs: 2000,
            maxAttempts: 3,
            backOffMs: 1000,
        },
        createAccounts: {
            timeoutMs: 3000,
        },
    }) {
        super(TrxAccountProvider.TRX_SNAP_ID, messenger);
        _TrxAccountProvider_instances.add(this);
        _TrxAccountProvider_client.set(this, void 0);
        _TrxAccountProvider_config.set(this, void 0);
        __classPrivateFieldSet(this, _TrxAccountProvider_client, __classPrivateFieldGet(this, _TrxAccountProvider_instances, "m", _TrxAccountProvider_getKeyringClientFromSnapId).call(this, TrxAccountProvider.TRX_SNAP_ID), "f");
        __classPrivateFieldSet(this, _TrxAccountProvider_config, config, "f");
    }
    getName() {
        return TrxAccountProvider.NAME;
    }
    isAccountCompatible(account) {
        return (account.type === keyring_api_1.TrxAccountType.Eoa &&
            account.metadata.keyring.type === keyring_controller_1.KeyringTypes.snap);
    }
    async createAccounts({ entropySource, groupIndex, }) {
        const derivationPath = `m/44'/195'/0'/${groupIndex}'`;
        const account = await __classPrivateFieldGet(this, _TrxAccountProvider_instances, "m", _TrxAccountProvider_createAccount).call(this, {
            entropySource,
            groupIndex,
            derivationPath,
        });
        return [account];
    }
    async discoverAccounts({ entropySource, groupIndex, }) {
        const discoveredAccounts = await (0, utils_1.withRetry)(() => (0, utils_1.withTimeout)(__classPrivateFieldGet(this, _TrxAccountProvider_client, "f").discoverAccounts([keyring_api_1.TrxScope.Mainnet], entropySource, groupIndex), __classPrivateFieldGet(this, _TrxAccountProvider_config, "f").discovery.timeoutMs), {
            maxAttempts: __classPrivateFieldGet(this, _TrxAccountProvider_config, "f").discovery.maxAttempts,
            backOffMs: __classPrivateFieldGet(this, _TrxAccountProvider_config, "f").discovery.backOffMs,
        });
        if (!discoveredAccounts.length) {
            return [];
        }
        const createdAccounts = await Promise.all(discoveredAccounts.map((d) => __classPrivateFieldGet(this, _TrxAccountProvider_instances, "m", _TrxAccountProvider_createAccount).call(this, {
            entropySource,
            groupIndex,
            derivationPath: d.derivationPath,
        })));
        return createdAccounts;
    }
}
exports.TrxAccountProvider = TrxAccountProvider;
_TrxAccountProvider_client = new WeakMap(), _TrxAccountProvider_config = new WeakMap(), _TrxAccountProvider_instances = new WeakSet(), _TrxAccountProvider_getKeyringClientFromSnapId = function _TrxAccountProvider_getKeyringClientFromSnapId(snapId) {
    return new keyring_snap_client_1.KeyringClient({
        send: async (request) => {
            const response = await this.messenger.call('SnapController:handleRequest', {
                snapId: snapId,
                origin: 'metamask',
                handler: snaps_utils_1.HandlerType.OnKeyringRequest,
                request,
            });
            return response;
        },
    });
}, _TrxAccountProvider_createAccount = async function _TrxAccountProvider_createAccount({ entropySource, groupIndex, derivationPath, }) {
    const createAccount = await this.getRestrictedSnapAccountCreator();
    const account = await (0, utils_1.withTimeout)(createAccount({ entropySource, derivationPath }), __classPrivateFieldGet(this, _TrxAccountProvider_config, "f").createAccounts.timeoutMs);
    // Ensure entropy is present before type assertion validation
    account.options.entropy = {
        type: keyring_api_2.KeyringAccountEntropyTypeOption.Mnemonic,
        id: entropySource,
        groupIndex,
        derivationPath,
    };
    (0, account_api_1.assertIsBip44Account)(account);
    return account;
};
TrxAccountProvider.NAME = exports.TRX_ACCOUNT_PROVIDER_NAME;
TrxAccountProvider.TRX_SNAP_ID = 'npm:@metamask/tron-wallet-snap';

      };
    };
  }
  }
}, {package:"@metamask/multichain-account-service",file:"node_modules\\@metamask\\multichain-account-service\\dist\\providers\\TrxAccountProvider.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\index.cjs", {"./AccountProviderWrapper.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\AccountProviderWrapper.cjs","./BaseBip44AccountProvider.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\BaseBip44AccountProvider.cjs","./BtcAccountProvider.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\BtcAccountProvider.cjs","./EvmAccountProvider.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\EvmAccountProvider.cjs","./SnapAccountProvider.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\SnapAccountProvider.cjs","./SolAccountProvider.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\SolAccountProvider.cjs","./TrxAccountProvider.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\TrxAccountProvider.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\utils.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-account-service%5Cdist%5Cproviders%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeoutError = void 0;
__exportStar(require("./BaseBip44AccountProvider.cjs"), exports);
__exportStar(require("./SnapAccountProvider.cjs"), exports);
__exportStar(require("./AccountProviderWrapper.cjs"), exports);
// Errors that can bubble up outside of provider calls.
var utils_1 = require("./utils.cjs");
Object.defineProperty(exports, "TimeoutError", { enumerable: true, get: function () { return utils_1.TimeoutError; } });
// Concrete providers:
__exportStar(require("./SolAccountProvider.cjs"), exports);
__exportStar(require("./EvmAccountProvider.cjs"), exports);
__exportStar(require("./BtcAccountProvider.cjs"), exports);
__exportStar(require("./TrxAccountProvider.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/multichain-account-service",file:"node_modules\\@metamask\\multichain-account-service\\dist\\providers\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-account-service\\dist\\providers\\utils.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-account-service%5Cdist%5Cproviders%5Cutils.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.withTimeout = exports.withRetry = exports.TimeoutError = void 0;
/** Timeout error. */
class TimeoutError extends Error {
    constructor(message) {
        super(message);
        this.name = 'TimeoutError';
    }
}
exports.TimeoutError = TimeoutError;
/**
 * Execute a function with exponential backoff on transient failures.
 *
 * @param fnToExecute - The function to execute.
 * @param options - The options for the retry.
 * @param options.maxAttempts - The maximum number of attempts.
 * @param options.backOffMs - The backoff in milliseconds.
 * @throws An error if the transaction count cannot be retrieved.
 * @returns The result of the function.
 */
async function withRetry(fnToExecute, { maxAttempts = 3, backOffMs = 500, } = {}) {
    let lastError;
    let backOff = backOffMs;
    for (let attempt = 1; attempt <= maxAttempts; attempt++) {
        try {
            return await fnToExecute();
        }
        catch (error) {
            lastError = error;
            if (attempt >= maxAttempts) {
                break;
            }
            const delay = backOff;
            await new Promise((resolve) => setTimeout(resolve, delay));
            backOff *= 2;
        }
    }
    throw lastError;
}
exports.withRetry = withRetry;
/**
 * Execute a promise with a timeout.
 *
 * @param promise - The promise to execute.
 * @param timeoutMs - The timeout in milliseconds.
 * @returns The result of the promise.
 */
async function withTimeout(promise, timeoutMs = 500) {
    let timer;
    try {
        return await Promise.race([
            promise,
            new Promise((_resolve, reject) => {
                timer = setTimeout(() => reject(new TimeoutError('Timed out')), timeoutMs);
            }),
        ]);
    }
    finally {
        if (timer) {
            clearTimeout(timer);
        }
    }
}
exports.withTimeout = withTimeout;

      };
    };
  }
  }
}, {package:"@metamask/multichain-account-service",file:"node_modules\\@metamask\\multichain-account-service\\dist\\providers\\utils.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\dist\\handlers\\types.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-api-middleware%5Cdist%5Chandlers%5Ctypes.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultichainApiNotifications = void 0;
/**
 * Multichain API notifications currently supported by/known to the wallet.
 */
var MultichainApiNotifications;
(function (MultichainApiNotifications) {
    MultichainApiNotifications["sessionChanged"] = "wallet_sessionChanged";
    MultichainApiNotifications["walletNotify"] = "wallet_notify";
})(MultichainApiNotifications || (exports.MultichainApiNotifications = MultichainApiNotifications = {}));

      };
    };
  }
  }
}, {package:"@metamask/multichain-api-middleware",file:"node_modules\\@metamask\\multichain-api-middleware\\dist\\handlers\\types.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\dist\\handlers\\wallet-createSession.cjs", {"@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-api-middleware%5Cdist%5Chandlers%5Cwallet-createSession.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.walletCreateSession = void 0;
const chain_agnostic_permission_1 = require("@metamask/chain-agnostic-permission");
const controller_utils_1 = require("@metamask/controller-utils");
const permission_controller_1 = require("@metamask/permission-controller");
const rpc_errors_1 = require("@metamask/rpc-errors");
const utils_1 = require("@metamask/utils");
const SOLANA_CAIP_CHAIN_ID = 'solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp';
/**
 * Handler for the `wallet_createSession` RPC method which is responsible
 * for prompting for approval and granting a CAIP-25 permission.
 *
 * This implementation primarily deviates from the CAIP-25 handler
 * specification by treating all scopes as optional regardless of
 * if they were specified in `requiredScopes` or `optionalScopes`.
 * Additionally, provided scopes, methods, notifications, and
 * account values that are invalid/malformed are ignored rather than
 * causing an error to be returned.
 *
 * @param req - The request object.
 * @param res - The response object.
 * @param _next - The next middleware function.
 * @param end - The end function.
 * @param hooks - The hooks object.
 * @param hooks.listAccounts - The hook that returns an array of the wallet's evm accounts.
 * @param hooks.findNetworkClientIdByChainId - The hook that returns the networkClientId for a chainId.
 * @param hooks.requestPermissionsForOrigin - The hook that approves and grants requested permissions.
 * @param hooks.getNonEvmSupportedMethods - The hook that returns the supported methods for a non EVM scope.
 * @param hooks.isNonEvmScopeSupported - The hook that returns true if a non EVM scope is supported.
 * @param hooks.getNonEvmAccountAddresses - The hook that returns a list of CaipAccountIds that are supported for a CaipChainId.
 * @param hooks.trackSessionCreatedEvent - An optional hook for platform specific logic to run. Can be undefined.
 * @returns A promise with wallet_createSession handler
 */
async function walletCreateSessionHandler(req, res, _next, end, hooks) {
    if (!(0, utils_1.isPlainObject)(req.params)) {
        return end((0, permission_controller_1.invalidParams)({ data: { request: req } }));
    }
    const { requiredScopes, optionalScopes, sessionProperties } = req.params;
    if (sessionProperties && Object.keys(sessionProperties).length === 0) {
        return end(new rpc_errors_1.JsonRpcError(5302, 'Invalid sessionProperties requested'));
    }
    const filteredSessionProperties = Object.fromEntries(Object.entries(sessionProperties ?? {}).filter(([key]) => (0, chain_agnostic_permission_1.isKnownSessionPropertyValue)(key)));
    try {
        const { normalizedRequiredScopes, normalizedOptionalScopes } = (0, chain_agnostic_permission_1.validateAndNormalizeScopes)(requiredScopes || {}, optionalScopes || {});
        const requiredScopesWithSupportedMethodsAndNotifications = (0, chain_agnostic_permission_1.getSupportedScopeObjects)(normalizedRequiredScopes, {
            getNonEvmSupportedMethods: hooks.getNonEvmSupportedMethods,
        });
        const optionalScopesWithSupportedMethodsAndNotifications = (0, chain_agnostic_permission_1.getSupportedScopeObjects)(normalizedOptionalScopes, {
            getNonEvmSupportedMethods: hooks.getNonEvmSupportedMethods,
        });
        const networkClientExistsForChainId = (chainId) => {
            try {
                hooks.findNetworkClientIdByChainId(chainId);
                return true;
            }
            catch {
                return false;
            }
        };
        // if solana is a requested scope but not supported, we add a promptToCreateSolanaAccount flag to request
        const isSolanaRequested = (0, chain_agnostic_permission_1.isNamespaceInScopesObject)(requiredScopesWithSupportedMethodsAndNotifications, utils_1.KnownCaipNamespace.Solana) ||
            (0, chain_agnostic_permission_1.isNamespaceInScopesObject)(optionalScopesWithSupportedMethodsAndNotifications, utils_1.KnownCaipNamespace.Solana);
        let promptToCreateSolanaAccount = false;
        if (isSolanaRequested) {
            const supportedSolanaAccounts = hooks.getNonEvmAccountAddresses(SOLANA_CAIP_CHAIN_ID);
            promptToCreateSolanaAccount = supportedSolanaAccounts.length === 0;
        }
        const { supportedScopes: supportedRequiredScopes } = (0, chain_agnostic_permission_1.bucketScopes)(requiredScopesWithSupportedMethodsAndNotifications, {
            isEvmChainIdSupported: networkClientExistsForChainId,
            isEvmChainIdSupportable: () => false,
            getNonEvmSupportedMethods: hooks.getNonEvmSupportedMethods,
            isNonEvmScopeSupported: hooks.isNonEvmScopeSupported,
        });
        const { supportedScopes: supportedOptionalScopes } = (0, chain_agnostic_permission_1.bucketScopes)(optionalScopesWithSupportedMethodsAndNotifications, {
            isEvmChainIdSupported: networkClientExistsForChainId,
            isEvmChainIdSupportable: () => false,
            getNonEvmSupportedMethods: hooks.getNonEvmSupportedMethods,
            isNonEvmScopeSupported: hooks.isNonEvmScopeSupported,
        });
        const allRequestedAccountAddresses = (0, chain_agnostic_permission_1.getCaipAccountIdsFromScopesObjects)([
            supportedRequiredScopes,
            supportedOptionalScopes,
        ]);
        const allSupportedRequestedCaipChainIds = (0, chain_agnostic_permission_1.getAllScopesFromScopesObjects)([
            supportedRequiredScopes,
            supportedOptionalScopes,
        ]);
        const existingEvmAddresses = hooks
            .listAccounts()
            .map((account) => account.address);
        const supportedRequestedAccountAddresses = allRequestedAccountAddresses.filter((requestedAccountAddress) => {
            const { address, chain: { namespace }, chainId: caipChainId, } = (0, utils_1.parseCaipAccountId)(requestedAccountAddress);
            if (namespace === utils_1.KnownCaipNamespace.Eip155.toString()) {
                return existingEvmAddresses.some((existingEvmAddress) => {
                    return (0, controller_utils_1.isEqualCaseInsensitive)(address, existingEvmAddress);
                });
            }
            // If the namespace is not eip155 (EVM) we do a case sensitive check
            return hooks
                .getNonEvmAccountAddresses(caipChainId)
                .some((existingCaipAddress) => {
                return requestedAccountAddress === existingCaipAddress;
            });
        });
        const requestedCaip25CaveatValue = {
            requiredScopes: (0, chain_agnostic_permission_1.getInternalScopesObject)(supportedRequiredScopes),
            optionalScopes: (0, chain_agnostic_permission_1.getInternalScopesObject)(supportedOptionalScopes),
            isMultichainOrigin: true,
            sessionProperties: filteredSessionProperties,
        };
        const requestedCaip25CaveatValueWithSupportedAccounts = (0, chain_agnostic_permission_1.setNonSCACaipAccountIdsInCaip25CaveatValue)(requestedCaip25CaveatValue, supportedRequestedAccountAddresses);
        // if `promptToCreateSolanaAccount` is true and there are no other valid scopes requested,
        // we add a `wallet` scope to the request in order to get passed the CAIP-25 caveat validator.
        // This is very hacky but is necessary because the solana opt-in flow breaks key assumptions
        // of the CAIP-25 permission specification -  namely that we can have valid requests with no scopes.
        if (allSupportedRequestedCaipChainIds.length === 0) {
            if (promptToCreateSolanaAccount) {
                requestedCaip25CaveatValueWithSupportedAccounts.optionalScopes[utils_1.KnownCaipNamespace.Wallet] = {
                    accounts: [],
                };
            }
            else {
                // if solana is not requested and there are no supported scopes, we return an error
                return end(new rpc_errors_1.JsonRpcError(5100, 'Requested scopes are not supported'));
            }
        }
        const [grantedPermissions] = await hooks.requestPermissionsForOrigin({
            [chain_agnostic_permission_1.Caip25EndowmentPermissionName]: {
                caveats: [
                    {
                        type: chain_agnostic_permission_1.Caip25CaveatType,
                        value: requestedCaip25CaveatValueWithSupportedAccounts,
                    },
                ],
            },
        }, {
            metadata: { promptToCreateSolanaAccount },
        });
        const approvedCaip25Permission = grantedPermissions[chain_agnostic_permission_1.Caip25EndowmentPermissionName];
        const approvedCaip25CaveatValue = approvedCaip25Permission?.caveats?.find((caveat) => caveat.type === chain_agnostic_permission_1.Caip25CaveatType)?.value;
        if (!approvedCaip25CaveatValue) {
            throw rpc_errors_1.rpcErrors.internal();
        }
        const sessionScopes = (0, chain_agnostic_permission_1.getSessionScopes)(approvedCaip25CaveatValue, {
            getNonEvmSupportedMethods: hooks.getNonEvmSupportedMethods,
        });
        const { sessionProperties: approvedSessionProperties = {} } = approvedCaip25CaveatValue;
        hooks.trackSessionCreatedEvent?.(approvedCaip25CaveatValue);
        res.result = {
            sessionScopes,
            sessionProperties: approvedSessionProperties,
        };
        return end();
    }
    catch (err) {
        return end(err);
    }
}
exports.walletCreateSession = {
    methodNames: ['wallet_createSession'],
    implementation: walletCreateSessionHandler,
    hookNames: {
        findNetworkClientIdByChainId: true,
        listAccounts: true,
        requestPermissionsForOrigin: true,
        getNonEvmSupportedMethods: true,
        isNonEvmScopeSupported: true,
        getNonEvmAccountAddresses: true,
        trackSessionCreatedEvent: true,
    },
};

      };
    };
  }
  }
}, {package:"@metamask/multichain-api-middleware",file:"node_modules\\@metamask\\multichain-api-middleware\\dist\\handlers\\wallet-createSession.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\dist\\handlers\\wallet-getSession.cjs", {"@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-api-middleware%5Cdist%5Chandlers%5Cwallet-getSession.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.walletGetSession = void 0;
const chain_agnostic_permission_1 = require("@metamask/chain-agnostic-permission");
/**
 * Handler for the `wallet_getSession` RPC method as specified by [CAIP-312](https://chainagnostic.org/CAIPs/caip-312).
 * The implementation below deviates from the linked spec in that it ignores the `sessionId` param entirely,
 * and that an empty object is returned for the `sessionScopes` result rather than throwing an error if there
 * is no active session for the origin.
 *
 * @param _request - The request object.
 * @param response - The response object.
 * @param _next - The next middleware function. Unused.
 * @param end - The end function.
 * @param hooks - The hooks object.
 * @param hooks.getCaveatForOrigin - Function to retrieve a caveat for the origin.
 * @param hooks.getNonEvmSupportedMethods - A function that returns the supported methods for a non EVM scope.
 * @returns Nothing.
 */
async function walletGetSessionHandler(_request, response, _next, end, hooks) {
    let caveat;
    try {
        caveat = hooks.getCaveatForOrigin(chain_agnostic_permission_1.Caip25EndowmentPermissionName, chain_agnostic_permission_1.Caip25CaveatType);
    }
    catch {
        // noop
    }
    if (!caveat) {
        response.result = { sessionScopes: {} };
        return end();
    }
    response.result = {
        sessionScopes: (0, chain_agnostic_permission_1.getSessionScopes)(caveat.value, {
            getNonEvmSupportedMethods: hooks.getNonEvmSupportedMethods,
        }),
    };
    return end();
}
exports.walletGetSession = {
    methodNames: ['wallet_getSession'],
    implementation: walletGetSessionHandler,
    hookNames: {
        getCaveatForOrigin: true,
        getNonEvmSupportedMethods: true,
    },
};

      };
    };
  }
  }
}, {package:"@metamask/multichain-api-middleware",file:"node_modules\\@metamask\\multichain-api-middleware\\dist\\handlers\\wallet-getSession.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\dist\\handlers\\wallet-invokeMethod.cjs", {"@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-api-middleware%5Cdist%5Chandlers%5Cwallet-invokeMethod.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.walletInvokeMethod = void 0;
const chain_agnostic_permission_1 = require("@metamask/chain-agnostic-permission");
const rpc_errors_1 = require("@metamask/rpc-errors");
const utils_1 = require("@metamask/utils");
/**
 * Handler for the `wallet_invokeMethod` RPC method as specified by [CAIP-27](https://chainagnostic.org/CAIPs/caip-27).
 * The implementation below deviates from the linked spec in that it ignores the `sessionId` param
 * and instead uses the singular session for the origin if available.
 *
 * @param request - The request object.
 * @param response - The response object. Unused.
 * @param next - The next middleware function.
 * @param end - The end function.
 * @param hooks - The hooks object.
 * @param hooks.getCaveatForOrigin - the hook for getting a caveat from a permission for an origin.
 * @param hooks.findNetworkClientIdByChainId - the hook for finding the networkClientId for a chainId.
 * @param hooks.getSelectedNetworkClientId - the hook for getting the current globally selected networkClientId.
 * @param hooks.getNonEvmSupportedMethods - A function that returns the supported methods for a non EVM scope.
 * @param hooks.handleNonEvmRequestForOrigin - A function that sends a request to the MultichainRouter for processing.
 * @returns Nothing.
 */
async function walletInvokeMethodHandler(request, response, next, end, hooks) {
    const { scope, request: wrappedRequest } = request.params;
    (0, chain_agnostic_permission_1.assertIsInternalScopeString)(scope);
    let caveat;
    try {
        caveat = hooks.getCaveatForOrigin(chain_agnostic_permission_1.Caip25EndowmentPermissionName, chain_agnostic_permission_1.Caip25CaveatType);
    }
    catch {
        // noop
    }
    if (!caveat) {
        return end(rpc_errors_1.providerErrors.unauthorized());
    }
    const scopeObject = (0, chain_agnostic_permission_1.getSessionScopes)(caveat.value, {
        getNonEvmSupportedMethods: hooks.getNonEvmSupportedMethods,
    })[scope];
    if (!scopeObject?.methods?.includes(wrappedRequest.method)) {
        return end(rpc_errors_1.providerErrors.unauthorized());
    }
    const { namespace, reference } = (0, chain_agnostic_permission_1.parseScopeString)(scope);
    const isEvmRequest = (namespace === utils_1.KnownCaipNamespace.Wallet &&
        (!reference || reference === utils_1.KnownCaipNamespace.Eip155)) ||
        namespace === utils_1.KnownCaipNamespace.Eip155;
    const unwrappedRequest = {
        ...request,
        scope,
        method: wrappedRequest.method,
        params: wrappedRequest.params,
    };
    if (isEvmRequest) {
        let networkClientId;
        if (namespace === utils_1.KnownCaipNamespace.Wallet) {
            networkClientId = hooks.getSelectedNetworkClientId();
        }
        else if (namespace === utils_1.KnownCaipNamespace.Eip155) {
            if (reference) {
                networkClientId = hooks.findNetworkClientIdByChainId((0, utils_1.numberToHex)(parseInt(reference, 10)));
            }
        }
        if (!networkClientId) {
            console.error('failed to resolve network client for wallet_invokeMethod', request);
            return end(rpc_errors_1.rpcErrors.internal());
        }
        Object.assign(request, {
            ...unwrappedRequest,
            networkClientId,
        });
        return next();
    }
    try {
        response.result = await hooks.handleNonEvmRequestForOrigin({
            connectedAddresses: scopeObject.accounts,
            // Type assertion: We know that scope is not "wallet" by now because it
            // is already being handled above.
            scope: scope,
            request: unwrappedRequest,
        });
    }
    catch (err) {
        return end(err);
    }
    return end();
}
exports.walletInvokeMethod = {
    methodNames: ['wallet_invokeMethod'],
    implementation: walletInvokeMethodHandler,
    hookNames: {
        getCaveatForOrigin: true,
        findNetworkClientIdByChainId: true,
        getSelectedNetworkClientId: true,
        getNonEvmSupportedMethods: true,
        handleNonEvmRequestForOrigin: true,
    },
};

      };
    };
  }
  }
}, {package:"@metamask/multichain-api-middleware",file:"node_modules\\@metamask\\multichain-api-middleware\\dist\\handlers\\wallet-invokeMethod.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\dist\\handlers\\wallet-revokeSession.cjs", {"@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-api-middleware%5Cdist%5Chandlers%5Cwallet-revokeSession.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.walletRevokeSession = void 0;
const chain_agnostic_permission_1 = require("@metamask/chain-agnostic-permission");
const permission_controller_1 = require("@metamask/permission-controller");
const rpc_errors_1 = require("@metamask/rpc-errors");
/**
 * Revokes specific session scopes from an existing caveat.
 * Fully revokes permission if no accounts remain permitted after iterating through scopes.
 *
 * @param scopes - Array of scope strings to remove from the caveat.
 * @param hooks - The hooks object.
 * @param hooks.revokePermissionForOrigin - The hook for revoking a permission for an origin function.
 * @param hooks.updateCaveat - The hook used to conditionally update the caveat rather than fully revoke the permission.
 * @param hooks.getCaveatForOrigin - The hook to fetch an existing caveat for the origin of the request.
 */
function partialRevokePermissions(scopes, hooks) {
    let updatedCaveatValue = hooks.getCaveatForOrigin(chain_agnostic_permission_1.Caip25EndowmentPermissionName, chain_agnostic_permission_1.Caip25CaveatType).value;
    for (const scopeString of scopes) {
        const result = chain_agnostic_permission_1.Caip25CaveatMutators[chain_agnostic_permission_1.Caip25CaveatType].removeScope(updatedCaveatValue, scopeString);
        // If operation is a Noop, it means a scope was passed that was not present in the permission, so we proceed with the loop
        if (result.operation === permission_controller_1.CaveatMutatorOperation.Noop) {
            continue;
        }
        updatedCaveatValue = result?.value ?? {
            requiredScopes: {},
            optionalScopes: {},
            sessionProperties: {},
            isMultichainOrigin: true,
        };
    }
    const caipAccountIds = (0, chain_agnostic_permission_1.getCaipAccountIdsFromCaip25CaveatValue)(updatedCaveatValue);
    // We fully revoke permission if no accounts are left after scope removal loop.
    if (!caipAccountIds.length) {
        hooks.revokePermissionForOrigin(chain_agnostic_permission_1.Caip25EndowmentPermissionName);
    }
    else {
        hooks.updateCaveat(chain_agnostic_permission_1.Caip25EndowmentPermissionName, chain_agnostic_permission_1.Caip25CaveatType, updatedCaveatValue);
    }
}
/**
 * Handler for the `wallet_revokeSession` RPC method as specified by [CAIP-285](https://chainagnostic.org/CAIPs/caip-285).
 * The implementation below deviates from the linked spec in that it ignores the `sessionId` param
 * and instead revokes the singular session for the origin if available. Additionally,
 * the handler also does not return an error if there is currently no active session and instead
 * returns true which is the same result returned if an active session was actually revoked.
 *
 * @param request - The JSON-RPC request object. Unused.
 * @param response - The JSON-RPC response object.
 * @param _next - The next middleware function. Unused.
 * @param end - The end callback function.
 * @param hooks - The hooks object.
 * @param hooks.revokePermissionForOrigin - The hook for revoking a permission for an origin function.
 * @param hooks.updateCaveat - The hook used to conditionally update the caveat rather than fully revoke the permission.
 * @param hooks.getCaveatForOrigin - The hook to fetch an existing caveat for the origin of the request.
 * @returns Nothing.
 */
async function walletRevokeSessionHandler(request, response, _next, end, hooks) {
    const { params: { scopes }, } = request;
    try {
        if (scopes?.length) {
            partialRevokePermissions(scopes, hooks);
        }
        else {
            hooks.revokePermissionForOrigin(chain_agnostic_permission_1.Caip25EndowmentPermissionName);
        }
    }
    catch (err) {
        if (!(err instanceof permission_controller_1.UnrecognizedSubjectError) &&
            !(err instanceof permission_controller_1.PermissionDoesNotExistError)) {
            console.error(err);
            return end(rpc_errors_1.rpcErrors.internal());
        }
    }
    response.result = true;
    return end();
}
exports.walletRevokeSession = {
    methodNames: ['wallet_revokeSession'],
    implementation: walletRevokeSessionHandler,
    hookNames: {
        revokePermissionForOrigin: true,
        updateCaveat: true,
        getCaveatForOrigin: true,
    },
};

      };
    };
  }
  }
}, {package:"@metamask/multichain-api-middleware",file:"node_modules\\@metamask\\multichain-api-middleware\\dist\\handlers\\wallet-revokeSession.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\dist\\index.cjs", {"./handlers/types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\dist\\handlers\\types.cjs","./handlers/wallet-createSession.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\dist\\handlers\\wallet-createSession.cjs","./handlers/wallet-getSession.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\dist\\handlers\\wallet-getSession.cjs","./handlers/wallet-invokeMethod.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\dist\\handlers\\wallet-invokeMethod.cjs","./handlers/wallet-revokeSession.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\dist\\handlers\\wallet-revokeSession.cjs","./middlewares/MultichainMiddlewareManager.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\dist\\middlewares\\MultichainMiddlewareManager.cjs","./middlewares/MultichainSubscriptionManager.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\dist\\middlewares\\MultichainSubscriptionManager.cjs","./middlewares/multichainMethodCallValidatorMiddleware.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\dist\\middlewares\\multichainMethodCallValidatorMiddleware.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-api-middleware%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultichainApiNotifications = exports.MultichainSubscriptionManager = exports.MultichainMiddlewareManager = exports.multichainMethodCallValidatorMiddleware = exports.walletRevokeSession = exports.walletInvokeMethod = exports.walletGetSession = exports.walletCreateSession = void 0;
var wallet_createSession_1 = require("./handlers/wallet-createSession.cjs");
Object.defineProperty(exports, "walletCreateSession", { enumerable: true, get: function () { return wallet_createSession_1.walletCreateSession; } });
var wallet_getSession_1 = require("./handlers/wallet-getSession.cjs");
Object.defineProperty(exports, "walletGetSession", { enumerable: true, get: function () { return wallet_getSession_1.walletGetSession; } });
var wallet_invokeMethod_1 = require("./handlers/wallet-invokeMethod.cjs");
Object.defineProperty(exports, "walletInvokeMethod", { enumerable: true, get: function () { return wallet_invokeMethod_1.walletInvokeMethod; } });
var wallet_revokeSession_1 = require("./handlers/wallet-revokeSession.cjs");
Object.defineProperty(exports, "walletRevokeSession", { enumerable: true, get: function () { return wallet_revokeSession_1.walletRevokeSession; } });
var multichainMethodCallValidatorMiddleware_1 = require("./middlewares/multichainMethodCallValidatorMiddleware.cjs");
Object.defineProperty(exports, "multichainMethodCallValidatorMiddleware", { enumerable: true, get: function () { return multichainMethodCallValidatorMiddleware_1.multichainMethodCallValidatorMiddleware; } });
var MultichainMiddlewareManager_1 = require("./middlewares/MultichainMiddlewareManager.cjs");
Object.defineProperty(exports, "MultichainMiddlewareManager", { enumerable: true, get: function () { return MultichainMiddlewareManager_1.MultichainMiddlewareManager; } });
var MultichainSubscriptionManager_1 = require("./middlewares/MultichainSubscriptionManager.cjs");
Object.defineProperty(exports, "MultichainSubscriptionManager", { enumerable: true, get: function () { return MultichainSubscriptionManager_1.MultichainSubscriptionManager; } });
var types_1 = require("./handlers/types.cjs");
Object.defineProperty(exports, "MultichainApiNotifications", { enumerable: true, get: function () { return types_1.MultichainApiNotifications; } });

      };
    };
  }
  }
}, {package:"@metamask/multichain-api-middleware",file:"node_modules\\@metamask\\multichain-api-middleware\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\dist\\middlewares\\MultichainMiddlewareManager.cjs", {"@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-api-middleware%5Cdist%5Cmiddlewares%5CMultichainMiddlewareManager.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var _MultichainMiddlewareManager_instances, _MultichainMiddlewareManager_middlewares, _MultichainMiddlewareManager_getMiddlewareEntry, _MultichainMiddlewareManager_removeMiddlewareEntry, _MultichainMiddlewareManager_removeMiddleware;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultichainMiddlewareManager = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
// Methods related to eth_subscriptions
const SubscriptionMethods = ['eth_subscribe', 'eth_unsubscribe'];
/**
 * A helper that facilates registering and calling of provided middleware instances
 * in the RPC pipeline based on the incoming request's scope, origin, and tabId.
 * The core purpose of this class is to enable and manage multichain subscriptions
 * (i.e. eth_subscribe called accross different chains and domains).
 *
 * Note that only one middleware instance can be registered per scope, origin, tabId key.
 */
class MultichainMiddlewareManager {
    constructor() {
        _MultichainMiddlewareManager_instances.add(this);
        _MultichainMiddlewareManager_middlewares.set(this, []);
    }
    addMiddleware(middlewareEntry) {
        const { scope, origin, tabId } = middlewareEntry;
        if (!__classPrivateFieldGet(this, _MultichainMiddlewareManager_instances, "m", _MultichainMiddlewareManager_getMiddlewareEntry).call(this, { scope, origin, tabId })) {
            __classPrivateFieldGet(this, _MultichainMiddlewareManager_middlewares, "f").push(middlewareEntry);
        }
    }
    removeMiddlewareByScope(scope) {
        __classPrivateFieldGet(this, _MultichainMiddlewareManager_middlewares, "f").forEach((middlewareEntry) => {
            if (middlewareEntry.scope === scope) {
                __classPrivateFieldGet(this, _MultichainMiddlewareManager_instances, "m", _MultichainMiddlewareManager_removeMiddleware).call(this, middlewareEntry);
            }
        });
    }
    removeMiddlewareByScopeAndOrigin(scope, origin) {
        __classPrivateFieldGet(this, _MultichainMiddlewareManager_middlewares, "f").forEach((middlewareEntry) => {
            if (middlewareEntry.scope === scope &&
                middlewareEntry.origin === origin) {
                __classPrivateFieldGet(this, _MultichainMiddlewareManager_instances, "m", _MultichainMiddlewareManager_removeMiddleware).call(this, middlewareEntry);
            }
        });
    }
    removeMiddlewareByOriginAndTabId(origin, tabId) {
        __classPrivateFieldGet(this, _MultichainMiddlewareManager_middlewares, "f").forEach((middlewareEntry) => {
            if (middlewareEntry.origin === origin &&
                middlewareEntry.tabId === tabId) {
                __classPrivateFieldGet(this, _MultichainMiddlewareManager_instances, "m", _MultichainMiddlewareManager_removeMiddleware).call(this, middlewareEntry);
            }
        });
    }
    generateMultichainMiddlewareForOriginAndTabId(origin, tabId) {
        const middleware = (req, res, next, end) => {
            const { scope } = req;
            const middlewareEntry = __classPrivateFieldGet(this, _MultichainMiddlewareManager_instances, "m", _MultichainMiddlewareManager_getMiddlewareEntry).call(this, {
                scope,
                origin,
                tabId,
            });
            if (SubscriptionMethods.includes(req.method)) {
                if (middlewareEntry) {
                    middlewareEntry.middleware(req, res, next, end);
                }
                else {
                    // TODO: Temporary safety guard to prevent requests with these methods
                    // from being forwarded to the RPC endpoint even though this scenario
                    // should not be possible.
                    return end(rpc_errors_1.rpcErrors.methodNotFound());
                }
            }
            else {
                return next();
            }
            return undefined;
        };
        middleware.destroy = this.removeMiddlewareByOriginAndTabId.bind(this, origin, tabId);
        return middleware;
    }
}
exports.MultichainMiddlewareManager = MultichainMiddlewareManager;
_MultichainMiddlewareManager_middlewares = new WeakMap(), _MultichainMiddlewareManager_instances = new WeakSet(), _MultichainMiddlewareManager_getMiddlewareEntry = function _MultichainMiddlewareManager_getMiddlewareEntry({ scope, origin, tabId, }) {
    return __classPrivateFieldGet(this, _MultichainMiddlewareManager_middlewares, "f").find((middlewareEntry) => {
        return (middlewareEntry.scope === scope &&
            middlewareEntry.origin === origin &&
            middlewareEntry.tabId === tabId);
    });
}, _MultichainMiddlewareManager_removeMiddlewareEntry = function _MultichainMiddlewareManager_removeMiddlewareEntry({ scope, origin, tabId }) {
    __classPrivateFieldSet(this, _MultichainMiddlewareManager_middlewares, __classPrivateFieldGet(this, _MultichainMiddlewareManager_middlewares, "f").filter((middlewareEntry) => {
        return (middlewareEntry.scope !== scope ||
            middlewareEntry.origin !== origin ||
            middlewareEntry.tabId !== tabId);
    }), "f");
}, _MultichainMiddlewareManager_removeMiddleware = function _MultichainMiddlewareManager_removeMiddleware(middlewareEntry) {
    // When the destroy function on the middleware is async,
    // we don't need to wait for it complete
    Promise.resolve(middlewareEntry.middleware.destroy?.()).catch(() => {
        // do nothing
    });
    __classPrivateFieldGet(this, _MultichainMiddlewareManager_instances, "m", _MultichainMiddlewareManager_removeMiddlewareEntry).call(this, middlewareEntry);
};

      };
    };
  }
  }
}, {package:"@metamask/multichain-api-middleware",file:"node_modules\\@metamask\\multichain-api-middleware\\dist\\middlewares\\MultichainMiddlewareManager.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\dist\\middlewares\\MultichainSubscriptionManager.cjs", {"../handlers/types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\dist\\handlers\\types.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/eth-json-rpc-filters/subscriptionManager.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-json-rpc-filters\\subscriptionManager.js","@metamask/safe-event-emitter":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\safe-event-emitter\\dist\\cjs\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-api-middleware%5Cdist%5Cmiddlewares%5CMultichainSubscriptionManager.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _MultichainSubscriptionManager_instances, _MultichainSubscriptionManager_findNetworkClientIdByChainId, _MultichainSubscriptionManager_getNetworkClientById, _MultichainSubscriptionManager_subscriptions, _MultichainSubscriptionManager_getSubscriptionEntry, _MultichainSubscriptionManager_removeSubscriptionEntry, _MultichainSubscriptionManager_unsubscribe;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultichainSubscriptionManager = void 0;
const controller_utils_1 = require("@metamask/controller-utils");
const subscriptionManager_1 = __importDefault(require("@metamask/eth-json-rpc-filters/subscriptionManager.js"));
const safe_event_emitter_1 = __importDefault(require("@metamask/safe-event-emitter"));
const utils_1 = require("@metamask/utils");
const types_1 = require("../handlers/types.cjs");
/**
 * A helper that facilates the lifecycle of a SubscriptionManager instance that
 * is meant to handle subscriptons for only one specific scope, origin, and tabId combination.
 */
class MultichainSubscriptionManager extends safe_event_emitter_1.default {
    /**
     * Construct a MultichainSubscriptionManager.
     *
     * @param options - The controller options.
     * @param options.findNetworkClientIdByChainId - The hook to get the networkClientId from a chainId.
     * @param options.getNetworkClientById - The hook to get the network client instance by its networkClientId.
     */
    constructor(options) {
        super();
        _MultichainSubscriptionManager_instances.add(this);
        _MultichainSubscriptionManager_findNetworkClientIdByChainId.set(this, void 0);
        _MultichainSubscriptionManager_getNetworkClientById.set(this, void 0);
        _MultichainSubscriptionManager_subscriptions.set(this, []);
        __classPrivateFieldSet(this, _MultichainSubscriptionManager_findNetworkClientIdByChainId, options.findNetworkClientIdByChainId, "f");
        __classPrivateFieldSet(this, _MultichainSubscriptionManager_getNetworkClientById, options.getNetworkClientById, "f");
    }
    notify({ scope, origin, tabId }, { method, params }) {
        this.emit('notification', origin, tabId, {
            method: types_1.MultichainApiNotifications.walletNotify,
            params: {
                scope,
                notification: { method, params },
            },
        });
    }
    subscribe(subscriptionKey) {
        const subscriptionEntry = __classPrivateFieldGet(this, _MultichainSubscriptionManager_instances, "m", _MultichainSubscriptionManager_getSubscriptionEntry).call(this, subscriptionKey);
        if (subscriptionEntry) {
            return subscriptionEntry.subscriptionManager;
        }
        const networkClientId = __classPrivateFieldGet(this, _MultichainSubscriptionManager_findNetworkClientIdByChainId, "f").call(this, (0, controller_utils_1.toHex)((0, utils_1.parseCaipChainId)(subscriptionKey.scope).reference));
        const networkClient = __classPrivateFieldGet(this, _MultichainSubscriptionManager_getNetworkClientById, "f").call(this, networkClientId);
        const subscriptionManager = (0, subscriptionManager_1.default)({
            blockTracker: networkClient.blockTracker,
            provider: networkClient.provider,
        });
        subscriptionManager.events.on('notification', (message) => {
            this.notify(subscriptionKey, message);
        });
        const newSubscriptionManagerEntry = {
            ...subscriptionKey,
            subscriptionManager,
        };
        subscriptionManager.destroy = subscriptionManager.middleware.destroy;
        subscriptionManager.middleware.destroy = __classPrivateFieldGet(this, _MultichainSubscriptionManager_instances, "m", _MultichainSubscriptionManager_unsubscribe).bind(this, newSubscriptionManagerEntry);
        __classPrivateFieldGet(this, _MultichainSubscriptionManager_subscriptions, "f").push(newSubscriptionManagerEntry);
        return subscriptionManager;
    }
    unsubscribeByScope(scope) {
        __classPrivateFieldGet(this, _MultichainSubscriptionManager_subscriptions, "f").forEach((subscriptionEntry) => {
            if (subscriptionEntry.scope === scope) {
                __classPrivateFieldGet(this, _MultichainSubscriptionManager_instances, "m", _MultichainSubscriptionManager_unsubscribe).call(this, subscriptionEntry);
            }
        });
    }
    unsubscribeByScopeAndOrigin(scope, origin) {
        __classPrivateFieldGet(this, _MultichainSubscriptionManager_subscriptions, "f").forEach((subscriptionEntry) => {
            if (subscriptionEntry.scope === scope &&
                subscriptionEntry.origin === origin) {
                __classPrivateFieldGet(this, _MultichainSubscriptionManager_instances, "m", _MultichainSubscriptionManager_unsubscribe).call(this, subscriptionEntry);
            }
        });
    }
    unsubscribeByOriginAndTabId(origin, tabId) {
        __classPrivateFieldGet(this, _MultichainSubscriptionManager_subscriptions, "f").forEach((subscriptionEntry) => {
            if (subscriptionEntry.origin === origin &&
                subscriptionEntry.tabId === tabId) {
                __classPrivateFieldGet(this, _MultichainSubscriptionManager_instances, "m", _MultichainSubscriptionManager_unsubscribe).call(this, subscriptionEntry);
            }
        });
    }
}
exports.MultichainSubscriptionManager = MultichainSubscriptionManager;
_MultichainSubscriptionManager_findNetworkClientIdByChainId = new WeakMap(), _MultichainSubscriptionManager_getNetworkClientById = new WeakMap(), _MultichainSubscriptionManager_subscriptions = new WeakMap(), _MultichainSubscriptionManager_instances = new WeakSet(), _MultichainSubscriptionManager_getSubscriptionEntry = function _MultichainSubscriptionManager_getSubscriptionEntry({ scope, origin, tabId, }) {
    return __classPrivateFieldGet(this, _MultichainSubscriptionManager_subscriptions, "f").find((subscriptionEntry) => {
        return (subscriptionEntry.scope === scope &&
            subscriptionEntry.origin === origin &&
            subscriptionEntry.tabId === tabId);
    });
}, _MultichainSubscriptionManager_removeSubscriptionEntry = function _MultichainSubscriptionManager_removeSubscriptionEntry({ scope, origin, tabId }) {
    __classPrivateFieldSet(this, _MultichainSubscriptionManager_subscriptions, __classPrivateFieldGet(this, _MultichainSubscriptionManager_subscriptions, "f").filter((subscriptionEntry) => {
        return (subscriptionEntry.scope !== scope ||
            subscriptionEntry.origin !== origin ||
            subscriptionEntry.tabId !== tabId);
    }), "f");
}, _MultichainSubscriptionManager_unsubscribe = function _MultichainSubscriptionManager_unsubscribe(subscriptionEntry) {
    subscriptionEntry.subscriptionManager.destroy?.();
    __classPrivateFieldGet(this, _MultichainSubscriptionManager_instances, "m", _MultichainSubscriptionManager_removeSubscriptionEntry).call(this, subscriptionEntry);
};

      };
    };
  }
  }
}, {package:"@metamask/multichain-api-middleware",file:"node_modules\\@metamask\\multichain-api-middleware\\dist\\middlewares\\MultichainSubscriptionManager.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\dist\\middlewares\\multichainMethodCallValidatorMiddleware.cjs", {"@metamask/api-specs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\node_modules\\@metamask\\api-specs\\dist\\index.js","@metamask/json-rpc-engine":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-engine\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","@open-rpc/schema-utils-js/build/dereference-document.js":"D:\\code\\v\\metamask-extension\\node_modules\\@open-rpc\\schema-utils-js\\build\\dereference-document.js","@open-rpc/schema-utils-js/build/parse-open-rpc-document.js":"D:\\code\\v\\metamask-extension\\node_modules\\@open-rpc\\schema-utils-js\\build\\parse-open-rpc-document.js","jsonschema":"D:\\code\\v\\metamask-extension\\node_modules\\jsonschema\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-api-middleware%5Cdist%5Cmiddlewares%5CmultichainMethodCallValidatorMiddleware.cjs
      return function (require, module, exports) {
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.multichainMethodCallValidatorMiddleware = void 0;
const api_specs_1 = require("@metamask/api-specs");
const json_rpc_engine_1 = require("@metamask/json-rpc-engine");
const rpc_errors_1 = require("@metamask/rpc-errors");
const utils_1 = require("@metamask/utils");
const dereference_document_1 = __importDefault(require("@open-rpc/schema-utils-js/build/dereference-document.js"));
const parse_open_rpc_document_1 = require("@open-rpc/schema-utils-js/build/parse-open-rpc-document.js");
const jsonschema_1 = require("jsonschema");
const transformError = (error, param, got) => {
    // if there is a path, add it to the message
    const message = `${param.name}${error.path.length > 0 ? `.${error.path.join('.')}` : ''} ${error.message}`;
    return rpc_errors_1.rpcErrors.invalidParams({
        message,
        data: {
            param: param.name,
            path: error.path,
            schema: error.schema,
            got,
        },
    });
};
const v = new jsonschema_1.Validator();
const dereffedPromise = (0, dereference_document_1.default)(api_specs_1.MultiChainOpenRPCDocument, (0, parse_open_rpc_document_1.makeCustomResolver)({}));
/**
 * Helper that utilizes the Multichain method specifications from `@metamask/api-specs`
 * to validate the params of a Multichain request.
 *
 * @param method - The request's method.
 * @param params - The request's optional JsonRpcParams object.
 * @returns an array of error objects for each validation error or an empty array if no errors.
 */
const multichainMethodCallValidator = async (method, params) => {
    const dereffed = await dereffedPromise;
    const methodToCheck = dereffed.methods.find((m) => m.name === method);
    if (!methodToCheck ||
        !(0, utils_1.isObject)(methodToCheck) ||
        !('params' in methodToCheck)) {
        return [rpc_errors_1.rpcErrors.methodNotFound({ data: { method } })];
    }
    const errors = [];
    for (const param of methodToCheck.params) {
        if (!(0, utils_1.isObject)(params)) {
            return [rpc_errors_1.rpcErrors.invalidParams()];
        }
        const p = param;
        const paramToCheck = params[p.name];
        const result = v.validate(paramToCheck, p.schema, {
            required: p.required,
        });
        if (result.errors) {
            errors.push(...result.errors.map((e) => {
                return transformError(e, p, paramToCheck);
            }));
        }
    }
    return errors;
};
/**
 * Middleware that validates the params of a Multichain method request
 * using the specifications from `@metamask/api-specs`.
 */
exports.multichainMethodCallValidatorMiddleware = (0, json_rpc_engine_1.createAsyncMiddleware)(async (request, _response, next) => {
    const errors = await multichainMethodCallValidator(request.method, request.params);
    if (errors.length > 0) {
        throw rpc_errors_1.rpcErrors.invalidParams({ data: errors });
    }
    return await next();
});

      };
    };
  }
  }
}, {package:"@metamask/multichain-api-middleware",file:"node_modules\\@metamask\\multichain-api-middleware\\dist\\middlewares\\multichainMethodCallValidatorMiddleware.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\node_modules\\@metamask\\api-specs\\dist\\build\\multichain-openrpc.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-api-middleware%5Cnode_modules%5C@metamask%5Capi-specs%5Cdist%5Cbuild%5Cmultichain-openrpc.json
      return function (require, module, exports) {
module.exports={
    "openrpc": "1.2.4",
    "info": {
        "title": "MetaMask MultiChain API",
        "version": "1.0.0",
        "description": "This provides the specs for the MultiChain API Layer for the MetaMask API"
    },
    "methods": [
        {
            "name": "wallet_notify",
            "paramStructure": "by-name",
            "params": [
                {
                    "name": "scope",
                    "description": "a valid `scope` string that has been previously authorized via `provider_authorize`",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/ScopeString"
                    }
                },
                {
                    "name": "notification",
                    "description": "an object containing a JSON-RPC notification with `method` and `params`",
                    "deprecated": false,
                    "required": true,
                    "schema": {
                        "type": "object",
                        "properties": {
                            "method": {
                                "type": "string"
                            },
                            "params": true
                        }
                    }
                }
            ]
        },
        {
            "name": "wallet_invokeMethod",
            "paramStructure": "by-name",
            "params": [
                {
                    "name": "scope",
                    "description": "a valid `scope` string that has been previously authorized via `provider_authorize`",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/ScopeString"
                    }
                },
                {
                    "name": "request",
                    "description": "an object containing a JSON-RPC request with `method` and `params`",
                    "deprecated": false,
                    "required": true,
                    "schema": {
                        "type": "object",
                        "properties": {
                            "method": {
                                "type": "string"
                            },
                            "params": true
                        }
                    }
                }
            ],
            "result": {
                "name": "wallet_invokeMethodResult",
                "schema": true
            },
            "examples": [
                {
                    "name": "wallet_invokeMethodExample",
                    "params": [
                        {
                            "name": "scope",
                            "value": "eip155:1"
                        },
                        {
                            "name": "request",
                            "value": {
                                "method": "eth_getBalance",
                                "params": []
                            }
                        }
                    ],
                    "result": {
                        "name": "wallet_invokeMethodResult",
                        "value": "0x1"
                    }
                }
            ]
        },
        {
            "name": "wallet_revokeSession",
            "description": "The `wallet_revokeSession` method revokes the entire active session.",
            "params": [],
            "result": {
                "name": "wallet_revokeSessionResult",
                "schema": {
                    "type": "boolean"
                }
            },
            "examples": [
                {
                    "name": "wallet_revokeSessionExample",
                    "params": [],
                    "result": {
                        "name": "wallet_revokeSessionExampleResult",
                        "value": true
                    }
                }
            ],
            "errors": [
                {
                    "$ref": "#/components/errors/UnknownError"
                }
            ]
        },
        {
            "name": "wallet_sessionChanged",
            "paramStructure": "by-name",
            "description": "This notification is published by the wallet to notify the callers of updates to a shared session's authorization scopes. The event payload contains the new `sessionScopes`.",
            "params": [
                {
                    "name": "sessionScopes",
                    "schema": {
                        "$ref": "#/components/schemas/SessionScopes"
                    }
                }
            ],
            "examples": [
                {
                    "name": "wallet_sessionChangedExample",
                    "description": "Example of a wallet_sessionChanged notification.",
                    "params": [
                        {
                            "name": "sessionScopes",
                            "value": {
                                "eip155:1337": {
                                    "accounts": [
                                        "eip155:1337:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"
                                    ],
                                    "methods": [
                                        "personal_sign",
                                        "eth_signTypedData_v4",
                                        "wallet_watchAsset",
                                        "eth_sendTransaction",
                                        "eth_decrypt",
                                        "eth_getEncryptionPublicKey",
                                        "web3_clientVersion",
                                        "eth_subscribe",
                                        "eth_unsubscribe",
                                        "wallet_swapAsset",
                                        "eth_blockNumber",
                                        "eth_call",
                                        "eth_chainId",
                                        "eth_estimateGas",
                                        "eth_feeHistory",
                                        "eth_gasPrice",
                                        "eth_getBalance",
                                        "eth_getBlockByHash",
                                        "eth_getBlockByNumber",
                                        "eth_getBlockTransactionCountByHash",
                                        "eth_getBlockTransactionCountByNumber",
                                        "eth_getCode",
                                        "eth_getFilterChanges",
                                        "eth_getFilterLogs",
                                        "eth_getLogs",
                                        "eth_getProof",
                                        "eth_getStorageAt",
                                        "eth_getTransactionByBlockHashAndIndex",
                                        "eth_getTransactionByBlockNumberAndIndex",
                                        "eth_getTransactionByHash",
                                        "eth_getTransactionCount",
                                        "eth_getTransactionReceipt",
                                        "eth_getUncleCountByBlockHash",
                                        "eth_getUncleCountByBlockNumber",
                                        "eth_newBlockFilter",
                                        "eth_newFilter",
                                        "eth_newPendingTransactionFilter",
                                        "eth_sendRawTransaction",
                                        "eth_syncing",
                                        "eth_uninstallFilter"
                                    ],
                                    "notifications": [
                                        "eth_subscription"
                                    ]
                                },
                                "wallet": {
                                    "accounts": [],
                                    "methods": [
                                        "wallet_registerOnboarding",
                                        "wallet_scanQRCode"
                                    ],
                                    "notifications": []
                                },
                                "wallet:eip155": {
                                    "accounts": [
                                        "wallet:eip155:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"
                                    ],
                                    "methods": [
                                        "wallet_addEthereumChain"
                                    ],
                                    "notifications": []
                                }
                            }
                        }
                    ]
                }
            ]
        },
        {
            "name": "wallet_getSession",
            "description": "The `wallet_getSession` method returns an active session.",
            "params": [],
            "result": {
                "name": "wallet_getSessionResult",
                "schema": {
                    "type": "object",
                    "properties": {
                        "sessionScopes": {
                            "$ref": "#/components/schemas/SessionScopes"
                        }
                    }
                }
            },
            "examples": [
                {
                    "name": "wallet_getSessionExample",
                    "description": "Example of a getSession request.",
                    "params": [],
                    "result": {
                        "name": "wallet_getSessionResultExample",
                        "value": {
                            "sessionScopes": {
                                "eip155:1337": {
                                    "accounts": [
                                        "eip155:1337:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"
                                    ],
                                    "methods": [
                                        "personal_sign",
                                        "eth_signTypedData_v4",
                                        "wallet_watchAsset",
                                        "eth_sendTransaction",
                                        "eth_decrypt",
                                        "eth_getEncryptionPublicKey",
                                        "web3_clientVersion",
                                        "eth_subscribe",
                                        "eth_unsubscribe",
                                        "wallet_swapAsset",
                                        "eth_blockNumber",
                                        "eth_call",
                                        "eth_chainId",
                                        "eth_estimateGas",
                                        "eth_feeHistory",
                                        "eth_gasPrice",
                                        "eth_getBalance",
                                        "eth_getBlockByHash",
                                        "eth_getBlockByNumber",
                                        "eth_getBlockTransactionCountByHash",
                                        "eth_getBlockTransactionCountByNumber",
                                        "eth_getCode",
                                        "eth_getFilterChanges",
                                        "eth_getFilterLogs",
                                        "eth_getLogs",
                                        "eth_getProof",
                                        "eth_getStorageAt",
                                        "eth_getTransactionByBlockHashAndIndex",
                                        "eth_getTransactionByBlockNumberAndIndex",
                                        "eth_getTransactionByHash",
                                        "eth_getTransactionCount",
                                        "eth_getTransactionReceipt",
                                        "eth_getUncleCountByBlockHash",
                                        "eth_getUncleCountByBlockNumber",
                                        "eth_newBlockFilter",
                                        "eth_newFilter",
                                        "eth_newPendingTransactionFilter",
                                        "eth_sendRawTransaction",
                                        "eth_syncing",
                                        "eth_uninstallFilter"
                                    ],
                                    "notifications": [
                                        "eth_subscription"
                                    ]
                                },
                                "wallet": {
                                    "accounts": [],
                                    "methods": [
                                        "wallet_registerOnboarding",
                                        "wallet_scanQRCode"
                                    ],
                                    "notifications": []
                                },
                                "wallet:eip155": {
                                    "accounts": [
                                        "wallet:eip155:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"
                                    ],
                                    "methods": [
                                        "wallet_addEthereumChain"
                                    ],
                                    "notifications": []
                                }
                            }
                        }
                    }
                }
            ]
        },
        {
            "name": "wallet_createSession",
            "paramStructure": "by-name",
            "params": [
                {
                    "name": "requiredScopes",
                    "description": "Scopes that the wallet must support in order to be used with this provider.",
                    "schema": {
                        "type": "object",
                        "patternProperties": {
                            "[-a-z0-9]{3,8}(:[-_a-zA-Z0-9]{1,32})?": {
                                "$ref": "#/components/schemas/Scope"
                            }
                        }
                    }
                },
                {
                    "name": "optionalScopes",
                    "description": "Scopes that the wallet may support in order to be used with this provider.",
                    "schema": {
                        "type": "object",
                        "patternProperties": {
                            "[-a-z0-9]{3,8}(:[-_a-zA-Z0-9]{1,32})?": {
                                "$ref": "#/components/schemas/Scope"
                            }
                        }
                    }
                },
                {
                    "name": "sessionProperties",
                    "description": "Properties that the wallet may use to determine if the session is valid.",
                    "schema": {
                        "type": "object"
                    }
                }
            ],
            "result": {
                "name": "wallet_createSessionResult",
                "schema": {
                    "type": "object",
                    "properties": {
                        "sessionScopes": {
                            "$ref": "#/components/schemas/SessionScopes"
                        },
                        "sessionProperties": {
                            "type": "object"
                        }
                    }
                }
            },
            "examples": [
                {
                    "name": "wallet_createSessionEthExample",
                    "description": "Example of a createSession request.",
                    "params": [
                        {
                            "name": "optionalScopes",
                            "value": {
                                "eip155:1337": {
                                    "methods": [
                                        "wallet_watchAsset",
                                        "eth_sendTransaction",
                                        "eth_decrypt",
                                        "eth_getEncryptionPublicKey",
                                        "web3_clientVersion",
                                        "eth_subscribe",
                                        "eth_unsubscribe",
                                        "eth_blockNumber",
                                        "eth_call",
                                        "eth_chainId",
                                        "eth_estimateGas",
                                        "eth_feeHistory",
                                        "eth_gasPrice",
                                        "eth_getBalance",
                                        "eth_getBlockByHash",
                                        "eth_getBlockByNumber",
                                        "eth_getBlockTransactionCountByHash",
                                        "eth_getBlockTransactionCountByNumber",
                                        "eth_getCode",
                                        "eth_getFilterChanges",
                                        "eth_getFilterLogs",
                                        "eth_getLogs",
                                        "eth_getProof",
                                        "eth_getStorageAt",
                                        "eth_getTransactionByBlockHashAndIndex",
                                        "eth_getTransactionByBlockNumberAndIndex",
                                        "eth_getTransactionByHash",
                                        "eth_getTransactionCount",
                                        "eth_getTransactionReceipt",
                                        "eth_getUncleCountByBlockHash",
                                        "eth_getUncleCountByBlockNumber",
                                        "eth_newBlockFilter",
                                        "eth_newFilter",
                                        "eth_newPendingTransactionFilter",
                                        "eth_sendRawTransaction",
                                        "eth_syncing",
                                        "eth_uninstallFilter"
                                    ],
                                    "notifications": [
                                        "eth_subscription"
                                    ]
                                },
                                "wallet": {
                                    "methods": [
                                        "wallet_registerOnboarding",
                                        "wallet_scanQRCode"
                                    ],
                                    "notifications": []
                                },
                                "wallet:eip155": {
                                    "methods": [
                                        "wallet_addEthereumChain"
                                    ],
                                    "notifications": []
                                }
                            }
                        }
                    ],
                    "result": {
                        "name": "wallet_createSessionResultExample",
                        "value": {
                            "sessionProperties": {},
                            "sessionScopes": {
                                "eip155:1337": {
                                    "accounts": [
                                        "eip155:1337:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"
                                    ],
                                    "methods": [
                                        "personal_sign",
                                        "eth_signTypedData_v4",
                                        "wallet_watchAsset",
                                        "eth_sendTransaction",
                                        "eth_decrypt",
                                        "eth_getEncryptionPublicKey",
                                        "web3_clientVersion",
                                        "eth_subscribe",
                                        "eth_unsubscribe",
                                        "wallet_swapAsset",
                                        "eth_blockNumber",
                                        "eth_call",
                                        "eth_chainId",
                                        "eth_estimateGas",
                                        "eth_feeHistory",
                                        "eth_gasPrice",
                                        "eth_getBalance",
                                        "eth_getBlockByHash",
                                        "eth_getBlockByNumber",
                                        "eth_getBlockTransactionCountByHash",
                                        "eth_getBlockTransactionCountByNumber",
                                        "eth_getCode",
                                        "eth_getFilterChanges",
                                        "eth_getFilterLogs",
                                        "eth_getLogs",
                                        "eth_getProof",
                                        "eth_getStorageAt",
                                        "eth_getTransactionByBlockHashAndIndex",
                                        "eth_getTransactionByBlockNumberAndIndex",
                                        "eth_getTransactionByHash",
                                        "eth_getTransactionCount",
                                        "eth_getTransactionReceipt",
                                        "eth_getUncleCountByBlockHash",
                                        "eth_getUncleCountByBlockNumber",
                                        "eth_newBlockFilter",
                                        "eth_newFilter",
                                        "eth_newPendingTransactionFilter",
                                        "eth_sendRawTransaction",
                                        "eth_syncing",
                                        "eth_uninstallFilter"
                                    ],
                                    "notifications": [
                                        "eth_subscription"
                                    ]
                                },
                                "wallet": {
                                    "accounts": [],
                                    "methods": [
                                        "wallet_registerOnboarding",
                                        "wallet_scanQRCode"
                                    ],
                                    "notifications": []
                                },
                                "wallet:eip155": {
                                    "accounts": [
                                        "wallet:eip155:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"
                                    ],
                                    "methods": [
                                        "wallet_addEthereumChain"
                                    ],
                                    "notifications": []
                                }
                            }
                        }
                    }
                },
                {
                    "name": "wallet_createSessionEthUnsupportedMethodsExample",
                    "description": "Example of a createSession request with unsupported eip155 methods.",
                    "params": [
                        {
                            "name": "optionalScopes",
                            "value": {
                                "eip155:1337": {
                                    "methods": [
                                        "not_supported"
                                    ],
                                    "notifications": []
                                },
                                "wallet": {
                                    "methods": [],
                                    "notifications": []
                                },
                                "wallet:eip155": {
                                    "methods": [],
                                    "notifications": []
                                }
                            }
                        }
                    ],
                    "result": {
                        "name": "wallet_createSessionEthUnsupportedMethodsResultExample",
                        "value": {
                            "sessionProperties": {},
                            "sessionScopes": {
                                "eip155:1337": {
                                    "accounts": [
                                        "eip155:1337:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"
                                    ],
                                    "methods": [
                                        "personal_sign",
                                        "eth_signTypedData_v4",
                                        "wallet_watchAsset",
                                        "eth_sendTransaction",
                                        "eth_decrypt",
                                        "eth_getEncryptionPublicKey",
                                        "web3_clientVersion",
                                        "eth_subscribe",
                                        "eth_unsubscribe",
                                        "wallet_swapAsset",
                                        "eth_blockNumber",
                                        "eth_call",
                                        "eth_chainId",
                                        "eth_estimateGas",
                                        "eth_feeHistory",
                                        "eth_gasPrice",
                                        "eth_getBalance",
                                        "eth_getBlockByHash",
                                        "eth_getBlockByNumber",
                                        "eth_getBlockTransactionCountByHash",
                                        "eth_getBlockTransactionCountByNumber",
                                        "eth_getCode",
                                        "eth_getFilterChanges",
                                        "eth_getFilterLogs",
                                        "eth_getLogs",
                                        "eth_getProof",
                                        "eth_getStorageAt",
                                        "eth_getTransactionByBlockHashAndIndex",
                                        "eth_getTransactionByBlockNumberAndIndex",
                                        "eth_getTransactionByHash",
                                        "eth_getTransactionCount",
                                        "eth_getTransactionReceipt",
                                        "eth_getUncleCountByBlockHash",
                                        "eth_getUncleCountByBlockNumber",
                                        "eth_newBlockFilter",
                                        "eth_newFilter",
                                        "eth_newPendingTransactionFilter",
                                        "eth_sendRawTransaction",
                                        "eth_syncing",
                                        "eth_uninstallFilter"
                                    ],
                                    "notifications": [
                                        "eth_subscription"
                                    ]
                                },
                                "wallet": {
                                    "accounts": [],
                                    "methods": [
                                        "wallet_registerOnboarding",
                                        "wallet_scanQRCode"
                                    ],
                                    "notifications": []
                                },
                                "wallet:eip155": {
                                    "accounts": [
                                        "wallet:eip155:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"
                                    ],
                                    "methods": [
                                        "wallet_addEthereumChain"
                                    ],
                                    "notifications": []
                                }
                            }
                        }
                    }
                },
                {
                    "name": "wallet_createSessionUnsupportedScopesExample",
                    "description": "Example of a createSession request with unsupported scopes.",
                    "params": [
                        {
                            "name": "optionalScopes",
                            "value": {
                                "foobar": {
                                    "methods": [
                                        "eth_getBalance"
                                    ],
                                    "notifications": [
                                        "eth_subscription"
                                    ]
                                },
                                "eip155:1": {
                                    "accounts": [
                                        "eip155:1:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"
                                    ],
                                    "methods": [
                                        "personal_sign",
                                        "eth_signTypedData_v4",
                                        "wallet_watchAsset",
                                        "eth_sendTransaction",
                                        "eth_decrypt",
                                        "eth_getEncryptionPublicKey",
                                        "web3_clientVersion",
                                        "eth_subscribe",
                                        "eth_unsubscribe",
                                        "wallet_swapAsset",
                                        "eth_blockNumber",
                                        "eth_call",
                                        "eth_chainId",
                                        "eth_estimateGas",
                                        "eth_feeHistory",
                                        "eth_gasPrice",
                                        "eth_getBalance",
                                        "eth_getBlockByHash",
                                        "eth_getBlockByNumber",
                                        "eth_getBlockTransactionCountByHash",
                                        "eth_getBlockTransactionCountByNumber",
                                        "eth_getCode",
                                        "eth_getFilterChanges",
                                        "eth_getFilterLogs",
                                        "eth_getLogs",
                                        "eth_getProof",
                                        "eth_getStorageAt",
                                        "eth_getTransactionByBlockHashAndIndex",
                                        "eth_getTransactionByBlockNumberAndIndex",
                                        "eth_getTransactionByHash",
                                        "eth_getTransactionCount",
                                        "eth_getTransactionReceipt",
                                        "eth_getUncleCountByBlockHash",
                                        "eth_getUncleCountByBlockNumber",
                                        "eth_newBlockFilter",
                                        "eth_newFilter",
                                        "eth_newPendingTransactionFilter",
                                        "eth_sendRawTransaction",
                                        "eth_syncing",
                                        "eth_uninstallFilter"
                                    ],
                                    "notifications": [
                                        "eth_subscription"
                                    ]
                                }
                            }
                        }
                    ],
                    "result": {
                        "name": "wallet_createSessionUnsupportedScopesResultExample",
                        "value": {
                            "sessionProperties": {},
                            "sessionScopes": {
                                "eip155:1": {
                                    "accounts": [
                                        "eip155:1:0x5cfe73b6021e818b776b421b1c4db2474086a7e1"
                                    ],
                                    "methods": [
                                        "personal_sign",
                                        "eth_signTypedData_v4",
                                        "wallet_watchAsset",
                                        "eth_sendTransaction",
                                        "eth_decrypt",
                                        "eth_getEncryptionPublicKey",
                                        "web3_clientVersion",
                                        "eth_subscribe",
                                        "eth_unsubscribe",
                                        "wallet_swapAsset",
                                        "eth_blockNumber",
                                        "eth_call",
                                        "eth_chainId",
                                        "eth_estimateGas",
                                        "eth_feeHistory",
                                        "eth_gasPrice",
                                        "eth_getBalance",
                                        "eth_getBlockByHash",
                                        "eth_getBlockByNumber",
                                        "eth_getBlockTransactionCountByHash",
                                        "eth_getBlockTransactionCountByNumber",
                                        "eth_getCode",
                                        "eth_getFilterChanges",
                                        "eth_getFilterLogs",
                                        "eth_getLogs",
                                        "eth_getProof",
                                        "eth_getStorageAt",
                                        "eth_getTransactionByBlockHashAndIndex",
                                        "eth_getTransactionByBlockNumberAndIndex",
                                        "eth_getTransactionByHash",
                                        "eth_getTransactionCount",
                                        "eth_getTransactionReceipt",
                                        "eth_getUncleCountByBlockHash",
                                        "eth_getUncleCountByBlockNumber",
                                        "eth_newBlockFilter",
                                        "eth_newFilter",
                                        "eth_newPendingTransactionFilter",
                                        "eth_sendRawTransaction",
                                        "eth_syncing",
                                        "eth_uninstallFilter"
                                    ],
                                    "notifications": [
                                        "eth_subscription"
                                    ]
                                }
                            }
                        }
                    }
                }
            ],
            "errors": [
                {
                    "$ref": "#/components/errors/UnknownError"
                },
                {
                    "code": 5100,
                    "message": "Requested networks are not supported"
                },
                {
                    "code": 5101,
                    "message": "Requested methods are not supported"
                },
                {
                    "code": 5102,
                    "message": "Requested notifications are not supported"
                },
                {
                    "code": 5300,
                    "message": "Invalid scopedProperties requested"
                },
                {
                    "code": 5301,
                    "message": "scopedProperties can only be outside of sessionScopes"
                },
                {
                    "code": 5302,
                    "message": "Invalid sessionProperties requested"
                }
            ]
        }
    ],
    "components": {
        "errors": {
            "UnknownError": {
                "code": 5000,
                "message": "Unknown error with request"
            }
        },
        "schemas": {
            "SessionScopes": {
                "type": "object",
                "patternProperties": {
                    "[-a-z0-9]{3,8}(:[-_a-zA-Z0-9]{1,32})?": {
                        "$ref": "#/components/schemas/Scope"
                    }
                }
            },
            "ScopeString": {
                "type": "string",
                "pattern": "[-a-z0-9]{3,8}(:[-_a-zA-Z0-9]{1,32})?"
            },
            "Scope": {
                "type": "object",
                "title": "Scope",
                "description": "Scope for a multi-chain connection",
                "additionalProperties": true,
                "required": [
                    "notifications",
                    "methods"
                ],
                "properties": {
                    "scopes": {
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/ScopeString"
                        }
                    },
                    "methods": {
                        "description": "Methods that the wallet must support in order to be used with this provider.",
                        "type": "array",
                        "items": {
                            "type": "string"
                        }
                    },
                    "notifications": {
                        "description": "Notifications that the wallet must support in order to be used with this provider.",
                        "type": "array",
                        "items": {
                            "type": "string"
                        }
                    },
                    "rpcEndpoints": {
                        "description": "JSON-RPC endpoints for this namespace.",
                        "type": "array",
                        "items": {
                            "type": "string",
                            "format": "uri"
                        }
                    },
                    "rpcDocuments": {
                        "type": "array",
                        "description": "OpenRPC documents that define RPC methods in which to anchor the methods authorized in a CAIP-25 interaction.",
                        "items": {
                            "type": "string",
                            "format": "uri"
                        }
                    }
                }
            }
        }
    }
}

      };
    };
  }
  }
}, {package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules\\@metamask\\multichain-api-middleware\\node_modules\\@metamask\\api-specs\\dist\\build\\multichain-openrpc.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\node_modules\\@metamask\\api-specs\\dist\\build\\openrpc.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-api-middleware%5Cnode_modules%5C@metamask%5Capi-specs%5Cdist%5Cbuild%5Copenrpc.json
      return function (require, module, exports) {
module.exports={
    "openrpc": "1.2.4",
    "info": {
        "title": "JSON-RPC API",
        "version": "1.0.0",
        "description": "This section provides an interactive reference for MetaMask's Wallet JSON-RPC API. The API builds on a set of standard Ethereum methods with MetaMask-specific enhancements, and is designed for seamless integration into dapps."
    },
    "methods": [
        {
            "name": "wallet_addEthereumChain",
            "tags": [
                {
                    "$ref": "#/components/tags/MetaMask"
                },
                {
                    "$ref": "#/components/tags/Multichain"
                }
            ],
            "summary": "Adds an Ethereum chain to the wallet.",
            "description": "Creates a confirmation asking the user to add the specified chain to the wallet application. The caller must specify a chain ID and some chain metadata. Specified by [EIP-3085](https://eips.ethereum.org/EIPS/eip-3085).",
            "params": [
                {
                    "name": "Chain",
                    "schema": {
                        "$ref": "#/components/schemas/AddEthereumChainParameter"
                    }
                }
            ],
            "errors": [
                {
                    "code": -32602,
                    "message": "Expected null or array with at least one valid string HTTPS URL 'blockExplorerUrl'. Received: ${blockExplorerUrls}"
                },
                {
                    "code": -32602,
                    "message": "Expected 0x-prefixed, unpadded, non-zero hexadecimal string 'chainId'. Received:\n${chainId}"
                },
                {
                    "code": -32602,
                    "message": "Invalid chain ID \"${_chainId}\": numerical value greater than max safe value. Received:\n${chainId}"
                },
                {
                    "code": -32602,
                    "message": "May not specify default MetaMask chain."
                },
                {
                    "code": -32602,
                    "message": "Expected 2-6 character string 'nativeCurrency.symbol'. Received:\n${ticker}"
                },
                {
                    "code": -32602,
                    "message": "nativeCurrency.symbol does not match currency symbol for a network the user already has added with the same chainId. Received:\n${ticker}"
                }
            ],
            "result": {
                "name": "Null response",
                "description": "This method returns `null` if the chain is added.",
                "schema": {
                    "type": "null"
                }
            },
            "examples": [
                {
                    "name": "wallet_addEthereumChain example",
                    "params": [
                        {
                            "name": "Chain",
                            "value": {
                                "chainId": "0x64",
                                "chainName": "Gnosis",
                                "rpcUrls": [
                                    "https://rpc.gnosischain.com"
                                ],
                                "iconUrls": [
                                    "https://xdaichain.com/fake/example/url/xdai.svg",
                                    "https://xdaichain.com/fake/example/url/xdai.png"
                                ],
                                "nativeCurrency": {
                                    "name": "XDAI",
                                    "symbol": "XDAI",
                                    "decimals": 18
                                },
                                "blockExplorerUrls": [
                                    "https://blockscout.com/poa/xdai/"
                                ]
                            }
                        }
                    ],
                    "result": {
                        "name": "Null response",
                        "value": "null"
                    }
                }
            ]
        },
        {
            "name": "wallet_switchEthereumChain",
            "tags": [
                {
                    "$ref": "#/components/tags/MetaMask"
                }
            ],
            "summary": "Switches the wallet's active Ethereum chain.",
            "description": "Requests that the wallet switches its active Ethereum chain. Specified by [EIP-3326](https://eips.ethereum.org/EIPS/eip-3326).",
            "params": [
                {
                    "name": "Chain",
                    "schema": {
                        "title": "Chain",
                        "description": "Object containing the chain ID to switch to.",
                        "type": "object",
                        "required": [
                            "chainId"
                        ],
                        "properties": {
                            "chainId": {
                                "description": "The chain ID as a `0x`-prefixed hexadecimal string, as returned by the `eth_chainId` method.",
                                "type": "string"
                            }
                        }
                    }
                }
            ],
            "result": {
                "name": "Null response",
                "description": "This method returns `null` if the active chain is switched.",
                "schema": {
                    "type": "null"
                }
            },
            "errors": [
                {
                    "code": 4902,
                    "message": "Unrecognized chain ID. Try adding the chain using wallet_addEthereumChain first."
                }
            ],
            "examples": [
                {
                    "name": "wallet_switchEthereumChain example",
                    "params": [
                        {
                            "name": "Chain",
                            "value": {
                                "chainId": "0x64"
                            }
                        }
                    ],
                    "result": {
                        "name": "Null response",
                        "value": "null"
                    }
                }
            ]
        },
        {
            "name": "wallet_getPermissions",
            "tags": [
                {
                    "$ref": "#/components/tags/MetaMask"
                }
            ],
            "summary": "Gets the user's permissions.",
            "description": "Gets the user's permissions. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",
            "params": [],
            "result": {
                "name": "Permissions list",
                "schema": {
                    "$ref": "#/components/schemas/PermissionsList"
                }
            },
            "examples": [
                {
                    "name": "wallet_getPermissions example",
                    "params": [],
                    "result": {
                        "name": "Permission list",
                        "value": {
                            "eth_accounts": {}
                        }
                    }
                }
            ]
        },
        {
            "name": "wallet_requestPermissions",
            "tags": [
                {
                    "$ref": "#/components/tags/MetaMask"
                }
            ],
            "summary": "Requests additional permissions.",
            "description": "Requests additional permissions from the user. This method accepts a single permission per call. Specified by [EIP-2255](https://eips.ethereum.org/EIPS/eip-2255).",
            "params": [
                {
                    "name": "Permission",
                    "required": true,
                    "schema": {
                        "title": "Permission",
                        "description": "Object containing the permission to request.",
                        "type": "object",
                        "properties": {
                            "permission_name": {
                                "type": "object",
                                "description": "The permission object. `permission_name` is the name of the permission being requested.",
                                "additionalProperties": true
                            }
                        }
                    }
                }
            ],
            "result": {
                "name": "Permissions list",
                "schema": {
                    "$ref": "#/components/schemas/PermissionsList"
                }
            },
            "examples": [
                {
                    "name": "wallet_requestPermissions example",
                    "params": [
                        {
                            "name": "Permission",
                            "value": {
                                "eth_accounts": {}
                            }
                        }
                    ],
                    "result": {
                        "name": "Permission list",
                        "value": {
                            "eth_accounts": {}
                        }
                    }
                }
            ],
            "errors": [
                {
                    "$ref": "#/components/errors/UserRejected"
                }
            ]
        },
        {
            "name": "wallet_revokePermissions",
            "tags": [
                {
                    "$ref": "#/components/tags/MetaMask"
                },
                {
                    "$ref": "#/components/tags/Experimental"
                }
            ],
            "summary": "Revokes the current dapp permissions.",
            "description": "Revokes previously granted permissions for the current dapp identified by its origin. This method accepts a single permission per call. Specified by [MIP-2](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-2.md) and only available for the MetaMask browser extension.",
            "params": [
                {
                    "name": "Permission",
                    "required": true,
                    "schema": {
                        "title": "Permission",
                        "description": "Object containing the permission to revoke.",
                        "type": "object",
                        "properties": {
                            "permission_name": {
                                "type": "object",
                                "description": "The permission object. `permission_name` is the name of the permission being revoked.",
                                "additionalProperties": true
                            }
                        }
                    }
                }
            ],
            "result": {
                "name": "Null response",
                "description": "This method returns `null` if the permission is revoked.",
                "schema": {
                    "type": "null"
                }
            },
            "errors": [],
            "examples": [
                {
                    "name": "wallet_revokePermissions example",
                    "params": [
                        {
                            "name": "Permission",
                            "value": {
                                "eth_accounts": {}
                            }
                        }
                    ],
                    "result": {
                        "name": "Null response",
                        "value": "null"
                    }
                }
            ]
        },
        {
            "name": "personal_sign",
            "tags": [
                {
                    "$ref": "#/components/tags/MetaMask"
                },
                {
                    "$ref": "#/components/tags/Restricted"
                },
                {
                    "$ref": "#/components/tags/Multichain"
                }
            ],
            "summary": "Presents a plain text signature challenge to the user.",
            "description": "Presents a plain text signature challenge to the user and returns the signed response. Prepends a safe prefix to the signed message to prevent the challenge tricking users into signing a financial transaction. <br><br> MetaMask implements `personal_sign` similarly to the Go Ethereum client's `eth_sign` implementation. MetaMask's `personal_sign` doesn't accept a password. <br><br> This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",
            "deprecated": false,
            "params": [
                {
                    "name": "Challenge",
                    "required": true,
                    "description": "A hex-encoded UTF-8 string to present to the user. See how to encode a string like this in the [`browser-string-hexer`](https://github.com/danfinlay/browser-string-hexer) module.",
                    "schema": {
                        "type": "string",
                        "pattern": "^0x[a-fA-F\\d]+$"
                    }
                },
                {
                    "name": "Address",
                    "required": true,
                    "description": "The address of the requested signing account.",
                    "schema": {
                        "type": "string",
                        "pattern": "^0x[0-9a-fA-F]{40}$"
                    }
                }
            ],
            "result": {
                "name": "Signature",
                "description": "A hex-encoded signature.",
                "schema": {
                    "type": "string",
                    "pattern": "^0x[0-9a-f]*$"
                }
            },
            "examples": [
                {
                    "name": "personal_sign example",
                    "params": [
                        {
                            "name": "Challenge",
                            "value": "0x506c65617365207369676e2074686973206d65737361676520746f20636f6e6669726d20796f7572206964656e746974792e"
                        },
                        {
                            "name": "Address",
                            "value": "0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"
                        }
                    ],
                    "result": {
                        "name": "Signature",
                        "value": "0x43d7215ebe96c09a5adac69fc76dea5647286b501954ea273e417cf65e6c80e1db4891826375a7de02467a3e01caf125f64c851a8e9ee9467fd6f7e83523b2115bed8e79d527a85e28a36807d79b85fc551b5c15c1ead2e43456c31f565219203db2aed86cb3601b33ec3b410836d4be7718c6148dc9ac82ecc0a04c5edecd8914"
                    }
                }
            ]
        },
        {
            "name": "eth_signTypedData_v4",
            "tags": [
                {
                    "$ref": "#/components/tags/MetaMask"
                },
                {
                    "$ref": "#/components/tags/Restricted"
                },
                {
                    "$ref": "#/components/tags/Multichain"
                }
            ],
            "summary": "Presents a structured data message for the user to sign.",
            "description": "Presents a data message for the user to sign in a structured and readable format and returns the signed response. Introduced by [EIP-712](https://eips.ethereum.org/EIPS/eip-712). This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",
            "params": [
                {
                    "name": "Address",
                    "required": true,
                    "description": "The address of the requested signing account.",
                    "schema": {
                        "type": "string",
                        "pattern": "^0x[0-9a-fA-F]{40}$"
                    }
                },
                {
                    "name": "Typed data",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/TypedData"
                    }
                }
            ],
            "result": {
                "name": "Signature",
                "description": "A hex-encoded signature.",
                "schema": {
                    "type": "string",
                    "pattern": "^0x[0-9a-f]*$"
                }
            },
            "examples": [
                {
                    "name": "eth_SignTypedData_v4 example",
                    "params": [
                        {
                            "name": "Address",
                            "value": "0x0000000000000000000000000000000000000000"
                        },
                        {
                            "name": "Typed data",
                            "value": {
                                "types": {
                                    "EIP712Domain": [
                                        {
                                            "name": "name",
                                            "type": "string"
                                        },
                                        {
                                            "name": "version",
                                            "type": "string"
                                        },
                                        {
                                            "name": "chainId",
                                            "type": "uint256"
                                        },
                                        {
                                            "name": "verifyingContract",
                                            "type": "address"
                                        }
                                    ],
                                    "Person": [
                                        {
                                            "name": "name",
                                            "type": "string"
                                        },
                                        {
                                            "name": "wallet",
                                            "type": "address"
                                        }
                                    ],
                                    "Mail": [
                                        {
                                            "name": "from",
                                            "type": "Person"
                                        },
                                        {
                                            "name": "to",
                                            "type": "Person"
                                        },
                                        {
                                            "name": "contents",
                                            "type": "string"
                                        }
                                    ]
                                },
                                "primaryType": "Mail",
                                "domain": {
                                    "name": "Ether Mail",
                                    "version": "1",
                                    "chainId": 1,
                                    "verifyingContract": "0xCcCCccccCCCCcCCCCCCcCcCccCcCCCcCcccccccC"
                                },
                                "message": {
                                    "from": {
                                        "name": "Cow",
                                        "wallet": "0xCD2a3d9F938E13CD947Ec05AbC7FE734Df8DD826"
                                    },
                                    "to": {
                                        "name": "Bob",
                                        "wallet": "0xbBbBBBBbbBBBbbbBbbBbbbbBBbBbbbbBbBbbBBbB"
                                    },
                                    "contents": "Hello, Bob!"
                                }
                            }
                        }
                    ],
                    "result": {
                        "name": "Signature",
                        "value": "0x4355c47d63924e8a72e509b65029052eb6c299d53a04e167c5775fd466751c9d07299936d304c153f6443dfa05f40ff007d72911b6f72307f996231605b915621c"
                    }
                }
            ]
        },
        {
            "name": "wallet_registerOnboarding",
            "tags": [
                {
                    "$ref": "#/components/tags/MetaMask"
                },
                {
                    "$ref": "#/components/tags/Multichain"
                }
            ],
            "summary": "Redirects the user back to the site after onboarding.",
            "description": "Registers the requesting site with MetaMask as the initiator of onboarding, enabling MetaMask to redirect the user back to the site after onboarding. Returns a promise that resolves to `true`, or rejects the request if there's an error. Instead of calling this method directly, you should use the [`@metamask/onboarding`](https://github.com/MetaMask/metamask-onboarding) library.",
            "params": [],
            "result": {
                "name": "Registered",
                "description": "`true` if the request was successful, `false` otherwise.",
                "schema": {
                    "type": "boolean"
                }
            },
            "examples": [
                {
                    "name": "wallet_registerOnboarding example",
                    "params": [],
                    "result": {
                        "name": "Registered",
                        "value": true
                    }
                }
            ]
        },
        {
            "name": "wallet_watchAsset",
            "tags": [
                {
                    "$ref": "#/components/tags/MetaMask"
                },
                {
                    "$ref": "#/components/tags/Experimental"
                },
                {
                    "$ref": "#/components/tags/Multichain"
                }
            ],
            "summary": "Tracks a token in MetaMask.",
            "description": "Requests that the user track the specified token in MetaMask. Returns a boolean indicating if the token was successfully added. Once added, the token is indistinguishable from those added using legacy methods, such as a centralized registry. Introduced by [EIP-747](https://eips.ethereum.org/EIPS/eip-747).",
            "paramStructure": "by-name",
            "params": [
                {
                    "name": "type",
                    "schema": {
                        "type": "string",
                        "description": "The token type (`ERC20`, `ERC721`, or `ERC1155`). Support for ERC-721 and ERC-1155 tokens is experimental and currently only available on the extension (not on mobile). See [MIP-1](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/MIPs/mip-1.md) and the [MIP proposal lifecycle](https://github.com/MetaMask/metamask-improvement-proposals/blob/main/PROCESS-GUIDE.md#proposal-lifecycle) for more information.",
                        "enum": [
                            "ERC20",
                            "ERC721",
                            "ERC1155"
                        ]
                    },
                    "required": true
                },
                {
                    "name": "options",
                    "schema": {
                        "description": "An object containing information about the token.",
                        "type": "object",
                        "required": [
                            "address"
                        ],
                        "properties": {
                            "address": {
                                "description": "The address of the token contract.",
                                "type": "string"
                            },
                            "symbol": {
                                "description": "A ticker symbol or shorthand, up to 11 characters (optional for ERC-20 tokens).",
                                "minLength": 2,
                                "maxLength": 11,
                                "type": "string"
                            },
                            "decimals": {
                                "description": "The number of token decimals (optional for ERC-20 tokens).",
                                "type": "number"
                            },
                            "image": {
                                "description": "A string URL of the token logo (optional for ERC-20 tokens).",
                                "type": "string"
                            },
                            "tokenId": {
                                "description": "The unique identifier of the NFT (required for ERC-721 and ERC-1155 tokens).",
                                "type": "string"
                            }
                        }
                    }
                }
            ],
            "errors": [
                {
                    "code": -32602,
                    "message": "Must specify address, symbol, and decimals."
                },
                {
                    "code": -32602,
                    "message": "Invalid symbol: not a string."
                },
                {
                    "code": -32602,
                    "message": "Invalid symbol '${symbol}': longer than 11 characters."
                },
                {
                    "code": -32602,
                    "message": "Invalid decimals '${decimals}': must be 0 <= 36."
                },
                {
                    "code": -32602,
                    "message": "Invalid address '${address}'."
                },
                {
                    "code": -32602,
                    "message": "Asset type is required."
                },
                {
                    "code": -32602,
                    "message": "Both address and tokenId are required."
                },
                {
                    "code": -32602,
                    "message": "Invalid address."
                },
                {
                    "code": -32000,
                    "message": "Suggested NFT is not owned by the selected account."
                },
                {
                    "code": -32000,
                    "message": "Suggested NFT of type ${standard} does not match received type ${type}."
                },
                {
                    "code": -32002,
                    "message": "Unable to verify ownership. Possibly because the standard is not supported or the user's currently selected network does not match the chain of the asset in question."
                }
            ],
            "result": {
                "name": "Added",
                "description": "`true` if the token was added, `false` otherwise.",
                "schema": {
                    "type": "boolean"
                }
            },
            "examples": [
                {
                    "name": "wallet_watchAsset ERC-20 example",
                    "params": [
                        {
                            "name": "type",
                            "value": "ERC20"
                        },
                        {
                            "name": "options",
                            "value": {
                                "address": "0xb60e8dd61c5d32be8058bb8eb970870f07233155",
                                "symbol": "FOO",
                                "decimals": 18,
                                "image": "https://foo.io/token-image.svg"
                            }
                        }
                    ],
                    "result": {
                        "name": "Added",
                        "value": true
                    }
                },
                {
                    "name": "wallet_watchAsset ERC-721 example",
                    "params": [
                        {
                            "name": "type",
                            "value": "ERC721"
                        },
                        {
                            "name": "options",
                            "value": {
                                "address": "0x123456789abcdef0123456789abcdef01234567",
                                "tokenId": "42"
                            }
                        }
                    ],
                    "result": {
                        "name": "Added",
                        "value": true
                    }
                },
                {
                    "name": "wallet_watchAsset ERC-1155 example",
                    "params": [
                        {
                            "name": "type",
                            "value": "ERC1155"
                        },
                        {
                            "name": "options",
                            "value": {
                                "address": "0xabcdef0123456789abcdef0123456789abcdef01",
                                "tokenId": "1337"
                            }
                        }
                    ],
                    "result": {
                        "name": "Added",
                        "value": true
                    }
                }
            ]
        },
        {
            "name": "wallet_scanQRCode",
            "tags": [
                {
                    "$ref": "#/components/tags/MetaMask"
                },
                {
                    "$ref": "#/components/tags/Mobile"
                },
                {
                    "$ref": "#/components/tags/Multichain"
                }
            ],
            "summary": "Requests that the user scan a QR code.",
            "description": "Requests that the user scan a QR code using their device camera. Introduced by [EIP-945](https://github.com/ethereum/EIPs/issues/945).",
            "params": [
                {
                    "name": "Regex",
                    "required": false,
                    "description": "A regular expression (regex) string for matching arbitrary QR code strings.",
                    "schema": {
                        "type": "string",
                        "title": "regex"
                    }
                }
            ],
            "result": {
                "name": "QR code string",
                "description": "A string corresponding to the scanned QR code. If a regex string is provided, the resulting string matches it. If no regex string is provided, the resulting string matches an Ethereum address. If neither condition is met, the method returns an error.",
                "schema": {
                    "type": "string",
                    "title": "QR code string"
                }
            }
        },
        {
            "name": "wallet_sendCalls",
            "tags": [
                {
                    "$ref": "#/components/tags/MetaMask"
                }
            ],
            "summary": "Sends a batch of calls.",
            "description": "Requests that the wallet submits a batch of calls. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",
            "params": [
                {
                    "name": "Calls",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/SendCallsParameter"
                    }
                }
            ],
            "result": {
                "name": "Batch result",
                "schema": {
                    "description": "An object containing information about the sent batch.",
                    "type": "object",
                    "properties": {
                        "id": {
                            "description": "The ID of the batch of calls.",
                            "type": "string"
                        },
                        "capabilities": {
                            "description": "Wallets can use this object to attach capability-specific metadata.",
                            "type": "object"
                        }
                    }
                }
            },
            "errors": [
                {
                    "$ref": "#/components/errors/InvalidParams"
                },
                {
                    "code": -32000,
                    "message": "Version not supported."
                },
                {
                    "$ref": "#/components/errors/UserRejected"
                },
                {
                    "$ref": "#/components/errors/Unauthorized"
                },
                {
                    "code": 5700,
                    "message": "The wallet does not support a capability that was not marked as optional."
                },
                {
                    "code": 5710,
                    "message": "EIP-7702 not supported on the specified chain ID."
                },
                {
                    "code": 5720,
                    "message": "There is already a batch submitted with the specified batch ID."
                },
                {
                    "code": 5740,
                    "message": "The batch is too large for the wallet to process."
                },
                {
                    "code": 5750,
                    "message": "EIP-7702 upgrade rejected for this chain and account."
                }
            ],
            "examples": [
                {
                    "name": "wallet_sendCalls example",
                    "params": [
                        {
                            "name": "Calls",
                            "value": {
                                "version": "2.0.0",
                                "from": "0xd46e8dd67c5d32be8058bb8eb970870f07244567",
                                "chainId": "0xaa36a7",
                                "atomicRequired": true,
                                "calls": [
                                    {
                                        "to": "0x54f1C1965B355e1AB9ec3465616136be35bb5Ff7",
                                        "value": "0x0"
                                    },
                                    {
                                        "to": "0x2D48e6f5Ae053e4E918d2be53570961D880905F2",
                                        "value": "0x0"
                                    }
                                ]
                            }
                        }
                    ],
                    "result": {
                        "name": "Batch result",
                        "value": {
                            "id": "0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"
                        }
                    }
                }
            ]
        },
        {
            "name": "wallet_getCallsStatus",
            "tags": [
                {
                    "$ref": "#/components/tags/MetaMask"
                }
            ],
            "summary": "Gets the status of a call batch.",
            "description": "Gets the status of a batch of calls that was previously sent using `wallet_sendCalls`. Specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",
            "params": [
                {
                    "name": "Batch ID",
                    "required": true,
                    "description": "The ID of a batch of calls (the `id` value returned by `wallet_sendCalls`).",
                    "schema": {
                        "type": "string"
                    }
                }
            ],
            "result": {
                "name": "Batch status",
                "schema": {
                    "description": "An object containing status information of the batch of calls.",
                    "type": "object",
                    "properties": {
                        "version": {
                            "description": "The version of the API format.",
                            "type": "string"
                        },
                        "id": {
                            "description": "The ID of the batch of calls.",
                            "$ref": "#/components/schemas/uint"
                        },
                        "chainId": {
                            "description": "The chain ID of the calls.",
                            "$ref": "#/components/schemas/uint"
                        },
                        "status": {
                            "description": "The status code of the batch of calls. Possible values are: <br> <ul>\n  <li>`100` - Pending</li>\n  <li>`200` - Confirmed</li>\n  <li>`400` - Failed offchain</li>\n  <li>`500` - Reverted</li>\n  <li>`600` - Partially reverted</li>\n</ul>",
                            "type": "number"
                        },
                        "atomic": {
                            "description": "`true` if the wallet executed the calls atomically. `false` if the wallet executed the calls non-atomically.",
                            "type": "boolean"
                        },
                        "receipts": {
                            "description": "An array of transaction receipts. If the wallet executed the calls atomically, a single receipt or an array of receipts may be returned, corresponding to how the batch of calls were included onchain.",
                            "type": "array",
                            "items": {
                                "title": "Receipt",
                                "description": "A transaction receipt object.",
                                "type": "object",
                                "properties": {
                                    "logs": {
                                        "description": "An array of log objects.",
                                        "type": "array",
                                        "items": {
                                            "title": "Log",
                                            "description": "An object containing information about the log.",
                                            "type": "object",
                                            "properties": {
                                                "address": {
                                                    "description": "The address that generated the log.",
                                                    "type": "string",
                                                    "pattern": "^0x[0-9a-fA-F]{40}$"
                                                },
                                                "data": {
                                                    "description": "The data of the log.",
                                                    "type": "string",
                                                    "pattern": "^0x[0-9a-f]*$"
                                                },
                                                "topics": {
                                                    "description": "An array of log topics.",
                                                    "type": "array",
                                                    "items": {
                                                        "title": "Topic",
                                                        "description": "A log topic.",
                                                        "type": "string",
                                                        "pattern": "^0x[0-9a-f]*$"
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    "status": {
                                        "description": "The status of the transaction. `0x1` indicates success, and `0x0` indicates failure.",
                                        "type": "string",
                                        "pattern": "^0x[0-1]$"
                                    },
                                    "blockHash": {
                                        "description": "The hash of the block containing the transaction.",
                                        "type": "string",
                                        "pattern": "^0x[0-9a-f]{64}$"
                                    },
                                    "blockNumber": {
                                        "description": "The number of the block containing the transaction.",
                                        "type": "string",
                                        "pattern": "^0x([1-9a-f]+[0-9a-f]*|0)$"
                                    },
                                    "gasUsed": {
                                        "description": "The amount of gas used by the transaction.",
                                        "type": "string",
                                        "pattern": "^0x([1-9a-f]+[0-9a-f]*|0)$"
                                    },
                                    "transactionHash": {
                                        "description": "The hash of the transaction.",
                                        "type": "string",
                                        "pattern": "^0x[0-9a-f]{64}$"
                                    }
                                },
                                "additionalProperties": true
                            }
                        },
                        "capabilities": {
                            "description": "Capabilities associated with the batch of calls.",
                            "type": "object",
                            "additionalProperties": true
                        }
                    }
                }
            },
            "errors": [
                {
                    "$ref": "#/components/errors/InvalidParams"
                },
                {
                    "$ref": "#/components/errors/Unauthorized"
                },
                {
                    "code": 5730,
                    "message": "No matching bundle found."
                }
            ],
            "examples": [
                {
                    "name": "wallet_getCallsStatus example",
                    "params": [
                        {
                            "name": "Batch ID",
                            "value": "0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"
                        }
                    ],
                    "result": {
                        "name": "Batch status",
                        "value": {
                            "version": "2.0.0",
                            "chainId": "0xaa36a7",
                            "id": "0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331",
                            "status": 200,
                            "atomic": true,
                            "receipts": [
                                {
                                    "logs": [
                                        {
                                            "address": "0xa922b54716264130634d6ff183747a8ead91a40b",
                                            "topics": [
                                                "0x5a2a90727cc9d000dd060b1132a5c977c9702bb3a52afe360c9c22f0e9451a68"
                                            ],
                                            "data": "0xabcd"
                                        }
                                    ],
                                    "status": "0x1",
                                    "blockHash": "0xf19bbafd9fd0124ec110b848e8de4ab4f62bf60c189524e54213285e7f540d4a",
                                    "blockNumber": "0xabcd",
                                    "gasUsed": "0xdef",
                                    "transactionHash": "0x9b7bb827c2e5e3c1a0a44dc53e573aa0b3af3bd1f9f5ed03071b100bb039eaff"
                                }
                            ]
                        }
                    }
                }
            ]
        },
        {
            "name": "wallet_getCapabilities",
            "tags": [
                {
                    "$ref": "#/components/tags/MetaMask"
                }
            ],
            "summary": "Gets the capabilities of the wallet.",
            "description": "Returns information about the wallet's support for the `atomic` capability. The `atomic` capability specifies how the wallet will execute batches of transactions sent using `wallet_sendCalls`. `wallet_getCapabilities` is specified by [EIP-5792](https://eips.ethereum.org/EIPS/eip-5792).",
            "params": [
                {
                    "name": "Address",
                    "description": "A wallet address.",
                    "required": true,
                    "schema": {
                        "type": "string",
                        "pattern": "^0x[0-9a-fA-F]{40}$"
                    }
                },
                {
                    "name": "Chain IDs",
                    "description": "An array of chain IDs to get capabilities for.",
                    "schema": {
                        "type": "array",
                        "items": {
                            "title": "Chain ID",
                            "description": "An [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID in hexadecimal format.",
                            "$ref": "#/components/schemas/uint"
                        }
                    }
                }
            ],
            "result": {
                "name": "Capabilities",
                "schema": {
                    "description": "An object specifying the status of the `atomic` capability for specific [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain IDs. For each chain, the `atomic` capability can have a `status` of: <br> <ul>\n  <li>`supported` - The wallet will execute calls sent using\n        `wallet_sendCalls` atomically.</li>\n  <li>`ready` - The wallet can upgrade to `supported` pending user\n          approval to upgrade their account via EIP-7702.</li>\n</ul> If the `atomic` capability is not `supported` or `ready` for a specified chain ID, the wallet will not return anything for that chain ID.",
                    "type": "object"
                }
            },
            "errors": [
                {
                    "$ref": "#/components/errors/InvalidParams"
                },
                {
                    "$ref": "#/components/errors/Unauthorized"
                }
            ],
            "examples": [
                {
                    "name": "wallet_getCapabilities example",
                    "params": [
                        {
                            "name": "Address",
                            "value": "0xd46e8dd67c5d32be8058bb8eb970870f07244567"
                        },
                        {
                            "name": "Chain IDs",
                            "value": [
                                "0xaa36a7"
                            ]
                        }
                    ],
                    "result": {
                        "name": "Capabilities",
                        "value": {
                            "0xaa36a7": {
                                "atomic": {
                                    "status": "ready"
                                }
                            }
                        }
                    }
                }
            ]
        },
        {
            "name": "eth_requestAccounts",
            "tags": [
                {
                    "$ref": "#/components/tags/MetaMask"
                }
            ],
            "description": "Requests that the user provide access to one or more Ethereum addresses. This method is specified by [EIP-1102](https://eips.ethereum.org/EIPS/eip-1102). Internally, this method calls `wallet_requestPermissions` for permission to call `eth_accounts`.",
            "summary": "Requests that the user provide access to addresses.",
            "params": [],
            "result": {
                "name": "Address list",
                "schema": {
                    "type": "array",
                    "description": "An array of Ethereum addresses that the user has authorized the dapp to access.",
                    "items": {
                        "title": "Address",
                        "description": "A hex-encoded address.",
                        "type": "string",
                        "pattern": "^0x[0-9a-fA-F]{40}$"
                    }
                }
            },
            "errors": [
                {
                    "$ref": "#/components/errors/UserRejected"
                }
            ],
            "examples": [
                {
                    "name": "eth_requestAccounts example",
                    "params": [],
                    "result": {
                        "name": "Address list",
                        "value": [
                            "0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"
                        ]
                    }
                }
            ]
        },
        {
            "name": "eth_accounts",
            "tags": [
                {
                    "$ref": "#/components/tags/MetaMask"
                },
                {
                    "$ref": "#/components/tags/Restricted"
                }
            ],
            "description": "Returns a list of addresses that the user has authorized the dapp to access. This method requires calling `wallet_requestPermissions` for permission. We recommend using `eth_requestAccounts`, which internally calls `wallet_requestPermission`.",
            "summary": "Gets a list of authorized addresses.",
            "params": [],
            "result": {
                "name": "Address list",
                "schema": {
                    "type": "array",
                    "description": "An array of Ethereum addresses that the user has authorized the dapp to access.",
                    "items": {
                        "title": "Address",
                        "description": "A hex-encoded address.",
                        "type": "string",
                        "pattern": "^0x[0-9a-fA-F]{40}$"
                    }
                }
            },
            "examples": [
                {
                    "name": "eth_accounts example",
                    "params": [],
                    "result": {
                        "name": "Address list",
                        "value": [
                            "0xa77392123a1085f75e62eec7dea7e0e1e5142d5f"
                        ]
                    }
                }
            ]
        },
        {
            "name": "eth_sendTransaction",
            "tags": [
                {
                    "$ref": "#/components/tags/MetaMask"
                },
                {
                    "$ref": "#/components/tags/Restricted"
                },
                {
                    "$ref": "#/components/tags/Multichain"
                }
            ],
            "description": "Creates a new wallet confirmation to make an Ethereum transaction from the user's account. This method requires that the user has granted permission to interact with their account first, so make sure to call `eth_requestAccounts` (recommended) or `wallet_requestPermissions` first.",
            "summary": "Initiates a new transaction.",
            "params": [
                {
                    "name": "Transaction",
                    "required": true,
                    "description": "The transaction object to sign and send.",
                    "schema": {
                        "type": "object",
                        "title": "Transaction",
                        "description": "The parameters to customize a transaction. If a `to` address is not provided, the transaction is assumed to be a contract creation transaction, and the `data` field is used as the contract initialization code. `gasPrice` cannot be used together with `maxPriorityFeePerGas` and `maxFeePerGas`.",
                        "required": [
                            "from"
                        ],
                        "if": {
                            "properties": {
                                "to": {
                                    "not": {
                                        "type": "string"
                                    }
                                }
                            }
                        },
                        "then": {
                            "required": [
                                "data"
                            ]
                        },
                        "properties": {
                            "to": {
                                "description": "The recipient's address.",
                                "$ref": "#/components/schemas/address"
                            },
                            "from": {
                                "description": "The sender's address.",
                                "$ref": "#/components/schemas/address"
                            },
                            "gas": {
                                "description": "The maximum amount of gas the transaction is allowed to use.",
                                "$ref": "#/components/schemas/uint"
                            },
                            "value": {
                                "description": "The amount to transfer in wei.",
                                "$ref": "#/components/schemas/uint"
                            },
                            "data": {
                                "description": "The data to include in the transaction. Used for contract creation transactions.",
                                "$ref": "#/components/schemas/bytes"
                            },
                            "gasPrice": {
                                "description": "The gas price the sender is willing to pay to miners in wei. Used in pre-1559 transactions.",
                                "$ref": "#/components/schemas/uint"
                            },
                            "maxPriorityFeePerGas": {
                                "description": "Maximum fee per gas the sender is willing to pay to miners in wei. Used in 1559 transactions.",
                                "$ref": "#/components/schemas/uint"
                            },
                            "maxFeePerGas": {
                                "description": "The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei. Used in 1559 transactions.",
                                "$ref": "#/components/schemas/uint"
                            }
                        }
                    }
                }
            ],
            "result": {
                "name": "Transaction hash",
                "description": "The transaction hash of the sent transaction.",
                "schema": {
                    "type": "string",
                    "pattern": "^0x[0-9a-f]{64}$"
                }
            },
            "errors": [
                {
                    "code": 4100,
                    "message": "The requested account and/or method has not been authorized by the user."
                }
            ],
            "examples": [
                {
                    "name": "sendTransaction",
                    "params": [
                        {
                            "name": "Transaction",
                            "value": {
                                "to": "0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7",
                                "from": "0xDeaDbeefdEAdbeefdEadbEEFdeadbeefDEADbEEF",
                                "gas": "0x76c0",
                                "value": "0x8ac7230489e80000",
                                "data": "0x",
                                "gasPrice": "0x4a817c800"
                            }
                        }
                    ],
                    "result": {
                        "name": "eth_sendTransactionExampleResult",
                        "value": "0x4e306b5a5a37532e1734503f7d2427a86f2c992fbe471f5be403b9f734e667c8"
                    }
                }
            ]
        },
        {
            "name": "eth_decrypt",
            "tags": [
                {
                    "$ref": "#/components/tags/MetaMask"
                },
                {
                    "$ref": "#/components/tags/Restricted"
                },
                {
                    "$ref": "#/components/tags/Deprecated"
                }
            ],
            "summary": "Decrypts an encrypted message.",
            "description": "This method is deprecated and may be removed in the future.\n\n Requests that MetaMask decrypt the specified encrypted message.\n The message must have been encrypted using the public encryption key of the specified Ethereum address.\n Returns a promise that resolves to the decrypted message, or rejects if the decryption attempt fails.",
            "params": [
                {
                    "name": "EncryptedMessage",
                    "required": true,
                    "description": "The encrypted message to decrypt.",
                    "schema": {
                        "type": "string"
                    }
                },
                {
                    "name": "Address",
                    "required": true,
                    "description": "The address of the Ethereum account that can decrypt the message.",
                    "schema": {
                        "$ref": "#/components/schemas/address"
                    }
                }
            ],
            "result": {
                "name": "PermissionsList",
                "schema": {
                    "$ref": "#/components/schemas/PermissionsList"
                }
            },
            "errors": [
                {
                    "code": 4100,
                    "message": "The requested account and/or method has not been authorized by the user."
                }
            ],
            "examples": [
                {
                    "name": "decryptExample",
                    "params": [
                        {
                            "name": "EncryptedMessage",
                            "value": "0x7b2276657273696f6e223a227832353531392d7873616c736132302d706f6c7931333035222c226e6f6e6365223a2243533967507076467071765358704655416679726a7179774e35302b7a747766222c22657068656d5075626c69634b6579223a224372774b61456d2f4b356d6d714239764c376f5872636d6441417757764479324f784c3333527135576e553d222c2263697068657274657874223a2248347a65336e7177572b753174663956343945506167454e343872774f766b6952676244566e47587a38493d227d"
                        },
                        {
                            "name": "Address",
                            "value": "0xD1F5279BE4B4dD94133A23deE1B23F5bfC0Db1d0"
                        }
                    ],
                    "result": {
                        "name": "eth_decryptExampleResult",
                        "value": "Hello, Ethereum!"
                    }
                }
            ]
        },
        {
            "name": "eth_getEncryptionPublicKey",
            "tags": [
                {
                    "$ref": "#/components/tags/MetaMask"
                },
                {
                    "$ref": "#/components/tags/Restricted"
                },
                {
                    "$ref": "#/components/tags/Deprecated"
                }
            ],
            "summary": "Gets a public key used for encryption.",
            "description": "This method is deprecated and may be removed in the future.\n\n Requests that the user share their public encryption key.\n Returns a public encryption key, or rejects if the user denies the request.\n The public key is computed from entropy associated with the specified user account, using the NaCl implementation of the `X25519_XSalsa20_Poly1305` algorithm.",
            "params": [
                {
                    "name": "Address",
                    "required": true,
                    "description": "The address of the Ethereum account that can decrypt the message.",
                    "schema": {
                        "$ref": "#/components/schemas/address"
                    }
                }
            ],
            "result": {
                "name": "EncryptionKey",
                "schema": {
                    "type": "string"
                }
            },
            "examples": [
                {
                    "name": "eth_getEncryptionPublicKey",
                    "params": [
                        {
                            "name": "Address",
                            "value": "0x4B0897b0513FdBeEc7C469D9aF4fA6C0752aBea7"
                        }
                    ],
                    "result": {
                        "name": "eth_getEncryptionPublicKeyExampleResult",
                        "value": "0x04bfcab3b7ca7e8b3f3b62b2f7f77e9e4b68080bbf8f0f4a1c8f890864d2c7c1d3c45d8b2e3f5f1c27dfeea4c2f5733e90bfc7484e2a690aa9b8ac4559d2e6a8d7"
                    }
                }
            ]
        },
        {
            "name": "web3_clientVersion",
            "tags": [
                {
                    "$ref": "#/components/tags/Ethereum"
                },
                {
                    "$ref": "#/components/tags/Multichain"
                }
            ],
            "description": "Returns the current MetaMask client version. This differs slightly per client. For example, the browser extension returns a string like `MetaMask/v10.33.1`, while the mobile app returns a string like `MetaMask/8.1.2/Mobile`.",
            "summary": "Current client version.",
            "params": [],
            "examples": [
                {
                    "name": "MetaMaskClientVersionExample",
                    "description": "Example version response from MetaMask.",
                    "params": [],
                    "result": {
                        "name": "MetaMaskClientVersion",
                        "description": "The current client version.",
                        "value": "MetaMask/v10.33.1"
                    }
                },
                {
                    "name": "MetaMaskMobileClientVersionExample",
                    "description": "Example version response from MetaMask Mobile.",
                    "params": [],
                    "result": {
                        "name": "MetaMaskClientVersion",
                        "description": "The current client version.",
                        "value": "MetaMask/8.1.2/Mobile"
                    }
                }
            ],
            "result": {
                "name": "CurrentVersion",
                "description": "The current client version.",
                "schema": {
                    "title": "CurrentClientVersion",
                    "type": "string"
                }
            }
        },
        {
            "name": "eth_subscribe",
            "tags": [
                {
                    "$ref": "#/components/tags/Ethereum"
                },
                {
                    "$ref": "#/components/tags/Multichain"
                }
            ],
            "summary": "Subscribes to specific Ethereum events, returning a subscription ID used to receive notifications.",
            "description": "Subscribes to specific events on the Ethereum network, such as new blocks, or logs. When an event occurs, a notification is sent to the client with the corresponding data. To stop receiving notifications, the client can unsubscribe using `eth_unsubscribe`.",
            "params": [
                {
                    "name": "subscriptionType",
                    "required": true,
                    "schema": {
                        "title": "subscriptionType",
                        "type": "string",
                        "enum": [
                            "newHeads",
                            "logs"
                        ],
                        "description": "The type of subscription to create. Must be one of the following:\n1. `newHeads` - New block headers.\n2. `logs` - Logs matching a filter object."
                    }
                },
                {
                    "name": "filterOptions",
                    "required": false,
                    "schema": {
                        "title": "filterOptions",
                        "type": "object",
                        "description": "(Optional) An object containing filter options specific to the subscription type. Only applicable for the `logs` subscription type.",
                        "required": [
                            "topics"
                        ],
                        "properties": {
                            "address": {
                                "type": "string",
                                "description": "(Optional) A single address or an array of addresses to filter the logs by."
                            },
                            "topics": {
                                "type": "array",
                                "description": "An array of topics to filter the logs by.",
                                "items": {
                                    "type": "string"
                                }
                            }
                        }
                    }
                }
            ],
            "result": {
                "name": "subscriptionId",
                "schema": {
                    "type": "string"
                },
                "description": "A unique subscription ID that can be used to unsubscribe or identify incoming notifications."
            },
            "examples": [
                {
                    "name": "eth_subscribe example",
                    "params": [
                        {
                            "name": "subscriptionType",
                            "value": "newHeads"
                        }
                    ],
                    "result": {
                        "name": "eth_subscribeExampleResult",
                        "value": "0x1b84f2cdf29a204b79e450c1939b30c1"
                    }
                }
            ]
        },
        {
            "name": "eth_unsubscribe",
            "tags": [
                {
                    "$ref": "#/components/tags/Ethereum"
                },
                {
                    "$ref": "#/components/tags/Multichain"
                }
            ],
            "summary": "Unsubscribes from a specific Ethereum event, using the subscription ID provided by `eth_subscribe`.",
            "description": "Unsubscribes from specific events on the Ethereum network, to which the client has been previously subscribed using `eth_subscribe`. The client must provide the subscription ID obtained from `eth_subscribe` to stop receiving notifications for the corresponding event.",
            "params": [
                {
                    "name": "subscriptionId",
                    "required": true,
                    "schema": {
                        "type": "string",
                        "description": "The unique subscription ID obtained from `eth_subscribe`, used to identify the subscription to be unsubscribed."
                    }
                }
            ],
            "result": {
                "name": "unsubscribed",
                "schema": {
                    "type": "boolean"
                },
                "description": "A boolean value indicating whether the unsubscription was successful."
            },
            "examples": [
                {
                    "name": "eth_unsubscribe example",
                    "params": [
                        {
                            "name": "subscriptionId",
                            "value": "0x1b84f2cdf29a204b79e450c1939b30c1"
                        }
                    ],
                    "result": {
                        "name": "eth_unsubscribeExampleResult",
                        "value": true
                    }
                }
            ]
        },
        {
            "name": "eth_blockNumber",
            "summary": "Returns the number of most recent block.",
            "params": [],
            "result": {
                "name": "Block number",
                "schema": {
                    "$ref": "#/components/schemas/uint"
                }
            },
            "examples": [
                {
                    "name": "eth_blockNumber example",
                    "params": [],
                    "result": {
                        "name": "Block number",
                        "value": "0x2377"
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_call",
            "summary": "Executes a new message call immediately without creating a transaction on the block chain.",
            "params": [
                {
                    "name": "Transaction",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/GenericTransaction"
                    }
                },
                {
                    "name": "Block",
                    "required": false,
                    "schema": {
                        "$ref": "#/components/schemas/BlockNumberOrTagOrHash"
                    }
                }
            ],
            "result": {
                "name": "Return data",
                "schema": {
                    "$ref": "#/components/schemas/bytes"
                }
            },
            "examples": [
                {
                    "name": "eth_call example",
                    "params": [
                        {
                            "name": "Transaction",
                            "value": {
                                "to": "0x69498dd54bd25aa0c886cf1f8b8ae0856d55ff13",
                                "value": "0x1"
                            }
                        },
                        {
                            "name": "Block",
                            "value": "latest"
                        }
                    ],
                    "result": {
                        "name": "Return data",
                        "value": "0x"
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_chainId",
            "summary": "Returns the chain ID of the current network.",
            "params": [],
            "result": {
                "name": "Chain ID",
                "schema": {
                    "$ref": "#/components/schemas/uint"
                }
            },
            "examples": [
                {
                    "name": "eth_chainId example",
                    "params": [],
                    "result": {
                        "name": "Chain ID",
                        "value": "0x1"
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_coinbase",
            "summary": "Returns the client coinbase address.",
            "params": [],
            "result": {
                "name": "Coinbase address",
                "schema": {
                    "$ref": "#/components/schemas/address"
                }
            },
            "examples": [
                {
                    "name": "eth_coinbase example",
                    "params": [],
                    "result": {
                        "name": "Coinbase address",
                        "value": "0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_estimateGas",
            "summary": "Generates and returns an estimate of how much gas is necessary to allow the transaction to complete.",
            "params": [
                {
                    "name": "Transaction",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/GenericTransaction"
                    }
                },
                {
                    "name": "Block",
                    "required": false,
                    "schema": {
                        "$ref": "#/components/schemas/BlockNumberOrTag"
                    }
                }
            ],
            "result": {
                "name": "Gas used",
                "schema": {
                    "$ref": "#/components/schemas/uint"
                }
            },
            "examples": [
                {
                    "name": "eth_estimateGas example",
                    "params": [
                        {
                            "name": "Transaction",
                            "value": {
                                "from": "0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",
                                "to": "0x44aa93095d6749a706051658b970b941c72c1d53",
                                "value": "0x1"
                            }
                        }
                    ],
                    "result": {
                        "name": "Gas used",
                        "value": "0x5208"
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_feeHistory",
            "summary": "Transaction fee history",
            "description": "Returns transaction base fee per gas and effective priority fee per gas for the requested/supported block range.",
            "params": [
                {
                    "name": "blockCount",
                    "description": "Requested range of blocks. Clients will return less than the requested range if not all blocks are available.",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/uint"
                    }
                },
                {
                    "name": "newestBlock",
                    "description": "Highest block of the requested range.",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/BlockNumberOrTag"
                    }
                },
                {
                    "name": "rewardPercentiles",
                    "description": "A monotonically increasing list of percentile values. For each block in the requested range, the transactions will be sorted in ascending order by effective tip per gas and the coresponding effective tip for the percentile will be determined, accounting for gas consumed.",
                    "required": true,
                    "schema": {
                        "title": "rewardPercentiles",
                        "type": "array",
                        "items": {
                            "title": "rewardPercentile",
                            "description": "Floating point value between 0 and 100.",
                            "type": "number"
                        }
                    }
                }
            ],
            "result": {
                "name": "Fee history result",
                "description": "Fee history for the returned block range. This can be a subsection of the requested range if not all blocks are available.",
                "schema": {
                    "title": "feeHistoryResults",
                    "description": "Fee history results.",
                    "type": "object",
                    "required": [
                        "oldestBlock",
                        "baseFeePerGas",
                        "gasUsedRatio"
                    ],
                    "additionalProperties": false,
                    "properties": {
                        "oldestBlock": {
                            "title": "oldestBlock",
                            "description": "Lowest number block of returned range.",
                            "$ref": "#/components/schemas/uint"
                        },
                        "baseFeePerGas": {
                            "title": "baseFeePerGasArray",
                            "description": "An array of block base fees per gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-1559 blocks.",
                            "type": "array",
                            "items": {
                                "$ref": "#/components/schemas/uint"
                            }
                        },
                        "baseFeePerBlobGas": {
                            "title": "baseFeePerBlobGasArray",
                            "description": "An array of block base fees per blob gas. This includes the next block after the newest of the returned range, because this value can be derived from the newest block. Zeroes are returned for pre-EIP-4844 blocks.",
                            "type": "array",
                            "items": {
                                "$ref": "#/components/schemas/uint"
                            }
                        },
                        "gasUsedRatio": {
                            "title": "gasUsedRatio",
                            "description": "An array of block gas used ratios. These are calculated as the ratio of gasUsed and gasLimit.",
                            "type": "array",
                            "items": {
                                "$ref": "#/components/schemas/ratio"
                            }
                        },
                        "blobGasUsedRatio": {
                            "title": "blobGasUsedRatio",
                            "description": "An array of block blob gas used ratios. These are calculated as the ratio of blobGasUsed and the max blob gas per block.",
                            "type": "array",
                            "items": {
                                "$ref": "#/components/schemas/ratio"
                            }
                        },
                        "reward": {
                            "title": "rewardArray",
                            "description": "A two-dimensional array of effective priority fees per gas at the requested block percentiles.",
                            "type": "array",
                            "items": {
                                "title": "rewardPercentile",
                                "description": "An array of effective priority fee per gas data points from a single block. All zeroes are returned if the block is empty.",
                                "type": "array",
                                "items": {
                                    "title": "rewardPercentile",
                                    "description": "A given percentile sample of effective priority fees per gas from a single block in ascending order, weighted by gas used. Zeroes are returned if the block is empty.",
                                    "$ref": "#/components/schemas/uint"
                                }
                            }
                        }
                    }
                }
            },
            "examples": [
                {
                    "name": "eth_feeHistory example",
                    "params": [
                        {
                            "name": "blockCount",
                            "value": "0x5"
                        },
                        {
                            "name": "newestblock",
                            "value": "latest"
                        },
                        {
                            "name": "rewardPercentiles",
                            "value": [
                                20,
                                30
                            ]
                        }
                    ],
                    "result": {
                        "name": "Fee history result",
                        "value": {
                            "oldestblock": "0x10b52f",
                            "baseFeePerGas": [
                                "0x3fa63a3f",
                                "0x37f999ee",
                                "0x3e36f20a",
                                "0x4099f79a",
                                "0x430d532d",
                                "0x46fcd4a4"
                            ],
                            "baseFeePerBlobGas": [
                                "0x7b7609c19",
                                "0x6dbe41789",
                                "0x7223341d4",
                                "0x6574a002c",
                                "0x7223341d4",
                                "0x6574a002c"
                            ],
                            "gasUsedRatio": [
                                0.017712333333333333,
                                0.9458865666666667,
                                0.6534561,
                                0.6517375666666667,
                                0.7347769666666667
                            ],
                            "blobGasUsedRatio": [
                                0,
                                0.6666666666666666,
                                0,
                                1,
                                0
                            ],
                            "reward": [
                                [
                                    "0x3b9aca00",
                                    "0x59682f00"
                                ],
                                [
                                    "0x3a13012",
                                    "0x3a13012"
                                ],
                                [
                                    "0x3a13012",
                                    "0x3a13012"
                                ],
                                [
                                    "0xf4240",
                                    "0xf4240"
                                ],
                                [
                                    "0xf4240",
                                    "0xf4240"
                                ]
                            ]
                        }
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_gasPrice",
            "summary": "Returns the current price per gas in wei.",
            "params": [],
            "result": {
                "name": "Gas price",
                "schema": {
                    "title": "Gas price",
                    "$ref": "#/components/schemas/uint"
                }
            },
            "examples": [
                {
                    "name": "eth_gasPrice example",
                    "params": [],
                    "result": {
                        "name": "Gas price",
                        "value": "0x3e8"
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_getBalance",
            "summary": "Returns the balance of the account of given address.",
            "params": [
                {
                    "name": "Address",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/address"
                    }
                },
                {
                    "name": "Block",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/BlockNumberOrTagOrHash"
                    }
                }
            ],
            "result": {
                "name": "Balance",
                "schema": {
                    "$ref": "#/components/schemas/uint"
                }
            },
            "examples": [
                {
                    "name": "eth_getBalance example",
                    "params": [
                        {
                            "name": "Address",
                            "value": "0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"
                        },
                        {
                            "name": "Block",
                            "value": "latest"
                        }
                    ],
                    "result": {
                        "name": "Balance",
                        "value": "0x1cfe56f3795885980000"
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_getBlockByHash",
            "summary": "Returns information about a block by hash.",
            "params": [
                {
                    "name": "Block hash",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/hash32"
                    }
                },
                {
                    "name": "Hydrated transactions",
                    "required": true,
                    "schema": {
                        "title": "hydrated",
                        "type": "boolean"
                    }
                }
            ],
            "result": {
                "name": "Block information",
                "schema": {
                    "oneOf": [
                        {
                            "$ref": "#/components/schemas/notFound"
                        },
                        {
                            "$ref": "#/components/schemas/Block"
                        }
                    ]
                }
            },
            "examples": [
                {
                    "name": "eth_getBlockByHash example",
                    "params": [
                        {
                            "name": "Block hash",
                            "value": "0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c"
                        },
                        {
                            "name": "Hydrated transactions",
                            "value": false
                        }
                    ],
                    "result": {
                        "name": "Block information",
                        "value": {
                            "number": "0x68b3",
                            "hash": "0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",
                            "mixHash": "0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",
                            "parentHash": "0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",
                            "nonce": "0x378da40ff335b070",
                            "sha3Uncles": "0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",
                            "logsBloom": "0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",
                            "transactionsRoot": "0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",
                            "stateRoot": "0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",
                            "receiptsRoot": "0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",
                            "miner": "0xb42b6c4a95406c78ff892d270ad20b22642e102d",
                            "difficulty": "0x66e619a",
                            "totalDifficulty": "0x1e875d746ae",
                            "extraData": "0xd583010502846765746885676f312e37856c696e7578",
                            "size": "0x334",
                            "gasLimit": "0x47e7c4",
                            "gasUsed": "0x37993",
                            "timestamp": "0x5835c54d",
                            "uncles": [],
                            "transactions": [
                                "0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc",
                                "0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"
                            ],
                            "baseFeePerGas": "0x7",
                            "withdrawalsRoot": "0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",
                            "withdrawals": [
                                {
                                    "index": "0x0",
                                    "validatorIndex": "0x9d8c0",
                                    "address": "0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",
                                    "amount": "0x11a33e3760"
                                }
                            ],
                            "blobGasUsed": "0x0",
                            "excessBlobGas": "0x0",
                            "parentBeaconBlockRoot": "0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"
                        }
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_getBlockByNumber",
            "summary": "Returns information about a block by number.",
            "params": [
                {
                    "name": "Block",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/BlockNumberOrTag"
                    }
                },
                {
                    "name": "Hydrated transactions",
                    "required": true,
                    "schema": {
                        "title": "hydrated",
                        "type": "boolean"
                    }
                }
            ],
            "result": {
                "name": "Block information",
                "schema": {
                    "oneOf": [
                        {
                            "$ref": "#/components/schemas/notFound"
                        },
                        {
                            "$ref": "#/components/schemas/Block"
                        }
                    ]
                }
            },
            "examples": [
                {
                    "name": "eth_getBlockByNumber example",
                    "params": [
                        {
                            "name": "block",
                            "value": "0x68b3"
                        },
                        {
                            "name": "Hydrated transactions",
                            "value": false
                        }
                    ],
                    "result": {
                        "name": "Block information",
                        "value": {
                            "number": "0x68b3",
                            "hash": "0xd5f1812548be429cbdc6376b29611fc49e06f1359758c4ceaaa3b393e2239f9c",
                            "mixHash": "0x24900fb3da77674a861c428429dce0762707ecb6052325bbd9b3c64e74b5af9d",
                            "parentHash": "0x1f68ac259155e2f38211ddad0f0a15394d55417b185a93923e2abe71bb7a4d6d",
                            "nonce": "0x378da40ff335b070",
                            "sha3Uncles": "0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347",
                            "logsBloom": "0x00000000000000100000004080000000000500000000000000020000100000000800001000000004000001000000000000000800040010000020100000000400000010000000000000000040000000000000040000000000000000000000000000000400002400000000000000000000000000000004000004000000000000840000000800000080010004000000001000000800000000000000000000000000000000000800000000000040000000020000000000000000000800000400000000000000000000000600000400000000002000000000000000000000004000000000000000100000000000000000000000000000000000040000900010000000",
                            "transactionsRoot": "0x4d0c8e91e16bdff538c03211c5c73632ed054d00a7e210c0eb25146c20048126",
                            "stateRoot": "0x91309efa7e42c1f137f31fe9edbe88ae087e6620d0d59031324da3e2f4f93233",
                            "receiptsRoot": "0x68461ab700003503a305083630a8fb8d14927238f0bc8b6b3d246c0c64f21f4a",
                            "miner": "0xb42b6c4a95406c78ff892d270ad20b22642e102d",
                            "difficulty": "0x66e619a",
                            "totalDifficulty": "0x1e875d746ae",
                            "extraData": "0xd583010502846765746885676f312e37856c696e7578",
                            "size": "0x334",
                            "gasLimit": "0x47e7c4",
                            "gasUsed": "0x37993",
                            "timestamp": "0x5835c54d",
                            "uncles": [],
                            "transactions": [
                                "0xa0807e117a8dd124ab949f460f08c36c72b710188f01609595223b325e58e0fc",
                                "0xeae6d797af50cb62a596ec3939114d63967c374fa57de9bc0f4e2b576ed6639d"
                            ],
                            "baseFeePerGas": "0x7",
                            "withdrawalsRoot": "0x7a4ecf19774d15cf9c15adf0dd8e8a250c128b26c9e2ab2a08d6c9c8ffbd104f",
                            "withdrawals": [
                                {
                                    "index": "0x0",
                                    "validatorIndex": "0x9d8c0",
                                    "address": "0xb9d7934878b5fb9610b3fe8a5e441e8fad7e293f",
                                    "amount": "0x11a33e3760"
                                }
                            ],
                            "blobGasUsed": "0x0",
                            "excessBlobGas": "0x0",
                            "parentBeaconBlockRoot": "0x95c4dbd5b19f6fe3cbc3183be85ff4e85ebe75c5b4fc911f1c91e5b7a554a685"
                        }
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_getBlockTransactionCountByHash",
            "summary": "Returns the number of transactions in a block from a block matching the given block hash.",
            "params": [
                {
                    "name": "Block hash",
                    "schema": {
                        "$ref": "#/components/schemas/hash32"
                    }
                }
            ],
            "result": {
                "name": "Transaction count",
                "schema": {
                    "oneOf": [
                        {
                            "$ref": "#/components/schemas/notFound"
                        },
                        {
                            "title": "Transaction count",
                            "$ref": "#/components/schemas/uint"
                        }
                    ]
                }
            },
            "examples": [
                {
                    "name": "eth_getBlockTransactionCountByHash example",
                    "params": [
                        {
                            "name": "Block hash",
                            "value": "0xb903239f8543d04b5dc1ba6579132b143087c68db1b2168786408fcbce568238"
                        }
                    ],
                    "result": {
                        "name": "Transaction count",
                        "value": "0x8"
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_getBlockTransactionCountByNumber",
            "summary": "Returns the number of transactions in a block matching the given block number.",
            "params": [
                {
                    "name": "Block",
                    "schema": {
                        "$ref": "#/components/schemas/BlockNumberOrTag"
                    }
                }
            ],
            "result": {
                "name": "Transaction count",
                "schema": {
                    "oneOf": [
                        {
                            "$ref": "#/components/schemas/notFound"
                        },
                        {
                            "title": "Transaction count",
                            "$ref": "#/components/schemas/uint"
                        }
                    ]
                }
            },
            "examples": [
                {
                    "name": "eth_getBlockTransactionCountByNumber example",
                    "params": [
                        {
                            "name": "Block",
                            "value": "0xe8"
                        }
                    ],
                    "result": {
                        "name": "Transaction count",
                        "value": "0x8"
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_getCode",
            "summary": "Returns code at a given address.",
            "params": [
                {
                    "name": "Address",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/address"
                    }
                },
                {
                    "name": "Block",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/BlockNumberOrTagOrHash"
                    }
                }
            ],
            "result": {
                "name": "Bytecode",
                "schema": {
                    "$ref": "#/components/schemas/bytes"
                }
            },
            "examples": [
                {
                    "name": "eth_getCode example",
                    "params": [
                        {
                            "name": "Address",
                            "value": "0xa50a51c09a5c451c52bb714527e1974b686d8e77"
                        },
                        {
                            "name": "Block",
                            "value": "latest"
                        }
                    ],
                    "result": {
                        "name": "Bytecode",
                        "value": "0x60806040526004361060485763ffffffff7c01000000000000000000000000000000000000000000000000000000006000350416633fa4f2458114604d57806355241077146071575b600080fd5b348015605857600080fd5b50605f6088565b60408051918252519081900360200190f35b348015607c57600080fd5b506086600435608e565b005b60005481565b60008190556040805182815290517f199cd93e851e4c78c437891155e2112093f8f15394aa89dab09e38d6ca0727879181900360200190a1505600a165627a7a723058209d8929142720a69bde2ab3bfa2da6217674b984899b62753979743c0470a2ea70029"
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_getFilterChanges",
            "summary": "Polling method for the filter with the given ID (created using `eth_newFilter`). Returns an array of logs which occurred since last poll.",
            "params": [
                {
                    "name": "Filter identifier",
                    "schema": {
                        "$ref": "#/components/schemas/uint"
                    }
                }
            ],
            "result": {
                "name": "Log objects",
                "schema": {
                    "$ref": "#/components/schemas/FilterResults"
                }
            },
            "examples": [
                {
                    "name": "eth_getFilterChanges example",
                    "params": [
                        {
                            "name": "Filter identifier",
                            "value": "0x01"
                        }
                    ],
                    "result": {
                        "name": "Log objects",
                        "value": [
                            {
                                "logIndex": "0x0",
                                "removed": false,
                                "blockNumber": "0x233",
                                "blockHash": "0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",
                                "transactionHash": "0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",
                                "transactionIndex": "0x0",
                                "address": "0x42699a7612a82f1d9c36148af9c77354759b210b",
                                "data": "0x0000000000000000000000000000000000000000000000000000000000000004",
                                "topics": [
                                    "0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"
                                ]
                            },
                            {
                                "logIndex": "0x0",
                                "removed": false,
                                "blockNumber": "0x238",
                                "blockHash": "0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",
                                "transactionHash": "0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",
                                "transactionIndex": "0x0",
                                "address": "0x42699a7612a82f1d9c36148af9c77354759b210b",
                                "data": "0x0000000000000000000000000000000000000000000000000000000000000007",
                                "topics": [
                                    "0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"
                                ]
                            }
                        ]
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_getFilterLogs",
            "summary": "Returns an array of all logs matching the filter with the given ID (created using `eth_newFilter`).",
            "params": [
                {
                    "name": "Filter identifier",
                    "schema": {
                        "$ref": "#/components/schemas/uint"
                    }
                }
            ],
            "result": {
                "name": "Log objects",
                "schema": {
                    "$ref": "#/components/schemas/FilterResults"
                }
            },
            "examples": [
                {
                    "name": "eth_getFilterLogs example",
                    "params": [
                        {
                            "name": "Filter identifier",
                            "value": "0x01"
                        }
                    ],
                    "result": {
                        "name": "Log objects",
                        "value": [
                            {
                                "logIndex": "0x0",
                                "removed": false,
                                "blockNumber": "0x233",
                                "blockHash": "0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",
                                "transactionHash": "0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",
                                "transactionIndex": "0x0",
                                "address": "0x42699a7612a82f1d9c36148af9c77354759b210b",
                                "data": "0x0000000000000000000000000000000000000000000000000000000000000004",
                                "topics": [
                                    "0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"
                                ]
                            },
                            {
                                "logIndex": "0x0",
                                "removed": false,
                                "blockNumber": "0x238",
                                "blockHash": "0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",
                                "transactionHash": "0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",
                                "transactionIndex": "0x0",
                                "address": "0x42699a7612a82f1d9c36148af9c77354759b210b",
                                "data": "0x0000000000000000000000000000000000000000000000000000000000000007",
                                "topics": [
                                    "0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"
                                ]
                            }
                        ]
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_getLogs",
            "summary": "Returns an array of all logs matching the specified filter.",
            "params": [
                {
                    "name": "Filter",
                    "schema": {
                        "$ref": "#/components/schemas/Filter"
                    }
                }
            ],
            "result": {
                "name": "Log objects",
                "schema": {
                    "$ref": "#/components/schemas/FilterResults"
                }
            },
            "examples": [
                {
                    "name": "eth_getLogs example",
                    "params": [
                        {
                            "name": "Filter",
                            "value": {
                                "fromBlock": "0x137d3c2",
                                "toBlock": "0x137d3c3",
                                "address": "0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",
                                "topics": []
                            }
                        }
                    ],
                    "result": {
                        "name": "Log objects",
                        "value": [
                            {
                                "logIndex": "0x0",
                                "removed": false,
                                "blockNumber": "0x233",
                                "blockHash": "0xfc139f5e2edee9e9c888d8df9a2d2226133a9bd87c88ccbd9c930d3d4c9f9ef5",
                                "transactionHash": "0x66e7a140c8fa27fe98fde923defea7562c3ca2d6bb89798aabec65782c08f63d",
                                "transactionIndex": "0x0",
                                "address": "0x42699a7612a82f1d9c36148af9c77354759b210b",
                                "data": "0x0000000000000000000000000000000000000000000000000000000000000004",
                                "topics": [
                                    "0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"
                                ]
                            },
                            {
                                "logIndex": "0x0",
                                "removed": false,
                                "blockNumber": "0x238",
                                "blockHash": "0x98b0ec0f9fea0018a644959accbe69cd046a8582e89402e1ab0ada91cad644ed",
                                "transactionHash": "0xdb17aa1c2ce609132f599155d384c0bc5334c988a6c368056d7e167e23eee058",
                                "transactionIndex": "0x0",
                                "address": "0x42699a7612a82f1d9c36148af9c77354759b210b",
                                "data": "0x0000000000000000000000000000000000000000000000000000000000000007",
                                "topics": [
                                    "0x04474795f5b996ff80cb47c148d4c5ccdbe09ef27551820caa9c2f8ed149cce3"
                                ]
                            }
                        ]
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_getProof",
            "summary": "Returns the merkle proof for a given account and optionally some storage keys.",
            "params": [
                {
                    "name": "Address",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/address"
                    }
                },
                {
                    "name": "StorageKeys",
                    "required": true,
                    "schema": {
                        "title": "Storage keys",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/bytesMax32"
                        }
                    }
                },
                {
                    "name": "Block",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/BlockNumberOrTagOrHash"
                    }
                }
            ],
            "result": {
                "name": "Account",
                "schema": {
                    "$ref": "#/components/schemas/AccountProof"
                }
            },
            "examples": [
                {
                    "name": "eth_getProof example",
                    "params": [
                        {
                            "name": "Address",
                            "value": "0xe5cB067E90D5Cd1F8052B83562Ae670bA4A211a8"
                        },
                        {
                            "name": "StorageKeys",
                            "value": [
                                "0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",
                                "0x283s34c8e2b1456f09832c71e5d6a0b4f8c9e1d3a2b5c7f0e6d4a8b2c1f3e5d7"
                            ]
                        },
                        {
                            "name": "Block",
                            "value": "latest"
                        }
                    ],
                    "result": {
                        "name": "Account",
                        "value": {
                            "accountProof": [
                                "0xf90211a06a718c2c9da77c253b12d7b2569657901e37bb691718f5dda1b86157ab1dd5eda0e7f19ed5e21bccc8d3260236b24f80ad88b3634f5d005f37b838881f0e12f1bda0abb301291704e4d92686c0f5f8ebb1734185321559b8d717ffdca95c99591976a0d0c2026bfab65c3b95276bfa82af9dec860b485f8857f293c148d63a2182128fa0c98044ec9a1273a218bed58b478277dd39173ad7b8edb95c200423a6bc8fc25fa056e5a55d9ddccdbf49362857200bbb1f042d61187c9f5f9ddcff5d2f1fc984a2a02a5b7200af424114f99a4b5f0a21c19aac82209e431ed80bfde177adb1004bdfa0026e4374f0518ff44a80fa374838ecb86cc64ac93bb710fea6dff4198f947b27a03fea341d87984673ad523177ed52f278bf4d8f97e6531c8ece932aeede4802f4a0bfe2f4a7fcb78f7e9f080dea7b6977fb1d88c441696e4456dad92b9d34ff0f43a02a3eb5c0edb14626c9c629601027bd60178bb2b688a67cea4d179fc432436615a0747355b8e02f3b884b4ffe5cea1619e32515fea064cca98208591af8c744e894a0874253737bae37f020ad3bb7e3292c7c4a63cdc158af6b33aaa4deaef016dccba03d8192bc1fc6aa1548912e763a0b5013a94399cefad7b47cf388873b2b794068a09b67f9737c6028d796bfd1c5da57a6f45824dc891f848ea0e1f8019d1fb5fba8a0aa871f9de8da85960fcd8a22cdf21c27f11e3966c14a6737ffd414b98dda00b280",
                                "0xf90211a0d360be1e1da1a0c32bc4c105833bd531e59d110684007b7c50fb2709002973eca0cf6dd1e350a7031b4e2ab49c899fd8bd47551c8565d8fd8d1d7796c83820c3b1a0eb0a88c29bb33989a589156f7bf07d9efc74034dd9d3f5b73385c3b45c3249bea02783c25f97a6ddb8dc07adf4b176991836d39184b1f678adeda832fff15e3664a00a4e288060045e587774d8a64993a7add73068b16863145e1e8eeb4602e18e19a0340851f4046ad1298962d6e47d05c66329549c839c158748aaad7ae00b943aefa085b127bc2a3bd17604283de21b2b3c9aa8f1d4b7b85c94d8105a46fe32c77688a00f531d62b3c5435324c01009c284fe31277e8d38302b75ea01be89f09e205969a00011c8351c0e3d639ac54b9d3a59de630b16a67de8270d7d6064d0a67e93f9cca048780d32b7f2db88650b51c46f46fd0a68795edee1fd5ecee6eb3595741d9669a0c91afd74eaf8e08a997061a62b354e2516fdc494e8e26cc50ceeb8f4a175608ba0e2c07f1b48fab80eecb340f5882e8c7b32ee416e4045c61f1df646a133487303a01a1eff78435a7a29a29463bdc3486ae81364b00bea82ba0fdf67a110770f2261a04f2eb440ba71c72da5fd7f0e439018d6671dc809f747213a1ea755848124e994a074ff9f37fce99daa3ed01dd763076450022996fc729be2cc43c61ec5182c2366a0b80b36b7b621112592f52390b89748d422e9b1517c4b0203b8176a53f89d4a6680",
                                "0xf90211a0b25f283bd01a8c8b2418049f9585bc37ff2c1e2e12eab4b7f64ae1f26647389aa02ad96c150d7c3c9c194d30315456852cf6a0a940e0191ae5d04007454823d4e9a0b220cf7a855e2dbcc0b973134e2e119b982d7d40dbb1b27d99816c41f40e829aa049224431da84cbf1b7ae813abcc9ef4c1dfc1760f6ddc5d57f7354bf3cbf6cc4a015191f879ac115b362f0257fd3eedb789537e836574a5b1abf1c9982ebe3bdfea07913c1b6e7282569d2d421e9fa2257f5d1698e93303bc49b941704287d7aaefea0a526576981ce6fd9f2bd48dd2ca6d5272f2fbdc85f0ee35a295f6ccd97ae8765a0313fad407f0c737c29024c02a890c4ecc12d7771c05ab7b435e5087a7cdef4d9a0d2044603cba9d4afdaf6fd2470e729ef3a65242de71276f20d59accfa6b53a7ca0457caacb9370c09b15f7d904adefd2308be94e23669ba5f43241ffff5f438a0aa09fb2dd45a383a0cc088a72b14117e1e9b7d6889218f3ac7631e8de644c5cb76da0c675dcd4d3fb692b514851c6106e2b09e6f5661d56a0a32ae02e2efc1515c235a074949a59ff1bdba87548510d6e404ec4532f4456dfdec8e753d92fda11a3088ba0a328c6ab1ab8f70db4d23e95bb163c13ba0c508f063a5b1393a4efd7ff375f05a0c722fe3ce796998269373cbb2fc229b2bdf2c43c6c2df003309422e043ce6c03a024e69343286eec44fa4744f6907209116e5383cff3fa98fe81ba06e7e8d4366680",
                                "0xf90211a00e99ba2198124b8241ea304551fe973215829e2fbc0438d67922707a2a847432a0bb9ce24fd527879c5fe6dbbec1ef5a05ed9d1ca88e921d140bafbec1112f6a6aa099787fd6c7a1989229c4291ef5267335e66152ce417daea46e66d19cb6f81d1ca0e430ff4b8d5621baa5978673344e78b4d8b4df51431b6e63785267c98a24ce18a0bb3e91a825fe3d42ed270a93e9ad1aabd566c40cb28e622f7f1d7ee967c8afd6a0aa364b0056870c6507bc3262a5f851ecb13684088bdb13996d3cb2db401ce3ffa0a3732eba4c7a6e062665ab5be08acb986c3db87556fb138548cc900ff1e56995a026b088e90c9738b8ce16e853107a937a50d52726a24f9f6ce60f587762eb45a2a006c9d5bc3c064b5c1fb565bff91cace9161c64ae653a329610c1dcf34d434429a06c16df2edc70656d322d0c2403bad7d45bc790ffc3e7adeef856d98ea6afc91ba0ae05ed5d6c34b5da29c2e94d7880aeba0906f95f4ec10b132a1d4766a0701c98a01470a86aa350d1ada0c082eac75de828a851f9c8c7c4aa49b1556fe3a5574966a0334eef025100a6da1033710dd98e0475f29d3d7e397caf618ca71c336c5f4f49a0ef0b3abbebcff34d6a8a8f5cdbfbd154ab3452b58dcb09de58ec983644963675a041857e865ec38e200a13bc1a3cb71c7d69aeef7ffdee8be515c9a5b691ce091fa059edd0eb3bbec36bbf38a19802d4646c00ba821ab55fdeea12e15bab62c4e1e580",
                                "0xf90211a0af0c7fa65ffcb84c31e68c1cf00e1a20bf8bb497c39883e19b66a99975b03431a0c492cab3623eb7926069794c3c718733e16c5fd0d4a13fb7c752ee9809aac7ada05003cea7132aa70d6f36731d60640a90bcd8f4fd493e4540d5ab1b4943679c0ca0fd700683405b1d2306b586dd3b5b2f92f1692fae20d17cd8b8e59d09b9c6670da01db8683910e46e56e8afeb9fe2b7c35382e5a0914d7b0dd8f0e8cb9981ba7435a0fa7f75d73aa73c35824387bec81388315caa4aee3f4f5562f971beb256c62d49a0ee478e420d83f413e8568dacfd5d83f83a5dd7c45f494b504828e5dc962f0e3ea094b95444a917ac94a675681f6bf851172ad0969801a783a63a71edafed45e7a7a0a0c46586e109abe80fe50361dd582e3f143cb416828239faa43bb2b890869501a0ae051d5d43634c68bf9c97823256cc68580f194dfdbd0c301140c7ca5853430ca0660b9365bb77ec9cdc6eb95516c162dca20727c6f828dbbeb1ae110dde4d3134a09feb1b75e84ff6722e4d837bfb6d207b6ee3b21b86844a01140ce293813b49a1a0ed58a70b04efa3bdc0babe2abfa20824a75d61d52291bfdb5cf08597800764d6a020a2d5d3a83f9e35ad9fd1c448626d90af0eb3efefaa4f2f93207b4096ef5507a0fc8efc4484dcf0a54f0574de9aaade0dcff6ec3599edb9f82efb26b6566dcaeaa032f7e79856db3fd984f72bb2c93d4dab328198d355a61c975fab1f08bdb2046580"
                            ],
                            "balance": "0x0",
                            "codeHash": "0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470",
                            "nonce": "0x0",
                            "storageHash": "0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",
                            "storageProof": [
                                {
                                    "key": "0x56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421",
                                    "proof": [
                                        "0xf90211a0c87222cccea2bf32759fcee9dbaacbe3ea4165dd6184af6773651c5e00e34a8ba0be90e6e5d1a67ab5587779c60ac136d6a96db62b84c04998a5f03a367346abd6a05344aa1c9ca2e3e56bf98fd718ec43728578d148e1967fbaf8bf17a2a073a0bda011a2f9312c3308640a0d6ceeae218747290f23806067456da1d444c65abae437a0b3097a108bfce79af6699da4ae3003cd4929f0b4576aad655c31cb725bde84c7a0c133d3c637e174f36a73c22b1039eb003da6374bc0929321241badb3efa3c4a9a0f13059f2301ad9862ce02e3f7f3f2c9ab78eb30583764d73654f7f1f8b1e86fda06544e3915748b18204e09df75ff20d2fa6bd8121e2e669699012d54590383d6fa070e3a8e093691581d58fadb560b510262a758037632cd8670d3a36df828976b7a062a88a2900544dc76a32255a6b2b2a2eef8fa68279700c00adc7508286702552a0a474aeebd5603dfce46a6ecd1ecd519068dc034a544fde03ac42d4018e60a334a0b7d528fc41c8fdc8ea18c6e7d0099270c777ec1403cf879d1f5134bdc12a6c6ca04440f1242e42c5bfa7c536591ab89c8e84bea417435871c32eef1e25295b20daa06a5dcfe3cc84cff9d3e3c3ae868cfba8f0dd111a90c3f85869dab5b893f96643a026b2fb9dd7d08b0ed2f1c44fbf875011412a384f86f751c92e1013248d4aa371a0c75597b2b789fc4e939b71937390ce9d7d53159431328ac52180eef08ef200f280",
                                        "0xf90191a0f0c5b800b542001597f2b7a8e106ac0e2849d2cc1df1727ac35c4ea3965f1c9180a08537f2e248702a6ae2a57e9110a5740f5772c876389739ac90debd6a0692713ea00b3a26a05b5494fb3ff6f0b3897688a5581066b20b07ebab9252d169d928717fa0a9a54d84976d134d6dba06a65064c7f3a964a75947d452db6f6bb4b6c47b43aaa01e2a1ed3d1572b872bbf09ee44d2ed737da31f01de3c0f4b4e1f046740066461a076f251d160b9a02eb0b5c1d83b61c9cdd4f37361705e79a45529bf49801fb824a0774a01a624cb14a50d17f2fe4b7ae6af8a67bbb029177ccc3dd729a734484d3ea05921b8a19aebe4fff5a36071e311778f9b93459183fdf7f6d870b401fa25dcbba0c8d71dd13d2806e2865a5c2cfa447f626471bf0b66182a8fd07230434e1cad2680a0e9864fdfaf3693b2602f56cd938ccd494b8634b1f91800ef02203a3609ca4c21a0c69d174ad6b6e58b0bd05914352839ec60915cd066dd2bee2a48016139687f21a0513dd5514fd6bad56871711441d38de2821cc6913cb192416b0385f025650731808080"
                                    ],
                                    "value": "0x1"
                                }
                            ]
                        }
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_getStorageAt",
            "summary": "Returns the value from a storage position at a given address.",
            "params": [
                {
                    "name": "Address",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/address"
                    }
                },
                {
                    "name": "Storage slot",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/uint256"
                    }
                },
                {
                    "name": "Block",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/BlockNumberOrTagOrHash"
                    }
                }
            ],
            "result": {
                "name": "Value",
                "schema": {
                    "$ref": "#/components/schemas/bytes"
                }
            },
            "examples": [
                {
                    "name": "eth_getStorageAt example",
                    "params": [
                        {
                            "name": "Address",
                            "value": "0xfe3b557e8fb62b89f4916b721be55ceb828dbd73"
                        },
                        {
                            "name": "Storage slot",
                            "value": "0x0"
                        },
                        {
                            "name": "Block",
                            "value": "latest"
                        }
                    ],
                    "result": {
                        "name": "Value",
                        "value": "0x0000000000000000000000000000000000000000000000000000000000000000"
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_getTransactionByBlockHashAndIndex",
            "summary": "Returns information about a transaction by block hash and transaction index position.",
            "params": [
                {
                    "name": "Block hash",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/hash32"
                    }
                },
                {
                    "name": "Transaction index",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/uint"
                    }
                }
            ],
            "result": {
                "name": "Transaction information",
                "schema": {
                    "oneOf": [
                        {
                            "$ref": "#/components/schemas/notFound"
                        },
                        {
                            "$ref": "#/components/schemas/TransactionInfo"
                        }
                    ]
                }
            },
            "examples": [
                {
                    "name": "eth_getTransactionByBlockHashAndIndex example",
                    "params": [
                        {
                            "name": "Block hash",
                            "value": "0xbf137c3a7a1ebdfac21252765e5d7f40d115c2757e4a4abee929be88c624fdb7"
                        },
                        {
                            "name": "Transaction index",
                            "value": "0x2"
                        }
                    ],
                    "result": {
                        "name": "Transaction information",
                        "value": {
                            "blockHash": "0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",
                            "blockNumber": "0x422",
                            "chainId": 2018,
                            "from": "0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",
                            "gas": "0x5208",
                            "gasPrice": "0x3b9aca00",
                            "hash": "0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",
                            "input": "0x",
                            "nonce": "0x1",
                            "to": "0x627306090abab3a6e1400e9345bc60c78a8bef57",
                            "transactionIndex": "0x0",
                            "value": "0x4e1003b28d9280000",
                            "v": "0xfe7",
                            "r": "0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",
                            "s": "0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"
                        }
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_getTransactionByBlockNumberAndIndex",
            "summary": "Returns information about a transaction by block number and transaction index position.",
            "params": [
                {
                    "name": "Block",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/BlockNumberOrTag"
                    }
                },
                {
                    "name": "Transaction index",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/uint"
                    }
                }
            ],
            "result": {
                "name": "Transaction information",
                "schema": {
                    "oneOf": [
                        {
                            "$ref": "#/components/schemas/notFound"
                        },
                        {
                            "$ref": "#/components/schemas/TransactionInfo"
                        }
                    ]
                }
            },
            "examples": [
                {
                    "name": "eth_getTransactionByBlockNumberAndIndex example",
                    "params": [
                        {
                            "name": "Block",
                            "value": "0x1442e"
                        },
                        {
                            "name": "Transaction index",
                            "value": "0x2"
                        }
                    ],
                    "result": {
                        "name": "Transaction information",
                        "value": {
                            "blockHash": "0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",
                            "blockNumber": "0x422",
                            "chainId": 2018,
                            "from": "0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",
                            "gas": "0x5208",
                            "gasPrice": "0x3b9aca00",
                            "hash": "0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",
                            "input": "0x",
                            "nonce": "0x1",
                            "to": "0x627306090abab3a6e1400e9345bc60c78a8bef57",
                            "transactionIndex": "0x0",
                            "value": "0x4e1003b28d9280000",
                            "v": "0xfe7",
                            "r": "0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",
                            "s": "0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"
                        }
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_getTransactionByHash",
            "summary": "Returns the information about a transaction requested by transaction hash.",
            "params": [
                {
                    "name": "Transaction hash",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/hash32"
                    }
                }
            ],
            "result": {
                "name": "Transaction information",
                "schema": {
                    "oneOf": [
                        {
                            "$ref": "#/components/schemas/notFound"
                        },
                        {
                            "$ref": "#/components/schemas/TransactionInfo"
                        }
                    ]
                }
            },
            "examples": [
                {
                    "name": "eth_getTransactionByHash example",
                    "params": [
                        {
                            "name": "Transaction hash",
                            "value": "0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44"
                        }
                    ],
                    "result": {
                        "name": "Transaction information",
                        "value": {
                            "blockHash": "0x510efccf44a192e6e34bcb439a1947e24b86244280762cbb006858c237093fda",
                            "blockNumber": "0x422",
                            "chainId": 2018,
                            "from": "0xfe3b557e8fb62b89f4916b721be55ceb828dbd73",
                            "gas": "0x5208",
                            "gasPrice": "0x3b9aca00",
                            "hash": "0xa52be92809541220ee0aaaede6047d9a6c5d0cd96a517c854d944ee70a0ebb44",
                            "input": "0x",
                            "nonce": "0x1",
                            "to": "0x627306090abab3a6e1400e9345bc60c78a8bef57",
                            "transactionIndex": "0x0",
                            "value": "0x4e1003b28d9280000",
                            "v": "0xfe7",
                            "r": "0x84caf09aefbd5e539295acc67217563438a4efb224879b6855f56857fa2037d3",
                            "s": "0x5e863be3829812c81439f0ae9d8ecb832b531d651fb234c848d1bf45e62be8b9"
                        }
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_getTransactionCount",
            "summary": "Returns the number of transactions sent from an address.",
            "params": [
                {
                    "name": "Address",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/address"
                    }
                },
                {
                    "name": "Block",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/BlockNumberOrTagOrHash"
                    }
                }
            ],
            "result": {
                "name": "Transaction count",
                "schema": {
                    "$ref": "#/components/schemas/uint"
                }
            },
            "examples": [
                {
                    "name": "eth_getTransactionCount example",
                    "params": [
                        {
                            "name": "Address",
                            "value": "0xc94770007dda54cF92009BFF0dE90c06F603a09f"
                        },
                        {
                            "name": "Block",
                            "value": "latest"
                        }
                    ],
                    "result": {
                        "name": "Transaction count",
                        "value": "0x1"
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_getTransactionReceipt",
            "summary": "Returns the receipt of a transaction by transaction hash.",
            "params": [
                {
                    "name": "Transaction hash",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/hash32"
                    }
                }
            ],
            "result": {
                "name": "Receipt information",
                "schema": {
                    "oneOf": [
                        {
                            "$ref": "#/components/schemas/notFound"
                        },
                        {
                            "$ref": "#/components/schemas/ReceiptInfo"
                        }
                    ]
                }
            },
            "examples": [
                {
                    "name": "eth_getTransactionReceipt example",
                    "params": [
                        {
                            "name": "Transaction hash",
                            "value": "0x504ce587a65bdbdb6414a0c6c16d86a04dd79bfcc4f2950eec9634b30ce5370f"
                        }
                    ],
                    "result": {
                        "name": "Receipt information",
                        "value": {
                            "blockHash": "0xe7212a92cfb9b06addc80dec2a0dfae9ea94fd344efeb157c41e12994fcad60a",
                            "blockNumber": "0x50",
                            "contractAddress": null,
                            "cumulativeGasUsed": "0x5208",
                            "from": "0x627306090abab3a6e1400e9345bc60c78a8bef57",
                            "gasUsed": "0x5208",
                            "blobGasUsed": "0x20000",
                            "effectiveGasPrice": "0x1",
                            "blobGasPrice": "0x3",
                            "logs": [],
                            "logsBloom": "0x00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                            "status": "0x1",
                            "to": "0xf17f52151ebef6c7334fad080c5704d77216b732",
                            "transactionHash": "0xc00e97af59c6f88de163306935f7682af1a34c67245e414537d02e422815efc3",
                            "transactionIndex": "0x0"
                        }
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_getUncleCountByBlockHash",
            "summary": "Returns the number of uncles in a block from a block matching the given block hash.",
            "params": [
                {
                    "name": "Block hash",
                    "schema": {
                        "$ref": "#/components/schemas/hash32"
                    }
                }
            ],
            "result": {
                "name": "Uncle count",
                "schema": {
                    "oneOf": [
                        {
                            "$ref": "#/components/schemas/notFound"
                        },
                        {
                            "title": "Uncle count",
                            "$ref": "#/components/schemas/uint"
                        }
                    ]
                }
            },
            "examples": [
                {
                    "name": "eth_getUncleCountByBlockHash example",
                    "params": [
                        {
                            "name": "Block hash",
                            "value": "0xb3b20624f8f0f86eb50dd04688409e5cea4bd02d700bf6e79e9384d47d6a5a35"
                        }
                    ],
                    "result": {
                        "name": "Uncle count",
                        "value": "0x1"
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_getUncleCountByBlockNumber",
            "summary": "Returns the number of transactions in a block matching the given block number.",
            "params": [
                {
                    "name": "Block",
                    "schema": {
                        "$ref": "#/components/schemas/BlockNumberOrTag"
                    }
                }
            ],
            "result": {
                "name": "Uncle count",
                "schema": {
                    "oneOf": [
                        {
                            "$ref": "#/components/schemas/notFound"
                        },
                        {
                            "title": "Uncle count",
                            "$ref": "#/components/schemas/uint"
                        }
                    ]
                }
            },
            "examples": [
                {
                    "name": "eth_getUncleCountByBlockNumber example",
                    "params": [
                        {
                            "name": "Block",
                            "value": "0xe8"
                        }
                    ],
                    "result": {
                        "name": "Uncle count",
                        "value": "0x1"
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_newBlockFilter",
            "summary": "Creates a filter in the node, to notify when a new block arrives.",
            "params": [],
            "result": {
                "name": "Filter identifier",
                "schema": {
                    "$ref": "#/components/schemas/uint"
                }
            },
            "examples": [
                {
                    "name": "eth_newBlockFilter example",
                    "params": [],
                    "result": {
                        "name": "Filter identifier",
                        "value": "0x01"
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_newFilter",
            "summary": "Creates a filter object, based on filter options, to notify when the state changes (logs).",
            "params": [
                {
                    "name": "Filter",
                    "schema": {
                        "$ref": "#/components/schemas/Filter"
                    }
                }
            ],
            "result": {
                "name": "Filter identifier",
                "schema": {
                    "$ref": "#/components/schemas/uint"
                }
            },
            "examples": [
                {
                    "name": "eth_newFilter example",
                    "params": [
                        {
                            "name": "Filter",
                            "value": {
                                "fromBlock": "0x137d3c2",
                                "toBlock": "0x137d3c3",
                                "address": "0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2",
                                "topics": []
                            }
                        }
                    ],
                    "result": {
                        "name": "Filter identifier",
                        "value": "0x01"
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_newPendingTransactionFilter",
            "summary": "Creates a filter in the node, to notify when new pending transactions arrive.",
            "params": [],
            "result": {
                "name": "Filter identifier",
                "schema": {
                    "$ref": "#/components/schemas/uint"
                }
            },
            "examples": [
                {
                    "name": "eth_newPendingTransactionFilter example",
                    "params": [],
                    "result": {
                        "name": "Filter identifier",
                        "value": "0x01"
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_sendRawTransaction",
            "summary": "Submits a raw transaction. You can create and sign a transaction externally using a library such as [web3.js](https://web3js.readthedocs.io/) or [ethers.js](https://docs.ethers.org/). For [EIP-4844](https://eips.ethereum.org/EIPS/eip-4844) transactions, the raw form must be the network form. This means it includes the blobs, KZG commitments, and KZG proofs.",
            "params": [
                {
                    "name": "Transaction",
                    "required": true,
                    "schema": {
                        "$ref": "#/components/schemas/bytes"
                    }
                }
            ],
            "result": {
                "name": "Transaction hash",
                "schema": {
                    "$ref": "#/components/schemas/hash32"
                }
            },
            "examples": [
                {
                    "name": "eth_sendRawTransaction example",
                    "params": [
                        {
                            "name": "Transaction",
                            "value": "0xf869018203e882520894f17f52151ebef6c7334fad080c5704d77216b732881bc16d674ec80000801ba02da1c48b670996dcb1f447ef9ef00b33033c48a4fe938f420bec3e56bfd24071a062e0aa78a81bf0290afbc3a9d8e9a068e6d74caa66c5e0fa8a46deaae96b0833"
                        }
                    ],
                    "result": {
                        "name": "Transaction hash",
                        "value": "0xe670ec64341771606e55d6b4ca35a1a6b75ee3d5145a99d05921026d1527331"
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_syncing",
            "summary": "Returns an object with data about the sync status or false.",
            "params": [],
            "result": {
                "name": "Syncing status",
                "schema": {
                    "$ref": "#/components/schemas/SyncingStatus"
                }
            },
            "examples": [
                {
                    "name": "eth_syncing example",
                    "params": [],
                    "result": {
                        "name": "Syncing status",
                        "value": {
                            "startingBlock": "0x0",
                            "currentBlock": "0x1518",
                            "highestBlock": "0x9567a3"
                        }
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        },
        {
            "name": "eth_uninstallFilter",
            "summary": "Uninstalls a filter with given id.",
            "params": [
                {
                    "name": "Filter identifier",
                    "schema": {
                        "$ref": "#/components/schemas/uint"
                    }
                }
            ],
            "result": {
                "name": "Success",
                "schema": {
                    "type": "boolean"
                }
            },
            "examples": [
                {
                    "name": "eth_uninstallFilter example",
                    "params": [
                        {
                            "name": "Filter identifier",
                            "value": "0x01"
                        }
                    ],
                    "result": {
                        "name": "Success",
                        "value": true
                    }
                }
            ],
            "tags": [
                {
                    "name": "Ethereum API",
                    "description": "Ethereum Node JSON-RPC method"
                },
                {
                    "name": "Multichain API",
                    "description": "Multichain JSON-RPC method"
                }
            ]
        }
    ],
    "components": {
        "errors": {
            "UserRejected": {
                "code": 4001,
                "message": "User rejected the request."
            },
            "InvalidParams": {
                "code": -32602,
                "message": "The wallet cannot parse the request."
            },
            "Unauthorized": {
                "code": 4100,
                "message": "The requested account and/or method has not been authorized by the user."
            }
        },
        "schemas": {
            "TypedData": {
                "title": "Typed data",
                "description": "Object containing information about the typed data to sign.",
                "type": "object",
                "required": [
                    "types",
                    "primaryType",
                    "domain",
                    "message"
                ],
                "properties": {
                    "types": {
                        "type": "object",
                        "description": "Object containing type information.",
                        "required": [
                            "EIP712Domain"
                        ],
                        "properties": {
                            "EIP712Domain": {
                                "type": "array",
                                "items": {
                                    "type": "object",
                                    "title": "Domain separator value",
                                    "description": "Object containing information about the domain separator value.",
                                    "properties": {
                                        "name": {
                                            "type": "string",
                                            "description": "Name of the domain separator value."
                                        },
                                        "type": {
                                            "type": "string",
                                            "description": "Data type of the domain separator value."
                                        }
                                    }
                                },
                                "description": "An array specifying one or more of the following domain separator values: <br><br> <ul>\n  <li>`name` - The user-readable name of the signing domain, that is, the name of the dapp or the protocol.</li>\n  <li>`version` - The current major version of the signing domain.</li>\n  <li>`chainId` - The chain ID of the network.</li>\n  <li>`verifyingContract` - The address of the contract that will verify the signature.</li>\n  <li>`salt` - A disambiguating salt for the protocol.</li>\n</ul>"
                            }
                        },
                        "additionalProperties": {
                            "type": "array",
                            "required": [
                                "name",
                                "type"
                            ],
                            "items": {
                                "type": "object",
                                "properties": {
                                    "name": {
                                        "type": "string"
                                    },
                                    "type": {
                                        "type": "string"
                                    }
                                }
                            }
                        }
                    },
                    "domain": {
                        "type": "object",
                        "description": "Object containing the domain separator values specified in the `EIP712Domain` type."
                    },
                    "primaryType": {
                        "type": "string",
                        "description": "The primary type of the message."
                    },
                    "message": {
                        "type": "object",
                        "description": "The message you're proposing the user to sign."
                    }
                }
            },
            "SendCallsParameter": {
                "title": "Calls",
                "description": "An object containing information about a batch of calls.",
                "type": "object",
                "required": [
                    "version",
                    "from",
                    "chainId",
                    "atomicRequired",
                    "calls"
                ],
                "properties": {
                    "version": {
                        "description": "The version of the API format. This must be `2.0.0`.",
                        "type": "string"
                    },
                    "id": {
                        "description": "The ID of the batch of calls.",
                        "type": "string"
                    },
                    "from": {
                        "description": "The sender's address.",
                        "type": "string",
                        "pattern": "^0x[0-9a-fA-F]{40}$"
                    },
                    "chainId": {
                        "description": "The [EIP-155](https://eips.ethereum.org/EIPS/eip-155) chain ID of the calls. This must match the currently selected network in the wallet.",
                        "type": "string",
                        "pattern": "^0x([1-9a-f]+[0-9a-f]*|0)$"
                    },
                    "atomicRequired": {
                        "description": "`true` if the wallet must execute all calls atomically. If `false`, the wallet may execute the calls sequentially without atomicity. If `false` and the wallet is capable of executing the calls atomically, it may do so.",
                        "type": "boolean"
                    },
                    "calls": {
                        "type": "array",
                        "description": "An array of call objects.",
                        "items": {
                            "title": "Call",
                            "description": "An object containing information about the call.",
                            "type": "object",
                            "properties": {
                                "to": {
                                    "description": "The address of the call's recipient.",
                                    "type": "string",
                                    "pattern": "^0x[0-9a-fA-F]{40}$"
                                },
                                "data": {
                                    "description": "The data to send with the call.",
                                    "type": "string",
                                    "pattern": "^0x[0-9a-f]*$"
                                },
                                "value": {
                                    "description": "The value to send with the call.",
                                    "type": "string",
                                    "pattern": "^0x([1-9a-f]+[0-9a-f]*|0)$"
                                },
                                "capabilities": {
                                    "description": "Dapps can use this object to communicate with the wallet about supported capabilities.",
                                    "type": "object"
                                }
                            }
                        }
                    },
                    "capabilities": {
                        "description": "Dapps can use this object to communicate with the wallet about supported capabilities.",
                        "type": "object"
                    }
                }
            },
            "AddEthereumChainParameter": {
                "title": "Chain",
                "description": "Object containing information about the chain to add.",
                "type": "object",
                "required": [
                    "chainId",
                    "chainName",
                    "nativeCurrency",
                    "rpcUrls"
                ],
                "properties": {
                    "chainId": {
                        "description": "The chain ID as a `0x`-prefixed hexadecimal string, per the `eth_chainId` method. MetaMask compares this chain ID value with the `eth_chainId` return value. If these values aren't identical, MetaMask rejects the request.",
                        "type": "string"
                    },
                    "blockExplorerUrls": {
                        "description": "(Optional) An array of one or more URLs pointing to block explorer sites for the chain.",
                        "type": "array",
                        "items": {
                            "type": "string",
                            "description": "Block explorer URL."
                        }
                    },
                    "chainName": {
                        "description": "A human-readable name for the chain.",
                        "type": "string"
                    },
                    "iconUrls": {
                        "description": "(Optional) An array of one or more URLs pointing to icons that can be used to visually identify the chain. Note: MetaMask will not currently display these icons. You can still include icon URLs so they are used if MetaMask incorporates them into the display of custom networks in the future.",
                        "type": "array",
                        "items": {
                            "format": "uri",
                            "type": "string",
                            "description": "Icon URL."
                        }
                    },
                    "nativeCurrency": {
                        "$ref": "#/components/schemas/NativeCurrency"
                    },
                    "rpcUrls": {
                        "description": "An array of one or more URLs pointing to RPC endpoints that can be used to communicate with the chain. At least one item is required, and only the first item is used.",
                        "type": "array",
                        "minItems": 1,
                        "items": {
                            "format": "uri",
                            "type": "string",
                            "description": "RPC URL."
                        }
                    }
                }
            },
            "NativeCurrency": {
                "title": "NativeCurrency",
                "type": "object",
                "description": "An object containing information about the native currency of the chain.",
                "required": [
                    "decimals",
                    "symbol"
                ],
                "properties": {
                    "decimals": {
                        "description": "A non-negative integer representing the number of decimals the native currency uses.",
                        "minimum": 0,
                        "type": "integer"
                    },
                    "name": {
                        "description": "A human-readable name of the native currency.",
                        "type": "string"
                    },
                    "symbol": {
                        "description": "A human-readable symbol of the native currency.",
                        "type": "string"
                    }
                }
            },
            "Caveats": {
                "title": "Caveats",
                "description": "An array of caveats that specify restrictions on the permission.",
                "type": "array",
                "items": {
                    "title": "Caveat",
                    "description": "Object containing information about the caveat.",
                    "type": "object",
                    "properties": {
                        "type": {
                            "title": "Type",
                            "type": "string",
                            "description": "Type of caveat."
                        },
                        "value": {
                            "title": "CaveatValue",
                            "description": "Value of the caveat."
                        },
                        "name": {
                            "title": "Name",
                            "type": "string",
                            "description": "Name of the caveat."
                        }
                    }
                }
            },
            "Permission": {
                "title": "Permission",
                "description": "Object containing information about the permission.",
                "type": "object",
                "properties": {
                    "id": {
                        "description": "The permission ID.",
                        "type": "string"
                    },
                    "parentCapability": {
                        "description": "The name of the permission being granted. For example, `eth_accounts` or `endowment:permitted-chains`.",
                        "type": "string"
                    },
                    "invoker": {
                        "description": "The URI of the dapp being granted this permission.",
                        "type": "string"
                    },
                    "caveats": {
                        "$ref": "#/components/schemas/Caveats"
                    },
                    "date": {
                        "description": "The timestamp of the permission request.",
                        "type": "number"
                    }
                }
            },
            "PermissionsList": {
                "title": "Permissions list",
                "description": "An array of the user's permissions.",
                "type": "array",
                "items": {
                    "$ref": "#/components/schemas/Permission"
                }
            },
            "address": {
                "title": "hex encoded address",
                "type": "string",
                "pattern": "^0x[0-9a-fA-F]{40}$"
            },
            "addresses": {
                "title": "hex encoded address",
                "type": "array",
                "items": {
                    "$ref": "#/components/schemas/address"
                }
            },
            "byte": {
                "title": "hex encoded byte",
                "type": "string",
                "pattern": "^0x([0-9a-fA-F]?){1,2}$"
            },
            "bytes": {
                "title": "hex encoded bytes",
                "type": "string",
                "pattern": "^0x[0-9a-f]*$"
            },
            "bytesMax32": {
                "title": "32 hex encoded bytes",
                "type": "string",
                "pattern": "^0x[0-9a-f]{0,64}$"
            },
            "bytes8": {
                "title": "8 hex encoded bytes",
                "type": "string",
                "pattern": "^0x[0-9a-f]{16}$"
            },
            "bytes32": {
                "title": "32 hex encoded bytes",
                "type": "string",
                "pattern": "^0x[0-9a-f]{64}$"
            },
            "bytes48": {
                "title": "48 hex encoded bytes",
                "type": "string",
                "pattern": "^0x[0-9a-f]{96}$"
            },
            "bytes96": {
                "title": "96 hex encoded bytes",
                "type": "string",
                "pattern": "^0x[0-9a-f]{192}$"
            },
            "bytes256": {
                "title": "256 hex encoded bytes",
                "type": "string",
                "pattern": "^0x[0-9a-f]{512}$"
            },
            "bytes65": {
                "title": "65 hex encoded bytes",
                "type": "string",
                "pattern": "^0x[0-9a-f]{130}$"
            },
            "ratio": {
                "title": "normalized ratio",
                "type": "number",
                "minimum": 0,
                "maximum": 1
            },
            "uint": {
                "title": "hex encoded unsigned integer",
                "type": "string",
                "pattern": "^0x([1-9a-f]+[0-9a-f]*|0)$"
            },
            "uint64": {
                "title": "hex encoded 64 bit unsigned integer",
                "type": "string",
                "pattern": "^0x([1-9a-f]+[0-9a-f]{0,15})|0$"
            },
            "uint256": {
                "title": "hex encoded 256 bit unsigned integer",
                "type": "string",
                "pattern": "^0x([1-9a-f]+[0-9a-f]{0,31})|0$"
            },
            "hash32": {
                "title": "32 byte hex value",
                "type": "string",
                "pattern": "^0x[0-9a-f]{64}$"
            },
            "notFound": {
                "title": "Not Found (null)",
                "type": "null"
            },
            "Block": {
                "title": "Block object",
                "type": "object",
                "required": [
                    "hash",
                    "parentHash",
                    "sha3Uncles",
                    "miner",
                    "stateRoot",
                    "transactionsRoot",
                    "receiptsRoot",
                    "logsBloom",
                    "number",
                    "gasLimit",
                    "gasUsed",
                    "timestamp",
                    "extraData",
                    "mixHash",
                    "nonce",
                    "size",
                    "transactions",
                    "uncles"
                ],
                "additionalProperties": false,
                "properties": {
                    "hash": {
                        "title": "Hash",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "parentHash": {
                        "title": "Parent block hash",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "sha3Uncles": {
                        "title": "Ommers hash",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "miner": {
                        "title": "Coinbase",
                        "$ref": "#/components/schemas/address"
                    },
                    "stateRoot": {
                        "title": "State root",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "transactionsRoot": {
                        "title": "Transactions root",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "receiptsRoot": {
                        "title": "Receipts root",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "logsBloom": {
                        "title": "Bloom filter",
                        "$ref": "#/components/schemas/bytes256"
                    },
                    "difficulty": {
                        "title": "Difficulty",
                        "$ref": "#/components/schemas/uint"
                    },
                    "number": {
                        "title": "Number",
                        "$ref": "#/components/schemas/uint"
                    },
                    "gasLimit": {
                        "title": "Gas limit",
                        "$ref": "#/components/schemas/uint"
                    },
                    "gasUsed": {
                        "title": "Gas used",
                        "$ref": "#/components/schemas/uint"
                    },
                    "timestamp": {
                        "title": "Timestamp",
                        "$ref": "#/components/schemas/uint"
                    },
                    "extraData": {
                        "title": "Extra data",
                        "$ref": "#/components/schemas/bytes"
                    },
                    "mixHash": {
                        "title": "Mix hash",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "nonce": {
                        "title": "Nonce",
                        "$ref": "#/components/schemas/bytes8"
                    },
                    "baseFeePerGas": {
                        "title": "Base fee per gas",
                        "$ref": "#/components/schemas/uint"
                    },
                    "withdrawalsRoot": {
                        "title": "Withdrawals root",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "blobGasUsed": {
                        "title": "Blob gas used",
                        "$ref": "#/components/schemas/uint"
                    },
                    "excessBlobGas": {
                        "title": "Excess blob gas",
                        "$ref": "#/components/schemas/uint"
                    },
                    "parentBeaconBlockRoot": {
                        "title": "Parent Beacon Block Root",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "size": {
                        "title": "Block size",
                        "$ref": "#/components/schemas/uint"
                    },
                    "transactions": {
                        "anyOf": [
                            {
                                "title": "Transaction hashes",
                                "type": "array",
                                "items": {
                                    "$ref": "#/components/schemas/hash32"
                                }
                            },
                            {
                                "title": "Full transactions",
                                "type": "array",
                                "items": {
                                    "$ref": "#/components/schemas/TransactionInfo"
                                }
                            }
                        ]
                    },
                    "withdrawals": {
                        "title": "Withdrawals",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/Withdrawal"
                        }
                    },
                    "uncles": {
                        "title": "Uncles",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/hash32"
                        }
                    }
                }
            },
            "BlockTag": {
                "title": "Block tag",
                "type": "string",
                "enum": [
                    "earliest",
                    "finalized",
                    "safe",
                    "latest",
                    "pending"
                ],
                "description": "`earliest`: The lowest numbered block the client has available; `finalized`: The most recent crypto-economically secure block, cannot be re-orged outside of manual intervention driven by community coordination; `safe`: The most recent block that is safe from re-orgs under honest majority and certain synchronicity assumptions; `latest`: The most recent block in the canonical chain observed by the client, this block may be re-orged out of the canonical chain even under healthy/normal conditions; `pending`: A sample next block built by the client on top of `latest` and containing the set of transactions usually taken from local mempool. Before the merge transition is finalized, any call querying for `finalized` or `safe` block MUST be responded to with `-39001: Unknown block` error"
            },
            "BlockNumberOrTag": {
                "title": "Block number or tag",
                "oneOf": [
                    {
                        "title": "Block number",
                        "$ref": "#/components/schemas/uint"
                    },
                    {
                        "title": "Block tag",
                        "$ref": "#/components/schemas/BlockTag"
                    }
                ]
            },
            "BlockNumberOrTagOrHash": {
                "title": "Block number, tag, or block hash",
                "anyOf": [
                    {
                        "title": "Block number",
                        "$ref": "#/components/schemas/uint"
                    },
                    {
                        "title": "Block tag",
                        "$ref": "#/components/schemas/BlockTag"
                    },
                    {
                        "title": "Block hash",
                        "$ref": "#/components/schemas/hash32"
                    }
                ]
            },
            "BadBlock": {
                "title": "Bad block",
                "type": "object",
                "required": [
                    "block",
                    "hash",
                    "rlp"
                ],
                "additionalProperties": false,
                "properties": {
                    "block": {
                        "title": "Block",
                        "$ref": "#/components/schemas/Block"
                    },
                    "hash": {
                        "title": "Hash",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "rlp": {
                        "title": "RLP",
                        "$ref": "#/components/schemas/bytes"
                    }
                }
            },
            "SyncingStatus": {
                "title": "Syncing status",
                "oneOf": [
                    {
                        "title": "Syncing progress",
                        "type": "object",
                        "additionalProperties": false,
                        "properties": {
                            "startingBlock": {
                                "title": "Starting block",
                                "$ref": "#/components/schemas/uint"
                            },
                            "currentBlock": {
                                "title": "Current block",
                                "$ref": "#/components/schemas/uint"
                            },
                            "highestBlock": {
                                "title": "Highest block",
                                "$ref": "#/components/schemas/uint"
                            }
                        }
                    },
                    {
                        "title": "Not syncing",
                        "description": "Should always return false if not syncing.",
                        "type": "boolean"
                    }
                ]
            },
            "FilterResults": {
                "title": "Filter results",
                "oneOf": [
                    {
                        "title": "new block or transaction hashes",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/hash32"
                        }
                    },
                    {
                        "title": "new logs",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/Log"
                        }
                    }
                ]
            },
            "Filter": {
                "title": "filter",
                "type": "object",
                "additionalProperties": false,
                "properties": {
                    "fromBlock": {
                        "title": "from block",
                        "$ref": "#/components/schemas/uint"
                    },
                    "toBlock": {
                        "title": "to block",
                        "$ref": "#/components/schemas/uint"
                    },
                    "address": {
                        "title": "Address(es)",
                        "oneOf": [
                            {
                                "title": "Any Address",
                                "type": "null"
                            },
                            {
                                "title": "Address",
                                "$ref": "#/components/schemas/address"
                            },
                            {
                                "title": "Addresses",
                                "$ref": "#/components/schemas/addresses"
                            }
                        ]
                    },
                    "topics": {
                        "title": "Topics",
                        "$ref": "#/components/schemas/FilterTopics"
                    }
                }
            },
            "FilterTopics": {
                "title": "Filter Topics",
                "oneOf": [
                    {
                        "title": "Any Topic Match",
                        "type": "null"
                    },
                    {
                        "title": "Specified Filter Topics",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/FilterTopic"
                        }
                    }
                ]
            },
            "FilterTopic": {
                "title": "Filter Topic List Entry",
                "oneOf": [
                    {
                        "title": "Single Topic Match",
                        "$ref": "#/components/schemas/bytes32"
                    },
                    {
                        "title": "Multiple Topic Match",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/bytes32"
                        }
                    }
                ]
            },
            "Log": {
                "title": "log",
                "type": "object",
                "required": [
                    "transactionHash"
                ],
                "additionalProperties": false,
                "properties": {
                    "removed": {
                        "title": "removed",
                        "type": "boolean"
                    },
                    "logIndex": {
                        "title": "log index",
                        "$ref": "#/components/schemas/uint"
                    },
                    "transactionIndex": {
                        "title": "transaction index",
                        "$ref": "#/components/schemas/uint"
                    },
                    "transactionHash": {
                        "title": "transaction hash",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "blockHash": {
                        "title": "block hash",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "blockNumber": {
                        "title": "block number",
                        "$ref": "#/components/schemas/uint"
                    },
                    "address": {
                        "title": "address",
                        "$ref": "#/components/schemas/address"
                    },
                    "data": {
                        "title": "data",
                        "$ref": "#/components/schemas/bytes"
                    },
                    "topics": {
                        "title": "topics",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/bytes32"
                        }
                    }
                }
            },
            "ReceiptInfo": {
                "type": "object",
                "title": "Receipt information",
                "required": [
                    "blockHash",
                    "blockNumber",
                    "from",
                    "cumulativeGasUsed",
                    "gasUsed",
                    "logs",
                    "logsBloom",
                    "transactionHash",
                    "transactionIndex",
                    "effectiveGasPrice"
                ],
                "additionalProperties": false,
                "properties": {
                    "type": {
                        "title": "type",
                        "$ref": "#/components/schemas/byte"
                    },
                    "transactionHash": {
                        "title": "transaction hash",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "transactionIndex": {
                        "title": "transaction index",
                        "$ref": "#/components/schemas/uint"
                    },
                    "blockHash": {
                        "title": "block hash",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "blockNumber": {
                        "title": "block number",
                        "$ref": "#/components/schemas/uint"
                    },
                    "from": {
                        "title": "from",
                        "$ref": "#/components/schemas/address"
                    },
                    "to": {
                        "title": "to",
                        "description": "Address of the receiver or null in a contract creation transaction.",
                        "oneOf": [
                            {
                                "title": "Contract Creation (null)",
                                "type": "null"
                            },
                            {
                                "title": "Recipient Address",
                                "$ref": "#/components/schemas/address"
                            }
                        ]
                    },
                    "cumulativeGasUsed": {
                        "title": "cumulative gas used",
                        "description": "The sum of gas used by this transaction and all preceding transactions in the same block.",
                        "$ref": "#/components/schemas/uint"
                    },
                    "gasUsed": {
                        "title": "gas used",
                        "description": "The amount of gas used for this specific transaction alone.",
                        "$ref": "#/components/schemas/uint"
                    },
                    "blobGasUsed": {
                        "title": "blob gas used",
                        "description": "The amount of blob gas used for this specific transaction. Only specified for blob transactions as defined by EIP-4844.",
                        "$ref": "#/components/schemas/uint"
                    },
                    "contractAddress": {
                        "title": "contract address",
                        "description": "The contract address created, if the transaction was a contract creation, otherwise null.",
                        "oneOf": [
                            {
                                "$ref": "#/components/schemas/address"
                            },
                            {
                                "title": "Null",
                                "type": "null"
                            }
                        ]
                    },
                    "logs": {
                        "title": "logs",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/Log"
                        }
                    },
                    "logsBloom": {
                        "title": "logs bloom",
                        "$ref": "#/components/schemas/bytes256"
                    },
                    "root": {
                        "title": "state root",
                        "description": "The post-transaction state root. Only specified for transactions included before the Byzantium upgrade.",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "status": {
                        "title": "status",
                        "description": "Either 1 (success) or 0 (failure). Only specified for transactions included after the Byzantium upgrade.",
                        "$ref": "#/components/schemas/uint"
                    },
                    "effectiveGasPrice": {
                        "title": "effective gas price",
                        "description": "The actual value per gas deducted from the sender's account. Before EIP-1559, this is equal to the transaction's gas price. After, it is equal to baseFeePerGas + min(maxFeePerGas - baseFeePerGas, maxPriorityFeePerGas).",
                        "$ref": "#/components/schemas/uint"
                    },
                    "blobGasPrice": {
                        "title": "blob gas price",
                        "description": "The actual value per gas deducted from the sender's account for blob gas. Only specified for blob transactions as defined by EIP-4844.",
                        "$ref": "#/components/schemas/uint"
                    }
                }
            },
            "AccountProof": {
                "title": "Account proof",
                "type": "object",
                "required": [
                    "address",
                    "accountProof",
                    "balance",
                    "codeHash",
                    "nonce",
                    "storageHash",
                    "storageProof"
                ],
                "additionalProperties": false,
                "properties": {
                    "address": {
                        "title": "address",
                        "$ref": "#/components/schemas/address"
                    },
                    "accountProof": {
                        "title": "accountProof",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/bytes"
                        }
                    },
                    "balance": {
                        "title": "balance",
                        "$ref": "#/components/schemas/uint256"
                    },
                    "codeHash": {
                        "title": "codeHash",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "nonce": {
                        "title": "nonce",
                        "$ref": "#/components/schemas/uint64"
                    },
                    "storageHash": {
                        "title": "storageHash",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "storageProof": {
                        "title": "Storage proofs",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/StorageProof"
                        }
                    }
                }
            },
            "StorageProof": {
                "title": "Storage proof",
                "type": "object",
                "required": [
                    "key",
                    "value",
                    "proof"
                ],
                "additionalProperties": false,
                "properties": {
                    "key": {
                        "title": "key",
                        "$ref": "#/components/schemas/bytesMax32"
                    },
                    "value": {
                        "title": "value",
                        "$ref": "#/components/schemas/uint256"
                    },
                    "proof": {
                        "title": "proof",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/bytes"
                        }
                    }
                }
            },
            "Transaction4844Unsigned": {
                "type": "object",
                "title": "EIP-4844 transaction.",
                "required": [
                    "type",
                    "nonce",
                    "to",
                    "gas",
                    "value",
                    "input",
                    "maxPriorityFeePerGas",
                    "maxFeePerGas",
                    "maxFeePerBlobGas",
                    "accessList",
                    "blobVersionedHashes",
                    "chainId"
                ],
                "properties": {
                    "type": {
                        "title": "type",
                        "$ref": "#/components/schemas/byte"
                    },
                    "nonce": {
                        "title": "nonce",
                        "$ref": "#/components/schemas/uint"
                    },
                    "to": {
                        "title": "to address",
                        "$ref": "#/components/schemas/address"
                    },
                    "gas": {
                        "title": "gas limit",
                        "$ref": "#/components/schemas/uint"
                    },
                    "value": {
                        "title": "value",
                        "$ref": "#/components/schemas/uint"
                    },
                    "input": {
                        "title": "input data",
                        "$ref": "#/components/schemas/bytes"
                    },
                    "maxPriorityFeePerGas": {
                        "title": "max priority fee per gas",
                        "description": "Maximum fee per gas the sender is willing to pay to miners in wei",
                        "$ref": "#/components/schemas/uint"
                    },
                    "maxFeePerGas": {
                        "title": "max fee per gas",
                        "description": "The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",
                        "$ref": "#/components/schemas/uint"
                    },
                    "maxFeePerBlobGas": {
                        "title": "max fee per blob gas",
                        "description": "The maximum total fee per gas the sender is willing to pay for blob gas in wei",
                        "$ref": "#/components/schemas/uint"
                    },
                    "accessList": {
                        "title": "accessList",
                        "description": "EIP-2930 access list",
                        "$ref": "#/components/schemas/AccessList"
                    },
                    "blobVersionedHashes": {
                        "title": "blobVersionedHashes",
                        "description": "List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/hash32"
                        }
                    },
                    "chainId": {
                        "title": "chainId",
                        "description": "Chain ID that this transaction is valid on.",
                        "$ref": "#/components/schemas/uint"
                    }
                }
            },
            "AccessListEntry": {
                "title": "Access list entry",
                "type": "object",
                "additionalProperties": false,
                "properties": {
                    "address": {
                        "$ref": "#/components/schemas/address"
                    },
                    "storageKeys": {
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/hash32"
                        }
                    }
                }
            },
            "AccessList": {
                "title": "Access list",
                "type": "array",
                "items": {
                    "$ref": "#/components/schemas/AccessListEntry"
                }
            },
            "Transaction1559Unsigned": {
                "type": "object",
                "title": "EIP-1559 transaction.",
                "required": [
                    "type",
                    "nonce",
                    "gas",
                    "value",
                    "input",
                    "maxFeePerGas",
                    "maxPriorityFeePerGas",
                    "gasPrice",
                    "chainId",
                    "accessList"
                ],
                "properties": {
                    "type": {
                        "title": "type",
                        "type": "string",
                        "pattern": "^0x2$"
                    },
                    "nonce": {
                        "title": "nonce",
                        "$ref": "#/components/schemas/uint"
                    },
                    "to": {
                        "title": "to address",
                        "oneOf": [
                            {
                                "title": "Contract Creation (null)",
                                "type": "null"
                            },
                            {
                                "title": "Address",
                                "$ref": "#/components/schemas/address"
                            }
                        ]
                    },
                    "gas": {
                        "title": "gas limit",
                        "$ref": "#/components/schemas/uint"
                    },
                    "value": {
                        "title": "value",
                        "$ref": "#/components/schemas/uint"
                    },
                    "input": {
                        "title": "input data",
                        "$ref": "#/components/schemas/bytes"
                    },
                    "maxPriorityFeePerGas": {
                        "title": "max priority fee per gas",
                        "description": "Maximum fee per gas the sender is willing to pay to miners in wei",
                        "$ref": "#/components/schemas/uint"
                    },
                    "maxFeePerGas": {
                        "title": "max fee per gas",
                        "description": "The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",
                        "$ref": "#/components/schemas/uint"
                    },
                    "gasPrice": {
                        "title": "gas price",
                        "description": "The effective gas price paid by the sender in wei. For transactions not yet included in a block, this value should be set equal to the max fee per gas. This field is DEPRECATED, please transition to using effectiveGasPrice in the receipt object going forward.",
                        "$ref": "#/components/schemas/uint"
                    },
                    "accessList": {
                        "title": "accessList",
                        "description": "EIP-2930 access list",
                        "$ref": "#/components/schemas/AccessList"
                    },
                    "chainId": {
                        "title": "chainId",
                        "description": "Chain ID that this transaction is valid on.",
                        "$ref": "#/components/schemas/uint"
                    }
                }
            },
            "Transaction2930Unsigned": {
                "type": "object",
                "title": "EIP-2930 transaction.",
                "required": [
                    "type",
                    "nonce",
                    "gas",
                    "value",
                    "input",
                    "gasPrice",
                    "chainId",
                    "accessList"
                ],
                "properties": {
                    "type": {
                        "title": "type",
                        "type": "string",
                        "pattern": "^0x1$"
                    },
                    "nonce": {
                        "title": "nonce",
                        "$ref": "#/components/schemas/uint"
                    },
                    "to": {
                        "title": "to address",
                        "oneOf": [
                            {
                                "title": "Contract Creation (null)",
                                "type": "null"
                            },
                            {
                                "title": "Address",
                                "$ref": "#/components/schemas/address"
                            }
                        ]
                    },
                    "gas": {
                        "title": "gas limit",
                        "$ref": "#/components/schemas/uint"
                    },
                    "value": {
                        "title": "value",
                        "$ref": "#/components/schemas/uint"
                    },
                    "input": {
                        "title": "input data",
                        "$ref": "#/components/schemas/bytes"
                    },
                    "gasPrice": {
                        "title": "gas price",
                        "description": "The gas price willing to be paid by the sender in wei",
                        "$ref": "#/components/schemas/uint"
                    },
                    "accessList": {
                        "title": "accessList",
                        "description": "EIP-2930 access list",
                        "$ref": "#/components/schemas/AccessList"
                    },
                    "chainId": {
                        "title": "chainId",
                        "description": "Chain ID that this transaction is valid on.",
                        "$ref": "#/components/schemas/uint"
                    }
                }
            },
            "TransactionLegacyUnsigned": {
                "type": "object",
                "title": "Legacy transaction.",
                "required": [
                    "type",
                    "nonce",
                    "gas",
                    "value",
                    "input",
                    "gasPrice"
                ],
                "properties": {
                    "type": {
                        "title": "type",
                        "type": "string",
                        "pattern": "^0x0$"
                    },
                    "nonce": {
                        "title": "nonce",
                        "$ref": "#/components/schemas/uint"
                    },
                    "to": {
                        "title": "to address",
                        "oneOf": [
                            {
                                "title": "Contract Creation (null)",
                                "type": "null"
                            },
                            {
                                "title": "Address",
                                "$ref": "#/components/schemas/address"
                            }
                        ]
                    },
                    "gas": {
                        "title": "gas limit",
                        "$ref": "#/components/schemas/uint"
                    },
                    "value": {
                        "title": "value",
                        "$ref": "#/components/schemas/uint"
                    },
                    "input": {
                        "title": "input data",
                        "$ref": "#/components/schemas/bytes"
                    },
                    "gasPrice": {
                        "title": "gas price",
                        "description": "The gas price willing to be paid by the sender in wei",
                        "$ref": "#/components/schemas/uint"
                    },
                    "chainId": {
                        "title": "chainId",
                        "description": "Chain ID that this transaction is valid on.",
                        "$ref": "#/components/schemas/uint"
                    }
                }
            },
            "TransactionUnsigned": {
                "oneOf": [
                    {
                        "$ref": "#/components/schemas/Transaction4844Unsigned"
                    },
                    {
                        "$ref": "#/components/schemas/Transaction1559Unsigned"
                    },
                    {
                        "$ref": "#/components/schemas/Transaction2930Unsigned"
                    },
                    {
                        "$ref": "#/components/schemas/TransactionLegacyUnsigned"
                    }
                ]
            },
            "Transaction4844Signed": {
                "title": "Signed 4844 Transaction",
                "type": "object",
                "allOf": [
                    {
                        "$ref": "#/components/schemas/Transaction4844Unsigned"
                    },
                    {
                        "title": "EIP-4844 transaction signature properties.",
                        "required": [
                            "yParity",
                            "r",
                            "s"
                        ],
                        "properties": {
                            "yParity": {
                                "title": "yParity",
                                "description": "The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",
                                "$ref": "#/components/schemas/uint"
                            },
                            "r": {
                                "title": "r",
                                "$ref": "#/components/schemas/uint"
                            },
                            "s": {
                                "title": "s",
                                "$ref": "#/components/schemas/uint"
                            }
                        }
                    }
                ]
            },
            "Transaction1559Signed": {
                "title": "Signed 1559 Transaction",
                "type": "object",
                "allOf": [
                    {
                        "$ref": "#/components/schemas/Transaction1559Unsigned"
                    },
                    {
                        "title": "EIP-1559 transaction signature properties.",
                        "required": [
                            "yParity",
                            "r",
                            "s"
                        ],
                        "properties": {
                            "yParity": {
                                "title": "yParity",
                                "description": "The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",
                                "$ref": "#/components/schemas/uint"
                            },
                            "v": {
                                "title": "v",
                                "description": "For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",
                                "$ref": "#/components/schemas/uint"
                            },
                            "r": {
                                "title": "r",
                                "$ref": "#/components/schemas/uint"
                            },
                            "s": {
                                "title": "s",
                                "$ref": "#/components/schemas/uint"
                            }
                        }
                    }
                ]
            },
            "Transaction2930Signed": {
                "title": "Signed 2930 Transaction",
                "type": "object",
                "allOf": [
                    {
                        "$ref": "#/components/schemas/Transaction2930Unsigned"
                    },
                    {
                        "title": "EIP-2930 transaction signature properties.",
                        "required": [
                            "yParity",
                            "r",
                            "s"
                        ],
                        "properties": {
                            "yParity": {
                                "title": "yParity",
                                "description": "The parity (0 for even, 1 for odd) of the y-value of the secp256k1 signature.",
                                "$ref": "#/components/schemas/uint"
                            },
                            "v": {
                                "title": "v",
                                "description": "For backwards compatibility, `v` is optionally provided as an alternative to `yParity`. This field is DEPRECATED and all use of it should migrate to `yParity`.",
                                "$ref": "#/components/schemas/uint"
                            },
                            "r": {
                                "title": "r",
                                "$ref": "#/components/schemas/uint"
                            },
                            "s": {
                                "title": "s",
                                "$ref": "#/components/schemas/uint"
                            }
                        }
                    }
                ]
            },
            "TransactionLegacySigned": {
                "title": "Signed Legacy Transaction",
                "type": "object",
                "allOf": [
                    {
                        "$ref": "#/components/schemas/TransactionLegacyUnsigned"
                    },
                    {
                        "title": "Legacy transaction signature properties.",
                        "required": [
                            "v",
                            "r",
                            "s"
                        ],
                        "properties": {
                            "v": {
                                "title": "v",
                                "$ref": "#/components/schemas/uint"
                            },
                            "r": {
                                "title": "r",
                                "$ref": "#/components/schemas/uint"
                            },
                            "s": {
                                "title": "s",
                                "$ref": "#/components/schemas/uint"
                            }
                        }
                    }
                ]
            },
            "TransactionSigned": {
                "oneOf": [
                    {
                        "$ref": "#/components/schemas/Transaction4844Signed"
                    },
                    {
                        "$ref": "#/components/schemas/Transaction1559Signed"
                    },
                    {
                        "$ref": "#/components/schemas/Transaction2930Signed"
                    },
                    {
                        "$ref": "#/components/schemas/TransactionLegacySigned"
                    }
                ]
            },
            "TransactionInfo": {
                "type": "object",
                "title": "Transaction information",
                "allOf": [
                    {
                        "title": "Contextual information",
                        "required": [
                            "blockHash",
                            "blockNumber",
                            "from",
                            "hash",
                            "transactionIndex"
                        ],
                        "unevaluatedProperties": false,
                        "properties": {
                            "blockHash": {
                                "title": "block hash",
                                "$ref": "#/components/schemas/hash32"
                            },
                            "blockNumber": {
                                "title": "block number",
                                "$ref": "#/components/schemas/uint"
                            },
                            "from": {
                                "title": "from address",
                                "$ref": "#/components/schemas/address"
                            },
                            "hash": {
                                "title": "transaction hash",
                                "$ref": "#/components/schemas/hash32"
                            },
                            "transactionIndex": {
                                "title": "transaction index",
                                "$ref": "#/components/schemas/uint"
                            }
                        }
                    },
                    {
                        "$ref": "#/components/schemas/TransactionSigned"
                    }
                ]
            },
            "GenericTransaction": {
                "type": "object",
                "title": "Transaction object generic to all types",
                "additionalProperties": false,
                "properties": {
                    "type": {
                        "title": "type",
                        "$ref": "#/components/schemas/byte"
                    },
                    "nonce": {
                        "title": "nonce",
                        "$ref": "#/components/schemas/uint"
                    },
                    "to": {
                        "title": "to address",
                        "oneOf": [
                            {
                                "title": "Contract Creation (null)",
                                "type": "null"
                            },
                            {
                                "title": "Address",
                                "$ref": "#/components/schemas/address"
                            }
                        ]
                    },
                    "from": {
                        "title": "from address",
                        "$ref": "#/components/schemas/address"
                    },
                    "gas": {
                        "title": "gas limit",
                        "$ref": "#/components/schemas/uint"
                    },
                    "value": {
                        "title": "value",
                        "$ref": "#/components/schemas/uint"
                    },
                    "input": {
                        "title": "input data",
                        "$ref": "#/components/schemas/bytes"
                    },
                    "gasPrice": {
                        "title": "gas price",
                        "description": "The gas price willing to be paid by the sender in wei",
                        "$ref": "#/components/schemas/uint"
                    },
                    "maxPriorityFeePerGas": {
                        "title": "max priority fee per gas",
                        "description": "Maximum fee per gas the sender is willing to pay to miners in wei",
                        "$ref": "#/components/schemas/uint"
                    },
                    "maxFeePerGas": {
                        "title": "max fee per gas",
                        "description": "The maximum total fee per gas the sender is willing to pay (includes the network / base fee and miner / priority fee) in wei",
                        "$ref": "#/components/schemas/uint"
                    },
                    "maxFeePerBlobGas": {
                        "title": "max fee per blob gas",
                        "description": "The maximum total fee per gas the sender is willing to pay for blob gas in wei",
                        "$ref": "#/components/schemas/uint"
                    },
                    "accessList": {
                        "title": "accessList",
                        "description": "EIP-2930 access list",
                        "$ref": "#/components/schemas/AccessList"
                    },
                    "blobVersionedHashes": {
                        "title": "blobVersionedHashes",
                        "description": "List of versioned blob hashes associated with the transaction's EIP-4844 data blobs.",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/hash32"
                        }
                    },
                    "blobs": {
                        "title": "blobs",
                        "description": "Raw blob data.",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/bytes"
                        }
                    },
                    "chainId": {
                        "title": "chainId",
                        "description": "Chain ID that this transaction is valid on.",
                        "$ref": "#/components/schemas/uint"
                    }
                }
            },
            "Withdrawal": {
                "type": "object",
                "title": "Validator withdrawal",
                "required": [
                    "index",
                    "validatorIndex",
                    "address",
                    "amount"
                ],
                "additionalProperties": false,
                "properties": {
                    "index": {
                        "title": "index of withdrawal",
                        "$ref": "#/components/schemas/uint64"
                    },
                    "validatorIndex": {
                        "title": "index of validator that generated withdrawal",
                        "$ref": "#/components/schemas/uint64"
                    },
                    "address": {
                        "title": "recipient address for withdrawal value",
                        "$ref": "#/components/schemas/address"
                    },
                    "amount": {
                        "title": "value contained in withdrawal",
                        "$ref": "#/components/schemas/uint256"
                    }
                }
            },
            "ForkchoiceStateV1": {
                "title": "Forkchoice state object V1",
                "type": "object",
                "required": [
                    "headBlockHash",
                    "safeBlockHash",
                    "finalizedBlockHash"
                ],
                "properties": {
                    "headBlockHash": {
                        "title": "Head block hash",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "safeBlockHash": {
                        "title": "Safe block hash",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "finalizedBlockHash": {
                        "title": "Finalized block hash",
                        "$ref": "#/components/schemas/hash32"
                    }
                }
            },
            "ForkchoiceUpdatedResponseV1": {
                "title": "Forkchoice updated response",
                "type": "object",
                "required": [
                    "payloadStatus"
                ],
                "properties": {
                    "payloadStatus": {
                        "title": "Payload status",
                        "$ref": "#/components/schemas/RestrictedPayloadStatusV1"
                    },
                    "payloadId": {
                        "title": "Payload id",
                        "$ref": "#/components/schemas/bytes8"
                    }
                }
            },
            "PayloadAttributesV1": {
                "title": "Payload attributes object V1",
                "type": "object",
                "required": [
                    "timestamp",
                    "prevRandao",
                    "suggestedFeeRecipient"
                ],
                "properties": {
                    "timestamp": {
                        "title": "Timestamp",
                        "$ref": "#/components/schemas/uint64"
                    },
                    "prevRandao": {
                        "title": "Previous randao value",
                        "$ref": "#/components/schemas/bytes32"
                    },
                    "suggestedFeeRecipient": {
                        "title": "Suggested fee recipient",
                        "$ref": "#/components/schemas/address"
                    }
                }
            },
            "PayloadAttributesV2": {
                "title": "Payload attributes object V2",
                "type": "object",
                "required": [
                    "timestamp",
                    "prevRandao",
                    "suggestedFeeRecipient",
                    "withdrawals"
                ],
                "properties": {
                    "timestamp": {
                        "$ref": "#/components/schemas/PayloadAttributesV1/properties/timestamp"
                    },
                    "prevRandao": {
                        "$ref": "#/components/schemas/PayloadAttributesV1/properties/prevRandao"
                    },
                    "suggestedFeeRecipient": {
                        "$ref": "#/components/schemas/PayloadAttributesV1/properties/suggestedFeeRecipient"
                    },
                    "withdrawals": {
                        "title": "Withdrawals",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/WithdrawalV1"
                        }
                    }
                }
            },
            "PayloadAttributesV3": {
                "title": "Payload attributes object V3",
                "type": "object",
                "required": [
                    "timestamp",
                    "prevRandao",
                    "suggestedFeeRecipient",
                    "withdrawals",
                    "parentBeaconBlockRoot"
                ],
                "properties": {
                    "timestamp": {
                        "$ref": "#/components/schemas/PayloadAttributesV2/properties/timestamp"
                    },
                    "prevRandao": {
                        "$ref": "#/components/schemas/PayloadAttributesV2/properties/prevRandao"
                    },
                    "suggestedFeeRecipient": {
                        "$ref": "#/components/schemas/PayloadAttributesV2/properties/suggestedFeeRecipient"
                    },
                    "withdrawals": {
                        "$ref": "#/components/schemas/PayloadAttributesV2/properties/withdrawals"
                    },
                    "parentBeaconBlockRoot": {
                        "title": "Parent beacon block root",
                        "$ref": "#/components/schemas/hash32"
                    }
                }
            },
            "PayloadStatusV1": {
                "title": "Payload status object V1",
                "type": "object",
                "required": [
                    "status"
                ],
                "properties": {
                    "status": {
                        "title": "Payload validation status",
                        "type": "string",
                        "enum": [
                            "VALID",
                            "INVALID",
                            "SYNCING",
                            "ACCEPTED",
                            "INVALID_BLOCK_HASH"
                        ]
                    },
                    "latestValidHash": {
                        "title": "The hash of the most recent valid block",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "validationError": {
                        "title": "Validation error message",
                        "type": "string"
                    }
                }
            },
            "RestrictedPayloadStatusV1": {
                "$ref": "#/components/schemas/PayloadStatusV1",
                "properties": {
                    "status": {
                        "$ref": "#/components/schemas/PayloadStatusV1/properties/status",
                        "description": "Set of possible values is restricted to VALID, INVALID, SYNCING",
                        "enum": [
                            "VALID",
                            "INVALID",
                            "SYNCING"
                        ]
                    },
                    "latestValidHash": {
                        "$ref": "#/components/schemas/PayloadStatusV1/properties/latestValidHash"
                    },
                    "validationError": {
                        "$ref": "#/components/schemas/PayloadStatusV1/properties/validationError"
                    }
                }
            },
            "PayloadStatusNoInvalidBlockHash": {
                "$ref": "#/components/schemas/PayloadStatusV1",
                "title": "Payload status object deprecating INVALID_BLOCK_HASH status",
                "properties": {
                    "status": {
                        "$ref": "#/components/schemas/PayloadStatusV1/properties/status",
                        "enum": [
                            "VALID",
                            "INVALID",
                            "SYNCING",
                            "ACCEPTED"
                        ]
                    },
                    "latestValidHash": {
                        "$ref": "#/components/schemas/PayloadStatusV1/properties/latestValidHash"
                    },
                    "validationError": {
                        "$ref": "#/components/schemas/PayloadStatusV1/properties/validationError"
                    }
                }
            },
            "ExecutionPayloadV1": {
                "title": "Execution payload object V1",
                "type": "object",
                "required": [
                    "parentHash",
                    "feeRecipient",
                    "stateRoot",
                    "receiptsRoot",
                    "logsBloom",
                    "prevRandao",
                    "blockNumber",
                    "gasLimit",
                    "gasUsed",
                    "timestamp",
                    "extraData",
                    "baseFeePerGas",
                    "blockHash",
                    "transactions"
                ],
                "properties": {
                    "parentHash": {
                        "title": "Parent block hash",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "feeRecipient": {
                        "title": "Recipient of transaction priority fees",
                        "$ref": "#/components/schemas/address"
                    },
                    "stateRoot": {
                        "title": "State root",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "receiptsRoot": {
                        "title": "Receipts root",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "logsBloom": {
                        "title": "Bloom filter",
                        "$ref": "#/components/schemas/bytes256"
                    },
                    "prevRandao": {
                        "title": "Previous randao value",
                        "$ref": "#/components/schemas/bytes32"
                    },
                    "blockNumber": {
                        "title": "Block number",
                        "$ref": "#/components/schemas/uint64"
                    },
                    "gasLimit": {
                        "title": "Gas limit",
                        "$ref": "#/components/schemas/uint64"
                    },
                    "gasUsed": {
                        "title": "Gas used",
                        "$ref": "#/components/schemas/uint64"
                    },
                    "timestamp": {
                        "title": "Timestamp",
                        "$ref": "#/components/schemas/uint64"
                    },
                    "extraData": {
                        "title": "Extra data",
                        "$ref": "#/components/schemas/bytesMax32"
                    },
                    "baseFeePerGas": {
                        "title": "Base fee per gas",
                        "$ref": "#/components/schemas/uint256"
                    },
                    "blockHash": {
                        "title": "Block hash",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "transactions": {
                        "title": "Transactions",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/bytes"
                        }
                    }
                }
            },
            "WithdrawalV1": {
                "title": "Withdrawal object V1",
                "type": "object",
                "required": [
                    "index",
                    "validatorIndex",
                    "address",
                    "amount"
                ],
                "properties": {
                    "index": {
                        "title": "Withdrawal index",
                        "$ref": "#/components/schemas/uint64"
                    },
                    "validatorIndex": {
                        "title": "Validator index",
                        "$ref": "#/components/schemas/uint64"
                    },
                    "address": {
                        "title": "Withdrawal address",
                        "$ref": "#/components/schemas/address"
                    },
                    "amount": {
                        "title": "Withdrawal amount",
                        "$ref": "#/components/schemas/uint64"
                    }
                }
            },
            "ExecutionPayloadV2": {
                "title": "Execution payload object V2",
                "type": "object",
                "required": [
                    "parentHash",
                    "feeRecipient",
                    "stateRoot",
                    "receiptsRoot",
                    "logsBloom",
                    "prevRandao",
                    "blockNumber",
                    "gasLimit",
                    "gasUsed",
                    "timestamp",
                    "extraData",
                    "baseFeePerGas",
                    "blockHash",
                    "transactions",
                    "withdrawals"
                ],
                "properties": {
                    "parentHash": {
                        "$ref": "#/components/schemas/ExecutionPayloadV1/properties/parentHash"
                    },
                    "feeRecipient": {
                        "$ref": "#/components/schemas/ExecutionPayloadV1/properties/feeRecipient"
                    },
                    "stateRoot": {
                        "$ref": "#/components/schemas/ExecutionPayloadV1/properties/stateRoot"
                    },
                    "receiptsRoot": {
                        "$ref": "#/components/schemas/ExecutionPayloadV1/properties/receiptsRoot"
                    },
                    "logsBloom": {
                        "$ref": "#/components/schemas/ExecutionPayloadV1/properties/logsBloom"
                    },
                    "prevRandao": {
                        "$ref": "#/components/schemas/ExecutionPayloadV1/properties/prevRandao"
                    },
                    "blockNumber": {
                        "$ref": "#/components/schemas/ExecutionPayloadV1/properties/blockNumber"
                    },
                    "gasLimit": {
                        "$ref": "#/components/schemas/ExecutionPayloadV1/properties/gasLimit"
                    },
                    "gasUsed": {
                        "$ref": "#/components/schemas/ExecutionPayloadV1/properties/gasUsed"
                    },
                    "timestamp": {
                        "$ref": "#/components/schemas/ExecutionPayloadV1/properties/timestamp"
                    },
                    "extraData": {
                        "$ref": "#/components/schemas/ExecutionPayloadV1/properties/extraData"
                    },
                    "baseFeePerGas": {
                        "$ref": "#/components/schemas/ExecutionPayloadV1/properties/baseFeePerGas"
                    },
                    "blockHash": {
                        "$ref": "#/components/schemas/ExecutionPayloadV1/properties/blockHash"
                    },
                    "transactions": {
                        "$ref": "#/components/schemas/ExecutionPayloadV1/properties/transactions"
                    },
                    "withdrawals": {
                        "title": "Withdrawals",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/WithdrawalV1"
                        }
                    }
                }
            },
            "ExecutionPayloadV3": {
                "title": "Execution payload object V3",
                "type": "object",
                "required": [
                    "parentHash",
                    "feeRecipient",
                    "stateRoot",
                    "receiptsRoot",
                    "logsBloom",
                    "prevRandao",
                    "blockNumber",
                    "gasLimit",
                    "gasUsed",
                    "timestamp",
                    "extraData",
                    "baseFeePerGas",
                    "blockHash",
                    "transactions",
                    "withdrawals",
                    "blobGasUsed",
                    "excessBlobGas"
                ],
                "properties": {
                    "parentHash": {
                        "$ref": "#/components/schemas/ExecutionPayloadV2/properties/parentHash"
                    },
                    "feeRecipient": {
                        "$ref": "#/components/schemas/ExecutionPayloadV2/properties/feeRecipient"
                    },
                    "stateRoot": {
                        "$ref": "#/components/schemas/ExecutionPayloadV2/properties/stateRoot"
                    },
                    "receiptsRoot": {
                        "$ref": "#/components/schemas/ExecutionPayloadV2/properties/receiptsRoot"
                    },
                    "logsBloom": {
                        "$ref": "#/components/schemas/ExecutionPayloadV2/properties/logsBloom"
                    },
                    "prevRandao": {
                        "$ref": "#/components/schemas/ExecutionPayloadV2/properties/prevRandao"
                    },
                    "blockNumber": {
                        "$ref": "#/components/schemas/ExecutionPayloadV2/properties/blockNumber"
                    },
                    "gasLimit": {
                        "$ref": "#/components/schemas/ExecutionPayloadV2/properties/gasLimit"
                    },
                    "gasUsed": {
                        "$ref": "#/components/schemas/ExecutionPayloadV2/properties/gasUsed"
                    },
                    "timestamp": {
                        "$ref": "#/components/schemas/ExecutionPayloadV2/properties/timestamp"
                    },
                    "extraData": {
                        "$ref": "#/components/schemas/ExecutionPayloadV2/properties/extraData"
                    },
                    "baseFeePerGas": {
                        "$ref": "#/components/schemas/ExecutionPayloadV2/properties/baseFeePerGas"
                    },
                    "blockHash": {
                        "$ref": "#/components/schemas/ExecutionPayloadV2/properties/blockHash"
                    },
                    "transactions": {
                        "$ref": "#/components/schemas/ExecutionPayloadV2/properties/transactions"
                    },
                    "withdrawals": {
                        "$ref": "#/components/schemas/ExecutionPayloadV2/properties/withdrawals"
                    },
                    "blobGasUsed": {
                        "title": "Blob gas used",
                        "$ref": "#/components/schemas/uint64"
                    },
                    "excessBlobGas": {
                        "title": "Excess blob gas",
                        "$ref": "#/components/schemas/uint64"
                    }
                }
            },
            "ExecutionPayloadV4": {
                "title": "Execution payload object V4",
                "type": "object",
                "required": [
                    "parentHash",
                    "feeRecipient",
                    "stateRoot",
                    "receiptsRoot",
                    "logsBloom",
                    "prevRandao",
                    "blockNumber",
                    "gasLimit",
                    "gasUsed",
                    "timestamp",
                    "extraData",
                    "baseFeePerGas",
                    "blockHash",
                    "transactions",
                    "withdrawals",
                    "blobGasUsed",
                    "excessBlobGas",
                    "depositRequests",
                    "withdrawalRequests",
                    "consolidationRequests"
                ],
                "properties": {
                    "parentHash": {
                        "$ref": "#/components/schemas/ExecutionPayloadV3/properties/parentHash"
                    },
                    "feeRecipient": {
                        "$ref": "#/components/schemas/ExecutionPayloadV3/properties/feeRecipient"
                    },
                    "stateRoot": {
                        "$ref": "#/components/schemas/ExecutionPayloadV3/properties/stateRoot"
                    },
                    "receiptsRoot": {
                        "$ref": "#/components/schemas/ExecutionPayloadV3/properties/receiptsRoot"
                    },
                    "logsBloom": {
                        "$ref": "#/components/schemas/ExecutionPayloadV3/properties/logsBloom"
                    },
                    "prevRandao": {
                        "$ref": "#/components/schemas/ExecutionPayloadV3/properties/prevRandao"
                    },
                    "blockNumber": {
                        "$ref": "#/components/schemas/ExecutionPayloadV3/properties/blockNumber"
                    },
                    "gasLimit": {
                        "$ref": "#/components/schemas/ExecutionPayloadV3/properties/gasLimit"
                    },
                    "gasUsed": {
                        "$ref": "#/components/schemas/ExecutionPayloadV3/properties/gasUsed"
                    },
                    "timestamp": {
                        "$ref": "#/components/schemas/ExecutionPayloadV3/properties/timestamp"
                    },
                    "extraData": {
                        "$ref": "#/components/schemas/ExecutionPayloadV3/properties/extraData"
                    },
                    "baseFeePerGas": {
                        "$ref": "#/components/schemas/ExecutionPayloadV3/properties/baseFeePerGas"
                    },
                    "blockHash": {
                        "$ref": "#/components/schemas/ExecutionPayloadV3/properties/blockHash"
                    },
                    "transactions": {
                        "$ref": "#/components/schemas/ExecutionPayloadV3/properties/transactions"
                    },
                    "withdrawals": {
                        "$ref": "#/components/schemas/ExecutionPayloadV3/properties/withdrawals"
                    },
                    "blobGasUsed": {
                        "$ref": "#/components/schemas/ExecutionPayloadV3/properties/blobGasUsed"
                    },
                    "excessBlobGas": {
                        "$ref": "#/components/schemas/ExecutionPayloadV3/properties/excessBlobGas"
                    },
                    "depositRequests": {
                        "title": "Deposit requests",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/DepositRequestV1"
                        }
                    },
                    "withdrawalRequests": {
                        "title": "Withdrawals requests",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/WithdrawalRequestV1"
                        }
                    },
                    "consolidationRequests": {
                        "title": "Consolidation requests",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/ConsolidationRequestV1"
                        }
                    }
                }
            },
            "ExecutionPayloadBodyV1": {
                "title": "Execution payload body object V1",
                "type": "object",
                "required": [
                    "transactions"
                ],
                "properties": {
                    "transactions": {
                        "$ref": "#/components/schemas/ExecutionPayloadV1/properties/transactions"
                    },
                    "withdrawals": {
                        "title": "Withdrawals",
                        "type": [
                            "array",
                            "null"
                        ],
                        "items": {
                            "$ref": "#/components/schemas/WithdrawalV1"
                        }
                    }
                }
            },
            "ExecutionPayloadBodyV2": {
                "title": "Execution payload body object V2",
                "type": "object",
                "required": [
                    "transactions"
                ],
                "properties": {
                    "transactions": {
                        "title": "Transactions",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/bytes"
                        }
                    },
                    "withdrawals": {
                        "title": "Withdrawals",
                        "type": [
                            "array",
                            "null"
                        ],
                        "items": {
                            "$ref": "#/components/schemas/WithdrawalV1"
                        }
                    },
                    "depositRequests": {
                        "title": "Deposit requests",
                        "type": [
                            "array",
                            "null"
                        ],
                        "items": {
                            "$ref": "#/components/schemas/DepositRequestV1"
                        }
                    },
                    "withdrawalRequests": {
                        "title": "Withdrawals requests",
                        "type": [
                            "array",
                            "null"
                        ],
                        "items": {
                            "$ref": "#/components/schemas/WithdrawalRequestV1"
                        }
                    },
                    "consolidationRequests": {
                        "title": "Consolidation requests - array - 'null'",
                        "items": {
                            "$ref": "#/components/schemas/ConsolidationRequestV1"
                        }
                    }
                }
            },
            "BlobsBundleV1": {
                "title": "Blobs bundle object V1",
                "type": "object",
                "required": [
                    "commitments",
                    "proofs",
                    "blobs"
                ],
                "properties": {
                    "commitments": {
                        "title": "Commitments",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/bytes48"
                        }
                    },
                    "proofs": {
                        "title": "Proofs",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/bytes48"
                        }
                    },
                    "blobs": {
                        "title": "Blobs",
                        "type": "array",
                        "items": {
                            "$ref": "#/components/schemas/bytes"
                        }
                    }
                }
            },
            "DepositRequestV1": {
                "title": "Deposit request object V1",
                "type": "object",
                "required": [
                    "pubkey",
                    "withdrawalCredentials",
                    "amount",
                    "signature",
                    "index"
                ],
                "properties": {
                    "pubkey": {
                        "title": "Public key",
                        "$ref": "#/components/schemas/bytes48"
                    },
                    "withdrawalCredentials": {
                        "title": "Withdrawal credentials",
                        "$ref": "#/components/schemas/bytes32"
                    },
                    "amount": {
                        "title": "Deposit amount",
                        "$ref": "#/components/schemas/uint64"
                    },
                    "signature": {
                        "title": "Deposit signature",
                        "$ref": "#/components/schemas/bytes96"
                    },
                    "index": {
                        "title": "Deposit index",
                        "$ref": "#/components/schemas/uint64"
                    }
                }
            },
            "WithdrawalRequestV1": {
                "title": "Withdrawal request object V1",
                "type": "object",
                "required": [
                    "sourceAddress",
                    "validatorPubkey",
                    "amount"
                ],
                "properties": {
                    "sourceAddress": {
                        "title": "Source address",
                        "$ref": "#/components/schemas/address"
                    },
                    "validatorPubkey": {
                        "title": "Validator public key",
                        "$ref": "#/components/schemas/bytes48"
                    },
                    "amount": {
                        "title": "Withdraw amount",
                        "$ref": "#/components/schemas/uint64"
                    }
                }
            },
            "ConsolidationRequestV1": {
                "title": "Consolidation request object V1",
                "type": "object",
                "required": [
                    "sourceAddress",
                    "sourcePubkey",
                    "targetPubkey"
                ],
                "properties": {
                    "sourceAddress": {
                        "title": "Source address",
                        "$ref": "#/components/schemas/address"
                    },
                    "sourcePubkey": {
                        "title": "Source validator public key",
                        "$ref": "#/components/schemas/bytes48"
                    },
                    "targetPubkey": {
                        "title": "Target validator public key",
                        "$ref": "#/components/schemas/bytes48"
                    }
                }
            },
            "TransitionConfigurationV1": {
                "title": "Transition configuration object",
                "type": "object",
                "required": [
                    "terminalTotalDifficulty",
                    "terminalBlockHash",
                    "terminalBlockNumber"
                ],
                "properties": {
                    "terminalTotalDifficulty": {
                        "title": "Terminal total difficulty",
                        "$ref": "#/components/schemas/uint256"
                    },
                    "terminalBlockHash": {
                        "title": "Terminal block hash",
                        "$ref": "#/components/schemas/hash32"
                    },
                    "terminalBlockNumber": {
                        "title": "Terminal block number",
                        "$ref": "#/components/schemas/uint64"
                    }
                }
            }
        },
        "tags": {
            "MetaMask": {
                "name": "MetaMask",
                "description": "MetaMask-specific methods."
            },
            "Restricted": {
                "name": "Restricted",
                "description": "Restricted methods. If a method is restricted, the caller must have the corresponding permission via `wallet_requestPermissions` in order to call it."
            },
            "Mobile": {
                "name": "Mobile",
                "description": "Mobile-specific methods."
            },
            "Experimental": {
                "name": "Experimental",
                "description": "Experimental methods."
            },
            "Deprecated": {
                "name": "Deprecated",
                "description": "Deprecated methods."
            },
            "Ethereum": {
                "name": "Ethereum API",
                "description": "Ethereum execution API methods."
            },
            "Multichain": {
                "name": "Multichain API",
                "description": "Multichain API methods."
            }
        },
        "contentDescriptors": {},
        "examplePairings": {},
        "links": {},
        "examples": {}
    }
}

      };
    };
  }
  }
}, {package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules\\@metamask\\multichain-api-middleware\\node_modules\\@metamask\\api-specs\\dist\\build\\openrpc.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\node_modules\\@metamask\\api-specs\\dist\\index.js", {"./build/multichain-openrpc.json":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\node_modules\\@metamask\\api-specs\\dist\\build\\multichain-openrpc.json","./build/openrpc.json":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-api-middleware\\node_modules\\@metamask\\api-specs\\dist\\build\\openrpc.json"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-api-middleware%5Cnode_modules%5C@metamask%5Capi-specs%5Cdist%5Cindex.js
      return function (require, module, exports) {
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultiChainOpenRPCDocument = exports.MetaMaskOpenRPCDocument = void 0;
const openrpc_json_1 = __importDefault(require("./build/openrpc.json"));
exports.MetaMaskOpenRPCDocument = openrpc_json_1.default;
const multichain_openrpc_json_1 = __importDefault(require("./build/multichain-openrpc.json"));
exports.MultiChainOpenRPCDocument = multichain_openrpc_json_1.default;
exports.default = openrpc_json_1.default;

      };
    };
  }
  }
}, {package:"@metamask/multichain-api-middleware>@metamask/api-specs",file:"node_modules\\@metamask\\multichain-api-middleware\\node_modules\\@metamask\\api-specs\\dist\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-enablement-controller\\dist\\NetworkEnablementController.cjs", {"./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-enablement-controller\\dist\\constants.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-enablement-controller\\dist\\utils.cjs","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cnetwork-enablement-controller%5Cdist%5CNetworkEnablementController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _NetworkEnablementController_instances, _NetworkEnablementController_ensureNamespaceBucket, _NetworkEnablementController_isInPopularNetworksMode, _NetworkEnablementController_removeNetworkEntry, _NetworkEnablementController_onAddNetwork;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkEnablementController = void 0;
const base_controller_1 = require("@metamask/base-controller");
const controller_utils_1 = require("@metamask/controller-utils");
const keyring_api_1 = require("@metamask/keyring-api");
const utils_1 = require("@metamask/utils");
const constants_1 = require("./constants.cjs");
const utils_2 = require("./utils.cjs");
const controllerName = 'NetworkEnablementController';
/**
 * Gets the default state for the NetworkEnablementController.
 *
 * @returns The default state with pre-enabled networks.
 */
const getDefaultNetworkEnablementControllerState = () => ({
    enabledNetworkMap: {
        [utils_1.KnownCaipNamespace.Eip155]: {
            [controller_utils_1.ChainId[controller_utils_1.BuiltInNetworkName.Mainnet]]: true,
            [controller_utils_1.ChainId[controller_utils_1.BuiltInNetworkName.LineaMainnet]]: true,
            [controller_utils_1.ChainId[controller_utils_1.BuiltInNetworkName.BaseMainnet]]: true,
        },
        [utils_1.KnownCaipNamespace.Solana]: {
            [keyring_api_1.SolScope.Mainnet]: true,
            [keyring_api_1.SolScope.Testnet]: false,
            [keyring_api_1.SolScope.Devnet]: false,
        },
        [utils_1.KnownCaipNamespace.Bip122]: {
            [keyring_api_1.BtcScope.Mainnet]: true,
            [keyring_api_1.BtcScope.Testnet]: false,
            [keyring_api_1.BtcScope.Signet]: false,
        },
        [utils_1.KnownCaipNamespace.Tron]: {
            [keyring_api_1.TrxScope.Mainnet]: true,
            [keyring_api_1.TrxScope.Nile]: false,
            [keyring_api_1.TrxScope.Shasta]: false,
        },
    },
});
// Metadata for the controller state
const metadata = {
    enabledNetworkMap: {
        includeInStateLogs: true,
        persist: true,
        anonymous: true,
        usedInUi: true,
    },
};
/**
 * Controller responsible for managing network enablement state across different blockchain networks.
 *
 * This controller tracks which networks are enabled/disabled for the user and provides methods
 * to toggle network states. It supports both EVM (EIP-155) and non-EVM networks like Solana.
 *
 * The controller maintains a map of enabled networks organized by namespace (e.g., 'eip155', 'solana')
 * and provides methods to query and modify network enablement states.
 */
class NetworkEnablementController extends base_controller_1.BaseController {
    /**
     * Creates a NetworkEnablementController instance.
     *
     * @param args - The arguments to this function.
     * @param args.messenger - Messenger used to communicate with BaseV2 controller.
     * @param args.state - Initial state to set on this controller.
     */
    constructor({ messenger, state, }) {
        super({
            messenger,
            metadata,
            name: controllerName,
            state: {
                ...getDefaultNetworkEnablementControllerState(),
                ...state,
            },
        });
        _NetworkEnablementController_instances.add(this);
        messenger.subscribe('NetworkController:networkAdded', ({ chainId }) => {
            __classPrivateFieldGet(this, _NetworkEnablementController_instances, "m", _NetworkEnablementController_onAddNetwork).call(this, chainId);
        });
        messenger.subscribe('NetworkController:networkRemoved', ({ chainId }) => {
            __classPrivateFieldGet(this, _NetworkEnablementController_instances, "m", _NetworkEnablementController_removeNetworkEntry).call(this, chainId);
        });
    }
    /**
     * Enables or disables a network for the user.
     *
     * This method accepts either a Hex chain ID (for EVM networks) or a CAIP-2 chain ID
     * (for any blockchain network). The method will automatically convert Hex chain IDs
     * to CAIP-2 format internally. This dual parameter support allows for backward
     * compatibility with existing EVM chain ID formats while supporting newer
     * multi-chain standards.
     *
     * When enabling a non-popular network, this method will disable all other networks
     * to ensure only one network is active at a time (exclusive mode).
     *
     * @param chainId - The chain ID of the network to enable or disable. Can be either:
     * - A Hex string (e.g., '0x1' for Ethereum mainnet) for EVM networks
     * - A CAIP-2 chain ID (e.g., 'eip155:1' for Ethereum mainnet, 'solana:mainnet' for Solana)
     */
    enableNetwork(chainId) {
        const { namespace, storageKey } = (0, utils_2.deriveKeys)(chainId);
        this.update((s) => {
            // disable all networks in all namespaces first
            Object.keys(s.enabledNetworkMap).forEach((ns) => {
                Object.keys(s.enabledNetworkMap[ns]).forEach((key) => {
                    s.enabledNetworkMap[ns][key] = false;
                });
            });
            // if the namespace bucket does not exist, return
            // new nemespace are added only when a new network is added
            if (!s.enabledNetworkMap[namespace]) {
                return;
            }
            // enable the network
            s.enabledNetworkMap[namespace][storageKey] = true;
        });
    }
    /**
     * Enables a network for the user within a specific namespace.
     *
     * This method accepts either a Hex chain ID (for EVM networks) or a CAIP-2 chain ID
     * (for any blockchain network) and enables it within the specified namespace.
     * The method validates that the chainId belongs to the specified namespace for safety.
     *
     * Before enabling the target network, this method disables all other networks
     * in the same namespace to ensure exclusive behavior within the namespace.
     *
     * @param chainId - The chain ID of the network to enable. Can be either:
     * - A Hex string (e.g., '0x1' for Ethereum mainnet) for EVM networks
     * - A CAIP-2 chain ID (e.g., 'eip155:1' for Ethereum mainnet, 'solana:mainnet' for Solana)
     * @param namespace - The CAIP namespace where the network should be enabled
     * @throws Error if the chainId's derived namespace doesn't match the provided namespace
     */
    enableNetworkInNamespace(chainId, namespace) {
        const { namespace: derivedNamespace, storageKey } = (0, utils_2.deriveKeys)(chainId);
        // Validate that the derived namespace matches the provided namespace
        if (derivedNamespace !== namespace) {
            throw new Error(`Chain ID ${chainId} belongs to namespace ${derivedNamespace}, but namespace ${namespace} was specified`);
        }
        this.update((s) => {
            // Ensure the namespace bucket exists
            __classPrivateFieldGet(this, _NetworkEnablementController_instances, "m", _NetworkEnablementController_ensureNamespaceBucket).call(this, s, namespace);
            // Disable all networks in the specified namespace first
            if (s.enabledNetworkMap[namespace]) {
                Object.keys(s.enabledNetworkMap[namespace]).forEach((key) => {
                    s.enabledNetworkMap[namespace][key] = false;
                });
            }
            // Enable the target network in the specified namespace
            s.enabledNetworkMap[namespace][storageKey] = true;
        });
    }
    /**
     * Enables all popular networks and Solana mainnet.
     *
     * This method first disables all networks across all namespaces, then enables
     * all networks defined in POPULAR_NETWORKS (EVM networks), Solana mainnet, and
     * Bitcoin mainnet. This provides exclusive behavior - only popular networks will
     * be enabled after calling this method.
     *
     * Popular networks that don't exist in NetworkController or MultichainNetworkController configurations will be skipped silently.
     */
    enableAllPopularNetworks() {
        this.update((s) => {
            // First disable all networks across all namespaces
            Object.keys(s.enabledNetworkMap).forEach((ns) => {
                Object.keys(s.enabledNetworkMap[ns]).forEach((key) => {
                    s.enabledNetworkMap[ns][key] = false;
                });
            });
            // Get current network configurations to check if networks exist
            const networkControllerState = this.messagingSystem.call('NetworkController:getState');
            const multichainState = this.messagingSystem.call('MultichainNetworkController:getState');
            // Enable all popular EVM networks that exist in NetworkController configurations
            constants_1.POPULAR_NETWORKS.forEach((chainId) => {
                const { namespace, storageKey } = (0, utils_2.deriveKeys)(chainId);
                // Check if network exists in NetworkController configurations
                if (networkControllerState.networkConfigurationsByChainId[chainId]) {
                    // Ensure namespace bucket exists
                    __classPrivateFieldGet(this, _NetworkEnablementController_instances, "m", _NetworkEnablementController_ensureNamespaceBucket).call(this, s, namespace);
                    // Enable the network
                    s.enabledNetworkMap[namespace][storageKey] = true;
                }
            });
            // Enable Solana mainnet if it exists in MultichainNetworkController configurations
            const solanaKeys = (0, utils_2.deriveKeys)(keyring_api_1.SolScope.Mainnet);
            if (multichainState.multichainNetworkConfigurationsByChainId[keyring_api_1.SolScope.Mainnet]) {
                // Ensure namespace bucket exists
                __classPrivateFieldGet(this, _NetworkEnablementController_instances, "m", _NetworkEnablementController_ensureNamespaceBucket).call(this, s, solanaKeys.namespace);
                // Enable Solana mainnet
                s.enabledNetworkMap[solanaKeys.namespace][solanaKeys.storageKey] = true;
            }
            // Enable Bitcoin mainnet if it exists in MultichainNetworkController configurations
            const bitcoinKeys = (0, utils_2.deriveKeys)(keyring_api_1.BtcScope.Mainnet);
            if (multichainState.multichainNetworkConfigurationsByChainId[keyring_api_1.BtcScope.Mainnet]) {
                // Ensure namespace bucket exists
                __classPrivateFieldGet(this, _NetworkEnablementController_instances, "m", _NetworkEnablementController_ensureNamespaceBucket).call(this, s, bitcoinKeys.namespace);
                // Enable Bitcoin mainnet
                s.enabledNetworkMap[bitcoinKeys.namespace][bitcoinKeys.storageKey] =
                    true;
            }
            // Enable Tron mainnet if it exists in MultichainNetworkController configurations
            const tronKeys = (0, utils_2.deriveKeys)(keyring_api_1.TrxScope.Mainnet);
            if (multichainState.multichainNetworkConfigurationsByChainId[keyring_api_1.TrxScope.Mainnet]) {
                // Ensure namespace bucket exists
                __classPrivateFieldGet(this, _NetworkEnablementController_instances, "m", _NetworkEnablementController_ensureNamespaceBucket).call(this, s, tronKeys.namespace);
                // Enable Tron mainnet
                s.enabledNetworkMap[tronKeys.namespace][tronKeys.storageKey] = true;
            }
        });
    }
    /**
     * Initializes the network enablement state from network controller configurations.
     *
     * This method reads the current network configurations from both NetworkController
     * and MultichainNetworkController and syncs the enabled network map accordingly.
     * It ensures proper namespace buckets exist for all configured networks and only
     * adds missing networks with a default value of false, preserving existing user settings.
     *
     * This method should be called after the NetworkController and MultichainNetworkController
     * have been initialized and their configurations are available.
     */
    init() {
        this.update((s) => {
            // Get network configurations from NetworkController (EVM networks)
            const networkControllerState = this.messagingSystem.call('NetworkController:getState');
            // Get network configurations from MultichainNetworkController (all networks)
            const multichainState = this.messagingSystem.call('MultichainNetworkController:getState');
            // Initialize namespace buckets for EVM networks from NetworkController
            Object.keys(networkControllerState.networkConfigurationsByChainId).forEach((chainId) => {
                const { namespace, storageKey } = (0, utils_2.deriveKeys)(chainId);
                __classPrivateFieldGet(this, _NetworkEnablementController_instances, "m", _NetworkEnablementController_ensureNamespaceBucket).call(this, s, namespace);
                // Only add network if it doesn't already exist in state (preserves user settings)
                if (s.enabledNetworkMap[namespace][storageKey] === undefined) {
                    s.enabledNetworkMap[namespace][storageKey] = false;
                }
            });
            // Initialize namespace buckets for all networks from MultichainNetworkController
            Object.keys(multichainState.multichainNetworkConfigurationsByChainId).forEach((chainId) => {
                const { namespace, storageKey } = (0, utils_2.deriveKeys)(chainId);
                __classPrivateFieldGet(this, _NetworkEnablementController_instances, "m", _NetworkEnablementController_ensureNamespaceBucket).call(this, s, namespace);
                // Only add network if it doesn't already exist in state (preserves user settings)
                if (s.enabledNetworkMap[namespace][storageKey] === undefined) {
                    s.enabledNetworkMap[namespace][storageKey] = false;
                }
            });
        });
    }
    /**
     * Disables a network for the user.
     *
     * This method accepts either a Hex chain ID (for EVM networks) or a CAIP-2 chain ID
     * (for any blockchain network). The method will automatically convert Hex chain IDs
     * to CAIP-2 format internally.
     *
     * Note: This method will prevent disabling the last remaining enabled network
     * to ensure at least one network is always available.
     *
     * @param chainId - The chain ID of the network to disable. Can be either:
     * - A Hex string (e.g., '0x1' for Ethereum mainnet) for EVM networks
     * - A CAIP-2 chain ID (e.g., 'eip155:1' for Ethereum mainnet, 'solana:mainnet' for Solana)
     */
    disableNetwork(chainId) {
        const derivedKeys = (0, utils_2.deriveKeys)(chainId);
        const { namespace, storageKey } = derivedKeys;
        this.update((s) => {
            s.enabledNetworkMap[namespace][storageKey] = false;
        });
    }
    /**
     * Checks if a network is enabled.
     *
     * @param chainId - The chain ID of the network to check. Can be either:
     * - A Hex string (e.g., '0x1' for Ethereum mainnet) for EVM networks
     * - A CAIP-2 chain ID (e.g., 'eip155:1' for Ethereum mainnet, 'solana:mainnet' for Solana)
     * @returns True if the network is enabled, false otherwise
     */
    isNetworkEnabled(chainId) {
        const derivedKeys = (0, utils_2.deriveKeys)(chainId);
        const { namespace, storageKey } = derivedKeys;
        return this.state.enabledNetworkMap[namespace]?.[storageKey] ?? false;
    }
}
exports.NetworkEnablementController = NetworkEnablementController;
_NetworkEnablementController_instances = new WeakSet(), _NetworkEnablementController_ensureNamespaceBucket = function _NetworkEnablementController_ensureNamespaceBucket(state, ns) {
    if (!state.enabledNetworkMap[ns]) {
        state.enabledNetworkMap[ns] = {};
    }
}, _NetworkEnablementController_isInPopularNetworksMode = function _NetworkEnablementController_isInPopularNetworksMode() {
    // Get current network configurations to check which popular networks exist
    const networkControllerState = this.messagingSystem.call('NetworkController:getState');
    // Count how many popular networks are enabled
    const enabledPopularNetworksCount = constants_1.POPULAR_NETWORKS.reduce((count, chainId) => {
        // Only check networks that actually exist in NetworkController configurations
        if (!networkControllerState.networkConfigurationsByChainId[chainId]) {
            return count; // Skip networks that don't exist
        }
        const { namespace, storageKey } = (0, utils_2.deriveKeys)(chainId);
        const isEnabled = this.state.enabledNetworkMap[namespace]?.[storageKey];
        return isEnabled ? count + 1 : count;
    }, 0);
    // Return true if more than 2 popular networks are enabled
    return enabledPopularNetworksCount > 1;
}, _NetworkEnablementController_removeNetworkEntry = function _NetworkEnablementController_removeNetworkEntry(chainId) {
    const derivedKeys = (0, utils_2.deriveKeys)(chainId);
    const { namespace, storageKey } = derivedKeys;
    this.update((s) => {
        // fallback and enable ethereum mainnet
        if ((0, utils_2.isOnlyNetworkEnabledInNamespace)(this.state, derivedKeys)) {
            s.enabledNetworkMap[namespace][controller_utils_1.ChainId[controller_utils_1.BuiltInNetworkName.Mainnet]] =
                true;
        }
        if (namespace in s.enabledNetworkMap) {
            delete s.enabledNetworkMap[namespace][storageKey];
        }
    });
}, _NetworkEnablementController_onAddNetwork = function _NetworkEnablementController_onAddNetwork(chainId) {
    const { namespace, storageKey, reference } = (0, utils_2.deriveKeys)(chainId);
    this.update((s) => {
        // Ensure the namespace bucket exists
        __classPrivateFieldGet(this, _NetworkEnablementController_instances, "m", _NetworkEnablementController_ensureNamespaceBucket).call(this, s, namespace);
        // Check if popular networks mode is active (>2 popular networks enabled)
        const inPopularNetworksMode = __classPrivateFieldGet(this, _NetworkEnablementController_instances, "m", _NetworkEnablementController_isInPopularNetworksMode).call(this);
        // Check if the network being added is a popular network
        const isAddedNetworkPopular = (0, utils_2.isPopularNetwork)(reference);
        // Keep current selection only if in popular networks mode AND adding a popular network
        const shouldKeepCurrentSelection = inPopularNetworksMode && isAddedNetworkPopular;
        if (shouldKeepCurrentSelection) {
            // Add the popular network but don't enable it (keep current selection)
            s.enabledNetworkMap[namespace][storageKey] = true;
        }
        else {
            // Switch to the newly added network (disable all others, enable this one)
            Object.keys(s.enabledNetworkMap).forEach((ns) => {
                Object.keys(s.enabledNetworkMap[ns]).forEach((key) => {
                    s.enabledNetworkMap[ns][key] = false;
                });
            });
            // Enable the newly added network
            s.enabledNetworkMap[namespace][storageKey] = true;
        }
    });
};

      };
    };
  }
  }
}, {package:"@metamask/network-enablement-controller",file:"node_modules\\@metamask\\network-enablement-controller\\dist\\NetworkEnablementController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-enablement-controller\\dist\\constants.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cnetwork-enablement-controller%5Cdist%5Cconstants.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.POPULAR_NETWORKS = void 0;
exports.POPULAR_NETWORKS = [
    '0x1',
    '0xe708',
    '0x2105',
    '0xa4b1',
    '0xa86a',
    '0x38',
    '0xa',
    '0x89',
    '0x531',
    '0x144',
    '0x2a15c308d',
    '0x3e7', // HyperEVM (999)
];

      };
    };
  }
  }
}, {package:"@metamask/network-enablement-controller",file:"node_modules\\@metamask\\network-enablement-controller\\dist\\constants.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-enablement-controller\\dist\\index.cjs", {"./NetworkEnablementController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-enablement-controller\\dist\\NetworkEnablementController.cjs","./selectors.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-enablement-controller\\dist\\selectors.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cnetwork-enablement-controller%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.selectEnabledSolanaNetworks = exports.selectEnabledEvmNetworks = exports.selectEnabledNetworksCount = exports.selectAllEnabledNetworks = exports.createSelectorForEnabledNetworksForNamespace = exports.selectIsNetworkEnabled = exports.selectEnabledNetworkMap = exports.NetworkEnablementController = void 0;
var NetworkEnablementController_1 = require("./NetworkEnablementController.cjs");
Object.defineProperty(exports, "NetworkEnablementController", { enumerable: true, get: function () { return NetworkEnablementController_1.NetworkEnablementController; } });
var selectors_1 = require("./selectors.cjs");
Object.defineProperty(exports, "selectEnabledNetworkMap", { enumerable: true, get: function () { return selectors_1.selectEnabledNetworkMap; } });
Object.defineProperty(exports, "selectIsNetworkEnabled", { enumerable: true, get: function () { return selectors_1.selectIsNetworkEnabled; } });
Object.defineProperty(exports, "createSelectorForEnabledNetworksForNamespace", { enumerable: true, get: function () { return selectors_1.createSelectorForEnabledNetworksForNamespace; } });
Object.defineProperty(exports, "selectAllEnabledNetworks", { enumerable: true, get: function () { return selectors_1.selectAllEnabledNetworks; } });
Object.defineProperty(exports, "selectEnabledNetworksCount", { enumerable: true, get: function () { return selectors_1.selectEnabledNetworksCount; } });
Object.defineProperty(exports, "selectEnabledEvmNetworks", { enumerable: true, get: function () { return selectors_1.selectEnabledEvmNetworks; } });
Object.defineProperty(exports, "selectEnabledSolanaNetworks", { enumerable: true, get: function () { return selectors_1.selectEnabledSolanaNetworks; } });

      };
    };
  }
  }
}, {package:"@metamask/network-enablement-controller",file:"node_modules\\@metamask\\network-enablement-controller\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-enablement-controller\\dist\\selectors.cjs", {"./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-enablement-controller\\dist\\utils.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cnetwork-enablement-controller%5Cdist%5Cselectors.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.selectEnabledSolanaNetworks = exports.selectEnabledEvmNetworks = exports.selectEnabledNetworksCount = exports.selectAllEnabledNetworks = exports.createSelectorForEnabledNetworksForNamespace = exports.selectIsNetworkEnabled = exports.selectEnabledNetworkMap = void 0;
const utils_1 = require("@metamask/utils");
const reselect_1 = require("reselect");
const utils_2 = require("./utils.cjs");
/**
 * Base selector to get the enabled network map from the controller state.
 *
 * @param state - The NetworkEnablementController state
 * @returns The enabled network map
 */
const selectEnabledNetworkMap = (state) => state.enabledNetworkMap;
exports.selectEnabledNetworkMap = selectEnabledNetworkMap;
/**
 * Selector to check if a specific network is enabled.
 *
 * This selector accepts either a Hex chain ID (for EVM networks) or a CAIP-2 chain ID
 * (for any blockchain network) and returns whether the network is currently enabled.
 * It returns false for unknown networks or if there's an error parsing the chain ID.
 *
 * @param chainId - The chain ID to check (Hex or CAIP-2 format)
 * @returns A selector function that returns true if the network is enabled, false otherwise
 */
const selectIsNetworkEnabled = (chainId) => (0, reselect_1.createSelector)(exports.selectEnabledNetworkMap, (enabledNetworkMap) => {
    const { namespace, storageKey } = (0, utils_2.deriveKeys)(chainId);
    return (namespace in enabledNetworkMap &&
        storageKey in enabledNetworkMap[namespace] &&
        enabledNetworkMap[namespace][storageKey]);
});
exports.selectIsNetworkEnabled = selectIsNetworkEnabled;
/**
 * Selector builder to get all enabled networks for a specific namespace.
 *
 * The selector returned by this function returns an array of chain IDs (as strings) for all enabled networks
 * within the specified namespace (e.g., 'eip155' for EVM networks, 'solana' for Solana).
 *
 * @param namespace - The CAIP namespace to get enabled networks for (e.g., 'eip155', 'solana')
 * @returns A selector function that returns an array of chain ID strings for enabled networks in the namespace
 */
const createSelectorForEnabledNetworksForNamespace = (namespace) => (0, reselect_1.createSelector)(exports.selectEnabledNetworkMap, (enabledNetworkMap) => {
    return Object.entries(enabledNetworkMap[namespace] ?? {})
        .filter(([, enabled]) => enabled)
        .map(([id]) => id);
});
exports.createSelectorForEnabledNetworksForNamespace = createSelectorForEnabledNetworksForNamespace;
/**
 * Selector to get all enabled networks across all namespaces.
 *
 * This selector returns a record where keys are CAIP namespaces and values are arrays
 * of enabled chain IDs within each namespace.
 *
 * @returns A selector function that returns a record mapping namespace to array of enabled chain IDs
 */
exports.selectAllEnabledNetworks = (0, reselect_1.createSelector)(exports.selectEnabledNetworkMap, (enabledNetworkMap) => {
    return Object.keys(enabledNetworkMap).reduce((acc, ns) => {
        acc[ns] = Object.entries(enabledNetworkMap[ns])
            .filter(([, enabled]) => enabled)
            .map(([id]) => id);
        return acc;
    }, {});
});
/**
 * Selector to get the total count of enabled networks across all namespaces.
 *
 * @returns A selector function that returns the total number of enabled networks
 */
exports.selectEnabledNetworksCount = (0, reselect_1.createSelector)(exports.selectAllEnabledNetworks, (allEnabledNetworks) => {
    return Object.values(allEnabledNetworks).flat().length;
});
/**
 * Selector to get all enabled EVM networks.
 *
 * This is a convenience selector that specifically targets EIP-155 networks.
 *
 * @returns A selector function that returns an array of enabled EVM chain IDs
 */
exports.selectEnabledEvmNetworks = (0, reselect_1.createSelector)((0, exports.createSelectorForEnabledNetworksForNamespace)(utils_1.KnownCaipNamespace.Eip155), (enabledEvmNetworks) => enabledEvmNetworks);
/**
 * Selector to get all enabled Solana networks.
 *
 * This is a convenience selector that specifically targets Solana networks.
 *
 * @returns A selector function that returns an array of enabled Solana chain IDs
 */
exports.selectEnabledSolanaNetworks = (0, reselect_1.createSelector)((0, exports.createSelectorForEnabledNetworksForNamespace)(utils_1.KnownCaipNamespace.Solana), (enabledSolanaNetworks) => enabledSolanaNetworks);

      };
    };
  }
  }
}, {package:"@metamask/network-enablement-controller",file:"node_modules\\@metamask\\network-enablement-controller\\dist\\selectors.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-enablement-controller\\dist\\utils.cjs", {"./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-enablement-controller\\dist\\constants.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/multichain-network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cnetwork-enablement-controller%5Cdist%5Cutils.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isPopularNetwork = exports.isOnlyNetworkEnabledInNamespace = exports.deriveKeys = void 0;
const controller_utils_1 = require("@metamask/controller-utils");
const multichain_network_controller_1 = require("@metamask/multichain-network-controller");
const utils_1 = require("@metamask/utils");
const constants_1 = require("./constants.cjs");
/**
 * Derives the namespace, storage key, and CAIP chain ID from a given chain ID.
 *
 * This utility function handles the conversion between different chain ID formats.
 * For EVM networks, it converts Hex chain IDs to CAIP-2 format and determines
 * the appropriate storage key. For non-EVM networks, it parses the CAIP-2 chain ID
 * and uses the full chain ID as the storage key.
 *
 * @param chainId - The chain ID to derive keys from (Hex or CAIP-2 format)
 * @returns An object containing namespace, storageKey, and caipId
 * @throws Error if the chain ID cannot be parsed
 */
function deriveKeys(chainId) {
    const caipChainId = (0, utils_1.isCaipChainId)(chainId)
        ? chainId
        : (0, multichain_network_controller_1.toEvmCaipChainId)(chainId);
    const { namespace, reference } = (0, utils_1.parseCaipChainId)(caipChainId);
    let storageKey;
    if (namespace === utils_1.KnownCaipNamespace.Eip155) {
        storageKey = (0, utils_1.isHexString)(chainId) ? chainId : (0, controller_utils_1.toHex)(reference);
    }
    else {
        storageKey = caipChainId;
    }
    return { namespace, storageKey, caipChainId, reference };
}
exports.deriveKeys = deriveKeys;
/**
 * Checks if the specified network is the only enabled network in its namespace.
 *
 * This function is used to prevent unnecessary state updates when trying to enable
 * This method is used to prevent the last network in a namespace from being removed.
 *
 * @param state - The current controller state
 * @param derivedKeys - The parsed keys object containing namespace and storageKey
 * @returns True if the network is the only enabled network in the namespace, false otherwise
 */
function isOnlyNetworkEnabledInNamespace(state, derivedKeys) {
    const { namespace, storageKey } = derivedKeys;
    // Early return if namespace doesn't exist
    if (!state.enabledNetworkMap[namespace]) {
        return false;
    }
    const networks = state.enabledNetworkMap[namespace];
    // Get all enabled networks in this namespace
    const enabledNetworks = Object.entries(networks).filter(([_, enabled]) => enabled);
    // Check if there's exactly one enabled network and it matches our target
    if (enabledNetworks.length === 1) {
        const [onlyEnabledKey] = enabledNetworks[0];
        return onlyEnabledKey === storageKey;
    }
    // Return false if there are zero or multiple enabled networks
    return false;
}
exports.isOnlyNetworkEnabledInNamespace = isOnlyNetworkEnabledInNamespace;
/**
 * Checks if a network is considered popular based on its reference.
 *
 * @param reference - The network reference (typically the chain ID reference part)
 * @returns True if the network is popular, false otherwise
 */
function isPopularNetwork(reference) {
    try {
        return constants_1.POPULAR_NETWORKS.includes((0, controller_utils_1.toHex)(reference));
    }
    catch {
        // If toHex fails (e.g., for non-decimal references like Bitcoin hashes),
        // the network is not popular
        return false;
    }
}
exports.isPopularNetwork = isPopularNetwork;

      };
    };
  }
  }
}, {package:"@metamask/network-enablement-controller",file:"node_modules\\@metamask\\network-enablement-controller\\dist\\utils.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\NotificationServicesPushController\\web\\index.cjs", {"./push-utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\NotificationServicesPushController\\web\\push-utils.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cnotification-services-controller%5Cdist%5CNotificationServicesPushController%5Cweb%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSubscribeToPushNotifications = exports.deleteRegToken = exports.createRegToken = void 0;
var push_utils_1 = require("./push-utils.cjs");
Object.defineProperty(exports, "createRegToken", { enumerable: true, get: function () { return push_utils_1.createRegToken; } });
Object.defineProperty(exports, "deleteRegToken", { enumerable: true, get: function () { return push_utils_1.deleteRegToken; } });
Object.defineProperty(exports, "createSubscribeToPushNotifications", { enumerable: true, get: function () { return push_utils_1.createSubscribeToPushNotifications; } });

      };
    };
  }
  }
}, {package:"@metamask/notification-services-controller",file:"node_modules\\@metamask\\notification-services-controller\\dist\\NotificationServicesPushController\\web\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\NotificationServicesPushController\\web\\push-utils.cjs", {"../../NotificationServicesController/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\NotificationServicesController\\index.cjs","../../shared/to-raw-notification.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\shared\\to-raw-notification.cjs","firebase/app":"D:\\code\\v\\metamask-extension\\node_modules\\firebase\\app\\dist\\esm\\index.esm.js","firebase/messaging":"D:\\code\\v\\metamask-extension\\node_modules\\firebase\\messaging\\dist\\esm\\index.esm.js","firebase/messaging/sw":"D:\\code\\v\\metamask-extension\\node_modules\\firebase\\messaging\\sw\\dist\\esm\\index.esm.js","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cnotification-services-controller%5Cdist%5CNotificationServicesPushController%5Cweb%5Cpush-utils.cjs
      return function (require, module, exports) {
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSubscribeToPushNotifications = exports.deleteRegToken = exports.createRegToken = exports.supportedCache = void 0;
const app_1 = require("firebase/app");
const messaging_1 = require("firebase/messaging");
const sw_1 = require("firebase/messaging/sw");
const loglevel_1 = __importDefault(require("loglevel"));
const NotificationServicesController_1 = require("../../NotificationServicesController/index.cjs");
const to_raw_notification_1 = require("../../shared/to-raw-notification.cjs");
// Exported to help testing
// eslint-disable-next-line import-x/no-mutable-exports
exports.supportedCache = null;
const getPushAvailability = async () => {
    exports.supportedCache ?? (exports.supportedCache = await (0, sw_1.isSupported)());
    return exports.supportedCache;
};
const createFirebaseApp = async (env) => {
    try {
        return (0, app_1.getApp)();
    }
    catch {
        const firebaseConfig = {
            apiKey: env.apiKey,
            authDomain: env.authDomain,
            storageBucket: env.storageBucket,
            projectId: env.projectId,
            messagingSenderId: env.messagingSenderId,
            appId: env.appId,
            measurementId: env.measurementId,
        };
        return (0, app_1.initializeApp)(firebaseConfig);
    }
};
const getFirebaseMessaging = async (env) => {
    const supported = await getPushAvailability();
    if (!supported) {
        return null;
    }
    const app = await createFirebaseApp(env);
    return (0, sw_1.getMessaging)(app);
};
/**
 * Creates a registration token for Firebase Cloud Messaging.
 *
 * @param env - env to configure push notifications
 * @returns A promise that resolves with the registration token or null if an error occurs.
 */
async function createRegToken(env) {
    try {
        const messaging = await getFirebaseMessaging(env);
        if (!messaging) {
            return null;
        }
        const token = await (0, messaging_1.getToken)(messaging, {
            serviceWorkerRegistration: self.registration,
            vapidKey: env.vapidKey,
        });
        return token;
    }
    catch {
        return null;
    }
}
exports.createRegToken = createRegToken;
/**
 * Deletes the Firebase Cloud Messaging registration token.
 *
 * @param env - env to configure push notifications
 * @returns A promise that resolves with true if the token was successfully deleted, false otherwise.
 */
async function deleteRegToken(env) {
    try {
        const messaging = await getFirebaseMessaging(env);
        if (!messaging) {
            return true;
        }
        await (0, messaging_1.deleteToken)(messaging);
        return true;
    }
    catch {
        return false;
    }
}
exports.deleteRegToken = deleteRegToken;
/**
 * Service Worker Listener for when push notifications are received.
 *
 * @param env - push notification environment
 * @param handler - handler to actually showing notification, MUST BE PROVIDED
 * @returns unsubscribe handler
 */
async function listenToPushNotificationsReceived(env, handler) {
    const messaging = await getFirebaseMessaging(env);
    if (!messaging) {
        return null;
    }
    const unsubscribePushNotifications = (0, sw_1.onBackgroundMessage)(messaging, 
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    async (payload) => {
        try {
            const data = payload?.data?.data ? JSON.parse(payload?.data?.data) : undefined;
            if (!data) {
                return;
            }
            const notificationData = (0, to_raw_notification_1.toRawOnChainNotification)(data);
            const notification = NotificationServicesController_1.Processors.processNotification(notificationData);
            await handler(notification);
        }
        catch (error) {
            // Do Nothing, cannot parse a bad notification
            loglevel_1.default.error('Unable to send push notification:', {
                notification: payload?.data?.data,
                error,
            });
            throw new Error('Unable to send push notification');
        }
    });
    const unsubscribe = () => unsubscribePushNotifications();
    return unsubscribe;
}
/**
 * Service Worker Listener for when a notification is clicked
 *
 * @param handler - listen to NotificationEvent from the service worker
 * @returns unsubscribe handler
 */
function listenToPushNotificationsClicked(handler) {
    const clickHandler = (event) => {
        // Get Data
        const data = event?.notification?.data;
        handler(event, data);
    };
    self.addEventListener('notificationclick', clickHandler);
    const unsubscribe = () => self.removeEventListener('notificationclick', clickHandler);
    return unsubscribe;
}
/**
 * A creator function that assists creating web-specific push notification subscription:
 * 1. Creates subscriptions for receiving and clicking notifications
 * 2. Creates click events when a notification is clicked
 * 3. Publishes controller messenger events
 *
 * @param props - props for this creator function.
 * @param props.onReceivedHandler - allows the developer to handle showing a notification
 * @param props.onClickHandler - allows the developer to handle clicking the notification
 * @param props.messenger - the controller messenger to publish the `onNewNotifications` and `pushNotificationsClicked` events
 * @returns a function that can be used by the controller
 */
function createSubscribeToPushNotifications(props) {
    return async function (env) {
        const onBackgroundMessageSub = await listenToPushNotificationsReceived(env, async (notification) => {
            props.messenger.publish('NotificationServicesPushController:onNewNotifications', notification);
            await props.onReceivedHandler(notification);
        });
        const onClickSub = listenToPushNotificationsClicked((event, notification) => {
            props.messenger.publish('NotificationServicesPushController:pushNotificationClicked', notification);
            props.onClickHandler(event, notification);
        });
        const unsubscribe = () => {
            onBackgroundMessageSub?.();
            onClickSub();
        };
        return unsubscribe;
    };
}
exports.createSubscribeToPushNotifications = createSubscribeToPushNotifications;

      };
    };
  }
  }
}, {package:"@metamask/notification-services-controller",file:"node_modules\\@metamask\\notification-services-controller\\dist\\NotificationServicesPushController\\web\\push-utils.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\obs-store\\dist\\ComposedStore.js", {"./ObservableStore":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\obs-store\\dist\\ObservableStore.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cobs-store%5Cdist%5CComposedStore.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComposedStore = void 0;
const ObservableStore_1 = require("./ObservableStore");
class ComposedStore extends ObservableStore_1.ObservableStore {
    constructor(children) {
        // Typecast: Preserve existing behavior
        super({});
        // subscribe to children
        this._children = children || {};
        Object.keys(this._children).forEach((childKey) => {
            const child = this._children[childKey];
            this._addChild(childKey, child);
        });
    }
    _addChild(childKey, child) {
        const updateFromChild = (childValue) => {
            const state = this.getState();
            state[childKey] = childValue;
            this.putState(state);
        };
        child.subscribe(updateFromChild);
        updateFromChild(child.getState());
    }
}
exports.ComposedStore = ComposedStore;

      };
    };
  }
  }
}, {package:"@metamask/obs-store",file:"node_modules\\@metamask\\obs-store\\dist\\ComposedStore.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\obs-store\\dist\\MergedStore.js", {"./ObservableStore":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\obs-store\\dist\\ObservableStore.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cobs-store%5Cdist%5CMergedStore.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MergedStore = void 0;
const ObservableStore_1 = require("./ObservableStore");
class MergedStore extends ObservableStore_1.ObservableStore {
    constructor(children = []) {
        // Typecast: Preserve existing behavior
        super({});
        this._children = children;
        // subscribe to children
        children.forEach((child) => this._addChild(child));
        this._updateWholeState();
    }
    _addChild(child) {
        child.subscribe(() => this._updateWholeState());
    }
    _updateWholeState() {
        const childStates = this._children.map((child) => child.getState());
        // apply shallow merge over states
        const state = Object.assign({}, ...childStates);
        this.putState(state);
    }
}
exports.MergedStore = MergedStore;

      };
    };
  }
  }
}, {package:"@metamask/obs-store",file:"node_modules\\@metamask\\obs-store\\dist\\MergedStore.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\obs-store\\dist\\ObservableStore.js", {"@metamask/safe-event-emitter":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\safe-event-emitter\\dist\\cjs\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cobs-store%5Cdist%5CObservableStore.js
      return function (require, module, exports) {
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ObservableStore = void 0;
const safe_event_emitter_1 = __importDefault(require("@metamask/safe-event-emitter"));
class ObservableStore extends safe_event_emitter_1.default {
    constructor(initState) {
        super();
        if (initState === undefined) {
            // Typecast/default state: Preserve existing behavior
            this._state = {};
        }
        else {
            this._state = initState;
        }
    }
    // wrapper around internal getState
    getState() {
        return this._getState();
    }
    // wrapper around internal putState
    putState(newState) {
        this._putState(newState);
        this.emit('update', newState);
    }
    updateState(partialState) {
        // if non-null object, merge
        if (partialState && typeof partialState === 'object') {
            const state = this.getState();
            this.putState(Object.assign(Object.assign({}, state), partialState));
            // if not object, use new value
        }
        else {
            this.putState(partialState);
        }
    }
    // subscribe to changes
    subscribe(handler) {
        this.on('update', handler);
    }
    // unsubscribe to changes
    unsubscribe(handler) {
        this.removeListener('update', handler);
    }
    //
    // private
    //
    // read from persistence
    _getState() {
        return this._state;
    }
    // write to persistence
    _putState(newState) {
        this._state = newState;
    }
}
exports.ObservableStore = ObservableStore;

      };
    };
  }
  }
}, {package:"@metamask/obs-store",file:"node_modules\\@metamask\\obs-store\\dist\\ObservableStore.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\obs-store\\dist\\asStream.js", {"readable-stream":"D:\\code\\v\\metamask-extension\\node_modules\\readable-stream\\readable-browser.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cobs-store%5Cdist%5CasStream.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.storeAsStream = void 0;
const readable_stream_1 = require("readable-stream");
class ObservableStoreStream extends readable_stream_1.Duplex {
    constructor(obsStore) {
        super({
            // pass values, not serializations
            objectMode: true,
        });
        // dont buffer outgoing updates
        this.resume();
        // save handler so we can unsubscribe later
        this.handler = (state) => this.push(state);
        // subscribe to obsStore changes
        this.obsStore = obsStore;
        this.obsStore.subscribe(this.handler);
    }
    // emit current state on new destination
    pipe(dest, options) {
        const result = super.pipe(dest, options);
        dest.write(this.obsStore.getState());
        return result;
    }
    // write from incoming stream to state
    _write(chunk, _encoding, callback) {
        this.obsStore.putState(chunk);
        callback();
    }
    // noop - outgoing stream is asking us if we have data we arent giving it
    _read(_size) {
        return undefined;
    }
    // unsubscribe from event emitter
    _destroy(err, callback) {
        this.obsStore.unsubscribe(this.handler);
        super._destroy(err, callback);
    }
}
function storeAsStream(obsStore) {
    return new ObservableStoreStream(obsStore);
}
exports.storeAsStream = storeAsStream;

      };
    };
  }
  }
}, {package:"@metamask/obs-store",file:"node_modules\\@metamask\\obs-store\\dist\\asStream.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\obs-store\\dist\\index.js", {"./ComposedStore":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\obs-store\\dist\\ComposedStore.js","./MergedStore":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\obs-store\\dist\\MergedStore.js","./ObservableStore":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\obs-store\\dist\\ObservableStore.js","./asStream":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\obs-store\\dist\\asStream.js","./transform":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\obs-store\\dist\\transform.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cobs-store%5Cdist%5Cindex.js
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./asStream"), exports);
__exportStar(require("./ComposedStore"), exports);
__exportStar(require("./MergedStore"), exports);
__exportStar(require("./ObservableStore"), exports);
__exportStar(require("./transform"), exports);

      };
    };
  }
  }
}, {package:"@metamask/obs-store",file:"node_modules\\@metamask\\obs-store\\dist\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\obs-store\\dist\\transform.js", {"readable-stream":"D:\\code\\v\\metamask-extension\\node_modules\\readable-stream\\readable-browser.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cobs-store%5Cdist%5Ctransform.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.storeTransformStream = void 0;
const readable_stream_1 = require("readable-stream");
function storeTransformStream(syncTransformFn) {
    const t = new readable_stream_1.Transform({
        objectMode: true,
        transform: (state, _encoding, cb) => {
            try {
                const newState = syncTransformFn(state);
                cb(undefined, newState);
                return undefined;
            }
            catch (err) {
                cb(err);
                return undefined;
            }
        },
    });
    return t;
}
exports.storeTransformStream = storeTransformStream;

      };
    };
  }
  }
}, {package:"@metamask/obs-store",file:"node_modules\\@metamask\\obs-store\\dist\\transform.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-log-controller\\dist\\PermissionLogController.cjs", {"./enums.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-log-controller\\dist\\enums.cjs","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cpermission-log-controller%5Cdist%5CPermissionLogController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _PermissionLogController_instances, _PermissionLogController_restrictedMethods, _PermissionLogController_getAccountToTimeMap, _PermissionLogController_logRequest, _PermissionLogController_logResponse, _PermissionLogController_logPermissionsHistory, _PermissionLogController_commitNewHistory, _PermissionLogController_getRequestedMethods, _PermissionLogController_getAccountsFromPermission;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PermissionLogController = void 0;
const base_controller_1 = require("@metamask/base-controller");
const utils_1 = require("@metamask/utils");
const enums_1 = require("./enums.cjs");
const defaultState = {
    permissionHistory: {},
    permissionActivityLog: [],
};
const name = 'PermissionLogController';
/**
 * Controller with middleware for logging requests and responses to restricted
 * and permissions-related methods.
 */
class PermissionLogController extends base_controller_1.BaseController {
    constructor({ messenger, restrictedMethods, state, }) {
        super({
            messenger,
            name,
            metadata: {
                permissionHistory: {
                    persist: true,
                    anonymous: false,
                },
                permissionActivityLog: {
                    persist: false,
                    anonymous: false,
                },
            },
            state: { ...defaultState, ...state },
        });
        _PermissionLogController_instances.add(this);
        _PermissionLogController_restrictedMethods.set(this, void 0);
        __classPrivateFieldSet(this, _PermissionLogController_restrictedMethods, restrictedMethods, "f");
    }
    /**
     * Updates the exposed account history for the given origin.
     * Sets the 'last seen' time to Date.now() for the given accounts.
     * Does **not** update the 'lastApproved' time for the permission itself.
     * Returns if the accounts array is empty.
     *
     * @param origin - The origin that the accounts are exposed to.
     * @param accounts - The accounts.
     */
    updateAccountsHistory(origin, accounts) {
        if (accounts.length === 0) {
            return;
        }
        const newEntries = {
            // TODO: Either fix this lint violation or explain why it's necessary to ignore.
            // eslint-disable-next-line @typescript-eslint/naming-convention
            eth_accounts: {
                accounts: __classPrivateFieldGet(this, _PermissionLogController_instances, "m", _PermissionLogController_getAccountToTimeMap).call(this, accounts, Date.now()),
            },
        };
        __classPrivateFieldGet(this, _PermissionLogController_instances, "m", _PermissionLogController_commitNewHistory).call(this, origin, newEntries);
    }
    /**
     * Create a permissions log middleware. Records permissions activity and history:
     *
     * Activity: requests and responses for restricted and most wallet_ methods.
     *
     * History: for each origin, the last time a permission was granted, including
     * which accounts were exposed, if any.
     *
     * @returns The permissions log middleware.
     */
    createMiddleware() {
        return (req, res, next) => {
            const { origin, method } = req;
            const isInternal = method.startsWith(enums_1.WALLET_PREFIX);
            const isEthRequestAccounts = method === 'eth_requestAccounts';
            // Determine if the method should be logged
            if ((!enums_1.LOG_IGNORE_METHODS.includes(method) &&
                (isInternal || __classPrivateFieldGet(this, _PermissionLogController_restrictedMethods, "f").has(method))) ||
                isEthRequestAccounts) {
                const activityEntry = __classPrivateFieldGet(this, _PermissionLogController_instances, "m", _PermissionLogController_logRequest).call(this, req, isInternal);
                const requestedMethods = __classPrivateFieldGet(this, _PermissionLogController_instances, "m", _PermissionLogController_getRequestedMethods).call(this, req);
                // Call next with a return handler for capturing the response
                next((cb) => {
                    const time = Date.now();
                    __classPrivateFieldGet(this, _PermissionLogController_instances, "m", _PermissionLogController_logResponse).call(this, activityEntry, res, time);
                    if (requestedMethods && !res.error && res.result && origin) {
                        __classPrivateFieldGet(this, _PermissionLogController_instances, "m", _PermissionLogController_logPermissionsHistory).call(this, requestedMethods, origin, res.result, time, isEthRequestAccounts);
                    }
                    cb();
                });
                return;
            }
            next();
        };
    }
}
exports.PermissionLogController = PermissionLogController;
_PermissionLogController_restrictedMethods = new WeakMap(), _PermissionLogController_instances = new WeakSet(), _PermissionLogController_getAccountToTimeMap = function _PermissionLogController_getAccountToTimeMap(accounts, time) {
    return accounts.reduce((acc, account) => ({
        ...acc,
        [account]: time,
    }), {});
}, _PermissionLogController_logRequest = function _PermissionLogController_logRequest(request, isInternal) {
    const activityEntry = {
        id: request.id,
        method: request.method,
        methodType: isInternal
            ? enums_1.LOG_METHOD_TYPES.internal
            : enums_1.LOG_METHOD_TYPES.restricted,
        origin: request.origin,
        requestTime: Date.now(),
        responseTime: null,
        success: null,
    };
    this.update((state) => {
        const newLogs = [...state.permissionActivityLog, activityEntry];
        state.permissionActivityLog =
            // remove oldest log if exceeding size limit
            newLogs.length > enums_1.LOG_LIMIT ? newLogs.slice(1) : newLogs;
    });
    return activityEntry;
}, _PermissionLogController_logResponse = function _PermissionLogController_logResponse(entry, response, time) {
    if (!entry || !response) {
        return;
    }
    // The JSON-RPC 2.0 specification defines "success" by the presence of
    // either the "result" or "error" property. The specification forbids
    // both properties from being present simultaneously, and our JSON-RPC
    // stack is spec-compliant at the time of writing.
    this.update((state) => {
        state.permissionActivityLog = state.permissionActivityLog.map((log) => {
            // Update the log entry that matches the given entry id
            if (log.id === entry.id) {
                return {
                    ...log,
                    success: (0, utils_1.hasProperty)(response, 'result'),
                    responseTime: time,
                };
            }
            return log;
        });
    });
}, _PermissionLogController_logPermissionsHistory = function _PermissionLogController_logPermissionsHistory(requestedMethods, origin, result, time, isEthRequestAccounts) {
    let newEntries;
    if (isEthRequestAccounts) {
        // Type assertion: We are assuming that the response data contains
        // a set of accounts if the RPC method is "eth_requestAccounts".
        const accounts = result;
        newEntries = {
            // TODO: Either fix this lint violation or explain why it's necessary to ignore.
            // eslint-disable-next-line @typescript-eslint/naming-convention
            eth_accounts: {
                accounts: __classPrivateFieldGet(this, _PermissionLogController_instances, "m", _PermissionLogController_getAccountToTimeMap).call(this, accounts, time),
                lastApproved: time,
            },
        };
    }
    else {
        // Records new "lastApproved" times for the granted permissions, if any.
        // Special handling for eth_accounts, in order to record the time the
        // accounts were last seen or approved by the origin.
        // Type assertion: We are assuming that the response data contains
        // a set of permissions if the RPC method is "eth_requestPermissions".
        const permissions = result;
        newEntries = permissions.reduce((acc, permission) => {
            const method = permission.parentCapability;
            if (!requestedMethods.includes(method)) {
                return acc;
            }
            if (method === 'eth_accounts') {
                const accounts = __classPrivateFieldGet(this, _PermissionLogController_instances, "m", _PermissionLogController_getAccountsFromPermission).call(this, permission);
                return {
                    ...acc,
                    [method]: {
                        lastApproved: time,
                        accounts: __classPrivateFieldGet(this, _PermissionLogController_instances, "m", _PermissionLogController_getAccountToTimeMap).call(this, accounts, time),
                    },
                };
            }
            return {
                ...acc,
                [method]: {
                    lastApproved: time,
                },
            };
        }, {});
    }
    if (Object.keys(newEntries).length > 0) {
        __classPrivateFieldGet(this, _PermissionLogController_instances, "m", _PermissionLogController_commitNewHistory).call(this, origin, newEntries);
    }
}, _PermissionLogController_commitNewHistory = function _PermissionLogController_commitNewHistory(origin, newEntries) {
    const { permissionHistory } = this.state;
    // a simple merge updates most permissions
    const oldOriginHistory = permissionHistory[origin] ?? {};
    const newOriginHistory = {
        ...oldOriginHistory,
        ...newEntries,
    };
    // eth_accounts requires special handling, because of information
    // we store about the accounts
    const existingEthAccountsEntry = oldOriginHistory.eth_accounts;
    const newEthAccountsEntry = newEntries.eth_accounts;
    if (existingEthAccountsEntry && newEthAccountsEntry) {
        // we may intend to update just the accounts, not the permission
        // itself
        const lastApproved = newEthAccountsEntry.lastApproved ??
            existingEthAccountsEntry.lastApproved;
        // merge old and new eth_accounts history entries
        newOriginHistory.eth_accounts = {
            lastApproved,
            accounts: {
                ...existingEthAccountsEntry.accounts,
                ...newEthAccountsEntry.accounts,
            },
        };
    }
    this.update((state) => {
        state.permissionHistory = {
            ...permissionHistory,
            [origin]: newOriginHistory,
        };
    });
}, _PermissionLogController_getRequestedMethods = function _PermissionLogController_getRequestedMethods(request) {
    const { method, params } = request;
    if (method === 'eth_requestAccounts') {
        return ['eth_accounts'];
    }
    else if (method === `${enums_1.WALLET_PREFIX}requestPermissions` &&
        params &&
        Array.isArray(params) &&
        params[0] &&
        typeof params[0] === 'object' &&
        !Array.isArray(params[0])) {
        return Object.keys(params[0]);
    }
    return null;
}, _PermissionLogController_getAccountsFromPermission = function _PermissionLogController_getAccountsFromPermission(permission) {
    if (permission.parentCapability !== 'eth_accounts' || !permission.caveats) {
        return [];
    }
    const accounts = new Set();
    for (const caveat of permission.caveats) {
        if (caveat.type === enums_1.CAVEAT_TYPES.restrictReturnedAccounts &&
            Array.isArray(caveat.value)) {
            for (const value of caveat.value) {
                accounts.add(value);
            }
        }
    }
    return [...accounts];
};

      };
    };
  }
  }
}, {package:"@metamask/permission-log-controller",file:"node_modules\\@metamask\\permission-log-controller\\dist\\PermissionLogController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-log-controller\\dist\\enums.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cpermission-log-controller%5Cdist%5Cenums.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LOG_LIMIT = exports.LOG_METHOD_TYPES = exports.LOG_IGNORE_METHODS = exports.CAVEAT_TYPES = exports.WALLET_PREFIX = void 0;
exports.WALLET_PREFIX = 'wallet_';
exports.CAVEAT_TYPES = Object.freeze({
    restrictReturnedAccounts: 'restrictReturnedAccounts',
});
exports.LOG_IGNORE_METHODS = [
    'wallet_registerOnboarding',
    'wallet_watchAsset',
];
// TODO: Either fix this lint violation or explain why it's necessary to ignore.
// eslint-disable-next-line @typescript-eslint/naming-convention
var LOG_METHOD_TYPES;
(function (LOG_METHOD_TYPES) {
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    LOG_METHOD_TYPES["restricted"] = "restricted";
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    LOG_METHOD_TYPES["internal"] = "internal";
})(LOG_METHOD_TYPES || (exports.LOG_METHOD_TYPES = LOG_METHOD_TYPES = {}));
/**
 * The permission activity log size limit.
 */
exports.LOG_LIMIT = 100;

      };
    };
  }
  }
}, {package:"@metamask/permission-log-controller",file:"node_modules\\@metamask\\permission-log-controller\\dist\\enums.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-log-controller\\dist\\index.cjs", {"./PermissionLogController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-log-controller\\dist\\PermissionLogController.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cpermission-log-controller%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./PermissionLogController.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/permission-log-controller",file:"node_modules\\@metamask\\permission-log-controller\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ppom-validator\\dist\\index.js", {"./ppom-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ppom-validator\\dist\\ppom-controller.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cppom-validator%5Cdist%5Cindex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PPOMController = exports.NETWORK_CACHE_DURATION = void 0;
var ppom_controller_1 = require("./ppom-controller");
Object.defineProperty(exports, "NETWORK_CACHE_DURATION", { enumerable: true, get: function () { return ppom_controller_1.NETWORK_CACHE_DURATION; } });
Object.defineProperty(exports, "PPOMController", { enumerable: true, get: function () { return ppom_controller_1.PPOMController; } });

      };
    };
  }
  }
}, {package:"@metamask/ppom-validator",file:"node_modules\\@metamask\\ppom-validator\\dist\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ppom-validator\\dist\\ppom-controller.js", {"./ppom-storage":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ppom-validator\\dist\\ppom-storage.js","./util":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ppom-validator\\dist\\util.js","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","await-semaphore":"D:\\code\\v\\metamask-extension\\node_modules\\await-semaphore\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cppom-validator%5Cdist%5Cppom-controller.js
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _PPOMController_instances, _PPOMController_ppom, _PPOMController_provider, _PPOMController_storage, _PPOMController_ppomMutex, _PPOMController_ppomProvider, _PPOMController_cdnBaseUrl, _PPOMController_providerRequestLimit, _PPOMController_providerRequests, _PPOMController_chainId, _PPOMController_securityAlertsEnabled, _PPOMController_providerRequestsCount, _PPOMController_blockaidPublicKey, _PPOMController_ppomInitialised, _PPOMController_nativeCrypto, _PPOMController_initialisePPOM, _PPOMController_resetToInactiveState, _PPOMController_onNetworkChange, _PPOMController_onPreferenceChange, _PPOMController_registerMessageHandlers, _PPOMController_subscribeMessageEvents, _PPOMController_resetPPOM, _PPOMController_initPPOMIfRequired, _PPOMController_updateVersionInfo, _PPOMController_checkFilePresentInStorage, _PPOMController_getAllFiles, _PPOMController_getFile, _PPOMController_getAPIResponse, _PPOMController_fetchVersionInfo, _PPOMController_fetchBlob, _PPOMController_jsonRpcRequest, _PPOMController_getPPOM;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PPOMController = exports.NETWORK_CACHE_DURATION = void 0;
const base_controller_1 = require("@metamask/base-controller");
const controller_utils_1 = require("@metamask/controller-utils");
const await_semaphore_1 = require("await-semaphore");
const ppom_storage_1 = require("./ppom-storage");
const util_1 = require("./util");
const PROVIDER_REQUEST_LIMIT = 300;
exports.NETWORK_CACHE_DURATION = 1000 * 60 * 60 * 24 * 7;
// The following methods on provider are allowed to PPOM
const ALLOWED_PROVIDER_CALLS = [
    'eth_call',
    'eth_blockNumber',
    'eth_createAccessList',
    'eth_getLogs',
    'eth_getFilterLogs',
    'eth_getTransactionByHash',
    'eth_chainId',
    'eth_getBlockByHash',
    'eth_getBlockByNumber',
    'eth_getCode',
    'eth_getStorageAt',
    'eth_getBalance',
    'eth_getTransactionCount',
    'trace_call',
    'trace_callMany',
    'debug_traceCall',
    'trace_filter',
];
const stateMetaData = {
    versionInfo: {
        includeInStateLogs: true,
        persist: true,
        anonymous: false,
        usedInUi: false,
    },
    storageMetadata: {
        includeInStateLogs: false,
        persist: true,
        anonymous: false,
        usedInUi: false,
    },
};
const PPOM_VERSION_FILE_NAME = 'ppom_version.json';
const controllerName = 'PPOMController';
const versionInfoFileHeaders = {
    headers: {
        // eslint-disable-next-line @typescript-eslint/naming-convention
        'Content-Type': 'application/json',
    },
};
/**
 * PPOMController
 * Controller responsible for managing the PPOM
 *
 * @property config - The controller configuration
 * @property state - The controller state
 * @property storage - The controller storage
 * @property ppom - The PPOM instance
 * @property provider - The provider used to create the PPOM instance
 */
class PPOMController extends base_controller_1.BaseController {
    /**
     * Creates a PPOMController instance.
     *
     * @param options - Constructor options.
     * @param options.chainId - ChainId of the selected network.
     * @param options.messenger - Controller messenger.
     * @param options.provider - The provider used to create the PPOM instance.
     * @param options.storageBackend - The storage backend to use for storing PPOM data.
     * @param options.securityAlertsEnabled - True if user has enabled preference for blockaid security check.
     * @param options.onPreferencesChange - Callback invoked when user changes preferences.
     * @param options.ppomProvider - Object wrapping PPOM.
     * @param options.cdnBaseUrl - Base URL for the CDN.
     * @param options.providerRequestLimit - Limit of number of requests that can be sent to provider per transaction.
     * @param options.dataUpdateDuration - Duration after which data is fetched again.
     * @param options.fileFetchScheduleDuration - Duration after which next data file is fetched.
     * @param options.state - Initial state of the controller.
     * @param options.blockaidPublicKey - Public key of blockaid for verifying signatures of data files.
     * @param options.nativeCrypto - Native implementation of crypto hashing function.
     * This is useful to leverage faster native crypto implementation on devices.
     * @returns The PPOMController instance.
     */
    constructor({ chainId, messenger, provider, storageBackend, securityAlertsEnabled, onPreferencesChange, ppomProvider, cdnBaseUrl, providerRequestLimit, state, blockaidPublicKey, nativeCrypto, }) {
        const initialState = {
            versionInfo: state?.versionInfo ?? [],
            storageMetadata: state?.storageMetadata ?? [],
        };
        super({
            name: controllerName,
            metadata: stateMetaData,
            messenger,
            state: initialState,
        });
        _PPOMController_instances.add(this);
        _PPOMController_ppom.set(this, void 0);
        _PPOMController_provider.set(this, void 0);
        _PPOMController_storage.set(this, void 0);
        /*
         * This mutex is used to prevent concurrent usage of the PPOM instance
         * and protect the PPOM instance from being used while it is being initialized/updated
         */
        _PPOMController_ppomMutex.set(this, void 0);
        _PPOMController_ppomProvider.set(this, void 0);
        // base URL of the CDN
        _PPOMController_cdnBaseUrl.set(this, void 0);
        // Limit of number of requests ppom can send to the provider per transaction
        _PPOMController_providerRequestLimit.set(this, void 0);
        // Number of requests sent to provider by ppom for current transaction
        _PPOMController_providerRequests.set(this, 0);
        // id of current chain selected
        _PPOMController_chainId.set(this, void 0);
        // true if user has enabled preference for blockaid security check
        _PPOMController_securityAlertsEnabled.set(this, void 0);
        // Map of count of each provider request call
        _PPOMController_providerRequestsCount.set(this, {});
        _PPOMController_blockaidPublicKey.set(this, void 0);
        _PPOMController_ppomInitialised.set(this, false);
        _PPOMController_nativeCrypto.set(this, undefined);
        __classPrivateFieldSet(this, _PPOMController_chainId, (0, util_1.addHexPrefix)(chainId), "f");
        __classPrivateFieldSet(this, _PPOMController_provider, provider, "f");
        __classPrivateFieldSet(this, _PPOMController_ppomProvider, ppomProvider, "f");
        __classPrivateFieldSet(this, _PPOMController_storage, new ppom_storage_1.PPOMStorage({
            storageBackend,
            readMetadata: () => {
                return [...this.state.storageMetadata];
            },
            writeMetadata: (metadata) => {
                this.update((draftState) => {
                    draftState.storageMetadata = metadata;
                });
            },
        }), "f");
        __classPrivateFieldSet(this, _PPOMController_ppomMutex, new await_semaphore_1.Mutex(), "f");
        __classPrivateFieldSet(this, _PPOMController_cdnBaseUrl, cdnBaseUrl, "f");
        __classPrivateFieldSet(this, _PPOMController_providerRequestLimit, providerRequestLimit ?? PROVIDER_REQUEST_LIMIT, "f");
        __classPrivateFieldSet(this, _PPOMController_securityAlertsEnabled, securityAlertsEnabled, "f");
        __classPrivateFieldSet(this, _PPOMController_blockaidPublicKey, blockaidPublicKey, "f");
        __classPrivateFieldSet(this, _PPOMController_nativeCrypto, nativeCrypto, "f");
        // enable / disable PPOM validations as user changes preferences
        onPreferencesChange(__classPrivateFieldGet(this, _PPOMController_instances, "m", _PPOMController_onPreferenceChange).bind(this));
        // register message handlers
        __classPrivateFieldGet(this, _PPOMController_instances, "m", _PPOMController_registerMessageHandlers).call(this);
        // subscribe to events
        __classPrivateFieldGet(this, _PPOMController_instances, "m", _PPOMController_subscribeMessageEvents).call(this);
    }
    /**
     * Use the PPOM.
     * This function receives a callback that will be called with the PPOM.
     *
     * @param callback - Callback to be invoked with PPOM.
     * @param chainId - ChainId of confirmation.
     */
    async usePPOM(callback, chainId) {
        const chainIdForRequest = chainId ?? __classPrivateFieldGet(this, _PPOMController_chainId, "f");
        if (!__classPrivateFieldGet(this, _PPOMController_securityAlertsEnabled, "f")) {
            throw Error('User has securityAlertsEnabled set to false');
        }
        if (!(0, util_1.blockaidValidationSupportedForNetwork)(chainIdForRequest)) {
            throw Error(`Blockaid validation not available on network with chainId: ${chainIdForRequest}`);
        }
        return await __classPrivateFieldGet(this, _PPOMController_ppomMutex, "f").use(async () => {
            const ppom = await __classPrivateFieldGet(this, _PPOMController_instances, "m", _PPOMController_initPPOMIfRequired).call(this, chainIdForRequest);
            __classPrivateFieldSet(this, _PPOMController_providerRequests, 0, "f");
            __classPrivateFieldSet(this, _PPOMController_providerRequestsCount, {}, "f");
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            const result = await callback(ppom);
            return {
                ...result,
                // we are destructuring the object below as this will be used outside the controller
                // we want to avoid possibility of outside code changing an instance variable.
                providerRequestsCount: { ...__classPrivateFieldGet(this, _PPOMController_providerRequestsCount, "f") },
            };
        });
    }
}
exports.PPOMController = PPOMController;
_PPOMController_ppom = new WeakMap(), _PPOMController_provider = new WeakMap(), _PPOMController_storage = new WeakMap(), _PPOMController_ppomMutex = new WeakMap(), _PPOMController_ppomProvider = new WeakMap(), _PPOMController_cdnBaseUrl = new WeakMap(), _PPOMController_providerRequestLimit = new WeakMap(), _PPOMController_providerRequests = new WeakMap(), _PPOMController_chainId = new WeakMap(), _PPOMController_securityAlertsEnabled = new WeakMap(), _PPOMController_providerRequestsCount = new WeakMap(), _PPOMController_blockaidPublicKey = new WeakMap(), _PPOMController_ppomInitialised = new WeakMap(), _PPOMController_nativeCrypto = new WeakMap(), _PPOMController_instances = new WeakSet(), _PPOMController_initialisePPOM = 
/*
 * Initialise PPOM loading wasm file.
 * This is done only if user has enabled preference for PPOM Validation.
 * Initialisation is done as soon as controller is constructed
 * or as user enables preference for blockaid validation.
 */
async function _PPOMController_initialisePPOM() {
    if (__classPrivateFieldGet(this, _PPOMController_securityAlertsEnabled, "f") && !__classPrivateFieldGet(this, _PPOMController_ppomInitialised, "f")) {
        const { ppomInit } = __classPrivateFieldGet(this, _PPOMController_ppomProvider, "f");
        await ppomInit('./ppom_bg.wasm');
        __classPrivateFieldSet(this, _PPOMController_ppomInitialised, true, "f");
    }
}, _PPOMController_resetToInactiveState = function _PPOMController_resetToInactiveState() {
    __classPrivateFieldGet(this, _PPOMController_instances, "m", _PPOMController_resetPPOM).call(this).catch((error) => {
        console.error(`Error in resetting ppom: ${error.message}`);
    });
    const { storageMetadata } = this.state;
    this.update((draftState) => {
        draftState.versionInfo = [];
        draftState.storageMetadata = [];
    });
    __classPrivateFieldGet(this, _PPOMController_storage, "f").deleteAllFiles(storageMetadata).catch((error) => {
        console.error(`Error in deleting files: ${error.message}`);
    });
}, _PPOMController_onNetworkChange = function _PPOMController_onNetworkChange(networkControllerState) {
    const selectedNetworkClient = this.messagingSystem.call('NetworkController:getNetworkClientById', networkControllerState.selectedNetworkClientId);
    const { chainId } = selectedNetworkClient.configuration;
    const id = (0, util_1.addHexPrefix)(chainId);
    if (id === __classPrivateFieldGet(this, _PPOMController_chainId, "f")) {
        return;
    }
    __classPrivateFieldSet(this, _PPOMController_chainId, id, "f");
    __classPrivateFieldGet(this, _PPOMController_instances, "m", _PPOMController_resetPPOM).call(this).catch((error) => {
        console.error(`Error in resetting ppom: ${error.message}`);
    });
}, _PPOMController_onPreferenceChange = function _PPOMController_onPreferenceChange(
// TOOD: Replace with `PreferencesState` from `@metamask/preferences-controller`
preferenceControllerState) {
    const blockaidEnabled = preferenceControllerState.securityAlertsEnabled;
    if (blockaidEnabled === __classPrivateFieldGet(this, _PPOMController_securityAlertsEnabled, "f")) {
        return;
    }
    __classPrivateFieldSet(this, _PPOMController_securityAlertsEnabled, blockaidEnabled, "f");
    if (!blockaidEnabled) {
        __classPrivateFieldGet(this, _PPOMController_instances, "m", _PPOMController_resetToInactiveState).call(this);
    }
}, _PPOMController_registerMessageHandlers = function _PPOMController_registerMessageHandlers() {
    this.messagingSystem.registerActionHandler(`${controllerName}:usePPOM`, this.usePPOM.bind(this));
}, _PPOMController_subscribeMessageEvents = function _PPOMController_subscribeMessageEvents() {
    const onNetworkChange = __classPrivateFieldGet(this, _PPOMController_instances, "m", _PPOMController_onNetworkChange).bind(this);
    this.messagingSystem.subscribe('NetworkController:networkDidChange', onNetworkChange);
}, _PPOMController_resetPPOM = 
/*
 * The function resets PPOM.
 */
async function _PPOMController_resetPPOM() {
    await __classPrivateFieldGet(this, _PPOMController_ppomMutex, "f").use(async () => {
        if (__classPrivateFieldGet(this, _PPOMController_ppom, "f")) {
            __classPrivateFieldGet(this, _PPOMController_ppom, "f").free();
            __classPrivateFieldSet(this, _PPOMController_ppom, undefined, "f");
        }
    });
}, _PPOMController_initPPOMIfRequired = 
/*
 * The function will initialise PPOM for the network if required.
 */
async function _PPOMController_initPPOMIfRequired(chainId) {
    const versionInfoUpdated = await __classPrivateFieldGet(this, _PPOMController_instances, "m", _PPOMController_updateVersionInfo).call(this);
    let ppom;
    if (__classPrivateFieldGet(this, _PPOMController_ppom, "f") === undefined || versionInfoUpdated) {
        ppom = await __classPrivateFieldGet(this, _PPOMController_instances, "m", _PPOMController_getPPOM).call(this, chainId);
        if (__classPrivateFieldGet(this, _PPOMController_chainId, "f") === chainId) {
            if (__classPrivateFieldGet(this, _PPOMController_ppom, "f")) {
                __classPrivateFieldGet(this, _PPOMController_ppom, "f").free();
            }
            __classPrivateFieldSet(this, _PPOMController_ppom, ppom, "f");
        }
        __classPrivateFieldGet(this, _PPOMController_storage, "f").syncMetadata(this.state.versionInfo).catch((exp) => {
            console.error(`Error while trying to sync metadata: ${exp.message}`);
        });
    }
    return ppom;
}, _PPOMController_updateVersionInfo = 
/*
 * Fetch the version info from the CDN and update the version info in state.
 * Function returns true if update is available for versionInfo.
 */
async function _PPOMController_updateVersionInfo() {
    const versionInfo = await __classPrivateFieldGet(this, _PPOMController_instances, "m", _PPOMController_fetchVersionInfo).call(this);
    if (versionInfo) {
        this.update((draftState) => {
            draftState.versionInfo = versionInfo;
        });
        return true;
    }
    return false;
}, _PPOMController_checkFilePresentInStorage = function _PPOMController_checkFilePresentInStorage(storageMetadata, fileVersionInfo) {
    return storageMetadata.find((file) => file.name === fileVersionInfo.name &&
        file.chainId === fileVersionInfo.chainId &&
        file.version === fileVersionInfo.version &&
        file.checksum === fileVersionInfo.checksum);
}, _PPOMController_getAllFiles = 
/*
 *
 * Get all files listed in versionInfo passed.
 */
async function _PPOMController_getAllFiles(versionInfo) {
    const files = await Promise.all(versionInfo.map(async (file) => {
        let data;
        try {
            data = await __classPrivateFieldGet(this, _PPOMController_instances, "m", _PPOMController_getFile).call(this, file);
        }
        catch (exp) {
            console.error(`Error in getting file ${file.filePath}: ${exp.message}`);
        }
        if (data) {
            return [file.name, new Uint8Array(data)];
        }
        return undefined;
    }));
    return files?.filter((data) => data?.[1] !== undefined);
}, _PPOMController_getFile = 
/*
 * Gets a single file from CDN and write to the storage.
 */
async function _PPOMController_getFile(fileVersionInfo) {
    const { storageMetadata } = this.state;
    // do not fetch file if the storage version is latest
    if (__classPrivateFieldGet(this, _PPOMController_instances, "m", _PPOMController_checkFilePresentInStorage).call(this, storageMetadata, fileVersionInfo)) {
        try {
            return await __classPrivateFieldGet(this, _PPOMController_storage, "f").readFile(fileVersionInfo.name, fileVersionInfo.chainId);
        }
        catch (error) {
            console.error(`Error in reading file: ${error.message}`);
        }
    }
    // validate file path for valid characters
    (0, util_1.checkFilePath)(fileVersionInfo.filePath);
    const fileUrl = (0, util_1.constructURLHref)(__classPrivateFieldGet(this, _PPOMController_cdnBaseUrl, "f"), fileVersionInfo.filePath);
    const fileData = await __classPrivateFieldGet(this, _PPOMController_instances, "m", _PPOMController_fetchBlob).call(this, fileUrl);
    await (0, util_1.validateSignature)(fileData, fileVersionInfo.hashSignature, __classPrivateFieldGet(this, _PPOMController_blockaidPublicKey, "f"), fileVersionInfo.filePath, __classPrivateFieldGet(this, _PPOMController_nativeCrypto, "f"));
    await __classPrivateFieldGet(this, _PPOMController_storage, "f")
        .writeFile({
        data: fileData,
        ...fileVersionInfo,
    })
        .catch((error) => {
        console.error(`Error in writing file: ${error.message}`);
    });
    return fileData;
}, _PPOMController_getAPIResponse = 
/*
 * Generic method to fetch file from CDN.
 */
async function _PPOMController_getAPIResponse(url, options = {}, method = 'GET') {
    const response = await (0, controller_utils_1.safelyExecute)(async () => (0, controller_utils_1.timeoutFetch)(url, {
        method,
        cache: 'no-cache',
        redirect: 'error',
        ...options,
    }, 10000), true);
    const cached = response?.status === 304;
    if (!response?.status || response?.status < 200 || response?.status > 399) {
        throw new Error(`Failed to fetch file with url: ${url}`);
    }
    return { cached, response };
}, _PPOMController_fetchVersionInfo = 
/*
 * Fetch the version info from the PPOM cdn.
 */
async function _PPOMController_fetchVersionInfo() {
    const url = (0, util_1.constructURLHref)(__classPrivateFieldGet(this, _PPOMController_cdnBaseUrl, "f"), PPOM_VERSION_FILE_NAME);
    const { cached, response } = await __classPrivateFieldGet(this, _PPOMController_instances, "m", _PPOMController_getAPIResponse).call(this, url, {
        headers: versionInfoFileHeaders,
    });
    if (cached && this.state.versionInfo?.length) {
        return undefined;
    }
    return response.json();
}, _PPOMController_fetchBlob = 
/*
 * Fetch the blob file from the PPOM cdn.
 */
async function _PPOMController_fetchBlob(url) {
    const { response } = await __classPrivateFieldGet(this, _PPOMController_instances, "m", _PPOMController_getAPIResponse).call(this, url);
    return await response.arrayBuffer();
}, _PPOMController_jsonRpcRequest = 
/*
 * Send a JSON RPC request to the provider.
 * This method is used by the PPOM to make requests to the provider.
 */
async function _PPOMController_jsonRpcRequest(method, params) {
    // Resolve with error if number of requests from PPOM to provider exceeds the limit for the current transaction
    if (__classPrivateFieldGet(this, _PPOMController_providerRequests, "f") > __classPrivateFieldGet(this, _PPOMController_providerRequestLimit, "f")) {
        return util_1.PROVIDER_ERRORS.limitExceeded();
    }
    __classPrivateFieldSet(this, _PPOMController_providerRequests, __classPrivateFieldGet(this, _PPOMController_providerRequests, "f") + 1, "f");
    // Resolve with error if the provider method called by PPOM is not allowed for PPOM
    if (!ALLOWED_PROVIDER_CALLS.includes(method)) {
        return util_1.PROVIDER_ERRORS.methodNotSupported();
    }
    __classPrivateFieldGet(this, _PPOMController_providerRequestsCount, "f")[method] = __classPrivateFieldGet(this, _PPOMController_providerRequestsCount, "f")[method]
        ? Number(__classPrivateFieldGet(this, _PPOMController_providerRequestsCount, "f")[method]) + 1
        : 1;
    const payload = (0, util_1.createPayload)(method, params);
    try {
        const result = await __classPrivateFieldGet(this, _PPOMController_provider, "f").request(payload);
        return { jsonrpc: '2.0', id: payload.id, result };
    }
    catch (error) {
        return {
            jsonrpc: '2.0',
            id: payload.id,
            error,
        };
    }
}, _PPOMController_getPPOM = 
/*
 * This function can be called to initialise PPOM or re-initilise it,
 * when new files are required to be passed to it.
 *
 * It will load the data files from storage and pass data files and wasm file to ppom.
 */
async function _PPOMController_getPPOM(chainId) {
    // PPOM initialisation in contructor fails for react native
    // thus it is added here to prevent validation from failing.
    await __classPrivateFieldGet(this, _PPOMController_instances, "m", _PPOMController_initialisePPOM).call(this);
    const versionInfo = this.state.versionInfo.filter(({ chainId: id }) => id === chainId);
    // The following code throw error if no data files are found for the chainId.
    // This check has been put in place after suggestion of security team.
    // If we want to disable ppom validation on all instances of Metamask,
    // this can be achieved by returning empty data from version file.
    if (versionInfo?.length === undefined || versionInfo?.length === 0) {
        throw new Error(`Aborting initialising PPOM as no files are found for the network with chainId: ${chainId}`);
    }
    // Get all the files for  the chainId
    const files = await __classPrivateFieldGet(this, _PPOMController_instances, "m", _PPOMController_getAllFiles).call(this, versionInfo);
    if (files?.length !== versionInfo?.length) {
        throw new Error(`Aborting initialising PPOM as not all files could not be downloaded for the network with chainId: ${chainId}`);
    }
    const { PPOM } = __classPrivateFieldGet(this, _PPOMController_ppomProvider, "f");
    return PPOM.new(__classPrivateFieldGet(this, _PPOMController_instances, "m", _PPOMController_jsonRpcRequest).bind(this), files);
};

      };
    };
  }
  }
}, {package:"@metamask/ppom-validator",file:"node_modules\\@metamask\\ppom-validator\\dist\\ppom-controller.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ppom-validator\\dist\\ppom-storage.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cppom-validator%5Cdist%5Cppom-storage.js
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _PPOMStorage_storageBackend, _PPOMStorage_readMetadata, _PPOMStorage_writeMetadata;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PPOMStorage = void 0;
/**
 * @class PPOMStorage
 * This class is responsible for managing the local storage
 * It provides the following functionalities:
 * 1. Sync the metadata with the version info from the cdn
 * 2. Read a file from the local storage
 * 3. Write a file to the local storage
 *
 * It also validates the checksum of the file when reading and writing in order to
 * detect corrupted files or files that are not up to date
 */
class PPOMStorage {
    /**
     * Creates a PPOMStorage instance.
     *
     * @param options - The options passed to the function.
     * @param options.storageBackend - The storage backend to use for the local storage.
     * @param options.readMetadata - A function to read the metadata from the local storage.
     * @param options.writeMetadata - A function to write the metadata to the local storage.
     */
    constructor({ storageBackend, readMetadata, writeMetadata, }) {
        _PPOMStorage_storageBackend.set(this, void 0);
        _PPOMStorage_readMetadata.set(this, void 0);
        _PPOMStorage_writeMetadata.set(this, void 0);
        __classPrivateFieldSet(this, _PPOMStorage_storageBackend, storageBackend, "f");
        __classPrivateFieldSet(this, _PPOMStorage_readMetadata, readMetadata, "f");
        __classPrivateFieldSet(this, _PPOMStorage_writeMetadata, writeMetadata, "f");
    }
    /**
     * Sync the metadata with the version info from the cdn.
     * 1. Remove the files that are not readable (e.g. corrupted or deleted).
     * 2. Remove the files that are not in the cdn anymore.
     * 3. Remove the files that are not up to date in the cdn.
     * 4. Remove the files that are not in the local storage from the metadata.
     * 5. Delete the files that are not in the metadata from the local storage.
     *
     * @param versionInfo - Version information of metadata files.
     */
    async syncMetadata(versionInfo) {
        const metadata = __classPrivateFieldGet(this, _PPOMStorage_readMetadata, "f").call(this);
        const syncedMetadata = [];
        for (const fileMetadata of metadata) {
            // check if the file is readable (e.g. corrupted or deleted)
            try {
                await this.readFile(fileMetadata.name, fileMetadata.chainId);
            }
            catch (exp) {
                console.error('Error: ', exp);
                continue;
            }
            // check if the file exits and up to date in the storage
            if (!versionInfo.find((file) => file.name === fileMetadata.name &&
                file.chainId === fileMetadata.chainId &&
                file.version === fileMetadata.version &&
                file.checksum === fileMetadata.checksum)) {
                continue;
            }
            syncedMetadata.push(fileMetadata);
        }
        const filesInDB = await __classPrivateFieldGet(this, _PPOMStorage_storageBackend, "f").dir();
        for (const { name, chainId } of filesInDB) {
            if (!syncedMetadata.find((file) => file.name === name && file.chainId === chainId)) {
                await __classPrivateFieldGet(this, _PPOMStorage_storageBackend, "f").delete({ name, chainId });
            }
        }
        __classPrivateFieldGet(this, _PPOMStorage_writeMetadata, "f").call(this, syncedMetadata);
        return syncedMetadata;
    }
    /**
     * Delete all files in storage.
     *
     * @param metadata - List of all files in storage.
     */
    async deleteAllFiles(metadata) {
        for (const fileMetadata of metadata) {
            const { name, chainId } = fileMetadata;
            try {
                await __classPrivateFieldGet(this, _PPOMStorage_storageBackend, "f").delete({ name, chainId });
            }
            catch (exp) {
                console.error(`Error in deleting file: ${name}, ${chainId}`, exp);
            }
        }
    }
    /**
     * Read the file from the local storage.
     * 1. Check if the file exists in the local storage.
     * 2. Check if the file exists in the metadata.
     *
     * @param name - Name assigned to storage.
     * @param chainId - ChainId for which file is queried.
     */
    async readFile(name, chainId) {
        const metadata = __classPrivateFieldGet(this, _PPOMStorage_readMetadata, "f").call(this);
        const fileMetadata = metadata.find((file) => file.name === name && file.chainId === chainId);
        if (!fileMetadata) {
            throw new Error(`File metadata (${name}, ${chainId}) not found`);
        }
        const data = await __classPrivateFieldGet(this, _PPOMStorage_storageBackend, "f").read({ name, chainId }, fileMetadata.checksum);
        if (!data) {
            throw new Error(`Storage File (${name}, ${chainId}) not found`);
        }
        return data;
    }
    /**
     * Write the file to the local storage.
     * 1. Write the file to the local storage.
     * 2. Update the metadata.
     *
     * @param options - Object passed to write to storage.
     * @param options.data - File data to be written.
     * @param options.name - Name to be assigned to the storage.
     * @param options.chainId - Current ChainId.
     * @param options.version - Version of file.
     * @param options.checksum - Checksum of file.
     */
    async writeFile({ data, name, chainId, version, checksum, }) {
        await __classPrivateFieldGet(this, _PPOMStorage_storageBackend, "f").write({ name, chainId }, data, checksum);
        const metadata = __classPrivateFieldGet(this, _PPOMStorage_readMetadata, "f").call(this);
        const fileMetadata = metadata.find((file) => file.name === name && file.chainId === chainId);
        if (fileMetadata) {
            fileMetadata.version = version;
            fileMetadata.checksum = checksum;
        }
        else {
            metadata.push({ name, chainId, version, checksum });
        }
        __classPrivateFieldGet(this, _PPOMStorage_writeMetadata, "f").call(this, metadata);
    }
}
exports.PPOMStorage = PPOMStorage;
_PPOMStorage_storageBackend = new WeakMap(), _PPOMStorage_readMetadata = new WeakMap(), _PPOMStorage_writeMetadata = new WeakMap();

      };
    };
  }
  }
}, {package:"@metamask/ppom-validator",file:"node_modules\\@metamask\\ppom-validator\\dist\\ppom-storage.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ppom-validator\\dist\\util.js", {"buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js","crypto-js":"D:\\code\\v\\metamask-extension\\node_modules\\crypto-js\\index.js","elliptic":"D:\\code\\v\\metamask-extension\\node_modules\\elliptic\\lib\\elliptic.js","json-rpc-random-id":"D:\\code\\v\\metamask-extension\\node_modules\\json-rpc-random-id\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cppom-validator%5Cdist%5Cutil.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkFilePath = exports.addHexPrefix = exports.constructURLHref = exports.validateSignature = exports.PROVIDER_ERRORS = exports.createPayload = exports.IdGenerator = exports.blockaidValidationSupportedForNetwork = exports.SUPPORTED_NETWORK_CHAINIDS = void 0;
const crypto_js_1 = __importStar(require("crypto-js"));
const elliptic_1 = __importDefault(require("elliptic"));
const json_rpc_random_id_1 = __importDefault(require("json-rpc-random-id"));
const EdDSA = elliptic_1.default.eddsa;
const URL_PREFIX = 'https://';
exports.SUPPORTED_NETWORK_CHAINIDS = {
    MAINNET: '0x1',
    BSC: '0x38',
    OPTIMISM: '0xa',
    POLYGON: '0x89',
    AVALANCHE: '0xa86a',
    ARBITRUM: '0xa4b1',
    LINEA_MAINNET: '0xe708',
    BASE: '0x2105',
    SEPOLIA: '0xaa36a7',
    OPBNB: '0xcc',
    ZKSYNC: '0x144',
    SCROLL: '0x82750',
    BERACHAIN: '0x138d4',
    METACHAIN_ONE: '0x1b6e6',
};
const blockaidValidationSupportedForNetwork = (chainId) => {
    return Object.values(exports.SUPPORTED_NETWORK_CHAINIDS).some((cid) => cid === chainId);
};
exports.blockaidValidationSupportedForNetwork = blockaidValidationSupportedForNetwork;
exports.IdGenerator = (0, json_rpc_random_id_1.default)();
const createPayload = (method, params) => ({
    id: (0, exports.IdGenerator)(),
    jsonrpc: '2.0',
    method,
    params: params ?? [],
});
exports.createPayload = createPayload;
exports.PROVIDER_ERRORS = {
    limitExceeded: () => ({
        jsonrpc: '2.0',
        id: (0, exports.IdGenerator)(),
        error: {
            code: -32005,
            message: 'Limit exceeded',
        },
    }),
    methodNotSupported: () => ({
        jsonrpc: '2.0',
        id: (0, exports.IdGenerator)(),
        error: {
            code: -32601,
            message: 'Method not supported',
        },
    }),
};
const getHash = async (data, nativeCrypto, useNative = true) => {
    if (nativeCrypto) {
        return nativeCrypto.createHash('sha256').update(data).digest('hex');
    }
    if ('crypto' in globalThis &&
        typeof globalThis.crypto === 'object' &&
        globalThis.crypto.subtle?.digest &&
        useNative) {
        const hashBuffer = await globalThis.crypto.subtle.digest('SHA-256', data);
        const hashArray = Array.from(new Uint8Array(hashBuffer));
        const hash = hashArray
            .map((item) => item.toString(16).padStart(2, '0'))
            .join('');
        return hash;
    }
    return (0, crypto_js_1.SHA256)(crypto_js_1.default.lib.WordArray.create(data)).toString();
};
// useNative argument is added for testing purpose, without it test cases are breaking in Node-20 and above
// Reason being that in node 20 crypto is always present in globalThis
// and it is not possible to reset it due to security reasons
const validateSignature = async (data, hashSignature, key, filePath, nativeCrypto, useNative) => {
    const hashString = await getHash(data, nativeCrypto, useNative);
    // const hashString = hash.toString();
    const ec = new EdDSA('ed25519');
    const ecKey = ec.keyFromPublic(key);
    // eslint-disable-next-line no-restricted-globals
    const result = ecKey.verify(Buffer.from(hashString), hashSignature);
    if (!result) {
        throw Error(`Signature verification failed for file path: ${filePath}`);
    }
};
exports.validateSignature = validateSignature;
const constructURLHref = (base, path) => new URL(`${URL_PREFIX}${base}/${path}`
    .replace(/https:\/\/https:\/\//gu, 'https://')
    .replace(/\/\//gu, '/')).href;
exports.constructURLHref = constructURLHref;
const addHexPrefix = (str) => {
    if (typeof str !== 'string' || str.match(/^-?0x/u)) {
        return str;
    }
    if (str.match(/^-?0X/u)) {
        return str.replace('0X', '0x');
    }
    return `0x${parseInt(str, 10).toString(16)}`;
};
exports.addHexPrefix = addHexPrefix;
/*
 * The function check to ensure that file path can contain only alphanumeric
 * characters and a dot character (.) or slash (/).
 */
const checkFilePath = (filePath) => {
    const filePathRegex = /^[\w./]+$/u;
    if (!filePath.match(filePathRegex)) {
        throw new Error(`Invalid file path for data file: ${filePath}`);
    }
};
exports.checkFilePath = checkFilePath;

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"@metamask/ppom-validator",file:"node_modules\\@metamask\\ppom-validator\\dist\\util.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rate-limit-controller\\dist\\RateLimitController.cjs", {"@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Crate-limit-controller%5Cdist%5CRateLimitController.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RateLimitController = void 0;
const base_controller_1 = require("@metamask/base-controller");
const rpc_errors_1 = require("@metamask/rpc-errors");
const utils_1 = require("@metamask/utils");
const name = 'RateLimitController';
const metadata = {
    requests: { persist: false, anonymous: false },
};
/**
 * Controller with logic for rate-limiting API endpoints per requesting origin.
 */
class RateLimitController extends base_controller_1.BaseController {
    /**
     * Creates a RateLimitController instance.
     *
     * @param options - Constructor options.
     * @param options.messenger - A reference to the messaging system.
     * @param options.state - Initial state to set on this controller.
     * @param options.implementations - Mapping from API type to API implementation.
     * @param options.rateLimitTimeout - The time window in which the rate limit is applied (in ms).
     * @param options.rateLimitCount - The amount of calls an origin can make in the rate limit time window.
     */
    constructor({ rateLimitTimeout = 5000, rateLimitCount = 1, messenger, state, implementations, }) {
        const defaultState = {
            requests: (0, utils_1.getKnownPropertyNames)(implementations).reduce((acc, key) => ({ ...acc, [key]: {} }), {}),
        };
        super({
            name,
            metadata,
            messenger,
            state: { ...defaultState, ...state },
        });
        this.implementations = implementations;
        this.rateLimitTimeout = rateLimitTimeout;
        this.rateLimitCount = rateLimitCount;
        this.messagingSystem.registerActionHandler(`${name}:call`, (origin, type, ...args) => this.call(origin, type, ...args));
    }
    /**
     * Calls an API if the requesting origin is not rate-limited.
     *
     * @param origin - The requesting origin.
     * @param type - The type of API call to make.
     * @param args - Arguments for the API call.
     */
    async call(origin, type, ...args) {
        if (this.isRateLimited(type, origin)) {
            throw rpc_errors_1.rpcErrors.limitExceeded({
                message: `"${type.toString()}" is currently rate-limited. Please try again later.`,
            });
        }
        this.recordRequest(type, origin);
        const implementation = this.implementations[type].method;
        if (!implementation) {
            throw new Error('Invalid api type');
        }
        return implementation(...args);
    }
    /**
     * Checks whether an origin is rate limited for the a specific API.
     *
     * @param api - The API the origin is trying to access.
     * @param origin - The origin trying to access the API.
     * @returns `true` if rate-limited, and `false` otherwise.
     */
    isRateLimited(api, origin) {
        const rateLimitCount = this.implementations[api].rateLimitCount ?? this.rateLimitCount;
        return this.state.requests[api][origin] >= rateLimitCount;
    }
    /**
     * Records that an origin has made a request to call an API, for rate-limiting purposes.
     *
     * @param api - The API the origin is trying to access.
     * @param origin - The origin trying to access the API.
     */
    recordRequest(api, origin) {
        const rateLimitTimeout = this.implementations[api].rateLimitTimeout ?? this.rateLimitTimeout;
        const previous = this.state.requests[api][origin] ?? 0;
        this.update((state) => {
            if (previous === 0) {
                setTimeout(() => this.resetRequestCount(api, origin), rateLimitTimeout);
            }
            Object.assign(state, {
                requests: {
                    ...state.requests,
                    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
                    // eslint-disable-next-line @typescript-eslint/restrict-plus-operands
                    [api]: { [origin]: previous + 1 },
                },
            });
        });
    }
    /**
     * Resets the request count for a given origin and API combination, for rate-limiting purposes.
     *
     * @param api - The API in question.
     * @param origin - The origin in question.
     */
    resetRequestCount(api, origin) {
        this.update((state) => {
            Object.assign(state, {
                requests: {
                    ...state.requests,
                    [api]: { [origin]: 0 },
                },
            });
        });
    }
}
exports.RateLimitController = RateLimitController;

      };
    };
  }
  }
}, {package:"@metamask/rate-limit-controller",file:"node_modules\\@metamask\\rate-limit-controller\\dist\\RateLimitController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rate-limit-controller\\dist\\index.cjs", {"./RateLimitController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rate-limit-controller\\dist\\RateLimitController.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Crate-limit-controller%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RateLimitController = void 0;
var RateLimitController_1 = require("./RateLimitController.cjs");
Object.defineProperty(exports, "RateLimitController", { enumerable: true, get: function () { return RateLimitController_1.RateLimitController; } });

      };
    };
  }
  }
}, {package:"@metamask/rate-limit-controller",file:"node_modules\\@metamask\\rate-limit-controller\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\remote-feature-flag-controller\\dist\\client-config-api-service\\client-config-api-service.cjs", {"../constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\remote-feature-flag-controller\\dist\\constants.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cremote-feature-flag-controller%5Cdist%5Cclient-config-api-service%5Cclient-config-api-service.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _ClientConfigApiService_fetch, _ClientConfigApiService_policy, _ClientConfigApiService_client, _ClientConfigApiService_distribution, _ClientConfigApiService_environment;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientConfigApiService = void 0;
const controller_utils_1 = require("@metamask/controller-utils");
const constants_1 = require("../constants.cjs");
/**
 * This service is responsible for fetching feature flags from the ClientConfig API.
 */
class ClientConfigApiService {
    constructor({ fetch: fetchFunction, retries = controller_utils_1.DEFAULT_MAX_RETRIES, maximumConsecutiveFailures = controller_utils_1.DEFAULT_MAX_CONSECUTIVE_FAILURES, circuitBreakDuration = controller_utils_1.DEFAULT_CIRCUIT_BREAK_DURATION, onBreak, onDegraded, config, }) {
        _ClientConfigApiService_fetch.set(this, void 0);
        _ClientConfigApiService_policy.set(this, void 0);
        _ClientConfigApiService_client.set(this, void 0);
        _ClientConfigApiService_distribution.set(this, void 0);
        _ClientConfigApiService_environment.set(this, void 0);
        __classPrivateFieldSet(this, _ClientConfigApiService_fetch, fetchFunction, "f");
        __classPrivateFieldSet(this, _ClientConfigApiService_client, config.client, "f");
        __classPrivateFieldSet(this, _ClientConfigApiService_distribution, config.distribution, "f");
        __classPrivateFieldSet(this, _ClientConfigApiService_environment, config.environment, "f");
        __classPrivateFieldSet(this, _ClientConfigApiService_policy, (0, controller_utils_1.createServicePolicy)({
            maxRetries: retries,
            maxConsecutiveFailures: maximumConsecutiveFailures,
            circuitBreakDuration,
        }), "f");
        if (onBreak) {
            __classPrivateFieldGet(this, _ClientConfigApiService_policy, "f").onBreak(onBreak);
        }
        if (onDegraded) {
            __classPrivateFieldGet(this, _ClientConfigApiService_policy, "f").onDegraded(onDegraded);
        }
    }
    /**
     * Listens for when the request to the API fails too many times in a row.
     *
     * @param args - The same arguments that {@link ServicePolicy.onBreak}
     * takes.
     * @returns What {@link ServicePolicy.onBreak} returns.
     */
    onBreak(...args) {
        return __classPrivateFieldGet(this, _ClientConfigApiService_policy, "f").onBreak(...args);
    }
    /**
     * Listens for when the API is degraded.
     *
     * @param args - The same arguments that {@link ServicePolicy.onDegraded}
     * takes.
     * @returns What {@link ServicePolicy.onDegraded} returns.
     */
    onDegraded(...args) {
        return __classPrivateFieldGet(this, _ClientConfigApiService_policy, "f").onDegraded(...args);
    }
    /**
     * Fetches feature flags from the API with specific client, distribution, and environment parameters.
     * Provides structured error handling, including fallback to cached data if available.
     * @returns An object of feature flags and their boolean values or a structured error object.
     */
    async fetchRemoteFeatureFlags() {
        const url = `${constants_1.BASE_URL}/flags?client=${__classPrivateFieldGet(this, _ClientConfigApiService_client, "f")}&distribution=${__classPrivateFieldGet(this, _ClientConfigApiService_distribution, "f")}&environment=${__classPrivateFieldGet(this, _ClientConfigApiService_environment, "f")}`;
        const response = await __classPrivateFieldGet(this, _ClientConfigApiService_policy, "f").execute(() => __classPrivateFieldGet(this, _ClientConfigApiService_fetch, "f").call(this, url, { cache: 'no-cache' }));
        if (!response.ok) {
            throw new Error('Failed to fetch remote feature flags');
        }
        const data = await response.json();
        if (!Array.isArray(data)) {
            throw new Error('Feature flags api did not return an array');
        }
        const remoteFeatureFlags = this.flattenFeatureFlags(data);
        return {
            remoteFeatureFlags,
            cacheTimestamp: Date.now(),
        };
    }
    /**
     * Flattens an array of feature flag objects into a single feature flags object.
     * @param responseData - Array of objects containing feature flag key-value pairs
     * @returns A single object containing all feature flags merged together
     * @example
     * // Input: [{ flag1: true }, { flag2: [] }]
     * // Output: { flag1: true, flag2: [] }
     */
    flattenFeatureFlags(responseData) {
        return responseData.reduce((acc, curr) => {
            return { ...acc, ...curr };
        }, {});
    }
}
exports.ClientConfigApiService = ClientConfigApiService;
_ClientConfigApiService_fetch = new WeakMap(), _ClientConfigApiService_policy = new WeakMap(), _ClientConfigApiService_client = new WeakMap(), _ClientConfigApiService_distribution = new WeakMap(), _ClientConfigApiService_environment = new WeakMap();

      };
    };
  }
  }
}, {package:"@metamask/remote-feature-flag-controller",file:"node_modules\\@metamask\\remote-feature-flag-controller\\dist\\client-config-api-service\\client-config-api-service.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\remote-feature-flag-controller\\dist\\constants.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cremote-feature-flag-controller%5Cdist%5Cconstants.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BASE_URL = void 0;
/**
 * ClientConfig API base URL.
 */
exports.BASE_URL = 'https://client-config.api.cx.metamask.io/v1';

      };
    };
  }
  }
}, {package:"@metamask/remote-feature-flag-controller",file:"node_modules\\@metamask\\remote-feature-flag-controller\\dist\\constants.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\remote-feature-flag-controller\\dist\\index.cjs", {"./client-config-api-service/client-config-api-service.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\remote-feature-flag-controller\\dist\\client-config-api-service\\client-config-api-service.cjs","./remote-feature-flag-controller-types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\remote-feature-flag-controller\\dist\\remote-feature-flag-controller-types.cjs","./remote-feature-flag-controller.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\remote-feature-flag-controller\\dist\\remote-feature-flag-controller.cjs","./utils/user-segmentation-utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\remote-feature-flag-controller\\dist\\utils\\user-segmentation-utils.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cremote-feature-flag-controller%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateDeterministicRandomNumber = exports.ClientConfigApiService = exports.EnvironmentType = exports.DistributionType = exports.ClientType = exports.RemoteFeatureFlagController = void 0;
var remote_feature_flag_controller_1 = require("./remote-feature-flag-controller.cjs");
Object.defineProperty(exports, "RemoteFeatureFlagController", { enumerable: true, get: function () { return remote_feature_flag_controller_1.RemoteFeatureFlagController; } });
var remote_feature_flag_controller_types_1 = require("./remote-feature-flag-controller-types.cjs");
Object.defineProperty(exports, "ClientType", { enumerable: true, get: function () { return remote_feature_flag_controller_types_1.ClientType; } });
Object.defineProperty(exports, "DistributionType", { enumerable: true, get: function () { return remote_feature_flag_controller_types_1.DistributionType; } });
Object.defineProperty(exports, "EnvironmentType", { enumerable: true, get: function () { return remote_feature_flag_controller_types_1.EnvironmentType; } });
var client_config_api_service_1 = require("./client-config-api-service/client-config-api-service.cjs");
Object.defineProperty(exports, "ClientConfigApiService", { enumerable: true, get: function () { return client_config_api_service_1.ClientConfigApiService; } });
var user_segmentation_utils_1 = require("./utils/user-segmentation-utils.cjs");
Object.defineProperty(exports, "generateDeterministicRandomNumber", { enumerable: true, get: function () { return user_segmentation_utils_1.generateDeterministicRandomNumber; } });

      };
    };
  }
  }
}, {package:"@metamask/remote-feature-flag-controller",file:"node_modules\\@metamask\\remote-feature-flag-controller\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\remote-feature-flag-controller\\dist\\remote-feature-flag-controller-types.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cremote-feature-flag-controller%5Cdist%5Cremote-feature-flag-controller-types.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnvironmentType = exports.DistributionType = exports.ClientType = void 0;
// Define accepted values for client, distribution, and environment
var ClientType;
(function (ClientType) {
    ClientType["Extension"] = "extension";
    ClientType["Mobile"] = "mobile";
})(ClientType || (exports.ClientType = ClientType = {}));
var DistributionType;
(function (DistributionType) {
    DistributionType["Main"] = "main";
    DistributionType["Flask"] = "flask";
    /**
     * @deprecated Use DistributionType Main with EnvironmentType Beta instead
     */
    DistributionType["Beta"] = "beta";
})(DistributionType || (exports.DistributionType = DistributionType = {}));
var EnvironmentType;
(function (EnvironmentType) {
    EnvironmentType["Production"] = "prod";
    EnvironmentType["ReleaseCandidate"] = "rc";
    EnvironmentType["Development"] = "dev";
    EnvironmentType["Beta"] = "beta";
    EnvironmentType["Test"] = "test";
    EnvironmentType["Exp"] = "exp";
})(EnvironmentType || (exports.EnvironmentType = EnvironmentType = {}));

      };
    };
  }
  }
}, {package:"@metamask/remote-feature-flag-controller",file:"node_modules\\@metamask\\remote-feature-flag-controller\\dist\\remote-feature-flag-controller-types.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\remote-feature-flag-controller\\dist\\remote-feature-flag-controller.cjs", {"./utils/user-segmentation-utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\remote-feature-flag-controller\\dist\\utils\\user-segmentation-utils.cjs","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cremote-feature-flag-controller%5Cdist%5Cremote-feature-flag-controller.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _RemoteFeatureFlagController_instances, _RemoteFeatureFlagController_fetchInterval, _RemoteFeatureFlagController_disabled, _RemoteFeatureFlagController_clientConfigApiService, _RemoteFeatureFlagController_inProgressFlagUpdate, _RemoteFeatureFlagController_getMetaMetricsId, _RemoteFeatureFlagController_isCacheExpired, _RemoteFeatureFlagController_updateCache, _RemoteFeatureFlagController_processRemoteFeatureFlags;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RemoteFeatureFlagController = exports.getDefaultRemoteFeatureFlagControllerState = exports.DEFAULT_CACHE_DURATION = exports.controllerName = void 0;
const base_controller_1 = require("@metamask/base-controller");
const user_segmentation_utils_1 = require("./utils/user-segmentation-utils.cjs");
// === GENERAL ===
exports.controllerName = 'RemoteFeatureFlagController';
exports.DEFAULT_CACHE_DURATION = 24 * 60 * 60 * 1000; // 1 day
const remoteFeatureFlagControllerMetadata = {
    remoteFeatureFlags: {
        includeInStateLogs: true,
        persist: true,
        anonymous: true,
        usedInUi: true,
    },
    cacheTimestamp: {
        includeInStateLogs: true,
        persist: true,
        anonymous: true,
        usedInUi: false,
    },
};
/**
 * Returns the default state for the RemoteFeatureFlagController.
 *
 * @returns The default controller state.
 */
function getDefaultRemoteFeatureFlagControllerState() {
    return {
        remoteFeatureFlags: {},
        cacheTimestamp: 0,
    };
}
exports.getDefaultRemoteFeatureFlagControllerState = getDefaultRemoteFeatureFlagControllerState;
/**
 * The RemoteFeatureFlagController manages the retrieval and caching of remote feature flags.
 * It fetches feature flags from a remote API, caches them, and provides methods to access
 * and manage these flags. The controller ensures that feature flags are refreshed based on
 * a specified interval and handles cases where the controller is disabled or the network is unavailable.
 */
class RemoteFeatureFlagController extends base_controller_1.BaseController {
    /**
     * Constructs a new RemoteFeatureFlagController instance.
     *
     * @param options - The controller options.
     * @param options.messenger - The messenger used for communication.
     * @param options.state - The initial state of the controller.
     * @param options.clientConfigApiService - The service instance to fetch remote feature flags.
     * @param options.fetchInterval - The interval in milliseconds before cached flags expire. Defaults to 1 day.
     * @param options.disabled - Determines if the controller should be disabled initially. Defaults to false.
     * @param options.getMetaMetricsId - Returns metaMetricsId.
     */
    constructor({ messenger, state, clientConfigApiService, fetchInterval = exports.DEFAULT_CACHE_DURATION, disabled = false, getMetaMetricsId, }) {
        super({
            name: exports.controllerName,
            metadata: remoteFeatureFlagControllerMetadata,
            messenger,
            state: {
                ...getDefaultRemoteFeatureFlagControllerState(),
                ...state,
            },
        });
        _RemoteFeatureFlagController_instances.add(this);
        _RemoteFeatureFlagController_fetchInterval.set(this, void 0);
        _RemoteFeatureFlagController_disabled.set(this, void 0);
        _RemoteFeatureFlagController_clientConfigApiService.set(this, void 0);
        _RemoteFeatureFlagController_inProgressFlagUpdate.set(this, void 0);
        _RemoteFeatureFlagController_getMetaMetricsId.set(this, void 0);
        __classPrivateFieldSet(this, _RemoteFeatureFlagController_fetchInterval, fetchInterval, "f");
        __classPrivateFieldSet(this, _RemoteFeatureFlagController_disabled, disabled, "f");
        __classPrivateFieldSet(this, _RemoteFeatureFlagController_clientConfigApiService, clientConfigApiService, "f");
        __classPrivateFieldSet(this, _RemoteFeatureFlagController_getMetaMetricsId, getMetaMetricsId, "f");
    }
    /**
     * Retrieves the remote feature flags, fetching from the API if necessary.
     * Uses caching to prevent redundant API calls and handles concurrent fetches.
     *
     * @returns A promise that resolves to the current set of feature flags.
     */
    async updateRemoteFeatureFlags() {
        if (__classPrivateFieldGet(this, _RemoteFeatureFlagController_disabled, "f") || !__classPrivateFieldGet(this, _RemoteFeatureFlagController_instances, "m", _RemoteFeatureFlagController_isCacheExpired).call(this)) {
            return;
        }
        let serverData;
        if (__classPrivateFieldGet(this, _RemoteFeatureFlagController_inProgressFlagUpdate, "f")) {
            await __classPrivateFieldGet(this, _RemoteFeatureFlagController_inProgressFlagUpdate, "f");
            return;
        }
        try {
            __classPrivateFieldSet(this, _RemoteFeatureFlagController_inProgressFlagUpdate, __classPrivateFieldGet(this, _RemoteFeatureFlagController_clientConfigApiService, "f").fetchRemoteFeatureFlags(), "f");
            serverData = await __classPrivateFieldGet(this, _RemoteFeatureFlagController_inProgressFlagUpdate, "f");
        }
        finally {
            __classPrivateFieldSet(this, _RemoteFeatureFlagController_inProgressFlagUpdate, undefined, "f");
        }
        await __classPrivateFieldGet(this, _RemoteFeatureFlagController_instances, "m", _RemoteFeatureFlagController_updateCache).call(this, serverData.remoteFeatureFlags);
    }
    /**
     * Enables the controller, allowing it to make network requests.
     */
    enable() {
        __classPrivateFieldSet(this, _RemoteFeatureFlagController_disabled, false, "f");
    }
    /**
     * Disables the controller, preventing it from making network requests.
     */
    disable() {
        __classPrivateFieldSet(this, _RemoteFeatureFlagController_disabled, true, "f");
    }
}
exports.RemoteFeatureFlagController = RemoteFeatureFlagController;
_RemoteFeatureFlagController_fetchInterval = new WeakMap(), _RemoteFeatureFlagController_disabled = new WeakMap(), _RemoteFeatureFlagController_clientConfigApiService = new WeakMap(), _RemoteFeatureFlagController_inProgressFlagUpdate = new WeakMap(), _RemoteFeatureFlagController_getMetaMetricsId = new WeakMap(), _RemoteFeatureFlagController_instances = new WeakSet(), _RemoteFeatureFlagController_isCacheExpired = function _RemoteFeatureFlagController_isCacheExpired() {
    return Date.now() - this.state.cacheTimestamp > __classPrivateFieldGet(this, _RemoteFeatureFlagController_fetchInterval, "f");
}, _RemoteFeatureFlagController_updateCache = 
/**
 * Updates the controller's state with new feature flags and resets the cache timestamp.
 *
 * @param remoteFeatureFlags - The new feature flags to cache.
 * @private
 */
async function _RemoteFeatureFlagController_updateCache(remoteFeatureFlags) {
    const processedRemoteFeatureFlags = await __classPrivateFieldGet(this, _RemoteFeatureFlagController_instances, "m", _RemoteFeatureFlagController_processRemoteFeatureFlags).call(this, remoteFeatureFlags);
    this.update(() => {
        return {
            remoteFeatureFlags: processedRemoteFeatureFlags,
            cacheTimestamp: Date.now(),
        };
    });
}, _RemoteFeatureFlagController_processRemoteFeatureFlags = async function _RemoteFeatureFlagController_processRemoteFeatureFlags(remoteFeatureFlags) {
    const processedRemoteFeatureFlags = {};
    const metaMetricsId = __classPrivateFieldGet(this, _RemoteFeatureFlagController_getMetaMetricsId, "f").call(this);
    const thresholdValue = (0, user_segmentation_utils_1.generateDeterministicRandomNumber)(metaMetricsId);
    for (const [remoteFeatureFlagName, remoteFeatureFlagValue,] of Object.entries(remoteFeatureFlags)) {
        let processedValue = remoteFeatureFlagValue;
        if (Array.isArray(remoteFeatureFlagValue) && thresholdValue) {
            const selectedGroup = remoteFeatureFlagValue.find((featureFlag) => {
                if (!(0, user_segmentation_utils_1.isFeatureFlagWithScopeValue)(featureFlag)) {
                    return false;
                }
                return thresholdValue <= featureFlag.scope.value;
            });
            if (selectedGroup) {
                processedValue = {
                    name: selectedGroup.name,
                    value: selectedGroup.value,
                };
            }
        }
        processedRemoteFeatureFlags[remoteFeatureFlagName] = processedValue;
    }
    return processedRemoteFeatureFlags;
};

      };
    };
  }
  }
}, {package:"@metamask/remote-feature-flag-controller",file:"node_modules\\@metamask\\remote-feature-flag-controller\\dist\\remote-feature-flag-controller.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\remote-feature-flag-controller\\dist\\utils\\user-segmentation-utils.cjs", {"uuid":"D:\\code\\v\\metamask-extension\\node_modules\\uuid\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cremote-feature-flag-controller%5Cdist%5Cutils%5Cuser-segmentation-utils.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isFeatureFlagWithScopeValue = exports.generateDeterministicRandomNumber = void 0;
const uuid_1 = require("uuid");
/**
 * Converts a UUID string to a BigInt by removing dashes and converting to hexadecimal.
 * @param uuid - The UUID string to convert
 * @returns The UUID as a BigInt value
 */
function uuidStringToBigInt(uuid) {
    return BigInt(`0x${uuid.replace(/-/gu, '')}`);
}
const MIN_UUID_V4 = '00000000-0000-4000-8000-000000000000';
const MAX_UUID_V4 = 'ffffffff-ffff-4fff-bfff-ffffffffffff';
const MIN_UUID_V4_BIGINT = uuidStringToBigInt(MIN_UUID_V4);
const MAX_UUID_V4_BIGINT = uuidStringToBigInt(MAX_UUID_V4);
const UUID_V4_VALUE_RANGE_BIGINT = MAX_UUID_V4_BIGINT - MIN_UUID_V4_BIGINT;
/**
 * Generates a deterministic random number between 0 and 1 based on a metaMetricsId.
 * This is useful for A/B testing and feature flag rollouts where we want
 * consistent group assignment for the same user.
 * @param metaMetricsId - The unique identifier used to generate the deterministic random number. Must be either:
 * - A UUIDv4 string (e.g., '123e4567-e89b-12d3-a456-426614174000'
 * - A hex string with '0x' prefix (e.g., '0x86bacb9b2bf9a7e8d2b147eadb95ac9aaa26842327cd24afc8bd4b3c1d136420')
 * @returns A number between 0 and 1, deterministically generated from the input ID.
 * The same input will always produce the same output.
 */
function generateDeterministicRandomNumber(metaMetricsId) {
    if (!metaMetricsId) {
        throw new Error('MetaMetrics ID cannot be empty');
    }
    let idValue;
    let maxValue;
    // uuidv4 format
    if ((0, uuid_1.validate)(metaMetricsId)) {
        if ((0, uuid_1.version)(metaMetricsId) !== 4) {
            throw new Error(`Invalid UUID version. Expected v4, got v${(0, uuid_1.version)(metaMetricsId)}`);
        }
        idValue = uuidStringToBigInt(metaMetricsId) - MIN_UUID_V4_BIGINT;
        maxValue = UUID_V4_VALUE_RANGE_BIGINT;
    }
    else {
        // hex format with 0x prefix
        if (!metaMetricsId.startsWith('0x')) {
            throw new Error('Hex ID must start with 0x prefix');
        }
        const cleanId = metaMetricsId.slice(2);
        const EXPECTED_HEX_LENGTH = 64; // 32 bytes = 64 hex characters
        if (cleanId.length !== EXPECTED_HEX_LENGTH) {
            throw new Error(`Invalid hex ID length. Expected ${EXPECTED_HEX_LENGTH} characters, got ${cleanId.length}`);
        }
        if (!/^[0-9a-f]+$/iu.test(cleanId)) {
            throw new Error('Hex ID contains invalid characters');
        }
        idValue = BigInt(`0x${cleanId}`);
        maxValue = BigInt(`0x${'f'.repeat(cleanId.length)}`);
    }
    // Use BigInt division first, then convert to number to maintain precision
    return Number((idValue * BigInt(1000000)) / maxValue) / 1000000;
}
exports.generateDeterministicRandomNumber = generateDeterministicRandomNumber;
/**
 * Type guard to check if a value is a feature flag with scope.
 * Used to validate feature flag objects that contain scope-based configurations.
 *
 * @param featureFlag - The value to check if it's a feature flag with scope
 * @returns True if the value is a feature flag with scope, false otherwise
 */
const isFeatureFlagWithScopeValue = (featureFlag) => {
    return (typeof featureFlag === 'object' &&
        featureFlag !== null &&
        'scope' in featureFlag);
};
exports.isFeatureFlagWithScopeValue = isFeatureFlagWithScopeValue;

      };
    };
  }
  }
}, {package:"@metamask/remote-feature-flag-controller",file:"node_modules\\@metamask\\remote-feature-flag-controller\\dist\\utils\\user-segmentation-utils.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\selected-network-controller\\dist\\SelectedNetworkController.cjs", {"@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/swappable-obj-proxy":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\swappable-obj-proxy\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cselected-network-controller%5Cdist%5CSelectedNetworkController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _SelectedNetworkController_instances, _SelectedNetworkController_domainProxyMap, _SelectedNetworkController_registerMessageHandlers, _SelectedNetworkController_setNetworkClientIdForDomain, _SelectedNetworkController_unsetNetworkClientIdForDomain, _SelectedNetworkController_domainHasPermissions;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SelectedNetworkController = exports.SelectedNetworkControllerEventTypes = exports.SelectedNetworkControllerActionTypes = exports.METAMASK_DOMAIN = exports.controllerName = void 0;
const base_controller_1 = require("@metamask/base-controller");
const swappable_obj_proxy_1 = require("@metamask/swappable-obj-proxy");
exports.controllerName = 'SelectedNetworkController';
const stateMetadata = {
    domains: {
        includeInStateLogs: true,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
};
const getDefaultState = () => ({ domains: {} });
exports.METAMASK_DOMAIN = 'metamask';
exports.SelectedNetworkControllerActionTypes = {
    getState: `${exports.controllerName}:getState`,
    getNetworkClientIdForDomain: `${exports.controllerName}:getNetworkClientIdForDomain`,
    setNetworkClientIdForDomain: `${exports.controllerName}:setNetworkClientIdForDomain`,
};
exports.SelectedNetworkControllerEventTypes = {
    stateChange: `${exports.controllerName}:stateChange`,
};
/**
 * Controller for getting and setting the network for a particular domain.
 */
class SelectedNetworkController extends base_controller_1.BaseController {
    /**
     * Construct a SelectedNetworkController controller.
     *
     * @param options - The controller options.
     * @param options.messenger - The restricted messenger for the EncryptionPublicKey controller.
     * @param options.state - The controllers initial state.
     * @param options.domainProxyMap - A map for storing domain-specific proxies that are held in memory only during use.
     */
    constructor({ messenger, state = getDefaultState(), domainProxyMap, }) {
        super({
            name: exports.controllerName,
            metadata: stateMetadata,
            messenger,
            state,
        });
        _SelectedNetworkController_instances.add(this);
        _SelectedNetworkController_domainProxyMap.set(this, void 0);
        __classPrivateFieldSet(this, _SelectedNetworkController_domainProxyMap, domainProxyMap, "f");
        __classPrivateFieldGet(this, _SelectedNetworkController_instances, "m", _SelectedNetworkController_registerMessageHandlers).call(this);
        // this is fetching all the dapp permissions from the PermissionsController and looking for any domains that are not in domains state in this controller. Then we take any missing domains and add them to state here, setting it with the globally selected networkClientId (fetched from the NetworkController)
        this.messagingSystem
            .call('PermissionController:getSubjectNames')
            .filter((domain) => this.state.domains[domain] === undefined)
            .forEach((domain) => this.setNetworkClientIdForDomain(domain, this.messagingSystem.call('NetworkController:getState')
            .selectedNetworkClientId));
        this.messagingSystem.subscribe('PermissionController:stateChange', (_, patches) => {
            patches.forEach(({ op, path }) => {
                const isChangingSubject = path[0] === 'subjects' && path[1] !== undefined;
                if (isChangingSubject && typeof path[1] === 'string') {
                    const domain = path[1];
                    if (op === 'add' && this.state.domains[domain] === undefined) {
                        this.setNetworkClientIdForDomain(domain, this.messagingSystem.call('NetworkController:getState')
                            .selectedNetworkClientId);
                    }
                    else if (op === 'remove' &&
                        this.state.domains[domain] !== undefined) {
                        __classPrivateFieldGet(this, _SelectedNetworkController_instances, "m", _SelectedNetworkController_unsetNetworkClientIdForDomain).call(this, domain);
                    }
                }
            });
        });
        this.messagingSystem.subscribe('NetworkController:stateChange', ({ selectedNetworkClientId, networkConfigurationsByChainId }, patches) => {
            const patch = patches.find(({ op, path }) => (op === 'replace' || op === 'remove') &&
                path[0] === 'networkConfigurationsByChainId');
            if (patch) {
                const networkClientIdToChainId = Object.values(networkConfigurationsByChainId).reduce((acc, network) => {
                    network.rpcEndpoints.forEach(({ networkClientId }) => (acc[networkClientId] = network.chainId));
                    return acc;
                }, {});
                Object.entries(this.state.domains).forEach(([domain, networkClientIdForDomain]) => {
                    const chainIdForDomain = networkClientIdToChainId[networkClientIdForDomain];
                    if (patch.op === 'remove' && !chainIdForDomain) {
                        // If the network was removed, fall back to the globally selected network
                        this.setNetworkClientIdForDomain(domain, selectedNetworkClientId);
                    }
                    else if (patch.op === 'replace') {
                        // If the network was updated, redirect to the network's default endpoint
                        const updatedChainId = patch.path[1];
                        if (!chainIdForDomain || chainIdForDomain === updatedChainId) {
                            const network = networkConfigurationsByChainId[updatedChainId];
                            const { networkClientId: defaultNetworkClientId } = network.rpcEndpoints[network.defaultRpcEndpointIndex];
                            if (networkClientIdForDomain !== defaultNetworkClientId) {
                                this.setNetworkClientIdForDomain(domain, defaultNetworkClientId);
                            }
                        }
                    }
                });
            }
        });
    }
    setNetworkClientIdForDomain(domain, networkClientId) {
        if (domain === exports.METAMASK_DOMAIN) {
            throw new Error(`NetworkClientId for domain "${exports.METAMASK_DOMAIN}" cannot be set on the SelectedNetworkController`);
        }
        if (!__classPrivateFieldGet(this, _SelectedNetworkController_instances, "m", _SelectedNetworkController_domainHasPermissions).call(this, domain)) {
            throw new Error('NetworkClientId for domain cannot be called with a domain that has not yet been granted permissions');
        }
        __classPrivateFieldGet(this, _SelectedNetworkController_instances, "m", _SelectedNetworkController_setNetworkClientIdForDomain).call(this, domain, networkClientId);
    }
    getNetworkClientIdForDomain(domain) {
        const { selectedNetworkClientId: metamaskSelectedNetworkClientId } = this.messagingSystem.call('NetworkController:getState');
        return this.state.domains[domain] ?? metamaskSelectedNetworkClientId;
    }
    /**
     * Accesses the provider and block tracker for the currently selected network.
     *
     * @param domain - the domain for the provider
     * @returns The proxy and block tracker proxies.
     */
    getProviderAndBlockTracker(domain) {
        // If the domain is 'metamask', return the NetworkController's globally selected network client proxy
        if (domain === exports.METAMASK_DOMAIN) {
            const networkClient = this.messagingSystem.call('NetworkController:getSelectedNetworkClient');
            if (networkClient === undefined) {
                throw new Error('Selected network not initialized');
            }
            return networkClient;
        }
        let networkProxy = __classPrivateFieldGet(this, _SelectedNetworkController_domainProxyMap, "f").get(domain);
        if (networkProxy === undefined) {
            let networkClient;
            if (__classPrivateFieldGet(this, _SelectedNetworkController_instances, "m", _SelectedNetworkController_domainHasPermissions).call(this, domain)) {
                const networkClientId = this.getNetworkClientIdForDomain(domain);
                networkClient = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId);
            }
            else {
                networkClient = this.messagingSystem.call('NetworkController:getSelectedNetworkClient');
                if (networkClient === undefined) {
                    throw new Error('Selected network not initialized');
                }
            }
            networkProxy = {
                provider: (0, swappable_obj_proxy_1.createEventEmitterProxy)(networkClient.provider),
                blockTracker: (0, swappable_obj_proxy_1.createEventEmitterProxy)(networkClient.blockTracker, {
                    eventFilter: 'skipInternal',
                }),
            };
            __classPrivateFieldGet(this, _SelectedNetworkController_domainProxyMap, "f").set(domain, networkProxy);
        }
        return networkProxy;
    }
}
exports.SelectedNetworkController = SelectedNetworkController;
_SelectedNetworkController_domainProxyMap = new WeakMap(), _SelectedNetworkController_instances = new WeakSet(), _SelectedNetworkController_registerMessageHandlers = function _SelectedNetworkController_registerMessageHandlers() {
    this.messagingSystem.registerActionHandler(exports.SelectedNetworkControllerActionTypes.getNetworkClientIdForDomain, this.getNetworkClientIdForDomain.bind(this));
    this.messagingSystem.registerActionHandler(exports.SelectedNetworkControllerActionTypes.setNetworkClientIdForDomain, this.setNetworkClientIdForDomain.bind(this));
}, _SelectedNetworkController_setNetworkClientIdForDomain = function _SelectedNetworkController_setNetworkClientIdForDomain(domain, networkClientId) {
    const networkClient = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId);
    // This needs to happen before getProviderAndBlockTracker,
    // otherwise we may be referencing a network client ID that no longer exists.
    this.update((state) => {
        state.domains[domain] = networkClientId;
    });
    const networkProxy = this.getProviderAndBlockTracker(domain);
    networkProxy.provider.setTarget(networkClient.provider);
    networkProxy.blockTracker.setTarget(networkClient.blockTracker);
}, _SelectedNetworkController_unsetNetworkClientIdForDomain = function _SelectedNetworkController_unsetNetworkClientIdForDomain(domain) {
    const globallySelectedNetworkClient = this.messagingSystem.call('NetworkController:getSelectedNetworkClient');
    const networkProxy = __classPrivateFieldGet(this, _SelectedNetworkController_domainProxyMap, "f").get(domain);
    if (networkProxy && globallySelectedNetworkClient) {
        networkProxy.provider.setTarget(globallySelectedNetworkClient.provider);
        networkProxy.blockTracker.setTarget(globallySelectedNetworkClient.blockTracker);
    }
    else if (networkProxy) {
        __classPrivateFieldGet(this, _SelectedNetworkController_domainProxyMap, "f").delete(domain);
    }
    this.update((state) => {
        delete state.domains[domain];
    });
}, _SelectedNetworkController_domainHasPermissions = function _SelectedNetworkController_domainHasPermissions(domain) {
    return this.messagingSystem.call('PermissionController:hasPermissions', domain);
};

      };
    };
  }
  }
}, {package:"@metamask/selected-network-controller",file:"node_modules\\@metamask\\selected-network-controller\\dist\\SelectedNetworkController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\selected-network-controller\\dist\\SelectedNetworkMiddleware.cjs", {"./SelectedNetworkController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\selected-network-controller\\dist\\SelectedNetworkController.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cselected-network-controller%5Cdist%5CSelectedNetworkMiddleware.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSelectedNetworkMiddleware = void 0;
const SelectedNetworkController_1 = require("./SelectedNetworkController.cjs");
const createSelectedNetworkMiddleware = (messenger) => {
    const getNetworkClientIdForDomain = (origin) => messenger.call(SelectedNetworkController_1.SelectedNetworkControllerActionTypes.getNetworkClientIdForDomain, origin);
    return (req, _, next) => {
        if (!req.origin) {
            throw new Error("Request object is lacking an 'origin'");
        }
        req.networkClientId = getNetworkClientIdForDomain(req.origin);
        return next();
    };
};
exports.createSelectedNetworkMiddleware = createSelectedNetworkMiddleware;

      };
    };
  }
  }
}, {package:"@metamask/selected-network-controller",file:"node_modules\\@metamask\\selected-network-controller\\dist\\SelectedNetworkMiddleware.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\selected-network-controller\\dist\\index.cjs", {"./SelectedNetworkController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\selected-network-controller\\dist\\SelectedNetworkController.cjs","./SelectedNetworkMiddleware.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\selected-network-controller\\dist\\SelectedNetworkMiddleware.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cselected-network-controller%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSelectedNetworkMiddleware = exports.METAMASK_DOMAIN = exports.SelectedNetworkController = exports.SelectedNetworkControllerEventTypes = exports.SelectedNetworkControllerActionTypes = void 0;
var SelectedNetworkController_1 = require("./SelectedNetworkController.cjs");
Object.defineProperty(exports, "SelectedNetworkControllerActionTypes", { enumerable: true, get: function () { return SelectedNetworkController_1.SelectedNetworkControllerActionTypes; } });
Object.defineProperty(exports, "SelectedNetworkControllerEventTypes", { enumerable: true, get: function () { return SelectedNetworkController_1.SelectedNetworkControllerEventTypes; } });
Object.defineProperty(exports, "SelectedNetworkController", { enumerable: true, get: function () { return SelectedNetworkController_1.SelectedNetworkController; } });
Object.defineProperty(exports, "METAMASK_DOMAIN", { enumerable: true, get: function () { return SelectedNetworkController_1.METAMASK_DOMAIN; } });
var SelectedNetworkMiddleware_1 = require("./SelectedNetworkMiddleware.cjs");
Object.defineProperty(exports, "createSelectedNetworkMiddleware", { enumerable: true, get: function () { return SelectedNetworkMiddleware_1.createSelectedNetworkMiddleware; } });

      };
    };
  }
  }
}, {package:"@metamask/selected-network-controller",file:"node_modules\\@metamask\\selected-network-controller\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\shield-controller\\dist\\ShieldController.cjs", {"./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\shield-controller\\dist\\constants.cjs","./logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\shield-controller\\dist\\logger.cjs","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/signature-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\signature-controller\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cshield-controller%5Cdist%5CShieldController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _ShieldController_instances, _ShieldController_backend, _ShieldController_coverageHistoryLimit, _ShieldController_transactionHistoryLimit, _ShieldController_transactionControllerStateChangeHandler, _ShieldController_signatureControllerStateChangeHandler, _ShieldController_started, _ShieldController_handleSignatureControllerStateChange, _ShieldController_handleTransactionControllerStateChange, _ShieldController_addCoverageResult, _ShieldController_logSignature, _ShieldController_logTransaction, _ShieldController_getCoverageStatus, _ShieldController_getLatestCoverageId;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShieldController = exports.getDefaultShieldControllerState = void 0;
const base_controller_1 = require("@metamask/base-controller");
const signature_controller_1 = require("@metamask/signature-controller");
const transaction_controller_1 = require("@metamask/transaction-controller");
const constants_1 = require("./constants.cjs");
const logger_1 = require("./logger.cjs");
const log = (0, logger_1.createModuleLogger)(logger_1.projectLogger, 'ShieldController');
/**
 * Get the default state for the ShieldController.
 *
 * @returns The default state for the ShieldController.
 */
function getDefaultShieldControllerState() {
    return {
        coverageResults: {},
        orderedTransactionHistory: [],
    };
}
exports.getDefaultShieldControllerState = getDefaultShieldControllerState;
/**
 * Metadata for the ShieldController state, describing how to "anonymize"
 * the state and which parts should be persisted.
 */
const metadata = {
    coverageResults: {
        includeInStateLogs: true,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
    orderedTransactionHistory: {
        includeInStateLogs: true,
        persist: true,
        anonymous: false,
        usedInUi: false,
    },
};
class ShieldController extends base_controller_1.BaseController {
    constructor(options) {
        const { messenger, state, backend, transactionHistoryLimit = 100, coverageHistoryLimit = 10, } = options;
        super({
            name: constants_1.controllerName,
            metadata,
            messenger,
            state: {
                ...getDefaultShieldControllerState(),
                ...state,
            },
        });
        _ShieldController_instances.add(this);
        _ShieldController_backend.set(this, void 0);
        _ShieldController_coverageHistoryLimit.set(this, void 0);
        _ShieldController_transactionHistoryLimit.set(this, void 0);
        _ShieldController_transactionControllerStateChangeHandler.set(this, void 0);
        _ShieldController_signatureControllerStateChangeHandler.set(this, void 0);
        _ShieldController_started.set(this, void 0);
        __classPrivateFieldSet(this, _ShieldController_backend, backend, "f");
        __classPrivateFieldSet(this, _ShieldController_coverageHistoryLimit, coverageHistoryLimit, "f");
        __classPrivateFieldSet(this, _ShieldController_transactionHistoryLimit, transactionHistoryLimit, "f");
        __classPrivateFieldSet(this, _ShieldController_transactionControllerStateChangeHandler, __classPrivateFieldGet(this, _ShieldController_instances, "m", _ShieldController_handleTransactionControllerStateChange).bind(this), "f");
        __classPrivateFieldSet(this, _ShieldController_signatureControllerStateChangeHandler, __classPrivateFieldGet(this, _ShieldController_instances, "m", _ShieldController_handleSignatureControllerStateChange).bind(this), "f");
        __classPrivateFieldSet(this, _ShieldController_started, false, "f");
    }
    start() {
        if (__classPrivateFieldGet(this, _ShieldController_started, "f")) {
            return;
        }
        __classPrivateFieldSet(this, _ShieldController_started, true, "f");
        this.messagingSystem.subscribe('TransactionController:stateChange', __classPrivateFieldGet(this, _ShieldController_transactionControllerStateChangeHandler, "f"), (state) => state.transactions);
        this.messagingSystem.subscribe('SignatureController:stateChange', __classPrivateFieldGet(this, _ShieldController_signatureControllerStateChangeHandler, "f"), (state) => state.signatureRequests);
    }
    stop() {
        if (!__classPrivateFieldGet(this, _ShieldController_started, "f")) {
            return;
        }
        __classPrivateFieldSet(this, _ShieldController_started, false, "f");
        this.messagingSystem.unsubscribe('TransactionController:stateChange', __classPrivateFieldGet(this, _ShieldController_transactionControllerStateChangeHandler, "f"));
        this.messagingSystem.unsubscribe('SignatureController:stateChange', __classPrivateFieldGet(this, _ShieldController_signatureControllerStateChangeHandler, "f"));
    }
    /**
     * Checks the coverage of a transaction.
     *
     * @param txMeta - The transaction to check coverage for.
     * @returns The coverage result.
     */
    async checkCoverage(txMeta) {
        // Check coverage
        const coverageId = __classPrivateFieldGet(this, _ShieldController_instances, "m", _ShieldController_getLatestCoverageId).call(this, txMeta.id);
        const coverageResult = await __classPrivateFieldGet(this, _ShieldController_backend, "f").checkCoverage({
            txMeta,
            coverageId,
        });
        // Publish coverage result
        this.messagingSystem.publish(`${constants_1.controllerName}:coverageResultReceived`, coverageResult);
        // Update state
        __classPrivateFieldGet(this, _ShieldController_instances, "m", _ShieldController_addCoverageResult).call(this, txMeta.id, coverageResult);
        return coverageResult;
    }
    /**
     * Checks the coverage of a signature request.
     *
     * @param signatureRequest - The signature request to check coverage for.
     * @returns The coverage result.
     */
    async checkSignatureCoverage(signatureRequest) {
        // Check coverage
        const coverageId = __classPrivateFieldGet(this, _ShieldController_instances, "m", _ShieldController_getLatestCoverageId).call(this, signatureRequest.id);
        const coverageResult = await __classPrivateFieldGet(this, _ShieldController_backend, "f").checkSignatureCoverage({
            signatureRequest,
            coverageId,
        });
        // Publish coverage result
        this.messagingSystem.publish(`${constants_1.controllerName}:coverageResultReceived`, coverageResult);
        // Update state
        __classPrivateFieldGet(this, _ShieldController_instances, "m", _ShieldController_addCoverageResult).call(this, signatureRequest.id, coverageResult);
        return coverageResult;
    }
}
exports.ShieldController = ShieldController;
_ShieldController_backend = new WeakMap(), _ShieldController_coverageHistoryLimit = new WeakMap(), _ShieldController_transactionHistoryLimit = new WeakMap(), _ShieldController_transactionControllerStateChangeHandler = new WeakMap(), _ShieldController_signatureControllerStateChangeHandler = new WeakMap(), _ShieldController_started = new WeakMap(), _ShieldController_instances = new WeakSet(), _ShieldController_handleSignatureControllerStateChange = function _ShieldController_handleSignatureControllerStateChange(signatureRequests, previousSignatureRequests) {
    const signatureRequestsArray = Object.values(signatureRequests);
    const previousSignatureRequestsArray = Object.values(previousSignatureRequests ?? {});
    const previousSignatureRequestsById = new Map(previousSignatureRequestsArray.map((request) => [request.id, request]));
    for (const signatureRequest of signatureRequestsArray) {
        const previousSignatureRequest = previousSignatureRequestsById.get(signatureRequest.id);
        // Check coverage if the signature request is new and has type
        // `personal_sign`.
        if (!previousSignatureRequest &&
            signatureRequest.type === signature_controller_1.SignatureRequestType.PersonalSign) {
            this.checkSignatureCoverage(signatureRequest).catch(
            // istanbul ignore next
            (error) => log('Error checking coverage:', error));
        }
        // Log signature once the signature request has been fulfilled.
        if (signatureRequest.status === signature_controller_1.SignatureRequestStatus.Signed &&
            signatureRequest.status !== previousSignatureRequest?.status) {
            __classPrivateFieldGet(this, _ShieldController_instances, "m", _ShieldController_logSignature).call(this, signatureRequest).catch(
            // istanbul ignore next
            (error) => log('Error logging signature:', error));
        }
    }
}, _ShieldController_handleTransactionControllerStateChange = function _ShieldController_handleTransactionControllerStateChange(transactions, previousTransactions) {
    const previousTransactionsById = new Map(previousTransactions?.map((tx) => [tx.id, tx]) ?? []);
    for (const transaction of transactions) {
        const previousTransaction = previousTransactionsById.get(transaction.id);
        // Check coverage if the transaction is new or if the simulation data has
        // changed.
        if (!previousTransaction ||
            // Checking reference equality is sufficient because this object is
            // replaced if the simulation data has changed.
            previousTransaction.simulationData !== transaction.simulationData) {
            this.checkCoverage(transaction).catch(
            // istanbul ignore next
            (error) => log('Error checking coverage:', error));
        }
        // Log transaction once it has been submitted.
        if (transaction.status === transaction_controller_1.TransactionStatus.submitted &&
            transaction.status !== previousTransaction?.status) {
            __classPrivateFieldGet(this, _ShieldController_instances, "m", _ShieldController_logTransaction).call(this, transaction).catch(
            // istanbul ignore next
            (error) => log('Error logging transaction:', error));
        }
    }
}, _ShieldController_addCoverageResult = function _ShieldController_addCoverageResult(txId, coverageResult) {
    // Assert the coverageId hasn't changed.
    const latestCoverageId = __classPrivateFieldGet(this, _ShieldController_instances, "m", _ShieldController_getLatestCoverageId).call(this, txId);
    if (latestCoverageId && coverageResult.coverageId !== latestCoverageId) {
        throw new Error('Coverage ID has changed');
    }
    this.update((draft) => {
        // Fetch coverage result entry.
        let newEntry = false;
        let coverageResultEntry = draft.coverageResults[txId];
        // Create new entry if necessary.
        if (!coverageResultEntry) {
            newEntry = true;
            coverageResultEntry = {
                results: [],
            };
            draft.coverageResults[txId] = coverageResultEntry;
        }
        // Trim coverage history if necessary.
        if (coverageResultEntry.results.length >= __classPrivateFieldGet(this, _ShieldController_coverageHistoryLimit, "f")) {
            coverageResultEntry.results.pop();
        }
        // Add new result.
        coverageResultEntry.results.unshift(coverageResult);
        // Add to history if new entry.
        const { orderedTransactionHistory } = draft;
        let removedTxId;
        if (newEntry) {
            // Trim transaction history if necessary.
            if (orderedTransactionHistory.length >= __classPrivateFieldGet(this, _ShieldController_transactionHistoryLimit, "f")) {
                removedTxId = orderedTransactionHistory.pop();
                // Delete corresponding coverage result entry.
                if (removedTxId) {
                    delete draft.coverageResults[removedTxId];
                }
            }
            // Add to history.
            orderedTransactionHistory.unshift(txId);
        }
    });
}, _ShieldController_logSignature = async function _ShieldController_logSignature(signatureRequest) {
    const signature = signatureRequest.rawSig;
    if (!signature) {
        throw new Error('Signature not found');
    }
    const { status } = __classPrivateFieldGet(this, _ShieldController_instances, "m", _ShieldController_getCoverageStatus).call(this, signatureRequest.id);
    await __classPrivateFieldGet(this, _ShieldController_backend, "f").logSignature({
        signatureRequest,
        signature,
        status,
    });
}, _ShieldController_logTransaction = async function _ShieldController_logTransaction(txMeta) {
    const transactionHash = txMeta.hash;
    if (!transactionHash) {
        throw new Error('Transaction hash not found');
    }
    const { status } = __classPrivateFieldGet(this, _ShieldController_instances, "m", _ShieldController_getCoverageStatus).call(this, txMeta.id);
    await __classPrivateFieldGet(this, _ShieldController_backend, "f").logTransaction({
        txMeta,
        transactionHash,
        status,
    });
}, _ShieldController_getCoverageStatus = function _ShieldController_getCoverageStatus(itemId) {
    // The status is assigned as follows:
    // - 'shown' if we have a result
    // - 'not_shown' if we don't have a result
    const coverageId = __classPrivateFieldGet(this, _ShieldController_instances, "m", _ShieldController_getLatestCoverageId).call(this, itemId);
    let status = 'shown';
    if (!coverageId) {
        log('Coverage ID not found for', itemId);
        status = 'not_shown';
    }
    return { status };
}, _ShieldController_getLatestCoverageId = function _ShieldController_getLatestCoverageId(itemId) {
    return this.state.coverageResults[itemId]?.results[0]?.coverageId;
};

      };
    };
  }
  }
}, {package:"@metamask/shield-controller",file:"node_modules\\@metamask\\shield-controller\\dist\\ShieldController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\shield-controller\\dist\\backend.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cshield-controller%5Cdist%5Cbackend.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _ShieldRemoteBackend_instances, _ShieldRemoteBackend_getAccessToken, _ShieldRemoteBackend_getCoverageResultTimeout, _ShieldRemoteBackend_getCoverageResultPollInterval, _ShieldRemoteBackend_baseUrl, _ShieldRemoteBackend_fetch, _ShieldRemoteBackend_initCoverageCheck, _ShieldRemoteBackend_getCoverageResult, _ShieldRemoteBackend_createHeaders;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShieldRemoteBackend = void 0;
class ShieldRemoteBackend {
    constructor({ getAccessToken, getCoverageResultTimeout = 5000, // milliseconds
    getCoverageResultPollInterval = 1000, // milliseconds
    baseUrl, fetch: fetchFn, }) {
        _ShieldRemoteBackend_instances.add(this);
        _ShieldRemoteBackend_getAccessToken.set(this, void 0);
        _ShieldRemoteBackend_getCoverageResultTimeout.set(this, void 0);
        _ShieldRemoteBackend_getCoverageResultPollInterval.set(this, void 0);
        _ShieldRemoteBackend_baseUrl.set(this, void 0);
        _ShieldRemoteBackend_fetch.set(this, void 0);
        __classPrivateFieldSet(this, _ShieldRemoteBackend_getAccessToken, getAccessToken, "f");
        __classPrivateFieldSet(this, _ShieldRemoteBackend_getCoverageResultTimeout, getCoverageResultTimeout, "f");
        __classPrivateFieldSet(this, _ShieldRemoteBackend_getCoverageResultPollInterval, getCoverageResultPollInterval, "f");
        __classPrivateFieldSet(this, _ShieldRemoteBackend_baseUrl, baseUrl, "f");
        __classPrivateFieldSet(this, _ShieldRemoteBackend_fetch, fetchFn, "f");
    }
    async checkCoverage(req) {
        let { coverageId } = req;
        if (!coverageId) {
            const reqBody = makeInitCoverageCheckBody(req.txMeta);
            ({ coverageId } = await __classPrivateFieldGet(this, _ShieldRemoteBackend_instances, "m", _ShieldRemoteBackend_initCoverageCheck).call(this, 'v1/transaction/coverage/init', reqBody));
        }
        const txCoverageResultUrl = `${__classPrivateFieldGet(this, _ShieldRemoteBackend_baseUrl, "f")}/v1/transaction/coverage/result`;
        const coverageResult = await __classPrivateFieldGet(this, _ShieldRemoteBackend_instances, "m", _ShieldRemoteBackend_getCoverageResult).call(this, coverageId, {
            coverageResultUrl: txCoverageResultUrl,
        });
        return {
            coverageId,
            message: coverageResult.message,
            reasonCode: coverageResult.reasonCode,
            status: coverageResult.status,
        };
    }
    async checkSignatureCoverage(req) {
        let { coverageId } = req;
        if (!coverageId) {
            const reqBody = makeInitSignatureCoverageCheckBody(req.signatureRequest);
            ({ coverageId } = await __classPrivateFieldGet(this, _ShieldRemoteBackend_instances, "m", _ShieldRemoteBackend_initCoverageCheck).call(this, 'v1/signature/coverage/init', reqBody));
        }
        const signatureCoverageResultUrl = `${__classPrivateFieldGet(this, _ShieldRemoteBackend_baseUrl, "f")}/v1/signature/coverage/result`;
        const coverageResult = await __classPrivateFieldGet(this, _ShieldRemoteBackend_instances, "m", _ShieldRemoteBackend_getCoverageResult).call(this, coverageId, {
            coverageResultUrl: signatureCoverageResultUrl,
        });
        return {
            coverageId,
            message: coverageResult.message,
            reasonCode: coverageResult.reasonCode,
            status: coverageResult.status,
        };
    }
    async logSignature(req) {
        const initBody = makeInitSignatureCoverageCheckBody(req.signatureRequest);
        const body = {
            signature: req.signature,
            status: req.status,
            ...initBody,
        };
        const res = await __classPrivateFieldGet(this, _ShieldRemoteBackend_fetch, "f").call(this, `${__classPrivateFieldGet(this, _ShieldRemoteBackend_baseUrl, "f")}/v1/signature/coverage/log`, {
            method: 'POST',
            headers: await __classPrivateFieldGet(this, _ShieldRemoteBackend_instances, "m", _ShieldRemoteBackend_createHeaders).call(this),
            body: JSON.stringify(body),
        });
        if (res.status !== 200) {
            throw new Error(`Failed to log signature: ${res.status}`);
        }
    }
    async logTransaction(req) {
        const initBody = makeInitCoverageCheckBody(req.txMeta);
        const body = {
            transactionHash: req.transactionHash,
            status: req.status,
            ...initBody,
        };
        const res = await __classPrivateFieldGet(this, _ShieldRemoteBackend_fetch, "f").call(this, `${__classPrivateFieldGet(this, _ShieldRemoteBackend_baseUrl, "f")}/v1/transaction/coverage/log`, {
            method: 'POST',
            headers: await __classPrivateFieldGet(this, _ShieldRemoteBackend_instances, "m", _ShieldRemoteBackend_createHeaders).call(this),
            body: JSON.stringify(body),
        });
        if (res.status !== 200) {
            throw new Error(`Failed to log transaction: ${res.status}`);
        }
    }
}
exports.ShieldRemoteBackend = ShieldRemoteBackend;
_ShieldRemoteBackend_getAccessToken = new WeakMap(), _ShieldRemoteBackend_getCoverageResultTimeout = new WeakMap(), _ShieldRemoteBackend_getCoverageResultPollInterval = new WeakMap(), _ShieldRemoteBackend_baseUrl = new WeakMap(), _ShieldRemoteBackend_fetch = new WeakMap(), _ShieldRemoteBackend_instances = new WeakSet(), _ShieldRemoteBackend_initCoverageCheck = async function _ShieldRemoteBackend_initCoverageCheck(path, reqBody) {
    const res = await __classPrivateFieldGet(this, _ShieldRemoteBackend_fetch, "f").call(this, `${__classPrivateFieldGet(this, _ShieldRemoteBackend_baseUrl, "f")}/${path}`, {
        method: 'POST',
        headers: await __classPrivateFieldGet(this, _ShieldRemoteBackend_instances, "m", _ShieldRemoteBackend_createHeaders).call(this),
        body: JSON.stringify(reqBody),
    });
    if (res.status !== 200) {
        throw new Error(`Failed to init coverage check: ${res.status}`);
    }
    return (await res.json());
}, _ShieldRemoteBackend_getCoverageResult = async function _ShieldRemoteBackend_getCoverageResult(coverageId, configs) {
    const reqBody = {
        coverageId,
    };
    const timeout = configs?.timeout ?? __classPrivateFieldGet(this, _ShieldRemoteBackend_getCoverageResultTimeout, "f");
    const pollInterval = configs?.pollInterval ?? __classPrivateFieldGet(this, _ShieldRemoteBackend_getCoverageResultPollInterval, "f");
    const headers = await __classPrivateFieldGet(this, _ShieldRemoteBackend_instances, "m", _ShieldRemoteBackend_createHeaders).call(this);
    return await new Promise((resolve, reject) => {
        let timeoutReached = false;
        setTimeout(() => {
            timeoutReached = true;
            reject(new Error('Timeout waiting for coverage result'));
        }, timeout);
        const poll = async () => {
            // The timeoutReached variable is modified in the timeout callback.
            // eslint-disable-next-line no-unmodified-loop-condition
            while (!timeoutReached) {
                const startTime = Date.now();
                const res = await __classPrivateFieldGet(this, _ShieldRemoteBackend_fetch, "f").call(this, configs.coverageResultUrl, {
                    method: 'POST',
                    headers,
                    body: JSON.stringify(reqBody),
                });
                if (res.status === 200) {
                    return (await res.json());
                }
                await sleep(pollInterval - (Date.now() - startTime));
            }
            // The following line will not have an effect as the upper level promise
            // will already be rejected by now.
            throw new Error('unexpected error');
        };
        poll().then(resolve).catch(reject);
    });
}, _ShieldRemoteBackend_createHeaders = async function _ShieldRemoteBackend_createHeaders() {
    const accessToken = await __classPrivateFieldGet(this, _ShieldRemoteBackend_getAccessToken, "f").call(this);
    return {
        'Content-Type': 'application/json',
        Authorization: `Bearer ${accessToken}`,
    };
};
/**
 * Sleep for a specified amount of time.
 *
 * @param ms - The number of milliseconds to sleep.
 * @returns A promise that resolves after the specified amount of time.
 */
async function sleep(ms) {
    return new Promise((resolve) => setTimeout(resolve, ms));
}
/**
 * Make the body for the init coverage check request.
 *
 * @param txMeta - The transaction metadata.
 * @returns The body for the init coverage check request.
 */
function makeInitCoverageCheckBody(txMeta) {
    return {
        txParams: [
            {
                from: txMeta.txParams.from,
                to: txMeta.txParams.to,
                value: txMeta.txParams.value,
                data: txMeta.txParams.data,
                nonce: txMeta.txParams.nonce,
            },
        ],
        chainId: txMeta.chainId,
        origin: txMeta.origin,
    };
}
/**
 * Make the body for the init signature coverage check request.
 *
 * @param signatureRequest - The signature request.
 * @returns The body for the init signature coverage check request.
 */
function makeInitSignatureCoverageCheckBody(signatureRequest) {
    if (typeof signatureRequest.messageParams.data !== 'string') {
        throw new Error('Signature data must be a string');
    }
    return {
        chainId: signatureRequest.chainId,
        data: signatureRequest.messageParams.data,
        from: signatureRequest.messageParams.from,
        method: signatureRequest.type,
        origin: signatureRequest.messageParams.origin,
    };
}

      };
    };
  }
  }
}, {package:"@metamask/shield-controller",file:"node_modules\\@metamask\\shield-controller\\dist\\backend.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\shield-controller\\dist\\constants.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cshield-controller%5Cdist%5Cconstants.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.controllerName = void 0;
/**
 * The name of the {@link ShieldController}.
 */
exports.controllerName = 'ShieldController';

      };
    };
  }
  }
}, {package:"@metamask/shield-controller",file:"node_modules\\@metamask\\shield-controller\\dist\\constants.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\shield-controller\\dist\\index.cjs", {"./ShieldController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\shield-controller\\dist\\ShieldController.cjs","./backend.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\shield-controller\\dist\\backend.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cshield-controller%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShieldRemoteBackend = exports.getDefaultShieldControllerState = exports.ShieldController = void 0;
var ShieldController_1 = require("./ShieldController.cjs");
Object.defineProperty(exports, "ShieldController", { enumerable: true, get: function () { return ShieldController_1.ShieldController; } });
Object.defineProperty(exports, "getDefaultShieldControllerState", { enumerable: true, get: function () { return ShieldController_1.getDefaultShieldControllerState; } });
var backend_1 = require("./backend.cjs");
Object.defineProperty(exports, "ShieldRemoteBackend", { enumerable: true, get: function () { return backend_1.ShieldRemoteBackend; } });

      };
    };
  }
  }
}, {package:"@metamask/shield-controller",file:"node_modules\\@metamask\\shield-controller\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\shield-controller\\dist\\logger.cjs", {"./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\shield-controller\\dist\\constants.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cshield-controller%5Cdist%5Clogger.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createModuleLogger = exports.projectLogger = void 0;
const utils_1 = require("@metamask/utils");
Object.defineProperty(exports, "createModuleLogger", { enumerable: true, get: function () { return utils_1.createModuleLogger; } });
const constants_1 = require("./constants.cjs");
exports.projectLogger = (0, utils_1.createProjectLogger)(constants_1.controllerName);

      };
    };
  }
  }
}, {package:"@metamask/shield-controller",file:"node_modules\\@metamask\\shield-controller\\dist\\logger.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\cronjob\\CronjobController.cjs", {"../snaps/Timer.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\snaps\\Timer.cjs","../snaps/constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\snaps\\constants.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\cronjob\\utils.cjs","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/snaps-rpc-methods":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","immer":"D:\\code\\v\\metamask-extension\\node_modules\\immer\\dist\\index.js","luxon":"D:\\code\\v\\metamask-extension\\node_modules\\luxon\\build\\cjs-browser\\luxon.js","nanoid":"D:\\code\\v\\metamask-extension\\node_modules\\nanoid\\index.browser.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-controllers%5Cdist%5Ccronjob%5CCronjobController.cjs
      return function (require, module, exports) {
"use strict";

function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CronjobController = exports.DAILY_TIMEOUT = void 0;
const base_controller_1 = require("@metamask/base-controller");
const snaps_rpc_methods_1 = require("@metamask/snaps-rpc-methods");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
const immer_1 = require("immer");
const luxon_1 = require("luxon");
const nanoid_1 = require("nanoid");
const utils_2 = require("./utils.cjs");
const constants_1 = require("../snaps/constants.cjs");
const Timer_1 = require("../snaps/Timer.cjs");
exports.DAILY_TIMEOUT = (0, utils_1.inMilliseconds)(24, utils_1.Duration.Hour);
const controllerName = 'CronjobController';
/**
 * The cronjob controller is responsible for managing cronjobs and background
 * events for Snaps. It allows Snaps to schedule events that will be executed
 * at a later time.
 */
var _timers = /*#__PURE__*/new WeakMap();
var _stateManager = /*#__PURE__*/new WeakMap();
var _dailyTimer = /*#__PURE__*/new WeakMap();
var _CronjobController_brand = /*#__PURE__*/new WeakSet();
var _handleSnapInstalledEvent = /*#__PURE__*/new WeakMap();
var _handleSnapEnabledEvent = /*#__PURE__*/new WeakMap();
var _handleSnapUninstalledEvent = /*#__PURE__*/new WeakMap();
var _handleSnapDisabledEvent = /*#__PURE__*/new WeakMap();
var _handleSnapUpdatedEvent = /*#__PURE__*/new WeakMap();
class CronjobController extends base_controller_1.BaseController {
  constructor({
    messenger,
    state: _state,
    stateManager
  }) {
    super({
      messenger,
      metadata: {
        events: {
          includeInStateLogs: false,
          persist: false,
          anonymous: false,
          usedInUi: false
        }
      },
      name: controllerName,
      state: {
        events: {},
        ..._state,
        ...stateManager.getInitialState()
      }
    });
    /**
     * Start the daily timer that will reschedule events every 24 hours.
     */
    _classPrivateMethodInitSpec(this, _CronjobController_brand);
    _classPrivateFieldInitSpec(this, _timers, void 0);
    _classPrivateFieldInitSpec(this, _stateManager, void 0);
    _classPrivateFieldInitSpec(this, _dailyTimer, new Timer_1.Timer(exports.DAILY_TIMEOUT));
    /**
     * Handle events that should cause cron jobs to be registered.
     *
     * @param snap - Basic Snap information.
     */
    _classPrivateFieldInitSpec(this, _handleSnapInstalledEvent, snap => {
      // In case of local Snaps, they may already have cronjobs that should be cleared.
      this.unregister(snap.id);
      this.register(snap.id);
    });
    /**
     * Handle the Snap enabled event. This checks if the Snap has any cronjobs or
     * background events that need to be rescheduled.
     *
     * @param snap - Basic Snap information.
     */
    _classPrivateFieldInitSpec(this, _handleSnapEnabledEvent, snap => {
      const events = this.get(snap.id);
      _assertClassBrand(_CronjobController_brand, this, _reschedule).call(this, events);
      this.register(snap.id);
    });
    /**
     * Handle events that should cause cronjobs and background events to be
     * unregistered.
     *
     * @param snap - Basic Snap information.
     */
    _classPrivateFieldInitSpec(this, _handleSnapUninstalledEvent, snap => {
      this.unregister(snap.id);
    });
    /**
     * Handle events that should cause cronjobs and background events to be
     * unregistered.
     *
     * @param snap - Basic Snap information.
     */
    _classPrivateFieldInitSpec(this, _handleSnapDisabledEvent, snap => {
      this.unregister(snap.id);
    });
    /**
     * Handle cron jobs on 'snapUpdated' event.
     *
     * @param snap - Basic Snap information.
     */
    _classPrivateFieldInitSpec(this, _handleSnapUpdatedEvent, snap => {
      this.unregister(snap.id);
      this.register(snap.id);
    });
    _classPrivateFieldSet(_timers, this, new Map());
    _classPrivateFieldSet(_stateManager, this, stateManager);
    this.messagingSystem.subscribe('SnapController:snapInstalled', _classPrivateFieldGet(_handleSnapInstalledEvent, this));
    this.messagingSystem.subscribe('SnapController:snapUninstalled', _classPrivateFieldGet(_handleSnapUninstalledEvent, this));
    this.messagingSystem.subscribe('SnapController:snapEnabled', _classPrivateFieldGet(_handleSnapEnabledEvent, this));
    this.messagingSystem.subscribe('SnapController:snapDisabled', _classPrivateFieldGet(_handleSnapDisabledEvent, this));
    this.messagingSystem.subscribe('SnapController:snapUpdated', _classPrivateFieldGet(_handleSnapUpdatedEvent, this));
    this.messagingSystem.registerActionHandler(`${controllerName}:init`, (...args) => this.init(...args));
    this.messagingSystem.registerActionHandler(`${controllerName}:schedule`, (...args) => this.schedule(...args));
    this.messagingSystem.registerActionHandler(`${controllerName}:cancel`, (...args) => this.cancel(...args));
    this.messagingSystem.registerActionHandler(`${controllerName}:get`, (...args) => this.get(...args));
  }
  /**
   * Initialize the CronjobController.
   *
   * This starts the daily timer, clears out expired events
   * and reschedules any remaining events.
   */
  init() {
    _assertClassBrand(_CronjobController_brand, this, _start).call(this);
    _assertClassBrand(_CronjobController_brand, this, _clear).call(this);
    _assertClassBrand(_CronjobController_brand, this, _reschedule).call(this);
  }
  /**
   * Schedule a non-recurring background event.
   *
   * @param event - The event to schedule.
   * @returns The ID of the scheduled event.
   */
  schedule(event) {
    return _assertClassBrand(_CronjobController_brand, this, _add).call(this, {
      ...event,
      recurring: false
    });
  }
  /**
   * Cancel an event.
   *
   * @param origin - The origin making the cancel call.
   * @param id - The id of the event to cancel.
   * @throws If the event does not exist.
   */
  cancel(origin, id) {
    (0, utils_1.assert)(this.state.events[id], `A background event with the id of "${id}" does not exist.`);
    (0, utils_1.assert)(this.state.events[id].snapId === origin, 'Only the origin that scheduled this event can cancel it.');
    _assertClassBrand(_CronjobController_brand, this, _cancel).call(this, id);
  }
  /**
   * Get a list of a Snap's background events.
   *
   * @param snapId - The id of the Snap to fetch background events for.
   * @returns An array of background events.
   */
  get(snapId) {
    return Object.values(this.state.events).filter(snapEvent => snapEvent.snapId === snapId && !snapEvent.recurring).map(event => ({
      ...event,
      date: (0, snaps_utils_1.toCensoredISO8601String)(event.date),
      scheduledAt: (0, snaps_utils_1.toCensoredISO8601String)(event.scheduledAt)
    }));
  }
  /**
   * Register cronjobs for a given Snap by getting specification from the
   * permission caveats. Once registered, each job will be scheduled.
   *
   * @param snapId - The snap ID to register jobs for.
   */
  register(snapId) {
    const jobs = _assertClassBrand(_CronjobController_brand, this, _getSnapCronjobs).call(this, snapId);
    jobs === null || jobs === void 0 || jobs.forEach(job => _assertClassBrand(_CronjobController_brand, this, _add).call(this, job));
  }
  /**
   * Unregister all cronjobs and background events for a given Snap.
   *
   * @param snapId - ID of a snap.
   */
  unregister(snapId) {
    for (const [id, event] of Object.entries(this.state.events)) {
      if (event.snapId === snapId) {
        _assertClassBrand(_CronjobController_brand, this, _cancel).call(this, id);
      }
    }
  }
  /**
   * Run controller teardown process and unsubscribe from Snap events.
   */
  destroy() {
    super.destroy();
    this.messagingSystem.unsubscribe('SnapController:snapInstalled', _classPrivateFieldGet(_handleSnapInstalledEvent, this));
    this.messagingSystem.unsubscribe('SnapController:snapUninstalled', _classPrivateFieldGet(_handleSnapUninstalledEvent, this));
    this.messagingSystem.unsubscribe('SnapController:snapEnabled', _classPrivateFieldGet(_handleSnapEnabledEvent, this));
    this.messagingSystem.unsubscribe('SnapController:snapDisabled', _classPrivateFieldGet(_handleSnapDisabledEvent, this));
    this.messagingSystem.unsubscribe('SnapController:snapUpdated', _classPrivateFieldGet(_handleSnapUpdatedEvent, this));
    // Cancel all timers and clear the map.
    _classPrivateFieldGet(_timers, this).forEach(timer => timer.cancel());
    _classPrivateFieldGet(_timers, this).clear();
    if (_classPrivateFieldGet(_dailyTimer, this).status === 'running') {
      _classPrivateFieldGet(_dailyTimer, this).cancel();
    }
  }
}
function _start() {
  _classPrivateFieldSet(_dailyTimer, this, new Timer_1.Timer(exports.DAILY_TIMEOUT));
  _classPrivateFieldGet(_dailyTimer, this).start(() => {
    _assertClassBrand(_CronjobController_brand, this, _reschedule).call(this);
    _assertClassBrand(_CronjobController_brand, this, _start).call(this);
  });
}
/**
 * Add a cronjob or background event to the controller state and schedule it
 * for execution.
 *
 * @param event - The event to schedule.
 * @returns The ID of the scheduled event.
 */
function _add(event) {
  const id = event.id ?? (0, nanoid_1.nanoid)();
  const internalEvent = {
    ...event,
    id,
    date: (0, utils_2.getExecutionDate)(event.schedule),
    scheduledAt: new Date().toISOString()
  };
  const {
    nextState
  } = this.update(state => {
    state.events[internalEvent.id] = (0, immer_1.castDraft)(internalEvent);
  });
  _classPrivateFieldGet(_stateManager, this).set(nextState);
  _assertClassBrand(_CronjobController_brand, this, _schedule).call(this, internalEvent);
  return id;
}
/**
 * Get the next execution date for a given event and start a timer for it.
 *
 * @param event - The event to schedule.
 * @param next - Whether to schedule to the next date, otherwise will
 * schedule for existing date.
 */
function _schedule(event, next = true) {
  if (!next) {
    _assertClassBrand(_CronjobController_brand, this, _startTimer).call(this, event);
    return;
  }
  const date = (0, utils_2.getExecutionDate)(event.schedule);
  const {
    nextState
  } = this.update(state => {
    state.events[event.id].date = date;
  });
  _classPrivateFieldGet(_stateManager, this).set(nextState);
  _assertClassBrand(_CronjobController_brand, this, _startTimer).call(this, {
    ...event,
    date
  });
}
/**
 * Set up and start a timer for the given event.
 *
 * @param event - The event to schedule.
 * @throws If the event is scheduled in the past.
 */
function _startTimer(event) {
  const ms = luxon_1.DateTime.fromISO(event.date, {
    setZone: true
  }).toMillis() - Date.now();
  // We don't schedule this job yet as it is too far in the future.
  if (ms > exports.DAILY_TIMEOUT) {
    return;
  }
  // When an event is supposed to be scheduled close to the current time
  // we may end up needing to execute immediately instead.
  if (ms <= 0) {
    _assertClassBrand(_CronjobController_brand, this, _execute).call(this, event);
    return;
  }
  const timer = new Timer_1.Timer(ms);
  timer.start(() => {
    _assertClassBrand(_CronjobController_brand, this, _execute).call(this, event);
  });
  _classPrivateFieldGet(_timers, this).set(event.id, timer);
}
/**
 * Execute a background event. This method is called when the event's timer
 * expires.
 *
 * If the event is not recurring, it will be removed from the state after
 * execution. If it is recurring, it will be rescheduled.
 *
 * @param event - The event to execute.
 */
function _execute(event) {
  this.messagingSystem.call('SnapController:handleRequest', {
    snapId: event.snapId,
    origin: constants_1.METAMASK_ORIGIN,
    handler: snaps_utils_1.HandlerType.OnCronjob,
    request: event.request
  }).catch(error => {
    (0, snaps_utils_1.logError)(`An error occurred while executing an event for Snap "${event.snapId}":`, error);
  });
  _classPrivateFieldGet(_timers, this).delete(event.id);
  // Non-recurring events are removed from the state after execution, and
  // recurring events are rescheduled.
  if (!event.recurring) {
    const {
      nextState
    } = this.update(state => {
      delete state.events[event.id];
    });
    _classPrivateFieldGet(_stateManager, this).set(nextState);
    return;
  }
  _assertClassBrand(_CronjobController_brand, this, _schedule).call(this, event);
}
/**
 * Cancel a background event by its ID. Unlike {@link cancel}, this method
 * does not check the origin of the event, so it can be used internally.
 *
 * @param id - The ID of the background event to cancel.
 */
function _cancel(id) {
  const timer = _classPrivateFieldGet(_timers, this).get(id);
  timer === null || timer === void 0 || timer.cancel();
  _classPrivateFieldGet(_timers, this).delete(id);
  const {
    nextState
  } = this.update(state => {
    delete state.events[id];
  });
  _classPrivateFieldGet(_stateManager, this).set(nextState);
}
/**
 * Retrieve all cronjob specifications for a Snap.
 *
 * @param snapId - ID of a Snap.
 * @returns Array of cronjob specifications.
 */
function _getSnapCronjobs(snapId) {
  const permissions = this.messagingSystem.call('PermissionController:getPermissions', snapId);
  const permission = permissions === null || permissions === void 0 ? void 0 : permissions[snaps_rpc_methods_1.SnapEndowments.Cronjob];
  const definitions = (0, snaps_rpc_methods_1.getCronjobCaveatJobs)(permission);
  if (!definitions) {
    return [];
  }
  return definitions.map((definition, idx) => {
    return {
      snapId,
      id: `cronjob-${snapId}-${idx}`,
      request: definition.request,
      schedule: (0, utils_2.getCronjobSpecificationSchedule)(definition),
      recurring: true
    };
  });
}
/**
 * Reschedule events that are yet to be executed. This should be called on
 * controller initialization and once every 24 hours to ensure that
 * background events are scheduled correctly.
 *
 * @param events - An array of events to reschedule. Defaults to all events in
 * the controller state.
 */
function _reschedule(events = Object.values(this.state.events)) {
  const now = Date.now();
  for (const event of events) {
    if (_classPrivateFieldGet(_timers, this).has(event.id)) {
      // If the timer for this event already exists, we don't need to
      // reschedule it.
      continue;
    }
    const eventDate = luxon_1.DateTime.fromISO(event.date, {
      setZone: true
    }).toUTC().toMillis();
    // If the event is recurring and the date is in the past, execute it
    // immediately.
    if (event.recurring && eventDate <= now) {
      _assertClassBrand(_CronjobController_brand, this, _execute).call(this, event);
      continue;
    }
    _assertClassBrand(_CronjobController_brand, this, _schedule).call(this, event, false);
  }
}
/**
 * Clear non-recurring events that are past their scheduled time.
 */
function _clear() {
  const now = Date.now();
  for (const event of Object.values(this.state.events)) {
    const eventDate = luxon_1.DateTime.fromISO(event.date, {
      setZone: true
    }).toUTC().toMillis();
    if (!event.recurring && eventDate < now) {
      _assertClassBrand(_CronjobController_brand, this, _cancel).call(this, event.id);
    }
  }
}
exports.CronjobController = CronjobController;

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers",file:"node_modules\\@metamask\\snaps-controllers\\dist\\cronjob\\CronjobController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\cronjob\\index.cjs", {"./CronjobController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\cronjob\\CronjobController.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-controllers%5Cdist%5Ccronjob%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
__exportStar(require("./CronjobController.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers",file:"node_modules\\@metamask\\snaps-controllers\\dist\\cronjob\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\cronjob\\utils.cjs", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","cron-parser":"D:\\code\\v\\metamask-extension\\node_modules\\cron-parser\\lib\\parser.js","luxon":"D:\\code\\v\\metamask-extension\\node_modules\\luxon\\build\\cjs-browser\\luxon.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-controllers%5Cdist%5Ccronjob%5Cutils.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExecutionDate = exports.getCronjobSpecificationSchedule = void 0;
const utils_1 = require("@metamask/utils");
const cron_parser_1 = require("cron-parser");
const luxon_1 = require("luxon");
/**
 * Get the schedule from a cronjob specification.
 *
 * This function assumes the cronjob specification is valid and contains
 * either a `duration` or an `expression` property.
 *
 * @param specification - The cronjob specification to extract the schedule
 * from.
 * @returns The schedule of the cronjob, which can be either an ISO 8601
 * duration or a cron expression.
 */
function getCronjobSpecificationSchedule(specification) {
  if ((0, utils_1.hasProperty)(specification, 'duration')) {
    return specification.duration;
  }
  return specification.expression;
}
exports.getCronjobSpecificationSchedule = getCronjobSpecificationSchedule;
/**
 * Get a duration with a minimum of 1 second. This function assumes the provided
 * duration is valid.
 *
 * @param duration - The duration to validate.
 * @returns The validated duration.
 */
function getDuration(duration) {
  if (duration.as('seconds') < 1) {
    return luxon_1.Duration.fromObject({
      seconds: 1
    });
  }
  return duration;
}
/**
 * Get the next execution date from a schedule, which should be either:
 *
 * - An ISO 8601 date string, or
 * - An ISO 8601 duration string, or
 * - A cron expression.
 *
 * @param schedule - The schedule of the event.
 * @returns The parsed ISO 8601 date at which the event should be executed.
 */
function getExecutionDate(schedule) {
  const date = luxon_1.DateTime.fromISO(schedule, {
    setZone: true
  });
  if (date.isValid) {
    const now = Date.now();
    // We round to the nearest second to avoid milliseconds in the output.
    const roundedDate = date.toUTC().startOf('second');
    if (roundedDate.toMillis() < now) {
      throw new Error('Cannot schedule an event in the past.');
    }
    return roundedDate.toISO({
      suppressMilliseconds: true
    });
  }
  const duration = luxon_1.Duration.fromISO(schedule);
  if (duration.isValid) {
    // This ensures the duration is at least 1 second.
    const validatedDuration = getDuration(duration);
    return luxon_1.DateTime.now().toUTC().plus(validatedDuration).toISO();
  }
  try {
    const parsed = (0, cron_parser_1.parseExpression)(schedule, {
      utc: true
    });
    const next = parsed.next();
    const nextDate = luxon_1.DateTime.fromJSDate(next.toDate());
    (0, utils_1.assert)(nextDate.isValid);
    return nextDate.toUTC().toISO();
  } catch {
    throw new Error(`Unable to parse "${schedule}" as ISO 8601 date, ISO 8601 duration, or cron expression.`);
  }
}
exports.getExecutionDate = getExecutionDate;

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers",file:"node_modules\\@metamask\\snaps-controllers\\dist\\cronjob\\utils.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\fsm.cjs", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","@xstate/fsm":"D:\\code\\v\\metamask-extension\\node_modules\\@xstate\\fsm\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-controllers%5Cdist%5Cfsm.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.forceStrict = exports.validateMachine = void 0;
const utils_1 = require("@metamask/utils");
const fsm_1 = require("@xstate/fsm");
/**
 * Validates the set-up of a @xstate/fsm machine.
 *
 * 1. Ensures that all named actions in the config have a provided implementation.
 *
 * @param machine - The machine to validate.
 * @throws {@link AssertionError}. If the validation fails.
 */
function validateMachine(machine) {
  (0, utils_1.assert)('_options' in machine, 'The machine is not an @xstate/fsm machine');
  const typed = machine;
  // 1.
  const toArray = obj => {
    if (Array.isArray(obj)) {
      return obj;
    } else if (obj === undefined || obj === null) {
      return [];
    }
    return [obj];
  };
  const allActions = new Set();
  const addActions = actions => toArray(actions).flatMap(action => {
    if (typeof action === 'string') {
      return [action];
    }
    (0, utils_1.assert)(typeof action === 'function');
    return [];
  }).forEach(allActions.add.bind(allActions));
  for (const state of Object.values(typed.config.states)) {
    addActions(state.entry);
    addActions(state.exit);
    for (const transition of Object.values(state.on ?? {})) {
      addActions(transition.actions);
    }
  }
  allActions.forEach(action => (0, utils_1.assert)(typed._options.actions !== undefined && action in typed._options.actions, `Action "${action}" doesn't have an implementation`));
}
exports.validateMachine = validateMachine;
/**
 * Ensure that the interpreter is strict.
 * Strict means that the transition must occur.
 * The event must exist in .on {} state config and it's guard must succeed.
 *
 * The error will be thrown when an invalid `interpreter.send()` is called
 * and will be bubbled there.
 *
 * TODO(ritave): Doesn't support self transitions.
 *
 * @param interpreter - The interpreter that will be force into strict mode.
 * @throws {@link Error} Thrown when the transition is invalid.
 */
function forceStrict(interpreter) {
  // As soon as a listener subscribes, it is called. It might be called in
  // an initial state which doesn't have the .changed property
  let onInitialCalled = false;
  interpreter.subscribe(state => {
    (0, utils_1.assert)(!onInitialCalled || state.changed, 'Invalid state transition');
    onInitialCalled = true;
  });
  const ogSend = interpreter.send.bind(interpreter);
  interpreter.send = (...args) => {
    (0, utils_1.assert)(interpreter.status === fsm_1.InterpreterStatus.Running, 'Interpreter is stopped');
    return ogSend(...args);
  };
}
exports.forceStrict = forceStrict;

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers",file:"node_modules\\@metamask\\snaps-controllers\\dist\\fsm.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\index.cjs", {"./cronjob/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\cronjob\\index.cjs","./insights/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\insights\\index.cjs","./interface/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\interface\\index.cjs","./multichain/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\multichain\\index.cjs","./services/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\services\\index.cjs","./snaps/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\snaps\\index.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\utils.cjs","./websocket/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\websocket\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-controllers%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
__exportStar(require("./services/index.cjs"), exports);
__exportStar(require("./snaps/index.cjs"), exports);
__exportStar(require("./utils.cjs"), exports);
__exportStar(require("./cronjob/index.cjs"), exports);
__exportStar(require("./interface/index.cjs"), exports);
__exportStar(require("./insights/index.cjs"), exports);
__exportStar(require("./multichain/index.cjs"), exports);
__exportStar(require("./websocket/index.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers",file:"node_modules\\@metamask\\snaps-controllers\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\insights\\SnapInsightsController.cjs", {"../snaps/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\snaps\\index.cjs","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/snaps-rpc-methods":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-controllers%5Cdist%5Cinsights%5CSnapInsightsController.cjs
      return function (require, module, exports) {
"use strict";

function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapInsightsController = void 0;
const base_controller_1 = require("@metamask/base-controller");
const snaps_rpc_methods_1 = require("@metamask/snaps-rpc-methods");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
const snaps_1 = require("../snaps/index.cjs");
const controllerName = 'SnapInsightsController';
/**
 * Controller for monitoring for new transactions and signatures to provide insight for.
 */
var _SnapInsightsController_brand = /*#__PURE__*/new WeakSet();
class SnapInsightsController extends base_controller_1.BaseController {
  constructor({
    messenger,
    state: _state
  }) {
    super({
      messenger,
      metadata: {
        insights: {
          includeInStateLogs: true,
          persist: false,
          anonymous: false,
          usedInUi: true
        }
      },
      name: controllerName,
      state: {
        insights: {},
        ..._state
      }
    });
    /**
     * Check if an insight already exists for a given ID.
     *
     * @param id - The ID.
     * @returns True if the insight already exists, otherwise false.
     */
    _classPrivateMethodInitSpec(this, _SnapInsightsController_brand);
    this.messagingSystem.subscribe('TransactionController:unapprovedTransactionAdded', _assertClassBrand(_SnapInsightsController_brand, this, _handleTransaction).bind(this));
    this.messagingSystem.subscribe('TransactionController:transactionStatusUpdated', _assertClassBrand(_SnapInsightsController_brand, this, _handleTransactionStatusUpdate).bind(this));
    this.messagingSystem.subscribe('SignatureController:stateChange', _assertClassBrand(_SnapInsightsController_brand, this, _handleSignatureStateChange).bind(this));
  }
}
function _hasInsight(id) {
  return (0, utils_1.hasProperty)(this.state.insights, id);
}
/**
 * Get a list of runnable Snaps that have a given permission.
 * Also includes the permission object itself.
 *
 * @param permissionName - The permission name.
 * @returns A list of objects containing Snap IDs and the permission object.
 */
function _getSnapsWithPermission(permissionName) {
  const allSnaps = this.messagingSystem.call('SnapController:getAll');
  const filteredSnaps = (0, snaps_1.getRunnableSnaps)(allSnaps);
  return filteredSnaps.reduce((accumulator, snap) => {
    const permissions = this.messagingSystem.call('PermissionController:getPermissions', snap.id);
    if (permissions && (0, utils_1.hasProperty)(permissions, permissionName)) {
      accumulator.push({
        snapId: snap.id,
        permission: permissions[permissionName]
      });
    }
    return accumulator;
  }, []);
}
/**
 * Handle a newly added unapproved transaction.
 * This function fetches insights from all available Snaps
 * and populates the insights state blob with the responses.
 *
 * @param transaction - The transaction object.
 */
function _handleTransaction(transaction) {
  const {
    id,
    txParams,
    chainId,
    origin
  } = transaction;
  // This assumes that the transactions are EVM-compatible for now.
  const caipChainId = `eip155:${(0, utils_1.hexToBigInt)(chainId).toString(10)}`;
  const snaps = _assertClassBrand(_SnapInsightsController_brand, this, _getSnapsWithPermission).call(this, snaps_rpc_methods_1.SnapEndowments.TransactionInsight);
  snaps.forEach(({
    snapId,
    permission
  }) => {
    const hasTransactionOriginCaveat = (0, snaps_rpc_methods_1.getTransactionOriginCaveat)(permission);
    const transactionOrigin = hasTransactionOriginCaveat && origin ? origin : null;
    this.update(state => {
      var _state$insights;
      (_state$insights = state.insights)[id] ?? (_state$insights[id] = {});
      state.insights[id][snapId] = {
        snapId,
        loading: true
      };
    });
    _assertClassBrand(_SnapInsightsController_brand, this, _handleSnapRequest).call(this, {
      snapId,
      handler: snaps_utils_1.HandlerType.OnTransaction,
      params: {
        transaction: txParams,
        chainId: caipChainId,
        transactionOrigin
      }
    }).then(response => _assertClassBrand(_SnapInsightsController_brand, this, _handleSnapResponse).call(this, {
      id,
      snapId,
      response: response
    })).catch(error => _assertClassBrand(_SnapInsightsController_brand, this, _handleSnapResponse).call(this, {
      id,
      snapId,
      error
    }));
  });
}
/**
 * Handle the stateChange event emitted by the SignatureController.
 * This function will remove existing insights from the state when applicable, as well as
 * trigger insight fetching for newly added signatures.
 *
 * @param state - The SignatureController state blob.
 */
function _handleSignatureStateChange(state) {
  // If any IDs have disappeared since the last state update, the insight may be cleaned up.
  for (const id of Object.keys(this.state.insights)) {
    if (!(0, utils_1.hasProperty)(state.unapprovedTypedMessages, id) && !(0, utils_1.hasProperty)(state.unapprovedPersonalMsgs, id)) {
      _assertClassBrand(_SnapInsightsController_brand, this, _handleInsightCleanup).call(this, id);
    }
  }
  if (state.unapprovedPersonalMsgCount > 0 || state.unapprovedTypedMessagesCount > 0) {
    const snaps = _assertClassBrand(_SnapInsightsController_brand, this, _getSnapsWithPermission).call(this, snaps_rpc_methods_1.SnapEndowments.SignatureInsight);
    // This isn't very efficient, but SignatureController doesn't expose a better event for us to use yet.
    for (const personalSignature of Object.values(state.unapprovedPersonalMsgs)) {
      _assertClassBrand(_SnapInsightsController_brand, this, _handleSignature).call(this, snaps, personalSignature);
    }
    for (const typedMessage of Object.values(state.unapprovedTypedMessages)) {
      _assertClassBrand(_SnapInsightsController_brand, this, _handleSignature).call(this, snaps, typedMessage);
    }
  }
}
/**
 * Handle a newly added unapproved signature.
 * This function fetches insights from all available Snaps
 * and populates the insights state blob with the responses.
 *
 * @param snaps - A list of Snaps to invoke.
 * @param signature - The signature object.
 */
function _handleSignature(snaps, signature) {
  const {
    id,
    msgParams
  } = signature;
  if (_assertClassBrand(_SnapInsightsController_brand, this, _hasInsight).call(this, id)) {
    return;
  }
  const {
    from,
    data,
    signatureMethod,
    origin
  } = msgParams;
  /**
   * Both eth_signTypedData_v3 and eth_signTypedData_v4 methods
   * need to be parsed because their data is stringified. All other
   * signature methods do not, so they are ignored.
   */
  const shouldParse = signatureMethod === 'eth_signTypedData_v3' || signatureMethod === 'eth_signTypedData_v4';
  const payload = {
    from,
    data: shouldParse ? JSON.parse(data) : data,
    signatureMethod
  };
  snaps.forEach(({
    snapId,
    permission
  }) => {
    const hasSignatureOriginCaveat = (0, snaps_rpc_methods_1.getSignatureOriginCaveat)(permission);
    const signatureOrigin = origin && hasSignatureOriginCaveat ? origin : null;
    this.update(state => {
      var _state$insights2;
      (_state$insights2 = state.insights)[id] ?? (_state$insights2[id] = {});
      state.insights[id][snapId] = {
        snapId,
        loading: true
      };
    });
    _assertClassBrand(_SnapInsightsController_brand, this, _handleSnapRequest).call(this, {
      snapId,
      handler: snaps_utils_1.HandlerType.OnSignature,
      params: {
        signature: payload,
        signatureOrigin
      }
    }).then(response => _assertClassBrand(_SnapInsightsController_brand, this, _handleSnapResponse).call(this, {
      id,
      snapId,
      response: response
    })).catch(error => _assertClassBrand(_SnapInsightsController_brand, this, _handleSnapResponse).call(this, {
      id,
      snapId,
      error
    }));
  });
}
/**
 * Handle the transactionStatusUpdated event emitted by the TransactionController.
 * This function will remove insights for the transaction in question
 * once the transaction status has changed from unapproved.
 *
 * @param args - An options bag.
 * @param args.transactionMeta - The transaction.
 */
function _handleTransactionStatusUpdate({
  transactionMeta
}) {
  if (transactionMeta.status !== 'unapproved') {
    _assertClassBrand(_SnapInsightsController_brand, this, _handleInsightCleanup).call(this, transactionMeta.id);
  }
}
function _handleInsightCleanup(id) {
  if (!_assertClassBrand(_SnapInsightsController_brand, this, _hasInsight).call(this, id)) {
    return;
  }
  // Delete interfaces from interface controller.
  Object.values(this.state.insights[id]).filter(insight => insight.interfaceId).forEach(insight => {
    this.messagingSystem.call('SnapInterfaceController:deleteInterface', insight.interfaceId);
  });
  this.update(state => {
    delete state.insights[id];
  });
}
/**
 * Handle sending a request to a given Snap with a given payload.
 *
 * @param args - An options bag.
 * @param args.snapId - The Snap ID.
 * @param args.handler - The handler to invoke.
 * @param args.params - The JSON-RPC params to send.
 * @returns The response from the Snap.
 */
async function _handleSnapRequest({
  snapId,
  handler,
  params
}) {
  return this.messagingSystem.call('SnapController:handleRequest', {
    snapId,
    origin: 'metamask',
    handler,
    request: {
      method: '',
      params
    }
  });
}
/**
 * Handle response from a given Snap by persisting the response or error in state.
 *
 * @param args - An options bag.
 * @param args.id - The transaction or signature ID.
 * @param args.snapId - The Snap ID.
 * @param args.response - An optional response object returned by the Snap.
 * @param args.error - An optional error returned by the Snap.
 */
function _handleSnapResponse({
  id,
  snapId,
  response,
  error
}) {
  // If the insight has been cleaned up already, we can skip setting the state.
  // This may happen if a user accepts/rejects a transaction/signature faster than the Snap responds.
  if (!_assertClassBrand(_SnapInsightsController_brand, this, _hasInsight).call(this, id)) {
    return;
  }
  this.update(state => {
    state.insights[id][snapId].loading = false;
    state.insights[id][snapId].interfaceId = response === null || response === void 0 ? void 0 : response.id;
    state.insights[id][snapId].severity = response === null || response === void 0 ? void 0 : response.severity;
    state.insights[id][snapId].error = error === null || error === void 0 ? void 0 : error.message;
  });
}
exports.SnapInsightsController = SnapInsightsController;

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers",file:"node_modules\\@metamask\\snaps-controllers\\dist\\insights\\SnapInsightsController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\insights\\index.cjs", {"./SnapInsightsController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\insights\\SnapInsightsController.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-controllers%5Cdist%5Cinsights%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
__exportStar(require("./SnapInsightsController.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers",file:"node_modules\\@metamask\\snaps-controllers\\dist\\insights\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\interface\\SnapInterfaceController.cjs", {"./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\interface\\utils.cjs","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/snaps-sdk":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","immer":"D:\\code\\v\\metamask-extension\\node_modules\\immer\\dist\\index.js","nanoid":"D:\\code\\v\\metamask-extension\\node_modules\\nanoid\\index.browser.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-controllers%5Cdist%5Cinterface%5CSnapInterfaceController.cjs
      return function (require, module, exports) {
"use strict";

function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapInterfaceController = void 0;
const base_controller_1 = require("@metamask/base-controller");
const snaps_sdk_1 = require("@metamask/snaps-sdk");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
const immer_1 = require("immer");
const nanoid_1 = require("nanoid");
const utils_2 = require("./utils.cjs");
const MAX_UI_CONTENT_SIZE = 10000000; // 10 mb
const controllerName = 'SnapInterfaceController';
/**
 * Use this controller to manage snaps UI interfaces using RPC method hooks.
 */
var _SnapInterfaceController_brand = /*#__PURE__*/new WeakSet();
class SnapInterfaceController extends base_controller_1.BaseController {
  constructor({
    messenger,
    state: _state
  }) {
    super({
      messenger,
      metadata: {
        interfaces: {
          includeInStateLogs: true,
          persist: interfaces => {
            return Object.entries(interfaces).reduce((persistedInterfaces, [id, snapInterface]) => {
              switch (snapInterface.contentType) {
                case snaps_sdk_1.ContentType.Notification:
                  persistedInterfaces[id] = snapInterface;
                  return persistedInterfaces;
                default:
                  return persistedInterfaces;
              }
            }, {});
          },
          anonymous: false,
          usedInUi: true
        }
      },
      name: controllerName,
      state: {
        interfaces: {},
        ..._state
      }
    });
    /**
     * Constructor helper for registering this controller's messaging system
     * actions.
     */
    _classPrivateMethodInitSpec(this, _SnapInterfaceController_brand);
    this.messagingSystem.subscribe('NotificationServicesController:notificationsListUpdated', _assertClassBrand(_SnapInterfaceController_brand, this, _onNotificationsListUpdated).bind(this));
    _assertClassBrand(_SnapInterfaceController_brand, this, _registerMessageHandlers).call(this);
  }
  /**
   * Create an interface in the controller state with the associated data.
   *
   * @param snapId - The snap id that created the interface.
   * @param content - The interface content.
   * @param context - An optional interface context object.
   * @param contentType - The type of content.
   * @returns The newly interface id.
   */
  createInterface(snapId, content, context, contentType) {
    const element = (0, utils_2.getJsxInterface)(content);
    _assertClassBrand(_SnapInterfaceController_brand, this, _validateContent).call(this, element);
    (0, utils_2.validateInterfaceContext)(context);
    const id = (0, nanoid_1.nanoid)();
    const componentState = (0, utils_2.constructState)({}, element, {
      getAssetsState: _assertClassBrand(_SnapInterfaceController_brand, this, _getAssetsState).bind(this),
      getAccountByAddress: _assertClassBrand(_SnapInterfaceController_brand, this, _getAccountByAddress).bind(this),
      getSelectedAccount: _assertClassBrand(_SnapInterfaceController_brand, this, _getSelectedAccount).bind(this),
      listAccounts: _assertClassBrand(_SnapInterfaceController_brand, this, _listAccounts).bind(this),
      snapOwnsAccount: account => (0, snaps_utils_1.snapOwnsAccount)(snapId, account)
    });
    this.update(draftState => {
      // @ts-expect-error - TS2589: Type instantiation is excessively deep and
      // possibly infinite.
      draftState.interfaces[id] = {
        snapId,
        content: (0, immer_1.castDraft)(element),
        state: componentState,
        context: context ?? null,
        contentType: contentType ?? null
      };
    });
    return id;
  }
  /**
   * Get the data of a given interface id.
   *
   * @param snapId - The snap id requesting the interface data.
   * @param id - The interface id.
   * @returns The interface state.
   */
  getInterface(snapId, id) {
    _assertClassBrand(_SnapInterfaceController_brand, this, _validateArgs).call(this, snapId, id);
    return this.state.interfaces[id];
  }
  /**
   * Update the interface with the given content.
   *
   * @param snapId - The snap id requesting the update.
   * @param id - The interface id.
   * @param content - The new content.
   * @param context - An optional interface context object.
   */
  updateInterface(snapId, id, content, context) {
    _assertClassBrand(_SnapInterfaceController_brand, this, _validateArgs).call(this, snapId, id);
    const element = (0, utils_2.getJsxInterface)(content);
    _assertClassBrand(_SnapInterfaceController_brand, this, _validateContent).call(this, element);
    (0, utils_2.validateInterfaceContext)(context);
    const oldState = this.state.interfaces[id].state;
    const newState = (0, utils_2.constructState)(oldState, element, {
      getAssetsState: _assertClassBrand(_SnapInterfaceController_brand, this, _getAssetsState).bind(this),
      getAccountByAddress: _assertClassBrand(_SnapInterfaceController_brand, this, _getAccountByAddress).bind(this),
      getSelectedAccount: _assertClassBrand(_SnapInterfaceController_brand, this, _getSelectedAccount).bind(this),
      listAccounts: _assertClassBrand(_SnapInterfaceController_brand, this, _listAccounts).bind(this),
      snapOwnsAccount: account => (0, snaps_utils_1.snapOwnsAccount)(snapId, account)
    });
    this.update(draftState => {
      draftState.interfaces[id].state = newState;
      draftState.interfaces[id].content = (0, immer_1.castDraft)(element);
      if (context) {
        draftState.interfaces[id].context = context;
      }
    });
  }
  /**
   * Delete an interface from state.
   *
   * @param id - The interface id.
   */
  deleteInterface(id) {
    this.update(draftState => {
      delete draftState.interfaces[id];
    });
  }
  /**
   * Update the interface state.
   *
   * @param id - The interface id.
   * @param state - The new state.
   */
  updateInterfaceState(id, state) {
    this.update(draftState => {
      draftState.interfaces[id].state = state;
    });
  }
  /**
   * Resolve the promise of a given interface approval request.
   * The approval needs to have the same ID as the interface.
   *
   * @param snapId - The snap id.
   * @param id - The interface id.
   * @param value - The value to resolve the promise with.
   */
  async resolveInterface(snapId, id, value) {
    _assertClassBrand(_SnapInterfaceController_brand, this, _validateArgs).call(this, snapId, id);
    _assertClassBrand(_SnapInterfaceController_brand, this, _validateApproval).call(this, id);
    await _assertClassBrand(_SnapInterfaceController_brand, this, _acceptApprovalRequest).call(this, id, value);
    this.deleteInterface(id);
  }
  /**
   * Utility function to validate the args passed to the other methods.
   *
   * @param snapId - The snap id.
   * @param id - The interface id.
   */
}
function _registerMessageHandlers() {
  this.messagingSystem.registerActionHandler(`${controllerName}:createInterface`, this.createInterface.bind(this));
  this.messagingSystem.registerActionHandler(`${controllerName}:getInterface`, this.getInterface.bind(this));
  this.messagingSystem.registerActionHandler(`${controllerName}:updateInterface`, this.updateInterface.bind(this));
  this.messagingSystem.registerActionHandler(`${controllerName}:deleteInterface`, this.deleteInterface.bind(this));
  this.messagingSystem.registerActionHandler(`${controllerName}:updateInterfaceState`, this.updateInterfaceState.bind(this));
  this.messagingSystem.registerActionHandler(`${controllerName}:resolveInterface`, this.resolveInterface.bind(this));
}
function _validateArgs(snapId, id) {
  const existingInterface = this.state.interfaces[id];
  (0, utils_1.assert)(existingInterface !== undefined, `Interface with id '${id}' not found.`);
  (0, utils_1.assert)(existingInterface.snapId === snapId, `Interface not created by ${snapId}.`);
}
/**
 * Utility function to validate that the approval request exists.
 *
 * @param id - The interface id.
 */
function _validateApproval(id) {
  (0, utils_1.assert)(_assertClassBrand(_SnapInterfaceController_brand, this, _hasApprovalRequest).call(this, id), `Approval request with id '${id}' not found.`);
}
/**
 * Check an origin against the phishing list.
 *
 * @param origin - The origin to check.
 * @returns True if the origin is on the phishing list, otherwise false.
 */
function _checkPhishingList(origin) {
  return this.messagingSystem.call('PhishingController:testOrigin', origin).result;
}
/**
 * Check if an approval request exists for a given interface by looking up
 * if the ApprovalController has a request with the given interface ID.
 *
 * @param id - The interface id.
 * @returns True if an approval request exists, otherwise false.
 */
function _hasApprovalRequest(id) {
  return this.messagingSystem.call('ApprovalController:hasRequest', {
    id
  });
}
/**
 * Accept an approval request for a given interface.
 *
 * @param id - The interface id.
 * @param value - The value to resolve the promise with.
 */
async function _acceptApprovalRequest(id, value) {
  await this.messagingSystem.call('ApprovalController:acceptRequest', id, value);
}
/**
 * Get the selected account in the client.
 *
 * @returns The selected account.
 */
function _getSelectedAccount() {
  return this.messagingSystem.call('AccountsController:getSelectedMultichainAccount');
}
/**
 * Get a list of accounts for the given chain IDs.
 *
 * @param chainIds - The chain IDs to get the accounts for.
 * @returns The list of accounts.
 */
function _listAccounts(chainIds) {
  const accounts = this.messagingSystem.call('AccountsController:listMultichainAccounts');
  if (!chainIds || chainIds.length === 0) {
    return accounts;
  }
  return accounts.filter(account => account.scopes.some(scope => (0, utils_2.isMatchingChainId)(scope, chainIds)));
}
/**
 * Get an account by its address.
 *
 * @param address - The account address.
 * @returns The account or undefined if not found.
 */
function _getAccountByAddress(address) {
  const {
    address: parsedAddress
  } = (0, utils_1.parseCaipAccountId)(address);
  return this.messagingSystem.call('AccountsController:getAccountByAddress', parsedAddress);
}
/**
 * Get the MultichainAssetsController state.
 *
 * @returns The MultichainAssetsController state.
 */
function _getAssetsState() {
  return this.messagingSystem.call('MultichainAssetsController:getState');
}
/**
 * Get a snap by its id.
 *
 * @param id - The snap id.
 * @returns The snap.
 */
function _getSnap(id) {
  return this.messagingSystem.call('SnapController:get', id);
}
/**
 * Utility function to validate the components of an interface.
 * Throws if something is invalid.
 *
 * @param element - The JSX element to verify.
 */
function _validateContent(element) {
  // We assume the validity of this JSON to be validated by the caller.
  // E.g., in the RPC method implementation.
  const size = (0, snaps_utils_1.getJsonSizeUnsafe)(element);
  (0, utils_1.assert)(size <= MAX_UI_CONTENT_SIZE, `A Snap UI may not be larger than ${MAX_UI_CONTENT_SIZE / 1000000} MB.`);
  (0, snaps_utils_1.validateJsxElements)(element, {
    isOnPhishingList: _assertClassBrand(_SnapInterfaceController_brand, this, _checkPhishingList).bind(this),
    getSnap: _assertClassBrand(_SnapInterfaceController_brand, this, _getSnap).bind(this),
    getAccountByAddress: _assertClassBrand(_SnapInterfaceController_brand, this, _getAccountByAddress).bind(this)
  });
}
function _onNotificationsListUpdated(notificationsList) {
  const snapNotificationsWithInterface = notificationsList.filter(notification => {
    return notification.type === 'snap' && (0, utils_1.hasProperty)(notification.data, 'detailedView');
  });
  const interfaceIdSet = new Set(snapNotificationsWithInterface.map(notification => notification.data.detailedView.interfaceId));
  this.update(state => {
    Object.entries(state.interfaces).forEach(([id, snapInterface]) => {
      if (snapInterface.contentType === snaps_sdk_1.ContentType.Notification && !interfaceIdSet.has(id)) {
        delete state.interfaces[id];
      }
    });
  });
}
exports.SnapInterfaceController = SnapInterfaceController;

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers",file:"node_modules\\@metamask\\snaps-controllers\\dist\\interface\\SnapInterfaceController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\interface\\index.cjs", {"./SnapInterfaceController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\interface\\SnapInterfaceController.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-controllers%5Cdist%5Cinterface%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
__exportStar(require("./SnapInterfaceController.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers",file:"node_modules\\@metamask\\snaps-controllers\\dist\\interface\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\interface\\utils.cjs", {"@metamask/snaps-sdk":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\index.cjs","@metamask/snaps-sdk/jsx":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\jsx.js","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-controllers%5Cdist%5Cinterface%5Cutils.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateInterfaceContext = exports.constructState = exports.getAccountSelectorStateValue = exports.getAssetSelectorStateValue = exports.getAccountSelectorDefaultStateValue = exports.getDefaultAsset = exports.formatAccountSelectorStateValue = exports.isMatchingChainId = exports.assertNameIsUnique = exports.getJsxInterface = exports.isStatefulComponent = void 0;
const snaps_sdk_1 = require("@metamask/snaps-sdk");
const jsx_1 = require("@metamask/snaps-sdk/jsx");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
/**
 * A list of stateful component types.
 */
const STATEFUL_COMPONENT_TYPES = ['Input', 'Dropdown', 'RadioGroup', 'FileInput', 'Checkbox', 'Selector', 'AssetSelector', 'AddressInput', 'AccountSelector'];
/**
 * Check if a component is a stateful component.
 *
 * @param component - The component to check.
 * @param component.type - The type of the component.
 *
 * @returns Whether the component is a stateful component.
 */
function isStatefulComponent(component) {
  return STATEFUL_COMPONENT_TYPES.includes(component.type);
}
exports.isStatefulComponent = isStatefulComponent;
/**
 * Get a JSX element from a component or JSX element. If the component is a
 * JSX element, it is returned as is. Otherwise, the component is converted to
 * a JSX element.
 *
 * @param component - The component to convert.
 * @returns The JSX element.
 */
function getJsxInterface(component) {
  if ((0, jsx_1.isJSXElementUnsafe)(component)) {
    return component;
  }
  return (0, snaps_utils_1.getJsxElementFromComponent)(component);
}
exports.getJsxInterface = getJsxInterface;
/**
 * Assert that the component name is unique in state.
 *
 * @param state - The interface state to verify against.
 * @param name - The component name to verify.
 */
function assertNameIsUnique(state, name) {
  (0, snaps_sdk_1.assert)(state[name] === undefined, `Duplicate component names are not allowed, found multiple instances of: "${name}".`);
}
exports.assertNameIsUnique = assertNameIsUnique;
/**
 * Check if the chain ID matches the scope.
 * This function handles the case where a scope represents all EVM compatible chains.
 * In this case, it returns true if the chain ID is an EIP-155 chain ID.
 *
 * @param scope - The scope to check.
 * @param chainIds - The chain IDs to check against.
 * @returns Whether one of the chain ID matches the scope.
 */
function isMatchingChainId(scope, chainIds) {
  // if the scope represents all EVM compatible chains, return true if the namespace is EIP-155.
  if (scope === 'eip155:0') {
    return chainIds.some(chainId => {
      const {
        namespace
      } = (0, utils_1.parseCaipChainId)(chainId);
      return namespace === utils_1.KnownCaipNamespace.Eip155;
    });
  }
  // Otherwise, check if the scope is in the chain IDs.
  return chainIds.includes(scope);
}
exports.isMatchingChainId = isMatchingChainId;
/**
 * Format the state value for an account selector.
 *
 * @param account - The account to format.
 * @param requestedChainIds - The requested chain IDs.
 *
 * @returns The state value for the account selector.
 */
function formatAccountSelectorStateValue(account, requestedChainIds) {
  const {
    id,
    address,
    scopes
  } = account;
  const chainIds = (0, snaps_utils_1.createChainIdList)(scopes, requestedChainIds);
  const addresses = (0, snaps_utils_1.createAccountList)(address, chainIds);
  return {
    accountId: id,
    addresses
  };
}
exports.formatAccountSelectorStateValue = formatAccountSelectorStateValue;
/**
 * Get a default asset for a given address.
 *
 * @param addresses - The account addresses.
 * @param chainIds - The chain IDs to filter the assets.
 * @param elementDataGetters - Data getters for the element.
 * @param elementDataGetters.getAccountByAddress - A function to get an account by its address.
 * @param elementDataGetters.getAssetsState - A function to get the MultichainAssetController state.
 *
 * @returns The default asset for the account or undefined if not found.
 */
function getDefaultAsset(addresses, chainIds, {
  getAccountByAddress,
  getAssetsState
}) {
  var _getAccountByAddress;
  const {
    assetsMetadata,
    accountsAssets
  } = getAssetsState();
  const parsedAccounts = addresses.map(address => (0, utils_1.parseCaipAccountId)(address));
  const accountChainIds = parsedAccounts.map(({
    chainId
  }) => chainId);
  const filteredChainIds = chainIds && chainIds.length > 0 ? accountChainIds.filter(accountChainId => chainIds.includes(accountChainId)) : accountChainIds;
  const accountId = (_getAccountByAddress = getAccountByAddress(addresses[0])) === null || _getAccountByAddress === void 0 ? void 0 : _getAccountByAddress.id;
  // We should never fail on this assertion as the address is already validated.
  (0, snaps_sdk_1.assert)(accountId, `Account not found for address: ${addresses[0]}.`);
  const accountAssets = accountsAssets[accountId];
  // The AssetSelector component in the UI will be disabled if there is no asset available for the account
  // and networks provided. In this case, we return null to indicate that there is no default selected asset.
  if (accountAssets.length === 0) {
    return null;
  }
  const nativeAsset = accountAssets.find(asset => {
    const {
      chainId,
      assetNamespace
    } = (0, utils_1.parseCaipAssetType)(asset);
    return filteredChainIds.includes(chainId) && assetNamespace === 'slip44';
  });
  if (nativeAsset) {
    return {
      asset: nativeAsset,
      name: assetsMetadata[nativeAsset].name,
      symbol: assetsMetadata[nativeAsset].symbol
    };
  }
  return {
    asset: accountAssets[0],
    name: assetsMetadata[accountAssets[0]].name,
    symbol: assetsMetadata[accountAssets[0]].symbol
  };
}
exports.getDefaultAsset = getDefaultAsset;
/**
 * Get the default state value for an account selector.
 *
 * @param element - The account selector element.
 * @param elementDataGetters - Data getters for the element.
 * @param elementDataGetters.getSelectedAccount - A function to get the selected account in the client.
 * @param elementDataGetters.listAccounts - A function to list accounts for the provided chain IDs.
 * @param elementDataGetters.snapOwnsAccount - A function to check if the snap owns the account.
 * @returns The default state for the account selector.
 */
function getAccountSelectorDefaultStateValue(element, {
  getSelectedAccount,
  listAccounts,
  snapOwnsAccount
}) {
  const {
    chainIds,
    hideExternalAccounts
  } = element.props;
  const selectedAccount = getSelectedAccount();
  // Use the selected account if it matches.
  // The following conditions are checked:
  // - If the selected account has any of the requested chain IDs in its scopes.
  // - If the selected account is owned by the snap and hideExternalAccounts is true.
  if ((!chainIds || chainIds.length === 0 || selectedAccount.scopes.some(scope => isMatchingChainId(scope, chainIds))) && (!hideExternalAccounts || hideExternalAccounts && snapOwnsAccount(selectedAccount))) {
    return formatAccountSelectorStateValue(selectedAccount, chainIds);
  }
  const accounts = listAccounts(chainIds);
  const filteredAccounts = hideExternalAccounts ? accounts.filter(account => snapOwnsAccount(account)) : accounts;
  // The AccountSelector component in the UI will be disabled if there is no account available for the networks provided.
  // In this case, we return null to indicate that there is no default selected account.
  if (filteredAccounts.length === 0) {
    return null;
  }
  return formatAccountSelectorStateValue(filteredAccounts[0], chainIds);
}
exports.getAccountSelectorDefaultStateValue = getAccountSelectorDefaultStateValue;
/**
 * Construct default state for a component.
 *
 * This function is meant to be used inside constructInputState to account
 * for component specific defaults and will not override the component value or existing form state.
 *
 * @param element - The input element.
 * @param elementDataGetters - Data getters for the element.
 *
 * @returns The default state for the specific component, if any.
 */
function constructComponentSpecificDefaultState(element, elementDataGetters) {
  switch (element.type) {
    case 'Dropdown':
      {
        var _children$;
        const children = (0, snaps_utils_1.getJsxChildren)(element);
        return (_children$ = children[0]) === null || _children$ === void 0 ? void 0 : _children$.props.value;
      }
    case 'RadioGroup':
      {
        var _children$2;
        const children = (0, snaps_utils_1.getJsxChildren)(element);
        return (_children$2 = children[0]) === null || _children$2 === void 0 ? void 0 : _children$2.props.value;
      }
    case 'Selector':
      {
        var _children$3;
        const children = (0, snaps_utils_1.getJsxChildren)(element);
        return (_children$3 = children[0]) === null || _children$3 === void 0 ? void 0 : _children$3.props.value;
      }
    case 'AccountSelector':
      return getAccountSelectorDefaultStateValue(element, elementDataGetters);
    case 'Checkbox':
      return false;
    case 'AssetSelector':
      return getDefaultAsset(element.props.addresses, element.props.chainIds, elementDataGetters);
    default:
      return null;
  }
}
/**
 * Get the state value for an asset selector.
 *
 * @param value - The asset selector value.
 * @param getAssetState - A function to get the MultichainAssetController state.
 * @returns The state value for the asset selector or null.
 */
function getAssetSelectorStateValue(value, getAssetState) {
  if (!value) {
    return null;
  }
  const {
    assetsMetadata
  } = getAssetState();
  const asset = assetsMetadata[value];
  if (!asset) {
    return null;
  }
  return {
    asset: value,
    name: asset.name ?? asset.symbol ?? 'Unknown',
    symbol: asset.symbol ?? 'Unknown'
  };
}
exports.getAssetSelectorStateValue = getAssetSelectorStateValue;
/**
 * Get the state value for an account selector.
 *
 * @param element - The account selector element.
 * @param elementDataGetters - Data getters for the element.
 * @param elementDataGetters.getAccountByAddress - A function to get an account by address.
 * @param elementDataGetters.snapOwnsAccount - A function to check if the snap owns the account.
 * @returns The state value for the account selector.
 */
function getAccountSelectorStateValue(element, {
  getAccountByAddress,
  snapOwnsAccount
}) {
  const {
    value,
    hideExternalAccounts
  } = element.props;
  if (!value) {
    return null;
  }
  const account = getAccountByAddress(value);
  if (!account) {
    return null;
  }
  if (hideExternalAccounts && !snapOwnsAccount(account)) {
    return null;
  }
  return formatAccountSelectorStateValue(account, element.props.chainIds);
}
exports.getAccountSelectorStateValue = getAccountSelectorStateValue;
/**
 * Get the state value for a stateful component.
 *
 * Most components store the state value as a `value` prop.
 * This function exists to account for components where that isn't the case.
 *
 * @param element - The input element.
 * @param elementDataGetters - Data getters for the element.
 * @returns The state value for a given component.
 */
function getComponentStateValue(element, elementDataGetters) {
  switch (element.type) {
    case 'Checkbox':
      return element.props.checked;
    case 'AssetSelector':
      return getAssetSelectorStateValue(element.props.value, elementDataGetters.getAssetsState);
    case 'AddressInput':
      {
        if (!element.props.value) {
          return null;
        }
        // Construct CAIP-10 Id
        const {
          namespace,
          reference
        } = (0, utils_1.parseCaipChainId)(element.props.chainId);
        return (0, utils_1.toCaipAccountId)(namespace, reference, element.props.value);
      }
    case 'AccountSelector':
      return getAccountSelectorStateValue(element, elementDataGetters);
    default:
      return element.props.value;
  }
}
/**
 * Construct the state for an input field.
 *
 * @param oldState - The previous state.
 * @param element - The input element.
 * @param elementDataGetters - Data getters for the element.
 * @param form - An optional form that the input is enclosed in.
 * @returns The input state.
 */
function constructInputState(oldState, element, elementDataGetters, form) {
  const oldStateUnwrapped = form ? oldState[form] : oldState;
  const oldInputState = oldStateUnwrapped === null || oldStateUnwrapped === void 0 ? void 0 : oldStateUnwrapped[element.props.name];
  if (element.type === 'FileInput') {
    return oldInputState ?? null;
  }
  return getComponentStateValue(element, elementDataGetters) ?? oldInputState ?? constructComponentSpecificDefaultState(element, elementDataGetters) ?? null;
}
/**
 * Construct the interface state for a given component tree.
 *
 * @param oldState - The previous state.
 * @param rootComponent - The UI component to construct state from.
 * @param elementDataGetters - Data getters for the elements.
 * @returns The interface state of the passed component.
 */
function constructState(oldState, rootComponent, elementDataGetters) {
  const newState = {};
  // Stack containing the forms we have visited and at which depth
  const formStack = [];
  (0, snaps_utils_1.walkJsx)(rootComponent, (component, depth) => {
    let currentForm = formStack[formStack.length - 1];
    // Pop the current form of the stack once we leave its depth.
    if (currentForm && depth <= currentForm.depth) {
      formStack.pop();
      currentForm = formStack[formStack.length - 1];
    }
    if (component.type === 'Form') {
      assertNameIsUnique(newState, component.props.name);
      formStack.push({
        name: component.props.name,
        depth
      });
      newState[component.props.name] = {};
      return;
    }
    // Stateful components inside a form
    if (currentForm && isStatefulComponent(component)) {
      const formState = newState[currentForm.name];
      assertNameIsUnique(formState, component.props.name);
      formState[component.props.name] = constructInputState(oldState, component, elementDataGetters, currentForm.name);
      return;
    }
    // Stateful components outside a form
    if (isStatefulComponent(component)) {
      assertNameIsUnique(newState, component.props.name);
      newState[component.props.name] = constructInputState(oldState, component, elementDataGetters);
    }
  });
  return newState;
}
exports.constructState = constructState;
const MAX_CONTEXT_SIZE = 5000000; // 5 mb
/**
 * Validate a JSON blob to be used as the interface context.
 *
 * @param context - The JSON blob.
 * @throws If the JSON blob is too large.
 */
function validateInterfaceContext(context) {
  if (!context) {
    return;
  }
  // We assume the validity of this JSON to be validated by the caller.
  // E.g., in the RPC method implementation.
  const size = (0, snaps_utils_1.getJsonSizeUnsafe)(context);
  (0, snaps_sdk_1.assert)(size <= MAX_CONTEXT_SIZE, `A Snap interface context may not be larger than ${MAX_CONTEXT_SIZE / 1000000} MB.`);
}
exports.validateInterfaceContext = validateInterfaceContext;

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers",file:"node_modules\\@metamask\\snaps-controllers\\dist\\interface\\utils.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\logging.cjs", {"@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-controllers%5Cdist%5Clogging.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.log = void 0;
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
/**
 * A logging function specific to this package. The log messages don't show up
 * by default, but they can be enabled by setting the environment variable:
 * - `DEBUG=metamask:snaps:snaps-controllers`, or
 * - `DEBUG=metamask:snaps:*` to enable all logs from `@metamask/snaps-*`.
 */
exports.log = (0, utils_1.createModuleLogger)(snaps_utils_1.snapsLogger, 'snaps-controllers');

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers",file:"node_modules\\@metamask\\snaps-controllers\\dist\\logging.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\multichain\\MultichainRouter.cjs", {"../snaps/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\snaps\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-rpc-methods":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","nanoid":"D:\\code\\v\\metamask-extension\\node_modules\\nanoid\\index.browser.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-controllers%5Cdist%5Cmultichain%5CMultichainRouter.cjs
      return function (require, module, exports) {
"use strict";

function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainRouter = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_rpc_methods_1 = require("@metamask/snaps-rpc-methods");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
const nanoid_1 = require("nanoid");
const snaps_1 = require("../snaps/index.cjs");
const name = 'MultichainRouter';
var _messenger = /*#__PURE__*/new WeakMap();
var _withSnapKeyring = /*#__PURE__*/new WeakMap();
var _MultichainRouter_brand = /*#__PURE__*/new WeakSet();
class MultichainRouter {
  constructor({
    messenger,
    withSnapKeyring
  }) {
    /**
     * Attempts to resolve the account address to use for a given request by inspecting the request itself.
     *
     * The request is sent to to an account Snap via the SnapKeyring that will attempt this resolution.
     *
     * @param snapId - The ID of the Snap to send the request to.
     * @param scope - The CAIP-2 scope for the request.
     * @param request - The JSON-RPC request.
     * @returns The resolved address if found, otherwise null.
     * @throws If the invocation of the SnapKeyring fails.
     */
    _classPrivateMethodInitSpec(this, _MultichainRouter_brand);
    _defineProperty(this, "name", name);
    _defineProperty(this, "state", null);
    _classPrivateFieldInitSpec(this, _messenger, void 0);
    _classPrivateFieldInitSpec(this, _withSnapKeyring, void 0);
    _classPrivateFieldSet(_messenger, this, messenger);
    _classPrivateFieldSet(_withSnapKeyring, this, withSnapKeyring);
    _classPrivateFieldGet(_messenger, this).registerActionHandler(`${name}:handleRequest`, async (...args) => this.handleRequest(...args));
    _classPrivateFieldGet(_messenger, this).registerActionHandler(`${name}:getSupportedMethods`, (...args) => this.getSupportedMethods(...args));
    _classPrivateFieldGet(_messenger, this).registerActionHandler(`${name}:getSupportedAccounts`, (...args) => this.getSupportedAccounts(...args));
    _classPrivateFieldGet(_messenger, this).registerActionHandler(`${name}:isSupportedScope`, (...args) => this.isSupportedScope(...args));
  }
  /**
   * Handle an incoming JSON-RPC request tied to a specific scope by routing
   * to either a protocol Snap or an account Snap.
   *
   * Note: Addresses are considered case sensitive by the MultichainRouter as
   * not all non-EVM chains are case insensitive.
   *
   * @param options - An options bag.
   * @param options.connectedAddresses - Addresses currently connected to the origin.
   * @param options.origin - The origin of the RPC request.
   * @param options.request - The JSON-RPC request.
   * @param options.scope - The CAIP-2 scope for the request.
   * @returns The response from the chosen Snap.
   * @throws If no handler was found.
   */
  async handleRequest({
    connectedAddresses,
    origin,
    scope,
    request: rawRequest
  }) {
    // Explicitly block EVM scopes, just in case.
    (0, utils_1.assert)(!scope.startsWith(utils_1.KnownCaipNamespace.Eip155) && !scope.startsWith('wallet:eip155'));
    // Re-create the request to simplify and remove additional properties that may be present in MM middleware.
    const request = {
      jsonrpc: '2.0',
      id: rawRequest.id ?? (0, nanoid_1.nanoid)(),
      method: rawRequest.method,
      ...(rawRequest.params ? {
        params: rawRequest.params
      } : {})
    };
    const {
      method,
      params
    } = request;
    // If the RPC request can be serviced by an account Snap, route it there.
    const accountId = await _assertClassBrand(_MultichainRouter_brand, this, _getSnapAccountId).call(this, connectedAddresses, scope, request);
    if (accountId) {
      return _classPrivateFieldGet(_withSnapKeyring, this).call(this, async ({
        keyring
      }) => keyring.submitRequest({
        origin,
        account: accountId,
        scope,
        method,
        params: params
      }));
    }
    // If the RPC request cannot be serviced by an account Snap,
    // but has a protocol Snap available, route it there.
    const protocolSnaps = _assertClassBrand(_MultichainRouter_brand, this, _getProtocolSnaps).call(this, scope);
    const protocolSnap = protocolSnaps.find(snap => snap.methods.includes(method));
    if (protocolSnap) {
      return _classPrivateFieldGet(_messenger, this).call('SnapController:handleRequest', {
        snapId: protocolSnap.snapId,
        origin,
        request: {
          method: '',
          params: {
            request,
            scope
          }
        },
        handler: snaps_utils_1.HandlerType.OnProtocolRequest
      });
    }
    // If no compatible account or protocol Snaps were found, throw.
    throw rpc_errors_1.rpcErrors.methodNotFound();
  }
  /**
   * Get a list of metadata for supported accounts for a given scope from the client.
   *
   * @param scope - The CAIP-2 scope.
   * @returns A list of metadata for the supported accounts.
   */

  /**
   * Get a list of supported methods for a given scope.
   * This combines both protocol and account Snaps supported methods.
   *
   * @param scope - The CAIP-2 scope.
   * @returns A list of supported methods.
   */
  getSupportedMethods(scope) {
    const accountMethods = _assertClassBrand(_MultichainRouter_brand, this, _getSupportedAccountsMetadata).call(this, scope).flatMap(account => account.methods);
    const protocolMethods = _assertClassBrand(_MultichainRouter_brand, this, _getProtocolSnaps).call(this, scope).flatMap(snap => snap.methods);
    return Array.from(new Set([...accountMethods, ...protocolMethods]));
  }
  /**
   * Get a list of supported accounts for a given scope.
   *
   * @param scope - The CAIP-2 scope.
   * @returns A list of CAIP-10 addresses.
   */
  getSupportedAccounts(scope) {
    return _assertClassBrand(_MultichainRouter_brand, this, _getSupportedAccountsMetadata).call(this, scope).map(account => `${scope}:${account.address}`);
  }
  /**
   * Determine whether a given CAIP-2 scope is supported by the router.
   *
   * @param scope - The CAIP-2 scope.
   * @returns True if the router can service the scope, otherwise false.
   */
  isSupportedScope(scope) {
    const hasAccountSnap = _classPrivateFieldGet(_messenger, this).call('AccountsController:listMultichainAccounts', scope).some(account => {
      var _account$metadata$sna;
      return (_account$metadata$sna = account.metadata.snap) === null || _account$metadata$sna === void 0 ? void 0 : _account$metadata$sna.enabled;
    });
    // We currently assume here that if one Snap exists that service the scope, we can service the scope generally.
    return hasAccountSnap || _assertClassBrand(_MultichainRouter_brand, this, _getProtocolSnaps).call(this, scope).length > 0;
  }
}
async function _resolveRequestAddress(snapId, scope, request) {
  try {
    const result = await _classPrivateFieldGet(_withSnapKeyring, this).call(this, async ({
      keyring
    }) => keyring.resolveAccountAddress(snapId, scope, request));
    const address = result === null || result === void 0 ? void 0 : result.address;
    return address ? (0, utils_1.parseCaipAccountId)(address).address : null;
  } catch {
    throw rpc_errors_1.rpcErrors.internal();
  }
}
/**
 * Get the account ID of the account that should service the RPC request via an account Snap.
 *
 * This function checks whether any accounts exist that can service a given request by
 * using a combination of the resolveAccountAddress functionality and the connected accounts.
 *
 * If an account is expected to service this request but none is found, the function will throw.
 *
 * @param connectedAddresses - The CAIP-10 addresses connected to the requesting origin.
 * @param scope - The CAIP-2 scope for the request.
 * @param request - The JSON-RPC request.
 * @returns An account ID if found, otherwise null.
 * @throws If no account is found, but the accounts exist that could service the request.
 */
async function _getSnapAccountId(connectedAddresses, scope, request) {
  const accounts = _classPrivateFieldGet(_messenger, this).call('AccountsController:listMultichainAccounts', scope).filter(account => {
    var _account$metadata$sna2;
    return Boolean((_account$metadata$sna2 = account.metadata.snap) === null || _account$metadata$sna2 === void 0 ? void 0 : _account$metadata$sna2.enabled) && account.methods.includes(request.method);
  });
  // If no accounts can service the request, return null.
  if (accounts.length === 0) {
    return null;
  }
  const resolutionSnapId = accounts[0].metadata.snap.id;
  // Attempt to resolve the address that should be used for signing.
  const address = await _assertClassBrand(_MultichainRouter_brand, this, _resolveRequestAddress).call(this, resolutionSnapId, scope, request);
  const parsedConnectedAddresses = connectedAddresses.map(connectedAddress => (0, utils_1.parseCaipAccountId)(connectedAddress).address);
  // If we have a resolved address, try to find the selected account based on that
  // otherwise, default to one of the connected accounts.
  // TODO: Eventually let the user choose if we have more than one option for the account.
  const selectedAccount = accounts.find(account => parsedConnectedAddresses.includes(account.address) && (!address || account.address === address));
  if (!selectedAccount) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'No available account found for request.'
    });
  }
  return selectedAccount.id;
}
/**
 * Get all protocol Snaps that can service a given CAIP-2 scope.
 *
 * Protocol Snaps are deemed fit to service a scope if they are runnable
 * and have the proper permissions set for the scope.
 *
 * @param scope - A CAIP-2 scope.
 * @returns A list of all the protocol Snaps available and their RPC methods.
 */
function _getProtocolSnaps(scope) {
  const allSnaps = _classPrivateFieldGet(_messenger, this).call('SnapController:getAll');
  const filteredSnaps = (0, snaps_1.getRunnableSnaps)(allSnaps);
  return filteredSnaps.reduce((accumulator, snap) => {
    const permissions = _classPrivateFieldGet(_messenger, this).call('PermissionController:getPermissions', snap.id);
    if (permissions && (0, utils_1.hasProperty)(permissions, snaps_rpc_methods_1.SnapEndowments.Protocol)) {
      const permission = permissions[snaps_rpc_methods_1.SnapEndowments.Protocol];
      const scopes = (0, snaps_rpc_methods_1.getProtocolCaveatScopes)(permission);
      if (scopes && (0, utils_1.hasProperty)(scopes, scope)) {
        accumulator.push({
          snapId: snap.id,
          methods: scopes[scope].methods
        });
      }
    }
    return accumulator;
  }, []);
}
function _getSupportedAccountsMetadata(scope) {
  return _classPrivateFieldGet(_messenger, this).call('AccountsController:listMultichainAccounts', scope).filter(account => {
    var _account$metadata$sna3;
    return (_account$metadata$sna3 = account.metadata.snap) === null || _account$metadata$sna3 === void 0 ? void 0 : _account$metadata$sna3.enabled;
  });
}
exports.MultichainRouter = MultichainRouter;

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers",file:"node_modules\\@metamask\\snaps-controllers\\dist\\multichain\\MultichainRouter.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\multichain\\index.cjs", {"./MultichainRouter.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\multichain\\MultichainRouter.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-controllers%5Cdist%5Cmultichain%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
__exportStar(require("./MultichainRouter.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers",file:"node_modules\\@metamask\\snaps-controllers\\dist\\multichain\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\services\\AbstractExecutionService.cjs", {"../logging.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\logging.cjs","../snaps/Timer.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\snaps\\Timer.cjs","../utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\utils.cjs","@metamask/json-rpc-engine":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-engine\\dist\\index.cjs","@metamask/json-rpc-middleware-stream":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-middleware-stream\\dist\\index.cjs","@metamask/object-multiplex":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\object-multiplex\\dist\\index.js","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","nanoid":"D:\\code\\v\\metamask-extension\\node_modules\\nanoid\\index.browser.cjs","readable-stream":"D:\\code\\v\\metamask-extension\\node_modules\\readable-stream\\readable-browser.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-controllers%5Cdist%5Cservices%5CAbstractExecutionService.cjs
      return function (require, module, exports) {
"use strict";

function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
var __importDefault = void 0 && (void 0).__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupMultiplex = exports.AbstractExecutionService = void 0;
const json_rpc_engine_1 = require("@metamask/json-rpc-engine");
const json_rpc_middleware_stream_1 = require("@metamask/json-rpc-middleware-stream");
const object_multiplex_1 = __importDefault(require("@metamask/object-multiplex"));
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
const nanoid_1 = require("nanoid");
const readable_stream_1 = require("readable-stream");
const logging_1 = require("../logging.cjs");
const Timer_1 = require("../snaps/Timer.cjs");
const utils_2 = require("../utils.cjs");
const controllerName = 'ExecutionService';
var _jobs = /*#__PURE__*/new WeakMap();
var _status = /*#__PURE__*/new WeakMap();
var _setupSnapProvider = /*#__PURE__*/new WeakMap();
var _messenger = /*#__PURE__*/new WeakMap();
var _initTimeout = /*#__PURE__*/new WeakMap();
var _pingTimeout = /*#__PURE__*/new WeakMap();
var _terminationTimeout = /*#__PURE__*/new WeakMap();
var _usePing = /*#__PURE__*/new WeakMap();
var _AbstractExecutionService_brand = /*#__PURE__*/new WeakSet();
class AbstractExecutionService {
  constructor({
    setupSnapProvider,
    messenger,
    initTimeout = (0, utils_1.inMilliseconds)(60, utils_1.Duration.Second),
    pingTimeout = (0, utils_1.inMilliseconds)(2, utils_1.Duration.Second),
    terminationTimeout = (0, utils_1.inMilliseconds)(1, utils_1.Duration.Second),
    usePing = true
  }) {
    /**
     * Constructor helper for registering the controller's messaging system
     * actions.
     */
    _classPrivateMethodInitSpec(this, _AbstractExecutionService_brand);
    _defineProperty(this, "name", controllerName);
    _defineProperty(this, "state", null);
    _classPrivateFieldInitSpec(this, _jobs, void 0);
    _classPrivateFieldInitSpec(this, _status, void 0);
    _classPrivateFieldInitSpec(this, _setupSnapProvider, void 0);
    _classPrivateFieldInitSpec(this, _messenger, void 0);
    _classPrivateFieldInitSpec(this, _initTimeout, void 0);
    _classPrivateFieldInitSpec(this, _pingTimeout, void 0);
    _classPrivateFieldInitSpec(this, _terminationTimeout, void 0);
    _classPrivateFieldInitSpec(this, _usePing, void 0);
    _classPrivateFieldSet(_jobs, this, new Map());
    _classPrivateFieldSet(_status, this, new Map());
    _classPrivateFieldSet(_setupSnapProvider, this, setupSnapProvider);
    _classPrivateFieldSet(_messenger, this, messenger);
    _classPrivateFieldSet(_initTimeout, this, initTimeout);
    _classPrivateFieldSet(_pingTimeout, this, pingTimeout);
    _classPrivateFieldSet(_terminationTimeout, this, terminationTimeout);
    _classPrivateFieldSet(_usePing, this, usePing);
    _assertClassBrand(_AbstractExecutionService_brand, this, _registerMessageHandlers).call(this);
  }
  /**
   * Terminates the Snap with the specified ID and deletes all its associated
   * data. Any subsequent messages targeting the Snap will fail with an error.
   * Throws an error if termination fails unexpectedly.
   *
   * @param snapId - The id of the Snap to be terminated.
   */
  async terminateSnap(snapId) {
    const job = _classPrivateFieldGet(_jobs, this).get(snapId);
    if (!job) {
      return;
    }
    try {
      // Ping worker and tell it to run teardown, continue with termination if it takes too long
      const result = await (0, utils_2.withTimeout)(_assertClassBrand(_AbstractExecutionService_brand, this, _command).call(this, snapId, {
        jsonrpc: '2.0',
        method: 'terminate',
        params: [],
        id: (0, nanoid_1.nanoid)()
      }), _classPrivateFieldGet(_terminationTimeout, this));
      if (result === utils_2.hasTimedOut || result !== 'OK') {
        (0, snaps_utils_1.logWarning)(`Snap "${snapId}" failed to terminate gracefully.`);
      }
    } catch {
      // Ignore
    }
    Object.values(job.streams).forEach(stream => {
      try {
        if (!stream.destroyed) {
          stream.destroy();
        }
      } catch (error) {
        (0, snaps_utils_1.logError)('Error while destroying stream', error);
      }
    });
    this.terminateJob(job);
    _classPrivateFieldGet(_jobs, this).delete(snapId);
    _classPrivateFieldGet(_status, this).delete(snapId);
    (0, logging_1.log)(`Snap "${snapId}" terminated.`);
  }
  /**
   * Initiates a job for a Snap.
   *
   * @param snapId - The ID of the Snap to initiate a job for.
   * @param timer - The timer to use for timeouts.
   * @returns Information regarding the created job.
   * @throws If the execution service returns an error or execution times out.
   */

  /**
   * Set the execution status of the Snap.
   *
   * @param snapId - The Snap ID.
   * @param status - The current execution status.
   */
  setSnapStatus(snapId, status) {
    _classPrivateFieldGet(_status, this).set(snapId, status);
  }
  async terminateAllSnaps() {
    await Promise.all([..._classPrivateFieldGet(_jobs, this).keys()].map(async snapId => this.terminateSnap(snapId)));
  }
  /**
   * Initializes and executes a Snap, setting up the communication channels to the Snap etc.
   *
   * @param snapData - Data needed for Snap execution.
   * @param snapData.snapId - The ID of the Snap to execute.
   * @param snapData.sourceCode - The source code of the Snap to execute.
   * @param snapData.endowments - The endowments available to the executing Snap.
   * @returns A string `OK` if execution succeeded.
   * @throws If the execution service returns an error or execution times out.
   */
  async executeSnap({
    snapId,
    sourceCode,
    endowments
  }) {
    if (_classPrivateFieldGet(_jobs, this).has(snapId)) {
      throw new Error(`"${snapId}" is already running.`);
    }
    this.setSnapStatus(snapId, 'created');
    const timer = new Timer_1.Timer(_classPrivateFieldGet(_initTimeout, this));
    // This may resolve even if the environment has failed to start up fully
    const job = await _assertClassBrand(_AbstractExecutionService_brand, this, _initJob).call(this, snapId, timer);
    // Certain environments use ping as part of their initialization and thus can skip it here
    if (_classPrivateFieldGet(_usePing, this)) {
      // Ping the worker to ensure that it started up
      const pingResult = await (0, utils_2.withTimeout)(_assertClassBrand(_AbstractExecutionService_brand, this, _command).call(this, job.id, {
        jsonrpc: '2.0',
        method: 'ping',
        id: (0, nanoid_1.nanoid)()
      }), _classPrivateFieldGet(_pingTimeout, this));
      if (pingResult === utils_2.hasTimedOut) {
        throw new Error(`The executor for "${snapId}" was unreachable. The executor did not respond in time.`);
      }
    }
    const rpcStream = job.streams.rpc;
    _classPrivateFieldGet(_setupSnapProvider, this).call(this, snapId, rpcStream);
    // Use the remaining time as the timer, but ensure that the
    // Snap gets at least half the init timeout.
    const remainingTime = Math.max(timer.remaining, _classPrivateFieldGet(_initTimeout, this) / 2);
    this.setSnapStatus(snapId, 'initialized');
    const request = {
      jsonrpc: '2.0',
      method: 'executeSnap',
      params: {
        snapId,
        sourceCode,
        endowments
      },
      id: (0, nanoid_1.nanoid)()
    };
    (0, utils_1.assertIsJsonRpcRequest)(request);
    this.setSnapStatus(snapId, 'executing');
    const result = await (0, utils_2.withTimeout)(_assertClassBrand(_AbstractExecutionService_brand, this, _command).call(this, job.id, request), remainingTime);
    if (result === utils_2.hasTimedOut) {
      throw new Error(`${snapId} failed to start.`);
    }
    if (result === 'OK') {
      this.setSnapStatus(snapId, 'running');
    }
    return result;
  }
  /**
   * Handle RPC request.
   *
   * @param snapId - The ID of the recipient Snap.
   * @param options - Bag of options to pass to the RPC handler.
   * @returns Promise that can handle the request.
   */
  async handleRpcRequest(snapId, options) {
    const {
      handler,
      request,
      origin
    } = options;
    return await _assertClassBrand(_AbstractExecutionService_brand, this, _command).call(this, snapId, {
      id: (0, nanoid_1.nanoid)(),
      jsonrpc: '2.0',
      method: 'snapRpc',
      params: {
        origin,
        handler,
        request: request,
        target: snapId
      }
    });
  }
}
function _registerMessageHandlers() {
  _classPrivateFieldGet(_messenger, this).registerActionHandler(`${controllerName}:handleRpcRequest`, async (snapId, options) => this.handleRpcRequest(snapId, options));
  _classPrivateFieldGet(_messenger, this).registerActionHandler(`${controllerName}:executeSnap`, async data => this.executeSnap(data));
  _classPrivateFieldGet(_messenger, this).registerActionHandler(`${controllerName}:terminateSnap`, async snapId => this.terminateSnap(snapId));
  _classPrivateFieldGet(_messenger, this).registerActionHandler(`${controllerName}:terminateAllSnaps`, async () => this.terminateAllSnaps());
}
async function _initJob(snapId, timer) {
  const {
    streams,
    worker
  } = await _assertClassBrand(_AbstractExecutionService_brand, this, _initStreams).call(this, snapId, timer);
  const rpcEngine = new json_rpc_engine_1.JsonRpcEngine();
  const jsonRpcConnection = (0, json_rpc_middleware_stream_1.createStreamMiddleware)();
  (0, readable_stream_1.pipeline)(jsonRpcConnection.stream, streams.command, jsonRpcConnection.stream, error => {
    var _error$message2;
    if (error && !((_error$message2 = error.message) !== null && _error$message2 !== void 0 && _error$message2.match('Premature close'))) {
      (0, snaps_utils_1.logError)(`Command stream failure.`, error);
    }
  });
  rpcEngine.push(jsonRpcConnection.middleware);
  const envMetadata = {
    id: snapId,
    streams,
    rpcEngine,
    worker
  };
  _classPrivateFieldGet(_jobs, this).set(snapId, envMetadata);
  return envMetadata;
}
/**
 * Sets up the streams for an initiated job.
 *
 * @param snapId - The Snap ID.
 * @param timer - The timer to use for timeouts.
 * @returns The streams to communicate with the worker and the worker itself.
 * @throws If the execution service returns an error or execution times out.
 */
async function _initStreams(snapId, timer) {
  const result = await (0, utils_2.withTimeout)(this.initEnvStream(snapId), timer);
  if (result === utils_2.hasTimedOut) {
    // For certain environments, such as the iframe we may have already created the worker and wish to terminate it.
    this.terminateJob({
      id: snapId
    });
    const status = _classPrivateFieldGet(_status, this).get(snapId);
    if (status === 'created') {
      // Currently this error can only be thrown by OffscreenExecutionService.
      throw new Error(`The executor for "${snapId}" couldn't start initialization. The offscreen document may not exist.`);
    }
    throw new Error(`The executor for "${snapId}" failed to initialize. The iframe/webview/worker failed to load.`);
  }
  const {
    worker,
    stream: envStream
  } = result;
  const mux = setupMultiplex(envStream, `Snap: "${snapId}"`);
  const commandStream = mux.createStream(snaps_utils_1.SNAP_STREAM_NAMES.COMMAND);
  // Handle out-of-band errors, i.e. errors thrown from the Snap outside of the req/res cycle.
  // Also keep track of outbound request/responses
  const notificationHandler = message => {
    if ((0, utils_1.hasProperty)(message, 'id')) {
      return;
    }
    if (message.method === 'OutboundRequest') {
      _classPrivateFieldGet(_messenger, this).publish('ExecutionService:outboundRequest', snapId);
    } else if (message.method === 'OutboundResponse') {
      _classPrivateFieldGet(_messenger, this).publish('ExecutionService:outboundResponse', snapId);
    } else if (message.method === 'UnhandledError') {
      _classPrivateFieldGet(_messenger, this).publish('ExecutionService:unhandledError', snapId, message.params.error);
      commandStream.removeListener('data', notificationHandler);
    } else {
      (0, snaps_utils_1.logError)(new Error(`Received unexpected command stream notification "${message.method}".`));
    }
  };
  commandStream.on('data', notificationHandler);
  const rpcStream = mux.createStream(snaps_utils_1.SNAP_STREAM_NAMES.JSON_RPC);
  rpcStream.on('data', chunk => {
    if (chunk !== null && chunk !== void 0 && chunk.data && (0, utils_1.hasProperty)(chunk === null || chunk === void 0 ? void 0 : chunk.data, 'id')) {
      _classPrivateFieldGet(_messenger, this).publish('ExecutionService:outboundRequest', snapId);
    }
  });
  const originalWrite = rpcStream.write.bind(rpcStream);
  // @ts-expect-error Hack to inspect the messages being written to the stream.
  rpcStream.write = (chunk, encoding, callback) => {
    var _chunk$data;
    // Ignore chain switching notifications as it doesn't matter for the SnapProvider.
    if ((chunk === null || chunk === void 0 || (_chunk$data = chunk.data) === null || _chunk$data === void 0 ? void 0 : _chunk$data.method) === 'metamask_chainChanged') {
      return true;
    }
    if (chunk !== null && chunk !== void 0 && chunk.data && (0, utils_1.hasProperty)(chunk === null || chunk === void 0 ? void 0 : chunk.data, 'id')) {
      _classPrivateFieldGet(_messenger, this).publish('ExecutionService:outboundResponse', snapId);
    }
    return originalWrite(chunk, encoding, callback);
  };
  // Typecast: stream type mismatch
  return {
    streams: {
      command: commandStream,
      rpc: rpcStream,
      // eslint-disable-next-line @typescript-eslint/naming-convention
      _connection: envStream
    },
    worker
  };
}
async function _command(snapId, message) {
  const job = _classPrivateFieldGet(_jobs, this).get(snapId);
  if (!job) {
    throw new Error(`"${snapId}" is not currently running.`);
  }
  (0, logging_1.log)('Parent: Sending Command', message);
  const response = await job.rpcEngine.handle(message);
  // We don't need full validation of the response here because we control it.
  if ((0, utils_1.hasProperty)(response, 'error')) {
    const error = response.error;
    throw new rpc_errors_1.JsonRpcError(error.code, error.message, error.data);
  }
  return response.result;
}
exports.AbstractExecutionService = AbstractExecutionService;
/**
 * Sets up stream multiplexing for the given stream.
 *
 * @param connectionStream - The stream to mux.
 * @param streamName - The name of the stream, for identification in errors.
 * @returns The multiplexed stream.
 */
function setupMultiplex(connectionStream, streamName) {
  const mux = new object_multiplex_1.default();
  (0, readable_stream_1.pipeline)(connectionStream, mux, connectionStream, error => {
    var _error$message;
    if (error && !((_error$message = error.message) !== null && _error$message !== void 0 && _error$message.match('Premature close'))) {
      (0, snaps_utils_1.logError)(`"${streamName}" stream failure.`, error);
    }
  });
  return mux;
}
exports.setupMultiplex = setupMultiplex;

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers",file:"node_modules\\@metamask\\snaps-controllers\\dist\\services\\AbstractExecutionService.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\services\\ProxyPostMessageStream.cjs", {"@metamask/post-message-stream":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\post-message-stream\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-controllers%5Cdist%5Cservices%5CProxyPostMessageStream.cjs
      return function (require, module, exports) {
"use strict";

function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProxyPostMessageStream = void 0;
const post_message_stream_1 = require("@metamask/post-message-stream");
/**
 * A post message stream that wraps messages in a job ID, before sending them
 * over the underlying stream.
 */
var _stream = /*#__PURE__*/new WeakMap();
var _jobId = /*#__PURE__*/new WeakMap();
var _ProxyPostMessageStream_brand = /*#__PURE__*/new WeakSet();
class ProxyPostMessageStream extends post_message_stream_1.BasePostMessageStream {
  /**
   * Initializes a new `ProxyPostMessageStream` instance.
   *
   * @param args - The constructor arguments.
   * @param args.stream - The underlying stream to use for communication.
   * @param args.jobId - The ID of the job this stream is associated with.
   */
  constructor({
    stream,
    jobId
  }) {
    super();
    /**
     * Handle incoming data from the underlying stream. This checks that the job
     * ID matches the expected job ID, and pushes the data to the stream if so.
     *
     * @param data - The data to handle.
     */
    _classPrivateMethodInitSpec(this, _ProxyPostMessageStream_brand);
    _classPrivateFieldInitSpec(this, _stream, void 0);
    _classPrivateFieldInitSpec(this, _jobId, void 0);
    _classPrivateFieldSet(_stream, this, stream);
    _classPrivateFieldSet(_jobId, this, jobId);
    _classPrivateFieldGet(_stream, this).on('data', _assertClassBrand(_ProxyPostMessageStream_brand, this, _onData).bind(this));
  }
  /**
   * Write data to the underlying stream. This wraps the data in an object with
   * the job ID.
   *
   * @param data - The data to write.
   */
  _postMessage(data) {
    _classPrivateFieldGet(_stream, this).write({
      jobId: _classPrivateFieldGet(_jobId, this),
      data
    });
  }
}
function _onData(data) {
  if (data.jobId !== _classPrivateFieldGet(_jobId, this)) {
    return;
  }
  this.push(data.data);
}
exports.ProxyPostMessageStream = ProxyPostMessageStream;

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers",file:"node_modules\\@metamask\\snaps-controllers\\dist\\services\\ProxyPostMessageStream.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\services\\iframe\\IframeExecutionService.cjs", {"../AbstractExecutionService.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\services\\AbstractExecutionService.cjs","@metamask/post-message-stream":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\post-message-stream\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-controllers%5Cdist%5Cservices%5Ciframe%5CIframeExecutionService.cjs
      return function (require, module, exports) {
"use strict";

function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IframeExecutionService = void 0;
const post_message_stream_1 = require("@metamask/post-message-stream");
const snaps_utils_1 = require("@metamask/snaps-utils");
const AbstractExecutionService_1 = require("../AbstractExecutionService.cjs");
class IframeExecutionService extends AbstractExecutionService_1.AbstractExecutionService {
  constructor({
    iframeUrl,
    messenger,
    setupSnapProvider,
    ...args
  }) {
    super({
      ...args,
      messenger,
      setupSnapProvider
    });
    _defineProperty(this, "iframeUrl", void 0);
    this.iframeUrl = iframeUrl;
  }
  terminateJob(jobWrapper) {
    var _document$getElementB;
    (_document$getElementB = document.getElementById(jobWrapper.id)) === null || _document$getElementB === void 0 || _document$getElementB.remove();
  }
  async initEnvStream(snapId) {
    this.setSnapStatus(snapId, 'initializing');
    const iframeWindow = await (0, snaps_utils_1.createWindow)({
      uri: this.iframeUrl.toString(),
      id: snapId
    });
    const stream = new post_message_stream_1.WindowPostMessageStream({
      name: 'parent',
      target: 'child',
      targetWindow: iframeWindow,
      targetOrigin: '*'
    });
    return {
      worker: iframeWindow,
      stream
    };
  }
}
exports.IframeExecutionService = IframeExecutionService;

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers",file:"node_modules\\@metamask\\snaps-controllers\\dist\\services\\iframe\\IframeExecutionService.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\services\\iframe\\index.cjs", {"./IframeExecutionService.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\services\\iframe\\IframeExecutionService.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-controllers%5Cdist%5Cservices%5Ciframe%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
__exportStar(require("./IframeExecutionService.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers",file:"node_modules\\@metamask\\snaps-controllers\\dist\\services\\iframe\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\services\\index.cjs", {"./AbstractExecutionService.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\services\\AbstractExecutionService.cjs","./ProxyPostMessageStream.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\services\\ProxyPostMessageStream.cjs","./iframe/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\services\\iframe\\index.cjs","./offscreen/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\services\\offscreen\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-controllers%5Cdist%5Cservices%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
__exportStar(require("./AbstractExecutionService.cjs"), exports);
__exportStar(require("./ProxyPostMessageStream.cjs"), exports);
__exportStar(require("./iframe/index.cjs"), exports);
__exportStar(require("./offscreen/index.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers",file:"node_modules\\@metamask\\snaps-controllers\\dist\\services\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\services\\offscreen\\OffscreenExecutionService.cjs", {"../proxy/ProxyExecutionService.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\services\\proxy\\ProxyExecutionService.cjs","@metamask/post-message-stream":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\post-message-stream\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-controllers%5Cdist%5Cservices%5Coffscreen%5COffscreenExecutionService.cjs
      return function (require, module, exports) {
"use strict";

function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OffscreenExecutionService = void 0;
const post_message_stream_1 = require("@metamask/post-message-stream");
const ProxyExecutionService_1 = require("../proxy/ProxyExecutionService.cjs");
var _offscreenPromise = /*#__PURE__*/new WeakMap();
class OffscreenExecutionService extends ProxyExecutionService_1.ProxyExecutionService {
  /**
   * Create a new offscreen execution service.
   *
   * @param args - The constructor arguments.
   * @param args.messenger - The messenger to use for communication with the
   * `SnapController`.
   * @param args.setupSnapProvider - The function to use to set up the snap
   * provider.
   * @param args.offscreenPromise - A promise that resolves when the offscreen
   * environment is ready.
   */
  constructor({
    messenger,
    setupSnapProvider,
    offscreenPromise,
    ...args
  }) {
    super({
      ...args,
      messenger,
      setupSnapProvider,
      stream: new post_message_stream_1.BrowserRuntimePostMessageStream({
        name: 'parent',
        target: 'child'
      })
    });
    _classPrivateFieldInitSpec(this, _offscreenPromise, void 0);
    _classPrivateFieldSet(_offscreenPromise, this, offscreenPromise);
  }
  /**
   * Create a new stream for the given Snap ID. This will wait for the offscreen
   * environment to be ready before creating the stream.
   *
   * @param snapId - The Snap ID to create a stream for.
   * @returns The stream for the given Snap ID.
   */
  async initEnvStream(snapId) {
    await _classPrivateFieldGet(_offscreenPromise, this);
    return await super.initEnvStream(snapId);
  }
}
exports.OffscreenExecutionService = OffscreenExecutionService;

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers",file:"node_modules\\@metamask\\snaps-controllers\\dist\\services\\offscreen\\OffscreenExecutionService.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\services\\offscreen\\index.cjs", {"./OffscreenExecutionService.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\services\\offscreen\\OffscreenExecutionService.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-controllers%5Cdist%5Cservices%5Coffscreen%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
__exportStar(require("./OffscreenExecutionService.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers",file:"node_modules\\@metamask\\snaps-controllers\\dist\\services\\offscreen\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\services\\proxy\\ProxyExecutionService.cjs", {"../AbstractExecutionService.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\services\\AbstractExecutionService.cjs","../ProxyPostMessageStream.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\services\\ProxyPostMessageStream.cjs","nanoid":"D:\\code\\v\\metamask-extension\\node_modules\\nanoid\\index.browser.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-controllers%5Cdist%5Cservices%5Cproxy%5CProxyExecutionService.cjs
      return function (require, module, exports) {
"use strict";

function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProxyExecutionService = void 0;
const nanoid_1 = require("nanoid");
const AbstractExecutionService_1 = require("../AbstractExecutionService.cjs");
const ProxyPostMessageStream_1 = require("../ProxyPostMessageStream.cjs");
var _stream = /*#__PURE__*/new WeakMap();
class ProxyExecutionService extends AbstractExecutionService_1.AbstractExecutionService {
  /**
   * Create a new proxy execution service.
   *
   * @param args - The constructor arguments.
   * @param args.messenger - The messenger to use for communication with the
   * `SnapController`.
   * @param args.setupSnapProvider - The function to use to set up the snap
   * provider.
   * @param args.stream - The stream to use for communicating with the proxy
   * executor.
   */
  constructor({
    stream,
    messenger,
    setupSnapProvider,
    ...args
  }) {
    super({
      ...args,
      messenger,
      setupSnapProvider,
      usePing: false
    });
    _classPrivateFieldInitSpec(this, _stream, void 0);
    _classPrivateFieldSet(_stream, this, stream);
  }
  /**
   * Send a termination command to the proxy stream.
   *
   * @param job - The job to terminate.
   */
  // TODO: Either fix this lint violation or explain why it's necessary to
  //  ignore.
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  async terminateJob(job) {
    // The `AbstractExecutionService` will have already closed the job stream,
    // so we write to the runtime stream directly.
    _classPrivateFieldGet(_stream, this).write({
      jobId: job.id,
      data: {
        jsonrpc: '2.0',
        method: 'terminateJob',
        id: (0, nanoid_1.nanoid)()
      }
    });
  }
  /**
   * Create a new stream for the specified Snap. This wraps the root stream
   * in a stream specific to the Snap.
   *
   * @param snapId - The Snap ID.
   * @returns An object with the worker ID and stream.
   */
  async initEnvStream(snapId) {
    this.setSnapStatus(snapId, 'initializing');
    const stream = new ProxyPostMessageStream_1.ProxyPostMessageStream({
      stream: _classPrivateFieldGet(_stream, this),
      jobId: snapId
    });
    // Send a request and await any response before continuing
    // This simulates the behaviour of non-proxy environments by effectively awaiting
    // the load of the environment inside the proxy environment
    // This assumes the proxy environment is already loaded before this function is called
    await new Promise(resolve => {
      stream.once('data', resolve);
      stream.write({
        name: 'command',
        data: {
          jsonrpc: '2.0',
          method: 'ping',
          id: (0, nanoid_1.nanoid)()
        }
      });
    });
    return {
      worker: snapId,
      stream
    };
  }
}
exports.ProxyExecutionService = ProxyExecutionService;

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers",file:"node_modules\\@metamask\\snaps-controllers\\dist\\services\\proxy\\ProxyExecutionService.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\snaps\\SnapController.cjs", {"../fsm.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\fsm.cjs","../logging.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\logging.cjs","../utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\utils.cjs","./Timer.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\snaps\\Timer.cjs","./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\snaps\\constants.cjs","./location/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\snaps\\location\\index.cjs","./registry/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\snaps\\registry\\index.cjs","./selectors.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-controllers\\dist\\snaps\\selectors.cjs","@metamask/approval-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\approval-controller\\dist\\index.cjs","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-rpc-methods":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\index.cjs","@metamask/snaps-sdk":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","@xstate/fsm":"D:\\code\\v\\metamask-extension\\node_modules\\@xstate\\fsm\\lib\\index.js","async-mutex":"D:\\code\\v\\metamask-extension\\node_modules\\async-mutex\\lib\\index.js","nanoid":"D:\\code\\v\\metamask-extension\\node_modules\\nanoid\\index.browser.cjs","semver":"D:\\code\\v\\metamask-extension\\node_modules\\semver\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-controllers%5Cdist%5Csnaps%5CSnapController.cjs
      return function (require, module, exports) {
"use strict";

function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapController = exports.SNAP_APPROVAL_RESULT = exports.SNAP_APPROVAL_UPDATE = exports.SNAP_APPROVAL_INSTALL = exports.controllerName = void 0;
const approval_controller_1 = require("@metamask/approval-controller");
const base_controller_1 = require("@metamask/base-controller");
const permission_controller_1 = require("@metamask/permission-controller");
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_rpc_methods_1 = require("@metamask/snaps-rpc-methods");
const snaps_sdk_1 = require("@metamask/snaps-sdk");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
const fsm_1 = require("@xstate/fsm");
const async_mutex_1 = require("async-mutex");
const nanoid_1 = require("nanoid");
const semver_1 = require("semver");
const constants_1 = require("./constants.cjs");
const location_1 = require("./location/index.cjs");
const registry_1 = require("./registry/index.cjs");
const selectors_1 = require("./selectors.cjs");
const Timer_1 = require("./Timer.cjs");
const fsm_2 = require("../fsm.cjs");
const logging_1 = require("../logging.cjs");
const utils_2 = require("../utils.cjs");
exports.controllerName = 'SnapController';
// TODO: Figure out how to name these
exports.SNAP_APPROVAL_INSTALL = 'wallet_installSnap';
exports.SNAP_APPROVAL_UPDATE = 'wallet_updateSnap';
exports.SNAP_APPROVAL_RESULT = 'wallet_installSnapResult';
const TRUNCATED_SNAP_PROPERTIES = new Set(['initialPermissions', 'id', 'version', 'enabled', 'blocked']);
const defaultState = {
  snaps: {},
  snapStates: {},
  unencryptedSnapStates: {}
};
/**
 * Truncates the properties of a snap to only ones that are easily serializable.
 *
 * @param snap - The snap to truncate.
 * @returns Object with serializable snap properties.
 */
function truncateSnap(snap) {
  const truncatedSnap = Object.keys(snap).reduce((serialized, key) => {
    if (TRUNCATED_SNAP_PROPERTIES.has(key)) {
      serialized[key] = snap[key];
    }
    return serialized;
  }, {});
  return truncatedSnap;
}
/*
 * A snap is initialized in three phases:
 * - Add: Loads the snap from a remote source and parses it.
 * - Authorize: Requests the snap's required permissions from the user.
 * - Start: Initializes the snap in its SES realm with the authorized permissions.
 */
var _closeAllConnections = /*#__PURE__*/new WeakMap();
var _dynamicPermissions = /*#__PURE__*/new WeakMap();
var _environmentEndowmentPermissions = /*#__PURE__*/new WeakMap();
var _excludedPermissions = /*#__PURE__*/new WeakMap();
var _featureFlags = /*#__PURE__*/new WeakMap();
var _fetchFunction = /*#__PURE__*/new WeakMap();
var _idleTimeCheckInterval = /*#__PURE__*/new WeakMap();
var _maxIdleTime = /*#__PURE__*/new WeakMap();
var _encryptor = /*#__PURE__*/new WeakMap();
var _getMnemonicSeed = /*#__PURE__*/new WeakMap();
var _getFeatureFlags = /*#__PURE__*/new WeakMap();
var _clientCryptography = /*#__PURE__*/new WeakMap();
var _detectSnapLocation = /*#__PURE__*/new WeakMap();
var _snapsRuntimeData = /*#__PURE__*/new WeakMap();
var _rollbackSnapshots = /*#__PURE__*/new WeakMap();
var _timeoutForLastRequestStatus = /*#__PURE__*/new WeakMap();
var _statusMachine = /*#__PURE__*/new WeakMap();
var _preinstalledSnaps = /*#__PURE__*/new WeakMap();
var _trackEvent = /*#__PURE__*/new WeakMap();
var _trackSnapExport = /*#__PURE__*/new WeakMap();
var _SnapController_brand = /*#__PURE__*/new WeakSet();
var _persistSnapState = /*#__PURE__*/new WeakMap();
class SnapController extends base_controller_1.BaseController {
  constructor({
    closeAllConnections,
    messenger,
    state: _state,
    dynamicPermissions = ['eth_accounts'],
    environmentEndowmentPermissions = [],
    excludedPermissions = {},
    idleTimeCheckInterval = (0, utils_1.inMilliseconds)(5, utils_1.Duration.Second),
    maxIdleTime = (0, utils_1.inMilliseconds)(30, utils_1.Duration.Second),
    maxRequestTime = (0, utils_1.inMilliseconds)(60, utils_1.Duration.Second),
    fetchFunction = globalThis.fetch.bind(undefined),
    featureFlags = {},
    detectSnapLocation: detectSnapLocationFunction = location_1.detectSnapLocation,
    preinstalledSnaps: _preinstalledSnaps2 = null,
    encryptor,
    getMnemonicSeed,
    getFeatureFlags = () => ({}),
    clientCryptography,
    trackEvent
  }) {
    var _this$state;
    super({
      messenger,
      metadata: {
        snapStates: {
          includeInStateLogs: false,
          persist: true,
          anonymous: false,
          usedInUi: false
        },
        unencryptedSnapStates: {
          includeInStateLogs: false,
          persist: true,
          anonymous: false,
          usedInUi: false
        },
        snaps: {
          includeInStateLogs: snaps => {
            // Delete larger snap properties
            return Object.values(snaps).reduce((acc, snap) => {
              const snapCopy = {
                ...snap
              };
              delete snapCopy.sourceCode;
              delete snapCopy.auxiliaryFiles;
              acc[snap.id] = snapCopy;
              return acc;
            }, {});
          },
          persist: snaps => {
            return Object.values(snaps)
            // We should not persist snaps that are in the installing state,
            // since they haven't completed installation and would be unusable
            .filter(snap => snap.status !== snaps_utils_1.SnapStatus.Installing).map(snap => {
              return {
                ...snap,
                // At the time state is rehydrated, no snap will be running.
                status: snaps_utils_1.SnapStatus.Stopped
              };
            }).reduce((memo, snap) => {
              memo[snap.id] = snap;
              return memo;
            }, {});
          },
          anonymous: false,
          // TODO: Ensure larger snap properties are not sent to the UI
          // Currently these are stripped out manually in the extension
          usedInUi: true
        }
      },
      name: exports.controllerName,
      state: {
        ...defaultState,
        ..._state
      }
    });
    /**
     * We track status of a Snap using a finite-state-machine.
     * It keeps track of whether the snap is started / stopped / etc.
     *
     * @see {@link SnapController.transition} for interacting with the machine.
     */
    // We initialize the machine in the instance because the status is currently tightly coupled
    // with the SnapController - the guard checks for enabled status inside the SnapController state.
    // In the future, side-effects could be added to the machine during transitions.
    _classPrivateMethodInitSpec(this, _SnapController_brand);
    _classPrivateFieldInitSpec(this, _closeAllConnections, void 0);
    _classPrivateFieldInitSpec(this, _dynamicPermissions, void 0);
    _classPrivateFieldInitSpec(this, _environmentEndowmentPermissions, void 0);
    _classPrivateFieldInitSpec(this, _excludedPermissions, void 0);
    _classPrivateFieldInitSpec(this, _featureFlags, void 0);
    _classPrivateFieldInitSpec(this, _fetchFunction, void 0);
    _classPrivateFieldInitSpec(this, _idleTimeCheckInterval, void 0);
    _classPrivateFieldInitSpec(this, _maxIdleTime, void 0);
    // This property cannot be hash private yet because of tests.
    // eslint-disable-next-line no-restricted-syntax
    _defineProperty(this, "maxRequestTime", void 0);
    _classPrivateFieldInitSpec(this, _encryptor, void 0);
    _classPrivateFieldInitSpec(this, _getMnemonicSeed, void 0);
    _classPrivateFieldInitSpec(this, _getFeatureFlags, void 0);
    _classPrivateFieldInitSpec(this, _clientCryptography, void 0);
    _classPrivateFieldInitSpec(this, _detectSnapLocation, void 0);
    _classPrivateFieldInitSpec(this, _snapsRuntimeData, void 0);
    _classPrivateFieldInitSpec(this, _rollbackSnapshots, void 0);
    _classPrivateFieldInitSpec(this, _timeoutForLastRequestStatus, void 0);
    _classPrivateFieldInitSpec(this, _statusMachine, void 0);
    _classPrivateFieldInitSpec(this, _preinstalledSnaps, void 0);
    _classPrivateFieldInitSpec(this, _trackEvent, void 0);
    _classPrivateFieldInitSpec(this, _trackSnapExport, void 0);
    /**
     * Persist the state of a Snap.
     *
     * This function is debounced per Snap, meaning that multiple calls to this
     * function for the same Snap will only result in one state update. It also
     * uses a mutex to ensure that only one state update per Snap is processed at
     * a time, avoiding possible race conditions.
     *
     * @param snapId - The Snap ID.
     * @param newSnapState - The new state of the Snap.
     * @param encrypted - A flag to indicate whether to use encrypted storage or
     * not.
     */
    _classPrivateFieldInitSpec(this, _persistSnapState, (0, utils_2.debouncePersistState)((snapId, newSnapState, encrypted) => {
      const runtime = _assertClassBrand(_SnapController_brand, this, _getRuntimeExpect).call(this, snapId);
      runtime.stateMutex.runExclusive(async () => {
        const newState = await _assertClassBrand(_SnapController_brand, this, _getStateToPersist).call(this, snapId, newSnapState, encrypted);
        if (encrypted) {
          return this.update(state => {
            state.snapStates[snapId] = newState;
          });
        }
        return this.update(state => {
          state.unencryptedSnapStates[snapId] = newState;
        });
      }).catch(snaps_utils_1.logError);
    }, constants_1.STATE_DEBOUNCE_TIMEOUT));
    _classPrivateFieldSet(_closeAllConnections, this, closeAllConnections);
    _classPrivateFieldSet(_dynamicPermissions, this, dynamicPermissions);
    _classPrivateFieldSet(_environmentEndowmentPermissions, this, environmentEndowmentPermissions);
    _classPrivateFieldSet(_excludedPermissions, this, excludedPermissions);
    _classPrivateFieldSet(_featureFlags, this, featureFlags);
    _classPrivateFieldSet(_fetchFunction, this, fetchFunction);
    _classPrivateFieldSet(_idleTimeCheckInterval, this, idleTimeCheckInterval);
    _classPrivateFieldSet(_maxIdleTime, this, maxIdleTime);
    this.maxRequestTime = maxRequestTime;
    _classPrivateFieldSet(_detectSnapLocation, this, detectSnapLocationFunction);
    _classPrivateFieldSet(_encryptor, this, encryptor);
    _classPrivateFieldSet(_getMnemonicSeed, this, getMnemonicSeed);
    _classPrivateFieldSet(_getFeatureFlags, this, getFeatureFlags);
    _classPrivateFieldSet(_clientCryptography, this, clientCryptography);
    _classPrivateFieldSet(_preinstalledSnaps, this, _preinstalledSnaps2);
    this._onUnhandledSnapError = this._onUnhandledSnapError.bind(this);
    this._onOutboundRequest = this._onOutboundRequest.bind(this);
    this._onOutboundResponse = this._onOutboundResponse.bind(this);
    _classPrivateFieldSet(_rollbackSnapshots, this, new Map());
    _classPrivateFieldSet(_snapsRuntimeData, this, new Map());
    _classPrivateFieldSet(_trackEvent, this, trackEvent);
    _assertClassBrand(_SnapController_brand, this, _pollForLastRequestStatus).call(this);
    /* eslint-disable @typescript-eslint/unbound-method */
    this.messagingSystem.subscribe('ExecutionService:unhandledError', this._onUnhandledSnapError);
    this.messagingSystem.subscribe('ExecutionService:outboundRequest', this._onOutboundRequest);
    this.messagingSystem.subscribe('ExecutionService:outboundResponse', this._onOutboundResponse);
    /* eslint-enable @typescript-eslint/unbound-method */
    this.messagingSystem.subscribe('SnapController:snapInstalled', ({
      id
    }, origin) => {
      _assertClassBrand(_SnapController_brand, this, _callLifecycleHook).call(this, origin, id, snaps_utils_1.HandlerType.OnInstall).catch(error => {
        (0, snaps_utils_1.logError)(`Error when calling \`onInstall\` lifecycle hook for snap "${id}": ${(0, snaps_sdk_1.getErrorMessage)(error)}`);
      });
    });
    this.messagingSystem.subscribe('SnapController:snapUpdated', ({
      id
    }, _oldVersion, origin) => {
      _assertClassBrand(_SnapController_brand, this, _callLifecycleHook).call(this, origin, id, snaps_utils_1.HandlerType.OnUpdate).catch(error => {
        (0, snaps_utils_1.logError)(`Error when calling \`onUpdate\` lifecycle hook for snap "${id}": ${(0, snaps_sdk_1.getErrorMessage)(error)}`);
      });
    });
    this.messagingSystem.subscribe('KeyringController:lock', _assertClassBrand(_SnapController_brand, this, _handleLock).bind(this));
    _assertClassBrand(_SnapController_brand, this, _initializeStateMachine).call(this);
    _assertClassBrand(_SnapController_brand, this, _registerMessageHandlers).call(this);
    Object.values(((_this$state = this.state) === null || _this$state === void 0 ? void 0 : _this$state.snaps) ?? {}).forEach(snap => _assertClassBrand(_SnapController_brand, this, _setupRuntime).call(this, snap.id));
    if (_classPrivateFieldGet(_preinstalledSnaps, this)) {
      _assertClassBrand(_SnapController_brand, this, _handlePreinstalledSnaps).call(this, _classPrivateFieldGet(_preinstalledSnaps, this));
    }
    _classPrivateFieldSet(_trackSnapExport, this, (0, utils_2.throttleTracking)((snapId, handler, success, origin) => {
      const snapMetadata = this.messagingSystem.call('SnapsRegistry:getMetadata', snapId);
      _classPrivateFieldGet(_trackEvent, this).call(this, {
        event: 'Snap Export Used',
        category: 'Snaps',
        properties: {
          // eslint-disable-next-line @typescript-eslint/naming-convention
          snap_id: snapId,
          export: handler,
          // eslint-disable-next-line @typescript-eslint/naming-convention
          snap_category: snapMetadata === null || snapMetadata === void 0 ? void 0 : snapMetadata.category,
          success,
          origin
        }
      });
    }));
  }
  /**
   * Initialise the SnapController.
   *
   * Currently this method calls the `onStart` lifecycle hook for all
   * runnable Snaps.
   */
  init() {
    _assertClassBrand(_SnapController_brand, this, _callLifecycleHooks).call(this, constants_1.METAMASK_ORIGIN, snaps_utils_1.HandlerType.OnStart);
  }
  /**
   * Checks all installed snaps against the block list and
   * blocks/unblocks snaps as appropriate. See {@link SnapController.blockSnap}
   * for more information.
   *
   * Also updates any preinstalled Snaps to the latest allowlisted version.
   */
  async updateRegistry() {
    _assertClassBrand(_SnapController_brand, this, _assertCanUsePlatform).call(this);
    await this.messagingSystem.call('SnapsRegistry:update');
    const blockedSnaps = await this.messagingSystem.call('SnapsRegistry:get', Object.values(this.state.snaps).reduce((blockListArg, snap) => {
      blockListArg[snap.id] = {
        version: snap.version,
        checksum: snap.manifest.source.shasum
      };
      return blockListArg;
    }, {}));
    await Promise.all(Object.entries(blockedSnaps).map(async ([snapId, {
      status,
      reason
    }]) => {
      if (status === registry_1.SnapsRegistryStatus.Blocked) {
        return _assertClassBrand(_SnapController_brand, this, _blockSnap).call(this, snapId, reason);
      }
      return _assertClassBrand(_SnapController_brand, this, _unblockSnap).call(this, snapId);
    }));
    if (!_classPrivateFieldGet(_featureFlags, this).autoUpdatePreinstalledSnaps) {
      return;
    }
    const preinstalledVersionRange = '*';
    await Promise.allSettled(Object.values(this.state.snaps).filter(snap => snap.preinstalled).map(async snap => {
      const resolvedVersion = await _assertClassBrand(_SnapController_brand, this, _resolveAllowlistVersion).call(this, snap.id, preinstalledVersionRange);
      if (resolvedVersion !== preinstalledVersionRange && (0, utils_1.gtVersion)(resolvedVersion, snap.version)) {
        const location = _classPrivateFieldGet(_detectSnapLocation, this).call(this, snap.id, {
          versionRange: resolvedVersion,
          fetch: _classPrivateFieldGet(_fetchFunction, this),
          allowLocal: false
        });
        await _assertClassBrand(_SnapController_brand, this, _updateSnap).call(this, {
          origin: approval_controller_1.ORIGIN_METAMASK,
          snapId: snap.id,
          location,
          versionRange: resolvedVersion,
          automaticUpdate: true
        });
      }
    }));
  }
  /**
   * Blocks an installed snap and prevents it from being started again. Emits
   * {@link SnapBlocked}. Does nothing if the snap is not installed.
   *
   * @param snapId - The snap to block.
   * @param blockedSnapInfo - Information detailing why the snap is blocked.
   */

  _onUnhandledSnapError(snapId, error) {
    // Log the error that caused the crash
    // so it gets raised to the developer for debugging purposes.
    (0, snaps_utils_1.logError)(`Unhandled error from "${snapId}":`, error);
    this.stopSnap(snapId, snaps_utils_1.SnapStatusEvents.Crash).catch(stopSnapError => {
      // TODO: Decide how to handle errors.
      (0, snaps_utils_1.logError)(stopSnapError);
    });
  }
  _onOutboundRequest(snapId) {
    const runtime = _assertClassBrand(_SnapController_brand, this, _getRuntimeExpect).call(this, snapId);
    // Ideally we would only pause the pending request that is making the outbound request
    // but right now we don't have a way to know which request initiated the outbound request
    runtime.pendingInboundRequests.filter(pendingRequest => pendingRequest.timer.status === 'running').forEach(pendingRequest => pendingRequest.timer.pause());
    runtime.pendingOutboundRequests += 1;
  }
  _onOutboundResponse(snapId) {
    const runtime = _assertClassBrand(_SnapController_brand, this, _getRuntimeExpect).call(this, snapId);
    runtime.pendingOutboundRequests -= 1;
    if (runtime.pendingOutboundRequests === 0) {
      runtime.pendingInboundRequests.filter(pendingRequest => pendingRequest.timer.status === 'paused').forEach(pendingRequest => pendingRequest.timer.resume());
    }
  }
  /**
   * Transitions between states using `snapStatusStateMachineConfig` as the template to figure out
   * the next state. This transition function uses a very minimal subset of XState conventions:
   * - supports initial state
   * - .on supports raw event target string
   * - .on supports {target, cond} object
   * - the arguments for `cond` is the `SerializedSnap` instead of Xstate convention of `(event,
   * context) => boolean`
   *
   * @param snapId - The id of the snap to transition.
   * @param event - The event enum to use to transition.
   */

  /**
   * Starts the given snap. Throws an error if no such snap exists
   * or if it is already running.
   *
   * @param snapId - The id of the Snap to start.
   */
  async startSnap(snapId) {
    _assertClassBrand(_SnapController_brand, this, _assertCanUsePlatform).call(this);
    const snap = this.state.snaps[snapId];
    if (!snap.enabled) {
      throw new Error(`Snap "${snapId}" is disabled.`);
    }
    await _assertClassBrand(_SnapController_brand, this, _startSnap).call(this, {
      snapId,
      sourceCode: snap.sourceCode
    });
  }
  /**
   * Enables the given snap. A snap can only be started if it is enabled. A snap
   * can only be enabled if it isn't blocked.
   *
   * @param snapId - The id of the Snap to enable.
   */
  enableSnap(snapId) {
    this.getExpect(snapId);
    if (this.state.snaps[snapId].blocked) {
      throw new Error(`Snap "${snapId}" is blocked and cannot be enabled.`);
    }
    this.update(state => {
      state.snaps[snapId].enabled = true;
    });
    this.messagingSystem.publish('SnapController:snapEnabled', this.getTruncatedExpect(snapId));
  }
  /**
   * Disables the given snap. A snap can only be started if it is enabled.
   *
   * @param snapId - The id of the Snap to disable.
   * @returns A promise that resolves once the snap has been disabled.
   */
  async disableSnap(snapId) {
    if (!this.has(snapId)) {
      throw new Error(`Snap "${snapId}" not found.`);
    }
    this.update(state => {
      state.snaps[snapId].enabled = false;
    });
    if (this.isRunning(snapId)) {
      await this.stopSnap(snapId, snaps_utils_1.SnapStatusEvents.Stop);
    }
    this.messagingSystem.publish('SnapController:snapDisabled', this.getTruncatedExpect(snapId));
  }
  /**
   * Stops the given snap, removes all hooks, closes all connections, and
   * terminates its worker.
   *
   * @param snapId - The id of the Snap to stop.
   * @param statusEvent - The Snap status event that caused the snap to be
   * stopped.
   */
  async stopSnap(snapId, statusEvent = snaps_utils_1.SnapStatusEvents.Stop) {
    const runtime = _assertClassBrand(_SnapController_brand, this, _getRuntime).call(this, snapId);
    if (!runtime) {
      throw new Error(`The snap "${snapId}" is not running.`);
    }
    // If we are already stopping, wait for that to finish.
    if (runtime.stopPromise) {
      await runtime.stopPromise;
      return;
    }
    // Flag that the Snap is actively stopping, this prevents other calls to stopSnap
    // while we are handling termination of the Snap
    const {
      promise,
      resolve
    } = (0, utils_1.createDeferredPromise)();
    runtime.stopPromise = promise;
    try {
      if (this.isRunning(snapId)) {
        var _classPrivateFieldGet2;
        (_classPrivateFieldGet2 = _classPrivateFieldGet(_closeAllConnections, this)) === null || _classPrivateFieldGet2 === void 0 || _classPrivateFieldGet2.call(this, snapId);
        await _assertClassBrand(_SnapController_brand, this, _terminateSnap).call(this, snapId);
      }
    } finally {
      // Reset request tracking
      runtime.lastRequest = null;
      runtime.pendingInboundRequests = [];
      runtime.pendingOutboundRequests = 0;
      runtime.stopPromise = null;
      if (this.isRunning(snapId)) {
        _assertClassBrand(_SnapController_brand, this, _transition).call(this, snapId, statusEvent);
      }
      resolve();
    }
  }
  /**
   * Stops all running snaps, removes all hooks, closes all connections, and
   * terminates their workers.
   *
   * @param statusEvent - The Snap status event that caused the snap to be
   * stopped.
   */
  async stopAllSnaps(statusEvent = snaps_utils_1.SnapStatusEvents.Stop) {
    const snaps = Object.values(this.state.snaps).filter(snap => this.isRunning(snap.id));
    const promises = snaps.map(async snap => this.stopSnap(snap.id, statusEvent));
    await Promise.allSettled(promises);
  }
  /**
   * Terminates the specified snap and emits the `snapTerminated` event.
   *
   * @param snapId - The snap to terminate.
   */

  /**
   * Returns whether the given snap is running.
   * Throws an error if the snap doesn't exist.
   *
   * @param snapId - The id of the Snap to check.
   * @returns `true` if the snap is running, otherwise `false`.
   */
  isRunning(snapId) {
    return this.getExpect(snapId).status === 'running';
  }
  /**
   * Returns whether the given snap has been added to state.
   *
   * @param snapId - The id of the Snap to check for.
   * @returns `true` if the snap exists in the controller state, otherwise `false`.
   */
  has(snapId) {
    return Boolean(this.get(snapId));
  }
  /**
   * Gets the snap with the given id if it exists, including all data.
   * This should not be used if the snap is to be serializable, as e.g.
   * the snap sourceCode may be quite large.
   *
   * @param snapId - The id of the Snap to get.
   * @returns The entire snap object from the controller state.
   */
  get(snapId) {
    return this.state.snaps[snapId];
  }
  /**
   * Gets the snap with the given id, throws if doesn't.
   * This should not be used if the snap is to be serializable, as e.g.
   * the snap sourceCode may be quite large.
   *
   * @see {@link SnapController.get}
   * @throws {@link Error}. If the snap doesn't exist
   * @param snapId - The id of the snap to get.
   * @returns The entire snap object.
   */
  getExpect(snapId) {
    const snap = this.get(snapId);
    (0, utils_1.assert)(snap !== undefined, `Snap "${snapId}" not found.`);
    return snap;
  }
  /**
   * Gets the snap with the given id if it exists, excluding any
   * non-serializable or expensive-to-serialize data.
   *
   * @param snapId - The id of the Snap to get.
   * @returns A truncated version of the snap state, that is less expensive to serialize.
   */
  // TODO(ritave): this.get returns undefined, this.getTruncated returns null
  getTruncated(snapId) {
    const snap = this.get(snapId);
    return snap ? truncateSnap(snap) : null;
  }
  /**
   * Gets the snap with the given id, throw if it doesn't exist.
   *
   * @throws {@link Error}. If snap doesn't exist
   * @param snapId - The id of the snap to get.
   * @returns A truncated version of the snap state, that is less expensive to serialize.
   */
  getTruncatedExpect(snapId) {
    return truncateSnap(this.getExpect(snapId));
  }
  /**
   * Check if a given Snap has a cached encryption key stored in the runtime.
   *
   * @param snapId - The Snap ID.
   * @param runtime - The Snap runtime data.
   * @returns True if the Snap has a cached encryption key, otherwise false.
   */

  /**
   * Updates the own state of the snap with the given id.
   * This is distinct from the state MetaMask uses to manage snaps.
   *
   * @param snapId - The id of the Snap whose state should be updated.
   * @param newSnapState - The new state of the snap.
   * @param encrypted - A flag to indicate whether to use encrypted storage or not.
   */
  async updateSnapState(snapId, newSnapState, encrypted) {
    const runtime = _assertClassBrand(_SnapController_brand, this, _getRuntimeExpect).call(this, snapId);
    if (encrypted) {
      runtime.state = newSnapState;
    } else {
      runtime.unencryptedState = newSnapState;
    }
    _classPrivateFieldGet(_persistSnapState, this).call(this, snapId, newSnapState, encrypted);
  }
  /**
   * Clears the state of the snap with the given id.
   * This is distinct from the state MetaMask uses to manage snaps.
   *
   * @param snapId - The id of the Snap whose state should be cleared.
   * @param encrypted - A flag to indicate whether to use encrypted storage or not.
   */
  clearSnapState(snapId, encrypted) {
    const runtime = _assertClassBrand(_SnapController_brand, this, _getRuntimeExpect).call(this, snapId);
    if (encrypted) {
      runtime.state = null;
    } else {
      runtime.unencryptedState = null;
    }
    _classPrivateFieldGet(_persistSnapState, this).call(this, snapId, null, encrypted);
  }
  /**
   * Gets the own state of the snap with the given id.
   * This is distinct from the state MetaMask uses to manage snaps.
   *
   * @param snapId - The id of the Snap whose state to get.
   * @param encrypted - A flag to indicate whether to use encrypted storage or not.
   * @returns The requested snap state or null if no state exists.
   */
  async getSnapState(snapId, encrypted) {
    const runtime = _assertClassBrand(_SnapController_brand, this, _getRuntimeExpect).call(this, snapId);
    return await runtime.getStateMutex.runExclusive(async () => {
      const cachedState = encrypted ? runtime.state : runtime.unencryptedState;
      if (cachedState !== undefined) {
        return cachedState;
      }
      const state = encrypted ? this.state.snapStates[snapId] : this.state.unencryptedSnapStates[snapId];
      if (state === null || state === undefined) {
        return null;
      }
      if (!encrypted) {
        // For performance reasons, we do not validate that the state is JSON,
        // since we control serialization.
        const json = JSON.parse(state);
        runtime.unencryptedState = json;
        return json;
      }
      const decrypted = await _assertClassBrand(_SnapController_brand, this, _decryptSnapState).call(this, snapId, state);
      // eslint-disable-next-line require-atomic-updates
      runtime.state = decrypted;
      return decrypted;
    });
  }
  /**
   * Gets a static auxiliary snap file in a chosen file encoding.
   *
   * @param snapId - The id of the Snap whose state to get.
   * @param path - The path to the requested file.
   * @param encoding - An optional requested file encoding.
   * @returns The file requested in the chosen file encoding or null if the file is not found.
   */
  async getSnapFile(snapId, path, encoding = snaps_sdk_1.AuxiliaryFileEncoding.Base64) {
    var _snap$auxiliaryFiles;
    const snap = this.getExpect(snapId);
    const normalizedPath = (0, snaps_utils_1.normalizeRelative)(path);
    const value = (_snap$auxiliaryFiles = snap.auxiliaryFiles) === null || _snap$auxiliaryFiles === void 0 || (_snap$auxiliaryFiles = _snap$auxiliaryFiles.find(file => file.path === normalizedPath)) === null || _snap$auxiliaryFiles === void 0 ? void 0 : _snap$auxiliaryFiles.value;
    if (!value) {
      return null;
    }
    const encoded = await (0, snaps_utils_1.encodeAuxiliaryFile)(value, encoding);
    (0, utils_1.assert)(encoded.length < snaps_utils_1.MAX_FILE_SIZE, `Failed to encode static file to "${encoding}": Static files must be less than 64 MB when encoded.`);
    return encoded;
  }
  /**
   * Determine if a given Snap ID supports a given minimum version of the Snaps platform
   * by inspecting the platformVersion in the Snap manifest.
   *
   * @param snapId - The Snap ID.
   * @param version - The version.
   * @returns True if the platform version is equal or greater to the passed version, false otherwise.
   */
  isMinimumPlatformVersion(snapId, version) {
    const snap = this.getExpect(snapId);
    const {
      platformVersion
    } = snap.manifest;
    if (!platformVersion) {
      return false;
    }
    return (0, semver_1.gte)(platformVersion, version);
  }
  /**
   * Completely clear the controller's state: delete all associated data,
   * handlers, event listeners, and permissions; tear down all snap providers.
   */
  async clearState() {
    const snapIds = Object.keys(this.state.snaps);
    await this.stopAllSnaps();
    snapIds.forEach(snapId => _assertClassBrand(_SnapController_brand, this, _revokeAllSnapPermissions).call(this, snapId));
    this.update(state => {
      state.snaps = {};
      state.snapStates = {};
      state.unencryptedSnapStates = {};
    });
    _classPrivateFieldGet(_snapsRuntimeData, this).clear();
    _classPrivateFieldGet(_rollbackSnapshots, this).clear();
    // We want to remove all snaps & permissions, except for preinstalled snaps
    if (_classPrivateFieldGet(_preinstalledSnaps, this)) {
      _assertClassBrand(_SnapController_brand, this, _handlePreinstalledSnaps).call(this, _classPrivateFieldGet(_preinstalledSnaps, this));
    }
  }
  /**
   * Removes the given snap from state, and clears all associated handlers
   * and listeners.
   *
   * @param snapId - The id of the Snap.
   * @returns A promise that resolves once the snap has been removed.
   */
  async removeSnap(snapId) {
    return this.removeSnaps([snapId]);
  }
  /**
   * Stops the given snaps, removes them from state, and clears all associated
   * permissions, handlers, and listeners.
   *
   * @param snapIds - The ids of the Snaps.
   */
  async removeSnaps(snapIds) {
    if (!Array.isArray(snapIds)) {
      throw new Error('Expected array of snap ids.');
    }
    snapIds.forEach(snapId => {
      const snap = this.getExpect(snapId);
      (0, utils_1.assert)(snap.removable !== false, `${snapId} is not removable.`);
    });
    await Promise.all(snapIds.map(async snapId => {
      const snap = this.getExpect(snapId);
      const truncated = this.getTruncatedExpect(snapId);
      // Disable the snap and revoke all of its permissions before deleting
      // it. This ensures that the snap will not be restarted or otherwise
      // affect the host environment while we are deleting it.
      await this.disableSnap(snapId);
      _assertClassBrand(_SnapController_brand, this, _revokeAllSnapPermissions).call(this, snapId);
      _assertClassBrand(_SnapController_brand, this, _removeSnapFromSubjects).call(this, snapId);
      _classPrivateFieldGet(_snapsRuntimeData, this).delete(snapId);
      this.update(state => {
        delete state.snaps[snapId];
        delete state.snapStates[snapId];
        delete state.unencryptedSnapStates[snapId];
      });
      // If the snap has been fully installed before, also emit snapUninstalled.
      if (snap.status !== snaps_utils_1.SnapStatus.Installing) {
        this.messagingSystem.publish(`SnapController:snapUninstalled`, truncated);
      }
    }));
  }
  /**
   * Removes a snap's permission (caveat) from the specified subject.
   *
   * @param origin - The origin from which to remove the snap.
   * @param snapId - The id of the snap to remove.
   */
  removeSnapFromSubject(origin, snapId) {
    var _subjectPermissions$s, _snapIdsCaveat$value;
    const subjectPermissions = this.messagingSystem.call('PermissionController:getPermissions', origin);
    const snapIdsCaveat = subjectPermissions === null || subjectPermissions === void 0 || (_subjectPermissions$s = subjectPermissions[snaps_rpc_methods_1.WALLET_SNAP_PERMISSION_KEY]) === null || _subjectPermissions$s === void 0 || (_subjectPermissions$s = _subjectPermissions$s.caveats) === null || _subjectPermissions$s === void 0 ? void 0 : _subjectPermissions$s.find(caveat => caveat.type === snaps_utils_1.SnapCaveatType.SnapIds);
    if (!snapIdsCaveat) {
      return;
    }
    const caveatHasSnap = Boolean((_snapIdsCaveat$value = snapIdsCaveat.value) === null || _snapIdsCaveat$value === void 0 ? void 0 : _snapIdsCaveat$value[snapId]);
    if (caveatHasSnap) {
      const newCaveatValue = {
        ...snapIdsCaveat.value
      };
      delete newCaveatValue[snapId];
      if (Object.keys(newCaveatValue).length > 0) {
        this.messagingSystem.call('PermissionController:updateCaveat', origin, snaps_rpc_methods_1.WALLET_SNAP_PERMISSION_KEY, snaps_utils_1.SnapCaveatType.SnapIds, newCaveatValue);
      } else {
        this.messagingSystem.call('PermissionController:revokePermissions', {
          [origin]: [snaps_rpc_methods_1.WALLET_SNAP_PERMISSION_KEY]
        });
      }
    }
  }
  /**
   * Checks if a list of permissions are dynamic and allowed to be revoked, if they are they will all be revoked.
   *
   * @param snapId - The snap ID.
   * @param permissionNames - The names of the permissions.
   * @throws If non-dynamic permissions are passed.
   */
  revokeDynamicSnapPermissions(snapId, permissionNames) {
    (0, utils_1.assert)(permissionNames.every(permissionName => _classPrivateFieldGet(_dynamicPermissions, this).includes(permissionName)), 'Non-dynamic permissions cannot be revoked');
    this.messagingSystem.call('PermissionController:revokePermissions', {
      [snapId]: permissionNames
    });
  }
  /**
   * Removes a snap's permission (caveat) from all subjects.
   *
   * @param snapId - The id of the Snap.
   */

  /**
   * Handles incrementing the activeReferences counter.
   *
   * @param snapId - The snap id of the snap that was referenced.
   */
  incrementActiveReferences(snapId) {
    const runtime = _assertClassBrand(_SnapController_brand, this, _getRuntimeExpect).call(this, snapId);
    runtime.activeReferences += 1;
  }
  /**
   * Handles decrement the activeReferences counter.
   *
   * @param snapId - The snap id of the snap that was referenced..
   */
  decrementActiveReferences(snapId) {
    const runtime = _assertClassBrand(_SnapController_brand, this, _getRuntimeExpect).call(this, snapId);
    (0, utils_1.assert)(runtime.activeReferences > 0, 'SnapController reference management is in an invalid state.');
    runtime.activeReferences -= 1;
  }
  /**
   * Gets all snaps in their truncated format.
   *
   * @returns All installed snaps in their truncated format.
   */
  getAllSnaps() {
    return Object.values(this.state.snaps).map(truncateSnap);
  }
  /**
   * Gets all runnable snaps.
   *
   * @returns All runnable snaps.
   */
  getRunnableSnaps() {
    return (0, selectors_1.getRunnableSnaps)(this.getAllSnaps());
  }
  /**
   * Gets the serialized permitted snaps of the given origin, if any.
   *
   * @param origin - The origin whose permitted snaps to retrieve.
   * @returns The serialized permitted snaps for the origin.
   */
  getPermittedSnaps(origin) {
    var _permissions$snaps_rp;
    const permissions = this.messagingSystem.call('PermissionController:getPermissions', origin) ?? {};
    const snaps = ((_permissions$snaps_rp = permissions[snaps_rpc_methods_1.WALLET_SNAP_PERMISSION_KEY]) === null || _permissions$snaps_rp === void 0 || (_permissions$snaps_rp = _permissions$snaps_rp.caveats) === null || _permissions$snaps_rp === void 0 || (_permissions$snaps_rp = _permissions$snaps_rp.find(caveat => caveat.type === snaps_utils_1.SnapCaveatType.SnapIds)) === null || _permissions$snaps_rp === void 0 ? void 0 : _permissions$snaps_rp.value) ?? {};
    return Object.keys(snaps).reduce((permittedSnaps, snapId) => {
      const snap = this.get(snapId);
      const truncatedSnap = this.getTruncated(snapId);
      if (truncatedSnap && (snap === null || snap === void 0 ? void 0 : snap.status) !== snaps_utils_1.SnapStatus.Installing) {
        permittedSnaps[snapId] = truncatedSnap;
      }
      return permittedSnaps;
    }, {});
  }
  /**
   * Installs the snaps requested by the given origin, returning the snap
   * object if the origin is permitted to install it, and an authorization error
   * otherwise.
   *
   * @param origin - The origin that requested to install the snaps.
   * @param requestedSnaps - The snaps to install.
   * @returns An object of snap ids and snap objects, or errors if a
   * snap couldn't be installed.
   */
  async installSnaps(origin, requestedSnaps) {
    _assertClassBrand(_SnapController_brand, this, _assertCanUsePlatform).call(this);
    const result = {};
    const snapIds = Object.keys(requestedSnaps);
    const pendingUpdates = [];
    const pendingInstalls = [];
    try {
      for (const [snapId, {
        version: rawVersion
      }] of Object.entries(requestedSnaps)) {
        (0, snaps_utils_1.assertIsValidSnapId)(snapId);
        const [error, version] = (0, snaps_utils_1.resolveVersionRange)(rawVersion);
        if (error) {
          throw rpc_errors_1.rpcErrors.invalidParams(`The "version" field must be a valid SemVer version range if specified. Received: "${rawVersion}".`);
        }
        const location = _classPrivateFieldGet(_detectSnapLocation, this).call(this, snapId, {
          versionRange: version,
          fetch: _classPrivateFieldGet(_fetchFunction, this),
          allowLocal: _classPrivateFieldGet(_featureFlags, this).allowLocalSnaps,
          resolveVersion: async range => _classPrivateFieldGet(_featureFlags, this).requireAllowlist ? await _assertClassBrand(_SnapController_brand, this, _resolveAllowlistVersion).call(this, snapId, range) : range
        });
        // Existing snaps may need to be updated, unless they should be re-installed (e.g. local snaps)
        // Everything else is treated as an install
        const isUpdate = this.has(snapId) && !location.shouldAlwaysReload;
        if (isUpdate && _assertClassBrand(_SnapController_brand, this, _isValidUpdate).call(this, snapId, version)) {
          const existingSnap = this.getExpect(snapId);
          pendingUpdates.push({
            snapId,
            oldVersion: existingSnap.version
          });
          let rollbackSnapshot = _assertClassBrand(_SnapController_brand, this, _getRollbackSnapshot).call(this, snapId);
          if (rollbackSnapshot === undefined) {
            rollbackSnapshot = _assertClassBrand(_SnapController_brand, this, _createRollbackSnapshot).call(this, snapId);
            rollbackSnapshot.newVersion = version;
          } else {
            throw new Error('This snap is already being updated.');
          }
        } else if (!isUpdate) {
          pendingInstalls.push(snapId);
        }
        result[snapId] = await _assertClassBrand(_SnapController_brand, this, _processRequestedSnap).call(this, origin, snapId, location, version);
      }
      // Once we finish all installs / updates, emit events.
      pendingInstalls.forEach(snapId => this.messagingSystem.publish(`SnapController:snapInstalled`, this.getTruncatedExpect(snapId), origin, false));
      pendingUpdates.forEach(({
        snapId,
        oldVersion
      }) => this.messagingSystem.publish(`SnapController:snapUpdated`, this.getTruncatedExpect(snapId), oldVersion, origin, false));
      snapIds.forEach(snapId => _classPrivateFieldGet(_rollbackSnapshots, this).delete(snapId));
    } catch (error) {
      const installed = pendingInstalls.filter(snapId => this.has(snapId));
      await this.removeSnaps(installed);
      const snapshottedSnaps = [..._classPrivateFieldGet(_rollbackSnapshots, this).keys()];
      const snapsToRollback = pendingUpdates.map(({
        snapId
      }) => snapId).filter(snapId => snapshottedSnaps.includes(snapId));
      await _assertClassBrand(_SnapController_brand, this, _rollbackSnaps).call(this, snapsToRollback);
      throw error;
    }
    return result;
  }
  /**
   * Adds, authorizes, and runs the given snap with a snap provider.
   * Results from this method should be efficiently serializable.
   *
   * @param origin - The origin requesting the snap.
   * @param snapId - The id of the snap.
   * @param location - The location implementation of the snap.
   * @param versionRange - The semver range of the snap to install.
   * @returns The resulting snap object, or an error if something went wrong.
   */

  destroy() {
    super.destroy();
    if (_classPrivateFieldGet(_timeoutForLastRequestStatus, this)) {
      clearTimeout(_classPrivateFieldGet(_timeoutForLastRequestStatus, this));
    }
    /* eslint-disable @typescript-eslint/unbound-method */
    this.messagingSystem.unsubscribe('ExecutionService:unhandledError', this._onUnhandledSnapError);
    this.messagingSystem.unsubscribe('ExecutionService:outboundRequest', this._onOutboundRequest);
    this.messagingSystem.unsubscribe('ExecutionService:outboundResponse', this._onOutboundResponse);
    this.messagingSystem.clearEventSubscriptions('SnapController:snapInstalled');
    this.messagingSystem.clearEventSubscriptions('SnapController:snapUpdated');
    /* eslint-enable @typescript-eslint/unbound-method */
  }
  /**
   * Passes a JSON-RPC request object to the RPC handler function of a snap.
   *
   * @param options - A bag of options.
   * @param options.snapId - The ID of the recipient snap.
   * @param options.origin - The origin of the RPC request.
   * @param options.handler - The handler to trigger on the snap for the request.
   * @param options.request - The JSON-RPC request object.
   * @returns The result of the JSON-RPC request.
   */
  async handleRequest({
    snapId,
    origin,
    handler: handlerType,
    request: rawRequest
  }) {
    _assertClassBrand(_SnapController_brand, this, _assertCanUsePlatform).call(this);
    (0, utils_1.assert)(origin === constants_1.METAMASK_ORIGIN || (0, snaps_utils_1.isValidUrl)(origin), "'origin' must be a valid URL or 'metamask'.");
    const request = {
      jsonrpc: '2.0',
      id: (0, nanoid_1.nanoid)(),
      ...rawRequest
    };
    (0, utils_1.assertIsJsonRpcRequest)(request);
    const permissionName = snaps_rpc_methods_1.handlerEndowments[handlerType];
    (0, utils_1.assert)(typeof permissionName === 'string' || permissionName === null, "'permissionName' must be either a string or null.");
    const permissions = this.messagingSystem.call('PermissionController:getPermissions', snapId);
    // If permissionName is null, the handler does not require a permission.
    if (permissionName !== null && (!permissions || !(0, utils_1.hasProperty)(permissions, permissionName))) {
      throw new Error(`Snap "${snapId}" is not permitted to use "${permissionName}".`);
    }
    const handlerPermissions = permissionName ? permissions[permissionName] : undefined;
    if (permissionName === snaps_rpc_methods_1.SnapEndowments.Rpc || permissionName === snaps_rpc_methods_1.SnapEndowments.Keyring) {
      (0, utils_1.assert)(handlerPermissions);
      const subject = this.messagingSystem.call('SubjectMetadataController:getSubjectMetadata', origin);
      const origins = permissionName === snaps_rpc_methods_1.SnapEndowments.Rpc ? (0, snaps_rpc_methods_1.getRpcCaveatOrigins)(handlerPermissions) : (0, snaps_rpc_methods_1.getKeyringCaveatOrigins)(handlerPermissions);
      (0, utils_1.assert)(origins);
      if (!(0, snaps_utils_1.isOriginAllowed)(origins, (subject === null || subject === void 0 ? void 0 : subject.subjectType) ?? permission_controller_1.SubjectType.Website, origin)) {
        throw new Error(`Snap "${snapId}" is not permitted to handle requests from "${origin}".`);
      }
    }
    if (origin !== constants_1.METAMASK_ORIGIN && constants_1.CLIENT_ONLY_HANDLERS.includes(handlerType)) {
      throw new Error(`"${handlerType}" can only be invoked by MetaMask.`);
    }
    if (!this.state.snaps[snapId].enabled) {
      throw new Error(`Snap "${snapId}" is disabled.`);
    }
    if (this.state.snaps[snapId].status === snaps_utils_1.SnapStatus.Installing) {
      throw new Error(`Snap "${snapId}" is currently being installed. Please try again later.`);
    }
    const timeout = _assertClassBrand(_SnapController_brand, this, _getExecutionTimeout).call(this, handlerPermissions);
    const runtime = _assertClassBrand(_SnapController_brand, this, _getRuntimeExpect).call(this, snapId);
    if (runtime.stopPromise) {
      await runtime.stopPromise;
    }
    if (!this.isRunning(snapId)) {
      if (!runtime.startPromise) {
        runtime.startPromise = this.startSnap(snapId);
      }
      try {
        await runtime.startPromise;
      } finally {
        runtime.startPromise = null;
      }
    }
    const transformedRequest = _assertClassBrand(_SnapController_brand, this, _transformSnapRpcRequest).call(this, snapId, handlerType, request);
    const timer = new Timer_1.Timer(timeout);
    _assertClassBrand(_SnapController_brand, this, _recordSnapRpcRequestStart).call(this, snapId, transformedRequest.id, timer);
    const handleRpcRequestPromise = this.messagingSystem.call('ExecutionService:handleRpcRequest', snapId, {
      origin,
      handler: handlerType,
      request: transformedRequest
    });
    // This will either get the result or reject due to the timeout.
    try {
      const result = await (0, utils_2.withTimeout)(handleRpcRequestPromise, timer);
      if (result === utils_2.hasTimedOut) {
        const stopping = runtime.stopPromise !== null || !this.isRunning(snapId);
        throw new Error(stopping ? `${snapId} was stopped and the request was cancelled. This is likely because the Snap crashed.` : `${snapId} failed to respond to the request in time.`);
      }
      await _assertClassBrand(_SnapController_brand, this, _assertSnapRpcResponse).call(this, snapId, handlerType, result);
      const transformedResult = await _assertClassBrand(_SnapController_brand, this, _transformSnapRpcResponse).call(this, snapId, handlerType, transformedRequest, result);
      _assertClassBrand(_SnapController_brand, this, _recordSnapRpcRequestFinish).call(this, snapId, transformedRequest.id, handlerType, origin, true);
      return transformedResult;
    } catch (error) {
      // We flag the RPC request as finished early since termination may affect pending requests
      _assertClassBrand(_SnapController_brand, this, _recordSnapRpcRequestFinish).call(this, snapId, transformedRequest.id, handlerType, origin, false);
      const [jsonRpcError, handled] = (0, snaps_utils_1.unwrapError)(error);
      const stopping = runtime.stopPromise !== null || !this.isRunning(snapId);
      if (!handled) {
        if (!stopping) {
          (0, snaps_utils_1.logError)(`"${snapId}" crashed due to an unhandled error:`, jsonRpcError);
        }
        await this.stopSnap(snapId, snaps_utils_1.SnapStatusEvents.Crash);
      }
      throw jsonRpcError;
    }
  }
  /**
   * Set the active state of the client. This will trigger the `onActive` or
   * `onInactive` lifecycle hooks for all Snaps.
   *
   * @param active - A boolean indicating whether the client is active or not.
   */
  setClientActive(active) {
    if (active) {
      _assertClassBrand(_SnapController_brand, this, _callLifecycleHooks).call(this, constants_1.METAMASK_ORIGIN, snaps_utils_1.HandlerType.OnActive);
    } else {
      _assertClassBrand(_SnapController_brand, this, _callLifecycleHooks).call(this, constants_1.METAMASK_ORIGIN, snaps_utils_1.HandlerType.OnInactive);
    }
  }
  /**
   * Determine the execution timeout for a given handler permission.
   *
   * If no permission is specified or the permission itself has no execution timeout defined
   * the constructor argument `maxRequestTime` will be used.
   *
   * @param permission - An optional permission constraint for the handler being called.
   * @returns The execution timeout for the given handler.
   */
}
function _initializeStateMachine() {
  const disableGuard = ({
    snapId
  }) => {
    return this.getExpect(snapId).enabled;
  };
  const statusConfig = {
    initial: snaps_utils_1.SnapStatus.Installing,
    states: {
      [snaps_utils_1.SnapStatus.Installing]: {
        on: {
          [snaps_utils_1.SnapStatusEvents.Start]: {
            target: snaps_utils_1.SnapStatus.Running,
            cond: disableGuard
          }
        }
      },
      [snaps_utils_1.SnapStatus.Updating]: {
        on: {
          [snaps_utils_1.SnapStatusEvents.Start]: {
            target: snaps_utils_1.SnapStatus.Running,
            cond: disableGuard
          },
          [snaps_utils_1.SnapStatusEvents.Stop]: snaps_utils_1.SnapStatus.Stopped
        }
      },
      [snaps_utils_1.SnapStatus.Running]: {
        on: {
          [snaps_utils_1.SnapStatusEvents.Stop]: snaps_utils_1.SnapStatus.Stopped,
          [snaps_utils_1.SnapStatusEvents.Crash]: snaps_utils_1.SnapStatus.Crashed
        }
      },
      [snaps_utils_1.SnapStatus.Stopped]: {
        on: {
          [snaps_utils_1.SnapStatusEvents.Start]: {
            target: snaps_utils_1.SnapStatus.Running,
            cond: disableGuard
          },
          [snaps_utils_1.SnapStatusEvents.Update]: snaps_utils_1.SnapStatus.Updating
        }
      },
      [snaps_utils_1.SnapStatus.Crashed]: {
        on: {
          [snaps_utils_1.SnapStatusEvents.Start]: {
            target: snaps_utils_1.SnapStatus.Running,
            cond: disableGuard
          },
          [snaps_utils_1.SnapStatusEvents.Update]: snaps_utils_1.SnapStatus.Updating
        }
      }
    }
  };
  _classPrivateFieldSet(_statusMachine, this, (0, fsm_1.createMachine)(statusConfig));
  (0, fsm_2.validateMachine)(_classPrivateFieldGet(_statusMachine, this));
}
/**
 * Constructor helper for registering the controller's messaging system
 * actions.
 */
function _registerMessageHandlers() {
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:init`, (...args) => this.init(...args));
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:clearSnapState`, (...args) => this.clearSnapState(...args));
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:get`, (...args) => this.get(...args));
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:getSnapState`, async (...args) => this.getSnapState(...args));
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:handleRequest`, async (...args) => this.handleRequest(...args));
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:has`, (...args) => this.has(...args));
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:updateRegistry`, async () => this.updateRegistry());
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:updateSnapState`, async (...args) => this.updateSnapState(...args));
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:enable`, (...args) => this.enableSnap(...args));
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:disable`, async (...args) => this.disableSnap(...args));
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:remove`, async (...args) => this.removeSnap(...args));
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:getPermitted`, (...args) => this.getPermittedSnaps(...args));
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:install`, async (...args) => this.installSnaps(...args));
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:getAll`, (...args) => this.getAllSnaps(...args));
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:getRunnableSnaps`, (...args) => this.getRunnableSnaps(...args));
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:incrementActiveReferences`, (...args) => this.incrementActiveReferences(...args));
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:decrementActiveReferences`, (...args) => this.decrementActiveReferences(...args));
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:disconnectOrigin`, (...args) => this.removeSnapFromSubject(...args));
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:revokeDynamicPermissions`, (...args) => this.revokeDynamicSnapPermissions(...args));
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:getFile`, async (...args) => this.getSnapFile(...args));
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:stopAllSnaps`, async (...args) => this.stopAllSnaps(...args));
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:isMinimumPlatformVersion`, (...args) => this.isMinimumPlatformVersion(...args));
  this.messagingSystem.registerActionHandler(`${exports.controllerName}:setClientActive`, (...args) => this.setClientActive(...args));
}
function _handlePreinstalledSnaps(preinstalledSnaps) {
  for (const {
    snapId,
    manifest,
    files,
    removable,
    hidden,
    hideSnapBranding
  } of preinstalledSnaps) {
    var _manifest$source$loca;
    const existingSnap = this.get(snapId);
    const isAlreadyInstalled = existingSnap !== undefined;
    const isUpdate = isAlreadyInstalled && (0, utils_1.gtVersion)(manifest.version, existingSnap.version);
    // Disallow downgrades and overwriting non preinstalled snaps
    if (isAlreadyInstalled && (!isUpdate || existingSnap.preinstalled !== true)) {
      continue;
    }
    const manifestFile = new snaps_utils_1.VirtualFile({
      path: snaps_utils_1.NpmSnapFileNames.Manifest,
      value: JSON.stringify(manifest),
      result: manifest
    });
    const virtualFiles = files.map(({
      path,
      value
    }) => new snaps_utils_1.VirtualFile({
      value,
      path
    }));
    const {
      filePath,
      iconPath
    } = manifest.source.location.npm;
    const sourceCode = virtualFiles.find(file => file.path === filePath);
    const svgIcon = iconPath ? virtualFiles.find(file => file.path === iconPath) : undefined;
    (0, utils_1.assert)(sourceCode, 'Source code not provided for preinstalled snap.');
    (0, utils_1.assert)(!iconPath || iconPath && svgIcon, 'Icon not provided for preinstalled snap.');
    (0, utils_1.assert)(manifest.source.files === undefined, 'Auxiliary files are not currently supported for preinstalled snaps.');
    const localizationFiles = ((_manifest$source$loca = manifest.source.locales) === null || _manifest$source$loca === void 0 ? void 0 : _manifest$source$loca.map(path => virtualFiles.find(file => file.path === path))) ?? [];
    const validatedLocalizationFiles = (0, snaps_utils_1.getValidatedLocalizationFiles)(localizationFiles.filter(Boolean));
    (0, utils_1.assert)(localizationFiles.length === validatedLocalizationFiles.length, 'Missing localization files for preinstalled snap.');
    const filesObject = {
      manifest: manifestFile,
      sourceCode,
      svgIcon,
      auxiliaryFiles: [],
      localizationFiles: validatedLocalizationFiles
    };
    // Add snap to the SnapController state
    _assertClassBrand(_SnapController_brand, this, _set).call(this, {
      id: snapId,
      origin: constants_1.METAMASK_ORIGIN,
      files: filesObject,
      removable,
      hidden,
      hideSnapBranding,
      preinstalled: true
    });
    // Setup permissions
    const processedPermissions = (0, snaps_rpc_methods_1.processSnapPermissions)(manifest.initialPermissions);
    _assertClassBrand(_SnapController_brand, this, _validateSnapPermissions).call(this, processedPermissions);
    const {
      newPermissions,
      unusedPermissions
    } = _assertClassBrand(_SnapController_brand, this, _calculatePermissionsChange).call(this, snapId, processedPermissions);
    _assertClassBrand(_SnapController_brand, this, _updatePermissions).call(this, {
      snapId,
      newPermissions,
      unusedPermissions
    });
    if (manifest.initialConnections) {
      _assertClassBrand(_SnapController_brand, this, _handleInitialConnections).call(this, snapId, (existingSnap === null || existingSnap === void 0 ? void 0 : existingSnap.initialConnections) ?? null, manifest.initialConnections);
    }
    // Set status
    this.update(state => {
      state.snaps[snapId].status = snaps_utils_1.SnapStatus.Stopped;
    });
    _assertClassBrand(_SnapController_brand, this, _setupRuntime).call(this, snapId);
    // Emit events
    if (isUpdate) {
      this.messagingSystem.publish('SnapController:snapUpdated', this.getTruncatedExpect(snapId), existingSnap.version, constants_1.METAMASK_ORIGIN, true);
    } else {
      this.messagingSystem.publish('SnapController:snapInstalled', this.getTruncatedExpect(snapId), constants_1.METAMASK_ORIGIN, true);
    }
  }
}
function _pollForLastRequestStatus() {
  _classPrivateFieldSet(_timeoutForLastRequestStatus, this, setTimeout(() => {
    _assertClassBrand(_SnapController_brand, this, _stopSnapsLastRequestPastMax).call(this).catch(error => {
      // TODO: Decide how to handle errors.
      (0, snaps_utils_1.logError)(error);
    });
    _assertClassBrand(_SnapController_brand, this, _pollForLastRequestStatus).call(this);
  }, _classPrivateFieldGet(_idleTimeCheckInterval, this)));
}
async function _blockSnap(snapId, blockedSnapInfo) {
  if (!this.has(snapId)) {
    return;
  }
  try {
    this.update(state => {
      state.snaps[snapId].blocked = true;
      state.snaps[snapId].blockInformation = blockedSnapInfo;
    });
    await this.disableSnap(snapId);
  } catch (error) {
    (0, snaps_utils_1.logError)(`Encountered error when stopping blocked snap "${snapId}".`, error);
  }
  this.messagingSystem.publish(`${exports.controllerName}:snapBlocked`, snapId, blockedSnapInfo);
}
/**
 * Unblocks a snap so that it can be enabled and started again. Emits
 * {@link SnapUnblocked}. Does nothing if the snap is not installed or already
 * unblocked.
 *
 * @param snapId - The id of the snap to unblock.
 */
function _unblockSnap(snapId) {
  if (!this.has(snapId) || !this.state.snaps[snapId].blocked) {
    return;
  }
  this.update(state => {
    state.snaps[snapId].blocked = false;
    delete state.snaps[snapId].blockInformation;
  });
  this.messagingSystem.publish(`${exports.controllerName}:snapUnblocked`, snapId);
}
async function _assertIsInstallAllowed(snapId, {
  platformVersion,
  ...snapInfo
}) {
  const results = await this.messagingSystem.call('SnapsRegistry:get', {
    [snapId]: snapInfo
  });
  const result = results[snapId];
  if (result.status === registry_1.SnapsRegistryStatus.Blocked) {
    var _result$reason;
    throw new Error(`Cannot install version "${snapInfo.version}" of snap "${snapId}": The version is blocked. ${((_result$reason = result.reason) === null || _result$reason === void 0 ? void 0 : _result$reason.explanation) ?? ''}`);
  }
  const isAllowlistingRequired = Object.keys(snapInfo.permissions).some(permission => !constants_1.ALLOWED_PERMISSIONS.includes(permission));
  if (_classPrivateFieldGet(_featureFlags, this).requireAllowlist && isAllowlistingRequired && result.status !== registry_1.SnapsRegistryStatus.Verified) {
    throw new Error(`Cannot install version "${snapInfo.version}" of snap "${snapId}": ${result.status === registry_1.SnapsRegistryStatus.Unavailable ? 'The registry is temporarily unavailable.' : 'The snap is not on the allowlist.'}`);
  }
  _assertClassBrand(_SnapController_brand, this, _validatePlatformVersion).call(this, snapId, platformVersion);
}
/**
 * Asserts whether new Snaps are allowed to be installed.
 */
function _assertCanInstallSnaps() {
  (0, utils_1.assert)(_classPrivateFieldGet(_featureFlags, this).disableSnapInstallation !== true, 'Installing Snaps is currently disabled in this version of MetaMask.');
}
/**
 * Asserts whether the Snaps platform is allowed to run.
 */
function _assertCanUsePlatform() {
  const flags = _classPrivateFieldGet(_getFeatureFlags, this).call(this);
  (0, utils_1.assert)(flags.disableSnaps !== true, 'The Snaps platform requires basic functionality to be used. Enable basic functionality in the settings to use the Snaps platform.');
}
async function _stopSnapsLastRequestPastMax() {
  const entries = [..._classPrivateFieldGet(_snapsRuntimeData, this).entries()];
  return Promise.all(entries.filter(([_snapId, runtime]) => runtime.activeReferences === 0 && runtime.pendingInboundRequests.length === 0 && runtime.lastRequest && _classPrivateFieldGet(_maxIdleTime, this) && (0, utils_1.timeSince)(runtime.lastRequest) > _classPrivateFieldGet(_maxIdleTime, this)).map(async ([snapId]) => this.stopSnap(snapId, snaps_utils_1.SnapStatusEvents.Stop)));
}
function _transition(snapId, event) {
  const {
    interpreter
  } = _assertClassBrand(_SnapController_brand, this, _getRuntimeExpect).call(this, snapId);
  interpreter.send(event);
  this.update(state => {
    state.snaps[snapId].status = interpreter.state.value;
  });
}
async function _terminateSnap(snapId) {
  await this.messagingSystem.call('ExecutionService:terminateSnap', snapId);
  // Hack to give up execution for a bit to let gracefully terminating Snaps return.
  await new Promise(resolve => setTimeout(resolve, 1));
  const runtime = _assertClassBrand(_SnapController_brand, this, _getRuntimeExpect).call(this, snapId);
  // Unresponsive requests may still be timed, time them out.
  runtime.pendingInboundRequests.filter(pendingRequest => pendingRequest.timer.status !== 'finished').forEach(pendingRequest => pendingRequest.timer.finish());
  // Hack to give up execution for a bit to let timed out requests return.
  await new Promise(resolve => setTimeout(resolve, 1));
  this.messagingSystem.publish('SnapController:snapTerminated', this.getTruncatedExpect(snapId));
}
function _hasCachedEncryptionKey(snapId, runtime = _assertClassBrand(_SnapController_brand, this, _getRuntimeExpect).call(this, snapId)) {
  return runtime.encryptionKey !== null && runtime.encryptionSalt !== null;
}
/**
 * Generate an encryption key to be used for state encryption for a given Snap.
 *
 * @param options - An options bag.
 * @param options.snapId - The Snap ID.
 * @param options.salt - A salt to be used for the encryption key.
 * @param options.useCache - Whether to use caching or not.
 * @param options.keyMetadata - Optional metadata about how to derive the encryption key.
 * @returns An encryption key.
 */
async function _getSnapEncryptionKey({
  snapId,
  salt: passedSalt,
  useCache,
  keyMetadata
}) {
  const runtime = _assertClassBrand(_SnapController_brand, this, _getRuntimeExpect).call(this, snapId);
  if (_assertClassBrand(_SnapController_brand, this, _hasCachedEncryptionKey).call(this, snapId, runtime) && useCache) {
    return {
      key: await _classPrivateFieldGet(_encryptor, this).importKey(runtime.encryptionKey),
      salt: runtime.encryptionSalt
    };
  }
  const salt = passedSalt ?? _classPrivateFieldGet(_encryptor, this).generateSalt();
  const seed = await _classPrivateFieldGet(_getMnemonicSeed, this).call(this);
  const entropy = await (0, snaps_rpc_methods_1.getEncryptionEntropy)({
    snapId,
    seed,
    cryptographicFunctions: _classPrivateFieldGet(_clientCryptography, this)
  });
  const encryptionKey = await _classPrivateFieldGet(_encryptor, this).keyFromPassword(entropy, salt, true, keyMetadata);
  const exportedKey = await _classPrivateFieldGet(_encryptor, this).exportKey(encryptionKey);
  // Cache exported encryption key in runtime
  if (useCache) {
    runtime.encryptionKey = exportedKey;
    runtime.encryptionSalt = salt;
  }
  return {
    key: encryptionKey,
    salt
  };
}
/**
 * Decrypt the encrypted state for a given Snap.
 *
 * @param snapId - The Snap ID.
 * @param state - The encrypted state as a string.
 * @returns A valid JSON object derived from the encrypted state.
 * @throws If the decryption fails or the decrypted state is not valid JSON.
 */
async function _decryptSnapState(snapId, state) {
  try {
    // We assume that the state string here is valid JSON since we control serialization.
    // This lets us skip JSON validation.
    const parsed = JSON.parse(state);
    const {
      salt,
      keyMetadata
    } = parsed;
    // We only cache encryption keys if they are already cached or if the encryption key is using the latest key derivation params.
    const useCache = _assertClassBrand(_SnapController_brand, this, _hasCachedEncryptionKey).call(this, snapId) || _classPrivateFieldGet(_encryptor, this).isVaultUpdated(state);
    const {
      key
    } = await _assertClassBrand(_SnapController_brand, this, _getSnapEncryptionKey).call(this, {
      snapId,
      salt,
      useCache,
      // When decrypting state we expect key metadata to be present.
      // If it isn't present, we assume that the Snap state we are decrypting is old enough to use the legacy encryption params.
      keyMetadata: keyMetadata ?? constants_1.LEGACY_ENCRYPTION_KEY_DERIVATION_OPTIONS
    });
    const decryptedState = await _classPrivateFieldGet(_encryptor, this).decryptWithKey(key, parsed);
    // We assume this to be valid JSON, since all RPC requests from a Snap are validated and sanitized.
    return decryptedState;
  } catch {
    throw rpc_errors_1.rpcErrors.internal({
      message: 'Failed to decrypt snap state, the state must be corrupted.'
    });
  }
}
/**
 * Encrypt a JSON state object for a given Snap.
 *
 * Note: This function does not assert the validity of the object,
 * please ensure only valid JSON is passed to it.
 *
 * @param snapId - The Snap ID.
 * @param state - The state object.
 * @returns A string containing the encrypted JSON object.
 */
async function _encryptSnapState(snapId, state) {
  const {
    key,
    salt
  } = await _assertClassBrand(_SnapController_brand, this, _getSnapEncryptionKey).call(this, {
    snapId,
    useCache: true
  });
  const encryptedState = await _classPrivateFieldGet(_encryptor, this).encryptWithKey(key, state);
  encryptedState.salt = salt;
  return JSON.stringify(encryptedState);
}
/**
 * Get the new Snap state to persist based on the given state and encryption
 * flag.
 *
 * - If the state is null, return null.
 * - If the state should be encrypted, return the encrypted state.
 * - Otherwise, if the state should not be encrypted, return the JSON-
 * stringified state.
 *
 * @param snapId - The Snap ID.
 * @param state - The state to persist.
 * @param encrypted - A flag to indicate whether to use encrypted storage or
 * not.
 * @returns The state to persist.
 */
async function _getStateToPersist(snapId, state, encrypted) {
  if (state === null) {
    return null;
  }
  if (encrypted) {
    return await _assertClassBrand(_SnapController_brand, this, _encryptSnapState).call(this, snapId, state);
  }
  return JSON.stringify(state);
}
function _handleInitialConnections(snapId, previousInitialConnections, initialConnections) {
  if (previousInitialConnections) {
    const revokedInitialConnections = (0, utils_2.setDiff)(previousInitialConnections, initialConnections);
    for (const origin of Object.keys(revokedInitialConnections)) {
      this.removeSnapFromSubject(origin, snapId);
    }
  }
  for (const origin of Object.keys(initialConnections)) {
    _assertClassBrand(_SnapController_brand, this, _addSnapToSubject).call(this, origin, snapId);
  }
}
function _addSnapToSubject(origin, snapId) {
  var _subjectPermissions$s2, _existingCaveat$value;
  const subjectPermissions = this.messagingSystem.call('PermissionController:getPermissions', origin);
  const existingCaveat = subjectPermissions === null || subjectPermissions === void 0 || (_subjectPermissions$s2 = subjectPermissions[snaps_rpc_methods_1.WALLET_SNAP_PERMISSION_KEY]) === null || _subjectPermissions$s2 === void 0 || (_subjectPermissions$s2 = _subjectPermissions$s2.caveats) === null || _subjectPermissions$s2 === void 0 ? void 0 : _subjectPermissions$s2.find(caveat => caveat.type === snaps_utils_1.SnapCaveatType.SnapIds);
  const subjectHasSnap = Boolean(existingCaveat === null || existingCaveat === void 0 || (_existingCaveat$value = existingCaveat.value) === null || _existingCaveat$value === void 0 ? void 0 : _existingCaveat$value[snapId]);
  // If the subject is already connected to the snap, this is a no-op.
  if (subjectHasSnap) {
    return;
  }
  // If an existing caveat exists, we add the snap to that.
  if (existingCaveat) {
    this.messagingSystem.call('PermissionController:updateCaveat', origin, snaps_rpc_methods_1.WALLET_SNAP_PERMISSION_KEY, snaps_utils_1.SnapCaveatType.SnapIds, {
      ...existingCaveat.value,
      [snapId]: {}
    });
    return;
  }
  const approvedPermissions = {
    [snaps_rpc_methods_1.WALLET_SNAP_PERMISSION_KEY]: {
      caveats: [{
        type: snaps_utils_1.SnapCaveatType.SnapIds,
        value: {
          [snapId]: {}
        }
      }]
    }
  };
  this.messagingSystem.call('PermissionController:grantPermissions', {
    approvedPermissions,
    subject: {
      origin
    }
  });
}
function _removeSnapFromSubjects(snapId) {
  const subjects = this.messagingSystem.call('PermissionController:getSubjectNames');
  for (const subject of subjects) {
    this.removeSnapFromSubject(subject, snapId);
  }
}
/**
 * Safely revokes all permissions granted to a Snap.
 *
 * @param snapId - The snap ID.
 */
function _revokeAllSnapPermissions(snapId) {
  if (this.messagingSystem.call('PermissionController:hasPermissions', snapId)) {
    this.messagingSystem.call('PermissionController:revokeAllPermissions', snapId);
  }
}
async function _processRequestedSnap(origin, snapId, location, versionRange) {
  const existingSnap = this.getTruncated(snapId);
  // For devX we always re-install local snaps.
  if (existingSnap && !location.shouldAlwaysReload) {
    if ((0, utils_1.satisfiesVersionRange)(existingSnap.version, versionRange)) {
      return existingSnap;
    }
    return await _assertClassBrand(_SnapController_brand, this, _updateSnap).call(this, {
      origin,
      snapId,
      location,
      versionRange
    });
  }
  _assertClassBrand(_SnapController_brand, this, _assertCanInstallSnaps).call(this);
  let pendingApproval = _assertClassBrand(_SnapController_brand, this, _createApproval).call(this, {
    origin,
    snapId,
    type: exports.SNAP_APPROVAL_INSTALL
  });
  this.messagingSystem.publish('SnapController:snapInstallStarted', snapId, origin, false);
  // Existing snaps must be stopped before overwriting
  if (existingSnap && this.isRunning(snapId)) {
    await this.stopSnap(snapId, snaps_utils_1.SnapStatusEvents.Stop);
  }
  // Existing snaps that should be re-installed should not maintain their existing permissions
  if (existingSnap && location.shouldAlwaysReload) {
    _assertClassBrand(_SnapController_brand, this, _revokeAllSnapPermissions).call(this, snapId);
  }
  try {
    const {
      sourceCode
    } = await _assertClassBrand(_SnapController_brand, this, _add).call(this, {
      origin,
      id: snapId,
      location,
      versionRange
    });
    await _assertClassBrand(_SnapController_brand, this, _authorize).call(this, snapId, pendingApproval);
    pendingApproval = _assertClassBrand(_SnapController_brand, this, _createApproval).call(this, {
      origin,
      snapId,
      type: exports.SNAP_APPROVAL_RESULT
    });
    await _assertClassBrand(_SnapController_brand, this, _startSnap).call(this, {
      snapId,
      sourceCode
    });
    const truncated = this.getTruncatedExpect(snapId);
    _assertClassBrand(_SnapController_brand, this, _updateApproval).call(this, pendingApproval.id, {
      loading: false,
      type: exports.SNAP_APPROVAL_INSTALL
    });
    return truncated;
  } catch (error) {
    (0, snaps_utils_1.logError)(`Error when adding ${snapId}.`, error);
    const errorString = error instanceof Error ? error.message : error.toString();
    _assertClassBrand(_SnapController_brand, this, _updateApproval).call(this, pendingApproval.id, {
      loading: false,
      type: exports.SNAP_APPROVAL_INSTALL,
      error: errorString
    });
    this.messagingSystem.publish('SnapController:snapInstallFailed', snapId, origin, false, errorString);
    throw error;
  }
}
function _createApproval({
  origin,
  snapId,
  type
}) {
  const id = (0, nanoid_1.nanoid)();
  const promise = this.messagingSystem.call('ApprovalController:addRequest', {
    origin,
    id,
    type,
    requestData: {
      // Mirror previous installation metadata
      metadata: {
        id,
        origin: snapId,
        dappOrigin: origin
      },
      snapId
    },
    requestState: {
      loading: true
    }
  }, true);
  return {
    id,
    promise
  };
}
function _updateApproval(id, requestState) {
  try {
    this.messagingSystem.call('ApprovalController:updateRequestState', {
      id,
      requestState
    });
  } catch {
    // Do nothing
  }
}
/**
 * Updates an installed snap. The flow is similar to
 * {@link SnapController.installSnaps}. The user will be asked if they want
 * to update, then approve any permission changes, and finally the snap will
 * be restarted.
 *
 * The update will fail if the user rejects any prompt or if the new version
 * of the snap is blocked.
 *
 * If the original version of the snap was blocked and the update succeeded,
 * the snap will be unblocked and enabled before it is restarted.
 *
 * @param options - An options bag.
 * @param options.origin - The origin requesting the snap update.
 * @param options.snapId - The id of the Snap to be updated.
 * @param options.location - The location implementation of the snap.
 * @param options.versionRange - A semver version range in which the maximum version will be chosen.
 * @param options.automaticUpdate - An optional boolean flag to indicate whether this update should be done
 * automatically.
 * @returns The snap metadata if updated, `null` otherwise.
 */
async function _updateSnap({
  origin,
  snapId,
  location,
  versionRange,
  automaticUpdate = false
}) {
  _assertClassBrand(_SnapController_brand, this, _assertCanInstallSnaps).call(this);
  _assertClassBrand(_SnapController_brand, this, _assertCanUsePlatform).call(this);
  const snap = this.getExpect(snapId);
  const {
    preinstalled,
    removable,
    hidden,
    hideSnapBranding
  } = snap;
  if (preinstalled && !automaticUpdate) {
    throw new Error('Preinstalled Snaps cannot be manually updated.');
  }
  let pendingApproval = automaticUpdate ? null : _assertClassBrand(_SnapController_brand, this, _createApproval).call(this, {
    origin,
    snapId,
    type: exports.SNAP_APPROVAL_UPDATE
  });
  try {
    this.messagingSystem.publish('SnapController:snapInstallStarted', snapId, origin, true);
    const oldManifest = snap.manifest;
    const newSnap = await (0, utils_2.fetchSnap)(snapId, location);
    const {
      sourceCode: sourceCodeFile,
      manifest: manifestFile
    } = newSnap;
    const manifest = manifestFile.result;
    const newVersion = manifest.version;
    if (!(0, utils_1.gtVersion)(newVersion, snap.version)) {
      throw rpc_errors_1.rpcErrors.invalidParams(`Snap "${snapId}@${snap.version}" is already installed. Couldn't update to a version inside requested "${versionRange}" range.`);
    }
    if (!(0, utils_1.satisfiesVersionRange)(newVersion, versionRange)) {
      throw new Error(`Version mismatch. Manifest for "${snapId}" specifies version "${newVersion}" which doesn't satisfy requested version range "${versionRange}".`);
    }
    await _assertClassBrand(_SnapController_brand, this, _assertIsInstallAllowed).call(this, snapId, {
      version: newVersion,
      checksum: manifest.source.shasum,
      permissions: manifest.initialPermissions,
      platformVersion: manifest.platformVersion
    });
    const processedPermissions = (0, snaps_rpc_methods_1.processSnapPermissions)(manifest.initialPermissions);
    _assertClassBrand(_SnapController_brand, this, _validateSnapPermissions).call(this, processedPermissions);
    const {
      newPermissions,
      unusedPermissions,
      approvedPermissions
    } = _assertClassBrand(_SnapController_brand, this, _calculatePermissionsChange).call(this, snapId, processedPermissions);
    const {
      newConnections,
      unusedConnections,
      approvedConnections
    } = _assertClassBrand(_SnapController_brand, this, _calculateConnectionsChange).call(this, snapId, oldManifest.initialConnections ?? {}, manifest.initialConnections ?? {});
    let approvedNewPermissions;
    let requestData;
    if (pendingApproval) {
      _assertClassBrand(_SnapController_brand, this, _updateApproval).call(this, pendingApproval.id, {
        permissions: newPermissions,
        newVersion: manifest.version,
        newPermissions,
        approvedPermissions,
        unusedPermissions,
        newConnections,
        unusedConnections,
        approvedConnections,
        loading: false
      });
      const {
        permissions,
        ...rest
      } = await pendingApproval.promise;
      approvedNewPermissions = permissions;
      requestData = rest;
      pendingApproval = _assertClassBrand(_SnapController_brand, this, _createApproval).call(this, {
        origin,
        snapId,
        type: exports.SNAP_APPROVAL_RESULT
      });
    } else {
      (0, utils_1.assert)(automaticUpdate);
      approvedNewPermissions = newPermissions;
    }
    if (this.isRunning(snapId)) {
      await this.stopSnap(snapId, snaps_utils_1.SnapStatusEvents.Stop);
    }
    _assertClassBrand(_SnapController_brand, this, _transition).call(this, snapId, snaps_utils_1.SnapStatusEvents.Update);
    _assertClassBrand(_SnapController_brand, this, _set).call(this, {
      origin,
      id: snapId,
      files: newSnap,
      removable,
      preinstalled,
      hidden,
      hideSnapBranding,
      isUpdate: true
    });
    _assertClassBrand(_SnapController_brand, this, _upd