LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\test-dapp\\dist\\constants.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ctest-dapp%5Cdist%5Cconstants.json
      return function (require, module, exports) {
module.exports={
  "hstBytecode": "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",
  "hstAbi": [
    {
      "inputs": [
        {
          "internalType": "uint256",
          "name": "initialAmount",
          "type": "uint256"
        },
        {
          "internalType": "string",
          "name": "tokenName",
          "type": "string"
        },
        {
          "internalType": "uint8",
          "name": "decimalUnits",
          "type": "uint8"
        },
        {
          "internalType": "string",
          "name": "tokenSymbol",
          "type": "string"
        }
      ],
      "stateMutability": "nonpayable",
      "type": "constructor"
    },
    {
      "anonymous": false,
      "inputs": [
        {
          "indexed": true,
          "internalType": "address",
          "name": "owner",
          "type": "address"
        },
        {
          "indexed": true,
          "internalType": "address",
          "name": "spender",
          "type": "address"
        },
        {
          "indexed": false,
          "internalType": "uint256",
          "name": "value",
          "type": "uint256"
        }
      ],
      "name": "Approval",
      "type": "event"
    },
    {
      "anonymous": false,
      "inputs": [
        {
          "indexed": true,
          "internalType": "address",
          "name": "previousOwner",
          "type": "address"
        },
        {
          "indexed": true,
          "internalType": "address",
          "name": "newOwner",
          "type": "address"
        }
      ],
      "name": "OwnershipTransferred",
      "type": "event"
    },
    {
      "anonymous": false,
      "inputs": [
        {
          "indexed": true,
          "internalType": "address",
          "name": "from",
          "type": "address"
        },
        {
          "indexed": true,
          "internalType": "address",
          "name": "to",
          "type": "address"
        },
        {
          "indexed": false,
          "internalType": "uint256",
          "name": "value",
          "type": "uint256"
        }
      ],
      "name": "Transfer",
      "type": "event"
    },
    {
      "inputs": [],
      "name": "DOMAIN_SEPARATOR",
      "outputs": [
        {
          "internalType": "bytes32",
          "name": "",
          "type": "bytes32"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "owner",
          "type": "address"
        },
        {
          "internalType": "address",
          "name": "spender",
          "type": "address"
        }
      ],
      "name": "allowance",
      "outputs": [
        {
          "internalType": "uint256",
          "name": "",
          "type": "uint256"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "spender",
          "type": "address"
        },
        {
          "internalType": "uint256",
          "name": "amount",
          "type": "uint256"
        }
      ],
      "name": "approve",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "account",
          "type": "address"
        }
      ],
      "name": "balanceOf",
      "outputs": [
        {
          "internalType": "uint256",
          "name": "",
          "type": "uint256"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "decimals",
      "outputs": [
        {
          "internalType": "uint8",
          "name": "",
          "type": "uint8"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "spender",
          "type": "address"
        },
        {
          "internalType": "uint256",
          "name": "subtractedValue",
          "type": "uint256"
        }
      ],
      "name": "decreaseAllowance",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "spender",
          "type": "address"
        },
        {
          "internalType": "uint256",
          "name": "addedValue",
          "type": "uint256"
        }
      ],
      "name": "increaseAllowance",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "to",
          "type": "address"
        },
        {
          "internalType": "uint256",
          "name": "amount",
          "type": "uint256"
        }
      ],
      "name": "mint",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "name",
      "outputs": [
        {
          "internalType": "string",
          "name": "",
          "type": "string"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "owner",
          "type": "address"
        }
      ],
      "name": "nonces",
      "outputs": [
        {
          "internalType": "uint256",
          "name": "",
          "type": "uint256"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "owner",
      "outputs": [
        {
          "internalType": "address",
          "name": "",
          "type": "address"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "owner",
          "type": "address"
        },
        {
          "internalType": "address",
          "name": "spender",
          "type": "address"
        },
        {
          "internalType": "uint256",
          "name": "value",
          "type": "uint256"
        },
        {
          "internalType": "uint256",
          "name": "deadline",
          "type": "uint256"
        },
        {
          "internalType": "uint8",
          "name": "v",
          "type": "uint8"
        },
        {
          "internalType": "bytes32",
          "name": "r",
          "type": "bytes32"
        },
        {
          "internalType": "bytes32",
          "name": "s",
          "type": "bytes32"
        }
      ],
      "name": "permit",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "renounceOwnership",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "symbol",
      "outputs": [
        {
          "internalType": "string",
          "name": "",
          "type": "string"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "totalSupply",
      "outputs": [
        {
          "internalType": "uint256",
          "name": "",
          "type": "uint256"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "to",
          "type": "address"
        },
        {
          "internalType": "uint256",
          "name": "amount",
          "type": "uint256"
        }
      ],
      "name": "transfer",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "from",
          "type": "address"
        },
        {
          "internalType": "address",
          "name": "to",
          "type": "address"
        },
        {
          "internalType": "uint256",
          "name": "amount",
          "type": "uint256"
        }
      ],
      "name": "transferFrom",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "newOwner",
          "type": "address"
        }
      ],
      "name": "transferOwnership",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    }
  ],
  "piggybankBytecode": "0x608060405234801561001057600080fd5b5033600160006101000a81548173ffffffffffffffffffffffffffffffffffffffff021916908373ffffffffffffffffffffffffffffffffffffffff1602179055506000808190555061023b806100686000396000f300608060405260043610610057576000357c0100000000000000000000000000000000000000000000000000000000900463ffffffff1680632e1a7d4d1461005c5780638da5cb5b1461009d578063d0e30db0146100f4575b600080fd5b34801561006857600080fd5b5061008760048036038101908080359060200190929190505050610112565b6040518082815260200191505060405180910390f35b3480156100a957600080fd5b506100b26101d0565b604051808273ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200191505060405180910390f35b6100fc6101f6565b6040518082815260200191505060405180910390f35b6000600160009054906101000a900473ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff163373ffffffffffffffffffffffffffffffffffffffff1614151561017057600080fd5b8160008082825403925050819055503373ffffffffffffffffffffffffffffffffffffffff166108fc839081150290604051600060405180830381858888f193505050501580156101c5573d6000803e3d6000fd5b506000549050919050565b600160009054906101000a900473ffffffffffffffffffffffffffffffffffffffff1681565b60003460008082825401925050819055506000549050905600a165627a7a72305820f237db3ec816a52589d82512117bc85bc08d3537683ffeff9059108caf3e5d400029",
  "piggybankAbi": [
    {
      "constant": false,
      "inputs": [
        {
          "name": "withdrawAmount",
          "type": "uint256"
        }
      ],
      "name": "withdraw",
      "outputs": [
        {
          "name": "remainingBal",
          "type": "uint256"
        }
      ],
      "payable": false,
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "constant": true,
      "inputs": [],
      "name": "owner",
      "outputs": [
        {
          "name": "",
          "type": "address"
        }
      ],
      "payable": false,
      "stateMutability": "view",
      "type": "function"
    },
    {
      "constant": false,
      "inputs": [],
      "name": "deposit",
      "outputs": [
        {
          "name": "",
          "type": "uint256"
        }
      ],
      "payable": true,
      "stateMutability": "payable",
      "type": "function"
    },
    {
      "inputs": [],
      "payable": false,
      "stateMutability": "nonpayable",
      "type": "constructor"
    }
  ],
  "nftsAbi": [
    {
      "inputs": [],
      "stateMutability": "nonpayable",
      "type": "constructor"
    },
    {
      "anonymous": false,
      "inputs": [
        {
          "indexed": true,
          "internalType": "address",
          "name": "owner",
          "type": "address"
        },
        {
          "indexed": true,
          "internalType": "address",
          "name": "approved",
          "type": "address"
        },
        {
          "indexed": true,
          "internalType": "uint256",
          "name": "tokenId",
          "type": "uint256"
        }
      ],
      "name": "Approval",
      "type": "event"
    },
    {
      "anonymous": false,
      "inputs": [
        {
          "indexed": true,
          "internalType": "address",
          "name": "owner",
          "type": "address"
        },
        {
          "indexed": true,
          "internalType": "address",
          "name": "operator",
          "type": "address"
        },
        {
          "indexed": false,
          "internalType": "bool",
          "name": "approved",
          "type": "bool"
        }
      ],
      "name": "ApprovalForAll",
      "type": "event"
    },
    {
      "anonymous": false,
      "inputs": [
        {
          "indexed": true,
          "internalType": "address",
          "name": "from",
          "type": "address"
        },
        {
          "indexed": true,
          "internalType": "address",
          "name": "to",
          "type": "address"
        },
        {
          "indexed": true,
          "internalType": "uint256",
          "name": "tokenId",
          "type": "uint256"
        }
      ],
      "name": "Transfer",
      "type": "event"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "to",
          "type": "address"
        },
        {
          "internalType": "uint256",
          "name": "tokenId",
          "type": "uint256"
        }
      ],
      "name": "approve",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "owner",
          "type": "address"
        }
      ],
      "name": "balanceOf",
      "outputs": [
        {
          "internalType": "uint256",
          "name": "",
          "type": "uint256"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "currentTokenId",
      "outputs": [
        {
          "internalType": "uint256",
          "name": "",
          "type": "uint256"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "uint256",
          "name": "tokenId",
          "type": "uint256"
        }
      ],
      "name": "getApproved",
      "outputs": [
        {
          "internalType": "address",
          "name": "",
          "type": "address"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "owner",
          "type": "address"
        },
        {
          "internalType": "address",
          "name": "operator",
          "type": "address"
        }
      ],
      "name": "isApprovedForAll",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "uint256",
          "name": "numberOfTokens",
          "type": "uint256"
        }
      ],
      "name": "mintNFTs",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "name",
      "outputs": [
        {
          "internalType": "string",
          "name": "",
          "type": "string"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "uint256",
          "name": "tokenId",
          "type": "uint256"
        }
      ],
      "name": "ownerOf",
      "outputs": [
        {
          "internalType": "address",
          "name": "",
          "type": "address"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "from",
          "type": "address"
        },
        {
          "internalType": "address",
          "name": "to",
          "type": "address"
        },
        {
          "internalType": "uint256",
          "name": "tokenId",
          "type": "uint256"
        }
      ],
      "name": "safeTransferFrom",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "from",
          "type": "address"
        },
        {
          "internalType": "address",
          "name": "to",
          "type": "address"
        },
        {
          "internalType": "uint256",
          "name": "tokenId",
          "type": "uint256"
        },
        {
          "internalType": "bytes",
          "name": "data",
          "type": "bytes"
        }
      ],
      "name": "safeTransferFrom",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "operator",
          "type": "address"
        },
        {
          "internalType": "bool",
          "name": "approved",
          "type": "bool"
        }
      ],
      "name": "setApprovalForAll",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "bytes4",
          "name": "interfaceId",
          "type": "bytes4"
        }
      ],
      "name": "supportsInterface",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "symbol",
      "outputs": [
        {
          "internalType": "string",
          "name": "",
          "type": "string"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "uint256",
          "name": "tokenId",
          "type": "uint256"
        }
      ],
      "name": "tokenURI",
      "outputs": [
        {
          "internalType": "string",
          "name": "",
          "type": "string"
        }
      ],
      "stateMutability": "pure",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "from",
          "type": "address"
        },
        {
          "internalType": "address",
          "name": "to",
          "type": "address"
        },
        {
          "internalType": "uint256",
          "name": "tokenId",
          "type": "uint256"
        }
      ],
      "name": "transferFrom",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    }
  ],
  "nftsBytecode": "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",
  "failingContractAbi": [
    { "payable": true, "stateMutability": "payable", "type": "fallback" }
  ],
  "failingContractBytecode": "0x6080604052348015600f57600080fd5b50608b8061001e6000396000f3fe6080604052610fff3411600e57fe5b3373ffffffffffffffffffffffffffffffffffffffff166108fc349081150290604051600060405180830381858888f193505050501580156053573d6000803e3d6000fd5b5000fea265627a7a72315820631b0dbb6b871cdbfdec2773af15ebfb8e52c794cf836fe27ec21f1aed17180f64736f6c634300050c0032",
  "multisigBytecode": "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",
  "multisigAbi": [
    {
      "inputs": [
        {
          "internalType": "uint256",
          "name": "_txIndex",
          "type": "uint256"
        }
      ],
      "name": "confirmTransaction",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [],
      "stateMutability": "nonpayable",
      "type": "constructor"
    },
    {
      "anonymous": false,
      "inputs": [
        {
          "indexed": true,
          "internalType": "address",
          "name": "owner",
          "type": "address"
        },
        {
          "indexed": true,
          "internalType": "uint256",
          "name": "txIndex",
          "type": "uint256"
        }
      ],
      "name": "ConfirmTransaction",
      "type": "event"
    },
    {
      "anonymous": false,
      "inputs": [
        {
          "indexed": true,
          "internalType": "address",
          "name": "sender",
          "type": "address"
        },
        {
          "indexed": false,
          "internalType": "uint256",
          "name": "amount",
          "type": "uint256"
        },
        {
          "indexed": false,
          "internalType": "uint256",
          "name": "balance",
          "type": "uint256"
        }
      ],
      "name": "Deposit",
      "type": "event"
    },
    {
      "inputs": [
        {
          "internalType": "uint256",
          "name": "_txIndex",
          "type": "uint256"
        }
      ],
      "name": "executeTransaction",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "anonymous": false,
      "inputs": [
        {
          "indexed": true,
          "internalType": "address",
          "name": "owner",
          "type": "address"
        },
        {
          "indexed": true,
          "internalType": "uint256",
          "name": "txIndex",
          "type": "uint256"
        }
      ],
      "name": "ExecuteTransaction",
      "type": "event"
    },
    {
      "inputs": [
        {
          "internalType": "uint256",
          "name": "_txIndex",
          "type": "uint256"
        }
      ],
      "name": "revokeConfirmation",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "anonymous": false,
      "inputs": [
        {
          "indexed": true,
          "internalType": "address",
          "name": "owner",
          "type": "address"
        },
        {
          "indexed": true,
          "internalType": "uint256",
          "name": "txIndex",
          "type": "uint256"
        }
      ],
      "name": "RevokeConfirmation",
      "type": "event"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "_to",
          "type": "address"
        },
        {
          "internalType": "uint256",
          "name": "_value",
          "type": "uint256"
        },
        {
          "internalType": "bytes",
          "name": "_data",
          "type": "bytes"
        }
      ],
      "name": "submitTransaction",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "anonymous": false,
      "inputs": [
        {
          "indexed": true,
          "internalType": "address",
          "name": "owner",
          "type": "address"
        },
        {
          "indexed": true,
          "internalType": "uint256",
          "name": "txIndex",
          "type": "uint256"
        },
        {
          "indexed": true,
          "internalType": "address",
          "name": "to",
          "type": "address"
        },
        {
          "indexed": false,
          "internalType": "uint256",
          "name": "value",
          "type": "uint256"
        },
        {
          "indexed": false,
          "internalType": "bytes",
          "name": "data",
          "type": "bytes"
        }
      ],
      "name": "SubmitTransaction",
      "type": "event"
    },
    {
      "stateMutability": "payable",
      "type": "receive"
    },
    {
      "inputs": [],
      "name": "getOwners",
      "outputs": [
        {
          "internalType": "address[]",
          "name": "",
          "type": "address[]"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "uint256",
          "name": "_txIndex",
          "type": "uint256"
        }
      ],
      "name": "getTransaction",
      "outputs": [
        {
          "internalType": "address",
          "name": "to",
          "type": "address"
        },
        {
          "internalType": "uint256",
          "name": "value",
          "type": "uint256"
        },
        {
          "internalType": "bytes",
          "name": "data",
          "type": "bytes"
        },
        {
          "internalType": "bool",
          "name": "executed",
          "type": "bool"
        },
        {
          "internalType": "uint256",
          "name": "numConfirmations",
          "type": "uint256"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "getTransactionCount",
      "outputs": [
        {
          "internalType": "uint256",
          "name": "",
          "type": "uint256"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "uint256",
          "name": "",
          "type": "uint256"
        },
        {
          "internalType": "address",
          "name": "",
          "type": "address"
        }
      ],
      "name": "isConfirmed",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "",
          "type": "address"
        }
      ],
      "name": "isOwner",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "numConfirmationsRequired",
      "outputs": [
        {
          "internalType": "uint256",
          "name": "",
          "type": "uint256"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "uint256",
          "name": "",
          "type": "uint256"
        }
      ],
      "name": "owners",
      "outputs": [
        {
          "internalType": "address",
          "name": "",
          "type": "address"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "uint256",
          "name": "",
          "type": "uint256"
        }
      ],
      "name": "transactions",
      "outputs": [
        {
          "internalType": "address",
          "name": "to",
          "type": "address"
        },
        {
          "internalType": "uint256",
          "name": "value",
          "type": "uint256"
        },
        {
          "internalType": "bytes",
          "name": "data",
          "type": "bytes"
        },
        {
          "internalType": "bool",
          "name": "executed",
          "type": "bool"
        },
        {
          "internalType": "uint256",
          "name": "numConfirmations",
          "type": "uint256"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    }
  ],
  "erc1155Abi": [
    {
      "inputs": [],
      "stateMutability": "nonpayable",
      "type": "constructor"
    },
    {
      "anonymous": false,
      "inputs": [
        {
          "indexed": true,
          "internalType": "address",
          "name": "account",
          "type": "address"
        },
        {
          "indexed": true,
          "internalType": "address",
          "name": "operator",
          "type": "address"
        },
        {
          "indexed": false,
          "internalType": "bool",
          "name": "approved",
          "type": "bool"
        }
      ],
      "name": "ApprovalForAll",
      "type": "event"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "to",
          "type": "address"
        },
        {
          "internalType": "uint256[]",
          "name": "ids",
          "type": "uint256[]"
        },
        {
          "internalType": "uint256[]",
          "name": "amounts",
          "type": "uint256[]"
        },
        {
          "internalType": "bytes",
          "name": "data",
          "type": "bytes"
        }
      ],
      "name": "mintBatch",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "anonymous": false,
      "inputs": [
        {
          "indexed": true,
          "internalType": "address",
          "name": "previousOwner",
          "type": "address"
        },
        {
          "indexed": true,
          "internalType": "address",
          "name": "newOwner",
          "type": "address"
        }
      ],
      "name": "OwnershipTransferred",
      "type": "event"
    },
    {
      "inputs": [],
      "name": "renounceOwnership",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "from",
          "type": "address"
        },
        {
          "internalType": "address",
          "name": "to",
          "type": "address"
        },
        {
          "internalType": "uint256[]",
          "name": "ids",
          "type": "uint256[]"
        },
        {
          "internalType": "uint256[]",
          "name": "amounts",
          "type": "uint256[]"
        },
        {
          "internalType": "bytes",
          "name": "data",
          "type": "bytes"
        }
      ],
      "name": "safeBatchTransferFrom",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "from",
          "type": "address"
        },
        {
          "internalType": "address",
          "name": "to",
          "type": "address"
        },
        {
          "internalType": "uint256",
          "name": "id",
          "type": "uint256"
        },
        {
          "internalType": "uint256",
          "name": "amount",
          "type": "uint256"
        },
        {
          "internalType": "bytes",
          "name": "data",
          "type": "bytes"
        }
      ],
      "name": "safeTransferFrom",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "operator",
          "type": "address"
        },
        {
          "internalType": "bool",
          "name": "approved",
          "type": "bool"
        }
      ],
      "name": "setApprovalForAll",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "string",
          "name": "newuri",
          "type": "string"
        }
      ],
      "name": "setURI",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "anonymous": false,
      "inputs": [
        {
          "indexed": true,
          "internalType": "address",
          "name": "operator",
          "type": "address"
        },
        {
          "indexed": true,
          "internalType": "address",
          "name": "from",
          "type": "address"
        },
        {
          "indexed": true,
          "internalType": "address",
          "name": "to",
          "type": "address"
        },
        {
          "indexed": false,
          "internalType": "uint256[]",
          "name": "ids",
          "type": "uint256[]"
        },
        {
          "indexed": false,
          "internalType": "uint256[]",
          "name": "values",
          "type": "uint256[]"
        }
      ],
      "name": "TransferBatch",
      "type": "event"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "newOwner",
          "type": "address"
        }
      ],
      "name": "transferOwnership",
      "outputs": [],
      "stateMutability": "nonpayable",
      "type": "function"
    },
    {
      "anonymous": false,
      "inputs": [
        {
          "indexed": true,
          "internalType": "address",
          "name": "operator",
          "type": "address"
        },
        {
          "indexed": true,
          "internalType": "address",
          "name": "from",
          "type": "address"
        },
        {
          "indexed": true,
          "internalType": "address",
          "name": "to",
          "type": "address"
        },
        {
          "indexed": false,
          "internalType": "uint256",
          "name": "id",
          "type": "uint256"
        },
        {
          "indexed": false,
          "internalType": "uint256",
          "name": "value",
          "type": "uint256"
        }
      ],
      "name": "TransferSingle",
      "type": "event"
    },
    {
      "anonymous": false,
      "inputs": [
        {
          "indexed": false,
          "internalType": "string",
          "name": "value",
          "type": "string"
        },
        {
          "indexed": true,
          "internalType": "uint256",
          "name": "id",
          "type": "uint256"
        }
      ],
      "name": "URI",
      "type": "event"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "account",
          "type": "address"
        },
        {
          "internalType": "uint256",
          "name": "id",
          "type": "uint256"
        }
      ],
      "name": "balanceOf",
      "outputs": [
        {
          "internalType": "uint256",
          "name": "",
          "type": "uint256"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address[]",
          "name": "accounts",
          "type": "address[]"
        },
        {
          "internalType": "uint256[]",
          "name": "ids",
          "type": "uint256[]"
        }
      ],
      "name": "balanceOfBatch",
      "outputs": [
        {
          "internalType": "uint256[]",
          "name": "",
          "type": "uint256[]"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "address",
          "name": "account",
          "type": "address"
        },
        {
          "internalType": "address",
          "name": "operator",
          "type": "address"
        }
      ],
      "name": "isApprovedForAll",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "name",
      "outputs": [
        {
          "internalType": "string",
          "name": "",
          "type": "string"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [],
      "name": "owner",
      "outputs": [
        {
          "internalType": "address",
          "name": "",
          "type": "address"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "bytes4",
          "name": "interfaceId",
          "type": "bytes4"
        }
      ],
      "name": "supportsInterface",
      "outputs": [
        {
          "internalType": "bool",
          "name": "",
          "type": "bool"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    },
    {
      "inputs": [
        {
          "internalType": "uint256",
          "name": "_tokenid",
          "type": "uint256"
        }
      ],
      "name": "uri",
      "outputs": [
        {
          "internalType": "string",
          "name": "",
          "type": "string"
        }
      ],
      "stateMutability": "view",
      "type": "function"
    }
  ],
  "erc1155Bytecode": "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",
  "heavyCallData": "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"
}

      };
    };
  }
  }
}, {package:"@metamask/test-dapp",file:"node_modules\\@metamask\\test-dapp\\dist\\constants.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\UserOperationController.cjs", {"./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\constants.cjs","./helpers/Bundler.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\helpers\\Bundler.cjs","./helpers/PendingUserOperationTracker.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\helpers\\PendingUserOperationTracker.cjs","./helpers/SnapSmartContractAccount.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\helpers\\SnapSmartContractAccount.cjs","./logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\logger.cjs","./types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\types.cjs","./utils/gas-fees.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\utils\\gas-fees.cjs","./utils/gas.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\utils\\gas.cjs","./utils/transaction.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\utils\\transaction.cjs","./utils/validation.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\utils\\validation.cjs","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/eth-query":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-query\\index.js","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","events":"D:\\code\\v\\metamask-extension\\node_modules\\events\\events.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","uuid":"D:\\code\\v\\metamask-extension\\node_modules\\uuid\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cuser-operation-controller%5Cdist%5CUserOperationController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _UserOperationController_instances, _UserOperationController_entrypoint, _UserOperationController_getGasFeeEstimates, _UserOperationController_pendingUserOperationTracker, _UserOperationController_addUserOperation, _UserOperationController_prepareAndSubmitUserOperation, _UserOperationController_waitForConfirmation, _UserOperationController_createMetadata, _UserOperationController_prepareUserOperation, _UserOperationController_addPaymasterData, _UserOperationController_approveUserOperation, _UserOperationController_signUserOperation, _UserOperationController_submitUserOperation, _UserOperationController_failUserOperation, _UserOperationController_createEmptyUserOperation, _UserOperationController_updateMetadata, _UserOperationController_deleteMetadata, _UserOperationController_updateTransaction, _UserOperationController_addPendingUserOperationTrackerListeners, _UserOperationController_requestApproval, _UserOperationController_getTransactionType, _UserOperationController_getProvider, _UserOperationController_updateUserOperationAfterApproval, _UserOperationController_regenerateUserOperation;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserOperationController = void 0;
const base_controller_1 = require("@metamask/base-controller");
const controller_utils_1 = require("@metamask/controller-utils");
const eth_query_1 = __importDefault(require("@metamask/eth-query"));
const rpc_errors_1 = require("@metamask/rpc-errors");
const transaction_controller_1 = require("@metamask/transaction-controller");
const utils_1 = require("@metamask/utils");
// This package purposefully relies on Node's EventEmitter module.
// eslint-disable-next-line import-x/no-nodejs-modules
const events_1 = __importDefault(require("events"));
const lodash_1 = require("lodash");
const uuid_1 = require("uuid");
const constants_1 = require("./constants.cjs");
const Bundler_1 = require("./helpers/Bundler.cjs");
const PendingUserOperationTracker_1 = require("./helpers/PendingUserOperationTracker.cjs");
const SnapSmartContractAccount_1 = require("./helpers/SnapSmartContractAccount.cjs");
const logger_1 = require("./logger.cjs");
const types_1 = require("./types.cjs");
const gas_1 = require("./utils/gas.cjs");
const gas_fees_1 = require("./utils/gas-fees.cjs");
const transaction_1 = require("./utils/transaction.cjs");
const validation_1 = require("./utils/validation.cjs");
const controllerName = 'UserOperationController';
const stateMetadata = {
    userOperations: { persist: true, anonymous: false },
};
const getDefaultState = () => ({
    userOperations: {},
});
/**
 * Controller for creating and managing the life cycle of user operations.
 */
class UserOperationController extends base_controller_1.BaseController {
    /**
     * Construct a UserOperationController instance.
     *
     * @param options - Controller options.
     * @param options.entrypoint - Address of the entrypoint contract.
     * @param options.getGasFeeEstimates - Callback to get gas fee estimates.
     * @param options.messenger - Restricted messenger for the user operation controller.
     * @param options.state - Initial state to set on the controller.
     */
    constructor({ entrypoint, getGasFeeEstimates, messenger, state, }) {
        super({
            name: controllerName,
            metadata: stateMetadata,
            messenger,
            state: { ...getDefaultState(), ...state },
        });
        _UserOperationController_instances.add(this);
        _UserOperationController_entrypoint.set(this, void 0);
        _UserOperationController_getGasFeeEstimates.set(this, void 0);
        _UserOperationController_pendingUserOperationTracker.set(this, void 0);
        this.hub = new events_1.default();
        __classPrivateFieldSet(this, _UserOperationController_entrypoint, entrypoint, "f");
        __classPrivateFieldSet(this, _UserOperationController_getGasFeeEstimates, getGasFeeEstimates, "f");
        __classPrivateFieldSet(this, _UserOperationController_pendingUserOperationTracker, new PendingUserOperationTracker_1.PendingUserOperationTracker({
            getUserOperations: () => (0, lodash_1.cloneDeep)(Object.values(this.state.userOperations)),
            messenger,
        }), "f");
        __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_addPendingUserOperationTrackerListeners).call(this);
    }
    /**
     * Create and submit a user operation.
     *
     * @param request - Information required to create a user operation.
     * @param request.data - Data to include in the resulting transaction.
     * @param request.maxFeePerGas - Maximum fee per gas to pay towards the transaction.
     * @param request.maxPriorityFeePerGas - Maximum priority fee per gas to pay towards the transaction.
     * @param request.to - Destination address of the resulting transaction.
     * @param request.value - Value to include in the resulting transaction.
     * @param options - Configuration options when creating a user operation.
     * @param options.networkClientId - ID of the network client used to query the chain.
     * @param options.origin - Origin of the user operation, such as the hostname of a dApp.
     * @param options.requireApproval - Whether to require user approval before submitting the user operation. Defaults to true.
     * @param options.smartContractAccount - Smart contract abstraction to provide the contract specific values such as call data and nonce. Defaults to the current snap account.
     * @param options.swaps - Swap metadata to record with the user operation.
     * @param options.type - Type of the transaction.
     */
    async addUserOperation(request, options) {
        (0, validation_1.validateAddUserOperationRequest)(request);
        (0, validation_1.validateAddUserOperationOptions)(options);
        return await __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_addUserOperation).call(this, request, options);
    }
    /**
     * Create and submit a user operation equivalent to the provided transaction.
     *
     * @param transaction - Transaction to use as the basis for the user operation.
     * @param options - Configuration options when creating a user operation.
     * @param options.networkClientId - ID of the network client used to query the chain.
     * @param options.origin - Origin of the user operation, such as the hostname of a dApp.
     * @param options.requireApproval - Whether to require user approval before submitting the user operation. Defaults to true.
     * @param options.smartContractAccount - Smart contract abstraction to provide the contract specific values such as call data and nonce. Defaults to the current snap account.
     * @param options.swaps - Swap metadata to record with the user operation.
     * @param options.type - Type of the transaction.
     */
    async addUserOperationFromTransaction(transaction, options) {
        (0, validation_1.validateAddUserOperationOptions)(options);
        const { data, from, maxFeePerGas, maxPriorityFeePerGas, to, value } = transaction;
        const request = {
            data: data === '' ? undefined : data,
            from,
            maxFeePerGas,
            maxPriorityFeePerGas,
            to,
            value,
        };
        (0, validation_1.validateAddUserOperationRequest)(request);
        return await __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_addUserOperation).call(this, request, { ...options, transaction });
    }
    startPollingByNetworkClientId(networkClientId) {
        return __classPrivateFieldGet(this, _UserOperationController_pendingUserOperationTracker, "f").startPolling({
            networkClientId,
        });
    }
}
exports.UserOperationController = UserOperationController;
_UserOperationController_entrypoint = new WeakMap(), _UserOperationController_getGasFeeEstimates = new WeakMap(), _UserOperationController_pendingUserOperationTracker = new WeakMap(), _UserOperationController_instances = new WeakSet(), _UserOperationController_addUserOperation = async function _UserOperationController_addUserOperation(request, options) {
    (0, logger_1.projectLogger)('Adding user operation', { request, options });
    const { networkClientId, origin, smartContractAccount: requestSmartContractAccount, swaps, transaction, } = options;
    const { chainId, provider } = await __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_getProvider).call(this, networkClientId);
    const metadata = await __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_createMetadata).call(this, chainId, origin, transaction, swaps);
    const smartContractAccount = requestSmartContractAccount ??
        new SnapSmartContractAccount_1.SnapSmartContractAccount(this.messagingSystem);
    const cache = {
        chainId,
        metadata,
        options: { ...options, smartContractAccount },
        provider,
        request,
        transaction,
    };
    const { id } = metadata;
    let throwError = false;
    const hashValue = (async () => {
        try {
            return await __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_prepareAndSubmitUserOperation).call(this, cache);
        }
        catch (error) {
            __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_failUserOperation).call(this, metadata, error);
            if (throwError) {
                throw error;
            }
            return undefined;
        }
    })();
    const hash = async () => {
        throwError = true;
        return await hashValue;
    };
    const transactionHash = async () => {
        await hash();
        const { transactionHash: finalTransactionHash } = await __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_waitForConfirmation).call(this, metadata);
        return finalTransactionHash;
    };
    return {
        id,
        hash,
        transactionHash,
    };
}, _UserOperationController_prepareAndSubmitUserOperation = async function _UserOperationController_prepareAndSubmitUserOperation(cache) {
    const { metadata, options } = cache;
    const { requireApproval, smartContractAccount } = options;
    let resultCallbacks;
    try {
        await __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_prepareUserOperation).call(this, cache);
        await __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_addPaymasterData).call(this, metadata, smartContractAccount);
        this.hub.emit('user-operation-added', metadata);
        if (requireApproval !== false) {
            resultCallbacks = await __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_approveUserOperation).call(this, cache);
        }
        await __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_signUserOperation).call(this, metadata, smartContractAccount);
        await __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_submitUserOperation).call(this, metadata);
        resultCallbacks?.success();
        return metadata.hash;
    }
    catch (error) {
        /* istanbul ignore next */
        resultCallbacks?.error(error);
        throw error;
    }
}, _UserOperationController_waitForConfirmation = async function _UserOperationController_waitForConfirmation(metadata) {
    const { id, hash } = metadata;
    (0, logger_1.projectLogger)('Waiting for confirmation', id, hash);
    return new Promise((resolve, reject) => {
        this.hub.once(`${id}:confirmed`, (finalMetadata) => {
            resolve(finalMetadata);
        });
        this.hub.once(`${id}:failed`, (_finalMetadata, error) => {
            reject(error);
        });
    });
}, _UserOperationController_createMetadata = async function _UserOperationController_createMetadata(chainId, origin, transaction, swaps) {
    const metadata = {
        actualGasCost: null,
        actualGasUsed: null,
        baseFeePerGas: null,
        bundlerUrl: null,
        chainId,
        error: null,
        hash: null,
        id: (0, uuid_1.v1)(),
        origin,
        status: types_1.UserOperationStatus.Unapproved,
        swapsMetadata: swaps
            ? {
                approvalTxId: swaps.approvalTxId ?? null,
                destinationTokenAddress: swaps.destinationTokenAddress ?? null,
                destinationTokenAmount: swaps.destinationTokenAmount ?? null,
                destinationTokenDecimals: swaps.destinationTokenDecimals ?? null,
                destinationTokenSymbol: swaps.destinationTokenSymbol ?? null,
                estimatedBaseFee: swaps.estimatedBaseFee ?? null,
                sourceTokenAddress: swaps.sourceTokenAddress ?? null,
                sourceTokenAmount: swaps.sourceTokenAmount ?? null,
                sourceTokenDecimals: swaps.sourceTokenDecimals ?? null,
                sourceTokenSymbol: swaps.sourceTokenSymbol ?? null,
                swapAndSendRecipient: swaps.swapAndSendRecipient ?? null,
                swapMetaData: swaps.swapMetaData ?? null,
                swapTokenValue: swaps.swapTokenValue ?? null,
            }
            : null,
        time: Date.now(),
        transactionHash: null,
        transactionParams: transaction ?? null,
        transactionType: null,
        userFeeLevel: null,
        userOperation: __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_createEmptyUserOperation).call(this, transaction),
    };
    __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_updateMetadata).call(this, metadata);
    (0, logger_1.projectLogger)('Added user operation', metadata.id);
    return metadata;
}, _UserOperationController_prepareUserOperation = async function _UserOperationController_prepareUserOperation(cache) {
    const { chainId, metadata, options, provider, request, transaction } = cache;
    const { data, from, to, value } = request;
    const { id, transactionParams, userOperation } = metadata;
    const { smartContractAccount } = options;
    (0, logger_1.projectLogger)('Preparing user operation', { id });
    const transactionType = await __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_getTransactionType).call(this, transaction, provider, options);
    metadata.transactionType = transactionType ?? null;
    (0, logger_1.projectLogger)('Determined transaction type', transactionType);
    await (0, gas_fees_1.updateGasFees)({
        getGasFeeEstimates: __classPrivateFieldGet(this, _UserOperationController_getGasFeeEstimates, "f"),
        metadata,
        originalRequest: request,
        provider,
        transaction: transactionParams ?? undefined,
    });
    const response = await smartContractAccount.prepareUserOperation({
        chainId,
        data,
        from,
        to,
        value,
    });
    (0, validation_1.validatePrepareUserOperationResponse)(response);
    const { bundler: bundlerUrl, callData, dummyPaymasterAndData, dummySignature, initCode, nonce, sender, } = response;
    userOperation.callData = callData;
    userOperation.initCode = initCode ?? constants_1.EMPTY_BYTES;
    userOperation.nonce = nonce;
    userOperation.paymasterAndData = dummyPaymasterAndData ?? constants_1.EMPTY_BYTES;
    userOperation.sender = sender;
    userOperation.signature = dummySignature ?? constants_1.EMPTY_BYTES;
    metadata.bundlerUrl = bundlerUrl;
    await (0, gas_1.updateGas)(metadata, response, __classPrivateFieldGet(this, _UserOperationController_entrypoint, "f"));
    __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_updateMetadata).call(this, metadata);
}, _UserOperationController_addPaymasterData = async function _UserOperationController_addPaymasterData(metadata, smartContractAccount) {
    const { id, userOperation, chainId } = metadata;
    (0, logger_1.projectLogger)('Requesting paymaster data', { id });
    const response = await smartContractAccount.updateUserOperation({
        userOperation,
        chainId,
    });
    (0, validation_1.validateUpdateUserOperationResponse)(response);
    userOperation.paymasterAndData = response.paymasterAndData ?? constants_1.EMPTY_BYTES;
    if (response.callGasLimit) {
        userOperation.callGasLimit = response.callGasLimit;
    }
    if (response.preVerificationGas) {
        userOperation.preVerificationGas = response.preVerificationGas;
    }
    if (response.verificationGasLimit) {
        userOperation.verificationGasLimit = response.verificationGasLimit;
    }
    __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_updateMetadata).call(this, metadata);
}, _UserOperationController_approveUserOperation = async function _UserOperationController_approveUserOperation(cache) {
    (0, logger_1.projectLogger)('Requesting approval');
    const { metadata } = cache;
    const { resultCallbacks, value } = await __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_requestApproval).call(this, metadata);
    const updatedTransaction = value?.txMeta;
    if (updatedTransaction) {
        await __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_updateUserOperationAfterApproval).call(this, cache, updatedTransaction);
    }
    metadata.status = types_1.UserOperationStatus.Approved;
    __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_updateMetadata).call(this, metadata);
    return resultCallbacks;
}, _UserOperationController_signUserOperation = async function _UserOperationController_signUserOperation(metadata, smartContractAccount) {
    const { id, chainId, userOperation } = metadata;
    (0, logger_1.projectLogger)('Signing user operation', id, userOperation);
    const response = await smartContractAccount.signUserOperation({
        userOperation,
        chainId,
    });
    (0, validation_1.validateSignUserOperationResponse)(response);
    const { signature } = response;
    userOperation.signature = signature;
    (0, logger_1.projectLogger)('Signed user operation', signature);
    metadata.status = types_1.UserOperationStatus.Signed;
    __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_updateMetadata).call(this, metadata);
}, _UserOperationController_submitUserOperation = async function _UserOperationController_submitUserOperation(metadata) {
    const { userOperation } = metadata;
    (0, logger_1.projectLogger)('Submitting user operation', userOperation);
    const bundler = new Bundler_1.Bundler(metadata.bundlerUrl);
    const hash = await bundler.sendUserOperation(userOperation, __classPrivateFieldGet(this, _UserOperationController_entrypoint, "f"));
    metadata.hash = hash;
    metadata.status = types_1.UserOperationStatus.Submitted;
    __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_updateMetadata).call(this, metadata);
}, _UserOperationController_failUserOperation = function _UserOperationController_failUserOperation(metadata, error) {
    const { id } = metadata;
    const rawError = error;
    (0, logger_1.projectLogger)('User operation failed', id, error);
    metadata.error = {
        name: rawError.name,
        message: rawError.message,
        stack: rawError.stack,
        code: rawError.code,
        rpc: rawError.value,
    };
    metadata.status = types_1.UserOperationStatus.Failed;
    __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_updateMetadata).call(this, metadata);
    if (String(rawError.code) === String(rpc_errors_1.errorCodes.provider.userRejectedRequest)) {
        __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_deleteMetadata).call(this, id);
    }
}, _UserOperationController_createEmptyUserOperation = function _UserOperationController_createEmptyUserOperation(transaction) {
    return {
        callData: constants_1.EMPTY_BYTES,
        callGasLimit: constants_1.EMPTY_BYTES,
        initCode: constants_1.EMPTY_BYTES,
        maxFeePerGas: transaction?.maxFeePerGas ?? constants_1.EMPTY_BYTES,
        maxPriorityFeePerGas: transaction?.maxPriorityFeePerGas ?? constants_1.EMPTY_BYTES,
        nonce: constants_1.EMPTY_BYTES,
        paymasterAndData: constants_1.EMPTY_BYTES,
        preVerificationGas: constants_1.EMPTY_BYTES,
        sender: constants_1.ADDRESS_ZERO,
        signature: constants_1.EMPTY_BYTES,
        verificationGasLimit: constants_1.EMPTY_BYTES,
    };
}, _UserOperationController_updateMetadata = function _UserOperationController_updateMetadata(metadata) {
    const { id } = metadata;
    this.update((state) => {
        state.userOperations[id] = (0, lodash_1.cloneDeep)(metadata);
    });
    __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_updateTransaction).call(this, metadata);
}, _UserOperationController_deleteMetadata = function _UserOperationController_deleteMetadata(id) {
    this.update((state) => {
        delete state.userOperations[id];
    });
}, _UserOperationController_updateTransaction = function _UserOperationController_updateTransaction(metadata) {
    if (!metadata.transactionParams) {
        return;
    }
    const transactionMetadata = (0, transaction_1.getTransactionMetadata)(metadata);
    this.hub.emit('transaction-updated', transactionMetadata);
}, _UserOperationController_addPendingUserOperationTrackerListeners = function _UserOperationController_addPendingUserOperationTrackerListeners() {
    __classPrivateFieldGet(this, _UserOperationController_pendingUserOperationTracker, "f").hub.on('user-operation-confirmed', (metadata) => {
        (0, logger_1.projectLogger)('In listener...');
        this.hub.emit('user-operation-confirmed', metadata);
        // TODO: Either fix this lint violation or explain why it's necessary to ignore.
        // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
        this.hub.emit(`${metadata.id}:confirmed`, metadata);
    });
    __classPrivateFieldGet(this, _UserOperationController_pendingUserOperationTracker, "f").hub.on('user-operation-failed', (metadata, error) => {
        this.hub.emit('user-operation-failed', metadata, error);
        // TODO: Either fix this lint violation or explain why it's necessary to ignore.
        // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
        this.hub.emit(`${metadata.id}:failed`, metadata, error);
    });
    __classPrivateFieldGet(this, _UserOperationController_pendingUserOperationTracker, "f").hub.on('user-operation-updated', (metadata) => {
        __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_updateMetadata).call(this, metadata);
    });
}, _UserOperationController_requestApproval = async function _UserOperationController_requestApproval(metadata) {
    const { id, origin } = metadata;
    const type = controller_utils_1.ApprovalType.Transaction;
    const requestData = { txId: id };
    return (await this.messagingSystem.call('ApprovalController:addRequest', {
        id,
        origin,
        type,
        requestData,
        expectsResult: true,
    }, true));
}, _UserOperationController_getTransactionType = async function _UserOperationController_getTransactionType(transaction, provider, options) {
    if (!transaction) {
        return undefined;
    }
    if (options.type) {
        return options.type;
    }
    const ethQuery = new eth_query_1.default(provider);
    const result = (0, transaction_controller_1.determineTransactionType)(transaction, ethQuery);
    return (await result).type;
}, _UserOperationController_getProvider = async function _UserOperationController_getProvider(networkClientId) {
    const { provider, configuration } = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId);
    const { chainId } = configuration;
    return { provider, chainId };
}, _UserOperationController_updateUserOperationAfterApproval = async function _UserOperationController_updateUserOperationAfterApproval(cache, updatedTransaction) {
    (0, logger_1.projectLogger)('Found updated transaction in approval', { updatedTransaction });
    const { metadata, request } = cache;
    const { userOperation } = metadata;
    const usingPaymaster = userOperation.paymasterAndData !== constants_1.EMPTY_BYTES;
    const updatedMaxFeePerGas = (0, utils_1.add0x)(updatedTransaction.txParams.maxFeePerGas);
    const updatedMaxPriorityFeePerGas = (0, utils_1.add0x)(updatedTransaction.txParams.maxPriorityFeePerGas);
    let regenerateUserOperation = false;
    const previousMaxFeePerGas = userOperation.maxFeePerGas;
    const previousMaxPriorityFeePerGas = userOperation.maxPriorityFeePerGas;
    const gasFeesUpdated = previousMaxFeePerGas !== updatedMaxFeePerGas ||
        previousMaxPriorityFeePerGas !== updatedMaxPriorityFeePerGas;
    /**
     * true when we detect {@link getTransactionMetadata} has set the gas fees to zero
     * because the userOperation has a paymaster. This should not be mistaken for gas
     * fees being updated during the approval process.
     */
    const areGasFeesZeroBecauseOfPaymaster = usingPaymaster &&
        updatedMaxFeePerGas === constants_1.VALUE_ZERO &&
        updatedMaxPriorityFeePerGas === constants_1.VALUE_ZERO;
    if (gasFeesUpdated && !areGasFeesZeroBecauseOfPaymaster) {
        (0, logger_1.projectLogger)('Gas fees updated during approval', {
            previousMaxFeePerGas,
            previousMaxPriorityFeePerGas,
            updatedMaxFeePerGas,
            updatedMaxPriorityFeePerGas,
        });
        userOperation.maxFeePerGas = updatedMaxFeePerGas;
        userOperation.maxPriorityFeePerGas = updatedMaxPriorityFeePerGas;
        regenerateUserOperation = usingPaymaster;
    }
    const previousData = request.data ?? constants_1.EMPTY_BYTES;
    const updatedData = updatedTransaction.txParams.data ?? constants_1.EMPTY_BYTES;
    if (previousData !== updatedData) {
        (0, logger_1.projectLogger)('Data updated during approval', { previousData, updatedData });
        regenerateUserOperation = true;
    }
    const previousValue = request.value ?? constants_1.VALUE_ZERO;
    const updatedValue = updatedTransaction.txParams.value ?? constants_1.VALUE_ZERO;
    if (previousValue !== updatedValue) {
        (0, logger_1.projectLogger)('Value updated during approval', { previousValue, updatedValue });
        regenerateUserOperation = true;
    }
    if (regenerateUserOperation) {
        const updatedRequest = {
            ...request,
            data: updatedData,
            maxFeePerGas: updatedMaxFeePerGas,
            maxPriorityFeePerGas: updatedMaxPriorityFeePerGas,
            value: updatedValue,
        };
        await __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_regenerateUserOperation).call(this, {
            ...cache,
            request: updatedRequest,
        });
    }
}, _UserOperationController_regenerateUserOperation = async function _UserOperationController_regenerateUserOperation(cache) {
    (0, logger_1.projectLogger)('Regenerating user operation as parameters were updated during approval');
    const { options: { smartContractAccount }, metadata, } = cache;
    await __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_prepareUserOperation).call(this, cache);
    await __classPrivateFieldGet(this, _UserOperationController_instances, "m", _UserOperationController_addPaymasterData).call(this, metadata, smartContractAccount);
    (0, logger_1.projectLogger)('Regenerated user operation', metadata.userOperation);
};

      };
    };
  }
  }
}, {package:"@metamask/user-operation-controller",file:"node_modules\\@metamask\\user-operation-controller\\dist\\UserOperationController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\constants.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cuser-operation-controller%5Cdist%5Cconstants.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VALUE_ZERO = exports.ADDRESS_ZERO = exports.EMPTY_BYTES = void 0;
exports.EMPTY_BYTES = '0x';
exports.ADDRESS_ZERO = '0x0000000000000000000000000000000000000000';
exports.VALUE_ZERO = '0x0';

      };
    };
  }
  }
}, {package:"@metamask/user-operation-controller",file:"node_modules\\@metamask\\user-operation-controller\\dist\\constants.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\helpers\\Bundler.cjs", {"../logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\logger.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cuser-operation-controller%5Cdist%5Chelpers%5CBundler.cjs
      return function (require, module, exports) {
"use strict";
/* eslint-disable jsdoc/require-jsdoc */
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _Bundler_instances, _Bundler_url, _Bundler_query;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bundler = void 0;
const logger_1 = require("../logger.cjs");
const log = (0, logger_1.createModuleLogger)(logger_1.projectLogger, 'bundler');
/**
 * A helper class for interacting with a bundler.
 */
class Bundler {
    constructor(url) {
        _Bundler_instances.add(this);
        _Bundler_url.set(this, void 0);
        __classPrivateFieldSet(this, _Bundler_url, url, "f");
    }
    /**
     * Estimate the gas required to execute a user operation.
     *
     * @param userOperation - The user operation to estimate gas for.
     * @param entrypoint - The address of entrypoint to use for the user operation.
     * @returns The estimated gas limits for the user operation.
     */
    async estimateUserOperationGas(userOperation, entrypoint) {
        log('Estimating gas', { url: __classPrivateFieldGet(this, _Bundler_url, "f"), userOperation, entrypoint });
        const response = await __classPrivateFieldGet(this, _Bundler_instances, "m", _Bundler_query).call(this, 'eth_estimateUserOperationGas', [userOperation, entrypoint]);
        log('Estimated gas', { response });
        return response;
    }
    /**
     * Retrieve the receipt for a user operation.
     * @param hash - The hash of the user operation.
     * @returns The receipt for the user operation, or `undefined` if the user operation is pending.
     */
    async getUserOperationReceipt(hash) {
        log('Getting user operation receipt', { url: __classPrivateFieldGet(this, _Bundler_url, "f"), hash });
        return await __classPrivateFieldGet(this, _Bundler_instances, "m", _Bundler_query).call(this, 'eth_getUserOperationReceipt', [hash]);
    }
    /**
     * Submit a user operation to the bundler.
     * @param userOperation - The signed user operation to submit.
     * @param entrypoint - The address of entrypoint to use for the user operation.
     * @returns The hash of the user operation.
     */
    async sendUserOperation(userOperation, entrypoint) {
        log('Sending user operation', {
            url: __classPrivateFieldGet(this, _Bundler_url, "f"),
            userOperation,
            entrypoint,
        });
        const hash = await __classPrivateFieldGet(this, _Bundler_instances, "m", _Bundler_query).call(this, 'eth_sendUserOperation', [
            userOperation,
            entrypoint,
        ]);
        log('Sent user operation', hash);
        return hash;
    }
}
exports.Bundler = Bundler;
_Bundler_url = new WeakMap(), _Bundler_instances = new WeakSet(), _Bundler_query = 
// TODO: Either fix this lint violation or explain why it's necessary to ignore.
// eslint-disable-next-line @typescript-eslint/naming-convention
async function _Bundler_query(method, params) {
    const request = {
        method: 'POST',
        headers: {
            Accept: 'application/json',
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({ jsonrpc: '2.0', id: 1, method, params }),
    };
    const response = await fetch(__classPrivateFieldGet(this, _Bundler_url, "f"), request);
    const responseJson = await response.json();
    if (responseJson.error) {
        const error = new Error(responseJson.error.message || responseJson.error);
        error.code =
            responseJson.error.code;
        throw error;
    }
    return responseJson.result;
};

      };
    };
  }
  }
}, {package:"@metamask/user-operation-controller",file:"node_modules\\@metamask\\user-operation-controller\\dist\\helpers\\Bundler.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\helpers\\PendingUserOperationTracker.cjs", {"../logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\logger.cjs","../types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\types.cjs","./Bundler.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\helpers\\Bundler.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/eth-query":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-query\\index.js","@metamask/polling-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\polling-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","events":"D:\\code\\v\\metamask-extension\\node_modules\\events\\events.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cuser-operation-controller%5Cdist%5Chelpers%5CPendingUserOperationTracker.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _PendingUserOperationTracker_instances, _PendingUserOperationTracker_getUserOperations, _PendingUserOperationTracker_messenger, _PendingUserOperationTracker_checkUserOperations, _PendingUserOperationTracker_checkUserOperation, _PendingUserOperationTracker_onUserOperationConfirmed, _PendingUserOperationTracker_onUserOperationFailed, _PendingUserOperationTracker_getPendingUserOperations, _PendingUserOperationTracker_updateUserOperation, _PendingUserOperationTracker_getUserOperationReceipt, _PendingUserOperationTracker_normalizeGasValue;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PendingUserOperationTracker = void 0;
const controller_utils_1 = require("@metamask/controller-utils");
const eth_query_1 = __importDefault(require("@metamask/eth-query"));
const polling_controller_1 = require("@metamask/polling-controller");
const utils_1 = require("@metamask/utils");
// This package purposefully relies on Node's EventEmitter module.
// eslint-disable-next-line import-x/no-nodejs-modules
const events_1 = __importDefault(require("events"));
const logger_1 = require("../logger.cjs");
const types_1 = require("../types.cjs");
const Bundler_1 = require("./Bundler.cjs");
const log = (0, utils_1.createModuleLogger)(logger_1.projectLogger, 'pending-user-operations');
/**
 * A helper class to periodically query the bundlers
 * and update the status of any submitted user operations.
 */
class PendingUserOperationTracker extends (0, polling_controller_1.BlockTrackerPollingControllerOnly)() {
    constructor({ getUserOperations, messenger, }) {
        super();
        _PendingUserOperationTracker_instances.add(this);
        _PendingUserOperationTracker_getUserOperations.set(this, void 0);
        _PendingUserOperationTracker_messenger.set(this, void 0);
        this.hub = new events_1.default();
        __classPrivateFieldSet(this, _PendingUserOperationTracker_getUserOperations, getUserOperations, "f");
        __classPrivateFieldSet(this, _PendingUserOperationTracker_messenger, messenger, "f");
    }
    async _executePoll({ networkClientId }) {
        try {
            const { blockTracker, configuration, provider } = this._getNetworkClientById(networkClientId);
            log('Polling', {
                blockNumber: blockTracker.getCurrentBlock(),
                chainId: configuration.chainId,
            });
            await __classPrivateFieldGet(this, _PendingUserOperationTracker_instances, "m", _PendingUserOperationTracker_checkUserOperations).call(this, configuration.chainId, provider);
        }
        catch (error) {
            /* istanbul ignore next */
            log('Failed to check user operations', error);
        }
    }
    _getNetworkClientById(networkClientId) {
        return __classPrivateFieldGet(this, _PendingUserOperationTracker_messenger, "f").call('NetworkController:getNetworkClientById', networkClientId);
    }
}
exports.PendingUserOperationTracker = PendingUserOperationTracker;
_PendingUserOperationTracker_getUserOperations = new WeakMap(), _PendingUserOperationTracker_messenger = new WeakMap(), _PendingUserOperationTracker_instances = new WeakSet(), _PendingUserOperationTracker_checkUserOperations = async function _PendingUserOperationTracker_checkUserOperations(chainId, provider) {
    const pendingUserOperations = __classPrivateFieldGet(this, _PendingUserOperationTracker_instances, "m", _PendingUserOperationTracker_getPendingUserOperations).call(this).filter((metadata) => metadata.chainId === chainId);
    if (!pendingUserOperations.length) {
        log('No pending user operations to check');
        return;
    }
    log('Found pending user operations to check', {
        count: pendingUserOperations.length,
        ids: pendingUserOperations.map((userOperation) => userOperation.id),
    });
    await Promise.all(pendingUserOperations.map((userOperation) => __classPrivateFieldGet(this, _PendingUserOperationTracker_instances, "m", _PendingUserOperationTracker_checkUserOperation).call(this, userOperation, provider)));
}, _PendingUserOperationTracker_checkUserOperation = async function _PendingUserOperationTracker_checkUserOperation(metadata, provider) {
    const { bundlerUrl, hash, id } = metadata;
    if (!hash || !bundlerUrl) {
        log('Skipping user operation as missing hash or bundler', id);
        return;
    }
    try {
        const receipt = await __classPrivateFieldGet(this, _PendingUserOperationTracker_instances, "m", _PendingUserOperationTracker_getUserOperationReceipt).call(this, hash, bundlerUrl);
        const isSuccess = receipt?.success;
        if (receipt && !isSuccess) {
            __classPrivateFieldGet(this, _PendingUserOperationTracker_instances, "m", _PendingUserOperationTracker_onUserOperationFailed).call(this, metadata, receipt);
            return;
        }
        if (isSuccess) {
            await __classPrivateFieldGet(this, _PendingUserOperationTracker_instances, "m", _PendingUserOperationTracker_onUserOperationConfirmed).call(this, metadata, receipt, provider);
            return;
        }
        log('No receipt found for user operation', { id, hash });
    }
    catch (error) {
        log('Failed to check user operation', id, error);
    }
}, _PendingUserOperationTracker_onUserOperationConfirmed = async function _PendingUserOperationTracker_onUserOperationConfirmed(metadata, receipt, provider) {
    const { id } = metadata;
    const { actualGasCost, actualGasUsed, receipt: { blockHash, transactionHash }, } = receipt;
    log('User operation confirmed', id, transactionHash);
    const { baseFeePerGas } = await (0, controller_utils_1.query)(new eth_query_1.default(provider), 'getBlockByHash', [blockHash, false]);
    metadata.actualGasCost = __classPrivateFieldGet(this, _PendingUserOperationTracker_instances, "m", _PendingUserOperationTracker_normalizeGasValue).call(this, actualGasCost);
    metadata.actualGasUsed = __classPrivateFieldGet(this, _PendingUserOperationTracker_instances, "m", _PendingUserOperationTracker_normalizeGasValue).call(this, actualGasUsed);
    metadata.baseFeePerGas = baseFeePerGas;
    metadata.status = types_1.UserOperationStatus.Confirmed;
    metadata.transactionHash = transactionHash;
    __classPrivateFieldGet(this, _PendingUserOperationTracker_instances, "m", _PendingUserOperationTracker_updateUserOperation).call(this, metadata);
    this.hub.emit('user-operation-confirmed', metadata);
}, _PendingUserOperationTracker_onUserOperationFailed = function _PendingUserOperationTracker_onUserOperationFailed(metadata, _receipt) {
    const { id } = metadata;
    log('User operation failed', id);
    metadata.status = types_1.UserOperationStatus.Failed;
    __classPrivateFieldGet(this, _PendingUserOperationTracker_instances, "m", _PendingUserOperationTracker_updateUserOperation).call(this, metadata);
    this.hub.emit('user-operation-failed', metadata, new Error('User operation receipt has failed status'));
}, _PendingUserOperationTracker_getPendingUserOperations = function _PendingUserOperationTracker_getPendingUserOperations() {
    return __classPrivateFieldGet(this, _PendingUserOperationTracker_getUserOperations, "f").call(this).filter((userOperation) => userOperation.status === types_1.UserOperationStatus.Submitted);
}, _PendingUserOperationTracker_updateUserOperation = function _PendingUserOperationTracker_updateUserOperation(metadata) {
    this.hub.emit('user-operation-updated', metadata);
}, _PendingUserOperationTracker_getUserOperationReceipt = async function _PendingUserOperationTracker_getUserOperationReceipt(hash, bundlerUrl) {
    const bundler = new Bundler_1.Bundler(bundlerUrl);
    return bundler.getUserOperationReceipt(hash);
}, _PendingUserOperationTracker_normalizeGasValue = function _PendingUserOperationTracker_normalizeGasValue(gasValue) {
    if (typeof gasValue === 'number') {
        return (0, controller_utils_1.toHex)(gasValue);
    }
    return gasValue;
};

      };
    };
  }
  }
}, {package:"@metamask/user-operation-controller",file:"node_modules\\@metamask\\user-operation-controller\\dist\\helpers\\PendingUserOperationTracker.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\helpers\\SnapSmartContractAccount.cjs", {"../constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\constants.cjs","../utils/chain-id.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\utils\\chain-id.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cuser-operation-controller%5Cdist%5Chelpers%5CSnapSmartContractAccount.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _SnapSmartContractAccount_messenger;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnapSmartContractAccount = void 0;
const constants_1 = require("../constants.cjs");
const chain_id_1 = require("../utils/chain-id.cjs");
class SnapSmartContractAccount {
    constructor(messenger) {
        _SnapSmartContractAccount_messenger.set(this, void 0);
        __classPrivateFieldSet(this, _SnapSmartContractAccount_messenger, messenger, "f");
    }
    async prepareUserOperation(request) {
        const { chainId, data: requestData, from: sender, to: requestTo, value: requestValue, } = request;
        const data = requestData ?? constants_1.EMPTY_BYTES;
        const to = requestTo ?? constants_1.ADDRESS_ZERO;
        const value = requestValue ?? constants_1.VALUE_ZERO;
        const response = await __classPrivateFieldGet(this, _SnapSmartContractAccount_messenger, "f").call('KeyringController:prepareUserOperation', sender, [{ data, to, value }], { chainId: (0, chain_id_1.toEip155ChainId)(chainId) });
        const { bundlerUrl: bundler, callData, dummyPaymasterAndData, dummySignature, gasLimits: gas, initCode, nonce, } = response;
        return {
            bundler,
            callData,
            dummyPaymasterAndData,
            dummySignature,
            gas,
            initCode,
            nonce,
            sender,
        };
    }
    async updateUserOperation(request) {
        const { userOperation, chainId } = request;
        const { sender } = userOperation;
        const { paymasterAndData: responsePaymasterAndData, verificationGasLimit, preVerificationGas, callGasLimit, } = await __classPrivateFieldGet(this, _SnapSmartContractAccount_messenger, "f").call('KeyringController:patchUserOperation', sender, userOperation, { chainId: (0, chain_id_1.toEip155ChainId)(chainId) });
        const paymasterAndData = responsePaymasterAndData === constants_1.EMPTY_BYTES
            ? undefined
            : responsePaymasterAndData;
        return {
            paymasterAndData,
            verificationGasLimit,
            preVerificationGas,
            callGasLimit,
        };
    }
    async signUserOperation(request) {
        const { userOperation, chainId } = request;
        const { sender } = userOperation;
        const signature = await __classPrivateFieldGet(this, _SnapSmartContractAccount_messenger, "f").call('KeyringController:signUserOperation', sender, userOperation, { chainId: (0, chain_id_1.toEip155ChainId)(chainId) });
        return { signature };
    }
}
exports.SnapSmartContractAccount = SnapSmartContractAccount;
_SnapSmartContractAccount_messenger = new WeakMap();

      };
    };
  }
  }
}, {package:"@metamask/user-operation-controller",file:"node_modules\\@metamask\\user-operation-controller\\dist\\helpers\\SnapSmartContractAccount.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\index.cjs", {"./UserOperationController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\UserOperationController.cjs","./types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\types.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cuser-operation-controller%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./UserOperationController.cjs"), exports);
__exportStar(require("./types.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/user-operation-controller",file:"node_modules\\@metamask\\user-operation-controller\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\logger.cjs", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cuser-operation-controller%5Cdist%5Clogger.cjs
      return function (require, module, exports) {
"use strict";
/* istanbul ignore file */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createModuleLogger = exports.projectLogger = void 0;
const utils_1 = require("@metamask/utils");
Object.defineProperty(exports, "createModuleLogger", { enumerable: true, get: function () { return utils_1.createModuleLogger; } });
exports.projectLogger = (0, utils_1.createProjectLogger)('user-operation-controller');

      };
    };
  }
  }
}, {package:"@metamask/user-operation-controller",file:"node_modules\\@metamask\\user-operation-controller\\dist\\logger.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\types.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cuser-operation-controller%5Cdist%5Ctypes.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserOperationStatus = void 0;
/**
 * The possible statuses of a single user operation.
 */
var UserOperationStatus;
(function (UserOperationStatus) {
    UserOperationStatus["Unapproved"] = "unapproved";
    UserOperationStatus["Approved"] = "approved";
    UserOperationStatus["Signed"] = "signed";
    UserOperationStatus["Submitted"] = "submitted";
    UserOperationStatus["Failed"] = "failed";
    UserOperationStatus["Confirmed"] = "confirmed";
})(UserOperationStatus || (exports.UserOperationStatus = UserOperationStatus = {}));

      };
    };
  }
  }
}, {package:"@metamask/user-operation-controller",file:"node_modules\\@metamask\\user-operation-controller\\dist\\types.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\utils\\chain-id.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cuser-operation-controller%5Cdist%5Cutils%5Cchain-id.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toEip155ChainId = void 0;
/**
 * Converts a chain ID string to a compliant CAIP-2 chain ID reference for EIP-155 chains.
 *
 * @param chainId - Chain ID string
 * @returns An CAIP-2 chain ID reference for EIP-155 chains.
 */
function toEip155ChainId(chainId) {
    const chainIdNumber = Number(chainId);
    // If for some reason the chainId isn't convertible to a decimal integer representation, we fallback
    // to the initial `chainId`.
    return Number.isInteger(chainIdNumber) ? chainIdNumber.toString() : chainId;
}
exports.toEip155ChainId = toEip155ChainId;

      };
    };
  }
  }
}, {package:"@metamask/user-operation-controller",file:"node_modules\\@metamask\\user-operation-controller\\dist\\utils\\chain-id.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\utils\\gas-fees.cjs", {"../constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\constants.cjs","../logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\logger.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/eth-query":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-query\\index.js","@metamask/gas-fee-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gas-fee-controller\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cuser-operation-controller%5Cdist%5Cutils%5Cgas-fees.cjs
      return function (require, module, exports) {
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateGasFees = void 0;
const controller_utils_1 = require("@metamask/controller-utils");
const eth_query_1 = __importDefault(require("@metamask/eth-query"));
const gas_fee_controller_1 = require("@metamask/gas-fee-controller");
const transaction_controller_1 = require("@metamask/transaction-controller");
const utils_1 = require("@metamask/utils");
const constants_1 = require("../constants.cjs");
const logger_1 = require("../logger.cjs");
const log = (0, logger_1.createModuleLogger)(logger_1.projectLogger, 'gas-fees');
/**
 * Populates the gas fee properties for a user operation.
 * @param request - The request to update the gas fees.
 * @param request.getGasFeeEstimates - A callback to get gas fee estimates.
 * @param request.metadata - The metadata for the user operation.
 * @param request.originalRequest - The original request to add the user operation.
 * @param request.provider - A provider to query the network.
 * @param request.transaction - The transaction that created the user operation.
 */
async function updateGasFees(request) {
    const { metadata, originalRequest, transaction } = request;
    const { userOperation } = metadata;
    let suggestedGasFees;
    const getGasFeeEstimates = async () => {
        if (!suggestedGasFees) {
            suggestedGasFees = await getSuggestedGasFees(request);
        }
        return suggestedGasFees;
    };
    userOperation.maxFeePerGas = await getMaxFeePerGas(originalRequest, getGasFeeEstimates, transaction);
    userOperation.maxPriorityFeePerGas = await getMaxPriorityFeePerGas(originalRequest, getGasFeeEstimates, userOperation, transaction);
    metadata.userFeeLevel = getUserFeeLevel(metadata, originalRequest, suggestedGasFees, transaction);
}
exports.updateGasFees = updateGasFees;
/**
 * Gets the maxFeePerGas for a user operation.
 * @param originalRequest - The original request to add the user operation.
 * @param getGetFasEstimates - A callback to get gas fee estimates.
 * @param transaction - The transaction that created the user operation.
 * @returns The maxFeePerGas for the user operation.
 */
async function getMaxFeePerGas(originalRequest, getGetFasEstimates, transaction) {
    const { maxFeePerGas, maxPriorityFeePerGas } = originalRequest;
    const { gasPrice } = transaction ?? {};
    if (!isGasFeeEmpty(maxFeePerGas)) {
        log('Using maxFeePerGas from request', maxFeePerGas);
        return maxFeePerGas;
    }
    if (isGasFeeEmpty(maxPriorityFeePerGas) && gasPrice) {
        log('Setting maxFeePerGas to transaction gasPrice', gasPrice);
        return gasPrice;
    }
    const { maxFeePerGas: suggestedMaxFeePerGas } = await getGetFasEstimates();
    if (!suggestedMaxFeePerGas) {
        throw new Error('Failed to get gas fee estimate for maxFeePerGas');
    }
    log('Using maxFeePerGas from estimate', suggestedMaxFeePerGas);
    return suggestedMaxFeePerGas;
}
/**
 * Gets the maxPriorityFeePerGas for a user operation.
 * @param originalRequest - The original request to add the user operation.
 * @param getGetFasEstimates - A callback to get gas fee estimates.
 * @param userOperation - The user operation being updated.
 * @param transaction - The transaction that created the user operation.
 * @returns The maxPriorityFeePerGas for the user operation.
 */
async function getMaxPriorityFeePerGas(originalRequest, getGetFasEstimates, userOperation, transaction) {
    const { maxFeePerGas, maxPriorityFeePerGas } = originalRequest;
    const { gasPrice } = transaction ?? {};
    const { maxFeePerGas: updatedMaxFeePerGas } = userOperation;
    if (!isGasFeeEmpty(maxPriorityFeePerGas)) {
        log('Using maxPriorityFeePerGas from request', maxPriorityFeePerGas);
        return maxPriorityFeePerGas;
    }
    if (isGasFeeEmpty(maxFeePerGas) && gasPrice) {
        log('Setting maxPriorityFeePerGas to transaction gasPrice', gasPrice);
        return gasPrice;
    }
    const { maxPriorityFeePerGas: suggestedMaxPriorityFeePerGas } = await getGetFasEstimates();
    if (suggestedMaxPriorityFeePerGas) {
        log('Using maxPriorityFeePerGas from estimate', suggestedMaxPriorityFeePerGas);
        return suggestedMaxPriorityFeePerGas;
    }
    log('Setting maxPriorityFeePerGas to maxFeePerGas', updatedMaxFeePerGas);
    return updatedMaxFeePerGas;
}
/**
 * Gets the userFeeLevel for a user operation.
 * @param metadata - The metadata for the user operation.
 * @param originalRequest - The original request to add the user operation.
 * @param suggestedGasFees - The suggested gas fees, if any.
 * @param transaction - The transaction that created the user operation.
 * @returns The userFeeLevel for the user operation.
 */
function getUserFeeLevel(metadata, originalRequest, suggestedGasFees, transaction) {
    const { origin } = metadata;
    const { maxFeePerGas, maxPriorityFeePerGas } = originalRequest;
    const { maxFeePerGas: suggestedMaxFeePerGas, maxPriorityFeePerGas: suggestedMaxPriorityFeePerGas, } = suggestedGasFees || {};
    if (isGasFeeEmpty(maxFeePerGas) &&
        isGasFeeEmpty(maxPriorityFeePerGas) &&
        transaction?.gasPrice) {
        return origin === controller_utils_1.ORIGIN_METAMASK
            ? transaction_controller_1.UserFeeLevel.CUSTOM
            : transaction_controller_1.UserFeeLevel.DAPP_SUGGESTED;
    }
    if (isGasFeeEmpty(maxFeePerGas) &&
        isGasFeeEmpty(maxPriorityFeePerGas) &&
        suggestedMaxFeePerGas &&
        suggestedMaxPriorityFeePerGas) {
        return transaction_controller_1.UserFeeLevel.MEDIUM;
    }
    if (origin === controller_utils_1.ORIGIN_METAMASK) {
        return transaction_controller_1.UserFeeLevel.CUSTOM;
    }
    return transaction_controller_1.UserFeeLevel.DAPP_SUGGESTED;
}
/**
 * Gets suggested gas fees.
 * @param request - The request to update the gas fees.
 * @param request.getGasFeeEstimates - A callback to get gas fee estimates.
 * @param request.provider - A provider to query the network.
 * @returns The suggested gas fees.
 */
async function getSuggestedGasFees(request) {
    const { getGasFeeEstimates, provider } = request;
    try {
        const { gasFeeEstimates, gasEstimateType } = await getGasFeeEstimates();
        if (gasEstimateType === gas_fee_controller_1.GAS_ESTIMATE_TYPES.FEE_MARKET) {
            /* istanbul ignore next */
            const { medium: { suggestedMaxPriorityFeePerGas, suggestedMaxFeePerGas } = {}, } = gasFeeEstimates;
            if (suggestedMaxPriorityFeePerGas && suggestedMaxFeePerGas) {
                const values = {
                    maxFeePerGas: gweiDecimalToWeiHex(suggestedMaxFeePerGas),
                    maxPriorityFeePerGas: gweiDecimalToWeiHex(suggestedMaxPriorityFeePerGas),
                };
                log('Using medium values from fee market estimate', values);
                return values;
            }
        }
        if (gasEstimateType === gas_fee_controller_1.GAS_ESTIMATE_TYPES.LEGACY) {
            const maxFeePerGas = gweiDecimalToWeiHex(gasFeeEstimates.medium);
            log('Using medium value from legacy estimate', maxFeePerGas);
            return {
                maxFeePerGas,
            };
        }
        if (gasEstimateType === gas_fee_controller_1.GAS_ESTIMATE_TYPES.ETH_GASPRICE) {
            const maxFeePerGas = gweiDecimalToWeiHex(gasFeeEstimates.gasPrice);
            log('Using gasPrice from estimate', maxFeePerGas);
            return {
                maxFeePerGas,
            };
        }
    }
    catch (error) {
        log('Failed to get estimate', error);
    }
    const gasPriceDecimal = (await (0, controller_utils_1.query)(new eth_query_1.default(provider), 'gasPrice'));
    if (!gasPriceDecimal) {
        return {};
    }
    const maxFeePerGas = (0, utils_1.add0x)(gasPriceDecimal.toString(16));
    log('Using gasPrice from network as fallback', maxFeePerGas);
    return { maxFeePerGas };
}
/**
 * Converts a GWEI decimal string to a WEI hexadecimal string.
 * @param value - The GWEI decimal string to convert.
 * @returns The WEI hexadecimal string.
 */
function gweiDecimalToWeiHex(value) {
    return (0, controller_utils_1.toHex)((0, controller_utils_1.gweiDecToWEIBN)(value));
}
/**
 * Checks if a gas fee property is empty.
 * @param value - The gas fee value to check.
 * @returns Whether the gas fee property is empty.
 */
function isGasFeeEmpty(value) {
    return !value || value === constants_1.EMPTY_BYTES;
}

      };
    };
  }
  }
}, {package:"@metamask/user-operation-controller",file:"node_modules\\@metamask\\user-operation-controller\\dist\\utils\\gas-fees.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\utils\\gas.cjs", {"../constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\constants.cjs","../helpers/Bundler.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\helpers\\Bundler.cjs","../logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\logger.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","bn.js":"D:\\code\\v\\metamask-extension\\node_modules\\bn.js\\lib\\bn.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cuser-operation-controller%5Cdist%5Cutils%5Cgas.cjs
      return function (require, module, exports) {
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateGas = void 0;
const controller_utils_1 = require("@metamask/controller-utils");
const utils_1 = require("@metamask/utils");
const bn_js_1 = __importDefault(require("bn.js"));
const constants_1 = require("../constants.cjs");
const Bundler_1 = require("../helpers/Bundler.cjs");
const logger_1 = require("../logger.cjs");
const log = (0, logger_1.createModuleLogger)(logger_1.projectLogger, 'gas');
/**
 * A multiplier to apply to all gas estimate values returned from the bundler.
 */
const GAS_ESTIMATE_MULTIPLIER = 1.5;
/**
 * Populates the gas properties for a user operation.
 * @param metadata - The metadata for the user operation.
 * @param prepareResponse - The prepare response from the smart contract account.
 * @param entrypoint - Address of the entrypoint contract.
 */
async function updateGas(metadata, prepareResponse, entrypoint) {
    const { userOperation } = metadata;
    if (prepareResponse.gas) {
        userOperation.callGasLimit = prepareResponse.gas.callGasLimit;
        userOperation.preVerificationGas = prepareResponse.gas.preVerificationGas;
        userOperation.verificationGasLimit =
            prepareResponse.gas.verificationGasLimit;
        log('Using gas values from smart contract account', {
            callGasLimit: userOperation.callGasLimit,
            preVerificationGas: userOperation.preVerificationGas,
            verificationGasLimit: userOperation.verificationGasLimit,
        });
        return;
    }
    const payload = {
        ...userOperation,
        maxFeePerGas: constants_1.VALUE_ZERO,
        maxPriorityFeePerGas: constants_1.VALUE_ZERO,
        callGasLimit: constants_1.VALUE_ZERO,
        preVerificationGas: constants_1.VALUE_ZERO,
        verificationGasLimit: '0xF4240',
    };
    const bundler = new Bundler_1.Bundler(metadata.bundlerUrl);
    const estimate = await bundler.estimateUserOperationGas(payload, entrypoint);
    userOperation.callGasLimit = normalizeGasEstimate(estimate.callGasLimit);
    userOperation.preVerificationGas = normalizeGasEstimate(estimate.preVerificationGas);
    userOperation.verificationGasLimit = normalizeGasEstimate((estimate.verificationGasLimit ?? estimate.verificationGas));
    log('Using buffered gas values from bundler estimate', {
        callGasLimit: userOperation.callGasLimit,
        preVerificationGas: userOperation.preVerificationGas,
        verificationGasLimit: userOperation.verificationGasLimit,
        multiplier: GAS_ESTIMATE_MULTIPLIER,
        estimate,
    });
}
exports.updateGas = updateGas;
/**
 * Normalizes a gas estimate value from the bundler.
 * @param rawValue - The raw value to normalize.
 * @returns The normalized value as a hexadecimal string.
 */
function normalizeGasEstimate(rawValue) {
    const value = typeof rawValue === 'string' ? (0, controller_utils_1.hexToBN)(rawValue) : new bn_js_1.default(rawValue);
    const bufferedValue = value.muln(GAS_ESTIMATE_MULTIPLIER);
    return (0, utils_1.add0x)(bufferedValue.toString(16));
}

      };
    };
  }
  }
}, {package:"@metamask/user-operation-controller",file:"node_modules\\@metamask\\user-operation-controller\\dist\\utils\\gas.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\utils\\transaction.cjs", {"../constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\constants.cjs","../types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\types.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","bn.js":"D:\\code\\v\\metamask-extension\\node_modules\\bn.js\\lib\\bn.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cuser-operation-controller%5Cdist%5Cutils%5Ctransaction.cjs
      return function (require, module, exports) {
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTransactionMetadata = void 0;
const transaction_controller_1 = require("@metamask/transaction-controller");
const utils_1 = require("@metamask/utils");
const bn_js_1 = __importDefault(require("bn.js"));
const constants_1 = require("../constants.cjs");
const types_1 = require("../types.cjs");
/**
 * Converts a user operation metadata object into a transaction metadata object.
 * @param metadata - The user operation metadata object to convert.
 * @returns The equivalent transaction metadata object.
 */
function getTransactionMetadata(metadata) {
    const { actualGasCost, actualGasUsed, baseFeePerGas, chainId, error: rawError, origin, transactionHash, id, swapsMetadata, time, transactionParams, transactionType, userFeeLevel: rawUserFeeLevel, userOperation, } = metadata;
    if (!transactionParams) {
        return undefined;
    }
    // effectiveGasPrice = actualGasCost / actualGasUsed
    const effectiveGasPrice = actualGasCost && actualGasUsed
        ? (0, utils_1.add0x)(new bn_js_1.default((0, utils_1.remove0x)(actualGasCost), 16)
            .div(new bn_js_1.default((0, utils_1.remove0x)(actualGasUsed), 16))
            .toString(16))
        : undefined;
    const error = (rawError
        ? {
            name: rawError.name,
            message: rawError.message,
            stack: rawError.stack,
            code: rawError.code,
            rpc: rawError.rpc,
        }
        : undefined);
    const status = {
        [types_1.UserOperationStatus.Unapproved]: transaction_controller_1.TransactionStatus.unapproved,
        [types_1.UserOperationStatus.Approved]: transaction_controller_1.TransactionStatus.approved,
        [types_1.UserOperationStatus.Signed]: transaction_controller_1.TransactionStatus.signed,
        [types_1.UserOperationStatus.Submitted]: transaction_controller_1.TransactionStatus.submitted,
        [types_1.UserOperationStatus.Confirmed]: transaction_controller_1.TransactionStatus.confirmed,
        [types_1.UserOperationStatus.Failed]: transaction_controller_1.TransactionStatus.failed,
    }[metadata.status];
    const gas = addHex(userOperation.preVerificationGas, userOperation.verificationGasLimit, userOperation.callGasLimit);
    const hasPaymaster = userOperation.paymasterAndData !== constants_1.EMPTY_BYTES;
    const maxFeePerGas = hasPaymaster ? constants_1.VALUE_ZERO : userOperation.maxFeePerGas;
    const maxPriorityFeePerGas = hasPaymaster
        ? constants_1.VALUE_ZERO
        : userOperation.maxPriorityFeePerGas;
    const nonce = userOperation.nonce === constants_1.EMPTY_BYTES ? undefined : userOperation.nonce;
    const txParams = {
        ...transactionParams,
        from: userOperation.sender,
        gas,
        nonce,
        maxFeePerGas,
        maxPriorityFeePerGas,
    };
    // User operations only support EIP-1559 gas fee properties.
    delete txParams.gasPrice;
    const swaps = {
        approvalTxId: swapsMetadata?.approvalTxId ?? undefined,
        destinationTokenAddress: swapsMetadata?.destinationTokenAddress ?? undefined,
        destinationTokenAmount: swapsMetadata?.destinationTokenAmount ?? undefined,
        destinationTokenDecimals: swapsMetadata?.destinationTokenDecimals ?? undefined,
        destinationTokenSymbol: swapsMetadata?.destinationTokenSymbol ?? undefined,
        estimatedBaseFee: swapsMetadata?.estimatedBaseFee ?? undefined,
        sourceTokenAddress: swapsMetadata?.sourceTokenAddress ?? undefined,
        sourceTokenAmount: swapsMetadata?.sourceTokenAmount ?? undefined,
        sourceTokenDecimals: swapsMetadata?.sourceTokenDecimals ?? undefined,
        sourceTokenSymbol: swapsMetadata?.sourceTokenSymbol ?? undefined,
        swapAndSendRecipient: swapsMetadata?.swapAndSendRecipient ?? undefined,
        swapMetaData: swapsMetadata?.swapMetaData ?? undefined,
        swapTokenValue: swapsMetadata?.swapTokenValue ?? undefined,
    };
    const userFeeLevel = hasPaymaster ? transaction_controller_1.UserFeeLevel.CUSTOM : rawUserFeeLevel;
    return {
        baseFeePerGas: baseFeePerGas ?? undefined,
        chainId: chainId,
        error,
        hash: transactionHash ?? undefined,
        id,
        isUserOperation: true,
        networkClientId: 'user-operation',
        origin,
        status,
        time,
        txParams,
        txReceipt: {
            effectiveGasPrice: effectiveGasPrice ?? undefined,
            gasUsed: actualGasUsed ?? undefined,
        },
        type: transactionType ?? undefined,
        userFeeLevel: userFeeLevel,
        ...swaps,
    };
}
exports.getTransactionMetadata = getTransactionMetadata;
/**
 * Adds the given hexadecimal values together.
 * @param values - The hexadecimal values to add together.
 * @returns The sum of the given hexadecimal values.
 */
function addHex(...values) {
    const total = new bn_js_1.default(0);
    for (const value of values) {
        if (!value) {
            continue;
        }
        total.iadd(new bn_js_1.default((0, utils_1.remove0x)(value), 16));
    }
    return (0, utils_1.add0x)(total.toString(16));
}

      };
    };
  }
  }
}, {package:"@metamask/user-operation-controller",file:"node_modules\\@metamask\\user-operation-controller\\dist\\utils\\transaction.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\utils\\validation.cjs", {"../constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\user-operation-controller\\dist\\constants.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cuser-operation-controller%5Cdist%5Cutils%5Cvalidation.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateSignUserOperationResponse = exports.validateUpdateUserOperationResponse = exports.validatePrepareUserOperationResponse = exports.validateAddUserOperationOptions = exports.validateAddUserOperationRequest = void 0;
const superstruct_1 = require("@metamask/superstruct");
const transaction_controller_1 = require("@metamask/transaction-controller");
const utils_1 = require("@metamask/utils");
const constants_1 = require("../constants.cjs");
/**
 * Validate a request to add a user operation.
 * @param request - The request to validate.
 */
function validateAddUserOperationRequest(request) {
    const Hex = defineHex();
    const HexOrEmptyBytes = defineHexOrEmptyBytes();
    const ValidRequest = (0, superstruct_1.object)({
        data: (0, superstruct_1.optional)(HexOrEmptyBytes),
        from: Hex,
        maxFeePerGas: (0, superstruct_1.optional)(Hex),
        maxPriorityFeePerGas: (0, superstruct_1.optional)(Hex),
        to: (0, superstruct_1.optional)(Hex),
        value: (0, superstruct_1.optional)(Hex),
    });
    validate(request, ValidRequest, 'Invalid request to add user operation');
}
exports.validateAddUserOperationRequest = validateAddUserOperationRequest;
/**
 * Validate the options when adding a user operation.
 * @param options - The options to validate.
 */
function validateAddUserOperationOptions(options) {
    const ValidOptions = (0, superstruct_1.object)({
        networkClientId: (0, superstruct_1.string)(),
        origin: (0, superstruct_1.string)(),
        requireApproval: (0, superstruct_1.optional)((0, superstruct_1.boolean)()),
        smartContractAccount: (0, superstruct_1.optional)((0, superstruct_1.object)({
            prepareUserOperation: (0, superstruct_1.func)(),
            updateUserOperation: (0, superstruct_1.func)(),
            signUserOperation: (0, superstruct_1.func)(),
        })),
        swaps: (0, superstruct_1.optional)((0, superstruct_1.object)({
            approvalTxId: (0, superstruct_1.optional)((0, superstruct_1.string)()),
            destinationTokenAddress: (0, superstruct_1.optional)((0, superstruct_1.string)()),
            destinationTokenDecimals: (0, superstruct_1.optional)((0, superstruct_1.number)()),
            destinationTokenSymbol: (0, superstruct_1.optional)((0, superstruct_1.string)()),
            estimatedBaseFee: (0, superstruct_1.optional)((0, superstruct_1.string)()),
            sourceTokenSymbol: (0, superstruct_1.optional)((0, superstruct_1.string)()),
            swapMetaData: (0, superstruct_1.optional)((0, superstruct_1.object)()),
            swapTokenValue: (0, superstruct_1.optional)((0, superstruct_1.string)()),
            destinationTokenAmount: (0, superstruct_1.optional)((0, superstruct_1.string)()),
            sourceTokenAddress: (0, superstruct_1.optional)((0, superstruct_1.string)()),
            sourceTokenAmount: (0, superstruct_1.optional)((0, superstruct_1.string)()),
            sourceTokenDecimals: (0, superstruct_1.optional)((0, superstruct_1.number)()),
            swapAndSendRecipient: (0, superstruct_1.optional)((0, superstruct_1.string)()),
        })),
        type: (0, superstruct_1.optional)((0, superstruct_1.enums)(Object.values(transaction_controller_1.TransactionType))),
    });
    validate(options, ValidOptions, 'Invalid options to add user operation');
}
exports.validateAddUserOperationOptions = validateAddUserOperationOptions;
/**
 * Validate the response from a smart contract account when preparing the user operation.
 * @param response - The response to validate.
 */
function validatePrepareUserOperationResponse(response) {
    const Hex = defineHex();
    const HexOrEmptyBytes = defineHexOrEmptyBytes();
    const ValidResponse = (0, superstruct_1.refine)((0, superstruct_1.object)({
        bundler: (0, superstruct_1.string)(),
        callData: Hex,
        dummyPaymasterAndData: (0, superstruct_1.optional)(HexOrEmptyBytes),
        dummySignature: (0, superstruct_1.optional)(HexOrEmptyBytes),
        gas: (0, superstruct_1.optional)((0, superstruct_1.object)({
            callGasLimit: Hex,
            preVerificationGas: Hex,
            verificationGasLimit: Hex,
        })),
        initCode: (0, superstruct_1.optional)(HexOrEmptyBytes),
        nonce: Hex,
        sender: Hex,
    }), 'ValidPrepareUserOperationResponse', ({ gas, dummySignature }) => {
        if (!gas && (!dummySignature || dummySignature === constants_1.EMPTY_BYTES)) {
            return 'Must specify dummySignature if not specifying gas';
        }
        /* istanbul ignore next */
        return true;
    });
    validate(response, ValidResponse, 'Invalid response when preparing user operation');
}
exports.validatePrepareUserOperationResponse = validatePrepareUserOperationResponse;
/**
 * Validate the response from a smart contract account when updating the user operation.
 * @param response - The response to validate.
 */
function validateUpdateUserOperationResponse(response) {
    const ValidResponse = (0, superstruct_1.optional)((0, superstruct_1.object)({
        paymasterAndData: (0, superstruct_1.optional)(defineHexOrEmptyBytes()),
        callGasLimit: (0, superstruct_1.optional)(defineHexOrEmptyBytes()),
        preVerificationGas: (0, superstruct_1.optional)(defineHexOrEmptyBytes()),
        verificationGasLimit: (0, superstruct_1.optional)(defineHexOrEmptyBytes()),
    }));
    validate(response, ValidResponse, 'Invalid response when updating user operation');
}
exports.validateUpdateUserOperationResponse = validateUpdateUserOperationResponse;
/**
 * Validate the response from a smart contract account when signing the user operation.
 * @param response - The response to validate.
 */
function validateSignUserOperationResponse(response) {
    const Hex = defineHex();
    const ValidResponse = (0, superstruct_1.object)({
        signature: Hex,
    });
    validate(response, ValidResponse, 'Invalid response when signing user operation');
}
exports.validateSignUserOperationResponse = validateSignUserOperationResponse;
/**
 * Validate data against a struct.
 * @param data - The data to validate.
 * @param struct - The struct to validate against.
 * @param message - The message to throw if validation fails.
 */
// TODO: Either fix this lint violation or explain why it's necessary to ignore.
// eslint-disable-next-line @typescript-eslint/naming-convention
function validate(data, struct, message) {
    try {
        (0, superstruct_1.assert)(data, struct, message);
    }
    catch (error) {
        const causes = error
            .failures()
            .map((failure) => {
            if (!failure.path.length) {
                return failure.message;
            }
            return `${failure.path.join('.')} - ${failure.message}`;
        })
            .join('\n');
        const finalMessage = `${message}\n${causes}`;
        throw new Error(finalMessage);
    }
}
/**
 * Define the Hex type used by superstruct.
 * @returns The Hex superstruct type.
 */
function defineHex() {
    return (0, superstruct_1.define)('Hexadecimal String', (value) => (0, utils_1.isStrictHexString)(value));
}
/**
 * Define the HexOrEmptyBytes type used by superstruct.
 * @returns The HexOrEmptyBytes superstruct type.
 */
function defineHexOrEmptyBytes() {
    return (0, superstruct_1.define)('Hexadecimal String or 0x', (value) => (0, utils_1.isStrictHexString)(value) || value === constants_1.EMPTY_BYTES);
}

      };
    };
  }
  }
}, {package:"@metamask/user-operation-controller",file:"node_modules\\@metamask\\user-operation-controller\\dist\\utils\\validation.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@multiformats\\base-x\\src\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@multiformats%5Cbase-x%5Csrc%5Cindex.js
      return function (require, module, exports) {
'use strict'
// base-x encoding / decoding
// Copyright (c) 2018 base-x contributors
// Copyright (c) 2014-2018 The Bitcoin Core developers (base58.cpp)
// Distributed under the MIT software license, see the accompanying
// file LICENSE or http://www.opensource.org/licenses/mit-license.php.
function base (ALPHABET) {
  if (ALPHABET.length >= 255) { throw new TypeError('Alphabet too long') }
  var BASE_MAP = new Uint8Array(256)
  for (var j = 0; j < BASE_MAP.length; j++) {
    BASE_MAP[j] = 255
  }
  for (var i = 0; i < ALPHABET.length; i++) {
    var x = ALPHABET.charAt(i)
    var xc = x.charCodeAt(0)
    if (BASE_MAP[xc] !== 255) { throw new TypeError(x + ' is ambiguous') }
    BASE_MAP[xc] = i
  }
  var BASE = ALPHABET.length
  var LEADER = ALPHABET.charAt(0)
  var FACTOR = Math.log(BASE) / Math.log(256) // log(BASE) / log(256), rounded up
  var iFACTOR = Math.log(256) / Math.log(BASE) // log(256) / log(BASE), rounded up
  function encode (source) {
    if (source instanceof Uint8Array) {
    } else if (ArrayBuffer.isView(source)) {
      source = new Uint8Array(source.buffer, source.byteOffset, source.byteLength)
    } else if (Array.isArray(source)) {
      source = Uint8Array.from(source)
    }
    if (!(source instanceof Uint8Array)) { throw new TypeError('Expected Uint8Array') }
    if (source.length === 0) { return '' }
        // Skip & count leading zeroes.
    var zeroes = 0
    var length = 0
    var pbegin = 0
    var pend = source.length
    while (pbegin !== pend && source[pbegin] === 0) {
      pbegin++
      zeroes++
    }
        // Allocate enough space in big-endian base58 representation.
    var size = ((pend - pbegin) * iFACTOR + 1) >>> 0
    var b58 = new Uint8Array(size)
        // Process the bytes.
    while (pbegin !== pend) {
      var carry = source[pbegin]
            // Apply "b58 = b58 * 256 + ch".
      var i = 0
      for (var it1 = size - 1; (carry !== 0 || i < length) && (it1 !== -1); it1--, i++) {
        carry += (256 * b58[it1]) >>> 0
        b58[it1] = (carry % BASE) >>> 0
        carry = (carry / BASE) >>> 0
      }
      if (carry !== 0) { throw new Error('Non-zero carry') }
      length = i
      pbegin++
    }
        // Skip leading zeroes in base58 result.
    var it2 = size - length
    while (it2 !== size && b58[it2] === 0) {
      it2++
    }
        // Translate the result into a string.
    var str = LEADER.repeat(zeroes)
    for (; it2 < size; ++it2) { str += ALPHABET.charAt(b58[it2]) }
    return str
  }
  function decodeUnsafe (source) {
    if (typeof source !== 'string') { throw new TypeError('Expected String') }
    if (source.length === 0) { return new Uint8Array() }
    var psz = 0
        // Skip leading spaces.
    if (source[psz] === ' ') { return }
        // Skip and count leading '1's.
    var zeroes = 0
    var length = 0
    while (source[psz] === LEADER) {
      zeroes++
      psz++
    }
        // Allocate enough space in big-endian base256 representation.
    var size = (((source.length - psz) * FACTOR) + 1) >>> 0 // log(58) / log(256), rounded up.
    var b256 = new Uint8Array(size)
        // Process the characters.
    while (source[psz]) {
            // Decode character
      var carry = BASE_MAP[source.charCodeAt(psz)]
            // Invalid character
      if (carry === 255) { return }
      var i = 0
      for (var it3 = size - 1; (carry !== 0 || i < length) && (it3 !== -1); it3--, i++) {
        carry += (BASE * b256[it3]) >>> 0
        b256[it3] = (carry % 256) >>> 0
        carry = (carry / 256) >>> 0
      }
      if (carry !== 0) { throw new Error('Non-zero carry') }
      length = i
      psz++
    }
        // Skip trailing spaces.
    if (source[psz] === ' ') { return }
        // Skip leading zeroes in b256.
    var it4 = size - length
    while (it4 !== size && b256[it4] === 0) {
      it4++
    }
    var vch = new Uint8Array(zeroes + (size - it4))
    var j = zeroes
    while (it4 !== size) {
      vch[j++] = b256[it4++]
    }
    return vch
  }
  function decode (string) {
    var buffer = decodeUnsafe(string)
    if (buffer) { return buffer }
    throw new Error('Non-base' + BASE + ' character')
  }
  return {
    encode: encode,
    decodeUnsafe: decodeUnsafe,
    decode: decode
  }
}
module.exports = base

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>cids>multibase>@multiformats/base-x",file:"node_modules\\@multiformats\\base-x\\src\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@open-rpc\\meta-schema\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@open-rpc%5Cmeta-schema%5Cindex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.openrpcDocument = void 0;
exports.openrpcDocument = { "$schema": "https://meta.json-schema.tools/", "$id": "https://meta.open-rpc.org/", "title": "openrpcDocument", "type": "object", "required": ["info", "methods", "openrpc"], "additionalProperties": false, "patternProperties": { "^x-": { "$ref": "#/definitions/specificationExtension" } }, "properties": { "openrpc": { "title": "openrpc", "type": "string", "enum": ["1.3.2", "1.3.1", "1.3.0", "1.2.6", "1.2.5", "1.2.4", "1.2.3", "1.2.2", "1.2.1", "1.2.0", "1.1.12", "1.1.11", "1.1.10", "1.1.9", "1.1.8", "1.1.7", "1.1.6", "1.1.5", "1.1.4", "1.1.3", "1.1.2", "1.1.1", "1.1.0", "1.0.0", "1.0.0-rc1", "1.0.0-rc0"] }, "info": { "$ref": "#/definitions/infoObject" }, "externalDocs": { "$ref": "#/definitions/externalDocumentationObject" }, "servers": { "title": "servers", "type": "array", "additionalItems": false, "items": { "$ref": "#/definitions/serverObject" } }, "methods": { "title": "methods", "type": "array", "additionalItems": false, "items": { "title": "methodOrReference", "oneOf": [{ "$ref": "#/definitions/methodObject" }, { "$ref": "#/definitions/referenceObject" }] } }, "components": { "title": "components", "type": "object", "properties": { "schemas": { "title": "schemaComponents", "type": "object", "patternProperties": { "[0-z]+": { "$ref": "#/definitions/JSONSchema" } } }, "links": { "title": "linkComponents", "type": "object", "patternProperties": { "[0-z]+": { "$ref": "#/definitions/linkObject" } } }, "errors": { "title": "errorComponents", "type": "object", "patternProperties": { "[0-z]+": { "$ref": "#/definitions/errorObject" } } }, "examples": { "title": "exampleComponents", "type": "object", "patternProperties": { "[0-z]+": { "$ref": "#/definitions/exampleObject" } } }, "examplePairings": { "title": "examplePairingComponents", "type": "object", "patternProperties": { "[0-z]+": { "$ref": "#/definitions/examplePairingObject" } } }, "contentDescriptors": { "title": "contentDescriptorComponents", "type": "object", "patternProperties": { "[0-z]+": { "$ref": "#/definitions/contentDescriptorObject" } } }, "tags": { "title": "tagComponents", "type": "object", "patternProperties": { "[0-z]+": { "$ref": "#/definitions/tagObject" } } } } }, "$schema": { "title": "metaSchema", "description": "JSON Schema URI (used by some editors)", "type": "string", "default": "https://meta.open-rpc.org/" } }, "definitions": { "specificationExtension": { "title": "specificationExtension" }, "JSONSchema": { "$ref": "https://meta.json-schema.tools" }, "referenceObject": { "title": "referenceObject", "type": "object", "additionalProperties": false, "required": ["$ref"], "properties": { "$ref": { "$ref": "https://meta.json-schema.tools/#/definitions/JSONSchemaObject/properties/$ref" } } }, "errorObject": { "title": "errorObject", "type": "object", "description": "Defines an application level error.", "additionalProperties": false, "required": ["code", "message"], "properties": { "code": { "title": "errorObjectCode", "description": "A Number that indicates the error type that occurred. This MUST be an integer. The error codes from and including -32768 to -32000 are reserved for pre-defined errors. These pre-defined errors SHOULD be assumed to be returned from any JSON-RPC api.", "type": "integer" }, "message": { "title": "errorObjectMessage", "description": "A String providing a short description of the error. The message SHOULD be limited to a concise single sentence.", "type": "string" }, "data": { "title": "errorObjectData", "description": "A Primitive or Structured value that contains additional information about the error. This may be omitted. The value of this member is defined by the Server (e.g. detailed error information, nested errors etc.)." } } }, "licenseObject": { "title": "licenseObject", "type": "object", "additionalProperties": false, "properties": { "name": { "title": "licenseObjectName", "type": "string" }, "url": { "title": "licenseObjectUrl", "type": "string" } }, "patternProperties": { "^x-": { "$ref": "#/definitions/specificationExtension" } } }, "contactObject": { "title": "contactObject", "type": "object", "additionalProperties": false, "properties": { "name": { "title": "contactObjectName", "type": "string" }, "email": { "title": "contactObjectEmail", "type": "string" }, "url": { "title": "contactObjectUrl", "type": "string" } }, "patternProperties": { "^x-": { "$ref": "#/definitions/specificationExtension" } } }, "infoObject": { "title": "infoObject", "type": "object", "additionalProperties": false, "required": ["title", "version"], "properties": { "title": { "title": "infoObjectProperties", "type": "string" }, "description": { "title": "infoObjectDescription", "type": "string" }, "termsOfService": { "title": "infoObjectTermsOfService", "type": "string", "format": "uri" }, "version": { "title": "infoObjectVersion", "type": "string" }, "contact": { "$ref": "#/definitions/contactObject" }, "license": { "$ref": "#/definitions/licenseObject" } }, "patternProperties": { "^x-": { "$ref": "#/definitions/specificationExtension" } } }, "serverObject": { "title": "serverObject", "type": "object", "required": ["url"], "additionalProperties": false, "properties": { "url": { "title": "serverObjectUrl", "type": "string", "format": "uri" }, "name": { "title": "serverObjectName", "type": "string" }, "description": { "title": "serverObjectDescription", "type": "string" }, "summary": { "title": "serverObjectSummary", "type": "string" }, "variables": { "title": "serverObjectVariables", "type": "object", "patternProperties": { "[0-z]+": { "title": "serverObjectVariable", "type": "object", "required": ["default"], "properties": { "default": { "title": "serverObjectVariableDefault", "type": "string" }, "description": { "title": "serverObjectVariableDescription", "type": "string" }, "enum": { "title": "serverObjectVariableEnum", "type": "array", "items": { "title": "serverObjectVariableEnumItem", "type": "string" } } } } } } }, "patternProperties": { "^x-": { "$ref": "#/definitions/specificationExtension" } } }, "linkObject": { "title": "linkObject", "type": "object", "additionalProperties": false, "properties": { "name": { "title": "linkObjectName", "type": "string", "minLength": 1 }, "summary": { "title": "linkObjectSummary", "type": "string" }, "method": { "title": "linkObjectMethod", "type": "string" }, "description": { "title": "linkObjectDescription", "type": "string" }, "params": { "title": "linkObjectParams" }, "server": { "title": "linkObjectServer", "$ref": "#/definitions/serverObject" } }, "patternProperties": { "^x-": { "$ref": "#/definitions/specificationExtension" } } }, "externalDocumentationObject": { "title": "externalDocumentationObject", "type": "object", "additionalProperties": false, "description": "information about external documentation", "required": ["url"], "properties": { "description": { "title": "externalDocumentationObjectDescription", "type": "string" }, "url": { "title": "externalDocumentationObjectUrl", "type": "string", "format": "uri" } }, "patternProperties": { "^x-": { "$ref": "#/definitions/specificationExtension" } } }, "methodObject": { "title": "methodObject", "type": "object", "required": ["name", "params"], "additionalProperties": false, "properties": { "name": { "title": "methodObjectName", "description": "The cannonical name for the method. The name MUST be unique within the methods array.", "type": "string", "minLength": 1 }, "description": { "title": "methodObjectDescription", "description": "A verbose explanation of the method behavior. GitHub Flavored Markdown syntax MAY be used for rich text representation.", "type": "string" }, "summary": { "title": "methodObjectSummary", "description": "A short summary of what the method does.", "type": "string" }, "servers": { "title": "servers", "type": "array", "additionalItems": false, "items": { "$ref": "#/definitions/serverObject" } }, "tags": { "title": "methodObjectTags", "type": "array", "items": { "title": "tagOrReference", "oneOf": [{ "$ref": "#/definitions/tagObject" }, { "$ref": "#/definitions/referenceObject" }] } }, "paramStructure": { "title": "methodObjectParamStructure", "type": "string", "description": "Format the server expects the params. Defaults to 'either'.", "enum": ["by-position", "by-name", "either"], "default": "either" }, "params": { "title": "methodObjectParams", "type": "array", "items": { "title": "contentDescriptorOrReference", "oneOf": [{ "$ref": "#/definitions/contentDescriptorObject" }, { "$ref": "#/definitions/referenceObject" }] } }, "result": { "title": "methodObjectResult", "oneOf": [{ "$ref": "#/definitions/contentDescriptorObject" }, { "$ref": "#/definitions/referenceObject" }] }, "errors": { "title": "methodObjectErrors", "description": "Defines an application level error.", "type": "array", "items": { "title": "errorOrReference", "oneOf": [{ "$ref": "#/definitions/errorObject" }, { "$ref": "#/definitions/referenceObject" }] } }, "links": { "title": "methodObjectLinks", "type": "array", "items": { "title": "linkOrReference", "oneOf": [{ "$ref": "#/definitions/linkObject" }, { "$ref": "#/definitions/referenceObject" }] } }, "examples": { "title": "methodObjectExamples", "type": "array", "items": { "title": "examplePairingOrReference", "oneOf": [{ "$ref": "#/definitions/examplePairingObject" }, { "$ref": "#/definitions/referenceObject" }] } }, "deprecated": { "title": "methodObjectDeprecated", "type": "boolean", "default": false }, "externalDocs": { "$ref": "#/definitions/externalDocumentationObject" } }, "patternProperties": { "^x-": { "$ref": "#/definitions/specificationExtension" } } }, "tagObject": { "title": "tagObject", "type": "object", "additionalProperties": false, "required": ["name"], "properties": { "name": { "title": "tagObjectName", "type": "string", "minLength": 1 }, "description": { "title": "tagObjectDescription", "type": "string" }, "externalDocs": { "$ref": "#/definitions/externalDocumentationObject" } }, "patternProperties": { "^x-": { "$ref": "#/definitions/specificationExtension" } } }, "exampleObject": { "title": "exampleObject", "type": "object", "required": ["name", "value"], "properties": { "summary": { "title": "exampleObjectSummary", "type": "string" }, "value": { "title": "exampleObjectValue" }, "description": { "title": "exampleObjectDescription", "type": "string" }, "name": { "title": "exampleObjectName", "type": "string", "minLength": 1 } }, "patternProperties": { "^x-": { "$ref": "#/definitions/specificationExtension" } } }, "examplePairingObject": { "title": "examplePairingObject", "type": "object", "required": ["name", "params"], "properties": { "name": { "title": "examplePairingObjectName", "type": "string", "minLength": 1 }, "description": { "title": "examplePairingObjectDescription", "type": "string" }, "params": { "title": "examplePairingObjectParams", "type": "array", "items": { "title": "exampleOrReference", "oneOf": [{ "$ref": "#/definitions/exampleObject" }, { "$ref": "#/definitions/referenceObject" }] } }, "result": { "title": "examplePairingObjectResult", "oneOf": [{ "$ref": "#/definitions/exampleObject" }, { "$ref": "#/definitions/referenceObject" }] } } }, "contentDescriptorObject": { "title": "contentDescriptorObject", "type": "object", "additionalProperties": false, "required": ["name", "schema"], "properties": { "name": { "title": "contentDescriptorObjectName", "type": "string", "minLength": 1 }, "description": { "title": "contentDescriptorObjectDescription", "type": "string" }, "summary": { "title": "contentDescriptorObjectSummary", "type": "string" }, "schema": { "$ref": "#/definitions/JSONSchema" }, "required": { "title": "contentDescriptorObjectRequired", "type": "boolean", "default": false }, "deprecated": { "title": "contentDescriptorObjectDeprecated", "type": "boolean", "default": false } }, "patternProperties": { "^x-": { "$ref": "#/definitions/specificationExtension" } } } } };
exports.default = exports.openrpcDocument;

      };
    };
  }
  }
}, {package:"@open-rpc/meta-schema",file:"node_modules\\@open-rpc\\meta-schema\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@open-rpc\\schema-utils-js\\build\\dereference-document.js", {"@json-schema-tools/dereferencer":"D:\\code\\v\\metamask-extension\\node_modules\\@json-schema-tools\\dereferencer\\build\\index.js","@json-schema-tools/reference-resolver":"D:\\code\\v\\metamask-extension\\node_modules\\@json-schema-tools\\reference-resolver\\build\\index-web.js","fast-safe-stringify":"D:\\code\\v\\metamask-extension\\node_modules\\fast-safe-stringify\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@open-rpc%5Cschema-utils-js%5Cbuild%5Cdereference-document.js
      return function (require, module, exports) {
"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenRPCDocumentDereferencingError = void 0;
var dereferencer_1 = __importDefault(require("@json-schema-tools/dereferencer"));
var reference_resolver_1 = __importDefault(require("@json-schema-tools/reference-resolver"));
var fast_safe_stringify_1 = __importDefault(require("fast-safe-stringify"));
/**
 * Provides an error interface for OpenRPC Document dereferencing problems
 *
 * @category Errors
 *
 */
var OpenRPCDocumentDereferencingError = /** @class */ (function () {
    /**
     * @param e The error that originated from jsonSchemaRefParser
     */
    function OpenRPCDocumentDereferencingError(e) {
        this.name = "OpenRPCDocumentDereferencingError";
        this.message = "The json schema provided cannot be dereferenced. Received Error: \n ".concat(e);
    }
    return OpenRPCDocumentDereferencingError;
}());
exports.OpenRPCDocumentDereferencingError = OpenRPCDocumentDereferencingError;
var derefItem = function (item, doc, resolver) { return __awaiter(void 0, void 0, void 0, function () {
    var $ref, err_1;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                $ref = item.$ref;
                if ($ref === undefined) {
                    return [2 /*return*/, item];
                }
                _a.label = 1;
            case 1:
                _a.trys.push([1, 3, , 4]);
                return [4 /*yield*/, resolver.resolve($ref, doc)];
            case 2: 
            // returns resolved value of the reference
            return [2 /*return*/, _a.sent()];
            case 3:
                err_1 = _a.sent();
                throw new OpenRPCDocumentDereferencingError([
                    "unable to eval pointer against OpenRPC Document.",
                    "error type: ".concat(err_1.name),
                    "instance: ".concat(err_1.instance),
                    "token: ".concat(err_1.token),
                    "pointer: ".concat($ref),
                    "reference object: ".concat((0, fast_safe_stringify_1.default)(item))
                ].join("\n"));
            case 4: return [2 /*return*/];
        }
    });
}); };
var derefItems = function (items, doc, resolver) { return __awaiter(void 0, void 0, void 0, function () {
    var dereffed, _i, items_1, i, _a, _b;
    return __generator(this, function (_c) {
        switch (_c.label) {
            case 0:
                dereffed = [];
                _i = 0, items_1 = items;
                _c.label = 1;
            case 1:
                if (!(_i < items_1.length)) return [3 /*break*/, 4];
                i = items_1[_i];
                _b = (_a = dereffed).push;
                return [4 /*yield*/, derefItem(i, doc, resolver)];
            case 2:
                _b.apply(_a, [_c.sent()]);
                _c.label = 3;
            case 3:
                _i++;
                return [3 /*break*/, 1];
            case 4: return [2 /*return*/, dereffed];
        }
    });
}); };
var handleSchemaWithSchemaComponents = function (s, schemaComponents) { return __awaiter(void 0, void 0, void 0, function () {
    var dereffer, dereffed, e_1;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (s === true || s === false) {
                    return [2 /*return*/, Promise.resolve(s)];
                }
                if (schemaComponents !== undefined) {
                    s.components = { schemas: schemaComponents };
                }
                dereffer = new dereferencer_1.default(s);
                _a.label = 1;
            case 1:
                _a.trys.push([1, 3, , 4]);
                return [4 /*yield*/, dereffer.resolve()];
            case 2:
                dereffed = _a.sent();
                if (dereffed !== true && dereffed !== false) {
                    delete dereffed.components;
                    delete s.components;
                }
                return [2 /*return*/, dereffed];
            case 3:
                e_1 = _a.sent();
                throw new OpenRPCDocumentDereferencingError([
                    "Unable to parse reference inside of JSONSchema",
                    s.title ? "Schema Title: ".concat(s.title) : "",
                    "error message: ".concat(e_1.message),
                    "schema in question: ".concat((0, fast_safe_stringify_1.default)(s))
                ].join("\n"));
            case 4: return [2 /*return*/];
        }
    });
}); };
var handleSchemaComponents = function (doc) { return __awaiter(void 0, void 0, void 0, function () {
    var schemas, schemaKeys, _i, schemaKeys_1, k, _a, _b;
    return __generator(this, function (_c) {
        switch (_c.label) {
            case 0:
                if (doc.components === undefined) {
                    return [2 /*return*/, Promise.resolve(doc)];
                }
                if (doc.components.schemas === undefined) {
                    return [2 /*return*/, Promise.resolve(doc)];
                }
                schemas = doc.components.schemas;
                schemaKeys = Object.keys(schemas);
                _i = 0, schemaKeys_1 = schemaKeys;
                _c.label = 1;
            case 1:
                if (!(_i < schemaKeys_1.length)) return [3 /*break*/, 4];
                k = schemaKeys_1[_i];
                _a = schemas;
                _b = k;
                return [4 /*yield*/, handleSchemaWithSchemaComponents(schemas[k], schemas)];
            case 2:
                _a[_b] = _c.sent();
                _c.label = 3;
            case 3:
                _i++;
                return [3 /*break*/, 1];
            case 4: return [2 /*return*/, doc];
        }
    });
}); };
var handleSchemasInsideContentDescriptorComponents = function (doc) { return __awaiter(void 0, void 0, void 0, function () {
    var cds, cdsKeys, componentSchemas, _i, cdsKeys_1, cdK, _a;
    return __generator(this, function (_b) {
        switch (_b.label) {
            case 0:
                if (doc.components === undefined) {
                    return [2 /*return*/, Promise.resolve(doc)];
                }
                if (doc.components.contentDescriptors === undefined) {
                    return [2 /*return*/, Promise.resolve(doc)];
                }
                cds = doc.components.contentDescriptors;
                cdsKeys = Object.keys(cds);
                componentSchemas = {};
                if (doc.components.schemas) {
                    componentSchemas = doc.components.schemas;
                }
                _i = 0, cdsKeys_1 = cdsKeys;
                _b.label = 1;
            case 1:
                if (!(_i < cdsKeys_1.length)) return [3 /*break*/, 4];
                cdK = cdsKeys_1[_i];
                _a = cds[cdK];
                return [4 /*yield*/, handleSchemaWithSchemaComponents(cds[cdK].schema, componentSchemas)];
            case 2:
                _a.schema = _b.sent();
                _b.label = 3;
            case 3:
                _i++;
                return [3 /*break*/, 1];
            case 4: return [2 /*return*/, doc];
        }
    });
}); };
var handleMethod = function (methodOrRef, doc, resolver) { return __awaiter(void 0, void 0, void 0, function () {
    var method, _a, _b, _c, _d, _i, _e, exPairing, _f, _g, _h, _j, componentSchemas, params, _k, params_1, p, _l, result, _m;
    return __generator(this, function (_o) {
        switch (_o.label) {
            case 0:
                method = methodOrRef;
                if (!(methodOrRef.$ref !== undefined)) return [3 /*break*/, 2];
                return [4 /*yield*/, derefItem({ $ref: methodOrRef.$ref }, doc, resolver)];
            case 1:
                method = _o.sent();
                _o.label = 2;
            case 2:
                if (!(method.tags !== undefined)) return [3 /*break*/, 4];
                _a = method;
                return [4 /*yield*/, derefItems(method.tags, doc, resolver)];
            case 3:
                _a.tags = _o.sent();
                _o.label = 4;
            case 4:
                if (!(method.errors !== undefined)) return [3 /*break*/, 6];
                _b = method;
                return [4 /*yield*/, derefItems(method.errors, doc, resolver)];
            case 5:
                _b.errors = _o.sent();
                _o.label = 6;
            case 6:
                if (!(method.links !== undefined)) return [3 /*break*/, 8];
                _c = method;
                return [4 /*yield*/, derefItems(method.links, doc, resolver)];
            case 7:
                _c.links = _o.sent();
                _o.label = 8;
            case 8:
                if (!(method.examples !== undefined)) return [3 /*break*/, 14];
                _d = method;
                return [4 /*yield*/, derefItems(method.examples, doc, resolver)];
            case 9:
                _d.examples = _o.sent();
                _i = 0, _e = method.examples;
                _o.label = 10;
            case 10:
                if (!(_i < _e.length)) return [3 /*break*/, 14];
                exPairing = _e[_i];
                _f = exPairing;
                return [4 /*yield*/, derefItems(exPairing.params, doc, resolver)];
            case 11:
                _f.params = _o.sent();
                if (!(exPairing.result !== undefined)) return [3 /*break*/, 13];
                _g = exPairing;
                return [4 /*yield*/, derefItem(exPairing.result, doc, resolver)];
            case 12:
                _g.result = _o.sent();
                _o.label = 13;
            case 13:
                _i++;
                return [3 /*break*/, 10];
            case 14:
                _h = method;
                return [4 /*yield*/, derefItems(method.params, doc, resolver)];
            case 15:
                _h.params = _o.sent();
                if (!(method.result !== undefined)) return [3 /*break*/, 17];
                _j = method;
                return [4 /*yield*/, derefItem(method.result, doc, resolver)];
            case 16:
                _j.result = _o.sent();
                _o.label = 17;
            case 17:
                componentSchemas = {};
                if (doc.components && doc.components.schemas) {
                    componentSchemas = doc.components.schemas;
                }
                params = method.params;
                _k = 0, params_1 = params;
                _o.label = 18;
            case 18:
                if (!(_k < params_1.length)) return [3 /*break*/, 21];
                p = params_1[_k];
                _l = p;
                return [4 /*yield*/, handleSchemaWithSchemaComponents(p.schema, componentSchemas)];
            case 19:
                _l.schema = _o.sent();
                _o.label = 20;
            case 20:
                _k++;
                return [3 /*break*/, 18];
            case 21:
                if (!(method.result !== undefined)) return [3 /*break*/, 23];
                result = method.result;
                _m = result;
                return [4 /*yield*/, handleSchemaWithSchemaComponents(result.schema, componentSchemas)];
            case 22:
                _m.schema = _o.sent();
                _o.label = 23;
            case 23: return [2 /*return*/, method];
        }
    });
}); };
/**
 * replaces $ref's within a document and its schemas. The replaced value will be a javascript object reference to the
 * real schema / open-rpc component
 *
 * @param schema The OpenRPC document
 *
 * @returns The same OpenRPC Document that was passed in, but with all $ref's dereferenced.
 *
 * @throws [[OpenRPCDocumentDereferencingError]]
 *
 * @example
 * ```typescript
 *
 * import { OpenRPC } from "@open-rpc/meta-schema"
 * import { dereferenceDocument } from "@open-rpc/schema-utils-js";
 *
 * try {
 *   const dereffedDocument = await dereferenceDocument({ ... }) as OpenRPC;
 * } catch (e) {
 *   // handle validation errors
 * }
 * ```
 *
 */
function dereferenceDocument(openrpcDocument, resolver) {
    if (resolver === void 0) { resolver = reference_resolver_1.default; }
    return __awaiter(this, void 0, void 0, function () {
        var derefDoc, methods, _i, _a, method, _b, _c;
        return __generator(this, function (_d) {
            switch (_d.label) {
                case 0:
                    derefDoc = __assign({}, openrpcDocument);
                    return [4 /*yield*/, handleSchemaComponents(derefDoc)];
                case 1:
                    derefDoc = _d.sent();
                    return [4 /*yield*/, handleSchemasInsideContentDescriptorComponents(derefDoc)];
                case 2:
                    derefDoc = _d.sent();
                    methods = [];
                    _i = 0, _a = derefDoc.methods;
                    _d.label = 3;
                case 3:
                    if (!(_i < _a.length)) return [3 /*break*/, 6];
                    method = _a[_i];
                    _c = (_b = methods).push;
                    return [4 /*yield*/, handleMethod(method, derefDoc, resolver)];
                case 4:
                    _c.apply(_b, [_d.sent()]);
                    _d.label = 5;
                case 5:
                    _i++;
                    return [3 /*break*/, 3];
                case 6:
                    derefDoc.methods = methods;
                    return [2 /*return*/, derefDoc];
            }
        });
    });
}
exports.default = dereferenceDocument;

      };
    };
  }
  }
}, {package:"@open-rpc/schema-utils-js",file:"node_modules\\@open-rpc\\schema-utils-js\\build\\dereference-document.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@open-rpc\\schema-utils-js\\build\\parse-open-rpc-document.js", {"./dereference-document":"D:\\code\\v\\metamask-extension\\node_modules\\@open-rpc\\schema-utils-js\\build\\dereference-document.js","./validate-open-rpc-document":"D:\\code\\v\\metamask-extension\\node_modules\\@open-rpc\\schema-utils-js\\build\\validate-open-rpc-document.js","@json-schema-tools/reference-resolver":"D:\\code\\v\\metamask-extension\\node_modules\\@json-schema-tools\\reference-resolver\\build\\index-web.js","@json-schema-tools/reference-resolver/build/reference-resolver":"D:\\code\\v\\metamask-extension\\node_modules\\@json-schema-tools\\reference-resolver\\build\\reference-resolver.js","is-url":"D:\\code\\v\\metamask-extension\\node_modules\\is-url\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@open-rpc%5Cschema-utils-js%5Cbuild%5Cparse-open-rpc-document.js
      return function (require, module, exports) {
"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeCustomResolver = void 0;
var dereference_document_1 = __importDefault(require("./dereference-document"));
var validate_open_rpc_document_1 = __importStar(require("./validate-open-rpc-document"));
var reference_resolver_1 = __importDefault(require("@json-schema-tools/reference-resolver"));
var isUrl = require("is-url");
var reference_resolver_2 = __importDefault(require("@json-schema-tools/reference-resolver/build/reference-resolver"));
/**
 * @ignore
 */
var isJson = function (jsonString) {
    try {
        JSON.parse(jsonString);
        return true;
    }
    catch (e) {
        return false;
    }
};
var defaultParseOpenRPCDocumentOptions = {
    dereference: true,
    validate: true,
};
var makeParseOpenRPCDocument = function (fetchUrlSchema, readSchemaFromFile) {
    /**
     * Resolves an OpenRPC document from a variety of input types. The resolved OpenRPC document
     * will be dereferenced and validated against the [meta-schema](https://github.com/open-rpc/meta-schema).
     *
     * @param schema The OpenRPC document or a reference to one.
     *
     * If schema is an object, it will use this as the openrpc document literally.
     * If schema is a string, it may fall under 3 other categories:
     *   1. schema is an OpenRPC document as a json string.
     *   2. schema is a url that resolves to an OpenRPC document.
     *   3. schema is a file path, where the file at the path contains an OpenRPC document.
     *
     * @param options Parser options. See [[IParseOpenRPCDocumentOptions]]
     *
     * @returns The same OpenRPC Document that was passed in, but with all $ref's dereferenced.
     *
     * @throws [[OpenRPCDocumentValidationError]]
     * @throws [[OpenRPCDocumentDereferencingError]]
     *
     * @example
     * ```typescript
     *
     * const { OpenRPC } from "@open-rpc/meta-schema"
     * const { parseOpenRPCDocument } from "@open-rpc/schema-utils-js";
     *
     * try {
     *   const fromUrl = await parseOpenRPCDocument("example.com/openrpc.json") as OpenRPC;
     *   const fromFile = await parseOpenRPCDocument("example.com/openrpc.json") as OpenRPC;
     *   const fromString = await parseOpenRPCDocument('{ "openrpc": "1.0.0", ... }') as OpenRPC;
     *   const fromCwd = await parseOpenRPCDocument() as types.OpenRPC; // default
     * } catch (e) {
     *   // handle validation errors
     * }
     * ```
     *
     */
    return function parseOpenRPCDocument(schema, options) {
        if (schema === void 0) { schema = "./openrpc.json"; }
        if (options === void 0) { options = defaultParseOpenRPCDocumentOptions; }
        return __awaiter(this, void 0, void 0, function () {
            var parsedSchema, parseOptions, isValid, postDeref, isValid;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        parseOptions = __assign(__assign({}, defaultParseOpenRPCDocumentOptions), options);
                        if (!(typeof schema !== "string")) return [3 /*break*/, 1];
                        parsedSchema = schema;
                        return [3 /*break*/, 6];
                    case 1:
                        if (!isJson(schema)) return [3 /*break*/, 2];
                        parsedSchema = JSON.parse(schema);
                        return [3 /*break*/, 6];
                    case 2:
                        if (!isUrl(schema)) return [3 /*break*/, 4];
                        return [4 /*yield*/, fetchUrlSchema(schema)];
                    case 3:
                        parsedSchema = _a.sent();
                        return [3 /*break*/, 6];
                    case 4: return [4 /*yield*/, readSchemaFromFile(schema)];
                    case 5:
                        parsedSchema = _a.sent();
                        _a.label = 6;
                    case 6:
                        if (parseOptions.validate) {
                            isValid = (0, validate_open_rpc_document_1.default)(parsedSchema);
                            if (isValid instanceof validate_open_rpc_document_1.OpenRPCDocumentValidationError) {
                                throw isValid;
                            }
                        }
                        postDeref = parsedSchema;
                        if (!parseOptions.dereference) return [3 /*break*/, 10];
                        if (!(parseOptions.resolver !== undefined)) return [3 /*break*/, 8];
                        return [4 /*yield*/, (0, dereference_document_1.default)(parsedSchema, parseOptions.resolver)];
                    case 7:
                        postDeref = _a.sent();
                        return [3 /*break*/, 10];
                    case 8: return [4 /*yield*/, (0, dereference_document_1.default)(parsedSchema, reference_resolver_1.default)];
                    case 9:
                        postDeref = _a.sent();
                        _a.label = 10;
                    case 10:
                        if (parseOptions.validate) {
                            isValid = (0, validate_open_rpc_document_1.default)(postDeref);
                            if (isValid instanceof validate_open_rpc_document_1.OpenRPCDocumentValidationError) {
                                throw isValid;
                            }
                        }
                        return [2 /*return*/, postDeref];
                }
            });
        });
    };
};
function makeCustomResolver(protocolMapHandler) {
    return new reference_resolver_2.default(protocolMapHandler);
}
exports.makeCustomResolver = makeCustomResolver;
exports.default = makeParseOpenRPCDocument;

      };
    };
  }
  }
}, {package:"@open-rpc/schema-utils-js",file:"node_modules\\@open-rpc\\schema-utils-js\\build\\parse-open-rpc-document.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@open-rpc\\schema-utils-js\\build\\validate-open-rpc-document.js", {"@json-schema-tools/meta-schema":"D:\\code\\v\\metamask-extension\\node_modules\\@json-schema-tools\\meta-schema\\index.js","@open-rpc/meta-schema":"D:\\code\\v\\metamask-extension\\node_modules\\@open-rpc\\meta-schema\\index.js","ajv":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\ajv.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@open-rpc%5Cschema-utils-js%5Cbuild%5Cvalidate-open-rpc-document.js
      return function (require, module, exports) {
"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenRPCDocumentValidationError = void 0;
var meta_schema_1 = __importDefault(require("@open-rpc/meta-schema"));
var ajv_1 = __importDefault(require("ajv"));
var meta_schema_2 = __importDefault(require("@json-schema-tools/meta-schema"));
/**
 * @ignore
 */
/**
 * Provides an error interface for OpenRPC Document validation
 *
 * @category Errors
 *
 */
var OpenRPCDocumentValidationError = /** @class */ (function () {
    /**
     * @param errors The errors received by ajv.errors.
     */
    function OpenRPCDocumentValidationError(errors) {
        this.name = "OpenRPCDocumentDereferencingError";
        this.message = [
            "Error validating OpenRPC Document against @open-rpc/meta-schema.",
            "The errors found are as follows:",
            JSON.stringify(errors, undefined, "  "),
        ].join("\n");
    }
    return OpenRPCDocumentValidationError;
}());
exports.OpenRPCDocumentValidationError = OpenRPCDocumentValidationError;
/**
 * Returns any JSON Schema validation errors that are found with the OpenRPC document passed in.
 *
 * @param document OpenRPC Document to validate.
 *
 * @returns Either true if everything checks out, or a well formatted error.
 *
 * @example
 * ```typescript
 *
 * import { validateOpenRPCDocument } from "@open-rpc/schema-utils-js";
 * const badOpenRPCDocument = {} as any;
 *
 * const result = validateOpenRPCDocument(badOpenRPCDocument);
 * if (result !== true) {
 *   console.error(result);
 * }
 * ```
 *
 */
function validateOpenRPCDocument(document) {
    var ajv = new ajv_1.default();
    ajv.addSchema(meta_schema_2.default, "https://meta.json-schema.tools");
    var metaSchemaCopy = __assign({}, meta_schema_1.default);
    delete metaSchemaCopy.definitions.JSONSchema.$id;
    delete metaSchemaCopy.definitions.JSONSchema.$schema;
    delete metaSchemaCopy.$schema;
    delete metaSchemaCopy.$id;
    try {
        ajv.validate(metaSchemaCopy, document);
    }
    catch (e) {
        throw new Error([
            'schema-utils-js: Internal Error',
            '-----',
            e,
            '-----',
            'If you see this report it: https://github.com/open-rpc/schema-utils-js/issues',
        ].join('\n'));
    }
    if (ajv.errors) {
        return new OpenRPCDocumentValidationError(ajv.errors);
    }
    else {
        return true;
    }
}
exports.default = validateOpenRPCDocument;

      };
    };
  }
  }
}, {package:"@open-rpc/schema-utils-js",file:"node_modules\\@open-rpc\\schema-utils-js\\build\\validate-open-rpc-document.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@segment\\loosely-validate-event\\index.js", {"assert":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\assert\\assert.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js","component-type":"D:\\code\\v\\metamask-extension\\node_modules\\component-type\\index.js","join-component":"D:\\code\\v\\metamask-extension\\node_modules\\join-component\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@segment%5Cloosely-validate-event%5Cindex.js
      return function (require, module, exports) {
(function (Buffer){(function (){
var type = require('component-type')
var join = require('join-component')
var assert = require('assert')

// Segment messages can be a maximum of 32kb.
var MAX_SIZE = 32 << 10

module.exports = looselyValidateEvent

/**
 * Validate an event.
 */

function looselyValidateEvent (event, type) {
  validateGenericEvent(event)
  type = type || event.type
  assert(type, 'You must pass an event type.')
  switch (type) {
    case 'track':
      return validateTrackEvent(event)
    case 'group':
      return validateGroupEvent(event)
    case 'identify':
      return validateIdentifyEvent(event)
    case 'page':
      return validatePageEvent(event)
    case 'screen':
      return validateScreenEvent(event)
    case 'alias':
      return validateAliasEvent(event)
    default:
      assert(0, 'Invalid event type: "' + type + '"')
  }
}

/**
 * Validate a "track" event.
 */

function validateTrackEvent (event) {
  assert(event.anonymousId || event.userId, 'You must pass either an "anonymousId" or a "userId".')
  assert(event.event, 'You must pass an "event".')
}

/**
 * Validate a "group" event.
 */

function validateGroupEvent (event) {
  assert(event.anonymousId || event.userId, 'You must pass either an "anonymousId" or a "userId".')
  assert(event.groupId, 'You must pass a "groupId".')
}

/**
 * Validate a "identify" event.
 */

function validateIdentifyEvent (event) {
  assert(event.anonymousId || event.userId, 'You must pass either an "anonymousId" or a "userId".')
}

/**
 * Validate a "page" event.
 */

function validatePageEvent (event) {
  assert(event.anonymousId || event.userId, 'You must pass either an "anonymousId" or a "userId".')
}

/**
 * Validate a "screen" event.
 */

function validateScreenEvent (event) {
  assert(event.anonymousId || event.userId, 'You must pass either an "anonymousId" or a "userId".')
}

/**
 * Validate an "alias" event.
 */

function validateAliasEvent (event) {
  assert(event.userId, 'You must pass a "userId".')
  assert(event.previousId, 'You must pass a "previousId".')
}

/**
 * Validation rules.
 */

var genericValidationRules = {
  anonymousId: [ 'string', 'number' ],
  category: 'string',
  context: 'object',
  event: 'string',
  groupId: [ 'string', 'number' ],
  integrations: 'object',
  name: 'string',
  previousId: [ 'string', 'number' ],
  timestamp: 'date',
  userId: [ 'string', 'number' ],
  type: 'string'
}

/**
 * Validate an event object.
 */

function validateGenericEvent (event) {
  assert(type(event) === 'object', 'You must pass a message object.')
  var json = JSON.stringify(event)
  // Strings are variable byte encoded, so json.length is not sufficient.
  assert(Buffer.byteLength(json, 'utf8') < MAX_SIZE, 'Your message must be < 32kb.')

  for (var key in genericValidationRules) {
    var val = event[key]
    if (!val) continue
    var rule = genericValidationRules[key]
    if (type(rule) !== 'array') {
      rule = [ rule ]
    }
    var a = rule[0] === 'object' ? 'an' : 'a'
    assert(
      rule.some(function (e) { return type(val) === e }),
      '"' + key + '" must be ' + a + ' ' + join(rule, 'or') + '.'
    )
  }
}

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"@segment/loosely-validate-event",file:"node_modules\\@segment\\loosely-validate-event\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@trezor\\connect-plugin-ethereum\\lib\\index.js", {"@metamask/eth-sig-util":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-sig-util\\dist\\index.js","tslib":"D:\\code\\v\\metamask-extension\\node_modules\\tslib\\tslib.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@trezor%5Cconnect-plugin-ethereum%5Clib%5Cindex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformTypedData = void 0;
const tslib_1 = require("tslib");
const sigUtil = tslib_1.__importStar(require("@metamask/eth-sig-util"));
function sanitizeData(data) {
    switch (Object.prototype.toString.call(data)) {
        case '[object Object]': {
            const entries = Object.keys(data).map(k => [k, sanitizeData(data[k])]);
            return Object.fromEntries(entries);
        }
        case '[object Array]':
            return data.map((v) => sanitizeData(v));
        case '[object BigInt]':
            return data.toString();
        default:
            return data;
    }
}
const transformTypedData = (data, metamask_v4_compat) => {
    if (!metamask_v4_compat) {
        throw new Error('Trezor: Only version 4 of typed data signing is supported');
    }
    const version = sigUtil.SignTypedDataVersion.V4;
    const { types, primaryType, domain, message } = sigUtil.TypedDataUtils.sanitizeData(data);
    const domainSeparatorHash = sigUtil.TypedDataUtils.hashStruct('EIP712Domain', sanitizeData(domain), types, version).toString('hex');
    let messageHash = null;
    if (primaryType !== 'EIP712Domain') {
        messageHash = sigUtil.TypedDataUtils.hashStruct(primaryType, sanitizeData(message), types, version).toString('hex');
    }
    return Object.assign({ domain_separator_hash: domainSeparatorHash, message_hash: messageHash }, data);
};
exports.transformTypedData = transformTypedData;
exports.default = exports.transformTypedData;

      };
    };
  }
  }
}, {package:"@metamask/eth-trezor-keyring>@trezor/connect-plugin-ethereum",file:"node_modules\\@trezor\\connect-plugin-ethereum\\lib\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@xstate\\fsm\\lib\\index.js", {"./types.js":"D:\\code\\v\\metamask-extension\\node_modules\\@xstate\\fsm\\lib\\types.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@xstate%5Cfsm%5Clib%5Cindex.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var types = require('./types.js');

const INIT_EVENT = { type: 'xstate.init' };
const ASSIGN_ACTION = 'xstate.assign';
function toArray(item) {
    return item === undefined ? [] : [].concat(item);
}
function assign(assignment) {
    return {
        type: ASSIGN_ACTION,
        assignment
    };
}
function toActionObject(
// tslint:disable-next-line:ban-types
action, actionMap) {
    action =
        typeof action === 'string' && actionMap && actionMap[action]
            ? actionMap[action]
            : action;
    return typeof action === 'string'
        ? {
            type: action
        }
        : typeof action === 'function'
            ? {
                type: action.name,
                exec: action
            }
            : action;
}
const IS_PRODUCTION = "development" === 'production';
function createMatcher(value) {
    return (stateValue) => value === stateValue;
}
function toEventObject(event) {
    return (typeof event === 'string' ? { type: event } : event);
}
function createUnchangedState(value, context) {
    return {
        value,
        context,
        actions: [],
        changed: false,
        matches: createMatcher(value)
    };
}
function handleActions(actions, context, eventObject) {
    let nextContext = context;
    let assigned = false;
    const nonAssignActions = actions.filter((action) => {
        if (action.type === ASSIGN_ACTION) {
            assigned = true;
            let tmpContext = Object.assign({}, nextContext);
            if (typeof action.assignment === 'function') {
                tmpContext = action.assignment(nextContext, eventObject);
            }
            else {
                Object.keys(action.assignment).forEach((key) => {
                    tmpContext[key] =
                        typeof action.assignment[key] === 'function'
                            ? action.assignment[key](nextContext, eventObject)
                            : action.assignment[key];
                });
            }
            nextContext = tmpContext;
            return false;
        }
        return true;
    });
    return [nonAssignActions, nextContext, assigned];
}
function createMachine(fsmConfig, implementations = {}) {
    if (!IS_PRODUCTION) {
        Object.keys(fsmConfig.states).forEach((state) => {
            if (fsmConfig.states[state].states) {
                throw new Error(`Nested finite states not supported.
            Please check the configuration for the "${state}" state.`);
            }
        });
    }
    const [initialActions, initialContext] = handleActions(toArray(fsmConfig.states[fsmConfig.initial].entry).map((action) => toActionObject(action, implementations.actions)), fsmConfig.context, INIT_EVENT);
    const machine = {
        config: fsmConfig,
        _options: implementations,
        initialState: {
            value: fsmConfig.initial,
            actions: initialActions,
            context: initialContext,
            matches: createMatcher(fsmConfig.initial)
        },
        transition: (state, event) => {
            var _a, _b;
            const { value, context } = typeof state === 'string'
                ? { value: state, context: fsmConfig.context }
                : state;
            const eventObject = toEventObject(event);
            const stateConfig = fsmConfig.states[value];
            if (!IS_PRODUCTION && !stateConfig) {
                throw new Error(`State '${value}' not found on machine ${(_a = fsmConfig.id) !== null && _a !== void 0 ? _a : ''}`);
            }
            if (stateConfig.on) {
                const transitions = toArray(stateConfig.on[eventObject.type]);
                for (const transition of transitions) {
                    if (transition === undefined) {
                        return createUnchangedState(value, context);
                    }
                    const { target, actions = [], cond = () => true } = typeof transition === 'string'
                        ? { target: transition }
                        : transition;
                    const isTargetless = target === undefined;
                    const nextStateValue = target !== null && target !== void 0 ? target : value;
                    const nextStateConfig = fsmConfig.states[nextStateValue];
                    if (!IS_PRODUCTION && !nextStateConfig) {
                        throw new Error(`State '${nextStateValue}' not found on machine ${(_b = fsmConfig.id) !== null && _b !== void 0 ? _b : ''}`);
                    }
                    if (cond(context, eventObject)) {
                        const allActions = (isTargetless
                            ? toArray(actions)
                            : []
                                .concat(stateConfig.exit, actions, nextStateConfig.entry)
                                .filter((a) => a)).map((action) => toActionObject(action, machine._options.actions));
                        const [nonAssignActions, nextContext, assigned] = handleActions(allActions, context, eventObject);
                        const resolvedTarget = target !== null && target !== void 0 ? target : value;
                        return {
                            value: resolvedTarget,
                            context: nextContext,
                            actions: nonAssignActions,
                            changed: target !== value || nonAssignActions.length > 0 || assigned,
                            matches: createMatcher(resolvedTarget)
                        };
                    }
                }
            }
            // No transitions match
            return createUnchangedState(value, context);
        }
    };
    return machine;
}
const executeStateActions = (state, event) => state.actions.forEach(({ exec }) => exec && exec(state.context, event));
function interpret(machine) {
    let state = machine.initialState;
    let status = types.InterpreterStatus.NotStarted;
    const listeners = new Set();
    const service = {
        _machine: machine,
        send: (event) => {
            if (status !== types.InterpreterStatus.Running) {
                return;
            }
            state = machine.transition(state, event);
            executeStateActions(state, toEventObject(event));
            listeners.forEach((listener) => listener(state));
        },
        subscribe: (listener) => {
            listeners.add(listener);
            listener(state);
            return {
                unsubscribe: () => listeners.delete(listener)
            };
        },
        start: (initialState) => {
            if (initialState) {
                const resolved = typeof initialState === 'object'
                    ? initialState
                    : { context: machine.config.context, value: initialState };
                state = {
                    value: resolved.value,
                    actions: [],
                    context: resolved.context,
                    matches: createMatcher(resolved.value)
                };
                if (!IS_PRODUCTION) {
                    if (!(state.value in machine.config.states)) {
                        throw new Error(`Cannot start service in state '${state.value}'. The state is not found on machine${machine.config.id ? ` '${machine.config.id}'` : ''}.`);
                    }
                }
            }
            else {
                state = machine.initialState;
            }
            status = types.InterpreterStatus.Running;
            executeStateActions(state, INIT_EVENT);
            return service;
        },
        stop: () => {
            status = types.InterpreterStatus.Stopped;
            listeners.clear();
            return service;
        },
        get state() {
            return state;
        },
        get status() {
            return status;
        }
    };
    return service;
}

Object.defineProperty(exports, 'InterpreterStatus', {
  enumerable: true,
  get: function () { return types.InterpreterStatus; }
});
exports.assign = assign;
exports.createMachine = createMachine;
exports.interpret = interpret;

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers>@xstate/fsm",file:"node_modules\\@xstate\\fsm\\lib\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@xstate\\fsm\\lib\\types.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@xstate%5Cfsm%5Clib%5Ctypes.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

exports.InterpreterStatus = void 0;
(function (InterpreterStatus) {
    InterpreterStatus[InterpreterStatus["NotStarted"] = 0] = "NotStarted";
    InterpreterStatus[InterpreterStatus["Running"] = 1] = "Running";
    InterpreterStatus[InterpreterStatus["Stopped"] = 2] = "Stopped";
})(exports.InterpreterStatus || (exports.InterpreterStatus = {}));

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers>@xstate/fsm",file:"node_modules\\@xstate\\fsm\\lib\\types.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\ajv.js", {"./cache":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\cache.js","./compile":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\index.js","./compile/async":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\async.js","./compile/error_classes":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\error_classes.js","./compile/formats":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\formats.js","./compile/resolve":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\resolve.js","./compile/rules":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\rules.js","./compile/schema_obj":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\schema_obj.js","./compile/util":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\util.js","./data":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\data.js","./keyword":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\keyword.js","./refs/data.json":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\refs\\data.json","./refs/json-schema-draft-07.json":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\refs\\json-schema-draft-07.json","fast-json-stable-stringify":"D:\\code\\v\\metamask-extension\\node_modules\\fast-json-stable-stringify\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cajv.js
      return function (require, module, exports) {
'use strict';

var compileSchema = require('./compile')
  , resolve = require('./compile/resolve')
  , Cache = require('./cache')
  , SchemaObject = require('./compile/schema_obj')
  , stableStringify = require('fast-json-stable-stringify')
  , formats = require('./compile/formats')
  , rules = require('./compile/rules')
  , $dataMetaSchema = require('./data')
  , util = require('./compile/util');

module.exports = Ajv;

Ajv.prototype.validate = validate;
Ajv.prototype.compile = compile;
Ajv.prototype.addSchema = addSchema;
Ajv.prototype.addMetaSchema = addMetaSchema;
Ajv.prototype.validateSchema = validateSchema;
Ajv.prototype.getSchema = getSchema;
Ajv.prototype.removeSchema = removeSchema;
Ajv.prototype.addFormat = addFormat;
Ajv.prototype.errorsText = errorsText;

Ajv.prototype._addSchema = _addSchema;
Ajv.prototype._compile = _compile;

Ajv.prototype.compileAsync = require('./compile/async');
var customKeyword = require('./keyword');
Ajv.prototype.addKeyword = customKeyword.add;
Ajv.prototype.getKeyword = customKeyword.get;
Ajv.prototype.removeKeyword = customKeyword.remove;
Ajv.prototype.validateKeyword = customKeyword.validate;

var errorClasses = require('./compile/error_classes');
Ajv.ValidationError = errorClasses.Validation;
Ajv.MissingRefError = errorClasses.MissingRef;
Ajv.$dataMetaSchema = $dataMetaSchema;

var META_SCHEMA_ID = 'http://json-schema.org/draft-07/schema';

var META_IGNORE_OPTIONS = [ 'removeAdditional', 'useDefaults', 'coerceTypes', 'strictDefaults' ];
var META_SUPPORT_DATA = ['/properties'];

/**
 * Creates validator instance.
 * Usage: `Ajv(opts)`
 * @param {Object} opts optional options
 * @return {Object} ajv instance
 */
function Ajv(opts) {
  if (!(this instanceof Ajv)) return new Ajv(opts);
  opts = this._opts = util.copy(opts) || {};
  setLogger(this);
  this._schemas = {};
  this._refs = {};
  this._fragments = {};
  this._formats = formats(opts.format);

  this._cache = opts.cache || new Cache;
  this._loadingSchemas = {};
  this._compilations = [];
  this.RULES = rules();
  this._getId = chooseGetId(opts);

  opts.loopRequired = opts.loopRequired || Infinity;
  if (opts.errorDataPath == 'property') opts._errorDataPathProperty = true;
  if (opts.serialize === undefined) opts.serialize = stableStringify;
  this._metaOpts = getMetaSchemaOptions(this);

  if (opts.formats) addInitialFormats(this);
  if (opts.keywords) addInitialKeywords(this);
  addDefaultMetaSchema(this);
  if (typeof opts.meta == 'object') this.addMetaSchema(opts.meta);
  if (opts.nullable) this.addKeyword('nullable', {metaSchema: {type: 'boolean'}});
  addInitialSchemas(this);
}



/**
 * Validate data using schema
 * Schema will be compiled and cached (using serialized JSON as key. [fast-json-stable-stringify](https://github.com/epoberezkin/fast-json-stable-stringify) is used to serialize.
 * @this   Ajv
 * @param  {String|Object} schemaKeyRef key, ref or schema object
 * @param  {Any} data to be validated
 * @return {Boolean} validation result. Errors from the last validation will be available in `ajv.errors` (and also in compiled schema: `schema.errors`).
 */
function validate(schemaKeyRef, data) {
  var v;
  if (typeof schemaKeyRef == 'string') {
    v = this.getSchema(schemaKeyRef);
    if (!v) throw new Error('no schema with key or ref "' + schemaKeyRef + '"');
  } else {
    var schemaObj = this._addSchema(schemaKeyRef);
    v = schemaObj.validate || this._compile(schemaObj);
  }

  var valid = v(data);
  if (v.$async !== true) this.errors = v.errors;
  return valid;
}


/**
 * Create validating function for passed schema.
 * @this   Ajv
 * @param  {Object} schema schema object
 * @param  {Boolean} _meta true if schema is a meta-schema. Used internally to compile meta schemas of custom keywords.
 * @return {Function} validating function
 */
function compile(schema, _meta) {
  var schemaObj = this._addSchema(schema, undefined, _meta);
  return schemaObj.validate || this._compile(schemaObj);
}


/**
 * Adds schema to the instance.
 * @this   Ajv
 * @param {Object|Array} schema schema or array of schemas. If array is passed, `key` and other parameters will be ignored.
 * @param {String} key Optional schema key. Can be passed to `validate` method instead of schema object or id/ref. One schema per instance can have empty `id` and `key`.
 * @param {Boolean} _skipValidation true to skip schema validation. Used internally, option validateSchema should be used instead.
 * @param {Boolean} _meta true if schema is a meta-schema. Used internally, addMetaSchema should be used instead.
 * @return {Ajv} this for method chaining
 */
function addSchema(schema, key, _skipValidation, _meta) {
  if (Array.isArray(schema)){
    for (var i=0; i<schema.length; i++) this.addSchema(schema[i], undefined, _skipValidation, _meta);
    return this;
  }
  var id = this._getId(schema);
  if (id !== undefined && typeof id != 'string')
    throw new Error('schema id must be string');
  key = resolve.normalizeId(key || id);
  checkUnique(this, key);
  this._schemas[key] = this._addSchema(schema, _skipValidation, _meta, true);
  return this;
}


/**
 * Add schema that will be used to validate other schemas
 * options in META_IGNORE_OPTIONS are alway set to false
 * @this   Ajv
 * @param {Object} schema schema object
 * @param {String} key optional schema key
 * @param {Boolean} skipValidation true to skip schema validation, can be used to override validateSchema option for meta-schema
 * @return {Ajv} this for method chaining
 */
function addMetaSchema(schema, key, skipValidation) {
  this.addSchema(schema, key, skipValidation, true);
  return this;
}


/**
 * Validate schema
 * @this   Ajv
 * @param {Object} schema schema to validate
 * @param {Boolean} throwOrLogError pass true to throw (or log) an error if invalid
 * @return {Boolean} true if schema is valid
 */
function validateSchema(schema, throwOrLogError) {
  var $schema = schema.$schema;
  if ($schema !== undefined && typeof $schema != 'string')
    throw new Error('$schema must be a string');
  $schema = $schema || this._opts.defaultMeta || defaultMeta(this);
  if (!$schema) {
    this.logger.warn('meta-schema not available');
    this.errors = null;
    return true;
  }
  var valid = this.validate($schema, schema);
  if (!valid && throwOrLogError) {
    var message = 'schema is invalid: ' + this.errorsText();
    if (this._opts.validateSchema == 'log') this.logger.error(message);
    else throw new Error(message);
  }
  return valid;
}


function defaultMeta(self) {
  var meta = self._opts.meta;
  self._opts.defaultMeta = typeof meta == 'object'
                            ? self._getId(meta) || meta
                            : self.getSchema(META_SCHEMA_ID)
                              ? META_SCHEMA_ID
                              : undefined;
  return self._opts.defaultMeta;
}


/**
 * Get compiled schema from the instance by `key` or `ref`.
 * @this   Ajv
 * @param  {String} keyRef `key` that was passed to `addSchema` or full schema reference (`schema.id` or resolved id).
 * @return {Function} schema validating function (with property `schema`).
 */
function getSchema(keyRef) {
  var schemaObj = _getSchemaObj(this, keyRef);
  switch (typeof schemaObj) {
    case 'object': return schemaObj.validate || this._compile(schemaObj);
    case 'string': return this.getSchema(schemaObj);
    case 'undefined': return _getSchemaFragment(this, keyRef);
  }
}


function _getSchemaFragment(self, ref) {
  var res = resolve.schema.call(self, { schema: {} }, ref);
  if (res) {
    var schema = res.schema
      , root = res.root
      , baseId = res.baseId;
    var v = compileSchema.call(self, schema, root, undefined, baseId);
    self._fragments[ref] = new SchemaObject({
      ref: ref,
      fragment: true,
      schema: schema,
      root: root,
      baseId: baseId,
      validate: v
    });
    return v;
  }
}


function _getSchemaObj(self, keyRef) {
  keyRef = resolve.normalizeId(keyRef);
  return self._schemas[keyRef] || self._refs[keyRef] || self._fragments[keyRef];
}


/**
 * Remove cached schema(s).
 * If no parameter is passed all schemas but meta-schemas are removed.
 * If RegExp is passed all schemas with key/id matching pattern but meta-schemas are removed.
 * Even if schema is referenced by other schemas it still can be removed as other schemas have local references.
 * @this   Ajv
 * @param  {String|Object|RegExp} schemaKeyRef key, ref, pattern to match key/ref or schema object
 * @return {Ajv} this for method chaining
 */
function removeSchema(schemaKeyRef) {
  if (schemaKeyRef instanceof RegExp) {
    _removeAllSchemas(this, this._schemas, schemaKeyRef);
    _removeAllSchemas(this, this._refs, schemaKeyRef);
    return this;
  }
  switch (typeof schemaKeyRef) {
    case 'undefined':
      _removeAllSchemas(this, this._schemas);
      _removeAllSchemas(this, this._refs);
      this._cache.clear();
      return this;
    case 'string':
      var schemaObj = _getSchemaObj(this, schemaKeyRef);
      if (schemaObj) this._cache.del(schemaObj.cacheKey);
      delete this._schemas[schemaKeyRef];
      delete this._refs[schemaKeyRef];
      return this;
    case 'object':
      var serialize = this._opts.serialize;
      var cacheKey = serialize ? serialize(schemaKeyRef) : schemaKeyRef;
      this._cache.del(cacheKey);
      var id = this._getId(schemaKeyRef);
      if (id) {
        id = resolve.normalizeId(id);
        delete this._schemas[id];
        delete this._refs[id];
      }
  }
  return this;
}


function _removeAllSchemas(self, schemas, regex) {
  for (var keyRef in schemas) {
    var schemaObj = schemas[keyRef];
    if (!schemaObj.meta && (!regex || regex.test(keyRef))) {
      self._cache.del(schemaObj.cacheKey);
      delete schemas[keyRef];
    }
  }
}


/* @this   Ajv */
function _addSchema(schema, skipValidation, meta, shouldAddSchema) {
  if (typeof schema != 'object' && typeof schema != 'boolean')
    throw new Error('schema should be object or boolean');
  var serialize = this._opts.serialize;
  var cacheKey = serialize ? serialize(schema) : schema;
  var cached = this._cache.get(cacheKey);
  if (cached) return cached;

  shouldAddSchema = shouldAddSchema || this._opts.addUsedSchema !== false;

  var id = resolve.normalizeId(this._getId(schema));
  if (id && shouldAddSchema) checkUnique(this, id);

  var willValidate = this._opts.validateSchema !== false && !skipValidation;
  var recursiveMeta;
  if (willValidate && !(recursiveMeta = id && id == resolve.normalizeId(schema.$schema)))
    this.validateSchema(schema, true);

  var localRefs = resolve.ids.call(this, schema);

  var schemaObj = new SchemaObject({
    id: id,
    schema: schema,
    localRefs: localRefs,
    cacheKey: cacheKey,
    meta: meta
  });

  if (id[0] != '#' && shouldAddSchema) this._refs[id] = schemaObj;
  this._cache.put(cacheKey, schemaObj);

  if (willValidate && recursiveMeta) this.validateSchema(schema, true);

  return schemaObj;
}


/* @this   Ajv */
function _compile(schemaObj, root) {
  if (schemaObj.compiling) {
    schemaObj.validate = callValidate;
    callValidate.schema = schemaObj.schema;
    callValidate.errors = null;
    callValidate.root = root ? root : callValidate;
    if (schemaObj.schema.$async === true)
      callValidate.$async = true;
    return callValidate;
  }
  schemaObj.compiling = true;

  var currentOpts;
  if (schemaObj.meta) {
    currentOpts = this._opts;
    this._opts = this._metaOpts;
  }

  var v;
  try { v = compileSchema.call(this, schemaObj.schema, root, schemaObj.localRefs); }
  catch(e) {
    delete schemaObj.validate;
    throw e;
  }
  finally {
    schemaObj.compiling = false;
    if (schemaObj.meta) this._opts = currentOpts;
  }

  schemaObj.validate = v;
  schemaObj.refs = v.refs;
  schemaObj.refVal = v.refVal;
  schemaObj.root = v.root;
  return v;


  /* @this   {*} - custom context, see passContext option */
  function callValidate() {
    /* jshint validthis: true */
    var _validate = schemaObj.validate;
    var result = _validate.apply(this, arguments);
    callValidate.errors = _validate.errors;
    return result;
  }
}


function chooseGetId(opts) {
  switch (opts.schemaId) {
    case 'auto': return _get$IdOrId;
    case 'id': return _getId;
    default: return _get$Id;
  }
}

/* @this   Ajv */
function _getId(schema) {
  if (schema.$id) this.logger.warn('schema $id ignored', schema.$id);
  return schema.id;
}

/* @this   Ajv */
function _get$Id(schema) {
  if (schema.id) this.logger.warn('schema id ignored', schema.id);
  return schema.$id;
}


function _get$IdOrId(schema) {
  if (schema.$id && schema.id && schema.$id != schema.id)
    throw new Error('schema $id is different from id');
  return schema.$id || schema.id;
}


/**
 * Convert array of error message objects to string
 * @this   Ajv
 * @param  {Array<Object>} errors optional array of validation errors, if not passed errors from the instance are used.
 * @param  {Object} options optional options with properties `separator` and `dataVar`.
 * @return {String} human readable string with all errors descriptions
 */
function errorsText(errors, options) {
  errors = errors || this.errors;
  if (!errors) return 'No errors';
  options = options || {};
  var separator = options.separator === undefined ? ', ' : options.separator;
  var dataVar = options.dataVar === undefined ? 'data' : options.dataVar;

  var text = '';
  for (var i=0; i<errors.length; i++) {
    var e = errors[i];
    if (e) text += dataVar + e.dataPath + ' ' + e.message + separator;
  }
  return text.slice(0, -separator.length);
}


/**
 * Add custom format
 * @this   Ajv
 * @param {String} name format name
 * @param {String|RegExp|Function} format string is converted to RegExp; function should return boolean (true when valid)
 * @return {Ajv} this for method chaining
 */
function addFormat(name, format) {
  if (typeof format == 'string') format = new RegExp(format);
  this._formats[name] = format;
  return this;
}


function addDefaultMetaSchema(self) {
  var $dataSchema;
  if (self._opts.$data) {
    $dataSchema = require('./refs/data.json');
    self.addMetaSchema($dataSchema, $dataSchema.$id, true);
  }
  if (self._opts.meta === false) return;
  var metaSchema = require('./refs/json-schema-draft-07.json');
  if (self._opts.$data) metaSchema = $dataMetaSchema(metaSchema, META_SUPPORT_DATA);
  self.addMetaSchema(metaSchema, META_SCHEMA_ID, true);
  self._refs['http://json-schema.org/schema'] = META_SCHEMA_ID;
}


function addInitialSchemas(self) {
  var optsSchemas = self._opts.schemas;
  if (!optsSchemas) return;
  if (Array.isArray(optsSchemas)) self.addSchema(optsSchemas);
  else for (var key in optsSchemas) self.addSchema(optsSchemas[key], key);
}


function addInitialFormats(self) {
  for (var name in self._opts.formats) {
    var format = self._opts.formats[name];
    self.addFormat(name, format);
  }
}


function addInitialKeywords(self) {
  for (var name in self._opts.keywords) {
    var keyword = self._opts.keywords[name];
    self.addKeyword(name, keyword);
  }
}


function checkUnique(self, id) {
  if (self._schemas[id] || self._refs[id])
    throw new Error('schema with key or id "' + id + '" already exists');
}


function getMetaSchemaOptions(self) {
  var metaOpts = util.copy(self._opts);
  for (var i=0; i<META_IGNORE_OPTIONS.length; i++)
    delete metaOpts[META_IGNORE_OPTIONS[i]];
  return metaOpts;
}


function setLogger(self) {
  var logger = self._opts.logger;
  if (logger === false) {
    self.logger = {log: noop, warn: noop, error: noop};
  } else {
    if (logger === undefined) logger = console;
    if (!(typeof logger == 'object' && logger.log && logger.warn && logger.error))
      throw new Error('logger must implement log, warn and error methods');
    self.logger = logger;
  }
}


function noop() {}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\ajv.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\cache.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Ccache.js
      return function (require, module, exports) {
'use strict';


var Cache = module.exports = function Cache() {
  this._cache = {};
};


Cache.prototype.put = function Cache_put(key, value) {
  this._cache[key] = value;
};


Cache.prototype.get = function Cache_get(key) {
  return this._cache[key];
};


Cache.prototype.del = function Cache_del(key) {
  delete this._cache[key];
};


Cache.prototype.clear = function Cache_clear() {
  this._cache = {};
};

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\cache.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\async.js", {"./error_classes":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\error_classes.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Ccompile%5Casync.js
      return function (require, module, exports) {
'use strict';

var MissingRefError = require('./error_classes').MissingRef;

module.exports = compileAsync;


/**
 * Creates validating function for passed schema with asynchronous loading of missing schemas.
 * `loadSchema` option should be a function that accepts schema uri and returns promise that resolves with the schema.
 * @this  Ajv
 * @param {Object}   schema schema object
 * @param {Boolean}  meta optional true to compile meta-schema; this parameter can be skipped
 * @param {Function} callback an optional node-style callback, it is called with 2 parameters: error (or null) and validating function.
 * @return {Promise} promise that resolves with a validating function.
 */
function compileAsync(schema, meta, callback) {
  /* eslint no-shadow: 0 */
  /* global Promise */
  /* jshint validthis: true */
  var self = this;
  if (typeof this._opts.loadSchema != 'function')
    throw new Error('options.loadSchema should be a function');

  if (typeof meta == 'function') {
    callback = meta;
    meta = undefined;
  }

  var p = loadMetaSchemaOf(schema).then(function () {
    var schemaObj = self._addSchema(schema, undefined, meta);
    return schemaObj.validate || _compileAsync(schemaObj);
  });

  if (callback) {
    p.then(
      function(v) { callback(null, v); },
      callback
    );
  }

  return p;


  function loadMetaSchemaOf(sch) {
    var $schema = sch.$schema;
    return $schema && !self.getSchema($schema)
            ? compileAsync.call(self, { $ref: $schema }, true)
            : Promise.resolve();
  }


  function _compileAsync(schemaObj) {
    try { return self._compile(schemaObj); }
    catch(e) {
      if (e instanceof MissingRefError) return loadMissingSchema(e);
      throw e;
    }


    function loadMissingSchema(e) {
      var ref = e.missingSchema;
      if (added(ref)) throw new Error('Schema ' + ref + ' is loaded but ' + e.missingRef + ' cannot be resolved');

      var schemaPromise = self._loadingSchemas[ref];
      if (!schemaPromise) {
        schemaPromise = self._loadingSchemas[ref] = self._opts.loadSchema(ref);
        schemaPromise.then(removePromise, removePromise);
      }

      return schemaPromise.then(function (sch) {
        if (!added(ref)) {
          return loadMetaSchemaOf(sch).then(function () {
            if (!added(ref)) self.addSchema(sch, ref, undefined, meta);
          });
        }
      }).then(function() {
        return _compileAsync(schemaObj);
      });

      function removePromise() {
        delete self._loadingSchemas[ref];
      }

      function added(ref) {
        return self._refs[ref] || self._schemas[ref];
      }
    }
  }
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\compile\\async.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\error_classes.js", {"./resolve":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\resolve.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Ccompile%5Cerror_classes.js
      return function (require, module, exports) {
'use strict';

var resolve = require('./resolve');

module.exports = {
  Validation: errorSubclass(ValidationError),
  MissingRef: errorSubclass(MissingRefError)
};


function ValidationError(errors) {
  this.message = 'validation failed';
  this.errors = errors;
  this.ajv = this.validation = true;
}


MissingRefError.message = function (baseId, ref) {
  return 'can\'t resolve reference ' + ref + ' from id ' + baseId;
};


function MissingRefError(baseId, ref, message) {
  this.message = message || MissingRefError.message(baseId, ref);
  this.missingRef = resolve.url(baseId, ref);
  this.missingSchema = resolve.normalizeId(resolve.fullPath(this.missingRef));
}


function errorSubclass(Subclass) {
  Subclass.prototype = Object.create(Error.prototype);
  Subclass.prototype.constructor = Subclass;
  return Subclass;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\compile\\error_classes.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\formats.js", {"./util":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\util.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Ccompile%5Cformats.js
      return function (require, module, exports) {
'use strict';

var util = require('./util');

var DATE = /^(\d\d\d\d)-(\d\d)-(\d\d)$/;
var DAYS = [0,31,28,31,30,31,30,31,31,30,31,30,31];
var TIME = /^(\d\d):(\d\d):(\d\d)(\.\d+)?(z|[+-]\d\d(?::?\d\d)?)?$/i;
var HOSTNAME = /^(?=.{1,253}\.?$)[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*\.?$/i;
var URI = /^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i;
var URIREF = /^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i;
// uri-template: https://tools.ietf.org/html/rfc6570
var URITEMPLATE = /^(?:(?:[^\x00-\x20"'<>%\\^`{|}]|%[0-9a-f]{2})|\{[+#./;?&=,!@|]?(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?(?:,(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?)*\})*$/i;
// For the source: https://gist.github.com/dperini/729294
// For test cases: https://mathiasbynens.be/demo/url-regex
// @todo Delete current URL in favour of the commented out URL rule when this issue is fixed https://github.com/eslint/eslint/issues/7983.
// var URL = /^(?:(?:https?|ftp):\/\/)(?:\S+(?::\S*)?@)?(?:(?!10(?:\.\d{1,3}){3})(?!127(?:\.\d{1,3}){3})(?!169\.254(?:\.\d{1,3}){2})(?!192\.168(?:\.\d{1,3}){2})(?!172\.(?:1[6-9]|2\d|3[0-1])(?:\.\d{1,3}){2})(?:[1-9]\d?|1\d\d|2[01]\d|22[0-3])(?:\.(?:1?\d{1,2}|2[0-4]\d|25[0-5])){2}(?:\.(?:[1-9]\d?|1\d\d|2[0-4]\d|25[0-4]))|(?:(?:[a-z\u{00a1}-\u{ffff}0-9]+-)*[a-z\u{00a1}-\u{ffff}0-9]+)(?:\.(?:[a-z\u{00a1}-\u{ffff}0-9]+-)*[a-z\u{00a1}-\u{ffff}0-9]+)*(?:\.(?:[a-z\u{00a1}-\u{ffff}]{2,})))(?::\d{2,5})?(?:\/[^\s]*)?$/iu;
var URL = /^(?:(?:http[s\u017F]?|ftp):\/\/)(?:(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+(?::(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?@)?(?:(?!10(?:\.[0-9]{1,3}){3})(?!127(?:\.[0-9]{1,3}){3})(?!169\.254(?:\.[0-9]{1,3}){2})(?!192\.168(?:\.[0-9]{1,3}){2})(?!172\.(?:1[6-9]|2[0-9]|3[01])(?:\.[0-9]{1,3}){2})(?:[1-9][0-9]?|1[0-9][0-9]|2[01][0-9]|22[0-3])(?:\.(?:1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])){2}(?:\.(?:[1-9][0-9]?|1[0-9][0-9]|2[0-4][0-9]|25[0-4]))|(?:(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)(?:\.(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)*(?:\.(?:(?:[a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]){2,})))(?::[0-9]{2,5})?(?:\/(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?$/i;
var UUID = /^(?:urn:uuid:)?[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/i;
var JSON_POINTER = /^(?:\/(?:[^~/]|~0|~1)*)*$/;
var JSON_POINTER_URI_FRAGMENT = /^#(?:\/(?:[a-z0-9_\-.!$&'()*+,;:=@]|%[0-9a-f]{2}|~0|~1)*)*$/i;
var RELATIVE_JSON_POINTER = /^(?:0|[1-9][0-9]*)(?:#|(?:\/(?:[^~/]|~0|~1)*)*)$/;


module.exports = formats;

function formats(mode) {
  mode = mode == 'full' ? 'full' : 'fast';
  return util.copy(formats[mode]);
}


formats.fast = {
  // date: http://tools.ietf.org/html/rfc3339#section-5.6
  date: /^\d\d\d\d-[0-1]\d-[0-3]\d$/,
  // date-time: http://tools.ietf.org/html/rfc3339#section-5.6
  time: /^(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)?$/i,
  'date-time': /^\d\d\d\d-[0-1]\d-[0-3]\d[t\s](?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)$/i,
  // uri: https://github.com/mafintosh/is-my-json-valid/blob/master/formats.js
  uri: /^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/)?[^\s]*$/i,
  'uri-reference': /^(?:(?:[a-z][a-z0-9+\-.]*:)?\/?\/)?(?:[^\\\s#][^\s#]*)?(?:#[^\\\s]*)?$/i,
  'uri-template': URITEMPLATE,
  url: URL,
  // email (sources from jsen validator):
  // http://stackoverflow.com/questions/201323/using-a-regular-expression-to-validate-an-email-address#answer-8829363
  // http://www.w3.org/TR/html5/forms.html#valid-e-mail-address (search for 'willful violation')
  email: /^[a-z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*$/i,
  hostname: HOSTNAME,
  // optimized https://www.safaribooksonline.com/library/view/regular-expressions-cookbook/9780596802837/ch07s16.html
  ipv4: /^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,
  // optimized http://stackoverflow.com/questions/53497/regular-expression-that-matches-valid-ipv6-addresses
  ipv6: /^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,
  regex: regex,
  // uuid: http://tools.ietf.org/html/rfc4122
  uuid: UUID,
  // JSON-pointer: https://tools.ietf.org/html/rfc6901
  // uri fragment: https://tools.ietf.org/html/rfc3986#appendix-A
  'json-pointer': JSON_POINTER,
  'json-pointer-uri-fragment': JSON_POINTER_URI_FRAGMENT,
  // relative JSON-pointer: http://tools.ietf.org/html/draft-luff-relative-json-pointer-00
  'relative-json-pointer': RELATIVE_JSON_POINTER
};


formats.full = {
  date: date,
  time: time,
  'date-time': date_time,
  uri: uri,
  'uri-reference': URIREF,
  'uri-template': URITEMPLATE,
  url: URL,
  email: /^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i,
  hostname: HOSTNAME,
  ipv4: /^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,
  ipv6: /^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,
  regex: regex,
  uuid: UUID,
  'json-pointer': JSON_POINTER,
  'json-pointer-uri-fragment': JSON_POINTER_URI_FRAGMENT,
  'relative-json-pointer': RELATIVE_JSON_POINTER
};


function isLeapYear(year) {
  // https://tools.ietf.org/html/rfc3339#appendix-C
  return year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0);
}


function date(str) {
  // full-date from http://tools.ietf.org/html/rfc3339#section-5.6
  var matches = str.match(DATE);
  if (!matches) return false;

  var year = +matches[1];
  var month = +matches[2];
  var day = +matches[3];

  return month >= 1 && month <= 12 && day >= 1 &&
          day <= (month == 2 && isLeapYear(year) ? 29 : DAYS[month]);
}


function time(str, full) {
  var matches = str.match(TIME);
  if (!matches) return false;

  var hour = matches[1];
  var minute = matches[2];
  var second = matches[3];
  var timeZone = matches[5];
  return ((hour <= 23 && minute <= 59 && second <= 59) ||
          (hour == 23 && minute == 59 && second == 60)) &&
         (!full || timeZone);
}


var DATE_TIME_SEPARATOR = /t|\s/i;
function date_time(str) {
  // http://tools.ietf.org/html/rfc3339#section-5.6
  var dateTime = str.split(DATE_TIME_SEPARATOR);
  return dateTime.length == 2 && date(dateTime[0]) && time(dateTime[1], true);
}


var NOT_URI_FRAGMENT = /\/|:/;
function uri(str) {
  // http://jmrware.com/articles/2009/uri_regexp/URI_regex.html + optional protocol + required "."
  return NOT_URI_FRAGMENT.test(str) && URI.test(str);
}


var Z_ANCHOR = /[^\\]\\Z/;
function regex(str) {
  if (Z_ANCHOR.test(str)) return false;
  try {
    new RegExp(str);
    return true;
  } catch(e) {
    return false;
  }
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\compile\\formats.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\index.js", {"../dotjs/validate":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\validate.js","./error_classes":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\error_classes.js","./resolve":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\resolve.js","./util":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\util.js","fast-deep-equal":"D:\\code\\v\\metamask-extension\\node_modules\\fast-deep-equal\\index.js","fast-json-stable-stringify":"D:\\code\\v\\metamask-extension\\node_modules\\fast-json-stable-stringify\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Ccompile%5Cindex.js
      return function (require, module, exports) {
'use strict';

var resolve = require('./resolve')
  , util = require('./util')
  , errorClasses = require('./error_classes')
  , stableStringify = require('fast-json-stable-stringify');

var validateGenerator = require('../dotjs/validate');

/**
 * Functions below are used inside compiled validations function
 */

var ucs2length = util.ucs2length;
var equal = require('fast-deep-equal');

// this error is thrown by async schemas to return validation errors via exception
var ValidationError = errorClasses.Validation;

module.exports = compile;


/**
 * Compiles schema to validation function
 * @this   Ajv
 * @param  {Object} schema schema object
 * @param  {Object} root object with information about the root schema for this schema
 * @param  {Object} localRefs the hash of local references inside the schema (created by resolve.id), used for inline resolution
 * @param  {String} baseId base ID for IDs in the schema
 * @return {Function} validation function
 */
function compile(schema, root, localRefs, baseId) {
  /* jshint validthis: true, evil: true */
  /* eslint no-shadow: 0 */
  var self = this
    , opts = this._opts
    , refVal = [ undefined ]
    , refs = {}
    , patterns = []
    , patternsHash = {}
    , defaults = []
    , defaultsHash = {}
    , customRules = [];

  root = root || { schema: schema, refVal: refVal, refs: refs };

  var c = checkCompiling.call(this, schema, root, baseId);
  var compilation = this._compilations[c.index];
  if (c.compiling) return (compilation.callValidate = callValidate);

  var formats = this._formats;
  var RULES = this.RULES;

  try {
    var v = localCompile(schema, root, localRefs, baseId);
    compilation.validate = v;
    var cv = compilation.callValidate;
    if (cv) {
      cv.schema = v.schema;
      cv.errors = null;
      cv.refs = v.refs;
      cv.refVal = v.refVal;
      cv.root = v.root;
      cv.$async = v.$async;
      if (opts.sourceCode) cv.source = v.source;
    }
    return v;
  } finally {
    endCompiling.call(this, schema, root, baseId);
  }

  /* @this   {*} - custom context, see passContext option */
  function callValidate() {
    /* jshint validthis: true */
    var validate = compilation.validate;
    var result = validate.apply(this, arguments);
    callValidate.errors = validate.errors;
    return result;
  }

  function localCompile(_schema, _root, localRefs, baseId) {
    var isRoot = !_root || (_root && _root.schema == _schema);
    if (_root.schema != root.schema)
      return compile.call(self, _schema, _root, localRefs, baseId);

    var $async = _schema.$async === true;

    var sourceCode = validateGenerator({
      isTop: true,
      schema: _schema,
      isRoot: isRoot,
      baseId: baseId,
      root: _root,
      schemaPath: '',
      errSchemaPath: '#',
      errorPath: '""',
      MissingRefError: errorClasses.MissingRef,
      RULES: RULES,
      validate: validateGenerator,
      util: util,
      resolve: resolve,
      resolveRef: resolveRef,
      usePattern: usePattern,
      useDefault: useDefault,
      useCustomRule: useCustomRule,
      opts: opts,
      formats: formats,
      logger: self.logger,
      self: self
    });

    sourceCode = vars(refVal, refValCode) + vars(patterns, patternCode)
                   + vars(defaults, defaultCode) + vars(customRules, customRuleCode)
                   + sourceCode;

    if (opts.processCode) sourceCode = opts.processCode(sourceCode, _schema);
    // console.log('\n\n\n *** \n', JSON.stringify(sourceCode));
    var validate;
    try {
      var makeValidate = new Function(
        'self',
        'RULES',
        'formats',
        'root',
        'refVal',
        'defaults',
        'customRules',
        'equal',
        'ucs2length',
        'ValidationError',
        sourceCode
      );

      validate = makeValidate(
        self,
        RULES,
        formats,
        root,
        refVal,
        defaults,
        customRules,
        equal,
        ucs2length,
        ValidationError
      );

      refVal[0] = validate;
    } catch(e) {
      self.logger.error('Error compiling schema, function code:', sourceCode);
      throw e;
    }

    validate.schema = _schema;
    validate.errors = null;
    validate.refs = refs;
    validate.refVal = refVal;
    validate.root = isRoot ? validate : _root;
    if ($async) validate.$async = true;
    if (opts.sourceCode === true) {
      validate.source = {
        code: sourceCode,
        patterns: patterns,
        defaults: defaults
      };
    }

    return validate;
  }

  function resolveRef(baseId, ref, isRoot) {
    ref = resolve.url(baseId, ref);
    var refIndex = refs[ref];
    var _refVal, refCode;
    if (refIndex !== undefined) {
      _refVal = refVal[refIndex];
      refCode = 'refVal[' + refIndex + ']';
      return resolvedRef(_refVal, refCode);
    }
    if (!isRoot && root.refs) {
      var rootRefId = root.refs[ref];
      if (rootRefId !== undefined) {
        _refVal = root.refVal[rootRefId];
        refCode = addLocalRef(ref, _refVal);
        return resolvedRef(_refVal, refCode);
      }
    }

    refCode = addLocalRef(ref);
    var v = resolve.call(self, localCompile, root, ref);
    if (v === undefined) {
      var localSchema = localRefs && localRefs[ref];
      if (localSchema) {
        v = resolve.inlineRef(localSchema, opts.inlineRefs)
            ? localSchema
            : compile.call(self, localSchema, root, localRefs, baseId);
      }
    }

    if (v === undefined) {
      removeLocalRef(ref);
    } else {
      replaceLocalRef(ref, v);
      return resolvedRef(v, refCode);
    }
  }

  function addLocalRef(ref, v) {
    var refId = refVal.length;
    refVal[refId] = v;
    refs[ref] = refId;
    return 'refVal' + refId;
  }

  function removeLocalRef(ref) {
    delete refs[ref];
  }

  function replaceLocalRef(ref, v) {
    var refId = refs[ref];
    refVal[refId] = v;
  }

  function resolvedRef(refVal, code) {
    return typeof refVal == 'object' || typeof refVal == 'boolean'
            ? { code: code, schema: refVal, inline: true }
            : { code: code, $async: refVal && !!refVal.$async };
  }

  function usePattern(regexStr) {
    var index = patternsHash[regexStr];
    if (index === undefined) {
      index = patternsHash[regexStr] = patterns.length;
      patterns[index] = regexStr;
    }
    return 'pattern' + index;
  }

  function useDefault(value) {
    switch (typeof value) {
      case 'boolean':
      case 'number':
        return '' + value;
      case 'string':
        return util.toQuotedString(value);
      case 'object':
        if (value === null) return 'null';
        var valueStr = stableStringify(value);
        var index = defaultsHash[valueStr];
        if (index === undefined) {
          index = defaultsHash[valueStr] = defaults.length;
          defaults[index] = value;
        }
        return 'default' + index;
    }
  }

  function useCustomRule(rule, schema, parentSchema, it) {
    if (self._opts.validateSchema !== false) {
      var deps = rule.definition.dependencies;
      if (deps && !deps.every(function(keyword) {
        return Object.prototype.hasOwnProperty.call(parentSchema, keyword);
      }))
        throw new Error('parent schema must have all required keywords: ' + deps.join(','));

      var validateSchema = rule.definition.validateSchema;
      if (validateSchema) {
        var valid = validateSchema(schema);
        if (!valid) {
          var message = 'keyword schema is invalid: ' + self.errorsText(validateSchema.errors);
          if (self._opts.validateSchema == 'log') self.logger.error(message);
          else throw new Error(message);
        }
      }
    }

    var compile = rule.definition.compile
      , inline = rule.definition.inline
      , macro = rule.definition.macro;

    var validate;
    if (compile) {
      validate = compile.call(self, schema, parentSchema, it);
    } else if (macro) {
      validate = macro.call(self, schema, parentSchema, it);
      if (opts.validateSchema !== false) self.validateSchema(validate, true);
    } else if (inline) {
      validate = inline.call(self, it, rule.keyword, schema, parentSchema);
    } else {
      validate = rule.definition.validate;
      if (!validate) return;
    }

    if (validate === undefined)
      throw new Error('custom keyword "' + rule.keyword + '"failed to compile');

    var index = customRules.length;
    customRules[index] = validate;

    return {
      code: 'customRule' + index,
      validate: validate
    };
  }
}


/**
 * Checks if the schema is currently compiled
 * @this   Ajv
 * @param  {Object} schema schema to compile
 * @param  {Object} root root object
 * @param  {String} baseId base schema ID
 * @return {Object} object with properties "index" (compilation index) and "compiling" (boolean)
 */
function checkCompiling(schema, root, baseId) {
  /* jshint validthis: true */
  var index = compIndex.call(this, schema, root, baseId);
  if (index >= 0) return { index: index, compiling: true };
  index = this._compilations.length;
  this._compilations[index] = {
    schema: schema,
    root: root,
    baseId: baseId
  };
  return { index: index, compiling: false };
}


/**
 * Removes the schema from the currently compiled list
 * @this   Ajv
 * @param  {Object} schema schema to compile
 * @param  {Object} root root object
 * @param  {String} baseId base schema ID
 */
function endCompiling(schema, root, baseId) {
  /* jshint validthis: true */
  var i = compIndex.call(this, schema, root, baseId);
  if (i >= 0) this._compilations.splice(i, 1);
}


/**
 * Index of schema compilation in the currently compiled list
 * @this   Ajv
 * @param  {Object} schema schema to compile
 * @param  {Object} root root object
 * @param  {String} baseId base schema ID
 * @return {Integer} compilation index
 */
function compIndex(schema, root, baseId) {
  /* jshint validthis: true */
  for (var i=0; i<this._compilations.length; i++) {
    var c = this._compilations[i];
    if (c.schema == schema && c.root == root && c.baseId == baseId) return i;
  }
  return -1;
}


function patternCode(i, patterns) {
  return 'var pattern' + i + ' = new RegExp(' + util.toQuotedString(patterns[i]) + ');';
}


function defaultCode(i) {
  return 'var default' + i + ' = defaults[' + i + '];';
}


function refValCode(i, refVal) {
  return refVal[i] === undefined ? '' : 'var refVal' + i + ' = refVal[' + i + '];';
}


function customRuleCode(i) {
  return 'var customRule' + i + ' = customRules[' + i + '];';
}


function vars(arr, statement) {
  if (!arr.length) return '';
  var code = '';
  for (var i=0; i<arr.length; i++)
    code += statement(i, arr);
  return code;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\compile\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\resolve.js", {"./schema_obj":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\schema_obj.js","./util":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\util.js","fast-deep-equal":"D:\\code\\v\\metamask-extension\\node_modules\\fast-deep-equal\\index.js","json-schema-traverse":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\node_modules\\json-schema-traverse\\index.js","uri-js":"D:\\code\\v\\metamask-extension\\node_modules\\uri-js\\dist\\es5\\uri.all.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Ccompile%5Cresolve.js
      return function (require, module, exports) {
'use strict';

var URI = require('uri-js')
  , equal = require('fast-deep-equal')
  , util = require('./util')
  , SchemaObject = require('./schema_obj')
  , traverse = require('json-schema-traverse');

module.exports = resolve;

resolve.normalizeId = normalizeId;
resolve.fullPath = getFullPath;
resolve.url = resolveUrl;
resolve.ids = resolveIds;
resolve.inlineRef = inlineRef;
resolve.schema = resolveSchema;

/**
 * [resolve and compile the references ($ref)]
 * @this   Ajv
 * @param  {Function} compile reference to schema compilation funciton (localCompile)
 * @param  {Object} root object with information about the root schema for the current schema
 * @param  {String} ref reference to resolve
 * @return {Object|Function} schema object (if the schema can be inlined) or validation function
 */
function resolve(compile, root, ref) {
  /* jshint validthis: true */
  var refVal = this._refs[ref];
  if (typeof refVal == 'string') {
    if (this._refs[refVal]) refVal = this._refs[refVal];
    else return resolve.call(this, compile, root, refVal);
  }

  refVal = refVal || this._schemas[ref];
  if (refVal instanceof SchemaObject) {
    return inlineRef(refVal.schema, this._opts.inlineRefs)
            ? refVal.schema
            : refVal.validate || this._compile(refVal);
  }

  var res = resolveSchema.call(this, root, ref);
  var schema, v, baseId;
  if (res) {
    schema = res.schema;
    root = res.root;
    baseId = res.baseId;
  }

  if (schema instanceof SchemaObject) {
    v = schema.validate || compile.call(this, schema.schema, root, undefined, baseId);
  } else if (schema !== undefined) {
    v = inlineRef(schema, this._opts.inlineRefs)
        ? schema
        : compile.call(this, schema, root, undefined, baseId);
  }

  return v;
}


/**
 * Resolve schema, its root and baseId
 * @this Ajv
 * @param  {Object} root root object with properties schema, refVal, refs
 * @param  {String} ref  reference to resolve
 * @return {Object} object with properties schema, root, baseId
 */
function resolveSchema(root, ref) {
  /* jshint validthis: true */
  var p = URI.parse(ref)
    , refPath = _getFullPath(p)
    , baseId = getFullPath(this._getId(root.schema));
  if (Object.keys(root.schema).length === 0 || refPath !== baseId) {
    var id = normalizeId(refPath);
    var refVal = this._refs[id];
    if (typeof refVal == 'string') {
      return resolveRecursive.call(this, root, refVal, p);
    } else if (refVal instanceof SchemaObject) {
      if (!refVal.validate) this._compile(refVal);
      root = refVal;
    } else {
      refVal = this._schemas[id];
      if (refVal instanceof SchemaObject) {
        if (!refVal.validate) this._compile(refVal);
        if (id == normalizeId(ref))
          return { schema: refVal, root: root, baseId: baseId };
        root = refVal;
      } else {
        return;
      }
    }
    if (!root.schema) return;
    baseId = getFullPath(this._getId(root.schema));
  }
  return getJsonPointer.call(this, p, baseId, root.schema, root);
}


/* @this Ajv */
function resolveRecursive(root, ref, parsedRef) {
  /* jshint validthis: true */
  var res = resolveSchema.call(this, root, ref);
  if (res) {
    var schema = res.schema;
    var baseId = res.baseId;
    root = res.root;
    var id = this._getId(schema);
    if (id) baseId = resolveUrl(baseId, id);
    return getJsonPointer.call(this, parsedRef, baseId, schema, root);
  }
}


var PREVENT_SCOPE_CHANGE = util.toHash(['properties', 'patternProperties', 'enum', 'dependencies', 'definitions']);
/* @this Ajv */
function getJsonPointer(parsedRef, baseId, schema, root) {
  /* jshint validthis: true */
  parsedRef.fragment = parsedRef.fragment || '';
  if (parsedRef.fragment.slice(0,1) != '/') return;
  var parts = parsedRef.fragment.split('/');

  for (var i = 1; i < parts.length; i++) {
    var part = parts[i];
    if (part) {
      part = util.unescapeFragment(part);
      schema = schema[part];
      if (schema === undefined) break;
      var id;
      if (!PREVENT_SCOPE_CHANGE[part]) {
        id = this._getId(schema);
        if (id) baseId = resolveUrl(baseId, id);
        if (schema.$ref) {
          var $ref = resolveUrl(baseId, schema.$ref);
          var res = resolveSchema.call(this, root, $ref);
          if (res) {
            schema = res.schema;
            root = res.root;
            baseId = res.baseId;
          }
        }
      }
    }
  }
  if (schema !== undefined && schema !== root.schema)
    return { schema: schema, root: root, baseId: baseId };
}


var SIMPLE_INLINED = util.toHash([
  'type', 'format', 'pattern',
  'maxLength', 'minLength',
  'maxProperties', 'minProperties',
  'maxItems', 'minItems',
  'maximum', 'minimum',
  'uniqueItems', 'multipleOf',
  'required', 'enum'
]);
function inlineRef(schema, limit) {
  if (limit === false) return false;
  if (limit === undefined || limit === true) return checkNoRef(schema);
  else if (limit) return countKeys(schema) <= limit;
}


function checkNoRef(schema) {
  var item;
  if (Array.isArray(schema)) {
    for (var i=0; i<schema.length; i++) {
      item = schema[i];
      if (typeof item == 'object' && !checkNoRef(item)) return false;
    }
  } else {
    for (var key in schema) {
      if (key == '$ref') return false;
      item = schema[key];
      if (typeof item == 'object' && !checkNoRef(item)) return false;
    }
  }
  return true;
}


function countKeys(schema) {
  var count = 0, item;
  if (Array.isArray(schema)) {
    for (var i=0; i<schema.length; i++) {
      item = schema[i];
      if (typeof item == 'object') count += countKeys(item);
      if (count == Infinity) return Infinity;
    }
  } else {
    for (var key in schema) {
      if (key == '$ref') return Infinity;
      if (SIMPLE_INLINED[key]) {
        count++;
      } else {
        item = schema[key];
        if (typeof item == 'object') count += countKeys(item) + 1;
        if (count == Infinity) return Infinity;
      }
    }
  }
  return count;
}


function getFullPath(id, normalize) {
  if (normalize !== false) id = normalizeId(id);
  var p = URI.parse(id);
  return _getFullPath(p);
}


function _getFullPath(p) {
  return URI.serialize(p).split('#')[0] + '#';
}


var TRAILING_SLASH_HASH = /#\/?$/;
function normalizeId(id) {
  return id ? id.replace(TRAILING_SLASH_HASH, '') : '';
}


function resolveUrl(baseId, id) {
  id = normalizeId(id);
  return URI.resolve(baseId, id);
}


/* @this Ajv */
function resolveIds(schema) {
  var schemaId = normalizeId(this._getId(schema));
  var baseIds = {'': schemaId};
  var fullPaths = {'': getFullPath(schemaId, false)};
  var localRefs = {};
  var self = this;

  traverse(schema, {allKeys: true}, function(sch, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex) {
    if (jsonPtr === '') return;
    var id = self._getId(sch);
    var baseId = baseIds[parentJsonPtr];
    var fullPath = fullPaths[parentJsonPtr] + '/' + parentKeyword;
    if (keyIndex !== undefined)
      fullPath += '/' + (typeof keyIndex == 'number' ? keyIndex : util.escapeFragment(keyIndex));

    if (typeof id == 'string') {
      id = baseId = normalizeId(baseId ? URI.resolve(baseId, id) : id);

      var refVal = self._refs[id];
      if (typeof refVal == 'string') refVal = self._refs[refVal];
      if (refVal && refVal.schema) {
        if (!equal(sch, refVal.schema))
          throw new Error('id "' + id + '" resolves to more than one schema');
      } else if (id != normalizeId(fullPath)) {
        if (id[0] == '#') {
          if (localRefs[id] && !equal(sch, localRefs[id]))
            throw new Error('id "' + id + '" resolves to more than one schema');
          localRefs[id] = sch;
        } else {
          self._refs[id] = fullPath;
        }
      }
    }
    baseIds[jsonPtr] = baseId;
    fullPaths[jsonPtr] = fullPath;
  });

  return localRefs;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\compile\\resolve.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\rules.js", {"../dotjs":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\index.js","./util":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\util.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Ccompile%5Crules.js
      return function (require, module, exports) {
'use strict';

var ruleModules = require('../dotjs')
  , toHash = require('./util').toHash;

module.exports = function rules() {
  var RULES = [
    { type: 'number',
      rules: [ { 'maximum': ['exclusiveMaximum'] },
               { 'minimum': ['exclusiveMinimum'] }, 'multipleOf', 'format'] },
    { type: 'string',
      rules: [ 'maxLength', 'minLength', 'pattern', 'format' ] },
    { type: 'array',
      rules: [ 'maxItems', 'minItems', 'items', 'contains', 'uniqueItems' ] },
    { type: 'object',
      rules: [ 'maxProperties', 'minProperties', 'required', 'dependencies', 'propertyNames',
               { 'properties': ['additionalProperties', 'patternProperties'] } ] },
    { rules: [ '$ref', 'const', 'enum', 'not', 'anyOf', 'oneOf', 'allOf', 'if' ] }
  ];

  var ALL = [ 'type', '$comment' ];
  var KEYWORDS = [
    '$schema', '$id', 'id', '$data', '$async', 'title',
    'description', 'default', 'definitions',
    'examples', 'readOnly', 'writeOnly',
    'contentMediaType', 'contentEncoding',
    'additionalItems', 'then', 'else'
  ];
  var TYPES = [ 'number', 'integer', 'string', 'array', 'object', 'boolean', 'null' ];
  RULES.all = toHash(ALL);
  RULES.types = toHash(TYPES);

  RULES.forEach(function (group) {
    group.rules = group.rules.map(function (keyword) {
      var implKeywords;
      if (typeof keyword == 'object') {
        var key = Object.keys(keyword)[0];
        implKeywords = keyword[key];
        keyword = key;
        implKeywords.forEach(function (k) {
          ALL.push(k);
          RULES.all[k] = true;
        });
      }
      ALL.push(keyword);
      var rule = RULES.all[keyword] = {
        keyword: keyword,
        code: ruleModules[keyword],
        implements: implKeywords
      };
      return rule;
    });

    RULES.all.$comment = {
      keyword: '$comment',
      code: ruleModules.$comment
    };

    if (group.type) RULES.types[group.type] = group;
  });

  RULES.keywords = toHash(ALL.concat(KEYWORDS));
  RULES.custom = {};

  return RULES;
};

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\compile\\rules.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\schema_obj.js", {"./util":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\util.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Ccompile%5Cschema_obj.js
      return function (require, module, exports) {
'use strict';

var util = require('./util');

module.exports = SchemaObject;

function SchemaObject(obj) {
  util.copy(obj, this);
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\compile\\schema_obj.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\ucs2length.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Ccompile%5Cucs2length.js
      return function (require, module, exports) {
'use strict';

// https://mathiasbynens.be/notes/javascript-encoding
// https://github.com/bestiejs/punycode.js - punycode.ucs2.decode
module.exports = function ucs2length(str) {
  var length = 0
    , len = str.length
    , pos = 0
    , value;
  while (pos < len) {
    length++;
    value = str.charCodeAt(pos++);
    if (value >= 0xD800 && value <= 0xDBFF && pos < len) {
      // high surrogate, and there is a next character
      value = str.charCodeAt(pos);
      if ((value & 0xFC00) == 0xDC00) pos++; // low surrogate
    }
  }
  return length;
};

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\compile\\ucs2length.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\util.js", {"./ucs2length":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\compile\\ucs2length.js","fast-deep-equal":"D:\\code\\v\\metamask-extension\\node_modules\\fast-deep-equal\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Ccompile%5Cutil.js
      return function (require, module, exports) {
'use strict';


module.exports = {
  copy: copy,
  checkDataType: checkDataType,
  checkDataTypes: checkDataTypes,
  coerceToTypes: coerceToTypes,
  toHash: toHash,
  getProperty: getProperty,
  escapeQuotes: escapeQuotes,
  equal: require('fast-deep-equal'),
  ucs2length: require('./ucs2length'),
  varOccurences: varOccurences,
  varReplace: varReplace,
  schemaHasRules: schemaHasRules,
  schemaHasRulesExcept: schemaHasRulesExcept,
  schemaUnknownRules: schemaUnknownRules,
  toQuotedString: toQuotedString,
  getPathExpr: getPathExpr,
  getPath: getPath,
  getData: getData,
  unescapeFragment: unescapeFragment,
  unescapeJsonPointer: unescapeJsonPointer,
  escapeFragment: escapeFragment,
  escapeJsonPointer: escapeJsonPointer
};


function copy(o, to) {
  to = to || {};
  for (var key in o) to[key] = o[key];
  return to;
}


function checkDataType(dataType, data, strictNumbers, negate) {
  var EQUAL = negate ? ' !== ' : ' === '
    , AND = negate ? ' || ' : ' && '
    , OK = negate ? '!' : ''
    , NOT = negate ? '' : '!';
  switch (dataType) {
    case 'null': return data + EQUAL + 'null';
    case 'array': return OK + 'Array.isArray(' + data + ')';
    case 'object': return '(' + OK + data + AND +
                          'typeof ' + data + EQUAL + '"object"' + AND +
                          NOT + 'Array.isArray(' + data + '))';
    case 'integer': return '(typeof ' + data + EQUAL + '"number"' + AND +
                           NOT + '(' + data + ' % 1)' +
                           AND + data + EQUAL + data +
                           (strictNumbers ? (AND + OK + 'isFinite(' + data + ')') : '') + ')';
    case 'number': return '(typeof ' + data + EQUAL + '"' + dataType + '"' +
                          (strictNumbers ? (AND + OK + 'isFinite(' + data + ')') : '') + ')';
    default: return 'typeof ' + data + EQUAL + '"' + dataType + '"';
  }
}


function checkDataTypes(dataTypes, data, strictNumbers) {
  switch (dataTypes.length) {
    case 1: return checkDataType(dataTypes[0], data, strictNumbers, true);
    default:
      var code = '';
      var types = toHash(dataTypes);
      if (types.array && types.object) {
        code = types.null ? '(': '(!' + data + ' || ';
        code += 'typeof ' + data + ' !== "object")';
        delete types.null;
        delete types.array;
        delete types.object;
      }
      if (types.number) delete types.integer;
      for (var t in types)
        code += (code ? ' && ' : '' ) + checkDataType(t, data, strictNumbers, true);

      return code;
  }
}


var COERCE_TO_TYPES = toHash([ 'string', 'number', 'integer', 'boolean', 'null' ]);
function coerceToTypes(optionCoerceTypes, dataTypes) {
  if (Array.isArray(dataTypes)) {
    var types = [];
    for (var i=0; i<dataTypes.length; i++) {
      var t = dataTypes[i];
      if (COERCE_TO_TYPES[t]) types[types.length] = t;
      else if (optionCoerceTypes === 'array' && t === 'array') types[types.length] = t;
    }
    if (types.length) return types;
  } else if (COERCE_TO_TYPES[dataTypes]) {
    return [dataTypes];
  } else if (optionCoerceTypes === 'array' && dataTypes === 'array') {
    return ['array'];
  }
}


function toHash(arr) {
  var hash = {};
  for (var i=0; i<arr.length; i++) hash[arr[i]] = true;
  return hash;
}


var IDENTIFIER = /^[a-z$_][a-z$_0-9]*$/i;
var SINGLE_QUOTE = /'|\\/g;
function getProperty(key) {
  return typeof key == 'number'
          ? '[' + key + ']'
          : IDENTIFIER.test(key)
            ? '.' + key
            : "['" + escapeQuotes(key) + "']";
}


function escapeQuotes(str) {
  return str.replace(SINGLE_QUOTE, '\\$&')
            .replace(/\n/g, '\\n')
            .replace(/\r/g, '\\r')
            .replace(/\f/g, '\\f')
            .replace(/\t/g, '\\t');
}


function varOccurences(str, dataVar) {
  dataVar += '[^0-9]';
  var matches = str.match(new RegExp(dataVar, 'g'));
  return matches ? matches.length : 0;
}


function varReplace(str, dataVar, expr) {
  dataVar += '([^0-9])';
  expr = expr.replace(/\$/g, '$$$$');
  return str.replace(new RegExp(dataVar, 'g'), expr + '$1');
}


function schemaHasRules(schema, rules) {
  if (typeof schema == 'boolean') return !schema;
  for (var key in schema) if (rules[key]) return true;
}


function schemaHasRulesExcept(schema, rules, exceptKeyword) {
  if (typeof schema == 'boolean') return !schema && exceptKeyword != 'not';
  for (var key in schema) if (key != exceptKeyword && rules[key]) return true;
}


function schemaUnknownRules(schema, rules) {
  if (typeof schema == 'boolean') return;
  for (var key in schema) if (!rules[key]) return key;
}


function toQuotedString(str) {
  return '\'' + escapeQuotes(str) + '\'';
}


function getPathExpr(currentPath, expr, jsonPointers, isNumber) {
  var path = jsonPointers // false by default
              ? '\'/\' + ' + expr + (isNumber ? '' : '.replace(/~/g, \'~0\').replace(/\\//g, \'~1\')')
              : (isNumber ? '\'[\' + ' + expr + ' + \']\'' : '\'[\\\'\' + ' + expr + ' + \'\\\']\'');
  return joinPaths(currentPath, path);
}


function getPath(currentPath, prop, jsonPointers) {
  var path = jsonPointers // false by default
              ? toQuotedString('/' + escapeJsonPointer(prop))
              : toQuotedString(getProperty(prop));
  return joinPaths(currentPath, path);
}


var JSON_POINTER = /^\/(?:[^~]|~0|~1)*$/;
var RELATIVE_JSON_POINTER = /^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/;
function getData($data, lvl, paths) {
  var up, jsonPointer, data, matches;
  if ($data === '') return 'rootData';
  if ($data[0] == '/') {
    if (!JSON_POINTER.test($data)) throw new Error('Invalid JSON-pointer: ' + $data);
    jsonPointer = $data;
    data = 'rootData';
  } else {
    matches = $data.match(RELATIVE_JSON_POINTER);
    if (!matches) throw new Error('Invalid JSON-pointer: ' + $data);
    up = +matches[1];
    jsonPointer = matches[2];
    if (jsonPointer == '#') {
      if (up >= lvl) throw new Error('Cannot access property/index ' + up + ' levels up, current level is ' + lvl);
      return paths[lvl - up];
    }

    if (up > lvl) throw new Error('Cannot access data ' + up + ' levels up, current level is ' + lvl);
    data = 'data' + ((lvl - up) || '');
    if (!jsonPointer) return data;
  }

  var expr = data;
  var segments = jsonPointer.split('/');
  for (var i=0; i<segments.length; i++) {
    var segment = segments[i];
    if (segment) {
      data += getProperty(unescapeJsonPointer(segment));
      expr += ' && ' + data;
    }
  }
  return expr;
}


function joinPaths (a, b) {
  if (a == '""') return b;
  return (a + ' + ' + b).replace(/([^\\])' \+ '/g, '$1');
}


function unescapeFragment(str) {
  return unescapeJsonPointer(decodeURIComponent(str));
}


function escapeFragment(str) {
  return encodeURIComponent(escapeJsonPointer(str));
}


function escapeJsonPointer(str) {
  return str.replace(/~/g, '~0').replace(/\//g, '~1');
}


function unescapeJsonPointer(str) {
  return str.replace(/~1/g, '/').replace(/~0/g, '~');
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\compile\\util.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\data.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdata.js
      return function (require, module, exports) {
'use strict';

var KEYWORDS = [
  'multipleOf',
  'maximum',
  'exclusiveMaximum',
  'minimum',
  'exclusiveMinimum',
  'maxLength',
  'minLength',
  'pattern',
  'additionalItems',
  'maxItems',
  'minItems',
  'uniqueItems',
  'maxProperties',
  'minProperties',
  'required',
  'additionalProperties',
  'enum',
  'format',
  'const'
];

module.exports = function (metaSchema, keywordsJsonPointers) {
  for (var i=0; i<keywordsJsonPointers.length; i++) {
    metaSchema = JSON.parse(JSON.stringify(metaSchema));
    var segments = keywordsJsonPointers[i].split('/');
    var keywords = metaSchema;
    var j;
    for (j=1; j<segments.length; j++)
      keywords = keywords[segments[j]];

    for (j=0; j<KEYWORDS.length; j++) {
      var key = KEYWORDS[j];
      var schema = keywords[key];
      if (schema) {
        keywords[key] = {
          anyOf: [
            schema,
            { $ref: 'https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#' }
          ]
        };
      }
    }
  }

  return metaSchema;
};

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\data.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\definition_schema.js", {"./refs/json-schema-draft-07.json":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\refs\\json-schema-draft-07.json"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdefinition_schema.js
      return function (require, module, exports) {
'use strict';

var metaSchema = require('./refs/json-schema-draft-07.json');

module.exports = {
  $id: 'https://github.com/ajv-validator/ajv/blob/master/lib/definition_schema.js',
  definitions: {
    simpleTypes: metaSchema.definitions.simpleTypes
  },
  type: 'object',
  dependencies: {
    schema: ['validate'],
    $data: ['validate'],
    statements: ['inline'],
    valid: {not: {required: ['macro']}}
  },
  properties: {
    type: metaSchema.properties.type,
    schema: {type: 'boolean'},
    statements: {type: 'boolean'},
    dependencies: {
      type: 'array',
      items: {type: 'string'}
    },
    metaSchema: {type: 'object'},
    modifying: {type: 'boolean'},
    valid: {type: 'boolean'},
    $data: {type: 'boolean'},
    async: {type: 'boolean'},
    errors: {
      anyOf: [
        {type: 'boolean'},
        {const: 'full'}
      ]
    }
  }
};

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\definition_schema.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\_limit.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5C_limit.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate__limit(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $errorKeyword;
  var $data = 'data' + ($dataLvl || '');
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  var $isMax = $keyword == 'maximum',
    $exclusiveKeyword = $isMax ? 'exclusiveMaximum' : 'exclusiveMinimum',
    $schemaExcl = it.schema[$exclusiveKeyword],
    $isDataExcl = it.opts.$data && $schemaExcl && $schemaExcl.$data,
    $op = $isMax ? '<' : '>',
    $notOp = $isMax ? '>' : '<',
    $errorKeyword = undefined;
  if (!($isData || typeof $schema == 'number' || $schema === undefined)) {
    throw new Error($keyword + ' must be number');
  }
  if (!($isDataExcl || $schemaExcl === undefined || typeof $schemaExcl == 'number' || typeof $schemaExcl == 'boolean')) {
    throw new Error($exclusiveKeyword + ' must be number or boolean');
  }
  if ($isDataExcl) {
    var $schemaValueExcl = it.util.getData($schemaExcl.$data, $dataLvl, it.dataPathArr),
      $exclusive = 'exclusive' + $lvl,
      $exclType = 'exclType' + $lvl,
      $exclIsNumber = 'exclIsNumber' + $lvl,
      $opExpr = 'op' + $lvl,
      $opStr = '\' + ' + $opExpr + ' + \'';
    out += ' var schemaExcl' + ($lvl) + ' = ' + ($schemaValueExcl) + '; ';
    $schemaValueExcl = 'schemaExcl' + $lvl;
    out += ' var ' + ($exclusive) + '; var ' + ($exclType) + ' = typeof ' + ($schemaValueExcl) + '; if (' + ($exclType) + ' != \'boolean\' && ' + ($exclType) + ' != \'undefined\' && ' + ($exclType) + ' != \'number\') { ';
    var $errorKeyword = $exclusiveKeyword;
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = ''; /* istanbul ignore else */
    if (it.createErrors !== false) {
      out += ' { keyword: \'' + ($errorKeyword || '_exclusiveLimit') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
      if (it.opts.messages !== false) {
        out += ' , message: \'' + ($exclusiveKeyword) + ' should be boolean\' ';
      }
      if (it.opts.verbose) {
        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
      }
      out += ' } ';
    } else {
      out += ' {} ';
    }
    var __err = out;
    out = $$outStack.pop();
    if (!it.compositeRule && $breakOnError) {
      /* istanbul ignore if */
      if (it.async) {
        out += ' throw new ValidationError([' + (__err) + ']); ';
      } else {
        out += ' validate.errors = [' + (__err) + ']; return false; ';
      }
    } else {
      out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
    }
    out += ' } else if ( ';
    if ($isData) {
      out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
    }
    out += ' ' + ($exclType) + ' == \'number\' ? ( (' + ($exclusive) + ' = ' + ($schemaValue) + ' === undefined || ' + ($schemaValueExcl) + ' ' + ($op) + '= ' + ($schemaValue) + ') ? ' + ($data) + ' ' + ($notOp) + '= ' + ($schemaValueExcl) + ' : ' + ($data) + ' ' + ($notOp) + ' ' + ($schemaValue) + ' ) : ( (' + ($exclusive) + ' = ' + ($schemaValueExcl) + ' === true) ? ' + ($data) + ' ' + ($notOp) + '= ' + ($schemaValue) + ' : ' + ($data) + ' ' + ($notOp) + ' ' + ($schemaValue) + ' ) || ' + ($data) + ' !== ' + ($data) + ') { var op' + ($lvl) + ' = ' + ($exclusive) + ' ? \'' + ($op) + '\' : \'' + ($op) + '=\'; ';
    if ($schema === undefined) {
      $errorKeyword = $exclusiveKeyword;
      $errSchemaPath = it.errSchemaPath + '/' + $exclusiveKeyword;
      $schemaValue = $schemaValueExcl;
      $isData = $isDataExcl;
    }
  } else {
    var $exclIsNumber = typeof $schemaExcl == 'number',
      $opStr = $op;
    if ($exclIsNumber && $isData) {
      var $opExpr = '\'' + $opStr + '\'';
      out += ' if ( ';
      if ($isData) {
        out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
      }
      out += ' ( ' + ($schemaValue) + ' === undefined || ' + ($schemaExcl) + ' ' + ($op) + '= ' + ($schemaValue) + ' ? ' + ($data) + ' ' + ($notOp) + '= ' + ($schemaExcl) + ' : ' + ($data) + ' ' + ($notOp) + ' ' + ($schemaValue) + ' ) || ' + ($data) + ' !== ' + ($data) + ') { ';
    } else {
      if ($exclIsNumber && $schema === undefined) {
        $exclusive = true;
        $errorKeyword = $exclusiveKeyword;
        $errSchemaPath = it.errSchemaPath + '/' + $exclusiveKeyword;
        $schemaValue = $schemaExcl;
        $notOp += '=';
      } else {
        if ($exclIsNumber) $schemaValue = Math[$isMax ? 'min' : 'max']($schemaExcl, $schema);
        if ($schemaExcl === ($exclIsNumber ? $schemaValue : true)) {
          $exclusive = true;
          $errorKeyword = $exclusiveKeyword;
          $errSchemaPath = it.errSchemaPath + '/' + $exclusiveKeyword;
          $notOp += '=';
        } else {
          $exclusive = false;
          $opStr += '=';
        }
      }
      var $opExpr = '\'' + $opStr + '\'';
      out += ' if ( ';
      if ($isData) {
        out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
      }
      out += ' ' + ($data) + ' ' + ($notOp) + ' ' + ($schemaValue) + ' || ' + ($data) + ' !== ' + ($data) + ') { ';
    }
  }
  $errorKeyword = $errorKeyword || $keyword;
  var $$outStack = $$outStack || [];
  $$outStack.push(out);
  out = ''; /* istanbul ignore else */
  if (it.createErrors !== false) {
    out += ' { keyword: \'' + ($errorKeyword || '_limit') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { comparison: ' + ($opExpr) + ', limit: ' + ($schemaValue) + ', exclusive: ' + ($exclusive) + ' } ';
    if (it.opts.messages !== false) {
      out += ' , message: \'should be ' + ($opStr) + ' ';
      if ($isData) {
        out += '\' + ' + ($schemaValue);
      } else {
        out += '' + ($schemaValue) + '\'';
      }
    }
    if (it.opts.verbose) {
      out += ' , schema:  ';
      if ($isData) {
        out += 'validate.schema' + ($schemaPath);
      } else {
        out += '' + ($schema);
      }
      out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
    }
    out += ' } ';
  } else {
    out += ' {} ';
  }
  var __err = out;
  out = $$outStack.pop();
  if (!it.compositeRule && $breakOnError) {
    /* istanbul ignore if */
    if (it.async) {
      out += ' throw new ValidationError([' + (__err) + ']); ';
    } else {
      out += ' validate.errors = [' + (__err) + ']; return false; ';
    }
  } else {
    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
  }
  out += ' } ';
  if ($breakOnError) {
    out += ' else { ';
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\_limit.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\_limitItems.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5C_limitItems.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate__limitItems(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $errorKeyword;
  var $data = 'data' + ($dataLvl || '');
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  if (!($isData || typeof $schema == 'number')) {
    throw new Error($keyword + ' must be number');
  }
  var $op = $keyword == 'maxItems' ? '>' : '<';
  out += 'if ( ';
  if ($isData) {
    out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
  }
  out += ' ' + ($data) + '.length ' + ($op) + ' ' + ($schemaValue) + ') { ';
  var $errorKeyword = $keyword;
  var $$outStack = $$outStack || [];
  $$outStack.push(out);
  out = ''; /* istanbul ignore else */
  if (it.createErrors !== false) {
    out += ' { keyword: \'' + ($errorKeyword || '_limitItems') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { limit: ' + ($schemaValue) + ' } ';
    if (it.opts.messages !== false) {
      out += ' , message: \'should NOT have ';
      if ($keyword == 'maxItems') {
        out += 'more';
      } else {
        out += 'fewer';
      }
      out += ' than ';
      if ($isData) {
        out += '\' + ' + ($schemaValue) + ' + \'';
      } else {
        out += '' + ($schema);
      }
      out += ' items\' ';
    }
    if (it.opts.verbose) {
      out += ' , schema:  ';
      if ($isData) {
        out += 'validate.schema' + ($schemaPath);
      } else {
        out += '' + ($schema);
      }
      out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
    }
    out += ' } ';
  } else {
    out += ' {} ';
  }
  var __err = out;
  out = $$outStack.pop();
  if (!it.compositeRule && $breakOnError) {
    /* istanbul ignore if */
    if (it.async) {
      out += ' throw new ValidationError([' + (__err) + ']); ';
    } else {
      out += ' validate.errors = [' + (__err) + ']; return false; ';
    }
  } else {
    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
  }
  out += '} ';
  if ($breakOnError) {
    out += ' else { ';
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\_limitItems.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\_limitLength.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5C_limitLength.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate__limitLength(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $errorKeyword;
  var $data = 'data' + ($dataLvl || '');
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  if (!($isData || typeof $schema == 'number')) {
    throw new Error($keyword + ' must be number');
  }
  var $op = $keyword == 'maxLength' ? '>' : '<';
  out += 'if ( ';
  if ($isData) {
    out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
  }
  if (it.opts.unicode === false) {
    out += ' ' + ($data) + '.length ';
  } else {
    out += ' ucs2length(' + ($data) + ') ';
  }
  out += ' ' + ($op) + ' ' + ($schemaValue) + ') { ';
  var $errorKeyword = $keyword;
  var $$outStack = $$outStack || [];
  $$outStack.push(out);
  out = ''; /* istanbul ignore else */
  if (it.createErrors !== false) {
    out += ' { keyword: \'' + ($errorKeyword || '_limitLength') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { limit: ' + ($schemaValue) + ' } ';
    if (it.opts.messages !== false) {
      out += ' , message: \'should NOT be ';
      if ($keyword == 'maxLength') {
        out += 'longer';
      } else {
        out += 'shorter';
      }
      out += ' than ';
      if ($isData) {
        out += '\' + ' + ($schemaValue) + ' + \'';
      } else {
        out += '' + ($schema);
      }
      out += ' characters\' ';
    }
    if (it.opts.verbose) {
      out += ' , schema:  ';
      if ($isData) {
        out += 'validate.schema' + ($schemaPath);
      } else {
        out += '' + ($schema);
      }
      out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
    }
    out += ' } ';
  } else {
    out += ' {} ';
  }
  var __err = out;
  out = $$outStack.pop();
  if (!it.compositeRule && $breakOnError) {
    /* istanbul ignore if */
    if (it.async) {
      out += ' throw new ValidationError([' + (__err) + ']); ';
    } else {
      out += ' validate.errors = [' + (__err) + ']; return false; ';
    }
  } else {
    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
  }
  out += '} ';
  if ($breakOnError) {
    out += ' else { ';
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\_limitLength.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\_limitProperties.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5C_limitProperties.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate__limitProperties(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $errorKeyword;
  var $data = 'data' + ($dataLvl || '');
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  if (!($isData || typeof $schema == 'number')) {
    throw new Error($keyword + ' must be number');
  }
  var $op = $keyword == 'maxProperties' ? '>' : '<';
  out += 'if ( ';
  if ($isData) {
    out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
  }
  out += ' Object.keys(' + ($data) + ').length ' + ($op) + ' ' + ($schemaValue) + ') { ';
  var $errorKeyword = $keyword;
  var $$outStack = $$outStack || [];
  $$outStack.push(out);
  out = ''; /* istanbul ignore else */
  if (it.createErrors !== false) {
    out += ' { keyword: \'' + ($errorKeyword || '_limitProperties') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { limit: ' + ($schemaValue) + ' } ';
    if (it.opts.messages !== false) {
      out += ' , message: \'should NOT have ';
      if ($keyword == 'maxProperties') {
        out += 'more';
      } else {
        out += 'fewer';
      }
      out += ' than ';
      if ($isData) {
        out += '\' + ' + ($schemaValue) + ' + \'';
      } else {
        out += '' + ($schema);
      }
      out += ' properties\' ';
    }
    if (it.opts.verbose) {
      out += ' , schema:  ';
      if ($isData) {
        out += 'validate.schema' + ($schemaPath);
      } else {
        out += '' + ($schema);
      }
      out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
    }
    out += ' } ';
  } else {
    out += ' {} ';
  }
  var __err = out;
  out = $$outStack.pop();
  if (!it.compositeRule && $breakOnError) {
    /* istanbul ignore if */
    if (it.async) {
      out += ' throw new ValidationError([' + (__err) + ']); ';
    } else {
      out += ' validate.errors = [' + (__err) + ']; return false; ';
    }
  } else {
    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
  }
  out += '} ';
  if ($breakOnError) {
    out += ' else { ';
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\_limitProperties.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\allOf.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5CallOf.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate_allOf(it, $keyword, $ruleType) {
  var out = ' ';
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $it = it.util.copy(it);
  var $closingBraces = '';
  $it.level++;
  var $nextValid = 'valid' + $it.level;
  var $currentBaseId = $it.baseId,
    $allSchemasEmpty = true;
  var arr1 = $schema;
  if (arr1) {
    var $sch, $i = -1,
      l1 = arr1.length - 1;
    while ($i < l1) {
      $sch = arr1[$i += 1];
      if ((it.opts.strictKeywords ? (typeof $sch == 'object' && Object.keys($sch).length > 0) || $sch === false : it.util.schemaHasRules($sch, it.RULES.all))) {
        $allSchemasEmpty = false;
        $it.schema = $sch;
        $it.schemaPath = $schemaPath + '[' + $i + ']';
        $it.errSchemaPath = $errSchemaPath + '/' + $i;
        out += '  ' + (it.validate($it)) + ' ';
        $it.baseId = $currentBaseId;
        if ($breakOnError) {
          out += ' if (' + ($nextValid) + ') { ';
          $closingBraces += '}';
        }
      }
    }
  }
  if ($breakOnError) {
    if ($allSchemasEmpty) {
      out += ' if (true) { ';
    } else {
      out += ' ' + ($closingBraces.slice(0, -1)) + ' ';
    }
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\allOf.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\anyOf.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5CanyOf.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate_anyOf(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $valid = 'valid' + $lvl;
  var $errs = 'errs__' + $lvl;
  var $it = it.util.copy(it);
  var $closingBraces = '';
  $it.level++;
  var $nextValid = 'valid' + $it.level;
  var $noEmptySchema = $schema.every(function($sch) {
    return (it.opts.strictKeywords ? (typeof $sch == 'object' && Object.keys($sch).length > 0) || $sch === false : it.util.schemaHasRules($sch, it.RULES.all));
  });
  if ($noEmptySchema) {
    var $currentBaseId = $it.baseId;
    out += ' var ' + ($errs) + ' = errors; var ' + ($valid) + ' = false;  ';
    var $wasComposite = it.compositeRule;
    it.compositeRule = $it.compositeRule = true;
    var arr1 = $schema;
    if (arr1) {
      var $sch, $i = -1,
        l1 = arr1.length - 1;
      while ($i < l1) {
        $sch = arr1[$i += 1];
        $it.schema = $sch;
        $it.schemaPath = $schemaPath + '[' + $i + ']';
        $it.errSchemaPath = $errSchemaPath + '/' + $i;
        out += '  ' + (it.validate($it)) + ' ';
        $it.baseId = $currentBaseId;
        out += ' ' + ($valid) + ' = ' + ($valid) + ' || ' + ($nextValid) + '; if (!' + ($valid) + ') { ';
        $closingBraces += '}';
      }
    }
    it.compositeRule = $it.compositeRule = $wasComposite;
    out += ' ' + ($closingBraces) + ' if (!' + ($valid) + ') {   var err =   '; /* istanbul ignore else */
    if (it.createErrors !== false) {
      out += ' { keyword: \'' + ('anyOf') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
      if (it.opts.messages !== false) {
        out += ' , message: \'should match some schema in anyOf\' ';
      }
      if (it.opts.verbose) {
        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
      }
      out += ' } ';
    } else {
      out += ' {} ';
    }
    out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
    if (!it.compositeRule && $breakOnError) {
      /* istanbul ignore if */
      if (it.async) {
        out += ' throw new ValidationError(vErrors); ';
      } else {
        out += ' validate.errors = vErrors; return false; ';
      }
    }
    out += ' } else {  errors = ' + ($errs) + '; if (vErrors !== null) { if (' + ($errs) + ') vErrors.length = ' + ($errs) + '; else vErrors = null; } ';
    if (it.opts.allErrors) {
      out += ' } ';
    }
  } else {
    if ($breakOnError) {
      out += ' if (true) { ';
    }
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\anyOf.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\comment.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5Ccomment.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate_comment(it, $keyword, $ruleType) {
  var out = ' ';
  var $schema = it.schema[$keyword];
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $comment = it.util.toQuotedString($schema);
  if (it.opts.$comment === true) {
    out += ' console.log(' + ($comment) + ');';
  } else if (typeof it.opts.$comment == 'function') {
    out += ' self._opts.$comment(' + ($comment) + ', ' + (it.util.toQuotedString($errSchemaPath)) + ', validate.root.schema);';
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\comment.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\const.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5Cconst.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate_const(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $valid = 'valid' + $lvl;
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  if (!$isData) {
    out += ' var schema' + ($lvl) + ' = validate.schema' + ($schemaPath) + ';';
  }
  out += 'var ' + ($valid) + ' = equal(' + ($data) + ', schema' + ($lvl) + '); if (!' + ($valid) + ') {   ';
  var $$outStack = $$outStack || [];
  $$outStack.push(out);
  out = ''; /* istanbul ignore else */
  if (it.createErrors !== false) {
    out += ' { keyword: \'' + ('const') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { allowedValue: schema' + ($lvl) + ' } ';
    if (it.opts.messages !== false) {
      out += ' , message: \'should be equal to constant\' ';
    }
    if (it.opts.verbose) {
      out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
    }
    out += ' } ';
  } else {
    out += ' {} ';
  }
  var __err = out;
  out = $$outStack.pop();
  if (!it.compositeRule && $breakOnError) {
    /* istanbul ignore if */
    if (it.async) {
      out += ' throw new ValidationError([' + (__err) + ']); ';
    } else {
      out += ' validate.errors = [' + (__err) + ']; return false; ';
    }
  } else {
    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
  }
  out += ' }';
  if ($breakOnError) {
    out += ' else { ';
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\const.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\contains.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5Ccontains.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate_contains(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $valid = 'valid' + $lvl;
  var $errs = 'errs__' + $lvl;
  var $it = it.util.copy(it);
  var $closingBraces = '';
  $it.level++;
  var $nextValid = 'valid' + $it.level;
  var $idx = 'i' + $lvl,
    $dataNxt = $it.dataLevel = it.dataLevel + 1,
    $nextData = 'data' + $dataNxt,
    $currentBaseId = it.baseId,
    $nonEmptySchema = (it.opts.strictKeywords ? (typeof $schema == 'object' && Object.keys($schema).length > 0) || $schema === false : it.util.schemaHasRules($schema, it.RULES.all));
  out += 'var ' + ($errs) + ' = errors;var ' + ($valid) + ';';
  if ($nonEmptySchema) {
    var $wasComposite = it.compositeRule;
    it.compositeRule = $it.compositeRule = true;
    $it.schema = $schema;
    $it.schemaPath = $schemaPath;
    $it.errSchemaPath = $errSchemaPath;
    out += ' var ' + ($nextValid) + ' = false; for (var ' + ($idx) + ' = 0; ' + ($idx) + ' < ' + ($data) + '.length; ' + ($idx) + '++) { ';
    $it.errorPath = it.util.getPathExpr(it.errorPath, $idx, it.opts.jsonPointers, true);
    var $passData = $data + '[' + $idx + ']';
    $it.dataPathArr[$dataNxt] = $idx;
    var $code = it.validate($it);
    $it.baseId = $currentBaseId;
    if (it.util.varOccurences($code, $nextData) < 2) {
      out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
    } else {
      out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
    }
    out += ' if (' + ($nextValid) + ') break; }  ';
    it.compositeRule = $it.compositeRule = $wasComposite;
    out += ' ' + ($closingBraces) + ' if (!' + ($nextValid) + ') {';
  } else {
    out += ' if (' + ($data) + '.length == 0) {';
  }
  var $$outStack = $$outStack || [];
  $$outStack.push(out);
  out = ''; /* istanbul ignore else */
  if (it.createErrors !== false) {
    out += ' { keyword: \'' + ('contains') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
    if (it.opts.messages !== false) {
      out += ' , message: \'should contain a valid item\' ';
    }
    if (it.opts.verbose) {
      out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
    }
    out += ' } ';
  } else {
    out += ' {} ';
  }
  var __err = out;
  out = $$outStack.pop();
  if (!it.compositeRule && $breakOnError) {
    /* istanbul ignore if */
    if (it.async) {
      out += ' throw new ValidationError([' + (__err) + ']); ';
    } else {
      out += ' validate.errors = [' + (__err) + ']; return false; ';
    }
  } else {
    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
  }
  out += ' } else { ';
  if ($nonEmptySchema) {
    out += '  errors = ' + ($errs) + '; if (vErrors !== null) { if (' + ($errs) + ') vErrors.length = ' + ($errs) + '; else vErrors = null; } ';
  }
  if (it.opts.allErrors) {
    out += ' } ';
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\contains.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\custom.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5Ccustom.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate_custom(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $errorKeyword;
  var $data = 'data' + ($dataLvl || '');
  var $valid = 'valid' + $lvl;
  var $errs = 'errs__' + $lvl;
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  var $rule = this,
    $definition = 'definition' + $lvl,
    $rDef = $rule.definition,
    $closingBraces = '';
  var $compile, $inline, $macro, $ruleValidate, $validateCode;
  if ($isData && $rDef.$data) {
    $validateCode = 'keywordValidate' + $lvl;
    var $validateSchema = $rDef.validateSchema;
    out += ' var ' + ($definition) + ' = RULES.custom[\'' + ($keyword) + '\'].definition; var ' + ($validateCode) + ' = ' + ($definition) + '.validate;';
  } else {
    $ruleValidate = it.useCustomRule($rule, $schema, it.schema, it);
    if (!$ruleValidate) return;
    $schemaValue = 'validate.schema' + $schemaPath;
    $validateCode = $ruleValidate.code;
    $compile = $rDef.compile;
    $inline = $rDef.inline;
    $macro = $rDef.macro;
  }
  var $ruleErrs = $validateCode + '.errors',
    $i = 'i' + $lvl,
    $ruleErr = 'ruleErr' + $lvl,
    $asyncKeyword = $rDef.async;
  if ($asyncKeyword && !it.async) throw new Error('async keyword in sync schema');
  if (!($inline || $macro)) {
    out += '' + ($ruleErrs) + ' = null;';
  }
  out += 'var ' + ($errs) + ' = errors;var ' + ($valid) + ';';
  if ($isData && $rDef.$data) {
    $closingBraces += '}';
    out += ' if (' + ($schemaValue) + ' === undefined) { ' + ($valid) + ' = true; } else { ';
    if ($validateSchema) {
      $closingBraces += '}';
      out += ' ' + ($valid) + ' = ' + ($definition) + '.validateSchema(' + ($schemaValue) + '); if (' + ($valid) + ') { ';
    }
  }
  if ($inline) {
    if ($rDef.statements) {
      out += ' ' + ($ruleValidate.validate) + ' ';
    } else {
      out += ' ' + ($valid) + ' = ' + ($ruleValidate.validate) + '; ';
    }
  } else if ($macro) {
    var $it = it.util.copy(it);
    var $closingBraces = '';
    $it.level++;
    var $nextValid = 'valid' + $it.level;
    $it.schema = $ruleValidate.validate;
    $it.schemaPath = '';
    var $wasComposite = it.compositeRule;
    it.compositeRule = $it.compositeRule = true;
    var $code = it.validate($it).replace(/validate\.schema/g, $validateCode);
    it.compositeRule = $it.compositeRule = $wasComposite;
    out += ' ' + ($code);
  } else {
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = '';
    out += '  ' + ($validateCode) + '.call( ';
    if (it.opts.passContext) {
      out += 'this';
    } else {
      out += 'self';
    }
    if ($compile || $rDef.schema === false) {
      out += ' , ' + ($data) + ' ';
    } else {
      out += ' , ' + ($schemaValue) + ' , ' + ($data) + ' , validate.schema' + (it.schemaPath) + ' ';
    }
    out += ' , (dataPath || \'\')';
    if (it.errorPath != '""') {
      out += ' + ' + (it.errorPath);
    }
    var $parentData = $dataLvl ? 'data' + (($dataLvl - 1) || '') : 'parentData',
      $parentDataProperty = $dataLvl ? it.dataPathArr[$dataLvl] : 'parentDataProperty';
    out += ' , ' + ($parentData) + ' , ' + ($parentDataProperty) + ' , rootData )  ';
    var def_callRuleValidate = out;
    out = $$outStack.pop();
    if ($rDef.errors === false) {
      out += ' ' + ($valid) + ' = ';
      if ($asyncKeyword) {
        out += 'await ';
      }
      out += '' + (def_callRuleValidate) + '; ';
    } else {
      if ($asyncKeyword) {
        $ruleErrs = 'customErrors' + $lvl;
        out += ' var ' + ($ruleErrs) + ' = null; try { ' + ($valid) + ' = await ' + (def_callRuleValidate) + '; } catch (e) { ' + ($valid) + ' = false; if (e instanceof ValidationError) ' + ($ruleErrs) + ' = e.errors; else throw e; } ';
      } else {
        out += ' ' + ($ruleErrs) + ' = null; ' + ($valid) + ' = ' + (def_callRuleValidate) + '; ';
      }
    }
  }
  if ($rDef.modifying) {
    out += ' if (' + ($parentData) + ') ' + ($data) + ' = ' + ($parentData) + '[' + ($parentDataProperty) + '];';
  }
  out += '' + ($closingBraces);
  if ($rDef.valid) {
    if ($breakOnError) {
      out += ' if (true) { ';
    }
  } else {
    out += ' if ( ';
    if ($rDef.valid === undefined) {
      out += ' !';
      if ($macro) {
        out += '' + ($nextValid);
      } else {
        out += '' + ($valid);
      }
    } else {
      out += ' ' + (!$rDef.valid) + ' ';
    }
    out += ') { ';
    $errorKeyword = $rule.keyword;
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = '';
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = ''; /* istanbul ignore else */
    if (it.createErrors !== false) {
      out += ' { keyword: \'' + ($errorKeyword || 'custom') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { keyword: \'' + ($rule.keyword) + '\' } ';
      if (it.opts.messages !== false) {
        out += ' , message: \'should pass "' + ($rule.keyword) + '" keyword validation\' ';
      }
      if (it.opts.verbose) {
        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
      }
      out += ' } ';
    } else {
      out += ' {} ';
    }
    var __err = out;
    out = $$outStack.pop();
    if (!it.compositeRule && $breakOnError) {
      /* istanbul ignore if */
      if (it.async) {
        out += ' throw new ValidationError([' + (__err) + ']); ';
      } else {
        out += ' validate.errors = [' + (__err) + ']; return false; ';
      }
    } else {
      out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
    }
    var def_customError = out;
    out = $$outStack.pop();
    if ($inline) {
      if ($rDef.errors) {
        if ($rDef.errors != 'full') {
          out += '  for (var ' + ($i) + '=' + ($errs) + '; ' + ($i) + '<errors; ' + ($i) + '++) { var ' + ($ruleErr) + ' = vErrors[' + ($i) + ']; if (' + ($ruleErr) + '.dataPath === undefined) ' + ($ruleErr) + '.dataPath = (dataPath || \'\') + ' + (it.errorPath) + '; if (' + ($ruleErr) + '.schemaPath === undefined) { ' + ($ruleErr) + '.schemaPath = "' + ($errSchemaPath) + '"; } ';
          if (it.opts.verbose) {
            out += ' ' + ($ruleErr) + '.schema = ' + ($schemaValue) + '; ' + ($ruleErr) + '.data = ' + ($data) + '; ';
          }
          out += ' } ';
        }
      } else {
        if ($rDef.errors === false) {
          out += ' ' + (def_customError) + ' ';
        } else {
          out += ' if (' + ($errs) + ' == errors) { ' + (def_customError) + ' } else {  for (var ' + ($i) + '=' + ($errs) + '; ' + ($i) + '<errors; ' + ($i) + '++) { var ' + ($ruleErr) + ' = vErrors[' + ($i) + ']; if (' + ($ruleErr) + '.dataPath === undefined) ' + ($ruleErr) + '.dataPath = (dataPath || \'\') + ' + (it.errorPath) + '; if (' + ($ruleErr) + '.schemaPath === undefined) { ' + ($ruleErr) + '.schemaPath = "' + ($errSchemaPath) + '"; } ';
          if (it.opts.verbose) {
            out += ' ' + ($ruleErr) + '.schema = ' + ($schemaValue) + '; ' + ($ruleErr) + '.data = ' + ($data) + '; ';
          }
          out += ' } } ';
        }
      }
    } else if ($macro) {
      out += '   var err =   '; /* istanbul ignore else */
      if (it.createErrors !== false) {
        out += ' { keyword: \'' + ($errorKeyword || 'custom') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { keyword: \'' + ($rule.keyword) + '\' } ';
        if (it.opts.messages !== false) {
          out += ' , message: \'should pass "' + ($rule.keyword) + '" keyword validation\' ';
        }
        if (it.opts.verbose) {
          out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
        }
        out += ' } ';
      } else {
        out += ' {} ';
      }
      out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
      if (!it.compositeRule && $breakOnError) {
        /* istanbul ignore if */
        if (it.async) {
          out += ' throw new ValidationError(vErrors); ';
        } else {
          out += ' validate.errors = vErrors; return false; ';
        }
      }
    } else {
      if ($rDef.errors === false) {
        out += ' ' + (def_customError) + ' ';
      } else {
        out += ' if (Array.isArray(' + ($ruleErrs) + ')) { if (vErrors === null) vErrors = ' + ($ruleErrs) + '; else vErrors = vErrors.concat(' + ($ruleErrs) + '); errors = vErrors.length;  for (var ' + ($i) + '=' + ($errs) + '; ' + ($i) + '<errors; ' + ($i) + '++) { var ' + ($ruleErr) + ' = vErrors[' + ($i) + ']; if (' + ($ruleErr) + '.dataPath === undefined) ' + ($ruleErr) + '.dataPath = (dataPath || \'\') + ' + (it.errorPath) + ';  ' + ($ruleErr) + '.schemaPath = "' + ($errSchemaPath) + '";  ';
        if (it.opts.verbose) {
          out += ' ' + ($ruleErr) + '.schema = ' + ($schemaValue) + '; ' + ($ruleErr) + '.data = ' + ($data) + '; ';
        }
        out += ' } } else { ' + (def_customError) + ' } ';
      }
    }
    out += ' } ';
    if ($breakOnError) {
      out += ' else { ';
    }
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\custom.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\dependencies.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5Cdependencies.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate_dependencies(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $errs = 'errs__' + $lvl;
  var $it = it.util.copy(it);
  var $closingBraces = '';
  $it.level++;
  var $nextValid = 'valid' + $it.level;
  var $schemaDeps = {},
    $propertyDeps = {},
    $ownProperties = it.opts.ownProperties;
  for ($property in $schema) {
    if ($property == '__proto__') continue;
    var $sch = $schema[$property];
    var $deps = Array.isArray($sch) ? $propertyDeps : $schemaDeps;
    $deps[$property] = $sch;
  }
  out += 'var ' + ($errs) + ' = errors;';
  var $currentErrorPath = it.errorPath;
  out += 'var missing' + ($lvl) + ';';
  for (var $property in $propertyDeps) {
    $deps = $propertyDeps[$property];
    if ($deps.length) {
      out += ' if ( ' + ($data) + (it.util.getProperty($property)) + ' !== undefined ';
      if ($ownProperties) {
        out += ' && Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($property)) + '\') ';
      }
      if ($breakOnError) {
        out += ' && ( ';
        var arr1 = $deps;
        if (arr1) {
          var $propertyKey, $i = -1,
            l1 = arr1.length - 1;
          while ($i < l1) {
            $propertyKey = arr1[$i += 1];
            if ($i) {
              out += ' || ';
            }
            var $prop = it.util.getProperty($propertyKey),
              $useData = $data + $prop;
            out += ' ( ( ' + ($useData) + ' === undefined ';
            if ($ownProperties) {
              out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
            }
            out += ') && (missing' + ($lvl) + ' = ' + (it.util.toQuotedString(it.opts.jsonPointers ? $propertyKey : $prop)) + ') ) ';
          }
        }
        out += ')) {  ';
        var $propertyPath = 'missing' + $lvl,
          $missingProperty = '\' + ' + $propertyPath + ' + \'';
        if (it.opts._errorDataPathProperty) {
          it.errorPath = it.opts.jsonPointers ? it.util.getPathExpr($currentErrorPath, $propertyPath, true) : $currentErrorPath + ' + ' + $propertyPath;
        }
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = ''; /* istanbul ignore else */
        if (it.createErrors !== false) {
          out += ' { keyword: \'' + ('dependencies') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { property: \'' + (it.util.escapeQuotes($property)) + '\', missingProperty: \'' + ($missingProperty) + '\', depsCount: ' + ($deps.length) + ', deps: \'' + (it.util.escapeQuotes($deps.length == 1 ? $deps[0] : $deps.join(", "))) + '\' } ';
          if (it.opts.messages !== false) {
            out += ' , message: \'should have ';
            if ($deps.length == 1) {
              out += 'property ' + (it.util.escapeQuotes($deps[0]));
            } else {
              out += 'properties ' + (it.util.escapeQuotes($deps.join(", ")));
            }
            out += ' when property ' + (it.util.escapeQuotes($property)) + ' is present\' ';
          }
          if (it.opts.verbose) {
            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
          }
          out += ' } ';
        } else {
          out += ' {} ';
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          /* istanbul ignore if */
          if (it.async) {
            out += ' throw new ValidationError([' + (__err) + ']); ';
          } else {
            out += ' validate.errors = [' + (__err) + ']; return false; ';
          }
        } else {
          out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        }
      } else {
        out += ' ) { ';
        var arr2 = $deps;
        if (arr2) {
          var $propertyKey, i2 = -1,
            l2 = arr2.length - 1;
          while (i2 < l2) {
            $propertyKey = arr2[i2 += 1];
            var $prop = it.util.getProperty($propertyKey),
              $missingProperty = it.util.escapeQuotes($propertyKey),
              $useData = $data + $prop;
            if (it.opts._errorDataPathProperty) {
              it.errorPath = it.util.getPath($currentErrorPath, $propertyKey, it.opts.jsonPointers);
            }
            out += ' if ( ' + ($useData) + ' === undefined ';
            if ($ownProperties) {
              out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
            }
            out += ') {  var err =   '; /* istanbul ignore else */
            if (it.createErrors !== false) {
              out += ' { keyword: \'' + ('dependencies') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { property: \'' + (it.util.escapeQuotes($property)) + '\', missingProperty: \'' + ($missingProperty) + '\', depsCount: ' + ($deps.length) + ', deps: \'' + (it.util.escapeQuotes($deps.length == 1 ? $deps[0] : $deps.join(", "))) + '\' } ';
              if (it.opts.messages !== false) {
                out += ' , message: \'should have ';
                if ($deps.length == 1) {
                  out += 'property ' + (it.util.escapeQuotes($deps[0]));
                } else {
                  out += 'properties ' + (it.util.escapeQuotes($deps.join(", ")));
                }
                out += ' when property ' + (it.util.escapeQuotes($property)) + ' is present\' ';
              }
              if (it.opts.verbose) {
                out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
              }
              out += ' } ';
            } else {
              out += ' {} ';
            }
            out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } ';
          }
        }
      }
      out += ' }   ';
      if ($breakOnError) {
        $closingBraces += '}';
        out += ' else { ';
      }
    }
  }
  it.errorPath = $currentErrorPath;
  var $currentBaseId = $it.baseId;
  for (var $property in $schemaDeps) {
    var $sch = $schemaDeps[$property];
    if ((it.opts.strictKeywords ? (typeof $sch == 'object' && Object.keys($sch).length > 0) || $sch === false : it.util.schemaHasRules($sch, it.RULES.all))) {
      out += ' ' + ($nextValid) + ' = true; if ( ' + ($data) + (it.util.getProperty($property)) + ' !== undefined ';
      if ($ownProperties) {
        out += ' && Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($property)) + '\') ';
      }
      out += ') { ';
      $it.schema = $sch;
      $it.schemaPath = $schemaPath + it.util.getProperty($property);
      $it.errSchemaPath = $errSchemaPath + '/' + it.util.escapeFragment($property);
      out += '  ' + (it.validate($it)) + ' ';
      $it.baseId = $currentBaseId;
      out += ' }  ';
      if ($breakOnError) {
        out += ' if (' + ($nextValid) + ') { ';
        $closingBraces += '}';
      }
    }
  }
  if ($breakOnError) {
    out += '   ' + ($closingBraces) + ' if (' + ($errs) + ' == errors) {';
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\dependencies.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\enum.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5Cenum.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate_enum(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $valid = 'valid' + $lvl;
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  var $i = 'i' + $lvl,
    $vSchema = 'schema' + $lvl;
  if (!$isData) {
    out += ' var ' + ($vSchema) + ' = validate.schema' + ($schemaPath) + ';';
  }
  out += 'var ' + ($valid) + ';';
  if ($isData) {
    out += ' if (schema' + ($lvl) + ' === undefined) ' + ($valid) + ' = true; else if (!Array.isArray(schema' + ($lvl) + ')) ' + ($valid) + ' = false; else {';
  }
  out += '' + ($valid) + ' = false;for (var ' + ($i) + '=0; ' + ($i) + '<' + ($vSchema) + '.length; ' + ($i) + '++) if (equal(' + ($data) + ', ' + ($vSchema) + '[' + ($i) + '])) { ' + ($valid) + ' = true; break; }';
  if ($isData) {
    out += '  }  ';
  }
  out += ' if (!' + ($valid) + ') {   ';
  var $$outStack = $$outStack || [];
  $$outStack.push(out);
  out = ''; /* istanbul ignore else */
  if (it.createErrors !== false) {
    out += ' { keyword: \'' + ('enum') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { allowedValues: schema' + ($lvl) + ' } ';
    if (it.opts.messages !== false) {
      out += ' , message: \'should be equal to one of the allowed values\' ';
    }
    if (it.opts.verbose) {
      out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
    }
    out += ' } ';
  } else {
    out += ' {} ';
  }
  var __err = out;
  out = $$outStack.pop();
  if (!it.compositeRule && $breakOnError) {
    /* istanbul ignore if */
    if (it.async) {
      out += ' throw new ValidationError([' + (__err) + ']); ';
    } else {
      out += ' validate.errors = [' + (__err) + ']; return false; ';
    }
  } else {
    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
  }
  out += ' }';
  if ($breakOnError) {
    out += ' else { ';
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\enum.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\format.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5Cformat.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate_format(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  if (it.opts.format === false) {
    if ($breakOnError) {
      out += ' if (true) { ';
    }
    return out;
  }
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  var $unknownFormats = it.opts.unknownFormats,
    $allowUnknown = Array.isArray($unknownFormats);
  if ($isData) {
    var $format = 'format' + $lvl,
      $isObject = 'isObject' + $lvl,
      $formatType = 'formatType' + $lvl;
    out += ' var ' + ($format) + ' = formats[' + ($schemaValue) + ']; var ' + ($isObject) + ' = typeof ' + ($format) + ' == \'object\' && !(' + ($format) + ' instanceof RegExp) && ' + ($format) + '.validate; var ' + ($formatType) + ' = ' + ($isObject) + ' && ' + ($format) + '.type || \'string\'; if (' + ($isObject) + ') { ';
    if (it.async) {
      out += ' var async' + ($lvl) + ' = ' + ($format) + '.async; ';
    }
    out += ' ' + ($format) + ' = ' + ($format) + '.validate; } if (  ';
    if ($isData) {
      out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'string\') || ';
    }
    out += ' (';
    if ($unknownFormats != 'ignore') {
      out += ' (' + ($schemaValue) + ' && !' + ($format) + ' ';
      if ($allowUnknown) {
        out += ' && self._opts.unknownFormats.indexOf(' + ($schemaValue) + ') == -1 ';
      }
      out += ') || ';
    }
    out += ' (' + ($format) + ' && ' + ($formatType) + ' == \'' + ($ruleType) + '\' && !(typeof ' + ($format) + ' == \'function\' ? ';
    if (it.async) {
      out += ' (async' + ($lvl) + ' ? await ' + ($format) + '(' + ($data) + ') : ' + ($format) + '(' + ($data) + ')) ';
    } else {
      out += ' ' + ($format) + '(' + ($data) + ') ';
    }
    out += ' : ' + ($format) + '.test(' + ($data) + '))))) {';
  } else {
    var $format = it.formats[$schema];
    if (!$format) {
      if ($unknownFormats == 'ignore') {
        it.logger.warn('unknown format "' + $schema + '" ignored in schema at path "' + it.errSchemaPath + '"');
        if ($breakOnError) {
          out += ' if (true) { ';
        }
        return out;
      } else if ($allowUnknown && $unknownFormats.indexOf($schema) >= 0) {
        if ($breakOnError) {
          out += ' if (true) { ';
        }
        return out;
      } else {
        throw new Error('unknown format "' + $schema + '" is used in schema at path "' + it.errSchemaPath + '"');
      }
    }
    var $isObject = typeof $format == 'object' && !($format instanceof RegExp) && $format.validate;
    var $formatType = $isObject && $format.type || 'string';
    if ($isObject) {
      var $async = $format.async === true;
      $format = $format.validate;
    }
    if ($formatType != $ruleType) {
      if ($breakOnError) {
        out += ' if (true) { ';
      }
      return out;
    }
    if ($async) {
      if (!it.async) throw new Error('async format in sync schema');
      var $formatRef = 'formats' + it.util.getProperty($schema) + '.validate';
      out += ' if (!(await ' + ($formatRef) + '(' + ($data) + '))) { ';
    } else {
      out += ' if (! ';
      var $formatRef = 'formats' + it.util.getProperty($schema);
      if ($isObject) $formatRef += '.validate';
      if (typeof $format == 'function') {
        out += ' ' + ($formatRef) + '(' + ($data) + ') ';
      } else {
        out += ' ' + ($formatRef) + '.test(' + ($data) + ') ';
      }
      out += ') { ';
    }
  }
  var $$outStack = $$outStack || [];
  $$outStack.push(out);
  out = ''; /* istanbul ignore else */
  if (it.createErrors !== false) {
    out += ' { keyword: \'' + ('format') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { format:  ';
    if ($isData) {
      out += '' + ($schemaValue);
    } else {
      out += '' + (it.util.toQuotedString($schema));
    }
    out += '  } ';
    if (it.opts.messages !== false) {
      out += ' , message: \'should match format "';
      if ($isData) {
        out += '\' + ' + ($schemaValue) + ' + \'';
      } else {
        out += '' + (it.util.escapeQuotes($schema));
      }
      out += '"\' ';
    }
    if (it.opts.verbose) {
      out += ' , schema:  ';
      if ($isData) {
        out += 'validate.schema' + ($schemaPath);
      } else {
        out += '' + (it.util.toQuotedString($schema));
      }
      out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
    }
    out += ' } ';
  } else {
    out += ' {} ';
  }
  var __err = out;
  out = $$outStack.pop();
  if (!it.compositeRule && $breakOnError) {
    /* istanbul ignore if */
    if (it.async) {
      out += ' throw new ValidationError([' + (__err) + ']); ';
    } else {
      out += ' validate.errors = [' + (__err) + ']; return false; ';
    }
  } else {
    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
  }
  out += ' } ';
  if ($breakOnError) {
    out += ' else { ';
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\format.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\if.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5Cif.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate_if(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $valid = 'valid' + $lvl;
  var $errs = 'errs__' + $lvl;
  var $it = it.util.copy(it);
  $it.level++;
  var $nextValid = 'valid' + $it.level;
  var $thenSch = it.schema['then'],
    $elseSch = it.schema['else'],
    $thenPresent = $thenSch !== undefined && (it.opts.strictKeywords ? (typeof $thenSch == 'object' && Object.keys($thenSch).length > 0) || $thenSch === false : it.util.schemaHasRules($thenSch, it.RULES.all)),
    $elsePresent = $elseSch !== undefined && (it.opts.strictKeywords ? (typeof $elseSch == 'object' && Object.keys($elseSch).length > 0) || $elseSch === false : it.util.schemaHasRules($elseSch, it.RULES.all)),
    $currentBaseId = $it.baseId;
  if ($thenPresent || $elsePresent) {
    var $ifClause;
    $it.createErrors = false;
    $it.schema = $schema;
    $it.schemaPath = $schemaPath;
    $it.errSchemaPath = $errSchemaPath;
    out += ' var ' + ($errs) + ' = errors; var ' + ($valid) + ' = true;  ';
    var $wasComposite = it.compositeRule;
    it.compositeRule = $it.compositeRule = true;
    out += '  ' + (it.validate($it)) + ' ';
    $it.baseId = $currentBaseId;
    $it.createErrors = true;
    out += '  errors = ' + ($errs) + '; if (vErrors !== null) { if (' + ($errs) + ') vErrors.length = ' + ($errs) + '; else vErrors = null; }  ';
    it.compositeRule = $it.compositeRule = $wasComposite;
    if ($thenPresent) {
      out += ' if (' + ($nextValid) + ') {  ';
      $it.schema = it.schema['then'];
      $it.schemaPath = it.schemaPath + '.then';
      $it.errSchemaPath = it.errSchemaPath + '/then';
      out += '  ' + (it.validate($it)) + ' ';
      $it.baseId = $currentBaseId;
      out += ' ' + ($valid) + ' = ' + ($nextValid) + '; ';
      if ($thenPresent && $elsePresent) {
        $ifClause = 'ifClause' + $lvl;
        out += ' var ' + ($ifClause) + ' = \'then\'; ';
      } else {
        $ifClause = '\'then\'';
      }
      out += ' } ';
      if ($elsePresent) {
        out += ' else { ';
      }
    } else {
      out += ' if (!' + ($nextValid) + ') { ';
    }
    if ($elsePresent) {
      $it.schema = it.schema['else'];
      $it.schemaPath = it.schemaPath + '.else';
      $it.errSchemaPath = it.errSchemaPath + '/else';
      out += '  ' + (it.validate($it)) + ' ';
      $it.baseId = $currentBaseId;
      out += ' ' + ($valid) + ' = ' + ($nextValid) + '; ';
      if ($thenPresent && $elsePresent) {
        $ifClause = 'ifClause' + $lvl;
        out += ' var ' + ($ifClause) + ' = \'else\'; ';
      } else {
        $ifClause = '\'else\'';
      }
      out += ' } ';
    }
    out += ' if (!' + ($valid) + ') {   var err =   '; /* istanbul ignore else */
    if (it.createErrors !== false) {
      out += ' { keyword: \'' + ('if') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { failingKeyword: ' + ($ifClause) + ' } ';
      if (it.opts.messages !== false) {
        out += ' , message: \'should match "\' + ' + ($ifClause) + ' + \'" schema\' ';
      }
      if (it.opts.verbose) {
        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
      }
      out += ' } ';
    } else {
      out += ' {} ';
    }
    out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
    if (!it.compositeRule && $breakOnError) {
      /* istanbul ignore if */
      if (it.async) {
        out += ' throw new ValidationError(vErrors); ';
      } else {
        out += ' validate.errors = vErrors; return false; ';
      }
    }
    out += ' }   ';
    if ($breakOnError) {
      out += ' else { ';
    }
  } else {
    if ($breakOnError) {
      out += ' if (true) { ';
    }
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\if.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\index.js", {"./_limit":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\_limit.js","./_limitItems":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\_limitItems.js","./_limitLength":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\_limitLength.js","./_limitProperties":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\_limitProperties.js","./allOf":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\allOf.js","./anyOf":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\anyOf.js","./comment":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\comment.js","./const":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\const.js","./contains":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\contains.js","./dependencies":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\dependencies.js","./enum":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\enum.js","./format":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\format.js","./if":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\if.js","./items":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\items.js","./multipleOf":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\multipleOf.js","./not":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\not.js","./oneOf":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\oneOf.js","./pattern":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\pattern.js","./properties":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\properties.js","./propertyNames":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\propertyNames.js","./ref":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\ref.js","./required":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\required.js","./uniqueItems":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\uniqueItems.js","./validate":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\validate.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5Cindex.js
      return function (require, module, exports) {
'use strict';

//all requires must be explicit because browserify won't work with dynamic requires
module.exports = {
  '$ref': require('./ref'),
  allOf: require('./allOf'),
  anyOf: require('./anyOf'),
  '$comment': require('./comment'),
  const: require('./const'),
  contains: require('./contains'),
  dependencies: require('./dependencies'),
  'enum': require('./enum'),
  format: require('./format'),
  'if': require('./if'),
  items: require('./items'),
  maximum: require('./_limit'),
  minimum: require('./_limit'),
  maxItems: require('./_limitItems'),
  minItems: require('./_limitItems'),
  maxLength: require('./_limitLength'),
  minLength: require('./_limitLength'),
  maxProperties: require('./_limitProperties'),
  minProperties: require('./_limitProperties'),
  multipleOf: require('./multipleOf'),
  not: require('./not'),
  oneOf: require('./oneOf'),
  pattern: require('./pattern'),
  properties: require('./properties'),
  propertyNames: require('./propertyNames'),
  required: require('./required'),
  uniqueItems: require('./uniqueItems'),
  validate: require('./validate')
};

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\items.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5Citems.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate_items(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $valid = 'valid' + $lvl;
  var $errs = 'errs__' + $lvl;
  var $it = it.util.copy(it);
  var $closingBraces = '';
  $it.level++;
  var $nextValid = 'valid' + $it.level;
  var $idx = 'i' + $lvl,
    $dataNxt = $it.dataLevel = it.dataLevel + 1,
    $nextData = 'data' + $dataNxt,
    $currentBaseId = it.baseId;
  out += 'var ' + ($errs) + ' = errors;var ' + ($valid) + ';';
  if (Array.isArray($schema)) {
    var $additionalItems = it.schema.additionalItems;
    if ($additionalItems === false) {
      out += ' ' + ($valid) + ' = ' + ($data) + '.length <= ' + ($schema.length) + '; ';
      var $currErrSchemaPath = $errSchemaPath;
      $errSchemaPath = it.errSchemaPath + '/additionalItems';
      out += '  if (!' + ($valid) + ') {   ';
      var $$outStack = $$outStack || [];
      $$outStack.push(out);
      out = ''; /* istanbul ignore else */
      if (it.createErrors !== false) {
        out += ' { keyword: \'' + ('additionalItems') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { limit: ' + ($schema.length) + ' } ';
        if (it.opts.messages !== false) {
          out += ' , message: \'should NOT have more than ' + ($schema.length) + ' items\' ';
        }
        if (it.opts.verbose) {
          out += ' , schema: false , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
        }
        out += ' } ';
      } else {
        out += ' {} ';
      }
      var __err = out;
      out = $$outStack.pop();
      if (!it.compositeRule && $breakOnError) {
        /* istanbul ignore if */
        if (it.async) {
          out += ' throw new ValidationError([' + (__err) + ']); ';
        } else {
          out += ' validate.errors = [' + (__err) + ']; return false; ';
        }
      } else {
        out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
      }
      out += ' } ';
      $errSchemaPath = $currErrSchemaPath;
      if ($breakOnError) {
        $closingBraces += '}';
        out += ' else { ';
      }
    }
    var arr1 = $schema;
    if (arr1) {
      var $sch, $i = -1,
        l1 = arr1.length - 1;
      while ($i < l1) {
        $sch = arr1[$i += 1];
        if ((it.opts.strictKeywords ? (typeof $sch == 'object' && Object.keys($sch).length > 0) || $sch === false : it.util.schemaHasRules($sch, it.RULES.all))) {
          out += ' ' + ($nextValid) + ' = true; if (' + ($data) + '.length > ' + ($i) + ') { ';
          var $passData = $data + '[' + $i + ']';
          $it.schema = $sch;
          $it.schemaPath = $schemaPath + '[' + $i + ']';
          $it.errSchemaPath = $errSchemaPath + '/' + $i;
          $it.errorPath = it.util.getPathExpr(it.errorPath, $i, it.opts.jsonPointers, true);
          $it.dataPathArr[$dataNxt] = $i;
          var $code = it.validate($it);
          $it.baseId = $currentBaseId;
          if (it.util.varOccurences($code, $nextData) < 2) {
            out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
          } else {
            out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
          }
          out += ' }  ';
          if ($breakOnError) {
            out += ' if (' + ($nextValid) + ') { ';
            $closingBraces += '}';
          }
        }
      }
    }
    if (typeof $additionalItems == 'object' && (it.opts.strictKeywords ? (typeof $additionalItems == 'object' && Object.keys($additionalItems).length > 0) || $additionalItems === false : it.util.schemaHasRules($additionalItems, it.RULES.all))) {
      $it.schema = $additionalItems;
      $it.schemaPath = it.schemaPath + '.additionalItems';
      $it.errSchemaPath = it.errSchemaPath + '/additionalItems';
      out += ' ' + ($nextValid) + ' = true; if (' + ($data) + '.length > ' + ($schema.length) + ') {  for (var ' + ($idx) + ' = ' + ($schema.length) + '; ' + ($idx) + ' < ' + ($data) + '.length; ' + ($idx) + '++) { ';
      $it.errorPath = it.util.getPathExpr(it.errorPath, $idx, it.opts.jsonPointers, true);
      var $passData = $data + '[' + $idx + ']';
      $it.dataPathArr[$dataNxt] = $idx;
      var $code = it.validate($it);
      $it.baseId = $currentBaseId;
      if (it.util.varOccurences($code, $nextData) < 2) {
        out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
      } else {
        out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
      }
      if ($breakOnError) {
        out += ' if (!' + ($nextValid) + ') break; ';
      }
      out += ' } }  ';
      if ($breakOnError) {
        out += ' if (' + ($nextValid) + ') { ';
        $closingBraces += '}';
      }
    }
  } else if ((it.opts.strictKeywords ? (typeof $schema == 'object' && Object.keys($schema).length > 0) || $schema === false : it.util.schemaHasRules($schema, it.RULES.all))) {
    $it.schema = $schema;
    $it.schemaPath = $schemaPath;
    $it.errSchemaPath = $errSchemaPath;
    out += '  for (var ' + ($idx) + ' = ' + (0) + '; ' + ($idx) + ' < ' + ($data) + '.length; ' + ($idx) + '++) { ';
    $it.errorPath = it.util.getPathExpr(it.errorPath, $idx, it.opts.jsonPointers, true);
    var $passData = $data + '[' + $idx + ']';
    $it.dataPathArr[$dataNxt] = $idx;
    var $code = it.validate($it);
    $it.baseId = $currentBaseId;
    if (it.util.varOccurences($code, $nextData) < 2) {
      out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
    } else {
      out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
    }
    if ($breakOnError) {
      out += ' if (!' + ($nextValid) + ') break; ';
    }
    out += ' }';
  }
  if ($breakOnError) {
    out += ' ' + ($closingBraces) + ' if (' + ($errs) + ' == errors) {';
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\items.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\multipleOf.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5CmultipleOf.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate_multipleOf(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  if (!($isData || typeof $schema == 'number')) {
    throw new Error($keyword + ' must be number');
  }
  out += 'var division' + ($lvl) + ';if (';
  if ($isData) {
    out += ' ' + ($schemaValue) + ' !== undefined && ( typeof ' + ($schemaValue) + ' != \'number\' || ';
  }
  out += ' (division' + ($lvl) + ' = ' + ($data) + ' / ' + ($schemaValue) + ', ';
  if (it.opts.multipleOfPrecision) {
    out += ' Math.abs(Math.round(division' + ($lvl) + ') - division' + ($lvl) + ') > 1e-' + (it.opts.multipleOfPrecision) + ' ';
  } else {
    out += ' division' + ($lvl) + ' !== parseInt(division' + ($lvl) + ') ';
  }
  out += ' ) ';
  if ($isData) {
    out += '  )  ';
  }
  out += ' ) {   ';
  var $$outStack = $$outStack || [];
  $$outStack.push(out);
  out = ''; /* istanbul ignore else */
  if (it.createErrors !== false) {
    out += ' { keyword: \'' + ('multipleOf') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { multipleOf: ' + ($schemaValue) + ' } ';
    if (it.opts.messages !== false) {
      out += ' , message: \'should be multiple of ';
      if ($isData) {
        out += '\' + ' + ($schemaValue);
      } else {
        out += '' + ($schemaValue) + '\'';
      }
    }
    if (it.opts.verbose) {
      out += ' , schema:  ';
      if ($isData) {
        out += 'validate.schema' + ($schemaPath);
      } else {
        out += '' + ($schema);
      }
      out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
    }
    out += ' } ';
  } else {
    out += ' {} ';
  }
  var __err = out;
  out = $$outStack.pop();
  if (!it.compositeRule && $breakOnError) {
    /* istanbul ignore if */
    if (it.async) {
      out += ' throw new ValidationError([' + (__err) + ']); ';
    } else {
      out += ' validate.errors = [' + (__err) + ']; return false; ';
    }
  } else {
    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
  }
  out += '} ';
  if ($breakOnError) {
    out += ' else { ';
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\multipleOf.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\not.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5Cnot.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate_not(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $errs = 'errs__' + $lvl;
  var $it = it.util.copy(it);
  $it.level++;
  var $nextValid = 'valid' + $it.level;
  if ((it.opts.strictKeywords ? (typeof $schema == 'object' && Object.keys($schema).length > 0) || $schema === false : it.util.schemaHasRules($schema, it.RULES.all))) {
    $it.schema = $schema;
    $it.schemaPath = $schemaPath;
    $it.errSchemaPath = $errSchemaPath;
    out += ' var ' + ($errs) + ' = errors;  ';
    var $wasComposite = it.compositeRule;
    it.compositeRule = $it.compositeRule = true;
    $it.createErrors = false;
    var $allErrorsOption;
    if ($it.opts.allErrors) {
      $allErrorsOption = $it.opts.allErrors;
      $it.opts.allErrors = false;
    }
    out += ' ' + (it.validate($it)) + ' ';
    $it.createErrors = true;
    if ($allErrorsOption) $it.opts.allErrors = $allErrorsOption;
    it.compositeRule = $it.compositeRule = $wasComposite;
    out += ' if (' + ($nextValid) + ') {   ';
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = ''; /* istanbul ignore else */
    if (it.createErrors !== false) {
      out += ' { keyword: \'' + ('not') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
      if (it.opts.messages !== false) {
        out += ' , message: \'should NOT be valid\' ';
      }
      if (it.opts.verbose) {
        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
      }
      out += ' } ';
    } else {
      out += ' {} ';
    }
    var __err = out;
    out = $$outStack.pop();
    if (!it.compositeRule && $breakOnError) {
      /* istanbul ignore if */
      if (it.async) {
        out += ' throw new ValidationError([' + (__err) + ']); ';
      } else {
        out += ' validate.errors = [' + (__err) + ']; return false; ';
      }
    } else {
      out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
    }
    out += ' } else {  errors = ' + ($errs) + '; if (vErrors !== null) { if (' + ($errs) + ') vErrors.length = ' + ($errs) + '; else vErrors = null; } ';
    if (it.opts.allErrors) {
      out += ' } ';
    }
  } else {
    out += '  var err =   '; /* istanbul ignore else */
    if (it.createErrors !== false) {
      out += ' { keyword: \'' + ('not') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
      if (it.opts.messages !== false) {
        out += ' , message: \'should NOT be valid\' ';
      }
      if (it.opts.verbose) {
        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
      }
      out += ' } ';
    } else {
      out += ' {} ';
    }
    out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
    if ($breakOnError) {
      out += ' if (false) { ';
    }
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\not.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\oneOf.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5ConeOf.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate_oneOf(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $valid = 'valid' + $lvl;
  var $errs = 'errs__' + $lvl;
  var $it = it.util.copy(it);
  var $closingBraces = '';
  $it.level++;
  var $nextValid = 'valid' + $it.level;
  var $currentBaseId = $it.baseId,
    $prevValid = 'prevValid' + $lvl,
    $passingSchemas = 'passingSchemas' + $lvl;
  out += 'var ' + ($errs) + ' = errors , ' + ($prevValid) + ' = false , ' + ($valid) + ' = false , ' + ($passingSchemas) + ' = null; ';
  var $wasComposite = it.compositeRule;
  it.compositeRule = $it.compositeRule = true;
  var arr1 = $schema;
  if (arr1) {
    var $sch, $i = -1,
      l1 = arr1.length - 1;
    while ($i < l1) {
      $sch = arr1[$i += 1];
      if ((it.opts.strictKeywords ? (typeof $sch == 'object' && Object.keys($sch).length > 0) || $sch === false : it.util.schemaHasRules($sch, it.RULES.all))) {
        $it.schema = $sch;
        $it.schemaPath = $schemaPath + '[' + $i + ']';
        $it.errSchemaPath = $errSchemaPath + '/' + $i;
        out += '  ' + (it.validate($it)) + ' ';
        $it.baseId = $currentBaseId;
      } else {
        out += ' var ' + ($nextValid) + ' = true; ';
      }
      if ($i) {
        out += ' if (' + ($nextValid) + ' && ' + ($prevValid) + ') { ' + ($valid) + ' = false; ' + ($passingSchemas) + ' = [' + ($passingSchemas) + ', ' + ($i) + ']; } else { ';
        $closingBraces += '}';
      }
      out += ' if (' + ($nextValid) + ') { ' + ($valid) + ' = ' + ($prevValid) + ' = true; ' + ($passingSchemas) + ' = ' + ($i) + '; }';
    }
  }
  it.compositeRule = $it.compositeRule = $wasComposite;
  out += '' + ($closingBraces) + 'if (!' + ($valid) + ') {   var err =   '; /* istanbul ignore else */
  if (it.createErrors !== false) {
    out += ' { keyword: \'' + ('oneOf') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { passingSchemas: ' + ($passingSchemas) + ' } ';
    if (it.opts.messages !== false) {
      out += ' , message: \'should match exactly one schema in oneOf\' ';
    }
    if (it.opts.verbose) {
      out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
    }
    out += ' } ';
  } else {
    out += ' {} ';
  }
  out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
  if (!it.compositeRule && $breakOnError) {
    /* istanbul ignore if */
    if (it.async) {
      out += ' throw new ValidationError(vErrors); ';
    } else {
      out += ' validate.errors = vErrors; return false; ';
    }
  }
  out += '} else {  errors = ' + ($errs) + '; if (vErrors !== null) { if (' + ($errs) + ') vErrors.length = ' + ($errs) + '; else vErrors = null; }';
  if (it.opts.allErrors) {
    out += ' } ';
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\oneOf.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\pattern.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5Cpattern.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate_pattern(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  var $regexp = $isData ? '(new RegExp(' + $schemaValue + '))' : it.usePattern($schema);
  out += 'if ( ';
  if ($isData) {
    out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'string\') || ';
  }
  out += ' !' + ($regexp) + '.test(' + ($data) + ') ) {   ';
  var $$outStack = $$outStack || [];
  $$outStack.push(out);
  out = ''; /* istanbul ignore else */
  if (it.createErrors !== false) {
    out += ' { keyword: \'' + ('pattern') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { pattern:  ';
    if ($isData) {
      out += '' + ($schemaValue);
    } else {
      out += '' + (it.util.toQuotedString($schema));
    }
    out += '  } ';
    if (it.opts.messages !== false) {
      out += ' , message: \'should match pattern "';
      if ($isData) {
        out += '\' + ' + ($schemaValue) + ' + \'';
      } else {
        out += '' + (it.util.escapeQuotes($schema));
      }
      out += '"\' ';
    }
    if (it.opts.verbose) {
      out += ' , schema:  ';
      if ($isData) {
        out += 'validate.schema' + ($schemaPath);
      } else {
        out += '' + (it.util.toQuotedString($schema));
      }
      out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
    }
    out += ' } ';
  } else {
    out += ' {} ';
  }
  var __err = out;
  out = $$outStack.pop();
  if (!it.compositeRule && $breakOnError) {
    /* istanbul ignore if */
    if (it.async) {
      out += ' throw new ValidationError([' + (__err) + ']); ';
    } else {
      out += ' validate.errors = [' + (__err) + ']; return false; ';
    }
  } else {
    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
  }
  out += '} ';
  if ($breakOnError) {
    out += ' else { ';
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\pattern.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\properties.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5Cproperties.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate_properties(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $errs = 'errs__' + $lvl;
  var $it = it.util.copy(it);
  var $closingBraces = '';
  $it.level++;
  var $nextValid = 'valid' + $it.level;
  var $key = 'key' + $lvl,
    $idx = 'idx' + $lvl,
    $dataNxt = $it.dataLevel = it.dataLevel + 1,
    $nextData = 'data' + $dataNxt,
    $dataProperties = 'dataProperties' + $lvl;
  var $schemaKeys = Object.keys($schema || {}).filter(notProto),
    $pProperties = it.schema.patternProperties || {},
    $pPropertyKeys = Object.keys($pProperties).filter(notProto),
    $aProperties = it.schema.additionalProperties,
    $someProperties = $schemaKeys.length || $pPropertyKeys.length,
    $noAdditional = $aProperties === false,
    $additionalIsSchema = typeof $aProperties == 'object' && Object.keys($aProperties).length,
    $removeAdditional = it.opts.removeAdditional,
    $checkAdditional = $noAdditional || $additionalIsSchema || $removeAdditional,
    $ownProperties = it.opts.ownProperties,
    $currentBaseId = it.baseId;
  var $required = it.schema.required;
  if ($required && !(it.opts.$data && $required.$data) && $required.length < it.opts.loopRequired) {
    var $requiredHash = it.util.toHash($required);
  }

  function notProto(p) {
    return p !== '__proto__';
  }
  out += 'var ' + ($errs) + ' = errors;var ' + ($nextValid) + ' = true;';
  if ($ownProperties) {
    out += ' var ' + ($dataProperties) + ' = undefined;';
  }
  if ($checkAdditional) {
    if ($ownProperties) {
      out += ' ' + ($dataProperties) + ' = ' + ($dataProperties) + ' || Object.keys(' + ($data) + '); for (var ' + ($idx) + '=0; ' + ($idx) + '<' + ($dataProperties) + '.length; ' + ($idx) + '++) { var ' + ($key) + ' = ' + ($dataProperties) + '[' + ($idx) + ']; ';
    } else {
      out += ' for (var ' + ($key) + ' in ' + ($data) + ') { ';
    }
    if ($someProperties) {
      out += ' var isAdditional' + ($lvl) + ' = !(false ';
      if ($schemaKeys.length) {
        if ($schemaKeys.length > 8) {
          out += ' || validate.schema' + ($schemaPath) + '.hasOwnProperty(' + ($key) + ') ';
        } else {
          var arr1 = $schemaKeys;
          if (arr1) {
            var $propertyKey, i1 = -1,
              l1 = arr1.length - 1;
            while (i1 < l1) {
              $propertyKey = arr1[i1 += 1];
              out += ' || ' + ($key) + ' == ' + (it.util.toQuotedString($propertyKey)) + ' ';
            }
          }
        }
      }
      if ($pPropertyKeys.length) {
        var arr2 = $pPropertyKeys;
        if (arr2) {
          var $pProperty, $i = -1,
            l2 = arr2.length - 1;
          while ($i < l2) {
            $pProperty = arr2[$i += 1];
            out += ' || ' + (it.usePattern($pProperty)) + '.test(' + ($key) + ') ';
          }
        }
      }
      out += ' ); if (isAdditional' + ($lvl) + ') { ';
    }
    if ($removeAdditional == 'all') {
      out += ' delete ' + ($data) + '[' + ($key) + ']; ';
    } else {
      var $currentErrorPath = it.errorPath;
      var $additionalProperty = '\' + ' + $key + ' + \'';
      if (it.opts._errorDataPathProperty) {
        it.errorPath = it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
      }
      if ($noAdditional) {
        if ($removeAdditional) {
          out += ' delete ' + ($data) + '[' + ($key) + ']; ';
        } else {
          out += ' ' + ($nextValid) + ' = false; ';
          var $currErrSchemaPath = $errSchemaPath;
          $errSchemaPath = it.errSchemaPath + '/additionalProperties';
          var $$outStack = $$outStack || [];
          $$outStack.push(out);
          out = ''; /* istanbul ignore else */
          if (it.createErrors !== false) {
            out += ' { keyword: \'' + ('additionalProperties') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { additionalProperty: \'' + ($additionalProperty) + '\' } ';
            if (it.opts.messages !== false) {
              out += ' , message: \'';
              if (it.opts._errorDataPathProperty) {
                out += 'is an invalid additional property';
              } else {
                out += 'should NOT have additional properties';
              }
              out += '\' ';
            }
            if (it.opts.verbose) {
              out += ' , schema: false , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
            }
            out += ' } ';
          } else {
            out += ' {} ';
          }
          var __err = out;
          out = $$outStack.pop();
          if (!it.compositeRule && $breakOnError) {
            /* istanbul ignore if */
            if (it.async) {
              out += ' throw new ValidationError([' + (__err) + ']); ';
            } else {
              out += ' validate.errors = [' + (__err) + ']; return false; ';
            }
          } else {
            out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
          }
          $errSchemaPath = $currErrSchemaPath;
          if ($breakOnError) {
            out += ' break; ';
          }
        }
      } else if ($additionalIsSchema) {
        if ($removeAdditional == 'failing') {
          out += ' var ' + ($errs) + ' = errors;  ';
          var $wasComposite = it.compositeRule;
          it.compositeRule = $it.compositeRule = true;
          $it.schema = $aProperties;
          $it.schemaPath = it.schemaPath + '.additionalProperties';
          $it.errSchemaPath = it.errSchemaPath + '/additionalProperties';
          $it.errorPath = it.opts._errorDataPathProperty ? it.errorPath : it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
          var $passData = $data + '[' + $key + ']';
          $it.dataPathArr[$dataNxt] = $key;
          var $code = it.validate($it);
          $it.baseId = $currentBaseId;
          if (it.util.varOccurences($code, $nextData) < 2) {
            out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
          } else {
            out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
          }
          out += ' if (!' + ($nextValid) + ') { errors = ' + ($errs) + '; if (validate.errors !== null) { if (errors) validate.errors.length = errors; else validate.errors = null; } delete ' + ($data) + '[' + ($key) + ']; }  ';
          it.compositeRule = $it.compositeRule = $wasComposite;
        } else {
          $it.schema = $aProperties;
          $it.schemaPath = it.schemaPath + '.additionalProperties';
          $it.errSchemaPath = it.errSchemaPath + '/additionalProperties';
          $it.errorPath = it.opts._errorDataPathProperty ? it.errorPath : it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
          var $passData = $data + '[' + $key + ']';
          $it.dataPathArr[$dataNxt] = $key;
          var $code = it.validate($it);
          $it.baseId = $currentBaseId;
          if (it.util.varOccurences($code, $nextData) < 2) {
            out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
          } else {
            out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
          }
          if ($breakOnError) {
            out += ' if (!' + ($nextValid) + ') break; ';
          }
        }
      }
      it.errorPath = $currentErrorPath;
    }
    if ($someProperties) {
      out += ' } ';
    }
    out += ' }  ';
    if ($breakOnError) {
      out += ' if (' + ($nextValid) + ') { ';
      $closingBraces += '}';
    }
  }
  var $useDefaults = it.opts.useDefaults && !it.compositeRule;
  if ($schemaKeys.length) {
    var arr3 = $schemaKeys;
    if (arr3) {
      var $propertyKey, i3 = -1,
        l3 = arr3.length - 1;
      while (i3 < l3) {
        $propertyKey = arr3[i3 += 1];
        var $sch = $schema[$propertyKey];
        if ((it.opts.strictKeywords ? (typeof $sch == 'object' && Object.keys($sch).length > 0) || $sch === false : it.util.schemaHasRules($sch, it.RULES.all))) {
          var $prop = it.util.getProperty($propertyKey),
            $passData = $data + $prop,
            $hasDefault = $useDefaults && $sch.default !== undefined;
          $it.schema = $sch;
          $it.schemaPath = $schemaPath + $prop;
          $it.errSchemaPath = $errSchemaPath + '/' + it.util.escapeFragment($propertyKey);
          $it.errorPath = it.util.getPath(it.errorPath, $propertyKey, it.opts.jsonPointers);
          $it.dataPathArr[$dataNxt] = it.util.toQuotedString($propertyKey);
          var $code = it.validate($it);
          $it.baseId = $currentBaseId;
          if (it.util.varOccurences($code, $nextData) < 2) {
            $code = it.util.varReplace($code, $nextData, $passData);
            var $useData = $passData;
          } else {
            var $useData = $nextData;
            out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ';
          }
          if ($hasDefault) {
            out += ' ' + ($code) + ' ';
          } else {
            if ($requiredHash && $requiredHash[$propertyKey]) {
              out += ' if ( ' + ($useData) + ' === undefined ';
              if ($ownProperties) {
                out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
              }
              out += ') { ' + ($nextValid) + ' = false; ';
              var $currentErrorPath = it.errorPath,
                $currErrSchemaPath = $errSchemaPath,
                $missingProperty = it.util.escapeQuotes($propertyKey);
              if (it.opts._errorDataPathProperty) {
                it.errorPath = it.util.getPath($currentErrorPath, $propertyKey, it.opts.jsonPointers);
              }
              $errSchemaPath = it.errSchemaPath + '/required';
              var $$outStack = $$outStack || [];
              $$outStack.push(out);
              out = ''; /* istanbul ignore else */
              if (it.createErrors !== false) {
                out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
                if (it.opts.messages !== false) {
                  out += ' , message: \'';
                  if (it.opts._errorDataPathProperty) {
                    out += 'is a required property';
                  } else {
                    out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
                  }
                  out += '\' ';
                }
                if (it.opts.verbose) {
                  out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                }
                out += ' } ';
              } else {
                out += ' {} ';
              }
              var __err = out;
              out = $$outStack.pop();
              if (!it.compositeRule && $breakOnError) {
                /* istanbul ignore if */
                if (it.async) {
                  out += ' throw new ValidationError([' + (__err) + ']); ';
                } else {
                  out += ' validate.errors = [' + (__err) + ']; return false; ';
                }
              } else {
                out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
              }
              $errSchemaPath = $currErrSchemaPath;
              it.errorPath = $currentErrorPath;
              out += ' } else { ';
            } else {
              if ($breakOnError) {
                out += ' if ( ' + ($useData) + ' === undefined ';
                if ($ownProperties) {
                  out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
                }
                out += ') { ' + ($nextValid) + ' = true; } else { ';
              } else {
                out += ' if (' + ($useData) + ' !== undefined ';
                if ($ownProperties) {
                  out += ' &&   Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
                }
                out += ' ) { ';
              }
            }
            out += ' ' + ($code) + ' } ';
          }
        }
        if ($breakOnError) {
          out += ' if (' + ($nextValid) + ') { ';
          $closingBraces += '}';
        }
      }
    }
  }
  if ($pPropertyKeys.length) {
    var arr4 = $pPropertyKeys;
    if (arr4) {
      var $pProperty, i4 = -1,
        l4 = arr4.length - 1;
      while (i4 < l4) {
        $pProperty = arr4[i4 += 1];
        var $sch = $pProperties[$pProperty];
        if ((it.opts.strictKeywords ? (typeof $sch == 'object' && Object.keys($sch).length > 0) || $sch === false : it.util.schemaHasRules($sch, it.RULES.all))) {
          $it.schema = $sch;
          $it.schemaPath = it.schemaPath + '.patternProperties' + it.util.getProperty($pProperty);
          $it.errSchemaPath = it.errSchemaPath + '/patternProperties/' + it.util.escapeFragment($pProperty);
          if ($ownProperties) {
            out += ' ' + ($dataProperties) + ' = ' + ($dataProperties) + ' || Object.keys(' + ($data) + '); for (var ' + ($idx) + '=0; ' + ($idx) + '<' + ($dataProperties) + '.length; ' + ($idx) + '++) { var ' + ($key) + ' = ' + ($dataProperties) + '[' + ($idx) + ']; ';
          } else {
            out += ' for (var ' + ($key) + ' in ' + ($data) + ') { ';
          }
          out += ' if (' + (it.usePattern($pProperty)) + '.test(' + ($key) + ')) { ';
          $it.errorPath = it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
          var $passData = $data + '[' + $key + ']';
          $it.dataPathArr[$dataNxt] = $key;
          var $code = it.validate($it);
          $it.baseId = $currentBaseId;
          if (it.util.varOccurences($code, $nextData) < 2) {
            out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
          } else {
            out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
          }
          if ($breakOnError) {
            out += ' if (!' + ($nextValid) + ') break; ';
          }
          out += ' } ';
          if ($breakOnError) {
            out += ' else ' + ($nextValid) + ' = true; ';
          }
          out += ' }  ';
          if ($breakOnError) {
            out += ' if (' + ($nextValid) + ') { ';
            $closingBraces += '}';
          }
        }
      }
    }
  }
  if ($breakOnError) {
    out += ' ' + ($closingBraces) + ' if (' + ($errs) + ' == errors) {';
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\properties.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\propertyNames.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5CpropertyNames.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate_propertyNames(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $errs = 'errs__' + $lvl;
  var $it = it.util.copy(it);
  var $closingBraces = '';
  $it.level++;
  var $nextValid = 'valid' + $it.level;
  out += 'var ' + ($errs) + ' = errors;';
  if ((it.opts.strictKeywords ? (typeof $schema == 'object' && Object.keys($schema).length > 0) || $schema === false : it.util.schemaHasRules($schema, it.RULES.all))) {
    $it.schema = $schema;
    $it.schemaPath = $schemaPath;
    $it.errSchemaPath = $errSchemaPath;
    var $key = 'key' + $lvl,
      $idx = 'idx' + $lvl,
      $i = 'i' + $lvl,
      $invalidName = '\' + ' + $key + ' + \'',
      $dataNxt = $it.dataLevel = it.dataLevel + 1,
      $nextData = 'data' + $dataNxt,
      $dataProperties = 'dataProperties' + $lvl,
      $ownProperties = it.opts.ownProperties,
      $currentBaseId = it.baseId;
    if ($ownProperties) {
      out += ' var ' + ($dataProperties) + ' = undefined; ';
    }
    if ($ownProperties) {
      out += ' ' + ($dataProperties) + ' = ' + ($dataProperties) + ' || Object.keys(' + ($data) + '); for (var ' + ($idx) + '=0; ' + ($idx) + '<' + ($dataProperties) + '.length; ' + ($idx) + '++) { var ' + ($key) + ' = ' + ($dataProperties) + '[' + ($idx) + ']; ';
    } else {
      out += ' for (var ' + ($key) + ' in ' + ($data) + ') { ';
    }
    out += ' var startErrs' + ($lvl) + ' = errors; ';
    var $passData = $key;
    var $wasComposite = it.compositeRule;
    it.compositeRule = $it.compositeRule = true;
    var $code = it.validate($it);
    $it.baseId = $currentBaseId;
    if (it.util.varOccurences($code, $nextData) < 2) {
      out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
    } else {
      out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
    }
    it.compositeRule = $it.compositeRule = $wasComposite;
    out += ' if (!' + ($nextValid) + ') { for (var ' + ($i) + '=startErrs' + ($lvl) + '; ' + ($i) + '<errors; ' + ($i) + '++) { vErrors[' + ($i) + '].propertyName = ' + ($key) + '; }   var err =   '; /* istanbul ignore else */
    if (it.createErrors !== false) {
      out += ' { keyword: \'' + ('propertyNames') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { propertyName: \'' + ($invalidName) + '\' } ';
      if (it.opts.messages !== false) {
        out += ' , message: \'property name \\\'' + ($invalidName) + '\\\' is invalid\' ';
      }
      if (it.opts.verbose) {
        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
      }
      out += ' } ';
    } else {
      out += ' {} ';
    }
    out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
    if (!it.compositeRule && $breakOnError) {
      /* istanbul ignore if */
      if (it.async) {
        out += ' throw new ValidationError(vErrors); ';
      } else {
        out += ' validate.errors = vErrors; return false; ';
      }
    }
    if ($breakOnError) {
      out += ' break; ';
    }
    out += ' } }';
  }
  if ($breakOnError) {
    out += ' ' + ($closingBraces) + ' if (' + ($errs) + ' == errors) {';
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\propertyNames.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\ref.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5Cref.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate_ref(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $valid = 'valid' + $lvl;
  var $async, $refCode;
  if ($schema == '#' || $schema == '#/') {
    if (it.isRoot) {
      $async = it.async;
      $refCode = 'validate';
    } else {
      $async = it.root.schema.$async === true;
      $refCode = 'root.refVal[0]';
    }
  } else {
    var $refVal = it.resolveRef(it.baseId, $schema, it.isRoot);
    if ($refVal === undefined) {
      var $message = it.MissingRefError.message(it.baseId, $schema);
      if (it.opts.missingRefs == 'fail') {
        it.logger.error($message);
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = ''; /* istanbul ignore else */
        if (it.createErrors !== false) {
          out += ' { keyword: \'' + ('$ref') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { ref: \'' + (it.util.escapeQuotes($schema)) + '\' } ';
          if (it.opts.messages !== false) {
            out += ' , message: \'can\\\'t resolve reference ' + (it.util.escapeQuotes($schema)) + '\' ';
          }
          if (it.opts.verbose) {
            out += ' , schema: ' + (it.util.toQuotedString($schema)) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
          }
          out += ' } ';
        } else {
          out += ' {} ';
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          /* istanbul ignore if */
          if (it.async) {
            out += ' throw new ValidationError([' + (__err) + ']); ';
          } else {
            out += ' validate.errors = [' + (__err) + ']; return false; ';
          }
        } else {
          out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        }
        if ($breakOnError) {
          out += ' if (false) { ';
        }
      } else if (it.opts.missingRefs == 'ignore') {
        it.logger.warn($message);
        if ($breakOnError) {
          out += ' if (true) { ';
        }
      } else {
        throw new it.MissingRefError(it.baseId, $schema, $message);
      }
    } else if ($refVal.inline) {
      var $it = it.util.copy(it);
      $it.level++;
      var $nextValid = 'valid' + $it.level;
      $it.schema = $refVal.schema;
      $it.schemaPath = '';
      $it.errSchemaPath = $schema;
      var $code = it.validate($it).replace(/validate\.schema/g, $refVal.code);
      out += ' ' + ($code) + ' ';
      if ($breakOnError) {
        out += ' if (' + ($nextValid) + ') { ';
      }
    } else {
      $async = $refVal.$async === true || (it.async && $refVal.$async !== false);
      $refCode = $refVal.code;
    }
  }
  if ($refCode) {
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = '';
    if (it.opts.passContext) {
      out += ' ' + ($refCode) + '.call(this, ';
    } else {
      out += ' ' + ($refCode) + '( ';
    }
    out += ' ' + ($data) + ', (dataPath || \'\')';
    if (it.errorPath != '""') {
      out += ' + ' + (it.errorPath);
    }
    var $parentData = $dataLvl ? 'data' + (($dataLvl - 1) || '') : 'parentData',
      $parentDataProperty = $dataLvl ? it.dataPathArr[$dataLvl] : 'parentDataProperty';
    out += ' , ' + ($parentData) + ' , ' + ($parentDataProperty) + ', rootData)  ';
    var __callValidate = out;
    out = $$outStack.pop();
    if ($async) {
      if (!it.async) throw new Error('async schema referenced by sync schema');
      if ($breakOnError) {
        out += ' var ' + ($valid) + '; ';
      }
      out += ' try { await ' + (__callValidate) + '; ';
      if ($breakOnError) {
        out += ' ' + ($valid) + ' = true; ';
      }
      out += ' } catch (e) { if (!(e instanceof ValidationError)) throw e; if (vErrors === null) vErrors = e.errors; else vErrors = vErrors.concat(e.errors); errors = vErrors.length; ';
      if ($breakOnError) {
        out += ' ' + ($valid) + ' = false; ';
      }
      out += ' } ';
      if ($breakOnError) {
        out += ' if (' + ($valid) + ') { ';
      }
    } else {
      out += ' if (!' + (__callValidate) + ') { if (vErrors === null) vErrors = ' + ($refCode) + '.errors; else vErrors = vErrors.concat(' + ($refCode) + '.errors); errors = vErrors.length; } ';
      if ($breakOnError) {
        out += ' else { ';
      }
    }
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\ref.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\required.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5Crequired.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate_required(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $valid = 'valid' + $lvl;
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  var $vSchema = 'schema' + $lvl;
  if (!$isData) {
    if ($schema.length < it.opts.loopRequired && it.schema.properties && Object.keys(it.schema.properties).length) {
      var $required = [];
      var arr1 = $schema;
      if (arr1) {
        var $property, i1 = -1,
          l1 = arr1.length - 1;
        while (i1 < l1) {
          $property = arr1[i1 += 1];
          var $propertySch = it.schema.properties[$property];
          if (!($propertySch && (it.opts.strictKeywords ? (typeof $propertySch == 'object' && Object.keys($propertySch).length > 0) || $propertySch === false : it.util.schemaHasRules($propertySch, it.RULES.all)))) {
            $required[$required.length] = $property;
          }
        }
      }
    } else {
      var $required = $schema;
    }
  }
  if ($isData || $required.length) {
    var $currentErrorPath = it.errorPath,
      $loopRequired = $isData || $required.length >= it.opts.loopRequired,
      $ownProperties = it.opts.ownProperties;
    if ($breakOnError) {
      out += ' var missing' + ($lvl) + '; ';
      if ($loopRequired) {
        if (!$isData) {
          out += ' var ' + ($vSchema) + ' = validate.schema' + ($schemaPath) + '; ';
        }
        var $i = 'i' + $lvl,
          $propertyPath = 'schema' + $lvl + '[' + $i + ']',
          $missingProperty = '\' + ' + $propertyPath + ' + \'';
        if (it.opts._errorDataPathProperty) {
          it.errorPath = it.util.getPathExpr($currentErrorPath, $propertyPath, it.opts.jsonPointers);
        }
        out += ' var ' + ($valid) + ' = true; ';
        if ($isData) {
          out += ' if (schema' + ($lvl) + ' === undefined) ' + ($valid) + ' = true; else if (!Array.isArray(schema' + ($lvl) + ')) ' + ($valid) + ' = false; else {';
        }
        out += ' for (var ' + ($i) + ' = 0; ' + ($i) + ' < ' + ($vSchema) + '.length; ' + ($i) + '++) { ' + ($valid) + ' = ' + ($data) + '[' + ($vSchema) + '[' + ($i) + ']] !== undefined ';
        if ($ownProperties) {
          out += ' &&   Object.prototype.hasOwnProperty.call(' + ($data) + ', ' + ($vSchema) + '[' + ($i) + ']) ';
        }
        out += '; if (!' + ($valid) + ') break; } ';
        if ($isData) {
          out += '  }  ';
        }
        out += '  if (!' + ($valid) + ') {   ';
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = ''; /* istanbul ignore else */
        if (it.createErrors !== false) {
          out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
          if (it.opts.messages !== false) {
            out += ' , message: \'';
            if (it.opts._errorDataPathProperty) {
              out += 'is a required property';
            } else {
              out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
            }
            out += '\' ';
          }
          if (it.opts.verbose) {
            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
          }
          out += ' } ';
        } else {
          out += ' {} ';
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          /* istanbul ignore if */
          if (it.async) {
            out += ' throw new ValidationError([' + (__err) + ']); ';
          } else {
            out += ' validate.errors = [' + (__err) + ']; return false; ';
          }
        } else {
          out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        }
        out += ' } else { ';
      } else {
        out += ' if ( ';
        var arr2 = $required;
        if (arr2) {
          var $propertyKey, $i = -1,
            l2 = arr2.length - 1;
          while ($i < l2) {
            $propertyKey = arr2[$i += 1];
            if ($i) {
              out += ' || ';
            }
            var $prop = it.util.getProperty($propertyKey),
              $useData = $data + $prop;
            out += ' ( ( ' + ($useData) + ' === undefined ';
            if ($ownProperties) {
              out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
            }
            out += ') && (missing' + ($lvl) + ' = ' + (it.util.toQuotedString(it.opts.jsonPointers ? $propertyKey : $prop)) + ') ) ';
          }
        }
        out += ') {  ';
        var $propertyPath = 'missing' + $lvl,
          $missingProperty = '\' + ' + $propertyPath + ' + \'';
        if (it.opts._errorDataPathProperty) {
          it.errorPath = it.opts.jsonPointers ? it.util.getPathExpr($currentErrorPath, $propertyPath, true) : $currentErrorPath + ' + ' + $propertyPath;
        }
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = ''; /* istanbul ignore else */
        if (it.createErrors !== false) {
          out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
          if (it.opts.messages !== false) {
            out += ' , message: \'';
            if (it.opts._errorDataPathProperty) {
              out += 'is a required property';
            } else {
              out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
            }
            out += '\' ';
          }
          if (it.opts.verbose) {
            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
          }
          out += ' } ';
        } else {
          out += ' {} ';
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          /* istanbul ignore if */
          if (it.async) {
            out += ' throw new ValidationError([' + (__err) + ']); ';
          } else {
            out += ' validate.errors = [' + (__err) + ']; return false; ';
          }
        } else {
          out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        }
        out += ' } else { ';
      }
    } else {
      if ($loopRequired) {
        if (!$isData) {
          out += ' var ' + ($vSchema) + ' = validate.schema' + ($schemaPath) + '; ';
        }
        var $i = 'i' + $lvl,
          $propertyPath = 'schema' + $lvl + '[' + $i + ']',
          $missingProperty = '\' + ' + $propertyPath + ' + \'';
        if (it.opts._errorDataPathProperty) {
          it.errorPath = it.util.getPathExpr($currentErrorPath, $propertyPath, it.opts.jsonPointers);
        }
        if ($isData) {
          out += ' if (' + ($vSchema) + ' && !Array.isArray(' + ($vSchema) + ')) {  var err =   '; /* istanbul ignore else */
          if (it.createErrors !== false) {
            out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
            if (it.opts.messages !== false) {
              out += ' , message: \'';
              if (it.opts._errorDataPathProperty) {
                out += 'is a required property';
              } else {
                out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
              }
              out += '\' ';
            }
            if (it.opts.verbose) {
              out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
            }
            out += ' } ';
          } else {
            out += ' {} ';
          }
          out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } else if (' + ($vSchema) + ' !== undefined) { ';
        }
        out += ' for (var ' + ($i) + ' = 0; ' + ($i) + ' < ' + ($vSchema) + '.length; ' + ($i) + '++) { if (' + ($data) + '[' + ($vSchema) + '[' + ($i) + ']] === undefined ';
        if ($ownProperties) {
          out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', ' + ($vSchema) + '[' + ($i) + ']) ';
        }
        out += ') {  var err =   '; /* istanbul ignore else */
        if (it.createErrors !== false) {
          out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
          if (it.opts.messages !== false) {
            out += ' , message: \'';
            if (it.opts._errorDataPathProperty) {
              out += 'is a required property';
            } else {
              out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
            }
            out += '\' ';
          }
          if (it.opts.verbose) {
            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
          }
          out += ' } ';
        } else {
          out += ' {} ';
        }
        out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } } ';
        if ($isData) {
          out += '  }  ';
        }
      } else {
        var arr3 = $required;
        if (arr3) {
          var $propertyKey, i3 = -1,
            l3 = arr3.length - 1;
          while (i3 < l3) {
            $propertyKey = arr3[i3 += 1];
            var $prop = it.util.getProperty($propertyKey),
              $missingProperty = it.util.escapeQuotes($propertyKey),
              $useData = $data + $prop;
            if (it.opts._errorDataPathProperty) {
              it.errorPath = it.util.getPath($currentErrorPath, $propertyKey, it.opts.jsonPointers);
            }
            out += ' if ( ' + ($useData) + ' === undefined ';
            if ($ownProperties) {
              out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
            }
            out += ') {  var err =   '; /* istanbul ignore else */
            if (it.createErrors !== false) {
              out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
              if (it.opts.messages !== false) {
                out += ' , message: \'';
                if (it.opts._errorDataPathProperty) {
                  out += 'is a required property';
                } else {
                  out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
                }
                out += '\' ';
              }
              if (it.opts.verbose) {
                out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
              }
              out += ' } ';
            } else {
              out += ' {} ';
            }
            out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } ';
          }
        }
      }
    }
    it.errorPath = $currentErrorPath;
  } else if ($breakOnError) {
    out += ' if (true) {';
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\required.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\uniqueItems.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5CuniqueItems.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate_uniqueItems(it, $keyword, $ruleType) {
  var out = ' ';
  var $lvl = it.level;
  var $dataLvl = it.dataLevel;
  var $schema = it.schema[$keyword];
  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
  var $breakOnError = !it.opts.allErrors;
  var $data = 'data' + ($dataLvl || '');
  var $valid = 'valid' + $lvl;
  var $isData = it.opts.$data && $schema && $schema.$data,
    $schemaValue;
  if ($isData) {
    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
    $schemaValue = 'schema' + $lvl;
  } else {
    $schemaValue = $schema;
  }
  if (($schema || $isData) && it.opts.uniqueItems !== false) {
    if ($isData) {
      out += ' var ' + ($valid) + '; if (' + ($schemaValue) + ' === false || ' + ($schemaValue) + ' === undefined) ' + ($valid) + ' = true; else if (typeof ' + ($schemaValue) + ' != \'boolean\') ' + ($valid) + ' = false; else { ';
    }
    out += ' var i = ' + ($data) + '.length , ' + ($valid) + ' = true , j; if (i > 1) { ';
    var $itemType = it.schema.items && it.schema.items.type,
      $typeIsArray = Array.isArray($itemType);
    if (!$itemType || $itemType == 'object' || $itemType == 'array' || ($typeIsArray && ($itemType.indexOf('object') >= 0 || $itemType.indexOf('array') >= 0))) {
      out += ' outer: for (;i--;) { for (j = i; j--;) { if (equal(' + ($data) + '[i], ' + ($data) + '[j])) { ' + ($valid) + ' = false; break outer; } } } ';
    } else {
      out += ' var itemIndices = {}, item; for (;i--;) { var item = ' + ($data) + '[i]; ';
      var $method = 'checkDataType' + ($typeIsArray ? 's' : '');
      out += ' if (' + (it.util[$method]($itemType, 'item', it.opts.strictNumbers, true)) + ') continue; ';
      if ($typeIsArray) {
        out += ' if (typeof item == \'string\') item = \'"\' + item; ';
      }
      out += ' if (typeof itemIndices[item] == \'number\') { ' + ($valid) + ' = false; j = itemIndices[item]; break; } itemIndices[item] = i; } ';
    }
    out += ' } ';
    if ($isData) {
      out += '  }  ';
    }
    out += ' if (!' + ($valid) + ') {   ';
    var $$outStack = $$outStack || [];
    $$outStack.push(out);
    out = ''; /* istanbul ignore else */
    if (it.createErrors !== false) {
      out += ' { keyword: \'' + ('uniqueItems') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { i: i, j: j } ';
      if (it.opts.messages !== false) {
        out += ' , message: \'should NOT have duplicate items (items ## \' + j + \' and \' + i + \' are identical)\' ';
      }
      if (it.opts.verbose) {
        out += ' , schema:  ';
        if ($isData) {
          out += 'validate.schema' + ($schemaPath);
        } else {
          out += '' + ($schema);
        }
        out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
      }
      out += ' } ';
    } else {
      out += ' {} ';
    }
    var __err = out;
    out = $$outStack.pop();
    if (!it.compositeRule && $breakOnError) {
      /* istanbul ignore if */
      if (it.async) {
        out += ' throw new ValidationError([' + (__err) + ']); ';
      } else {
        out += ' validate.errors = [' + (__err) + ']; return false; ';
      }
    } else {
      out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
    }
    out += ' } ';
    if ($breakOnError) {
      out += ' else { ';
    }
  } else {
    if ($breakOnError) {
      out += ' if (true) { ';
    }
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\uniqueItems.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\validate.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Cdotjs%5Cvalidate.js
      return function (require, module, exports) {
'use strict';
module.exports = function generate_validate(it, $keyword, $ruleType) {
  var out = '';
  var $async = it.schema.$async === true,
    $refKeywords = it.util.schemaHasRulesExcept(it.schema, it.RULES.all, '$ref'),
    $id = it.self._getId(it.schema);
  if (it.opts.strictKeywords) {
    var $unknownKwd = it.util.schemaUnknownRules(it.schema, it.RULES.keywords);
    if ($unknownKwd) {
      var $keywordsMsg = 'unknown keyword: ' + $unknownKwd;
      if (it.opts.strictKeywords === 'log') it.logger.warn($keywordsMsg);
      else throw new Error($keywordsMsg);
    }
  }
  if (it.isTop) {
    out += ' var validate = ';
    if ($async) {
      it.async = true;
      out += 'async ';
    }
    out += 'function(data, dataPath, parentData, parentDataProperty, rootData) { \'use strict\'; ';
    if ($id && (it.opts.sourceCode || it.opts.processCode)) {
      out += ' ' + ('/\*# sourceURL=' + $id + ' */') + ' ';
    }
  }
  if (typeof it.schema == 'boolean' || !($refKeywords || it.schema.$ref)) {
    var $keyword = 'false schema';
    var $lvl = it.level;
    var $dataLvl = it.dataLevel;
    var $schema = it.schema[$keyword];
    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
    var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
    var $breakOnError = !it.opts.allErrors;
    var $errorKeyword;
    var $data = 'data' + ($dataLvl || '');
    var $valid = 'valid' + $lvl;
    if (it.schema === false) {
      if (it.isTop) {
        $breakOnError = true;
      } else {
        out += ' var ' + ($valid) + ' = false; ';
      }
      var $$outStack = $$outStack || [];
      $$outStack.push(out);
      out = ''; /* istanbul ignore else */
      if (it.createErrors !== false) {
        out += ' { keyword: \'' + ($errorKeyword || 'false schema') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
        if (it.opts.messages !== false) {
          out += ' , message: \'boolean schema is false\' ';
        }
        if (it.opts.verbose) {
          out += ' , schema: false , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
        }
        out += ' } ';
      } else {
        out += ' {} ';
      }
      var __err = out;
      out = $$outStack.pop();
      if (!it.compositeRule && $breakOnError) {
        /* istanbul ignore if */
        if (it.async) {
          out += ' throw new ValidationError([' + (__err) + ']); ';
        } else {
          out += ' validate.errors = [' + (__err) + ']; return false; ';
        }
      } else {
        out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
      }
    } else {
      if (it.isTop) {
        if ($async) {
          out += ' return data; ';
        } else {
          out += ' validate.errors = null; return true; ';
        }
      } else {
        out += ' var ' + ($valid) + ' = true; ';
      }
    }
    if (it.isTop) {
      out += ' }; return validate; ';
    }
    return out;
  }
  if (it.isTop) {
    var $top = it.isTop,
      $lvl = it.level = 0,
      $dataLvl = it.dataLevel = 0,
      $data = 'data';
    it.rootId = it.resolve.fullPath(it.self._getId(it.root.schema));
    it.baseId = it.baseId || it.rootId;
    delete it.isTop;
    it.dataPathArr = [""];
    if (it.schema.default !== undefined && it.opts.useDefaults && it.opts.strictDefaults) {
      var $defaultMsg = 'default is ignored in the schema root';
      if (it.opts.strictDefaults === 'log') it.logger.warn($defaultMsg);
      else throw new Error($defaultMsg);
    }
    out += ' var vErrors = null; ';
    out += ' var errors = 0;     ';
    out += ' if (rootData === undefined) rootData = data; ';
  } else {
    var $lvl = it.level,
      $dataLvl = it.dataLevel,
      $data = 'data' + ($dataLvl || '');
    if ($id) it.baseId = it.resolve.url(it.baseId, $id);
    if ($async && !it.async) throw new Error('async schema in sync schema');
    out += ' var errs_' + ($lvl) + ' = errors;';
  }
  var $valid = 'valid' + $lvl,
    $breakOnError = !it.opts.allErrors,
    $closingBraces1 = '',
    $closingBraces2 = '';
  var $errorKeyword;
  var $typeSchema = it.schema.type,
    $typeIsArray = Array.isArray($typeSchema);
  if ($typeSchema && it.opts.nullable && it.schema.nullable === true) {
    if ($typeIsArray) {
      if ($typeSchema.indexOf('null') == -1) $typeSchema = $typeSchema.concat('null');
    } else if ($typeSchema != 'null') {
      $typeSchema = [$typeSchema, 'null'];
      $typeIsArray = true;
    }
  }
  if ($typeIsArray && $typeSchema.length == 1) {
    $typeSchema = $typeSchema[0];
    $typeIsArray = false;
  }
  if (it.schema.$ref && $refKeywords) {
    if (it.opts.extendRefs == 'fail') {
      throw new Error('$ref: validation keywords used in schema at path "' + it.errSchemaPath + '" (see option extendRefs)');
    } else if (it.opts.extendRefs !== true) {
      $refKeywords = false;
      it.logger.warn('$ref: keywords ignored in schema at path "' + it.errSchemaPath + '"');
    }
  }
  if (it.schema.$comment && it.opts.$comment) {
    out += ' ' + (it.RULES.all.$comment.code(it, '$comment'));
  }
  if ($typeSchema) {
    if (it.opts.coerceTypes) {
      var $coerceToTypes = it.util.coerceToTypes(it.opts.coerceTypes, $typeSchema);
    }
    var $rulesGroup = it.RULES.types[$typeSchema];
    if ($coerceToTypes || $typeIsArray || $rulesGroup === true || ($rulesGroup && !$shouldUseGroup($rulesGroup))) {
      var $schemaPath = it.schemaPath + '.type',
        $errSchemaPath = it.errSchemaPath + '/type';
      var $schemaPath = it.schemaPath + '.type',
        $errSchemaPath = it.errSchemaPath + '/type',
        $method = $typeIsArray ? 'checkDataTypes' : 'checkDataType';
      out += ' if (' + (it.util[$method]($typeSchema, $data, it.opts.strictNumbers, true)) + ') { ';
      if ($coerceToTypes) {
        var $dataType = 'dataType' + $lvl,
          $coerced = 'coerced' + $lvl;
        out += ' var ' + ($dataType) + ' = typeof ' + ($data) + '; var ' + ($coerced) + ' = undefined; ';
        if (it.opts.coerceTypes == 'array') {
          out += ' if (' + ($dataType) + ' == \'object\' && Array.isArray(' + ($data) + ') && ' + ($data) + '.length == 1) { ' + ($data) + ' = ' + ($data) + '[0]; ' + ($dataType) + ' = typeof ' + ($data) + '; if (' + (it.util.checkDataType(it.schema.type, $data, it.opts.strictNumbers)) + ') ' + ($coerced) + ' = ' + ($data) + '; } ';
        }
        out += ' if (' + ($coerced) + ' !== undefined) ; ';
        var arr1 = $coerceToTypes;
        if (arr1) {
          var $type, $i = -1,
            l1 = arr1.length - 1;
          while ($i < l1) {
            $type = arr1[$i += 1];
            if ($type == 'string') {
              out += ' else if (' + ($dataType) + ' == \'number\' || ' + ($dataType) + ' == \'boolean\') ' + ($coerced) + ' = \'\' + ' + ($data) + '; else if (' + ($data) + ' === null) ' + ($coerced) + ' = \'\'; ';
            } else if ($type == 'number' || $type == 'integer') {
              out += ' else if (' + ($dataType) + ' == \'boolean\' || ' + ($data) + ' === null || (' + ($dataType) + ' == \'string\' && ' + ($data) + ' && ' + ($data) + ' == +' + ($data) + ' ';
              if ($type == 'integer') {
                out += ' && !(' + ($data) + ' % 1)';
              }
              out += ')) ' + ($coerced) + ' = +' + ($data) + '; ';
            } else if ($type == 'boolean') {
              out += ' else if (' + ($data) + ' === \'false\' || ' + ($data) + ' === 0 || ' + ($data) + ' === null) ' + ($coerced) + ' = false; else if (' + ($data) + ' === \'true\' || ' + ($data) + ' === 1) ' + ($coerced) + ' = true; ';
            } else if ($type == 'null') {
              out += ' else if (' + ($data) + ' === \'\' || ' + ($data) + ' === 0 || ' + ($data) + ' === false) ' + ($coerced) + ' = null; ';
            } else if (it.opts.coerceTypes == 'array' && $type == 'array') {
              out += ' else if (' + ($dataType) + ' == \'string\' || ' + ($dataType) + ' == \'number\' || ' + ($dataType) + ' == \'boolean\' || ' + ($data) + ' == null) ' + ($coerced) + ' = [' + ($data) + ']; ';
            }
          }
        }
        out += ' else {   ';
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = ''; /* istanbul ignore else */
        if (it.createErrors !== false) {
          out += ' { keyword: \'' + ($errorKeyword || 'type') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { type: \'';
          if ($typeIsArray) {
            out += '' + ($typeSchema.join(","));
          } else {
            out += '' + ($typeSchema);
          }
          out += '\' } ';
          if (it.opts.messages !== false) {
            out += ' , message: \'should be ';
            if ($typeIsArray) {
              out += '' + ($typeSchema.join(","));
            } else {
              out += '' + ($typeSchema);
            }
            out += '\' ';
          }
          if (it.opts.verbose) {
            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
          }
          out += ' } ';
        } else {
          out += ' {} ';
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          /* istanbul ignore if */
          if (it.async) {
            out += ' throw new ValidationError([' + (__err) + ']); ';
          } else {
            out += ' validate.errors = [' + (__err) + ']; return false; ';
          }
        } else {
          out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        }
        out += ' } if (' + ($coerced) + ' !== undefined) {  ';
        var $parentData = $dataLvl ? 'data' + (($dataLvl - 1) || '') : 'parentData',
          $parentDataProperty = $dataLvl ? it.dataPathArr[$dataLvl] : 'parentDataProperty';
        out += ' ' + ($data) + ' = ' + ($coerced) + '; ';
        if (!$dataLvl) {
          out += 'if (' + ($parentData) + ' !== undefined)';
        }
        out += ' ' + ($parentData) + '[' + ($parentDataProperty) + '] = ' + ($coerced) + '; } ';
      } else {
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = ''; /* istanbul ignore else */
        if (it.createErrors !== false) {
          out += ' { keyword: \'' + ($errorKeyword || 'type') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { type: \'';
          if ($typeIsArray) {
            out += '' + ($typeSchema.join(","));
          } else {
            out += '' + ($typeSchema);
          }
          out += '\' } ';
          if (it.opts.messages !== false) {
            out += ' , message: \'should be ';
            if ($typeIsArray) {
              out += '' + ($typeSchema.join(","));
            } else {
              out += '' + ($typeSchema);
            }
            out += '\' ';
          }
          if (it.opts.verbose) {
            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
          }
          out += ' } ';
        } else {
          out += ' {} ';
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) {
          /* istanbul ignore if */
          if (it.async) {
            out += ' throw new ValidationError([' + (__err) + ']); ';
          } else {
            out += ' validate.errors = [' + (__err) + ']; return false; ';
          }
        } else {
          out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        }
      }
      out += ' } ';
    }
  }
  if (it.schema.$ref && !$refKeywords) {
    out += ' ' + (it.RULES.all.$ref.code(it, '$ref')) + ' ';
    if ($breakOnError) {
      out += ' } if (errors === ';
      if ($top) {
        out += '0';
      } else {
        out += 'errs_' + ($lvl);
      }
      out += ') { ';
      $closingBraces2 += '}';
    }
  } else {
    var arr2 = it.RULES;
    if (arr2) {
      var $rulesGroup, i2 = -1,
        l2 = arr2.length - 1;
      while (i2 < l2) {
        $rulesGroup = arr2[i2 += 1];
        if ($shouldUseGroup($rulesGroup)) {
          if ($rulesGroup.type) {
            out += ' if (' + (it.util.checkDataType($rulesGroup.type, $data, it.opts.strictNumbers)) + ') { ';
          }
          if (it.opts.useDefaults) {
            if ($rulesGroup.type == 'object' && it.schema.properties) {
              var $schema = it.schema.properties,
                $schemaKeys = Object.keys($schema);
              var arr3 = $schemaKeys;
              if (arr3) {
                var $propertyKey, i3 = -1,
                  l3 = arr3.length - 1;
                while (i3 < l3) {
                  $propertyKey = arr3[i3 += 1];
                  var $sch = $schema[$propertyKey];
                  if ($sch.default !== undefined) {
                    var $passData = $data + it.util.getProperty($propertyKey);
                    if (it.compositeRule) {
                      if (it.opts.strictDefaults) {
                        var $defaultMsg = 'default is ignored for: ' + $passData;
                        if (it.opts.strictDefaults === 'log') it.logger.warn($defaultMsg);
                        else throw new Error($defaultMsg);
                      }
                    } else {
                      out += ' if (' + ($passData) + ' === undefined ';
                      if (it.opts.useDefaults == 'empty') {
                        out += ' || ' + ($passData) + ' === null || ' + ($passData) + ' === \'\' ';
                      }
                      out += ' ) ' + ($passData) + ' = ';
                      if (it.opts.useDefaults == 'shared') {
                        out += ' ' + (it.useDefault($sch.default)) + ' ';
                      } else {
                        out += ' ' + (JSON.stringify($sch.default)) + ' ';
                      }
                      out += '; ';
                    }
                  }
                }
              }
            } else if ($rulesGroup.type == 'array' && Array.isArray(it.schema.items)) {
              var arr4 = it.schema.items;
              if (arr4) {
                var $sch, $i = -1,
                  l4 = arr4.length - 1;
                while ($i < l4) {
                  $sch = arr4[$i += 1];
                  if ($sch.default !== undefined) {
                    var $passData = $data + '[' + $i + ']';
                    if (it.compositeRule) {
                      if (it.opts.strictDefaults) {
                        var $defaultMsg = 'default is ignored for: ' + $passData;
                        if (it.opts.strictDefaults === 'log') it.logger.warn($defaultMsg);
                        else throw new Error($defaultMsg);
                      }
                    } else {
                      out += ' if (' + ($passData) + ' === undefined ';
                      if (it.opts.useDefaults == 'empty') {
                        out += ' || ' + ($passData) + ' === null || ' + ($passData) + ' === \'\' ';
                      }
                      out += ' ) ' + ($passData) + ' = ';
                      if (it.opts.useDefaults == 'shared') {
                        out += ' ' + (it.useDefault($sch.default)) + ' ';
                      } else {
                        out += ' ' + (JSON.stringify($sch.default)) + ' ';
                      }
                      out += '; ';
                    }
                  }
                }
              }
            }
          }
          var arr5 = $rulesGroup.rules;
          if (arr5) {
            var $rule, i5 = -1,
              l5 = arr5.length - 1;
            while (i5 < l5) {
              $rule = arr5[i5 += 1];
              if ($shouldUseRule($rule)) {
                var $code = $rule.code(it, $rule.keyword, $rulesGroup.type);
                if ($code) {
                  out += ' ' + ($code) + ' ';
                  if ($breakOnError) {
                    $closingBraces1 += '}';
                  }
                }
              }
            }
          }
          if ($breakOnError) {
            out += ' ' + ($closingBraces1) + ' ';
            $closingBraces1 = '';
          }
          if ($rulesGroup.type) {
            out += ' } ';
            if ($typeSchema && $typeSchema === $rulesGroup.type && !$coerceToTypes) {
              out += ' else { ';
              var $schemaPath = it.schemaPath + '.type',
                $errSchemaPath = it.errSchemaPath + '/type';
              var $$outStack = $$outStack || [];
              $$outStack.push(out);
              out = ''; /* istanbul ignore else */
              if (it.createErrors !== false) {
                out += ' { keyword: \'' + ($errorKeyword || 'type') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { type: \'';
                if ($typeIsArray) {
                  out += '' + ($typeSchema.join(","));
                } else {
                  out += '' + ($typeSchema);
                }
                out += '\' } ';
                if (it.opts.messages !== false) {
                  out += ' , message: \'should be ';
                  if ($typeIsArray) {
                    out += '' + ($typeSchema.join(","));
                  } else {
                    out += '' + ($typeSchema);
                  }
                  out += '\' ';
                }
                if (it.opts.verbose) {
                  out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                }
                out += ' } ';
              } else {
                out += ' {} ';
              }
              var __err = out;
              out = $$outStack.pop();
              if (!it.compositeRule && $breakOnError) {
                /* istanbul ignore if */
                if (it.async) {
                  out += ' throw new ValidationError([' + (__err) + ']); ';
                } else {
                  out += ' validate.errors = [' + (__err) + ']; return false; ';
                }
              } else {
                out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
              }
              out += ' } ';
            }
          }
          if ($breakOnError) {
            out += ' if (errors === ';
            if ($top) {
              out += '0';
            } else {
              out += 'errs_' + ($lvl);
            }
            out += ') { ';
            $closingBraces2 += '}';
          }
        }
      }
    }
  }
  if ($breakOnError) {
    out += ' ' + ($closingBraces2) + ' ';
  }
  if ($top) {
    if ($async) {
      out += ' if (errors === 0) return data;           ';
      out += ' else throw new ValidationError(vErrors); ';
    } else {
      out += ' validate.errors = vErrors; ';
      out += ' return errors === 0;       ';
    }
    out += ' }; return validate;';
  } else {
    out += ' var ' + ($valid) + ' = errors === errs_' + ($lvl) + ';';
  }

  function $shouldUseGroup($rulesGroup) {
    var rules = $rulesGroup.rules;
    for (var i = 0; i < rules.length; i++)
      if ($shouldUseRule(rules[i])) return true;
  }

  function $shouldUseRule($rule) {
    return it.schema[$rule.keyword] !== undefined || ($rule.implements && $ruleImplementsSomeKeyword($rule));
  }

  function $ruleImplementsSomeKeyword($rule) {
    var impl = $rule.implements;
    for (var i = 0; i < impl.length; i++)
      if (it.schema[impl[i]] !== undefined) return true;
  }
  return out;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\dotjs\\validate.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\keyword.js", {"./definition_schema":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\definition_schema.js","./dotjs/custom":"D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\dotjs\\custom.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Ckeyword.js
      return function (require, module, exports) {
'use strict';

var IDENTIFIER = /^[a-z_$][a-z0-9_$-]*$/i;
var customRuleCode = require('./dotjs/custom');
var definitionSchema = require('./definition_schema');

module.exports = {
  add: addKeyword,
  get: getKeyword,
  remove: removeKeyword,
  validate: validateKeyword
};


/**
 * Define custom keyword
 * @this  Ajv
 * @param {String} keyword custom keyword, should be unique (including different from all standard, custom and macro keywords).
 * @param {Object} definition keyword definition object with properties `type` (type(s) which the keyword applies to), `validate` or `compile`.
 * @return {Ajv} this for method chaining
 */
function addKeyword(keyword, definition) {
  /* jshint validthis: true */
  /* eslint no-shadow: 0 */
  var RULES = this.RULES;
  if (RULES.keywords[keyword])
    throw new Error('Keyword ' + keyword + ' is already defined');

  if (!IDENTIFIER.test(keyword))
    throw new Error('Keyword ' + keyword + ' is not a valid identifier');

  if (definition) {
    this.validateKeyword(definition, true);

    var dataType = definition.type;
    if (Array.isArray(dataType)) {
      for (var i=0; i<dataType.length; i++)
        _addRule(keyword, dataType[i], definition);
    } else {
      _addRule(keyword, dataType, definition);
    }

    var metaSchema = definition.metaSchema;
    if (metaSchema) {
      if (definition.$data && this._opts.$data) {
        metaSchema = {
          anyOf: [
            metaSchema,
            { '$ref': 'https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#' }
          ]
        };
      }
      definition.validateSchema = this.compile(metaSchema, true);
    }
  }

  RULES.keywords[keyword] = RULES.all[keyword] = true;


  function _addRule(keyword, dataType, definition) {
    var ruleGroup;
    for (var i=0; i<RULES.length; i++) {
      var rg = RULES[i];
      if (rg.type == dataType) {
        ruleGroup = rg;
        break;
      }
    }

    if (!ruleGroup) {
      ruleGroup = { type: dataType, rules: [] };
      RULES.push(ruleGroup);
    }

    var rule = {
      keyword: keyword,
      definition: definition,
      custom: true,
      code: customRuleCode,
      implements: definition.implements
    };
    ruleGroup.rules.push(rule);
    RULES.custom[keyword] = rule;
  }

  return this;
}


/**
 * Get keyword
 * @this  Ajv
 * @param {String} keyword pre-defined or custom keyword.
 * @return {Object|Boolean} custom keyword definition, `true` if it is a predefined keyword, `false` otherwise.
 */
function getKeyword(keyword) {
  /* jshint validthis: true */
  var rule = this.RULES.custom[keyword];
  return rule ? rule.definition : this.RULES.keywords[keyword] || false;
}


/**
 * Remove keyword
 * @this  Ajv
 * @param {String} keyword pre-defined or custom keyword.
 * @return {Ajv} this for method chaining
 */
function removeKeyword(keyword) {
  /* jshint validthis: true */
  var RULES = this.RULES;
  delete RULES.keywords[keyword];
  delete RULES.all[keyword];
  delete RULES.custom[keyword];
  for (var i=0; i<RULES.length; i++) {
    var rules = RULES[i].rules;
    for (var j=0; j<rules.length; j++) {
      if (rules[j].keyword == keyword) {
        rules.splice(j, 1);
        break;
      }
    }
  }
  return this;
}


/**
 * Validate keyword definition
 * @this  Ajv
 * @param {Object} definition keyword definition object.
 * @param {Boolean} throwError true to throw exception if definition is invalid
 * @return {boolean} validation result
 */
function validateKeyword(definition, throwError) {
  validateKeyword.errors = null;
  var v = this._validateKeyword = this._validateKeyword
                                  || this.compile(definitionSchema, true);

  if (v(definition)) return true;
  validateKeyword.errors = v.errors;
  if (throwError)
    throw new Error('custom keyword definition is invalid: '  + this.errorsText(v.errors));
  else
    return false;
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\keyword.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\refs\\data.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Crefs%5Cdata.json
      return function (require, module, exports) {
module.exports={
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#",
    "description": "Meta-schema for $data reference (JSON Schema extension proposal)",
    "type": "object",
    "required": [ "$data" ],
    "properties": {
        "$data": {
            "type": "string",
            "anyOf": [
                { "format": "relative-json-pointer" }, 
                { "format": "json-pointer" }
            ]
        }
    },
    "additionalProperties": false
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\refs\\data.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\lib\\refs\\json-schema-draft-07.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Clib%5Crefs%5Cjson-schema-draft-07.json
      return function (require, module, exports) {
module.exports={
    "$schema": "http://json-schema.org/draft-07/schema#",
    "$id": "http://json-schema.org/draft-07/schema#",
    "title": "Core schema meta-schema",
    "definitions": {
        "schemaArray": {
            "type": "array",
            "minItems": 1,
            "items": { "$ref": "#" }
        },
        "nonNegativeInteger": {
            "type": "integer",
            "minimum": 0
        },
        "nonNegativeIntegerDefault0": {
            "allOf": [
                { "$ref": "#/definitions/nonNegativeInteger" },
                { "default": 0 }
            ]
        },
        "simpleTypes": {
            "enum": [
                "array",
                "boolean",
                "integer",
                "null",
                "number",
                "object",
                "string"
            ]
        },
        "stringArray": {
            "type": "array",
            "items": { "type": "string" },
            "uniqueItems": true,
            "default": []
        }
    },
    "type": ["object", "boolean"],
    "properties": {
        "$id": {
            "type": "string",
            "format": "uri-reference"
        },
        "$schema": {
            "type": "string",
            "format": "uri"
        },
        "$ref": {
            "type": "string",
            "format": "uri-reference"
        },
        "$comment": {
            "type": "string"
        },
        "title": {
            "type": "string"
        },
        "description": {
            "type": "string"
        },
        "default": true,
        "readOnly": {
            "type": "boolean",
            "default": false
        },
        "examples": {
            "type": "array",
            "items": true
        },
        "multipleOf": {
            "type": "number",
            "exclusiveMinimum": 0
        },
        "maximum": {
            "type": "number"
        },
        "exclusiveMaximum": {
            "type": "number"
        },
        "minimum": {
            "type": "number"
        },
        "exclusiveMinimum": {
            "type": "number"
        },
        "maxLength": { "$ref": "#/definitions/nonNegativeInteger" },
        "minLength": { "$ref": "#/definitions/nonNegativeIntegerDefault0" },
        "pattern": {
            "type": "string",
            "format": "regex"
        },
        "additionalItems": { "$ref": "#" },
        "items": {
            "anyOf": [
                { "$ref": "#" },
                { "$ref": "#/definitions/schemaArray" }
            ],
            "default": true
        },
        "maxItems": { "$ref": "#/definitions/nonNegativeInteger" },
        "minItems": { "$ref": "#/definitions/nonNegativeIntegerDefault0" },
        "uniqueItems": {
            "type": "boolean",
            "default": false
        },
        "contains": { "$ref": "#" },
        "maxProperties": { "$ref": "#/definitions/nonNegativeInteger" },
        "minProperties": { "$ref": "#/definitions/nonNegativeIntegerDefault0" },
        "required": { "$ref": "#/definitions/stringArray" },
        "additionalProperties": { "$ref": "#" },
        "definitions": {
            "type": "object",
            "additionalProperties": { "$ref": "#" },
            "default": {}
        },
        "properties": {
            "type": "object",
            "additionalProperties": { "$ref": "#" },
            "default": {}
        },
        "patternProperties": {
            "type": "object",
            "additionalProperties": { "$ref": "#" },
            "propertyNames": { "format": "regex" },
            "default": {}
        },
        "dependencies": {
            "type": "object",
            "additionalProperties": {
                "anyOf": [
                    { "$ref": "#" },
                    { "$ref": "#/definitions/stringArray" }
                ]
            }
        },
        "propertyNames": { "$ref": "#" },
        "const": true,
        "enum": {
            "type": "array",
            "items": true,
            "minItems": 1,
            "uniqueItems": true
        },
        "type": {
            "anyOf": [
                { "$ref": "#/definitions/simpleTypes" },
                {
                    "type": "array",
                    "items": { "$ref": "#/definitions/simpleTypes" },
                    "minItems": 1,
                    "uniqueItems": true
                }
            ]
        },
        "format": { "type": "string" },
        "contentMediaType": { "type": "string" },
        "contentEncoding": { "type": "string" },
        "if": {"$ref": "#"},
        "then": {"$ref": "#"},
        "else": {"$ref": "#"},
        "allOf": { "$ref": "#/definitions/schemaArray" },
        "anyOf": { "$ref": "#/definitions/schemaArray" },
        "oneOf": { "$ref": "#/definitions/schemaArray" },
        "not": { "$ref": "#" }
    },
    "default": true
}

      };
    };
  }
  }
}, {package:"eslint>ajv",file:"node_modules\\ajv\\lib\\refs\\json-schema-draft-07.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\ajv\\node_modules\\json-schema-traverse\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cajv%5Cnode_modules%5Cjson-schema-traverse%5Cindex.js
      return function (require, module, exports) {
'use strict';

var traverse = module.exports = function (schema, opts, cb) {
  // Legacy support for v0.3.1 and earlier.
  if (typeof opts == 'function') {
    cb = opts;
    opts = {};
  }

  cb = opts.cb || cb;
  var pre = (typeof cb == 'function') ? cb : cb.pre || function() {};
  var post = cb.post || function() {};

  _traverse(opts, pre, post, schema, '', schema);
};


traverse.keywords = {
  additionalItems: true,
  items: true,
  contains: true,
  additionalProperties: true,
  propertyNames: true,
  not: true
};

traverse.arrayKeywords = {
  items: true,
  allOf: true,
  anyOf: true,
  oneOf: true
};

traverse.propsKeywords = {
  definitions: true,
  properties: true,
  patternProperties: true,
  dependencies: true
};

traverse.skipKeywords = {
  default: true,
  enum: true,
  const: true,
  required: true,
  maximum: true,
  minimum: true,
  exclusiveMaximum: true,
  exclusiveMinimum: true,
  multipleOf: true,
  maxLength: true,
  minLength: true,
  pattern: true,
  format: true,
  maxItems: true,
  minItems: true,
  uniqueItems: true,
  maxProperties: true,
  minProperties: true
};


function _traverse(opts, pre, post, schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex) {
  if (schema && typeof schema == 'object' && !Array.isArray(schema)) {
    pre(schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex);
    for (var key in schema) {
      var sch = schema[key];
      if (Array.isArray(sch)) {
        if (key in traverse.arrayKeywords) {
          for (var i=0; i<sch.length; i++)
            _traverse(opts, pre, post, sch[i], jsonPtr + '/' + key + '/' + i, rootSchema, jsonPtr, key, schema, i);
        }
      } else if (key in traverse.propsKeywords) {
        if (sch && typeof sch == 'object') {
          for (var prop in sch)
            _traverse(opts, pre, post, sch[prop], jsonPtr + '/' + key + '/' + escapeJsonPtr(prop), rootSchema, jsonPtr, key, schema, prop);
        }
      } else if (key in traverse.keywords || (opts.allKeys && !(key in traverse.skipKeywords))) {
        _traverse(opts, pre, post, sch, jsonPtr + '/' + key, rootSchema, jsonPtr, key, schema);
      }
    }
    post(schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex);
  }
}


function escapeJsonPtr(str) {
  return str.replace(/~/g, '~0').replace(/\//g, '~1');
}

      };
    };
  }
  }
}, {package:"eslint>ajv>json-schema-traverse",file:"node_modules\\ajv\\node_modules\\json-schema-traverse\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\await-semaphore\\index.js", {"_process":"D:\\code\\v\\metamask-extension\\node_modules\\process\\browser.js","timers":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\timers-browserify\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cawait-semaphore%5Cindex.js
      return function (require, module, exports) {
(function (process,setImmediate){(function (){
"use strict";
class Semaphore {
    constructor(count) {
        this.tasks = [];
        this.count = count;
    }
    sched() {
        if (this.count > 0 && this.tasks.length > 0) {
            this.count--;
            let next = this.tasks.shift();
            if (next === undefined) {
                throw "Unexpected undefined value in tasks list";
            }
            next();
        }
    }
    acquire() {
        return new Promise((res, rej) => {
            var task = () => {
                var released = false;
                res(() => {
                    if (!released) {
                        released = true;
                        this.count++;
                        this.sched();
                    }
                });
            };
            this.tasks.push(task);
            if (process && process.nextTick) {
                process.nextTick(this.sched.bind(this));
            }
            else {
                setImmediate(this.sched.bind(this));
            }
        });
    }
    use(f) {
        return this.acquire()
            .then(release => {
            return f()
                .then((res) => {
                release();
                return res;
            })
                .catch((err) => {
                release();
                throw err;
            });
        });
    }
}
exports.Semaphore = Semaphore;
class Mutex extends Semaphore {
    constructor() {
        super(1);
    }
}
exports.Mutex = Mutex;

}).call(this)}).call(this,require('_process'),require("timers").setImmediate)

      };
    };
  }
  }
}, {package:"await-semaphore",file:"node_modules\\await-semaphore\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\index.js", {"./lib/axios.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\axios.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.all = exports.VERSION = exports.HttpStatusCode = exports.CanceledError = exports.CancelToken = exports.Cancel = exports.AxiosHeaders = exports.AxiosError = exports.Axios = void 0;
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function () {
    return _axios.default;
  }
});
exports.toFormData = exports.spread = exports.mergeConfig = exports.isCancel = exports.isAxiosError = exports.getAdapter = exports.formToJSON = void 0;
var _axios = _interopRequireDefault(require("./lib/axios.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// This module is intended to unwrap Axios default export as named.
// Keep top-level export same with static properties
// so that it can keep same with es module or cjs
const {
  Axios,
  AxiosError,
  CanceledError,
  isCancel,
  CancelToken,
  VERSION,
  all,
  Cancel,
  isAxiosError,
  spread,
  toFormData,
  AxiosHeaders,
  HttpStatusCode,
  formToJSON,
  getAdapter,
  mergeConfig
} = _axios.default;
exports.mergeConfig = mergeConfig;
exports.getAdapter = getAdapter;
exports.formToJSON = formToJSON;
exports.HttpStatusCode = HttpStatusCode;
exports.AxiosHeaders = AxiosHeaders;
exports.toFormData = toFormData;
exports.spread = spread;
exports.isAxiosError = isAxiosError;
exports.Cancel = Cancel;
exports.all = all;
exports.VERSION = VERSION;
exports.CancelToken = CancelToken;
exports.isCancel = isCancel;
exports.CanceledError = CanceledError;
exports.AxiosError = AxiosError;
exports.Axios = Axios;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\adapters\\adapters.js", {"../core/AxiosError.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\AxiosError.js","../utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js","./fetch.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\adapters\\fetch.js","./http.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\null.js","./xhr.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\adapters\\xhr.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Cadapters%5Cadapters.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _utils = _interopRequireDefault(require("../utils.js"));
var _http = _interopRequireDefault(require("./http.js"));
var _xhr = _interopRequireDefault(require("./xhr.js"));
var fetchAdapter = _interopRequireWildcard(require("./fetch.js"));
var _AxiosError = _interopRequireDefault(require("../core/AxiosError.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const knownAdapters = {
  http: _http.default,
  xhr: _xhr.default,
  fetch: {
    get: fetchAdapter.getFetch
  }
};
_utils.default.forEach(knownAdapters, (fn, value) => {
  if (fn) {
    try {
      Object.defineProperty(fn, 'name', {
        value
      });
    } catch (e) {
      // eslint-disable-next-line no-empty
    }
    Object.defineProperty(fn, 'adapterName', {
      value
    });
  }
});
const renderReason = reason => `- ${reason}`;
const isResolvedHandle = adapter => _utils.default.isFunction(adapter) || adapter === null || adapter === false;
var _default = exports.default = {
  getAdapter: (adapters, config) => {
    adapters = _utils.default.isArray(adapters) ? adapters : [adapters];
    const {
      length
    } = adapters;
    let nameOrAdapter;
    let adapter;
    const rejectedReasons = {};
    for (let i = 0; i < length; i++) {
      nameOrAdapter = adapters[i];
      let id;
      adapter = nameOrAdapter;
      if (!isResolvedHandle(nameOrAdapter)) {
        adapter = knownAdapters[(id = String(nameOrAdapter)).toLowerCase()];
        if (adapter === undefined) {
          throw new _AxiosError.default(`Unknown adapter '${id}'`);
        }
      }
      if (adapter && (_utils.default.isFunction(adapter) || (adapter = adapter.get(config)))) {
        break;
      }
      rejectedReasons[id || '#' + i] = adapter;
    }
    if (!adapter) {
      const reasons = Object.entries(rejectedReasons).map(([id, state]) => `adapter ${id} ` + (state === false ? 'is not supported by the environment' : 'is not available in the build'));
      let s = length ? reasons.length > 1 ? 'since :\n' + reasons.map(renderReason).join('\n') : ' ' + renderReason(reasons[0]) : 'as no adapter specified';
      throw new _AxiosError.default(`There is no suitable adapter to dispatch the request ` + s, 'ERR_NOT_SUPPORT');
    }
    return adapter;
  },
  adapters: knownAdapters
};

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\adapters\\adapters.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\adapters\\fetch.js", {"../core/AxiosError.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\AxiosError.js","../core/AxiosHeaders.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\AxiosHeaders.js","../core/settle.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\settle.js","../helpers/composeSignals.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\composeSignals.js","../helpers/progressEventReducer.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\progressEventReducer.js","../helpers/resolveConfig.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\resolveConfig.js","../helpers/trackStream.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\trackStream.js","../platform/index.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\platform\\index.js","../utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Cadapters%5Cfetch.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFetch = exports.default = void 0;
var _index = _interopRequireDefault(require("../platform/index.js"));
var _utils = _interopRequireDefault(require("../utils.js"));
var _AxiosError = _interopRequireDefault(require("../core/AxiosError.js"));
var _composeSignals = _interopRequireDefault(require("../helpers/composeSignals.js"));
var _trackStream = require("../helpers/trackStream.js");
var _AxiosHeaders = _interopRequireDefault(require("../core/AxiosHeaders.js"));
var _progressEventReducer = require("../helpers/progressEventReducer.js");
var _resolveConfig = _interopRequireDefault(require("../helpers/resolveConfig.js"));
var _settle = _interopRequireDefault(require("../core/settle.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const DEFAULT_CHUNK_SIZE = 64 * 1024;
const {
  isFunction
} = _utils.default;
const globalFetchAPI = (({
  fetch,
  Request,
  Response
}) => ({
  fetch,
  Request,
  Response
}))(_utils.default.global);
const {
  ReadableStream,
  TextEncoder
} = _utils.default.global;
const test = (fn, ...args) => {
  try {
    return !!fn(...args);
  } catch (e) {
    return false;
  }
};
const factory = env => {
  const {
    fetch,
    Request,
    Response
  } = Object.assign({}, globalFetchAPI, env);
  const isFetchSupported = isFunction(fetch);
  const isRequestSupported = isFunction(Request);
  const isResponseSupported = isFunction(Response);
  if (!isFetchSupported) {
    return false;
  }
  const isReadableStreamSupported = isFetchSupported && isFunction(ReadableStream);
  const encodeText = isFetchSupported && (typeof TextEncoder === 'function' ? (encoder => str => encoder.encode(str))(new TextEncoder()) : async str => new Uint8Array(await new Request(str).arrayBuffer()));
  const supportsRequestStream = isRequestSupported && isReadableStreamSupported && test(() => {
    let duplexAccessed = false;
    const hasContentType = new Request(_index.default.origin, {
      body: new ReadableStream(),
      method: 'POST',
      get duplex() {
        duplexAccessed = true;
        return 'half';
      }
    }).headers.has('Content-Type');
    return duplexAccessed && !hasContentType;
  });
  const supportsResponseStream = isResponseSupported && isReadableStreamSupported && test(() => _utils.default.isReadableStream(new Response('').body));
  const resolvers = {
    stream: supportsResponseStream && (res => res.body)
  };
  isFetchSupported && (() => {
    ['text', 'arrayBuffer', 'blob', 'formData', 'stream'].forEach(type => {
      !resolvers[type] && (resolvers[type] = (res, config) => {
        let method = res && res[type];
        if (method) {
          return method.call(res);
        }
        throw new _AxiosError.default(`Response type '${type}' is not supported`, _AxiosError.default.ERR_NOT_SUPPORT, config);
      });
    });
  })();
  const getBodyLength = async body => {
    if (body == null) {
      return 0;
    }
    if (_utils.default.isBlob(body)) {
      return body.size;
    }
    if (_utils.default.isSpecCompliantForm(body)) {
      const _request = new Request(_index.default.origin, {
        method: 'POST',
        body
      });
      return (await _request.arrayBuffer()).byteLength;
    }
    if (_utils.default.isArrayBufferView(body) || _utils.default.isArrayBuffer(body)) {
      return body.byteLength;
    }
    if (_utils.default.isURLSearchParams(body)) {
      body = body + '';
    }
    if (_utils.default.isString(body)) {
      return (await encodeText(body)).byteLength;
    }
  };
  const resolveBodyLength = async (headers, body) => {
    const length = _utils.default.toFiniteNumber(headers.getContentLength());
    return length == null ? getBodyLength(body) : length;
  };
  return async config => {
    let {
      url,
      method,
      data,
      signal,
      cancelToken,
      timeout,
      onDownloadProgress,
      onUploadProgress,
      responseType,
      headers,
      withCredentials = 'same-origin',
      fetchOptions
    } = (0, _resolveConfig.default)(config);
    responseType = responseType ? (responseType + '').toLowerCase() : 'text';
    let composedSignal = (0, _composeSignals.default)([signal, cancelToken && cancelToken.toAbortSignal()], timeout);
    let request = null;
    const unsubscribe = composedSignal && composedSignal.unsubscribe && (() => {
      composedSignal.unsubscribe();
    });
    let requestContentLength;
    try {
      if (onUploadProgress && supportsRequestStream && method !== 'get' && method !== 'head' && (requestContentLength = await resolveBodyLength(headers, data)) !== 0) {
        let _request = new Request(url, {
          method: 'POST',
          body: data,
          duplex: "half"
        });
        let contentTypeHeader;
        if (_utils.default.isFormData(data) && (contentTypeHeader = _request.headers.get('content-type'))) {
          headers.setContentType(contentTypeHeader);
        }
        if (_request.body) {
          const [onProgress, flush] = (0, _progressEventReducer.progressEventDecorator)(requestContentLength, (0, _progressEventReducer.progressEventReducer)((0, _progressEventReducer.asyncDecorator)(onUploadProgress)));
          data = (0, _trackStream.trackStream)(_request.body, DEFAULT_CHUNK_SIZE, onProgress, flush);
        }
      }
      if (!_utils.default.isString(withCredentials)) {
        withCredentials = withCredentials ? 'include' : 'omit';
      }

      // Cloudflare Workers throws when credentials are defined
      // see https://github.com/cloudflare/workerd/issues/902
      const isCredentialsSupported = isRequestSupported && "credentials" in Request.prototype;
      const resolvedOptions = {
        ...fetchOptions,
        signal: composedSignal,
        method: method.toUpperCase(),
        headers: headers.normalize().toJSON(),
        body: data,
        duplex: "half",
        credentials: isCredentialsSupported ? withCredentials : undefined
      };
      request = isRequestSupported && new Request(url, resolvedOptions);
      let response = await (isRequestSupported ? fetch(request, fetchOptions) : fetch(url, resolvedOptions));
      const isStreamResponse = supportsResponseStream && (responseType === 'stream' || responseType === 'response');
      if (supportsResponseStream && (onDownloadProgress || isStreamResponse && unsubscribe)) {
        const options = {};
        ['status', 'statusText', 'headers'].forEach(prop => {
          options[prop] = response[prop];
        });
        const responseContentLength = _utils.default.toFiniteNumber(response.headers.get('content-length'));
        const [onProgress, flush] = onDownloadProgress && (0, _progressEventReducer.progressEventDecorator)(responseContentLength, (0, _progressEventReducer.progressEventReducer)((0, _progressEventReducer.asyncDecorator)(onDownloadProgress), true)) || [];
        response = new Response((0, _trackStream.trackStream)(response.body, DEFAULT_CHUNK_SIZE, onProgress, () => {
          flush && flush();
          unsubscribe && unsubscribe();
        }), options);
      }
      responseType = responseType || 'text';
      let responseData = await resolvers[_utils.default.findKey(resolvers, responseType) || 'text'](response, config);
      !isStreamResponse && unsubscribe && unsubscribe();
      return await new Promise((resolve, reject) => {
        (0, _settle.default)(resolve, reject, {
          data: responseData,
          headers: _AxiosHeaders.default.from(response.headers),
          status: response.status,
          statusText: response.statusText,
          config,
          request
        });
      });
    } catch (err) {
      unsubscribe && unsubscribe();
      if (err && err.name === 'TypeError' && /Load failed|fetch/i.test(err.message)) {
        throw Object.assign(new _AxiosError.default('Network Error', _AxiosError.default.ERR_NETWORK, config, request), {
          cause: err.cause || err
        });
      }
      throw _AxiosError.default.from(err, err && err.code, config, request);
    }
  };
};
const seedCache = new Map();
const getFetch = config => {
  let env = _utils.default.merge.call({
    skipUndefined: true
  }, globalFetchAPI, config ? config.env : null);
  const {
    fetch,
    Request,
    Response
  } = env;
  const seeds = [Request, Response, fetch];
  let len = seeds.length,
    i = len,
    seed,
    target,
    map = seedCache;
  while (i--) {
    seed = seeds[i];
    target = map.get(seed);
    target === undefined && map.set(seed, target = i ? new Map() : factory(env));
    map = target;
  }
  return target;
};
exports.getFetch = getFetch;
const adapter = getFetch();
var _default = exports.default = adapter;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\adapters\\fetch.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\adapters\\xhr.js", {"../cancel/CanceledError.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\cancel\\CanceledError.js","../core/AxiosError.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\AxiosError.js","../core/AxiosHeaders.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\AxiosHeaders.js","../defaults/transitional.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\defaults\\transitional.js","../helpers/parseProtocol.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\parseProtocol.js","../helpers/progressEventReducer.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\progressEventReducer.js","../helpers/resolveConfig.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\resolveConfig.js","../platform/index.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\platform\\index.js","./../core/settle.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\settle.js","./../utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Cadapters%5Cxhr.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _utils = _interopRequireDefault(require("./../utils.js"));
var _settle = _interopRequireDefault(require("./../core/settle.js"));
var _transitional = _interopRequireDefault(require("../defaults/transitional.js"));
var _AxiosError = _interopRequireDefault(require("../core/AxiosError.js"));
var _CanceledError = _interopRequireDefault(require("../cancel/CanceledError.js"));
var _parseProtocol = _interopRequireDefault(require("../helpers/parseProtocol.js"));
var _index = _interopRequireDefault(require("../platform/index.js"));
var _AxiosHeaders = _interopRequireDefault(require("../core/AxiosHeaders.js"));
var _progressEventReducer = require("../helpers/progressEventReducer.js");
var _resolveConfig = _interopRequireDefault(require("../helpers/resolveConfig.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const isXHRAdapterSupported = typeof XMLHttpRequest !== 'undefined';
var _default = exports.default = isXHRAdapterSupported && function (config) {
  return new Promise(function dispatchXhrRequest(resolve, reject) {
    const _config = (0, _resolveConfig.default)(config);
    let requestData = _config.data;
    const requestHeaders = _AxiosHeaders.default.from(_config.headers).normalize();
    let {
      responseType,
      onUploadProgress,
      onDownloadProgress
    } = _config;
    let onCanceled;
    let uploadThrottled, downloadThrottled;
    let flushUpload, flushDownload;
    function done() {
      flushUpload && flushUpload(); // flush events
      flushDownload && flushDownload(); // flush events

      _config.cancelToken && _config.cancelToken.unsubscribe(onCanceled);
      _config.signal && _config.signal.removeEventListener('abort', onCanceled);
    }
    let request = new XMLHttpRequest();
    request.open(_config.method.toUpperCase(), _config.url, true);

    // Set the request timeout in MS
    request.timeout = _config.timeout;
    function onloadend() {
      if (!request) {
        return;
      }
      // Prepare the response
      const responseHeaders = _AxiosHeaders.default.from('getAllResponseHeaders' in request && request.getAllResponseHeaders());
      const responseData = !responseType || responseType === 'text' || responseType === 'json' ? request.responseText : request.response;
      const response = {
        data: responseData,
        status: request.status,
        statusText: request.statusText,
        headers: responseHeaders,
        config,
        request
      };
      (0, _settle.default)(function _resolve(value) {
        resolve(value);
        done();
      }, function _reject(err) {
        reject(err);
        done();
      }, response);

      // Clean up request
      request = null;
    }
    if ('onloadend' in request) {
      // Use onloadend if available
      request.onloadend = onloadend;
    } else {
      // Listen for ready state to emulate onloadend
      request.onreadystatechange = function handleLoad() {
        if (!request || request.readyState !== 4) {
          return;
        }

        // The request errored out and we didn't get a response, this will be
        // handled by onerror instead
        // With one exception: request that using file: protocol, most browsers
        // will return status as 0 even though it's a successful request
        if (request.status === 0 && !(request.responseURL && request.responseURL.indexOf('file:') === 0)) {
          return;
        }
        // readystate handler is calling before onerror or ontimeout handlers,
        // so we should call onloadend on the next 'tick'
        setTimeout(onloadend);
      };
    }

    // Handle browser request cancellation (as opposed to a manual cancellation)
    request.onabort = function handleAbort() {
      if (!request) {
        return;
      }
      reject(new _AxiosError.default('Request aborted', _AxiosError.default.ECONNABORTED, config, request));

      // Clean up request
      request = null;
    };

    // Handle low level network errors
    request.onerror = function handleError(event) {
      // Browsers deliver a ProgressEvent in XHR onerror
      // (message may be empty; when present, surface it)
      // See https://developer.mozilla.org/docs/Web/API/XMLHttpRequest/error_event
      const msg = event && event.message ? event.message : 'Network Error';
      const err = new _AxiosError.default(msg, _AxiosError.default.ERR_NETWORK, config, request);
      // attach the underlying event for consumers who want details
      err.event = event || null;
      reject(err);
      request = null;
    };

    // Handle timeout
    request.ontimeout = function handleTimeout() {
      let timeoutErrorMessage = _config.timeout ? 'timeout of ' + _config.timeout + 'ms exceeded' : 'timeout exceeded';
      const transitional = _config.transitional || _transitional.default;
      if (_config.timeoutErrorMessage) {
        timeoutErrorMessage = _config.timeoutErrorMessage;
      }
      reject(new _AxiosError.default(timeoutErrorMessage, transitional.clarifyTimeoutError ? _AxiosError.default.ETIMEDOUT : _AxiosError.default.ECONNABORTED, config, request));

      // Clean up request
      request = null;
    };

    // Remove Content-Type if data is undefined
    requestData === undefined && requestHeaders.setContentType(null);

    // Add headers to the request
    if ('setRequestHeader' in request) {
      _utils.default.forEach(requestHeaders.toJSON(), function setRequestHeader(val, key) {
        request.setRequestHeader(key, val);
      });
    }

    // Add withCredentials to request if needed
    if (!_utils.default.isUndefined(_config.withCredentials)) {
      request.withCredentials = !!_config.withCredentials;
    }

    // Add responseType to request if needed
    if (responseType && responseType !== 'json') {
      request.responseType = _config.responseType;
    }

    // Handle progress if needed
    if (onDownloadProgress) {
      [downloadThrottled, flushDownload] = (0, _progressEventReducer.progressEventReducer)(onDownloadProgress, true);
      request.addEventListener('progress', downloadThrottled);
    }

    // Not all browsers support upload events
    if (onUploadProgress && request.upload) {
      [uploadThrottled, flushUpload] = (0, _progressEventReducer.progressEventReducer)(onUploadProgress);
      request.upload.addEventListener('progress', uploadThrottled);
      request.upload.addEventListener('loadend', flushUpload);
    }
    if (_config.cancelToken || _config.signal) {
      // Handle cancellation
      // eslint-disable-next-line func-names
      onCanceled = cancel => {
        if (!request) {
          return;
        }
        reject(!cancel || cancel.type ? new _CanceledError.default(null, config, request) : cancel);
        request.abort();
        request = null;
      };
      _config.cancelToken && _config.cancelToken.subscribe(onCanceled);
      if (_config.signal) {
        _config.signal.aborted ? onCanceled() : _config.signal.addEventListener('abort', onCanceled);
      }
    }
    const protocol = (0, _parseProtocol.default)(_config.url);
    if (protocol && _index.default.protocols.indexOf(protocol) === -1) {
      reject(new _AxiosError.default('Unsupported protocol ' + protocol + ':', _AxiosError.default.ERR_BAD_REQUEST, config));
      return;
    }

    // Send the request
    request.send(requestData || null);
  });
};

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\adapters\\xhr.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\axios.js", {"./adapters/adapters.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\adapters\\adapters.js","./cancel/CancelToken.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\cancel\\CancelToken.js","./cancel/CanceledError.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\cancel\\CanceledError.js","./cancel/isCancel.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\cancel\\isCancel.js","./core/Axios.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\Axios.js","./core/AxiosError.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\AxiosError.js","./core/AxiosHeaders.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\AxiosHeaders.js","./core/mergeConfig.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\mergeConfig.js","./defaults/index.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\defaults\\index.js","./env/data.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\env\\data.js","./helpers/HttpStatusCode.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\HttpStatusCode.js","./helpers/bind.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\bind.js","./helpers/formDataToJSON.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\formDataToJSON.js","./helpers/isAxiosError.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\isAxiosError.js","./helpers/spread.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\spread.js","./helpers/toFormData.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\toFormData.js","./utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Caxios.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _utils = _interopRequireDefault(require("./utils.js"));
var _bind = _interopRequireDefault(require("./helpers/bind.js"));
var _Axios = _interopRequireDefault(require("./core/Axios.js"));
var _mergeConfig = _interopRequireDefault(require("./core/mergeConfig.js"));
var _index = _interopRequireDefault(require("./defaults/index.js"));
var _formDataToJSON = _interopRequireDefault(require("./helpers/formDataToJSON.js"));
var _CanceledError = _interopRequireDefault(require("./cancel/CanceledError.js"));
var _CancelToken = _interopRequireDefault(require("./cancel/CancelToken.js"));
var _isCancel = _interopRequireDefault(require("./cancel/isCancel.js"));
var _data = require("./env/data.js");
var _toFormData = _interopRequireDefault(require("./helpers/toFormData.js"));
var _AxiosError = _interopRequireDefault(require("./core/AxiosError.js"));
var _spread = _interopRequireDefault(require("./helpers/spread.js"));
var _isAxiosError = _interopRequireDefault(require("./helpers/isAxiosError.js"));
var _AxiosHeaders = _interopRequireDefault(require("./core/AxiosHeaders.js"));
var _adapters = _interopRequireDefault(require("./adapters/adapters.js"));
var _HttpStatusCode = _interopRequireDefault(require("./helpers/HttpStatusCode.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Create an instance of Axios
 *
 * @param {Object} defaultConfig The default config for the instance
 *
 * @returns {Axios} A new instance of Axios
 */
function createInstance(defaultConfig) {
  const context = new _Axios.default(defaultConfig);
  const instance = (0, _bind.default)(_Axios.default.prototype.request, context);

  // Copy axios.prototype to instance
  _utils.default.extend(instance, _Axios.default.prototype, context, {
    allOwnKeys: true
  });

  // Copy context to instance
  _utils.default.extend(instance, context, null, {
    allOwnKeys: true
  });

  // Factory for creating new instances
  instance.create = function create(instanceConfig) {
    return createInstance((0, _mergeConfig.default)(defaultConfig, instanceConfig));
  };
  return instance;
}

// Create the default instance to be exported
const axios = createInstance(_index.default);

// Expose Axios class to allow class inheritance
axios.Axios = _Axios.default;

// Expose Cancel & CancelToken
axios.CanceledError = _CanceledError.default;
axios.CancelToken = _CancelToken.default;
axios.isCancel = _isCancel.default;
axios.VERSION = _data.VERSION;
axios.toFormData = _toFormData.default;

// Expose AxiosError class
axios.AxiosError = _AxiosError.default;

// alias for CanceledError for backward compatibility
axios.Cancel = axios.CanceledError;

// Expose all/spread
axios.all = function all(promises) {
  return Promise.all(promises);
};
axios.spread = _spread.default;

// Expose isAxiosError
axios.isAxiosError = _isAxiosError.default;

// Expose mergeConfig
axios.mergeConfig = _mergeConfig.default;
axios.AxiosHeaders = _AxiosHeaders.default;
axios.formToJSON = thing => (0, _formDataToJSON.default)(_utils.default.isHTMLForm(thing) ? new FormData(thing) : thing);
axios.getAdapter = _adapters.default.getAdapter;
axios.HttpStatusCode = _HttpStatusCode.default;
axios.default = axios;

// this module should only have a default export
var _default = exports.default = axios;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\axios.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\cancel\\CancelToken.js", {"./CanceledError.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\cancel\\CanceledError.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Ccancel%5CCancelToken.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _CanceledError = _interopRequireDefault(require("./CanceledError.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * A `CancelToken` is an object that can be used to request cancellation of an operation.
 *
 * @param {Function} executor The executor function.
 *
 * @returns {CancelToken}
 */
class CancelToken {
  constructor(executor) {
    if (typeof executor !== 'function') {
      throw new TypeError('executor must be a function.');
    }
    let resolvePromise;
    this.promise = new Promise(function promiseExecutor(resolve) {
      resolvePromise = resolve;
    });
    const token = this;

    // eslint-disable-next-line func-names
    this.promise.then(cancel => {
      if (!token._listeners) return;
      let i = token._listeners.length;
      while (i-- > 0) {
        token._listeners[i](cancel);
      }
      token._listeners = null;
    });

    // eslint-disable-next-line func-names
    this.promise.then = onfulfilled => {
      let _resolve;
      // eslint-disable-next-line func-names
      const promise = new Promise(resolve => {
        token.subscribe(resolve);
        _resolve = resolve;
      }).then(onfulfilled);
      promise.cancel = function reject() {
        token.unsubscribe(_resolve);
      };
      return promise;
    };
    executor(function cancel(message, config, request) {
      if (token.reason) {
        // Cancellation has already been requested
        return;
      }
      token.reason = new _CanceledError.default(message, config, request);
      resolvePromise(token.reason);
    });
  }

  /**
   * Throws a `CanceledError` if cancellation has been requested.
   */
  throwIfRequested() {
    if (this.reason) {
      throw this.reason;
    }
  }

  /**
   * Subscribe to the cancel signal
   */

  subscribe(listener) {
    if (this.reason) {
      listener(this.reason);
      return;
    }
    if (this._listeners) {
      this._listeners.push(listener);
    } else {
      this._listeners = [listener];
    }
  }

  /**
   * Unsubscribe from the cancel signal
   */

  unsubscribe(listener) {
    if (!this._listeners) {
      return;
    }
    const index = this._listeners.indexOf(listener);
    if (index !== -1) {
      this._listeners.splice(index, 1);
    }
  }
  toAbortSignal() {
    const controller = new AbortController();
    const abort = err => {
      controller.abort(err);
    };
    this.subscribe(abort);
    controller.signal.unsubscribe = () => this.unsubscribe(abort);
    return controller.signal;
  }

  /**
   * Returns an object that contains a new `CancelToken` and a function that, when called,
   * cancels the `CancelToken`.
   */
  static source() {
    let cancel;
    const token = new CancelToken(function executor(c) {
      cancel = c;
    });
    return {
      token,
      cancel
    };
  }
}
var _default = exports.default = CancelToken;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\cancel\\CancelToken.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\cancel\\CanceledError.js", {"../core/AxiosError.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\AxiosError.js","../utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Ccancel%5CCanceledError.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _AxiosError = _interopRequireDefault(require("../core/AxiosError.js"));
var _utils = _interopRequireDefault(require("../utils.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * A `CanceledError` is an object that is thrown when an operation is canceled.
 *
 * @param {string=} message The message.
 * @param {Object=} config The config.
 * @param {Object=} request The request.
 *
 * @returns {CanceledError} The created error.
 */
function CanceledError(message, config, request) {
  // eslint-disable-next-line no-eq-null,eqeqeq
  _AxiosError.default.call(this, message == null ? 'canceled' : message, _AxiosError.default.ERR_CANCELED, config, request);
  this.name = 'CanceledError';
}
_utils.default.inherits(CanceledError, _AxiosError.default, {
  __CANCEL__: true
});
var _default = exports.default = CanceledError;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\cancel\\CanceledError.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\cancel\\isCancel.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Ccancel%5CisCancel.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = isCancel;
function isCancel(value) {
  return !!(value && value.__CANCEL__);
}

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\cancel\\isCancel.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\Axios.js", {"../helpers/buildURL.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\buildURL.js","../helpers/validator.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\validator.js","./../utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js","./AxiosHeaders.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\AxiosHeaders.js","./InterceptorManager.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\InterceptorManager.js","./buildFullPath.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\buildFullPath.js","./dispatchRequest.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\dispatchRequest.js","./mergeConfig.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\mergeConfig.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Ccore%5CAxios.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _utils = _interopRequireDefault(require("./../utils.js"));
var _buildURL = _interopRequireDefault(require("../helpers/buildURL.js"));
var _InterceptorManager = _interopRequireDefault(require("./InterceptorManager.js"));
var _dispatchRequest = _interopRequireDefault(require("./dispatchRequest.js"));
var _mergeConfig = _interopRequireDefault(require("./mergeConfig.js"));
var _buildFullPath = _interopRequireDefault(require("./buildFullPath.js"));
var _validator = _interopRequireDefault(require("../helpers/validator.js"));
var _AxiosHeaders = _interopRequireDefault(require("./AxiosHeaders.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const validators = _validator.default.validators;

/**
 * Create a new instance of Axios
 *
 * @param {Object} instanceConfig The default config for the instance
 *
 * @return {Axios} A new instance of Axios
 */
class Axios {
  constructor(instanceConfig) {
    this.defaults = instanceConfig || {};
    this.interceptors = {
      request: new _InterceptorManager.default(),
      response: new _InterceptorManager.default()
    };
  }

  /**
   * Dispatch a request
   *
   * @param {String|Object} configOrUrl The config specific for this request (merged with this.defaults)
   * @param {?Object} config
   *
   * @returns {Promise} The Promise to be fulfilled
   */
  async request(configOrUrl, config) {
    try {
      return await this._request(configOrUrl, config);
    } catch (err) {
      if (err instanceof Error) {
        let dummy = {};
        Error.captureStackTrace ? Error.captureStackTrace(dummy) : dummy = new Error();

        // slice off the Error: ... line
        const stack = dummy.stack ? dummy.stack.replace(/^.+\n/, '') : '';
        try {
          if (!err.stack) {
            err.stack = stack;
            // match without the 2 top stack lines
          } else if (stack && !String(err.stack).endsWith(stack.replace(/^.+\n.+\n/, ''))) {
            err.stack += '\n' + stack;
          }
        } catch (e) {
          // ignore the case where "stack" is an un-writable property
        }
      }
      throw err;
    }
  }
  _request(configOrUrl, config) {
    /*eslint no-param-reassign:0*/
    // Allow for axios('example/url'[, config]) a la fetch API
    if (typeof configOrUrl === 'string') {
      config = config || {};
      config.url = configOrUrl;
    } else {
      config = configOrUrl || {};
    }
    config = (0, _mergeConfig.default)(this.defaults, config);
    const {
      transitional,
      paramsSerializer,
      headers
    } = config;
    if (transitional !== undefined) {
      _validator.default.assertOptions(transitional, {
        silentJSONParsing: validators.transitional(validators.boolean),
        forcedJSONParsing: validators.transitional(validators.boolean),
        clarifyTimeoutError: validators.transitional(validators.boolean)
      }, false);
    }
    if (paramsSerializer != null) {
      if (_utils.default.isFunction(paramsSerializer)) {
        config.paramsSerializer = {
          serialize: paramsSerializer
        };
      } else {
        _validator.default.assertOptions(paramsSerializer, {
          encode: validators.function,
          serialize: validators.function
        }, true);
      }
    }

    // Set config.allowAbsoluteUrls
    if (config.allowAbsoluteUrls !== undefined) {
      // do nothing
    } else if (this.defaults.allowAbsoluteUrls !== undefined) {
      config.allowAbsoluteUrls = this.defaults.allowAbsoluteUrls;
    } else {
      config.allowAbsoluteUrls = true;
    }
    _validator.default.assertOptions(config, {
      baseUrl: validators.spelling('baseURL'),
      withXsrfToken: validators.spelling('withXSRFToken')
    }, true);

    // Set config.method
    config.method = (config.method || this.defaults.method || 'get').toLowerCase();

    // Flatten headers
    let contextHeaders = headers && _utils.default.merge(headers.common, headers[config.method]);
    headers && _utils.default.forEach(['delete', 'get', 'head', 'post', 'put', 'patch', 'common'], method => {
      delete headers[method];
    });
    config.headers = _AxiosHeaders.default.concat(contextHeaders, headers);

    // filter out skipped interceptors
    const requestInterceptorChain = [];
    let synchronousRequestInterceptors = true;
    this.interceptors.request.forEach(function unshiftRequestInterceptors(interceptor) {
      if (typeof interceptor.runWhen === 'function' && interceptor.runWhen(config) === false) {
        return;
      }
      synchronousRequestInterceptors = synchronousRequestInterceptors && interceptor.synchronous;
      requestInterceptorChain.unshift(interceptor.fulfilled, interceptor.rejected);
    });
    const responseInterceptorChain = [];
    this.interceptors.response.forEach(function pushResponseInterceptors(interceptor) {
      responseInterceptorChain.push(interceptor.fulfilled, interceptor.rejected);
    });
    let promise;
    let i = 0;
    let len;
    if (!synchronousRequestInterceptors) {
      const chain = [_dispatchRequest.default.bind(this), undefined];
      chain.unshift(...requestInterceptorChain);
      chain.push(...responseInterceptorChain);
      len = chain.length;
      promise = Promise.resolve(config);
      while (i < len) {
        promise = promise.then(chain[i++], chain[i++]);
      }
      return promise;
    }
    len = requestInterceptorChain.length;
    let newConfig = config;
    i = 0;
    while (i < len) {
      const onFulfilled = requestInterceptorChain[i++];
      const onRejected = requestInterceptorChain[i++];
      try {
        newConfig = onFulfilled(newConfig);
      } catch (error) {
        onRejected.call(this, error);
        break;
      }
    }
    try {
      promise = _dispatchRequest.default.call(this, newConfig);
    } catch (error) {
      return Promise.reject(error);
    }
    i = 0;
    len = responseInterceptorChain.length;
    while (i < len) {
      promise = promise.then(responseInterceptorChain[i++], responseInterceptorChain[i++]);
    }
    return promise;
  }
  getUri(config) {
    config = (0, _mergeConfig.default)(this.defaults, config);
    const fullPath = (0, _buildFullPath.default)(config.baseURL, config.url, config.allowAbsoluteUrls);
    return (0, _buildURL.default)(fullPath, config.params, config.paramsSerializer);
  }
}

// Provide aliases for supported request methods
_utils.default.forEach(['delete', 'get', 'head', 'options'], function forEachMethodNoData(method) {
  /*eslint func-names:0*/
  Axios.prototype[method] = function (url, config) {
    return this.request((0, _mergeConfig.default)(config || {}, {
      method,
      url,
      data: (config || {}).data
    }));
  };
});
_utils.default.forEach(['post', 'put', 'patch'], function forEachMethodWithData(method) {
  /*eslint func-names:0*/

  function generateHTTPMethod(isForm) {
    return function httpMethod(url, data, config) {
      return this.request((0, _mergeConfig.default)(config || {}, {
        method,
        headers: isForm ? {
          'Content-Type': 'multipart/form-data'
        } : {},
        url,
        data
      }));
    };
  }
  Axios.prototype[method] = generateHTTPMethod();
  Axios.prototype[method + 'Form'] = generateHTTPMethod(true);
});
var _default = exports.default = Axios;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\core\\Axios.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\AxiosError.js", {"../utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Ccore%5CAxiosError.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _utils = _interopRequireDefault(require("../utils.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Create an Error with the specified message, config, error code, request and response.
 *
 * @param {string} message The error message.
 * @param {string} [code] The error code (for example, 'ECONNABORTED').
 * @param {Object} [config] The config.
 * @param {Object} [request] The request.
 * @param {Object} [response] The response.
 *
 * @returns {Error} The created error.
 */
function AxiosError(message, code, config, request, response) {
  Error.call(this);
  if (Error.captureStackTrace) {
    Error.captureStackTrace(this, this.constructor);
  } else {
    this.stack = new Error().stack;
  }
  this.message = message;
  this.name = 'AxiosError';
  code && (this.code = code);
  config && (this.config = config);
  request && (this.request = request);
  if (response) {
    this.response = response;
    this.status = response.status ? response.status : null;
  }
}
_utils.default.inherits(AxiosError, Error, {
  toJSON: function toJSON() {
    return {
      // Standard
      message: this.message,
      name: this.name,
      // Microsoft
      description: this.description,
      number: this.number,
      // Mozilla
      fileName: this.fileName,
      lineNumber: this.lineNumber,
      columnNumber: this.columnNumber,
      stack: this.stack,
      // Axios
      config: _utils.default.toJSONObject(this.config),
      code: this.code,
      status: this.status
    };
  }
});
const prototype = AxiosError.prototype;
const descriptors = {};
['ERR_BAD_OPTION_VALUE', 'ERR_BAD_OPTION', 'ECONNABORTED', 'ETIMEDOUT', 'ERR_NETWORK', 'ERR_FR_TOO_MANY_REDIRECTS', 'ERR_DEPRECATED', 'ERR_BAD_RESPONSE', 'ERR_BAD_REQUEST', 'ERR_CANCELED', 'ERR_NOT_SUPPORT', 'ERR_INVALID_URL'
// eslint-disable-next-line func-names
].forEach(code => {
  descriptors[code] = {
    value: code
  };
});
Object.defineProperties(AxiosError, descriptors);
Object.defineProperty(prototype, 'isAxiosError', {
  value: true
});

// eslint-disable-next-line func-names
AxiosError.from = (error, code, config, request, response, customProps) => {
  const axiosError = Object.create(prototype);
  _utils.default.toFlatObject(error, axiosError, function filter(obj) {
    return obj !== Error.prototype;
  }, prop => {
    return prop !== 'isAxiosError';
  });
  const msg = error && error.message ? error.message : 'Error';

  // Prefer explicit code; otherwise copy the low-level error's code (e.g. ECONNREFUSED)
  const errCode = code == null && error ? error.code : code;
  AxiosError.call(axiosError, msg, errCode, config, request, response);

  // Chain the original error on the standard field; non-enumerable to avoid JSON noise
  if (error && axiosError.cause == null) {
    Object.defineProperty(axiosError, 'cause', {
      value: error,
      configurable: true
    });
  }
  axiosError.name = error && error.name || 'Error';
  customProps && Object.assign(axiosError, customProps);
  return axiosError;
};
var _default = exports.default = AxiosError;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\core\\AxiosError.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\AxiosHeaders.js", {"../helpers/parseHeaders.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\parseHeaders.js","../utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Ccore%5CAxiosHeaders.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _utils = _interopRequireDefault(require("../utils.js"));
var _parseHeaders = _interopRequireDefault(require("../helpers/parseHeaders.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const $internals = Symbol('internals');
function normalizeHeader(header) {
  return header && String(header).trim().toLowerCase();
}
function normalizeValue(value) {
  if (value === false || value == null) {
    return value;
  }
  return _utils.default.isArray(value) ? value.map(normalizeValue) : String(value);
}
function parseTokens(str) {
  const tokens = Object.create(null);
  const tokensRE = /([^\s,;=]+)\s*(?:=\s*([^,;]+))?/g;
  let match;
  while (match = tokensRE.exec(str)) {
    tokens[match[1]] = match[2];
  }
  return tokens;
}
const isValidHeaderName = str => /^[-_a-zA-Z0-9^`|~,!#$%&'*+.]+$/.test(str.trim());
function matchHeaderValue(context, value, header, filter, isHeaderNameFilter) {
  if (_utils.default.isFunction(filter)) {
    return filter.call(this, value, header);
  }
  if (isHeaderNameFilter) {
    value = header;
  }
  if (!_utils.default.isString(value)) return;
  if (_utils.default.isString(filter)) {
    return value.indexOf(filter) !== -1;
  }
  if (_utils.default.isRegExp(filter)) {
    return filter.test(value);
  }
}
function formatHeader(header) {
  return header.trim().toLowerCase().replace(/([a-z\d])(\w*)/g, (w, char, str) => {
    return char.toUpperCase() + str;
  });
}
function buildAccessors(obj, header) {
  const accessorName = _utils.default.toCamelCase(' ' + header);
  ['get', 'set', 'has'].forEach(methodName => {
    Object.defineProperty(obj, methodName + accessorName, {
      value: function (arg1, arg2, arg3) {
        return this[methodName].call(this, header, arg1, arg2, arg3);
      },
      configurable: true
    });
  });
}
class AxiosHeaders {
  constructor(headers) {
    headers && this.set(headers);
  }
  set(header, valueOrRewrite, rewrite) {
    const self = this;
    function setHeader(_value, _header, _rewrite) {
      const lHeader = normalizeHeader(_header);
      if (!lHeader) {
        throw new Error('header name must be a non-empty string');
      }
      const key = _utils.default.findKey(self, lHeader);
      if (!key || self[key] === undefined || _rewrite === true || _rewrite === undefined && self[key] !== false) {
        self[key || _header] = normalizeValue(_value);
      }
    }
    const setHeaders = (headers, _rewrite) => _utils.default.forEach(headers, (_value, _header) => setHeader(_value, _header, _rewrite));
    if (_utils.default.isPlainObject(header) || header instanceof this.constructor) {
      setHeaders(header, valueOrRewrite);
    } else if (_utils.default.isString(header) && (header = header.trim()) && !isValidHeaderName(header)) {
      setHeaders((0, _parseHeaders.default)(header), valueOrRewrite);
    } else if (_utils.default.isObject(header) && _utils.default.isIterable(header)) {
      let obj = {},
        dest,
        key;
      for (const entry of header) {
        if (!_utils.default.isArray(entry)) {
          throw TypeError('Object iterator must return a key-value pair');
        }
        obj[key = entry[0]] = (dest = obj[key]) ? _utils.default.isArray(dest) ? [...dest, entry[1]] : [dest, entry[1]] : entry[1];
      }
      setHeaders(obj, valueOrRewrite);
    } else {
      header != null && setHeader(valueOrRewrite, header, rewrite);
    }
    return this;
  }
  get(header, parser) {
    header = normalizeHeader(header);
    if (header) {
      const key = _utils.default.findKey(this, header);
      if (key) {
        const value = this[key];
        if (!parser) {
          return value;
        }
        if (parser === true) {
          return parseTokens(value);
        }
        if (_utils.default.isFunction(parser)) {
          return parser.call(this, value, key);
        }
        if (_utils.default.isRegExp(parser)) {
          return parser.exec(value);
        }
        throw new TypeError('parser must be boolean|regexp|function');
      }
    }
  }
  has(header, matcher) {
    header = normalizeHeader(header);
    if (header) {
      const key = _utils.default.findKey(this, header);
      return !!(key && this[key] !== undefined && (!matcher || matchHeaderValue(this, this[key], key, matcher)));
    }
    return false;
  }
  delete(header, matcher) {
    const self = this;
    let deleted = false;
    function deleteHeader(_header) {
      _header = normalizeHeader(_header);
      if (_header) {
        const key = _utils.default.findKey(self, _header);
        if (key && (!matcher || matchHeaderValue(self, self[key], key, matcher))) {
          delete self[key];
          deleted = true;
        }
      }
    }
    if (_utils.default.isArray(header)) {
      header.forEach(deleteHeader);
    } else {
      deleteHeader(header);
    }
    return deleted;
  }
  clear(matcher) {
    const keys = Object.keys(this);
    let i = keys.length;
    let deleted = false;
    while (i--) {
      const key = keys[i];
      if (!matcher || matchHeaderValue(this, this[key], key, matcher, true)) {
        delete this[key];
        deleted = true;
      }
    }
    return deleted;
  }
  normalize(format) {
    const self = this;
    const headers = {};
    _utils.default.forEach(this, (value, header) => {
      const key = _utils.default.findKey(headers, header);
      if (key) {
        self[key] = normalizeValue(value);
        delete self[header];
        return;
      }
      const normalized = format ? formatHeader(header) : String(header).trim();
      if (normalized !== header) {
        delete self[header];
      }
      self[normalized] = normalizeValue(value);
      headers[normalized] = true;
    });
    return this;
  }
  concat(...targets) {
    return this.constructor.concat(this, ...targets);
  }
  toJSON(asStrings) {
    const obj = Object.create(null);
    _utils.default.forEach(this, (value, header) => {
      value != null && value !== false && (obj[header] = asStrings && _utils.default.isArray(value) ? value.join(', ') : value);
    });
    return obj;
  }
  [Symbol.iterator]() {
    return Object.entries(this.toJSON())[Symbol.iterator]();
  }
  toString() {
    return Object.entries(this.toJSON()).map(([header, value]) => header + ': ' + value).join('\n');
  }
  getSetCookie() {
    return this.get("set-cookie") || [];
  }
  get [Symbol.toStringTag]() {
    return 'AxiosHeaders';
  }
  static from(thing) {
    return thing instanceof this ? thing : new this(thing);
  }
  static concat(first, ...targets) {
    const computed = new this(first);
    targets.forEach(target => computed.set(target));
    return computed;
  }
  static accessor(header) {
    const internals = this[$internals] = this[$internals] = {
      accessors: {}
    };
    const accessors = internals.accessors;
    const prototype = this.prototype;
    function defineAccessor(_header) {
      const lHeader = normalizeHeader(_header);
      if (!accessors[lHeader]) {
        buildAccessors(prototype, _header);
        accessors[lHeader] = true;
      }
    }
    _utils.default.isArray(header) ? header.forEach(defineAccessor) : defineAccessor(header);
    return this;
  }
}
AxiosHeaders.accessor(['Content-Type', 'Content-Length', 'Accept', 'Accept-Encoding', 'User-Agent', 'Authorization']);

// reserved names hotfix
_utils.default.reduceDescriptors(AxiosHeaders.prototype, ({
  value
}, key) => {
  let mapped = key[0].toUpperCase() + key.slice(1); // map `set` => `Set`
  return {
    get: () => value,
    set(headerValue) {
      this[mapped] = headerValue;
    }
  };
});
_utils.default.freezeMethods(AxiosHeaders);
var _default = exports.default = AxiosHeaders;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\core\\AxiosHeaders.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\InterceptorManager.js", {"./../utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Ccore%5CInterceptorManager.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _utils = _interopRequireDefault(require("./../utils.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
class InterceptorManager {
  constructor() {
    this.handlers = [];
  }

  /**
   * Add a new interceptor to the stack
   *
   * @param {Function} fulfilled The function to handle `then` for a `Promise`
   * @param {Function} rejected The function to handle `reject` for a `Promise`
   *
   * @return {Number} An ID used to remove interceptor later
   */
  use(fulfilled, rejected, options) {
    this.handlers.push({
      fulfilled,
      rejected,
      synchronous: options ? options.synchronous : false,
      runWhen: options ? options.runWhen : null
    });
    return this.handlers.length - 1;
  }

  /**
   * Remove an interceptor from the stack
   *
   * @param {Number} id The ID that was returned by `use`
   *
   * @returns {Boolean} `true` if the interceptor was removed, `false` otherwise
   */
  eject(id) {
    if (this.handlers[id]) {
      this.handlers[id] = null;
    }
  }

  /**
   * Clear all interceptors from the stack
   *
   * @returns {void}
   */
  clear() {
    if (this.handlers) {
      this.handlers = [];
    }
  }

  /**
   * Iterate over all the registered interceptors
   *
   * This method is particularly useful for skipping over any
   * interceptors that may have become `null` calling `eject`.
   *
   * @param {Function} fn The function to call for each interceptor
   *
   * @returns {void}
   */
  forEach(fn) {
    _utils.default.forEach(this.handlers, function forEachHandler(h) {
      if (h !== null) {
        fn(h);
      }
    });
  }
}
var _default = exports.default = InterceptorManager;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\core\\InterceptorManager.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\buildFullPath.js", {"../helpers/combineURLs.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\combineURLs.js","../helpers/isAbsoluteURL.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\isAbsoluteURL.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Ccore%5CbuildFullPath.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = buildFullPath;
var _isAbsoluteURL = _interopRequireDefault(require("../helpers/isAbsoluteURL.js"));
var _combineURLs = _interopRequireDefault(require("../helpers/combineURLs.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Creates a new URL by combining the baseURL with the requestedURL,
 * only when the requestedURL is not already an absolute URL.
 * If the requestURL is absolute, this function returns the requestedURL untouched.
 *
 * @param {string} baseURL The base URL
 * @param {string} requestedURL Absolute or relative URL to combine
 *
 * @returns {string} The combined full path
 */
function buildFullPath(baseURL, requestedURL, allowAbsoluteUrls) {
  let isRelativeUrl = !(0, _isAbsoluteURL.default)(requestedURL);
  if (baseURL && (isRelativeUrl || allowAbsoluteUrls == false)) {
    return (0, _combineURLs.default)(baseURL, requestedURL);
  }
  return requestedURL;
}

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\core\\buildFullPath.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\dispatchRequest.js", {"../adapters/adapters.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\adapters\\adapters.js","../cancel/CanceledError.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\cancel\\CanceledError.js","../cancel/isCancel.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\cancel\\isCancel.js","../core/AxiosHeaders.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\AxiosHeaders.js","../defaults/index.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\defaults\\index.js","./transformData.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\transformData.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Ccore%5CdispatchRequest.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = dispatchRequest;
var _transformData = _interopRequireDefault(require("./transformData.js"));
var _isCancel = _interopRequireDefault(require("../cancel/isCancel.js"));
var _index = _interopRequireDefault(require("../defaults/index.js"));
var _CanceledError = _interopRequireDefault(require("../cancel/CanceledError.js"));
var _AxiosHeaders = _interopRequireDefault(require("../core/AxiosHeaders.js"));
var _adapters = _interopRequireDefault(require("../adapters/adapters.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Throws a `CanceledError` if cancellation has been requested.
 *
 * @param {Object} config The config that is to be used for the request
 *
 * @returns {void}
 */
function throwIfCancellationRequested(config) {
  if (config.cancelToken) {
    config.cancelToken.throwIfRequested();
  }
  if (config.signal && config.signal.aborted) {
    throw new _CanceledError.default(null, config);
  }
}

/**
 * Dispatch a request to the server using the configured adapter.
 *
 * @param {object} config The config that is to be used for the request
 *
 * @returns {Promise} The Promise to be fulfilled
 */
function dispatchRequest(config) {
  throwIfCancellationRequested(config);
  config.headers = _AxiosHeaders.default.from(config.headers);

  // Transform request data
  config.data = _transformData.default.call(config, config.transformRequest);
  if (['post', 'put', 'patch'].indexOf(config.method) !== -1) {
    config.headers.setContentType('application/x-www-form-urlencoded', false);
  }
  const adapter = _adapters.default.getAdapter(config.adapter || _index.default.adapter, config);
  return adapter(config).then(function onAdapterResolution(response) {
    throwIfCancellationRequested(config);

    // Transform response data
    response.data = _transformData.default.call(config, config.transformResponse, response);
    response.headers = _AxiosHeaders.default.from(response.headers);
    return response;
  }, function onAdapterRejection(reason) {
    if (!(0, _isCancel.default)(reason)) {
      throwIfCancellationRequested(config);

      // Transform response data
      if (reason && reason.response) {
        reason.response.data = _transformData.default.call(config, config.transformResponse, reason.response);
        reason.response.headers = _AxiosHeaders.default.from(reason.response.headers);
      }
    }
    return Promise.reject(reason);
  });
}

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\core\\dispatchRequest.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\mergeConfig.js", {"../utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js","./AxiosHeaders.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\AxiosHeaders.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Ccore%5CmergeConfig.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = mergeConfig;
var _utils = _interopRequireDefault(require("../utils.js"));
var _AxiosHeaders = _interopRequireDefault(require("./AxiosHeaders.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const headersToObject = thing => thing instanceof _AxiosHeaders.default ? {
  ...thing
} : thing;

/**
 * Config-specific merge-function which creates a new config-object
 * by merging two configuration objects together.
 *
 * @param {Object} config1
 * @param {Object} config2
 *
 * @returns {Object} New object resulting from merging config2 to config1
 */
function mergeConfig(config1, config2) {
  // eslint-disable-next-line no-param-reassign
  config2 = config2 || {};
  const config = {};
  function getMergedValue(target, source, prop, caseless) {
    if (_utils.default.isPlainObject(target) && _utils.default.isPlainObject(source)) {
      return _utils.default.merge.call({
        caseless
      }, target, source);
    } else if (_utils.default.isPlainObject(source)) {
      return _utils.default.merge({}, source);
    } else if (_utils.default.isArray(source)) {
      return source.slice();
    }
    return source;
  }

  // eslint-disable-next-line consistent-return
  function mergeDeepProperties(a, b, prop, caseless) {
    if (!_utils.default.isUndefined(b)) {
      return getMergedValue(a, b, prop, caseless);
    } else if (!_utils.default.isUndefined(a)) {
      return getMergedValue(undefined, a, prop, caseless);
    }
  }

  // eslint-disable-next-line consistent-return
  function valueFromConfig2(a, b) {
    if (!_utils.default.isUndefined(b)) {
      return getMergedValue(undefined, b);
    }
  }

  // eslint-disable-next-line consistent-return
  function defaultToConfig2(a, b) {
    if (!_utils.default.isUndefined(b)) {
      return getMergedValue(undefined, b);
    } else if (!_utils.default.isUndefined(a)) {
      return getMergedValue(undefined, a);
    }
  }

  // eslint-disable-next-line consistent-return
  function mergeDirectKeys(a, b, prop) {
    if (prop in config2) {
      return getMergedValue(a, b);
    } else if (prop in config1) {
      return getMergedValue(undefined, a);
    }
  }
  const mergeMap = {
    url: valueFromConfig2,
    method: valueFromConfig2,
    data: valueFromConfig2,
    baseURL: defaultToConfig2,
    transformRequest: defaultToConfig2,
    transformResponse: defaultToConfig2,
    paramsSerializer: defaultToConfig2,
    timeout: defaultToConfig2,
    timeoutMessage: defaultToConfig2,
    withCredentials: defaultToConfig2,
    withXSRFToken: defaultToConfig2,
    adapter: defaultToConfig2,
    responseType: defaultToConfig2,
    xsrfCookieName: defaultToConfig2,
    xsrfHeaderName: defaultToConfig2,
    onUploadProgress: defaultToConfig2,
    onDownloadProgress: defaultToConfig2,
    decompress: defaultToConfig2,
    maxContentLength: defaultToConfig2,
    maxBodyLength: defaultToConfig2,
    beforeRedirect: defaultToConfig2,
    transport: defaultToConfig2,
    httpAgent: defaultToConfig2,
    httpsAgent: defaultToConfig2,
    cancelToken: defaultToConfig2,
    socketPath: defaultToConfig2,
    responseEncoding: defaultToConfig2,
    validateStatus: mergeDirectKeys,
    headers: (a, b, prop) => mergeDeepProperties(headersToObject(a), headersToObject(b), prop, true)
  };
  _utils.default.forEach(Object.keys({
    ...config1,
    ...config2
  }), function computeConfigValue(prop) {
    const merge = mergeMap[prop] || mergeDeepProperties;
    const configValue = merge(config1[prop], config2[prop], prop);
    _utils.default.isUndefined(configValue) && merge !== mergeDirectKeys || (config[prop] = configValue);
  });
  return config;
}

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\core\\mergeConfig.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\settle.js", {"./AxiosError.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\AxiosError.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Ccore%5Csettle.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = settle;
var _AxiosError = _interopRequireDefault(require("./AxiosError.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Resolve or reject a Promise based on response status.
 *
 * @param {Function} resolve A function that resolves the promise.
 * @param {Function} reject A function that rejects the promise.
 * @param {object} response The response.
 *
 * @returns {object} The response.
 */
function settle(resolve, reject, response) {
  const validateStatus = response.config.validateStatus;
  if (!response.status || !validateStatus || validateStatus(response.status)) {
    resolve(response);
  } else {
    reject(new _AxiosError.default('Request failed with status code ' + response.status, [_AxiosError.default.ERR_BAD_REQUEST, _AxiosError.default.ERR_BAD_RESPONSE][Math.floor(response.status / 100) - 4], response.config, response.request, response));
  }
}

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\core\\settle.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\transformData.js", {"../core/AxiosHeaders.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\AxiosHeaders.js","../defaults/index.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\defaults\\index.js","./../utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Ccore%5CtransformData.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = transformData;
var _utils = _interopRequireDefault(require("./../utils.js"));
var _index = _interopRequireDefault(require("../defaults/index.js"));
var _AxiosHeaders = _interopRequireDefault(require("../core/AxiosHeaders.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Transform the data for a request or a response
 *
 * @param {Array|Function} fns A single function or Array of functions
 * @param {?Object} response The response object
 *
 * @returns {*} The resulting transformed data
 */
function transformData(fns, response) {
  const config = this || _index.default;
  const context = response || config;
  const headers = _AxiosHeaders.default.from(context.headers);
  let data = context.data;
  _utils.default.forEach(fns, function transform(fn) {
    data = fn.call(config, data, headers.normalize(), response ? response.status : undefined);
  });
  headers.normalize();
  return data;
}

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\core\\transformData.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\defaults\\index.js", {"../core/AxiosError.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\AxiosError.js","../helpers/formDataToJSON.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\formDataToJSON.js","../helpers/toFormData.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\toFormData.js","../helpers/toURLEncodedForm.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\toURLEncodedForm.js","../platform/index.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\platform\\index.js","../utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js","./transitional.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\defaults\\transitional.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Cdefaults%5Cindex.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _utils = _interopRequireDefault(require("../utils.js"));
var _AxiosError = _interopRequireDefault(require("../core/AxiosError.js"));
var _transitional = _interopRequireDefault(require("./transitional.js"));
var _toFormData = _interopRequireDefault(require("../helpers/toFormData.js"));
var _toURLEncodedForm = _interopRequireDefault(require("../helpers/toURLEncodedForm.js"));
var _index = _interopRequireDefault(require("../platform/index.js"));
var _formDataToJSON = _interopRequireDefault(require("../helpers/formDataToJSON.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * It takes a string, tries to parse it, and if it fails, it returns the stringified version
 * of the input
 *
 * @param {any} rawValue - The value to be stringified.
 * @param {Function} parser - A function that parses a string into a JavaScript object.
 * @param {Function} encoder - A function that takes a value and returns a string.
 *
 * @returns {string} A stringified version of the rawValue.
 */
function stringifySafely(rawValue, parser, encoder) {
  if (_utils.default.isString(rawValue)) {
    try {
      (parser || JSON.parse)(rawValue);
      return _utils.default.trim(rawValue);
    } catch (e) {
      if (e.name !== 'SyntaxError') {
        throw e;
      }
    }
  }
  return (encoder || JSON.stringify)(rawValue);
}
const defaults = {
  transitional: _transitional.default,
  adapter: ['xhr', 'http', 'fetch'],
  transformRequest: [function transformRequest(data, headers) {
    const contentType = headers.getContentType() || '';
    const hasJSONContentType = contentType.indexOf('application/json') > -1;
    const isObjectPayload = _utils.default.isObject(data);
    if (isObjectPayload && _utils.default.isHTMLForm(data)) {
      data = new FormData(data);
    }
    const isFormData = _utils.default.isFormData(data);
    if (isFormData) {
      return hasJSONContentType ? JSON.stringify((0, _formDataToJSON.default)(data)) : data;
    }
    if (_utils.default.isArrayBuffer(data) || _utils.default.isBuffer(data) || _utils.default.isStream(data) || _utils.default.isFile(data) || _utils.default.isBlob(data) || _utils.default.isReadableStream(data)) {
      return data;
    }
    if (_utils.default.isArrayBufferView(data)) {
      return data.buffer;
    }
    if (_utils.default.isURLSearchParams(data)) {
      headers.setContentType('application/x-www-form-urlencoded;charset=utf-8', false);
      return data.toString();
    }
    let isFileList;
    if (isObjectPayload) {
      if (contentType.indexOf('application/x-www-form-urlencoded') > -1) {
        return (0, _toURLEncodedForm.default)(data, this.formSerializer).toString();
      }
      if ((isFileList = _utils.default.isFileList(data)) || contentType.indexOf('multipart/form-data') > -1) {
        const _FormData = this.env && this.env.FormData;
        return (0, _toFormData.default)(isFileList ? {
          'files[]': data
        } : data, _FormData && new _FormData(), this.formSerializer);
      }
    }
    if (isObjectPayload || hasJSONContentType) {
      headers.setContentType('application/json', false);
      return stringifySafely(data);
    }
    return data;
  }],
  transformResponse: [function transformResponse(data) {
    const transitional = this.transitional || defaults.transitional;
    const forcedJSONParsing = transitional && transitional.forcedJSONParsing;
    const JSONRequested = this.responseType === 'json';
    if (_utils.default.isResponse(data) || _utils.default.isReadableStream(data)) {
      return data;
    }
    if (data && _utils.default.isString(data) && (forcedJSONParsing && !this.responseType || JSONRequested)) {
      const silentJSONParsing = transitional && transitional.silentJSONParsing;
      const strictJSONParsing = !silentJSONParsing && JSONRequested;
      try {
        return JSON.parse(data, this.parseReviver);
      } catch (e) {
        if (strictJSONParsing) {
          if (e.name === 'SyntaxError') {
            throw _AxiosError.default.from(e, _AxiosError.default.ERR_BAD_RESPONSE, this, null, this.response);
          }
          throw e;
        }
      }
    }
    return data;
  }],
  /**
   * A timeout in milliseconds to abort a request. If set to 0 (default) a
   * timeout is not created.
   */
  timeout: 0,
  xsrfCookieName: 'XSRF-TOKEN',
  xsrfHeaderName: 'X-XSRF-TOKEN',
  maxContentLength: -1,
  maxBodyLength: -1,
  env: {
    FormData: _index.default.classes.FormData,
    Blob: _index.default.classes.Blob
  },
  validateStatus: function validateStatus(status) {
    return status >= 200 && status < 300;
  },
  headers: {
    common: {
      'Accept': 'application/json, text/plain, */*',
      'Content-Type': undefined
    }
  }
};
_utils.default.forEach(['delete', 'get', 'head', 'post', 'put', 'patch'], method => {
  defaults.headers[method] = {};
});
var _default = exports.default = defaults;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\defaults\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\defaults\\transitional.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Cdefaults%5Ctransitional.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default = exports.default = {
  silentJSONParsing: true,
  forcedJSONParsing: true,
  clarifyTimeoutError: false
};

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\defaults\\transitional.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\env\\data.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Cenv%5Cdata.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VERSION = void 0;
const VERSION = exports.VERSION = "1.12.0";

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\env\\data.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\AxiosURLSearchParams.js", {"./toFormData.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\toFormData.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5CAxiosURLSearchParams.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _toFormData = _interopRequireDefault(require("./toFormData.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * It encodes a string by replacing all characters that are not in the unreserved set with
 * their percent-encoded equivalents
 *
 * @param {string} str - The string to encode.
 *
 * @returns {string} The encoded string.
 */
function encode(str) {
  const charMap = {
    '!': '%21',
    "'": '%27',
    '(': '%28',
    ')': '%29',
    '~': '%7E',
    '%20': '+',
    '%00': '\x00'
  };
  return encodeURIComponent(str).replace(/[!'()~]|%20|%00/g, function replacer(match) {
    return charMap[match];
  });
}

/**
 * It takes a params object and converts it to a FormData object
 *
 * @param {Object<string, any>} params - The parameters to be converted to a FormData object.
 * @param {Object<string, any>} options - The options object passed to the Axios constructor.
 *
 * @returns {void}
 */
function AxiosURLSearchParams(params, options) {
  this._pairs = [];
  params && (0, _toFormData.default)(params, this, options);
}
const prototype = AxiosURLSearchParams.prototype;
prototype.append = function append(name, value) {
  this._pairs.push([name, value]);
};
prototype.toString = function toString(encoder) {
  const _encode = encoder ? function (value) {
    return encoder.call(this, value, encode);
  } : encode;
  return this._pairs.map(function each(pair) {
    return _encode(pair[0]) + '=' + _encode(pair[1]);
  }, '').join('&');
};
var _default = exports.default = AxiosURLSearchParams;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\AxiosURLSearchParams.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\HttpStatusCode.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5CHttpStatusCode.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
const HttpStatusCode = {
  Continue: 100,
  SwitchingProtocols: 101,
  Processing: 102,
  EarlyHints: 103,
  Ok: 200,
  Created: 201,
  Accepted: 202,
  NonAuthoritativeInformation: 203,
  NoContent: 204,
  ResetContent: 205,
  PartialContent: 206,
  MultiStatus: 207,
  AlreadyReported: 208,
  ImUsed: 226,
  MultipleChoices: 300,
  MovedPermanently: 301,
  Found: 302,
  SeeOther: 303,
  NotModified: 304,
  UseProxy: 305,
  Unused: 306,
  TemporaryRedirect: 307,
  PermanentRedirect: 308,
  BadRequest: 400,
  Unauthorized: 401,
  PaymentRequired: 402,
  Forbidden: 403,
  NotFound: 404,
  MethodNotAllowed: 405,
  NotAcceptable: 406,
  ProxyAuthenticationRequired: 407,
  RequestTimeout: 408,
  Conflict: 409,
  Gone: 410,
  LengthRequired: 411,
  PreconditionFailed: 412,
  PayloadTooLarge: 413,
  UriTooLong: 414,
  UnsupportedMediaType: 415,
  RangeNotSatisfiable: 416,
  ExpectationFailed: 417,
  ImATeapot: 418,
  MisdirectedRequest: 421,
  UnprocessableEntity: 422,
  Locked: 423,
  FailedDependency: 424,
  TooEarly: 425,
  UpgradeRequired: 426,
  PreconditionRequired: 428,
  TooManyRequests: 429,
  RequestHeaderFieldsTooLarge: 431,
  UnavailableForLegalReasons: 451,
  InternalServerError: 500,
  NotImplemented: 501,
  BadGateway: 502,
  ServiceUnavailable: 503,
  GatewayTimeout: 504,
  HttpVersionNotSupported: 505,
  VariantAlsoNegotiates: 506,
  InsufficientStorage: 507,
  LoopDetected: 508,
  NotExtended: 510,
  NetworkAuthenticationRequired: 511
};
Object.entries(HttpStatusCode).forEach(([key, value]) => {
  HttpStatusCode[value] = key;
});
var _default = exports.default = HttpStatusCode;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\HttpStatusCode.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\bind.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5Cbind.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = bind;
function bind(fn, thisArg) {
  return function wrap() {
    return fn.apply(thisArg, arguments);
  };
}

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\bind.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\buildURL.js", {"../helpers/AxiosURLSearchParams.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\AxiosURLSearchParams.js","../utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5CbuildURL.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = buildURL;
var _utils = _interopRequireDefault(require("../utils.js"));
var _AxiosURLSearchParams = _interopRequireDefault(require("../helpers/AxiosURLSearchParams.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * It replaces all instances of the characters `:`, `$`, `,`, `+`, `[`, and `]` with their
 * URI encoded counterparts
 *
 * @param {string} val The value to be encoded.
 *
 * @returns {string} The encoded value.
 */
function encode(val) {
  return encodeURIComponent(val).replace(/%3A/gi, ':').replace(/%24/g, '$').replace(/%2C/gi, ',').replace(/%20/g, '+');
}

/**
 * Build a URL by appending params to the end
 *
 * @param {string} url The base of the url (e.g., http://www.google.com)
 * @param {object} [params] The params to be appended
 * @param {?(object|Function)} options
 *
 * @returns {string} The formatted url
 */
function buildURL(url, params, options) {
  /*eslint no-param-reassign:0*/
  if (!params) {
    return url;
  }
  const _encode = options && options.encode || encode;
  if (_utils.default.isFunction(options)) {
    options = {
      serialize: options
    };
  }
  const serializeFn = options && options.serialize;
  let serializedParams;
  if (serializeFn) {
    serializedParams = serializeFn(params, options);
  } else {
    serializedParams = _utils.default.isURLSearchParams(params) ? params.toString() : new _AxiosURLSearchParams.default(params, options).toString(_encode);
  }
  if (serializedParams) {
    const hashmarkIndex = url.indexOf("#");
    if (hashmarkIndex !== -1) {
      url = url.slice(0, hashmarkIndex);
    }
    url += (url.indexOf('?') === -1 ? '?' : '&') + serializedParams;
  }
  return url;
}

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\buildURL.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\combineURLs.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5CcombineURLs.js
      return function (require, module, exports) {
'use strict';

/**
 * Creates a new URL by combining the specified URLs
 *
 * @param {string} baseURL The base URL
 * @param {string} relativeURL The relative URL
 *
 * @returns {string} The combined URL
 */
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = combineURLs;
function combineURLs(baseURL, relativeURL) {
  return relativeURL ? baseURL.replace(/\/?\/$/, '') + '/' + relativeURL.replace(/^\/+/, '') : baseURL;
}

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\combineURLs.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\composeSignals.js", {"../cancel/CanceledError.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\cancel\\CanceledError.js","../core/AxiosError.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\AxiosError.js","../utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5CcomposeSignals.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _CanceledError = _interopRequireDefault(require("../cancel/CanceledError.js"));
var _AxiosError = _interopRequireDefault(require("../core/AxiosError.js"));
var _utils = _interopRequireDefault(require("../utils.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const composeSignals = (signals, timeout) => {
  const {
    length
  } = signals = signals ? signals.filter(Boolean) : [];
  if (timeout || length) {
    let controller = new AbortController();
    let aborted;
    const onabort = function (reason) {
      if (!aborted) {
        aborted = true;
        unsubscribe();
        const err = reason instanceof Error ? reason : this.reason;
        controller.abort(err instanceof _AxiosError.default ? err : new _CanceledError.default(err instanceof Error ? err.message : err));
      }
    };
    let timer = timeout && setTimeout(() => {
      timer = null;
      onabort(new _AxiosError.default(`timeout ${timeout} of ms exceeded`, _AxiosError.default.ETIMEDOUT));
    }, timeout);
    const unsubscribe = () => {
      if (signals) {
        timer && clearTimeout(timer);
        timer = null;
        signals.forEach(signal => {
          signal.unsubscribe ? signal.unsubscribe(onabort) : signal.removeEventListener('abort', onabort);
        });
        signals = null;
      }
    };
    signals.forEach(signal => signal.addEventListener('abort', onabort));
    const {
      signal
    } = controller;
    signal.unsubscribe = () => _utils.default.asap(unsubscribe);
    return signal;
  }
};
var _default = exports.default = composeSignals;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\composeSignals.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\cookies.js", {"../platform/index.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\platform\\index.js","./../utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5Ccookies.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _utils = _interopRequireDefault(require("./../utils.js"));
var _index = _interopRequireDefault(require("../platform/index.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = _index.default.hasStandardBrowserEnv ?
// Standard browser envs support document.cookie
{
  write(name, value, expires, path, domain, secure) {
    const cookie = [name + '=' + encodeURIComponent(value)];
    _utils.default.isNumber(expires) && cookie.push('expires=' + new Date(expires).toGMTString());
    _utils.default.isString(path) && cookie.push('path=' + path);
    _utils.default.isString(domain) && cookie.push('domain=' + domain);
    secure === true && cookie.push('secure');
    document.cookie = cookie.join('; ');
  },
  read(name) {
    const match = document.cookie.match(new RegExp('(^|;\\s*)(' + name + ')=([^;]*)'));
    return match ? decodeURIComponent(match[3]) : null;
  },
  remove(name) {
    this.write(name, '', Date.now() - 86400000);
  }
} :
// Non-standard browser env (web workers, react-native) lack needed support.
{
  write() {},
  read() {
    return null;
  },
  remove() {}
};

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\cookies.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\formDataToJSON.js", {"../utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5CformDataToJSON.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _utils = _interopRequireDefault(require("../utils.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * It takes a string like `foo[x][y][z]` and returns an array like `['foo', 'x', 'y', 'z']
 *
 * @param {string} name - The name of the property to get.
 *
 * @returns An array of strings.
 */
function parsePropPath(name) {
  // foo[x][y][z]
  // foo.x.y.z
  // foo-x-y-z
  // foo x y z
  return _utils.default.matchAll(/\w+|\[(\w*)]/g, name).map(match => {
    return match[0] === '[]' ? '' : match[1] || match[0];
  });
}

/**
 * Convert an array to an object.
 *
 * @param {Array<any>} arr - The array to convert to an object.
 *
 * @returns An object with the same keys and values as the array.
 */
function arrayToObject(arr) {
  const obj = {};
  const keys = Object.keys(arr);
  let i;
  const len = keys.length;
  let key;
  for (i = 0; i < len; i++) {
    key = keys[i];
    obj[key] = arr[key];
  }
  return obj;
}

/**
 * It takes a FormData object and returns a JavaScript object
 *
 * @param {string} formData The FormData object to convert to JSON.
 *
 * @returns {Object<string, any> | null} The converted object.
 */
function formDataToJSON(formData) {
  function buildPath(path, value, target, index) {
    let name = path[index++];
    if (name === '__proto__') return true;
    const isNumericKey = Number.isFinite(+name);
    const isLast = index >= path.length;
    name = !name && _utils.default.isArray(target) ? target.length : name;
    if (isLast) {
      if (_utils.default.hasOwnProp(target, name)) {
        target[name] = [target[name], value];
      } else {
        target[name] = value;
      }
      return !isNumericKey;
    }
    if (!target[name] || !_utils.default.isObject(target[name])) {
      target[name] = [];
    }
    const result = buildPath(path, value, target[name], index);
    if (result && _utils.default.isArray(target[name])) {
      target[name] = arrayToObject(target[name]);
    }
    return !isNumericKey;
  }
  if (_utils.default.isFormData(formData) && _utils.default.isFunction(formData.entries)) {
    const obj = {};
    _utils.default.forEachEntry(formData, (name, value) => {
      buildPath(parsePropPath(name), value, obj, 0);
    });
    return obj;
  }
  return null;
}
var _default = exports.default = formDataToJSON;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\formDataToJSON.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\isAbsoluteURL.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5CisAbsoluteURL.js
      return function (require, module, exports) {
'use strict';

/**
 * Determines whether the specified URL is absolute
 *
 * @param {string} url The URL to test
 *
 * @returns {boolean} True if the specified URL is absolute, otherwise false
 */
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = isAbsoluteURL;
function isAbsoluteURL(url) {
  // A URL is considered absolute if it begins with "<scheme>://" or "//" (protocol-relative URL).
  // RFC 3986 defines scheme name as a sequence of characters beginning with a letter and followed
  // by any combination of letters, digits, plus, period, or hyphen.
  return /^([a-z][a-z\d+\-.]*:)?\/\//i.test(url);
}

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\isAbsoluteURL.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\isAxiosError.js", {"./../utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5CisAxiosError.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = isAxiosError;
var _utils = _interopRequireDefault(require("./../utils.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Determines whether the payload is an error thrown by Axios
 *
 * @param {*} payload The value to test
 *
 * @returns {boolean} True if the payload is an error thrown by Axios, otherwise false
 */
function isAxiosError(payload) {
  return _utils.default.isObject(payload) && payload.isAxiosError === true;
}

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\isAxiosError.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\isURLSameOrigin.js", {"../platform/index.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\platform\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5CisURLSameOrigin.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _index = _interopRequireDefault(require("../platform/index.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = _index.default.hasStandardBrowserEnv ? ((origin, isMSIE) => url => {
  url = new URL(url, _index.default.origin);
  return origin.protocol === url.protocol && origin.host === url.host && (isMSIE || origin.port === url.port);
})(new URL(_index.default.origin), _index.default.navigator && /(msie|trident)/i.test(_index.default.navigator.userAgent)) : () => true;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\isURLSameOrigin.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\null.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5Cnull.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
// eslint-disable-next-line strict
var _default = exports.default = null;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\null.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\parseHeaders.js", {"./../utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5CparseHeaders.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _utils = _interopRequireDefault(require("./../utils.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// RawAxiosHeaders whose duplicates are ignored by node
// c.f. https://nodejs.org/api/http.html#http_message_headers
const ignoreDuplicateOf = _utils.default.toObjectSet(['age', 'authorization', 'content-length', 'content-type', 'etag', 'expires', 'from', 'host', 'if-modified-since', 'if-unmodified-since', 'last-modified', 'location', 'max-forwards', 'proxy-authorization', 'referer', 'retry-after', 'user-agent']);

/**
 * Parse headers into an object
 *
 * ```
 * Date: Wed, 27 Aug 2014 08:58:49 GMT
 * Content-Type: application/json
 * Connection: keep-alive
 * Transfer-Encoding: chunked
 * ```
 *
 * @param {String} rawHeaders Headers needing to be parsed
 *
 * @returns {Object} Headers parsed into an object
 */
var _default = rawHeaders => {
  const parsed = {};
  let key;
  let val;
  let i;
  rawHeaders && rawHeaders.split('\n').forEach(function parser(line) {
    i = line.indexOf(':');
    key = line.substring(0, i).trim().toLowerCase();
    val = line.substring(i + 1).trim();
    if (!key || parsed[key] && ignoreDuplicateOf[key]) {
      return;
    }
    if (key === 'set-cookie') {
      if (parsed[key]) {
        parsed[key].push(val);
      } else {
        parsed[key] = [val];
      }
    } else {
      parsed[key] = parsed[key] ? parsed[key] + ', ' + val : val;
    }
  });
  return parsed;
};
exports.default = _default;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\parseHeaders.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\parseProtocol.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5CparseProtocol.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = parseProtocol;
function parseProtocol(url) {
  const match = /^([-+\w]{1,25})(:?\/\/|:)/.exec(url);
  return match && match[1] || '';
}

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\parseProtocol.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\progressEventReducer.js", {"../utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js","./speedometer.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\speedometer.js","./throttle.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\throttle.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5CprogressEventReducer.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.progressEventReducer = exports.progressEventDecorator = exports.asyncDecorator = void 0;
var _speedometer2 = _interopRequireDefault(require("./speedometer.js"));
var _throttle = _interopRequireDefault(require("./throttle.js"));
var _utils = _interopRequireDefault(require("../utils.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const progressEventReducer = (listener, isDownloadStream, freq = 3) => {
  let bytesNotified = 0;
  const _speedometer = (0, _speedometer2.default)(50, 250);
  return (0, _throttle.default)(e => {
    const loaded = e.loaded;
    const total = e.lengthComputable ? e.total : undefined;
    const progressBytes = loaded - bytesNotified;
    const rate = _speedometer(progressBytes);
    const inRange = loaded <= total;
    bytesNotified = loaded;
    const data = {
      loaded,
      total,
      progress: total ? loaded / total : undefined,
      bytes: progressBytes,
      rate: rate ? rate : undefined,
      estimated: rate && total && inRange ? (total - loaded) / rate : undefined,
      event: e,
      lengthComputable: total != null,
      [isDownloadStream ? 'download' : 'upload']: true
    };
    listener(data);
  }, freq);
};
exports.progressEventReducer = progressEventReducer;
const progressEventDecorator = (total, throttled) => {
  const lengthComputable = total != null;
  return [loaded => throttled[0]({
    lengthComputable,
    total,
    loaded
  }), throttled[1]];
};
exports.progressEventDecorator = progressEventDecorator;
const asyncDecorator = fn => (...args) => _utils.default.asap(() => fn(...args));
exports.asyncDecorator = asyncDecorator;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\progressEventReducer.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\resolveConfig.js", {"../core/AxiosHeaders.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\AxiosHeaders.js","../core/buildFullPath.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\buildFullPath.js","../core/mergeConfig.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\mergeConfig.js","../platform/index.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\platform\\index.js","../utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js","./buildURL.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\buildURL.js","./cookies.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\cookies.js","./isURLSameOrigin.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\isURLSameOrigin.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5CresolveConfig.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _index = _interopRequireDefault(require("../platform/index.js"));
var _utils = _interopRequireDefault(require("../utils.js"));
var _isURLSameOrigin = _interopRequireDefault(require("./isURLSameOrigin.js"));
var _cookies = _interopRequireDefault(require("./cookies.js"));
var _buildFullPath = _interopRequireDefault(require("../core/buildFullPath.js"));
var _mergeConfig = _interopRequireDefault(require("../core/mergeConfig.js"));
var _AxiosHeaders = _interopRequireDefault(require("../core/AxiosHeaders.js"));
var _buildURL = _interopRequireDefault(require("./buildURL.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = config => {
  const newConfig = (0, _mergeConfig.default)({}, config);
  let {
    data,
    withXSRFToken,
    xsrfHeaderName,
    xsrfCookieName,
    headers,
    auth
  } = newConfig;
  newConfig.headers = headers = _AxiosHeaders.default.from(headers);
  newConfig.url = (0, _buildURL.default)((0, _buildFullPath.default)(newConfig.baseURL, newConfig.url, newConfig.allowAbsoluteUrls), config.params, config.paramsSerializer);

  // HTTP basic authentication
  if (auth) {
    headers.set('Authorization', 'Basic ' + btoa((auth.username || '') + ':' + (auth.password ? unescape(encodeURIComponent(auth.password)) : '')));
  }
  if (_utils.default.isFormData(data)) {
    if (_index.default.hasStandardBrowserEnv || _index.default.hasStandardBrowserWebWorkerEnv) {
      headers.setContentType(undefined); // browser handles it
    } else if (_utils.default.isFunction(data.getHeaders)) {
      // Node.js FormData (like form-data package)
      const formHeaders = data.getHeaders();
      // Only set safe headers to avoid overwriting security headers
      const allowedHeaders = ['content-type', 'content-length'];
      Object.entries(formHeaders).forEach(([key, val]) => {
        if (allowedHeaders.includes(key.toLowerCase())) {
          headers.set(key, val);
        }
      });
    }
  }

  // Add xsrf header
  // This is only done if running in a standard browser environment.
  // Specifically not if we're in a web worker, or react-native.

  if (_index.default.hasStandardBrowserEnv) {
    withXSRFToken && _utils.default.isFunction(withXSRFToken) && (withXSRFToken = withXSRFToken(newConfig));
    if (withXSRFToken || withXSRFToken !== false && (0, _isURLSameOrigin.default)(newConfig.url)) {
      // Add xsrf header
      const xsrfValue = xsrfHeaderName && xsrfCookieName && _cookies.default.read(xsrfCookieName);
      if (xsrfValue) {
        headers.set(xsrfHeaderName, xsrfValue);
      }
    }
  }
  return newConfig;
};
exports.default = _default;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\resolveConfig.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\speedometer.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5Cspeedometer.js
      return function (require, module, exports) {
'use strict';

/**
 * Calculate data maxRate
 * @param {Number} [samplesCount= 10]
 * @param {Number} [min= 1000]
 * @returns {Function}
 */
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
function speedometer(samplesCount, min) {
  samplesCount = samplesCount || 10;
  const bytes = new Array(samplesCount);
  const timestamps = new Array(samplesCount);
  let head = 0;
  let tail = 0;
  let firstSampleTS;
  min = min !== undefined ? min : 1000;
  return function push(chunkLength) {
    const now = Date.now();
    const startedAt = timestamps[tail];
    if (!firstSampleTS) {
      firstSampleTS = now;
    }
    bytes[head] = chunkLength;
    timestamps[head] = now;
    let i = tail;
    let bytesCount = 0;
    while (i !== head) {
      bytesCount += bytes[i++];
      i = i % samplesCount;
    }
    head = (head + 1) % samplesCount;
    if (head === tail) {
      tail = (tail + 1) % samplesCount;
    }
    if (now - firstSampleTS < min) {
      return;
    }
    const passed = startedAt && now - startedAt;
    return passed ? Math.round(bytesCount * 1000 / passed) : undefined;
  };
}
var _default = exports.default = speedometer;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\speedometer.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\spread.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5Cspread.js
      return function (require, module, exports) {
'use strict';

/**
 * Syntactic sugar for invoking a function and expanding an array for arguments.
 *
 * Common use case would be to use `Function.prototype.apply`.
 *
 *  ```js
 *  function f(x, y, z) {}
 *  var args = [1, 2, 3];
 *  f.apply(null, args);
 *  ```
 *
 * With `spread` this example can be re-written.
 *
 *  ```js
 *  spread(function(x, y, z) {})([1, 2, 3]);
 *  ```
 *
 * @param {Function} callback
 *
 * @returns {Function}
 */
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = spread;
function spread(callback) {
  return function wrap(arr) {
    return callback.apply(null, arr);
  };
}

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\spread.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\throttle.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5Cthrottle.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
/**
 * Throttle decorator
 * @param {Function} fn
 * @param {Number} freq
 * @return {Function}
 */
function throttle(fn, freq) {
  let timestamp = 0;
  let threshold = 1000 / freq;
  let lastArgs;
  let timer;
  const invoke = (args, now = Date.now()) => {
    timestamp = now;
    lastArgs = null;
    if (timer) {
      clearTimeout(timer);
      timer = null;
    }
    fn(...args);
  };
  const throttled = (...args) => {
    const now = Date.now();
    const passed = now - timestamp;
    if (passed >= threshold) {
      invoke(args, now);
    } else {
      lastArgs = args;
      if (!timer) {
        timer = setTimeout(() => {
          timer = null;
          invoke(lastArgs);
        }, threshold - passed);
      }
    }
  };
  const flush = () => lastArgs && invoke(lastArgs);
  return [throttled, flush];
}
var _default = exports.default = throttle;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\throttle.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\toFormData.js", {"../core/AxiosError.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\AxiosError.js","../platform/node/classes/FormData.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\null.js","../utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5CtoFormData.js
      return function (require, module, exports) {
(function (Buffer){(function (){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _utils = _interopRequireDefault(require("../utils.js"));
var _AxiosError = _interopRequireDefault(require("../core/AxiosError.js"));
var _FormData = _interopRequireDefault(require("../platform/node/classes/FormData.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// temporary hotfix to avoid circular references until AxiosURLSearchParams is refactored

/**
 * Determines if the given thing is a array or js object.
 *
 * @param {string} thing - The object or array to be visited.
 *
 * @returns {boolean}
 */
function isVisitable(thing) {
  return _utils.default.isPlainObject(thing) || _utils.default.isArray(thing);
}

/**
 * It removes the brackets from the end of a string
 *
 * @param {string} key - The key of the parameter.
 *
 * @returns {string} the key without the brackets.
 */
function removeBrackets(key) {
  return _utils.default.endsWith(key, '[]') ? key.slice(0, -2) : key;
}

/**
 * It takes a path, a key, and a boolean, and returns a string
 *
 * @param {string} path - The path to the current key.
 * @param {string} key - The key of the current object being iterated over.
 * @param {string} dots - If true, the key will be rendered with dots instead of brackets.
 *
 * @returns {string} The path to the current key.
 */
function renderKey(path, key, dots) {
  if (!path) return key;
  return path.concat(key).map(function each(token, i) {
    // eslint-disable-next-line no-param-reassign
    token = removeBrackets(token);
    return !dots && i ? '[' + token + ']' : token;
  }).join(dots ? '.' : '');
}

/**
 * If the array is an array and none of its elements are visitable, then it's a flat array.
 *
 * @param {Array<any>} arr - The array to check
 *
 * @returns {boolean}
 */
function isFlatArray(arr) {
  return _utils.default.isArray(arr) && !arr.some(isVisitable);
}
const predicates = _utils.default.toFlatObject(_utils.default, {}, null, function filter(prop) {
  return /^is[A-Z]/.test(prop);
});

/**
 * Convert a data object to FormData
 *
 * @param {Object} obj
 * @param {?Object} [formData]
 * @param {?Object} [options]
 * @param {Function} [options.visitor]
 * @param {Boolean} [options.metaTokens = true]
 * @param {Boolean} [options.dots = false]
 * @param {?Boolean} [options.indexes = false]
 *
 * @returns {Object}
 **/

/**
 * It converts an object into a FormData object
 *
 * @param {Object<any, any>} obj - The object to convert to form data.
 * @param {string} formData - The FormData object to append to.
 * @param {Object<string, any>} options
 *
 * @returns
 */
function toFormData(obj, formData, options) {
  if (!_utils.default.isObject(obj)) {
    throw new TypeError('target must be an object');
  }

  // eslint-disable-next-line no-param-reassign
  formData = formData || new (_FormData.default || FormData)();

  // eslint-disable-next-line no-param-reassign
  options = _utils.default.toFlatObject(options, {
    metaTokens: true,
    dots: false,
    indexes: false
  }, false, function defined(option, source) {
    // eslint-disable-next-line no-eq-null,eqeqeq
    return !_utils.default.isUndefined(source[option]);
  });
  const metaTokens = options.metaTokens;
  // eslint-disable-next-line no-use-before-define
  const visitor = options.visitor || defaultVisitor;
  const dots = options.dots;
  const indexes = options.indexes;
  const _Blob = options.Blob || typeof Blob !== 'undefined' && Blob;
  const useBlob = _Blob && _utils.default.isSpecCompliantForm(formData);
  if (!_utils.default.isFunction(visitor)) {
    throw new TypeError('visitor must be a function');
  }
  function convertValue(value) {
    if (value === null) return '';
    if (_utils.default.isDate(value)) {
      return value.toISOString();
    }
    if (_utils.default.isBoolean(value)) {
      return value.toString();
    }
    if (!useBlob && _utils.default.isBlob(value)) {
      throw new _AxiosError.default('Blob is not supported. Use a Buffer instead.');
    }
    if (_utils.default.isArrayBuffer(value) || _utils.default.isTypedArray(value)) {
      return useBlob && typeof Blob === 'function' ? new Blob([value]) : Buffer.from(value);
    }
    return value;
  }

  /**
   * Default visitor.
   *
   * @param {*} value
   * @param {String|Number} key
   * @param {Array<String|Number>} path
   * @this {FormData}
   *
   * @returns {boolean} return true to visit the each prop of the value recursively
   */
  function defaultVisitor(value, key, path) {
    let arr = value;
    if (value && !path && typeof value === 'object') {
      if (_utils.default.endsWith(key, '{}')) {
        // eslint-disable-next-line no-param-reassign
        key = metaTokens ? key : key.slice(0, -2);
        // eslint-disable-next-line no-param-reassign
        value = JSON.stringify(value);
      } else if (_utils.default.isArray(value) && isFlatArray(value) || (_utils.default.isFileList(value) || _utils.default.endsWith(key, '[]')) && (arr = _utils.default.toArray(value))) {
        // eslint-disable-next-line no-param-reassign
        key = removeBrackets(key);
        arr.forEach(function each(el, index) {
          !(_utils.default.isUndefined(el) || el === null) && formData.append(
          // eslint-disable-next-line no-nested-ternary
          indexes === true ? renderKey([key], index, dots) : indexes === null ? key : key + '[]', convertValue(el));
        });
        return false;
      }
    }
    if (isVisitable(value)) {
      return true;
    }
    formData.append(renderKey(path, key, dots), convertValue(value));
    return false;
  }
  const stack = [];
  const exposedHelpers = Object.assign(predicates, {
    defaultVisitor,
    convertValue,
    isVisitable
  });
  function build(value, path) {
    if (_utils.default.isUndefined(value)) return;
    if (stack.indexOf(value) !== -1) {
      throw Error('Circular reference detected in ' + path.join('.'));
    }
    stack.push(value);
    _utils.default.forEach(value, function each(el, key) {
      const result = !(_utils.default.isUndefined(el) || el === null) && visitor.call(formData, el, _utils.default.isString(key) ? key.trim() : key, path, exposedHelpers);
      if (result === true) {
        build(el, path ? path.concat(key) : [key]);
      }
    });
    stack.pop();
  }
  if (!_utils.default.isObject(obj)) {
    throw new TypeError('data must be an object');
  }
  build(obj);
  return formData;
}
var _default = exports.default = toFormData;

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\toFormData.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\toURLEncodedForm.js", {"../platform/index.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\platform\\index.js","../utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js","./toFormData.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\toFormData.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5CtoURLEncodedForm.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = toURLEncodedForm;
var _utils = _interopRequireDefault(require("../utils.js"));
var _toFormData = _interopRequireDefault(require("./toFormData.js"));
var _index = _interopRequireDefault(require("../platform/index.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function toURLEncodedForm(data, options) {
  return (0, _toFormData.default)(data, new _index.default.classes.URLSearchParams(), {
    visitor: function (value, key, path, helpers) {
      if (_index.default.isNode && _utils.default.isBuffer(value)) {
        this.append(key, value.toString('base64'));
        return false;
      }
      return helpers.defaultVisitor.apply(this, arguments);
    },
    ...options
  });
}

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\toURLEncodedForm.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\trackStream.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5CtrackStream.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.trackStream = exports.streamChunk = exports.readBytes = void 0;
const streamChunk = function* (chunk, chunkSize) {
  let len = chunk.byteLength;
  if (!chunkSize || len < chunkSize) {
    yield chunk;
    return;
  }
  let pos = 0;
  let end;
  while (pos < len) {
    end = pos + chunkSize;
    yield chunk.slice(pos, end);
    pos = end;
  }
};
exports.streamChunk = streamChunk;
const readBytes = async function* (iterable, chunkSize) {
  for await (const chunk of readStream(iterable)) {
    yield* streamChunk(chunk, chunkSize);
  }
};
exports.readBytes = readBytes;
const readStream = async function* (stream) {
  if (stream[Symbol.asyncIterator]) {
    yield* stream;
    return;
  }
  const reader = stream.getReader();
  try {
    for (;;) {
      const {
        done,
        value
      } = await reader.read();
      if (done) {
        break;
      }
      yield value;
    }
  } finally {
    await reader.cancel();
  }
};
const trackStream = (stream, chunkSize, onProgress, onFinish) => {
  const iterator = readBytes(stream, chunkSize);
  let bytes = 0;
  let done;
  let _onFinish = e => {
    if (!done) {
      done = true;
      onFinish && onFinish(e);
    }
  };
  return new ReadableStream({
    async pull(controller) {
      try {
        const {
          done,
          value
        } = await iterator.next();
        if (done) {
          _onFinish();
          controller.close();
          return;
        }
        let len = value.byteLength;
        if (onProgress) {
          let loadedBytes = bytes += len;
          onProgress(loadedBytes);
        }
        controller.enqueue(new Uint8Array(value));
      } catch (err) {
        _onFinish(err);
        throw err;
      }
    },
    cancel(reason) {
      _onFinish(reason);
      return iterator.return();
    }
  }, {
    highWaterMark: 2
  });
};
exports.trackStream = trackStream;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\trackStream.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\validator.js", {"../core/AxiosError.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\core\\AxiosError.js","../env/data.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\env\\data.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Chelpers%5Cvalidator.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _data = require("../env/data.js");
var _AxiosError = _interopRequireDefault(require("../core/AxiosError.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const validators = {};

// eslint-disable-next-line func-names
['object', 'boolean', 'number', 'function', 'string', 'symbol'].forEach((type, i) => {
  validators[type] = function validator(thing) {
    return typeof thing === type || 'a' + (i < 1 ? 'n ' : ' ') + type;
  };
});
const deprecatedWarnings = {};

/**
 * Transitional option validator
 *
 * @param {function|boolean?} validator - set to false if the transitional option has been removed
 * @param {string?} version - deprecated version / removed since version
 * @param {string?} message - some message with additional info
 *
 * @returns {function}
 */
validators.transitional = function transitional(validator, version, message) {
  function formatMessage(opt, desc) {
    return '[Axios v' + _data.VERSION + '] Transitional option \'' + opt + '\'' + desc + (message ? '. ' + message : '');
  }

  // eslint-disable-next-line func-names
  return (value, opt, opts) => {
    if (validator === false) {
      throw new _AxiosError.default(formatMessage(opt, ' has been removed' + (version ? ' in ' + version : '')), _AxiosError.default.ERR_DEPRECATED);
    }
    if (version && !deprecatedWarnings[opt]) {
      deprecatedWarnings[opt] = true;
      // eslint-disable-next-line no-console
      console.warn(formatMessage(opt, ' has been deprecated since v' + version + ' and will be removed in the near future'));
    }
    return validator ? validator(value, opt, opts) : true;
  };
};
validators.spelling = function spelling(correctSpelling) {
  return (value, opt) => {
    // eslint-disable-next-line no-console
    console.warn(`${opt} is likely a misspelling of ${correctSpelling}`);
    return true;
  };
};

/**
 * Assert object's properties type
 *
 * @param {object} options
 * @param {object} schema
 * @param {boolean?} allowUnknown
 *
 * @returns {object}
 */

function assertOptions(options, schema, allowUnknown) {
  if (typeof options !== 'object') {
    throw new _AxiosError.default('options must be an object', _AxiosError.default.ERR_BAD_OPTION_VALUE);
  }
  const keys = Object.keys(options);
  let i = keys.length;
  while (i-- > 0) {
    const opt = keys[i];
    const validator = schema[opt];
    if (validator) {
      const value = options[opt];
      const result = value === undefined || validator(value, opt, options);
      if (result !== true) {
        throw new _AxiosError.default('option ' + opt + ' must be ' + result, _AxiosError.default.ERR_BAD_OPTION_VALUE);
      }
      continue;
    }
    if (allowUnknown !== true) {
      throw new _AxiosError.default('Unknown option ' + opt, _AxiosError.default.ERR_BAD_OPTION);
    }
  }
}
var _default = exports.default = {
  assertOptions,
  validators
};

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\helpers\\validator.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\platform\\browser\\classes\\Blob.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Cplatform%5Cbrowser%5Cclasses%5CBlob.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default = exports.default = typeof Blob !== 'undefined' ? Blob : null;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\platform\\browser\\classes\\Blob.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\platform\\browser\\classes\\FormData.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Cplatform%5Cbrowser%5Cclasses%5CFormData.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default = exports.default = typeof FormData !== 'undefined' ? FormData : null;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\platform\\browser\\classes\\FormData.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\platform\\browser\\classes\\URLSearchParams.js", {"../../../helpers/AxiosURLSearchParams.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\AxiosURLSearchParams.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Cplatform%5Cbrowser%5Cclasses%5CURLSearchParams.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _AxiosURLSearchParams = _interopRequireDefault(require("../../../helpers/AxiosURLSearchParams.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = typeof URLSearchParams !== 'undefined' ? URLSearchParams : _AxiosURLSearchParams.default;

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\platform\\browser\\classes\\URLSearchParams.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\platform\\browser\\index.js", {"./classes/Blob.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\platform\\browser\\classes\\Blob.js","./classes/FormData.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\platform\\browser\\classes\\FormData.js","./classes/URLSearchParams.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\platform\\browser\\classes\\URLSearchParams.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Cplatform%5Cbrowser%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _URLSearchParams = _interopRequireDefault(require("./classes/URLSearchParams.js"));
var _FormData = _interopRequireDefault(require("./classes/FormData.js"));
var _Blob = _interopRequireDefault(require("./classes/Blob.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = {
  isBrowser: true,
  classes: {
    URLSearchParams: _URLSearchParams.default,
    FormData: _FormData.default,
    Blob: _Blob.default
  },
  protocols: ['http', 'https', 'file', 'blob', 'url', 'data']
};

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\platform\\browser\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\platform\\common\\utils.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Cplatform%5Ccommon%5Cutils.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.origin = exports.navigator = exports.hasStandardBrowserWebWorkerEnv = exports.hasStandardBrowserEnv = exports.hasBrowserEnv = void 0;
const hasBrowserEnv = exports.hasBrowserEnv = typeof window !== 'undefined' && typeof document !== 'undefined';
const _navigator = exports.navigator = typeof navigator === 'object' && navigator || undefined;

/**
 * Determine if we're running in a standard browser environment
 *
 * This allows axios to run in a web worker, and react-native.
 * Both environments support XMLHttpRequest, but not fully standard globals.
 *
 * web workers:
 *  typeof window -> undefined
 *  typeof document -> undefined
 *
 * react-native:
 *  navigator.product -> 'ReactNative'
 * nativescript
 *  navigator.product -> 'NativeScript' or 'NS'
 *
 * @returns {boolean}
 */
const hasStandardBrowserEnv = exports.hasStandardBrowserEnv = hasBrowserEnv && (!_navigator || ['ReactNative', 'NativeScript', 'NS'].indexOf(_navigator.product) < 0);

/**
 * Determine if we're running in a standard browser webWorker environment
 *
 * Although the `isStandardBrowserEnv` method indicates that
 * `allows axios to run in a web worker`, the WebWorker will still be
 * filtered out due to its judgment standard
 * `typeof window !== 'undefined' && typeof document !== 'undefined'`.
 * This leads to a problem when axios post `FormData` in webWorker
 */
const hasStandardBrowserWebWorkerEnv = exports.hasStandardBrowserWebWorkerEnv = (() => {
  return typeof WorkerGlobalScope !== 'undefined' &&
  // eslint-disable-next-line no-undef
  self instanceof WorkerGlobalScope && typeof self.importScripts === 'function';
})();
const origin = exports.origin = hasBrowserEnv && window.location.href || 'http://localhost';

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\platform\\common\\utils.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\platform\\index.js", {"./common/utils.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\platform\\common\\utils.js","./node/index.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\platform\\browser\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Cplatform%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _index = _interopRequireDefault(require("./node/index.js"));
var utils = _interopRequireWildcard(require("./common/utils.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports.default = {
  ...utils,
  ..._index.default
};

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\platform\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\utils.js", {"./helpers/bind.js":"D:\\code\\v\\metamask-extension\\node_modules\\axios\\lib\\helpers\\bind.js","_process":"D:\\code\\v\\metamask-extension\\node_modules\\process\\browser.js","timers":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\timers-browserify\\main.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Caxios%5Clib%5Cutils.js
      return function (require, module, exports) {
(function (process,setImmediate){(function (){
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _bind = _interopRequireDefault(require("./helpers/bind.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// utils is a library of generic helper functions non-specific to axios

const {
  toString
} = Object.prototype;
const {
  getPrototypeOf
} = Object;
const {
  iterator,
  toStringTag
} = Symbol;
const kindOf = (cache => thing => {
  const str = toString.call(thing);
  return cache[str] || (cache[str] = str.slice(8, -1).toLowerCase());
})(Object.create(null));
const kindOfTest = type => {
  type = type.toLowerCase();
  return thing => kindOf(thing) === type;
};
const typeOfTest = type => thing => typeof thing === type;

/**
 * Determine if a value is an Array
 *
 * @param {Object} val The value to test
 *
 * @returns {boolean} True if value is an Array, otherwise false
 */
const {
  isArray
} = Array;

/**
 * Determine if a value is undefined
 *
 * @param {*} val The value to test
 *
 * @returns {boolean} True if the value is undefined, otherwise false
 */
const isUndefined = typeOfTest('undefined');

/**
 * Determine if a value is a Buffer
 *
 * @param {*} val The value to test
 *
 * @returns {boolean} True if value is a Buffer, otherwise false
 */
function isBuffer(val) {
  return val !== null && !isUndefined(val) && val.constructor !== null && !isUndefined(val.constructor) && isFunction(val.constructor.isBuffer) && val.constructor.isBuffer(val);
}

/**
 * Determine if a value is an ArrayBuffer
 *
 * @param {*} val The value to test
 *
 * @returns {boolean} True if value is an ArrayBuffer, otherwise false
 */
const isArrayBuffer = kindOfTest('ArrayBuffer');

/**
 * Determine if a value is a view on an ArrayBuffer
 *
 * @param {*} val The value to test
 *
 * @returns {boolean} True if value is a view on an ArrayBuffer, otherwise false
 */
function isArrayBufferView(val) {
  let result;
  if (typeof ArrayBuffer !== 'undefined' && ArrayBuffer.isView) {
    result = ArrayBuffer.isView(val);
  } else {
    result = val && val.buffer && isArrayBuffer(val.buffer);
  }
  return result;
}

/**
 * Determine if a value is a String
 *
 * @param {*} val The value to test
 *
 * @returns {boolean} True if value is a String, otherwise false
 */
const isString = typeOfTest('string');

/**
 * Determine if a value is a Function
 *
 * @param {*} val The value to test
 * @returns {boolean} True if value is a Function, otherwise false
 */
const isFunction = typeOfTest('function');

/**
 * Determine if a value is a Number
 *
 * @param {*} val The value to test
 *
 * @returns {boolean} True if value is a Number, otherwise false
 */
const isNumber = typeOfTest('number');

/**
 * Determine if a value is an Object
 *
 * @param {*} thing The value to test
 *
 * @returns {boolean} True if value is an Object, otherwise false
 */
const isObject = thing => thing !== null && typeof thing === 'object';

/**
 * Determine if a value is a Boolean
 *
 * @param {*} thing The value to test
 * @returns {boolean} True if value is a Boolean, otherwise false
 */
const isBoolean = thing => thing === true || thing === false;

/**
 * Determine if a value is a plain Object
 *
 * @param {*} val The value to test
 *
 * @returns {boolean} True if value is a plain Object, otherwise false
 */
const isPlainObject = val => {
  if (kindOf(val) !== 'object') {
    return false;
  }
  const prototype = getPrototypeOf(val);
  return (prototype === null || prototype === Object.prototype || Object.getPrototypeOf(prototype) === null) && !(toStringTag in val) && !(iterator in val);
};

/**
 * Determine if a value is an empty object (safely handles Buffers)
 *
 * @param {*} val The value to test
 *
 * @returns {boolean} True if value is an empty object, otherwise false
 */
const isEmptyObject = val => {
  // Early return for non-objects or Buffers to prevent RangeError
  if (!isObject(val) || isBuffer(val)) {
    return false;
  }
  try {
    return Object.keys(val).length === 0 && Object.getPrototypeOf(val) === Object.prototype;
  } catch (e) {
    // Fallback for any other objects that might cause RangeError with Object.keys()
    return false;
  }
};

/**
 * Determine if a value is a Date
 *
 * @param {*} val The value to test
 *
 * @returns {boolean} True if value is a Date, otherwise false
 */
const isDate = kindOfTest('Date');

/**
 * Determine if a value is a File
 *
 * @param {*} val The value to test
 *
 * @returns {boolean} True if value is a File, otherwise false
 */
const isFile = kindOfTest('File');

/**
 * Determine if a value is a Blob
 *
 * @param {*} val The value to test
 *
 * @returns {boolean} True if value is a Blob, otherwise false
 */
const isBlob = kindOfTest('Blob');

/**
 * Determine if a value is a FileList
 *
 * @param {*} val The value to test
 *
 * @returns {boolean} True if value is a File, otherwise false
 */
const isFileList = kindOfTest('FileList');

/**
 * Determine if a value is a Stream
 *
 * @param {*} val The value to test
 *
 * @returns {boolean} True if value is a Stream, otherwise false
 */
const isStream = val => isObject(val) && isFunction(val.pipe);

/**
 * Determine if a value is a FormData
 *
 * @param {*} thing The value to test
 *
 * @returns {boolean} True if value is an FormData, otherwise false
 */
const isFormData = thing => {
  let kind;
  return thing && (typeof FormData === 'function' && thing instanceof FormData || isFunction(thing.append) && ((kind = kindOf(thing)) === 'formdata' ||
  // detect form-data instance
  kind === 'object' && isFunction(thing.toString) && thing.toString() === '[object FormData]'));
};

/**
 * Determine if a value is a URLSearchParams object
 *
 * @param {*} val The value to test
 *
 * @returns {boolean} True if value is a URLSearchParams object, otherwise false
 */
const isURLSearchParams = kindOfTest('URLSearchParams');
const [isReadableStream, isRequest, isResponse, isHeaders] = ['ReadableStream', 'Request', 'Response', 'Headers'].map(kindOfTest);

/**
 * Trim excess whitespace off the beginning and end of a string
 *
 * @param {String} str The String to trim
 *
 * @returns {String} The String freed of excess whitespace
 */
const trim = str => str.trim ? str.trim() : str.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, '');

/**
 * Iterate over an Array or an Object invoking a function for each item.
 *
 * If `obj` is an Array callback will be called passing
 * the value, index, and complete array for each item.
 *
 * If 'obj' is an Object callback will be called passing
 * the value, key, and complete object for each property.
 *
 * @param {Object|Array} obj The object to iterate
 * @param {Function} fn The callback to invoke for each item
 *
 * @param {Boolean} [allOwnKeys = false]
 * @returns {any}
 */
function forEach(obj, fn, {
  allOwnKeys = false
} = {}) {
  // Don't bother if no value provided
  if (obj === null || typeof obj === 'undefined') {
    return;
  }
  let i;
  let l;

  // Force an array if not already something iterable
  if (typeof obj !== 'object') {
    /*eslint no-param-reassign:0*/
    obj = [obj];
  }
  if (isArray(obj)) {
    // Iterate over array values
    for (i = 0, l = obj.length; i < l; i++) {
      fn.call(null, obj[i], i, obj);
    }
  } else {
    // Buffer check
    if (isBuffer(obj)) {
      return;
    }

    // Iterate over object keys
    const keys = allOwnKeys ? Object.getOwnPropertyNames(obj) : Object.keys(obj);
    const len = keys.length;
    let key;
    for (i = 0; i < len; i++) {
      key = keys[i];
      fn.call(null, obj[key], key, obj);
    }
  }
}
function findKey(obj, key) {
  if (isBuffer(obj)) {
    return null;
  }
  key = key.toLowerCase();
  const keys = Object.keys(obj);
  let i = keys.length;
  let _key;
  while (i-- > 0) {
    _key = keys[i];
    if (key === _key.toLowerCase()) {
      return _key;
    }
  }
  return null;
}
const _global = (() => {
  /*eslint no-undef:0*/
  if (typeof globalThis !== "undefined") return globalThis;
  return typeof self !== "undefined" ? self : typeof window !== 'undefined' ? window : global;
})();
const isContextDefined = context => !isUndefined(context) && context !== _global;

/**
 * Accepts varargs expecting each argument to be an object, then
 * immutably merges the properties of each object and returns result.
 *
 * When multiple objects contain the same key the later object in
 * the arguments list will take precedence.
 *
 * Example:
 *
 * ```js
 * var result = merge({foo: 123}, {foo: 456});
 * console.log(result.foo); // outputs 456
 * ```
 *
 * @param {Object} obj1 Object to merge
 *
 * @returns {Object} Result of all merge properties
 */
function merge(/* obj1, obj2, obj3, ... */
) {
  const {
    caseless,
    skipUndefined
  } = isContextDefined(this) && this || {};
  const result = {};
  const assignValue = (val, key) => {
    const targetKey = caseless && findKey(result, key) || key;
    if (isPlainObject(result[targetKey]) && isPlainObject(val)) {
      result[targetKey] = merge(result[targetKey], val);
    } else if (isPlainObject(val)) {
      result[targetKey] = merge({}, val);
    } else if (isArray(val)) {
      result[targetKey] = val.slice();
    } else {
      if (!skipUndefined || !isUndefined(val)) {
        result[targetKey] = val;
      }
    }
  };
  for (let i = 0, l = arguments.length; i < l; i++) {
    arguments[i] && forEach(arguments[i], assignValue);
  }
  return result;
}

/**
 * Extends object a by mutably adding to it the properties of object b.
 *
 * @param {Object} a The object to be extended
 * @param {Object} b The object to copy properties from
 * @param {Object} thisArg The object to bind function to
 *
 * @param {Boolean} [allOwnKeys]
 * @returns {Object} The resulting value of object a
 */
const extend = (a, b, thisArg, {
  allOwnKeys
} = {}) => {
  forEach(b, (val, key) => {
    if (thisArg && isFunction(val)) {
      a[key] = (0, _bind.default)(val, thisArg);
    } else {
      a[key] = val;
    }
  }, {
    allOwnKeys
  });
  return a;
};

/**
 * Remove byte order marker. This catches EF BB BF (the UTF-8 BOM)
 *
 * @param {string} content with BOM
 *
 * @returns {string} content value without BOM
 */
const stripBOM = content => {
  if (content.charCodeAt(0) === 0xFEFF) {
    content = content.slice(1);
  }
  return content;
};

/**
 * Inherit the prototype methods from one constructor into another
 * @param {function} constructor
 * @param {function} superConstructor
 * @param {object} [props]
 * @param {object} [descriptors]
 *
 * @returns {void}
 */
const inherits = (constructor, superConstructor, props, descriptors) => {
  constructor.prototype = Object.create(superConstructor.prototype, descriptors);
  constructor.prototype.constructor = constructor;
  Object.defineProperty(constructor, 'super', {
    value: superConstructor.prototype
  });
  props && Object.assign(constructor.prototype, props);
};

/**
 * Resolve object with deep prototype chain to a flat object
 * @param {Object} sourceObj source object
 * @param {Object} [destObj]
 * @param {Function|Boolean} [filter]
 * @param {Function} [propFilter]
 *
 * @returns {Object}
 */
const toFlatObject = (sourceObj, destObj, filter, propFilter) => {
  let props;
  let i;
  let prop;
  const merged = {};
  destObj = destObj || {};
  // eslint-disable-next-line no-eq-null,eqeqeq
  if (sourceObj == null) return destObj;
  do {
    props = Object.getOwnPropertyNames(sourceObj);
    i = props.length;
    while (i-- > 0) {
      prop = props[i];
      if ((!propFilter || propFilter(prop, sourceObj, destObj)) && !merged[prop]) {
        destObj[prop] = sourceObj[prop];
        merged[prop] = true;
      }
    }
    sourceObj = filter !== false && getPrototypeOf(sourceObj);
  } while (sourceObj && (!filter || filter(sourceObj, destObj)) && sourceObj !== Object.prototype);
  return destObj;
};

/**
 * Determines whether a string ends with the characters of a specified string
 *
 * @param {String} str
 * @param {String} searchString
 * @param {Number} [position= 0]
 *
 * @returns {boolean}
 */
const endsWith = (str, searchString, position) => {
  str = String(str);
  if (position === undefined || position > str.length) {
    position = str.length;
  }
  position -= searchString.length;
  const lastIndex = str.indexOf(searchString, position);
  return lastIndex !== -1 && lastIndex === position;
};

/**
 * Returns new array from array like object or null if failed
 *
 * @param {*} [thing]
 *
 * @returns {?Array}
 */
const toArray = thing => {
  if (!thing) return null;
  if (isArray(thing)) return thing;
  let i = thing.length;
  if (!isNumber(i)) return null;
  const arr = new Array(i);
  while (i-- > 0) {
    arr[i] = thing[i];
  }
  return arr;
};

/**
 * Checking if the Uint8Array exists and if it does, it returns a function that checks if the
 * thing passed in is an instance of Uint8Array
 *
 * @param {TypedArray}
 *
 * @returns {Array}
 */
// eslint-disable-next-line func-names
const isTypedArray = (TypedArray => {
  // eslint-disable-next-line func-names
  return thing => {
    return TypedArray && thing instanceof TypedArray;
  };
})(typeof Uint8Array !== 'undefined' && getPrototypeOf(Uint8Array));

/**
 * For each entry in the object, call the function with the key and value.
 *
 * @param {Object<any, any>} obj - The object to iterate over.
 * @param {Function} fn - The function to call for each entry.
 *
 * @returns {void}
 */
const forEachEntry = (obj, fn) => {
  const generator = obj && obj[iterator];
  const _iterator = generator.call(obj);
  let result;
  while ((result = _iterator.next()) && !result.done) {
    const pair = result.value;
    fn.call(obj, pair[0], pair[1]);
  }
};

/**
 * It takes a regular expression and a string, and returns an array of all the matches
 *
 * @param {string} regExp - The regular expression to match against.
 * @param {string} str - The string to search.
 *
 * @returns {Array<boolean>}
 */
const matchAll = (regExp, str) => {
  let matches;
  const arr = [];
  while ((matches = regExp.exec(str)) !== null) {
    arr.push(matches);
  }
  return arr;
};

/* Checking if the kindOfTest function returns true when passed an HTMLFormElement. */
const isHTMLForm = kindOfTest('HTMLFormElement');
const toCamelCase = str => {
  return str.toLowerCase().replace(/[-_\s]([a-z\d])(\w*)/g, function replacer(m, p1, p2) {
    return p1.toUpperCase() + p2;
  });
};

/* Creating a function that will check if an object has a property. */
const hasOwnProperty = (({
  hasOwnProperty
}) => (obj, prop) => hasOwnProperty.call(obj, prop))(Object.prototype);

/**
 * Determine if a value is a RegExp object
 *
 * @param {*} val The value to test
 *
 * @returns {boolean} True if value is a RegExp object, otherwise false
 */
const isRegExp = kindOfTest('RegExp');
const reduceDescriptors = (obj, reducer) => {
  const descriptors = Object.getOwnPropertyDescriptors(obj);
  const reducedDescriptors = {};
  forEach(descriptors, (descriptor, name) => {
    let ret;
    if ((ret = reducer(descriptor, name, obj)) !== false) {
      reducedDescriptors[name] = ret || descriptor;
    }
  });
  Object.defineProperties(obj, reducedDescriptors);
};

/**
 * Makes all methods read-only
 * @param {Object} obj
 */

const freezeMethods = obj => {
  reduceDescriptors(obj, (descriptor, name) => {
    // skip restricted props in strict mode
    if (isFunction(obj) && ['arguments', 'caller', 'callee'].indexOf(name) !== -1) {
      return false;
    }
    const value = obj[name];
    if (!isFunction(value)) return;
    descriptor.enumerable = false;
    if ('writable' in descriptor) {
      descriptor.writable = false;
      return;
    }
    if (!descriptor.set) {
      descriptor.set = () => {
        throw Error('Can not rewrite read-only method \'' + name + '\'');
      };
    }
  });
};
const toObjectSet = (arrayOrString, delimiter) => {
  const obj = {};
  const define = arr => {
    arr.forEach(value => {
      obj[value] = true;
    });
  };
  isArray(arrayOrString) ? define(arrayOrString) : define(String(arrayOrString).split(delimiter));
  return obj;
};
const noop = () => {};
const toFiniteNumber = (value, defaultValue) => {
  return value != null && Number.isFinite(value = +value) ? value : defaultValue;
};

/**
 * If the thing is a FormData object, return true, otherwise return false.
 *
 * @param {unknown} thing - The thing to check.
 *
 * @returns {boolean}
 */
function isSpecCompliantForm(thing) {
  return !!(thing && isFunction(thing.append) && thing[toStringTag] === 'FormData' && thing[iterator]);
}
const toJSONObject = obj => {
  const stack = new Array(10);
  const visit = (source, i) => {
    if (isObject(source)) {
      if (stack.indexOf(source) >= 0) {
        return;
      }

      //Buffer check
      if (isBuffer(source)) {
        return source;
      }
      if (!('toJSON' in source)) {
        stack[i] = source;
        const target = isArray(source) ? [] : {};
        forEach(source, (value, key) => {
          const reducedValue = visit(value, i + 1);
          !isUndefined(reducedValue) && (target[key] = reducedValue);
        });
        stack[i] = undefined;
        return target;
      }
    }
    return source;
  };
  return visit(obj, 0);
};
const isAsyncFn = kindOfTest('AsyncFunction');
const isThenable = thing => thing && (isObject(thing) || isFunction(thing)) && isFunction(thing.then) && isFunction(thing.catch);

// original code
// https://github.com/DigitalBrainJS/AxiosPromise/blob/16deab13710ec09779922131f3fa5954320f83ab/lib/utils.js#L11-L34

const _setImmediate = ((setImmediateSupported, postMessageSupported) => {
  if (setImmediateSupported) {
    return setImmediate;
  }
  return postMessageSupported ? ((token, callbacks) => {
    _global.addEventListener("message", ({
      source,
      data
    }) => {
      if (source === _global && data === token) {
        callbacks.length && callbacks.shift()();
      }
    }, false);
    return cb => {
      callbacks.push(cb);
      _global.postMessage(token, "*");
    };
  })(`axios@${Math.random()}`, []) : cb => setTimeout(cb);
})(typeof setImmediate === 'function', isFunction(_global.postMessage));
const asap = typeof queueMicrotask !== 'undefined' ? queueMicrotask.bind(_global) : typeof process !== 'undefined' && process.nextTick || _setImmediate;

// *********************

const isIterable = thing => thing != null && isFunction(thing[iterator]);
var _default = exports.default = {
  isArray,
  isArrayBuffer,
  isBuffer,
  isFormData,
  isArrayBufferView,
  isString,
  isNumber,
  isBoolean,
  isObject,
  isPlainObject,
  isEmptyObject,
  isReadableStream,
  isRequest,
  isResponse,
  isHeaders,
  isUndefined,
  isDate,
  isFile,
  isBlob,
  isRegExp,
  isFunction,
  isStream,
  isURLSearchParams,
  isTypedArray,
  isFileList,
  forEach,
  merge,
  extend,
  trim,
  stripBOM,
  inherits,
  toFlatObject,
  kindOf,
  kindOfTest,
  endsWith,
  toArray,
  forEachEntry,
  matchAll,
  isHTMLForm,
  hasOwnProperty,
  hasOwnProp: hasOwnProperty,
  // an alias to avoid ESLint no-prototype-builtins detection
  reduceDescriptors,
  freezeMethods,
  toObjectSet,
  toCamelCase,
  noop,
  toFiniteNumber,
  findKey,
  global: _global,
  isContextDefined,
  isSpecCompliantForm,
  toJSONObject,
  isAsyncFn,
  isThenable,
  setImmediate: _setImmediate,
  asap,
  isIterable
};

}).call(this)}).call(this,require('_process'),require("timers").setImmediate)

      };
    };
  }
  }
}, {package:"axios",file:"node_modules\\axios\\lib\\utils.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\b4a\\browser.js", {"./lib/ascii":"D:\\code\\v\\metamask-extension\\node_modules\\b4a\\lib\\ascii.js","./lib/base64":"D:\\code\\v\\metamask-extension\\node_modules\\b4a\\lib\\base64.js","./lib/hex":"D:\\code\\v\\metamask-extension\\node_modules\\b4a\\lib\\hex.js","./lib/utf16le":"D:\\code\\v\\metamask-extension\\node_modules\\b4a\\lib\\utf16le.js","./lib/utf8":"D:\\code\\v\\metamask-extension\\node_modules\\b4a\\lib\\utf8.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cb4a%5Cbrowser.js
      return function (require, module, exports) {
const ascii = require('./lib/ascii')
const base64 = require('./lib/base64')
const hex = require('./lib/hex')
const utf8 = require('./lib/utf8')
const utf16le = require('./lib/utf16le')

const LE = new Uint8Array(Uint16Array.of(0xff).buffer)[0] === 0xff

function codecFor (encoding) {
  switch (encoding) {
    case 'ascii':
      return ascii
    case 'base64':
      return base64
    case 'hex':
      return hex
    case 'utf8':
    case 'utf-8':
    case undefined:
      return utf8
    case 'ucs2':
    case 'ucs-2':
    case 'utf16le':
    case 'utf-16le':
      return utf16le
    default:
      throw new Error(`Unknown encoding: ${encoding}`)
  }
}

function isBuffer (value) {
  return value instanceof Uint8Array
}

function isEncoding (encoding) {
  try {
    codecFor(encoding)
    return true
  } catch {
    return false
  }
}

function alloc (size, fill, encoding) {
  const buffer = new Uint8Array(size)
  if (fill !== undefined) exports.fill(buffer, fill, 0, buffer.byteLength, encoding)
  return buffer
}

function allocUnsafe (size) {
  return new Uint8Array(size)
}

function allocUnsafeSlow (size) {
  return new Uint8Array(size)
}

function byteLength (string, encoding) {
  return codecFor(encoding).byteLength(string)
}

function compare (a, b) {
  if (a === b) return 0

  const len = Math.min(a.byteLength, b.byteLength)

  a = new DataView(a.buffer, a.byteOffset, a.byteLength)
  b = new DataView(b.buffer, b.byteOffset, b.byteLength)

  let i = 0

  for (let n = len - (len % 4); i < n; i += 4) {
    const x = a.getUint32(i, LE)
    const y = b.getUint32(i, LE)
    if (x !== y) break
  }

  for (; i < len; i++) {
    const x = a.getUint8(i)
    const y = b.getUint8(i)
    if (x < y) return -1
    if (x > y) return 1
  }

  return a.byteLength > b.byteLength ? 1 : a.byteLength < b.byteLength ? -1 : 0
}

function concat (buffers, totalLength) {
  if (totalLength === undefined) {
    totalLength = buffers.reduce((len, buffer) => len + buffer.byteLength, 0)
  }

  const result = new Uint8Array(totalLength)

  let offset = 0
  for (const buffer of buffers) {
    if (offset + buffer.byteLength > result.byteLength) {
      const sub = buffer.subarray(0, result.byteLength - offset)
      result.set(sub, offset)
      return result
    }
    result.set(buffer, offset)
    offset += buffer.byteLength
  }

  return result
}

function copy (source, target, targetStart = 0, start = 0, end = source.byteLength) {
  if (end > 0 && end < start) return 0
  if (end === start) return 0
  if (source.byteLength === 0 || target.byteLength === 0) return 0

  if (targetStart < 0) throw new RangeError('targetStart is out of range')
  if (start < 0 || start >= source.byteLength) throw new RangeError('sourceStart is out of range')
  if (end < 0) throw new RangeError('sourceEnd is out of range')

  if (targetStart >= target.byteLength) targetStart = target.byteLength
  if (end > source.byteLength) end = source.byteLength
  if (target.byteLength - targetStart < end - start) {
    end = target.length - targetStart + start
  }

  const len = end - start

  if (source === target) {
    target.copyWithin(targetStart, start, end)
  } else {
    target.set(source.subarray(start, end), targetStart)
  }

  return len
}

function equals (a, b) {
  if (a === b) return true
  if (a.byteLength !== b.byteLength) return false

  const len = a.byteLength

  a = new DataView(a.buffer, a.byteOffset, a.byteLength)
  b = new DataView(b.buffer, b.byteOffset, b.byteLength)

  let i = 0

  for (let n = len - (len % 4); i < n; i += 4) {
    if (a.getUint32(i, LE) !== b.getUint32(i, LE)) return false
  }

  for (; i < len; i++) {
    if (a.getUint8(i) !== b.getUint8(i)) return false
  }

  return true
}

function fill (buffer, value, offset, end, encoding) {
  if (typeof value === 'string') {
    // fill(buffer, string, encoding)
    if (typeof offset === 'string') {
      encoding = offset
      offset = 0
      end = buffer.byteLength

    // fill(buffer, string, offset, encoding)
    } else if (typeof end === 'string') {
      encoding = end
      end = buffer.byteLength
    }
  } else if (typeof value === 'number') {
    value = value & 0xff
  } else if (typeof value === 'boolean') {
    value = +value
  }

  if (offset < 0 || buffer.byteLength < offset || buffer.byteLength < end) {
    throw new RangeError('Out of range index')
  }

  if (offset === undefined) offset = 0
  if (end === undefined) end = buffer.byteLength

  if (end <= offset) return buffer

  if (!value) value = 0

  if (typeof value === 'number') {
    for (let i = offset; i < end; ++i) {
      buffer[i] = value
    }
  } else {
    value = isBuffer(value) ? value : from(value, encoding)

    const len = value.byteLength

    for (let i = 0; i < end - offset; ++i) {
      buffer[i + offset] = value[i % len]
    }
  }

  return buffer
}

function from (value, encodingOrOffset, length) {
  // from(string, encoding)
  if (typeof value === 'string') return fromString(value, encodingOrOffset)

  // from(array)
  if (Array.isArray(value)) return fromArray(value)

  // from(buffer)
  if (ArrayBuffer.isView(value)) return fromBuffer(value)

  // from(arrayBuffer[, byteOffset[, length]])
  return fromArrayBuffer(value, encodingOrOffset, length)
}

function fromString (string, encoding) {
  const codec = codecFor(encoding)
  const buffer = new Uint8Array(codec.byteLength(string))
  codec.write(buffer, string, 0, buffer.byteLength)
  return buffer
}

function fromArray (array) {
  const buffer = new Uint8Array(array.length)
  buffer.set(array)
  return buffer
}

function fromBuffer (buffer) {
  const copy = new Uint8Array(buffer.byteLength)
  copy.set(buffer)
  return copy
}

function fromArrayBuffer (arrayBuffer, byteOffset, length) {
  return new Uint8Array(arrayBuffer, byteOffset, length)
}

function includes (buffer, value, byteOffset, encoding) {
  return indexOf(buffer, value, byteOffset, encoding) !== -1
}

function bidirectionalIndexOf (buffer, value, byteOffset, encoding, first) {
  if (buffer.byteLength === 0) return -1

  if (typeof byteOffset === 'string') {
    encoding = byteOffset
    byteOffset = 0
  } else if (byteOffset === undefined) {
    byteOffset = first ? 0 : (buffer.length - 1)
  } else if (byteOffset < 0) {
    byteOffset += buffer.byteLength
  }

  if (byteOffset >= buffer.byteLength) {
    if (first) return -1
    else byteOffset = buffer.byteLength - 1
  } else if (byteOffset < 0) {
    if (first) byteOffset = 0
    else return -1
  }

  if (typeof value === 'string') {
    value = from(value, encoding)
  } else if (typeof value === 'number') {
    value = value & 0xff

    if (first) {
      return buffer.indexOf(value, byteOffset)
    } else {
      return buffer.lastIndexOf(value, byteOffset)
    }
  }

  if (value.byteLength === 0) return -1

  if (first) {
    let foundIndex = -1

    for (let i = byteOffset; i < buffer.byteLength; i++) {
      if (buffer[i] === value[foundIndex === -1 ? 0 : i - foundIndex]) {
        if (foundIndex === -1) foundIndex = i
        if (i - foundIndex + 1 === value.byteLength) return foundIndex
      } else {
        if (foundIndex !== -1) i -= i - foundIndex
        foundIndex = -1
      }
    }
  } else {
    if (byteOffset + value.byteLength > buffer.byteLength) {
      byteOffset = buffer.byteLength - value.byteLength
    }

    for (let i = byteOffset; i >= 0; i--) {
      let found = true

      for (let j = 0; j < value.byteLength; j++) {
        if (buffer[i + j] !== value[j]) {
          found = false
          break
        }
      }

      if (found) return i
    }
  }

  return -1
}

function indexOf (buffer, value, byteOffset, encoding) {
  return bidirectionalIndexOf(buffer, value, byteOffset, encoding, true /* first */)
}

function lastIndexOf (buffer, value, byteOffset, encoding) {
  return bidirectionalIndexOf(buffer, value, byteOffset, encoding, false /* last */)
}

function swap (buffer, n, m) {
  const i = buffer[n]
  buffer[n] = buffer[m]
  buffer[m] = i
}

function swap16 (buffer) {
  const len = buffer.byteLength

  if (len % 2 !== 0) throw new RangeError('Buffer size must be a multiple of 16-bits')

  for (let i = 0; i < len; i += 2) swap(buffer, i, i + 1)

  return buffer
}

function swap32 (buffer) {
  const len = buffer.byteLength

  if (len % 4 !== 0) throw new RangeError('Buffer size must be a multiple of 32-bits')

  for (let i = 0; i < len; i += 4) {
    swap(buffer, i, i + 3)
    swap(buffer, i + 1, i + 2)
  }

  return buffer
}

function swap64 (buffer) {
  const len = buffer.byteLength

  if (len % 8 !== 0) throw new RangeError('Buffer size must be a multiple of 64-bits')

  for (let i = 0; i < len; i += 8) {
    swap(buffer, i, i + 7)
    swap(buffer, i + 1, i + 6)
    swap(buffer, i + 2, i + 5)
    swap(buffer, i + 3, i + 4)
  }

  return buffer
}

function toBuffer (buffer) {
  return buffer
}

function toString (buffer, encoding, start = 0, end = buffer.byteLength) {
  const len = buffer.byteLength

  if (start >= len) return ''
  if (end <= start) return ''
  if (start < 0) start = 0
  if (end > len) end = len

  if (start !== 0 || end < len) buffer = buffer.subarray(start, end)

  return codecFor(encoding).toString(buffer)
}

function write (buffer, string, offset, length, encoding) {
  // write(buffer, string)
  if (offset === undefined) {
    encoding = 'utf8'

  // write(buffer, string, encoding)
  } else if (length === undefined && typeof offset === 'string') {
    encoding = offset
    offset = undefined

  // write(buffer, string, offset, encoding)
  } else if (encoding === undefined && typeof length === 'string') {
    encoding = length
    length = undefined
  }

  return codecFor(encoding).write(buffer, string, offset, length)
}

function writeDoubleLE (buffer, value, offset) {
  if (offset === undefined) offset = 0

  const view = new DataView(buffer.buffer, buffer.byteOffset, buffer.byteLength)
  view.setFloat64(offset, value, true)

  return offset + 8
}

function writeFloatLE (buffer, value, offset) {
  if (offset === undefined) offset = 0

  const view = new DataView(buffer.buffer, buffer.byteOffset, buffer.byteLength)
  view.setFloat32(offset, value, true)

  return offset + 4
}

function writeUInt32LE (buffer, value, offset) {
  if (offset === undefined) offset = 0

  const view = new DataView(buffer.buffer, buffer.byteOffset, buffer.byteLength)
  view.setUint32(offset, value, true)

  return offset + 4
}

function writeInt32LE (buffer, value, offset) {
  if (offset === undefined) offset = 0

  const view = new DataView(buffer.buffer, buffer.byteOffset, buffer.byteLength)
  view.setInt32(offset, value, true)

  return offset + 4
}

function readDoubleLE (buffer, offset) {
  if (offset === undefined) offset = 0

  const view = new DataView(buffer.buffer, buffer.byteOffset, buffer.byteLength)

  return view.getFloat64(offset, true)
}

function readFloatLE (buffer, offset) {
  if (offset === undefined) offset = 0

  const view = new DataView(buffer.buffer, buffer.byteOffset, buffer.byteLength)

  return view.getFloat32(offset, true)
}

function readUInt32LE (buffer, offset) {
  if (offset === undefined) offset = 0

  const view = new DataView(buffer.buffer, buffer.byteOffset, buffer.byteLength)

  return view.getUint32(offset, true)
}

function readInt32LE (buffer, offset) {
  if (offset === undefined) offset = 0

  const view = new DataView(buffer.buffer, buffer.byteOffset, buffer.byteLength)

  return view.getInt32(offset, true)
}

module.exports = exports = {
  isBuffer,
  isEncoding,
  alloc,
  allocUnsafe,
  allocUnsafeSlow,
  byteLength,
  compare,
  concat,
  copy,
  equals,
  fill,
  from,
  includes,
  indexOf,
  lastIndexOf,
  swap16,
  swap32,
  swap64,
  toBuffer,
  toString,
  write,
  writeDoubleLE,
  writeFloatLE,
  writeUInt32LE,
  writeInt32LE,
  readDoubleLE,
  readFloatLE,
  readUInt32LE,
  readInt32LE
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers>tar-stream>b4a",file:"node_modules\\b4a\\browser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\b4a\\lib\\ascii.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cb4a%5Clib%5Cascii.js
      return function (require, module, exports) {
function byteLength (string) {
  return string.length
}

function toString (buffer) {
  const len = buffer.byteLength

  let result = ''

  for (let i = 0; i < len; i++) {
    result += String.fromCharCode(buffer[i])
  }

  return result
}

function write (buffer, string, offset = 0, length = byteLength(string)) {
  const len = Math.min(length, buffer.byteLength - offset)

  for (let i = 0; i < len; i++) {
    buffer[offset + i] = string.charCodeAt(i)
  }

  return len
}

module.exports = {
  byteLength,
  toString,
  write
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers>tar-stream>b4a",file:"node_modules\\b4a\\lib\\ascii.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\b4a\\lib\\base64.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cb4a%5Clib%5Cbase64.js
      return function (require, module, exports) {
const alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'

const codes = new Uint8Array(256)

for (let i = 0; i < alphabet.length; i++) {
  codes[alphabet.charCodeAt(i)] = i
}

codes[/* - */ 0x2d] = 62
codes[/* _ */ 0x5f] = 63

function byteLength (string) {
  let len = string.length

  if (string.charCodeAt(len - 1) === 0x3d) len--
  if (len > 1 && string.charCodeAt(len - 1) === 0x3d) len--

  return (len * 3) >>> 2
}

function toString (buffer) {
  const len = buffer.byteLength

  let result = ''

  for (let i = 0; i < len; i += 3) {
    result += (
      alphabet[buffer[i] >> 2] +
      alphabet[((buffer[i] & 3) << 4) | (buffer[i + 1] >> 4)] +
      alphabet[((buffer[i + 1] & 15) << 2) | (buffer[i + 2] >> 6)] +
      alphabet[buffer[i + 2] & 63]
    )
  }

  if (len % 3 === 2) {
    result = result.substring(0, result.length - 1) + '='
  } else if (len % 3 === 1) {
    result = result.substring(0, result.length - 2) + '=='
  }

  return result
};

function write (buffer, string, offset = 0, length = byteLength(string)) {
  const len = Math.min(length, buffer.byteLength - offset)

  for (let i = 0, j = 0; j < len; i += 4) {
    const a = codes[string.charCodeAt(i)]
    const b = codes[string.charCodeAt(i + 1)]
    const c = codes[string.charCodeAt(i + 2)]
    const d = codes[string.charCodeAt(i + 3)]

    buffer[j++] = (a << 2) | (b >> 4)
    buffer[j++] = ((b & 15) << 4) | (c >> 2)
    buffer[j++] = ((c & 3) << 6) | (d & 63)
  }

  return len
};

module.exports = {
  byteLength,
  toString,
  write
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers>tar-stream>b4a",file:"node_modules\\b4a\\lib\\base64.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\b4a\\lib\\hex.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cb4a%5Clib%5Chex.js
      return function (require, module, exports) {
function byteLength (string) {
  return string.length >>> 1
}

function toString (buffer) {
  const len = buffer.byteLength

  buffer = new DataView(buffer.buffer, buffer.byteOffset, len)

  let result = ''
  let i = 0

  for (let n = len - (len % 4); i < n; i += 4) {
    result += buffer.getUint32(i).toString(16).padStart(8, '0')
  }

  for (; i < len; i++) {
    result += buffer.getUint8(i).toString(16).padStart(2, '0')
  }

  return result
}

function write (buffer, string, offset = 0, length = byteLength(string)) {
  const len = Math.min(length, buffer.byteLength - offset)

  for (let i = 0; i < len; i++) {
    const a = hexValue(string.charCodeAt(i * 2))
    const b = hexValue(string.charCodeAt(i * 2 + 1))

    if (a === undefined || b === undefined) {
      return buffer.subarray(0, i)
    }

    buffer[offset + i] = (a << 4) | b
  }

  return len
}

module.exports = {
  byteLength,
  toString,
  write
}

function hexValue (char) {
  if (char >= 0x30 && char <= 0x39) return char - 0x30
  if (char >= 0x41 && char <= 0x46) return char - 0x41 + 10
  if (char >= 0x61 && char <= 0x66) return char - 0x61 + 10
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers>tar-stream>b4a",file:"node_modules\\b4a\\lib\\hex.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\b4a\\lib\\utf16le.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cb4a%5Clib%5Cutf16le.js
      return function (require, module, exports) {
function byteLength (string) {
  return string.length * 2
}

function toString (buffer) {
  const len = buffer.byteLength

  let result = ''

  for (let i = 0; i < len - 1; i += 2) {
    result += String.fromCharCode(buffer[i] + (buffer[i + 1] * 256))
  }

  return result
}

function write (buffer, string, offset = 0, length = byteLength(string)) {
  const len = Math.min(length, buffer.byteLength - offset)

  let units = len

  for (let i = 0; i < string.length; ++i) {
    if ((units -= 2) < 0) break

    const c = string.charCodeAt(i)
    const hi = c >> 8
    const lo = c % 256

    buffer[offset + i * 2] = lo
    buffer[offset + i * 2 + 1] = hi
  }

  return len
}

module.exports = {
  byteLength,
  toString,
  write
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers>tar-stream>b4a",file:"node_modules\\b4a\\lib\\utf16le.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\b4a\\lib\\utf8.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cb4a%5Clib%5Cutf8.js
      return function (require, module, exports) {
function byteLength (string) {
  let length = 0

  for (let i = 0, n = string.length; i < n; i++) {
    const code = string.charCodeAt(i)

    if (code >= 0xd800 && code <= 0xdbff && i + 1 < n) {
      const code = string.charCodeAt(i + 1)

      if (code >= 0xdc00 && code <= 0xdfff) {
        length += 4
        i++
        continue
      }
    }

    if (code <= 0x7f) length += 1
    else if (code <= 0x7ff) length += 2
    else length += 3
  }

  return length
}

let toString

if (typeof TextDecoder !== 'undefined') {
  const decoder = new TextDecoder()

  toString = function toString (buffer) {
    return decoder.decode(buffer)
  }
} else {
  toString = function toString (buffer) {
    const len = buffer.byteLength

    let output = ''
    let i = 0

    while (i < len) {
      let byte = buffer[i]

      if (byte <= 0x7f) {
        output += String.fromCharCode(byte)
        i++
        continue
      }

      let bytesNeeded = 0
      let codePoint = 0

      if (byte <= 0xdf) {
        bytesNeeded = 1
        codePoint = byte & 0x1f
      } else if (byte <= 0xef) {
        bytesNeeded = 2
        codePoint = byte & 0x0f
      } else if (byte <= 0xf4) {
        bytesNeeded = 3
        codePoint = byte & 0x07
      }

      if (len - i - bytesNeeded > 0) {
        let k = 0

        while (k < bytesNeeded) {
          byte = buffer[i + k + 1]
          codePoint = (codePoint << 6) | (byte & 0x3f)
          k += 1
        }
      } else {
        codePoint = 0xfffd
        bytesNeeded = len - i
      }

      output += String.fromCodePoint(codePoint)
      i += bytesNeeded + 1
    }

    return output
  }
}

let write

if (typeof TextEncoder !== 'undefined') {
  const encoder = new TextEncoder()

  write = function write (buffer, string, offset = 0, length = byteLength(string)) {
    const len = Math.min(length, buffer.byteLength - offset)
    encoder.encodeInto(string, buffer.subarray(offset, offset + len))
    return len
  }
} else {
  write = function write (buffer, string, offset = 0, length = byteLength(string)) {
    const len = Math.min(length, buffer.byteLength - offset)

    buffer = buffer.subarray(offset, offset + len)

    let i = 0
    let j = 0

    while (i < string.length) {
      const code = string.codePointAt(i)

      if (code <= 0x7f) {
        buffer[j++] = code
        i++
        continue
      }

      let count = 0
      let bits = 0

      if (code <= 0x7ff) {
        count = 6
        bits = 0xc0
      } else if (code <= 0xffff) {
        count = 12
        bits = 0xe0
      } else if (code <= 0x1fffff) {
        count = 18
        bits = 0xf0
      }

      buffer[j++] = bits | (code >> count)
      count -= 6

      while (count >= 0) {
        buffer[j++] = 0x80 | ((code >> count) & 0x3f)
        count -= 6
      }

      i += code >= 0x10000 ? 2 : 1
    }

    return len
  }
}

module.exports = {
  byteLength,
  toString,
  write
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers>tar-stream>b4a",file:"node_modules\\b4a\\lib\\utf8.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\base32-encode\\index.js", {"to-data-view":"D:\\code\\v\\metamask-extension\\node_modules\\to-data-view\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbase32-encode%5Cindex.js
      return function (require, module, exports) {
var toDataView = require('to-data-view')

var RFC4648 = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ234567'
var RFC4648_HEX = '0123456789ABCDEFGHIJKLMNOPQRSTUV'
var CROCKFORD = '0123456789ABCDEFGHJKMNPQRSTVWXYZ'

module.exports = function base32Encode (data, variant, options) {
  options = options || {}
  var alphabet, defaultPadding

  switch (variant) {
    case 'RFC3548':
    case 'RFC4648':
      alphabet = RFC4648
      defaultPadding = true
      break
    case 'RFC4648-HEX':
      alphabet = RFC4648_HEX
      defaultPadding = true
      break
    case 'Crockford':
      alphabet = CROCKFORD
      defaultPadding = false
      break
    default:
      throw new Error('Unknown base32 variant: ' + variant)
  }

  var padding = (options.padding !== undefined ? options.padding : defaultPadding)
  var view = toDataView(data)

  var bits = 0
  var value = 0
  var output = ''

  for (var i = 0; i < view.byteLength; i++) {
    value = (value << 8) | view.getUint8(i)
    bits += 8

    while (bits >= 5) {
      output += alphabet[(value >>> (bits - 5)) & 31]
      bits -= 5
    }
  }

  if (bits > 0) {
    output += alphabet[(value << (5 - bits)) & 31]
  }

  if (padding) {
    while ((output.length % 8) !== 0) {
      output += '='
    }
  }

  return output
}

      };
    };
  }
  }
}, {package:"base32-encode",file:"node_modules\\base32-encode\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bech32\\dist\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbech32%5Cdist%5Cindex.js
      return function (require, module, exports) {
'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
exports.bech32m = exports.bech32 = void 0;
const ALPHABET = 'qpzry9x8gf2tvdw0s3jn54khce6mua7l';
const ALPHABET_MAP = {};
for (let z = 0; z < ALPHABET.length; z++) {
    const x = ALPHABET.charAt(z);
    ALPHABET_MAP[x] = z;
}
function polymodStep(pre) {
    const b = pre >> 25;
    return (((pre & 0x1ffffff) << 5) ^
        (-((b >> 0) & 1) & 0x3b6a57b2) ^
        (-((b >> 1) & 1) & 0x26508e6d) ^
        (-((b >> 2) & 1) & 0x1ea119fa) ^
        (-((b >> 3) & 1) & 0x3d4233dd) ^
        (-((b >> 4) & 1) & 0x2a1462b3));
}
function prefixChk(prefix) {
    let chk = 1;
    for (let i = 0; i < prefix.length; ++i) {
        const c = prefix.charCodeAt(i);
        if (c < 33 || c > 126)
            return 'Invalid prefix (' + prefix + ')';
        chk = polymodStep(chk) ^ (c >> 5);
    }
    chk = polymodStep(chk);
    for (let i = 0; i < prefix.length; ++i) {
        const v = prefix.charCodeAt(i);
        chk = polymodStep(chk) ^ (v & 0x1f);
    }
    return chk;
}
function convert(data, inBits, outBits, pad) {
    let value = 0;
    let bits = 0;
    const maxV = (1 << outBits) - 1;
    const result = [];
    for (let i = 0; i < data.length; ++i) {
        value = (value << inBits) | data[i];
        bits += inBits;
        while (bits >= outBits) {
            bits -= outBits;
            result.push((value >> bits) & maxV);
        }
    }
    if (pad) {
        if (bits > 0) {
            result.push((value << (outBits - bits)) & maxV);
        }
    }
    else {
        if (bits >= inBits)
            return 'Excess padding';
        if ((value << (outBits - bits)) & maxV)
            return 'Non-zero padding';
    }
    return result;
}
function toWords(bytes) {
    return convert(bytes, 8, 5, true);
}
function fromWordsUnsafe(words) {
    const res = convert(words, 5, 8, false);
    if (Array.isArray(res))
        return res;
}
function fromWords(words) {
    const res = convert(words, 5, 8, false);
    if (Array.isArray(res))
        return res;
    throw new Error(res);
}
function getLibraryFromEncoding(encoding) {
    let ENCODING_CONST;
    if (encoding === 'bech32') {
        ENCODING_CONST = 1;
    }
    else {
        ENCODING_CONST = 0x2bc830a3;
    }
    function encode(prefix, words, LIMIT) {
        LIMIT = LIMIT || 90;
        if (prefix.length + 7 + words.length > LIMIT)
            throw new TypeError('Exceeds length limit');
        prefix = prefix.toLowerCase();
        // determine chk mod
        let chk = prefixChk(prefix);
        if (typeof chk === 'string')
            throw new Error(chk);
        let result = prefix + '1';
        for (let i = 0; i < words.length; ++i) {
            const x = words[i];
            if (x >> 5 !== 0)
                throw new Error('Non 5-bit word');
            chk = polymodStep(chk) ^ x;
            result += ALPHABET.charAt(x);
        }
        for (let i = 0; i < 6; ++i) {
            chk = polymodStep(chk);
        }
        chk ^= ENCODING_CONST;
        for (let i = 0; i < 6; ++i) {
            const v = (chk >> ((5 - i) * 5)) & 0x1f;
            result += ALPHABET.charAt(v);
        }
        return result;
    }
    function __decode(str, LIMIT) {
        LIMIT = LIMIT || 90;
        if (str.length < 8)
            return str + ' too short';
        if (str.length > LIMIT)
            return 'Exceeds length limit';
        // don't allow mixed case
        const lowered = str.toLowerCase();
        const uppered = str.toUpperCase();
        if (str !== lowered && str !== uppered)
            return 'Mixed-case string ' + str;
        str = lowered;
        const split = str.lastIndexOf('1');
        if (split === -1)
            return 'No separator character for ' + str;
        if (split === 0)
            return 'Missing prefix for ' + str;
        const prefix = str.slice(0, split);
        const wordChars = str.slice(split + 1);
        if (wordChars.length < 6)
            return 'Data too short';
        let chk = prefixChk(prefix);
        if (typeof chk === 'string')
            return chk;
        const words = [];
        for (let i = 0; i < wordChars.length; ++i) {
            const c = wordChars.charAt(i);
            const v = ALPHABET_MAP[c];
            if (v === undefined)
                return 'Unknown character ' + c;
            chk = polymodStep(chk) ^ v;
            // not in the checksum?
            if (i + 6 >= wordChars.length)
                continue;
            words.push(v);
        }
        if (chk !== ENCODING_CONST)
            return 'Invalid checksum for ' + str;
        return { prefix, words };
    }
    function decodeUnsafe(str, LIMIT) {
        const res = __decode(str, LIMIT);
        if (typeof res === 'object')
            return res;
    }
    function decode(str, LIMIT) {
        const res = __decode(str, LIMIT);
        if (typeof res === 'object')
            return res;
        throw new Error(res);
    }
    return {
        decodeUnsafe,
        decode,
        encode,
        toWords,
        fromWordsUnsafe,
        fromWords,
    };
}
exports.bech32 = getLibraryFromEncoding('bech32');
exports.bech32m = getLibraryFromEncoding('bech32m');

      };
    };
  }
  }
}, {package:"bitcoin-address-validation>bech32",file:"node_modules\\bech32\\dist\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\and.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbits%5Cand.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Applies the AND operation, expects two arrays of the same size and returns a new one.
 *
 * @example
 * and([1,0,0,0,1,1,0,1], [0,1,1,0,0,1,0,0]) => [0,0,0,0,0,1,0,0]
 *
 * @param {Array} bits1 input data
 * @param {Array} bits2 input data
 * @return {Array} [bits1 AND bits2]
 */
exports.default = (function (bits1, bits2) {
    var result = [];
    for (var i = 0; i < bits1.length; i++)
        result[i] = (bits1[i] & bits2[i]);
    return result;
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\bits\\and.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\circular-shift-left.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbits%5Ccircular-shift-left.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Circular Shift Left
 *
 * @example
 * circularShiftLeft([1,0,1,1,0,1]) => [0,1,1,0,1,1]
 *
 * @see {@link https://en.wikipedia.org/wiki/Circular_shift}
 *
 * @param {Array} bits input data
 * @param {number} amount how far should it be shifted
 * @return {Array} [ROL bits]
 */
exports.default = (function (bits, amount) {
    var result = [];
    if (amount > bits.length)
        throw new Error('shift amount can’t be larger than bits array length');
    for (var i = 0; i < bits.length; i++)
        result[(bits.length + i - amount) % bits.length] = bits[i];
    return result;
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\bits\\circular-shift-left.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\circular-shift-right.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbits%5Ccircular-shift-right.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Circular Shift Right
 *
 * @example
 * circularShiftRight([1,0,1,1,0,1]) => [1,1,0,1,1,0]
 *
 * @see {@link https://en.wikipedia.org/wiki/Circular_shift}
 *
 * @param {Array} bits input data
 * @param {number} amount how far should it be shifted
 * @return {Array} [ROR bits]
 */
exports.default = (function (bits, amount) {
    var result = [];
    if (amount > bits.length)
        throw new Error('shift amount can’t be larger than bits array length');
    for (var i = 0; i < bits.length; i++)
        result[(i + amount) % bits.length] = bits[i];
    return result;
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\bits\\circular-shift-right.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\index.js", {"./and":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\and.js","./circular-shift-left":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\circular-shift-left.js","./circular-shift-right":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\circular-shift-right.js","./nand":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\nand.js","./nor":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\nor.js","./not":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\not.js","./or":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\or.js","./reduce-and":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\reduce-and.js","./reduce-nand":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\reduce-nand.js","./reduce-nor":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\reduce-nor.js","./reduce-or":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\reduce-or.js","./reduce-xnor":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\reduce-xnor.js","./reduce-xor":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\reduce-xor.js","./to-boolean":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\to-boolean.js","./to-string":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\to-string.js","./xnor":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\xnor.js","./xor":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\xor.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbits%5Cindex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.xor = exports.xnor = exports.toString = exports.toBoolean = exports.reduceXor = exports.reduceXnor = exports.reduceOr = exports.reduceNor = exports.reduceNand = exports.reduceAnd = exports.or = exports.not = exports.nor = exports.nand = exports.circularShiftRight = exports.circularShiftLeft = exports.and = void 0;
var and_1 = require("./and");
exports.and = and_1.default;
var circular_shift_left_1 = require("./circular-shift-left");
exports.circularShiftLeft = circular_shift_left_1.default;
var circular_shift_right_1 = require("./circular-shift-right");
exports.circularShiftRight = circular_shift_right_1.default;
var nand_1 = require("./nand");
exports.nand = nand_1.default;
var nor_1 = require("./nor");
exports.nor = nor_1.default;
var not_1 = require("./not");
exports.not = not_1.default;
var or_1 = require("./or");
exports.or = or_1.default;
var reduce_and_1 = require("./reduce-and");
exports.reduceAnd = reduce_and_1.default;
var reduce_nand_1 = require("./reduce-nand");
exports.reduceNand = reduce_nand_1.default;
var reduce_nor_1 = require("./reduce-nor");
exports.reduceNor = reduce_nor_1.default;
var reduce_or_1 = require("./reduce-or");
exports.reduceOr = reduce_or_1.default;
var reduce_xnor_1 = require("./reduce-xnor");
exports.reduceXnor = reduce_xnor_1.default;
var reduce_xor_1 = require("./reduce-xor");
exports.reduceXor = reduce_xor_1.default;
var to_boolean_1 = require("./to-boolean");
exports.toBoolean = to_boolean_1.default;
var to_string_1 = require("./to-string");
exports.toString = to_string_1.default;
var xnor_1 = require("./xnor");
exports.xnor = xnor_1.default;
var xor_1 = require("./xor");
exports.xor = xor_1.default;
exports.default = {
    and: and_1.default,
    circularShiftLeft: circular_shift_left_1.default,
    circularShiftRight: circular_shift_right_1.default,
    nand: nand_1.default,
    nor: nor_1.default,
    not: not_1.default,
    or: or_1.default,
    reduceAnd: reduce_and_1.default,
    reduceNand: reduce_nand_1.default,
    reduceNor: reduce_nor_1.default,
    reduceOr: reduce_or_1.default,
    reduceXnor: reduce_xnor_1.default,
    reduceXor: reduce_xor_1.default,
    toBoolean: to_boolean_1.default,
    toString: to_string_1.default,
    xnor: xnor_1.default,
    xor: xor_1.default,
};

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\bits\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\nand.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbits%5Cnand.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Applies the NAND operation, expects two arrays of the same size and returns a new one.
 *
 * @example
 * nand([1,0,0,0,1,1,0,1], [0,1,1,0,0,1,0,0]) => [1,1,1,1,1,0,1,1]
 *
 * @param {Array} bits1 input data
 * @param {Array} bits2 input data
 * @return {Array} [bits1 NAND bits2]
 */
exports.default = (function (bits1, bits2) {
    var result = [];
    for (var i = 0; i < bits1.length; i++)
        result[i] = ((bits1[i] & bits2[i]) ^ 1);
    return result;
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\bits\\nand.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\nor.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbits%5Cnor.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Applies the NOR operation, expects two arrays of the same size and returns a new one.
 *
 * @example
 * nor([1,0,0,0,1,1,0,1], [0,1,1,0,0,1,0,0]) => [0,0,0,1,0,0,1,0]
 *
 * @param {Array} bits1 input data
 * @param {Array} bits2 input data
 * @return {Array} [bits1 NOR bits2]
 */
exports.default = (function (bits1, bits2) {
    var result = [];
    for (var i = 0; i < bits1.length; i++)
        result[i] = ((bits1[i] | bits2[i]) ^ 1);
    return result;
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\bits\\nor.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\not.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbits%5Cnot.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Flips all given bits and returns the flipped bits.
 *
 * @example
 * not([1,0,1,1,0,1]) => [0,1,0,0,1,0]
 *
 * @param {Array} bits input data
 * @return {Array} [NOT bits]
 */
exports.default = (function (bits) {
    var result = [];
    for (var i = 0; i < bits.length; i++)
        result[i] = (bits[i] ^ 1);
    return result;
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\bits\\not.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\or.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbits%5Cor.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Applies the OR operation, expects two arrays of the same size and returns a new one.
 *
 * @example
 * or([1,0,0,0,1,1,0,1], [0,1,1,0,0,1,0,0]) => [1,1,1,0,1,1,0,1]
 *
 * @param {Array} bits1 input data
 * @param {Array} bits2 input data
 * @return {Array} [bits1 OR bits2]
 */
exports.default = (function (bits1, bits2) {
    var result = [];
    for (var i = 0; i < bits1.length; i++)
        result[i] = (bits1[i] | bits2[i]);
    return result;
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\bits\\or.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\reduce-and.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbits%5Creduce-and.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Applies the AND operation on the given bits. Returns one bit.
 * Throws if less than 2 bits are given.
 *
 * @example
 * reduceAnd([1, 0, 0, 0, 1, 1, 0, 1]) => 0
 *
 * @param {Array} bits input data
 * @return {Integer} AND bits
 */
exports.default = (function (bits) {
    if (bits.length < 2)
        throw new RangeError('Not enough bits.');
    var result = bits[0];
    for (var i = 1; i < bits.length; i++)
        result &= bits[i];
    return result;
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\bits\\reduce-and.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\reduce-nand.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbits%5Creduce-nand.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Applies the NAND operation on the given bits. Returns one bit.
 * Throws if less than 2 bits are given.
 *
 * @example
 * reduceNand([1, 0, 0, 0, 1, 1, 0, 1]) => 0
 *
 * @param {Array} bits input data
 * @return {Integer} NAND bits
 */
exports.default = (function (bits) {
    if (bits.length < 2)
        throw new RangeError('Not enough bits.');
    var result = bits[0];
    for (var i = 1; i < bits.length; i++)
        result = ((result & bits[i]) ^ 1);
    return result;
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\bits\\reduce-nand.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\reduce-nor.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbits%5Creduce-nor.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Applies the NOR operation on the given bits. Returns one bit.
 * Throws if less than 2 bits are given.
 *
 * @example
 * reduceNor([1, 0, 0, 0, 1, 1, 0, 1]) => 0
 *
 * @param {Array} bits input data
 * @return {Integer} NOR bits
 */
exports.default = (function (bits) {
    if (bits.length < 2)
        throw new RangeError('Not enough bits.');
    var result = bits[0];
    for (var i = 1; i < bits.length; i++)
        result = ((result | bits[i]) ^ 1);
    return result;
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\bits\\reduce-nor.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\reduce-or.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbits%5Creduce-or.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Applies the OR operation on the given bits. Returns one bit.
 * Throws if less than 2 bits are given.
 *
 * @example
 * reduceOr([1, 0, 0, 0, 1, 1, 0, 1]) => 1
 *
 * @param {Array} bits input data
 * @return {Integer} OR bits
 */
exports.default = (function (bits) {
    if (bits.length < 2)
        throw new RangeError('Not enough bits.');
    var result = bits[0];
    for (var i = 1; i < bits.length; i++)
        result |= bits[i];
    return result;
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\bits\\reduce-or.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\reduce-xnor.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbits%5Creduce-xnor.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Applies the XNOR operation on the given bits. Returns one bit.
 * Throws if less than 2 bits are given.
 *
 * @example
 * reduceXnor([1, 0, 0, 0, 1, 1, 0, 1]) => 1
 *
 * @param {Array} bits input data
 * @return {Integer} XNOR bits
 */
exports.default = (function (bits) {
    if (bits.length < 2)
        throw new RangeError('Not enough bits.');
    var result = bits[0];
    for (var i = 1; i < bits.length; i++)
        result ^= bits[i] ^ 1;
    return result;
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\bits\\reduce-xnor.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\reduce-xor.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbits%5Creduce-xor.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Applies the XOR operation on the given bits. Returns one bit.
 * Throws if less than 2 bits are given.
 *
 * @example
 * reduceXor([1, 0, 0, 0, 1, 1, 0, 1]) => 0
 *
 * @param {Array} bits input data
 * @return {Integer} XOR bits
 */
exports.default = (function (bits) {
    if (bits.length < 2)
        throw new RangeError('Not enough bits.');
    var result = bits[0];
    for (var i = 1; i < bits.length; i++)
        result ^= bits[i];
    return result;
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\bits\\reduce-xor.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\to-boolean.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbits%5Cto-boolean.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Converts a bit array to a boolean array.
 *
 * @example toBoolean([0, 1]) => [false, true]
 * @param {Array} bits input data
 * @returns {Array} boolean bits
 */
exports.default = (function (bits) {
    var result = [];
    for (var i = 0; i < bits.length; i++)
        result[i] = bits[i] === 1;
    return result;
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\bits\\to-boolean.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\to-string.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbits%5Cto-string.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Converts a bit array to a string. If defined, inserts spacer every spacing characters, but never inserts it as the last substring.
 *
 * @example
 * toString([1,0,1,0,1,0], 2, '_') => '10_10_10'
 *
 * @param {Array} bits the bits to convert
 * @param {Number} spacing where to place the spacers
 * @param {Number} spacer the string used as a spacer
 * @return {String}
 */
exports.default = (function (bits, spacing, spacer) {
    if (spacing === void 0) { spacing = 0; }
    if (spacer === void 0) { spacer = ' '; }
    if (!spacing)
        return bits.join('');
    var result = '';
    for (var i = 0; i < bits.length; i++) {
        result += "" + bits[i];
        if (i % spacing === spacing - 1 && i !== bits.length - 1)
            result += spacer;
    }
    return result;
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\bits\\to-string.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\xnor.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbits%5Cxnor.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Applies the exclusive NOR operation, expects two arrays of the same size and returns a new one.
 *
 * @example
 * xnor([1,0,0,0,1,1,0,1], [0,1,1,0,0,1,0,0]) => [0,0,0,1,0,1,1,0]
 *
 * @param {Array} bits1 input data
 * @param {Array} bits2 input data
 * @return {Array} [bits1 XNOR bits2]
 */
exports.default = (function (bits1, bits2) {
    var result = [];
    for (var i = 0; i < bits1.length; i++)
        result[i] = (bits1[i] ^ bits2[i] ^ 1);
    return result;
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\bits\\xnor.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\xor.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbits%5Cxor.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Applies the exclusive or operation, expects two arrays of the same size and returns a new one.
 *
 * @example
 * xor([1,0,0,0,1,1,0,1], [0,1,1,0,0,1,0,0]) => [1,1,1,0,1,0,0,1]
 *
 * @param {Array} bits1 input data
 * @param {Array} bits2 input data
 * @return {Array} [bits1 XOR bits2]
 */
exports.default = (function (bits1, bits2) {
    var result = [];
    for (var i = 0; i < bits1.length; i++)
        result[i] = (bits1[i] ^ bits2[i]);
    return result;
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\bits\\xor.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\and.js", {"buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbuffer%5Cand.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Applies a bitwise AND to the contents of two buffers. Returns a new buffer.
 *
 * @example
 * bitwise.buffer.and(a, b, false) => Buffer(a AND b)
 *
 * @param {Buffer} a first buffer
 * @param {Buffer} b second buffer
 * @param {Boolean} isLooping loop through first buffer
 * @return {Buffer} a AND b
 */
exports.default = (function (a, b, isLooping) {
    if (isLooping === void 0) { isLooping = false; }
    var length = isLooping ? b.length : a.length;
    var result = Buffer.alloc(length);
    for (var i = 0; i < length; i++) {
        var j = isLooping ? i % a.length : i;
        result[i] = a[j] & b[i];
    }
    return result;
});

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\buffer\\and.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\create.js", {"../byte/write":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\byte\\write.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbuffer%5Ccreate.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var write_1 = require("../byte/write");
/**
 * Creates a new buffer and writes the given bits.
 *
 * @example
 * createBuffer([1,1,1,1, 0,0,0,1, 1,0,1,0]) => buffer with data 1111 0001 1010 0000
 *
 * @param {Array} bits an array containing the bits to insert
 * @returns {Buffer}
 */
exports.default = (function (bits) {
    var data = [0, 0, 0, 0, 0, 0, 0, 0];
    var buffer = Buffer.alloc(Math.ceil(bits.length / 8));
    for (var i = 0; i < buffer.length; i++) {
        for (var j = 0; j < 8; j++) {
            if (bits[i * 8 + j])
                data[j] = bits[i * 8 + j];
            else
                data[j] = 0;
        }
        buffer[i] = write_1.default(data);
    }
    return buffer;
});

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\buffer\\create.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\index.js", {"./and":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\and.js","./create":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\create.js","./modify":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\modify.js","./nand":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\nand.js","./nor":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\nor.js","./not":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\not.js","./or":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\or.js","./read":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\read.js","./read-int":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\read-int.js","./read-u-int":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\read-u-int.js","./xnor":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\xnor.js","./xor":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\xor.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbuffer%5Cindex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.xor = exports.xnor = exports.readUInt = exports.readInt = exports.read = exports.or = exports.not = exports.nor = exports.nand = exports.modify = exports.create = exports.and = void 0;
var and_1 = require("./and");
exports.and = and_1.default;
var create_1 = require("./create");
exports.create = create_1.default;
var modify_1 = require("./modify");
exports.modify = modify_1.default;
var nand_1 = require("./nand");
exports.nand = nand_1.default;
var nor_1 = require("./nor");
exports.nor = nor_1.default;
var not_1 = require("./not");
exports.not = not_1.default;
var or_1 = require("./or");
exports.or = or_1.default;
var read_1 = require("./read");
exports.read = read_1.default;
var read_int_1 = require("./read-int");
exports.readInt = read_int_1.default;
var read_u_int_1 = require("./read-u-int");
exports.readUInt = read_u_int_1.default;
var xnor_1 = require("./xnor");
exports.xnor = xnor_1.default;
var xor_1 = require("./xor");
exports.xor = xor_1.default;
exports.default = {
    and: and_1.default,
    create: create_1.default,
    modify: modify_1.default,
    nand: nand_1.default,
    nor: nor_1.default,
    not: not_1.default,
    or: or_1.default,
    read: read_1.default,
    readInt: read_int_1.default,
    readUInt: read_u_int_1.default,
    xnor: xnor_1.default,
    xor: xor_1.default,
};

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\buffer\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\modify.js", {"../byte/write":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\byte\\write.js","./read":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\read.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbuffer%5Cmodify.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var write_1 = require("../byte/write");
var read_1 = require("./read");
/**
 * Modifies the buffer's bits to equal newBits starting at bitOffset.
 *
 * @example
 * modifyBuffer(buffer, [0,0,1,0], 0) => buffer was modified
 *
 * @param {Buffer} buffer the buffer to modify
 * @param {Array} bits the bits to insert
 * @param {Number} offset where to start (in bits)
 * @returns {undefined}
 */
exports.default = (function (buffer, bits, offset) {
    if (offset === void 0) { offset = 0; }
    var start = Math.floor(offset / 8);
    var end = Math.ceil((offset + bits.length) / 8);
    var subBuffer = buffer.slice(start, end);
    var byteData = read_1.default(subBuffer);
    var subOffset = offset % 8;
    for (var i = 0; i < bits.length; i++)
        byteData[subOffset++] = bits[i];
    var length = end - start;
    for (var i_1 = 0; i_1 < length; i_1++)
        subBuffer[i_1] = write_1.default(byteData.slice(i_1 * 8, (i_1 + 1) * 8));
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\buffer\\modify.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\nand.js", {"buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbuffer%5Cnand.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Applies a bitwise NAND to the contents of two buffers. Returns a new buffer.
 *
 * @example
 * bitwise.buffer.nand(a, b, false) => Buffer(a NAND b)
 *
 * @param {Buffer} a first buffer
 * @param {Buffer} b second buffer
 * @param {Boolean} isLooping loop through first buffer
 * @return {Buffer} a NAND b
 */
exports.default = (function (a, b, isLooping) {
    if (isLooping === void 0) { isLooping = false; }
    var length = isLooping ? b.length : a.length;
    var result = Buffer.alloc(length);
    for (var i = 0; i < length; i++) {
        var j = isLooping ? i % a.length : i;
        result[i] = ~(a[j] & b[i]);
    }
    return result;
});

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\buffer\\nand.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\nor.js", {"buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbuffer%5Cnor.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Applies a bitwise NOR to the contents of two buffers. Returns a new buffer.
 *
 * @example
 * bitwise.buffer.nor(a, b, false) => Buffer(a NOR b)
 *
 * @param {Buffer} a first buffer
 * @param {Buffer} b second buffer
 * @param {Boolean} isLooping loop through first buffer
 * @return {Buffer} a NOR b
 */
exports.default = (function (a, b, isLooping) {
    if (isLooping === void 0) { isLooping = false; }
    var length = isLooping ? b.length : a.length;
    var result = Buffer.alloc(length);
    for (var i = 0; i < length; i++) {
        var j = isLooping ? i % a.length : i;
        result[i] = ~(a[j] | b[i]);
    }
    return result;
});

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\buffer\\nor.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\not.js", {"buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbuffer%5Cnot.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Applies a bitwise NOT to the contents of a buffer. Returns a new buffer.
 *
 * @example
 * bitwise.buffer.not(buffer) => Buffer(NOT buffer)
 *
 * @param {Buffer} buffer input data
 * @return {Buffer} Buffer(NOT buffer)
 */
exports.default = (function (buffer) {
    var result = Buffer.alloc(buffer.length);
    for (var i = 0; i < buffer.length; i++)
        result[i] = ~buffer[i];
    return result;
});

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\buffer\\not.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\or.js", {"buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbuffer%5Cor.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Applies a bitwise OR to the contents of two buffers. Returns a new buffer.
 *
 * @example
 * bitwise.buffer.or(a, b, false) => Buffer(a OR b)
 *
 * @param {Buffer} a first buffer
 * @param {Buffer} b second buffer
 * @param {Boolean} isLooping loop through first buffer
 * @return {Buffer} a OR b
 */
exports.default = (function (a, b, isLooping) {
    if (isLooping === void 0) { isLooping = false; }
    var length = isLooping ? b.length : a.length;
    var result = Buffer.alloc(length);
    for (var i = 0; i < length; i++) {
        var j = isLooping ? i % a.length : i;
        result[i] = a[j] | b[i];
    }
    return result;
});

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\buffer\\or.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\read-int.js", {"../bits/not":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\not.js","../utilities":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\utilities.js","./read":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\read.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbuffer%5Cread-int.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utilities_1 = require("../utilities");
var not_1 = require("../bits/not");
var read_1 = require("./read");
/**
 * Converts a section of a buffer to a signed integer.
 *
 * @example
 * // buffer 11110110
 * readUInt(buffer, 3, 5) => -10
 *
 * @param {Buffer} buffer the buffer to extract information from
 * @param {Number} length the length of the signed integer (in bits)
 * @param {Number} offset where to start (in bits)
 * @return {Number}
 */
exports.default = (function (buffer, offset, length) {
    if (offset === void 0) { offset = 0; }
    if (length === void 0) { length = 8; }
    var bits = read_1.default(buffer, offset, length);
    if (bits[0] === 0) {
        var result = 0;
        for (var i = 0; i < length; i++)
            if (bits[i])
                result += utilities_1.p2[length - i - 1];
        return result;
    }
    else {
        var result = -1;
        var inverted = not_1.default(bits);
        for (var i = 0; i < length; i++)
            if (inverted[i])
                result -= utilities_1.p2[length - i - 1];
        return result;
    }
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\buffer\\read-int.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\read-u-int.js", {"../utilities":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\utilities.js","./read":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\read.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbuffer%5Cread-u-int.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utilities_1 = require("../utilities");
var read_1 = require("./read");
/**
 * Converts a section of a buffer to an unsigned integer.
 *
 * @example
 * // buffer 11110110
 * readUInt(buffer, 3, 5) => 22
 *
 * @param {Buffer} buffer the buffer to extract information from
 * @param {Number} length the length of the unsigned integer (in bits)
 * @param {Number} offset where to start (in bits)
 * @returns {Number}
 */
exports.default = (function (buffer, offset, length) {
    if (offset === void 0) { offset = 0; }
    if (length === void 0) { length = 8; }
    var arr = read_1.default(buffer, offset, length);
    var result = 0;
    for (var i = 0; i < length; i++)
        result += arr[i] * utilities_1.p2[length - i - 1];
    return result;
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\buffer\\read-u-int.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\read.js", {"../byte/read":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\byte\\read.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbuffer%5Cread.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var read_1 = require("../byte/read");
/**
 * Returns an Array containing bitLength bits starting at bitOffset.
 *
 * @example
 * readBuffer(buffer, 2, 4) => [0,0,1,0]
 *
 * @param {Buffer} buffer the buffer to read
 * @param {Number} offset where to start (in bits)
 * @param {Number} length how many bits to read
 * @returns {Array}
 */
exports.default = (function (buffer, offset, length) {
    if (offset === void 0) { offset = 0; }
    if (!length)
        length = buffer.length * 8 - offset;
    var start = Math.floor(offset / 8);
    var bytesToRead = Math.floor(length / 8) + 2;
    var arr = [];
    arr.length = bytesToRead * 8;
    for (var i = 0; i < bytesToRead; i++) {
        var toRead = buffer[start + i];
        if (toRead === undefined)
            continue;
        var bits = read_1.default(buffer[start + i]);
        arr[i * 8] = bits[0];
        arr[i * 8 + 1] = bits[1];
        arr[i * 8 + 2] = bits[2];
        arr[i * 8 + 3] = bits[3];
        arr[i * 8 + 4] = bits[4];
        arr[i * 8 + 5] = bits[5];
        arr[i * 8 + 6] = bits[6];
        arr[i * 8 + 7] = bits[7];
    }
    var subOffset = offset % 8;
    return arr.slice(subOffset, subOffset + length);
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\buffer\\read.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\xnor.js", {"buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbuffer%5Cxnor.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Applies a bitwise XNOR to the contents of two buffers. Returns a new buffer.
 *
 * @example
 * bitwise.buffer.xnor(a, b, false) => Buffer(a XNOR b)
 *
 * @param {Buffer} a first buffer
 * @param {Buffer} b second buffer
 * @param {Boolean} isLooping loop through first buffer
 * @return {Buffer} a XNOR b
 */
exports.default = (function (a, b, isLooping) {
    if (isLooping === void 0) { isLooping = false; }
    var length = isLooping ? b.length : a.length;
    var result = Buffer.alloc(length);
    for (var i = 0; i < length; i++) {
        var j = isLooping ? i % a.length : i;
        result[i] = ~(a[j] ^ b[i]);
    }
    return result;
});

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\buffer\\xnor.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\xor.js", {"buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbuffer%5Cxor.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Applies a bitwise XOR to the contents of two buffers. Returns a new buffer.
 *
 * @example
 * bitwise.buffer.xor(a, b, false) => Buffer(a XOR b)
 *
 * @param {Buffer} a first buffer
 * @param {Buffer} b second buffer
 * @param {Boolean} isLooping loop through first buffer
 * @return {Buffer} a XOR b
 */
exports.default = (function (a, b, isLooping) {
    if (isLooping === void 0) { isLooping = false; }
    var length = isLooping ? b.length : a.length;
    var result = Buffer.alloc(length);
    for (var i = 0; i < length; i++) {
        var j = isLooping ? i % a.length : i;
        result[i] = a[j] ^ b[i];
    }
    return result;
});

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\buffer\\xor.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\byte\\index.js", {"./read":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\byte\\read.js","./write":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\byte\\write.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbyte%5Cindex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.write = exports.read = void 0;
var read_1 = require("./read");
exports.read = read_1.default;
var write_1 = require("./write");
exports.write = write_1.default;
exports.default = { read: read_1.default, write: write_1.default };

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\byte\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\byte\\read.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbyte%5Cread.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Returns an Array of length 8 containing the read bits.
 *
 * @example
 * byte.read(42) => [0,0,1,0,1,0,1,0]
 *
 * @param {Number} byte one byte
 * @return {Array}
 */
exports.default = (function (byte) {
    if (byte > 255 || byte < 0 || ~~byte !== byte)
        throw new RangeError('invalid byte');
    var result = [0, 0, 0, 0, 0, 0, 0, 0];
    for (var i = 0; i < 8; i++)
        result[7 - i] = ((byte >> i) & 1);
    return result;
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\byte\\read.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\byte\\write.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cbyte%5Cwrite.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Returns a UInt8 (0-255) which equals the given bits.
 *
 * @example
 * byte.write([0,0,1,0,1,0,1,0]) => 42
 *
 * @param {Array} byte 8 bits
 * @return {Number} 8-bit unsigned integer
 */
exports.default = (function (byte) {
    if (!Array.isArray(byte) || byte.length !== 8)
        throw new RangeError('invalid array length');
    var data = 0;
    for (var i = 0; i < 8; i++)
        if (byte[7 - i])
            data |= 1 << i;
    return data;
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\byte\\write.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\index.js", {"./bits":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\bits\\index.js","./buffer":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\buffer\\index.js","./byte":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\byte\\index.js","./integer":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\integer\\index.js","./nibble":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\nibble\\index.js","./string":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\string\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cindex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.string = exports.nibble = exports.integer = exports.byte = exports.buffer = exports.bits = void 0;
var bits_1 = require("./bits");
exports.bits = bits_1.default;
var buffer_1 = require("./buffer");
exports.buffer = buffer_1.default;
var byte_1 = require("./byte");
exports.byte = byte_1.default;
var integer_1 = require("./integer");
exports.integer = integer_1.default;
var nibble_1 = require("./nibble");
exports.nibble = nibble_1.default;
var string_1 = require("./string");
exports.string = string_1.default;
var bitwise = { bits: bits_1.default, buffer: buffer_1.default, byte: byte_1.default, integer: integer_1.default, nibble: nibble_1.default, string: string_1.default };
exports.default = bitwise;

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\integer\\get-bit.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cinteger%5Cget-bit.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Gets the value of a specific bit.
 * @example bitwise.integer.getBit(128, 7) => 1
 * @param {Integer} int32 input number
 * @param {Integer} position bit's position
 * @returns {Integer} bit's value
 */
exports.default = (function (int32, position) {
    return ((int32 >> position) & 1);
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\integer\\get-bit.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\integer\\index.js", {"./get-bit":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\integer\\get-bit.js","./set-bit":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\integer\\set-bit.js","./toggle-bit":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\integer\\toggle-bit.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cinteger%5Cindex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toggleBit = exports.setBit = exports.getBit = void 0;
var get_bit_1 = require("./get-bit");
exports.getBit = get_bit_1.default;
var set_bit_1 = require("./set-bit");
exports.setBit = set_bit_1.default;
var toggle_bit_1 = require("./toggle-bit");
exports.toggleBit = toggle_bit_1.default;
exports.default = { getBit: get_bit_1.default, setBit: set_bit_1.default, toggleBit: toggle_bit_1.default };

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\integer\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\integer\\set-bit.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cinteger%5Cset-bit.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Sets the value of a specific bit.
 * @example bitwise.integer.set(128, 7, 0) => 0
 * @param {Integer} int32 input number
 * @param {Integer} position bit’s position
 * @param {Integer} value bit’s new value
 * @returns {Integer} resulting number
 */
exports.default = (function (int32, position, value) {
    return (value === 1 ? int32 | (1 << position) : int32 & ~(1 << position));
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\integer\\set-bit.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\integer\\toggle-bit.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cinteger%5Ctoggle-bit.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Toggles a specific bit.
 * @example bitwise.integer.getBit(128, 7) => 0
 * @param {Integer} int32 input number
 * @param {Integer} position bit’s position
 * @returns {Integer} updated number
 */
exports.default = (function (int32, position) { return int32 ^ (1 << position); });

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\integer\\toggle-bit.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\nibble\\index.js", {"./read":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\nibble\\read.js","./write":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\nibble\\write.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cnibble%5Cindex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.write = exports.read = void 0;
var read_1 = require("./read");
exports.read = read_1.default;
var write_1 = require("./write");
exports.write = write_1.default;
exports.default = { read: read_1.default, write: write_1.default };

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\nibble\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\nibble\\read.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cnibble%5Cread.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Returns an Array of length 8 containing the read bits.
 *
 * @example
 * nibble.read(15) => [1,1,1,1]
 *
 * @param {Number} nibble one nibble
 * @return {Array}
 */
exports.default = (function (nibble) {
    if (nibble < 16 && nibble >= 0 && Math.floor(nibble) === nibble) {
        var result = [0, 0, 0, 0];
        for (var i = 0; i < 4; i++)
            result[3 - i] = ((nibble >> i) & 1);
        return result;
    }
    else
        throw new RangeError('invalid array length');
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\nibble\\read.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\nibble\\write.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cnibble%5Cwrite.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Returns a Nibble (0-15) which equals the given bits.
 *
 * @example
 * byte.write([1,0,1,0]) => 10
 *
 * @param {Array} nibble 4-bit unsigned integer
 * @return {Number}
 */
exports.default = (function (nibble) {
    if (!Array.isArray(nibble) || nibble.length !== 4)
        throw new RangeError('invalid array length');
    var result = 0;
    for (var i = 0; i < 4; i++)
        if (nibble[3 - i])
            result |= 1 << i;
    return result;
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\nibble\\write.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\string\\index.js", {"./to-bits":"D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\string\\to-bits.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cstring%5Cindex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toBits = void 0;
var to_bits_1 = require("./to-bits");
exports.toBits = to_bits_1.default;
exports.default = { toBits: to_bits_1.default };

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\string\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\string\\to-bits.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cstring%5Cto-bits.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Converts a string into an array of bits. Ignores all characters except 1 and 0.
 *
 * @example
 * toBits('10 10 12$%_.0') => [1,0,1,0,1,0]
 *
 * @param {String} string the string to convert
 * @returns {Array} resulting array of bits
 */
exports.default = (function (string) {
    var result = [];
    for (var i = 0; i < string.length; i++) {
        if (string[i] === '1')
            result.push(1);
        else if (string[i] === '0')
            result.push(0);
    }
    return result;
});

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\string\\to-bits.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\bitwise\\utilities.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cbitwise%5Cutilities.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.p2 = void 0;
// 32-bit powers of two wouldn't be possible with <<
exports.p2 = [];
for (var i = 0; i < 32; i++)
    exports.p2[i] = Math.pow(2, i);

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bitwise",file:"node_modules\\bitwise\\utilities.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\borc\\node_modules\\bignumber.js\\bignumber.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cborc%5Cnode_modules%5Cbignumber.js%5Cbignumber.js
      return function (require, module, exports) {
;(function (globalObject) {
  'use strict';

/*
 *      bignumber.js v9.3.0
 *      A JavaScript library for arbitrary-precision arithmetic.
 *      https://github.com/MikeMcl/bignumber.js
 *      Copyright (c) 2025 Michael Mclaughlin <M8ch88l@gmail.com>
 *      MIT Licensed.
 *
 *      BigNumber.prototype methods     |  BigNumber methods
 *                                      |
 *      absoluteValue            abs    |  clone
 *      comparedTo                      |  config               set
 *      decimalPlaces            dp     |      DECIMAL_PLACES
 *      dividedBy                div    |      ROUNDING_MODE
 *      dividedToIntegerBy       idiv   |      EXPONENTIAL_AT
 *      exponentiatedBy          pow    |      RANGE
 *      integerValue                    |      CRYPTO
 *      isEqualTo                eq     |      MODULO_MODE
 *      isFinite                        |      POW_PRECISION
 *      isGreaterThan            gt     |      FORMAT
 *      isGreaterThanOrEqualTo   gte    |      ALPHABET
 *      isInteger                       |  isBigNumber
 *      isLessThan               lt     |  maximum              max
 *      isLessThanOrEqualTo      lte    |  minimum              min
 *      isNaN                           |  random
 *      isNegative                      |  sum
 *      isPositive                      |
 *      isZero                          |
 *      minus                           |
 *      modulo                   mod    |
 *      multipliedBy             times  |
 *      negated                         |
 *      plus                            |
 *      precision                sd     |
 *      shiftedBy                       |
 *      squareRoot               sqrt   |
 *      toExponential                   |
 *      toFixed                         |
 *      toFormat                        |
 *      toFraction                      |
 *      toJSON                          |
 *      toNumber                        |
 *      toPrecision                     |
 *      toString                        |
 *      valueOf                         |
 *
 */


  var BigNumber,
    isNumeric = /^-?(?:\d+(?:\.\d*)?|\.\d+)(?:e[+-]?\d+)?$/i,
    mathceil = Math.ceil,
    mathfloor = Math.floor,

    bignumberError = '[BigNumber Error] ',
    tooManyDigits = bignumberError + 'Number primitive has more than 15 significant digits: ',

    BASE = 1e14,
    LOG_BASE = 14,
    MAX_SAFE_INTEGER = 0x1fffffffffffff,         // 2^53 - 1
    // MAX_INT32 = 0x7fffffff,                   // 2^31 - 1
    POWS_TEN = [1, 10, 100, 1e3, 1e4, 1e5, 1e6, 1e7, 1e8, 1e9, 1e10, 1e11, 1e12, 1e13],
    SQRT_BASE = 1e7,

    // EDITABLE
    // The limit on the value of DECIMAL_PLACES, TO_EXP_NEG, TO_EXP_POS, MIN_EXP, MAX_EXP, and
    // the arguments to toExponential, toFixed, toFormat, and toPrecision.
    MAX = 1E9;                                   // 0 to MAX_INT32


  /*
   * Create and return a BigNumber constructor.
   */
  function clone(configObject) {
    var div, convertBase, parseNumeric,
      P = BigNumber.prototype = { constructor: BigNumber, toString: null, valueOf: null },
      ONE = new BigNumber(1),


      //----------------------------- EDITABLE CONFIG DEFAULTS -------------------------------


      // The default values below must be integers within the inclusive ranges stated.
      // The values can also be changed at run-time using BigNumber.set.

      // The maximum number of decimal places for operations involving division.
      DECIMAL_PLACES = 20,                     // 0 to MAX

      // The rounding mode used when rounding to the above decimal places, and when using
      // toExponential, toFixed, toFormat and toPrecision, and round (default value).
      // UP         0 Away from zero.
      // DOWN       1 Towards zero.
      // CEIL       2 Towards +Infinity.
      // FLOOR      3 Towards -Infinity.
      // HALF_UP    4 Towards nearest neighbour. If equidistant, up.
      // HALF_DOWN  5 Towards nearest neighbour. If equidistant, down.
      // HALF_EVEN  6 Towards nearest neighbour. If equidistant, towards even neighbour.
      // HALF_CEIL  7 Towards nearest neighbour. If equidistant, towards +Infinity.
      // HALF_FLOOR 8 Towards nearest neighbour. If equidistant, towards -Infinity.
      ROUNDING_MODE = 4,                       // 0 to 8

      // EXPONENTIAL_AT : [TO_EXP_NEG , TO_EXP_POS]

      // The exponent value at and beneath which toString returns exponential notation.
      // Number type: -7
      TO_EXP_NEG = -7,                         // 0 to -MAX

      // The exponent value at and above which toString returns exponential notation.
      // Number type: 21
      TO_EXP_POS = 21,                         // 0 to MAX

      // RANGE : [MIN_EXP, MAX_EXP]

      // The minimum exponent value, beneath which underflow to zero occurs.
      // Number type: -324  (5e-324)
      MIN_EXP = -1e7,                          // -1 to -MAX

      // The maximum exponent value, above which overflow to Infinity occurs.
      // Number type:  308  (1.7976931348623157e+308)
      // For MAX_EXP > 1e7, e.g. new BigNumber('1e100000000').plus(1) may be slow.
      MAX_EXP = 1e7,                           // 1 to MAX

      // Whether to use cryptographically-secure random number generation, if available.
      CRYPTO = false,                          // true or false

      // The modulo mode used when calculating the modulus: a mod n.
      // The quotient (q = a / n) is calculated according to the corresponding rounding mode.
      // The remainder (r) is calculated as: r = a - n * q.
      //
      // UP        0 The remainder is positive if the dividend is negative, else is negative.
      // DOWN      1 The remainder has the same sign as the dividend.
      //             This modulo mode is commonly known as 'truncated division' and is
      //             equivalent to (a % n) in JavaScript.
      // FLOOR     3 The remainder has the same sign as the divisor (Python %).
      // HALF_EVEN 6 This modulo mode implements the IEEE 754 remainder function.
      // EUCLID    9 Euclidian division. q = sign(n) * floor(a / abs(n)).
      //             The remainder is always positive.
      //
      // The truncated division, floored division, Euclidian division and IEEE 754 remainder
      // modes are commonly used for the modulus operation.
      // Although the other rounding modes can also be used, they may not give useful results.
      MODULO_MODE = 1,                         // 0 to 9

      // The maximum number of significant digits of the result of the exponentiatedBy operation.
      // If POW_PRECISION is 0, there will be unlimited significant digits.
      POW_PRECISION = 0,                       // 0 to MAX

      // The format specification used by the BigNumber.prototype.toFormat method.
      FORMAT = {
        prefix: '',
        groupSize: 3,
        secondaryGroupSize: 0,
        groupSeparator: ',',
        decimalSeparator: '.',
        fractionGroupSize: 0,
        fractionGroupSeparator: '\xA0',        // non-breaking space
        suffix: ''
      },

      // The alphabet used for base conversion. It must be at least 2 characters long, with no '+',
      // '-', '.', whitespace, or repeated character.
      // '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$_'
      ALPHABET = '0123456789abcdefghijklmnopqrstuvwxyz',
      alphabetHasNormalDecimalDigits = true;


    //------------------------------------------------------------------------------------------


    // CONSTRUCTOR


    /*
     * The BigNumber constructor and exported function.
     * Create and return a new instance of a BigNumber object.
     *
     * v {number|string|BigNumber} A numeric value.
     * [b] {number} The base of v. Integer, 2 to ALPHABET.length inclusive.
     */
    function BigNumber(v, b) {
      var alphabet, c, caseChanged, e, i, isNum, len, str,
        x = this;

      // Enable constructor call without `new`.
      if (!(x instanceof BigNumber)) return new BigNumber(v, b);

      if (b == null) {

        if (v && v._isBigNumber === true) {
          x.s = v.s;

          if (!v.c || v.e > MAX_EXP) {
            x.c = x.e = null;
          } else if (v.e < MIN_EXP) {
            x.c = [x.e = 0];
          } else {
            x.e = v.e;
            x.c = v.c.slice();
          }

          return;
        }

        if ((isNum = typeof v == 'number') && v * 0 == 0) {

          // Use `1 / n` to handle minus zero also.
          x.s = 1 / v < 0 ? (v = -v, -1) : 1;

          // Fast path for integers, where n < 2147483648 (2**31).
          if (v === ~~v) {
            for (e = 0, i = v; i >= 10; i /= 10, e++);

            if (e > MAX_EXP) {
              x.c = x.e = null;
            } else {
              x.e = e;
              x.c = [v];
            }

            return;
          }

          str = String(v);
        } else {

          if (!isNumeric.test(str = String(v))) return parseNumeric(x, str, isNum);

          x.s = str.charCodeAt(0) == 45 ? (str = str.slice(1), -1) : 1;
        }

        // Decimal point?
        if ((e = str.indexOf('.')) > -1) str = str.replace('.', '');

        // Exponential form?
        if ((i = str.search(/e/i)) > 0) {

          // Determine exponent.
          if (e < 0) e = i;
          e += +str.slice(i + 1);
          str = str.substring(0, i);
        } else if (e < 0) {

          // Integer.
          e = str.length;
        }

      } else {

        // '[BigNumber Error] Base {not a primitive number|not an integer|out of range}: {b}'
        intCheck(b, 2, ALPHABET.length, 'Base');

        // Allow exponential notation to be used with base 10 argument, while
        // also rounding to DECIMAL_PLACES as with other bases.
        if (b == 10 && alphabetHasNormalDecimalDigits) {
          x = new BigNumber(v);
          return round(x, DECIMAL_PLACES + x.e + 1, ROUNDING_MODE);
        }

        str = String(v);

        if (isNum = typeof v == 'number') {

          // Avoid potential interpretation of Infinity and NaN as base 44+ values.
          if (v * 0 != 0) return parseNumeric(x, str, isNum, b);

          x.s = 1 / v < 0 ? (str = str.slice(1), -1) : 1;

          // '[BigNumber Error] Number primitive has more than 15 significant digits: {n}'
          if (BigNumber.DEBUG && str.replace(/^0\.0*|\./, '').length > 15) {
            throw Error
             (tooManyDigits + v);
          }
        } else {
          x.s = str.charCodeAt(0) === 45 ? (str = str.slice(1), -1) : 1;
        }

        alphabet = ALPHABET.slice(0, b);
        e = i = 0;

        // Check that str is a valid base b number.
        // Don't use RegExp, so alphabet can contain special characters.
        for (len = str.length; i < len; i++) {
          if (alphabet.indexOf(c = str.charAt(i)) < 0) {
            if (c == '.') {

              // If '.' is not the first character and it has not be found before.
              if (i > e) {
                e = len;
                continue;
              }
            } else if (!caseChanged) {

              // Allow e.g. hexadecimal 'FF' as well as 'ff'.
              if (str == str.toUpperCase() && (str = str.toLowerCase()) ||
                  str == str.toLowerCase() && (str = str.toUpperCase())) {
                caseChanged = true;
                i = -1;
                e = 0;
                continue;
              }
            }

            return parseNumeric(x, String(v), isNum, b);
          }
        }

        // Prevent later check for length on converted number.
        isNum = false;
        str = convertBase(str, b, 10, x.s);

        // Decimal point?
        if ((e = str.indexOf('.')) > -1) str = str.replace('.', '');
        else e = str.length;
      }

      // Determine leading zeros.
      for (i = 0; str.charCodeAt(i) === 48; i++);

      // Determine trailing zeros.
      for (len = str.length; str.charCodeAt(--len) === 48;);

      if (str = str.slice(i, ++len)) {
        len -= i;

        // '[BigNumber Error] Number primitive has more than 15 significant digits: {n}'
        if (isNum && BigNumber.DEBUG &&
          len > 15 && (v > MAX_SAFE_INTEGER || v !== mathfloor(v))) {
            throw Error
             (tooManyDigits + (x.s * v));
        }

         // Overflow?
        if ((e = e - i - 1) > MAX_EXP) {

          // Infinity.
          x.c = x.e = null;

        // Underflow?
        } else if (e < MIN_EXP) {

          // Zero.
          x.c = [x.e = 0];
        } else {
          x.e = e;
          x.c = [];

          // Transform base

          // e is the base 10 exponent.
          // i is where to slice str to get the first element of the coefficient array.
          i = (e + 1) % LOG_BASE;
          if (e < 0) i += LOG_BASE;  // i < 1

          if (i < len) {
            if (i) x.c.push(+str.slice(0, i));

            for (len -= LOG_BASE; i < len;) {
              x.c.push(+str.slice(i, i += LOG_BASE));
            }

            i = LOG_BASE - (str = str.slice(i)).length;
          } else {
            i -= len;
          }

          for (; i--; str += '0');
          x.c.push(+str);
        }
      } else {

        // Zero.
        x.c = [x.e = 0];
      }
    }


    // CONSTRUCTOR PROPERTIES


    BigNumber.clone = clone;

    BigNumber.ROUND_UP = 0;
    BigNumber.ROUND_DOWN = 1;
    BigNumber.ROUND_CEIL = 2;
    BigNumber.ROUND_FLOOR = 3;
    BigNumber.ROUND_HALF_UP = 4;
    BigNumber.ROUND_HALF_DOWN = 5;
    BigNumber.ROUND_HALF_EVEN = 6;
    BigNumber.ROUND_HALF_CEIL = 7;
    BigNumber.ROUND_HALF_FLOOR = 8;
    BigNumber.EUCLID = 9;


    /*
     * Configure infrequently-changing library-wide settings.
     *
     * Accept an object with the following optional properties (if the value of a property is
     * a number, it must be an integer within the inclusive range stated):
     *
     *   DECIMAL_PLACES   {number}           0 to MAX
     *   ROUNDING_MODE    {number}           0 to 8
     *   EXPONENTIAL_AT   {number|number[]}  -MAX to MAX  or  [-MAX to 0, 0 to MAX]
     *   RANGE            {number|number[]}  -MAX to MAX (not zero)  or  [-MAX to -1, 1 to MAX]
     *   CRYPTO           {boolean}          true or false
     *   MODULO_MODE      {number}           0 to 9
     *   POW_PRECISION       {number}           0 to MAX
     *   ALPHABET         {string}           A string of two or more unique characters which does
     *                                       not contain '.'.
     *   FORMAT           {object}           An object with some of the following properties:
     *     prefix                 {string}
     *     groupSize              {number}
     *     secondaryGroupSize     {number}
     *     groupSeparator         {string}
     *     decimalSeparator       {string}
     *     fractionGroupSize      {number}
     *     fractionGroupSeparator {string}
     *     suffix                 {string}
     *
     * (The values assigned to the above FORMAT object properties are not checked for validity.)
     *
     * E.g.
     * BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 4 })
     *
     * Ignore properties/parameters set to null or undefined, except for ALPHABET.
     *
     * Return an object with the properties current values.
     */
    BigNumber.config = BigNumber.set = function (obj) {
      var p, v;

      if (obj != null) {

        if (typeof obj == 'object') {

          // DECIMAL_PLACES {number} Integer, 0 to MAX inclusive.
          // '[BigNumber Error] DECIMAL_PLACES {not a primitive number|not an integer|out of range}: {v}'
          if (obj.hasOwnProperty(p = 'DECIMAL_PLACES')) {
            v = obj[p];
            intCheck(v, 0, MAX, p);
            DECIMAL_PLACES = v;
          }

          // ROUNDING_MODE {number} Integer, 0 to 8 inclusive.
          // '[BigNumber Error] ROUNDING_MODE {not a primitive number|not an integer|out of range}: {v}'
          if (obj.hasOwnProperty(p = 'ROUNDING_MODE')) {
            v = obj[p];
            intCheck(v, 0, 8, p);
            ROUNDING_MODE = v;
          }

          // EXPONENTIAL_AT {number|number[]}
          // Integer, -MAX to MAX inclusive or
          // [integer -MAX to 0 inclusive, 0 to MAX inclusive].
          // '[BigNumber Error] EXPONENTIAL_AT {not a primitive number|not an integer|out of range}: {v}'
          if (obj.hasOwnProperty(p = 'EXPONENTIAL_AT')) {
            v = obj[p];
            if (v && v.pop) {
              intCheck(v[0], -MAX, 0, p);
              intCheck(v[1], 0, MAX, p);
              TO_EXP_NEG = v[0];
              TO_EXP_POS = v[1];
            } else {
              intCheck(v, -MAX, MAX, p);
              TO_EXP_NEG = -(TO_EXP_POS = v < 0 ? -v : v);
            }
          }

          // RANGE {number|number[]} Non-zero integer, -MAX to MAX inclusive or
          // [integer -MAX to -1 inclusive, integer 1 to MAX inclusive].
          // '[BigNumber Error] RANGE {not a primitive number|not an integer|out of range|cannot be zero}: {v}'
          if (obj.hasOwnProperty(p = 'RANGE')) {
            v = obj[p];
            if (v && v.pop) {
              intCheck(v[0], -MAX, -1, p);
              intCheck(v[1], 1, MAX, p);
              MIN_EXP = v[0];
              MAX_EXP = v[1];
            } else {
              intCheck(v, -MAX, MAX, p);
              if (v) {
                MIN_EXP = -(MAX_EXP = v < 0 ? -v : v);
              } else {
                throw Error
                 (bignumberError + p + ' cannot be zero: ' + v);
              }
            }
          }

          // CRYPTO {boolean} true or false.
          // '[BigNumber Error] CRYPTO not true or false: {v}'
          // '[BigNumber Error] crypto unavailable'
          if (obj.hasOwnProperty(p = 'CRYPTO')) {
            v = obj[p];
            if (v === !!v) {
              if (v) {
                if (typeof crypto != 'undefined' && crypto &&
                 (crypto.getRandomValues || crypto.randomBytes)) {
                  CRYPTO = v;
                } else {
                  CRYPTO = !v;
                  throw Error
                   (bignumberError + 'crypto unavailable');
                }
              } else {
                CRYPTO = v;
              }
            } else {
              throw Error
               (bignumberError + p + ' not true or false: ' + v);
            }
          }

          // MODULO_MODE {number} Integer, 0 to 9 inclusive.
          // '[BigNumber Error] MODULO_MODE {not a primitive number|not an integer|out of range}: {v}'
          if (obj.hasOwnProperty(p = 'MODULO_MODE')) {
            v = obj[p];
            intCheck(v, 0, 9, p);
            MODULO_MODE = v;
          }

          // POW_PRECISION {number} Integer, 0 to MAX inclusive.
          // '[BigNumber Error] POW_PRECISION {not a primitive number|not an integer|out of range}: {v}'
          if (obj.hasOwnProperty(p = 'POW_PRECISION')) {
            v = obj[p];
            intCheck(v, 0, MAX, p);
            POW_PRECISION = v;
          }

          // FORMAT {object}
          // '[BigNumber Error] FORMAT not an object: {v}'
          if (obj.hasOwnProperty(p = 'FORMAT')) {
            v = obj[p];
            if (typeof v == 'object') FORMAT = v;
            else throw Error
             (bignumberError + p + ' not an object: ' + v);
          }

          // ALPHABET {string}
          // '[BigNumber Error] ALPHABET invalid: {v}'
          if (obj.hasOwnProperty(p = 'ALPHABET')) {
            v = obj[p];

            // Disallow if less than two characters,
            // or if it contains '+', '-', '.', whitespace, or a repeated character.
            if (typeof v == 'string' && !/^.?$|[+\-.\s]|(.).*\1/.test(v)) {
              alphabetHasNormalDecimalDigits = v.slice(0, 10) == '0123456789';
              ALPHABET = v;
            } else {
              throw Error
               (bignumberError + p + ' invalid: ' + v);
            }
          }

        } else {

          // '[BigNumber Error] Object expected: {v}'
          throw Error
           (bignumberError + 'Object expected: ' + obj);
        }
      }

      return {
        DECIMAL_PLACES: DECIMAL_PLACES,
        ROUNDING_MODE: ROUNDING_MODE,
        EXPONENTIAL_AT: [TO_EXP_NEG, TO_EXP_POS],
        RANGE: [MIN_EXP, MAX_EXP],
        CRYPTO: CRYPTO,
        MODULO_MODE: MODULO_MODE,
        POW_PRECISION: POW_PRECISION,
        FORMAT: FORMAT,
        ALPHABET: ALPHABET
      };
    };


    /*
     * Return true if v is a BigNumber instance, otherwise return false.
     *
     * If BigNumber.DEBUG is true, throw if a BigNumber instance is not well-formed.
     *
     * v {any}
     *
     * '[BigNumber Error] Invalid BigNumber: {v}'
     */
    BigNumber.isBigNumber = function (v) {
      if (!v || v._isBigNumber !== true) return false;
      if (!BigNumber.DEBUG) return true;

      var i, n,
        c = v.c,
        e = v.e,
        s = v.s;

      out: if ({}.toString.call(c) == '[object Array]') {

        if ((s === 1 || s === -1) && e >= -MAX && e <= MAX && e === mathfloor(e)) {

          // If the first element is zero, the BigNumber value must be zero.
          if (c[0] === 0) {
            if (e === 0 && c.length === 1) return true;
            break out;
          }

          // Calculate number of digits that c[0] should have, based on the exponent.
          i = (e + 1) % LOG_BASE;
          if (i < 1) i += LOG_BASE;

          // Calculate number of digits of c[0].
          //if (Math.ceil(Math.log(c[0] + 1) / Math.LN10) == i) {
          if (String(c[0]).length == i) {

            for (i = 0; i < c.length; i++) {
              n = c[i];
              if (n < 0 || n >= BASE || n !== mathfloor(n)) break out;
            }

            // Last element cannot be zero, unless it is the only element.
            if (n !== 0) return true;
          }
        }

      // Infinity/NaN
      } else if (c === null && e === null && (s === null || s === 1 || s === -1)) {
        return true;
      }

      throw Error
        (bignumberError + 'Invalid BigNumber: ' + v);
    };


    /*
     * Return a new BigNumber whose value is the maximum of the arguments.
     *
     * arguments {number|string|BigNumber}
     */
    BigNumber.maximum = BigNumber.max = function () {
      return maxOrMin(arguments, -1);
    };


    /*
     * Return a new BigNumber whose value is the minimum of the arguments.
     *
     * arguments {number|string|BigNumber}
     */
    BigNumber.minimum = BigNumber.min = function () {
      return maxOrMin(arguments, 1);
    };


    /*
     * Return a new BigNumber with a random value equal to or greater than 0 and less than 1,
     * and with dp, or DECIMAL_PLACES if dp is omitted, decimal places (or less if trailing
     * zeros are produced).
     *
     * [dp] {number} Decimal places. Integer, 0 to MAX inclusive.
     *
     * '[BigNumber Error] Argument {not a primitive number|not an integer|out of range}: {dp}'
     * '[BigNumber Error] crypto unavailable'
     */
    BigNumber.random = (function () {
      var pow2_53 = 0x20000000000000;

      // Return a 53 bit integer n, where 0 <= n < 9007199254740992.
      // Check if Math.random() produces more than 32 bits of randomness.
      // If it does, assume at least 53 bits are produced, otherwise assume at least 30 bits.
      // 0x40000000 is 2^30, 0x800000 is 2^23, 0x1fffff is 2^21 - 1.
      var random53bitInt = (Math.random() * pow2_53) & 0x1fffff
       ? function () { return mathfloor(Math.random() * pow2_53); }
       : function () { return ((Math.random() * 0x40000000 | 0) * 0x800000) +
         (Math.random() * 0x800000 | 0); };

      return function (dp) {
        var a, b, e, k, v,
          i = 0,
          c = [],
          rand = new BigNumber(ONE);

        if (dp == null) dp = DECIMAL_PLACES;
        else intCheck(dp, 0, MAX);

        k = mathceil(dp / LOG_BASE);

        if (CRYPTO) {

          // Browsers supporting crypto.getRandomValues.
          if (crypto.getRandomValues) {

            a = crypto.getRandomValues(new Uint32Array(k *= 2));

            for (; i < k;) {

              // 53 bits:
              // ((Math.pow(2, 32) - 1) * Math.pow(2, 21)).toString(2)
              // 11111 11111111 11111111 11111111 11100000 00000000 00000000
              // ((Math.pow(2, 32) - 1) >>> 11).toString(2)
              //                                     11111 11111111 11111111
              // 0x20000 is 2^21.
              v = a[i] * 0x20000 + (a[i + 1] >>> 11);

              // Rejection sampling:
              // 0 <= v < 9007199254740992
              // Probability that v >= 9e15, is
              // 7199254740992 / 9007199254740992 ~= 0.0008, i.e. 1 in 1251
              if (v >= 9e15) {
                b = crypto.getRandomValues(new Uint32Array(2));
                a[i] = b[0];
                a[i + 1] = b[1];
              } else {

                // 0 <= v <= 8999999999999999
                // 0 <= (v % 1e14) <= 99999999999999
                c.push(v % 1e14);
                i += 2;
              }
            }
            i = k / 2;

          // Node.js supporting crypto.randomBytes.
          } else if (crypto.randomBytes) {

            // buffer
            a = crypto.randomBytes(k *= 7);

            for (; i < k;) {

              // 0x1000000000000 is 2^48, 0x10000000000 is 2^40
              // 0x100000000 is 2^32, 0x1000000 is 2^24
              // 11111 11111111 11111111 11111111 11111111 11111111 11111111
              // 0 <= v < 9007199254740992
              v = ((a[i] & 31) * 0x1000000000000) + (a[i + 1] * 0x10000000000) +
                 (a[i + 2] * 0x100000000) + (a[i + 3] * 0x1000000) +
                 (a[i + 4] << 16) + (a[i + 5] << 8) + a[i + 6];

              if (v >= 9e15) {
                crypto.randomBytes(7).copy(a, i);
              } else {

                // 0 <= (v % 1e14) <= 99999999999999
                c.push(v % 1e14);
                i += 7;
              }
            }
            i = k / 7;
          } else {
            CRYPTO = false;
            throw Error
             (bignumberError + 'crypto unavailable');
          }
        }

        // Use Math.random.
        if (!CRYPTO) {

          for (; i < k;) {
            v = random53bitInt();
            if (v < 9e15) c[i++] = v % 1e14;
          }
        }

        k = c[--i];
        dp %= LOG_BASE;

        // Convert trailing digits to zeros according to dp.
        if (k && dp) {
          v = POWS_TEN[LOG_BASE - dp];
          c[i] = mathfloor(k / v) * v;
        }

        // Remove trailing elements which are zero.
        for (; c[i] === 0; c.pop(), i--);

        // Zero?
        if (i < 0) {
          c = [e = 0];
        } else {

          // Remove leading elements which are zero and adjust exponent accordingly.
          for (e = -1 ; c[0] === 0; c.splice(0, 1), e -= LOG_BASE);

          // Count the digits of the first element of c to determine leading zeros, and...
          for (i = 1, v = c[0]; v >= 10; v /= 10, i++);

          // adjust the exponent accordingly.
          if (i < LOG_BASE) e -= LOG_BASE - i;
        }

        rand.e = e;
        rand.c = c;
        return rand;
      };
    })();


    /*
     * Return a BigNumber whose value is the sum of the arguments.
     *
     * arguments {number|string|BigNumber}
     */
    BigNumber.sum = function () {
      var i = 1,
        args = arguments,
        sum = new BigNumber(args[0]);
      for (; i < args.length;) sum = sum.plus(args[i++]);
      return sum;
    };


    // PRIVATE FUNCTIONS


    // Called by BigNumber and BigNumber.prototype.toString.
    convertBase = (function () {
      var decimal = '0123456789';

      /*
       * Convert string of baseIn to an array of numbers of baseOut.
       * Eg. toBaseOut('255', 10, 16) returns [15, 15].
       * Eg. toBaseOut('ff', 16, 10) returns [2, 5, 5].
       */
      function toBaseOut(str, baseIn, baseOut, alphabet) {
        var j,
          arr = [0],
          arrL,
          i = 0,
          len = str.length;

        for (; i < len;) {
          for (arrL = arr.length; arrL--; arr[arrL] *= baseIn);

          arr[0] += alphabet.indexOf(str.charAt(i++));

          for (j = 0; j < arr.length; j++) {

            if (arr[j] > baseOut - 1) {
              if (arr[j + 1] == null) arr[j + 1] = 0;
              arr[j + 1] += arr[j] / baseOut | 0;
              arr[j] %= baseOut;
            }
          }
        }

        return arr.reverse();
      }

      // Convert a numeric string of baseIn to a numeric string of baseOut.
      // If the caller is toString, we are converting from base 10 to baseOut.
      // If the caller is BigNumber, we are converting from baseIn to base 10.
      return function (str, baseIn, baseOut, sign, callerIsToString) {
        var alphabet, d, e, k, r, x, xc, y,
          i = str.indexOf('.'),
          dp = DECIMAL_PLACES,
          rm = ROUNDING_MODE;

        // Non-integer.
        if (i >= 0) {
          k = POW_PRECISION;

          // Unlimited precision.
          POW_PRECISION = 0;
          str = str.replace('.', '');
          y = new BigNumber(baseIn);
          x = y.pow(str.length - i);
          POW_PRECISION = k;

          // Convert str as if an integer, then restore the fraction part by dividing the
          // result by its base raised to a power.

          y.c = toBaseOut(toFixedPoint(coeffToString(x.c), x.e, '0'),
           10, baseOut, decimal);
          y.e = y.c.length;
        }

        // Convert the number as integer.

        xc = toBaseOut(str, baseIn, baseOut, callerIsToString
         ? (alphabet = ALPHABET, decimal)
         : (alphabet = decimal, ALPHABET));

        // xc now represents str as an integer and converted to baseOut. e is the exponent.
        e = k = xc.length;

        // Remove trailing zeros.
        for (; xc[--k] == 0; xc.pop());

        // Zero?
        if (!xc[0]) return alphabet.charAt(0);

        // Does str represent an integer? If so, no need for the division.
        if (i < 0) {
          --e;
        } else {
          x.c = xc;
          x.e = e;

          // The sign is needed for correct rounding.
          x.s = sign;
          x = div(x, y, dp, rm, baseOut);
          xc = x.c;
          r = x.r;
          e = x.e;
        }

        // xc now represents str converted to baseOut.

        // The index of the rounding digit.
        d = e + dp + 1;

        // The rounding digit: the digit to the right of the digit that may be rounded up.
        i = xc[d];

        // Look at the rounding digits and mode to determine whether to round up.

        k = baseOut / 2;
        r = r || d < 0 || xc[d + 1] != null;

        r = rm < 4 ? (i != null || r) && (rm == 0 || rm == (x.s < 0 ? 3 : 2))
              : i > k || i == k &&(rm == 4 || r || rm == 6 && xc[d - 1] & 1 ||
               rm == (x.s < 0 ? 8 : 7));

        // If the index of the rounding digit is not greater than zero, or xc represents
        // zero, then the result of the base conversion is zero or, if rounding up, a value
        // such as 0.00001.
        if (d < 1 || !xc[0]) {

          // 1^-dp or 0
          str = r ? toFixedPoint(alphabet.charAt(1), -dp, alphabet.charAt(0)) : alphabet.charAt(0);
        } else {

          // Truncate xc to the required number of decimal places.
          xc.length = d;

          // Round up?
          if (r) {

            // Rounding up may mean the previous digit has to be rounded up and so on.
            for (--baseOut; ++xc[--d] > baseOut;) {
              xc[d] = 0;

              if (!d) {
                ++e;
                xc = [1].concat(xc);
              }
            }
          }

          // Determine trailing zeros.
          for (k = xc.length; !xc[--k];);

          // E.g. [4, 11, 15] becomes 4bf.
          for (i = 0, str = ''; i <= k; str += alphabet.charAt(xc[i++]));

          // Add leading zeros, decimal point and trailing zeros as required.
          str = toFixedPoint(str, e, alphabet.charAt(0));
        }

        // The caller will add the sign.
        return str;
      };
    })();


    // Perform division in the specified base. Called by div and convertBase.
    div = (function () {

      // Assume non-zero x and k.
      function multiply(x, k, base) {
        var m, temp, xlo, xhi,
          carry = 0,
          i = x.length,
          klo = k % SQRT_BASE,
          khi = k / SQRT_BASE | 0;

        for (x = x.slice(); i--;) {
          xlo = x[i] % SQRT_BASE;
          xhi = x[i] / SQRT_BASE | 0;
          m = khi * xlo + xhi * klo;
          temp = klo * xlo + ((m % SQRT_BASE) * SQRT_BASE) + carry;
          carry = (temp / base | 0) + (m / SQRT_BASE | 0) + khi * xhi;
          x[i] = temp % base;
        }

        if (carry) x = [carry].concat(x);

        return x;
      }

      function compare(a, b, aL, bL) {
        var i, cmp;

        if (aL != bL) {
          cmp = aL > bL ? 1 : -1;
        } else {

          for (i = cmp = 0; i < aL; i++) {

            if (a[i] != b[i]) {
              cmp = a[i] > b[i] ? 1 : -1;
              break;
            }
          }
        }

        return cmp;
      }

      function subtract(a, b, aL, base) {
        var i = 0;

        // Subtract b from a.
        for (; aL--;) {
          a[aL] -= i;
          i = a[aL] < b[aL] ? 1 : 0;
          a[aL] = i * base + a[aL] - b[aL];
        }

        // Remove leading zeros.
        for (; !a[0] && a.length > 1; a.splice(0, 1));
      }

      // x: dividend, y: divisor.
      return function (x, y, dp, rm, base) {
        var cmp, e, i, more, n, prod, prodL, q, qc, rem, remL, rem0, xi, xL, yc0,
          yL, yz,
          s = x.s == y.s ? 1 : -1,
          xc = x.c,
          yc = y.c;

        // Either NaN, Infinity or 0?
        if (!xc || !xc[0] || !yc || !yc[0]) {

          return new BigNumber(

           // Return NaN if either NaN, or both Infinity or 0.
           !x.s || !y.s || (xc ? yc && xc[0] == yc[0] : !yc) ? NaN :

            // Return ±0 if x is ±0 or y is ±Infinity, or return ±Infinity as y is ±0.
            xc && xc[0] == 0 || !yc ? s * 0 : s / 0
         );
        }

        q = new BigNumber(s);
        qc = q.c = [];
        e = x.e - y.e;
        s = dp + e + 1;

        if (!base) {
          base = BASE;
          e = bitFloor(x.e / LOG_BASE) - bitFloor(y.e / LOG_BASE);
          s = s / LOG_BASE | 0;
        }

        // Result exponent may be one less then the current value of e.
        // The coefficients of the BigNumbers from convertBase may have trailing zeros.
        for (i = 0; yc[i] == (xc[i] || 0); i++);

        if (yc[i] > (xc[i] || 0)) e--;

        if (s < 0) {
          qc.push(1);
          more = true;
        } else {
          xL = xc.length;
          yL = yc.length;
          i = 0;
          s += 2;

          // Normalise xc and yc so highest order digit of yc is >= base / 2.

          n = mathfloor(base / (yc[0] + 1));

          // Not necessary, but to handle odd bases where yc[0] == (base / 2) - 1.
          // if (n > 1 || n++ == 1 && yc[0] < base / 2) {
          if (n > 1) {
            yc = multiply(yc, n, base);
            xc = multiply(xc, n, base);
            yL = yc.length;
            xL = xc.length;
          }

          xi = yL;
          rem = xc.slice(0, yL);
          remL = rem.length;

          // Add zeros to make remainder as long as divisor.
          for (; remL < yL; rem[remL++] = 0);
          yz = yc.slice();
          yz = [0].concat(yz);
          yc0 = yc[0];
          if (yc[1] >= base / 2) yc0++;
          // Not necessary, but to prevent trial digit n > base, when using base 3.
          // else if (base == 3 && yc0 == 1) yc0 = 1 + 1e-15;

          do {
            n = 0;

            // Compare divisor and remainder.
            cmp = compare(yc, rem, yL, remL);

            // If divisor < remainder.
            if (cmp < 0) {

              // Calculate trial digit, n.

              rem0 = rem[0];
              if (yL != remL) rem0 = rem0 * base + (rem[1] || 0);

              // n is how many times the divisor goes into the current remainder.
              n = mathfloor(rem0 / yc0);

              //  Algorithm:
              //  product = divisor multiplied by trial digit (n).
              //  Compare product and remainder.
              //  If product is greater than remainder:
              //    Subtract divisor from product, decrement trial digit.
              //  Subtract product from remainder.
              //  If product was less than remainder at the last compare:
              //    Compare new remainder and divisor.
              //    If remainder is greater than divisor:
              //      Subtract divisor from remainder, increment trial digit.

              if (n > 1) {

                // n may be > base only when base is 3.
                if (n >= base) n = base - 1;

                // product = divisor * trial digit.
                prod = multiply(yc, n, base);
                prodL = prod.length;
                remL = rem.length;

                // Compare product and remainder.
                // If product > remainder then trial digit n too high.
                // n is 1 too high about 5% of the time, and is not known to have
                // ever been more than 1 too high.
                while (compare(prod, rem, prodL, remL) == 1) {
                  n--;

                  // Subtract divisor from product.
                  subtract(prod, yL < prodL ? yz : yc, prodL, base);
                  prodL = prod.length;
                  cmp = 1;
                }
              } else {

                // n is 0 or 1, cmp is -1.
                // If n is 0, there is no need to compare yc and rem again below,
                // so change cmp to 1 to avoid it.
                // If n is 1, leave cmp as -1, so yc and rem are compared again.
        