LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\chains\\ropsten.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Cchains%5Cropsten.json
      return function (require, module, exports) {
module.exports={
    "name": "ropsten",
    "chainId": 3,
    "networkId": 3,
    "defaultHardfork": "merge",
    "consensus": {
        "type": "pow",
        "algorithm": "ethash",
        "ethash": {}
    },
    "comment": "PoW test network",
    "url": "https://github.com/ethereum/ropsten",
    "genesis": {
        "gasLimit": 16777216,
        "difficulty": 1048576,
        "nonce": "0x0000000000000042",
        "extraData": "0x3535353535353535353535353535353535353535353535353535353535353535"
    },
    "hardforks": [
        {
            "name": "chainstart",
            "block": 0,
            "forkHash": "0x30c7ddbc"
        },
        {
            "name": "homestead",
            "block": 0,
            "forkHash": "0x30c7ddbc"
        },
        {
            "name": "tangerineWhistle",
            "block": 0,
            "forkHash": "0x30c7ddbc"
        },
        {
            "name": "spuriousDragon",
            "block": 10,
            "forkHash": "0x63760190"
        },
        {
            "name": "byzantium",
            "block": 1700000,
            "forkHash": "0x3ea159c7"
        },
        {
            "name": "constantinople",
            "block": 4230000,
            "forkHash": "0x97b544f3"
        },
        {
            "name": "petersburg",
            "block": 4939394,
            "forkHash": "0xd6e2149b"
        },
        {
            "name": "istanbul",
            "block": 6485846,
            "forkHash": "0x4bc66396"
        },
        {
            "name": "muirGlacier",
            "block": 7117117,
            "forkHash": "0x6727ef90"
        },
        {
            "name": "berlin",
            "block": 9812189,
            "forkHash": "0xa157d377"
        },
        {
            "name": "london",
            "block": 10499401,
            "forkHash": "0x7119b6b3"
        },
        {
            "//_comment": "The forkHash will remain same as mergeForkIdTransition is post merge",
            "name": "merge",
            "ttd": "50000000000000000",
            "block": null,
            "forkHash": "0x7119b6b3"
        },
        {
            "name": "mergeForkIdTransition",
            "block": null,
            "forkHash": null
        },
        {
            "name": "shanghai",
            "block": null,
            "forkHash": null
        }
    ],
    "bootstrapNodes": [
        {
            "ip": "52.176.7.10",
            "port": 30303,
            "id": "30b7ab30a01c124a6cceca36863ece12c4f5fa68e3ba9b0b51407ccc002eeed3b3102d20a88f1c1d3c3154e2449317b8ef95090e77b312d5cc39354f86d5d606",
            "location": "",
            "comment": "US-Azure geth"
        },
        {
            "ip": "52.176.100.77",
            "port": 30303,
            "id": "865a63255b3bb68023b6bffd5095118fcc13e79dcf014fe4e47e065c350c7cc72af2e53eff895f11ba1bbb6a2b33271c1116ee870f266618eadfc2e78aa7349c",
            "location": "",
            "comment": "US-Azure parity"
        },
        {
            "ip": "52.232.243.152",
            "port": 30303,
            "id": "6332792c4a00e3e4ee0926ed89e0d27ef985424d97b6a45bf0f23e51f0dcb5e66b875777506458aea7af6f9e4ffb69f43f3778ee73c81ed9d34c51c4b16b0b0f",
            "location": "",
            "comment": "Parity"
        },
        {
            "ip": "192.81.208.223",
            "port": 30303,
            "id": "94c15d1b9e2fe7ce56e458b9a3b672ef11894ddedd0c6f247e0f1d3487f52b66208fb4aeb8179fce6e3a749ea93ed147c37976d67af557508d199d9594c35f09",
            "location": "",
            "comment": "@gpip"
        }
    ],
    "dnsNetworks": [
        "enrtree://AKA3AM6LPBYEUDMVNU3BSVQJ5AD45Y7YPOHJLEF6W26QOE4VTUDPE@all.ropsten.ethdisco.net"
    ]
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\chains\\ropsten.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\chains\\sepolia.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Cchains%5Csepolia.json
      return function (require, module, exports) {
module.exports={
    "name": "sepolia",
    "chainId": 11155111,
    "networkId": 11155111,
    "defaultHardfork": "merge",
    "consensus": {
        "type": "pow",
        "algorithm": "ethash",
        "ethash": {}
    },
    "comment": "PoW test network to replace Ropsten",
    "url": "https://github.com/ethereum/go-ethereum/pull/23730",
    "genesis": {
        "timestamp": "0x6159af19",
        "gasLimit": 30000000,
        "difficulty": 131072,
        "nonce": "0x0000000000000000",
        "extraData": "0x5365706f6c69612c20417468656e732c204174746963612c2047726565636521"
    },
    "hardforks": [
        {
            "name": "chainstart",
            "block": 0,
            "forkHash": "0xfe3366e7"
        },
        {
            "name": "homestead",
            "block": 0,
            "forkHash": "0xfe3366e7"
        },
        {
            "name": "tangerineWhistle",
            "block": 0,
            "forkHash": "0xfe3366e7"
        },
        {
            "name": "spuriousDragon",
            "block": 0,
            "forkHash": "0xfe3366e7"
        },
        {
            "name": "byzantium",
            "block": 0,
            "forkHash": "0xfe3366e7"
        },
        {
            "name": "constantinople",
            "block": 0,
            "forkHash": "0xfe3366e7"
        },
        {
            "name": "petersburg",
            "block": 0,
            "forkHash": "0xfe3366e7"
        },
        {
            "name": "istanbul",
            "block": 0,
            "forkHash": "0xfe3366e7"
        },
        {
            "name": "muirGlacier",
            "block": 0,
            "forkHash": "0xfe3366e7"
        },
        {
            "name": "berlin",
            "block": 0,
            "forkHash": "0xfe3366e7"
        },
        {
            "name": "london",
            "block": 0,
            "forkHash": "0xfe3366e7"
        },
        {
            "//_comment": "The forkHash will remain same as mergeForkIdTransition is post merge, terminal block: https://sepolia.etherscan.io/block/1450408",
            "name": "merge",
            "ttd": "17000000000000000",
            "block": 1450409,
            "forkHash": "0xfe3366e7"
        },
        {
            "name": "mergeForkIdTransition",
            "block": 1735371,
            "forkHash": "0xb96cbd13"
        },
        {
            "name": "shanghai",
            "block": null,
            "timestamp": "1677557088",
            "forkHash": "0xf7f9bc08"
        }
    ],
    "bootstrapNodes": [
        {
            "ip": "18.168.182.86",
            "port": 30303,
            "id": "9246d00bc8fd1742e5ad2428b80fc4dc45d786283e05ef6edbd9002cbc335d40998444732fbe921cb88e1d2c73d1b1de53bae6a2237996e9bfe14f871baf7066",
            "location": "",
            "comment": "geth"
        },
        {
            "ip": "52.14.151.177",
            "port": 30303,
            "id": "ec66ddcf1a974950bd4c782789a7e04f8aa7110a72569b6e65fcd51e937e74eed303b1ea734e4d19cfaec9fbff9b6ee65bf31dcb50ba79acce9dd63a6aca61c7",
            "location": "",
            "comment": "besu"
        },
        {
            "ip": "165.22.196.173",
            "port": 30303,
            "id": "ce970ad2e9daa9e14593de84a8b49da3d54ccfdf83cbc4fe519cb8b36b5918ed4eab087dedd4a62479b8d50756b492d5f762367c8d20329a7854ec01547568a6",
            "location": "",
            "comment": "EF"
        },
        {
            "ip": "65.108.95.67",
            "port": 30303,
            "id": "075503b13ed736244896efcde2a992ec0b451357d46cb7a8132c0384721742597fc8f0d91bbb40bb52e7d6e66728d36a1fda09176294e4a30cfac55dcce26bc6",
            "location": "",
            "comment": "lodestar"
        }
    ],
    "dnsNetworks": [
        "enrtree://AKA3AM6LPBYEUDMVNU3BSVQJ5AD45Y7YPOHJLEF6W26QOE4VTUDPE@all.sepolia.ethdisco.net"
    ]
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\chains\\sepolia.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\common.js", {"./chains/goerli.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\chains\\goerli.json","./chains/mainnet.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\chains\\mainnet.json","./chains/rinkeby.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\chains\\rinkeby.json","./chains/ropsten.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\chains\\ropsten.json","./chains/sepolia.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\chains\\sepolia.json","./eips":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\index.js","./enums":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\enums.js","./hardforks":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\index.js","./utils":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\utils.js","@ethereumjs/util":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\index.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js","crc-32":"D:\\code\\v\\metamask-extension\\node_modules\\crc-32\\crc32.js","events":"D:\\code\\v\\metamask-extension\\node_modules\\events\\events.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ccommon.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Common = void 0;
const util_1 = require("@ethereumjs/util");
const crc_32_1 = require("crc-32");
const events_1 = require("events");
const goerli = require("./chains/goerli.json");
const mainnet = require("./chains/mainnet.json");
const rinkeby = require("./chains/rinkeby.json");
const ropsten = require("./chains/ropsten.json");
const sepolia = require("./chains/sepolia.json");
const eips_1 = require("./eips");
const enums_1 = require("./enums");
const hardforks_1 = require("./hardforks");
const utils_1 = require("./utils");
/**
 * Common class to access chain and hardfork parameters and to provide
 * a unified and shared view on the network and hardfork state.
 *
 * Use the {@link Common.custom} static constructor for creating simple
 * custom chain {@link Common} objects (more complete custom chain setups
 * can be created via the main constructor and the {@link CommonOpts.customChains} parameter).
 */
class Common extends events_1.EventEmitter {
    constructor(opts) {
        super();
        this._eips = [];
        this._customChains = opts.customChains ?? [];
        this._chainParams = this.setChain(opts.chain);
        this.DEFAULT_HARDFORK = this._chainParams.defaultHardfork ?? enums_1.Hardfork.Merge;
        // Assign hardfork changes in the sequence of the applied hardforks
        this.HARDFORK_CHANGES = this.hardforks().map((hf) => [
            hf.name,
            hardforks_1.hardforks[hf.name],
        ]);
        this._hardfork = this.DEFAULT_HARDFORK;
        if (opts.hardfork !== undefined) {
            this.setHardfork(opts.hardfork);
        }
        if (opts.eips) {
            this.setEIPs(opts.eips);
        }
    }
    /**
     * Creates a {@link Common} object for a custom chain, based on a standard one.
     *
     * It uses all the {@link Chain} parameters from the {@link baseChain} option except the ones overridden
     * in a provided {@link chainParamsOrName} dictionary. Some usage example:
     *
     * ```javascript
     * Common.custom({chainId: 123})
     * ```
     *
     * There are also selected supported custom chains which can be initialized by using one of the
     * {@link CustomChains} for {@link chainParamsOrName}, e.g.:
     *
     * ```javascript
     * Common.custom(CustomChains.MaticMumbai)
     * ```
     *
     * Note that these supported custom chains only provide some base parameters (usually the chain and
     * network ID and a name) and can only be used for selected use cases (e.g. sending a tx with
     * the `@ethereumjs/tx` library to a Layer-2 chain).
     *
     * @param chainParamsOrName Custom parameter dict (`name` will default to `custom-chain`) or string with name of a supported custom chain
     * @param opts Custom chain options to set the {@link CustomCommonOpts.baseChain}, selected {@link CustomCommonOpts.hardfork} and others
     */
    static custom(chainParamsOrName, opts = {}) {
        const baseChain = opts.baseChain ?? 'mainnet';
        const standardChainParams = { ...Common._getChainParams(baseChain) };
        standardChainParams['name'] = 'custom-chain';
        if (typeof chainParamsOrName !== 'string') {
            return new Common({
                chain: {
                    ...standardChainParams,
                    ...chainParamsOrName,
                },
                ...opts,
            });
        }
        else {
            if (chainParamsOrName === enums_1.CustomChain.PolygonMainnet) {
                return Common.custom({
                    name: enums_1.CustomChain.PolygonMainnet,
                    chainId: 137,
                    networkId: 137,
                }, opts);
            }
            if (chainParamsOrName === enums_1.CustomChain.PolygonMumbai) {
                return Common.custom({
                    name: enums_1.CustomChain.PolygonMumbai,
                    chainId: 80001,
                    networkId: 80001,
                }, opts);
            }
            if (chainParamsOrName === enums_1.CustomChain.ArbitrumRinkebyTestnet) {
                return Common.custom({
                    name: enums_1.CustomChain.ArbitrumRinkebyTestnet,
                    chainId: 421611,
                    networkId: 421611,
                }, opts);
            }
            if (chainParamsOrName === enums_1.CustomChain.ArbitrumOne) {
                return Common.custom({
                    name: enums_1.CustomChain.ArbitrumOne,
                    chainId: 42161,
                    networkId: 42161,
                }, opts);
            }
            if (chainParamsOrName === enums_1.CustomChain.xDaiChain) {
                return Common.custom({
                    name: enums_1.CustomChain.xDaiChain,
                    chainId: 100,
                    networkId: 100,
                }, opts);
            }
            if (chainParamsOrName === enums_1.CustomChain.OptimisticKovan) {
                return Common.custom({
                    name: enums_1.CustomChain.OptimisticKovan,
                    chainId: 69,
                    networkId: 69,
                }, 
                // Optimism has not implemented the London hardfork yet (targeting Q1.22)
                { hardfork: enums_1.Hardfork.Berlin, ...opts });
            }
            if (chainParamsOrName === enums_1.CustomChain.OptimisticEthereum) {
                return Common.custom({
                    name: enums_1.CustomChain.OptimisticEthereum,
                    chainId: 10,
                    networkId: 10,
                }, 
                // Optimism has not implemented the London hardfork yet (targeting Q1.22)
                { hardfork: enums_1.Hardfork.Berlin, ...opts });
            }
            throw new Error(`Custom chain ${chainParamsOrName} not supported`);
        }
    }
    /**
     * Static method to load and set common from a geth genesis json
     * @param genesisJson json of geth configuration
     * @param { chain, eips, genesisHash, hardfork, mergeForkIdPostMerge } to further configure the common instance
     * @returns Common
     */
    static fromGethGenesis(genesisJson, { chain, eips, genesisHash, hardfork, mergeForkIdPostMerge }) {
        const genesisParams = (0, utils_1.parseGethGenesis)(genesisJson, chain, mergeForkIdPostMerge);
        const common = new Common({
            chain: genesisParams.name ?? 'custom',
            customChains: [genesisParams],
            eips,
            hardfork: hardfork ?? genesisParams.hardfork,
        });
        if (genesisHash !== undefined) {
            common.setForkHashes(genesisHash);
        }
        return common;
    }
    /**
     * Static method to determine if a {@link chainId} is supported as a standard chain
     * @param chainId bigint id (`1`) of a standard chain
     * @returns boolean
     */
    static isSupportedChainId(chainId) {
        const initializedChains = this._getInitializedChains();
        return Boolean(initializedChains['names'][chainId.toString()]);
    }
    static _getChainParams(chain, customChains) {
        const initializedChains = this._getInitializedChains(customChains);
        if (typeof chain === 'number' || typeof chain === 'bigint') {
            chain = chain.toString();
            if (initializedChains['names'][chain]) {
                const name = initializedChains['names'][chain];
                return initializedChains[name];
            }
            throw new Error(`Chain with ID ${chain} not supported`);
        }
        if (initializedChains[chain] !== undefined) {
            return initializedChains[chain];
        }
        throw new Error(`Chain with name ${chain} not supported`);
    }
    /**
     * Sets the chain
     * @param chain String ('mainnet') or Number (1) chain representation.
     *              Or, a Dictionary of chain parameters for a private network.
     * @returns The dictionary with parameters set as chain
     */
    setChain(chain) {
        if (typeof chain === 'number' || typeof chain === 'bigint' || typeof chain === 'string') {
            this._chainParams = Common._getChainParams(chain, this._customChains);
        }
        else if (typeof chain === 'object') {
            if (this._customChains.length > 0) {
                throw new Error('Chain must be a string, number, or bigint when initialized with customChains passed in');
            }
            const required = ['networkId', 'genesis', 'hardforks', 'bootstrapNodes'];
            for (const param of required) {
                if (!(param in chain)) {
                    throw new Error(`Missing required chain parameter: ${param}`);
                }
            }
            this._chainParams = chain;
        }
        else {
            throw new Error('Wrong input format');
        }
        for (const hf of this.hardforks()) {
            if (hf.block === undefined) {
                throw new Error(`Hardfork cannot have undefined block number`);
            }
        }
        return this._chainParams;
    }
    /**
     * Sets the hardfork to get params for
     * @param hardfork String identifier (e.g. 'byzantium') or {@link Hardfork} enum
     */
    setHardfork(hardfork) {
        let existing = false;
        for (const hfChanges of this.HARDFORK_CHANGES) {
            if (hfChanges[0] === hardfork) {
                if (this._hardfork !== hardfork) {
                    this._hardfork = hardfork;
                    this.emit('hardforkChanged', hardfork);
                }
                existing = true;
            }
        }
        if (!existing) {
            throw new Error(`Hardfork with name ${hardfork} not supported`);
        }
    }
    /**
     * Returns the hardfork based on the block number or an optional
     * total difficulty (Merge HF) provided.
     *
     * An optional TD takes precedence in case the corresponding HF block
     * is set to `null` or otherwise needs to match (if not an error
     * will be thrown).
     *
     * @param blockNumber
     * @param td : total difficulty of the parent block (for block hf) OR of the chain latest (for chain hf)
     * @param timestamp: timestamp in seconds at which block was/is to be minted
     * @returns The name of the HF
     */
    getHardforkByBlockNumber(blockNumber, td, timestamp) {
        blockNumber = (0, util_1.toType)(blockNumber, util_1.TypeOutput.BigInt);
        td = (0, util_1.toType)(td, util_1.TypeOutput.BigInt);
        timestamp = (0, util_1.toType)(timestamp, util_1.TypeOutput.Number);
        // Filter out hardforks with no block number, no ttd or no timestamp (i.e. unapplied hardforks)
        const hfs = this.hardforks().filter((hf) => hf.block !== null || (hf.ttd !== null && hf.ttd !== undefined) || hf.timestamp !== undefined);
        const mergeIndex = hfs.findIndex((hf) => hf.ttd !== null && hf.ttd !== undefined);
        const doubleTTDHF = hfs
            .slice(mergeIndex + 1)
            .findIndex((hf) => hf.ttd !== null && hf.ttd !== undefined);
        if (doubleTTDHF >= 0) {
            throw Error(`More than one merge hardforks found with ttd specified`);
        }
        // Find the first hardfork that has a block number greater than `blockNumber`
        // (skips the merge hardfork since it cannot have a block number specified).
        // If timestamp is not provided, it also skips timestamps hardforks to continue
        // discovering/checking number hardforks.
        let hfIndex = hfs.findIndex((hf) => (hf.block !== null && hf.block > blockNumber) ||
            (timestamp !== undefined && Number(hf.timestamp) > timestamp));
        if (hfIndex === -1) {
            // all hardforks apply, set hfIndex to the last one as that's the candidate
            hfIndex = hfs.length;
        }
        else if (hfIndex === 0) {
            // cannot have a case where a block number is before all applied hardforks
            // since the chain has to start with a hardfork
            throw Error('Must have at least one hardfork at block 0');
        }
        // If timestamp is not provided, we need to rollback to the last hf with block or ttd
        if (timestamp === undefined) {
            const stepBack = hfs
                .slice(0, hfIndex)
                .reverse()
                .findIndex((hf) => hf.block !== null || hf.ttd !== undefined);
            hfIndex = hfIndex - stepBack;
        }
        // Move hfIndex one back to arrive at candidate hardfork
        hfIndex = hfIndex - 1;
        // If the timestamp was not provided, we could have skipped timestamp hardforks to look for number
        // hardforks. so it will now be needed to rollback
        if (hfs[hfIndex].block === null && hfs[hfIndex].timestamp === undefined) {
            // We're on the merge hardfork.  Let's check the TTD
            if (td === undefined || td === null || BigInt(hfs[hfIndex].ttd) > td) {
                // Merge ttd greater than current td so we're on hardfork before merge
                hfIndex -= 1;
            }
        }
        else {
            if (mergeIndex >= 0 && td !== undefined && td !== null) {
                if (hfIndex >= mergeIndex && BigInt(hfs[mergeIndex].ttd) > td) {
                    throw Error('Maximum HF determined by total difficulty is lower than the block number HF');
                }
                else if (hfIndex < mergeIndex && BigInt(hfs[mergeIndex].ttd) <= td) {
                    throw Error('HF determined by block number is lower than the minimum total difficulty HF');
                }
            }
        }
        const hfStartIndex = hfIndex;
        // Move the hfIndex to the end of the hardforks that might be scheduled on the same block/timestamp
        // This won't anyway be the case with Merge hfs
        for (; hfIndex < hfs.length - 1; hfIndex++) {
            // break out if hfIndex + 1 is not scheduled at hfIndex
            if (hfs[hfIndex].block !== hfs[hfIndex + 1].block ||
                hfs[hfIndex].timestamp !== hfs[hfIndex + 1].timestamp) {
                break;
            }
        }
        if (timestamp) {
            const minTimeStamp = hfs
                .slice(0, hfStartIndex)
                .reduce((acc, hf) => Math.max(Number(hf.timestamp ?? '0'), acc), 0);
            if (minTimeStamp > timestamp) {
                throw Error(`Maximum HF determined by timestamp is lower than the block number/ttd HF`);
            }
            const maxTimeStamp = hfs
                .slice(hfIndex + 1)
                .reduce((acc, hf) => Math.min(Number(hf.timestamp ?? timestamp), acc), timestamp);
            if (maxTimeStamp < timestamp) {
                throw Error(`Maximum HF determined by block number/ttd is lower than timestamp HF`);
            }
        }
        const hardfork = hfs[hfIndex];
        return hardfork.name;
    }
    /**
     * Sets a new hardfork based on the block number or an optional
     * total difficulty (Merge HF) provided.
     *
     * An optional TD takes precedence in case the corresponding HF block
     * is set to `null` or otherwise needs to match (if not an error
     * will be thrown).
     *
     * @param blockNumber
     * @param td
     * @param timestamp
     * @returns The name of the HF set
     */
    setHardforkByBlockNumber(blockNumber, td, timestamp) {
        const hardfork = this.getHardforkByBlockNumber(blockNumber, td, timestamp);
        this.setHardfork(hardfork);
        return hardfork;
    }
    /**
     * Internal helper function, returns the params for the given hardfork for the chain set
     * @param hardfork Hardfork name
     * @returns Dictionary with hardfork params or null if hardfork not on chain
     */
    _getHardfork(hardfork) {
        const hfs = this.hardforks();
        for (const hf of hfs) {
            if (hf['name'] === hardfork)
                return hf;
        }
        return null;
    }
    /**
     * Sets the active EIPs
     * @param eips
     */
    setEIPs(eips = []) {
        for (const eip of eips) {
            if (!(eip in eips_1.EIPs)) {
                throw new Error(`${eip} not supported`);
            }
            const minHF = this.gteHardfork(eips_1.EIPs[eip]['minimumHardfork']);
            if (!minHF) {
                throw new Error(`${eip} cannot be activated on hardfork ${this.hardfork()}, minimumHardfork: ${minHF}`);
            }
            if (eips_1.EIPs[eip].requiredEIPs !== undefined) {
                for (const elem of eips_1.EIPs[eip].requiredEIPs) {
                    if (!(eips.includes(elem) || this.isActivatedEIP(elem))) {
                        throw new Error(`${eip} requires EIP ${elem}, but is not included in the EIP list`);
                    }
                }
            }
        }
        this._eips = eips;
    }
    /**
     * Returns a parameter for the current chain setup
     *
     * If the parameter is present in an EIP, the EIP always takes precedence.
     * Otherwise the parameter if taken from the latest applied HF with
     * a change on the respective parameter.
     *
     * @param topic Parameter topic ('gasConfig', 'gasPrices', 'vm', 'pow')
     * @param name Parameter name (e.g. 'minGasLimit' for 'gasConfig' topic)
     * @returns The value requested or `BigInt(0)` if not found
     */
    param(topic, name) {
        // TODO: consider the case that different active EIPs
        // can change the same parameter
        let value;
        for (const eip of this._eips) {
            value = this.paramByEIP(topic, name, eip);
            if (value !== undefined)
                return value;
        }
        return this.paramByHardfork(topic, name, this._hardfork);
    }
    /**
     * Returns the parameter corresponding to a hardfork
     * @param topic Parameter topic ('gasConfig', 'gasPrices', 'vm', 'pow')
     * @param name Parameter name (e.g. 'minGasLimit' for 'gasConfig' topic)
     * @param hardfork Hardfork name
     * @returns The value requested or `BigInt(0)` if not found
     */
    paramByHardfork(topic, name, hardfork) {
        let value = null;
        for (const hfChanges of this.HARDFORK_CHANGES) {
            // EIP-referencing HF file (e.g. berlin.json)
            if ('eips' in hfChanges[1]) {
                const hfEIPs = hfChanges[1]['eips'];
                for (const eip of hfEIPs) {
                    const valueEIP = this.paramByEIP(topic, name, eip);
                    value = typeof valueEIP === 'bigint' ? valueEIP : value;
                }
                // Parameter-inlining HF file (e.g. istanbul.json)
            }
            else {
                if (hfChanges[1][topic] === undefined) {
                    throw new Error(`Topic ${topic} not defined`);
                }
                if (hfChanges[1][topic][name] !== undefined) {
                    value = hfChanges[1][topic][name].v;
                }
            }
            if (hfChanges[0] === hardfork)
                break;
        }
        return BigInt(value ?? 0);
    }
    /**
     * Returns a parameter corresponding to an EIP
     * @param topic Parameter topic ('gasConfig', 'gasPrices', 'vm', 'pow')
     * @param name Parameter name (e.g. 'minGasLimit' for 'gasConfig' topic)
     * @param eip Number of the EIP
     * @returns The value requested or `undefined` if not found
     */
    paramByEIP(topic, name, eip) {
        if (!(eip in eips_1.EIPs)) {
            throw new Error(`${eip} not supported`);
        }
        const eipParams = eips_1.EIPs[eip];
        if (!(topic in eipParams)) {
            throw new Error(`Topic ${topic} not defined`);
        }
        if (eipParams[topic][name] === undefined) {
            return undefined;
        }
        const value = eipParams[topic][name].v;
        return BigInt(value);
    }
    /**
     * Returns a parameter for the hardfork active on block number or
     * optional provided total difficulty (Merge HF)
     * @param topic Parameter topic
     * @param name Parameter name
     * @param blockNumber Block number
     * @param td Total difficulty
     *    * @returns The value requested or `BigInt(0)` if not found
     */
    paramByBlock(topic, name, blockNumber, td, timestamp) {
        const hardfork = this.getHardforkByBlockNumber(blockNumber, td, timestamp);
        return this.paramByHardfork(topic, name, hardfork);
    }
    /**
     * Checks if an EIP is activated by either being included in the EIPs
     * manually passed in with the {@link CommonOpts.eips} or in a
     * hardfork currently being active
     *
     * Note: this method only works for EIPs being supported
     * by the {@link CommonOpts.eips} constructor option
     * @param eip
     */
    isActivatedEIP(eip) {
        if (this.eips().includes(eip)) {
            return true;
        }
        for (const hfChanges of this.HARDFORK_CHANGES) {
            const hf = hfChanges[1];
            if (this.gteHardfork(hf['name']) && 'eips' in hf) {
                if (hf['eips'].includes(eip)) {
                    return true;
                }
            }
        }
        return false;
    }
    /**
     * Checks if set or provided hardfork is active on block number
     * @param hardfork Hardfork name or null (for HF set)
     * @param blockNumber
     * @returns True if HF is active on block number
     */
    hardforkIsActiveOnBlock(hardfork, blockNumber) {
        blockNumber = (0, util_1.toType)(blockNumber, util_1.TypeOutput.BigInt);
        hardfork = hardfork ?? this._hardfork;
        const hfBlock = this.hardforkBlock(hardfork);
        if (typeof hfBlock === 'bigint' && hfBlock !== BigInt(0) && blockNumber >= hfBlock) {
            return true;
        }
        return false;
    }
    /**
     * Alias to hardforkIsActiveOnBlock when hardfork is set
     * @param blockNumber
     * @returns True if HF is active on block number
     */
    activeOnBlock(blockNumber) {
        return this.hardforkIsActiveOnBlock(null, blockNumber);
    }
    /**
     * Sequence based check if given or set HF1 is greater than or equal HF2
     * @param hardfork1 Hardfork name or null (if set)
     * @param hardfork2 Hardfork name
     * @param opts Hardfork options
     * @returns True if HF1 gte HF2
     */
    hardforkGteHardfork(hardfork1, hardfork2) {
        hardfork1 = hardfork1 ?? this._hardfork;
        const hardforks = this.hardforks();
        let posHf1 = -1, posHf2 = -1;
        let index = 0;
        for (const hf of hardforks) {
            if (hf['name'] === hardfork1)
                posHf1 = index;
            if (hf['name'] === hardfork2)
                posHf2 = index;
            index += 1;
        }
        return posHf1 >= posHf2 && posHf2 !== -1;
    }
    /**
     * Alias to hardforkGteHardfork when hardfork is set
     * @param hardfork Hardfork name
     * @returns True if hardfork set is greater than hardfork provided
     */
    gteHardfork(hardfork) {
        return this.hardforkGteHardfork(null, hardfork);
    }
    /**
     * Returns the hardfork change block for hardfork provided or set
     * @param hardfork Hardfork name, optional if HF set
     * @returns Block number or null if unscheduled
     */
    hardforkBlock(hardfork) {
        hardfork = hardfork ?? this._hardfork;
        const block = this._getHardfork(hardfork)?.['block'];
        if (block === undefined || block === null) {
            return null;
        }
        return BigInt(block);
    }
    hardforkTimestamp(hardfork) {
        hardfork = hardfork ?? this._hardfork;
        const timestamp = this._getHardfork(hardfork)?.['timestamp'];
        if (timestamp === undefined || timestamp === null) {
            return null;
        }
        return BigInt(timestamp);
    }
    /**
     * Returns the hardfork change block for eip
     * @param eip EIP number
     * @returns Block number or null if unscheduled
     */
    eipBlock(eip) {
        for (const hfChanges of this.HARDFORK_CHANGES) {
            const hf = hfChanges[1];
            if ('eips' in hf) {
                // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
                if (hf['eips'].includes(eip)) {
                    return this.hardforkBlock(hfChanges[0]);
                }
            }
        }
        return null;
    }
    /**
     * Returns the hardfork change total difficulty (Merge HF) for hardfork provided or set
     * @param hardfork Hardfork name, optional if HF set
     * @returns Total difficulty or null if no set
     */
    hardforkTTD(hardfork) {
        hardfork = hardfork ?? this._hardfork;
        const ttd = this._getHardfork(hardfork)?.['ttd'];
        if (ttd === undefined || ttd === null) {
            return null;
        }
        return BigInt(ttd);
    }
    /**
     * True if block number provided is the hardfork (given or set) change block
     * @param blockNumber Number of the block to check
     * @param hardfork Hardfork name, optional if HF set
     * @returns True if blockNumber is HF block
     * @deprecated
     */
    isHardforkBlock(blockNumber, hardfork) {
        blockNumber = (0, util_1.toType)(blockNumber, util_1.TypeOutput.BigInt);
        hardfork = hardfork ?? this._hardfork;
        const block = this.hardforkBlock(hardfork);
        return typeof block === 'bigint' && block !== BigInt(0) ? block === blockNumber : false;
    }
    /**
     * Returns the change block for the next hardfork after the hardfork provided or set
     * @param hardfork Hardfork name, optional if HF set
     * @returns Block timestamp, number or null if not available
     */
    nextHardforkBlockOrTimestamp(hardfork) {
        hardfork = hardfork ?? this._hardfork;
        const hfs = this.hardforks();
        let hfIndex = hfs.findIndex((hf) => hf.name === hardfork);
        // If the current hardfork is merge, go one behind as merge hf is not part of these
        // calcs even if the merge hf block is set
        if (hardfork === enums_1.Hardfork.Merge) {
            hfIndex -= 1;
        }
        // Hardfork not found
        if (hfIndex < 0) {
            return null;
        }
        let currHfTimeOrBlock = hfs[hfIndex].timestamp ?? hfs[hfIndex].block;
        currHfTimeOrBlock =
            currHfTimeOrBlock !== null && currHfTimeOrBlock !== undefined
                ? Number(currHfTimeOrBlock)
                : null;
        const nextHf = hfs.slice(hfIndex + 1).find((hf) => {
            let hfTimeOrBlock = hf.timestamp ?? hf.block;
            hfTimeOrBlock =
                hfTimeOrBlock !== null && hfTimeOrBlock !== undefined ? Number(hfTimeOrBlock) : null;
            return (hf.name !== enums_1.Hardfork.Merge &&
                hfTimeOrBlock !== null &&
                hfTimeOrBlock !== undefined &&
                hfTimeOrBlock !== currHfTimeOrBlock);
        });
        // If no next hf found with valid block or timestamp return null
        if (nextHf === undefined) {
            return null;
        }
        const nextHfBlock = nextHf.timestamp ?? nextHf.block;
        if (nextHfBlock === null || nextHfBlock === undefined) {
            return null;
        }
        return BigInt(nextHfBlock);
    }
    /**
     * Returns the change block for the next hardfork after the hardfork provided or set
     * @param hardfork Hardfork name, optional if HF set
     * @returns Block number or null if not available
     * @deprecated
     */
    nextHardforkBlock(hardfork) {
        hardfork = hardfork ?? this._hardfork;
        let hfBlock = this.hardforkBlock(hardfork);
        // If this is a merge hardfork with block not set, then we fallback to previous hardfork
        // to find the nextHardforkBlock
        if (hfBlock === null && hardfork === enums_1.Hardfork.Merge) {
            const hfs = this.hardforks();
            const mergeIndex = hfs.findIndex((hf) => hf.ttd !== null && hf.ttd !== undefined);
            if (mergeIndex < 0) {
                throw Error(`Merge hardfork should have been found`);
            }
            hfBlock = this.hardforkBlock(hfs[mergeIndex - 1].name);
        }
        if (hfBlock === null) {
            return null;
        }
        // Next fork block number or null if none available
        // Logic: if accumulator is still null and on the first occurrence of
        // a block greater than the current hfBlock set the accumulator,
        // pass on the accumulator as the final result from this time on
        const nextHfBlock = this.hardforks().reduce((acc, hf) => {
            // We need to ignore the merge block in our next hardfork calc
            const block = BigInt(hf.block === null || (hf.ttd !== undefined && hf.ttd !== null) ? 0 : hf.block);
            // Typescript can't seem to follow that the hfBlock is not null at this point
            return block > hfBlock && acc === null ? block : acc;
        }, null);
        return nextHfBlock;
    }
    /**
     * True if block number provided is the hardfork change block following the hardfork given or set
     * @param blockNumber Number of the block to check
     * @param hardfork Hardfork name, optional if HF set
     * @returns True if blockNumber is HF block
     * @deprecated
     */
    isNextHardforkBlock(blockNumber, hardfork) {
        blockNumber = (0, util_1.toType)(blockNumber, util_1.TypeOutput.BigInt);
        hardfork = hardfork ?? this._hardfork;
        const nextHardforkBlock = this.nextHardforkBlock(hardfork);
        return nextHardforkBlock === null ? false : nextHardforkBlock === blockNumber;
    }
    /**
     * Internal helper function to calculate a fork hash
     * @param hardfork Hardfork name
     * @param genesisHash Genesis block hash of the chain
     * @returns Fork hash as hex string
     */
    _calcForkHash(hardfork, genesisHash) {
        let hfBuffer = Buffer.alloc(0);
        let prevBlockOrTime = 0;
        for (const hf of this.hardforks()) {
            const { block, timestamp, name } = hf;
            // Timestamp to be used for timestamp based hfs even if we may bundle
            // block number with them retrospectively
            let blockOrTime = timestamp ?? block;
            blockOrTime = blockOrTime !== null ? Number(blockOrTime) : null;
            // Skip for chainstart (0), not applied HFs (null) and
            // when already applied on same blockOrTime HFs
            // and on the merge since forkhash doesn't change on merge hf
            if (typeof blockOrTime === 'number' &&
                blockOrTime !== 0 &&
                blockOrTime !== prevBlockOrTime &&
                name !== enums_1.Hardfork.Merge) {
                const hfBlockBuffer = Buffer.from(blockOrTime.toString(16).padStart(16, '0'), 'hex');
                hfBuffer = Buffer.concat([hfBuffer, hfBlockBuffer]);
                prevBlockOrTime = blockOrTime;
            }
            if (hf.name === hardfork)
                break;
        }
        const inputBuffer = Buffer.concat([genesisHash, hfBuffer]);
        // CRC32 delivers result as signed (negative) 32-bit integer,
        // convert to hex string
        const forkhash = (0, util_1.intToBuffer)((0, crc_32_1.buf)(inputBuffer) >>> 0).toString('hex');
        return `0x${forkhash}`;
    }
    /**
     * Returns an eth/64 compliant fork hash (EIP-2124)
     * @param hardfork Hardfork name, optional if HF set
     * @param genesisHash Genesis block hash of the chain, optional if already defined and not needed to be calculated
     */
    forkHash(hardfork, genesisHash) {
        hardfork = hardfork ?? this._hardfork;
        const data = this._getHardfork(hardfork);
        if (data === null ||
            (data?.block === null && data?.timestamp === undefined && data?.ttd === undefined)) {
            const msg = 'No fork hash calculation possible for future hardfork';
            throw new Error(msg);
        }
        if (data?.forkHash !== null && data?.forkHash !== undefined) {
            return data.forkHash;
        }
        if (!genesisHash)
            throw new Error('genesisHash required for forkHash calculation');
        return this._calcForkHash(hardfork, genesisHash);
    }
    /**
     *
     * @param forkHash Fork hash as a hex string
     * @returns Array with hardfork data (name, block, forkHash)
     */
    hardforkForForkHash(forkHash) {
        const resArray = this.hardforks().filter((hf) => {
            return hf.forkHash === forkHash;
        });
        return resArray.length >= 1 ? resArray[resArray.length - 1] : null;
    }
    /**
     * Sets any missing forkHashes on the passed-in {@link Common} instance
     * @param common The {@link Common} to set the forkHashes for
     * @param genesisHash The genesis block hash
     */
    setForkHashes(genesisHash) {
        for (const hf of this.hardforks()) {
            const blockOrTime = hf.timestamp ?? hf.block;
            if ((hf.forkHash === null || hf.forkHash === undefined) &&
                ((blockOrTime !== null && blockOrTime !== undefined) || typeof hf.ttd !== 'undefined')) {
                hf.forkHash = this.forkHash(hf.name, genesisHash);
            }
        }
    }
    /**
     * Returns the Genesis parameters of the current chain
     * @returns Genesis dictionary
     */
    genesis() {
        return this._chainParams.genesis;
    }
    /**
     * Returns the hardforks for current chain
     * @returns {Array} Array with arrays of hardforks
     */
    hardforks() {
        return this._chainParams.hardforks;
    }
    /**
     * Returns bootstrap nodes for the current chain
     * @returns {Dictionary} Dict with bootstrap nodes
     */
    bootstrapNodes() {
        return this._chainParams.bootstrapNodes;
    }
    /**
     * Returns DNS networks for the current chain
     * @returns {String[]} Array of DNS ENR urls
     */
    dnsNetworks() {
        return this._chainParams.dnsNetworks;
    }
    /**
     * Returns the hardfork set
     * @returns Hardfork name
     */
    hardfork() {
        return this._hardfork;
    }
    /**
     * Returns the Id of current chain
     * @returns chain Id
     */
    chainId() {
        return BigInt(this._chainParams.chainId);
    }
    /**
     * Returns the name of current chain
     * @returns chain name (lower case)
     */
    chainName() {
        return this._chainParams.name;
    }
    /**
     * Returns the Id of current network
     * @returns network Id
     */
    networkId() {
        return BigInt(this._chainParams.networkId);
    }
    /**
     * Returns the active EIPs
     * @returns List of EIPs
     */
    eips() {
        return this._eips;
    }
    /**
     * Returns the consensus type of the network
     * Possible values: "pow"|"poa"|"pos"
     *
     * Note: This value can update along a Hardfork.
     */
    consensusType() {
        const hardfork = this.hardfork();
        let value;
        for (const hfChanges of this.HARDFORK_CHANGES) {
            if ('consensus' in hfChanges[1]) {
                value = hfChanges[1]['consensus']['type'];
            }
            if (hfChanges[0] === hardfork)
                break;
        }
        return value ?? this._chainParams['consensus']['type'];
    }
    /**
     * Returns the concrete consensus implementation
     * algorithm or protocol for the network
     * e.g. "ethash" for "pow" consensus type,
     * "clique" for "poa" consensus type or
     * "casper" for "pos" consensus type.
     *
     * Note: This value can update along a Hardfork.
     */
    consensusAlgorithm() {
        const hardfork = this.hardfork();
        let value;
        for (const hfChanges of this.HARDFORK_CHANGES) {
            if ('consensus' in hfChanges[1]) {
                value = hfChanges[1]['consensus']['algorithm'];
            }
            if (hfChanges[0] === hardfork)
                break;
        }
        return value ?? this._chainParams['consensus']['algorithm'];
    }
    /**
     * Returns a dictionary with consensus configuration
     * parameters based on the consensus algorithm
     *
     * Expected returns (parameters must be present in
     * the respective chain json files):
     *
     * ethash: empty object
     * clique: period, epoch
     * casper: empty object
     *
     * Note: This value can update along a Hardfork.
     */
    consensusConfig() {
        const hardfork = this.hardfork();
        let value;
        for (const hfChanges of this.HARDFORK_CHANGES) {
            if ('consensus' in hfChanges[1]) {
                // The config parameter is named after the respective consensus algorithm
                value = hfChanges[1]['consensus'][hfChanges[1]['consensus']['algorithm']];
            }
            if (hfChanges[0] === hardfork)
                break;
        }
        return (value ?? this._chainParams['consensus'][this.consensusAlgorithm()] ?? {});
    }
    /**
     * Returns a deep copy of this {@link Common} instance.
     */
    copy() {
        const copy = Object.assign(Object.create(Object.getPrototypeOf(this)), this);
        copy.removeAllListeners();
        return copy;
    }
    static _getInitializedChains(customChains) {
        const names = {};
        for (const [name, id] of Object.entries(enums_1.Chain)) {
            names[id] = name.toLowerCase();
        }
        const chains = { mainnet, ropsten, rinkeby, goerli, sepolia };
        if (customChains) {
            for (const chain of customChains) {
                const { name } = chain;
                names[chain.chainId.toString()] = name;
                chains[name] = chain;
            }
        }
        chains.names = names;
        return chains;
    }
}
exports.Common = Common;

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\common.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\1153.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C1153.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-1153",
    "number": 1153,
    "comment": "Transient Storage",
    "url": "https://eips.ethereum.org/EIPS/eip-1153",
    "status": "Review",
    "minimumHardfork": "chainstart",
    "requiredEIPs": [],
    "gasConfig": {},
    "gasPrices": {
        "tstore": {
            "v": 100,
            "d": "Base fee of the TSTORE opcode"
        },
        "tload": {
            "v": 100,
            "d": "Base fee of the TLOAD opcode"
        }
    },
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\1153.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\1559.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C1559.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-1559",
    "number": 1559,
    "comment": "Fee market change for ETH 1.0 chain",
    "url": "https://eips.ethereum.org/EIPS/eip-1559",
    "status": "Final",
    "minimumHardfork": "berlin",
    "requiredEIPs": [2930],
    "gasConfig": {
        "baseFeeMaxChangeDenominator": {
            "v": 8,
            "d": "Maximum base fee change denominator"
        },
        "elasticityMultiplier": {
            "v": 2,
            "d": "Maximum block gas target elasticity"
        },
        "initialBaseFee": {
            "v": 1000000000,
            "d": "Initial base fee on first EIP1559 block"
        }
    },
    "gasPrices": {},
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\1559.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\2315.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C2315.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-2315",
    "number": 2315,
    "comment": "Simple subroutines for the EVM",
    "url": "https://eips.ethereum.org/EIPS/eip-2315",
    "status": "Draft",
    "minimumHardfork": "istanbul",
    "gasConfig": {},
    "gasPrices": {
        "beginsub": {
            "v": 2,
            "d": "Base fee of the BEGINSUB opcode"
        },
        "returnsub": {
            "v": 5,
            "d": "Base fee of the RETURNSUB opcode"
        },
        "jumpsub": {
            "v": 10,
            "d": "Base fee of the JUMPSUB opcode"
        }
    },
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\2315.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\2537.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C2537.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-2537",
    "number": 2537,
    "comment": "BLS12-381 precompiles",
    "url": "https://eips.ethereum.org/EIPS/eip-2537",
    "status": "Draft",
    "minimumHardfork": "chainstart",
    "gasConfig": {},
    "gasPrices": {
        "Bls12381G1AddGas": {
            "v": 600,
            "d": "Gas cost of a single BLS12-381 G1 addition precompile-call"
        },
        "Bls12381G1MulGas": {
            "v": 12000,
            "d": "Gas cost of a single BLS12-381 G1 multiplication precompile-call"
        },
        "Bls12381G2AddGas": {
            "v": 4500,
            "d": "Gas cost of a single BLS12-381 G2 addition precompile-call"
        },
        "Bls12381G2MulGas": {
            "v": 55000,
            "d": "Gas cost of a single BLS12-381 G2 multiplication precompile-call"
        },
        "Bls12381PairingBaseGas": {
            "v": 115000,
            "d": "Base gas cost of BLS12-381 pairing check"
        },
        "Bls12381PairingPerPairGas": {
            "v": 23000,
            "d": "Per-pair gas cost of BLS12-381 pairing check"
        },
        "Bls12381MapG1Gas": {
            "v": 5500,
            "d": "Gas cost of BLS12-381 map field element to G1"
        },
        "Bls12381MapG2Gas": {
            "v": 110000,
            "d": "Gas cost of BLS12-381 map field element to G2"
        },
        "Bls12381MultiExpGasDiscount": {
            "v": [
                [1, 1200],
                [2, 888],
                [3, 764],
                [4, 641],
                [5, 594],
                [6, 547],
                [7, 500],
                [8, 453],
                [9, 438],
                [10, 423],
                [11, 408],
                [12, 394],
                [13, 379],
                [14, 364],
                [15, 349],
                [16, 334],
                [17, 330],
                [18, 326],
                [19, 322],
                [20, 318],
                [21, 314],
                [22, 310],
                [23, 306],
                [24, 302],
                [25, 298],
                [26, 294],
                [27, 289],
                [28, 285],
                [29, 281],
                [30, 277],
                [31, 273],
                [32, 269],
                [33, 268],
                [34, 266],
                [35, 265],
                [36, 263],
                [37, 262],
                [38, 260],
                [39, 259],
                [40, 257],
                [41, 256],
                [42, 254],
                [43, 253],
                [44, 251],
                [45, 250],
                [46, 248],
                [47, 247],
                [48, 245],
                [49, 244],
                [50, 242],
                [51, 241],
                [52, 239],
                [53, 238],
                [54, 236],
                [55, 235],
                [56, 233],
                [57, 232],
                [58, 231],
                [59, 229],
                [60, 228],
                [61, 226],
                [62, 225],
                [63, 223],
                [64, 222],
                [65, 221],
                [66, 220],
                [67, 219],
                [68, 219],
                [69, 218],
                [70, 217],
                [71, 216],
                [72, 216],
                [73, 215],
                [74, 214],
                [75, 213],
                [76, 213],
                [77, 212],
                [78, 211],
                [79, 211],
                [80, 210],
                [81, 209],
                [82, 208],
                [83, 208],
                [84, 207],
                [85, 206],
                [86, 205],
                [87, 205],
                [88, 204],
                [89, 203],
                [90, 202],
                [91, 202],
                [92, 201],
                [93, 200],
                [94, 199],
                [95, 199],
                [96, 198],
                [97, 197],
                [98, 196],
                [99, 196],
                [100, 195],
                [101, 194],
                [102, 193],
                [103, 193],
                [104, 192],
                [105, 191],
                [106, 191],
                [107, 190],
                [108, 189],
                [109, 188],
                [110, 188],
                [111, 187],
                [112, 186],
                [113, 185],
                [114, 185],
                [115, 184],
                [116, 183],
                [117, 182],
                [118, 182],
                [119, 181],
                [120, 180],
                [121, 179],
                [122, 179],
                [123, 178],
                [124, 177],
                [125, 176],
                [126, 176],
                [127, 175],
                [128, 174]
            ],
            "d": "Discount gas costs of calls to the MultiExp precompiles with `k` (point, scalar) pair"
        }
    },
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\2537.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\2565.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C2565.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-2565",
    "number": 2565,
    "comment": "ModExp gas cost",
    "url": "https://eips.ethereum.org/EIPS/eip-2565",
    "status": "Final",
    "minimumHardfork": "byzantium",
    "gasConfig": {},
    "gasPrices": {
        "modexpGquaddivisor": {
            "v": 3,
            "d": "Gquaddivisor from modexp precompile for gas calculation"
        }
    },
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\2565.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\2718.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C2718.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-2718",
    "comment": "Typed Transaction Envelope",
    "url": "https://eips.ethereum.org/EIPS/eip-2718",
    "status": "Final",
    "minimumHardfork": "chainstart",
    "gasConfig": {},
    "gasPrices": {},
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\2718.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\2929.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C2929.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-2929",
    "comment": "Gas cost increases for state access opcodes",
    "url": "https://eips.ethereum.org/EIPS/eip-2929",
    "status": "Final",
    "minimumHardfork": "chainstart",
    "gasConfig": {},
    "gasPrices": {
        "coldsload": {
            "v": 2100,
            "d": "Gas cost of the first read of storage from a given location (per transaction)"
        },
        "coldaccountaccess": {
            "v": 2600,
            "d": "Gas cost of the first read of a given address (per transaction)"
        },
        "warmstorageread": {
            "v": 100,
            "d": "Gas cost of reading storage locations which have already loaded 'cold'"
        },
        "sstoreCleanGasEIP2200": {
            "v": 2900,
            "d": "Once per SSTORE operation from clean non-zero to something else"
        },
        "sstoreNoopGasEIP2200": {
            "v": 100,
            "d": "Once per SSTORE operation if the value doesn't change"
        },
        "sstoreDirtyGasEIP2200": {
            "v": 100,
            "d": "Once per SSTORE operation if a dirty value is changed"
        },
        "sstoreInitRefundEIP2200": {
            "v": 19900,
            "d": "Once per SSTORE operation for resetting to the original zero value"
        },
        "sstoreCleanRefundEIP2200": {
            "v": 4900,
            "d": "Once per SSTORE operation for resetting to the original non-zero value"
        },
        "call": {
            "v": 0,
            "d": "Base fee of the CALL opcode"
        },
        "callcode": {
            "v": 0,
            "d": "Base fee of the CALLCODE opcode"
        },
        "delegatecall": {
            "v": 0,
            "d": "Base fee of the DELEGATECALL opcode"
        },
        "staticcall": {
            "v": 0,
            "d": "Base fee of the STATICCALL opcode"
        },
        "balance": {
            "v": 0,
            "d": "Base fee of the BALANCE opcode"
        },
        "extcodesize": {
            "v": 0,
            "d": "Base fee of the EXTCODESIZE opcode"
        },
        "extcodecopy": {
            "v": 0,
            "d": "Base fee of the EXTCODECOPY opcode"
        },
        "extcodehash": {
            "v": 0,
            "d": "Base fee of the EXTCODEHASH opcode"
        },
        "sload": {
            "v": 0,
            "d": "Base fee of the SLOAD opcode"
        },
        "sstore": {
            "v": 0,
            "d": "Base fee of the SSTORE opcode"
        }
    },
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\2929.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\2930.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C2930.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-2930",
    "comment": "Optional access lists",
    "url": "https://eips.ethereum.org/EIPS/eip-2930",
    "status": "Final",
    "minimumHardfork": "istanbul",
    "requiredEIPs": [2718, 2929],
    "gasConfig": {},
    "gasPrices": {
        "accessListStorageKeyCost": {
            "v": 1900,
            "d": "Gas cost per storage key in an Access List transaction"
        },
        "accessListAddressCost": {
            "v": 2400,
            "d": "Gas cost per storage key in an Access List transaction"
        }
    },
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\2930.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3074.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C3074.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-3074",
    "number": 3074,
    "comment": "AUTH and AUTHCALL opcodes",
    "url": "https://eips.ethereum.org/EIPS/eip-3074",
    "status": "Review",
    "minimumHardfork": "london",
    "gasConfig": {},
    "gasPrices": {
        "auth": {
            "v": 3100,
            "d": "Gas cost of the AUTH opcode"
        },
        "authcall": {
            "v": 0,
            "d": "Gas cost of the AUTHCALL opcode"
        },
        "authcallValueTransfer": {
            "v": 6700,
            "d": "Paid for CALL when the value transfer is non-zero"
        }
    },
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3074.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3198.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C3198.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-3198",
    "number": 3198,
    "comment": "BASEFEE opcode",
    "url": "https://eips.ethereum.org/EIPS/eip-3198",
    "status": "Final",
    "minimumHardfork": "london",
    "gasConfig": {},
    "gasPrices": {
        "basefee": {
            "v": 2,
            "d": "Gas cost of the BASEFEE opcode"
        }
    },
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3198.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3529.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C3529.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-3529",
    "comment": "Reduction in refunds",
    "url": "https://eips.ethereum.org/EIPS/eip-3529",
    "status": "Final",
    "minimumHardfork": "berlin",
    "requiredEIPs": [2929],
    "gasConfig": {
        "maxRefundQuotient": {
            "v": 5,
            "d": "Maximum refund quotient; max tx refund is min(tx.gasUsed/maxRefundQuotient, tx.gasRefund)"
        }
    },
    "gasPrices": {
        "selfdestructRefund": {
            "v": 0,
            "d": "Refunded following a selfdestruct operation"
        },
        "sstoreClearRefundEIP2200": {
            "v": 4800,
            "d": "Once per SSTORE operation for clearing an originally existing storage slot"
        }
    },
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3529.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3540.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C3540.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-3540",
    "number": 3540,
    "comment": "EVM Object Format (EOF) v1",
    "url": "https://eips.ethereum.org/EIPS/eip-3540",
    "status": "Review",
    "minimumHardfork": "london",
    "requiredEIPs": [3541],
    "gasConfig": {},
    "gasPrices": {},
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3540.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3541.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C3541.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-3541",
    "comment": "Reject new contracts starting with the 0xEF byte",
    "url": "https://eips.ethereum.org/EIPS/eip-3541",
    "status": "Final",
    "minimumHardfork": "berlin",
    "requiredEIPs": [],
    "gasConfig": {},
    "gasPrices": {},
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3541.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3554.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C3554.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-3554",
    "comment": "Reduction in refunds",
    "url": "Difficulty Bomb Delay to December 1st 2021",
    "status": "Final",
    "minimumHardfork": "muirGlacier",
    "requiredEIPs": [],
    "gasConfig": {},
    "gasPrices": {},
    "vm": {},
    "pow": {
        "difficultyBombDelay": {
            "v": 9500000,
            "d": "the amount of blocks to delay the difficulty bomb with"
        }
    }
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3554.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3607.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C3607.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-3607",
    "number": 3607,
    "comment": "Reject transactions from senders with deployed code",
    "url": "https://eips.ethereum.org/EIPS/eip-3607",
    "status": "Final",
    "minimumHardfork": "chainstart",
    "requiredEIPs": [],
    "gasConfig": {},
    "gasPrices": {},
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3607.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3651.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C3651.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-3651",
    "number": 3198,
    "comment": "Warm COINBASE",
    "url": "https://eips.ethereum.org/EIPS/eip-3651",
    "status": "Review",
    "minimumHardfork": "london",
    "requiredEIPs": [2929],
    "gasConfig": {},
    "gasPrices": {},
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3651.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3670.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C3670.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-3670",
    "number": 3670,
    "comment": "EOF - Code Validation",
    "url": "https://eips.ethereum.org/EIPS/eip-3670",
    "status": "Review",
    "minimumHardfork": "london",
    "requiredEIPs": [3540],
    "gasConfig": {},
    "gasPrices": {},
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3670.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3675.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C3675.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-3675",
    "number": 3675,
    "comment": "Upgrade consensus to Proof-of-Stake",
    "url": "https://eips.ethereum.org/EIPS/eip-3675",
    "status": "Final",
    "minimumHardfork": "london",
    "requiredEIPs": [],
    "gasConfig": {},
    "gasPrices": {},
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3675.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3855.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C3855.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-3855",
    "number": 3855,
    "comment": "PUSH0 instruction",
    "url": "https://eips.ethereum.org/EIPS/eip-3855",
    "status": "Review",
    "minimumHardfork": "chainstart",
    "requiredEIPs": [],
    "gasConfig": {},
    "gasPrices": {
        "push0": {
            "v": 2,
            "d": "Base fee of the PUSH0 opcode"
        }
    },
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3855.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3860.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C3860.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-3860",
    "number": 3860,
    "comment": "Limit and meter initcode",
    "url": "https://eips.ethereum.org/EIPS/eip-3860",
    "status": "Review",
    "minimumHardfork": "spuriousDragon",
    "requiredEIPs": [],
    "gasConfig": {},
    "gasPrices": {
        "initCodeWordCost": {
            "v": 2,
            "d": "Gas to pay for each word (32 bytes) of initcode when creating a contract"
        }
    },
    "vm": {
        "maxInitCodeSize": {
            "v": 49152,
            "d": "Maximum length of initialization code when creating a contract"
        }
    },
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3860.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\4345.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C4345.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-4345",
    "number": 4345,
    "comment": "Difficulty Bomb Delay to June 2022",
    "url": "https://eips.ethereum.org/EIPS/eip-4345",
    "status": "Final",
    "minimumHardfork": "london",
    "gasConfig": {},
    "gasPrices": {},
    "vm": {},
    "pow": {
        "difficultyBombDelay": {
            "v": 10700000,
            "d": "the amount of blocks to delay the difficulty bomb with"
        }
    }
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\4345.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\4399.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C4399.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-4399",
    "number": 4399,
    "comment": "Supplant DIFFICULTY opcode with PREVRANDAO",
    "url": "https://eips.ethereum.org/EIPS/eip-4399",
    "status": "Review",
    "minimumHardfork": "london",
    "requiredEIPs": [],
    "gasConfig": {},
    "gasPrices": {},
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\4399.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\4844.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C4844.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-4844",
    "number": 4844,
    "comment": "Shard Blob Transactions",
    "url": "https://eips.ethereum.org/EIPS/eip-4844",
    "status": "Draft",
    "minimumHardfork": "merge",
    "requiredEIPs": [1559, 2718, 2930, 4895],
    "gasConfig": {
        "dataGasPerBlob": {
            "v": 131072,
            "d": "The base fee for data gas per blob"
        },
        "targetDataGasPerBlock": {
            "v": 262144,
            "d": "The target data gas consumed per block"
        },
        "maxDataGasPerBlock": {
            "v": 524288,
            "d": "The max data gas allowable per block"
        },
        "dataGasPriceUpdateFraction": {
            "v": 2225652,
            "d": "The denominator used in the exponential when calculating a data gas price"
        }
    },
    "gasPrices": {
        "simpleGasPerBlob": {
            "v": 12000,
            "d": "The basic gas fee for each blob"
        },
        "minDataGasPrice": {
            "v": 1,
            "d": "The minimum fee per data gas"
        },
        "kzgPointEvaluationGasPrecompilePrice": {
            "v": 50000,
            "d": "The fee associated with the point evaluation precompile"
        },
        "datahash": {
            "v": 3,
            "d": "Base fee of the DATAHASH opcode"
        }
    },
    "sharding": {
        "blobCommitmentVersionKzg": {
            "v": 1,
            "d": "The number indicated a versioned hash is a KZG commitment"
        },
        "fieldElementsPerBlob": {
            "v": 4096,
            "d": "The number of field elements allowed per blob"
        }
    },
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\4844.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\4895.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C4895.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-4895",
    "number": 4895,
    "comment": "Beacon chain push withdrawals as operations",
    "url": "https://eips.ethereum.org/EIPS/eip-4895",
    "status": "Review",
    "minimumHardfork": "merge",
    "requiredEIPs": [],
    "gasConfig": {},
    "gasPrices": {},
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\4895.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\5133.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5C5133.json
      return function (require, module, exports) {
module.exports={
    "name": "EIP-5133",
    "number": 5133,
    "comment": "Delaying Difficulty Bomb to mid-September 2022",
    "url": "https://eips.ethereum.org/EIPS/eip-5133",
    "status": "Draft",
    "minimumHardfork": "grayGlacier",
    "gasConfig": {},
    "gasPrices": {},
    "vm": {},
    "pow": {
        "difficultyBombDelay": {
            "v": 11400000,
            "d": "the amount of blocks to delay the difficulty bomb with"
        }
    }
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\5133.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\index.js", {"./1153.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\1153.json","./1559.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\1559.json","./2315.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\2315.json","./2537.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\2537.json","./2565.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\2565.json","./2718.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\2718.json","./2929.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\2929.json","./2930.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\2930.json","./3074.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3074.json","./3198.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3198.json","./3529.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3529.json","./3540.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3540.json","./3541.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3541.json","./3554.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3554.json","./3607.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3607.json","./3651.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3651.json","./3670.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3670.json","./3675.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3675.json","./3855.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3855.json","./3860.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\3860.json","./4345.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\4345.json","./4399.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\4399.json","./4844.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\4844.json","./4895.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\4895.json","./5133.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\5133.json"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ceips%5Cindex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EIPs = void 0;
exports.EIPs = {
    1153: require('./1153.json'),
    1559: require('./1559.json'),
    2315: require('./2315.json'),
    2537: require('./2537.json'),
    2565: require('./2565.json'),
    2718: require('./2718.json'),
    2929: require('./2929.json'),
    2930: require('./2930.json'),
    3074: require('./3074.json'),
    3198: require('./3198.json'),
    3529: require('./3529.json'),
    3540: require('./3540.json'),
    3541: require('./3541.json'),
    3554: require('./3554.json'),
    3607: require('./3607.json'),
    3651: require('./3651.json'),
    3670: require('./3670.json'),
    3675: require('./3675.json'),
    3855: require('./3855.json'),
    3860: require('./3860.json'),
    4345: require('./4345.json'),
    4399: require('./4399.json'),
    4844: require('./4844.json'),
    4895: require('./4895.json'),
    5133: require('./5133.json'),
};

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\eips\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\enums.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Cenums.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomChain = exports.ConsensusAlgorithm = exports.ConsensusType = exports.Hardfork = exports.Chain = void 0;
var Chain;
(function (Chain) {
    Chain[Chain["Mainnet"] = 1] = "Mainnet";
    Chain[Chain["Ropsten"] = 3] = "Ropsten";
    Chain[Chain["Rinkeby"] = 4] = "Rinkeby";
    Chain[Chain["Goerli"] = 5] = "Goerli";
    Chain[Chain["Sepolia"] = 11155111] = "Sepolia";
})(Chain = exports.Chain || (exports.Chain = {}));
var Hardfork;
(function (Hardfork) {
    Hardfork["Chainstart"] = "chainstart";
    Hardfork["Homestead"] = "homestead";
    Hardfork["Dao"] = "dao";
    Hardfork["TangerineWhistle"] = "tangerineWhistle";
    Hardfork["SpuriousDragon"] = "spuriousDragon";
    Hardfork["Byzantium"] = "byzantium";
    Hardfork["Constantinople"] = "constantinople";
    Hardfork["Petersburg"] = "petersburg";
    Hardfork["Istanbul"] = "istanbul";
    Hardfork["MuirGlacier"] = "muirGlacier";
    Hardfork["Berlin"] = "berlin";
    Hardfork["London"] = "london";
    Hardfork["ArrowGlacier"] = "arrowGlacier";
    Hardfork["GrayGlacier"] = "grayGlacier";
    Hardfork["MergeForkIdTransition"] = "mergeForkIdTransition";
    Hardfork["Merge"] = "merge";
    Hardfork["Shanghai"] = "shanghai";
    Hardfork["ShardingForkDev"] = "shardingFork";
})(Hardfork = exports.Hardfork || (exports.Hardfork = {}));
var ConsensusType;
(function (ConsensusType) {
    ConsensusType["ProofOfStake"] = "pos";
    ConsensusType["ProofOfWork"] = "pow";
    ConsensusType["ProofOfAuthority"] = "poa";
})(ConsensusType = exports.ConsensusType || (exports.ConsensusType = {}));
var ConsensusAlgorithm;
(function (ConsensusAlgorithm) {
    ConsensusAlgorithm["Ethash"] = "ethash";
    ConsensusAlgorithm["Clique"] = "clique";
    ConsensusAlgorithm["Casper"] = "casper";
})(ConsensusAlgorithm = exports.ConsensusAlgorithm || (exports.ConsensusAlgorithm = {}));
var CustomChain;
(function (CustomChain) {
    /**
     * Polygon (Matic) Mainnet
     *
     * - [Documentation](https://docs.matic.network/docs/develop/network-details/network)
     */
    CustomChain["PolygonMainnet"] = "polygon-mainnet";
    /**
     * Polygon (Matic) Mumbai Testnet
     *
     * - [Documentation](https://docs.matic.network/docs/develop/network-details/network)
     */
    CustomChain["PolygonMumbai"] = "polygon-mumbai";
    /**
     * Arbitrum Rinkeby Testnet
     *
     * - [Documentation](https://developer.offchainlabs.com/docs/public_testnet)
     */
    CustomChain["ArbitrumRinkebyTestnet"] = "arbitrum-rinkeby-testnet";
    /**
     * Arbitrum One - mainnet for Arbitrum roll-up
     *
     * - [Documentation](https://developer.offchainlabs.com/public-chains)
     */
    CustomChain["ArbitrumOne"] = "arbitrum-one";
    /**
     * xDai EVM sidechain with a native stable token
     *
     * - [Documentation](https://www.xdaichain.com/)
     */
    CustomChain["xDaiChain"] = "x-dai-chain";
    /**
     * Optimistic Kovan - testnet for Optimism roll-up
     *
     * - [Documentation](https://community.optimism.io/docs/developers/tutorials.html)
     */
    CustomChain["OptimisticKovan"] = "optimistic-kovan";
    /**
     * Optimistic Ethereum - mainnet for Optimism roll-up
     *
     * - [Documentation](https://community.optimism.io/docs/developers/tutorials.html)
     */
    CustomChain["OptimisticEthereum"] = "optimistic-ethereum";
})(CustomChain = exports.CustomChain || (exports.CustomChain = {}));

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\enums.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\arrowGlacier.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Chardforks%5CarrowGlacier.json
      return function (require, module, exports) {
module.exports={
    "name": "arrowGlacier",
    "comment": "HF to delay the difficulty bomb",
    "url": "https://github.com/ethereum/execution-specs/blob/master/network-upgrades/mainnet-upgrades/arrow-glacier.md",
    "status": "Final",
    "eips": [4345],
    "gasConfig": {},
    "gasPrices": {},
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\arrowGlacier.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\berlin.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Chardforks%5Cberlin.json
      return function (require, module, exports) {
module.exports={
    "name": "berlin",
    "comment": "HF targeted for July 2020 following the Muir Glacier HF",
    "url": "https://eips.ethereum.org/EIPS/eip-2070",
    "status": "Final",
    "eips": [2565, 2929, 2718, 2930]
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\berlin.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\byzantium.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Chardforks%5Cbyzantium.json
      return function (require, module, exports) {
module.exports={
    "name": "byzantium",
    "comment": "Hardfork with new precompiles, instructions and other protocol changes",
    "url": "https://eips.ethereum.org/EIPS/eip-609",
    "status": "Final",
    "gasConfig": {},
    "gasPrices": {
        "modexpGquaddivisor": {
            "v": 20,
            "d": "Gquaddivisor from modexp precompile for gas calculation"
        },
        "ecAdd": {
            "v": 500,
            "d": "Gas costs for curve addition precompile"
        },
        "ecMul": {
            "v": 40000,
            "d": "Gas costs for curve multiplication precompile"
        },
        "ecPairing": {
            "v": 100000,
            "d": "Base gas costs for curve pairing precompile"
        },
        "ecPairingWord": {
            "v": 80000,
            "d": "Gas costs regarding curve pairing precompile input length"
        },
        "revert": {
            "v": 0,
            "d": "Base fee of the REVERT opcode"
        },
        "staticcall": {
            "v": 700,
            "d": "Base fee of the STATICCALL opcode"
        },
        "returndatasize": {
            "v": 2,
            "d": "Base fee of the RETURNDATASIZE opcode"
        },
        "returndatacopy": {
            "v": 3,
            "d": "Base fee of the RETURNDATACOPY opcode"
        }
    },
    "vm": {},
    "pow": {
        "minerReward": {
            "v": "3000000000000000000",
            "d": "the amount a miner get rewarded for mining a block"
        },
        "difficultyBombDelay": {
            "v": 3000000,
            "d": "the amount of blocks to delay the difficulty bomb with"
        }
    }
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\byzantium.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\chainstart.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Chardforks%5Cchainstart.json
      return function (require, module, exports) {
module.exports={
    "name": "chainstart",
    "comment": "Start of the Ethereum main chain",
    "url": "",
    "status": "",
    "gasConfig": {
        "minGasLimit": {
            "v": 5000,
            "d": "Minimum the gas limit may ever be"
        },
        "gasLimitBoundDivisor": {
            "v": 1024,
            "d": "The bound divisor of the gas limit, used in update calculations"
        },
        "maxRefundQuotient": {
            "v": 2,
            "d": "Maximum refund quotient; max tx refund is min(tx.gasUsed/maxRefundQuotient, tx.gasRefund)"
        }
    },
    "gasPrices": {
        "base": {
            "v": 2,
            "d": "Gas base cost, used e.g. for ChainID opcode (Istanbul)"
        },
        "tierStep": {
            "v": [0, 2, 3, 5, 8, 10, 20],
            "d": "Once per operation, for a selection of them"
        },
        "exp": {
            "v": 10,
            "d": "Base fee of the EXP opcode"
        },
        "expByte": {
            "v": 10,
            "d": "Times ceil(log256(exponent)) for the EXP instruction"
        },
        "sha3": {
            "v": 30,
            "d": "Base fee of the SHA3 opcode"
        },
        "sha3Word": {
            "v": 6,
            "d": "Once per word of the SHA3 operation's data"
        },
        "sload": {
            "v": 50,
            "d": "Base fee of the SLOAD opcode"
        },
        "sstoreSet": {
            "v": 20000,
            "d": "Once per SSTORE operation if the zeroness changes from zero"
        },
        "sstoreReset": {
            "v": 5000,
            "d": "Once per SSTORE operation if the zeroness does not change from zero"
        },
        "sstoreRefund": {
            "v": 15000,
            "d": "Once per SSTORE operation if the zeroness changes to zero"
        },
        "jumpdest": {
            "v": 1,
            "d": "Base fee of the JUMPDEST opcode"
        },
        "log": {
            "v": 375,
            "d": "Base fee of the LOG opcode"
        },
        "logData": {
            "v": 8,
            "d": "Per byte in a LOG* operation's data"
        },
        "logTopic": {
            "v": 375,
            "d": "Multiplied by the * of the LOG*, per LOG transaction. e.g. LOG0 incurs 0 * c_txLogTopicGas, LOG4 incurs 4 * c_txLogTopicGas"
        },
        "create": {
            "v": 32000,
            "d": "Base fee of the CREATE opcode"
        },
        "call": {
            "v": 40,
            "d": "Base fee of the CALL opcode"
        },
        "callStipend": {
            "v": 2300,
            "d": "Free gas given at beginning of call"
        },
        "callValueTransfer": {
            "v": 9000,
            "d": "Paid for CALL when the value transfor is non-zero"
        },
        "callNewAccount": {
            "v": 25000,
            "d": "Paid for CALL when the destination address didn't exist prior"
        },
        "selfdestructRefund": {
            "v": 24000,
            "d": "Refunded following a selfdestruct operation"
        },
        "memory": {
            "v": 3,
            "d": "Times the address of the (highest referenced byte in memory + 1). NOTE: referencing happens on read, write and in instructions such as RETURN and CALL"
        },
        "quadCoeffDiv": {
            "v": 512,
            "d": "Divisor for the quadratic particle of the memory cost equation"
        },
        "createData": {
            "v": 200,
            "d": ""
        },
        "tx": {
            "v": 21000,
            "d": "Per transaction. NOTE: Not payable on data of calls between transactions"
        },
        "txCreation": {
            "v": 32000,
            "d": "The cost of creating a contract via tx"
        },
        "txDataZero": {
            "v": 4,
            "d": "Per byte of data attached to a transaction that equals zero. NOTE: Not payable on data of calls between transactions"
        },
        "txDataNonZero": {
            "v": 68,
            "d": "Per byte of data attached to a transaction that is not equal to zero. NOTE: Not payable on data of calls between transactions"
        },
        "copy": {
            "v": 3,
            "d": "Multiplied by the number of 32-byte words that are copied (round up) for any *COPY operation and added"
        },
        "ecRecover": {
            "v": 3000,
            "d": ""
        },
        "sha256": {
            "v": 60,
            "d": ""
        },
        "sha256Word": {
            "v": 12,
            "d": ""
        },
        "ripemd160": {
            "v": 600,
            "d": ""
        },
        "ripemd160Word": {
            "v": 120,
            "d": ""
        },
        "identity": {
            "v": 15,
            "d": ""
        },
        "identityWord": {
            "v": 3,
            "d": ""
        },
        "stop": {
            "v": 0,
            "d": "Base fee of the STOP opcode"
        },
        "add": {
            "v": 3,
            "d": "Base fee of the ADD opcode"
        },
        "mul": {
            "v": 5,
            "d": "Base fee of the MUL opcode"
        },
        "sub": {
            "v": 3,
            "d": "Base fee of the SUB opcode"
        },
        "div": {
            "v": 5,
            "d": "Base fee of the DIV opcode"
        },
        "sdiv": {
            "v": 5,
            "d": "Base fee of the SDIV opcode"
        },
        "mod": {
            "v": 5,
            "d": "Base fee of the MOD opcode"
        },
        "smod": {
            "v": 5,
            "d": "Base fee of the SMOD opcode"
        },
        "addmod": {
            "v": 8,
            "d": "Base fee of the ADDMOD opcode"
        },
        "mulmod": {
            "v": 8,
            "d": "Base fee of the MULMOD opcode"
        },
        "signextend": {
            "v": 5,
            "d": "Base fee of the SIGNEXTEND opcode"
        },
        "lt": {
            "v": 3,
            "d": "Base fee of the LT opcode"
        },
        "gt": {
            "v": 3,
            "d": "Base fee of the GT opcode"
        },
        "slt": {
            "v": 3,
            "d": "Base fee of the SLT opcode"
        },
        "sgt": {
            "v": 3,
            "d": "Base fee of the SGT opcode"
        },
        "eq": {
            "v": 3,
            "d": "Base fee of the EQ opcode"
        },
        "iszero": {
            "v": 3,
            "d": "Base fee of the ISZERO opcode"
        },
        "and": {
            "v": 3,
            "d": "Base fee of the AND opcode"
        },
        "or": {
            "v": 3,
            "d": "Base fee of the OR opcode"
        },
        "xor": {
            "v": 3,
            "d": "Base fee of the XOR opcode"
        },
        "not": {
            "v": 3,
            "d": "Base fee of the NOT opcode"
        },
        "byte": {
            "v": 3,
            "d": "Base fee of the BYTE opcode"
        },
        "address": {
            "v": 2,
            "d": "Base fee of the ADDRESS opcode"
        },
        "balance": {
            "v": 20,
            "d": "Base fee of the BALANCE opcode"
        },
        "origin": {
            "v": 2,
            "d": "Base fee of the ORIGIN opcode"
        },
        "caller": {
            "v": 2,
            "d": "Base fee of the CALLER opcode"
        },
        "callvalue": {
            "v": 2,
            "d": "Base fee of the CALLVALUE opcode"
        },
        "calldataload": {
            "v": 3,
            "d": "Base fee of the CALLDATALOAD opcode"
        },
        "calldatasize": {
            "v": 2,
            "d": "Base fee of the CALLDATASIZE opcode"
        },
        "calldatacopy": {
            "v": 3,
            "d": "Base fee of the CALLDATACOPY opcode"
        },
        "codesize": {
            "v": 2,
            "d": "Base fee of the CODESIZE opcode"
        },
        "codecopy": {
            "v": 3,
            "d": "Base fee of the CODECOPY opcode"
        },
        "gasprice": {
            "v": 2,
            "d": "Base fee of the GASPRICE opcode"
        },
        "extcodesize": {
            "v": 20,
            "d": "Base fee of the EXTCODESIZE opcode"
        },
        "extcodecopy": {
            "v": 20,
            "d": "Base fee of the EXTCODECOPY opcode"
        },
        "blockhash": {
            "v": 20,
            "d": "Base fee of the BLOCKHASH opcode"
        },
        "coinbase": {
            "v": 2,
            "d": "Base fee of the COINBASE opcode"
        },
        "timestamp": {
            "v": 2,
            "d": "Base fee of the TIMESTAMP opcode"
        },
        "number": {
            "v": 2,
            "d": "Base fee of the NUMBER opcode"
        },
        "difficulty": {
            "v": 2,
            "d": "Base fee of the DIFFICULTY opcode"
        },
        "gaslimit": {
            "v": 2,
            "d": "Base fee of the GASLIMIT opcode"
        },
        "pop": {
            "v": 2,
            "d": "Base fee of the POP opcode"
        },
        "mload": {
            "v": 3,
            "d": "Base fee of the MLOAD opcode"
        },
        "mstore": {
            "v": 3,
            "d": "Base fee of the MSTORE opcode"
        },
        "mstore8": {
            "v": 3,
            "d": "Base fee of the MSTORE8 opcode"
        },
        "sstore": {
            "v": 0,
            "d": "Base fee of the SSTORE opcode"
        },
        "jump": {
            "v": 8,
            "d": "Base fee of the JUMP opcode"
        },
        "jumpi": {
            "v": 10,
            "d": "Base fee of the JUMPI opcode"
        },
        "pc": {
            "v": 2,
            "d": "Base fee of the PC opcode"
        },
        "msize": {
            "v": 2,
            "d": "Base fee of the MSIZE opcode"
        },
        "gas": {
            "v": 2,
            "d": "Base fee of the GAS opcode"
        },
        "push": {
            "v": 3,
            "d": "Base fee of the PUSH opcode"
        },
        "dup": {
            "v": 3,
            "d": "Base fee of the DUP opcode"
        },
        "swap": {
            "v": 3,
            "d": "Base fee of the SWAP opcode"
        },
        "callcode": {
            "v": 40,
            "d": "Base fee of the CALLCODE opcode"
        },
        "return": {
            "v": 0,
            "d": "Base fee of the RETURN opcode"
        },
        "invalid": {
            "v": 0,
            "d": "Base fee of the INVALID opcode"
        },
        "selfdestruct": {
            "v": 0,
            "d": "Base fee of the SELFDESTRUCT opcode"
        }
    },
    "vm": {
        "stackLimit": {
            "v": 1024,
            "d": "Maximum size of VM stack allowed"
        },
        "callCreateDepth": {
            "v": 1024,
            "d": "Maximum depth of call/create stack"
        },
        "maxExtraDataSize": {
            "v": 32,
            "d": "Maximum size extra data may be after Genesis"
        }
    },
    "pow": {
        "minimumDifficulty": {
            "v": 131072,
            "d": "The minimum that the difficulty may ever be"
        },
        "difficultyBoundDivisor": {
            "v": 2048,
            "d": "The bound divisor of the difficulty, used in the update calculations"
        },
        "durationLimit": {
            "v": 13,
            "d": "The decision boundary on the blocktime duration used to determine whether difficulty should go up or not"
        },
        "epochDuration": {
            "v": 30000,
            "d": "Duration between proof-of-work epochs"
        },
        "timebombPeriod": {
            "v": 100000,
            "d": "Exponential difficulty timebomb period"
        },
        "minerReward": {
            "v": "5000000000000000000",
            "d": "the amount a miner get rewarded for mining a block"
        },
        "difficultyBombDelay": {
            "v": 0,
            "d": "the amount of blocks to delay the difficulty bomb with"
        }
    }
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\chainstart.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\constantinople.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Chardforks%5Cconstantinople.json
      return function (require, module, exports) {
module.exports={
    "name": "constantinople",
    "comment": "Postponed hardfork including EIP-1283 (SSTORE gas metering changes)",
    "url": "https://eips.ethereum.org/EIPS/eip-1013",
    "status": "Final",
    "gasConfig": {},
    "gasPrices": {
        "netSstoreNoopGas": {
            "v": 200,
            "d": "Once per SSTORE operation if the value doesn't change"
        },
        "netSstoreInitGas": {
            "v": 20000,
            "d": "Once per SSTORE operation from clean zero"
        },
        "netSstoreCleanGas": {
            "v": 5000,
            "d": "Once per SSTORE operation from clean non-zero"
        },
        "netSstoreDirtyGas": {
            "v": 200,
            "d": "Once per SSTORE operation from dirty"
        },
        "netSstoreClearRefund": {
            "v": 15000,
            "d": "Once per SSTORE operation for clearing an originally existing storage slot"
        },
        "netSstoreResetRefund": {
            "v": 4800,
            "d": "Once per SSTORE operation for resetting to the original non-zero value"
        },
        "netSstoreResetClearRefund": {
            "v": 19800,
            "d": "Once per SSTORE operation for resetting to the original zero value"
        },
        "shl": {
            "v": 3,
            "d": "Base fee of the SHL opcode"
        },
        "shr": {
            "v": 3,
            "d": "Base fee of the SHR opcode"
        },
        "sar": {
            "v": 3,
            "d": "Base fee of the SAR opcode"
        },
        "extcodehash": {
            "v": 400,
            "d": "Base fee of the EXTCODEHASH opcode"
        },
        "create2": {
            "v": 32000,
            "d": "Base fee of the CREATE2 opcode"
        }
    },
    "vm": {},
    "pow": {
        "minerReward": {
            "v": "2000000000000000000",
            "d": "The amount a miner gets rewarded for mining a block"
        },
        "difficultyBombDelay": {
            "v": 5000000,
            "d": "the amount of blocks to delay the difficulty bomb with"
        }
    }
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\constantinople.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\dao.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Chardforks%5Cdao.json
      return function (require, module, exports) {
module.exports={
    "name": "dao",
    "comment": "DAO rescue hardfork",
    "url": "https://eips.ethereum.org/EIPS/eip-779",
    "status": "Final",
    "gasConfig": {},
    "gasPrices": {},
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\dao.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\grayGlacier.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Chardforks%5CgrayGlacier.json
      return function (require, module, exports) {
module.exports={
    "name": "grayGlacier",
    "comment": "Delaying the difficulty bomb to Mid September 2022",
    "url": "https://github.com/ethereum/execution-specs/blob/master/network-upgrades/mainnet-upgrades/gray-glacier.md",
    "status": "Draft",
    "eips": [5133],
    "gasConfig": {},
    "gasPrices": {},
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\grayGlacier.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\homestead.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Chardforks%5Chomestead.json
      return function (require, module, exports) {
module.exports={
    "name": "homestead",
    "comment": "Homestead hardfork with protocol and network changes",
    "url": "https://eips.ethereum.org/EIPS/eip-606",
    "status": "Final",
    "gasConfig": {},
    "gasPrices": {
        "delegatecall": {
            "v": 40,
            "d": "Base fee of the DELEGATECALL opcode"
        }
    },
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\homestead.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\index.js", {"./arrowGlacier.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\arrowGlacier.json","./berlin.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\berlin.json","./byzantium.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\byzantium.json","./chainstart.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\chainstart.json","./constantinople.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\constantinople.json","./dao.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\dao.json","./grayGlacier.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\grayGlacier.json","./homestead.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\homestead.json","./istanbul.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\istanbul.json","./london.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\london.json","./merge.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\merge.json","./mergeForkIdTransition.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\mergeForkIdTransition.json","./muirGlacier.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\muirGlacier.json","./petersburg.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\petersburg.json","./shanghai.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\shanghai.json","./sharding.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\sharding.json","./spuriousDragon.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\spuriousDragon.json","./tangerineWhistle.json":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\tangerineWhistle.json"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Chardforks%5Cindex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hardforks = void 0;
exports.hardforks = {
    chainstart: require('./chainstart.json'),
    homestead: require('./homestead.json'),
    dao: require('./dao.json'),
    tangerineWhistle: require('./tangerineWhistle.json'),
    spuriousDragon: require('./spuriousDragon.json'),
    byzantium: require('./byzantium.json'),
    constantinople: require('./constantinople.json'),
    petersburg: require('./petersburg.json'),
    istanbul: require('./istanbul.json'),
    muirGlacier: require('./muirGlacier.json'),
    berlin: require('./berlin.json'),
    london: require('./london.json'),
    shanghai: require('./shanghai.json'),
    arrowGlacier: require('./arrowGlacier.json'),
    grayGlacier: require('./grayGlacier.json'),
    mergeForkIdTransition: require('./mergeForkIdTransition.json'),
    merge: require('./merge.json'),
    shardingFork: require('./sharding.json'),
};

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\istanbul.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Chardforks%5Cistanbul.json
      return function (require, module, exports) {
module.exports={
    "name": "istanbul",
    "comment": "HF targeted for December 2019 following the Constantinople/Petersburg HF",
    "url": "https://eips.ethereum.org/EIPS/eip-1679",
    "status": "Final",
    "gasConfig": {},
    "gasPrices": {
        "blake2Round": {
            "v": 1,
            "d": "Gas cost per round for the Blake2 F precompile"
        },
        "ecAdd": {
            "v": 150,
            "d": "Gas costs for curve addition precompile"
        },
        "ecMul": {
            "v": 6000,
            "d": "Gas costs for curve multiplication precompile"
        },
        "ecPairing": {
            "v": 45000,
            "d": "Base gas costs for curve pairing precompile"
        },
        "ecPairingWord": {
            "v": 34000,
            "d": "Gas costs regarding curve pairing precompile input length"
        },
        "txDataNonZero": {
            "v": 16,
            "d": "Per byte of data attached to a transaction that is not equal to zero. NOTE: Not payable on data of calls between transactions"
        },
        "sstoreSentryGasEIP2200": {
            "v": 2300,
            "d": "Minimum gas required to be present for an SSTORE call, not consumed"
        },
        "sstoreNoopGasEIP2200": {
            "v": 800,
            "d": "Once per SSTORE operation if the value doesn't change"
        },
        "sstoreDirtyGasEIP2200": {
            "v": 800,
            "d": "Once per SSTORE operation if a dirty value is changed"
        },
        "sstoreInitGasEIP2200": {
            "v": 20000,
            "d": "Once per SSTORE operation from clean zero to non-zero"
        },
        "sstoreInitRefundEIP2200": {
            "v": 19200,
            "d": "Once per SSTORE operation for resetting to the original zero value"
        },
        "sstoreCleanGasEIP2200": {
            "v": 5000,
            "d": "Once per SSTORE operation from clean non-zero to something else"
        },
        "sstoreCleanRefundEIP2200": {
            "v": 4200,
            "d": "Once per SSTORE operation for resetting to the original non-zero value"
        },
        "sstoreClearRefundEIP2200": {
            "v": 15000,
            "d": "Once per SSTORE operation for clearing an originally existing storage slot"
        },
        "balance": {
            "v": 700,
            "d": "Base fee of the BALANCE opcode"
        },
        "extcodehash": {
            "v": 700,
            "d": "Base fee of the EXTCODEHASH opcode"
        },
        "chainid": {
            "v": 2,
            "d": "Base fee of the CHAINID opcode"
        },
        "selfbalance": {
            "v": 5,
            "d": "Base fee of the SELFBALANCE opcode"
        },
        "sload": {
            "v": 800,
            "d": "Base fee of the SLOAD opcode"
        }
    },
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\istanbul.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\london.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Chardforks%5Clondon.json
      return function (require, module, exports) {
module.exports={
    "name": "london",
    "comment": "HF targeted for July 2021 following the Berlin fork",
    "url": "https://github.com/ethereum/eth1.0-specs/blob/master/network-upgrades/mainnet-upgrades/london.md",
    "status": "Final",
    "eips": [1559, 3198, 3529, 3541]
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\london.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\merge.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Chardforks%5Cmerge.json
      return function (require, module, exports) {
module.exports={
    "name": "merge",
    "comment": "Hardfork to upgrade the consensus mechanism to Proof-of-Stake",
    "url": "https://github.com/ethereum/execution-specs/blob/master/network-upgrades/mainnet-upgrades/merge.md",
    "status": "Final",
    "consensus": {
        "type": "pos",
        "algorithm": "casper",
        "casper": {}
    },
    "eips": [3675, 4399]
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\merge.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\mergeForkIdTransition.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Chardforks%5CmergeForkIdTransition.json
      return function (require, module, exports) {
module.exports={
    "name": "mergeForkIdTransition",
    "comment": "Pre-merge hardfork to fork off non-upgraded clients",
    "url": "https://eips.ethereum.org/EIPS/eip-3675",
    "status": "Draft",
    "eips": []
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\mergeForkIdTransition.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\muirGlacier.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Chardforks%5CmuirGlacier.json
      return function (require, module, exports) {
module.exports={
    "name": "muirGlacier",
    "comment": "HF to delay the difficulty bomb",
    "url": "https://eips.ethereum.org/EIPS/eip-2384",
    "status": "Final",
    "gasConfig": {},
    "gasPrices": {},
    "vm": {},
    "pow": {
        "difficultyBombDelay": {
            "v": 9000000,
            "d": "the amount of blocks to delay the difficulty bomb with"
        }
    }
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\muirGlacier.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\petersburg.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Chardforks%5Cpetersburg.json
      return function (require, module, exports) {
module.exports={
    "name": "petersburg",
    "comment": "Aka constantinopleFix, removes EIP-1283, activate together with or after constantinople",
    "url": "https://eips.ethereum.org/EIPS/eip-1716",
    "status": "Final",
    "gasConfig": {},
    "gasPrices": {
        "netSstoreNoopGas": {
            "v": null,
            "d": "Removed along EIP-1283"
        },
        "netSstoreInitGas": {
            "v": null,
            "d": "Removed along EIP-1283"
        },
        "netSstoreCleanGas": {
            "v": null,
            "d": "Removed along EIP-1283"
        },
        "netSstoreDirtyGas": {
            "v": null,
            "d": "Removed along EIP-1283"
        },
        "netSstoreClearRefund": {
            "v": null,
            "d": "Removed along EIP-1283"
        },
        "netSstoreResetRefund": {
            "v": null,
            "d": "Removed along EIP-1283"
        },
        "netSstoreResetClearRefund": {
            "v": null,
            "d": "Removed along EIP-1283"
        }
    },
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\petersburg.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\shanghai.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Chardforks%5Cshanghai.json
      return function (require, module, exports) {
module.exports={
    "name": "shanghai",
    "comment": "Next feature hardfork after the merge hardfork having withdrawals, warm coinbase, push0, limit/meter initcode",
    "url": "https://github.com/ethereum/execution-specs/blob/master/network-upgrades/mainnet-upgrades/shanghai.md",
    "status": "Final",
    "eips": [3651, 3855, 3860, 4895]
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\shanghai.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\sharding.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Chardforks%5Csharding.json
      return function (require, module, exports) {
module.exports={
    "name": "shardingFork",
    "comment": "Internal hardfork to test proto-danksharding (do not use in production)",
    "url": "https://eips.ethereum.org/EIPS/eip-4844",
    "status": "Experimental",
    "eips": [4844]
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\sharding.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\spuriousDragon.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Chardforks%5CspuriousDragon.json
      return function (require, module, exports) {
module.exports={
    "name": "spuriousDragon",
    "comment": "HF with EIPs for simple replay attack protection, EXP cost increase, state trie clearing, contract code size limit",
    "url": "https://eips.ethereum.org/EIPS/eip-607",
    "status": "Final",
    "gasConfig": {},
    "gasPrices": {
        "expByte": {
            "v": 50,
            "d": "Times ceil(log256(exponent)) for the EXP instruction"
        }
    },
    "vm": {
        "maxCodeSize": {
            "v": 24576,
            "d": "Maximum length of contract code"
        }
    },
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\spuriousDragon.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\tangerineWhistle.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Chardforks%5CtangerineWhistle.json
      return function (require, module, exports) {
module.exports={
    "name": "tangerineWhistle",
    "comment": "Hardfork with gas cost changes for IO-heavy operations",
    "url": "https://eips.ethereum.org/EIPS/eip-608",
    "status": "Final",
    "gasConfig": {},
    "gasPrices": {
        "sload": {
            "v": 200,
            "d": "Once per SLOAD operation"
        },
        "call": {
            "v": 700,
            "d": "Once per CALL operation & message call transaction"
        },
        "extcodesize": {
            "v": 700,
            "d": "Base fee of the EXTCODESIZE opcode"
        },
        "extcodecopy": {
            "v": 700,
            "d": "Base fee of the EXTCODECOPY opcode"
        },
        "balance": {
            "v": 400,
            "d": "Base fee of the BALANCE opcode"
        },
        "delegatecall": {
            "v": 700,
            "d": "Base fee of the DELEGATECALL opcode"
        },
        "callcode": {
            "v": 700,
            "d": "Base fee of the CALLCODE opcode"
        },
        "selfdestruct": {
            "v": 5000,
            "d": "Base fee of the SELFDESTRUCT opcode"
        }
    },
    "vm": {},
    "pow": {}
}

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\hardforks\\tangerineWhistle.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\index.js", {"./common":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\common.js","./enums":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\enums.js","./types":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\types.js","./utils":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\utils.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Cindex.js
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./common"), exports);
__exportStar(require("./enums"), exports);
__exportStar(require("./types"), exports);
__exportStar(require("./utils"), exports);

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\types.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Ctypes.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\types.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\utils.js", {"./enums":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\enums.js","@ethereumjs/util":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Ccommon%5Cdist%5Cutils.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseGethGenesis = void 0;
const util_1 = require("@ethereumjs/util");
const enums_1 = require("./enums");
/**
 * Transforms Geth formatted nonce (i.e. hex string) to 8 byte 0x-prefixed string used internally
 * @param nonce string parsed from the Geth genesis file
 * @returns nonce as a 0x-prefixed 8 byte string
 */
function formatNonce(nonce) {
    if (!nonce || nonce === '0x0') {
        return '0x0000000000000000';
    }
    if ((0, util_1.isHexPrefixed)(nonce)) {
        return '0x' + (0, util_1.stripHexPrefix)(nonce).padStart(16, '0');
    }
    return '0x' + nonce.padStart(16, '0');
}
/**
 * Converts Geth genesis parameters to an EthereumJS compatible `CommonOpts` object
 * @param json object representing the Geth genesis file
 * @param optional mergeForkIdPostMerge which clarifies the placement of MergeForkIdTransition
 * hardfork, which by default is post merge as with the merged eth networks but could also come
 * before merge like in kiln genesis
 * @returns genesis parameters in a `CommonOpts` compliant object
 */
function parseGethParams(json, mergeForkIdPostMerge = true) {
    const { name, config, difficulty, mixHash, gasLimit, coinbase, baseFeePerGas, } = json;
    let { extraData, timestamp, nonce } = json;
    const genesisTimestamp = Number(timestamp);
    const { chainId } = config;
    // geth is not strictly putting empty fields with a 0x prefix
    if (extraData === '') {
        extraData = '0x';
    }
    // geth may use number for timestamp
    if (!(0, util_1.isHexPrefixed)(timestamp)) {
        timestamp = (0, util_1.intToHex)(parseInt(timestamp));
    }
    // geth may not give us a nonce strictly formatted to an 8 byte hex string
    if (nonce.length !== 18) {
        nonce = formatNonce(nonce);
    }
    // EIP155 and EIP158 are both part of Spurious Dragon hardfork and must occur at the same time
    // but have different configuration parameters in geth genesis parameters
    if (config.eip155Block !== config.eip158Block) {
        throw new Error('EIP155 block number must equal EIP 158 block number since both are part of SpuriousDragon hardfork and the client only supports activating the full hardfork');
    }
    const params = {
        name,
        chainId,
        networkId: chainId,
        genesis: {
            timestamp,
            gasLimit: parseInt(gasLimit),
            difficulty: parseInt(difficulty),
            nonce,
            extraData,
            mixHash,
            coinbase,
            baseFeePerGas,
        },
        hardfork: undefined,
        hardforks: [],
        bootstrapNodes: [],
        consensus: config.clique !== undefined
            ? {
                type: 'poa',
                algorithm: 'clique',
                clique: {
                    // The recent geth genesis seems to be using blockperiodseconds
                    // and epochlength for clique specification
                    // see: https://hackmd.io/PqZgMpnkSWCWv5joJoFymQ
                    period: config.clique.period ?? config.clique.blockperiodseconds,
                    epoch: config.clique.epoch ?? config.clique.epochlength,
                },
            }
            : {
                type: 'pow',
                algorithm: 'ethash',
                ethash: {},
            },
    };
    const forkMap = {
        [enums_1.Hardfork.Homestead]: { name: 'homesteadBlock' },
        [enums_1.Hardfork.Dao]: { name: 'daoForkBlock' },
        [enums_1.Hardfork.TangerineWhistle]: { name: 'eip150Block' },
        [enums_1.Hardfork.SpuriousDragon]: { name: 'eip155Block' },
        [enums_1.Hardfork.Byzantium]: { name: 'byzantiumBlock' },
        [enums_1.Hardfork.Constantinople]: { name: 'constantinopleBlock' },
        [enums_1.Hardfork.Petersburg]: { name: 'petersburgBlock' },
        [enums_1.Hardfork.Istanbul]: { name: 'istanbulBlock' },
        [enums_1.Hardfork.MuirGlacier]: { name: 'muirGlacierBlock' },
        [enums_1.Hardfork.Berlin]: { name: 'berlinBlock' },
        [enums_1.Hardfork.London]: { name: 'londonBlock' },
        [enums_1.Hardfork.MergeForkIdTransition]: { name: 'mergeForkBlock', postMerge: mergeForkIdPostMerge },
        [enums_1.Hardfork.Shanghai]: { name: 'shanghaiTime', postMerge: true, isTimestamp: true },
        [enums_1.Hardfork.ShardingForkDev]: { name: 'shardingForkTime', postMerge: true, isTimestamp: true },
    };
    // forkMapRev is the map from config field name to Hardfork
    const forkMapRev = Object.keys(forkMap).reduce((acc, elem) => {
        acc[forkMap[elem].name] = elem;
        return acc;
    }, {});
    const configHardforkNames = Object.keys(config).filter((key) => forkMapRev[key] !== undefined && config[key] !== undefined && config[key] !== null);
    params.hardforks = configHardforkNames
        .map((nameBlock) => ({
        name: forkMapRev[nameBlock],
        block: forkMap[forkMapRev[nameBlock]].isTimestamp === true || typeof config[nameBlock] !== 'number'
            ? null
            : config[nameBlock],
        timestamp: forkMap[forkMapRev[nameBlock]].isTimestamp === true && typeof config[nameBlock] === 'number'
            ? config[nameBlock]
            : undefined,
    }))
        .filter((fork) => fork.block !== null || fork.timestamp !== undefined);
    params.hardforks.sort(function (a, b) {
        return (a.block ?? Infinity) - (b.block ?? Infinity);
    });
    params.hardforks.sort(function (a, b) {
        return (a.timestamp ?? genesisTimestamp) - (b.timestamp ?? genesisTimestamp);
    });
    if (config.terminalTotalDifficulty !== undefined) {
        // Following points need to be considered for placement of merge hf
        // - Merge hardfork can't be placed at genesis
        // - Place merge hf before any hardforks that require CL participation for e.g. withdrawals
        // - Merge hardfork has to be placed just after genesis if any of the genesis hardforks make CL
        //   necessary for e.g. withdrawals
        const mergeConfig = {
            name: enums_1.Hardfork.Merge,
            ttd: config.terminalTotalDifficulty,
            block: null,
        };
        // Merge hardfork has to be placed before first hardfork that is dependent on merge
        const postMergeIndex = params.hardforks.findIndex((hf) => forkMap[hf.name]?.postMerge === true);
        if (postMergeIndex !== -1) {
            params.hardforks.splice(postMergeIndex, 0, mergeConfig);
        }
        else {
            params.hardforks.push(mergeConfig);
        }
    }
    const latestHardfork = params.hardforks.length > 0 ? params.hardforks.slice(-1)[0] : undefined;
    params.hardfork = latestHardfork?.name;
    params.hardforks.unshift({ name: enums_1.Hardfork.Chainstart, block: 0 });
    return params;
}
/**
 * Parses a genesis.json exported from Geth into parameters for Common instance
 * @param json representing the Geth genesis file
 * @param name optional chain name
 * @returns parsed params
 */
function parseGethGenesis(json, name, mergeForkIdPostMerge) {
    try {
        if (['config', 'difficulty', 'gasLimit', 'alloc'].some((field) => !(field in json))) {
            throw new Error('Invalid format, expected geth genesis fields missing');
        }
        if (name !== undefined) {
            json.name = name;
        }
        return parseGethParams(json, mergeForkIdPostMerge);
    }
    catch (e) {
        throw new Error(`Error parsing parameters file: ${e.message}`);
    }
}
exports.parseGethGenesis = parseGethGenesis;

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\common\\dist\\utils.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\rlp\\dist\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Crlp%5Cdist%5Cindex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RLP = exports.utils = exports.decode = exports.encode = void 0;
/**
 * RLP Encoding based on https://ethereum.org/en/developers/docs/data-structures-and-encoding/rlp/
 * This function takes in data, converts it to Uint8Array if not,
 * and adds a length for recursion.
 * @param input Will be converted to Uint8Array
 * @returns Uint8Array of encoded data
 **/
function encode(input) {
    if (Array.isArray(input)) {
        const output = [];
        let outputLength = 0;
        for (let i = 0; i < input.length; i++) {
            const encoded = encode(input[i]);
            output.push(encoded);
            outputLength += encoded.length;
        }
        return concatBytes(encodeLength(outputLength, 192), ...output);
    }
    const inputBuf = toBytes(input);
    if (inputBuf.length === 1 && inputBuf[0] < 128) {
        return inputBuf;
    }
    return concatBytes(encodeLength(inputBuf.length, 128), inputBuf);
}
exports.encode = encode;
/**
 * Slices a Uint8Array, throws if the slice goes out-of-bounds of the Uint8Array.
 * E.g. `safeSlice(hexToBytes('aa'), 1, 2)` will throw.
 * @param input
 * @param start
 * @param end
 */
function safeSlice(input, start, end) {
    if (end > input.length) {
        throw new Error('invalid RLP (safeSlice): end slice of Uint8Array out-of-bounds');
    }
    return input.slice(start, end);
}
/**
 * Parse integers. Check if there is no leading zeros
 * @param v The value to parse
 */
function decodeLength(v) {
    if (v[0] === 0) {
        throw new Error('invalid RLP: extra zeros');
    }
    return parseHexByte(bytesToHex(v));
}
function encodeLength(len, offset) {
    if (len < 56) {
        return Uint8Array.from([len + offset]);
    }
    const hexLength = numberToHex(len);
    const lLength = hexLength.length / 2;
    const firstByte = numberToHex(offset + 55 + lLength);
    return Uint8Array.from(hexToBytes(firstByte + hexLength));
}
function decode(input, stream = false) {
    if (typeof input === 'undefined' || input === null || input.length === 0) {
        return Uint8Array.from([]);
    }
    const inputBytes = toBytes(input);
    const decoded = _decode(inputBytes);
    if (stream) {
        return decoded;
    }
    if (decoded.remainder.length !== 0) {
        throw new Error('invalid RLP: remainder must be zero');
    }
    return decoded.data;
}
exports.decode = decode;
/** Decode an input with RLP */
function _decode(input) {
    let length, llength, data, innerRemainder, d;
    const decoded = [];
    const firstByte = input[0];
    if (firstByte <= 0x7f) {
        // a single byte whose value is in the [0x00, 0x7f] range, that byte is its own RLP encoding.
        return {
            data: input.slice(0, 1),
            remainder: input.slice(1),
        };
    }
    else if (firstByte <= 0xb7) {
        // string is 0-55 bytes long. A single byte with value 0x80 plus the length of the string followed by the string
        // The range of the first byte is [0x80, 0xb7]
        length = firstByte - 0x7f;
        // set 0x80 null to 0
        if (firstByte === 0x80) {
            data = Uint8Array.from([]);
        }
        else {
            data = safeSlice(input, 1, length);
        }
        if (length === 2 && data[0] < 0x80) {
            throw new Error('invalid RLP encoding: invalid prefix, single byte < 0x80 are not prefixed');
        }
        return {
            data,
            remainder: input.slice(length),
        };
    }
    else if (firstByte <= 0xbf) {
        // string is greater than 55 bytes long. A single byte with the value (0xb7 plus the length of the length),
        // followed by the length, followed by the string
        llength = firstByte - 0xb6;
        if (input.length - 1 < llength) {
            throw new Error('invalid RLP: not enough bytes for string length');
        }
        length = decodeLength(safeSlice(input, 1, llength));
        if (length <= 55) {
            throw new Error('invalid RLP: expected string length to be greater than 55');
        }
        data = safeSlice(input, llength, length + llength);
        return {
            data,
            remainder: input.slice(length + llength),
        };
    }
    else if (firstByte <= 0xf7) {
        // a list between 0-55 bytes long
        length = firstByte - 0xbf;
        innerRemainder = safeSlice(input, 1, length);
        while (innerRemainder.length) {
            d = _decode(innerRemainder);
            decoded.push(d.data);
            innerRemainder = d.remainder;
        }
        return {
            data: decoded,
            remainder: input.slice(length),
        };
    }
    else {
        // a list over 55 bytes long
        llength = firstByte - 0xf6;
        length = decodeLength(safeSlice(input, 1, llength));
        if (length < 56) {
            throw new Error('invalid RLP: encoded list too short');
        }
        const totalLength = llength + length;
        if (totalLength > input.length) {
            throw new Error('invalid RLP: total length is larger than the data');
        }
        innerRemainder = safeSlice(input, llength, totalLength);
        while (innerRemainder.length) {
            d = _decode(innerRemainder);
            decoded.push(d.data);
            innerRemainder = d.remainder;
        }
        return {
            data: decoded,
            remainder: input.slice(totalLength),
        };
    }
}
const cachedHexes = Array.from({ length: 256 }, (_v, i) => i.toString(16).padStart(2, '0'));
function bytesToHex(uint8a) {
    // Pre-caching chars with `cachedHexes` speeds this up 6x
    let hex = '';
    for (let i = 0; i < uint8a.length; i++) {
        hex += cachedHexes[uint8a[i]];
    }
    return hex;
}
function parseHexByte(hexByte) {
    const byte = Number.parseInt(hexByte, 16);
    if (Number.isNaN(byte))
        throw new Error('Invalid byte sequence');
    return byte;
}
// Caching slows it down 2-3x
function hexToBytes(hex) {
    if (typeof hex !== 'string') {
        throw new TypeError('hexToBytes: expected string, got ' + typeof hex);
    }
    if (hex.length % 2)
        throw new Error('hexToBytes: received invalid unpadded hex');
    const array = new Uint8Array(hex.length / 2);
    for (let i = 0; i < array.length; i++) {
        const j = i * 2;
        array[i] = parseHexByte(hex.slice(j, j + 2));
    }
    return array;
}
/** Concatenates two Uint8Arrays into one. */
function concatBytes(...arrays) {
    if (arrays.length === 1)
        return arrays[0];
    const length = arrays.reduce((a, arr) => a + arr.length, 0);
    const result = new Uint8Array(length);
    for (let i = 0, pad = 0; i < arrays.length; i++) {
        const arr = arrays[i];
        result.set(arr, pad);
        pad += arr.length;
    }
    return result;
}
function utf8ToBytes(utf) {
    return new TextEncoder().encode(utf);
}
/** Transform an integer into its hexadecimal value */
function numberToHex(integer) {
    if (integer < 0) {
        throw new Error('Invalid integer as argument, must be unsigned!');
    }
    const hex = integer.toString(16);
    return hex.length % 2 ? `0${hex}` : hex;
}
/** Pad a string to be even */
function padToEven(a) {
    return a.length % 2 ? `0${a}` : a;
}
/** Check if a string is prefixed by 0x */
function isHexPrefixed(str) {
    return str.length >= 2 && str[0] === '0' && str[1] === 'x';
}
/** Removes 0x from a given String */
function stripHexPrefix(str) {
    if (typeof str !== 'string') {
        return str;
    }
    return isHexPrefixed(str) ? str.slice(2) : str;
}
/** Transform anything into a Uint8Array */
function toBytes(v) {
    if (v instanceof Uint8Array) {
        return v;
    }
    if (typeof v === 'string') {
        if (isHexPrefixed(v)) {
            return hexToBytes(padToEven(stripHexPrefix(v)));
        }
        return utf8ToBytes(v);
    }
    if (typeof v === 'number' || typeof v === 'bigint') {
        if (!v) {
            return Uint8Array.from([]);
        }
        return hexToBytes(numberToHex(v));
    }
    if (v === null || v === undefined) {
        return Uint8Array.from([]);
    }
    throw new Error('toBytes: received unsupported type ' + typeof v);
}
exports.utils = {
    bytesToHex,
    concatBytes,
    hexToBytes,
    utf8ToBytes,
};
exports.RLP = { encode, decode };

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util>@ethereumjs/rlp",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\rlp\\dist\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\account.js", {"./bytes":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\bytes.js","./constants":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\constants.js","./helpers":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\helpers.js","./internal":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\internal.js","@ethereumjs/rlp":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\rlp\\dist\\index.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js","ethereum-cryptography/keccak":"D:\\code\\v\\metamask-extension\\node_modules\\ethereum-cryptography\\keccak.js","ethereum-cryptography/secp256k1":"D:\\code\\v\\metamask-extension\\node_modules\\ethereum-cryptography\\secp256k1.js","ethereum-cryptography/utils":"D:\\code\\v\\metamask-extension\\node_modules\\ethereum-cryptography\\utils.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Cutil%5Cdist%5Caccount.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.accountBodyToRLP = exports.accountBodyToSlim = exports.accountBodyFromSlim = exports.isZeroAddress = exports.zeroAddress = exports.importPublic = exports.privateToAddress = exports.privateToPublic = exports.publicToAddress = exports.pubToAddress = exports.isValidPublic = exports.isValidPrivate = exports.generateAddress2 = exports.generateAddress = exports.isValidChecksumAddress = exports.toChecksumAddress = exports.isValidAddress = exports.Account = void 0;
const rlp_1 = require("@ethereumjs/rlp");
const keccak_1 = require("ethereum-cryptography/keccak");
const secp256k1_1 = require("ethereum-cryptography/secp256k1");
const utils_1 = require("ethereum-cryptography/utils");
const bytes_1 = require("./bytes");
const constants_1 = require("./constants");
const helpers_1 = require("./helpers");
const internal_1 = require("./internal");
const _0n = BigInt(0);
class Account {
    /**
     * This constructor assigns and validates the values.
     * Use the static factory methods to assist in creating an Account from varying data types.
     */
    constructor(nonce = _0n, balance = _0n, storageRoot = constants_1.KECCAK256_RLP, codeHash = constants_1.KECCAK256_NULL) {
        this.nonce = nonce;
        this.balance = balance;
        this.storageRoot = storageRoot;
        this.codeHash = codeHash;
        this._validate();
    }
    static fromAccountData(accountData) {
        const { nonce, balance, storageRoot, codeHash } = accountData;
        return new Account(nonce !== undefined ? (0, bytes_1.bufferToBigInt)((0, bytes_1.toBuffer)(nonce)) : undefined, balance !== undefined ? (0, bytes_1.bufferToBigInt)((0, bytes_1.toBuffer)(balance)) : undefined, storageRoot !== undefined ? (0, bytes_1.toBuffer)(storageRoot) : undefined, codeHash !== undefined ? (0, bytes_1.toBuffer)(codeHash) : undefined);
    }
    static fromRlpSerializedAccount(serialized) {
        const values = (0, bytes_1.arrToBufArr)(rlp_1.RLP.decode(Uint8Array.from(serialized)));
        if (!Array.isArray(values)) {
            throw new Error('Invalid serialized account input. Must be array');
        }
        return this.fromValuesArray(values);
    }
    static fromValuesArray(values) {
        const [nonce, balance, storageRoot, codeHash] = values;
        return new Account((0, bytes_1.bufferToBigInt)(nonce), (0, bytes_1.bufferToBigInt)(balance), storageRoot, codeHash);
    }
    _validate() {
        if (this.nonce < _0n) {
            throw new Error('nonce must be greater than zero');
        }
        if (this.balance < _0n) {
            throw new Error('balance must be greater than zero');
        }
        if (this.storageRoot.length !== 32) {
            throw new Error('storageRoot must have a length of 32');
        }
        if (this.codeHash.length !== 32) {
            throw new Error('codeHash must have a length of 32');
        }
    }
    /**
     * Returns a Buffer Array of the raw Buffers for the account, in order.
     */
    raw() {
        return [
            (0, bytes_1.bigIntToUnpaddedBuffer)(this.nonce),
            (0, bytes_1.bigIntToUnpaddedBuffer)(this.balance),
            this.storageRoot,
            this.codeHash,
        ];
    }
    /**
     * Returns the RLP serialization of the account as a `Buffer`.
     */
    serialize() {
        return Buffer.from(rlp_1.RLP.encode((0, bytes_1.bufArrToArr)(this.raw())));
    }
    /**
     * Returns a `Boolean` determining if the account is a contract.
     */
    isContract() {
        return !this.codeHash.equals(constants_1.KECCAK256_NULL);
    }
    /**
     * Returns a `Boolean` determining if the account is empty complying to the definition of
     * account emptiness in [EIP-161](https://eips.ethereum.org/EIPS/eip-161):
     * "An account is considered empty when it has no code and zero nonce and zero balance."
     */
    isEmpty() {
        return this.balance === _0n && this.nonce === _0n && this.codeHash.equals(constants_1.KECCAK256_NULL);
    }
}
exports.Account = Account;
/**
 * Checks if the address is a valid. Accepts checksummed addresses too.
 */
const isValidAddress = function (hexAddress) {
    try {
        (0, helpers_1.assertIsString)(hexAddress);
    }
    catch (e) {
        return false;
    }
    return /^0x[0-9a-fA-F]{40}$/.test(hexAddress);
};
exports.isValidAddress = isValidAddress;
/**
 * Returns a checksummed address.
 *
 * If an eip1191ChainId is provided, the chainId will be included in the checksum calculation. This
 * has the effect of checksummed addresses for one chain having invalid checksums for others.
 * For more details see [EIP-1191](https://eips.ethereum.org/EIPS/eip-1191).
 *
 * WARNING: Checksums with and without the chainId will differ and the EIP-1191 checksum is not
 * backwards compatible to the original widely adopted checksum format standard introduced in
 * [EIP-55](https://eips.ethereum.org/EIPS/eip-55), so this will break in existing applications.
 * Usage of this EIP is therefore discouraged unless you have a very targeted use case.
 */
const toChecksumAddress = function (hexAddress, eip1191ChainId) {
    (0, helpers_1.assertIsHexString)(hexAddress);
    const address = (0, internal_1.stripHexPrefix)(hexAddress).toLowerCase();
    let prefix = '';
    if (eip1191ChainId !== undefined) {
        const chainId = (0, bytes_1.bufferToBigInt)((0, bytes_1.toBuffer)(eip1191ChainId));
        prefix = chainId.toString() + '0x';
    }
    const buf = Buffer.from(prefix + address, 'utf8');
    const hash = (0, utils_1.bytesToHex)((0, keccak_1.keccak256)(buf));
    let ret = '0x';
    for (let i = 0; i < address.length; i++) {
        if (parseInt(hash[i], 16) >= 8) {
            ret += address[i].toUpperCase();
        }
        else {
            ret += address[i];
        }
    }
    return ret;
};
exports.toChecksumAddress = toChecksumAddress;
/**
 * Checks if the address is a valid checksummed address.
 *
 * See toChecksumAddress' documentation for details about the eip1191ChainId parameter.
 */
const isValidChecksumAddress = function (hexAddress, eip1191ChainId) {
    return (0, exports.isValidAddress)(hexAddress) && (0, exports.toChecksumAddress)(hexAddress, eip1191ChainId) === hexAddress;
};
exports.isValidChecksumAddress = isValidChecksumAddress;
/**
 * Generates an address of a newly created contract.
 * @param from The address which is creating this new address
 * @param nonce The nonce of the from account
 */
const generateAddress = function (from, nonce) {
    (0, helpers_1.assertIsBuffer)(from);
    (0, helpers_1.assertIsBuffer)(nonce);
    if ((0, bytes_1.bufferToBigInt)(nonce) === BigInt(0)) {
        // in RLP we want to encode null in the case of zero nonce
        // read the RLP documentation for an answer if you dare
        return Buffer.from((0, keccak_1.keccak256)(rlp_1.RLP.encode((0, bytes_1.bufArrToArr)([from, null])))).slice(-20);
    }
    // Only take the lower 160bits of the hash
    return Buffer.from((0, keccak_1.keccak256)(rlp_1.RLP.encode((0, bytes_1.bufArrToArr)([from, nonce])))).slice(-20);
};
exports.generateAddress = generateAddress;
/**
 * Generates an address for a contract created using CREATE2.
 * @param from The address which is creating this new address
 * @param salt A salt
 * @param initCode The init code of the contract being created
 */
const generateAddress2 = function (from, salt, initCode) {
    (0, helpers_1.assertIsBuffer)(from);
    (0, helpers_1.assertIsBuffer)(salt);
    (0, helpers_1.assertIsBuffer)(initCode);
    if (from.length !== 20) {
        throw new Error('Expected from to be of length 20');
    }
    if (salt.length !== 32) {
        throw new Error('Expected salt to be of length 32');
    }
    const address = (0, keccak_1.keccak256)(Buffer.concat([Buffer.from('ff', 'hex'), from, salt, (0, keccak_1.keccak256)(initCode)]));
    return (0, bytes_1.toBuffer)(address).slice(-20);
};
exports.generateAddress2 = generateAddress2;
/**
 * Checks if the private key satisfies the rules of the curve secp256k1.
 */
const isValidPrivate = function (privateKey) {
    return secp256k1_1.secp256k1.utils.isValidPrivateKey(privateKey);
};
exports.isValidPrivate = isValidPrivate;
/**
 * Checks if the public key satisfies the rules of the curve secp256k1
 * and the requirements of Ethereum.
 * @param publicKey The two points of an uncompressed key, unless sanitize is enabled
 * @param sanitize Accept public keys in other formats
 */
const isValidPublic = function (publicKey, sanitize = false) {
    (0, helpers_1.assertIsBuffer)(publicKey);
    if (publicKey.length === 64) {
        // Convert to SEC1 for secp256k1
        // Automatically checks whether point is on curve
        try {
            secp256k1_1.secp256k1.ProjectivePoint.fromHex(Buffer.concat([Buffer.from([4]), publicKey]));
            return true;
        }
        catch (e) {
            return false;
        }
    }
    if (!sanitize) {
        return false;
    }
    try {
        secp256k1_1.secp256k1.ProjectivePoint.fromHex(publicKey);
        return true;
    }
    catch (e) {
        return false;
    }
};
exports.isValidPublic = isValidPublic;
/**
 * Returns the ethereum address of a given public key.
 * Accepts "Ethereum public keys" and SEC1 encoded keys.
 * @param pubKey The two points of an uncompressed key, unless sanitize is enabled
 * @param sanitize Accept public keys in other formats
 */
const pubToAddress = function (pubKey, sanitize = false) {
    (0, helpers_1.assertIsBuffer)(pubKey);
    if (sanitize && pubKey.length !== 64) {
        pubKey = Buffer.from(secp256k1_1.secp256k1.ProjectivePoint.fromHex(pubKey).toRawBytes(false).slice(1));
    }
    if (pubKey.length !== 64) {
        throw new Error('Expected pubKey to be of length 64');
    }
    // Only take the lower 160bits of the hash
    return Buffer.from((0, keccak_1.keccak256)(pubKey)).slice(-20);
};
exports.pubToAddress = pubToAddress;
exports.publicToAddress = exports.pubToAddress;
/**
 * Returns the ethereum public key of a given private key.
 * @param privateKey A private key must be 256 bits wide
 */
const privateToPublic = function (privateKey) {
    (0, helpers_1.assertIsBuffer)(privateKey);
    // skip the type flag and use the X, Y points
    return Buffer.from(secp256k1_1.secp256k1.ProjectivePoint.fromPrivateKey(privateKey).toRawBytes(false).slice(1));
};
exports.privateToPublic = privateToPublic;
/**
 * Returns the ethereum address of a given private key.
 * @param privateKey A private key must be 256 bits wide
 */
const privateToAddress = function (privateKey) {
    return (0, exports.publicToAddress)((0, exports.privateToPublic)(privateKey));
};
exports.privateToAddress = privateToAddress;
/**
 * Converts a public key to the Ethereum format.
 */
const importPublic = function (publicKey) {
    (0, helpers_1.assertIsBuffer)(publicKey);
    if (publicKey.length !== 64) {
        publicKey = Buffer.from(secp256k1_1.secp256k1.ProjectivePoint.fromHex(publicKey).toRawBytes(false).slice(1));
    }
    return publicKey;
};
exports.importPublic = importPublic;
/**
 * Returns the zero address.
 */
const zeroAddress = function () {
    const addressLength = 20;
    const addr = (0, bytes_1.zeros)(addressLength);
    return (0, bytes_1.bufferToHex)(addr);
};
exports.zeroAddress = zeroAddress;
/**
 * Checks if a given address is the zero address.
 */
const isZeroAddress = function (hexAddress) {
    try {
        (0, helpers_1.assertIsString)(hexAddress);
    }
    catch (e) {
        return false;
    }
    const zeroAddr = (0, exports.zeroAddress)();
    return zeroAddr === hexAddress;
};
exports.isZeroAddress = isZeroAddress;
function accountBodyFromSlim(body) {
    const [nonce, balance, storageRoot, codeHash] = body;
    return [
        nonce,
        balance,
        (0, bytes_1.arrToBufArr)(storageRoot).length === 0 ? constants_1.KECCAK256_RLP : storageRoot,
        (0, bytes_1.arrToBufArr)(codeHash).length === 0 ? constants_1.KECCAK256_NULL : codeHash,
    ];
}
exports.accountBodyFromSlim = accountBodyFromSlim;
const emptyUint8Arr = new Uint8Array(0);
function accountBodyToSlim(body) {
    const [nonce, balance, storageRoot, codeHash] = body;
    return [
        nonce,
        balance,
        (0, bytes_1.arrToBufArr)(storageRoot).equals(constants_1.KECCAK256_RLP) ? emptyUint8Arr : storageRoot,
        (0, bytes_1.arrToBufArr)(codeHash).equals(constants_1.KECCAK256_NULL) ? emptyUint8Arr : codeHash,
    ];
}
exports.accountBodyToSlim = accountBodyToSlim;
/**
 * Converts a slim account (per snap protocol spec) to the RLP encoded version of the account
 * @param body Array of 4 Buffer-like items to represent the account
 * @returns RLP encoded version of the account
 */
function accountBodyToRLP(body, couldBeSlim = true) {
    const accountBody = couldBeSlim ? accountBodyFromSlim(body) : body;
    return (0, bytes_1.arrToBufArr)(rlp_1.RLP.encode(accountBody));
}
exports.accountBodyToRLP = accountBodyToRLP;

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\account.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\address.js", {"./account":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\account.js","./bytes":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\bytes.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Cutil%5Cdist%5Caddress.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Address = void 0;
const account_1 = require("./account");
const bytes_1 = require("./bytes");
/**
 * Handling and generating Ethereum addresses
 */
class Address {
    constructor(buf) {
        if (buf.length !== 20) {
            throw new Error('Invalid address length');
        }
        this.buf = buf;
    }
    /**
     * Returns the zero address.
     */
    static zero() {
        return new Address((0, bytes_1.zeros)(20));
    }
    /**
     * Returns an Address object from a hex-encoded string.
     * @param str - Hex-encoded address
     */
    static fromString(str) {
        if (!(0, account_1.isValidAddress)(str)) {
            throw new Error('Invalid address');
        }
        return new Address((0, bytes_1.toBuffer)(str));
    }
    /**
     * Returns an address for a given public key.
     * @param pubKey The two points of an uncompressed key
     */
    static fromPublicKey(pubKey) {
        if (!Buffer.isBuffer(pubKey)) {
            throw new Error('Public key should be Buffer');
        }
        const buf = (0, account_1.pubToAddress)(pubKey);
        return new Address(buf);
    }
    /**
     * Returns an address for a given private key.
     * @param privateKey A private key must be 256 bits wide
     */
    static fromPrivateKey(privateKey) {
        if (!Buffer.isBuffer(privateKey)) {
            throw new Error('Private key should be Buffer');
        }
        const buf = (0, account_1.privateToAddress)(privateKey);
        return new Address(buf);
    }
    /**
     * Generates an address for a newly created contract.
     * @param from The address which is creating this new address
     * @param nonce The nonce of the from account
     */
    static generate(from, nonce) {
        if (typeof nonce !== 'bigint') {
            throw new Error('Expected nonce to be a bigint');
        }
        return new Address((0, account_1.generateAddress)(from.buf, (0, bytes_1.bigIntToBuffer)(nonce)));
    }
    /**
     * Generates an address for a contract created using CREATE2.
     * @param from The address which is creating this new address
     * @param salt A salt
     * @param initCode The init code of the contract being created
     */
    static generate2(from, salt, initCode) {
        if (!Buffer.isBuffer(salt)) {
            throw new Error('Expected salt to be a Buffer');
        }
        if (!Buffer.isBuffer(initCode)) {
            throw new Error('Expected initCode to be a Buffer');
        }
        return new Address((0, account_1.generateAddress2)(from.buf, salt, initCode));
    }
    /**
     * Is address equal to another.
     */
    equals(address) {
        return this.buf.equals(address.buf);
    }
    /**
     * Is address zero.
     */
    isZero() {
        return this.equals(Address.zero());
    }
    /**
     * True if address is in the address range defined
     * by EIP-1352
     */
    isPrecompileOrSystemAddress() {
        const address = (0, bytes_1.bufferToBigInt)(this.buf);
        const rangeMin = BigInt(0);
        const rangeMax = BigInt('0xffff');
        return address >= rangeMin && address <= rangeMax;
    }
    /**
     * Returns hex encoding of address.
     */
    toString() {
        return '0x' + this.buf.toString('hex');
    }
    /**
     * Returns Buffer representation of address.
     */
    toBuffer() {
        return Buffer.from(this.buf);
    }
}
exports.Address = Address;

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\address.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\asyncEventEmitter.js", {"events":"D:\\code\\v\\metamask-extension\\node_modules\\events\\events.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Cutil%5Cdist%5CasyncEventEmitter.js
      return function (require, module, exports) {
"use strict";
/**
 * Ported to Typescript from original implementation below:
 * https://github.com/ahultgren/async-eventemitter -- MIT licensed
 *
 * Type Definitions based on work by: patarapolw <https://github.com/patarapolw> -- MIT licensed
 * that was contributed to Definitely Typed below:
 * https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/async-eventemitter
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsyncEventEmitter = void 0;
const events_1 = require("events");
async function runInSeries(context, tasks, data) {
    let error;
    for await (const task of tasks) {
        try {
            if (task.length < 2) {
                //sync
                task.call(context, data);
            }
            else {
                await new Promise((resolve, reject) => {
                    task.call(context, data, (error) => {
                        if (error) {
                            reject(error);
                        }
                        else {
                            resolve();
                        }
                    });
                });
            }
        }
        catch (e) {
            error = e;
        }
    }
    if (error) {
        throw error;
    }
}
class AsyncEventEmitter extends events_1.EventEmitter {
    emit(event, ...args) {
        let [data, callback] = args;
        const self = this;
        let listeners = self._events[event] ?? [];
        // Optional data argument
        if (callback === undefined && typeof data === 'function') {
            callback = data;
            data = undefined;
        }
        // Special treatment of internal newListener and removeListener events
        if (event === 'newListener' || event === 'removeListener') {
            data = {
                event: data,
                fn: callback,
            };
            callback = undefined;
        }
        // A single listener is just a function not an array...
        listeners = Array.isArray(listeners) ? listeners : [listeners];
        runInSeries(self, listeners.slice(), data).then(callback).catch(callback);
        return self.listenerCount(event) > 0;
    }
    once(event, listener) {
        const self = this;
        let g;
        if (typeof listener !== 'function') {
            throw new TypeError('listener must be a function');
        }
        // Hack to support set arity
        if (listener.length >= 2) {
            g = function (e, next) {
                self.removeListener(event, g);
                void listener(e, next);
            };
        }
        else {
            g = function (e) {
                self.removeListener(event, g);
                void listener(e, g);
            };
        }
        self.on(event, g);
        return self;
    }
    first(event, listener) {
        let listeners = this._events[event] ?? [];
        // Contract
        if (typeof listener !== 'function') {
            throw new TypeError('listener must be a function');
        }
        // Listeners are not always an array
        if (!Array.isArray(listeners)) {
            ;
            this._events[event] = listeners = [listeners];
        }
        listeners.unshift(listener);
        return this;
    }
    before(event, target, listener) {
        return this.beforeOrAfter(event, target, listener);
    }
    after(event, target, listener) {
        return this.beforeOrAfter(event, target, listener, 'after');
    }
    beforeOrAfter(event, target, listener, beforeOrAfter) {
        let listeners = this._events[event] ?? [];
        let i;
        let index;
        const add = beforeOrAfter === 'after' ? 1 : 0;
        // Contract
        if (typeof listener !== 'function') {
            throw new TypeError('listener must be a function');
        }
        if (typeof target !== 'function') {
            throw new TypeError('target must be a function');
        }
        // Listeners are not always an array
        if (!Array.isArray(listeners)) {
            ;
            this._events[event] = listeners = [listeners];
        }
        index = listeners.length;
        for (i = listeners.length; i--;) {
            if (listeners[i] === target) {
                index = i + add;
                break;
            }
        }
        listeners.splice(index, 0, listener);
        return this;
    }
    on(event, listener) {
        return super.on(event, listener);
    }
    addListener(event, listener) {
        return super.addListener(event, listener);
    }
    prependListener(event, listener) {
        return super.prependListener(event, listener);
    }
    prependOnceListener(event, listener) {
        return super.prependOnceListener(event, listener);
    }
    removeAllListeners(event) {
        return super.removeAllListeners(event);
    }
    removeListener(event, listener) {
        return super.removeListener(event, listener);
    }
    eventNames() {
        return super.eventNames();
    }
    listeners(event) {
        return super.listeners(event);
    }
    listenerCount(event) {
        return super.listenerCount(event);
    }
    getMaxListeners() {
        return super.getMaxListeners();
    }
    setMaxListeners(maxListeners) {
        return super.setMaxListeners(maxListeners);
    }
}
exports.AsyncEventEmitter = AsyncEventEmitter;

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\asyncEventEmitter.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\bytes.js", {"./helpers":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\helpers.js","./internal":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\internal.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Cutil%5Cdist%5Cbytes.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.intToUnpaddedBuffer = exports.bigIntToUnpaddedBuffer = exports.bigIntToHex = exports.bufArrToArr = exports.arrToBufArr = exports.validateNoLeadingZeroes = exports.baToJSON = exports.toUtf8 = exports.short = exports.addHexPrefix = exports.toUnsigned = exports.fromSigned = exports.bufferToInt = exports.bigIntToBuffer = exports.bufferToBigInt = exports.bufferToHex = exports.toBuffer = exports.unpadHexString = exports.unpadArray = exports.unpadBuffer = exports.setLengthRight = exports.setLengthLeft = exports.zeros = exports.intToBuffer = exports.intToHex = void 0;
const helpers_1 = require("./helpers");
const internal_1 = require("./internal");
/**
 * Converts a `Number` into a hex `String`
 * @param {Number} i
 * @return {String}
 */
const intToHex = function (i) {
    if (!Number.isSafeInteger(i) || i < 0) {
        throw new Error(`Received an invalid integer type: ${i}`);
    }
    return `0x${i.toString(16)}`;
};
exports.intToHex = intToHex;
/**
 * Converts an `Number` to a `Buffer`
 * @param {Number} i
 * @return {Buffer}
 */
const intToBuffer = function (i) {
    const hex = (0, exports.intToHex)(i);
    return Buffer.from((0, internal_1.padToEven)(hex.slice(2)), 'hex');
};
exports.intToBuffer = intToBuffer;
/**
 * Returns a buffer filled with 0s.
 * @param bytes the number of bytes the buffer should be
 */
const zeros = function (bytes) {
    return Buffer.allocUnsafe(bytes).fill(0);
};
exports.zeros = zeros;
/**
 * Pads a `Buffer` with zeros till it has `length` bytes.
 * Truncates the beginning or end of input if its length exceeds `length`.
 * @param msg the value to pad (Buffer)
 * @param length the number of bytes the output should be
 * @param right whether to start padding form the left or right
 * @return (Buffer)
 */
const setLength = function (msg, length, right) {
    const buf = (0, exports.zeros)(length);
    if (right) {
        if (msg.length < length) {
            msg.copy(buf);
            return buf;
        }
        return msg.slice(0, length);
    }
    else {
        if (msg.length < length) {
            msg.copy(buf, length - msg.length);
            return buf;
        }
        return msg.slice(-length);
    }
};
/**
 * Left Pads a `Buffer` with leading zeros till it has `length` bytes.
 * Or it truncates the beginning if it exceeds.
 * @param msg the value to pad (Buffer)
 * @param length the number of bytes the output should be
 * @return (Buffer)
 */
const setLengthLeft = function (msg, length) {
    (0, helpers_1.assertIsBuffer)(msg);
    return setLength(msg, length, false);
};
exports.setLengthLeft = setLengthLeft;
/**
 * Right Pads a `Buffer` with trailing zeros till it has `length` bytes.
 * it truncates the end if it exceeds.
 * @param msg the value to pad (Buffer)
 * @param length the number of bytes the output should be
 * @return (Buffer)
 */
const setLengthRight = function (msg, length) {
    (0, helpers_1.assertIsBuffer)(msg);
    return setLength(msg, length, true);
};
exports.setLengthRight = setLengthRight;
/**
 * Trims leading zeros from a `Buffer`, `String` or `Number[]`.
 * @param a (Buffer|Array|String)
 * @return (Buffer|Array|String)
 */
const stripZeros = function (a) {
    let first = a[0];
    while (a.length > 0 && first.toString() === '0') {
        a = a.slice(1);
        first = a[0];
    }
    return a;
};
/**
 * Trims leading zeros from a `Buffer`.
 * @param a (Buffer)
 * @return (Buffer)
 */
const unpadBuffer = function (a) {
    (0, helpers_1.assertIsBuffer)(a);
    return stripZeros(a);
};
exports.unpadBuffer = unpadBuffer;
/**
 * Trims leading zeros from an `Array` (of numbers).
 * @param a (number[])
 * @return (number[])
 */
const unpadArray = function (a) {
    (0, helpers_1.assertIsArray)(a);
    return stripZeros(a);
};
exports.unpadArray = unpadArray;
/**
 * Trims leading zeros from a hex-prefixed `String`.
 * @param a (String)
 * @return (String)
 */
const unpadHexString = function (a) {
    (0, helpers_1.assertIsHexString)(a);
    a = (0, internal_1.stripHexPrefix)(a);
    return ('0x' + stripZeros(a));
};
exports.unpadHexString = unpadHexString;
/**
 * Attempts to turn a value into a `Buffer`.
 * Inputs supported: `Buffer`, `String` (hex-prefixed), `Number`, null/undefined, `BigInt` and other objects
 * with a `toArray()` or `toBuffer()` method.
 * @param v the value
 */
const toBuffer = function (v) {
    if (v === null || v === undefined) {
        return Buffer.allocUnsafe(0);
    }
    if (Buffer.isBuffer(v)) {
        return Buffer.from(v);
    }
    if (Array.isArray(v) || v instanceof Uint8Array) {
        return Buffer.from(v);
    }
    if (typeof v === 'string') {
        if (!(0, internal_1.isHexString)(v)) {
            throw new Error(`Cannot convert string to buffer. toBuffer only supports 0x-prefixed hex strings and this string was given: ${v}`);
        }
        return Buffer.from((0, internal_1.padToEven)((0, internal_1.stripHexPrefix)(v)), 'hex');
    }
    if (typeof v === 'number') {
        return (0, exports.intToBuffer)(v);
    }
    if (typeof v === 'bigint') {
        if (v < BigInt(0)) {
            throw new Error(`Cannot convert negative bigint to buffer. Given: ${v}`);
        }
        let n = v.toString(16);
        if (n.length % 2)
            n = '0' + n;
        return Buffer.from(n, 'hex');
    }
    if (v.toArray) {
        // converts a BN to a Buffer
        return Buffer.from(v.toArray());
    }
    if (v.toBuffer) {
        return Buffer.from(v.toBuffer());
    }
    throw new Error('invalid type');
};
exports.toBuffer = toBuffer;
/**
 * Converts a `Buffer` into a `0x`-prefixed hex `String`.
 * @param buf `Buffer` object to convert
 */
const bufferToHex = function (buf) {
    buf = (0, exports.toBuffer)(buf);
    return '0x' + buf.toString('hex');
};
exports.bufferToHex = bufferToHex;
/**
 * Converts a {@link Buffer} to a {@link bigint}
 */
function bufferToBigInt(buf) {
    const hex = (0, exports.bufferToHex)(buf);
    if (hex === '0x') {
        return BigInt(0);
    }
    return BigInt(hex);
}
exports.bufferToBigInt = bufferToBigInt;
/**
 * Converts a {@link bigint} to a {@link Buffer}
 */
function bigIntToBuffer(num) {
    return (0, exports.toBuffer)('0x' + num.toString(16));
}
exports.bigIntToBuffer = bigIntToBuffer;
/**
 * Converts a `Buffer` to a `Number`.
 * @param buf `Buffer` object to convert
 * @throws If the input number exceeds 53 bits.
 */
const bufferToInt = function (buf) {
    const res = Number(bufferToBigInt(buf));
    if (!Number.isSafeInteger(res))
        throw new Error('Number exceeds 53 bits');
    return res;
};
exports.bufferToInt = bufferToInt;
/**
 * Interprets a `Buffer` as a signed integer and returns a `BigInt`. Assumes 256-bit numbers.
 * @param num Signed integer value
 */
const fromSigned = function (num) {
    return BigInt.asIntN(256, bufferToBigInt(num));
};
exports.fromSigned = fromSigned;
/**
 * Converts a `BigInt` to an unsigned integer and returns it as a `Buffer`. Assumes 256-bit numbers.
 * @param num
 */
const toUnsigned = function (num) {
    return bigIntToBuffer(BigInt.asUintN(256, num));
};
exports.toUnsigned = toUnsigned;
/**
 * Adds "0x" to a given `String` if it does not already start with "0x".
 */
const addHexPrefix = function (str) {
    if (typeof str !== 'string') {
        return str;
    }
    return (0, internal_1.isHexPrefixed)(str) ? str : '0x' + str;
};
exports.addHexPrefix = addHexPrefix;
/**
 * Shortens a string  or buffer's hex string representation to maxLength (default 50).
 *
 * Examples:
 *
 * Input:  '657468657265756d000000000000000000000000000000000000000000000000'
 * Output: '657468657265756d0000000000000000000000000000000000…'
 */
function short(buffer, maxLength = 50) {
    const bufferStr = Buffer.isBuffer(buffer) ? buffer.toString('hex') : buffer;
    if (bufferStr.length <= maxLength) {
        return bufferStr;
    }
    return bufferStr.slice(0, maxLength) + '…';
}
exports.short = short;
/**
 * Returns the utf8 string representation from a hex string.
 *
 * Examples:
 *
 * Input 1: '657468657265756d000000000000000000000000000000000000000000000000'
 * Input 2: '657468657265756d'
 * Input 3: '000000000000000000000000000000000000000000000000657468657265756d'
 *
 * Output (all 3 input variants): 'ethereum'
 *
 * Note that this method is not intended to be used with hex strings
 * representing quantities in both big endian or little endian notation.
 *
 * @param string Hex string, should be `0x` prefixed
 * @return Utf8 string
 */
const toUtf8 = function (hex) {
    const zerosRegexp = /^(00)+|(00)+$/g;
    hex = (0, internal_1.stripHexPrefix)(hex);
    if (hex.length % 2 !== 0) {
        throw new Error('Invalid non-even hex string input for toUtf8() provided');
    }
    const bufferVal = Buffer.from(hex.replace(zerosRegexp, ''), 'hex');
    return bufferVal.toString('utf8');
};
exports.toUtf8 = toUtf8;
/**
 * Converts a `Buffer` or `Array` to JSON.
 * @param ba (Buffer|Array)
 * @return (Array|String|null)
 */
const baToJSON = function (ba) {
    if (Buffer.isBuffer(ba)) {
        return `0x${ba.toString('hex')}`;
    }
    else if (ba instanceof Array) {
        const array = [];
        for (let i = 0; i < ba.length; i++) {
            array.push((0, exports.baToJSON)(ba[i]));
        }
        return array;
    }
};
exports.baToJSON = baToJSON;
/**
 * Checks provided Buffers for leading zeroes and throws if found.
 *
 * Examples:
 *
 * Valid values: 0x1, 0x, 0x01, 0x1234
 * Invalid values: 0x0, 0x00, 0x001, 0x0001
 *
 * Note: This method is useful for validating that RLP encoded integers comply with the rule that all
 * integer values encoded to RLP must be in the most compact form and contain no leading zero bytes
 * @param values An object containing string keys and Buffer values
 * @throws if any provided value is found to have leading zero bytes
 */
const validateNoLeadingZeroes = function (values) {
    for (const [k, v] of Object.entries(values)) {
        if (v !== undefined && v.length > 0 && v[0] === 0) {
            throw new Error(`${k} cannot have leading zeroes, received: ${v.toString('hex')}`);
        }
    }
};
exports.validateNoLeadingZeroes = validateNoLeadingZeroes;
function arrToBufArr(arr) {
    if (!Array.isArray(arr)) {
        return Buffer.from(arr);
    }
    return arr.map((a) => arrToBufArr(a));
}
exports.arrToBufArr = arrToBufArr;
function bufArrToArr(arr) {
    if (!Array.isArray(arr)) {
        return Uint8Array.from(arr ?? []);
    }
    return arr.map((a) => bufArrToArr(a));
}
exports.bufArrToArr = bufArrToArr;
/**
 * Converts a {@link bigint} to a `0x` prefixed hex string
 */
const bigIntToHex = (num) => {
    return '0x' + num.toString(16);
};
exports.bigIntToHex = bigIntToHex;
/**
 * Convert value from bigint to an unpadded Buffer
 * (useful for RLP transport)
 * @param value value to convert
 */
function bigIntToUnpaddedBuffer(value) {
    return (0, exports.unpadBuffer)(bigIntToBuffer(value));
}
exports.bigIntToUnpaddedBuffer = bigIntToUnpaddedBuffer;
function intToUnpaddedBuffer(value) {
    return (0, exports.unpadBuffer)((0, exports.intToBuffer)(value));
}
exports.intToUnpaddedBuffer = intToUnpaddedBuffer;

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\bytes.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\constants.js", {"buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js","ethereum-cryptography/secp256k1":"D:\\code\\v\\metamask-extension\\node_modules\\ethereum-cryptography\\secp256k1.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Cutil%5Cdist%5Cconstants.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MAX_WITHDRAWALS_PER_PAYLOAD = exports.RLP_EMPTY_STRING = exports.KECCAK256_RLP = exports.KECCAK256_RLP_S = exports.KECCAK256_RLP_ARRAY = exports.KECCAK256_RLP_ARRAY_S = exports.KECCAK256_NULL = exports.KECCAK256_NULL_S = exports.TWO_POW256 = exports.SECP256K1_ORDER_DIV_2 = exports.SECP256K1_ORDER = exports.MAX_INTEGER_BIGINT = exports.MAX_INTEGER = exports.MAX_UINT64 = void 0;
const buffer_1 = require("buffer");
const secp256k1_1 = require("ethereum-cryptography/secp256k1");
/**
 * 2^64-1
 */
exports.MAX_UINT64 = BigInt('0xffffffffffffffff');
/**
 * The max integer that the evm can handle (2^256-1)
 */
exports.MAX_INTEGER = BigInt('0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff');
/**
 * The max integer that the evm can handle (2^256-1) as a bigint
 * 2^256-1 equals to 340282366920938463463374607431768211455
 * We use literal value instead of calculated value for compatibility issue.
 */
exports.MAX_INTEGER_BIGINT = BigInt('115792089237316195423570985008687907853269984665640564039457584007913129639935');
exports.SECP256K1_ORDER = secp256k1_1.secp256k1.CURVE.n;
exports.SECP256K1_ORDER_DIV_2 = secp256k1_1.secp256k1.CURVE.n / BigInt(2);
/**
 * 2^256
 */
exports.TWO_POW256 = BigInt('0x10000000000000000000000000000000000000000000000000000000000000000');
/**
 * Keccak-256 hash of null
 */
exports.KECCAK256_NULL_S = 'c5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470';
/**
 * Keccak-256 hash of null
 */
exports.KECCAK256_NULL = buffer_1.Buffer.from(exports.KECCAK256_NULL_S, 'hex');
/**
 * Keccak-256 of an RLP of an empty array
 */
exports.KECCAK256_RLP_ARRAY_S = '1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347';
/**
 * Keccak-256 of an RLP of an empty array
 */
exports.KECCAK256_RLP_ARRAY = buffer_1.Buffer.from(exports.KECCAK256_RLP_ARRAY_S, 'hex');
/**
 * Keccak-256 hash of the RLP of null
 */
exports.KECCAK256_RLP_S = '56e81f171bcc55a6ff8345e692c0f86e5b48e01b996cadc001622fb5e363b421';
/**
 * Keccak-256 hash of the RLP of null
 */
exports.KECCAK256_RLP = buffer_1.Buffer.from(exports.KECCAK256_RLP_S, 'hex');
/**
 *  RLP encoded empty string
 */
exports.RLP_EMPTY_STRING = buffer_1.Buffer.from([0x80]);
exports.MAX_WITHDRAWALS_PER_PAYLOAD = 16;

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\constants.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\encoding.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Cutil%5Cdist%5Cencoding.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compactBytesToNibbles = exports.bytesToNibbles = exports.nibblesToCompactBytes = exports.nibblesToBytes = exports.hasTerminator = void 0;
// Reference: https://ethereum.org/en/developers/docs/data-structures-and-encoding/patricia-merkle-trie/
/**
 *
 * @param s byte sequence
 * @returns boolean indicating if input hex nibble sequence has terminator indicating leaf-node
 *          terminator is represented with 16 because a nibble ranges from 0 - 15(f)
 */
const hasTerminator = (nibbles) => {
    return nibbles.length > 0 && nibbles[nibbles.length - 1] === 16;
};
exports.hasTerminator = hasTerminator;
const nibblesToBytes = (nibbles, bytes) => {
    for (let bi = 0, ni = 0; ni < nibbles.length; bi += 1, ni += 2) {
        bytes[bi] = (nibbles[ni] << 4) | nibbles[ni + 1];
    }
};
exports.nibblesToBytes = nibblesToBytes;
const nibblesToCompactBytes = (nibbles) => {
    let terminator = 0;
    if ((0, exports.hasTerminator)(nibbles)) {
        terminator = 1;
        // Remove the terminator from the sequence
        nibbles = nibbles.subarray(0, nibbles.length - 1);
    }
    const buf = new Uint8Array(nibbles.length / 2 + 1);
    // Shift the terminator info into the first nibble of buf[0]
    buf[0] = terminator << 5;
    // If odd length, then add that flag into the first nibble and put the odd nibble to
    // second part of buf[0] which otherwise will be left padded with a 0
    if ((nibbles.length & 1) === 1) {
        buf[0] |= 1 << 4;
        buf[0] |= nibbles[0];
        nibbles = nibbles.subarray(1);
    }
    // create bytes out of the rest even nibbles
    (0, exports.nibblesToBytes)(nibbles, buf.subarray(1));
    return buf;
};
exports.nibblesToCompactBytes = nibblesToCompactBytes;
const bytesToNibbles = (str) => {
    const l = str.length * 2 + 1;
    const nibbles = new Uint8Array(l);
    for (let i = 0; i < str.length; i++) {
        const b = str[i];
        nibbles[i * 2] = b / 16;
        nibbles[i * 2 + 1] = b % 16;
    }
    // This will get removed from calling function if the first nibble
    // indicates that terminator is not present
    nibbles[l - 1] = 16;
    return nibbles;
};
exports.bytesToNibbles = bytesToNibbles;
const compactBytesToNibbles = (compact) => {
    if (compact.length === 0) {
        return compact;
    }
    let base = (0, exports.bytesToNibbles)(compact);
    // delete terminator flag if terminator flag was not in first nibble
    if (base[0] < 2) {
        base = base.subarray(0, base.length - 1);
    }
    // chop the terminator nibble and the even padding (if there is one)
    // i.e.  chop 2 left nibbles when even else 1 when odd
    const chop = 2 - (base[0] & 1);
    return base.subarray(chop);
};
exports.compactBytesToNibbles = compactBytesToNibbles;
/**
 * A test helper to generates compact path for a subset of key bytes
 *
 * TODO: Commenting the code for now as this seems to be helper function
 * (from geth codebase )
 *
 */
//
//
// export const getPathTo = (tillBytes: number, key: Buffer) => {
//   const hexNibbles = bytesToNibbles(key).subarray(0, tillBytes)
//   // Remove the terminator if its there, although it would be there only if tillBytes >= key.length
//   // This seems to be a test helper to generate paths so correctness of this isn't necessary
//   hexNibbles[hexNibbles.length - 1] = 0
//   const compactBytes = nibblesToCompactBytes(hexNibbles)
//   return [Buffer.from(compactBytes)]
// }

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\encoding.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\helpers.js", {"../../../../../is-buffer/index.js":"D:\\code\\v\\metamask-extension\\node_modules\\is-buffer\\index.js","./internal":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\internal.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Cutil%5Cdist%5Chelpers.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assertIsString = exports.assertIsArray = exports.assertIsBuffer = exports.assertIsHexString = void 0;
const internal_1 = require("./internal");
/**
 * Throws if a string is not hex prefixed
 * @param {string} input string to check hex prefix of
 */
const assertIsHexString = function (input) {
    if (!(0, internal_1.isHexString)(input)) {
        const msg = `This method only supports 0x-prefixed hex strings but input was: ${input}`;
        throw new Error(msg);
    }
};
exports.assertIsHexString = assertIsHexString;
/**
 * Throws if input is not a buffer
 * @param {Buffer} input value to check
 */
const assertIsBuffer = function (input) {
    if (!Buffer.isBuffer(input)) {
        const msg = `This method only supports Buffer but input was: ${input}`;
        throw new Error(msg);
    }
};
exports.assertIsBuffer = assertIsBuffer;
/**
 * Throws if input is not an array
 * @param {number[]} input value to check
 */
const assertIsArray = function (input) {
    if (!Array.isArray(input)) {
        const msg = `This method only supports number arrays but input was: ${input}`;
        throw new Error(msg);
    }
};
exports.assertIsArray = assertIsArray;
/**
 * Throws if input is not a string
 * @param {string} input value to check
 */
const assertIsString = function (input) {
    if (typeof input !== 'string') {
        const msg = `This method only supports strings but input was: ${input}`;
        throw new Error(msg);
    }
};
exports.assertIsString = assertIsString;

}).call(this)}).call(this,{"isBuffer":require("../../../../../is-buffer/index.js")})

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\helpers.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\index.js", {"./account":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\account.js","./address":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\address.js","./asyncEventEmitter":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\asyncEventEmitter.js","./bytes":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\bytes.js","./constants":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\constants.js","./encoding":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\encoding.js","./internal":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\internal.js","./lock":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\lock.js","./provider":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\provider.js","./signature":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\signature.js","./types":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\types.js","./units":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\units.js","./withdrawal":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\withdrawal.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Cutil%5Cdist%5Cindex.js
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.toAscii = exports.stripHexPrefix = exports.padToEven = exports.isHexString = exports.isHexPrefixed = exports.getKeys = exports.getBinarySize = exports.fromUtf8 = exports.fromAscii = exports.arrayContainsArray = void 0;
/**
 * Constants
 */
__exportStar(require("./constants"), exports);
/**
 * Units helpers
 */
__exportStar(require("./units"), exports);
/**
 * Account class and helper functions
 */
__exportStar(require("./account"), exports);
/**
 * Address type
 */
__exportStar(require("./address"), exports);
/**
 * Withdrawal type
 */
__exportStar(require("./withdrawal"), exports);
/**
 * ECDSA signature
 */
__exportStar(require("./signature"), exports);
/**
 * Utilities for manipulating Buffers, byte arrays, etc.
 */
__exportStar(require("./bytes"), exports);
/**
 * Helpful TypeScript types
 */
__exportStar(require("./types"), exports);
/**
 * Helper function for working with compact encoding
 */
__exportStar(require("./encoding"), exports);
/**
 * Export ethjs-util methods
 */
__exportStar(require("./asyncEventEmitter"), exports);
var internal_1 = require("./internal");
Object.defineProperty(exports, "arrayContainsArray", { enumerable: true, get: function () { return internal_1.arrayContainsArray; } });
Object.defineProperty(exports, "fromAscii", { enumerable: true, get: function () { return internal_1.fromAscii; } });
Object.defineProperty(exports, "fromUtf8", { enumerable: true, get: function () { return internal_1.fromUtf8; } });
Object.defineProperty(exports, "getBinarySize", { enumerable: true, get: function () { return internal_1.getBinarySize; } });
Object.defineProperty(exports, "getKeys", { enumerable: true, get: function () { return internal_1.getKeys; } });
Object.defineProperty(exports, "isHexPrefixed", { enumerable: true, get: function () { return internal_1.isHexPrefixed; } });
Object.defineProperty(exports, "isHexString", { enumerable: true, get: function () { return internal_1.isHexString; } });
Object.defineProperty(exports, "padToEven", { enumerable: true, get: function () { return internal_1.padToEven; } });
Object.defineProperty(exports, "stripHexPrefix", { enumerable: true, get: function () { return internal_1.stripHexPrefix; } });
Object.defineProperty(exports, "toAscii", { enumerable: true, get: function () { return internal_1.toAscii; } });
__exportStar(require("./lock"), exports);
__exportStar(require("./provider"), exports);

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\internal.js", {"buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Cutil%5Cdist%5Cinternal.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
/*
The MIT License

Copyright (c) 2016 Nick Dodson. nickdodson.com

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.isHexString = exports.getKeys = exports.fromAscii = exports.fromUtf8 = exports.toAscii = exports.arrayContainsArray = exports.getBinarySize = exports.padToEven = exports.stripHexPrefix = exports.isHexPrefixed = void 0;
/**
 * Returns a `Boolean` on whether or not the a `String` starts with '0x'
 * @param str the string input value
 * @return a boolean if it is or is not hex prefixed
 * @throws if the str input is not a string
 */
function isHexPrefixed(str) {
    if (typeof str !== 'string') {
        throw new Error(`[isHexPrefixed] input must be type 'string', received type ${typeof str}`);
    }
    return str[0] === '0' && str[1] === 'x';
}
exports.isHexPrefixed = isHexPrefixed;
/**
 * Removes '0x' from a given `String` if present
 * @param str the string value
 * @returns the string without 0x prefix
 */
const stripHexPrefix = (str) => {
    if (typeof str !== 'string')
        throw new Error(`[stripHexPrefix] input must be type 'string', received ${typeof str}`);
    return isHexPrefixed(str) ? str.slice(2) : str;
};
exports.stripHexPrefix = stripHexPrefix;
/**
 * Pads a `String` to have an even length
 * @param value
 * @return output
 */
function padToEven(value) {
    let a = value;
    if (typeof a !== 'string') {
        throw new Error(`[padToEven] value must be type 'string', received ${typeof a}`);
    }
    if (a.length % 2)
        a = `0${a}`;
    return a;
}
exports.padToEven = padToEven;
/**
 * Get the binary size of a string
 * @param str
 * @returns the number of bytes contained within the string
 */
function getBinarySize(str) {
    if (typeof str !== 'string') {
        throw new Error(`[getBinarySize] method requires input type 'string', received ${typeof str}`);
    }
    return Buffer.byteLength(str, 'utf8');
}
exports.getBinarySize = getBinarySize;
/**
 * Returns TRUE if the first specified array contains all elements
 * from the second one. FALSE otherwise.
 *
 * @param superset
 * @param subset
 *
 */
function arrayContainsArray(superset, subset, some) {
    if (Array.isArray(superset) !== true) {
        throw new Error(`[arrayContainsArray] method requires input 'superset' to be an array, got type '${typeof superset}'`);
    }
    if (Array.isArray(subset) !== true) {
        throw new Error(`[arrayContainsArray] method requires input 'subset' to be an array, got type '${typeof subset}'`);
    }
    return subset[some === true ? 'some' : 'every']((value) => superset.indexOf(value) >= 0);
}
exports.arrayContainsArray = arrayContainsArray;
/**
 * Should be called to get ascii from its hex representation
 *
 * @param string in hex
 * @returns ascii string representation of hex value
 */
function toAscii(hex) {
    let str = '';
    let i = 0;
    const l = hex.length;
    if (hex.substring(0, 2) === '0x')
        i = 2;
    for (; i < l; i += 2) {
        const code = parseInt(hex.substr(i, 2), 16);
        str += String.fromCharCode(code);
    }
    return str;
}
exports.toAscii = toAscii;
/**
 * Should be called to get hex representation (prefixed by 0x) of utf8 string
 *
 * @param string
 * @param optional padding
 * @returns hex representation of input string
 */
function fromUtf8(stringValue) {
    const str = Buffer.from(stringValue, 'utf8');
    return `0x${padToEven(str.toString('hex')).replace(/^0+|0+$/g, '')}`;
}
exports.fromUtf8 = fromUtf8;
/**
 * Should be called to get hex representation (prefixed by 0x) of ascii string
 *
 * @param  string
 * @param  optional padding
 * @returns  hex representation of input string
 */
function fromAscii(stringValue) {
    let hex = '';
    for (let i = 0; i < stringValue.length; i++) {
        const code = stringValue.charCodeAt(i);
        const n = code.toString(16);
        hex += n.length < 2 ? `0${n}` : n;
    }
    return `0x${hex}`;
}
exports.fromAscii = fromAscii;
/**
 * Returns the keys from an array of objects.
 * @example
 * ```js
 * getKeys([{a: '1', b: '2'}, {a: '3', b: '4'}], 'a') => ['1', '3']
 *````
 * @param  params
 * @param  key
 * @param  allowEmpty
 * @returns output just a simple array of output keys
 */
function getKeys(params, key, allowEmpty) {
    if (!Array.isArray(params)) {
        throw new Error(`[getKeys] method expects input 'params' to be an array, got ${typeof params}`);
    }
    if (typeof key !== 'string') {
        throw new Error(`[getKeys] method expects input 'key' to be type 'string', got ${typeof params}`);
    }
    const result = [];
    for (let i = 0; i < params.length; i++) {
        let value = params[i][key];
        if (allowEmpty === true && !value) {
            value = '';
        }
        else if (typeof value !== 'string') {
            throw new Error(`invalid abi - expected type 'string', received ${typeof value}`);
        }
        result.push(value);
    }
    return result;
}
exports.getKeys = getKeys;
/**
 * Is the string a hex string.
 *
 * @param  value
 * @param  length
 * @returns  output the string is a hex string
 */
function isHexString(value, length) {
    if (typeof value !== 'string' || !value.match(/^0x[0-9A-Fa-f]*$/))
        return false;
    if (typeof length !== 'undefined' && length > 0 && value.length !== 2 + 2 * length)
        return false;
    return true;
}
exports.isHexString = isHexString;

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\internal.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\lock.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Cutil%5Cdist%5Clock.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Lock = void 0;
// Based on https://github.com/jsoendermann/semaphore-async-await/blob/master/src/Semaphore.ts
class Lock {
    constructor() {
        this.permits = 1;
        this.promiseResolverQueue = [];
    }
    /**
     * Returns a promise used to wait for a permit to become available. This method should be awaited on.
     * @returns  A promise that gets resolved when execution is allowed to proceed.
     */
    async acquire() {
        if (this.permits > 0) {
            this.permits -= 1;
            return Promise.resolve(true);
        }
        // If there is no permit available, we return a promise that resolves once the semaphore gets
        // signaled enough times that permits is equal to one.
        return new Promise((resolver) => this.promiseResolverQueue.push(resolver));
    }
    /**
     * Increases the number of permits by one. If there are other functions waiting, one of them will
     * continue to execute in a future iteration of the event loop.
     */
    release() {
        this.permits += 1;
        if (this.permits > 1 && this.promiseResolverQueue.length > 0) {
            // eslint-disable-next-line no-console
            console.warn('Lock.permits should never be > 0 when there is someone waiting.');
        }
        else if (this.permits === 1 && this.promiseResolverQueue.length > 0) {
            // If there is someone else waiting, immediately consume the permit that was released
            // at the beginning of this function and let the waiting function resume.
            this.permits -= 1;
            const nextResolver = this.promiseResolverQueue.shift();
            if (nextResolver) {
                nextResolver(true);
            }
        }
    }
}
exports.Lock = Lock;

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\lock.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\provider.js", {"micro-ftch":"D:\\code\\v\\metamask-extension\\node_modules\\micro-ftch\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Cutil%5Cdist%5Cprovider.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getProvider = exports.fetchFromProvider = void 0;
const micro_ftch_1 = require("micro-ftch");
const fetchFromProvider = async (url, params) => {
    const res = await (0, micro_ftch_1.default)(url, {
        headers: {
            'content-type': 'application/json',
        },
        type: 'json',
        data: {
            method: params.method,
            params: params.params,
            jsonrpc: '2.0',
            id: 1,
        },
    });
    return res.result;
};
exports.fetchFromProvider = fetchFromProvider;
const getProvider = (provider) => {
    if (typeof provider === 'string') {
        return provider;
    }
    else if (provider?.connection?.url !== undefined) {
        return provider.connection.url;
    }
    else {
        throw new Error('Must provide valid provider URL or Web3Provider');
    }
};
exports.getProvider = getProvider;

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\provider.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\signature.js", {"./bytes":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\bytes.js","./constants":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\constants.js","./helpers":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\helpers.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js","ethereum-cryptography/keccak":"D:\\code\\v\\metamask-extension\\node_modules\\ethereum-cryptography\\keccak.js","ethereum-cryptography/secp256k1":"D:\\code\\v\\metamask-extension\\node_modules\\ethereum-cryptography\\secp256k1.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Cutil%5Cdist%5Csignature.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hashPersonalMessage = exports.isValidSignature = exports.fromRpcSig = exports.toCompactSig = exports.toRpcSig = exports.ecrecover = exports.ecsign = void 0;
const keccak_1 = require("ethereum-cryptography/keccak");
const secp256k1_1 = require("ethereum-cryptography/secp256k1");
const bytes_1 = require("./bytes");
const constants_1 = require("./constants");
const helpers_1 = require("./helpers");
/**
 * Returns the ECDSA signature of a message hash.
 *
 * If `chainId` is provided assume an EIP-155-style signature and calculate the `v` value
 * accordingly, otherwise return a "static" `v` just derived from the `recovery` bit
 */
function ecsign(msgHash, privateKey, chainId) {
    const sig = secp256k1_1.secp256k1.sign(msgHash, privateKey);
    const buf = sig.toCompactRawBytes();
    const r = Buffer.from(buf.slice(0, 32));
    const s = Buffer.from(buf.slice(32, 64));
    const v = chainId === undefined
        ? BigInt(sig.recovery + 27)
        : BigInt(sig.recovery + 35) + BigInt(chainId) * BigInt(2);
    return { r, s, v };
}
exports.ecsign = ecsign;
function calculateSigRecovery(v, chainId) {
    if (v === BigInt(0) || v === BigInt(1))
        return v;
    if (chainId === undefined) {
        return v - BigInt(27);
    }
    return v - (chainId * BigInt(2) + BigInt(35));
}
function isValidSigRecovery(recovery) {
    return recovery === BigInt(0) || recovery === BigInt(1);
}
/**
 * ECDSA public key recovery from signature.
 * NOTE: Accepts `v === 0 | v === 1` for EIP1559 transactions
 * @returns Recovered public key
 */
const ecrecover = function (msgHash, v, r, s, chainId) {
    const signature = Buffer.concat([(0, bytes_1.setLengthLeft)(r, 32), (0, bytes_1.setLengthLeft)(s, 32)], 64);
    const recovery = calculateSigRecovery(v, chainId);
    if (!isValidSigRecovery(recovery)) {
        throw new Error('Invalid signature v value');
    }
    const sig = secp256k1_1.secp256k1.Signature.fromCompact(signature).addRecoveryBit(Number(recovery));
    const senderPubKey = sig.recoverPublicKey(msgHash);
    return Buffer.from(senderPubKey.toRawBytes(false).slice(1));
};
exports.ecrecover = ecrecover;
/**
 * Convert signature parameters into the format of `eth_sign` RPC method.
 * NOTE: Accepts `v === 0 | v === 1` for EIP1559 transactions
 * @returns Signature
 */
const toRpcSig = function (v, r, s, chainId) {
    const recovery = calculateSigRecovery(v, chainId);
    if (!isValidSigRecovery(recovery)) {
        throw new Error('Invalid signature v value');
    }
    // geth (and the RPC eth_sign method) uses the 65 byte format used by Bitcoin
    return (0, bytes_1.bufferToHex)(Buffer.concat([(0, bytes_1.setLengthLeft)(r, 32), (0, bytes_1.setLengthLeft)(s, 32), (0, bytes_1.toBuffer)(v)]));
};
exports.toRpcSig = toRpcSig;
/**
 * Convert signature parameters into the format of Compact Signature Representation (EIP-2098).
 * NOTE: Accepts `v === 0 | v === 1` for EIP1559 transactions
 * @returns Signature
 */
const toCompactSig = function (v, r, s, chainId) {
    const recovery = calculateSigRecovery(v, chainId);
    if (!isValidSigRecovery(recovery)) {
        throw new Error('Invalid signature v value');
    }
    let ss = s;
    if ((v > BigInt(28) && v % BigInt(2) === BigInt(1)) || v === BigInt(1) || v === BigInt(28)) {
        ss = Buffer.from(s);
        ss[0] |= 0x80;
    }
    return (0, bytes_1.bufferToHex)(Buffer.concat([(0, bytes_1.setLengthLeft)(r, 32), (0, bytes_1.setLengthLeft)(ss, 32)]));
};
exports.toCompactSig = toCompactSig;
/**
 * Convert signature format of the `eth_sign` RPC method to signature parameters
 *
 * NOTE: For an extracted `v` value < 27 (see Geth bug https://github.com/ethereum/go-ethereum/issues/2053)
 * `v + 27` is returned for the `v` value
 * NOTE: After EIP1559, `v` could be `0` or `1` but this function assumes
 * it's a signed message (EIP-191 or EIP-712) adding `27` at the end. Remove if needed.
 */
const fromRpcSig = function (sig) {
    const buf = (0, bytes_1.toBuffer)(sig);
    let r;
    let s;
    let v;
    if (buf.length >= 65) {
        r = buf.slice(0, 32);
        s = buf.slice(32, 64);
        v = (0, bytes_1.bufferToBigInt)(buf.slice(64));
    }
    else if (buf.length === 64) {
        // Compact Signature Representation (https://eips.ethereum.org/EIPS/eip-2098)
        r = buf.slice(0, 32);
        s = buf.slice(32, 64);
        v = BigInt((0, bytes_1.bufferToInt)(buf.slice(32, 33)) >> 7);
        s[0] &= 0x7f;
    }
    else {
        throw new Error('Invalid signature length');
    }
    // support both versions of `eth_sign` responses
    if (v < 27) {
        v = v + BigInt(27);
    }
    return {
        v,
        r,
        s,
    };
};
exports.fromRpcSig = fromRpcSig;
/**
 * Validate a ECDSA signature.
 * NOTE: Accepts `v === 0 | v === 1` for EIP1559 transactions
 * @param homesteadOrLater Indicates whether this is being used on either the homestead hardfork or a later one
 */
const isValidSignature = function (v, r, s, homesteadOrLater = true, chainId) {
    if (r.length !== 32 || s.length !== 32) {
        return false;
    }
    if (!isValidSigRecovery(calculateSigRecovery(v, chainId))) {
        return false;
    }
    const rBigInt = (0, bytes_1.bufferToBigInt)(r);
    const sBigInt = (0, bytes_1.bufferToBigInt)(s);
    if (rBigInt === BigInt(0) ||
        rBigInt >= constants_1.SECP256K1_ORDER ||
        sBigInt === BigInt(0) ||
        sBigInt >= constants_1.SECP256K1_ORDER) {
        return false;
    }
    if (homesteadOrLater && sBigInt >= constants_1.SECP256K1_ORDER_DIV_2) {
        return false;
    }
    return true;
};
exports.isValidSignature = isValidSignature;
/**
 * Returns the keccak-256 hash of `message`, prefixed with the header used by the `eth_sign` RPC call.
 * The output of this function can be fed into `ecsign` to produce the same signature as the `eth_sign`
 * call for a given `message`, or fed to `ecrecover` along with a signature to recover the public key
 * used to produce the signature.
 */
const hashPersonalMessage = function (message) {
    (0, helpers_1.assertIsBuffer)(message);
    const prefix = Buffer.from(`\u0019Ethereum Signed Message:\n${message.length}`, 'utf-8');
    return Buffer.from((0, keccak_1.keccak256)(Buffer.concat([prefix, message])));
};
exports.hashPersonalMessage = hashPersonalMessage;

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\signature.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\types.js", {"./bytes":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\bytes.js","./internal":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\internal.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Cutil%5Cdist%5Ctypes.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toType = exports.TypeOutput = void 0;
const bytes_1 = require("./bytes");
const internal_1 = require("./internal");
/**
 * Type output options
 */
var TypeOutput;
(function (TypeOutput) {
    TypeOutput[TypeOutput["Number"] = 0] = "Number";
    TypeOutput[TypeOutput["BigInt"] = 1] = "BigInt";
    TypeOutput[TypeOutput["Buffer"] = 2] = "Buffer";
    TypeOutput[TypeOutput["PrefixedHexString"] = 3] = "PrefixedHexString";
})(TypeOutput = exports.TypeOutput || (exports.TypeOutput = {}));
function toType(input, outputType) {
    if (input === null) {
        return null;
    }
    if (input === undefined) {
        return undefined;
    }
    if (typeof input === 'string' && !(0, internal_1.isHexString)(input)) {
        throw new Error(`A string must be provided with a 0x-prefix, given: ${input}`);
    }
    else if (typeof input === 'number' && !Number.isSafeInteger(input)) {
        throw new Error('The provided number is greater than MAX_SAFE_INTEGER (please use an alternative input type)');
    }
    const output = (0, bytes_1.toBuffer)(input);
    switch (outputType) {
        case TypeOutput.Buffer:
            return output;
        case TypeOutput.BigInt:
            return (0, bytes_1.bufferToBigInt)(output);
        case TypeOutput.Number: {
            const bigInt = (0, bytes_1.bufferToBigInt)(output);
            if (bigInt > BigInt(Number.MAX_SAFE_INTEGER)) {
                throw new Error('The provided number is greater than MAX_SAFE_INTEGER (please use an alternative output type)');
            }
            return Number(bigInt);
        }
        case TypeOutput.PrefixedHexString:
            return (0, bytes_1.bufferToHex)(output);
        default:
            throw new Error('unknown outputType');
    }
}
exports.toType = toType;

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\types.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\units.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Cutil%5Cdist%5Cunits.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GWEI_TO_WEI = void 0;
/** Easy conversion from Gwei to wei */
exports.GWEI_TO_WEI = BigInt(1000000000);

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\units.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\withdrawal.js", {"./address":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\address.js","./bytes":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\bytes.js","./types":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\types.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5C@ethereumjs%5Cutil%5Cdist%5Cwithdrawal.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Withdrawal = void 0;
const address_1 = require("./address");
const bytes_1 = require("./bytes");
const types_1 = require("./types");
/**
 * Representation of EIP-4895 withdrawal data
 */
class Withdrawal {
    /**
     * This constructor assigns and validates the values.
     * Use the static factory methods to assist in creating a Withdrawal object from varying data types.
     * Its amount is in Gwei to match CL representation and for eventual ssz withdrawalsRoot
     */
    constructor(index, validatorIndex, address, 
    /**
     * withdrawal amount in Gwei to match the CL repesentation and eventually ssz withdrawalsRoot
     */
    amount) {
        this.index = index;
        this.validatorIndex = validatorIndex;
        this.address = address;
        this.amount = amount;
    }
    static fromWithdrawalData(withdrawalData) {
        const { index: indexData, validatorIndex: validatorIndexData, address: addressData, amount: amountData, } = withdrawalData;
        const index = (0, types_1.toType)(indexData, types_1.TypeOutput.BigInt);
        const validatorIndex = (0, types_1.toType)(validatorIndexData, types_1.TypeOutput.BigInt);
        const address = new address_1.Address((0, types_1.toType)(addressData, types_1.TypeOutput.Buffer));
        const amount = (0, types_1.toType)(amountData, types_1.TypeOutput.BigInt);
        return new Withdrawal(index, validatorIndex, address, amount);
    }
    static fromValuesArray(withdrawalArray) {
        if (withdrawalArray.length !== 4) {
            throw Error(`Invalid withdrawalArray length expected=4 actual=${withdrawalArray.length}`);
        }
        const [index, validatorIndex, address, amount] = withdrawalArray;
        return Withdrawal.fromWithdrawalData({ index, validatorIndex, address, amount });
    }
    /**
     * Convert a withdrawal to a buffer array
     * @param withdrawal the withdrawal to convert
     * @returns buffer array of the withdrawal
     */
    static toBufferArray(withdrawal) {
        const { index, validatorIndex, address, amount } = withdrawal;
        const indexBuffer = (0, types_1.toType)(index, types_1.TypeOutput.BigInt) === BigInt(0)
            ? Buffer.alloc(0)
            : (0, types_1.toType)(index, types_1.TypeOutput.Buffer);
        const validatorIndexBuffer = (0, types_1.toType)(validatorIndex, types_1.TypeOutput.BigInt) === BigInt(0)
            ? Buffer.alloc(0)
            : (0, types_1.toType)(validatorIndex, types_1.TypeOutput.Buffer);
        let addressBuffer;
        if (address instanceof address_1.Address) {
            addressBuffer = address.buf;
        }
        else {
            addressBuffer = (0, types_1.toType)(address, types_1.TypeOutput.Buffer);
        }
        const amountBuffer = (0, types_1.toType)(amount, types_1.TypeOutput.BigInt) === BigInt(0)
            ? Buffer.alloc(0)
            : (0, types_1.toType)(amount, types_1.TypeOutput.Buffer);
        return [indexBuffer, validatorIndexBuffer, addressBuffer, amountBuffer];
    }
    raw() {
        return Withdrawal.toBufferArray(this);
    }
    toValue() {
        return {
            index: this.index,
            validatorIndex: this.validatorIndex,
            address: this.address.buf,
            amount: this.amount,
        };
    }
    toJSON() {
        return {
            index: (0, bytes_1.bigIntToHex)(this.index),
            validatorIndex: (0, bytes_1.bigIntToHex)(this.validatorIndex),
            address: '0x' + this.address.buf.toString('hex'),
            amount: (0, bytes_1.bigIntToHex)(this.amount),
        };
    }
}
exports.Withdrawal = Withdrawal;

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>@ethereumjs/common>@ethereumjs/util",file:"node_modules\\gridplus-sdk\\node_modules\\@ethereumjs\\util\\dist\\withdrawal.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\bignumber.js\\bignumber.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5Cbignumber.js%5Cbignumber.js
      return function (require, module, exports) {
;(function (globalObject) {
  'use strict';

/*
 *      bignumber.js v9.3.0
 *      A JavaScript library for arbitrary-precision arithmetic.
 *      https://github.com/MikeMcl/bignumber.js
 *      Copyright (c) 2025 Michael Mclaughlin <M8ch88l@gmail.com>
 *      MIT Licensed.
 *
 *      BigNumber.prototype methods     |  BigNumber methods
 *                                      |
 *      absoluteValue            abs    |  clone
 *      comparedTo                      |  config               set
 *      decimalPlaces            dp     |      DECIMAL_PLACES
 *      dividedBy                div    |      ROUNDING_MODE
 *      dividedToIntegerBy       idiv   |      EXPONENTIAL_AT
 *      exponentiatedBy          pow    |      RANGE
 *      integerValue                    |      CRYPTO
 *      isEqualTo                eq     |      MODULO_MODE
 *      isFinite                        |      POW_PRECISION
 *      isGreaterThan            gt     |      FORMAT
 *      isGreaterThanOrEqualTo   gte    |      ALPHABET
 *      isInteger                       |  isBigNumber
 *      isLessThan               lt     |  maximum              max
 *      isLessThanOrEqualTo      lte    |  minimum              min
 *      isNaN                           |  random
 *      isNegative                      |  sum
 *      isPositive                      |
 *      isZero                          |
 *      minus                           |
 *      modulo                   mod    |
 *      multipliedBy             times  |
 *      negated                         |
 *      plus                            |
 *      precision                sd     |
 *      shiftedBy                       |
 *      squareRoot               sqrt   |
 *      toExponential                   |
 *      toFixed                         |
 *      toFormat                        |
 *      toFraction                      |
 *      toJSON                          |
 *      toNumber                        |
 *      toPrecision                     |
 *      toString                        |
 *      valueOf                         |
 *
 */


  var BigNumber,
    isNumeric = /^-?(?:\d+(?:\.\d*)?|\.\d+)(?:e[+-]?\d+)?$/i,
    mathceil = Math.ceil,
    mathfloor = Math.floor,

    bignumberError = '[BigNumber Error] ',
    tooManyDigits = bignumberError + 'Number primitive has more than 15 significant digits: ',

    BASE = 1e14,
    LOG_BASE = 14,
    MAX_SAFE_INTEGER = 0x1fffffffffffff,         // 2^53 - 1
    // MAX_INT32 = 0x7fffffff,                   // 2^31 - 1
    POWS_TEN = [1, 10, 100, 1e3, 1e4, 1e5, 1e6, 1e7, 1e8, 1e9, 1e10, 1e11, 1e12, 1e13],
    SQRT_BASE = 1e7,

    // EDITABLE
    // The limit on the value of DECIMAL_PLACES, TO_EXP_NEG, TO_EXP_POS, MIN_EXP, MAX_EXP, and
    // the arguments to toExponential, toFixed, toFormat, and toPrecision.
    MAX = 1E9;                                   // 0 to MAX_INT32


  /*
   * Create and return a BigNumber constructor.
   */
  function clone(configObject) {
    var div, convertBase, parseNumeric,
      P = BigNumber.prototype = { constructor: BigNumber, toString: null, valueOf: null },
      ONE = new BigNumber(1),


      //----------------------------- EDITABLE CONFIG DEFAULTS -------------------------------


      // The default values below must be integers within the inclusive ranges stated.
      // The values can also be changed at run-time using BigNumber.set.

      // The maximum number of decimal places for operations involving division.
      DECIMAL_PLACES = 20,                     // 0 to MAX

      // The rounding mode used when rounding to the above decimal places, and when using
      // toExponential, toFixed, toFormat and toPrecision, and round (default value).
      // UP         0 Away from zero.
      // DOWN       1 Towards zero.
      // CEIL       2 Towards +Infinity.
      // FLOOR      3 Towards -Infinity.
      // HALF_UP    4 Towards nearest neighbour. If equidistant, up.
      // HALF_DOWN  5 Towards nearest neighbour. If equidistant, down.
      // HALF_EVEN  6 Towards nearest neighbour. If equidistant, towards even neighbour.
      // HALF_CEIL  7 Towards nearest neighbour. If equidistant, towards +Infinity.
      // HALF_FLOOR 8 Towards nearest neighbour. If equidistant, towards -Infinity.
      ROUNDING_MODE = 4,                       // 0 to 8

      // EXPONENTIAL_AT : [TO_EXP_NEG , TO_EXP_POS]

      // The exponent value at and beneath which toString returns exponential notation.
      // Number type: -7
      TO_EXP_NEG = -7,                         // 0 to -MAX

      // The exponent value at and above which toString returns exponential notation.
      // Number type: 21
      TO_EXP_POS = 21,                         // 0 to MAX

      // RANGE : [MIN_EXP, MAX_EXP]

      // The minimum exponent value, beneath which underflow to zero occurs.
      // Number type: -324  (5e-324)
      MIN_EXP = -1e7,                          // -1 to -MAX

      // The maximum exponent value, above which overflow to Infinity occurs.
      // Number type:  308  (1.7976931348623157e+308)
      // For MAX_EXP > 1e7, e.g. new BigNumber('1e100000000').plus(1) may be slow.
      MAX_EXP = 1e7,                           // 1 to MAX

      // Whether to use cryptographically-secure random number generation, if available.
      CRYPTO = false,                          // true or false

      // The modulo mode used when calculating the modulus: a mod n.
      // The quotient (q = a / n) is calculated according to the corresponding rounding mode.
      // The remainder (r) is calculated as: r = a - n * q.
      //
      // UP        0 The remainder is positive if the dividend is negative, else is negative.
      // DOWN      1 The remainder has the same sign as the dividend.
      //             This modulo mode is commonly known as 'truncated division' and is
      //             equivalent to (a % n) in JavaScript.
      // FLOOR     3 The remainder has the same sign as the divisor (Python %).
      // HALF_EVEN 6 This modulo mode implements the IEEE 754 remainder function.
      // EUCLID    9 Euclidian division. q = sign(n) * floor(a / abs(n)).
      //             The remainder is always positive.
      //
      // The truncated division, floored division, Euclidian division and IEEE 754 remainder
      // modes are commonly used for the modulus operation.
      // Although the other rounding modes can also be used, they may not give useful results.
      MODULO_MODE = 1,                         // 0 to 9

      // The maximum number of significant digits of the result of the exponentiatedBy operation.
      // If POW_PRECISION is 0, there will be unlimited significant digits.
      POW_PRECISION = 0,                       // 0 to MAX

      // The format specification used by the BigNumber.prototype.toFormat method.
      FORMAT = {
        prefix: '',
        groupSize: 3,
        secondaryGroupSize: 0,
        groupSeparator: ',',
        decimalSeparator: '.',
        fractionGroupSize: 0,
        fractionGroupSeparator: '\xA0',        // non-breaking space
        suffix: ''
      },

      // The alphabet used for base conversion. It must be at least 2 characters long, with no '+',
      // '-', '.', whitespace, or repeated character.
      // '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$_'
      ALPHABET = '0123456789abcdefghijklmnopqrstuvwxyz',
      alphabetHasNormalDecimalDigits = true;


    //------------------------------------------------------------------------------------------


    // CONSTRUCTOR


    /*
     * The BigNumber constructor and exported function.
     * Create and return a new instance of a BigNumber object.
     *
     * v {number|string|BigNumber} A numeric value.
     * [b] {number} The base of v. Integer, 2 to ALPHABET.length inclusive.
     */
    function BigNumber(v, b) {
      var alphabet, c, caseChanged, e, i, isNum, len, str,
        x = this;

      // Enable constructor call without `new`.
      if (!(x instanceof BigNumber)) return new BigNumber(v, b);

      if (b == null) {

        if (v && v._isBigNumber === true) {
          x.s = v.s;

          if (!v.c || v.e > MAX_EXP) {
            x.c = x.e = null;
          } else if (v.e < MIN_EXP) {
            x.c = [x.e = 0];
          } else {
            x.e = v.e;
            x.c = v.c.slice();
          }

          return;
        }

        if ((isNum = typeof v == 'number') && v * 0 == 0) {

          // Use `1 / n` to handle minus zero also.
          x.s = 1 / v < 0 ? (v = -v, -1) : 1;

          // Fast path for integers, where n < 2147483648 (2**31).
          if (v === ~~v) {
            for (e = 0, i = v; i >= 10; i /= 10, e++);

            if (e > MAX_EXP) {
              x.c = x.e = null;
            } else {
              x.e = e;
              x.c = [v];
            }

            return;
          }

          str = String(v);
        } else {

          if (!isNumeric.test(str = String(v))) return parseNumeric(x, str, isNum);

          x.s = str.charCodeAt(0) == 45 ? (str = str.slice(1), -1) : 1;
        }

        // Decimal point?
        if ((e = str.indexOf('.')) > -1) str = str.replace('.', '');

        // Exponential form?
        if ((i = str.search(/e/i)) > 0) {

          // Determine exponent.
          if (e < 0) e = i;
          e += +str.slice(i + 1);
          str = str.substring(0, i);
        } else if (e < 0) {

          // Integer.
          e = str.length;
        }

      } else {

        // '[BigNumber Error] Base {not a primitive number|not an integer|out of range}: {b}'
        intCheck(b, 2, ALPHABET.length, 'Base');

        // Allow exponential notation to be used with base 10 argument, while
        // also rounding to DECIMAL_PLACES as with other bases.
        if (b == 10 && alphabetHasNormalDecimalDigits) {
          x = new BigNumber(v);
          return round(x, DECIMAL_PLACES + x.e + 1, ROUNDING_MODE);
        }

        str = String(v);

        if (isNum = typeof v == 'number') {

          // Avoid potential interpretation of Infinity and NaN as base 44+ values.
          if (v * 0 != 0) return parseNumeric(x, str, isNum, b);

          x.s = 1 / v < 0 ? (str = str.slice(1), -1) : 1;

          // '[BigNumber Error] Number primitive has more than 15 significant digits: {n}'
          if (BigNumber.DEBUG && str.replace(/^0\.0*|\./, '').length > 15) {
            throw Error
             (tooManyDigits + v);
          }
        } else {
          x.s = str.charCodeAt(0) === 45 ? (str = str.slice(1), -1) : 1;
        }

        alphabet = ALPHABET.slice(0, b);
        e = i = 0;

        // Check that str is a valid base b number.
        // Don't use RegExp, so alphabet can contain special characters.
        for (len = str.length; i < len; i++) {
          if (alphabet.indexOf(c = str.charAt(i)) < 0) {
            if (c == '.') {

              // If '.' is not the first character and it has not be found before.
              if (i > e) {
                e = len;
                continue;
              }
            } else if (!caseChanged) {

              // Allow e.g. hexadecimal 'FF' as well as 'ff'.
              if (str == str.toUpperCase() && (str = str.toLowerCase()) ||
                  str == str.toLowerCase() && (str = str.toUpperCase())) {
                caseChanged = true;
                i = -1;
                e = 0;
                continue;
              }
            }

            return parseNumeric(x, String(v), isNum, b);
          }
        }

        // Prevent later check for length on converted number.
        isNum = false;
        str = convertBase(str, b, 10, x.s);

        // Decimal point?
        if ((e = str.indexOf('.')) > -1) str = str.replace('.', '');
        else e = str.length;
      }

      // Determine leading zeros.
      for (i = 0; str.charCodeAt(i) === 48; i++);

      // Determine trailing zeros.
      for (len = str.length; str.charCodeAt(--len) === 48;);

      if (str = str.slice(i, ++len)) {
        len -= i;

        // '[BigNumber Error] Number primitive has more than 15 significant digits: {n}'
        if (isNum && BigNumber.DEBUG &&
          len > 15 && (v > MAX_SAFE_INTEGER || v !== mathfloor(v))) {
            throw Error
             (tooManyDigits + (x.s * v));
        }

         // Overflow?
        if ((e = e - i - 1) > MAX_EXP) {

          // Infinity.
          x.c = x.e = null;

        // Underflow?
        } else if (e < MIN_EXP) {

          // Zero.
          x.c = [x.e = 0];
        } else {
          x.e = e;
          x.c = [];

          // Transform base

          // e is the base 10 exponent.
          // i is where to slice str to get the first element of the coefficient array.
          i = (e + 1) % LOG_BASE;
          if (e < 0) i += LOG_BASE;  // i < 1

          if (i < len) {
            if (i) x.c.push(+str.slice(0, i));

            for (len -= LOG_BASE; i < len;) {
              x.c.push(+str.slice(i, i += LOG_BASE));
            }

            i = LOG_BASE - (str = str.slice(i)).length;
          } else {
            i -= len;
          }

          for (; i--; str += '0');
          x.c.push(+str);
        }
      } else {

        // Zero.
        x.c = [x.e = 0];
      }
    }


    // CONSTRUCTOR PROPERTIES


    BigNumber.clone = clone;

    BigNumber.ROUND_UP = 0;
    BigNumber.ROUND_DOWN = 1;
    BigNumber.ROUND_CEIL = 2;
    BigNumber.ROUND_FLOOR = 3;
    BigNumber.ROUND_HALF_UP = 4;
    BigNumber.ROUND_HALF_DOWN = 5;
    BigNumber.ROUND_HALF_EVEN = 6;
    BigNumber.ROUND_HALF_CEIL = 7;
    BigNumber.ROUND_HALF_FLOOR = 8;
    BigNumber.EUCLID = 9;


    /*
     * Configure infrequently-changing library-wide settings.
     *
     * Accept an object with the following optional properties (if the value of a property is
     * a number, it must be an integer within the inclusive range stated):
     *
     *   DECIMAL_PLACES   {number}           0 to MAX
     *   ROUNDING_MODE    {number}           0 to 8
     *   EXPONENTIAL_AT   {number|number[]}  -MAX to MAX  or  [-MAX to 0, 0 to MAX]
     *   RANGE            {number|number[]}  -MAX to MAX (not zero)  or  [-MAX to -1, 1 to MAX]
     *   CRYPTO           {boolean}          true or false
     *   MODULO_MODE      {number}           0 to 9
     *   POW_PRECISION       {number}           0 to MAX
     *   ALPHABET         {string}           A string of two or more unique characters which does
     *                                       not contain '.'.
     *   FORMAT           {object}           An object with some of the following properties:
     *     prefix                 {string}
     *     groupSize              {number}
     *     secondaryGroupSize     {number}
     *     groupSeparator         {string}
     *     decimalSeparator       {string}
     *     fractionGroupSize      {number}
     *     fractionGroupSeparator {string}
     *     suffix                 {string}
     *
     * (The values assigned to the above FORMAT object properties are not checked for validity.)
     *
     * E.g.
     * BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 4 })
     *
     * Ignore properties/parameters set to null or undefined, except for ALPHABET.
     *
     * Return an object with the properties current values.
     */
    BigNumber.config = BigNumber.set = function (obj) {
      var p, v;

      if (obj != null) {

        if (typeof obj == 'object') {

          // DECIMAL_PLACES {number} Integer, 0 to MAX inclusive.
          // '[BigNumber Error] DECIMAL_PLACES {not a primitive number|not an integer|out of range}: {v}'
          if (obj.hasOwnProperty(p = 'DECIMAL_PLACES')) {
            v = obj[p];
            intCheck(v, 0, MAX, p);
            DECIMAL_PLACES = v;
          }

          // ROUNDING_MODE {number} Integer, 0 to 8 inclusive.
          // '[BigNumber Error] ROUNDING_MODE {not a primitive number|not an integer|out of range}: {v}'
          if (obj.hasOwnProperty(p = 'ROUNDING_MODE')) {
            v = obj[p];
            intCheck(v, 0, 8, p);
            ROUNDING_MODE = v;
          }

          // EXPONENTIAL_AT {number|number[]}
          // Integer, -MAX to MAX inclusive or
          // [integer -MAX to 0 inclusive, 0 to MAX inclusive].
          // '[BigNumber Error] EXPONENTIAL_AT {not a primitive number|not an integer|out of range}: {v}'
          if (obj.hasOwnProperty(p = 'EXPONENTIAL_AT')) {
            v = obj[p];
            if (v && v.pop) {
              intCheck(v[0], -MAX, 0, p);
              intCheck(v[1], 0, MAX, p);
              TO_EXP_NEG = v[0];
              TO_EXP_POS = v[1];
            } else {
              intCheck(v, -MAX, MAX, p);
              TO_EXP_NEG = -(TO_EXP_POS = v < 0 ? -v : v);
            }
          }

          // RANGE {number|number[]} Non-zero integer, -MAX to MAX inclusive or
          // [integer -MAX to -1 inclusive, integer 1 to MAX inclusive].
          // '[BigNumber Error] RANGE {not a primitive number|not an integer|out of range|cannot be zero}: {v}'
          if (obj.hasOwnProperty(p = 'RANGE')) {
            v = obj[p];
            if (v && v.pop) {
              intCheck(v[0], -MAX, -1, p);
              intCheck(v[1], 1, MAX, p);
              MIN_EXP = v[0];
              MAX_EXP = v[1];
            } else {
              intCheck(v, -MAX, MAX, p);
              if (v) {
                MIN_EXP = -(MAX_EXP = v < 0 ? -v : v);
              } else {
                throw Error
                 (bignumberError + p + ' cannot be zero: ' + v);
              }
            }
          }

          // CRYPTO {boolean} true or false.
          // '[BigNumber Error] CRYPTO not true or false: {v}'
          // '[BigNumber Error] crypto unavailable'
          if (obj.hasOwnProperty(p = 'CRYPTO')) {
            v = obj[p];
            if (v === !!v) {
              if (v) {
                if (typeof crypto != 'undefined' && crypto &&
                 (crypto.getRandomValues || crypto.randomBytes)) {
                  CRYPTO = v;
                } else {
                  CRYPTO = !v;
                  throw Error
                   (bignumberError + 'crypto unavailable');
                }
              } else {
                CRYPTO = v;
              }
            } else {
              throw Error
               (bignumberError + p + ' not true or false: ' + v);
            }
          }

          // MODULO_MODE {number} Integer, 0 to 9 inclusive.
          // '[BigNumber Error] MODULO_MODE {not a primitive number|not an integer|out of range}: {v}'
          if (obj.hasOwnProperty(p = 'MODULO_MODE')) {
            v = obj[p];
            intCheck(v, 0, 9, p);
            MODULO_MODE = v;
          }

          // POW_PRECISION {number} Integer, 0 to MAX inclusive.
          // '[BigNumber Error] POW_PRECISION {not a primitive number|not an integer|out of range}: {v}'
          if (obj.hasOwnProperty(p = 'POW_PRECISION')) {
            v = obj[p];
            intCheck(v, 0, MAX, p);
            POW_PRECISION = v;
          }

          // FORMAT {object}
          // '[BigNumber Error] FORMAT not an object: {v}'
          if (obj.hasOwnProperty(p = 'FORMAT')) {
            v = obj[p];
            if (typeof v == 'object') FORMAT = v;
            else throw Error
             (bignumberError + p + ' not an object: ' + v);
          }

          // ALPHABET {string}
          // '[BigNumber Error] ALPHABET invalid: {v}'
          if (obj.hasOwnProperty(p = 'ALPHABET')) {
            v = obj[p];

            // Disallow if less than two characters,
            // or if it contains '+', '-', '.', whitespace, or a repeated character.
            if (typeof v == 'string' && !/^.?$|[+\-.\s]|(.).*\1/.test(v)) {
              alphabetHasNormalDecimalDigits = v.slice(0, 10) == '0123456789';
              ALPHABET = v;
            } else {
              throw Error
               (bignumberError + p + ' invalid: ' + v);
            }
          }

        } else {

          // '[BigNumber Error] Object expected: {v}'
          throw Error
           (bignumberError + 'Object expected: ' + obj);
        }
      }

      return {
        DECIMAL_PLACES: DECIMAL_PLACES,
        ROUNDING_MODE: ROUNDING_MODE,
        EXPONENTIAL_AT: [TO_EXP_NEG, TO_EXP_POS],
        RANGE: [MIN_EXP, MAX_EXP],
        CRYPTO: CRYPTO,
        MODULO_MODE: MODULO_MODE,
        POW_PRECISION: POW_PRECISION,
        FORMAT: FORMAT,
        ALPHABET: ALPHABET
      };
    };


    /*
     * Return true if v is a BigNumber instance, otherwise return false.
     *
     * If BigNumber.DEBUG is true, throw if a BigNumber instance is not well-formed.
     *
     * v {any}
     *
     * '[BigNumber Error] Invalid BigNumber: {v}'
     */
    BigNumber.isBigNumber = function (v) {
      if (!v || v._isBigNumber !== true) return false;
      if (!BigNumber.DEBUG) return true;

      var i, n,
        c = v.c,
        e = v.e,
        s = v.s;

      out: if ({}.toString.call(c) == '[object Array]') {

        if ((s === 1 || s === -1) && e >= -MAX && e <= MAX && e === mathfloor(e)) {

          // If the first element is zero, the BigNumber value must be zero.
          if (c[0] === 0) {
            if (e === 0 && c.length === 1) return true;
            break out;
          }

          // Calculate number of digits that c[0] should have, based on the exponent.
          i = (e + 1) % LOG_BASE;
          if (i < 1) i += LOG_BASE;

          // Calculate number of digits of c[0].
          //if (Math.ceil(Math.log(c[0] + 1) / Math.LN10) == i) {
          if (String(c[0]).length == i) {

            for (i = 0; i < c.length; i++) {
              n = c[i];
              if (n < 0 || n >= BASE || n !== mathfloor(n)) break out;
            }

            // Last element cannot be zero, unless it is the only element.
            if (n !== 0) return true;
          }
        }

      // Infinity/NaN
      } else if (c === null && e === null && (s === null || s === 1 || s === -1)) {
        return true;
      }

      throw Error
        (bignumberError + 'Invalid BigNumber: ' + v);
    };


    /*
     * Return a new BigNumber whose value is the maximum of the arguments.
     *
     * arguments {number|string|BigNumber}
     */
    BigNumber.maximum = BigNumber.max = function () {
      return maxOrMin(arguments, -1);
    };


    /*
     * Return a new BigNumber whose value is the minimum of the arguments.
     *
     * arguments {number|string|BigNumber}
     */
    BigNumber.minimum = BigNumber.min = function () {
      return maxOrMin(arguments, 1);
    };


    /*
     * Return a new BigNumber with a random value equal to or greater than 0 and less than 1,
     * and with dp, or DECIMAL_PLACES if dp is omitted, decimal places (or less if trailing
     * zeros are produced).
     *
     * [dp] {number} Decimal places. Integer, 0 to MAX inclusive.
     *
     * '[BigNumber Error] Argument {not a primitive number|not an integer|out of range}: {dp}'
     * '[BigNumber Error] crypto unavailable'
     */
    BigNumber.random = (function () {
      var pow2_53 = 0x20000000000000;

      // Return a 53 bit integer n, where 0 <= n < 9007199254740992.
      // Check if Math.random() produces more than 32 bits of randomness.
      // If it does, assume at least 53 bits are produced, otherwise assume at least 30 bits.
      // 0x40000000 is 2^30, 0x800000 is 2^23, 0x1fffff is 2^21 - 1.
      var random53bitInt = (Math.random() * pow2_53) & 0x1fffff
       ? function () { return mathfloor(Math.random() * pow2_53); }
       : function () { return ((Math.random() * 0x40000000 | 0) * 0x800000) +
         (Math.random() * 0x800000 | 0); };

      return function (dp) {
        var a, b, e, k, v,
          i = 0,
          c = [],
          rand = new BigNumber(ONE);

        if (dp == null) dp = DECIMAL_PLACES;
        else intCheck(dp, 0, MAX);

        k = mathceil(dp / LOG_BASE);

        if (CRYPTO) {

          // Browsers supporting crypto.getRandomValues.
          if (crypto.getRandomValues) {

            a = crypto.getRandomValues(new Uint32Array(k *= 2));

            for (; i < k;) {

              // 53 bits:
              // ((Math.pow(2, 32) - 1) * Math.pow(2, 21)).toString(2)
              // 11111 11111111 11111111 11111111 11100000 00000000 00000000
              // ((Math.pow(2, 32) - 1) >>> 11).toString(2)
              //                                     11111 11111111 11111111
              // 0x20000 is 2^21.
              v = a[i] * 0x20000 + (a[i + 1] >>> 11);

              // Rejection sampling:
              // 0 <= v < 9007199254740992
              // Probability that v >= 9e15, is
              // 7199254740992 / 9007199254740992 ~= 0.0008, i.e. 1 in 1251
              if (v >= 9e15) {
                b = crypto.getRandomValues(new Uint32Array(2));
                a[i] = b[0];
                a[i + 1] = b[1];
              } else {

                // 0 <= v <= 8999999999999999
                // 0 <= (v % 1e14) <= 99999999999999
                c.push(v % 1e14);
                i += 2;
              }
            }
            i = k / 2;

          // Node.js supporting crypto.randomBytes.
          } else if (crypto.randomBytes) {

            // buffer
            a = crypto.randomBytes(k *= 7);

            for (; i < k;) {

              // 0x1000000000000 is 2^48, 0x10000000000 is 2^40
              // 0x100000000 is 2^32, 0x1000000 is 2^24
              // 11111 11111111 11111111 11111111 11111111 11111111 11111111
              // 0 <= v < 9007199254740992
              v = ((a[i] & 31) * 0x1000000000000) + (a[i + 1] * 0x10000000000) +
                 (a[i + 2] * 0x100000000) + (a[i + 3] * 0x1000000) +
                 (a[i + 4] << 16) + (a[i + 5] << 8) + a[i + 6];

              if (v >= 9e15) {
                crypto.randomBytes(7).copy(a, i);
              } else {

                // 0 <= (v % 1e14) <= 99999999999999
                c.push(v % 1e14);
                i += 7;
              }
            }
            i = k / 7;
          } else {
            CRYPTO = false;
            throw Error
             (bignumberError + 'crypto unavailable');
          }
        }

        // Use Math.random.
        if (!CRYPTO) {

          for (; i < k;) {
            v = random53bitInt();
            if (v < 9e15) c[i++] = v % 1e14;
          }
        }

        k = c[--i];
        dp %= LOG_BASE;

        // Convert trailing digits to zeros according to dp.
        if (k && dp) {
          v = POWS_TEN[LOG_BASE - dp];
          c[i] = mathfloor(k / v) * v;
        }

        // Remove trailing elements which are zero.
        for (; c[i] === 0; c.pop(), i--);

        // Zero?
        if (i < 0) {
          c = [e = 0];
        } else {

          // Remove leading elements which are zero and adjust exponent accordingly.
          for (e = -1 ; c[0] === 0; c.splice(0, 1), e -= LOG_BASE);

          // Count the digits of the first element of c to determine leading zeros, and...
          for (i = 1, v = c[0]; v >= 10; v /= 10, i++);

          // adjust the exponent accordingly.
          if (i < LOG_BASE) e -= LOG_BASE - i;
        }

        rand.e = e;
        rand.c = c;
        return rand;
      };
    })();


    /*
     * Return a BigNumber whose value is the sum of the arguments.
     *
     * arguments {number|string|BigNumber}
     */
    BigNumber.sum = function () {
      var i = 1,
        args = arguments,
        sum = new BigNumber(args[0]);
      for (; i < args.length;) sum = sum.plus(args[i++]);
      return sum;
    };


    // PRIVATE FUNCTIONS


    // Called by BigNumber and BigNumber.prototype.toString.
    convertBase = (function () {
      var decimal = '0123456789';

      /*
       * Convert string of baseIn to an array of numbers of baseOut.
       * Eg. toBaseOut('255', 10, 16) returns [15, 15].
       * Eg. toBaseOut('ff', 16, 10) returns [2, 5, 5].
       */
      function toBaseOut(str, baseIn, baseOut, alphabet) {
        var j,
          arr = [0],
          arrL,
          i = 0,
          len = str.length;

        for (; i < len;) {
          for (arrL = arr.length; arrL--; arr[arrL] *= baseIn);

          arr[0] += alphabet.indexOf(str.charAt(i++));

          for (j = 0; j < arr.length; j++) {

            if (arr[j] > baseOut - 1) {
              if (arr[j + 1] == null) arr[j + 1] = 0;
              arr[j + 1] += arr[j] / baseOut | 0;
              arr[j] %= baseOut;
            }
          }
        }

        return arr.reverse();
      }

      // Convert a numeric string of baseIn to a numeric string of baseOut.
      // If the caller is toString, we are converting from base 10 to baseOut.
      // If the caller is BigNumber, we are converting from baseIn to base 10.
      return function (str, baseIn, baseOut, sign, callerIsToString) {
        var alphabet, d, e, k, r, x, xc, y,
          i = str.indexOf('.'),
          dp = DECIMAL_PLACES,
          rm = ROUNDING_MODE;

        // Non-integer.
        if (i >= 0) {
          k = POW_PRECISION;

          // Unlimited precision.
          POW_PRECISION = 0;
          str = str.replace('.', '');
          y = new BigNumber(baseIn);
          x = y.pow(str.length - i);
          POW_PRECISION = k;

          // Convert str as if an integer, then restore the fraction part by dividing the
          // result by its base raised to a power.

          y.c = toBaseOut(toFixedPoint(coeffToString(x.c), x.e, '0'),
           10, baseOut, decimal);
          y.e = y.c.length;
        }

        // Convert the number as integer.

        xc = toBaseOut(str, baseIn, baseOut, callerIsToString
         ? (alphabet = ALPHABET, decimal)
         : (alphabet = decimal, ALPHABET));

        // xc now represents str as an integer and converted to baseOut. e is the exponent.
        e = k = xc.length;

        // Remove trailing zeros.
        for (; xc[--k] == 0; xc.pop());

        // Zero?
        if (!xc[0]) return alphabet.charAt(0);

        // Does str represent an integer? If so, no need for the division.
        if (i < 0) {
          --e;
        } else {
          x.c = xc;
          x.e = e;

          // The sign is needed for correct rounding.
          x.s = sign;
          x = div(x, y, dp, rm, baseOut);
          xc = x.c;
          r = x.r;
          e = x.e;
        }

        // xc now represents str converted to baseOut.

        // The index of the rounding digit.
        d = e + dp + 1;

        // The rounding digit: the digit to the right of the digit that may be rounded up.
        i = xc[d];

        // Look at the rounding digits and mode to determine whether to round up.

        k = baseOut / 2;
        r = r || d < 0 || xc[d + 1] != null;

        r = rm < 4 ? (i != null || r) && (rm == 0 || rm == (x.s < 0 ? 3 : 2))
              : i > k || i == k &&(rm == 4 || r || rm == 6 && xc[d - 1] & 1 ||
               rm == (x.s < 0 ? 8 : 7));

        // If the index of the rounding digit is not greater than zero, or xc represents
        // zero, then the result of the base conversion is zero or, if rounding up, a value
        // such as 0.00001.
        if (d < 1 || !xc[0]) {

          // 1^-dp or 0
          str = r ? toFixedPoint(alphabet.charAt(1), -dp, alphabet.charAt(0)) : alphabet.charAt(0);
        } else {

          // Truncate xc to the required number of decimal places.
          xc.length = d;

          // Round up?
          if (r) {

            // Rounding up may mean the previous digit has to be rounded up and so on.
            for (--baseOut; ++xc[--d] > baseOut;) {
              xc[d] = 0;

              if (!d) {
                ++e;
                xc = [1].concat(xc);
              }
            }
          }

          // Determine trailing zeros.
          for (k = xc.length; !xc[--k];);

          // E.g. [4, 11, 15] becomes 4bf.
          for (i = 0, str = ''; i <= k; str += alphabet.charAt(xc[i++]));

          // Add leading zeros, decimal point and trailing zeros as required.
          str = toFixedPoint(str, e, alphabet.charAt(0));
        }

        // The caller will add the sign.
        return str;
      };
    })();


    // Perform division in the specified base. Called by div and convertBase.
    div = (function () {

      // Assume non-zero x and k.
      function multiply(x, k, base) {
        var m, temp, xlo, xhi,
          carry = 0,
          i = x.length,
          klo = k % SQRT_BASE,
          khi = k / SQRT_BASE | 0;

        for (x = x.slice(); i--;) {
          xlo = x[i] % SQRT_BASE;
          xhi = x[i] / SQRT_BASE | 0;
          m = khi * xlo + xhi * klo;
          temp = klo * xlo + ((m % SQRT_BASE) * SQRT_BASE) + carry;
          carry = (temp / base | 0) + (m / SQRT_BASE | 0) + khi * xhi;
          x[i] = temp % base;
        }

        if (carry) x = [carry].concat(x);

        return x;
      }

      function compare(a, b, aL, bL) {
        var i, cmp;

        if (aL != bL) {
          cmp = aL > bL ? 1 : -1;
        } else {

          for (i = cmp = 0; i < aL; i++) {

            if (a[i] != b[i]) {
              cmp = a[i] > b[i] ? 1 : -1;
              break;
            }
          }
        }

        return cmp;
      }

      function subtract(a, b, aL, base) {
        var i = 0;

        // Subtract b from a.
        for (; aL--;) {
          a[aL] -= i;
          i = a[aL] < b[aL] ? 1 : 0;
          a[aL] = i * base + a[aL] - b[aL];
        }

        // Remove leading zeros.
        for (; !a[0] && a.length > 1; a.splice(0, 1));
      }

      // x: dividend, y: divisor.
      return function (x, y, dp, rm, base) {
        var cmp, e, i, more, n, prod, prodL, q, qc, rem, remL, rem0, xi, xL, yc0,
          yL, yz,
          s = x.s == y.s ? 1 : -1,
          xc = x.c,
          yc = y.c;

        // Either NaN, Infinity or 0?
        if (!xc || !xc[0] || !yc || !yc[0]) {

          return new BigNumber(

           // Return NaN if either NaN, or both Infinity or 0.
           !x.s || !y.s || (xc ? yc && xc[0] == yc[0] : !yc) ? NaN :

            // Return ±0 if x is ±0 or y is ±Infinity, or return ±Infinity as y is ±0.
            xc && xc[0] == 0 || !yc ? s * 0 : s / 0
         );
        }

        q = new BigNumber(s);
        qc = q.c = [];
        e = x.e - y.e;
        s = dp + e + 1;

        if (!base) {
          base = BASE;
          e = bitFloor(x.e / LOG_BASE) - bitFloor(y.e / LOG_BASE);
          s = s / LOG_BASE | 0;
        }

        // Result exponent may be one less then the current value of e.
        // The coefficients of the BigNumbers from convertBase may have trailing zeros.
        for (i = 0; yc[i] == (xc[i] || 0); i++);

        if (yc[i] > (xc[i] || 0)) e--;

        if (s < 0) {
          qc.push(1);
          more = true;
        } else {
          xL = xc.length;
          yL = yc.length;
          i = 0;
          s += 2;

          // Normalise xc and yc so highest order digit of yc is >= base / 2.

          n = mathfloor(base / (yc[0] + 1));

          // Not necessary, but to handle odd bases where yc[0] == (base / 2) - 1.
          // if (n > 1 || n++ == 1 && yc[0] < base / 2) {
          if (n > 1) {
            yc = multiply(yc, n, base);
            xc = multiply(xc, n, base);
            yL = yc.length;
            xL = xc.length;
          }

          xi = yL;
          rem = xc.slice(0, yL);
          remL = rem.length;

          // Add zeros to make remainder as long as divisor.
          for (; remL < yL; rem[remL++] = 0);
          yz = yc.slice();
          yz = [0].concat(yz);
          yc0 = yc[0];
          if (yc[1] >= base / 2) yc0++;
          // Not necessary, but to prevent trial digit n > base, when using base 3.
          // else if (base == 3 && yc0 == 1) yc0 = 1 + 1e-15;

          do {
            n = 0;

            // Compare divisor and remainder.
            cmp = compare(yc, rem, yL, remL);

            // If divisor < remainder.
            if (cmp < 0) {

              // Calculate trial digit, n.

              rem0 = rem[0];
              if (yL != remL) rem0 = rem0 * base + (rem[1] || 0);

              // n is how many times the divisor goes into the current remainder.
              n = mathfloor(rem0 / yc0);

              //  Algorithm:
              //  product = divisor multiplied by trial digit (n).
              //  Compare product and remainder.
              //  If product is greater than remainder:
              //    Subtract divisor from product, decrement trial digit.
              //  Subtract product from remainder.
              //  If product was less than remainder at the last compare:
              //    Compare new remainder and divisor.
              //    If remainder is greater than divisor:
              //      Subtract divisor from remainder, increment trial digit.

              if (n > 1) {

                // n may be > base only when base is 3.
                if (n >= base) n = base - 1;

                // product = divisor * trial digit.
                prod = multiply(yc, n, base);
                prodL = prod.length;
                remL = rem.length;

                // Compare product and remainder.
                // If product > remainder then trial digit n too high.
                // n is 1 too high about 5% of the time, and is not known to have
                // ever been more than 1 too high.
                while (compare(prod, rem, prodL, remL) == 1) {
                  n--;

                  // Subtract divisor from product.
                  subtract(prod, yL < prodL ? yz : yc, prodL, base);
                  prodL = prod.length;
                  cmp = 1;
                }
              } else {

                // n is 0 or 1, cmp is -1.
                // If n is 0, there is no need to compare yc and rem again below,
                // so change cmp to 1 to avoid it.
                // If n is 1, leave cmp as -1, so yc and rem are compared again.
                if (n == 0) {

                  // divisor < remainder, so n must be at least 1.
                  cmp = n = 1;
                }

                // product = divisor
                prod = yc.slice();
                prodL = prod.length;
              }

              if (prodL < remL) prod = [0].concat(prod);

              // Subtract product from remainder.
              subtract(rem, prod, remL, base);
              remL = rem.length;

               // If product was < remainder.
              if (cmp == -1) {

                // Compare divisor and new remainder.
                // If divisor < new remainder, subtract divisor from remainder.
                // Trial digit n too low.
                // n is 1 too low about 5% of the time, and very rarely 2 too low.
                while (compare(yc, rem, yL, remL) < 1) {
                  n++;

                  // Subtract divisor from remainder.
                  subtract(rem, yL < remL ? yz : yc, remL, base);
                  remL = rem.length;
                }
              }
            } else if (cmp === 0) {
              n++;
              rem = [0];
            } // else cmp === 1 and n will be 0

            // Add the next digit, n, to the result array.
            qc[i++] = n;

            // Update the remainder.
            if (rem[0]) {
              rem[remL++] = xc[xi] || 0;
            } else {
              rem = [xc[xi]];
              remL = 1;
            }
          } while ((xi++ < xL || rem[0] != null) && s--);

          more = rem[0] != null;

          // Leading zero?
          if (!qc[0]) qc.splice(0, 1);
        }

        if (base == BASE) {

          // To calculate q.e, first get the number of digits of qc[0].
          for (i = 1, s = qc[0]; s >= 10; s /= 10, i++);

          round(q, dp + (q.e = i + e * LOG_BASE - 1) + 1, rm, more);

        // Caller is convertBase.
        } else {
          q.e = e;
          q.r = +more;
        }

        return q;
      };
    })();


    /*
     * Return a string representing the value of BigNumber n in fixed-point or exponential
     * notation rounded to the specified decimal places or significant digits.
     *
     * n: a BigNumber.
     * i: the index of the last digit required (i.e. the digit that may be rounded up).
     * rm: the rounding mode.
     * id: 1 (toExponential) or 2 (toPrecision).
     */
    function format(n, i, rm, id) {
      var c0, e, ne, len, str;

      if (rm == null) rm = ROUNDING_MODE;
      else intCheck(rm, 0, 8);

      if (!n.c) return n.toString();

      c0 = n.c[0];
      ne = n.e;

      if (i == null) {
        str = coeffToString(n.c);
        str = id == 1 || id == 2 && (ne <= TO_EXP_NEG || ne >= TO_EXP_POS)
         ? toExponential(str, ne)
         : toFixedPoint(str, ne, '0');
      } else {
        n = round(new BigNumber(n), i, rm);

        // n.e may have changed if the value was rounded up.
        e = n.e;

        str = coeffToString(n.c);
        len = str.length;

        // toPrecision returns exponential notation if the number of significant digits
        // specified is less than the number of digits necessary to represent the integer
        // part of the value in fixed-point notation.

        // Exponential notation.
        if (id == 1 || id == 2 && (i <= e || e <= TO_EXP_NEG)) {

          // Append zeros?
          for (; len < i; str += '0', len++);
          str = toExponential(str, e);

        // Fixed-point notation.
        } else {
          i -= ne;
          str = toFixedPoint(str, e, '0');

          // Append zeros?
          if (e + 1 > len) {
            if (--i > 0) for (str += '.'; i--; str += '0');
          } else {
            i += e - len;
            if (i > 0) {
              if (e + 1 == len) str += '.';
              for (; i--; str += '0');
            }
          }
        }
      }

      return n.s < 0 && c0 ? '-' + str : str;
    }


    // Handle BigNumber.max and BigNumber.min.
    // If any number is NaN, return NaN.
    function maxOrMin(args, n) {
      var k, y,
        i = 1,
        x = new BigNumber(args[0]);

      for (; i < args.length; i++) {
        y = new BigNumber(args[i]);
        if (!y.s || (k = compare(x, y)) === n || k === 0 && x.s === n) {
          x = y;
        }
      }

      return x;
    }


    /*
     * Strip trailing zeros, calculate base 10 exponent and check against MIN_EXP and MAX_EXP.
     * Called by minus, plus and times.
     */
    function normalise(n, c, e) {
      var i = 1,
        j = c.length;

       // Remove trailing zeros.
      for (; !c[--j]; c.pop());

      // Calculate the base 10 exponent. First get the number of digits of c[0].
      for (j = c[0]; j >= 10; j /= 10, i++);

      // Overflow?
      if ((e = i + e * LOG_BASE - 1) > MAX_EXP) {

        // Infinity.
        n.c = n.e = null;

      // Underflow?
      } else if (e < MIN_EXP) {

        // Zero.
        n.c = [n.e = 0];
      } else {
        n.e = e;
        n.c = c;
      }

      return n;
    }


    // Handle values that fail the validity test in BigNumber.
    parseNumeric = (function () {
      var basePrefix = /^(-?)0([xbo])(?=\w[\w.]*$)/i,
        dotAfter = /^([^.]+)\.$/,
        dotBefore = /^\.([^.]+)$/,
        isInfinityOrNaN = /^-?(Infinity|NaN)$/,
        whitespaceOrPlus = /^\s*\+(?=[\w.])|^\s+|\s+$/g;

      return function (x, str, isNum, b) {
        var base,
          s = isNum ? str : str.replace(whitespaceOrPlus, '');

        // No exception on ±Infinity or NaN.
        if (isInfinityOrNaN.test(s)) {
          x.s = isNaN(s) ? null : s < 0 ? -1 : 1;
        } else {
          if (!isNum) {

            // basePrefix = /^(-?)0([xbo])(?=\w[\w.]*$)/i
            s = s.replace(basePrefix, function (m, p1, p2) {
              base = (p2 = p2.toLowerCase()) == 'x' ? 16 : p2 == 'b' ? 2 : 8;
              return !b || b == base ? p1 : m;
            });

            if (b) {
              base = b;

              // E.g. '1.' to '1', '.1' to '0.1'
              s = s.replace(dotAfter, '$1').replace(dotBefore, '0.$1');
            }

            if (str != s) return new BigNumber(s, base);
          }

          // '[BigNumber Error] Not a number: {n}'
          // '[BigNumber Error] Not a base {b} number: {n}'
          if (BigNumber.DEBUG) {
            throw Error
              (bignumberError + 'Not a' + (b ? ' base ' + b : '') + ' number: ' + str);
          }

          // NaN
          x.s = null;
        }

        x.c = x.e = null;
      }
    })();


    /*
     * Round x to sd significant digits using rounding mode rm. Check for over/under-flow.
     * If r is truthy, it is known that there are more digits after the rounding digit.
     */
    function round(x, sd, rm, r) {
      var d, i, j, k, n, ni, rd,
        xc = x.c,
        pows10 = POWS_TEN;

      // if x is not Infinity or NaN...
      if (xc) {

        // rd is the rounding digit, i.e. the digit after the digit that may be rounded up.
        // n is a base 1e14 number, the value of the element of array x.c containing rd.
        // ni is the index of n within x.c.
        // d is the number of digits of n.
        // i is the index of rd within n including leading zeros.
        // j is the actual index of rd within n (if < 0, rd is a leading zero).
        out: {

          // Get the number of digits of the first element of xc.
          for (d = 1, k = xc[0]; k >= 10; k /= 10, d++);
          i = sd - d;

          // If the rounding digit is in the first element of xc...
          if (i < 0) {
            i += LOG_BASE;
            j = sd;
            n = xc[ni = 0];

            // Get the rounding digit at index j of n.
            rd = mathfloor(n / pows10[d - j - 1] % 10);
          } else {
            ni = mathceil((i + 1) / LOG_BASE);

            if (ni >= xc.length) {

              if (r) {

                // Needed by sqrt.
                for (; xc.length <= ni; xc.push(0));
                n = rd = 0;
                d = 1;
                i %= LOG_BASE;
                j = i - LOG_BASE + 1;
              } else {
                break out;
              }
            } else {
              n = k = xc[ni];

              // Get the number of digits of n.
              for (d = 1; k >= 10; k /= 10, d++);

              // Get the index of rd within n.
              i %= LOG_BASE;

              // Get the index of rd within n, adjusted for leading zeros.
              // The number of leading zeros of n is given by LOG_BASE - d.
              j = i - LOG_BASE + d;

              // Get the rounding digit at index j of n.
              rd = j < 0 ? 0 : mathfloor(n / pows10[d - j - 1] % 10);
            }
          }

          r = r || sd < 0 ||

          // Are there any non-zero digits after the rounding digit?
          // The expression  n % pows10[d - j - 1]  returns all digits of n to the right
          // of the digit at j, e.g. if n is 908714 and j is 2, the expression gives 714.
           xc[ni + 1] != null || (j < 0 ? n : n % pows10[d - j - 1]);

          r = rm < 4
           ? (rd || r) && (rm == 0 || rm == (x.s < 0 ? 3 : 2))
           : rd > 5 || rd == 5 && (rm == 4 || r || rm == 6 &&

            // Check whether the digit to the left of the rounding digit is odd.
            ((i > 0 ? j > 0 ? n / pows10[d - j] : 0 : xc[ni - 1]) % 10) & 1 ||
             rm == (x.s < 0 ? 8 : 7));

          if (sd < 1 || !xc[0]) {
            xc.length = 0;

            if (r) {

              // Convert sd to decimal places.
              sd -= x.e + 1;

              // 1, 0.1, 0.01, 0.001, 0.0001 etc.
              xc[0] = pows10[(LOG_BASE - sd % LOG_BASE) % LOG_BASE];
              x.e = -sd || 0;
            } else {

              // Zero.
              xc[0] = x.e = 0;
            }

            return x;
          }

          // Remove excess digits.
          if (i == 0) {
            xc.length = ni;
            k = 1;
            ni--;
          } else {
            xc.length = ni + 1;
            k = pows10[LOG_BASE - i];

            // E.g. 56700 becomes 56000 if 7 is the rounding digit.
            // j > 0 means i > number of leading zeros of n.
            xc[ni] = j > 0 ? mathfloor(n / pows10[d - j] % pows10[j]) * k : 0;
          }

          // Round up?
          if (r) {

            for (; ;) {

              // If the digit to be rounded up is in the first element of xc...
              if (ni == 0) {

                // i will be the length of xc[0] before k is added.
                for (i = 1, j = xc[0]; j >= 10; j /= 10, i++);
                j = xc[0] += k;
                for (k = 1; j >= 10; j /= 10, k++);

                // if i != k the length has increased.
                if (i != k) {
                  x.e++;
                  if (xc[0] == BASE) xc[0] = 1;
                }

                break;
              } else {
                xc[ni] += k;
                if (xc[ni] != BASE) break;
                xc[ni--] = 0;
                k = 1;
              }
            }
          }

          // Remove trailing zeros.
          for (i = xc.length; xc[--i] === 0; xc.pop());
        }

        // Overflow? Infinity.
        if (x.e > MAX_EXP) {
          x.c = x.e = null;

        // Underflow? Zero.
        } else if (x.e < MIN_EXP) {
          x.c = [x.e = 0];
        }
      }

      return x;
    }


    function valueOf(n) {
      var str,
        e = n.e;

      if (e === null) return n.toString();

      str = coeffToString(n.c);

      str = e <= TO_EXP_NEG || e >= TO_EXP_POS
        ? toExponential(str, e)
        : toFixedPoint(str, e, '0');

      return n.s < 0 ? '-' + str : str;
    }


    // PROTOTYPE/INSTANCE METHODS


    /*
     * Return a new BigNumber whose value is the absolute value of this BigNumber.
     */
    P.absoluteValue = P.abs = function () {
      var x = new BigNumber(this);
      if (x.s < 0) x.s = 1;
      return x;
    };


    /*
     * Return
     *   1 if the value of this BigNumber is greater than the value of BigNumber(y, b),
     *   -1 if the value of this BigNumber is less than the value of BigNumber(y, b),
     *   0 if they have the same value,
     *   or null if the value of either is NaN.
     */
    P.comparedTo = function (y, b) {
      return compare(this, new BigNumber(y, b));
    };


    /*
     * If dp is undefined or null or true or false, return the number of decimal places of the
     * value of this BigNumber, or null if the value of this BigNumber is ±Infinity or NaN.
     *
     * Otherwise, if dp is a number, return a new BigNumber whose value is the value of this
     * BigNumber rounded to a maximum of dp decimal places using rounding mode rm, or
     * ROUNDING_MODE if rm is omitted.
     *
     * [dp] {number} Decimal places: integer, 0 to MAX inclusive.
     * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
     *
     * '[BigNumber Error] Argument {not a primitive number|not an integer|out of range}: {dp|rm}'
     */
    P.decimalPlaces = P.dp = function (dp, rm) {
      var c, n, v,
        x = this;

      if (dp != null) {
        intCheck(dp, 0, MAX);
        if (rm == null) rm = ROUNDING_MODE;
        else intCheck(rm, 0, 8);

        return round(new BigNumber(x), dp + x.e + 1, rm);
      }

      if (!(c = x.c)) return null;
      n = ((v = c.length - 1) - bitFloor(this.e / LOG_BASE)) * LOG_BASE;

      // Subtract the number of trailing zeros of the last number.
      if (v = c[v]) for (; v % 10 == 0; v /= 10, n--);
      if (n < 0) n = 0;

      return n;
    };


    /*
     *  n / 0 = I
     *  n / N = N
     *  n / I = 0
     *  0 / n = 0
     *  0 / 0 = N
     *  0 / N = N
     *  0 / I = 0
     *  N / n = N
     *  N / 0 = N
     *  N / N = N
     *  N / I = N
     *  I / n = I
     *  I / 0 = I
     *  I / N = N
     *  I / I = N
     *
     * Return a new BigNumber whose value is the value of this BigNumber divided by the value of
     * BigNumber(y, b), rounded according to DECIMAL_PLACES and ROUNDING_MODE.
     */
    P.dividedBy = P.div = function (y, b) {
      return div(this, new BigNumber(y, b), DECIMAL_PLACES, ROUNDING_MODE);
    };


    /*
     * Return a new BigNumber whose value is the integer part of dividing the value of this
     * BigNumber by the value of BigNumber(y, b).
     */
    P.dividedToIntegerBy = P.idiv = function (y, b) {
      return div(this, new BigNumber(y, b), 0, 1);
    };


    /*
     * Return a BigNumber whose value is the value of this BigNumber exponentiated by n.
     *
     * If m is present, return the result modulo m.
     * If n is negative round according to DECIMAL_PLACES and ROUNDING_MODE.
     * If POW_PRECISION is non-zero and m is not present, round to POW_PRECISION using ROUNDING_MODE.
     *
     * The modular power operation works efficiently when x, n, and m are integers, otherwise it
     * is equivalent to calculating x.exponentiatedBy(n).modulo(m) with a POW_PRECISION of 0.
     *
     * n {number|string|BigNumber} The exponent. An integer.
     * [m] {number|string|BigNumber} The modulus.
     *
     * '[BigNumber Error] Exponent not an integer: {n}'
     */
    P.exponentiatedBy = P.pow = function (n, m) {
      var half, isModExp, i, k, more, nIsBig, nIsNeg, nIsOdd, y,
        x = this;

      n = new BigNumber(n);

      // Allow NaN and ±Infinity, but not other non-integers.
      if (n.c && !n.isInteger()) {
        throw Error
          (bignumberError + 'Exponent not an integer: ' + valueOf(n));
      }

      if (m != null) m = new BigNumber(m);

      // Exponent of MAX_SAFE_INTEGER is 15.
      nIsBig = n.e > 14;

      // If x is NaN, ±Infinity, ±0 or ±1, or n is ±Infinity, NaN or ±0.
      if (!x.c || !x.c[0] || x.c[0] == 1 && !x.e && x.c.length == 1 || !n.c || !n.c[0]) {

        // The sign of the result of pow when x is negative depends on the evenness of n.
        // If +n overflows to ±Infinity, the evenness of n would be not be known.
        y = new BigNumber(Math.pow(+valueOf(x), nIsBig ? n.s * (2 - isOdd(n)) : +valueOf(n)));
        return m ? y.mod(m) : y;
      }

      nIsNeg = n.s < 0;

      if (m) {

        // x % m returns NaN if abs(m) is zero, or m is NaN.
        if (m.c ? !m.c[0] : !m.s) return new BigNumber(NaN);

        isModExp = !nIsNeg && x.isInteger() && m.isInteger();

        if (isModExp) x = x.mod(m);

      // Overflow to ±Infinity: >=2**1e10 or >=1.0000024**1e15.
      // Underflow to ±0: <=0.79**1e10 or <=0.9999975**1e15.
      } else if (n.e > 9 && (x.e > 0 || x.e < -1 || (x.e == 0
        // [1, 240000000]
        ? x.c[0] > 1 || nIsBig && x.c[1] >= 24e7
        // [80000000000000]  [99999750000000]
        : x.c[0] < 8e13 || nIsBig && x.c[0] <= 9999975e7))) {

        // If x is negative and n is odd, k = -0, else k = 0.
        k = x.s < 0 && isOdd(n) ? -0 : 0;

        // If x >= 1, k = ±Infinity.
        if (x.e > -1) k = 1 / k;

        // If n is negative return ±0, else return ±Infinity.
        return new BigNumber(nIsNeg ? 1 / k : k);

      } else if (POW_PRECISION) {

        // Truncating each coefficient array to a length of k after each multiplication
        // equates to truncating significant digits to POW_PRECISION + [28, 41],
        // i.e. there will be a minimum of 28 guard digits retained.
        k = mathceil(POW_PRECISION / LOG_BASE + 2);
      }

      if (nIsBig) {
        half = new BigNumber(0.5);
        if (nIsNeg) n.s = 1;
        nIsOdd = isOdd(n);
      } else {
        i = Math.abs(+valueOf(n));
        nIsOdd = i % 2;
      }

      y = new BigNumber(ONE);

      // Performs 54 loop iterations for n of 9007199254740991.
      for (; ;) {

        if (nIsOdd) {
          y = y.times(x);
          if (!y.c) break;

          if (k) {
            if (y.c.length > k) y.c.length = k;
          } else if (isModExp) {
            y = y.mod(m);    //y = y.minus(div(y, m, 0, MODULO_MODE).times(m));
          }
        }

        if (i) {
          i = mathfloor(i / 2);
          if (i === 0) break;
          nIsOdd = i % 2;
        } else {
          n = n.times(half);
          round(n, n.e + 1, 1);

          if (n.e > 14) {
            nIsOdd = isOdd(n);
          } else {
            i = +valueOf(n);
            if (i === 0) break;
            nIsOdd = i % 2;
          }
        }

        x = x.times(x);

        if (k) {
          if (x.c && x.c.length > k) x.c.length = k;
        } else if (isModExp) {
          x = x.mod(m);    //x = x.minus(div(x, m, 0, MODULO_MODE).times(m));
        }
      }

      if (isModExp) return y;
      if (nIsNeg) y = ONE.div(y);

      return m ? y.mod(m) : k ? round(y, POW_PRECISION, ROUNDING_MODE, more) : y;
    };


    /*
     * Return a new BigNumber whose value is the value of this BigNumber rounded to an integer
     * using rounding mode rm, or ROUNDING_MODE if rm is omitted.
     *
     * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
     *
     * '[BigNumber Error] Argument {not a primitive number|not an integer|out of range}: {rm}'
     */
    P.integerValue = function (rm) {
      var n = new BigNumber(this);
      if (rm == null) rm = ROUNDING_MODE;
      else intCheck(rm, 0, 8);
      return round(n, n.e + 1, rm);
    };


    /*
     * Return true if the value of this BigNumber is equal to the value of BigNumber(y, b),
     * otherwise return false.
     */
    P.isEqualTo = P.eq = function (y, b) {
      return compare(this, new BigNumber(y, b)) === 0;
    };


    /*
     * Return true if the value of this BigNumber is a finite number, otherwise return false.
     */
    P.isFinite = function () {
      return !!this.c;
    };


    /*
     * Return true if the value of this BigNumber is greater than the value of BigNumber(y, b),
     * otherwise return false.
     */
    P.isGreaterThan = P.gt = function (y, b) {
      return compare(this, new BigNumber(y, b)) > 0;
    };


    /*
     * Return true if the value of this BigNumber is greater than or equal to the value of
     * BigNumber(y, b), otherwise return false.
     */
    P.isGreaterThanOrEqualTo = P.gte = function (y, b) {
      return (b = compare(this, new BigNumber(y, b))) === 1 || b === 0;

    };


    /*
     * Return true if the value of this BigNumber is an integer, otherwise return false.
     */
    P.isInteger = function () {
      return !!this.c && bitFloor(this.e / LOG_BASE) > this.c.length - 2;
    };


    /*
     * Return true if the value of this BigNumber is less than the value of BigNumber(y, b),
     * otherwise return false.
     */
    P.isLessThan = P.lt = function (y, b) {
      return compare(this, new BigNumber(y, b)) < 0;
    };


    /*
     * Return true if the value of this BigNumber is less than or equal to the value of
     * BigNumber(y, b), otherwise return false.
     */
    P.isLessThanOrEqualTo = P.lte = function (y, b) {
      return (b = compare(this, new BigNumber(y, b))) === -1 || b === 0;
    };


    /*
     * Return true if the value of this BigNumber is NaN, otherwise return false.
     */
    P.isNaN = function () {
      return !this.s;
    };


    /*
     * Return true if the value of this BigNumber is negative, otherwise return false.
     */
    P.isNegative = function () {
      return this.s < 0;
    };


    /*
     * Return true if the value of this BigNumber is positive, otherwise return false.
     */
    P.isPositive = function () {
      return this.s > 0;
    };


    /*
     * Return true if the value of this BigNumber is 0 or -0, otherwise return false.
     */
    P.isZero = function () {
      return !!this.c && this.c[0] == 0;
    };


    /*
     *  n - 0 = n
     *  n - N = N
     *  n - I = -I
     *  0 - n = -n
     *  0 - 0 = 0
     *  0 - N = N
     *  0 - I = -I
     *  N - n = N
     *  N - 0 = N
     *  N - N = N
     *  N - I = N
     *  I - n = I
     *  I - 0 = I
     *  I - N = N
     *  I - I = N
     *
     * Return a new BigNumber whose value is the value of this BigNumber minus the value of
     * BigNumber(y, b).
     */
    P.minus = function (y, b) {
      var i, j, t, xLTy,
        x = this,
        a = x.s;

      y = new BigNumber(y, b);
      b = y.s;

      // Either NaN?
      if (!a || !b) return new BigNumber(NaN);

      // Signs differ?
      if (a != b) {
        y.s = -b;
        return x.plus(y);
      }

      var xe = x.e / LOG_BASE,
        ye = y.e / LOG_BASE,
        xc = x.c,
        yc = y.c;

      if (!xe || !ye) {

        // Either Infinity?
        if (!xc || !yc) return xc ? (y.s = -b, y) : new BigNumber(yc ? x : NaN);

        // Either zero?
        if (!xc[0] || !yc[0]) {

          // Return y if y is non-zero, x if x is non-zero, or zero if both are zero.
          return yc[0] ? (y.s = -b, y) : new BigNumber(xc[0] ? x :

           // IEEE 754 (2008) 6.3: n - n = -0 when rounding to -Infinity
           ROUNDING_MODE == 3 ? -0 : 0);
        }
      }

      xe = bitFloor(xe);
      ye = bitFloor(ye);
      xc = xc.slice();

      // Determine which is the bigger number.
      if (a = xe - ye) {

        if (xLTy = a < 0) {
          a = -a;
          t = xc;
        } else {
          ye = xe;
          t = yc;
        }

        t.reverse();

        // Prepend zeros to equalise exponents.
        for (b = a; b--; t.push(0));
        t.reverse();
      } else {

        // Exponents equal. Check digit by digit.
        j = (xLTy = (a = xc.length) < (b = yc.length)) ? a : b;

        for (a = b = 0; b < j; b++) {

          if (xc[b] != yc[b]) {
            xLTy = xc[b] < yc[b];
            break;
          }
        }
      }

      // x < y? Point xc to the array of the bigger number.
      if (xLTy) {
        t = xc;
        xc = yc;
        yc = t;
        y.s = -y.s;
      }

      b = (j = yc.length) - (i = xc.length);

      // Append zeros to xc if shorter.
      // No need to add zeros to yc if shorter as subtract only needs to start at yc.length.
      if (b > 0) for (; b--; xc[i++] = 0);
      b = BASE - 1;

      // Subtract yc from xc.
      for (; j > a;) {

        if (xc[--j] < yc[j]) {
          for (i = j; i && !xc[--i]; xc[i] = b);
          --xc[i];
          xc[j] += BASE;
        }

        xc[j] -= yc[j];
      }

      // Remove leading zeros and adjust exponent accordingly.
      for (; xc[0] == 0; xc.splice(0, 1), --ye);

      // Zero?
      if (!xc[0]) {

        // Following IEEE 754 (2008) 6.3,
        // n - n = +0  but  n - n = -0  when rounding towards -Infinity.
        y.s = ROUNDING_MODE == 3 ? -1 : 1;
        y.c = [y.e = 0];
        return y;
      }

      // No need to check for Infinity as +x - +y != Infinity && -x - -y != Infinity
      // for finite x and y.
      return normalise(y, xc, ye);
    };


    /*
     *   n % 0 =  N
     *   n % N =  N
     *   n % I =  n
     *   0 % n =  0
     *  -0 % n = -0
     *   0 % 0 =  N
     *   0 % N =  N
     *   0 % I =  0
     *   N % n =  N
     *   N % 0 =  N
     *   N % N =  N
     *   N % I =  N
     *   I % n =  N
     *   I % 0 =  N
     *   I % N =  N
     *   I % I =  N
     *
     * Return a new BigNumber whose value is the value of this BigNumber modulo the value of
     * BigNumber(y, b). The result depends on the value of MODULO_MODE.
     */
    P.modulo = P.mod = function (y, b) {
      var q, s,
        x = this;

      y = new BigNumber(y, b);

      // Return NaN if x is Infinity or NaN, or y is NaN or zero.
      if (!x.c || !y.s || y.c && !y.c[0]) {
        return new BigNumber(NaN);

      // Return x if y is Infinity or x is zero.
      } else if (!y.c || x.c && !x.c[0]) {
        return new BigNumber(x);
      }

      if (MODULO_MODE == 9) {

        // Euclidian division: q = sign(y) * floor(x / abs(y))
        // r = x - qy    where  0 <= r < abs(y)
        s = y.s;
        y.s = 1;
        q = div(x, y, 0, 3);
        y.s = s;
        q.s *= s;
      } else {
        q = div(x, y, 0, MODULO_MODE);
      }

      y = x.minus(q.times(y));

      // To match JavaScript %, ensure sign of zero is sign of dividend.
      if (!y.c[0] && MODULO_MODE == 1) y.s = x.s;

      return y;
    };


    /*
     *  n * 0 = 0
     *  n * N = N
     *  n * I = I
     *  0 * n = 0
     *  0 * 0 = 0
     *  0 * N = N
     *  0 * I = N
     *  N * n = N
     *  N * 0 = N
     *  N * N = N
     *  N * I = N
     *  I * n = I
     *  I * 0 = N
     *  I * N = N
     *  I * I = I
     *
     * Return a new BigNumber whose value is the value of this BigNumber multiplied by the value
     * of BigNumber(y, b).
     */
    P.multipliedBy = P.times = function (y, b) {
      var c, e, i, j, k, m, xcL, xlo, xhi, ycL, ylo, yhi, zc,
        base, sqrtBase,
        x = this,
        xc = x.c,
        yc = (y = new BigNumber(y, b)).c;

      // Either NaN, ±Infinity or ±0?
      if (!xc || !yc || !xc[0] || !yc[0]) {

        // Return NaN if either is NaN, or one is 0 and the other is Infinity.
        if (!x.s || !y.s || xc && !xc[0] && !yc || yc && !yc[0] && !xc) {
          y.c = y.e = y.s = null;
        } else {
          y.s *= x.s;

          // Return ±Infinity if either is ±Infinity.
          if (!xc || !yc) {
            y.c = y.e = null;

          // Return ±0 if either is ±0.
          } else {
            y.c = [0];
            y.e = 0;
          }
        }

        return y;
      }

      e = bitFloor(x.e / LOG_BASE) + bitFloor(y.e / LOG_BASE);
      y.s *= x.s;
      xcL = xc.length;
      ycL = yc.length;

      // Ensure xc points to longer array and xcL to its length.
      if (xcL < ycL) {
        zc = xc;
        xc = yc;
        yc = zc;
        i = xcL;
        xcL = ycL;
        ycL = i;
      }

      // Initialise the result array with zeros.
      for (i = xcL + ycL, zc = []; i--; zc.push(0));

      base = BASE;
      sqrtBase = SQRT_BASE;

      for (i = ycL; --i >= 0;) {
        c = 0;
        ylo = yc[i] % sqrtBase;
        yhi = yc[i] / sqrtBase | 0;

        for (k = xcL, j = i + k; j > i;) {
          xlo = xc[--k] % sqrtBase;
          xhi = xc[k] / sqrtBase | 0;
          m = yhi * xlo + xhi * ylo;
          xlo = ylo * xlo + ((m % sqrtBase) * sqrtBase) + zc[j] + c;
          c = (xlo / base | 0) + (m / sqrtBase | 0) + yhi * xhi;
          zc[j--] = xlo % base;
        }

        zc[j] = c;
      }

      if (c) {
        ++e;
      } else {
        zc.splice(0, 1);
      }

      return normalise(y, zc, e);
    };


    /*
     * Return a new BigNumber whose value is the value of this BigNumber negated,
     * i.e. multiplied by -1.
     */
    P.negated = function () {
      var x = new BigNumber(this);
      x.s = -x.s || null;
      return x;
    };


    /*
     *  n + 0 = n
     *  n + N = N
     *  n + I = I
     *  0 + n = n
     *  0 + 0 = 0
     *  0 + N = N
     *  0 + I = I
     *  N + n = N
     *  N + 0 = N
     *  N + N = N
     *  N + I = N
     *  I + n = I
     *  I + 0 = I
     *  I + N = N
     *  I + I = I
     *
     * Return a new BigNumber whose value is the value of this BigNumber plus the value of
     * BigNumber(y, b).
     */
    P.plus = function (y, b) {
      var t,
        x = this,
        a = x.s;

      y = new BigNumber(y, b);
      b = y.s;

      // Either NaN?
      if (!a || !b) return new BigNumber(NaN);

      // Signs differ?
       if (a != b) {
        y.s = -b;
        return x.minus(y);
      }

      var xe = x.e / LOG_BASE,
        ye = y.e / LOG_BASE,
        xc = x.c,
        yc = y.c;

      if (!xe || !ye) {

        // Return ±Infinity if either ±Infinity.
        if (!xc || !yc) return new BigNumber(a / 0);

        // Either zero?
        // Return y if y is non-zero, x if x is non-zero, or zero if both are zero.
        if (!xc[0] || !yc[0]) return yc[0] ? y : new BigNumber(xc[0] ? x : a * 0);
      }

      xe = bitFloor(xe);
      ye = bitFloor(ye);
      xc = xc.slice();

      // Prepend zeros to equalise exponents. Faster to use reverse then do unshifts.
      if (a = xe - ye) {
        if (a > 0) {
          ye = xe;
          t = yc;
        } else {
          a = -a;
          t = xc;
        }

        t.reverse();
        for (; a--; t.push(0));
        t.reverse();
      }

      a = xc.length;
      b = yc.length;

      // Point xc to the longer array, and b to the shorter length.
      if (a - b < 0) {
        t = yc;
        yc = xc;
        xc = t;
        b = a;
      }

      // Only start adding at yc.length - 1 as the further digits of xc can be ignored.
      for (a = 0; b;) {
        a = (xc[--b] = xc[b] + yc[b] + a) / BASE | 0;
        xc[b] = BASE === xc[b] ? 0 : xc[b] % BASE;
      }

      if (a) {
        xc = [a].concat(xc);
        ++ye;
      }

      // No need to check for zero, as +x + +y != 0 && -x + -y != 0
      // ye = MAX_EXP + 1 possible
      return normalise(y, xc, ye);
    };


    /*
     * If sd is undefined or null or true or false, return the number of significant digits of
     * the value of this BigNumber, or null if the value of this BigNumber is ±Infinity or NaN.
     * If sd is true include integer-part trailing zeros in the count.
     *
     * Otherwise, if sd is a number, return a new BigNumber whose value is the value of this
     * BigNumber rounded to a maximum of sd significant digits using rounding mode rm, or
     * ROUNDING_MODE if rm is omitted.
     *
     * sd {number|boolean} number: significant digits: integer, 1 to MAX inclusive.
     *                     boolean: whether to count integer-part trailing zeros: true or false.
     * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
     *
     * '[BigNumber Error] Argument {not a primitive number|not an integer|out of range}: {sd|rm}'
     */
    P.precision = P.sd = function (sd, rm) {
      var c, n, v,
        x = this;

      if (sd != null && sd !== !!sd) {
        intCheck(sd, 1, MAX);
        if (rm == null) rm = ROUNDING_MODE;
        else intCheck(rm, 0, 8);

        return round(new BigNumber(x), sd, rm);
      }

      if (!(c = x.c)) return null;
      v = c.length - 1;
      n = v * LOG_BASE + 1;

      if (v = c[v]) {

        // Subtract the number of trailing zeros of the last element.
        for (; v % 10 == 0; v /= 10, n--);

        // Add the number of digits of the first element.
        for (v = c[0]; v >= 10; v /= 10, n++);
      }

      if (sd && x.e + 1 > n) n = x.e + 1;

      return n;
    };


    /*
     * Return a new BigNumber whose value is the value of this BigNumber shifted by k places
     * (powers of 10). Shift to the right if n > 0, and to the left if n < 0.
     *
     * k {number} Integer, -MAX_SAFE_INTEGER to MAX_SAFE_INTEGER inclusive.
     *
     * '[BigNumber Error] Argument {not a primitive number|not an integer|out of range}: {k}'
     */
    P.shiftedBy = function (k) {
      intCheck(k, -MAX_SAFE_INTEGER, MAX_SAFE_INTEGER);
      return this.times('1e' + k);
    };


    /*
     *  sqrt(-n) =  N
     *  sqrt(N) =  N
     *  sqrt(-I) =  N
     *  sqrt(I) =  I
     *  sqrt(0) =  0
     *  sqrt(-0) = -0
     *
     * Return a new BigNumber whose value is the square root of the value of this BigNumber,
     * rounded according to DECIMAL_PLACES and ROUNDING_MODE.
     */
    P.squareRoot = P.sqrt = function () {
      var m, n, r, rep, t,
        x = this,
        c = x.c,
        s = x.s,
        e = x.e,
        dp = DECIMAL_PLACES + 4,
        half = new BigNumber('0.5');

      // Negative/NaN/Infinity/zero?
      if (s !== 1 || !c || !c[0]) {
        return new BigNumber(!s || s < 0 && (!c || c[0]) ? NaN : c ? x : 1 / 0);
      }

      // Initial estimate.
      s = Math.sqrt(+valueOf(x));

      // Math.sqrt underflow/overflow?
      // Pass x to Math.sqrt as integer, then adjust the exponent of the result.
      if (s == 0 || s == 1 / 0) {
        n = coeffToString(c);
        if ((n.length + e) % 2 == 0) n += '0';
        s = Math.sqrt(+n);
        e = bitFloor((e + 1) / 2) - (e < 0 || e % 2);

        if (s == 1 / 0) {
          n = '5e' + e;
        } else {
          n = s.toExponential();
          n = n.slice(0, n.indexOf('e') + 1) + e;
        }

        r = new BigNumber(n);
      } else {
        r = new BigNumber(s + '');
      }

      // Check for zero.
      // r could be zero if MIN_EXP is changed after the this value was created.
      // This would cause a division by zero (x/t) and hence Infinity below, which would cause
      // coeffToString to throw.
      if (r.c[0]) {
        e = r.e;
        s = e + dp;
        if (s < 3) s = 0;

        // Newton-Raphson iteration.
        for (; ;) {
          t = r;
          r = half.times(t.plus(div(x, t, dp, 1)));

          if (coeffToString(t.c).slice(0, s) === (n = coeffToString(r.c)).slice(0, s)) {

            // The exponent of r may here be one less than the final result exponent,
            // e.g 0.0009999 (e-4) -- > 0.001 (e-3), so adjust s so the rounding digits
            // are indexed correctly.
            if (r.e < e) --s;
            n = n.slice(s - 3, s + 1);

            // The 4th rounding digit may be in error by -1 so if the 4 rounding digits
            // are 9999 or 4999 (i.e. approaching a rounding boundary) continue the
            // iteration.
            if (n == '9999' || !rep && n == '4999') {

              // On the first iteration only, check to see if rounding up gives the
              // exact result as the nines may infinitely repeat.
              if (!rep) {
                round(t, t.e + DECIMAL_PLACES + 2, 0);

                if (t.times(t).eq(x)) {
                  r = t;
                  break;
                }
              }

              dp += 4;
              s += 4;
              rep = 1;
            } else {

              // If rounding digits are null, 0{0,4} or 50{0,3}, check for exact
              // result. If not, then there are further digits and m will be truthy.
              if (!+n || !+n.slice(1) && n.charAt(0) == '5') {

                // Truncate to the first rounding digit.
                round(r, r.e + DECIMAL_PLACES + 2, 1);
                m = !r.times(r).eq(x);
              }

              break;
            }
          }
        }
      }

      return round(r, r.e + DECIMAL_PLACES + 1, ROUNDING_MODE, m);
    };


    /*
     * Return a string representing the value of this BigNumber in exponential notation and
     * rounded using ROUNDING_MODE to dp fixed decimal places.
     *
     * [dp] {number} Decimal places. Integer, 0 to MAX inclusive.
     * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
     *
     * '[BigNumber Error] Argument {not a primitive number|not an integer|out of range}: {dp|rm}'
     */
    P.toExponential = function (dp, rm) {
      if (dp != null) {
        intCheck(dp, 0, MAX);
        dp++;
      }
      return format(this, dp, rm, 1);
    };


    /*
     * Return a string representing the value of this BigNumber in fixed-point notation rounding
     * to dp fixed decimal places using rounding mode rm, or ROUNDING_MODE if rm is omitted.
     *
     * Note: as with JavaScript's number type, (-0).toFixed(0) is '0',
     * but e.g. (-0.00001).toFixed(0) is '-0'.
     *
     * [dp] {number} Decimal places. Integer, 0 to MAX inclusive.
     * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
     *
     * '[BigNumber Error] Argument {not a primitive number|not an integer|out of range}: {dp|rm}'
     */
    P.toFixed = function (dp, rm) {
      if (dp != null) {
        intCheck(dp, 0, MAX);
        dp = dp + this.e + 1;
      }
      return format(this, dp, rm);
    };


    /*
     * Return a string representing the value of this BigNumber in fixed-point notation rounded
     * using rm or ROUNDING_MODE to dp decimal places, and formatted according to the properties
     * of the format or FORMAT object (see BigNumber.set).
     *
     * The formatting object may contain some or all of the properties shown below.
     *
     * FORMAT = {
     *   prefix: '',
     *   groupSize: 3,
     *   secondaryGroupSize: 0,
     *   groupSeparator: ',',
     *   decimalSeparator: '.',
     *   fractionGroupSize: 0,
     *   fractionGroupSeparator: '\xA0',      // non-breaking space
     *   suffix: ''
     * };
     *
     * [dp] {number} Decimal places. Integer, 0 to MAX inclusive.
     * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
     * [format] {object} Formatting options. See FORMAT pbject above.
     *
     * '[BigNumber Error] Argument {not a primitive number|not an integer|out of range}: {dp|rm}'
     * '[BigNumber Error] Argument not an object: {format}'
     */
    P.toFormat = function (dp, rm, format) {
      var str,
        x = this;

      if (format == null) {
        if (dp != null && rm && typeof rm == 'object') {
          format = rm;
          rm = null;
        } else if (dp && typeof dp == 'object') {
          format = dp;
          dp = rm = null;
        } else {
          format = FORMAT;
        }
      } else if (typeof format != 'object') {
        throw Error
          (bignumberError + 'Argument not an object: ' + format);
      }

      str = x.toFixed(dp, rm);

      if (x.c) {
        var i,
          arr = str.split('.'),
          g1 = +format.groupSize,
          g2 = +format.secondaryGroupSize,
          groupSeparator = format.groupSeparator || '',
          intPart = arr[0],
          fractionPart = arr[1],
          isNeg = x.s < 0,
          intDigits = isNeg ? intPart.slice(1) : intPart,
          len = intDigits.length;

        if (g2) {
          i = g1;
          g1 = g2;
          g2 = i;
          len -= i;
        }

        if (g1 > 0 && len > 0) {
          i = len % g1 || g1;
          intPart = intDigits.substr(0, i);
          for (; i < len; i += g1) intPart += groupSeparator + intDigits.substr(i, g1);
          if (g2 > 0) intPart += groupSeparator + intDigits.slice(i);
          if (isNeg) intPart = '-' + intPart;
        }

        str = fractionPart
         ? intPart + (format.decimalSeparator || '') + ((g2 = +format.fractionGroupSize)
          ? fractionPart.replace(new RegExp('\\d{' + g2 + '}\\B', 'g'),
           '$&' + (format.fractionGroupSeparator || ''))
          : fractionPart)
         : intPart;
      }

      return (format.prefix || '') + str + (format.suffix || '');
    };


    /*
     * Return an array of two BigNumbers representing the value of this BigNumber as a simple
     * fraction with an integer numerator and an integer denominator.
     * The denominator will be a positive non-zero value less than or equal to the specified
     * maximum denominator. If a maximum denominator is not specified, the denominator will be
     * the lowest value necessary to represent the number exactly.
     *
     * [md] {number|string|BigNumber} Integer >= 1, or Infinity. The maximum denominator.
     *
     * '[BigNumber Error] Argument {not an integer|out of range} : {md}'
     */
    P.toFraction = function (md) {
      var d, d0, d1, d2, e, exp, n, n0, n1, q, r, s,
        x = this,
        xc = x.c;

      if (md != null) {
        n = new BigNumber(md);

        // Throw if md is less than one or is not an integer, unless it is Infinity.
        if (!n.isInteger() && (n.c || n.s !== 1) || n.lt(ONE)) {
          throw Error
            (bignumberError + 'Argument ' +
              (n.isInteger() ? 'out of range: ' : 'not an integer: ') + valueOf(n));
        }
      }

      if (!xc) return new BigNumber(x);

      d = new BigNumber(ONE);
      n1 = d0 = new BigNumber(ONE);
      d1 = n0 = new BigNumber(ONE);
      s = coeffToString(xc);

      // Determine initial denominator.
      // d is a power of 10 and the minimum max denominator that specifies the value exactly.
      e = d.e = s.length - x.e - 1;
      d.c[0] = POWS_TEN[(exp = e % LOG_BASE) < 0 ? LOG_BASE + exp : exp];
      md = !md || n.comparedTo(d) > 0 ? (e > 0 ? d : n1) : n;

      exp = MAX_EXP;
      MAX_EXP = 1 / 0;
      n = new BigNumber(s);

      // n0 = d1 = 0
      n0.c[0] = 0;

      for (; ;)  {
        q = div(n, d, 0, 1);
        d2 = d0.plus(q.times(d1));
        if (d2.comparedTo(md) == 1) break;
        d0 = d1;
        d1 = d2;
        n1 = n0.plus(q.times(d2 = n1));
        n0 = d2;
        d = n.minus(q.times(d2 = d));
        n = d2;
      }

      d2 = div(md.minus(d0), d1, 0, 1);
      n0 = n0.plus(d2.times(n1));
      d0 = d0.plus(d2.times(d1));
      n0.s = n1.s = x.s;
      e = e * 2;

      // Determine which fraction is closer to x, n0/d0 or n1/d1
      r = div(n1, d1, e, ROUNDING_MODE).minus(x).abs().comparedTo(
          div(n0, d0, e, ROUNDING_MODE).minus(x).abs()) < 1 ? [n1, d1] : [n0, d0];

      MAX_EXP = exp;

      return r;
    };


    /*
     * Return the value of this BigNumber converted to a number primitive.
     */
    P.toNumber = function () {
      return +valueOf(this);
    };


    /*
     * Return a string representing the value of this BigNumber rounded to sd significant digits
     * using rounding mode rm or ROUNDING_MODE. If sd is less than the number of digits
     * necessary to represent the integer part of the value in fixed-point notation, then use
     * exponential notation.
     *
     * [sd] {number} Significant digits. Integer, 1 to MAX inclusive.
     * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
     *
     * '[BigNumber Error] Argument {not a primitive number|not an integer|out of range}: {sd|rm}'
     */
    P.toPrecision = function (sd, rm) {
      if (sd != null) intCheck(sd, 1, MAX);
      return format(this, sd, rm, 2);
    };


    /*
     * Return a string representing the value of this BigNumber in base b, or base 10 if b is
     * omitted. If a base is specified, including base 10, round according to DECIMAL_PLACES and
     * ROUNDING_MODE. If a base is not specified, and this BigNumber has a positive exponent
     * that is equal to or greater than TO_EXP_POS, or a negative exponent equal to or less than
     * TO_EXP_NEG, return exponential notation.
     *
     * [b] {number} Integer, 2 to ALPHABET.length inclusive.
     *
     * '[BigNumber Error] Base {not a primitive number|not an integer|out of range}: {b}'
     */
    P.toString = function (b) {
      var str,
        n = this,
        s = n.s,
        e = n.e;

      // Infinity or NaN?
      if (e === null) {
        if (s) {
          str = 'Infinity';
          if (s < 0) str = '-' + str;
        } else {
          str = 'NaN';
        }
      } else {
        if (b == null) {
          str = e <= TO_EXP_NEG || e >= TO_EXP_POS
           ? toExponential(coeffToString(n.c), e)
           : toFixedPoint(coeffToString(n.c), e, '0');
        } else if (b === 10 && alphabetHasNormalDecimalDigits) {
          n = round(new BigNumber(n), DECIMAL_PLACES + e + 1, ROUNDING_MODE);
          str = toFixedPoint(coeffToString(n.c), n.e, '0');
        } else {
          intCheck(b, 2, ALPHABET.length, 'Base');
          str = convertBase(toFixedPoint(coeffToString(n.c), e, '0'), 10, b, s, true);
        }

        if (s < 0 && n.c[0]) str = '-' + str;
      }

      return str;
    };


    /*
     * Return as toString, but do not accept a base argument, and include the minus sign for
     * negative zero.
     */
    P.valueOf = P.toJSON = function () {
      return valueOf(this);
    };


    P._isBigNumber = true;

    if (configObject != null) BigNumber.set(configObject);

    return BigNumber;
  }


  // PRIVATE HELPER FUNCTIONS

  // These functions don't need access to variables,
  // e.g. DECIMAL_PLACES, in the scope of the `clone` function above.


  function bitFloor(n) {
    var i = n | 0;
    return n > 0 || n === i ? i : i - 1;
  }


  // Return a coefficient array as a string of base 10 digits.
  function coeffToString(a) {
    var s, z,
      i = 1,
      j = a.length,
      r = a[0] + '';

    for (; i < j;) {
      s = a[i++] + '';
      z = LOG_BASE - s.length;
      for (; z--; s = '0' + s);
      r += s;
    }

    // Determine trailing zeros.
    for (j = r.length; r.charCodeAt(--j) === 48;);

    return r.slice(0, j + 1 || 1);
  }


  // Compare the value of BigNumbers x and y.
  function compare(x, y) {
    var a, b,
      xc = x.c,
      yc = y.c,
      i = x.s,
      j = y.s,
      k = x.e,
      l = y.e;

    // Either NaN?
    if (!i || !j) return null;

    a = xc && !xc[0];
    b = yc && !yc[0];

    // Either zero?
    if (a || b) return a ? b ? 0 : -j : i;

    // Signs differ?
    if (i != j) return i;

    a = i < 0;
    b = k == l;

    // Either Infinity?
    if (!xc || !yc) return b ? 0 : !xc ^ a ? 1 : -1;

    // Compare exponents.
    if (!b) return k > l ^ a ? 1 : -1;

    j = (k = xc.length) < (l = yc.length) ? k : l;

    // Compare digit by digit.
    for (i = 0; i < j; i++) if (xc[i] != yc[i]) return xc[i] > yc[i] ^ a ? 1 : -1;

    // Compare lengths.
    return k == l ? 0 : k > l ^ a ? 1 : -1;
  }


  /*
   * Check that n is a primitive number, an integer, and in range, otherwise throw.
   */
  function intCheck(n, min, max, name) {
    if (n < min || n > max || n !== mathfloor(n)) {
      throw Error
       (bignumberError + (name || 'Argument') + (typeof n == 'number'
         ? n < min || n > max ? ' out of range: ' : ' not an integer: '
         : ' not a primitive number: ') + String(n));
    }
  }


  // Assumes finite n.
  function isOdd(n) {
    var k = n.c.length - 1;
    return bitFloor(n.e / LOG_BASE) == k && n.c[k] % 2 != 0;
  }


  function toExponential(str, e) {
    return (str.length > 1 ? str.charAt(0) + '.' + str.slice(1) : str) +
     (e < 0 ? 'e' : 'e+') + e;
  }


  function toFixedPoint(str, e, z) {
    var len, zs;

    // Negative exponent?
    if (e < 0) {

      // Prepend zeros.
      for (zs = z + '.'; ++e; zs += z);
      str = zs + str;

    // Positive exponent
    } else {
      len = str.length;

      // Append zeros.
      if (++e > len) {
        for (zs = z, e -= len; --e; zs += z);
        str += zs;
      } else if (e < len) {
        str = str.slice(0, e) + '.' + str.slice(e);
      }
    }

    return str;
  }


  // EXPORT


  BigNumber = clone();
  BigNumber['default'] = BigNumber.BigNumber = BigNumber;

  // AMD.
  if (typeof define == 'function' && define.amd) {
    define(function () { return BigNumber; });

  // Node.js and other environments that support module.exports.
  } else if (typeof module != 'undefined' && module.exports) {
    module.exports = BigNumber;

  // Browser.
  } else {
    if (!globalObject) {
      globalObject = typeof self != 'undefined' && self ? self : window;
    }

    globalObject.BigNumber = BigNumber;
  }
})(this);

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>bignumber.js",file:"node_modules\\gridplus-sdk\\node_modules\\bignumber.js\\bignumber.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\rlp\\dist\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5Crlp%5Cdist%5Cindex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.utils = exports.decode = exports.encode = void 0;
/**
 * RLP Encoding based on https://eth.wiki/en/fundamentals/rlp
 * This function takes in data, converts it to Uint8Array if not,
 * and adds a length for recursion.
 * @param input Will be converted to Uint8Array
 * @returns Uint8Array of encoded data
 **/
function encode(input) {
    if (Array.isArray(input)) {
        const output = [];
        for (let i = 0; i < input.length; i++) {
            output.push(encode(input[i]));
        }
        const buf = concatBytes(...output);
        return concatBytes(encodeLength(buf.length, 192), buf);
    }
    const inputBuf = toBytes(input);
    if (inputBuf.length === 1 && inputBuf[0] < 128) {
        return inputBuf;
    }
    return concatBytes(encodeLength(inputBuf.length, 128), inputBuf);
}
exports.encode = encode;
/**
 * Slices a Uint8Array, throws if the slice goes out-of-bounds of the Uint8Array.
 * E.g. `safeSlice(hexToBytes('aa'), 1, 2)` will throw.
 * @param input
 * @param start
 * @param end
 */
function safeSlice(input, start, end) {
    if (end > input.length) {
        throw new Error('invalid RLP (safeSlice): end slice of Uint8Array out-of-bounds');
    }
    return input.slice(start, end);
}
/**
 * Parse integers. Check if there is no leading zeros
 * @param v The value to parse
 */
function decodeLength(v) {
    if (v[0] === 0) {
        throw new Error('invalid RLP: extra zeros');
    }
    return parseHexByte(bytesToHex(v));
}
function encodeLength(len, offset) {
    if (len < 56) {
        return Uint8Array.from([len + offset]);
    }
    const hexLength = numberToHex(len);
    const lLength = hexLength.length / 2;
    const firstByte = numberToHex(offset + 55 + lLength);
    return Uint8Array.from(hexToBytes(firstByte + hexLength));
}
function decode(input, stream = false) {
    if (!input || input.length === 0) {
        return Uint8Array.from([]);
    }
    const inputBytes = toBytes(input);
    const decoded = _decode(inputBytes);
    if (stream) {
        return decoded;
    }
    if (decoded.remainder.length !== 0) {
        throw new Error('invalid RLP: remainder must be zero');
    }
    return decoded.data;
}
exports.decode = decode;
/** Decode an input with RLP */
function _decode(input) {
    let length, llength, data, innerRemainder, d;
    const decoded = [];
    const firstByte = input[0];
    if (firstByte <= 0x7f) {
        // a single byte whose value is in the [0x00, 0x7f] range, that byte is its own RLP encoding.
        return {
            data: input.slice(0, 1),
            remainder: input.slice(1),
        };
    }
    else if (firstByte <= 0xb7) {
        // string is 0-55 bytes long. A single byte with value 0x80 plus the length of the string followed by the string
        // The range of the first byte is [0x80, 0xb7]
        length = firstByte - 0x7f;
        // set 0x80 null to 0
        if (firstByte === 0x80) {
            data = Uint8Array.from([]);
        }
        else {
            data = safeSlice(input, 1, length);
        }
        if (length === 2 && data[0] < 0x80) {
            throw new Error('invalid RLP encoding: invalid prefix, single byte < 0x80 are not prefixed');
        }
        return {
            data: data,
            remainder: input.slice(length),
        };
    }
    else if (firstByte <= 0xbf) {
        // string is greater than 55 bytes long. A single byte with the value (0xb7 plus the length of the length),
        // followed by the length, followed by the string
        llength = firstByte - 0xb6;
        if (input.length - 1 < llength) {
            throw new Error('invalid RLP: not enough bytes for string length');
        }
        length = decodeLength(safeSlice(input, 1, llength));
        if (length <= 55) {
            throw new Error('invalid RLP: expected string length to be greater than 55');
        }
        data = safeSlice(input, llength, length + llength);
        return {
            data: data,
            remainder: input.slice(length + llength),
        };
    }
    else if (firstByte <= 0xf7) {
        // a list between 0-55 bytes long
        length = firstByte - 0xbf;
        innerRemainder = safeSlice(input, 1, length);
        while (innerRemainder.length) {
            d = _decode(innerRemainder);
            decoded.push(d.data);
            innerRemainder = d.remainder;
        }
        return {
            data: decoded,
            remainder: input.slice(length),
        };
    }
    else {
        // a list over 55 bytes long
        llength = firstByte - 0xf6;
        length = decodeLength(safeSlice(input, 1, llength));
        if (length < 56) {
            throw new Error('invalid RLP: encoded list too short');
        }
        const totalLength = llength + length;
        if (totalLength > input.length) {
            throw new Error('invalid RLP: total length is larger than the data');
        }
        innerRemainder = safeSlice(input, llength, totalLength);
        while (innerRemainder.length) {
            d = _decode(innerRemainder);
            decoded.push(d.data);
            innerRemainder = d.remainder;
        }
        return {
            data: decoded,
            remainder: input.slice(totalLength),
        };
    }
}
const cachedHexes = Array.from({ length: 256 }, (_v, i) => i.toString(16).padStart(2, '0'));
function bytesToHex(uint8a) {
    // Pre-caching chars with `cachedHexes` speeds this up 6x
    let hex = '';
    for (let i = 0; i < uint8a.length; i++) {
        hex += cachedHexes[uint8a[i]];
    }
    return hex;
}
function parseHexByte(hexByte) {
    const byte = Number.parseInt(hexByte, 16);
    if (Number.isNaN(byte))
        throw new Error('Invalid byte sequence');
    return byte;
}
// Caching slows it down 2-3x
function hexToBytes(hex) {
    if (typeof hex !== 'string') {
        throw new TypeError('hexToBytes: expected string, got ' + typeof hex);
    }
    if (hex.length % 2)
        throw new Error('hexToBytes: received invalid unpadded hex');
    const array = new Uint8Array(hex.length / 2);
    for (let i = 0; i < array.length; i++) {
        const j = i * 2;
        array[i] = parseHexByte(hex.slice(j, j + 2));
    }
    return array;
}
/** Concatenates two Uint8Arrays into one. */
function concatBytes(...arrays) {
    if (arrays.length === 1)
        return arrays[0];
    const length = arrays.reduce((a, arr) => a + arr.length, 0);
    const result = new Uint8Array(length);
    for (let i = 0, pad = 0; i < arrays.length; i++) {
        const arr = arrays[i];
        result.set(arr, pad);
        pad += arr.length;
    }
    return result;
}
function utf8ToBytes(utf) {
    return new TextEncoder().encode(utf);
}
/** Transform an integer into its hexadecimal value */
function numberToHex(integer) {
    if (integer < 0) {
        throw new Error('Invalid integer as argument, must be unsigned!');
    }
    const hex = integer.toString(16);
    return hex.length % 2 ? `0${hex}` : hex;
}
/** Pad a string to be even */
function padToEven(a) {
    return a.length % 2 ? `0${a}` : a;
}
/** Check if a string is prefixed by 0x */
function isHexPrefixed(str) {
    return str.length >= 2 && str[0] === '0' && str[1] === 'x';
}
/** Removes 0x from a given String */
function stripHexPrefix(str) {
    if (typeof str !== 'string') {
        return str;
    }
    return isHexPrefixed(str) ? str.slice(2) : str;
}
/** Transform anything into a Uint8Array */
function toBytes(v) {
    if (v instanceof Uint8Array) {
        return v;
    }
    if (typeof v === 'string') {
        if (isHexPrefixed(v)) {
            return hexToBytes(padToEven(stripHexPrefix(v)));
        }
        return utf8ToBytes(v);
    }
    if (typeof v === 'number' || typeof v === 'bigint') {
        if (!v) {
            return Uint8Array.from([]);
        }
        return hexToBytes(numberToHex(v));
    }
    if (v === null || v === undefined) {
        return Uint8Array.from([]);
    }
    throw new Error('toBytes: received unsupported type ' + typeof v);
}
exports.utils = {
    bytesToHex,
    concatBytes,
    hexToBytes,
    utf8ToBytes,
};
const RLP = { encode, decode };
exports.default = RLP;

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>rlp",file:"node_modules\\gridplus-sdk\\node_modules\\rlp\\dist\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\index.js", {"./nil.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\nil.js","./parse.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\parse.js","./stringify.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\stringify.js","./v1.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\v1.js","./v3.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\v3.js","./v4.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\v4.js","./v5.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\v5.js","./validate.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\validate.js","./version.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\version.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5Cuuid%5Cdist%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NIL", {
  enumerable: true,
  get: function () {
    return _nil.default;
  }
});
Object.defineProperty(exports, "parse", {
  enumerable: true,
  get: function () {
    return _parse.default;
  }
});
Object.defineProperty(exports, "stringify", {
  enumerable: true,
  get: function () {
    return _stringify.default;
  }
});
Object.defineProperty(exports, "v1", {
  enumerable: true,
  get: function () {
    return _v.default;
  }
});
Object.defineProperty(exports, "v3", {
  enumerable: true,
  get: function () {
    return _v2.default;
  }
});
Object.defineProperty(exports, "v4", {
  enumerable: true,
  get: function () {
    return _v3.default;
  }
});
Object.defineProperty(exports, "v5", {
  enumerable: true,
  get: function () {
    return _v4.default;
  }
});
Object.defineProperty(exports, "validate", {
  enumerable: true,
  get: function () {
    return _validate.default;
  }
});
Object.defineProperty(exports, "version", {
  enumerable: true,
  get: function () {
    return _version.default;
  }
});

var _v = _interopRequireDefault(require("./v1.js"));

var _v2 = _interopRequireDefault(require("./v3.js"));

var _v3 = _interopRequireDefault(require("./v4.js"));

var _v4 = _interopRequireDefault(require("./v5.js"));

var _nil = _interopRequireDefault(require("./nil.js"));

var _version = _interopRequireDefault(require("./version.js"));

var _validate = _interopRequireDefault(require("./validate.js"));

var _stringify = _interopRequireDefault(require("./stringify.js"));

var _parse = _interopRequireDefault(require("./parse.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\md5-browser.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5Cuuid%5Cdist%5Cmd5-browser.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

/*
 * Browser-compatible JavaScript MD5
 *
 * Modification of JavaScript MD5
 * https://github.com/blueimp/JavaScript-MD5
 *
 * Copyright 2011, Sebastian Tschan
 * https://blueimp.net
 *
 * Licensed under the MIT license:
 * https://opensource.org/licenses/MIT
 *
 * Based on
 * A JavaScript implementation of the RSA Data Security, Inc. MD5 Message
 * Digest Algorithm, as defined in RFC 1321.
 * Version 2.2 Copyright (C) Paul Johnston 1999 - 2009
 * Other contributors: Greg Holt, Andrew Kepert, Ydnar, Lostinet
 * Distributed under the BSD License
 * See http://pajhome.org.uk/crypt/md5 for more info.
 */
function md5(bytes) {
  if (typeof bytes === 'string') {
    const msg = unescape(encodeURIComponent(bytes)); // UTF8 escape

    bytes = new Uint8Array(msg.length);

    for (let i = 0; i < msg.length; ++i) {
      bytes[i] = msg.charCodeAt(i);
    }
  }

  return md5ToHexEncodedArray(wordsToMd5(bytesToWords(bytes), bytes.length * 8));
}
/*
 * Convert an array of little-endian words to an array of bytes
 */


function md5ToHexEncodedArray(input) {
  const output = [];
  const length32 = input.length * 32;
  const hexTab = '0123456789abcdef';

  for (let i = 0; i < length32; i += 8) {
    const x = input[i >> 5] >>> i % 32 & 0xff;
    const hex = parseInt(hexTab.charAt(x >>> 4 & 0x0f) + hexTab.charAt(x & 0x0f), 16);
    output.push(hex);
  }

  return output;
}
/**
 * Calculate output length with padding and bit length
 */


function getOutputLength(inputLength8) {
  return (inputLength8 + 64 >>> 9 << 4) + 14 + 1;
}
/*
 * Calculate the MD5 of an array of little-endian words, and a bit length.
 */


function wordsToMd5(x, len) {
  /* append padding */
  x[len >> 5] |= 0x80 << len % 32;
  x[getOutputLength(len) - 1] = len;
  let a = 1732584193;
  let b = -271733879;
  let c = -1732584194;
  let d = 271733878;

  for (let i = 0; i < x.length; i += 16) {
    const olda = a;
    const oldb = b;
    const oldc = c;
    const oldd = d;
    a = md5ff(a, b, c, d, x[i], 7, -680876936);
    d = md5ff(d, a, b, c, x[i + 1], 12, -389564586);
    c = md5ff(c, d, a, b, x[i + 2], 17, 606105819);
    b = md5ff(b, c, d, a, x[i + 3], 22, -1044525330);
    a = md5ff(a, b, c, d, x[i + 4], 7, -176418897);
    d = md5ff(d, a, b, c, x[i + 5], 12, 1200080426);
    c = md5ff(c, d, a, b, x[i + 6], 17, -1473231341);
    b = md5ff(b, c, d, a, x[i + 7], 22, -45705983);
    a = md5ff(a, b, c, d, x[i + 8], 7, 1770035416);
    d = md5ff(d, a, b, c, x[i + 9], 12, -1958414417);
    c = md5ff(c, d, a, b, x[i + 10], 17, -42063);
    b = md5ff(b, c, d, a, x[i + 11], 22, -1990404162);
    a = md5ff(a, b, c, d, x[i + 12], 7, 1804603682);
    d = md5ff(d, a, b, c, x[i + 13], 12, -40341101);
    c = md5ff(c, d, a, b, x[i + 14], 17, -1502002290);
    b = md5ff(b, c, d, a, x[i + 15], 22, 1236535329);
    a = md5gg(a, b, c, d, x[i + 1], 5, -165796510);
    d = md5gg(d, a, b, c, x[i + 6], 9, -1069501632);
    c = md5gg(c, d, a, b, x[i + 11], 14, 643717713);
    b = md5gg(b, c, d, a, x[i], 20, -373897302);
    a = md5gg(a, b, c, d, x[i + 5], 5, -701558691);
    d = md5gg(d, a, b, c, x[i + 10], 9, 38016083);
    c = md5gg(c, d, a, b, x[i + 15], 14, -660478335);
    b = md5gg(b, c, d, a, x[i + 4], 20, -405537848);
    a = md5gg(a, b, c, d, x[i + 9], 5, 568446438);
    d = md5gg(d, a, b, c, x[i + 14], 9, -1019803690);
    c = md5gg(c, d, a, b, x[i + 3], 14, -187363961);
    b = md5gg(b, c, d, a, x[i + 8], 20, 1163531501);
    a = md5gg(a, b, c, d, x[i + 13], 5, -1444681467);
    d = md5gg(d, a, b, c, x[i + 2], 9, -51403784);
    c = md5gg(c, d, a, b, x[i + 7], 14, 1735328473);
    b = md5gg(b, c, d, a, x[i + 12], 20, -1926607734);
    a = md5hh(a, b, c, d, x[i + 5], 4, -378558);
    d = md5hh(d, a, b, c, x[i + 8], 11, -2022574463);
    c = md5hh(c, d, a, b, x[i + 11], 16, 1839030562);
    b = md5hh(b, c, d, a, x[i + 14], 23, -35309556);
    a = md5hh(a, b, c, d, x[i + 1], 4, -1530992060);
    d = md5hh(d, a, b, c, x[i + 4], 11, 1272893353);
    c = md5hh(c, d, a, b, x[i + 7], 16, -155497632);
    b = md5hh(b, c, d, a, x[i + 10], 23, -1094730640);
    a = md5hh(a, b, c, d, x[i + 13], 4, 681279174);
    d = md5hh(d, a, b, c, x[i], 11, -358537222);
    c = md5hh(c, d, a, b, x[i + 3], 16, -722521979);
    b = md5hh(b, c, d, a, x[i + 6], 23, 76029189);
    a = md5hh(a, b, c, d, x[i + 9], 4, -640364487);
    d = md5hh(d, a, b, c, x[i + 12], 11, -421815835);
    c = md5hh(c, d, a, b, x[i + 15], 16, 530742520);
    b = md5hh(b, c, d, a, x[i + 2], 23, -995338651);
    a = md5ii(a, b, c, d, x[i], 6, -198630844);
    d = md5ii(d, a, b, c, x[i + 7], 10, 1126891415);
    c = md5ii(c, d, a, b, x[i + 14], 15, -1416354905);
    b = md5ii(b, c, d, a, x[i + 5], 21, -57434055);
    a = md5ii(a, b, c, d, x[i + 12], 6, 1700485571);
    d = md5ii(d, a, b, c, x[i + 3], 10, -1894986606);
    c = md5ii(c, d, a, b, x[i + 10], 15, -1051523);
    b = md5ii(b, c, d, a, x[i + 1], 21, -2054922799);
    a = md5ii(a, b, c, d, x[i + 8], 6, 1873313359);
    d = md5ii(d, a, b, c, x[i + 15], 10, -30611744);
    c = md5ii(c, d, a, b, x[i + 6], 15, -1560198380);
    b = md5ii(b, c, d, a, x[i + 13], 21, 1309151649);
    a = md5ii(a, b, c, d, x[i + 4], 6, -145523070);
    d = md5ii(d, a, b, c, x[i + 11], 10, -1120210379);
    c = md5ii(c, d, a, b, x[i + 2], 15, 718787259);
    b = md5ii(b, c, d, a, x[i + 9], 21, -343485551);
    a = safeAdd(a, olda);
    b = safeAdd(b, oldb);
    c = safeAdd(c, oldc);
    d = safeAdd(d, oldd);
  }

  return [a, b, c, d];
}
/*
 * Convert an array bytes to an array of little-endian words
 * Characters >255 have their high-byte silently ignored.
 */


function bytesToWords(input) {
  if (input.length === 0) {
    return [];
  }

  const length8 = input.length * 8;
  const output = new Uint32Array(getOutputLength(length8));

  for (let i = 0; i < length8; i += 8) {
    output[i >> 5] |= (input[i / 8] & 0xff) << i % 32;
  }

  return output;
}
/*
 * Add integers, wrapping at 2^32. This uses 16-bit operations internally
 * to work around bugs in some JS interpreters.
 */


function safeAdd(x, y) {
  const lsw = (x & 0xffff) + (y & 0xffff);
  const msw = (x >> 16) + (y >> 16) + (lsw >> 16);
  return msw << 16 | lsw & 0xffff;
}
/*
 * Bitwise rotate a 32-bit number to the left.
 */


function bitRotateLeft(num, cnt) {
  return num << cnt | num >>> 32 - cnt;
}
/*
 * These functions implement the four basic operations the algorithm uses.
 */


function md5cmn(q, a, b, x, s, t) {
  return safeAdd(bitRotateLeft(safeAdd(safeAdd(a, q), safeAdd(x, t)), s), b);
}

function md5ff(a, b, c, d, x, s, t) {
  return md5cmn(b & c | ~b & d, a, b, x, s, t);
}

function md5gg(a, b, c, d, x, s, t) {
  return md5cmn(b & d | c & ~d, a, b, x, s, t);
}

function md5hh(a, b, c, d, x, s, t) {
  return md5cmn(b ^ c ^ d, a, b, x, s, t);
}

function md5ii(a, b, c, d, x, s, t) {
  return md5cmn(c ^ (b | ~d), a, b, x, s, t);
}

var _default = md5;
exports.default = _default;
      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\md5-browser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\native-browser.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5Cuuid%5Cdist%5Cnative-browser.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
const randomUUID = typeof crypto !== 'undefined' && crypto.randomUUID && crypto.randomUUID.bind(crypto);
var _default = {
  randomUUID
};
exports.default = _default;
      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\native-browser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\nil.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5Cuuid%5Cdist%5Cnil.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default = '00000000-0000-0000-0000-000000000000';
exports.default = _default;
      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\nil.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\parse.js", {"./validate.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\validate.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5Cuuid%5Cdist%5Cparse.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _validate = _interopRequireDefault(require("./validate.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function parse(uuid) {
  if (!(0, _validate.default)(uuid)) {
    throw TypeError('Invalid UUID');
  }

  let v;
  const arr = new Uint8Array(16); // Parse ########-....-....-....-............

  arr[0] = (v = parseInt(uuid.slice(0, 8), 16)) >>> 24;
  arr[1] = v >>> 16 & 0xff;
  arr[2] = v >>> 8 & 0xff;
  arr[3] = v & 0xff; // Parse ........-####-....-....-............

  arr[4] = (v = parseInt(uuid.slice(9, 13), 16)) >>> 8;
  arr[5] = v & 0xff; // Parse ........-....-####-....-............

  arr[6] = (v = parseInt(uuid.slice(14, 18), 16)) >>> 8;
  arr[7] = v & 0xff; // Parse ........-....-....-####-............

  arr[8] = (v = parseInt(uuid.slice(19, 23), 16)) >>> 8;
  arr[9] = v & 0xff; // Parse ........-....-....-....-############
  // (Use "/" to avoid 32-bit truncation when bit-shifting high-order bytes)

  arr[10] = (v = parseInt(uuid.slice(24, 36), 16)) / 0x10000000000 & 0xff;
  arr[11] = v / 0x100000000 & 0xff;
  arr[12] = v >>> 24 & 0xff;
  arr[13] = v >>> 16 & 0xff;
  arr[14] = v >>> 8 & 0xff;
  arr[15] = v & 0xff;
  return arr;
}

var _default = parse;
exports.default = _default;
      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\parse.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\regex.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5Cuuid%5Cdist%5Cregex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default = /^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i;
exports.default = _default;
      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\regex.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\rng-browser.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5Cuuid%5Cdist%5Crng-browser.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = rng;
// Unique ID creation requires a high quality random # generator. In the browser we therefore
// require the crypto API and do not support built-in fallback to lower quality random number
// generators (like Math.random()).
let getRandomValues;
const rnds8 = new Uint8Array(16);

function rng() {
  // lazy load so that environments that need to polyfill have a chance to do so
  if (!getRandomValues) {
    // getRandomValues needs to be invoked in a context where "this" is a Crypto implementation.
    getRandomValues = typeof crypto !== 'undefined' && crypto.getRandomValues && crypto.getRandomValues.bind(crypto);

    if (!getRandomValues) {
      throw new Error('crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported');
    }
  }

  return getRandomValues(rnds8);
}
      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\rng-browser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\sha1-browser.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5Cuuid%5Cdist%5Csha1-browser.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

// Adapted from Chris Veness' SHA1 code at
// http://www.movable-type.co.uk/scripts/sha1.html
function f(s, x, y, z) {
  switch (s) {
    case 0:
      return x & y ^ ~x & z;

    case 1:
      return x ^ y ^ z;

    case 2:
      return x & y ^ x & z ^ y & z;

    case 3:
      return x ^ y ^ z;
  }
}

function ROTL(x, n) {
  return x << n | x >>> 32 - n;
}

function sha1(bytes) {
  const K = [0x5a827999, 0x6ed9eba1, 0x8f1bbcdc, 0xca62c1d6];
  const H = [0x67452301, 0xefcdab89, 0x98badcfe, 0x10325476, 0xc3d2e1f0];

  if (typeof bytes === 'string') {
    const msg = unescape(encodeURIComponent(bytes)); // UTF8 escape

    bytes = [];

    for (let i = 0; i < msg.length; ++i) {
      bytes.push(msg.charCodeAt(i));
    }
  } else if (!Array.isArray(bytes)) {
    // Convert Array-like to Array
    bytes = Array.prototype.slice.call(bytes);
  }

  bytes.push(0x80);
  const l = bytes.length / 4 + 2;
  const N = Math.ceil(l / 16);
  const M = new Array(N);

  for (let i = 0; i < N; ++i) {
    const arr = new Uint32Array(16);

    for (let j = 0; j < 16; ++j) {
      arr[j] = bytes[i * 64 + j * 4] << 24 | bytes[i * 64 + j * 4 + 1] << 16 | bytes[i * 64 + j * 4 + 2] << 8 | bytes[i * 64 + j * 4 + 3];
    }

    M[i] = arr;
  }

  M[N - 1][14] = (bytes.length - 1) * 8 / Math.pow(2, 32);
  M[N - 1][14] = Math.floor(M[N - 1][14]);
  M[N - 1][15] = (bytes.length - 1) * 8 & 0xffffffff;

  for (let i = 0; i < N; ++i) {
    const W = new Uint32Array(80);

    for (let t = 0; t < 16; ++t) {
      W[t] = M[i][t];
    }

    for (let t = 16; t < 80; ++t) {
      W[t] = ROTL(W[t - 3] ^ W[t - 8] ^ W[t - 14] ^ W[t - 16], 1);
    }

    let a = H[0];
    let b = H[1];
    let c = H[2];
    let d = H[3];
    let e = H[4];

    for (let t = 0; t < 80; ++t) {
      const s = Math.floor(t / 20);
      const T = ROTL(a, 5) + f(s, b, c, d) + e + K[s] + W[t] >>> 0;
      e = d;
      d = c;
      c = ROTL(b, 30) >>> 0;
      b = a;
      a = T;
    }

    H[0] = H[0] + a >>> 0;
    H[1] = H[1] + b >>> 0;
    H[2] = H[2] + c >>> 0;
    H[3] = H[3] + d >>> 0;
    H[4] = H[4] + e >>> 0;
  }

  return [H[0] >> 24 & 0xff, H[0] >> 16 & 0xff, H[0] >> 8 & 0xff, H[0] & 0xff, H[1] >> 24 & 0xff, H[1] >> 16 & 0xff, H[1] >> 8 & 0xff, H[1] & 0xff, H[2] >> 24 & 0xff, H[2] >> 16 & 0xff, H[2] >> 8 & 0xff, H[2] & 0xff, H[3] >> 24 & 0xff, H[3] >> 16 & 0xff, H[3] >> 8 & 0xff, H[3] & 0xff, H[4] >> 24 & 0xff, H[4] >> 16 & 0xff, H[4] >> 8 & 0xff, H[4] & 0xff];
}

var _default = sha1;
exports.default = _default;
      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\sha1-browser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\stringify.js", {"./validate.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\validate.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5Cuuid%5Cdist%5Cstringify.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.unsafeStringify = unsafeStringify;

var _validate = _interopRequireDefault(require("./validate.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Convert array of 16 byte values to UUID string format of the form:
 * XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX
 */
const byteToHex = [];

for (let i = 0; i < 256; ++i) {
  byteToHex.push((i + 0x100).toString(16).slice(1));
}

function unsafeStringify(arr, offset = 0) {
  // Note: Be careful editing this code!  It's been tuned for performance
  // and works in ways you may not expect. See https://github.com/uuidjs/uuid/pull/434
  return byteToHex[arr[offset + 0]] + byteToHex[arr[offset + 1]] + byteToHex[arr[offset + 2]] + byteToHex[arr[offset + 3]] + '-' + byteToHex[arr[offset + 4]] + byteToHex[arr[offset + 5]] + '-' + byteToHex[arr[offset + 6]] + byteToHex[arr[offset + 7]] + '-' + byteToHex[arr[offset + 8]] + byteToHex[arr[offset + 9]] + '-' + byteToHex[arr[offset + 10]] + byteToHex[arr[offset + 11]] + byteToHex[arr[offset + 12]] + byteToHex[arr[offset + 13]] + byteToHex[arr[offset + 14]] + byteToHex[arr[offset + 15]];
}

function stringify(arr, offset = 0) {
  const uuid = unsafeStringify(arr, offset); // Consistency check for valid UUID.  If this throws, it's likely due to one
  // of the following:
  // - One or more input array values don't map to a hex octet (leading to
  // "undefined" in the uuid)
  // - Invalid input values for the RFC `version` or `variant` fields

  if (!(0, _validate.default)(uuid)) {
    throw TypeError('Stringified UUID is invalid');
  }

  return uuid;
}

var _default = stringify;
exports.default = _default;
      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\stringify.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\v1.js", {"./rng.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\rng-browser.js","./stringify.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\stringify.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5Cuuid%5Cdist%5Cv1.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _rng = _interopRequireDefault(require("./rng.js"));

var _stringify = require("./stringify.js");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// **`v1()` - Generate time-based UUID**
//
// Inspired by https://github.com/LiosK/UUID.js
// and http://docs.python.org/library/uuid.html
let _nodeId;

let _clockseq; // Previous uuid creation time


let _lastMSecs = 0;
let _lastNSecs = 0; // See https://github.com/uuidjs/uuid for API details

function v1(options, buf, offset) {
  let i = buf && offset || 0;
  const b = buf || new Array(16);
  options = options || {};
  let node = options.node || _nodeId;
  let clockseq = options.clockseq !== undefined ? options.clockseq : _clockseq; // node and clockseq need to be initialized to random values if they're not
  // specified.  We do this lazily to minimize issues related to insufficient
  // system entropy.  See #189

  if (node == null || clockseq == null) {
    const seedBytes = options.random || (options.rng || _rng.default)();

    if (node == null) {
      // Per 4.5, create and 48-bit node id, (47 random bits + multicast bit = 1)
      node = _nodeId = [seedBytes[0] | 0x01, seedBytes[1], seedBytes[2], seedBytes[3], seedBytes[4], seedBytes[5]];
    }

    if (clockseq == null) {
      // Per 4.2.2, randomize (14 bit) clockseq
      clockseq = _clockseq = (seedBytes[6] << 8 | seedBytes[7]) & 0x3fff;
    }
  } // UUID timestamps are 100 nano-second units since the Gregorian epoch,
  // (1582-10-15 00:00).  JSNumbers aren't precise enough for this, so
  // time is handled internally as 'msecs' (integer milliseconds) and 'nsecs'
  // (100-nanoseconds offset from msecs) since unix epoch, 1970-01-01 00:00.


  let msecs = options.msecs !== undefined ? options.msecs : Date.now(); // Per 4.2.1.2, use count of uuid's generated during the current clock
  // cycle to simulate higher resolution clock

  let nsecs = options.nsecs !== undefined ? options.nsecs : _lastNSecs + 1; // Time since last uuid creation (in msecs)

  const dt = msecs - _lastMSecs + (nsecs - _lastNSecs) / 10000; // Per 4.2.1.2, Bump clockseq on clock regression

  if (dt < 0 && options.clockseq === undefined) {
    clockseq = clockseq + 1 & 0x3fff;
  } // Reset nsecs if clock regresses (new clockseq) or we've moved onto a new
  // time interval


  if ((dt < 0 || msecs > _lastMSecs) && options.nsecs === undefined) {
    nsecs = 0;
  } // Per 4.2.1.2 Throw error if too many uuids are requested


  if (nsecs >= 10000) {
    throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");
  }

  _lastMSecs = msecs;
  _lastNSecs = nsecs;
  _clockseq = clockseq; // Per 4.1.4 - Convert from unix epoch to Gregorian epoch

  msecs += 12219292800000; // `time_low`

  const tl = ((msecs & 0xfffffff) * 10000 + nsecs) % 0x100000000;
  b[i++] = tl >>> 24 & 0xff;
  b[i++] = tl >>> 16 & 0xff;
  b[i++] = tl >>> 8 & 0xff;
  b[i++] = tl & 0xff; // `time_mid`

  const tmh = msecs / 0x100000000 * 10000 & 0xfffffff;
  b[i++] = tmh >>> 8 & 0xff;
  b[i++] = tmh & 0xff; // `time_high_and_version`

  b[i++] = tmh >>> 24 & 0xf | 0x10; // include version

  b[i++] = tmh >>> 16 & 0xff; // `clock_seq_hi_and_reserved` (Per 4.2.2 - include variant)

  b[i++] = clockseq >>> 8 | 0x80; // `clock_seq_low`

  b[i++] = clockseq & 0xff; // `node`

  for (let n = 0; n < 6; ++n) {
    b[i + n] = node[n];
  }

  return buf || (0, _stringify.unsafeStringify)(b);
}

var _default = v1;
exports.default = _default;
      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\v1.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\v3.js", {"./md5.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\md5-browser.js","./v35.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\v35.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5Cuuid%5Cdist%5Cv3.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _v = _interopRequireDefault(require("./v35.js"));

var _md = _interopRequireDefault(require("./md5.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const v3 = (0, _v.default)('v3', 0x30, _md.default);
var _default = v3;
exports.default = _default;
      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\v3.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\v35.js", {"./parse.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\parse.js","./stringify.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\stringify.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5Cuuid%5Cdist%5Cv35.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URL = exports.DNS = void 0;
exports.default = v35;

var _stringify = require("./stringify.js");

var _parse = _interopRequireDefault(require("./parse.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function stringToBytes(str) {
  str = unescape(encodeURIComponent(str)); // UTF8 escape

  const bytes = [];

  for (let i = 0; i < str.length; ++i) {
    bytes.push(str.charCodeAt(i));
  }

  return bytes;
}

const DNS = '6ba7b810-9dad-11d1-80b4-00c04fd430c8';
exports.DNS = DNS;
const URL = '6ba7b811-9dad-11d1-80b4-00c04fd430c8';
exports.URL = URL;

function v35(name, version, hashfunc) {
  function generateUUID(value, namespace, buf, offset) {
    var _namespace;

    if (typeof value === 'string') {
      value = stringToBytes(value);
    }

    if (typeof namespace === 'string') {
      namespace = (0, _parse.default)(namespace);
    }

    if (((_namespace = namespace) === null || _namespace === void 0 ? void 0 : _namespace.length) !== 16) {
      throw TypeError('Namespace must be array-like (16 iterable integer values, 0-255)');
    } // Compute hash of namespace and value, Per 4.3
    // Future: Use spread syntax when supported on all platforms, e.g. `bytes =
    // hashfunc([...namespace, ... value])`


    let bytes = new Uint8Array(16 + value.length);
    bytes.set(namespace);
    bytes.set(value, namespace.length);
    bytes = hashfunc(bytes);
    bytes[6] = bytes[6] & 0x0f | version;
    bytes[8] = bytes[8] & 0x3f | 0x80;

    if (buf) {
      offset = offset || 0;

      for (let i = 0; i < 16; ++i) {
        buf[offset + i] = bytes[i];
      }

      return buf;
    }

    return (0, _stringify.unsafeStringify)(bytes);
  } // Function#name is not settable on some platforms (#270)


  try {
    generateUUID.name = name; // eslint-disable-next-line no-empty
  } catch (err) {} // For CommonJS default export support


  generateUUID.DNS = DNS;
  generateUUID.URL = URL;
  return generateUUID;
}
      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\v35.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\v4.js", {"./native.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\native-browser.js","./rng.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\rng-browser.js","./stringify.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\stringify.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5Cuuid%5Cdist%5Cv4.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _native = _interopRequireDefault(require("./native.js"));

var _rng = _interopRequireDefault(require("./rng.js"));

var _stringify = require("./stringify.js");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function v4(options, buf, offset) {
  if (_native.default.randomUUID && !buf && !options) {
    return _native.default.randomUUID();
  }

  options = options || {};

  const rnds = options.random || (options.rng || _rng.default)(); // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`


  rnds[6] = rnds[6] & 0x0f | 0x40;
  rnds[8] = rnds[8] & 0x3f | 0x80; // Copy bytes to buffer, if provided

  if (buf) {
    offset = offset || 0;

    for (let i = 0; i < 16; ++i) {
      buf[offset + i] = rnds[i];
    }

    return buf;
  }

  return (0, _stringify.unsafeStringify)(rnds);
}

var _default = v4;
exports.default = _default;
      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\v4.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\v5.js", {"./sha1.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\sha1-browser.js","./v35.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\v35.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5Cuuid%5Cdist%5Cv5.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _v = _interopRequireDefault(require("./v35.js"));

var _sha = _interopRequireDefault(require("./sha1.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const v5 = (0, _v.default)('v5', 0x50, _sha.default);
var _default = v5;
exports.default = _default;
      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\v5.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\validate.js", {"./regex.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\regex.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5Cuuid%5Cdist%5Cvalidate.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _regex = _interopRequireDefault(require("./regex.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function validate(uuid) {
  return typeof uuid === 'string' && _regex.default.test(uuid);
}

var _default = validate;
exports.default = _default;
      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\validate.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\version.js", {"./validate.js":"D:\\code\\v\\metamask-extension\\node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\validate.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cgridplus-sdk%5Cnode_modules%5Cuuid%5Cdist%5Cversion.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _validate = _interopRequireDefault(require("./validate.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function version(uuid) {
  if (!(0, _validate.default)(uuid)) {
    throw TypeError('Invalid UUID');
  }

  return parseInt(uuid.slice(14, 15), 16);
}

var _default = version;
exports.default = _default;
      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>uuid",file:"node_modules\\gridplus-sdk\\node_modules\\uuid\\dist\\version.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\idb\\build\\index.cjs", {"./wrap-idb-value.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\idb\\build\\wrap-idb-value.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cidb%5Cbuild%5Cindex.cjs
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var wrapIdbValue = require('./wrap-idb-value.cjs');

/**
 * Open a database.
 *
 * @param name Name of the database.
 * @param version Schema version.
 * @param callbacks Additional callbacks.
 */
function openDB(name, version, { blocked, upgrade, blocking, terminated } = {}) {
    const request = indexedDB.open(name, version);
    const openPromise = wrapIdbValue.wrap(request);
    if (upgrade) {
        request.addEventListener('upgradeneeded', (event) => {
            upgrade(wrapIdbValue.wrap(request.result), event.oldVersion, event.newVersion, wrapIdbValue.wrap(request.transaction), event);
        });
    }
    if (blocked) {
        request.addEventListener('blocked', (event) => blocked(
        // Casting due to https://github.com/microsoft/TypeScript-DOM-lib-generator/pull/1405
        event.oldVersion, event.newVersion, event));
    }
    openPromise
        .then((db) => {
        if (terminated)
            db.addEventListener('close', () => terminated());
        if (blocking) {
            db.addEventListener('versionchange', (event) => blocking(event.oldVersion, event.newVersion, event));
        }
    })
        .catch(() => { });
    return openPromise;
}
/**
 * Delete a database.
 *
 * @param name Name of the database.
 */
function deleteDB(name, { blocked } = {}) {
    const request = indexedDB.deleteDatabase(name);
    if (blocked) {
        request.addEventListener('blocked', (event) => blocked(
        // Casting due to https://github.com/microsoft/TypeScript-DOM-lib-generator/pull/1405
        event.oldVersion, event));
    }
    return wrapIdbValue.wrap(request).then(() => undefined);
}

const readMethods = ['get', 'getKey', 'getAll', 'getAllKeys', 'count'];
const writeMethods = ['put', 'add', 'delete', 'clear'];
const cachedMethods = new Map();
function getMethod(target, prop) {
    if (!(target instanceof IDBDatabase &&
        !(prop in target) &&
        typeof prop === 'string')) {
        return;
    }
    if (cachedMethods.get(prop))
        return cachedMethods.get(prop);
    const targetFuncName = prop.replace(/FromIndex$/, '');
    const useIndex = prop !== targetFuncName;
    const isWrite = writeMethods.includes(targetFuncName);
    if (
    // Bail if the target doesn't exist on the target. Eg, getAll isn't in Edge.
    !(targetFuncName in (useIndex ? IDBIndex : IDBObjectStore).prototype) ||
        !(isWrite || readMethods.includes(targetFuncName))) {
        return;
    }
    const method = async function (storeName, ...args) {
        // isWrite ? 'readwrite' : undefined gzipps better, but fails in Edge :(
        const tx = this.transaction(storeName, isWrite ? 'readwrite' : 'readonly');
        let target = tx.store;
        if (useIndex)
            target = target.index(args.shift());
        // Must reject if op rejects.
        // If it's a write operation, must reject if tx.done rejects.
        // Must reject with op rejection first.
        // Must resolve with op value.
        // Must handle both promises (no unhandled rejections)
        return (await Promise.all([
            target[targetFuncName](...args),
            isWrite && tx.done,
        ]))[0];
    };
    cachedMethods.set(prop, method);
    return method;
}
wrapIdbValue.replaceTraps((oldTraps) => ({
    ...oldTraps,
    get: (target, prop, receiver) => getMethod(target, prop) || oldTraps.get(target, prop, receiver),
    has: (target, prop) => !!getMethod(target, prop) || oldTraps.has(target, prop),
}));

exports.unwrap = wrapIdbValue.unwrap;
exports.wrap = wrapIdbValue.wrap;
exports.deleteDB = deleteDB;
exports.openDB = openDB;

      };
    };
  }
  }
}, {package:"@metamask/notification-services-controller>firebase>@firebase/app>idb",file:"node_modules\\idb\\build\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\idb\\build\\wrap-idb-value.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cidb%5Cbuild%5Cwrap-idb-value.cjs
      return function (require, module, exports) {
'use strict';

const instanceOfAny = (object, constructors) => constructors.some((c) => object instanceof c);

let idbProxyableTypes;
let cursorAdvanceMethods;
// This is a function to prevent it throwing up in node environments.
function getIdbProxyableTypes() {
    return (idbProxyableTypes ||
        (idbProxyableTypes = [
            IDBDatabase,
            IDBObjectStore,
            IDBIndex,
            IDBCursor,
            IDBTransaction,
        ]));
}
// This is a function to prevent it throwing up in node environments.
function getCursorAdvanceMethods() {
    return (cursorAdvanceMethods ||
        (cursorAdvanceMethods = [
            IDBCursor.prototype.advance,
            IDBCursor.prototype.continue,
            IDBCursor.prototype.continuePrimaryKey,
        ]));
}
const cursorRequestMap = new WeakMap();
const transactionDoneMap = new WeakMap();
const transactionStoreNamesMap = new WeakMap();
const transformCache = new WeakMap();
const reverseTransformCache = new WeakMap();
function promisifyRequest(request) {
    const promise = new Promise((resolve, reject) => {
        const unlisten = () => {
            request.removeEventListener('success', success);
            request.removeEventListener('error', error);
        };
        const success = () => {
            resolve(wrap(request.result));
            unlisten();
        };
        const error = () => {
            reject(request.error);
            unlisten();
        };
        request.addEventListener('success', success);
        request.addEventListener('error', error);
    });
    promise
        .then((value) => {
        // Since cursoring reuses the IDBRequest (*sigh*), we cache it for later retrieval
        // (see wrapFunction).
        if (value instanceof IDBCursor) {
            cursorRequestMap.set(value, request);
        }
        // Catching to avoid "Uncaught Promise exceptions"
    })
        .catch(() => { });
    // This mapping exists in reverseTransformCache but doesn't doesn't exist in transformCache. This
    // is because we create many promises from a single IDBRequest.
    reverseTransformCache.set(promise, request);
    return promise;
}
function cacheDonePromiseForTransaction(tx) {
    // Early bail if we've already created a done promise for this transaction.
    if (transactionDoneMap.has(tx))
        return;
    const done = new Promise((resolve, reject) => {
        const unlisten = () => {
            tx.removeEventListener('complete', complete);
            tx.removeEventListener('error', error);
            tx.removeEventListener('abort', error);
        };
        const complete = () => {
            resolve();
            unlisten();
        };
        const error = () => {
            reject(tx.error || new DOMException('AbortError', 'AbortError'));
            unlisten();
        };
        tx.addEventListener('complete', complete);
        tx.addEventListener('error', error);
        tx.addEventListener('abort', error);
    });
    // Cache it for later retrieval.
    transactionDoneMap.set(tx, done);
}
let idbProxyTraps = {
    get(target, prop, receiver) {
        if (target instanceof IDBTransaction) {
            // Special handling for transaction.done.
            if (prop === 'done')
                return transactionDoneMap.get(target);
            // Polyfill for objectStoreNames because of Edge.
            if (prop === 'objectStoreNames') {
                return target.objectStoreNames || transactionStoreNamesMap.get(target);
            }
            // Make tx.store return the only store in the transaction, or undefined if there are many.
            if (prop === 'store') {
                return receiver.objectStoreNames[1]
                    ? undefined
                    : receiver.objectStore(receiver.objectStoreNames[0]);
            }
        }
        // Else transform whatever we get back.
        return wrap(target[prop]);
    },
    set(target, prop, value) {
        target[prop] = value;
        return true;
    },
    has(target, prop) {
        if (target instanceof IDBTransaction &&
            (prop === 'done' || prop === 'store')) {
            return true;
        }
        return prop in target;
    },
};
function replaceTraps(callback) {
    idbProxyTraps = callback(idbProxyTraps);
}
function wrapFunction(func) {
    // Due to expected object equality (which is enforced by the caching in `wrap`), we
    // only create one new func per func.
    // Edge doesn't support objectStoreNames (booo), so we polyfill it here.
    if (func === IDBDatabase.prototype.transaction &&
        !('objectStoreNames' in IDBTransaction.prototype)) {
        return function (storeNames, ...args) {
            const tx = func.call(unwrap(this), storeNames, ...args);
            transactionStoreNamesMap.set(tx, storeNames.sort ? storeNames.sort() : [storeNames]);
            return wrap(tx);
        };
    }
    // Cursor methods are special, as the behaviour is a little more different to standard IDB. In
    // IDB, you advance the cursor and wait for a new 'success' on the IDBRequest that gave you the
    // cursor. It's kinda like a promise that can resolve with many values. That doesn't make sense
    // with real promises, so each advance methods returns a new promise for the cursor object, or
    // undefined if the end of the cursor has been reached.
    if (getCursorAdvanceMethods().includes(func)) {
        return function (...args) {
            // Calling the original function with the proxy as 'this' causes ILLEGAL INVOCATION, so we use
            // the original object.
            func.apply(unwrap(this), args);
            return wrap(cursorRequestMap.get(this));
        };
    }
    return function (...args) {
        // Calling the original function with the proxy as 'this' causes ILLEGAL INVOCATION, so we use
        // the original object.
        return wrap(func.apply(unwrap(this), args));
    };
}
function transformCachableValue(value) {
    if (typeof value === 'function')
        return wrapFunction(value);
    // This doesn't return, it just creates a 'done' promise for the transaction,
    // which is later returned for transaction.done (see idbObjectHandler).
    if (value instanceof IDBTransaction)
        cacheDonePromiseForTransaction(value);
    if (instanceOfAny(value, getIdbProxyableTypes()))
        return new Proxy(value, idbProxyTraps);
    // Return the same value back if we're not going to transform it.
    return value;
}
function wrap(value) {
    // We sometimes generate multiple promises from a single IDBRequest (eg when cursoring), because
    // IDB is weird and a single IDBRequest can yield many responses, so these can't be cached.
    if (value instanceof IDBRequest)
        return promisifyRequest(value);
    // If we've already transformed this value before, reuse the transformed value.
    // This is faster, but it also provides object equality.
    if (transformCache.has(value))
        return transformCache.get(value);
    const newValue = transformCachableValue(value);
    // Not all types are transformed.
    // These may be primitive types, so they can't be WeakMap keys.
    if (newValue !== value) {
        transformCache.set(value, newValue);
        reverseTransformCache.set(newValue, value);
    }
    return newValue;
}
const unwrap = (value) => reverseTransformCache.get(value);

exports.instanceOfAny = instanceOfAny;
exports.replaceTraps = replaceTraps;
exports.reverseTransformCache = reverseTransformCache;
exports.unwrap = unwrap;
exports.wrap = wrap;

      };
    };
  }
  }
}, {package:"@metamask/notification-services-controller>firebase>@firebase/app>idb",file:"node_modules\\idb\\build\\wrap-idb-value.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\is-retry-allowed\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cis-retry-allowed%5Cindex.js
      return function (require, module, exports) {
'use strict';

const denyList = new Set([
	'ENOTFOUND',
	'ENETUNREACH',

	// SSL errors from https://github.com/nodejs/node/blob/fc8e3e2cdc521978351de257030db0076d79e0ab/src/crypto/crypto_common.cc#L301-L328
	'UNABLE_TO_GET_ISSUER_CERT',
	'UNABLE_TO_GET_CRL',
	'UNABLE_TO_DECRYPT_CERT_SIGNATURE',
	'UNABLE_TO_DECRYPT_CRL_SIGNATURE',
	'UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY',
	'CERT_SIGNATURE_FAILURE',
	'CRL_SIGNATURE_FAILURE',
	'CERT_NOT_YET_VALID',
	'CERT_HAS_EXPIRED',
	'CRL_NOT_YET_VALID',
	'CRL_HAS_EXPIRED',
	'ERROR_IN_CERT_NOT_BEFORE_FIELD',
	'ERROR_IN_CERT_NOT_AFTER_FIELD',
	'ERROR_IN_CRL_LAST_UPDATE_FIELD',
	'ERROR_IN_CRL_NEXT_UPDATE_FIELD',
	'OUT_OF_MEM',
	'DEPTH_ZERO_SELF_SIGNED_CERT',
	'SELF_SIGNED_CERT_IN_CHAIN',
	'UNABLE_TO_GET_ISSUER_CERT_LOCALLY',
	'UNABLE_TO_VERIFY_LEAF_SIGNATURE',
	'CERT_CHAIN_TOO_LONG',
	'CERT_REVOKED',
	'INVALID_CA',
	'PATH_LENGTH_EXCEEDED',
	'INVALID_PURPOSE',
	'CERT_UNTRUSTED',
	'CERT_REJECTED',
	'HOSTNAME_MISMATCH'
]);

// TODO: Use `error?.code` when targeting Node.js 14
module.exports = error => !denyList.has(error && error.code);

      };
    };
  }
  }
}, {package:"is-retry-allowed",file:"node_modules\\is-retry-allowed\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\is-url\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cis-url%5Cindex.js
      return function (require, module, exports) {

/**
 * Expose `isUrl`.
 */

module.exports = isUrl;

/**
 * RegExps.
 * A URL must match #1 and then at least one of #2/#3.
 * Use two levels of REs to avoid REDOS.
 */

var protocolAndDomainRE = /^(?:\w+:)?\/\/(\S+)$/;

var localhostDomainRE = /^localhost[\:?\d]*(?:[^\:?\d]\S*)?$/
var nonLocalhostDomainRE = /^[^\s\.]+\.\S{2,}$/;

/**
 * Loosely validate a URL `string`.
 *
 * @param {String} string
 * @return {Boolean}
 */

function isUrl(string){
  if (typeof string !== 'string') {
    return false;
  }

  var match = string.match(protocolAndDomainRE);
  if (!match) {
    return false;
  }

  var everythingAfterProtocol = match[1];
  if (!everythingAfterProtocol) {
    return false;
  }

  if (localhostDomainRE.test(everythingAfterProtocol) ||
      nonLocalhostDomainRE.test(everythingAfterProtocol)) {
    return true;
  }

  return false;
}

      };
    };
  }
  }
}, {package:"@open-rpc/schema-utils-js>is-url",file:"node_modules\\is-url\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\iso-url\\index.js", {"./src/relative":"D:\\code\\v\\metamask-extension\\node_modules\\iso-url\\src\\relative.js","./src/url":"D:\\code\\v\\metamask-extension\\node_modules\\iso-url\\src\\url-browser.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Ciso-url%5Cindex.js
      return function (require, module, exports) {
'use strict';

const {
    URLWithLegacySupport,
    format,
    URLSearchParams,
    defaultBase
} = require('./src/url');
const relative = require('./src/relative');

module.exports = {
    URL: URLWithLegacySupport,
    URLSearchParams,
    format,
    relative,
    defaultBase
};

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>borc>iso-url",file:"node_modules\\iso-url\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\iso-url\\src\\relative.js", {"./url":"D:\\code\\v\\metamask-extension\\node_modules\\iso-url\\src\\url-browser.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Ciso-url%5Csrc%5Crelative.js
      return function (require, module, exports) {
'use strict';

const { URLWithLegacySupport, format } = require('./url');

module.exports = (url, location = {}, protocolMap = {}, defaultProtocol) => {
    let protocol = location.protocol ?
        location.protocol.replace(':', '') :
        'http';

    // Check protocol map
    protocol = (protocolMap[protocol] || defaultProtocol || protocol) + ':';
    let urlParsed;

    try {
        urlParsed = new URLWithLegacySupport(url);
    } catch (err) {
        urlParsed = {};
    }

    const base = Object.assign({}, location, {
        protocol: protocol || urlParsed.protocol,
        host: location.host || urlParsed.host
    });

    return new URLWithLegacySupport(url, format(base)).toString();
};

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>borc>iso-url",file:"node_modules\\iso-url\\src\\relative.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\iso-url\\src\\url-browser.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Ciso-url%5Csrc%5Curl-browser.js
      return function (require, module, exports) {
'use strict';

const defaultBase = self.location ?
    self.location.protocol + '//' + self.location.host :
    '';
const URL = self.URL;

class URLWithLegacySupport {
    constructor(url = '', base = defaultBase) {
        this.super = new URL(url, base);
        this.path = this.pathname + this.search;
        this.auth =
            this.username && this.password ?
                this.username + ':' + this.password :
                null;

        this.query =
            this.search && this.search.startsWith('?') ?
                this.search.slice(1) :
                null;
    }

    get hash() {
        return this.super.hash;
    }
    get host() {
        return this.super.host;
    }
    get hostname() {
        return this.super.hostname;
    }
    get href() {
        return this.super.href;
    }
    get origin() {
        return this.super.origin;
    }
    get password() {
        return this.super.password;
    }
    get pathname() {
        return this.super.pathname;
    }
    get port() {
        return this.super.port;
    }
    get protocol() {
        return this.super.protocol;
    }
    get search() {
        return this.super.search;
    }
    get searchParams() {
        return this.super.searchParams;
    }
    get username() {
        return this.super.username;
    }

    set hash(hash) {
        this.super.hash = hash;
    }
    set host(host) {
        this.super.host = host;
    }
    set hostname(hostname) {
        this.super.hostname = hostname;
    }
    set href(href) {
        this.super.href = href;
    }
    set origin(origin) {
        this.super.origin = origin;
    }
    set password(password) {
        this.super.password = password;
    }
    set pathname(pathname) {
        this.super.pathname = pathname;
    }
    set port(port) {
        this.super.port = port;
    }
    set protocol(protocol) {
        this.super.protocol = protocol;
    }
    set search(search) {
        this.super.search = search;
    }
    set searchParams(searchParams) {
        this.super.searchParams = searchParams;
    }
    set username(username) {
        this.super.username = username;
    }

    createObjectURL(o) {
        return this.super.createObjectURL(o);
    }
    revokeObjectURL(o) {
        this.super.revokeObjectURL(o);
    }
    toJSON() {
        return this.super.toJSON();
    }
    toString() {
        return this.super.toString();
    }
    format() {
        return this.toString();
    }
}

function format(obj) {
    if (typeof obj === 'string') {
        const url = new URL(obj);

        return url.toString();
    }

    if (!(obj instanceof URL)) {
        const userPass =
            obj.username && obj.password ?
                `${obj.username}:${obj.password}@` :
                '';
        const auth = obj.auth ? obj.auth + '@' : '';
        const port = obj.port ? ':' + obj.port : '';
        const protocol = obj.protocol ? obj.protocol + '//' : '';
        const host = obj.host || '';
        const hostname = obj.hostname || '';
        const search = obj.search || (obj.query ? '?' + obj.query : '');
        const hash = obj.hash || '';
        const pathname = obj.pathname || '';
        const path = obj.path || pathname + search;

        return `${protocol}${userPass || auth}${host ||
            hostname + port}${path}${hash}`;
    }
}

module.exports = {
    URLWithLegacySupport,
    URLSearchParams: self.URLSearchParams,
    defaultBase,
    format
};

      };
    };
  }
  }
}, {package:"eth-lattice-keyring>gridplus-sdk>borc>iso-url",file:"node_modules\\iso-url\\src\\url-browser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\isomorphic-fetch\\fetch-npm-browserify.js", {"whatwg-fetch":"D:\\code\\v\\metamask-extension\\node_modules\\whatwg-fetch\\dist\\fetch.umd.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cisomorphic-fetch%5Cfetch-npm-browserify.js
      return function (require, module, exports) {
// the whatwg-fetch polyfill installs the fetch() function
// on the global object (window or self)
//
// Return that as the export for use in Webpack, Browserify etc.
require('whatwg-fetch');
module.exports = self.fetch.bind(self);

      };
    };
  }
  }
}, {package:"@open-rpc/test-coverage>isomorphic-fetch",file:"node_modules\\isomorphic-fetch\\fetch-npm-browserify.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\join-component\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cjoin-component%5Cindex.js
      return function (require, module, exports) {

/**
 * Join `arr` with the trailing `str` defaulting to "and",
 * and `sep` string defaulting to ", ".
 *
 * @param {Array} arr
 * @param {String} str
 * @param {String} sep
 * @return {String}
 * @api public
 */

module.exports = function(arr, str, sep){
  str = str || 'and';
  sep = sep || ', ';

  if (arr.length < 2) return arr[0] || '';

  var oxford = str.slice(0, 2) === sep;

  if (!oxford) {
    str = ' ' + str;
  } else if (arr.length == 2) {
    str = str.slice(1);
  }

  return arr.slice(0, -1).join(sep) + str + ' ' + arr[arr.length - 1];
};

      };
    };
  }
  }
}, {package:"@segment/loosely-validate-event>join-component",file:"node_modules\\join-component\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\js-base64\\base64.js", {"buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cjs-base64%5Cbase64.js
      return function (require, module, exports) {
(function (Buffer){(function (){
//
// THIS FILE IS AUTOMATICALLY GENERATED! DO NOT EDIT BY HAND!
//
;
(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined'
        ? module.exports = factory()
        : typeof define === 'function' && define.amd
            ? define(factory) :
            // cf. https://github.com/dankogai/js-base64/issues/119
            (function () {
                // existing version for noConflict()
                var _Base64 = global.Base64;
                var gBase64 = factory();
                gBase64.noConflict = function () {
                    global.Base64 = _Base64;
                    return gBase64;
                };
                if (global.Meteor) { // Meteor.js
                    Base64 = gBase64;
                }
                global.Base64 = gBase64;
            })();
}((typeof self !== 'undefined' ? self
    : typeof window !== 'undefined' ? window
        : typeof global !== 'undefined' ? global
            : this), function () {
    'use strict';
    /**
     *  base64.ts
     *
     *  Licensed under the BSD 3-Clause License.
     *    http://opensource.org/licenses/BSD-3-Clause
     *
     *  References:
     *    http://en.wikipedia.org/wiki/Base64
     *
     * @author Dan Kogai (https://github.com/dankogai)
     */
    var version = '3.7.7';
    /**
     * @deprecated use lowercase `version`.
     */
    var VERSION = version;
    var _hasBuffer = typeof Buffer === 'function';
    var _TD = typeof TextDecoder === 'function' ? new TextDecoder() : undefined;
    var _TE = typeof TextEncoder === 'function' ? new TextEncoder() : undefined;
    var b64ch = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';
    var b64chs = Array.prototype.slice.call(b64ch);
    var b64tab = (function (a) {
        var tab = {};
        a.forEach(function (c, i) { return tab[c] = i; });
        return tab;
    })(b64chs);
    var b64re = /^(?:[A-Za-z\d+\/]{4})*?(?:[A-Za-z\d+\/]{2}(?:==)?|[A-Za-z\d+\/]{3}=?)?$/;
    var _fromCC = String.fromCharCode.bind(String);
    var _U8Afrom = typeof Uint8Array.from === 'function'
        ? Uint8Array.from.bind(Uint8Array)
        : function (it) { return new Uint8Array(Array.prototype.slice.call(it, 0)); };
    var _mkUriSafe = function (src) { return src
        .replace(/=/g, '').replace(/[+\/]/g, function (m0) { return m0 == '+' ? '-' : '_'; }); };
    var _tidyB64 = function (s) { return s.replace(/[^A-Za-z0-9\+\/]/g, ''); };
    /**
     * polyfill version of `btoa`
     */
    var btoaPolyfill = function (bin) {
        // console.log('polyfilled');
        var u32, c0, c1, c2, asc = '';
        var pad = bin.length % 3;
        for (var i = 0; i < bin.length;) {
            if ((c0 = bin.charCodeAt(i++)) > 255 ||
                (c1 = bin.charCodeAt(i++)) > 255 ||
                (c2 = bin.charCodeAt(i++)) > 255)
                throw new TypeError('invalid character found');
            u32 = (c0 << 16) | (c1 << 8) | c2;
            asc += b64chs[u32 >> 18 & 63]
                + b64chs[u32 >> 12 & 63]
                + b64chs[u32 >> 6 & 63]
                + b64chs[u32 & 63];
        }
        return pad ? asc.slice(0, pad - 3) + "===".substring(pad) : asc;
    };
    /**
     * does what `window.btoa` of web browsers do.
     * @param {String} bin binary string
     * @returns {string} Base64-encoded string
     */
    var _btoa = typeof btoa === 'function' ? function (bin) { return btoa(bin); }
        : _hasBuffer ? function (bin) { return Buffer.from(bin, 'binary').toString('base64'); }
            : btoaPolyfill;
    var _fromUint8Array = _hasBuffer
        ? function (u8a) { return Buffer.from(u8a).toString('base64'); }
        : function (u8a) {
            // cf. https://stackoverflow.com/questions/12710001/how-to-convert-uint8-array-to-base64-encoded-string/12713326#12713326
            var maxargs = 0x1000;
            var strs = [];
            for (var i = 0, l = u8a.length; i < l; i += maxargs) {
                strs.push(_fromCC.apply(null, u8a.subarray(i, i + maxargs)));
            }
            return _btoa(strs.join(''));
        };
    /**
     * converts a Uint8Array to a Base64 string.
     * @param {boolean} [urlsafe] URL-and-filename-safe a la RFC4648 §5
     * @returns {string} Base64 string
     */
    var fromUint8Array = function (u8a, urlsafe) {
        if (urlsafe === void 0) { urlsafe = false; }
        return urlsafe ? _mkUriSafe(_fromUint8Array(u8a)) : _fromUint8Array(u8a);
    };
    // This trick is found broken https://github.com/dankogai/js-base64/issues/130
    // const utob = (src: string) => unescape(encodeURIComponent(src));
    // reverting good old fationed regexp
    var cb_utob = function (c) {
        if (c.length < 2) {
            var cc = c.charCodeAt(0);
            return cc < 0x80 ? c
                : cc < 0x800 ? (_fromCC(0xc0 | (cc >>> 6))
                    + _fromCC(0x80 | (cc & 0x3f)))
                    : (_fromCC(0xe0 | ((cc >>> 12) & 0x0f))
                        + _fromCC(0x80 | ((cc >>> 6) & 0x3f))
                        + _fromCC(0x80 | (cc & 0x3f)));
        }
        else {
            var cc = 0x10000
                + (c.charCodeAt(0) - 0xD800) * 0x400
                + (c.charCodeAt(1) - 0xDC00);
            return (_fromCC(0xf0 | ((cc >>> 18) & 0x07))
                + _fromCC(0x80 | ((cc >>> 12) & 0x3f))
                + _fromCC(0x80 | ((cc >>> 6) & 0x3f))
                + _fromCC(0x80 | (cc & 0x3f)));
        }
    };
    var re_utob = /[\uD800-\uDBFF][\uDC00-\uDFFFF]|[^\x00-\x7F]/g;
    /**
     * @deprecated should have been internal use only.
     * @param {string} src UTF-8 string
     * @returns {string} UTF-16 string
     */
    var utob = function (u) { return u.replace(re_utob, cb_utob); };
    //
    var _encode = _hasBuffer
        ? function (s) { return Buffer.from(s, 'utf8').toString('base64'); }
        : _TE
            ? function (s) { return _fromUint8Array(_TE.encode(s)); }
            : function (s) { return _btoa(utob(s)); };
    /**
     * converts a UTF-8-encoded string to a Base64 string.
     * @param {boolean} [urlsafe] if `true` make the result URL-safe
     * @returns {string} Base64 string
     */
    var encode = function (src, urlsafe) {
        if (urlsafe === void 0) { urlsafe = false; }
        return urlsafe
            ? _mkUriSafe(_encode(src))
            : _encode(src);
    };
    /**
     * converts a UTF-8-encoded string to URL-safe Base64 RFC4648 §5.
     * @returns {string} Base64 string
     */
    var encodeURI = function (src) { return encode(src, true); };
    // This trick is found broken https://github.com/dankogai/js-base64/issues/130
    // const btou = (src: string) => decodeURIComponent(escape(src));
    // reverting good old fationed regexp
    var re_btou = /[\xC0-\xDF][\x80-\xBF]|[\xE0-\xEF][\x80-\xBF]{2}|[\xF0-\xF7][\x80-\xBF]{3}/g;
    var cb_btou = function (cccc) {
        switch (cccc.length) {
            case 4:
                var cp = ((0x07 & cccc.charCodeAt(0)) << 18)
                    | ((0x3f & cccc.charCodeAt(1)) << 12)
                    | ((0x3f & cccc.charCodeAt(2)) << 6)
                    | (0x3f & cccc.charCodeAt(3)), offset = cp - 0x10000;
                return (_fromCC((offset >>> 10) + 0xD800)
                    + _fromCC((offset & 0x3FF) + 0xDC00));
            case 3:
                return _fromCC(((0x0f & cccc.charCodeAt(0)) << 12)
                    | ((0x3f & cccc.charCodeAt(1)) << 6)
                    | (0x3f & cccc.charCodeAt(2)));
            default:
                return _fromCC(((0x1f & cccc.charCodeAt(0)) << 6)
                    | (0x3f & cccc.charCodeAt(1)));
        }
    };
    /**
     * @deprecated should have been internal use only.
     * @param {string} src UTF-16 string
     * @returns {string} UTF-8 string
     */
    var btou = function (b) { return b.replace(re_btou, cb_btou); };
    /**
     * polyfill version of `atob`
     */
    var atobPolyfill = function (asc) {
        // console.log('polyfilled');
        asc = asc.replace(/\s+/g, '');
        if (!b64re.test(asc))
            throw new TypeError('malformed base64.');
        asc += '=='.slice(2 - (asc.length & 3));
        var u24, bin = '', r1, r2;
        for (var i = 0; i < asc.length;) {
            u24 = b64tab[asc.charAt(i++)] << 18
                | b64tab[asc.charAt(i++)] << 12
                | (r1 = b64tab[asc.charAt(i++)]) << 6
                | (r2 = b64tab[asc.charAt(i++)]);
            bin += r1 === 64 ? _fromCC(u24 >> 16 & 255)
                : r2 === 64 ? _fromCC(u24 >> 16 & 255, u24 >> 8 & 255)
                    : _fromCC(u24 >> 16 & 255, u24 >> 8 & 255, u24 & 255);
        }
        return bin;
    };
    /**
     * does what `window.atob` of web browsers do.
     * @param {String} asc Base64-encoded string
     * @returns {string} binary string
     */
    var _atob = typeof atob === 'function' ? function (asc) { return atob(_tidyB64(asc)); }
        : _hasBuffer ? function (asc) { return Buffer.from(asc, 'base64').toString('binary'); }
            : atobPolyfill;
    //
    var _toUint8Array = _hasBuffer
        ? function (a) { return _U8Afrom(Buffer.from(a, 'base64')); }
        : function (a) { return _U8Afrom(_atob(a).split('').map(function (c) { return c.charCodeAt(0); })); };
    /**
     * converts a Base64 string to a Uint8Array.
     */
    var toUint8Array = function (a) { return _toUint8Array(_unURI(a)); };
    //
    var _decode = _hasBuffer
        ? function (a) { return Buffer.from(a, 'base64').toString('utf8'); }
        : _TD
            ? function (a) { return _TD.decode(_toUint8Array(a)); }
            : function (a) { return btou(_atob(a)); };
    var _unURI = function (a) { return _tidyB64(a.replace(/[-_]/g, function (m0) { return m0 == '-' ? '+' : '/'; })); };
    /**
     * converts a Base64 string to a UTF-8 string.
     * @param {String} src Base64 string.  Both normal and URL-safe are supported
     * @returns {string} UTF-8 string
     */
    var decode = function (src) { return _decode(_unURI(src)); };
    /**
     * check if a value is a valid Base64 string
     * @param {String} src a value to check
      */
    var isValid = function (src) {
        if (typeof src !== 'string')
            return false;
        var s = src.replace(/\s+/g, '').replace(/={0,2}$/, '');
        return !/[^\s0-9a-zA-Z\+/]/.test(s) || !/[^\s0-9a-zA-Z\-_]/.test(s);
    };
    //
    var _noEnum = function (v) {
        return {
            value: v, enumerable: false, writable: true, configurable: true
        };
    };
    /**
     * extend String.prototype with relevant methods
     */
    var extendString = function () {
        var _add = function (name, body) { return Object.defineProperty(String.prototype, name, _noEnum(body)); };
        _add('fromBase64', function () { return decode(this); });
        _add('toBase64', function (urlsafe) { return encode(this, urlsafe); });
        _add('toBase64URI', function () { return encode(this, true); });
        _add('toBase64URL', function () { return encode(this, true); });
        _add('toUint8Array', function () { return toUint8Array(this); });
    };
    /**
     * extend Uint8Array.prototype with relevant methods
     */
    var extendUint8Array = function () {
        var _add = function (name, body) { return Object.defineProperty(Uint8Array.prototype, name, _noEnum(body)); };
        _add('toBase64', function (urlsafe) { return fromUint8Array(this, urlsafe); });
        _add('toBase64URI', function () { return fromUint8Array(this, true); });
        _add('toBase64URL', function () { return fromUint8Array(this, true); });
    };
    /**
     * extend Builtin prototypes with relevant methods
     */
    var extendBuiltins = function () {
        extendString();
        extendUint8Array();
    };
    var gBase64 = {
        version: version,
        VERSION: VERSION,
        atob: _atob,
        atobPolyfill: atobPolyfill,
        btoa: _btoa,
        btoaPolyfill: btoaPolyfill,
        fromBase64: decode,
        toBase64: encode,
        encode: encode,
        encodeURI: encodeURI,
        encodeURL: encodeURI,
        utob: utob,
        btou: btou,
        decode: decode,
        isValid: isValid,
        fromUint8Array: fromUint8Array,
        toUint8Array: toUint8Array,
        extendString: extendString,
        extendUint8Array: extendUint8Array,
        extendBuiltins: extendBuiltins
    };
    //
    // export Base64 to the namespace
    //
    // ES5 is yet to have Object.assign() that may make transpilers unhappy.
    // gBase64.Base64 = Object.assign({}, gBase64);
    gBase64.Base64 = {};
    Object.keys(gBase64).forEach(function (k) { return gBase64.Base64[k] = gBase64[k]; });
    return gBase64;
}));

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>js-base64",file:"node_modules\\js-base64\\base64.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\lodash\\_baseInRange.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Clodash%5C_baseInRange.js
      return function (require, module, exports) {
/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeMax = Math.max,
    nativeMin = Math.min;

/**
 * The base implementation of `_.inRange` which doesn't coerce arguments.
 *
 * @private
 * @param {number} number The number to check.
 * @param {number} start The start of the range.
 * @param {number} end The end of the range.
 * @returns {boolean} Returns `true` if `number` is in the range, else `false`.
 */
function baseInRange(number, start, end) {
  return number >= nativeMin(start, end) && number < nativeMax(start, end);
}

module.exports = baseInRange;

      };
    };
  }
  }
}, {package:"lodash",file:"node_modules\\lodash\\_baseInRange.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\lodash\\_baseTrim.js", {"./_trimmedEndIndex":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\_trimmedEndIndex.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Clodash%5C_baseTrim.js
      return function (require, module, exports) {
var trimmedEndIndex = require('./_trimmedEndIndex');

/** Used to match leading whitespace. */
var reTrimStart = /^\s+/;

/**
 * The base implementation of `_.trim`.
 *
 * @private
 * @param {string} string The string to trim.
 * @returns {string} Returns the trimmed string.
 */
function baseTrim(string) {
  return string
    ? string.slice(0, trimmedEndIndex(string) + 1).replace(reTrimStart, '')
    : string;
}

module.exports = baseTrim;

      };
    };
  }
  }
}, {package:"lodash",file:"node_modules\\lodash\\_baseTrim.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\lodash\\_trimmedEndIndex.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Clodash%5C_trimmedEndIndex.js
      return function (require, module, exports) {
/** Used to match a single whitespace character. */
var reWhitespace = /\s/;

/**
 * Used by `_.trim` and `_.trimEnd` to get the index of the last non-whitespace
 * character of `string`.
 *
 * @private
 * @param {string} string The string to inspect.
 * @returns {number} Returns the index of the last non-whitespace character.
 */
function trimmedEndIndex(string) {
  var index = string.length;

  while (index-- && reWhitespace.test(string.charAt(index))) {}
  return index;
}

module.exports = trimmedEndIndex;

      };
    };
  }
  }
}, {package:"lodash",file:"node_modules\\lodash\\_trimmedEndIndex.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\lodash\\inRange.js", {"./_baseInRange":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\_baseInRange.js","./toFinite":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\toFinite.js","./toNumber":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\toNumber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Clodash%5CinRange.js
      return function (require, module, exports) {
var baseInRange = require('./_baseInRange'),
    toFinite = require('./toFinite'),
    toNumber = require('./toNumber');

/**
 * Checks if `n` is between `start` and up to, but not including, `end`. If
 * `end` is not specified, it's set to `start` with `start` then set to `0`.
 * If `start` is greater than `end` the params are swapped to support
 * negative ranges.
 *
 * @static
 * @memberOf _
 * @since 3.3.0
 * @category Number
 * @param {number} number The number to check.
 * @param {number} [start=0] The start of the range.
 * @param {number} end The end of the range.
 * @returns {boolean} Returns `true` if `number` is in the range, else `false`.
 * @see _.range, _.rangeRight
 * @example
 *
 * _.inRange(3, 2, 4);
 * // => true
 *
 * _.inRange(4, 8);
 * // => true
 *
 * _.inRange(4, 2);
 * // => false
 *
 * _.inRange(2, 2);
 * // => false
 *
 * _.inRange(1.2, 2);
 * // => true
 *
 * _.inRange(5.2, 4);
 * // => false
 *
 * _.inRange(-3, -2, -6);
 * // => true
 */
function inRange(number, start, end) {
  start = toFinite(start);
  if (end === undefined) {
    end = start;
    start = 0;
  } else {
    end = toFinite(end);
  }
  number = toNumber(number);
  return baseInRange(number, start, end);
}

module.exports = inRange;

      };
    };
  }
  }
}, {package:"lodash",file:"node_modules\\lodash\\inRange.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\lodash\\isEmpty.js", {"./_baseKeys":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\_baseKeys.js","./_getTag":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\_getTag.js","./_isPrototype":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\_isPrototype.js","./isArguments":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\isArguments.js","./isArray":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\isArray.js","./isArrayLike":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\isArrayLike.js","./isBuffer":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\isBuffer.js","./isTypedArray":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\isTypedArray.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Clodash%5CisEmpty.js
      return function (require, module, exports) {
var baseKeys = require('./_baseKeys'),
    getTag = require('./_getTag'),
    isArguments = require('./isArguments'),
    isArray = require('./isArray'),
    isArrayLike = require('./isArrayLike'),
    isBuffer = require('./isBuffer'),
    isPrototype = require('./_isPrototype'),
    isTypedArray = require('./isTypedArray');

/** `Object#toString` result references. */
var mapTag = '[object Map]',
    setTag = '[object Set]';

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Checks if `value` is an empty object, collection, map, or set.
 *
 * Objects are considered empty if they have no own enumerable string keyed
 * properties.
 *
 * Array-like values such as `arguments` objects, arrays, buffers, strings, or
 * jQuery-like collections are considered empty if they have a `length` of `0`.
 * Similarly, maps and sets are considered empty if they have a `size` of `0`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is empty, else `false`.
 * @example
 *
 * _.isEmpty(null);
 * // => true
 *
 * _.isEmpty(true);
 * // => true
 *
 * _.isEmpty(1);
 * // => true
 *
 * _.isEmpty([1, 2, 3]);
 * // => false
 *
 * _.isEmpty({ 'a': 1 });
 * // => false
 */
function isEmpty(value) {
  if (value == null) {
    return true;
  }
  if (isArrayLike(value) &&
      (isArray(value) || typeof value == 'string' || typeof value.splice == 'function' ||
        isBuffer(value) || isTypedArray(value) || isArguments(value))) {
    return !value.length;
  }
  var tag = getTag(value);
  if (tag == mapTag || tag == setTag) {
    return !value.size;
  }
  if (isPrototype(value)) {
    return !baseKeys(value).length;
  }
  for (var key in value) {
    if (hasOwnProperty.call(value, key)) {
      return false;
    }
  }
  return true;
}

module.exports = isEmpty;

      };
    };
  }
  }
}, {package:"lodash",file:"node_modules\\lodash\\isEmpty.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\lodash\\isInteger.js", {"./toInteger":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\toInteger.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Clodash%5CisInteger.js
      return function (require, module, exports) {
var toInteger = require('./toInteger');

/**
 * Checks if `value` is an integer.
 *
 * **Note:** This method is based on
 * [`Number.isInteger`](https://mdn.io/Number/isInteger).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an integer, else `false`.
 * @example
 *
 * _.isInteger(3);
 * // => true
 *
 * _.isInteger(Number.MIN_VALUE);
 * // => false
 *
 * _.isInteger(Infinity);
 * // => false
 *
 * _.isInteger('3');
 * // => false
 */
function isInteger(value) {
  return typeof value == 'number' && value == toInteger(value);
}

module.exports = isInteger;

      };
    };
  }
  }
}, {package:"lodash",file:"node_modules\\lodash\\isInteger.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\lodash\\toFinite.js", {"./toNumber":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\toNumber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Clodash%5CtoFinite.js
      return function (require, module, exports) {
var toNumber = require('./toNumber');

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0,
    MAX_INTEGER = 1.7976931348623157e+308;

/**
 * Converts `value` to a finite number.
 *
 * @static
 * @memberOf _
 * @since 4.12.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {number} Returns the converted number.
 * @example
 *
 * _.toFinite(3.2);
 * // => 3.2
 *
 * _.toFinite(Number.MIN_VALUE);
 * // => 5e-324
 *
 * _.toFinite(Infinity);
 * // => 1.7976931348623157e+308
 *
 * _.toFinite('3.2');
 * // => 3.2
 */
function toFinite(value) {
  if (!value) {
    return value === 0 ? value : 0;
  }
  value = toNumber(value);
  if (value === INFINITY || value === -INFINITY) {
    var sign = (value < 0 ? -1 : 1);
    return sign * MAX_INTEGER;
  }
  return value === value ? value : 0;
}

module.exports = toFinite;

      };
    };
  }
  }
}, {package:"lodash",file:"node_modules\\lodash\\toFinite.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\lodash\\toInteger.js", {"./toFinite":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\toFinite.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Clodash%5CtoInteger.js
      return function (require, module, exports) {
var toFinite = require('./toFinite');

/**
 * Converts `value` to an integer.
 *
 * **Note:** This method is loosely based on
 * [`ToInteger`](http://www.ecma-international.org/ecma-262/7.0/#sec-tointeger).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {number} Returns the converted integer.
 * @example
 *
 * _.toInteger(3.2);
 * // => 3
 *
 * _.toInteger(Number.MIN_VALUE);
 * // => 0
 *
 * _.toInteger(Infinity);
 * // => 1.7976931348623157e+308
 *
 * _.toInteger('3.2');
 * // => 3
 */
function toInteger(value) {
  var result = toFinite(value),
      remainder = result % 1;

  return result === result ? (remainder ? result - remainder : result) : 0;
}

module.exports = toInteger;

      };
    };
  }
  }
}, {package:"lodash",file:"node_modules\\lodash\\toInteger.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\lodash\\toNumber.js", {"./_baseTrim":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\_baseTrim.js","./isObject":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\isObject.js","./isSymbol":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\isSymbol.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Clodash%5CtoNumber.js
      return function (require, module, exports) {
var baseTrim = require('./_baseTrim'),
    isObject = require('./isObject'),
    isSymbol = require('./isSymbol');

/** Used as references for various `Number` constants. */
var NAN = 0 / 0;

/** Used to detect bad signed hexadecimal string values. */
var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;

/** Used to detect binary string values. */
var reIsBinary = /^0b[01]+$/i;

/** Used to detect octal string values. */
var reIsOctal = /^0o[0-7]+$/i;

/** Built-in method references without a dependency on `root`. */
var freeParseInt = parseInt;

/**
 * Converts `value` to a number.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to process.
 * @returns {number} Returns the number.
 * @example
 *
 * _.toNumber(3.2);
 * // => 3.2
 *
 * _.toNumber(Number.MIN_VALUE);
 * // => 5e-324
 *
 * _.toNumber(Infinity);
 * // => Infinity
 *
 * _.toNumber('3.2');
 * // => 3.2
 */
function toNumber(value) {
  if (typeof value == 'number') {
    return value;
  }
  if (isSymbol(value)) {
    return NAN;
  }
  if (isObject(value)) {
    var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
    value = isObject(other) ? (other + '') : other;
  }
  if (typeof value != 'string') {
    return value === 0 ? value : +value;
  }
  value = baseTrim(value);
  var isBinary = reIsBinary.test(value);
  return (isBinary || reIsOctal.test(value))
    ? freeParseInt(value.slice(2), isBinary ? 2 : 8)
    : (reIsBadHex.test(value) ? NAN : +value);
}

module.exports = toNumber;

      };
    };
  }
  }
}, {package:"lodash",file:"node_modules\\lodash\\toNumber.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multibase\\src\\base.js", {"./util":"D:\\code\\v\\metamask-extension\\node_modules\\multibase\\src\\util.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultibase%5Csrc%5Cbase.js
      return function (require, module, exports) {
'use strict'

const { encodeText } = require('./util')

/** @typedef {__import__('./types').CodecFactory} CodecFactory */
/** @typedef {__import__("./types").BaseName} BaseName */
/** @typedef {__import__("./types").BaseCode} BaseCode */

/**
 * Class to encode/decode in the supported Bases
 *
 */
class Base {
  /**
   * @param {BaseName} name
   * @param {BaseCode} code
   * @param {CodecFactory} factory
   * @param {string} alphabet
   */
  constructor (name, code, factory, alphabet) {
    this.name = name
    this.code = code
    this.codeBuf = encodeText(this.code)
    this.alphabet = alphabet
    this.codec = factory(alphabet)
  }

  /**
   * @param {Uint8Array} buf
   * @returns {string}
   */
  encode (buf) {
    return this.codec.encode(buf)
  }

  /**
   * @param {string} string
   * @returns {Uint8Array}
   */
  decode (string) {
    for (const char of string) {
      if (this.alphabet && this.alphabet.indexOf(char) < 0) {
        throw new Error(`invalid character '${char}' in '${string}'`)
      }
    }
    return this.codec.decode(string)
  }
}

module.exports = Base

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>cids>multibase",file:"node_modules\\multibase\\src\\base.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multibase\\src\\constants.js", {"./base.js":"D:\\code\\v\\metamask-extension\\node_modules\\multibase\\src\\base.js","./rfc4648":"D:\\code\\v\\metamask-extension\\node_modules\\multibase\\src\\rfc4648.js","./util":"D:\\code\\v\\metamask-extension\\node_modules\\multibase\\src\\util.js","@multiformats/base-x":"D:\\code\\v\\metamask-extension\\node_modules\\@multiformats\\base-x\\src\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultibase%5Csrc%5Cconstants.js
      return function (require, module, exports) {
'use strict'

const baseX = require('@multiformats/base-x')
const Base = require('./base.js')
const { rfc4648 } = require('./rfc4648')
const { decodeText, encodeText } = require('./util')

/** @typedef {__import__('./types').CodecFactory} CodecFactory */
/** @typedef {__import__('./types').Codec} Codec */
/** @typedef {__import__('./types').BaseName} BaseName */
/** @typedef {__import__('./types').BaseCode} BaseCode */

/** @type {CodecFactory} */
const identity = () => {
  return {
    encode: decodeText,
    decode: encodeText
  }
}

/**
 *
 * name, code, implementation, alphabet
 *
 * @type {Array<[BaseName, BaseCode, CodecFactory, string]>}
 */
const constants = [
  ['identity', '\x00', identity, ''],
  ['base2', '0', rfc4648(1), '01'],
  ['base8', '7', rfc4648(3), '01234567'],
  ['base10', '9', baseX, '0123456789'],
  ['base16', 'f', rfc4648(4), '0123456789abcdef'],
  ['base16upper', 'F', rfc4648(4), '0123456789ABCDEF'],
  ['base32hex', 'v', rfc4648(5), '0123456789abcdefghijklmnopqrstuv'],
  ['base32hexupper', 'V', rfc4648(5), '0123456789ABCDEFGHIJKLMNOPQRSTUV'],
  ['base32hexpad', 't', rfc4648(5), '0123456789abcdefghijklmnopqrstuv='],
  ['base32hexpadupper', 'T', rfc4648(5), '0123456789ABCDEFGHIJKLMNOPQRSTUV='],
  ['base32', 'b', rfc4648(5), 'abcdefghijklmnopqrstuvwxyz234567'],
  ['base32upper', 'B', rfc4648(5), 'ABCDEFGHIJKLMNOPQRSTUVWXYZ234567'],
  ['base32pad', 'c', rfc4648(5), 'abcdefghijklmnopqrstuvwxyz234567='],
  ['base32padupper', 'C', rfc4648(5), 'ABCDEFGHIJKLMNOPQRSTUVWXYZ234567='],
  ['base32z', 'h', rfc4648(5), 'ybndrfg8ejkmcpqxot1uwisza345h769'],
  ['base36', 'k', baseX, '0123456789abcdefghijklmnopqrstuvwxyz'],
  ['base36upper', 'K', baseX, '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'],
  ['base58btc', 'z', baseX, '123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz'],
  ['base58flickr', 'Z', baseX, '123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ'],
  ['base64', 'm', rfc4648(6), 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'],
  ['base64pad', 'M', rfc4648(6), 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/='],
  ['base64url', 'u', rfc4648(6), 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_'],
  ['base64urlpad', 'U', rfc4648(6), 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_=']
]

/** @type {Record<BaseName,Base>} */
const names = constants.reduce((prev, tupple) => {
  prev[tupple[0]] = new Base(tupple[0], tupple[1], tupple[2], tupple[3])
  return prev
}, /** @type {Record<BaseName,Base>} */({}))

/** @type {Record<BaseCode,Base>} */
const codes = constants.reduce((prev, tupple) => {
  prev[tupple[1]] = names[tupple[0]]
  return prev
}, /** @type {Record<BaseCode,Base>} */({}))

module.exports = {
  names,
  codes
}

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>cids>multibase",file:"node_modules\\multibase\\src\\constants.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multibase\\src\\index.js", {"./constants":"D:\\code\\v\\metamask-extension\\node_modules\\multibase\\src\\constants.js","./util":"D:\\code\\v\\metamask-extension\\node_modules\\multibase\\src\\util.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultibase%5Csrc%5Cindex.js
      return function (require, module, exports) {
/**
 * Implementation of the [multibase](https://github.com/multiformats/multibase) specification.
 *
 */
'use strict'

const constants = require('./constants')
const { encodeText, decodeText, concat } = require('./util')

/** @typedef {__import__('./base')} Base */
/** @typedef {__import__("./types").BaseNameOrCode} BaseNameOrCode */
/** @typedef {__import__("./types").BaseCode} BaseCode */
/** @typedef {__import__("./types").BaseName} BaseName */

/**
 * Create a new Uint8Array with the multibase varint+code.
 *
 * @param {BaseNameOrCode} nameOrCode - The multibase name or code number.
 * @param {Uint8Array} buf - The data to be prefixed with multibase.
 * @returns {Uint8Array}
 * @throws {Error} Will throw if the encoding is not supported
 */
function multibase (nameOrCode, buf) {
  if (!buf) {
    throw new Error('requires an encoded Uint8Array')
  }
  const { name, codeBuf } = encoding(nameOrCode)
  validEncode(name, buf)

  return concat([codeBuf, buf], codeBuf.length + buf.length)
}

/**
 * Encode data with the specified base and add the multibase prefix.
 *
 * @param {BaseNameOrCode} nameOrCode - The multibase name or code number.
 * @param {Uint8Array} buf - The data to be encoded.
 * @returns {Uint8Array}
 * @throws {Error} Will throw if the encoding is not supported
 *
 */
function encode (nameOrCode, buf) {
  const enc = encoding(nameOrCode)
  const data = encodeText(enc.encode(buf))

  return concat([enc.codeBuf, data], enc.codeBuf.length + data.length)
}

/**
 * Takes a Uint8Array or string encoded with multibase header, decodes it and
 * returns the decoded buffer
 *
 * @param {Uint8Array|string} data
 * @returns {Uint8Array}
 * @throws {Error} Will throw if the encoding is not supported
 *
 */
function decode (data) {
  if (data instanceof Uint8Array) {
    data = decodeText(data)
  }
  const prefix = data[0]

  // Make all encodings case-insensitive except the ones that include upper and lower chars in the alphabet
  if (['f', 'F', 'v', 'V', 't', 'T', 'b', 'B', 'c', 'C', 'h', 'k', 'K'].includes(prefix)) {
    data = data.toLowerCase()
  }
  const enc = encoding(/** @type {BaseCode} */(data[0]))
  return enc.decode(data.substring(1))
}

/**
 * Is the given data multibase encoded?
 *
 * @param {Uint8Array|string} data
 */
function isEncoded (data) {
  if (data instanceof Uint8Array) {
    data = decodeText(data)
  }

  // Ensure bufOrString is a string
  if (Object.prototype.toString.call(data) !== '[object String]') {
    return false
  }

  try {
    const enc = encoding(/** @type {BaseCode} */(data[0]))
    return enc.name
  } catch (err) {
    return false
  }
}

/**
 * Validate encoded data
 *
 * @param {BaseNameOrCode} name
 * @param {Uint8Array} buf
 * @returns {void}
 * @throws {Error} Will throw if the encoding is not supported
 */
function validEncode (name, buf) {
  const enc = encoding(name)
  enc.decode(decodeText(buf))
}

/**
 * Get the encoding by name or code
 *
 * @param {BaseNameOrCode} nameOrCode
 * @returns {Base}
 * @throws {Error} Will throw if the encoding is not supported
 */
function encoding (nameOrCode) {
  if (Object.prototype.hasOwnProperty.call(constants.names, /** @type {BaseName} */(nameOrCode))) {
    return constants.names[/** @type {BaseName} */(nameOrCode)]
  } else if (Object.prototype.hasOwnProperty.call(constants.codes, /** @type {BaseCode} */(nameOrCode))) {
    return constants.codes[/** @type {BaseCode} */(nameOrCode)]
  } else {
    throw new Error(`Unsupported encoding: ${nameOrCode}`)
  }
}

/**
 * Get encoding from data
 *
 * @param {string|Uint8Array} data
 * @returns {Base}
 * @throws {Error} Will throw if the encoding is not supported
 */
function encodingFromData (data) {
  if (data instanceof Uint8Array) {
    data = decodeText(data)
  }

  return encoding(/** @type {BaseCode} */(data[0]))
}

exports = module.exports = multibase
exports.encode = encode
exports.decode = decode
exports.isEncoded = isEncoded
exports.encoding = encoding
exports.encodingFromData = encodingFromData
const names = Object.freeze(constants.names)
const codes = Object.freeze(constants.codes)
exports.names = names
exports.codes = codes

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>cids>multibase",file:"node_modules\\multibase\\src\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multibase\\src\\rfc4648.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultibase%5Csrc%5Crfc4648.js
      return function (require, module, exports) {
'use strict'

/** @typedef {__import__('./types').CodecFactory} CodecFactory */

/**
 * @param {string} string
 * @param {string} alphabet
 * @param {number} bitsPerChar
 * @returns {Uint8Array}
 */
const decode = (string, alphabet, bitsPerChar) => {
  // Build the character lookup table:
  /** @type {Record<string, number>} */
  const codes = {}
  for (let i = 0; i < alphabet.length; ++i) {
    codes[alphabet[i]] = i
  }

  // Count the padding bytes:
  let end = string.length
  while (string[end - 1] === '=') {
    --end
  }

  // Allocate the output:
  const out = new Uint8Array((end * bitsPerChar / 8) | 0)

  // Parse the data:
  let bits = 0 // Number of bits currently in the buffer
  let buffer = 0 // Bits waiting to be written out, MSB first
  let written = 0 // Next byte to write
  for (let i = 0; i < end; ++i) {
    // Read one character from the string:
    const value = codes[string[i]]
    if (value === undefined) {
      throw new SyntaxError('Invalid character ' + string[i])
    }

    // Append the bits to the buffer:
    buffer = (buffer << bitsPerChar) | value
    bits += bitsPerChar

    // Write out some bits if the buffer has a byte's worth:
    if (bits >= 8) {
      bits -= 8
      out[written++] = 0xff & (buffer >> bits)
    }
  }

  // Verify that we have received just enough bits:
  if (bits >= bitsPerChar || 0xff & (buffer << (8 - bits))) {
    throw new SyntaxError('Unexpected end of data')
  }

  return out
}

/**
 * @param {Uint8Array} data
 * @param {string} alphabet
 * @param {number} bitsPerChar
 * @returns {string}
 */
const encode = (data, alphabet, bitsPerChar) => {
  const pad = alphabet[alphabet.length - 1] === '='
  const mask = (1 << bitsPerChar) - 1
  let out = ''

  let bits = 0 // Number of bits currently in the buffer
  let buffer = 0 // Bits waiting to be written out, MSB first
  for (let i = 0; i < data.length; ++i) {
    // Slurp data into the buffer:
    buffer = (buffer << 8) | data[i]
    bits += 8

    // Write out as much as we can:
    while (bits > bitsPerChar) {
      bits -= bitsPerChar
      out += alphabet[mask & (buffer >> bits)]
    }
  }

  // Partial character:
  if (bits) {
    out += alphabet[mask & (buffer << (bitsPerChar - bits))]
  }

  // Add padding characters until we hit a byte boundary:
  if (pad) {
    while ((out.length * bitsPerChar) & 7) {
      out += '='
    }
  }

  return out
}

/**
 * RFC4648 Factory
 *
 * @param {number} bitsPerChar
 * @returns {CodecFactory}
 */
const rfc4648 = (bitsPerChar) => (alphabet) => {
  return {
    /**
     * @param {Uint8Array} input
     * @returns {string}
     */
    encode (input) {
      return encode(input, alphabet, bitsPerChar)
    },
    /**
     * @param {string} input
     * @returns {Uint8Array}
     */
    decode (input) {
      return decode(input, alphabet, bitsPerChar)
    }
  }
}

module.exports = { rfc4648 }

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>cids>multibase",file:"node_modules\\multibase\\src\\rfc4648.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multibase\\src\\util.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultibase%5Csrc%5Cutil.js
      return function (require, module, exports) {
'use strict'

const textDecoder = new TextDecoder()
/**
 * @param {ArrayBufferView|ArrayBuffer} bytes
 * @returns {string}
 */
const decodeText = (bytes) => textDecoder.decode(bytes)

const textEncoder = new TextEncoder()
/**
 * @param {string} text
 * @returns {Uint8Array}
 */
const encodeText = (text) => textEncoder.encode(text)

/**
 * Returns a new Uint8Array created by concatenating the passed Arrays
 *
 * @param {Array<ArrayLike<number>>} arrs
 * @param {number} length
 * @returns {Uint8Array}
 */
function concat (arrs, length) {
  const output = new Uint8Array(length)
  let offset = 0

  for (const arr of arrs) {
    output.set(arr, offset)
    offset += arr.length
  }

  return output
}

module.exports = { decodeText, encodeText, concat }

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>cids>multibase",file:"node_modules\\multibase\\src\\util.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\node_modules\\uint8arrays\\cjs\\src\\alloc.js", {"./util/as-uint8array.js":"D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\node_modules\\uint8arrays\\cjs\\src\\util\\as-uint8array.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmulticodec%5Cnode_modules%5Cuint8arrays%5Ccjs%5Csrc%5Calloc.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var asUint8array = require('./util/as-uint8array.js');

function alloc(size = 0) {
  if (globalThis.Buffer != null && globalThis.Buffer.alloc != null) {
    return asUint8array.asUint8Array(globalThis.Buffer.alloc(size));
  }
  return new Uint8Array(size);
}
function allocUnsafe(size = 0) {
  if (globalThis.Buffer != null && globalThis.Buffer.allocUnsafe != null) {
    return asUint8array.asUint8Array(globalThis.Buffer.allocUnsafe(size));
  }
  return new Uint8Array(size);
}

exports.alloc = alloc;
exports.allocUnsafe = allocUnsafe;

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec>uint8arrays",file:"node_modules\\multicodec\\node_modules\\uint8arrays\\cjs\\src\\alloc.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\node_modules\\uint8arrays\\cjs\\src\\concat.js", {"./alloc.js":"D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\node_modules\\uint8arrays\\cjs\\src\\alloc.js","./util/as-uint8array.js":"D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\node_modules\\uint8arrays\\cjs\\src\\util\\as-uint8array.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmulticodec%5Cnode_modules%5Cuint8arrays%5Ccjs%5Csrc%5Cconcat.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var alloc = require('./alloc.js');
var asUint8array = require('./util/as-uint8array.js');

function concat(arrays, length) {
  if (!length) {
    length = arrays.reduce((acc, curr) => acc + curr.length, 0);
  }
  const output = alloc.allocUnsafe(length);
  let offset = 0;
  for (const arr of arrays) {
    output.set(arr, offset);
    offset += arr.length;
  }
  return asUint8array.asUint8Array(output);
}

exports.concat = concat;

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec>uint8arrays",file:"node_modules\\multicodec\\node_modules\\uint8arrays\\cjs\\src\\concat.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\node_modules\\uint8arrays\\cjs\\src\\from-string.js", {"./util/as-uint8array.js":"D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\node_modules\\uint8arrays\\cjs\\src\\util\\as-uint8array.js","./util/bases.js":"D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\node_modules\\uint8arrays\\cjs\\src\\util\\bases.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmulticodec%5Cnode_modules%5Cuint8arrays%5Ccjs%5Csrc%5Cfrom-string.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var bases = require('./util/bases.js');
var asUint8array = require('./util/as-uint8array.js');

function fromString(string, encoding = 'utf8') {
  const base = bases[encoding];
  if (!base) {
    throw new Error(`Unsupported encoding "${ encoding }"`);
  }
  if ((encoding === 'utf8' || encoding === 'utf-8') && globalThis.Buffer != null && globalThis.Buffer.from != null) {
    return asUint8array.asUint8Array(globalThis.Buffer.from(string, 'utf-8'));
  }
  return base.decoder.decode(`${ base.prefix }${ string }`);
}

exports.fromString = fromString;

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec>uint8arrays",file:"node_modules\\multicodec\\node_modules\\uint8arrays\\cjs\\src\\from-string.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\node_modules\\uint8arrays\\cjs\\src\\to-string.js", {"./util/bases.js":"D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\node_modules\\uint8arrays\\cjs\\src\\util\\bases.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmulticodec%5Cnode_modules%5Cuint8arrays%5Ccjs%5Csrc%5Cto-string.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var bases = require('./util/bases.js');

function toString(array, encoding = 'utf8') {
  const base = bases[encoding];
  if (!base) {
    throw new Error(`Unsupported encoding "${ encoding }"`);
  }
  if ((encoding === 'utf8' || encoding === 'utf-8') && globalThis.Buffer != null && globalThis.Buffer.from != null) {
    return globalThis.Buffer.from(array.buffer, array.byteOffset, array.byteLength).toString('utf8');
  }
  return base.encoder.encode(array).substring(1);
}

exports.toString = toString;

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec>uint8arrays",file:"node_modules\\multicodec\\node_modules\\uint8arrays\\cjs\\src\\to-string.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\node_modules\\uint8arrays\\cjs\\src\\util\\as-uint8array.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmulticodec%5Cnode_modules%5Cuint8arrays%5Ccjs%5Csrc%5Cutil%5Cas-uint8array.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function asUint8Array(buf) {
  if (globalThis.Buffer != null) {
    return new Uint8Array(buf.buffer, buf.byteOffset, buf.byteLength);
  }
  return buf;
}

exports.asUint8Array = asUint8Array;

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec>uint8arrays",file:"node_modules\\multicodec\\node_modules\\uint8arrays\\cjs\\src\\util\\as-uint8array.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\node_modules\\uint8arrays\\cjs\\src\\util\\bases.js", {"../alloc.js":"D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\node_modules\\uint8arrays\\cjs\\src\\alloc.js","multiformats/basics":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\basics.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmulticodec%5Cnode_modules%5Cuint8arrays%5Ccjs%5Csrc%5Cutil%5Cbases.js
      return function (require, module, exports) {
'use strict';

var basics = require('multiformats/basics');
var alloc = require('../alloc.js');

function createCodec(name, prefix, encode, decode) {
  return {
    name,
    prefix,
    encoder: {
      name,
      prefix,
      encode
    },
    decoder: { decode }
  };
}
const string = createCodec('utf8', 'u', buf => {
  const decoder = new TextDecoder('utf8');
  return 'u' + decoder.decode(buf);
}, str => {
  const encoder = new TextEncoder();
  return encoder.encode(str.substring(1));
});
const ascii = createCodec('ascii', 'a', buf => {
  let string = 'a';
  for (let i = 0; i < buf.length; i++) {
    string += String.fromCharCode(buf[i]);
  }
  return string;
}, str => {
  str = str.substring(1);
  const buf = alloc.allocUnsafe(str.length);
  for (let i = 0; i < str.length; i++) {
    buf[i] = str.charCodeAt(i);
  }
  return buf;
});
const BASES = {
  utf8: string,
  'utf-8': string,
  hex: basics.bases.base16,
  latin1: ascii,
  ascii: ascii,
  binary: ascii,
  ...basics.bases
};

module.exports = BASES;

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec>uint8arrays",file:"node_modules\\multicodec\\node_modules\\uint8arrays\\cjs\\src\\util\\bases.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\src\\generated-table.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmulticodec%5Csrc%5Cgenerated-table.js
      return function (require, module, exports) {
// DO NOT CHANGE THIS FILE. IT IS GENERATED BY tools/update-table.js
/* eslint quote-props: off */
'use strict'

/**
 * @type {__import__('./generated-types').NameCodeMap}
 */
const baseTable = Object.freeze({
  'identity': 0x00,
  'cidv1': 0x01,
  'cidv2': 0x02,
  'cidv3': 0x03,
  'ip4': 0x04,
  'tcp': 0x06,
  'sha1': 0x11,
  'sha2-256': 0x12,
  'sha2-512': 0x13,
  'sha3-512': 0x14,
  'sha3-384': 0x15,
  'sha3-256': 0x16,
  'sha3-224': 0x17,
  'shake-128': 0x18,
  'shake-256': 0x19,
  'keccak-224': 0x1a,
  'keccak-256': 0x1b,
  'keccak-384': 0x1c,
  'keccak-512': 0x1d,
  'blake3': 0x1e,
  'dccp': 0x21,
  'murmur3-128': 0x22,
  'murmur3-32': 0x23,
  'ip6': 0x29,
  'ip6zone': 0x2a,
  'path': 0x2f,
  'multicodec': 0x30,
  'multihash': 0x31,
  'multiaddr': 0x32,
  'multibase': 0x33,
  'dns': 0x35,
  'dns4': 0x36,
  'dns6': 0x37,
  'dnsaddr': 0x38,
  'protobuf': 0x50,
  'cbor': 0x51,
  'raw': 0x55,
  'dbl-sha2-256': 0x56,
  'rlp': 0x60,
  'bencode': 0x63,
  'dag-pb': 0x70,
  'dag-cbor': 0x71,
  'libp2p-key': 0x72,
  'git-raw': 0x78,
  'torrent-info': 0x7b,
  'torrent-file': 0x7c,
  'leofcoin-block': 0x81,
  'leofcoin-tx': 0x82,
  'leofcoin-pr': 0x83,
  'sctp': 0x84,
  'dag-jose': 0x85,
  'dag-cose': 0x86,
  'eth-block': 0x90,
  'eth-block-list': 0x91,
  'eth-tx-trie': 0x92,
  'eth-tx': 0x93,
  'eth-tx-receipt-trie': 0x94,
  'eth-tx-receipt': 0x95,
  'eth-state-trie': 0x96,
  'eth-account-snapshot': 0x97,
  'eth-storage-trie': 0x98,
  'eth-receipt-log-trie': 0x99,
  'eth-reciept-log': 0x9a,
  'bitcoin-block': 0xb0,
  'bitcoin-tx': 0xb1,
  'bitcoin-witness-commitment': 0xb2,
  'zcash-block': 0xc0,
  'zcash-tx': 0xc1,
  'caip-50': 0xca,
  'streamid': 0xce,
  'stellar-block': 0xd0,
  'stellar-tx': 0xd1,
  'md4': 0xd4,
  'md5': 0xd5,
  'bmt': 0xd6,
  'decred-block': 0xe0,
  'decred-tx': 0xe1,
  'ipld-ns': 0xe2,
  'ipfs-ns': 0xe3,
  'swarm-ns': 0xe4,
  'ipns-ns': 0xe5,
  'zeronet': 0xe6,
  'secp256k1-pub': 0xe7,
  'bls12_381-g1-pub': 0xea,
  'bls12_381-g2-pub': 0xeb,
  'x25519-pub': 0xec,
  'ed25519-pub': 0xed,
  'bls12_381-g1g2-pub': 0xee,
  'dash-block': 0xf0,
  'dash-tx': 0xf1,
  'swarm-manifest': 0xfa,
  'swarm-feed': 0xfb,
  'udp': 0x0111,
  'p2p-webrtc-star': 0x0113,
  'p2p-webrtc-direct': 0x0114,
  'p2p-stardust': 0x0115,
  'p2p-circuit': 0x0122,
  'dag-json': 0x0129,
  'udt': 0x012d,
  'utp': 0x012e,
  'unix': 0x0190,
  'thread': 0x0196,
  'p2p': 0x01a5,
  'ipfs': 0x01a5,
  'https': 0x01bb,
  'onion': 0x01bc,
  'onion3': 0x01bd,
  'garlic64': 0x01be,
  'garlic32': 0x01bf,
  'tls': 0x01c0,
  'noise': 0x01c6,
  'quic': 0x01cc,
  'ws': 0x01dd,
  'wss': 0x01de,
  'p2p-websocket-star': 0x01df,
  'http': 0x01e0,
  'swhid-1-snp': 0x01f0,
  'json': 0x0200,
  'messagepack': 0x0201,
  'libp2p-peer-record': 0x0301,
  'libp2p-relay-rsvp': 0x0302,
  'car-index-sorted': 0x0400,
  'sha2-256-trunc254-padded': 0x1012,
  'ripemd-128': 0x1052,
  'ripemd-160': 0x1053,
  'ripemd-256': 0x1054,
  'ripemd-320': 0x1055,
  'x11': 0x1100,
  'p256-pub': 0x1200,
  'p384-pub': 0x1201,
  'p521-pub': 0x1202,
  'ed448-pub': 0x1203,
  'x448-pub': 0x1204,
  'ed25519-priv': 0x1300,
  'secp256k1-priv': 0x1301,
  'x25519-priv': 0x1302,
  'kangarootwelve': 0x1d01,
  'sm3-256': 0x534d,
  'blake2b-8': 0xb201,
  'blake2b-16': 0xb202,
  'blake2b-24': 0xb203,
  'blake2b-32': 0xb204,
  'blake2b-40': 0xb205,
  'blake2b-48': 0xb206,
  'blake2b-56': 0xb207,
  'blake2b-64': 0xb208,
  'blake2b-72': 0xb209,
  'blake2b-80': 0xb20a,
  'blake2b-88': 0xb20b,
  'blake2b-96': 0xb20c,
  'blake2b-104': 0xb20d,
  'blake2b-112': 0xb20e,
  'blake2b-120': 0xb20f,
  'blake2b-128': 0xb210,
  'blake2b-136': 0xb211,
  'blake2b-144': 0xb212,
  'blake2b-152': 0xb213,
  'blake2b-160': 0xb214,
  'blake2b-168': 0xb215,
  'blake2b-176': 0xb216,
  'blake2b-184': 0xb217,
  'blake2b-192': 0xb218,
  'blake2b-200': 0xb219,
  'blake2b-208': 0xb21a,
  'blake2b-216': 0xb21b,
  'blake2b-224': 0xb21c,
  'blake2b-232': 0xb21d,
  'blake2b-240': 0xb21e,
  'blake2b-248': 0xb21f,
  'blake2b-256': 0xb220,
  'blake2b-264': 0xb221,
  'blake2b-272': 0xb222,
  'blake2b-280': 0xb223,
  'blake2b-288': 0xb224,
  'blake2b-296': 0xb225,
  'blake2b-304': 0xb226,
  'blake2b-312': 0xb227,
  'blake2b-320': 0xb228,
  'blake2b-328': 0xb229,
  'blake2b-336': 0xb22a,
  'blake2b-344': 0xb22b,
  'blake2b-352': 0xb22c,
  'blake2b-360': 0xb22d,
  'blake2b-368': 0xb22e,
  'blake2b-376': 0xb22f,
  'blake2b-384': 0xb230,
  'blake2b-392': 0xb231,
  'blake2b-400': 0xb232,
  'blake2b-408': 0xb233,
  'blake2b-416': 0xb234,
  'blake2b-424': 0xb235,
  'blake2b-432': 0xb236,
  'blake2b-440': 0xb237,
  'blake2b-448': 0xb238,
  'blake2b-456': 0xb239,
  'blake2b-464': 0xb23a,
  'blake2b-472': 0xb23b,
  'blake2b-480': 0xb23c,
  'blake2b-488': 0xb23d,
  'blake2b-496': 0xb23e,
  'blake2b-504': 0xb23f,
  'blake2b-512': 0xb240,
  'blake2s-8': 0xb241,
  'blake2s-16': 0xb242,
  'blake2s-24': 0xb243,
  'blake2s-32': 0xb244,
  'blake2s-40': 0xb245,
  'blake2s-48': 0xb246,
  'blake2s-56': 0xb247,
  'blake2s-64': 0xb248,
  'blake2s-72': 0xb249,
  'blake2s-80': 0xb24a,
  'blake2s-88': 0xb24b,
  'blake2s-96': 0xb24c,
  'blake2s-104': 0xb24d,
  'blake2s-112': 0xb24e,
  'blake2s-120': 0xb24f,
  'blake2s-128': 0xb250,
  'blake2s-136': 0xb251,
  'blake2s-144': 0xb252,
  'blake2s-152': 0xb253,
  'blake2s-160': 0xb254,
  'blake2s-168': 0xb255,
  'blake2s-176': 0xb256,
  'blake2s-184': 0xb257,
  'blake2s-192': 0xb258,
  'blake2s-200': 0xb259,
  'blake2s-208': 0xb25a,
  'blake2s-216': 0xb25b,
  'blake2s-224': 0xb25c,
  'blake2s-232': 0xb25d,
  'blake2s-240': 0xb25e,
  'blake2s-248': 0xb25f,
  'blake2s-256': 0xb260,
  'skein256-8': 0xb301,
  'skein256-16': 0xb302,
  'skein256-24': 0xb303,
  'skein256-32': 0xb304,
  'skein256-40': 0xb305,
  'skein256-48': 0xb306,
  'skein256-56': 0xb307,
  'skein256-64': 0xb308,
  'skein256-72': 0xb309,
  'skein256-80': 0xb30a,
  'skein256-88': 0xb30b,
  'skein256-96': 0xb30c,
  'skein256-104': 0xb30d,
  'skein256-112': 0xb30e,
  'skein256-120': 0xb30f,
  'skein256-128': 0xb310,
  'skein256-136': 0xb311,
  'skein256-144': 0xb312,
  'skein256-152': 0xb313,
  'skein256-160': 0xb314,
  'skein256-168': 0xb315,
  'skein256-176': 0xb316,
  'skein256-184': 0xb317,
  'skein256-192': 0xb318,
  'skein256-200': 0xb319,
  'skein256-208': 0xb31a,
  'skein256-216': 0xb31b,
  'skein256-224': 0xb31c,
  'skein256-232': 0xb31d,
  'skein256-240': 0xb31e,
  'skein256-248': 0xb31f,
  'skein256-256': 0xb320,
  'skein512-8': 0xb321,
  'skein512-16': 0xb322,
  'skein512-24': 0xb323,
  'skein512-32': 0xb324,
  'skein512-40': 0xb325,
  'skein512-48': 0xb326,
  'skein512-56': 0xb327,
  'skein512-64': 0xb328,
  'skein512-72': 0xb329,
  'skein512-80': 0xb32a,
  'skein512-88': 0xb32b,
  'skein512-96': 0xb32c,
  'skein512-104': 0xb32d,
  'skein512-112': 0xb32e,
  'skein512-120': 0xb32f,
  'skein512-128': 0xb330,
  'skein512-136': 0xb331,
  'skein512-144': 0xb332,
  'skein512-152': 0xb333,
  'skein512-160': 0xb334,
  'skein512-168': 0xb335,
  'skein512-176': 0xb336,
  'skein512-184': 0xb337,
  'skein512-192': 0xb338,
  'skein512-200': 0xb339,
  'skein512-208': 0xb33a,
  'skein512-216': 0xb33b,
  'skein512-224': 0xb33c,
  'skein512-232': 0xb33d,
  'skein512-240': 0xb33e,
  'skein512-248': 0xb33f,
  'skein512-256': 0xb340,
  'skein512-264': 0xb341,
  'skein512-272': 0xb342,
  'skein512-280': 0xb343,
  'skein512-288': 0xb344,
  'skein512-296': 0xb345,
  'skein512-304': 0xb346,
  'skein512-312': 0xb347,
  'skein512-320': 0xb348,
  'skein512-328': 0xb349,
  'skein512-336': 0xb34a,
  'skein512-344': 0xb34b,
  'skein512-352': 0xb34c,
  'skein512-360': 0xb34d,
  'skein512-368': 0xb34e,
  'skein512-376': 0xb34f,
  'skein512-384': 0xb350,
  'skein512-392': 0xb351,
  'skein512-400': 0xb352,
  'skein512-408': 0xb353,
  'skein512-416': 0xb354,
  'skein512-424': 0xb355,
  'skein512-432': 0xb356,
  'skein512-440': 0xb357,
  'skein512-448': 0xb358,
  'skein512-456': 0xb359,
  'skein512-464': 0xb35a,
  'skein512-472': 0xb35b,
  'skein512-480': 0xb35c,
  'skein512-488': 0xb35d,
  'skein512-496': 0xb35e,
  'skein512-504': 0xb35f,
  'skein512-512': 0xb360,
  'skein1024-8': 0xb361,
  'skein1024-16': 0xb362,
  'skein1024-24': 0xb363,
  'skein1024-32': 0xb364,
  'skein1024-40': 0xb365,
  'skein1024-48': 0xb366,
  'skein1024-56': 0xb367,
  'skein1024-64': 0xb368,
  'skein1024-72': 0xb369,
  'skein1024-80': 0xb36a,
  'skein1024-88': 0xb36b,
  'skein1024-96': 0xb36c,
  'skein1024-104': 0xb36d,
  'skein1024-112': 0xb36e,
  'skein1024-120': 0xb36f,
  'skein1024-128': 0xb370,
  'skein1024-136': 0xb371,
  'skein1024-144': 0xb372,
  'skein1024-152': 0xb373,
  'skein1024-160': 0xb374,
  'skein1024-168': 0xb375,
  'skein1024-176': 0xb376,
  'skein1024-184': 0xb377,
  'skein1024-192': 0xb378,
  'skein1024-200': 0xb379,
  'skein1024-208': 0xb37a,
  'skein1024-216': 0xb37b,
  'skein1024-224': 0xb37c,
  'skein1024-232': 0xb37d,
  'skein1024-240': 0xb37e,
  'skein1024-248': 0xb37f,
  'skein1024-256': 0xb380,
  'skein1024-264': 0xb381,
  'skein1024-272': 0xb382,
  'skein1024-280': 0xb383,
  'skein1024-288': 0xb384,
  'skein1024-296': 0xb385,
  'skein1024-304': 0xb386,
  'skein1024-312': 0xb387,
  'skein1024-320': 0xb388,
  'skein1024-328': 0xb389,
  'skein1024-336': 0xb38a,
  'skein1024-344': 0xb38b,
  'skein1024-352': 0xb38c,
  'skein1024-360': 0xb38d,
  'skein1024-368': 0xb38e,
  'skein1024-376': 0xb38f,
  'skein1024-384': 0xb390,
  'skein1024-392': 0xb391,
  'skein1024-400': 0xb392,
  'skein1024-408': 0xb393,
  'skein1024-416': 0xb394,
  'skein1024-424': 0xb395,
  'skein1024-432': 0xb396,
  'skein1024-440': 0xb397,
  'skein1024-448': 0xb398,
  'skein1024-456': 0xb399,
  'skein1024-464': 0xb39a,
  'skein1024-472': 0xb39b,
  'skein1024-480': 0xb39c,
  'skein1024-488': 0xb39d,
  'skein1024-496': 0xb39e,
  'skein1024-504': 0xb39f,
  'skein1024-512': 0xb3a0,
  'skein1024-520': 0xb3a1,
  'skein1024-528': 0xb3a2,
  'skein1024-536': 0xb3a3,
  'skein1024-544': 0xb3a4,
  'skein1024-552': 0xb3a5,
  'skein1024-560': 0xb3a6,
  'skein1024-568': 0xb3a7,
  'skein1024-576': 0xb3a8,
  'skein1024-584': 0xb3a9,
  'skein1024-592': 0xb3aa,
  'skein1024-600': 0xb3ab,
  'skein1024-608': 0xb3ac,
  'skein1024-616': 0xb3ad,
  'skein1024-624': 0xb3ae,
  'skein1024-632': 0xb3af,
  'skein1024-640': 0xb3b0,
  'skein1024-648': 0xb3b1,
  'skein1024-656': 0xb3b2,
  'skein1024-664': 0xb3b3,
  'skein1024-672': 0xb3b4,
  'skein1024-680': 0xb3b5,
  'skein1024-688': 0xb3b6,
  'skein1024-696': 0xb3b7,
  'skein1024-704': 0xb3b8,
  'skein1024-712': 0xb3b9,
  'skein1024-720': 0xb3ba,
  'skein1024-728': 0xb3bb,
  'skein1024-736': 0xb3bc,
  'skein1024-744': 0xb3bd,
  'skein1024-752': 0xb3be,
  'skein1024-760': 0xb3bf,
  'skein1024-768': 0xb3c0,
  'skein1024-776': 0xb3c1,
  'skein1024-784': 0xb3c2,
  'skein1024-792': 0xb3c3,
  'skein1024-800': 0xb3c4,
  'skein1024-808': 0xb3c5,
  'skein1024-816': 0xb3c6,
  'skein1024-824': 0xb3c7,
  'skein1024-832': 0xb3c8,
  'skein1024-840': 0xb3c9,
  'skein1024-848': 0xb3ca,
  'skein1024-856': 0xb3cb,
  'skein1024-864': 0xb3cc,
  'skein1024-872': 0xb3cd,
  'skein1024-880': 0xb3ce,
  'skein1024-888': 0xb3cf,
  'skein1024-896': 0xb3d0,
  'skein1024-904': 0xb3d1,
  'skein1024-912': 0xb3d2,
  'skein1024-920': 0xb3d3,
  'skein1024-928': 0xb3d4,
  'skein1024-936': 0xb3d5,
  'skein1024-944': 0xb3d6,
  'skein1024-952': 0xb3d7,
  'skein1024-960': 0xb3d8,
  'skein1024-968': 0xb3d9,
  'skein1024-976': 0xb3da,
  'skein1024-984': 0xb3db,
  'skein1024-992': 0xb3dc,
  'skein1024-1000': 0xb3dd,
  'skein1024-1008': 0xb3de,
  'skein1024-1016': 0xb3df,
  'skein1024-1024': 0xb3e0,
  'poseidon-bls12_381-a2-fc1': 0xb401,
  'poseidon-bls12_381-a2-fc1-sc': 0xb402,
  'zeroxcert-imprint-256': 0xce11,
  'fil-commitment-unsealed': 0xf101,
  'fil-commitment-sealed': 0xf102,
  'holochain-adr-v0': 0x807124,
  'holochain-adr-v1': 0x817124,
  'holochain-key-v0': 0x947124,
  'holochain-key-v1': 0x957124,
  'holochain-sig-v0': 0xa27124,
  'holochain-sig-v1': 0xa37124,
  'skynet-ns': 0xb19910,
  'arweave-ns': 0xb29910
})

module.exports = { baseTable }

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec",file:"node_modules\\multicodec\\src\\generated-table.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\src\\index.js", {"./maps":"D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\src\\maps.js","./util":"D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\src\\util.js","uint8arrays/concat":"D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\node_modules\\uint8arrays\\cjs\\src\\concat.js","varint":"D:\\code\\v\\metamask-extension\\node_modules\\varint\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmulticodec%5Csrc%5Cindex.js
      return function (require, module, exports) {
/**
 * Implementation of the multicodec specification.
 *
 * @module multicodec
 * @example
 * const multicodec = require('multicodec')
 *
 * const prefixedProtobuf = multicodec.addPrefix('protobuf', protobufBuffer)
 * // prefixedProtobuf 0x50...
 *
 */
'use strict'

/** @typedef {__import__('./generated-types').CodecName} CodecName */
/** @typedef {__import__('./generated-types').CodecCode} CodecCode */

const varint = require('varint')
const { concat: uint8ArrayConcat } = require('uint8arrays/concat')
const util = require('./util')
const { nameToVarint, constantToCode, nameToCode, codeToName } = require('./maps')

/**
 * Prefix a buffer with a multicodec-packed.
 *
 * @param {CodecName|Uint8Array} multicodecStrOrCode
 * @param {Uint8Array} data
 * @returns {Uint8Array}
 */
function addPrefix (multicodecStrOrCode, data) {
  let prefix

  if (multicodecStrOrCode instanceof Uint8Array) {
    prefix = util.varintUint8ArrayEncode(multicodecStrOrCode)
  } else {
    if (nameToVarint[multicodecStrOrCode]) {
      prefix = nameToVarint[multicodecStrOrCode]
    } else {
      throw new Error('multicodec not recognized')
    }
  }

  return uint8ArrayConcat([prefix, data], prefix.length + data.length)
}

/**
 * Decapsulate the multicodec-packed prefix from the data.
 *
 * @param {Uint8Array} data
 * @returns {Uint8Array}
 */
function rmPrefix (data) {
  varint.decode(/** @type {Buffer} */(data))
  return data.slice(varint.decode.bytes)
}

/**
 * Get the codec name of the prefixed data.
 *
 * @param {Uint8Array} prefixedData
 * @returns {CodecName}
 */
function getNameFromData (prefixedData) {
  const code = /** @type {CodecCode} */(varint.decode(/** @type {Buffer} */(prefixedData)))
  const name = codeToName[code]
  if (name === undefined) {
    throw new Error(`Code "${code}" not found`)
  }
  return name
}

/**
 * Get the codec name from a code.
 *
 * @param {CodecCode} codec
 * @returns {CodecName}
 */
function getNameFromCode (codec) {
  return codeToName[codec]
}

/**
 * Get the code of the codec
 *
 * @param {CodecName} name
 * @returns {CodecCode}
 */
function getCodeFromName (name) {
  const code = nameToCode[name]
  if (code === undefined) {
    throw new Error(`Codec "${name}" not found`)
  }
  return code
}

/**
 * Get the code of the prefixed data.
 *
 * @param {Uint8Array} prefixedData
 * @returns {CodecCode}
 */
function getCodeFromData (prefixedData) {
  return /** @type {CodecCode} */(varint.decode(/** @type {Buffer} */(prefixedData)))
}

/**
 * Get the code as varint of a codec name.
 *
 * @param {CodecName} name
 * @returns {Uint8Array}
 */
function getVarintFromName (name) {
  const code = nameToVarint[name]
  if (code === undefined) {
    throw new Error(`Codec "${name}" not found`)
  }
  return code
}

/**
 * Get the varint of a code.
 *
 * @param {CodecCode} code
 * @returns {Uint8Array}
 */
function getVarintFromCode (code) {
  return util.varintEncode(code)
}

/**
 * Get the codec name of the prefixed data.
 *
 * @deprecated use getNameFromData instead.
 * @param {Uint8Array} prefixedData
 * @returns {CodecName}
 */
function getCodec (prefixedData) {
  return getNameFromData(prefixedData)
}

/**
 * Get the codec name from a code.
 *
 * @deprecated use getNameFromCode instead.
 * @param {CodecCode} codec
 * @returns {CodecName}
 */
function getName (codec) {
  return getNameFromCode(codec)
}

/**
 * Get the code of the codec
 *
 * @deprecated use getCodeFromName instead.
 * @param {CodecName} name
 * @returns {CodecCode}
 */
function getNumber (name) {
  return getCodeFromName(name)
}

/**
 * Get the code of the prefixed data.
 *
 * @deprecated use getCodeFromData instead.
 * @param {Uint8Array} prefixedData
 * @returns {CodecCode}
 */
function getCode (prefixedData) {
  return getCodeFromData(prefixedData)
}

/**
 * Get the code as varint of a codec name.
 *
 * @deprecated use getVarintFromName instead.
 * @param {CodecName} name
 * @returns {Uint8Array}
 */
function getCodeVarint (name) {
  return getVarintFromName(name)
}

/**
 * Get the varint of a code.
 *
 * @deprecated use getVarintFromCode instead.
 * @param {CodecCode} code
 * @returns {Array.<number>}
 */
function getVarint (code) {
  return Array.from(getVarintFromCode(code))
}

module.exports = {
  addPrefix,
  rmPrefix,
  getNameFromData,
  getNameFromCode,
  getCodeFromName,
  getCodeFromData,
  getVarintFromName,
  getVarintFromCode,
  // Deprecated
  getCodec,
  getName,
  getNumber,
  getCode,
  getCodeVarint,
  getVarint,
  // Make the constants top-level constants
  ...constantToCode,
  // Export the maps
  nameToVarint,
  nameToCode,
  codeToName
}

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec",file:"node_modules\\multicodec\\src\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\src\\maps.js", {"./generated-table":"D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\src\\generated-table.js","./util":"D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\src\\util.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmulticodec%5Csrc%5Cmaps.js
      return function (require, module, exports) {
'use strict'

/** @typedef {__import__('./generated-types').ConstantCodeMap} ConstantCodeMap */
/** @typedef {__import__('./generated-types').NameUint8ArrayMap} NameUint8ArrayMap */
/** @typedef {__import__('./generated-types').CodeNameMap} CodeNameMap */
/** @typedef {__import__('./generated-types').CodecName} CodecName */
/** @typedef {__import__('./generated-types').CodecConstant} CodecConstant */

const { baseTable } = require('./generated-table')
const varintEncode = require('./util').varintEncode

const nameToVarint = /** @type {NameUint8ArrayMap} */ ({})
const constantToCode = /** @type {ConstantCodeMap} */({})
const codeToName = /** @type {CodeNameMap} */({})

// eslint-disable-next-line guard-for-in
for (const name in baseTable) {
  const codecName = /** @type {CodecName} */(name)
  const code = baseTable[codecName]
  nameToVarint[codecName] = varintEncode(code)

  const constant = /** @type {CodecConstant} */(codecName.toUpperCase().replace(/-/g, '_'))
  constantToCode[constant] = code

  if (!codeToName[code]) {
    codeToName[code] = codecName
  }
}

Object.freeze(nameToVarint)
Object.freeze(constantToCode)
Object.freeze(codeToName)
const nameToCode = Object.freeze(baseTable)
module.exports = {
  nameToVarint,
  constantToCode,
  nameToCode,
  codeToName
}

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec",file:"node_modules\\multicodec\\src\\maps.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\src\\util.js", {"uint8arrays/from-string":"D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\node_modules\\uint8arrays\\cjs\\src\\from-string.js","uint8arrays/to-string":"D:\\code\\v\\metamask-extension\\node_modules\\multicodec\\node_modules\\uint8arrays\\cjs\\src\\to-string.js","varint":"D:\\code\\v\\metamask-extension\\node_modules\\varint\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmulticodec%5Csrc%5Cutil.js
      return function (require, module, exports) {
'use strict'

const varint = require('varint')
const { toString: uint8ArrayToString } = require('uint8arrays/to-string')
const { fromString: uint8ArrayFromString } = require('uint8arrays/from-string')

module.exports = {
  numberToUint8Array,
  uint8ArrayToNumber,
  varintUint8ArrayEncode,
  varintEncode
}

/**
 * @param {Uint8Array} buf
 */
function uint8ArrayToNumber (buf) {
  return parseInt(uint8ArrayToString(buf, 'base16'), 16)
}

/**
 * @param {number} num
 */
function numberToUint8Array (num) {
  let hexString = num.toString(16)
  if (hexString.length % 2 === 1) {
    hexString = '0' + hexString
  }
  return uint8ArrayFromString(hexString, 'base16')
}

/**
 * @param {Uint8Array} input
 */
function varintUint8ArrayEncode (input) {
  return Uint8Array.from(varint.encode(uint8ArrayToNumber(input)))
}

/**
 * @param {number} num
 */
function varintEncode (num) {
  return Uint8Array.from(varint.encode(num))
}

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec",file:"node_modules\\multicodec\\src\\util.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base10.js", {"./base.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultiformats%5Ccjs%5Csrc%5Cbases%5Cbase10.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var base = require('./base.js');

const base10 = base.baseX({
  prefix: '9',
  name: 'base10',
  alphabet: '0123456789'
});

exports.base10 = base10;

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec>uint8arrays>multiformats",file:"node_modules\\multiformats\\cjs\\src\\bases\\base10.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base16.js", {"./base.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultiformats%5Ccjs%5Csrc%5Cbases%5Cbase16.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var base = require('./base.js');

const base16 = base.rfc4648({
  prefix: 'f',
  name: 'base16',
  alphabet: '0123456789abcdef',
  bitsPerChar: 4
});
const base16upper = base.rfc4648({
  prefix: 'F',
  name: 'base16upper',
  alphabet: '0123456789ABCDEF',
  bitsPerChar: 4
});

exports.base16 = base16;
exports.base16upper = base16upper;

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec>uint8arrays>multiformats",file:"node_modules\\multiformats\\cjs\\src\\bases\\base16.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base2.js", {"./base.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultiformats%5Ccjs%5Csrc%5Cbases%5Cbase2.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var base = require('./base.js');

const base2 = base.rfc4648({
  prefix: '0',
  name: 'base2',
  alphabet: '01',
  bitsPerChar: 1
});

exports.base2 = base2;

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec>uint8arrays>multiformats",file:"node_modules\\multiformats\\cjs\\src\\bases\\base2.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base256emoji.js", {"./base.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultiformats%5Ccjs%5Csrc%5Cbases%5Cbase256emoji.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var base = require('./base.js');

const alphabet = Array.from('\uD83D\uDE80\uD83E\uDE90\u2604\uD83D\uDEF0\uD83C\uDF0C\uD83C\uDF11\uD83C\uDF12\uD83C\uDF13\uD83C\uDF14\uD83C\uDF15\uD83C\uDF16\uD83C\uDF17\uD83C\uDF18\uD83C\uDF0D\uD83C\uDF0F\uD83C\uDF0E\uD83D\uDC09\u2600\uD83D\uDCBB\uD83D\uDDA5\uD83D\uDCBE\uD83D\uDCBF\uD83D\uDE02\u2764\uD83D\uDE0D\uD83E\uDD23\uD83D\uDE0A\uD83D\uDE4F\uD83D\uDC95\uD83D\uDE2D\uD83D\uDE18\uD83D\uDC4D\uD83D\uDE05\uD83D\uDC4F\uD83D\uDE01\uD83D\uDD25\uD83E\uDD70\uD83D\uDC94\uD83D\uDC96\uD83D\uDC99\uD83D\uDE22\uD83E\uDD14\uD83D\uDE06\uD83D\uDE44\uD83D\uDCAA\uD83D\uDE09\u263A\uD83D\uDC4C\uD83E\uDD17\uD83D\uDC9C\uD83D\uDE14\uD83D\uDE0E\uD83D\uDE07\uD83C\uDF39\uD83E\uDD26\uD83C\uDF89\uD83D\uDC9E\u270C\u2728\uD83E\uDD37\uD83D\uDE31\uD83D\uDE0C\uD83C\uDF38\uD83D\uDE4C\uD83D\uDE0B\uD83D\uDC97\uD83D\uDC9A\uD83D\uDE0F\uD83D\uDC9B\uD83D\uDE42\uD83D\uDC93\uD83E\uDD29\uD83D\uDE04\uD83D\uDE00\uD83D\uDDA4\uD83D\uDE03\uD83D\uDCAF\uD83D\uDE48\uD83D\uDC47\uD83C\uDFB6\uD83D\uDE12\uD83E\uDD2D\u2763\uD83D\uDE1C\uD83D\uDC8B\uD83D\uDC40\uD83D\uDE2A\uD83D\uDE11\uD83D\uDCA5\uD83D\uDE4B\uD83D\uDE1E\uD83D\uDE29\uD83D\uDE21\uD83E\uDD2A\uD83D\uDC4A\uD83E\uDD73\uD83D\uDE25\uD83E\uDD24\uD83D\uDC49\uD83D\uDC83\uD83D\uDE33\u270B\uD83D\uDE1A\uD83D\uDE1D\uD83D\uDE34\uD83C\uDF1F\uD83D\uDE2C\uD83D\uDE43\uD83C\uDF40\uD83C\uDF37\uD83D\uDE3B\uD83D\uDE13\u2B50\u2705\uD83E\uDD7A\uD83C\uDF08\uD83D\uDE08\uD83E\uDD18\uD83D\uDCA6\u2714\uD83D\uDE23\uD83C\uDFC3\uD83D\uDC90\u2639\uD83C\uDF8A\uD83D\uDC98\uD83D\uDE20\u261D\uD83D\uDE15\uD83C\uDF3A\uD83C\uDF82\uD83C\uDF3B\uD83D\uDE10\uD83D\uDD95\uD83D\uDC9D\uD83D\uDE4A\uD83D\uDE39\uD83D\uDDE3\uD83D\uDCAB\uD83D\uDC80\uD83D\uDC51\uD83C\uDFB5\uD83E\uDD1E\uD83D\uDE1B\uD83D\uDD34\uD83D\uDE24\uD83C\uDF3C\uD83D\uDE2B\u26BD\uD83E\uDD19\u2615\uD83C\uDFC6\uD83E\uDD2B\uD83D\uDC48\uD83D\uDE2E\uD83D\uDE46\uD83C\uDF7B\uD83C\uDF43\uD83D\uDC36\uD83D\uDC81\uD83D\uDE32\uD83C\uDF3F\uD83E\uDDE1\uD83C\uDF81\u26A1\uD83C\uDF1E\uD83C\uDF88\u274C\u270A\uD83D\uDC4B\uD83D\uDE30\uD83E\uDD28\uD83D\uDE36\uD83E\uDD1D\uD83D\uDEB6\uD83D\uDCB0\uD83C\uDF53\uD83D\uDCA2\uD83E\uDD1F\uD83D\uDE41\uD83D\uDEA8\uD83D\uDCA8\uD83E\uDD2C\u2708\uD83C\uDF80\uD83C\uDF7A\uD83E\uDD13\uD83D\uDE19\uD83D\uDC9F\uD83C\uDF31\uD83D\uDE16\uD83D\uDC76\uD83E\uDD74\u25B6\u27A1\u2753\uD83D\uDC8E\uD83D\uDCB8\u2B07\uD83D\uDE28\uD83C\uDF1A\uD83E\uDD8B\uD83D\uDE37\uD83D\uDD7A\u26A0\uD83D\uDE45\uD83D\uDE1F\uD83D\uDE35\uD83D\uDC4E\uD83E\uDD32\uD83E\uDD20\uD83E\uDD27\uD83D\uDCCC\uD83D\uDD35\uD83D\uDC85\uD83E\uDDD0\uD83D\uDC3E\uD83C\uDF52\uD83D\uDE17\uD83E\uDD11\uD83C\uDF0A\uD83E\uDD2F\uD83D\uDC37\u260E\uD83D\uDCA7\uD83D\uDE2F\uD83D\uDC86\uD83D\uDC46\uD83C\uDFA4\uD83D\uDE47\uD83C\uDF51\u2744\uD83C\uDF34\uD83D\uDCA3\uD83D\uDC38\uD83D\uDC8C\uD83D\uDCCD\uD83E\uDD40\uD83E\uDD22\uD83D\uDC45\uD83D\uDCA1\uD83D\uDCA9\uD83D\uDC50\uD83D\uDCF8\uD83D\uDC7B\uD83E\uDD10\uD83E\uDD2E\uD83C\uDFBC\uD83E\uDD75\uD83D\uDEA9\uD83C\uDF4E\uD83C\uDF4A\uD83D\uDC7C\uD83D\uDC8D\uD83D\uDCE3\uD83E\uDD42');
const alphabetBytesToChars = alphabet.reduce((p, c, i) => {
  p[i] = c;
  return p;
}, []);
const alphabetCharsToBytes = alphabet.reduce((p, c, i) => {
  p[c.codePointAt(0)] = i;
  return p;
}, []);
function encode(data) {
  return data.reduce((p, c) => {
    p += alphabetBytesToChars[c];
    return p;
  }, '');
}
function decode(str) {
  const byts = [];
  for (const char of str) {
    const byt = alphabetCharsToBytes[char.codePointAt(0)];
    if (byt === undefined) {
      throw new Error(`Non-base256emoji character: ${ char }`);
    }
    byts.push(byt);
  }
  return new Uint8Array(byts);
}
const base256emoji = base.from({
  prefix: '\uD83D\uDE80',
  name: 'base256emoji',
  encode,
  decode
});

exports.base256emoji = base256emoji;

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec>uint8arrays>multiformats",file:"node_modules\\multiformats\\cjs\\src\\bases\\base256emoji.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base36.js", {"./base.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultiformats%5Ccjs%5Csrc%5Cbases%5Cbase36.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var base = require('./base.js');

const base36 = base.baseX({
  prefix: 'k',
  name: 'base36',
  alphabet: '0123456789abcdefghijklmnopqrstuvwxyz'
});
const base36upper = base.baseX({
  prefix: 'K',
  name: 'base36upper',
  alphabet: '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'
});

exports.base36 = base36;
exports.base36upper = base36upper;

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec>uint8arrays>multiformats",file:"node_modules\\multiformats\\cjs\\src\\bases\\base36.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base64.js", {"./base.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultiformats%5Ccjs%5Csrc%5Cbases%5Cbase64.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var base = require('./base.js');

const base64 = base.rfc4648({
  prefix: 'm',
  name: 'base64',
  alphabet: 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/',
  bitsPerChar: 6
});
const base64pad = base.rfc4648({
  prefix: 'M',
  name: 'base64pad',
  alphabet: 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=',
  bitsPerChar: 6
});
const base64url = base.rfc4648({
  prefix: 'u',
  name: 'base64url',
  alphabet: 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_',
  bitsPerChar: 6
});
const base64urlpad = base.rfc4648({
  prefix: 'U',
  name: 'base64urlpad',
  alphabet: 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_=',
  bitsPerChar: 6
});

exports.base64 = base64;
exports.base64pad = base64pad;
exports.base64url = base64url;
exports.base64urlpad = base64urlpad;

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec>uint8arrays>multiformats",file:"node_modules\\multiformats\\cjs\\src\\bases\\base64.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base8.js", {"./base.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultiformats%5Ccjs%5Csrc%5Cbases%5Cbase8.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var base = require('./base.js');

const base8 = base.rfc4648({
  prefix: '7',
  name: 'base8',
  alphabet: '01234567',
  bitsPerChar: 3
});

exports.base8 = base8;

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec>uint8arrays>multiformats",file:"node_modules\\multiformats\\cjs\\src\\bases\\base8.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\identity.js", {"../bytes.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bytes.js","./base.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultiformats%5Ccjs%5Csrc%5Cbases%5Cidentity.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var base = require('./base.js');
var bytes = require('../bytes.js');

const identity = base.from({
  prefix: '\0',
  name: 'identity',
  encode: buf => bytes.toString(buf),
  decode: str => bytes.fromString(str)
});

exports.identity = identity;

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec>uint8arrays>multiformats",file:"node_modules\\multiformats\\cjs\\src\\bases\\identity.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\basics.js", {"./bases/base10.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base10.js","./bases/base16.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base16.js","./bases/base2.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base2.js","./bases/base256emoji.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base256emoji.js","./bases/base32.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base32.js","./bases/base36.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base36.js","./bases/base58.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base58.js","./bases/base64.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base64.js","./bases/base8.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\base8.js","./bases/identity.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bases\\identity.js","./bytes.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bytes.js","./cid.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\cid.js","./codecs/json.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\codecs\\json.js","./codecs/raw.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\codecs\\raw.js","./hashes/digest.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\hashes\\digest.js","./hashes/hasher.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\hashes\\hasher.js","./hashes/identity.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\hashes\\identity.js","./hashes/sha2.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\hashes\\sha2-browser.js","./index.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\index.js","./varint.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\varint.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultiformats%5Ccjs%5Csrc%5Cbasics.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var identity = require('./bases/identity.js');
var base2 = require('./bases/base2.js');
var base8 = require('./bases/base8.js');
var base10 = require('./bases/base10.js');
var base16 = require('./bases/base16.js');
var base32 = require('./bases/base32.js');
var base36 = require('./bases/base36.js');
var base58 = require('./bases/base58.js');
var base64 = require('./bases/base64.js');
var base256emoji = require('./bases/base256emoji.js');
var sha2 = require('./hashes/sha2.js');
var identity$1 = require('./hashes/identity.js');
var raw = require('./codecs/raw.js');
var json = require('./codecs/json.js');
require('./index.js');
var cid = require('./cid.js');
var hasher = require('./hashes/hasher.js');
var digest = require('./hashes/digest.js');
var varint = require('./varint.js');
var bytes = require('./bytes.js');

const bases = {
  ...identity,
  ...base2,
  ...base8,
  ...base10,
  ...base16,
  ...base32,
  ...base36,
  ...base58,
  ...base64,
  ...base256emoji
};
const hashes = {
  ...sha2,
  ...identity$1
};
const codecs = {
  raw,
  json
};

exports.CID = cid.CID;
exports.hasher = hasher;
exports.digest = digest;
exports.varint = varint;
exports.bytes = bytes;
exports.bases = bases;
exports.codecs = codecs;
exports.hashes = hashes;

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec>uint8arrays>multiformats",file:"node_modules\\multiformats\\cjs\\src\\basics.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\codecs\\json.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultiformats%5Ccjs%5Csrc%5Ccodecs%5Cjson.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const textEncoder = new TextEncoder();
const textDecoder = new TextDecoder();
const name = 'json';
const code = 512;
const encode = node => textEncoder.encode(JSON.stringify(node));
const decode = data => JSON.parse(textDecoder.decode(data));

exports.code = code;
exports.decode = decode;
exports.encode = encode;
exports.name = name;

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec>uint8arrays>multiformats",file:"node_modules\\multiformats\\cjs\\src\\codecs\\json.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\codecs\\raw.js", {"../bytes.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bytes.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultiformats%5Ccjs%5Csrc%5Ccodecs%5Craw.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var bytes = require('../bytes.js');

const name = 'raw';
const code = 85;
const encode = node => bytes.coerce(node);
const decode = data => bytes.coerce(data);

exports.code = code;
exports.decode = decode;
exports.encode = encode;
exports.name = name;

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec>uint8arrays>multiformats",file:"node_modules\\multiformats\\cjs\\src\\codecs\\raw.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\hashes\\identity.js", {"../bytes.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\bytes.js","./digest.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\hashes\\digest.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultiformats%5Ccjs%5Csrc%5Chashes%5Cidentity.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var bytes = require('../bytes.js');
var digest$1 = require('./digest.js');

const code = 0;
const name = 'identity';
const encode = bytes.coerce;
const digest = input => digest$1.create(code, encode(input));
const identity = {
  code,
  name,
  encode,
  digest
};

exports.identity = identity;

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec>uint8arrays>multiformats",file:"node_modules\\multiformats\\cjs\\src\\hashes\\identity.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\hashes\\sha2-browser.js", {"./hasher.js":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\hashes\\hasher.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultiformats%5Ccjs%5Csrc%5Chashes%5Csha2-browser.js
      return function (require, module, exports) {
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var hasher = require('./hasher.js');

const sha = name => async data => new Uint8Array(await crypto.subtle.digest(name, data));
const sha256 = hasher.from({
  name: 'sha2-256',
  code: 18,
  encode: sha('SHA-256')
});
const sha512 = hasher.from({
  name: 'sha2-512',
  code: 19,
  encode: sha('SHA-512')
});

exports.sha256 = sha256;
exports.sha512 = sha512;

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>multicodec>uint8arrays>multiformats",file:"node_modules\\multiformats\\cjs\\src\\hashes\\sha2-browser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multihashes\\node_modules\\uint8arrays\\concat.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultihashes%5Cnode_modules%5Cuint8arrays%5Cconcat.js
      return function (require, module, exports) {
'use strict'

/**
 * Returns a new Uint8Array created by concatenating the passed ArrayLikes
 *
 * @param {Array<ArrayLike<number>>} arrays
 * @param {number} [length]
 */
function concat (arrays, length) {
  if (!length) {
    length = arrays.reduce((acc, curr) => acc + curr.length, 0)
  }

  const output = new Uint8Array(length)
  let offset = 0

  for (const arr of arrays) {
    output.set(arr, offset)
    offset += arr.length
  }

  return output
}

module.exports = concat

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>cids>multihashes>uint8arrays",file:"node_modules\\multihashes\\node_modules\\uint8arrays\\concat.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multihashes\\node_modules\\uint8arrays\\from-string.js", {"multibase":"D:\\code\\v\\metamask-extension\\node_modules\\multibase\\src\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultihashes%5Cnode_modules%5Cuint8arrays%5Cfrom-string.js
      return function (require, module, exports) {
'use strict'

const { encoding: getCodec } = require('multibase')
const utf8Encoder = new TextEncoder()

/**
 * @typedef {__import__('multibase/src/types').BaseName | 'utf8' | 'utf-8' | 'ascii' | undefined} SupportedEncodings
 */

/**
 * Interprets each character in a string as a byte and
 * returns a Uint8Array of those bytes.
 *
 * @param {string} string - The string to turn into an array
 */
function asciiStringToUint8Array (string) {
  const array = new Uint8Array(string.length)

  for (let i = 0; i < string.length; i++) {
    array[i] = string.charCodeAt(i)
  }

  return array
}

/**
 * Create a `Uint8Array` from the passed string
 *
 * Supports `utf8`, `utf-8` and any encoding supported by the multibase module.
 *
 * Also `ascii` which is similar to node's 'binary' encoding.
 *
 * @param {string} string
 * @param {SupportedEncodings} [encoding=utf8] - utf8, base16, base64, base64urlpad, etc
 * @returns {Uint8Array}
 */
function fromString (string, encoding = 'utf8') {
  if (encoding === 'utf8' || encoding === 'utf-8') {
    return utf8Encoder.encode(string)
  }

  if (encoding === 'ascii') {
    return asciiStringToUint8Array(string)
  }

  return getCodec(encoding).decode(string)
}

module.exports = fromString

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>cids>multihashes>uint8arrays",file:"node_modules\\multihashes\\node_modules\\uint8arrays\\from-string.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multihashes\\node_modules\\uint8arrays\\to-string.js", {"multibase":"D:\\code\\v\\metamask-extension\\node_modules\\multibase\\src\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultihashes%5Cnode_modules%5Cuint8arrays%5Cto-string.js
      return function (require, module, exports) {
'use strict'

const { encoding: getCodec } = require('multibase')
const utf8Decoder = new TextDecoder('utf8')

/**
 * @typedef {__import__('multibase/src/types').BaseName | 'utf8' | 'utf-8' | 'ascii' | undefined} SupportedEncodings
 */

/**
 * Turns a Uint8Array of bytes into a string with each
 * character being the char code of the corresponding byte
 *
 * @param {Uint8Array} array - The array to turn into a string
 */
function uint8ArrayToAsciiString (array) {
  let string = ''

  for (let i = 0; i < array.length; i++) {
    string += String.fromCharCode(array[i])
  }
  return string
}

/**
 * Turns a `Uint8Array` into a string.
 *
 * Supports `utf8`, `utf-8` and any encoding supported by the multibase module.
 *
 * Also `ascii` which is similar to node's 'binary' encoding.
 *
 * @param {Uint8Array} array - The array to turn into a string
 * @param {SupportedEncodings} [encoding=utf8] - The encoding to use
 * @returns {string}
 */
function toString (array, encoding = 'utf8') {
  if (encoding === 'utf8' || encoding === 'utf-8') {
    return utf8Decoder.decode(array)
  }

  if (encoding === 'ascii') {
    return uint8ArrayToAsciiString(array)
  }

  return getCodec(encoding).encode(array)
}

module.exports = toString

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>cids>multihashes>uint8arrays",file:"node_modules\\multihashes\\node_modules\\uint8arrays\\to-string.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multihashes\\node_modules\\varint\\decode.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultihashes%5Cnode_modules%5Cvarint%5Cdecode.js
      return function (require, module, exports) {
module.exports = read

var MSB = 0x80
  , REST = 0x7F

function read(buf, offset) {
  var res    = 0
    , offset = offset || 0
    , shift  = 0
    , counter = offset
    , b
    , l = buf.length

  do {
    if (counter >= l) {
      read.bytes = 0
      throw new RangeError('Could not decode varint')
    }
    b = buf[counter++]
    res += shift < 28
      ? (b & REST) << shift
      : (b & REST) * Math.pow(2, shift)
    shift += 7
  } while (b >= MSB)

  read.bytes = counter - offset

  return res
}

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>cids>multihashes>varint",file:"node_modules\\multihashes\\node_modules\\varint\\decode.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multihashes\\node_modules\\varint\\encode.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultihashes%5Cnode_modules%5Cvarint%5Cencode.js
      return function (require, module, exports) {
module.exports = encode

var MSB = 0x80
  , REST = 0x7F
  , MSBALL = ~REST
  , INT = Math.pow(2, 31)

function encode(num, out, offset) {
  out = out || []
  offset = offset || 0
  var oldOffset = offset

  while(num >= INT) {
    out[offset++] = (num & 0xFF) | MSB
    num /= 128
  }
  while(num & MSBALL) {
    out[offset++] = (num & 0xFF) | MSB
    num >>>= 7
  }
  out[offset] = num | 0
  
  encode.bytes = offset - oldOffset + 1
  
  return out
}

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>cids>multihashes>varint",file:"node_modules\\multihashes\\node_modules\\varint\\encode.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multihashes\\node_modules\\varint\\index.js", {"./decode.js":"D:\\code\\v\\metamask-extension\\node_modules\\multihashes\\node_modules\\varint\\decode.js","./encode.js":"D:\\code\\v\\metamask-extension\\node_modules\\multihashes\\node_modules\\varint\\encode.js","./length.js":"D:\\code\\v\\metamask-extension\\node_modules\\multihashes\\node_modules\\varint\\length.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultihashes%5Cnode_modules%5Cvarint%5Cindex.js
      return function (require, module, exports) {
module.exports = {
    encode: require('./encode.js')
  , decode: require('./decode.js')
  , encodingLength: require('./length.js')
}

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>cids>multihashes>varint",file:"node_modules\\multihashes\\node_modules\\varint\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multihashes\\node_modules\\varint\\length.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultihashes%5Cnode_modules%5Cvarint%5Clength.js
      return function (require, module, exports) {

var N1 = Math.pow(2,  7)
var N2 = Math.pow(2, 14)
var N3 = Math.pow(2, 21)
var N4 = Math.pow(2, 28)
var N5 = Math.pow(2, 35)
var N6 = Math.pow(2, 42)
var N7 = Math.pow(2, 49)
var N8 = Math.pow(2, 56)
var N9 = Math.pow(2, 63)

module.exports = function (value) {
  return (
    value < N1 ? 1
  : value < N2 ? 2
  : value < N3 ? 3
  : value < N4 ? 4
  : value < N5 ? 5
  : value < N6 ? 6
  : value < N7 ? 7
  : value < N8 ? 8
  : value < N9 ? 9
  :              10
  )
}

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>cids>multihashes>varint",file:"node_modules\\multihashes\\node_modules\\varint\\length.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multihashes\\src\\constants.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultihashes%5Csrc%5Cconstants.js
      return function (require, module, exports) {
/* eslint quote-props: off */
'use strict'

/**
 * Names for all available hashes
 *
 * @typedef { "identity" | "sha1" | "sha2-256" | "sha2-512" | "sha3-512" | "sha3-384" | "sha3-256" | "sha3-224" | "shake-128" | "shake-256" | "keccak-224" | "keccak-256" | "keccak-384" | "keccak-512" | "blake3" | "murmur3-128" | "murmur3-32" | "dbl-sha2-256" | "md4" | "md5" | "bmt" | "sha2-256-trunc254-padded" | "ripemd-128" | "ripemd-160" | "ripemd-256" | "ripemd-320" | "x11" | "kangarootwelve" | "sm3-256" | "blake2b-8" | "blake2b-16" | "blake2b-24" | "blake2b-32" | "blake2b-40" | "blake2b-48" | "blake2b-56" | "blake2b-64" | "blake2b-72" | "blake2b-80" | "blake2b-88" | "blake2b-96" | "blake2b-104" | "blake2b-112" | "blake2b-120" | "blake2b-128" | "blake2b-136" | "blake2b-144" | "blake2b-152" | "blake2b-160" | "blake2b-168" | "blake2b-176" | "blake2b-184" | "blake2b-192" | "blake2b-200" | "blake2b-208" | "blake2b-216" | "blake2b-224" | "blake2b-232" | "blake2b-240" | "blake2b-248" | "blake2b-256" | "blake2b-264" | "blake2b-272" | "blake2b-280" | "blake2b-288" | "blake2b-296" | "blake2b-304" | "blake2b-312" | "blake2b-320" | "blake2b-328" | "blake2b-336" | "blake2b-344" | "blake2b-352" | "blake2b-360" | "blake2b-368" | "blake2b-376" | "blake2b-384" | "blake2b-392" | "blake2b-400" | "blake2b-408" | "blake2b-416" | "blake2b-424" | "blake2b-432" | "blake2b-440" | "blake2b-448" | "blake2b-456" | "blake2b-464" | "blake2b-472" | "blake2b-480" | "blake2b-488" | "blake2b-496" | "blake2b-504" | "blake2b-512" | "blake2s-8" | "blake2s-16" | "blake2s-24" | "blake2s-32" | "blake2s-40" | "blake2s-48" | "blake2s-56" | "blake2s-64" | "blake2s-72" | "blake2s-80" | "blake2s-88" | "blake2s-96" | "blake2s-104" | "blake2s-112" | "blake2s-120" | "blake2s-128" | "blake2s-136" | "blake2s-144" | "blake2s-152" | "blake2s-160" | "blake2s-168" | "blake2s-176" | "blake2s-184" | "blake2s-192" | "blake2s-200" | "blake2s-208" | "blake2s-216" | "blake2s-224" | "blake2s-232" | "blake2s-240" | "blake2s-248" | "blake2s-256" | "skein256-8" | "skein256-16" | "skein256-24" | "skein256-32" | "skein256-40" | "skein256-48" | "skein256-56" | "skein256-64" | "skein256-72" | "skein256-80" | "skein256-88" | "skein256-96" | "skein256-104" | "skein256-112" | "skein256-120" | "skein256-128" | "skein256-136" | "skein256-144" | "skein256-152" | "skein256-160" | "skein256-168" | "skein256-176" | "skein256-184" | "skein256-192" | "skein256-200" | "skein256-208" | "skein256-216" | "skein256-224" | "skein256-232" | "skein256-240" | "skein256-248" | "skein256-256" | "skein512-8" | "skein512-16" | "skein512-24" | "skein512-32" | "skein512-40" | "skein512-48" | "skein512-56" | "skein512-64" | "skein512-72" | "skein512-80" | "skein512-88" | "skein512-96" | "skein512-104" | "skein512-112" | "skein512-120" | "skein512-128" | "skein512-136" | "skein512-144" | "skein512-152" | "skein512-160" | "skein512-168" | "skein512-176" | "skein512-184" | "skein512-192" | "skein512-200" | "skein512-208" | "skein512-216" | "skein512-224" | "skein512-232" | "skein512-240" | "skein512-248" | "skein512-256" | "skein512-264" | "skein512-272" | "skein512-280" | "skein512-288" | "skein512-296" | "skein512-304" | "skein512-312" | "skein512-320" | "skein512-328" | "skein512-336" | "skein512-344" | "skein512-352" | "skein512-360" | "skein512-368" | "skein512-376" | "skein512-384" | "skein512-392" | "skein512-400" | "skein512-408" | "skein512-416" | "skein512-424" | "skein512-432" | "skein512-440" | "skein512-448" | "skein512-456" | "skein512-464" | "skein512-472" | "skein512-480" | "skein512-488" | "skein512-496" | "skein512-504" | "skein512-512" | "skein1024-8" | "skein1024-16" | "skein1024-24" | "skein1024-32" | "skein1024-40" | "skein1024-48" | "skein1024-56" | "skein1024-64" | "skein1024-72" | "skein1024-80" | "skein1024-88" | "skein1024-96" | "skein1024-104" | "skein1024-112" | "skein1024-120" | "skein1024-128" | "skein1024-136" | "skein1024-144" | "skein1024-152" | "skein1024-160" | "skein1024-168" | "skein1024-176" | "skein1024-184" | "skein1024-192" | "skein1024-200" | "skein1024-208" | "skein1024-216" | "skein1024-224" | "skein1024-232" | "skein1024-240" | "skein1024-248" | "skein1024-256" | "skein1024-264" | "skein1024-272" | "skein1024-280" | "skein1024-288" | "skein1024-296" | "skein1024-304" | "skein1024-312" | "skein1024-320" | "skein1024-328" | "skein1024-336" | "skein1024-344" | "skein1024-352" | "skein1024-360" | "skein1024-368" | "skein1024-376" | "skein1024-384" | "skein1024-392" | "skein1024-400" | "skein1024-408" | "skein1024-416" | "skein1024-424" | "skein1024-432" | "skein1024-440" | "skein1024-448" | "skein1024-456" | "skein1024-464" | "skein1024-472" | "skein1024-480" | "skein1024-488" | "skein1024-496" | "skein1024-504" | "skein1024-512" | "skein1024-520" | "skein1024-528" | "skein1024-536" | "skein1024-544" | "skein1024-552" | "skein1024-560" | "skein1024-568" | "skein1024-576" | "skein1024-584" | "skein1024-592" | "skein1024-600" | "skein1024-608" | "skein1024-616" | "skein1024-624" | "skein1024-632" | "skein1024-640" | "skein1024-648" | "skein1024-656" | "skein1024-664" | "skein1024-672" | "skein1024-680" | "skein1024-688" | "skein1024-696" | "skein1024-704" | "skein1024-712" | "skein1024-720" | "skein1024-728" | "skein1024-736" | "skein1024-744" | "skein1024-752" | "skein1024-760" | "skein1024-768" | "skein1024-776" | "skein1024-784" | "skein1024-792" | "skein1024-800" | "skein1024-808" | "skein1024-816" | "skein1024-824" | "skein1024-832" | "skein1024-840" | "skein1024-848" | "skein1024-856" | "skein1024-864" | "skein1024-872" | "skein1024-880" | "skein1024-888" | "skein1024-896" | "skein1024-904" | "skein1024-912" | "skein1024-920" | "skein1024-928" | "skein1024-936" | "skein1024-944" | "skein1024-952" | "skein1024-960" | "skein1024-968" | "skein1024-976" | "skein1024-984" | "skein1024-992" | "skein1024-1000" | "skein1024-1008" | "skein1024-1016" | "skein1024-1024" | "poseidon-bls12_381-a2-fc1" | "poseidon-bls12_381-a2-fc1-sc" } HashName
 */
/**
 * Codes for all available hashes
 *
 * @typedef { 0x00 | 0x11 | 0x12 | 0x13 | 0x14 | 0x15 | 0x16 | 0x17 | 0x18 | 0x19 | 0x1a | 0x1b | 0x1c | 0x1d | 0x1e | 0x22 | 0x23 | 0x56 | 0xd4 | 0xd5 | 0xd6 | 0x1012 | 0x1052 | 0x1053 | 0x1054 | 0x1055 | 0x1100 | 0x1d01 | 0x534d | 0xb201 | 0xb202 | 0xb203 | 0xb204 | 0xb205 | 0xb206 | 0xb207 | 0xb208 | 0xb209 | 0xb20a | 0xb20b | 0xb20c | 0xb20d | 0xb20e | 0xb20f | 0xb210 | 0xb211 | 0xb212 | 0xb213 | 0xb214 | 0xb215 | 0xb216 | 0xb217 | 0xb218 | 0xb219 | 0xb21a | 0xb21b | 0xb21c | 0xb21d | 0xb21e | 0xb21f | 0xb220 | 0xb221 | 0xb222 | 0xb223 | 0xb224 | 0xb225 | 0xb226 | 0xb227 | 0xb228 | 0xb229 | 0xb22a | 0xb22b | 0xb22c | 0xb22d | 0xb22e | 0xb22f | 0xb230 | 0xb231 | 0xb232 | 0xb233 | 0xb234 | 0xb235 | 0xb236 | 0xb237 | 0xb238 | 0xb239 | 0xb23a | 0xb23b | 0xb23c | 0xb23d | 0xb23e | 0xb23f | 0xb240 | 0xb241 | 0xb242 | 0xb243 | 0xb244 | 0xb245 | 0xb246 | 0xb247 | 0xb248 | 0xb249 | 0xb24a | 0xb24b | 0xb24c | 0xb24d | 0xb24e | 0xb24f | 0xb250 | 0xb251 | 0xb252 | 0xb253 | 0xb254 | 0xb255 | 0xb256 | 0xb257 | 0xb258 | 0xb259 | 0xb25a | 0xb25b | 0xb25c | 0xb25d | 0xb25e | 0xb25f | 0xb260 | 0xb301 | 0xb302 | 0xb303 | 0xb304 | 0xb305 | 0xb306 | 0xb307 | 0xb308 | 0xb309 | 0xb30a | 0xb30b | 0xb30c | 0xb30d | 0xb30e | 0xb30f | 0xb310 | 0xb311 | 0xb312 | 0xb313 | 0xb314 | 0xb315 | 0xb316 | 0xb317 | 0xb318 | 0xb319 | 0xb31a | 0xb31b | 0xb31c | 0xb31d | 0xb31e | 0xb31f | 0xb320 | 0xb321 | 0xb322 | 0xb323 | 0xb324 | 0xb325 | 0xb326 | 0xb327 | 0xb328 | 0xb329 | 0xb32a | 0xb32b | 0xb32c | 0xb32d | 0xb32e | 0xb32f | 0xb330 | 0xb331 | 0xb332 | 0xb333 | 0xb334 | 0xb335 | 0xb336 | 0xb337 | 0xb338 | 0xb339 | 0xb33a | 0xb33b | 0xb33c | 0xb33d | 0xb33e | 0xb33f | 0xb340 | 0xb341 | 0xb342 | 0xb343 | 0xb344 | 0xb345 | 0xb346 | 0xb347 | 0xb348 | 0xb349 | 0xb34a | 0xb34b | 0xb34c | 0xb34d | 0xb34e | 0xb34f | 0xb350 | 0xb351 | 0xb352 | 0xb353 | 0xb354 | 0xb355 | 0xb356 | 0xb357 | 0xb358 | 0xb359 | 0xb35a | 0xb35b | 0xb35c | 0xb35d | 0xb35e | 0xb35f | 0xb360 | 0xb361 | 0xb362 | 0xb363 | 0xb364 | 0xb365 | 0xb366 | 0xb367 | 0xb368 | 0xb369 | 0xb36a | 0xb36b | 0xb36c | 0xb36d | 0xb36e | 0xb36f | 0xb370 | 0xb371 | 0xb372 | 0xb373 | 0xb374 | 0xb375 | 0xb376 | 0xb377 | 0xb378 | 0xb379 | 0xb37a | 0xb37b | 0xb37c | 0xb37d | 0xb37e | 0xb37f | 0xb380 | 0xb381 | 0xb382 | 0xb383 | 0xb384 | 0xb385 | 0xb386 | 0xb387 | 0xb388 | 0xb389 | 0xb38a | 0xb38b | 0xb38c | 0xb38d | 0xb38e | 0xb38f | 0xb390 | 0xb391 | 0xb392 | 0xb393 | 0xb394 | 0xb395 | 0xb396 | 0xb397 | 0xb398 | 0xb399 | 0xb39a | 0xb39b | 0xb39c | 0xb39d | 0xb39e | 0xb39f | 0xb3a0 | 0xb3a1 | 0xb3a2 | 0xb3a3 | 0xb3a4 | 0xb3a5 | 0xb3a6 | 0xb3a7 | 0xb3a8 | 0xb3a9 | 0xb3aa | 0xb3ab | 0xb3ac | 0xb3ad | 0xb3ae | 0xb3af | 0xb3b0 | 0xb3b1 | 0xb3b2 | 0xb3b3 | 0xb3b4 | 0xb3b5 | 0xb3b6 | 0xb3b7 | 0xb3b8 | 0xb3b9 | 0xb3ba | 0xb3bb | 0xb3bc | 0xb3bd | 0xb3be | 0xb3bf | 0xb3c0 | 0xb3c1 | 0xb3c2 | 0xb3c3 | 0xb3c4 | 0xb3c5 | 0xb3c6 | 0xb3c7 | 0xb3c8 | 0xb3c9 | 0xb3ca | 0xb3cb | 0xb3cc | 0xb3cd | 0xb3ce | 0xb3cf | 0xb3d0 | 0xb3d1 | 0xb3d2 | 0xb3d3 | 0xb3d4 | 0xb3d5 | 0xb3d6 | 0xb3d7 | 0xb3d8 | 0xb3d9 | 0xb3da | 0xb3db | 0xb3dc | 0xb3dd | 0xb3de | 0xb3df | 0xb3e0 | 0xb401 | 0xb402 } HashCode
 */

/**
 * @type { Record<HashName,HashCode> }
 */
const names = Object.freeze({
  'identity': 0x00,
  'sha1': 0x11,
  'sha2-256': 0x12,
  'sha2-512': 0x13,
  'sha3-512': 0x14,
  'sha3-384': 0x15,
  'sha3-256': 0x16,
  'sha3-224': 0x17,
  'shake-128': 0x18,
  'shake-256': 0x19,
  'keccak-224': 0x1a,
  'keccak-256': 0x1b,
  'keccak-384': 0x1c,
  'keccak-512': 0x1d,
  'blake3': 0x1e,
  'murmur3-128': 0x22,
  'murmur3-32': 0x23,
  'dbl-sha2-256': 0x56,
  'md4': 0xd4,
  'md5': 0xd5,
  'bmt': 0xd6,
  'sha2-256-trunc254-padded': 0x1012,
  'ripemd-128': 0x1052,
  'ripemd-160': 0x1053,
  'ripemd-256': 0x1054,
  'ripemd-320': 0x1055,
  'x11': 0x1100,
  'kangarootwelve': 0x1d01,
  'sm3-256': 0x534d,
  'blake2b-8': 0xb201,
  'blake2b-16': 0xb202,
  'blake2b-24': 0xb203,
  'blake2b-32': 0xb204,
  'blake2b-40': 0xb205,
  'blake2b-48': 0xb206,
  'blake2b-56': 0xb207,
  'blake2b-64': 0xb208,
  'blake2b-72': 0xb209,
  'blake2b-80': 0xb20a,
  'blake2b-88': 0xb20b,
  'blake2b-96': 0xb20c,
  'blake2b-104': 0xb20d,
  'blake2b-112': 0xb20e,
  'blake2b-120': 0xb20f,
  'blake2b-128': 0xb210,
  'blake2b-136': 0xb211,
  'blake2b-144': 0xb212,
  'blake2b-152': 0xb213,
  'blake2b-160': 0xb214,
  'blake2b-168': 0xb215,
  'blake2b-176': 0xb216,
  'blake2b-184': 0xb217,
  'blake2b-192': 0xb218,
  'blake2b-200': 0xb219,
  'blake2b-208': 0xb21a,
  'blake2b-216': 0xb21b,
  'blake2b-224': 0xb21c,
  'blake2b-232': 0xb21d,
  'blake2b-240': 0xb21e,
  'blake2b-248': 0xb21f,
  'blake2b-256': 0xb220,
  'blake2b-264': 0xb221,
  'blake2b-272': 0xb222,
  'blake2b-280': 0xb223,
  'blake2b-288': 0xb224,
  'blake2b-296': 0xb225,
  'blake2b-304': 0xb226,
  'blake2b-312': 0xb227,
  'blake2b-320': 0xb228,
  'blake2b-328': 0xb229,
  'blake2b-336': 0xb22a,
  'blake2b-344': 0xb22b,
  'blake2b-352': 0xb22c,
  'blake2b-360': 0xb22d,
  'blake2b-368': 0xb22e,
  'blake2b-376': 0xb22f,
  'blake2b-384': 0xb230,
  'blake2b-392': 0xb231,
  'blake2b-400': 0xb232,
  'blake2b-408': 0xb233,
  'blake2b-416': 0xb234,
  'blake2b-424': 0xb235,
  'blake2b-432': 0xb236,
  'blake2b-440': 0xb237,
  'blake2b-448': 0xb238,
  'blake2b-456': 0xb239,
  'blake2b-464': 0xb23a,
  'blake2b-472': 0xb23b,
  'blake2b-480': 0xb23c,
  'blake2b-488': 0xb23d,
  'blake2b-496': 0xb23e,
  'blake2b-504': 0xb23f,
  'blake2b-512': 0xb240,
  'blake2s-8': 0xb241,
  'blake2s-16': 0xb242,
  'blake2s-24': 0xb243,
  'blake2s-32': 0xb244,
  'blake2s-40': 0xb245,
  'blake2s-48': 0xb246,
  'blake2s-56': 0xb247,
  'blake2s-64': 0xb248,
  'blake2s-72': 0xb249,
  'blake2s-80': 0xb24a,
  'blake2s-88': 0xb24b,
  'blake2s-96': 0xb24c,
  'blake2s-104': 0xb24d,
  'blake2s-112': 0xb24e,
  'blake2s-120': 0xb24f,
  'blake2s-128': 0xb250,
  'blake2s-136': 0xb251,
  'blake2s-144': 0xb252,
  'blake2s-152': 0xb253,
  'blake2s-160': 0xb254,
  'blake2s-168': 0xb255,
  'blake2s-176': 0xb256,
  'blake2s-184': 0xb257,
  'blake2s-192': 0xb258,
  'blake2s-200': 0xb259,
  'blake2s-208': 0xb25a,
  'blake2s-216': 0xb25b,
  'blake2s-224': 0xb25c,
  'blake2s-232': 0xb25d,
  'blake2s-240': 0xb25e,
  'blake2s-248': 0xb25f,
  'blake2s-256': 0xb260,
  'skein256-8': 0xb301,
  'skein256-16': 0xb302,
  'skein256-24': 0xb303,
  'skein256-32': 0xb304,
  'skein256-40': 0xb305,
  'skein256-48': 0xb306,
  'skein256-56': 0xb307,
  'skein256-64': 0xb308,
  'skein256-72': 0xb309,
  'skein256-80': 0xb30a,
  'skein256-88': 0xb30b,
  'skein256-96': 0xb30c,
  'skein256-104': 0xb30d,
  'skein256-112': 0xb30e,
  'skein256-120': 0xb30f,
  'skein256-128': 0xb310,
  'skein256-136': 0xb311,
  'skein256-144': 0xb312,
  'skein256-152': 0xb313,
  'skein256-160': 0xb314,
  'skein256-168': 0xb315,
  'skein256-176': 0xb316,
  'skein256-184': 0xb317,
  'skein256-192': 0xb318,
  'skein256-200': 0xb319,
  'skein256-208': 0xb31a,
  'skein256-216': 0xb31b,
  'skein256-224': 0xb31c,
  'skein256-232': 0xb31d,
  'skein256-240': 0xb31e,
  'skein256-248': 0xb31f,
  'skein256-256': 0xb320,
  'skein512-8': 0xb321,
  'skein512-16': 0xb322,
  'skein512-24': 0xb323,
  'skein512-32': 0xb324,
  'skein512-40': 0xb325,
  'skein512-48': 0xb326,
  'skein512-56': 0xb327,
  'skein512-64': 0xb328,
  'skein512-72': 0xb329,
  'skein512-80': 0xb32a,
  'skein512-88': 0xb32b,
  'skein512-96': 0xb32c,
  'skein512-104': 0xb32d,
  'skein512-112': 0xb32e,
  'skein512-120': 0xb32f,
  'skein512-128': 0xb330,
  'skein512-136': 0xb331,
  'skein512-144': 0xb332,
  'skein512-152': 0xb333,
  'skein512-160': 0xb334,
  'skein512-168': 0xb335,
  'skein512-176': 0xb336,
  'skein512-184': 0xb337,
  'skein512-192': 0xb338,
  'skein512-200': 0xb339,
  'skein512-208': 0xb33a,
  'skein512-216': 0xb33b,
  'skein512-224': 0xb33c,
  'skein512-232': 0xb33d,
  'skein512-240': 0xb33e,
  'skein512-248': 0xb33f,
  'skein512-256': 0xb340,
  'skein512-264': 0xb341,
  'skein512-272': 0xb342,
  'skein512-280': 0xb343,
  'skein512-288': 0xb344,
  'skein512-296': 0xb345,
  'skein512-304': 0xb346,
  'skein512-312': 0xb347,
  'skein512-320': 0xb348,
  'skein512-328': 0xb349,
  'skein512-336': 0xb34a,
  'skein512-344': 0xb34b,
  'skein512-352': 0xb34c,
  'skein512-360': 0xb34d,
  'skein512-368': 0xb34e,
  'skein512-376': 0xb34f,
  'skein512-384': 0xb350,
  'skein512-392': 0xb351,
  'skein512-400': 0xb352,
  'skein512-408': 0xb353,
  'skein512-416': 0xb354,
  'skein512-424': 0xb355,
  'skein512-432': 0xb356,
  'skein512-440': 0xb357,
  'skein512-448': 0xb358,
  'skein512-456': 0xb359,
  'skein512-464': 0xb35a,
  'skein512-472': 0xb35b,
  'skein512-480': 0xb35c,
  'skein512-488': 0xb35d,
  'skein512-496': 0xb35e,
  'skein512-504': 0xb35f,
  'skein512-512': 0xb360,
  'skein1024-8': 0xb361,
  'skein1024-16': 0xb362,
  'skein1024-24': 0xb363,
  'skein1024-32': 0xb364,
  'skein1024-40': 0xb365,
  'skein1024-48': 0xb366,
  'skein1024-56': 0xb367,
  'skein1024-64': 0xb368,
  'skein1024-72': 0xb369,
  'skein1024-80': 0xb36a,
  'skein1024-88': 0xb36b,
  'skein1024-96': 0xb36c,
  'skein1024-104': 0xb36d,
  'skein1024-112': 0xb36e,
  'skein1024-120': 0xb36f,
  'skein1024-128': 0xb370,
  'skein1024-136': 0xb371,
  'skein1024-144': 0xb372,
  'skein1024-152': 0xb373,
  'skein1024-160': 0xb374,
  'skein1024-168': 0xb375,
  'skein1024-176': 0xb376,
  'skein1024-184': 0xb377,
  'skein1024-192': 0xb378,
  'skein1024-200': 0xb379,
  'skein1024-208': 0xb37a,
  'skein1024-216': 0xb37b,
  'skein1024-224': 0xb37c,
  'skein1024-232': 0xb37d,
  'skein1024-240': 0xb37e,
  'skein1024-248': 0xb37f,
  'skein1024-256': 0xb380,
  'skein1024-264': 0xb381,
  'skein1024-272': 0xb382,
  'skein1024-280': 0xb383,
  'skein1024-288': 0xb384,
  'skein1024-296': 0xb385,
  'skein1024-304': 0xb386,
  'skein1024-312': 0xb387,
  'skein1024-320': 0xb388,
  'skein1024-328': 0xb389,
  'skein1024-336': 0xb38a,
  'skein1024-344': 0xb38b,
  'skein1024-352': 0xb38c,
  'skein1024-360': 0xb38d,
  'skein1024-368': 0xb38e,
  'skein1024-376': 0xb38f,
  'skein1024-384': 0xb390,
  'skein1024-392': 0xb391,
  'skein1024-400': 0xb392,
  'skein1024-408': 0xb393,
  'skein1024-416': 0xb394,
  'skein1024-424': 0xb395,
  'skein1024-432': 0xb396,
  'skein1024-440': 0xb397,
  'skein1024-448': 0xb398,
  'skein1024-456': 0xb399,
  'skein1024-464': 0xb39a,
  'skein1024-472': 0xb39b,
  'skein1024-480': 0xb39c,
  'skein1024-488': 0xb39d,
  'skein1024-496': 0xb39e,
  'skein1024-504': 0xb39f,
  'skein1024-512': 0xb3a0,
  'skein1024-520': 0xb3a1,
  'skein1024-528': 0xb3a2,
  'skein1024-536': 0xb3a3,
  'skein1024-544': 0xb3a4,
  'skein1024-552': 0xb3a5,
  'skein1024-560': 0xb3a6,
  'skein1024-568': 0xb3a7,
  'skein1024-576': 0xb3a8,
  'skein1024-584': 0xb3a9,
  'skein1024-592': 0xb3aa,
  'skein1024-600': 0xb3ab,
  'skein1024-608': 0xb3ac,
  'skein1024-616': 0xb3ad,
  'skein1024-624': 0xb3ae,
  'skein1024-632': 0xb3af,
  'skein1024-640': 0xb3b0,
  'skein1024-648': 0xb3b1,
  'skein1024-656': 0xb3b2,
  'skein1024-664': 0xb3b3,
  'skein1024-672': 0xb3b4,
  'skein1024-680': 0xb3b5,
  'skein1024-688': 0xb3b6,
  'skein1024-696': 0xb3b7,
  'skein1024-704': 0xb3b8,
  'skein1024-712': 0xb3b9,
  'skein1024-720': 0xb3ba,
  'skein1024-728': 0xb3bb,
  'skein1024-736': 0xb3bc,
  'skein1024-744': 0xb3bd,
  'skein1024-752': 0xb3be,
  'skein1024-760': 0xb3bf,
  'skein1024-768': 0xb3c0,
  'skein1024-776': 0xb3c1,
  'skein1024-784': 0xb3c2,
  'skein1024-792': 0xb3c3,
  'skein1024-800': 0xb3c4,
  'skein1024-808': 0xb3c5,
  'skein1024-816': 0xb3c6,
  'skein1024-824': 0xb3c7,
  'skein1024-832': 0xb3c8,
  'skein1024-840': 0xb3c9,
  'skein1024-848': 0xb3ca,
  'skein1024-856': 0xb3cb,
  'skein1024-864': 0xb3cc,
  'skein1024-872': 0xb3cd,
  'skein1024-880': 0xb3ce,
  'skein1024-888': 0xb3cf,
  'skein1024-896': 0xb3d0,
  'skein1024-904': 0xb3d1,
  'skein1024-912': 0xb3d2,
  'skein1024-920': 0xb3d3,
  'skein1024-928': 0xb3d4,
  'skein1024-936': 0xb3d5,
  'skein1024-944': 0xb3d6,
  'skein1024-952': 0xb3d7,
  'skein1024-960': 0xb3d8,
  'skein1024-968': 0xb3d9,
  'skein1024-976': 0xb3da,
  'skein1024-984': 0xb3db,
  'skein1024-992': 0xb3dc,
  'skein1024-1000': 0xb3dd,
  'skein1024-1008': 0xb3de,
  'skein1024-1016': 0xb3df,
  'skein1024-1024': 0xb3e0,
  'poseidon-bls12_381-a2-fc1': 0xb401,
  'poseidon-bls12_381-a2-fc1-sc': 0xb402
})

module.exports = { names }

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>cids>multihashes",file:"node_modules\\multihashes\\src\\constants.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\multihashes\\src\\index.js", {"./constants":"D:\\code\\v\\metamask-extension\\node_modules\\multihashes\\src\\constants.js","multibase":"D:\\code\\v\\metamask-extension\\node_modules\\multibase\\src\\index.js","uint8arrays/concat":"D:\\code\\v\\metamask-extension\\node_modules\\multihashes\\node_modules\\uint8arrays\\concat.js","uint8arrays/from-string":"D:\\code\\v\\metamask-extension\\node_modules\\multihashes\\node_modules\\uint8arrays\\from-string.js","uint8arrays/to-string":"D:\\code\\v\\metamask-extension\\node_modules\\multihashes\\node_modules\\uint8arrays\\to-string.js","varint":"D:\\code\\v\\metamask-extension\\node_modules\\multihashes\\node_modules\\varint\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cmultihashes%5Csrc%5Cindex.js
      return function (require, module, exports) {
/**
 * Multihash implementation in JavaScript.
 */
'use strict'

const multibase = require('multibase')
const varint = require('varint')
const { names } = require('./constants')
const uint8ArrayToString = require('uint8arrays/to-string')
const uint8ArrayFromString = require('uint8arrays/from-string')
const uint8ArrayConcat = require('uint8arrays/concat')

const codes = /** @type {__import__('./types').CodeNameMap} */({})

// eslint-disable-next-line guard-for-in
for (const key in names) {
  const name = /** @type {HashName} */(key)
  codes[names[name]] = name
}
Object.freeze(codes)

/**
 * Convert the given multihash to a hex encoded string.
 *
 * @param {Uint8Array} hash
 * @returns {string}
 */
function toHexString (hash) {
  if (!(hash instanceof Uint8Array)) {
    throw new Error('must be passed a Uint8Array')
  }

  return uint8ArrayToString(hash, 'base16')
}

/**
 * Convert the given hex encoded string to a multihash.
 *
 * @param {string} hash
 * @returns {Uint8Array}
 */
function fromHexString (hash) {
  return uint8ArrayFromString(hash, 'base16')
}

/**
 * Convert the given multihash to a base58 encoded string.
 *
 * @param {Uint8Array} hash
 * @returns {string}
 */
function toB58String (hash) {
  if (!(hash instanceof Uint8Array)) {
    throw new Error('must be passed a Uint8Array')
  }

  return uint8ArrayToString(multibase.encode('base58btc', hash)).slice(1)
}

/**
 * Convert the given base58 encoded string to a multihash.
 *
 * @param {string|Uint8Array} hash
 * @returns {Uint8Array}
 */
function fromB58String (hash) {
  const encoded = hash instanceof Uint8Array
    ? uint8ArrayToString(hash)
    : hash

  return multibase.decode('z' + encoded)
}

/**
 * Decode a hash from the given multihash.
 *
 * @param {Uint8Array} bytes
 * @returns {{code: HashCode, name: HashName, length: number, digest: Uint8Array}} result
 */
function decode (bytes) {
  if (!(bytes instanceof Uint8Array)) {
    throw new Error('multihash must be a Uint8Array')
  }

  if (bytes.length < 2) {
    throw new Error('multihash too short. must be > 2 bytes.')
  }

  const code = /** @type {HashCode} */(varint.decode(bytes))
  if (!isValidCode(code)) {
    throw new Error(`multihash unknown function code: 0x${code.toString(16)}`)
  }
  bytes = bytes.slice(varint.decode.bytes)

  const len = varint.decode(bytes)
  if (len < 0) {
    throw new Error(`multihash invalid length: ${len}`)
  }
  bytes = bytes.slice(varint.decode.bytes)

  if (bytes.length !== len) {
    throw new Error(`multihash length inconsistent: 0x${uint8ArrayToString(bytes, 'base16')}`)
  }

  return {
    code,
    name: codes[code],
    length: len,
    digest: bytes
  }
}

/**
 * Encode a hash digest along with the specified function code.
 *
 * > **Note:** the length is derived from the length of the digest itself.
 *
 * @param {Uint8Array} digest
 * @param {HashName | HashCode} code
 * @param {number} [length]
 * @returns {Uint8Array}
 */
function encode (digest, code, length) {
  if (!digest || code === undefined) {
    throw new Error('multihash encode requires at least two args: digest, code')
  }

  // ensure it's a hashfunction code.
  const hashfn = coerceCode(code)

  if (!(digest instanceof Uint8Array)) {
    throw new Error('digest should be a Uint8Array')
  }

  if (length == null) {
    length = digest.length
  }

  if (length && digest.length !== length) {
    throw new Error('digest length should be equal to specified length.')
  }

  const hash = varint.encode(hashfn)
  const len = varint.encode(length)
  return uint8ArrayConcat([hash, len, digest], hash.length + len.length + digest.length)
}

/**
 * Converts a hash function name into the matching code.
 * If passed a number it will return the number if it's a valid code.
 *
 * @param {HashName | number} name
 * @returns {number}
 */
function coerceCode (name) {
  let code = name

  if (typeof name === 'string') {
    if (names[name] === undefined) {
      throw new Error(`Unrecognized hash function named: ${name}`)
    }
    code = names[name]
  }

  if (typeof code !== 'number') {
    throw new Error(`Hash function code should be a number. Got: ${code}`)
  }

  // @ts-ignore
  if (codes[code] === undefined && !isAppCode(code)) {
    throw new Error(`Unrecognized function code: ${code}`)
  }

  return code
}

/**
 * Checks if a code is part of the app range
 *
 * @param {number} code
 * @returns {boolean}
 */
function isAppCode (code) {
  return code > 0 && code < 0x10
}

/**
 * Checks whether a multihash code is valid.
 *
 * @param {HashCode} code
 * @returns {boolean}
 */
function isValidCode (code) {
  if (isAppCode(code)) {
    return true
  }

  if (codes[code]) {
    return true
  }

  return false
}

/**
 * Check if the given buffer is a valid multihash. Throws an error if it is not valid.
 *
 * @param {Uint8Array} multihash
 * @returns {void}
 * @throws {Error}
 */
function validate (multihash) {
  decode(multihash) // throws if bad.
}

/**
 * Returns a prefix from a valid multihash. Throws an error if it is not valid.
 *
 * @param {Uint8Array} multihash
 * @returns {Uint8Array}
 * @throws {Error}
 */
function prefix (multihash) {
  validate(multihash)

  return multihash.subarray(0, 2)
}

module.exports = {
  names,
  codes,
  toHexString,
  fromHexString,
  toB58String,
  fromB58String,
  decode,
  encode,
  coerceCode,
  isAppCode,
  validate,
  prefix,
  isValidCode
}

/**
 * @typedef { __import__("./constants").HashCode } HashCode
 * @typedef { __import__("./constants").HashName } HashName
 */

      };
    };
  }
  }
}, {package:"@ensdomains/content-hash>cids>multihashes",file:"node_modules\\multihashes\\src\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\pify\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cpify%5Cindex.js
      return function (require, module, exports) {
'use strict';

const processFn = (fn, options, proxy, unwrapped) => function (...arguments_) {
	const P = options.promiseModule;

	return new P((resolve, reject) => {
		if (options.multiArgs) {
			arguments_.push((...result) => {
				if (options.errorFirst) {
					if (result[0]) {
						reject(result);
					} else {
						result.shift();
						resolve(result);
					}
				} else {
					resolve(result);
				}
			});
		} else if (options.errorFirst) {
			arguments_.push((error, result) => {
				if (error) {
					reject(error);
				} else {
					resolve(result);
				}
			});
		} else {
			arguments_.push(resolve);
		}

		const self = this === proxy ? unwrapped : this;
		Reflect.apply(fn, self, arguments_);
	});
};

const filterCache = new WeakMap();

module.exports = (input, options) => {
	options = {
		exclude: [/.+(?:Sync|Stream)$/],
		errorFirst: true,
		promiseModule: Promise,
		...options
	};

	const objectType = typeof input;
	if (!(input !== null && (objectType === 'object' || objectType === 'function'))) {
		throw new TypeError(`Expected \`input\` to be a \`Function\` or \`Object\`, got \`${input === null ? 'null' : objectType}\``);
	}

	const filter = (target, key) => {
		let cached = filterCache.get(target);

		if (!cached) {
			cached = {};
			filterCache.set(target, cached);
		}

		if (key in cached) {
			return cached[key];
		}

		const match = pattern => (typeof pattern === 'string' || typeof key === 'symbol') ? key === pattern : pattern.test(key);
		const desc = Reflect.getOwnPropertyDescriptor(target, key);
		const writableOrConfigurableOwn = (desc === undefined || desc.writable || desc.configurable);
		const included = options.include ? options.include.some(match) : !options.exclude.some(match);
		const shouldFilter = included && writableOrConfigurableOwn;
		cached[key] = shouldFilter;
		return shouldFilter;
	};

	const cache = new WeakMap();

	const proxy = new Proxy(input, {
		apply(target, thisArg, args) {
			const cached = cache.get(target);

			if (cached) {
				return Reflect.apply(cached, thisArg, args);
			}

			const pified = options.excludeMain ? target : processFn(target, options, proxy, target);
			cache.set(target, pified);
			return Reflect.apply(pified, thisArg, args);
		},

		get(target, key) {
			const property = target[key];

			// eslint-disable-next-line no-use-extend-native/no-use-extend-native
			if (!filter(target, key) || property === Function.prototype[key]) {
				return property;
			}

			const cached = cache.get(property);

			if (cached) {
				return cached;
			}

			if (typeof property === 'function') {
				const pified = processFn(property, options, proxy, target);
				cache.set(property, pified);
				return pified;
			}

			return property;
		}
	});

	return proxy;
};

      };
    };
  }
  }
}, {package:"pify",file:"node_modules\\pify\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\queue-tick\\queue-microtask.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cqueue-tick%5Cqueue-microtask.js
      return function (require, module, exports) {
module.exports = typeof queueMicrotask === 'function' ? queueMicrotask : (fn) => Promise.resolve().then(fn)

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers>tar-stream>streamx>queue-tick",file:"node_modules\\queue-tick\\queue-microtask.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\readable-web-to-node-stream\\lib\\index.js", {"readable-stream":"D:\\code\\v\\metamask-extension\\node_modules\\readable-stream\\readable-browser.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Creadable-web-to-node-stream%5Clib%5Cindex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReadableWebToNodeStream = void 0;
const readable_stream_1 = require("readable-stream");
/**
 * Converts a Web-API stream into Node stream.Readable class
 * Node stream readable: https://nodejs.org/api/stream.html#stream_readable_streams
 * Web API readable-stream: https://developer.mozilla.org/en-US/docs/Web/API/ReadableStream
 * Node readable stream: https://nodejs.org/api/stream.html#stream_readable_streams
 */
class ReadableWebToNodeStream extends readable_stream_1.Readable {
    /**
     *
     * @param stream Readable​Stream: https://developer.mozilla.org/en-US/docs/Web/API/ReadableStream
     */
    constructor(stream) {
        super();
        this.bytesRead = 0;
        this.released = false;
        this.reader = stream.getReader();
    }
    /**
     * Implementation of readable._read(size).
     * When readable._read() is called, if data is available from the resource,
     * the implementation should begin pushing that data into the read queue
     * https://nodejs.org/api/stream.html#stream_readable_read_size_1
     */
    async _read() {
        // Should start pushing data into the queue
        // Read data from the underlying Web-API-readable-stream
        if (this.released) {
            this.push(null); // Signal EOF
            return;
        }
        this.pendingRead = this.reader.read();
        const data = await this.pendingRead;
        // clear the promise before pushing pushing new data to the queue and allow sequential calls to _read()
        delete this.pendingRead;
        if (data.done || this.released) {
            this.push(null); // Signal EOF
        }
        else {
            this.bytesRead += data.value.length;
            this.push(data.value); // Push new data to the queue
        }
    }
    /**
     * If there is no unresolved read call to Web-API Readable​Stream immediately returns;
     * otherwise will wait until the read is resolved.
     */
    async waitForReadToComplete() {
        if (this.pendingRead) {
            await this.pendingRead;
        }
    }
    /**
     * Close wrapper
     */
    async close() {
        await this.syncAndRelease();
    }
    async syncAndRelease() {
        this.released = true;
        await this.waitForReadToComplete();
        await this.reader.releaseLock();
    }
}
exports.ReadableWebToNodeStream = ReadableWebToNodeStream;

      };
    };
  }
  }
}, {package:"@metamask/snaps-controllers>readable-web-to-node-stream",file:"node_modules\\readable-web-to-node-stream\\lib\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\remove-trailing-slash\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Cremove-trailing-slash%5Cindex.js
      return function (require, module, exports) {

/**
 * Remove trailing slashes from the given `str`
 *
 * @api public
 * @param {String} str
 * @return {String}
 */
exports = module.exports = function (str) {
  return String(str).replace(exports.expr, '');
};

/**
 * Expose the regex
 *
 * @api private
 * @type {RegExp}
 */
exports.expr = /\/+$/;

      };
    };
  }
  }
}, {package:"remove-trailing-slash",file:"node_modules\\remove-trailing-slash\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\index.js", {"./internal/AsyncSubject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\AsyncSubject.js","./internal/BehaviorSubject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\BehaviorSubject.js","./internal/Notification":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Notification.js","./internal/Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","./internal/ReplaySubject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\ReplaySubject.js","./internal/Scheduler":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Scheduler.js","./internal/Subject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subject.js","./internal/Subscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subscriber.js","./internal/Subscription":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subscription.js","./internal/config":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\config.js","./internal/firstValueFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\firstValueFrom.js","./internal/lastValueFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\lastValueFrom.js","./internal/observable/ConnectableObservable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\ConnectableObservable.js","./internal/observable/bindCallback":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\bindCallback.js","./internal/observable/bindNodeCallback":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\bindNodeCallback.js","./internal/observable/combineLatest":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\combineLatest.js","./internal/observable/concat":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\concat.js","./internal/observable/connectable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\connectable.js","./internal/observable/defer":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\defer.js","./internal/observable/dom/animationFrames":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\dom\\animationFrames.js","./internal/observable/empty":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\empty.js","./internal/observable/forkJoin":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\forkJoin.js","./internal/observable/from":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\from.js","./internal/observable/fromEvent":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\fromEvent.js","./internal/observable/fromEventPattern":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\fromEventPattern.js","./internal/observable/generate":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\generate.js","./internal/observable/iif":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\iif.js","./internal/observable/interval":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\interval.js","./internal/observable/merge":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\merge.js","./internal/observable/never":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\never.js","./internal/observable/of":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\of.js","./internal/observable/onErrorResumeNext":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\onErrorResumeNext.js","./internal/observable/pairs":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\pairs.js","./internal/observable/partition":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\partition.js","./internal/observable/race":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\race.js","./internal/observable/range":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\range.js","./internal/observable/throwError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\throwError.js","./internal/observable/timer":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\timer.js","./internal/observable/using":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\using.js","./internal/observable/zip":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\zip.js","./internal/operators/audit":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\audit.js","./internal/operators/auditTime":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\auditTime.js","./internal/operators/buffer":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\buffer.js","./internal/operators/bufferCount":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\bufferCount.js","./internal/operators/bufferTime":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\bufferTime.js","./internal/operators/bufferToggle":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\bufferToggle.js","./internal/operators/bufferWhen":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\bufferWhen.js","./internal/operators/catchError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\catchError.js","./internal/operators/combineAll":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\combineAll.js","./internal/operators/combineLatestAll":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\combineLatestAll.js","./internal/operators/combineLatestWith":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\combineLatestWith.js","./internal/operators/concatAll":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\concatAll.js","./internal/operators/concatMap":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\concatMap.js","./internal/operators/concatMapTo":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\concatMapTo.js","./internal/operators/concatWith":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\concatWith.js","./internal/operators/connect":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\connect.js","./internal/operators/count":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\count.js","./internal/operators/debounce":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\debounce.js","./internal/operators/debounceTime":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\debounceTime.js","./internal/operators/defaultIfEmpty":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\defaultIfEmpty.js","./internal/operators/delay":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\delay.js","./internal/operators/delayWhen":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\delayWhen.js","./internal/operators/dematerialize":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\dematerialize.js","./internal/operators/distinct":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\distinct.js","./internal/operators/distinctUntilChanged":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\distinctUntilChanged.js","./internal/operators/distinctUntilKeyChanged":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\distinctUntilKeyChanged.js","./internal/operators/elementAt":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\elementAt.js","./internal/operators/endWith":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\endWith.js","./internal/operators/every":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\every.js","./internal/operators/exhaust":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\exhaust.js","./internal/operators/exhaustAll":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\exhaustAll.js","./internal/operators/exhaustMap":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\exhaustMap.js","./internal/operators/expand":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\expand.js","./internal/operators/filter":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\filter.js","./internal/operators/finalize":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\finalize.js","./internal/operators/find":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\find.js","./internal/operators/findIndex":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\findIndex.js","./internal/operators/first":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\first.js","./internal/operators/flatMap":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\flatMap.js","./internal/operators/groupBy":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\groupBy.js","./internal/operators/ignoreElements":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\ignoreElements.js","./internal/operators/isEmpty":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\isEmpty.js","./internal/operators/last":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\last.js","./internal/operators/map":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\map.js","./internal/operators/mapTo":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mapTo.js","./internal/operators/materialize":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\materialize.js","./internal/operators/max":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\max.js","./internal/operators/mergeAll":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeAll.js","./internal/operators/mergeMap":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeMap.js","./internal/operators/mergeMapTo":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeMapTo.js","./internal/operators/mergeScan":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeScan.js","./internal/operators/mergeWith":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeWith.js","./internal/operators/min":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\min.js","./internal/operators/multicast":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\multicast.js","./internal/operators/observeOn":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\observeOn.js","./internal/operators/onErrorResumeNextWith":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\onErrorResumeNextWith.js","./internal/operators/pairwise":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\pairwise.js","./internal/operators/pluck":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\pluck.js","./internal/operators/publish":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\publish.js","./internal/operators/publishBehavior":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\publishBehavior.js","./internal/operators/publishLast":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\publishLast.js","./internal/operators/publishReplay":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\publishReplay.js","./internal/operators/raceWith":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\raceWith.js","./internal/operators/reduce":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\reduce.js","./internal/operators/refCount":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\refCount.js","./internal/operators/repeat":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\repeat.js","./internal/operators/repeatWhen":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\repeatWhen.js","./internal/operators/retry":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\retry.js","./internal/operators/retryWhen":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\retryWhen.js","./internal/operators/sample":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\sample.js","./internal/operators/sampleTime":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\sampleTime.js","./internal/operators/scan":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\scan.js","./internal/operators/sequenceEqual":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\sequenceEqual.js","./internal/operators/share":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\share.js","./internal/operators/shareReplay":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\shareReplay.js","./internal/operators/single":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\single.js","./internal/operators/skip":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\skip.js","./internal/operators/skipLast":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\skipLast.js","./internal/operators/skipUntil":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\skipUntil.js","./internal/operators/skipWhile":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\skipWhile.js","./internal/operators/startWith":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\startWith.js","./internal/operators/subscribeOn":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\subscribeOn.js","./internal/operators/switchAll":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\switchAll.js","./internal/operators/switchMap":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\switchMap.js","./internal/operators/switchMapTo":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\switchMapTo.js","./internal/operators/switchScan":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\switchScan.js","./internal/operators/take":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\take.js","./internal/operators/takeLast":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\takeLast.js","./internal/operators/takeUntil":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\takeUntil.js","./internal/operators/takeWhile":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\takeWhile.js","./internal/operators/tap":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\tap.js","./internal/operators/throttle":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\throttle.js","./internal/operators/throttleTime":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\throttleTime.js","./internal/operators/throwIfEmpty":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\throwIfEmpty.js","./internal/operators/timeInterval":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\timeInterval.js","./internal/operators/timeout":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\timeout.js","./internal/operators/timeoutWith":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\timeoutWith.js","./internal/operators/timestamp":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\timestamp.js","./internal/operators/toArray":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\toArray.js","./internal/operators/window":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\window.js","./internal/operators/windowCount":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\windowCount.js","./internal/operators/windowTime":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\windowTime.js","./internal/operators/windowToggle":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\windowToggle.js","./internal/operators/windowWhen":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\windowWhen.js","./internal/operators/withLatestFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\withLatestFrom.js","./internal/operators/zipAll":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\zipAll.js","./internal/operators/zipWith":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\zipWith.js","./internal/scheduled/scheduled":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\scheduled.js","./internal/scheduler/VirtualTimeScheduler":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\VirtualTimeScheduler.js","./internal/scheduler/animationFrame":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\animationFrame.js","./internal/scheduler/asap":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\asap.js","./internal/scheduler/async":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\async.js","./internal/scheduler/queue":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\queue.js","./internal/symbol/observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\symbol\\observable.js","./internal/types":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\types.js","./internal/util/ArgumentOutOfRangeError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\ArgumentOutOfRangeError.js","./internal/util/EmptyError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\EmptyError.js","./internal/util/NotFoundError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\NotFoundError.js","./internal/util/ObjectUnsubscribedError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\ObjectUnsubscribedError.js","./internal/util/SequenceError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\SequenceError.js","./internal/util/UnsubscriptionError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\UnsubscriptionError.js","./internal/util/identity":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\identity.js","./internal/util/isObservable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isObservable.js","./internal/util/noop":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\noop.js","./internal/util/pipe":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\pipe.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cindex.js
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.interval = exports.iif = exports.generate = exports.fromEventPattern = exports.fromEvent = exports.from = exports.forkJoin = exports.empty = exports.defer = exports.connectable = exports.concat = exports.combineLatest = exports.bindNodeCallback = exports.bindCallback = exports.UnsubscriptionError = exports.TimeoutError = exports.SequenceError = exports.ObjectUnsubscribedError = exports.NotFoundError = exports.EmptyError = exports.ArgumentOutOfRangeError = exports.firstValueFrom = exports.lastValueFrom = exports.isObservable = exports.identity = exports.noop = exports.pipe = exports.NotificationKind = exports.Notification = exports.Subscriber = exports.Subscription = exports.Scheduler = exports.VirtualAction = exports.VirtualTimeScheduler = exports.animationFrameScheduler = exports.animationFrame = exports.queueScheduler = exports.queue = exports.asyncScheduler = exports.async = exports.asapScheduler = exports.asap = exports.AsyncSubject = exports.ReplaySubject = exports.BehaviorSubject = exports.Subject = exports.animationFrames = exports.observable = exports.ConnectableObservable = exports.Observable = void 0;
exports.filter = exports.expand = exports.exhaustMap = exports.exhaustAll = exports.exhaust = exports.every = exports.endWith = exports.elementAt = exports.distinctUntilKeyChanged = exports.distinctUntilChanged = exports.distinct = exports.dematerialize = exports.delayWhen = exports.delay = exports.defaultIfEmpty = exports.debounceTime = exports.debounce = exports.count = exports.connect = exports.concatWith = exports.concatMapTo = exports.concatMap = exports.concatAll = exports.combineLatestWith = exports.combineLatestAll = exports.combineAll = exports.catchError = exports.bufferWhen = exports.bufferToggle = exports.bufferTime = exports.bufferCount = exports.buffer = exports.auditTime = exports.audit = exports.config = exports.NEVER = exports.EMPTY = exports.scheduled = exports.zip = exports.using = exports.timer = exports.throwError = exports.range = exports.race = exports.partition = exports.pairs = exports.onErrorResumeNext = exports.of = exports.never = exports.merge = void 0;
exports.switchMap = exports.switchAll = exports.subscribeOn = exports.startWith = exports.skipWhile = exports.skipUntil = exports.skipLast = exports.skip = exports.single = exports.shareReplay = exports.share = exports.sequenceEqual = exports.scan = exports.sampleTime = exports.sample = exports.refCount = exports.retryWhen = exports.retry = exports.repeatWhen = exports.repeat = exports.reduce = exports.raceWith = exports.publishReplay = exports.publishLast = exports.publishBehavior = exports.publish = exports.pluck = exports.pairwise = exports.onErrorResumeNextWith = exports.observeOn = exports.multicast = exports.min = exports.mergeWith = exports.mergeScan = exports.mergeMapTo = exports.mergeMap = exports.flatMap = exports.mergeAll = exports.max = exports.materialize = exports.mapTo = exports.map = exports.last = exports.isEmpty = exports.ignoreElements = exports.groupBy = exports.first = exports.findIndex = exports.find = exports.finalize = void 0;
exports.zipWith = exports.zipAll = exports.withLatestFrom = exports.windowWhen = exports.windowToggle = exports.windowTime = exports.windowCount = exports.window = exports.toArray = exports.timestamp = exports.timeoutWith = exports.timeout = exports.timeInterval = exports.throwIfEmpty = exports.throttleTime = exports.throttle = exports.tap = exports.takeWhile = exports.takeUntil = exports.takeLast = exports.take = exports.switchScan = exports.switchMapTo = void 0;
var Observable_1 = require("./internal/Observable");
Object.defineProperty(exports, "Observable", { enumerable: true, get: function () { return Observable_1.Observable; } });
var ConnectableObservable_1 = require("./internal/observable/ConnectableObservable");
Object.defineProperty(exports, "ConnectableObservable", { enumerable: true, get: function () { return ConnectableObservable_1.ConnectableObservable; } });
var observable_1 = require("./internal/symbol/observable");
Object.defineProperty(exports, "observable", { enumerable: true, get: function () { return observable_1.observable; } });
var animationFrames_1 = require("./internal/observable/dom/animationFrames");
Object.defineProperty(exports, "animationFrames", { enumerable: true, get: function () { return animationFrames_1.animationFrames; } });
var Subject_1 = require("./internal/Subject");
Object.defineProperty(exports, "Subject", { enumerable: true, get: function () { return Subject_1.Subject; } });
var BehaviorSubject_1 = require("./internal/BehaviorSubject");
Object.defineProperty(exports, "BehaviorSubject", { enumerable: true, get: function () { return BehaviorSubject_1.BehaviorSubject; } });
var ReplaySubject_1 = require("./internal/ReplaySubject");
Object.defineProperty(exports, "ReplaySubject", { enumerable: true, get: function () { return ReplaySubject_1.ReplaySubject; } });
var AsyncSubject_1 = require("./internal/AsyncSubject");
Object.defineProperty(exports, "AsyncSubject", { enumerable: true, get: function () { return AsyncSubject_1.AsyncSubject; } });
var asap_1 = require("./internal/scheduler/asap");
Object.defineProperty(exports, "asap", { enumerable: true, get: function () { return asap_1.asap; } });
Object.defineProperty(exports, "asapScheduler", { enumerable: true, get: function () { return asap_1.asapScheduler; } });
var async_1 = require("./internal/scheduler/async");
Object.defineProperty(exports, "async", { enumerable: true, get: function () { return async_1.async; } });
Object.defineProperty(exports, "asyncScheduler", { enumerable: true, get: function () { return async_1.asyncScheduler; } });
var queue_1 = require("./internal/scheduler/queue");
Object.defineProperty(exports, "queue", { enumerable: true, get: function () { return queue_1.queue; } });
Object.defineProperty(exports, "queueScheduler", { enumerable: true, get: function () { return queue_1.queueScheduler; } });
var animationFrame_1 = require("./internal/scheduler/animationFrame");
Object.defineProperty(exports, "animationFrame", { enumerable: true, get: function () { return animationFrame_1.animationFrame; } });
Object.defineProperty(exports, "animationFrameScheduler", { enumerable: true, get: function () { return animationFrame_1.animationFrameScheduler; } });
var VirtualTimeScheduler_1 = require("./internal/scheduler/VirtualTimeScheduler");
Object.defineProperty(exports, "VirtualTimeScheduler", { enumerable: true, get: function () { return VirtualTimeScheduler_1.VirtualTimeScheduler; } });
Object.defineProperty(exports, "VirtualAction", { enumerable: true, get: function () { return VirtualTimeScheduler_1.VirtualAction; } });
var Scheduler_1 = require("./internal/Scheduler");
Object.defineProperty(exports, "Scheduler", { enumerable: true, get: function () { return Scheduler_1.Scheduler; } });
var Subscription_1 = require("./internal/Subscription");
Object.defineProperty(exports, "Subscription", { enumerable: true, get: function () { return Subscription_1.Subscription; } });
var Subscriber_1 = require("./internal/Subscriber");
Object.defineProperty(exports, "Subscriber", { enumerable: true, get: function () { return Subscriber_1.Subscriber; } });
var Notification_1 = require("./internal/Notification");
Object.defineProperty(exports, "Notification", { enumerable: true, get: function () { return Notification_1.Notification; } });
Object.defineProperty(exports, "NotificationKind", { enumerable: true, get: function () { return Notification_1.NotificationKind; } });
var pipe_1 = require("./internal/util/pipe");
Object.defineProperty(exports, "pipe", { enumerable: true, get: function () { return pipe_1.pipe; } });
var noop_1 = require("./internal/util/noop");
Object.defineProperty(exports, "noop", { enumerable: true, get: function () { return noop_1.noop; } });
var identity_1 = require("./internal/util/identity");
Object.defineProperty(exports, "identity", { enumerable: true, get: function () { return identity_1.identity; } });
var isObservable_1 = require("./internal/util/isObservable");
Object.defineProperty(exports, "isObservable", { enumerable: true, get: function () { return isObservable_1.isObservable; } });
var lastValueFrom_1 = require("./internal/lastValueFrom");
Object.defineProperty(exports, "lastValueFrom", { enumerable: true, get: function () { return lastValueFrom_1.lastValueFrom; } });
var firstValueFrom_1 = require("./internal/firstValueFrom");
Object.defineProperty(exports, "firstValueFrom", { enumerable: true, get: function () { return firstValueFrom_1.firstValueFrom; } });
var ArgumentOutOfRangeError_1 = require("./internal/util/ArgumentOutOfRangeError");
Object.defineProperty(exports, "ArgumentOutOfRangeError", { enumerable: true, get: function () { return ArgumentOutOfRangeError_1.ArgumentOutOfRangeError; } });
var EmptyError_1 = require("./internal/util/EmptyError");
Object.defineProperty(exports, "EmptyError", { enumerable: true, get: function () { return EmptyError_1.EmptyError; } });
var NotFoundError_1 = require("./internal/util/NotFoundError");
Object.defineProperty(exports, "NotFoundError", { enumerable: true, get: function () { return NotFoundError_1.NotFoundError; } });
var ObjectUnsubscribedError_1 = require("./internal/util/ObjectUnsubscribedError");
Object.defineProperty(exports, "ObjectUnsubscribedError", { enumerable: true, get: function () { return ObjectUnsubscribedError_1.ObjectUnsubscribedError; } });
var SequenceError_1 = require("./internal/util/SequenceError");
Object.defineProperty(exports, "SequenceError", { enumerable: true, get: function () { return SequenceError_1.SequenceError; } });
var timeout_1 = require("./internal/operators/timeout");
Object.defineProperty(exports, "TimeoutError", { enumerable: true, get: function () { return timeout_1.TimeoutError; } });
var UnsubscriptionError_1 = require("./internal/util/UnsubscriptionError");
Object.defineProperty(exports, "UnsubscriptionError", { enumerable: true, get: function () { return UnsubscriptionError_1.UnsubscriptionError; } });
var bindCallback_1 = require("./internal/observable/bindCallback");
Object.defineProperty(exports, "bindCallback", { enumerable: true, get: function () { return bindCallback_1.bindCallback; } });
var bindNodeCallback_1 = require("./internal/observable/bindNodeCallback");
Object.defineProperty(exports, "bindNodeCallback", { enumerable: true, get: function () { return bindNodeCallback_1.bindNodeCallback; } });
var combineLatest_1 = require("./internal/observable/combineLatest");
Object.defineProperty(exports, "combineLatest", { enumerable: true, get: function () { return combineLatest_1.combineLatest; } });
var concat_1 = require("./internal/observable/concat");
Object.defineProperty(exports, "concat", { enumerable: true, get: function () { return concat_1.concat; } });
var connectable_1 = require("./internal/observable/connectable");
Object.defineProperty(exports, "connectable", { enumerable: true, get: function () { return connectable_1.connectable; } });
var defer_1 = require("./internal/observable/defer");
Object.defineProperty(exports, "defer", { enumerable: true, get: function () { return defer_1.defer; } });
var empty_1 = require("./internal/observable/empty");
Object.defineProperty(exports, "empty", { enumerable: true, get: function () { return empty_1.empty; } });
var forkJoin_1 = require("./internal/observable/forkJoin");
Object.defineProperty(exports, "forkJoin", { enumerable: true, get: function () { return forkJoin_1.forkJoin; } });
var from_1 = require("./internal/observable/from");
Object.defineProperty(exports, "from", { enumerable: true, get: function () { return from_1.from; } });
var fromEvent_1 = require("./internal/observable/fromEvent");
Object.defineProperty(exports, "fromEvent", { enumerable: true, get: function () { return fromEvent_1.fromEvent; } });
var fromEventPattern_1 = require("./internal/observable/fromEventPattern");
Object.defineProperty(exports, "fromEventPattern", { enumerable: true, get: function () { return fromEventPattern_1.fromEventPattern; } });
var generate_1 = require("./internal/observable/generate");
Object.defineProperty(exports, "generate", { enumerable: true, get: function () { return generate_1.generate; } });
var iif_1 = require("./internal/observable/iif");
Object.defineProperty(exports, "iif", { enumerable: true, get: function () { return iif_1.iif; } });
var interval_1 = require("./internal/observable/interval");
Object.defineProperty(exports, "interval", { enumerable: true, get: function () { return interval_1.interval; } });
var merge_1 = require("./internal/observable/merge");
Object.defineProperty(exports, "merge", { enumerable: true, get: function () { return merge_1.merge; } });
var never_1 = require("./internal/observable/never");
Object.defineProperty(exports, "never", { enumerable: true, get: function () { return never_1.never; } });
var of_1 = require("./internal/observable/of");
Object.defineProperty(exports, "of", { enumerable: true, get: function () { return of_1.of; } });
var onErrorResumeNext_1 = require("./internal/observable/onErrorResumeNext");
Object.defineProperty(exports, "onErrorResumeNext", { enumerable: true, get: function () { return onErrorResumeNext_1.onErrorResumeNext; } });
var pairs_1 = require("./internal/observable/pairs");
Object.defineProperty(exports, "pairs", { enumerable: true, get: function () { return pairs_1.pairs; } });
var partition_1 = require("./internal/observable/partition");
Object.defineProperty(exports, "partition", { enumerable: true, get: function () { return partition_1.partition; } });
var race_1 = require("./internal/observable/race");
Object.defineProperty(exports, "race", { enumerable: true, get: function () { return race_1.race; } });
var range_1 = require("./internal/observable/range");
Object.defineProperty(exports, "range", { enumerable: true, get: function () { return range_1.range; } });
var throwError_1 = require("./internal/observable/throwError");
Object.defineProperty(exports, "throwError", { enumerable: true, get: function () { return throwError_1.throwError; } });
var timer_1 = require("./internal/observable/timer");
Object.defineProperty(exports, "timer", { enumerable: true, get: function () { return timer_1.timer; } });
var using_1 = require("./internal/observable/using");
Object.defineProperty(exports, "using", { enumerable: true, get: function () { return using_1.using; } });
var zip_1 = require("./internal/observable/zip");
Object.defineProperty(exports, "zip", { enumerable: true, get: function () { return zip_1.zip; } });
var scheduled_1 = require("./internal/scheduled/scheduled");
Object.defineProperty(exports, "scheduled", { enumerable: true, get: function () { return scheduled_1.scheduled; } });
var empty_2 = require("./internal/observable/empty");
Object.defineProperty(exports, "EMPTY", { enumerable: true, get: function () { return empty_2.EMPTY; } });
var never_2 = require("./internal/observable/never");
Object.defineProperty(exports, "NEVER", { enumerable: true, get: function () { return never_2.NEVER; } });
__exportStar(require("./internal/types"), exports);
var config_1 = require("./internal/config");
Object.defineProperty(exports, "config", { enumerable: true, get: function () { return config_1.config; } });
var audit_1 = require("./internal/operators/audit");
Object.defineProperty(exports, "audit", { enumerable: true, get: function () { return audit_1.audit; } });
var auditTime_1 = require("./internal/operators/auditTime");
Object.defineProperty(exports, "auditTime", { enumerable: true, get: function () { return auditTime_1.auditTime; } });
var buffer_1 = require("./internal/operators/buffer");
Object.defineProperty(exports, "buffer", { enumerable: true, get: function () { return buffer_1.buffer; } });
var bufferCount_1 = require("./internal/operators/bufferCount");
Object.defineProperty(exports, "bufferCount", { enumerable: true, get: function () { return bufferCount_1.bufferCount; } });
var bufferTime_1 = require("./internal/operators/bufferTime");
Object.defineProperty(exports, "bufferTime", { enumerable: true, get: function () { return bufferTime_1.bufferTime; } });
var bufferToggle_1 = require("./internal/operators/bufferToggle");
Object.defineProperty(exports, "bufferToggle", { enumerable: true, get: function () { return bufferToggle_1.bufferToggle; } });
var bufferWhen_1 = require("./internal/operators/bufferWhen");
Object.defineProperty(exports, "bufferWhen", { enumerable: true, get: function () { return bufferWhen_1.bufferWhen; } });
var catchError_1 = require("./internal/operators/catchError");
Object.defineProperty(exports, "catchError", { enumerable: true, get: function () { return catchError_1.catchError; } });
var combineAll_1 = require("./internal/operators/combineAll");
Object.defineProperty(exports, "combineAll", { enumerable: true, get: function () { return combineAll_1.combineAll; } });
var combineLatestAll_1 = require("./internal/operators/combineLatestAll");
Object.defineProperty(exports, "combineLatestAll", { enumerable: true, get: function () { return combineLatestAll_1.combineLatestAll; } });
var combineLatestWith_1 = require("./internal/operators/combineLatestWith");
Object.defineProperty(exports, "combineLatestWith", { enumerable: true, get: function () { return combineLatestWith_1.combineLatestWith; } });
var concatAll_1 = require("./internal/operators/concatAll");
Object.defineProperty(exports, "concatAll", { enumerable: true, get: function () { return concatAll_1.concatAll; } });
var concatMap_1 = require("./internal/operators/concatMap");
Object.defineProperty(exports, "concatMap", { enumerable: true, get: function () { return concatMap_1.concatMap; } });
var concatMapTo_1 = require("./internal/operators/concatMapTo");
Object.defineProperty(exports, "concatMapTo", { enumerable: true, get: function () { return concatMapTo_1.concatMapTo; } });
var concatWith_1 = require("./internal/operators/concatWith");
Object.defineProperty(exports, "concatWith", { enumerable: true, get: function () { return concatWith_1.concatWith; } });
var connect_1 = require("./internal/operators/connect");
Object.defineProperty(exports, "connect", { enumerable: true, get: function () { return connect_1.connect; } });
var count_1 = require("./internal/operators/count");
Object.defineProperty(exports, "count", { enumerable: true, get: function () { return count_1.count; } });
var debounce_1 = require("./internal/operators/debounce");
Object.defineProperty(exports, "debounce", { enumerable: true, get: function () { return debounce_1.debounce; } });
var debounceTime_1 = require("./internal/operators/debounceTime");
Object.defineProperty(exports, "debounceTime", { enumerable: true, get: function () { return debounceTime_1.debounceTime; } });
var defaultIfEmpty_1 = require("./internal/operators/defaultIfEmpty");
Object.defineProperty(exports, "defaultIfEmpty", { enumerable: true, get: function () { return defaultIfEmpty_1.defaultIfEmpty; } });
var delay_1 = require("./internal/operators/delay");
Object.defineProperty(exports, "delay", { enumerable: true, get: function () { return delay_1.delay; } });
var delayWhen_1 = require("./internal/operators/delayWhen");
Object.defineProperty(exports, "delayWhen", { enumerable: true, get: function () { return delayWhen_1.delayWhen; } });
var dematerialize_1 = require("./internal/operators/dematerialize");
Object.defineProperty(exports, "dematerialize", { enumerable: true, get: function () { return dematerialize_1.dematerialize; } });
var distinct_1 = require("./internal/operators/distinct");
Object.defineProperty(exports, "distinct", { enumerable: true, get: function () { return distinct_1.distinct; } });
var distinctUntilChanged_1 = require("./internal/operators/distinctUntilChanged");
Object.defineProperty(exports, "distinctUntilChanged", { enumerable: true, get: function () { return distinctUntilChanged_1.distinctUntilChanged; } });
var distinctUntilKeyChanged_1 = require("./internal/operators/distinctUntilKeyChanged");
Object.defineProperty(exports, "distinctUntilKeyChanged", { enumerable: true, get: function () { return distinctUntilKeyChanged_1.distinctUntilKeyChanged; } });
var elementAt_1 = require("./internal/operators/elementAt");
Object.defineProperty(exports, "elementAt", { enumerable: true, get: function () { return elementAt_1.elementAt; } });
var endWith_1 = require("./internal/operators/endWith");
Object.defineProperty(exports, "endWith", { enumerable: true, get: function () { return endWith_1.endWith; } });
var every_1 = require("./internal/operators/every");
Object.defineProperty(exports, "every", { enumerable: true, get: function () { return every_1.every; } });
var exhaust_1 = require("./internal/operators/exhaust");
Object.defineProperty(exports, "exhaust", { enumerable: true, get: function () { return exhaust_1.exhaust; } });
var exhaustAll_1 = require("./internal/operators/exhaustAll");
Object.defineProperty(exports, "exhaustAll", { enumerable: true, get: function () { return exhaustAll_1.exhaustAll; } });
var exhaustMap_1 = require("./internal/operators/exhaustMap");
Object.defineProperty(exports, "exhaustMap", { enumerable: true, get: function () { return exhaustMap_1.exhaustMap; } });
var expand_1 = require("./internal/operators/expand");
Object.defineProperty(exports, "expand", { enumerable: true, get: function () { return expand_1.expand; } });
var filter_1 = require("./internal/operators/filter");
Object.defineProperty(exports, "filter", { enumerable: true, get: function () { return filter_1.filter; } });
var finalize_1 = require("./internal/operators/finalize");
Object.defineProperty(exports, "finalize", { enumerable: true, get: function () { return finalize_1.finalize; } });
var find_1 = require("./internal/operators/find");
Object.defineProperty(exports, "find", { enumerable: true, get: function () { return find_1.find; } });
var findIndex_1 = require("./internal/operators/findIndex");
Object.defineProperty(exports, "findIndex", { enumerable: true, get: function () { return findIndex_1.findIndex; } });
var first_1 = require("./internal/operators/first");
Object.defineProperty(exports, "first", { enumerable: true, get: function () { return first_1.first; } });
var groupBy_1 = require("./internal/operators/groupBy");
Object.defineProperty(exports, "groupBy", { enumerable: true, get: function () { return groupBy_1.groupBy; } });
var ignoreElements_1 = require("./internal/operators/ignoreElements");
Object.defineProperty(exports, "ignoreElements", { enumerable: true, get: function () { return ignoreElements_1.ignoreElements; } });
var isEmpty_1 = require("./internal/operators/isEmpty");
Object.defineProperty(exports, "isEmpty", { enumerable: true, get: function () { return isEmpty_1.isEmpty; } });
var last_1 = require("./internal/operators/last");
Object.defineProperty(exports, "last", { enumerable: true, get: function () { return last_1.last; } });
var map_1 = require("./internal/operators/map");
Object.defineProperty(exports, "map", { enumerable: true, get: function () { return map_1.map; } });
var mapTo_1 = require("./internal/operators/mapTo");
Object.defineProperty(exports, "mapTo", { enumerable: true, get: function () { return mapTo_1.mapTo; } });
var materialize_1 = require("./internal/operators/materialize");
Object.defineProperty(exports, "materialize", { enumerable: true, get: function () { return materialize_1.materialize; } });
var max_1 = require("./internal/operators/max");
Object.defineProperty(exports, "max", { enumerable: true, get: function () { return max_1.max; } });
var mergeAll_1 = require("./internal/operators/mergeAll");
Object.defineProperty(exports, "mergeAll", { enumerable: true, get: function () { return mergeAll_1.mergeAll; } });
var flatMap_1 = require("./internal/operators/flatMap");
Object.defineProperty(exports, "flatMap", { enumerable: true, get: function () { return flatMap_1.flatMap; } });
var mergeMap_1 = require("./internal/operators/mergeMap");
Object.defineProperty(exports, "mergeMap", { enumerable: true, get: function () { return mergeMap_1.mergeMap; } });
var mergeMapTo_1 = require("./internal/operators/mergeMapTo");
Object.defineProperty(exports, "mergeMapTo", { enumerable: true, get: function () { return mergeMapTo_1.mergeMapTo; } });
var mergeScan_1 = require("./internal/operators/mergeScan");
Object.defineProperty(exports, "mergeScan", { enumerable: true, get: function () { return mergeScan_1.mergeScan; } });
var mergeWith_1 = require("./internal/operators/mergeWith");
Object.defineProperty(exports, "mergeWith", { enumerable: true, get: function () { return mergeWith_1.mergeWith; } });
var min_1 = require("./internal/operators/min");
Object.defineProperty(exports, "min", { enumerable: true, get: function () { return min_1.min; } });
var multicast_1 = require("./internal/operators/multicast");
Object.defineProperty(exports, "multicast", { enumerable: true, get: function () { return multicast_1.multicast; } });
var observeOn_1 = require("./internal/operators/observeOn");
Object.defineProperty(exports, "observeOn", { enumerable: true, get: function () { return observeOn_1.observeOn; } });
var onErrorResumeNextWith_1 = require("./internal/operators/onErrorResumeNextWith");
Object.defineProperty(exports, "onErrorResumeNextWith", { enumerable: true, get: function () { return onErrorResumeNextWith_1.onErrorResumeNextWith; } });
var pairwise_1 = require("./internal/operators/pairwise");
Object.defineProperty(exports, "pairwise", { enumerable: true, get: function () { return pairwise_1.pairwise; } });
var pluck_1 = require("./internal/operators/pluck");
Object.defineProperty(exports, "pluck", { enumerable: true, get: function () { return pluck_1.pluck; } });
var publish_1 = require("./internal/operators/publish");
Object.defineProperty(exports, "publish", { enumerable: true, get: function () { return publish_1.publish; } });
var publishBehavior_1 = require("./internal/operators/publishBehavior");
Object.defineProperty(exports, "publishBehavior", { enumerable: true, get: function () { return publishBehavior_1.publishBehavior; } });
var publishLast_1 = require("./internal/operators/publishLast");
Object.defineProperty(exports, "publishLast", { enumerable: true, get: function () { return publishLast_1.publishLast; } });
var publishReplay_1 = require("./internal/operators/publishReplay");
Object.defineProperty(exports, "publishReplay", { enumerable: true, get: function () { return publishReplay_1.publishReplay; } });
var raceWith_1 = require("./internal/operators/raceWith");
Object.defineProperty(exports, "raceWith", { enumerable: true, get: function () { return raceWith_1.raceWith; } });
var reduce_1 = require("./internal/operators/reduce");
Object.defineProperty(exports, "reduce", { enumerable: true, get: function () { return reduce_1.reduce; } });
var repeat_1 = require("./internal/operators/repeat");
Object.defineProperty(exports, "repeat", { enumerable: true, get: function () { return repeat_1.repeat; } });
var repeatWhen_1 = require("./internal/operators/repeatWhen");
Object.defineProperty(exports, "repeatWhen", { enumerable: true, get: function () { return repeatWhen_1.repeatWhen; } });
var retry_1 = require("./internal/operators/retry");
Object.defineProperty(exports, "retry", { enumerable: true, get: function () { return retry_1.retry; } });
var retryWhen_1 = require("./internal/operators/retryWhen");
Object.defineProperty(exports, "retryWhen", { enumerable: true, get: function () { return retryWhen_1.retryWhen; } });
var refCount_1 = require("./internal/operators/refCount");
Object.defineProperty(exports, "refCount", { enumerable: true, get: function () { return refCount_1.refCount; } });
var sample_1 = require("./internal/operators/sample");
Object.defineProperty(exports, "sample", { enumerable: true, get: function () { return sample_1.sample; } });
var sampleTime_1 = require("./internal/operators/sampleTime");
Object.defineProperty(exports, "sampleTime", { enumerable: true, get: function () { return sampleTime_1.sampleTime; } });
var scan_1 = require("./internal/operators/scan");
Object.defineProperty(exports, "scan", { enumerable: true, get: function () { return scan_1.scan; } });
var sequenceEqual_1 = require("./internal/operators/sequenceEqual");
Object.defineProperty(exports, "sequenceEqual", { enumerable: true, get: function () { return sequenceEqual_1.sequenceEqual; } });
var share_1 = require("./internal/operators/share");
Object.defineProperty(exports, "share", { enumerable: true, get: function () { return share_1.share; } });
var shareReplay_1 = require("./internal/operators/shareReplay");
Object.defineProperty(exports, "shareReplay", { enumerable: true, get: function () { return shareReplay_1.shareReplay; } });
var single_1 = require("./internal/operators/single");
Object.defineProperty(exports, "single", { enumerable: true, get: function () { return single_1.single; } });
var skip_1 = require("./internal/operators/skip");
Object.defineProperty(exports, "skip", { enumerable: true, get: function () { return skip_1.skip; } });
var skipLast_1 = require("./internal/operators/skipLast");
Object.defineProperty(exports, "skipLast", { enumerable: true, get: function () { return skipLast_1.skipLast; } });
var skipUntil_1 = require("./internal/operators/skipUntil");
Object.defineProperty(exports, "skipUntil", { enumerable: true, get: function () { return skipUntil_1.skipUntil; } });
var skipWhile_1 = require("./internal/operators/skipWhile");
Object.defineProperty(exports, "skipWhile", { enumerable: true, get: function () { return skipWhile_1.skipWhile; } });
var startWith_1 = require("./internal/operators/startWith");
Object.defineProperty(exports, "startWith", { enumerable: true, get: function () { return startWith_1.startWith; } });
var subscribeOn_1 = require("./internal/operators/subscribeOn");
Object.defineProperty(exports, "subscribeOn", { enumerable: true, get: function () { return subscribeOn_1.subscribeOn; } });
var switchAll_1 = require("./internal/operators/switchAll");
Object.defineProperty(exports, "switchAll", { enumerable: true, get: function () { return switchAll_1.switchAll; } });
var switchMap_1 = require("./internal/operators/switchMap");
Object.defineProperty(exports, "switchMap", { enumerable: true, get: function () { return switchMap_1.switchMap; } });
var switchMapTo_1 = require("./internal/operators/switchMapTo");
Object.defineProperty(exports, "switchMapTo", { enumerable: true, get: function () { return switchMapTo_1.switchMapTo; } });
var switchScan_1 = require("./internal/operators/switchScan");
Object.defineProperty(exports, "switchScan", { enumerable: true, get: function () { return switchScan_1.switchScan; } });
var take_1 = require("./internal/operators/take");
Object.defineProperty(exports, "take", { enumerable: true, get: function () { return take_1.take; } });
var takeLast_1 = require("./internal/operators/takeLast");
Object.defineProperty(exports, "takeLast", { enumerable: true, get: function () { return takeLast_1.takeLast; } });
var takeUntil_1 = require("./internal/operators/takeUntil");
Object.defineProperty(exports, "takeUntil", { enumerable: true, get: function () { return takeUntil_1.takeUntil; } });
var takeWhile_1 = require("./internal/operators/takeWhile");
Object.defineProperty(exports, "takeWhile", { enumerable: true, get: function () { return takeWhile_1.takeWhile; } });
var tap_1 = require("./internal/operators/tap");
Object.defineProperty(exports, "tap", { enumerable: true, get: function () { return tap_1.tap; } });
var throttle_1 = require("./internal/operators/throttle");
Object.defineProperty(exports, "throttle", { enumerable: true, get: function () { return throttle_1.throttle; } });
var throttleTime_1 = require("./internal/operators/throttleTime");
Object.defineProperty(exports, "throttleTime", { enumerable: true, get: function () { return throttleTime_1.throttleTime; } });
var throwIfEmpty_1 = require("./internal/operators/throwIfEmpty");
Object.defineProperty(exports, "throwIfEmpty", { enumerable: true, get: function () { return throwIfEmpty_1.throwIfEmpty; } });
var timeInterval_1 = require("./internal/operators/timeInterval");
Object.defineProperty(exports, "timeInterval", { enumerable: true, get: function () { return timeInterval_1.timeInterval; } });
var timeout_2 = require("./internal/operators/timeout");
Object.defineProperty(exports, "timeout", { enumerable: true, get: function () { return timeout_2.timeout; } });
var timeoutWith_1 = require("./internal/operators/timeoutWith");
Object.defineProperty(exports, "timeoutWith", { enumerable: true, get: function () { return timeoutWith_1.timeoutWith; } });
var timestamp_1 = require("./internal/operators/timestamp");
Object.defineProperty(exports, "timestamp", { enumerable: true, get: function () { return timestamp_1.timestamp; } });
var toArray_1 = require("./internal/operators/toArray");
Object.defineProperty(exports, "toArray", { enumerable: true, get: function () { return toArray_1.toArray; } });
var window_1 = require("./internal/operators/window");
Object.defineProperty(exports, "window", { enumerable: true, get: function () { return window_1.window; } });
var windowCount_1 = require("./internal/operators/windowCount");
Object.defineProperty(exports, "windowCount", { enumerable: true, get: function () { return windowCount_1.windowCount; } });
var windowTime_1 = require("./internal/operators/windowTime");
Object.defineProperty(exports, "windowTime", { enumerable: true, get: function () { return windowTime_1.windowTime; } });
var windowToggle_1 = require("./internal/operators/windowToggle");
Object.defineProperty(exports, "windowToggle", { enumerable: true, get: function () { return windowToggle_1.windowToggle; } });
var windowWhen_1 = require("./internal/operators/windowWhen");
Object.defineProperty(exports, "windowWhen", { enumerable: true, get: function () { return windowWhen_1.windowWhen; } });
var withLatestFrom_1 = require("./internal/operators/withLatestFrom");
Object.defineProperty(exports, "withLatestFrom", { enumerable: true, get: function () { return withLatestFrom_1.withLatestFrom; } });
var zipAll_1 = require("./internal/operators/zipAll");
Object.defineProperty(exports, "zipAll", { enumerable: true, get: function () { return zipAll_1.zipAll; } });
var zipWith_1 = require("./internal/operators/zipWith");
Object.defineProperty(exports, "zipWith", { enumerable: true, get: function () { return zipWith_1.zipWith; } });

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\AsyncSubject.js", {"./Subject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subject.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5CAsyncSubject.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsyncSubject = void 0;
var Subject_1 = require("./Subject");
var AsyncSubject = (function (_super) {
    __extends(AsyncSubject, _super);
    function AsyncSubject() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._value = null;
        _this._hasValue = false;
        _this._isComplete = false;
        return _this;
    }
    AsyncSubject.prototype._checkFinalizedStatuses = function (subscriber) {
        var _a = this, hasError = _a.hasError, _hasValue = _a._hasValue, _value = _a._value, thrownError = _a.thrownError, isStopped = _a.isStopped, _isComplete = _a._isComplete;
        if (hasError) {
            subscriber.error(thrownError);
        }
        else if (isStopped || _isComplete) {
            _hasValue && subscriber.next(_value);
            subscriber.complete();
        }
    };
    AsyncSubject.prototype.next = function (value) {
        if (!this.isStopped) {
            this._value = value;
            this._hasValue = true;
        }
    };
    AsyncSubject.prototype.complete = function () {
        var _a = this, _hasValue = _a._hasValue, _value = _a._value, _isComplete = _a._isComplete;
        if (!_isComplete) {
            this._isComplete = true;
            _hasValue && _super.prototype.next.call(this, _value);
            _super.prototype.complete.call(this);
        }
    };
    return AsyncSubject;
}(Subject_1.Subject));
exports.AsyncSubject = AsyncSubject;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\AsyncSubject.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\BehaviorSubject.js", {"./Subject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subject.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5CBehaviorSubject.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.BehaviorSubject = void 0;
var Subject_1 = require("./Subject");
var BehaviorSubject = (function (_super) {
    __extends(BehaviorSubject, _super);
    function BehaviorSubject(_value) {
        var _this = _super.call(this) || this;
        _this._value = _value;
        return _this;
    }
    Object.defineProperty(BehaviorSubject.prototype, "value", {
        get: function () {
            return this.getValue();
        },
        enumerable: false,
        configurable: true
    });
    BehaviorSubject.prototype._subscribe = function (subscriber) {
        var subscription = _super.prototype._subscribe.call(this, subscriber);
        !subscription.closed && subscriber.next(this._value);
        return subscription;
    };
    BehaviorSubject.prototype.getValue = function () {
        var _a = this, hasError = _a.hasError, thrownError = _a.thrownError, _value = _a._value;
        if (hasError) {
            throw thrownError;
        }
        this._throwIfClosed();
        return _value;
    };
    BehaviorSubject.prototype.next = function (value) {
        _super.prototype.next.call(this, (this._value = value));
    };
    return BehaviorSubject;
}(Subject_1.Subject));
exports.BehaviorSubject = BehaviorSubject;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\BehaviorSubject.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Notification.js", {"./observable/empty":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\empty.js","./observable/of":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\of.js","./observable/throwError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\throwError.js","./util/isFunction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isFunction.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5CNotification.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.observeNotification = exports.Notification = exports.NotificationKind = void 0;
var empty_1 = require("./observable/empty");
var of_1 = require("./observable/of");
var throwError_1 = require("./observable/throwError");
var isFunction_1 = require("./util/isFunction");
var NotificationKind;
(function (NotificationKind) {
    NotificationKind["NEXT"] = "N";
    NotificationKind["ERROR"] = "E";
    NotificationKind["COMPLETE"] = "C";
})(NotificationKind = exports.NotificationKind || (exports.NotificationKind = {}));
var Notification = (function () {
    function Notification(kind, value, error) {
        this.kind = kind;
        this.value = value;
        this.error = error;
        this.hasValue = kind === 'N';
    }
    Notification.prototype.observe = function (observer) {
        return observeNotification(this, observer);
    };
    Notification.prototype.do = function (nextHandler, errorHandler, completeHandler) {
        var _a = this, kind = _a.kind, value = _a.value, error = _a.error;
        return kind === 'N' ? nextHandler === null || nextHandler === void 0 ? void 0 : nextHandler(value) : kind === 'E' ? errorHandler === null || errorHandler === void 0 ? void 0 : errorHandler(error) : completeHandler === null || completeHandler === void 0 ? void 0 : completeHandler();
    };
    Notification.prototype.accept = function (nextOrObserver, error, complete) {
        var _a;
        return isFunction_1.isFunction((_a = nextOrObserver) === null || _a === void 0 ? void 0 : _a.next)
            ? this.observe(nextOrObserver)
            : this.do(nextOrObserver, error, complete);
    };
    Notification.prototype.toObservable = function () {
        var _a = this, kind = _a.kind, value = _a.value, error = _a.error;
        var result = kind === 'N'
            ?
                of_1.of(value)
            :
                kind === 'E'
                    ?
                        throwError_1.throwError(function () { return error; })
                    :
                        kind === 'C'
                            ?
                                empty_1.EMPTY
                            :
                                0;
        if (!result) {
            throw new TypeError("Unexpected notification kind " + kind);
        }
        return result;
    };
    Notification.createNext = function (value) {
        return new Notification('N', value);
    };
    Notification.createError = function (err) {
        return new Notification('E', undefined, err);
    };
    Notification.createComplete = function () {
        return Notification.completeNotification;
    };
    Notification.completeNotification = new Notification('C');
    return Notification;
}());
exports.Notification = Notification;
function observeNotification(notification, observer) {
    var _a, _b, _c;
    var _d = notification, kind = _d.kind, value = _d.value, error = _d.error;
    if (typeof kind !== 'string') {
        throw new TypeError('Invalid notification, missing "kind"');
    }
    kind === 'N' ? (_a = observer.next) === null || _a === void 0 ? void 0 : _a.call(observer, value) : kind === 'E' ? (_b = observer.error) === null || _b === void 0 ? void 0 : _b.call(observer, error) : (_c = observer.complete) === null || _c === void 0 ? void 0 : _c.call(observer);
}
exports.observeNotification = observeNotification;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\Notification.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\NotificationFactories.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5CNotificationFactories.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createNotification = exports.nextNotification = exports.errorNotification = exports.COMPLETE_NOTIFICATION = void 0;
exports.COMPLETE_NOTIFICATION = (function () { return createNotification('C', undefined, undefined); })();
function errorNotification(error) {
    return createNotification('E', undefined, error);
}
exports.errorNotification = errorNotification;
function nextNotification(value) {
    return createNotification('N', value, undefined);
}
exports.nextNotification = nextNotification;
function createNotification(kind, value, error) {
    return {
        kind: kind,
        value: value,
        error: error,
    };
}
exports.createNotification = createNotification;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\NotificationFactories.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js", {"./Subscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subscriber.js","./Subscription":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subscription.js","./config":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\config.js","./symbol/observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\symbol\\observable.js","./util/errorContext":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\errorContext.js","./util/isFunction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isFunction.js","./util/pipe":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\pipe.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5CObservable.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Observable = void 0;
var Subscriber_1 = require("./Subscriber");
var Subscription_1 = require("./Subscription");
var observable_1 = require("./symbol/observable");
var pipe_1 = require("./util/pipe");
var config_1 = require("./config");
var isFunction_1 = require("./util/isFunction");
var errorContext_1 = require("./util/errorContext");
var Observable = (function () {
    function Observable(subscribe) {
        if (subscribe) {
            this._subscribe = subscribe;
        }
    }
    Observable.prototype.lift = function (operator) {
        var observable = new Observable();
        observable.source = this;
        observable.operator = operator;
        return observable;
    };
    Observable.prototype.subscribe = function (observerOrNext, error, complete) {
        var _this = this;
        var subscriber = isSubscriber(observerOrNext) ? observerOrNext : new Subscriber_1.SafeSubscriber(observerOrNext, error, complete);
        errorContext_1.errorContext(function () {
            var _a = _this, operator = _a.operator, source = _a.source;
            subscriber.add(operator
                ?
                    operator.call(subscriber, source)
                : source
                    ?
                        _this._subscribe(subscriber)
                    :
                        _this._trySubscribe(subscriber));
        });
        return subscriber;
    };
    Observable.prototype._trySubscribe = function (sink) {
        try {
            return this._subscribe(sink);
        }
        catch (err) {
            sink.error(err);
        }
    };
    Observable.prototype.forEach = function (next, promiseCtor) {
        var _this = this;
        promiseCtor = getPromiseCtor(promiseCtor);
        return new promiseCtor(function (resolve, reject) {
            var subscriber = new Subscriber_1.SafeSubscriber({
                next: function (value) {
                    try {
                        next(value);
                    }
                    catch (err) {
                        reject(err);
                        subscriber.unsubscribe();
                    }
                },
                error: reject,
                complete: resolve,
            });
            _this.subscribe(subscriber);
        });
    };
    Observable.prototype._subscribe = function (subscriber) {
        var _a;
        return (_a = this.source) === null || _a === void 0 ? void 0 : _a.subscribe(subscriber);
    };
    Observable.prototype[observable_1.observable] = function () {
        return this;
    };
    Observable.prototype.pipe = function () {
        var operations = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            operations[_i] = arguments[_i];
        }
        return pipe_1.pipeFromArray(operations)(this);
    };
    Observable.prototype.toPromise = function (promiseCtor) {
        var _this = this;
        promiseCtor = getPromiseCtor(promiseCtor);
        return new promiseCtor(function (resolve, reject) {
            var value;
            _this.subscribe(function (x) { return (value = x); }, function (err) { return reject(err); }, function () { return resolve(value); });
        });
    };
    Observable.create = function (subscribe) {
        return new Observable(subscribe);
    };
    return Observable;
}());
exports.Observable = Observable;
function getPromiseCtor(promiseCtor) {
    var _a;
    return (_a = promiseCtor !== null && promiseCtor !== void 0 ? promiseCtor : config_1.config.Promise) !== null && _a !== void 0 ? _a : Promise;
}
function isObserver(value) {
    return value && isFunction_1.isFunction(value.next) && isFunction_1.isFunction(value.error) && isFunction_1.isFunction(value.complete);
}
function isSubscriber(value) {
    return (value && value instanceof Subscriber_1.Subscriber) || (isObserver(value) && Subscription_1.isSubscription(value));
}

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\ReplaySubject.js", {"./Subject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subject.js","./scheduler/dateTimestampProvider":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\dateTimestampProvider.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5CReplaySubject.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReplaySubject = void 0;
var Subject_1 = require("./Subject");
var dateTimestampProvider_1 = require("./scheduler/dateTimestampProvider");
var ReplaySubject = (function (_super) {
    __extends(ReplaySubject, _super);
    function ReplaySubject(_bufferSize, _windowTime, _timestampProvider) {
        if (_bufferSize === void 0) { _bufferSize = Infinity; }
        if (_windowTime === void 0) { _windowTime = Infinity; }
        if (_timestampProvider === void 0) { _timestampProvider = dateTimestampProvider_1.dateTimestampProvider; }
        var _this = _super.call(this) || this;
        _this._bufferSize = _bufferSize;
        _this._windowTime = _windowTime;
        _this._timestampProvider = _timestampProvider;
        _this._buffer = [];
        _this._infiniteTimeWindow = true;
        _this._infiniteTimeWindow = _windowTime === Infinity;
        _this._bufferSize = Math.max(1, _bufferSize);
        _this._windowTime = Math.max(1, _windowTime);
        return _this;
    }
    ReplaySubject.prototype.next = function (value) {
        var _a = this, isStopped = _a.isStopped, _buffer = _a._buffer, _infiniteTimeWindow = _a._infiniteTimeWindow, _timestampProvider = _a._timestampProvider, _windowTime = _a._windowTime;
        if (!isStopped) {
            _buffer.push(value);
            !_infiniteTimeWindow && _buffer.push(_timestampProvider.now() + _windowTime);
        }
        this._trimBuffer();
        _super.prototype.next.call(this, value);
    };
    ReplaySubject.prototype._subscribe = function (subscriber) {
        this._throwIfClosed();
        this._trimBuffer();
        var subscription = this._innerSubscribe(subscriber);
        var _a = this, _infiniteTimeWindow = _a._infiniteTimeWindow, _buffer = _a._buffer;
        var copy = _buffer.slice();
        for (var i = 0; i < copy.length && !subscriber.closed; i += _infiniteTimeWindow ? 1 : 2) {
            subscriber.next(copy[i]);
        }
        this._checkFinalizedStatuses(subscriber);
        return subscription;
    };
    ReplaySubject.prototype._trimBuffer = function () {
        var _a = this, _bufferSize = _a._bufferSize, _timestampProvider = _a._timestampProvider, _buffer = _a._buffer, _infiniteTimeWindow = _a._infiniteTimeWindow;
        var adjustedBufferSize = (_infiniteTimeWindow ? 1 : 2) * _bufferSize;
        _bufferSize < Infinity && adjustedBufferSize < _buffer.length && _buffer.splice(0, _buffer.length - adjustedBufferSize);
        if (!_infiniteTimeWindow) {
            var now = _timestampProvider.now();
            var last = 0;
            for (var i = 1; i < _buffer.length && _buffer[i] <= now; i += 2) {
                last = i;
            }
            last && _buffer.splice(0, last + 1);
        }
    };
    return ReplaySubject;
}(Subject_1.Subject));
exports.ReplaySubject = ReplaySubject;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\ReplaySubject.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Scheduler.js", {"./scheduler/dateTimestampProvider":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\dateTimestampProvider.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5CScheduler.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Scheduler = void 0;
var dateTimestampProvider_1 = require("./scheduler/dateTimestampProvider");
var Scheduler = (function () {
    function Scheduler(schedulerActionCtor, now) {
        if (now === void 0) { now = Scheduler.now; }
        this.schedulerActionCtor = schedulerActionCtor;
        this.now = now;
    }
    Scheduler.prototype.schedule = function (work, delay, state) {
        if (delay === void 0) { delay = 0; }
        return new this.schedulerActionCtor(this, work).schedule(state, delay);
    };
    Scheduler.now = dateTimestampProvider_1.dateTimestampProvider.now;
    return Scheduler;
}());
exports.Scheduler = Scheduler;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\Scheduler.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subject.js", {"./Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","./Subscription":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subscription.js","./util/ObjectUnsubscribedError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\ObjectUnsubscribedError.js","./util/arrRemove":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\arrRemove.js","./util/errorContext":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\errorContext.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5CSubject.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AnonymousSubject = exports.Subject = void 0;
var Observable_1 = require("./Observable");
var Subscription_1 = require("./Subscription");
var ObjectUnsubscribedError_1 = require("./util/ObjectUnsubscribedError");
var arrRemove_1 = require("./util/arrRemove");
var errorContext_1 = require("./util/errorContext");
var Subject = (function (_super) {
    __extends(Subject, _super);
    function Subject() {
        var _this = _super.call(this) || this;
        _this.closed = false;
        _this.currentObservers = null;
        _this.observers = [];
        _this.isStopped = false;
        _this.hasError = false;
        _this.thrownError = null;
        return _this;
    }
    Subject.prototype.lift = function (operator) {
        var subject = new AnonymousSubject(this, this);
        subject.operator = operator;
        return subject;
    };
    Subject.prototype._throwIfClosed = function () {
        if (this.closed) {
            throw new ObjectUnsubscribedError_1.ObjectUnsubscribedError();
        }
    };
    Subject.prototype.next = function (value) {
        var _this = this;
        errorContext_1.errorContext(function () {
            var e_1, _a;
            _this._throwIfClosed();
            if (!_this.isStopped) {
                if (!_this.currentObservers) {
                    _this.currentObservers = Array.from(_this.observers);
                }
                try {
                    for (var _b = __values(_this.currentObservers), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var observer = _c.value;
                        observer.next(value);
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
            }
        });
    };
    Subject.prototype.error = function (err) {
        var _this = this;
        errorContext_1.errorContext(function () {
            _this._throwIfClosed();
            if (!_this.isStopped) {
                _this.hasError = _this.isStopped = true;
                _this.thrownError = err;
                var observers = _this.observers;
                while (observers.length) {
                    observers.shift().error(err);
                }
            }
        });
    };
    Subject.prototype.complete = function () {
        var _this = this;
        errorContext_1.errorContext(function () {
            _this._throwIfClosed();
            if (!_this.isStopped) {
                _this.isStopped = true;
                var observers = _this.observers;
                while (observers.length) {
                    observers.shift().complete();
                }
            }
        });
    };
    Subject.prototype.unsubscribe = function () {
        this.isStopped = this.closed = true;
        this.observers = this.currentObservers = null;
    };
    Object.defineProperty(Subject.prototype, "observed", {
        get: function () {
            var _a;
            return ((_a = this.observers) === null || _a === void 0 ? void 0 : _a.length) > 0;
        },
        enumerable: false,
        configurable: true
    });
    Subject.prototype._trySubscribe = function (subscriber) {
        this._throwIfClosed();
        return _super.prototype._trySubscribe.call(this, subscriber);
    };
    Subject.prototype._subscribe = function (subscriber) {
        this._throwIfClosed();
        this._checkFinalizedStatuses(subscriber);
        return this._innerSubscribe(subscriber);
    };
    Subject.prototype._innerSubscribe = function (subscriber) {
        var _this = this;
        var _a = this, hasError = _a.hasError, isStopped = _a.isStopped, observers = _a.observers;
        if (hasError || isStopped) {
            return Subscription_1.EMPTY_SUBSCRIPTION;
        }
        this.currentObservers = null;
        observers.push(subscriber);
        return new Subscription_1.Subscription(function () {
            _this.currentObservers = null;
            arrRemove_1.arrRemove(observers, subscriber);
        });
    };
    Subject.prototype._checkFinalizedStatuses = function (subscriber) {
        var _a = this, hasError = _a.hasError, thrownError = _a.thrownError, isStopped = _a.isStopped;
        if (hasError) {
            subscriber.error(thrownError);
        }
        else if (isStopped) {
            subscriber.complete();
        }
    };
    Subject.prototype.asObservable = function () {
        var observable = new Observable_1.Observable();
        observable.source = this;
        return observable;
    };
    Subject.create = function (destination, source) {
        return new AnonymousSubject(destination, source);
    };
    return Subject;
}(Observable_1.Observable));
exports.Subject = Subject;
var AnonymousSubject = (function (_super) {
    __extends(AnonymousSubject, _super);
    function AnonymousSubject(destination, source) {
        var _this = _super.call(this) || this;
        _this.destination = destination;
        _this.source = source;
        return _this;
    }
    AnonymousSubject.prototype.next = function (value) {
        var _a, _b;
        (_b = (_a = this.destination) === null || _a === void 0 ? void 0 : _a.next) === null || _b === void 0 ? void 0 : _b.call(_a, value);
    };
    AnonymousSubject.prototype.error = function (err) {
        var _a, _b;
        (_b = (_a = this.destination) === null || _a === void 0 ? void 0 : _a.error) === null || _b === void 0 ? void 0 : _b.call(_a, err);
    };
    AnonymousSubject.prototype.complete = function () {
        var _a, _b;
        (_b = (_a = this.destination) === null || _a === void 0 ? void 0 : _a.complete) === null || _b === void 0 ? void 0 : _b.call(_a);
    };
    AnonymousSubject.prototype._subscribe = function (subscriber) {
        var _a, _b;
        return (_b = (_a = this.source) === null || _a === void 0 ? void 0 : _a.subscribe(subscriber)) !== null && _b !== void 0 ? _b : Subscription_1.EMPTY_SUBSCRIPTION;
    };
    return AnonymousSubject;
}(Subject));
exports.AnonymousSubject = AnonymousSubject;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\Subject.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subscriber.js", {"./NotificationFactories":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\NotificationFactories.js","./Subscription":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subscription.js","./config":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\config.js","./scheduler/timeoutProvider":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\timeoutProvider.js","./util/errorContext":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\errorContext.js","./util/isFunction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isFunction.js","./util/noop":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\noop.js","./util/reportUnhandledError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\reportUnhandledError.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5CSubscriber.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.EMPTY_OBSERVER = exports.SafeSubscriber = exports.Subscriber = void 0;
var isFunction_1 = require("./util/isFunction");
var Subscription_1 = require("./Subscription");
var config_1 = require("./config");
var reportUnhandledError_1 = require("./util/reportUnhandledError");
var noop_1 = require("./util/noop");
var NotificationFactories_1 = require("./NotificationFactories");
var timeoutProvider_1 = require("./scheduler/timeoutProvider");
var errorContext_1 = require("./util/errorContext");
var Subscriber = (function (_super) {
    __extends(Subscriber, _super);
    function Subscriber(destination) {
        var _this = _super.call(this) || this;
        _this.isStopped = false;
        if (destination) {
            _this.destination = destination;
            if (Subscription_1.isSubscription(destination)) {
                destination.add(_this);
            }
        }
        else {
            _this.destination = exports.EMPTY_OBSERVER;
        }
        return _this;
    }
    Subscriber.create = function (next, error, complete) {
        return new SafeSubscriber(next, error, complete);
    };
    Subscriber.prototype.next = function (value) {
        if (this.isStopped) {
            handleStoppedNotification(NotificationFactories_1.nextNotification(value), this);
        }
        else {
            this._next(value);
        }
    };
    Subscriber.prototype.error = function (err) {
        if (this.isStopped) {
            handleStoppedNotification(NotificationFactories_1.errorNotification(err), this);
        }
        else {
            this.isStopped = true;
            this._error(err);
        }
    };
    Subscriber.prototype.complete = function () {
        if (this.isStopped) {
            handleStoppedNotification(NotificationFactories_1.COMPLETE_NOTIFICATION, this);
        }
        else {
            this.isStopped = true;
            this._complete();
        }
    };
    Subscriber.prototype.unsubscribe = function () {
        if (!this.closed) {
            this.isStopped = true;
            _super.prototype.unsubscribe.call(this);
            this.destination = null;
        }
    };
    Subscriber.prototype._next = function (value) {
        this.destination.next(value);
    };
    Subscriber.prototype._error = function (err) {
        try {
            this.destination.error(err);
        }
        finally {
            this.unsubscribe();
        }
    };
    Subscriber.prototype._complete = function () {
        try {
            this.destination.complete();
        }
        finally {
            this.unsubscribe();
        }
    };
    return Subscriber;
}(Subscription_1.Subscription));
exports.Subscriber = Subscriber;
var _bind = Function.prototype.bind;
function bind(fn, thisArg) {
    return _bind.call(fn, thisArg);
}
var ConsumerObserver = (function () {
    function ConsumerObserver(partialObserver) {
        this.partialObserver = partialObserver;
    }
    ConsumerObserver.prototype.next = function (value) {
        var partialObserver = this.partialObserver;
        if (partialObserver.next) {
            try {
                partialObserver.next(value);
            }
            catch (error) {
                handleUnhandledError(error);
            }
        }
    };
    ConsumerObserver.prototype.error = function (err) {
        var partialObserver = this.partialObserver;
        if (partialObserver.error) {
            try {
                partialObserver.error(err);
            }
            catch (error) {
                handleUnhandledError(error);
            }
        }
        else {
            handleUnhandledError(err);
        }
    };
    ConsumerObserver.prototype.complete = function () {
        var partialObserver = this.partialObserver;
        if (partialObserver.complete) {
            try {
                partialObserver.complete();
            }
            catch (error) {
                handleUnhandledError(error);
            }
        }
    };
    return ConsumerObserver;
}());
var SafeSubscriber = (function (_super) {
    __extends(SafeSubscriber, _super);
    function SafeSubscriber(observerOrNext, error, complete) {
        var _this = _super.call(this) || this;
        var partialObserver;
        if (isFunction_1.isFunction(observerOrNext) || !observerOrNext) {
            partialObserver = {
                next: (observerOrNext !== null && observerOrNext !== void 0 ? observerOrNext : undefined),
                error: error !== null && error !== void 0 ? error : undefined,
                complete: complete !== null && complete !== void 0 ? complete : undefined,
            };
        }
        else {
            var context_1;
            if (_this && config_1.config.useDeprecatedNextContext) {
                context_1 = Object.create(observerOrNext);
                context_1.unsubscribe = function () { return _this.unsubscribe(); };
                partialObserver = {
                    next: observerOrNext.next && bind(observerOrNext.next, context_1),
                    error: observerOrNext.error && bind(observerOrNext.error, context_1),
                    complete: observerOrNext.complete && bind(observerOrNext.complete, context_1),
                };
            }
            else {
                partialObserver = observerOrNext;
            }
        }
        _this.destination = new ConsumerObserver(partialObserver);
        return _this;
    }
    return SafeSubscriber;
}(Subscriber));
exports.SafeSubscriber = SafeSubscriber;
function handleUnhandledError(error) {
    if (config_1.config.useDeprecatedSynchronousErrorHandling) {
        errorContext_1.captureError(error);
    }
    else {
        reportUnhandledError_1.reportUnhandledError(error);
    }
}
function defaultErrorHandler(err) {
    throw err;
}
function handleStoppedNotification(notification, subscriber) {
    var onStoppedNotification = config_1.config.onStoppedNotification;
    onStoppedNotification && timeoutProvider_1.timeoutProvider.setTimeout(function () { return onStoppedNotification(notification, subscriber); });
}
exports.EMPTY_OBSERVER = {
    closed: true,
    next: noop_1.noop,
    error: defaultErrorHandler,
    complete: noop_1.noop,
};

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\Subscriber.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subscription.js", {"./util/UnsubscriptionError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\UnsubscriptionError.js","./util/arrRemove":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\arrRemove.js","./util/isFunction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isFunction.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5CSubscription.js
      return function (require, module, exports) {
"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.isSubscription = exports.EMPTY_SUBSCRIPTION = exports.Subscription = void 0;
var isFunction_1 = require("./util/isFunction");
var UnsubscriptionError_1 = require("./util/UnsubscriptionError");
var arrRemove_1 = require("./util/arrRemove");
var Subscription = (function () {
    function Subscription(initialTeardown) {
        this.initialTeardown = initialTeardown;
        this.closed = false;
        this._parentage = null;
        this._finalizers = null;
    }
    Subscription.prototype.unsubscribe = function () {
        var e_1, _a, e_2, _b;
        var errors;
        if (!this.closed) {
            this.closed = true;
            var _parentage = this._parentage;
            if (_parentage) {
                this._parentage = null;
                if (Array.isArray(_parentage)) {
                    try {
                        for (var _parentage_1 = __values(_parentage), _parentage_1_1 = _parentage_1.next(); !_parentage_1_1.done; _parentage_1_1 = _parentage_1.next()) {
                            var parent_1 = _parentage_1_1.value;
                            parent_1.remove(this);
                        }
                    }
                    catch (e_1_1) { e_1 = { error: e_1_1 }; }
                    finally {
                        try {
                            if (_parentage_1_1 && !_parentage_1_1.done && (_a = _parentage_1.return)) _a.call(_parentage_1);
                        }
                        finally { if (e_1) throw e_1.error; }
                    }
                }
                else {
                    _parentage.remove(this);
                }
            }
            var initialFinalizer = this.initialTeardown;
            if (isFunction_1.isFunction(initialFinalizer)) {
                try {
                    initialFinalizer();
                }
                catch (e) {
                    errors = e instanceof UnsubscriptionError_1.UnsubscriptionError ? e.errors : [e];
                }
            }
            var _finalizers = this._finalizers;
            if (_finalizers) {
                this._finalizers = null;
                try {
                    for (var _finalizers_1 = __values(_finalizers), _finalizers_1_1 = _finalizers_1.next(); !_finalizers_1_1.done; _finalizers_1_1 = _finalizers_1.next()) {
                        var finalizer = _finalizers_1_1.value;
                        try {
                            execFinalizer(finalizer);
                        }
                        catch (err) {
                            errors = errors !== null && errors !== void 0 ? errors : [];
                            if (err instanceof UnsubscriptionError_1.UnsubscriptionError) {
                                errors = __spreadArray(__spreadArray([], __read(errors)), __read(err.errors));
                            }
                            else {
                                errors.push(err);
                            }
                        }
                    }
                }
                catch (e_2_1) { e_2 = { error: e_2_1 }; }
                finally {
                    try {
                        if (_finalizers_1_1 && !_finalizers_1_1.done && (_b = _finalizers_1.return)) _b.call(_finalizers_1);
                    }
                    finally { if (e_2) throw e_2.error; }
                }
            }
            if (errors) {
                throw new UnsubscriptionError_1.UnsubscriptionError(errors);
            }
        }
    };
    Subscription.prototype.add = function (teardown) {
        var _a;
        if (teardown && teardown !== this) {
            if (this.closed) {
                execFinalizer(teardown);
            }
            else {
                if (teardown instanceof Subscription) {
                    if (teardown.closed || teardown._hasParent(this)) {
                        return;
                    }
                    teardown._addParent(this);
                }
                (this._finalizers = (_a = this._finalizers) !== null && _a !== void 0 ? _a : []).push(teardown);
            }
        }
    };
    Subscription.prototype._hasParent = function (parent) {
        var _parentage = this._parentage;
        return _parentage === parent || (Array.isArray(_parentage) && _parentage.includes(parent));
    };
    Subscription.prototype._addParent = function (parent) {
        var _parentage = this._parentage;
        this._parentage = Array.isArray(_parentage) ? (_parentage.push(parent), _parentage) : _parentage ? [_parentage, parent] : parent;
    };
    Subscription.prototype._removeParent = function (parent) {
        var _parentage = this._parentage;
        if (_parentage === parent) {
            this._parentage = null;
        }
        else if (Array.isArray(_parentage)) {
            arrRemove_1.arrRemove(_parentage, parent);
        }
    };
    Subscription.prototype.remove = function (teardown) {
        var _finalizers = this._finalizers;
        _finalizers && arrRemove_1.arrRemove(_finalizers, teardown);
        if (teardown instanceof Subscription) {
            teardown._removeParent(this);
        }
    };
    Subscription.EMPTY = (function () {
        var empty = new Subscription();
        empty.closed = true;
        return empty;
    })();
    return Subscription;
}());
exports.Subscription = Subscription;
exports.EMPTY_SUBSCRIPTION = Subscription.EMPTY;
function isSubscription(value) {
    return (value instanceof Subscription ||
        (value && 'closed' in value && isFunction_1.isFunction(value.remove) && isFunction_1.isFunction(value.add) && isFunction_1.isFunction(value.unsubscribe)));
}
exports.isSubscription = isSubscription;
function execFinalizer(finalizer) {
    if (isFunction_1.isFunction(finalizer)) {
        finalizer();
    }
    else {
        finalizer.unsubscribe();
    }
}

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\Subscription.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\config.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cconfig.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.config = void 0;
exports.config = {
    onUnhandledError: null,
    onStoppedNotification: null,
    Promise: undefined,
    useDeprecatedSynchronousErrorHandling: false,
    useDeprecatedNextContext: false,
};

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\config.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\firstValueFrom.js", {"./Subscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subscriber.js","./util/EmptyError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\EmptyError.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5CfirstValueFrom.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.firstValueFrom = void 0;
var EmptyError_1 = require("./util/EmptyError");
var Subscriber_1 = require("./Subscriber");
function firstValueFrom(source, config) {
    var hasConfig = typeof config === 'object';
    return new Promise(function (resolve, reject) {
        var subscriber = new Subscriber_1.SafeSubscriber({
            next: function (value) {
                resolve(value);
                subscriber.unsubscribe();
            },
            error: reject,
            complete: function () {
                if (hasConfig) {
                    resolve(config.defaultValue);
                }
                else {
                    reject(new EmptyError_1.EmptyError());
                }
            },
        });
        source.subscribe(subscriber);
    });
}
exports.firstValueFrom = firstValueFrom;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\firstValueFrom.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\lastValueFrom.js", {"./util/EmptyError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\EmptyError.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5ClastValueFrom.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.lastValueFrom = void 0;
var EmptyError_1 = require("./util/EmptyError");
function lastValueFrom(source, config) {
    var hasConfig = typeof config === 'object';
    return new Promise(function (resolve, reject) {
        var _hasValue = false;
        var _value;
        source.subscribe({
            next: function (value) {
                _value = value;
                _hasValue = true;
            },
            error: reject,
            complete: function () {
                if (_hasValue) {
                    resolve(_value);
                }
                else if (hasConfig) {
                    resolve(config.defaultValue);
                }
                else {
                    reject(new EmptyError_1.EmptyError());
                }
            },
        });
    });
}
exports.lastValueFrom = lastValueFrom;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\lastValueFrom.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\ConnectableObservable.js", {"../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","../Subscription":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subscription.js","../operators/OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js","../operators/refCount":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\refCount.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5CConnectableObservable.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConnectableObservable = void 0;
var Observable_1 = require("../Observable");
var Subscription_1 = require("../Subscription");
var refCount_1 = require("../operators/refCount");
var OperatorSubscriber_1 = require("../operators/OperatorSubscriber");
var lift_1 = require("../util/lift");
var ConnectableObservable = (function (_super) {
    __extends(ConnectableObservable, _super);
    function ConnectableObservable(source, subjectFactory) {
        var _this = _super.call(this) || this;
        _this.source = source;
        _this.subjectFactory = subjectFactory;
        _this._subject = null;
        _this._refCount = 0;
        _this._connection = null;
        if (lift_1.hasLift(source)) {
            _this.lift = source.lift;
        }
        return _this;
    }
    ConnectableObservable.prototype._subscribe = function (subscriber) {
        return this.getSubject().subscribe(subscriber);
    };
    ConnectableObservable.prototype.getSubject = function () {
        var subject = this._subject;
        if (!subject || subject.isStopped) {
            this._subject = this.subjectFactory();
        }
        return this._subject;
    };
    ConnectableObservable.prototype._teardown = function () {
        this._refCount = 0;
        var _connection = this._connection;
        this._subject = this._connection = null;
        _connection === null || _connection === void 0 ? void 0 : _connection.unsubscribe();
    };
    ConnectableObservable.prototype.connect = function () {
        var _this = this;
        var connection = this._connection;
        if (!connection) {
            connection = this._connection = new Subscription_1.Subscription();
            var subject_1 = this.getSubject();
            connection.add(this.source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subject_1, undefined, function () {
                _this._teardown();
                subject_1.complete();
            }, function (err) {
                _this._teardown();
                subject_1.error(err);
            }, function () { return _this._teardown(); })));
            if (connection.closed) {
                this._connection = null;
                connection = Subscription_1.Subscription.EMPTY;
            }
        }
        return connection;
    };
    ConnectableObservable.prototype.refCount = function () {
        return refCount_1.refCount()(this);
    };
    return ConnectableObservable;
}(Observable_1.Observable));
exports.ConnectableObservable = ConnectableObservable;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\ConnectableObservable.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\bindCallback.js", {"./bindCallbackInternals":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\bindCallbackInternals.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5CbindCallback.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bindCallback = void 0;
var bindCallbackInternals_1 = require("./bindCallbackInternals");
function bindCallback(callbackFunc, resultSelector, scheduler) {
    return bindCallbackInternals_1.bindCallbackInternals(false, callbackFunc, resultSelector, scheduler);
}
exports.bindCallback = bindCallback;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\bindCallback.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\bindCallbackInternals.js", {"../AsyncSubject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\AsyncSubject.js","../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","../operators/observeOn":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\observeOn.js","../operators/subscribeOn":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\subscribeOn.js","../util/isScheduler":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isScheduler.js","../util/mapOneOrManyArgs":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\mapOneOrManyArgs.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5CbindCallbackInternals.js
      return function (require, module, exports) {
"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.bindCallbackInternals = void 0;
var isScheduler_1 = require("../util/isScheduler");
var Observable_1 = require("../Observable");
var subscribeOn_1 = require("../operators/subscribeOn");
var mapOneOrManyArgs_1 = require("../util/mapOneOrManyArgs");
var observeOn_1 = require("../operators/observeOn");
var AsyncSubject_1 = require("../AsyncSubject");
function bindCallbackInternals(isNodeStyle, callbackFunc, resultSelector, scheduler) {
    if (resultSelector) {
        if (isScheduler_1.isScheduler(resultSelector)) {
            scheduler = resultSelector;
        }
        else {
            return function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                return bindCallbackInternals(isNodeStyle, callbackFunc, scheduler)
                    .apply(this, args)
                    .pipe(mapOneOrManyArgs_1.mapOneOrManyArgs(resultSelector));
            };
        }
    }
    if (scheduler) {
        return function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            return bindCallbackInternals(isNodeStyle, callbackFunc)
                .apply(this, args)
                .pipe(subscribeOn_1.subscribeOn(scheduler), observeOn_1.observeOn(scheduler));
        };
    }
    return function () {
        var _this = this;
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var subject = new AsyncSubject_1.AsyncSubject();
        var uninitialized = true;
        return new Observable_1.Observable(function (subscriber) {
            var subs = subject.subscribe(subscriber);
            if (uninitialized) {
                uninitialized = false;
                var isAsync_1 = false;
                var isComplete_1 = false;
                callbackFunc.apply(_this, __spreadArray(__spreadArray([], __read(args)), [
                    function () {
                        var results = [];
                        for (var _i = 0; _i < arguments.length; _i++) {
                            results[_i] = arguments[_i];
                        }
                        if (isNodeStyle) {
                            var err = results.shift();
                            if (err != null) {
                                subject.error(err);
                                return;
                            }
                        }
                        subject.next(1 < results.length ? results : results[0]);
                        isComplete_1 = true;
                        if (isAsync_1) {
                            subject.complete();
                        }
                    },
                ]));
                if (isComplete_1) {
                    subject.complete();
                }
                isAsync_1 = true;
            }
            return subs;
        });
    };
}
exports.bindCallbackInternals = bindCallbackInternals;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\bindCallbackInternals.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\bindNodeCallback.js", {"./bindCallbackInternals":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\bindCallbackInternals.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5CbindNodeCallback.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bindNodeCallback = void 0;
var bindCallbackInternals_1 = require("./bindCallbackInternals");
function bindNodeCallback(callbackFunc, resultSelector, scheduler) {
    return bindCallbackInternals_1.bindCallbackInternals(true, callbackFunc, resultSelector, scheduler);
}
exports.bindNodeCallback = bindNodeCallback;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\bindNodeCallback.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\combineLatest.js", {"../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","../operators/OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js","../util/args":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\args.js","../util/argsArgArrayOrObject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\argsArgArrayOrObject.js","../util/createObject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\createObject.js","../util/executeSchedule":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\executeSchedule.js","../util/identity":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\identity.js","../util/mapOneOrManyArgs":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\mapOneOrManyArgs.js","./from":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\from.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5CcombineLatest.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.combineLatestInit = exports.combineLatest = void 0;
var Observable_1 = require("../Observable");
var argsArgArrayOrObject_1 = require("../util/argsArgArrayOrObject");
var from_1 = require("./from");
var identity_1 = require("../util/identity");
var mapOneOrManyArgs_1 = require("../util/mapOneOrManyArgs");
var args_1 = require("../util/args");
var createObject_1 = require("../util/createObject");
var OperatorSubscriber_1 = require("../operators/OperatorSubscriber");
var executeSchedule_1 = require("../util/executeSchedule");
function combineLatest() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var scheduler = args_1.popScheduler(args);
    var resultSelector = args_1.popResultSelector(args);
    var _a = argsArgArrayOrObject_1.argsArgArrayOrObject(args), observables = _a.args, keys = _a.keys;
    if (observables.length === 0) {
        return from_1.from([], scheduler);
    }
    var result = new Observable_1.Observable(combineLatestInit(observables, scheduler, keys
        ?
            function (values) { return createObject_1.createObject(keys, values); }
        :
            identity_1.identity));
    return resultSelector ? result.pipe(mapOneOrManyArgs_1.mapOneOrManyArgs(resultSelector)) : result;
}
exports.combineLatest = combineLatest;
function combineLatestInit(observables, scheduler, valueTransform) {
    if (valueTransform === void 0) { valueTransform = identity_1.identity; }
    return function (subscriber) {
        maybeSchedule(scheduler, function () {
            var length = observables.length;
            var values = new Array(length);
            var active = length;
            var remainingFirstValues = length;
            var _loop_1 = function (i) {
                maybeSchedule(scheduler, function () {
                    var source = from_1.from(observables[i], scheduler);
                    var hasFirstValue = false;
                    source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
                        values[i] = value;
                        if (!hasFirstValue) {
                            hasFirstValue = true;
                            remainingFirstValues--;
                        }
                        if (!remainingFirstValues) {
                            subscriber.next(valueTransform(values.slice()));
                        }
                    }, function () {
                        if (!--active) {
                            subscriber.complete();
                        }
                    }));
                }, subscriber);
            };
            for (var i = 0; i < length; i++) {
                _loop_1(i);
            }
        }, subscriber);
    };
}
exports.combineLatestInit = combineLatestInit;
function maybeSchedule(scheduler, execute, subscription) {
    if (scheduler) {
        executeSchedule_1.executeSchedule(subscription, scheduler, execute);
    }
    else {
        execute();
    }
}

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\combineLatest.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\concat.js", {"../operators/concatAll":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\concatAll.js","../util/args":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\args.js","./from":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\from.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5Cconcat.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.concat = void 0;
var concatAll_1 = require("../operators/concatAll");
var args_1 = require("../util/args");
var from_1 = require("./from");
function concat() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    return concatAll_1.concatAll()(from_1.from(args, args_1.popScheduler(args)));
}
exports.concat = concat;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\concat.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\connectable.js", {"../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","../Subject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subject.js","./defer":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\defer.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5Cconnectable.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.connectable = void 0;
var Subject_1 = require("../Subject");
var Observable_1 = require("../Observable");
var defer_1 = require("./defer");
var DEFAULT_CONFIG = {
    connector: function () { return new Subject_1.Subject(); },
    resetOnDisconnect: true,
};
function connectable(source, config) {
    if (config === void 0) { config = DEFAULT_CONFIG; }
    var connection = null;
    var connector = config.connector, _a = config.resetOnDisconnect, resetOnDisconnect = _a === void 0 ? true : _a;
    var subject = connector();
    var result = new Observable_1.Observable(function (subscriber) {
        return subject.subscribe(subscriber);
    });
    result.connect = function () {
        if (!connection || connection.closed) {
            connection = defer_1.defer(function () { return source; }).subscribe(subject);
            if (resetOnDisconnect) {
                connection.add(function () { return (subject = connector()); });
            }
        }
        return connection;
    };
    return result;
}
exports.connectable = connectable;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\connectable.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\defer.js", {"../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","./innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5Cdefer.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defer = void 0;
var Observable_1 = require("../Observable");
var innerFrom_1 = require("./innerFrom");
function defer(observableFactory) {
    return new Observable_1.Observable(function (subscriber) {
        innerFrom_1.innerFrom(observableFactory()).subscribe(subscriber);
    });
}
exports.defer = defer;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\defer.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\dom\\animationFrames.js", {"../../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","../../scheduler/animationFrameProvider":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\animationFrameProvider.js","../../scheduler/performanceTimestampProvider":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\performanceTimestampProvider.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5Cdom%5CanimationFrames.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.animationFrames = void 0;
var Observable_1 = require("../../Observable");
var performanceTimestampProvider_1 = require("../../scheduler/performanceTimestampProvider");
var animationFrameProvider_1 = require("../../scheduler/animationFrameProvider");
function animationFrames(timestampProvider) {
    return timestampProvider ? animationFramesFactory(timestampProvider) : DEFAULT_ANIMATION_FRAMES;
}
exports.animationFrames = animationFrames;
function animationFramesFactory(timestampProvider) {
    return new Observable_1.Observable(function (subscriber) {
        var provider = timestampProvider || performanceTimestampProvider_1.performanceTimestampProvider;
        var start = provider.now();
        var id = 0;
        var run = function () {
            if (!subscriber.closed) {
                id = animationFrameProvider_1.animationFrameProvider.requestAnimationFrame(function (timestamp) {
                    id = 0;
                    var now = provider.now();
                    subscriber.next({
                        timestamp: timestampProvider ? now : timestamp,
                        elapsed: now - start,
                    });
                    run();
                });
            }
        };
        run();
        return function () {
            if (id) {
                animationFrameProvider_1.animationFrameProvider.cancelAnimationFrame(id);
            }
        };
    });
}
var DEFAULT_ANIMATION_FRAMES = animationFramesFactory();

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\dom\\animationFrames.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\empty.js", {"../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5Cempty.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.empty = exports.EMPTY = void 0;
var Observable_1 = require("../Observable");
exports.EMPTY = new Observable_1.Observable(function (subscriber) { return subscriber.complete(); });
function empty(scheduler) {
    return scheduler ? emptyScheduled(scheduler) : exports.EMPTY;
}
exports.empty = empty;
function emptyScheduled(scheduler) {
    return new Observable_1.Observable(function (subscriber) { return scheduler.schedule(function () { return subscriber.complete(); }); });
}

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\empty.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\forkJoin.js", {"../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","../operators/OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js","../util/args":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\args.js","../util/argsArgArrayOrObject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\argsArgArrayOrObject.js","../util/createObject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\createObject.js","../util/mapOneOrManyArgs":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\mapOneOrManyArgs.js","./innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5CforkJoin.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.forkJoin = void 0;
var Observable_1 = require("../Observable");
var argsArgArrayOrObject_1 = require("../util/argsArgArrayOrObject");
var innerFrom_1 = require("./innerFrom");
var args_1 = require("../util/args");
var OperatorSubscriber_1 = require("../operators/OperatorSubscriber");
var mapOneOrManyArgs_1 = require("../util/mapOneOrManyArgs");
var createObject_1 = require("../util/createObject");
function forkJoin() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var resultSelector = args_1.popResultSelector(args);
    var _a = argsArgArrayOrObject_1.argsArgArrayOrObject(args), sources = _a.args, keys = _a.keys;
    var result = new Observable_1.Observable(function (subscriber) {
        var length = sources.length;
        if (!length) {
            subscriber.complete();
            return;
        }
        var values = new Array(length);
        var remainingCompletions = length;
        var remainingEmissions = length;
        var _loop_1 = function (sourceIndex) {
            var hasValue = false;
            innerFrom_1.innerFrom(sources[sourceIndex]).subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
                if (!hasValue) {
                    hasValue = true;
                    remainingEmissions--;
                }
                values[sourceIndex] = value;
            }, function () { return remainingCompletions--; }, undefined, function () {
                if (!remainingCompletions || !hasValue) {
                    if (!remainingEmissions) {
                        subscriber.next(keys ? createObject_1.createObject(keys, values) : values);
                    }
                    subscriber.complete();
                }
            }));
        };
        for (var sourceIndex = 0; sourceIndex < length; sourceIndex++) {
            _loop_1(sourceIndex);
        }
    });
    return resultSelector ? result.pipe(mapOneOrManyArgs_1.mapOneOrManyArgs(resultSelector)) : result;
}
exports.forkJoin = forkJoin;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\forkJoin.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\from.js", {"../scheduled/scheduled":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\scheduled.js","./innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5Cfrom.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.from = void 0;
var scheduled_1 = require("../scheduled/scheduled");
var innerFrom_1 = require("./innerFrom");
function from(input, scheduler) {
    return scheduler ? scheduled_1.scheduled(input, scheduler) : innerFrom_1.innerFrom(input);
}
exports.from = from;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\from.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\fromEvent.js", {"../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../operators/mergeMap":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeMap.js","../util/isArrayLike":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isArrayLike.js","../util/isFunction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isFunction.js","../util/mapOneOrManyArgs":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\mapOneOrManyArgs.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5CfromEvent.js
      return function (require, module, exports) {
"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.fromEvent = void 0;
var innerFrom_1 = require("../observable/innerFrom");
var Observable_1 = require("../Observable");
var mergeMap_1 = require("../operators/mergeMap");
var isArrayLike_1 = require("../util/isArrayLike");
var isFunction_1 = require("../util/isFunction");
var mapOneOrManyArgs_1 = require("../util/mapOneOrManyArgs");
var nodeEventEmitterMethods = ['addListener', 'removeListener'];
var eventTargetMethods = ['addEventListener', 'removeEventListener'];
var jqueryMethods = ['on', 'off'];
function fromEvent(target, eventName, options, resultSelector) {
    if (isFunction_1.isFunction(options)) {
        resultSelector = options;
        options = undefined;
    }
    if (resultSelector) {
        return fromEvent(target, eventName, options).pipe(mapOneOrManyArgs_1.mapOneOrManyArgs(resultSelector));
    }
    var _a = __read(isEventTarget(target)
        ? eventTargetMethods.map(function (methodName) { return function (handler) { return target[methodName](eventName, handler, options); }; })
        :
            isNodeStyleEventEmitter(target)
                ? nodeEventEmitterMethods.map(toCommonHandlerRegistry(target, eventName))
                : isJQueryStyleEventEmitter(target)
                    ? jqueryMethods.map(toCommonHandlerRegistry(target, eventName))
                    : [], 2), add = _a[0], remove = _a[1];
    if (!add) {
        if (isArrayLike_1.isArrayLike(target)) {
            return mergeMap_1.mergeMap(function (subTarget) { return fromEvent(subTarget, eventName, options); })(innerFrom_1.innerFrom(target));
        }
    }
    if (!add) {
        throw new TypeError('Invalid event target');
    }
    return new Observable_1.Observable(function (subscriber) {
        var handler = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            return subscriber.next(1 < args.length ? args : args[0]);
        };
        add(handler);
        return function () { return remove(handler); };
    });
}
exports.fromEvent = fromEvent;
function toCommonHandlerRegistry(target, eventName) {
    return function (methodName) { return function (handler) { return target[methodName](eventName, handler); }; };
}
function isNodeStyleEventEmitter(target) {
    return isFunction_1.isFunction(target.addListener) && isFunction_1.isFunction(target.removeListener);
}
function isJQueryStyleEventEmitter(target) {
    return isFunction_1.isFunction(target.on) && isFunction_1.isFunction(target.off);
}
function isEventTarget(target) {
    return isFunction_1.isFunction(target.addEventListener) && isFunction_1.isFunction(target.removeEventListener);
}

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\fromEvent.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\fromEventPattern.js", {"../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","../util/isFunction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isFunction.js","../util/mapOneOrManyArgs":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\mapOneOrManyArgs.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5CfromEventPattern.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fromEventPattern = void 0;
var Observable_1 = require("../Observable");
var isFunction_1 = require("../util/isFunction");
var mapOneOrManyArgs_1 = require("../util/mapOneOrManyArgs");
function fromEventPattern(addHandler, removeHandler, resultSelector) {
    if (resultSelector) {
        return fromEventPattern(addHandler, removeHandler).pipe(mapOneOrManyArgs_1.mapOneOrManyArgs(resultSelector));
    }
    return new Observable_1.Observable(function (subscriber) {
        var handler = function () {
            var e = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                e[_i] = arguments[_i];
            }
            return subscriber.next(e.length === 1 ? e[0] : e);
        };
        var retValue = addHandler(handler);
        return isFunction_1.isFunction(removeHandler) ? function () { return removeHandler(handler, retValue); } : undefined;
    });
}
exports.fromEventPattern = fromEventPattern;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\fromEventPattern.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\fromSubscribable.js", {"../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5CfromSubscribable.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fromSubscribable = void 0;
var Observable_1 = require("../Observable");
function fromSubscribable(subscribable) {
    return new Observable_1.Observable(function (subscriber) { return subscribable.subscribe(subscriber); });
}
exports.fromSubscribable = fromSubscribable;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\fromSubscribable.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\generate.js", {"../scheduled/scheduleIterable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\scheduleIterable.js","../util/identity":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\identity.js","../util/isScheduler":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isScheduler.js","./defer":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\defer.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5Cgenerate.js
      return function (require, module, exports) {
"use strict";
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generate = void 0;
var identity_1 = require("../util/identity");
var isScheduler_1 = require("../util/isScheduler");
var defer_1 = require("./defer");
var scheduleIterable_1 = require("../scheduled/scheduleIterable");
function generate(initialStateOrOptions, condition, iterate, resultSelectorOrScheduler, scheduler) {
    var _a, _b;
    var resultSelector;
    var initialState;
    if (arguments.length === 1) {
        (_a = initialStateOrOptions, initialState = _a.initialState, condition = _a.condition, iterate = _a.iterate, _b = _a.resultSelector, resultSelector = _b === void 0 ? identity_1.identity : _b, scheduler = _a.scheduler);
    }
    else {
        initialState = initialStateOrOptions;
        if (!resultSelectorOrScheduler || isScheduler_1.isScheduler(resultSelectorOrScheduler)) {
            resultSelector = identity_1.identity;
            scheduler = resultSelectorOrScheduler;
        }
        else {
            resultSelector = resultSelectorOrScheduler;
        }
    }
    function gen() {
        var state;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    state = initialState;
                    _a.label = 1;
                case 1:
                    if (!(!condition || condition(state))) return [3, 4];
                    return [4, resultSelector(state)];
                case 2:
                    _a.sent();
                    _a.label = 3;
                case 3:
                    state = iterate(state);
                    return [3, 1];
                case 4: return [2];
            }
        });
    }
    return defer_1.defer((scheduler
        ?
            function () { return scheduleIterable_1.scheduleIterable(gen(), scheduler); }
        :
            gen));
}
exports.generate = generate;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\generate.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\iif.js", {"./defer":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\defer.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5Ciif.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.iif = void 0;
var defer_1 = require("./defer");
function iif(condition, trueResult, falseResult) {
    return defer_1.defer(function () { return (condition() ? trueResult : falseResult); });
}
exports.iif = iif;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\iif.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js", {"../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","../symbol/observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\symbol\\observable.js","../util/isArrayLike":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isArrayLike.js","../util/isAsyncIterable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isAsyncIterable.js","../util/isFunction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isFunction.js","../util/isInteropObservable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isInteropObservable.js","../util/isIterable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isIterable.js","../util/isPromise":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isPromise.js","../util/isReadableStreamLike":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isReadableStreamLike.js","../util/reportUnhandledError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\reportUnhandledError.js","../util/throwUnobservableError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\throwUnobservableError.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5CinnerFrom.js
      return function (require, module, exports) {
"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __asyncValues = (this && this.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.fromReadableStreamLike = exports.fromAsyncIterable = exports.fromIterable = exports.fromPromise = exports.fromArrayLike = exports.fromInteropObservable = exports.innerFrom = void 0;
var isArrayLike_1 = require("../util/isArrayLike");
var isPromise_1 = require("../util/isPromise");
var Observable_1 = require("../Observable");
var isInteropObservable_1 = require("../util/isInteropObservable");
var isAsyncIterable_1 = require("../util/isAsyncIterable");
var throwUnobservableError_1 = require("../util/throwUnobservableError");
var isIterable_1 = require("../util/isIterable");
var isReadableStreamLike_1 = require("../util/isReadableStreamLike");
var isFunction_1 = require("../util/isFunction");
var reportUnhandledError_1 = require("../util/reportUnhandledError");
var observable_1 = require("../symbol/observable");
function innerFrom(input) {
    if (input instanceof Observable_1.Observable) {
        return input;
    }
    if (input != null) {
        if (isInteropObservable_1.isInteropObservable(input)) {
            return fromInteropObservable(input);
        }
        if (isArrayLike_1.isArrayLike(input)) {
            return fromArrayLike(input);
        }
        if (isPromise_1.isPromise(input)) {
            return fromPromise(input);
        }
        if (isAsyncIterable_1.isAsyncIterable(input)) {
            return fromAsyncIterable(input);
        }
        if (isIterable_1.isIterable(input)) {
            return fromIterable(input);
        }
        if (isReadableStreamLike_1.isReadableStreamLike(input)) {
            return fromReadableStreamLike(input);
        }
    }
    throw throwUnobservableError_1.createInvalidObservableTypeError(input);
}
exports.innerFrom = innerFrom;
function fromInteropObservable(obj) {
    return new Observable_1.Observable(function (subscriber) {
        var obs = obj[observable_1.observable]();
        if (isFunction_1.isFunction(obs.subscribe)) {
            return obs.subscribe(subscriber);
        }
        throw new TypeError('Provided object does not correctly implement Symbol.observable');
    });
}
exports.fromInteropObservable = fromInteropObservable;
function fromArrayLike(array) {
    return new Observable_1.Observable(function (subscriber) {
        for (var i = 0; i < array.length && !subscriber.closed; i++) {
            subscriber.next(array[i]);
        }
        subscriber.complete();
    });
}
exports.fromArrayLike = fromArrayLike;
function fromPromise(promise) {
    return new Observable_1.Observable(function (subscriber) {
        promise
            .then(function (value) {
            if (!subscriber.closed) {
                subscriber.next(value);
                subscriber.complete();
            }
        }, function (err) { return subscriber.error(err); })
            .then(null, reportUnhandledError_1.reportUnhandledError);
    });
}
exports.fromPromise = fromPromise;
function fromIterable(iterable) {
    return new Observable_1.Observable(function (subscriber) {
        var e_1, _a;
        try {
            for (var iterable_1 = __values(iterable), iterable_1_1 = iterable_1.next(); !iterable_1_1.done; iterable_1_1 = iterable_1.next()) {
                var value = iterable_1_1.value;
                subscriber.next(value);
                if (subscriber.closed) {
                    return;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (iterable_1_1 && !iterable_1_1.done && (_a = iterable_1.return)) _a.call(iterable_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        subscriber.complete();
    });
}
exports.fromIterable = fromIterable;
function fromAsyncIterable(asyncIterable) {
    return new Observable_1.Observable(function (subscriber) {
        process(asyncIterable, subscriber).catch(function (err) { return subscriber.error(err); });
    });
}
exports.fromAsyncIterable = fromAsyncIterable;
function fromReadableStreamLike(readableStream) {
    return fromAsyncIterable(isReadableStreamLike_1.readableStreamLikeToAsyncGenerator(readableStream));
}
exports.fromReadableStreamLike = fromReadableStreamLike;
function process(asyncIterable, subscriber) {
    var asyncIterable_1, asyncIterable_1_1;
    var e_2, _a;
    return __awaiter(this, void 0, void 0, function () {
        var value, e_2_1;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    _b.trys.push([0, 5, 6, 11]);
                    asyncIterable_1 = __asyncValues(asyncIterable);
                    _b.label = 1;
                case 1: return [4, asyncIterable_1.next()];
                case 2:
                    if (!(asyncIterable_1_1 = _b.sent(), !asyncIterable_1_1.done)) return [3, 4];
                    value = asyncIterable_1_1.value;
                    subscriber.next(value);
                    if (subscriber.closed) {
                        return [2];
                    }
                    _b.label = 3;
                case 3: return [3, 1];
                case 4: return [3, 11];
                case 5:
                    e_2_1 = _b.sent();
                    e_2 = { error: e_2_1 };
                    return [3, 11];
                case 6:
                    _b.trys.push([6, , 9, 10]);
                    if (!(asyncIterable_1_1 && !asyncIterable_1_1.done && (_a = asyncIterable_1.return))) return [3, 8];
                    return [4, _a.call(asyncIterable_1)];
                case 7:
                    _b.sent();
                    _b.label = 8;
                case 8: return [3, 10];
                case 9:
                    if (e_2) throw e_2.error;
                    return [7];
                case 10: return [7];
                case 11:
                    subscriber.complete();
                    return [2];
            }
        });
    });
}

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\interval.js", {"../scheduler/async":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\async.js","./timer":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\timer.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5Cinterval.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.interval = void 0;
var async_1 = require("../scheduler/async");
var timer_1 = require("./timer");
function interval(period, scheduler) {
    if (period === void 0) { period = 0; }
    if (scheduler === void 0) { scheduler = async_1.asyncScheduler; }
    if (period < 0) {
        period = 0;
    }
    return timer_1.timer(period, period, scheduler);
}
exports.interval = interval;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\interval.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\merge.js", {"../operators/mergeAll":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeAll.js","../util/args":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\args.js","./empty":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\empty.js","./from":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\from.js","./innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5Cmerge.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.merge = void 0;
var mergeAll_1 = require("../operators/mergeAll");
var innerFrom_1 = require("./innerFrom");
var empty_1 = require("./empty");
var args_1 = require("../util/args");
var from_1 = require("./from");
function merge() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var scheduler = args_1.popScheduler(args);
    var concurrent = args_1.popNumber(args, Infinity);
    var sources = args;
    return !sources.length
        ?
            empty_1.EMPTY
        : sources.length === 1
            ?
                innerFrom_1.innerFrom(sources[0])
            :
                mergeAll_1.mergeAll(concurrent)(from_1.from(sources, scheduler));
}
exports.merge = merge;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\merge.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\never.js", {"../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","../util/noop":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\noop.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5Cnever.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.never = exports.NEVER = void 0;
var Observable_1 = require("../Observable");
var noop_1 = require("../util/noop");
exports.NEVER = new Observable_1.Observable(noop_1.noop);
function never() {
    return exports.NEVER;
}
exports.never = never;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\never.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\of.js", {"../util/args":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\args.js","./from":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\from.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5Cof.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.of = void 0;
var args_1 = require("../util/args");
var from_1 = require("./from");
function of() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var scheduler = args_1.popScheduler(args);
    return from_1.from(args, scheduler);
}
exports.of = of;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\of.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\onErrorResumeNext.js", {"../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","../operators/OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js","../util/argsOrArgArray":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\argsOrArgArray.js","../util/noop":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\noop.js","./innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5ConErrorResumeNext.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.onErrorResumeNext = void 0;
var Observable_1 = require("../Observable");
var argsOrArgArray_1 = require("../util/argsOrArgArray");
var OperatorSubscriber_1 = require("../operators/OperatorSubscriber");
var noop_1 = require("../util/noop");
var innerFrom_1 = require("./innerFrom");
function onErrorResumeNext() {
    var sources = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        sources[_i] = arguments[_i];
    }
    var nextSources = argsOrArgArray_1.argsOrArgArray(sources);
    return new Observable_1.Observable(function (subscriber) {
        var sourceIndex = 0;
        var subscribeNext = function () {
            if (sourceIndex < nextSources.length) {
                var nextSource = void 0;
                try {
                    nextSource = innerFrom_1.innerFrom(nextSources[sourceIndex++]);
                }
                catch (err) {
                    subscribeNext();
                    return;
                }
                var innerSubscriber = new OperatorSubscriber_1.OperatorSubscriber(subscriber, undefined, noop_1.noop, noop_1.noop);
                nextSource.subscribe(innerSubscriber);
                innerSubscriber.add(subscribeNext);
            }
            else {
                subscriber.complete();
            }
        };
        subscribeNext();
    });
}
exports.onErrorResumeNext = onErrorResumeNext;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\onErrorResumeNext.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\pairs.js", {"./from":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\from.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5Cpairs.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pairs = void 0;
var from_1 = require("./from");
function pairs(obj, scheduler) {
    return from_1.from(Object.entries(obj), scheduler);
}
exports.pairs = pairs;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\pairs.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\partition.js", {"../operators/filter":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\filter.js","../util/not":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\not.js","./innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5Cpartition.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.partition = void 0;
var not_1 = require("../util/not");
var filter_1 = require("../operators/filter");
var innerFrom_1 = require("./innerFrom");
function partition(source, predicate, thisArg) {
    return [filter_1.filter(predicate, thisArg)(innerFrom_1.innerFrom(source)), filter_1.filter(not_1.not(predicate, thisArg))(innerFrom_1.innerFrom(source))];
}
exports.partition = partition;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\partition.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\race.js", {"../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","../operators/OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js","../util/argsOrArgArray":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\argsOrArgArray.js","./innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5Crace.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.raceInit = exports.race = void 0;
var Observable_1 = require("../Observable");
var innerFrom_1 = require("./innerFrom");
var argsOrArgArray_1 = require("../util/argsOrArgArray");
var OperatorSubscriber_1 = require("../operators/OperatorSubscriber");
function race() {
    var sources = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        sources[_i] = arguments[_i];
    }
    sources = argsOrArgArray_1.argsOrArgArray(sources);
    return sources.length === 1 ? innerFrom_1.innerFrom(sources[0]) : new Observable_1.Observable(raceInit(sources));
}
exports.race = race;
function raceInit(sources) {
    return function (subscriber) {
        var subscriptions = [];
        var _loop_1 = function (i) {
            subscriptions.push(innerFrom_1.innerFrom(sources[i]).subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
                if (subscriptions) {
                    for (var s = 0; s < subscriptions.length; s++) {
                        s !== i && subscriptions[s].unsubscribe();
                    }
                    subscriptions = null;
                }
                subscriber.next(value);
            })));
        };
        for (var i = 0; subscriptions && !subscriber.closed && i < sources.length; i++) {
            _loop_1(i);
        }
    };
}
exports.raceInit = raceInit;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\race.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\range.js", {"../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","./empty":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\empty.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5Crange.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.range = void 0;
var Observable_1 = require("../Observable");
var empty_1 = require("./empty");
function range(start, count, scheduler) {
    if (count == null) {
        count = start;
        start = 0;
    }
    if (count <= 0) {
        return empty_1.EMPTY;
    }
    var end = count + start;
    return new Observable_1.Observable(scheduler
        ?
            function (subscriber) {
                var n = start;
                return scheduler.schedule(function () {
                    if (n < end) {
                        subscriber.next(n++);
                        this.schedule();
                    }
                    else {
                        subscriber.complete();
                    }
                });
            }
        :
            function (subscriber) {
                var n = start;
                while (n < end && !subscriber.closed) {
                    subscriber.next(n++);
                }
                subscriber.complete();
            });
}
exports.range = range;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\range.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\throwError.js", {"../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","../util/isFunction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isFunction.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5CthrowError.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.throwError = void 0;
var Observable_1 = require("../Observable");
var isFunction_1 = require("../util/isFunction");
function throwError(errorOrErrorFactory, scheduler) {
    var errorFactory = isFunction_1.isFunction(errorOrErrorFactory) ? errorOrErrorFactory : function () { return errorOrErrorFactory; };
    var init = function (subscriber) { return subscriber.error(errorFactory()); };
    return new Observable_1.Observable(scheduler ? function (subscriber) { return scheduler.schedule(init, 0, subscriber); } : init);
}
exports.throwError = throwError;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\throwError.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\timer.js", {"../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","../scheduler/async":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\async.js","../util/isDate":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isDate.js","../util/isScheduler":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isScheduler.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5Ctimer.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.timer = void 0;
var Observable_1 = require("../Observable");
var async_1 = require("../scheduler/async");
var isScheduler_1 = require("../util/isScheduler");
var isDate_1 = require("../util/isDate");
function timer(dueTime, intervalOrScheduler, scheduler) {
    if (dueTime === void 0) { dueTime = 0; }
    if (scheduler === void 0) { scheduler = async_1.async; }
    var intervalDuration = -1;
    if (intervalOrScheduler != null) {
        if (isScheduler_1.isScheduler(intervalOrScheduler)) {
            scheduler = intervalOrScheduler;
        }
        else {
            intervalDuration = intervalOrScheduler;
        }
    }
    return new Observable_1.Observable(function (subscriber) {
        var due = isDate_1.isValidDate(dueTime) ? +dueTime - scheduler.now() : dueTime;
        if (due < 0) {
            due = 0;
        }
        var n = 0;
        return scheduler.schedule(function () {
            if (!subscriber.closed) {
                subscriber.next(n++);
                if (0 <= intervalDuration) {
                    this.schedule(undefined, intervalDuration);
                }
                else {
                    subscriber.complete();
                }
            }
        }, due);
    });
}
exports.timer = timer;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\timer.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\using.js", {"../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","./empty":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\empty.js","./innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5Cusing.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.using = void 0;
var Observable_1 = require("../Observable");
var innerFrom_1 = require("./innerFrom");
var empty_1 = require("./empty");
function using(resourceFactory, observableFactory) {
    return new Observable_1.Observable(function (subscriber) {
        var resource = resourceFactory();
        var result = observableFactory(resource);
        var source = result ? innerFrom_1.innerFrom(result) : empty_1.EMPTY;
        source.subscribe(subscriber);
        return function () {
            if (resource) {
                resource.unsubscribe();
            }
        };
    });
}
exports.using = using;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\using.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\zip.js", {"../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","../operators/OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js","../util/args":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\args.js","../util/argsOrArgArray":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\argsOrArgArray.js","./empty":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\empty.js","./innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cobservable%5Czip.js
      return function (require, module, exports) {
"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.zip = void 0;
var Observable_1 = require("../Observable");
var innerFrom_1 = require("./innerFrom");
var argsOrArgArray_1 = require("../util/argsOrArgArray");
var empty_1 = require("./empty");
var OperatorSubscriber_1 = require("../operators/OperatorSubscriber");
var args_1 = require("../util/args");
function zip() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var resultSelector = args_1.popResultSelector(args);
    var sources = argsOrArgArray_1.argsOrArgArray(args);
    return sources.length
        ? new Observable_1.Observable(function (subscriber) {
            var buffers = sources.map(function () { return []; });
            var completed = sources.map(function () { return false; });
            subscriber.add(function () {
                buffers = completed = null;
            });
            var _loop_1 = function (sourceIndex) {
                innerFrom_1.innerFrom(sources[sourceIndex]).subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
                    buffers[sourceIndex].push(value);
                    if (buffers.every(function (buffer) { return buffer.length; })) {
                        var result = buffers.map(function (buffer) { return buffer.shift(); });
                        subscriber.next(resultSelector ? resultSelector.apply(void 0, __spreadArray([], __read(result))) : result);
                        if (buffers.some(function (buffer, i) { return !buffer.length && completed[i]; })) {
                            subscriber.complete();
                        }
                    }
                }, function () {
                    completed[sourceIndex] = true;
                    !buffers[sourceIndex].length && subscriber.complete();
                }));
            };
            for (var sourceIndex = 0; !subscriber.closed && sourceIndex < sources.length; sourceIndex++) {
                _loop_1(sourceIndex);
            }
            return function () {
                buffers = completed = null;
            };
        })
        : empty_1.EMPTY;
}
exports.zip = zip;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\observable\\zip.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js", {"../Subscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5COperatorSubscriber.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.OperatorSubscriber = exports.createOperatorSubscriber = void 0;
var Subscriber_1 = require("../Subscriber");
function createOperatorSubscriber(destination, onNext, onComplete, onError, onFinalize) {
    return new OperatorSubscriber(destination, onNext, onComplete, onError, onFinalize);
}
exports.createOperatorSubscriber = createOperatorSubscriber;
var OperatorSubscriber = (function (_super) {
    __extends(OperatorSubscriber, _super);
    function OperatorSubscriber(destination, onNext, onComplete, onError, onFinalize, shouldUnsubscribe) {
        var _this = _super.call(this, destination) || this;
        _this.onFinalize = onFinalize;
        _this.shouldUnsubscribe = shouldUnsubscribe;
        _this._next = onNext
            ? function (value) {
                try {
                    onNext(value);
                }
                catch (err) {
                    destination.error(err);
                }
            }
            : _super.prototype._next;
        _this._error = onError
            ? function (err) {
                try {
                    onError(err);
                }
                catch (err) {
                    destination.error(err);
                }
                finally {
                    this.unsubscribe();
                }
            }
            : _super.prototype._error;
        _this._complete = onComplete
            ? function () {
                try {
                    onComplete();
                }
                catch (err) {
                    destination.error(err);
                }
                finally {
                    this.unsubscribe();
                }
            }
            : _super.prototype._complete;
        return _this;
    }
    OperatorSubscriber.prototype.unsubscribe = function () {
        var _a;
        if (!this.shouldUnsubscribe || this.shouldUnsubscribe()) {
            var closed_1 = this.closed;
            _super.prototype.unsubscribe.call(this);
            !closed_1 && ((_a = this.onFinalize) === null || _a === void 0 ? void 0 : _a.call(this));
        }
    };
    return OperatorSubscriber;
}(Subscriber_1.Subscriber));
exports.OperatorSubscriber = OperatorSubscriber;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\audit.js", {"../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Caudit.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.audit = void 0;
var lift_1 = require("../util/lift");
var innerFrom_1 = require("../observable/innerFrom");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function audit(durationSelector) {
    return lift_1.operate(function (source, subscriber) {
        var hasValue = false;
        var lastValue = null;
        var durationSubscriber = null;
        var isComplete = false;
        var endDuration = function () {
            durationSubscriber === null || durationSubscriber === void 0 ? void 0 : durationSubscriber.unsubscribe();
            durationSubscriber = null;
            if (hasValue) {
                hasValue = false;
                var value = lastValue;
                lastValue = null;
                subscriber.next(value);
            }
            isComplete && subscriber.complete();
        };
        var cleanupDuration = function () {
            durationSubscriber = null;
            isComplete && subscriber.complete();
        };
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            hasValue = true;
            lastValue = value;
            if (!durationSubscriber) {
                innerFrom_1.innerFrom(durationSelector(value)).subscribe((durationSubscriber = OperatorSubscriber_1.createOperatorSubscriber(subscriber, endDuration, cleanupDuration)));
            }
        }, function () {
            isComplete = true;
            (!hasValue || !durationSubscriber || durationSubscriber.closed) && subscriber.complete();
        }));
    });
}
exports.audit = audit;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\audit.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\auditTime.js", {"../observable/timer":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\timer.js","../scheduler/async":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\async.js","./audit":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\audit.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CauditTime.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.auditTime = void 0;
var async_1 = require("../scheduler/async");
var audit_1 = require("./audit");
var timer_1 = require("../observable/timer");
function auditTime(duration, scheduler) {
    if (scheduler === void 0) { scheduler = async_1.asyncScheduler; }
    return audit_1.audit(function () { return timer_1.timer(duration, scheduler); });
}
exports.auditTime = auditTime;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\auditTime.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\buffer.js", {"../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","../util/noop":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\noop.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cbuffer.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buffer = void 0;
var lift_1 = require("../util/lift");
var noop_1 = require("../util/noop");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var innerFrom_1 = require("../observable/innerFrom");
function buffer(closingNotifier) {
    return lift_1.operate(function (source, subscriber) {
        var currentBuffer = [];
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) { return currentBuffer.push(value); }, function () {
            subscriber.next(currentBuffer);
            subscriber.complete();
        }));
        innerFrom_1.innerFrom(closingNotifier).subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function () {
            var b = currentBuffer;
            currentBuffer = [];
            subscriber.next(b);
        }, noop_1.noop));
        return function () {
            currentBuffer = null;
        };
    });
}
exports.buffer = buffer;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\buffer.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\bufferCount.js", {"../util/arrRemove":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\arrRemove.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CbufferCount.js
      return function (require, module, exports) {
"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.bufferCount = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var arrRemove_1 = require("../util/arrRemove");
function bufferCount(bufferSize, startBufferEvery) {
    if (startBufferEvery === void 0) { startBufferEvery = null; }
    startBufferEvery = startBufferEvery !== null && startBufferEvery !== void 0 ? startBufferEvery : bufferSize;
    return lift_1.operate(function (source, subscriber) {
        var buffers = [];
        var count = 0;
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            var e_1, _a, e_2, _b;
            var toEmit = null;
            if (count++ % startBufferEvery === 0) {
                buffers.push([]);
            }
            try {
                for (var buffers_1 = __values(buffers), buffers_1_1 = buffers_1.next(); !buffers_1_1.done; buffers_1_1 = buffers_1.next()) {
                    var buffer = buffers_1_1.value;
                    buffer.push(value);
                    if (bufferSize <= buffer.length) {
                        toEmit = toEmit !== null && toEmit !== void 0 ? toEmit : [];
                        toEmit.push(buffer);
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (buffers_1_1 && !buffers_1_1.done && (_a = buffers_1.return)) _a.call(buffers_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            if (toEmit) {
                try {
                    for (var toEmit_1 = __values(toEmit), toEmit_1_1 = toEmit_1.next(); !toEmit_1_1.done; toEmit_1_1 = toEmit_1.next()) {
                        var buffer = toEmit_1_1.value;
                        arrRemove_1.arrRemove(buffers, buffer);
                        subscriber.next(buffer);
                    }
                }
                catch (e_2_1) { e_2 = { error: e_2_1 }; }
                finally {
                    try {
                        if (toEmit_1_1 && !toEmit_1_1.done && (_b = toEmit_1.return)) _b.call(toEmit_1);
                    }
                    finally { if (e_2) throw e_2.error; }
                }
            }
        }, function () {
            var e_3, _a;
            try {
                for (var buffers_2 = __values(buffers), buffers_2_1 = buffers_2.next(); !buffers_2_1.done; buffers_2_1 = buffers_2.next()) {
                    var buffer = buffers_2_1.value;
                    subscriber.next(buffer);
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (buffers_2_1 && !buffers_2_1.done && (_a = buffers_2.return)) _a.call(buffers_2);
                }
                finally { if (e_3) throw e_3.error; }
            }
            subscriber.complete();
        }, undefined, function () {
            buffers = null;
        }));
    });
}
exports.bufferCount = bufferCount;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\bufferCount.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\bufferTime.js", {"../Subscription":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subscription.js","../scheduler/async":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\async.js","../util/args":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\args.js","../util/arrRemove":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\arrRemove.js","../util/executeSchedule":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\executeSchedule.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CbufferTime.js
      return function (require, module, exports) {
"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.bufferTime = void 0;
var Subscription_1 = require("../Subscription");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var arrRemove_1 = require("../util/arrRemove");
var async_1 = require("../scheduler/async");
var args_1 = require("../util/args");
var executeSchedule_1 = require("../util/executeSchedule");
function bufferTime(bufferTimeSpan) {
    var _a, _b;
    var otherArgs = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        otherArgs[_i - 1] = arguments[_i];
    }
    var scheduler = (_a = args_1.popScheduler(otherArgs)) !== null && _a !== void 0 ? _a : async_1.asyncScheduler;
    var bufferCreationInterval = (_b = otherArgs[0]) !== null && _b !== void 0 ? _b : null;
    var maxBufferSize = otherArgs[1] || Infinity;
    return lift_1.operate(function (source, subscriber) {
        var bufferRecords = [];
        var restartOnEmit = false;
        var emit = function (record) {
            var buffer = record.buffer, subs = record.subs;
            subs.unsubscribe();
            arrRemove_1.arrRemove(bufferRecords, record);
            subscriber.next(buffer);
            restartOnEmit && startBuffer();
        };
        var startBuffer = function () {
            if (bufferRecords) {
                var subs = new Subscription_1.Subscription();
                subscriber.add(subs);
                var buffer = [];
                var record_1 = {
                    buffer: buffer,
                    subs: subs,
                };
                bufferRecords.push(record_1);
                executeSchedule_1.executeSchedule(subs, scheduler, function () { return emit(record_1); }, bufferTimeSpan);
            }
        };
        if (bufferCreationInterval !== null && bufferCreationInterval >= 0) {
            executeSchedule_1.executeSchedule(subscriber, scheduler, startBuffer, bufferCreationInterval, true);
        }
        else {
            restartOnEmit = true;
        }
        startBuffer();
        var bufferTimeSubscriber = OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            var e_1, _a;
            var recordsCopy = bufferRecords.slice();
            try {
                for (var recordsCopy_1 = __values(recordsCopy), recordsCopy_1_1 = recordsCopy_1.next(); !recordsCopy_1_1.done; recordsCopy_1_1 = recordsCopy_1.next()) {
                    var record = recordsCopy_1_1.value;
                    var buffer = record.buffer;
                    buffer.push(value);
                    maxBufferSize <= buffer.length && emit(record);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (recordsCopy_1_1 && !recordsCopy_1_1.done && (_a = recordsCopy_1.return)) _a.call(recordsCopy_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }, function () {
            while (bufferRecords === null || bufferRecords === void 0 ? void 0 : bufferRecords.length) {
                subscriber.next(bufferRecords.shift().buffer);
            }
            bufferTimeSubscriber === null || bufferTimeSubscriber === void 0 ? void 0 : bufferTimeSubscriber.unsubscribe();
            subscriber.complete();
            subscriber.unsubscribe();
        }, undefined, function () { return (bufferRecords = null); });
        source.subscribe(bufferTimeSubscriber);
    });
}
exports.bufferTime = bufferTime;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\bufferTime.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\bufferToggle.js", {"../Subscription":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subscription.js","../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/arrRemove":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\arrRemove.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","../util/noop":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\noop.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CbufferToggle.js
      return function (require, module, exports) {
"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.bufferToggle = void 0;
var Subscription_1 = require("../Subscription");
var lift_1 = require("../util/lift");
var innerFrom_1 = require("../observable/innerFrom");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var noop_1 = require("../util/noop");
var arrRemove_1 = require("../util/arrRemove");
function bufferToggle(openings, closingSelector) {
    return lift_1.operate(function (source, subscriber) {
        var buffers = [];
        innerFrom_1.innerFrom(openings).subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (openValue) {
            var buffer = [];
            buffers.push(buffer);
            var closingSubscription = new Subscription_1.Subscription();
            var emitBuffer = function () {
                arrRemove_1.arrRemove(buffers, buffer);
                subscriber.next(buffer);
                closingSubscription.unsubscribe();
            };
            closingSubscription.add(innerFrom_1.innerFrom(closingSelector(openValue)).subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, emitBuffer, noop_1.noop)));
        }, noop_1.noop));
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            var e_1, _a;
            try {
                for (var buffers_1 = __values(buffers), buffers_1_1 = buffers_1.next(); !buffers_1_1.done; buffers_1_1 = buffers_1.next()) {
                    var buffer = buffers_1_1.value;
                    buffer.push(value);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (buffers_1_1 && !buffers_1_1.done && (_a = buffers_1.return)) _a.call(buffers_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }, function () {
            while (buffers.length > 0) {
                subscriber.next(buffers.shift());
            }
            subscriber.complete();
        }));
    });
}
exports.bufferToggle = bufferToggle;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\bufferToggle.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\bufferWhen.js", {"../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","../util/noop":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\noop.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CbufferWhen.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bufferWhen = void 0;
var lift_1 = require("../util/lift");
var noop_1 = require("../util/noop");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var innerFrom_1 = require("../observable/innerFrom");
function bufferWhen(closingSelector) {
    return lift_1.operate(function (source, subscriber) {
        var buffer = null;
        var closingSubscriber = null;
        var openBuffer = function () {
            closingSubscriber === null || closingSubscriber === void 0 ? void 0 : closingSubscriber.unsubscribe();
            var b = buffer;
            buffer = [];
            b && subscriber.next(b);
            innerFrom_1.innerFrom(closingSelector()).subscribe((closingSubscriber = OperatorSubscriber_1.createOperatorSubscriber(subscriber, openBuffer, noop_1.noop)));
        };
        openBuffer();
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) { return buffer === null || buffer === void 0 ? void 0 : buffer.push(value); }, function () {
            buffer && subscriber.next(buffer);
            subscriber.complete();
        }, undefined, function () { return (buffer = closingSubscriber = null); }));
    });
}
exports.bufferWhen = bufferWhen;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\bufferWhen.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\catchError.js", {"../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CcatchError.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.catchError = void 0;
var innerFrom_1 = require("../observable/innerFrom");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var lift_1 = require("../util/lift");
function catchError(selector) {
    return lift_1.operate(function (source, subscriber) {
        var innerSub = null;
        var syncUnsub = false;
        var handledResult;
        innerSub = source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, undefined, undefined, function (err) {
            handledResult = innerFrom_1.innerFrom(selector(err, catchError(selector)(source)));
            if (innerSub) {
                innerSub.unsubscribe();
                innerSub = null;
                handledResult.subscribe(subscriber);
            }
            else {
                syncUnsub = true;
            }
        }));
        if (syncUnsub) {
            innerSub.unsubscribe();
            innerSub = null;
            handledResult.subscribe(subscriber);
        }
    });
}
exports.catchError = catchError;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\catchError.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\combineAll.js", {"./combineLatestAll":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\combineLatestAll.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CcombineAll.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.combineAll = void 0;
var combineLatestAll_1 = require("./combineLatestAll");
exports.combineAll = combineLatestAll_1.combineLatestAll;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\combineAll.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\combineLatest.js", {"../observable/combineLatest":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\combineLatest.js","../util/args":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\args.js","../util/argsOrArgArray":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\argsOrArgArray.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","../util/mapOneOrManyArgs":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\mapOneOrManyArgs.js","../util/pipe":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\pipe.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CcombineLatest.js
      return function (require, module, exports) {
"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.combineLatest = void 0;
var combineLatest_1 = require("../observable/combineLatest");
var lift_1 = require("../util/lift");
var argsOrArgArray_1 = require("../util/argsOrArgArray");
var mapOneOrManyArgs_1 = require("../util/mapOneOrManyArgs");
var pipe_1 = require("../util/pipe");
var args_1 = require("../util/args");
function combineLatest() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var resultSelector = args_1.popResultSelector(args);
    return resultSelector
        ? pipe_1.pipe(combineLatest.apply(void 0, __spreadArray([], __read(args))), mapOneOrManyArgs_1.mapOneOrManyArgs(resultSelector))
        : lift_1.operate(function (source, subscriber) {
            combineLatest_1.combineLatestInit(__spreadArray([source], __read(argsOrArgArray_1.argsOrArgArray(args))))(subscriber);
        });
}
exports.combineLatest = combineLatest;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\combineLatest.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\combineLatestAll.js", {"../observable/combineLatest":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\combineLatest.js","./joinAllInternals":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\joinAllInternals.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CcombineLatestAll.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.combineLatestAll = void 0;
var combineLatest_1 = require("../observable/combineLatest");
var joinAllInternals_1 = require("./joinAllInternals");
function combineLatestAll(project) {
    return joinAllInternals_1.joinAllInternals(combineLatest_1.combineLatest, project);
}
exports.combineLatestAll = combineLatestAll;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\combineLatestAll.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\combineLatestWith.js", {"./combineLatest":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\combineLatest.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CcombineLatestWith.js
      return function (require, module, exports) {
"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.combineLatestWith = void 0;
var combineLatest_1 = require("./combineLatest");
function combineLatestWith() {
    var otherSources = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        otherSources[_i] = arguments[_i];
    }
    return combineLatest_1.combineLatest.apply(void 0, __spreadArray([], __read(otherSources)));
}
exports.combineLatestWith = combineLatestWith;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\combineLatestWith.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\concat.js", {"../observable/from":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\from.js","../util/args":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\args.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./concatAll":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\concatAll.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cconcat.js
      return function (require, module, exports) {
"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.concat = void 0;
var lift_1 = require("../util/lift");
var concatAll_1 = require("./concatAll");
var args_1 = require("../util/args");
var from_1 = require("../observable/from");
function concat() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var scheduler = args_1.popScheduler(args);
    return lift_1.operate(function (source, subscriber) {
        concatAll_1.concatAll()(from_1.from(__spreadArray([source], __read(args)), scheduler)).subscribe(subscriber);
    });
}
exports.concat = concat;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\concat.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\concatAll.js", {"./mergeAll":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeAll.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CconcatAll.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.concatAll = void 0;
var mergeAll_1 = require("./mergeAll");
function concatAll() {
    return mergeAll_1.mergeAll(1);
}
exports.concatAll = concatAll;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\concatAll.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\concatMap.js", {"../util/isFunction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isFunction.js","./mergeMap":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeMap.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CconcatMap.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.concatMap = void 0;
var mergeMap_1 = require("./mergeMap");
var isFunction_1 = require("../util/isFunction");
function concatMap(project, resultSelector) {
    return isFunction_1.isFunction(resultSelector) ? mergeMap_1.mergeMap(project, resultSelector, 1) : mergeMap_1.mergeMap(project, 1);
}
exports.concatMap = concatMap;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\concatMap.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\concatMapTo.js", {"../util/isFunction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isFunction.js","./concatMap":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\concatMap.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CconcatMapTo.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.concatMapTo = void 0;
var concatMap_1 = require("./concatMap");
var isFunction_1 = require("../util/isFunction");
function concatMapTo(innerObservable, resultSelector) {
    return isFunction_1.isFunction(resultSelector) ? concatMap_1.concatMap(function () { return innerObservable; }, resultSelector) : concatMap_1.concatMap(function () { return innerObservable; });
}
exports.concatMapTo = concatMapTo;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\concatMapTo.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\concatWith.js", {"./concat":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\concat.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CconcatWith.js
      return function (require, module, exports) {
"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.concatWith = void 0;
var concat_1 = require("./concat");
function concatWith() {
    var otherSources = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        otherSources[_i] = arguments[_i];
    }
    return concat_1.concat.apply(void 0, __spreadArray([], __read(otherSources)));
}
exports.concatWith = concatWith;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\concatWith.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\connect.js", {"../Subject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subject.js","../observable/fromSubscribable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\fromSubscribable.js","../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cconnect.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.connect = void 0;
var Subject_1 = require("../Subject");
var innerFrom_1 = require("../observable/innerFrom");
var lift_1 = require("../util/lift");
var fromSubscribable_1 = require("../observable/fromSubscribable");
var DEFAULT_CONFIG = {
    connector: function () { return new Subject_1.Subject(); },
};
function connect(selector, config) {
    if (config === void 0) { config = DEFAULT_CONFIG; }
    var connector = config.connector;
    return lift_1.operate(function (source, subscriber) {
        var subject = connector();
        innerFrom_1.innerFrom(selector(fromSubscribable_1.fromSubscribable(subject))).subscribe(subscriber);
        subscriber.add(source.subscribe(subject));
    });
}
exports.connect = connect;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\connect.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\count.js", {"./reduce":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\reduce.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Ccount.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.count = void 0;
var reduce_1 = require("./reduce");
function count(predicate) {
    return reduce_1.reduce(function (total, value, i) { return (!predicate || predicate(value, i) ? total + 1 : total); }, 0);
}
exports.count = count;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\count.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\debounce.js", {"../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","../util/noop":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\noop.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cdebounce.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.debounce = void 0;
var lift_1 = require("../util/lift");
var noop_1 = require("../util/noop");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var innerFrom_1 = require("../observable/innerFrom");
function debounce(durationSelector) {
    return lift_1.operate(function (source, subscriber) {
        var hasValue = false;
        var lastValue = null;
        var durationSubscriber = null;
        var emit = function () {
            durationSubscriber === null || durationSubscriber === void 0 ? void 0 : durationSubscriber.unsubscribe();
            durationSubscriber = null;
            if (hasValue) {
                hasValue = false;
                var value = lastValue;
                lastValue = null;
                subscriber.next(value);
            }
        };
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            durationSubscriber === null || durationSubscriber === void 0 ? void 0 : durationSubscriber.unsubscribe();
            hasValue = true;
            lastValue = value;
            durationSubscriber = OperatorSubscriber_1.createOperatorSubscriber(subscriber, emit, noop_1.noop);
            innerFrom_1.innerFrom(durationSelector(value)).subscribe(durationSubscriber);
        }, function () {
            emit();
            subscriber.complete();
        }, undefined, function () {
            lastValue = durationSubscriber = null;
        }));
    });
}
exports.debounce = debounce;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\debounce.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\debounceTime.js", {"../scheduler/async":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\async.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CdebounceTime.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.debounceTime = void 0;
var async_1 = require("../scheduler/async");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function debounceTime(dueTime, scheduler) {
    if (scheduler === void 0) { scheduler = async_1.asyncScheduler; }
    return lift_1.operate(function (source, subscriber) {
        var activeTask = null;
        var lastValue = null;
        var lastTime = null;
        var emit = function () {
            if (activeTask) {
                activeTask.unsubscribe();
                activeTask = null;
                var value = lastValue;
                lastValue = null;
                subscriber.next(value);
            }
        };
        function emitWhenIdle() {
            var targetTime = lastTime + dueTime;
            var now = scheduler.now();
            if (now < targetTime) {
                activeTask = this.schedule(undefined, targetTime - now);
                subscriber.add(activeTask);
                return;
            }
            emit();
        }
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            lastValue = value;
            lastTime = scheduler.now();
            if (!activeTask) {
                activeTask = scheduler.schedule(emitWhenIdle, dueTime);
                subscriber.add(activeTask);
            }
        }, function () {
            emit();
            subscriber.complete();
        }, undefined, function () {
            lastValue = activeTask = null;
        }));
    });
}
exports.debounceTime = debounceTime;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\debounceTime.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\defaultIfEmpty.js", {"../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CdefaultIfEmpty.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultIfEmpty = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function defaultIfEmpty(defaultValue) {
    return lift_1.operate(function (source, subscriber) {
        var hasValue = false;
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            hasValue = true;
            subscriber.next(value);
        }, function () {
            if (!hasValue) {
                subscriber.next(defaultValue);
            }
            subscriber.complete();
        }));
    });
}
exports.defaultIfEmpty = defaultIfEmpty;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\defaultIfEmpty.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\delay.js", {"../observable/timer":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\timer.js","../scheduler/async":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\async.js","./delayWhen":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\delayWhen.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cdelay.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.delay = void 0;
var async_1 = require("../scheduler/async");
var delayWhen_1 = require("./delayWhen");
var timer_1 = require("../observable/timer");
function delay(due, scheduler) {
    if (scheduler === void 0) { scheduler = async_1.asyncScheduler; }
    var duration = timer_1.timer(due, scheduler);
    return delayWhen_1.delayWhen(function () { return duration; });
}
exports.delay = delay;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\delay.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\delayWhen.js", {"../observable/concat":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\concat.js","../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","./ignoreElements":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\ignoreElements.js","./mapTo":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mapTo.js","./mergeMap":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeMap.js","./take":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\take.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CdelayWhen.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.delayWhen = void 0;
var concat_1 = require("../observable/concat");
var take_1 = require("./take");
var ignoreElements_1 = require("./ignoreElements");
var mapTo_1 = require("./mapTo");
var mergeMap_1 = require("./mergeMap");
var innerFrom_1 = require("../observable/innerFrom");
function delayWhen(delayDurationSelector, subscriptionDelay) {
    if (subscriptionDelay) {
        return function (source) {
            return concat_1.concat(subscriptionDelay.pipe(take_1.take(1), ignoreElements_1.ignoreElements()), source.pipe(delayWhen(delayDurationSelector)));
        };
    }
    return mergeMap_1.mergeMap(function (value, index) { return innerFrom_1.innerFrom(delayDurationSelector(value, index)).pipe(take_1.take(1), mapTo_1.mapTo(value)); });
}
exports.delayWhen = delayWhen;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\delayWhen.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\dematerialize.js", {"../Notification":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Notification.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cdematerialize.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.dematerialize = void 0;
var Notification_1 = require("../Notification");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function dematerialize() {
    return lift_1.operate(function (source, subscriber) {
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (notification) { return Notification_1.observeNotification(notification, subscriber); }));
    });
}
exports.dematerialize = dematerialize;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\dematerialize.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\distinct.js", {"../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","../util/noop":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\noop.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cdistinct.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.distinct = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var noop_1 = require("../util/noop");
var innerFrom_1 = require("../observable/innerFrom");
function distinct(keySelector, flushes) {
    return lift_1.operate(function (source, subscriber) {
        var distinctKeys = new Set();
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            var key = keySelector ? keySelector(value) : value;
            if (!distinctKeys.has(key)) {
                distinctKeys.add(key);
                subscriber.next(value);
            }
        }));
        flushes && innerFrom_1.innerFrom(flushes).subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function () { return distinctKeys.clear(); }, noop_1.noop));
    });
}
exports.distinct = distinct;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\distinct.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\distinctUntilChanged.js", {"../util/identity":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\identity.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CdistinctUntilChanged.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.distinctUntilChanged = void 0;
var identity_1 = require("../util/identity");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function distinctUntilChanged(comparator, keySelector) {
    if (keySelector === void 0) { keySelector = identity_1.identity; }
    comparator = comparator !== null && comparator !== void 0 ? comparator : defaultCompare;
    return lift_1.operate(function (source, subscriber) {
        var previousKey;
        var first = true;
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            var currentKey = keySelector(value);
            if (first || !comparator(previousKey, currentKey)) {
                first = false;
                previousKey = currentKey;
                subscriber.next(value);
            }
        }));
    });
}
exports.distinctUntilChanged = distinctUntilChanged;
function defaultCompare(a, b) {
    return a === b;
}

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\distinctUntilChanged.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\distinctUntilKeyChanged.js", {"./distinctUntilChanged":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\distinctUntilChanged.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CdistinctUntilKeyChanged.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.distinctUntilKeyChanged = void 0;
var distinctUntilChanged_1 = require("./distinctUntilChanged");
function distinctUntilKeyChanged(key, compare) {
    return distinctUntilChanged_1.distinctUntilChanged(function (x, y) { return compare ? compare(x[key], y[key]) : x[key] === y[key]; });
}
exports.distinctUntilKeyChanged = distinctUntilKeyChanged;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\distinctUntilKeyChanged.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\elementAt.js", {"../util/ArgumentOutOfRangeError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\ArgumentOutOfRangeError.js","./defaultIfEmpty":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\defaultIfEmpty.js","./filter":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\filter.js","./take":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\take.js","./throwIfEmpty":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\throwIfEmpty.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CelementAt.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.elementAt = void 0;
var ArgumentOutOfRangeError_1 = require("../util/ArgumentOutOfRangeError");
var filter_1 = require("./filter");
var throwIfEmpty_1 = require("./throwIfEmpty");
var defaultIfEmpty_1 = require("./defaultIfEmpty");
var take_1 = require("./take");
function elementAt(index, defaultValue) {
    if (index < 0) {
        throw new ArgumentOutOfRangeError_1.ArgumentOutOfRangeError();
    }
    var hasDefaultValue = arguments.length >= 2;
    return function (source) {
        return source.pipe(filter_1.filter(function (v, i) { return i === index; }), take_1.take(1), hasDefaultValue ? defaultIfEmpty_1.defaultIfEmpty(defaultValue) : throwIfEmpty_1.throwIfEmpty(function () { return new ArgumentOutOfRangeError_1.ArgumentOutOfRangeError(); }));
    };
}
exports.elementAt = elementAt;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\elementAt.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\endWith.js", {"../observable/concat":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\concat.js","../observable/of":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\of.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CendWith.js
      return function (require, module, exports) {
"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.endWith = void 0;
var concat_1 = require("../observable/concat");
var of_1 = require("../observable/of");
function endWith() {
    var values = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        values[_i] = arguments[_i];
    }
    return function (source) { return concat_1.concat(source, of_1.of.apply(void 0, __spreadArray([], __read(values)))); };
}
exports.endWith = endWith;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\endWith.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\every.js", {"../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cevery.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.every = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function every(predicate, thisArg) {
    return lift_1.operate(function (source, subscriber) {
        var index = 0;
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            if (!predicate.call(thisArg, value, index++, source)) {
                subscriber.next(false);
                subscriber.complete();
            }
        }, function () {
            subscriber.next(true);
            subscriber.complete();
        }));
    });
}
exports.every = every;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\every.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\exhaust.js", {"./exhaustAll":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\exhaustAll.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cexhaust.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.exhaust = void 0;
var exhaustAll_1 = require("./exhaustAll");
exports.exhaust = exhaustAll_1.exhaustAll;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\exhaust.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\exhaustAll.js", {"../util/identity":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\identity.js","./exhaustMap":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\exhaustMap.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CexhaustAll.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.exhaustAll = void 0;
var exhaustMap_1 = require("./exhaustMap");
var identity_1 = require("../util/identity");
function exhaustAll() {
    return exhaustMap_1.exhaustMap(identity_1.identity);
}
exports.exhaustAll = exhaustAll;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\exhaustAll.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\exhaustMap.js", {"../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js","./map":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\map.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CexhaustMap.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.exhaustMap = void 0;
var map_1 = require("./map");
var innerFrom_1 = require("../observable/innerFrom");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function exhaustMap(project, resultSelector) {
    if (resultSelector) {
        return function (source) {
            return source.pipe(exhaustMap(function (a, i) { return innerFrom_1.innerFrom(project(a, i)).pipe(map_1.map(function (b, ii) { return resultSelector(a, b, i, ii); })); }));
        };
    }
    return lift_1.operate(function (source, subscriber) {
        var index = 0;
        var innerSub = null;
        var isComplete = false;
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (outerValue) {
            if (!innerSub) {
                innerSub = OperatorSubscriber_1.createOperatorSubscriber(subscriber, undefined, function () {
                    innerSub = null;
                    isComplete && subscriber.complete();
                });
                innerFrom_1.innerFrom(project(outerValue, index++)).subscribe(innerSub);
            }
        }, function () {
            isComplete = true;
            !innerSub && subscriber.complete();
        }));
    });
}
exports.exhaustMap = exhaustMap;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\exhaustMap.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\expand.js", {"../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./mergeInternals":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeInternals.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cexpand.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.expand = void 0;
var lift_1 = require("../util/lift");
var mergeInternals_1 = require("./mergeInternals");
function expand(project, concurrent, scheduler) {
    if (concurrent === void 0) { concurrent = Infinity; }
    concurrent = (concurrent || 0) < 1 ? Infinity : concurrent;
    return lift_1.operate(function (source, subscriber) {
        return mergeInternals_1.mergeInternals(source, subscriber, project, concurrent, undefined, true, scheduler);
    });
}
exports.expand = expand;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\expand.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\filter.js", {"../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cfilter.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.filter = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function filter(predicate, thisArg) {
    return lift_1.operate(function (source, subscriber) {
        var index = 0;
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) { return predicate.call(thisArg, value, index++) && subscriber.next(value); }));
    });
}
exports.filter = filter;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\filter.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\finalize.js", {"../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cfinalize.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.finalize = void 0;
var lift_1 = require("../util/lift");
function finalize(callback) {
    return lift_1.operate(function (source, subscriber) {
        try {
            source.subscribe(subscriber);
        }
        finally {
            subscriber.add(callback);
        }
    });
}
exports.finalize = finalize;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\finalize.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\find.js", {"../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cfind.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createFind = exports.find = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function find(predicate, thisArg) {
    return lift_1.operate(createFind(predicate, thisArg, 'value'));
}
exports.find = find;
function createFind(predicate, thisArg, emit) {
    var findIndex = emit === 'index';
    return function (source, subscriber) {
        var index = 0;
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            var i = index++;
            if (predicate.call(thisArg, value, i, source)) {
                subscriber.next(findIndex ? i : value);
                subscriber.complete();
            }
        }, function () {
            subscriber.next(findIndex ? -1 : undefined);
            subscriber.complete();
        }));
    };
}
exports.createFind = createFind;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\find.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\findIndex.js", {"../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./find":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\find.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CfindIndex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findIndex = void 0;
var lift_1 = require("../util/lift");
var find_1 = require("./find");
function findIndex(predicate, thisArg) {
    return lift_1.operate(find_1.createFind(predicate, thisArg, 'index'));
}
exports.findIndex = findIndex;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\findIndex.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\first.js", {"../util/EmptyError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\EmptyError.js","../util/identity":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\identity.js","./defaultIfEmpty":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\defaultIfEmpty.js","./filter":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\filter.js","./take":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\take.js","./throwIfEmpty":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\throwIfEmpty.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cfirst.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.first = void 0;
var EmptyError_1 = require("../util/EmptyError");
var filter_1 = require("./filter");
var take_1 = require("./take");
var defaultIfEmpty_1 = require("./defaultIfEmpty");
var throwIfEmpty_1 = require("./throwIfEmpty");
var identity_1 = require("../util/identity");
function first(predicate, defaultValue) {
    var hasDefaultValue = arguments.length >= 2;
    return function (source) {
        return source.pipe(predicate ? filter_1.filter(function (v, i) { return predicate(v, i, source); }) : identity_1.identity, take_1.take(1), hasDefaultValue ? defaultIfEmpty_1.defaultIfEmpty(defaultValue) : throwIfEmpty_1.throwIfEmpty(function () { return new EmptyError_1.EmptyError(); }));
    };
}
exports.first = first;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\first.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\flatMap.js", {"./mergeMap":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeMap.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CflatMap.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.flatMap = void 0;
var mergeMap_1 = require("./mergeMap");
exports.flatMap = mergeMap_1.mergeMap;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\flatMap.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\groupBy.js", {"../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","../Subject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subject.js","../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CgroupBy.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.groupBy = void 0;
var Observable_1 = require("../Observable");
var innerFrom_1 = require("../observable/innerFrom");
var Subject_1 = require("../Subject");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function groupBy(keySelector, elementOrOptions, duration, connector) {
    return lift_1.operate(function (source, subscriber) {
        var element;
        if (!elementOrOptions || typeof elementOrOptions === 'function') {
            element = elementOrOptions;
        }
        else {
            (duration = elementOrOptions.duration, element = elementOrOptions.element, connector = elementOrOptions.connector);
        }
        var groups = new Map();
        var notify = function (cb) {
            groups.forEach(cb);
            cb(subscriber);
        };
        var handleError = function (err) { return notify(function (consumer) { return consumer.error(err); }); };
        var activeGroups = 0;
        var teardownAttempted = false;
        var groupBySourceSubscriber = new OperatorSubscriber_1.OperatorSubscriber(subscriber, function (value) {
            try {
                var key_1 = keySelector(value);
                var group_1 = groups.get(key_1);
                if (!group_1) {
                    groups.set(key_1, (group_1 = connector ? connector() : new Subject_1.Subject()));
                    var grouped = createGroupedObservable(key_1, group_1);
                    subscriber.next(grouped);
                    if (duration) {
                        var durationSubscriber_1 = OperatorSubscriber_1.createOperatorSubscriber(group_1, function () {
                            group_1.complete();
                            durationSubscriber_1 === null || durationSubscriber_1 === void 0 ? void 0 : durationSubscriber_1.unsubscribe();
                        }, undefined, undefined, function () { return groups.delete(key_1); });
                        groupBySourceSubscriber.add(innerFrom_1.innerFrom(duration(grouped)).subscribe(durationSubscriber_1));
                    }
                }
                group_1.next(element ? element(value) : value);
            }
            catch (err) {
                handleError(err);
            }
        }, function () { return notify(function (consumer) { return consumer.complete(); }); }, handleError, function () { return groups.clear(); }, function () {
            teardownAttempted = true;
            return activeGroups === 0;
        });
        source.subscribe(groupBySourceSubscriber);
        function createGroupedObservable(key, groupSubject) {
            var result = new Observable_1.Observable(function (groupSubscriber) {
                activeGroups++;
                var innerSub = groupSubject.subscribe(groupSubscriber);
                return function () {
                    innerSub.unsubscribe();
                    --activeGroups === 0 && teardownAttempted && groupBySourceSubscriber.unsubscribe();
                };
            });
            result.key = key;
            return result;
        }
    });
}
exports.groupBy = groupBy;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\groupBy.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\ignoreElements.js", {"../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","../util/noop":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\noop.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CignoreElements.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ignoreElements = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var noop_1 = require("../util/noop");
function ignoreElements() {
    return lift_1.operate(function (source, subscriber) {
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, noop_1.noop));
    });
}
exports.ignoreElements = ignoreElements;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\ignoreElements.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\isEmpty.js", {"../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CisEmpty.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isEmpty = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function isEmpty() {
    return lift_1.operate(function (source, subscriber) {
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function () {
            subscriber.next(false);
            subscriber.complete();
        }, function () {
            subscriber.next(true);
            subscriber.complete();
        }));
    });
}
exports.isEmpty = isEmpty;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\isEmpty.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\joinAllInternals.js", {"../util/identity":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\identity.js","../util/mapOneOrManyArgs":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\mapOneOrManyArgs.js","../util/pipe":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\pipe.js","./mergeMap":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeMap.js","./toArray":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\toArray.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CjoinAllInternals.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.joinAllInternals = void 0;
var identity_1 = require("../util/identity");
var mapOneOrManyArgs_1 = require("../util/mapOneOrManyArgs");
var pipe_1 = require("../util/pipe");
var mergeMap_1 = require("./mergeMap");
var toArray_1 = require("./toArray");
function joinAllInternals(joinFn, project) {
    return pipe_1.pipe(toArray_1.toArray(), mergeMap_1.mergeMap(function (sources) { return joinFn(sources); }), project ? mapOneOrManyArgs_1.mapOneOrManyArgs(project) : identity_1.identity);
}
exports.joinAllInternals = joinAllInternals;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\joinAllInternals.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\last.js", {"../util/EmptyError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\EmptyError.js","../util/identity":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\identity.js","./defaultIfEmpty":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\defaultIfEmpty.js","./filter":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\filter.js","./takeLast":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\takeLast.js","./throwIfEmpty":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\throwIfEmpty.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Clast.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.last = void 0;
var EmptyError_1 = require("../util/EmptyError");
var filter_1 = require("./filter");
var takeLast_1 = require("./takeLast");
var throwIfEmpty_1 = require("./throwIfEmpty");
var defaultIfEmpty_1 = require("./defaultIfEmpty");
var identity_1 = require("../util/identity");
function last(predicate, defaultValue) {
    var hasDefaultValue = arguments.length >= 2;
    return function (source) {
        return source.pipe(predicate ? filter_1.filter(function (v, i) { return predicate(v, i, source); }) : identity_1.identity, takeLast_1.takeLast(1), hasDefaultValue ? defaultIfEmpty_1.defaultIfEmpty(defaultValue) : throwIfEmpty_1.throwIfEmpty(function () { return new EmptyError_1.EmptyError(); }));
    };
}
exports.last = last;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\last.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\map.js", {"../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cmap.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.map = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function map(project, thisArg) {
    return lift_1.operate(function (source, subscriber) {
        var index = 0;
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            subscriber.next(project.call(thisArg, value, index++));
        }));
    });
}
exports.map = map;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\map.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mapTo.js", {"./map":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\map.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CmapTo.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapTo = void 0;
var map_1 = require("./map");
function mapTo(value) {
    return map_1.map(function () { return value; });
}
exports.mapTo = mapTo;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mapTo.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\materialize.js", {"../Notification":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Notification.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cmaterialize.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.materialize = void 0;
var Notification_1 = require("../Notification");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function materialize() {
    return lift_1.operate(function (source, subscriber) {
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            subscriber.next(Notification_1.Notification.createNext(value));
        }, function () {
            subscriber.next(Notification_1.Notification.createComplete());
            subscriber.complete();
        }, function (err) {
            subscriber.next(Notification_1.Notification.createError(err));
            subscriber.complete();
        }));
    });
}
exports.materialize = materialize;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\materialize.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\max.js", {"../util/isFunction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isFunction.js","./reduce":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\reduce.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cmax.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.max = void 0;
var reduce_1 = require("./reduce");
var isFunction_1 = require("../util/isFunction");
function max(comparer) {
    return reduce_1.reduce(isFunction_1.isFunction(comparer) ? function (x, y) { return (comparer(x, y) > 0 ? x : y); } : function (x, y) { return (x > y ? x : y); });
}
exports.max = max;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\max.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\merge.js", {"../observable/from":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\from.js","../util/args":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\args.js","../util/argsOrArgArray":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\argsOrArgArray.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./mergeAll":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeAll.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cmerge.js
      return function (require, module, exports) {
"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.merge = void 0;
var lift_1 = require("../util/lift");
var argsOrArgArray_1 = require("../util/argsOrArgArray");
var mergeAll_1 = require("./mergeAll");
var args_1 = require("../util/args");
var from_1 = require("../observable/from");
function merge() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var scheduler = args_1.popScheduler(args);
    var concurrent = args_1.popNumber(args, Infinity);
    args = argsOrArgArray_1.argsOrArgArray(args);
    return lift_1.operate(function (source, subscriber) {
        mergeAll_1.mergeAll(concurrent)(from_1.from(__spreadArray([source], __read(args)), scheduler)).subscribe(subscriber);
    });
}
exports.merge = merge;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\merge.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeAll.js", {"../util/identity":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\identity.js","./mergeMap":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeMap.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CmergeAll.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeAll = void 0;
var mergeMap_1 = require("./mergeMap");
var identity_1 = require("../util/identity");
function mergeAll(concurrent) {
    if (concurrent === void 0) { concurrent = Infinity; }
    return mergeMap_1.mergeMap(identity_1.identity, concurrent);
}
exports.mergeAll = mergeAll;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeAll.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeInternals.js", {"../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/executeSchedule":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\executeSchedule.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CmergeInternals.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeInternals = void 0;
var innerFrom_1 = require("../observable/innerFrom");
var executeSchedule_1 = require("../util/executeSchedule");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function mergeInternals(source, subscriber, project, concurrent, onBeforeNext, expand, innerSubScheduler, additionalFinalizer) {
    var buffer = [];
    var active = 0;
    var index = 0;
    var isComplete = false;
    var checkComplete = function () {
        if (isComplete && !buffer.length && !active) {
            subscriber.complete();
        }
    };
    var outerNext = function (value) { return (active < concurrent ? doInnerSub(value) : buffer.push(value)); };
    var doInnerSub = function (value) {
        expand && subscriber.next(value);
        active++;
        var innerComplete = false;
        innerFrom_1.innerFrom(project(value, index++)).subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (innerValue) {
            onBeforeNext === null || onBeforeNext === void 0 ? void 0 : onBeforeNext(innerValue);
            if (expand) {
                outerNext(innerValue);
            }
            else {
                subscriber.next(innerValue);
            }
        }, function () {
            innerComplete = true;
        }, undefined, function () {
            if (innerComplete) {
                try {
                    active--;
                    var _loop_1 = function () {
                        var bufferedValue = buffer.shift();
                        if (innerSubScheduler) {
                            executeSchedule_1.executeSchedule(subscriber, innerSubScheduler, function () { return doInnerSub(bufferedValue); });
                        }
                        else {
                            doInnerSub(bufferedValue);
                        }
                    };
                    while (buffer.length && active < concurrent) {
                        _loop_1();
                    }
                    checkComplete();
                }
                catch (err) {
                    subscriber.error(err);
                }
            }
        }));
    };
    source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, outerNext, function () {
        isComplete = true;
        checkComplete();
    }));
    return function () {
        additionalFinalizer === null || additionalFinalizer === void 0 ? void 0 : additionalFinalizer();
    };
}
exports.mergeInternals = mergeInternals;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeInternals.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeMap.js", {"../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/isFunction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isFunction.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./map":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\map.js","./mergeInternals":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeInternals.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CmergeMap.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeMap = void 0;
var map_1 = require("./map");
var innerFrom_1 = require("../observable/innerFrom");
var lift_1 = require("../util/lift");
var mergeInternals_1 = require("./mergeInternals");
var isFunction_1 = require("../util/isFunction");
function mergeMap(project, resultSelector, concurrent) {
    if (concurrent === void 0) { concurrent = Infinity; }
    if (isFunction_1.isFunction(resultSelector)) {
        return mergeMap(function (a, i) { return map_1.map(function (b, ii) { return resultSelector(a, b, i, ii); })(innerFrom_1.innerFrom(project(a, i))); }, concurrent);
    }
    else if (typeof resultSelector === 'number') {
        concurrent = resultSelector;
    }
    return lift_1.operate(function (source, subscriber) { return mergeInternals_1.mergeInternals(source, subscriber, project, concurrent); });
}
exports.mergeMap = mergeMap;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeMap.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeMapTo.js", {"../util/isFunction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isFunction.js","./mergeMap":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeMap.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CmergeMapTo.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeMapTo = void 0;
var mergeMap_1 = require("./mergeMap");
var isFunction_1 = require("../util/isFunction");
function mergeMapTo(innerObservable, resultSelector, concurrent) {
    if (concurrent === void 0) { concurrent = Infinity; }
    if (isFunction_1.isFunction(resultSelector)) {
        return mergeMap_1.mergeMap(function () { return innerObservable; }, resultSelector, concurrent);
    }
    if (typeof resultSelector === 'number') {
        concurrent = resultSelector;
    }
    return mergeMap_1.mergeMap(function () { return innerObservable; }, concurrent);
}
exports.mergeMapTo = mergeMapTo;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeMapTo.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeScan.js", {"../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./mergeInternals":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeInternals.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CmergeScan.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeScan = void 0;
var lift_1 = require("../util/lift");
var mergeInternals_1 = require("./mergeInternals");
function mergeScan(accumulator, seed, concurrent) {
    if (concurrent === void 0) { concurrent = Infinity; }
    return lift_1.operate(function (source, subscriber) {
        var state = seed;
        return mergeInternals_1.mergeInternals(source, subscriber, function (value, index) { return accumulator(state, value, index); }, concurrent, function (value) {
            state = value;
        }, false, undefined, function () { return (state = null); });
    });
}
exports.mergeScan = mergeScan;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeScan.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeWith.js", {"./merge":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\merge.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CmergeWith.js
      return function (require, module, exports) {
"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeWith = void 0;
var merge_1 = require("./merge");
function mergeWith() {
    var otherSources = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        otherSources[_i] = arguments[_i];
    }
    return merge_1.merge.apply(void 0, __spreadArray([], __read(otherSources)));
}
exports.mergeWith = mergeWith;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\mergeWith.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\min.js", {"../util/isFunction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isFunction.js","./reduce":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\reduce.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cmin.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.min = void 0;
var reduce_1 = require("./reduce");
var isFunction_1 = require("../util/isFunction");
function min(comparer) {
    return reduce_1.reduce(isFunction_1.isFunction(comparer) ? function (x, y) { return (comparer(x, y) < 0 ? x : y); } : function (x, y) { return (x < y ? x : y); });
}
exports.min = min;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\min.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\multicast.js", {"../observable/ConnectableObservable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\ConnectableObservable.js","../util/isFunction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isFunction.js","./connect":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\connect.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cmulticast.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.multicast = void 0;
var ConnectableObservable_1 = require("../observable/ConnectableObservable");
var isFunction_1 = require("../util/isFunction");
var connect_1 = require("./connect");
function multicast(subjectOrSubjectFactory, selector) {
    var subjectFactory = isFunction_1.isFunction(subjectOrSubjectFactory) ? subjectOrSubjectFactory : function () { return subjectOrSubjectFactory; };
    if (isFunction_1.isFunction(selector)) {
        return connect_1.connect(selector, {
            connector: subjectFactory,
        });
    }
    return function (source) { return new ConnectableObservable_1.ConnectableObservable(source, subjectFactory); };
}
exports.multicast = multicast;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\multicast.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\observeOn.js", {"../util/executeSchedule":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\executeSchedule.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CobserveOn.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.observeOn = void 0;
var executeSchedule_1 = require("../util/executeSchedule");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function observeOn(scheduler, delay) {
    if (delay === void 0) { delay = 0; }
    return lift_1.operate(function (source, subscriber) {
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) { return executeSchedule_1.executeSchedule(subscriber, scheduler, function () { return subscriber.next(value); }, delay); }, function () { return executeSchedule_1.executeSchedule(subscriber, scheduler, function () { return subscriber.complete(); }, delay); }, function (err) { return executeSchedule_1.executeSchedule(subscriber, scheduler, function () { return subscriber.error(err); }, delay); }));
    });
}
exports.observeOn = observeOn;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\observeOn.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\onErrorResumeNextWith.js", {"../observable/onErrorResumeNext":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\onErrorResumeNext.js","../util/argsOrArgArray":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\argsOrArgArray.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5ConErrorResumeNextWith.js
      return function (require, module, exports) {
"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.onErrorResumeNext = exports.onErrorResumeNextWith = void 0;
var argsOrArgArray_1 = require("../util/argsOrArgArray");
var onErrorResumeNext_1 = require("../observable/onErrorResumeNext");
function onErrorResumeNextWith() {
    var sources = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        sources[_i] = arguments[_i];
    }
    var nextSources = argsOrArgArray_1.argsOrArgArray(sources);
    return function (source) { return onErrorResumeNext_1.onErrorResumeNext.apply(void 0, __spreadArray([source], __read(nextSources))); };
}
exports.onErrorResumeNextWith = onErrorResumeNextWith;
exports.onErrorResumeNext = onErrorResumeNextWith;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\onErrorResumeNextWith.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\pairwise.js", {"../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cpairwise.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pairwise = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function pairwise() {
    return lift_1.operate(function (source, subscriber) {
        var prev;
        var hasPrev = false;
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            var p = prev;
            prev = value;
            hasPrev && subscriber.next([p, value]);
            hasPrev = true;
        }));
    });
}
exports.pairwise = pairwise;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\pairwise.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\pluck.js", {"./map":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\map.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cpluck.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pluck = void 0;
var map_1 = require("./map");
function pluck() {
    var properties = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        properties[_i] = arguments[_i];
    }
    var length = properties.length;
    if (length === 0) {
        throw new Error('list of properties cannot be empty.');
    }
    return map_1.map(function (x) {
        var currentProp = x;
        for (var i = 0; i < length; i++) {
            var p = currentProp === null || currentProp === void 0 ? void 0 : currentProp[properties[i]];
            if (typeof p !== 'undefined') {
                currentProp = p;
            }
            else {
                return undefined;
            }
        }
        return currentProp;
    });
}
exports.pluck = pluck;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\pluck.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\publish.js", {"../Subject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subject.js","./connect":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\connect.js","./multicast":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\multicast.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cpublish.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.publish = void 0;
var Subject_1 = require("../Subject");
var multicast_1 = require("./multicast");
var connect_1 = require("./connect");
function publish(selector) {
    return selector ? function (source) { return connect_1.connect(selector)(source); } : function (source) { return multicast_1.multicast(new Subject_1.Subject())(source); };
}
exports.publish = publish;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\publish.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\publishBehavior.js", {"../BehaviorSubject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\BehaviorSubject.js","../observable/ConnectableObservable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\ConnectableObservable.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CpublishBehavior.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.publishBehavior = void 0;
var BehaviorSubject_1 = require("../BehaviorSubject");
var ConnectableObservable_1 = require("../observable/ConnectableObservable");
function publishBehavior(initialValue) {
    return function (source) {
        var subject = new BehaviorSubject_1.BehaviorSubject(initialValue);
        return new ConnectableObservable_1.ConnectableObservable(source, function () { return subject; });
    };
}
exports.publishBehavior = publishBehavior;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\publishBehavior.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\publishLast.js", {"../AsyncSubject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\AsyncSubject.js","../observable/ConnectableObservable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\ConnectableObservable.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CpublishLast.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.publishLast = void 0;
var AsyncSubject_1 = require("../AsyncSubject");
var ConnectableObservable_1 = require("../observable/ConnectableObservable");
function publishLast() {
    return function (source) {
        var subject = new AsyncSubject_1.AsyncSubject();
        return new ConnectableObservable_1.ConnectableObservable(source, function () { return subject; });
    };
}
exports.publishLast = publishLast;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\publishLast.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\publishReplay.js", {"../ReplaySubject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\ReplaySubject.js","../util/isFunction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isFunction.js","./multicast":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\multicast.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CpublishReplay.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.publishReplay = void 0;
var ReplaySubject_1 = require("../ReplaySubject");
var multicast_1 = require("./multicast");
var isFunction_1 = require("../util/isFunction");
function publishReplay(bufferSize, windowTime, selectorOrScheduler, timestampProvider) {
    if (selectorOrScheduler && !isFunction_1.isFunction(selectorOrScheduler)) {
        timestampProvider = selectorOrScheduler;
    }
    var selector = isFunction_1.isFunction(selectorOrScheduler) ? selectorOrScheduler : undefined;
    return function (source) { return multicast_1.multicast(new ReplaySubject_1.ReplaySubject(bufferSize, windowTime, timestampProvider), selector)(source); };
}
exports.publishReplay = publishReplay;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\publishReplay.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\raceWith.js", {"../observable/race":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\race.js","../util/identity":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\identity.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CraceWith.js
      return function (require, module, exports) {
"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.raceWith = void 0;
var race_1 = require("../observable/race");
var lift_1 = require("../util/lift");
var identity_1 = require("../util/identity");
function raceWith() {
    var otherSources = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        otherSources[_i] = arguments[_i];
    }
    return !otherSources.length
        ? identity_1.identity
        : lift_1.operate(function (source, subscriber) {
            race_1.raceInit(__spreadArray([source], __read(otherSources)))(subscriber);
        });
}
exports.raceWith = raceWith;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\raceWith.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\reduce.js", {"../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./scanInternals":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\scanInternals.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Creduce.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.reduce = void 0;
var scanInternals_1 = require("./scanInternals");
var lift_1 = require("../util/lift");
function reduce(accumulator, seed) {
    return lift_1.operate(scanInternals_1.scanInternals(accumulator, seed, arguments.length >= 2, false, true));
}
exports.reduce = reduce;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\reduce.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\refCount.js", {"../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CrefCount.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.refCount = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function refCount() {
    return lift_1.operate(function (source, subscriber) {
        var connection = null;
        source._refCount++;
        var refCounter = OperatorSubscriber_1.createOperatorSubscriber(subscriber, undefined, undefined, undefined, function () {
            if (!source || source._refCount <= 0 || 0 < --source._refCount) {
                connection = null;
                return;
            }
            var sharedConnection = source._connection;
            var conn = connection;
            connection = null;
            if (sharedConnection && (!conn || sharedConnection === conn)) {
                sharedConnection.unsubscribe();
            }
            subscriber.unsubscribe();
        });
        source.subscribe(refCounter);
        if (!refCounter.closed) {
            connection = source.connect();
        }
    });
}
exports.refCount = refCount;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\refCount.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\repeat.js", {"../observable/empty":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\empty.js","../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../observable/timer":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\timer.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Crepeat.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.repeat = void 0;
var empty_1 = require("../observable/empty");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var innerFrom_1 = require("../observable/innerFrom");
var timer_1 = require("../observable/timer");
function repeat(countOrConfig) {
    var _a;
    var count = Infinity;
    var delay;
    if (countOrConfig != null) {
        if (typeof countOrConfig === 'object') {
            (_a = countOrConfig.count, count = _a === void 0 ? Infinity : _a, delay = countOrConfig.delay);
        }
        else {
            count = countOrConfig;
        }
    }
    return count <= 0
        ? function () { return empty_1.EMPTY; }
        : lift_1.operate(function (source, subscriber) {
            var soFar = 0;
            var sourceSub;
            var resubscribe = function () {
                sourceSub === null || sourceSub === void 0 ? void 0 : sourceSub.unsubscribe();
                sourceSub = null;
                if (delay != null) {
                    var notifier = typeof delay === 'number' ? timer_1.timer(delay) : innerFrom_1.innerFrom(delay(soFar));
                    var notifierSubscriber_1 = OperatorSubscriber_1.createOperatorSubscriber(subscriber, function () {
                        notifierSubscriber_1.unsubscribe();
                        subscribeToSource();
                    });
                    notifier.subscribe(notifierSubscriber_1);
                }
                else {
                    subscribeToSource();
                }
            };
            var subscribeToSource = function () {
                var syncUnsub = false;
                sourceSub = source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, undefined, function () {
                    if (++soFar < count) {
                        if (sourceSub) {
                            resubscribe();
                        }
                        else {
                            syncUnsub = true;
                        }
                    }
                    else {
                        subscriber.complete();
                    }
                }));
                if (syncUnsub) {
                    resubscribe();
                }
            };
            subscribeToSource();
        });
}
exports.repeat = repeat;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\repeat.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\repeatWhen.js", {"../Subject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subject.js","../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CrepeatWhen.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.repeatWhen = void 0;
var innerFrom_1 = require("../observable/innerFrom");
var Subject_1 = require("../Subject");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function repeatWhen(notifier) {
    return lift_1.operate(function (source, subscriber) {
        var innerSub;
        var syncResub = false;
        var completions$;
        var isNotifierComplete = false;
        var isMainComplete = false;
        var checkComplete = function () { return isMainComplete && isNotifierComplete && (subscriber.complete(), true); };
        var getCompletionSubject = function () {
            if (!completions$) {
                completions$ = new Subject_1.Subject();
                innerFrom_1.innerFrom(notifier(completions$)).subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function () {
                    if (innerSub) {
                        subscribeForRepeatWhen();
                    }
                    else {
                        syncResub = true;
                    }
                }, function () {
                    isNotifierComplete = true;
                    checkComplete();
                }));
            }
            return completions$;
        };
        var subscribeForRepeatWhen = function () {
            isMainComplete = false;
            innerSub = source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, undefined, function () {
                isMainComplete = true;
                !checkComplete() && getCompletionSubject().next();
            }));
            if (syncResub) {
                innerSub.unsubscribe();
                innerSub = null;
                syncResub = false;
                subscribeForRepeatWhen();
            }
        };
        subscribeForRepeatWhen();
    });
}
exports.repeatWhen = repeatWhen;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\repeatWhen.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\retry.js", {"../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../observable/timer":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\timer.js","../util/identity":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\identity.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cretry.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.retry = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var identity_1 = require("../util/identity");
var timer_1 = require("../observable/timer");
var innerFrom_1 = require("../observable/innerFrom");
function retry(configOrCount) {
    if (configOrCount === void 0) { configOrCount = Infinity; }
    var config;
    if (configOrCount && typeof configOrCount === 'object') {
        config = configOrCount;
    }
    else {
        config = {
            count: configOrCount,
        };
    }
    var _a = config.count, count = _a === void 0 ? Infinity : _a, delay = config.delay, _b = config.resetOnSuccess, resetOnSuccess = _b === void 0 ? false : _b;
    return count <= 0
        ? identity_1.identity
        : lift_1.operate(function (source, subscriber) {
            var soFar = 0;
            var innerSub;
            var subscribeForRetry = function () {
                var syncUnsub = false;
                innerSub = source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
                    if (resetOnSuccess) {
                        soFar = 0;
                    }
                    subscriber.next(value);
                }, undefined, function (err) {
                    if (soFar++ < count) {
                        var resub_1 = function () {
                            if (innerSub) {
                                innerSub.unsubscribe();
                                innerSub = null;
                                subscribeForRetry();
                            }
                            else {
                                syncUnsub = true;
                            }
                        };
                        if (delay != null) {
                            var notifier = typeof delay === 'number' ? timer_1.timer(delay) : innerFrom_1.innerFrom(delay(err, soFar));
                            var notifierSubscriber_1 = OperatorSubscriber_1.createOperatorSubscriber(subscriber, function () {
                                notifierSubscriber_1.unsubscribe();
                                resub_1();
                            }, function () {
                                subscriber.complete();
                            });
                            notifier.subscribe(notifierSubscriber_1);
                        }
                        else {
                            resub_1();
                        }
                    }
                    else {
                        subscriber.error(err);
                    }
                }));
                if (syncUnsub) {
                    innerSub.unsubscribe();
                    innerSub = null;
                    subscribeForRetry();
                }
            };
            subscribeForRetry();
        });
}
exports.retry = retry;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\retry.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\retryWhen.js", {"../Subject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subject.js","../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CretryWhen.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.retryWhen = void 0;
var innerFrom_1 = require("../observable/innerFrom");
var Subject_1 = require("../Subject");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function retryWhen(notifier) {
    return lift_1.operate(function (source, subscriber) {
        var innerSub;
        var syncResub = false;
        var errors$;
        var subscribeForRetryWhen = function () {
            innerSub = source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, undefined, undefined, function (err) {
                if (!errors$) {
                    errors$ = new Subject_1.Subject();
                    innerFrom_1.innerFrom(notifier(errors$)).subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function () {
                        return innerSub ? subscribeForRetryWhen() : (syncResub = true);
                    }));
                }
                if (errors$) {
                    errors$.next(err);
                }
            }));
            if (syncResub) {
                innerSub.unsubscribe();
                innerSub = null;
                syncResub = false;
                subscribeForRetryWhen();
            }
        };
        subscribeForRetryWhen();
    });
}
exports.retryWhen = retryWhen;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\retryWhen.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\sample.js", {"../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","../util/noop":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\noop.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Csample.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sample = void 0;
var innerFrom_1 = require("../observable/innerFrom");
var lift_1 = require("../util/lift");
var noop_1 = require("../util/noop");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function sample(notifier) {
    return lift_1.operate(function (source, subscriber) {
        var hasValue = false;
        var lastValue = null;
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            hasValue = true;
            lastValue = value;
        }));
        innerFrom_1.innerFrom(notifier).subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function () {
            if (hasValue) {
                hasValue = false;
                var value = lastValue;
                lastValue = null;
                subscriber.next(value);
            }
        }, noop_1.noop));
    });
}
exports.sample = sample;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\sample.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\sampleTime.js", {"../observable/interval":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\interval.js","../scheduler/async":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\async.js","./sample":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\sample.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CsampleTime.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sampleTime = void 0;
var async_1 = require("../scheduler/async");
var sample_1 = require("./sample");
var interval_1 = require("../observable/interval");
function sampleTime(period, scheduler) {
    if (scheduler === void 0) { scheduler = async_1.asyncScheduler; }
    return sample_1.sample(interval_1.interval(period, scheduler));
}
exports.sampleTime = sampleTime;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\sampleTime.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\scan.js", {"../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./scanInternals":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\scanInternals.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cscan.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.scan = void 0;
var lift_1 = require("../util/lift");
var scanInternals_1 = require("./scanInternals");
function scan(accumulator, seed) {
    return lift_1.operate(scanInternals_1.scanInternals(accumulator, seed, arguments.length >= 2, true));
}
exports.scan = scan;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\scan.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\scanInternals.js", {"./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CscanInternals.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.scanInternals = void 0;
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function scanInternals(accumulator, seed, hasSeed, emitOnNext, emitBeforeComplete) {
    return function (source, subscriber) {
        var hasState = hasSeed;
        var state = seed;
        var index = 0;
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            var i = index++;
            state = hasState
                ?
                    accumulator(state, value, i)
                :
                    ((hasState = true), value);
            emitOnNext && subscriber.next(state);
        }, emitBeforeComplete &&
            (function () {
                hasState && subscriber.next(state);
                subscriber.complete();
            })));
    };
}
exports.scanInternals = scanInternals;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\scanInternals.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\sequenceEqual.js", {"../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CsequenceEqual.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sequenceEqual = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var innerFrom_1 = require("../observable/innerFrom");
function sequenceEqual(compareTo, comparator) {
    if (comparator === void 0) { comparator = function (a, b) { return a === b; }; }
    return lift_1.operate(function (source, subscriber) {
        var aState = createState();
        var bState = createState();
        var emit = function (isEqual) {
            subscriber.next(isEqual);
            subscriber.complete();
        };
        var createSubscriber = function (selfState, otherState) {
            var sequenceEqualSubscriber = OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (a) {
                var buffer = otherState.buffer, complete = otherState.complete;
                if (buffer.length === 0) {
                    complete ? emit(false) : selfState.buffer.push(a);
                }
                else {
                    !comparator(a, buffer.shift()) && emit(false);
                }
            }, function () {
                selfState.complete = true;
                var complete = otherState.complete, buffer = otherState.buffer;
                complete && emit(buffer.length === 0);
                sequenceEqualSubscriber === null || sequenceEqualSubscriber === void 0 ? void 0 : sequenceEqualSubscriber.unsubscribe();
            });
            return sequenceEqualSubscriber;
        };
        source.subscribe(createSubscriber(aState, bState));
        innerFrom_1.innerFrom(compareTo).subscribe(createSubscriber(bState, aState));
    });
}
exports.sequenceEqual = sequenceEqual;
function createState() {
    return {
        buffer: [],
        complete: false,
    };
}

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\sequenceEqual.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\share.js", {"../Subject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subject.js","../Subscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subscriber.js","../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cshare.js
      return function (require, module, exports) {
"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.share = void 0;
var innerFrom_1 = require("../observable/innerFrom");
var Subject_1 = require("../Subject");
var Subscriber_1 = require("../Subscriber");
var lift_1 = require("../util/lift");
function share(options) {
    if (options === void 0) { options = {}; }
    var _a = options.connector, connector = _a === void 0 ? function () { return new Subject_1.Subject(); } : _a, _b = options.resetOnError, resetOnError = _b === void 0 ? true : _b, _c = options.resetOnComplete, resetOnComplete = _c === void 0 ? true : _c, _d = options.resetOnRefCountZero, resetOnRefCountZero = _d === void 0 ? true : _d;
    return function (wrapperSource) {
        var connection;
        var resetConnection;
        var subject;
        var refCount = 0;
        var hasCompleted = false;
        var hasErrored = false;
        var cancelReset = function () {
            resetConnection === null || resetConnection === void 0 ? void 0 : resetConnection.unsubscribe();
            resetConnection = undefined;
        };
        var reset = function () {
            cancelReset();
            connection = subject = undefined;
            hasCompleted = hasErrored = false;
        };
        var resetAndUnsubscribe = function () {
            var conn = connection;
            reset();
            conn === null || conn === void 0 ? void 0 : conn.unsubscribe();
        };
        return lift_1.operate(function (source, subscriber) {
            refCount++;
            if (!hasErrored && !hasCompleted) {
                cancelReset();
            }
            var dest = (subject = subject !== null && subject !== void 0 ? subject : connector());
            subscriber.add(function () {
                refCount--;
                if (refCount === 0 && !hasErrored && !hasCompleted) {
                    resetConnection = handleReset(resetAndUnsubscribe, resetOnRefCountZero);
                }
            });
            dest.subscribe(subscriber);
            if (!connection &&
                refCount > 0) {
                connection = new Subscriber_1.SafeSubscriber({
                    next: function (value) { return dest.next(value); },
                    error: function (err) {
                        hasErrored = true;
                        cancelReset();
                        resetConnection = handleReset(reset, resetOnError, err);
                        dest.error(err);
                    },
                    complete: function () {
                        hasCompleted = true;
                        cancelReset();
                        resetConnection = handleReset(reset, resetOnComplete);
                        dest.complete();
                    },
                });
                innerFrom_1.innerFrom(source).subscribe(connection);
            }
        })(wrapperSource);
    };
}
exports.share = share;
function handleReset(reset, on) {
    var args = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        args[_i - 2] = arguments[_i];
    }
    if (on === true) {
        reset();
        return;
    }
    if (on === false) {
        return;
    }
    var onSubscriber = new Subscriber_1.SafeSubscriber({
        next: function () {
            onSubscriber.unsubscribe();
            reset();
        },
    });
    return innerFrom_1.innerFrom(on.apply(void 0, __spreadArray([], __read(args)))).subscribe(onSubscriber);
}

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\share.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\shareReplay.js", {"../ReplaySubject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\ReplaySubject.js","./share":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\share.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CshareReplay.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.shareReplay = void 0;
var ReplaySubject_1 = require("../ReplaySubject");
var share_1 = require("./share");
function shareReplay(configOrBufferSize, windowTime, scheduler) {
    var _a, _b, _c;
    var bufferSize;
    var refCount = false;
    if (configOrBufferSize && typeof configOrBufferSize === 'object') {
        (_a = configOrBufferSize.bufferSize, bufferSize = _a === void 0 ? Infinity : _a, _b = configOrBufferSize.windowTime, windowTime = _b === void 0 ? Infinity : _b, _c = configOrBufferSize.refCount, refCount = _c === void 0 ? false : _c, scheduler = configOrBufferSize.scheduler);
    }
    else {
        bufferSize = (configOrBufferSize !== null && configOrBufferSize !== void 0 ? configOrBufferSize : Infinity);
    }
    return share_1.share({
        connector: function () { return new ReplaySubject_1.ReplaySubject(bufferSize, windowTime, scheduler); },
        resetOnError: true,
        resetOnComplete: false,
        resetOnRefCountZero: refCount,
    });
}
exports.shareReplay = shareReplay;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\shareReplay.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\single.js", {"../util/EmptyError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\EmptyError.js","../util/NotFoundError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\NotFoundError.js","../util/SequenceError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\SequenceError.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Csingle.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.single = void 0;
var EmptyError_1 = require("../util/EmptyError");
var SequenceError_1 = require("../util/SequenceError");
var NotFoundError_1 = require("../util/NotFoundError");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function single(predicate) {
    return lift_1.operate(function (source, subscriber) {
        var hasValue = false;
        var singleValue;
        var seenValue = false;
        var index = 0;
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            seenValue = true;
            if (!predicate || predicate(value, index++, source)) {
                hasValue && subscriber.error(new SequenceError_1.SequenceError('Too many matching values'));
                hasValue = true;
                singleValue = value;
            }
        }, function () {
            if (hasValue) {
                subscriber.next(singleValue);
                subscriber.complete();
            }
            else {
                subscriber.error(seenValue ? new NotFoundError_1.NotFoundError('No matching values') : new EmptyError_1.EmptyError());
            }
        }));
    });
}
exports.single = single;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\single.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\skip.js", {"./filter":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\filter.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cskip.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.skip = void 0;
var filter_1 = require("./filter");
function skip(count) {
    return filter_1.filter(function (_, index) { return count <= index; });
}
exports.skip = skip;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\skip.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\skipLast.js", {"../util/identity":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\identity.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CskipLast.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.skipLast = void 0;
var identity_1 = require("../util/identity");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function skipLast(skipCount) {
    return skipCount <= 0
        ?
            identity_1.identity
        : lift_1.operate(function (source, subscriber) {
            var ring = new Array(skipCount);
            var seen = 0;
            source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
                var valueIndex = seen++;
                if (valueIndex < skipCount) {
                    ring[valueIndex] = value;
                }
                else {
                    var index = valueIndex % skipCount;
                    var oldValue = ring[index];
                    ring[index] = value;
                    subscriber.next(oldValue);
                }
            }));
            return function () {
                ring = null;
            };
        });
}
exports.skipLast = skipLast;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\skipLast.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\skipUntil.js", {"../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","../util/noop":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\noop.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CskipUntil.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.skipUntil = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var innerFrom_1 = require("../observable/innerFrom");
var noop_1 = require("../util/noop");
function skipUntil(notifier) {
    return lift_1.operate(function (source, subscriber) {
        var taking = false;
        var skipSubscriber = OperatorSubscriber_1.createOperatorSubscriber(subscriber, function () {
            skipSubscriber === null || skipSubscriber === void 0 ? void 0 : skipSubscriber.unsubscribe();
            taking = true;
        }, noop_1.noop);
        innerFrom_1.innerFrom(notifier).subscribe(skipSubscriber);
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) { return taking && subscriber.next(value); }));
    });
}
exports.skipUntil = skipUntil;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\skipUntil.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\skipWhile.js", {"../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CskipWhile.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.skipWhile = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function skipWhile(predicate) {
    return lift_1.operate(function (source, subscriber) {
        var taking = false;
        var index = 0;
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) { return (taking || (taking = !predicate(value, index++))) && subscriber.next(value); }));
    });
}
exports.skipWhile = skipWhile;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\skipWhile.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\startWith.js", {"../observable/concat":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\concat.js","../util/args":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\args.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CstartWith.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.startWith = void 0;
var concat_1 = require("../observable/concat");
var args_1 = require("../util/args");
var lift_1 = require("../util/lift");
function startWith() {
    var values = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        values[_i] = arguments[_i];
    }
    var scheduler = args_1.popScheduler(values);
    return lift_1.operate(function (source, subscriber) {
        (scheduler ? concat_1.concat(values, source, scheduler) : concat_1.concat(values, source)).subscribe(subscriber);
    });
}
exports.startWith = startWith;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\startWith.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\subscribeOn.js", {"../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CsubscribeOn.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.subscribeOn = void 0;
var lift_1 = require("../util/lift");
function subscribeOn(scheduler, delay) {
    if (delay === void 0) { delay = 0; }
    return lift_1.operate(function (source, subscriber) {
        subscriber.add(scheduler.schedule(function () { return source.subscribe(subscriber); }, delay));
    });
}
exports.subscribeOn = subscribeOn;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\subscribeOn.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\switchAll.js", {"../util/identity":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\identity.js","./switchMap":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\switchMap.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CswitchAll.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.switchAll = void 0;
var switchMap_1 = require("./switchMap");
var identity_1 = require("../util/identity");
function switchAll() {
    return switchMap_1.switchMap(identity_1.identity);
}
exports.switchAll = switchAll;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\switchAll.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\switchMap.js", {"../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CswitchMap.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.switchMap = void 0;
var innerFrom_1 = require("../observable/innerFrom");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function switchMap(project, resultSelector) {
    return lift_1.operate(function (source, subscriber) {
        var innerSubscriber = null;
        var index = 0;
        var isComplete = false;
        var checkComplete = function () { return isComplete && !innerSubscriber && subscriber.complete(); };
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            innerSubscriber === null || innerSubscriber === void 0 ? void 0 : innerSubscriber.unsubscribe();
            var innerIndex = 0;
            var outerIndex = index++;
            innerFrom_1.innerFrom(project(value, outerIndex)).subscribe((innerSubscriber = OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (innerValue) { return subscriber.next(resultSelector ? resultSelector(value, innerValue, outerIndex, innerIndex++) : innerValue); }, function () {
                innerSubscriber = null;
                checkComplete();
            })));
        }, function () {
            isComplete = true;
            checkComplete();
        }));
    });
}
exports.switchMap = switchMap;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\switchMap.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\switchMapTo.js", {"../util/isFunction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isFunction.js","./switchMap":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\switchMap.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CswitchMapTo.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.switchMapTo = void 0;
var switchMap_1 = require("./switchMap");
var isFunction_1 = require("../util/isFunction");
function switchMapTo(innerObservable, resultSelector) {
    return isFunction_1.isFunction(resultSelector) ? switchMap_1.switchMap(function () { return innerObservable; }, resultSelector) : switchMap_1.switchMap(function () { return innerObservable; });
}
exports.switchMapTo = switchMapTo;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\switchMapTo.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\switchScan.js", {"../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./switchMap":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\switchMap.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CswitchScan.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.switchScan = void 0;
var switchMap_1 = require("./switchMap");
var lift_1 = require("../util/lift");
function switchScan(accumulator, seed) {
    return lift_1.operate(function (source, subscriber) {
        var state = seed;
        switchMap_1.switchMap(function (value, index) { return accumulator(state, value, index); }, function (_, innerValue) { return ((state = innerValue), innerValue); })(source).subscribe(subscriber);
        return function () {
            state = null;
        };
    });
}
exports.switchScan = switchScan;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\switchScan.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\take.js", {"../observable/empty":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\empty.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Ctake.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.take = void 0;
var empty_1 = require("../observable/empty");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function take(count) {
    return count <= 0
        ?
            function () { return empty_1.EMPTY; }
        : lift_1.operate(function (source, subscriber) {
            var seen = 0;
            source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
                if (++seen <= count) {
                    subscriber.next(value);
                    if (count <= seen) {
                        subscriber.complete();
                    }
                }
            }));
        });
}
exports.take = take;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\take.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\takeLast.js", {"../observable/empty":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\empty.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CtakeLast.js
      return function (require, module, exports) {
"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.takeLast = void 0;
var empty_1 = require("../observable/empty");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function takeLast(count) {
    return count <= 0
        ? function () { return empty_1.EMPTY; }
        : lift_1.operate(function (source, subscriber) {
            var buffer = [];
            source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
                buffer.push(value);
                count < buffer.length && buffer.shift();
            }, function () {
                var e_1, _a;
                try {
                    for (var buffer_1 = __values(buffer), buffer_1_1 = buffer_1.next(); !buffer_1_1.done; buffer_1_1 = buffer_1.next()) {
                        var value = buffer_1_1.value;
                        subscriber.next(value);
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (buffer_1_1 && !buffer_1_1.done && (_a = buffer_1.return)) _a.call(buffer_1);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
                subscriber.complete();
            }, undefined, function () {
                buffer = null;
            }));
        });
}
exports.takeLast = takeLast;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\takeLast.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\takeUntil.js", {"../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","../util/noop":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\noop.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CtakeUntil.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.takeUntil = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var innerFrom_1 = require("../observable/innerFrom");
var noop_1 = require("../util/noop");
function takeUntil(notifier) {
    return lift_1.operate(function (source, subscriber) {
        innerFrom_1.innerFrom(notifier).subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function () { return subscriber.complete(); }, noop_1.noop));
        !subscriber.closed && source.subscribe(subscriber);
    });
}
exports.takeUntil = takeUntil;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\takeUntil.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\takeWhile.js", {"../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CtakeWhile.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.takeWhile = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function takeWhile(predicate, inclusive) {
    if (inclusive === void 0) { inclusive = false; }
    return lift_1.operate(function (source, subscriber) {
        var index = 0;
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            var result = predicate(value, index++);
            (result || inclusive) && subscriber.next(value);
            !result && subscriber.complete();
        }));
    });
}
exports.takeWhile = takeWhile;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\takeWhile.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\tap.js", {"../util/identity":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\identity.js","../util/isFunction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isFunction.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Ctap.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.tap = void 0;
var isFunction_1 = require("../util/isFunction");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var identity_1 = require("../util/identity");
function tap(observerOrNext, error, complete) {
    var tapObserver = isFunction_1.isFunction(observerOrNext) || error || complete
        ?
            { next: observerOrNext, error: error, complete: complete }
        : observerOrNext;
    return tapObserver
        ? lift_1.operate(function (source, subscriber) {
            var _a;
            (_a = tapObserver.subscribe) === null || _a === void 0 ? void 0 : _a.call(tapObserver);
            var isUnsub = true;
            source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
                var _a;
                (_a = tapObserver.next) === null || _a === void 0 ? void 0 : _a.call(tapObserver, value);
                subscriber.next(value);
            }, function () {
                var _a;
                isUnsub = false;
                (_a = tapObserver.complete) === null || _a === void 0 ? void 0 : _a.call(tapObserver);
                subscriber.complete();
            }, function (err) {
                var _a;
                isUnsub = false;
                (_a = tapObserver.error) === null || _a === void 0 ? void 0 : _a.call(tapObserver, err);
                subscriber.error(err);
            }, function () {
                var _a, _b;
                if (isUnsub) {
                    (_a = tapObserver.unsubscribe) === null || _a === void 0 ? void 0 : _a.call(tapObserver);
                }
                (_b = tapObserver.finalize) === null || _b === void 0 ? void 0 : _b.call(tapObserver);
            }));
        })
        :
            identity_1.identity;
}
exports.tap = tap;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\tap.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\throttle.js", {"../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cthrottle.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.throttle = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var innerFrom_1 = require("../observable/innerFrom");
function throttle(durationSelector, config) {
    return lift_1.operate(function (source, subscriber) {
        var _a = config !== null && config !== void 0 ? config : {}, _b = _a.leading, leading = _b === void 0 ? true : _b, _c = _a.trailing, trailing = _c === void 0 ? false : _c;
        var hasValue = false;
        var sendValue = null;
        var throttled = null;
        var isComplete = false;
        var endThrottling = function () {
            throttled === null || throttled === void 0 ? void 0 : throttled.unsubscribe();
            throttled = null;
            if (trailing) {
                send();
                isComplete && subscriber.complete();
            }
        };
        var cleanupThrottling = function () {
            throttled = null;
            isComplete && subscriber.complete();
        };
        var startThrottle = function (value) {
            return (throttled = innerFrom_1.innerFrom(durationSelector(value)).subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, endThrottling, cleanupThrottling)));
        };
        var send = function () {
            if (hasValue) {
                hasValue = false;
                var value = sendValue;
                sendValue = null;
                subscriber.next(value);
                !isComplete && startThrottle(value);
            }
        };
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            hasValue = true;
            sendValue = value;
            !(throttled && !throttled.closed) && (leading ? send() : startThrottle(value));
        }, function () {
            isComplete = true;
            !(trailing && hasValue && throttled && !throttled.closed) && subscriber.complete();
        }));
    });
}
exports.throttle = throttle;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\throttle.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\throttleTime.js", {"../observable/timer":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\timer.js","../scheduler/async":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\async.js","./throttle":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\throttle.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CthrottleTime.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.throttleTime = void 0;
var async_1 = require("../scheduler/async");
var throttle_1 = require("./throttle");
var timer_1 = require("../observable/timer");
function throttleTime(duration, scheduler, config) {
    if (scheduler === void 0) { scheduler = async_1.asyncScheduler; }
    var duration$ = timer_1.timer(duration, scheduler);
    return throttle_1.throttle(function () { return duration$; }, config);
}
exports.throttleTime = throttleTime;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\throttleTime.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\throwIfEmpty.js", {"../util/EmptyError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\EmptyError.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CthrowIfEmpty.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.throwIfEmpty = void 0;
var EmptyError_1 = require("../util/EmptyError");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function throwIfEmpty(errorFactory) {
    if (errorFactory === void 0) { errorFactory = defaultErrorFactory; }
    return lift_1.operate(function (source, subscriber) {
        var hasValue = false;
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            hasValue = true;
            subscriber.next(value);
        }, function () { return (hasValue ? subscriber.complete() : subscriber.error(errorFactory())); }));
    });
}
exports.throwIfEmpty = throwIfEmpty;
function defaultErrorFactory() {
    return new EmptyError_1.EmptyError();
}

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\throwIfEmpty.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\timeInterval.js", {"../scheduler/async":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\async.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CtimeInterval.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeInterval = exports.timeInterval = void 0;
var async_1 = require("../scheduler/async");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function timeInterval(scheduler) {
    if (scheduler === void 0) { scheduler = async_1.asyncScheduler; }
    return lift_1.operate(function (source, subscriber) {
        var last = scheduler.now();
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            var now = scheduler.now();
            var interval = now - last;
            last = now;
            subscriber.next(new TimeInterval(value, interval));
        }));
    });
}
exports.timeInterval = timeInterval;
var TimeInterval = (function () {
    function TimeInterval(value, interval) {
        this.value = value;
        this.interval = interval;
    }
    return TimeInterval;
}());
exports.TimeInterval = TimeInterval;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\timeInterval.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\timeout.js", {"../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../scheduler/async":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\async.js","../util/createErrorClass":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\createErrorClass.js","../util/executeSchedule":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\executeSchedule.js","../util/isDate":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isDate.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Ctimeout.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.timeout = exports.TimeoutError = void 0;
var async_1 = require("../scheduler/async");
var isDate_1 = require("../util/isDate");
var lift_1 = require("../util/lift");
var innerFrom_1 = require("../observable/innerFrom");
var createErrorClass_1 = require("../util/createErrorClass");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var executeSchedule_1 = require("../util/executeSchedule");
exports.TimeoutError = createErrorClass_1.createErrorClass(function (_super) {
    return function TimeoutErrorImpl(info) {
        if (info === void 0) { info = null; }
        _super(this);
        this.message = 'Timeout has occurred';
        this.name = 'TimeoutError';
        this.info = info;
    };
});
function timeout(config, schedulerArg) {
    var _a = (isDate_1.isValidDate(config) ? { first: config } : typeof config === 'number' ? { each: config } : config), first = _a.first, each = _a.each, _b = _a.with, _with = _b === void 0 ? timeoutErrorFactory : _b, _c = _a.scheduler, scheduler = _c === void 0 ? schedulerArg !== null && schedulerArg !== void 0 ? schedulerArg : async_1.asyncScheduler : _c, _d = _a.meta, meta = _d === void 0 ? null : _d;
    if (first == null && each == null) {
        throw new TypeError('No timeout provided.');
    }
    return lift_1.operate(function (source, subscriber) {
        var originalSourceSubscription;
        var timerSubscription;
        var lastValue = null;
        var seen = 0;
        var startTimer = function (delay) {
            timerSubscription = executeSchedule_1.executeSchedule(subscriber, scheduler, function () {
                try {
                    originalSourceSubscription.unsubscribe();
                    innerFrom_1.innerFrom(_with({
                        meta: meta,
                        lastValue: lastValue,
                        seen: seen,
                    })).subscribe(subscriber);
                }
                catch (err) {
                    subscriber.error(err);
                }
            }, delay);
        };
        originalSourceSubscription = source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            timerSubscription === null || timerSubscription === void 0 ? void 0 : timerSubscription.unsubscribe();
            seen++;
            subscriber.next((lastValue = value));
            each > 0 && startTimer(each);
        }, undefined, undefined, function () {
            if (!(timerSubscription === null || timerSubscription === void 0 ? void 0 : timerSubscription.closed)) {
                timerSubscription === null || timerSubscription === void 0 ? void 0 : timerSubscription.unsubscribe();
            }
            lastValue = null;
        }));
        !seen && startTimer(first != null ? (typeof first === 'number' ? first : +first - scheduler.now()) : each);
    });
}
exports.timeout = timeout;
function timeoutErrorFactory(info) {
    throw new exports.TimeoutError(info);
}

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\timeout.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\timeoutWith.js", {"../scheduler/async":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\async.js","../util/isDate":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isDate.js","./timeout":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\timeout.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CtimeoutWith.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.timeoutWith = void 0;
var async_1 = require("../scheduler/async");
var isDate_1 = require("../util/isDate");
var timeout_1 = require("./timeout");
function timeoutWith(due, withObservable, scheduler) {
    var first;
    var each;
    var _with;
    scheduler = scheduler !== null && scheduler !== void 0 ? scheduler : async_1.async;
    if (isDate_1.isValidDate(due)) {
        first = due;
    }
    else if (typeof due === 'number') {
        each = due;
    }
    if (withObservable) {
        _with = function () { return withObservable; };
    }
    else {
        throw new TypeError('No observable provided to switch to');
    }
    if (first == null && each == null) {
        throw new TypeError('No timeout provided.');
    }
    return timeout_1.timeout({
        first: first,
        each: each,
        scheduler: scheduler,
        with: _with,
    });
}
exports.timeoutWith = timeoutWith;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\timeoutWith.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\timestamp.js", {"../scheduler/dateTimestampProvider":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\dateTimestampProvider.js","./map":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\map.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Ctimestamp.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.timestamp = void 0;
var dateTimestampProvider_1 = require("../scheduler/dateTimestampProvider");
var map_1 = require("./map");
function timestamp(timestampProvider) {
    if (timestampProvider === void 0) { timestampProvider = dateTimestampProvider_1.dateTimestampProvider; }
    return map_1.map(function (value) { return ({ value: value, timestamp: timestampProvider.now() }); });
}
exports.timestamp = timestamp;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\timestamp.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\toArray.js", {"../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./reduce":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\reduce.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CtoArray.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toArray = void 0;
var reduce_1 = require("./reduce");
var lift_1 = require("../util/lift");
var arrReducer = function (arr, value) { return (arr.push(value), arr); };
function toArray() {
    return lift_1.operate(function (source, subscriber) {
        reduce_1.reduce(arrReducer, [])(source).subscribe(subscriber);
    });
}
exports.toArray = toArray;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\toArray.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\window.js", {"../Subject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subject.js","../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","../util/noop":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\noop.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Cwindow.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.window = void 0;
var Subject_1 = require("../Subject");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var noop_1 = require("../util/noop");
var innerFrom_1 = require("../observable/innerFrom");
function window(windowBoundaries) {
    return lift_1.operate(function (source, subscriber) {
        var windowSubject = new Subject_1.Subject();
        subscriber.next(windowSubject.asObservable());
        var errorHandler = function (err) {
            windowSubject.error(err);
            subscriber.error(err);
        };
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) { return windowSubject === null || windowSubject === void 0 ? void 0 : windowSubject.next(value); }, function () {
            windowSubject.complete();
            subscriber.complete();
        }, errorHandler));
        innerFrom_1.innerFrom(windowBoundaries).subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function () {
            windowSubject.complete();
            subscriber.next((windowSubject = new Subject_1.Subject()));
        }, noop_1.noop, errorHandler));
        return function () {
            windowSubject === null || windowSubject === void 0 ? void 0 : windowSubject.unsubscribe();
            windowSubject = null;
        };
    });
}
exports.window = window;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\window.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\windowCount.js", {"../Subject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subject.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CwindowCount.js
      return function (require, module, exports) {
"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.windowCount = void 0;
var Subject_1 = require("../Subject");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function windowCount(windowSize, startWindowEvery) {
    if (startWindowEvery === void 0) { startWindowEvery = 0; }
    var startEvery = startWindowEvery > 0 ? startWindowEvery : windowSize;
    return lift_1.operate(function (source, subscriber) {
        var windows = [new Subject_1.Subject()];
        var starts = [];
        var count = 0;
        subscriber.next(windows[0].asObservable());
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            var e_1, _a;
            try {
                for (var windows_1 = __values(windows), windows_1_1 = windows_1.next(); !windows_1_1.done; windows_1_1 = windows_1.next()) {
                    var window_1 = windows_1_1.value;
                    window_1.next(value);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (windows_1_1 && !windows_1_1.done && (_a = windows_1.return)) _a.call(windows_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            var c = count - windowSize + 1;
            if (c >= 0 && c % startEvery === 0) {
                windows.shift().complete();
            }
            if (++count % startEvery === 0) {
                var window_2 = new Subject_1.Subject();
                windows.push(window_2);
                subscriber.next(window_2.asObservable());
            }
        }, function () {
            while (windows.length > 0) {
                windows.shift().complete();
            }
            subscriber.complete();
        }, function (err) {
            while (windows.length > 0) {
                windows.shift().error(err);
            }
            subscriber.error(err);
        }, function () {
            starts = null;
            windows = null;
        }));
    });
}
exports.windowCount = windowCount;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\windowCount.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\windowTime.js", {"../Subject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subject.js","../Subscription":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subscription.js","../scheduler/async":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\async.js","../util/args":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\args.js","../util/arrRemove":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\arrRemove.js","../util/executeSchedule":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\executeSchedule.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CwindowTime.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.windowTime = void 0;
var Subject_1 = require("../Subject");
var async_1 = require("../scheduler/async");
var Subscription_1 = require("../Subscription");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var arrRemove_1 = require("../util/arrRemove");
var args_1 = require("../util/args");
var executeSchedule_1 = require("../util/executeSchedule");
function windowTime(windowTimeSpan) {
    var _a, _b;
    var otherArgs = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        otherArgs[_i - 1] = arguments[_i];
    }
    var scheduler = (_a = args_1.popScheduler(otherArgs)) !== null && _a !== void 0 ? _a : async_1.asyncScheduler;
    var windowCreationInterval = (_b = otherArgs[0]) !== null && _b !== void 0 ? _b : null;
    var maxWindowSize = otherArgs[1] || Infinity;
    return lift_1.operate(function (source, subscriber) {
        var windowRecords = [];
        var restartOnClose = false;
        var closeWindow = function (record) {
            var window = record.window, subs = record.subs;
            window.complete();
            subs.unsubscribe();
            arrRemove_1.arrRemove(windowRecords, record);
            restartOnClose && startWindow();
        };
        var startWindow = function () {
            if (windowRecords) {
                var subs = new Subscription_1.Subscription();
                subscriber.add(subs);
                var window_1 = new Subject_1.Subject();
                var record_1 = {
                    window: window_1,
                    subs: subs,
                    seen: 0,
                };
                windowRecords.push(record_1);
                subscriber.next(window_1.asObservable());
                executeSchedule_1.executeSchedule(subs, scheduler, function () { return closeWindow(record_1); }, windowTimeSpan);
            }
        };
        if (windowCreationInterval !== null && windowCreationInterval >= 0) {
            executeSchedule_1.executeSchedule(subscriber, scheduler, startWindow, windowCreationInterval, true);
        }
        else {
            restartOnClose = true;
        }
        startWindow();
        var loop = function (cb) { return windowRecords.slice().forEach(cb); };
        var terminate = function (cb) {
            loop(function (_a) {
                var window = _a.window;
                return cb(window);
            });
            cb(subscriber);
            subscriber.unsubscribe();
        };
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            loop(function (record) {
                record.window.next(value);
                maxWindowSize <= ++record.seen && closeWindow(record);
            });
        }, function () { return terminate(function (consumer) { return consumer.complete(); }); }, function (err) { return terminate(function (consumer) { return consumer.error(err); }); }));
        return function () {
            windowRecords = null;
        };
    });
}
exports.windowTime = windowTime;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\windowTime.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\windowToggle.js", {"../Subject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subject.js","../Subscription":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subscription.js","../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/arrRemove":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\arrRemove.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","../util/noop":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\noop.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CwindowToggle.js
      return function (require, module, exports) {
"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.windowToggle = void 0;
var Subject_1 = require("../Subject");
var Subscription_1 = require("../Subscription");
var lift_1 = require("../util/lift");
var innerFrom_1 = require("../observable/innerFrom");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var noop_1 = require("../util/noop");
var arrRemove_1 = require("../util/arrRemove");
function windowToggle(openings, closingSelector) {
    return lift_1.operate(function (source, subscriber) {
        var windows = [];
        var handleError = function (err) {
            while (0 < windows.length) {
                windows.shift().error(err);
            }
            subscriber.error(err);
        };
        innerFrom_1.innerFrom(openings).subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (openValue) {
            var window = new Subject_1.Subject();
            windows.push(window);
            var closingSubscription = new Subscription_1.Subscription();
            var closeWindow = function () {
                arrRemove_1.arrRemove(windows, window);
                window.complete();
                closingSubscription.unsubscribe();
            };
            var closingNotifier;
            try {
                closingNotifier = innerFrom_1.innerFrom(closingSelector(openValue));
            }
            catch (err) {
                handleError(err);
                return;
            }
            subscriber.next(window.asObservable());
            closingSubscription.add(closingNotifier.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, closeWindow, noop_1.noop, handleError)));
        }, noop_1.noop));
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            var e_1, _a;
            var windowsCopy = windows.slice();
            try {
                for (var windowsCopy_1 = __values(windowsCopy), windowsCopy_1_1 = windowsCopy_1.next(); !windowsCopy_1_1.done; windowsCopy_1_1 = windowsCopy_1.next()) {
                    var window_1 = windowsCopy_1_1.value;
                    window_1.next(value);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (windowsCopy_1_1 && !windowsCopy_1_1.done && (_a = windowsCopy_1.return)) _a.call(windowsCopy_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }, function () {
            while (0 < windows.length) {
                windows.shift().complete();
            }
            subscriber.complete();
        }, handleError, function () {
            while (0 < windows.length) {
                windows.shift().unsubscribe();
            }
        }));
    });
}
exports.windowToggle = windowToggle;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\windowToggle.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\windowWhen.js", {"../Subject":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subject.js","../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CwindowWhen.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.windowWhen = void 0;
var Subject_1 = require("../Subject");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var innerFrom_1 = require("../observable/innerFrom");
function windowWhen(closingSelector) {
    return lift_1.operate(function (source, subscriber) {
        var window;
        var closingSubscriber;
        var handleError = function (err) {
            window.error(err);
            subscriber.error(err);
        };
        var openWindow = function () {
            closingSubscriber === null || closingSubscriber === void 0 ? void 0 : closingSubscriber.unsubscribe();
            window === null || window === void 0 ? void 0 : window.complete();
            window = new Subject_1.Subject();
            subscriber.next(window.asObservable());
            var closingNotifier;
            try {
                closingNotifier = innerFrom_1.innerFrom(closingSelector());
            }
            catch (err) {
                handleError(err);
                return;
            }
            closingNotifier.subscribe((closingSubscriber = OperatorSubscriber_1.createOperatorSubscriber(subscriber, openWindow, openWindow, handleError)));
        };
        openWindow();
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) { return window.next(value); }, function () {
            window.complete();
            subscriber.complete();
        }, handleError, function () {
            closingSubscriber === null || closingSubscriber === void 0 ? void 0 : closingSubscriber.unsubscribe();
            window = null;
        }));
    });
}
exports.windowWhen = windowWhen;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\windowWhen.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\withLatestFrom.js", {"../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../util/args":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\args.js","../util/identity":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\identity.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js","../util/noop":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\noop.js","./OperatorSubscriber":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\OperatorSubscriber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CwithLatestFrom.js
      return function (require, module, exports) {
"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.withLatestFrom = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var innerFrom_1 = require("../observable/innerFrom");
var identity_1 = require("../util/identity");
var noop_1 = require("../util/noop");
var args_1 = require("../util/args");
function withLatestFrom() {
    var inputs = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        inputs[_i] = arguments[_i];
    }
    var project = args_1.popResultSelector(inputs);
    return lift_1.operate(function (source, subscriber) {
        var len = inputs.length;
        var otherValues = new Array(len);
        var hasValue = inputs.map(function () { return false; });
        var ready = false;
        var _loop_1 = function (i) {
            innerFrom_1.innerFrom(inputs[i]).subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
                otherValues[i] = value;
                if (!ready && !hasValue[i]) {
                    hasValue[i] = true;
                    (ready = hasValue.every(identity_1.identity)) && (hasValue = null);
                }
            }, noop_1.noop));
        };
        for (var i = 0; i < len; i++) {
            _loop_1(i);
        }
        source.subscribe(OperatorSubscriber_1.createOperatorSubscriber(subscriber, function (value) {
            if (ready) {
                var values = __spreadArray([value], __read(otherValues));
                subscriber.next(project ? project.apply(void 0, __spreadArray([], __read(values))) : values);
            }
        }));
    });
}
exports.withLatestFrom = withLatestFrom;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\withLatestFrom.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\zip.js", {"../observable/zip":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\zip.js","../util/lift":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\lift.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5Czip.js
      return function (require, module, exports) {
"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.zip = void 0;
var zip_1 = require("../observable/zip");
var lift_1 = require("../util/lift");
function zip() {
    var sources = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        sources[_i] = arguments[_i];
    }
    return lift_1.operate(function (source, subscriber) {
        zip_1.zip.apply(void 0, __spreadArray([source], __read(sources))).subscribe(subscriber);
    });
}
exports.zip = zip;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\zip.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\zipAll.js", {"../observable/zip":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\zip.js","./joinAllInternals":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\joinAllInternals.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CzipAll.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.zipAll = void 0;
var zip_1 = require("../observable/zip");
var joinAllInternals_1 = require("./joinAllInternals");
function zipAll(project) {
    return joinAllInternals_1.joinAllInternals(zip_1.zip, project);
}
exports.zipAll = zipAll;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\zipAll.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\zipWith.js", {"./zip":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\zip.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Coperators%5CzipWith.js
      return function (require, module, exports) {
"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.zipWith = void 0;
var zip_1 = require("./zip");
function zipWith() {
    var otherInputs = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        otherInputs[_i] = arguments[_i];
    }
    return zip_1.zip.apply(void 0, __spreadArray([], __read(otherInputs)));
}
exports.zipWith = zipWith;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\operators\\zipWith.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\scheduleArray.js", {"../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduled%5CscheduleArray.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.scheduleArray = void 0;
var Observable_1 = require("../Observable");
function scheduleArray(input, scheduler) {
    return new Observable_1.Observable(function (subscriber) {
        var i = 0;
        return scheduler.schedule(function () {
            if (i === input.length) {
                subscriber.complete();
            }
            else {
                subscriber.next(input[i++]);
                if (!subscriber.closed) {
                    this.schedule();
                }
            }
        });
    });
}
exports.scheduleArray = scheduleArray;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\scheduleArray.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\scheduleAsyncIterable.js", {"../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","../util/executeSchedule":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\executeSchedule.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduled%5CscheduleAsyncIterable.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.scheduleAsyncIterable = void 0;
var Observable_1 = require("../Observable");
var executeSchedule_1 = require("../util/executeSchedule");
function scheduleAsyncIterable(input, scheduler) {
    if (!input) {
        throw new Error('Iterable cannot be null');
    }
    return new Observable_1.Observable(function (subscriber) {
        executeSchedule_1.executeSchedule(subscriber, scheduler, function () {
            var iterator = input[Symbol.asyncIterator]();
            executeSchedule_1.executeSchedule(subscriber, scheduler, function () {
                iterator.next().then(function (result) {
                    if (result.done) {
                        subscriber.complete();
                    }
                    else {
                        subscriber.next(result.value);
                    }
                });
            }, 0, true);
        });
    });
}
exports.scheduleAsyncIterable = scheduleAsyncIterable;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\scheduleAsyncIterable.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\scheduleIterable.js", {"../Observable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Observable.js","../symbol/iterator":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\symbol\\iterator.js","../util/executeSchedule":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\executeSchedule.js","../util/isFunction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isFunction.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduled%5CscheduleIterable.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.scheduleIterable = void 0;
var Observable_1 = require("../Observable");
var iterator_1 = require("../symbol/iterator");
var isFunction_1 = require("../util/isFunction");
var executeSchedule_1 = require("../util/executeSchedule");
function scheduleIterable(input, scheduler) {
    return new Observable_1.Observable(function (subscriber) {
        var iterator;
        executeSchedule_1.executeSchedule(subscriber, scheduler, function () {
            iterator = input[iterator_1.iterator]();
            executeSchedule_1.executeSchedule(subscriber, scheduler, function () {
                var _a;
                var value;
                var done;
                try {
                    (_a = iterator.next(), value = _a.value, done = _a.done);
                }
                catch (err) {
                    subscriber.error(err);
                    return;
                }
                if (done) {
                    subscriber.complete();
                }
                else {
                    subscriber.next(value);
                }
            }, 0, true);
        });
        return function () { return isFunction_1.isFunction(iterator === null || iterator === void 0 ? void 0 : iterator.return) && iterator.return(); };
    });
}
exports.scheduleIterable = scheduleIterable;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\scheduleIterable.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\scheduleObservable.js", {"../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../operators/observeOn":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\observeOn.js","../operators/subscribeOn":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\subscribeOn.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduled%5CscheduleObservable.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.scheduleObservable = void 0;
var innerFrom_1 = require("../observable/innerFrom");
var observeOn_1 = require("../operators/observeOn");
var subscribeOn_1 = require("../operators/subscribeOn");
function scheduleObservable(input, scheduler) {
    return innerFrom_1.innerFrom(input).pipe(subscribeOn_1.subscribeOn(scheduler), observeOn_1.observeOn(scheduler));
}
exports.scheduleObservable = scheduleObservable;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\scheduleObservable.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\schedulePromise.js", {"../observable/innerFrom":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\observable\\innerFrom.js","../operators/observeOn":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\observeOn.js","../operators/subscribeOn":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\operators\\subscribeOn.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduled%5CschedulePromise.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.schedulePromise = void 0;
var innerFrom_1 = require("../observable/innerFrom");
var observeOn_1 = require("../operators/observeOn");
var subscribeOn_1 = require("../operators/subscribeOn");
function schedulePromise(input, scheduler) {
    return innerFrom_1.innerFrom(input).pipe(subscribeOn_1.subscribeOn(scheduler), observeOn_1.observeOn(scheduler));
}
exports.schedulePromise = schedulePromise;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\schedulePromise.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\scheduleReadableStreamLike.js", {"../util/isReadableStreamLike":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isReadableStreamLike.js","./scheduleAsyncIterable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\scheduleAsyncIterable.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduled%5CscheduleReadableStreamLike.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.scheduleReadableStreamLike = void 0;
var scheduleAsyncIterable_1 = require("./scheduleAsyncIterable");
var isReadableStreamLike_1 = require("../util/isReadableStreamLike");
function scheduleReadableStreamLike(input, scheduler) {
    return scheduleAsyncIterable_1.scheduleAsyncIterable(isReadableStreamLike_1.readableStreamLikeToAsyncGenerator(input), scheduler);
}
exports.scheduleReadableStreamLike = scheduleReadableStreamLike;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\scheduleReadableStreamLike.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\scheduled.js", {"../util/isArrayLike":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isArrayLike.js","../util/isAsyncIterable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isAsyncIterable.js","../util/isInteropObservable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isInteropObservable.js","../util/isIterable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isIterable.js","../util/isPromise":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isPromise.js","../util/isReadableStreamLike":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\isReadableStreamLike.js","../util/throwUnobservableError":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\throwUnobservableError.js","./scheduleArray":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\scheduleArray.js","./scheduleAsyncIterable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\scheduleAsyncIterable.js","./scheduleIterable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\scheduleIterable.js","./scheduleObservable":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\scheduleObservable.js","./schedulePromise":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\schedulePromise.js","./scheduleReadableStreamLike":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\scheduleReadableStreamLike.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduled%5Cscheduled.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.scheduled = void 0;
var scheduleObservable_1 = require("./scheduleObservable");
var schedulePromise_1 = require("./schedulePromise");
var scheduleArray_1 = require("./scheduleArray");
var scheduleIterable_1 = require("./scheduleIterable");
var scheduleAsyncIterable_1 = require("./scheduleAsyncIterable");
var isInteropObservable_1 = require("../util/isInteropObservable");
var isPromise_1 = require("../util/isPromise");
var isArrayLike_1 = require("../util/isArrayLike");
var isIterable_1 = require("../util/isIterable");
var isAsyncIterable_1 = require("../util/isAsyncIterable");
var throwUnobservableError_1 = require("../util/throwUnobservableError");
var isReadableStreamLike_1 = require("../util/isReadableStreamLike");
var scheduleReadableStreamLike_1 = require("./scheduleReadableStreamLike");
function scheduled(input, scheduler) {
    if (input != null) {
        if (isInteropObservable_1.isInteropObservable(input)) {
            return scheduleObservable_1.scheduleObservable(input, scheduler);
        }
        if (isArrayLike_1.isArrayLike(input)) {
            return scheduleArray_1.scheduleArray(input, scheduler);
        }
        if (isPromise_1.isPromise(input)) {
            return schedulePromise_1.schedulePromise(input, scheduler);
        }
        if (isAsyncIterable_1.isAsyncIterable(input)) {
            return scheduleAsyncIterable_1.scheduleAsyncIterable(input, scheduler);
        }
        if (isIterable_1.isIterable(input)) {
            return scheduleIterable_1.scheduleIterable(input, scheduler);
        }
        if (isReadableStreamLike_1.isReadableStreamLike(input)) {
            return scheduleReadableStreamLike_1.scheduleReadableStreamLike(input, scheduler);
        }
    }
    throw throwUnobservableError_1.createInvalidObservableTypeError(input);
}
exports.scheduled = scheduled;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduled\\scheduled.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\Action.js", {"../Subscription":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subscription.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduler%5CAction.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = void 0;
var Subscription_1 = require("../Subscription");
var Action = (function (_super) {
    __extends(Action, _super);
    function Action(scheduler, work) {
        return _super.call(this) || this;
    }
    Action.prototype.schedule = function (state, delay) {
        if (delay === void 0) { delay = 0; }
        return this;
    };
    return Action;
}(Subscription_1.Subscription));
exports.Action = Action;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\Action.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AnimationFrameAction.js", {"./AsyncAction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AsyncAction.js","./animationFrameProvider":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\animationFrameProvider.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduler%5CAnimationFrameAction.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.AnimationFrameAction = void 0;
var AsyncAction_1 = require("./AsyncAction");
var animationFrameProvider_1 = require("./animationFrameProvider");
var AnimationFrameAction = (function (_super) {
    __extends(AnimationFrameAction, _super);
    function AnimationFrameAction(scheduler, work) {
        var _this = _super.call(this, scheduler, work) || this;
        _this.scheduler = scheduler;
        _this.work = work;
        return _this;
    }
    AnimationFrameAction.prototype.requestAsyncId = function (scheduler, id, delay) {
        if (delay === void 0) { delay = 0; }
        if (delay !== null && delay > 0) {
            return _super.prototype.requestAsyncId.call(this, scheduler, id, delay);
        }
        scheduler.actions.push(this);
        return scheduler._scheduled || (scheduler._scheduled = animationFrameProvider_1.animationFrameProvider.requestAnimationFrame(function () { return scheduler.flush(undefined); }));
    };
    AnimationFrameAction.prototype.recycleAsyncId = function (scheduler, id, delay) {
        var _a;
        if (delay === void 0) { delay = 0; }
        if (delay != null ? delay > 0 : this.delay > 0) {
            return _super.prototype.recycleAsyncId.call(this, scheduler, id, delay);
        }
        var actions = scheduler.actions;
        if (id != null && ((_a = actions[actions.length - 1]) === null || _a === void 0 ? void 0 : _a.id) !== id) {
            animationFrameProvider_1.animationFrameProvider.cancelAnimationFrame(id);
            scheduler._scheduled = undefined;
        }
        return undefined;
    };
    return AnimationFrameAction;
}(AsyncAction_1.AsyncAction));
exports.AnimationFrameAction = AnimationFrameAction;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AnimationFrameAction.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AnimationFrameScheduler.js", {"./AsyncScheduler":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AsyncScheduler.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduler%5CAnimationFrameScheduler.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.AnimationFrameScheduler = void 0;
var AsyncScheduler_1 = require("./AsyncScheduler");
var AnimationFrameScheduler = (function (_super) {
    __extends(AnimationFrameScheduler, _super);
    function AnimationFrameScheduler() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AnimationFrameScheduler.prototype.flush = function (action) {
        this._active = true;
        var flushId = this._scheduled;
        this._scheduled = undefined;
        var actions = this.actions;
        var error;
        action = action || actions.shift();
        do {
            if ((error = action.execute(action.state, action.delay))) {
                break;
            }
        } while ((action = actions[0]) && action.id === flushId && actions.shift());
        this._active = false;
        if (error) {
            while ((action = actions[0]) && action.id === flushId && actions.shift()) {
                action.unsubscribe();
            }
            throw error;
        }
    };
    return AnimationFrameScheduler;
}(AsyncScheduler_1.AsyncScheduler));
exports.AnimationFrameScheduler = AnimationFrameScheduler;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AnimationFrameScheduler.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AsapAction.js", {"./AsyncAction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AsyncAction.js","./immediateProvider":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\immediateProvider.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduler%5CAsapAction.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsapAction = void 0;
var AsyncAction_1 = require("./AsyncAction");
var immediateProvider_1 = require("./immediateProvider");
var AsapAction = (function (_super) {
    __extends(AsapAction, _super);
    function AsapAction(scheduler, work) {
        var _this = _super.call(this, scheduler, work) || this;
        _this.scheduler = scheduler;
        _this.work = work;
        return _this;
    }
    AsapAction.prototype.requestAsyncId = function (scheduler, id, delay) {
        if (delay === void 0) { delay = 0; }
        if (delay !== null && delay > 0) {
            return _super.prototype.requestAsyncId.call(this, scheduler, id, delay);
        }
        scheduler.actions.push(this);
        return scheduler._scheduled || (scheduler._scheduled = immediateProvider_1.immediateProvider.setImmediate(scheduler.flush.bind(scheduler, undefined)));
    };
    AsapAction.prototype.recycleAsyncId = function (scheduler, id, delay) {
        var _a;
        if (delay === void 0) { delay = 0; }
        if (delay != null ? delay > 0 : this.delay > 0) {
            return _super.prototype.recycleAsyncId.call(this, scheduler, id, delay);
        }
        var actions = scheduler.actions;
        if (id != null && ((_a = actions[actions.length - 1]) === null || _a === void 0 ? void 0 : _a.id) !== id) {
            immediateProvider_1.immediateProvider.clearImmediate(id);
            if (scheduler._scheduled === id) {
                scheduler._scheduled = undefined;
            }
        }
        return undefined;
    };
    return AsapAction;
}(AsyncAction_1.AsyncAction));
exports.AsapAction = AsapAction;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AsapAction.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AsapScheduler.js", {"./AsyncScheduler":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AsyncScheduler.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduler%5CAsapScheduler.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsapScheduler = void 0;
var AsyncScheduler_1 = require("./AsyncScheduler");
var AsapScheduler = (function (_super) {
    __extends(AsapScheduler, _super);
    function AsapScheduler() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AsapScheduler.prototype.flush = function (action) {
        this._active = true;
        var flushId = this._scheduled;
        this._scheduled = undefined;
        var actions = this.actions;
        var error;
        action = action || actions.shift();
        do {
            if ((error = action.execute(action.state, action.delay))) {
                break;
            }
        } while ((action = actions[0]) && action.id === flushId && actions.shift());
        this._active = false;
        if (error) {
            while ((action = actions[0]) && action.id === flushId && actions.shift()) {
                action.unsubscribe();
            }
            throw error;
        }
    };
    return AsapScheduler;
}(AsyncScheduler_1.AsyncScheduler));
exports.AsapScheduler = AsapScheduler;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AsapScheduler.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AsyncAction.js", {"../util/arrRemove":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\arrRemove.js","./Action":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\Action.js","./intervalProvider":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\intervalProvider.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduler%5CAsyncAction.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsyncAction = void 0;
var Action_1 = require("./Action");
var intervalProvider_1 = require("./intervalProvider");
var arrRemove_1 = require("../util/arrRemove");
var AsyncAction = (function (_super) {
    __extends(AsyncAction, _super);
    function AsyncAction(scheduler, work) {
        var _this = _super.call(this, scheduler, work) || this;
        _this.scheduler = scheduler;
        _this.work = work;
        _this.pending = false;
        return _this;
    }
    AsyncAction.prototype.schedule = function (state, delay) {
        var _a;
        if (delay === void 0) { delay = 0; }
        if (this.closed) {
            return this;
        }
        this.state = state;
        var id = this.id;
        var scheduler = this.scheduler;
        if (id != null) {
            this.id = this.recycleAsyncId(scheduler, id, delay);
        }
        this.pending = true;
        this.delay = delay;
        this.id = (_a = this.id) !== null && _a !== void 0 ? _a : this.requestAsyncId(scheduler, this.id, delay);
        return this;
    };
    AsyncAction.prototype.requestAsyncId = function (scheduler, _id, delay) {
        if (delay === void 0) { delay = 0; }
        return intervalProvider_1.intervalProvider.setInterval(scheduler.flush.bind(scheduler, this), delay);
    };
    AsyncAction.prototype.recycleAsyncId = function (_scheduler, id, delay) {
        if (delay === void 0) { delay = 0; }
        if (delay != null && this.delay === delay && this.pending === false) {
            return id;
        }
        if (id != null) {
            intervalProvider_1.intervalProvider.clearInterval(id);
        }
        return undefined;
    };
    AsyncAction.prototype.execute = function (state, delay) {
        if (this.closed) {
            return new Error('executing a cancelled action');
        }
        this.pending = false;
        var error = this._execute(state, delay);
        if (error) {
            return error;
        }
        else if (this.pending === false && this.id != null) {
            this.id = this.recycleAsyncId(this.scheduler, this.id, null);
        }
    };
    AsyncAction.prototype._execute = function (state, _delay) {
        var errored = false;
        var errorValue;
        try {
            this.work(state);
        }
        catch (e) {
            errored = true;
            errorValue = e ? e : new Error('Scheduled action threw falsy error');
        }
        if (errored) {
            this.unsubscribe();
            return errorValue;
        }
    };
    AsyncAction.prototype.unsubscribe = function () {
        if (!this.closed) {
            var _a = this, id = _a.id, scheduler = _a.scheduler;
            var actions = scheduler.actions;
            this.work = this.state = this.scheduler = null;
            this.pending = false;
            arrRemove_1.arrRemove(actions, this);
            if (id != null) {
                this.id = this.recycleAsyncId(scheduler, id, null);
            }
            this.delay = null;
            _super.prototype.unsubscribe.call(this);
        }
    };
    return AsyncAction;
}(Action_1.Action));
exports.AsyncAction = AsyncAction;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AsyncAction.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AsyncScheduler.js", {"../Scheduler":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Scheduler.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduler%5CAsyncScheduler.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsyncScheduler = void 0;
var Scheduler_1 = require("../Scheduler");
var AsyncScheduler = (function (_super) {
    __extends(AsyncScheduler, _super);
    function AsyncScheduler(SchedulerAction, now) {
        if (now === void 0) { now = Scheduler_1.Scheduler.now; }
        var _this = _super.call(this, SchedulerAction, now) || this;
        _this.actions = [];
        _this._active = false;
        return _this;
    }
    AsyncScheduler.prototype.flush = function (action) {
        var actions = this.actions;
        if (this._active) {
            actions.push(action);
            return;
        }
        var error;
        this._active = true;
        do {
            if ((error = action.execute(action.state, action.delay))) {
                break;
            }
        } while ((action = actions.shift()));
        this._active = false;
        if (error) {
            while ((action = actions.shift())) {
                action.unsubscribe();
            }
            throw error;
        }
    };
    return AsyncScheduler;
}(Scheduler_1.Scheduler));
exports.AsyncScheduler = AsyncScheduler;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AsyncScheduler.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\QueueAction.js", {"./AsyncAction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AsyncAction.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduler%5CQueueAction.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueueAction = void 0;
var AsyncAction_1 = require("./AsyncAction");
var QueueAction = (function (_super) {
    __extends(QueueAction, _super);
    function QueueAction(scheduler, work) {
        var _this = _super.call(this, scheduler, work) || this;
        _this.scheduler = scheduler;
        _this.work = work;
        return _this;
    }
    QueueAction.prototype.schedule = function (state, delay) {
        if (delay === void 0) { delay = 0; }
        if (delay > 0) {
            return _super.prototype.schedule.call(this, state, delay);
        }
        this.delay = delay;
        this.state = state;
        this.scheduler.flush(this);
        return this;
    };
    QueueAction.prototype.execute = function (state, delay) {
        return delay > 0 || this.closed ? _super.prototype.execute.call(this, state, delay) : this._execute(state, delay);
    };
    QueueAction.prototype.requestAsyncId = function (scheduler, id, delay) {
        if (delay === void 0) { delay = 0; }
        if ((delay != null && delay > 0) || (delay == null && this.delay > 0)) {
            return _super.prototype.requestAsyncId.call(this, scheduler, id, delay);
        }
        scheduler.flush(this);
        return 0;
    };
    return QueueAction;
}(AsyncAction_1.AsyncAction));
exports.QueueAction = QueueAction;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\QueueAction.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\QueueScheduler.js", {"./AsyncScheduler":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AsyncScheduler.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduler%5CQueueScheduler.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueueScheduler = void 0;
var AsyncScheduler_1 = require("./AsyncScheduler");
var QueueScheduler = (function (_super) {
    __extends(QueueScheduler, _super);
    function QueueScheduler() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return QueueScheduler;
}(AsyncScheduler_1.AsyncScheduler));
exports.QueueScheduler = QueueScheduler;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\QueueScheduler.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\VirtualTimeScheduler.js", {"../Subscription":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subscription.js","./AsyncAction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AsyncAction.js","./AsyncScheduler":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AsyncScheduler.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduler%5CVirtualTimeScheduler.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualAction = exports.VirtualTimeScheduler = void 0;
var AsyncAction_1 = require("./AsyncAction");
var Subscription_1 = require("../Subscription");
var AsyncScheduler_1 = require("./AsyncScheduler");
var VirtualTimeScheduler = (function (_super) {
    __extends(VirtualTimeScheduler, _super);
    function VirtualTimeScheduler(schedulerActionCtor, maxFrames) {
        if (schedulerActionCtor === void 0) { schedulerActionCtor = VirtualAction; }
        if (maxFrames === void 0) { maxFrames = Infinity; }
        var _this = _super.call(this, schedulerActionCtor, function () { return _this.frame; }) || this;
        _this.maxFrames = maxFrames;
        _this.frame = 0;
        _this.index = -1;
        return _this;
    }
    VirtualTimeScheduler.prototype.flush = function () {
        var _a = this, actions = _a.actions, maxFrames = _a.maxFrames;
        var error;
        var action;
        while ((action = actions[0]) && action.delay <= maxFrames) {
            actions.shift();
            this.frame = action.delay;
            if ((error = action.execute(action.state, action.delay))) {
                break;
            }
        }
        if (error) {
            while ((action = actions.shift())) {
                action.unsubscribe();
            }
            throw error;
        }
    };
    VirtualTimeScheduler.frameTimeFactor = 10;
    return VirtualTimeScheduler;
}(AsyncScheduler_1.AsyncScheduler));
exports.VirtualTimeScheduler = VirtualTimeScheduler;
var VirtualAction = (function (_super) {
    __extends(VirtualAction, _super);
    function VirtualAction(scheduler, work, index) {
        if (index === void 0) { index = (scheduler.index += 1); }
        var _this = _super.call(this, scheduler, work) || this;
        _this.scheduler = scheduler;
        _this.work = work;
        _this.index = index;
        _this.active = true;
        _this.index = scheduler.index = index;
        return _this;
    }
    VirtualAction.prototype.schedule = function (state, delay) {
        if (delay === void 0) { delay = 0; }
        if (Number.isFinite(delay)) {
            if (!this.id) {
                return _super.prototype.schedule.call(this, state, delay);
            }
            this.active = false;
            var action = new VirtualAction(this.scheduler, this.work);
            this.add(action);
            return action.schedule(state, delay);
        }
        else {
            return Subscription_1.Subscription.EMPTY;
        }
    };
    VirtualAction.prototype.requestAsyncId = function (scheduler, id, delay) {
        if (delay === void 0) { delay = 0; }
        this.delay = scheduler.frame + delay;
        var actions = scheduler.actions;
        actions.push(this);
        actions.sort(VirtualAction.sortActions);
        return 1;
    };
    VirtualAction.prototype.recycleAsyncId = function (scheduler, id, delay) {
        if (delay === void 0) { delay = 0; }
        return undefined;
    };
    VirtualAction.prototype._execute = function (state, delay) {
        if (this.active === true) {
            return _super.prototype._execute.call(this, state, delay);
        }
    };
    VirtualAction.sortActions = function (a, b) {
        if (a.delay === b.delay) {
            if (a.index === b.index) {
                return 0;
            }
            else if (a.index > b.index) {
                return 1;
            }
            else {
                return -1;
            }
        }
        else if (a.delay > b.delay) {
            return 1;
        }
        else {
            return -1;
        }
    };
    return VirtualAction;
}(AsyncAction_1.AsyncAction));
exports.VirtualAction = VirtualAction;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\VirtualTimeScheduler.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\animationFrame.js", {"./AnimationFrameAction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AnimationFrameAction.js","./AnimationFrameScheduler":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AnimationFrameScheduler.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduler%5CanimationFrame.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.animationFrame = exports.animationFrameScheduler = void 0;
var AnimationFrameAction_1 = require("./AnimationFrameAction");
var AnimationFrameScheduler_1 = require("./AnimationFrameScheduler");
exports.animationFrameScheduler = new AnimationFrameScheduler_1.AnimationFrameScheduler(AnimationFrameAction_1.AnimationFrameAction);
exports.animationFrame = exports.animationFrameScheduler;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\animationFrame.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\animationFrameProvider.js", {"../Subscription":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\Subscription.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduler%5CanimationFrameProvider.js
      return function (require, module, exports) {
"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.animationFrameProvider = void 0;
var Subscription_1 = require("../Subscription");
exports.animationFrameProvider = {
    schedule: function (callback) {
        var request = requestAnimationFrame;
        var cancel = cancelAnimationFrame;
        var delegate = exports.animationFrameProvider.delegate;
        if (delegate) {
            request = delegate.requestAnimationFrame;
            cancel = delegate.cancelAnimationFrame;
        }
        var handle = request(function (timestamp) {
            cancel = undefined;
            callback(timestamp);
        });
        return new Subscription_1.Subscription(function () { return cancel === null || cancel === void 0 ? void 0 : cancel(handle); });
    },
    requestAnimationFrame: function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var delegate = exports.animationFrameProvider.delegate;
        return ((delegate === null || delegate === void 0 ? void 0 : delegate.requestAnimationFrame) || requestAnimationFrame).apply(void 0, __spreadArray([], __read(args)));
    },
    cancelAnimationFrame: function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var delegate = exports.animationFrameProvider.delegate;
        return ((delegate === null || delegate === void 0 ? void 0 : delegate.cancelAnimationFrame) || cancelAnimationFrame).apply(void 0, __spreadArray([], __read(args)));
    },
    delegate: undefined,
};

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\animationFrameProvider.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\asap.js", {"./AsapAction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AsapAction.js","./AsapScheduler":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AsapScheduler.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduler%5Casap.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.asap = exports.asapScheduler = void 0;
var AsapAction_1 = require("./AsapAction");
var AsapScheduler_1 = require("./AsapScheduler");
exports.asapScheduler = new AsapScheduler_1.AsapScheduler(AsapAction_1.AsapAction);
exports.asap = exports.asapScheduler;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\asap.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\async.js", {"./AsyncAction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AsyncAction.js","./AsyncScheduler":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\AsyncScheduler.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduler%5Casync.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.async = exports.asyncScheduler = void 0;
var AsyncAction_1 = require("./AsyncAction");
var AsyncScheduler_1 = require("./AsyncScheduler");
exports.asyncScheduler = new AsyncScheduler_1.AsyncScheduler(AsyncAction_1.AsyncAction);
exports.async = exports.asyncScheduler;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\async.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\dateTimestampProvider.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduler%5CdateTimestampProvider.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.dateTimestampProvider = void 0;
exports.dateTimestampProvider = {
    now: function () {
        return (exports.dateTimestampProvider.delegate || Date).now();
    },
    delegate: undefined,
};

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\dateTimestampProvider.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\immediateProvider.js", {"../util/Immediate":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\util\\Immediate.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduler%5CimmediateProvider.js
      return function (require, module, exports) {
"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.immediateProvider = void 0;
var Immediate_1 = require("../util/Immediate");
var setImmediate = Immediate_1.Immediate.setImmediate, clearImmediate = Immediate_1.Immediate.clearImmediate;
exports.immediateProvider = {
    setImmediate: function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var delegate = exports.immediateProvider.delegate;
        return ((delegate === null || delegate === void 0 ? void 0 : delegate.setImmediate) || setImmediate).apply(void 0, __spreadArray([], __read(args)));
    },
    clearImmediate: function (handle) {
        var delegate = exports.immediateProvider.delegate;
        return ((delegate === null || delegate === void 0 ? void 0 : delegate.clearImmediate) || clearImmediate)(handle);
    },
    delegate: undefined,
};

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\immediateProvider.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\intervalProvider.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduler%5CintervalProvider.js
      return function (require, module, exports) {
"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.intervalProvider = void 0;
exports.intervalProvider = {
    setInterval: function (handler, timeout) {
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
        }
        var delegate = exports.intervalProvider.delegate;
        if (delegate === null || delegate === void 0 ? void 0 : delegate.setInterval) {
            return delegate.setInterval.apply(delegate, __spreadArray([handler, timeout], __read(args)));
        }
        return setInterval.apply(void 0, __spreadArray([handler, timeout], __read(args)));
    },
    clearInterval: function (handle) {
        var delegate = exports.intervalProvider.delegate;
        return ((delegate === null || delegate === void 0 ? void 0 : delegate.clearInterval) || clearInterval)(handle);
    },
    delegate: undefined,
};

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\intervalProvider.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\performanceTimestampProvider.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduler%5CperformanceTimestampProvider.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.performanceTimestampProvider = void 0;
exports.performanceTimestampProvider = {
    now: function () {
        return (exports.performanceTimestampProvider.delegate || performance).now();
    },
    delegate: undefined,
};

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\performanceTimestampProvider.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\queue.js", {"./QueueAction":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\QueueAction.js","./QueueScheduler":"D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\QueueScheduler.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduler%5Cqueue.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.queue = exports.queueScheduler = void 0;
var QueueAction_1 = require("./QueueAction");
var QueueScheduler_1 = require("./QueueScheduler");
exports.queueScheduler = new QueueScheduler_1.QueueScheduler(QueueAction_1.QueueAction);
exports.queue = exports.queueScheduler;

      };
    };
  }
  }
}, {package:"wait-on>rxjs",file:"node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\queue.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\rxjs\\dist\\cjs\\internal\\scheduler\\timeoutProvider.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5Crxjs%5Cdist%5Ccjs%5Cinternal%5Cscheduler%5CtimeoutProvider.js
      return function (require, module, exports) {
"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.timeoutProvider = void 0;
exports.timeoutProvider = {
    setTimeout: function (handler, timeout) {
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
        }
        var delegate = exports.timeoutProvider.delegate;
        if (delegate === null || delegate === void 0 ? void 0 : delegate.setTimeout) {
            return delegate.setTimeout.apply(delegate, __spreadArray([handler, timeout], __read(args)));
        }
        return setTimeout.apply(void 0, __spreadArray([handler, timeout], __read(args)));
    },
    clearTimeout: function (handle) {
        var delegate = exports.timeoutProvider.delegate;
        return ((delegate === null || delegate === void 0 ? void 0 : delegate.clearTimeout) || clearTimeout)(handle);
    },
    delegate: undefined,
