LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\app\\scripts\\background.js", {"../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../shared/constants/background-liveness-check":"D:\\code\\v\\metamask-extension\\shared\\constants\\background-liveness-check.ts","../../shared/constants/errors":"D:\\code\\v\\metamask-extension\\shared\\constants\\errors.ts","../../shared/constants/infura-project-id":"D:\\code\\v\\metamask-extension\\shared\\constants\\infura-project-id.ts","../../shared/constants/messages":"D:\\code\\v\\metamask-extension\\shared\\constants\\messages.ts","../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../shared/constants/offscreen-communication":"D:\\code\\v\\metamask-extension\\shared\\constants\\offscreen-communication.ts","../../shared/constants/onboarding":"D:\\code\\v\\metamask-extension\\shared\\constants\\onboarding.ts","../../shared/constants/referrals":"D:\\code\\v\\metamask-extension\\shared\\constants\\referrals.ts","../../shared/constants/start-up-errors":"D:\\code\\v\\metamask-extension\\shared\\constants\\start-up-errors.ts","../../shared/lib/get-first-preferred-lang-code":"D:\\code\\v\\metamask-extension\\shared\\lib\\get-first-preferred-lang-code.js","../../shared/lib/manifestFlags":"D:\\code\\v\\metamask-extension\\shared\\lib\\manifestFlags.ts","../../shared/lib/promise-with-resolvers":"D:\\code\\v\\metamask-extension\\shared\\lib\\promise-with-resolvers.ts","../../shared/modules/browser-runtime.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\browser-runtime.utils.js","../../shared/modules/caip-stream":"D:\\code\\v\\metamask-extension\\shared\\modules\\caip-stream.ts","../../shared/modules/fetch-with-timeout":"D:\\code\\v\\metamask-extension\\shared\\modules\\fetch-with-timeout.ts","../../shared/modules/mv3.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\mv3.utils.js","../../shared/modules/object.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\object.utils.js","../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../test/e2e/background-socket/socket-background-to-mocha":"D:\\code\\v\\metamask-extension\\test\\e2e\\background-socket\\socket-background-to-mocha.ts","../../test/e2e/default-fixture":"D:\\code\\v\\metamask-extension\\test\\e2e\\default-fixture.js","../../test/stub/keyring-bridge":"D:\\code\\v\\metamask-extension\\test\\stub\\keyring-bridge.js","./constants/marketing-site-whitelist":"D:\\code\\v\\metamask-extension\\app\\scripts\\constants\\marketing-site-whitelist.ts","./constants/sentry-state":"D:\\code\\v\\metamask-extension\\app\\scripts\\constants\\sentry-state.ts","./constants/snaps":"D:\\code\\v\\metamask-extension\\app\\scripts\\constants\\snaps.ts","./constants/stream":"D:\\code\\v\\metamask-extension\\app\\scripts\\constants\\stream.ts","./first-time-state":"D:\\code\\v\\metamask-extension\\app\\scripts\\first-time-state.js","./fixtures/generate-wallet-state":"D:\\code\\v\\metamask-extension\\app\\scripts\\fixtures\\generate-wallet-state.js","./lib/CronjobControllerStorageManager":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\CronjobControllerStorageManager.ts","./lib/createHyperliquidReferralMiddleware":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\createHyperliquidReferralMiddleware.ts","./lib/deep-links/deep-link-router":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\deep-links\\deep-link-router.ts","./lib/deep-links/metrics":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\deep-links\\metrics.ts","./lib/ens-ipfs/setup":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\ens-ipfs\\setup.js","./lib/getObjStructure":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\getObjStructure.js","./lib/migrator":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\migrator\\index.js","./lib/notification-manager":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\notification-manager.js","./lib/safe-reload":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\safe-reload.ts","./lib/setup-initial-state-hooks":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\setup-initial-state-hooks.js","./lib/start-up-errors/start-up-errors":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\start-up-errors\\start-up-errors.ts","./lib/state-corruption/state-corruption-recovery":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\state-corruption\\state-corruption-recovery.ts","./lib/stores/extension-store":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\stores\\extension-store.ts","./lib/stores/persistence-manager":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\stores\\persistence-manager.ts","./lib/stores/read-only-network-store":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\stores\\read-only-network-store.ts","./lib/stream-utils":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\stream-utils.js","./lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","./metamask-controller":"D:\\code\\v\\metamask-extension\\app\\scripts\\metamask-controller.js","./migrations":"D:\\code\\v\\metamask-extension\\app\\scripts\\migrations\\index.js","./offscreen":"D:\\code\\v\\metamask-extension\\app\\scripts\\offscreen.js","./platforms/extension":"D:\\code\\v\\metamask-extension\\app\\scripts\\platforms\\extension.js","@metamask/notification-services-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\notification-services-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","extension-port-stream":"D:\\code\\v\\metamask-extension\\node_modules\\extension-port-stream\\dist\\index.js","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","readable-stream":"D:\\code\\v\\metamask-extension\\node_modules\\readable-stream\\readable-browser.js","webextension-polyfill":"D:\\code\\v\\metamask-extension\\node_modules\\webextension-polyfill\\dist\\browser-polyfill.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Cbackground.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadStateFromPersistence = loadStateFromPersistence;
exports.setupController = setupController;
require("./lib/setup-initial-state-hooks");
require("../../shared/constants/infura-project-id");
var _readableStream = require("readable-stream");
var _loglevel = _interopRequireDefault(require("loglevel"));
var _webextensionPolyfill = _interopRequireDefault(require("webextension-polyfill"));
var _utils = require("@metamask/utils");
var _extensionPortStream = _interopRequireDefault(require("extension-port-stream"));
var _notificationServicesController = require("@metamask/notification-services-controller");
var _promiseWithResolvers = require("../../shared/lib/promise-with-resolvers");
var _onboarding = require("../../shared/constants/onboarding");
var _app = require("../../shared/constants/app");
var _messages = require("../../shared/constants/messages");
var _backgroundLivenessCheck = require("../../shared/constants/background-liveness-check");
var _metametrics = require("../../shared/constants/metametrics");
var _browserRuntime = require("../../shared/modules/browser-runtime.utils");
var _mv = require("../../shared/modules/mv3.utils");
var _object = require("../../shared/modules/object.utils");
var _offscreenCommunication = require("../../shared/constants/offscreen-communication");
var _networks = require("../../shared/modules/selectors/networks");
var _caipStream = require("../../shared/modules/caip-stream");
var _fetchWithTimeout = _interopRequireDefault(require("../../shared/modules/fetch-with-timeout"));
var _errors = require("../../shared/constants/errors");
var _getFirstPreferredLangCode = _interopRequireDefault(require("../../shared/lib/get-first-preferred-lang-code"));
var _manifestFlags = require("../../shared/lib/manifestFlags");
var _startUpErrors = require("../../shared/constants/start-up-errors");
var _referrals = require("../../shared/constants/referrals");
var _stateCorruptionRecovery = require("./lib/state-corruption/state-corruption-recovery");
var _persistenceManager = require("./lib/stores/persistence-manager");
var _extensionStore = _interopRequireDefault(require("./lib/stores/extension-store"));
var _readOnlyNetworkStore = _interopRequireDefault(require("./lib/stores/read-only-network-store"));
var _migrations = _interopRequireDefault(require("./migrations"));
var _migrator = _interopRequireDefault(require("./lib/migrator"));
var _extension = _interopRequireDefault(require("./platforms/extension"));
var _sentryState = require("./constants/sentry-state");
var _notificationManager = _interopRequireWildcard(require("./lib/notification-manager"));
var _metamaskController = _interopRequireWildcard(require("./metamask-controller"));
var _getObjStructure = _interopRequireDefault(require("./lib/getObjStructure"));
var _setup = _interopRequireDefault(require("./lib/ens-ipfs/setup"));
var _util = require("./lib/util");
var _offscreen = require("./offscreen");
var _streamUtils = require("./lib/stream-utils");
var _firstTimeState = _interopRequireDefault(require("./first-time-state"));
var _marketingSiteWhitelist = require("./constants/marketing-site-whitelist");
var _stream = require("./constants/stream");
var _snaps = require("./constants/snaps");
var _deepLinkRouter = require("./lib/deep-links/deep-link-router");
var _metrics = require("./lib/deep-links/metrics");
var _safeReload = require("./lib/safe-reload");
var _startUpErrors2 = require("./lib/start-up-errors/start-up-errors");
var _CronjobControllerStorageManager = require("./lib/CronjobControllerStorageManager");
var _createHyperliquidReferralMiddleware = require("./lib/createHyperliquidReferralMiddleware");
var _getManifestFlags$tes;
/**
 * @file The entry point for the web extension singleton process.
 */
// Disabled to allow setting up initial state hooks first
// This import sets up global functions required for Sentry to function.
// It must be run first in case an error is thrown later during initialization.
// Import this very early, so globalThis.INFURA_PROJECT_ID_FROM_MANIFEST_FLAGS is always defined
/* eslint-enable import/first */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * @typedef {__import__('./lib/stores/persistence-manager').Backup} Backup
 */

// eslint-disable-next-line @metamask/design-tokens/color-no-hex
const BADGE_COLOR_APPROVAL = '#0376C9';
// eslint-disable-next-line @metamask/design-tokens/color-no-hex
const BADGE_COLOR_NOTIFICATION = '#D73847';
const BADGE_MAX_COUNT = 9;
const inTest = false;
const useReadOnlyNetworkStore = inTest && ((_getManifestFlags$tes = (0, _manifestFlags.getManifestFlags)().testing) === null || _getManifestFlags$tes === void 0 ? void 0 : _getManifestFlags$tes.forceExtensionStore) !== true;
const localStore = useReadOnlyNetworkStore ? new _readOnlyNetworkStore.default() : new _extensionStore.default();
const persistenceManager = new _persistenceManager.PersistenceManager({
  localStore
});
// Setup global hook for improved Sentry state snapshots during initialization
global.stateHooks.getMostRecentPersistedState = () => persistenceManager.mostRecentRetrievedState;

/**
 * A helper function to log the current state of the vault. Useful for debugging
 * purposes, to, in the case of database corruption, an possible way for an end
 * user to recover their vault. Hopefully this is never needed.
 */
global.logEncryptedVault = () => {
  persistenceManager.logEncryptedVault();
};
const {
  sentry
} = global;
let firstTimeState = {
  ..._firstTimeState.default
};
const metamaskInternalProcessHash = {
  [_app.ENVIRONMENT_TYPE_POPUP]: true,
  [_app.ENVIRONMENT_TYPE_NOTIFICATION]: true,
  [_app.ENVIRONMENT_TYPE_FULLSCREEN]: true
};
const metamaskBlockedPorts = ['trezor-connect'];
_loglevel.default.setLevel(true ? 'debug' : 'info', false);
const platform = new _extension.default();
const notificationManager = new _notificationManager.default();
const isFirefox = (0, _util.getPlatform)() === _app.PLATFORM_FIREFOX;
let openPopupCount = 0;
let notificationIsOpen = false;
let uiIsTriggering = false;
const openMetamaskTabsIDs = {};
const requestAccountTabIds = {};
let controller;
const senderOriginMapping = {};
const tabOriginMapping = {};
if (inTest || true) {
  global.stateHooks.metamaskGetState = persistenceManager.get.bind(persistenceManager, {
    validateVault: false
  });
}
const phishingPageUrl = new URL("https://metamask.github.io/phishing-warning/v5.1.0/");

// normalized (adds a trailing slash to the end of the domain if it's missing)
// the URL once and reuse it:
const phishingPageHref = phishingPageUrl.toString();
const ONE_SECOND_IN_MILLISECONDS = 1_000;
// Timeout for initializing phishing warning page.
const PHISHING_WARNING_PAGE_TIMEOUT = ONE_SECOND_IN_MILLISECONDS;

// In MV3 onInstalled must be installed in the entry file
if (globalThis.stateHooks.onInstalledListener) {
  globalThis.stateHooks.onInstalledListener.then(handleOnInstalled);
} else {
  _webextensionPolyfill.default.runtime.onInstalled.addListener(function listener(details) {
    _webextensionPolyfill.default.runtime.onInstalled.removeListener(listener);
    handleOnInstalled(details);
  });
}

/**
 * This deferred Promise is used to track whether initialization has finished.
 *
 * It is very important to ensure that `resolveInitialization` is *always*
 * called once initialization has completed, and that `rejectInitialization` is
 * called if initialization fails in an unrecoverable way.
 */
/**
 * @type {Promise<void>}
 */
let isInitialized;
/**
 * @type {() => void}
 */
let resolveInitialization;
/**
 * @type {() => void}
 */
let rejectInitialization;

/**
 * Creates a deferred Promise and sets the global variables to track the
 * state of application initialization (or re-initialization).
 */
function setGlobalInitializers() {
  const deferred = (0, _promiseWithResolvers.withResolvers)();
  isInitialized = deferred.promise;
  resolveInitialization = deferred.resolve;
  rejectInitialization = deferred.reject;
}
setGlobalInitializers();

/**
 * Sends a message to the dapp(s) content script to signal it can connect to MetaMask background as
 * the backend is not active. It is required to re-connect dapps after service worker re-activates.
 * For non-dapp pages, the message will be sent and ignored.
 */
const sendReadyMessageToTabs = async () => {
  const tabs = await _webextensionPolyfill.default.tabs.query({
    /**
     * Only query tabs that our extension can run in. To do this, we query for all URLs that our
     * extension can inject scripts in, which is by using the "<all_urls>" value and __without__
     * the "tabs" manifest permission. If we included the "tabs" permission, this would also fetch
     * URLs that we'd not be able to inject in, e.g. chrome://pages, chrome://extension, which
     * is not what we'd want.
     *
     * You might be wondering, how does the "url" param work without the "tabs" permission?
     *
     * @see {@link https://bugs.chromium.org/p/chromium/issues/detail?id=661311#c1}
     *  "If the extension has access to inject scripts into Tab, then we can return the url
     *   of Tab (because the extension could just inject a script to message the location.href)."
     */
    url: '<all_urls>',
    windowType: 'normal'
  }).then(result => {
    (0, _browserRuntime.checkForLastErrorAndLog)();
    return result;
  }).catch(() => {
    (0, _browserRuntime.checkForLastErrorAndLog)();
  });

  /** @todo we should only sendMessage to dapp tabs, not all tabs. */
  for (const tab of tabs) {
    _webextensionPolyfill.default.tabs.sendMessage(tab.id, {
      name: _messages.EXTENSION_MESSAGES.READY
    }).then(() => {
      (0, _browserRuntime.checkForLastErrorAndLog)();
    }).catch(() => {
      // An error may happen if:
      //  * a contentscript is blocked from loading, and thus there is no
      // `runtime.onMessage` handlers to listen to the message, or
      //  * if MetaMask reloads/installs while tabs are already open, as these
      // tabs won't have a valid Port to send the message to.
      (0, _browserRuntime.checkForLastErrorAndLog)();
    });
  }
};

/**
 * Detects known phishing pages as soon as the browser begins to load the
 * page. If the page is a known phishing page, the user is redirected to the
 * phishing warning page.
 *
 * This detection works even if the phishing page is now a redirect to a new
 * domain that our phishing detection system is not aware of.
 *
 * @param {MetamaskController} theController
 */
function maybeDetectPhishing(theController) {
  async function redirectTab(tabId, url) {
    try {
      return await _webextensionPolyfill.default.tabs.update(tabId, {
        url
      });
    } catch (error) {
      return sentry === null || sentry === void 0 ? void 0 : sentry.captureException(error);
    }
  }
  // we can use the blocking API in MV2, but not in MV3
  const isManifestV2 = !_mv.isManifestV3;
  _webextensionPolyfill.default.webRequest.onBeforeRequest.addListener(details => {
    var _phishingTestResponse, _phishingTestResponse2, _phishingTestResponse3;
    if (details.tabId === _webextensionPolyfill.default.tabs.TAB_ID_NONE) {
      return {};
    }
    const {
      completedOnboarding
    } = theController.onboardingController.state;
    if (!completedOnboarding) {
      return {};
    }
    const prefState = theController.preferencesController.state;
    if (!prefState.usePhishDetect) {
      return {};
    }

    // ignore requests that come from our phishing warning page, as
    // the requests may come from the "continue to site" link, so we'll
    // actually _want_ to bypass the phishing detection. We shouldn't have to
    // do this, because the phishing site does tell the extension that the
    // domain it blocked it now "safe", but it does this _after_ the request
    // begins (which would get blocked by this listener). So we have to bail
    // on detection here.
    // This check can be removed once  https://github.com/MetaMask/phishing-warning/issues/160
    // is shipped.
    if (details.initiator && details.initiator !== 'null' &&
    // compare normalized URLs
    new URL(details.initiator).host === phishingPageUrl.host) {
      return {};
    }
    const {
      hostname,
      href,
      searchParams
    } = new URL(details.url);
    if (inTest) {
      if (searchParams.has('IN_TEST_BYPASS_EARLY_PHISHING_DETECTION')) {
        // this is a test page that needs to bypass early phishing detection
        return {};
      }
    }
    theController.phishingController.maybeUpdateState();
    const blockedRequestResponse = theController.phishingController.isBlockedRequest(details.url);
    let phishingTestResponse;
    if (details.type === 'main_frame' || details.type === 'sub_frame') {
      phishingTestResponse = theController.phishingController.test(details.url);
    }

    // if the request is not blocked, and the phishing test is not blocked, return and don't show the phishing screen
    if (!((_phishingTestResponse = phishingTestResponse) !== null && _phishingTestResponse !== void 0 && _phishingTestResponse.result) && !blockedRequestResponse.result) {
      return {};
    }

    // Determine the block reason based on the type
    let blockReason;
    let blockedUrl = hostname;
    if ((_phishingTestResponse2 = phishingTestResponse) !== null && _phishingTestResponse2 !== void 0 && _phishingTestResponse2.result && blockedRequestResponse.result) {
      blockReason = `${phishingTestResponse.type} and ${blockedRequestResponse.type}`;
    } else if ((_phishingTestResponse3 = phishingTestResponse) !== null && _phishingTestResponse3 !== void 0 && _phishingTestResponse3.result) {
      blockReason = phishingTestResponse.type;
    } else {
      blockReason = blockedRequestResponse.type;
      blockedUrl = details.initiator;
    }
    if (!isFirefox) {
      theController.metaMetricsController.trackEvent({
        // should we differentiate between background redirection and content script redirection?
        event: _metametrics.MetaMetricsEventName.PhishingPageDisplayed,
        category: _metametrics.MetaMetricsEventCategory.Phishing,
        properties: {
          url: blockedUrl,
          referrer: {
            url: blockedUrl
          },
          reason: blockReason,
          requestDomain: blockedRequestResponse.result ? hostname : undefined
        }
      }, {
        excludeMetaMetricsId: true
      });
    }
    const querystring = new URLSearchParams({
      hostname,
      href
    });
    const redirectUrl = new URL(phishingPageHref);
    redirectUrl.hash = querystring.toString();
    const redirectHref = redirectUrl.toString();

    // blocking is better than tab redirection, as blocking will prevent
    // the browser from loading the page at all
    if (isManifestV2) {
      // We can redirect `main_frame` requests directly to the warning page.
      // For non-`main_frame` requests (e.g. `sub_frame` or WebSocket), we cancel them
      // and redirect the whole tab asynchronously so that the user sees the warning.
      if (details.type === 'main_frame') {
        return {
          redirectUrl: redirectHref
        };
      }
      redirectTab(details.tabId, redirectHref);
      return {
        cancel: true
      };
    }
    // redirect the whole tab (even if it's a sub_frame request)
    redirectTab(details.tabId, redirectHref);
    return {};
  }, {
    urls: ['http://*/*', 'https://*/*', 'ws://*/*', 'wss://*/*']
  }, isManifestV2 ? ['blocking'] : []);
}

// These are set after initialization
/**
 * Connects a WindowPostMessage Port to the MetaMask controller.
 * This method identifies trusted (MetaMask) interfaces, and connects them differently from untrusted (web pages).
 *
 * @callback ConnectWindowPostMessage
 * @param {chrome.runtime.Port} remotePort - The port provided by a new context.
 * @returns {void}
 */
/** @type {ConnectWindowPostMessage} */
let connectWindowPostMessage;

/**
 * Connects a externally_connecatable Port to the MetaMask controller.
 * This method identifies dapp clients and connects them differently from extension clients.
 *
 * @callback ConnectExternallyConnectable
 * @param {chrome.runtime.Port} remotePort - The port provided by a new context.
 */
/** @type {ConnectExternallyConnectable} */
let connectExternallyConnectable;

/**
 * Connects a Duplexstream to the MetaMask controller EIP-1193 API (via a multiplexed duplex stream).
 *
 * @callback ConnectEip1193
 * @param {DuplexStream} connectionStream - The duplex stream.
 * @param {chrome.runtime.MessageSender} sender - The remote port sender.
 */
/** @type {ConnectEip1193} */
let connectEip1193;

/**
 * Connects a DuplexStream to the MetaMask controller Caip Multichain API.
 *
 * @callback ConnectCaipMultichain
 * @param {DuplexStream} connectionStream - The duplex stream.
 * @param {chrome.runtime.MessageSender} sender - The remote port sender.
 */
/** @type {ConnectCaipMultichain} */
let connectCaipMultichain;
const corruptionHandler = new _stateCorruptionRecovery.CorruptionHandler();
_webextensionPolyfill.default.runtime.onConnect.addListener(async port => {
  var _getManifestFlags$tes2;
  if (inTest && ((_getManifestFlags$tes2 = (0, _manifestFlags.getManifestFlags)().testing) === null || _getManifestFlags$tes2 === void 0 ? void 0 : _getManifestFlags$tes2.simulateUnresponsiveBackground) === true) {
    return;
  }
  port.postMessage({
    data: {
      method: _backgroundLivenessCheck.BACKGROUND_LIVENESS_METHOD
    },
    name: 'background-liveness'
  });

  // Queue up connection attempts here, waiting until after initialization
  try {
    await isInitialized;

    // This is set in `setupController`, which is called as part of initialization
    connectWindowPostMessage(port);
  } catch (error) {
    sentry === null || sentry === void 0 || sentry.captureException(error);

    // if we have a STATE_CORRUPTION_ERROR tell the user about it and offer to
    // restore from a backup, if we have one.
    if ((0, _errors.isStateCorruptionError)(error)) {
      await corruptionHandler.handleStateCorruptionError({
        port,
        error,
        database: persistenceManager,
        repairCallback: async backup => {
          // we are going to reinitialize the background script, so we need to
          // reset the initialization promises. this is gross since it is
          // possible the original references could have been passed to other
          // functions, and we can't update those references from here.
          // right now, that isn't the case though.
          setGlobalInitializers();
          if ((0, _stateCorruptionRecovery.hasVault)(backup)) {
            await initBackground(backup);
            controller.onboardingController.setFirstTimeFlowType(_onboarding.FirstTimeFlowType.restore);
          } else {
            // if we don't have a backup we need to make sure we clear the state
            // from the database, and then reinitialize the background script
            // with the first time state.
            await persistenceManager.reset();
            await initBackground(null);
          }
        }
      });
    } else {
      var _controller;
      const errorLike = (0, _utils.isObject)(error) ? {
        message: error.message ?? 'Unknown error',
        name: error.name ?? 'UnknownError',
        stack: error.stack
      } : {
        message: String(error),
        name: 'UnknownError',
        stack: ''
      };
      // general errors
      (0, _startUpErrors2.tryPostMessage)(port, _startUpErrors.DISPLAY_GENERAL_STARTUP_ERROR, {
        error: errorLike,
        currentLocale: (_controller = controller) === null || _controller === void 0 || (_controller = _controller.preferencesController) === null || _controller === void 0 || (_controller = _controller.state) === null || _controller === void 0 ? void 0 : _controller.currentLocale
      });
    }
  }
});
_webextensionPolyfill.default.runtime.onConnectExternal.addListener(async (...args) => {
  // Queue up connection attempts here, waiting until after initialization
  await isInitialized;
  // This is set in `setupController`, which is called as part of initialization
  connectExternallyConnectable(...args);
});
function saveTimestamp() {
  const timestamp = new Date().toISOString();
  _webextensionPolyfill.default.storage.session.set({
    timestamp
  });
}

/**
 * @typedef {__import__('@metamask/transaction-controller').TransactionMeta} TransactionMeta
 */

/**
 * The data emitted from the MetaMaskController.store EventEmitter, also used to initialize the MetaMaskController. Available in UI on React state as state.metamask.
 *
 * @typedef MetaMaskState
 * @property {boolean} isInitialized - Whether the first vault has been created.
 * @property {boolean} isUnlocked - Whether the vault is currently decrypted and accounts are available for selection.
 * @property {boolean} isAccountMenuOpen - Represents whether the main account selection UI is currently displayed.
 * @property {boolean} isNetworkMenuOpen - Represents whether the main network selection UI is currently displayed.
 * @property {object} identities - An object matching lower-case hex addresses to Identity objects with "address" and "name" (nickname) keys.
 * @property {object} networkConfigurations - A list of network configurations, containing RPC provider details (eg chainId, rpcUrl, rpcPreferences).
 * @property {Array} addressBook - A list of previously sent to addresses.
 * @property {object} marketData - A map from chain ID -> contract address -> an object containing the token's market data.
 * @property {Array} tokens - Tokens held by the current user, including their balances.
 * @property {object} send - TODO: Document
 * @property {boolean} useBlockie - Indicates preferred user identicon format. True for blockie, false for Jazzicon.
 * @property {object} featureFlags - An object for optional feature flags.
 * @property {boolean} welcomeScreen - True if welcome screen should be shown.
 * @property {string} currentLocale - A locale string matching the user's preferred display language.
 * @property {string} networkStatus - Either "unknown", "available", "unavailable", or "blocked", depending on the status of the currently selected network.
 * @property {object} accounts - An object mapping lower-case hex addresses to objects with "balance" and "address" keys, both storing hex string values.
 * @property {object} accountsByChainId - An object mapping lower-case hex addresses to objects with "balance" and "address" keys, both storing hex string values keyed by chain id.
 * @property {hex} currentBlockGasLimit - The most recently seen block gas limit, in a lower case hex prefixed string.
 * @property {object} currentBlockGasLimitByChainId - The most recently seen block gas limit, in a lower case hex prefixed string keyed by chain id.
 * @property {object} unapprovedPersonalMsgs - An object of messages pending approval, mapping a unique ID to the options.
 * @property {number} unapprovedPersonalMsgCount - The number of messages in unapprovedPersonalMsgs.
 * @property {object} unapprovedEncryptionPublicKeyMsgs - An object of messages pending approval, mapping a unique ID to the options.
 * @property {number} unapprovedEncryptionPublicKeyMsgCount - The number of messages in EncryptionPublicKeyMsgs.
 * @property {object} unapprovedDecryptMsgs - An object of messages pending approval, mapping a unique ID to the options.
 * @property {number} unapprovedDecryptMsgCount - The number of messages in unapprovedDecryptMsgs.
 * @property {object} unapprovedTypedMessages - An object of messages pending approval, mapping a unique ID to the options.
 * @property {number} unapprovedTypedMessagesCount - The number of messages in unapprovedTypedMessages.
 * @property {number} pendingApprovalCount - The number of pending request in the approval controller.
 * @property {Keyring[]} keyrings - An array of keyring descriptions, summarizing the accounts that are available for use, and what keyrings they belong to.
 * @property {string} selectedAddress - A lower case hex string of the currently selected address.
 * @property {string} currentCurrency - A string identifying the user's preferred display currency, for use in showing conversion rates.
 * @property {number} currencyRates - An object mapping of nativeCurrency to conversion rate and date
 * @property {boolean} forgottenPassword - Returns true if the user has initiated the password recovery screen, is recovering from seed phrase.
 */

/**
 * @typedef VersionedData
 * @property {MetaMaskState} data - The data emitted from MetaMask controller, or used to initialize it.
 * @property {number} version - The latest migration version that has been run.
 */

/**
 * Initializes the MetaMask controller, and sets up all platform configuration.
 *
 * @param {Backup | null} backup
 * @returns {Promise} Setup complete.
 */
async function initialize(backup) {
  var _window$navigator;
  const offscreenPromise = _mv.isManifestV3 ? (0, _offscreen.createOffscreen)() : null;
  const initData = await loadStateFromPersistence(backup);
  const initState = initData.data;
  const initLangCode = await (0, _getFirstPreferredLangCode.default)();
  let isFirstMetaMaskControllerSetup;

  // We only want to start this if we are running a test build, not for the release build.
  // `navigator.webdriver` is true if Selenium, Puppeteer, or Playwright are running.
  // In MV3, the Service Worker sees `navigator.webdriver` as `undefined`, so this will trigger from
  // an Offscreen Document message instead. Because it's a singleton class, it's safe to start multiple times.
  if (false && (_window$navigator = window.navigator) !== null && _window$navigator !== void 0 && _window$navigator.webdriver) {
    const {
      getSocketBackgroundToMocha
    } =
    // Use `require` to make it easier to exclude this test code from the Browserify build.
    // eslint-disable-next-line @typescript-eslint/no-require-imports, @typescript-eslint/no-var-requires, node/global-require
    require('../../test/e2e/background-socket/socket-background-to-mocha');
    getSocketBackgroundToMocha();
  }
  if (_mv.isManifestV3) {
    var _initState$Preference;
    // Save the timestamp immediately and then every `SAVE_TIMESTAMP_INTERVAL`
    // miliseconds. This keeps the service worker alive.
    if (((_initState$Preference = initState.PreferencesController) === null || _initState$Preference === void 0 ? void 0 : _initState$Preference.enableMV3TimestampSave) !== false) {
      const SAVE_TIMESTAMP_INTERVAL_MS = 2 * 1000;
      saveTimestamp();
      setInterval(saveTimestamp, SAVE_TIMESTAMP_INTERVAL_MS);
    }
    const sessionData = await _webextensionPolyfill.default.storage.session.get(['isFirstMetaMaskControllerSetup']);
    isFirstMetaMaskControllerSetup = (sessionData === null || sessionData === void 0 ? void 0 : sessionData.isFirstMetaMaskControllerSetup) === undefined;
    await _webextensionPolyfill.default.storage.session.set({
      isFirstMetaMaskControllerSetup
    });
  }
  const overrides = inTest ? {
    keyrings: {
      // Use `require` to make it easier to exclude this test code from the Browserify build.
      // eslint-disable-next-line @typescript-eslint/no-require-imports, @typescript-eslint/no-var-requires, node/global-require
      trezorBridge: require('../../test/stub/keyring-bridge').FakeTrezorBridge,
      // Use `require` to make it easier to exclude this test code from the Browserify build.
      // eslint-disable-next-line @typescript-eslint/no-require-imports, @typescript-eslint/no-var-requires, node/global-require
      ledgerBridge: require('../../test/stub/keyring-bridge').FakeLedgerBridge,
      // Use `require` to make it easier to exclude this test code from the Browserify build.
      // eslint-disable-next-line @typescript-eslint/no-require-imports, @typescript-eslint/no-var-requires, node/global-require
      qrBridge: require('../../test/stub/keyring-bridge').FakeQrBridge
    }
  } : {};
  const preinstalledSnaps = await loadPreinstalledSnaps();
  const cronjobControllerStorageManager = new _CronjobControllerStorageManager.CronjobControllerStorageManager();
  await cronjobControllerStorageManager.init();
  const {
    update,
    requestSafeReload
  } = (0, _safeReload.getRequestSafeReload)(persistenceManager);
  setupController(initState, initLangCode, overrides, isFirstMetaMaskControllerSetup, initData.meta, offscreenPromise, preinstalledSnaps, requestSafeReload, cronjobControllerStorageManager);
  controller.store.on('update', update);
  controller.store.on('error', error => {
    _loglevel.default.error('MetaMask controller.store error:', error);
    sentry === null || sentry === void 0 || sentry.captureException(error);
  });

  // `setupController` sets up the `controller` object, so we can use it now:
  maybeDetectPhishing(controller);
  if (!_mv.isManifestV3) {
    await loadPhishingWarningPage();
  }
  await sendReadyMessageToTabs();
  new _deepLinkRouter.DeepLinkRouter({
    getExtensionURL: platform.getExtensionURL,
    getState: controller.getState.bind(controller)
  }).on('navigate', async ({
    url,
    parsed
  }) => {
    // don't track deep links that are immediately redirected (like /buy)
    if (!('redirectTo' in parsed)) {
      await controller.metaMetricsController.trackEvent((0, _metrics.createEvent)({
        signature: parsed.signature,
        url
      }));
    }
  }).on('error', error => sentry === null || sentry === void 0 ? void 0 : sentry.captureException(error)).install();
}

/**
 * Loads the preinstalled snaps from urls and returns them as an array.
 * It fails if any Snap fails to load in the expected time range.
 * Supports .json.gz files using gzip decompression.
 */
async function loadPreinstalledSnaps() {
  const fetchWithTimeout = (0, _fetchWithTimeout.default)();
  const promises = _snaps.PREINSTALLED_SNAPS_URLS.map(async url => {
    const response = await fetchWithTimeout(url);

    // If the Snap is compressed, decompress it
    if (url.pathname.endsWith('.json.gz')) {
      const ds = new DecompressionStream('gzip');
      const decompressedStream = response.body.pipeThrough(ds);
      return await new Response(decompressedStream).json();
    }
    return await response.json();
  });
  return Promise.all(promises);
}

/**
 * An error thrown if the phishing warning page takes too long to load.
 */
class PhishingWarningPageTimeoutError extends Error {
  constructor() {
    super('Timeout failed');
  }
}

/**
 * Load the phishing warning page temporarily to ensure the service
 * worker has been registered, so that the warning page works offline.
 */
async function loadPhishingWarningPage() {
  let iframe;
  try {
    const extensionStartupPhishingPageUrl = new URL(phishingPageHref);
    // The `extensionStartup` hash signals to the phishing warning page that it should not bother
    // setting up streams for user interaction. Otherwise this page load would cause a console
    // error.
    extensionStartupPhishingPageUrl.hash = '#extensionStartup';
    iframe = window.document.createElement('iframe');
    iframe.setAttribute('src', extensionStartupPhishingPageUrl.href);
    iframe.setAttribute('sandbox', 'allow-scripts allow-same-origin');

    // Create "deferred Promise" to allow passing resolve/reject to event handlers
    let deferredResolve;
    let deferredReject;
    const loadComplete = new Promise((resolve, reject) => {
      deferredResolve = resolve;
      deferredReject = reject;
    });

    // The load event is emitted once loading has completed, even if the loading failed.
    // If loading failed we can't do anything about it, so we don't need to check.
    iframe.addEventListener('load', deferredResolve);

    // This step initiates the page loading.
    window.document.body.appendChild(iframe);

    // This timeout ensures that this iframe gets cleaned up in a reasonable
    // timeframe, and ensures that the "initialization complete" message
    // doesn't get delayed too long.
    setTimeout(() => deferredReject(new PhishingWarningPageTimeoutError()), PHISHING_WARNING_PAGE_TIMEOUT);
    await loadComplete;
  } catch (error) {
    if (error instanceof PhishingWarningPageTimeoutError) {
      console.warn('Phishing warning page timeout; page not guaranteed to work offline.');
    } else {
      console.error('Failed to initialize phishing warning page', error);
    }
  } finally {
    if (iframe) {
      iframe.remove();
    }
  }
}

//
// State and Persistence
//

/**
 * Loads any stored data, prioritizing the latest storage strategy.
 * Migrates that data schema in case it was last loaded on an older version.
 *
 * @param {Backup | null} backup
 * @returns {Promise<{data: MetaMaskState meta: {version: number}}>} Last data emitted from previous instance of MetaMask.
 */
async function loadStateFromPersistence(backup) {
  var _preMigrationVersione, _preMigrationVersione2;
  if (null) {
    const withState = JSON.parse(null);

    // Use `require` to make it easier to exclude this test code from the Browserify build.
    // eslint-disable-next-line @typescript-eslint/no-require-imports, @typescript-eslint/no-var-requires, node/global-require
    const {
      generateWalletState
    } = require('./fixtures/generate-wallet-state');
    const fixtureBuilder = await generateWalletState(withState, false);
    const stateOverrides = fixtureBuilder.fixture.data;
    firstTimeState = {
      ...firstTimeState,
      ...stateOverrides
    };
  }

  // read from disk
  // first from preferred, async API:
  /**
   * @type {__import__("./lib/stores/base-store").MetaMaskStorageStructure | undefined}
   */
  let preMigrationVersionedData;
  if (backup) {
    preMigrationVersionedData = {
      data: {},
      meta: {}
    };
    for (const key of _persistenceManager.backedUpStateKeys) {
      if ((0, _utils.hasProperty)(backup, key)) {
        preMigrationVersionedData.data[key] = backup[key];
      }
    }
    // use the meta property from the backup if it exists, that way the
    // migrations will behave correctly.
    if ((0, _utils.hasProperty)(backup, 'meta') && (0, _utils.isObject)(backup.meta)) {
      preMigrationVersionedData.meta = backup.meta;
    }
    // sanity check on the meta property
    if (typeof preMigrationVersionedData.meta.version !== 'number') {
      _loglevel.default.error("The `backup`'s `meta.version` property was missing during backup restore.");
      // the last migration version before we started storing backups was `155`
      // so we can use that version as a fallback.
      preMigrationVersionedData.meta.version = 155;
    }
  } else {
    const validateVault = true;
    preMigrationVersionedData = await persistenceManager.get({
      validateVault
    });
  }
  const migrator = new _migrator.default({
    migrations: _migrations.default,
    defaultVersion: null ?
    // eslint-disable-next-line @typescript-eslint/no-require-imports, @typescript-eslint/no-var-requires, node/global-require
    require('../../test/e2e/default-fixture').FIXTURE_STATE_METADATA_VERSION : null
  });

  // report migration errors to sentry
  migrator.on('error', err => {
    console.warn(err);
    // get vault structure without secrets
    const vaultStructure = (0, _getObjStructure.default)(preMigrationVersionedData);
    sentry.captureException(err, {
      // "extra" key is required by Sentry
      extra: {
        vaultStructure
      }
    });
  });
  if (!((_preMigrationVersione = preMigrationVersionedData) !== null && _preMigrationVersione !== void 0 && _preMigrationVersione.data) && !((_preMigrationVersione2 = preMigrationVersionedData) !== null && _preMigrationVersione2 !== void 0 && _preMigrationVersione2.meta)) {
    preMigrationVersionedData = migrator.generateInitialState(firstTimeState);
  }

  // migrate data
  const versionedData = await migrator.migrateData(preMigrationVersionedData);
  if (!versionedData) {
    throw new Error('MetaMask - migrator returned undefined');
  } else if (!(0, _utils.isObject)(versionedData.meta)) {
    throw new Error(`MetaMask - migrator metadata has invalid type '${typeof versionedData.meta}'`);
  } else if (typeof versionedData.meta.version !== 'number') {
    throw new Error(`MetaMask - migrator metadata version has invalid type '${typeof versionedData.meta.version}'`);
  } else if (!(0, _utils.isObject)(versionedData.data)) {
    throw new Error(`MetaMask - migrator data has invalid type '${typeof versionedData.data}'`);
  }
  // this initializes the meta/version data as a class variable to be used for future writes
  persistenceManager.setMetadata(versionedData.meta);

  // write to disk
  await persistenceManager.set(versionedData.data);

  // return just the data
  return versionedData;
}

/**
 * Emit event of DappViewed,
 * which should only be tracked only after a user opts into metrics and connected to the dapp
 *
 * @param {string} origin - URL of visited dapp
 */
function emitDappViewedMetricEvent(origin) {
  const {
    metaMetricsId
  } = controller.metaMetricsController.state;
  if (!(0, _util.shouldEmitDappViewedEvent)(metaMetricsId)) {
    return;
  }
  const numberOfConnectedAccounts = controller.getPermittedAccounts(origin).length;
  if (numberOfConnectedAccounts === 0) {
    return;
  }
  const preferencesState = controller.controllerMessenger.call('PreferencesController:getState');
  const numberOfTotalAccounts = Object.keys(preferencesState.identities).length;
  controller.metaMetricsController.trackEvent({
    event: _metametrics.MetaMetricsEventName.DappViewed,
    category: _metametrics.MetaMetricsEventCategory.InpageProvider,
    referrer: {
      url: origin
    },
    properties: {
      is_first_visit: false,
      number_of_accounts: numberOfTotalAccounts,
      number_of_accounts_connected: numberOfConnectedAccounts
    }
  }, {
    excludeMetaMetricsId: true
  });
}

/**
 * Track dapp connection when loaded and permissioned
 *
 * @param {chrome.runtime.Port} remotePort - The port provided by a new context.
 */
function trackDappView(remotePort) {
  var _remotePort$sender, _remotePort$sender2, _remotePort$sender3;
  if (!((_remotePort$sender = remotePort.sender) !== null && _remotePort$sender !== void 0 && _remotePort$sender.tab) || !((_remotePort$sender2 = remotePort.sender) !== null && _remotePort$sender2 !== void 0 && _remotePort$sender2.url) || !((_remotePort$sender3 = remotePort.sender) !== null && _remotePort$sender3 !== void 0 && (_remotePort$sender3 = _remotePort$sender3.tab) !== null && _remotePort$sender3 !== void 0 && _remotePort$sender3.url)) {
    return;
  }
  const tabId = remotePort.sender.tab.id;
  const url = new URL(remotePort.sender.url);
  const {
    origin
  } = url;
  const tabUrl = new URL(remotePort.sender.tab.url);
  const {
    origin: tabOrigin
  } = tabUrl;

  // store the origin to corresponding tab so it can provide info for onActivated listener
  if (!Object.keys(senderOriginMapping).includes(tabId)) {
    senderOriginMapping[tabId] = origin;
  }
  // do the same for tab origin, which can be different to sender origin
  if (!(tabId in tabOriginMapping)) {
    tabOriginMapping[tabId] = tabOrigin;
  }
  const isConnectedToDapp = controller.controllerMessenger.call('PermissionController:hasPermissions', origin);

  // when open a new tab, this event will trigger twice, only 2nd time is with dapp loaded
  const isTabLoaded = remotePort.sender.tab.title !== 'New Tab';

  // *** Emit DappViewed metric event when ***
  // - refresh the dapp
  // - open dapp in a new tab
  if (isConnectedToDapp && isTabLoaded) {
    emitDappViewedMetricEvent(origin);
  }
}

/**
 * Emit App Opened event
 */
function emitAppOpenedMetricEvent() {
  const {
    metaMetricsId,
    participateInMetaMetrics
  } = controller.metaMetricsController.state;

  // Skip if user hasn't opted into metrics
  if (metaMetricsId === null && !participateInMetaMetrics) {
    return;
  }
  controller.metaMetricsController.trackEvent({
    event: _metametrics.MetaMetricsEventName.AppOpened,
    category: _metametrics.MetaMetricsEventCategory.App
  });
}

/**
 * This function checks if the app is being opened
 * and emits an event only if no other UI instances are currently open.
 *
 * @param {string} environment - The environment type where the app is opening
 */
function trackAppOpened(environment) {
  // List of valid environment types to track
  const environmentTypeList = [_app.ENVIRONMENT_TYPE_POPUP, _app.ENVIRONMENT_TYPE_NOTIFICATION, _app.ENVIRONMENT_TYPE_FULLSCREEN];

  // Check if any UI instances are currently open
  const isFullscreenOpen = Object.values(openMetamaskTabsIDs).some(Boolean);
  const isAlreadyOpen = isFullscreenOpen || notificationIsOpen || openPopupCount > 0;

  // Only emit event if no UI is open and environment is valid
  if (!isAlreadyOpen && environmentTypeList.includes(environment)) {
    emitAppOpenedMetricEvent();
  }
}

/**
 * Initializes the MetaMask Controller with any initial state and default language.
 * Configures platform-specific error reporting strategy.
 * Streams emitted state updates to platform-specific storage strategy.
 * Creates platform listeners for new Dapps/Contexts, and sets up their data connections to the controller.
 *
 * @param {object} initState - The initial state to start the controller with, matches the state that is emitted from the controller.
 * @param {string} initLangCode - The region code for the language preferred by the current user.
 * @param {object} overrides - object with callbacks that are allowed to override the setup controller logic
 * @param isFirstMetaMaskControllerSetup
 * @param {object} stateMetadata - Metadata about the initial state and migrations, including the most recent migration version
 * @param {Promise<void>} offscreenPromise - A promise that resolves when the offscreen document has finished initialization.
 * @param {Array} preinstalledSnaps - A list of preinstalled Snaps loaded from disk during boot.
 * @param {() => Promise<void>)} requestSafeReload - A function that requests a safe reload of the extension.
 * @param {CronjobControllerStorageManager} cronjobControllerStorageManager - A storage manager for the CronjobController.
 */
function setupController(initState, initLangCode, overrides, isFirstMetaMaskControllerSetup, stateMetadata, offscreenPromise, preinstalledSnaps, requestSafeReload, cronjobControllerStorageManager) {
  //
  // MetaMask Controller
  //
  controller = new _metamaskController.default({
    infuraProjectId: globalThis.INFURA_PROJECT_ID,
    // User confirmation callbacks:
    showUserConfirmation: triggerUi,
    // initial state
    initState,
    // initial locale code
    initLangCode,
    // platform specific api
    platform,
    notificationManager,
    browser: _webextensionPolyfill.default,
    getRequestAccountTabIds: () => {
      return requestAccountTabIds;
    },
    getOpenMetamaskTabsIds: () => {
      return openMetamaskTabsIDs;
    },
    overrides,
    isFirstMetaMaskControllerSetup,
    currentMigrationVersion: stateMetadata.version,
    featureFlags: {},
    offscreenPromise,
    preinstalledSnaps,
    requestSafeReload,
    cronjobControllerStorageManager
  });
  (0, _setup.default)({
    getCurrentChainId: () => (0, _networks.getCurrentChainId)({
      metamask: controller.networkController.state
    }),
    getIpfsGateway: controller.preferencesController.getIpfsGateway.bind(controller.preferencesController),
    getUseAddressBarEnsResolution: () => controller.preferencesController.state.useAddressBarEnsResolution,
    provider: controller.provider
  });
  setupSentryGetStateGlobal(controller);
  const isClientOpenStatus = () => {
    return openPopupCount > 0 || Boolean(Object.keys(openMetamaskTabsIDs).length) || notificationIsOpen;
  };
  const onCloseEnvironmentInstances = (isClientOpen, environmentType) => {
    // if all instances of metamask are closed we call a method on the controller to stop gasFeeController polling
    if (isClientOpen === false) {
      controller.onClientClosed();
      // otherwise we want to only remove the polling tokens for the environment type that has closed
    } else {
      // in the case of fullscreen environment a user might have multiple tabs open so we don't want to disconnect all of
      // its corresponding polling tokens unless all tabs are closed.
      if (environmentType === _app.ENVIRONMENT_TYPE_FULLSCREEN && Boolean(Object.keys(openMetamaskTabsIDs).length)) {
        return;
      }
      controller.onEnvironmentTypeClosed(environmentType);
    }
  };
  connectWindowPostMessage = remotePort => {
    var _remotePort$sender4;
    const processName = remotePort.name;
    if (metamaskBlockedPorts.includes(remotePort.name)) {
      return;
    }
    let isMetaMaskInternalProcess = false;
    const senderUrl = (_remotePort$sender4 = remotePort.sender) !== null && _remotePort$sender4 !== void 0 && _remotePort$sender4.url ? new URL(remotePort.sender.url) : null;
    if (isFirefox) {
      isMetaMaskInternalProcess = metamaskInternalProcessHash[processName];
    } else {
      isMetaMaskInternalProcess = (senderUrl === null || senderUrl === void 0 ? void 0 : senderUrl.origin) === `chrome-extension://${_webextensionPolyfill.default.runtime.id}`;
    }
    if (isMetaMaskInternalProcess) {
      var _overrides$getPortStr;
      const portStream = (overrides === null || overrides === void 0 || (_overrides$getPortStr = overrides.getPortStream) === null || _overrides$getPortStr === void 0 ? void 0 : _overrides$getPortStr.call(overrides, remotePort)) || new _extensionPortStream.default(remotePort);
      // communication with popup
      controller.isClientOpen = true;
      controller.setupTrustedCommunication(portStream, remotePort.sender);
      trackAppOpened(processName);
      initializeRemoteFeatureFlags();
      if (processName === _app.ENVIRONMENT_TYPE_POPUP) {
        openPopupCount += 1;
        (0, _readableStream.finished)(portStream, () => {
          openPopupCount -= 1;
          const isClientOpen = isClientOpenStatus();
          controller.isClientOpen = isClientOpen;
          onCloseEnvironmentInstances(isClientOpen, _app.ENVIRONMENT_TYPE_POPUP);
        });
      }
      if (processName === _app.ENVIRONMENT_TYPE_NOTIFICATION) {
        notificationIsOpen = true;
        (0, _readableStream.finished)(portStream, () => {
          notificationIsOpen = false;
          const isClientOpen = isClientOpenStatus();
          controller.isClientOpen = isClientOpen;
          onCloseEnvironmentInstances(isClientOpen, _app.ENVIRONMENT_TYPE_NOTIFICATION);
        });
      }
      if (processName === _app.ENVIRONMENT_TYPE_FULLSCREEN) {
        const tabId = remotePort.sender.tab.id;
        openMetamaskTabsIDs[tabId] = true;
        (0, _readableStream.finished)(portStream, () => {
          delete openMetamaskTabsIDs[tabId];
          const isClientOpen = isClientOpenStatus();
          controller.isClientOpen = isClientOpen;
          onCloseEnvironmentInstances(isClientOpen, _app.ENVIRONMENT_TYPE_FULLSCREEN);
        });
      }
    } else if (senderUrl && senderUrl.origin === phishingPageUrl.origin && senderUrl.pathname === phishingPageUrl.pathname) {
      var _overrides$getPortStr2;
      const portStreamForPhishingPage = (overrides === null || overrides === void 0 || (_overrides$getPortStr2 = overrides.getPortStream) === null || _overrides$getPortStr2 === void 0 ? void 0 : _overrides$getPortStr2.call(overrides, remotePort)) || new _extensionPortStream.default(remotePort);
      controller.setupPhishingCommunication({
        connectionStream: portStreamForPhishingPage
      });
    } else {
      var _overrides$getPortStr4;
      // this is triggered when a new tab is opened, or origin(url) is changed
      if (remotePort.sender && remotePort.sender.tab && remotePort.sender.url) {
        const tabId = remotePort.sender.tab.id;
        const url = new URL(remotePort.sender.url);
        const {
          origin
        } = url;
        trackDappView(remotePort);
        remotePort.onMessage.addListener(msg => {
          if (msg.data && msg.data.method === _app.MESSAGE_TYPE.ETH_REQUEST_ACCOUNTS) {
            requestAccountTabIds[origin] = tabId;
          }
        });
      }
      if (senderUrl && _marketingSiteWhitelist.COOKIE_ID_MARKETING_WHITELIST_ORIGINS.some(origin => origin === senderUrl.origin)) {
        var _overrides$getPortStr3;
        const portStreamForCookieHandlerPage = (overrides === null || overrides === void 0 || (_overrides$getPortStr3 = overrides.getPortStream) === null || _overrides$getPortStr3 === void 0 ? void 0 : _overrides$getPortStr3.call(overrides, remotePort)) || new _extensionPortStream.default(remotePort);
        controller.setUpCookieHandlerCommunication({
          connectionStream: portStreamForCookieHandlerPage
        });
      }
      const portStream = (overrides === null || overrides === void 0 || (_overrides$getPortStr4 = overrides.getPortStream) === null || _overrides$getPortStr4 === void 0 ? void 0 : _overrides$getPortStr4.call(overrides, remotePort)) || new _extensionPortStream.default(remotePort);
      connectEip1193(portStream, remotePort.sender);

      // for firefox and manifest v2 (non production webpack builds)
      // we expose the multichain provider via window.postMessage
      if (isFirefox || !_mv.isManifestV3) {
        const mux = (0, _streamUtils.setupMultiplex)(portStream);
        mux.ignoreStream(_stream.METAMASK_EIP_1193_PROVIDER);
        connectCaipMultichain(mux.createStream(_stream.METAMASK_CAIP_MULTICHAIN_PROVIDER), remotePort.sender);
      }
    }
  };
  connectExternallyConnectable = remotePort => {
    var _overrides$getPortStr5;
    const portStream = (overrides === null || overrides === void 0 || (_overrides$getPortStr5 = overrides.getPortStream) === null || _overrides$getPortStr5 === void 0 ? void 0 : _overrides$getPortStr5.call(overrides, remotePort)) || new _extensionPortStream.default(remotePort);

    // if the sender.id value is present it means the caller is an extension rather
    // than a site. When the caller is an extension we want to fallback to connecting
    // it with the 1193 provider
    const isDappConnecting = !remotePort.sender.id;
    if (isDappConnecting) {
      if (metamaskBlockedPorts.includes(remotePort.name)) {
        return;
      }

      // this is triggered when a new tab is opened, or origin(url) is changed
      trackDappView(remotePort);
      connectCaipMultichain((0, _caipStream.createCaipStream)(portStream), remotePort.sender);
    } else {
      connectEip1193(portStream, remotePort.sender);
    }
  };
  connectEip1193 = (connectionStream, sender) => {
    controller.setupUntrustedCommunicationEip1193({
      connectionStream,
      sender
    });
  };
  connectCaipMultichain = (connectionStream, sender) => {
    controller.setupUntrustedCommunicationCaip({
      connectionStream,
      sender
    });
  };
  if (overrides !== null && overrides !== void 0 && overrides.registerConnectListeners) {
    overrides.registerConnectListeners(connectWindowPostMessage, connectEip1193);
  }

  //
  // User Interface setup
  //
  updateBadge();
  controller.controllerMessenger.subscribe(_metamaskController.METAMASK_CONTROLLER_EVENTS.DECRYPT_MESSAGE_MANAGER_UPDATE_BADGE, updateBadge);
  controller.controllerMessenger.subscribe(_metamaskController.METAMASK_CONTROLLER_EVENTS.ENCRYPTION_PUBLIC_KEY_MANAGER_UPDATE_BADGE, updateBadge);
  controller.signatureController.hub.on(_metamaskController.METAMASK_CONTROLLER_EVENTS.UPDATE_BADGE, updateBadge);
  controller.controllerMessenger.subscribe(_metamaskController.METAMASK_CONTROLLER_EVENTS.APP_STATE_UNLOCK_CHANGE, updateBadge);
  controller.controllerMessenger.subscribe(_metamaskController.METAMASK_CONTROLLER_EVENTS.APPROVAL_STATE_CHANGE, updateBadge);
  controller.controllerMessenger.subscribe(_metamaskController.METAMASK_CONTROLLER_EVENTS.METAMASK_NOTIFICATIONS_LIST_UPDATED, updateBadge);
  controller.controllerMessenger.subscribe(_metamaskController.METAMASK_CONTROLLER_EVENTS.METAMASK_NOTIFICATIONS_MARK_AS_READ, updateBadge);

  /**
   * Formats a count for display as a badge label.
   *
   * @param {number} count - The count to be formatted.
   * @param {number} maxCount - The maximum count to display before using the '+' suffix.
   * @returns {string} The formatted badge label.
   */
  function getBadgeLabel(count, maxCount) {
    return count > maxCount ? `${maxCount}+` : String(count);
  }

  /**
   * Updates the Web Extension's "badge" number, on the little fox in the toolbar.
   * The number reflects the current number of pending transactions or message signatures needing user approval.
   */
  function updateBadge() {
    const pendingApprovalCount = getPendingApprovalCount();
    const unreadNotificationsCount = getUnreadNotificationsCount();
    let label = '';
    let badgeColor = BADGE_COLOR_APPROVAL;
    if (pendingApprovalCount) {
      label = getBadgeLabel(pendingApprovalCount, BADGE_MAX_COUNT);
    } else if (unreadNotificationsCount > 0) {
      label = getBadgeLabel(unreadNotificationsCount, BADGE_MAX_COUNT);
      badgeColor = BADGE_COLOR_NOTIFICATION;
    }
    try {
      const badgeText = {
        text: label
      };
      const badgeBackgroundColor = {
        color: badgeColor
      };
      if (_mv.isManifestV3) {
        _webextensionPolyfill.default.action.setBadgeText(badgeText);
        _webextensionPolyfill.default.action.setBadgeBackgroundColor(badgeBackgroundColor);
      } else {
        _webextensionPolyfill.default.browserAction.setBadgeText(badgeText);
        _webextensionPolyfill.default.browserAction.setBadgeBackgroundColor(badgeBackgroundColor);
      }
    } catch (error) {
      console.error('Error updating browser badge:', error);
    }
  }

  /**
   * Initializes remote feature flags by making a request to fetch them from the clientConfigApi.
   * This function is called when MM is during internal process.
   * If the request fails, the error will be logged but won't interrupt extension initialization.
   *
   * @returns {Promise<void>} A promise that resolves when the remote feature flags have been updated.
   */
  async function initializeRemoteFeatureFlags() {
    try {
      // initialize the request to fetch remote feature flags
      await controller.remoteFeatureFlagController.updateRemoteFeatureFlags();
    } catch (error) {
      _loglevel.default.error('Error initializing remote feature flags:', error);
    }
  }
  function getPendingApprovalCount() {
    try {
      const pendingApprovalCount = controller.appStateController.waitingForUnlock.length + controller.approvalController.getTotalApprovalCount();
      return pendingApprovalCount;
    } catch (error) {
      console.error('Failed to get pending approval count:', error);
      return 0;
    }
  }
  function getUnreadNotificationsCount() {
    try {
      const {
        isNotificationServicesEnabled,
        isFeatureAnnouncementsEnabled
      } = controller.notificationServicesController.state;
      const snapNotificationCount = Object.values(controller.notificationServicesController.state.metamaskNotificationsList).filter(notification => notification.type === _notificationServicesController.NotificationServicesController.Constants.TRIGGER_TYPES.SNAP && notification.readDate === null).length;
      const featureAnnouncementCount = isFeatureAnnouncementsEnabled ? controller.notificationServicesController.state.metamaskNotificationsList.filter(notification => !notification.isRead && notification.type === _notificationServicesController.NotificationServicesController.Constants.TRIGGER_TYPES.FEATURES_ANNOUNCEMENT).length : 0;
      const walletNotificationCount = isNotificationServicesEnabled ? controller.notificationServicesController.state.metamaskNotificationsList.filter(notification => !notification.isRead && notification.type !== _notificationServicesController.NotificationServicesController.Constants.TRIGGER_TYPES.FEATURES_ANNOUNCEMENT && notification.type !== _notificationServicesController.NotificationServicesController.Constants.TRIGGER_TYPES.SNAP).length : 0;
      const unreadNotificationsCount = snapNotificationCount + featureAnnouncementCount + walletNotificationCount;
      return unreadNotificationsCount;
    } catch (error) {
      console.error('Failed to get unread notifications count:', error);
      return 0;
    }
  }
  notificationManager.on(_notificationManager.NOTIFICATION_MANAGER_EVENTS.POPUP_CLOSED, ({
    automaticallyClosed
  }) => {
    if (!automaticallyClosed) {
      rejectUnapprovedNotifications();
    } else if (getPendingApprovalCount() > 0) {
      triggerUi();
    }
    updateBadge();
  });
  function rejectUnapprovedNotifications() {
    controller.signatureController.rejectUnapproved(_metametrics.REJECT_NOTIFICATION_CLOSE_SIG);
    controller.decryptMessageController.rejectUnapproved(_metametrics.REJECT_NOTIFICATION_CLOSE);
    controller.encryptionPublicKeyController.rejectUnapproved(_metametrics.REJECT_NOTIFICATION_CLOSE);
    controller.rejectAllPendingApprovals();
  }

  // Updates the snaps registry and check for newly blocked snaps to block if the user has at least one snap installed that isn't preinstalled.
  if (Object.values(controller.snapController.state.snaps).some(snap => !snap.preinstalled)) {
    controller.snapController.updateRegistry();
  }
}

//
// Etc...
//

/**
 * Opens the browser popup for user confirmation
 */
async function triggerUi() {
  const tabs = await platform.getActiveTabs();
  const currentlyActiveMetamaskTab = Boolean(tabs.find(tab => openMetamaskTabsIDs[tab.id]));
  // Vivaldi is not closing port connection on popup close, so openPopupCount does not work correctly
  // To be reviewed in the future if this behaviour is fixed - also the way we determine isVivaldi variable might change at some point
  const isVivaldi = tabs.length > 0 && tabs[0].extData && tabs[0].extData.indexOf('vivaldi_tab') > -1;
  if (!uiIsTriggering && (isVivaldi || openPopupCount === 0) && !currentlyActiveMetamaskTab) {
    uiIsTriggering = true;
    try {
      const currentPopupId = controller.appStateController.getCurrentPopupId();
      await notificationManager.showPopup(newPopupId => controller.appStateController.setCurrentPopupId(newPopupId), currentPopupId);
    } finally {
      uiIsTriggering = false;
    }
  }
}

// It adds the "App Installed" event into a queue of events, which will be tracked only after a user opts into metrics.
const addAppInstalledEvent = () => {
  if (controller) {
    controller.metaMetricsController.updateTraits({
      [_metametrics.MetaMetricsUserTrait.InstallDateExt]: new Date().toISOString().split('T')[0] // yyyy-mm-dd
    });
    controller.metaMetricsController.addEventBeforeMetricsOptIn({
      category: _metametrics.MetaMetricsEventCategory.App,
      event: _metametrics.MetaMetricsEventName.AppInstalled,
      properties: {}
    });
    return;
  }
  setTimeout(() => {
    // If the controller is not set yet, we wait and try to add the "App Installed" event again.
    addAppInstalledEvent();
  }, 500);
};

/**
 * Handles the onInstalled event.
 *
 * @param {chrome.runtime.InstalledDetails} details
 */
function handleOnInstalled(details) {
  if (details.reason === 'install') {
    onInstall();
  } else if (details.reason === 'update' && details.previousVersion && details.previousVersion !== platform.getVersion()) {
    onUpdate();
  }
}

/**
 * Trigger actions that should happen only upon initial install (e.g. open tab for onboarding).
 */
function onInstall() {
  _loglevel.default.debug('First install detected');
  addAppInstalledEvent();
  if (!false && !true) {
    platform.openExtensionInBrowser();
  }
}

/**
 * Trigger actions that should happen only upon update installation
 */
async function onUpdate() {
  await isInitialized;
  _loglevel.default.debug('Update installation detected');
  controller.appStateController.setLastUpdatedAt(Date.now());
}

/**
 * Trigger actions that should happen only when an update is available
 */
async function onUpdateAvailable() {
  await isInitialized;
  _loglevel.default.debug('An update is available');
  controller.appStateController.setIsUpdateAvailable(true);
}
_webextensionPolyfill.default.runtime.onUpdateAvailable.addListener(onUpdateAvailable);
function onNavigateToTab() {
  _webextensionPolyfill.default.tabs.onActivated.addListener(onActivatedTab => {
    if (controller) {
      const {
        tabId
      } = onActivatedTab;
      const currentOrigin = senderOriginMapping[tabId];
      const currentTabOrigin = tabOriginMapping[tabId];
      // *** Emit DappViewed metric event when ***
      // - navigate to a connected dapp
      if (currentOrigin) {
        const connectSitePermissions = controller.permissionController.state.subjects[currentOrigin];
        // when the dapp is not connected, connectSitePermissions is undefined
        const isConnectedToDapp = connectSitePermissions !== undefined;
        if (isConnectedToDapp) {
          emitDappViewedMetricEvent(currentOrigin);
        }
      }

      // If the connected dApp is Hyperliquid, trigger the referral flow
      if (currentTabOrigin === _referrals.HYPERLIQUID_ORIGIN) {
        const connectSitePermissions = controller.permissionController.state.subjects[currentTabOrigin];
        // when the dapp is not connected, connectSitePermissions is undefined
        const isConnectedToDapp = connectSitePermissions !== undefined;
        if (isConnectedToDapp) {
          controller.handleHyperliquidReferral(tabId, _createHyperliquidReferralMiddleware.HyperliquidPermissionTriggerType.OnNavigateConnectedTab).catch(error => {
            _loglevel.default.error('Failed to handle Hyperliquid referral after navigation to connected tab: ', error);
          });
        }
      }
    }
  });
}
function setupSentryGetStateGlobal(store) {
  global.stateHooks.getSentryAppState = function () {
    const backgroundState = store.memStore.getState();
    return (0, _object.maskObject)(backgroundState, _sentryState.SENTRY_BACKGROUND_STATE);
  };
}

/**
 *
 * @param {Backup | null} backup
 */
async function initBackground(backup) {
  onNavigateToTab();
  try {
    await initialize(backup);
    if (false) {
      // Send message to offscreen document
      if (_webextensionPolyfill.default.offscreen) {
        _webextensionPolyfill.default.runtime.sendMessage({
          target: _offscreenCommunication.OffscreenCommunicationTarget.extension,
          event: _offscreenCommunication.OffscreenCommunicationEvents.metamaskBackgroundReady
        });
      } else {
        var _window$document;
        (_window$document = window.document) === null || _window$document === void 0 || (_window$document = _window$document.documentElement) === null || _window$document === void 0 || _window$document.classList.add('controller-loaded');
      }
    }
    persistenceManager.cleanUpMostRecentRetrievedState();
    _loglevel.default.info('MetaMask initialization complete.');
    resolveInitialization();
  } catch (error) {
    _loglevel.default.error(error);
    rejectInitialization(error);
  }
}
if (!false) {
  initBackground(null);
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\background.js",}]],["D:\\code\\v\\metamask-extension\\app\\scripts\\background.js"],{})

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
