LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\wordlists\\lib\\lang-it.js", {"./wordlist":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\wordlists\\lib\\wordlist.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@ethersproject%5Cwordlists%5Clib%5Clang-it.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.langIt = void 0;
var wordlist_1 = require("./wordlist");
var words = "AbacoAbbaglioAbbinatoAbeteAbissoAbolireAbrasivoAbrogatoAccadereAccennoAccusatoAcetoneAchilleAcidoAcquaAcreAcrilicoAcrobataAcutoAdagioAddebitoAddomeAdeguatoAderireAdipeAdottareAdulareAffabileAffettoAffissoAffrantoAforismaAfosoAfricanoAgaveAgenteAgevoleAggancioAgireAgitareAgonismoAgricoloAgrumetoAguzzoAlabardaAlatoAlbatroAlberatoAlboAlbumeAlceAlcolicoAlettoneAlfaAlgebraAlianteAlibiAlimentoAllagatoAllegroAllievoAllodolaAllusivoAlmenoAlogenoAlpacaAlpestreAltalenaAlternoAlticcioAltroveAlunnoAlveoloAlzareAmalgamaAmanitaAmarenaAmbitoAmbratoAmebaAmericaAmetistaAmicoAmmassoAmmendaAmmirareAmmonitoAmoreAmpioAmpliareAmuletoAnacardoAnagrafeAnalistaAnarchiaAnatraAncaAncellaAncoraAndareAndreaAnelloAngeloAngolareAngustoAnimaAnnegareAnnidatoAnnoAnnuncioAnonimoAnticipoAnziApaticoAperturaApodeApparireAppetitoAppoggioApprodoAppuntoAprileArabicaArachideAragostaAraldicaArancioAraturaArazzoArbitroArchivioArditoArenileArgentoArgineArgutoAriaArmoniaArneseArredatoArringaArrostoArsenicoArsoArteficeArzilloAsciuttoAscoltoAsepsiAsetticoAsfaltoAsinoAsolaAspiratoAsproAssaggioAsseAssolutoAssurdoAstaAstenutoAsticeAstrattoAtavicoAteismoAtomicoAtonoAttesaAttivareAttornoAttritoAttualeAusilioAustriaAutistaAutonomoAutunnoAvanzatoAvereAvvenireAvvisoAvvolgereAzioneAzotoAzzimoAzzurroBabeleBaccanoBacinoBacoBadessaBadilataBagnatoBaitaBalconeBaldoBalenaBallataBalzanoBambinoBandireBaraondaBarbaroBarcaBaritonoBarlumeBaroccoBasilicoBassoBatostaBattutoBauleBavaBavosaBeccoBeffaBelgioBelvaBendaBenevoleBenignoBenzinaBereBerlinaBetaBibitaBiciBidoneBifidoBigaBilanciaBimboBinocoloBiologoBipedeBipolareBirbanteBirraBiscottoBisestoBisnonnoBisonteBisturiBizzarroBlandoBlattaBollitoBonificoBordoBoscoBotanicoBottinoBozzoloBraccioBradipoBramaBrancaBravuraBretellaBrevettoBrezzaBrigliaBrillanteBrindareBroccoloBrodoBronzinaBrulloBrunoBubboneBucaBudinoBuffoneBuioBulboBuonoBurloneBurrascaBussolaBustaCadettoCaducoCalamaroCalcoloCalesseCalibroCalmoCaloriaCambusaCamerataCamiciaCamminoCamolaCampaleCanapaCandelaCaneCaninoCanottoCantinaCapaceCapelloCapitoloCapogiroCapperoCapraCapsulaCarapaceCarcassaCardoCarismaCarovanaCarrettoCartolinaCasaccioCascataCasermaCasoCassoneCastelloCasualeCatastaCatenaCatrameCautoCavilloCedibileCedrataCefaloCelebreCellulareCenaCenoneCentesimoCeramicaCercareCertoCerumeCervelloCesoiaCespoCetoChelaChiaroChiccaChiedereChimeraChinaChirurgoChitarraCiaoCiclismoCifrareCignoCilindroCiottoloCircaCirrosiCitricoCittadinoCiuffoCivettaCivileClassicoClinicaCloroCoccoCodardoCodiceCoerenteCognomeCollareColmatoColoreColposoColtivatoColzaComaCometaCommandoComodoComputerComuneConcisoCondurreConfermaCongelareConiugeConnessoConoscereConsumoContinuoConvegnoCopertoCopioneCoppiaCopricapoCorazzaCordataCoricatoCorniceCorollaCorpoCorredoCorsiaCorteseCosmicoCostanteCotturaCovatoCratereCravattaCreatoCredereCremosoCrescitaCretaCricetoCrinaleCrisiCriticoCroceCronacaCrostataCrucialeCruscaCucireCuculoCuginoCullatoCupolaCuratoreCursoreCurvoCuscinoCustodeDadoDainoDalmataDamerinoDanielaDannosoDanzareDatatoDavantiDavveroDebuttoDecennioDecisoDeclinoDecolloDecretoDedicatoDefinitoDeformeDegnoDelegareDelfinoDelirioDeltaDemenzaDenotatoDentroDepositoDerapataDerivareDerogaDescrittoDesertoDesiderioDesumereDetersivoDevotoDiametroDicembreDiedroDifesoDiffusoDigerireDigitaleDiluvioDinamicoDinnanziDipintoDiplomaDipoloDiradareDireDirottoDirupoDisagioDiscretoDisfareDisgeloDispostoDistanzaDisumanoDitoDivanoDiveltoDividereDivoratoDobloneDocenteDoganaleDogmaDolceDomatoDomenicaDominareDondoloDonoDormireDoteDottoreDovutoDozzinaDragoDruidoDubbioDubitareDucaleDunaDuomoDupliceDuraturoEbanoEccessoEccoEclissiEconomiaEderaEdicolaEdileEditoriaEducareEgemoniaEgliEgoismoEgregioElaboratoElargireEleganteElencatoElettoElevareElficoElicaElmoElsaElusoEmanatoEmblemaEmessoEmiroEmotivoEmozioneEmpiricoEmuloEndemicoEnduroEnergiaEnfasiEnotecaEntrareEnzimaEpatiteEpilogoEpisodioEpocaleEppureEquatoreErarioErbaErbosoEredeEremitaErigereErmeticoEroeErosivoErranteEsagonoEsameEsanimeEsaudireEscaEsempioEsercitoEsibitoEsigenteEsistereEsitoEsofagoEsortatoEsosoEspansoEspressoEssenzaEssoEstesoEstimareEstoniaEstrosoEsultareEtilicoEtnicoEtruscoEttoEuclideoEuropaEvasoEvidenzaEvitatoEvolutoEvvivaFabbricaFaccendaFachiroFalcoFamigliaFanaleFanfaraFangoFantasmaFareFarfallaFarinosoFarmacoFasciaFastosoFasulloFaticareFatoFavolosoFebbreFecolaFedeFegatoFelpaFeltroFemminaFendereFenomenoFermentoFerroFertileFessuraFestivoFettaFeudoFiabaFiduciaFifaFiguratoFiloFinanzaFinestraFinireFioreFiscaleFisicoFiumeFlaconeFlamencoFleboFlemmaFloridoFluenteFluoroFobicoFocacciaFocosoFoderatoFoglioFolataFolcloreFolgoreFondenteFoneticoFoniaFontanaForbitoForchettaForestaFormicaFornaioForoFortezzaForzareFosfatoFossoFracassoFranaFrassinoFratelloFreccettaFrenataFrescoFrigoFrollinoFrondeFrugaleFruttaFucilataFucsiaFuggenteFulmineFulvoFumanteFumettoFumosoFuneFunzioneFuocoFurboFurgoneFuroreFusoFutileGabbianoGaffeGalateoGallinaGaloppoGamberoGammaGaranziaGarboGarofanoGarzoneGasdottoGasolioGastricoGattoGaudioGazeboGazzellaGecoGelatinaGelsoGemelloGemmatoGeneGenitoreGennaioGenotipoGergoGhepardoGhiaccioGhisaGialloGildaGineproGiocareGioielloGiornoGioveGiratoGironeGittataGiudizioGiuratoGiustoGlobuloGlutineGnomoGobbaGolfGomitoGommoneGonfioGonnaGovernoGracileGradoGraficoGrammoGrandeGrattareGravosoGraziaGrecaGreggeGrifoneGrigioGrinzaGrottaGruppoGuadagnoGuaioGuantoGuardareGufoGuidareIbernatoIconaIdenticoIdillioIdoloIdraIdricoIdrogenoIgieneIgnaroIgnoratoIlareIllesoIllogicoIlludereImballoImbevutoImboccoImbutoImmaneImmersoImmolatoImpaccoImpetoImpiegoImportoImprontaInalareInarcareInattivoIncantoIncendioInchinoIncisivoInclusoIncontroIncrocioIncuboIndagineIndiaIndoleIneditoInfattiInfilareInflittoIngaggioIngegnoIngleseIngordoIngrossoInnescoInodoreInoltrareInondatoInsanoInsettoInsiemeInsonniaInsulinaIntasatoInteroIntonacoIntuitoInumidireInvalidoInveceInvitoIperboleIpnoticoIpotesiIppicaIrideIrlandaIronicoIrrigatoIrrorareIsolatoIsotopoIstericoIstitutoIstriceItaliaIterareLabbroLabirintoLaccaLaceratoLacrimaLacunaLaddoveLagoLampoLancettaLanternaLardosoLargaLaringeLastraLatenzaLatinoLattugaLavagnaLavoroLegaleLeggeroLemboLentezzaLenzaLeoneLepreLesivoLessatoLestoLetteraleLevaLevigatoLiberoLidoLievitoLillaLimaturaLimitareLimpidoLineareLinguaLiquidoLiraLiricaLiscaLiteLitigioLivreaLocandaLodeLogicaLombareLondraLongevoLoquaceLorenzoLotoLotteriaLuceLucidatoLumacaLuminosoLungoLupoLuppoloLusingaLussoLuttoMacabroMacchinaMaceroMacinatoMadamaMagicoMagliaMagneteMagroMaiolicaMalafedeMalgradoMalintesoMalsanoMaltoMalumoreManaManciaMandorlaMangiareManifestoMannaroManovraMansardaMantideManubrioMappaMaratonaMarcireMarettaMarmoMarsupioMascheraMassaiaMastinoMaterassoMatricolaMattoneMaturoMazurcaMeandroMeccanicoMecenateMedesimoMeditareMegaMelassaMelisMelodiaMeningeMenoMensolaMercurioMerendaMerloMeschinoMeseMessereMestoloMetalloMetodoMettereMiagolareMicaMicelioMicheleMicroboMidolloMieleMiglioreMilanoMiliteMimosaMineraleMiniMinoreMirinoMirtilloMiscelaMissivaMistoMisurareMitezzaMitigareMitraMittenteMnemonicoModelloModificaModuloMoganoMogioMoleMolossoMonasteroMoncoMondinaMonetarioMonileMonotonoMonsoneMontatoMonvisoMoraMordereMorsicatoMostroMotivatoMotosegaMottoMovenzaMovimentoMozzoMuccaMucosaMuffaMughettoMugnaioMulattoMulinelloMultiploMummiaMuntoMuovereMuraleMusaMuscoloMusicaMutevoleMutoNababboNaftaNanometroNarcisoNariceNarratoNascereNastrareNaturaleNauticaNaviglioNebulosaNecrosiNegativoNegozioNemmenoNeofitaNerettoNervoNessunoNettunoNeutraleNeveNevroticoNicchiaNinfaNitidoNobileNocivoNodoNomeNominaNordicoNormaleNorvegeseNostranoNotareNotiziaNotturnoNovellaNucleoNullaNumeroNuovoNutrireNuvolaNuzialeOasiObbedireObbligoObeliscoOblioOboloObsoletoOccasioneOcchioOccidenteOccorrereOccultareOcraOculatoOdiernoOdorareOffertaOffrireOffuscatoOggettoOggiOgnunoOlandeseOlfattoOliatoOlivaOlogrammaOltreOmaggioOmbelicoOmbraOmegaOmissioneOndosoOnereOniceOnnivoroOnorevoleOntaOperatoOpinioneOppostoOracoloOrafoOrdineOrecchinoOreficeOrfanoOrganicoOrigineOrizzonteOrmaOrmeggioOrnativoOrologioOrrendoOrribileOrtensiaOrticaOrzataOrzoOsareOscurareOsmosiOspedaleOspiteOssaOssidareOstacoloOsteOtiteOtreOttagonoOttimoOttobreOvaleOvestOvinoOviparoOvocitoOvunqueOvviareOzioPacchettoPacePacificoPadellaPadronePaesePagaPaginaPalazzinaPalesarePallidoPaloPaludePandoroPannelloPaoloPaonazzoPapricaParabolaParcellaParerePargoloPariParlatoParolaPartireParvenzaParzialePassivoPasticcaPataccaPatologiaPattumePavonePeccatoPedalarePedonalePeggioPelosoPenarePendicePenisolaPennutoPenombraPensarePentolaPepePepitaPerbenePercorsoPerdonatoPerforarePergamenaPeriodoPermessoPernoPerplessoPersuasoPertugioPervasoPesatorePesistaPesoPestiferoPetaloPettinePetulantePezzoPiacerePiantaPiattinoPiccinoPicozzaPiegaPietraPifferoPigiamaPigolioPigroPilaPiliferoPillolaPilotaPimpantePinetaPinnaPinoloPioggiaPiomboPiramidePireticoPiritePirolisiPitonePizzicoPlaceboPlanarePlasmaPlatanoPlenarioPochezzaPoderosoPodismoPoesiaPoggiarePolentaPoligonoPollicePolmonitePolpettaPolsoPoltronaPolverePomicePomodoroPontePopolosoPorfidoPorosoPorporaPorrePortataPosaPositivoPossessoPostulatoPotassioPoterePranzoPrassiPraticaPreclusoPredicaPrefissoPregiatoPrelievoPremerePrenotarePreparatoPresenzaPretestoPrevalsoPrimaPrincipePrivatoProblemaProcuraProdurreProfumoProgettoProlungaPromessaPronomePropostaProrogaProtesoProvaPrudentePrugnaPruritoPsichePubblicoPudicaPugilatoPugnoPulcePulitoPulsantePuntarePupazzoPupillaPuroQuadroQualcosaQuasiQuerelaQuotaRaccoltoRaddoppioRadicaleRadunatoRafficaRagazzoRagioneRagnoRamarroRamingoRamoRandagioRantolareRapatoRapinaRappresoRasaturaRaschiatoRasenteRassegnaRastrelloRataRavvedutoRealeRecepireRecintoReclutaReconditoRecuperoRedditoRedimereRegalatoRegistroRegolaRegressoRelazioneRemareRemotoRennaReplicaReprimereReputareResaResidenteResponsoRestauroReteRetinaRetoricaRettificaRevocatoRiassuntoRibadireRibelleRibrezzoRicaricaRiccoRicevereRiciclatoRicordoRicredutoRidicoloRidurreRifasareRiflessoRiformaRifugioRigareRigettatoRighelloRilassatoRilevatoRimanereRimbalzoRimedioRimorchioRinascitaRincaroRinforzoRinnovoRinomatoRinsavitoRintoccoRinunciaRinvenireRiparatoRipetutoRipienoRiportareRipresaRipulireRisataRischioRiservaRisibileRisoRispettoRistoroRisultatoRisvoltoRitardoRitegnoRitmicoRitrovoRiunioneRivaRiversoRivincitaRivoltoRizomaRobaRoboticoRobustoRocciaRocoRodaggioRodereRoditoreRogitoRollioRomanticoRompereRonzioRosolareRospoRotanteRotondoRotulaRovescioRubizzoRubricaRugaRullinoRumineRumorosoRuoloRupeRussareRusticoSabatoSabbiareSabotatoSagomaSalassoSaldaturaSalgemmaSalivareSalmoneSaloneSaltareSalutoSalvoSapereSapidoSaporitoSaracenoSarcasmoSartoSassosoSatelliteSatiraSatolloSaturnoSavanaSavioSaziatoSbadiglioSbalzoSbancatoSbarraSbattereSbavareSbendareSbirciareSbloccatoSbocciatoSbrinareSbruffoneSbuffareScabrosoScadenzaScalaScambiareScandaloScapolaScarsoScatenareScavatoSceltoScenicoScettroSchedaSchienaSciarpaScienzaScindereScippoSciroppoScivoloSclerareScodellaScolpitoScompartoSconfortoScoprireScortaScossoneScozzeseScribaScrollareScrutinioScuderiaScultoreScuolaScuroScusareSdebitareSdoganareSeccaturaSecondoSedanoSeggiolaSegnalatoSegregatoSeguitoSelciatoSelettivoSellaSelvaggioSemaforoSembrareSemeSeminatoSempreSensoSentireSepoltoSequenzaSerataSerbatoSerenoSerioSerpenteSerraglioServireSestinaSetolaSettimanaSfaceloSfaldareSfamatoSfarzosoSfaticatoSferaSfidaSfilatoSfingeSfocatoSfoderareSfogoSfoltireSforzatoSfrattoSfruttatoSfuggitoSfumareSfusoSgabelloSgarbatoSgonfiareSgorbioSgrassatoSguardoSibiloSiccomeSierraSiglaSignoreSilenzioSillabaSimboloSimpaticoSimulatoSinfoniaSingoloSinistroSinoSintesiSinusoideSiparioSismaSistoleSituatoSlittaSlogaturaSlovenoSmarritoSmemoratoSmentitoSmeraldoSmilzoSmontareSmottatoSmussatoSnellireSnervatoSnodoSobbalzoSobrioSoccorsoSocialeSodaleSoffittoSognoSoldatoSolenneSolidoSollazzoSoloSolubileSolventeSomaticoSommaSondaSonettoSonniferoSopireSoppesoSopraSorgereSorpassoSorrisoSorsoSorteggioSorvolatoSospiroSostaSottileSpadaSpallaSpargereSpatolaSpaventoSpazzolaSpecieSpedireSpegnereSpelaturaSperanzaSpessoreSpettraleSpezzatoSpiaSpigolosoSpillatoSpinosoSpiraleSplendidoSportivoSposoSprangaSprecareSpronatoSpruzzoSpuntinoSquilloSradicareSrotolatoStabileStaccoStaffaStagnareStampatoStantioStarnutoStaseraStatutoSteloSteppaSterzoStilettoStimaStirpeStivaleStizzosoStonatoStoricoStrappoStregatoStriduloStrozzareStruttoStuccareStufoStupendoSubentroSuccosoSudoreSuggeritoSugoSultanoSuonareSuperboSupportoSurgelatoSurrogatoSussurroSuturaSvagareSvedeseSveglioSvelareSvenutoSveziaSviluppoSvistaSvizzeraSvoltaSvuotareTabaccoTabulatoTacciareTaciturnoTaleTalismanoTamponeTanninoTaraTardivoTargatoTariffaTarpareTartarugaTastoTatticoTavernaTavolataTazzaTecaTecnicoTelefonoTemerarioTempoTemutoTendoneTeneroTensioneTentacoloTeoremaTermeTerrazzoTerzettoTesiTesseratoTestatoTetroTettoiaTifareTigellaTimbroTintoTipicoTipografoTiraggioTiroTitanioTitoloTitubanteTizioTizzoneToccareTollerareToltoTombolaTomoTonfoTonsillaTopazioTopologiaToppaTorbaTornareTorroneTortoraToscanoTossireTostaturaTotanoTraboccoTracheaTrafilaTragediaTralcioTramontoTransitoTrapanoTrarreTraslocoTrattatoTraveTrecciaTremolioTrespoloTributoTrichecoTrifoglioTrilloTrinceaTrioTristezzaTrituratoTrivellaTrombaTronoTroppoTrottolaTrovareTruccatoTubaturaTuffatoTulipanoTumultoTunisiaTurbareTurchinoTutaTutelaUbicatoUccelloUccisoreUdireUditivoUffaUfficioUgualeUlisseUltimatoUmanoUmileUmorismoUncinettoUngereUnghereseUnicornoUnificatoUnisonoUnitarioUnteUovoUpupaUraganoUrgenzaUrloUsanzaUsatoUscitoUsignoloUsuraioUtensileUtilizzoUtopiaVacanteVaccinatoVagabondoVagliatoValangaValgoValicoVallettaValorosoValutareValvolaVampataVangareVanitosoVanoVantaggioVanveraVaporeVaranoVarcatoVarianteVascaVedettaVedovaVedutoVegetaleVeicoloVelcroVelinaVellutoVeloceVenatoVendemmiaVentoVeraceVerbaleVergognaVerificaVeroVerrucaVerticaleVescicaVessilloVestaleVeteranoVetrinaVetustoViandanteVibranteVicendaVichingoVicinanzaVidimareVigiliaVignetoVigoreVileVillanoViminiVincitoreViolaViperaVirgolaVirologoVirulentoViscosoVisioneVispoVissutoVisuraVitaVitelloVittimaVivandaVividoViziareVoceVogaVolatileVolereVolpeVoragineVulcanoZampognaZannaZappatoZatteraZavorraZefiroZelanteZeloZenzeroZerbinoZibettoZincoZirconeZittoZollaZoticoZuccheroZufoloZuluZuppa";
var wordlist = null;
function loadWords(lang) {
    if (wordlist != null) {
        return;
    }
    wordlist = words.replace(/([A-Z])/g, " $1").toLowerCase().substring(1).split(" ");
    // Verify the computed list matches the official list
    /* istanbul ignore if */
    if (wordlist_1.Wordlist.check(lang) !== "0x5c1362d88fd4cf614a96f3234941d29f7d37c08c5292fde03bf62c2db6ff7620") {
        wordlist = null;
        throw new Error("BIP39 Wordlist for it (Italian) FAILED");
    }
}
var LangIt = /** @class */ (function (_super) {
    __extends(LangIt, _super);
    function LangIt() {
        return _super.call(this, "it") || this;
    }
    LangIt.prototype.getWord = function (index) {
        loadWords(this);
        return wordlist[index];
    };
    LangIt.prototype.getWordIndex = function (word) {
        loadWords(this);
        return wordlist.indexOf(word);
    };
    return LangIt;
}(wordlist_1.Wordlist));
var langIt = new LangIt();
exports.langIt = langIt;
wordlist_1.Wordlist.register(langIt);

      };
    };
  }
  }
}, {package:"ethers>@ethersproject/wordlists",file:"node_modules\\@ethersproject\\wordlists\\lib\\lang-it.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\wordlists\\lib\\lang-ja.js", {"./wordlist":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\wordlists\\lib\\wordlist.js","@ethersproject/bytes":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\bytes\\lib\\index.js","@ethersproject/strings":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\strings\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@ethersproject%5Cwordlists%5Clib%5Clang-ja.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.langJa = void 0;
var bytes_1 = require("@ethersproject/bytes");
var strings_1 = require("@ethersproject/strings");
var wordlist_1 = require("./wordlist");
var data = [
    // 4-kana words
    "AQRASRAGBAGUAIRAHBAghAURAdBAdcAnoAMEAFBAFCBKFBQRBSFBCXBCDBCHBGFBEQBpBBpQBIkBHNBeOBgFBVCBhBBhNBmOBmRBiHBiFBUFBZDBvFBsXBkFBlcBjYBwDBMBBTBBTRBWBBWXXaQXaRXQWXSRXCFXYBXpHXOQXHRXhRXuRXmXXbRXlXXwDXTRXrCXWQXWGaBWaKcaYgasFadQalmaMBacAKaRKKBKKXKKjKQRKDRKCYKCRKIDKeVKHcKlXKjHKrYNAHNBWNaRNKcNIBNIONmXNsXNdXNnBNMBNRBNrXNWDNWMNFOQABQAHQBrQXBQXFQaRQKXQKDQKOQKFQNBQNDQQgQCXQCDQGBQGDQGdQYXQpBQpQQpHQLXQHuQgBQhBQhCQuFQmXQiDQUFQZDQsFQdRQkHQbRQlOQlmQPDQjDQwXQMBQMDQcFQTBQTHQrDDXQDNFDGBDGQDGRDpFDhFDmXDZXDbRDMYDRdDTRDrXSAhSBCSBrSGQSEQSHBSVRShYShkSyQSuFSiBSdcSoESocSlmSMBSFBSFKSFNSFdSFcCByCaRCKcCSBCSRCCrCGbCEHCYXCpBCpQCIBCIHCeNCgBCgFCVECVcCmkCmwCZXCZFCdRClOClmClFCjDCjdCnXCwBCwXCcRCFQCFjGXhGNhGDEGDMGCDGCHGIFGgBGVXGVEGVRGmXGsXGdYGoSGbRGnXGwXGwDGWRGFNGFLGFOGFdGFkEABEBDEBFEXOEaBEKSENBENDEYXEIgEIkEgBEgQEgHEhFEudEuFEiBEiHEiFEZDEvBEsXEsFEdXEdREkFEbBEbRElFEPCEfkEFNYAEYAhYBNYQdYDXYSRYCEYYoYgQYgRYuRYmCYZTYdBYbEYlXYjQYRbYWRpKXpQopQnpSFpCXpIBpISphNpdBpdRpbRpcZpFBpFNpFDpFopFrLADLBuLXQLXcLaFLCXLEhLpBLpFLHXLeVLhILdHLdRLoDLbRLrXIABIBQIBCIBsIBoIBMIBRIXaIaRIKYIKRINBINuICDIGBIIDIIkIgRIxFIyQIiHIdRIbYIbRIlHIwRIMYIcRIRVITRIFBIFNIFQOABOAFOBQOaFONBONMOQFOSFOCDOGBOEQOpBOLXOIBOIFOgQOgFOyQOycOmXOsXOdIOkHOMEOMkOWWHBNHXNHXWHNXHDuHDRHSuHSRHHoHhkHmRHdRHkQHlcHlRHwBHWcgAEgAggAkgBNgBQgBEgXOgYcgLXgHjgyQgiBgsFgdagMYgWSgFQgFEVBTVXEVKBVKNVKDVKYVKRVNBVNYVDBVDxVSBVSRVCjVGNVLXVIFVhBVhcVsXVdRVbRVlRhBYhKYhDYhGShxWhmNhdahdkhbRhjohMXhTRxAXxXSxKBxNBxEQxeNxeQxhXxsFxdbxlHxjcxFBxFNxFQxFOxFoyNYyYoybcyMYuBQuBRuBruDMuCouHBudQukkuoBulVuMXuFEmCYmCRmpRmeDmiMmjdmTFmFQiADiBOiaRiKRiNBiNRiSFiGkiGFiERipRiLFiIFihYibHijBijEiMXiWBiFBiFCUBQUXFUaRUNDUNcUNRUNFUDBUSHUCDUGBUGFUEqULNULoUIRUeEUeYUgBUhFUuRUiFUsXUdFUkHUbBUjSUjYUwXUMDUcHURdUTBUrBUrXUrQZAFZXZZaRZKFZNBZQFZCXZGBZYdZpBZLDZIFZHXZHNZeQZVRZVFZmXZiBZvFZdFZkFZbHZbFZwXZcCZcRZRBvBQvBGvBLvBWvCovMYsAFsBDsaRsKFsNFsDrsSHsSFsCXsCRsEBsEHsEfspBsLBsLDsIgsIRseGsbRsFBsFQsFSdNBdSRdCVdGHdYDdHcdVbdySduDdsXdlRdwXdWYdWcdWRkBMkXOkaRkNIkNFkSFkCFkYBkpRkeNkgBkhVkmXksFklVkMBkWDkFNoBNoaQoaFoNBoNXoNaoNEoSRoEroYXoYCoYbopRopFomXojkowXorFbBEbEIbdBbjYlaRlDElMXlFDjKjjSRjGBjYBjYkjpRjLXjIBjOFjeVjbRjwBnXQnSHnpFnLXnINnMBnTRwXBwXNwXYwNFwQFwSBwGFwLXwLDweNwgBwuHwjDwnXMBXMpFMIBMeNMTHcaQcNBcDHcSFcCXcpBcLXcLDcgFcuFcnXcwXccDcTQcrFTQErXNrCHrpFrgFrbFrTHrFcWNYWNbWEHWMXWTR",
    // 5-kana words
    "ABGHABIJAEAVAYJQALZJAIaRAHNXAHdcAHbRAZJMAZJRAZTRAdVJAklmAbcNAjdRAMnRAMWYAWpRAWgRAFgBAFhBAFdcBNJBBNJDBQKBBQhcBQlmBDEJBYJkBYJTBpNBBpJFBIJBBIJDBIcABOKXBOEJBOVJBOiJBOZJBepBBeLXBeIFBegBBgGJBVJXBuocBiJRBUJQBlXVBlITBwNFBMYVBcqXBTlmBWNFBWiJBWnRBFGHBFwXXKGJXNJBXNZJXDTTXSHSXSVRXSlHXCJDXGQJXEhXXYQJXYbRXOfXXeNcXVJFXhQJXhEJXdTRXjdXXMhBXcQTXRGBXTEBXTnQXFCXXFOFXFgFaBaFaBNJaBCJaBpBaBwXaNJKaNJDaQIBaDpRaEPDaHMFamDJalEJaMZJaFaFaFNBaFQJaFLDaFVHKBCYKBEBKBHDKXaFKXGdKXEJKXpHKXIBKXZDKXwXKKwLKNacKNYJKNJoKNWcKDGdKDTRKChXKGaRKGhBKGbRKEBTKEaRKEPTKLMDKLWRKOHDKVJcKdBcKlIBKlOPKFSBKFEPKFpFNBNJNJBQNBGHNBEPNBHXNBgFNBVXNBZDNBsXNBwXNNaRNNJDNNJENNJkNDCJNDVDNGJRNJiDNZJNNsCJNJFNNFSBNFCXNFEPNFLXNFIFQJBFQCaRQJEQQLJDQLJFQIaRQOqXQHaFQHHQQVJXQVJDQhNJQmEIQZJFQsJXQJrFQWbRDJABDBYJDXNFDXCXDXLXDXZDDXsJDQqXDSJFDJCXDEPkDEqXDYmQDpSJDOCkDOGQDHEIDVJDDuDuDWEBDJFgSBNDSBSFSBGHSBIBSBTQSKVYSJQNSJQiSJCXSEqXSJYVSIiJSOMYSHAHSHaQSeCFSepQSegBSHdHSHrFShSJSJuHSJUFSkNRSrSrSWEBSFaHSJFQSFCXSFGDSFYXSFODSFgBSFVXSFhBSFxFSFkFSFbBSFMFCADdCJXBCXaFCXKFCXNFCXCXCXGBCXEJCXYBCXLDCXIBCXOPCXHXCXgBCXhBCXiBCXlDCXcHCJNBCJNFCDCJCDGBCDVXCDhBCDiDCDJdCCmNCpJFCIaRCOqXCHCHCHZJCViJCuCuCmddCJiFCdNBCdHhClEJCnUJCreSCWlgCWTRCFBFCFNBCFYBCFVFCFhFCFdSCFTBCFWDGBNBGBQFGJBCGBEqGBpBGBgQGNBEGNJYGNkOGNJRGDUFGJpQGHaBGJeNGJeEGVBlGVKjGiJDGvJHGsVJGkEBGMIJGWjNGFBFGFCXGFGBGFYXGFpBGFMFEASJEAWpEJNFECJVEIXSEIQJEOqXEOcFEeNcEHEJEHlFEJgFEhlmEmDJEmZJEiMBEUqXEoSREPBFEPXFEPKFEPSFEPEFEPpFEPLXEPIBEJPdEPcFEPTBEJnXEqlHEMpREFCXEFODEFcFYASJYJAFYBaBYBVXYXpFYDhBYCJBYJGFYYbRYeNcYJeVYiIJYZJcYvJgYvJRYJsXYsJFYMYMYreVpBNHpBEJpBwXpQxFpYEJpeNDpJeDpeSFpeCHpHUJpHbBpHcHpmUJpiiJpUJrpsJuplITpFaBpFQqpFGBpFEfpFYBpFpBpFLJpFIDpFgBpFVXpFyQpFuFpFlFpFjDpFnXpFwXpJFMpFTBLXCJLXEFLXhFLXUJLXbFLalmLNJBLSJQLCLCLGJBLLDJLHaFLeNFLeSHLeCXLepFLhaRLZsJLsJDLsJrLocaLlLlLMdbLFNBLFSBLFEHLFkFIBBFIBXFIBaQIBKXIBSFIBpHIBLXIBgBIBhBIBuHIBmXIBiFIBZXIBvFIBbFIBjQIBwXIBWFIKTRIQUJIDGFICjQIYSRIINXIJeCIVaRImEkIZJFIvJRIsJXIdCJIJoRIbBQIjYBIcqXITFVIreVIFKFIFSFIFCJIFGFIFLDIFIBIJFOIFgBIFVXIJFhIFxFIFmXIFdHIFbBIJFrIJFWOBGBOQfXOOKjOUqXOfXBOqXEOcqXORVJOFIBOFlDHBIOHXiFHNTRHCJXHIaRHHJDHHEJHVbRHZJYHbIBHRsJHRkDHWlmgBKFgBSBgBCDgBGHgBpBgBIBgBVJgBuBgBvFgKDTgQVXgDUJgGSJgOqXgmUMgZIJgTUJgWIEgFBFgFNBgFDJgFSFgFGBgFYXgJFOgFgQgFVXgFhBgFbHgJFWVJABVQKcVDgFVOfXVeDFVhaRVmGdViJYVMaRVFNHhBNDhBCXhBEqhBpFhBLXhNJBhSJRheVXhhKEhxlmhZIJhdBQhkIJhbMNhMUJhMZJxNJgxQUJxDEkxDdFxSJRxplmxeSBxeCXxeGFxeYXxepQxegBxWVcxFEQxFLXxFIBxFgBxFxDxFZtxFdcxFbBxFwXyDJXyDlcuASJuDJpuDIBuCpJuGSJuIJFueEFuZIJusJXudWEuoIBuWGJuFBcuFKEuFNFuFQFuFDJuFGJuFVJuFUtuFdHuFTBmBYJmNJYmQhkmLJDmLJomIdXmiJYmvJRmsJRmklmmMBymMuCmclmmcnQiJABiJBNiJBDiBSFiBCJiBEFiBYBiBpFiBLXiBTHiJNciDEfiCZJiECJiJEqiOkHiHKFieNDiHJQieQcieDHieSFieCXieGFieEFieIHiegFihUJixNoioNXiFaBiFKFiFNDiFEPiFYXitFOitFHiFgBiFVEiFmXiFitiFbBiFMFiFrFUCXQUIoQUIJcUHQJUeCEUHwXUUJDUUqXUdWcUcqXUrnQUFNDUFSHUFCFUFEfUFLXUtFOZBXOZXSBZXpFZXVXZEQJZEJkZpDJZOqXZeNHZeCDZUqXZFBQZFEHZFLXvBAFvBKFvBCXvBEPvBpHvBIDvBgFvBuHvQNJvFNFvFGBvFIBvJFcsXCDsXLXsXsXsXlFsXcHsQqXsJQFsEqXseIFsFEHsFjDdBxOdNpRdNJRdEJbdpJRdhZJdnSJdrjNdFNJdFQHdFhNkNJDkYaRkHNRkHSRkVbRkuMRkjSJkcqDoSJFoEiJoYZJoOfXohEBoMGQocqXbBAFbBXFbBaFbBNDbBGBbBLXbBTBbBWDbGJYbIJHbFQqbFpQlDgQlOrFlVJRjGEBjZJRnXvJnXbBnEfHnOPDngJRnxfXnUJWwXEJwNpJwDpBwEfXwrEBMDCJMDGHMDIJMLJDcQGDcQpHcqXccqNFcqCXcFCJRBSBRBGBRBEJRBpQTBNFTBQJTBpBTBVXTFABTFSBTFCFTFGBTFMDrXCJrXLDrDNJrEfHrFQJrFitWNjdWNTR",
    // 6-kana words
    "AKLJMANOPFASNJIAEJWXAYJNRAIIbRAIcdaAeEfDAgidRAdjNYAMYEJAMIbRAFNJBAFpJFBBIJYBDZJFBSiJhBGdEBBEJfXBEJqXBEJWRBpaUJBLXrXBIYJMBOcfXBeEfFBestXBjNJRBcDJOBFEqXXNvJRXDMBhXCJNYXOAWpXONJWXHDEBXeIaRXhYJDXZJSJXMDJOXcASJXFVJXaBQqXaBZJFasXdQaFSJQaFEfXaFpJHaFOqXKBNSRKXvJBKQJhXKEJQJKEJGFKINJBKIJjNKgJNSKVElmKVhEBKiJGFKlBgJKjnUJKwsJYKMFIJKFNJDKFIJFKFOfXNJBSFNJBCXNBpJFNJBvQNJBMBNJLJXNJOqXNJeCXNJeGFNdsJCNbTKFNwXUJQNFEPQDiJcQDMSJQSFpBQGMQJQJeOcQyCJEQUJEBQJFBrQFEJqDXDJFDJXpBDJXIMDGiJhDIJGRDJeYcDHrDJDVXgFDkAWpDkIgRDjDEqDMvJRDJFNFDJFIBSKclmSJQOFSJQVHSJQjDSJGJBSJGJFSECJoSHEJqSJHTBSJVJDSViJYSZJNBSJsJDSFSJFSFEfXSJFLXCBUJVCJXSBCJXpBCXVJXCJXsXCJXdFCJNJHCLIJgCHiJFCVNJMChCJhCUHEJCsJTRCJdYcCoQJCCFEfXCFIJgCFUJxCFstFGJBaQGJBIDGQJqXGYJNRGJHKFGeQqDGHEJFGJeLXGHIiJGHdBlGUJEBGkIJTGFQPDGJFEqEAGegEJIJBEJVJXEhQJTEiJNcEJZJFEJoEqEjDEqEPDsXEPGJBEPOqXEPeQFEfDiDEJfEFEfepQEfMiJEqXNBEqDIDEqeSFEqVJXEMvJRYXNJDYXEJHYKVJcYYJEBYJeEcYJUqXYFpJFYFstXpAZJMpBSJFpNBNFpeQPDpHLJDpHIJFpHgJFpeitFpHZJFpJFADpFSJFpJFCJpFOqXpFitBpJFZJLXIJFLIJgRLVNJWLVHJMLwNpJLFGJBLFLJDLFOqXLJFUJIBDJXIBGJBIJBYQIJBIBIBOqXIBcqDIEGJFILNJTIIJEBIOiJhIJeNBIJeIBIhiJIIWoTRIJFAHIJFpBIJFuHIFUtFIJFTHOSBYJOEcqXOHEJqOvBpFOkVJrObBVJOncqDOcNJkHhNJRHuHJuHdMhBgBUqXgBsJXgONJBgHNJDgHHJQgJeitgHsJXgJyNagyDJBgZJDrgsVJQgkEJNgkjSJgJFAHgFCJDgFZtMVJXNFVXQfXVJXDJVXoQJVQVJQVDEfXVDvJHVEqNFVeQfXVHpJFVHxfXVVJSRVVmaRVlIJOhCXVJhHjYkhxCJVhWVUJhWiJcxBNJIxeEqDxfXBFxcFEPxFSJFxFYJXyBDQJydaUJyFOPDuYCJYuLvJRuHLJXuZJLDuFOPDuFZJHuFcqXmKHJdmCQJcmOsVJiJAGFitLCFieOfXiestXiZJMEikNJQirXzFiFQqXiFIJFiFZJFiFvtFUHpJFUteIcUteOcUVCJkUhdHcUbEJEUJqXQUMNJhURjYkUFitFZDGJHZJIxDZJVJXZJFDJZJFpQvBNJBvBSJFvJxBrseQqDsVFVJdFLJDkEJNBkmNJYkFLJDoQJOPoGsJRoEAHBoEJfFbBQqDbBZJHbFVJXlFIJBjYIrXjeitcjjCEBjWMNBwXQfXwXOaFwDsJXwCJTRwrCZJMDNJQcDDJFcqDOPRYiJFTBsJXTQIJBTFEfXTFLJDrXEJFrEJXMrFZJFWEJdEWYTlm",
    // 7-kana words
    "ABCDEFACNJTRAMBDJdAcNJVXBLNJEBXSIdWRXErNJkXYDJMBXZJCJaXMNJaYKKVJKcKDEJqXKDcNJhKVJrNYKbgJVXKFVJSBNBYBwDNJeQfXNJeEqXNhGJWENJFiJRQlIJbEQJfXxDQqXcfXQFNDEJQFwXUJDYcnUJDJIBgQDIUJTRDJFEqDSJQSJFSJQIJFSOPeZtSJFZJHCJXQfXCTDEqFGJBSJFGJBOfXGJBcqXGJHNJDGJRLiJEJfXEqEJFEJPEFpBEJYJBZJFYBwXUJYiJMEBYJZJyTYTONJXpQMFXFpeGIDdpJFstXpJFcPDLBVSJRLHQJqXLJFZJFIJBNJDIJBUqXIBkFDJIJEJPTIYJGWRIJeQPDIJeEfHIJFsJXOqGDSFHXEJqXgJCsJCgGQJqXgdQYJEgFMFNBgJFcqDVJwXUJVJFZJchIgJCCxOEJqXxOwXUJyDJBVRuscisciJBiJBieUtqXiJFDJkiFsJXQUGEZJcUJFsJXZtXIrXZDZJDrZJFNJDZJFstXvJFQqXvJFCJEsJXQJqkhkNGBbDJdTRbYJMEBlDwXUJMEFiJFcfXNJDRcNJWMTBLJXC",
    // 8-kana words
    "BraFUtHBFSJFdbNBLJXVJQoYJNEBSJBEJfHSJHwXUJCJdAZJMGjaFVJXEJPNJBlEJfFiJFpFbFEJqIJBVJCrIBdHiJhOPFChvJVJZJNJWxGFNIFLueIBQJqUHEJfUFstOZJDrlXEASJRlXVJXSFwVJNJWD",
    // 9-kana words
    "QJEJNNJDQJEJIBSFQJEJxegBQJEJfHEPSJBmXEJFSJCDEJqXLXNJFQqXIcQsFNJFIFEJqXUJgFsJXIJBUJEJfHNFvJxEqXNJnXUJFQqD",
    // 10-kana words
    "IJBEJqXZJ"
];
// Maps each character into its kana value (the index)
var mapping = "~~AzB~X~a~KN~Q~D~S~C~G~E~Y~p~L~I~O~eH~g~V~hxyumi~~U~~Z~~v~~s~~dkoblPjfnqwMcRTr~W~~~F~~~~~Jt";
var wordlist = null;
function hex(word) {
    return (0, bytes_1.hexlify)((0, strings_1.toUtf8Bytes)(word));
}
var KiYoKu = "0xe3818de38284e3818f";
var KyoKu = "0xe3818de38283e3818f";
function loadWords(lang) {
    if (wordlist !== null) {
        return;
    }
    wordlist = [];
    // Transforms for normalizing (sort is a not quite UTF-8)
    var transform = {};
    // Delete the diacritic marks
    transform[(0, strings_1.toUtf8String)([227, 130, 154])] = false;
    transform[(0, strings_1.toUtf8String)([227, 130, 153])] = false;
    // Some simple transforms that sort out most of the order
    transform[(0, strings_1.toUtf8String)([227, 130, 133])] = (0, strings_1.toUtf8String)([227, 130, 134]);
    transform[(0, strings_1.toUtf8String)([227, 129, 163])] = (0, strings_1.toUtf8String)([227, 129, 164]);
    transform[(0, strings_1.toUtf8String)([227, 130, 131])] = (0, strings_1.toUtf8String)([227, 130, 132]);
    transform[(0, strings_1.toUtf8String)([227, 130, 135])] = (0, strings_1.toUtf8String)([227, 130, 136]);
    // Normalize words using the transform
    function normalize(word) {
        var result = "";
        for (var i = 0; i < word.length; i++) {
            var kana = word[i];
            var target = transform[kana];
            if (target === false) {
                continue;
            }
            if (target) {
                kana = target;
            }
            result += kana;
        }
        return result;
    }
    // Sort how the Japanese list is sorted
    function sortJapanese(a, b) {
        a = normalize(a);
        b = normalize(b);
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }
    // Load all the words
    for (var length_1 = 3; length_1 <= 9; length_1++) {
        var d = data[length_1 - 3];
        for (var offset = 0; offset < d.length; offset += length_1) {
            var word = [];
            for (var i = 0; i < length_1; i++) {
                var k = mapping.indexOf(d[offset + i]);
                word.push(227);
                word.push((k & 0x40) ? 130 : 129);
                word.push((k & 0x3f) + 128);
            }
            wordlist.push((0, strings_1.toUtf8String)(word));
        }
    }
    wordlist.sort(sortJapanese);
    // For some reason kyoku and kiyoku are flipped in node (!!).
    // The order SHOULD be:
    //   - kyoku
    //   - kiyoku
    // This should ignore "if", but that doesn't work here??
    /* istanbul ignore next */
    if (hex(wordlist[442]) === KiYoKu && hex(wordlist[443]) === KyoKu) {
        var tmp = wordlist[442];
        wordlist[442] = wordlist[443];
        wordlist[443] = tmp;
    }
    // Verify the computed list matches the official list
    /* istanbul ignore if */
    if (wordlist_1.Wordlist.check(lang) !== "0xcb36b09e6baa935787fd762ce65e80b0c6a8dabdfbc3a7f86ac0e2c4fd111600") {
        wordlist = null;
        throw new Error("BIP39 Wordlist for ja (Japanese) FAILED");
    }
}
var LangJa = /** @class */ (function (_super) {
    __extends(LangJa, _super);
    function LangJa() {
        return _super.call(this, "ja") || this;
    }
    LangJa.prototype.getWord = function (index) {
        loadWords(this);
        return wordlist[index];
    };
    LangJa.prototype.getWordIndex = function (word) {
        loadWords(this);
        return wordlist.indexOf(word);
    };
    LangJa.prototype.split = function (mnemonic) {
        wordlist_1.logger.checkNormalize();
        return mnemonic.split(/(?:\u3000| )+/g);
    };
    LangJa.prototype.join = function (words) {
        return words.join("\u3000");
    };
    return LangJa;
}(wordlist_1.Wordlist));
var langJa = new LangJa();
exports.langJa = langJa;
wordlist_1.Wordlist.register(langJa);

      };
    };
  }
  }
}, {package:"ethers>@ethersproject/wordlists",file:"node_modules\\@ethersproject\\wordlists\\lib\\lang-ja.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\wordlists\\lib\\lang-ko.js", {"./wordlist":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\wordlists\\lib\\wordlist.js","@ethersproject/strings":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\strings\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@ethersproject%5Cwordlists%5Clib%5Clang-ko.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.langKo = void 0;
var strings_1 = require("@ethersproject/strings");
var wordlist_1 = require("./wordlist");
var data = [
    "OYAa",
    "ATAZoATBl3ATCTrATCl8ATDloATGg3ATHT8ATJT8ATJl3ATLlvATLn4ATMT8ATMX8ATMboATMgoAToLbAToMTATrHgATvHnAT3AnAT3JbAT3MTAT8DbAT8JTAT8LmAT8MYAT8MbAT#LnAUHT8AUHZvAUJXrAUJX8AULnrAXJnvAXLUoAXLgvAXMn6AXRg3AXrMbAX3JTAX3QbAYLn3AZLgvAZrSUAZvAcAZ8AaAZ8AbAZ8AnAZ8HnAZ8LgAZ8MYAZ8MgAZ8OnAaAboAaDTrAaFTrAaJTrAaJboAaLVoAaMXvAaOl8AaSeoAbAUoAbAg8AbAl4AbGnrAbMT8AbMXrAbMn4AbQb8AbSV8AbvRlAb8AUAb8AnAb8HgAb8JTAb8NTAb8RbAcGboAcLnvAcMT8AcMX8AcSToAcrAaAcrFnAc8AbAc8MgAfGgrAfHboAfJnvAfLV8AfLkoAfMT8AfMnoAfQb8AfScrAfSgrAgAZ8AgFl3AgGX8AgHZvAgHgrAgJXoAgJX8AgJboAgLZoAgLn4AgOX8AgoATAgoAnAgoCUAgoJgAgoLXAgoMYAgoSeAgrDUAgrJTAhrFnAhrLjAhrQgAjAgoAjJnrAkMX8AkOnoAlCTvAlCV8AlClvAlFg4AlFl6AlFn3AloSnAlrAXAlrAfAlrFUAlrFbAlrGgAlrOXAlvKnAlvMTAl3AbAl3MnAnATrAnAcrAnCZ3AnCl8AnDg8AnFboAnFl3AnHX4AnHbrAnHgrAnIl3AnJgvAnLXoAnLX4AnLbrAnLgrAnLhrAnMXoAnMgrAnOn3AnSbrAnSeoAnvLnAn3OnCTGgvCTSlvCTvAUCTvKnCTvNTCT3CZCT3GUCT3MTCT8HnCUCZrCULf8CULnvCU3HnCU3JUCY6NUCbDb8CbFZoCbLnrCboOTCboScCbrFnCbvLnCb8AgCb8HgCb$LnCkLfoClBn3CloDUDTHT8DTLl3DTSU8DTrAaDTrLXDTrLjDTrOYDTrOgDTvFXDTvFnDT3HUDT3LfDUCT9DUDT4DUFVoDUFV8DUFkoDUGgrDUJnrDULl8DUMT8DUMXrDUMX4DUMg8DUOUoDUOgvDUOg8DUSToDUSZ8DbDXoDbDgoDbGT8DbJn3DbLg3DbLn4DbMXrDbMg8DbOToDboJXGTClvGTDT8GTFZrGTLVoGTLlvGTLl3GTMg8GTOTvGTSlrGToCUGTrDgGTrJYGTrScGTtLnGTvAnGTvQgGUCZrGUDTvGUFZoGUHXrGULnvGUMT8GUoMgGXoLnGXrMXGXrMnGXvFnGYLnvGZOnvGZvOnGZ8LaGZ8LmGbAl3GbDYvGbDlrGbHX3GbJl4GbLV8GbLn3GbMn4GboJTGboRfGbvFUGb3GUGb4JnGgDX3GgFl$GgJlrGgLX6GgLZoGgLf8GgOXoGgrAgGgrJXGgrMYGgrScGgvATGgvOYGnAgoGnJgvGnLZoGnLg3GnLnrGnQn8GnSbrGnrMgHTClvHTDToHTFT3HTQT8HToJTHToJgHTrDUHTrMnHTvFYHTvRfHT8MnHT8SUHUAZ8HUBb4HUDTvHUoMYHXFl6HXJX6HXQlrHXrAUHXrMnHXrSbHXvFYHXvKXHX3LjHX3MeHYvQlHZrScHZvDbHbAcrHbFT3HbFl3HbJT8HbLTrHbMT8HbMXrHbMbrHbQb8HbSX3HboDbHboJTHbrFUHbrHgHbrJTHb8JTHb8MnHb8QgHgAlrHgDT3HgGgrHgHgrHgJTrHgJT8HgLX@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",
    "ATLnDlATrAZoATrJX4ATrMT8ATrMX4ATrRTrATvDl8ATvJUoATvMl8AT3AToAT3MX8AT8CT3AT8DT8AT8HZrAT8HgoAUAgFnAUCTFnAXoMX8AXrAT8AXrGgvAXrJXvAXrOgoAXvLl3AZvAgoAZvFbrAZvJXoAZvJl8AZvJn3AZvMX8AZvSbrAZ8FZoAZ8LZ8AZ8MU8AZ8OTvAZ8SV8AZ8SX3AbAgFZAboJnoAbvGboAb8ATrAb8AZoAb8AgrAb8Al4Ab8Db8Ab8JnoAb8LX4Ab8LZrAb8LhrAb8MT8Ab8OUoAb8Qb8Ab8ST8AcrAUoAcrAc8AcrCZ3AcrFT3AcrFZrAcrJl4AcrJn3AcrMX3AcrOTvAc8AZ8Ac8MT8AfAcJXAgoFn4AgoGgvAgoGnrAgoLc8AgoMXoAgrLnrAkrSZ8AlFXCTAloHboAlrHbrAlrLhrAlrLkoAl3CZrAl3LUoAl3LZrAnrAl4AnrMT8An3HT4BT3IToBX4MnvBb!Ln$CTGXMnCToLZ4CTrHT8CT3JTrCT3RZrCT#GTvCU6GgvCU8Db8CU8GZrCU8HT8CboLl3CbrGgrCbrMU8Cb8DT3Cb8GnrCb8LX4Cb8MT8Cb8ObrCgrGgvCgrKX4Cl8FZoDTrAbvDTrDboDTrGT6DTrJgrDTrMX3DTrRZrDTrRg8DTvAVvDTvFZoDT3DT8DT3Ln3DT4HZrDT4MT8DT8AlrDT8MT8DUAkGbDUDbJnDYLnQlDbDUOYDbMTAnDbMXSnDboAT3DboFn4DboLnvDj6JTrGTCgFTGTGgFnGTJTMnGTLnPlGToJT8GTrCT3GTrLVoGTrLnvGTrMX3GTrMboGTvKl3GZClFnGZrDT3GZ8DTrGZ8FZ8GZ8MXvGZ8On8GZ8ST3GbCnQXGbMbFnGboFboGboJg3GboMXoGb3JTvGb3JboGb3Mn6Gb3Qb8GgDXLjGgMnAUGgrDloGgrHX4GgrSToGgvAXrGgvAZvGgvFbrGgvLl3GgvMnvGnDnLXGnrATrGnrMboGnuLl3HTATMnHTAgCnHTCTCTHTrGTvHTrHTvHTrJX8HTrLl8HTrMT8HTrMgoHTrOTrHTuOn3HTvAZrHTvDTvHTvGboHTvJU8HTvLl3HTvMXrHTvQb4HT4GT6HT4JT8HT4Jb#HT8Al3HT8GZrHT8GgrHT8HX4HT8Jb8HT8JnoHT8LTrHT8LgvHT8SToHT8SV8HUoJUoHUoJX8HUoLnrHXrLZoHXvAl3HX3LnrHX4FkvHX4LhrHX4MXoHX4OnoHZrAZ8HZrDb8HZrGZ8HZrJnrHZvGZ8HZvLnvHZ8JnvHZ8LhrHbCXJlHbMTAnHboJl4HbpLl3HbrJX8HbrLnrHbrMnvHbvRYrHgoSTrHgrFV8HgrGZ8HgrJXoHgrRnvHgvBb!HgvGTrHgvHX4HgvHn!HgvLTrHgvSU8HnDnLbHnFbJbHnvDn8Hn6GgvHn!BTvJTCTLnJTQgFnJTrAnvJTrLX4JTrOUoJTvFn3JTvLnrJTvNToJT3AgoJT3Jn4JT3LhvJT3ObrJT8AcrJT8Al3JT8JT8JT8JnoJT8LX4JT8LnrJT8MX3JT8Rg3JT8Sc8JUoBTvJU8AToJU8GZ8JU8GgvJU8JTrJU8JXrJU8JnrJU8LnvJU8ScvJXHnJlJXrGgvJXrJU8JXrLhrJXrMT8JXrMXrJXrQUoJXvCTvJXvGZ8JXvGgrJXvQT8JX8Ab8JX8DT8JX8GZ8JX8HZvJX8LnrJX8MT8JX8MXoJX8MnvJX8ST3JYGnCTJbAkGbJbCTAnJbLTAcJboDT3JboLb6JbrAnvJbrCn3JbrDl8JbrGboJbrIZoJbrJnvJbrMnvJbrQb4Jb8RZrJeAbAnJgJnFbJgScAnJgrATrJgvHZ8JgvMn4JlJlFbJlLiQXJlLjOnJlRbOlJlvNXoJlvRl3Jl4AcrJl8AUoJl8MnrJnFnMlJnHgGbJnoDT8JnoFV8JnoGgvJnoIT8JnoQToJnoRg3JnrCZ3JnrGgrJnrHTvJnrLf8JnrOX8JnvAT3JnvFZoJnvGT8JnvJl4JnvMT8JnvMX8JnvOXrJnvPX6JnvSX3JnvSZrJn3MT8Jn3MX8Jn3RTrLTATKnLTJnLTLTMXKnLTRTQlLToGb8LTrAZ8LTrCZ8LTrDb8LTrHT8LT3PX6LT4FZoLT$CTvLT$GgrLUvHX3LVoATrLVoAgoLVoJboLVoMX3LVoRg3LV8CZ3LV8FZoLV8GTvLXrDXoLXrFbrLXvAgvLXvFlrLXvLl3LXvRn6LX4Mb8LX8GT8LYCXMnLYrMnrLZoSTvLZrAZvLZrAloLZrFToLZrJXvLZrJboLZrJl4LZrLnrLZrMT8LZrOgvLZrRnvLZrST4LZvMX8LZvSlvLZ8AgoLZ8CT3LZ8JT8LZ8LV8LZ8LZoLZ8Lg8LZ8SV8LZ8SbrLZ$HT8LZ$Mn4La6CTvLbFbMnLbRYFTLbSnFZLboJT8LbrAT9LbrGb3LbrQb8LcrJX8LcrMXrLerHTvLerJbrLerNboLgrDb8LgrGZ8LgrHTrLgrMXrLgrSU8LgvJTrLgvLl3Lg6Ll3LhrLnrLhrMT8LhvAl4LiLnQXLkoAgrLkoJT8LkoJn4LlrSU8Ll3FZoLl3HTrLl3JX8Ll3JnoLl3LToLmLeFbLnDUFbLnLVAnLnrATrLnrAZoLnrAb8LnrAlrLnrGgvLnrJU8LnrLZrLnrLhrLnrMb8LnrOXrLnrSZ8LnvAb4LnvDTrLnvDl8LnvHTrLnvHbrLnvJT8LnvJU8LnvJbrLnvLhvLnvMX8LnvMb8LnvNnoLnvSU8Ln3Al3Ln4FZoLn4GT6Ln4JgvLn4LhrLn4MT8Ln4SToMToCZrMToJX8MToLX4MToLf8MToRg3MTrEloMTvGb6MT3BTrMT3Lb6MT8AcrMT8AgrMT8GZrMT8JnoMT8LnrMT8MX3MUOUAnMXAbFnMXoAloMXoJX8MXoLf8MXoLl8MXrAb8MXrDTvMXrGT8MXrGgrMXrHTrMXrLf8MXrMU8MXrOXvMXrQb8MXvGT8MXvHTrMXvLVoMX3AX3MX3Jn3MX3LhrMX3MX3MX4AlrMX4OboMX8GTvMX8GZrMX8GgrMX8JT8MX8JX8MX8LhrMX8MT8MYDUFbMYMgDbMbGnFfMbvLX4MbvLl3Mb8Mb8Mb8ST4MgGXCnMg8ATrMg8AgoMg8CZrMg8DTrMg8DboMg8HTrMg8JgrMg8LT8MloJXoMl8AhrMl8JT8MnLgAUMnoJXrMnoLX4MnoLhrMnoMT8MnrAl4MnrDb8MnrOTvMnrOgvMnrQb8MnrSU8MnvGgrMnvHZ8Mn3MToMn4DTrMn4LTrMn4Mg8NnBXAnOTFTFnOToAToOTrGgvOTrJX8OT3JXoOT6MTrOT8GgrOT8HTpOT8MToOUoHT8OUoJT8OUoLn3OXrAgoOXrDg8OXrMT8OXvSToOX6CTvOX8CZrOX8OgrOb6HgvOb8AToOb8MT8OcvLZ8OgvAlrOgvHTvOgvJTrOgvJnrOgvLZrOgvLn4OgvMT8OgvRTrOg8AZoOg8DbvOnrOXoOnvJn4OnvLhvOnvRTrOn3GgoOn3JnvOn6JbvOn8OTrPTGYFTPbBnFnPbGnDnPgDYQTPlrAnvPlrETvPlrLnvPlrMXvPlvFX4QTMTAnQTrJU8QYCnJlQYJlQlQbGTQbQb8JnrQb8LZoQb8LnvQb8MT8Qb8Ml8Qb8ST4QloAl4QloHZvQloJX8QloMn8QnJZOlRTrAZvRTrDTrRTvJn4RTvLhvRT4Jb8RZrAZrRZ8AkrRZ8JU8RZ8LV8RZ8LnvRbJlQXRg3GboRg3MnvRg8AZ8Rg8JboRg8Jl4RnLTCbRnvFl3RnvQb8SToAl4SToCZrSToFZoSToHXrSToJU8SToJgvSToJl4SToLhrSToMX3STrAlvSTrCT9STrCgrSTrGgrSTrHXrSTrHboSTrJnoSTrNboSTvLnrST4AZoST8Ab8ST8JT8SUoJn3SU6HZ#SU6JTvSU8Db8SU8HboSU8LgrSV8JT8SZrAcrSZrAl3SZrJT8SZrJnvSZrMT8SZvLUoSZ4FZoSZ8JnoSZ8RZrScoLnrScoMT8ScoMX8ScrAT4ScrAZ8ScrLZ8ScrLkvScvDb8ScvLf8ScvNToSgrFZrShvKnrSloHUoSloLnrSlrMXoSl8HgrSmrJUoSn3BX6",
    "ATFlOn3ATLgrDYAT4MTAnAT8LTMnAYJnRTrAbGgJnrAbLV8LnAbvNTAnAeFbLg3AgOYMXoAlQbFboAnDboAfAnJgoJTBToDgAnBUJbAl3BboDUAnCTDlvLnCTFTrSnCYoQTLnDTwAbAnDUDTrSnDUHgHgrDX8LXFnDbJXAcrETvLTLnGTFTQbrGTMnGToGT3DUFbGUJlPX3GbQg8LnGboJbFnGb3GgAYGgAg8ScGgMbAXrGgvAbAnGnJTLnvGnvATFgHTDT6ATHTrDlJnHYLnMn8HZrSbJTHZ8LTFnHbFTJUoHgSeMT8HgrLjAnHgvAbAnHlFUrDlHnDgvAnHnHTFT3HnQTGnrJTAaMXvJTGbCn3JTOgrAnJXvAXMnJbMg8SnJbMnRg3Jb8LTMnJnAl3OnJnGYrQlJnJlQY3LTDlCn3LTJjLg3LTLgvFXLTMg3GTLV8HUOgLXFZLg3LXNXrMnLX8QXFnLX9AlMYLYLXPXrLZAbJU8LZDUJU8LZMXrSnLZ$AgFnLaPXrDULbFYrMnLbMn8LXLboJgJgLeFbLg3LgLZrSnLgOYAgoLhrRnJlLkCTrSnLkOnLhrLnFX%AYLnFZoJXLnHTvJbLnLloAbMTATLf8MTHgJn3MTMXrAXMT3MTFnMUITvFnMXFX%AYMXMXvFbMXrFTDbMYAcMX3MbLf8SnMb8JbFnMgMXrMTMgvAXFnMgvGgCmMnAloSnMnFnJTrOXvMXSnOX8HTMnObJT8ScObLZFl3ObMXCZoPTLgrQXPUFnoQXPU3RXJlPX3RkQXPbrJXQlPlrJbFnQUAhrDbQXGnCXvQYLnHlvQbLfLnvRTOgvJbRXJYrQlRYLnrQlRbLnrQlRlFT8JlRlFnrQXSTClCn3STHTrAnSTLZQlrSTMnGTrSToHgGbSTrGTDnSTvGXCnST3HgFbSU3HXAXSbAnJn3SbFT8LnScLfLnv",
    "AT3JgJX8AT8FZoSnAT8JgFV8AT8LhrDbAZ8JT8DbAb8GgLhrAb8SkLnvAe8MT8SnAlMYJXLVAl3GYDTvAl3LfLnvBUDTvLl3CTOn3HTrCT3DUGgrCU8MT8AbCbFTrJUoCgrDb8MTDTLV8JX8DTLnLXQlDT8LZrSnDUQb8FZ8DUST4JnvDb8ScOUoDj6GbJl4GTLfCYMlGToAXvFnGboAXvLnGgAcrJn3GgvFnSToGnLf8JnvGn#HTDToHTLnFXJlHTvATFToHTvHTDToHTvMTAgoHT3STClvHT4AlFl6HT8HTDToHUoDgJTrHUoScMX3HbRZrMXoHboJg8LTHgDb8JTrHgMToLf8HgvLnLnoHnHn3HT4Hn6MgvAnJTJU8ScvJT3AaQT8JT8HTrAnJXrRg8AnJbAloMXoJbrATFToJbvMnoSnJgDb6GgvJgDb8MXoJgSX3JU8JguATFToJlPYLnQlJlQkDnLbJlQlFYJlJl8Lf8OTJnCTFnLbJnLTHXMnJnLXGXCnJnoFfRg3JnrMYRg3Jn3HgFl3KT8Dg8LnLTRlFnPTLTvPbLbvLVoSbrCZLXMY6HT3LXNU7DlrLXNXDTATLX8DX8LnLZDb8JU8LZMnoLhrLZSToJU8LZrLaLnrLZvJn3SnLZ8LhrSnLaJnoMT8LbFlrHTvLbrFTLnrLbvATLlvLb6OTFn3LcLnJZOlLeAT6Mn4LeJT3ObrLg6LXFlrLhrJg8LnLhvDlPX4LhvLfLnvLj6JTFT3LnFbrMXoLnQluCTvLnrQXCY6LnvLfLnvLnvMgLnvLnvSeLf8MTMbrJn3MT3JgST3MT8AnATrMT8LULnrMUMToCZrMUScvLf8MXoDT8SnMX6ATFToMX8AXMT8MX8FkMT8MX8HTrDUMX8ScoSnMYJT6CTvMgAcrMXoMg8SToAfMlvAXLg3MnFl3AnvOT3AnFl3OUoATHT8OU3RnLXrOXrOXrSnObPbvFn6Og8HgrSnOg8OX8DbPTvAgoJgPU3RYLnrPXrDnJZrPb8CTGgvPlrLTDlvPlvFUJnoQUvFXrQlQeMnoAl3QlrQlrSnRTFTrJUoSTDlLiLXSTFg6HT3STJgoMn4STrFTJTrSTrLZFl3ST4FnMXoSUrDlHUoScvHTvSnSfLkvMXo",
    "AUoAcrMXoAZ8HboAg8AbOg6ATFgAg8AloMXoAl3AT8JTrAl8MX8MXoCT3SToJU8Cl8Db8MXoDT8HgrATrDboOT8MXoGTOTrATMnGT8LhrAZ8GnvFnGnQXHToGgvAcrHTvAXvLl3HbrAZoMXoHgBlFXLg3HgMnFXrSnHgrSb8JUoHn6HT8LgvITvATrJUoJUoLZrRnvJU8HT8Jb8JXvFX8QT8JXvLToJTrJYrQnGnQXJgrJnoATrJnoJU8ScvJnvMnvMXoLTCTLgrJXLTJlRTvQlLbRnJlQYvLbrMb8LnvLbvFn3RnoLdCVSTGZrLeSTvGXCnLg3MnoLn3MToLlrETvMT8SToAl3MbrDU6GTvMb8LX4LhrPlrLXGXCnSToLf8Rg3STrDb8LTrSTvLTHXMnSb3RYLnMnSgOg6ATFg",
    "HUDlGnrQXrJTrHgLnrAcJYMb8DULc8LTvFgGnCk3Mg8JbAnLX4QYvFYHnMXrRUoJnGnvFnRlvFTJlQnoSTrBXHXrLYSUJgLfoMT8Se8DTrHbDb",
    "AbDl8SToJU8An3RbAb8ST8DUSTrGnrAgoLbFU6Db8LTrMg8AaHT8Jb8ObDl8SToJU8Pb3RlvFYoJl"
];
var codes = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*";
function getHangul(code) {
    if (code >= 40) {
        code = code + 168 - 40;
    }
    else if (code >= 19) {
        code = code + 97 - 19;
    }
    return (0, strings_1.toUtf8String)([225, (code >> 6) + 132, (code & 0x3f) + 128]);
}
var wordlist = null;
function loadWords(lang) {
    if (wordlist != null) {
        return;
    }
    wordlist = [];
    data.forEach(function (data, length) {
        length += 4;
        for (var i = 0; i < data.length; i += length) {
            var word = "";
            for (var j = 0; j < length; j++) {
                word += getHangul(codes.indexOf(data[i + j]));
            }
            wordlist.push(word);
        }
    });
    wordlist.sort();
    // Verify the computed list matches the official list
    /* istanbul ignore if */
    if (wordlist_1.Wordlist.check(lang) !== "0xf9eddeace9c5d3da9c93cf7d3cd38f6a13ed3affb933259ae865714e8a3ae71a") {
        wordlist = null;
        throw new Error("BIP39 Wordlist for ko (Korean) FAILED");
    }
}
var LangKo = /** @class */ (function (_super) {
    __extends(LangKo, _super);
    function LangKo() {
        return _super.call(this, "ko") || this;
    }
    LangKo.prototype.getWord = function (index) {
        loadWords(this);
        return wordlist[index];
    };
    LangKo.prototype.getWordIndex = function (word) {
        loadWords(this);
        return wordlist.indexOf(word);
    };
    return LangKo;
}(wordlist_1.Wordlist));
var langKo = new LangKo();
exports.langKo = langKo;
wordlist_1.Wordlist.register(langKo);

      };
    };
  }
  }
}, {package:"ethers>@ethersproject/wordlists",file:"node_modules\\@ethersproject\\wordlists\\lib\\lang-ko.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\wordlists\\lib\\lang-zh.js", {"./wordlist":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\wordlists\\lib\\wordlist.js","@ethersproject/strings":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\strings\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@ethersproject%5Cwordlists%5Clib%5Clang-zh.js
      return function (require, module, exports) {
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.langZhTw = exports.langZhCn = void 0;
var strings_1 = require("@ethersproject/strings");
var wordlist_1 = require("./wordlist");
var data = "}aE#4A=Yv&co#4N#6G=cJ&SM#66|/Z#4t&kn~46#4K~4q%b9=IR#7l,mB#7W_X2*dl}Uo~7s}Uf&Iw#9c&cw~6O&H6&wx&IG%v5=IQ~8a&Pv#47$PR&50%Ko&QM&3l#5f,D9#4L|/H&tQ;v0~6n]nN<di,AM=W5%QO&ka&ua,hM^tm=zV=JA=wR&+X]7P&NB#4J#5L|/b[dA}tJ<Do&6m&u2[U1&Kb.HM&mC=w0&MW<rY,Hq#6M}QG,13&wP}Jp]Ow%ue&Kg<HP<D9~4k~9T&I2_c6$9T#9/[C5~7O~4a=cs&O7=KK=An&l9$6U$8A&uD&QI|/Y&bg}Ux&F2#6b}E2&JN&kW&kp=U/&bb=Xl<Cj}k+~5J#6L&5z&9i}b4&Fo,ho(X0_g3~4O$Fz&QE<HN=Ww]6/%GF-Vw=tj&/D&PN#9g=YO}cL&Of&PI~5I&Ip=vU=IW#9G;0o-wU}ss&QR<BT&R9=tk$PY_dh&Pq-yh]7T,nj.Xu=EP&76=cI&Fs*Xg}z7$Gb&+I=DF,AF=cA}rL#7j=Dz&3y<Aa$52=PQ}b0(iY$Fa}oL&xV#6U=ec=WZ,xh%RY<dp#9N&Fl&44=WH*A7=sh&TB&8P=07;u+&PK}uh}J5#72)V/=xC,AB$k0&f6;1E|+5=1B,3v]6n&wR%b+&xx]7f=Ol}fl;+D^wG]7E;nB;uh^Ir&l5=JL,nS=cf=g5;u6|/Q$Gc=MH%Hg#5d%M6^86=U+$Gz,l/,ir^5y&Ba&/F-IY&FI&be%IZ#77&PW_Nu$kE(Yf&NX]7Z,Jy&FJ(Xo&Nz#/d=y7&MX<Ag}Z+;nE]Dt(iG#4D=13&Pj~4c%v8&Zo%OL&/X#4W<HR&ie~6J_1O(Y2=y5=Ad*cv_eB#6k&PX:BU#7A;uk&Ft&Fx_dD=U2;vB=U5=4F}+O&GN.HH:9s=b0%NV(jO&IH=JT}Z9=VZ<Af,Kx^4m&uJ%c6,6r;9m#+L}cf%Kh&F3~4H=vP}bu,Hz|++,1w]nv}k6;uu$jw*Kl*WX&uM[x7&Fr[m7$NO&QN]hu=JN}nR^8g#/h(ps|KC;vd}xz=V0}p6&FD$G1#7K<bG_4p~8g&cf;u4=tl}+k%5/}fz;uw<cA=u1}gU}VM=LJ=eX&+L&Pr#4U}p2:nC,2K]7H:jF&9x}uX#9O=MB<fz~8X~5m&4D&kN&u5%E/(h7(ZF&VG<de(qM|/e-Wt=3x(a+,/R]f/&ND$Ro&nU}0g=KA%kH&NK$Ke<dS}cB&IX~5g$TN]6m=Uv,Is&Py=Ef%Kz#+/%bi&+A<F4$OG&4C&FL#9V<Zk=2I_eE&6c]nw&kq$HG}y+&A8$P3}OH=XP]70%IS(AJ_gH%GZ&tY&AZ=vb~6y&/r=VI=Wv<Zi=fl=xf&eL}c8}OL=MJ=g8$F7=YT}9u=0+^xC}JH&nL^N0~4T]K2,Cy%OC#6s;vG(AC^xe^cG&MF}Br#9P;wD-7h$O/&xA}Fn^PC]6i]7G&8V$Qs;vl(TB~73~4l<mW&6V=2y&uY&+3)aP}XF;LP&kx$wU=t7;uy<FN&lz)7E=Oo*Y+;wI}9q}le;J6&Ri&4t&Qr#8B=cb&vG=J5|Ql(h5<Yy~4+}QD,Lx=wn%K/&RK=dO&Pw,Q9=co%4u;9u}g0@6a^4I%b0=zo|/c&tX=dQ=OS#+b=yz_AB&wB&Pm=W9$HP_gR=62=AO=ti=hI,oA&jr&dH=tm&b6$P2(x8=zi;nG~7F;05]0n[Ix&3m}rg=Xp=cd&uz]7t;97=cN;vV<jf&FF&F1=6Q&Ik*Kk&P4,2z=fQ]7D&3u,H0=d/}Uw<ZN<7R}Kv;0f$H7,MD]7n$F0#88~9Z%da=by;+T#/u=VF&fO&kr^kf<AB]sU,I5$Ng&Pz;0i&QD&vM=Yl:BM;nJ_xJ]U7&Kf&30,3f|Z9*dC)je_jA&Q4&Kp$NH(Yz#6S&Id%Ib=KX,AD=KV%dP}tW&Pk^+E_Ni=cq,3R}VZ(Si=b+}rv;0j}rZ]uA,/w(Sx&Jv$w9&4d&wE,NJ$Gy=J/]Ls#7k<ZQ<Y/&uj]Ov$PM;v3,2F&+u:up=On&3e,Jv;90=J+&Qm]6q}bK#+d~8Y(h2]hA;99&AS=I/}qB&dQ}yJ-VM}Vl&ui,iB&G3|Dc]7d=eQ%dX%JC_1L~4d^NP;vJ&/1)ZI#7N]9X[bQ&PL=0L(UZ,Lm&kc&IR}n7(iR<AQ<dg=33=vN}ft}au]7I,Ba=x9=dR~6R&Tq=Xi,3d$Nr&Bc}DI&ku&vf]Dn,/F&iD,Ll&Nw=0y&I7=Ls=/A&tU=Qe}Ua&uk&+F=g4=gh=Vj#+1&Qn}Uy*44#5F,Pc&Rz*Xn=oh=5W;0n_Nf(iE<Y7=vr=Zu]oz#5Z%mI=kN=Bv_Jp(T2;vt_Ml<FS&uI=L/&6P]64$M7}86<bo%QX(SI%IY&VK=Al&Ux;vv;ut*E/%uh<ZE|O3,M2(yc]yu=Wk&tp:Ex}hr,Cl&WE)+Z=8U}I2_4Q,hA_si=iw=OM=tM=yZ%Ia=U7;wT}b+;uo=Za}yS!5x}HD}fb#5O_dA;Nv%uB(yB;01(Sf}Fk;v7}Pt#8v<mZ#7L,/r&Pl~4w&f5=Ph$Fw_LF&8m,bL=yJ&BH}p/*Jn}tU~5Q;wB(h6]Df]8p^+B;E4&Wc=d+;Ea&bw$8C&FN,DM=Yf}mP~5w=fT#6V=mC=Fi=AV}jB&AN}lW}aH#/D)dZ;hl;vE}/7,CJ;31&w8,hj%u9_Js=jJ&4M~8k=TN&eC}nL&uc-wi&lX}dj=Mv=e2#6u=cr$uq$6G]8W}Jb:nm=Yg<b3(UA;vX&6n&xF=KT,jC,De&R8&oY=Zv&oB]7/=Z2&Oa}bf,hh(4h^tZ&72&Nx;D2&xL~5h~40)ZG)h+=OJ&RA]Bv$yB=Oq=df,AQ%Jn}OJ;11,3z&Tl&tj;v+^Hv,Dh(id=s+]7N&N3)9Q~8f,S4=uW=w4&uX,LX&3d]CJ&yp&8x<b2_do&lP=y/<cy_dG=Oi=7R(VH(lt_1T,Iq_AA;12^6T%k6#8K[B1{oO<AU[Bt;1b$9S&Ps<8T=St{bY,jB(Zp&63&Uv$9V,PM]6v&Af}zW[bW_oq}sm}nB&Kq&gC&ff_eq_2m&5F&TI}rf}Gf;Zr_z9;ER&jk}iz_sn<BN~+n&vo=Vi%97|ZR=Wc,WE&6t]6z%85(ly#84=KY)6m_5/=aX,N3}Tm&he&6K]tR_B2-I3;u/&hU&lH<AP=iB&IA=XL;/5&Nh=wv<BH#79=vS=zl<AA=0X_RG}Bw&9p$NW,AX&kP_Lp&/Z(Tc]Mu}hs#6I}5B&cI<bq&H9#6m=K9}vH(Y1(Y0#4B&w6,/9&gG<bE,/O=zb}I4_l8<B/;wL%Qo<HO[Mq=XX}0v&BP&F4(mG}0i}nm,EC=9u{I3,xG&/9=JY*DK&hR)BX=EI=cx=b/{6k}yX%A+&wa}Xb=la;wi^lL;0t}jo&Qb=xg=XB}iO<qo{bR=NV&8f=a0&Jy;0v=uK)HK;vN#6h&jB(h/%ud&NI%wY.X7=Pt}Cu-uL&Gs_hl%mH,tm]78=Lb^Q0#7Y=1u<Bt&+Q=Co_RH,w3;1e}ux<aU;ui}U3&Q5%bt]63&UQ|0l&uL}O7&3o,AV&dm|Nj(Xt*5+(Uu&Hh(p7(UF=VR=Bp^Jl&Hd[ix)9/=Iq]C8<67]66}mB%6f}bb}JI]8T$HA}db=YM&pa=2J}tS&Y0=PS&y4=cX$6E,hX,XP&nR;04,FQ&l0&Vm_Dv#5Y~8Z=Bi%MA]6x=JO:+p,Az&9q,Hj~6/}SD=K1:EJ}nA;Qo#/E]9R,Ie&6X%W3]61&v4=xX_MC=0q;06(Xq=fs}IG}Dv=0l}o7$iZ;9v&LH&DP-7a&OY,SZ,Kz,Cv&dh=fx|Nh,F/~7q=XF&w+;9n&Gw;0h}Z7<7O&JK(S7&LS<AD<ac=wo<Dt&zw%4B=4v#8P;9o~6p*vV=Tm,Or&I6=1q}nY=P0=gq&Bl&Uu,Ch%yb}UY=zh}dh}rl(T4_xk(YA#8R*xH,IN}Jn]7V}C4&Ty}j3]7p=cL=3h&wW%Qv<Z3=f0&RI&+S(ic_zq}oN&/Y=z1;Td=LW=0e=OI(Vc,+b^ju(UL;0r:Za%8v=Rp=zw&58&73&wK}qX]6y&8E)a2}WR=wP^ur&nQ<cH}Re=Aq&wk}Q0&+q=PP,Gc|/d^k5,Fw]8Y}Pg]p3=ju=ed}r5_yf&Cs]7z$/G<Cm&Jp&54_1G_gP_Ll}JZ;0u]k8_7k(Sg]65{9i=LN&Sx&WK,iW&fD&Lk{9a}Em-9c#8N&io=sy]8d&nT&IK(lx#7/$lW(Td<s8~49,3o<7Y=MW(T+_Jr&Wd,iL}Ct=xh&5V;v4&8n%Kx=iF&l2_0B{B+,If(J0,Lv;u8=Kx-vB=HC&vS=Z6&fU&vE^xK;3D=4h=MR#45:Jw;0d}iw=LU}I5=I0]gB*im,K9}GU,1k_4U&Tt=Vs(iX&lU(TF#7y,ZO}oA&m5#5P}PN}Uz=hM<B1&FB<aG,e6~7T<tP(UQ_ZT=wu&F8)aQ]iN,1r_Lo&/g:CD}84{J1_Ki&Na&3n$jz&FE=dc;uv;va}in}ll=fv(h1&3h}fp=Cy}BM(+E~8m}lo%v7=hC(T6$cj=BQ=Bw(DR,2j=Ks,NS|F+;00=fU=70}Mb(YU;+G&m7&hr=Sk%Co]t+(X5_Jw}0r}gC(AS-IP&QK<Z2#8Q$WC]WX}T2&pG_Ka,HC=R4&/N;Z+;ch(C7,D4$3p_Mk&B2$8D=n9%Ky#5z(CT&QJ#7B]DC]gW}nf~5M;Iw#80}Tc_1F#4Z-aC}Hl=ph=fz,/3=aW}JM}nn;DG;vm}wn,4P}T3;wx&RG$u+}zK=0b;+J_Ek{re<aZ=AS}yY#5D]7q,Cp}xN=VP*2C}GZ}aG~+m_Cs=OY#6r]6g<GS}LC(UB=3A=Bo}Jy<c4}Is;1P<AG}Op<Z1}ld}nS=1Z,yM&95&98=CJ(4t:2L$Hk=Zo}Vc;+I}np&N1}9y=iv}CO*7p=jL)px]tb^zh&GS&Vl%v/;vR=14=zJ&49|/f]hF}WG;03=8P}o/&Gg&rp;DB,Kv}Ji&Pb;aA^ll(4j%yt}+K$Ht#4y&hY]7Y<F1,eN}bG(Uh%6Z]t5%G7;+F_RE;it}tL=LS&Da=Xx(S+(4f=8G=yI}cJ}WP=37=jS}pX}hd)fp<A8=Jt~+o$HJ=M6}iX=g9}CS=dv=Cj(mP%Kd,xq|+9&LD(4/=Xm&QP=Lc}LX&fL;+K=Op(lu=Qs.qC:+e&L+=Jj#8w;SL]7S(b+#4I=c1&nG_Lf&uH;+R)ZV<bV%B/,TE&0H&Jq&Ah%OF&Ss(p2,Wv&I3=Wl}Vq;1L&lJ#9b_1H=8r=b8=JH(SZ=hD=J2#7U,/U#/X~6P,FU<eL=jx,mG=hG=CE&PU=Se(qX&LY=X6=y4&tk&QQ&tf=4g&xI}W+&mZ=Dc#7w}Lg;DA;wQ_Kb(cJ=hR%yX&Yb,hw{bX_4X;EP;1W_2M}Uc=b5(YF,CM&Tp^OJ{DD]6s=vF=Yo~8q}XH}Fu%P5(SJ=Qt;MO]s8<F3&B3&8T(Ul-BS*dw&dR<87}/8]62$PZ]Lx<Au}9Q]7c=ja=KR,Go,Us&v6(qk}pG&G2=ev^GM%w4&H4]7F&dv]J6}Ew:9w=sj-ZL}Ym$+h(Ut(Um~4n=Xs(U7%eE=Qc_JR<CA#6t<Fv|/I,IS,EG<F2(Xy$/n<Fa(h9}+9_2o&N4#7X<Zq|+f_Dp=dt&na,Ca=NJ)jY=8C=YG=s6&Q+<DO}D3=xB&R1(lw;Qn<bF(Cu|/B}HV=SS&n7,10&u0]Dm%A6^4Q=WR(TD=Xo<GH,Rj(l8)bP&n/=LM&CF,F5&ml=PJ;0k=LG=tq,Rh,D6@4i=1p&+9=YC%er_Mh;nI;0q=Fw]80=xq=FM$Gv;v6&nc;wK%H2&Kj;vs,AA=YP,66}bI(qR~5U=6q~4b$Ni=K5.X3$So&Iu(p+]8G=Cf=RY(TS_O3(iH&57=fE=Dg_Do#9z#7H;FK{qd_2k%JR}en&gh_z8;Rx}9p<cN_Ne,DO;LN_7o~/p=NF=5Y}gN<ce<C1,QE]Wv=3u<BC}GK]yq}DY&u/_hj=II(pz&rC,jV&+Z}ut=NQ;Cg-SR_ZS,+o=u/;Oy_RK_QF(Fx&xP}Wr&TA,Uh&g1=yr{ax[VF$Pg(YB;Ox=Vy;+W(Sp}XV%dd&33(l/]l4#4Y}OE=6c=bw(A7&9t%wd&N/&mo,JH&Qe)fm=Ao}fu=tH";
var deltaData = "FAZDC6BALcLZCA+GBARCW8wNCcDDZ8LVFBOqqDUiou+M42TFAyERXFb7EjhP+vmBFpFrUpfDV2F7eB+eCltCHJFWLFCED+pWTojEIHFXc3aFn4F68zqjEuKidS1QBVPDEhE7NA4mhMF7oThD49ot3FgtzHFCK0acW1x8DH1EmLoIlrWFBLE+y5+NA3Cx65wJHTaEZVaK1mWAmPGxgYCdxwOjTDIt/faOEhTl1vqNsKtJCOhJWuio2g07KLZEQsFBUpNtwEByBgxFslFheFbiEPvi61msDvApxCzB6rBCzox7joYA5UdDc+Cb4FSgIabpXFAj3bjkmFAxCZE+mD/SFf/0ELecYCt3nLoxC6WEZf2tKDB4oZvrEmqFkKk7BwILA7gtYBpsTq//D4jD0F0wEB9pyQ1BD5Ba0oYHDI+sbDFhvrHXdDHfgFEIJLi5r8qercNFBgFLC4bo5ERJtamWBDFy73KCEb6M8VpmEt330ygCTK58EIIFkYgF84gtGA9Uyh3m68iVrFbWFbcbqiCYHZ9J1jeRPbL8yswhMiDbhEhdNoSwFbZrLT740ABEqgCkO8J1BLd1VhKKR4sD1yUo0z+FF59Mvg71CFbyEhbHSFBKEIKyoQNgQppq9T0KAqePu0ZFGrXOHdKJqkoTFhYvpDNyuuznrN84thJbsCoO6Cu6Xlvntvy0QYuAExQEYtTUBf3CoCqwgGFZ4u1HJFzDVwEy3cjcpV4QvsPaBC3rCGyCF23o4K3pp2gberGgFEJEHo4nHICtyKH2ZqyxhN05KBBJIQlKh/Oujv/DH32VrlqFdIFC7Fz9Ct4kaqFME0UETLprnN9kfy+kFmtQBB0+5CFu0N9Ij8l/VvJDh2oq3hT6EzjTHKFN7ZjZwoTsAZ4Exsko6Fpa6WC+sduz8jyrLpegTv2h1EBeYpLpm2czQW0KoCcS0bCVXCmuWJDBjN1nQNLdF58SFJ0h7i3pC3oEOKy/FjBklL70XvBEEIWp2yZ04xObzAWDDJG7f+DbqBEA7LyiR95j7MDVdDViz2RE5vWlBMv5e4+VfhP3aXNPhvLSynb9O2x4uFBV+3jqu6d5pCG28/sETByvmu/+IJ0L3wb4rj9DNOLBF6XPIODr4L19U9RRofAG6Nxydi8Bki8BhGJbBAJKzbJxkZSlF9Q2Cu8oKqggB9hBArwLLqEBWEtFowy8XK8bEyw9snT+BeyFk1ZCSrdmgfEwFePTgCjELBEnIbjaDDPJm36rG9pztcEzT8dGk23SBhXBB1H4z+OWze0ooFzz8pDBYFvp9j9tvFByf9y4EFdVnz026CGR5qMr7fxMHN8UUdlyJAzlTBDRC28k+L4FB8078ljyD91tUj1ocnTs8vdEf7znbzm+GIjEZnoZE5rnLL700Xc7yHfz05nWxy03vBB9YGHYOWxgMQGBCR24CVYNE1hpfKxN0zKnfJDmmMgMmBWqNbjfSyFCBWSCGCgR8yFXiHyEj+VtD1FB3FpC1zI0kFbzifiKTLm9yq5zFmur+q8FHqjoOBWsBPiDbnCC2ErunV6cJ6TygXFYHYp7MKN9RUlSIS8/xBAGYLzeqUnBF4QbsTuUkUqGs6CaiDWKWjQK9EJkjpkTmNCPYXL";
// @TODO: Load lazily
var wordlist = {
    zh_cn: null,
    zh_tw: null
};
var Checks = {
    zh_cn: "0x17bcc4d8547e5a7135e365d1ab443aaae95e76d8230c2782c67305d4f21497a1",
    zh_tw: "0x51e720e90c7b87bec1d70eb6e74a21a449bd3ec9c020b01d3a40ed991b60ce5d"
};
var codes = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
var style = "~!@#$%^&*_-=[]{}|;:,.()<>?";
function loadWords(lang) {
    if (wordlist[lang.locale] !== null) {
        return;
    }
    wordlist[lang.locale] = [];
    var deltaOffset = 0;
    for (var i = 0; i < 2048; i++) {
        var s = style.indexOf(data[i * 3]);
        var bytes = [
            228 + (s >> 2),
            128 + codes.indexOf(data[i * 3 + 1]),
            128 + codes.indexOf(data[i * 3 + 2]),
        ];
        if (lang.locale === "zh_tw") {
            var common = s % 4;
            for (var i_1 = common; i_1 < 3; i_1++) {
                bytes[i_1] = codes.indexOf(deltaData[deltaOffset++]) + ((i_1 == 0) ? 228 : 128);
            }
        }
        wordlist[lang.locale].push((0, strings_1.toUtf8String)(bytes));
    }
    // Verify the computed list matches the official list
    /* istanbul ignore if */
    if (wordlist_1.Wordlist.check(lang) !== Checks[lang.locale]) {
        wordlist[lang.locale] = null;
        throw new Error("BIP39 Wordlist for " + lang.locale + " (Chinese) FAILED");
    }
}
var LangZh = /** @class */ (function (_super) {
    __extends(LangZh, _super);
    function LangZh(country) {
        return _super.call(this, "zh_" + country) || this;
    }
    LangZh.prototype.getWord = function (index) {
        loadWords(this);
        return wordlist[this.locale][index];
    };
    LangZh.prototype.getWordIndex = function (word) {
        loadWords(this);
        return wordlist[this.locale].indexOf(word);
    };
    LangZh.prototype.split = function (mnemonic) {
        mnemonic = mnemonic.replace(/(?:\u3000| )+/g, "");
        return mnemonic.split("");
    };
    return LangZh;
}(wordlist_1.Wordlist));
var langZhCn = new LangZh("cn");
exports.langZhCn = langZhCn;
wordlist_1.Wordlist.register(langZhCn);
wordlist_1.Wordlist.register(langZhCn, "zh");
var langZhTw = new LangZh("tw");
exports.langZhTw = langZhTw;
wordlist_1.Wordlist.register(langZhTw);

      };
    };
  }
  }
}, {package:"ethers>@ethersproject/wordlists",file:"node_modules\\@ethersproject\\wordlists\\lib\\lang-zh.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\wordlists\\lib\\wordlist.js", {"./_version":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\wordlists\\lib\\_version.js","@ethersproject/hash":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\hash\\lib\\index.js","@ethersproject/logger":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\logger\\lib\\index.js","@ethersproject/properties":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\properties\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@ethersproject%5Cwordlists%5Clib%5Cwordlist.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Wordlist = exports.logger = void 0;
// This gets overridden by rollup
var exportWordlist = false;
var hash_1 = require("@ethersproject/hash");
var properties_1 = require("@ethersproject/properties");
var logger_1 = require("@ethersproject/logger");
var _version_1 = require("./_version");
exports.logger = new logger_1.Logger(_version_1.version);
var Wordlist = /** @class */ (function () {
    function Wordlist(locale) {
        var _newTarget = this.constructor;
        exports.logger.checkAbstract(_newTarget, Wordlist);
        (0, properties_1.defineReadOnly)(this, "locale", locale);
    }
    // Subclasses may override this
    Wordlist.prototype.split = function (mnemonic) {
        return mnemonic.toLowerCase().split(/ +/g);
    };
    // Subclasses may override this
    Wordlist.prototype.join = function (words) {
        return words.join(" ");
    };
    Wordlist.check = function (wordlist) {
        var words = [];
        for (var i = 0; i < 2048; i++) {
            var word = wordlist.getWord(i);
            /* istanbul ignore if */
            if (i !== wordlist.getWordIndex(word)) {
                return "0x";
            }
            words.push(word);
        }
        return (0, hash_1.id)(words.join("\n") + "\n");
    };
    Wordlist.register = function (lang, name) {
        if (!name) {
            name = lang.locale;
        }
        /* istanbul ignore if */
        if (exportWordlist) {
            try {
                var anyGlobal = window;
                if (anyGlobal._ethers && anyGlobal._ethers.wordlists) {
                    if (!anyGlobal._ethers.wordlists[name]) {
                        (0, properties_1.defineReadOnly)(anyGlobal._ethers.wordlists, name, lang);
                    }
                }
            }
            catch (error) { }
        }
    };
    return Wordlist;
}());
exports.Wordlist = Wordlist;

      };
    };
  }
  }
}, {package:"ethers>@ethersproject/wordlists",file:"node_modules\\@ethersproject\\wordlists\\lib\\wordlist.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\wordlists\\lib\\wordlists.js", {"./lang-cz":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\wordlists\\lib\\lang-cz.js","./lang-en":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\wordlists\\lib\\lang-en.js","./lang-es":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\wordlists\\lib\\lang-es.js","./lang-fr":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\wordlists\\lib\\lang-fr.js","./lang-it":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\wordlists\\lib\\lang-it.js","./lang-ja":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\wordlists\\lib\\lang-ja.js","./lang-ko":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\wordlists\\lib\\lang-ko.js","./lang-zh":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\wordlists\\lib\\lang-zh.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@ethersproject%5Cwordlists%5Clib%5Cwordlists.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.wordlists = void 0;
var lang_cz_1 = require("./lang-cz");
var lang_en_1 = require("./lang-en");
var lang_es_1 = require("./lang-es");
var lang_fr_1 = require("./lang-fr");
var lang_ja_1 = require("./lang-ja");
var lang_ko_1 = require("./lang-ko");
var lang_it_1 = require("./lang-it");
var lang_zh_1 = require("./lang-zh");
exports.wordlists = {
    cz: lang_cz_1.langCz,
    en: lang_en_1.langEn,
    es: lang_es_1.langEs,
    fr: lang_fr_1.langFr,
    it: lang_it_1.langIt,
    ja: lang_ja_1.langJa,
    ko: lang_ko_1.langKo,
    zh: lang_zh_1.langZhCn,
    zh_cn: lang_zh_1.langZhCn,
    zh_tw: lang_zh_1.langZhTw
};

      };
    };
  }
  }
}, {package:"ethers>@ethersproject/wordlists",file:"node_modules\\@ethersproject\\wordlists\\lib\\wordlists.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\alias-sampling\\dist\\cjs\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Calias-sampling%5Cdist%5Ccjs%5Cindex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var precomputeAlias = function (p, n) {
    var sum = p.reduce(function (acc, val) {
        if (val < 0) {
            throw new Error('Probability must be a positive: p[' + p.indexOf(val) + ']=' + val);
        }
        return acc + val;
    }, 0);
    if (sum === 0) {
        throw new Error('Probability sum must be greater than zero.');
    }
    var scaledProbabilities = p.map(function (prob) { return (prob * n) / sum; });
    var aliasData = { prob: new Array(n), alias: new Array(n) };
    var small = [];
    var large = [];
    for (var i = n - 1; i >= 0; i--) {
        if (scaledProbabilities[i] < 1) {
            small.push(i);
        }
        else {
            large.push(i);
        }
    }
    while (small.length > 0 && large.length > 0) {
        var less = small.pop();
        var more = large.pop();
        aliasData.prob[less] = scaledProbabilities[less];
        aliasData.alias[less] = more;
        scaledProbabilities[more] = (scaledProbabilities[more] + scaledProbabilities[less]) - 1;
        if (scaledProbabilities[more] < 1) {
            small.push(more);
        }
        else {
            large.push(more);
        }
    }
    while (large.length > 0) {
        aliasData.prob[large.pop()] = 1;
    }
    while (small.length > 0) {
        aliasData.prob[small.pop()] = 1;
    }
    return aliasData;
};
var draw = function (aliasData, outcomes, rng) {
    var c = Math.floor(rng() * aliasData.prob.length);
    return outcomes[(rng() < aliasData.prob[c]) ? c : aliasData.alias[c]];
};
var next = function (aliasData, outcomes, rng, numOfSamples) {
    if (numOfSamples === void 0) { numOfSamples = 1; }
    if (numOfSamples === 1) {
        return draw(aliasData, outcomes, rng);
    }
    var samples = [];
    for (var i = 0; i < numOfSamples; i++) {
        samples.push(draw(aliasData, outcomes, rng));
    }
    return samples;
};
var sample = function (probabilities, outcomes, rng) {
    if (rng === void 0) { rng = Math.random; }
    if (!Array.isArray(probabilities)) {
        throw new Error('Probabilities must be an array.');
    }
    if (probabilities.length === 0) {
        throw new Error('Probabilities array must not be empty.');
    }
    var n = probabilities.length;
    var indexedOutcomes = outcomes !== null && outcomes !== void 0 ? outcomes : Array.from({ length: n }, function (_, i) { return i; });
    var aliasData = precomputeAlias(probabilities, n);
    return {
        next: function (numOfSamples) {
            if (numOfSamples === void 0) { numOfSamples = 1; }
            return next(aliasData, indexedOutcomes, rng, numOfSamples);
        }
    };
};
exports.default = sample;

      };
    };
  }
  }
}, {package:"@ngraveio/bc-ur>@keystonehq/alias-sampling",file:"node_modules\\@keystonehq\\alias-sampling\\dist\\cjs\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\abi.js", {"./errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\errors.js","./packer":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\packer.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cabi-utils%5Cdist%5Cabi.js
      return function (require, module, exports) {
"use strict";
// ESLint gets confused by the nested list and tables in the docs, so we disable
// the rule for this file.
/* eslint-disable jsdoc/check-indentation, jsdoc/match-description */
Object.defineProperty(exports, "__esModule", { value: true });
exports.decodeSingle = exports.decode = exports.encodePacked = exports.encodeSingle = exports.encode = void 0;
const utils_1 = require("@metamask/utils");
const errors_1 = require("./errors");
const packer_1 = require("./packer");
/**
 * Encode the data with the provided types. The types must be valid Solidity
 * ABI types.
 *
 * This will attempt to parse the values into the correct types. For example,
 * if you pass in a hex string for a `uint256`, it will be parsed into a
 * `bigint`. Regular strings are interpreted as UTF-8 strings. If you want to
 * pass in a hex string, you must pass it in as a `Uint8Array`, or use the
 * "0x"-prefix.
 *
 * It will also attempt to infer the types of the values. For example, if you
 * pass in a string for a `uint256`, it will result in a TypeScript compile-time
 * error. This does not work for all types, however. For example, if you use
 * nested arrays or tuples, the type will be inferred as `unknown`.
 *
 * The following types are supported:
 *
 * - `address`: A 20-byte Ethereum address.
 *   - As a 40-character-long hexadecimal string, starting with "0x".
 *   - As a 20-byte-long byte array, i.e., `Uint8Array`.
 * - `bool`: A boolean value.
 *   - As a boolean literal, i.e., `true` or `false`.
 *   - As the strings "true" or "false".
 * - `bytes(n)`: A dynamic byte array.
 *   - As a hexadecimal string, starting with "0x".
 *   - As a byte array, i.e., `Uint8Array`.
 *   - As a regular string, which will be interpreted as UTF-8.
 * - `function`: A Solidity function.
 *   - As a 48-character-long hexadecimal string, starting with "0x".
 *   - As a 24-byte-long byte array, i.e., `Uint8Array`.
 *   - As a {@link SolidityFunction} object.
 * - `int(n)`: A signed integer.
 *   - As a number.
 *   - As a `bigint`.
 *   - As a hexadecimal string, starting with "0x".
 * - `string`: A dynamic UTF-8 string.
 *   - As a regular string.
 *   - As a hexadecimal string, starting with "0x".
 *   - As a byte array, i.e., `Uint8Array`.
 * - `tuple`: A tuple of values.
 *   - As an array of values.
 * - `uint(n)`: An unsigned integer.
 *   - As a number.
 *   - As a `bigint`.
 *   - As a hexadecimal string, starting with "0x".
 *
 * @example
 * ```typescript
 * import { encode, decode } from '@metamask/abi-utils';
 *
 * const types = ['uint256', 'string'];
 * const encoded = encode(types, [42, 'Hello, world!']);
 * const decoded = decode(types, encoded);
 *
 * console.log(decoded); // [42n, 'Hello, world!']
 * ```
 * @see https://docs.soliditylang.org/en/v0.8.17/abi-spec.html
 * @param types - The types to encode.
 * @param values - The values to encode. This array must have the same length as
 * the types array.
 * @param packed - Whether to use the non-standard packed mode. Defaults to
 * `false`.
 * @param tight - Whether to pack the values tightly. When enabled, the values
 * will be packed without any padding. This matches the behaviour of
 * `ethereumjs-abi`. Defaults to `false`.
 * @returns The ABI encoded bytes.
 */
const encode = (types, values, packed, tight) => {
    try {
        return (0, packer_1.pack)({ types, values, packed, tight });
    }
    catch (error) {
        if (error instanceof errors_1.ParserError) {
            throw new errors_1.ParserError(`Unable to encode value: ${error.message}`, error);
        }
        throw new errors_1.ParserError(`An unexpected error occurred: ${(0, errors_1.getErrorMessage)(error)}`, error);
    }
};
exports.encode = encode;
/**
 * Encode the data with the provided type. The type must be a valid Solidity
 * ABI type.
 *
 * See {@link encode} for more information on how values are parsed.
 *
 * @example
 * ```typescript
 * import { encodeSingle, decodeSingle } from '@metamask/abi-utils';
 *
 * const encoded = encodeSingle('uint256', 42);
 * const decoded = decodeSingle('uint256', encoded);
 *
 * console.log(decoded); // 42n
 * ```
 * @see https://docs.soliditylang.org/en/v0.8.17/abi-spec.html#types
 * @param type - The type to encode.
 * @param value - The value to encode.
 * @returns The ABI encoded bytes.
 */
const encodeSingle = (type, value) => {
    return (0, exports.encode)([type], [value]);
};
exports.encodeSingle = encodeSingle;
/**
 * Encode the data with the provided types. The types must be valid Solidity
 * ABI types. This is similar to {@link encode}, but the values are encoded in
 * the non-standard packed mode. This differs from the standard encoding in the
 * following ways:
 *
 * - Most values are packed tightly, without alignment padding.
 *   - The exception is array values, which are padded to 32 bytes.
 * - Values are still padded to their full size, i.e., `uint16` values are still
 *  padded to 2 bytes, regardless of the length of the value.
 * - The encoding of dynamic types (`bytes`, `string`) is different. The length
 * of the dynamic type is not included in the encoding, and the dynamic type is
 * not padded to a multiple of 32 bytes.
 * - All values are encoded in-place, without any offsets.
 *
 * The encoding of this is ambiguous as soon as there is more than one dynamic
 * type. That means that these values cannot be decoded with {@link decode} or
 * Solidity's `abi.decode` function.
 *
 * See {@link encode} for more information on how values are parsed.
 *
 * @example
 * ```typescript
 * import { encodePacked } from '@metamask/abi-utils';
 *
 * const encoded = encodePacked(['uint8'], [42]);
 *
 * console.log(encoded); // `Uint8Array [ 42 ]`
 * ```
 * @see https://docs.soliditylang.org/en/v0.8.17/abi-spec.html#types
 * @see https://docs.soliditylang.org/en/v0.8.17/abi-spec.html#non-standard-packed-mode
 * @param types - The types to encode.
 * @param values - The values to encode.
 * @param tight - Whether to pack the values tightly. When enabled, `bytesN`
 * values in arrays will be packed without any padding. This matches the
 * behaviour of `ethereumjs-abi`. Defaults to `false`.
 * @returns The ABI encoded bytes.
 */
const encodePacked = (types, values, tight) => {
    return (0, exports.encode)(types, values, true, tight);
};
exports.encodePacked = encodePacked;
/**
 * Decode an ABI encoded buffer with the specified types. The types must be
 * valid Solidity ABI types.
 *
 * This will attempt to infer the output types from the input types. For
 * example, if you use `uint256` as an input type, the output type will be
 * `bigint`. This does not work for all types, however. For example, if you use
 * nested array types or tuple types, the output type will be `unknown`.
 *
 * The resulting types of the values will be as follows:
 *
 * | Contract ABI Type | Resulting JavaScript Type |
 * | ----------------- | ------------------------- |
 * | `address`         | `string`                  |
 * | `bool`            | `boolean`                 |
 * | `bytes(n)`        | `Uint8Array`              |
 * | `function`        | {@link SolidityFunction}  |
 * | `int(n)`          | `bigint`                  |
 * | `string`          | `string`                  |
 * | `tuple`           | `Array`                   |
 * | `array`           | `Array`                   |
 * | `uint(n)`         | `bigint`                  |
 *
 * @example
 * ```typescript
 * import { encode, decode } from '@metamask/abi-utils';
 *
 * const types = ['uint256', 'string'];
 * const encoded = encode(types, [42, 'Hello, world!']);
 * const decoded = decode(types, encoded);
 *
 * console.log(decoded); // [42n, 'Hello, world!']
 * ```
 * @see https://docs.soliditylang.org/en/v0.8.17/abi-spec.html#types
 * @param types - The types to decode the bytes with.
 * @param value - The bytes-like value to decode.
 * @returns The decoded values as array.
 */
const decode = (types, value) => {
    const bytes = (0, utils_1.createBytes)(value);
    try {
        return (0, packer_1.unpack)(types, bytes);
    }
    catch (error) {
        if (error instanceof errors_1.ParserError) {
            throw new errors_1.ParserError(`Unable to decode value: ${error.message}`, error);
        }
        throw new errors_1.ParserError(`An unexpected error occurred: ${(0, errors_1.getErrorMessage)(error)}`, error);
    }
};
exports.decode = decode;
/**
 * Decode the data with the provided type. The type must be a valid Solidity
 * ABI type.
 *
 * See {@link decode} for more information on how values are parsed.
 *
 * @example
 * ```typescript
 * import { encodeSingle, decodeSingle } from '@metamask/abi-utils';
 *
 * const encoded = encodeSingle('uint256', 42);
 * const decoded = decodeSingle('uint256', encoded);
 *
 * console.log(decoded); // 42n
 * ```
 * @see https://docs.soliditylang.org/en/v0.8.17/abi-spec.html#types
 * @param type - The type to decode.
 * @param value - The bytes-like value to decode.
 * @returns The decoded value.
 */
const decodeSingle = (type, value) => {
    const result = (0, exports.decode)([type], value);
    (0, utils_1.assert)(result.length === 1, new errors_1.ParserError('Decoded value array has unexpected length.'));
    return result[0];
};
exports.decodeSingle = decodeSingle;

      };
    };
  }
  }
}, {package:"@metamask/abi-utils",file:"node_modules\\@metamask\\abi-utils\\dist\\abi.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\errors.js", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cabi-utils%5Cdist%5Cerrors.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParserError = exports.getErrorStack = exports.getErrorMessage = void 0;
const utils_1 = require("@metamask/utils");
/**
 * Attempt to get an error message from a value.
 *
 * - If the value is an error, the error's message is returned.
 * - If the value is an object with a `message` property, the value of that
 * property is returned.
 * - If the value is a string, the value is returned.
 * - Otherwise, "Unknown error." is returned.
 *
 * @param error - The value to get an error message from.
 * @returns The error message.
 * @internal
 */
const getErrorMessage = (error) => {
    if (typeof error === 'string') {
        return error;
    }
    if (error instanceof Error) {
        return error.message;
    }
    if ((0, utils_1.isObject)(error) &&
        (0, utils_1.hasProperty)(error, 'message') &&
        typeof error.message === 'string') {
        return error.message;
    }
    return 'Unknown error.';
};
exports.getErrorMessage = getErrorMessage;
/**
 * Get the error stack from a value. If the value is an error, the error's stack
 * is returned. Otherwise, it returns `undefined`.
 *
 * @param error - The value to get an error stack from.
 * @returns The error stack, or `undefined` if the value is not an error.
 * @internal
 */
const getErrorStack = (error) => {
    if (error instanceof Error) {
        return error.stack;
    }
    return undefined;
};
exports.getErrorStack = getErrorStack;
/**
 * An error that is thrown when the ABI encoder or decoder encounters an
 * issue.
 */
class ParserError extends Error {
    constructor(message, originalError) {
        super(message);
        this.name = 'ParserError';
        const originalStack = (0, exports.getErrorStack)(originalError);
        if (originalStack) {
            this.stack = originalStack;
        }
    }
}
exports.ParserError = ParserError;

      };
    };
  }
  }
}, {package:"@metamask/abi-utils",file:"node_modules\\@metamask\\abi-utils\\dist\\errors.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\index.js", {"./abi":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\abi.js","./errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\errors.js","./types":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\types\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cabi-utils%5Cdist%5Cindex.js
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./abi"), exports);
__exportStar(require("./errors"), exports);
__exportStar(require("./types"), exports);

      };
    };
  }
  }
}, {package:"@metamask/abi-utils",file:"node_modules\\@metamask\\abi-utils\\dist\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\iterator.js", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cabi-utils%5Cdist%5Citerator.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.iterate = void 0;
const utils_1 = require("@metamask/utils");
/**
 * Iterate over a buffer with the specified size. This will yield a part of the
 * buffer starting at an increment of the specified size, until the end of the
 * buffer is reached.
 *
 * Calling the `skip` function will make it skip the specified number of bytes.
 *
 * @param buffer - The buffer to iterate over.
 * @param size - The number of bytes to iterate with.
 * @returns An iterator that yields the parts of the byte array.
 * @yields The parts of the byte array.
 */
const iterate = function* (buffer, size = 32) {
    for (let pointer = 0; pointer < buffer.length; pointer += size) {
        const skip = (length) => {
            (0, utils_1.assert)(length >= 0, 'Cannot skip a negative number of bytes.');
            (0, utils_1.assert)(length % size === 0, 'Length must be a multiple of the size.');
            pointer += length;
        };
        const value = buffer.subarray(pointer);
        yield { skip, value };
    }
    return {
        skip: () => undefined,
        value: new Uint8Array(),
    };
};
exports.iterate = iterate;

      };
    };
  }
  }
}, {package:"@metamask/abi-utils",file:"node_modules\\@metamask\\abi-utils\\dist\\iterator.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\packer.js", {"./errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\errors.js","./iterator":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\iterator.js","./parsers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\index.js","./utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\utils\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cabi-utils%5Cdist%5Cpacker.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.unpack = exports.pack = exports.isDynamicParser = exports.getParser = void 0;
const utils_1 = require("@metamask/utils");
const errors_1 = require("./errors");
const iterator_1 = require("./iterator");
const parsers_1 = require("./parsers");
const utils_2 = require("./utils");
/**
 * Get the parser for the specified type.
 *
 * @param type - The type to get a parser for.
 * @returns The parser.
 * @throws If there is no parser for the specified type.
 */
const getParser = (type) => {
    const parsers = {
        address: parsers_1.address,
        array: parsers_1.array,
        bool: parsers_1.bool,
        bytes: parsers_1.bytes,
        fixedBytes: parsers_1.fixedBytes,
        function: parsers_1.fn,
        number: parsers_1.number,
        string: parsers_1.string,
        tuple: parsers_1.tuple,
    };
    const staticParser = parsers[type];
    if (staticParser) {
        return staticParser;
    }
    const parser = Object.values(parsers).find((value) => value.isType(type));
    if (parser) {
        return parser;
    }
    throw new errors_1.ParserError(`The type "${type}" is not supported.`);
};
exports.getParser = getParser;
/**
 * Check if the specified parser is dynamic, for the provided types. This is
 * primarily used for parsing tuples, where a tuple can be dynamic based on the
 * types. For other parsers, it will simply use the set `isDynamic` value.
 *
 * @param parser - The parser to check.
 * @param type - The type to check the parser with.
 * @returns Whether the parser is dynamic.
 */
const isDynamicParser = (parser, type) => {
    const { isDynamic } = parser;
    if (typeof isDynamic === 'function') {
        return isDynamic(type);
    }
    return isDynamic;
};
exports.isDynamicParser = isDynamicParser;
/**
 * Pack the provided values in a buffer, encoded with the specified types. If a
 * buffer is specified, the resulting value will be concatenated with the
 * buffer.
 *
 * @param args - The arguments object.
 * @param args.types - The types of the values to pack.
 * @param args.values - The values to pack.
 * @param args.packed - Whether to use the non-standard packed mode. Defaults to
 * `false`.
 * @param args.arrayPacked - Whether to use the non-standard packed mode for
 * arrays. Defaults to `false`.
 * @param args.byteArray - The byte array to encode the values into. Defaults to
 * an empty array.
 * @param args.tight - Whether to use tight packing mode. Only applicable when
 * `packed` is true. When true, the packed mode will not add any padding bytes.
 * This matches the packing behaviour of `ethereumjs-abi`, but is not standard.
 * @returns The resulting encoded buffer.
 */
const pack = ({ types, values, packed = false, tight = false, arrayPacked = false, byteArray = new Uint8Array(), }) => {
    (0, utils_1.assert)(types.length === values.length, new errors_1.ParserError(`The number of types (${types.length}) does not match the number of values (${values.length}).`));
    const { staticBuffer, dynamicBuffer, pointers } = types.reduce(
    // eslint-disable-next-line @typescript-eslint/no-shadow
    ({ staticBuffer, dynamicBuffer, pointers }, type, index) => {
        const parser = (0, exports.getParser)(type);
        const value = values[index];
        // If packed mode is enabled, we can skip the dynamic check, as all
        // values are encoded in the static buffer.
        if (packed || arrayPacked || !(0, exports.isDynamicParser)(parser, type)) {
            return {
                staticBuffer: parser.encode({
                    buffer: staticBuffer,
                    value,
                    type,
                    packed,
                    tight,
                }),
                dynamicBuffer,
                pointers,
            };
        }
        const newStaticBuffer = (0, utils_1.concatBytes)([staticBuffer, new Uint8Array(32)]);
        const newDynamicBuffer = parser.encode({
            buffer: dynamicBuffer,
            value,
            type,
            packed,
            tight,
        });
        return {
            staticBuffer: newStaticBuffer,
            dynamicBuffer: newDynamicBuffer,
            pointers: [
                ...pointers,
                { position: staticBuffer.length, pointer: dynamicBuffer.length },
            ],
        };
    }, {
        staticBuffer: new Uint8Array(),
        dynamicBuffer: new Uint8Array(),
        pointers: [],
    });
    // If packed mode is enabled, there shouldn't be any dynamic values.
    (0, utils_1.assert)((!packed && !arrayPacked) || dynamicBuffer.length === 0, new errors_1.ParserError('Invalid pack state.'));
    const dynamicStart = staticBuffer.length;
    const updatedBuffer = pointers.reduce((target, { pointer, position }) => {
        const offset = (0, utils_2.padStart)((0, utils_1.numberToBytes)(dynamicStart + pointer));
        return (0, utils_2.set)(target, offset, position);
    }, staticBuffer);
    return (0, utils_1.concatBytes)([byteArray, updatedBuffer, dynamicBuffer]);
};
exports.pack = pack;
const unpack = (types, buffer) => {
    const iterator = (0, iterator_1.iterate)(buffer);
    return types.map((type) => {
        const { value: { value, skip }, done, } = iterator.next();
        (0, utils_1.assert)(!done, new errors_1.ParserError(`The encoded value is invalid for the provided types. Reached end of buffer while attempting to parse "${type}".`));
        const parser = (0, exports.getParser)(type);
        const isDynamic = (0, exports.isDynamicParser)(parser, type);
        if (isDynamic) {
            const pointer = (0, utils_1.bytesToNumber)(value.subarray(0, 32));
            const target = buffer.subarray(pointer);
            return parser.decode({ type, value: target, skip });
        }
        return parser.decode({ type, value, skip });
    });
};
exports.unpack = unpack;

      };
    };
  }
  }
}, {package:"@metamask/abi-utils",file:"node_modules\\@metamask\\abi-utils\\dist\\packer.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\address.js", {"../errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\errors.js","../utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\utils\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cabi-utils%5Cdist%5Cparsers%5Caddress.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.address = exports.getAddress = void 0;
const utils_1 = require("@metamask/utils");
const errors_1 = require("../errors");
const utils_2 = require("../utils");
/**
 * Normalize an address value. This accepts the address as:
 *
 * - A hex string starting with the `0x` prefix.
 * - A byte array (`Uint8Array` or `Buffer`).
 *
 * It checks that the address is 20 bytes long.
 *
 * @param value - The value to normalize.
 * @returns The normalized address as `Uint8Array`.
 */
const getAddress = (value) => {
    const bytesValue = (0, utils_1.createBytes)(value);
    (0, utils_1.assert)(bytesValue.length <= 20, new errors_1.ParserError(`Invalid address value. Expected address to be 20 bytes long, but received ${bytesValue.length} bytes.`));
    return (0, utils_2.padStart)(bytesValue, 20);
};
exports.getAddress = getAddress;
exports.address = {
    isDynamic: false,
    /**
     * Get if the given value is a valid address type. Since `address` is a simple
     * type, this is just a check that the value is "address".
     *
     * @param type - The type to check.
     * @returns Whether the type is a valid address type.
     */
    isType: (type) => type === 'address',
    /**
     * Get the byte length of an encoded address. Since `address` is a simple
     * type, this always returns 32.
     *
     * Note that actual addresses are only 20 bytes long, but the encoding of
     * the `address` type is always 32 bytes long.
     *
     * @returns The byte length of an encoded address.
     */
    getByteLength() {
        return 32;
    },
    /**
     * Encode the given address to a 32-byte-long byte array.
     *
     * @param args - The encoding arguments.
     * @param args.buffer - The byte array to add to.
     * @param args.value - The address to encode.
     * @param args.packed - Whether to use packed encoding.
     * @returns The bytes with the encoded address added to it.
     */
    encode({ buffer, value, packed }) {
        const addressValue = (0, exports.getAddress)(value);
        // If we're using packed encoding, we can just add the address bytes to the
        // byte array, without adding any padding.
        if (packed) {
            return (0, utils_1.concatBytes)([buffer, addressValue]);
        }
        const addressBuffer = (0, utils_2.padStart)(addressValue);
        return (0, utils_1.concatBytes)([buffer, addressBuffer]);
    },
    /**
     * Decode the given byte array to an address.
     *
     * @param args - The decoding arguments.
     * @param args.value - The byte array to decode.
     * @returns The decoded address as a hexadecimal string, starting with the
     * "0x"-prefix.
     */
    decode({ value }) {
        return (0, utils_1.add0x)((0, utils_1.bytesToHex)(value.slice(12, 32)));
    },
};

      };
    };
  }
  }
}, {package:"@metamask/abi-utils",file:"node_modules\\@metamask\\abi-utils\\dist\\parsers\\address.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\array.js", {"../errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\errors.js","../packer":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\packer.js","../utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\utils\\index.js","./fixed-bytes":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\fixed-bytes.js","./tuple":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\tuple.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cabi-utils%5Cdist%5Cparsers%5Carray.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.array = exports.getTupleType = exports.getArrayType = exports.isArrayType = void 0;
const utils_1 = require("@metamask/utils");
const errors_1 = require("../errors");
const packer_1 = require("../packer");
const utils_2 = require("../utils");
const fixed_bytes_1 = require("./fixed-bytes");
const tuple_1 = require("./tuple");
const ARRAY_REGEX = /^(?<type>.*)\[(?<length>\d*?)\]$/u;
const isArrayType = (type) => ARRAY_REGEX.test(type);
exports.isArrayType = isArrayType;
/**
 * Get the type of the array.
 *
 * @param type - The type to get the array type for.
 * @returns The array type.
 */
const getArrayType = (type) => {
    const match = type.match(ARRAY_REGEX);
    (0, utils_1.assert)(match?.groups?.type, new errors_1.ParserError(`Invalid array type. Expected an array type, but received "${type}".`));
    return [
        match.groups.type,
        match.groups.length ? parseInt(match.groups.length, 10) : undefined,
    ];
};
exports.getArrayType = getArrayType;
/**
 * Get the type of the array as a tuple type. This is used for encoding fixed
 * length arrays, which are encoded as tuples.
 *
 * @param innerType - The type of the array.
 * @param length - The length of the array.
 * @returns The tuple type.
 */
const getTupleType = (innerType, length) => {
    return `(${new Array(length).fill(innerType).join(',')})`;
};
exports.getTupleType = getTupleType;
exports.array = {
    /**
     * Check if the array is dynamic. Arrays are dynamic if the array does not
     * have a fixed length, or if the array type is dynamic.
     *
     * @param type - The type to check.
     * @returns Whether the array is dynamic.
     */
    isDynamic(type) {
        const [innerType, length] = (0, exports.getArrayType)(type);
        return (
        // `T[]` is dynamic for any `T`. `T[k]` is dynamic for any dynamic `T` and
        // any `k >= 0`.
        length === undefined || (0, packer_1.isDynamicParser)((0, packer_1.getParser)(innerType), innerType));
    },
    /**
     * Check if a type is an array type.
     *
     * @param type - The type to check.
     * @returns Whether the type is an array type.
     */
    isType(type) {
        return (0, exports.isArrayType)(type);
    },
    /**
     * Get the byte length of an encoded array. If the array is dynamic, this
     * returns 32, i.e., the length of the pointer to the array. If the array is
     * static, this returns the byte length of the resulting tuple type.
     *
     * @param type - The type to get the byte length for.
     * @returns The byte length of an encoded array.
     */
    getByteLength(type) {
        (0, utils_1.assert)((0, exports.isArrayType)(type), new errors_1.ParserError(`Expected an array type, but received "${type}".`));
        const [innerType, length] = (0, exports.getArrayType)(type);
        if (!(0, packer_1.isDynamicParser)(this, type) && length !== undefined) {
            return tuple_1.tuple.getByteLength((0, exports.getTupleType)(innerType, length));
        }
        return 32;
    },
    /**
     * Encode the given array to a byte array. If the array is static, this uses
     * the tuple encoder.
     *
     * @param args - The encoding arguments.
     * @param args.type - The type of the array.
     * @param args.buffer - The byte array to add to.
     * @param args.value - The array to encode.
     * @param args.packed - Whether to use non-standard packed encoding.
     * @param args.tight - Whether to use non-standard tight encoding.
     * @returns The bytes with the encoded array added to it.
     */
    encode({ type, buffer, value, packed, tight }) {
        const [arrayType, fixedLength] = (0, exports.getArrayType)(type);
        // Packed encoding does not support nested arrays.
        (0, utils_1.assert)(!packed || !(0, exports.isArrayType)(arrayType), new errors_1.ParserError(`Cannot pack nested arrays.`));
        // Tightly pack `T[]` where `T` is a dynamic type. This is not supported in
        // Solidity, but is commonly used in the Ethereum ecosystem.
        if (packed && (0, packer_1.isDynamicParser)((0, packer_1.getParser)(arrayType), arrayType)) {
            return (0, packer_1.pack)({
                types: new Array(value.length).fill(arrayType),
                values: value,
                byteArray: buffer,
                packed,
                arrayPacked: true,
                tight,
            });
        }
        if (fixedLength) {
            (0, utils_1.assert)(fixedLength === value.length, new errors_1.ParserError(`Array length does not match type length. Expected a length of ${fixedLength}, but received ${value.length}.`));
            // `T[k]` for any `T` and `k` is encoded as `(T[0], ..., T[k - 1])`.
            return tuple_1.tuple.encode({
                type: (0, exports.getTupleType)(arrayType, fixedLength),
                buffer,
                value,
                // In "tight" mode, we don't pad the values to 32 bytes if the value is
                // of type `bytesN`. This is an edge case in `ethereumjs-abi` that we
                // support to provide compatibility with it.
                packed: fixed_bytes_1.fixedBytes.isType(arrayType) && tight,
                tight,
            });
        }
        // For packed encoding, we don't need to encode the length of the array,
        // so we can just encode the values.
        if (packed) {
            return (0, packer_1.pack)({
                types: new Array(value.length).fill(arrayType),
                values: value,
                byteArray: buffer,
                // In "tight" mode, we don't pad the values to 32 bytes if the value is
                // of type `bytesN`. This is an edge case in `ethereumjs-abi` that we
                // support to provide compatibility with it.
                packed: fixed_bytes_1.fixedBytes.isType(arrayType) && tight,
                arrayPacked: true,
                tight,
            });
        }
        // `T[]` with `k` elements is encoded as `k (T[0], ..., T[k - 1])`. That
        // means that we just need to encode the length of the array, and then the
        // array itself. The pointer is encoded by the {@link pack} function.
        const arrayLength = (0, utils_2.padStart)((0, utils_1.numberToBytes)(value.length));
        return (0, packer_1.pack)({
            types: new Array(value.length).fill(arrayType),
            values: value,
            byteArray: (0, utils_1.concatBytes)([buffer, arrayLength]),
            packed,
            tight,
        });
    },
    /**
     * Decode an array from the given byte array.
     *
     * @param args - The decoding arguments.
     * @param args.type - The type of the array.
     * @param args.value - The byte array to decode.
     * @returns The decoded array.
     */
    decode({ type, value, ...rest }) {
        const [arrayType, fixedLength] = (0, exports.getArrayType)(type);
        if (fixedLength) {
            const result = tuple_1.tuple.decode({
                type: (0, exports.getTupleType)(arrayType, fixedLength),
                value,
                ...rest,
            });
            (0, utils_1.assert)(result.length === fixedLength, new errors_1.ParserError(`Array length does not match type length. Expected a length of ${fixedLength}, but received ${result.length}.`));
            return result;
        }
        const arrayLength = (0, utils_1.bytesToNumber)(value.subarray(0, 32));
        return (0, packer_1.unpack)(new Array(arrayLength).fill(arrayType), value.subarray(32));
    },
};

      };
    };
  }
  }
}, {package:"@metamask/abi-utils",file:"node_modules\\@metamask\\abi-utils\\dist\\parsers\\array.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\bool.js", {"../errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\errors.js","./number":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\number.js","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cabi-utils%5Cdist%5Cparsers%5Cbool.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bool = exports.getBooleanValue = void 0;
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const errors_1 = require("../errors");
const number_1 = require("./number");
const BooleanCoercer = (0, superstruct_1.coerce)((0, superstruct_1.boolean)(), (0, superstruct_1.union)([(0, superstruct_1.literal)('true'), (0, superstruct_1.literal)('false')]), (value) => value === 'true');
/**
 * Normalize a boolean value. This accepts the boolean as:
 *
 * - A boolean literal.
 * - The string "true" or "false".
 *
 * @param value - The value to get a boolean for.
 * @returns The parsed boolean value. This is `BigInt(1)` for truthy values, or
 * `BigInt(0)` for falsy values.
 */
const getBooleanValue = (value) => {
    try {
        const booleanValue = (0, superstruct_1.create)(value, BooleanCoercer);
        if (booleanValue) {
            return BigInt(1);
        }
        return BigInt(0);
    }
    catch {
        throw new errors_1.ParserError(`Invalid boolean value. Expected a boolean literal, or the string "true" or "false", but received "${value}".`);
    }
};
exports.getBooleanValue = getBooleanValue;
exports.bool = {
    isDynamic: false,
    /**
     * Get if the given value is a valid boolean type. Since `bool` is a simple
     * type, this is just a check that the value is "bool".
     *
     * @param type - The type to check.
     * @returns Whether the type is a valid boolean type.
     */
    isType: (type) => type === 'bool',
    /**
     * Get the byte length of an encoded boolean. Since `bool` is a simple
     * type, this always returns 32.
     *
     * Note that actual booleans are only 1 byte long, but the encoding of
     * the `bool` type is always 32 bytes long.
     *
     * @returns The byte length of an encoded boolean.
     */
    getByteLength() {
        return 32;
    },
    /**
     * Encode the given boolean to a byte array.
     *
     * @param args - The encoding arguments.
     * @param args.buffer - The byte array to add to.
     * @param args.value - The boolean to encode.
     * @param args.packed - Whether the value is packed.
     * @param args.tight - Whether to use non-standard tight encoding.
     * @returns The bytes with the encoded boolean added to it.
     */
    encode({ buffer, value, packed, tight }) {
        const booleanValue = (0, exports.getBooleanValue)(value);
        // For packed encoding, we add a single byte (`0x00` or `0x01`) to the byte
        // array.
        if (packed) {
            return (0, utils_1.concatBytes)([buffer, (0, utils_1.bigIntToBytes)(booleanValue)]);
        }
        // Booleans are encoded as 32-byte integers, so we use the number parser
        // to encode the boolean value.
        return number_1.number.encode({
            type: 'uint256',
            buffer,
            value: booleanValue,
            packed,
            tight,
        });
    },
    /**
     * Decode the given byte array to a boolean.
     *
     * @param args - The decoding arguments.
     * @returns The decoded boolean.
     */
    decode(args) {
        // Booleans are encoded as 32-byte integers, so we use the number parser
        // to decode the boolean value.
        return number_1.number.decode({ ...args, type: 'uint256' }) === BigInt(1);
    },
};

      };
    };
  }
  }
}, {package:"@metamask/abi-utils",file:"node_modules\\@metamask\\abi-utils\\dist\\parsers\\bool.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\bytes.js", {"../utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\utils\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cabi-utils%5Cdist%5Cparsers%5Cbytes.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bytes = void 0;
const utils_1 = require("@metamask/utils");
const utils_2 = require("../utils");
exports.bytes = {
    isDynamic: true,
    /**
     * Check if a type is a bytes type. Since `bytes` is a simple type, this is
     * just a check that the type is "bytes".
     *
     * @param type - The type to check.
     * @returns Whether the type is a bytes type.
     */
    isType: (type) => type === 'bytes',
    /**
     * Get the byte length of an encoded bytes value. Since `bytes` is a simple
     * type, this always returns 32.
     *
     * Note that actual length of a bytes value is variable, but the encoded
     * static value (pointer) is always 32 bytes long.
     *
     * @returns The byte length of an encoded bytes value.
     */
    getByteLength() {
        return 32;
    },
    /**
     * Encode the given bytes value to a byte array.
     *
     * @param args - The encoding arguments.
     * @param args.buffer - The byte array to add to.
     * @param args.value - The bytes value to encode.
     * @param args.packed - Whether to use packed encoding.
     * @returns The bytes with the encoded bytes value added to it.
     */
    encode({ buffer, value, packed }) {
        const bufferValue = (0, utils_1.createBytes)(value);
        // For packed encoding, we can just add the bytes value to the byte array,
        // without adding any padding or alignment. There is also no need to
        // encode the length of the bytes.
        if (packed) {
            return (0, utils_1.concatBytes)([buffer, bufferValue]);
        }
        const paddedSize = Math.ceil(bufferValue.byteLength / 32) * 32;
        // Bytes of length `k` are encoded as `k pad_right(bytes)`.
        return (0, utils_1.concatBytes)([
            buffer,
            (0, utils_2.padStart)((0, utils_1.numberToBytes)(bufferValue.byteLength)),
            (0, utils_2.padEnd)(bufferValue, paddedSize),
        ]);
    },
    /**
     * Decode the given byte array to a bytes value.
     *
     * @param args - The decoding arguments.
     * @param args.value - The byte array to decode.
     * @returns The decoded bytes value as a `Uint8Array`.
     */
    decode({ value }) {
        const bytesValue = value.subarray(0, 32);
        const length = (0, utils_1.bytesToNumber)(bytesValue);
        // Since we're returning a `Uint8Array`, we use `slice` to copy the bytes
        // into a new array.
        return value.slice(32, 32 + length);
    },
};

      };
    };
  }
  }
}, {package:"@metamask/abi-utils",file:"node_modules\\@metamask\\abi-utils\\dist\\parsers\\bytes.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\fixed-bytes.js", {"../errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\errors.js","../utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\utils\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cabi-utils%5Cdist%5Cparsers%5Cfixed-bytes.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fixedBytes = exports.getByteLength = void 0;
const utils_1 = require("@metamask/utils");
const errors_1 = require("../errors");
const utils_2 = require("../utils");
const BYTES_REGEX = /^bytes([0-9]{1,2})$/u;
/**
 * Get the length of the specified type. If a length is not specified, or if the
 * length is out of range (0 < n <= 32), this will throw an error.
 *
 * @param type - The type to get the length for.
 * @returns The byte length of the type.
 */
const getByteLength = (type) => {
    const bytes = type.match(BYTES_REGEX)?.[1];
    (0, utils_1.assert)(bytes, `Invalid byte length. Expected a number between 1 and 32, but received "${type}".`);
    const length = Number(bytes);
    (0, utils_1.assert)(length > 0 && length <= 32, new errors_1.ParserError(`Invalid byte length. Expected a number between 1 and 32, but received "${type}".`));
    return length;
};
exports.getByteLength = getByteLength;
exports.fixedBytes = {
    isDynamic: false,
    /**
     * Check if a type is a fixed bytes type.
     *
     * @param type - The type to check.
     * @returns Whether the type is a fixed bytes type.
     */
    isType(type) {
        return BYTES_REGEX.test(type);
    },
    /**
     * Get the byte length of an encoded fixed bytes type.
     *
     * @returns The byte length of the type.
     */
    getByteLength() {
        return 32;
    },
    /**
     * Encode a fixed bytes value.
     *
     * @param args - The arguments to encode.
     * @param args.type - The type of the value.
     * @param args.buffer - The byte array to add to.
     * @param args.value - The value to encode.
     * @param args.packed - Whether to use packed encoding.
     * @returns The bytes with the encoded value added to it.
     */
    encode({ type, buffer, value, packed }) {
        const length = (0, exports.getByteLength)(type);
        const bufferValue = (0, utils_1.createBytes)(value);
        (0, utils_1.assert)(bufferValue.length <= length, new errors_1.ParserError(`Expected a value of length ${length}, but received a value of length ${bufferValue.length}.`));
        // For packed encoding, the value is padded to the length of the type, and
        // then added to the byte array.
        if (packed) {
            return (0, utils_1.concatBytes)([buffer, (0, utils_2.padEnd)(bufferValue, length)]);
        }
        return (0, utils_1.concatBytes)([buffer, (0, utils_2.padEnd)(bufferValue)]);
    },
    /**
     * Decode a fixed bytes value.
     *
     * @param args - The arguments to decode.
     * @param args.type - The type of the value.
     * @param args.value - The value to decode.
     * @returns The decoded value as a `Uint8Array`.
     */
    decode({ type, value }) {
        const length = (0, exports.getByteLength)(type);
        // Since we're returning a `Uint8Array`, we use `slice` to copy the bytes
        // into a new array.
        return value.slice(0, length);
    },
};

      };
    };
  }
  }
}, {package:"@metamask/abi-utils",file:"node_modules\\@metamask\\abi-utils\\dist\\parsers\\fixed-bytes.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\function.js", {"../errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\errors.js","./fixed-bytes":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\fixed-bytes.js","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cabi-utils%5Cdist%5Cparsers%5Cfunction.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fn = exports.getFunction = void 0;
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const errors_1 = require("../errors");
const fixed_bytes_1 = require("./fixed-bytes");
/**
 * A struct that represents a Solidity function. The value must be a hex string
 * or a byte array. The created value will always be an object with an `address`
 * and `selector` property.
 */
const FunctionStruct = (0, superstruct_1.coerce)((0, superstruct_1.object)({
    address: utils_1.StrictHexStruct,
    selector: utils_1.StrictHexStruct,
}), (0, superstruct_1.union)([utils_1.StrictHexStruct, (0, superstruct_1.instance)(Uint8Array)]), (value) => {
    const bytes = (0, utils_1.createBytes)(value);
    (0, utils_1.assert)(bytes.length === 24, new errors_1.ParserError(`Invalid Solidity function. Expected function to be 24 bytes long, but received ${bytes.length} bytes.`));
    return {
        address: (0, utils_1.bytesToHex)(bytes.subarray(0, 20)),
        selector: (0, utils_1.bytesToHex)(bytes.subarray(20, 24)),
    };
});
/**
 * Normalize a function. This accepts the function as:
 *
 * - A {@link SolidityFunction} object.
 * - A hexadecimal string.
 * - A byte array.
 *
 * @param input - The function-like input.
 * @returns The function as buffer.
 */
const getFunction = (input) => {
    const value = (0, superstruct_1.create)(input, FunctionStruct);
    return (0, utils_1.concatBytes)([(0, utils_1.hexToBytes)(value.address), (0, utils_1.hexToBytes)(value.selector)]);
};
exports.getFunction = getFunction;
exports.fn = {
    isDynamic: false,
    /**
     * Check if a type is a function type. Since `function` is a simple type, this
     * is just a check that the type is "function".
     *
     * @param type - The type to check.
     * @returns Whether the type is a function type.
     */
    isType: (type) => type === 'function',
    /**
     * Get the byte length of an encoded function. Since `function` is a simple
     * type, this always returns 32.
     *
     * Note that actual functions are only 24 bytes long, but the encoding of
     * the `function` type is always 32 bytes long.
     *
     * @returns The byte length of an encoded function.
     */
    getByteLength() {
        return 32;
    },
    /**
     * Encode the given function to a byte array.
     *
     * @param args - The encoding arguments.
     * @param args.buffer - The byte array to add to.
     * @param args.value - The function to encode.
     * @param args.packed - Whether to use packed encoding.
     * @param args.tight - Whether to use non-standard tight encoding.
     * @returns The bytes with the encoded function added to it.
     */
    encode({ buffer, value, packed, tight }) {
        const fnValue = (0, exports.getFunction)(value);
        // Functions are encoded as `bytes24`, so we use the fixedBytes parser to
        // encode the function.
        return fixed_bytes_1.fixedBytes.encode({
            type: 'bytes24',
            buffer,
            value: fnValue,
            packed,
            tight,
        });
    },
    /**
     * Decode the given byte array to a function.
     *
     * @param args - The decoding arguments.
     * @param args.value - The byte array to decode.
     * @returns The decoded function as a {@link SolidityFunction} object.
     */
    decode({ value }) {
        return {
            address: (0, utils_1.bytesToHex)(value.slice(0, 20)),
            selector: (0, utils_1.bytesToHex)(value.slice(20, 24)),
        };
    },
};

      };
    };
  }
  }
}, {package:"@metamask/abi-utils",file:"node_modules\\@metamask\\abi-utils\\dist\\parsers\\function.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\index.js", {"./address":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\address.js","./array":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\array.js","./bool":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\bool.js","./bytes":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\bytes.js","./fixed-bytes":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\fixed-bytes.js","./function":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\function.js","./number":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\number.js","./parser":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\parser.js","./string":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\string.js","./tuple":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\tuple.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cabi-utils%5Cdist%5Cparsers%5Cindex.js
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./address"), exports);
__exportStar(require("./array"), exports);
__exportStar(require("./bool"), exports);
__exportStar(require("./bytes"), exports);
__exportStar(require("./fixed-bytes"), exports);
__exportStar(require("./function"), exports);
__exportStar(require("./number"), exports);
__exportStar(require("./parser"), exports);
__exportStar(require("./string"), exports);
__exportStar(require("./tuple"), exports);

      };
    };
  }
  }
}, {package:"@metamask/abi-utils",file:"node_modules\\@metamask\\abi-utils\\dist\\parsers\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\number.js", {"../errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\errors.js","../utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\utils\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cabi-utils%5Cdist%5Cparsers%5Cnumber.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.number = exports.getBigInt = exports.assertNumberLength = exports.getLength = exports.isSigned = void 0;
const utils_1 = require("@metamask/utils");
const errors_1 = require("../errors");
const utils_2 = require("../utils");
const NUMBER_REGEX = /^u?int(?<length>[0-9]*)?$/u;
/**
 * Check if a number type is signed.
 *
 * @param type - The type to check.
 * @returns Whether the type is signed.
 */
const isSigned = (type) => {
    return !type.startsWith('u');
};
exports.isSigned = isSigned;
/**
 * Get the length of the specified type. If a length is not specified, if the
 * length is out of range (8 <= n <= 256), or if the length is not a multiple of
 * 8, this will throw an error.
 *
 * @param type - The type to get the length for.
 * @returns The bit length of the type.
 */
const getLength = (type) => {
    if (type === 'int' || type === 'uint') {
        return 256;
    }
    const match = type.match(NUMBER_REGEX);
    (0, utils_1.assert)(match?.groups?.length, new errors_1.ParserError(`Invalid number type. Expected a number type, but received "${type}".`));
    const length = parseInt(match.groups.length, 10);
    (0, utils_1.assert)(length >= 8 && length <= 256, new errors_1.ParserError(`Invalid number length. Expected a number between 8 and 256, but received "${type}".`));
    (0, utils_1.assert)(length % 8 === 0, new errors_1.ParserError(`Invalid number length. Expected a multiple of 8, but received "${type}".`));
    return length;
};
exports.getLength = getLength;
/**
 * Assert that the byte length of the given value is in range for the given
 * number type.
 *
 * @param value - The value to check.
 * @param type - The type of the value.
 * @throws If the value is out of range for the type.
 */
const assertNumberLength = (value, type) => {
    const length = (0, exports.getLength)(type);
    const maxValue = BigInt(2) ** BigInt(length - ((0, exports.isSigned)(type) ? 1 : 0)) - BigInt(1);
    if ((0, exports.isSigned)(type)) {
        // Signed types must be in the range of `-(2^(length - 1))` to
        // `2^(length - 1) - 1`.
        (0, utils_1.assert)(value >= -(maxValue + BigInt(1)) && value <= maxValue, new errors_1.ParserError(`Number "${value}" is out of range for type "${type}".`));
        return;
    }
    // Unsigned types must be in the range of `0` to `2^length - 1`.
    (0, utils_1.assert)(value <= maxValue, new errors_1.ParserError(`Number "${value}" is out of range for type "${type}".`));
};
exports.assertNumberLength = assertNumberLength;
/**
 * Normalize a `bigint` value. This accepts the value as:
 *
 * - A `bigint`.
 * - A `number`.
 * - A decimal string, i.e., a string that does not start with "0x".
 * - A hexadecimal string, i.e., a string that starts with "0x".
 *
 * @param value - The number-like value to parse.
 * @returns The value parsed as bigint.
 */
const getBigInt = (value) => {
    try {
        return (0, utils_1.createBigInt)(value);
    }
    catch {
        throw new errors_1.ParserError(`Invalid number. Expected a valid number value, but received "${value}".`);
    }
};
exports.getBigInt = getBigInt;
exports.number = {
    isDynamic: false,
    /**
     * Check if a type is a number type.
     *
     * @param type - The type to check.
     * @returns Whether the type is a number type.
     */
    isType(type) {
        return NUMBER_REGEX.test(type);
    },
    /**
     * Get the byte length of an encoded number type. Since `int` and `uint` are
     * simple types, this will always return 32.
     *
     * @returns The byte length of the type.
     */
    getByteLength() {
        return 32;
    },
    /**
     * Encode a number value.
     *
     * @param args - The arguments to encode.
     * @param args.type - The type of the value.
     * @param args.buffer - The byte array to add to.
     * @param args.value - The value to encode.
     * @param args.packed - Whether to use packed encoding.
     * @returns The bytes with the encoded value added to it.
     */
    encode({ type, buffer, value, packed }) {
        const bigIntValue = (0, exports.getBigInt)(value);
        (0, exports.assertNumberLength)(bigIntValue, type);
        if ((0, exports.isSigned)(type)) {
            // For packed encoding, the value is padded to the length of the type, and
            // then added to the byte array.
            if (packed) {
                const length = (0, exports.getLength)(type) / 8;
                return (0, utils_1.concatBytes)([buffer, (0, utils_1.signedBigIntToBytes)(bigIntValue, length)]);
            }
            return (0, utils_1.concatBytes)([
                buffer,
                (0, utils_2.padStart)((0, utils_1.signedBigIntToBytes)(bigIntValue, 32)),
            ]);
        }
        // For packed encoding, the value is padded to the length of the type, and
        // then added to the byte array.
        if (packed) {
            const length = (0, exports.getLength)(type) / 8;
            return (0, utils_1.concatBytes)([
                buffer,
                (0, utils_2.padStart)((0, utils_1.bigIntToBytes)(bigIntValue), length),
            ]);
        }
        return (0, utils_1.concatBytes)([buffer, (0, utils_2.padStart)((0, utils_1.bigIntToBytes)(bigIntValue))]);
    },
    /**
     * Decode a number value.
     *
     * @param args - The decoding arguments.
     * @param args.type - The type of the value.
     * @param args.value - The value to decode.
     * @returns The decoded value.
     */
    decode({ type, value }) {
        const buffer = value.subarray(0, 32);
        if ((0, exports.isSigned)(type)) {
            const numberValue = (0, utils_1.bytesToSignedBigInt)(buffer);
            (0, exports.assertNumberLength)(numberValue, type);
            return numberValue;
        }
        const numberValue = (0, utils_1.bytesToBigInt)(buffer);
        (0, exports.assertNumberLength)(numberValue, type);
        return numberValue;
    },
};

      };
    };
  }
  }
}, {package:"@metamask/abi-utils",file:"node_modules\\@metamask\\abi-utils\\dist\\parsers\\number.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\parser.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cabi-utils%5Cdist%5Cparsers%5Cparser.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });

      };
    };
  }
  }
}, {package:"@metamask/abi-utils",file:"node_modules\\@metamask\\abi-utils\\dist\\parsers\\parser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\string.js", {"./bytes":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\bytes.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cabi-utils%5Cdist%5Cparsers%5Cstring.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.string = void 0;
const utils_1 = require("@metamask/utils");
const bytes_1 = require("./bytes");
exports.string = {
    isDynamic: true,
    /**
     * Check if a type is a string type. Since `string` is a simple type, this
     * is just a check if the type is "string".
     *
     * @param type - The type to check.
     * @returns Whether the type is a string type.
     */
    isType: (type) => type === 'string',
    /**
     * Get the byte length of an encoded string type. Since `string` is a simple
     * type, this will always return 32.
     *
     * Note that actual strings are variable in length, but the encoded static
     * value (pointer) is always 32 bytes long.
     *
     * @returns The byte length of an encoded string.
     */
    getByteLength() {
        return 32;
    },
    /**
     * Encode the given string value to a byte array.
     *
     * @param args - The encoding arguments.
     * @param args.buffer - The byte array to add to.
     * @param args.value - The string value to encode.
     * @param args.packed - Whether to use packed encoding.
     * @param args.tight - Whether to use non-standard tight encoding.
     * @returns The bytes with the encoded string value added to it.
     */
    encode({ buffer, value, packed, tight }) {
        // Strings are encoded as UTF-8 bytes, so we use the bytes parser to encode
        // the string as bytes.
        return bytes_1.bytes.encode({
            type: 'bytes',
            buffer,
            value: (0, utils_1.stringToBytes)(value),
            packed,
            tight,
        });
    },
    /**
     * Decode the given byte array to a string value.
     *
     * @param args - The decoding arguments.
     * @returns The decoded string value.
     */
    decode(args) {
        // Strings are encoded as UTF-8 bytes, so we use the bytes parser to decode
        // the bytes, and convert them to a string.
        return (0, utils_1.bytesToString)(bytes_1.bytes.decode(args));
    },
};

      };
    };
  }
  }
}, {package:"@metamask/abi-utils",file:"node_modules\\@metamask\\abi-utils\\dist\\parsers\\string.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\parsers\\tuple.js", {"../errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\errors.js","../packer":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\packer.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cabi-utils%5Cdist%5Cparsers%5Ctuple.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.tuple = exports.getTupleElements = void 0;
const utils_1 = require("@metamask/utils");
const errors_1 = require("../errors");
const packer_1 = require("../packer");
const TUPLE_REGEX = /^\((.+)\)$/u;
const isTupleType = (type) => TUPLE_REGEX.test(type);
/**
 * Get elements from a tuple type.
 *
 * @param type - The tuple type to get the types for.
 * @returns The elements of the tuple as string array.
 */
const getTupleElements = (type) => {
    (0, utils_1.assert)(type.startsWith('(') && type.endsWith(')'), new errors_1.ParserError(`Invalid tuple type. Expected tuple type, but received "${type}".`));
    const elements = [];
    let current = '';
    let depth = 0;
    for (let i = 1; i < type.length - 1; i++) {
        const char = type[i];
        if (char === ',' && depth === 0) {
            elements.push(current.trim());
            current = '';
        }
        else {
            current += char;
            if (char === '(') {
                depth += 1;
            }
            else if (char === ')') {
                depth -= 1;
            }
        }
    }
    if (current.trim()) {
        elements.push(current.trim());
    }
    return elements;
};
exports.getTupleElements = getTupleElements;
exports.tuple = {
    /**
     * Check if the tuple is dynamic. Tuples are dynamic if one or more elements
     * of the tuple are dynamic.
     *
     * @param type - The type to check.
     * @returns Whether the tuple is dynamic.
     */
    isDynamic(type) {
        const elements = (0, exports.getTupleElements)(type);
        return elements.some((element) => {
            const parser = (0, packer_1.getParser)(element);
            return (0, packer_1.isDynamicParser)(parser, element);
        });
    },
    /**
     * Check if a type is a tuple type.
     *
     * @param type - The type to check.
     * @returns Whether the type is a tuple type.
     */
    isType(type) {
        return isTupleType(type);
    },
    /**
     * Get the byte length of a tuple type. If the tuple is dynamic, this will
     * always return 32. If the tuple is static, this will return the sum of the
     * byte lengths of the tuple elements.
     *
     * @param type - The type to get the byte length for.
     * @returns The byte length of the tuple type.
     */
    getByteLength(type) {
        if ((0, packer_1.isDynamicParser)(this, type)) {
            return 32;
        }
        const elements = (0, exports.getTupleElements)(type);
        return elements.reduce((total, element) => {
            return total + (0, packer_1.getParser)(element).getByteLength(element);
        }, 0);
    },
    /**
     * Encode a tuple value.
     *
     * @param args - The encoding arguments.
     * @param args.type - The type of the value.
     * @param args.buffer - The byte array to add to.
     * @param args.value - The value to encode.
     * @param args.packed - Whether to use non-standard packed encoding.
     * @param args.tight - Whether to use non-standard tight encoding.
     * @returns The bytes with the encoded value added to it.
     */
    encode({ type, buffer, value, packed, tight }) {
        const elements = (0, exports.getTupleElements)(type);
        return (0, packer_1.pack)({
            types: elements,
            values: value,
            byteArray: buffer,
            packed,
            tight,
        });
    },
    /**
     * Decode a tuple value.
     *
     * @param args - The decoding arguments.
     * @param args.type - The type of the value.
     * @param args.value - The value to decode.
     * @param args.skip - A function to skip a number of bytes.
     * @returns The decoded value.
     */
    decode({ type, value, skip }) {
        const elements = (0, exports.getTupleElements)(type);
        const length = this.getByteLength(type) - 32;
        skip(length);
        return (0, packer_1.unpack)(elements, value);
    },
};

      };
    };
  }
  }
}, {package:"@metamask/abi-utils",file:"node_modules\\@metamask\\abi-utils\\dist\\parsers\\tuple.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\types\\abi.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cabi-utils%5Cdist%5Ctypes%5Cabi.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });

      };
    };
  }
  }
}, {package:"@metamask/abi-utils",file:"node_modules\\@metamask\\abi-utils\\dist\\types\\abi.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\types\\index.js", {"./abi":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\types\\abi.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cabi-utils%5Cdist%5Ctypes%5Cindex.js
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./abi"), exports);

      };
    };
  }
  }
}, {package:"@metamask/abi-utils",file:"node_modules\\@metamask\\abi-utils\\dist\\types\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\utils\\buffer.js", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cabi-utils%5Cdist%5Cutils%5Cbuffer.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.padEnd = exports.padStart = exports.set = void 0;
const utils_1 = require("@metamask/utils");
const BUFFER_WIDTH = 32;
/**
 * Set `buffer` in `target` at the specified position.
 *
 * @param target - The buffer to set to.
 * @param buffer - The buffer to set in the target.
 * @param position - The position at which to set the target.
 * @returns The combined buffer.
 */
const set = (target, buffer, position) => {
    return (0, utils_1.concatBytes)([
        target.subarray(0, position),
        buffer,
        target.subarray(position + buffer.length),
    ]);
};
exports.set = set;
/**
 * Add padding to a buffer. If the buffer is larger than `length`, this function won't do anything. If it's smaller, the
 * buffer will be padded to the specified length, with extra zeroes at the start.
 *
 * @param buffer - The buffer to add padding to.
 * @param length - The number of bytes to pad the buffer to.
 * @returns The padded buffer.
 */
const padStart = (buffer, length = BUFFER_WIDTH) => {
    const padding = new Uint8Array(Math.max(length - buffer.length, 0)).fill(0x00);
    return (0, utils_1.concatBytes)([padding, buffer]);
};
exports.padStart = padStart;
/**
 * Add padding to a buffer. If the buffer is larger than `length`, this function won't do anything. If it's smaller, the
 * buffer will be padded to the specified length, with extra zeroes at the end.
 *
 * @param buffer - The buffer to add padding to.
 * @param length - The number of bytes to pad the buffer to.
 * @returns The padded buffer.
 */
const padEnd = (buffer, length = BUFFER_WIDTH) => {
    const padding = new Uint8Array(Math.max(length - buffer.length, 0)).fill(0x00);
    return (0, utils_1.concatBytes)([buffer, padding]);
};
exports.padEnd = padEnd;

      };
    };
  }
  }
}, {package:"@metamask/abi-utils",file:"node_modules\\@metamask\\abi-utils\\dist\\utils\\buffer.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\utils\\index.js", {"./buffer":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\utils\\buffer.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cabi-utils%5Cdist%5Cutils%5Cindex.js
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./buffer"), exports);

      };
    };
  }
  }
}, {package:"@metamask/abi-utils",file:"node_modules\\@metamask\\abi-utils\\dist\\utils\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\api\\bip44.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-api%5Cdist%5Capi%5Cbip44.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isBip44Account = isBip44Account;
exports.assertIsBip44Account = assertIsBip44Account;
/**
 * Checks if an account is BIP-44 compatible.
 *
 * @param account - The account to be tested.
 * @returns True if the account is BIP-44 compatible.
 */
function isBip44Account(account) {
    // To be BIP-44 compatible, we just check for the entropy type (the
    // the `entropy` shape will be inferred automatically).
    return account.options.entropy?.type === 'mnemonic';
}
/**
 * Asserts a keyring account is BIP-44 compatible.
 *
 * @param account - Keyring account to check.
 * @throws If the keyring account is not compatible.
 */
function assertIsBip44Account(account) {
    if (!isBip44Account(account)) {
        throw new Error('Account is not BIP-44 compatible');
    }
}

      };
    };
  }
  }
}, {package:"@metamask/account-api",file:"node_modules\\@metamask\\account-api\\dist\\api\\bip44.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\api\\group.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-api%5Cdist%5Capi%5Cgroup.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ACCOUNT_GROUP_ID_REGEX = exports.AccountGroupType = exports.DEFAULT_ACCOUNT_GROUP_UNIQUE_ID = void 0;
exports.toAccountGroupId = toAccountGroupId;
exports.toDefaultAccountGroupId = toDefaultAccountGroupId;
exports.isAccountGroupId = isAccountGroupId;
exports.parseAccountGroupId = parseAccountGroupId;
exports.stripAccountWalletId = stripAccountWalletId;
/**
 * Default account group unique ID.
 *
 * This constant can be used to reference the "default" group from
 * an account wallet.
 */
exports.DEFAULT_ACCOUNT_GROUP_UNIQUE_ID = 'default';
/**
 * Account group object.
 *
 * Each group types groups accounts using different criterias.
 */
var AccountGroupType;
(function (AccountGroupType) {
    /** Group that represents a multichain account. */
    AccountGroupType["MultichainAccount"] = "multichain-account";
    /** Group that represents a single account. */
    AccountGroupType["SingleAccount"] = "single-account";
})(AccountGroupType || (exports.AccountGroupType = AccountGroupType = {}));
/**
 * Regex to validate a valid account group ID.
 */
exports.ACCOUNT_GROUP_ID_REGEX = /^(?<walletId>(?<walletType>entropy|snap|keyring):(?<walletSubId>.+))\/(?<groupSubId>[^/]+)$/u;
/**
 * Convert a wallet ID and a unique ID, to a group ID.
 *
 * @param walletId - A wallet ID.
 * @param id - A unique ID.
 * @returns A group ID.
 */
function toAccountGroupId(walletId, id) {
    return `${walletId}/${id}`;
}
/**
 * Convert a wallet ID to the default group ID.
 *
 * @param walletId - A wallet ID.
 * @returns The default group ID.
 */
function toDefaultAccountGroupId(walletId) {
    return toAccountGroupId(walletId, exports.DEFAULT_ACCOUNT_GROUP_UNIQUE_ID);
}
/**
 * Checks if the given value is {@link AccountGroupId}.
 *
 * @param value - The value to check.
 * @returns Whether the value is a {@link AccountGroupId}.
 */
function isAccountGroupId(value) {
    return exports.ACCOUNT_GROUP_ID_REGEX.test(value);
}
/**
 * Parse a multichain account group ID to an object containing a wallet ID
 * information (wallet type and wallet sub-ID), as well as account group ID
 * information (group sub-ID).
 *
 * @param groupId - The account group ID to validate and parse.
 * @returns The parsed account group ID.
 * @throws When the group ID format is invalid.
 */
function parseAccountGroupId(groupId) {
    const match = exports.ACCOUNT_GROUP_ID_REGEX.exec(groupId);
    if (!match?.groups) {
        throw new Error(`Invalid account group ID: "${groupId}"`);
    }
    const walletId = match.groups.walletId;
    const walletType = match.groups.walletType;
    const walletSubId = match.groups.walletSubId;
    return {
        wallet: {
            id: walletId,
            type: walletType,
            subId: walletSubId,
        },
        subId: match.groups.groupSubId,
    };
}
/**
 * Strip the account wallet ID from an account group ID.
 *
 * @param groupId - Account group ID.
 * @returns Account group sub-ID.
 * @throws When the group ID format is invalid.
 */
function stripAccountWalletId(groupId) {
    return parseAccountGroupId(groupId).subId;
}

      };
    };
  }
  }
}, {package:"@metamask/account-api",file:"node_modules\\@metamask\\account-api\\dist\\api\\group.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\api\\index.cjs", {"./bip44.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\api\\bip44.cjs","./group.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\api\\group.cjs","./multichain/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\api\\multichain\\index.cjs","./selector.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\api\\selector.cjs","./wallet.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\api\\wallet.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-api%5Cdist%5Capi%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./bip44.cjs"), exports);
__exportStar(require("./group.cjs"), exports);
__exportStar(require("./wallet.cjs"), exports);
__exportStar(require("./selector.cjs"), exports);
__exportStar(require("./multichain/index.cjs"), exports);
// NOTE: Do not export the `internal` sub-path.

      };
    };
  }
  }
}, {package:"@metamask/account-api",file:"node_modules\\@metamask\\account-api\\dist\\api\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\api\\internal\\index.cjs", {"./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\api\\internal\\utils.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-api%5Cdist%5Capi%5Cinternal%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
// This folder is meant to be used internally and should not be exported.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./utils.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/account-api",file:"node_modules\\@metamask\\account-api\\dist\\api\\internal\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\api\\internal\\utils.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-api%5Cdist%5Capi%5Cinternal%5Cutils.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.areBothEmpty = areBothEmpty;
/**
 * Checks that both arrays are empty, and thus, identical.
 *
 * @param a - First array.
 * @param b - Second array.
 * @returns True if both arrays are empty, false otherwise.
 */
function areBothEmpty(a, b) {
    return a.length === 0 && b.length === 0;
}

      };
    };
  }
  }
}, {package:"@metamask/account-api",file:"node_modules\\@metamask\\account-api\\dist\\api\\internal\\utils.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\api\\multichain\\group.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-api%5Cdist%5Capi%5Cmultichain%5Cgroup.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MULTICHAIN_ACCOUNT_GROUP_ID_REGEX = void 0;
exports.toMultichainAccountGroupId = toMultichainAccountGroupId;
exports.isMultichainAccountGroupId = isMultichainAccountGroupId;
exports.parseMultichainAccountGroupId = parseMultichainAccountGroupId;
exports.getGroupIndexFromMultichainAccountGroupId = getGroupIndexFromMultichainAccountGroupId;
/**
 * Regex to validate a valid multichain account group ID.
 */
exports.MULTICHAIN_ACCOUNT_GROUP_ID_REGEX = /^(?<walletId>(?<walletType>entropy):(?<walletSubId>.+))\/(?<groupIndex>[0-9]+)$/u;
/**
 * Gets the multichain account group ID from its multichain account wallet ID and its index.
 *
 * @param walletId - Multichain account wallet ID.
 * @param groupIndex - Index of that multichain account.
 * @returns The multichain account ID.
 */
function toMultichainAccountGroupId(walletId, groupIndex) {
    return `${walletId}/${groupIndex}`;
}
/**
 * Checks if the given value is {@link MultichainAccountGroupId}.
 *
 * @param value - The value to check.
 * @returns Whether the value is a {@link MultichainAccountGroupId}.
 */
function isMultichainAccountGroupId(value) {
    return exports.MULTICHAIN_ACCOUNT_GROUP_ID_REGEX.test(value);
}
/**
 * Parse a multichain account group ID to an object containing a multichain
 * wallet ID information (wallet type and wallet sub-ID), as well as
 * multichain account group ID information (group index).
 *
 * @param groupId - The multichain account group ID to validate and parse.
 * @returns The parsed multichain account group ID.
 * @throws When the group ID format is invalid.
 */
function parseMultichainAccountGroupId(groupId) {
    const match = exports.MULTICHAIN_ACCOUNT_GROUP_ID_REGEX.exec(groupId);
    if (!match?.groups) {
        throw new Error(`Invalid multichain account group ID: "${groupId}"`);
    }
    const walletId = match.groups.walletId;
    const walletType = match.groups.walletType;
    const walletSubId = match.groups.walletSubId;
    return {
        wallet: {
            id: walletId,
            type: walletType,
            subId: walletSubId,
        },
        groupIndex: Number(match.groups.groupIndex),
    };
}
/**
 * Gets the multichain account index from an account group ID.
 *
 * @param id - Multichain account ID.
 * @returns The multichain account index if extractable, undefined otherwise.
 * @throws When the group ID format is invalid.
 */
function getGroupIndexFromMultichainAccountGroupId(id) {
    return parseMultichainAccountGroupId(id).groupIndex;
}

      };
    };
  }
  }
}, {package:"@metamask/account-api",file:"node_modules\\@metamask\\account-api\\dist\\api\\multichain\\group.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\api\\multichain\\index.cjs", {"./group.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\api\\multichain\\group.cjs","./wallet.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\api\\multichain\\wallet.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-api%5Cdist%5Capi%5Cmultichain%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./group.cjs"), exports);
__exportStar(require("./wallet.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/account-api",file:"node_modules\\@metamask\\account-api\\dist\\api\\multichain\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\api\\multichain\\wallet.cjs", {"../wallet.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\api\\wallet.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-api%5Cdist%5Capi%5Cmultichain%5Cwallet.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MULTICHAIN_ACCOUNT_WALLET_ID_REGEX = void 0;
exports.toMultichainAccountWalletId = toMultichainAccountWalletId;
exports.isMultichainAccountWalletId = isMultichainAccountWalletId;
exports.parseMultichainAccountWalletId = parseMultichainAccountWalletId;
const wallet_1 = require("../wallet.cjs");
/**
 * Regex to validate a valid multichain account wallet ID.
 */
exports.MULTICHAIN_ACCOUNT_WALLET_ID_REGEX = /^(?<walletId>(?<walletType>entropy):(?<walletSubId>.+))$/u;
/**
 * Gets the multichain account wallet ID from its entropy source.
 *
 * @param entropySource - Entropy source ID of that wallet.
 * @returns The multichain account wallet ID.
 */
function toMultichainAccountWalletId(entropySource) {
    return `${wallet_1.AccountWalletType.Entropy}:${entropySource}`;
}
/**
 * Checks if the given value is {@link MultichainAccountWalletId}.
 *
 * @param value - The value to check.
 * @returns Whether the value is a {@link MultichainAccountWalletId}.
 */
function isMultichainAccountWalletId(value) {
    return exports.MULTICHAIN_ACCOUNT_WALLET_ID_REGEX.test(value);
}
/**
 * Parse a multichain account wallet ID to an object containing wallet ID
 * information (wallet type and sub-ID).
 *
 * @param walletId - The account wallet ID to validate and parse.
 * @returns The parsed account wallet ID.
 * @throws When the wallet ID format is invalid.
 */
function parseMultichainAccountWalletId(walletId) {
    const match = exports.MULTICHAIN_ACCOUNT_WALLET_ID_REGEX.exec(walletId);
    if (!match?.groups) {
        throw new Error(`Invalid multichain account wallet ID: "${walletId}"`);
    }
    return {
        type: match.groups.walletType,
        subId: match.groups.walletSubId,
    };
}

      };
    };
  }
  }
}, {package:"@metamask/account-api",file:"node_modules\\@metamask\\account-api\\dist\\api\\multichain\\wallet.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\api\\selector.cjs", {"./internal/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\api\\internal\\index.cjs","@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-api%5Cdist%5Capi%5Cselector.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.selectOne = selectOne;
exports.select = select;
const keyring_utils_1 = require("@metamask/keyring-utils");
const internal_1 = require("./internal/index.cjs");
/**
 * Query an account matching the selector.
 *
 * @param accounts - List of accounts to select from.
 * @param selector - Query selector.
 * @returns The account matching the selector or undefined if not matching.
 * @throws If multiple accounts match the selector.
 */
function selectOne(accounts, selector) {
    const matched = select(accounts, selector);
    if (matched.length > 1) {
        throw new Error(`Too many account candidates, expected 1, got: ${matched.length}`);
    }
    if (matched.length === 0) {
        return undefined;
    }
    return matched[0]; // This is safe, see checks above.
}
/**
 * Query accounts matching the selector.
 *
 * @param accounts - List of accounts to select from.
 * @param selector - Query selector.
 * @returns The accounts matching the selector.
 */
function select(accounts, selector) {
    return accounts.filter((account) => {
        let selected = true;
        if (selector.id) {
            selected && (selected = account.id === selector.id);
        }
        if (selector.address) {
            selected && (selected = account.address === selector.address);
        }
        if (selector.type) {
            selected && (selected = account.type === selector.type);
        }
        if (selector.methods !== undefined) {
            selected && (selected = (0, internal_1.areBothEmpty)(selector.methods, account.methods) ||
                selector.methods.some((method) => account.methods.includes(method)));
        }
        if (selector.scopes !== undefined) {
            selected && (selected = (0, internal_1.areBothEmpty)(selector.scopes, account.scopes) ||
                selector.scopes.some((scope) => {
                    return (
                    // This will cover specific EVM EOA scopes as well.
                    (0, keyring_utils_1.isScopeEqualToAny)(scope, account.scopes));
                }));
        }
        return selected;
    });
}

      };
    };
  }
  }
}, {package:"@metamask/account-api",file:"node_modules\\@metamask\\account-api\\dist\\api\\selector.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\api\\wallet.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-api%5Cdist%5Capi%5Cwallet.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ACCOUNT_WALLET_ID_REGEX = exports.AccountWalletType = void 0;
exports.toAccountWalletId = toAccountWalletId;
exports.isAccountWalletId = isAccountWalletId;
exports.parseAccountWalletId = parseAccountWalletId;
exports.stripAccountWalletType = stripAccountWalletType;
/**
 * Wallet type.
 *
 * Each wallet types groups accounts using different criterias.
 */
var AccountWalletType;
(function (AccountWalletType) {
    /** Wallet grouping accounts based on their entropy source. */
    AccountWalletType["Entropy"] = "entropy";
    /** Wallet grouping accounts based on their keyring's type. */
    AccountWalletType["Keyring"] = "keyring";
    /** Wallet grouping accounts associated with an account management Snap. */
    AccountWalletType["Snap"] = "snap";
})(AccountWalletType || (exports.AccountWalletType = AccountWalletType = {}));
/**
 * Regex to validate an account wallet ID.
 */
exports.ACCOUNT_WALLET_ID_REGEX = /^(?<walletType>entropy|keyring|snap):(?<walletSubId>.+)$/u;
/**
 * Convert a unique ID to a wallet ID for a given type.
 *
 * @param type - A wallet type.
 * @param id - A unique ID.
 * @returns A wallet ID.
 */
function toAccountWalletId(type, id) {
    return `${type}:${id}`;
}
/**
 * Checks if the given value is {@link AccountWalletId}.
 *
 * @param value - The value to check.
 * @returns Whether the value is a {@link AccountWalletId}.
 */
function isAccountWalletId(value) {
    return exports.ACCOUNT_WALLET_ID_REGEX.test(value);
}
/**
 * Parse an account wallet ID to an object containing a wallet ID information
 * (wallet type and wallet sub-ID).
 *
 * @param walletId - The account wallet ID to validate and parse.
 * @returns The parsed account wallet ID.
 * @throws When the wallet ID format is invalid.
 */
function parseAccountWalletId(walletId) {
    const match = exports.ACCOUNT_WALLET_ID_REGEX.exec(walletId);
    if (!match?.groups) {
        throw new Error(`Invalid account wallet ID: "${walletId}"`);
    }
    return {
        type: match.groups.walletType,
        subId: match.groups.walletSubId,
    };
}
/**
 * Strip the account wallet type from an account wallet ID.
 *
 * @param walletId - Account wallet ID.
 * @returns Account wallet sub-ID.
 * @throws When the wallet ID format is invalid.
 */
function stripAccountWalletType(walletId) {
    return parseAccountWalletId(walletId).subId;
}

      };
    };
  }
  }
}, {package:"@metamask/account-api",file:"node_modules\\@metamask\\account-api\\dist\\api\\wallet.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\index.cjs", {"./api/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\api\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-api%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./api/index.cjs"), exports);
// NOTE: We do not export the mocks utilities as part of the public API, but they
// are still available through `@metamask/account-api/mocks`.

      };
    };
  }
  }
}, {package:"@metamask/account-api",file:"node_modules\\@metamask\\account-api\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\AccountTreeController.cjs", {"./backup-and-sync/analytics/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\analytics\\index.cjs","./backup-and-sync/service/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\service\\index.cjs","./group.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\group.cjs","./logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\logger.cjs","./rules/entropy.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\rules\\entropy.cjs","./rules/keyring.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\rules\\keyring.cjs","./rules/snap.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\rules\\snap.cjs","@metamask/account-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\index.cjs","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5CAccountTreeController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _AccountTreeController_instances, _AccountTreeController_accountIdToContext, _AccountTreeController_groupIdToWalletId, _AccountTreeController_backupAndSyncService, _AccountTreeController_rules, _AccountTreeController_trace, _AccountTreeController_backupAndSyncConfig, _AccountTreeController_accountOrderCallbacks, _AccountTreeController_initialized, _AccountTreeController_getEntropyRule, _AccountTreeController_getSnapRule, _AccountTreeController_getKeyringRule, _AccountTreeController_applyAccountWalletMetadata, _AccountTreeController_getRuleForWallet, _AccountTreeController_getComputedAccountGroupName, _AccountTreeController_getDefaultAccountGroupName, _AccountTreeController_applyAccountGroupMetadata, _AccountTreeController_handleAccountAdded, _AccountTreeController_handleAccountRemoved, _AccountTreeController_pruneEmptyGroupAndWallet, _AccountTreeController_insert, _AccountTreeController_listAccounts, _AccountTreeController_assertAccountGroupExists, _AccountTreeController_assertAccountWalletExists, _AccountTreeController_assertAccountGroupNameIsUnique, _AccountTreeController_getDefaultSelectedAccountGroup, _AccountTreeController_handleSelectedAccountChange, _AccountTreeController_handleMultichainAccountWalletStatusChange, _AccountTreeController_getAccountGroup, _AccountTreeController_getDefaultAccountFromAccountGroupId, _AccountTreeController_getDefaultAccountGroupId, _AccountTreeController_registerMessageHandlers, _AccountTreeController_createBackupAndSyncContext;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccountTreeController = exports.getDefaultAccountTreeControllerState = exports.controllerName = void 0;
const account_api_1 = require("@metamask/account-api");
const base_controller_1 = require("@metamask/base-controller");
const keyring_api_1 = require("@metamask/keyring-api");
const utils_1 = require("@metamask/utils");
const analytics_1 = require("./backup-and-sync/analytics/index.cjs");
const service_1 = require("./backup-and-sync/service/index.cjs");
const group_1 = require("./group.cjs");
const logger_1 = require("./logger.cjs");
const entropy_1 = require("./rules/entropy.cjs");
const keyring_1 = require("./rules/keyring.cjs");
const snap_1 = require("./rules/snap.cjs");
exports.controllerName = 'AccountTreeController';
const accountTreeControllerMetadata = {
    accountTree: {
        includeInStateLogs: true,
        persist: false,
        anonymous: false,
        usedInUi: true,
    },
    isAccountTreeSyncingInProgress: {
        includeInStateLogs: false,
        persist: false,
        anonymous: false,
        usedInUi: true,
    },
    hasAccountTreeSyncingSyncedAtLeastOnce: {
        includeInStateLogs: true,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
    accountGroupsMetadata: {
        includeInStateLogs: true,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
    accountWalletsMetadata: {
        includeInStateLogs: true,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
};
/**
 * Gets default state of the `AccountTreeController`.
 *
 * @returns The default state of the `AccountTreeController`.
 */
function getDefaultAccountTreeControllerState() {
    return {
        accountTree: {
            wallets: {},
            selectedAccountGroup: '',
        },
        isAccountTreeSyncingInProgress: false,
        hasAccountTreeSyncingSyncedAtLeastOnce: false,
        accountGroupsMetadata: {},
        accountWalletsMetadata: {},
    };
}
exports.getDefaultAccountTreeControllerState = getDefaultAccountTreeControllerState;
class AccountTreeController extends base_controller_1.BaseController {
    /**
     * Constructor for AccountTreeController.
     *
     * @param options - The controller options.
     * @param options.messenger - The messenger object.
     * @param options.state - Initial state to set on this controller
     * @param options.config - Optional configuration for the controller.
     */
    constructor({ messenger, state, config, }) {
        super({
            messenger,
            name: exports.controllerName,
            metadata: accountTreeControllerMetadata,
            state: {
                ...getDefaultAccountTreeControllerState(),
                ...state,
            },
        });
        _AccountTreeController_instances.add(this);
        _AccountTreeController_accountIdToContext.set(this, void 0);
        _AccountTreeController_groupIdToWalletId.set(this, void 0);
        /**
         * Service responsible for all backup and sync operations.
         */
        _AccountTreeController_backupAndSyncService.set(this, void 0);
        _AccountTreeController_rules.set(this, void 0);
        _AccountTreeController_trace.set(this, void 0);
        _AccountTreeController_backupAndSyncConfig.set(this, void 0);
        /**
         * Callbacks to migrate hidden and pinned account information from the account order controller
         */
        _AccountTreeController_accountOrderCallbacks.set(this, void 0);
        _AccountTreeController_initialized.set(this, void 0);
        // This will be set to true upon the first `init` call.
        __classPrivateFieldSet(this, _AccountTreeController_initialized, false, "f");
        // Reverse map to allow fast node access from an account ID.
        __classPrivateFieldSet(this, _AccountTreeController_accountIdToContext, new Map(), "f");
        // Reverse map to allow fast wallet node access from a group ID.
        __classPrivateFieldSet(this, _AccountTreeController_groupIdToWalletId, new Map(), "f");
        // Rules to apply to construct the wallets tree.
        __classPrivateFieldSet(this, _AccountTreeController_rules, [
            // 1. We group by entropy-source
            new entropy_1.EntropyRule(this.messagingSystem),
            // 2. We group by Snap ID
            new snap_1.SnapRule(this.messagingSystem),
            // 3. We group by wallet type (this rule cannot fail and will group all non-matching accounts)
            new keyring_1.KeyringRule(this.messagingSystem),
        ], "f");
        // Initialize trace function
        __classPrivateFieldSet(this, _AccountTreeController_trace, config?.trace ?? analytics_1.traceFallback, "f");
        // Initialize backup and sync config
        __classPrivateFieldSet(this, _AccountTreeController_backupAndSyncConfig, {
            emitAnalyticsEventFn: (event) => {
                return (config?.backupAndSync?.onBackupAndSyncEvent &&
                    config.backupAndSync.onBackupAndSyncEvent((0, analytics_1.formatAnalyticsEvent)(event)));
            },
        }, "f");
        // Used when migrating initial hidden/pinned state for groups (if available).
        __classPrivateFieldSet(this, _AccountTreeController_accountOrderCallbacks, config?.accountOrderCallbacks, "f");
        // Initialize the backup and sync service
        __classPrivateFieldSet(this, _AccountTreeController_backupAndSyncService, new service_1.BackupAndSyncService(__classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_createBackupAndSyncContext).call(this)), "f");
        this.messagingSystem.subscribe('AccountsController:accountAdded', (account) => {
            __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_handleAccountAdded).call(this, account);
        });
        this.messagingSystem.subscribe('AccountsController:accountRemoved', (accountId) => {
            __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_handleAccountRemoved).call(this, accountId);
        });
        this.messagingSystem.subscribe('AccountsController:selectedAccountChange', (account) => {
            __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_handleSelectedAccountChange).call(this, account);
        });
        this.messagingSystem.subscribe('UserStorageController:stateChange', (userStorageControllerState) => {
            __classPrivateFieldGet(this, _AccountTreeController_backupAndSyncService, "f").handleUserStorageStateChange(userStorageControllerState);
        });
        this.messagingSystem.subscribe('MultichainAccountService:walletStatusChange', (walletId, status) => {
            __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_handleMultichainAccountWalletStatusChange).call(this, walletId, status);
        });
        __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_registerMessageHandlers).call(this);
    }
    /**
     * Initialize the controller's state.
     *
     * It constructs the initial state of the account tree (tree nodes, nodes
     * names, metadata, etc..) and will automatically update the controller's
     * state with it.
     */
    init() {
        if (__classPrivateFieldGet(this, _AccountTreeController_initialized, "f")) {
            // We prevent re-initilializing the state multiple times. Though, we can use
            // `reinit` to re-init everything from scratch.
            return;
        }
        (0, logger_1.projectLogger)('Initializing...');
        const wallets = {};
        // Clear mappings for fresh rebuild.
        __classPrivateFieldGet(this, _AccountTreeController_accountIdToContext, "f").clear();
        __classPrivateFieldGet(this, _AccountTreeController_groupIdToWalletId, "f").clear();
        // Keep the current selected group to check if it's still part of the tree
        // after rebuilding it.
        const previousSelectedAccountGroup = this.state.accountTree.selectedAccountGroup;
        // There's no guarantee that accounts would be sorted by their import time
        // with `listMultichainAccounts`. We have to sort them here before constructing
        // the tree.
        //
        // Because of the alignment mecanism, some accounts from the same group might not
        // have been imported at the same time, but at least of them should have been
        // imported at the right time, thus, inserting the group at the proper place too.
        //
        // Lastly, if one day we allow to have "gaps" in between groups, then this `sort`
        // won't be enough and we would have to use group properties instead (like group
        // index or maybe introduce a `importTime` at group level).
        const accounts = __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_listAccounts).call(this).sort((a, b) => a.metadata.importTime - b.metadata.importTime);
        // For now, we always re-compute all wallets, we do not re-use the existing state.
        for (const account of accounts) {
            __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_insert).call(this, wallets, account);
        }
        // Once we have the account tree, we can apply persisted metadata (names + UI states).
        let previousSelectedAccountGroupStillExists = false;
        this.update((state) => {
            state.accountTree.wallets = wallets;
            // Apply group metadata within the state update
            for (const wallet of Object.values(state.accountTree.wallets)) {
                __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_applyAccountWalletMetadata).call(this, state, wallet.id);
                // Used for default group default names (so we use human-indexing here).
                let nextNaturalNameIndex = 1;
                for (const group of Object.values(wallet.groups)) {
                    __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_applyAccountGroupMetadata).call(this, state, wallet.id, group.id, {
                        // We allow computed name when initializing the tree.
                        // This will automatically handle account name migration for the very first init of the
                        // tree. Once groups are created, their name will be persisted, thus, taking precedence
                        // over the computed names (even if we re-init).
                        allowComputedName: true,
                        // FIXME: We should not need this kind of logic if we were not inserting accounts
                        // 1 by 1. Instead, we should be inserting wallets and groups directly. This would
                        // allow us to naturally insert a group in the tree AND update its metadata right
                        // away...
                        // But here, we have to wait for the entire group to be ready before updating
                        // its metadata (mainly because we're dealing with single accounts rather than entire
                        // groups).
                        // That is why we need this kind of extra parameter.
                        nextNaturalNameIndex,
                    });
                    if (group.id === previousSelectedAccountGroup) {
                        previousSelectedAccountGroupStillExists = true;
                    }
                    nextNaturalNameIndex += 1;
                }
            }
            if (!previousSelectedAccountGroupStillExists ||
                previousSelectedAccountGroup === '') {
                // No group is selected yet OR group no longer exists, re-sync with the
                // AccountsController.
                state.accountTree.selectedAccountGroup =
                    __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_getDefaultSelectedAccountGroup).call(this, wallets);
            }
        });
        // We still compare the previous and new value, the previous one could have been
        // an empty string and `#getDefaultSelectedAccountGroup` could also return an
        // empty string too, thus, we would re-use the same value here again. In that
        // case, no need to fire any event.
        if (previousSelectedAccountGroup !==
            this.state.accountTree.selectedAccountGroup) {
            (0, logger_1.projectLogger)(`Selected (initial) group is: [${this.state.accountTree.selectedAccountGroup}]`);
            this.messagingSystem.publish(`${exports.controllerName}:selectedAccountGroupChange`, this.state.accountTree.selectedAccountGroup, previousSelectedAccountGroup);
        }
        (0, logger_1.projectLogger)('Initialized!');
        __classPrivateFieldSet(this, _AccountTreeController_initialized, true, "f");
    }
    /**
     * Re-initialize the controller's state.
     *
     * This is done in one single (atomic) `update` block to avoid having a temporary
     * cleared state. Use this when you need to force a full re-init even if already initialized.
     */
    reinit() {
        (0, logger_1.projectLogger)('Re-initializing...');
        __classPrivateFieldSet(this, _AccountTreeController_initialized, false, "f");
        this.init();
    }
    /**
     * Gets the account wallet object from its ID.
     *
     * @param walletId - Account wallet ID.
     * @returns The account wallet object if found, undefined otherwise.
     */
    getAccountWalletObject(walletId) {
        const wallet = this.state.accountTree.wallets[walletId];
        if (!wallet) {
            return undefined;
        }
        return wallet;
    }
    /**
     * Gets all account wallet objects.
     *
     * @returns All account wallet objects.
     */
    getAccountWalletObjects() {
        return Object.values(this.state.accountTree.wallets);
    }
    /**
     * Gets all underlying accounts from the currently selected account
     * group.
     *
     * It also support account selector, which allows to filter specific
     * accounts given some criterias (account type, address, scopes, etc...).
     *
     * @param selector - Optional account selector.
     * @returns Underlying accounts for the currently selected account (filtered
     * by the selector if provided).
     */
    getAccountsFromSelectedAccountGroup(selector) {
        const groupId = this.getSelectedAccountGroup();
        if (!groupId) {
            return [];
        }
        const group = this.getAccountGroupObject(groupId);
        // We should never reach this part, so we cannot cover it either.
        /* istanbul ignore next */
        if (!group) {
            return [];
        }
        const accounts = [];
        for (const id of group.accounts) {
            const account = this.messagingSystem.call('AccountsController:getAccount', id);
            // For now, we're filtering undefined account, but I believe
            // throwing would be more appropriate here.
            if (account) {
                accounts.push(account);
            }
        }
        return selector ? (0, account_api_1.select)(accounts, selector) : accounts;
    }
    /**
     * Gets the account group object from its ID.
     *
     * @param groupId - Account group ID.
     * @returns The account group object if found, undefined otherwise.
     */
    getAccountGroupObject(groupId) {
        const walletId = __classPrivateFieldGet(this, _AccountTreeController_groupIdToWalletId, "f").get(groupId);
        if (!walletId) {
            return undefined;
        }
        const wallet = this.getAccountWalletObject(walletId);
        return wallet?.groups[groupId];
    }
    /**
     * Gets the currently selected account group ID.
     *
     * @returns The selected account group ID or empty string if none selected.
     */
    getSelectedAccountGroup() {
        return this.state.accountTree.selectedAccountGroup;
    }
    /**
     * Sets the selected account group and updates the AccountsController selectedAccount accordingly.
     *
     * @param groupId - The account group ID to select.
     */
    setSelectedAccountGroup(groupId) {
        const previousSelectedAccountGroup = this.state.accountTree.selectedAccountGroup;
        // Idempotent check - if the same group is already selected, do nothing
        if (previousSelectedAccountGroup === groupId) {
            return;
        }
        // Find the first account in this group to select
        const accountToSelect = __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_getDefaultAccountFromAccountGroupId).call(this, groupId);
        if (!accountToSelect) {
            throw new Error(`No accounts found in group: ${groupId}`);
        }
        // Update our state first
        this.update((state) => {
            state.accountTree.selectedAccountGroup = groupId;
        });
        (0, logger_1.projectLogger)(`Selected group is now: [${this.state.accountTree.selectedAccountGroup}]`);
        this.messagingSystem.publish(`${exports.controllerName}:selectedAccountGroupChange`, groupId, previousSelectedAccountGroup);
        // Update AccountsController - this will trigger selectedAccountChange event,
        // but our handler is idempotent so it won't cause infinite loop
        this.messagingSystem.call('AccountsController:setSelectedAccount', accountToSelect);
    }
    /**
     * Resolves name conflicts by adding a suffix to make the name unique.
     *
     * @internal
     * @param wallet - The wallet to check within.
     * @param groupId - The account group ID to exclude from the check.
     * @param name - The desired name that has a conflict.
     * @returns A unique name with suffix added if necessary.
     */
    resolveNameConflict(wallet, groupId, name) {
        let suffix = 2;
        let candidateName = `${name} (${suffix})`;
        // Keep incrementing suffix until we find a unique name
        while (!(0, group_1.isAccountGroupNameUniqueFromWallet)(wallet, groupId, candidateName)) {
            suffix += 1;
            candidateName = `${name} (${suffix})`;
        }
        return candidateName;
    }
    /**
     * Sets a custom name for an account group.
     *
     * @param groupId - The account group ID.
     * @param name - The custom name to set.
     * @param autoHandleConflict - If true, automatically resolves name conflicts by adding a suffix. If false, throws on conflicts.
     * @throws If the account group ID is not found in the current tree.
     * @throws If the account group name already exists and autoHandleConflict is false.
     */
    setAccountGroupName(groupId, name, autoHandleConflict = false) {
        // Validate that the group exists in the current tree
        __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_assertAccountGroupExists).call(this, groupId);
        const walletId = __classPrivateFieldGet(this, _AccountTreeController_groupIdToWalletId, "f").get(groupId);
        (0, utils_1.assert)(walletId, `Account group with ID "${groupId}" not found in tree`);
        const wallet = this.state.accountTree.wallets[walletId];
        let finalName = name;
        // Handle name conflicts based on the autoHandleConflict flag
        if (autoHandleConflict &&
            !(0, group_1.isAccountGroupNameUniqueFromWallet)(wallet, groupId, name)) {
            finalName = this.resolveNameConflict(wallet, groupId, name);
        }
        else {
            // Validate that the name is unique
            __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_assertAccountGroupNameIsUnique).call(this, groupId, finalName);
        }
        (0, logger_1.projectLogger)(`[${groupId}] Set new name to: "${finalName}" (auto handle conflict: ${autoHandleConflict})`);
        this.update((state) => {
            /* istanbul ignore next */
            if (!state.accountGroupsMetadata[groupId]) {
                state.accountGroupsMetadata[groupId] = {};
            }
            // Update persistent metadata
            state.accountGroupsMetadata[groupId].name = {
                value: finalName,
                lastUpdatedAt: Date.now(),
            };
            // Update tree node directly using efficient mapping
            state.accountTree.wallets[walletId].groups[groupId].metadata.name =
                finalName;
        });
        // Trigger atomic sync for group rename (only for groups from entropy wallets)
        if (wallet.type === account_api_1.AccountWalletType.Entropy) {
            __classPrivateFieldGet(this, _AccountTreeController_backupAndSyncService, "f").enqueueSingleGroupSync(groupId);
        }
    }
    /**
     * Sets a custom name for an account wallet.
     *
     * @param walletId - The account wallet ID.
     * @param name - The custom name to set.
     * @throws If the account wallet ID is not found in the current tree.
     */
    setAccountWalletName(walletId, name) {
        // Validate that the wallet exists in the current tree
        __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_assertAccountWalletExists).call(this, walletId);
        this.update((state) => {
            var _a;
            // Update persistent metadata
            (_a = state.accountWalletsMetadata)[walletId] ?? (_a[walletId] = {});
            state.accountWalletsMetadata[walletId].name = {
                value: name,
                lastUpdatedAt: Date.now(),
            };
            // Update tree node directly
            state.accountTree.wallets[walletId].metadata.name = name;
        });
        // Trigger atomic sync for wallet rename (only for groups from entropy wallets)
        if (this.state.accountTree.wallets[walletId].type ===
            account_api_1.AccountWalletType.Entropy) {
            __classPrivateFieldGet(this, _AccountTreeController_backupAndSyncService, "f").enqueueSingleWalletSync(walletId);
        }
    }
    /**
     * Toggles the pinned state of an account group.
     *
     * @param groupId - The account group ID.
     * @param pinned - Whether the group should be pinned.
     * @throws If the account group ID is not found in the current tree.
     */
    setAccountGroupPinned(groupId, pinned) {
        // Validate that the group exists in the current tree
        __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_assertAccountGroupExists).call(this, groupId);
        const walletId = __classPrivateFieldGet(this, _AccountTreeController_groupIdToWalletId, "f").get(groupId);
        this.update((state) => {
            /* istanbul ignore next */
            if (!state.accountGroupsMetadata[groupId]) {
                state.accountGroupsMetadata[groupId] = {};
            }
            // Update persistent metadata
            state.accountGroupsMetadata[groupId].pinned = {
                value: pinned,
                lastUpdatedAt: Date.now(),
            };
            // Update tree node directly using efficient mapping
            if (walletId) {
                state.accountTree.wallets[walletId].groups[groupId].metadata.pinned =
                    pinned;
            }
        });
        // Trigger atomic sync for group pinning (only for groups from entropy wallets)
        if (walletId &&
            this.state.accountTree.wallets[walletId].type ===
                account_api_1.AccountWalletType.Entropy) {
            __classPrivateFieldGet(this, _AccountTreeController_backupAndSyncService, "f").enqueueSingleGroupSync(groupId);
        }
    }
    /**
     * Toggles the hidden state of an account group.
     *
     * @param groupId - The account group ID.
     * @param hidden - Whether the group should be hidden.
     * @throws If the account group ID is not found in the current tree.
     */
    setAccountGroupHidden(groupId, hidden) {
        // Validate that the group exists in the current tree
        __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_assertAccountGroupExists).call(this, groupId);
        const walletId = __classPrivateFieldGet(this, _AccountTreeController_groupIdToWalletId, "f").get(groupId);
        this.update((state) => {
            /* istanbul ignore next */
            if (!state.accountGroupsMetadata[groupId]) {
                state.accountGroupsMetadata[groupId] = {};
            }
            // Update persistent metadata
            state.accountGroupsMetadata[groupId].hidden = {
                value: hidden,
                lastUpdatedAt: Date.now(),
            };
            // Update tree node directly using efficient mapping
            if (walletId) {
                state.accountTree.wallets[walletId].groups[groupId].metadata.hidden =
                    hidden;
            }
        });
        // Trigger atomic sync for group hiding (only for groups from entropy wallets)
        if (walletId &&
            this.state.accountTree.wallets[walletId].type ===
                account_api_1.AccountWalletType.Entropy) {
            __classPrivateFieldGet(this, _AccountTreeController_backupAndSyncService, "f").enqueueSingleGroupSync(groupId);
        }
    }
    /**
     * Clears the controller state and resets to default values.
     * Also clears the backup and sync service state.
     */
    clearState() {
        (0, logger_1.projectLogger)('Clearing state');
        this.update(() => {
            return {
                ...getDefaultAccountTreeControllerState(),
            };
        });
        __classPrivateFieldGet(this, _AccountTreeController_backupAndSyncService, "f").clearState();
        // So we know we have to call `init` again.
        __classPrivateFieldSet(this, _AccountTreeController_initialized, false, "f");
    }
    /**
     * Bi-directionally syncs the account tree with user storage.
     * This will perform a full sync, including both pulling updates
     * from user storage and pushing local changes to user storage.
     * This also performs legacy account syncing if needed.
     *
     * IMPORTANT:
     * If a full sync is already in progress, it will return the ongoing promise.
     *
     * @returns A promise that resolves when the sync is complete.
     */
    async syncWithUserStorage() {
        return __classPrivateFieldGet(this, _AccountTreeController_backupAndSyncService, "f").performFullSync();
    }
    /**
     * Bi-directionally syncs the account tree with user storage.
     * This will ensure at least one full sync is ran, including both pulling updates
     * from user storage and pushing local changes to user storage.
     * This also performs legacy account syncing if needed.
     *
     * IMPORTANT:
     * If the first ever full sync is already in progress, it will return the ongoing promise.
     * If the first ever full sync was previously completed, it will NOT start a new sync, and will resolve immediately.
     *
     * @returns A promise that resolves when the first ever full sync is complete.
     */
    async syncWithUserStorageAtLeastOnce() {
        return __classPrivateFieldGet(this, _AccountTreeController_backupAndSyncService, "f").performFullSyncAtLeastOnce();
    }
}
exports.AccountTreeController = AccountTreeController;
_AccountTreeController_accountIdToContext = new WeakMap(), _AccountTreeController_groupIdToWalletId = new WeakMap(), _AccountTreeController_backupAndSyncService = new WeakMap(), _AccountTreeController_rules = new WeakMap(), _AccountTreeController_trace = new WeakMap(), _AccountTreeController_backupAndSyncConfig = new WeakMap(), _AccountTreeController_accountOrderCallbacks = new WeakMap(), _AccountTreeController_initialized = new WeakMap(), _AccountTreeController_instances = new WeakSet(), _AccountTreeController_getEntropyRule = function _AccountTreeController_getEntropyRule() {
    return __classPrivateFieldGet(this, _AccountTreeController_rules, "f")[0];
}, _AccountTreeController_getSnapRule = function _AccountTreeController_getSnapRule() {
    return __classPrivateFieldGet(this, _AccountTreeController_rules, "f")[1];
}, _AccountTreeController_getKeyringRule = function _AccountTreeController_getKeyringRule() {
    return __classPrivateFieldGet(this, _AccountTreeController_rules, "f")[2];
}, _AccountTreeController_applyAccountWalletMetadata = function _AccountTreeController_applyAccountWalletMetadata(state, walletId) {
    const wallet = state.accountTree.wallets[walletId];
    const persistedMetadata = state.accountWalletsMetadata[walletId];
    // Apply persisted name if available (including empty strings)
    if (persistedMetadata?.name !== undefined) {
        wallet.metadata.name = persistedMetadata.name.value;
    }
    else if (!wallet.metadata.name) {
        // Generate default name if none exists
        if (wallet.type === account_api_1.AccountWalletType.Entropy) {
            wallet.metadata.name =
                __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_getEntropyRule).call(this).getDefaultAccountWalletName(wallet);
        }
        else if (wallet.type === account_api_1.AccountWalletType.Snap) {
            wallet.metadata.name =
                __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_getSnapRule).call(this).getDefaultAccountWalletName(wallet);
        }
        else {
            wallet.metadata.name =
                __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_getKeyringRule).call(this).getDefaultAccountWalletName(wallet);
        }
        (0, logger_1.projectLogger)(`[${wallet.id}] Set default name to: "${wallet.metadata.name}"`);
    }
}, _AccountTreeController_getRuleForWallet = function _AccountTreeController_getRuleForWallet(wallet) {
    switch (wallet.type) {
        case account_api_1.AccountWalletType.Entropy:
            return __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_getEntropyRule).call(this);
        case account_api_1.AccountWalletType.Snap:
            return __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_getSnapRule).call(this);
        default:
            return __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_getKeyringRule).call(this);
    }
}, _AccountTreeController_getComputedAccountGroupName = function _AccountTreeController_getComputedAccountGroupName(wallet, group) {
    let proposedName = ''; // Empty means there's no computed name for this group.
    for (const id of group.accounts) {
        const account = this.messagingSystem.call('AccountsController:getAccount', id);
        if (!account || !account.metadata.name.length) {
            continue;
        }
        // We only pick a new proposed name if we don't have one yet.
        if (!proposedName) {
            proposedName = account.metadata.name;
        }
        // But EVM accounts take precedence over any other computed names.
        if ((0, keyring_api_1.isEvmAccountType)(account.type)) {
            // So we just overwrite the proposed name and stop looping right away.
            proposedName = account.metadata.name;
            break;
        }
    }
    // If this name already exists for whatever reason, we rename it to resolve this conflict.
    if (proposedName.length &&
        !(0, group_1.isAccountGroupNameUniqueFromWallet)(wallet, group.id, proposedName)) {
        proposedName = this.resolveNameConflict(wallet, group.id, proposedName);
    }
    return proposedName;
}, _AccountTreeController_getDefaultAccountGroupName = function _AccountTreeController_getDefaultAccountGroupName(state, wallet, group, nextNaturalNameIndex) {
    // Get the appropriate rule for this wallet type
    const rule = __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_getRuleForWallet).call(this, wallet);
    // Get the prefix for groups of this wallet
    const namePrefix = rule.getDefaultAccountGroupPrefix(wallet);
    // Parse the highest account index being used (similar to accounts-controller)
    let highestNameIndex = 0;
    for (const { id: otherGroupId } of Object.values(wallet.groups)) {
        // Skip the current group being processed
        if (otherGroupId === group.id) {
            continue;
        }
        // We always get the name from the persisted map, since `init` will clear the
        // `state.accountTree.wallets`, thus, given empty `group.metadata.name`.
        // NOTE: If the other group has not been named yet, we just use an empty name.
        const otherGroupName = state.accountGroupsMetadata[otherGroupId]?.name?.value ?? '';
        // Parse the existing group name to extract the numeric index
        const nameMatch = otherGroupName.match(/account\s+(\d+)$/iu);
        if (nameMatch) {
            const nameIndex = parseInt(nameMatch[1], 10);
            if (nameIndex > highestNameIndex) {
                highestNameIndex = nameIndex;
            }
        }
    }
    // We just use the highest known index no matter the wallet type.
    //
    // For entropy-based wallets (bip44), if a multichain account group with group index 1
    // is inserted before another one with group index 0, then the naming will be:
    // - "Account 1" (group index 1)
    // - "Account 2" (group index 0)
    // This naming makes more sense for the end-user.
    //
    // For other type of wallets, since those wallets can create arbitrary gaps, we still
    // rely on the highest know index to avoid back-filling account with "old names".
    let proposedNameIndex = Math.max(
    // Use + 1 to use the next available index.
    highestNameIndex + 1, 
    // In case all accounts have been renamed differently than the usual "Account <index>"
    // pattern, we want to use the next "natural" index, which is just the number of groups
    // in that wallet (e.g. ["Account A", "Another Account"], next natural index would be
    // "Account 3" in this case).
    nextNaturalNameIndex ?? Object.keys(wallet.groups).length);
    // Find a unique name by checking for conflicts and incrementing if needed
    let proposedNameExists;
    let proposedName = '';
    do {
        proposedName = `${namePrefix} ${proposedNameIndex}`;
        // Check if this name already exists in the wallet (excluding current group)
        proposedNameExists = !(0, group_1.isAccountGroupNameUniqueFromWallet)(wallet, group.id, proposedName);
        /* istanbul ignore next */
        if (proposedNameExists) {
            proposedNameIndex += 1; // Try next number
        }
    } while (proposedNameExists);
    return proposedName;
}, _AccountTreeController_applyAccountGroupMetadata = function _AccountTreeController_applyAccountGroupMetadata(state, walletId, groupId, { allowComputedName, nextNaturalNameIndex, } = {}) {
    var _a, _b, _c;
    const wallet = state.accountTree.wallets[walletId];
    const group = wallet.groups[groupId];
    const persistedGroupMetadata = state.accountGroupsMetadata[groupId];
    // Apply persisted name if available (including empty strings)
    if (persistedGroupMetadata?.name !== undefined) {
        state.accountTree.wallets[walletId].groups[groupId].metadata.name =
            persistedGroupMetadata.name.value;
    }
    else if (!group.metadata.name) {
        let proposedName = '';
        // Computed names are usually only used for existing/old accounts. So this option
        // should be used only when we first initialize the tree.
        if (allowComputedName) {
            proposedName = __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_getComputedAccountGroupName).call(this, wallet, group);
        }
        // If we still don't have a valid name candidate, we fallback to a default name.
        if (!proposedName.length) {
            proposedName = __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_getDefaultAccountGroupName).call(this, state, wallet, group, nextNaturalNameIndex);
        }
        state.accountTree.wallets[walletId].groups[groupId].metadata.name =
            proposedName;
        (0, logger_1.projectLogger)(`[${group.id}] Set default name to: "${group.metadata.name}"`);
        // Persist the generated name to ensure consistency
        (_a = state.accountGroupsMetadata)[groupId] ?? (_a[groupId] = {});
        state.accountGroupsMetadata[groupId].name = {
            value: proposedName,
            // The `lastUpdatedAt` field is used for backup and sync, when comparing local names
            // with backed up names. In this case, the generated name should never take precedence
            // over a user-defined name, so we set `lastUpdatedAt` to 0.
            lastUpdatedAt: 0,
        };
    }
    // Apply persisted UI states
    if (persistedGroupMetadata?.pinned?.value !== undefined) {
        group.metadata.pinned = persistedGroupMetadata.pinned.value;
    }
    else {
        let isPinned = false;
        if (__classPrivateFieldGet(this, _AccountTreeController_accountOrderCallbacks, "f")?.isPinnedAccount) {
            isPinned = group.accounts.some((account) => __classPrivateFieldGet(this, _AccountTreeController_accountOrderCallbacks, "f")?.isPinnedAccount?.(account));
        }
        (_b = state.accountGroupsMetadata)[groupId] ?? (_b[groupId] = {});
        state.accountGroupsMetadata[groupId].pinned = {
            value: isPinned,
            lastUpdatedAt: 0,
        };
        // If any accounts was previously pinned, then we consider the group to be pinned as well.
        group.metadata.pinned = isPinned;
    }
    if (persistedGroupMetadata?.hidden?.value !== undefined) {
        group.metadata.hidden = persistedGroupMetadata.hidden.value;
    }
    else {
        let isHidden = false;
        if (__classPrivateFieldGet(this, _AccountTreeController_accountOrderCallbacks, "f")?.isHiddenAccount) {
            isHidden = group.accounts.some((account) => __classPrivateFieldGet(this, _AccountTreeController_accountOrderCallbacks, "f")?.isHiddenAccount?.(account));
        }
        (_c = state.accountGroupsMetadata)[groupId] ?? (_c[groupId] = {});
        state.accountGroupsMetadata[groupId].hidden = {
            value: isHidden,
            lastUpdatedAt: 0,
        };
        // If any accounts was previously hidden, then we consider the group to be hidden as well.
        group.metadata.hidden = isHidden;
    }
}, _AccountTreeController_handleAccountAdded = function _AccountTreeController_handleAccountAdded(account) {
    // We wait for the first `init` to be called to actually build up the tree and
    // mutate it. We expect the caller to first update the `AccountsController` state
    // to force the migration of accounts, and then call `init`.
    if (!__classPrivateFieldGet(this, _AccountTreeController_initialized, "f")) {
        return;
    }
    // Check if this account is already known by the tree to avoid double-insertion.
    if (!__classPrivateFieldGet(this, _AccountTreeController_accountIdToContext, "f").has(account.id)) {
        this.update((state) => {
            __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_insert).call(this, state.accountTree.wallets, account);
            const context = __classPrivateFieldGet(this, _AccountTreeController_accountIdToContext, "f").get(account.id);
            if (context) {
                const { walletId, groupId } = context;
                const wallet = state.accountTree.wallets[walletId];
                if (wallet) {
                    __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_applyAccountWalletMetadata).call(this, state, walletId);
                    __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_applyAccountGroupMetadata).call(this, state, walletId, groupId);
                }
            }
        });
        this.messagingSystem.publish(`${exports.controllerName}:accountTreeChange`, this.state.accountTree);
    }
}, _AccountTreeController_handleAccountRemoved = function _AccountTreeController_handleAccountRemoved(accountId) {
    // We wait for the first `init` to be called to actually build up the tree and
    // mutate it. We expect the caller to first update the `AccountsController` state
    // to force the migration of accounts, and then call `init`.
    if (!__classPrivateFieldGet(this, _AccountTreeController_initialized, "f")) {
        return;
    }
    const context = __classPrivateFieldGet(this, _AccountTreeController_accountIdToContext, "f").get(accountId);
    if (context) {
        const { walletId, groupId } = context;
        const previousSelectedAccountGroup = this.state.accountTree.selectedAccountGroup;
        let selectedAccountGroupChanged = false;
        this.update((state) => {
            const accounts = state.accountTree.wallets[walletId]?.groups[groupId]?.accounts;
            if (accounts) {
                const index = accounts.indexOf(accountId);
                if (index !== -1) {
                    accounts.splice(index, 1);
                    // Check if we need to update selectedAccountGroup after removal
                    if (state.accountTree.selectedAccountGroup === groupId &&
                        accounts.length === 0) {
                        // The currently selected group is now empty, find a new group to select
                        const newSelectedAccountGroup = __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_getDefaultAccountGroupId).call(this, state.accountTree.wallets);
                        state.accountTree.selectedAccountGroup = newSelectedAccountGroup;
                        selectedAccountGroupChanged =
                            newSelectedAccountGroup !== previousSelectedAccountGroup;
                    }
                }
                if (accounts.length === 0) {
                    __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_pruneEmptyGroupAndWallet).call(this, state, walletId, groupId);
                }
            }
        });
        this.messagingSystem.publish(`${exports.controllerName}:accountTreeChange`, this.state.accountTree);
        // Emit selectedAccountGroupChange event if the selected group changed
        if (selectedAccountGroupChanged) {
            this.messagingSystem.publish(`${exports.controllerName}:selectedAccountGroupChange`, this.state.accountTree.selectedAccountGroup, previousSelectedAccountGroup);
        }
        // Clear reverse-mapping for that account.
        __classPrivateFieldGet(this, _AccountTreeController_accountIdToContext, "f").delete(accountId);
    }
}, _AccountTreeController_pruneEmptyGroupAndWallet = function _AccountTreeController_pruneEmptyGroupAndWallet(state, walletId, groupId) {
    const { wallets } = state.accountTree;
    delete wallets[walletId].groups[groupId];
    __classPrivateFieldGet(this, _AccountTreeController_groupIdToWalletId, "f").delete(groupId);
    // Clean up metadata for the pruned group
    delete state.accountGroupsMetadata[groupId];
    if (Object.keys(wallets[walletId].groups).length === 0) {
        delete wallets[walletId];
        // Clean up metadata for the pruned wallet
        delete state.accountWalletsMetadata[walletId];
    }
    return state;
}, _AccountTreeController_insert = function _AccountTreeController_insert(wallets, account) {
    const result = __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_getEntropyRule).call(this).match(account) ??
        __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_getSnapRule).call(this).match(account) ??
        __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_getKeyringRule).call(this).match(account); // This one cannot fail.
    // Update controller's state.
    const walletId = result.wallet.id;
    let wallet = wallets[walletId];
    if (!wallet) {
        (0, logger_1.projectLogger)(`[${walletId}] Added as new wallet`);
        wallets[walletId] = {
            ...result.wallet,
            status: 'ready',
            groups: {},
            metadata: {
                name: '',
                ...result.wallet.metadata,
            },
            // We do need to type-cast since we're not narrowing `result` with
            // the union tag `result.wallet.type`.
        };
        wallet = wallets[walletId];
        // Trigger atomic sync for new wallet (only for entropy wallets)
        if (wallet.type === account_api_1.AccountWalletType.Entropy) {
            __classPrivateFieldGet(this, _AccountTreeController_backupAndSyncService, "f").enqueueSingleWalletSync(walletId);
        }
    }
    const groupId = result.group.id;
    let group = wallet.groups[groupId];
    const { type, id } = account;
    const sortOrder = group_1.ACCOUNT_TYPE_TO_SORT_ORDER[type];
    if (!group) {
        (0, logger_1.projectLogger)(`[${walletId}] Add new group: [${groupId}]`);
        wallet.groups[groupId] = {
            ...result.group,
            // Type-wise, we are guaranteed to always have at least 1 account.
            accounts: [id],
            metadata: {
                name: '',
                ...{ pinned: false, hidden: false },
                ...result.group.metadata, // Allow rules to override defaults
            },
            // We do need to type-cast since we're not narrowing `result` with
            // the union tag `result.group.type`.
        };
        group = wallet.groups[groupId];
        // Map group ID to its containing wallet ID for efficient direct access
        __classPrivateFieldGet(this, _AccountTreeController_groupIdToWalletId, "f").set(groupId, walletId);
        // Trigger atomic sync for new group (only for entropy wallets)
        if (wallet.type === account_api_1.AccountWalletType.Entropy) {
            __classPrivateFieldGet(this, _AccountTreeController_backupAndSyncService, "f").enqueueSingleGroupSync(groupId);
        }
    }
    else {
        group.accounts.push(id);
        // We need to do this at every insertion because race conditions can happen
        // during the account creation process where one provider completes before the other.
        // The discovery process in the service can also lead to some accounts being created "out of order".
        const { accounts } = group;
        accounts.sort(
        /* istanbul ignore next: Comparator branch execution (a===id vs b===id)
         * and return attribution vary across engines; final ordering is covered
         * by behavior tests. Ignoring the entire comparator avoids flaky line
         * coverage without reducing scenario coverage.
         */
        (a, b) => {
            const aSortOrder = a === id ? sortOrder : __classPrivateFieldGet(this, _AccountTreeController_accountIdToContext, "f").get(a)?.sortOrder;
            const bSortOrder = b === id ? sortOrder : __classPrivateFieldGet(this, _AccountTreeController_accountIdToContext, "f").get(b)?.sortOrder;
            return ((aSortOrder ?? group_1.MAX_SORT_ORDER) - (bSortOrder ?? group_1.MAX_SORT_ORDER));
        });
    }
    (0, logger_1.projectLogger)(`[${groupId}] Add new account: { id: "${account.id}", type: "${account.type}", address: "${account.address}"`);
    // Update the reverse mapping for this account.
    __classPrivateFieldGet(this, _AccountTreeController_accountIdToContext, "f").set(account.id, {
        walletId: wallet.id,
        groupId: group.id,
        sortOrder,
    });
}, _AccountTreeController_listAccounts = function _AccountTreeController_listAccounts() {
    return this.messagingSystem.call('AccountsController:listMultichainAccounts');
}, _AccountTreeController_assertAccountGroupExists = function _AccountTreeController_assertAccountGroupExists(groupId) {
    const exists = __classPrivateFieldGet(this, _AccountTreeController_groupIdToWalletId, "f").has(groupId);
    if (!exists) {
        throw new Error(`Account group with ID "${groupId}" not found in tree`);
    }
}, _AccountTreeController_assertAccountWalletExists = function _AccountTreeController_assertAccountWalletExists(walletId) {
    const exists = Boolean(this.state.accountTree.wallets[walletId]);
    if (!exists) {
        throw new Error(`Account wallet with ID "${walletId}" not found in tree`);
    }
}, _AccountTreeController_assertAccountGroupNameIsUnique = function _AccountTreeController_assertAccountGroupNameIsUnique(groupId, name) {
    if (!(0, group_1.isAccountGroupNameUnique)(this.state, groupId, name)) {
        throw new Error('Account group name already exists');
    }
}, _AccountTreeController_getDefaultSelectedAccountGroup = function _AccountTreeController_getDefaultSelectedAccountGroup(wallets) {
    const selectedAccount = this.messagingSystem.call('AccountsController:getSelectedMultichainAccount');
    if (selectedAccount && selectedAccount.id) {
        const accountMapping = __classPrivateFieldGet(this, _AccountTreeController_accountIdToContext, "f").get(selectedAccount.id);
        if (accountMapping) {
            const { groupId } = accountMapping;
            return groupId;
        }
    }
    // Default to the default group in case of errors.
    return __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_getDefaultAccountGroupId).call(this, wallets);
}, _AccountTreeController_handleSelectedAccountChange = function _AccountTreeController_handleSelectedAccountChange(account) {
    const accountMapping = __classPrivateFieldGet(this, _AccountTreeController_accountIdToContext, "f").get(account.id);
    if (!accountMapping) {
        // Account not in tree yet, might be during initialization
        return;
    }
    const { groupId } = accountMapping;
    const previousSelectedAccountGroup = this.state.accountTree.selectedAccountGroup;
    // Idempotent check - if the same group is already selected, do nothing
    if (previousSelectedAccountGroup === groupId) {
        return;
    }
    // Update selectedAccountGroup to match the selected account
    this.update((state) => {
        state.accountTree.selectedAccountGroup = groupId;
    });
    this.messagingSystem.publish(`${exports.controllerName}:selectedAccountGroupChange`, groupId, previousSelectedAccountGroup);
}, _AccountTreeController_handleMultichainAccountWalletStatusChange = function _AccountTreeController_handleMultichainAccountWalletStatusChange(walletId, walletStatus) {
    this.update((state) => {
        const wallet = state.accountTree.wallets[walletId];
        if (wallet) {
            wallet.status = walletStatus;
        }
    });
}, _AccountTreeController_getAccountGroup = function _AccountTreeController_getAccountGroup(groupId) {
    const found = Object.values(this.state.accountTree.wallets).find((wallet) => wallet.groups[groupId] !== undefined);
    return found?.groups[groupId];
}, _AccountTreeController_getDefaultAccountFromAccountGroupId = function _AccountTreeController_getDefaultAccountFromAccountGroupId(groupId) {
    const group = __classPrivateFieldGet(this, _AccountTreeController_instances, "m", _AccountTreeController_getAccountGroup).call(this, groupId);
    if (group) {
        let candidate;
        for (const id of group.accounts) {
            const account = this.messagingSystem.call('AccountsController:getAccount', id);
            if (!candidate) {
                candidate = id;
            }
            if (account && (0, keyring_api_1.isEvmAccountType)(account.type)) {
                // EVM accounts have a higher priority, so if we find any, we just
                // use that account!
                return account.id;
            }
        }
        return candidate;
    }
    return undefined;
}, _AccountTreeController_getDefaultAccountGroupId = function _AccountTreeController_getDefaultAccountGroupId(wallets) {
    let candidate = '';
    for (const wallet of Object.values(wallets)) {
        for (const group of Object.values(wallet.groups)) {
            // We only update the candidate with the first non-empty group, but still
            // try to find a group that contains an EVM account (the `candidate` is
            // our fallback).
            if (candidate === '' && group.accounts.length > 0) {
                candidate = group.id;
            }
            for (const id of group.accounts) {
                const account = this.messagingSystem.call('AccountsController:getAccount', id);
                if (account && (0, keyring_api_1.isEvmAccountType)(account.type)) {
                    // EVM accounts have a higher priority, so if we find any, we just
                    // use that group!
                    return group.id;
                }
            }
        }
    }
    return candidate;
}, _AccountTreeController_registerMessageHandlers = function _AccountTreeController_registerMessageHandlers() {
    this.messagingSystem.registerActionHandler(`${exports.controllerName}:getSelectedAccountGroup`, this.getSelectedAccountGroup.bind(this));
    this.messagingSystem.registerActionHandler(`${exports.controllerName}:setSelectedAccountGroup`, this.setSelectedAccountGroup.bind(this));
    this.messagingSystem.registerActionHandler(`${exports.controllerName}:getAccountsFromSelectedAccountGroup`, this.getAccountsFromSelectedAccountGroup.bind(this));
    this.messagingSystem.registerActionHandler(`${exports.controllerName}:setAccountWalletName`, this.setAccountWalletName.bind(this));
    this.messagingSystem.registerActionHandler(`${exports.controllerName}:setAccountGroupName`, this.setAccountGroupName.bind(this));
    this.messagingSystem.registerActionHandler(`${exports.controllerName}:setAccountGroupPinned`, this.setAccountGroupPinned.bind(this));
    this.messagingSystem.registerActionHandler(`${exports.controllerName}:setAccountGroupHidden`, this.setAccountGroupHidden.bind(this));
}, _AccountTreeController_createBackupAndSyncContext = function _AccountTreeController_createBackupAndSyncContext() {
    return {
        ...__classPrivateFieldGet(this, _AccountTreeController_backupAndSyncConfig, "f"),
        controller: this,
        messenger: this.messagingSystem,
        controllerStateUpdateFn: this.update.bind(this),
        traceFn: __classPrivateFieldGet(this, _AccountTreeController_trace, "f").bind(this),
        groupIdToWalletId: __classPrivateFieldGet(this, _AccountTreeController_groupIdToWalletId, "f"),
    };
};

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\AccountTreeController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\analytics\\index.cjs", {"./segment.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\analytics\\segment.cjs","./traces.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\analytics\\traces.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cbackup-and-sync%5Canalytics%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./segment.cjs"), exports);
__exportStar(require("./traces.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\analytics\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\analytics\\segment.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cbackup-and-sync%5Canalytics%5Csegment.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatAnalyticsEvent = exports.BackupAndSyncAnalyticsEvent = void 0;
exports.BackupAndSyncAnalyticsEvent = {
    WalletRenamed: 'wallet_renamed',
    GroupAdded: 'group_added',
    GroupRenamed: 'group_renamed',
    GroupHiddenStatusChanged: 'group_hidden_status_changed',
    GroupPinnedStatusChanged: 'group_pinned_status_changed',
    LegacySyncingDone: 'legacy_syncing_done',
    LegacyGroupAddedFromAccount: 'legacy_group_added_from_account',
    LegacyGroupRenamed: 'legacy_group_renamed',
};
const BACKUP_AND_SYNC_EVENT_FEATURE_NAME = 'Multichain Account Syncing';
/**
 * Formats the analytics event payload to match the segment schema.
 *
 * @param params - The parameters for the analytics event.
 * @param params.action - The action being performed.
 * @param params.profileId - The profile ID associated with the event.
 * @param params.additionalDescription - Optional additional description for the event.
 *
 * @returns The formatted event payload.
 */
const formatAnalyticsEvent = ({ action, profileId, additionalDescription, }) => {
    return {
        feature_name: BACKUP_AND_SYNC_EVENT_FEATURE_NAME,
        action,
        profile_id: profileId,
        ...(additionalDescription !== undefined
            ? {
                additional_description: additionalDescription,
            }
            : {}),
    };
};
exports.formatAnalyticsEvent = formatAnalyticsEvent;

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\analytics\\segment.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\analytics\\traces.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cbackup-and-sync%5Canalytics%5Ctraces.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.traceFallback = exports.TraceName = void 0;
exports.TraceName = {
    AccountSyncFull: 'Multichain Account Syncing - Full',
};
/**
 * Fallback function for tracing.
 * This function is used when no specific trace function is provided.
 * It executes the provided function in a trace context if available.
 *
 * @param _request - The trace request containing additional data and context.
 * @param fn - The function to execute within the trace context.
 * @returns A promise that resolves to the result of the executed function.
 * If no function is provided, it resolves to undefined.
 */
const traceFallback = async (_request, fn) => {
    if (!fn) {
        return undefined;
    }
    return await Promise.resolve(fn());
};
exports.traceFallback = traceFallback;

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\analytics\\traces.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\authentication\\index.cjs", {"./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\authentication\\utils.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cbackup-and-sync%5Cauthentication%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./utils.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\authentication\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\authentication\\utils.cjs", {"../../logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\logger.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cbackup-and-sync%5Cauthentication%5Cutils.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getProfileId = void 0;
const logger_1 = require("../../logger.cjs");
/**
 * Retrieves the profile ID from AuthenticationController.
 *
 * @param context - The backup and sync context.
 * @param entropySourceId - The optional entropy source ID.
 * @returns The profile ID associated with the session, if available.
 */
const getProfileId = async (context, entropySourceId) => {
    try {
        const sessionProfile = await context.messenger.call('AuthenticationController:getSessionProfile', entropySourceId);
        return sessionProfile.profileId;
    }
    catch (error) {
        (0, logger_1.backupAndSyncLogger)(`Failed to retrieve profile ID:`, error);
        return undefined;
    }
};
exports.getProfileId = getProfileId;

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\authentication\\utils.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\service\\atomic-sync-queue.cjs", {"../../logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\logger.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cbackup-and-sync%5Cservice%5Catomic-sync-queue.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var _AtomicSyncQueue_queue, _AtomicSyncQueue_isProcessingInProgress;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AtomicSyncQueue = void 0;
const utils_1 = require("@metamask/utils");
const logger_1 = require("../../logger.cjs");
/**
 * Manages atomic sync operations in a queue to prevent concurrent execution
 * and ensure proper ordering of sync events.
 */
class AtomicSyncQueue {
    constructor() {
        /**
         * Queue for atomic sync events that need to be processed asynchronously.
         */
        _AtomicSyncQueue_queue.set(this, []);
        /**
         * Flag to prevent multiple queue processing operations from running concurrently.
         */
        _AtomicSyncQueue_isProcessingInProgress.set(this, false);
    }
    /**
     * Clears the queue and enqueues a new sync function.
     *
     * @param syncFunction - The sync function to enqueue.
     * @returns A Promise that resolves when the sync function completes.
     */
    clearAndEnqueue(syncFunction) {
        this.clear();
        return this.enqueue(syncFunction);
    }
    /**
     * Enqueues an atomic sync function for processing.
     *
     * @param syncFunction - The sync function to enqueue.
     * @returns A Promise that resolves when the sync function completes.
     */
    enqueue(syncFunction) {
        const { promise, resolve, reject } = (0, utils_1.createDeferredPromise)();
        // Create the sync event with promise handlers
        const syncEvent = {
            execute: async () => {
                try {
                    await syncFunction();
                    resolve?.();
                }
                catch (error) {
                    reject?.(error);
                }
            },
        };
        // Add to queue and start processing
        __classPrivateFieldGet(this, _AtomicSyncQueue_queue, "f").push(syncEvent);
        setTimeout(() => {
            this.process().catch((error) => {
                (0, logger_1.backupAndSyncLogger)('Error processing atomic sync queue:', error);
            });
        }, 0);
        return promise;
    }
    /**
     * Processes the atomic sync queue.
     */
    async process() {
        if (__classPrivateFieldGet(this, _AtomicSyncQueue_isProcessingInProgress, "f")) {
            return;
        }
        if (__classPrivateFieldGet(this, _AtomicSyncQueue_queue, "f").length === 0) {
            return;
        }
        __classPrivateFieldSet(this, _AtomicSyncQueue_isProcessingInProgress, true, "f");
        try {
            while (__classPrivateFieldGet(this, _AtomicSyncQueue_queue, "f").length > 0) {
                const event = __classPrivateFieldGet(this, _AtomicSyncQueue_queue, "f").shift();
                /* istanbul ignore next */
                if (!event) {
                    break;
                }
                await event.execute();
            }
        }
        finally {
            __classPrivateFieldSet(this, _AtomicSyncQueue_isProcessingInProgress, false, "f");
        }
    }
    /**
     * Clears all pending sync events from the queue.
     * Useful when big sync starts to prevent stale updates.
     */
    clear() {
        __classPrivateFieldGet(this, _AtomicSyncQueue_queue, "f").length = 0;
    }
    /**
     * Gets the current queue size.
     *
     * @returns The number of pending sync events.
     */
    get size() {
        return __classPrivateFieldGet(this, _AtomicSyncQueue_queue, "f").length;
    }
    /**
     * Checks if queue processing is currently in progress.
     *
     * @returns True if processing is in progress.
     */
    get isProcessing() {
        return __classPrivateFieldGet(this, _AtomicSyncQueue_isProcessingInProgress, "f");
    }
}
exports.AtomicSyncQueue = AtomicSyncQueue;
_AtomicSyncQueue_queue = new WeakMap(), _AtomicSyncQueue_isProcessingInProgress = new WeakMap();

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\service\\atomic-sync-queue.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\service\\index.cjs", {"../../logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\logger.cjs","../analytics/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\analytics\\index.cjs","../authentication/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\authentication\\index.cjs","../syncing/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\syncing\\index.cjs","../user-storage/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\index.cjs","../utils/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\utils\\index.cjs","./atomic-sync-queue.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\service\\atomic-sync-queue.cjs","@metamask/account-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cbackup-and-sync%5Cservice%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _BackupAndSyncService_instances, _BackupAndSyncService_context, _BackupAndSyncService_atomicSyncQueue, _BackupAndSyncService_ongoingFullSyncPromise, _BackupAndSyncService_firstOngoingFullSyncPromise, _BackupAndSyncService_getEntropyWallet, _BackupAndSyncService_setupOngoingPromiseCleanup, _BackupAndSyncService_performFullSyncInner, _BackupAndSyncService_performSingleWalletSyncInner, _BackupAndSyncService_performSingleGroupSyncInner;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupAndSyncService = void 0;
const account_api_1 = require("@metamask/account-api");
const atomic_sync_queue_1 = require("./atomic-sync-queue.cjs");
const logger_1 = require("../../logger.cjs");
const analytics_1 = require("../analytics/index.cjs");
const authentication_1 = require("../authentication/index.cjs");
const syncing_1 = require("../syncing/index.cjs");
const user_storage_1 = require("../user-storage/index.cjs");
const utils_1 = require("../utils/index.cjs");
/**
 * Service responsible for managing all backup and sync operations.
 *
 * This service handles:
 * - Full sync operations
 * - Single item sync operations
 * - Sync queue management
 * - Sync state management
 */
class BackupAndSyncService {
    constructor(context) {
        _BackupAndSyncService_instances.add(this);
        _BackupAndSyncService_context.set(this, void 0);
        /**
         * Queue manager for atomic sync operations.
         */
        _BackupAndSyncService_atomicSyncQueue.set(this, void 0);
        /**
         * Cached promise for ongoing full sync operations.
         * Ensures multiple callers await the same sync operation.
         */
        _BackupAndSyncService_ongoingFullSyncPromise.set(this, null);
        /**
         * Cached promise for the first ongoing full sync operation.
         * Ensures multiple callers await the same sync operation.
         */
        _BackupAndSyncService_firstOngoingFullSyncPromise.set(this, null);
        __classPrivateFieldSet(this, _BackupAndSyncService_context, context, "f");
        __classPrivateFieldSet(this, _BackupAndSyncService_atomicSyncQueue, new atomic_sync_queue_1.AtomicSyncQueue(), "f");
    }
    /**
     * Checks if syncing is currently in progress.
     *
     * @returns True if syncing is in progress.
     */
    get isInProgress() {
        return __classPrivateFieldGet(this, _BackupAndSyncService_context, "f").controller.state.isAccountTreeSyncingInProgress;
    }
    /**
     * Checks if the account tree has been synced at least once.
     *
     * @returns True if the account tree has been synced at least once.
     */
    get hasSyncedAtLeastOnce() {
        return __classPrivateFieldGet(this, _BackupAndSyncService_context, "f").controller.state
            .hasAccountTreeSyncingSyncedAtLeastOnce;
    }
    /**
     * Checks if backup and sync is enabled by checking UserStorageController state.
     *
     * @returns True if backup and sync + account syncing is enabled.
     */
    get isBackupAndSyncEnabled() {
        const userStorageControllerState = __classPrivateFieldGet(this, _BackupAndSyncService_context, "f").messenger.call('UserStorageController:getState');
        const { isAccountSyncingEnabled, isBackupAndSyncEnabled } = userStorageControllerState;
        return isBackupAndSyncEnabled && isAccountSyncingEnabled;
    }
    /**
     * Clears the atomic queue and resets ongoing operations.
     */
    clearState() {
        __classPrivateFieldGet(this, _BackupAndSyncService_atomicSyncQueue, "f").clear();
        __classPrivateFieldSet(this, _BackupAndSyncService_ongoingFullSyncPromise, null, "f");
        __classPrivateFieldSet(this, _BackupAndSyncService_firstOngoingFullSyncPromise, null, "f");
    }
    /**
     * Handles changes to the user storage state.
     * Used to clear the backup and sync service state.
     *
     * @param state - The new user storage state.
     */
    handleUserStorageStateChange(state) {
        if (!state.isAccountSyncingEnabled || !state.isBackupAndSyncEnabled) {
            // If either syncing is disabled, clear the account tree state
            this.clearState();
        }
    }
    /**
     * Enqueues a single wallet sync operation (fire-and-forget).
     * If the first full sync has not yet occurred, it does nothing.
     *
     * @param walletId - The wallet ID to sync.
     */
    enqueueSingleWalletSync(walletId) {
        if (!this.isBackupAndSyncEnabled || !this.hasSyncedAtLeastOnce) {
            return;
        }
        // eslint-disable-next-line no-void
        void __classPrivateFieldGet(this, _BackupAndSyncService_atomicSyncQueue, "f").enqueue(() => __classPrivateFieldGet(this, _BackupAndSyncService_instances, "m", _BackupAndSyncService_performSingleWalletSyncInner).call(this, walletId));
    }
    /**
     * Enqueues a single group sync operation (fire-and-forget).
     * If the first full sync has not yet occurred, it does nothing.
     *
     * @param groupId - The group ID to sync.
     */
    enqueueSingleGroupSync(groupId) {
        if (!this.isBackupAndSyncEnabled ||
            !this.hasSyncedAtLeastOnce ||
            // This prevents rate limiting scenarios where full syncs trigger group creations
            // that in turn enqueue the same single group syncs that the full sync just did.
            // This can very rarely lead to inconsistencies, but will be fixed on the next full sync.
            // TODO: let's improve this in the future by tracking the updates done in the full sync and
            // comparing against that.
            this.isInProgress) {
            return;
        }
        // eslint-disable-next-line no-void
        void __classPrivateFieldGet(this, _BackupAndSyncService_atomicSyncQueue, "f").enqueue(() => __classPrivateFieldGet(this, _BackupAndSyncService_instances, "m", _BackupAndSyncService_performSingleGroupSyncInner).call(this, groupId));
    }
    /**
     * Performs a full synchronization of the local account tree with user storage, ensuring consistency
     * between local state and cloud-stored account data.
     * If a full sync is already in progress, it will return the ongoing promise.
     * This clears the atomic sync queue before starting the full sync.
     *
     * NOTE: in some very edge cases, this can be ran concurrently if triggered quickly after
     * toggling back and forth the backup and sync feature from the UI.
     *
     * @returns A promise that resolves when the sync is complete.
     */
    async performFullSync() {
        if (!this.isBackupAndSyncEnabled) {
            return undefined;
        }
        // If there's an ongoing sync (including first sync), return it
        if (__classPrivateFieldGet(this, _BackupAndSyncService_ongoingFullSyncPromise, "f")) {
            return __classPrivateFieldGet(this, _BackupAndSyncService_ongoingFullSyncPromise, "f");
        }
        // Create a new ongoing sync (sequential calls after previous completed)
        const newSyncPromise = __classPrivateFieldGet(this, _BackupAndSyncService_atomicSyncQueue, "f").clearAndEnqueue(() => __classPrivateFieldGet(this, _BackupAndSyncService_instances, "m", _BackupAndSyncService_performFullSyncInner).call(this));
        // First sync setup - create and cache the first sync promise
        if (!__classPrivateFieldGet(this, _BackupAndSyncService_firstOngoingFullSyncPromise, "f")) {
            __classPrivateFieldSet(this, _BackupAndSyncService_firstOngoingFullSyncPromise, newSyncPromise, "f");
        }
        return __classPrivateFieldGet(this, _BackupAndSyncService_instances, "m", _BackupAndSyncService_setupOngoingPromiseCleanup).call(this, newSyncPromise);
    }
    /**
     * Performs a full synchronization of the local account tree with user storage, ensuring consistency
     * between local state and cloud-stored account data.
     *
     * If the first ever full sync is already in progress, it will return the ongoing promise.
     * If the first ever full sync has already completed, it will resolve and NOT start a new sync.
     *
     * This clears the atomic sync queue before starting the full sync.
     *
     * @returns A promise that resolves when the sync is complete.
     */
    async performFullSyncAtLeastOnce() {
        if (!this.isBackupAndSyncEnabled) {
            return undefined;
        }
        if (!__classPrivateFieldGet(this, _BackupAndSyncService_firstOngoingFullSyncPromise, "f")) {
            __classPrivateFieldSet(this, _BackupAndSyncService_firstOngoingFullSyncPromise, __classPrivateFieldGet(this, _BackupAndSyncService_atomicSyncQueue, "f").clearAndEnqueue(() => __classPrivateFieldGet(this, _BackupAndSyncService_instances, "m", _BackupAndSyncService_performFullSyncInner).call(this)), "f");
            // eslint-disable-next-line no-void
            void __classPrivateFieldGet(this, _BackupAndSyncService_instances, "m", _BackupAndSyncService_setupOngoingPromiseCleanup).call(this, __classPrivateFieldGet(this, _BackupAndSyncService_firstOngoingFullSyncPromise, "f"));
        }
        return __classPrivateFieldGet(this, _BackupAndSyncService_firstOngoingFullSyncPromise, "f");
    }
}
exports.BackupAndSyncService = BackupAndSyncService;
_BackupAndSyncService_context = new WeakMap(), _BackupAndSyncService_atomicSyncQueue = new WeakMap(), _BackupAndSyncService_ongoingFullSyncPromise = new WeakMap(), _BackupAndSyncService_firstOngoingFullSyncPromise = new WeakMap(), _BackupAndSyncService_instances = new WeakSet(), _BackupAndSyncService_getEntropyWallet = function _BackupAndSyncService_getEntropyWallet(walletId) {
    const wallet = __classPrivateFieldGet(this, _BackupAndSyncService_context, "f").controller.state.accountTree.wallets[walletId];
    return wallet?.type === account_api_1.AccountWalletType.Entropy ? wallet : undefined;
}, _BackupAndSyncService_setupOngoingPromiseCleanup = function _BackupAndSyncService_setupOngoingPromiseCleanup(promise) {
    __classPrivateFieldSet(this, _BackupAndSyncService_ongoingFullSyncPromise, promise, "f");
    // Set up cleanup without affecting the returned promise
    promise
        .finally(() => {
        __classPrivateFieldSet(this, _BackupAndSyncService_ongoingFullSyncPromise, null, "f");
    })
        .catch(() => {
        // Only ignore errors from the cleanup operation itself
        // The original promise errors are still propagated to callers
    });
    return promise;
}, _BackupAndSyncService_performFullSyncInner = 
/**
 * Performs a full synchronization of the local account tree with user storage, ensuring consistency
 * between local state and cloud-stored account data.
 *
 * This method performs a comprehensive sync operation that:
 * 1. Identifies all local entropy wallets that can be synchronized
 * 2. Performs legacy account syncing if needed (for backwards compatibility)
 * - Disables subsequent legacy syncing by setting a flag in user storage
 * - Exits early if multichain account syncing is disabled after legacy sync
 * 3. Executes multichain account syncing for each wallet:
 * - Syncs wallet metadata bidirectionally
 * - Creates missing local groups from user storage data (or pushes local groups if none exist remotely)
 * - Refreshes local state to reflect newly created groups
 * - Syncs group metadata bidirectionally
 *
 * The sync is atomic per wallet with rollback on errors, but continues processing other wallets
 * if individual wallet sync fails. A global lock prevents concurrent sync operations.
 *
 * During this process, all other atomic multichain related user storage updates are blocked.
 *
 * @throws Will throw if the sync operation encounters unrecoverable errors
 */
async function _BackupAndSyncService_performFullSyncInner() {
    // Prevent multiple syncs from running at the same time.
    // Also prevents atomic updates from being applied while syncing is in progress.
    if (this.isInProgress) {
        return;
    }
    // Set isAccountTreeSyncingInProgress immediately to prevent race conditions
    __classPrivateFieldGet(this, _BackupAndSyncService_context, "f").controllerStateUpdateFn((state) => {
        state.isAccountTreeSyncingInProgress = true;
    });
    // Encapsulate the sync logic in a function to allow tracing
    const bigSyncFn = async () => {
        try {
            // 1. Identifies all local entropy wallets that can be synchronized
            const localSyncableWallets = (0, utils_1.getLocalEntropyWallets)(__classPrivateFieldGet(this, _BackupAndSyncService_context, "f"));
            if (!localSyncableWallets.length) {
                // No wallets to sync, just return. This shouldn't happen.
                return;
            }
            // 2. Iterate over each local wallet
            for (const wallet of localSyncableWallets) {
                const entropySourceId = wallet.metadata.entropy.id;
                let walletProfileId;
                let walletFromUserStorage;
                let groupsFromUserStorage;
                try {
                    walletProfileId = await (0, authentication_1.getProfileId)(__classPrivateFieldGet(this, _BackupAndSyncService_context, "f"), entropySourceId);
                    [walletFromUserStorage, groupsFromUserStorage] = await Promise.all([
                        (0, user_storage_1.getWalletFromUserStorage)(__classPrivateFieldGet(this, _BackupAndSyncService_context, "f"), entropySourceId),
                        (0, user_storage_1.getAllGroupsFromUserStorage)(__classPrivateFieldGet(this, _BackupAndSyncService_context, "f"), entropySourceId),
                    ]);
                    // 2.1 Decide if we need to perform legacy account syncing
                    if (!walletFromUserStorage ||
                        !walletFromUserStorage.isLegacyAccountSyncingDisabled) {
                        // 2.2 Perform legacy account syncing
                        // This will migrate legacy account data to the new structure.
                        // This operation will only be performed once.
                        await (0, syncing_1.performLegacyAccountSyncing)(__classPrivateFieldGet(this, _BackupAndSyncService_context, "f"), entropySourceId, walletProfileId);
                    }
                }
                catch (error) {
                    const errorMessage = error instanceof Error ? error.message : String(error);
                    const errorString = `Legacy syncing failed for wallet ${wallet.id}: ${errorMessage}`;
                    (0, logger_1.backupAndSyncLogger)(errorString);
                    throw new Error(errorString);
                }
                // 3. Execute multichain account syncing
                let stateSnapshot;
                try {
                    // 3.1 Wallet syncing
                    // Create a state snapshot before processing each wallet for potential rollback
                    stateSnapshot = (0, utils_1.createStateSnapshot)(__classPrivateFieldGet(this, _BackupAndSyncService_context, "f"));
                    // Sync wallet metadata bidirectionally
                    await (0, syncing_1.syncWalletMetadata)(__classPrivateFieldGet(this, _BackupAndSyncService_context, "f"), wallet, walletFromUserStorage, walletProfileId);
                    // 3.2 Groups syncing
                    // If groups data does not exist in user storage yet, create it
                    if (!groupsFromUserStorage.length) {
                        // If no groups exist in user storage, we can push all groups from the wallet to the user storage and exit
                        await (0, user_storage_1.pushGroupToUserStorageBatch)(__classPrivateFieldGet(this, _BackupAndSyncService_context, "f"), (0, utils_1.getLocalGroupsForEntropyWallet)(__classPrivateFieldGet(this, _BackupAndSyncService_context, "f"), wallet.id), entropySourceId);
                        continue; // No need to proceed with metadata comparison if groups are new
                    }
                    // Create local groups for each group from user storage if they do not exist
                    // This will ensure that we have all groups available locally before syncing metadata
                    await (0, syncing_1.createLocalGroupsFromUserStorage)(__classPrivateFieldGet(this, _BackupAndSyncService_context, "f"), groupsFromUserStorage, entropySourceId, walletProfileId);
                    // Sync group metadata bidirectionally
                    await (0, syncing_1.syncGroupsMetadata)(__classPrivateFieldGet(this, _BackupAndSyncService_context, "f"), wallet, groupsFromUserStorage, entropySourceId, walletProfileId);
                }
                catch (error) {
                    const errorMessage = error instanceof Error ? error.message : String(error);
                    const errorString = `Error during multichain account syncing for wallet ${wallet.id}: ${errorMessage}`;
                    (0, logger_1.backupAndSyncLogger)(errorString);
                    // Attempt to rollback state changes for this wallet
                    try {
                        if (!stateSnapshot) {
                            throw new Error(`State snapshot is missing for wallet ${wallet.id}`);
                        }
                        (0, utils_1.restoreStateFromSnapshot)(__classPrivateFieldGet(this, _BackupAndSyncService_context, "f"), stateSnapshot);
                        (0, logger_1.backupAndSyncLogger)(`Rolled back state changes for wallet ${wallet.id}`);
                    }
                    catch (rollbackError) {
                        (0, logger_1.backupAndSyncLogger)(`Failed to rollback state for wallet ${wallet.id}:`, rollbackError instanceof Error
                            ? rollbackError.message
                            : String(rollbackError));
                    }
                    // Continue with next wallet instead of failing the entire sync
                    continue;
                }
            }
        }
        catch (error) {
            (0, logger_1.backupAndSyncLogger)('Error during multichain account syncing:', error);
            throw error;
        }
        __classPrivateFieldGet(this, _BackupAndSyncService_context, "f").controllerStateUpdateFn((state) => {
            state.hasAccountTreeSyncingSyncedAtLeastOnce = true;
        });
    };
    // Execute the big sync function with tracing and ensure state cleanup
    try {
        await __classPrivateFieldGet(this, _BackupAndSyncService_context, "f").traceFn({
            name: analytics_1.TraceName.AccountSyncFull,
        }, bigSyncFn);
    }
    finally {
        // Always reset state, regardless of success or failure
        __classPrivateFieldGet(this, _BackupAndSyncService_context, "f").controllerStateUpdateFn((state) => {
            state.isAccountTreeSyncingInProgress = false;
        });
    }
}, _BackupAndSyncService_performSingleWalletSyncInner = 
/**
 * Performs a single wallet's bidirectional metadata sync with user storage.
 *
 * @param walletId - The wallet ID to sync.
 */
async function _BackupAndSyncService_performSingleWalletSyncInner(walletId) {
    try {
        const wallet = __classPrivateFieldGet(this, _BackupAndSyncService_instances, "m", _BackupAndSyncService_getEntropyWallet).call(this, walletId);
        if (!wallet) {
            return; // Only sync entropy wallets
        }
        const entropySourceId = wallet.metadata.entropy.id;
        const walletProfileId = await (0, authentication_1.getProfileId)(__classPrivateFieldGet(this, _BackupAndSyncService_context, "f"), entropySourceId);
        const walletFromUserStorage = await (0, user_storage_1.getWalletFromUserStorage)(__classPrivateFieldGet(this, _BackupAndSyncService_context, "f"), entropySourceId);
        await (0, syncing_1.syncWalletMetadata)(__classPrivateFieldGet(this, _BackupAndSyncService_context, "f"), wallet, walletFromUserStorage, walletProfileId);
    }
    catch (error) {
        (0, logger_1.backupAndSyncLogger)(`Error in single wallet sync for ${walletId}:`, error);
        throw error;
    }
}, _BackupAndSyncService_performSingleGroupSyncInner = 
/**
 * Performs a single group's bidirectional metadata sync with user storage.
 *
 * @param groupId - The group ID to sync.
 */
async function _BackupAndSyncService_performSingleGroupSyncInner(groupId) {
    try {
        const walletId = __classPrivateFieldGet(this, _BackupAndSyncService_context, "f").groupIdToWalletId.get(groupId);
        if (!walletId) {
            return;
        }
        const wallet = __classPrivateFieldGet(this, _BackupAndSyncService_instances, "m", _BackupAndSyncService_getEntropyWallet).call(this, walletId);
        if (!wallet) {
            return; // Only sync entropy wallets
        }
        const group = wallet.groups[groupId];
        if (!group) {
            return;
        }
        const entropySourceId = wallet.metadata.entropy.id;
        const walletProfileId = await (0, authentication_1.getProfileId)(__classPrivateFieldGet(this, _BackupAndSyncService_context, "f"), entropySourceId);
        // Get the specific group from user storage
        const groupFromUserStorage = await (0, user_storage_1.getGroupFromUserStorage)(__classPrivateFieldGet(this, _BackupAndSyncService_context, "f"), entropySourceId, group.metadata.entropy.groupIndex);
        await (0, syncing_1.syncGroupMetadata)(__classPrivateFieldGet(this, _BackupAndSyncService_context, "f"), group, groupFromUserStorage, entropySourceId, walletProfileId);
    }
    catch (error) {
        (0, logger_1.backupAndSyncLogger)(`Error in single group sync for ${groupId}:`, error);
        throw error;
    }
};

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\service\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\syncing\\group.cjs", {"../../logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\logger.cjs","../analytics/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\analytics\\index.cjs","../types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\types.cjs","../user-storage/network-operations.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\network-operations.cjs","../utils/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\utils\\index.cjs","./metadata.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\syncing\\metadata.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cbackup-and-sync%5Csyncing%5Cgroup.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.syncGroupsMetadata = exports.syncGroupMetadata = exports.createLocalGroupsFromUserStorage = exports.createMultichainAccountGroup = void 0;
const metadata_1 = require("./metadata.cjs");
const logger_1 = require("../../logger.cjs");
const analytics_1 = require("../analytics/index.cjs");
const types_1 = require("../types.cjs");
const network_operations_1 = require("../user-storage/network-operations.cjs");
const utils_1 = require("../utils/index.cjs");
/**
 * Creates a multichain account group.
 *
 * @param context - The sync context containing controller and messenger.
 * @param entropySourceId - The entropy source ID.
 * @param groupIndex - The group index.
 * @param profileId - The profile ID for analytics.
 * @param analyticsAction - The analytics action to log.
 */
const createMultichainAccountGroup = async (context, entropySourceId, groupIndex, profileId, analyticsAction) => {
    try {
        const didGroupAlreadyExist = (0, utils_1.getLocalGroupForEntropyWallet)(context, entropySourceId, groupIndex);
        // This will be idempotent so we can create the group even if it already exists
        await context.messenger.call('MultichainAccountService:createMultichainAccountGroup', {
            entropySource: entropySourceId,
            groupIndex,
        });
        if (!didGroupAlreadyExist) {
            context.emitAnalyticsEventFn({
                action: analyticsAction,
                profileId,
            });
        }
    }
    catch (error) {
        // This can happen if the Snap Keyring is not ready yet when invoking
        // `MultichainAccountService:createMultichainAccountGroup`.
        // Since `MultichainAccountService:createMultichainAccountGroup` will at
        // least create the EVM account and the account group before throwing, we can safely
        // ignore this error and swallow it.
        // Any missing Snap accounts will be added later with alignment.
        (0, logger_1.backupAndSyncLogger)(`Failed to create group ${groupIndex} for entropy ${entropySourceId}:`, 
        // istanbul ignore next
        error instanceof Error ? error.message : String(error));
    }
};
exports.createMultichainAccountGroup = createMultichainAccountGroup;
/**
 * Creates local groups from user storage groups.
 *
 * @param context - The sync context containing controller and messenger.
 * @param groupsFromUserStorage - Array of groups from user storage.
 * @param entropySourceId - The entropy source ID.
 * @param profileId - The profile ID for analytics.
 */
async function createLocalGroupsFromUserStorage(context, groupsFromUserStorage, entropySourceId, profileId) {
    const numberOfAccountGroupsToCreate = Math.max(...groupsFromUserStorage.map((g) => g.groupIndex));
    // Creating multichain account group is idempotent, so we can safely
    // re-create every groups starting from 0.
    for (let groupIndex = 0; groupIndex <= numberOfAccountGroupsToCreate; groupIndex++) {
        await (0, exports.createMultichainAccountGroup)(context, entropySourceId, groupIndex, profileId, analytics_1.BackupAndSyncAnalyticsEvent.GroupAdded);
    }
}
exports.createLocalGroupsFromUserStorage = createLocalGroupsFromUserStorage;
/**
 * Syncs group metadata fields and determines if the group needs to be pushed to user storage.
 *
 * @param context - The sync context containing controller and messenger.
 * @param localGroup - The local group to sync.
 * @param groupFromUserStorage - The group from user storage to compare against.
 * @param profileId - The profile ID for analytics.
 * @returns A promise that resolves to true if the group needs to be pushed to user storage.
 */
async function syncGroupMetadataAndCheckIfPushNeeded(context, localGroup, groupFromUserStorage, profileId) {
    const groupPersistedMetadata = context.controller.state.accountGroupsMetadata[localGroup.id];
    if (!groupFromUserStorage) {
        (0, logger_1.backupAndSyncLogger)(`Group ${localGroup.id} did not exist in user storage, pushing to user storage...`);
        return true;
    }
    // Track if we need to push this group to user storage
    let shouldPushGroup = false;
    // Compare and sync name metadata
    const shouldPushForName = await (0, metadata_1.compareAndSyncMetadata)({
        context,
        localMetadata: groupPersistedMetadata?.name,
        userStorageMetadata: groupFromUserStorage.name,
        validateUserStorageValue: (value) => types_1.UserStorageSyncedWalletGroupSchema.schema.name.schema.value.is(value),
        applyLocalUpdate: (name) => {
            context.controller.setAccountGroupName(localGroup.id, name, true);
        },
        analytics: {
            action: analytics_1.BackupAndSyncAnalyticsEvent.GroupRenamed,
            profileId,
        },
    });
    shouldPushGroup || (shouldPushGroup = shouldPushForName);
    // Compare and sync pinned metadata
    const shouldPushForPinned = await (0, metadata_1.compareAndSyncMetadata)({
        context,
        localMetadata: groupPersistedMetadata?.pinned,
        userStorageMetadata: groupFromUserStorage.pinned,
        validateUserStorageValue: (value) => types_1.UserStorageSyncedWalletGroupSchema.schema.pinned.schema.value.is(value),
        applyLocalUpdate: (pinned) => {
            context.controller.setAccountGroupPinned(localGroup.id, pinned);
        },
        analytics: {
            action: analytics_1.BackupAndSyncAnalyticsEvent.GroupPinnedStatusChanged,
            profileId,
        },
    });
    shouldPushGroup || (shouldPushGroup = shouldPushForPinned);
    // Compare and sync hidden metadata
    const shouldPushForHidden = await (0, metadata_1.compareAndSyncMetadata)({
        context,
        localMetadata: groupPersistedMetadata?.hidden,
        userStorageMetadata: groupFromUserStorage.hidden,
        validateUserStorageValue: (value) => types_1.UserStorageSyncedWalletGroupSchema.schema.hidden.schema.value.is(value),
        applyLocalUpdate: (hidden) => {
            context.controller.setAccountGroupHidden(localGroup.id, hidden);
        },
        analytics: {
            action: analytics_1.BackupAndSyncAnalyticsEvent.GroupHiddenStatusChanged,
            profileId,
        },
    });
    shouldPushGroup || (shouldPushGroup = shouldPushForHidden);
    return shouldPushGroup;
}
/**
 * Syncs a single group's metadata between local and user storage.
 *
 * @param context - The sync context containing controller and messenger.
 * @param localGroup - The local group to sync.
 * @param groupFromUserStorage - The group from user storage to compare against (or null if it doesn't exist).
 * @param entropySourceId - The entropy source ID.
 * @param profileId - The profile ID for analytics.
 */
async function syncGroupMetadata(context, localGroup, groupFromUserStorage, entropySourceId, profileId) {
    const shouldPushGroup = await syncGroupMetadataAndCheckIfPushNeeded(context, localGroup, groupFromUserStorage, profileId);
    if (shouldPushGroup) {
        await (0, network_operations_1.pushGroupToUserStorage)(context, localGroup, entropySourceId);
    }
}
exports.syncGroupMetadata = syncGroupMetadata;
/**
 * Syncs group metadata between local and user storage.
 *
 * @param context - The sync context containing controller and messenger.
 * @param wallet - The local wallet containing the groups.
 * @param groupsFromUserStorage - Array of groups from user storage.
 * @param entropySourceId - The entropy source ID.
 * @param profileId - The profile ID for analytics.
 */
async function syncGroupsMetadata(context, wallet, groupsFromUserStorage, entropySourceId, profileId) {
    const localSyncableGroupsToBePushedToUserStorage = [];
    const localSyncableGroups = (0, utils_1.getLocalGroupsForEntropyWallet)(context, wallet.id);
    for (const localSyncableGroup of localSyncableGroups) {
        const groupFromUserStorage = groupsFromUserStorage.find((group) => group.groupIndex === localSyncableGroup.metadata.entropy.groupIndex);
        const shouldPushGroup = await syncGroupMetadataAndCheckIfPushNeeded(context, localSyncableGroup, groupFromUserStorage, profileId);
        // Add to push list if any metadata needs to be updated in user storage
        if (shouldPushGroup) {
            localSyncableGroupsToBePushedToUserStorage.push(localSyncableGroup);
        }
    }
    // Push all groups that need to be updated to user storage
    if (localSyncableGroupsToBePushedToUserStorage.length > 0) {
        await (0, network_operations_1.pushGroupToUserStorageBatch)(context, localSyncableGroupsToBePushedToUserStorage, entropySourceId);
    }
}
exports.syncGroupsMetadata = syncGroupsMetadata;

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\syncing\\group.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\syncing\\index.cjs", {"./group.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\syncing\\group.cjs","./legacy.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\syncing\\legacy.cjs","./metadata.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\syncing\\metadata.cjs","./wallet.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\syncing\\wallet.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cbackup-and-sync%5Csyncing%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./group.cjs"), exports);
__exportStar(require("./legacy.cjs"), exports);
__exportStar(require("./wallet.cjs"), exports);
__exportStar(require("./metadata.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\syncing\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\syncing\\legacy.cjs", {"../../logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\logger.cjs","../analytics/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\analytics\\index.cjs","../user-storage/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\index.cjs","../utils/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\utils\\index.cjs","./group.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\syncing\\group.cjs","@metamask/account-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\index.cjs","@metamask/accounts-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\accounts-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cbackup-and-sync%5Csyncing%5Clegacy.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.performLegacyAccountSyncing = void 0;
const account_api_1 = require("@metamask/account-api");
const accounts_controller_1 = require("@metamask/accounts-controller");
const group_1 = require("./group.cjs");
const logger_1 = require("../../logger.cjs");
const analytics_1 = require("../analytics/index.cjs");
const user_storage_1 = require("../user-storage/index.cjs");
const utils_1 = require("../utils/index.cjs");
/**
 * Performs a stripped down version of legacy account syncing, replacing the current
 * UserStorageController:syncInternalAccountsWithUserStorage call.
 * This ensures legacy (V1) account syncing data is correctly migrated to
 * the new AccountTreeController data structure. It should only happen
 * once per wallet.
 *
 * @param context - The sync context containing controller and messenger.
 * @param entropySourceId - The entropy source ID.
 * @param profileId - The profile ID for analytics.
 */
const performLegacyAccountSyncing = async (context, entropySourceId, profileId) => {
    // 1. Get legacy account syncing data
    const legacyAccountsFromUserStorage = await (0, user_storage_1.getAllLegacyUserStorageAccounts)(context, entropySourceId);
    if (legacyAccountsFromUserStorage.length === 0) {
        (0, logger_1.backupAndSyncLogger)('No legacy accounts, skipping legacy account syncing');
        context.emitAnalyticsEventFn({
            action: analytics_1.BackupAndSyncAnalyticsEvent.LegacySyncingDone,
            profileId,
        });
        return;
    }
    // 2. Create account groups accordingly
    const numberOfAccountGroupsToCreate = legacyAccountsFromUserStorage.length;
    (0, logger_1.backupAndSyncLogger)(`Creating ${numberOfAccountGroupsToCreate} account groups for legacy accounts`);
    if (numberOfAccountGroupsToCreate > 0) {
        // Creating multichain account group is idempotent, so we can safely
        // re-create every groups starting from 0.
        for (let i = 0; i < numberOfAccountGroupsToCreate; i++) {
            (0, logger_1.backupAndSyncLogger)(`Creating account group ${i} for legacy account`);
            await (0, group_1.createMultichainAccountGroup)(context, entropySourceId, i, profileId, analytics_1.BackupAndSyncAnalyticsEvent.LegacyGroupAddedFromAccount);
        }
    }
    // 3. Rename account groups if needed
    const localAccountGroups = (0, utils_1.getLocalGroupsForEntropyWallet)(context, (0, account_api_1.toMultichainAccountWalletId)(entropySourceId));
    for (const legacyAccount of legacyAccountsFromUserStorage) {
        // n: name
        // a: EVM address
        const { n, a } = legacyAccount;
        if (!a || !n) {
            (0, logger_1.backupAndSyncLogger)(`Legacy account data is missing name or address, skipping account: ${JSON.stringify(legacyAccount)}`);
            continue;
        }
        if (n) {
            // Find the local group that corresponds to this EVM address
            const localAccountId = (0, accounts_controller_1.getUUIDFromAddressOfNormalAccount)(a);
            const localGroup = localAccountGroups.find((group) => group.accounts.includes(localAccountId));
            if (localGroup) {
                context.controller.setAccountGroupName(localGroup.id, n, true);
                context.emitAnalyticsEventFn({
                    action: analytics_1.BackupAndSyncAnalyticsEvent.LegacyGroupRenamed,
                    profileId,
                    additionalDescription: `Renamed legacy group ${localGroup.id} to ${n}`,
                });
            }
        }
    }
    context.emitAnalyticsEventFn({
        action: analytics_1.BackupAndSyncAnalyticsEvent.LegacySyncingDone,
        profileId,
    });
};
exports.performLegacyAccountSyncing = performLegacyAccountSyncing;

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\syncing\\legacy.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\syncing\\metadata.cjs", {"fast-deep-equal":"D:\\code\\v\\metamask-extension\\node_modules\\fast-deep-equal\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cbackup-and-sync%5Csyncing%5Cmetadata.cjs
      return function (require, module, exports) {
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.compareAndSyncMetadata = void 0;
const fast_deep_equal_1 = __importDefault(require("fast-deep-equal"));
/**
 * Compares metadata between local and user storage, applying the most recent version.
 *
 * @param options - Configuration object for metadata comparison.
 * @param options.context - The backup and sync context containing controller and messenger.
 * @param options.localMetadata - The local metadata object.
 * @param options.localMetadata.value - The local metadata value.
 * @param options.localMetadata.lastUpdatedAt - The local metadata timestamp.
 * @param options.userStorageMetadata - The user storage metadata object.
 * @param options.userStorageMetadata.value - The user storage metadata value.
 * @param options.userStorageMetadata.lastUpdatedAt - The user storage metadata timestamp.
 * @param options.applyLocalUpdate - Function to apply the user storage value locally.
 * @param options.validateUserStorageValue - Function to validate user storage data.
 * @param options.analytics - Optional analytics configuration for tracking updates.
 * @param options.analytics.action - The analytics action for the event.
 * @param options.analytics.profileId - The profile ID for analytics.
 * @returns Promise resolving to true if local data should be pushed to user storage.
 */
async function compareAndSyncMetadata({ context, localMetadata, userStorageMetadata, applyLocalUpdate, validateUserStorageValue, analytics, }) {
    const localValue = localMetadata?.value;
    const localTimestamp = localMetadata?.lastUpdatedAt;
    const userStorageValue = userStorageMetadata?.value;
    const userStorageTimestamp = userStorageMetadata?.lastUpdatedAt;
    const isSameValue = (0, fast_deep_equal_1.default)(localValue, userStorageValue);
    if (isSameValue) {
        return false; // No sync needed, values are the same
    }
    const isUserStorageMoreRecent = localTimestamp !== undefined &&
        userStorageTimestamp !== undefined &&
        localTimestamp < userStorageTimestamp;
    // Validate user storage value using the provided validator
    const isUserStorageValueValid = validateUserStorageValue(userStorageValue);
    if ((isUserStorageMoreRecent || !localMetadata) && isUserStorageValueValid) {
        // User storage is more recent and valid, apply it locally
        await applyLocalUpdate(userStorageValue);
        // Emit analytics event if provided
        if (analytics) {
            context.emitAnalyticsEventFn({
                action: analytics.action,
                profileId: analytics.profileId,
            });
        }
        return false; // Don't push to user storage since we just pulled from it
    }
    return true; // Local is more recent or user storage is invalid, should push to user storage
}
exports.compareAndSyncMetadata = compareAndSyncMetadata;

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\syncing\\metadata.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\syncing\\wallet.cjs", {"../../logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\logger.cjs","../analytics/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\analytics\\index.cjs","../types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\types.cjs","../user-storage/network-operations.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\network-operations.cjs","./metadata.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\syncing\\metadata.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cbackup-and-sync%5Csyncing%5Cwallet.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.syncWalletMetadata = exports.syncWalletMetadataAndCheckIfPushNeeded = void 0;
const metadata_1 = require("./metadata.cjs");
const logger_1 = require("../../logger.cjs");
const analytics_1 = require("../analytics/index.cjs");
const types_1 = require("../types.cjs");
const network_operations_1 = require("../user-storage/network-operations.cjs");
/**
 * Syncs wallet metadata fields and determines if the wallet needs to be pushed to user storage.
 *
 * @param context - The sync context containing controller and messenger.
 * @param localWallet - The local wallet to sync.
 * @param walletFromUserStorage - The wallet data from user storage, if any.
 * @param profileId - The profile ID for analytics.
 * @returns Promise resolving to true if the wallet should be pushed to user storage.
 */
async function syncWalletMetadataAndCheckIfPushNeeded(context, localWallet, walletFromUserStorage, profileId) {
    const walletPersistedMetadata = context.controller.state.accountWalletsMetadata[localWallet.id];
    if (!walletFromUserStorage ||
        Object.keys(walletFromUserStorage).length === 0) {
        (0, logger_1.backupAndSyncLogger)(`Wallet ${localWallet.id} did not exist in user storage, pushing to user storage...`);
        return true;
    }
    // Track if we need to push this wallet to user storage
    let shouldPushWallet = false;
    // Compare and sync name metadata
    const shouldPushForName = await (0, metadata_1.compareAndSyncMetadata)({
        context,
        localMetadata: walletPersistedMetadata?.name,
        userStorageMetadata: walletFromUserStorage.name,
        validateUserStorageValue: (value) => types_1.UserStorageSyncedWalletSchema.schema.name.schema.value.is(value),
        applyLocalUpdate: (name) => {
            context.controller.setAccountWalletName(localWallet.id, name);
        },
        analytics: {
            action: analytics_1.BackupAndSyncAnalyticsEvent.WalletRenamed,
            profileId,
        },
    });
    shouldPushWallet || (shouldPushWallet = shouldPushForName);
    // Avoid re-triggering legacy-syncing (in case this field is missing on the remote
    // wallet object).
    const shouldPushForMissingLegacyField = !Object.prototype.hasOwnProperty.call(walletFromUserStorage, 'isLegacyAccountSyncingDisabled');
    shouldPushWallet || (shouldPushWallet = shouldPushForMissingLegacyField);
    return shouldPushWallet;
}
exports.syncWalletMetadataAndCheckIfPushNeeded = syncWalletMetadataAndCheckIfPushNeeded;
/**
 * Syncs wallet metadata and pushes it to user storage if needed.
 *
 * @param context - The sync context containing controller and messenger.
 * @param localWallet - The local wallet to sync.
 * @param walletFromUserStorage - The wallet data from user storage, if any.
 * @param profileId - The profile ID for analytics.
 */
async function syncWalletMetadata(context, localWallet, walletFromUserStorage, profileId) {
    const shouldPushToUserStorage = await syncWalletMetadataAndCheckIfPushNeeded(context, localWallet, walletFromUserStorage, profileId);
    if (shouldPushToUserStorage) {
        await (0, network_operations_1.pushWalletToUserStorage)(context, localWallet);
    }
}
exports.syncWalletMetadata = syncWalletMetadata;

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\syncing\\wallet.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\types.cjs", {"@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cbackup-and-sync%5Ctypes.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LegacyUserStorageSyncedAccountSchema = exports.UserStorageSyncedWalletGroupSchema = exports.UserStorageSyncedWalletSchema = void 0;
const superstruct_1 = require("@metamask/superstruct");
/**
 * Schema for an updatable field with value and timestamp.
 *
 * @param valueSchema - The schema for the value field.
 * @returns A superstruct schema for an updatable field.
 */
const UpdatableFieldSchema = (valueSchema) => (0, superstruct_1.object)({
    value: valueSchema,
    lastUpdatedAt: (0, superstruct_1.number)(),
});
/**
 * Superstruct schema for UserStorageSyncedWallet validation.
 */
exports.UserStorageSyncedWalletSchema = (0, superstruct_1.object)({
    name: (0, superstruct_1.optional)(UpdatableFieldSchema((0, superstruct_1.string)())),
    isLegacyAccountSyncingDisabled: (0, superstruct_1.optional)((0, superstruct_1.boolean)()),
});
/**
 * Superstruct schema for UserStorageSyncedWalletGroup validation.
 */
exports.UserStorageSyncedWalletGroupSchema = (0, superstruct_1.object)({
    name: (0, superstruct_1.optional)(UpdatableFieldSchema((0, superstruct_1.string)())),
    pinned: (0, superstruct_1.optional)(UpdatableFieldSchema((0, superstruct_1.boolean)())),
    hidden: (0, superstruct_1.optional)(UpdatableFieldSchema((0, superstruct_1.boolean)())),
    groupIndex: (0, superstruct_1.number)(),
});
/**
 * Superstruct schema for LegacyUserStorageSyncedAccount validation.
 */
exports.LegacyUserStorageSyncedAccountSchema = (0, superstruct_1.object)({
    v: (0, superstruct_1.optional)((0, superstruct_1.string)()),
    i: (0, superstruct_1.optional)((0, superstruct_1.string)()),
    a: (0, superstruct_1.optional)((0, superstruct_1.string)()),
    n: (0, superstruct_1.optional)((0, superstruct_1.string)()),
    nlu: (0, superstruct_1.optional)((0, superstruct_1.number)()),
});

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\types.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\constants.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cbackup-and-sync%5Cuser-storage%5Cconstants.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.USER_STORAGE_GROUPS_FEATURE_KEY = exports.USER_STORAGE_WALLETS_FEATURE_ENTRY_KEY = exports.USER_STORAGE_WALLETS_FEATURE_KEY = exports.USER_STORAGE_FEATURE_PREFIX = void 0;
exports.USER_STORAGE_FEATURE_PREFIX = 'multichain_accounts';
exports.USER_STORAGE_WALLETS_FEATURE_KEY = `${exports.USER_STORAGE_FEATURE_PREFIX}_wallets`;
exports.USER_STORAGE_WALLETS_FEATURE_ENTRY_KEY = 'wallet';
exports.USER_STORAGE_GROUPS_FEATURE_KEY = `${exports.USER_STORAGE_FEATURE_PREFIX}_groups`;

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\constants.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\format-utils.cjs", {"./validation.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\validation.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cbackup-and-sync%5Cuser-storage%5Cformat-utils.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseLegacyAccountFromUserStorageResponse = exports.parseGroupFromUserStorageResponse = exports.parseWalletFromUserStorageResponse = exports.formatGroupForUserStorageUsage = exports.formatWalletForUserStorageUsage = void 0;
const validation_1 = require("./validation.cjs");
/**
 * Formats the wallet for user storage usage.
 * This function extracts the necessary metadata from the wallet
 * and formats it according to the user storage requirements.
 *
 * @param context - The backup and sync context.
 * @param wallet - The wallet object to format.
 * @returns The formatted wallet for user storage.
 */
const formatWalletForUserStorageUsage = (context, wallet) => {
    // This can be null if the user has not manually set a name
    const persistedWalletMetadata = context.controller.state.accountWalletsMetadata[wallet.id];
    return {
        ...(persistedWalletMetadata ?? {}),
        isLegacyAccountSyncingDisabled: true, // If we're here, it means legacy account syncing has been performed at least once, so we can disable it for this wallet.
    };
};
exports.formatWalletForUserStorageUsage = formatWalletForUserStorageUsage;
/**
 * Formats the group for user storage usage.
 * This function extracts the necessary metadata from the group
 * and formats it according to the user storage requirements.
 *
 * @param context - The backup and sync context.
 * @param group - The group object to format.
 * @returns The formatted group for user storage.
 */
const formatGroupForUserStorageUsage = (context, group) => {
    // This can be null if the user has not manually set a name, pinned or hidden the group
    const persistedGroupMetadata = context.controller.state.accountGroupsMetadata[group.id];
    return {
        ...(persistedGroupMetadata ?? {}),
        groupIndex: group.metadata.entropy.groupIndex,
    };
};
exports.formatGroupForUserStorageUsage = formatGroupForUserStorageUsage;
/**
 * Parses the wallet from user storage response.
 * This function attempts to parse the wallet data from a string format
 * and returns it as a UserStorageSyncedWallet object.
 *
 * @param wallet - The wallet data in string format.
 * @returns The parsed UserStorageSyncedWallet object.
 * @throws If the wallet data is not in valid JSON format or fails validation.
 */
const parseWalletFromUserStorageResponse = (wallet) => {
    try {
        const walletData = JSON.parse(wallet);
        (0, validation_1.assertValidUserStorageWallet)(walletData);
        return walletData;
    }
    catch (error) {
        throw new Error(`Error trying to parse wallet from user storage response: ${error instanceof Error ? error.message : String(error)}`);
    }
};
exports.parseWalletFromUserStorageResponse = parseWalletFromUserStorageResponse;
/**
 * Parses the group from user storage response.
 * This function attempts to parse the group data from a string format
 * and returns it as a UserStorageSyncedWalletGroup object.
 *
 * @param group - The group data in string format.
 * @returns The parsed UserStorageSyncedWalletGroup object.
 * @throws If the group data is not in valid JSON format or fails validation.
 */
const parseGroupFromUserStorageResponse = (group) => {
    try {
        const groupData = JSON.parse(group);
        (0, validation_1.assertValidUserStorageGroup)(groupData);
        return groupData;
    }
    catch (error) {
        throw new Error(`Error trying to parse group from user storage response: ${error instanceof Error ? error.message : String(error)}`);
    }
};
exports.parseGroupFromUserStorageResponse = parseGroupFromUserStorageResponse;
/**
 * Parses the legacy account from user storage response.
 * This function attempts to parse the account data from a string format
 * and returns it as a LegacyUserStorageSyncedAccount object.
 *
 * @param account - The account data in string format.
 * @returns The parsed LegacyUserStorageSyncedAccount object.
 * @throws If the account data is not in valid JSON format or fails validation.
 */
const parseLegacyAccountFromUserStorageResponse = (account) => {
    try {
        const accountData = JSON.parse(account);
        (0, validation_1.assertValidLegacyUserStorageAccount)(accountData);
        return accountData;
    }
    catch (error) {
        throw new Error(`Error trying to parse legacy account from user storage response: ${error instanceof Error ? error.message : String(error)}`);
    }
};
exports.parseLegacyAccountFromUserStorageResponse = parseLegacyAccountFromUserStorageResponse;

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\format-utils.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\index.cjs", {"./format-utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\format-utils.cjs","./network-operations.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\network-operations.cjs","./network-utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\network-utils.cjs","./validation.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\validation.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cbackup-and-sync%5Cuser-storage%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./format-utils.cjs"), exports);
__exportStar(require("./network-utils.cjs"), exports);
__exportStar(require("./network-operations.cjs"), exports);
__exportStar(require("./validation.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\network-operations.cjs", {"../../logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\logger.cjs","./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\constants.cjs","./format-utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\format-utils.cjs","./network-utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\network-utils.cjs","@metamask/profile-sync-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\profile-sync-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cbackup-and-sync%5Cuser-storage%5Cnetwork-operations.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAllLegacyUserStorageAccounts = exports.pushGroupToUserStorageBatch = exports.pushGroupToUserStorage = exports.getGroupFromUserStorage = exports.getAllGroupsFromUserStorage = exports.pushWalletToUserStorage = exports.getWalletFromUserStorage = void 0;
const profile_sync_controller_1 = require("@metamask/profile-sync-controller");
const constants_1 = require("./constants.cjs");
const format_utils_1 = require("./format-utils.cjs");
const network_utils_1 = require("./network-utils.cjs");
const logger_1 = require("../../logger.cjs");
/**
 * Retrieves the wallet from user storage.
 *
 * @param context - The backup and sync context.
 * @param entropySourceId - The entropy source ID.
 * @returns The wallet from user storage or null if not found or invalid.
 * @throws When network operations fail after maximum retry attempts.
 * @throws When messenger calls to UserStorageController fail due to authentication errors, encryption/decryption failures, or network issues.
 */
const getWalletFromUserStorage = async (context, entropySourceId) => {
    return (0, network_utils_1.executeWithRetry)(async () => {
        const walletData = await context.messenger.call('UserStorageController:performGetStorage', `${constants_1.USER_STORAGE_WALLETS_FEATURE_KEY}.${constants_1.USER_STORAGE_WALLETS_FEATURE_ENTRY_KEY}`, entropySourceId);
        if (!walletData) {
            return null;
        }
        try {
            (0, logger_1.backupAndSyncLogger)(`Retrieved wallet data from user storage: ${JSON.stringify(walletData)}`);
            return (0, format_utils_1.parseWalletFromUserStorageResponse)(walletData);
        }
        catch (error) {
            (0, logger_1.backupAndSyncLogger)(`Failed to parse wallet data from user storage: ${error instanceof Error ? error.message : String(error)}`);
            return null;
        }
    });
};
exports.getWalletFromUserStorage = getWalletFromUserStorage;
/**
 * Pushes the wallet to user storage.
 *
 * @param context - The backup and sync context.
 * @param wallet - The wallet to push to user storage.
 * @returns A promise that resolves when the operation is complete.
 * @throws When network operations fail after maximum retry attempts.
 * @throws When messenger calls to UserStorageController fail due to authentication errors, encryption/decryption failures, or network issues.
 * @throws When JSON.stringify fails on the formatted wallet data.
 */
const pushWalletToUserStorage = async (context, wallet) => {
    return (0, network_utils_1.executeWithRetry)(async () => {
        const formattedWallet = (0, format_utils_1.formatWalletForUserStorageUsage)(context, wallet);
        const stringifiedWallet = JSON.stringify(formattedWallet);
        const entropySourceId = wallet.metadata.entropy.id;
        (0, logger_1.backupAndSyncLogger)(`Pushing wallet to user storage: ${stringifiedWallet}`);
        return await context.messenger.call('UserStorageController:performSetStorage', `${constants_1.USER_STORAGE_WALLETS_FEATURE_KEY}.${constants_1.USER_STORAGE_WALLETS_FEATURE_ENTRY_KEY}`, stringifiedWallet, entropySourceId);
    });
};
exports.pushWalletToUserStorage = pushWalletToUserStorage;
/**
 * Retrieves all groups from user storage.
 *
 * @param context - The backup and sync context.
 * @param entropySourceId - The entropy source ID.
 * @returns An array of groups from user storage.
 * @throws When network operations fail after maximum retry attempts.
 * @throws When messenger calls to UserStorageController fail due to authentication errors, encryption/decryption failures, or network issues.
 */
const getAllGroupsFromUserStorage = async (context, entropySourceId) => {
    return (0, network_utils_1.executeWithRetry)(async () => {
        const groupData = await context.messenger.call('UserStorageController:performGetStorageAllFeatureEntries', `${constants_1.USER_STORAGE_GROUPS_FEATURE_KEY}`, entropySourceId);
        if (!groupData) {
            return [];
        }
        const allGroups = groupData
            .map((stringifiedGroup) => {
            try {
                return (0, format_utils_1.parseGroupFromUserStorageResponse)(stringifiedGroup);
            }
            catch (error) {
                (0, logger_1.backupAndSyncLogger)(`Failed to parse group data from user storage: ${error instanceof Error ? error.message : String(error)}`);
                return null;
            }
        })
            .filter((group) => group !== null);
        (0, logger_1.backupAndSyncLogger)(`Retrieved groups from user storage: ${JSON.stringify(allGroups)}`);
        return allGroups;
    });
};
exports.getAllGroupsFromUserStorage = getAllGroupsFromUserStorage;
/**
 * Retrieves a single group from user storage by group index.
 *
 * @param context - The backup and sync context.
 * @param entropySourceId - The entropy source ID.
 * @param groupIndex - The group index to retrieve.
 * @returns The group from user storage or null if not found or invalid.
 * @throws When network operations fail after maximum retry attempts.
 * @throws When messenger calls to UserStorageController fail due to authentication errors, encryption/decryption failures, or network issues.
 */
const getGroupFromUserStorage = async (context, entropySourceId, groupIndex) => {
    return (0, network_utils_1.executeWithRetry)(async () => {
        const groupData = await context.messenger.call('UserStorageController:performGetStorage', `${constants_1.USER_STORAGE_GROUPS_FEATURE_KEY}.${groupIndex}`, entropySourceId);
        if (!groupData) {
            return null;
        }
        try {
            return (0, format_utils_1.parseGroupFromUserStorageResponse)(groupData);
        }
        catch (error) {
            (0, logger_1.backupAndSyncLogger)(`Failed to parse group data from user storage: ${error instanceof Error ? error.message : String(error)}`);
            return null;
        }
    });
};
exports.getGroupFromUserStorage = getGroupFromUserStorage;
/**
 * Pushes a group to user storage.
 *
 * @param context - The backup and sync context.
 * @param group - The group to push to user storage.
 * @param entropySourceId - The entropy source ID.
 * @returns A promise that resolves when the operation is complete.
 * @throws When network operations fail after maximum retry attempts.
 * @throws When messenger calls to UserStorageController fail due to authentication errors, encryption/decryption failures, or network issues.
 * @throws When JSON.stringify fails on the formatted group data.
 */
const pushGroupToUserStorage = async (context, group, entropySourceId) => {
    return (0, network_utils_1.executeWithRetry)(async () => {
        const formattedGroup = (0, format_utils_1.formatGroupForUserStorageUsage)(context, group);
        const stringifiedGroup = JSON.stringify(formattedGroup);
        (0, logger_1.backupAndSyncLogger)(`Pushing group to user storage: ${stringifiedGroup}`);
        return await context.messenger.call('UserStorageController:performSetStorage', `${constants_1.USER_STORAGE_GROUPS_FEATURE_KEY}.${formattedGroup.groupIndex}`, stringifiedGroup, entropySourceId);
    });
};
exports.pushGroupToUserStorage = pushGroupToUserStorage;
/**
 * Pushes a batch of groups to user storage.
 *
 * @param context - The backup and sync context.
 * @param groups - The groups to push to user storage.
 * @param entropySourceId - The entropy source ID.
 * @returns A promise that resolves when the operation is complete.
 * @throws When network operations fail after maximum retry attempts.
 * @throws When messenger calls to UserStorageController fail due to authentication errors, encryption/decryption failures, or network issues.
 * @throws When JSON.stringify fails on any of the formatted group data.
 */
const pushGroupToUserStorageBatch = async (context, groups, entropySourceId) => {
    return (0, network_utils_1.executeWithRetry)(async () => {
        const formattedGroups = groups.map((group) => (0, format_utils_1.formatGroupForUserStorageUsage)(context, group));
        const entries = formattedGroups.map((group) => [
            String(group.groupIndex),
            JSON.stringify(group),
        ]);
        (0, logger_1.backupAndSyncLogger)(`Pushing groups to user storage: ${entries.map(([_, value]) => value).join(', ')}`);
        return await context.messenger.call('UserStorageController:performBatchSetStorage', constants_1.USER_STORAGE_GROUPS_FEATURE_KEY, entries, entropySourceId);
    });
};
exports.pushGroupToUserStorageBatch = pushGroupToUserStorageBatch;
/**
 * Retrieves legacy user storage accounts for a specific entropy source ID.
 *
 * @param context - The backup and sync context.
 * @param entropySourceId - The entropy source ID to retrieve data for.
 * @returns A promise that resolves with the legacy user storage accounts.
 * @throws When network operations fail after maximum retry attempts.
 * @throws When messenger calls to UserStorageController fail due to authentication errors, encryption/decryption failures, or network issues.
 */
const getAllLegacyUserStorageAccounts = async (context, entropySourceId) => {
    return (0, network_utils_1.executeWithRetry)(async () => {
        const accountsData = await context.messenger.call('UserStorageController:performGetStorageAllFeatureEntries', profile_sync_controller_1.SDK.USER_STORAGE_FEATURE_NAMES.accounts, entropySourceId);
        if (!accountsData) {
            return [];
        }
        const allAccounts = accountsData
            .map((stringifiedAccount) => {
            try {
                return (0, format_utils_1.parseLegacyAccountFromUserStorageResponse)(stringifiedAccount);
            }
            catch (error) {
                (0, logger_1.backupAndSyncLogger)(`Failed to parse legacy account data from user storage: ${error instanceof Error ? error.message : String(error)}`);
                return null;
            }
        })
            .filter((account) => account !== null);
        (0, logger_1.backupAndSyncLogger)(`Retrieved legacy accounts from user storage: ${JSON.stringify(allAccounts)}`);
        return allAccounts;
    });
};
exports.getAllLegacyUserStorageAccounts = getAllLegacyUserStorageAccounts;

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\network-operations.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\network-utils.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cbackup-and-sync%5Cuser-storage%5Cnetwork-utils.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.executeWithRetry = void 0;
/**
 * Executes a network operation with retry logic for transient failures.
 *
 * @param operation - The async operation to execute.
 * @param maxRetries - Maximum number of retry attempts.
 * @param baseDelayMs - Base delay between retries in milliseconds.
 * @returns Promise that resolves with the operation result.
 */
async function executeWithRetry(operation, maxRetries = 3, baseDelayMs = 1000) {
    let lastError = new Error('Unknown error');
    for (let attempt = 0; attempt <= maxRetries; attempt++) {
        try {
            return await operation();
        }
        catch (error) {
            lastError = error instanceof Error ? error : new Error(String(error));
            if (attempt === maxRetries) {
                break; // Exit loop after final attempt
            }
            // Calculate exponential backoff delay
            const delayMs = baseDelayMs * Math.pow(2, attempt);
            // Wait before retry
            await new Promise((resolve) => setTimeout(resolve, delayMs));
        }
    }
    // This will only be reached if all attempts failed
    throw lastError;
}
exports.executeWithRetry = executeWithRetry;

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\network-utils.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\validation.cjs", {"../types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\types.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cbackup-and-sync%5Cuser-storage%5Cvalidation.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assertValidLegacyUserStorageAccount = exports.assertValidUserStorageGroup = exports.assertValidUserStorageWallet = void 0;
const superstruct_1 = require("@metamask/superstruct");
const types_1 = require("../types.cjs");
/**
 * Formats validation error messages for user storage data.
 *
 * @param error - The StructError thrown during validation.
 * @returns A formatted string of validation error messages.
 */
const formatValidationErrorMessages = (error) => {
    const validationFailures = error
        .failures()
        .map(({ path, message }) => `[${path.join('.')}] ${message}`)
        .join(', ');
    return `Invalid user storage data: ${validationFailures}`;
};
/**
 * Validates and asserts user storage wallet data, throwing detailed errors if invalid.
 *
 * @param walletData - The wallet data from user storage to validate.
 * @throws StructError if the wallet data is invalid.
 */
function assertValidUserStorageWallet(walletData) {
    try {
        (0, superstruct_1.assert)(walletData, types_1.UserStorageSyncedWalletSchema);
    }
    catch (error) {
        if (error instanceof superstruct_1.StructError) {
            throw new Error(`Invalid user storage wallet data: ${formatValidationErrorMessages(error)}`);
        }
        /* istanbul ignore next */
        throw error;
    }
}
exports.assertValidUserStorageWallet = assertValidUserStorageWallet;
/**
 * Validates and asserts user storage group data, throwing detailed errors if invalid.
 *
 * @param groupData - The group data from user storage to validate.
 * @throws StructError if the group data is invalid.
 */
function assertValidUserStorageGroup(groupData) {
    try {
        (0, superstruct_1.assert)(groupData, types_1.UserStorageSyncedWalletGroupSchema);
    }
    catch (error) {
        if (error instanceof superstruct_1.StructError) {
            throw new Error(`Invalid user storage group data: ${formatValidationErrorMessages(error)}`);
        }
        /* istanbul ignore next */
        throw error;
    }
}
exports.assertValidUserStorageGroup = assertValidUserStorageGroup;
/**
 * Validates and asserts legacy user storage account data, throwing detailed errors if invalid.
 *
 * @param accountData - The account data from user storage to validate.
 * @throws StructError if the account data is invalid.
 */
function assertValidLegacyUserStorageAccount(accountData) {
    try {
        (0, superstruct_1.assert)(accountData, types_1.LegacyUserStorageSyncedAccountSchema);
    }
    catch (error) {
        if (error instanceof superstruct_1.StructError) {
            throw new Error(`Invalid legacy user storage account data: ${formatValidationErrorMessages(error)}`);
        }
        /* istanbul ignore next */
        throw error;
    }
}
exports.assertValidLegacyUserStorageAccount = assertValidLegacyUserStorageAccount;

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\validation.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\utils\\controller.cjs", {"../../logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\logger.cjs","@metamask/account-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cbackup-and-sync%5Cutils%5Ccontroller.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.restoreStateFromSnapshot = exports.createStateSnapshot = exports.getLocalGroupsForEntropyWallet = exports.getLocalGroupForEntropyWallet = exports.getLocalEntropyWallets = void 0;
const account_api_1 = require("@metamask/account-api");
const logger_1 = require("../../logger.cjs");
/**
 * Gets all local entropy wallets that can be synced.
 *
 * @param context - The backup and sync context.
 * @returns Array of entropy wallet objects.
 */
function getLocalEntropyWallets(context) {
    return Object.values(context.controller.state.accountTree.wallets).filter((wallet) => wallet.type === account_api_1.AccountWalletType.Entropy);
}
exports.getLocalEntropyWallets = getLocalEntropyWallets;
/**
 * Gets the local group for a specific entropy wallet by its source ID and group index.
 *
 * @param context - The backup and sync context.
 * @param entropySourceId - The entropy source ID.
 * @param groupIndex - The group index.
 * @returns The local group object if it exists, undefined otherwise.
 */
const getLocalGroupForEntropyWallet = (context, entropySourceId, groupIndex) => {
    const walletId = (0, account_api_1.toMultichainAccountWalletId)(entropySourceId);
    const wallet = context.controller.state.accountTree.wallets[walletId];
    if (!wallet || wallet.type !== account_api_1.AccountWalletType.Entropy) {
        (0, logger_1.backupAndSyncLogger)(`Wallet ${walletId} not found or is not an entropy wallet`);
        return undefined;
    }
    const groupId = (0, account_api_1.toMultichainAccountGroupId)(walletId, groupIndex);
    return wallet.groups[groupId];
};
exports.getLocalGroupForEntropyWallet = getLocalGroupForEntropyWallet;
/**
 * Gets all groups for a specific entropy wallet.
 *
 * @param context - The backup and sync context.
 * @param walletId - The wallet ID to get groups for.
 * @returns Array of multichain account group objects.
 */
function getLocalGroupsForEntropyWallet(context, walletId) {
    const wallet = context.controller.state.accountTree.wallets[walletId];
    if (!wallet || wallet.type !== account_api_1.AccountWalletType.Entropy) {
        (0, logger_1.backupAndSyncLogger)(`Wallet ${walletId} not found or is not an entropy wallet`);
        return [];
    }
    return Object.values(wallet.groups);
}
exports.getLocalGroupsForEntropyWallet = getLocalGroupsForEntropyWallet;
/**
 * Creates a snapshot of the current controller state for rollback purposes.
 * Captures all state including the account tree structure.
 *
 * @param context - The backup and sync context containing controller and messenger.
 * @returns A deep copy of relevant state that can be restored later.
 */
function createStateSnapshot(context) {
    return {
        accountGroupsMetadata: JSON.parse(JSON.stringify(context.controller.state.accountGroupsMetadata)),
        accountWalletsMetadata: JSON.parse(JSON.stringify(context.controller.state.accountWalletsMetadata)),
        selectedAccountGroup: context.controller.state.accountTree.selectedAccountGroup,
        accountTreeWallets: JSON.parse(JSON.stringify(context.controller.state.accountTree.wallets)),
    };
}
exports.createStateSnapshot = createStateSnapshot;
/**
 * Restores state using an update callback.
 * Restores both persisted metadata and the complete account tree structure.
 * Uses the controller's init() method to rebuild internal maps correctly.
 *
 * @param context - The backup and sync context containing controller and messenger.
 * @param snapshot - The state snapshot to restore.
 */
function restoreStateFromSnapshot(context, snapshot) {
    context.controllerStateUpdateFn((state) => {
        state.accountGroupsMetadata = snapshot.accountGroupsMetadata;
        state.accountWalletsMetadata = snapshot.accountWalletsMetadata;
        state.accountTree.selectedAccountGroup = snapshot.selectedAccountGroup;
        state.accountTree.wallets = snapshot.accountTreeWallets;
    });
    // Use init() to rebuild the internal maps from the restored account tree state
    // This ensures that the internal maps (#accountIdToContext and #groupIdToWalletId)
    // are correctly synchronized with the restored account tree structure
    context.controller.init();
}
exports.restoreStateFromSnapshot = restoreStateFromSnapshot;

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\utils\\controller.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\utils\\index.cjs", {"./controller.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\utils\\controller.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cbackup-and-sync%5Cutils%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./controller.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\utils\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\group.cjs", {"@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cgroup.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isAccountGroupNameUnique = exports.isAccountGroupNameUniqueFromWallet = exports.ACCOUNT_TYPE_TO_SORT_ORDER = exports.MAX_SORT_ORDER = void 0;
const keyring_api_1 = require("@metamask/keyring-api");
exports.MAX_SORT_ORDER = 9999;
/**
 * Order of account types.
 */
exports.ACCOUNT_TYPE_TO_SORT_ORDER = {
    [keyring_api_1.EthAccountType.Eoa]: 0,
    [keyring_api_1.EthAccountType.Erc4337]: 1,
    [keyring_api_1.SolAccountType.DataAccount]: 2,
    [keyring_api_1.BtcAccountType.P2pkh]: 3,
    [keyring_api_1.BtcAccountType.P2sh]: 4,
    [keyring_api_1.BtcAccountType.P2wpkh]: 5,
    [keyring_api_1.BtcAccountType.P2tr]: 6,
    [keyring_api_1.TrxAccountType.Eoa]: 7,
    [keyring_api_1.AnyAccountType.Account]: exports.MAX_SORT_ORDER,
};
/**
 * Checks if a group name is unique within a specific wallet.
 *
 * @param wallet - The wallet to check within.
 * @param groupId - The account group ID to exclude from the check.
 * @param name - The name to validate for uniqueness.
 * @returns True if the name is unique within the wallet, false otherwise.
 */
function isAccountGroupNameUniqueFromWallet(wallet, groupId, name) {
    const trimmedName = name.trim();
    // Check for duplicates within this wallet
    for (const group of Object.values(wallet.groups)) {
        if (group.id !== groupId && group.metadata.name.trim() === trimmedName) {
            return false;
        }
    }
    return true;
}
exports.isAccountGroupNameUniqueFromWallet = isAccountGroupNameUniqueFromWallet;
/**
 * Checks if an account group name is unique within the same wallet.
 *
 * @param state - The account tree controller state.
 * @param groupId - The account group ID to exclude from the check.
 * @param name - The name to validate for uniqueness.
 * @returns True if the name is unique within the same wallet, false otherwise.
 * @throws Error if the group ID does not exist.
 */
function isAccountGroupNameUnique(state, groupId, name) {
    // Find the wallet that contains the group being validated
    for (const wallet of Object.values(state.accountTree.wallets)) {
        if (wallet.groups[groupId]) {
            // Use the wallet-specific function for consistency
            return isAccountGroupNameUniqueFromWallet(wallet, groupId, name);
        }
    }
    throw new Error(`Account group with ID "${groupId}" not found in tree`);
}
exports.isAccountGroupNameUnique = isAccountGroupNameUnique;

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\group.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\index.cjs", {"./AccountTreeController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\AccountTreeController.cjs","./backup-and-sync/user-storage/constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\backup-and-sync\\user-storage\\constants.cjs","./group.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\group.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDefaultAccountTreeControllerState = exports.AccountTreeController = exports.USER_STORAGE_WALLETS_FEATURE_KEY = exports.USER_STORAGE_GROUPS_FEATURE_KEY = exports.isAccountGroupNameUnique = void 0;
var group_1 = require("./group.cjs");
Object.defineProperty(exports, "isAccountGroupNameUnique", { enumerable: true, get: function () { return group_1.isAccountGroupNameUnique; } });
var constants_1 = require("./backup-and-sync/user-storage/constants.cjs");
Object.defineProperty(exports, "USER_STORAGE_GROUPS_FEATURE_KEY", { enumerable: true, get: function () { return constants_1.USER_STORAGE_GROUPS_FEATURE_KEY; } });
Object.defineProperty(exports, "USER_STORAGE_WALLETS_FEATURE_KEY", { enumerable: true, get: function () { return constants_1.USER_STORAGE_WALLETS_FEATURE_KEY; } });
var AccountTreeController_1 = require("./AccountTreeController.cjs");
Object.defineProperty(exports, "AccountTreeController", { enumerable: true, get: function () { return AccountTreeController_1.AccountTreeController; } });
Object.defineProperty(exports, "getDefaultAccountTreeControllerState", { enumerable: true, get: function () { return AccountTreeController_1.getDefaultAccountTreeControllerState; } });

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\logger.cjs", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Clogger.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.backupAndSyncLogger = exports.projectLogger = void 0;
const utils_1 = require("@metamask/utils");
exports.projectLogger = (0, utils_1.createProjectLogger)('account-tree-controller');
exports.backupAndSyncLogger = (0, utils_1.createModuleLogger)(exports.projectLogger, 'Backup and sync');

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\logger.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\rule.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Crule.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseRule = void 0;
class BaseRule {
    constructor(messenger) {
        this.messenger = messenger;
    }
    /**
     * Gets computed name for a group based on its accounts.
     *
     * @param group - Group associated to this rule.
     * @returns The computed name based on existing accounts.
     */
    getComputedAccountGroupName(group) {
        const account = this.messenger.call('AccountsController:getAccount', 
        // Type-wise, we are guaranteed to always have at least 1 account.
        group.accounts[0]);
        return account?.metadata.name ?? '';
    }
    /**
     * Gets default prefix name for a group.
     *
     * @param wallet - Wallet of this group.
     * @returns The default prefix name for that group.
     */
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    getDefaultAccountGroupPrefix(wallet) {
        return 'Account';
    }
}
exports.BaseRule = BaseRule;

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\rule.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\rules\\entropy.cjs", {"../rule.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\rule.cjs","@metamask/account-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Crules%5Centropy.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EntropyRule = void 0;
const account_api_1 = require("@metamask/account-api");
const keyring_api_1 = require("@metamask/keyring-api");
const keyring_controller_1 = require("@metamask/keyring-controller");
const rule_1 = require("../rule.cjs");
class EntropyRule extends rule_1.BaseRule {
    constructor() {
        super(...arguments);
        this.walletType = account_api_1.AccountWalletType.Entropy;
        this.groupType = account_api_1.AccountGroupType.MultichainAccount;
    }
    getEntropySourceIndex(entropySource) {
        const { keyrings } = this.messenger.call('KeyringController:getState');
        return keyrings
            .filter((keyring) => keyring.type === keyring_controller_1.KeyringTypes.hd)
            .findIndex((keyring) => keyring.metadata.id === entropySource);
    }
    match(account) {
        if (!(0, account_api_1.isBip44Account)(account)) {
            return undefined;
        }
        const entropySource = account.options.entropy.id;
        const entropySourceIndex = this.getEntropySourceIndex(entropySource);
        if (entropySourceIndex === -1) {
            console.warn(`! Found an unknown entropy ID: "${entropySource}", account "${account.id}" won't be grouped by entropy.`);
            return undefined;
        }
        const walletId = (0, account_api_1.toMultichainAccountWalletId)(entropySource);
        const groupId = (0, account_api_1.toMultichainAccountGroupId)(walletId, account.options.entropy.groupIndex);
        return {
            wallet: {
                type: this.walletType,
                id: walletId,
                metadata: {
                    entropy: {
                        id: entropySource,
                    },
                },
            },
            group: {
                type: this.groupType,
                id: groupId,
                metadata: {
                    entropy: {
                        groupIndex: account.options.entropy.groupIndex,
                    },
                    pinned: false,
                    hidden: false,
                },
            },
        };
    }
    getDefaultAccountWalletName(wallet) {
        // NOTE: We have checked during the rule matching, so we can safely assume it will
        // well-defined here.
        const entropySourceIndex = this.getEntropySourceIndex(wallet.metadata.entropy.id);
        return `Wallet ${entropySourceIndex + 1}`; // Use human indexing (starts at 1).
    }
    getComputedAccountGroupName(group) {
        // Only use EVM account names for multichain groups to avoid chain-specific names becoming group names.
        // Non-EVM account names should not be used as group names since groups represent multichain collections.
        for (const id of group.accounts) {
            const account = this.messenger.call('AccountsController:getAccount', id);
            if (account && (0, keyring_api_1.isEvmAccountType)(account.type)) {
                return account.metadata.name;
            }
        }
        return '';
    }
    getDefaultAccountGroupPrefix(_wallet) {
        return 'Account';
    }
}
exports.EntropyRule = EntropyRule;

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\rules\\entropy.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\rules\\keyring.cjs", {"../rule.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\rule.cjs","@metamask/account-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\index.cjs","@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Crules%5Ckeyring.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeyringRule = exports.getAccountGroupPrefixFromKeyringType = exports.getAccountWalletNameFromKeyringType = void 0;
const account_api_1 = require("@metamask/account-api");
const account_api_2 = require("@metamask/account-api");
const account_api_3 = require("@metamask/account-api");
const keyring_controller_1 = require("@metamask/keyring-controller");
const rule_1 = require("../rule.cjs");
/**
 * Get wallet name from a keyring type.
 *
 * @param type - Keyring's type.
 * @returns Wallet name.
 */
function getAccountWalletNameFromKeyringType(type) {
    switch (type) {
        case keyring_controller_1.KeyringTypes.simple: {
            return 'Imported accounts';
        }
        case keyring_controller_1.KeyringTypes.trezor: {
            return 'Trezor';
        }
        case keyring_controller_1.KeyringTypes.oneKey: {
            return 'OneKey';
        }
        case keyring_controller_1.KeyringTypes.ledger: {
            return 'Ledger';
        }
        case keyring_controller_1.KeyringTypes.lattice: {
            return 'Lattice';
        }
        case keyring_controller_1.KeyringTypes.qr: {
            return 'QR';
        }
        // Those keyrings should never really be used in such context since they
        // should be used by other grouping rules.
        case keyring_controller_1.KeyringTypes.hd: {
            return 'HD Wallet';
        }
        case keyring_controller_1.KeyringTypes.snap: {
            return 'Snap Wallet';
        }
        // ------------------------------------------------------------------------
        default: {
            return 'Unknown';
        }
    }
}
exports.getAccountWalletNameFromKeyringType = getAccountWalletNameFromKeyringType;
/**
 * Get group name prefix from a keyring type.
 *
 * @param type - Keyring's type.
 * @returns Wallet name.
 */
function getAccountGroupPrefixFromKeyringType(type) {
    switch (type) {
        case keyring_controller_1.KeyringTypes.simple: {
            return 'Imported Account';
        }
        case keyring_controller_1.KeyringTypes.trezor: {
            return 'Trezor Account';
        }
        case keyring_controller_1.KeyringTypes.oneKey: {
            return 'OneKey Account';
        }
        case keyring_controller_1.KeyringTypes.ledger: {
            return 'Ledger Account';
        }
        case keyring_controller_1.KeyringTypes.lattice: {
            return 'Lattice Account';
        }
        case keyring_controller_1.KeyringTypes.qr: {
            return 'QR Account';
        }
        // Those keyrings should never really be used in such context since they
        // should be used by other grouping rules.
        case keyring_controller_1.KeyringTypes.hd: {
            return 'Account';
        }
        case keyring_controller_1.KeyringTypes.snap: {
            return 'Snap Account';
        }
        // ------------------------------------------------------------------------
        default: {
            return 'Unknown Account';
        }
    }
}
exports.getAccountGroupPrefixFromKeyringType = getAccountGroupPrefixFromKeyringType;
class KeyringRule extends rule_1.BaseRule {
    constructor() {
        super(...arguments);
        this.walletType = account_api_2.AccountWalletType.Keyring;
        this.groupType = account_api_1.AccountGroupType.SingleAccount;
    }
    match(account) {
        // We assume that `type` is really a `KeyringTypes`.
        const keyringType = account.metadata.keyring.type;
        const walletId = (0, account_api_3.toAccountWalletId)(this.walletType, keyringType);
        const groupId = (0, account_api_3.toAccountGroupId)(walletId, account.address);
        return {
            wallet: {
                type: this.walletType,
                id: walletId,
                metadata: {
                    keyring: {
                        type: keyringType,
                    },
                },
            },
            group: {
                type: this.groupType,
                id: groupId,
                metadata: {
                    pinned: false,
                    hidden: false,
                },
            },
        };
    }
    getDefaultAccountWalletName(wallet) {
        return getAccountWalletNameFromKeyringType(wallet.metadata.keyring.type);
    }
    getComputedAccountGroupName(group) {
        return super.getComputedAccountGroupName(group);
    }
    getDefaultAccountGroupPrefix(wallet) {
        return getAccountGroupPrefixFromKeyringType(wallet.metadata.keyring.type);
    }
}
exports.KeyringRule = KeyringRule;

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\rules\\keyring.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\rules\\snap.cjs", {"../rule.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\rule.cjs","./keyring.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\rules\\keyring.cjs","@metamask/account-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\index.cjs","@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccount-tree-controller%5Cdist%5Crules%5Csnap.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnapRule = void 0;
const account_api_1 = require("@metamask/account-api");
const account_api_2 = require("@metamask/account-api");
const keyring_controller_1 = require("@metamask/keyring-controller");
const snaps_utils_1 = require("@metamask/snaps-utils");
const keyring_1 = require("./keyring.cjs");
const rule_1 = require("../rule.cjs");
/**
 * Check if an account is a Snap account.
 *
 * @param account - The account to check.
 * @returns True if the account is a Snap account, false otherwise.
 */
function isSnapAccount(account) {
    return (account.metadata.keyring.type === keyring_controller_1.KeyringTypes.snap &&
        account.metadata.snap !== undefined &&
        account.metadata.snap.enabled);
}
class SnapRule extends rule_1.BaseRule {
    constructor() {
        super(...arguments);
        this.walletType = account_api_1.AccountWalletType.Snap;
        this.groupType = account_api_1.AccountGroupType.SingleAccount;
    }
    match(account) {
        if (!isSnapAccount(account)) {
            return undefined;
        }
        const { id: snapId } = account.metadata.snap;
        const walletId = (0, account_api_2.toAccountWalletId)(this.walletType, snapId);
        const groupId = (0, account_api_2.toAccountGroupId)(walletId, account.address);
        return {
            wallet: {
                type: this.walletType,
                id: walletId,
                metadata: {
                    snap: {
                        id: snapId,
                    },
                },
            },
            group: {
                type: this.groupType,
                id: groupId,
                metadata: {
                    pinned: false,
                    hidden: false,
                },
            },
        };
    }
    getDefaultAccountWalletName(wallet) {
        const snapId = wallet.metadata.snap.id;
        const snap = this.messenger.call('SnapController:get', snapId);
        const snapName = snap
            ? // TODO: Handle localization here, but that's a "client thing", so we don't have a `core` controller
                // to refer to.
                snap.manifest.proposedName
            : (0, snaps_utils_1.stripSnapPrefix)(snapId);
        return snapName;
    }
    getDefaultAccountGroupPrefix(_wallet) {
        return (0, keyring_1.getAccountGroupPrefixFromKeyringType)(keyring_controller_1.KeyringTypes.snap);
    }
}
exports.SnapRule = SnapRule;

      };
    };
  }
  }
}, {package:"@metamask/account-tree-controller",file:"node_modules\\@metamask\\account-tree-controller\\dist\\rules\\snap.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\accounts-controller\\dist\\AccountsController.cjs", {"./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\accounts-controller\\dist\\utils.cjs","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/eth-snap-keyring":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs","@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccounts-controller%5Cdist%5CAccountsController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _AccountsController_instances, _AccountsController_assertAccountCanBeRenamed, _AccountsController_getInternalAccountForNonSnapAccount, _AccountsController_getSnapKeyring, _AccountsController_handleOnSnapKeyringAccountEvent, _AccountsController_handleOnKeyringStateChange, _AccountsController_update, _AccountsController_handleOnSnapStateChange, _AccountsController_getAccountsByKeyringType, _AccountsController_getLastSelectedAccount, _AccountsController_getLastSelectedIndex, _AccountsController_getInternalAccountFromAddressAndType, _AccountsController_handleOnMultichainNetworkDidChange, _AccountsController_subscribeToMessageEvents, _AccountsController_registerMessageHandlers;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccountsController = exports.EMPTY_ACCOUNT = void 0;
const base_controller_1 = require("@metamask/base-controller");
const eth_snap_keyring_1 = require("@metamask/eth-snap-keyring");
const keyring_api_1 = require("@metamask/keyring-api");
const keyring_controller_1 = require("@metamask/keyring-controller");
const keyring_utils_1 = require("@metamask/keyring-utils");
const utils_1 = require("@metamask/utils");
const lodash_1 = require("lodash");
const utils_2 = require("./utils.cjs");
const controllerName = 'AccountsController';
const accountsControllerMetadata = {
    internalAccounts: {
        includeInStateLogs: true,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
};
const defaultState = {
    internalAccounts: {
        accounts: {},
        selectedAccount: '',
    },
};
exports.EMPTY_ACCOUNT = {
    id: '',
    address: '',
    options: {},
    methods: [],
    type: keyring_api_1.EthAccountType.Eoa,
    scopes: [keyring_api_1.EthScope.Eoa],
    metadata: {
        name: '',
        keyring: {
            type: '',
        },
        importTime: 0,
    },
};
/**
 * Controller that manages internal accounts.
 * The accounts controller is responsible for creating and managing internal accounts.
 * It also provides convenience methods for accessing and updating the internal accounts.
 * The accounts controller also listens for keyring state changes and updates the internal accounts accordingly.
 * The accounts controller also listens for snap state changes and updates the internal accounts accordingly.
 *
 */
class AccountsController extends base_controller_1.BaseController {
    /**
     * Constructor for AccountsController.
     *
     * @param options - The controller options.
     * @param options.messenger - The messenger object.
     * @param options.state - Initial state to set on this controller
     */
    constructor({ messenger, state, }) {
        super({
            messenger,
            name: controllerName,
            metadata: accountsControllerMetadata,
            state: {
                ...defaultState,
                ...state,
            },
        });
        _AccountsController_instances.add(this);
        __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_subscribeToMessageEvents).call(this);
        __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_registerMessageHandlers).call(this);
    }
    /**
     * Returns the internal account object for the given account ID, if it exists.
     *
     * @param accountId - The ID of the account to retrieve.
     * @returns The internal account object, or undefined if the account does not exist.
     */
    getAccount(accountId) {
        return this.state.internalAccounts.accounts[accountId];
    }
    /**
     * Returns an array of all evm internal accounts.
     *
     * @returns An array of InternalAccount objects.
     */
    listAccounts() {
        const accounts = Object.values(this.state.internalAccounts.accounts);
        return accounts.filter((account) => (0, keyring_api_1.isEvmAccountType)(account.type));
    }
    /**
     * Returns an array of all internal accounts.
     *
     * @param chainId - The chain ID.
     * @returns An array of InternalAccount objects.
     */
    listMultichainAccounts(chainId) {
        const accounts = Object.values(this.state.internalAccounts.accounts);
        if (!chainId) {
            return accounts;
        }
        if (!(0, utils_1.isCaipChainId)(chainId)) {
            throw new Error(`Invalid CAIP-2 chain ID: ${String(chainId)}`);
        }
        return accounts.filter((account) => (0, keyring_utils_1.isScopeEqualToAny)(chainId, account.scopes));
    }
    /**
     * Returns the internal account object for the given account ID.
     *
     * @param accountId - The ID of the account to retrieve.
     * @returns The internal account object.
     * @throws An error if the account ID is not found.
     */
    getAccountExpect(accountId) {
        const account = this.getAccount(accountId);
        if (account === undefined) {
            throw new Error(`Account Id "${accountId}" not found`);
        }
        return account;
    }
    /**
     * Returns the last selected EVM account.
     *
     * @returns The selected internal account.
     */
    getSelectedAccount() {
        const { internalAccounts: { selectedAccount }, } = this.state;
        // Edge case where the extension is setup but the srp is not yet created
        // certain ui elements will query the selected address before any accounts are created.
        if (selectedAccount === '') {
            return exports.EMPTY_ACCOUNT;
        }
        const account = this.getAccountExpect(selectedAccount);
        if ((0, keyring_api_1.isEvmAccountType)(account.type)) {
            return account;
        }
        const accounts = this.listAccounts();
        if (!accounts.length) {
            // ! Should never reach this.
            throw new Error('No EVM accounts');
        }
        // This will never be undefined because we have already checked if accounts.length is > 0
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        return __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_getLastSelectedAccount).call(this, accounts);
    }
    /**
     * __WARNING The return value may be undefined if there isn't an account for that chain id.__
     *
     * Retrieves the last selected account by chain ID.
     *
     * @param chainId - The chain ID to filter the accounts.
     * @returns The last selected account compatible with the specified chain ID or undefined.
     */
    getSelectedMultichainAccount(chainId) {
        const { internalAccounts: { selectedAccount }, } = this.state;
        // Edge case where the extension is setup but the srp is not yet created
        // certain ui elements will query the selected address before any accounts are created.
        if (selectedAccount === '') {
            return exports.EMPTY_ACCOUNT;
        }
        if (!chainId) {
            return this.getAccountExpect(selectedAccount);
        }
        const accounts = this.listMultichainAccounts(chainId);
        return __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_getLastSelectedAccount).call(this, accounts);
    }
    /**
     * Returns the account with the specified address.
     * ! This method will only return the first account that matches the address
     *
     * @param address - The address of the account to retrieve.
     * @returns The account with the specified address, or undefined if not found.
     */
    getAccountByAddress(address) {
        return this.listMultichainAccounts().find((account) => account.address.toLowerCase() === address.toLowerCase());
    }
    /**
     * Sets the selected account by its ID.
     *
     * @param accountId - The ID of the account to be selected.
     */
    setSelectedAccount(accountId) {
        const account = this.getAccountExpect(accountId);
        if (this.state.internalAccounts.selectedAccount === account.id) {
            return;
        }
        __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_update).call(this, (state) => {
            const { internalAccounts } = state;
            internalAccounts.accounts[account.id].metadata.lastSelected = Date.now();
            internalAccounts.selectedAccount = account.id;
        });
    }
    /**
     * Sets the name of the account with the given ID.
     *
     * @param accountId - The ID of the account to set the name for.
     * @param accountName - The new name for the account.
     * @throws An error if an account with the same name already exists.
     */
    setAccountName(accountId, accountName) {
        // This will check for name uniqueness and fire the `accountRenamed` event
        // if the account has been renamed.
        this.updateAccountMetadata(accountId, {
            name: accountName,
            nameLastUpdatedAt: Date.now(),
        });
    }
    /**
     * Sets the name of the account with the given ID and select it.
     *
     * @param accountId - The ID of the account to set the name for and select.
     * @param accountName - The new name for the account.
     * @throws An error if an account with the same name already exists.
     */
    setAccountNameAndSelectAccount(accountId, accountName) {
        const account = this.getAccountExpect(accountId);
        __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_assertAccountCanBeRenamed).call(this, account, accountName);
        const internalAccount = {
            ...account,
            metadata: {
                ...account.metadata,
                name: accountName,
                nameLastUpdatedAt: Date.now(),
                lastSelected: __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_getLastSelectedIndex).call(this),
            },
        };
        __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_update).call(this, (state) => {
            state.internalAccounts.accounts[account.id] = internalAccount;
            state.internalAccounts.selectedAccount = account.id;
        });
        this.messagingSystem.publish('AccountsController:accountRenamed', internalAccount);
    }
    /**
     * Updates the metadata of the account with the given ID.
     *
     * @param accountId - The ID of the account for which the metadata will be updated.
     * @param metadata - The new metadata for the account.
     */
    updateAccountMetadata(accountId, metadata) {
        const account = this.getAccountExpect(accountId);
        if (metadata.name) {
            __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_assertAccountCanBeRenamed).call(this, account, metadata.name);
        }
        const internalAccount = {
            ...account,
            metadata: { ...account.metadata, ...metadata },
        };
        __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_update).call(this, (state) => {
            state.internalAccounts.accounts[accountId] = internalAccount;
        });
        if (metadata.name) {
            this.messagingSystem.publish('AccountsController:accountRenamed', internalAccount);
        }
    }
    /**
     * Updates the internal accounts list by retrieving normal and snap accounts,
     * removing duplicates, and updating the metadata of each account.
     *
     * @returns A Promise that resolves when the accounts have been updated.
     */
    async updateAccounts() {
        const keyringAccountIndexes = new Map();
        const existingInternalAccounts = this.state.internalAccounts.accounts;
        const internalAccounts = {};
        const { keyrings } = this.messagingSystem.call('KeyringController:getState');
        for (const keyring of keyrings) {
            const keyringTypeName = (0, utils_2.keyringTypeToName)(keyring.type);
            for (const address of keyring.accounts) {
                const internalAccount = __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_getInternalAccountFromAddressAndType).call(this, address, keyring);
                // This should never really happen, but if for some reason we're not
                // able to get the Snap keyring reference, this would return an
                // undefined account.
                // So we just skip it, even though, this should not really happen.
                if (!internalAccount) {
                    continue;
                }
                // Get current index for this keyring (we use human indexing, so start at 1).
                const keyringAccountIndex = keyringAccountIndexes.get(keyringTypeName) ?? 1;
                const existingAccount = existingInternalAccounts[internalAccount.id];
                internalAccounts[internalAccount.id] = {
                    ...internalAccount,
                    metadata: {
                        ...internalAccount.metadata,
                        // Re-use existing metadata if any.
                        name: existingAccount?.metadata.name ??
                            `${keyringTypeName} ${keyringAccountIndex}`,
                        importTime: existingAccount?.metadata.importTime ?? Date.now(),
                        lastSelected: existingAccount?.metadata.lastSelected ?? 0,
                    },
                };
                // Increment the account index for this keyring.
                keyringAccountIndexes.set(keyringTypeName, keyringAccountIndex + 1);
            }
        }
        __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_update).call(this, (state) => {
            state.internalAccounts.accounts = internalAccounts;
        });
    }
    /**
     * Loads the backup state of the accounts controller.
     *
     * @param backup - The backup state to load.
     */
    loadBackup(backup) {
        if (backup.internalAccounts) {
            this.update((currentState) => {
                currentState.internalAccounts = backup.internalAccounts;
            });
        }
    }
    /**
     * Returns the next account number for a given keyring type.
     *
     * @param keyringType - The type of keyring.
     * @param accounts - Existing accounts to check for the next available account number.
     * @returns An object containing the account prefix and index to use.
     */
    getNextAvailableAccountName(keyringType = keyring_controller_1.KeyringTypes.hd, accounts) {
        const keyringName = (0, utils_2.keyringTypeToName)(keyringType);
        const keyringAccounts = __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_getAccountsByKeyringType).call(this, keyringType, accounts);
        const lastDefaultIndexUsedForKeyringType = keyringAccounts.reduce((maxInternalAccountIndex, internalAccount) => {
            // We **DO NOT USE** `\d+` here to only consider valid "human"
            // number (rounded decimal number)
            const match = new RegExp(`${keyringName} ([0-9]+)$`, 'u').exec(internalAccount.metadata.name);
            if (match) {
                // Quoting `RegExp.exec` documentation:
                // > The returned array has the matched text as the first item, and then one item for
                // > each capturing group of the matched text.
                // So use `match[1]` to get the captured value
                const internalAccountIndex = parseInt(match[1], 10);
                return Math.max(maxInternalAccountIndex, internalAccountIndex);
            }
            return maxInternalAccountIndex;
        }, 0);
        const index = Math.max(keyringAccounts.length + 1, lastDefaultIndexUsedForKeyringType + 1);
        return `${keyringName} ${index}`;
    }
}
exports.AccountsController = AccountsController;
_AccountsController_instances = new WeakSet(), _AccountsController_assertAccountCanBeRenamed = function _AccountsController_assertAccountCanBeRenamed(account, accountName) {
    if (this.listMultichainAccounts().find((internalAccount) => internalAccount.metadata.name === accountName &&
        internalAccount.id !== account.id)) {
        throw new Error('Account name already exists');
    }
}, _AccountsController_getInternalAccountForNonSnapAccount = function _AccountsController_getInternalAccountForNonSnapAccount(address, keyring) {
    const id = (0, utils_2.getUUIDFromAddressOfNormalAccount)(address);
    // We might have an account for this ID already, so we'll just re-use
    // the same metadata
    const account = this.getAccount(id);
    const metadata = {
        name: account?.metadata.name ?? '',
        ...(account?.metadata.nameLastUpdatedAt
            ? {
                nameLastUpdatedAt: account?.metadata.nameLastUpdatedAt,
            }
            : {}),
        importTime: account?.metadata.importTime ?? Date.now(),
        lastSelected: account?.metadata.lastSelected ?? 0,
        keyring: {
            type: keyring.type,
        },
    };
    let options = {};
    if ((0, utils_2.isHdKeyringType)(keyring.type)) {
        // We need to find the account index from its HD keyring.
        const groupIndex = (0, utils_2.getEvmGroupIndexFromAddressIndex)(keyring, address);
        // If for some reason, we cannot find this address, then the caller made a mistake
        // and it did not use the proper keyring object. For now, we do not fail and just
        // consider this account as "simple account".
        if (groupIndex !== undefined) {
            // NOTE: We are not using the `hdPath` from the associated keyring here and
            // getting the keyring instance here feels a bit overkill.
            // This will be naturally fixed once every keyring start using `KeyringAccount` and implement the keyring API.
            const derivationPath = (0, utils_2.getEvmDerivationPathForIndex)(groupIndex);
            // Those are "legacy options" and they were used before `KeyringAccount` added
            // support for type options. We keep those temporarily until we update everything
            // to use the new typed options.
            const legacyOptions = {
                entropySource: keyring.metadata.id,
                derivationPath,
                groupIndex,
            };
            // New typed entropy options. This is required for multichain accounts.
            const entropyOptions = {
                entropy: {
                    type: keyring_api_1.KeyringAccountEntropyTypeOption.Mnemonic,
                    id: keyring.metadata.id,
                    derivationPath,
                    groupIndex,
                },
            };
            options = {
                ...legacyOptions,
                ...entropyOptions,
            };
        }
    }
    return {
        id,
        address,
        options,
        methods: [
            keyring_api_1.EthMethod.PersonalSign,
            keyring_api_1.EthMethod.Sign,
            keyring_api_1.EthMethod.SignTransaction,
            keyring_api_1.EthMethod.SignTypedDataV1,
            keyring_api_1.EthMethod.SignTypedDataV3,
            keyring_api_1.EthMethod.SignTypedDataV4,
        ],
        scopes: [keyring_api_1.EthScope.Eoa],
        type: keyring_api_1.EthAccountType.Eoa,
        metadata,
    };
}, _AccountsController_getSnapKeyring = function _AccountsController_getSnapKeyring() {
    const [snapKeyring] = this.messagingSystem.call('KeyringController:getKeyringsByType', eth_snap_keyring_1.SnapKeyring.type);
    // Snap keyring is not available until the first account is created in the keyring
    // controller, so this might be undefined.
    return snapKeyring;
}, _AccountsController_handleOnSnapKeyringAccountEvent = function _AccountsController_handleOnSnapKeyringAccountEvent(event, ...payload) {
    this.messagingSystem.publish(event, ...payload);
}, _AccountsController_handleOnKeyringStateChange = function _AccountsController_handleOnKeyringStateChange({ isUnlocked, keyrings, }) {
    // TODO: Change when accountAdded event is added to the keyring controller.
    // We check for keyrings length to be greater than 0 because the extension client may try execute
    // submit password twice and clear the keyring state.
    // https://github.com/MetaMask/KeyringController/blob/2d73a4deed8d013913f6ef0c9f5c0bb7c614f7d3/src/KeyringController.ts#L910
    if (!isUnlocked || keyrings.length === 0) {
        return;
    }
    // State patches.
    const generatePatch = () => {
        return {
            previous: {},
            added: [],
            updated: [],
            removed: [],
        };
    };
    const patches = {
        snap: generatePatch(),
        normal: generatePatch(),
    };
    // Gets the patch object based on the keyring type (since Snap accounts and other accounts
    // are handled differently).
    const patchOf = (type) => {
        if ((0, utils_2.isSnapKeyringType)(type)) {
            return patches.snap;
        }
        return patches.normal;
    };
    // Create a map (with lower-cased addresses) of all existing accounts.
    for (const account of this.listMultichainAccounts()) {
        const address = account.address.toLowerCase();
        const patch = patchOf(account.metadata.keyring.type);
        patch.previous[address] = account;
    }
    // Go over all keyring changes and create patches out of it.
    const addresses = new Set();
    for (const keyring of keyrings) {
        const patch = patchOf(keyring.type);
        for (const accountAddress of keyring.accounts) {
            // Lower-case address to use it in the `previous` map.
            const address = accountAddress.toLowerCase();
            const account = patch.previous[address];
            if (account) {
                // If the account exists before, this might be an update.
                patch.updated.push(account);
            }
            else {
                // Otherwise, that's a new account.
                patch.added.push({
                    address,
                    keyring,
                });
            }
            // Keep track of those address to check for removed accounts later.
            addresses.add(address);
        }
    }
    // We might have accounts associated with removed keyrings, so we iterate
    // over all previous known accounts and check against the keyring addresses.
    for (const patch of [patches.snap, patches.normal]) {
        for (const [address, account] of Object.entries(patch.previous)) {
            // If a previous address is not part of the new addesses, then it got removed.
            if (!addresses.has(address)) {
                patch.removed.push(account);
            }
        }
    }
    // Diff that we will use to publish events afterward.
    const diff = {
        removed: [],
        added: [],
    };
    __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_update).call(this, (state) => {
        const { internalAccounts } = state;
        for (const patch of [patches.snap, patches.normal]) {
            for (const account of patch.removed) {
                delete internalAccounts.accounts[account.id];
                diff.removed.push(account.id);
            }
            for (const added of patch.added) {
                const account = __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_getInternalAccountFromAddressAndType).call(this, added.address, added.keyring);
                if (account) {
                    // Re-compute the list of accounts everytime, so we can make sure new names
                    // are also considered.
                    const accounts = Object.values(internalAccounts.accounts);
                    // Get next account name available for this given keyring.
                    const name = this.getNextAvailableAccountName(account.metadata.keyring.type, accounts);
                    // If it's the first account, we need to select it.
                    const lastSelected = accounts.length === 0 ? __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_getLastSelectedIndex).call(this) : 0;
                    internalAccounts.accounts[account.id] = {
                        ...account,
                        metadata: {
                            ...account.metadata,
                            name,
                            importTime: Date.now(),
                            lastSelected,
                        },
                    };
                    diff.added.push(internalAccounts.accounts[account.id]);
                }
            }
        }
    }, 
    // Will get executed after the update, but before re-selecting an account in case
    // the current one is not valid anymore.
    () => {
        // Now publish events
        for (const id of diff.removed) {
            this.messagingSystem.publish('AccountsController:accountRemoved', id);
        }
        for (const account of diff.added) {
            this.messagingSystem.publish('AccountsController:accountAdded', account);
        }
    });
    // NOTE: Since we also track "updated" accounts with our patches, we could fire a new event
    // like `accountUpdated` (we would still need to check if anything really changed on the account).
}, _AccountsController_update = function _AccountsController_update(callback, beforeAutoSelectAccount) {
    // The currently selected account might get deleted during the update, so keep track
    // of it before doing any change.
    const previouslySelectedAccount = this.state.internalAccounts.selectedAccount;
    this.update((state) => {
        callback(state);
        // If the account no longer exists (or none is selected), we need to re-select another one.
        const { internalAccounts } = state;
        if (!internalAccounts.accounts[previouslySelectedAccount]) {
            const accounts = Object.values(internalAccounts.accounts);
            // Get the lastly selected account (according to the current accounts).
            const lastSelectedAccount = __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_getLastSelectedAccount).call(this, accounts);
            if (lastSelectedAccount) {
                internalAccounts.selectedAccount = lastSelectedAccount.id;
                internalAccounts.accounts[lastSelectedAccount.id].metadata.lastSelected = __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_getLastSelectedIndex).call(this);
            }
            else {
                // It will be undefined if there are no accounts.
                internalAccounts.selectedAccount = '';
            }
        }
    });
    // We might want to do some pre-work before selecting a new account.
    beforeAutoSelectAccount?.();
    // Now, we compare the newly selected account, and we send event if different.
    const { selectedAccount } = this.state.internalAccounts;
    if (selectedAccount && selectedAccount !== previouslySelectedAccount) {
        const account = this.getSelectedMultichainAccount();
        // The account should always be defined at this point, since we have already checked for
        // `selectedAccount` to be non-empty.
        if (account) {
            if ((0, keyring_api_1.isEvmAccountType)(account.type)) {
                this.messagingSystem.publish('AccountsController:selectedEvmAccountChange', account);
            }
            this.messagingSystem.publish('AccountsController:selectedAccountChange', account);
        }
    }
}, _AccountsController_handleOnSnapStateChange = function _AccountsController_handleOnSnapStateChange(snapState) {
    // Only check if Snaps changed in status.
    const { snaps } = snapState;
    const accounts = [];
    for (const account of this.listMultichainAccounts()) {
        if (account.metadata.snap) {
            const snap = snaps[account.metadata.snap.id];
            if (snap) {
                const enabled = snap.enabled && !snap.blocked;
                const metadata = account.metadata.snap;
                if (metadata.enabled !== enabled) {
                    accounts.push({ id: account.id, enabled });
                }
            }
            else {
                // If Snap could not be found on the state, we consider it disabled.
                accounts.push({ id: account.id, enabled: false });
            }
        }
    }
    if (accounts.length > 0) {
        this.update((state) => {
            for (const { id, enabled } of accounts) {
                const account = state.internalAccounts.accounts[id];
                if (account.metadata.snap) {
                    account.metadata.snap.enabled = enabled;
                }
            }
        });
    }
}, _AccountsController_getAccountsByKeyringType = function _AccountsController_getAccountsByKeyringType(keyringType, accounts) {
    return (accounts ?? this.listMultichainAccounts()).filter((internalAccount) => {
        // We do consider `hd` and `simple` keyrings to be of same type. So we check those 2 types
        // to group those accounts together!
        if ((0, utils_2.isHdKeyringType)(keyringType) || (0, utils_2.isSimpleKeyringType)(keyringType)) {
            return ((0, utils_2.isHdKeyringType)(internalAccount.metadata.keyring.type) ||
                (0, utils_2.isSimpleKeyringType)(internalAccount.metadata.keyring.type));
        }
        return internalAccount.metadata.keyring.type === keyringType;
    });
}, _AccountsController_getLastSelectedAccount = function _AccountsController_getLastSelectedAccount(accounts) {
    const [accountToSelect] = accounts.sort((accountA, accountB) => {
        // sort by lastSelected descending
        return ((accountB.metadata.lastSelected ?? 0) -
            (accountA.metadata.lastSelected ?? 0));
    });
    return accountToSelect;
}, _AccountsController_getLastSelectedIndex = function _AccountsController_getLastSelectedIndex() {
    // NOTE: For now we use the current date, since we know this value
    // will always be higher than any already selected account index.
    return Date.now();
}, _AccountsController_getInternalAccountFromAddressAndType = function _AccountsController_getInternalAccountFromAddressAndType(address, keyring) {
    if ((0, utils_2.isSnapKeyringType)(keyring.type)) {
        const snapKeyring = __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_getSnapKeyring).call(this);
        // We need the Snap keyring to retrieve the account from its address.
        if (!snapKeyring) {
            return undefined;
        }
        // This might be undefined if the Snap deleted the account before
        // reaching that point.
        let account = snapKeyring.getAccountByAddress(address);
        if (account) {
            // We force the copy here, to avoid mutating the reference returned by the Snap keyring.
            account = (0, lodash_1.cloneDeep)(account);
            // MIGRATION: To avoid any existing Snap account migration, we are
            // just "adding" the new typed options that we need for multichain
            // accounts. Ultimately, we would need a real Snap account migrations
            // (being handled by each Snaps).
            if ((0, utils_2.isHdSnapKeyringAccount)(account)) {
                const options = {
                    ...account.options,
                    entropy: {
                        type: keyring_api_1.KeyringAccountEntropyTypeOption.Mnemonic,
                        id: account.options.entropySource,
                        groupIndex: account.options.index,
                        derivationPath: account.options.derivationPath,
                    },
                };
                // Inject the new typed options to the internal account copy.
                account.options = options;
            }
        }
        return account;
    }
    return __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_getInternalAccountForNonSnapAccount).call(this, address, keyring);
}, _AccountsController_handleOnMultichainNetworkDidChange = function _AccountsController_handleOnMultichainNetworkDidChange(id) {
    let accountId;
    // We only support non-EVM Caip chain IDs at the moment. Ex Solana and Bitcoin
    // MultichainNetworkController will handle throwing an error if the Caip chain ID is not supported
    if ((0, utils_1.isCaipChainId)(id)) {
        // Update selected account to non evm account
        const lastSelectedNonEvmAccount = this.getSelectedMultichainAccount(id);
        // @ts-expect-error - This should never be undefined, otherwise it's a bug that should be handled
        accountId = lastSelectedNonEvmAccount.id;
    }
    else {
        // Update selected account to evm account
        const lastSelectedEvmAccount = this.getSelectedAccount();
        accountId = lastSelectedEvmAccount.id;
    }
    if (this.state.internalAccounts.selectedAccount === accountId) {
        return;
    }
    this.update((currentState) => {
        currentState.internalAccounts.accounts[accountId].metadata.lastSelected =
            Date.now();
        currentState.internalAccounts.selectedAccount = accountId;
    });
    // DO NOT publish AccountsController:setSelectedAccount to prevent circular listener loops
}, _AccountsController_subscribeToMessageEvents = function _AccountsController_subscribeToMessageEvents() {
    this.messagingSystem.subscribe('SnapController:stateChange', (snapStateState) => __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_handleOnSnapStateChange).call(this, snapStateState));
    this.messagingSystem.subscribe('KeyringController:stateChange', (keyringState) => __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_handleOnKeyringStateChange).call(this, keyringState));
    this.messagingSystem.subscribe('SnapKeyring:accountAssetListUpdated', (snapAccountEvent) => __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_handleOnSnapKeyringAccountEvent).call(this, 'AccountsController:accountAssetListUpdated', snapAccountEvent));
    this.messagingSystem.subscribe('SnapKeyring:accountBalancesUpdated', (snapAccountEvent) => __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_handleOnSnapKeyringAccountEvent).call(this, 'AccountsController:accountBalancesUpdated', snapAccountEvent));
    this.messagingSystem.subscribe('SnapKeyring:accountTransactionsUpdated', (snapAccountEvent) => __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_handleOnSnapKeyringAccountEvent).call(this, 'AccountsController:accountTransactionsUpdated', snapAccountEvent));
    // Handle account change when multichain network is changed
    this.messagingSystem.subscribe('MultichainNetworkController:networkDidChange', (id) => __classPrivateFieldGet(this, _AccountsController_instances, "m", _AccountsController_handleOnMultichainNetworkDidChange).call(this, id));
}, _AccountsController_registerMessageHandlers = function _AccountsController_registerMessageHandlers() {
    this.messagingSystem.registerActionHandler(`${controllerName}:setSelectedAccount`, this.setSelectedAccount.bind(this));
    this.messagingSystem.registerActionHandler(`${controllerName}:listAccounts`, this.listAccounts.bind(this));
    this.messagingSystem.registerActionHandler(`${controllerName}:listMultichainAccounts`, this.listMultichainAccounts.bind(this));
    this.messagingSystem.registerActionHandler(`${controllerName}:setAccountName`, this.setAccountName.bind(this));
    this.messagingSystem.registerActionHandler(`${controllerName}:setAccountNameAndSelectAccount`, this.setAccountNameAndSelectAccount.bind(this));
    this.messagingSystem.registerActionHandler(`${controllerName}:updateAccounts`, this.updateAccounts.bind(this));
    this.messagingSystem.registerActionHandler(`${controllerName}:getSelectedAccount`, this.getSelectedAccount.bind(this));
    this.messagingSystem.registerActionHandler(`${controllerName}:getSelectedMultichainAccount`, this.getSelectedMultichainAccount.bind(this));
    this.messagingSystem.registerActionHandler(`${controllerName}:getAccountByAddress`, this.getAccountByAddress.bind(this));
    this.messagingSystem.registerActionHandler(`${controllerName}:getNextAvailableAccountName`, this.getNextAvailableAccountName.bind(this));
    this.messagingSystem.registerActionHandler(`AccountsController:getAccount`, this.getAccount.bind(this));
    this.messagingSystem.registerActionHandler(`AccountsController:updateAccountMetadata`, this.updateAccountMetadata.bind(this));
};

      };
    };
  }
  }
}, {package:"@metamask/accounts-controller",file:"node_modules\\@metamask\\accounts-controller\\dist\\AccountsController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\accounts-controller\\dist\\index.cjs", {"./AccountsController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\accounts-controller\\dist\\AccountsController.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\accounts-controller\\dist\\utils.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccounts-controller%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isNormalKeyringType = exports.getUUIDFromAddressOfNormalAccount = exports.getUUIDOptionsFromAddressOfNormalAccount = exports.keyringTypeToName = exports.AccountsController = exports.EMPTY_ACCOUNT = void 0;
var AccountsController_1 = require("./AccountsController.cjs");
Object.defineProperty(exports, "EMPTY_ACCOUNT", { enumerable: true, get: function () { return AccountsController_1.EMPTY_ACCOUNT; } });
Object.defineProperty(exports, "AccountsController", { enumerable: true, get: function () { return AccountsController_1.AccountsController; } });
var utils_1 = require("./utils.cjs");
Object.defineProperty(exports, "keyringTypeToName", { enumerable: true, get: function () { return utils_1.keyringTypeToName; } });
Object.defineProperty(exports, "getUUIDOptionsFromAddressOfNormalAccount", { enumerable: true, get: function () { return utils_1.getUUIDOptionsFromAddressOfNormalAccount; } });
Object.defineProperty(exports, "getUUIDFromAddressOfNormalAccount", { enumerable: true, get: function () { return utils_1.getUUIDFromAddressOfNormalAccount; } });
Object.defineProperty(exports, "isNormalKeyringType", { enumerable: true, get: function () { return utils_1.isNormalKeyringType; } });

      };
    };
  }
  }
}, {package:"@metamask/accounts-controller",file:"node_modules\\@metamask\\accounts-controller\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\accounts-controller\\dist\\utils.cjs", {"@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","ethereum-cryptography/sha256":"D:\\code\\v\\metamask-extension\\node_modules\\ethereum-cryptography\\sha256.js","uuid":"D:\\code\\v\\metamask-extension\\node_modules\\uuid\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Caccounts-controller%5Cdist%5Cutils.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isHdSnapKeyringAccount = exports.HdSnapKeyringAccountOptionsStruct = exports.getEvmGroupIndexFromAddressIndex = exports.getEvmDerivationPathForIndex = exports.isHdKeyringType = exports.isSimpleKeyringType = exports.isSnapKeyringType = exports.isNormalKeyringType = exports.getUUIDFromAddressOfNormalAccount = exports.getUUIDOptionsFromAddressOfNormalAccount = exports.keyringTypeToName = void 0;
const keyring_controller_1 = require("@metamask/keyring-controller");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const sha256_1 = require("ethereum-cryptography/sha256");
const uuid_1 = require("uuid");
/**
 * Returns the name of the keyring type.
 *
 * @param keyringType - The type of the keyring.
 * @returns The name of the keyring type.
 */
function keyringTypeToName(keyringType) {
    switch (keyringType) {
        case keyring_controller_1.KeyringTypes.simple: {
            return 'Account';
        }
        case keyring_controller_1.KeyringTypes.hd: {
            return 'Account';
        }
        case keyring_controller_1.KeyringTypes.trezor: {
            return 'Trezor';
        }
        case keyring_controller_1.KeyringTypes.oneKey: {
            return 'OneKey';
        }
        case keyring_controller_1.KeyringTypes.ledger: {
            return 'Ledger';
        }
        case keyring_controller_1.KeyringTypes.lattice: {
            return 'Lattice';
        }
        case keyring_controller_1.KeyringTypes.qr: {
            return 'QR';
        }
        case keyring_controller_1.KeyringTypes.snap: {
            return 'Snap Account';
        }
        default: {
            throw new Error(`Unknown keyring ${keyringType}`);
        }
    }
}
exports.keyringTypeToName = keyringTypeToName;
/**
 * Generates a UUID v4 options from a given Ethereum address.
 *
 * @param address - The Ethereum address to generate the UUID from.
 * @returns The UUID v4 options.
 */
function getUUIDOptionsFromAddressOfNormalAccount(address) {
    const v4options = {
        random: (0, sha256_1.sha256)((0, utils_1.hexToBytes)(address)).slice(0, 16),
    };
    return v4options;
}
exports.getUUIDOptionsFromAddressOfNormalAccount = getUUIDOptionsFromAddressOfNormalAccount;
/**
 * Generates a UUID from a given Ethereum address.
 *
 * @param address - The Ethereum address to generate the UUID from.
 * @returns The generated UUID.
 */
function getUUIDFromAddressOfNormalAccount(address) {
    return (0, uuid_1.v4)(getUUIDOptionsFromAddressOfNormalAccount(address));
}
exports.getUUIDFromAddressOfNormalAccount = getUUIDFromAddressOfNormalAccount;
/**
 * Check if a keyring type is considered a "normal" keyring.
 *
 * @param keyringType - The account's keyring type.
 * @returns True if the keyring type is considered a "normal" keyring, false otherwise.
 */
function isNormalKeyringType(keyringType) {
    // Right now, we only have to "exclude" Snap accounts, but this might need to be
    // adapted later on if we have new kind of keyrings!
    return keyringType !== keyring_controller_1.KeyringTypes.snap;
}
exports.isNormalKeyringType = isNormalKeyringType;
/**
 * Check if a keyring type is a Snap keyring.
 *
 * @param keyringType - The account's keyring type.
 * @returns True if the keyring type is considered a Snap keyring, false otherwise.
 */
function isSnapKeyringType(keyringType) {
    return keyringType === keyring_controller_1.KeyringTypes.snap;
}
exports.isSnapKeyringType = isSnapKeyringType;
/**
 * Check if a keyring type is a simple keyring.
 *
 * @param keyringType - The account's keyring type.
 * @returns True if the keyring type is considered a simple keyring, false otherwise.
 */
function isSimpleKeyringType(keyringType) {
    return keyringType === keyring_controller_1.KeyringTypes.simple;
}
exports.isSimpleKeyringType = isSimpleKeyringType;
/**
 * Check if a keyring is a HD keyring.
 *
 * @param keyringType - The account's keyring type.
 * @returns True if the keyring is a HD keyring, false otherwise.
 */
function isHdKeyringType(keyringType) {
    return keyringType === keyring_controller_1.KeyringTypes.hd;
}
exports.isHdKeyringType = isHdKeyringType;
/**
 * Get the derivation path for the index of an account within a EVM HD keyring.
 *
 * @param index - The account index.
 * @returns The derivation path.
 */
function getEvmDerivationPathForIndex(index) {
    const purpose = '44';
    const coinType = '60'; // Ethereum.
    return `m/${purpose}'/${coinType}'/0'/0/${index}`;
}
exports.getEvmDerivationPathForIndex = getEvmDerivationPathForIndex;
/**
 * Get the group index from a keyring object (EVM HD keyring only) and an address.
 *
 * @param keyring - The keyring object.
 * @param address - The address to match.
 * @returns The group index for that address, undefined if not able to match the address.
 */
function getEvmGroupIndexFromAddressIndex(keyring, address) {
    // TODO: Remove this function once EVM HD keyrings start using the new unified
    // keyring API.
    // NOTE: We mostly put that logic in a separate function so we can easily add coverage
    // for (supposedly) unreachable code path.
    if (!isHdKeyringType(keyring.type)) {
        // We cannot extract the group index from non-HD keyrings.
        return undefined;
    }
    // We need to find the account index from its HD keyring. We assume those
    // accounts are ordered, thus we can use their index to compute their
    // derivation path and group index.
    const groupIndex = keyring.accounts.findIndex(
    // NOTE: This is ok to use `toLowerCase` here, since we're only dealing
    // with EVM addresses.
    (accountAddress) => accountAddress.toLowerCase() === address.toLowerCase());
    // If for some reason, we cannot find this address, then the caller made a mistake
    // and it did not use the proper keyring object. For now, we do not fail and just
    // consider this account as "simple account".
    if (groupIndex === -1) {
        console.warn(`! Unable to get group index for HD account: "${address}"`);
        return undefined;
    }
    return groupIndex;
}
exports.getEvmGroupIndexFromAddressIndex = getEvmGroupIndexFromAddressIndex;
/**
 * HD keyring account for Snap accounts that handles non-EVM HD accounts. (e.g the
 * Solana Snap).
 *
 * NOTE: We use `superstruct.type` here `superstruct.object` since it allows
 * extra-properties than a Snap might add in its `options`.
 */
exports.HdSnapKeyringAccountOptionsStruct = (0, superstruct_1.type)({
    entropySource: (0, superstruct_1.string)(),
    index: (0, superstruct_1.number)(),
    derivationPath: (0, superstruct_1.string)(),
});
/**
 * Check if an account is an HD Snap keyring account.
 *
 * @param account - Snap keyring account.
 * @returns True if valid, false otherwise.
 */
function isHdSnapKeyringAccount(account) {
    return (0, superstruct_1.is)(account.options, exports.HdSnapKeyringAccountOptionsStruct);
}
exports.isHdSnapKeyringAccount = isHdSnapKeyringAccount;

      };
    };
  }
  }
}, {package:"@metamask/accounts-controller",file:"node_modules\\@metamask\\accounts-controller\\dist\\utils.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\approval-controller\\dist\\ApprovalController.cjs", {"./errors.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\approval-controller\\dist\\errors.cjs","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","nanoid":"D:\\code\\v\\metamask-extension\\node_modules\\nanoid\\index.browser.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Capproval-controller%5Cdist%5CApprovalController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _ApprovalController_instances, _ApprovalController_approvals, _ApprovalController_origins, _ApprovalController_showApprovalRequest, _ApprovalController_typesExcludedFromRateLimiting, _ApprovalController_add, _ApprovalController_validateAddParams, _ApprovalController_addPendingApprovalOrigin, _ApprovalController_addToStore, _ApprovalController_delete, _ApprovalController_getCallbacks, _ApprovalController_result;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApprovalController = exports.APPROVAL_TYPE_RESULT_SUCCESS = exports.APPROVAL_TYPE_RESULT_ERROR = exports.ORIGIN_METAMASK = void 0;
const base_controller_1 = require("@metamask/base-controller");
const rpc_errors_1 = require("@metamask/rpc-errors");
const nanoid_1 = require("nanoid");
const errors_1 = require("./errors.cjs");
// Constants
// Avoiding dependency on controller-utils
exports.ORIGIN_METAMASK = 'metamask';
exports.APPROVAL_TYPE_RESULT_ERROR = 'result_error';
exports.APPROVAL_TYPE_RESULT_SUCCESS = 'result_success';
const controllerName = 'ApprovalController';
const stateMetadata = {
    pendingApprovals: { persist: false, anonymous: true },
    pendingApprovalCount: { persist: false, anonymous: false },
    approvalFlows: { persist: false, anonymous: false },
};
const getAlreadyPendingMessage = (origin, type) => `Request of type '${type}' already pending for origin ${origin}. Please wait.`;
const getDefaultState = () => {
    return {
        pendingApprovals: {},
        pendingApprovalCount: 0,
        approvalFlows: [],
    };
};
/**
 * Controller for managing requests that require user approval.
 *
 * Enables limiting the number of pending requests by origin and type, counting
 * pending requests, and more.
 *
 * Adding a request returns a promise that resolves or rejects when the request
 * is approved or denied, respectively.
 */
class ApprovalController extends base_controller_1.BaseController {
    /**
     * Construct an Approval controller.
     *
     * @param options - The controller options.
     * @param options.showApprovalRequest - Function for opening the UI such that
     * the request can be displayed to the user.
     * @param options.messenger - The restricted messenger for the Approval controller.
     * @param options.state - The initial controller state.
     * @param options.typesExcludedFromRateLimiting - Array of approval types which allow multiple pending approval requests from the same origin.
     */
    constructor({ messenger, showApprovalRequest, state = {}, typesExcludedFromRateLimiting = [], }) {
        super({
            name: controllerName,
            metadata: stateMetadata,
            messenger,
            state: { ...getDefaultState(), ...state },
        });
        _ApprovalController_instances.add(this);
        _ApprovalController_approvals.set(this, void 0);
        _ApprovalController_origins.set(this, void 0);
        _ApprovalController_showApprovalRequest.set(this, void 0);
        _ApprovalController_typesExcludedFromRateLimiting.set(this, void 0);
        __classPrivateFieldSet(this, _ApprovalController_approvals, new Map(), "f");
        __classPrivateFieldSet(this, _ApprovalController_origins, new Map(), "f");
        // TODO: Either fix this lint violation or explain why it's necessary to ignore.
        // eslint-disable-next-line @typescript-eslint/no-misused-promises
        __classPrivateFieldSet(this, _ApprovalController_showApprovalRequest, showApprovalRequest, "f");
        __classPrivateFieldSet(this, _ApprovalController_typesExcludedFromRateLimiting, typesExcludedFromRateLimiting, "f");
        this.registerMessageHandlers();
    }
    /**
     * Constructor helper for registering this controller's messaging system
     * actions.
     */
    registerMessageHandlers() {
        this.messagingSystem.registerActionHandler(`${controllerName}:clearRequests`, this.clear.bind(this));
        this.messagingSystem.registerActionHandler(`${controllerName}:addRequest`, (opts, shouldShowRequest) => {
            if (shouldShowRequest) {
                return this.addAndShowApprovalRequest(opts);
            }
            return this.add(opts);
        });
        this.messagingSystem.registerActionHandler(`${controllerName}:hasRequest`, this.has.bind(this));
        this.messagingSystem.registerActionHandler(`${controllerName}:acceptRequest`, this.accept.bind(this));
        this.messagingSystem.registerActionHandler(`${controllerName}:rejectRequest`, this.reject.bind(this));
        this.messagingSystem.registerActionHandler(`${controllerName}:updateRequestState`, this.updateRequestState.bind(this));
        this.messagingSystem.registerActionHandler(`${controllerName}:startFlow`, this.startFlow.bind(this));
        this.messagingSystem.registerActionHandler(`${controllerName}:endFlow`, this.endFlow.bind(this));
        this.messagingSystem.registerActionHandler(`${controllerName}:setFlowLoadingText`, this.setFlowLoadingText.bind(this));
        this.messagingSystem.registerActionHandler(`${controllerName}:showSuccess`, this.success.bind(this));
        this.messagingSystem.registerActionHandler(`${controllerName}:showError`, this.error.bind(this));
    }
    addAndShowApprovalRequest(opts) {
        const promise = __classPrivateFieldGet(this, _ApprovalController_instances, "m", _ApprovalController_add).call(this, opts.origin, opts.type, opts.id, opts.requestData, opts.requestState, opts.expectsResult);
        __classPrivateFieldGet(this, _ApprovalController_showApprovalRequest, "f").call(this);
        return promise;
    }
    add(opts) {
        return __classPrivateFieldGet(this, _ApprovalController_instances, "m", _ApprovalController_add).call(this, opts.origin, opts.type, opts.id, opts.requestData, opts.requestState, opts.expectsResult);
    }
    /**
     * Gets the info for the approval request with the given id.
     *
     * @param id - The id of the approval request.
     * @returns The approval request data associated with the id.
     */
    get(id) {
        return this.state.pendingApprovals[id];
    }
    /**
     * Gets the number of pending approvals, by origin and/or type.
     *
     * If only `origin` is specified, all approvals for that origin will be
     * counted, regardless of type.
     * If only `type` is specified, all approvals for that type will be counted,
     * regardless of origin.
     * If both `origin` and `type` are specified, 0 or 1 will be returned.
     *
     * @param opts - The approval count options.
     * @param opts.origin - An approval origin.
     * @param opts.type - The type of the approval request.
     * @returns The current approval request count for the given origin and/or
     * type.
     */
    getApprovalCount(opts = {}) {
        if (!opts.origin && !opts.type) {
            throw new Error('Must specify origin, type, or both.');
        }
        const { origin, type: _type } = opts;
        if (origin && _type) {
            return __classPrivateFieldGet(this, _ApprovalController_origins, "f").get(origin)?.get(_type) || 0;
        }
        if (origin) {
            return Array.from((__classPrivateFieldGet(this, _ApprovalController_origins, "f").get(origin) || new Map()).values()).reduce((total, value) => total + value, 0);
        }
        // Only "type" was specified
        let count = 0;
        for (const approval of Object.values(this.state.pendingApprovals)) {
            if (approval.type === _type) {
                count += 1;
            }
        }
        return count;
    }
    /**
     * Get the total count of all pending approval requests for all origins.
     *
     * @returns The total pending approval request count.
     */
    getTotalApprovalCount() {
        return this.state.pendingApprovalCount;
    }
    /**
     * Checks if there's a pending approval request per the given parameters.
     * At least one parameter must be specified. An error will be thrown if the
     * parameters are invalid.
     *
     * If `id` is specified, all other parameters will be ignored.
     * If `id` is not specified, the method will check for requests that match
     * all of the specified parameters.
     *
     * @param opts - Options bag.
     * @param opts.id - The ID to check for.
     * @param opts.origin - The origin to check for.
     * @param opts.type - The type to check for.
     * @returns `true` if a matching approval is found, and `false` otherwise.
     */
    has(opts = {}) {
        const { id, origin, type: _type } = opts;
        if (id) {
            if (typeof id !== 'string') {
                throw new Error('May not specify non-string id.');
            }
            return __classPrivateFieldGet(this, _ApprovalController_approvals, "f").has(id);
        }
        if (_type && typeof _type !== 'string') {
            throw new Error('May not specify non-string type.');
        }
        if (origin) {
            if (typeof origin !== 'string') {
                throw new Error('May not specify non-string origin.');
            }
            // Check origin and type pair if type also specified
            if (_type) {
                return Boolean(__classPrivateFieldGet(this, _ApprovalController_origins, "f").get(origin)?.get(_type));
            }
            return __classPrivateFieldGet(this, _ApprovalController_origins, "f").has(origin);
        }
        if (_type) {
            for (const approval of Object.values(this.state.pendingApprovals)) {
                if (approval.type === _type) {
                    return true;
                }
            }
            return false;
        }
        throw new Error('Must specify a valid combination of id, origin, and type.');
    }
    /**
     * Resolves the promise of the approval with the given id, and deletes the
     * approval. Throws an error if no such approval exists.
     *
     * @param id - The id of the approval request.
     * @param value - The value to resolve the approval promise with.
     * @param options - Options bag.
     * @returns A promise that either resolves once a result is provided by
     * the creator of the approval request, or immediately if `options.waitForResult`
     * is `false` or `undefined`.
     */
    accept(id, value, options) {
        // Safe to cast as the delete method below will throw if the ID is not found
        const approval = this.get(id);
        const requestPromise = __classPrivateFieldGet(this, _ApprovalController_instances, "m", _ApprovalController_getCallbacks).call(this, id);
        let requestDeleted = false;
        if (!options?.deleteAfterResult || !options.waitForResult) {
            __classPrivateFieldGet(this, _ApprovalController_instances, "m", _ApprovalController_delete).call(this, id);
            requestDeleted = true;
        }
        return new Promise((resolve, reject) => {
            const resultCallbacks = {
                success: (acceptValue) => resolve({ value: acceptValue }),
                error: reject,
            };
            if (options?.waitForResult && !approval.expectsResult) {
                reject(new errors_1.ApprovalRequestNoResultSupportError(id));
                return;
            }
            const resultValue = options?.waitForResult ? resultCallbacks : undefined;
            const resolveValue = approval.expectsResult
                ? { value, resultCallbacks: resultValue }
                : value;
            requestPromise.resolve(resolveValue);
            if (!options?.waitForResult) {
                resolve({ value: undefined });
            }
        }).finally(() => {
            if (!requestDeleted) {
                __classPrivateFieldGet(this, _ApprovalController_instances, "m", _ApprovalController_delete).call(this, id);
            }
        });
    }
    /**
     * Rejects the promise of the approval with the given id, and deletes the
     * approval. Throws an error if no such approval exists.
     *
     * @param id - The id of the approval request.
     * @param error - The error to reject the approval promise with.
     */
    reject(id, error) {
        const callbacks = __classPrivateFieldGet(this, _ApprovalController_instances, "m", _ApprovalController_getCallbacks).call(this, id);
        __classPrivateFieldGet(this, _ApprovalController_instances, "m", _ApprovalController_delete).call(this, id);
        callbacks.reject(error);
    }
    /**
     * Rejects and deletes all approval requests.
     *
     * @param rejectionError - The JsonRpcError to reject the approval
     * requests with.
     */
    clear(rejectionError) {
        for (const id of __classPrivateFieldGet(this, _ApprovalController_approvals, "f").keys()) {
            this.reject(id, rejectionError);
        }
        __classPrivateFieldGet(this, _ApprovalController_origins, "f").clear();
        this.update((draftState) => {
            draftState.pendingApprovals = {};
            draftState.pendingApprovalCount = 0;
        });
    }
    /**
     * Updates the request state of the approval with the given id.
     *
     * @param opts - Options bag.
     * @param opts.id - The id of the approval request.
     * @param opts.requestState - Additional data associated with the request
     */
    updateRequestState(opts) {
        if (!this.state.pendingApprovals[opts.id]) {
            throw new errors_1.ApprovalRequestNotFoundError(opts.id);
        }
        this.update((draftState) => {
            draftState.pendingApprovals[opts.id].requestState =
                opts.requestState;
        });
    }
    /**
     * Starts a new approval flow.
     *
     * @param opts - Options bag.
     * @param opts.id - The id of the approval flow.
     * @param opts.loadingText - The loading text that will be associated to the approval flow.
     * @param opts.show - A flag to determine whether the approval should show to the user.
     * @returns The object containing the approval flow id.
     */
    startFlow(opts = {}) {
        const id = opts.id ?? (0, nanoid_1.nanoid)();
        const loadingText = opts.loadingText ?? null;
        this.update((draftState) => {
            draftState.approvalFlows.push({ id, loadingText });
        });
        // By default, if nothing else is specified, we always show the approval.
        if (opts.show !== false) {
            __classPrivateFieldGet(this, _ApprovalController_showApprovalRequest, "f").call(this);
        }
        return { id, loadingText };
    }
    /**
     * Ends the current approval flow.
     *
     * @param opts - Options bag.
     * @param opts.id - The id of the approval flow that will be finished.
     */
    endFlow({ id }) {
        if (!this.state.approvalFlows.length) {
            throw new errors_1.NoApprovalFlowsError();
        }
        const currentFlow = this.state.approvalFlows.slice(-1)[0];
        if (id !== currentFlow.id) {
            throw new errors_1.EndInvalidFlowError(id, this.state.approvalFlows.map((flow) => flow.id));
        }
        this.update((draftState) => {
            draftState.approvalFlows.pop();
        });
    }
    /**
     * Sets the loading text for the approval flow.
     *
     * @param opts - Options bag.
     * @param opts.id - The approval flow loading text that will be displayed.
     * @param opts.loadingText - The loading text that will be associated to the approval flow.
     */
    setFlowLoadingText({ id, loadingText }) {
        const flowIndex = this.state.approvalFlows.findIndex((flow) => flow.id === id);
        if (flowIndex === -1) {
            throw new errors_1.MissingApprovalFlowError(id);
        }
        this.update((draftState) => {
            draftState.approvalFlows[flowIndex].loadingText = loadingText;
        });
    }
    /**
     * Show a success page.
     *
     * @param opts - Options bag.
     * @param opts.message - The message text or components to display in the page.
     * @param opts.header - The text or components to display in the header of the page.
     * @param opts.flowToEnd - The ID of the approval flow to end once the success page is approved.
     * @param opts.title - The title to display above the message. Shown by default but can be hidden with `null`.
     * @param opts.icon - The icon to display in the page. Shown by default but can be hidden with `null`.
     * @returns Empty object to support future additions.
     */
    async success(opts = {}) {
        await __classPrivateFieldGet(this, _ApprovalController_instances, "m", _ApprovalController_result).call(this, exports.APPROVAL_TYPE_RESULT_SUCCESS, opts, {
            message: opts.message,
            header: opts.header,
            title: opts.title,
            icon: opts.icon,
        });
        return {};
    }
    /**
     * Show an error page.
     *
     * @param opts - Options bag.
     * @param opts.message - The message text or components to display in the page.
     * @param opts.header - The text or components to display in the header of the page.
     * @param opts.flowToEnd - The ID of the approval flow to end once the error page is approved.
     * @param opts.title - The title to display above the message. Shown by default but can be hidden with `null`.
     * @param opts.icon - The icon to display in the page. Shown by default but can be hidden with `null`.
     * @returns Empty object to support future additions.
     */
    async error(opts = {}) {
        await __classPrivateFieldGet(this, _ApprovalController_instances, "m", _ApprovalController_result).call(this, exports.APPROVAL_TYPE_RESULT_ERROR, opts, {
            error: opts.error,
            header: opts.header,
            title: opts.title,
            icon: opts.icon,
        });
        return {};
    }
}
exports.ApprovalController = ApprovalController;
_ApprovalController_approvals = new WeakMap(), _ApprovalController_origins = new WeakMap(), _ApprovalController_showApprovalRequest = new WeakMap(), _ApprovalController_typesExcludedFromRateLimiting = new WeakMap(), _ApprovalController_instances = new WeakSet(), _ApprovalController_add = function _ApprovalController_add(origin, type, id = (0, nanoid_1.nanoid)(), requestData, requestState, expectsResult) {
    __classPrivateFieldGet(this, _ApprovalController_instances, "m", _ApprovalController_validateAddParams).call(this, id, origin, type, requestData, requestState);
    if (!__classPrivateFieldGet(this, _ApprovalController_typesExcludedFromRateLimiting, "f").includes(type) &&
        this.has({ origin, type })) {
        throw rpc_errors_1.rpcErrors.resourceUnavailable(getAlreadyPendingMessage(origin, type));
    }
    // add pending approval
    return new Promise((resolve, reject) => {
        __classPrivateFieldGet(this, _ApprovalController_approvals, "f").set(id, { resolve, reject });
        __classPrivateFieldGet(this, _ApprovalController_instances, "m", _ApprovalController_addPendingApprovalOrigin).call(this, origin, type);
        __classPrivateFieldGet(this, _ApprovalController_instances, "m", _ApprovalController_addToStore).call(this, id, origin, type, requestData, requestState, expectsResult);
    });
}, _ApprovalController_validateAddParams = function _ApprovalController_validateAddParams(id, origin, type, requestData, requestState) {
    let errorMessage = null;
    if (!id || typeof id !== 'string') {
        errorMessage = 'Must specify non-empty string id.';
    }
    else if (__classPrivateFieldGet(this, _ApprovalController_approvals, "f").has(id)) {
        errorMessage = `Approval request with id '${id}' already exists.`;
    }
    else if (!origin || typeof origin !== 'string') {
        errorMessage = 'Must specify non-empty string origin.';
    }
    else if (!type || typeof type !== 'string') {
        errorMessage = 'Must specify non-empty string type.';
    }
    else if (requestData &&
        (typeof requestData !== 'object' || Array.isArray(requestData))) {
        errorMessage = 'Request data must be a plain object if specified.';
    }
    else if (requestState &&
        (typeof requestState !== 'object' || Array.isArray(requestState))) {
        errorMessage = 'Request state must be a plain object if specified.';
    }
    if (errorMessage) {
        throw rpc_errors_1.rpcErrors.internal(errorMessage);
    }
}, _ApprovalController_addPendingApprovalOrigin = function _ApprovalController_addPendingApprovalOrigin(origin, type) {
    let originMap = __classPrivateFieldGet(this, _ApprovalController_origins, "f").get(origin);
    if (!originMap) {
        originMap = new Map();
        __classPrivateFieldGet(this, _ApprovalController_origins, "f").set(origin, originMap);
    }
    const currentValue = originMap.get(type) || 0;
    originMap.set(type, currentValue + 1);
}, _ApprovalController_addToStore = function _ApprovalController_addToStore(id, origin, type, requestData, requestState, expectsResult) {
    const approval = {
        id,
        origin,
        type,
        time: Date.now(),
        requestData: requestData || null,
        requestState: requestState || null,
        expectsResult: expectsResult || false,
    };
    this.update((draftState) => {
        draftState.pendingApprovals[id] = approval;
        draftState.pendingApprovalCount = Object.keys(draftState.pendingApprovals).length;
    });
}, _ApprovalController_delete = function _ApprovalController_delete(id) {
    if (!__classPrivateFieldGet(this, _ApprovalController_approvals, "f").has(id)) {
        throw new errors_1.ApprovalRequestNotFoundError(id);
    }
    __classPrivateFieldGet(this, _ApprovalController_approvals, "f").delete(id);
    const { origin, type } = this.state.pendingApprovals[id];
    const originMap = __classPrivateFieldGet(this, _ApprovalController_origins, "f").get(origin);
    const originTotalCount = this.getApprovalCount({ origin });
    const originTypeCount = originMap.get(type);
    if (originTotalCount === 1) {
        __classPrivateFieldGet(this, _ApprovalController_origins, "f").delete(origin);
    }
    else {
        originMap.set(type, originTypeCount - 1);
    }
    this.update((draftState) => {
        delete draftState.pendingApprovals[id];
        draftState.pendingApprovalCount = Object.keys(draftState.pendingApprovals).length;
    });
}, _ApprovalController_getCallbacks = function _ApprovalController_getCallbacks(id) {
    const callbacks = __classPrivateFieldGet(this, _ApprovalController_approvals, "f").get(id);
    if (!callbacks) {
        throw new errors_1.ApprovalRequestNotFoundError(id);
    }
    return callbacks;
}, _ApprovalController_result = async function _ApprovalController_result(type, opts, requestData) {
    try {
        await this.addAndShowApprovalRequest({
            origin: exports.ORIGIN_METAMASK,
            type,
            requestData,
        });
    }
    catch (error) {
        console.info('Failed to display result page', error);
    }
    finally {
        if (opts.flowToEnd) {
            try {
                this.endFlow({ id: opts.flowToEnd });
            }
            catch (error) {
                console.info('Failed to end flow', { id: opts.flowToEnd, error });
            }
        }
    }
};
exports.default = ApprovalController;

      };
    };
  }
  }
}, {package:"@metamask/approval-controller",file:"node_modules\\@metamask\\approval-controller\\dist\\ApprovalController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\approval-controller\\dist\\errors.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Capproval-controller%5Cdist%5Cerrors.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MissingApprovalFlowError = exports.EndInvalidFlowError = exports.NoApprovalFlowsError = exports.ApprovalRequestNoResultSupportError = exports.ApprovalRequestNotFoundError = void 0;
class ApprovalRequestNotFoundError extends Error {
    constructor(id) {
        super(`Approval request with id '${id}' not found.`);
    }
}
exports.ApprovalRequestNotFoundError = ApprovalRequestNotFoundError;
class ApprovalRequestNoResultSupportError extends Error {
    constructor(id) {
        super(`Approval acceptance requested result but request with id '${id}' does not support it.`);
    }
}
exports.ApprovalRequestNoResultSupportError = ApprovalRequestNoResultSupportError;
class NoApprovalFlowsError extends Error {
    constructor() {
        super(`No approval flows found.`);
    }
}
exports.NoApprovalFlowsError = NoApprovalFlowsError;
class EndInvalidFlowError extends Error {
    constructor(id, flowIds) {
        super(`Attempted to end flow with id '${id}' which does not match current flow with id '${flowIds.slice(-1)[0]}'. All Flows: ${flowIds.join(', ')}`);
    }
}
exports.EndInvalidFlowError = EndInvalidFlowError;
class MissingApprovalFlowError extends Error {
    constructor(id) {
        super(`No approval flows found with id '${id}'.`);
    }
}
exports.MissingApprovalFlowError = MissingApprovalFlowError;

      };
    };
  }
  }
}, {package:"@metamask/approval-controller",file:"node_modules\\@metamask\\approval-controller\\dist\\errors.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\approval-controller\\dist\\index.cjs", {"./ApprovalController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\approval-controller\\dist\\ApprovalController.cjs","./errors.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\approval-controller\\dist\\errors.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Capproval-controller%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./ApprovalController.cjs"), exports);
__exportStar(require("./errors.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/approval-controller",file:"node_modules\\@metamask\\approval-controller\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\AccountTrackerController.cjs", {"./multi-chain-accounts-service/api-balance-fetcher.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\multi-chain-accounts-service\\api-balance-fetcher.cjs","./rpc-service/rpc-balance-fetcher.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\rpc-service\\rpc-balance-fetcher.cjs","@ethersproject/providers":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\providers\\lib\\index.js","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/eth-query":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-query\\index.js","@metamask/polling-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\polling-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","async-mutex":"D:\\code\\v\\metamask-extension\\node_modules\\async-mutex\\lib\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CAccountTrackerController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _AccountTrackerController_instances, _AccountTrackerController_refreshMutex, _AccountTrackerController_includeStakedAssets, _AccountTrackerController_accountsApiChainIds, _AccountTrackerController_getStakedBalanceForChain, _AccountTrackerController_balanceFetchers, _AccountTrackerController_getProvider, _AccountTrackerController_getNetworkClient, _AccountTrackerController_createAccountsApiFetcher, _AccountTrackerController_getCorrectNetworkClient, _AccountTrackerController_getNetworkClientIds, _AccountTrackerController_registerMessageHandlers;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccountTrackerController = void 0;
const providers_1 = require("@ethersproject/providers");
const controller_utils_1 = require("@metamask/controller-utils");
const eth_query_1 = __importDefault(require("@metamask/eth-query"));
const polling_controller_1 = require("@metamask/polling-controller");
const utils_1 = require("@metamask/utils");
const async_mutex_1 = require("async-mutex");
const lodash_1 = require("lodash");
const api_balance_fetcher_1 = require("./multi-chain-accounts-service/api-balance-fetcher.cjs");
const rpc_balance_fetcher_1 = require("./rpc-service/rpc-balance-fetcher.cjs");
/**
 * The name of the {@link AccountTrackerController}.
 */
const controllerName = 'AccountTrackerController';
const ZERO_ADDRESS = '0x0000000000000000000000000000000000000000';
/**
 * Creates an RPC balance fetcher configured for AccountTracker use case.
 * Returns only native balances and staked balances (no token balances).
 *
 * @param getProvider - Function to get Web3Provider for a given chain ID
 * @param getNetworkClient - Function to get NetworkClient for a given chain ID
 * @param includeStakedAssets - Whether to include staked assets in the fetch
 * @returns BalanceFetcher configured to fetch only native and optionally staked balances
 */
function createAccountTrackerRpcBalanceFetcher(getProvider, getNetworkClient, includeStakedAssets) {
    // Provide empty tokens state to ensure only native and staked balances are fetched
    const getEmptyTokensState = () => ({
        allTokens: {},
        allDetectedTokens: {},
    });
    const rpcBalanceFetcher = new rpc_balance_fetcher_1.RpcBalanceFetcher(getProvider, getNetworkClient, getEmptyTokensState);
    // Wrap the RpcBalanceFetcher to filter staked balances when not needed
    return {
        supports(_chainId) {
            return rpcBalanceFetcher.supports();
        },
        async fetch(params) {
            const balances = await rpcBalanceFetcher.fetch(params);
            if (!includeStakedAssets) {
                // Filter out staked balances from the results
                return balances.filter((balance) => balance.token === ZERO_ADDRESS);
            }
            return balances;
        },
    };
}
const accountTrackerMetadata = {
    accountsByChainId: {
        includeInStateLogs: false,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
};
/**
 * Controller that tracks the network balances for all user accounts.
 */
class AccountTrackerController extends (0, polling_controller_1.StaticIntervalPollingController)() {
    /**
     * Creates an AccountTracker instance.
     *
     * @param options - The controller options.
     * @param options.interval - Polling interval used to fetch new account balances.
     * @param options.state - Initial state to set on this controller.
     * @param options.messenger - The controller messaging system.
     * @param options.getStakedBalanceForChain - The function to get the staked native asset balance for a chain.
     * @param options.includeStakedAssets - Whether to include staked assets in the account balances.
     * @param options.accountsApiChainIds - Function that returns array of chainIds that should use Accounts-API strategy (if supported by API).
     * @param options.allowExternalServices - Disable external HTTP calls (privacy / offline mode).
     */
    constructor({ interval = 10000, state, messenger, getStakedBalanceForChain, includeStakedAssets = false, accountsApiChainIds = () => [], allowExternalServices = () => true, }) {
        const { selectedNetworkClientId } = messenger.call('NetworkController:getState');
        const { configuration: { chainId }, } = messenger.call('NetworkController:getNetworkClientById', selectedNetworkClientId);
        super({
            name: controllerName,
            messenger,
            state: {
                accountsByChainId: {
                    [chainId]: {},
                },
                ...state,
            },
            metadata: accountTrackerMetadata,
        });
        _AccountTrackerController_instances.add(this);
        _AccountTrackerController_refreshMutex.set(this, new async_mutex_1.Mutex());
        _AccountTrackerController_includeStakedAssets.set(this, void 0);
        _AccountTrackerController_accountsApiChainIds.set(this, void 0);
        _AccountTrackerController_getStakedBalanceForChain.set(this, void 0);
        _AccountTrackerController_balanceFetchers.set(this, void 0);
        _AccountTrackerController_getProvider.set(this, (chainId) => {
            const { networkConfigurationsByChainId } = this.messagingSystem.call('NetworkController:getState');
            const cfg = networkConfigurationsByChainId[chainId];
            const { networkClientId } = cfg.rpcEndpoints[cfg.defaultRpcEndpointIndex];
            const client = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId);
            return new providers_1.Web3Provider(client.provider);
        });
        _AccountTrackerController_getNetworkClient.set(this, (chainId) => {
            const { networkConfigurationsByChainId } = this.messagingSystem.call('NetworkController:getState');
            const cfg = networkConfigurationsByChainId[chainId];
            const { networkClientId } = cfg.rpcEndpoints[cfg.defaultRpcEndpointIndex];
            return this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId);
        });
        /**
         * Creates an AccountsApiBalanceFetcher that only supports chains in the accountsApiChainIds array
         *
         * @returns A BalanceFetcher that wraps AccountsApiBalanceFetcher with chainId filtering
         */
        _AccountTrackerController_createAccountsApiFetcher.set(this, () => {
            const originalFetcher = new api_balance_fetcher_1.AccountsApiBalanceFetcher('extension', __classPrivateFieldGet(this, _AccountTrackerController_getProvider, "f"));
            return {
                supports: (chainId) => {
                    // Only support chains that are both:
                    // 1. In our specified accountsApiChainIds array
                    // 2. Actually supported by the AccountsApi
                    return (__classPrivateFieldGet(this, _AccountTrackerController_accountsApiChainIds, "f").call(this).includes(chainId) &&
                        originalFetcher.supports(chainId));
                },
                fetch: originalFetcher.fetch.bind(originalFetcher),
            };
        });
        __classPrivateFieldSet(this, _AccountTrackerController_getStakedBalanceForChain, getStakedBalanceForChain, "f");
        __classPrivateFieldSet(this, _AccountTrackerController_includeStakedAssets, includeStakedAssets, "f");
        __classPrivateFieldSet(this, _AccountTrackerController_accountsApiChainIds, accountsApiChainIds, "f");
        // Initialize balance fetchers - Strategy order: API first, then RPC fallback
        __classPrivateFieldSet(this, _AccountTrackerController_balanceFetchers, [
            ...(accountsApiChainIds().length > 0 && allowExternalServices()
                ? [__classPrivateFieldGet(this, _AccountTrackerController_createAccountsApiFetcher, "f").call(this)]
                : []),
            createAccountTrackerRpcBalanceFetcher(__classPrivateFieldGet(this, _AccountTrackerController_getProvider, "f"), __classPrivateFieldGet(this, _AccountTrackerController_getNetworkClient, "f"), __classPrivateFieldGet(this, _AccountTrackerController_includeStakedAssets, "f")),
        ], "f");
        this.setIntervalLength(interval);
        this.messagingSystem.subscribe('AccountsController:selectedEvmAccountChange', (newAddress, prevAddress) => {
            if (newAddress !== prevAddress) {
                // Making an async call for this new event
                // eslint-disable-next-line @typescript-eslint/no-floating-promises
                this.refresh(__classPrivateFieldGet(this, _AccountTrackerController_instances, "m", _AccountTrackerController_getNetworkClientIds).call(this));
            }
        }, (event) => event.address);
        __classPrivateFieldGet(this, _AccountTrackerController_instances, "m", _AccountTrackerController_registerMessageHandlers).call(this);
    }
    syncAccounts(newChainIds) {
        const accountsByChainId = (0, lodash_1.cloneDeep)(this.state.accountsByChainId);
        const { selectedNetworkClientId } = this.messagingSystem.call('NetworkController:getState');
        const { configuration: { chainId: currentChainId }, } = this.messagingSystem.call('NetworkController:getNetworkClientById', selectedNetworkClientId);
        const existing = Object.keys(accountsByChainId?.[currentChainId] ?? {});
        // Initialize new chain IDs if they don't exist
        newChainIds.forEach((newChainId) => {
            if (!accountsByChainId[newChainId]) {
                accountsByChainId[newChainId] = {};
                existing.forEach((address) => {
                    accountsByChainId[newChainId][address] = { balance: '0x0' };
                });
            }
        });
        // Note: The address from the preferences controller are checksummed
        // The addresses from the accounts controller are lowercased
        const addresses = Object.values(this.messagingSystem
            .call('AccountsController:listAccounts')
            .map((internalAccount) => (0, controller_utils_1.toChecksumHexAddress)(internalAccount.address)));
        const newAddresses = addresses.filter((address) => !existing.includes(address));
        const oldAddresses = existing.filter((address) => !addresses.includes(address));
        Object.keys(accountsByChainId).forEach((chainId) => {
            newAddresses.forEach((address) => {
                accountsByChainId[chainId][address] = {
                    balance: '0x0',
                };
            });
        });
        Object.keys(accountsByChainId).forEach((chainId) => {
            oldAddresses.forEach((address) => {
                delete accountsByChainId[chainId][address];
            });
        });
        if (!(0, lodash_1.isEqual)(this.state.accountsByChainId, accountsByChainId)) {
            this.update((state) => {
                state.accountsByChainId = accountsByChainId;
            });
        }
    }
    /**
     * Refreshes the balances of the accounts using the networkClientId
     *
     * @param input - The input for the poll.
     * @param input.networkClientIds - The network client IDs used to get balances.
     * @param input.queryAllAccounts - Whether to query all accounts or just the selected account
     */
    async _executePoll({ networkClientIds, queryAllAccounts = false, }) {
        // TODO: Either fix this lint violation or explain why it's necessary to ignore.
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.refresh(networkClientIds, queryAllAccounts);
    }
    /**
     * Refreshes the balances of the accounts depending on the multi-account setting.
     * If multi-account is disabled, only updates the selected account balance.
     * If multi-account is enabled, updates balances for all accounts.
     *
     * @param networkClientIds - Optional network client IDs to fetch a network client with
     * @param queryAllAccounts - Whether to query all accounts or just the selected account
     */
    async refresh(networkClientIds, queryAllAccounts = false) {
        const selectedAccount = this.messagingSystem.call('AccountsController:getSelectedAccount');
        const allAccounts = this.messagingSystem.call('AccountsController:listAccounts');
        const { isMultiAccountBalancesEnabled } = this.messagingSystem.call('PreferencesController:getState');
        const releaseLock = await __classPrivateFieldGet(this, _AccountTrackerController_refreshMutex, "f").acquire();
        try {
            const chainIds = networkClientIds.map((networkClientId) => {
                const { chainId } = __classPrivateFieldGet(this, _AccountTrackerController_instances, "m", _AccountTrackerController_getCorrectNetworkClient).call(this, networkClientId);
                return chainId;
            });
            this.syncAccounts(chainIds);
            // Use balance fetchers with fallback strategy
            const aggregated = [];
            let remainingChains = [...chainIds];
            // Try each fetcher in order, removing successfully processed chains
            for (const fetcher of __classPrivateFieldGet(this, _AccountTrackerController_balanceFetchers, "f")) {
                const supportedChains = remainingChains.filter((c) => fetcher.supports(c));
                if (!supportedChains.length) {
                    continue;
                }
                try {
                    const balances = await fetcher.fetch({
                        chainIds: supportedChains,
                        queryAllAccounts: queryAllAccounts ?? isMultiAccountBalancesEnabled,
                        selectedAccount: (0, controller_utils_1.toChecksumHexAddress)(selectedAccount.address),
                        allAccounts,
                    });
                    if (balances && balances.length > 0) {
                        aggregated.push(...balances);
                        // Remove chains that were successfully processed
                        const processedChains = new Set(balances.map((b) => b.chainId));
                        remainingChains = remainingChains.filter((chain) => !processedChains.has(chain));
                    }
                }
                catch (error) {
                    console.warn(`Balance fetcher failed for chains ${supportedChains.join(', ')}: ${String(error)}`);
                    // Continue to next fetcher (fallback)
                }
                // If all chains have been processed, break early
                if (remainingChains.length === 0) {
                    break;
                }
            }
            // Build a _copy_ of the current state and track whether anything changed
            const nextAccountsByChainId = (0, lodash_1.cloneDeep)(this.state.accountsByChainId);
            let hasChanges = false;
            // Process the aggregated balance results
            const stakedBalancesByChainAndAddress = {};
            aggregated.forEach(({ success, value, account, token, chainId }) => {
                if (success && value !== undefined) {
                    const checksumAddress = (0, controller_utils_1.toChecksumHexAddress)(account);
                    const hexValue = `0x${value.toString(16)}`;
                    if (token === ZERO_ADDRESS) {
                        // Native balance
                        // Ensure the account entry exists before accessing it
                        if (!nextAccountsByChainId[chainId]) {
                            nextAccountsByChainId[chainId] = {};
                        }
                        if (!nextAccountsByChainId[chainId][checksumAddress]) {
                            nextAccountsByChainId[chainId][checksumAddress] = {
                                balance: '0x0',
                            };
                        }
                        if (nextAccountsByChainId[chainId][checksumAddress].balance !==
                            hexValue) {
                            nextAccountsByChainId[chainId][checksumAddress].balance =
                                hexValue;
                            hasChanges = true;
                        }
                    }
                    else {
                        // Staked balance (from staking contract address)
                        if (!stakedBalancesByChainAndAddress[chainId]) {
                            stakedBalancesByChainAndAddress[chainId] = {};
                        }
                        stakedBalancesByChainAndAddress[chainId][checksumAddress] =
                            hexValue;
                    }
                }
            });
            // Apply staked balances
            Object.entries(stakedBalancesByChainAndAddress).forEach(([chainId, balancesByAddress]) => {
                Object.entries(balancesByAddress).forEach(([address, stakedBalance]) => {
                    // Ensure account structure exists
                    if (!nextAccountsByChainId[chainId]) {
                        nextAccountsByChainId[chainId] = {};
                    }
                    if (!nextAccountsByChainId[chainId][address]) {
                        nextAccountsByChainId[chainId][address] = { balance: '0x0' };
                    }
                    if (nextAccountsByChainId[chainId][address].stakedBalance !==
                        stakedBalance) {
                        nextAccountsByChainId[chainId][address].stakedBalance =
                            stakedBalance;
                        hasChanges = true;
                    }
                });
            });
            // Only update state if something changed
            if (hasChanges) {
                this.update((state) => {
                    state.accountsByChainId = nextAccountsByChainId;
                });
            }
        }
        finally {
            releaseLock();
        }
    }
    /**
     * Sync accounts balances with some additional addresses.
     *
     * @param addresses - the additional addresses, may be hardware wallet addresses.
     * @param networkClientId - Optional networkClientId to fetch a network client with.
     * @returns accounts - addresses with synced balance
     */
    async syncBalanceWithAddresses(addresses, networkClientId) {
        const { ethQuery } = __classPrivateFieldGet(this, _AccountTrackerController_instances, "m", _AccountTrackerController_getCorrectNetworkClient).call(this, networkClientId);
        // TODO: This should use multicall when enabled by the user.
        return await Promise.all(addresses.map((address) => {
            return (0, controller_utils_1.safelyExecuteWithTimeout)(async () => {
                (0, utils_1.assert)(ethQuery, 'Provider not set.');
                const balance = await (0, controller_utils_1.query)(ethQuery, 'getBalance', [address]);
                let stakedBalance;
                if (__classPrivateFieldGet(this, _AccountTrackerController_includeStakedAssets, "f")) {
                    stakedBalance = (await __classPrivateFieldGet(this, _AccountTrackerController_getStakedBalanceForChain, "f").call(this, [address], networkClientId))[address];
                }
                return [address, balance, stakedBalance];
            });
        })).then((value) => {
            return value.reduce((obj, item) => {
                if (!item) {
                    return obj;
                }
                const [address, balance, stakedBalance] = item;
                return {
                    ...obj,
                    [address]: {
                        balance,
                        stakedBalance,
                    },
                };
            }, {});
        });
    }
    /**
     * Updates the balances of multiple native tokens in a single batch operation.
     * This is more efficient than calling updateNativeToken multiple times as it
     * triggers only one state update.
     *
     * @param balances - Array of balance updates, each containing address, chainId, and balance.
     */
    updateNativeBalances(balances) {
        const nextAccountsByChainId = (0, lodash_1.cloneDeep)(this.state.accountsByChainId);
        let hasChanges = false;
        balances.forEach(({ address, chainId, balance }) => {
            const checksumAddress = (0, controller_utils_1.toChecksumHexAddress)(address);
            // Ensure the chainId exists in the state
            if (!nextAccountsByChainId[chainId]) {
                nextAccountsByChainId[chainId] = {};
                hasChanges = true;
            }
            // Check if the address exists for this chain
            const accountExists = Boolean(nextAccountsByChainId[chainId][checksumAddress]);
            // Ensure the address exists for this chain
            if (!accountExists) {
                nextAccountsByChainId[chainId][checksumAddress] = {
                    balance: '0x0',
                };
                hasChanges = true;
            }
            // Only update the balance if it has changed, or if this is a new account
            const currentBalance = nextAccountsByChainId[chainId][checksumAddress].balance;
            if (!accountExists || currentBalance !== balance) {
                nextAccountsByChainId[chainId][checksumAddress].balance = balance;
                hasChanges = true;
            }
        });
        // Only call update if there are actual changes
        if (hasChanges) {
            this.update((state) => {
                state.accountsByChainId = nextAccountsByChainId;
            });
        }
    }
    /**
     * Updates the staked balances of multiple accounts in a single batch operation.
     * This is more efficient than updating staked balances individually as it
     * triggers only one state update.
     *
     * @param stakedBalances - Array of staked balance updates, each containing address, chainId, and stakedBalance.
     */
    updateStakedBalances(stakedBalances) {
        const nextAccountsByChainId = (0, lodash_1.cloneDeep)(this.state.accountsByChainId);
        let hasChanges = false;
        stakedBalances.forEach(({ address, chainId, stakedBalance }) => {
            const checksumAddress = (0, controller_utils_1.toChecksumHexAddress)(address);
            // Ensure the chainId exists in the state
            if (!nextAccountsByChainId[chainId]) {
                nextAccountsByChainId[chainId] = {};
                hasChanges = true;
            }
            // Check if the address exists for this chain
            const accountExists = Boolean(nextAccountsByChainId[chainId][checksumAddress]);
            // Ensure the address exists for this chain
            if (!accountExists) {
                nextAccountsByChainId[chainId][checksumAddress] = {
                    balance: '0x0',
                };
                hasChanges = true;
            }
            // Only update the staked balance if it has changed, or if this is a new account
            const currentStakedBalance = nextAccountsByChainId[chainId][checksumAddress].stakedBalance;
            if (!accountExists || !(0, lodash_1.isEqual)(currentStakedBalance, stakedBalance)) {
                nextAccountsByChainId[chainId][checksumAddress].stakedBalance =
                    stakedBalance;
                hasChanges = true;
            }
        });
        // Only call update if there are actual changes
        if (hasChanges) {
            this.update((state) => {
                state.accountsByChainId = nextAccountsByChainId;
            });
        }
    }
}
exports.AccountTrackerController = AccountTrackerController;
_AccountTrackerController_refreshMutex = new WeakMap(), _AccountTrackerController_includeStakedAssets = new WeakMap(), _AccountTrackerController_accountsApiChainIds = new WeakMap(), _AccountTrackerController_getStakedBalanceForChain = new WeakMap(), _AccountTrackerController_balanceFetchers = new WeakMap(), _AccountTrackerController_getProvider = new WeakMap(), _AccountTrackerController_getNetworkClient = new WeakMap(), _AccountTrackerController_createAccountsApiFetcher = new WeakMap(), _AccountTrackerController_instances = new WeakSet(), _AccountTrackerController_getCorrectNetworkClient = function _AccountTrackerController_getCorrectNetworkClient(networkClientId) {
    const selectedNetworkClientId = networkClientId ??
        this.messagingSystem.call('NetworkController:getState')
            .selectedNetworkClientId;
    const { configuration: { chainId }, provider, blockTracker, } = this.messagingSystem.call('NetworkController:getNetworkClientById', selectedNetworkClientId);
    return {
        chainId,
        provider,
        ethQuery: new eth_query_1.default(provider),
        blockTracker,
    };
}, _AccountTrackerController_getNetworkClientIds = function _AccountTrackerController_getNetworkClientIds() {
    const { networkConfigurationsByChainId } = this.messagingSystem.call('NetworkController:getState');
    return Object.values(networkConfigurationsByChainId).flatMap((networkConfiguration) => networkConfiguration.rpcEndpoints.map((rpcEndpoint) => rpcEndpoint.networkClientId));
}, _AccountTrackerController_registerMessageHandlers = function _AccountTrackerController_registerMessageHandlers() {
    this.messagingSystem.registerActionHandler(`${controllerName}:updateNativeBalances`, this.updateNativeBalances.bind(this));
    this.messagingSystem.registerActionHandler(`${controllerName}:updateStakedBalances`, this.updateStakedBalances.bind(this));
};
exports.default = AccountTrackerController;

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\AccountTrackerController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\AssetsContractController.cjs", {"./Standards/ERC20Standard.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\Standards\\ERC20Standard.cjs","./Standards/NftStandards/ERC1155/ERC1155Standard.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\Standards\\NftStandards\\ERC1155\\ERC1155Standard.cjs","./Standards/NftStandards/ERC721/ERC721Standard.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\Standards\\NftStandards\\ERC721\\ERC721Standard.cjs","./assetsUtil.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\assetsUtil.cjs","./multicall.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\multicall.cjs","@ethersproject/contracts":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\contracts\\lib\\index.js","@ethersproject/providers":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\providers\\lib\\index.js","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","single-call-balance-checker-abi":"D:\\code\\v\\metamask-extension\\node_modules\\single-call-balance-checker-abi\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CAssetsContractController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _AssetsContractController_instances, _AssetsContractController_provider, _AssetsContractController_ipfsGateway, _AssetsContractController_chainId, _AssetsContractController_registerActionHandlers, _AssetsContractController_registerEventSubscriptions, _AssetsContractController_getCorrectProvider, _AssetsContractController_getCorrectChainId;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssetsContractController = exports.MISSING_PROVIDER_ERROR = exports.STAKING_CONTRACT_ADDRESS_BY_CHAINID = exports.SINGLE_CALL_BALANCES_ADDRESS_BY_CHAINID = void 0;
const contracts_1 = require("@ethersproject/contracts");
const providers_1 = require("@ethersproject/providers");
const controller_utils_1 = require("@metamask/controller-utils");
const utils_1 = require("@metamask/utils");
const single_call_balance_checker_abi_1 = __importDefault(require("single-call-balance-checker-abi"));
const assetsUtil_1 = require("./assetsUtil.cjs");
const multicall_1 = require("./multicall.cjs");
const ERC20Standard_1 = require("./Standards/ERC20Standard.cjs");
const ERC1155Standard_1 = require("./Standards/NftStandards/ERC1155/ERC1155Standard.cjs");
const ERC721Standard_1 = require("./Standards/NftStandards/ERC721/ERC721Standard.cjs");
/**
 * Check if token detection is enabled for certain networks
 *
 * @param chainId - ChainID of network
 * @returns Whether the current network supports token detection
 */
exports.SINGLE_CALL_BALANCES_ADDRESS_BY_CHAINID = {
    [assetsUtil_1.SupportedTokenDetectionNetworks.mainnet]: '0xb1f8e55c7f64d203c1400b9d8555d050f94adf39',
    [assetsUtil_1.SupportedTokenDetectionNetworks.bsc]: '0x2352c63A83f9Fd126af8676146721Fa00924d7e4',
    [assetsUtil_1.SupportedTokenDetectionNetworks.polygon]: '0x2352c63A83f9Fd126af8676146721Fa00924d7e4',
    [assetsUtil_1.SupportedTokenDetectionNetworks.avax]: '0xD023D153a0DFa485130ECFdE2FAA7e612EF94818',
    [assetsUtil_1.SupportedTokenDetectionNetworks.aurora]: '0x1286415D333855237f89Df27D388127181448538',
    [assetsUtil_1.SupportedTokenDetectionNetworks.linea_goerli]: '0x10dAd7Ca3921471f616db788D9300DC97Db01783',
    [assetsUtil_1.SupportedTokenDetectionNetworks.linea_mainnet]: '0xF62e6a41561b3650a69Bb03199C735e3E3328c0D',
    [assetsUtil_1.SupportedTokenDetectionNetworks.arbitrum]: '0x151E24A486D7258dd7C33Fb67E4bB01919B7B32c',
    [assetsUtil_1.SupportedTokenDetectionNetworks.optimism]: '0xB1c568e9C3E6bdaf755A60c7418C269eb11524FC',
    [assetsUtil_1.SupportedTokenDetectionNetworks.base]: '0x6AA75276052D96696134252587894ef5FFA520af',
    [assetsUtil_1.SupportedTokenDetectionNetworks.zksync]: '0x458fEd3144680a5b8bcfaa0F9594aa19B4Ea2D34',
    [assetsUtil_1.SupportedTokenDetectionNetworks.cronos]: '0x768ca200f0fc702ac9ea502498c18f5eff176378',
    [assetsUtil_1.SupportedTokenDetectionNetworks.celo]: '0x6aa75276052d96696134252587894ef5ffa520af',
    [assetsUtil_1.SupportedTokenDetectionNetworks.gnosis]: '0x6aa75276052d96696134252587894ef5ffa520af',
    [assetsUtil_1.SupportedTokenDetectionNetworks.fantom]: '0x6aa75276052d96696134252587894ef5ffa520af',
    [assetsUtil_1.SupportedTokenDetectionNetworks.polygon_zkevm]: '0x6aa75276052d96696134252587894ef5ffa520af',
    [assetsUtil_1.SupportedTokenDetectionNetworks.moonbeam]: '0x6aa75276052d96696134252587894ef5ffa520af',
    [assetsUtil_1.SupportedTokenDetectionNetworks.moonriver]: '0x6aa75276052d96696134252587894ef5ffa520af',
    [assetsUtil_1.SupportedTokenDetectionNetworks.monad_mainnet]: '0xC856736BFe4DcB217F6678Ff2C4D7A7939B29A88',
};
exports.STAKING_CONTRACT_ADDRESS_BY_CHAINID = {
    [assetsUtil_1.SupportedStakedBalanceNetworks.mainnet]: '0x4fef9d741011476750a243ac70b9789a63dd47df',
    [assetsUtil_1.SupportedStakedBalanceNetworks.hoodi]: '0xe96ac18cfe5a7af8fe1fe7bc37ff110d88bc67ff',
};
exports.MISSING_PROVIDER_ERROR = 'AssetsContractController failed to set the provider correctly. A provider must be set for this method to be available';
/**
 * The name of the {@link AssetsContractController}
 */
const name = 'AssetsContractController';
/**
 * Controller that interacts with contracts on mainnet through web3
 */
class AssetsContractController {
    /**
     * Creates a AssetsContractController instance.
     *
     * @param options - The controller options.
     * @param options.messenger - The messenger.
     * @param options.chainId - The chain ID of the current network.
     */
    constructor({ messenger, chainId: initialChainId, }) {
        _AssetsContractController_instances.add(this);
        this.name = name;
        _AssetsContractController_provider.set(this, void 0);
        _AssetsContractController_ipfsGateway.set(this, void 0);
        _AssetsContractController_chainId.set(this, void 0);
        this.messagingSystem = messenger;
        __classPrivateFieldSet(this, _AssetsContractController_provider, undefined, "f");
        __classPrivateFieldSet(this, _AssetsContractController_ipfsGateway, controller_utils_1.IPFS_DEFAULT_GATEWAY_URL, "f");
        __classPrivateFieldSet(this, _AssetsContractController_chainId, initialChainId, "f");
        __classPrivateFieldGet(this, _AssetsContractController_instances, "m", _AssetsContractController_registerActionHandlers).call(this);
        __classPrivateFieldGet(this, _AssetsContractController_instances, "m", _AssetsContractController_registerEventSubscriptions).call(this);
    }
    /**
     * Sets a new provider.
     *
     * @param provider - Provider used to create a new underlying Web3 instance
     */
    setProvider(provider) {
        __classPrivateFieldSet(this, _AssetsContractController_provider, provider, "f");
    }
    get ipfsGateway() {
        return __classPrivateFieldGet(this, _AssetsContractController_ipfsGateway, "f");
    }
    get chainId() {
        return __classPrivateFieldGet(this, _AssetsContractController_chainId, "f");
    }
    /**
     * Get a ERC20Standard instance using the relevant provider instance.
     *
     * @param networkClientId - Network Client ID used to get the provider.
     * @returns ERC20Standard instance.
     */
    getERC20Standard(networkClientId) {
        const provider = __classPrivateFieldGet(this, _AssetsContractController_instances, "m", _AssetsContractController_getCorrectProvider).call(this, networkClientId);
        return new ERC20Standard_1.ERC20Standard(provider);
    }
    /**
     * Get a ERC721Standard instance using the relevant provider instance.
     *
     * @param networkClientId - Network Client ID used to get the provider.
     * @returns ERC721Standard instance.
     */
    getERC721Standard(networkClientId) {
        const provider = __classPrivateFieldGet(this, _AssetsContractController_instances, "m", _AssetsContractController_getCorrectProvider).call(this, networkClientId);
        return new ERC721Standard_1.ERC721Standard(provider);
    }
    /**
     * Get a ERC1155Standard instance using the relevant provider instance.
     *
     * @param networkClientId - Network Client ID used to get the provider.
     * @returns ERC1155Standard instance.
     */
    getERC1155Standard(networkClientId) {
        const provider = __classPrivateFieldGet(this, _AssetsContractController_instances, "m", _AssetsContractController_getCorrectProvider).call(this, networkClientId);
        return new ERC1155Standard_1.ERC1155Standard(provider);
    }
    /**
     * Get balance or count for current account on specific asset contract.
     *
     * @param address - Asset ERC20 contract address.
     * @param selectedAddress - Current account public address.
     * @param networkClientId - Network Client ID to fetch the provider with.
     * @returns Promise resolving to BN object containing balance for current account on specific asset contract.
     */
    async getERC20BalanceOf(address, selectedAddress, networkClientId) {
        const erc20Standard = this.getERC20Standard(networkClientId);
        return erc20Standard.getBalanceOf(address, selectedAddress);
    }
    /**
     * Query for the decimals for a given ERC20 asset.
     *
     * @param address - ERC20 asset contract address.
     * @param networkClientId - Network Client ID to fetch the provider with.
     * @returns Promise resolving to the 'decimals'.
     */
    async getERC20TokenDecimals(address, networkClientId) {
        const erc20Standard = this.getERC20Standard(networkClientId);
        return erc20Standard.getTokenDecimals(address);
    }
    /**
     * Query for the name for a given ERC20 asset.
     *
     * @param address - ERC20 asset contract address.
     * @param networkClientId - Network Client ID to fetch the provider with.
     * @returns Promise resolving to the 'decimals'.
     */
    async getERC20TokenName(address, networkClientId) {
        const erc20Standard = this.getERC20Standard(networkClientId);
        return erc20Standard.getTokenName(address);
    }
    /**
     * Enumerate assets assigned to an owner.
     *
     * @param address - ERC721 asset contract address.
     * @param selectedAddress - Current account public address.
     * @param index - An NFT counter less than `balanceOf(selectedAddress)`.
     * @param networkClientId - Network Client ID to fetch the provider with.
     * @returns Promise resolving to token identifier for the 'index'th asset assigned to 'selectedAddress'.
     */
    async getERC721NftTokenId(address, selectedAddress, index, networkClientId) {
        const erc721Standard = this.getERC721Standard(networkClientId);
        return erc721Standard.getNftTokenId(address, selectedAddress, index);
    }
    /**
     * Enumerate assets assigned to an owner.
     *
     * @param tokenAddress - ERC721 asset contract address.
     * @param userAddress - Current account public address.
     * @param tokenId - ERC721 asset identifier.
     * @param networkClientId - Network Client ID to fetch the provider with.
     * @returns Promise resolving to an object containing the token standard and a set of details which depend on which standard the token supports.
     */
    async getTokenStandardAndDetails(tokenAddress, userAddress, tokenId, networkClientId) {
        // Asserts provider is available
        __classPrivateFieldGet(this, _AssetsContractController_instances, "m", _AssetsContractController_getCorrectProvider).call(this, networkClientId);
        // ERC721
        try {
            const erc721Standard = this.getERC721Standard(networkClientId);
            return {
                ...(await erc721Standard.getDetails(tokenAddress, __classPrivateFieldGet(this, _AssetsContractController_ipfsGateway, "f"), tokenId)),
            };
        }
        catch {
            // Ignore
        }
        // ERC1155
        try {
            const erc1155Standard = this.getERC1155Standard(networkClientId);
            return {
                ...(await erc1155Standard.getDetails(tokenAddress, __classPrivateFieldGet(this, _AssetsContractController_ipfsGateway, "f"), tokenId)),
            };
        }
        catch {
            // Ignore
        }
        // ERC20
        try {
            const erc20Standard = this.getERC20Standard(networkClientId);
            return {
                ...(await erc20Standard.getDetails(tokenAddress, userAddress)),
            };
        }
        catch {
            // Ignore
        }
        throw new Error('Unable to determine contract standard');
    }
    /**
     * Query for tokenURI for a given ERC721 asset.
     *
     * @param address - ERC721 asset contract address.
     * @param tokenId - ERC721 asset identifier.
     * @param networkClientId - Network Client ID to fetch the provider with.
     * @returns Promise resolving to the 'tokenURI'.
     */
    async getERC721TokenURI(address, tokenId, networkClientId) {
        const erc721Standard = this.getERC721Standard(networkClientId);
        return erc721Standard.getTokenURI(address, tokenId);
    }
    /**
     * Query for name for a given asset.
     *
     * @param address - ERC721 or ERC20 asset contract address.
     * @param networkClientId - Network Client ID to fetch the provider with.
     * @returns Promise resolving to the 'name'.
     */
    async getERC721AssetName(address, networkClientId) {
        const erc721Standard = this.getERC721Standard(networkClientId);
        return erc721Standard.getAssetName(address);
    }
    /**
     * Query for symbol for a given asset.
     *
     * @param address - ERC721 or ERC20 asset contract address.
     * @param networkClientId - Network Client ID to fetch the provider with.
     * @returns Promise resolving to the 'symbol'.
     */
    async getERC721AssetSymbol(address, networkClientId) {
        const erc721Standard = this.getERC721Standard(networkClientId);
        return erc721Standard.getAssetSymbol(address);
    }
    /**
     * Query for owner for a given ERC721 asset.
     *
     * @param address - ERC721 asset contract address.
     * @param tokenId - ERC721 asset identifier.
     * @param networkClientId - Network Client ID to fetch the provider with.
     * @returns Promise resolving to the owner address.
     */
    async getERC721OwnerOf(address, tokenId, networkClientId) {
        const erc721Standard = this.getERC721Standard(networkClientId);
        return erc721Standard.getOwnerOf(address, tokenId);
    }
    /**
     * Query for tokenURI for a given asset.
     *
     * @param address - ERC1155 asset contract address.
     * @param tokenId - ERC1155 asset identifier.
     * @param networkClientId - Network Client ID to fetch the provider with.
     * @returns Promise resolving to the 'tokenURI'.
     */
    async getERC1155TokenURI(address, tokenId, networkClientId) {
        const erc1155Standard = this.getERC1155Standard(networkClientId);
        return erc1155Standard.getTokenURI(address, tokenId);
    }
    /**
     * Query for balance of a given ERC 1155 token.
     *
     * @param userAddress - Wallet public address.
     * @param nftAddress - ERC1155 asset contract address.
     * @param nftId - ERC1155 asset identifier.
     * @param networkClientId - Network Client ID to fetch the provider with.
     * @returns Promise resolving to the 'balanceOf'.
     */
    async getERC1155BalanceOf(userAddress, nftAddress, nftId, networkClientId) {
        const erc1155Standard = this.getERC1155Standard(networkClientId);
        return erc1155Standard.getBalanceOf(nftAddress, userAddress, nftId);
    }
    /**
     * Transfer single ERC1155 token.
     *
     * @param nftAddress - ERC1155 token address.
     * @param senderAddress - ERC1155 token sender.
     * @param recipientAddress - ERC1155 token recipient.
     * @param nftId - ERC1155 token id.
     * @param qty - Quantity of tokens to be sent.
     * @param networkClientId - Network Client ID to fetch the provider with.
     * @returns Promise resolving to the 'transferSingle' ERC1155 token.
     */
    async transferSingleERC1155(nftAddress, senderAddress, recipientAddress, nftId, qty, networkClientId) {
        const erc1155Standard = this.getERC1155Standard(networkClientId);
        return erc1155Standard.transferSingle(nftAddress, senderAddress, recipientAddress, nftId, qty);
    }
    /**
     * Get the token balance for a list of token addresses in a single call. Only non-zero balances
     * are returned.
     *
     * @param selectedAddress - The address to check token balances for.
     * @param tokensToDetect - The token addresses to detect balances for.
     * @param networkClientId - Network Client ID to fetch the provider with.
     * @returns The list of non-zero token balances.
     */
    async getBalancesInSingleCall(selectedAddress, tokensToDetect, networkClientId) {
        const chainId = __classPrivateFieldGet(this, _AssetsContractController_instances, "m", _AssetsContractController_getCorrectChainId).call(this, networkClientId);
        const provider = __classPrivateFieldGet(this, _AssetsContractController_instances, "m", _AssetsContractController_getCorrectProvider).call(this, networkClientId);
        if (!((id) => id in exports.SINGLE_CALL_BALANCES_ADDRESS_BY_CHAINID)(chainId)) {
            // Only fetch balance if contract address exists
            return {};
        }
        const contractAddress = exports.SINGLE_CALL_BALANCES_ADDRESS_BY_CHAINID[chainId];
        const contract = new contracts_1.Contract(contractAddress, single_call_balance_checker_abi_1.default, provider);
        const result = await contract.balances([selectedAddress], tokensToDetect);
        const nonZeroBalances = {};
        /* istanbul ignore else */
        if (result.length > 0) {
            tokensToDetect.forEach((tokenAddress, index) => {
                const balance = result[index];
                /* istanbul ignore else */
                if (String(balance) !== '0') {
                    nonZeroBalances[tokenAddress] = balance;
                }
            });
        }
        return nonZeroBalances;
    }
    /**
     * Get the staked ethereum balance for multiple addresses in a single call.
     *
     * @param addresses - The addresses to check staked ethereum balance for.
     * @param networkClientId - Network Client ID to fetch the provider with.
     * @returns The hex staked ethereum balance for address.
     */
    async getStakedBalanceForChain(addresses, networkClientId) {
        const chainId = __classPrivateFieldGet(this, _AssetsContractController_instances, "m", _AssetsContractController_getCorrectChainId).call(this, networkClientId);
        const provider = __classPrivateFieldGet(this, _AssetsContractController_instances, "m", _AssetsContractController_getCorrectProvider).call(this, networkClientId);
        const balances = addresses.reduce((accumulator, address) => {
            accumulator[address] = '0x00';
            return accumulator;
        }, {});
        // Only fetch staked balance on supported networks
        if (![
            assetsUtil_1.SupportedStakedBalanceNetworks.mainnet,
            assetsUtil_1.SupportedStakedBalanceNetworks.hoodi,
        ].includes(chainId)) {
            return {};
        }
        // Only fetch staked balance if contract address exists
        if (!((id) => id in exports.STAKING_CONTRACT_ADDRESS_BY_CHAINID)(chainId)) {
            return {};
        }
        const contractAddress = exports.STAKING_CONTRACT_ADDRESS_BY_CHAINID[chainId];
        const abi = [
            {
                inputs: [{ internalType: 'address', name: 'account', type: 'address' }],
                name: 'getShares',
                outputs: [{ internalType: 'uint256', name: '', type: 'uint256' }],
                stateMutability: 'view',
                type: 'function',
            },
            {
                inputs: [{ internalType: 'uint256', name: 'shares', type: 'uint256' }],
                name: 'convertToAssets',
                outputs: [{ internalType: 'uint256', name: 'assets', type: 'uint256' }],
                stateMutability: 'view',
                type: 'function',
            },
        ];
        try {
            const calls = addresses.map((address) => ({
                contract: new contracts_1.Contract(contractAddress, abi, provider),
                functionSignature: 'getShares(address)',
                arguments: [address],
            }));
            const userShares = await (0, multicall_1.multicallOrFallback)(calls, chainId, provider);
            const nonZeroCalls = userShares
                .map((shares, index) => {
                if (shares.success && shares.value.gt(0)) {
                    return {
                        address: addresses[index],
                        call: {
                            contract: new contracts_1.Contract(contractAddress, abi, provider),
                            functionSignature: 'convertToAssets(uint256)',
                            arguments: [shares.value.toString()],
                        },
                    };
                }
                return null;
            })
                .filter(Boolean);
            const nonZeroBalances = await (0, multicall_1.multicallOrFallback)(nonZeroCalls.map((call) => call.call), chainId, provider);
            nonZeroBalances.forEach((balance, index) => {
                if (balance.success && balance.value) {
                    const { address } = nonZeroCalls[index];
                    balances[address] = balance.value.toHexString();
                }
            });
        }
        catch (error) {
            // if we get an error, log and return the default value
            console.error(error);
        }
        return balances;
    }
}
exports.AssetsContractController = AssetsContractController;
_AssetsContractController_provider = new WeakMap(), _AssetsContractController_ipfsGateway = new WeakMap(), _AssetsContractController_chainId = new WeakMap(), _AssetsContractController_instances = new WeakSet(), _AssetsContractController_registerActionHandlers = function _AssetsContractController_registerActionHandlers() {
    const methodsExcludedFromMessenger = [
        'constructor',
        'messagingSystem',
        'setProvider',
        'provider',
        'ipfsGateway',
        'chainId',
    ];
    (0, utils_1.getKnownPropertyNames)(Object.getPrototypeOf(this)).forEach((method) => {
        if (((key) => !methodsExcludedFromMessenger.find((e) => e === key) &&
            typeof this[key] === 'function')(method)) {
            this.messagingSystem.registerActionHandler(`${name}:${method}`, 
            // TODO: Write a generic for-loop implementation that iterates over an input union type in tandem with the input array.
            // @ts-expect-error Both assigned argument and assignee parameter are using the entire union type for `method` instead of the type for the current element
            this[method].bind(this));
        }
    });
}, _AssetsContractController_registerEventSubscriptions = function _AssetsContractController_registerEventSubscriptions() {
    this.messagingSystem.subscribe(`PreferencesController:stateChange`, ({ ipfsGateway }) => {
        __classPrivateFieldSet(this, _AssetsContractController_ipfsGateway, ipfsGateway, "f");
    });
    this.messagingSystem.subscribe(`NetworkController:networkDidChange`, ({ selectedNetworkClientId }) => {
        const chainId = __classPrivateFieldGet(this, _AssetsContractController_instances, "m", _AssetsContractController_getCorrectChainId).call(this, selectedNetworkClientId);
        if (__classPrivateFieldGet(this, _AssetsContractController_chainId, "f") !== chainId) {
            __classPrivateFieldSet(this, _AssetsContractController_chainId, chainId, "f");
            // @ts-expect-error TODO: remove this annotation once the `Eip1193Provider` class is released
            __classPrivateFieldSet(this, _AssetsContractController_provider, __classPrivateFieldGet(this, _AssetsContractController_instances, "m", _AssetsContractController_getCorrectProvider).call(this), "f");
        }
    });
}, _AssetsContractController_getCorrectProvider = function _AssetsContractController_getCorrectProvider(networkClientId) {
    const provider = networkClientId
        ? this.messagingSystem.call(`NetworkController:getNetworkClientById`, networkClientId).provider
        : (this.messagingSystem.call('NetworkController:getSelectedNetworkClient')
            ?.provider ?? __classPrivateFieldGet(this, _AssetsContractController_provider, "f"));
    if (provider === undefined) {
        throw new Error(exports.MISSING_PROVIDER_ERROR);
    }
    return new providers_1.Web3Provider(provider);
}, _AssetsContractController_getCorrectChainId = function _AssetsContractController_getCorrectChainId(networkClientId) {
    if (networkClientId) {
        const networkClientConfiguration = this.messagingSystem.call('NetworkController:getNetworkConfigurationByNetworkClientId', networkClientId);
        if (networkClientConfiguration) {
            return networkClientConfiguration.chainId;
        }
    }
    const { selectedNetworkClientId } = this.messagingSystem.call('NetworkController:getState');
    const networkClient = this.messagingSystem.call('NetworkController:getNetworkClientById', selectedNetworkClientId);
    return networkClient.configuration?.chainId ?? __classPrivateFieldGet(this, _AssetsContractController_chainId, "f");
};
exports.default = AssetsContractController;

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\AssetsContractController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\CurrencyRateController.cjs", {"./crypto-compare-service/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\crypto-compare-service\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/polling-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\polling-controller\\dist\\index.cjs","async-mutex":"D:\\code\\v\\metamask-extension\\node_modules\\async-mutex\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CCurrencyRateController.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CurrencyRateController = void 0;
const controller_utils_1 = require("@metamask/controller-utils");
const polling_controller_1 = require("@metamask/polling-controller");
const async_mutex_1 = require("async-mutex");
const crypto_compare_service_1 = require("./crypto-compare-service/index.cjs");
const name = 'CurrencyRateController';
const metadata = {
    currentCurrency: {
        includeInStateLogs: true,
        persist: true,
        anonymous: true,
        usedInUi: true,
    },
    currencyRates: {
        includeInStateLogs: true,
        persist: true,
        anonymous: true,
        usedInUi: true,
    },
};
const defaultState = {
    currentCurrency: 'usd',
    currencyRates: {
        ETH: {
            conversionDate: 0,
            conversionRate: 0,
            usdConversionRate: null,
        },
    },
};
/**
 * Controller that passively polls on a set interval for an exchange rate from the current network
 * asset to the user's preferred currency.
 */
class CurrencyRateController extends (0, polling_controller_1.StaticIntervalPollingController)() {
    /**
     * Creates a CurrencyRateController instance.
     *
     * @param options - Constructor options.
     * @param options.includeUsdRate - Keep track of the USD rate in addition to the current currency rate.
     * @param options.interval - The polling interval, in milliseconds.
     * @param options.messenger - A reference to the messaging system.
     * @param options.state - Initial state to set on this controller.
     * @param options.useExternalServices - Feature Switch for using external services (default: true)
     * @param options.fetchMultiExchangeRate - Fetches the exchange rate from an external API. This option is primarily meant for use in unit tests.
     */
    constructor({ includeUsdRate = false, interval = 180000, useExternalServices = () => true, messenger, state, fetchMultiExchangeRate = crypto_compare_service_1.fetchMultiExchangeRate, }) {
        super({
            name,
            metadata,
            messenger,
            state: { ...defaultState, ...state },
        });
        this.mutex = new async_mutex_1.Mutex();
        this.includeUsdRate = includeUsdRate;
        this.useExternalServices = useExternalServices;
        this.setIntervalLength(interval);
        this.fetchMultiExchangeRate = fetchMultiExchangeRate;
    }
    /**
     * Sets a currency to track.
     *
     * @param currentCurrency - ISO 4217 currency code.
     */
    async setCurrentCurrency(currentCurrency) {
        const releaseLock = await this.mutex.acquire();
        const nativeCurrencies = Object.keys(this.state.currencyRates);
        try {
            this.update(() => {
                return {
                    ...defaultState,
                    currentCurrency,
                };
            });
        }
        finally {
            releaseLock();
        }
        // TODO: Either fix this lint violation or explain why it's necessary to ignore.
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.updateExchangeRate(nativeCurrencies);
    }
    /**
     * Updates the exchange rate for the current currency and native currency pairs.
     *
     * @param nativeCurrencies - The native currency symbols to fetch exchange rates for.
     */
    async updateExchangeRate(nativeCurrencies) {
        if (!this.useExternalServices()) {
            return;
        }
        const releaseLock = await this.mutex.acquire();
        try {
            const { currentCurrency } = this.state;
            // For preloaded testnets (Goerli, Sepolia) we want to fetch exchange rate for real ETH.
            // Map each native currency to the symbol we want to fetch for it.
            const testnetSymbols = Object.values(controller_utils_1.TESTNET_TICKER_SYMBOLS);
            const nativeCurrenciesToFetch = nativeCurrencies.reduce((acc, nativeCurrency) => {
                if (!nativeCurrency) {
                    return acc;
                }
                acc[nativeCurrency] = testnetSymbols.includes(nativeCurrency)
                    ? controller_utils_1.FALL_BACK_VS_CURRENCY
                    : nativeCurrency;
                return acc;
            }, {});
            const fetchExchangeRateResponse = await this.fetchMultiExchangeRate(currentCurrency, [...new Set(Object.values(nativeCurrenciesToFetch))], this.includeUsdRate);
            const rates = Object.entries(nativeCurrenciesToFetch).reduce((acc, [nativeCurrency, fetchedCurrency]) => {
                const rate = fetchExchangeRateResponse[fetchedCurrency.toLowerCase()];
                acc[nativeCurrency] = {
                    conversionDate: rate !== undefined ? Date.now() / 1000 : null,
                    conversionRate: rate?.[currentCurrency.toLowerCase()] ?? null,
                    usdConversionRate: rate?.usd ?? null,
                };
                return acc;
            }, {});
            this.update((state) => {
                state.currencyRates = {
                    ...state.currencyRates,
                    ...rates,
                };
            });
        }
        catch (error) {
            console.error('Failed to fetch exchange rates.', error);
            throw error;
        }
        finally {
            releaseLock();
        }
    }
    /**
     * Prepare to discard this controller.
     *
     * This stops any active polling.
     */
    destroy() {
        super.destroy();
        this.stopAllPolling();
    }
    /**
     * Updates exchange rate for the current currency.
     *
     * @param input - The input for the poll.
     * @param input.nativeCurrencies - The native currency symbols to poll prices for.
     */
    async _executePoll({ nativeCurrencies, }) {
        await this.updateExchangeRate(nativeCurrencies);
    }
}
exports.CurrencyRateController = CurrencyRateController;
exports.default = CurrencyRateController;

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\CurrencyRateController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\DeFiPositionsController\\DeFiPositionsController.cjs", {"../assetsUtil.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\assetsUtil.cjs","./calculate-defi-metrics.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\DeFiPositionsController\\calculate-defi-metrics.cjs","./fetch-positions.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\DeFiPositionsController\\fetch-positions.cjs","./group-defi-positions.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\DeFiPositionsController\\group-defi-positions.cjs","@metamask/polling-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\polling-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CDeFiPositionsController%5CDeFiPositionsController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _DeFiPositionsController_instances, _DeFiPositionsController_fetchPositions, _DeFiPositionsController_isEnabled, _DeFiPositionsController_trackEvent, _DeFiPositionsController_updateAccountPositions, _DeFiPositionsController_fetchAccountPositions, _DeFiPositionsController_updatePositionsCountMetrics;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeFiPositionsController = exports.getDefaultDefiPositionsControllerState = void 0;
const polling_controller_1 = require("@metamask/polling-controller");
const calculate_defi_metrics_1 = require("./calculate-defi-metrics.cjs");
const fetch_positions_1 = require("./fetch-positions.cjs");
const group_defi_positions_1 = require("./group-defi-positions.cjs");
const assetsUtil_1 = require("../assetsUtil.cjs");
const TEN_MINUTES_IN_MS = 600000;
const FETCH_POSITIONS_BATCH_SIZE = 10;
const controllerName = 'DeFiPositionsController';
const controllerMetadata = {
    allDeFiPositions: {
        includeInStateLogs: false,
        persist: false,
        anonymous: false,
        usedInUi: true,
    },
    allDeFiPositionsCount: {
        includeInStateLogs: false,
        persist: false,
        anonymous: false,
        usedInUi: false,
    },
};
const getDefaultDefiPositionsControllerState = () => {
    return {
        allDeFiPositions: {},
        allDeFiPositionsCount: {},
    };
};
exports.getDefaultDefiPositionsControllerState = getDefaultDefiPositionsControllerState;
/**
 * Controller that stores assets and exposes convenience methods
 */
class DeFiPositionsController extends (0, polling_controller_1.StaticIntervalPollingController)() {
    /**
     * DeFiPositionsController constuctor
     *
     * @param options - Constructor options.
     * @param options.messenger - The controller messenger.
     * @param options.isEnabled - Function that returns whether the controller is enabled. (default: () => true)
     * @param options.trackEvent - Function to track events. (default: undefined)
     */
    constructor({ messenger, isEnabled = () => true, trackEvent, }) {
        super({
            name: controllerName,
            metadata: controllerMetadata,
            messenger,
            state: (0, exports.getDefaultDefiPositionsControllerState)(),
        });
        _DeFiPositionsController_instances.add(this);
        _DeFiPositionsController_fetchPositions.set(this, void 0);
        _DeFiPositionsController_isEnabled.set(this, void 0);
        _DeFiPositionsController_trackEvent.set(this, void 0);
        this.setIntervalLength(TEN_MINUTES_IN_MS);
        __classPrivateFieldSet(this, _DeFiPositionsController_fetchPositions, (0, fetch_positions_1.buildPositionFetcher)(), "f");
        __classPrivateFieldSet(this, _DeFiPositionsController_isEnabled, isEnabled, "f");
        this.messagingSystem.subscribe('KeyringController:unlock', () => {
            this.startPolling(null);
        });
        this.messagingSystem.subscribe('KeyringController:lock', () => {
            this.stopAllPolling();
        });
        this.messagingSystem.subscribe('TransactionController:transactionConfirmed', async (transactionMeta) => {
            if (!__classPrivateFieldGet(this, _DeFiPositionsController_isEnabled, "f").call(this)) {
                return;
            }
            await __classPrivateFieldGet(this, _DeFiPositionsController_instances, "m", _DeFiPositionsController_updateAccountPositions).call(this, transactionMeta.txParams.from);
        });
        this.messagingSystem.subscribe('AccountsController:accountAdded', async (account) => {
            if (!__classPrivateFieldGet(this, _DeFiPositionsController_isEnabled, "f").call(this) || !account.type.startsWith('eip155:')) {
                return;
            }
            await __classPrivateFieldGet(this, _DeFiPositionsController_instances, "m", _DeFiPositionsController_updateAccountPositions).call(this, account.address);
        });
        __classPrivateFieldSet(this, _DeFiPositionsController_trackEvent, trackEvent, "f");
    }
    async _executePoll() {
        if (!__classPrivateFieldGet(this, _DeFiPositionsController_isEnabled, "f").call(this)) {
            return;
        }
        const accounts = this.messagingSystem.call('AccountsController:listAccounts');
        const initialResult = [];
        const results = await (0, assetsUtil_1.reduceInBatchesSerially)({
            initialResult,
            values: accounts,
            batchSize: FETCH_POSITIONS_BATCH_SIZE,
            eachBatch: async (workingResult, batch) => {
                const batchResults = (await Promise.all(batch.map(async ({ address: accountAddress, type }) => {
                    if (type.startsWith('eip155:')) {
                        const positions = await __classPrivateFieldGet(this, _DeFiPositionsController_instances, "m", _DeFiPositionsController_fetchAccountPositions).call(this, accountAddress);
                        return {
                            accountAddress,
                            positions,
                        };
                    }
                    return undefined;
                }))).filter(Boolean);
                return [...workingResult, ...batchResults];
            },
        });
        const allDefiPositions = results.reduce((acc, { accountAddress, positions }) => {
            acc[accountAddress] = positions;
            return acc;
        }, {});
        this.update((state) => {
            state.allDeFiPositions = allDefiPositions;
        });
    }
}
exports.DeFiPositionsController = DeFiPositionsController;
_DeFiPositionsController_fetchPositions = new WeakMap(), _DeFiPositionsController_isEnabled = new WeakMap(), _DeFiPositionsController_trackEvent = new WeakMap(), _DeFiPositionsController_instances = new WeakSet(), _DeFiPositionsController_updateAccountPositions = async function _DeFiPositionsController_updateAccountPositions(accountAddress) {
    const accountPositionsPerChain = await __classPrivateFieldGet(this, _DeFiPositionsController_instances, "m", _DeFiPositionsController_fetchAccountPositions).call(this, accountAddress);
    this.update((state) => {
        state.allDeFiPositions[accountAddress] = accountPositionsPerChain;
    });
}, _DeFiPositionsController_fetchAccountPositions = async function _DeFiPositionsController_fetchAccountPositions(accountAddress) {
    try {
        const defiPositionsResponse = await __classPrivateFieldGet(this, _DeFiPositionsController_fetchPositions, "f").call(this, accountAddress);
        const groupedDeFiPositions = (0, group_defi_positions_1.groupDeFiPositions)(defiPositionsResponse);
        try {
            __classPrivateFieldGet(this, _DeFiPositionsController_instances, "m", _DeFiPositionsController_updatePositionsCountMetrics).call(this, groupedDeFiPositions, accountAddress);
        }
        catch (error) {
            console.error(`Failed to update positions count for account ${accountAddress}:`, error);
        }
        return groupedDeFiPositions;
    }
    catch {
        return null;
    }
}, _DeFiPositionsController_updatePositionsCountMetrics = function _DeFiPositionsController_updatePositionsCountMetrics(groupedDeFiPositions, accountAddress) {
    // If no track event passed then skip the metrics update
    if (!__classPrivateFieldGet(this, _DeFiPositionsController_trackEvent, "f")) {
        return;
    }
    const defiMetrics = (0, calculate_defi_metrics_1.calculateDeFiPositionMetrics)(groupedDeFiPositions);
    const { totalPositions } = defiMetrics.properties;
    if (totalPositions !== this.state.allDeFiPositionsCount[accountAddress]) {
        this.update((state) => {
            state.allDeFiPositionsCount[accountAddress] = totalPositions;
        });
        __classPrivateFieldGet(this, _DeFiPositionsController_trackEvent, "f")?.call(this, defiMetrics);
    }
};

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\DeFiPositionsController\\DeFiPositionsController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\DeFiPositionsController\\calculate-defi-metrics.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CDeFiPositionsController%5Ccalculate-defi-metrics.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.calculateDeFiPositionMetrics = void 0;
/**
 * Calculates the total market value and total positions for a given account
 * and returns a breakdown of the market value per protocol.
 *
 * @param accountPositionsPerChain - The account positions per chain.
 * @returns An object containing the total market value, total positions, and a breakdown of the market value per protocol.
 */
function calculateDeFiPositionMetrics(accountPositionsPerChain) {
    let totalMarketValueUSD = 0;
    let totalPositions = 0;
    const breakdown = [];
    Object.entries(accountPositionsPerChain).forEach(([chainId, chainPositions]) => {
        const chainTotalMarketValueUSD = chainPositions.aggregatedMarketValue;
        totalMarketValueUSD += chainTotalMarketValueUSD;
        Object.entries(chainPositions.protocols).forEach(([protocolId, protocol]) => {
            const protocolTotalMarketValueUSD = protocol.aggregatedMarketValue;
            const protocolCount = Object.values(protocol.positionTypes).reduce((acc, positionType) => acc + (positionType?.positions?.flat().length || 0), 0);
            totalPositions += protocolCount;
            breakdown.push({
                protocolId,
                marketValueUSD: protocolTotalMarketValueUSD,
                chainId: chainId,
                count: protocolCount,
            });
        });
    });
    return {
        category: 'DeFi',
        event: 'DeFi Stats',
        properties: {
            totalMarketValueUSD,
            totalPositions,
            breakdown,
        },
    };
}
exports.calculateDeFiPositionMetrics = calculateDeFiPositionMetrics;

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\DeFiPositionsController\\calculate-defi-metrics.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\DeFiPositionsController\\fetch-positions.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CDeFiPositionsController%5Cfetch-positions.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildPositionFetcher = exports.DEFI_POSITIONS_API_URL = void 0;
// TODO: Update with prod API URL when available
exports.DEFI_POSITIONS_API_URL = 'https://defiadapters.api.cx.metamask.io';
/**
 * Builds a function that fetches DeFi positions for a given account address
 *
 * @returns A function that fetches DeFi positions for a given account address
 */
function buildPositionFetcher() {
    return async (accountAddress) => {
        const defiPositionsResponse = await fetch(`${exports.DEFI_POSITIONS_API_URL}/positions/${accountAddress}`);
        if (defiPositionsResponse.status !== 200) {
            throw new Error(`Unable to fetch defi positions - HTTP ${defiPositionsResponse.status}`);
        }
        return (await defiPositionsResponse.json()).data;
    };
}
exports.buildPositionFetcher = buildPositionFetcher;

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\DeFiPositionsController\\fetch-positions.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\DeFiPositionsController\\group-defi-positions.cjs", {"@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CDeFiPositionsController%5Cgroup-defi-positions.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.groupDeFiPositions = void 0;
const controller_utils_1 = require("@metamask/controller-utils");
/**
 *
 * @param defiPositionsResponse - The response from the defi positions API
 * @returns The grouped positions that get assigned to the state
 */
function groupDeFiPositions(defiPositionsResponse) {
    const groupedDeFiPositions = {};
    for (const position of defiPositionsResponse) {
        if (!position.success) {
            continue;
        }
        const { chainId, protocolId, iconUrl, positionType, protocolDisplayName } = position;
        const chain = (0, controller_utils_1.toHex)(chainId);
        if (!groupedDeFiPositions[chain]) {
            groupedDeFiPositions[chain] = {
                aggregatedMarketValue: 0,
                protocols: {},
            };
        }
        const chainData = groupedDeFiPositions[chain];
        if (!chainData.protocols[protocolId]) {
            chainData.protocols[protocolId] = {
                protocolDetails: {
                    name: protocolDisplayName,
                    iconUrl,
                },
                aggregatedMarketValue: 0,
                positionTypes: {},
            };
        }
        const protocolData = chainData.protocols[protocolId];
        let positionTypeData = protocolData.positionTypes[positionType];
        if (!positionTypeData) {
            positionTypeData = {
                aggregatedMarketValue: 0,
                positions: [],
            };
            protocolData.positionTypes[positionType] = positionTypeData;
        }
        for (const protocolToken of position.tokens) {
            const token = processToken(protocolToken);
            // If groupPositions is true, we group all positions of the same type
            if (position.metadata?.groupPositions) {
                if (positionTypeData.positions.length === 0) {
                    positionTypeData.positions.push([token]);
                }
                else {
                    positionTypeData.positions[0].push(token);
                }
            }
            else {
                positionTypeData.positions.push([token]);
            }
            if (token.marketValue) {
                const multiplier = position.positionType === 'borrow' ? -1 : 1;
                positionTypeData.aggregatedMarketValue += token.marketValue;
                protocolData.aggregatedMarketValue += token.marketValue * multiplier;
                chainData.aggregatedMarketValue += token.marketValue * multiplier;
            }
        }
    }
    return groupedDeFiPositions;
}
exports.groupDeFiPositions = groupDeFiPositions;
/**
 *
 * @param tokenBalance - The token balance that is going to be processed
 * @returns The processed token balance
 */
function processToken(tokenBalance) {
    if (!tokenBalance.tokens) {
        return {
            ...tokenBalance,
            marketValue: tokenBalance.price
                ? tokenBalance.balance * tokenBalance.price
                : undefined,
        };
    }
    const processedTokens = tokenBalance.tokens.map((t) => {
        const { tokens, ...tokenWithoutUnderlyings } = processToken(t);
        return tokenWithoutUnderlyings;
    });
    const marketValue = processedTokens.reduce((acc, t) => acc === undefined || t.marketValue === undefined
        ? undefined
        : acc + t.marketValue, 0);
    return {
        ...tokenBalance,
        marketValue,
        tokens: processedTokens,
    };
}

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\DeFiPositionsController\\group-defi-positions.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\MultichainAssetsController\\MultichainAssetsController.cjs", {"./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\MultichainAssetsController\\utils.cjs","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/keyring-snap-client":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","async-mutex":"D:\\code\\v\\metamask-extension\\node_modules\\async-mutex\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CMultichainAssetsController%5CMultichainAssetsController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _MultichainAssetsController_instances, _MultichainAssetsController_snaps, _MultichainAssetsController_controllerOperationMutex, _MultichainAssetsController_handleAccountAssetListUpdatedEvent, _MultichainAssetsController_handleOnAccountAddedEvent, _MultichainAssetsController_registerMessageHandlers, _MultichainAssetsController_handleAccountAssetListUpdated, _MultichainAssetsController_isNonEvmAccount, _MultichainAssetsController_handleOnAccountAdded, _MultichainAssetsController_handleOnAccountRemovedEvent, _MultichainAssetsController_refreshAssetsMetadata, _MultichainAssetsController_updateAssetsMetadata, _MultichainAssetsController_getAssetSnaps, _MultichainAssetsController_getAssetSnapFor, _MultichainAssetsController_getAllSnaps, _MultichainAssetsController_getSnapsPermissions, _MultichainAssetsController_getAssetsMetadataFrom, _MultichainAssetsController_getAssetsList, _MultichainAssetsController_getClient, _MultichainAssetsController_assertControllerMutexIsLocked, _MultichainAssetsController_withControllerLock;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultichainAssetsController = exports.getDefaultMultichainAssetsControllerState = void 0;
const base_controller_1 = require("@metamask/base-controller");
const keyring_api_1 = require("@metamask/keyring-api");
const keyring_snap_client_1 = require("@metamask/keyring-snap-client");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
const async_mutex_1 = require("async-mutex");
const utils_2 = require("./utils.cjs");
const controllerName = 'MultichainAssetsController';
/**
 * Constructs the default {@link MultichainAssetsController} state. This allows
 * consumers to provide a partial state object when initializing the controller
 * and also helps in constructing complete state objects for this controller in
 * tests.
 *
 * @returns The default {@link MultichainAssetsController} state.
 */
function getDefaultMultichainAssetsControllerState() {
    return { accountsAssets: {}, assetsMetadata: {} };
}
exports.getDefaultMultichainAssetsControllerState = getDefaultMultichainAssetsControllerState;
/**
 * {@link MultichainAssetsController}'s metadata.
 *
 * This allows us to choose if fields of the state should be persisted or not
 * using the `persist` flag; and if they can be sent to Sentry or not, using
 * the `anonymous` flag.
 */
const assetsControllerMetadata = {
    assetsMetadata: {
        includeInStateLogs: false,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
    accountsAssets: {
        includeInStateLogs: false,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
};
// TODO: make this controller extends StaticIntervalPollingController and update all assetsMetadata once a day.
class MultichainAssetsController extends base_controller_1.BaseController {
    constructor({ messenger, state = {}, }) {
        super({
            messenger,
            name: controllerName,
            metadata: assetsControllerMetadata,
            state: {
                ...getDefaultMultichainAssetsControllerState(),
                ...state,
            },
        });
        _MultichainAssetsController_instances.add(this);
        // Mapping of CAIP-2 Chain ID to Asset Snaps.
        _MultichainAssetsController_snaps.set(this, void 0);
        _MultichainAssetsController_controllerOperationMutex.set(this, new async_mutex_1.Mutex());
        __classPrivateFieldSet(this, _MultichainAssetsController_snaps, {}, "f");
        this.messagingSystem.subscribe('AccountsController:accountAdded', async (account) => await __classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_handleOnAccountAddedEvent).call(this, account));
        this.messagingSystem.subscribe('AccountsController:accountRemoved', async (account) => await __classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_handleOnAccountRemovedEvent).call(this, account));
        this.messagingSystem.subscribe('AccountsController:accountAssetListUpdated', async (event) => await __classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_handleAccountAssetListUpdatedEvent).call(this, event));
        __classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_registerMessageHandlers).call(this);
    }
    /**
     * Returns the metadata for the given asset
     *
     * @param asset - The asset to get metadata for
     * @returns The metadata for the asset or undefined if not found.
     */
    getAssetMetadata(asset) {
        return this.state.assetsMetadata[asset];
    }
}
exports.MultichainAssetsController = MultichainAssetsController;
_MultichainAssetsController_snaps = new WeakMap(), _MultichainAssetsController_controllerOperationMutex = new WeakMap(), _MultichainAssetsController_instances = new WeakSet(), _MultichainAssetsController_handleAccountAssetListUpdatedEvent = async function _MultichainAssetsController_handleAccountAssetListUpdatedEvent(event) {
    return __classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_withControllerLock).call(this, async () => __classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_handleAccountAssetListUpdated).call(this, event));
}, _MultichainAssetsController_handleOnAccountAddedEvent = async function _MultichainAssetsController_handleOnAccountAddedEvent(account) {
    return __classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_withControllerLock).call(this, async () => __classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_handleOnAccountAdded).call(this, account));
}, _MultichainAssetsController_registerMessageHandlers = function _MultichainAssetsController_registerMessageHandlers() {
    this.messagingSystem.registerActionHandler('MultichainAssetsController:getAssetMetadata', this.getAssetMetadata.bind(this));
}, _MultichainAssetsController_handleAccountAssetListUpdated = 
/**
 * Function to update the assets list for an account
 *
 * @param event - The list of assets to update
 */
async function _MultichainAssetsController_handleAccountAssetListUpdated(event) {
    __classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_assertControllerMutexIsLocked).call(this);
    const assetsForMetadataRefresh = new Set([]);
    const accountsAndAssetsToUpdate = {};
    for (const [accountId, { added, removed }] of Object.entries(event.assets)) {
        if (added.length > 0 || removed.length > 0) {
            const existing = this.state.accountsAssets[accountId] || [];
            // In case accountsAndAssetsToUpdate event is fired with "added" assets that already exist, we don't want to add them again
            const filteredToBeAddedAssets = added.filter((asset) => !existing.includes(asset) && (0, utils_1.isCaipAssetType)(asset));
            // In case accountsAndAssetsToUpdate event is fired with "removed" assets that don't exist, we don't want to remove them
            const filteredToBeRemovedAssets = removed.filter((asset) => existing.includes(asset) && (0, utils_1.isCaipAssetType)(asset));
            if (filteredToBeAddedAssets.length > 0 ||
                filteredToBeRemovedAssets.length > 0) {
                accountsAndAssetsToUpdate[accountId] = {
                    added: filteredToBeAddedAssets,
                    removed: filteredToBeRemovedAssets,
                };
            }
            for (const asset of existing) {
                assetsForMetadataRefresh.add(asset);
            }
            for (const asset of filteredToBeAddedAssets) {
                assetsForMetadataRefresh.add(asset);
            }
            for (const asset of filteredToBeRemovedAssets) {
                assetsForMetadataRefresh.delete(asset);
            }
        }
    }
    this.update((state) => {
        for (const [accountId, { added, removed }] of Object.entries(accountsAndAssetsToUpdate)) {
            const assets = new Set([
                ...(state.accountsAssets[accountId] || []),
                ...added,
            ]);
            for (const asset of removed) {
                assets.delete(asset);
            }
            state.accountsAssets[accountId] = Array.from(assets);
        }
    });
    // Trigger fetching metadata for new assets
    await __classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_refreshAssetsMetadata).call(this, Array.from(assetsForMetadataRefresh));
    this.messagingSystem.publish(`${controllerName}:accountAssetListUpdated`, {
        assets: accountsAndAssetsToUpdate,
    });
}, _MultichainAssetsController_isNonEvmAccount = function _MultichainAssetsController_isNonEvmAccount(account) {
    return (!(0, keyring_api_1.isEvmAccountType)(account.type) &&
        // Non-EVM accounts are backed by a Snap for now
        account.metadata.snap !== undefined);
}, _MultichainAssetsController_handleOnAccountAdded = 
/**
 * Handles changes when a new account has been added.
 *
 * @param account - The new account being added.
 */
async function _MultichainAssetsController_handleOnAccountAdded(account) {
    if (!__classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_isNonEvmAccount).call(this, account)) {
        // Nothing to do here for EVM accounts
        return;
    }
    __classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_assertControllerMutexIsLocked).call(this);
    // Get assets list
    if (account.metadata.snap) {
        const assets = await __classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_getAssetsList).call(this, account.id, account.metadata.snap.id);
        await __classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_refreshAssetsMetadata).call(this, assets);
        this.update((state) => {
            state.accountsAssets[account.id] = assets;
        });
        this.messagingSystem.publish(`${controllerName}:accountAssetListUpdated`, {
            assets: {
                [account.id]: {
                    added: assets,
                    removed: [],
                },
            },
        });
    }
}, _MultichainAssetsController_handleOnAccountRemovedEvent = 
/**
 * Handles changes when a new account has been removed.
 *
 * @param accountId - The new account id being removed.
 */
async function _MultichainAssetsController_handleOnAccountRemovedEvent(accountId) {
    // Check if accountId is in accountsAssets and if it is, remove it
    if (this.state.accountsAssets[accountId]) {
        this.update((state) => {
            // TODO: We are not deleting the assetsMetadata because we will soon make this controller extends StaticIntervalPollingController
            // and update all assetsMetadata once a day.
            delete state.accountsAssets[accountId];
        });
    }
}, _MultichainAssetsController_refreshAssetsMetadata = 
/**
 * Refreshes the assets snaps and metadata for the given list of assets
 *
 * @param assets - The assets to refresh
 */
async function _MultichainAssetsController_refreshAssetsMetadata(assets) {
    __classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_assertControllerMutexIsLocked).call(this);
    const assetsWithoutMetadata = assets.filter((asset) => !this.state.assetsMetadata[asset]);
    // Call the snap to get the metadata
    if (assetsWithoutMetadata.length > 0) {
        // Check if for every asset in assetsWithoutMetadata there is a snap in snaps by chainId else call getAssetSnaps
        if (!assetsWithoutMetadata.every((asset) => {
            const { chainId } = (0, utils_1.parseCaipAssetType)(asset);
            return Boolean(__classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_getAssetSnapFor).call(this, chainId));
        })) {
            __classPrivateFieldSet(this, _MultichainAssetsController_snaps, __classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_getAssetSnaps).call(this), "f");
        }
        await __classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_updateAssetsMetadata).call(this, assetsWithoutMetadata);
    }
}, _MultichainAssetsController_updateAssetsMetadata = 
/**
 * Updates the assets metadata for the given list of assets
 *
 * @param assets - The assets to update
 */
async function _MultichainAssetsController_updateAssetsMetadata(assets) {
    // Creates a mapping of scope to their respective assets list.
    const assetsByScope = {};
    for (const asset of assets) {
        const { chainId } = (0, utils_1.parseCaipAssetType)(asset);
        if (!assetsByScope[chainId]) {
            assetsByScope[chainId] = [];
        }
        assetsByScope[chainId].push(asset);
    }
    let newMetadata = {};
    for (const chainId of Object.keys(assetsByScope)) {
        const assetsForChain = assetsByScope[chainId];
        // Now fetch metadata from the associated asset Snaps:
        const snap = __classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_getAssetSnapFor).call(this, chainId);
        if (snap) {
            const metadata = await __classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_getAssetsMetadataFrom).call(this, assetsForChain, snap.id);
            newMetadata = {
                ...newMetadata,
                ...(metadata?.assets ?? {}),
            };
        }
    }
    this.update((state) => {
        state.assetsMetadata = {
            ...this.state.assetsMetadata,
            ...newMetadata,
        };
    });
}, _MultichainAssetsController_getAssetSnaps = function _MultichainAssetsController_getAssetSnaps() {
    const snaps = {};
    const allSnaps = __classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_getAllSnaps).call(this);
    const allPermissions = allSnaps.map((snap) => __classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_getSnapsPermissions).call(this, snap.id));
    for (const [index, permission] of allPermissions.entries()) {
        let scopes;
        for (const singlePermissionConstraint of Object.values(permission)) {
            scopes = (0, utils_2.getChainIdsCaveat)(singlePermissionConstraint);
            if (!scopes) {
                continue;
            }
            for (const scope of scopes) {
                if (!snaps[scope]) {
                    snaps[scope] = [];
                }
                snaps[scope].push(allSnaps[index]);
            }
        }
    }
    return snaps;
}, _MultichainAssetsController_getAssetSnapFor = function _MultichainAssetsController_getAssetSnapFor(scope) {
    const allSnaps = __classPrivateFieldGet(this, _MultichainAssetsController_snaps, "f")[scope];
    // Pick only the first one, we ignore the other Snaps if there are multiple candidates for now.
    return allSnaps?.[0]; // Will be undefined if there's no Snaps candidate for this scope.
}, _MultichainAssetsController_getAllSnaps = function _MultichainAssetsController_getAllSnaps() {
    // TODO: Use dedicated SnapController's action once available for this:
    return this.messagingSystem
        .call('SnapController:getAll')
        .filter((snap) => snap.enabled && !snap.blocked);
}, _MultichainAssetsController_getSnapsPermissions = function _MultichainAssetsController_getSnapsPermissions(origin) {
    return this.messagingSystem.call('PermissionController:getPermissions', origin);
}, _MultichainAssetsController_getAssetsMetadataFrom = 
/**
 * Returns the metadata for the given assets
 *
 * @param assets - The assets to get metadata for
 * @param snapId - The snap ID to get metadata from
 * @returns The metadata for the assets
 */
async function _MultichainAssetsController_getAssetsMetadataFrom(assets, snapId) {
    try {
        return (await this.messagingSystem.call('SnapController:handleRequest', {
            snapId: snapId,
            origin: 'metamask',
            handler: snaps_utils_1.HandlerType.OnAssetsLookup,
            request: {
                jsonrpc: '2.0',
                method: 'onAssetLookup',
                params: {
                    assets,
                },
            },
        }));
    }
    catch (error) {
        // Ignore
        console.error(error);
        return undefined;
    }
}, _MultichainAssetsController_getAssetsList = 
/**
 * Get assets list for an account
 *
 * @param accountId - AccountId to get assets for
 * @param snapId - Snap ID for the account
 * @returns list of assets
 */
async function _MultichainAssetsController_getAssetsList(accountId, snapId) {
    return await __classPrivateFieldGet(this, _MultichainAssetsController_instances, "m", _MultichainAssetsController_getClient).call(this, snapId).listAccountAssets(accountId);
}, _MultichainAssetsController_getClient = function _MultichainAssetsController_getClient(snapId) {
    return new keyring_snap_client_1.KeyringClient({
        send: async (request) => (await this.messagingSystem.call('SnapController:handleRequest', {
            snapId: snapId,
            origin: 'metamask',
            handler: snaps_utils_1.HandlerType.OnKeyringRequest,
            request,
        })),
    });
}, _MultichainAssetsController_assertControllerMutexIsLocked = function _MultichainAssetsController_assertControllerMutexIsLocked() {
    if (!__classPrivateFieldGet(this, _MultichainAssetsController_controllerOperationMutex, "f").isLocked()) {
        throw new Error('MultichainAssetsControllerError - Attempt to update state');
    }
}, _MultichainAssetsController_withControllerLock = 
/**
 * Lock the controller mutex before executing the given function,
 * and release it after the function is resolved or after an
 * error is thrown.
 *
 * This wrapper ensures that each mutable operation that interacts with the
 * controller and that changes its state is executed in a mutually exclusive way,
 * preventing unsafe concurrent access that could lead to unpredictable behavior.
 *
 * @param callback - The function to execute while the controller mutex is locked.
 * @returns The result of the function.
 */
async function _MultichainAssetsController_withControllerLock(callback) {
    return withLock(__classPrivateFieldGet(this, _MultichainAssetsController_controllerOperationMutex, "f"), callback);
};
/**
 * Lock the given mutex before executing the given function,
 * and release it after the function is resolved or after an
 * error is thrown.
 *
 * @param mutex - The mutex to lock.
 * @param callback - The function to execute while the mutex is locked.
 * @returns The result of the function.
 */
async function withLock(mutex, callback) {
    const releaseLock = await mutex.acquire();
    try {
        return await callback({ releaseLock });
    }
    finally {
        releaseLock();
    }
}

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\MultichainAssetsController\\MultichainAssetsController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\MultichainAssetsController\\index.cjs", {"./MultichainAssetsController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\MultichainAssetsController\\MultichainAssetsController.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CMultichainAssetsController%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDefaultMultichainAssetsControllerState = exports.MultichainAssetsController = void 0;
var MultichainAssetsController_1 = require("./MultichainAssetsController.cjs");
Object.defineProperty(exports, "MultichainAssetsController", { enumerable: true, get: function () { return MultichainAssetsController_1.MultichainAssetsController; } });
Object.defineProperty(exports, "getDefaultMultichainAssetsControllerState", { enumerable: true, get: function () { return MultichainAssetsController_1.getDefaultMultichainAssetsControllerState; } });

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\MultichainAssetsController\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\MultichainAssetsController\\utils.cjs", {"@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CMultichainAssetsController%5Cutils.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getChainIdsCaveat = void 0;
const snaps_utils_1 = require("@metamask/snaps-utils");
// TODO: this is a duplicate of https://github.com/MetaMask/snaps/blob/362208e725db18baed550ade99087d44e7b537ed/packages/snaps-rpc-methods/src/endowments/name-lookup.ts#L151
// To be removed once core has snaps-rpc-methods dependency
/**
 * Getter function to get the chainIds caveat from a permission.
 *
 * This does basic validation of the caveat, but does not validate the type or
 * value of the namespaces object itself, as this is handled by the
 * `PermissionsController` when the permission is requested.
 *
 * @param permission - The permission to get the `chainIds` caveat from.
 * @returns An array of `chainIds` that the snap supports.
 */
// istanbul ignore next
function getChainIdsCaveat(permission) {
    if (!permission?.caveats) {
        return null;
    }
    const caveat = permission.caveats.find((permCaveat) => permCaveat.type === snaps_utils_1.SnapCaveatType.ChainIds);
    return caveat ? caveat.value : null;
}
exports.getChainIdsCaveat = getChainIdsCaveat;

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\MultichainAssetsController\\utils.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\MultichainAssetsRatesController\\MultichainAssetsRatesController.cjs", {"./constant.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\MultichainAssetsRatesController\\constant.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/polling-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\polling-controller\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","async-mutex":"D:\\code\\v\\metamask-extension\\node_modules\\async-mutex\\lib\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CMultichainAssetsRatesController%5CMultichainAssetsRatesController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _MultichainAssetsRatesController_instances, _MultichainAssetsRatesController_mutex, _MultichainAssetsRatesController_currentCurrency, _MultichainAssetsRatesController_accountsAssets, _MultichainAssetsRatesController_isUnlocked, _MultichainAssetsRatesController_isNonEvmAccount, _MultichainAssetsRatesController_listMultichainAccounts, _MultichainAssetsRatesController_listAccounts, _MultichainAssetsRatesController_getUpdatedRatesFor, _MultichainAssetsRatesController_updateAssetsRatesForNewAssets, _MultichainAssetsRatesController_getAccount, _MultichainAssetsRatesController_getAssetsForAccount, _MultichainAssetsRatesController_buildConversions, _MultichainAssetsRatesController_flattenRates, _MultichainAssetsRatesController_buildUpdatedRates, _MultichainAssetsRatesController_applyUpdatedRates, _MultichainAssetsRatesController_handleSnapRequest, _MultichainAssetsRatesController_mergeMarketDataIntoConversionRates;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultichainAssetsRatesController = exports.getDefaultMultichainAssetsRatesControllerState = void 0;
const keyring_api_1 = require("@metamask/keyring-api");
const polling_controller_1 = require("@metamask/polling-controller");
const snaps_utils_1 = require("@metamask/snaps-utils");
const async_mutex_1 = require("async-mutex");
const lodash_1 = require("lodash");
const constant_1 = require("./constant.cjs");
/**
 * The name of the MultichainAssetsRatesController.
 */
const controllerName = 'MultichainAssetsRatesController';
/**
 * Constructs the default {@link MultichainAssetsRatesController} state. This allows
 * consumers to provide a partial state object when initializing the controller
 * and also helps in constructing complete state objects for this controller in
 * tests.
 *
 * @returns The default {@link MultichainAssetsRatesController} state.
 */
function getDefaultMultichainAssetsRatesControllerState() {
    return { conversionRates: {}, historicalPrices: {} };
}
exports.getDefaultMultichainAssetsRatesControllerState = getDefaultMultichainAssetsRatesControllerState;
const metadata = {
    conversionRates: {
        includeInStateLogs: false,
        persist: true,
        anonymous: true,
        usedInUi: true,
    },
    historicalPrices: {
        includeInStateLogs: false,
        persist: false,
        anonymous: true,
        usedInUi: true,
    },
};
/**
 * Controller that manages multichain token conversion rates.
 *
 * This controller polls for token conversion rates and updates its state.
 */
class MultichainAssetsRatesController extends (0, polling_controller_1.StaticIntervalPollingController)() {
    /**
     * Creates an instance of MultichainAssetsRatesController.
     *
     * @param options - Constructor options.
     * @param options.interval - The polling interval in milliseconds.
     * @param options.state - The initial state.
     * @param options.messenger - A reference to the messaging system.
     */
    constructor({ interval = 18000, state = {}, messenger, }) {
        var _a, _b;
        super({
            name: controllerName,
            messenger,
            state: {
                ...getDefaultMultichainAssetsRatesControllerState(),
                ...state,
            },
            metadata,
        });
        _MultichainAssetsRatesController_instances.add(this);
        _MultichainAssetsRatesController_mutex.set(this, new async_mutex_1.Mutex());
        _MultichainAssetsRatesController_currentCurrency.set(this, void 0);
        _MultichainAssetsRatesController_accountsAssets.set(this, void 0);
        _MultichainAssetsRatesController_isUnlocked.set(this, true);
        this.setIntervalLength(interval);
        // Subscribe to keyring lock/unlock events.
        this.messagingSystem.subscribe('KeyringController:lock', () => {
            __classPrivateFieldSet(this, _MultichainAssetsRatesController_isUnlocked, false, "f");
        });
        this.messagingSystem.subscribe('KeyringController:unlock', () => {
            __classPrivateFieldSet(this, _MultichainAssetsRatesController_isUnlocked, true, "f");
        });
        (_a = this, { accountsAssets: ({ set value(_c) { __classPrivateFieldSet(_a, _MultichainAssetsRatesController_accountsAssets, _c, "f"); } }).value } = this.messagingSystem.call('MultichainAssetsController:getState'));
        (_b = this, { currentCurrency: ({ set value(_c) { __classPrivateFieldSet(_b, _MultichainAssetsRatesController_currentCurrency, _c, "f"); } }).value } = this.messagingSystem.call('CurrencyRateController:getState'));
        this.messagingSystem.subscribe('CurrencyRateController:stateChange', async (currentCurrency) => {
            __classPrivateFieldSet(this, _MultichainAssetsRatesController_currentCurrency, currentCurrency, "f");
            await this.updateAssetsRates();
        }, (currencyRateControllerState) => currencyRateControllerState.currentCurrency);
        this.messagingSystem.subscribe('MultichainAssetsController:accountAssetListUpdated', async ({ assets }) => {
            const newAccountAssets = Object.entries(assets).map(([accountId, { added }]) => ({
                accountId,
                assets: [...added],
            }));
            // TODO; removed can be used in future for further cleanup
            await __classPrivateFieldGet(this, _MultichainAssetsRatesController_instances, "m", _MultichainAssetsRatesController_updateAssetsRatesForNewAssets).call(this, newAccountAssets);
        });
    }
    /**
     * Executes a poll by updating token conversion rates for the current account.
     *
     * @returns A promise that resolves when the polling completes.
     */
    async _executePoll() {
        await this.updateAssetsRates();
    }
    /**
     * Determines whether the controller is active.
     *
     * @returns True if the keyring is unlocked; otherwise, false.
     */
    get isActive() {
        return __classPrivateFieldGet(this, _MultichainAssetsRatesController_isUnlocked, "f");
    }
    /**
     * Updates token conversion rates for each non-EVM account.
     *
     * @returns A promise that resolves when the rates are updated.
     */
    async updateAssetsRates() {
        const releaseLock = await __classPrivateFieldGet(this, _MultichainAssetsRatesController_mutex, "f").acquire();
        return (async () => {
            if (!this.isActive) {
                return;
            }
            const accounts = __classPrivateFieldGet(this, _MultichainAssetsRatesController_instances, "m", _MultichainAssetsRatesController_listAccounts).call(this);
            for (const account of accounts) {
                const assets = __classPrivateFieldGet(this, _MultichainAssetsRatesController_instances, "m", _MultichainAssetsRatesController_getAssetsForAccount).call(this, account.id);
                if (assets?.length === 0) {
                    continue;
                }
                const rates = await __classPrivateFieldGet(this, _MultichainAssetsRatesController_instances, "m", _MultichainAssetsRatesController_getUpdatedRatesFor).call(this, account, assets);
                // Apply these updated rates to controller state
                __classPrivateFieldGet(this, _MultichainAssetsRatesController_instances, "m", _MultichainAssetsRatesController_applyUpdatedRates).call(this, rates);
            }
        })().finally(() => {
            releaseLock();
        });
    }
    /**
     * Fetches historical prices for the current account
     *
     * @param asset - The asset to fetch historical prices for.
     * @param account - optional account to fetch historical prices for
     * @returns The historical prices.
     */
    async fetchHistoricalPricesForAsset(asset, account) {
        const releaseLock = await __classPrivateFieldGet(this, _MultichainAssetsRatesController_mutex, "f").acquire();
        return (async () => {
            const currentCaipCurrency = constant_1.MAP_CAIP_CURRENCIES[__classPrivateFieldGet(this, _MultichainAssetsRatesController_currentCurrency, "f")] ?? constant_1.MAP_CAIP_CURRENCIES.usd;
            // Check if we already have historical prices for this asset and currency
            const historicalPriceExpirationTime = this.state.historicalPrices[asset]?.[__classPrivateFieldGet(this, _MultichainAssetsRatesController_currentCurrency, "f")]
                ?.expirationTime;
            const historicalPriceHasExpired = historicalPriceExpirationTime &&
                historicalPriceExpirationTime < Date.now();
            if (historicalPriceHasExpired === false) {
                return;
            }
            const selectedAccount = account ??
                this.messagingSystem.call('AccountsController:getSelectedMultichainAccount');
            try {
                const historicalPricesResponse = await this.messagingSystem.call('SnapController:handleRequest', {
                    snapId: selectedAccount?.metadata.snap?.id,
                    origin: 'metamask',
                    handler: snaps_utils_1.HandlerType.OnAssetHistoricalPrice,
                    request: {
                        jsonrpc: '2.0',
                        method: snaps_utils_1.HandlerType.OnAssetHistoricalPrice,
                        params: {
                            from: asset,
                            to: currentCaipCurrency,
                        },
                    },
                });
                // skip state update if no historical prices are returned
                if (!historicalPricesResponse) {
                    return;
                }
                this.update((state) => {
                    state.historicalPrices = {
                        ...state.historicalPrices,
                        [asset]: {
                            ...state.historicalPrices[asset],
                            [__classPrivateFieldGet(this, _MultichainAssetsRatesController_currentCurrency, "f")]: historicalPricesResponse?.historicalPrice,
                        },
                    };
                });
            }
            catch {
                throw new Error(`Failed to fetch historical prices for asset: ${asset}`);
            }
        })().finally(() => {
            releaseLock();
        });
    }
}
exports.MultichainAssetsRatesController = MultichainAssetsRatesController;
_MultichainAssetsRatesController_mutex = new WeakMap(), _MultichainAssetsRatesController_currentCurrency = new WeakMap(), _MultichainAssetsRatesController_accountsAssets = new WeakMap(), _MultichainAssetsRatesController_isUnlocked = new WeakMap(), _MultichainAssetsRatesController_instances = new WeakSet(), _MultichainAssetsRatesController_isNonEvmAccount = function _MultichainAssetsRatesController_isNonEvmAccount(account) {
    return (!(0, keyring_api_1.isEvmAccountType)(account.type) && account.metadata.snap !== undefined);
}, _MultichainAssetsRatesController_listMultichainAccounts = function _MultichainAssetsRatesController_listMultichainAccounts() {
    return this.messagingSystem.call('AccountsController:listMultichainAccounts');
}, _MultichainAssetsRatesController_listAccounts = function _MultichainAssetsRatesController_listAccounts() {
    const accounts = __classPrivateFieldGet(this, _MultichainAssetsRatesController_instances, "m", _MultichainAssetsRatesController_listMultichainAccounts).call(this);
    return accounts.filter((account) => __classPrivateFieldGet(this, _MultichainAssetsRatesController_instances, "m", _MultichainAssetsRatesController_isNonEvmAccount).call(this, account));
}, _MultichainAssetsRatesController_getUpdatedRatesFor = async function _MultichainAssetsRatesController_getUpdatedRatesFor(account, assets) {
    // Do not attempt to retrieve rates from Snap if there are no assets
    if (!assets.length) {
        return {};
    }
    // Build the conversions array
    const conversions = __classPrivateFieldGet(this, _MultichainAssetsRatesController_instances, "m", _MultichainAssetsRatesController_buildConversions).call(this, assets);
    // Retrieve rates from Snap
    const accountRatesResponse = (await __classPrivateFieldGet(this, _MultichainAssetsRatesController_instances, "m", _MultichainAssetsRatesController_handleSnapRequest).call(this, {
        snapId: account?.metadata.snap?.id,
        handler: snaps_utils_1.HandlerType.OnAssetsConversion,
        params: conversions,
    }));
    // If the snap request failed, return empty rates
    if (!accountRatesResponse) {
        return {};
    }
    // Prepare assets param for onAssetsMarketData
    const currentCurrencyCaip = constant_1.MAP_CAIP_CURRENCIES[__classPrivateFieldGet(this, _MultichainAssetsRatesController_currentCurrency, "f")] ?? constant_1.MAP_CAIP_CURRENCIES.usd;
    const assetsParam = {
        assets: assets.map((asset) => ({ asset, unit: currentCurrencyCaip })),
    };
    // Retrieve Market Data from Snap
    const marketDataResponse = (await __classPrivateFieldGet(this, _MultichainAssetsRatesController_instances, "m", _MultichainAssetsRatesController_handleSnapRequest).call(this, {
        snapId: account?.metadata.snap?.id,
        handler: snaps_utils_1.HandlerType.OnAssetsMarketData,
        params: assetsParam,
    }));
    // Merge market data into conversion rates if available
    const mergedRates = __classPrivateFieldGet(this, _MultichainAssetsRatesController_instances, "m", _MultichainAssetsRatesController_mergeMarketDataIntoConversionRates).call(this, accountRatesResponse, marketDataResponse);
    // Flatten nested rates if needed
    const flattenedRates = __classPrivateFieldGet(this, _MultichainAssetsRatesController_instances, "m", _MultichainAssetsRatesController_flattenRates).call(this, mergedRates);
    // Build the updatedRates object for these assets
    const updatedRates = __classPrivateFieldGet(this, _MultichainAssetsRatesController_instances, "m", _MultichainAssetsRatesController_buildUpdatedRates).call(this, assets, flattenedRates);
    return updatedRates;
}, _MultichainAssetsRatesController_updateAssetsRatesForNewAssets = 
/**
 * Updates the conversion rates for new assets.
 *
 * @param accounts - The accounts to update the conversion rates for.
 * @returns A promise that resolves when the rates are updated.
 */
async function _MultichainAssetsRatesController_updateAssetsRatesForNewAssets(accounts) {
    const releaseLock = await __classPrivateFieldGet(this, _MultichainAssetsRatesController_mutex, "f").acquire();
    return (async () => {
        if (!this.isActive) {
            return;
        }
        const allNewRates = {};
        for (const { accountId, assets } of accounts) {
            const account = __classPrivateFieldGet(this, _MultichainAssetsRatesController_instances, "m", _MultichainAssetsRatesController_getAccount).call(this, accountId);
            const rates = await __classPrivateFieldGet(this, _MultichainAssetsRatesController_instances, "m", _MultichainAssetsRatesController_getUpdatedRatesFor).call(this, account, assets);
            // Track new rates
            for (const [asset, rate] of Object.entries(rates)) {
                allNewRates[asset] = rate;
            }
        }
        __classPrivateFieldGet(this, _MultichainAssetsRatesController_instances, "m", _MultichainAssetsRatesController_applyUpdatedRates).call(this, allNewRates);
    })().finally(() => {
        releaseLock();
    });
}, _MultichainAssetsRatesController_getAccount = function _MultichainAssetsRatesController_getAccount(accountId) {
    const account = __classPrivateFieldGet(this, _MultichainAssetsRatesController_instances, "m", _MultichainAssetsRatesController_listAccounts).call(this).find((multichainAccount) => multichainAccount.id === accountId);
    if (!account) {
        throw new Error(`Unknown account: ${accountId}`);
    }
    return account;
}, _MultichainAssetsRatesController_getAssetsForAccount = function _MultichainAssetsRatesController_getAssetsForAccount(accountId) {
    return __classPrivateFieldGet(this, _MultichainAssetsRatesController_accountsAssets, "f")?.[accountId] ?? [];
}, _MultichainAssetsRatesController_buildConversions = function _MultichainAssetsRatesController_buildConversions(assets) {
    const currency = constant_1.MAP_CAIP_CURRENCIES[__classPrivateFieldGet(this, _MultichainAssetsRatesController_currentCurrency, "f")] ?? constant_1.MAP_CAIP_CURRENCIES.usd;
    return {
        conversions: assets.map((asset) => ({
            from: asset,
            to: currency,
        })),
    };
}, _MultichainAssetsRatesController_flattenRates = function _MultichainAssetsRatesController_flattenRates(assetsConversionResponse) {
    if (!assetsConversionResponse?.conversionRates) {
        return {};
    }
    const { conversionRates } = assetsConversionResponse;
    return Object.fromEntries(Object.entries(conversionRates).map(([asset, nestedObj]) => {
        // e.g., nestedObj might look like: { "swift:0/iso4217:EUR": { rate, conversionTime } }
        const singleValue = Object.values(nestedObj)[0];
        return [asset, singleValue];
    }));
}, _MultichainAssetsRatesController_buildUpdatedRates = function _MultichainAssetsRatesController_buildUpdatedRates(assets, flattenedRates) {
    const updatedRates = {};
    for (const asset of assets) {
        if (flattenedRates[asset]) {
            updatedRates[asset] = {
                ...flattenedRates[asset],
                currency: constant_1.MAP_CAIP_CURRENCIES[__classPrivateFieldGet(this, _MultichainAssetsRatesController_currentCurrency, "f")] ??
                    constant_1.MAP_CAIP_CURRENCIES.usd,
            };
        }
    }
    return updatedRates;
}, _MultichainAssetsRatesController_applyUpdatedRates = function _MultichainAssetsRatesController_applyUpdatedRates(updatedRates) {
    if (Object.keys(updatedRates).length === 0) {
        return;
    }
    this.update((state) => {
        state.conversionRates = {
            ...state.conversionRates,
            ...updatedRates,
        };
    });
}, _MultichainAssetsRatesController_handleSnapRequest = 
/**
 * Forwards a Snap request to the SnapController.
 *
 * @param args - The request parameters.
 * @param args.snapId - The ID of the Snap.
 * @param args.handler - The handler type.
 * @param args.params - The asset conversions.
 * @returns A promise that resolves with the account rates.
 */
async function _MultichainAssetsRatesController_handleSnapRequest({ snapId, handler, params, }) {
    try {
        return (await this.messagingSystem.call('SnapController:handleRequest', {
            snapId,
            origin: 'metamask',
            handler,
            request: {
                jsonrpc: '2.0',
                method: handler,
                params,
            },
        }));
    }
    catch (error) {
        console.error(`Snap request failed for ${handler}:`, {
            snapId,
            handler,
            message: error.message,
            params,
        });
        // Ignore
        return undefined;
    }
}, _MultichainAssetsRatesController_mergeMarketDataIntoConversionRates = function _MultichainAssetsRatesController_mergeMarketDataIntoConversionRates(accountRatesResponse, marketDataResponse) {
    // Early return if no market data to merge
    if (!marketDataResponse?.marketData) {
        return accountRatesResponse;
    }
    const result = (0, lodash_1.cloneDeep)(accountRatesResponse);
    const { conversionRates } = result;
    const { marketData } = marketDataResponse;
    // Iterate through each asset in market data
    for (const [assetId, currencyData] of Object.entries(marketData)) {
        const typedAssetId = assetId;
        // Iterate through each currency for this asset
        for (const [currency, marketDataForCurrency] of Object.entries(currencyData)) {
            const typedCurrency = currency;
            // Check if this currency exists in conversion rates for this asset
            const existingRate = conversionRates[typedAssetId][typedCurrency];
            if (!existingRate) {
                continue;
            }
            // Merge market data into the existing conversion rate
            conversionRates[typedAssetId][typedCurrency] = {
                ...existingRate,
                marketData: marketDataForCurrency ?? undefined,
            };
        }
    }
    return result;
};

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\MultichainAssetsRatesController\\MultichainAssetsRatesController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\MultichainAssetsRatesController\\constant.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CMultichainAssetsRatesController%5Cconstant.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MAP_CAIP_CURRENCIES = void 0;
/**
 * Maps each SUPPORTED_CURRENCIES entry to its CAIP-19 (or CAIP-like) identifier.
 * For fiat, we mimic the old “swift:0/iso4217:XYZ” style.
 */
exports.MAP_CAIP_CURRENCIES = {
    // ========================
    // Native crypto assets
    // ========================
    btc: 'bip122:000000000019d6689c085ae165831e93/slip44:0',
    eth: 'eip155:1/slip44:60',
    ltc: 'bip122:12a765e31ffd4059bada1e25190f6e98/slip44:2',
    // Bitcoin Cash
    bch: 'bip122:000000000000000000651ef99cb9fcbe/slip44:145',
    // Binance Coin
    bnb: 'cosmos:Binance-Chain-Tigris/slip44:714',
    // EOS mainnet (chainId = aca376f2...)
    eos: 'eos:aca376f2/slip44:194',
    // XRP mainnet
    xrp: 'xrpl:mainnet/slip44:144',
    // Stellar Lumens mainnet
    xlm: 'stellar:pubnet/slip44:148',
    // Chainlink (ERC20 on Ethereum mainnet)
    link: 'eip155:1/erc20:0x514910771af9Ca656af840dff83E8264EcF986CA',
    // Polkadot (chainId = 91b171bb158e2d3848fa23a9f1c25182)
    dot: 'polkadot:91b171bb158e2d3848fa23a9f1c25182/slip44:354',
    // Yearn.finance (ERC20 on Ethereum mainnet)
    yfi: 'eip155:1/erc20:0x0bc529c00C6401aEF6D220BE8C6Ea1667F6Ad93e',
    // ========================
    // Fiat currencies
    // ========================
    usd: 'swift:0/iso4217:USD',
    aed: 'swift:0/iso4217:AED',
    ars: 'swift:0/iso4217:ARS',
    aud: 'swift:0/iso4217:AUD',
    bdt: 'swift:0/iso4217:BDT',
    bhd: 'swift:0/iso4217:BHD',
    bmd: 'swift:0/iso4217:BMD',
    brl: 'swift:0/iso4217:BRL',
    cad: 'swift:0/iso4217:CAD',
    chf: 'swift:0/iso4217:CHF',
    clp: 'swift:0/iso4217:CLP',
    cny: 'swift:0/iso4217:CNY',
    czk: 'swift:0/iso4217:CZK',
    dkk: 'swift:0/iso4217:DKK',
    eur: 'swift:0/iso4217:EUR',
    gbp: 'swift:0/iso4217:GBP',
    hkd: 'swift:0/iso4217:HKD',
    huf: 'swift:0/iso4217:HUF',
    idr: 'swift:0/iso4217:IDR',
    ils: 'swift:0/iso4217:ILS',
    inr: 'swift:0/iso4217:INR',
    jpy: 'swift:0/iso4217:JPY',
    krw: 'swift:0/iso4217:KRW',
    kwd: 'swift:0/iso4217:KWD',
    lkr: 'swift:0/iso4217:LKR',
    mmk: 'swift:0/iso4217:MMK',
    mxn: 'swift:0/iso4217:MXN',
    myr: 'swift:0/iso4217:MYR',
    ngn: 'swift:0/iso4217:NGN',
    nok: 'swift:0/iso4217:NOK',
    nzd: 'swift:0/iso4217:NZD',
    php: 'swift:0/iso4217:PHP',
    pkr: 'swift:0/iso4217:PKR',
    pln: 'swift:0/iso4217:PLN',
    rub: 'swift:0/iso4217:RUB',
    sar: 'swift:0/iso4217:SAR',
    sek: 'swift:0/iso4217:SEK',
    sgd: 'swift:0/iso4217:SGD',
    thb: 'swift:0/iso4217:THB',
    try: 'swift:0/iso4217:TRY',
    twd: 'swift:0/iso4217:TWD',
    uah: 'swift:0/iso4217:UAH',
    vef: 'swift:0/iso4217:VEF',
    vnd: 'swift:0/iso4217:VND',
    zar: 'swift:0/iso4217:ZAR',
    xdr: 'swift:0/iso4217:XDR',
    xag: 'swift:0/iso4217:XAG',
    xau: 'swift:0/iso4217:XAU',
};

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\MultichainAssetsRatesController\\constant.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\MultichainAssetsRatesController\\index.cjs", {"./MultichainAssetsRatesController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\MultichainAssetsRatesController\\MultichainAssetsRatesController.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CMultichainAssetsRatesController%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDefaultMultichainAssetsRatesControllerState = exports.MultichainAssetsRatesController = void 0;
var MultichainAssetsRatesController_1 = require("./MultichainAssetsRatesController.cjs");
Object.defineProperty(exports, "MultichainAssetsRatesController", { enumerable: true, get: function () { return MultichainAssetsRatesController_1.MultichainAssetsRatesController; } });
Object.defineProperty(exports, "getDefaultMultichainAssetsRatesControllerState", { enumerable: true, get: function () { return MultichainAssetsRatesController_1.getDefaultMultichainAssetsRatesControllerState; } });

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\MultichainAssetsRatesController\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\MultichainBalancesController\\MultichainBalancesController.cjs", {"@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/keyring-snap-client":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CMultichainBalancesController%5CMultichainBalancesController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _MultichainBalancesController_instances, _MultichainBalancesController_handleOnAccountAssetListUpdated, _MultichainBalancesController_updateBalance, _MultichainBalancesController_listMultichainAccounts, _MultichainBalancesController_listAccounts, _MultichainBalancesController_listAccountAssets, _MultichainBalancesController_getAccount, _MultichainBalancesController_isNonEvmAccount, _MultichainBalancesController_handleOnAccountBalancesUpdated, _MultichainBalancesController_handleOnAccountRemoved, _MultichainBalancesController_getBalances, _MultichainBalancesController_getClient;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultichainBalancesController = exports.getDefaultMultichainBalancesControllerState = void 0;
const base_controller_1 = require("@metamask/base-controller");
const keyring_api_1 = require("@metamask/keyring-api");
const keyring_snap_client_1 = require("@metamask/keyring-snap-client");
const snaps_utils_1 = require("@metamask/snaps-utils");
const controllerName = 'MultichainBalancesController';
/**
 * Constructs the default {@link MultichainBalancesController} state. This allows
 * consumers to provide a partial state object when initializing the controller
 * and also helps in constructing complete state objects for this controller in
 * tests.
 *
 * @returns The default {@link MultichainBalancesController} state.
 */
function getDefaultMultichainBalancesControllerState() {
    return { balances: {} };
}
exports.getDefaultMultichainBalancesControllerState = getDefaultMultichainBalancesControllerState;
/**
 * {@link MultichainBalancesController}'s metadata.
 *
 * This allows us to choose if fields of the state should be persisted or not
 * using the `persist` flag; and if they can be sent to Sentry or not, using
 * the `anonymous` flag.
 */
const balancesControllerMetadata = {
    balances: {
        includeInStateLogs: false,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
};
/**
 * The MultichainBalancesController is responsible for fetching and caching account
 * balances.
 */
class MultichainBalancesController extends base_controller_1.BaseController {
    constructor({ messenger, state = {}, }) {
        super({
            messenger,
            name: controllerName,
            metadata: balancesControllerMetadata,
            state: {
                ...getDefaultMultichainBalancesControllerState(),
                ...state,
            },
        });
        _MultichainBalancesController_instances.add(this);
        // Fetch initial balances for all non-EVM accounts
        for (const account of __classPrivateFieldGet(this, _MultichainBalancesController_instances, "m", _MultichainBalancesController_listAccounts).call(this)) {
            // Fetching the balance is asynchronous and we cannot use `await` here.
            // eslint-disable-next-line no-void
            void this.updateBalance(account.id);
        }
        this.messagingSystem.subscribe('AccountsController:accountRemoved', (account) => __classPrivateFieldGet(this, _MultichainBalancesController_instances, "m", _MultichainBalancesController_handleOnAccountRemoved).call(this, account));
        this.messagingSystem.subscribe('AccountsController:accountBalancesUpdated', (balanceUpdate) => __classPrivateFieldGet(this, _MultichainBalancesController_instances, "m", _MultichainBalancesController_handleOnAccountBalancesUpdated).call(this, balanceUpdate));
        this.messagingSystem.subscribe('MultichainAssetsController:accountAssetListUpdated', async ({ assets }) => {
            const newAccountAssets = Object.entries(assets).map(([accountId, { added }]) => ({
                accountId,
                assets: [...added],
            }));
            await __classPrivateFieldGet(this, _MultichainBalancesController_instances, "m", _MultichainBalancesController_handleOnAccountAssetListUpdated).call(this, newAccountAssets);
        });
    }
    /**
     * Updates the balances of one account. This method doesn't return
     * anything, but it updates the state of the controller.
     *
     * @param accountId - The account ID.
     */
    async updateBalance(accountId) {
        await __classPrivateFieldGet(this, _MultichainBalancesController_instances, "m", _MultichainBalancesController_updateBalance).call(this, accountId, __classPrivateFieldGet(this, _MultichainBalancesController_instances, "m", _MultichainBalancesController_listAccountAssets).call(this, accountId));
    }
}
exports.MultichainBalancesController = MultichainBalancesController;
_MultichainBalancesController_instances = new WeakSet(), _MultichainBalancesController_handleOnAccountAssetListUpdated = 
/**
 * Updates the balances for the given accounts.
 *
 * @param accounts - The accounts to update the balances for.
 */
async function _MultichainBalancesController_handleOnAccountAssetListUpdated(accounts) {
    const { isUnlocked } = this.messagingSystem.call('KeyringController:getState');
    if (!isUnlocked) {
        return;
    }
    const balancesToUpdate = {};
    for (const { accountId, assets } of accounts) {
        const account = __classPrivateFieldGet(this, _MultichainBalancesController_instances, "m", _MultichainBalancesController_getAccount).call(this, accountId);
        if (account.metadata.snap) {
            const accountBalance = await __classPrivateFieldGet(this, _MultichainBalancesController_instances, "m", _MultichainBalancesController_getBalances).call(this, account.id, account.metadata.snap.id, assets);
            balancesToUpdate[accountId] = accountBalance;
        }
    }
    if (Object.keys(balancesToUpdate).length === 0) {
        return;
    }
    this.update((state) => {
        for (const [accountId, accountBalances] of Object.entries(balancesToUpdate)) {
            if (!state.balances[accountId] ||
                Object.keys(state.balances[accountId]).length === 0) {
                state.balances[accountId] = accountBalances;
            }
            else {
                for (const assetId in accountBalances) {
                    if (!state.balances[accountId][assetId]) {
                        state.balances[accountId][assetId] = accountBalances[assetId];
                    }
                }
            }
        }
    });
}, _MultichainBalancesController_updateBalance = 
/**
 * Updates the balances of one account. This method doesn't return
 * anything, but it updates the state of the controller.
 *
 * @param accountId - The account ID.
 * @param assets - The list of asset types for this account to upadte.
 */
async function _MultichainBalancesController_updateBalance(accountId, assets) {
    const { isUnlocked } = this.messagingSystem.call('KeyringController:getState');
    if (!isUnlocked) {
        return;
    }
    try {
        const account = __classPrivateFieldGet(this, _MultichainBalancesController_instances, "m", _MultichainBalancesController_getAccount).call(this, accountId);
        if (account.metadata.snap) {
            const accountBalance = await __classPrivateFieldGet(this, _MultichainBalancesController_instances, "m", _MultichainBalancesController_getBalances).call(this, account.id, account.metadata.snap.id, assets);
            this.update((state) => {
                state.balances[accountId] = accountBalance;
            });
        }
    }
    catch (error) {
        // FIXME: Maybe we shouldn't catch all errors here since this method is also being
        // used in the public methods. This means if something else uses `updateBalance` it
        // won't be able to catch and gets the error itself...
        console.error(`Failed to fetch balances for account ${accountId}:`, error);
    }
}, _MultichainBalancesController_listMultichainAccounts = function _MultichainBalancesController_listMultichainAccounts() {
    return this.messagingSystem.call('AccountsController:listMultichainAccounts');
}, _MultichainBalancesController_listAccounts = function _MultichainBalancesController_listAccounts() {
    const accounts = __classPrivateFieldGet(this, _MultichainBalancesController_instances, "m", _MultichainBalancesController_listMultichainAccounts).call(this);
    return accounts.filter((account) => __classPrivateFieldGet(this, _MultichainBalancesController_instances, "m", _MultichainBalancesController_isNonEvmAccount).call(this, account));
}, _MultichainBalancesController_listAccountAssets = function _MultichainBalancesController_listAccountAssets(accountId) {
    // TODO: Add an action `MultichainAssetsController:getAccountAssets` maybe?
    const assetsState = this.messagingSystem.call('MultichainAssetsController:getState');
    return assetsState.accountsAssets[accountId] ?? [];
}, _MultichainBalancesController_getAccount = function _MultichainBalancesController_getAccount(accountId) {
    const account = __classPrivateFieldGet(this, _MultichainBalancesController_instances, "m", _MultichainBalancesController_listAccounts).call(this).find((multichainAccount) => multichainAccount.id === accountId);
    if (!account) {
        throw new Error(`Unknown account: ${accountId}`);
    }
    return account;
}, _MultichainBalancesController_isNonEvmAccount = function _MultichainBalancesController_isNonEvmAccount(account) {
    return (!(0, keyring_api_1.isEvmAccountType)(account.type) &&
        // Non-EVM accounts are backed by a Snap for now
        account.metadata.snap !== undefined);
}, _MultichainBalancesController_handleOnAccountBalancesUpdated = function _MultichainBalancesController_handleOnAccountBalancesUpdated(balanceUpdate) {
    this.update((state) => {
        Object.entries(balanceUpdate.balances).forEach(([accountId, assetBalances]) => {
            if (accountId in state.balances) {
                Object.assign(state.balances[accountId], assetBalances);
            }
        });
    });
}, _MultichainBalancesController_handleOnAccountRemoved = 
/**
 * Handles changes when a new account has been removed.
 *
 * @param accountId - The account ID being removed.
 */
async function _MultichainBalancesController_handleOnAccountRemoved(accountId) {
    if (accountId in this.state.balances) {
        this.update((state) => {
            delete state.balances[accountId];
        });
    }
}, _MultichainBalancesController_getBalances = 
/**
 * Get the balances for an account.
 *
 * @param accountId - ID of the account to get balances for.
 * @param snapId - ID of the Snap which manages the account.
 * @param assetTypes - Array of asset types to get balances for.
 * @returns A map of asset types to balances.
 */
async function _MultichainBalancesController_getBalances(accountId, snapId, assetTypes) {
    return await __classPrivateFieldGet(this, _MultichainBalancesController_instances, "m", _MultichainBalancesController_getClient).call(this, snapId).getAccountBalances(accountId, assetTypes);
}, _MultichainBalancesController_getClient = function _MultichainBalancesController_getClient(snapId) {
    return new keyring_snap_client_1.KeyringClient({
        send: async (request) => (await this.messagingSystem.call('SnapController:handleRequest', {
            snapId: snapId,
            origin: 'metamask',
            handler: snaps_utils_1.HandlerType.OnKeyringRequest,
            request,
        })),
    });
};

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\MultichainBalancesController\\MultichainBalancesController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\MultichainBalancesController\\index.cjs", {"./MultichainBalancesController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\MultichainBalancesController\\MultichainBalancesController.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CMultichainBalancesController%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultichainBalancesController = void 0;
var MultichainBalancesController_1 = require("./MultichainBalancesController.cjs");
Object.defineProperty(exports, "MultichainBalancesController", { enumerable: true, get: function () { return MultichainBalancesController_1.MultichainBalancesController; } });

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\MultichainBalancesController\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\NftController.cjs", {"./assetsUtil.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\assetsUtil.cjs","./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\constants.cjs","@ethersproject/address":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\address\\lib\\index.js","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/phishing-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\phishing-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","async-mutex":"D:\\code\\v\\metamask-extension\\node_modules\\async-mutex\\lib\\index.js","bn.js":"D:\\code\\v\\metamask-extension\\node_modules\\bn.js\\lib\\bn.js","uuid":"D:\\code\\v\\metamask-extension\\node_modules\\uuid\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CNftController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _NftController_instances, _NftController_mutex, _NftController_selectedAccountId, _NftController_ipfsGateway, _NftController_displayNftMedia, _NftController_useIpfsSubdomains, _NftController_isIpfsGatewayEnabled, _NftController_onNftAdded, _NftController_onPreferencesControllerStateChange, _NftController_onSelectedAccountChange, _NftController_updateNestedNftState, _NftController_getNftCollectionApi, _NftController_getNftInformationFromApi, _NftController_getNftInformationFromTokenURI, _NftController_getNftURIAndStandard, _NftController_getNftInformation, _NftController_getNftContractInformationFromContract, _NftController_getNftContractInformation, _NftController_addIndividualNft, _NftController_addNftContract, _NftController_removeAndIgnoreIndividualNft, _NftController_removeIndividualNft, _NftController_removeNftContract, _NftController_validateWatchNft, _NftController_getAddressOrSelectedAddress, _NftController_updateNftUpdateForAccount, _NftController_bulkSanitizeNftMetadata, _NftController_sanitizeNftMetadata;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NftController = exports.getDefaultNftControllerState = void 0;
const address_1 = require("@ethersproject/address");
const base_controller_1 = require("@metamask/base-controller");
const controller_utils_1 = require("@metamask/controller-utils");
const phishing_controller_1 = require("@metamask/phishing-controller");
const rpc_errors_1 = require("@metamask/rpc-errors");
const utils_1 = require("@metamask/utils");
const async_mutex_1 = require("async-mutex");
const bn_js_1 = __importDefault(require("bn.js"));
const uuid_1 = require("uuid");
const assetsUtil_1 = require("./assetsUtil.cjs");
const constants_1 = require("./constants.cjs");
const nftControllerMetadata = {
    allNftContracts: {
        includeInStateLogs: false,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
    allNfts: {
        includeInStateLogs: false,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
    ignoredNfts: {
        includeInStateLogs: false,
        persist: true,
        anonymous: false,
        usedInUi: false,
    },
};
const ALL_NFTS_STATE_KEY = 'allNfts';
const ALL_NFTS_CONTRACTS_STATE_KEY = 'allNftContracts';
/**
 * The name of the {@link NftController}.
 */
const controllerName = 'NftController';
const getDefaultNftControllerState = () => ({
    allNftContracts: {},
    allNfts: {},
    ignoredNfts: [],
});
exports.getDefaultNftControllerState = getDefaultNftControllerState;
const NFT_UPDATE_THRESHOLD = 500;
/**
 * Controller that stores assets and exposes convenience methods
 */
class NftController extends base_controller_1.BaseController {
    /**
     * Creates an NftController instance.
     *
     * @param options - The controller options.
     * @param options.ipfsGateway - The configured IPFS gateway.
     * @param options.displayNftMedia - Controls whether the NFT API is used.
     * @param options.useIpfsSubdomains - Controls whether IPFS subdomains are used.
     * @param options.isIpfsGatewayEnabled - Controls whether IPFS is enabled or not.
     * @param options.onNftAdded - Callback that is called when an NFT is added. Currently used pass data
     * for tracking the NFT added event.
     * @param options.messenger - The messenger.
     * @param options.state - Initial state to set on this controller.
     */
    constructor({ ipfsGateway = controller_utils_1.IPFS_DEFAULT_GATEWAY_URL, displayNftMedia = false, useIpfsSubdomains = true, isIpfsGatewayEnabled = true, onNftAdded, messenger, state = {}, }) {
        super({
            name: controllerName,
            metadata: nftControllerMetadata,
            messenger,
            state: {
                ...(0, exports.getDefaultNftControllerState)(),
                ...state,
            },
        });
        _NftController_instances.add(this);
        _NftController_mutex.set(this, new async_mutex_1.Mutex());
        _NftController_selectedAccountId.set(this, void 0);
        _NftController_ipfsGateway.set(this, void 0);
        _NftController_displayNftMedia.set(this, void 0);
        _NftController_useIpfsSubdomains.set(this, void 0);
        _NftController_isIpfsGatewayEnabled.set(this, void 0);
        _NftController_onNftAdded.set(this, void 0);
        __classPrivateFieldSet(this, _NftController_selectedAccountId, this.messagingSystem.call('AccountsController:getSelectedAccount').id, "f");
        __classPrivateFieldSet(this, _NftController_ipfsGateway, ipfsGateway, "f");
        __classPrivateFieldSet(this, _NftController_displayNftMedia, displayNftMedia, "f");
        __classPrivateFieldSet(this, _NftController_useIpfsSubdomains, useIpfsSubdomains, "f");
        __classPrivateFieldSet(this, _NftController_isIpfsGatewayEnabled, isIpfsGatewayEnabled, "f");
        __classPrivateFieldSet(this, _NftController_onNftAdded, onNftAdded, "f");
        this.messagingSystem.subscribe('PreferencesController:stateChange', __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_onPreferencesControllerStateChange).bind(this));
        this.messagingSystem.subscribe('AccountsController:selectedEvmAccountChange', __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_onSelectedAccountChange).bind(this));
    }
    getNftApi() {
        return `${controller_utils_1.NFT_API_BASE_URL}/tokens`;
    }
    /**
     * Adds a new suggestedAsset to state. Parameters will be validated according to
     * asset type being watched. A `<suggestedNftMeta.id>:pending` hub event will be emitted once added.
     *
     * @param asset - The asset to be watched. For now ERC721 and ERC1155 tokens are accepted.
     * @param asset.address - The address of the asset contract.
     * @param asset.tokenId - The ID of the asset.
     * @param type - The asset type.
     * @param origin - Domain origin to register the asset from.
     * @param networkClientId - The networkClientId that can be used to identify the network client to use for this request.
     * @param options - Options bag.
     * @param options.userAddress - The address of the account where the NFT is being added.
     * @returns Object containing a Promise resolving to the suggestedAsset address if accepted.
     */
    async watchNft(asset, type, origin, networkClientId, { userAddress, } = {}) {
        const addressToSearch = __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_getAddressOrSelectedAddress).call(this, userAddress);
        if (!addressToSearch) {
            return;
        }
        if (!networkClientId) {
            throw rpc_errors_1.rpcErrors.invalidParams('Network client id is required');
        }
        await __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_validateWatchNft).call(this, asset, type, addressToSearch, networkClientId);
        const nftMetadata = await __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_getNftInformation).call(this, asset.address, asset.tokenId, networkClientId);
        // Sanitize metadata
        const sanitizedMetadata = await __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_sanitizeNftMetadata).call(this, nftMetadata);
        if (sanitizedMetadata.standard && sanitizedMetadata.standard !== type) {
            throw rpc_errors_1.rpcErrors.invalidInput(`Suggested NFT of type ${sanitizedMetadata.standard} does not match received type ${type}`);
        }
        const suggestedNftMeta = {
            asset: { ...asset, ...sanitizedMetadata },
            type,
            id: (0, uuid_1.v4)(),
            time: Date.now(),
            interactingAddress: addressToSearch,
            origin,
        };
        await this._requestApproval(suggestedNftMeta);
        const { address, tokenId } = asset;
        const { name, standard, description, image } = sanitizedMetadata;
        await this.addNft(address, tokenId, networkClientId, {
            nftMetadata: {
                name: name ?? null,
                description: description ?? null,
                image: image ?? null,
                standard: standard ?? null,
            },
            userAddress,
            source: constants_1.Source.Dapp,
        });
    }
    /**
     * Checks the ownership of a ERC-721 or ERC-1155 NFT for a given address.
     *
     * @param ownerAddress - User public address.
     * @param nftAddress - NFT contract address.
     * @param tokenId - NFT token ID.
     * @param networkClientId - The networkClientId that can be used to identify the network client to use for this request.
     * @returns Promise resolving the NFT ownership.
     */
    async isNftOwner(ownerAddress, nftAddress, tokenId, networkClientId) {
        // Checks the ownership for ERC-721.
        try {
            const owner = await this.messagingSystem.call('AssetsContractController:getERC721OwnerOf', nftAddress, tokenId, networkClientId);
            return ownerAddress.toLowerCase() === owner.toLowerCase();
        }
        catch {
            // Ignore ERC-721 contract error
        }
        // Checks the ownership for ERC-1155.
        try {
            const balance = await this.messagingSystem.call('AssetsContractController:getERC1155BalanceOf', ownerAddress, nftAddress, tokenId, networkClientId);
            return !balance.isZero();
        }
        catch {
            // Ignore ERC-1155 contract error
        }
        throw new Error(`Unable to verify ownership. Possibly because the standard is not supported or the user's currently selected network does not match the chain of the asset in question.`);
    }
    /**
     * Verifies currently selected address owns entered NFT address/tokenId combo and
     * adds the NFT and respective NFT contract to the stored NFT and NFT contracts lists.
     *
     * @param address - Hex address of the NFT contract.
     * @param tokenId - The NFT identifier.
     * @param networkClientId - The networkClientId that can be used to identify the network client to use for this request.
     * @param options - an object of arguments
     * @param options.userAddress - The address of the current user.
     * @param options.source - Whether the NFT was detected, added manually or suggested by a dapp.
     */
    async addNftVerifyOwnership(address, tokenId, networkClientId, { userAddress, source, } = {}) {
        const addressToSearch = __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_getAddressOrSelectedAddress).call(this, userAddress);
        if (!(await this.isNftOwner(addressToSearch, address, tokenId, networkClientId))) {
            throw new Error('This NFT is not owned by the user');
        }
        await this.addNft(address, tokenId, networkClientId, {
            userAddress: addressToSearch,
            source,
        });
    }
    /**
     * Adds an NFT and respective NFT contract to the stored NFT and NFT contracts lists.
     *
     * @param tokenAddress - Hex address of the NFT contract.
     * @param tokenId - The NFT identifier.
     * @param networkClientId - The networkClientId that can be used to identify the network client to use for this request.
     * @param options - an object of arguments
     * @param options.nftMetadata - NFT optional metadata.
     * @param options.userAddress - The address of the current user.
     * @param options.source - Whether the NFT was detected, added manually or suggested by a dapp.
     * @returns Promise resolving to the current NFT list.
     */
    async addNft(tokenAddress, tokenId, networkClientId, { nftMetadata, userAddress, source = constants_1.Source.Custom, } = {}) {
        const addressToSearch = __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_getAddressOrSelectedAddress).call(this, userAddress);
        if (!addressToSearch) {
            return;
        }
        const checksumHexAddress = (0, controller_utils_1.toChecksumHexAddress)(tokenAddress);
        if (!nftMetadata) {
            const fetchedMetadata = await __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_getNftInformation).call(this, checksumHexAddress, tokenId, networkClientId);
            // Sanitize metadata
            nftMetadata = await __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_sanitizeNftMetadata).call(this, fetchedMetadata);
        }
        else {
            // Sanitize provided metadata
            nftMetadata = await __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_sanitizeNftMetadata).call(this, nftMetadata);
        }
        const newNftContracts = await __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_addNftContract).call(this, networkClientId, {
            tokenAddress: checksumHexAddress,
            userAddress: addressToSearch,
            source,
            nftMetadata,
        });
        // If NFT contract was not added, do not add individual NFT
        const nftContract = newNftContracts.find((contract) => contract.address.toLowerCase() === checksumHexAddress.toLowerCase());
        const { configuration: { chainId }, } = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId);
        // This is the case when the NFT is added manually and not detected automatically
        // TODO: An improvement would be to make the chainId a required field and return it when getting the NFT information
        if (!nftMetadata.chainId) {
            nftMetadata.chainId = (0, controller_utils_1.convertHexToDecimal)(chainId);
        }
        // If NFT contract information, add individual NFT
        if (nftContract) {
            await __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_addIndividualNft).call(this, checksumHexAddress, tokenId, nftMetadata, nftContract, chainId, addressToSearch, source);
        }
    }
    /**
     * Refetches NFT metadata and updates the state
     *
     * @param options - Options for refetching NFT metadata
     * @param options.nfts - nfts to update metadata for.
     * @param options.userAddress - The current user address
     */
    async updateNftMetadata({ nfts, userAddress, }) {
        const addressToSearch = __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_getAddressOrSelectedAddress).call(this, userAddress);
        const releaseLock = await __classPrivateFieldGet(this, _NftController_mutex, "f").acquire();
        try {
            const nftsWithChecksumAdr = nfts.map((nft) => {
                return {
                    ...nft,
                    address: (0, controller_utils_1.toChecksumHexAddress)(nft.address),
                };
            });
            // Get all unsanitized nft metadata
            const unsanitizedResults = await Promise.all(nftsWithChecksumAdr.map(async (nft) => {
                // Each NFT should have a chainId; convert nft.chainId to networkClientId
                const networkClientId = this.messagingSystem.call('NetworkController:findNetworkClientIdByChainId', (0, controller_utils_1.toHex)(nft.chainId));
                const resMetadata = networkClientId
                    ? await __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_getNftInformation).call(this, nft.address, nft.tokenId, networkClientId)
                    : undefined;
                return {
                    nft,
                    newMetadata: resMetadata,
                };
            }));
            // Extract metadata
            const unsanitizedMetadata = unsanitizedResults.map((result) => result.newMetadata);
            // Sanitize all metadata
            const sanitizedMetadata = await __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_bulkSanitizeNftMetadata).call(this, unsanitizedMetadata);
            // Reassemble the results with sanitized metadata
            const nftMetadataResults = unsanitizedResults.map((result, index) => ({
                nft: result.nft,
                newMetadata: sanitizedMetadata[index],
            }));
            // We want to avoid updating the state if the state and fetched nft info are the same
            const nftsWithDifferentMetadata = [];
            const { allNfts } = this.state;
            // get from state allNfts that match nftsWithChecksumAdr
            const stateNfts = nftsWithChecksumAdr.map((nft) => {
                return allNfts[addressToSearch]?.[(0, controller_utils_1.toHex)(nft.chainId)]?.find((nftElement) => nftElement.address.toLowerCase() === nft.address.toLowerCase() &&
                    nftElement.tokenId === nft.tokenId);
            });
            nftMetadataResults.forEach((singleNft) => {
                const existingEntry = stateNfts.find((nft) => nft?.address.toLowerCase() ===
                    singleNft.nft.address.toLowerCase() &&
                    nft?.tokenId === singleNft.nft.tokenId);
                if (existingEntry && singleNft.newMetadata) {
                    const differentMetadata = (0, assetsUtil_1.compareNftMetadata)(singleNft.newMetadata, existingEntry);
                    if (differentMetadata) {
                        nftsWithDifferentMetadata.push({
                            nft: singleNft.nft,
                            newMetadata: singleNft.newMetadata,
                        });
                    }
                }
            });
            if (nftsWithDifferentMetadata.length !== 0) {
                nftsWithDifferentMetadata.forEach((elm) => this.updateNft(elm.nft, elm.newMetadata, addressToSearch, (0, controller_utils_1.toHex)(elm.nft.chainId)));
            }
        }
        finally {
            releaseLock();
        }
    }
    /**
     * Removes an NFT from the stored token list.
     *
     * @param address - Hex address of the NFT contract.
     * @param tokenId - Token identifier of the NFT.
     * @param networkClientId - The networkClientId that can be used to identify the network client to use for this request.
     * @param options - an object of arguments
     * @param options.userAddress - The address of the account where the NFT is being removed.
     */
    removeNft(address, tokenId, networkClientId, { userAddress } = {}) {
        const addressToSearch = __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_getAddressOrSelectedAddress).call(this, userAddress);
        const { configuration: { chainId }, } = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId);
        const checksumHexAddress = (0, controller_utils_1.toChecksumHexAddress)(address);
        __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_removeIndividualNft).call(this, checksumHexAddress, tokenId, {
            chainId,
            userAddress: addressToSearch,
        });
        const { allNfts } = this.state;
        const nfts = allNfts[addressToSearch]?.[chainId] || [];
        const remainingNft = nfts.find((nft) => nft.address.toLowerCase() === checksumHexAddress.toLowerCase());
        if (!remainingNft) {
            __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_removeNftContract).call(this, checksumHexAddress, {
                chainId,
                userAddress: addressToSearch,
            });
        }
    }
    /**
     * Removes an NFT from the stored token list and saves it in ignored NFTs list.
     *
     * @param address - Hex address of the NFT contract.
     * @param tokenId - Token identifier of the NFT.
     * @param networkClientId - The networkClientId that can be used to identify the network client to use for this request.
     * @param options - an object of arguments
     * @param options.userAddress - The address of the account where the NFT is being removed.
     */
    removeAndIgnoreNft(address, tokenId, networkClientId, { userAddress } = {}) {
        const addressToSearch = __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_getAddressOrSelectedAddress).call(this, userAddress);
        const { configuration: { chainId }, } = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId);
        const checksumHexAddress = (0, controller_utils_1.toChecksumHexAddress)(address);
        __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_removeAndIgnoreIndividualNft).call(this, checksumHexAddress, tokenId, {
            chainId,
            userAddress: addressToSearch,
        });
        const { allNfts } = this.state;
        const nfts = allNfts[addressToSearch]?.[chainId] || [];
        const remainingNft = nfts.find((nft) => nft.address.toLowerCase() === checksumHexAddress.toLowerCase());
        if (!remainingNft) {
            __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_removeNftContract).call(this, checksumHexAddress, {
                chainId,
                userAddress: addressToSearch,
            });
        }
    }
    /**
     * Removes all NFTs from the ignored list.
     */
    clearIgnoredNfts() {
        this.update((state) => {
            state.ignoredNfts = [];
        });
    }
    /**
     * Checks whether input NFT is still owned by the user
     * And updates the isCurrentlyOwned value on the NFT object accordingly.
     *
     * @param nft - The NFT object to check and update.
     * @param batch - A boolean indicating whether this method is being called as part of a batch or single update.
     * @param networkClientId - The networkClientId that can be used to identify the network client to use for this request.
     * @param accountParams - The userAddress and chainId to check ownership against
     * @param accountParams.userAddress - the address passed through the confirmed transaction flow to ensure assets are stored to the correct account
     * @returns the NFT with the updated isCurrentlyOwned value
     */
    async checkAndUpdateSingleNftOwnershipStatus(nft, batch, networkClientId, { userAddress } = {}) {
        const addressToSearch = __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_getAddressOrSelectedAddress).call(this, userAddress);
        const { configuration: { chainId }, } = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId);
        const { address, tokenId } = nft;
        let isOwned = nft.isCurrentlyOwned;
        try {
            isOwned = await this.isNftOwner(addressToSearch, address, tokenId, networkClientId);
        }
        catch {
            // ignore error
            // this will only throw an error 'Unable to verify ownership' in which case
            // we want to keep the current value of isCurrentlyOwned for this flow.
        }
        const updatedNft = {
            ...nft,
            isCurrentlyOwned: isOwned,
        };
        if (batch) {
            return updatedNft;
        }
        // if this is not part of a batched update we update this one NFT in state
        const { allNfts } = this.state;
        const nfts = [...(allNfts[addressToSearch]?.[chainId] || [])];
        const indexToUpdate = nfts.findIndex((item) => item.tokenId === tokenId &&
            item.address.toLowerCase() === address.toLowerCase());
        if (indexToUpdate !== -1) {
            nfts[indexToUpdate] = updatedNft;
            this.update((state) => {
                state.allNfts[addressToSearch] = Object.assign({}, state.allNfts[addressToSearch], {
                    [chainId]: nfts,
                });
            });
            __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_updateNestedNftState).call(this, nfts, ALL_NFTS_STATE_KEY, {
                userAddress: addressToSearch,
                chainId,
            });
        }
        return updatedNft;
    }
    /**
     * Checks whether NFTs associated with current selectedAddress/chainId combination are still owned by the user
     * And updates the isCurrentlyOwned value on each accordingly.
     *
     * @param networkClientId - The networkClientId that can be used to identify the network client to use for this request.
     * @param options - an object of arguments
     * @param options.userAddress - The address of the account where the NFT ownership status is checked/updated.
     */
    async checkAndUpdateAllNftsOwnershipStatus(networkClientId, { userAddress, } = {}) {
        const addressToSearch = __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_getAddressOrSelectedAddress).call(this, userAddress);
        const { configuration: { chainId }, } = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId);
        const { allNfts } = this.state;
        const nfts = allNfts[addressToSearch]?.[chainId] || [];
        const updatedNfts = await Promise.all(nfts.map(async (nft) => {
            return ((await this.checkAndUpdateSingleNftOwnershipStatus(nft, true, networkClientId, {
                userAddress,
            })) ?? nft);
        }));
        __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_updateNestedNftState).call(this, updatedNfts, ALL_NFTS_STATE_KEY, {
            userAddress: addressToSearch,
            chainId,
        });
    }
    /**
     * Update NFT favorite status.
     *
     * @param address - Hex address of the NFT contract.
     * @param tokenId - Hex address of the NFT contract.
     * @param favorite - NFT new favorite status.
     * @param networkClientId - The networkClientId that can be used to identify the network client to use for this request.
     * @param options - an object of arguments
     * @param options.userAddress - The address of the account where the NFT is being removed.
     */
    updateNftFavoriteStatus(address, tokenId, favorite, networkClientId, { userAddress, } = {}) {
        const addressToSearch = __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_getAddressOrSelectedAddress).call(this, userAddress);
        const { configuration: { chainId }, } = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId);
        const { allNfts } = this.state;
        const nfts = [...(allNfts[addressToSearch]?.[chainId] || [])];
        const index = nfts.findIndex((nft) => nft.address === address && nft.tokenId === tokenId);
        if (index === -1) {
            return;
        }
        const updatedNft = {
            ...nfts[index],
            favorite,
        };
        // Update Nfts array
        nfts[index] = updatedNft;
        __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_updateNestedNftState).call(this, nfts, ALL_NFTS_STATE_KEY, {
            chainId,
            userAddress: addressToSearch,
        });
    }
    /**
     * Returns an NFT by the address and token id.
     *
     * @param address - Hex address of the NFT contract.
     * @param tokenId - Number that represents the id of the token.
     * @param selectedAddress - Hex address of the user account.
     * @param chainId - Id of the current network.
     * @returns Object containing the NFT and its position in the array
     */
    findNftByAddressAndTokenId(address, tokenId, selectedAddress, chainId) {
        const { allNfts } = this.state;
        const nfts = allNfts[selectedAddress]?.[chainId] || [];
        const index = nfts.findIndex((nft) => nft.address.toLowerCase() === address.toLowerCase() &&
            nft.tokenId === tokenId);
        if (index === -1) {
            return null;
        }
        return { nft: nfts[index], index };
    }
    /**
     * Update NFT data.
     *
     * @param nft - NFT object to find the right NFT to updates.
     * @param updates - NFT partial object to update properties of the NFT.
     * @param selectedAddress - Hex address of the user account.
     * @param chainId - Id of the current network.
     */
    updateNft(nft, updates, selectedAddress, chainId) {
        const { allNfts } = this.state;
        const nfts = allNfts[selectedAddress]?.[chainId] || [];
        const nftInfo = this.findNftByAddressAndTokenId(nft.address, nft.tokenId, selectedAddress, chainId);
        if (!nftInfo) {
            return;
        }
        const updatedNft = {
            ...nft,
            ...updates,
        };
        const newNfts = [
            ...nfts.slice(0, nftInfo.index),
            updatedNft,
            ...nfts.slice(nftInfo.index + 1),
        ];
        __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_updateNestedNftState).call(this, newNfts, ALL_NFTS_STATE_KEY, {
            chainId,
            userAddress: selectedAddress,
        });
    }
    /**
     * Resets the transaction status of an NFT.
     *
     * @param transactionId - NFT transaction id.
     * @param selectedAddress - Hex address of the user account.
     * @param chainId - Id of the current network.
     * @returns a boolean indicating if the reset was well succeeded or not
     */
    resetNftTransactionStatusByTransactionId(transactionId, selectedAddress, chainId) {
        const { allNfts } = this.state;
        const nfts = allNfts[selectedAddress]?.[chainId] || [];
        const index = nfts.findIndex((nft) => nft.transactionId === transactionId);
        if (index === -1) {
            return false;
        }
        const updatedNft = {
            ...nfts[index],
            transactionId: undefined,
        };
        const newNfts = [
            ...nfts.slice(0, index),
            updatedNft,
            ...nfts.slice(index + 1),
        ];
        __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_updateNestedNftState).call(this, newNfts, ALL_NFTS_STATE_KEY, {
            chainId,
            userAddress: selectedAddress,
        });
        return true;
    }
    /**
     * Fetches NFT Collection Metadata from the NFT API.
     *
     * @param contractAddresses - The contract addresses of the NFTs.
     * @param chainId - The chain ID of the network where the NFT is located.
     * @returns NFT collections metadata.
     */
    async getNFTContractInfo(contractAddresses, chainId) {
        const url = new URL(__classPrivateFieldGet(this, _NftController_instances, "m", _NftController_getNftCollectionApi).call(this));
        url.searchParams.append('chainId', chainId);
        for (const address of contractAddresses) {
            url.searchParams.append('contract', address);
        }
        return await (0, controller_utils_1.handleFetch)(url, {
            headers: {
                Version: controller_utils_1.NFT_API_VERSION,
            },
        });
    }
    async _requestApproval(suggestedNftMeta) {
        return this.messagingSystem.call('ApprovalController:addRequest', {
            id: suggestedNftMeta.id,
            origin: suggestedNftMeta.origin,
            type: controller_utils_1.ApprovalType.WatchAsset,
            requestData: {
                id: suggestedNftMeta.id,
                interactingAddress: suggestedNftMeta.interactingAddress,
                asset: {
                    address: suggestedNftMeta.asset.address,
                    tokenId: suggestedNftMeta.asset.tokenId,
                    name: suggestedNftMeta.asset.name,
                    description: suggestedNftMeta.asset.description,
                    image: suggestedNftMeta.asset.image,
                    standard: suggestedNftMeta.asset.standard,
                },
            },
        }, true);
    }
    /**
     * Reset the controller state to the default state.
     */
    resetState() {
        this.update(() => {
            return (0, exports.getDefaultNftControllerState)();
        });
    }
}
exports.NftController = NftController;
_NftController_mutex = new WeakMap(), _NftController_selectedAccountId = new WeakMap(), _NftController_ipfsGateway = new WeakMap(), _NftController_displayNftMedia = new WeakMap(), _NftController_useIpfsSubdomains = new WeakMap(), _NftController_isIpfsGatewayEnabled = new WeakMap(), _NftController_onNftAdded = new WeakMap(), _NftController_instances = new WeakSet(), _NftController_onPreferencesControllerStateChange = 
/**
 * Handles the state change of the preference controller.
 *
 * @param preferencesState - The new state of the preference controller.
 * @param preferencesState.ipfsGateway - The configured IPFS gateway.
 * @param preferencesState.isIpfsGatewayEnabled - Controls whether IPFS is enabled or not.
 * @param preferencesState.displayNftMedia - Controls whether the NFT API is used (mobile).
 * @param preferencesState.openSeaEnabled - Controls whether the NFT API is used (extension).
 */
async function _NftController_onPreferencesControllerStateChange({ ipfsGateway, isIpfsGatewayEnabled, displayNftMedia, openSeaEnabled, }) {
    const selectedAccount = this.messagingSystem.call('AccountsController:getSelectedAccount');
    __classPrivateFieldSet(this, _NftController_selectedAccountId, selectedAccount.id, "f");
    const newDisplayNftMedia = Boolean(displayNftMedia || openSeaEnabled);
    // Get current state values
    if (__classPrivateFieldGet(this, _NftController_ipfsGateway, "f") !== ipfsGateway ||
        __classPrivateFieldGet(this, _NftController_displayNftMedia, "f") !== newDisplayNftMedia ||
        __classPrivateFieldGet(this, _NftController_isIpfsGatewayEnabled, "f") !== isIpfsGatewayEnabled) {
        __classPrivateFieldSet(this, _NftController_ipfsGateway, ipfsGateway, "f");
        __classPrivateFieldSet(this, _NftController_displayNftMedia, newDisplayNftMedia, "f");
        __classPrivateFieldSet(this, _NftController_isIpfsGatewayEnabled, isIpfsGatewayEnabled, "f");
        const needsUpdateNftMetadata = (isIpfsGatewayEnabled && ipfsGateway !== '') || newDisplayNftMedia;
        if (needsUpdateNftMetadata && selectedAccount) {
            await __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_updateNftUpdateForAccount).call(this, selectedAccount);
        }
    }
}, _NftController_onSelectedAccountChange = 
/**
 * Handles the selected account change on the accounts controller.
 *
 * @param internalAccount - The new selected account.
 */
async function _NftController_onSelectedAccountChange(internalAccount) {
    const oldSelectedAccountId = __classPrivateFieldGet(this, _NftController_selectedAccountId, "f");
    __classPrivateFieldSet(this, _NftController_selectedAccountId, internalAccount.id, "f");
    const needsUpdateNftMetadata = ((__classPrivateFieldGet(this, _NftController_isIpfsGatewayEnabled, "f") && __classPrivateFieldGet(this, _NftController_ipfsGateway, "f") !== '') ||
        __classPrivateFieldGet(this, _NftController_displayNftMedia, "f")) &&
        oldSelectedAccountId !== internalAccount.id;
    if (needsUpdateNftMetadata) {
        await __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_updateNftUpdateForAccount).call(this, internalAccount);
    }
}, _NftController_updateNestedNftState = function _NftController_updateNestedNftState(newCollection, baseStateKey, { userAddress, chainId }) {
    // userAddress can be an empty string if it is not set via an account change or in constructor
    // while this doesn't cause any issues, we want to ensure that we don't store assets to an empty string address
    if (!userAddress) {
        return;
    }
    this.update((state) => {
        const oldState = state[baseStateKey];
        const addressState = oldState[userAddress] || {};
        const newAddressState = {
            ...addressState,
            [chainId]: newCollection,
        };
        state[baseStateKey] = {
            ...oldState,
            [userAddress]: newAddressState,
        };
    });
}, _NftController_getNftCollectionApi = function _NftController_getNftCollectionApi() {
    // False negative.
    return `${controller_utils_1.NFT_API_BASE_URL}/collections`;
}, _NftController_getNftInformationFromApi = 
/**
 * Request individual NFT information from NFT API.
 *
 * @param contractAddress - Hex address of the NFT contract.
 * @param tokenId - The NFT identifier.
 * @returns Promise resolving to the current NFT name and image.
 */
async function _NftController_getNftInformationFromApi(contractAddress, tokenId) {
    // TODO Parameterize this by chainId for non-mainnet token detection
    // Attempt to fetch the data with the nft-api
    const urlParams = new URLSearchParams({
        chainIds: '1',
        tokens: `${contractAddress}:${tokenId}`,
        includeTopBid: 'true',
        includeAttributes: 'true',
        includeLastSale: 'true',
    }).toString();
    // First fetch token information
    const nftInformation = await (0, controller_utils_1.fetchWithErrorHandling)({
        url: `${this.getNftApi()}?${urlParams}`,
        options: {
            headers: {
                Version: controller_utils_1.NFT_API_VERSION,
            },
        },
    });
    // Params for getCollections API call
    const getCollectionParams = new URLSearchParams({
        chainId: '1',
        id: `${nftInformation?.tokens[0]?.token?.collection?.id}`,
    }).toString();
    // Fetch collection information using collectionId
    const collectionInformation = await (0, controller_utils_1.fetchWithErrorHandling)({
        url: `${controller_utils_1.NFT_API_BASE_URL}/collections?${getCollectionParams}`,
        options: {
            headers: {
                Version: controller_utils_1.NFT_API_VERSION,
            },
        },
    });
    // if we were still unable to fetch the data we return out the default/null of `NftMetadata`
    if (!nftInformation?.tokens?.[0]?.token) {
        return {
            name: null,
            description: null,
            image: null,
            standard: null,
        };
    }
    // if we've reached this point, we have successfully fetched some data for nftInformation
    // now we reconfigure the data to conform to the `NftMetadata` type for storage.
    const { image, metadata: { imageOriginal } = {}, name, description, collection, kind, rarityRank, rarity, attributes, lastSale, imageSmall, } = nftInformation.tokens[0].token;
    /* istanbul ignore next */
    const nftMetadata = Object.assign({}, { name: name || null }, { description: description || null }, { image: image || null }, collection?.creator && { creator: collection.creator }, imageOriginal && { imageOriginal }, imageSmall && { imageThumbnail: imageSmall }, kind && { standard: kind.toUpperCase() }, lastSale && { lastSale }, attributes && { attributes }, nftInformation.tokens[0].market?.topBid && {
        topBid: nftInformation.tokens[0].market?.topBid,
    }, rarityRank && { rarityRank }, rarity && { rarity }, (collection || collectionInformation) && {
        collection: {
            ...(collection || {}),
            creator: collection?.creator ||
                collectionInformation?.collections[0].creator,
            openseaVerificationStatus: collectionInformation?.collections[0].openseaVerificationStatus,
            contractDeployedAt: collectionInformation?.collections[0].contractDeployedAt,
            ownerCount: collectionInformation?.collections[0].ownerCount,
            topBid: collectionInformation?.collections[0].topBid,
        },
    });
    return nftMetadata;
}, _NftController_getNftInformationFromTokenURI = 
/**
 * Request individual NFT information from contracts that follows Metadata Interface.
 *
 * @param contractAddress - Hex address of the NFT contract.
 * @param tokenId - The NFT identifier.
 * @param networkClientId - The networkClientId that can be used to identify the network client to use for this request.
 * @returns Promise resolving to the current NFT name and image.
 */
async function _NftController_getNftInformationFromTokenURI(contractAddress, tokenId, networkClientId) {
    const result = await __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_getNftURIAndStandard).call(this, contractAddress, tokenId, networkClientId);
    let tokenURI = result[0];
    const standard = result[1];
    const hasIpfsTokenURI = tokenURI.startsWith('ipfs://');
    if (hasIpfsTokenURI && !__classPrivateFieldGet(this, _NftController_isIpfsGatewayEnabled, "f")) {
        return {
            image: null,
            name: null,
            description: null,
            standard: standard || null,
            favorite: false,
            tokenURI: tokenURI ?? null,
        };
    }
    const isDisplayNFTMediaToggleEnabled = __classPrivateFieldGet(this, _NftController_displayNftMedia, "f");
    if (!hasIpfsTokenURI && !isDisplayNFTMediaToggleEnabled) {
        return {
            image: null,
            name: null,
            description: null,
            standard: standard || null,
            favorite: false,
            tokenURI: tokenURI ?? null,
        };
    }
    if (hasIpfsTokenURI) {
        tokenURI = await (0, assetsUtil_1.getFormattedIpfsUrl)(__classPrivateFieldGet(this, _NftController_ipfsGateway, "f"), tokenURI, __classPrivateFieldGet(this, _NftController_useIpfsSubdomains, "f"));
    }
    if (tokenURI.startsWith('data:image/')) {
        return {
            image: tokenURI,
            name: null,
            description: null,
            standard: standard || null,
            favorite: false,
            tokenURI: tokenURI ?? null,
        };
    }
    try {
        const object = await (0, controller_utils_1.handleFetch)(tokenURI);
        // TODO: Check image_url existence. This is not part of EIP721 nor EIP1155
        const image = Object.prototype.hasOwnProperty.call(object, 'image')
            ? 'image'
            : /* istanbul ignore next */ 'image_url';
        return {
            image: object[image],
            name: object.name,
            description: object.description,
            standard,
            favorite: false,
            tokenURI: tokenURI ?? null,
        };
    }
    catch {
        return {
            image: null,
            name: null,
            description: null,
            standard: standard || null,
            favorite: false,
            tokenURI: tokenURI ?? null,
        };
    }
}, _NftController_getNftURIAndStandard = 
/**
 * Retrieve NFT uri with  metadata. TODO Update method to use IPFS.
 *
 * @param contractAddress - NFT contract address.
 * @param tokenId - NFT token id.
 * @param networkClientId - The networkClientId that can be used to identify the network client to use for this request.
 * @returns Promise resolving NFT uri and token standard.
 */
async function _NftController_getNftURIAndStandard(contractAddress, tokenId, networkClientId) {
    // try ERC721 uri
    try {
        const uri = await this.messagingSystem.call('AssetsContractController:getERC721TokenURI', contractAddress, tokenId, networkClientId);
        return [uri, controller_utils_1.ERC721];
    }
    catch {
        // Ignore error
    }
    // try ERC1155 uri
    try {
        const tokenURI = await this.messagingSystem.call('AssetsContractController:getERC1155TokenURI', contractAddress, tokenId, networkClientId);
        /**
         * According to EIP1155 the URI value allows for ID substitution
         * in case the string `{id}` exists.
         * https://eips.ethereum.org/EIPS/eip-1155#metadata
         */
        if (!tokenURI.includes('{id}')) {
            return [tokenURI, controller_utils_1.ERC1155];
        }
        const hexTokenId = (0, utils_1.remove0x)((0, controller_utils_1.BNToHex)(new bn_js_1.default(tokenId)))
            .padStart(64, '0')
            .toLowerCase();
        return [tokenURI.replace('{id}', hexTokenId), controller_utils_1.ERC1155];
    }
    catch {
        // Ignore error
    }
    return ['', ''];
}, _NftController_getNftInformation = 
/**
 * Request individual NFT information (name, image url and description).
 *
 * @param contractAddress - Hex address of the NFT contract.
 * @param tokenId - The NFT identifier.
 * @param networkClientId - The networkClientId that can be used to identify the network client to use for this request.
 * @returns Promise resolving to the current NFT name and image.
 */
async function _NftController_getNftInformation(contractAddress, tokenId, networkClientId) {
    const { configuration: { chainId }, } = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId);
    const [blockchainMetadata, nftApiMetadata] = await Promise.all([
        (0, controller_utils_1.safelyExecute)(() => __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_getNftInformationFromTokenURI).call(this, contractAddress, tokenId, networkClientId)),
        __classPrivateFieldGet(this, _NftController_displayNftMedia, "f") && chainId === '0x1'
            ? (0, controller_utils_1.safelyExecute)(() => __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_getNftInformationFromApi).call(this, contractAddress, tokenId))
            : undefined,
    ]);
    const metadata = {
        ...nftApiMetadata,
        name: blockchainMetadata?.name ?? nftApiMetadata?.name ?? null,
        description: blockchainMetadata?.description ?? nftApiMetadata?.description ?? null,
        image: nftApiMetadata?.image ?? blockchainMetadata?.image ?? null,
        standard: blockchainMetadata?.standard ?? nftApiMetadata?.standard ?? null,
        tokenURI: blockchainMetadata?.tokenURI ?? null,
    };
    // Sanitize the metadata by checking external links against phishing protection
    return await __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_sanitizeNftMetadata).call(this, metadata);
}, _NftController_getNftContractInformationFromContract = 
/**
 * Request NFT contract information from the contract itself.
 *
 * @param contractAddress - Hex address of the NFT contract.
 * @param networkClientId - The networkClientId that can be used to identify the network client to use for this request.
 * @returns Promise resolving to the current NFT name and image.
 */
async function _NftController_getNftContractInformationFromContract(
// TODO for calls to blockchain we need to explicitly pass the currentNetworkClientId since its relying on the provider
contractAddress, networkClientId) {
    const [name, symbol] = await Promise.all([
        this.messagingSystem.call('AssetsContractController:getERC721AssetName', contractAddress, networkClientId),
        this.messagingSystem.call('AssetsContractController:getERC721AssetSymbol', contractAddress, networkClientId),
    ]);
    return {
        collection: { name },
        symbol,
        address: contractAddress,
    };
}, _NftController_getNftContractInformation = 
/**
 * Request NFT contract information from Blockchain and aggregate with received data from NFTMetadata.
 *
 * @param contractAddress - Hex address of the NFT contract.
 * @param nftMetadataFromApi - Received NFT information to be aggregated with blockchain contract information.
 * @param networkClientId - The networkClientId that can be used to identify the network client to use for this request.
 * @returns Promise resolving to the NFT contract name, image and description.
 */
async function _NftController_getNftContractInformation(contractAddress, nftMetadataFromApi, networkClientId) {
    const blockchainContractData = await (0, controller_utils_1.safelyExecute)(() => __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_getNftContractInformationFromContract).call(this, contractAddress, networkClientId));
    if (blockchainContractData ||
        !Object.values(nftMetadataFromApi).every((value) => value === null)) {
        return {
            address: contractAddress,
            ...blockchainContractData,
            schema_name: nftMetadataFromApi?.standard ?? null,
            collection: {
                name: null,
                image_url: nftMetadataFromApi?.collection?.image ??
                    nftMetadataFromApi?.collection?.imageUrl ??
                    null,
                tokenCount: nftMetadataFromApi?.collection?.tokenCount ?? null,
                ...nftMetadataFromApi?.collection,
                ...blockchainContractData?.collection,
            },
        };
    }
    /* istanbul ignore next */
    return {
        address: contractAddress,
        asset_contract_type: null,
        created_date: null,
        schema_name: null,
        symbol: null,
        total_supply: null,
        description: null,
        external_link: null,
        collection: { name: null, image_url: null },
    };
}, _NftController_addIndividualNft = 
/**
 * Adds an individual NFT to the stored NFT list.
 *
 * @param tokenAddress - Hex address of the NFT contract.
 * @param tokenId - The NFT identifier.
 * @param nftMetadata - NFT optional information (name, image and description).
 * @param nftContract - An object containing contract data of the NFT being added.
 * @param chainId - The chainId of the network where the NFT is being added.
 * @param userAddress - The address of the account where the NFT is being added.
 * @param source - Whether the NFT was detected, added manually or suggested by a dapp.
 * @returns A promise resolving to `undefined`.
 */
async function _NftController_addIndividualNft(tokenAddress, tokenId, nftMetadata, nftContract, chainId, userAddress, source) {
    const releaseLock = await __classPrivateFieldGet(this, _NftController_mutex, "f").acquire();
    try {
        const checksumHexAddress = (0, controller_utils_1.toChecksumHexAddress)(tokenAddress);
        const { allNfts } = this.state;
        const nfts = [...(allNfts[userAddress]?.[chainId] ?? [])];
        const existingEntry = nfts.find((nft) => nft.address.toLowerCase() === checksumHexAddress.toLowerCase() &&
            nft.tokenId === tokenId);
        if (existingEntry) {
            const differentMetadata = (0, assetsUtil_1.compareNftMetadata)(nftMetadata, existingEntry);
            const hasNewFields = (0, assetsUtil_1.hasNewCollectionFields)(nftMetadata, existingEntry);
            if (!differentMetadata &&
                existingEntry.isCurrentlyOwned &&
                !hasNewFields) {
                return;
            }
            const indexToUpdate = nfts.findIndex((nft) => nft.address.toLowerCase() === checksumHexAddress.toLowerCase() &&
                nft.tokenId === tokenId);
            if (indexToUpdate !== -1) {
                nfts[indexToUpdate] = {
                    ...existingEntry,
                    ...nftMetadata,
                };
            }
        }
        else {
            const newEntry = {
                address: checksumHexAddress,
                tokenId,
                favorite: false,
                isCurrentlyOwned: true,
                ...nftMetadata,
            };
            nfts.push(newEntry);
        }
        __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_updateNestedNftState).call(this, nfts, ALL_NFTS_STATE_KEY, {
            chainId,
            userAddress,
        });
        if (__classPrivateFieldGet(this, _NftController_onNftAdded, "f")) {
            __classPrivateFieldGet(this, _NftController_onNftAdded, "f").call(this, {
                address: checksumHexAddress,
                symbol: nftContract.symbol,
                tokenId: tokenId.toString(),
                standard: nftMetadata.standard,
                source,
            });
        }
    }
    finally {
        releaseLock();
    }
}, _NftController_addNftContract = 
/**
 * Adds an NFT contract to the stored NFT contracts list.
 *
 * @param networkClientId - The networkClientId that can be used to identify the network client to use for this request.
 * @param options - options.
 * @param options.tokenAddress - Hex address of the NFT contract.
 * @param options.userAddress - The address of the account where the NFT is being added.
 * @param options.nftMetadata - The retrieved NFTMetadata from API.
 * @param options.source - Whether the NFT was detected, added manually or suggested by a dapp.
 * @returns Promise resolving to the current NFT contracts list.
 */
async function _NftController_addNftContract(networkClientId, { tokenAddress, userAddress, source, nftMetadata, }) {
    const releaseLock = await __classPrivateFieldGet(this, _NftController_mutex, "f").acquire();
    try {
        const checksumHexAddress = (0, controller_utils_1.toChecksumHexAddress)(tokenAddress);
        const { allNftContracts } = this.state;
        const { configuration: { chainId }, } = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId);
        const nftContracts = allNftContracts[userAddress]?.[chainId] || [];
        const existingEntry = nftContracts.find((nftContract) => nftContract.address.toLowerCase() ===
            checksumHexAddress.toLowerCase());
        if (existingEntry) {
            return nftContracts;
        }
        // this doesn't work currently for detection if the user switches networks while the detection is processing
        // will be fixed once detection uses networkClientIds
        // get name and symbol if ERC721 then put together the metadata
        const contractInformation = await __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_getNftContractInformation).call(this, checksumHexAddress, nftMetadata, networkClientId);
        const { asset_contract_type, created_date, symbol, description, external_link, schema_name, collection: { name, image_url, tokenCount }, } = contractInformation;
        // If the nft is auto-detected we want some valid metadata to be present
        if (source === constants_1.Source.Detected &&
            'address' in contractInformation &&
            typeof contractInformation.address === 'string' &&
            'collection' in contractInformation &&
            contractInformation.collection.name === null &&
            'image_url' in contractInformation.collection &&
            contractInformation.collection.image_url === null &&
            Object.entries(contractInformation).every(([key, value]) => {
                return key === 'address' || key === 'collection' || !value;
            })) {
            return nftContracts;
        }
        /* istanbul ignore next */
        const newEntry = Object.assign({}, { address: checksumHexAddress }, description && { description }, name && { name }, image_url && { logo: image_url }, symbol && { symbol }, tokenCount !== null &&
            typeof tokenCount !== 'undefined' && { totalSupply: tokenCount }, asset_contract_type && { assetContractType: asset_contract_type }, created_date && { createdDate: created_date }, schema_name && { schemaName: schema_name }, external_link && { externalLink: external_link });
        const newNftContracts = [...nftContracts, newEntry];
        __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_updateNestedNftState).call(this, newNftContracts, ALL_NFTS_CONTRACTS_STATE_KEY, {
            chainId,
            userAddress,
        });
        return newNftContracts;
    }
    finally {
        releaseLock();
    }
}, _NftController_removeAndIgnoreIndividualNft = function _NftController_removeAndIgnoreIndividualNft(address, tokenId, { chainId, userAddress, }) {
    const checksumHexAddress = (0, controller_utils_1.toChecksumHexAddress)(address);
    const { allNfts, ignoredNfts } = this.state;
    const newIgnoredNfts = [...ignoredNfts];
    const nfts = allNfts[userAddress]?.[chainId] || [];
    const newNfts = nfts.filter((nft) => {
        if (nft.address.toLowerCase() === checksumHexAddress.toLowerCase() &&
            nft.tokenId === tokenId) {
            const alreadyIgnored = newIgnoredNfts.find((c) => c.address === checksumHexAddress && c.tokenId === tokenId);
            !alreadyIgnored && newIgnoredNfts.push(nft);
            return false;
        }
        return true;
    });
    __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_updateNestedNftState).call(this, newNfts, ALL_NFTS_STATE_KEY, {
        userAddress,
        chainId,
    });
    this.update((state) => {
        state.ignoredNfts = newIgnoredNfts;
    });
}, _NftController_removeIndividualNft = function _NftController_removeIndividualNft(address, tokenId, { chainId, userAddress }) {
    const checksumHexAddress = (0, controller_utils_1.toChecksumHexAddress)(address);
    const { allNfts } = this.state;
    const nfts = allNfts[userAddress]?.[chainId] || [];
    const newNfts = nfts.filter((nft) => !(nft.address.toLowerCase() === checksumHexAddress.toLowerCase() &&
        nft.tokenId === tokenId));
    __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_updateNestedNftState).call(this, newNfts, ALL_NFTS_STATE_KEY, {
        userAddress,
        chainId,
    });
}, _NftController_removeNftContract = function _NftController_removeNftContract(address, { chainId, userAddress }) {
    const checksumHexAddress = (0, controller_utils_1.toChecksumHexAddress)(address);
    const { allNftContracts } = this.state;
    const nftContracts = allNftContracts[userAddress]?.[chainId] || [];
    const newNftContracts = nftContracts.filter((nftContract) => !(nftContract.address.toLowerCase() === checksumHexAddress.toLowerCase()));
    __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_updateNestedNftState).call(this, newNftContracts, ALL_NFTS_CONTRACTS_STATE_KEY, {
        chainId,
        userAddress,
    });
    return newNftContracts;
}, _NftController_validateWatchNft = async function _NftController_validateWatchNft(asset, type, userAddress, networkClientId) {
    const { address: contractAddress, tokenId } = asset;
    // Validate parameters
    if (!type) {
        throw rpc_errors_1.rpcErrors.invalidParams('Asset type is required');
    }
    if (type !== controller_utils_1.ERC721 && type !== controller_utils_1.ERC1155) {
        throw rpc_errors_1.rpcErrors.invalidParams(
        // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
        `Non NFT asset type ${type} not supported by watchNft`);
    }
    if (!contractAddress || !tokenId) {
        throw rpc_errors_1.rpcErrors.invalidParams('Both address and tokenId are required');
    }
    if (!(0, address_1.isAddress)(contractAddress)) {
        throw rpc_errors_1.rpcErrors.invalidParams('Invalid address');
    }
    if (!/^\d+$/u.test(tokenId)) {
        throw rpc_errors_1.rpcErrors.invalidParams('Invalid tokenId');
    }
    // Check if the user owns the suggested NFT
    try {
        const isOwner = await this.isNftOwner(userAddress, contractAddress, tokenId, networkClientId);
        if (!isOwner) {
            throw rpc_errors_1.rpcErrors.invalidInput('Suggested NFT is not owned by the selected account');
        }
    }
    catch (error) {
        // error thrown here: "Unable to verify ownership. Possibly because the standard is not supported or the user's currently selected network does not match the chain of the asset in question."
        if (error instanceof Error) {
            throw rpc_errors_1.rpcErrors.resourceUnavailable(error.message);
        }
        throw error;
    }
}, _NftController_getAddressOrSelectedAddress = function _NftController_getAddressOrSelectedAddress(address) {
    if (address) {
        return address;
    }
    // If the address is not defined (or empty), we fallback to the currently selected account's address
    const selectedAccount = this.messagingSystem.call('AccountsController:getAccount', __classPrivateFieldGet(this, _NftController_selectedAccountId, "f"));
    return selectedAccount?.address || '';
}, _NftController_updateNftUpdateForAccount = 
/**
 * Updates the all nfts in state for the account.
 * Nfts will be updated if they don't have a name, description or image.
 *
 * @param account - The account to update the NFT metadata for.
 */
async function _NftController_updateNftUpdateForAccount(account) {
    // get all nfts for the account for all chains
    const nfts = Object.values(this.state.allNfts[account.address] || {}).flat();
    // Filter only nfts
    const nftsToUpdate = nfts.filter((singleNft) => !singleNft.name && !singleNft.description && !singleNft.image);
    if (nftsToUpdate.length !== 0 &&
        nftsToUpdate.length < NFT_UPDATE_THRESHOLD) {
        await this.updateNftMetadata({
            nfts: nftsToUpdate,
            userAddress: account.address,
        });
    }
}, _NftController_bulkSanitizeNftMetadata = 
/**
 * Sanitizes multiple NFT metadata objects by checking external links against PhishingController in a single bulk request
 *
 * @param metadataList - Array of NFT metadata objects to sanitize
 * @returns Array of sanitized NFT metadata objects
 */
async function _NftController_bulkSanitizeNftMetadata(metadataList) {
    // Create a copy of the metadata list to avoid mutating the input
    const sanitizedMetadataList = metadataList.map((metadata) => ({
        ...metadata,
    }));
    // Maps URL to a list of {metadataIndex, fieldName} to track where each URL is used
    const urlMap = {};
    const fieldsToCheck = [
        'externalLink',
        'image',
        'imagePreview',
        'imageThumbnail',
        'imageOriginal',
        'animation',
        'animationOriginal',
    ];
    // Collect all URLs from all metadata objects
    sanitizedMetadataList.forEach((metadata, metadataIndex) => {
        // Check regular fields
        for (const field of fieldsToCheck) {
            const url = metadata[field];
            if (typeof url === 'string' && url && url.startsWith('http')) {
                if (!urlMap[url]) {
                    urlMap[url] = [];
                }
                urlMap[url].push({ metadataIndex, fieldName: field });
            }
        }
        // Check collection links if they exist
        if (metadata.collection) {
            const { collection } = metadata;
            if ('externalLink' in collection &&
                typeof collection.externalLink === 'string') {
                const url = collection.externalLink;
                if (!urlMap[url]) {
                    urlMap[url] = [];
                }
                urlMap[url].push({
                    metadataIndex,
                    fieldName: 'collection.externalLink',
                });
            }
        }
    });
    const urlsToCheck = Object.keys(urlMap);
    if (urlsToCheck.length === 0) {
        return sanitizedMetadataList;
    }
    try {
        // Use bulkScanUrls to check all URLs at once
        const bulkScanResponse = await this.messagingSystem.call('PhishingController:bulkScanUrls', urlsToCheck);
        // Apply scan results to all metadata objects
        Object.entries(bulkScanResponse.results).forEach(([url, result]) => {
            if (result.recommendedAction === phishing_controller_1.RecommendedAction.Block) {
                // Remove this URL from all metadata objects where it appears
                urlMap[url].forEach(({ metadataIndex, fieldName }) => {
                    if (fieldName === 'collection.externalLink' &&
                        sanitizedMetadataList[metadataIndex].collection // Check if collection exists
                    ) {
                        const { collection } = sanitizedMetadataList[metadataIndex];
                        // Ensure collection is not undefined again just to be safe before using 'in'
                        if (collection && 'externalLink' in collection) {
                            delete collection.externalLink;
                        }
                    }
                    else {
                        delete sanitizedMetadataList[metadataIndex][fieldName];
                    }
                });
            }
        });
    }
    catch (error) {
        console.error('Error during bulk URL scanning:', error);
        // If bulk scan fails, we fall back to keeping all URLs
    }
    return sanitizedMetadataList;
}, _NftController_sanitizeNftMetadata = 
/**
 * Sanitizes NFT metadata by checking external links against PhishingController
 *
 * @param metadata - The NFT metadata to sanitize
 * @returns Sanitized NFT metadata with potentially dangerous links removed
 */
async function _NftController_sanitizeNftMetadata(metadata) {
    // Use the bulk sanitize function with just a single metadata object
    const sanitized = await __classPrivateFieldGet(this, _NftController_instances, "m", _NftController_bulkSanitizeNftMetadata).call(this, [metadata]);
    return sanitized[0];
};
exports.default = NftController;

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\NftController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\NftDetectionController.cjs", {"./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\constants.cjs","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CNftDetectionController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _NftDetectionController_instances, _NftDetectionController_disabled, _NftDetectionController_addNft, _NftDetectionController_getNftState, _NftDetectionController_inProcessNftFetchingUpdates, _NftDetectionController_onPreferencesControllerStateChange, _NftDetectionController_getOwnerNftApi, _NftDetectionController_getOwnerNfts;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NftDetectionController = exports.BlockaidResultType = void 0;
const base_controller_1 = require("@metamask/base-controller");
const controller_utils_1 = require("@metamask/controller-utils");
const utils_1 = require("@metamask/utils");
const constants_1 = require("./constants.cjs");
const controllerName = 'NftDetectionController';
/**
 * A set of supported networks for NFT detection.
 */
const supportedNftDetectionNetworks = new Set([
    // TODO: We should consider passing this constant from the NftDetectionController contructor
    // to reduce the complexity to add further network into this constant
    '0x1',
    '0xe708',
    '0x531', // Sei
]);
var BlockaidResultType;
(function (BlockaidResultType) {
    BlockaidResultType["Benign"] = "Benign";
    BlockaidResultType["Spam"] = "Spam";
    BlockaidResultType["Warning"] = "Warning";
    BlockaidResultType["Malicious"] = "Malicious";
})(BlockaidResultType || (exports.BlockaidResultType = BlockaidResultType = {}));
/**
 * Controller that passively detects nfts for a user address
 */
class NftDetectionController extends base_controller_1.BaseController {
    /**
     * The controller options
     *
     * @param options - The controller options.
     * @param options.messenger - A reference to the messaging system.
     * @param options.disabled - Represents previous value of useNftDetection. Used to detect changes of useNftDetection. Default value is true.
     * @param options.addNft - Add an NFT.
     * @param options.getNftState - Gets the current state of the Assets controller.
     */
    constructor({ messenger, disabled = false, addNft, getNftState, }) {
        super({
            name: controllerName,
            messenger,
            metadata: {},
            state: {},
        });
        _NftDetectionController_instances.add(this);
        _NftDetectionController_disabled.set(this, void 0);
        _NftDetectionController_addNft.set(this, void 0);
        _NftDetectionController_getNftState.set(this, void 0);
        _NftDetectionController_inProcessNftFetchingUpdates.set(this, void 0);
        __classPrivateFieldSet(this, _NftDetectionController_disabled, disabled, "f");
        __classPrivateFieldSet(this, _NftDetectionController_inProcessNftFetchingUpdates, {}, "f");
        __classPrivateFieldSet(this, _NftDetectionController_getNftState, getNftState, "f");
        __classPrivateFieldSet(this, _NftDetectionController_addNft, addNft, "f");
        this.messagingSystem.subscribe('PreferencesController:stateChange', __classPrivateFieldGet(this, _NftDetectionController_instances, "m", _NftDetectionController_onPreferencesControllerStateChange).bind(this));
    }
    /**
     * Checks whether network is mainnet or not.
     *
     * @returns Whether current network is mainnet.
     */
    isMainnet() {
        const { selectedNetworkClientId } = this.messagingSystem.call('NetworkController:getState');
        const { configuration: { chainId }, } = this.messagingSystem.call('NetworkController:getNetworkClientById', selectedNetworkClientId);
        return chainId === controller_utils_1.ChainId.mainnet;
    }
    isMainnetByNetworkClientId(networkClient) {
        return networkClient.configuration.chainId === controller_utils_1.ChainId.mainnet;
    }
    /**
     * Triggers asset ERC721 token auto detection on mainnet. Any newly detected NFTs are
     * added.
     *
     * @param chainIds - The chain IDs to detect NFTs on.
     * @param options - Options bag.
     * @param options.userAddress - The address to detect NFTs for.
     */
    async detectNfts(chainIds, options) {
        const userAddress = options?.userAddress ??
            this.messagingSystem.call('AccountsController:getSelectedAccount')
                .address;
        // filter out unsupported chainIds
        const supportedChainIds = chainIds.filter((chainId) => supportedNftDetectionNetworks.has(chainId));
        /* istanbul ignore if */
        if (supportedChainIds.length === 0 || __classPrivateFieldGet(this, _NftDetectionController_disabled, "f")) {
            return;
        }
        /* istanbul ignore else */
        if (!userAddress) {
            return;
        }
        // create a string of all chainIds
        const chainIdsString = chainIds.join(',');
        const updateKey = `${chainIdsString}:${userAddress}`;
        if (updateKey in __classPrivateFieldGet(this, _NftDetectionController_inProcessNftFetchingUpdates, "f")) {
            // This prevents redundant updates
            // This promise is resolved after the in-progress update has finished,
            // and state has been updated.
            await __classPrivateFieldGet(this, _NftDetectionController_inProcessNftFetchingUpdates, "f")[updateKey];
            return;
        }
        const { promise: inProgressUpdate, resolve: updateSucceeded, reject: updateFailed, } = (0, utils_1.createDeferredPromise)({ suppressUnhandledRejection: true });
        __classPrivateFieldGet(this, _NftDetectionController_inProcessNftFetchingUpdates, "f")[updateKey] = inProgressUpdate;
        let next;
        let apiNfts = [];
        let resultNftApi;
        try {
            do {
                resultNftApi = await __classPrivateFieldGet(this, _NftDetectionController_instances, "m", _NftDetectionController_getOwnerNfts).call(this, userAddress, supportedChainIds, next);
                apiNfts = resultNftApi.tokens.filter((elm) => elm.token.isSpam === false &&
                    (elm.blockaidResult?.result_type
                        ? elm.blockaidResult?.result_type === BlockaidResultType.Benign
                        : true));
                // Proceed to add NFTs
                const addNftPromises = apiNfts.map(async (nft) => {
                    const { tokenId, contract, kind, image: imageUrl, imageSmall: imageThumbnailUrl, metadata, name, description, attributes, topBid, lastSale, rarityRank, rarityScore, collection, chainId, } = nft.token;
                    // Use a fallback if metadata is null
                    const { imageOriginal: imageOriginalUrl } = metadata || {};
                    let ignored;
                    /* istanbul ignore else */
                    const { ignoredNfts } = __classPrivateFieldGet(this, _NftDetectionController_getNftState, "f").call(this);
                    if (ignoredNfts.length) {
                        ignored = ignoredNfts.find((c) => {
                            /* istanbul ignore next */
                            return (c.address === (0, controller_utils_1.toChecksumHexAddress)(contract) &&
                                c.tokenId === tokenId);
                        });
                    }
                    /* istanbul ignore else */
                    if (!ignored) {
                        /* istanbul ignore next */
                        const nftMetadata = Object.assign({}, { name }, description && { description }, imageUrl && { image: imageUrl }, imageThumbnailUrl && { imageThumbnail: imageThumbnailUrl }, imageOriginalUrl && { imageOriginal: imageOriginalUrl }, kind && { standard: kind.toUpperCase() }, lastSale && { lastSale }, attributes && { attributes }, topBid && { topBid }, rarityRank && { rarityRank }, rarityScore && { rarityScore }, collection && { collection }, chainId && { chainId });
                        const networkClientId = this.messagingSystem.call('NetworkController:findNetworkClientIdByChainId', (0, controller_utils_1.toHex)(chainId));
                        await __classPrivateFieldGet(this, _NftDetectionController_addNft, "f").call(this, contract, tokenId, networkClientId, {
                            nftMetadata,
                            userAddress,
                            source: constants_1.Source.Detected,
                        });
                    }
                });
                await Promise.all(addNftPromises);
            } while ((next = resultNftApi.continuation));
            updateSucceeded();
        }
        catch (error) {
            updateFailed(error);
            throw error;
        }
        finally {
            delete __classPrivateFieldGet(this, _NftDetectionController_inProcessNftFetchingUpdates, "f")[updateKey];
        }
    }
}
exports.NftDetectionController = NftDetectionController;
_NftDetectionController_disabled = new WeakMap(), _NftDetectionController_addNft = new WeakMap(), _NftDetectionController_getNftState = new WeakMap(), _NftDetectionController_inProcessNftFetchingUpdates = new WeakMap(), _NftDetectionController_instances = new WeakSet(), _NftDetectionController_onPreferencesControllerStateChange = function _NftDetectionController_onPreferencesControllerStateChange({ useNftDetection }) {
    if (!useNftDetection !== __classPrivateFieldGet(this, _NftDetectionController_disabled, "f")) {
        __classPrivateFieldSet(this, _NftDetectionController_disabled, !useNftDetection, "f");
    }
}, _NftDetectionController_getOwnerNftApi = function _NftDetectionController_getOwnerNftApi({ chainIds, address, next, }) {
    // from chainIds construct a string of chainIds that can be used like chainIds=1&chainIds=56
    const chainIdsString = chainIds.join('&chainIds=');
    return `${controller_utils_1.NFT_API_BASE_URL}/users/${address}/tokens?chainIds=${chainIdsString}&limit=50&includeTopBid=true&continuation=${next ?? ''}`;
}, _NftDetectionController_getOwnerNfts = async function _NftDetectionController_getOwnerNfts(address, chainIds, cursor) {
    // Convert hex chainId to number
    const convertedChainIds = chainIds.map((chainId) => (0, controller_utils_1.convertHexToDecimal)(chainId).toString());
    const url = __classPrivateFieldGet(this, _NftDetectionController_instances, "m", _NftDetectionController_getOwnerNftApi).call(this, {
        chainIds: convertedChainIds,
        address,
        next: cursor,
    });
    const nftApiResponse = await (0, controller_utils_1.handleFetch)(url, {
        headers: {
            Version: controller_utils_1.NFT_API_VERSION,
        },
    });
    return nftApiResponse;
};
exports.default = NftDetectionController;

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\NftDetectionController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\RatesController\\RatesController.cjs", {"../crypto-compare-service/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\crypto-compare-service\\index.cjs","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","async-mutex":"D:\\code\\v\\metamask-extension\\node_modules\\async-mutex\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CRatesController%5CRatesController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _RatesController_instances, _RatesController_mutex, _RatesController_fetchMultiExchangeRate, _RatesController_includeUsdRate, _RatesController_intervalLength, _RatesController_intervalId, _RatesController_withLock, _RatesController_executePoll, _RatesController_updateRates;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RatesController = exports.Cryptocurrency = exports.name = void 0;
const base_controller_1 = require("@metamask/base-controller");
const async_mutex_1 = require("async-mutex");
const crypto_compare_service_1 = require("../crypto-compare-service/index.cjs");
exports.name = 'RatesController';
/**
 * Supported cryptocurrencies that can be used as a base currency. The value needs to be compatible
 * with CryptoCompare's API which is the default source for the rates.
 *
 * See: https://min-api.cryptocompare.com/documentation?key=Price&cat=multipleSymbolsPriceEndpoint
 */
var Cryptocurrency;
(function (Cryptocurrency) {
    Cryptocurrency["Btc"] = "btc";
    Cryptocurrency["Solana"] = "sol";
})(Cryptocurrency || (exports.Cryptocurrency = Cryptocurrency = {}));
const DEFAULT_INTERVAL = 180000;
const metadata = {
    fiatCurrency: {
        includeInStateLogs: true,
        persist: true,
        anonymous: true,
        usedInUi: true,
    },
    rates: {
        includeInStateLogs: false,
        persist: true,
        anonymous: true,
        usedInUi: true,
    },
    cryptocurrencies: {
        includeInStateLogs: true,
        persist: true,
        anonymous: true,
        usedInUi: false,
    },
};
const defaultState = {
    fiatCurrency: 'usd',
    rates: {
        [Cryptocurrency.Btc]: {
            conversionDate: 0,
            conversionRate: 0,
        },
        [Cryptocurrency.Solana]: {
            conversionDate: 0,
            conversionRate: 0,
        },
    },
    cryptocurrencies: [Cryptocurrency.Btc, Cryptocurrency.Solana],
};
class RatesController extends base_controller_1.BaseController {
    /**
     * Creates a RatesController instance.
     *
     * @param options - Constructor options.
     * @param options.includeUsdRate - Keep track of the USD rate in addition to the current currency rate.
     * @param options.interval - The polling interval, in milliseconds.
     * @param options.messenger - A reference to the messaging system.
     * @param options.state - Initial state to set on this controller.
     * @param options.fetchMultiExchangeRate - Fetches the exchange rate from an external API. This option is primarily meant for use in unit tests.
     */
    constructor({ interval = DEFAULT_INTERVAL, messenger, state, includeUsdRate, fetchMultiExchangeRate = crypto_compare_service_1.fetchMultiExchangeRate, }) {
        super({
            name: exports.name,
            metadata,
            messenger,
            state: { ...defaultState, ...state },
        });
        _RatesController_instances.add(this);
        _RatesController_mutex.set(this, new async_mutex_1.Mutex());
        _RatesController_fetchMultiExchangeRate.set(this, void 0);
        _RatesController_includeUsdRate.set(this, void 0);
        _RatesController_intervalLength.set(this, void 0);
        _RatesController_intervalId.set(this, void 0);
        __classPrivateFieldSet(this, _RatesController_includeUsdRate, includeUsdRate, "f");
        __classPrivateFieldSet(this, _RatesController_fetchMultiExchangeRate, fetchMultiExchangeRate, "f");
        __classPrivateFieldSet(this, _RatesController_intervalLength, interval, "f");
    }
    /**
     * Starts the polling process.
     */
    async start() {
        if (__classPrivateFieldGet(this, _RatesController_intervalId, "f")) {
            return;
        }
        this.messagingSystem.publish(`${exports.name}:pollingStarted`);
        await __classPrivateFieldGet(this, _RatesController_instances, "m", _RatesController_updateRates).call(this);
        __classPrivateFieldSet(this, _RatesController_intervalId, setInterval(() => {
            __classPrivateFieldGet(this, _RatesController_instances, "m", _RatesController_executePoll).call(this).catch(console.error);
        }, __classPrivateFieldGet(this, _RatesController_intervalLength, "f")), "f");
    }
    /**
     * Stops the polling process.
     */
    async stop() {
        if (!__classPrivateFieldGet(this, _RatesController_intervalId, "f")) {
            return;
        }
        clearInterval(__classPrivateFieldGet(this, _RatesController_intervalId, "f"));
        __classPrivateFieldSet(this, _RatesController_intervalId, undefined, "f");
        this.messagingSystem.publish(`${exports.name}:pollingStopped`);
    }
    /**
     * Returns the current list of cryptocurrency.
     * @returns The cryptocurrency list.
     */
    getCryptocurrencyList() {
        const { cryptocurrencies } = this.state;
        return cryptocurrencies;
    }
    /**
     * Sets the list of supported cryptocurrencies.
     * @param cryptocurrencies - The list of supported cryptocurrencies.
     */
    async setCryptocurrencyList(cryptocurrencies) {
        await __classPrivateFieldGet(this, _RatesController_instances, "m", _RatesController_withLock).call(this, () => {
            this.update((state) => {
                return {
                    ...state,
                    cryptocurrencies,
                };
            });
        });
    }
    /**
     * Sets the internal fiat currency and update rates accordingly.
     * @param fiatCurrency - The fiat currency.
     */
    async setFiatCurrency(fiatCurrency) {
        if (fiatCurrency === '') {
            throw new Error('The currency can not be an empty string');
        }
        await __classPrivateFieldGet(this, _RatesController_instances, "m", _RatesController_withLock).call(this, () => {
            this.update((state) => {
                return {
                    ...state,
                    fiatCurrency,
                };
            });
        });
        await __classPrivateFieldGet(this, _RatesController_instances, "m", _RatesController_updateRates).call(this);
    }
}
exports.RatesController = RatesController;
_RatesController_mutex = new WeakMap(), _RatesController_fetchMultiExchangeRate = new WeakMap(), _RatesController_includeUsdRate = new WeakMap(), _RatesController_intervalLength = new WeakMap(), _RatesController_intervalId = new WeakMap(), _RatesController_instances = new WeakSet(), _RatesController_withLock = 
/**
 * Executes a function `callback` within a mutex lock to ensure that only one instance of `callback` runs at a time across all invocations of `#withLock`.
 * This method is useful for synchronizing access to a resource or section of code that should not be executed concurrently.
 *
 * @template R - The return type of the function `callback`.
 * @param callback - A callback to execute once the lock is acquired. This callback can be synchronous or asynchronous.
 * @returns A promise that resolves to the result of the function `callback`. The promise is fulfilled once `callback` has completed execution.
 * @example
 * async function criticalLogic() {
 *   // Critical logic code goes here.
 * }
 *
 * // Execute criticalLogic within a lock.
 * const result = await this.#withLock(criticalLogic);
 */
// TODO: Either fix this lint violation or explain why it's necessary to ignore.
// eslint-disable-next-line @typescript-eslint/naming-convention
async function _RatesController_withLock(callback) {
    const releaseLock = await __classPrivateFieldGet(this, _RatesController_mutex, "f").acquire();
    try {
        return callback();
    }
    finally {
        releaseLock();
    }
}, _RatesController_executePoll = 
/**
 * Executes the polling operation to update rates.
 */
async function _RatesController_executePoll() {
    await __classPrivateFieldGet(this, _RatesController_instances, "m", _RatesController_updateRates).call(this);
}, _RatesController_updateRates = 
/**
 * Updates the rates by fetching new data.
 */
async function _RatesController_updateRates() {
    await __classPrivateFieldGet(this, _RatesController_instances, "m", _RatesController_withLock).call(this, async () => {
        const { fiatCurrency, cryptocurrencies } = this.state;
        const response = await __classPrivateFieldGet(this, _RatesController_fetchMultiExchangeRate, "f").call(this, fiatCurrency, cryptocurrencies, __classPrivateFieldGet(this, _RatesController_includeUsdRate, "f"));
        const updatedRates = {};
        for (const [cryptocurrency, values] of Object.entries(response)) {
            updatedRates[cryptocurrency] = {
                conversionDate: Date.now(),
                conversionRate: values[fiatCurrency],
                ...(__classPrivateFieldGet(this, _RatesController_includeUsdRate, "f") && { usdConversionRate: values.usd }),
            };
        }
        this.update((state) => {
            return {
                ...state,
                rates: updatedRates,
            };
        });
    });
};

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\RatesController\\RatesController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\RatesController\\index.cjs", {"./RatesController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\RatesController\\RatesController.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CRatesController%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cryptocurrency = exports.RatesController = void 0;
var RatesController_1 = require("./RatesController.cjs");
Object.defineProperty(exports, "RatesController", { enumerable: true, get: function () { return RatesController_1.RatesController; } });
Object.defineProperty(exports, "Cryptocurrency", { enumerable: true, get: function () { return RatesController_1.Cryptocurrency; } });

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\RatesController\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\Standards\\ERC20Standard.cjs", {"../assetsUtil.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\assetsUtil.cjs","@ethereumjs/util":"D:\\code\\v\\metamask-extension\\node_modules\\@ethereumjs\\util\\dist\\cjs\\index.js","@ethersproject/contracts":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\contracts\\lib\\index.js","@metamask/abi-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\node_modules\\@metamask\\abi-utils\\dist\\index.js","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/metamask-eth-abis":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\metamask-eth-abis\\dist\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CStandards%5CERC20Standard.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ERC20Standard = void 0;
const util_1 = require("@ethereumjs/util");
const contracts_1 = require("@ethersproject/contracts");
const abi_utils_1 = require("@metamask/abi-utils");
const controller_utils_1 = require("@metamask/controller-utils");
const metamask_eth_abis_1 = require("@metamask/metamask-eth-abis");
const utils_1 = require("@metamask/utils");
const assetsUtil_1 = require("../assetsUtil.cjs");
class ERC20Standard {
    constructor(provider) {
        this.provider = provider;
    }
    /**
     * Get balance or count for current account on specific asset contract.
     *
     * @param address - Asset ERC20 contract address.
     * @param selectedAddress - Current account public address.
     * @returns Promise resolving to BN object containing balance for current account on specific asset contract.
     */
    async getBalanceOf(address, selectedAddress) {
        const contract = new contracts_1.Contract(address, metamask_eth_abis_1.abiERC20, this.provider);
        const balance = await contract.balanceOf(selectedAddress);
        return (0, assetsUtil_1.ethersBigNumberToBN)(balance);
    }
    /**
     * Query for the decimals for a given ERC20 asset.
     *
     * @param address - ERC20 asset contract string.
     * @returns Promise resolving to the 'decimals'.
     */
    async getTokenDecimals(address) {
        const contract = new contracts_1.Contract(address, metamask_eth_abis_1.abiERC20, this.provider);
        try {
            const decimals = await contract.decimals();
            return decimals.toString();
        }
        catch (err) {
            // Mirror previous implementation
            if (err instanceof Error &&
                err.message.includes('call revert exception')) {
                throw new Error('Failed to parse token decimals');
            }
            throw err;
        }
    }
    /**
     * Query for the name for a given ERC20 asset.
     *
     * @param address - ERC20 asset contract string.
     * @returns Promise resolving to the 'name'.
     */
    async getTokenName(address) {
        const contract = new contracts_1.Contract(address, metamask_eth_abis_1.abiERC20, this.provider);
        try {
            const name = await contract.name();
            return name.toString();
        }
        catch (err) {
            // Mirror previous implementation
            if (err instanceof Error &&
                err.message.includes('call revert exception')) {
                throw new Error('Failed to parse token name');
            }
            throw err;
        }
    }
    /**
     * Query for symbol for a given ERC20 asset.
     *
     * @param address - ERC20 asset contract address.
     * @returns Promise resolving to the 'symbol'.
     */
    async getTokenSymbol(address) {
        // Signature for calling `symbol()`
        const payload = { to: address, data: '0x95d89b41' };
        const result = await this.provider.call(payload);
        (0, utils_1.assertIsStrictHexString)(result);
        // Parse as string - treat empty string as failure
        try {
            const decoded = (0, abi_utils_1.decodeSingle)('string', result);
            if (decoded?.length > 0) {
                return decoded;
            }
        }
        catch {
            // Ignore error
        }
        // Parse as bytes - treat empty string as failure
        try {
            // Not done in bytesToUtf8 in ethereumjs/util.
            const regexPreceedingAndTrailingZeroes = /^(00)+|(00)+$/gu;
            const resultTrimmed = result?.replace(regexPreceedingAndTrailingZeroes, '');
            const utf8 = (0, util_1.bytesToUtf8)((0, utils_1.hexToBytes)(resultTrimmed));
            if (utf8.length > 0) {
                return utf8;
            }
        }
        catch {
            // Ignore error
        }
        throw new Error('Failed to parse token symbol');
    }
    /**
     * Query if a contract implements an interface.
     *
     * @param address - Asset contract address.
     * @param userAddress - The public address for the currently active user's account.
     * @returns Promise resolving an object containing the standard, decimals, symbol and balance of the given contract/userAddress pair.
     */
    async getDetails(address, userAddress) {
        const [decimals, symbol, balance] = await Promise.all([
            this.getTokenDecimals(address),
            this.getTokenSymbol(address),
            userAddress ? this.getBalanceOf(address, userAddress) : undefined,
        ]);
        return {
            decimals,
            symbol,
            balance,
            standard: controller_utils_1.ERC20,
        };
    }
}
exports.ERC20Standard = ERC20Standard;

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\Standards\\ERC20Standard.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\Standards\\NftStandards\\ERC1155\\ERC1155Standard.cjs", {"../../../assetsUtil.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\assetsUtil.cjs","@ethersproject/contracts":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\contracts\\lib\\index.js","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/metamask-eth-abis":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\metamask-eth-abis\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CStandards%5CNftStandards%5CERC1155%5CERC1155Standard.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ERC1155Standard = void 0;
const contracts_1 = require("@ethersproject/contracts");
const controller_utils_1 = require("@metamask/controller-utils");
const metamask_eth_abis_1 = require("@metamask/metamask-eth-abis");
const assetsUtil_1 = require("../../../assetsUtil.cjs");
class ERC1155Standard {
    constructor(provider) {
        this.provider = provider;
    }
    /**
     * Query if contract implements ERC1155 URI Metadata interface.
     *
     * @param address - ERC1155 asset contract address.
     * @returns Promise resolving to whether the contract implements ERC1155 URI Metadata interface.
     */
    async contractSupportsURIMetadataInterface(address) {
        return this.contractSupportsInterface(address, controller_utils_1.ERC1155_METADATA_URI_INTERFACE_ID);
    }
    /**
     * Query if contract implements ERC1155 Token Receiver interface.
     *
     * @param address - ERC1155 asset contract address.
     * @returns Promise resolving to whether the contract implements ERC1155 Token Receiver interface.
     */
    async contractSupportsTokenReceiverInterface(address) {
        return this.contractSupportsInterface(address, controller_utils_1.ERC1155_TOKEN_RECEIVER_INTERFACE_ID);
    }
    /**
     * Query if contract implements ERC1155 interface.
     *
     * @param address - ERC1155 asset contract address.
     * @returns Promise resolving to whether the contract implements the base ERC1155 interface.
     */
    async contractSupportsBase1155Interface(address) {
        return this.contractSupportsInterface(address, controller_utils_1.ERC1155_INTERFACE_ID);
    }
    /**
     * Query for tokenURI for a given asset.
     *
     * @param address - ERC1155 asset contract address.
     * @param tokenId - ERC1155 asset identifier.
     * @returns Promise resolving to the 'tokenURI'.
     */
    async getTokenURI(address, tokenId) {
        const contract = new contracts_1.Contract(address, metamask_eth_abis_1.abiERC1155, this.provider);
        return contract.uri(tokenId);
    }
    /**
     * Query for balance of a given ERC1155 token.
     *
     * @param contractAddress - ERC1155 asset contract address.
     * @param address - Wallet public address.
     * @param tokenId - ERC1155 asset identifier.
     * @returns Promise resolving to the 'balanceOf'.
     */
    async getBalanceOf(contractAddress, address, tokenId) {
        const contract = new contracts_1.Contract(contractAddress, metamask_eth_abis_1.abiERC1155, this.provider);
        const balance = await contract.balanceOf(address, tokenId);
        return (0, assetsUtil_1.ethersBigNumberToBN)(balance);
    }
    /**
     * Transfer single ERC1155 token.
     * When minting/creating tokens, the from arg MUST be set to 0x0 (i.e. zero address).
     * When burning/destroying tokens, the to arg MUST be set to 0x0 (i.e. zero address).
     *
     * @param operator - ERC1155 token address.
     * @param from - ERC1155 token holder.
     * @param to - ERC1155 token recipient.
     * @param id - ERC1155 token id.
     * @param value - Number of tokens to be sent.
     * @returns Promise resolving to the 'transferSingle'.
     */
    async transferSingle(operator, from, to, id, value) {
        const contract = new contracts_1.Contract(operator, metamask_eth_abis_1.abiERC1155, this.provider);
        return new Promise((resolve, reject) => {
            contract.transferSingle(operator, from, to, id, value, (error, result) => {
                /* istanbul ignore if */
                if (error) {
                    reject(error);
                    return;
                }
                resolve(result);
            });
        });
    }
    /**
     * Query for symbol for a given asset.
     *
     * @param address - ERC1155 asset contract address.
     * @returns Promise resolving to the 'symbol'.
     */
    async getAssetSymbol(address) {
        const contract = new contracts_1.Contract(address, 
        // Contract ABI fragment containing only the symbol method to fetch the symbol of the contract.
        [
            {
                inputs: [],
                name: 'symbol',
                outputs: [{ name: '_symbol', type: 'string' }],
                stateMutability: 'view',
                type: 'function',
                payable: false,
            },
        ], this.provider);
        return contract.symbol();
    }
    /**
     * Query for name for a given asset.
     *
     * @param address - ERC1155 asset contract address.
     * @returns Promise resolving to the 'name'.
     */
    async getAssetName(address) {
        const contract = new contracts_1.Contract(address, 
        // Contract ABI fragment containing only the name method to fetch the name of the contract.
        [
            {
                inputs: [],
                name: 'name',
                outputs: [{ name: '_name', type: 'string' }],
                stateMutability: 'view',
                type: 'function',
                payable: false,
            },
        ], this.provider);
        return contract.name();
    }
    /**
     * Query if a contract implements an interface.
     *
     * @param address - ERC1155 asset contract address.
     * @param interfaceId - Interface identifier.
     * @returns Promise resolving to whether the contract implements `interfaceID`.
     */
    async contractSupportsInterface(address, interfaceId) {
        const contract = new contracts_1.Contract(address, metamask_eth_abis_1.abiERC1155, this.provider);
        return contract.supportsInterface(interfaceId);
    }
    /**
     * Query if a contract implements an interface.
     *
     * @param address - Asset contract address.
     * @param ipfsGateway - The user's preferred IPFS gateway.
     * @param tokenId - tokenId of a given token in the contract.
     * @returns Promise resolving an object containing the standard, tokenURI, symbol and name of the given contract/tokenId pair.
     */
    async getDetails(address, ipfsGateway, tokenId) {
        const isERC1155 = await this.contractSupportsBase1155Interface(address);
        if (!isERC1155) {
            throw new Error("This isn't a valid ERC1155 contract");
        }
        let image;
        const [symbol, name, tokenURI] = await Promise.all([
            (0, controller_utils_1.safelyExecute)(() => this.getAssetSymbol(address)),
            (0, controller_utils_1.safelyExecute)(() => this.getAssetName(address)),
            tokenId
                ? (0, controller_utils_1.safelyExecute)(() => this.getTokenURI(address, tokenId).then((uri) => uri.startsWith('ipfs://')
                    ? (0, assetsUtil_1.getFormattedIpfsUrl)(ipfsGateway, uri, true)
                    : uri))
                : undefined,
        ]);
        if (tokenURI) {
            try {
                const response = await (0, controller_utils_1.timeoutFetch)(tokenURI);
                const object = await response.json();
                image = object?.image;
                if (image?.startsWith('ipfs://')) {
                    image = (0, assetsUtil_1.getFormattedIpfsUrl)(ipfsGateway, image, true);
                }
            }
            catch {
                // Catch block should be kept empty to ignore exceptions, and
                // pass as much information as possible to the return statement
            }
        }
        // TODO consider querying to the metadata to get name.
        return {
            standard: controller_utils_1.ERC1155,
            tokenURI,
            image,
            symbol,
            name,
        };
    }
}
exports.ERC1155Standard = ERC1155Standard;

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\Standards\\NftStandards\\ERC1155\\ERC1155Standard.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\Standards\\NftStandards\\ERC721\\ERC721Standard.cjs", {"../../../assetsUtil.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\assetsUtil.cjs","@ethersproject/contracts":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\contracts\\lib\\index.js","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/metamask-eth-abis":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\metamask-eth-abis\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CStandards%5CNftStandards%5CERC721%5CERC721Standard.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ERC721Standard = void 0;
const contracts_1 = require("@ethersproject/contracts");
const controller_utils_1 = require("@metamask/controller-utils");
const metamask_eth_abis_1 = require("@metamask/metamask-eth-abis");
const assetsUtil_1 = require("../../../assetsUtil.cjs");
class ERC721Standard {
    constructor(provider) {
        /**
         * Query if contract implements ERC721Metadata interface.
         *
         * @param address - ERC721 asset contract address.
         * @returns Promise resolving to whether the contract implements ERC721Metadata interface.
         */
        this.contractSupportsMetadataInterface = async (address) => {
            return this.contractSupportsInterface(address, controller_utils_1.ERC721_METADATA_INTERFACE_ID);
        };
        /**
         * Query if contract implements ERC721Enumerable interface.
         *
         * @param address - ERC721 asset contract address.
         * @returns Promise resolving to whether the contract implements ERC721Enumerable interface.
         */
        this.contractSupportsEnumerableInterface = async (address) => {
            return this.contractSupportsInterface(address, controller_utils_1.ERC721_ENUMERABLE_INTERFACE_ID);
        };
        /**
         * Query if contract implements ERC721 interface.
         *
         * @param address - ERC721 asset contract address.
         * @returns Promise resolving to whether the contract implements ERC721 interface.
         */
        this.contractSupportsBase721Interface = async (address) => {
            return this.contractSupportsInterface(address, controller_utils_1.ERC721_INTERFACE_ID);
        };
        /**
         * Enumerate assets assigned to an owner.
         *
         * @param address - ERC721 asset contract address.
         * @param selectedAddress - Current account public address.
         * @param index - An NFT counter less than `balanceOf(selectedAddress)`.
         * @returns Promise resolving to token identifier for the 'index'th asset assigned to 'selectedAddress'.
         */
        this.getNftTokenId = async (address, selectedAddress, index) => {
            const contract = new contracts_1.Contract(address, metamask_eth_abis_1.abiERC721, this.provider);
            return contract.tokenOfOwnerByIndex(selectedAddress, index);
        };
        /**
         * Query for tokenURI for a given asset.
         *
         * @param address - ERC721 asset contract address.
         * @param tokenId - ERC721 asset identifier.
         * @returns Promise resolving to the 'tokenURI'.
         */
        this.getTokenURI = async (address, tokenId) => {
            const contract = new contracts_1.Contract(address, metamask_eth_abis_1.abiERC721, this.provider);
            const supportsMetadata = await this.contractSupportsMetadataInterface(address);
            if (!supportsMetadata) {
                // Do not throw error here, supporting Metadata interface is optional even though majority of ERC721 nfts do support it.
                // This change is made because of instances of NFTs that are ERC404( mixed ERC20 / ERC721 implementation).
                // As of today, ERC404 is unofficial but some people use it, the contract does not support Metadata interface, but it has the tokenURI() fct.
                console.error('Contract does not support ERC721 metadata interface.');
            }
            return contract.tokenURI(tokenId);
        };
        /**
         * Query for name for a given asset.
         *
         * @param address - ERC721 asset contract address.
         * @returns Promise resolving to the 'name'.
         */
        this.getAssetName = async (address) => {
            const contract = new contracts_1.Contract(address, metamask_eth_abis_1.abiERC721, this.provider);
            return contract.name();
        };
        /**
         * Query for symbol for a given asset.
         *
         * @param address - ERC721 asset contract address.
         * @returns Promise resolving to the 'symbol'.
         */
        this.getAssetSymbol = async (address) => {
            const contract = new contracts_1.Contract(address, metamask_eth_abis_1.abiERC721, this.provider);
            return contract.symbol();
        };
        /**
         * Query if a contract implements an interface.
         *
         * @param address - Asset contract address.
         * @param interfaceId - Interface identifier.
         * @returns Promise resolving to whether the contract implements `interfaceID`.
         */
        this.contractSupportsInterface = async (address, interfaceId) => {
            const contract = new contracts_1.Contract(address, metamask_eth_abis_1.abiERC721, this.provider);
            try {
                return await contract.supportsInterface(interfaceId);
            }
            catch (err) {
                // Mirror previous implementation
                if (err instanceof Error &&
                    err.message.includes('call revert exception')) {
                    return false;
                }
                throw err;
            }
        };
        /**
         * Query if a contract implements an interface.
         *
         * @param address - Asset contract address.
         * @param ipfsGateway - The user's preferred IPFS gateway.
         * @param tokenId - tokenId of a given token in the contract.
         * @returns Promise resolving an object containing the standard, tokenURI, symbol and name of the given contract/tokenId pair.
         */
        this.getDetails = async (address, ipfsGateway, tokenId) => {
            const isERC721 = await this.contractSupportsBase721Interface(address);
            if (!isERC721) {
                throw new Error("This isn't a valid ERC721 contract");
            }
            const [symbol, name, tokenURI] = await Promise.all([
                (0, controller_utils_1.safelyExecute)(() => this.getAssetSymbol(address)),
                (0, controller_utils_1.safelyExecute)(() => this.getAssetName(address)),
                tokenId
                    ? (0, controller_utils_1.safelyExecute)(() => this.getTokenURI(address, tokenId).then((uri) => uri.startsWith('ipfs://')
                        ? (0, assetsUtil_1.getFormattedIpfsUrl)(ipfsGateway, uri, true)
                        : uri))
                    : undefined,
            ]);
            let image;
            if (tokenURI) {
                try {
                    const response = await (0, controller_utils_1.timeoutFetch)(tokenURI);
                    const object = await response.json();
                    image = object?.image;
                    if (image?.startsWith('ipfs://')) {
                        image = await (0, assetsUtil_1.getFormattedIpfsUrl)(ipfsGateway, image, true);
                    }
                }
                catch {
                    // ignore
                }
            }
            return {
                standard: controller_utils_1.ERC721,
                tokenURI,
                symbol,
                name,
                image,
            };
        };
        this.provider = provider;
    }
    /**
     * Query for owner for a given ERC721 asset.
     *
     * @param address - ERC721 asset contract address.
     * @param tokenId - ERC721 asset identifier.
     * @returns Promise resolving to the owner address.
     */
    async getOwnerOf(address, tokenId) {
        const contract = new contracts_1.Contract(address, metamask_eth_abis_1.abiERC721, this.provider);
        return contract.ownerOf(tokenId);
    }
}
exports.ERC721Standard = ERC721Standard;

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\Standards\\NftStandards\\ERC721\\ERC721Standard.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\TokenBalancesController.cjs", {"./AssetsContractController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\AssetsContractController.cjs","./multi-chain-accounts-service/api-balance-fetcher.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\multi-chain-accounts-service\\api-balance-fetcher.cjs","./rpc-service/rpc-balance-fetcher.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\rpc-service\\rpc-balance-fetcher.cjs","@ethersproject/providers":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\providers\\lib\\index.js","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/polling-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\polling-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","immer":"D:\\code\\v\\metamask-extension\\node_modules\\immer\\dist\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CTokenBalancesController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _TokenBalancesController_instances, _TokenBalancesController_platform, _TokenBalancesController_queryAllAccounts, _TokenBalancesController_accountsApiChainIds, _TokenBalancesController_balanceFetchers, _TokenBalancesController_allTokens, _TokenBalancesController_detectedTokens, _TokenBalancesController_allIgnoredTokens, _TokenBalancesController_defaultInterval, _TokenBalancesController_websocketActivePollingInterval, _TokenBalancesController_chainPollingConfig, _TokenBalancesController_intervalPollingTimers, _TokenBalancesController_isControllerPollingActive, _TokenBalancesController_requestedChainIds, _TokenBalancesController_statusChangeDebouncer, _TokenBalancesController_chainIdsWithTokens, _TokenBalancesController_getProvider, _TokenBalancesController_getNetworkClient, _TokenBalancesController_createAccountsApiFetcher, _TokenBalancesController_startIntervalGroupPolling, _TokenBalancesController_startPollingForInterval, _TokenBalancesController_setPollingTimer, _TokenBalancesController_isTokenTracked, _TokenBalancesController_onTokensChanged, _TokenBalancesController_onNetworkChanged, _TokenBalancesController_onAccountRemoved, _TokenBalancesController_prepareBalanceUpdates, _TokenBalancesController_onAccountActivityBalanceUpdate, _TokenBalancesController_onAccountActivityStatusChanged, _TokenBalancesController_processAccumulatedStatusChanges;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TokenBalancesController = exports.parseAssetType = exports.caipChainIdToHex = void 0;
const providers_1 = require("@ethersproject/providers");
const controller_utils_1 = require("@metamask/controller-utils");
const polling_controller_1 = require("@metamask/polling-controller");
const utils_1 = require("@metamask/utils");
const immer_1 = require("immer");
const lodash_1 = require("lodash");
const AssetsContractController_1 = require("./AssetsContractController.cjs");
const api_balance_fetcher_1 = require("./multi-chain-accounts-service/api-balance-fetcher.cjs");
const rpc_balance_fetcher_1 = require("./rpc-service/rpc-balance-fetcher.cjs");
const CONTROLLER = 'TokenBalancesController';
const DEFAULT_INTERVAL_MS = 30000; // 30 seconds
const DEFAULT_WEBSOCKET_ACTIVE_POLLING_INTERVAL_MS = 300000; // 5 minutes
const metadata = {
    tokenBalances: {
        includeInStateLogs: false,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
};
// endregion
// ────────────────────────────────────────────────────────────────────────────
// region: Helper utilities
const draft = (base, fn) => (0, immer_1.produce)(base, fn);
const ZERO_ADDRESS = '0x0000000000000000000000000000000000000000';
const checksum = (addr) => (0, controller_utils_1.toChecksumHexAddress)(addr);
/**
 * Convert CAIP chain ID or hex chain ID to hex chain ID
 * Handles both CAIP-2 format (e.g., "eip155:1") and hex format (e.g., "0x1")
 *
 * @param chainId - CAIP chain ID (e.g., "eip155:1") or hex chain ID (e.g., "0x1")
 * @returns Hex chain ID (e.g., "0x1")
 * @throws {Error} If chainId is neither a valid CAIP-2 chain ID nor a hex string
 */
const caipChainIdToHex = (chainId) => {
    if ((0, utils_1.isStrictHexString)(chainId)) {
        return chainId;
    }
    if ((0, utils_1.isCaipChainId)(chainId)) {
        return (0, controller_utils_1.toHex)((0, utils_1.parseCaipChainId)(chainId).reference);
    }
    throw new Error('caipChainIdToHex - Failed to provide CAIP-2 or Hex chainId');
};
exports.caipChainIdToHex = caipChainIdToHex;
/**
 * Extract token address from asset type
 * Returns tuple of [tokenAddress, isNativeToken] or null if invalid
 *
 * @param assetType - Asset type string (e.g., 'eip155:1/erc20:0x...' or 'eip155:1/slip44:60')
 * @returns Tuple of [tokenAddress, isNativeToken] or null if invalid
 */
const parseAssetType = (assetType) => {
    if (!(0, utils_1.isCaipAssetType)(assetType)) {
        return null;
    }
    const parsed = (0, utils_1.parseCaipAssetType)(assetType);
    // ERC20 token (e.g., "eip155:1/erc20:0x...")
    if (parsed.assetNamespace === 'erc20') {
        return [parsed.assetReference, false];
    }
    // Native token (e.g., "eip155:1/slip44:60")
    if (parsed.assetNamespace === 'slip44') {
        return [ZERO_ADDRESS, true];
    }
    return null;
};
exports.parseAssetType = parseAssetType;
// endregion
// ────────────────────────────────────────────────────────────────────────────
// region: Main controller
class TokenBalancesController extends (0, polling_controller_1.StaticIntervalPollingController)() {
    constructor({ messenger, interval = DEFAULT_INTERVAL_MS, websocketActivePollingInterval = DEFAULT_WEBSOCKET_ACTIVE_POLLING_INTERVAL_MS, chainPollingIntervals = {}, state = {}, queryMultipleAccounts = true, accountsApiChainIds = () => [], allowExternalServices = () => true, platform, }) {
        super({
            name: CONTROLLER,
            messenger,
            metadata,
            state: { tokenBalances: {}, ...state },
        });
        _TokenBalancesController_instances.add(this);
        _TokenBalancesController_platform.set(this, void 0);
        _TokenBalancesController_queryAllAccounts.set(this, void 0);
        _TokenBalancesController_accountsApiChainIds.set(this, void 0);
        _TokenBalancesController_balanceFetchers.set(this, void 0);
        _TokenBalancesController_allTokens.set(this, {});
        _TokenBalancesController_detectedTokens.set(this, {});
        _TokenBalancesController_allIgnoredTokens.set(this, {});
        /** Default polling interval for chains without specific configuration */
        _TokenBalancesController_defaultInterval.set(this, void 0);
        /** Polling interval when WebSocket is active and providing real-time updates */
        _TokenBalancesController_websocketActivePollingInterval.set(this, void 0);
        /** Per-chain polling configuration */
        _TokenBalancesController_chainPollingConfig.set(this, void 0);
        /** Active polling timers grouped by interval */
        _TokenBalancesController_intervalPollingTimers.set(this, new Map());
        /** Track if controller-level polling is active */
        _TokenBalancesController_isControllerPollingActive.set(this, false);
        /** Store original chainIds from startPolling to preserve intent */
        _TokenBalancesController_requestedChainIds.set(this, []);
        /** Debouncing for rapid status changes to prevent excessive HTTP calls */
        _TokenBalancesController_statusChangeDebouncer.set(this, {
            timer: null,
            pendingChanges: new Map(),
        });
        _TokenBalancesController_getProvider.set(this, (chainId) => {
            const { networkConfigurationsByChainId } = this.messagingSystem.call('NetworkController:getState');
            const cfg = networkConfigurationsByChainId[chainId];
            const { networkClientId } = cfg.rpcEndpoints[cfg.defaultRpcEndpointIndex];
            const client = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId);
            return new providers_1.Web3Provider(client.provider);
        });
        _TokenBalancesController_getNetworkClient.set(this, (chainId) => {
            const { networkConfigurationsByChainId } = this.messagingSystem.call('NetworkController:getState');
            const cfg = networkConfigurationsByChainId[chainId];
            const { networkClientId } = cfg.rpcEndpoints[cfg.defaultRpcEndpointIndex];
            return this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId);
        });
        /**
         * Creates an AccountsApiBalanceFetcher that only supports chains in the accountsApiChainIds array
         *
         * @returns A BalanceFetcher that wraps AccountsApiBalanceFetcher with chainId filtering
         */
        _TokenBalancesController_createAccountsApiFetcher.set(this, () => {
            const originalFetcher = new api_balance_fetcher_1.AccountsApiBalanceFetcher(__classPrivateFieldGet(this, _TokenBalancesController_platform, "f"), __classPrivateFieldGet(this, _TokenBalancesController_getProvider, "f"));
            return {
                supports: (chainId) => {
                    // Only support chains that are both:
                    // 1. In our specified accountsApiChainIds array
                    // 2. Actually supported by the AccountsApi
                    return (__classPrivateFieldGet(this, _TokenBalancesController_accountsApiChainIds, "f").call(this).includes(chainId) &&
                        originalFetcher.supports(chainId));
                },
                fetch: originalFetcher.fetch.bind(originalFetcher),
            };
        });
        _TokenBalancesController_onTokensChanged.set(this, async (state) => {
            const changed = [];
            let hasChanges = false;
            // Get chains that have existing balances
            const chainsWithBalances = new Set();
            for (const address of Object.keys(this.state.tokenBalances)) {
                const addressKey = address;
                for (const chainId of Object.keys(this.state.tokenBalances[addressKey] || {})) {
                    chainsWithBalances.add(chainId);
                }
            }
            // Only process chains that are explicitly mentioned in the incoming state change
            const incomingChainIds = new Set([
                ...Object.keys(state.allTokens),
                ...Object.keys(state.allDetectedTokens),
            ]);
            // Only proceed if there are actual changes to chains that have balances or are being added
            const relevantChainIds = Array.from(incomingChainIds).filter((chainId) => {
                const id = chainId;
                const hasTokensNow = (state.allTokens[id] && Object.keys(state.allTokens[id]).length > 0) ||
                    (state.allDetectedTokens[id] &&
                        Object.keys(state.allDetectedTokens[id]).length > 0);
                const hadTokensBefore = (__classPrivateFieldGet(this, _TokenBalancesController_allTokens, "f")[id] && Object.keys(__classPrivateFieldGet(this, _TokenBalancesController_allTokens, "f")[id]).length > 0) ||
                    (__classPrivateFieldGet(this, _TokenBalancesController_detectedTokens, "f")[id] &&
                        Object.keys(__classPrivateFieldGet(this, _TokenBalancesController_detectedTokens, "f")[id]).length > 0);
                // Check if there's an actual change in token state
                const hasTokenChange = !(0, lodash_1.isEqual)(state.allTokens[id], __classPrivateFieldGet(this, _TokenBalancesController_allTokens, "f")[id]) ||
                    !(0, lodash_1.isEqual)(state.allDetectedTokens[id], __classPrivateFieldGet(this, _TokenBalancesController_detectedTokens, "f")[id]);
                // Process chains that have actual changes OR are new chains getting tokens
                return hasTokenChange || (!hadTokensBefore && hasTokensNow);
            });
            if (relevantChainIds.length === 0) {
                // No relevant changes, just update internal state
                __classPrivateFieldSet(this, _TokenBalancesController_allTokens, state.allTokens, "f");
                __classPrivateFieldSet(this, _TokenBalancesController_detectedTokens, state.allDetectedTokens, "f");
                return;
            }
            // Handle both cleanup and updates in a single state update
            this.update((s) => {
                for (const chainId of relevantChainIds) {
                    const id = chainId;
                    const hasTokensNow = (state.allTokens[id] &&
                        Object.keys(state.allTokens[id]).length > 0) ||
                        (state.allDetectedTokens[id] &&
                            Object.keys(state.allDetectedTokens[id]).length > 0);
                    const hadTokensBefore = (__classPrivateFieldGet(this, _TokenBalancesController_allTokens, "f")[id] &&
                        Object.keys(__classPrivateFieldGet(this, _TokenBalancesController_allTokens, "f")[id]).length > 0) ||
                        (__classPrivateFieldGet(this, _TokenBalancesController_detectedTokens, "f")[id] &&
                            Object.keys(__classPrivateFieldGet(this, _TokenBalancesController_detectedTokens, "f")[id]).length > 0);
                    if (!(0, lodash_1.isEqual)(state.allTokens[id], __classPrivateFieldGet(this, _TokenBalancesController_allTokens, "f")[id]) ||
                        !(0, lodash_1.isEqual)(state.allDetectedTokens[id], __classPrivateFieldGet(this, _TokenBalancesController_detectedTokens, "f")[id])) {
                        if (hasTokensNow) {
                            // Chain still has tokens - mark for async balance update
                            changed.push(id);
                        }
                        else if (hadTokensBefore) {
                            // Chain had tokens before but doesn't now - clean up balances immediately
                            for (const address of Object.keys(s.tokenBalances)) {
                                const addressKey = address;
                                if (s.tokenBalances[addressKey]?.[id]) {
                                    s.tokenBalances[addressKey][id] = {};
                                    hasChanges = true;
                                }
                            }
                        }
                    }
                }
            });
            __classPrivateFieldSet(this, _TokenBalancesController_allTokens, state.allTokens, "f");
            __classPrivateFieldSet(this, _TokenBalancesController_detectedTokens, state.allDetectedTokens, "f");
            __classPrivateFieldSet(this, _TokenBalancesController_allIgnoredTokens, state.allIgnoredTokens, "f");
            // Only update balances for chains that still have tokens (and only if we haven't already updated state)
            if (changed.length && !hasChanges) {
                this.updateBalances({ chainIds: changed }).catch((error) => {
                    console.warn('Error updating balances after token change:', error);
                });
            }
        });
        _TokenBalancesController_onNetworkChanged.set(this, (state) => {
            // Check if any networks were removed by comparing with previous state
            const currentNetworks = new Set(Object.keys(state.networkConfigurationsByChainId));
            // Get all networks that currently have balances
            const networksWithBalances = new Set();
            for (const address of Object.keys(this.state.tokenBalances)) {
                const addressKey = address;
                for (const network of Object.keys(this.state.tokenBalances[addressKey] || {})) {
                    networksWithBalances.add(network);
                }
            }
            // Find networks that were removed
            const removedNetworks = Array.from(networksWithBalances).filter((network) => !currentNetworks.has(network));
            if (removedNetworks.length > 0) {
                this.update((s) => {
                    // Remove balances for all accounts on the deleted networks
                    for (const address of Object.keys(s.tokenBalances)) {
                        const addressKey = address;
                        for (const removedNetwork of removedNetworks) {
                            const networkKey = removedNetwork;
                            if (s.tokenBalances[addressKey]?.[networkKey]) {
                                delete s.tokenBalances[addressKey][networkKey];
                            }
                        }
                    }
                });
            }
        });
        _TokenBalancesController_onAccountRemoved.set(this, (addr) => {
            if (!(0, utils_1.isStrictHexString)(addr) || !(0, controller_utils_1.isValidHexAddress)(addr)) {
                return;
            }
            this.update((s) => {
                delete s.tokenBalances[addr];
            });
        });
        // ────────────────────────────────────────────────────────────────────────────
        // AccountActivityService event handlers
        /**
         * Handle real-time balance updates from AccountActivityService
         * Processes balance updates and updates the token balance state
         * If any balance update has an error, triggers fallback polling for the chain
         *
         * @param options0 - Balance update parameters
         * @param options0.address - Account address
         * @param options0.chain - CAIP chain identifier
         * @param options0.updates - Array of balance updates for the account
         */
        _TokenBalancesController_onAccountActivityBalanceUpdate.set(this, async ({ address, chain, updates, }) => {
            const chainId = (0, exports.caipChainIdToHex)(chain);
            const checksummedAccount = checksum(address);
            try {
                // Process all balance updates at once
                const { tokenBalances, newTokens, nativeBalanceUpdates } = __classPrivateFieldGet(this, _TokenBalancesController_instances, "m", _TokenBalancesController_prepareBalanceUpdates).call(this, updates, checksummedAccount, chainId);
                // Update state once with all token balances
                if (tokenBalances.length > 0) {
                    this.update((state) => {
                        var _a, _b;
                        // Temporary until ADR to normalize all keys - tokenBalances state requires: account in lowercase, token in checksum
                        const lowercaseAccount = checksummedAccount.toLowerCase();
                        (_a = state.tokenBalances)[lowercaseAccount] ?? (_a[lowercaseAccount] = {});
                        (_b = state.tokenBalances[lowercaseAccount])[chainId] ?? (_b[chainId] = {});
                        // Apply all token balance updates
                        for (const { tokenAddress, balance } of tokenBalances) {
                            state.tokenBalances[lowercaseAccount][chainId][tokenAddress] =
                                balance;
                        }
                    });
                }
                // Update native balances in AccountTrackerController
                if (nativeBalanceUpdates.length > 0) {
                    this.messagingSystem.call('AccountTrackerController:updateNativeBalances', nativeBalanceUpdates);
                }
                // Import any new tokens that were discovered (balance already updated from websocket)
                if (newTokens.length > 0) {
                    await this.messagingSystem.call('TokenDetectionController:addDetectedTokensViaWs', {
                        tokensSlice: newTokens,
                        chainId: chainId,
                    });
                }
            }
            catch (error) {
                console.warn(`Error updating balances from AccountActivityService for chain ${chain}, account ${address}:`, error);
                console.warn('Balance update data:', JSON.stringify(updates, null, 2));
                // On error, trigger fallback polling
                await this.updateBalances({ chainIds: [chainId] }).catch(() => {
                    // Silently handle polling errors
                });
            }
        });
        /**
         * Handle status changes from AccountActivityService
         * Uses aggressive debouncing to prevent excessive HTTP calls from rapid up/down changes
         *
         * @param options0 - Status change event data
         * @param options0.chainIds - Array of chain identifiers
         * @param options0.status - Connection status ('up' for connected, 'down' for disconnected)
         */
        _TokenBalancesController_onAccountActivityStatusChanged.set(this, ({ chainIds, status, }) => {
            // Update pending changes (latest status wins for each chain)
            for (const chainId of chainIds) {
                __classPrivateFieldGet(this, _TokenBalancesController_statusChangeDebouncer, "f").pendingChanges.set(chainId, status);
            }
            // Clear existing timer to extend debounce window
            if (__classPrivateFieldGet(this, _TokenBalancesController_statusChangeDebouncer, "f").timer) {
                clearTimeout(__classPrivateFieldGet(this, _TokenBalancesController_statusChangeDebouncer, "f").timer);
            }
            // Set new timer - only process changes after activity settles
            __classPrivateFieldGet(this, _TokenBalancesController_statusChangeDebouncer, "f").timer = setTimeout(() => {
                __classPrivateFieldGet(this, _TokenBalancesController_instances, "m", _TokenBalancesController_processAccumulatedStatusChanges).call(this);
            }, 5000); // 5-second debounce window
        });
        __classPrivateFieldSet(this, _TokenBalancesController_platform, platform ?? 'extension', "f");
        __classPrivateFieldSet(this, _TokenBalancesController_queryAllAccounts, queryMultipleAccounts, "f");
        __classPrivateFieldSet(this, _TokenBalancesController_accountsApiChainIds, accountsApiChainIds, "f");
        __classPrivateFieldSet(this, _TokenBalancesController_defaultInterval, interval, "f");
        __classPrivateFieldSet(this, _TokenBalancesController_websocketActivePollingInterval, websocketActivePollingInterval, "f");
        __classPrivateFieldSet(this, _TokenBalancesController_chainPollingConfig, { ...chainPollingIntervals }, "f");
        // Strategy order: API first, then RPC fallback
        __classPrivateFieldSet(this, _TokenBalancesController_balanceFetchers, [
            ...(accountsApiChainIds().length > 0 && allowExternalServices()
                ? [__classPrivateFieldGet(this, _TokenBalancesController_createAccountsApiFetcher, "f").call(this)]
                : []),
            new rpc_balance_fetcher_1.RpcBalanceFetcher(__classPrivateFieldGet(this, _TokenBalancesController_getProvider, "f"), __classPrivateFieldGet(this, _TokenBalancesController_getNetworkClient, "f"), () => ({
                allTokens: __classPrivateFieldGet(this, _TokenBalancesController_allTokens, "f"),
                allDetectedTokens: __classPrivateFieldGet(this, _TokenBalancesController_detectedTokens, "f"),
            })),
        ], "f");
        this.setIntervalLength(interval);
        // initial token state & subscriptions
        const { allTokens, allDetectedTokens, allIgnoredTokens } = this.messagingSystem.call('TokensController:getState');
        __classPrivateFieldSet(this, _TokenBalancesController_allTokens, allTokens, "f");
        __classPrivateFieldSet(this, _TokenBalancesController_detectedTokens, allDetectedTokens, "f");
        __classPrivateFieldSet(this, _TokenBalancesController_allIgnoredTokens, allIgnoredTokens, "f");
        this.messagingSystem.subscribe('TokensController:stateChange', (tokensState) => {
            __classPrivateFieldGet(this, _TokenBalancesController_onTokensChanged, "f").call(this, tokensState).catch((error) => {
                console.warn('Error handling token state change:', error);
            });
        });
        this.messagingSystem.subscribe('NetworkController:stateChange', __classPrivateFieldGet(this, _TokenBalancesController_onNetworkChanged, "f"));
        this.messagingSystem.subscribe('KeyringController:accountRemoved', __classPrivateFieldGet(this, _TokenBalancesController_onAccountRemoved, "f"));
        // Register action handlers for polling interval control
        this.messagingSystem.registerActionHandler(`TokenBalancesController:updateChainPollingConfigs`, this.updateChainPollingConfigs.bind(this));
        this.messagingSystem.registerActionHandler(`TokenBalancesController:getChainPollingConfig`, this.getChainPollingConfig.bind(this));
        // Subscribe to AccountActivityService balance updates for real-time updates
        this.messagingSystem.subscribe('AccountActivityService:balanceUpdated', __classPrivateFieldGet(this, _TokenBalancesController_onAccountActivityBalanceUpdate, "f").bind(this));
        // Subscribe to AccountActivityService status changes for dynamic polling management
        this.messagingSystem.subscribe('AccountActivityService:statusChanged', __classPrivateFieldGet(this, _TokenBalancesController_onAccountActivityStatusChanged, "f").bind(this));
    }
    /**
     * Override to support per-chain polling intervals by grouping chains by interval
     *
     * @param options0 - The polling options
     * @param options0.chainIds - Chain IDs to start polling for
     */
    _startPolling({ chainIds }) {
        // Store the original chainIds to preserve intent across config updates
        __classPrivateFieldSet(this, _TokenBalancesController_requestedChainIds, [...chainIds], "f");
        __classPrivateFieldSet(this, _TokenBalancesController_isControllerPollingActive, true, "f");
        __classPrivateFieldGet(this, _TokenBalancesController_instances, "m", _TokenBalancesController_startIntervalGroupPolling).call(this, chainIds, true);
    }
    /**
     * Override to handle our custom polling approach
     *
     * @param tokenSetId - The token set ID to stop polling for
     */
    _stopPollingByPollingTokenSetId(tokenSetId) {
        let parsedTokenSetId;
        let chainsToStop = [];
        try {
            parsedTokenSetId = JSON.parse(tokenSetId);
            chainsToStop = parsedTokenSetId.chainIds || [];
        }
        catch (error) {
            console.warn('Failed to parse tokenSetId, stopping all polling:', error);
            // Fallback: stop all polling if we can't parse the tokenSetId
            __classPrivateFieldSet(this, _TokenBalancesController_isControllerPollingActive, false, "f");
            __classPrivateFieldSet(this, _TokenBalancesController_requestedChainIds, [], "f");
            __classPrivateFieldGet(this, _TokenBalancesController_intervalPollingTimers, "f").forEach((timer) => clearInterval(timer));
            __classPrivateFieldGet(this, _TokenBalancesController_intervalPollingTimers, "f").clear();
            return;
        }
        // Compare with current chains - only stop if it matches our current session
        const currentChainsSet = new Set(__classPrivateFieldGet(this, _TokenBalancesController_requestedChainIds, "f"));
        const stopChainsSet = new Set(chainsToStop);
        // Check if this stop request is for our current session
        const isCurrentSession = currentChainsSet.size === stopChainsSet.size &&
            [...currentChainsSet].every((chain) => stopChainsSet.has(chain));
        if (isCurrentSession) {
            __classPrivateFieldSet(this, _TokenBalancesController_isControllerPollingActive, false, "f");
            __classPrivateFieldSet(this, _TokenBalancesController_requestedChainIds, [], "f");
            __classPrivateFieldGet(this, _TokenBalancesController_intervalPollingTimers, "f").forEach((timer) => clearInterval(timer));
            __classPrivateFieldGet(this, _TokenBalancesController_intervalPollingTimers, "f").clear();
        }
    }
    /**
     * Get polling configuration for a chain (includes default fallback)
     *
     * @param chainId - The chain ID to get config for
     * @returns The polling configuration for the chain
     */
    getChainPollingConfig(chainId) {
        return (__classPrivateFieldGet(this, _TokenBalancesController_chainPollingConfig, "f")[chainId] ?? {
            interval: __classPrivateFieldGet(this, _TokenBalancesController_defaultInterval, "f"),
        });
    }
    async _executePoll({ chainIds, queryAllAccounts = false, }) {
        // This won't be called with our custom implementation, but keep for compatibility
        await this.updateBalances({ chainIds, queryAllAccounts });
    }
    /**
     * Update multiple chain polling configurations at once
     *
     * @param configs - Object mapping chain IDs to polling configurations
     * @param options - Optional configuration for the update behavior
     * @param options.immediateUpdate - Whether to immediately fetch balances after updating configs (default: true)
     */
    updateChainPollingConfigs(configs, options = { immediateUpdate: true }) {
        Object.assign(__classPrivateFieldGet(this, _TokenBalancesController_chainPollingConfig, "f"), configs);
        // If polling is currently active, restart with new interval groupings
        if (__classPrivateFieldGet(this, _TokenBalancesController_isControllerPollingActive, "f")) {
            // Restart polling with immediate fetch by default, unless explicitly disabled
            __classPrivateFieldGet(this, _TokenBalancesController_instances, "m", _TokenBalancesController_startIntervalGroupPolling).call(this, __classPrivateFieldGet(this, _TokenBalancesController_requestedChainIds, "f"), options.immediateUpdate);
        }
    }
    async updateBalances({ chainIds, queryAllAccounts = false, } = {}) {
        const targetChains = chainIds ?? __classPrivateFieldGet(this, _TokenBalancesController_instances, "m", _TokenBalancesController_chainIdsWithTokens).call(this);
        if (!targetChains.length) {
            return;
        }
        const { address: selected } = this.messagingSystem.call('AccountsController:getSelectedAccount');
        const allAccounts = this.messagingSystem.call('AccountsController:listAccounts');
        const aggregated = [];
        let remainingChains = [...targetChains];
        // Try each fetcher in order, removing successfully processed chains
        for (const fetcher of __classPrivateFieldGet(this, _TokenBalancesController_balanceFetchers, "f")) {
            const supportedChains = remainingChains.filter((c) => fetcher.supports(c));
            if (!supportedChains.length) {
                continue;
            }
            try {
                const balances = await fetcher.fetch({
                    chainIds: supportedChains,
                    queryAllAccounts: queryAllAccounts ?? __classPrivateFieldGet(this, _TokenBalancesController_queryAllAccounts, "f"),
                    selectedAccount: selected,
                    allAccounts,
                });
                if (balances && balances.length > 0) {
                    aggregated.push(...balances);
                    // Remove chains that were successfully processed
                    const processedChains = new Set(balances.map((b) => b.chainId));
                    remainingChains = remainingChains.filter((chain) => !processedChains.has(chain));
                }
            }
            catch (error) {
                console.warn(`Balance fetcher failed for chains ${supportedChains.join(', ')}: ${String(error)}`);
                // Continue to next fetcher (fallback)
            }
            // If all chains have been processed, break early
            if (remainingChains.length === 0) {
                break;
            }
        }
        // Determine which accounts to process based on queryAllAccounts parameter
        const accountsToProcess = (queryAllAccounts ?? __classPrivateFieldGet(this, _TokenBalancesController_queryAllAccounts, "f"))
            ? allAccounts.map((a) => a.address)
            : [selected];
        const prev = this.state;
        const next = draft(prev, (d) => {
            var _a, _b;
            // Initialize account and chain structures if they don't exist, but preserve existing balances
            for (const chainId of targetChains) {
                for (const account of accountsToProcess) {
                    // Ensure the nested structure exists without overwriting existing balances
                    (_a = d.tokenBalances)[account] ?? (_a[account] = {});
                    (_b = d.tokenBalances[account])[chainId] ?? (_b[chainId] = {});
                    // Initialize tokens from allTokens only if they don't exist yet
                    const chainTokens = __classPrivateFieldGet(this, _TokenBalancesController_allTokens, "f")[chainId];
                    if (chainTokens?.[account]) {
                        Object.values(chainTokens[account]).forEach((token) => {
                            const tokenAddress = checksum(token.address);
                            // Only initialize if the token balance doesn't exist yet
                            if (!(tokenAddress in d.tokenBalances[account][chainId])) {
                                d.tokenBalances[account][chainId][tokenAddress] = '0x0';
                            }
                        });
                    }
                    // Initialize tokens from allDetectedTokens only if they don't exist yet
                    const detectedChainTokens = __classPrivateFieldGet(this, _TokenBalancesController_detectedTokens, "f")[chainId];
                    if (detectedChainTokens?.[account]) {
                        Object.values(detectedChainTokens[account]).forEach((token) => {
                            const tokenAddress = checksum(token.address);
                            // Only initialize if the token balance doesn't exist yet
                            if (!(tokenAddress in d.tokenBalances[account][chainId])) {
                                d.tokenBalances[account][chainId][tokenAddress] = '0x0';
                            }
                        });
                    }
                }
            }
            // Update with actual fetched balances only if the value has changed
            aggregated.forEach(({ success, value, account, token, chainId }) => {
                var _a, _b, _c;
                if (success && value !== undefined) {
                    const newBalance = (0, controller_utils_1.toHex)(value);
                    const tokenAddress = checksum(token);
                    const currentBalance = d.tokenBalances[account]?.[chainId]?.[tokenAddress];
                    // Only update if the balance has actually changed
                    if (currentBalance !== newBalance) {
                        ((_c = ((_a = d.tokenBalances)[_b = account] ?? (_a[_b] = {})))[chainId] ?? (_c[chainId] = {}))[tokenAddress] = newBalance;
                    }
                }
            });
        });
        if (!(0, lodash_1.isEqual)(prev, next)) {
            this.update(() => next);
            const nativeBalances = aggregated.filter((r) => r.success && r.token === ZERO_ADDRESS);
            // Get current AccountTracker state to compare existing balances
            const accountTrackerState = this.messagingSystem.call('AccountTrackerController:getState');
            // Update native token balances only if they have changed
            if (nativeBalances.length > 0) {
                const balanceUpdates = nativeBalances
                    .map((balance) => ({
                    address: balance.account,
                    chainId: balance.chainId,
                    balance: balance.value ? (0, controller_utils_1.BNToHex)(balance.value) : '0x0',
                }))
                    .filter((update) => {
                    const currentBalance = accountTrackerState.accountsByChainId[update.chainId]?.[checksum(update.address)]?.balance;
                    // Only include if the balance has actually changed
                    return currentBalance !== update.balance;
                });
                if (balanceUpdates.length > 0) {
                    this.messagingSystem.call('AccountTrackerController:updateNativeBalances', balanceUpdates);
                }
            }
            // Filter and update staked balances in a single batch operation for better performance
            const stakedBalances = aggregated.filter((r) => {
                if (!r.success || r.token === ZERO_ADDRESS) {
                    return false;
                }
                // Check if the chainId and token address match any staking contract
                const stakingContractAddress = AssetsContractController_1.STAKING_CONTRACT_ADDRESS_BY_CHAINID[r.chainId];
                return (stakingContractAddress &&
                    stakingContractAddress.toLowerCase() === r.token.toLowerCase());
            });
            if (stakedBalances.length > 0) {
                const stakedBalanceUpdates = stakedBalances
                    .map((balance) => ({
                    address: balance.account,
                    chainId: balance.chainId,
                    stakedBalance: balance.value ? (0, controller_utils_1.toHex)(balance.value) : '0x0',
                }))
                    .filter((update) => {
                    const currentStakedBalance = accountTrackerState.accountsByChainId[update.chainId]?.[checksum(update.address)]?.stakedBalance;
                    // Only include if the staked balance has actually changed
                    return currentStakedBalance !== update.stakedBalance;
                });
                if (stakedBalanceUpdates.length > 0) {
                    this.messagingSystem.call('AccountTrackerController:updateStakedBalances', stakedBalanceUpdates);
                }
            }
        }
    }
    resetState() {
        this.update(() => ({ tokenBalances: {} }));
    }
    /**
     * Clean up all timers and resources when controller is destroyed
     */
    destroy() {
        __classPrivateFieldSet(this, _TokenBalancesController_isControllerPollingActive, false, "f");
        __classPrivateFieldGet(this, _TokenBalancesController_intervalPollingTimers, "f").forEach((timer) => clearInterval(timer));
        __classPrivateFieldGet(this, _TokenBalancesController_intervalPollingTimers, "f").clear();
        // Clean up debouncing timer
        if (__classPrivateFieldGet(this, _TokenBalancesController_statusChangeDebouncer, "f").timer) {
            clearTimeout(__classPrivateFieldGet(this, _TokenBalancesController_statusChangeDebouncer, "f").timer);
            __classPrivateFieldGet(this, _TokenBalancesController_statusChangeDebouncer, "f").timer = null;
        }
        // Unregister action handlers
        this.messagingSystem.unregisterActionHandler(`TokenBalancesController:updateChainPollingConfigs`);
        this.messagingSystem.unregisterActionHandler(`TokenBalancesController:getChainPollingConfig`);
        super.destroy();
    }
}
exports.TokenBalancesController = TokenBalancesController;
_TokenBalancesController_platform = new WeakMap(), _TokenBalancesController_queryAllAccounts = new WeakMap(), _TokenBalancesController_accountsApiChainIds = new WeakMap(), _TokenBalancesController_balanceFetchers = new WeakMap(), _TokenBalancesController_allTokens = new WeakMap(), _TokenBalancesController_detectedTokens = new WeakMap(), _TokenBalancesController_allIgnoredTokens = new WeakMap(), _TokenBalancesController_defaultInterval = new WeakMap(), _TokenBalancesController_websocketActivePollingInterval = new WeakMap(), _TokenBalancesController_chainPollingConfig = new WeakMap(), _TokenBalancesController_intervalPollingTimers = new WeakMap(), _TokenBalancesController_isControllerPollingActive = new WeakMap(), _TokenBalancesController_requestedChainIds = new WeakMap(), _TokenBalancesController_statusChangeDebouncer = new WeakMap(), _TokenBalancesController_getProvider = new WeakMap(), _TokenBalancesController_getNetworkClient = new WeakMap(), _TokenBalancesController_createAccountsApiFetcher = new WeakMap(), _TokenBalancesController_onTokensChanged = new WeakMap(), _TokenBalancesController_onNetworkChanged = new WeakMap(), _TokenBalancesController_onAccountRemoved = new WeakMap(), _TokenBalancesController_onAccountActivityBalanceUpdate = new WeakMap(), _TokenBalancesController_onAccountActivityStatusChanged = new WeakMap(), _TokenBalancesController_instances = new WeakSet(), _TokenBalancesController_chainIdsWithTokens = function _TokenBalancesController_chainIdsWithTokens() {
    return [
        ...new Set([
            ...Object.keys(__classPrivateFieldGet(this, _TokenBalancesController_allTokens, "f")),
            ...Object.keys(__classPrivateFieldGet(this, _TokenBalancesController_detectedTokens, "f")),
        ]),
    ];
}, _TokenBalancesController_startIntervalGroupPolling = function _TokenBalancesController_startIntervalGroupPolling(chainIds, immediate = true) {
    // Stop any existing interval timers
    __classPrivateFieldGet(this, _TokenBalancesController_intervalPollingTimers, "f").forEach((timer) => clearInterval(timer));
    __classPrivateFieldGet(this, _TokenBalancesController_intervalPollingTimers, "f").clear();
    // Group chains by their polling intervals
    const intervalGroups = new Map();
    for (const chainId of chainIds) {
        const config = this.getChainPollingConfig(chainId);
        const existing = intervalGroups.get(config.interval) || [];
        existing.push(chainId);
        intervalGroups.set(config.interval, existing);
    }
    // Start separate polling loop for each interval group
    for (const [interval, chainIdsGroup] of intervalGroups) {
        __classPrivateFieldGet(this, _TokenBalancesController_instances, "m", _TokenBalancesController_startPollingForInterval).call(this, interval, chainIdsGroup, immediate);
    }
}, _TokenBalancesController_startPollingForInterval = function _TokenBalancesController_startPollingForInterval(interval, chainIds, immediate = true) {
    const pollFunction = async () => {
        if (!__classPrivateFieldGet(this, _TokenBalancesController_isControllerPollingActive, "f")) {
            return;
        }
        try {
            await this._executePoll({ chainIds });
        }
        catch (error) {
            console.warn(`Polling failed for chains ${chainIds.join(', ')} with interval ${interval}:`, error);
        }
    };
    // Poll immediately first if requested
    if (immediate) {
        pollFunction().catch((error) => {
            console.warn(`Immediate polling failed for chains ${chainIds.join(', ')}:`, error);
        });
    }
    // Then start regular interval polling
    __classPrivateFieldGet(this, _TokenBalancesController_instances, "m", _TokenBalancesController_setPollingTimer).call(this, interval, chainIds, pollFunction);
}, _TokenBalancesController_setPollingTimer = function _TokenBalancesController_setPollingTimer(interval, chainIds, pollFunction) {
    // Clear any existing timer for this interval first
    const existingTimer = __classPrivateFieldGet(this, _TokenBalancesController_intervalPollingTimers, "f").get(interval);
    if (existingTimer) {
        clearInterval(existingTimer);
    }
    const timer = setInterval(() => {
        pollFunction().catch((error) => {
            console.warn(`Interval polling failed for chains ${chainIds.join(', ')}:`, error);
        });
    }, interval);
    __classPrivateFieldGet(this, _TokenBalancesController_intervalPollingTimers, "f").set(interval, timer);
}, _TokenBalancesController_isTokenTracked = function _TokenBalancesController_isTokenTracked(tokenAddress, account, chainId) {
    // Check if token exists in allTokens
    if (__classPrivateFieldGet(this, _TokenBalancesController_allTokens, "f")?.[chainId]?.[account.toLowerCase()]?.some((token) => token.address === tokenAddress)) {
        return true;
    }
    // Check if token exists in allIgnoredTokens
    if (__classPrivateFieldGet(this, _TokenBalancesController_allIgnoredTokens, "f")?.[chainId]?.[account.toLowerCase()]?.some((token) => token === tokenAddress)) {
        return true;
    }
    return false;
}, _TokenBalancesController_prepareBalanceUpdates = function _TokenBalancesController_prepareBalanceUpdates(updates, account, chainId) {
    const tokenBalances = [];
    const newTokens = [];
    const nativeBalanceUpdates = [];
    for (const update of updates) {
        const { asset, postBalance } = update;
        // Throw if balance update has an error
        if (postBalance.error) {
            throw new Error('Balance update has error');
        }
        // Parse token address from asset type
        const parsed = (0, exports.parseAssetType)(asset.type);
        if (!parsed) {
            throw new Error('Failed to parse asset type');
        }
        const [tokenAddress, isNativeToken] = parsed;
        // Validate token address
        if (!(0, utils_1.isStrictHexString)(tokenAddress) ||
            !(0, controller_utils_1.isValidHexAddress)(tokenAddress)) {
            throw new Error('Invalid token address');
        }
        const checksumTokenAddress = checksum(tokenAddress);
        const isTracked = __classPrivateFieldGet(this, _TokenBalancesController_instances, "m", _TokenBalancesController_isTokenTracked).call(this, checksumTokenAddress, account, chainId);
        // postBalance.amount is in hex format (raw units)
        const balanceHex = postBalance.amount;
        // Add token balance (tracked tokens, ignored tokens, and native tokens all get balance updates)
        tokenBalances.push({
            tokenAddress: checksumTokenAddress,
            balance: balanceHex,
        });
        // Add native balance update if this is a native token
        if (isNativeToken) {
            nativeBalanceUpdates.push({
                address: account,
                chainId,
                balance: balanceHex,
            });
        }
        // Handle untracked ERC20 tokens - queue for import
        if (!isNativeToken && !isTracked) {
            newTokens.push(checksumTokenAddress);
        }
    }
    return { tokenBalances, newTokens, nativeBalanceUpdates };
}, _TokenBalancesController_processAccumulatedStatusChanges = function _TokenBalancesController_processAccumulatedStatusChanges() {
    const changes = Array.from(__classPrivateFieldGet(this, _TokenBalancesController_statusChangeDebouncer, "f").pendingChanges.entries());
    __classPrivateFieldGet(this, _TokenBalancesController_statusChangeDebouncer, "f").pendingChanges.clear();
    __classPrivateFieldGet(this, _TokenBalancesController_statusChangeDebouncer, "f").timer = null;
    if (changes.length === 0) {
        return;
    }
    // Calculate final polling configurations
    const chainConfigs = {};
    for (const [chainId, status] of changes) {
        // Convert CAIP format (eip155:1) to hex format (0x1)
        // chainId is always in CAIP format from AccountActivityService
        const hexChainId = (0, exports.caipChainIdToHex)(chainId);
        if (status === 'down') {
            // Chain is down - use default polling since no real-time updates available
            chainConfigs[hexChainId] = { interval: __classPrivateFieldGet(this, _TokenBalancesController_defaultInterval, "f") };
        }
        else {
            // Chain is up - use longer intervals since WebSocket provides real-time updates
            chainConfigs[hexChainId] = {
                interval: __classPrivateFieldGet(this, _TokenBalancesController_websocketActivePollingInterval, "f"),
            };
        }
    }
    // Add jitter to prevent synchronized requests across instances
    const jitterDelay = Math.random() * __classPrivateFieldGet(this, _TokenBalancesController_defaultInterval, "f"); // 0 to default interval
    setTimeout(() => {
        this.updateChainPollingConfigs(chainConfigs, { immediateUpdate: true });
    }, jitterDelay);
};
exports.default = TokenBalancesController;

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\TokenBalancesController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\TokenDetectionController.cjs", {"./assetsUtil.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\assetsUtil.cjs","./multi-chain-accounts-service/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\multi-chain-accounts-service\\index.cjs","@metamask/contract-metadata":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\contract-metadata\\index.js","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/polling-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\polling-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CTokenDetectionController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _TokenDetectionController_instances, _TokenDetectionController_intervalId, _TokenDetectionController_selectedAccountId, _TokenDetectionController_tokensChainsCache, _TokenDetectionController_disabled, _TokenDetectionController_isUnlocked, _TokenDetectionController_isDetectionEnabledFromPreferences, _TokenDetectionController_useTokenDetection, _TokenDetectionController_useExternalServices, _TokenDetectionController_getBalancesInSingleCall, _TokenDetectionController_trackMetaMetricsEvent, _TokenDetectionController_accountsAPI, _TokenDetectionController_registerEventListeners, _TokenDetectionController_stopPolling, _TokenDetectionController_startPolling, _TokenDetectionController_compareTokensChainsCache, _TokenDetectionController_getCorrectNetworkClientIdByChainId, _TokenDetectionController_restartTokenDetection, _TokenDetectionController_getChainsToDetect, _TokenDetectionController_attemptAccountAPIDetection, _TokenDetectionController_addChainsToRpcDetection, _TokenDetectionController_shouldDetectTokens, _TokenDetectionController_detectTokensUsingRpc, _TokenDetectionController_getSlicesOfTokensToDetect, _TokenDetectionController_getConvertedStaticMainnetTokenList, _TokenDetectionController_addDetectedTokensViaAPI, _TokenDetectionController_filterAndBuildTokensWithBalance, _TokenDetectionController_addDetectedTokens, _TokenDetectionController_getSelectedAccount, _TokenDetectionController_getSelectedAddress;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TokenDetectionController = exports.controllerName = exports.mapChainIdWithTokenListMap = exports.STATIC_MAINNET_TOKEN_LIST = void 0;
const contract_metadata_1 = __importDefault(require("@metamask/contract-metadata"));
const controller_utils_1 = require("@metamask/controller-utils");
const polling_controller_1 = require("@metamask/polling-controller");
const utils_1 = require("@metamask/utils");
const lodash_1 = require("lodash");
const assetsUtil_1 = require("./assetsUtil.cjs");
const multi_chain_accounts_service_1 = require("./multi-chain-accounts-service/index.cjs");
const DEFAULT_INTERVAL = 180000;
exports.STATIC_MAINNET_TOKEN_LIST = Object.entries(contract_metadata_1.default).reduce((acc, [base, contract]) => {
    const { logo, erc20, erc721, ...tokenMetadata } = contract;
    return {
        ...acc,
        [base.toLowerCase()]: {
            ...tokenMetadata,
            address: base.toLowerCase(),
            iconUrl: `images/contract/${logo}`,
            aggregators: [],
        },
    };
}, {});
/**
 * Function that takes a TokensChainsCache object and maps chainId with TokenListMap.
 *
 * @param tokensChainsCache - TokensChainsCache input object
 * @returns returns the map of chainId with TokenListMap
 */
function mapChainIdWithTokenListMap(tokensChainsCache) {
    return (0, lodash_1.mapValues)(tokensChainsCache, (value) => {
        if ((0, lodash_1.isObject)(value) && 'data' in value) {
            return (0, lodash_1.get)(value, ['data']);
        }
        return value;
    });
}
exports.mapChainIdWithTokenListMap = mapChainIdWithTokenListMap;
exports.controllerName = 'TokenDetectionController';
/**
 * Controller that passively polls on a set interval for Tokens auto detection
 *
 * intervalId - Polling interval used to fetch new token rates
 *
 * selectedAddress - Vault selected address
 *
 * networkClientId - The network client ID of the current selected network
 *
 * disabled - Boolean to track if network requests are blocked
 *
 * isUnlocked - Boolean to track if the keyring state is unlocked
 *
 * isDetectionEnabledFromPreferences - Boolean to track if detection is enabled from PreferencesController
 *
 */
class TokenDetectionController extends (0, polling_controller_1.StaticIntervalPollingController)() {
    /**
     * Creates a TokenDetectionController instance.
     *
     * @param options - The controller options.
     * @param options.messenger - The controller messaging system.
     * @param options.disabled - If set to true, all network requests are blocked.
     * @param options.interval - Polling interval used to fetch new token rates
     * @param options.getBalancesInSingleCall - Gets the balances of a list of tokens for the given address.
     * @param options.trackMetaMetricsEvent - Sets options for MetaMetrics event tracking.
     * @param options.useAccountsAPI - Feature Switch for using the accounts API when detecting tokens (default: true)
     * @param options.useTokenDetection - Feature Switch for using token detection (default: true)
     * @param options.useExternalServices - Feature Switch for using external services (default: false)
     * @param options.platform - Indicates whether the platform is extension or mobile
     */
    constructor({ interval = DEFAULT_INTERVAL, disabled = true, getBalancesInSingleCall, trackMetaMetricsEvent, messenger, useAccountsAPI = true, useTokenDetection = () => true, useExternalServices = () => true, platform, }) {
        super({
            name: exports.controllerName,
            messenger,
            state: {},
            metadata: {},
        });
        _TokenDetectionController_instances.add(this);
        _TokenDetectionController_intervalId.set(this, void 0);
        _TokenDetectionController_selectedAccountId.set(this, void 0);
        _TokenDetectionController_tokensChainsCache.set(this, {});
        _TokenDetectionController_disabled.set(this, void 0);
        _TokenDetectionController_isUnlocked.set(this, void 0);
        _TokenDetectionController_isDetectionEnabledFromPreferences.set(this, void 0);
        _TokenDetectionController_useTokenDetection.set(this, void 0);
        _TokenDetectionController_useExternalServices.set(this, void 0);
        _TokenDetectionController_getBalancesInSingleCall.set(this, void 0);
        _TokenDetectionController_trackMetaMetricsEvent.set(this, void 0);
        _TokenDetectionController_accountsAPI.set(this, {
            isAccountsAPIEnabled: true,
            supportedNetworksCache: null,
            platform: '',
            async getSupportedNetworks() {
                /* istanbul ignore next */
                if (!this.isAccountsAPIEnabled) {
                    throw new Error('Accounts API Feature Switch is disabled');
                }
                /* istanbul ignore next */
                if (this.supportedNetworksCache) {
                    return this.supportedNetworksCache;
                }
                const result = await (0, multi_chain_accounts_service_1.fetchSupportedNetworks)().catch(() => null);
                this.supportedNetworksCache = result;
                return result;
            },
            async getMultiNetworksBalances(address, chainIds, supportedNetworks) {
                const chainIdNumbers = chainIds.map((chainId) => (0, utils_1.hexToNumber)(chainId));
                if (!supportedNetworks ||
                    !chainIdNumbers.every((id) => supportedNetworks.includes(id))) {
                    const supportedNetworksErrStr = (supportedNetworks ?? []).toString();
                    throw new Error(`Unsupported Network: supported networks ${supportedNetworksErrStr}, requested networks: ${chainIdNumbers.toString()}`);
                }
                const result = await (0, multi_chain_accounts_service_1.fetchMultiChainBalances)(address, {
                    networks: chainIdNumbers,
                }, this.platform);
                return result.balances;
            },
        });
        this.messagingSystem.registerActionHandler(`${exports.controllerName}:addDetectedTokensViaWs`, this.addDetectedTokensViaWs.bind(this));
        __classPrivateFieldSet(this, _TokenDetectionController_disabled, disabled, "f");
        this.setIntervalLength(interval);
        __classPrivateFieldSet(this, _TokenDetectionController_selectedAccountId, __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_getSelectedAccount).call(this).id, "f");
        const { tokensChainsCache } = this.messagingSystem.call('TokenListController:getState');
        __classPrivateFieldSet(this, _TokenDetectionController_tokensChainsCache, tokensChainsCache, "f");
        const { useTokenDetection: defaultUseTokenDetection } = this.messagingSystem.call('PreferencesController:getState');
        __classPrivateFieldSet(this, _TokenDetectionController_isDetectionEnabledFromPreferences, defaultUseTokenDetection, "f");
        __classPrivateFieldSet(this, _TokenDetectionController_getBalancesInSingleCall, getBalancesInSingleCall, "f");
        __classPrivateFieldSet(this, _TokenDetectionController_trackMetaMetricsEvent, trackMetaMetricsEvent, "f");
        const { isUnlocked } = this.messagingSystem.call('KeyringController:getState');
        __classPrivateFieldSet(this, _TokenDetectionController_isUnlocked, isUnlocked, "f");
        __classPrivateFieldGet(this, _TokenDetectionController_accountsAPI, "f").isAccountsAPIEnabled = useAccountsAPI;
        __classPrivateFieldSet(this, _TokenDetectionController_useTokenDetection, useTokenDetection, "f");
        __classPrivateFieldSet(this, _TokenDetectionController_useExternalServices, useExternalServices, "f");
        __classPrivateFieldGet(this, _TokenDetectionController_accountsAPI, "f").platform = platform;
        __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_registerEventListeners).call(this);
    }
    /**
     * Allows controller to make active and passive polling requests
     */
    enable() {
        __classPrivateFieldSet(this, _TokenDetectionController_disabled, false, "f");
    }
    /**
     * Blocks controller from making network calls
     */
    disable() {
        __classPrivateFieldSet(this, _TokenDetectionController_disabled, true, "f");
    }
    /**
     * Internal isActive state
     *
     * @returns Whether the controller is active (not disabled and keyring is unlocked)
     */
    get isActive() {
        return !__classPrivateFieldGet(this, _TokenDetectionController_disabled, "f") && __classPrivateFieldGet(this, _TokenDetectionController_isUnlocked, "f");
    }
    /**
     * Start polling for detected tokens.
     */
    async start() {
        this.enable();
        await __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_startPolling).call(this);
    }
    /**
     * Stop polling for detected tokens.
     */
    stop() {
        this.disable();
        __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_stopPolling).call(this);
    }
    async _executePoll({ chainIds, address, }) {
        if (!this.isActive) {
            return;
        }
        await this.detectTokens({
            chainIds,
            selectedAddress: address,
        });
    }
    /**
     * For each token in the token list provided by the TokenListController, checks the token's balance for the selected account address on the active network.
     * On mainnet, if token detection is disabled in preferences, ERC20 token auto detection will be triggered for each contract address in the legacy token list from the @metamask/contract-metadata repo.
     *
     * @param options - Options for token detection.
     * @param options.chainIds - The chain IDs of the network client to use.
     * @param options.selectedAddress - the selectedAddress against which to detect for token balances.
     */
    async detectTokens({ chainIds, selectedAddress, } = {}) {
        if (!this.isActive) {
            return;
        }
        if (!__classPrivateFieldGet(this, _TokenDetectionController_useTokenDetection, "f").call(this)) {
            return;
        }
        const addressToDetect = selectedAddress ?? __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_getSelectedAddress).call(this);
        const clientNetworks = __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_getCorrectNetworkClientIdByChainId).call(this, chainIds);
        let supportedNetworks;
        if (__classPrivateFieldGet(this, _TokenDetectionController_accountsAPI, "f").isAccountsAPIEnabled && __classPrivateFieldGet(this, _TokenDetectionController_useExternalServices, "f").call(this)) {
            supportedNetworks = await __classPrivateFieldGet(this, _TokenDetectionController_accountsAPI, "f").getSupportedNetworks();
        }
        const { chainsToDetectUsingRpc, chainsToDetectUsingAccountAPI } = __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_getChainsToDetect).call(this, clientNetworks, supportedNetworks);
        // Try detecting tokens via Account API first if conditions allow
        if (supportedNetworks && chainsToDetectUsingAccountAPI.length > 0) {
            const apiResult = await __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_attemptAccountAPIDetection).call(this, chainsToDetectUsingAccountAPI, addressToDetect, supportedNetworks);
            // If the account API call failed, have those chains fall back to RPC detection
            if (apiResult?.result === 'failed') {
                __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_addChainsToRpcDetection).call(this, chainsToDetectUsingRpc, chainsToDetectUsingAccountAPI, clientNetworks);
            }
        }
        // Proceed with RPC detection if there are chains remaining in chainsToDetectUsingRpc
        if (chainsToDetectUsingRpc.length > 0) {
            await __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_detectTokensUsingRpc).call(this, chainsToDetectUsingRpc, addressToDetect);
        }
    }
    /**
     * Add tokens detected from websocket balance updates
     * This method assumes:
     * - Tokens are already in the tokensChainsCache with full metadata
     * - Balance fetching is skipped since balances are provided by the websocket
     * - Ignored tokens have been filtered out by the caller
     *
     * @param options - The options object
     * @param options.tokensSlice - Array of token addresses detected from websocket (already filtered to exclude ignored tokens)
     * @param options.chainId - Hex chain ID
     * @returns Promise that resolves when tokens are added
     */
    async addDetectedTokensViaWs({ tokensSlice, chainId, }) {
        const tokensWithBalance = [];
        const eventTokensDetails = [];
        for (const tokenAddress of tokensSlice) {
            // Normalize addresses explicitly (don't assume input format)
            const lowercaseTokenAddress = tokenAddress.toLowerCase();
            const checksummedTokenAddress = (0, controller_utils_1.toChecksumHexAddress)(tokenAddress);
            // Check map of validated tokens (cache keys are lowercase)
            const tokenData = __classPrivateFieldGet(this, _TokenDetectionController_tokensChainsCache, "f")[chainId]?.data?.[lowercaseTokenAddress];
            if (!tokenData) {
                console.warn(`Token metadata not found in cache for ${tokenAddress} on chain ${chainId}`);
                continue;
            }
            const { decimals, symbol, aggregators, iconUrl, name } = tokenData;
            // Push to lists with checksummed address (for allTokens storage)
            eventTokensDetails.push(`${symbol} - ${checksummedTokenAddress}`);
            tokensWithBalance.push({
                address: checksummedTokenAddress,
                decimals,
                symbol,
                aggregators,
                image: iconUrl,
                isERC721: false,
                name,
            });
        }
        // Perform addition
        if (tokensWithBalance.length) {
            __classPrivateFieldGet(this, _TokenDetectionController_trackMetaMetricsEvent, "f").call(this, {
                event: 'Token Detected',
                category: 'Wallet',
                properties: {
                    tokens: eventTokensDetails,
                    token_standard: controller_utils_1.ERC20,
                    asset_type: controller_utils_1.ASSET_TYPES.TOKEN,
                },
            });
            const networkClientId = this.messagingSystem.call('NetworkController:findNetworkClientIdByChainId', chainId);
            await this.messagingSystem.call('TokensController:addTokens', tokensWithBalance, networkClientId);
        }
    }
}
exports.TokenDetectionController = TokenDetectionController;
_TokenDetectionController_intervalId = new WeakMap(), _TokenDetectionController_selectedAccountId = new WeakMap(), _TokenDetectionController_tokensChainsCache = new WeakMap(), _TokenDetectionController_disabled = new WeakMap(), _TokenDetectionController_isUnlocked = new WeakMap(), _TokenDetectionController_isDetectionEnabledFromPreferences = new WeakMap(), _TokenDetectionController_useTokenDetection = new WeakMap(), _TokenDetectionController_useExternalServices = new WeakMap(), _TokenDetectionController_getBalancesInSingleCall = new WeakMap(), _TokenDetectionController_trackMetaMetricsEvent = new WeakMap(), _TokenDetectionController_accountsAPI = new WeakMap(), _TokenDetectionController_instances = new WeakSet(), _TokenDetectionController_registerEventListeners = function _TokenDetectionController_registerEventListeners() {
    this.messagingSystem.subscribe('KeyringController:unlock', async () => {
        __classPrivateFieldSet(this, _TokenDetectionController_isUnlocked, true, "f");
        await __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_restartTokenDetection).call(this);
    });
    this.messagingSystem.subscribe('KeyringController:lock', () => {
        __classPrivateFieldSet(this, _TokenDetectionController_isUnlocked, false, "f");
        __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_stopPolling).call(this);
    });
    this.messagingSystem.subscribe('TokenListController:stateChange', async ({ tokensChainsCache }) => {
        const isEqualValues = __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_compareTokensChainsCache).call(this, tokensChainsCache, __classPrivateFieldGet(this, _TokenDetectionController_tokensChainsCache, "f"));
        if (!isEqualValues) {
            await __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_restartTokenDetection).call(this);
        }
    });
    this.messagingSystem.subscribe('PreferencesController:stateChange', async ({ useTokenDetection }) => {
        const selectedAccount = __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_getSelectedAccount).call(this);
        const isDetectionChangedFromPreferences = __classPrivateFieldGet(this, _TokenDetectionController_isDetectionEnabledFromPreferences, "f") !== useTokenDetection;
        __classPrivateFieldSet(this, _TokenDetectionController_isDetectionEnabledFromPreferences, useTokenDetection, "f");
        if (isDetectionChangedFromPreferences) {
            await __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_restartTokenDetection).call(this, {
                selectedAddress: selectedAccount.address,
            });
        }
    });
    this.messagingSystem.subscribe('AccountsController:selectedEvmAccountChange', async (selectedAccount) => {
        const { networkConfigurationsByChainId } = this.messagingSystem.call('NetworkController:getState');
        const chainIds = Object.keys(networkConfigurationsByChainId);
        const isSelectedAccountIdChanged = __classPrivateFieldGet(this, _TokenDetectionController_selectedAccountId, "f") !== selectedAccount.id;
        if (isSelectedAccountIdChanged) {
            __classPrivateFieldSet(this, _TokenDetectionController_selectedAccountId, selectedAccount.id, "f");
            await __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_restartTokenDetection).call(this, {
                selectedAddress: selectedAccount.address,
                chainIds,
            });
        }
    });
    this.messagingSystem.subscribe('TransactionController:transactionConfirmed', async (transactionMeta) => {
        await this.detectTokens({
            chainIds: [transactionMeta.chainId],
        });
    });
}, _TokenDetectionController_stopPolling = function _TokenDetectionController_stopPolling() {
    if (__classPrivateFieldGet(this, _TokenDetectionController_intervalId, "f")) {
        clearInterval(__classPrivateFieldGet(this, _TokenDetectionController_intervalId, "f"));
    }
}, _TokenDetectionController_startPolling = 
/**
 * Starts a new polling interval.
 */
async function _TokenDetectionController_startPolling() {
    if (!this.isActive) {
        return;
    }
    __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_stopPolling).call(this);
    await this.detectTokens();
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    __classPrivateFieldSet(this, _TokenDetectionController_intervalId, setInterval(async () => {
        await this.detectTokens();
    }, this.getIntervalLength()), "f");
}, _TokenDetectionController_compareTokensChainsCache = function _TokenDetectionController_compareTokensChainsCache(tokensChainsCache, previousTokensChainsCache) {
    const cleanPreviousTokensChainsCache = mapChainIdWithTokenListMap(previousTokensChainsCache);
    const cleanTokensChainsCache = mapChainIdWithTokenListMap(tokensChainsCache);
    const isEqualValues = (0, lodash_1.isEqual)(cleanTokensChainsCache, cleanPreviousTokensChainsCache);
    return isEqualValues;
}, _TokenDetectionController_getCorrectNetworkClientIdByChainId = function _TokenDetectionController_getCorrectNetworkClientIdByChainId(chainIds) {
    const { networkConfigurationsByChainId, selectedNetworkClientId } = this.messagingSystem.call('NetworkController:getState');
    if (!chainIds) {
        const networkConfiguration = this.messagingSystem.call('NetworkController:getNetworkConfigurationByNetworkClientId', selectedNetworkClientId);
        return [
            {
                chainId: networkConfiguration?.chainId ?? controller_utils_1.ChainId.mainnet,
                networkClientId: selectedNetworkClientId,
            },
        ];
    }
    return chainIds.map((chainId) => {
        const configuration = networkConfigurationsByChainId[chainId];
        return {
            chainId,
            networkClientId: configuration.rpcEndpoints[configuration.defaultRpcEndpointIndex]
                .networkClientId,
        };
    });
}, _TokenDetectionController_restartTokenDetection = 
/**
 * Restart token detection polling period and call detectNewTokens
 * in case of address change or user session initialization.
 *
 * @param options - Options for restart token detection.
 * @param options.selectedAddress - the selectedAddress against which to detect for token balances
 * @param options.chainIds - The chain IDs of the network client to use.
 */
async function _TokenDetectionController_restartTokenDetection({ selectedAddress, chainIds, } = {}) {
    await this.detectTokens({
        chainIds,
        selectedAddress,
    });
    this.setIntervalLength(DEFAULT_INTERVAL);
}, _TokenDetectionController_getChainsToDetect = function _TokenDetectionController_getChainsToDetect(clientNetworks, supportedNetworks) {
    const chainsToDetectUsingAccountAPI = [];
    const chainsToDetectUsingRpc = [];
    clientNetworks.forEach(({ chainId, networkClientId }) => {
        if (supportedNetworks?.includes((0, utils_1.hexToNumber)(chainId))) {
            chainsToDetectUsingAccountAPI.push(chainId);
        }
        else {
            chainsToDetectUsingRpc.push({ chainId, networkClientId });
        }
    });
    return { chainsToDetectUsingRpc, chainsToDetectUsingAccountAPI };
}, _TokenDetectionController_attemptAccountAPIDetection = async function _TokenDetectionController_attemptAccountAPIDetection(chainsToDetectUsingAccountAPI, addressToDetect, supportedNetworks) {
    return await __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_addDetectedTokensViaAPI).call(this, {
        chainIds: chainsToDetectUsingAccountAPI,
        selectedAddress: addressToDetect,
        supportedNetworks,
    });
}, _TokenDetectionController_addChainsToRpcDetection = function _TokenDetectionController_addChainsToRpcDetection(chainsToDetectUsingRpc, chainsToDetectUsingAccountAPI, clientNetworks) {
    chainsToDetectUsingAccountAPI.forEach((chainId) => {
        const networkEntry = clientNetworks.find((network) => network.chainId === chainId);
        if (networkEntry) {
            chainsToDetectUsingRpc.push({
                chainId: networkEntry.chainId,
                networkClientId: networkEntry.networkClientId,
            });
        }
    });
}, _TokenDetectionController_shouldDetectTokens = function _TokenDetectionController_shouldDetectTokens(chainId) {
    if (!(0, assetsUtil_1.isTokenDetectionSupportedForNetwork)(chainId)) {
        return false;
    }
    if (!__classPrivateFieldGet(this, _TokenDetectionController_isDetectionEnabledFromPreferences, "f") &&
        chainId !== controller_utils_1.ChainId.mainnet) {
        return false;
    }
    const isMainnetDetectionInactive = !__classPrivateFieldGet(this, _TokenDetectionController_isDetectionEnabledFromPreferences, "f") && chainId === controller_utils_1.ChainId.mainnet;
    if (isMainnetDetectionInactive) {
        __classPrivateFieldSet(this, _TokenDetectionController_tokensChainsCache, __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_getConvertedStaticMainnetTokenList).call(this), "f");
    }
    else {
        const { tokensChainsCache } = this.messagingSystem.call('TokenListController:getState');
        __classPrivateFieldSet(this, _TokenDetectionController_tokensChainsCache, tokensChainsCache ?? {}, "f");
    }
    return true;
}, _TokenDetectionController_detectTokensUsingRpc = async function _TokenDetectionController_detectTokensUsingRpc(chainsToDetectUsingRpc, addressToDetect) {
    for (const { chainId, networkClientId } of chainsToDetectUsingRpc) {
        if (!__classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_shouldDetectTokens).call(this, chainId)) {
            continue;
        }
        const tokenCandidateSlices = __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_getSlicesOfTokensToDetect).call(this, {
            chainId,
            selectedAddress: addressToDetect,
        });
        const tokenDetectionPromises = tokenCandidateSlices.map((tokensSlice) => __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_addDetectedTokens).call(this, {
            tokensSlice,
            selectedAddress: addressToDetect,
            networkClientId,
            chainId,
        }));
        await Promise.all(tokenDetectionPromises);
    }
}, _TokenDetectionController_getSlicesOfTokensToDetect = function _TokenDetectionController_getSlicesOfTokensToDetect({ chainId, selectedAddress, }) {
    const { allTokens, allDetectedTokens, allIgnoredTokens } = this.messagingSystem.call('TokensController:getState');
    const [tokensAddresses, detectedTokensAddresses, ignoredTokensAddresses] = [
        allTokens,
        allDetectedTokens,
        allIgnoredTokens,
    ].map((tokens) => (tokens[chainId]?.[selectedAddress] ?? []).map((value) => typeof value === 'string' ? value : value.address));
    const tokensToDetect = [];
    for (const tokenAddress of Object.keys(__classPrivateFieldGet(this, _TokenDetectionController_tokensChainsCache, "f")?.[chainId]?.data || {})) {
        if ([
            tokensAddresses,
            detectedTokensAddresses,
            ignoredTokensAddresses,
        ].every((addresses) => !addresses.find((address) => (0, controller_utils_1.isEqualCaseInsensitive)(address, tokenAddress)))) {
            tokensToDetect.push(tokenAddress);
        }
    }
    const slicesOfTokensToDetect = [];
    for (let i = 0, size = 1000; i < tokensToDetect.length; i += size) {
        slicesOfTokensToDetect.push(tokensToDetect.slice(i, i + size));
    }
    return slicesOfTokensToDetect;
}, _TokenDetectionController_getConvertedStaticMainnetTokenList = function _TokenDetectionController_getConvertedStaticMainnetTokenList() {
    const data = Object.entries(exports.STATIC_MAINNET_TOKEN_LIST).reduce((acc, [key, value]) => ({
        ...acc,
        [key]: {
            name: value.name,
            symbol: value.symbol,
            decimals: value.decimals,
            address: value.address,
            aggregators: [],
            iconUrl: value?.iconUrl,
        },
    }), {});
    return {
        '0x1': {
            data,
            timestamp: 0,
        },
    };
}, _TokenDetectionController_addDetectedTokensViaAPI = 
/**
 * This adds detected tokens from the Accounts API, avoiding the multi-call RPC calls for balances
 *
 * @param options - method arguments
 * @param options.selectedAddress - address to check against
 * @param options.chainIds - array of chainIds to check tokens for
 * @param options.supportedNetworks - array of chainIds to check tokens for
 * @returns a success or failed object
 */
async function _TokenDetectionController_addDetectedTokensViaAPI({ selectedAddress, chainIds, supportedNetworks, }) {
    return await (0, controller_utils_1.safelyExecute)(async () => {
        // Fetch balances for multiple chain IDs at once
        const tokenBalancesByChain = await __classPrivateFieldGet(this, _TokenDetectionController_accountsAPI, "f")
            .getMultiNetworksBalances(selectedAddress, chainIds, supportedNetworks)
            .catch(() => null);
        if (tokenBalancesByChain === null) {
            return { result: 'failed' };
        }
        // Process each chain ID individually
        for (const chainId of chainIds) {
            const isTokenDetectionInactiveInMainnet = !__classPrivateFieldGet(this, _TokenDetectionController_isDetectionEnabledFromPreferences, "f") &&
                chainId === controller_utils_1.ChainId.mainnet;
            const { tokensChainsCache } = this.messagingSystem.call('TokenListController:getState');
            __classPrivateFieldSet(this, _TokenDetectionController_tokensChainsCache, isTokenDetectionInactiveInMainnet
                ? __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_getConvertedStaticMainnetTokenList).call(this)
                : (tokensChainsCache ?? {}), "f");
            // Generate token candidates based on chainId and selectedAddress
            const tokenCandidateSlices = __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_getSlicesOfTokensToDetect).call(this, {
                chainId,
                selectedAddress,
            });
            // Filter balances for the current chainId
            const tokenBalances = tokenBalancesByChain.filter((balance) => balance.chainId === (0, utils_1.hexToNumber)(chainId));
            if (!tokenBalances || tokenBalances.length === 0) {
                continue;
            }
            // Use helper function to filter tokens with balance for this chainId
            const { tokensWithBalance, eventTokensDetails } = __classPrivateFieldGet(this, _TokenDetectionController_instances, "m", _TokenDetectionController_filterAndBuildTokensWithBalance).call(this, tokenCandidateSlices, tokenBalances, chainId);
            if (tokensWithBalance.length) {
                __classPrivateFieldGet(this, _TokenDetectionController_trackMetaMetricsEvent, "f").call(this, {
                    event: 'Token Detected',
                    category: 'Wallet',
                    properties: {
                        tokens: eventTokensDetails,
                        token_standard: controller_utils_1.ERC20,
                        asset_type: controller_utils_1.ASSET_TYPES.TOKEN,
                    },
                });
                const networkClientId = this.messagingSystem.call('NetworkController:findNetworkClientIdByChainId', chainId);
                await this.messagingSystem.call('TokensController:addTokens', tokensWithBalance, networkClientId);
            }
        }
        return { result: 'success' };
    });
}, _TokenDetectionController_filterAndBuildTokensWithBalance = function _TokenDetectionController_filterAndBuildTokensWithBalance(tokenCandidateSlices, tokenBalances, chainId) {
    const tokensWithBalance = [];
    const eventTokensDetails = [];
    const tokenCandidateSet = new Set(tokenCandidateSlices.flat());
    tokenBalances?.forEach((token) => {
        const tokenAddress = token.address;
        // Make sure the token to add is in our candidate list
        if (!tokenCandidateSet.has(tokenAddress)) {
            return;
        }
        // Retrieve token data from cache to safely add it
        const tokenData = __classPrivateFieldGet(this, _TokenDetectionController_tokensChainsCache, "f")[chainId]?.data[tokenAddress];
        // We need specific data from tokensChainsCache to correctly create a token
        // So even if we have a token that was detected correctly by the API, if its missing data we cannot safely add it.
        if (!tokenData) {
            return;
        }
        const { decimals, symbol, aggregators, iconUrl, name } = tokenData;
        eventTokensDetails.push(`${symbol} - ${tokenAddress}`);
        tokensWithBalance.push({
            address: tokenAddress,
            decimals,
            symbol,
            aggregators,
            image: iconUrl,
            isERC721: false,
            name,
        });
    });
    return { tokensWithBalance, eventTokensDetails };
}, _TokenDetectionController_addDetectedTokens = async function _TokenDetectionController_addDetectedTokens({ tokensSlice, selectedAddress, networkClientId, chainId, }) {
    await (0, controller_utils_1.safelyExecute)(async () => {
        const balances = await __classPrivateFieldGet(this, _TokenDetectionController_getBalancesInSingleCall, "f").call(this, selectedAddress, tokensSlice, networkClientId);
        const tokensWithBalance = [];
        const eventTokensDetails = [];
        for (const nonZeroTokenAddress of Object.keys(balances)) {
            const { decimals, symbol, aggregators, iconUrl, name } = __classPrivateFieldGet(this, _TokenDetectionController_tokensChainsCache, "f")[chainId].data[nonZeroTokenAddress];
            eventTokensDetails.push(`${symbol} - ${nonZeroTokenAddress}`);
            tokensWithBalance.push({
                address: nonZeroTokenAddress,
                decimals,
                symbol,
                aggregators,
                image: iconUrl,
                isERC721: false,
                name,
            });
        }
        if (tokensWithBalance.length) {
            __classPrivateFieldGet(this, _TokenDetectionController_trackMetaMetricsEvent, "f").call(this, {
                event: 'Token Detected',
                category: 'Wallet',
                properties: {
                    tokens: eventTokensDetails,
                    token_standard: controller_utils_1.ERC20,
                    asset_type: controller_utils_1.ASSET_TYPES.TOKEN,
                },
            });
            await this.messagingSystem.call('TokensController:addTokens', tokensWithBalance, networkClientId);
        }
    });
}, _TokenDetectionController_getSelectedAccount = function _TokenDetectionController_getSelectedAccount() {
    return this.messagingSystem.call('AccountsController:getSelectedAccount');
}, _TokenDetectionController_getSelectedAddress = function _TokenDetectionController_getSelectedAddress() {
    // If the address is not defined (or empty), we fallback to the currently selected account's address
    const account = this.messagingSystem.call('AccountsController:getAccount', __classPrivateFieldGet(this, _TokenDetectionController_selectedAccountId, "f"));
    return account?.address || '';
};
exports.default = TokenDetectionController;

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\TokenDetectionController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\TokenListController.cjs", {"./assetsUtil.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\assetsUtil.cjs","./token-service.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\token-service.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/polling-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\polling-controller\\dist\\index.cjs","async-mutex":"D:\\code\\v\\metamask-extension\\node_modules\\async-mutex\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CTokenListController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _TokenListController_instances, _TokenListController_onNetworkControllerStateChange, _TokenListController_startDeprecatedPolling;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TokenListController = exports.getDefaultTokenListState = void 0;
const controller_utils_1 = require("@metamask/controller-utils");
const polling_controller_1 = require("@metamask/polling-controller");
const async_mutex_1 = require("async-mutex");
const assetsUtil_1 = require("./assetsUtil.cjs");
const token_service_1 = require("./token-service.cjs");
const DEFAULT_INTERVAL = 24 * 60 * 60 * 1000;
const DEFAULT_THRESHOLD = 24 * 60 * 60 * 1000;
const name = 'TokenListController';
const metadata = {
    tokensChainsCache: {
        includeInStateLogs: false,
        persist: true,
        anonymous: true,
        usedInUi: true,
    },
    preventPollingOnNetworkRestart: {
        includeInStateLogs: false,
        persist: true,
        anonymous: true,
        usedInUi: false,
    },
};
const getDefaultTokenListState = () => {
    return {
        tokensChainsCache: {},
        preventPollingOnNetworkRestart: false,
    };
};
exports.getDefaultTokenListState = getDefaultTokenListState;
/**
 * Controller that passively polls on a set interval for the list of tokens from metaswaps api
 */
class TokenListController extends (0, polling_controller_1.StaticIntervalPollingController)() {
    /**
     * Creates a TokenListController instance.
     *
     * @param options - The controller options.
     * @param options.chainId - The chain ID of the current network.
     * @param options.onNetworkStateChange - A function for registering an event handler for network state changes.
     * @param options.interval - The polling interval, in milliseconds.
     * @param options.cacheRefreshThreshold - The token cache expiry time, in milliseconds.
     * @param options.messenger - A restricted messenger.
     * @param options.state - Initial state to set on this controller.
     * @param options.preventPollingOnNetworkRestart - Determines whether to prevent poilling on network restart in extension.
     */
    constructor({ chainId, preventPollingOnNetworkRestart = false, onNetworkStateChange, interval = DEFAULT_INTERVAL, cacheRefreshThreshold = DEFAULT_THRESHOLD, messenger, state, }) {
        super({
            name,
            metadata,
            messenger,
            state: { ...(0, exports.getDefaultTokenListState)(), ...state },
        });
        _TokenListController_instances.add(this);
        this.mutex = new async_mutex_1.Mutex();
        this.intervalDelay = interval;
        this.setIntervalLength(interval);
        this.cacheRefreshThreshold = cacheRefreshThreshold;
        this.chainId = chainId;
        this.updatePreventPollingOnNetworkRestart(preventPollingOnNetworkRestart);
        this.abortController = new AbortController();
        if (onNetworkStateChange) {
            // TODO: Either fix this lint violation or explain why it's necessary to ignore.
            // eslint-disable-next-line @typescript-eslint/no-misused-promises
            onNetworkStateChange(async (networkControllerState) => {
                await __classPrivateFieldGet(this, _TokenListController_instances, "m", _TokenListController_onNetworkControllerStateChange).call(this, networkControllerState);
            });
        }
        else {
            this.messagingSystem.subscribe('NetworkController:stateChange', 
            // TODO: Either fix this lint violation or explain why it's necessary to ignore.
            // eslint-disable-next-line @typescript-eslint/no-misused-promises
            async (networkControllerState) => {
                await __classPrivateFieldGet(this, _TokenListController_instances, "m", _TokenListController_onNetworkControllerStateChange).call(this, networkControllerState);
            });
        }
    }
    // Eventually we want to remove start/restart/stop controls in favor of new _executePoll API
    // Maintaining these functions for now until we can safely deprecate them for backwards compatibility
    /**
     * Start polling for the token list.
     *
     * @deprecated This method is deprecated and will be removed in the future.
     * Consider using the new polling approach instead
     */
    async start() {
        if (!(0, assetsUtil_1.isTokenListSupportedForNetwork)(this.chainId)) {
            return;
        }
        await __classPrivateFieldGet(this, _TokenListController_instances, "m", _TokenListController_startDeprecatedPolling).call(this);
    }
    /**
     * Restart polling for the token list.
     *
     * @deprecated This method is deprecated and will be removed in the future.
     * Consider using the new polling approach instead
     */
    async restart() {
        this.stopPolling();
        await __classPrivateFieldGet(this, _TokenListController_instances, "m", _TokenListController_startDeprecatedPolling).call(this);
    }
    /**
     * Stop polling for the token list.
     *
     * @deprecated This method is deprecated and will be removed in the future.
     * Consider using the new polling approach instead
     */
    stop() {
        this.stopPolling();
    }
    /**
     * This stops any active polling.
     *
     * @deprecated This method is deprecated and will be removed in the future.
     * Consider using the new polling approach instead
     */
    destroy() {
        super.destroy();
        this.stopPolling();
    }
    /**
     * This stops any active polling intervals.
     *
     * @deprecated This method is deprecated and will be removed in the future.
     * Consider using the new polling approach instead
     */
    stopPolling() {
        if (this.intervalId) {
            clearInterval(this.intervalId);
        }
    }
    /**
     * This starts a new polling loop for any given chain. Under the hood it is deduping polls
     *
     * @param input - The input for the poll.
     * @param input.chainId - The chainId of the chain to trigger the fetch.
     * @returns A promise that resolves when this operation completes.
     */
    async _executePoll({ chainId }) {
        return this.fetchTokenList(chainId);
    }
    /**
     * Fetching token list from the Token Service API. This will fetch tokens across chains. It will update tokensChainsCache (scoped across chains), and also the tokenList (scoped for the selected chain)
     *
     * @param chainId - The chainId of the current chain triggering the fetch.
     */
    async fetchTokenList(chainId) {
        const releaseLock = await this.mutex.acquire();
        try {
            if (this.isCacheValid(chainId)) {
                return;
            }
            // Fetch fresh token list from the API
            const tokensFromAPI = await (0, controller_utils_1.safelyExecute)(() => (0, token_service_1.fetchTokenListByChainId)(chainId, this.abortController.signal));
            // Have response - process and update list
            if (tokensFromAPI) {
                // Format tokens from API (HTTP) and update tokenList
                const tokenList = {};
                for (const token of tokensFromAPI) {
                    tokenList[token.address] = {
                        ...token,
                        aggregators: (0, assetsUtil_1.formatAggregatorNames)(token.aggregators),
                        iconUrl: (0, assetsUtil_1.formatIconUrlWithProxy)({
                            chainId,
                            tokenAddress: token.address,
                        }),
                    };
                }
                this.update((state) => {
                    var _a;
                    const newDataCache = { data: {}, timestamp: Date.now() };
                    (_a = state.tokensChainsCache)[chainId] ?? (_a[chainId] = newDataCache);
                    state.tokensChainsCache[chainId].data = tokenList;
                    state.tokensChainsCache[chainId].timestamp = Date.now();
                });
                return;
            }
            // No response - fallback to previous state, or initialise empty
            if (!tokensFromAPI) {
                this.update((state) => {
                    var _a;
                    const newDataCache = { data: {}, timestamp: Date.now() };
                    (_a = state.tokensChainsCache)[chainId] ?? (_a[chainId] = newDataCache);
                    state.tokensChainsCache[chainId].timestamp = Date.now();
                });
            }
        }
        finally {
            releaseLock();
        }
    }
    isCacheValid(chainId) {
        const { tokensChainsCache } = this.state;
        const timestamp = tokensChainsCache[chainId]?.timestamp;
        const now = Date.now();
        return (timestamp !== undefined && now - timestamp < this.cacheRefreshThreshold);
    }
    /**
     * Clearing tokenList and tokensChainsCache explicitly.
     */
    clearingTokenListData() {
        this.update(() => {
            return {
                ...this.state,
                tokensChainsCache: {},
            };
        });
    }
    /**
     * Updates preventPollingOnNetworkRestart from extension.
     *
     * @param shouldPreventPolling - Determine whether to prevent polling on network change
     */
    updatePreventPollingOnNetworkRestart(shouldPreventPolling) {
        this.update(() => {
            return {
                ...this.state,
                preventPollingOnNetworkRestart: shouldPreventPolling,
            };
        });
    }
}
exports.TokenListController = TokenListController;
_TokenListController_instances = new WeakSet(), _TokenListController_onNetworkControllerStateChange = 
/**
 * Updates state and restarts polling on changes to the network controller
 * state.
 *
 * @param networkControllerState - The updated network controller state.
 */
async function _TokenListController_onNetworkControllerStateChange(networkControllerState) {
    const selectedNetworkClient = this.messagingSystem.call('NetworkController:getNetworkClientById', networkControllerState.selectedNetworkClientId);
    const { chainId } = selectedNetworkClient.configuration;
    if (this.chainId !== chainId) {
        this.abortController.abort();
        this.abortController = new AbortController();
        this.chainId = chainId;
        if (this.state.preventPollingOnNetworkRestart) {
            this.clearingTokenListData();
        }
    }
}, _TokenListController_startDeprecatedPolling = 
/**
 * Starts a new polling interval for a given chainId (this should be deprecated in favor of _executePoll)
 *
 * @deprecated This method is deprecated and will be removed in the future.
 * Consider using the new polling approach instead
 */
async function _TokenListController_startDeprecatedPolling() {
    // renaming this to avoid collision with base class
    await (0, controller_utils_1.safelyExecute)(() => this.fetchTokenList(this.chainId));
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    this.intervalId = setInterval(async () => {
        await (0, controller_utils_1.safelyExecute)(() => this.fetchTokenList(this.chainId));
    }, this.intervalDelay);
};
exports.default = TokenListController;

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\TokenListController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\TokenRatesController.cjs", {"./assetsUtil.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\assetsUtil.cjs","./crypto-compare-service/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\crypto-compare-service\\index.cjs","./token-prices-service/codefi-v2.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\token-prices-service\\codefi-v2.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/polling-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\polling-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CTokenRatesController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _TokenRatesController_instances, _TokenRatesController_handle, _TokenRatesController_pollState, _TokenRatesController_tokenPricesService, _TokenRatesController_inProcessExchangeRateUpdates, _TokenRatesController_disabled, _TokenRatesController_interval, _TokenRatesController_allTokens, _TokenRatesController_allDetectedTokens, _TokenRatesController_subscribeToTokensStateChange, _TokenRatesController_subscribeToNetworkStateChange, _TokenRatesController_getTokenAddresses, _TokenRatesController_getTokensControllerState, _TokenRatesController_stopPoll, _TokenRatesController_poll, _TokenRatesController_fetchAndMapExchangeRates, _TokenRatesController_fetchAndMapExchangeRatesForSupportedNativeCurrency, _TokenRatesController_fetchAndMapExchangeRatesForUnsupportedNativeCurrency;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TokenRatesController = exports.getDefaultTokenRatesControllerState = exports.controllerName = void 0;
const controller_utils_1 = require("@metamask/controller-utils");
const polling_controller_1 = require("@metamask/polling-controller");
const utils_1 = require("@metamask/utils");
const lodash_1 = require("lodash");
const assetsUtil_1 = require("./assetsUtil.cjs");
const crypto_compare_service_1 = require("./crypto-compare-service/index.cjs");
const codefi_v2_1 = require("./token-prices-service/codefi-v2.cjs");
const DEFAULT_INTERVAL = 180000;
var PollState;
(function (PollState) {
    PollState["Active"] = "Active";
    PollState["Inactive"] = "Inactive";
})(PollState || (PollState = {}));
/**
 * The name of the {@link TokenRatesController}.
 */
exports.controllerName = 'TokenRatesController';
/**
 * Uses the CryptoCompare API to fetch the exchange rate between one currency
 * and another, i.e., the multiplier to apply the amount of one currency in
 * order to convert it to another.
 *
 * @param args - The arguments to this function.
 * @param args.from - The currency to convert from.
 * @param args.to - The currency to convert to.
 * @returns The exchange rate between `fromCurrency` to `toCurrency` if one
 * exists, or null if one does not.
 */
async function getCurrencyConversionRate({ from, to, }) {
    const includeUSDRate = false;
    try {
        const result = await (0, crypto_compare_service_1.fetchExchangeRate)(to, from, includeUSDRate);
        return result.conversionRate;
    }
    catch (error) {
        if (error instanceof Error &&
            error.message.includes('market does not exist for this coin pair')) {
            return null;
        }
        throw error;
    }
}
const tokenRatesControllerMetadata = {
    marketData: {
        includeInStateLogs: false,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
};
/**
 * Get the default {@link TokenRatesController} state.
 *
 * @returns The default {@link TokenRatesController} state.
 */
const getDefaultTokenRatesControllerState = () => {
    return {
        marketData: {},
    };
};
exports.getDefaultTokenRatesControllerState = getDefaultTokenRatesControllerState;
/**
 * Controller that passively polls on a set interval for token-to-fiat exchange rates
 * for tokens stored in the TokensController
 */
class TokenRatesController extends (0, polling_controller_1.StaticIntervalPollingController)() {
    /**
     * Creates a TokenRatesController instance.
     *
     * @param options - The controller options.
     * @param options.interval - The polling interval in ms
     * @param options.disabled - Boolean to track if network requests are blocked
     * @param options.tokenPricesService - An object in charge of retrieving token price
     * @param options.messenger - The messenger instance for communication
     * @param options.state - Initial state to set on this controller
     */
    constructor({ interval = DEFAULT_INTERVAL, disabled = false, tokenPricesService, messenger, state, }) {
        super({
            name: exports.controllerName,
            messenger,
            state: { ...(0, exports.getDefaultTokenRatesControllerState)(), ...state },
            metadata: tokenRatesControllerMetadata,
        });
        _TokenRatesController_instances.add(this);
        _TokenRatesController_handle.set(this, void 0);
        _TokenRatesController_pollState.set(this, PollState.Inactive);
        _TokenRatesController_tokenPricesService.set(this, void 0);
        _TokenRatesController_inProcessExchangeRateUpdates.set(this, {});
        _TokenRatesController_disabled.set(this, void 0);
        _TokenRatesController_interval.set(this, void 0);
        _TokenRatesController_allTokens.set(this, void 0);
        _TokenRatesController_allDetectedTokens.set(this, void 0);
        this.setIntervalLength(interval);
        __classPrivateFieldSet(this, _TokenRatesController_tokenPricesService, tokenPricesService, "f");
        __classPrivateFieldSet(this, _TokenRatesController_disabled, disabled, "f");
        __classPrivateFieldSet(this, _TokenRatesController_interval, interval, "f");
        const { allTokens, allDetectedTokens } = __classPrivateFieldGet(this, _TokenRatesController_instances, "m", _TokenRatesController_getTokensControllerState).call(this);
        __classPrivateFieldSet(this, _TokenRatesController_allTokens, allTokens, "f");
        __classPrivateFieldSet(this, _TokenRatesController_allDetectedTokens, allDetectedTokens, "f");
        __classPrivateFieldGet(this, _TokenRatesController_instances, "m", _TokenRatesController_subscribeToTokensStateChange).call(this);
        __classPrivateFieldGet(this, _TokenRatesController_instances, "m", _TokenRatesController_subscribeToNetworkStateChange).call(this);
    }
    /**
     * Allows controller to make active and passive polling requests
     */
    enable() {
        __classPrivateFieldSet(this, _TokenRatesController_disabled, false, "f");
    }
    /**
     * Blocks controller from making network calls
     */
    disable() {
        __classPrivateFieldSet(this, _TokenRatesController_disabled, true, "f");
    }
    /**
     * Start (or restart) polling.
     *
     * @param chainId - The chain ID.
     * @param nativeCurrency - The native currency.
     */
    async start(chainId, nativeCurrency) {
        __classPrivateFieldGet(this, _TokenRatesController_instances, "m", _TokenRatesController_stopPoll).call(this);
        __classPrivateFieldSet(this, _TokenRatesController_pollState, PollState.Active, "f");
        await __classPrivateFieldGet(this, _TokenRatesController_instances, "m", _TokenRatesController_poll).call(this, chainId, nativeCurrency);
    }
    /**
     * Stop polling.
     */
    stop() {
        __classPrivateFieldGet(this, _TokenRatesController_instances, "m", _TokenRatesController_stopPoll).call(this);
        __classPrivateFieldSet(this, _TokenRatesController_pollState, PollState.Inactive, "f");
    }
    /**
     * Updates exchange rates for all tokens.
     *
     * @param chainIdAndNativeCurrency - The chain ID and native currency.
     */
    async updateExchangeRates(chainIdAndNativeCurrency) {
        await this.updateExchangeRatesByChainId(chainIdAndNativeCurrency);
    }
    /**
     * Updates exchange rates for all tokens.
     *
     * @param chainIds - The chain IDs.
     * @returns A promise that resolves when all chain updates complete.
     */
    /**
     * Updates exchange rates for all tokens.
     *
     * @param chainIdAndNativeCurrency - The chain ID and native currency.
     */
    async updateExchangeRatesByChainId(chainIdAndNativeCurrency) {
        if (__classPrivateFieldGet(this, _TokenRatesController_disabled, "f")) {
            return;
        }
        // Create a promise for each chainId to fetch exchange rates.
        const updatePromises = chainIdAndNativeCurrency.map(async ({ chainId, nativeCurrency }) => {
            const tokenAddresses = __classPrivateFieldGet(this, _TokenRatesController_instances, "m", _TokenRatesController_getTokenAddresses).call(this, chainId);
            // Build a unique key based on chainId, nativeCurrency, and the number of token addresses.
            const updateKey = `${chainId}:${nativeCurrency}:${tokenAddresses.length}`;
            if (updateKey in __classPrivateFieldGet(this, _TokenRatesController_inProcessExchangeRateUpdates, "f")) {
                // Await any ongoing update to avoid redundant work.
                await __classPrivateFieldGet(this, _TokenRatesController_inProcessExchangeRateUpdates, "f")[updateKey];
                return null;
            }
            // Create a deferred promise to track this update.
            const { promise: inProgressUpdate, resolve: updateSucceeded, reject: updateFailed, } = (0, utils_1.createDeferredPromise)({ suppressUnhandledRejection: true });
            __classPrivateFieldGet(this, _TokenRatesController_inProcessExchangeRateUpdates, "f")[updateKey] = inProgressUpdate;
            try {
                const contractInformations = await __classPrivateFieldGet(this, _TokenRatesController_instances, "m", _TokenRatesController_fetchAndMapExchangeRates).call(this, {
                    tokenAddresses,
                    chainId,
                    nativeCurrency,
                });
                // Each promise returns an object with the market data for the chain.
                const marketData = {
                    [chainId]: {
                        ...(contractInformations ?? {}),
                    },
                };
                updateSucceeded();
                return marketData;
            }
            catch (error) {
                updateFailed(error);
                throw error;
            }
            finally {
                // Cleanup the tracking for this update.
                delete __classPrivateFieldGet(this, _TokenRatesController_inProcessExchangeRateUpdates, "f")[updateKey];
            }
        });
        // Wait for all update promises to settle.
        const results = await Promise.allSettled(updatePromises);
        // Merge all successful market data updates into one object.
        const combinedMarketData = results.reduce((acc, result) => {
            if (result.status === 'fulfilled' && result.value) {
                acc = { ...acc, ...result.value };
            }
            return acc;
        }, {});
        // Call this.update only once with the combined market data to reduce the number of state changes and re-renders
        if (Object.keys(combinedMarketData).length > 0) {
            this.update((state) => {
                state.marketData = {
                    ...state.marketData,
                    ...combinedMarketData,
                };
            });
        }
    }
    /**
     * Updates token rates for the given networkClientId
     *
     * @param input - The input for the poll.
     * @param input.chainIds - The chain ids to poll token rates on.
     */
    async _executePoll({ chainIds }) {
        const { networkConfigurationsByChainId } = this.messagingSystem.call('NetworkController:getState');
        const chainIdAndNativeCurrency = chainIds.reduce((acc, chainId) => {
            const networkConfiguration = networkConfigurationsByChainId[chainId];
            if (!networkConfiguration) {
                console.error(`TokenRatesController: No network configuration found for chainId ${chainId}`);
                return acc;
            }
            acc.push({
                chainId,
                nativeCurrency: networkConfiguration.nativeCurrency,
            });
            return acc;
        }, []);
        await this.updateExchangeRatesByChainId(chainIdAndNativeCurrency);
    }
    /**
     * Reset the controller state to the default state.
     */
    resetState() {
        this.update(() => {
            return (0, exports.getDefaultTokenRatesControllerState)();
        });
    }
}
exports.TokenRatesController = TokenRatesController;
_TokenRatesController_handle = new WeakMap(), _TokenRatesController_pollState = new WeakMap(), _TokenRatesController_tokenPricesService = new WeakMap(), _TokenRatesController_inProcessExchangeRateUpdates = new WeakMap(), _TokenRatesController_disabled = new WeakMap(), _TokenRatesController_interval = new WeakMap(), _TokenRatesController_allTokens = new WeakMap(), _TokenRatesController_allDetectedTokens = new WeakMap(), _TokenRatesController_instances = new WeakSet(), _TokenRatesController_subscribeToTokensStateChange = function _TokenRatesController_subscribeToTokensStateChange() {
    this.messagingSystem.subscribe('TokensController:stateChange', 
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    async ({ allTokens, allDetectedTokens }) => {
        if (__classPrivateFieldGet(this, _TokenRatesController_disabled, "f")) {
            return;
        }
        const { networkConfigurationsByChainId } = this.messagingSystem.call('NetworkController:getState');
        const chainIds = [
            ...new Set([
                ...Object.keys(allTokens),
                ...Object.keys(allDetectedTokens),
            ]),
        ];
        const chainIdsToUpdate = chainIds.filter((chainId) => !(0, lodash_1.isEqual)(__classPrivateFieldGet(this, _TokenRatesController_allTokens, "f")[chainId], allTokens[chainId]) ||
            !(0, lodash_1.isEqual)(__classPrivateFieldGet(this, _TokenRatesController_allDetectedTokens, "f")[chainId], allDetectedTokens[chainId]));
        __classPrivateFieldSet(this, _TokenRatesController_allTokens, allTokens, "f");
        __classPrivateFieldSet(this, _TokenRatesController_allDetectedTokens, allDetectedTokens, "f");
        const chainIdAndNativeCurrency = chainIdsToUpdate.reduce((acc, chainId) => {
            const networkConfiguration = networkConfigurationsByChainId[chainId];
            if (!networkConfiguration) {
                console.error(`TokenRatesController: No network configuration found for chainId ${chainId}`);
                return acc;
            }
            acc.push({
                chainId,
                nativeCurrency: networkConfiguration.nativeCurrency,
            });
            return acc;
        }, []);
        await this.updateExchangeRatesByChainId(chainIdAndNativeCurrency);
    }, ({ allTokens, allDetectedTokens }) => {
        return { allTokens, allDetectedTokens };
    });
}, _TokenRatesController_subscribeToNetworkStateChange = function _TokenRatesController_subscribeToNetworkStateChange() {
    this.messagingSystem.subscribe('NetworkController:stateChange', 
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    async ({ networkConfigurationsByChainId }, patches) => {
        const chainIdAndNativeCurrency = Object.values(networkConfigurationsByChainId).map(({ chainId, nativeCurrency }) => {
            return {
                chainId: chainId,
                nativeCurrency,
            };
        });
        if (__classPrivateFieldGet(this, _TokenRatesController_pollState, "f") === PollState.Active) {
            await this.updateExchangeRates(chainIdAndNativeCurrency);
        }
        // Remove state for deleted networks
        for (const patch of patches) {
            if (patch.op === 'remove' &&
                patch.path[0] === 'networkConfigurationsByChainId') {
                const removedChainId = patch.path[1];
                this.update((state) => {
                    delete state.marketData[removedChainId];
                });
            }
        }
    });
}, _TokenRatesController_getTokenAddresses = function _TokenRatesController_getTokenAddresses(chainId) {
    const getTokens = (allTokens) => Object.values(allTokens ?? {}).flatMap((tokens) => tokens.map(({ address }) => (0, controller_utils_1.toChecksumHexAddress)(address)));
    const tokenAddresses = getTokens(__classPrivateFieldGet(this, _TokenRatesController_allTokens, "f")[chainId]);
    const detectedTokenAddresses = getTokens(__classPrivateFieldGet(this, _TokenRatesController_allDetectedTokens, "f")[chainId]);
    return [...new Set([...tokenAddresses, ...detectedTokenAddresses])].sort();
}, _TokenRatesController_getTokensControllerState = function _TokenRatesController_getTokensControllerState() {
    const { allTokens, allDetectedTokens } = this.messagingSystem.call('TokensController:getState');
    return {
        allTokens,
        allDetectedTokens,
    };
}, _TokenRatesController_stopPoll = function _TokenRatesController_stopPoll() {
    if (__classPrivateFieldGet(this, _TokenRatesController_handle, "f")) {
        clearTimeout(__classPrivateFieldGet(this, _TokenRatesController_handle, "f"));
    }
}, _TokenRatesController_poll = 
/**
 * Poll for exchange rate updates.
 *
 * @param chainId - The chain ID.
 * @param nativeCurrency - The native currency.
 */
async function _TokenRatesController_poll(chainId, nativeCurrency) {
    await (0, controller_utils_1.safelyExecute)(() => this.updateExchangeRates([{ chainId, nativeCurrency }]));
    // Poll using recursive `setTimeout` instead of `setInterval` so that
    // requests don't stack if they take longer than the polling interval
    __classPrivateFieldSet(this, _TokenRatesController_handle, setTimeout(() => {
        // TODO: Either fix this lint violation or explain why it's necessary to ignore.
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        __classPrivateFieldGet(this, _TokenRatesController_instances, "m", _TokenRatesController_poll).call(this, chainId, nativeCurrency);
    }, __classPrivateFieldGet(this, _TokenRatesController_interval, "f")), "f");
}, _TokenRatesController_fetchAndMapExchangeRates = 
/**
 * Uses the token prices service to retrieve exchange rates for tokens in a
 * particular currency.
 *
 * If the price API does not support the given chain ID, returns an empty
 * object.
 *
 * If the price API does not support the given currency, retrieves exchange
 * rates in a known currency instead, then converts those rates using the
 * exchange rate between the known currency and desired currency.
 *
 * @param args - The arguments to this function.
 * @param args.tokenAddresses - Addresses for tokens.
 * @param args.chainId - The EIP-155 ID of the chain where the tokens live.
 * @param args.nativeCurrency - The native currency in which to request
 * exchange rates.
 * @returns A map from token address to its exchange rate in the native
 * currency, or an empty map if no exchange rates can be obtained for the
 * chain ID.
 */
async function _TokenRatesController_fetchAndMapExchangeRates({ tokenAddresses, chainId, nativeCurrency, }) {
    if (!__classPrivateFieldGet(this, _TokenRatesController_tokenPricesService, "f").validateChainIdSupported(chainId)) {
        return tokenAddresses.reduce((obj, tokenAddress) => {
            obj = {
                ...obj,
                [tokenAddress]: undefined,
            };
            return obj;
        }, {});
    }
    if (__classPrivateFieldGet(this, _TokenRatesController_tokenPricesService, "f").validateCurrencySupported(nativeCurrency)) {
        return await __classPrivateFieldGet(this, _TokenRatesController_instances, "m", _TokenRatesController_fetchAndMapExchangeRatesForSupportedNativeCurrency).call(this, {
            tokenAddresses,
            chainId,
            nativeCurrency,
        });
    }
    return await __classPrivateFieldGet(this, _TokenRatesController_instances, "m", _TokenRatesController_fetchAndMapExchangeRatesForUnsupportedNativeCurrency).call(this, {
        chainId,
        tokenAddresses,
        nativeCurrency,
    });
}, _TokenRatesController_fetchAndMapExchangeRatesForSupportedNativeCurrency = 
/**
 * Retrieves prices in the given currency for the given tokens on the given
 * chain. Ensures that token addresses are checksum addresses.
 *
 * @param args - The arguments to this function.
 * @param args.tokenAddresses - Addresses for tokens.
 * @param args.chainId - The EIP-155 ID of the chain where the tokens live.
 * @param args.nativeCurrency - The native currency in which to request
 * prices.
 * @returns A map of the token addresses (as checksums) to their prices in the
 * native currency.
 */
async function _TokenRatesController_fetchAndMapExchangeRatesForSupportedNativeCurrency({ tokenAddresses, chainId, nativeCurrency, }) {
    let contractNativeInformations;
    const tokenPricesByTokenAddress = await (0, assetsUtil_1.reduceInBatchesSerially)({
        values: [...tokenAddresses].sort(),
        batchSize: assetsUtil_1.TOKEN_PRICES_BATCH_SIZE,
        eachBatch: async (allTokenPricesByTokenAddress, batch) => {
            const tokenPricesByTokenAddressForBatch = await __classPrivateFieldGet(this, _TokenRatesController_tokenPricesService, "f").fetchTokenPrices({
                tokenAddresses: batch,
                chainId,
                currency: nativeCurrency,
            });
            return {
                ...allTokenPricesByTokenAddress,
                ...tokenPricesByTokenAddressForBatch,
            };
        },
        initialResult: {},
    });
    contractNativeInformations = tokenPricesByTokenAddress;
    // fetch for native token
    if (tokenAddresses.length === 0) {
        const contractNativeInformationsNative = await __classPrivateFieldGet(this, _TokenRatesController_tokenPricesService, "f").fetchTokenPrices({
            tokenAddresses: [],
            chainId,
            currency: nativeCurrency,
        });
        contractNativeInformations = {
            [(0, codefi_v2_1.getNativeTokenAddress)(chainId)]: {
                currency: nativeCurrency,
                ...contractNativeInformationsNative[(0, codefi_v2_1.getNativeTokenAddress)(chainId)],
            },
        };
    }
    return Object.entries(contractNativeInformations).reduce((obj, [tokenAddress, token]) => {
        obj = {
            ...obj,
            [tokenAddress]: { ...token },
        };
        return obj;
    }, {});
}, _TokenRatesController_fetchAndMapExchangeRatesForUnsupportedNativeCurrency = 
/**
 * If the price API does not support a given native currency, then we need to
 * convert it to a fallback currency and feed that currency into the price
 * API, then convert the prices to our desired native currency.
 *
 * @param args - The arguments to this function.
 * @param args.chainId - The chain id to fetch prices for.
 * @param args.tokenAddresses - Addresses for tokens.
 * @param args.nativeCurrency - The native currency in which to request
 * prices.
 * @returns A map of the token addresses (as checksums) to their prices in the
 * native currency.
 */
async function _TokenRatesController_fetchAndMapExchangeRatesForUnsupportedNativeCurrency({ chainId, tokenAddresses, nativeCurrency, }) {
    const [contractExchangeInformations, fallbackCurrencyToNativeCurrencyConversionRate,] = await Promise.all([
        __classPrivateFieldGet(this, _TokenRatesController_instances, "m", _TokenRatesController_fetchAndMapExchangeRatesForSupportedNativeCurrency).call(this, {
            tokenAddresses,
            chainId,
            nativeCurrency: controller_utils_1.FALL_BACK_VS_CURRENCY,
        }),
        getCurrencyConversionRate({
            from: controller_utils_1.FALL_BACK_VS_CURRENCY,
            to: nativeCurrency,
        }),
    ]);
    if (fallbackCurrencyToNativeCurrencyConversionRate === null) {
        return {};
    }
    // Converts the price in the fallback currency to the native currency
    const convertFallbackToNative = (value) => value !== undefined && value !== null
        ? value * fallbackCurrencyToNativeCurrencyConversionRate
        : undefined;
    const updatedContractExchangeRates = Object.entries(contractExchangeInformations).reduce((acc, [tokenAddress, token]) => {
        acc = {
            ...acc,
            [tokenAddress]: {
                ...token,
                currency: nativeCurrency,
                price: convertFallbackToNative(token.price),
                marketCap: convertFallbackToNative(token.marketCap),
                allTimeHigh: convertFallbackToNative(token.allTimeHigh),
                allTimeLow: convertFallbackToNative(token.allTimeLow),
                totalVolume: convertFallbackToNative(token.totalVolume),
                high1d: convertFallbackToNative(token.high1d),
                low1d: convertFallbackToNative(token.low1d),
                dilutedMarketCap: convertFallbackToNative(token.dilutedMarketCap),
            },
        };
        return acc;
    }, {});
    return updatedContractExchangeRates;
};
exports.default = TokenRatesController;

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\TokenRatesController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\TokenSearchDiscoveryDataController\\TokenSearchDiscoveryDataController.cjs", {"../assetsUtil.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\assetsUtil.cjs","../token-service.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\token-service.cjs","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CTokenSearchDiscoveryDataController%5CTokenSearchDiscoveryDataController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _TokenSearchDiscoveryDataController_instances, _TokenSearchDiscoveryDataController_abortController, _TokenSearchDiscoveryDataController_tokenPricesService, _TokenSearchDiscoveryDataController_swapsSupportedChainIds, _TokenSearchDiscoveryDataController_fetchTokens, _TokenSearchDiscoveryDataController_fetchSwapsTokensThresholdMs, _TokenSearchDiscoveryDataController_fetchPriceData;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TokenSearchDiscoveryDataController = exports.getDefaultTokenSearchDiscoveryDataControllerState = exports.MAX_TOKEN_DISPLAY_DATA_LENGTH = exports.controllerName = void 0;
const base_controller_1 = require("@metamask/base-controller");
const assetsUtil_1 = require("../assetsUtil.cjs");
const token_service_1 = require("../token-service.cjs");
// === GENERAL ===
exports.controllerName = 'TokenSearchDiscoveryDataController';
exports.MAX_TOKEN_DISPLAY_DATA_LENGTH = 10;
const tokenSearchDiscoveryDataControllerMetadata = {
    tokenDisplayData: {
        includeInStateLogs: false,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
    swapsTokenAddressesByChainId: {
        includeInStateLogs: false,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
};
/**
 * Constructs the default {@link TokenSearchDiscoveryDataController} state. This allows
 * consumers to provide a partial state object when initializing the controller
 * and also helps in constructing complete state objects for this controller in
 * tests.
 *
 * @returns The default {@link TokenSearchDiscoveryDataController} state.
 */
function getDefaultTokenSearchDiscoveryDataControllerState() {
    return {
        tokenDisplayData: [],
        swapsTokenAddressesByChainId: {},
    };
}
exports.getDefaultTokenSearchDiscoveryDataControllerState = getDefaultTokenSearchDiscoveryDataControllerState;
/**
 * The TokenSearchDiscoveryDataController manages the retrieval of token search results and token discovery.
 * It fetches token search results and discovery data from the Portfolio API.
 */
class TokenSearchDiscoveryDataController extends base_controller_1.BaseController {
    constructor({ state = {}, messenger, tokenPricesService, swapsSupportedChainIds, fetchTokens, fetchSwapsTokensThresholdMs, }) {
        super({
            name: exports.controllerName,
            metadata: tokenSearchDiscoveryDataControllerMetadata,
            messenger,
            state: {
                ...getDefaultTokenSearchDiscoveryDataControllerState(),
                ...state,
            },
        });
        _TokenSearchDiscoveryDataController_instances.add(this);
        _TokenSearchDiscoveryDataController_abortController.set(this, void 0);
        _TokenSearchDiscoveryDataController_tokenPricesService.set(this, void 0);
        _TokenSearchDiscoveryDataController_swapsSupportedChainIds.set(this, void 0);
        _TokenSearchDiscoveryDataController_fetchTokens.set(this, void 0);
        _TokenSearchDiscoveryDataController_fetchSwapsTokensThresholdMs.set(this, void 0);
        __classPrivateFieldSet(this, _TokenSearchDiscoveryDataController_abortController, new AbortController(), "f");
        __classPrivateFieldSet(this, _TokenSearchDiscoveryDataController_tokenPricesService, tokenPricesService, "f");
        __classPrivateFieldSet(this, _TokenSearchDiscoveryDataController_swapsSupportedChainIds, swapsSupportedChainIds, "f");
        __classPrivateFieldSet(this, _TokenSearchDiscoveryDataController_fetchTokens, fetchTokens, "f");
        __classPrivateFieldSet(this, _TokenSearchDiscoveryDataController_fetchSwapsTokensThresholdMs, fetchSwapsTokensThresholdMs, "f");
    }
    async fetchSwapsTokens(chainId) {
        if (!__classPrivateFieldGet(this, _TokenSearchDiscoveryDataController_swapsSupportedChainIds, "f").includes(chainId)) {
            return;
        }
        const swapsTokens = this.state.swapsTokenAddressesByChainId[chainId];
        if ((!swapsTokens ||
            swapsTokens.lastFetched <
                Date.now() - __classPrivateFieldGet(this, _TokenSearchDiscoveryDataController_fetchSwapsTokensThresholdMs, "f")) &&
            !swapsTokens?.isFetching) {
            try {
                this.update((state) => {
                    if (!state.swapsTokenAddressesByChainId[chainId]) {
                        state.swapsTokenAddressesByChainId[chainId] = {
                            lastFetched: Date.now(),
                            addresses: [],
                            isFetching: true,
                        };
                    }
                    else {
                        state.swapsTokenAddressesByChainId[chainId].isFetching = true;
                    }
                });
                const tokens = await __classPrivateFieldGet(this, _TokenSearchDiscoveryDataController_fetchTokens, "f").call(this, chainId);
                this.update((state) => {
                    state.swapsTokenAddressesByChainId[chainId] = {
                        lastFetched: Date.now(),
                        addresses: tokens.map((token) => token.address),
                        isFetching: false,
                    };
                });
            }
            catch (error) {
                console.error(error);
            }
        }
    }
    async fetchTokenDisplayData(chainId, address) {
        await this.fetchSwapsTokens(chainId);
        let tokenMetadata;
        try {
            tokenMetadata = await (0, token_service_1.fetchTokenMetadata)(chainId, address, __classPrivateFieldGet(this, _TokenSearchDiscoveryDataController_abortController, "f").signal);
        }
        catch (error) {
            if (!(error instanceof Error) ||
                !error.message.includes(token_service_1.TOKEN_METADATA_NO_SUPPORT_ERROR)) {
                throw error;
            }
        }
        const { currentCurrency } = this.messagingSystem.call('CurrencyRateController:getState');
        let tokenDisplayData;
        if (!tokenMetadata) {
            tokenDisplayData = {
                found: false,
                address,
                chainId,
                currency: currentCurrency,
            };
        }
        else {
            const priceData = await __classPrivateFieldGet(this, _TokenSearchDiscoveryDataController_instances, "m", _TokenSearchDiscoveryDataController_fetchPriceData).call(this, chainId, address);
            tokenDisplayData = {
                found: true,
                address,
                chainId,
                currency: currentCurrency,
                token: {
                    ...tokenMetadata,
                    isERC721: false,
                    image: (0, assetsUtil_1.formatIconUrlWithProxy)({
                        chainId,
                        tokenAddress: address,
                    }),
                },
                price: priceData,
            };
        }
        this.update((state) => {
            state.tokenDisplayData = [
                tokenDisplayData,
                ...state.tokenDisplayData.filter((token) => token.address !== address ||
                    token.chainId !== chainId ||
                    token.currency !== currentCurrency),
            ].slice(0, exports.MAX_TOKEN_DISPLAY_DATA_LENGTH);
        });
    }
}
exports.TokenSearchDiscoveryDataController = TokenSearchDiscoveryDataController;
_TokenSearchDiscoveryDataController_abortController = new WeakMap(), _TokenSearchDiscoveryDataController_tokenPricesService = new WeakMap(), _TokenSearchDiscoveryDataController_swapsSupportedChainIds = new WeakMap(), _TokenSearchDiscoveryDataController_fetchTokens = new WeakMap(), _TokenSearchDiscoveryDataController_fetchSwapsTokensThresholdMs = new WeakMap(), _TokenSearchDiscoveryDataController_instances = new WeakSet(), _TokenSearchDiscoveryDataController_fetchPriceData = async function _TokenSearchDiscoveryDataController_fetchPriceData(chainId, address) {
    const { currentCurrency } = this.messagingSystem.call('CurrencyRateController:getState');
    try {
        const pricesData = await __classPrivateFieldGet(this, _TokenSearchDiscoveryDataController_tokenPricesService, "f").fetchTokenPrices({
            chainId,
            tokenAddresses: [address],
            currency: currentCurrency,
        });
        return pricesData[address] ?? null;
    }
    catch (error) {
        console.error(error);
        return null;
    }
};

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\TokenSearchDiscoveryDataController\\TokenSearchDiscoveryDataController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\TokenSearchDiscoveryDataController\\index.cjs", {"./TokenSearchDiscoveryDataController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\TokenSearchDiscoveryDataController\\TokenSearchDiscoveryDataController.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CTokenSearchDiscoveryDataController%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./TokenSearchDiscoveryDataController.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\TokenSearchDiscoveryDataController\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\TokensController.cjs", {"./Standards/ERC20Standard.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\Standards\\ERC20Standard.cjs","./Standards/NftStandards/ERC1155/ERC1155Standard.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\Standards\\NftStandards\\ERC1155\\ERC1155Standard.cjs","./assetsUtil.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\assetsUtil.cjs","./token-service.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\token-service.cjs","@ethersproject/contracts":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\contracts\\lib\\index.js","@ethersproject/providers":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\providers\\lib\\index.js","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/contract-metadata":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\contract-metadata\\index.js","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/metamask-eth-abis":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\metamask-eth-abis\\dist\\index.js","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","async-mutex":"D:\\code\\v\\metamask-extension\\node_modules\\async-mutex\\lib\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","uuid":"D:\\code\\v\\metamask-extension\\node_modules\\uuid\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CTokensController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _TokensController_instances, _TokensController_mutex, _TokensController_selectedAccountId, _TokensController_provider, _TokensController_abortController, _TokensController_handleOnAccountRemoved, _TokensController_onNetworkStateChange, _TokensController_onSelectedAccountChange, _TokensController_fetchTokenMetadata, _TokensController_detectIsERC721, _TokensController_getProvider, _TokensController_createEthersContract, _TokensController_generateRandomId, _TokensController_getNewAllTokensState, _TokensController_getAddressOrSelectedAddress, _TokensController_requestApproval, _TokensController_getSelectedAccount, _TokensController_getSelectedAddress;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TokensController = exports.getDefaultTokensState = void 0;
const contracts_1 = require("@ethersproject/contracts");
const providers_1 = require("@ethersproject/providers");
const base_controller_1 = require("@metamask/base-controller");
const contract_metadata_1 = __importDefault(require("@metamask/contract-metadata"));
const controller_utils_1 = require("@metamask/controller-utils");
const metamask_eth_abis_1 = require("@metamask/metamask-eth-abis");
const rpc_errors_1 = require("@metamask/rpc-errors");
const utils_1 = require("@metamask/utils");
const async_mutex_1 = require("async-mutex");
const lodash_1 = require("lodash");
const uuid_1 = require("uuid");
const assetsUtil_1 = require("./assetsUtil.cjs");
const ERC20Standard_1 = require("./Standards/ERC20Standard.cjs");
const ERC1155Standard_1 = require("./Standards/NftStandards/ERC1155/ERC1155Standard.cjs");
const token_service_1 = require("./token-service.cjs");
const metadata = {
    allTokens: {
        includeInStateLogs: false,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
    allIgnoredTokens: {
        includeInStateLogs: false,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
    allDetectedTokens: {
        includeInStateLogs: false,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
};
const controllerName = 'TokensController';
const getDefaultTokensState = () => {
    return {
        allTokens: {},
        allIgnoredTokens: {},
        allDetectedTokens: {},
    };
};
exports.getDefaultTokensState = getDefaultTokensState;
/**
 * Controller that stores assets and exposes convenience methods
 */
class TokensController extends base_controller_1.BaseController {
    /**
     * Tokens controller options
     * @param options - Constructor options.
     * @param options.chainId - The chain ID of the current network.
     * @param options.provider - Network provider.
     * @param options.state - Initial state to set on this controller.
     * @param options.messenger - The messenger.
     */
    constructor({ provider, state, messenger, }) {
        super({
            name: controllerName,
            metadata,
            messenger,
            state: {
                ...(0, exports.getDefaultTokensState)(),
                ...state,
            },
        });
        _TokensController_instances.add(this);
        _TokensController_mutex.set(this, new async_mutex_1.Mutex());
        _TokensController_selectedAccountId.set(this, void 0);
        _TokensController_provider.set(this, void 0);
        _TokensController_abortController.set(this, void 0);
        __classPrivateFieldSet(this, _TokensController_provider, provider, "f");
        __classPrivateFieldSet(this, _TokensController_selectedAccountId, __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_getSelectedAccount).call(this).id, "f");
        __classPrivateFieldSet(this, _TokensController_abortController, new AbortController(), "f");
        this.messagingSystem.registerActionHandler(`${controllerName}:addDetectedTokens`, this.addDetectedTokens.bind(this));
        this.messagingSystem.registerActionHandler(`${controllerName}:addTokens`, this.addTokens.bind(this));
        this.messagingSystem.subscribe('AccountsController:selectedEvmAccountChange', __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_onSelectedAccountChange).bind(this));
        this.messagingSystem.subscribe('NetworkController:stateChange', __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_onNetworkStateChange).bind(this));
        this.messagingSystem.subscribe('KeyringController:accountRemoved', (accountAddress) => __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_handleOnAccountRemoved).call(this, accountAddress));
        this.messagingSystem.subscribe('TokenListController:stateChange', ({ tokensChainsCache }) => {
            const { allTokens } = this.state;
            const selectedAddress = __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_getSelectedAddress).call(this);
            // Deep clone the `allTokens` object to ensure mutability
            const updatedAllTokens = (0, lodash_1.cloneDeep)(allTokens);
            for (const [chainId, chainCache] of Object.entries(tokensChainsCache)) {
                const chainData = chainCache?.data || {};
                if (updatedAllTokens[chainId]) {
                    if (updatedAllTokens[chainId][selectedAddress]) {
                        const tokens = updatedAllTokens[chainId][selectedAddress];
                        for (const [, token] of Object.entries(tokens)) {
                            const cachedToken = chainData[token.address];
                            if (cachedToken && cachedToken.name && !token.name) {
                                token.name = cachedToken.name; // Update the token name
                            }
                        }
                    }
                }
            }
            // Update the state with the modified tokens
            this.update(() => {
                return {
                    ...this.state,
                    allTokens: updatedAllTokens,
                };
            });
        });
    }
    /**
     * Adds a token to the stored token list.
     *
     * @param options - The method argument object.
     * @param options.address - Hex address of the token contract.
     * @param options.symbol - Symbol of the token.
     * @param options.decimals - Number of decimals the token uses.
     * @param options.name - Name of the token.
     * @param options.image - Image of the token.
     * @param options.interactingAddress - The address of the account to add a token to.
     * @param options.networkClientId - Network Client ID.
     * @returns Current token list.
     */
    async addToken({ address, symbol, decimals, name, image, interactingAddress, networkClientId, }) {
        const releaseLock = await __classPrivateFieldGet(this, _TokensController_mutex, "f").acquire();
        const { allTokens, allIgnoredTokens, allDetectedTokens } = this.state;
        const chainIdToUse = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId).configuration.chainId;
        const accountAddress = __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_getAddressOrSelectedAddress).call(this, interactingAddress);
        try {
            address = (0, controller_utils_1.toChecksumHexAddress)(address);
            const tokens = allTokens[chainIdToUse]?.[accountAddress] || [];
            const ignoredTokens = allIgnoredTokens[chainIdToUse]?.[accountAddress] || [];
            const detectedTokens = allDetectedTokens[chainIdToUse]?.[accountAddress] || [];
            const newTokens = [...tokens];
            const [isERC721, tokenMetadata] = await Promise.all([
                __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_detectIsERC721).call(this, address, networkClientId),
                // TODO parameterize the token metadata fetch by networkClientId
                __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_fetchTokenMetadata).call(this, address, chainIdToUse),
            ]);
            const newEntry = {
                address,
                symbol,
                decimals,
                image: image ||
                    (0, assetsUtil_1.formatIconUrlWithProxy)({
                        chainId: chainIdToUse,
                        tokenAddress: address,
                    }),
                isERC721,
                aggregators: (0, assetsUtil_1.formatAggregatorNames)(tokenMetadata?.aggregators || []),
                name,
            };
            const previousIndex = newTokens.findIndex((token) => token.address.toLowerCase() === address.toLowerCase());
            if (previousIndex !== -1) {
                newTokens[previousIndex] = newEntry;
            }
            else {
                newTokens.push(newEntry);
            }
            const newIgnoredTokens = ignoredTokens.filter((tokenAddress) => tokenAddress.toLowerCase() !== address.toLowerCase());
            const newDetectedTokens = detectedTokens.filter((token) => token.address.toLowerCase() !== address.toLowerCase());
            const { newAllTokens, newAllIgnoredTokens, newAllDetectedTokens } = __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_getNewAllTokensState).call(this, {
                newTokens,
                newIgnoredTokens,
                newDetectedTokens,
                interactingAddress: accountAddress,
                interactingChainId: chainIdToUse,
            });
            const newState = {
                allTokens: newAllTokens,
                allIgnoredTokens: newAllIgnoredTokens,
                allDetectedTokens: newAllDetectedTokens,
            };
            this.update((state) => {
                Object.assign(state, newState);
            });
            return newTokens;
        }
        finally {
            releaseLock();
        }
    }
    /**
     * Add a batch of tokens.
     *
     * @param tokensToImport - Array of tokens to import.
     * @param networkClientId - Optional network client ID used to determine interacting chain ID.
     */
    async addTokens(tokensToImport, networkClientId) {
        const releaseLock = await __classPrivateFieldGet(this, _TokensController_mutex, "f").acquire();
        const { allTokens, allIgnoredTokens, allDetectedTokens } = this.state;
        const importedTokensMap = {};
        const interactingChainId = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId).configuration.chainId;
        // Used later to dedupe imported tokens
        const newTokensMap = [
            ...(allTokens[interactingChainId]?.[__classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_getSelectedAccount).call(this).address] ||
                []),
            ...tokensToImport,
        ].reduce((output, token) => {
            output[token.address] = token;
            return output;
        }, {});
        try {
            tokensToImport.forEach((tokenToAdd) => {
                const { address, symbol, decimals, image, aggregators, name } = tokenToAdd;
                const checksumAddress = (0, controller_utils_1.toChecksumHexAddress)(address);
                const formattedToken = {
                    address: checksumAddress,
                    symbol,
                    decimals,
                    image,
                    aggregators,
                    name,
                };
                newTokensMap[address] = formattedToken;
                importedTokensMap[address.toLowerCase()] = true;
                return formattedToken;
            });
            const newTokens = Object.values(newTokensMap);
            const newIgnoredTokens = allIgnoredTokens[interactingChainId]?.[__classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_getSelectedAddress).call(this)]?.filter((tokenAddress) => !newTokensMap[tokenAddress.toLowerCase()]);
            const detectedTokensForGivenChain = interactingChainId
                ? allDetectedTokens?.[interactingChainId]?.[__classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_getSelectedAddress).call(this)]
                : [];
            const newDetectedTokens = detectedTokensForGivenChain?.filter((t) => !importedTokensMap[t.address.toLowerCase()]);
            const { newAllTokens, newAllDetectedTokens, newAllIgnoredTokens } = __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_getNewAllTokensState).call(this, {
                newTokens,
                newDetectedTokens,
                newIgnoredTokens,
                interactingChainId,
            });
            this.update((state) => {
                state.allTokens = newAllTokens;
                state.allDetectedTokens = newAllDetectedTokens;
                state.allIgnoredTokens = newAllIgnoredTokens;
            });
        }
        finally {
            releaseLock();
        }
    }
    /**
     * Ignore a batch of tokens.
     *
     * @param tokenAddressesToIgnore - Array of token addresses to ignore.
     * @param networkClientId - Optional network client ID used to determine interacting chain ID.
     */
    ignoreTokens(tokenAddressesToIgnore, networkClientId) {
        const interactingChainId = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId).configuration.chainId;
        const { allTokens, allDetectedTokens, allIgnoredTokens } = this.state;
        const ignoredTokensMap = {};
        const ignoredTokens = allIgnoredTokens[interactingChainId]?.[__classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_getSelectedAddress).call(this)] || [];
        let newIgnoredTokens = [...ignoredTokens];
        const tokens = allTokens[interactingChainId]?.[__classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_getSelectedAddress).call(this)] || [];
        const detectedTokens = allDetectedTokens[interactingChainId]?.[__classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_getSelectedAddress).call(this)] || [];
        const checksummedTokenAddresses = tokenAddressesToIgnore.map((address) => {
            const checksumAddress = (0, controller_utils_1.toChecksumHexAddress)(address);
            ignoredTokensMap[address.toLowerCase()] = true;
            return checksumAddress;
        });
        newIgnoredTokens = [...ignoredTokens, ...checksummedTokenAddresses];
        const newDetectedTokens = detectedTokens.filter((token) => !ignoredTokensMap[token.address.toLowerCase()]);
        const newTokens = tokens.filter((token) => !ignoredTokensMap[token.address.toLowerCase()]);
        const { newAllIgnoredTokens, newAllDetectedTokens, newAllTokens } = __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_getNewAllTokensState).call(this, {
            newIgnoredTokens,
            newDetectedTokens,
            newTokens,
            interactingChainId,
        });
        this.update((state) => {
            state.allIgnoredTokens = newAllIgnoredTokens;
            state.allDetectedTokens = newAllDetectedTokens;
            state.allTokens = newAllTokens;
        });
    }
    /**
     * Adds a batch of detected tokens to the stored token list.
     *
     * @param incomingDetectedTokens - Array of detected tokens to be added or updated.
     * @param detectionDetails - An object containing the chain ID and address of the currently selected network on which the incomingDetectedTokens were detected.
     * @param detectionDetails.selectedAddress - the account address on which the incomingDetectedTokens were detected.
     * @param detectionDetails.chainId - the chainId on which the incomingDetectedTokens were detected.
     */
    async addDetectedTokens(incomingDetectedTokens, detectionDetails) {
        const releaseLock = await __classPrivateFieldGet(this, _TokensController_mutex, "f").acquire();
        const { chainId } = detectionDetails;
        // Previously selectedAddress could be an empty string. This is to preserve the behaviour
        const accountAddress = detectionDetails?.selectedAddress ?? __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_getSelectedAddress).call(this);
        const { allTokens, allDetectedTokens, allIgnoredTokens } = this.state;
        let newTokens = [...(allTokens?.[chainId]?.[accountAddress] ?? [])];
        let newDetectedTokens = [
            ...(allDetectedTokens?.[chainId]?.[accountAddress] ?? []),
        ];
        try {
            incomingDetectedTokens.forEach((tokenToAdd) => {
                const { address, symbol, decimals, image, aggregators, isERC721, name, } = tokenToAdd;
                const checksumAddress = (0, controller_utils_1.toChecksumHexAddress)(address);
                const newEntry = {
                    address: checksumAddress,
                    symbol,
                    decimals,
                    image,
                    isERC721,
                    aggregators,
                    name,
                };
                const previousImportedIndex = newTokens.findIndex((token) => token.address.toLowerCase() === checksumAddress.toLowerCase());
                if (previousImportedIndex !== -1) {
                    // Update existing data of imported token
                    newTokens[previousImportedIndex] = newEntry;
                }
                else {
                    const ignoredTokenIndex = allIgnoredTokens?.[chainId]?.[accountAddress]?.indexOf(address) ??
                        -1;
                    if (ignoredTokenIndex === -1) {
                        // Add detected token
                        const previousDetectedIndex = newDetectedTokens.findIndex((token) => token.address.toLowerCase() === checksumAddress.toLowerCase());
                        if (previousDetectedIndex !== -1) {
                            newDetectedTokens[previousDetectedIndex] = newEntry;
                        }
                        else {
                            newDetectedTokens.push(newEntry);
                        }
                    }
                }
            });
            const { newAllTokens, newAllDetectedTokens } = __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_getNewAllTokensState).call(this, {
                newTokens,
                newDetectedTokens,
                interactingAddress: accountAddress,
                interactingChainId: chainId,
            });
            // We may be detecting tokens on a different chain/account pair than are currently configured.
            // Re-point `tokens` and `detectedTokens` to keep them referencing the current chain/account.
            const selectedAddress = __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_getSelectedAddress).call(this);
            newTokens = newAllTokens?.[chainId]?.[selectedAddress] || [];
            newDetectedTokens =
                newAllDetectedTokens?.[chainId]?.[selectedAddress] || [];
            this.update((state) => {
                state.allTokens = newAllTokens;
                state.allDetectedTokens = newAllDetectedTokens;
            });
        }
        finally {
            releaseLock();
        }
    }
    /**
     * Adds isERC721 field to token object. This is called when a user attempts to add tokens that
     * were previously added which do not yet had isERC721 field.
     *
     * @param tokenAddress - The contract address of the token requiring the isERC721 field added.
     * @param networkClientId - The network client ID of the network on which the token is detected.
     * @returns The new token object with the added isERC721 field.
     */
    async updateTokenType(tokenAddress, networkClientId) {
        const chainIdToUse = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId).configuration.chainId;
        const isERC721 = await __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_detectIsERC721).call(this, tokenAddress, networkClientId);
        const accountAddress = __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_getSelectedAddress).call(this);
        const tokens = [...this.state.allTokens[chainIdToUse][accountAddress]];
        const tokenIndex = tokens.findIndex((token) => {
            return token.address.toLowerCase() === tokenAddress.toLowerCase();
        });
        const updatedToken = { ...tokens[tokenIndex], isERC721 };
        tokens[tokenIndex] = updatedToken;
        this.update((state) => {
            state.allTokens[chainIdToUse][accountAddress] = tokens;
        });
        return updatedToken;
    }
    /**
     * Adds a new suggestedAsset to the list of watched assets.
     * Parameters will be validated according to the asset type being watched.
     *
     * @param options - The method options.
     * @param options.asset - The asset to be watched. For now only ERC20 tokens are accepted.
     * @param options.type - The asset type.
     * @param options.interactingAddress - The address of the account that is requesting to watch the asset.
     * @param options.networkClientId - Network Client ID.
     * @returns A promise that resolves if the asset was watched successfully, and rejects otherwise.
     */
    async watchAsset({ asset, type, interactingAddress, networkClientId, }) {
        if (type !== controller_utils_1.ERC20) {
            throw new Error(`Asset of type ${type} not supported`);
        }
        if (!asset.address) {
            throw rpc_errors_1.rpcErrors.invalidParams('Address must be specified');
        }
        if (!(0, controller_utils_1.isValidHexAddress)(asset.address)) {
            throw rpc_errors_1.rpcErrors.invalidParams(`Invalid address "${asset.address}"`);
        }
        const selectedAddress = __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_getAddressOrSelectedAddress).call(this, interactingAddress);
        // Validate contract
        if (await __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_detectIsERC721).call(this, asset.address, networkClientId)) {
            throw rpc_errors_1.rpcErrors.invalidParams(
            // TODO: Either fix this lint violation or explain why it's necessary to ignore.
            // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
            `Contract ${asset.address} must match type ${type}, but was detected as ${controller_utils_1.ERC721}`);
        }
        const provider = __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_getProvider).call(this, networkClientId);
        const isErc1155 = await (0, controller_utils_1.safelyExecute)(() => new ERC1155Standard_1.ERC1155Standard(provider).contractSupportsBase1155Interface(asset.address));
        if (isErc1155) {
            throw rpc_errors_1.rpcErrors.invalidParams(
            // TODO: Either fix this lint violation or explain why it's necessary to ignore.
            // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
            `Contract ${asset.address} must match type ${type}, but was detected as ${controller_utils_1.ERC1155}`);
        }
        const erc20 = new ERC20Standard_1.ERC20Standard(provider);
        const [contractName, contractSymbol, contractDecimals] = await Promise.all([
            (0, controller_utils_1.safelyExecute)(() => erc20.getTokenName(asset.address)),
            (0, controller_utils_1.safelyExecute)(() => erc20.getTokenSymbol(asset.address)),
            (0, controller_utils_1.safelyExecute)(async () => erc20.getTokenDecimals(asset.address)),
        ]);
        asset.name = contractName;
        // Validate symbol
        if (!asset.symbol && !contractSymbol) {
            throw rpc_errors_1.rpcErrors.invalidParams('A symbol is required, but was not found in either the request or contract');
        }
        if (contractSymbol !== undefined &&
            asset.symbol !== undefined &&
            asset.symbol.toUpperCase() !== contractSymbol.toUpperCase()) {
            throw rpc_errors_1.rpcErrors.invalidParams(
            // TODO: Either fix this lint violation or explain why it's necessary to ignore.
            // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
            `The symbol in the request (${asset.symbol}) does not match the symbol in the contract (${contractSymbol})`);
        }
        asset.symbol = contractSymbol ?? asset.symbol;
        if (typeof asset.symbol !== 'string') {
            throw rpc_errors_1.rpcErrors.invalidParams(`Invalid symbol: not a string`);
        }
        if (asset.symbol.length > 11) {
            throw rpc_errors_1.rpcErrors.invalidParams(`Invalid symbol "${asset.symbol}": longer than 11 characters`);
        }
        // Validate decimals
        if (asset.decimals === undefined && contractDecimals === undefined) {
            throw rpc_errors_1.rpcErrors.invalidParams('Decimals are required, but were not found in either the request or contract');
        }
        if (contractDecimals !== undefined &&
            asset.decimals !== undefined &&
            String(asset.decimals) !== contractDecimals) {
            throw rpc_errors_1.rpcErrors.invalidParams(
            // TODO: Either fix this lint violation or explain why it's necessary to ignore.
            // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
            `The decimals in the request (${asset.decimals}) do not match the decimals in the contract (${contractDecimals})`);
        }
        const decimalsStr = contractDecimals ?? asset.decimals;
        const decimalsNum = parseInt(decimalsStr, 10);
        if (!Number.isInteger(decimalsNum) || decimalsNum > 36 || decimalsNum < 0) {
            throw rpc_errors_1.rpcErrors.invalidParams(
            // TODO: Either fix this lint violation or explain why it's necessary to ignore.
            // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
            `Invalid decimals "${decimalsStr}": must be an integer 0 <= 36`);
        }
        asset.decimals = decimalsNum;
        const suggestedAssetMeta = {
            asset,
            id: __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_generateRandomId).call(this),
            time: Date.now(),
            type,
            interactingAddress: selectedAddress,
        };
        await __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_requestApproval).call(this, suggestedAssetMeta);
        const { address, symbol, decimals, name, image } = asset;
        await this.addToken({
            address,
            symbol,
            decimals,
            name,
            image,
            interactingAddress: suggestedAssetMeta.interactingAddress,
            networkClientId,
        });
    }
    /**
     * Removes all tokens from the ignored list.
     */
    clearIgnoredTokens() {
        this.update((state) => {
            state.allIgnoredTokens = {};
        });
    }
    /**
     * Reset the controller state to the default state.
     */
    resetState() {
        this.update(() => {
            return (0, exports.getDefaultTokensState)();
        });
    }
}
exports.TokensController = TokensController;
_TokensController_mutex = new WeakMap(), _TokensController_selectedAccountId = new WeakMap(), _TokensController_provider = new WeakMap(), _TokensController_abortController = new WeakMap(), _TokensController_instances = new WeakSet(), _TokensController_handleOnAccountRemoved = function _TokensController_handleOnAccountRemoved(accountAddress) {
    const isEthAddress = (0, utils_1.isStrictHexString)(accountAddress.toLowerCase()) &&
        (0, controller_utils_1.isValidHexAddress)(accountAddress);
    if (!isEthAddress) {
        return;
    }
    const { allTokens, allIgnoredTokens, allDetectedTokens } = this.state;
    const newAllTokens = (0, lodash_1.cloneDeep)(allTokens);
    const newAllDetectedTokens = (0, lodash_1.cloneDeep)(allDetectedTokens);
    const newAllIgnoredTokens = (0, lodash_1.cloneDeep)(allIgnoredTokens);
    for (const chainId of Object.keys(newAllTokens)) {
        if (newAllTokens[chainId][accountAddress]) {
            delete newAllTokens[chainId][accountAddress];
        }
    }
    for (const chainId of Object.keys(newAllDetectedTokens)) {
        if (newAllDetectedTokens[chainId][accountAddress]) {
            delete newAllDetectedTokens[chainId][accountAddress];
        }
    }
    for (const chainId of Object.keys(newAllIgnoredTokens)) {
        if (newAllIgnoredTokens[chainId][accountAddress]) {
            delete newAllIgnoredTokens[chainId][accountAddress];
        }
    }
    this.update((state) => {
        state.allTokens = newAllTokens;
        state.allIgnoredTokens = newAllIgnoredTokens;
        state.allDetectedTokens = newAllDetectedTokens;
    });
}, _TokensController_onNetworkStateChange = function _TokensController_onNetworkStateChange(_, patches) {
    // Remove state for deleted networks
    for (const patch of patches) {
        if (patch.op === 'remove' &&
            patch.path[0] === 'networkConfigurationsByChainId') {
            const removedChainId = patch.path[1];
            this.update((state) => {
                delete state.allTokens[removedChainId];
                delete state.allIgnoredTokens[removedChainId];
                delete state.allDetectedTokens[removedChainId];
            });
        }
    }
}, _TokensController_onSelectedAccountChange = function _TokensController_onSelectedAccountChange(selectedAccount) {
    __classPrivateFieldSet(this, _TokensController_selectedAccountId, selectedAccount.id, "f");
}, _TokensController_fetchTokenMetadata = 
/**
 * Fetch metadata for a token.
 *
 * @param tokenAddress - The address of the token.
 * @param chainId - The chain ID of the network on which the token is detected.
 * @returns The token metadata.
 */
async function _TokensController_fetchTokenMetadata(tokenAddress, chainId) {
    try {
        const token = await (0, token_service_1.fetchTokenMetadata)(chainId, tokenAddress, __classPrivateFieldGet(this, _TokensController_abortController, "f").signal);
        return token;
    }
    catch (error) {
        if (error instanceof Error &&
            error.message.includes(token_service_1.TOKEN_METADATA_NO_SUPPORT_ERROR)) {
            return undefined;
        }
        throw error;
    }
}, _TokensController_detectIsERC721 = 
/**
 * Detects whether or not a token is ERC-721 compatible.
 *
 * @param tokenAddress - The token contract address.
 * @param networkClientId - Optional network client ID to fetch contract info with.
 * @returns A boolean indicating whether the token address passed in supports the EIP-721
 * interface.
 */
async function _TokensController_detectIsERC721(tokenAddress, networkClientId) {
    const checksumAddress = (0, controller_utils_1.toChecksumHexAddress)(tokenAddress);
    // if this token is already in our contract metadata map we don't need
    // to check against the contract
    if (contract_metadata_1.default[checksumAddress]?.erc721 === true) {
        return Promise.resolve(true);
    }
    else if (contract_metadata_1.default[checksumAddress]?.erc20 === true) {
        return Promise.resolve(false);
    }
    const tokenContract = __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_createEthersContract).call(this, tokenAddress, metamask_eth_abis_1.abiERC721, networkClientId);
    try {
        return await tokenContract.supportsInterface(controller_utils_1.ERC721_INTERFACE_ID);
    }
    catch (error) {
        // currently we see a variety of errors across different networks when
        // token contracts are not ERC721 compatible. We need to figure out a better
        // way of differentiating token interface types but for now if we get an error
        // we have to assume the token is not ERC721 compatible.
        return false;
    }
}, _TokensController_getProvider = function _TokensController_getProvider(networkClientId) {
    return new providers_1.Web3Provider(networkClientId
        ? this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId).provider
        : __classPrivateFieldGet(this, _TokensController_provider, "f"));
}, _TokensController_createEthersContract = function _TokensController_createEthersContract(tokenAddress, abi, networkClientId) {
    const web3provider = __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_getProvider).call(this, networkClientId);
    const tokenContract = new contracts_1.Contract(tokenAddress, abi, web3provider);
    return tokenContract;
}, _TokensController_generateRandomId = function _TokensController_generateRandomId() {
    return (0, uuid_1.v1)();
}, _TokensController_getNewAllTokensState = function _TokensController_getNewAllTokensState(params) {
    const { newTokens, newIgnoredTokens, newDetectedTokens, interactingAddress, interactingChainId, } = params;
    const { allTokens, allIgnoredTokens, allDetectedTokens } = this.state;
    const userAddressToAddTokens = __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_getAddressOrSelectedAddress).call(this, interactingAddress);
    let newAllTokens = allTokens;
    if (newTokens?.length ||
        (newTokens &&
            allTokens &&
            allTokens[interactingChainId] &&
            allTokens[interactingChainId][userAddressToAddTokens])) {
        const networkTokens = allTokens[interactingChainId];
        const newNetworkTokens = {
            ...networkTokens,
            ...{ [userAddressToAddTokens]: newTokens },
        };
        newAllTokens = {
            ...allTokens,
            ...{ [interactingChainId]: newNetworkTokens },
        };
    }
    let newAllIgnoredTokens = allIgnoredTokens;
    if (newIgnoredTokens?.length ||
        (newIgnoredTokens &&
            allIgnoredTokens &&
            allIgnoredTokens[interactingChainId] &&
            allIgnoredTokens[interactingChainId][userAddressToAddTokens])) {
        const networkIgnoredTokens = allIgnoredTokens[interactingChainId];
        const newIgnoredNetworkTokens = {
            ...networkIgnoredTokens,
            ...{ [userAddressToAddTokens]: newIgnoredTokens },
        };
        newAllIgnoredTokens = {
            ...allIgnoredTokens,
            ...{ [interactingChainId]: newIgnoredNetworkTokens },
        };
    }
    let newAllDetectedTokens = allDetectedTokens;
    if (newDetectedTokens?.length ||
        (newDetectedTokens &&
            allDetectedTokens &&
            allDetectedTokens[interactingChainId] &&
            allDetectedTokens[interactingChainId][userAddressToAddTokens])) {
        const networkDetectedTokens = allDetectedTokens[interactingChainId];
        const newDetectedNetworkTokens = {
            ...networkDetectedTokens,
            ...{ [userAddressToAddTokens]: newDetectedTokens },
        };
        newAllDetectedTokens = {
            ...allDetectedTokens,
            ...{ [interactingChainId]: newDetectedNetworkTokens },
        };
    }
    return { newAllTokens, newAllIgnoredTokens, newAllDetectedTokens };
}, _TokensController_getAddressOrSelectedAddress = function _TokensController_getAddressOrSelectedAddress(address) {
    if (address) {
        return address;
    }
    return __classPrivateFieldGet(this, _TokensController_instances, "m", _TokensController_getSelectedAddress).call(this);
}, _TokensController_requestApproval = async function _TokensController_requestApproval(suggestedAssetMeta) {
    return this.messagingSystem.call('ApprovalController:addRequest', {
        id: suggestedAssetMeta.id,
        origin: controller_utils_1.ORIGIN_METAMASK,
        type: controller_utils_1.ApprovalType.WatchAsset,
        requestData: {
            id: suggestedAssetMeta.id,
            interactingAddress: suggestedAssetMeta.interactingAddress,
            asset: {
                address: suggestedAssetMeta.asset.address,
                decimals: suggestedAssetMeta.asset.decimals,
                symbol: suggestedAssetMeta.asset.symbol,
                image: suggestedAssetMeta.asset.image || null,
            },
        },
    }, true);
}, _TokensController_getSelectedAccount = function _TokensController_getSelectedAccount() {
    return this.messagingSystem.call('AccountsController:getSelectedAccount');
}, _TokensController_getSelectedAddress = function _TokensController_getSelectedAddress() {
    // If the address is not defined (or empty), we fallback to the currently selected account's address
    const account = this.messagingSystem.call('AccountsController:getAccount', __classPrivateFieldGet(this, _TokensController_selectedAccountId, "f"));
    return account?.address || '';
};
exports.default = TokensController;

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\TokensController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\assetsUtil.cjs", {"@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","bn.js":"D:\\code\\v\\metamask-extension\\node_modules\\bn.js\\lib\\bn.js","multiformats":"D:\\code\\v\\metamask-extension\\node_modules\\multiformats\\cjs\\src\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5CassetsUtil.cjs
      return function (require, module, exports) {
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { newObj[key] = obj[key]; } } } newObj.default = obj; return newObj; } }
exports.accountAddressToCaipReference = exports.getKeyByValue = exports.fetchTokenContractExchangeRates = exports.reduceInBatchesSerially = exports.divideIntoBatches = exports.ethersBigNumberToBN = exports.addUrlProtocolPrefix = exports.getFormattedIpfsUrl = exports.getIpfsCIDv1AndPath = exports.removeIpfsProtocolPrefix = exports.isTokenListSupportedForNetwork = exports.isTokenDetectionSupportedForNetwork = exports.SupportedStakedBalanceNetworks = exports.SupportedTokenDetectionNetworks = exports.formatIconUrlWithProxy = exports.formatAggregatorNames = exports.hasNewCollectionFields = exports.compareNftMetadata = exports.TOKEN_PRICES_BATCH_SIZE = void 0;
const controller_utils_1 = require("@metamask/controller-utils");
const utils_1 = require("@metamask/utils");
const bn_js_1 = __importDefault(require("bn.js"));
/**
 * The maximum number of token addresses that should be sent to the Price API in
 * a single request.
 */
exports.TOKEN_PRICES_BATCH_SIZE = 30;
/**
 * Compares nft metadata entries to any nft entry.
 * We need this method when comparing a new fetched nft metadata, in case a entry changed to a defined value,
 * there's a need to update the nft in state.
 *
 * @param newNftMetadata - Nft metadata object.
 * @param nft - Nft object to compare with.
 * @returns Whether there are differences.
 */
function compareNftMetadata(newNftMetadata, nft) {
    const keys = [
        'image',
        'backgroundColor',
        'imagePreview',
        'imageThumbnail',
        'imageOriginal',
        'animation',
        'animationOriginal',
        'externalLink',
        'tokenURI',
        'chainId',
    ];
    const differentValues = keys.reduce((value, key) => {
        if (newNftMetadata[key] && newNftMetadata[key] !== nft[key]) {
            return value + 1;
        }
        return value;
    }, 0);
    return differentValues > 0;
}
exports.compareNftMetadata = compareNftMetadata;
/**
 * Checks whether the existing nft object has all the keys of the new incoming nft metadata object
 * @param newNftMetadata - New nft metadata object
 * @param nft - Existing nft object to compare with
 * @returns Whether the existing nft object has all the new keys from the new Nft metadata object
 */
function hasNewCollectionFields(newNftMetadata, nft) {
    const keysNewNftMetadata = Object.keys(newNftMetadata.collection ?? {});
    const keysExistingNft = new Set(Object.keys(nft.collection ?? {}));
    return keysNewNftMetadata.some((key) => !keysExistingNft.has(key));
}
exports.hasNewCollectionFields = hasNewCollectionFields;
const aggregatorNameByKey = {
    aave: 'Aave',
    bancor: 'Bancor',
    cmc: 'CMC',
    cryptocom: 'Crypto.com',
    coinGecko: 'CoinGecko',
    oneInch: '1inch',
    paraswap: 'Paraswap',
    pmm: 'PMM',
    zapper: 'Zapper',
    zerion: 'Zerion',
    zeroEx: '0x',
    synthetix: 'Synthetix',
    yearn: 'Yearn',
    apeswap: 'ApeSwap',
    binanceDex: 'BinanceDex',
    pancakeTop100: 'PancakeTop100',
    pancakeExtended: 'PancakeExtended',
    balancer: 'Balancer',
    quickswap: 'QuickSwap',
    matcha: 'Matcha',
    pangolinDex: 'PangolinDex',
    pangolinDexStableCoin: 'PangolinDexStableCoin',
    pangolinDexAvaxBridge: 'PangolinDexAvaxBridge',
    traderJoe: 'TraderJoe',
    airswapLight: 'AirswapLight',
    kleros: 'Kleros',
};
/**
 * Formats aggregator names to presentable format.
 *
 * @param aggregators - List of token list names in camelcase.
 * @returns Formatted aggregator names.
 */
const formatAggregatorNames = (aggregators) => {
    return aggregators.map((key) => aggregatorNameByKey[key] ||
        `${key[0].toUpperCase()}${key.substring(1, key.length)}`);
};
exports.formatAggregatorNames = formatAggregatorNames;
/**
 * Format token list assets to use image proxy from Codefi.
 *
 * @param params - Object that contains chainID and tokenAddress.
 * @param params.chainId - ChainID of network in 0x-prefixed hexadecimal format.
 * @param params.tokenAddress - Address of token in mixed or lowercase.
 * @returns Formatted image url
 */
const formatIconUrlWithProxy = ({ chainId, tokenAddress, }) => {
    const chainIdDecimal = (0, controller_utils_1.convertHexToDecimal)(chainId).toString();
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    return `https://static.cx.metamask.io/api/v1/tokenIcons/${chainIdDecimal}/${tokenAddress.toLowerCase()}.png`;
};
exports.formatIconUrlWithProxy = formatIconUrlWithProxy;
/**
 * Networks where token detection is supported - Values are in hex format
 */
var SupportedTokenDetectionNetworks;
(function (SupportedTokenDetectionNetworks) {
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    SupportedTokenDetectionNetworks["mainnet"] = "0x1";
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    SupportedTokenDetectionNetworks["bsc"] = "0x38";
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    SupportedTokenDetectionNetworks["polygon"] = "0x89";
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    SupportedTokenDetectionNetworks["avax"] = "0xa86a";
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    SupportedTokenDetectionNetworks["aurora"] = "0x4e454152";
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    SupportedTokenDetectionNetworks["linea_goerli"] = "0xe704";
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    SupportedTokenDetectionNetworks["linea_mainnet"] = "0xe708";
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    SupportedTokenDetectionNetworks["arbitrum"] = "0xa4b1";
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    SupportedTokenDetectionNetworks["optimism"] = "0xa";
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    SupportedTokenDetectionNetworks["base"] = "0x2105";
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    SupportedTokenDetectionNetworks["zksync"] = "0x144";
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    SupportedTokenDetectionNetworks["cronos"] = "0x19";
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    SupportedTokenDetectionNetworks["celo"] = "0xa4ec";
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    SupportedTokenDetectionNetworks["gnosis"] = "0x64";
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    SupportedTokenDetectionNetworks["fantom"] = "0xfa";
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    SupportedTokenDetectionNetworks["polygon_zkevm"] = "0x44d";
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    SupportedTokenDetectionNetworks["moonbeam"] = "0x504";
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    SupportedTokenDetectionNetworks["moonriver"] = "0x505";
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    SupportedTokenDetectionNetworks["sei"] = "0x531";
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    SupportedTokenDetectionNetworks["monad_mainnet"] = "0x8f";
})(SupportedTokenDetectionNetworks || (exports.SupportedTokenDetectionNetworks = SupportedTokenDetectionNetworks = {}));
/**
 * Networks where staked balance is supported - Values are in hex format
 */
var SupportedStakedBalanceNetworks;
(function (SupportedStakedBalanceNetworks) {
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    SupportedStakedBalanceNetworks["mainnet"] = "0x1";
    // TODO: Either fix this lint violation or explain why it's necessary to ignore.
    // eslint-disable-next-line @typescript-eslint/naming-convention
    SupportedStakedBalanceNetworks["hoodi"] = "0x88bb0";
})(SupportedStakedBalanceNetworks || (exports.SupportedStakedBalanceNetworks = SupportedStakedBalanceNetworks = {}));
/**
 * Check if token detection is enabled for certain networks.
 *
 * @param chainId - ChainID of network
 * @returns Whether the current network supports token detection
 */
function isTokenDetectionSupportedForNetwork(chainId) {
    return Object.values(SupportedTokenDetectionNetworks).includes(chainId);
}
exports.isTokenDetectionSupportedForNetwork = isTokenDetectionSupportedForNetwork;
/**
 * Check if token list polling is enabled for a given network.
 * Currently this method is used to support e2e testing for consumers of this package.
 *
 * @param chainId - ChainID of network
 * @returns Whether the current network supports tokenlists
 */
function isTokenListSupportedForNetwork(chainId) {
    return isTokenDetectionSupportedForNetwork(chainId);
}
exports.isTokenListSupportedForNetwork = isTokenListSupportedForNetwork;
/**
 * Removes IPFS protocol prefix from input string.
 *
 * @param ipfsUrl - An IPFS url (e.g. ipfs://{content id})
 * @returns IPFS content identifier and (possibly) path in a string
 * @throws Will throw if the url passed is not IPFS.
 */
function removeIpfsProtocolPrefix(ipfsUrl) {
    if (ipfsUrl.startsWith('ipfs://ipfs/')) {
        return ipfsUrl.replace('ipfs://ipfs/', '');
    }
    else if (ipfsUrl.startsWith('ipfs://')) {
        return ipfsUrl.replace('ipfs://', '');
    }
    // this method should not be used with non-ipfs urls (i.e. startsWith('ipfs://') === true)
    throw new Error('this method should not be used with non ipfs urls');
}
exports.removeIpfsProtocolPrefix = removeIpfsProtocolPrefix;
/**
 * Extracts content identifier and path from an input string.
 *
 * @param ipfsUrl - An IPFS URL minus the IPFS protocol prefix
 * @returns IFPS content identifier (cid) and sub path as string.
 * @throws Will throw if the url passed is not ipfs.
 */
async function getIpfsCIDv1AndPath(ipfsUrl) {
    const url = removeIpfsProtocolPrefix(ipfsUrl);
    // check if there is a path
    // (CID is everything preceding first forward slash, path is everything after)
    const index = url.indexOf('/');
    const cid = index !== -1 ? url.substring(0, index) : url;
    const path = index !== -1 ? url.substring(index) : undefined;
    // Dynamic import is used here in `core` for CJS compatbility, because 'multiformats' is ESM-
    // only. However, dynamic import is not supported by LavaMoat.
    // See here for details: https://github.com/MetaMask/metamask-extension/pull/27629#discussion_r1791797810
    // TODO: Attempt deleting this patch after migrating to Webpack, which may support dynamic
    // import with LavaMoat.
    const { CID } = _interopRequireWildcard(require("multiformats"));
    // We want to ensure that the CID is v1 (https://docs.ipfs.io/concepts/content-addressing/#identifier-formats)
    // because most cid v0s appear to be incompatible with IPFS subdomains
    return {
        cid: CID.parse(cid).toV1().toString(),
        path,
    };
}
exports.getIpfsCIDv1AndPath = getIpfsCIDv1AndPath;
/**
 * Formats URL correctly for use retrieving assets hosted on IPFS.
 *
 * @param ipfsGateway - The users preferred IPFS gateway (full URL or just host).
 * @param ipfsUrl - The IFPS URL pointed at the asset.
 * @param subdomainSupported - Boolean indicating whether the URL should be formatted with subdomains or not.
 * @returns A formatted URL, with the user's preferred IPFS gateway and format (subdomain or not), pointing to an asset hosted on IPFS.
 */
async function getFormattedIpfsUrl(ipfsGateway, ipfsUrl, subdomainSupported) {
    const { host, protocol, origin } = new URL(addUrlProtocolPrefix(ipfsGateway));
    if (subdomainSupported) {
        const { cid, path } = await getIpfsCIDv1AndPath(ipfsUrl);
        return `${protocol}//${cid}.ipfs.${host}${path ?? ''}`;
    }
    const cidAndPath = removeIpfsProtocolPrefix(ipfsUrl);
    return `${origin}/ipfs/${cidAndPath}`;
}
exports.getFormattedIpfsUrl = getFormattedIpfsUrl;
/**
 * Adds URL protocol prefix to input URL string if missing.
 *
 * @param urlString - An IPFS URL.
 * @returns A URL with a https:// prepended.
 */
function addUrlProtocolPrefix(urlString) {
    if (!urlString.match(/(^http:\/\/)|(^https:\/\/)/u)) {
        return `https://${urlString}`;
    }
    return urlString;
}
exports.addUrlProtocolPrefix = addUrlProtocolPrefix;
/**
 * Converts an Ethers BigNumber to a BN.
 *
 * @param bigNumber - An Ethers BigNumber instance.
 * @returns A BN object.
 */
function ethersBigNumberToBN(bigNumber) {
    return new bn_js_1.default((0, utils_1.remove0x)(bigNumber.toHexString()), 'hex');
}
exports.ethersBigNumberToBN = ethersBigNumberToBN;
/**
 * Partitions a list of values into groups that are at most `batchSize` in
 * length.
 *
 * @param values - The list of values.
 * @param args - The remaining arguments.
 * @param args.batchSize - The desired maximum number of values per batch.
 * @returns The list of batches.
 */
function divideIntoBatches(values, { batchSize }) {
    const batches = [];
    for (let i = 0; i < values.length; i += batchSize) {
        batches.push(values.slice(i, i + batchSize));
    }
    return batches;
}
exports.divideIntoBatches = divideIntoBatches;
/**
 * Constructs a result from processing batches of the given values
 * sequentially.
 *
 * @param args - The arguments to this function.
 * @param args.values - A list of values to iterate over.
 * @param args.batchSize - The maximum number of values in each batch.
 * @param args.eachBatch - A function to call for each batch. This function is
 * similar to the function that `Array.prototype.reduce` takes, in that it
 * receives the object that is being built, each batch in the list of batches
 * and the index, and should return an updated version of the object.
 * @param args.initialResult - The initial value of the final data structure,
 * i.e., the value that will be fed into the first call of `eachBatch`.
 * @returns The built result.
 */
async function reduceInBatchesSerially({ values, batchSize, eachBatch, initialResult, }) {
    const batches = divideIntoBatches(values, { batchSize });
    let workingResult = initialResult;
    for (const [index, batch] of batches.entries()) {
        workingResult = await eachBatch(workingResult, batch, index);
    }
    // There's no way around this — we have to assume that in the end, the result
    // matches the intended type.
    const finalResult = workingResult;
    return finalResult;
}
exports.reduceInBatchesSerially = reduceInBatchesSerially;
/**
 * Retrieves token prices for a set of contract addresses in a specific currency and chainId.
 *
 * @param args - The arguments to function.
 * @param args.tokenPricesService - An object in charge of retrieving token prices.
 * @param args.nativeCurrency - The native currency to request price in.
 * @param args.tokenAddresses - The list of contract addresses.
 * @param args.chainId - The chainId of the tokens.
 * @returns The prices for the requested tokens.
 */
async function fetchTokenContractExchangeRates({ tokenPricesService, nativeCurrency, tokenAddresses, chainId, }) {
    const isChainIdSupported = tokenPricesService.validateChainIdSupported(chainId);
    const isCurrencySupported = tokenPricesService.validateCurrencySupported(nativeCurrency);
    if (!isChainIdSupported || !isCurrencySupported) {
        return {};
    }
    const tokenPricesByTokenAddress = await reduceInBatchesSerially({
        values: [...tokenAddresses].sort(),
        batchSize: exports.TOKEN_PRICES_BATCH_SIZE,
        eachBatch: async (allTokenPricesByTokenAddress, batch) => {
            const tokenPricesByTokenAddressForBatch = await tokenPricesService.fetchTokenPrices({
                tokenAddresses: batch,
                chainId,
                currency: nativeCurrency,
            });
            return {
                ...allTokenPricesByTokenAddress,
                ...tokenPricesByTokenAddressForBatch,
            };
        },
        initialResult: {},
    });
    return Object.entries(tokenPricesByTokenAddress).reduce((obj, [tokenAddress, tokenPrice]) => {
        return {
            ...obj,
            [(0, controller_utils_1.toChecksumHexAddress)(tokenAddress)]: tokenPrice?.price,
        };
    }, {});
}
exports.fetchTokenContractExchangeRates = fetchTokenContractExchangeRates;
/**
 * Function to search for a specific value in a given map and return the key
 * @param map - map input to search value
 * @param value - the value to search for
 * @returns returns key that corresponds to the value
 */
function getKeyByValue(map, value) {
    for (const [key, val] of map.entries()) {
        if (val === value) {
            return key;
        }
    }
    return null; // Return null if no match is found
}
exports.getKeyByValue = getKeyByValue;
/**
 * Converts a hex chainId and account address to a CAIP account reference.
 *
 * @param chainId - The hex chain ID
 * @param accountAddress - The account address
 * @returns The CAIP account reference in format "namespace:reference:address"
 */
function accountAddressToCaipReference(chainId, accountAddress) {
    const caipChainId = (0, utils_1.toCaipChainId)(utils_1.KnownCaipNamespace.Eip155, (0, utils_1.hexToNumber)(chainId).toString());
    return `${caipChainId}:${accountAddress}`;
}
exports.accountAddressToCaipReference = accountAddressToCaipReference;

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\assetsUtil.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\balances.cjs", {"./AssetsContractController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\AssetsContractController.cjs","./token-prices-service/codefi-v2.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\token-prices-service\\codefi-v2.cjs","@metamask/account-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-api\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5Cbalances.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.calculateBalanceChangeForAccountGroup = exports.calculateBalanceChangeForAllWallets = exports.calculateBalanceForAllWallets = void 0;
const account_api_1 = require("@metamask/account-api");
const keyring_api_1 = require("@metamask/keyring-api");
const utils_1 = require("@metamask/utils");
const AssetsContractController_1 = require("./AssetsContractController.cjs");
const codefi_v2_1 = require("./token-prices-service/codefi-v2.cjs");
const evmRatePropertiesRecord = {
    '1d': 'pricePercentChange1d',
    '7d': 'pricePercentChange7d',
    '30d': 'pricePercentChange30d',
};
const nonEvmRatePropertiesRecord = {
    '1d': 'P1D',
    '7d': 'P7D',
    '30d': 'P30D',
};
const isChainEnabledByMap = (map, id) => {
    if (!map) {
        return true;
    }
    if ((0, utils_1.isStrictHexString)(id)) {
        return Boolean(map[utils_1.KnownCaipNamespace.Eip155]?.[id]);
    }
    const { namespace } = (0, utils_1.parseCaipChainId)(id);
    return Boolean(map[namespace]?.[id]);
};
const getInternalAccountsForGroup = (accountTreeState, accountsState, groupId) => {
    const walletId = (0, account_api_1.parseAccountGroupId)(groupId).wallet.id;
    const wallet = accountTreeState.accountTree.wallets[walletId];
    if (!wallet) {
        return [];
    }
    const group = wallet.groups[groupId];
    if (!group) {
        return [];
    }
    return group.accounts
        .map((accountId) => accountsState.internalAccounts.accounts[accountId])
        .filter(Boolean);
};
const isNonNaNNumber = (value) => typeof value === 'number' && !Number.isNaN(value);
/**
 * Combined function that gets valid token balances with calculation data
 *
 * @param account - Internal account.
 * @param tokenBalancesState - Token balances state.
 * @param tokensState - Tokens state.
 * @param tokenRatesState - Token rates state.
 * @param currencyRateState - Currency rate state.
 * @param isEvmChainEnabled - Predicate to check EVM chain enablement.
 * @returns token calculation data
 */
function getEvmTokenBalances(account, tokenBalancesState, tokensState, tokenRatesState, currencyRateState, isEvmChainEnabled) {
    const ZERO_ADDRESS = '0x0000000000000000000000000000000000000000';
    const accountBalances = tokenBalancesState.tokenBalances[account.address] ?? {};
    return Object.entries(accountBalances)
        .filter(([chainId]) => isEvmChainEnabled(chainId))
        .flatMap(([chainId, chainBalances]) => Object.entries(chainBalances).map(([tokenAddress, balance]) => ({
        chainId: chainId,
        tokenAddress: tokenAddress,
        balance,
    })))
        .map((tokenBalance) => {
        const { chainId, tokenAddress, balance } = tokenBalance;
        const stakingContractAddress = AssetsContractController_1.STAKING_CONTRACT_ADDRESS_BY_CHAINID[chainId];
        const isNative = tokenAddress === ZERO_ADDRESS;
        const isStakedNative = stakingContractAddress
            ? tokenAddress.toLowerCase() === stakingContractAddress.toLowerCase()
            : false;
        // Get Token Info (skip allTokens check for native and staked native)
        if (!isNative && !isStakedNative) {
            const accountTokens = tokensState?.allTokens?.[chainId]?.[account.address];
            const token = accountTokens?.find((t) => t.address === tokenAddress);
            if (!token) {
                return null;
            }
        }
        // Get market data
        const marketDataAddress = isNative || isStakedNative
            ? (0, codefi_v2_1.getNativeTokenAddress)(chainId)
            : tokenAddress;
        const tokenMarketData = tokenRatesState?.marketData?.[chainId]?.[marketDataAddress];
        if (!tokenMarketData?.price) {
            return null;
        }
        // Get conversion rate
        const nativeToUserRate = currencyRateState.currencyRates[tokenMarketData.currency]
            ?.conversionRate;
        if (!nativeToUserRate) {
            return null;
        }
        // Calculate values
        let decimals = 18;
        if (!isNative && !isStakedNative) {
            const accountTokens = tokensState?.allTokens?.[chainId]?.[account.address];
            const token = accountTokens?.find((t) => t.address === tokenAddress);
            decimals = isNonNaNNumber(token?.decimals)
                ? token?.decimals
                : 18;
        }
        const decimalBalance = parseInt(balance, 16);
        if (!isNonNaNNumber(decimalBalance)) {
            return null;
        }
        const userCurrencyValue = (decimalBalance / Math.pow(10, decimals)) *
            tokenMarketData.price *
            nativeToUserRate;
        return {
            userCurrencyValue,
            tokenMarketData, // Only needed for change calculations
        };
    })
        .filter((item) => item !== null);
}
/**
 * Combined function that gets valid non-EVM asset balances with calculation data
 *
 * @param account - Internal account.
 * @param multichainBalancesState - Multichain balances state.
 * @param multichainRatesState - Multichain rates state.
 * @param isAssetChainEnabled - Predicate to check asset chain enablement.
 * @returns token calculation data
 */
function getNonEvmAssetBalances(account, multichainBalancesState, multichainRatesState, isAssetChainEnabled) {
    const accountBalances = multichainBalancesState.balances[account.id] ?? {};
    return Object.entries(accountBalances)
        .filter(([assetId]) => isAssetChainEnabled(assetId))
        .map(([assetId, balanceData]) => {
        const balanceAmount = parseFloat(balanceData.amount);
        if (Number.isNaN(balanceAmount)) {
            return null;
        }
        const conversionRate = multichainRatesState.conversionRates[assetId];
        if (!conversionRate) {
            return null;
        }
        const conversionRateValue = parseFloat(conversionRate.rate);
        if (Number.isNaN(conversionRateValue)) {
            return null;
        }
        const userCurrencyValue = balanceAmount * conversionRateValue;
        return {
            assetId: assetId,
            userCurrencyValue,
            conversionRate, // Only needed for change calculations
        };
    })
        .filter((item) => item !== null);
}
/**
 * Sum EVM account token balances in user currency.
 *
 * @param account - Internal account.
 * @param tokenBalancesState - Token balances state.
 * @param tokensState - Tokens state.
 * @param tokenRatesState - Token rates state.
 * @param currencyRateState - Currency rate state.
 * @param isEvmChainEnabled - Predicate to check EVM chain enablement.
 * @returns Total value in user currency.
 */
function sumEvmAccountBalanceInUserCurrency(account, tokenBalancesState, tokensState, tokenRatesState, currencyRateState, isEvmChainEnabled) {
    const tokenBalances = getEvmTokenBalances(account, tokenBalancesState, tokensState, tokenRatesState, currencyRateState, isEvmChainEnabled);
    return tokenBalances.reduce((a, b) => a + b.userCurrencyValue, 0);
}
/**
 * Sum non‑EVM account balances in user currency from multichain sources.
 *
 * @param account - Internal account.
 * @param multichainBalancesState - Multichain balances state.
 * @param multichainRatesState - Multichain rates state.
 * @param isAssetChainEnabled - Predicate to check asset chain enablement.
 * @returns Total value in user currency.
 */
function sumNonEvmAccountBalanceInUserCurrency(account, multichainBalancesState, multichainRatesState, isAssetChainEnabled) {
    const assetBalances = getNonEvmAssetBalances(account, multichainBalancesState, multichainRatesState, isAssetChainEnabled);
    return assetBalances.reduce((a, b) => a + b.userCurrencyValue, 0);
}
/**
 * Calculate balances for all wallets and groups.
 * Pure function – accepts controller states and returns aggregated totals.
 *
 * @param accountTreeState - AccountTreeController state
 * @param accountsState - AccountsController state
 * @param tokenBalancesState - TokenBalancesController state
 * @param tokenRatesState - TokenRatesController state
 * @param multichainRatesState - MultichainAssetsRatesController state
 * @param multichainBalancesState - MultichainBalancesController state
 * @param tokensState - TokensController state
 * @param currencyRateState - CurrencyRateController state
 * @param enabledNetworkMap - Map of enabled networks keyed by namespace
 * @returns Aggregated balances for all wallets
 */
function calculateBalanceForAllWallets(accountTreeState, accountsState, tokenBalancesState, tokenRatesState, multichainRatesState, multichainBalancesState, tokensState, currencyRateState, enabledNetworkMap) {
    const isEvmChainEnabled = (chainId) => isChainEnabledByMap(enabledNetworkMap, chainId);
    const isAssetChainEnabled = (assetId) => isChainEnabledByMap(enabledNetworkMap, (0, utils_1.parseCaipAssetType)(assetId).chainId);
    const getBalance = {
        evm: (account) => sumEvmAccountBalanceInUserCurrency(account, tokenBalancesState, tokensState, tokenRatesState, currencyRateState, isEvmChainEnabled),
        nonEvm: (account) => sumNonEvmAccountBalanceInUserCurrency(account, multichainBalancesState, multichainRatesState, isAssetChainEnabled),
    };
    const getFlatAccountBalances = () => Object.entries(accountTreeState.accountTree.wallets ?? {})
        .flatMap(([walletId, wallet]) => Object.keys(wallet?.groups || {}).flatMap((groupId) => {
        const accounts = getInternalAccountsForGroup(accountTreeState, accountsState, groupId);
        return accounts.map((account) => ({
            walletId,
            groupId,
            account,
            isEvm: (0, keyring_api_1.isEvmAccountType)(account.type),
        }));
    }))
        .map((flatAccount) => {
        const flatAccountWithBalance = flatAccount;
        flatAccountWithBalance.balance = flatAccount.isEvm
            ? getBalance.evm(flatAccount.account)
            : getBalance.nonEvm(flatAccount.account);
        return flatAccountWithBalance;
    });
    const getAggWalletBalance = (flatAccountBalances) => flatAccountBalances.reduce((a, b) => a + b.balance, 0);
    const getWalletBalances = (flatAccountBalances) => {
        const wallets = {};
        const defaultWalletBalance = (walletId) => ({
            walletId,
            groups: {},
            totalBalanceInUserCurrency: 0,
            userCurrency: currencyRateState.currentCurrency,
        });
        const defaultGroupBalance = (walletId, groupId) => ({
            walletId,
            groupId,
            totalBalanceInUserCurrency: 0,
            userCurrency: currencyRateState.currentCurrency,
        });
        flatAccountBalances.forEach((flatAccount) => {
            var _a;
            const { walletId, groupId, balance } = flatAccount;
            wallets[walletId] ?? (wallets[walletId] = defaultWalletBalance(walletId));
            (_a = wallets[walletId].groups)[groupId] ?? (_a[groupId] = defaultGroupBalance(walletId, groupId));
            wallets[walletId].groups[groupId].totalBalanceInUserCurrency += balance;
            wallets[walletId].totalBalanceInUserCurrency += balance;
        });
        // Ensure all groups (including empty ones) are represented
        Object.entries(accountTreeState.accountTree.wallets ?? {}).forEach(([walletId, wallet]) => {
            if (!wallet) {
                return;
            }
            wallets[walletId] ?? (wallets[walletId] = defaultWalletBalance(walletId));
            Object.keys(wallet.groups || {}).forEach((groupId) => {
                var _a;
                (_a = wallets[walletId].groups)[groupId] ?? (_a[groupId] = defaultGroupBalance(walletId, groupId));
            });
        });
        return wallets;
    };
    const flatAccounts = getFlatAccountBalances();
    return {
        wallets: getWalletBalances(flatAccounts),
        totalBalanceInUserCurrency: getAggWalletBalance(flatAccounts),
        userCurrency: currencyRateState.currentCurrency,
    };
}
exports.calculateBalanceForAllWallets = calculateBalanceForAllWallets;
/**
 * Calculate aggregated portfolio value change for a given period (1d, 7d, 30d).
 * Logic mirrors extension/mobile historical aggregation:
 * - For each asset with available percent change for the requested period, compute current value in user currency.
 * - Reconstruct previous value by dividing current by (1 + percent/100).
 * - Sum across all assets, then compute amount change and percent change.
 *
 * @param accountTreeState - AccountTreeController state.
 * @param accountsState - AccountsController state.
 * @param tokenBalancesState - TokenBalancesController state.
 * @param tokenRatesState - TokenRatesController state.
 * @param multichainRatesState - MultichainAssetsRatesController state.
 * @param multichainBalancesState - MultichainBalancesController state.
 * @param tokensState - TokensController state.
 * @param currencyRateState - CurrencyRateController state.
 * @param enabledNetworkMap - Map of enabled networks keyed by namespace.
 * @param period - Period to compute change for ('1d' | '7d' | '30d').
 * @returns Aggregated change details for the requested period.
 */
function calculateBalanceChangeForAllWallets(accountTreeState, accountsState, tokenBalancesState, tokenRatesState, multichainRatesState, multichainBalancesState, tokensState, currencyRateState, enabledNetworkMap, period) {
    const isEvmChainEnabled = (chainId) => isChainEnabledByMap(enabledNetworkMap, chainId);
    const isAssetChainEnabled = (assetId) => {
        const { chainId } = (0, utils_1.parseCaipAssetType)(assetId);
        return isChainEnabledByMap(enabledNetworkMap, chainId);
    };
    const getAccountChange = {
        evm: (account) => sumEvmAccountChangeForPeriod(account, period, tokenBalancesState, tokensState, tokenRatesState, currencyRateState, isEvmChainEnabled),
        nonEvm: (account) => sumNonEvmAccountChangeForPeriod(account, period, multichainBalancesState, multichainRatesState, isAssetChainEnabled),
    };
    const getFlatAccountChanges = () => Object.entries(accountTreeState.accountTree.wallets ?? {})
        .flatMap(([walletId, wallet]) => Object.keys(wallet?.groups || {}).flatMap((groupId) => {
        const accounts = getInternalAccountsForGroup(accountTreeState, accountsState, groupId);
        return accounts.map((account) => ({
            walletId,
            groupId,
            account,
            isEvm: (0, keyring_api_1.isEvmAccountType)(account.type),
        }));
    }))
        .map((flatAccount) => {
        const flatAccountWithChange = flatAccount;
        const change = flatAccount.isEvm
            ? getAccountChange.evm(flatAccount.account)
            : getAccountChange.nonEvm(flatAccount.account);
        flatAccountWithChange.current = change.current;
        flatAccountWithChange.previous = change.previous;
        return flatAccountWithChange;
    });
    const getAggregatedTotals = (flatAccountChanges) => {
        return flatAccountChanges.reduce((totals, account) => {
            totals.current += account.current;
            totals.previous += account.previous;
            return totals;
        }, { current: 0, previous: 0 });
    };
    const flatAccountChanges = getFlatAccountChanges();
    const aggregatedTotals = getAggregatedTotals(flatAccountChanges);
    const amountChange = aggregatedTotals.current - aggregatedTotals.previous;
    const percentChange = aggregatedTotals.previous !== 0
        ? (amountChange / aggregatedTotals.previous) * 100
        : 0;
    return {
        period,
        currentTotalInUserCurrency: Number(aggregatedTotals.current.toFixed(8)),
        previousTotalInUserCurrency: Number(aggregatedTotals.previous.toFixed(8)),
        amountChangeInUserCurrency: Number(amountChange.toFixed(8)),
        percentChange: Number(percentChange.toFixed(8)),
        userCurrency: currencyRateState.currentCurrency,
    };
}
exports.calculateBalanceChangeForAllWallets = calculateBalanceChangeForAllWallets;
/**
 * Sum EVM account change for a period (current and previous totals).
 *
 * @param account - Internal account to aggregate.
 * @param period - Change period ('1d' | '7d' | '30d').
 * @param tokenBalancesState - Token balances controller state.
 * @param tokensState - Tokens controller state.
 * @param tokenRatesState - Token rates controller state.
 * @param currencyRateState - Currency rate controller state.
 * @param isEvmChainEnabled - Predicate that returns true if the EVM chain is enabled.
 * @returns Object with current and previous totals in user currency.
 */
function sumEvmAccountChangeForPeriod(account, period, tokenBalancesState, tokensState, tokenRatesState, currencyRateState, isEvmChainEnabled) {
    const tokenBalances = getEvmTokenBalances(account, tokenBalancesState, tokensState, tokenRatesState, currencyRateState, isEvmChainEnabled);
    const tokenChanges = tokenBalances
        .map((token) => {
        const percentRaw = token.tokenMarketData[evmRatePropertiesRecord[period]];
        if (!isNonNaNNumber(percentRaw)) {
            return null;
        }
        const denom = Number((1 + percentRaw / 100).toFixed(8));
        if (denom === 0) {
            return null;
        }
        return {
            current: token.userCurrencyValue,
            previous: token.userCurrencyValue / denom,
        };
    })
        .filter((change) => change !== null);
    return tokenChanges.reduce((totals, change) => {
        totals.current += change.current;
        totals.previous += change.previous;
        return totals;
    }, { current: 0, previous: 0 });
}
/**
 * Sum non-EVM account change for a period (current and previous totals).
 *
 * @param account - Internal account to aggregate.
 * @param period - Change period ('1d' | '7d' | '30d').
 * @param multichainBalancesState - Multichain balances controller state.
 * @param multichainRatesState - Multichain assets rates controller state.
 * @param isAssetChainEnabled - Predicate that returns true if the asset's chain is enabled.
 * @returns Object with current and previous totals in user currency.
 */
function sumNonEvmAccountChangeForPeriod(account, period, multichainBalancesState, multichainRatesState, isAssetChainEnabled) {
    const assetBalances = getNonEvmAssetBalances(account, multichainBalancesState, multichainRatesState, isAssetChainEnabled);
    const assetChanges = assetBalances
        .map((asset) => {
        // Safely access the percent change data with proper type checking
        const marketData = asset.conversionRate?.marketData;
        const pricePercentChange = marketData?.pricePercentChange;
        const percentRaw = pricePercentChange?.[nonEvmRatePropertiesRecord[period]];
        if (!isNonNaNNumber(percentRaw)) {
            return null;
        }
        const denom = Number((1 + percentRaw / 100).toFixed(8));
        if (denom === 0) {
            return null;
        }
        return {
            current: asset.userCurrencyValue,
            previous: asset.userCurrencyValue / denom,
        };
    })
        .filter((change) => change !== null);
    return assetChanges.reduce((totals, change) => ({
        current: totals.current + change.current,
        previous: totals.previous + change.previous,
    }), { current: 0, previous: 0 });
}
/**
 * Calculate portfolio value change for a specific account group and period.
 *
 * @param accountTreeState - AccountTreeController state.
 * @param accountsState - AccountsController state.
 * @param tokenBalancesState - TokenBalancesController state.
 * @param tokenRatesState - TokenRatesController state.
 * @param multichainRatesState - MultichainAssetsRatesController state.
 * @param multichainBalancesState - MultichainBalancesController state.
 * @param tokensState - TokensController state.
 * @param currencyRateState - CurrencyRateController state.
 * @param enabledNetworkMap - Map of enabled networks keyed by namespace.
 * @param groupId - Account group ID to compute change for.
 * @param period - Change period ('1d' | '7d' | '30d').
 * @returns Change result including current, previous, delta, percent, and period.
 */
function calculateBalanceChangeForAccountGroup(accountTreeState, accountsState, tokenBalancesState, tokenRatesState, multichainRatesState, multichainBalancesState, tokensState, currencyRateState, enabledNetworkMap, groupId, period) {
    const isEvmChainEnabled = (chainId) => isChainEnabledByMap(enabledNetworkMap, chainId);
    const isAssetChainEnabled = (assetId) => {
        const { chainId } = (0, utils_1.parseCaipAssetType)(assetId);
        return isChainEnabledByMap(enabledNetworkMap, chainId);
    };
    const getAccountChange = {
        evm: (account) => sumEvmAccountChangeForPeriod(account, period, tokenBalancesState, tokensState, tokenRatesState, currencyRateState, isEvmChainEnabled),
        nonEvm: (account) => sumNonEvmAccountChangeForPeriod(account, period, multichainBalancesState, multichainRatesState, isAssetChainEnabled),
    };
    const getFlatAccountChanges = () => {
        const accounts = getInternalAccountsForGroup(accountTreeState, accountsState, groupId);
        return accounts.map((account) => ({
            account,
            isEvm: (0, keyring_api_1.isEvmAccountType)(account.type),
        }));
    };
    const getAggregatedTotals = (flatAccountChanges) => {
        return flatAccountChanges.reduce((totals, { account, isEvm }) => {
            const change = isEvm
                ? getAccountChange.evm(account)
                : getAccountChange.nonEvm(account);
            totals.current += change.current;
            totals.previous += change.previous;
            return totals;
        }, { current: 0, previous: 0 });
    };
    const flatAccountChanges = getFlatAccountChanges();
    const aggregatedTotals = getAggregatedTotals(flatAccountChanges);
    const amountChange = aggregatedTotals.current - aggregatedTotals.previous;
    const percentChange = aggregatedTotals.previous !== 0
        ? (amountChange / aggregatedTotals.previous) * 100
        : 0;
    return {
        period,
        currentTotalInUserCurrency: Number(aggregatedTotals.current.toFixed(8)),
        previousTotalInUserCurrency: Number(aggregatedTotals.previous.toFixed(8)),
        amountChangeInUserCurrency: Number(amountChange.toFixed(8)),
        percentChange: Number(percentChange.toFixed(8)),
        userCurrency: currencyRateState.currentCurrency,
    };
}
exports.calculateBalanceChangeForAccountGroup = calculateBalanceChangeForAccountGroup;

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\balances.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\constants.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5Cconstants.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SUPPORTED_NETWORKS_ACCOUNTS_API_V4 = exports.Source = void 0;
var Source;
(function (Source) {
    Source["Custom"] = "custom";
    Source["Dapp"] = "dapp";
    Source["Detected"] = "detected";
})(Source || (exports.Source = Source = {}));
// TODO: delete this once we have the v4 endpoint for supported networks
exports.SUPPORTED_NETWORKS_ACCOUNTS_API_V4 = [
    '0x1',
    '0x89',
    '0x38',
    '0xe728',
    '0x2105',
    '0xa',
    '0xa4b1',
    '0x82750',
    '0x531', // 1329
];

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\constants.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\crypto-compare-service\\crypto-compare.cjs", {"../assetsUtil.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\assetsUtil.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5Ccrypto-compare-service%5Ccrypto-compare.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fetchMultiExchangeRate = exports.fetchExchangeRate = void 0;
const controller_utils_1 = require("@metamask/controller-utils");
const assetsUtil_1 = require("../assetsUtil.cjs");
/**
 * A map from native currency symbol to CryptoCompare identifier.
 * This is only needed when the values don't match.
 */
const nativeSymbolOverrides = new Map([
    ['MNT', 'MANTLE'],
    ['OMNI', 'OMNINET'],
]);
const CRYPTO_COMPARE_DOMAIN = 'https://min-api.cryptocompare.com';
/**
 * Get the CryptoCompare API URL for getting the conversion rate from the given native currency to
 * the given currency. Optionally, the conversion rate from the native currency to USD can also be
 * included in the response.
 *
 * @param currentCurrency - The currency to get a conversion rate for.
 * @param nativeCurrency - The native currency to convert from.
 * @param includeUSDRate - Whether or not the native currency to USD conversion rate should be
 * included in the response as well.
 * @returns The API URL for getting the conversion rate.
 */
function getPricingURL(currentCurrency, nativeCurrency, includeUSDRate) {
    return (`${CRYPTO_COMPARE_DOMAIN}/data/price?fsym=` +
        `${nativeCurrency}&tsyms=${currentCurrency}` +
        `${includeUSDRate && currentCurrency.toUpperCase() !== 'USD' ? ',USD' : ''}`);
}
/**
 * Get the CryptoCompare API URL for getting the conversion rate from a given array of native currencies
 * to the given currencies. Optionally, the conversion rate from the native currency to USD can also be
 * included in the response.
 *
 * @param fsyms - The native currencies to get conversion rates for.
 * @param tsyms - The currencies to convert to.
 * @param includeUSDRate - Whether or not the native currency to USD conversion rate should be included.
 * @returns The API URL for getting the conversion rates.
 */
function getMultiPricingURL(fsyms, tsyms, includeUSDRate = false) {
    const updatedTsyms = includeUSDRate && !tsyms.some((t) => t.toUpperCase() === 'USD')
        ? [...tsyms, 'USD']
        : tsyms;
    const params = new URLSearchParams();
    params.append('fsyms', fsyms.join(','));
    params.append('tsyms', updatedTsyms.join(','));
    const url = new URL(`${CRYPTO_COMPARE_DOMAIN}/data/pricemulti`);
    url.search = params.toString();
    return url.toString();
}
/**
 * Handles an error response from the CryptoCompare API.
 * Expected error response format
 * { Response: "Error", Message: "...", HasWarning: false }
 *
 * @param json - The JSON response from the CryptoCompare API.
 * @param json.Response - The response status.
 * @param json.Message - The error message.
 */
// TODO: Either fix this lint violation or explain why it's necessary to ignore.
// eslint-disable-next-line @typescript-eslint/naming-convention
function handleErrorResponse(json) {
    if (json.Response === 'Error') {
        throw new Error(json.Message);
    }
}
/**
 * Fetches the exchange rate for a given currency.
 *
 * @param currency - ISO 4217 currency code.
 * @param nativeCurrency - Symbol for base asset.
 * @param includeUSDRate - Whether to add the USD rate to the fetch.
 * @returns Promise resolving to exchange rate for given currency.
 */
async function fetchExchangeRate(currency, nativeCurrency, includeUSDRate) {
    currency = currency.toUpperCase();
    nativeCurrency = nativeCurrency.toUpperCase();
    currency = nativeSymbolOverrides.get(currency) ?? currency;
    nativeCurrency = nativeSymbolOverrides.get(nativeCurrency) ?? nativeCurrency;
    const json = await (0, controller_utils_1.handleFetch)(getPricingURL(currency, nativeCurrency, includeUSDRate));
    handleErrorResponse(json);
    const conversionRate = Number(json[currency.toUpperCase()]);
    const usdConversionRate = Number(json.USD);
    if (!Number.isFinite(conversionRate)) {
        throw new Error(`Invalid response for ${currency.toUpperCase()}: ${
        // TODO: Either fix this lint violation or explain why it's necessary to ignore.
        // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
        json[currency.toUpperCase()]}`);
    }
    if (includeUSDRate && !Number.isFinite(usdConversionRate)) {
        // TODO: Either fix this lint violation or explain why it's necessary to ignore.
        // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
        throw new Error(`Invalid response for usdConversionRate: ${json.USD}`);
    }
    return {
        conversionRate,
        usdConversionRate,
    };
}
exports.fetchExchangeRate = fetchExchangeRate;
/**
 * Fetches the exchange rates for multiple currencies.
 *
 * @param fiatCurrency - The currency of the rates (ISO 4217).
 * @param cryptocurrencies - The cryptocurrencies to get conversion rates for. Min length: 1. Max length: 300.
 * @param includeUSDRate - Whether to add the USD rate to the fetch.
 * @returns Promise resolving to exchange rates for given currencies.
 */
async function fetchMultiExchangeRate(fiatCurrency, cryptocurrencies, includeUSDRate) {
    const fsyms = cryptocurrencies.map((nativeCurrency) => nativeSymbolOverrides.get(nativeCurrency) ?? nativeCurrency);
    const url = getMultiPricingURL(fsyms, [fiatCurrency], includeUSDRate);
    const response = await (0, controller_utils_1.handleFetch)(url);
    handleErrorResponse(response);
    const rates = {};
    for (const [cryptocurrency, values] of Object.entries(response)) {
        const key = (0, assetsUtil_1.getKeyByValue)(nativeSymbolOverrides, cryptocurrency);
        rates[key?.toLowerCase() ?? cryptocurrency.toLowerCase()] = {
            [fiatCurrency.toLowerCase()]: values[fiatCurrency.toUpperCase()],
            ...(includeUSDRate && { usd: values.USD }),
        };
    }
    return rates;
}
exports.fetchMultiExchangeRate = fetchMultiExchangeRate;

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\crypto-compare-service\\crypto-compare.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\crypto-compare-service\\index.cjs", {"./crypto-compare.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\crypto-compare-service\\crypto-compare.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5Ccrypto-compare-service%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fetchMultiExchangeRate = exports.fetchExchangeRate = void 0;
var crypto_compare_1 = require("./crypto-compare.cjs");
Object.defineProperty(exports, "fetchExchangeRate", { enumerable: true, get: function () { return crypto_compare_1.fetchExchangeRate; } });
Object.defineProperty(exports, "fetchMultiExchangeRate", { enumerable: true, get: function () { return crypto_compare_1.fetchMultiExchangeRate; } });

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\crypto-compare-service\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\index.cjs", {"./AccountTrackerController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\AccountTrackerController.cjs","./AssetsContractController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\AssetsContractController.cjs","./CurrencyRateController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\CurrencyRateController.cjs","./DeFiPositionsController/DeFiPositionsController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\DeFiPositionsController\\DeFiPositionsController.cjs","./MultichainAssetsController/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\MultichainAssetsController\\index.cjs","./MultichainAssetsRatesController/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\MultichainAssetsRatesController\\index.cjs","./MultichainBalancesController/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\MultichainBalancesController\\index.cjs","./NftController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\NftController.cjs","./NftDetectionController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\NftDetectionController.cjs","./RatesController/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\RatesController\\index.cjs","./TokenBalancesController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\TokenBalancesController.cjs","./TokenDetectionController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\TokenDetectionController.cjs","./TokenListController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\TokenListController.cjs","./TokenRatesController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\TokenRatesController.cjs","./TokenSearchDiscoveryDataController/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\TokenSearchDiscoveryDataController\\index.cjs","./TokensController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\TokensController.cjs","./assetsUtil.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\assetsUtil.cjs","./balances.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\balances.cjs","./selectors/token-selectors.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\selectors\\token-selectors.cjs","./token-prices-service/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\token-prices-service\\index.cjs","./utils/formatters.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\utils\\formatters.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createFormatters = exports.selectAssetsBySelectedAccountGroup = exports.calculateBalanceChangeForAccountGroup = exports.calculateBalanceChangeForAllWallets = exports.calculateBalanceForAllWallets = exports.DeFiPositionsController = exports.TokenSearchDiscoveryDataController = exports.getDefaultMultichainAssetsRatesControllerState = exports.MultichainAssetsRatesController = exports.getDefaultMultichainAssetsControllerState = exports.MultichainAssetsController = exports.MultichainBalancesController = exports.Cryptocurrency = exports.RatesController = exports.getNativeTokenAddress = exports.SUPPORTED_CHAIN_IDS = exports.CodefiTokenPricesServiceV2 = exports.getKeyByValue = exports.fetchTokenContractExchangeRates = exports.getFormattedIpfsUrl = exports.formatIconUrlWithProxy = exports.isTokenDetectionSupportedForNetwork = exports.TokensController = exports.TokenRatesController = exports.getDefaultTokenRatesControllerState = exports.TokenListController = exports.TokenDetectionController = exports.TokenBalancesController = exports.NftDetectionController = exports.NftController = exports.getDefaultNftControllerState = exports.AssetsContractController = exports.SINGLE_CALL_BALANCES_ADDRESS_BY_CHAINID = exports.AccountTrackerController = void 0;
var AccountTrackerController_1 = require("./AccountTrackerController.cjs");
Object.defineProperty(exports, "AccountTrackerController", { enumerable: true, get: function () { return AccountTrackerController_1.AccountTrackerController; } });
var AssetsContractController_1 = require("./AssetsContractController.cjs");
Object.defineProperty(exports, "SINGLE_CALL_BALANCES_ADDRESS_BY_CHAINID", { enumerable: true, get: function () { return AssetsContractController_1.SINGLE_CALL_BALANCES_ADDRESS_BY_CHAINID; } });
Object.defineProperty(exports, "AssetsContractController", { enumerable: true, get: function () { return AssetsContractController_1.AssetsContractController; } });
__exportStar(require("./CurrencyRateController.cjs"), exports);
var NftController_1 = require("./NftController.cjs");
Object.defineProperty(exports, "getDefaultNftControllerState", { enumerable: true, get: function () { return NftController_1.getDefaultNftControllerState; } });
Object.defineProperty(exports, "NftController", { enumerable: true, get: function () { return NftController_1.NftController; } });
var NftDetectionController_1 = require("./NftDetectionController.cjs");
Object.defineProperty(exports, "NftDetectionController", { enumerable: true, get: function () { return NftDetectionController_1.NftDetectionController; } });
var TokenBalancesController_1 = require("./TokenBalancesController.cjs");
Object.defineProperty(exports, "TokenBalancesController", { enumerable: true, get: function () { return TokenBalancesController_1.TokenBalancesController; } });
var TokenDetectionController_1 = require("./TokenDetectionController.cjs");
Object.defineProperty(exports, "TokenDetectionController", { enumerable: true, get: function () { return TokenDetectionController_1.TokenDetectionController; } });
var TokenListController_1 = require("./TokenListController.cjs");
Object.defineProperty(exports, "TokenListController", { enumerable: true, get: function () { return TokenListController_1.TokenListController; } });
var TokenRatesController_1 = require("./TokenRatesController.cjs");
Object.defineProperty(exports, "getDefaultTokenRatesControllerState", { enumerable: true, get: function () { return TokenRatesController_1.getDefaultTokenRatesControllerState; } });
Object.defineProperty(exports, "TokenRatesController", { enumerable: true, get: function () { return TokenRatesController_1.TokenRatesController; } });
var TokensController_1 = require("./TokensController.cjs");
Object.defineProperty(exports, "TokensController", { enumerable: true, get: function () { return TokensController_1.TokensController; } });
var assetsUtil_1 = require("./assetsUtil.cjs");
Object.defineProperty(exports, "isTokenDetectionSupportedForNetwork", { enumerable: true, get: function () { return assetsUtil_1.isTokenDetectionSupportedForNetwork; } });
Object.defineProperty(exports, "formatIconUrlWithProxy", { enumerable: true, get: function () { return assetsUtil_1.formatIconUrlWithProxy; } });
Object.defineProperty(exports, "getFormattedIpfsUrl", { enumerable: true, get: function () { return assetsUtil_1.getFormattedIpfsUrl; } });
Object.defineProperty(exports, "fetchTokenContractExchangeRates", { enumerable: true, get: function () { return assetsUtil_1.fetchTokenContractExchangeRates; } });
Object.defineProperty(exports, "getKeyByValue", { enumerable: true, get: function () { return assetsUtil_1.getKeyByValue; } });
var token_prices_service_1 = require("./token-prices-service/index.cjs");
Object.defineProperty(exports, "CodefiTokenPricesServiceV2", { enumerable: true, get: function () { return token_prices_service_1.CodefiTokenPricesServiceV2; } });
Object.defineProperty(exports, "SUPPORTED_CHAIN_IDS", { enumerable: true, get: function () { return token_prices_service_1.SUPPORTED_CHAIN_IDS; } });
Object.defineProperty(exports, "getNativeTokenAddress", { enumerable: true, get: function () { return token_prices_service_1.getNativeTokenAddress; } });
var RatesController_1 = require("./RatesController/index.cjs");
Object.defineProperty(exports, "RatesController", { enumerable: true, get: function () { return RatesController_1.RatesController; } });
Object.defineProperty(exports, "Cryptocurrency", { enumerable: true, get: function () { return RatesController_1.Cryptocurrency; } });
var MultichainBalancesController_1 = require("./MultichainBalancesController/index.cjs");
Object.defineProperty(exports, "MultichainBalancesController", { enumerable: true, get: function () { return MultichainBalancesController_1.MultichainBalancesController; } });
var MultichainAssetsController_1 = require("./MultichainAssetsController/index.cjs");
Object.defineProperty(exports, "MultichainAssetsController", { enumerable: true, get: function () { return MultichainAssetsController_1.MultichainAssetsController; } });
Object.defineProperty(exports, "getDefaultMultichainAssetsControllerState", { enumerable: true, get: function () { return MultichainAssetsController_1.getDefaultMultichainAssetsControllerState; } });
var MultichainAssetsRatesController_1 = require("./MultichainAssetsRatesController/index.cjs");
Object.defineProperty(exports, "MultichainAssetsRatesController", { enumerable: true, get: function () { return MultichainAssetsRatesController_1.MultichainAssetsRatesController; } });
Object.defineProperty(exports, "getDefaultMultichainAssetsRatesControllerState", { enumerable: true, get: function () { return MultichainAssetsRatesController_1.getDefaultMultichainAssetsRatesControllerState; } });
var TokenSearchDiscoveryDataController_1 = require("./TokenSearchDiscoveryDataController/index.cjs");
Object.defineProperty(exports, "TokenSearchDiscoveryDataController", { enumerable: true, get: function () { return TokenSearchDiscoveryDataController_1.TokenSearchDiscoveryDataController; } });
var DeFiPositionsController_1 = require("./DeFiPositionsController/DeFiPositionsController.cjs");
Object.defineProperty(exports, "DeFiPositionsController", { enumerable: true, get: function () { return DeFiPositionsController_1.DeFiPositionsController; } });
var balances_1 = require("./balances.cjs");
Object.defineProperty(exports, "calculateBalanceForAllWallets", { enumerable: true, get: function () { return balances_1.calculateBalanceForAllWallets; } });
var balances_2 = require("./balances.cjs");
Object.defineProperty(exports, "calculateBalanceChangeForAllWallets", { enumerable: true, get: function () { return balances_2.calculateBalanceChangeForAllWallets; } });
Object.defineProperty(exports, "calculateBalanceChangeForAccountGroup", { enumerable: true, get: function () { return balances_2.calculateBalanceChangeForAccountGroup; } });
var token_selectors_1 = require("./selectors/token-selectors.cjs");
Object.defineProperty(exports, "selectAssetsBySelectedAccountGroup", { enumerable: true, get: function () { return token_selectors_1.selectAssetsBySelectedAccountGroup; } });
var formatters_1 = require("./utils/formatters.cjs");
Object.defineProperty(exports, "createFormatters", { enumerable: true, get: function () { return formatters_1.createFormatters; } });

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\multi-chain-accounts-service\\api-balance-fetcher.cjs", {"../AssetsContractController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\AssetsContractController.cjs","../assetsUtil.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\assetsUtil.cjs","../constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\constants.cjs","./multi-chain-accounts.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\multi-chain-accounts-service\\multi-chain-accounts.cjs","@ethersproject/contracts":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\contracts\\lib\\index.js","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","bn.js":"D:\\code\\v\\metamask-extension\\node_modules\\bn.js\\lib\\bn.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5Cmulti-chain-accounts-service%5Capi-balance-fetcher.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _AccountsApiBalanceFetcher_instances, _AccountsApiBalanceFetcher_platform, _AccountsApiBalanceFetcher_getProvider, _AccountsApiBalanceFetcher_fetchStakedBalances, _AccountsApiBalanceFetcher_fetchBalances;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccountsApiBalanceFetcher = void 0;
const contracts_1 = require("@ethersproject/contracts");
const controller_utils_1 = require("@metamask/controller-utils");
const bn_js_1 = __importDefault(require("bn.js"));
const multi_chain_accounts_1 = require("./multi-chain-accounts.cjs");
const AssetsContractController_1 = require("../AssetsContractController.cjs");
const assetsUtil_1 = require("../assetsUtil.cjs");
const constants_1 = require("../constants.cjs");
// Maximum number of account addresses that can be sent to the accounts API in a single request
const ACCOUNTS_API_BATCH_SIZE = 50;
const checksum = (addr) => (0, controller_utils_1.toChecksumHexAddress)(addr);
const toCaipAccount = (chainId, account) => (0, assetsUtil_1.accountAddressToCaipReference)(chainId, account);
class AccountsApiBalanceFetcher {
    constructor(platform = 'extension', getProvider) {
        _AccountsApiBalanceFetcher_instances.add(this);
        _AccountsApiBalanceFetcher_platform.set(this, 'extension');
        _AccountsApiBalanceFetcher_getProvider.set(this, void 0);
        __classPrivateFieldSet(this, _AccountsApiBalanceFetcher_platform, platform, "f");
        __classPrivateFieldSet(this, _AccountsApiBalanceFetcher_getProvider, getProvider, "f");
    }
    supports(chainId) {
        return constants_1.SUPPORTED_NETWORKS_ACCOUNTS_API_V4.includes(chainId);
    }
    async fetch({ chainIds, queryAllAccounts, selectedAccount, allAccounts, }) {
        const caipAddrs = [];
        for (const chainId of chainIds.filter((c) => this.supports(c))) {
            if (queryAllAccounts) {
                allAccounts.forEach((a) => caipAddrs.push(toCaipAccount(chainId, a.address)));
            }
            else {
                caipAddrs.push(toCaipAccount(chainId, selectedAccount));
            }
        }
        if (!caipAddrs.length) {
            return [];
        }
        // Don't use safelyExecute here - let real errors propagate
        let balances;
        let apiError = false;
        try {
            balances = await __classPrivateFieldGet(this, _AccountsApiBalanceFetcher_instances, "m", _AccountsApiBalanceFetcher_fetchBalances).call(this, caipAddrs);
        }
        catch (error) {
            // Mark that we had an API error so we don't add fake zero balances
            apiError = true;
            console.error('Failed to fetch balances from API:', error);
            balances = undefined;
        }
        const stakedBalances = await __classPrivateFieldGet(this, _AccountsApiBalanceFetcher_instances, "m", _AccountsApiBalanceFetcher_fetchStakedBalances).call(this, caipAddrs);
        const results = [];
        // Collect all unique addresses and chains from the CAIP addresses
        const addressChainMap = new Map();
        caipAddrs.forEach((caipAddr) => {
            const [, chainRef, address] = caipAddr.split(':');
            const chainId = (0, controller_utils_1.toHex)(parseInt(chainRef, 10));
            const checksumAddress = checksum(address);
            if (!addressChainMap.has(checksumAddress)) {
                addressChainMap.set(checksumAddress, new Set());
            }
            addressChainMap.get(checksumAddress)?.add(chainId);
        });
        // Ensure native token entries exist for all addresses on all requested chains
        const ZERO_ADDRESS = '0x0000000000000000000000000000000000000000';
        const nativeBalancesFromAPI = new Map(); // key: `${address}-${chainId}`
        // Process regular API balances
        if (balances) {
            const apiBalances = balances.flatMap((b) => {
                const addressPart = b.accountAddress?.split(':')[2];
                if (!addressPart) {
                    return [];
                }
                const account = checksum(addressPart);
                const token = checksum(b.address);
                // Use original address for zero address tokens, checksummed for others
                // TODO: this is a hack to get the correct account address type but needs to be fixed
                // by mgrating tokenBalancesController to checksum addresses
                const finalAccount = token === ZERO_ADDRESS ? account : addressPart;
                const chainId = (0, controller_utils_1.toHex)(b.chainId);
                let value;
                try {
                    // Convert string balance to BN avoiding floating point precision issues
                    const { balance: balanceStr, decimals } = b;
                    // Split the balance string into integer and decimal parts
                    const [integerPart = '0', decimalPart = ''] = balanceStr.split('.');
                    // Pad or truncate decimal part to match token decimals
                    const paddedDecimalPart = decimalPart
                        .padEnd(decimals, '0')
                        .slice(0, decimals);
                    // Combine and create BN
                    const fullIntegerStr = integerPart + paddedDecimalPart;
                    value = new bn_js_1.default(fullIntegerStr);
                }
                catch {
                    value = undefined;
                }
                // Track native balances for later
                if (token === ZERO_ADDRESS && value !== undefined) {
                    nativeBalancesFromAPI.set(`${finalAccount}-${chainId}`, value);
                }
                return [
                    {
                        success: value !== undefined,
                        value,
                        account: finalAccount,
                        token,
                        chainId,
                    },
                ];
            });
            results.push(...apiBalances);
        }
        // Only add zero native balance entries if API succeeded but didn't return balances
        // Don't add fake zero balances if the API failed entirely
        if (!apiError) {
            addressChainMap.forEach((chains, address) => {
                chains.forEach((chainId) => {
                    const key = `${address}-${chainId}`;
                    const existingBalance = nativeBalancesFromAPI.get(key);
                    if (!existingBalance) {
                        // Add zero native balance entry if API succeeded but didn't return one
                        results.push({
                            success: true,
                            value: new bn_js_1.default('0'),
                            account: address,
                            token: ZERO_ADDRESS,
                            chainId,
                        });
                    }
                });
            });
        }
        else {
            // If API failed, add error entries for all requested addresses/chains
            addressChainMap.forEach((chains, address) => {
                chains.forEach((chainId) => {
                    results.push({
                        success: false,
                        account: address,
                        token: ZERO_ADDRESS,
                        chainId,
                    });
                });
            });
        }
        // Add staked balances
        results.push(...stakedBalances);
        // If we had an API error and no successful results, throw the error
        if (apiError && results.every((r) => !r.success)) {
            throw new Error('Failed to fetch any balance data due to API error');
        }
        return results;
    }
}
exports.AccountsApiBalanceFetcher = AccountsApiBalanceFetcher;
_AccountsApiBalanceFetcher_platform = new WeakMap(), _AccountsApiBalanceFetcher_getProvider = new WeakMap(), _AccountsApiBalanceFetcher_instances = new WeakSet(), _AccountsApiBalanceFetcher_fetchStakedBalances = async function _AccountsApiBalanceFetcher_fetchStakedBalances(addrs) {
    // Return empty array if no provider is available for blockchain calls
    if (!__classPrivateFieldGet(this, _AccountsApiBalanceFetcher_getProvider, "f")) {
        return [];
    }
    const results = [];
    // Group addresses by chain ID
    const addressesByChain = {};
    for (const caipAddr of addrs) {
        const [, chainRef, address] = caipAddr.split(':');
        const chainId = (0, controller_utils_1.toHex)(parseInt(chainRef, 10));
        const checksumAddress = checksum(address);
        if (!addressesByChain[chainId]) {
            addressesByChain[chainId] = [];
        }
        addressesByChain[chainId].push(checksumAddress);
    }
    // Process each supported chain
    for (const [chainId, addresses] of Object.entries(addressesByChain)) {
        const chainIdHex = chainId;
        // Only fetch staked balance on supported networks (mainnet and hoodi)
        if (![
            assetsUtil_1.SupportedStakedBalanceNetworks.mainnet,
            assetsUtil_1.SupportedStakedBalanceNetworks.hoodi,
        ].includes(chainIdHex)) {
            continue;
        }
        // Only fetch staked balance if contract address exists
        if (!(chainIdHex in AssetsContractController_1.STAKING_CONTRACT_ADDRESS_BY_CHAINID)) {
            continue;
        }
        const contractAddress = AssetsContractController_1.STAKING_CONTRACT_ADDRESS_BY_CHAINID[chainIdHex];
        const provider = __classPrivateFieldGet(this, _AccountsApiBalanceFetcher_getProvider, "f").call(this, chainIdHex);
        const abi = [
            {
                inputs: [
                    { internalType: 'address', name: 'account', type: 'address' },
                ],
                name: 'getShares',
                outputs: [{ internalType: 'uint256', name: '', type: 'uint256' }],
                stateMutability: 'view',
                type: 'function',
            },
            {
                inputs: [
                    { internalType: 'uint256', name: 'shares', type: 'uint256' },
                ],
                name: 'convertToAssets',
                outputs: [
                    { internalType: 'uint256', name: 'assets', type: 'uint256' },
                ],
                stateMutability: 'view',
                type: 'function',
            },
        ];
        try {
            const contract = new contracts_1.Contract(contractAddress, abi, provider);
            // Get shares for each address
            for (const address of addresses) {
                try {
                    const shares = await (0, controller_utils_1.safelyExecute)(() => contract.getShares(address));
                    if (shares && shares.gt(0)) {
                        // Convert shares to assets (actual staked ETH amount)
                        const assets = await (0, controller_utils_1.safelyExecute)(() => contract.convertToAssets(shares));
                        if (assets) {
                            results.push({
                                success: true,
                                value: new bn_js_1.default(assets.toString()),
                                account: address,
                                token: checksum(contractAddress),
                                chainId: chainIdHex,
                            });
                        }
                    }
                    else {
                        // Return zero balance for accounts with no staked assets
                        results.push({
                            success: true,
                            value: new bn_js_1.default('0'),
                            account: address,
                            token: checksum(contractAddress),
                            chainId: chainIdHex,
                        });
                    }
                }
                catch (error) {
                    // Log error and continue with next address
                    console.error(`Error fetching staked balance for ${address}:`, error);
                    results.push({
                        success: false,
                        account: address,
                        token: checksum(contractAddress),
                        chainId: chainIdHex,
                    });
                }
            }
        }
        catch (error) {
            console.error(`Error setting up staking contract for chain ${chainId}:`, error);
        }
    }
    return results;
}, _AccountsApiBalanceFetcher_fetchBalances = async function _AccountsApiBalanceFetcher_fetchBalances(addrs) {
    // If we have fewer than or equal to the batch size, make a single request
    if (addrs.length <= ACCOUNTS_API_BATCH_SIZE) {
        const { balances } = await (0, multi_chain_accounts_1.fetchMultiChainBalancesV4)({ accountAddresses: addrs }, __classPrivateFieldGet(this, _AccountsApiBalanceFetcher_platform, "f"));
        return balances;
    }
    const allBalances = await (0, assetsUtil_1.reduceInBatchesSerially)({
        values: addrs,
        batchSize: ACCOUNTS_API_BATCH_SIZE,
        eachBatch: async (workingResult, batch) => {
            const { balances } = await (0, multi_chain_accounts_1.fetchMultiChainBalancesV4)({ accountAddresses: batch }, __classPrivateFieldGet(this, _AccountsApiBalanceFetcher_platform, "f"));
            return [...(workingResult || []), ...balances];
        },
        initialResult: [],
    });
    return allBalances;
};

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\multi-chain-accounts-service\\api-balance-fetcher.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\multi-chain-accounts-service\\index.cjs", {"./multi-chain-accounts.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\multi-chain-accounts-service\\multi-chain-accounts.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5Cmulti-chain-accounts-service%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fetchSupportedNetworks = exports.fetchMultiChainBalances = void 0;
var multi_chain_accounts_1 = require("./multi-chain-accounts.cjs");
Object.defineProperty(exports, "fetchMultiChainBalances", { enumerable: true, get: function () { return multi_chain_accounts_1.fetchMultiChainBalances; } });
Object.defineProperty(exports, "fetchSupportedNetworks", { enumerable: true, get: function () { return multi_chain_accounts_1.fetchSupportedNetworks; } });

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\multi-chain-accounts-service\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\multi-chain-accounts-service\\multi-chain-accounts.cjs", {"@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5Cmulti-chain-accounts-service%5Cmulti-chain-accounts.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fetchMultiChainBalancesV4 = exports.fetchMultiChainBalances = exports.fetchSupportedNetworks = exports.MULTICHAIN_ACCOUNTS_DOMAIN = void 0;
const controller_utils_1 = require("@metamask/controller-utils");
exports.MULTICHAIN_ACCOUNTS_DOMAIN = 'https://accounts.api.cx.metamask.io';
const getBalancesUrl = (address, queryParams) => {
    const url = new URL(`${exports.MULTICHAIN_ACCOUNTS_DOMAIN}/v2/accounts/${address}/balances`);
    if (queryParams?.networks !== undefined) {
        url.searchParams.append('networks', queryParams.networks);
    }
    return url;
};
const getBalancesUrlV4 = (queryParams) => {
    const url = new URL(`${exports.MULTICHAIN_ACCOUNTS_DOMAIN}/v4/multiaccount/balances`);
    if (queryParams?.networks !== undefined) {
        url.searchParams.append('networks', queryParams.networks);
    }
    if (queryParams?.accountAddresses !== undefined) {
        url.searchParams.append('accountAddresses', queryParams.accountAddresses);
    }
    return url;
};
/**
 * Fetches Supported Networks.
 *
 * @returns supported networks (decimal)
 */
async function fetchSupportedNetworks() {
    const url = new URL(`${exports.MULTICHAIN_ACCOUNTS_DOMAIN}/v1/supportedNetworks`);
    const response = await (0, controller_utils_1.handleFetch)(url);
    return response.fullSupport;
}
exports.fetchSupportedNetworks = fetchSupportedNetworks;
/**
 * Fetches Balances for multiple networks.
 *
 * @param address - address to fetch balances from
 * @param options - params to pass down for a more refined search
 * @param options.networks - the networks (in decimal) that you want to filter by
 * @param platform - indicates whether the platform is extension or mobile
 * @returns a Balances Response
 */
async function fetchMultiChainBalances(address, options, platform) {
    const url = getBalancesUrl(address, {
        networks: options?.networks?.join(),
    });
    const response = await (0, controller_utils_1.handleFetch)(url, {
        headers: {
            'x-metamask-clientproduct': `metamask-${platform}`,
        },
    });
    return response;
}
exports.fetchMultiChainBalances = fetchMultiChainBalances;
/**
 * Fetches Balances for multiple networks.
 *
 * @param options - params to pass down for a more refined search
 * @param options.accountAddresses - the account addresses that you want to filter by
 * @param options.networks - the networks (in decimal) that you want to filter by
 * @param platform - indicates whether the platform is extension or mobile
 * @returns a Balances Response
 */
async function fetchMultiChainBalancesV4(options, platform) {
    const url = getBalancesUrlV4({
        accountAddresses: options?.accountAddresses?.join(),
        networks: options?.networks?.join(),
    });
    const response = await (0, controller_utils_1.handleFetch)(url, {
        headers: {
            'x-metamask-clientproduct': `metamask-${platform}`,
        },
    });
    return response;
}
exports.fetchMultiChainBalancesV4 = fetchMultiChainBalancesV4;

      };
    };
  }
  }
}, {package:"@metamask/assets-controllers",file:"node_modules\\@metamask\\assets-controllers\\dist\\multi-chain-accounts-service\\multi-chain-accounts.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\multicall.cjs", {"./AssetsContractController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\AssetsContractController.cjs","./assetsUtil.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\assets-controllers\\dist\\assetsUtil.cjs","@ethersproject/contracts":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\contracts\\lib\\index.js","bn.js":"D:\\code\\v\\metamask-extension\\node_modules\\bn.js\\lib\\bn.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cassets-controllers%5Cdist%5Cmulticall.cjs
      return function (require, module, exports) {
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTokenBalancesForMultipleAddresses = exports.getStakedBalancesForAddresses = exports.aggregate3 = exports.multicallOrFallback = void 0;
const contracts_1 = require("@ethersproject/contracts");
const bn_js_1 = __importDefault(require("bn.js"));
const AssetsContractController_1 = require("./AssetsContractController.cjs");
const assetsUtil_1 = require("./assetsUtil.cjs");
// https://github.com/mds1/multicall/blob/main/deployments.json
const MULTICALL_CONTRACT_BY_CHAINID = {
    '0x1': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x2a': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x4': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x5': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x3': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xaa36a7': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x4268': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x5e9': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1b6e6': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x18fc4a': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xa': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x45': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1a4': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xaa37dc': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xa4b1': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xa4ba': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x66eed': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x66eee': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x66eeb': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x15f2249': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x89': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x13881': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x13882': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x44d': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x5a2': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x98a': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x64': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x27d8': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xa86a': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xa869': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xfa2': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xfa': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xfaf0': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x38': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x61': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x15eb': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xcc': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x504': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x505': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x507': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x2a15c308d': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x2a15c3083': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x63564c40': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x19': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x152': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x5535072': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x6c1': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x7a': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xe': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x13': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x10': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x72': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x120': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x4e454152': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x250': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x5c2359': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xec0': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x42': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x80': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x440': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x257': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xe9fe': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xd3a0': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x84444': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1e': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1f': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x2329': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x2328': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x6c': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x12': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xa516': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x5afe': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xa4ec': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xaef3': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x116ea': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x116e9': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x2019': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x3e9': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x7d1': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x141': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x6a': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x28': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x4d2': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1e14': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1e15': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1251': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x7f08': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x8ae': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x138b': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1389': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1388': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1f92': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x14a33': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x14a34': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x2105': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x936': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xff': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x46a': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x46b': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x8a': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x14f': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xd2af': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xe9ac0ce': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xe705': '0xca11bde05977b3631167028862be2a173976ca11',
    '0xe704': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xe708': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x2b6f': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x39': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x23a': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1644': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xdea8': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x3af': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x171': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x3e7': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x76adf1': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x3b9ac9ff': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x2c': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x2e': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x15b3': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x82751': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x8274f': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x82750': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x96f': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x3cc5': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x4571': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xe99': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x7d0': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1297': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1d5e': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x3a14269b': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x561bf78b': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x235ddd0': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x3cd156dc': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x5d456c62': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x79f99296': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x585eb4b1': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x507aaa2a': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1fc3': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x32d': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x8a73': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x8a72': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x8a71': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xe9ac0d6': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x1069': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x7e5': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x53': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x52': '0xca11bde05977b3631167028862be2a173976ca11',
    '0xe298': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1a8': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x94': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x2c6': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x2803': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x2802': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xa9': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x28c5f': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x28c60': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x13a': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x4cb2f': '0xdbfa261cd7d17bb40479a0493ad6c0fee435859e',
    '0x7f93': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xb660': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xb02113d3f': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xdad': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xdae': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x15b38': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x15b32': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x45c': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x45b': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x3d': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x41a6ace': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xa729': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1f47b': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1b59': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x1b58': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xc3': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x16fd8': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xc7': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x405': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x334': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1ce': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x1cf': '0xca11bde05977b3631167028862be2a173976ca11',
    '0xa70e': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x868b': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xa0c71fd': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x13e31': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xa1337': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1f2b': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xf63': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x144': '0xF9cda624FBC7e059355ce98a31693d299FACd963',
    '0x118': '0xF9cda624FBC7e059355ce98a31693d299FACd963',
    '0x12c': '0xF9cda624FBC7e059355ce98a31693d299FACd963',
    '0x18995f': '0xF9cda624FBC7e059355ce98a31693d299FACd963',
    '0x2b74': '0xF9cda624FBC7e059355ce98a31693d299FACd963',
    '0xfc': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x9da': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x137': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x13ed': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x24b1': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xba9302': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x7c8': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x138d5': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x6d': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x343b': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x34a1': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x3109': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x91b': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xa96': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x22c3': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x2be3': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xbf03': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1b254': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xa7b14': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x2276': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1b9e': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x6a63bb8': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x15af3': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x15af1': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xae3f3': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x531': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x28c61': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x28c58': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x1d88': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x5b9b': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x4c7e1': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xa53b': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1a2b': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x406': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x2cef': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x18b2': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x182a9': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xc4': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xfdd': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xfde': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x99c0a0f': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x22cf': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x310c5': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x46f': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x659': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x139c968f9': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xed88': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0xd036': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1f3': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x31bf8c3': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x1cbc67bfdc': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x98967f': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x4f588': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x16db': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x3a': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x59': '0xca11bde05977b3631167028862be2a173976ca11',
    '0x1e0': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x2eb': '0xcA11bde05977b3631167028862bE2a173976CA11',
    '0x221': '0xcA11bde05977b3631167028862bE2a173976CA11',
};
const multicallAbi = [
    {
        name: 'tryAggregate',
        type: 'function',
        stateMutability: 'payable',
        inputs: [
            { name: 'requireSuccess', type: 'bool' },
            {
                name: 'calls',
                type: 'tuple[]',
                components: [
                    { name: 'target', type: 'address' },
                    { name: 'callData', type: 'bytes' },
                ],
            },
        ],
        outputs: [
            {
                name: 'returnData',
                type: 'tuple[]',
                components: [
                    { name: 'success', type: 'bool' },
                    { name: 'returnData', type: 'bytes' },
                ],
            },
        ],
    },
];
// Multicall3 ABI for aggregate3 function
const multicall3Abi = [
    {
        name: 'aggregate3',
        type: 'function',
        stateMutability: 'payable',
        inputs: [
            {
                name: 'calls',
                type: 'tuple[]',
                components: [
                    { name: 'target', type: 'address' },
                    { name: 'allowFailure', type: 'bool' },
                    { name: 'callData', type: 'bytes' },
                ],
            },
        ],
        outputs: [
            {
                name: 'returnData',
                type: 'tuple[]',
                components: [
                    { name: 'success', type: 'bool' },
                    { name: 'returnData', type: 'bytes' },
                ],
            },
        ],
    },
];
// Constants for encoded strings and addresses
const ZERO_ADDRESS = '0x0000000000000000000000000000000000000000';
const BALANCE_OF_FUNCTION = 'balanceOf(address)';
const GET_ETH_BALANCE_FUNCTION = 'getEthBalance';
const GET_SHARES_FUNCTION = 'getShares';
const CONVERT_TO_ASSETS_FUNCTION = 'convertToAssets';
// ERC20 balanceOf ABI
const ERC20_BALANCE_OF_ABI = [
    {
        name: 'balanceOf',
        type: 'function',
        inputs: [{ name: 'account', type: 'address' }],
        outputs: [{ name: '', type: 'uint256' }],
        stateMutability: 'view',
    },
];
// Multicall3 getEthBalance ABI
const MULTICALL3_GET_ETH_BALANCE_ABI = [
    {
        name: 'getEthBalance',
        type: 'function',
        inputs: [{ name: 'addr', type: 'address' }],
        outputs: [{ name: 'balance', type: 'uint256' }],
        stateMutability: 'view',
    },
];
// Staking contract ABI with both getShares and convertToAssets
const STAKING_CONTRACT_ABI = [
    {
        inputs: [{ internalType: 'address', name: 'account', type: 'address' }],
        name: 'getShares',
        outputs: [{ internalType: 'uint256', name: '', type: 'uint256' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [{ internalType: 'uint256', name: 'shares', type: 'uint256' }],
        name: 'convertToAssets',
        outputs: [{ internalType: 'uint256', name: 'assets', type: 'uint256' }],
        stateMutability: 'view',
        type: 'function',
    },
];
const multicall = async (calls, multicallAddress, provider, maxCallsPerMulticall) => {
    const multicallContract = new contracts_1.Contract(multicallAddress, multicallAbi, provider);
    return await (0, assetsUtil_1.reduceInBatchesSerially)({
        values: calls,
        batchSize: maxCallsPerMulticall,
        initialResult: [],
        eachBatch: async (workingResult, batch) => {
            const calldata = batch.map((call) => ({
                target: call.contract.address,
                callData: call.contract.interface.encodeFunctionData(call.contract.interface.functions[call.functionSignature], call.arguments),
            }));
            const results = await multicallContract.callStatic.tryAggregate(false, calldata);
            return [
                ...workingResult,
                ...results.map((r, i) => ({
                    success: r.success,
                    value: r.success
                        ? batch[i].contract.interface.decodeFunctionResult(batch[i].functionSignature, r.returnData)[0]
                        : undefined,
                })),
            ];
        },
    });
};
const fallback = async (calls, maxCallsParallel) => {
    return await (0, assetsUtil_1.reduceInBatchesSerially)({
        values: calls,
        batchSize: maxCallsParallel,
        initialResult: [],
        eachBatch: async (workingResult, batch) => {
            const results = await Promise.allSettled(batch.map((call) => call.contract[call.functionSignature](...call.arguments)));
            return [
                ...workingResult,
                ...results.map((p) => ({
                    success: p.status === 'fulfilled',
                    value: p.status === 'fulfilled' ? p.value : undefined,
                })),
            ];
        },
    });
};
/**
 * Executes an array of contract calls. If the chain supports multicalls,
 * the calls will be executed in single RPC requests (up to maxCallsPerMulticall).
 * Otherwise the calls will be executed separately in parallel (up to maxCallsParallel).
 *
 * @param calls - An array of contract calls to execute.
 * @param chainId - The hexadecimal chain id.
 * @param provider - An ethers rpc provider.
 * @param maxCallsPerMulticall - If multicall is supported, the maximum number of calls to exeute in each multicall.
 * @param maxCallsParallel - If multicall is not supported, the maximum number of calls to execute in parallel.
 * @returns An array of results, with a success boolean and value for each call.
 */
const multicallOrFallback = async (calls, chainId, provider, maxCallsPerMulticall = 300, maxCallsParallel = 20) => {
    if (calls.length === 0) {
        return [];
    }
    const multicallAddress = MULTICALL_CONTRACT_BY_CHAINID[chainId];
    if (multicallAddress) {
        try {
            return await multicall(calls, multicallAddress, provider, maxCallsPerMulticall);
        }
        catch (error) {
            // Fallback only on revert
            // https://docs.ethers.org/v5/troubleshooting/errors/#help-CALL_EXCEPTION
            if (!error ||
                typeof error !== 'object' ||
                !('code' in error) ||
                error.code !== 'CALL_EXCEPTION') {
                throw error;
            }
        }
    }
    return await fallback(calls, maxCallsParallel);
};
exports.multicallOrFallback = multicallOrFallback;
/**
 * Execute multiple contract calls using Multicall3's aggregate3 function.
 * This allows for more efficient batch calls with individual failure handling.
 *
 * @param calls - Array of calls to execute via aggregate3
 * @param chainId - The hexadecimal chain id
 * @param provider - An ethers rpc provider
 * @returns Promise resolving to array of results from aggregate3
 */
const aggregate3 = async (calls, chainId, provider) => {
    if (calls.length === 0) {
        return [];
    }
    const multicall3Address = MULTICALL_CONTRACT_BY_CHAINID[chainId];
    const multicall3Contract = new contracts_1.Contract(multicall3Address, multicall3Abi, provider);
    return await multicall3Contract.callStatic.aggregate3(calls);
};
exports.aggregate3 = aggregate3;
/**
 * Processes and decodes balance results from aggregate3 calls
 *
 * @param results - Array of results from aggregate3 calls
 * @param callMapping - Array mapping call indices to token and user addresses
 * @param chainId - The hexadecimal chain id
 * @param provider - An ethers rpc provider
 * @param includeStaked - Whether to include staked balances
 * @returns Map of token address to map of user address to balance
 */
const processBalanceResults = (results, callMapping, chainId, provider, includeStaked) => {
    const balanceMap = {};
    const stakedBalanceMap = {};
    // Create contract instances for decoding
    const erc20Contract = new contracts_1.Contract(ZERO_ADDRESS, ERC20_BALANCE_OF_ABI, provider);
    const multicall3Address = MULTICALL_CONTRACT_BY_CHAINID[chainId];
    const multicall3Contract = new contracts_1.Contract(multicall3Address, MULTICALL3_GET_ETH_BALANCE_ABI, provider);
    // Staking contracts are now handled separately in two-step process
    results.forEach((result, index) => {
        if (result.success) {
            const { tokenAddress, userAddress, callType } = callMapping[index];
            if (callType === 'native') {
                // For native token, decode the getEthBalance result
                const balanceRaw = multicall3Contract.interface.decodeFunctionResult(GET_ETH_BALANCE_FUNCTION, result.returnData)[0];
                if (!balanceMap[tokenAddress]) {
                    balanceMap[tokenAddress] = {};
                }
                balanceMap[tokenAddress][userAddress] = new bn_js_1.default(balanceRaw.toString());
            }
            else if (callType === 'staking') {
                // Staking is now handled separately in two-step process
                // This case should not occur anymore
                console.warn('Staking callType found in main processing - this should not happen');
            }
            else {
                // For ERC20 tokens, decode the balanceOf result
                const balanceRaw = erc20Contract.interface.decodeFunctionResult(BALANCE_OF_FUNCTION, result.returnData)[0];
                if (!balanceMap[tokenAddress]) {
                    balanceMap[tokenAddress] = {};
                }
                balanceMap[tokenAddress][userAddress] = new bn_js_1.default(balanceRaw.toString());
            }
        }
    });
    const result = { tokenBalances: balanceMap };
    if (includeStaked && Object.keys(stakedBalanceMap).length > 0) {
        result.stakedBalances = stakedBalanceMap;
    }
    return result;
};
/**
 * Fallback function to get native token balances using individual eth_getBalance calls
 * when Multicall3 is not supported on the chain.
 *
 * @param userAddresses - Array of user addresses to check balances for
 * @param provider - An ethers rpc provider
 * @param maxCallsParallel - Maximum number of parallel calls (default: 20)
 * @returns Promise resolving to map of user address to balance
 */
const getNativeBalancesFallback = async (userAddresses, provider, maxCallsParallel = 20) => {
    const balanceMap = {};
    await (0, assetsUtil_1.reduceInBatchesSerially)({
        values: userAddresses,
        batchSize: maxCallsParallel,
        initialResult: undefined,
        eachBatch: async (_, batch) => {
            const results = await Promise.allSettled(batch.map(async (userAddress) => {
                const balance = await provider.getBalance(userAddress);
                return {
                    success: true,
                    balance: new bn_js_1.default(balance.toString()),
                    userAddress,
                };
            }));
            results.forEach((result) => {
                if (result.status === 'fulfilled' &&
                    result.value.success &&
                    result.value.balance !== null) {
                    balanceMap[result.value.userAddress] = result.value.balance;
                }
            });
        },
    });
    return balanceMap;
};
/**
 * Fallback function to get token balances using individual calls
 * when Multicall3 is not supported or when aggregate3 calls fail.
 *
 * @param tokenAddresses - Array of ERC20 token contract addresses
 * @param userAddresses - Array of user addresses to check balances for
 * @param provider - An ethers rpc provider
 * @param includeNative - Whether to include native token balances (default: true)
 * @param maxCallsParallel - Maximum number of parallel calls (default: 20)
 * @returns Promise resolving to map of token address to map of user address to balance
 */
const getTokenBalancesFallback = async (tokenAddresses, userAddresses, provider, includeNative, maxCallsParallel) => {
    const balanceMap = {};
    // Handle ERC20 token balances using the existing fallback function
    if (tokenAddresses.length > 0) {
        const erc20Calls = [];
        const callMapping = [];
        tokenAddresses.forEach((tokenAddress) => {
            userAddresses.forEach((userAddress) => {
                const contract = new contracts_1.Contract(tokenAddress, ERC20_BALANCE_OF_ABI, provider);
                erc20Calls.push({
                    contract,
                    functionSignature: BALANCE_OF_FUNCTION,
                    arguments: [userAddress],
                });
                callMapping.push({ tokenAddress, userAddress });
            });
        });
        const erc20Results = await fallback(erc20Calls, maxCallsParallel);
        erc20Results.forEach((result, index) => {
            if (result.success) {
                const { tokenAddress, userAddress } = callMapping[index];
                if (!balanceMap[tokenAddress]) {
                    balanceMap[tokenAddress] = {};
                }
                balanceMap[tokenAddress][userAddress] = result.value;
            }
        });
    }
    // Handle native token balances using the native fallback function
    if (includeNative) {
        const nativeBalances = await getNativeBalancesFallback(userAddresses, provider, maxCallsParallel);
        if (Object.keys(nativeBalances).length > 0) {
            balanceMap[ZERO_ADDRESS] = nativeBalances;
        }
    }
    return balanceMap;
};
/**
 * Fallback function to get staked balances using individual calls
 * when Multicall3 is not supported or when aggregate3 calls fail.
 *
 * @param userAddresses - Array of user addresses to check staked balances for
 * @param chainId - The hexadecimal chain id
 * @param provider - An ethers rpc provider
 * @param maxCallsParallel - Maximum number of parallel calls (default: 20)
 * @returns Promise resolving to map of user address to staked balance
 */
const getStakedBalancesFallback = async (userAddresses, chainId, provider, maxCallsParallel) => {
    const stakedBalanceMap = {};
    const stakingContractAddress = AssetsContractController_1.STAKING_CONTRACT_ADDRESS_BY_CHAINID[chainId];
    if (!stakingContractAddress) {
        // No staking support for this chain
        return stakedBalanceMap;
    }
    const stakingCalls = [];
    const callMapping = [];
    userAddresses.forEach((userAddress) => {
        const contract = new contracts_1.Contract(stakingContractAddress, STAKING_CONTRACT_ABI, provider);
        stakingCalls.push({
            contract,
            functionSignature: GET_SHARES_FUNCTION,
            arguments: [userAddress],
        });
        callMapping.push({ userAddress });
    });
    const stakingResults = await fallback(stakingCalls, maxCallsParallel);
    stakingResults.forEach((result, index) => {
        if (result.success) {
            const { userAddress } = callMapping[index];
            stakedBalanceMap[userAddress] = result.value;
        }
    });
    return stakedBalanceMap;
};
/**
 * Get staked balances for multiple addresses using two-step process:
 * 1. Get shares for all addresses
 * 2. Convert non-zero shares to assets
 *
 * @param userAddresses - Array of user addresses to check
 * @param chainId - Chain ID as hex string
 * @param provider - Ethers provider
 * @returns Promise resolving to map of user address to staked balance
 */
const getStakedBalancesForAddresses = async (userAddresses, chainId, provider) => {
    const stakingContractAddress = AssetsContractController_1.STAKING_CONTRACT_ADDRESS_BY_CHAINID[chainId];
    if (!stakingContractAddress) {
        return {};
    }
    const stakingContract = new contracts_1.Contract(stakingContractAddress, STAKING_CONTRACT_ABI, provider);
    try {
        // Step 1: Get shares for all addresses
        const shareCalls = userAddresses.map((userAddress) => ({
            target: stakingContractAddress,
            allowFailure: true,
            callData: stakingContract.interface.encodeFunctionData(GET_SHARES_FUNCTION, [userAddress]),
        }));
        const shareResults = await (0, exports.aggregate3)(shareCalls, chainId, provider);
        // Step 2: For addresses with non-zero shares, convert to assets
        const nonZeroSharesData = [];
        shareResults.forEach((result, index) => {
            if (result.success) {
                const sharesRaw = stakingContract.interface.decodeFunctionResult(GET_SHARES_FUNCTION, result.returnData)[0];
                const shares = new bn_js_1.default(sharesRaw.toString());
                if (shares.gt(new bn_js_1.default(0))) {
                    nonZeroSharesData.push({
                        address: userAddresses[index],
                        shares,
                    });
                }
            }
        });
        if (nonZeroSharesData.length === 0) {
            return {};
        }
        // Step 3: Convert shares to assets for addresses with non-zero shares
        const assetCalls = nonZeroSharesData.map(({ shares }) => ({
            target: stakingContractAddress,
            allowFailure: true,
            callData: stakingContract.interface.encodeFunctionData(CONVERT_TO_ASSETS_FUNCTION, [shares.toString()]),
        }));
        const assetResults = await (0, exports.aggregate3)(assetCalls, chainId, provider);
        // Step 4: Build final result mapping
        const result = {};
        assetResults.forEach((assetResult, index) => {
            if (assetResult.success) {
                const assetsRaw = stakingContract.interface.decodeFunctionResult(CONVERT_TO_ASSETS_FUNCTION, assetResult.returnData)[0];
                const assets = new bn_js_1.default(assetsRaw.toString());
                const { address } = nonZeroSharesData[index];
                result[address] = assets;
            }
        });
        return result;
    }
    catch (error) {
        console.error('Error fetching staked balances:', error);
        return {};
    }
};
exports.getStakedBalancesForAddresses = getStakedBalancesForAddresses;
/**
 * Get token balances (both ERC20 and native) for multiple addresses using aggregate3.
 * This is more efficient than individual balanceOf calls for multiple addresses and tokens.
 * Native token balances are mapped to the zero address (0x0000000000000000000000000000000000000000).
 *
 * @param accountTokenGroups - Array of objects containing account addresses and their associated token addresses
 * @param chainId - The hexadecimal chain id
 * @param provider - An ethers rpc provider
 * @param includeNative - Whether to include native token balances (default: true)
 * @param includeStaked - Whether to include staked balances from supported staking contracts (default: false)
 * @returns Promise resolving to object containing tokenBalances map and optional stakedBalances map
 */
const getTokenBalancesForMultipleAddresses = async (accountTokenGroups, chainId, provider, includeNative, includeStaked) => {
    // Return early if no groups provided
    if (accountTokenGroups.length === 0 && !includeNative && !includeStaked) {
        return { tokenBalances: {} };
    }
    // Extract unique token addresses and user addresses from groups
    const uniqueTokenAddresses = Array.from(new Set(accountTokenGroups.flatMap((group) => group.tokenAddresses))).filter((tokenAddress) => tokenAddress !== ZERO_ADDRESS); // Exclude native token from ERC20 calls
    const uniqueUserAddresses = Array.from(new Set(accountTokenGroups.map((group) => group.accountAddress)));
    // Check if Multicall3 is supported on this chain
    if (!MULTICALL_CONTRACT_BY_CHAINID[chainId]) {
        // Fallback to individual balance calls when Multicall3 is not supported
        const tokenBalances = await getTokenBalancesFallback(uniqueTokenAddresses, uniqueUserAddresses, provider, includeNative, 20);
        const result = { tokenBalances };
        // Handle staked balances fallback if requested
        if (includeStaked) {
            const stakedBalances = await getStakedBalancesFallback(uniqueUserAddresses, chainId, provider, 20);
            if (Object.keys(stakedBalances).length > 0) {
                result.stakedBalances = stakedBalances;
            }
        }
        return result;
    }
    try {
        // Create calls directly from pairs
        const allCalls = [];
        const allCallMapping = [];
        // Create a temporary ERC20 contract for encoding
        const tempERC20Contract = new contracts_1.Contract(ZERO_ADDRESS, ERC20_BALANCE_OF_ABI, provider);
        // Create ERC20 balance calls for all account-token combinations
        accountTokenGroups.forEach((group) => {
            group.tokenAddresses
                .filter((tokenAddress) => tokenAddress !== ZERO_ADDRESS)
                .forEach((tokenAddress) => {
                allCalls.push({
                    target: tokenAddress,
                    allowFailure: true,
                    callData: tempERC20Contract.interface.encodeFunctionData(BALANCE_OF_FUNCTION, [group.accountAddress]),
                });
                allCallMapping.push({
                    tokenAddress,
                    userAddress: group.accountAddress,
                    callType: 'erc20',
                });
            });
        });
        // Add native token balance calls if requested
        if (includeNative) {
            const multicall3Address = MULTICALL_CONTRACT_BY_CHAINID[chainId];
            const multicall3TempContract = new contracts_1.Contract(multicall3Address, MULTICALL3_GET_ETH_BALANCE_ABI, provider);
            uniqueUserAddresses.forEach((userAddress) => {
                allCalls.push({
                    target: multicall3Address,
                    allowFailure: true,
                    callData: multicall3TempContract.interface.encodeFunctionData(GET_ETH_BALANCE_FUNCTION, [userAddress]),
                });
                allCallMapping.push({
                    tokenAddress: ZERO_ADDRESS,
                    userAddress,
                    callType: 'native',
                });
            });
        }
        // Note: Staking balances will be handled separately in two steps after token/native calls
        // Execute all calls in batches
        const maxCallsPerBatch = 300; // Limit calls per batch to avoid gas/size limits
        const allResults = [];
        await (0, assetsUtil_1.reduceInBatchesSerially)({
            values: allCalls,
            batchSize: maxCallsPerBatch,
            initialResult: undefined,
            eachBatch: async (_, batch) => {
                const batchResults = await (0, exports.aggregate3)(batch, chainId, provider);
                allResults.push(...batchResults);
            },
        });
        // Handle staking balances in two steps if requested
        let stakedBalances = {};
        if (includeStaked) {
            stakedBalances = await (0, exports.getStakedBalancesForAddresses)(uniqueUserAddresses, chainId, provider);
        }
        // Process and return results
        const result = processBalanceResults(allResu