LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\add-ethereum-chain.js", {"../../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../../../shared/modules/rpc.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\rpc.utils.js","../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../../../../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts","../../../../helpers/constants/zendesk-url":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\zendesk-url.js","../../utils/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\confirm.ts","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cconfirmation%5Ctemplates%5Cadd-ethereum-chain.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _rpcErrors = require("@metamask/rpc-errors");
var _networkController = require("@metamask/network-controller");
var _controllerUtils = require("@metamask/controller-utils");
var _network = require("../../../../../shared/constants/network");
var _designSystem = require("../../../../helpers/constants/design-system");
var _routes = require("../../../../helpers/constants/routes");
var _zendeskUrl = _interopRequireDefault(require("../../../../helpers/constants/zendesk-url"));
var _rpc = require("../../../../../shared/modules/rpc.utils");
var _confirm = require("../../utils/confirm");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const UNRECOGNIZED_CHAIN = {
  id: 'UNRECOGNIZED_CHAIN',
  severity: _designSystem.Severity.Warning,
  content: {
    element: 'span',
    children: {
      element: 'MetaMaskTranslation',
      props: {
        translationKey: 'unrecognizedChain'
      }
    }
  }
};
const SAFE_CHAIN_LIST_PROVIDER_ERROR = {
  id: 'SAFE_CHAIN_LIST_PROVIDER_ERROR',
  severity: _designSystem.Severity.Warning,
  content: {
    element: 'span',
    children: {
      element: 'MetaMaskTranslation',
      props: {
        translationKey: 'errorGettingSafeChainList'
      }
    }
  }
};
const MISMATCHED_CHAIN_RECOMMENDATION = {
  id: 'MISMATCHED_CHAIN_RECOMMENDATION',
  severity: _designSystem.Severity.Warning,
  content: {
    element: 'span',
    children: {
      element: 'MetaMaskTranslation',
      props: {
        translationKey: 'mismatchedChainRecommendation',
        variables: [{
          element: 'a',
          key: 'mismatchedChainLink',
          props: {
            href: _zendeskUrl.default.VERIFY_CUSTOM_NETWORK,
            target: '__blank',
            tabIndex: 0
          },
          children: {
            element: 'MetaMaskTranslation',
            props: {
              translationKey: 'mismatchedChainLinkText'
            }
          }
        }]
      }
    }
  }
};
const DEPRECATED_CHAIN_ALERT = {
  id: 'DEPRECATED_CHAIN_ALERT',
  severity: _designSystem.Severity.Warning,
  content: {
    element: 'span',
    children: {
      element: 'MetaMaskTranslation',
      props: {
        translationKey: 'deprecatedNetwork'
      }
    }
  }
};
const MISMATCHED_NETWORK_NAME = {
  id: 'MISMATCHED_NETWORK_NAME',
  severity: _designSystem.Severity.Warning,
  content: {
    element: 'span',
    children: {
      element: 'MetaMaskTranslation',
      props: {
        translationKey: 'mismatchedNetworkName'
      }
    }
  }
};
const MISMATCHED_NETWORK_SYMBOL = {
  id: 'MISMATCHED_NETWORK_SYMBOL',
  severity: _designSystem.Severity.Danger,
  content: {
    element: 'span',
    children: {
      element: 'MetaMaskTranslation',
      props: {
        translationKey: 'mismatchedNetworkSymbol'
      }
    }
  }
};
const MISMATCHED_NETWORK_RPC = {
  id: 'MISMATCHED_NETWORK_RPC',
  severity: _designSystem.Severity.Danger,
  content: {
    element: 'span',
    children: {
      element: 'MetaMaskTranslation',
      props: {
        translationKey: 'mismatchedRpcUrl'
      }
    }
  }
};
const MISMATCHED_NETWORK_RPC_CHAIN_ID = {
  id: 'MISMATCHED_NETWORK_RPC_CHAIN_ID',
  severity: _designSystem.Severity.Danger,
  content: {
    element: 'span',
    children: {
      element: 'MetaMaskTranslation',
      props: {
        translationKey: 'mismatchedRpcChainId'
      }
    }
  }
};
const ERROR_CONNECTING_TO_RPC = {
  id: 'ERROR_CONNECTING_TO_RPC',
  severity: _designSystem.Severity.Danger,
  content: {
    element: 'span',
    children: {
      element: 'MetaMaskTranslation',
      props: {
        translationKey: 'errorWhileConnectingToRPC'
      }
    }
  }
};
async function getAlerts(pendingApproval, data) {
  const alerts = [];
  const originIsMetaMask = pendingApproval.origin === 'metamask';
  if (originIsMetaMask && Boolean(data.matchedChain)) {
    return [];
  }
  if (data.matchedChain) {
    var _data$matchedChain$na, _networkByPassingVali, _data$matchedChain$na2, _requestData$ticker, _networkByPassingVali2, _requestData$ticker2, _data$matchedChain$rp, _networkByPassingVali3;
    const {
      requestData
    } = pendingApproval;
    const networkByPassingValidation = _controllerUtils.NETWORKS_BYPASSING_VALIDATION[requestData.chainId.toLowerCase()];
    if (((_data$matchedChain$na = data.matchedChain.name) === null || _data$matchedChain$na === void 0 ? void 0 : _data$matchedChain$na.toLowerCase()) !== requestData.chainName.toLowerCase() && (networkByPassingValidation === null || networkByPassingValidation === void 0 || (_networkByPassingVali = networkByPassingValidation.name) === null || _networkByPassingVali === void 0 ? void 0 : _networkByPassingVali.toLowerCase()) !== requestData.chainName.toLowerCase()) {
      alerts.push(MISMATCHED_NETWORK_NAME);
    }
    if (((_data$matchedChain$na2 = data.matchedChain.nativeCurrency) === null || _data$matchedChain$na2 === void 0 || (_data$matchedChain$na2 = _data$matchedChain$na2.symbol) === null || _data$matchedChain$na2 === void 0 ? void 0 : _data$matchedChain$na2.toLowerCase()) !== ((_requestData$ticker = requestData.ticker) === null || _requestData$ticker === void 0 ? void 0 : _requestData$ticker.toLowerCase()) && (networkByPassingValidation === null || networkByPassingValidation === void 0 || (_networkByPassingVali2 = networkByPassingValidation.symbol) === null || _networkByPassingVali2 === void 0 ? void 0 : _networkByPassingVali2.toLowerCase()) !== ((_requestData$ticker2 = requestData.ticker) === null || _requestData$ticker2 === void 0 ? void 0 : _requestData$ticker2.toLowerCase())) {
      alerts.push(MISMATCHED_NETWORK_SYMBOL);
    }
    const {
      origin
    } = new URL(requestData.rpcUrl);
    if (!((_data$matchedChain$rp = data.matchedChain.rpc) !== null && _data$matchedChain$rp !== void 0 && _data$matchedChain$rp.map(rpc => new URL(rpc).origin).includes(origin)) && !(networkByPassingValidation !== null && networkByPassingValidation !== void 0 && (_networkByPassingVali3 = networkByPassingValidation.rpcUrl) !== null && _networkByPassingVali3 !== void 0 && _networkByPassingVali3.includes(origin))) {
      alerts.push(MISMATCHED_NETWORK_RPC);
    }
    if (_network.DEPRECATED_NETWORKS.includes(requestData.chainId)) {
      alerts.push(DEPRECATED_CHAIN_ALERT);
    }
  }
  if (!data.matchedChain && data.useSafeChainsListValidation) {
    if (data.providerError) {
      alerts.push(SAFE_CHAIN_LIST_PROVIDER_ERROR);
    } else {
      alerts.push(UNRECOGNIZED_CHAIN);
    }
  }
  if (alerts.length) {
    alerts.push(MISMATCHED_CHAIN_RECOMMENDATION);
  }
  return alerts;
}
function getState(pendingApproval) {
  if (parseInt(pendingApproval.requestData.chainId, 16) === 1) {
    return {
      useWarningModal: true
    };
  }
  return {};
}
function getValues(pendingApproval, t, actions, history, data) {
  var _customRpcUrl$toLower;
  const originIsMetaMask = pendingApproval.origin === 'metamask';
  const customRpcUrl = pendingApproval.requestData.rpcUrl;
  let title;
  if (originIsMetaMask) {
    title = t('wantToAddThisNetwork');
  } else if (data.existingNetworkConfiguration) {
    title = t('updateNetworkConfirmationTitle', [data.existingNetworkConfiguration.name]);
  } else {
    title = t('addNetworkConfirmationTitle', [pendingApproval.requestData.chainName]);
  }
  let subtitle;
  if (data.existingNetworkConfiguration) {
    subtitle = t('updateEthereumChainConfirmationDescription');
  } else {
    subtitle = t('multichainAddEthereumChainConfirmationDescription');
  }
  return {
    content: [{
      element: 'Typography',
      key: 'title',
      children: title,
      props: {
        variant: _designSystem.TypographyVariant.H3,
        align: 'center',
        fontWeight: 'bold',
        boxProps: {
          margin: [0, 0, 4]
        }
      }
    }, {
      element: 'Typography',
      key: 'description',
      children: subtitle,
      props: {
        variant: _designSystem.TypographyVariant.H6,
        align: 'center',
        boxProps: {
          margin: originIsMetaMask ? [0, 8, 4] : [0, 0, 4]
        }
      }
    }, {
      element: 'OriginPill',
      key: 'origin-pill',
      props: {
        origin: pendingApproval.origin,
        dataTestId: 'signature-origin-pill'
      }
    }, {
      element: 'TruncatedDefinitionList',
      key: 'network-details',
      props: {
        title: t('networkDetails'),
        tooltips: {
          [t('currencySymbol')]: t('currencySymbolDefinition'),
          [t('networkURL')]: t('networkURLDefinition'),
          [t('chainId')]: t('chainIdDefinition'),
          [t('networkName')]: t('networkNameDefinition'),
          [t('blockExplorerUrl')]: t('blockExplorerUrlDefinition')
        },
        warnings: {
          [t('networkURL')]: !customRpcUrl || (0, _confirm.isValidASCIIURL)(customRpcUrl) ? undefined : t('networkUrlErrorWarning', [(0, _confirm.toPunycodeURL)(customRpcUrl)]),
          [t('currencySymbol')]: data.currencySymbolWarning
        },
        dictionary: {
          [t('currencySymbol')]: pendingApproval.requestData.ticker,
          [t('networkURL')]: (_customRpcUrl$toLower = customRpcUrl.toLowerCase()) !== null && _customRpcUrl$toLower !== void 0 && _customRpcUrl$toLower.includes(`/v3/${_network.infuraProjectId}`) ? customRpcUrl.replace(`/v3/${_network.infuraProjectId}`, '').toLowerCase() : customRpcUrl.toLowerCase(),
          [t('chainId')]: parseInt(pendingApproval.requestData.chainId, 16),
          [t('networkName')]: pendingApproval.requestData.chainName,
          [t('blockExplorerUrl')]: pendingApproval.requestData.rpcPrefs.blockExplorerUrl
        },
        prefaceKeys: [t('currencySymbol'), t('networkURL')]
      }
    }, {
      element: 'Typography',
      key: 'only-add-networks-you-trust',
      children: [{
        element: 'MetaMaskTranslation',
        key: 'learn-about-risks',
        props: {
          translationKey: 'watchOutMessage',
          variables: [{
            element: 'a',
            children: t('securityMessageLinkForNetworks'),
            key: 'securityMessageLinkForNetworks',
            props: {
              href: _zendeskUrl.default.USER_GUIDE_CUSTOM_NETWORKS,
              target: '__blank'
            }
          }]
        }
      }],
      props: {
        variant: _designSystem.TypographyVariant.H6,
        boxProps: {
          margin: originIsMetaMask ? [0, 8] : 0,
          display: _designSystem.Display.Flex,
          flexDirection: _designSystem.FlexDirection.Column,
          alignItems: _designSystem.AlignItems.center
        }
      }
    }],
    cancelText: t('cancel'),
    submitText: t('approveButtonText'),
    onSubmit: async () => {
      let endpointChainId;
      try {
        endpointChainId = await (0, _rpc.jsonRpcRequest)(customRpcUrl, 'eth_chainId');
      } catch (err) {
        console.error(`Request for method 'eth_chainId on ${customRpcUrl} failed`);
        return [ERROR_CONNECTING_TO_RPC];
      }
      if (pendingApproval.requestData.chainId !== endpointChainId) {
        console.error(`Chain ID returned by RPC URL ${customRpcUrl} does not match ${endpointChainId}`);
        return [MISMATCHED_NETWORK_RPC_CHAIN_ID];
      }
      await actions.resolvePendingApproval(pendingApproval.id, pendingApproval.requestData);
      if (originIsMetaMask) {
        const blockExplorer = pendingApproval.requestData.rpcPrefs.blockExplorerUrl;
        const addedNetwork = await actions.addNetwork({
          chainId: pendingApproval.requestData.chainId,
          name: pendingApproval.requestData.chainName,
          nativeCurrency: pendingApproval.requestData.ticker,
          blockExplorerUrls: blockExplorer ? [blockExplorer] : [],
          defaultBlockExplorerUrlIndex: blockExplorer ? 0 : undefined,
          defaultRpcEndpointIndex: 0,
          rpcEndpoints: [{
            url: pendingApproval.requestData.rpcUrl,
            failoverUrls: pendingApproval.requestData.failoverRpcUrls,
            type: _networkController.RpcEndpointType.Custom
          }]
        });
        await actions.setNewNetworkAdded({
          networkConfigurationId: addedNetwork.rpcEndpoints[0].networkClientId,
          nickname: pendingApproval.requestData.chainName
        });
        const locationPath = document.location.hash.replace('#', '/');
        const isOnboardingRoute = locationPath === _routes.ONBOARDING_PRIVACY_SETTINGS_ROUTE;
        if (!isOnboardingRoute) {
          history.push(_routes.DEFAULT_ROUTE);
        }
      }
      return [];
    },
    onCancel: () => actions.rejectPendingApproval(pendingApproval.id, _rpcErrors.providerErrors.userRejectedRequest().serialize()),
    networkDisplay: !originIsMetaMask
  };
}
const addEthereumChain = {
  getAlerts,
  getValues,
  getState
};
var _default = exports.default = addEthereumChain;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\confirmation\\templates\\add-ethereum-chain.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\create-named-snap-account.js", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cconfirmation%5Ctemplates%5Ccreate-named-snap-account.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _metametrics = require("../../../../../shared/constants/metametrics");
/**
 * Returns the templated values to be consumed in the confirmation page.
 *
 * @param {object} pendingApproval - The pending confirmation object.
 * @param {Function} t - Translation function.
 * @param {object} actions - Object containing safe actions that the template can invoke.
 * @param {object} _history - The application's history object (not used in this function).
 * @param {object} _data - The data object passed into the template from the confirmation page (not
 *   used in this function).
 * @param {object} contexts - Context objects passed into the template from the confirmation page.
 * @returns {object} An object containing templated values for the confirmation page.
 */
function getValues(pendingApproval, t, actions, _history, _data, contexts) {
  const {
    origin: snapId,
    snapName,
    requestData
  } = pendingApproval;
  const {
    snapSuggestedAccountName
  } = requestData;
  const {
    trackEvent
  } = contexts;
  const trackSnapAccountEvent = event => {
    trackEvent({
      event,
      category: _metametrics.MetaMetricsEventCategory.Accounts,
      properties: {
        account_type: _metametrics.MetaMetricsEventAccountType.Snap,
        snap_id: snapId,
        snap_name: snapName
      }
    });
  };
  const onActionComplete = async result => {
    if (result.success) {
      trackSnapAccountEvent(_metametrics.MetaMetricsEventName.AddSnapAccountConfirmed);
      actions.resolvePendingApproval(pendingApproval.id, result);
    } else {
      trackSnapAccountEvent(_metametrics.MetaMetricsEventName.AddSnapAccountCanceled);
      // ! Resolve the pending approval to indicate that the user has canceled the flow. We do not
      // ! reject the approval but resolve with `false` for `SnapKeyring` to handle cancellation.
      actions.resolvePendingApproval(pendingApproval.id, false);
    }
  };
  return {
    content: [{
      element: 'CreateNamedSnapAccount',
      key: 'create-named-snap-account',
      props: {
        onActionComplete,
        snapSuggestedAccountName
      }
    }],
    loadingText: t('addingAccount'),
    hideSubmitButton: true,
    onLoad: () => trackSnapAccountEvent(_metametrics.MetaMetricsEventName.AddSnapAccountViewed)
  };
}
const createNamedSnapAccount = {
  getValues
};
var _default = exports.default = createNamedSnapAccount;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\confirmation\\templates\\create-named-snap-account.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\create-snap-account.js", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cconfirmation%5Ctemplates%5Ccreate-snap-account.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _metametrics = require("../../../../../shared/constants/metametrics");
function getValues(pendingApproval, t, actions, _history, _data, contexts) {
  const {
    origin: snapId,
    snapName
  } = pendingApproval;
  const {
    trackEvent
  } = contexts;
  const trackSnapAccountEvent = event => {
    trackEvent({
      event,
      category: _metametrics.MetaMetricsEventCategory.Accounts,
      properties: {
        account_type: _metametrics.MetaMetricsEventAccountType.Snap,
        snap_id: snapId,
        snap_name: snapName
      }
    });
  };
  const onCancel = () => {
    trackSnapAccountEvent(_metametrics.MetaMetricsEventName.AddSnapAccountCanceled);
    actions.resolvePendingApproval(pendingApproval.id, false);
  };
  return {
    content: [{
      element: 'CreateSnapAccount',
      key: 'create-snap-account',
      props: {
        snapId,
        snapName,
        onCancel
      }
    }],
    cancelText: t('cancel'),
    submitText: t('create'),
    onLoad: () => trackSnapAccountEvent(_metametrics.MetaMetricsEventName.AddSnapAccountViewed),
    onSubmit: () => {
      trackSnapAccountEvent(_metametrics.MetaMetricsEventName.AddSnapAccountConfirmed);
      actions.resolvePendingApproval(pendingApproval.id, true);
    },
    onCancel
  };
}
const createSnapAccount = {
  getValues
};
var _default = exports.default = createSnapAccount;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\confirmation\\templates\\create-snap-account.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\error.js", {"../ResultTemplate":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\ResultTemplate.ts","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cconfirmation%5Ctemplates%5Cerror.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _controllerUtils = require("@metamask/controller-utils");
var _ResultTemplate = require("../ResultTemplate");
const template = new _ResultTemplate.ResultTemplate(_controllerUtils.ApprovalType.ResultError);
const error = {
  getValues: template.getValues.bind(template)
};
var _default = exports.default = error;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\confirmation\\templates\\error.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\hyperliquid-referral-consent.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cconfirmation%5Ctemplates%5Chyperliquid-referral-consent.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
/**
 * Returns the templated values to be consumed in the confirmation page.
 *
 * @param pendingApproval - The pending confirmation object.
 * @param _t - Translation function.
 * @param actions - Object containing safe actions that the template can invoke.
 * @returns An object containing templated values for the confirmation page.
 */
function getValues(pendingApproval, _t, actions) {
  const {
    requestData
  } = pendingApproval;
  const {
    selectedAddress
  } = requestData;
  const onActionComplete = result => {
    actions.resolvePendingApproval(pendingApproval.id, {
      approved: result.approved,
      selectedAddress: result.selectedAddress
    });
  };
  return {
    content: [{
      element: 'HyperliquidReferralConsent',
      key: 'hyperliquid-referral-consent',
      props: {
        onActionComplete,
        selectedAddress
      }
    }],
    hideSubmitButton: true
  };
}
const hyperliquidReferralConsent = {
  getValues
};
var _default = exports.default = hyperliquidReferralConsent;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\confirmation\\templates\\hyperliquid-referral-consent.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\index.js", {"../../../../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../../../store/actions":"D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts","./add-ethereum-chain":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\add-ethereum-chain.js","./create-named-snap-account":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\create-named-snap-account.js","./create-snap-account":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\create-snap-account.js","./error":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\error.js","./hyperliquid-referral-consent":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\hyperliquid-referral-consent.ts","./remove-snap-account":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\remove-snap-account.js","./smart-transaction-status-page":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\smart-transaction-status-page.js","./snap-account-redirect":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\snap-account-redirect.js","./snaps/snap-alert/snap-alert":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\snaps\\snap-alert\\snap-alert.js","./snaps/snap-confirmation/snap-confirmation":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\snaps\\snap-confirmation\\snap-confirmation.js","./snaps/snap-default/snap-default":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\snaps\\snap-default\\snap-default.js","./snaps/snap-prompt/snap-prompt":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\snaps\\snap-prompt\\snap-prompt.js","./success":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\success.js","./switch-ethereum-chain":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\switch-ethereum-chain.js","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cconfirmation%5Ctemplates%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TEMPLATED_CONFIRMATION_APPROVAL_TYPES = void 0;
exports.getTemplateAlerts = getTemplateAlerts;
exports.getTemplateState = getTemplateState;
exports.getTemplateValues = getTemplateValues;
var _lodash = require("lodash");
var _controllerUtils = require("@metamask/controller-utils");
var _actions = require("../../../../store/actions");
var _app = require("../../../../../shared/constants/app");
var _smartTransactionStatusPage = _interopRequireDefault(require("./smart-transaction-status-page"));
var _createSnapAccount = _interopRequireDefault(require("./create-snap-account"));
var _removeSnapAccount = _interopRequireDefault(require("./remove-snap-account"));
var _snapAccountRedirect = _interopRequireDefault(require("./snap-account-redirect"));
var _createNamedSnapAccount = _interopRequireDefault(require("./create-named-snap-account"));
var _addEthereumChain = _interopRequireDefault(require("./add-ethereum-chain"));
var _switchEthereumChain = _interopRequireDefault(require("./switch-ethereum-chain"));
var _success = _interopRequireDefault(require("./success"));
var _error = _interopRequireDefault(require("./error"));
var _snapAlert = _interopRequireDefault(require("./snaps/snap-alert/snap-alert"));
var _snapConfirmation = _interopRequireDefault(require("./snaps/snap-confirmation/snap-confirmation"));
var _snapPrompt = _interopRequireDefault(require("./snaps/snap-prompt/snap-prompt"));
var _snapDefault = _interopRequireDefault(require("./snaps/snap-default/snap-default"));
var _hyperliquidReferralConsent = _interopRequireDefault(require("./hyperliquid-referral-consent"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)

///: END:ONLY_INCLUDE_IF

const APPROVAL_TEMPLATES = {
  [_controllerUtils.ApprovalType.AddEthereumChain]: _addEthereumChain.default,
  [_controllerUtils.ApprovalType.SwitchEthereumChain]: _switchEthereumChain.default,
  // Use ApprovalType from utils controller
  [_controllerUtils.ApprovalType.ResultSuccess]: _success.default,
  [_controllerUtils.ApprovalType.ResultError]: _error.default,
  [_app.SMART_TRANSACTION_CONFIRMATION_TYPES.showSmartTransactionStatusPage]: _smartTransactionStatusPage.default,
  [_controllerUtils.ApprovalType.SnapDialogAlert]: _snapAlert.default,
  [_controllerUtils.ApprovalType.SnapDialogConfirmation]: _snapConfirmation.default,
  [_controllerUtils.ApprovalType.SnapDialogPrompt]: _snapPrompt.default,
  [_controllerUtils.ApprovalType.SnapDialogDefault]: _snapDefault.default,
  ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
  [_app.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.confirmAccountCreation]: _createSnapAccount.default,
  [_app.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.confirmAccountRemoval]: _removeSnapAccount.default,
  [_app.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.showNameSnapAccount]: _createNamedSnapAccount.default,
  [_app.SNAP_MANAGE_ACCOUNTS_CONFIRMATION_TYPES.showSnapAccountRedirect]: _snapAccountRedirect.default,
  ///: END:ONLY_INCLUDE_IF
  [_app.HYPERLIQUID_APPROVAL_TYPE]: _hyperliquidReferralConsent.default
};
const TEMPLATED_CONFIRMATION_APPROVAL_TYPES = exports.TEMPLATED_CONFIRMATION_APPROVAL_TYPES = Object.keys(APPROVAL_TEMPLATES);
const ALLOWED_TEMPLATE_KEYS = ['cancelText', 'content', 'onLoad', 'onCancel', 'onSubmit', 'networkDisplay', 'submitText', 'loadingText', 'hideSubmitButton'];

/**
 * @typedef {object} PendingApproval
 * @property {string} id - The randomly generated id of the approval
 * @property {string} origin - The origin of the site requesting this approval
 * @property {number} time - The time the approval was requested
 * @property {string} type - The type of approval being requested
 * @property {object} requestData - The data submitted with the request
 */

/**
 * getTemplateAlerts calls the getAlerts function exported by the template if
 * it exists, and then returns the result of that function. In the confirmation
 * page the alerts returned from the getAlerts method will be set into the
 * alertState state object.
 *
 * @param {object} pendingApproval - the object representing the confirmation
 * @param {object} state - The state object consist of required info to determine alerts.
 */
async function getTemplateAlerts(pendingApproval, state) {
  var _APPROVAL_TEMPLATES$p;
  const fn = (_APPROVAL_TEMPLATES$p = APPROVAL_TEMPLATES[pendingApproval.type]) === null || _APPROVAL_TEMPLATES$p === void 0 ? void 0 : _APPROVAL_TEMPLATES$p.getAlerts;
  const results = fn ? await fn(pendingApproval, state) : [];
  if (!Array.isArray(results)) {
    throw new Error(`Template alerts must be an array, received: ${results}`);
  }
  if (results.some(result => (result === null || result === void 0 ? void 0 : result.id) === undefined)) {
    throw new Error(`Template alert entries must be objects with an id key. Received: ${results}`);
  }
  return results;
}

/**
 * The function call to return state must be a promise returning function
 * this "NOOP" is here to conform to the requirements for templates without
 * state.
 */
async function emptyState() {
  return {};
}

/**
 * getTemplateState calls the getState function exported by the template if
 * it exists, and then returns the result of that function. In the confirmation
 * page the object returned from the getState method will be set into the
 * confirmationState state object. Note, this state is not consumed by the page
 * itself.
 *
 * @param {object} pendingApproval - the object representing the confirmation
 */
async function getTemplateState(pendingApproval) {
  var _APPROVAL_TEMPLATES$p2;
  const fn = ((_APPROVAL_TEMPLATES$p2 = APPROVAL_TEMPLATES[pendingApproval.type]) === null || _APPROVAL_TEMPLATES$p2 === void 0 ? void 0 : _APPROVAL_TEMPLATES$p2.getState) ?? emptyState;
  const result = await fn(pendingApproval);
  if (typeof result !== 'object' || Array.isArray(result)) {
    throw new Error(`Template state must be an object, received: ${result}`);
  } else if (result === null || result === undefined) {
    return {};
  }
  return result;
}

/**
 * We do not want to pass the entire dispatch function to the template.
 * This function should return an object of actions that we generally consider
 * to be safe for templates to invoke. In the future we could put these behind
 * permission sets so that snaps that wish to manipulate state must ask for
 * explicit permission to do so.
 *
 * @param {Function} dispatch - Redux dispatch function
 */
function getAttenuatedDispatch(dispatch) {
  return {
    rejectPendingApproval: (...args) => dispatch((0, _actions.rejectPendingApproval)(...args)),
    resolvePendingApproval: (...args) => dispatch((0, _actions.resolvePendingApproval)(...args)),
    addNetwork: (...args) => dispatch((0, _actions.addNetwork)(...args)),
    setNewNetworkAdded: (...args) => dispatch((0, _actions.setNewNetworkAdded)(...args)),
    deleteInterface: (...args) => dispatch((0, _actions.deleteInterface)(...args))
  };
}

/**
 * Returns the templated values to be consumed in the confirmation page
 *
 * @param {object} pendingApproval - The pending confirmation object.
 * @param {Function} t - Translation function.
 * @param {Function} dispatch - Redux dispatch function.
 * @param {object} history - The application's history object.
 * @param {object} data - The data object passed into the template from the confirmation page.
 * @param {object} contexts - Contexts objects passed into the template from the confirmation page.
 */
function getTemplateValues(pendingApproval, t, dispatch, history, data, contexts) {
  var _APPROVAL_TEMPLATES$p3;
  const fn = (_APPROVAL_TEMPLATES$p3 = APPROVAL_TEMPLATES[pendingApproval.type]) === null || _APPROVAL_TEMPLATES$p3 === void 0 ? void 0 : _APPROVAL_TEMPLATES$p3.getValues;
  if (!fn) {
    throw new Error(`MESSAGE_TYPE: '${pendingApproval.type}' is not specified in approval templates`);
  }
  const safeActions = getAttenuatedDispatch(dispatch);
  const values = fn(pendingApproval, t, safeActions, history, data, contexts);
  const extraneousKeys = (0, _lodash.omit)(values, ALLOWED_TEMPLATE_KEYS);
  const safeValues = (0, _lodash.pick)(values, ALLOWED_TEMPLATE_KEYS);
  if (extraneousKeys.length > 0) {
    throw new Error(`Received extraneous keys from ${pendingApproval.type}.getValues. These keys are not passed to the confirmation page: ${Object.keys(extraneousKeys)}`);
  }
  return safeValues;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\confirmation\\templates\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\remove-snap-account.js", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cconfirmation%5Ctemplates%5Cremove-snap-account.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _metametrics = require("../../../../../shared/constants/metametrics");
function getValues(pendingApproval, t, actions, _history, _data, contexts) {
  const {
    origin: snapId,
    snapName
  } = pendingApproval;
  const {
    publicAddress
  } = pendingApproval.requestData;
  const {
    trackEvent
  } = contexts;
  const trackSnapAccountEvent = event => {
    trackEvent({
      event,
      category: _metametrics.MetaMetricsEventCategory.Accounts,
      properties: {
        account_type: _metametrics.MetaMetricsEventAccountType.Snap,
        snap_id: snapId,
        snap_name: snapName
      }
    });
  };
  const onCancel = () => {
    trackSnapAccountEvent(_metametrics.MetaMetricsEventName.RemoveSnapAccountCanceled);
    actions.resolvePendingApproval(pendingApproval.id, false);
  };
  return {
    content: [{
      element: 'RemoveSnapAccount',
      key: 'remove-snap-account',
      props: {
        snapId,
        snapName,
        publicAddress,
        onCancel
      }
    }],
    cancelText: t('cancel'),
    submitText: t('remove'),
    onLoad: () => trackSnapAccountEvent(_metametrics.MetaMetricsEventName.RemoveSnapAccountViewed),
    onSubmit: () => {
      trackSnapAccountEvent(_metametrics.MetaMetricsEventName.RemoveSnapAccountConfirmed);
      actions.resolvePendingApproval(pendingApproval.id, true);
    },
    onCancel
  };
}
const removeSnapAccount = {
  getValues
};
var _default = exports.default = removeSnapAccount;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\confirmation\\templates\\remove-snap-account.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\smart-transaction-status-page.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cconfirmation%5Ctemplates%5Csmart-transaction-status-page.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
// eslint-disable-next-line no-unused-vars
function getValues(pendingApproval, t, actions, _history) {
  const {
    id,
    requestState
  } = pendingApproval;
  return {
    content: [{
      element: 'SmartTransactionStatusPage',
      key: 'smart-transaction-status-page',
      props: {
        requestState,
        onCloseExtension: () => {
          actions.resolvePendingApproval(id, true);
        },
        onViewActivity: () => {
          actions.resolvePendingApproval(id, true);
        }
      }
    }],
    hideSubmitButton: true
  };
}
const smartTransactionStatusPage = {
  getValues
};
var _default = exports.default = smartTransactionStatusPage;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\confirmation\\templates\\smart-transaction-status-page.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\snap-account-redirect.js", {"../../../../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cconfirmation%5Ctemplates%5Csnap-account-redirect.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _metametrics = require("../../../../../shared/constants/metametrics");
function getValues(pendingApproval, t, actions, _history, _data, contexts) {
  const {
    origin: snapId,
    snapName
  } = pendingApproval;
  const {
    url,
    message,
    isBlockedUrl
  } = pendingApproval.requestData;
  const {
    trackEvent
  } = contexts;
  const trackSnapAccountEvent = event => {
    trackEvent({
      event,
      category: _metametrics.MetaMetricsEventCategory.Transactions,
      properties: {
        account_type: _metametrics.MetaMetricsEventAccountType.Snap,
        snap_id: snapId,
        snap_name: snapName
      }
    });
  };
  const hasValidNonBlockedUrl = () => {
    return url !== undefined && url !== null && url.length > 0 && isBlockedUrl === false;
  };

  // We can only submit if the URL is valid and non-blocked
  const onSubmit = event => {
    return hasValidNonBlockedUrl() ? {
      submitText: t('goToSite'),
      onSubmit: () => {
        trackSnapAccountEvent(event);
        actions.resolvePendingApproval(pendingApproval.id, true);
      }
    } : {};
  };
  return {
    content: [{
      element: 'SnapAccountRedirect',
      key: 'snap-account-redirect',
      props: {
        url,
        message,
        snapId,
        snapName,
        isBlockedUrl,
        ...onSubmit(_metametrics.MetaMetricsEventName.SnapAccountTransactionFinalizeRedirectSnapUrlClicked)
      }
    }],
    cancelText: t('close'),
    onLoad: () => trackSnapAccountEvent(_metametrics.MetaMetricsEventName.SnapAccountTransactionFinalizeViewed),
    onCancel: () => {
      trackSnapAccountEvent(_metametrics.MetaMetricsEventName.SnapAccountTransactionFinalizeClosed);
      actions.resolvePendingApproval(pendingApproval.id, false);
    },
    ...onSubmit(_metametrics.MetaMetricsEventName.SnapAccountTransactionFinalizeRedirectGoToSiteClicked)
  };
}
const createSnapAccount = {
  getValues
};
var _default = exports.default = createSnapAccount;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\confirmation\\templates\\snap-account-redirect.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\snaps\\snap-alert\\snap-alert.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cconfirmation%5Ctemplates%5Csnaps%5Csnap-alert%5Csnap-alert.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
function getValues(pendingApproval, t, actions) {
  const {
    requestData: {
      id
    }
  } = pendingApproval;
  return {
    submitText: t('ok').toUpperCase(),
    onSubmit: () => {
      actions.resolvePendingApproval(pendingApproval.id, null);
      actions.deleteInterface(id);
    }
  };
}
const snapAlert = {
  getValues
};
var _default = exports.default = snapAlert;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\confirmation\\templates\\snaps\\snap-alert\\snap-alert.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\snaps\\snap-confirmation\\snap-confirmation.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cconfirmation%5Ctemplates%5Csnaps%5Csnap-confirmation%5Csnap-confirmation.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
function getValues(pendingApproval, t, actions) {
  const {
    requestData: {
      id
    }
  } = pendingApproval;
  return {
    cancelText: t('reject'),
    submitText: t('approveButtonText'),
    onSubmit: () => {
      actions.resolvePendingApproval(pendingApproval.id, true);
      actions.deleteInterface(id);
    },
    onCancel: () => {
      actions.resolvePendingApproval(pendingApproval.id, false);
      actions.deleteInterface(id);
    }
  };
}
const snapConfirmation = {
  getValues
};
var _default = exports.default = snapConfirmation;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\confirmation\\templates\\snaps\\snap-confirmation\\snap-confirmation.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\snaps\\snap-default\\snap-default.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cconfirmation%5Ctemplates%5Csnaps%5Csnap-default%5Csnap-default.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
function getValues(pendingApproval, _t, actions) {
  const {
    requestData: {
      id
    }
  } = pendingApproval;
  return {
    onCancel: () => {
      actions.resolvePendingApproval(pendingApproval.id, null);
      actions.deleteInterface(id);
    }
  };
}
const snapDefault = {
  getValues
};
var _default = exports.default = snapDefault;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\confirmation\\templates\\snaps\\snap-default\\snap-default.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\snaps\\snap-prompt\\snap-prompt.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cconfirmation%5Ctemplates%5Csnaps%5Csnap-prompt%5Csnap-prompt.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
function getValues(pendingApproval, t, actions) {
  const {
    requestData: {
      id
    }
  } = pendingApproval;
  return {
    cancelText: t('cancel'),
    submitText: t('submit'),
    onSubmit: inputValue => {
      actions.resolvePendingApproval(pendingApproval.id, inputValue);
      actions.deleteInterface(id);
    },
    onCancel: () => {
      actions.resolvePendingApproval(pendingApproval.id, null);
      actions.deleteInterface(id);
    }
  };
}
const snapConfirm = {
  getValues
};
var _default = exports.default = snapConfirm;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\confirmation\\templates\\snaps\\snap-prompt\\snap-prompt.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\success.js", {"../ResultTemplate":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\ResultTemplate.ts","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cconfirmation%5Ctemplates%5Csuccess.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _controllerUtils = require("@metamask/controller-utils");
var _ResultTemplate = require("../ResultTemplate");
const template = new _ResultTemplate.ResultTemplate(_controllerUtils.ApprovalType.ResultSuccess);
const success = {
  getValues: template.getValues.bind(template)
};
var _default = exports.default = success;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\confirmation\\templates\\success.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\switch-ethereum-chain.js", {"../../../../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cconfirmation%5Ctemplates%5Cswitch-ethereum-chain.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _rpcErrors = require("@metamask/rpc-errors");
var _designSystem = require("../../../../helpers/constants/design-system");
const PENDING_TX_DROP_NOTICE = {
  id: 'PENDING_TX_DROP_NOTICE',
  severity: _designSystem.SEVERITIES.WARNING,
  content: {
    element: 'span',
    children: {
      element: 'MetaMaskTranslation',
      props: {
        translationKey: 'switchingNetworksCancelsPendingConfirmations'
      }
    }
  }
};
async function getAlerts(_pendingApproval, state) {
  const alerts = [];
  if (state.unapprovedTxsCount > 0) {
    alerts.push(PENDING_TX_DROP_NOTICE);
  }
  return alerts;
}
function getValues(pendingApproval, t, actions) {
  return {
    content: [{
      element: 'Typography',
      key: 'title',
      children: t('switchEthereumChainConfirmationTitle'),
      props: {
        variant: _designSystem.TypographyVariant.H3,
        align: 'center',
        fontWeight: 'normal',
        boxProps: {
          margin: [0, 0, 2],
          padding: [0, 4, 0, 4]
        }
      }
    }, {
      element: 'Typography',
      key: 'description',
      children: t('switchEthereumChainConfirmationDescription'),
      props: {
        variant: _designSystem.TypographyVariant.H7,
        color: _designSystem.TextColor.textAlternative,
        align: 'center',
        boxProps: {
          padding: [0, 4, 0, 4]
        }
      }
    }, {
      element: 'OriginPill',
      key: 'origin-pill',
      props: {
        origin: pendingApproval.origin,
        dataTestId: 'signature-origin-pill'
      }
    }, {
      element: 'Box',
      key: 'status-box',
      props: {
        justifyContent: _designSystem.JustifyContent.center
      },
      children: {
        element: 'ConfirmationNetworkSwitch',
        key: 'network-being-switched',
        props: {
          toNetwork: pendingApproval.requestData.toNetworkConfiguration,
          fromNetwork: pendingApproval.requestData.fromNetworkConfiguration
        }
      }
    }],
    cancelText: t('cancel'),
    submitText: t('switchNetwork'),
    onSubmit: () => actions.resolvePendingApproval(pendingApproval.id, pendingApproval.requestData.toNetworkConfiguration),
    onCancel: () => actions.rejectPendingApproval(pendingApproval.id, _rpcErrors.providerErrors.userRejectedRequest().serialize()),
    networkDisplay: true
  };
}
const switchEthereumChain = {
  getAlerts,
  getValues
};
var _default = exports.default = switchEthereumChain;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\confirmation\\templates\\switch-ethereum-chain.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\util.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cconfirmation%5Cutil.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processError = processError;
exports.processHeader = processHeader;
exports.processString = processString;
/**
 * Processes an error message or ResultComponent and returns a TemplateRendererComponent
 * or an array of strings | TemplateRendererComponents.
 *
 * @param input - The message or component to process.
 * @param fallback - The fallback message to use when the input is not valid.
 * @returns The processed error component.
 */
function processError(input, fallback) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  const currentInput = convertResultComponents(input) || fallback;
  if (typeof currentInput !== 'string') {
    return currentInput;
  }
  return {
    key: 'error',
    element: 'ActionableMessage',
    props: {
      type: 'danger',
      message: currentInput
    }
  };
}

/**
 * Processes a string or ResultComponent and returns a string or TemplateRendererComponent
 * or an array of strings | TemplateRendererComponents.
 *
 * @param input - The message or component to process.
 * @param fallback - The fallback string to use when the input is not valid.
 * @returns The processed message.
 */
function processString(input, fallback) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  const currentInput = convertResultComponents(input) || fallback;
  if (typeof currentInput !== 'string') {
    return currentInput;
  }
  return applyBold(currentInput);
}

/**
 * Processes a header configuration and returns a value compatible with the template renderer.
 *
 * @param header - The header configuration to process.
 * @returns The processed header.
 */
function processHeader(header) {
  return convertResultComponents(header);
}

/**
 * Applies bold formatting to the message.
 *
 * @param message - The input message to apply bold formatting to.
 * @returns The formatted message.
 */
function applyBold(message) {
  const boldPattern = /\*\*(.+?)\*\*/gu;
  return findMarkdown(message, boldPattern, (formattedText, index) => ({
    key: `bold-${index}`,
    element: 'b',
    children: formattedText
  }));
}

/**
 * Finds and formats markdown elements in the given text.
 *
 * @param text - The input text to search for markdown elements.
 * @param pattern - The pattern to match the markdown elements.
 * @param getElement - The callback function to create the formatted elements.
 * @returns The array of formatted elements.
 */
function findMarkdown(text, pattern, getElement) {
  let position = 0;
  let index = 0;
  const matches = Array.from(text.matchAll(pattern));
  const elements = [];
  for (const match of matches) {
    const rawText = text.substring(position, match.index);
    if (rawText.length) {
      elements.push(rawText);
    }
    const formattedText = match[1];
    const formattedElement = getElement(formattedText, index);
    elements.push(formattedElement);
    position = match.index + match[0].length;
    index += 1;
  }
  const finalRawText = text.substring(position);
  if (finalRawText.length) {
    elements.push(finalRawText);
  }
  return elements;
}
function convertResultComponents(input) {
  if (input === undefined) {
    return undefined;
  }
  if (typeof input === 'string') {
    return input;
  }
  if (Array.isArray(input)) {
    return input.map(convertResultComponents);
  }
  return {
    key: input.key,
    element: input.name,
    props: input.properties,
    children: convertResultComponents(input.children)
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\confirmation\\util.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\constants\\index.ts", {"../../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cconstants%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TypedSignSignaturePrimaryTypes = exports.TYPED_SIGNATURE_VERSIONS = exports.SPENDING_CAP_UNLIMITED_MSG = exports.IGNORE_GAS_LIMIT_CHAIN_IDS = void 0;
var _network = require("../../../../shared/constants/network");
const IGNORE_GAS_LIMIT_CHAIN_IDS = exports.IGNORE_GAS_LIMIT_CHAIN_IDS = [_network.CHAINLIST_CHAIN_IDS_MAP.MANTLE];
const TYPED_SIGNATURE_VERSIONS = exports.TYPED_SIGNATURE_VERSIONS = {
  V1: 'V1',
  V3: 'V3',
  V4: 'V4'
};
const SPENDING_CAP_UNLIMITED_MSG = exports.SPENDING_CAP_UNLIMITED_MSG = 'UNLIMITED MESSAGE';
const TypedSignSignaturePrimaryTypes = exports.TypedSignSignaturePrimaryTypes = {
  PERMIT: 'Permit',
  ORDER: 'Order'
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\constants\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\selectors\\confirm.ts", {"../../../../shared/modules/selectors/util":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\util.js","../../../selectors/approvals":"D:\\code\\v\\metamask-extension\\ui\\selectors\\approvals.ts","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cselectors%5Cconfirm.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.oldestPendingConfirmationSelector = void 0;
exports.pendingConfirmationsSelector = pendingConfirmationsSelector;
exports.pendingConfirmationsSortedSelector = pendingConfirmationsSortedSelector;
exports.selectEnableEnforcedSimulations = selectEnableEnforcedSimulations;
exports.selectEnforcedSimulationsDefaultSlippage = selectEnforcedSimulationsDefaultSlippage;
exports.selectEnforcedSimulationsSlippage = selectEnforcedSimulationsSlippage;
var _controllerUtils = require("@metamask/controller-utils");
var _reselect = require("reselect");
var _approvals = require("../../../selectors/approvals");
var _util = require("../../../../shared/modules/selectors/util");
const ConfirmationApprovalTypes = [_controllerUtils.ApprovalType.PersonalSign, _controllerUtils.ApprovalType.EthSignTypedData, _controllerUtils.ApprovalType.Transaction];
function pendingConfirmationsSelector(state) {
  return (0, _approvals.getPendingApprovals)(state).filter(({
    type
  }) => ConfirmationApprovalTypes.includes(type));
}
function pendingConfirmationsSortedSelector(state) {
  return (0, _approvals.getPendingApprovals)(state).filter(({
    type
  }) => ConfirmationApprovalTypes.includes(type)).sort((a1, a2) => a1.time - a2.time);
}
const firstPendingConfirmationSelector = (0, _reselect.createSelector)(pendingConfirmationsSortedSelector, pendingConfirmations => pendingConfirmations[0]);
const oldestPendingConfirmationSelector = exports.oldestPendingConfirmationSelector = (0, _util.createDeepEqualSelector)(firstPendingConfirmationSelector, firstPendingConfirmation => firstPendingConfirmation);
function selectEnableEnforcedSimulations(state, transactionId) {
  return state.metamask.enableEnforcedSimulationsForTransactions[transactionId] ?? state.metamask.enableEnforcedSimulations;
}
function selectEnforcedSimulationsDefaultSlippage(state) {
  return state.metamask.enforcedSimulationsSlippage;
}
function selectEnforcedSimulationsSlippage(state, transactionId) {
  return state.metamask.enforcedSimulationsSlippageForTransactions[transactionId] ?? state.metamask.enforcedSimulationsSlippage;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\selectors\\confirm.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\selectors\\preferences.ts", {"../../../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cselectors%5Cpreferences.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDismissSmartAccountSuggestionEnabled = getDismissSmartAccountSuggestionEnabled;
exports.getUseSmartAccount = getUseSmartAccount;
exports.selectConfirmationAdvancedDetailsOpen = selectConfirmationAdvancedDetailsOpen;
exports.selectUseTransactionSimulations = void 0;
var _selectors = require("../../../selectors");
const selectUseTransactionSimulations = state => state.metamask.useTransactionSimulations;
exports.selectUseTransactionSimulations = selectUseTransactionSimulations;
function selectConfirmationAdvancedDetailsOpen(state) {
  return Boolean((0, _selectors.getPreferences)(state).showConfirmationAdvancedDetails);
}
function getDismissSmartAccountSuggestionEnabled(state) {
  return Boolean((0, _selectors.getPreferences)(state).dismissSmartAccountSuggestionEnabled);
}
function getUseSmartAccount(state) {
  return Boolean((0, _selectors.getPreferences)(state).smartAccountOptIn);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\selectors\\preferences.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send-legacy\\send.constants.js", {"../../../../shared/constants/common":"D:\\code\\v\\metamask-extension\\shared\\constants\\common.ts","../../../../shared/constants/gas":"D:\\code\\v\\metamask-extension\\shared\\constants\\gas.ts","../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Csend-legacy%5Csend.constants.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOKEN_TRANSFER_FUNCTION_SIGNATURE = exports.TOKEN_APPROVAL_FUNCTION_SIGNATURE = exports.SWAPS_QUOTES_ERROR = exports.SWAPS_NO_QUOTES = exports.REQUIRED_ERROR = exports.RECIPIENT_TYPES = exports.NO_RESOLUTION_FOR_DOMAIN = exports.NFT_TRANSFER_FROM_FUNCTION_SIGNATURE = exports.NFT_SAFE_TRANSFER_FROM_FUNCTION_SIGNATURE = exports.NEGATIVE_OR_ZERO_AMOUNT_TOKENS_ERROR = exports.NEGATIVE_ETH_ERROR = exports.MIN_GAS_TOTAL = exports.MIN_GAS_PRICE_HEX = exports.MIN_GAS_PRICE_GWEI = exports.MIN_GAS_PRICE_DEC = exports.MIN_GAS_LIMIT_DEC = exports.MAX_GAS_LIMIT_DEC = exports.KNOWN_RECIPIENT_ADDRESS_WARNING = exports.INVALID_RECIPIENT_ADDRESS_ERROR = exports.INVALID_HEX_DATA_ERROR = exports.INSUFFICIENT_TOKENS_ERROR = exports.INSUFFICIENT_FUNDS_ERROR = exports.HIGH_FEE_WARNING_MULTIPLIER = exports.FLOAT_TOKENS_ERROR = exports.ENS_UNKNOWN_ERROR = exports.CONTRACT_ADDRESS_ERROR = exports.CONFUSING_ENS_ERROR = void 0;
var _gas = require("../../../../shared/constants/gas");
var _Numeric = require("../../../../shared/modules/Numeric");
var _common = require("../../../../shared/constants/common");
const MIN_GAS_PRICE_DEC = exports.MIN_GAS_PRICE_DEC = '0';
const MIN_GAS_PRICE_HEX = exports.MIN_GAS_PRICE_HEX = parseInt(MIN_GAS_PRICE_DEC, 10).toString(16);
const MIN_GAS_LIMIT_DEC = exports.MIN_GAS_LIMIT_DEC = new _Numeric.Numeric('21000', 10);
const MAX_GAS_LIMIT_DEC = exports.MAX_GAS_LIMIT_DEC = '30000000';
const HIGH_FEE_WARNING_MULTIPLIER = exports.HIGH_FEE_WARNING_MULTIPLIER = 1.5;
const MIN_GAS_PRICE_GWEI = exports.MIN_GAS_PRICE_GWEI = new _Numeric.Numeric(MIN_GAS_PRICE_HEX, 16, _common.EtherDenomination.WEI).toDenomination(_common.EtherDenomination.GWEI).round(1).toPrefixedHexString();
const MIN_GAS_TOTAL = exports.MIN_GAS_TOTAL = new _Numeric.Numeric(_gas.MIN_GAS_LIMIT_HEX, 16).times(new _Numeric.Numeric(MIN_GAS_PRICE_HEX, 16, _common.EtherDenomination.WEI)).toPrefixedHexString();
const TOKEN_TRANSFER_FUNCTION_SIGNATURE = exports.TOKEN_TRANSFER_FUNCTION_SIGNATURE = '0xa9059cbb';
const TOKEN_APPROVAL_FUNCTION_SIGNATURE = exports.TOKEN_APPROVAL_FUNCTION_SIGNATURE = '0x095ea7b3';
const NFT_TRANSFER_FROM_FUNCTION_SIGNATURE = exports.NFT_TRANSFER_FROM_FUNCTION_SIGNATURE = '0x23b872dd';
const NFT_SAFE_TRANSFER_FROM_FUNCTION_SIGNATURE = exports.NFT_SAFE_TRANSFER_FROM_FUNCTION_SIGNATURE = '0xf242432a';
const INSUFFICIENT_FUNDS_ERROR = exports.INSUFFICIENT_FUNDS_ERROR = 'insufficientFunds';
const INSUFFICIENT_TOKENS_ERROR = exports.INSUFFICIENT_TOKENS_ERROR = 'insufficientTokens';
const NEGATIVE_ETH_ERROR = exports.NEGATIVE_ETH_ERROR = 'negativeETH';
const NEGATIVE_OR_ZERO_AMOUNT_TOKENS_ERROR = exports.NEGATIVE_OR_ZERO_AMOUNT_TOKENS_ERROR = 'negativeOrZeroAmountToken';
const FLOAT_TOKENS_ERROR = exports.FLOAT_TOKENS_ERROR = 'floatAmountToken';
const INVALID_RECIPIENT_ADDRESS_ERROR = exports.INVALID_RECIPIENT_ADDRESS_ERROR = 'invalidAddressRecipient';
const REQUIRED_ERROR = exports.REQUIRED_ERROR = 'required';
const KNOWN_RECIPIENT_ADDRESS_WARNING = exports.KNOWN_RECIPIENT_ADDRESS_WARNING = 'knownAddressRecipient';
const CONTRACT_ADDRESS_ERROR = exports.CONTRACT_ADDRESS_ERROR = 'contractAddressError';
const CONFUSING_ENS_ERROR = exports.CONFUSING_ENS_ERROR = 'confusingEnsDomain';
const ENS_UNKNOWN_ERROR = exports.ENS_UNKNOWN_ERROR = 'ensUnknownError';
const NO_RESOLUTION_FOR_DOMAIN = exports.NO_RESOLUTION_FOR_DOMAIN = 'noDomainResolution';
const SWAPS_NO_QUOTES = exports.SWAPS_NO_QUOTES = 'swapQuotesNotAvailableErrorTitle';
const SWAPS_QUOTES_ERROR = exports.SWAPS_QUOTES_ERROR = 'swapFetchingQuotesErrorTitle';
const INVALID_HEX_DATA_ERROR = exports.INVALID_HEX_DATA_ERROR = 'invalidHexDataError';
const RECIPIENT_TYPES = exports.RECIPIENT_TYPES = {
  SMART_CONTRACT: 'SMART_CONTRACT',
  NON_CONTRACT: 'NON_CONTRACT'
};

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\send-legacy\\send.constants.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send-legacy\\send.utils.js", {"../../../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","./send.constants":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\send-legacy\\send.constants.js","@metamask/abi-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\abi-utils\\dist\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Csend-legacy%5Csend.utils.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addGasBuffer = addGasBuffer;
exports.ellipsify = ellipsify;
exports.generateERC1155TransferData = generateERC1155TransferData;
exports.generateERC20ApprovalData = generateERC20ApprovalData;
exports.generateERC20TransferData = generateERC20TransferData;
exports.generateERC721TransferData = generateERC721TransferData;
exports.getAssetTransferData = getAssetTransferData;
exports.isBalanceSufficient = isBalanceSufficient;
exports.isERC1155BalanceSufficient = isERC1155BalanceSufficient;
exports.isTokenBalanceSufficient = isTokenBalanceSufficient;
var _abiUtils = require("@metamask/abi-utils");
var _utils = require("@metamask/utils");
var _util = require("../../../../app/scripts/lib/util");
var _transaction = require("../../../../shared/constants/transaction");
var _Numeric = require("../../../../shared/modules/Numeric");
var _hexstringUtils = require("../../../../shared/modules/hexstring-utils");
var _send = require("./send.constants");
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

function isBalanceSufficient({
  amount = '0x0',
  balance = '0x0',
  conversionRate = 1,
  gasTotal = '0x0',
  primaryCurrency = undefined
}) {
  let totalAmount = new _Numeric.Numeric(amount, 16).add(new _Numeric.Numeric(gasTotal, 16));
  let balanceNumeric = new _Numeric.Numeric(balance, (0, _utils.isHexString)(balance) ? 16 : 10);
  if (typeof primaryCurrency !== 'undefined' && primaryCurrency !== null) {
    totalAmount = totalAmount.applyConversionRate(conversionRate);
    balanceNumeric = balanceNumeric.applyConversionRate(conversionRate);
  }
  return balanceNumeric.greaterThanOrEqualTo(totalAmount);
}
function isTokenBalanceSufficient({
  amount = '0x0',
  tokenBalance,
  decimals
}) {
  const amountNumeric = new _Numeric.Numeric(amount, 16).shiftedBy(decimals);
  const tokenBalanceNumeric = new _Numeric.Numeric(tokenBalance, 16);
  return tokenBalanceNumeric.greaterThanOrEqualTo(amountNumeric);
}
function isERC1155BalanceSufficient({
  amount = '0',
  tokenBalance
}) {
  const amountNumeric = new _Numeric.Numeric(amount, 16);
  const tokenBalanceNumeric = new _Numeric.Numeric(tokenBalance, 10);
  return tokenBalanceNumeric.greaterThanOrEqualTo(amountNumeric);
}
function addGasBuffer(initialGasLimitHex, blockGasLimitHex, bufferMultiplier = 1.5) {
  const initialGasLimit = new _Numeric.Numeric(initialGasLimitHex, 16);
  const upperGasLimit = new _Numeric.Numeric(blockGasLimitHex, 16).times(new _Numeric.Numeric(0.9, 10)).round(0);
  const bufferedGasLimit = initialGasLimit.times(new _Numeric.Numeric(bufferMultiplier, 10)).round(0);

  // if initialGasLimit is above blockGasLimit, dont modify it
  if (initialGasLimit.greaterThanOrEqualTo(upperGasLimit)) {
    return initialGasLimitHex;
  }
  // if bufferedGasLimit is below blockGasLimit, use bufferedGasLimit
  if (bufferedGasLimit.lessThan(upperGasLimit)) {
    return bufferedGasLimit.toString();
  }
  // otherwise use blockGasLimit
  return upperGasLimit.toString();
}
function generateERC20TransferData({
  toAddress = '0x0',
  amount = '0x0',
  sendToken
}) {
  if (!sendToken) {
    return undefined;
  }
  return _send.TOKEN_TRANSFER_FUNCTION_SIGNATURE + Array.prototype.map.call((0, _abiUtils.encode)(['address', 'uint256'], [(0, _util.addHexPrefix)(toAddress), (0, _util.addHexPrefix)(amount)]), x => `00${x.toString(16)}`.slice(-2)).join('');
}
function generateERC721TransferData({
  toAddress = '0x0',
  fromAddress = '0x0',
  tokenId
}) {
  if (!tokenId) {
    return undefined;
  }
  return _send.NFT_TRANSFER_FROM_FUNCTION_SIGNATURE + Array.prototype.map.call((0, _abiUtils.encode)(['address', 'address', 'uint256'], [(0, _util.addHexPrefix)(fromAddress), (0, _util.addHexPrefix)(toAddress), BigInt(tokenId)]), x => `00${x.toString(16)}`.slice(-2)).join('');
}
function generateERC1155TransferData({
  toAddress = '0x0',
  fromAddress = '0x0',
  tokenId,
  amount = '1',
  data = '0'
}) {
  if (!tokenId) {
    return undefined;
  }
  return _send.NFT_SAFE_TRANSFER_FROM_FUNCTION_SIGNATURE + Array.prototype.map.call((0, _abiUtils.encode)(['address', 'address', 'uint256', 'uint256', 'bytes'], [(0, _util.addHexPrefix)(fromAddress), (0, _util.addHexPrefix)(toAddress), BigInt(tokenId), (0, _util.addHexPrefix)(amount), (0, _util.addHexPrefix)(data)]), x => `00${x.toString(16)}`.slice(-2)).join('');
}
function generateERC20ApprovalData({
  spenderAddress = _hexstringUtils.BURN_ADDRESS,
  amount = '0x0'
}) {
  if (!spenderAddress) {
    return undefined;
  }
  return _send.TOKEN_APPROVAL_FUNCTION_SIGNATURE + Array.prototype.map.call((0, _abiUtils.encode)(['address', 'uint256'], [(0, _util.addHexPrefix)(spenderAddress), (0, _util.addHexPrefix)(amount)]), x => `00${x.toString(16)}`.slice(-2)).join('');
}
function getAssetTransferData({
  sendToken,
  fromAddress,
  toAddress,
  amount
}) {
  switch (sendToken.standard) {
    case _transaction.TokenStandard.ERC721:
      return generateERC721TransferData({
        toAddress,
        fromAddress,
        tokenId: sendToken.tokenId
      });
    case _transaction.TokenStandard.ERC1155:
      return generateERC1155TransferData({
        toAddress,
        fromAddress,
        tokenId: sendToken.tokenId
      });
    case _transaction.TokenStandard.ERC20:
    default:
      return generateERC20TransferData({
        toAddress,
        amount,
        sendToken
      });
  }
}
function ellipsify(text, first = 6, last = 4) {
  if (!text) {
    return '';
  }
  return `${text.slice(0, first)}...${text.slice(-last)}`;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\send-legacy\\send.utils.js",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\utils\\confirm.ts", {"../../../../shared/constants/signatures":"D:\\code\\v\\metamask-extension\\shared\\constants\\signatures.ts","../../../../shared/modules/transaction.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\transaction.utils.ts","../../../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../constants":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\constants\\index.ts","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cconfirmations%5Cutils%5Cconfirm.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toPunycodeURL = exports.parseSanitizeTypedDataMessage = exports.isValidASCIIURL = exports.isSignatureTransactionType = exports.isSIWESignatureRequest = exports.isPermitSignatureRequest = exports.isOrderSignatureRequest = exports.SIGNATURE_TRANSACTION_TYPES = void 0;
var _transactionController = require("@metamask/transaction-controller");
var _signatures = require("../../../../shared/constants/signatures");
var _transaction = require("../../../../shared/modules/transaction.utils");
var _util = require("../../../helpers/utils/util");
var _constants = require("../constants");
const SIGNATURE_TRANSACTION_TYPES = exports.SIGNATURE_TRANSACTION_TYPES = [_transactionController.TransactionType.personalSign, _transactionController.TransactionType.signTypedData];
const isSignatureTransactionType = request => request && SIGNATURE_TRANSACTION_TYPES.includes(request.type);
exports.isSignatureTransactionType = isSignatureTransactionType;
const parseSanitizeTypedDataMessage = dataToParse => {
  const {
    message,
    primaryType,
    types
  } = (0, _transaction.parseTypedDataMessage)(dataToParse);
  const sanitizedMessage = (0, _util.sanitizeMessage)(message, primaryType, types);
  return {
    sanitizedMessage,
    primaryType
  };
};

/**
 * Returns true if the request is a SIWE signature request
 *
 * @param request - The confirmation request to check
 */
exports.parseSanitizeTypedDataMessage = parseSanitizeTypedDataMessage;
const isSIWESignatureRequest = request => {
  var _msgParams;
  return Boolean(request === null || request === void 0 || (_msgParams = request.msgParams) === null || _msgParams === void 0 || (_msgParams = _msgParams.siwe) === null || _msgParams === void 0 ? void 0 : _msgParams.isSIWEMessage);
};
exports.isSIWESignatureRequest = isSIWESignatureRequest;
const isOrderSignatureRequest = request => {
  var _request$msgParams, _request$msgParams2;
  if (!request || !isSignatureTransactionType(request) || request.type !== 'eth_signTypedData' || ((_request$msgParams = request.msgParams) === null || _request$msgParams === void 0 || (_request$msgParams = _request$msgParams.version) === null || _request$msgParams === void 0 ? void 0 : _request$msgParams.toUpperCase()) === _constants.TYPED_SIGNATURE_VERSIONS.V1) {
    return false;
  }
  const {
    primaryType
  } = (0, _transaction.parseTypedDataMessage)((_request$msgParams2 = request.msgParams) === null || _request$msgParams2 === void 0 ? void 0 : _request$msgParams2.data);
  return _signatures.PRIMARY_TYPES_ORDER.includes(primaryType);
};

/**
 * Returns true if the request is a Permit Typed Sign signature request
 *
 * @param request - The confirmation request to check
 */
exports.isOrderSignatureRequest = isOrderSignatureRequest;
const isPermitSignatureRequest = request => {
  var _msgParams2, _msgParams3;
  if (!request || !isSignatureTransactionType(request) || request.type !== 'eth_signTypedData' || ((_msgParams2 = request.msgParams) === null || _msgParams2 === void 0 || (_msgParams2 = _msgParams2.version) === null || _msgParams2 === void 0 ? void 0 : _msgParams2.toUpperCase()) === _constants.TYPED_SIGNATURE_VERSIONS.V1) {
    return false;
  }
  const {
    primaryType
  } = (0, _transaction.parseTypedDataMessage)((_msgParams3 = request.msgParams) === null || _msgParams3 === void 0 ? void 0 : _msgParams3.data);
  return _signatures.PRIMARY_TYPES_PERMIT.includes(primaryType);
};

/**
 * @param urlString - The URL to check
 * @returns True if the URL hostname contains only ASCII characters, false otherwise. The URL is still valid if the path contains non-ASCII characters.
 */
exports.isPermitSignatureRequest = isPermitSignatureRequest;
const isValidASCIIURL = urlString => {
  try {
    if (!urlString || urlString.length === 0) {
      return false;
    }
    return urlString.includes(new URL(urlString).host);
  } catch (exp) {
    console.error(
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    `Failed to detect if URL hostname contains non-ASCII characters: ${urlString}. Error: ${exp}`);
    return false;
  }
};

/**
 * Converts the URL to Punycode
 *
 * @param urlString - The URL to convert
 * @returns The Punycode URL
 */
exports.isValidASCIIURL = isValidASCIIURL;
const toPunycodeURL = urlString => {
  try {
    const url = new URL(urlString);
    const isWithoutEndSlash = url.pathname === '/' && !urlString.endsWith('/');
    return isWithoutEndSlash ? url.href.slice(0, -1) : url.href;
  } catch (err) {
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    console.error(`Failed to convert URL to Punycode: ${err}`);
    return undefined;
  }
};
exports.toPunycodeURL = toPunycodeURL;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\confirmations\\utils\\confirm.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\swaps.util.gas.ts", {"../../store/background-connection":"D:\\code\\v\\metamask-extension\\ui\\store\\background-connection.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Cswaps.util.gas.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.estimateGasFee = estimateGasFee;
var _backgroundConnection = require("../../store/background-connection");
function estimateGasFee(request) {
  return (0, _backgroundConnection.submitRequestToBackground)('estimateGasFee', [request]);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\swaps.util.gas.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\swaps.util.ts", {"../../../shared/constants/common":"D:\\code\\v\\metamask-extension\\shared\\constants\\common.ts","../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../shared/constants/swaps":"D:\\code\\v\\metamask-extension\\shared\\constants\\swaps.ts","../../../shared/lib/fetch-with-cache":"D:\\code\\v\\metamask-extension\\shared\\lib\\fetch-with-cache.ts","../../../shared/lib/swaps-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\swaps-utils.js","../../../shared/lib/transactions-controller-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\transactions-controller-utils.js","../../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","../../../shared/modules/swaps.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\swaps.utils.js","../../helpers/utils/confirm-tx.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\confirm-tx.util.ts","./swaps.util.gas":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\swaps.util.gas.ts","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\bignumber.js\\bignumber.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cpages%5Cswaps%5Cswaps.util.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.countDecimals = exports.TOKEN_VALIDATORS = exports.StxErrorTypes = void 0;
exports.fetchAggregatorMetadata = fetchAggregatorMetadata;
exports.fetchBlockedTokens = fetchBlockedTokens;
exports.fetchSwapsFeatureFlags = fetchSwapsFeatureFlags;
exports.fetchSwapsGasPrices = fetchSwapsGasPrices;
exports.fetchToken = fetchToken;
exports.fetchTokenPrice = fetchTokenPrice;
exports.fetchTokens = fetchTokens;
exports.fetchTopAssets = fetchTopAssets;
exports.fetchTopAssetsList = fetchTopAssetsList;
exports.formatSwapsValueForDisplay = formatSwapsValueForDisplay;
exports.getNetworkNameByChainId = exports.getFeeForSmartTransaction = exports.getClassNameForCharLength = void 0;
exports.getRenderableNetworkFeesForQuote = getRenderableNetworkFeesForQuote;
exports.getSwapsLivenessForNetwork = exports.getSwap1559GasFeeEstimates = void 0;
exports.getTransaction1559GasFeeEstimates = getTransaction1559GasFeeEstimates;
exports.parseSmartTransactionsError = exports.isContractAddressValid = exports.getTranslatedStxErrorMessage = void 0;
exports.quotesToRenderableData = quotesToRenderableData;
exports.showRemainingTimeInMinAndSec = void 0;
var _bignumber = require("bignumber.js");
var _swaps = require("../../../shared/constants/swaps");
var _swaps2 = require("../../../shared/modules/swaps.utils");
var _network = require("../../../shared/constants/network");
var _confirmTx = require("../../helpers/utils/confirm-tx.util");
var _fetchWithCache = _interopRequireDefault(require("../../../shared/lib/fetch-with-cache"));
var _hexstringUtils = require("../../../shared/modules/hexstring-utils");
var _transactionsControllerUtils = require("../../../shared/lib/transactions-controller-utils");
var _swapsUtils = require("../../../shared/lib/swaps-utils");
var _conversion = require("../../../shared/modules/conversion.utils");
var _common = require("../../../shared/constants/common");
var _swapsUtil = require("./swaps.util.gas");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const CACHE_REFRESH_FIVE_MINUTES = 300000;
const USD_CURRENCY_CODE = 'usd';
const clientIdHeader = {
  'X-Client-Id': _swaps.SWAPS_CLIENT_ID
};
const TOKEN_VALIDATORS = exports.TOKEN_VALIDATORS = [{
  property: 'address',
  type: 'string',
  validator: input => (0, _hexstringUtils.isValidHexAddress)(input, {
    allowNonPrefixed: false
  })
}, {
  property: 'symbol',
  type: 'string',
  validator: string => (0, _swapsUtils.truthyString)(string) && string.length <= 12
}, {
  property: 'decimals',
  type: 'string|number',
  validator: string => Number(string) >= 0 && Number(string) <= 36
}];
const TOP_ASSET_VALIDATORS = TOKEN_VALIDATORS.slice(0, 2);
const AGGREGATOR_METADATA_VALIDATORS = [{
  property: 'color',
  type: 'string',
  validator: string => Boolean(string.match(/^#[A-Fa-f0-9]+$/u))
}, {
  property: 'title',
  type: 'string',
  validator: _swapsUtils.truthyString
}, {
  property: 'icon',
  type: 'string',
  validator: string => Boolean(string.match(/^data:image/u))
}];

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
const isValidDecimalNumber = string => !isNaN(string) && string.match(/^[.0-9]+$/u) && !isNaN(parseFloat(string));
const SWAP_GAS_PRICE_VALIDATOR = [{
  property: 'SafeGasPrice',
  type: 'string',
  validator: isValidDecimalNumber
}, {
  property: 'ProposeGasPrice',
  type: 'string',
  validator: isValidDecimalNumber
}, {
  property: 'FastGasPrice',
  type: 'string',
  validator: isValidDecimalNumber
}];
async function fetchToken(contractAddress,
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
chainId) {
  const tokenUrl = (0, _swapsUtils.getBaseApi)('token', chainId);
  return await (0, _fetchWithCache.default)({
    url: `${tokenUrl}?address=${contractAddress}`,
    fetchOptions: {
      method: 'GET',
      headers: clientIdHeader
    },
    cacheOptions: {
      cacheRefreshTime: CACHE_REFRESH_FIVE_MINUTES
    },
    functionName: 'fetchToken'
  });
}
async function fetchBlockedTokens(
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
chainId) {
  const blockedTokensUrl = (0, _swapsUtils.getBaseApi)('blockedTokens', chainId);
  return await (0, _fetchWithCache.default)({
    url: `${blockedTokensUrl}`,
    fetchOptions: {
      method: 'GET',
      headers: clientIdHeader
    },
    cacheOptions: {
      cacheRefreshTime: CACHE_REFRESH_FIVE_MINUTES
    },
    functionName: 'fetchBlockedTokens'
  });
}
async function fetchTokens(chainId) {
  const tokensUrl = (0, _swapsUtils.getBaseApi)('tokens', chainId);
  const tokens = await (0, _fetchWithCache.default)({
    url: tokensUrl,
    fetchOptions: {
      method: 'GET',
      headers: clientIdHeader
    },
    cacheOptions: {
      cacheRefreshTime: CACHE_REFRESH_FIVE_MINUTES
    },
    functionName: 'fetchTokens'
  });
  const logError = false;
  const tokenObject = _swaps.SWAPS_CHAINID_DEFAULT_TOKEN_MAP[chainId] || null;
  return [tokenObject, ...tokens.filter(token => {
    return (0, _swapsUtils.validateData)(TOKEN_VALIDATORS, token, tokensUrl, logError) && !((0, _swaps2.isSwapsDefaultTokenSymbol)(token.symbol, chainId) || (0, _swaps2.isSwapsDefaultTokenAddress)(token.address, chainId));
  })];
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
async function fetchAggregatorMetadata(chainId) {
  const aggregatorMetadataUrl = (0, _swapsUtils.getBaseApi)('aggregatorMetadata', chainId);
  const aggregators = await (0, _fetchWithCache.default)({
    url: aggregatorMetadataUrl,
    fetchOptions: {
      method: 'GET',
      headers: clientIdHeader
    },
    cacheOptions: {
      cacheRefreshTime: CACHE_REFRESH_FIVE_MINUTES
    },
    functionName: 'fetchAggregatorMetadata'
  });

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const filteredAggregators = {};
  for (const aggKey in aggregators) {
    if ((0, _swapsUtils.validateData)(AGGREGATOR_METADATA_VALIDATORS, aggregators[aggKey], aggregatorMetadataUrl)) {
      filteredAggregators[aggKey] = aggregators[aggKey];
    }
  }
  return filteredAggregators;
}
async function fetchTopAssetsList(chainId) {
  if (!Object.values(_network.CHAIN_IDS).includes(chainId)) {
    return [];
  }
  const topAssetsUrl = (0, _swapsUtils.getBaseApi)('topAssets', chainId);
  const response = (await (0, _fetchWithCache.default)({
    url: topAssetsUrl,
    functionName: 'fetchTopAssets',
    fetchOptions: {
      method: 'GET',
      headers: clientIdHeader
    },
    cacheOptions: {
      cacheRefreshTime: CACHE_REFRESH_FIVE_MINUTES
    }
  })) || [];
  const topAssetsList = response.filter(asset => (0, _swapsUtils.validateData)(TOP_ASSET_VALIDATORS, asset, topAssetsUrl));
  return topAssetsList;
}
async function fetchTopAssets(chainId) {
  const response = await fetchTopAssetsList(chainId);
  const topAssetsMap = response.reduce((_topAssetsMap, asset, index) => {
    return {
      ..._topAssetsMap,
      [asset.address]: {
        index: String(index)
      }
    };
  }, {});
  return topAssetsMap;
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
async function fetchSwapsFeatureFlags() {
  const v2ApiBaseUrl = false ? _swaps.SWAPS_DEV_API_V2_BASE_URL : _swaps.SWAPS_API_V2_BASE_URL;
  return await (0, _fetchWithCache.default)({
    url: `${v2ApiBaseUrl}/featureFlags`,
    fetchOptions: {
      method: 'GET',
      headers: clientIdHeader
    },
    cacheOptions: {
      cacheRefreshTime: 600000
    },
    functionName: 'fetchSwapsFeatureFlags'
  });
}
async function fetchTokenPrice(tokenContractAddress
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
) {
  var _prices$tokenContract;
  const query = `spot-prices?tokenAddresses=${tokenContractAddress}&vsCurrency=eth&includeMarketData=false`;
  const prices = await (0, _fetchWithCache.default)({
    url: `https://price.api.cx.metamask.io/v2/chains/1/${query}`,
    fetchOptions: {
      method: 'GET'
    },
    cacheOptions: {
      cacheRefreshTime: 60000
    },
    functionName: 'fetchTokenPrice'
  });
  return prices === null || prices === void 0 || (_prices$tokenContract = prices[tokenContractAddress]) === null || _prices$tokenContract === void 0 ? void 0 : _prices$tokenContract.eth;
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
async function fetchSwapsGasPrices(chainId) {
  const gasPricesUrl = (0, _swapsUtils.getBaseApi)('gasPrices', chainId);
  const response = await (0, _fetchWithCache.default)({
    url: gasPricesUrl,
    fetchOptions: {
      method: 'GET',
      headers: clientIdHeader
    },
    cacheOptions: {
      cacheRefreshTime: 30000
    },
    functionName: 'fetchSwapsGasPrices'
  });
  const responseIsValid = (0, _swapsUtils.validateData)(SWAP_GAS_PRICE_VALIDATOR, response, gasPricesUrl);
  if (!responseIsValid) {
    throw new Error(`${gasPricesUrl} response is invalid`);
  }
  const {
    SafeGasPrice: safeLow,
    ProposeGasPrice: average,
    FastGasPrice: fast
  } = response;
  return {
    safeLow,
    average,
    fast
  };
}
const getFeeForSmartTransaction = ({
  chainId,
  currentCurrency,
  conversionRate,
  USDConversionRate,
  nativeCurrencySymbol,
  feeInWeiDec
}) => {
  var _SWAPS_CHAINID_DEFAUL;
  const feeInWeiHex = (0, _conversion.decimalToHex)(feeInWeiDec);
  const ethFee = (0, _conversion.getValueFromWeiHex)({
    value: feeInWeiHex,
    toDenomination: _common.EtherDenomination.ETH,
    numberOfDecimals: 5
  });
  const rawNetworkFees = (0, _conversion.getValueFromWeiHex)({
    value: feeInWeiHex,
    toCurrency: currentCurrency,
    conversionRate,
    numberOfDecimals: 2
  });
  let feeInUsd;
  if (currentCurrency === USD_CURRENCY_CODE) {
    feeInUsd = rawNetworkFees;
  } else {
    feeInUsd = (0, _conversion.getValueFromWeiHex)({
      value: feeInWeiHex,
      toCurrency: USD_CURRENCY_CODE,
      conversionRate: USDConversionRate,
      numberOfDecimals: 2
    });
  }
  const formattedNetworkFee = (0, _confirmTx.formatCurrency)(rawNetworkFees, currentCurrency);
  const chainCurrencySymbolToUse = nativeCurrencySymbol || ((_SWAPS_CHAINID_DEFAUL = _swaps.SWAPS_CHAINID_DEFAULT_TOKEN_MAP[chainId]) === null || _SWAPS_CHAINID_DEFAUL === void 0 ? void 0 : _SWAPS_CHAINID_DEFAUL.symbol);
  return {
    rawNetworkFees,
    feeInUsd,
    feeInFiat: formattedNetworkFee,
    feeInEth: `${ethFee} ${chainCurrencySymbolToUse}`,
    rawEthFee: ethFee
  };
};
exports.getFeeForSmartTransaction = getFeeForSmartTransaction;
function getRenderableNetworkFeesForQuote({
  tradeGas,
  approveGas,
  gasPriceTrade,
  gasPriceApprove,
  currentCurrency,
  conversionRate,
  USDConversionRate,
  tradeValue,
  sourceSymbol,
  sourceAmount,
  chainId,
  nativeCurrencySymbol,
  multiLayerL1FeeTotal
}) {
  const tradeGasFeeTotalHex = (0, _transactionsControllerUtils.calcGasTotal)(tradeGas, gasPriceTrade);
  const approveGasFeeTotalHex = approveGas ? (0, _transactionsControllerUtils.calcGasTotal)(approveGas, gasPriceApprove) : '0x0';
  const gasTotalInWeiHex = (0, _conversion.sumHexes)(tradeGasFeeTotalHex, approveGasFeeTotalHex,
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  multiLayerL1FeeTotal || '0x0');
  const nonGasFee = new _bignumber.BigNumber(tradeValue, 16).minus((0, _swaps2.isSwapsDefaultTokenSymbol)(sourceSymbol, chainId) ? sourceAmount : 0, 10).toString(16);
  const totalWeiCost = new _bignumber.BigNumber(gasTotalInWeiHex, 16).plus(nonGasFee, 16).toString(16);
  const ethFee = (0, _conversion.getValueFromWeiHex)({
    value: totalWeiCost,
    toDenomination: _common.EtherDenomination.ETH,
    numberOfDecimals: 5
  });
  const rawNetworkFees = (0, _conversion.getValueFromWeiHex)({
    value: totalWeiCost,
    toCurrency: currentCurrency,
    conversionRate,
    numberOfDecimals: 2
  });
  const formattedNetworkFee = (0, _confirmTx.formatCurrency)(rawNetworkFees, currentCurrency);
  let feeInUsd;
  if (currentCurrency === USD_CURRENCY_CODE) {
    feeInUsd = rawNetworkFees;
  } else {
    feeInUsd = (0, _conversion.getValueFromWeiHex)({
      value: totalWeiCost,
      toCurrency: USD_CURRENCY_CODE,
      conversionRate: USDConversionRate,
      numberOfDecimals: 2
    });
  }
  const chainCurrencySymbolToUse =
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  nativeCurrencySymbol || _swaps.SWAPS_CHAINID_DEFAULT_TOKEN_MAP[chainId].symbol;
  return {
    rawNetworkFees,
    feeInUsd,
    rawEthFee: ethFee,
    feeInFiat: formattedNetworkFee,
    feeInEth: `${ethFee} ${chainCurrencySymbolToUse}`,
    nonGasFee
  };
}
function quotesToRenderableData({
  quotes,
  gasPriceTrade,
  gasPriceApprove,
  conversionRate,
  currentCurrency,
  approveGas,
  tokenConversionRates,
  chainId,
  smartTransactionEstimatedGas,
  nativeCurrencySymbol,
  multiLayerL1ApprovalFeeTotal
}) {
  return Object.values(quotes).map(quote => {
    const {
      destinationAmount = 0,
      sourceAmount = 0,
      sourceTokenInfo,
      destinationTokenInfo,
      slippage,
      aggType,
      aggregator,
      gasEstimateWithRefund,
      averageGas,
      fee,
      trade,
      multiLayerL1TradeFeeTotal
    } = quote;
    let multiLayerL1FeeTotal = null;
    if (multiLayerL1TradeFeeTotal !== null && multiLayerL1ApprovalFeeTotal !== null) {
      multiLayerL1FeeTotal = (0, _conversion.sumHexes)(multiLayerL1TradeFeeTotal || '0x0', multiLayerL1ApprovalFeeTotal || '0x0');
    } else if (multiLayerL1TradeFeeTotal !== null) {
      multiLayerL1FeeTotal = multiLayerL1TradeFeeTotal;
    }
    const sourceValue = (0, _transactionsControllerUtils.calcTokenAmount)(sourceAmount, sourceTokenInfo.decimals).toString(10);
    const destinationValue = (0, _transactionsControllerUtils.calcTokenAmount)(destinationAmount, destinationTokenInfo.decimals).toPrecision(8);
    let feeInFiat = null;
    let feeInEth = null;
    let rawNetworkFees = null;
    let rawEthFee = null;
    ({
      feeInFiat,
      feeInEth,
      rawNetworkFees,
      rawEthFee
    } = getRenderableNetworkFeesForQuote({
      tradeGas: gasEstimateWithRefund || (0, _conversion.decimalToHex)(averageGas || 800000),
      approveGas,
      gasPriceTrade,
      gasPriceApprove,
      currentCurrency,
      conversionRate,
      tradeValue: trade.value,
      sourceSymbol: sourceTokenInfo.symbol,
      sourceAmount,
      chainId,
      multiLayerL1FeeTotal
    }));
    if (smartTransactionEstimatedGas) {
      ({
        feeInFiat,
        feeInEth
      } = getFeeForSmartTransaction({
        chainId,
        currentCurrency,
        conversionRate,
        nativeCurrencySymbol,
        feeInWeiDec: smartTransactionEstimatedGas.feeEstimate
      }));
    }
    const slippageMultiplier = new _bignumber.BigNumber(100 - slippage).div(100);
    const minimumAmountReceived = new _bignumber.BigNumber(destinationValue).times(slippageMultiplier).toFixed(6);
    const tokenConversionRate = tokenConversionRates[destinationTokenInfo.address];
    const ethValueOfTrade = (0, _swaps2.isSwapsDefaultTokenSymbol)(destinationTokenInfo.symbol, chainId) ? (0, _transactionsControllerUtils.calcTokenAmount)(destinationAmount, destinationTokenInfo.decimals).minus(rawEthFee, 10) : new _bignumber.BigNumber(tokenConversionRate || 0, 10).times((0, _transactionsControllerUtils.calcTokenAmount)(destinationAmount, destinationTokenInfo.decimals), 10).minus(rawEthFee, 10);
    let liquiditySourceKey;
    let renderedSlippage = slippage;
    if (aggType === 'AGG') {
      liquiditySourceKey = 'swapAggregator';
    } else if (aggType === 'RFQ') {
      liquiditySourceKey = 'swapRequestForQuotation';
      renderedSlippage = 0;
    } else if (aggType === 'DEX') {
      liquiditySourceKey = 'swapDecentralizedExchange';
    } else if (aggType === 'CONTRACT') {
      liquiditySourceKey = 'swapDirectContract';
    } else {
      liquiditySourceKey = 'swapUnknown';
    }
    return {
      aggId: aggregator,
      amountReceiving: `${destinationValue} ${destinationTokenInfo.symbol}`,
      destinationTokenDecimals: destinationTokenInfo.decimals,
      destinationTokenSymbol: destinationTokenInfo.symbol,
      destinationTokenValue: formatSwapsValueForDisplay(destinationValue),
      destinationIconUrl: destinationTokenInfo.iconUrl,
      isBestQuote: quote.isBestQuote,
      liquiditySourceKey,
      feeInEth,
      detailedNetworkFees: `${feeInEth} (${feeInFiat})`,
      networkFees: feeInFiat,
      quoteSource: aggType,
      rawNetworkFees,
      slippage: renderedSlippage,
      sourceTokenDecimals: sourceTokenInfo.decimals,
      sourceTokenSymbol: sourceTokenInfo.symbol,
      sourceTokenValue: sourceValue,
      sourceTokenIconUrl: sourceTokenInfo.iconUrl,
      ethValueOfTrade,
      minimumAmountReceived,
      metaMaskFee: fee
    };
  });
}
function formatSwapsValueForDisplay(destinationAmount) {
  let amountToDisplay;
  if (typeof destinationAmount === 'string' && destinationAmount.includes('...')) {
    amountToDisplay = destinationAmount;
  } else {
    amountToDisplay = (0, _transactionsControllerUtils.toPrecisionWithoutTrailingZeros)(destinationAmount, 12);
  }
  if (amountToDisplay.match(/e[+-]/u)) {
    amountToDisplay = new _bignumber.BigNumber(amountToDisplay).toFixed();
  }
  return amountToDisplay;
}
const getClassNameForCharLength = (num, classNamePrefix) => {
  let modifier;
  if (!num || num.length <= 10) {
    modifier = 'lg';
  } else if (num.length > 10 && num.length <= 13) {
    modifier = 'md';
  } else {
    modifier = 'sm';
  }
  return `${classNamePrefix}--${modifier}`;
};

/**
 * Checks whether a contract address is valid before swapping tokens.
 *
 * @param contractAddress - E.g. "0x881d40237659c251811cec9c364ef91dc08d300c" for mainnet
 * @param chainId - The hex encoded chain ID to check
 * @returns Whether a contract address is valid or not
 */
exports.getClassNameForCharLength = getClassNameForCharLength;
const isContractAddressValid = (contractAddress, chainId) => {
  if (!contractAddress || !_swaps.ALLOWED_CONTRACT_ADDRESSES[chainId]) {
    return false;
  }
  return _swaps.ALLOWED_CONTRACT_ADDRESSES[chainId].some(
  // Sometimes we get a contract address with a few upper-case chars and since addresses are
  // case-insensitive, we compare lowercase versions for validity.
  allowedContractAddress => contractAddress.toLowerCase() === allowedContractAddress.toLowerCase());
};

/**
 * @param chainId
 * @returns string e.g. ethereum, bsc or polygon
 */
exports.isContractAddressValid = isContractAddressValid;
const getNetworkNameByChainId = chainId => {
  switch (chainId) {
    case _network.CHAIN_IDS.MAINNET:
      return _swaps.ETHEREUM;
    case _network.CHAIN_IDS.BSC:
      return _swaps.BSC;
    case _network.CHAIN_IDS.POLYGON:
      return _swaps.POLYGON;
    case _network.CHAIN_IDS.GOERLI:
      return _swaps.GOERLI;
    case _network.CHAIN_IDS.AVALANCHE:
      return _swaps.AVALANCHE;
    case _network.CHAIN_IDS.OPTIMISM:
      return _swaps.OPTIMISM;
    case _network.CHAIN_IDS.ARBITRUM:
      return _swaps.ARBITRUM;
    case _network.CHAIN_IDS.ZKSYNC_ERA:
      return _swaps.ZKSYNC_ERA;
    case _network.CHAIN_IDS.LINEA_MAINNET:
      return _swaps.LINEA;
    case _network.CHAIN_IDS.BASE:
      return _swaps.BASE;
    case _network.CHAIN_IDS.SEI:
      return _swaps.SEI;
    default:
      return '';
  }
};

/**
 * It returns info about if Swaps are enabled and if we should use our new APIs for it.
 *
 * @param chainId
 * @param swapsFeatureFlags
 * @returns object with 2 items: "swapsFeatureIsLive"
 */
exports.getNetworkNameByChainId = getNetworkNameByChainId;
const getSwapsLivenessForNetwork = (chainId,
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
swapsFeatureFlags = {}) => {
  const networkName = getNetworkNameByChainId(chainId);
  // Use old APIs for testnet and Goerli.
  if ([_network.CHAIN_IDS.LOCALHOST, _network.CHAIN_IDS.GOERLI].includes(chainId)) {
    return {
      swapsFeatureIsLive: true
    };
  }
  // If a network name is not found in the list of feature flags, disable Swaps.
  if (!swapsFeatureFlags[networkName]) {
    return {
      swapsFeatureIsLive: false
    };
  }
  const isNetworkEnabledForNewApi = swapsFeatureFlags[networkName].extensionActive;
  if (isNetworkEnabledForNewApi) {
    return {
      swapsFeatureIsLive: true
    };
  }
  return {
    swapsFeatureIsLive: swapsFeatureFlags[networkName].fallbackToV1
  };
};

/**
 * @param value
 * @returns number
 */

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
exports.getSwapsLivenessForNetwork = getSwapsLivenessForNetwork;
const countDecimals = value => {
  var _value$toString$split;
  if (!value || Math.floor(value) === value) {
    return 0;
  }
  return ((_value$toString$split = value.toString().split('.')[1]) === null || _value$toString$split === void 0 ? void 0 : _value$toString$split.length) || 0;
};
exports.countDecimals = countDecimals;
const showRemainingTimeInMinAndSec = remainingTimeInSec => {
  if (!Number.isInteger(remainingTimeInSec)) {
    return '0:00';
  }
  const minutes = Math.floor(remainingTimeInSec / 60);
  const seconds = remainingTimeInSec % 60;
  return `${minutes}:${seconds.toString().padStart(2, '0')}`;
};
exports.showRemainingTimeInMinAndSec = showRemainingTimeInMinAndSec;
let StxErrorTypes = exports.StxErrorTypes = /*#__PURE__*/function (StxErrorTypes) {
  StxErrorTypes["unavailable"] = "unavailable";
  StxErrorTypes["notEnoughFunds"] = "not_enough_funds";
  StxErrorTypes["regularTxPending"] = "regular_tx_pending";
  return StxErrorTypes;
}({});
const getTranslatedStxErrorMessage = (errorType, t) => {
  switch (errorType) {
    case StxErrorTypes.unavailable:
    case StxErrorTypes.regularTxPending:
      return t('smartSwapsErrorUnavailable');
    case StxErrorTypes.notEnoughFunds:
      return t('smartSwapsErrorNotEnoughFunds');
    default:
      return t('smartSwapsErrorUnavailable');
  }
};
exports.getTranslatedStxErrorMessage = getTranslatedStxErrorMessage;
const parseSmartTransactionsError = errorMessage => {
  const errorJson = errorMessage.slice(12);
  return JSON.parse(errorJson.trim());
};
exports.parseSmartTransactionsError = parseSmartTransactionsError;
const getSwap1559GasFeeEstimates = async (tradeTxParams, approveTxParams, estimatedBaseFeeGwei, chainId) => {
  const estimatedBaseFee = (0, _conversion.decGWEIToHexWEI)(estimatedBaseFeeGwei);
  const tradeGasFeeEstimates = await getTransaction1559GasFeeEstimates(tradeTxParams, estimatedBaseFee, chainId);
  const approveGasFeeEstimates = approveTxParams ? await getTransaction1559GasFeeEstimates(approveTxParams, estimatedBaseFee, chainId) : undefined;
  return {
    tradeGasFeeEstimates,
    approveGasFeeEstimates,
    estimatedBaseFee
  };
};
exports.getSwap1559GasFeeEstimates = getSwap1559GasFeeEstimates;
async function getTransaction1559GasFeeEstimates(transactionParams, estimatedBaseFee, chainId) {
  const transactionGasFeeResponse = await (0, _swapsUtil.estimateGasFee)({
    transactionParams,
    chainId
  });
  const transactionGasFeeEstimates = transactionGasFeeResponse === null || transactionGasFeeResponse === void 0 ? void 0 : transactionGasFeeResponse.estimates;
  const {
    maxFeePerGas
  } = (transactionGasFeeEstimates === null || transactionGasFeeEstimates === void 0 ? void 0 : transactionGasFeeEstimates.high) ?? {};
  const {
    maxPriorityFeePerGas
  } = (transactionGasFeeEstimates === null || transactionGasFeeEstimates === void 0 ? void 0 : transactionGasFeeEstimates.high) ?? {};
  const baseAndPriorityFeePerGas = maxPriorityFeePerGas ? (0, _conversion.addHexes)(estimatedBaseFee, maxPriorityFeePerGas) : undefined;
  return {
    baseAndPriorityFeePerGas,
    maxFeePerGas,
    maxPriorityFeePerGas
  };
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\pages\\swaps\\swaps.util.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\accounts.ts", {"../../shared/modules/selectors/util":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\util.js","../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Caccounts.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMemoizedInternalAccountByAddress = exports.getInternalAccountsObject = exports.getInternalAccountsByScope = exports.getInternalAccounts = void 0;
exports.getSelectedInternalAccount = getSelectedInternalAccount;
exports.hasCreatedSolanaAccount = hasCreatedSolanaAccount;
exports.isNonEvmAccount = isNonEvmAccount;
exports.isSelectedInternalAccountEth = isSelectedInternalAccountEth;
exports.isSelectedInternalAccountSolana = isSelectedInternalAccountSolana;
exports.isSolanaAccount = isSolanaAccount;
var _keyringApi = require("@metamask/keyring-api");
var _reselect = require("reselect");
var _utils = require("@metamask/utils");
var _util = require("../../shared/modules/selectors/util");
var _stringUtils = require("../../shared/modules/string-utils");
function isSolanaAccount(account) {
  const {
    DataAccount
  } = _keyringApi.SolAccountType;
  return Boolean(account && account.type === DataAccount);
}
function isNonEvmAccount(account) {
  const {
    DataAccount
  } = _keyringApi.SolAccountType;
  return Boolean(account && (Object.values(_keyringApi.BtcAccountType).includes(account.type) || account.type === DataAccount));
}
const getInternalAccounts = exports.getInternalAccounts = (0, _reselect.createSelector)(state => Object.values(state.metamask.internalAccounts.accounts), accounts => accounts);
const getInternalAccountsObject = exports.getInternalAccountsObject = (0, _reselect.createSelector)(state => state.metamask.internalAccounts.accounts, internalAccounts => internalAccounts);
const getMemoizedInternalAccountByAddress = exports.getMemoizedInternalAccountByAddress = (0, _util.createDeepEqualSelector)([getInternalAccounts, (_state, address) => address], (internalAccounts, address) => {
  return internalAccounts.find(account => (0, _stringUtils.isEqualCaseInsensitive)(account.address, address));
});
function getSelectedInternalAccount(state) {
  const accountId = state.metamask.internalAccounts.selectedAccount;
  return state.metamask.internalAccounts.accounts[accountId];
}
function isSelectedInternalAccountEth(state) {
  const account = getSelectedInternalAccount(state);
  const {
    Eoa,
    Erc4337
  } = _keyringApi.EthAccountType;
  return Boolean(account && (account.type === Eoa || account.type === Erc4337));
}
function isSelectedInternalAccountSolana(state) {
  return isSolanaAccount(getSelectedInternalAccount(state));
}
function hasCreatedSolanaAccount(state) {
  const accounts = getInternalAccounts(state);
  return accounts.some(account => isSolanaAccount(account));
}

/**
 * Returns all internal accounts that declare support for the provided CAIP scope.
 * The scope should be a CAIP-2 scope string (e.g., 'eip155:0', 'bip122:...').
 *
 * @param _state - Redux state (unused; required for selector signature)
 * @param scope - The CAIP scope string to filter accounts by
 */
const getInternalAccountsByScope = exports.getInternalAccountsByScope = (0, _util.createDeepEqualSelector)([getInternalAccounts, (_state, scope) => scope], (accounts, scope) => {
  if (!Array.isArray(accounts) || accounts.length === 0) {
    return [];
  }
  let namespace;
  let reference;
  try {
    const parsed = (0, _utils.parseCaipChainId)(scope);
    namespace = parsed.namespace;
    reference = parsed.reference;
  } catch {
    return [];
  }
  if (namespace === _utils.KnownCaipNamespace.Eip155) {
    // If requesting eip155:0 (wildcard), include any account that has any EVM scope
    if (reference === '0') {
      return accounts.filter(account => Array.isArray(account.scopes) && account.scopes.some(s => s.startsWith(`${_utils.KnownCaipNamespace.Eip155}:`)));
    }

    // For a specific EVM chain, include accounts that either have the exact scope or the wildcard
    return accounts.filter(account => Array.isArray(account.scopes) && (account.scopes.includes(scope) || account.scopes.includes(_keyringApi.EthScope.Eoa)));
  }

  // Non-EVM: exact scope match only
  return accounts.filter(account => Array.isArray(account.scopes) && account.scopes.includes(scope));
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\accounts.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\approvals.ts", {"../../shared/modules/selectors/util":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\util.js","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Capprovals.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApprovalFlows = getApprovalFlows;
exports.getApprovalsByOrigin = exports.getApprovalRequestsByType = void 0;
exports.getPendingApprovals = getPendingApprovals;
exports.hasPendingApprovals = hasPendingApprovals;
exports.pendingApprovalsSortedSelector = pendingApprovalsSortedSelector;
exports.selectPendingApprovalsForNavigation = exports.selectPendingApproval = void 0;
var _controllerUtils = require("@metamask/controller-utils");
var _reselect = require("reselect");
var _util = require("../../shared/modules/selectors/util");
function hasPendingApprovals(state, approvalTypes, predicate) {
  const pendingApprovalRequests = Object.values(state.metamask.pendingApprovals).filter(({
    type
  }) => approvalTypes.includes(type));
  if (predicate) {
    return pendingApprovalRequests.some(predicate);
  }
  return pendingApprovalRequests.length > 0;
}
const getApprovalRequestsByType = (state, approvalType, predicate) => {
  const pendingApprovalRequests = Object.values(state.metamask.pendingApprovals).filter(({
    type
  }) => type === approvalType);
  if (predicate) {
    return pendingApprovalRequests.filter(predicate);
  }
  return pendingApprovalRequests;
};
exports.getApprovalRequestsByType = getApprovalRequestsByType;
function getApprovalFlows(state) {
  return state.metamask.approvalFlows;
}
function getPendingApprovals(state) {
  return Object.values(state.metamask.pendingApprovals ?? {});
}
function pendingApprovalsSortedSelector(state) {
  return getPendingApprovals(state).sort((a1, a2) => a1.time - a2.time);
}

/**
 * Returns pending approvals sorted by time for use in confirmation navigation.
 * Excludes duplicate watch asset approvals as they are combined into a single confirmation.
 */
const selectPendingApprovalsForNavigation = exports.selectPendingApprovalsForNavigation = (0, _util.createDeepEqualSelector)(pendingApprovalsSortedSelector, sortedPendingApprovals => sortedPendingApprovals.filter((approval, index) => {
  if (isWatchNftApproval(approval) && sortedPendingApprovals.findIndex(isWatchNftApproval) !== index) {
    return false;
  }
  if (isWatchTokenApproval(approval) && sortedPendingApprovals.findIndex(isWatchTokenApproval) !== index) {
    return false;
  }
  return true;
}));
const internalSelectPendingApproval = (0, _reselect.createSelector)(getPendingApprovals, (_state, id) => id, (approvals, id) => approvals.find(({
  id: approvalId
}) => approvalId === id));
const selectPendingApproval = exports.selectPendingApproval = (0, _util.createDeepEqualSelector)(internalSelectPendingApproval, approval => approval);
const getApprovalsByOrigin = (state, origin) => {
  const pendingApprovals = getPendingApprovals(state);
  return pendingApprovals === null || pendingApprovals === void 0 ? void 0 : pendingApprovals.filter(confirmation => confirmation.origin === origin);
};
exports.getApprovalsByOrigin = getApprovalsByOrigin;
function isWatchTokenApproval(approval) {
  var _approval$requestData;
  const tokenId = (_approval$requestData = approval.requestData) === null || _approval$requestData === void 0 || (_approval$requestData = _approval$requestData.asset) === null || _approval$requestData === void 0 ? void 0 : _approval$requestData.tokenId;
  return approval.type === _controllerUtils.ApprovalType.WatchAsset && !tokenId;
}
function isWatchNftApproval(approval) {
  var _approval$requestData2;
  const tokenId = (_approval$requestData2 = approval.requestData) === null || _approval$requestData2 === void 0 || (_approval$requestData2 = _approval$requestData2.asset) === null || _approval$requestData2 === void 0 ? void 0 : _approval$requestData2.tokenId;
  return approval.type === _controllerUtils.ApprovalType.WatchAsset && Boolean(tokenId);
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\approvals.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\confirm-transaction.js", {"../../shared/constants/gas":"D:\\code\\v\\metamask-extension\\shared\\constants\\gas.ts","../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../shared/modules/gas.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\gas.utils.js","../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../helpers/utils/confirm-tx.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\confirm-tx.util.ts","../helpers/utils/tx-helper":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\tx-helper.ts","./custom-gas":"D:\\code\\v\\metamask-extension\\ui\\selectors\\custom-gas.js","./selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","./transactions":"D:\\code\\v\\metamask-extension\\ui\\selectors\\transactions.js","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cconfirm-transaction.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.currentCurrencySelector = exports.conversionRateSelector = void 0;
exports.selectIsMaxValueEnabled = selectIsMaxValueEnabled;
exports.selectMaxValueModeForTransaction = selectMaxValueModeForTransaction;
exports.selectTransactionAvailableBalance = selectTransactionAvailableBalance;
exports.selectTransactionFeeById = selectTransactionFeeById;
exports.use4ByteResolutionSelector = exports.unconfirmedTransactionsListSelector = exports.unconfirmedTransactionsHashSelector = exports.unconfirmedMessagesHashSelector = exports.txDataSelector = exports.transactionFeeSelector = exports.tokenAddressSelector = void 0;
var _reselect = require("reselect");
var _transactionController = require("@metamask/transaction-controller");
var _txHelper = _interopRequireDefault(require("../helpers/utils/tx-helper"));
var _confirmTx = require("../helpers/utils/confirm-tx.util");
var _metamask = require("../ducks/metamask/metamask");
var _gas = require("../../shared/constants/gas");
var _gas2 = require("../../shared/modules/gas.utils");
var _conversion = require("../../shared/modules/conversion.utils");
var _networks = require("../../shared/modules/selectors/networks");
var _customGas = require("./custom-gas");
var _selectors = require("./selectors");
var _transactions = require("./transactions");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const unapprovedTxsSelector = state => (0, _transactions.getUnapprovedTransactions)(state);
const unconfirmedTransactionsListSelector = exports.unconfirmedTransactionsListSelector = (0, _reselect.createSelector)(unapprovedTxsSelector, _transactions.unapprovedPersonalMsgsSelector, _transactions.unapprovedDecryptMsgsSelector, _transactions.unapprovedEncryptionPublicKeyMsgsSelector, _transactions.unapprovedTypedMessagesSelector, (unapprovedTxs = {}, unapprovedPersonalMsgs = {}, unapprovedDecryptMsgs = {}, unapprovedEncryptionPublicKeyMsgs = {}, unapprovedTypedMessages = {}) => (0, _txHelper.default)(unapprovedTxs, unapprovedPersonalMsgs, unapprovedDecryptMsgs, unapprovedEncryptionPublicKeyMsgs, unapprovedTypedMessages) || []);
const unconfirmedTransactionsHashSelector = exports.unconfirmedTransactionsHashSelector = (0, _reselect.createSelector)(unapprovedTxsSelector, _transactions.unapprovedPersonalMsgsSelector, _transactions.unapprovedDecryptMsgsSelector, _transactions.unapprovedEncryptionPublicKeyMsgsSelector, _transactions.unapprovedTypedMessagesSelector, (unapprovedTxs = {}, unapprovedPersonalMsgs = {}, unapprovedDecryptMsgs = {}, unapprovedEncryptionPublicKeyMsgs = {}, unapprovedTypedMessages = {}) => ({
  ...unapprovedTxs,
  ...unapprovedPersonalMsgs,
  ...unapprovedDecryptMsgs,
  ...unapprovedEncryptionPublicKeyMsgs,
  ...unapprovedTypedMessages
}));
const unconfirmedMessagesHashSelector = exports.unconfirmedMessagesHashSelector = (0, _reselect.createSelector)(_transactions.unapprovedPersonalMsgsSelector, _transactions.unapprovedDecryptMsgsSelector, _transactions.unapprovedEncryptionPublicKeyMsgsSelector, _transactions.unapprovedTypedMessagesSelector, (unapprovedPersonalMsgs = {}, unapprovedDecryptMsgs = {}, unapprovedEncryptionPublicKeyMsgs = {}, unapprovedTypedMessages = {}) => {
  return {
    ...unapprovedPersonalMsgs,
    ...unapprovedDecryptMsgs,
    ...unapprovedEncryptionPublicKeyMsgs,
    ...unapprovedTypedMessages
  };
});
const use4ByteResolutionSelector = state => state.metamask.use4ByteResolution;
exports.use4ByteResolutionSelector = use4ByteResolutionSelector;
const currentCurrencySelector = state => state.metamask.currentCurrency;
exports.currentCurrencySelector = currentCurrencySelector;
const conversionRateSelector = state => {
  var _state$metamask$curre;
  return (_state$metamask$curre = state.metamask.currencyRates[(0, _networks.getProviderConfig)(state).ticker]) === null || _state$metamask$curre === void 0 ? void 0 : _state$metamask$curre.conversionRate;
};
exports.conversionRateSelector = conversionRateSelector;
const txDataSelector = state => state.confirmTransaction.txData;
exports.txDataSelector = txDataSelector;
const txParamsSelector = (0, _reselect.createSelector)(txDataSelector, txData => txData && txData.txParams || {});
const tokenAddressSelector = exports.tokenAddressSelector = (0, _reselect.createSelector)(txParamsSelector, txParams => txParams && txParams.to);
const transactionFeeSelector = function (state, txData) {
  var _txData$txParams, _txData$txParams8, _txData$txParams9, _txData$txParams0;
  const currentCurrency = currentCurrencySelector(state);
  const conversionRate = conversionRateSelector(state);
  const nativeCurrency = (0, _metamask.getNativeCurrency)(state);
  const gasFeeEstimates = (0, _metamask.getGasFeeEstimates)(state) || {};
  const gasEstimateType = (0, _metamask.getGasEstimateType)(state);
  const networkAndAccountSupportsEIP1559 = (0, _selectors.checkNetworkAndAccountSupports1559)(state);
  const gasEstimationObject = {
    gasLimit: ((_txData$txParams = txData.txParams) === null || _txData$txParams === void 0 ? void 0 : _txData$txParams.gas) ?? '0x0',
    gasLimitNoBuffer: txData.gasLimitNoBuffer
  };
  if (networkAndAccountSupportsEIP1559) {
    var _txData$txParams2;
    const {
      gasPrice = '0'
    } = gasFeeEstimates;
    const selectedGasEstimates = gasFeeEstimates[txData.userFeeLevel] || {};
    if (((_txData$txParams2 = txData.txParams) === null || _txData$txParams2 === void 0 ? void 0 : _txData$txParams2.type) === _transactionController.TransactionEnvelopeType.legacy) {
      var _txData$txParams3;
      gasEstimationObject.gasPrice = ((_txData$txParams3 = txData.txParams) === null || _txData$txParams3 === void 0 ? void 0 : _txData$txParams3.gasPrice) ?? (0, _conversion.decGWEIToHexWEI)(gasPrice);
    } else {
      var _txData$txParams4, _txData$txParams5, _txData$txParams6, _txData$txParams7;
      const {
        suggestedMaxPriorityFeePerGas,
        suggestedMaxFeePerGas
      } = selectedGasEstimates;
      gasEstimationObject.maxFeePerGas = (_txData$txParams4 = txData.txParams) !== null && _txData$txParams4 !== void 0 && _txData$txParams4.maxFeePerGas && (txData.userFeeLevel === _gas.CUSTOM_GAS_ESTIMATE || !suggestedMaxFeePerGas) ? (_txData$txParams5 = txData.txParams) === null || _txData$txParams5 === void 0 ? void 0 : _txData$txParams5.maxFeePerGas : (0, _conversion.decGWEIToHexWEI)(suggestedMaxFeePerGas || gasPrice);
      gasEstimationObject.maxPriorityFeePerGas = (_txData$txParams6 = txData.txParams) !== null && _txData$txParams6 !== void 0 && _txData$txParams6.maxPriorityFeePerGas && (txData.userFeeLevel === _gas.CUSTOM_GAS_ESTIMATE || !suggestedMaxPriorityFeePerGas) ? (_txData$txParams7 = txData.txParams) === null || _txData$txParams7 === void 0 ? void 0 : _txData$txParams7.maxPriorityFeePerGas : suggestedMaxPriorityFeePerGas && (0, _conversion.decGWEIToHexWEI)(suggestedMaxPriorityFeePerGas) || gasEstimationObject.maxFeePerGas;
      gasEstimationObject.baseFeePerGas = (0, _conversion.decGWEIToHexWEI)(gasFeeEstimates.estimatedBaseFee);
    }
  } else {
    switch (gasEstimateType) {
      case _gas.GasEstimateTypes.feeMarket:
      case _gas.GasEstimateTypes.none:
        gasEstimationObject.gasPrice = ((_txData$txParams8 = txData.txParams) === null || _txData$txParams8 === void 0 ? void 0 : _txData$txParams8.gasPrice) ?? '0x0';
        break;
      case _gas.GasEstimateTypes.ethGasPrice:
        gasEstimationObject.gasPrice = ((_txData$txParams9 = txData.txParams) === null || _txData$txParams9 === void 0 ? void 0 : _txData$txParams9.gasPrice) ?? (0, _conversion.decGWEIToHexWEI)(gasFeeEstimates.gasPrice);
        break;
      case _gas.GasEstimateTypes.legacy:
        gasEstimationObject.gasPrice = ((_txData$txParams0 = txData.txParams) === null || _txData$txParams0 === void 0 ? void 0 : _txData$txParams0.gasPrice) ?? (0, _customGas.getAveragePriceEstimateInHexWEI)(state);
        break;
      default:
        break;
    }
  }
  const {
    txParams: {
      value = '0x0'
    } = {}
  } = txData;
  const fiatTransactionAmount = (0, _conversion.getValueFromWeiHex)({
    value,
    fromCurrency: nativeCurrency,
    toCurrency: currentCurrency,
    conversionRate,
    numberOfDecimals: 2
  });
  const ethTransactionAmount = (0, _conversion.getValueFromWeiHex)({
    value,
    fromCurrency: nativeCurrency,
    toCurrency: nativeCurrency,
    conversionRate,
    numberOfDecimals: 6
  });
  const hexMinimumTransactionFee = (0, _gas2.getMinimumGasTotalInHexWei)(gasEstimationObject);
  const hexMaximumTransactionFee = (0, _gas2.getMaximumGasTotalInHexWei)(gasEstimationObject);
  const fiatMinimumTransactionFee = (0, _confirmTx.getTransactionFee)({
    value: hexMinimumTransactionFee,
    fromCurrency: nativeCurrency,
    toCurrency: currentCurrency,
    numberOfDecimals: 2,
    conversionRate
  });
  const fiatMaximumTransactionFee = (0, _confirmTx.getTransactionFee)({
    value: hexMaximumTransactionFee,
    fromCurrency: nativeCurrency,
    toCurrency: currentCurrency,
    numberOfDecimals: 2,
    conversionRate
  });
  const ethTransactionFee = (0, _confirmTx.getTransactionFee)({
    value: hexMinimumTransactionFee,
    fromCurrency: nativeCurrency,
    toCurrency: nativeCurrency,
    numberOfDecimals: 6,
    conversionRate
  });
  const fiatTransactionTotal = (0, _confirmTx.addFiat)(fiatMinimumTransactionFee, fiatTransactionAmount);
  const ethTransactionTotal = (0, _confirmTx.addEth)(ethTransactionFee, ethTransactionAmount);
  const hexTransactionTotal = (0, _conversion.sumHexes)(value, hexMinimumTransactionFee);
  return {
    hexTransactionAmount: value,
    fiatTransactionAmount,
    ethTransactionAmount,
    hexMinimumTransactionFee,
    fiatMinimumTransactionFee,
    hexMaximumTransactionFee,
    fiatMaximumTransactionFee,
    ethTransactionFee,
    fiatTransactionTotal,
    ethTransactionTotal,
    hexTransactionTotal,
    gasEstimationObject
  };
};
exports.transactionFeeSelector = transactionFeeSelector;
function selectTransactionFeeById(state, transactionId) {
  const transactionMetadata = (0, _transactions.selectTransactionMetadata)(state, transactionId);
  return transactionFeeSelector(state, transactionMetadata ?? {});
}

// Cannot use createSelector due to circular dependency caused by getMetaMaskAccounts.
// chainId is optional parameter here
function selectTransactionAvailableBalance(state, transactionId, chainId) {
  var _accounts$sender;
  const accounts = (0, _selectors.getMetaMaskAccounts)(state, chainId);
  const sender = (0, _transactions.selectTransactionSender)(state, transactionId);
  return (_accounts$sender = accounts[sender]) === null || _accounts$sender === void 0 ? void 0 : _accounts$sender.balance;
}
function selectIsMaxValueEnabled(state, transactionId) {
  var _state$confirmTransac;
  return ((_state$confirmTransac = state.confirmTransaction.maxValueMode) === null || _state$confirmTransac === void 0 ? void 0 : _state$confirmTransac[transactionId]) ?? false;
}
const maxValueModeSelector = state => state.confirmTransaction.maxValueMode;
function selectMaxValueModeForTransaction(state, transactionId) {
  const maxValueModes = maxValueModeSelector(state);
  return maxValueModes[transactionId];
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\confirm-transaction.js",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\custom-gas.js", {"../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../shared/constants/common":"D:\\code\\v\\metamask-extension\\shared\\constants\\common.ts","../../shared/constants/gas":"D:\\code\\v\\metamask-extension\\shared\\constants\\gas.ts","../../shared/lib/transactions-controller-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\transactions-controller-utils.js","../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../ducks/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\index.js","../helpers/utils/confirm-tx.util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\confirm-tx.util.ts","../helpers/utils/formatters":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\formatters.js","./selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Ccustom-gas.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.basicPriceEstimateToETHTotal = basicPriceEstimateToETHTotal;
exports.getAverageEstimate = getAverageEstimate;
exports.getAveragePriceEstimateInHexWEI = getAveragePriceEstimateInHexWEI;
exports.getBasicGasEstimateLoadingStatus = getBasicGasEstimateLoadingStatus;
exports.getCustomGasLimit = getCustomGasLimit;
exports.getCustomGasPrice = getCustomGasPrice;
exports.getDefaultActiveButtonIndex = getDefaultActiveButtonIndex;
exports.getFastPriceEstimate = getFastPriceEstimate;
exports.getFastPriceEstimateInHexWEI = getFastPriceEstimateInHexWEI;
exports.getGasPriceInHexWei = getGasPriceInHexWei;
exports.getIsCustomNetworkGasPriceFetched = getIsCustomNetworkGasPriceFetched;
exports.getIsGasEstimatesFetched = getIsGasEstimatesFetched;
exports.getNoGasPriceFetched = getNoGasPriceFetched;
exports.getRenderableConvertedCurrencyFee = getRenderableConvertedCurrencyFee;
exports.getRenderableEthFee = getRenderableEthFee;
exports.getSafeLowEstimate = getSafeLowEstimate;
exports.isCustomPriceExcessive = isCustomPriceExcessive;
exports.isCustomPriceSafe = isCustomPriceSafe;
exports.isCustomPriceSafeForCustomNetwork = isCustomPriceSafeForCustomNetwork;
exports.priceEstimateToWei = priceEstimateToWei;
var _util = require("../../app/scripts/lib/util");
var _conversion = require("../../shared/modules/conversion.utils");
var _confirmTx = require("../helpers/utils/confirm-tx.util");
var _formatters = require("../helpers/utils/formatters");
var _send = require("../ducks/send");
var _gas = require("../../shared/constants/gas");
var _metamask = require("../ducks/metamask/metamask");
var _transactionsControllerUtils = require("../../shared/lib/transactions-controller-utils");
var _Numeric = require("../../shared/modules/Numeric");
var _common = require("../../shared/constants/common");
var _selectors = require("./selectors");
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

function getCustomGasLimit(state) {
  return state.gas.customData.limit;
}
function getCustomGasPrice(state) {
  return state.gas.customData.price;
}
function getBasicGasEstimateLoadingStatus(state) {
  return getIsGasEstimatesFetched(state) === false;
}
function getAveragePriceEstimateInHexWEI(state) {
  const averagePriceEstimate = getAverageEstimate(state);
  return getGasPriceInHexWei(averagePriceEstimate);
}
function getFastPriceEstimateInHexWEI(state) {
  const fastPriceEstimate = getFastPriceEstimate(state);
  return getGasPriceInHexWei(fastPriceEstimate || '0x0');
}
function getDefaultActiveButtonIndex(gasButtonInfo, customGasPriceInHex, gasPrice) {
  return gasButtonInfo.map(({
    priceInHexWei
  }) => priceInHexWei).lastIndexOf((0, _util.addHexPrefix)(customGasPriceInHex || gasPrice));
}
function getSafeLowEstimate(state) {
  const gasFeeEstimates = (0, _metamask.getGasFeeEstimates)(state);
  const gasEstimateType = (0, _metamask.getGasEstimateType)(state);
  return gasEstimateType === _gas.GasEstimateTypes.legacy ? gasFeeEstimates === null || gasFeeEstimates === void 0 ? void 0 : gasFeeEstimates.low : null;
}
function getAverageEstimate(state) {
  const gasFeeEstimates = (0, _metamask.getGasFeeEstimates)(state);
  const gasEstimateType = (0, _metamask.getGasEstimateType)(state);
  return gasEstimateType === _gas.GasEstimateTypes.legacy ? gasFeeEstimates === null || gasFeeEstimates === void 0 ? void 0 : gasFeeEstimates.medium : null;
}
function getFastPriceEstimate(state) {
  const gasFeeEstimates = (0, _metamask.getGasFeeEstimates)(state);
  const gasEstimateType = (0, _metamask.getGasEstimateType)(state);
  return gasEstimateType === _gas.GasEstimateTypes.legacy ? gasFeeEstimates === null || gasFeeEstimates === void 0 ? void 0 : gasFeeEstimates.high : null;
}
function isCustomPriceSafe(state) {
  const safeLow = getSafeLowEstimate(state);
  const customGasPrice = getCustomGasPrice(state);
  if (!customGasPrice) {
    return true;
  }
  if (!safeLow) {
    return false;
  }
  const customPriceSafe = new _Numeric.Numeric(customGasPrice, 16, _common.EtherDenomination.WEI).toDenomination(_common.EtherDenomination.GWEI).greaterThan(safeLow, 10);
  return customPriceSafe;
}
function isCustomPriceSafeForCustomNetwork(state) {
  const estimatedPrice = getAverageEstimate(state);
  const customGasPrice = getCustomGasPrice(state);
  if (!customGasPrice) {
    return true;
  }
  if (!estimatedPrice) {
    return false;
  }
  const customPriceSafe = new _Numeric.Numeric(customGasPrice, 16, _common.EtherDenomination.WEI).toDenomination(_common.EtherDenomination.GWEI).greaterThan(estimatedPrice, 10);
  return customPriceSafe;
}
function isCustomPriceExcessive(state, checkSend = false) {
  const customPrice = checkSend ? (0, _send.getGasPrice)(state) : getCustomGasPrice(state);
  const fastPrice = getFastPriceEstimate(state);
  if (!customPrice || !fastPrice) {
    return false;
  }

  // Custom gas should be considered excessive when it is 1.5 times greater than the fastest estimate.
  const customPriceExcessive = new _Numeric.Numeric(customPrice, 16, _common.EtherDenomination.WEI).toDenomination(_common.EtherDenomination.GWEI).greaterThan(Math.floor(fastPrice * 1.5), 10);
  return customPriceExcessive;
}
function basicPriceEstimateToETHTotal(estimate, gasLimit, numberOfDecimals = 9) {
  return new _Numeric.Numeric((0, _transactionsControllerUtils.calcGasTotal)(gasLimit, estimate), 16, _common.EtherDenomination.GWEI).round(numberOfDecimals).toBase(10).toString();
}
function getRenderableEthFee(estimate, gasLimit, numberOfDecimals = 9, nativeCurrency = 'ETH') {
  const value = new _Numeric.Numeric(estimate, 10).toBase(16).toString();
  const fee = basicPriceEstimateToETHTotal(value, gasLimit, numberOfDecimals);
  return (0, _formatters.formatETHFee)(fee, nativeCurrency);
}
function getRenderableConvertedCurrencyFee(estimate, gasLimit, convertedCurrency, conversionRate) {
  const value = new _Numeric.Numeric(estimate, 10).toBase(16).toString();
  const fee = basicPriceEstimateToETHTotal(value, gasLimit);
  const feeInCurrency = (0, _conversion.decEthToConvertedCurrency)(fee, convertedCurrency, conversionRate);
  return (0, _confirmTx.formatCurrency)(feeInCurrency, convertedCurrency);
}
function priceEstimateToWei(priceEstimate) {
  return new _Numeric.Numeric(priceEstimate, 16, _common.EtherDenomination.GWEI).toDenomination(_common.EtherDenomination.WEI).round(9).toString();
}
function getGasPriceInHexWei(price) {
  const value = new _Numeric.Numeric(price, 10).toBase(16).toString();
  return (0, _util.addHexPrefix)(priceEstimateToWei(value));
}
function getIsCustomNetworkGasPriceFetched(state) {
  const gasEstimateType = (0, _metamask.getGasEstimateType)(state);
  return gasEstimateType === _gas.GasEstimateTypes.ethGasPrice && !(0, _selectors.getIsMainnet)(state);
}
function getNoGasPriceFetched(state) {
  const gasEstimateType = (0, _metamask.getGasEstimateType)(state);
  return gasEstimateType === _gas.GasEstimateTypes.none;
}
function getIsGasEstimatesFetched(state) {
  const gasEstimateType = (0, _metamask.getGasEstimateType)(state);
  if ((0, _metamask.isEIP1559Network)(state)) {
    return false;
  }
  return gasEstimateType !== _gas.GasEstimateTypes.none;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\custom-gas.js",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\first-time-flow.js", {"../../shared/constants/onboarding":"D:\\code\\v\\metamask-extension\\shared\\constants\\onboarding.ts","../../shared/modules/environment":"D:\\code\\v\\metamask-extension\\shared\\modules\\environment.ts","../helpers/constants/routes":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\routes.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cfirst-time-flow.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFirstTimeFlowType = void 0;
exports.getFirstTimeFlowTypeRouteAfterMetaMetricsOptIn = getFirstTimeFlowTypeRouteAfterMetaMetricsOptIn;
exports.getFirstTimeFlowTypeRouteAfterUnlock = getFirstTimeFlowTypeRouteAfterUnlock;
exports.getOnboardingInitiator = exports.getIsSocialLoginFlow = void 0;
var _onboarding = require("../../shared/constants/onboarding");
var _environment = require("../../shared/modules/environment");
var _routes = require("../helpers/constants/routes");
/**
 * Returns true if the user is on a social login flow
 *
 * @param {object} state - MetaMask state tree
 * @returns {boolean} True if the user is on a social login flow
 */
const getIsSocialLoginFlow = state => {
  if (!(0, _environment.getIsSeedlessOnboardingFeatureEnabled)()) {
    return false;
  }
  const {
    firstTimeFlowType
  } = state.metamask;
  return firstTimeFlowType === _onboarding.FirstTimeFlowType.socialCreate || firstTimeFlowType === _onboarding.FirstTimeFlowType.socialImport;
};

/**
 * When the user unlocks the wallet but onboarding has not fully completed we
 * must direct the user to the appropriate step in the onboarding process.
 *
 * @param {object} state - MetaMask state tree
 * @returns {string} Route to redirect the user to
 */
exports.getIsSocialLoginFlow = getIsSocialLoginFlow;
function getFirstTimeFlowTypeRouteAfterUnlock(state) {
  const {
    firstTimeFlowType
  } = state.metamask;
  if (firstTimeFlowType === _onboarding.FirstTimeFlowType.create) {
    return _routes.ONBOARDING_CREATE_PASSWORD_ROUTE;
  } else if (firstTimeFlowType === _onboarding.FirstTimeFlowType.import) {
    return _routes.ONBOARDING_IMPORT_WITH_SRP_ROUTE;
  } else if (firstTimeFlowType === _onboarding.FirstTimeFlowType.restore) {
    return _routes.ONBOARDING_METAMETRICS;
  } else if (firstTimeFlowType === _onboarding.FirstTimeFlowType.socialCreate) {
    return _routes.ONBOARDING_DOWNLOAD_APP_ROUTE;
  }
  return _routes.DEFAULT_ROUTE;
}

/**
 * The onboarding flow first asks the user what process they wish to use to
 * initialize their wallet (either create, import, or restore). After that it
 * asks the user to opt into MetaMetrics. This function returns the route the
 * user should be directed to after they opt in or out of MetaMetrics. Note
 * that this differs from getFirstTimeFlowTypeRouteAfterUnlock only for the
 * restore option because the restore option is atypical from the other two
 * options and removes an entire screen from the onboarding flow.
 *
 * @param {object} state - MetaMask state tree
 * @returns {string} Route to redirect the user to
 */
function getFirstTimeFlowTypeRouteAfterMetaMetricsOptIn(state) {
  const {
    firstTimeFlowType
  } = state.metamask;
  if (firstTimeFlowType === _onboarding.FirstTimeFlowType.create) {
    return _routes.ONBOARDING_COMPLETION_ROUTE;
  } else if (firstTimeFlowType === _onboarding.FirstTimeFlowType.import) {
    return _routes.ONBOARDING_COMPLETION_ROUTE;
  } else if (firstTimeFlowType === _onboarding.FirstTimeFlowType.restore) {
    return _routes.ONBOARDING_REVIEW_SRP_ROUTE;
  } else if (firstTimeFlowType === _onboarding.FirstTimeFlowType.socialCreate) {
    return _routes.ONBOARDING_COMPLETION_ROUTE;
  } else if (firstTimeFlowType === _onboarding.FirstTimeFlowType.socialImport) {
    return _routes.ONBOARDING_DOWNLOAD_APP_ROUTE;
  }
  return _routes.DEFAULT_ROUTE;
}
const getFirstTimeFlowType = state => {
  return state.metamask.firstTimeFlowType;
};
exports.getFirstTimeFlowType = getFirstTimeFlowType;
const getOnboardingInitiator = state => {
  const {
    onboardingTabs
  } = state.metamask;
  if (!onboardingTabs || Object.keys(onboardingTabs).length !== 1) {
    return null;
  }
  const location = Object.keys(onboardingTabs)[0];
  const tabId = onboardingTabs[location];
  return {
    location,
    tabId
  };
};
exports.getOnboardingInitiator = getOnboardingInitiator;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\first-time-flow.js",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js", {"../pages/confirmations/selectors/confirm":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\selectors\\confirm.ts","./accounts":"D:\\code\\v\\metamask-extension\\ui\\selectors\\accounts.ts","./approvals":"D:\\code\\v\\metamask-extension\\ui\\selectors\\approvals.ts","./confirm-transaction":"D:\\code\\v\\metamask-extension\\ui\\selectors\\confirm-transaction.js","./custom-gas":"D:\\code\\v\\metamask-extension\\ui\\selectors\\custom-gas.js","./first-time-flow":"D:\\code\\v\\metamask-extension\\ui\\selectors\\first-time-flow.js","./metametrics":"D:\\code\\v\\metamask-extension\\ui\\selectors\\metametrics.js","./multichain-accounts":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\index.ts","./multichain/networks":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain\\networks.ts","./origin-throttling":"D:\\code\\v\\metamask-extension\\ui\\selectors\\origin-throttling.ts","./remote-feature-flags":"D:\\code\\v\\metamask-extension\\ui\\selectors\\remote-feature-flags.ts","./seedless-onboarding":"D:\\code\\v\\metamask-extension\\ui\\selectors\\seedless-onboarding\\index.ts","./selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","./transactions":"D:\\code\\v\\metamask-extension\\ui\\selectors\\transactions.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _confirm = require("../pages/confirmations/selectors/confirm");
Object.keys(_confirm).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _confirm[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _confirm[key];
    }
  });
});
var _confirmTransaction = require("./confirm-transaction");
Object.keys(_confirmTransaction).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _confirmTransaction[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _confirmTransaction[key];
    }
  });
});
var _customGas = require("./custom-gas");
Object.keys(_customGas).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _customGas[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _customGas[key];
    }
  });
});
var _firstTimeFlow = require("./first-time-flow");
Object.keys(_firstTimeFlow).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _firstTimeFlow[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _firstTimeFlow[key];
    }
  });
});
var _metametrics = require("./metametrics");
Object.keys(_metametrics).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _metametrics[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _metametrics[key];
    }
  });
});
var _selectors = require("./selectors");
Object.keys(_selectors).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _selectors[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _selectors[key];
    }
  });
});
var _transactions = require("./transactions");
Object.keys(_transactions).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _transactions[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _transactions[key];
    }
  });
});
var _approvals = require("./approvals");
Object.keys(_approvals).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _approvals[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _approvals[key];
    }
  });
});
var _accounts = require("./accounts");
Object.keys(_accounts).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _accounts[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _accounts[key];
    }
  });
});
var _remoteFeatureFlags = require("./remote-feature-flags");
Object.keys(_remoteFeatureFlags).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _remoteFeatureFlags[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _remoteFeatureFlags[key];
    }
  });
});
var _originThrottling = require("./origin-throttling");
Object.keys(_originThrottling).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _originThrottling[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _originThrottling[key];
    }
  });
});
var _networks = require("./multichain/networks");
Object.keys(_networks).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _networks[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _networks[key];
    }
  });
});
var _multichainAccounts = require("./multichain-accounts");
Object.keys(_multichainAccounts).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _multichainAccounts[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _multichainAccounts[key];
    }
  });
});
var _seedlessOnboarding = require("./seedless-onboarding");
Object.keys(_seedlessOnboarding).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _seedlessOnboarding[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _seedlessOnboarding[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\index.js",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\metametrics.js", {"reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cmetametrics.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectMatchingFragment = exports.selectFragments = exports.selectFragmentBySuccessEvent = exports.selectFragmentById = exports.getParticipateInMetaMetrics = exports.getLatestMetricsEventTimestamp = exports.getIsParticipateInMetaMetricsSet = exports.getDataCollectionForMarketing = void 0;
var _reselect = require("reselect");
const selectFragments = state => state.metamask.fragments;

// return true if user has set their marketing consent preference or if they are a social login user
exports.selectFragments = selectFragments;
const getDataCollectionForMarketing = state => state.metamask.dataCollectionForMarketing;

// return true if user has set their participation preference in MetaMetrics or if they are a social login user
exports.getDataCollectionForMarketing = getDataCollectionForMarketing;
const getParticipateInMetaMetrics = state => Boolean(state.metamask.participateInMetaMetrics);

// return true if user has set their participation preference in MetaMetrics or if they are a social login user
exports.getParticipateInMetaMetrics = getParticipateInMetaMetrics;
const getIsParticipateInMetaMetricsSet = state => state.metamask.participateInMetaMetrics !== null;
exports.getIsParticipateInMetaMetricsSet = getIsParticipateInMetaMetricsSet;
const getLatestMetricsEventTimestamp = state => state.metamask.latestNonAnonymousEventTimestamp;
exports.getLatestMetricsEventTimestamp = getLatestMetricsEventTimestamp;
const selectFragmentBySuccessEvent = exports.selectFragmentBySuccessEvent = (0, _reselect.createSelector)(selectFragments, (_, fragmentOptions) => fragmentOptions, (fragments, fragmentOptions) => {
  if (fragmentOptions.persist) {
    return Object.values(fragments).find(fragment => fragment.successEvent === fragmentOptions.successEvent);
  }
  return undefined;
});
const selectFragmentById = exports.selectFragmentById = (0, _reselect.createSelector)(selectFragments, (_, fragmentId) => fragmentId, (fragments, fragmentId) => {
  // A valid existing fragment must exist in state.
  // If these conditions are not meant we will create a new fragment.
  if (fragmentId && fragments !== null && fragments !== void 0 && fragments[fragmentId]) {
    return fragments[fragmentId];
  }
  return undefined;
});
const selectMatchingFragment = exports.selectMatchingFragment = (0, _reselect.createSelector)((state, params) => selectFragmentBySuccessEvent(state, params.fragmentOptions), (state, params) => selectFragmentById(state, params.existingId), (matchedBySuccessEvent, matchedById) => matchedById ?? matchedBySuccessEvent);

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\metametrics.js",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\feature-flags.ts", {"../../../shared/lib/multichain-accounts/remote-feature-flag":"D:\\code\\v\\metamask-extension\\shared\\lib\\multichain-accounts\\remote-feature-flag.ts","../remote-feature-flags":"D:\\code\\v\\metamask-extension\\ui\\selectors\\remote-feature-flags.ts","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cmultichain-accounts%5Cfeature-flags.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMultichainAccountsRemoteFeatureFlags = exports.getIsMultichainAccountsState2Enabled = exports.getIsMultichainAccountsState1Enabled = exports.STATE_2_FLAG = exports.STATE_1_FLAG = void 0;
var _superstruct = require("@metamask/superstruct");
var _remoteFeatureFlags = require("../remote-feature-flags");
var _remoteFeatureFlag = require("../../../shared/lib/multichain-accounts/remote-feature-flag");
const STATE_1_FLAG = exports.STATE_1_FLAG = 'enableMultichainAccounts';
const STATE_2_FLAG = exports.STATE_2_FLAG = 'enableMultichainAccountsState2';

/**
 * Feature flag structure for multichain accounts features
 */
const MultichainAccountsFeatureFlag = (0, _superstruct.object)({
  enabled: (0, _superstruct.boolean)(),
  featureVersion: (0, _superstruct.nullable)((0, _superstruct.string)()),
  minimumVersion: (0, _superstruct.nullable)((0, _superstruct.string)())
});

/**
 * Feature flag type for multichain accounts features
 */

/**
 * Selector to get the multichain accounts remote feature flags.
 *
 * @param state - The MetaMask state object
 * @param flagName - The name of the remote flag to use
 * @returns MultichainAccountsFeatureFlag - The feature flags for multichain accounts.
 */
const getMultichainAccountsRemoteFeatureFlags = (state, flagName) => {
  try {
    const multichainAccountsFeatureFlags = (0, _remoteFeatureFlags.getRemoteFeatureFlags)(state)[flagName];
    (0, _superstruct.assert)(multichainAccountsFeatureFlags, MultichainAccountsFeatureFlag);
    return multichainAccountsFeatureFlags;
  } catch (error) {
    return undefined;
  }
};

/**
 * Selector to check if the multichain accounts feature is enabled for state 1.
 *
 * @param state - The MetaMask state object
 * @returns boolean - True if the feature is enabled for state 1, false otherwise.
 */
exports.getMultichainAccountsRemoteFeatureFlags = getMultichainAccountsRemoteFeatureFlags;
const getIsMultichainAccountsState1Enabled = state => {
  const remoteFlagState1 = getMultichainAccountsRemoteFeatureFlags(state, STATE_1_FLAG);
  const remoteFlagState2 = getMultichainAccountsRemoteFeatureFlags(state, STATE_2_FLAG);
  return (0, _remoteFeatureFlag.isMultichainAccountsFeatureEnabled)(remoteFlagState1, _remoteFeatureFlag.FEATURE_VERSION_1) || (0, _remoteFeatureFlag.isMultichainAccountsFeatureEnabled)(remoteFlagState2, _remoteFeatureFlag.FEATURE_VERSION_2);
};

/**
 * Selector to check if the multichain accounts feature is enabled for state 2.
 *
 * @param state - The MetaMask state object
 * @returns boolean - True if the feature is enabled for state 2, false otherwise.
 */
exports.getIsMultichainAccountsState1Enabled = getIsMultichainAccountsState1Enabled;
const getIsMultichainAccountsState2Enabled = state => {
  const remoteFlag = getMultichainAccountsRemoteFeatureFlags(state, STATE_2_FLAG);
  return (0, _remoteFeatureFlag.isMultichainAccountsFeatureEnabled)(remoteFlag, _remoteFeatureFlag.FEATURE_VERSION_2);
};
exports.getIsMultichainAccountsState2Enabled = getIsMultichainAccountsState2Enabled;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\multichain-accounts\\feature-flags.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\index.ts", {"./feature-flags":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain-accounts\\feature-flags.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cmultichain-accounts%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _featureFlags = require("./feature-flags");
Object.keys(_featureFlags).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _featureFlags[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _featureFlags[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\multichain-accounts\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts", {"../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../shared/constants/multichain/assets":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\assets.ts","../../shared/constants/multichain/networks":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\networks.ts","../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../shared/modules/Numeric":"D:\\code\\v\\metamask-extension\\shared\\modules\\Numeric.ts","../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../shared/modules/selectors/util":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\util.js","../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","./accounts":"D:\\code\\v\\metamask-extension\\ui\\selectors\\accounts.ts","./multichain/networks":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain\\networks.ts","./selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cmultichain.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultichainNetworkPropType = exports.InternalAccountPropType = void 0;
exports.getImageForChainId = getImageForChainId;
exports.getLastSelectedNonEvmAccount = getLastSelectedNonEvmAccount;
exports.getLastSelectedSolanaAccount = getLastSelectedSolanaAccount;
exports.getMemoizedMultichainNetworkConfigurationsByChainId = void 0;
exports.getMultichainBalances = getMultichainBalances;
exports.getMultichainCoinRates = void 0;
exports.getMultichainConversionRate = getMultichainConversionRate;
exports.getMultichainCurrencyImage = getMultichainCurrencyImage;
exports.getMultichainCurrentChainId = getMultichainCurrentChainId;
exports.getMultichainCurrentCurrency = getMultichainCurrentCurrency;
exports.getMultichainCurrentNetwork = getMultichainCurrentNetwork;
exports.getMultichainDefaultToken = getMultichainDefaultToken;
exports.getMultichainIsBitcoin = getMultichainIsBitcoin;
exports.getMultichainIsEvm = getMultichainIsEvm;
exports.getMultichainIsMainnet = getMultichainIsMainnet;
exports.getMultichainIsSolana = getMultichainIsSolana;
exports.getMultichainIsTestnet = getMultichainIsTestnet;
exports.getMultichainNativeCurrency = getMultichainNativeCurrency;
exports.getMultichainNativeCurrencyImage = getMultichainNativeCurrencyImage;
exports.getMultichainNetwork = getMultichainNetwork;
exports.getMultichainNetworkConfigurationsByChainId = void 0;
exports.getMultichainNetworkProviders = getMultichainNetworkProviders;
exports.getMultichainProviderConfig = getMultichainProviderConfig;
exports.getMultichainSelectedAccountCachedBalance = getMultichainSelectedAccountCachedBalance;
exports.getMultichainSelectedAccountCachedBalanceIsZero = void 0;
exports.getMultichainShouldShowFiat = getMultichainShouldShowFiat;
exports.getMultichainTransactions = getMultichainTransactions;
exports.getSelectedAccountMultichainTransactions = getSelectedAccountMultichainTransactions;
exports.isChainIdMainnet = isChainIdMainnet;
exports.makeGetMultichainShouldShowFiatByChainId = void 0;
var _keyringApi = require("@metamask/keyring-api");
var _keyringUtils = require("@metamask/keyring-utils");
var _networkController = require("@metamask/network-controller");
var _utils = require("@metamask/utils");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reselect = require("reselect");
var _networks = require("../../shared/constants/multichain/networks");
var _Numeric = require("../../shared/modules/Numeric");
var _metamask = require("../ducks/metamask/metamask");
var _assets = require("../../shared/constants/multichain/assets");
var _network = require("../../shared/constants/network");
var _networks2 = require("../../shared/modules/selectors/networks");
var _util = require("../../app/scripts/lib/util");
var _util2 = require("../../shared/modules/selectors/util");
var _accounts = require("./accounts");
var _selectors = require("./selectors");
var _networks3 = require("./multichain/networks");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

// eslint-disable-next-line import/no-restricted-paths

// TODO: Remove after updating to @metamask/network-controller 20.0.0

const MultichainNetworkPropType = exports.MultichainNetworkPropType = _propTypes.default.shape({
  nickname: _propTypes.default.string.isRequired,
  isEvmNetwork: _propTypes.default.bool.isRequired,
  chainId: _propTypes.default.string,
  network: _propTypes.default.oneOfType([_propTypes.default.shape({
    rpcUrl: _propTypes.default.string,
    type: _propTypes.default.string.isRequired,
    chainId: _propTypes.default.string.isRequired,
    ticker: _propTypes.default.string.isRequired,
    rpcPrefs: _propTypes.default.shape({
      blockExplorerUrl: _propTypes.default.string,
      imageUrl: _propTypes.default.string
    }),
    nickname: _propTypes.default.string,
    id: _propTypes.default.string
  }), _propTypes.default.shape({
    chainId: _propTypes.default.string.isRequired,
    ticker: _propTypes.default.string.isRequired,
    rpcPrefs: _propTypes.default.shape({
      blockExplorerUrl: _propTypes.default.string,
      imageUrl: _propTypes.default.string
    })
  })]).isRequired
});
const InternalAccountPropType = exports.InternalAccountPropType = _propTypes.default.shape({
  id: _propTypes.default.string.isRequired,
  address: _propTypes.default.string.isRequired,
  metadata: _propTypes.default.shape({
    name: _propTypes.default.string.isRequired,
    snap: _propTypes.default.shape({
      id: _propTypes.default.string.isRequired,
      name: _propTypes.default.string,
      enabled: _propTypes.default.bool
    }),
    keyring: _propTypes.default.shape({
      type: _propTypes.default.string.isRequired
    }).isRequired
  }).isRequired,
  type: _propTypes.default.string.isRequired
});
function getMultichainNetworkProviders(_state) {
  // TODO: need state from the ChainController?
  return Object.values(_networks.MULTICHAIN_PROVIDER_CONFIGS);
}
function getMultichainNetwork(state, account) {
  var _nonEvmNetwork;
  const isEvm = getMultichainIsEvm(state, account);
  if (isEvm) {
    var _networkConfiguration;
    // EVM networks
    const evmChainId = (0, _networks2.getCurrentChainId)(state);

    // TODO: Update to use network configurations when @metamask/network-controller is updated to 20.0.0
    // ProviderConfig will be deprecated to use NetworkConfigurations
    // When a user updates a network name its only updated in the NetworkConfigurations.
    const evmNetwork = (0, _networks2.getProviderConfig)(state);
    const evmChainIdKey = evmChainId;
    evmNetwork.rpcPrefs = {
      ...evmNetwork.rpcPrefs,
      imageUrl: _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[evmChainIdKey]
    };
    const networkConfigurations = (0, _networks2.getNetworkConfigurationsByChainId)(state);
    return {
      nickname: ((_networkConfiguration = networkConfigurations[evmChainId]) === null || _networkConfiguration === void 0 ? void 0 : _networkConfiguration.name) ?? evmNetwork.rpcUrl,
      isEvmNetwork: true,
      // We assume the chain ID is `string` or `number`, so we convert it to a
      // `Number` to be compliant with EIP155 CAIP chain ID
      chainId: `${_utils.KnownCaipNamespace.Eip155}:${Number(evmChainId)}`,
      network: evmNetwork
    };
  }

  // Non-EVM networks:
  // (Hardcoded for testing)
  // HACK: For now, we rely on the account type being "sort-of" CAIP compliant, so use
  // this as a CAIP-2 namespace and apply our filter with it
  // For non-EVM, we know we have a selected account, since the logic `isEvm` is based
  // on having a non-EVM account being selected!
  const selectedAccount = account ?? (0, _accounts.getSelectedInternalAccount)(state);
  const nonEvmNetworks = getMultichainNetworkProviders(state);
  const selectedChainId = state.metamask.selectedMultichainNetworkChainId;
  let nonEvmNetwork;

  // First try to find network by selectedChainId
  if (selectedChainId) {
    nonEvmNetwork = nonEvmNetworks.find(provider => provider.chainId === selectedChainId);
  }

  // If no network found by selectedChainId, we try to find by scopes
  if (!nonEvmNetwork && selectedAccount.scopes.length > 0) {
    // If we have a selectedChainId but didn't find a match, we try to find a network
    // that matches both the selectedChainId and is in the scopes
    if (selectedChainId) {
      nonEvmNetwork = nonEvmNetworks.find(provider => provider.chainId === selectedChainId && (0, _keyringUtils.isScopeEqualToAny)(provider.chainId, selectedAccount.scopes));
    }
  }

  // If still no network found, we try to find a network that is address compatible
  if (!nonEvmNetwork) {
    nonEvmNetwork = nonEvmNetworks.find(provider => {
      return selectedAccount.scopes.includes(provider.chainId);
    });
  }
  if (!nonEvmNetwork) {
    throw new Error('Could not find non-EVM provider for the current configuration. This should never happen.');
  }
  return {
    // TODO: Adapt this for other non-EVM networks
    nickname: nonEvmNetwork.nickname,
    isEvmNetwork: false,
    chainId: (_nonEvmNetwork = nonEvmNetwork) === null || _nonEvmNetwork === void 0 ? void 0 : _nonEvmNetwork.chainId,
    network: nonEvmNetwork
  };
}

// FIXME: All the following might have side-effect, like if the current account is a bitcoin one and that
// a popup (for ethereum related stuffs) is being shown (and uses this function), then the native
// currency will be BTC..

function getMultichainIsEvm(state, account) {
  const isOnboarded = (0, _metamask.getCompletedOnboarding)(state);
  // Selected account is not available during onboarding (this is used in
  // the AppHeader)
  const selectedAccount = account ?? (0, _selectors.getMaybeSelectedInternalAccount)(state);

  // There are no selected account during onboarding. we default to the original EVM behavior.
  return !isOnboarded || !selectedAccount || (0, _keyringApi.isEvmAccountType)(selectedAccount.type);
}
function getMultichainIsBitcoin(state, account) {
  const isEvm = getMultichainIsEvm(state, account);
  const {
    symbol
  } = getMultichainDefaultToken(state, account);
  return !isEvm && symbol === 'BTC';
}
function getMultichainIsSolana(state, account) {
  const isEvm = getMultichainIsEvm(state, account);
  const {
    symbol
  } = getMultichainDefaultToken(state, account);
  return !isEvm && symbol === 'SOL';
}

/**
 * Retrieves the provider configuration for a multichain network.
 *
 * This function extracts the `network` field from the result of `getMultichainNetwork(state)`,
 * which is expected to be a `MultichainProviderConfig` object. The naming might suggest that
 * it returns a network, but it actually returns a provider configuration specific to a multichain setup.
 *
 * @param state - The redux state.
 * @param account - The multichain account.
 * @returns The current multichain provider configuration.
 */
function getMultichainProviderConfig(state, account) {
  return getMultichainNetwork(state, account).network;
}
function getMultichainCurrentNetwork(state, account) {
  return getMultichainProviderConfig(state, account);
}
function getMultichainNativeCurrency(state, account) {
  return getMultichainIsEvm(state, account) ? (0, _metamask.getNativeCurrency)(state) : getMultichainProviderConfig(state, account).ticker;
}
function getMultichainCurrentCurrency(state) {
  return (0, _metamask.getCurrentCurrency)(state);
}
function getMultichainCurrencyImage(state, account) {
  var _provider$rpcPrefs;
  if (getMultichainIsEvm(state, account)) {
    return (0, _selectors.getNativeCurrencyImage)(state);
  }
  const provider = getMultichainProviderConfig(state, account);
  return (_provider$rpcPrefs = provider.rpcPrefs) === null || _provider$rpcPrefs === void 0 ? void 0 : _provider$rpcPrefs.imageUrl;
}
function getMultichainNativeCurrencyImage(state, account) {
  return getMultichainCurrencyImage(state, account);
}
const makeGetMultichainShouldShowFiatByChainId = chainId => (state, account) => getMultichainShouldShowFiat(state, account, chainId);
exports.makeGetMultichainShouldShowFiatByChainId = makeGetMultichainShouldShowFiatByChainId;
function getMultichainShouldShowFiat(state, account, chainId) {
  const selectedAccount = account ?? (0, _accounts.getSelectedInternalAccount)(state);
  const isTestnet = getMultichainIsTestnet(state, selectedAccount);
  const isMainnet = !isTestnet;
  const useCurrencyRateCheck = (0, _selectors.getUseCurrencyRateCheck)(state);
  return getMultichainIsEvm(state, selectedAccount) ? (0, _selectors.getShouldShowFiat)(state, chainId) : useCurrencyRateCheck && isMainnet || useCurrencyRateCheck && isTestnet && (0, _selectors.getShowFiatInTestnets)(state);
}
function getMultichainDefaultToken(state, account) {
  var _getProviderConfig;
  const symbol = getMultichainIsEvm(state, account) ?
  // We fallback to 'ETH' to keep original behavior of `getSwapsDefaultToken`
  ((_getProviderConfig = (0, _networks2.getProviderConfig)(state)) === null || _getProviderConfig === void 0 ? void 0 : _getProviderConfig.ticker) ?? 'ETH' : getMultichainProviderConfig(state, account).ticker;
  return {
    symbol
  };
}
function getMultichainCurrentChainId(state) {
  const {
    chainId
  } = getMultichainProviderConfig(state);
  return chainId;
}
function isChainIdMainnet(chainId) {
  return chainId === _network.CHAIN_IDS.MAINNET;
}
function getMultichainIsMainnet(state, account) {
  const selectedAccount = account ?? (0, _accounts.getSelectedInternalAccount)(state);
  const providerConfig = getMultichainProviderConfig(state, selectedAccount);
  if (getMultichainIsEvm(state, account)) {
    return (0, _selectors.getIsMainnet)(state);
  }
  const mainnet = _networks.MULTICHAIN_ACCOUNT_TYPE_TO_MAINNET[selectedAccount.type];
  if (!mainnet) {
    return false;
  }

  // If it's Bitcoin case, check if it's a testnet address
  if ((0, _keyringUtils.isBtcTestnetAddress)(selectedAccount.address)) {
    return false;
  }
  return providerConfig.chainId === mainnet;
}
function getMultichainIsTestnet(state, account) {
  // NOTE: Since there are 2 different implementations for `IsTestnet` and `IsMainnet` we follow
  // the same pattern here too!
  const selectedAccount = account ?? (0, _accounts.getSelectedInternalAccount)(state);
  const providerConfig = getMultichainProviderConfig(state, selectedAccount);
  if (getMultichainIsEvm(state, account)) {
    // FIXME: There are multiple ways of checking for an EVM test network, but
    // current implementation differ between each other. So we do not use
    // `getIsTestnet` here and uses the actual `TEST_NETWORK_IDS` which seems
    // more up-to-date
    return _network.TEST_NETWORK_IDS.includes(providerConfig.chainId);
  }

  // For Bitcoin case, check address format as well
  if ((0, _keyringUtils.isBtcTestnetAddress)(selectedAccount.address)) {
    return true;
  }

  // TODO: For now we only check for bitcoin and Solana, but we will need to
  // update this for other non-EVM networks later!
  return [_networks.MultichainNetworks.BITCOIN_TESTNET, _networks.MultichainNetworks.BITCOIN_SIGNET, _networks.MultichainNetworks.SOLANA_DEVNET, _networks.MultichainNetworks.SOLANA_TESTNET].includes(providerConfig.chainId);
}
function getMultichainBalances(state) {
  return state.metamask.balances;
}
function getMultichainTransactions(state) {
  return state.metamask.nonEvmTransactions;
}
function getSelectedAccountMultichainTransactions(state) {
  const selectedAccount = (0, _accounts.getSelectedInternalAccount)(state);
  if ((0, _keyringApi.isEvmAccountType)(selectedAccount.type)) {
    return undefined;
  }
  const transactions = state.metamask.nonEvmTransactions[selectedAccount.id];

  // We need to get the provider config for the selected account to get the correct chainId
  const providerConfig = getMultichainProviderConfig(state, selectedAccount);
  const currentChainId = providerConfig.chainId;
  if ((0, _utils.isCaipChainId)(currentChainId)) {
    return transactions === null || transactions === void 0 ? void 0 : transactions[currentChainId];
  }
  return undefined;
}
const getMultichainCoinRates = state => {
  return state.metamask.rates;
};
exports.getMultichainCoinRates = getMultichainCoinRates;
function getNonEvmCachedBalance(state, account) {
  var _MULTICHAIN_NETWORK_T;
  const balances = getMultichainBalances(state);
  const selectedAccount = account ?? (0, _accounts.getSelectedInternalAccount)(state);
  const selectedNetworkConfig = (0, _networks3.getSelectedMultichainNetworkConfiguration)(state);

  // Prefer the fully resolved selected network configuration, but fall back to the
  // selected multichain chain ID (works even if feature flags filter out config)
  const chainId = (selectedNetworkConfig === null || selectedNetworkConfig === void 0 ? void 0 : selectedNetworkConfig.chainId) ?? state.metamask.selectedMultichainNetworkChainId;

  // We assume that there's at least one asset type in and that is the native
  // token for that network.
  const asset = (_MULTICHAIN_NETWORK_T = _assets.MULTICHAIN_NETWORK_TO_ASSET_TYPES[chainId]) === null || _MULTICHAIN_NETWORK_T === void 0 ? void 0 : _MULTICHAIN_NETWORK_T[0];
  if (!asset) {
    console.warn('Could not find asset type for chainId:', chainId);
  }
  const balancesForAccount = balances === null || balances === void 0 ? void 0 : balances[selectedAccount.id];
  if (!balancesForAccount) {
    console.warn('Could not find balances for account:', selectedAccount);
  }
  const balanceOfAsset = balancesForAccount === null || balancesForAccount === void 0 ? void 0 : balancesForAccount[asset];
  if (!balanceOfAsset) {
    console.warn('Could not find balance for asset:', asset);
  }
  return (balanceOfAsset === null || balanceOfAsset === void 0 ? void 0 : balanceOfAsset.amount) ?? 0;
}
function getImageForChainId(chainId) {
  return {
    ..._network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP,
    ..._networks.MULTICHAIN_TOKEN_IMAGE_MAP
  }[chainId];
}

// This selector is not compatible with `useMultichainSelector` since it uses the selected
// account implicitly!
function getMultichainSelectedAccountCachedBalance(state) {
  return getMultichainIsEvm(state) ? (0, _selectors.getSelectedAccountCachedBalance)(state) : getNonEvmCachedBalance(state);
}
const getMultichainSelectedAccountCachedBalanceIsZero = exports.getMultichainSelectedAccountCachedBalanceIsZero = (0, _reselect.createSelector)([getMultichainIsEvm, getMultichainSelectedAccountCachedBalance], (isEvm, balance) => {
  const base = isEvm ? 16 : 10;
  const numericBalance = new _Numeric.Numeric(balance, base);
  return numericBalance.isZero();
});
function getMultichainConversionRate(state, account) {
  var _getConversionRatesFo;
  const {
    conversionRates
  } = state.metamask;
  const {
    chainId
  } = getMultichainNetwork(state, account);
  const conversionRate = (_getConversionRatesFo = (0, _util.getConversionRatesForNativeAsset)({
    conversionRates,
    chainId
  })) === null || _getConversionRatesFo === void 0 ? void 0 : _getConversionRatesFo.rate;
  return getMultichainIsEvm(state, account) ? (0, _metamask.getConversionRate)(state) : conversionRate;
}

// TODO get this from the multichain network controller
const getMultichainNetworkConfigurationsByChainId = state => {
  return {
    ...(0, _networks2.getNetworkConfigurationsByChainId)(state),
    [_networks.MultichainNetworks.SOLANA]: {
      ..._networks.MULTICHAIN_PROVIDER_CONFIGS[_networks.MultichainNetworks.SOLANA],
      blockExplorerUrls: [],
      name: _networks.MULTICHAIN_PROVIDER_CONFIGS[_networks.MultichainNetworks.SOLANA].nickname ?? '',
      nativeCurrency: 'sol',
      rpcEndpoints: [{
        url: '',
        type: _networkController.RpcEndpointType.Custom,
        networkClientId: ''
      }],
      defaultRpcEndpointIndex: 0,
      chainId: _networks.MultichainNetworks.SOLANA
    },
    [_networks.MultichainNetworks.BITCOIN]: {
      ..._networks.MULTICHAIN_PROVIDER_CONFIGS[_networks.MultichainNetworks.BITCOIN],
      blockExplorerUrls: [],
      name: _networks.MULTICHAIN_PROVIDER_CONFIGS[_networks.MultichainNetworks.BITCOIN].nickname ?? '',
      nativeCurrency: 'BTC',
      rpcEndpoints: [{
        url: '',
        type: _networkController.RpcEndpointType.Custom,
        networkClientId: ''
      }],
      defaultRpcEndpointIndex: 0,
      chainId: _networks.MultichainNetworks.BITCOIN
    },
    [_networks.MultichainNetworks.BITCOIN_TESTNET]: {
      ..._networks.MULTICHAIN_PROVIDER_CONFIGS[_networks.MultichainNetworks.BITCOIN_TESTNET],
      blockExplorerUrls: [],
      name: _networks.MULTICHAIN_PROVIDER_CONFIGS[_networks.MultichainNetworks.BITCOIN_TESTNET].nickname ?? '',
      nativeCurrency: 'tBTC',
      rpcEndpoints: [{
        url: '',
        type: _networkController.RpcEndpointType.Custom,
        networkClientId: ''
      }],
      defaultRpcEndpointIndex: 0,
      chainId: _networks.MultichainNetworks.BITCOIN_TESTNET
    },
    [_networks.MultichainNetworks.BITCOIN_SIGNET]: {
      ..._networks.MULTICHAIN_PROVIDER_CONFIGS[_networks.MultichainNetworks.BITCOIN_SIGNET],
      blockExplorerUrls: [],
      name: _networks.MULTICHAIN_PROVIDER_CONFIGS[_networks.MultichainNetworks.BITCOIN_SIGNET].nickname ?? '',
      nativeCurrency: 'sBTC',
      rpcEndpoints: [{
        url: '',
        type: _networkController.RpcEndpointType.Custom,
        networkClientId: ''
      }],
      defaultRpcEndpointIndex: 0,
      chainId: _networks.MultichainNetworks.BITCOIN_SIGNET
    }
  };
};
exports.getMultichainNetworkConfigurationsByChainId = getMultichainNetworkConfigurationsByChainId;
const getMemoizedMultichainNetworkConfigurationsByChainId = exports.getMemoizedMultichainNetworkConfigurationsByChainId = (0, _util2.createDeepEqualSelector)([getMultichainNetworkConfigurationsByChainId], networkConfigurations => networkConfigurations);
function getLastSelectedNonEvmAccount(state) {
  const nonEvmAccounts = (0, _accounts.getInternalAccounts)(state);
  const sortedNonEvmAccounts = nonEvmAccounts.filter(account => !(0, _keyringApi.isEvmAccountType)(account.type)).sort((a, b) => (b.metadata.lastSelected ?? 0) - (a.metadata.lastSelected ?? 0));
  return sortedNonEvmAccounts.length > 0 ? sortedNonEvmAccounts[0] : undefined;
}
function getLastSelectedSolanaAccount(state) {
  const nonEvmAccounts = (0, _accounts.getInternalAccounts)(state);
  const sortedNonEvmAccounts = nonEvmAccounts.filter(account => (0, _accounts.isSolanaAccount)(account)).sort((a, b) => (b.metadata.lastSelected ?? 0) - (a.metadata.lastSelected ?? 0));
  return sortedNonEvmAccounts.length > 0 ? sortedNonEvmAccounts[0] : undefined;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\multichain.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain\\networks.ts", {"../../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../../shared/lib/network-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\network-utils.ts","../../../shared/modules/selectors/multichain":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\multichain.ts","../../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../../shared/modules/selectors/util":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\util.js","../accounts":"D:\\code\\v\\metamask-extension\\ui\\selectors\\accounts.ts","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/multichain-network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\index.cjs","@metamask/network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cmultichain%5Cnetworks.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectFirstUnavailableEvmNetwork = exports.selectAnyEnabledNetworksAreAvailable = exports.getSelectedMultichainNetworkConfiguration = exports.getSelectedMultichainNetworkChainId = exports.getNonEvmMultichainNetworkConfigurationsByChainId = exports.getNetworksWithTransactionActivity = exports.getNetworksWithActivity = exports.getMultichainNetworkConfigurationsByChainId = exports.getIsNonEvmNetworksEnabled = exports.getIsEvmMultichainNetworkSelected = exports.getEnabledNetworksByNamespace = exports.getEnabledNetworkClientIds = exports.getEnabledChainIds = exports.getAllEnabledNetworksForAllNamespaces = void 0;
var _multichainNetworkController = require("@metamask/multichain-network-controller");
var _networkController = require("@metamask/network-controller");
var _keyringApi = require("@metamask/keyring-api");
var _utils = require("@metamask/utils");
var _reselect = require("reselect");
var _networks = require("../../../shared/modules/selectors/networks");
var _util = require("../../../shared/modules/selectors/util");
var _selectors = require("../selectors");
var _accounts = require("../accounts");
var _multichain = require("../../../shared/modules/selectors/multichain");
var _networkUtils = require("../../../shared/lib/network-utils");
var _network = require("../../../shared/constants/network");
// Selector types

/**
 * This type takes into account the state
 * of the multichain-network-controller and
 * the network-controller.
 */

// Selectors

const getIsNonEvmNetworksEnabled = exports.getIsNonEvmNetworksEnabled = (0, _util.createDeepEqualSelector)(_selectors.getIsBitcoinSupportEnabled, _selectors.getIsSolanaSupportEnabled, _accounts.getInternalAccounts, (isBitcoinEnabled, isSolanaEnabled, internalAccounts) => {
  if (isBitcoinEnabled && isSolanaEnabled) {
    return {
      bitcoinEnabled: true,
      solanaEnabled: true
    };
  }
  let bitcoinEnabled = isBitcoinEnabled;
  let solanaEnabled = isSolanaEnabled;

  // The scopes have been set to optional because the first time
  // they're used we can't guarantee that the scopes will be set
  // during the keyring migration execution.
  for (const {
    scopes
  } of internalAccounts) {
    if (scopes !== null && scopes !== void 0 && scopes.includes(_keyringApi.BtcScope.Mainnet || _keyringApi.BtcScope.Testnet || _keyringApi.BtcScope.Signet)) {
      bitcoinEnabled = true;
    }
    if (scopes !== null && scopes !== void 0 && scopes.includes(_keyringApi.SolScope.Mainnet)) {
      solanaEnabled = true;
    }
    if (bitcoinEnabled && solanaEnabled) {
      break;
    }
  }
  return {
    bitcoinEnabled,
    solanaEnabled
  };
});
const getNonEvmMultichainNetworkConfigurationsByChainId = exports.getNonEvmMultichainNetworkConfigurationsByChainId = (0, _util.createDeepEqualSelector)(state => state.metamask.multichainNetworkConfigurationsByChainId, getIsNonEvmNetworksEnabled, _selectors.getIsSolanaTestnetSupportEnabled, _selectors.getIsBitcoinTestnetSupportEnabled, (multichainNetworkConfigurationsByChainId, isNonEvmNetworksEnabled, isSolanaTestnetSupportEnabled, isBitcoinTestnetSupportEnabled) => {
  const filteredNonEvmNetworkConfigurationsByChainId = {};

  // This is not ideal but since there are only two non EVM networks
  // we can just filter them out based on the support enabled
  const {
    bitcoinEnabled,
    solanaEnabled
  } = isNonEvmNetworksEnabled;
  if (bitcoinEnabled && multichainNetworkConfigurationsByChainId && multichainNetworkConfigurationsByChainId[_keyringApi.BtcScope.Mainnet]) {
    filteredNonEvmNetworkConfigurationsByChainId[_keyringApi.BtcScope.Mainnet] = multichainNetworkConfigurationsByChainId[_keyringApi.BtcScope.Mainnet];
  }
  if (bitcoinEnabled && isBitcoinTestnetSupportEnabled && multichainNetworkConfigurationsByChainId) {
    if (multichainNetworkConfigurationsByChainId[_keyringApi.BtcScope.Testnet]) {
      filteredNonEvmNetworkConfigurationsByChainId[_keyringApi.BtcScope.Testnet] = multichainNetworkConfigurationsByChainId[_keyringApi.BtcScope.Testnet];
    }
    if (multichainNetworkConfigurationsByChainId[_keyringApi.BtcScope.Signet]) {
      filteredNonEvmNetworkConfigurationsByChainId[_keyringApi.BtcScope.Signet] = multichainNetworkConfigurationsByChainId[_keyringApi.BtcScope.Signet];
    }
  }
  if (solanaEnabled && multichainNetworkConfigurationsByChainId && multichainNetworkConfigurationsByChainId[_keyringApi.SolScope.Mainnet]) {
    filteredNonEvmNetworkConfigurationsByChainId[_keyringApi.SolScope.Mainnet] = multichainNetworkConfigurationsByChainId[_keyringApi.SolScope.Mainnet];
  }
  if (solanaEnabled && isSolanaTestnetSupportEnabled && multichainNetworkConfigurationsByChainId && multichainNetworkConfigurationsByChainId[_keyringApi.SolScope.Devnet]) {
    filteredNonEvmNetworkConfigurationsByChainId[_keyringApi.SolScope.Devnet] = multichainNetworkConfigurationsByChainId[_keyringApi.SolScope.Devnet];
  }
  return filteredNonEvmNetworkConfigurationsByChainId;
});
const getMultichainNetworkConfigurationsByChainId = exports.getMultichainNetworkConfigurationsByChainId = (0, _util.createDeepEqualSelector)(
///: BEGIN:ONLY_INCLUDE_IF(multichain)
getNonEvmMultichainNetworkConfigurationsByChainId,
///: END:ONLY_INCLUDE_IF
_networks.getNetworkConfigurationsByChainId, (
///: BEGIN:ONLY_INCLUDE_IF(multichain)
nonEvmNetworkConfigurationsByChainId,
///: END:ONLY_INCLUDE_IF
networkConfigurationsByChainId) => {
  // There's a fallback for EVM network names/nicknames, in case the network
  // does not have a name/nickname the fallback is the first rpc endpoint url.
  // TODO: Update toMultichainNetworkConfigurationsByChainId to handle this case.
  const evmNetworks = Object.entries(networkConfigurationsByChainId).reduce((acc, [, network]) => ({
    ...acc,
    [(0, _multichainNetworkController.toEvmCaipChainId)(network.chainId)]: {
      ...(0, _multichainNetworkController.toMultichainNetworkConfiguration)(network),
      name: network.name || network.rpcEndpoints[network.defaultRpcEndpointIndex].url
    }
  }), {});
  const networks = {
    ///: BEGIN:ONLY_INCLUDE_IF(multichain)
    ...nonEvmNetworkConfigurationsByChainId,
    ///: END:ONLY_INCLUDE_IF
    ...evmNetworks
  };
  return [networks, networkConfigurationsByChainId];
});
const getIsEvmMultichainNetworkSelected = state => state.metamask.isEvmSelected;
exports.getIsEvmMultichainNetworkSelected = getIsEvmMultichainNetworkSelected;
const getSelectedMultichainNetworkChainId = state => {
  const isEvmSelected = getIsEvmMultichainNetworkSelected(state);
  if (isEvmSelected) {
    const evmNetworkConfig = (0, _networks.getProviderConfig)(state);
    return (0, _multichainNetworkController.toEvmCaipChainId)(evmNetworkConfig.chainId);
  }
  return state.metamask.selectedMultichainNetworkChainId;
};
exports.getSelectedMultichainNetworkChainId = getSelectedMultichainNetworkChainId;
const getSelectedMultichainNetworkConfiguration = state => {
  const chainId = getSelectedMultichainNetworkChainId(state);
  const [networkConfigurationsByChainId] = getMultichainNetworkConfigurationsByChainId(state);
  return networkConfigurationsByChainId[chainId];
};
exports.getSelectedMultichainNetworkConfiguration = getSelectedMultichainNetworkConfiguration;
const getNetworksWithActivity = state => state.metamask.networksWithTransactionActivity;
exports.getNetworksWithActivity = getNetworksWithActivity;
const getNetworksWithTransactionActivity = exports.getNetworksWithTransactionActivity = (0, _util.createDeepEqualSelector)(getNetworksWithActivity, networksWithActivity => networksWithActivity);
const getEnabledNetworksByNamespace = exports.getEnabledNetworksByNamespace = (0, _util.createDeepEqualSelector)(_multichain.getEnabledNetworks, getSelectedMultichainNetworkChainId, (enabledNetworkMap, currentMultichainChainId) => {
  const {
    namespace
  } = (0, _utils.parseCaipChainId)(currentMultichainChainId);
  const namespaceMap = enabledNetworkMap[namespace] ?? {};
  return Object.fromEntries(Object.entries(namespaceMap).filter(([, enabled]) => enabled === true));
});
const getAllEnabledNetworksForAllNamespaces = exports.getAllEnabledNetworksForAllNamespaces = (0, _util.createDeepEqualSelector)(_multichain.getEnabledNetworks, enabledNetworkMap => Object.values(enabledNetworkMap).flatMap(namespaceNetworks => Object.entries(namespaceNetworks).filter(([, enabled]) => enabled).map(([chainId]) => chainId)));
const getEnabledChainIds = exports.getEnabledChainIds = (0, _util.createDeepEqualSelector)(_networks.getNetworkConfigurationsByChainId, _multichain.getEnabledNetworks, getSelectedMultichainNetworkChainId, (networkConfigurations, enabledNetworks, currentMultichainChainId) => {
  const {
    namespace
  } = (0, _utils.parseCaipChainId)(currentMultichainChainId);

  // Get enabled networks for the current namespace
  const networksForNamespace = enabledNetworks[namespace] || {};
  return Object.keys(networkConfigurations).filter(chainId => networksForNamespace[chainId]);
});
const getEnabledNetworkClientIds = exports.getEnabledNetworkClientIds = (0, _util.createDeepEqualSelector)(_networks.getNetworkConfigurationsByChainId, _multichain.getEnabledNetworks, getSelectedMultichainNetworkChainId, (networkConfigurations, enabledNetworks, currentMultichainChainId) => {
  const {
    namespace
  } = (0, _utils.parseCaipChainId)(currentMultichainChainId);

  // Get enabled networks for the current namespace
  const networksForNamespace = enabledNetworks[namespace] || {};
  return Object.entries(networkConfigurations).reduce((acc, [chainId, network]) => {
    if (networksForNamespace[chainId]) {
      acc.push(network.rpcEndpoints[network.defaultRpcEndpointIndex].networkClientId);
    }
    return acc;
  }, []);
});
const selectAnyEnabledNetworksAreAvailable = exports.selectAnyEnabledNetworksAreAvailable = (0, _reselect.createSelector)(_multichain.getEnabledNetworks, _networks.selectDefaultNetworkClientIdsByChainId, _networks.getNetworksMetadata, (allEnabledNetworks, defaultNetworkClientIdsByChainId, networksMetadata) => {
  return Object.entries(allEnabledNetworks).reduce((result, [namespace, enabledNetworksByChainId]) => {
    if (namespace === _utils.KnownCaipNamespace.Eip155) {
      const chainIds = Object.entries(enabledNetworksByChainId).filter(([_chainId, isEnabled]) => isEnabled).map(([chainId, _isEnabled]) => chainId);
      const networkClientIds = chainIds.map(chainId => defaultNetworkClientIdsByChainId[chainId]);
      return (
        // If only non-EVM networks are enabled, then we may still
        // have an entry for EIP-155 but it will be empty
        networkClientIds.length === 0 || networkClientIds.some(networkClientId => {
          var _networksMetadata$net;
          return ((_networksMetadata$net = networksMetadata[networkClientId]) === null || _networksMetadata$net === void 0 ? void 0 : _networksMetadata$net.status) === _networkController.NetworkStatus.Available;
        })
      );
    }
    // Assume that all non-EVM networks are available
    return result;
  }, true);
});
const selectFirstUnavailableEvmNetwork = exports.selectFirstUnavailableEvmNetwork = (0, _reselect.createSelector)(_multichain.getEnabledNetworks, _networks.getNetworkConfigurationsByChainId, _networks.getNetworksMetadata, (enabledNetworks, networkConfigurationsByChainId, networksMetadata) => {
  const enabledEvmNetworks = enabledNetworks[_utils.KnownCaipNamespace.Eip155] ?? {};
  const enabledChainIds = Object.entries(enabledEvmNetworks).filter(([, isEnabled]) => isEnabled).map(([chainId]) => chainId);
  for (const chainId of enabledChainIds) {
    const networkConfiguration = networkConfigurationsByChainId[chainId];
    if (networkConfiguration) {
      // Get the network client ID directly from the network configuration
      const {
        rpcEndpoints,
        defaultRpcEndpointIndex,
        name
      } = networkConfiguration;
      const rpcEndpoint = rpcEndpoints[defaultRpcEndpointIndex];
      if (rpcEndpoint) {
        const metadata = networksMetadata[rpcEndpoint.networkClientId];
        if (metadata !== undefined && metadata.status !== _networkController.NetworkStatus.Available) {
          return {
            networkClientId: rpcEndpoint.networkClientId,
            chainId,
            networkName: name,
            // We have to use this function to check whether the endpoint is
            // an Infura endpoint because some Infura endpoint URLs use the
            // wrong type.
            isInfuraEndpoint: (0, _networkUtils.getIsMetaMaskInfuraEndpointUrl)(rpcEndpoint.url, _network.infuraProjectId ?? '')
          };
        }
      }
    }
  }
  return null;
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\multichain\\networks.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\origin-throttling.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Corigin-throttling.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectThrottledOrigins = void 0;
const selectThrottledOrigins = state => state.metamask.throttledOrigins;
exports.selectThrottledOrigins = selectThrottledOrigins;

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\origin-throttling.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\remote-feature-flags.ts", {"../../shared/lib/manifestFlags":"D:\\code\\v\\metamask-extension\\shared\\lib\\manifestFlags.ts","lodash/merge":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\merge.js","reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cremote-feature-flags.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRemoteFeatureFlags = void 0;
var _merge = _interopRequireDefault(require("lodash/merge"));
var _reselect = require("reselect");
var _manifestFlags = require("../../shared/lib/manifestFlags");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * Gets the remote feature flags by combining flags from both the manifest and state.
 * Manifest flags take precedence and will override any duplicate flags from state.
 * This allows for both static (manifest) and dynamic (state) feature flag configuration.
 *
 * @param state - The MetaMask state object
 * @returns Combined feature flags object with manifest flags taking precedence over state flags
 */
const getRemoteFeatureFlags = exports.getRemoteFeatureFlags = (0, _reselect.createSelector)(() => (0, _manifestFlags.getManifestFlags)().remoteFeatureFlags, state => state.metamask.remoteFeatureFlags, (manifestFlags, stateFlags) => (0, _merge.default)({}, stateFlags, manifestFlags));

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\remote-feature-flags.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\seedless-onboarding\\index.ts", {"./social-sync":"D:\\code\\v\\metamask-extension\\ui\\selectors\\seedless-onboarding\\social-sync.ts"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cseedless-onboarding%5Cindex.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _socialSync = require("./social-sync");
Object.keys(_socialSync).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _socialSync[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _socialSync[key];
    }
  });
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\seedless-onboarding\\index.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\seedless-onboarding\\social-sync.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cseedless-onboarding%5Csocial-sync.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIsSocialLoginUserAuthenticated = getIsSocialLoginUserAuthenticated;
exports.getSocialLoginEmail = getSocialLoginEmail;
exports.getSocialLoginType = getSocialLoginType;
function getSocialLoginType(state) {
  return state.metamask.authConnection;
}
function getSocialLoginEmail(state) {
  return state.metamask.socialLoginEmail;
}

/**
 * Checks if the social login flow has been initialized and the user is authenticated.
 *
 * @param state - The backup state.
 * @returns True if the social login flow has been initialized and the user is authenticated, false otherwise.
 */
function getIsSocialLoginUserAuthenticated(state) {
  const hasSocialLoginType = Boolean(getSocialLoginType(state));
  const hasSocialLoginEmail = Boolean(getSocialLoginEmail(state));
  return state.metamask.isSeedlessOnboardingUserAuthenticated && hasSocialLoginType && hasSocialLoginEmail;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\seedless-onboarding\\social-sync.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\selectors.js", {"../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../shared/constants/bridge":"D:\\code\\v\\metamask-extension\\shared\\constants\\bridge.ts","../../shared/constants/hardware-wallets":"D:\\code\\v\\metamask-extension\\shared\\constants\\hardware-wallets.ts","../../shared/constants/keyring":"D:\\code\\v\\metamask-extension\\shared\\constants\\keyring.ts","../../shared/constants/labels":"D:\\code\\v\\metamask-extension\\shared\\constants\\labels.ts","../../shared/constants/multichain/assets":"D:\\code\\v\\metamask-extension\\shared\\constants\\multichain\\assets.ts","../../shared/constants/network":"D:\\code\\v\\metamask-extension\\shared\\constants\\network.ts","../../shared/constants/swaps":"D:\\code\\v\\metamask-extension\\shared\\constants\\swaps.ts","../../shared/constants/terms":"D:\\code\\v\\metamask-extension\\shared\\constants\\terms.js","../../shared/constants/time":"D:\\code\\v\\metamask-extension\\shared\\constants\\time.ts","../../shared/constants/tokens":"D:\\code\\v\\metamask-extension\\shared\\constants\\tokens.js","../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../shared/lib/multichain-feature-flags":"D:\\code\\v\\metamask-extension\\shared\\lib\\multichain-feature-flags.ts","../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","../../shared/modules/selectors/multichain":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\multichain.ts","../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../shared/modules/selectors/util":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\util.js","../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts","../../shared/modules/transaction.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\transaction.utils.ts","../ducks/app/app":"D:\\code\\v\\metamask-extension\\ui\\ducks\\app\\app.ts","../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../helpers/constants/design-system":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\design-system.ts","../helpers/utils/snaps":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\snaps.ts","../helpers/utils/token-cache-utils":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\token-cache-utils.ts","../helpers/utils/util":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\util.js","../pages/confirmations/confirmation/templates":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\confirmation\\templates\\index.js","./accounts":"D:\\code\\v\\metamask-extension\\ui\\selectors\\accounts.ts","./approvals":"D:\\code\\v\\metamask-extension\\ui\\selectors\\approvals.ts","./multichain":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain.ts","./multichain/networks":"D:\\code\\v\\metamask-extension\\ui\\selectors\\multichain\\networks.ts","./remote-feature-flags":"D:\\code\\v\\metamask-extension\\ui\\selectors\\remote-feature-flags.ts","./shared":"D:\\code\\v\\metamask-extension\\ui\\selectors\\shared.ts","./transactions":"D:\\code\\v\\metamask-extension\\ui\\selectors\\transactions.js","@metamask/bridge-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\bridge-controller\\dist\\index.cjs","@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/eth-qr-keyring":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-qr-keyring\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs","@metamask/name-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\name-controller\\dist\\index.cjs","@metamask/network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-controller\\dist\\index.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/snaps-rpc-methods":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","punycode/punycode.js":"D:\\code\\v\\metamask-extension\\node_modules\\punycode\\punycode.js","reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs","semver":"D:\\code\\v\\metamask-extension\\node_modules\\semver\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cselectors.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.accountSupportsSmartTx = accountSupportsSmartTx;
exports.accountsWithSendEtherInfoSelector = accountsWithSendEtherInfoSelector;
exports.activeTabHasPermissions = activeTabHasPermissions;
exports.checkIfMethodIsEnabled = checkIfMethodIsEnabled;
exports.checkNetworkAndAccountSupports1559 = checkNetworkAndAccountSupports1559;
exports.checkNetworkOrAccountNotSupports1559 = checkNetworkOrAccountNotSupports1559;
exports.doesAddressRequireLedgerHidConnection = doesAddressRequireLedgerHidConnection;
exports.getAccountName = getAccountName;
exports.getAccountToConnectToActiveTab = getAccountToConnectToActiveTab;
exports.getAccountType = getAccountType;
exports.getAccountTypeForKeyring = getAccountTypeForKeyring;
exports.getAccountsWithLabels = getAccountsWithLabels;
exports.getActiveQrCodeScanRequest = getActiveQrCodeScanRequest;
exports.getAddressBook = getAddressBook;
exports.getAddressBookEntry = getAddressBookEntry;
exports.getAddressBookEntryOrAccountName = getAddressBookEntryOrAccountName;
exports.getAddressConnectedSubjectMap = getAddressConnectedSubjectMap;
exports.getAddressSecurityAlertResponse = getAddressSecurityAlertResponse;
exports.getAdvancedGasFeeValues = getAdvancedGasFeeValues;
exports.getAdvancedInlineGasShown = getAdvancedInlineGasShown;
exports.getAllAccountsOnNetworkAreEmpty = getAllAccountsOnNetworkAreEmpty;
exports.getAllConnectedAccounts = exports.getAllChainsToPoll = void 0;
exports.getAllDetectedTokens = getAllDetectedTokens;
exports.getAllDetectedTokensForSelectedAddress = getAllDetectedTokensForSelectedAddress;
exports.getAllDomains = getAllDomains;
exports.getAllEnabledNetworks = void 0;
exports.getAllPermittedAccounts = getAllPermittedAccounts;
exports.getAllPermittedAccountsForCurrentTab = getAllPermittedAccountsForCurrentTab;
exports.getAllPermittedAccountsForSelectedTab = getAllPermittedAccountsForSelectedTab;
exports.getAllPermittedChainsForSelectedTab = getAllPermittedChainsForSelectedTab;
exports.getAllPermittedScopes = getAllPermittedScopes;
exports.getAllSnapAvailableUpdates = void 0;
exports.getAllTokens = getAllTokens;
exports.getAnySnapUpdateAvailable = void 0;
exports.getAppIsLoading = getAppIsLoading;
exports.getBlockExplorerLinkText = getBlockExplorerLinkText;
exports.getChainIdsToPoll = void 0;
exports.getCompleteAddressBook = getCompleteAddressBook;
exports.getConnectedSubjectsForAllAddresses = exports.getConnectedSitesListWithNetworkInfo = exports.getConnectedSitesList = exports.getConfirmationExchangeRates = void 0;
exports.getConnectedSubjectsForSelectedAddress = getConnectedSubjectsForSelectedAddress;
exports.getCrossChainMetaMaskCachedBalances = getCrossChainMetaMaskCachedBalances;
exports.getCrossChainTokenExchangeRates = void 0;
exports.getCurrencyRates = getCurrencyRates;
exports.getCurrentAccountWithSendEtherInfo = getCurrentAccountWithSendEtherInfo;
exports.getCurrentEthBalance = getCurrentEthBalance;
exports.getCurrentKeyring = getCurrentKeyring;
exports.getCurrentNetwork = void 0;
exports.getCustomNonceValue = getCustomNonceValue;
exports.getCustomTokenAmount = getCustomTokenAmount;
exports.getDefaultHomeActiveTabName = getDefaultHomeActiveTabName;
exports.getDetectedTokensInCurrentNetwork = getDetectedTokensInCurrentNetwork;
exports.getEditedNetwork = getEditedNetwork;
Object.defineProperty(exports, "getEnabledNetworks", {
  enumerable: true,
  get: function () {
    return _multichain.getEnabledNetworks;
  }
});
exports.getEnabledSnaps = void 0;
exports.getEnsResolutionByAddress = getEnsResolutionByAddress;
exports.getEthereumAddressNames = getEthereumAddressNames;
exports.getEvmInternalAccounts = void 0;
exports.getExternalServicesOnboardingToggleState = getExternalServicesOnboardingToggleState;
exports.getFeatureFlags = getFeatureFlags;
exports.getFeatureNotificationsEnabled = getFeatureNotificationsEnabled;
exports.getFirstPermissionRequest = getFirstPermissionRequest;
exports.getFirstSnapInstallOrUpdateRequest = getFirstSnapInstallOrUpdateRequest;
exports.getFullTxData = void 0;
exports.getHDEntropyIndex = getHDEntropyIndex;
exports.getHardwareWalletType = getHardwareWalletType;
exports.getHdKeyringOfSelectedAccountOrPrimaryKeyring = exports.getHdKeyringIndexByIdOrDefault = void 0;
exports.getHiddenAccountsList = getHiddenAccountsList;
exports.getInterfaceContent = exports.getInterface = exports.getInsightSnaps = exports.getInsightSnapIds = exports.getHideSnapBranding = void 0;
exports.getInternalAccount = getInternalAccount;
exports.getInternalAccountsSortedByKeyring = exports.getInternalAccountByAddress = void 0;
exports.getIpfsGateway = getIpfsGateway;
exports.getIsAccessedFromDappConnectedSitePopover = getIsAccessedFromDappConnectedSitePopover;
exports.getIsAddSnapAccountEnabled = getIsAddSnapAccountEnabled;
exports.getIsAddingNewNetwork = getIsAddingNewNetwork;
exports.getIsBitcoinSupportEnabled = getIsBitcoinSupportEnabled;
exports.getIsBitcoinTestnetSupportEnabled = getIsBitcoinTestnetSupportEnabled;
exports.getIsBridgeChain = getIsBridgeChain;
exports.getIsBridgeEnabled = void 0;
exports.getIsCustomNetwork = getIsCustomNetwork;
exports.getIsDefiPositionsEnabled = getIsDefiPositionsEnabled;
exports.getIsDynamicTokenListAvailable = getIsDynamicTokenListAvailable;
exports.getIsLineaMainnet = getIsLineaMainnet;
exports.getIsMainnet = getIsMainnet;
exports.getIsMultiRpcOnboarding = getIsMultiRpcOnboarding;
exports.getIsNewSettingsEnabled = getIsNewSettingsEnabled;
exports.getIsNonStandardEthChain = getIsNonStandardEthChain;
exports.getIsRpcFailoverEnabled = void 0;
exports.getIsSecurityAlertsEnabled = getIsSecurityAlertsEnabled;
exports.getIsSigningQRHardwareTransaction = getIsSigningQRHardwareTransaction;
exports.getIsSolanaSupportEnabled = getIsSolanaSupportEnabled;
exports.getIsSolanaTestnetSupportEnabled = getIsSolanaTestnetSupportEnabled;
exports.getIsSwapsChain = getIsSwapsChain;
exports.getIsTestnet = getIsTestnet;
exports.getIsTokenDetectionInactiveOnMainnet = getIsTokenDetectionInactiveOnMainnet;
exports.getIsTokenDetectionSupported = getIsTokenDetectionSupported;
exports.getIsTokenNetworkFilterEqualCurrentNetwork = getIsTokenNetworkFilterEqualCurrentNetwork;
exports.getIsWatchEthereumAccountEnabled = getIsWatchEthereumAccountEnabled;
exports.getIstokenDetectionInactiveOnNonMainnetSupportedNetwork = getIstokenDetectionInactiveOnNonMainnetSupportedNetwork;
exports.getKeyringOfSelectedAccount = void 0;
exports.getKeyringSnapAccounts = getKeyringSnapAccounts;
exports.getKeyringSnapRemovalResult = getKeyringSnapRemovalResult;
exports.getKnownMethodData = getKnownMethodData;
exports.getLastConnectedInfo = getLastConnectedInfo;
exports.getLastViewedUserSurvey = getLastViewedUserSurvey;
exports.getLocale = getLocale;
exports.getManageInstitutionalWallets = getManageInstitutionalWallets;
exports.getMarketData = void 0;
exports.getMaybeSelectedInternalAccount = getMaybeSelectedInternalAccount;
exports.getMemoizedUnapprovedTemplatedConfirmations = exports.getMemoizedUnapprovedConfirmations = exports.getMemoizedTargetSubjectMetadata = exports.getMemoizedMetadataContract = exports.getMemoizedMetaMaskInternalAccounts = exports.getMemoizedInterfaces = exports.getMemoizedInterfaceContent = exports.getMemoizedInterface = exports.getMemoizedCurrentChainId = void 0;
exports.getMetaMaskAccountBalances = getMetaMaskAccountBalances;
exports.getMetaMaskAccountsOrdered = exports.getMetaMaskAccountsConnected = exports.getMetaMaskAccounts = void 0;
exports.getMetaMaskCachedBalances = getMetaMaskCachedBalances;
exports.getMetaMaskHdKeyrings = getMetaMaskHdKeyrings;
exports.getMetaMaskKeyrings = getMetaMaskKeyrings;
exports.getMetaMetricsDataDeletionId = getMetaMetricsDataDeletionId;
exports.getMetaMetricsDataDeletionStatus = getMetaMetricsDataDeletionStatus;
exports.getMetaMetricsDataDeletionTimestamp = getMetaMetricsDataDeletionTimestamp;
exports.getMetaMetricsId = getMetaMetricsId;
exports.getNameLookupSnapsIds = exports.getNameLookupSnaps = exports.getMultipleTargetsSubjectMetadata = exports.getMetadataContractName = void 0;
exports.getNameSources = getNameSources;
exports.getNames = getNames;
exports.getNativeCurrencyForChain = getNativeCurrencyForChain;
exports.getNativeCurrencyImage = getNativeCurrencyImage;
exports.getNativeTokenCachedBalanceByChainIdByAccountAddress = getNativeTokenCachedBalanceByChainIdByAccountAddress;
exports.getNativeTokenCachedBalanceByChainIdSelector = void 0;
exports.getNativeTokenInfo = getNativeTokenInfo;
exports.getNetworkConfigurationIdByChainId = exports.getNetworkClientIdsToPoll = void 0;
exports.getNetworkConnectionBanner = getNetworkConnectionBanner;
exports.getNetworkDiscoverButtonEnabled = getNetworkDiscoverButtonEnabled;
exports.getNetworkIdentifier = getNetworkIdentifier;
exports.getNetworkToAutomaticallySwitchTo = getNetworkToAutomaticallySwitchTo;
exports.getNetworksTabSelectedNetworkConfigurationId = getNetworksTabSelectedNetworkConfigurationId;
exports.getNewNetworkAdded = getNewNetworkAdded;
exports.getNewNftAddedMessage = getNewNftAddedMessage;
exports.getNewTokensImported = getNewTokensImported;
exports.getNewTokensImportedError = getNewTokensImportedError;
exports.getNextSuggestedNonce = getNextSuggestedNonce;
exports.getNftIsStillFetchingIndication = getNftIsStillFetchingIndication;
exports.getNotifySnaps = void 0;
exports.getNumberOfAllUnapprovedTransactionsAndMessages = getNumberOfAllUnapprovedTransactionsAndMessages;
exports.getNumberOfTokens = getNumberOfTokens;
exports.getOnboardedInThisUISession = getOnboardedInThisUISession;
exports.getOnboardingDate = getOnboardingDate;
exports.getOpenSeaEnabled = getOpenSeaEnabled;
exports.getOrderedConnectedAccountsForActiveTab = void 0;
exports.getOrderedConnectedAccountsForConnectedDapp = getOrderedConnectedAccountsForConnectedDapp;
exports.getOrderedNetworksList = getOrderedNetworksList;
exports.getOriginOfCurrentTab = getOriginOfCurrentTab;
exports.getPendingTokens = void 0;
exports.getPermissionSubjects = getPermissionSubjects;
exports.getPermissionSubjectsDeepEqual = void 0;
exports.getPermissions = getPermissions;
exports.getPermissionsForActiveTab = getPermissionsForActiveTab;
exports.getPermissionsRequests = getPermissionsRequests;
exports.getPermittedAccountsByOrigin = getPermittedAccountsByOrigin;
exports.getPermittedEVMAccounts = getPermittedEVMAccounts;
exports.getPermittedEVMAccountsForCurrentTab = getPermittedEVMAccountsForCurrentTab;
exports.getPermittedEVMAccountsForSelectedTab = getPermittedEVMAccountsForSelectedTab;
exports.getPermittedEVMChains = getPermittedEVMChains;
exports.getPermittedEVMChainsByOrigin = getPermittedEVMChainsByOrigin;
exports.getPermittedEVMChainsForSelectedTab = getPermittedEVMChainsForSelectedTab;
exports.getPinnedAccountsList = getPinnedAccountsList;
exports.getPreferences = getPreferences;
exports.getPreinstalledSnaps = void 0;
exports.getPrivacyMode = getPrivacyMode;
exports.getRemoveNftMessage = getRemoveNftMessage;
exports.getRequestState = getRequestState;
exports.getRequestType = getRequestType;
exports.getRequestingNetworkInfo = getRequestingNetworkInfo;
exports.getRpcPrefsForCurrentProvider = getRpcPrefsForCurrentProvider;
exports.getSelectedAccount = void 0;
exports.getSelectedAccountCachedBalance = getSelectedAccountCachedBalance;
exports.getSelectedAccountNativeTokenCachedBalanceByChainId = getSelectedAccountNativeTokenCachedBalanceByChainId;
exports.getSelectedAccountTokensAcrossChains = getSelectedAccountTokensAcrossChains;
exports.getSelectedAddress = getSelectedAddress;
exports.getSelectedEvmInternalAccount = void 0;
exports.getSelectedInternalAccountWithBalance = getSelectedInternalAccountWithBalance;
exports.getSelectedNetwork = exports.getSelectedKeyringByIdOrDefault = void 0;
exports.getSendInputCurrencySwitched = getSendInputCurrencySwitched;
exports.getSettingsPageSnapsIds = exports.getSettingsPageSnaps = void 0;
exports.getShouldHideZeroBalanceTokens = getShouldHideZeroBalanceTokens;
exports.getShouldShowFiat = getShouldShowFiat;
exports.getShouldSubmitEventsForShieldEntryModal = getShouldSubmitEventsForShieldEntryModal;
exports.getShowAccountBanner = getShowAccountBanner;
exports.getShowBasicFunctionalityModal = getShowBasicFunctionalityModal;
exports.getShowBetaHeader = getShowBetaHeader;
exports.getShowConnectionsRemovedModal = getShowConnectionsRemovedModal;
exports.getShowDataDeletionErrorModal = getShowDataDeletionErrorModal;
exports.getShowDeleteMetaMetricsDataModal = getShowDeleteMetaMetricsDataModal;
exports.getShowDownloadMobileAppSlide = getShowDownloadMobileAppSlide;
exports.getShowExtensionInFullSizeView = getShowExtensionInFullSizeView;
exports.getShowFiatInTestnets = getShowFiatInTestnets;
exports.getShowNetworkBanner = getShowNetworkBanner;
exports.getShowOutdatedBrowserWarning = getShowOutdatedBrowserWarning;
exports.getShowPermissionsTour = getShowPermissionsTour;
exports.getShowPermittedNetworkToastOpen = getShowPermittedNetworkToastOpen;
exports.getShowRecoveryPhraseReminder = getShowRecoveryPhraseReminder;
exports.getShowShieldEntryModal = getShowShieldEntryModal;
exports.getShowTermsOfUse = getShowTermsOfUse;
exports.getShowTestNetworks = getShowTestNetworks;
exports.getShowUpdateModal = getShowUpdateModal;
exports.getShowWhatsNewPopup = getShowWhatsNewPopup;
exports.getSignatureInsightSnaps = exports.getSignatureInsightSnapIds = void 0;
exports.getSlides = getSlides;
exports.getSnapInsights = exports.getSnap = void 0;
exports.getSnapInstallOrUpdateRequests = getSnapInstallOrUpdateRequests;
exports.getSnapMetadata = exports.getSnapLatestVersion = void 0;
exports.getSnapRegistry = getSnapRegistry;
exports.getSnapRegistryData = void 0;
exports.getSnaps = getSnaps;
exports.getSnapsInstallPrivacyWarningShown = getSnapsInstallPrivacyWarningShown;
exports.getSnapsList = getSnapsList;
exports.getSnapsMetadata = void 0;
exports.getSortedAnnouncementsToShow = getSortedAnnouncementsToShow;
exports.getSubjectMetadata = getSubjectMetadata;
exports.getSubjectMetadataDeepEqual = void 0;
exports.getSubjectsWithPermission = getSubjectsWithPermission;
exports.getSubjectsWithSnapPermission = getSubjectsWithSnapPermission;
exports.getSuggestedNfts = getSuggestedNfts;
exports.getSuggestedTokens = getSuggestedTokens;
exports.getSwapsDefaultToken = getSwapsDefaultToken;
exports.getTargetAccount = getTargetAccount;
exports.getTargetAccountWithSendEtherInfo = getTargetAccountWithSendEtherInfo;
exports.getTargetSubjectMetadata = getTargetSubjectMetadata;
exports.getTestNetworkBackgroundColor = getTestNetworkBackgroundColor;
exports.getTheme = getTheme;
exports.getTokenNetworkFilter = exports.getTokenList = exports.getTokenExchangeRates = exports.getTokenDetectionSupportNetworkByChainId = exports.getThirdPartyNotifySnaps = void 0;
exports.getTokenScanCache = getTokenScanCache;
exports.getTokenSortConfig = exports.getTokenScanResultsForAddresses = void 0;
exports.getTokensAcrossChainsByAccountAddress = getTokensAcrossChainsByAccountAddress;
exports.getTokensMarketData = exports.getTokensAcrossChainsByAccountAddressSelector = void 0;
exports.getTotalUnapprovedCount = getTotalUnapprovedCount;
exports.getTxData = exports.getTransaction = void 0;
exports.getUSDConversionRate = getUSDConversionRate;
exports.getUnapprovedConfirmations = exports.getUSDConversionRateByChainId = void 0;
exports.getUnapprovedTemplatedConfirmations = getUnapprovedTemplatedConfirmations;
exports.getUnapprovedTransaction = void 0;
exports.getUnapprovedTxCount = getUnapprovedTxCount;
exports.getUnconnectedAccounts = getUnconnectedAccounts;
exports.getUpdatedAndSortedAccountsWithCaipAccountId = exports.getUpdatedAndSortedAccounts = void 0;
exports.getUrlScanCacheResult = getUrlScanCacheResult;
exports.getUseBlockie = getUseBlockie;
exports.getUseCurrencyRateCheck = getUseCurrencyRateCheck;
exports.getUseExternalNameSources = getUseExternalNameSources;
exports.getUseExternalServices = getUseExternalServices;
exports.getUseNftDetection = getUseNftDetection;
exports.getUsePhishDetect = getUsePhishDetect;
exports.getUseTokenDetection = getUseTokenDetection;
exports.getUseTransactionSimulations = getUseTransactionSimulations;
exports.getWatchedToken = void 0;
exports.getWeb3ShimUsageStateForOrigin = getWeb3ShimUsageStateForOrigin;
exports.getsnapsAddSnapAccountModalDismissed = getsnapsAddSnapAccountModalDismissed;
exports.isAccountConnectedToCurrentTab = void 0;
exports.isBalanceCached = isBalanceCached;
exports.isCurrentProviderCustom = isCurrentProviderCustom;
exports.isGlobalNetworkSelectorRemoved = void 0;
exports.isHardwareWallet = isHardwareWallet;
exports.selectERC20Tokens = exports.selectDefaultRpcEndpointByChainId = exports.selectConversionRateByChainId = exports.selectAllTokensFlat = exports.rawStateSelector = void 0;
exports.useSafeChainsListValidationSelector = exports.selectNonZeroUnusedApprovalsAllowList = exports.selectNftsByChainId = exports.selectNetworkIdentifierByChainId = exports.selectNetworkConfigurationByChainId = exports.selectInstalledSnaps = exports.selectERC20TokensByChain = void 0;
var _punycode = require("punycode/punycode.js");
var _permissionController = require("@metamask/permission-controller");
var _controllerUtils = require("@metamask/controller-utils");
var _snapsUtils = require("@metamask/snaps-utils");
var _lodash = require("lodash");
var _semver = _interopRequireDefault(require("semver"));
var _reselect = require("reselect");
var _nameController = require("@metamask/name-controller");
var _transactionController = require("@metamask/transaction-controller");
var _keyringApi = require("@metamask/keyring-api");
var _networkController = require("@metamask/network-controller");
var _snapsRpcMethods = require("@metamask/snaps-rpc-methods");
var _chainAgnosticPermission = require("@metamask/chain-agnostic-permission");
var _keyringController = require("@metamask/keyring-controller");
var _bridgeController = require("@metamask/bridge-controller");
var _utils = require("@metamask/utils");
var _ethQrKeyring = require("@metamask/eth-qr-keyring");
var _multichainFeatureFlags = require("../../shared/lib/multichain-feature-flags");
var _tokenCacheUtils = require("../helpers/utils/token-cache-utils");
var _networks = require("../../shared/modules/selectors/networks");
var _multichain = require("../../shared/modules/selectors/multichain");
var _util = require("../../app/scripts/lib/util");
var _network = require("../../shared/constants/network");
var _hardwareWallets = require("../../shared/constants/hardware-wallets");
var _keyring = require("../../shared/constants/keyring");
var _labels = require("../../shared/constants/labels");
var _swaps = require("../../shared/constants/swaps");
var _bridge = require("../../shared/constants/bridge");
var _transaction = require("../../shared/constants/transaction");
var _util2 = require("../helpers/utils/util");
var _templates = require("../pages/confirmations/confirmation/templates");
var _tokens = require("../../shared/constants/tokens");
var _time = require("../../shared/constants/time");
var _terms = require("../../shared/constants/terms");
var _metamask = require("../ducks/metamask/metamask");
var _app = require("../ducks/app/app");
var _stringUtils = require("../../shared/modules/string-utils");
var _conversion = require("../../shared/modules/conversion.utils");
var _designSystem = require("../helpers/constants/design-system");
var _app2 = require("../../shared/constants/app");
var _assets = require("../../shared/constants/multichain/assets");
var _transaction2 = require("../../shared/modules/transaction.utils");
var _hexstringUtils = require("../../shared/modules/hexstring-utils");
var _util3 = require("../../shared/modules/selectors/util");
var _snaps = require("../helpers/utils/snaps");
var _shared = require("./shared");
var _transactions = require("./transactions");
var _accounts = require("./accounts");
var _multichain2 = require("./multichain");
var _networks2 = require("./multichain/networks");
var _remoteFeatureFlags = require("./remote-feature-flags");
var _approvals = require("./approvals");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

// eslint-disable-next-line import/order

/**
 * @typedef {__import__('../../ui/store/store').MetaMaskReduxState} MetaMaskReduxState
 */

// Re-export this file so we don't have to update all references
// TODO: Update all references

const isGlobalNetworkSelectorRemoved = exports.isGlobalNetworkSelectorRemoved = true;

/** `appState` slice selectors */

const getConfirmationExchangeRates = state => {
  return state.appState.confirmationExchangeRates;
};
exports.getConfirmationExchangeRates = getConfirmationExchangeRates;
function getAppIsLoading(state) {
  return state.appState.isLoading;
}
function getNftIsStillFetchingIndication(state) {
  return state.appState.isNftStillFetchingIndication;
}
function getSendInputCurrencySwitched({
  appState
}) {
  return appState.sendInputCurrencySwitched;
}
function getCustomNonceValue(state) {
  return String(state.appState.customNonceValue);
}
function getNextSuggestedNonce(state) {
  return Number(state.appState.nextNonce);
}
function getShowWhatsNewPopup(state) {
  return state.appState.showWhatsNewPopup;
}
function getShowPermittedNetworkToastOpen(state) {
  return state.appState.showPermittedNetworkToastOpen;
}
function getNewNftAddedMessage(state) {
  return state.appState.newNftAddedMessage;
}
function getRemoveNftMessage(state) {
  return state.appState.removeNftMessage;
}

/**
 * To retrieve the name of the new Network added using add network form
 *
 * @param {*} state
 * @returns string
 */
function getNewNetworkAdded(state) {
  return state.appState.newNetworkAddedName;
}

/**
 * @param state
 * @returns {{ chainId: __import__('@metamask/utils').Hex; nickname: string; editCompleted: boolean} | undefined}
 */
function getEditedNetwork(state) {
  return state.appState.editedNetwork;
}
function getIsAddingNewNetwork(state) {
  return state.appState.isAddingNewNetwork;
}
function getIsAccessedFromDappConnectedSitePopover(state) {
  return state.appState.isAccessedFromDappConnectedSitePopover;
}
function getIsMultiRpcOnboarding(state) {
  return state.appState.isMultiRpcOnboarding;
}
function getNetworksTabSelectedNetworkConfigurationId(state) {
  return state.appState.selectedNetworkConfigurationId;
}

/**
 * To fetch the name of the tokens that are imported from tokens found page
 *
 * @param {*} state
 * @returns
 */
function getNewTokensImported(state) {
  return state.appState.newTokensImported;
}
function getNewTokensImportedError(state) {
  return state.appState.newTokensImportedError;
}
function getCustomTokenAmount(state) {
  return state.appState.customTokenAmount;
}
function getOnboardedInThisUISession(state) {
  return state.appState.onboardedInThisUISession;
}
function getShowBasicFunctionalityModal(state) {
  return state.appState.showBasicFunctionalityModal;
}
function getExternalServicesOnboardingToggleState(state) {
  return state.appState.externalServicesOnboardingToggleState;
}
function getShowDeleteMetaMetricsDataModal(state) {
  return state.appState.showDeleteMetaMetricsDataModal;
}
function getShowDataDeletionErrorModal(state) {
  return state.appState.showDataDeletionErrorModal;
}

///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
function getKeyringSnapRemovalResult(state) {
  return state.appState.keyringRemovalSnapModal;
}
///: END:ONLY_INCLUDE_IF

const getPendingTokens = state => state.appState.pendingTokens;
exports.getPendingTokens = getPendingTokens;
function getShowConnectionsRemovedModal(state) {
  return state.appState.showConnectionsRemovedModal;
}
function getShowShieldEntryModal(state) {
  var _state$appState$shiel;
  return (_state$appState$shiel = state.appState.shieldEntryModal) === null || _state$appState$shiel === void 0 ? void 0 : _state$appState$shiel.show;
}
function getShouldSubmitEventsForShieldEntryModal(state) {
  var _state$appState$shiel2;
  return (_state$appState$shiel2 = state.appState.shieldEntryModal) === null || _state$appState$shiel2 === void 0 ? void 0 : _state$appState$shiel2.shouldSubmitEvents;
}

/** `metamask` slice selectors */

function getNetworkIdentifier(state) {
  const {
    type,
    nickname,
    rpcUrl
  } = (0, _networks.getProviderConfig)(state);
  return nickname || rpcUrl || type;
}
function getMetaMetricsId(state) {
  const {
    metaMetricsId
  } = state.metamask;
  return metaMetricsId;
}
function isCurrentProviderCustom(state) {
  const provider = (0, _networks.getProviderConfig)(state);
  return provider.type === _network.NETWORK_TYPES.RPC && !Object.values(_network.CHAIN_IDS).includes(provider.chainId);
}
function getActiveQrCodeScanRequest(state) {
  return state.metamask.activeQrCodeScanRequest;
}
function getIsSigningQRHardwareTransaction(state) {
  const activeQrCodeScanRequest = getActiveQrCodeScanRequest(state);
  return activeQrCodeScanRequest && activeQrCodeScanRequest.type === _ethQrKeyring.QrScanRequestType.SIGN;
}
function getCurrentKeyring(state) {
  var _internalAccount$meta;
  const internalAccount = (0, _accounts.getSelectedInternalAccount)(state);
  if (!internalAccount) {
    return null;
  }
  return (_internalAccount$meta = internalAccount.metadata) === null || _internalAccount$meta === void 0 ? void 0 : _internalAccount$meta.keyring;
}

/**
 * The function returns true if network and account details are fetched and
 * both of them support EIP-1559.
 *
 * @param state
 * @param [networkClientId] - The optional network client ID to check network and account for EIP-1559 support
 */
function checkNetworkAndAccountSupports1559(state, networkClientId) {
  const networkSupports1559 = (0, _metamask.isEIP1559Network)(state, networkClientId);
  return networkSupports1559;
}

/**
 * The function returns true if network and account details are fetched and
 * either of them do not support EIP-1559.
 *
 * @param state
 */
function checkNetworkOrAccountNotSupports1559(state) {
  const networkNotSupports1559 = (0, _metamask.isNotEIP1559Network)(state);
  return networkNotSupports1559;
}

/**
 * Checks if the current wallet is a hardware wallet.
 *
 * @param {object} state
 * @returns {boolean}
 */
function isHardwareWallet(state) {
  var _keyring$type;
  const keyring = getCurrentKeyring(state);
  return Boolean(keyring === null || keyring === void 0 || (_keyring$type = keyring.type) === null || _keyring$type === void 0 ? void 0 : _keyring$type.includes('Hardware'));
}

/**
 * Checks if the account supports smart transactions.
 *
 * @param {object} state - The state object.
 * @returns {boolean}
 */
function accountSupportsSmartTx(state) {
  const accountType = getAccountType(state);
  return Boolean(accountType !== 'snap');
}

/**
 * Get a HW wallet type, e.g. "Ledger Hardware"
 *
 * @param {object} state
 * @returns {string | undefined}
 */
function getHardwareWalletType(state) {
  const keyring = getCurrentKeyring(state);
  return isHardwareWallet(state) ? keyring.type : undefined;
}
function getAccountType(state) {
  const currentKeyring = getCurrentKeyring(state);
  return getAccountTypeForKeyring(currentKeyring);
}
function getAccountTypeForKeyring(keyring) {
  if (!keyring) {
    return '';
  }
  const {
    type
  } = keyring;
  switch (type) {
    case _keyring.KeyringType.trezor:
    case _keyring.KeyringType.oneKey:
    case _keyring.KeyringType.ledger:
    case _keyring.KeyringType.lattice:
    case _keyring.KeyringType.qr:
      return 'hardware';
    case _keyring.KeyringType.imported:
      return 'imported';
    ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
    case _keyring.KeyringType.snap:
      return 'snap';
    ///: END:ONLY_INCLUDE_IF
    default:
      return 'default';
  }
}

/**
 * Get MetaMask accounts, including account name and balance.
 */
const getMetaMaskAccounts = exports.getMetaMaskAccounts = (0, _util3.createDeepEqualSelector)(_accounts.getInternalAccounts, getMetaMaskAccountBalances, getMetaMaskCachedBalances, _multichain2.getMultichainBalances, _multichain2.getMultichainNetworkProviders, _networks.getCurrentChainId, (_, chainId) => chainId, (internalAccounts, balances, cachedBalances, multichainBalances, multichainNetworkProviders, currentChainId, chainId) => Object.values(internalAccounts).reduce((accounts, internalAccount) => {
  // TODO: mix in the identity state here as well, consolidating this
  // selector with `accountsWithSendEtherInfoSelector`
  let account = internalAccount;
  if (chainId === undefined || currentChainId === chainId) {
    // TODO: `AccountTracker` balances are in hex and `MultichainBalance` are in number.
    // We should consolidate the format to either hex or number
    if ((0, _keyringApi.isEvmAccountType)(internalAccount.type)) {
      if (balances !== null && balances !== void 0 && balances[internalAccount.address]) {
        account = {
          ...account,
          ...balances[internalAccount.address]
        };
      }
    } else {
      var _multichainBalances$i;
      const multichainNetwork = multichainNetworkProviders.find(network => network.isAddressCompatible(internalAccount.address));
      account = {
        ...account,
        balance: (multichainBalances === null || multichainBalances === void 0 || (_multichainBalances$i = multichainBalances[internalAccount.id]) === null || _multichainBalances$i === void 0 || (_multichainBalances$i = _multichainBalances$i[_assets.MULTICHAIN_NETWORK_TO_ASSET_TYPES[multichainNetwork.chainId]]) === null || _multichainBalances$i === void 0 ? void 0 : _multichainBalances$i.amount) ?? '0'
      };
    }
    if (account.balance === null || account.balance === undefined) {
      account = {
        ...account,
        balance: (cachedBalances && cachedBalances[internalAccount.address]) ?? '0x0'
      };
    }
  } else {
    account = {
      ...account,
      balance: (cachedBalances && cachedBalances[internalAccount.address]) ?? '0x0'
    };
  }
  return {
    ...accounts,
    [internalAccount.address]: account
  };
}, {}));
/**
 * Returns the address of the selected InternalAccount from the Metamask state.
 *
 * @param state - The Metamask state object.
 * @returns {string} The selected address.
 */
function getSelectedAddress(state) {
  var _getSelectedInternalA;
  return (_getSelectedInternalA = (0, _accounts.getSelectedInternalAccount)(state)) === null || _getSelectedInternalA === void 0 ? void 0 : _getSelectedInternalA.address;
}
const getInternalAccountByAddress = exports.getInternalAccountByAddress = (0, _reselect.createSelector)(state => state.metamask.internalAccounts.accounts, (_, address) => address, (accounts, address) => {
  return Object.values(accounts).find(account => (0, _stringUtils.isEqualCaseInsensitive)(account.address, address));
});
function getMaybeSelectedInternalAccount(state) {
  var _state$metamask$inter, _state$metamask$inter2;
  // Same as `getSelectedInternalAccount`, but might potentially be `undefined`:
  // - This might happen during the onboarding
  const accountId = (_state$metamask$inter = state.metamask.internalAccounts) === null || _state$metamask$inter === void 0 ? void 0 : _state$metamask$inter.selectedAccount;
  return accountId ? (_state$metamask$inter2 = state.metamask.internalAccounts) === null || _state$metamask$inter2 === void 0 ? void 0 : _state$metamask$inter2.accounts[accountId] : undefined;
}
function checkIfMethodIsEnabled(state, methodName) {
  const internalAccount = (0, _accounts.getSelectedInternalAccount)(state);
  return Boolean(internalAccount.methods.includes(methodName));
}
function getSelectedInternalAccountWithBalance(state) {
  const selectedAccount = (0, _accounts.getSelectedInternalAccount)(state);
  const rawAccount = getMetaMaskAccountBalances(state)[selectedAccount.address];
  const selectedAccountWithBalance = {
    ...selectedAccount,
    balance: rawAccount ? rawAccount.balance : '0x0'
  };
  return selectedAccountWithBalance;
}
function getInternalAccount(state, accountId) {
  return state.metamask.internalAccounts.accounts[accountId];
}
const getEvmInternalAccounts = exports.getEvmInternalAccounts = (0, _reselect.createSelector)(_accounts.getInternalAccounts, accounts => {
  return accounts.filter(account => (0, _keyringApi.isEvmAccountType)(account.type));
});
const getSelectedEvmInternalAccount = exports.getSelectedEvmInternalAccount = (0, _reselect.createSelector)(getEvmInternalAccounts, accounts => {
  // We should always have 1 EVM account (if not, it would be `undefined`, same
  // as `getSelectedInternalAccount` selector.
  const [evmAccountSelected] = (0, _util2.sortSelectedInternalAccounts)(accounts);
  return evmAccountSelected;
});

/**
 * Returns an array of internal accounts sorted by keyring.
 *
 * @param keyrings - The array of keyrings.
 * @param accounts - The object containing the accounts.
 * @returns The array of internal accounts sorted by keyring.
 */
const getInternalAccountsSortedByKeyring = exports.getInternalAccountsSortedByKeyring = (0, _util3.createDeepEqualSelector)(getMetaMaskKeyrings, getMetaMaskAccounts, (keyrings, accounts) => {
  const thirdPartySnaps = 'thirdPartySnaps';
  // Create a map of entropySource map to accounts for quick lookup
  const entropySourceToAccountsMap = Object.values(accounts).reduce((map, account) => {
    var _account$metadata;
    if (((_account$metadata = account.metadata) === null || _account$metadata === void 0 || (_account$metadata = _account$metadata.keyring) === null || _account$metadata === void 0 ? void 0 : _account$metadata.type) === _keyringController.KeyringTypes.snap) {
      const {
        entropySource = thirdPartySnaps
      } = account.options || {};
      if (!map[entropySource]) {
        map[entropySource] = [];
      }
      map[entropySource].push(account);
    }
    return map;
  }, {});

  // keep existing keyring order
  return keyrings.reduce((internalAccounts, keyring) => {
    // Get regular accounts for this keyring
    const keyringAccounts = keyring.accounts.map(address => accounts[address]);

    // If it's an HD keyring, add any snap accounts that belong to it
    if (keyring.type === _keyringController.KeyringTypes.hd) {
      const snapAccounts = entropySourceToAccountsMap[keyring.metadata.id] || [];
      internalAccounts.push(...keyringAccounts, ...snapAccounts);
      return internalAccounts;
    } else if (keyring.type === _keyringController.KeyringTypes.snap) {
      const thirdpartySnapAccounts = entropySourceToAccountsMap[thirdPartySnaps] || [];
      // In a scenario where there are multiple snap keyrings, which isn't the case for today
      // There would be duplicate third party snap accounts that are being pushed into internalAccounts again
      // This will only be run once, when there is only one snap keyring
      const accountsToAdd = thirdpartySnapAccounts.filter(account => !internalAccounts.some(existing => existing.id === account.id));
      internalAccounts.push(...accountsToAdd);
      return internalAccounts;
    }
    internalAccounts.push(...keyringAccounts);
    return internalAccounts;
  }, []);
});
function getNumberOfTokens(state) {
  const {
    tokens
  } = state.metamask;
  return tokens ? tokens.length : 0;
}
function getMetaMaskKeyrings(state) {
  return state.metamask.keyrings;
}
function getMetaMaskHdKeyrings(state) {
  return state.metamask.keyrings.filter(keyring => keyring.type === _keyringController.KeyringTypes.hd);
}
function getHDEntropyIndex(state) {
  const selectedAddress = getSelectedAddress(state);
  const keyrings = getMetaMaskKeyrings(state);
  const hdKeyrings = keyrings.filter(keyring => keyring.type === _keyring.KeyringType.hdKeyTree);
  let hdEntropyIndex = hdKeyrings.findIndex(keyring => keyring.accounts.includes(selectedAddress));
  // if the account is not found in the hd keyring, we should try to get entropySource from the accounts options
  if (hdEntropyIndex === -1) {
    const account = (0, _accounts.getSelectedInternalAccount)(state);
    if (account) {
      const {
        entropySource
      } = account.options;
      hdEntropyIndex = keyrings.findIndex(({
        metadata
      }) => metadata.id === entropySource);
    }
  }
  return hdEntropyIndex === -1 ? undefined : hdEntropyIndex;
}

/**
 * Get account balances state.
 *
 * @param {object} state - Redux state
 * @returns {object} A map of account addresses to account objects (which includes the account balance)
 */
function getMetaMaskAccountBalances(state) {
  var _state$metamask;
  const currentChainId = (0, _networks.getCurrentChainId)(state);
  return ((_state$metamask = state.metamask) === null || _state$metamask === void 0 || (_state$metamask = _state$metamask.accountsByChainId) === null || _state$metamask === void 0 ? void 0 : _state$metamask[currentChainId]) ?? {};
}
function getMetaMaskCachedBalances(state, networkChainId) {
  var _state$metamask$accou2;
  const enabledNetworks = (0, _multichain.getEnabledNetworks)(state);
  const eip155 = (enabledNetworks === null || enabledNetworks === void 0 ? void 0 : enabledNetworks.eip155) ?? {};
  const enabledIds = Object.keys(eip155).filter(id => Boolean(eip155[id]));
  if (enabledIds.length === 1) {
    var _state$metamask$accou;
    const chainId = enabledIds[0];
    if ((_state$metamask$accou = state.metamask.accountsByChainId) !== null && _state$metamask$accou !== void 0 && _state$metamask$accou[chainId]) {
      return Object.entries(state.metamask.accountsByChainId[chainId]).reduce((accumulator, [key, value]) => {
        accumulator[key] = value.balance;
        return accumulator;
      }, {});
    }
    return {};
  }
  const chainId = networkChainId ?? (0, _networks.getCurrentChainId)(state);
  if ((_state$metamask$accou2 = state.metamask.accountsByChainId) !== null && _state$metamask$accou2 !== void 0 && _state$metamask$accou2[chainId]) {
    return Object.entries(state.metamask.accountsByChainId[chainId]).reduce((accumulator, [key, value]) => {
      accumulator[key] = value.balance;
      return accumulator;
    }, {});
  }
  return {};
}
function getCrossChainMetaMaskCachedBalances(state) {
  const allAccountsByChainId = state.metamask.accountsByChainId;
  return Object.keys(allAccountsByChainId).reduce((acc, topLevelKey) => {
    acc[topLevelKey] = Object.keys(allAccountsByChainId[topLevelKey]).reduce((innerAcc, innerKey) => {
      innerAcc[innerKey] = allAccountsByChainId[topLevelKey][innerKey].balance;
      return innerAcc;
    }, {});
    return acc;
  }, {});
}

/**
 * Based on the current account address, return the balance for the native token of all chain networks on that account
 *
 * @param {object} state - Redux state
 * @returns {object} An object of tokens with balances for the given account. Data relationship will be chainId => balance
 */
function getSelectedAccountNativeTokenCachedBalanceByChainId(state) {
  const {
    accountsByChainId
  } = state.metamask;
  const {
    address: selectedAddress
  } = getSelectedEvmInternalAccount(state);
  const balancesByChainId = {};
  for (const [chainId, accounts] of Object.entries(accountsByChainId || {})) {
    if (accounts[selectedAddress]) {
      balancesByChainId[chainId] = accounts[selectedAddress].balance;
    }
  }
  return balancesByChainId;
}

/**
 * Based on the current account address, query for all tokens across all chain networks on that account,
 * including the native tokens, without hardcoding any native token information.
 *
 * @param {object} state - Redux state
 * @returns {object} An object mapping chain IDs to arrays of tokens (including native tokens) with balances.
 */
function getSelectedAccountTokensAcrossChains(state) {
  const tokensByChain = {};
  const {
    address: selectedAddress
  } = getSelectedEvmInternalAccount(state) ?? {};
  if (!selectedAddress) {
    return tokensByChain;
  }
  const {
    allTokens
  } = state.metamask;
  const nativeTokenBalancesByChainId = getSelectedAccountNativeTokenCachedBalanceByChainId(state);
  const chainIds = new Set([...Object.keys(allTokens || {}), ...Object.keys(nativeTokenBalancesByChainId || {})]);
  chainIds.forEach(chainId => {
    if (!tokensByChain[chainId]) {
      tokensByChain[chainId] = [];
    }
    if (allTokens[chainId] && selectedAddress && selectedAddress in allTokens[chainId] && allTokens[chainId][selectedAddress]) {
      allTokens[chainId][selectedAddress].forEach(token => {
        const tokenWithChain = {
          ...token,
          chainId,
          isNative: false
        };
        tokensByChain[chainId].push(tokenWithChain);
      });
    }
    const nativeBalance = nativeTokenBalancesByChainId[chainId];
    if (nativeBalance) {
      const nativeTokenInfo = getNativeTokenInfo(state, chainId);
      tokensByChain[chainId].push({
        ...nativeTokenInfo,
        address: '',
        balance: nativeBalance,
        chainId,
        isNative: true
      });
    }
  });
  return tokensByChain;
}

/**
 * Get the native token balance for a given account address and chainId
 *
 * @param {object} state - Redux state
 * @param {string} accountAddress - The address of the account
 * @param {string} chainId - The chainId of the account
 */
const getNativeTokenCachedBalanceByChainIdSelector = exports.getNativeTokenCachedBalanceByChainIdSelector = (0, _reselect.createSelector)(state => state, (_state, accountAddress) => accountAddress, (state, accountAddress) => getNativeTokenCachedBalanceByChainIdByAccountAddress(state, accountAddress));

/**
 * Get the tokens across chains for a given account address
 *
 * @param {object} state - Redux state
 * @param {string} accountAddress - The address of the account
 */
const getTokensAcrossChainsByAccountAddressSelector = exports.getTokensAcrossChainsByAccountAddressSelector = (0, _reselect.createSelector)(state => state, (_state, accountAddress) => accountAddress, (state, accountAddress) => getTokensAcrossChainsByAccountAddress(state, accountAddress));

/**
 * Get the native token balance for a given account address and chainId
 *
 * @param {object} state - Redux state
 * @param {string} selectedAddress - The address of the selected account
 */
function getNativeTokenCachedBalanceByChainIdByAccountAddress(state, selectedAddress) {
  const {
    accountsByChainId
  } = state.metamask;
  const balancesByChainId = {};
  for (const [chainId, accounts] of Object.entries(accountsByChainId || {})) {
    if (accounts[selectedAddress]) {
      balancesByChainId[chainId] = accounts[selectedAddress].balance;
    }
  }
  return balancesByChainId;
}

/**
 * Get the tokens across chains for a given account address
 *
 * @param {object} state - Redux state
 * @param {string} selectedAddress - The address of the selected account
 */
function getTokensAcrossChainsByAccountAddress(state, selectedAddress) {
  const {
    allTokens
  } = state.metamask;
  const tokensByChain = {};
  const nativeTokenBalancesByChainId = getNativeTokenCachedBalanceByChainIdByAccountAddress(state, selectedAddress);
  const chainIds = new Set([...Object.keys(allTokens || {}), ...Object.keys(nativeTokenBalancesByChainId || {})]);
  chainIds.forEach(chainId => {
    var _allTokens$chainId;
    if (!tokensByChain[chainId]) {
      tokensByChain[chainId] = [];
    }
    if ((_allTokens$chainId = allTokens[chainId]) !== null && _allTokens$chainId !== void 0 && _allTokens$chainId[selectedAddress]) {
      allTokens[chainId][selectedAddress].forEach(token => {
        const tokenWithChain = {
          ...token,
          chainId,
          isNative: false
        };
        tokensByChain[chainId].push(tokenWithChain);
      });
    }
    const nativeBalance = nativeTokenBalancesByChainId[chainId];
    if (nativeBalance) {
      const nativeTokenInfo = getNativeTokenInfo(state, chainId);
      tokensByChain[chainId].push({
        ...nativeTokenInfo,
        address: '',
        balance: nativeBalance,
        chainId,
        isNative: true,
        image: getNativeCurrencyForChain(chainId)
      });
    }
  });
  return tokensByChain;
}

/**
 * Retrieves native token information (symbol, decimals, name) for a given chainId from the state,
 * without hardcoding any values.
 *
 * @param {object} state - Redux state
 * @param {string} chainId - Chain ID
 * @returns {object} Native token information
 */
function getNativeTokenInfo(state, chainId) {
  const {
    networkConfigurationsByChainId
  } = state.metamask;
  const networkConfig = networkConfigurationsByChainId === null || networkConfigurationsByChainId === void 0 ? void 0 : networkConfigurationsByChainId[chainId];

  // Fill native token info by network config (if a user has a network added)
  if (networkConfig) {
    const symbol = networkConfig.nativeCurrency || _transaction.AssetType.native;
    const decimals = 18;
    const name = networkConfig.name || 'Native Token';
    return {
      symbol,
      decimals,
      name
    };
  }

  // Fill native token info by DApp provider
  const {
    provider
  } = state.metamask;
  if ((provider === null || provider === void 0 ? void 0 : provider.chainId) === chainId) {
    var _provider$nativeCurre;
    const symbol = provider.ticker || _transaction.AssetType.native;
    const decimals = ((_provider$nativeCurre = provider.nativeCurrency) === null || _provider$nativeCurre === void 0 ? void 0 : _provider$nativeCurre.decimals) || 18;
    const name = provider.nickname || 'Native Token';
    return {
      symbol,
      decimals,
      name
    };
  }

  // Attempt to retried native token info from hardcoded known networks
  const hardcodedSymbol = _network.CHAIN_ID_TO_CURRENCY_SYMBOL_MAP[chainId];
  const hardcodedName = _network.NETWORK_TO_NAME_MAP[chainId];
  if (hardcodedSymbol && hardcodedName) {
    return {
      symbol: hardcodedSymbol,
      decimals: 18,
      name: hardcodedName
    };
  }

  // Fallback to "NATIVE" symbol as this is an unknown native token
  return {
    symbol: _transaction.AssetType.native,
    decimals: 18,
    name: 'Native Token'
  };
}

/**
 *  @typedef {__import__('./selectors.types').InternalAccountWithBalance} InternalAccountWithBalance
 */

/**
 * Get ordered (by keyrings) accounts with InternalAccount and balance
 *
 * @returns {InternalAccountWithBalance} An array of internal accounts with balance
 */
const getMetaMaskAccountsOrdered = exports.getMetaMaskAccountsOrdered = (0, _util3.createDeepEqualSelector)(getInternalAccountsSortedByKeyring, getMetaMaskAccounts, (internalAccounts, accounts) => {
  return internalAccounts.map(internalAccount => ({
    ...internalAccount,
    ...(internalAccount !== null && internalAccount !== void 0 && internalAccount.address ? accounts[internalAccount.address] || {} : {})
  }));
});
const getMetaMaskAccountsConnected = exports.getMetaMaskAccountsConnected = (0, _reselect.createSelector)(getMetaMaskAccountsOrdered, connectedAccounts => connectedAccounts.map(({
  address
}) => address.toLowerCase()));
function isBalanceCached(state) {
  var _getMetaMaskAccountBa;
  const {
    address: selectedAddress
  } = (0, _accounts.getSelectedInternalAccount)(state);
  const selectedAccountBalance = (_getMetaMaskAccountBa = getMetaMaskAccountBalances(state)) === null || _getMetaMaskAccountBa === void 0 || (_getMetaMaskAccountBa = _getMetaMaskAccountBa[selectedAddress]) === null || _getMetaMaskAccountBa === void 0 ? void 0 : _getMetaMaskAccountBa.balance;
  const cachedBalance = getSelectedAccountCachedBalance(state);
  return Boolean(!selectedAccountBalance && cachedBalance);
}
function getSelectedAccountCachedBalance(state) {
  const cachedBalances = getMetaMaskCachedBalances(state);
  const {
    address: selectedAddress
  } = (0, _accounts.getSelectedInternalAccount)(state);
  return cachedBalances === null || cachedBalances === void 0 ? void 0 : cachedBalances[selectedAddress];
}
function getAllTokens(state) {
  return state.metamask.allTokens;
}

/**
 * Get a flattened list of all ERC-20 tokens owned by the user.
 * Includes all tokens from all chains and accounts.
 *
 * @returns {object[]} All ERC-20 tokens owned by the user in a flat array.
 */
const selectAllTokensFlat = exports.selectAllTokensFlat = (0, _reselect.createSelector)(getAllTokens, tokensByAccountByChain => {
  const tokensByAccountArray = Object.values(tokensByAccountByChain);
  return tokensByAccountArray.reduce((acc, tokensByAccount) => {
    const tokensArray = Object.values(tokensByAccount);
    return acc.concat(...tokensArray);
  }, []);
});

/**
 * Selector to return an origin to network ID map
 *
 * @param state - Redux state object.
 * @returns Object - Installed Snaps.
 */
function getAllDomains(state) {
  return state.metamask.domains;
}
const getSelectedAccount = exports.getSelectedAccount = (0, _util3.createDeepEqualSelector)(getMetaMaskAccounts, _accounts.getSelectedInternalAccount, (accounts, selectedAccount) => {
  // At the time of onboarding there is no selected account
  if (selectedAccount) {
    return {
      ...selectedAccount,
      ...accounts[selectedAccount.address]
    };
  }
  return undefined;
});
const getWatchedToken = transactionMeta => (0, _reselect.createSelector)([getSelectedAccount, getAllTokens], (selectedAccount, detectedTokens) => {
  var _detectedTokens$chain;
  const {
    chainId
  } = transactionMeta;
  const selectedToken = detectedTokens === null || detectedTokens === void 0 || (_detectedTokens$chain = detectedTokens[chainId]) === null || _detectedTokens$chain === void 0 || (_detectedTokens$chain = _detectedTokens$chain[selectedAccount.address]) === null || _detectedTokens$chain === void 0 ? void 0 : _detectedTokens$chain.find(token => (0, _hexstringUtils.toChecksumHexAddress)(token.address) === (0, _hexstringUtils.toChecksumHexAddress)(transactionMeta.txParams.to));
  return selectedToken;
});
exports.getWatchedToken = getWatchedToken;
function getTargetAccount(state, targetAddress) {
  const accounts = getMetaMaskAccounts(state);
  return accounts[targetAddress];
}
const getTokenExchangeRates = exports.getTokenExchangeRates = (0, _reselect.createSelector)(state => (0, _networks.getCurrentChainId)(state), state => state.metamask.marketData, (chainId, marketData) => {
  const contractMarketData = (marketData === null || marketData === void 0 ? void 0 : marketData[chainId]) ?? {};
  return Object.entries(contractMarketData).reduce((acc, [address, tokenData]) => {
    acc[address] = (tokenData === null || tokenData === void 0 ? void 0 : tokenData.price) ?? null;
    return acc;
  }, {});
});
const getCrossChainTokenExchangeRates = state => {
  const contractMarketData = state.metamask.marketData ?? {};
  return Object.keys(contractMarketData).reduce((acc, topLevelKey) => {
    acc[topLevelKey] = Object.keys(contractMarketData[topLevelKey]).reduce((innerAcc, innerKey) => {
      var _contractMarketData$t;
      innerAcc[innerKey] = (_contractMarketData$t = contractMarketData[topLevelKey][innerKey]) === null || _contractMarketData$t === void 0 ? void 0 : _contractMarketData$t.price;
      return innerAcc;
    }, {});
    return acc;
  }, {});
};

/**
 * Get market data for tokens on the current chain
 *
 * @param state
 * @returns {Record<Hex, __import__('@metamask/assets-controllers').MarketDataDetails>}
 */
exports.getCrossChainTokenExchangeRates = getCrossChainTokenExchangeRates;
const getTokensMarketData = state => {
  var _state$metamask$marke;
  const chainId = (0, _networks.getCurrentChainId)(state);
  return (_state$metamask$marke = state.metamask.marketData) === null || _state$metamask$marke === void 0 ? void 0 : _state$metamask$marke[chainId];
};
exports.getTokensMarketData = getTokensMarketData;
const getMarketData = state => {
  return state.metamask.marketData;
};
exports.getMarketData = getMarketData;
function getAddressBook(state) {
  const chainId = (0, _networks.getCurrentChainId)(state);
  if (!state.metamask.addressBook[chainId]) {
    return [];
  }
  return Object.values(state.metamask.addressBook[chainId]);
}
function getCompleteAddressBook(state) {
  const addresses = state.metamask.addressBook;
  const addressWithChainId = Object.entries(addresses).filter(([chainId, _]) => chainId !== '*').map(([chainId, addresse]) => Object.values(addresse).map(address => ({
    ...address,
    chainId
  }))).flat();
  return addressWithChainId;
}
function getEnsResolutionByAddress(state, address) {
  if (state.metamask.ensResolutionsByAddress[address]) {
    const ensResolution = state.metamask.ensResolutionsByAddress[address];
    // ensResolution is a punycode encoded string hence toUnicode is used to decode it from same package
    const normalizedEnsResolution = (0, _punycode.toUnicode)(ensResolution);
    return normalizedEnsResolution;
  }
  const entry = getAddressBookEntry(state, address) || getInternalAccountByAddress(state, address);
  return (entry === null || entry === void 0 ? void 0 : entry.name) || '';
}
function getAddressBookEntry(state, address) {
  const addressBook = getCompleteAddressBook(state);
  const entry = addressBook.find(contact => (0, _stringUtils.isEqualCaseInsensitive)(contact.address, address));
  return entry;
}
function getAddressBookEntryOrAccountName(state, address) {
  const entry = getAddressBookEntry(state, address);
  if (entry && entry.name !== '') {
    return entry.name;
  }
  const internalAccount = Object.values((0, _accounts.getInternalAccounts)(state)).find(account => (0, _stringUtils.isEqualCaseInsensitive)(account.address, address));
  return (internalAccount === null || internalAccount === void 0 ? void 0 : internalAccount.metadata.name) || address;
}
function getAccountName(accounts, accountAddress) {
  const account = accounts.find(internalAccount => (0, _stringUtils.isEqualCaseInsensitive)(internalAccount.address, accountAddress));
  return account && account.metadata.name !== '' ? account.metadata.name : '';
}
function accountsWithSendEtherInfoSelector(state) {
  const accounts = getMetaMaskAccounts(state);
  const internalAccounts = (0, _accounts.getInternalAccounts)(state);
  const accountsWithSendEtherInfo = Object.values(internalAccounts).map(internalAccount => {
    return {
      ...internalAccount,
      ...accounts[internalAccount.address]
    };
  });
  return accountsWithSendEtherInfo;
}
function getAccountsWithLabels(state) {
  return getMetaMaskAccountsOrdered(state).map(account => {
    const {
      address,
      metadata: {
        name
      },
      balance
    } = account;
    return {
      ...account,
      addressLabel: `${name.length < _labels.TRUNCATED_NAME_CHAR_LIMIT ? name : `${name.slice(0, _labels.TRUNCATED_NAME_CHAR_LIMIT - 1)}...`} (${(0, _util2.shortenAddress)(address)})`,
      label: name,
      balance
    };
  });
}
function getCurrentAccountWithSendEtherInfo(state) {
  const {
    address: currentAddress
  } = (0, _accounts.getSelectedInternalAccount)(state);
  const accounts = accountsWithSendEtherInfoSelector(state);
  return (0, _util2.getAccountByAddress)(accounts, currentAddress);
}
function getTargetAccountWithSendEtherInfo(state, targetAddress) {
  const accounts = accountsWithSendEtherInfoSelector(state);
  return (0, _util2.getAccountByAddress)(accounts, targetAddress);
}
function getCurrentEthBalance(state) {
  var _getCurrentAccountWit;
  return (_getCurrentAccountWit = getCurrentAccountWithSendEtherInfo(state)) === null || _getCurrentAccountWit === void 0 ? void 0 : _getCurrentAccountWit.balance;
}
const getNetworkConfigurationIdByChainId = exports.getNetworkConfigurationIdByChainId = (0, _util3.createDeepEqualSelector)(state => state.metamask.networkConfigurationsByChainId, networkConfigurationsByChainId => Object.entries(networkConfigurationsByChainId).reduce((acc, [_chainId, network]) => {
  const selectedRpcEndpoint = network.rpcEndpoints[network.defaultRpcEndpointIndex];
  acc[_chainId] = selectedRpcEndpoint.networkClientId;
  return acc;
}, {}));

/**
 * @type (state: any, chainId: string) => __import__('@metamask/network-controller').NetworkConfiguration
 */
const selectNetworkConfigurationByChainId = exports.selectNetworkConfigurationByChainId = (0, _reselect.createSelector)(_networks.getNetworkConfigurationsByChainId, (_state, chainId) => chainId, (networkConfigurationsByChainId, chainId) => networkConfigurationsByChainId[chainId]);
const selectDefaultRpcEndpointByChainId = exports.selectDefaultRpcEndpointByChainId = (0, _reselect.createSelector)(selectNetworkConfigurationByChainId, networkConfiguration => {
  if (!networkConfiguration) {
    return undefined;
  }
  const {
    defaultRpcEndpointIndex,
    rpcEndpoints
  } = networkConfiguration;
  return rpcEndpoints[defaultRpcEndpointIndex];
});

/**
 * @type (state: RemoteFeatureFlagsState) => boolean
 */
const getIsRpcFailoverEnabled = exports.getIsRpcFailoverEnabled = (0, _reselect.createSelector)(_remoteFeatureFlags.getRemoteFeatureFlags, remoteFeatureFlags => remoteFeatureFlags.walletFrameworkRpcFailoverEnabled ?? false);

/**
 * @type (state: any, chainId: string) => number | undefined
 */
const selectConversionRateByChainId = exports.selectConversionRateByChainId = (0, _reselect.createSelector)(selectNetworkConfigurationByChainId, state => state, (networkConfiguration, state) => {
  var _state$metamask$curre;
  if (!networkConfiguration) {
    return undefined;
  }
  const {
    nativeCurrency
  } = networkConfiguration;
  return (_state$metamask$curre = state.metamask.currencyRates[nativeCurrency]) === null || _state$metamask$curre === void 0 ? void 0 : _state$metamask$curre.conversionRate;
});
const selectNftsByChainId = exports.selectNftsByChainId = (0, _reselect.createSelector)(_accounts.getSelectedInternalAccount, state => state.metamask.allNfts, (_state, chainId) => chainId, (selectedAccount, nfts, chainId) => {
  var _nfts$selectedAccount;
  return (nfts === null || nfts === void 0 || (_nfts$selectedAccount = nfts[selectedAccount.address]) === null || _nfts$selectedAccount === void 0 ? void 0 : _nfts$selectedAccount[chainId]) ?? _shared.EMPTY_ARRAY;
});
const selectNetworkIdentifierByChainId = exports.selectNetworkIdentifierByChainId = (0, _reselect.createSelector)(selectNetworkConfigurationByChainId, selectDefaultRpcEndpointByChainId, (networkConfiguration, defaultRpcEndpoint) => {
  const {
    name: nickname
  } = networkConfiguration ?? {};
  const {
    url: rpcUrl,
    networkClientId
  } = defaultRpcEndpoint ?? {};
  return nickname || rpcUrl || networkClientId;
});
function getRequestingNetworkInfo(state, chainIds) {
  // If chainIds is undefined, set it to an empty array
  let processedChainIds = chainIds === undefined ? [] : chainIds;

  // If chainIds is a string, convert it to an array
  if (typeof processedChainIds === 'string') {
    processedChainIds = [processedChainIds];
  }

  // Ensure chainIds is flattened if it contains nested arrays
  const flattenedChainIds = processedChainIds.flat();

  // Filter the networks to include only those with chainId in flattenedChainIds
  return Object.values((0, _networks.getNetworkConfigurationsByChainId)(state)).filter(network => flattenedChainIds.includes(network.chainId));
}
function getTotalUnapprovedCount(state) {
  return state.metamask.pendingApprovalCount ?? 0;
}
function getSlides(state) {
  return state.metamask.slides || [];
}
function getUnapprovedTxCount(state) {
  const unapprovedTxs = (0, _transactions.getUnapprovedTransactions)(state);
  return Object.keys(unapprovedTxs).length;
}
const getUnapprovedConfirmations = exports.getUnapprovedConfirmations = (0, _util3.createDeepEqualSelector)(state => state.metamask.pendingApprovals || {}, pendingApprovals => Object.values(pendingApprovals));
function getUnapprovedTemplatedConfirmations(state) {
  const unapprovedConfirmations = getUnapprovedConfirmations(state);
  return unapprovedConfirmations.filter(approval => _templates.TEMPLATED_CONFIRMATION_APPROVAL_TYPES.includes(approval.type));
}
function getSuggestedTokens(state) {
  var _getUnapprovedConfirm;
  return ((_getUnapprovedConfirm = getUnapprovedConfirmations(state)) === null || _getUnapprovedConfirm === void 0 ? void 0 : _getUnapprovedConfirm.filter(({
    type,
    requestData
  }) => {
    var _requestData$asset;
    return type === _controllerUtils.ApprovalType.WatchAsset && (requestData === null || requestData === void 0 || (_requestData$asset = requestData.asset) === null || _requestData$asset === void 0 ? void 0 : _requestData$asset.tokenId) === undefined;
  })) || [];
}
function getSuggestedNfts(state) {
  var _getUnapprovedConfirm2;
  return ((_getUnapprovedConfirm2 = getUnapprovedConfirmations(state)) === null || _getUnapprovedConfirm2 === void 0 ? void 0 : _getUnapprovedConfirm2.filter(({
    requestData,
    type
  }) => {
    var _requestData$asset2;
    return type === _controllerUtils.ApprovalType.WatchAsset && (requestData === null || requestData === void 0 || (_requestData$asset2 = requestData.asset) === null || _requestData$asset2 === void 0 ? void 0 : _requestData$asset2.tokenId) !== undefined;
  })) || [];
}
function getIsMainnet(state) {
  const chainId = (0, _networks.getCurrentChainId)(state);
  return chainId === _network.CHAIN_IDS.MAINNET;
}
function getIsLineaMainnet(state) {
  const chainId = (0, _networks.getCurrentChainId)(state);
  return chainId === _network.CHAIN_IDS.LINEA_MAINNET;
}
function getIsTestnet(state) {
  const chainId = (0, _networks.getCurrentChainId)(state);
  return _network.TEST_CHAINS.includes(chainId);
}
function getIsNonStandardEthChain(state) {
  return !(getIsMainnet(state) || getIsTestnet(state) || false);
}
function getPreferences({
  metamask
}) {
  return metamask.preferences ?? {};
}
function getShowTestNetworks(state) {
  const {
    showTestNetworks
  } = getPreferences(state);
  return Boolean(showTestNetworks);
}

/**
 * privacy mode preference
 *
 * @param state
 * @returns {boolean}
 */
function getPrivacyMode(state) {
  const {
    privacyMode
  } = getPreferences(state);
  return Boolean(privacyMode);
}
function getUseExternalNameSources(state) {
  return state.metamask.useExternalNameSources;
}
const getTokenSortConfig = exports.getTokenSortConfig = (0, _util3.createDeepEqualSelector)(getPreferences, ({
  tokenSortConfig
}) => {
  return tokenSortConfig;
});

/**
 * Returns an object indicating which networks
 * tokens should be shown on in the portfolio view.
 */
// @deprecated('Use `getEnabledNetworks` instead')
const getTokenNetworkFilter = exports.getTokenNetworkFilter = (0, _util3.createDeepEqualSelector)(_networks.getCurrentChainId, getPreferences, _networks2.getIsEvmMultichainNetworkSelected, _networks2.getSelectedMultichainNetworkChainId,
/**
 * @param {*} currentChainId - chainId
 * @param {*} preferences - preferences state
 * @param {*} isEvmMultichainNetworkSelected - whether the evm multichain network is selected
 * @param {*} multichainNetworkChainId - the chainId of the multichain network
 * @returns {Record<Hex, boolean>}
 */
(currentChainId, {
  tokenNetworkFilter
}, isEvmMultichainNetworkSelected, multichainNetworkChainId) => {
  if (!isEvmMultichainNetworkSelected) {
    return {
      [multichainNetworkChainId]: true
    };
  }
  // Portfolio view not enabled outside popular networks
  if (!"true" || !_network.FEATURED_NETWORK_CHAIN_IDS.includes(currentChainId)) {
    return {
      [currentChainId]: true
    };
  }
  // Portfolio view only enabled on featured networks
  return Object.entries(tokenNetworkFilter || {}).reduce((acc, [chainId, value]) => {
    if (_network.FEATURED_NETWORK_CHAIN_IDS.includes(chainId)) {
      acc[chainId] = value;
    }
    return acc;
  }, {});
});

// @deprecated('Use `getEnabledNetworks` instead')
function getIsTokenNetworkFilterEqualCurrentNetwork(state) {
  const chainId = (0, _networks.getCurrentChainId)(state);
  const enabledNetworks = (0, _multichain.getEnabledNetworks)(state);
  const tokenNetworkFilter = getTokenNetworkFilter(state);
  const currentMultichainChainId = (0, _networks2.getSelectedMultichainNetworkChainId)(state);
  const {
    namespace
  } = (0, _utils.parseCaipChainId)(currentMultichainChainId);
  const networks = isGlobalNetworkSelectorRemoved ? (enabledNetworks === null || enabledNetworks === void 0 ? void 0 : enabledNetworks[namespace]) ?? {} : tokenNetworkFilter;
  if (Object.keys(networks).length === 1 && Object.keys(networks)[0] === chainId) {
    return true;
  }
  return false;
}
function getUseTransactionSimulations(state) {
  return Boolean(state.metamask.useTransactionSimulations);
}
function getFeatureNotificationsEnabled(state) {
  const {
    featureNotificationsEnabled = false
  } = getPreferences(state);
  return featureNotificationsEnabled;
}
function getShowExtensionInFullSizeView(state) {
  const {
    showExtensionInFullSizeView
  } = getPreferences(state);
  return Boolean(showExtensionInFullSizeView);
}
function getTestNetworkBackgroundColor(state) {
  const currentNetwork = (0, _networks.getProviderConfig)(state).ticker;
  switch (true) {
    case currentNetwork === null || currentNetwork === void 0 ? void 0 : currentNetwork.includes(_network.GOERLI_DISPLAY_NAME):
      return _designSystem.BackgroundColor.goerli;
    case currentNetwork === null || currentNetwork === void 0 ? void 0 : currentNetwork.includes(_network.SEPOLIA_DISPLAY_NAME):
      return _designSystem.BackgroundColor.sepolia;
    default:
      return undefined;
  }
}
function getShouldShowFiat(state, chainId) {
  let currentChainId;
  let conversionRate;
  if (chainId) {
    var _selectNetworkConfigu, _getCurrencyRates;
    currentChainId = chainId;
    // Try known constants before user defined ticker
    const ticker = _network.CHAIN_ID_TO_CURRENCY_SYMBOL_MAP[chainId] ?? _network.CHAIN_ID_TO_CURRENCY_SYMBOL_MAP_NETWORK_COLLISION[chainId] ?? ((_selectNetworkConfigu = selectNetworkConfigurationByChainId(state, chainId)) === null || _selectNetworkConfigu === void 0 ? void 0 : _selectNetworkConfigu.nativeCurrency);
    conversionRate = (_getCurrencyRates = getCurrencyRates(state)) === null || _getCurrencyRates === void 0 || (_getCurrencyRates = _getCurrencyRates[ticker]) === null || _getCurrencyRates === void 0 ? void 0 : _getCurrencyRates.conversionRate;
  } else {
    currentChainId = (0, _networks.getCurrentChainId)(state);
    conversionRate = (0, _metamask.getConversionRate)(state);
  }
  const isTestnet = _network.TEST_NETWORK_IDS.includes(currentChainId);
  const {
    showFiatInTestnets
  } = getPreferences(state);
  const useCurrencyRateCheck = getUseCurrencyRateCheck(state);
  const isConvertibleToFiat = Boolean(useCurrencyRateCheck && conversionRate);
  if (isTestnet) {
    return showFiatInTestnets && isConvertibleToFiat;
  }
  return isConvertibleToFiat;
}
function getShouldHideZeroBalanceTokens(state) {
  const {
    hideZeroBalanceTokens
  } = getPreferences(state);
  return hideZeroBalanceTokens;
}
function getAdvancedInlineGasShown(state) {
  return Boolean(state.metamask.featureFlags.advancedInlineGas);
}

/**
 * @param {string} svgString - The raw SVG string to make embeddable.
 * @returns {string} The embeddable SVG string.
 */
const getEmbeddableSvg = (0, _lodash.memoize)(svgString => `data:image/svg+xml;utf8,${encodeURIComponent(svgString)}`);
function getTargetSubjectMetadata(state, origin) {
  const metadata = getSubjectMetadata(state)[origin];
  if ((metadata === null || metadata === void 0 ? void 0 : metadata.subjectType) === _permissionController.SubjectType.Snap) {
    const {
      svgIcon,
      ...remainingMetadata
    } = metadata;
    return {
      ...remainingMetadata,
      iconUrl: svgIcon ? getEmbeddableSvg(svgIcon) : null
    };
  }
  return metadata;
}

/**
 * Input selector for reusing the same state object.
 * Used in memoized selectors created with createSelector
 * when raw state is needed to be passed to other selectors
 * used to achieve re-usability.
 *
 * @param state - Redux state object.
 * @returns Object - Redux state object.
 */
const rawStateSelector = state => state;

/**
 * Input selector used to retrieve Snaps that are added to Snaps Directory.
 *
 * @param state - Redux state object.
 * @returns Object - Containing verified Snaps from the Directory.
 */
exports.rawStateSelector = rawStateSelector;
const selectVerifiedSnapsRegistry = state => {
  var _state$metamask$datab;
  return (_state$metamask$datab = state.metamask.database) === null || _state$metamask$datab === void 0 ? void 0 : _state$metamask$datab.verifiedSnaps;
};

/**
 * Input selector providing a way to pass a snapId as an argument.
 *
 * @param _state - Redux state object.
 * @param snapId - ID of a Snap.
 * @returns string - ID of a Snap that can be used as input selector.
 */
const selectSnapId = (_state, snapId) => snapId;

/**
 * Input selector for retrieving all installed Snaps.
 *
 * @param state - Redux state object.
 * @returns Object - Installed Snaps.
 */
const selectInstalledSnaps = state => state.metamask.snaps;

/**
 * Retrieve registry data for requested Snap.
 *
 * @param state - Redux state object.
 * @param snapId - ID of a Snap.
 * @returns Object containing metadata stored in Snaps registry for requested Snap.
 */
exports.selectInstalledSnaps = selectInstalledSnaps;
const getSnapRegistryData = exports.getSnapRegistryData = (0, _reselect.createSelector)([selectVerifiedSnapsRegistry, selectSnapId], (snapsRegistryData, snapId) => {
  return snapsRegistryData ? snapsRegistryData[snapId] : null;
});

/**
 * Find and return Snap's latest version available in registry.
 *
 * @param state - Redux state object.
 * @param snapId - ID of a Snap.
 * @returns String SemVer version.
 */
const getSnapLatestVersion = exports.getSnapLatestVersion = (0, _reselect.createSelector)([getSnapRegistryData], snapRegistryData => {
  if (!snapRegistryData) {
    return null;
  }
  return Object.keys(snapRegistryData.versions).reduce((latest, version) => {
    return _semver.default.gt(version, latest) ? version : latest;
  }, '0.0.0');
});

/**
 * Return a Map of all installed Snaps with available update status.
 *
 * @param state - Redux state object.
 * @returns Map Snap IDs mapped to a boolean value (true if update is available, false otherwise).
 */
const getAllSnapAvailableUpdates = exports.getAllSnapAvailableUpdates = (0, _reselect.createSelector)([selectInstalledSnaps, rawStateSelector], (installedSnaps, state) => {
  const snapMap = new Map();
  Object.keys(installedSnaps).forEach(snapId => {
    const latestVersion = getSnapLatestVersion(state, snapId);
    snapMap.set(snapId, latestVersion ? _semver.default.gt(latestVersion, installedSnaps[snapId].version) : false);
  });
  return snapMap;
});

/**
 * Return status of Snaps update availability for any installed Snap.
 *
 * @param state - Redux state object.
 * @returns boolean true if update is available, false otherwise.
 */
const getAnySnapUpdateAvailable = exports.getAnySnapUpdateAvailable = (0, _reselect.createSelector)([getAllSnapAvailableUpdates], snapMap => {
  return [...snapMap.values()].some(value => value === true);
});

/**
 * Return if the snap branding should show in the UI.
 */
const getHideSnapBranding = exports.getHideSnapBranding = (0, _util3.createDeepEqualSelector)([selectInstalledSnaps, selectSnapId], (installedSnaps, snapId) => {
  var _installedSnaps$snapI;
  return (_installedSnaps$snapI = installedSnaps[snapId]) === null || _installedSnaps$snapI === void 0 ? void 0 : _installedSnaps$snapI.hideSnapBranding;
});

/**
 * Get a memoized version of the target subject metadata.
 */
const getMemoizedTargetSubjectMetadata = exports.getMemoizedTargetSubjectMetadata = (0, _util3.createDeepEqualSelector)(getTargetSubjectMetadata, interfaces => interfaces);

/**
 * Get a memoized version of the unapproved confirmations.
 */
const getMemoizedUnapprovedConfirmations = exports.getMemoizedUnapprovedConfirmations = (0, _util3.createDeepEqualSelector)(getUnapprovedConfirmations, confirmations => confirmations);

/**
 * Get a memoized version of the unapproved templated confirmations.
 */
const getMemoizedUnapprovedTemplatedConfirmations = exports.getMemoizedUnapprovedTemplatedConfirmations = (0, _util3.createDeepEqualSelector)(getUnapprovedTemplatedConfirmations, confirmations => confirmations);

/**
 * Get the Snap interfaces from the redux state.
 *
 * @param state - Redux state object.
 * @returns the Snap interfaces.
 */
const getInterfaces = state => state.metamask.interfaces;

/**
 * Input selector providing a way to pass a Snap interface ID as an argument.
 *
 * @param _state - Redux state object.
 * @param interfaceId - ID of a Snap interface.
 * @returns ID of a Snap Interface that can be used as input selector.
 */
const selectInterfaceId = (_state, interfaceId) => interfaceId;

/**
 * Get a memoized version of the Snap interfaces.
 */
const getMemoizedInterfaces = exports.getMemoizedInterfaces = (0, _util3.createDeepEqualSelector)(getInterfaces, interfaces => interfaces);

/**
 * Get a Snap Interface with a given ID.
 */
const getInterface = exports.getInterface = (0, _reselect.createSelector)([getMemoizedInterfaces, selectInterfaceId], (interfaces, id) => interfaces[id]);

/**
 * Get a memoized version of a Snap interface with a given ID
 */
const getMemoizedInterface = exports.getMemoizedInterface = (0, _util3.createDeepEqualSelector)(getInterface, snapInterface => snapInterface);

/**
 * Get the content from a Snap interface with a given ID.
 */
const getInterfaceContent = exports.getInterfaceContent = (0, _reselect.createSelector)([getMemoizedInterfaces, selectInterfaceId], (interfaces, id) => {
  var _interfaces$id;
  return (_interfaces$id = interfaces[id]) === null || _interfaces$id === void 0 ? void 0 : _interfaces$id.content;
});

/**
 * Get a memoized version of the content from a Snap interface with a given ID.
 */
const getMemoizedInterfaceContent = exports.getMemoizedInterfaceContent = (0, _util3.createDeepEqualSelector)(getInterfaceContent, content => content);

/**
 * Input selector providing a way to pass the origins as an argument.
 *
 * @param _state - Redux state object.
 * @param origins - Object containing origins.
 * @returns object - Object with keys that can be used as input selector.
 */
const selectOrigins = (_state, origins) => origins;

/**
 * Retrieve metadata for multiple subjects (origins).
 *
 * @param state - Redux state object.
 * @param origins - Object containing keys that represent subject's identification.
 * @returns Key:value object containing metadata attached to each subject key.
 */
const getMultipleTargetsSubjectMetadata = exports.getMultipleTargetsSubjectMetadata = (0, _util3.createDeepEqualSelector)([rawStateSelector, selectOrigins], (state, origins) => {
  return Object.keys(origins ?? {}).reduce((originsMetadata, origin) => {
    originsMetadata[origin] = getTargetSubjectMetadata(state, origin);
    return originsMetadata;
  }, {});
});
function getRpcPrefsForCurrentProvider(state) {
  const {
    rpcPrefs
  } = (0, _networks.getProviderConfig)(state);
  return rpcPrefs;
}
function getKnownMethodData(state, data) {
  const {
    knownMethodData,
    use4ByteResolution
  } = state.metamask;
  if (!use4ByteResolution || !(0, _transaction2.hasTransactionData)(data)) {
    return null;
  }
  const prefixedData = (0, _util.addHexPrefix)(data);
  const fourBytePrefix = prefixedData.slice(0, 10);
  if (fourBytePrefix.length < 10) {
    return null;
  }
  return (knownMethodData === null || knownMethodData === void 0 ? void 0 : knownMethodData[fourBytePrefix]) ?? null;
}
function getFeatureFlags(state) {
  return state.metamask.featureFlags;
}
function getOriginOfCurrentTab(state) {
  return state.activeTab.origin;
}
function getDefaultHomeActiveTabName(state) {
  return state.metamask.defaultHomeActiveTabName;
}
function getIpfsGateway(state) {
  return state.metamask.ipfsGateway;
}
function getUseExternalServices(state) {
  return state.metamask.useExternalServices;
}
function getUSDConversionRate(state) {
  var _state$metamask$curre2;
  return (_state$metamask$curre2 = state.metamask.currencyRates[(0, _networks.getProviderConfig)(state).ticker]) === null || _state$metamask$curre2 === void 0 ? void 0 : _state$metamask$curre2.usdConversionRate;
}
const getUSDConversionRateByChainId = chainId => (0, _reselect.createSelector)(getCurrencyRates, state => selectNetworkConfigurationByChainId(state, chainId), (currencyRates, networkConfiguration) => {
  var _currencyRates$native;
  if (!networkConfiguration) {
    return undefined;
  }
  const {
    nativeCurrency
  } = networkConfiguration;
  return (_currencyRates$native = currencyRates[nativeCurrency]) === null || _currencyRates$native === void 0 ? void 0 : _currencyRates$native.usdConversionRate;
});
exports.getUSDConversionRateByChainId = getUSDConversionRateByChainId;
function getCurrencyRates(state) {
  return state.metamask.currencyRates;
}
function getWeb3ShimUsageStateForOrigin(state, origin) {
  return state.metamask.web3ShimUsageOrigins[origin];
}

/**
 * @typedef {object} SwapsEthToken
 * @property {string} symbol - The symbol for ETH, namely "ETH"
 * @property {string} name - The name of the ETH currency, "Ether"
 * @property {string} address - A substitute address for the metaswap-api to
 * recognize the ETH token
 * @property {string} chainId - The chainId of the ETH token
 * @property {string} decimals - The number of ETH decimals, i.e. 18
 * @property {string} balance - The user's ETH balance in decimal wei, with a
 * precision of 4 decimal places
 * @property {string} string - The user's ETH balance in decimal ETH
 */

/**
 * Swaps related code uses token objects for various purposes. These objects
 * always have the following properties: `symbol`, `name`, `address`, and
 * `decimals`.
 *
 * When available for the current account, the objects can have `balance` and
 * `string` properties.
 * `balance` is the users token balance in decimal values, denominated in the
 * minimal token units (according to its decimals).
 * `string` is the token balance in a readable format, ready for rendering.
 *
 * Swaps treats the selected chain's currency as a token, and we use the token constants
 * in the SWAPS_CHAINID_DEFAULT_TOKEN_MAP to set the standard properties for
 * the token. The getSwapsDefaultToken selector extends that object with
 * `balance` and `string` values of the same type as in regular ERC-20 token
 * objects, per the above description.
 *
 * @deprecated Use getNativeAssetForChainId instead because this only supports EVM chains
 * @param {object} state - the redux state object
 * @param {string} overrideChainId - the chainId to override the current chainId
 * @returns {SwapsEthToken} The token object representation of the currently
 * selected account's ETH balance, as expected by the Swaps API.
 */

function getSwapsDefaultToken(state, overrideChainId = null) {
  const selectedAccount = getSelectedAccount(state);
  const balance = selectedAccount === null || selectedAccount === void 0 ? void 0 : selectedAccount.balance;
  const currentChainId = (0, _networks.getCurrentChainId)(state);
  const chainId = overrideChainId ?? currentChainId;
  const defaultTokenObject = _swaps.SWAPS_CHAINID_DEFAULT_TOKEN_MAP[chainId];
  return {
    ...defaultTokenObject,
    chainId,
    balance: (0, _conversion.hexToDecimal)(balance),
    string: (0, _conversion.getValueFromWeiHex)({
      value: balance,
      numberOfDecimals: 4,
      toDenomination: 'ETH'
    })
  };
}

/**
 * @deprecated Check if chainId is in ALLOWED_BRIDGE_CHAIN_IDS constant instead
 * @param state - The Redux state
 * @param {string} [overrideChainId] - (Optional) The chainId to check
 * @returns {boolean} Whether the chainId is a swaps chain
 */
function getIsSwapsChain(state, overrideChainId) {
  const currentChainId = (0, _networks.getCurrentChainId)(state);
  const chainId = overrideChainId ?? currentChainId;
  const isDevelopment = "development" === 'development' || "development" === 'testing';
  return isDevelopment ? _swaps.ALLOWED_DEV_SWAPS_CHAIN_IDS.includes(chainId) : _swaps.ALLOWED_PROD_SWAPS_CHAIN_IDS.includes(chainId);
}

/**
 * @deprecated Check if chainId is in ALLOWED_BRIDGE_CHAIN_IDS constant instead
 * @param state - The Redux state
 * @param overrideChainId - The chainId to check
 * @returns {boolean} Whether the chainId is a bridge chain
 */
function getIsBridgeChain(state, overrideChainId) {
  const account = (0, _accounts.getSelectedInternalAccount)(state);
  const {
    chainId: selectedMultiChainId,
    isEvmNetwork
  } = (0, _multichain2.getMultichainNetwork)(state, account);
  let currentChainId = selectedMultiChainId;

  // While we do not support the multichain network on EVM chains (ex: mainnet is epi155:1), use the old chainId
  if (isEvmNetwork) {
    currentChainId = (0, _networks.getCurrentChainId)(state);
  }
  const chainId = overrideChainId ?? currentChainId;
  return _bridge.ALLOWED_BRIDGE_CHAIN_IDS.includes(chainId);
}
const getBridgeFeatureFlags = (0, _util3.createDeepEqualSelector)([state => (0, _remoteFeatureFlags.getRemoteFeatureFlags)(state).bridgeConfig], bridgeConfig => {
  const validatedFlags = (0, _bridgeController.selectBridgeFeatureFlags)({
    remoteFeatureFlags: {
      bridgeConfig
    }
  });
  return validatedFlags;
});
const getIsBridgeEnabled = exports.getIsBridgeEnabled = (0, _reselect.createSelector)([getBridgeFeatureFlags, getUseExternalServices], (bridgeFeatureFlags, shouldUseExternalServices) => {
  return (shouldUseExternalServices && (bridgeFeatureFlags === null || bridgeFeatureFlags === void 0 ? void 0 : bridgeFeatureFlags.support)) ?? false;
});
function getNativeCurrencyImage(state) {
  const chainId = (0, _networks.getCurrentChainId)(state);
  return _network.CHAIN_ID_TOKEN_IMAGE_MAP[chainId];
}
function getNativeCurrencyForChain(chainId) {
  return _network.CHAIN_ID_TOKEN_IMAGE_MAP[chainId] ?? undefined;
}

/**
 * Returns a memoized selector that gets the internal accounts from the Redux store.
 *
 * @param state - The Redux store state.
 * @returns {Array} An array of internal accounts.
 */
const getMemoizedMetaMaskInternalAccounts = exports.getMemoizedMetaMaskInternalAccounts = (0, _util3.createDeepEqualSelector)(_accounts.getInternalAccounts, internalAccounts => internalAccounts);
const selectERC20TokensByChain = exports.selectERC20TokensByChain = (0, _util3.createDeepEqualSelector)(state => state.metamask.tokensChainsCache, erc20TokensByChain => erc20TokensByChain);
const selectERC20Tokens = exports.selectERC20Tokens = (0, _util3.createDeepEqualSelector)(_networks.getCurrentChainId, state => state.metamask.tokensChainsCache, (chainId, erc20Tokens) => {
  var _erc20Tokens$chainId;
  return (erc20Tokens === null || erc20Tokens === void 0 || (_erc20Tokens$chainId = erc20Tokens[chainId]) === null || _erc20Tokens$chainId === void 0 ? void 0 : _erc20Tokens$chainId.data) || {};
});

/**
 * To retrieve the token list for use throughout the UI. Will return the remotely fetched list
 * from the tokens controller if token detection is enabled, or the static list if not.
 *
 * @type {() => object}
 */
const getTokenList = exports.getTokenList = (0, _reselect.createSelector)(selectERC20Tokens, getIsTokenDetectionInactiveOnMainnet, (remoteTokenList, isTokenDetectionInactiveOnMainnet) => {
  return isTokenDetectionInactiveOnMainnet ? _tokens.STATIC_MAINNET_TOKEN_LIST : remoteTokenList;
});
const getMemoizedMetadataContract = exports.getMemoizedMetadataContract = (0, _reselect.createSelector)((state, _address) => getTokenList(state), (_state, address) => address, (tokenList, address) => tokenList[address === null || address === void 0 ? void 0 : address.toLowerCase()]);

/**
 * @type (state: any, address: string) => string
 */
const getMetadataContractName = exports.getMetadataContractName = (0, _reselect.createSelector)(getMemoizedMetadataContract, entry => (entry === null || entry === void 0 ? void 0 : entry.name) ?? '');
const getTxData = state => state.confirmTransaction.txData;
exports.getTxData = getTxData;
const getUnapprovedTransaction = exports.getUnapprovedTransaction = (0, _util3.createDeepEqualSelector)(state => (0, _transactions.getUnapprovedTransactions)(state), (_, transactionId) => transactionId, (unapprovedTxs, transactionId) => Object.values(unapprovedTxs).find(({
  id
}) => id === transactionId));
const getTransaction = exports.getTransaction = (0, _util3.createDeepEqualSelector)(state => (0, _transactions.getCurrentNetworkTransactions)(state), (_, transactionId) => transactionId, (unapprovedTxs, transactionId) => {
  return Object.values(unapprovedTxs).find(({
    id
  }) => id === transactionId) || {};
});
const getFullTxData = exports.getFullTxData = (0, _util3.createDeepEqualSelector)(getTxData, (state, transactionId, status) => {
  if (status === _transactionController.TransactionStatus.unapproved) {
    return getUnapprovedTransaction(state, transactionId) ?? {};
  }
  return getTransaction(state, transactionId);
}, (_state, _transactionId, _status, customTxParamsData, hexTransactionAmount) => ({
  customTxParamsData,
  hexTransactionAmount
}), (txData, transaction, {
  customTxParamsData,
  hexTransactionAmount
}) => {
  let fullTxData = {
    ...txData,
    ...transaction
  };
  if (transaction && transaction.simulationFails) {
    fullTxData.simulationFails = {
      ...transaction.simulationFails
    };
  }
  if (customTxParamsData) {
    fullTxData = {
      ...fullTxData,
      txParams: {
        ...fullTxData.txParams,
        data: customTxParamsData
      }
    };
  }
  if (hexTransactionAmount) {
    fullTxData = {
      ...fullTxData,
      txParams: {
        ...fullTxData.txParams,
        value: hexTransactionAmount
      }
    };
  }
  return fullTxData;
});

/**
 *  @typedef {__import__('./selectors.types').AccountConnections} AccountConnections
 */

/**
 * Retrieves the connected subjects for all addresses.
 *
 * @returns {AccountConnections}  The connected subjects for all addresses.
 */
const getConnectedSubjectsForAllAddresses = exports.getConnectedSubjectsForAllAddresses = (0, _util3.createDeepEqualSelector)(getPermissionSubjects, getSubjectMetadata, (subjects, subjectMetadata) => {
  const accountsToConnections = {};
  Object.entries(subjects).forEach(([subjectKey, subjectValue]) => {
    const exposedAccounts = getAccountsFromSubject(subjectValue);
    exposedAccounts.forEach(address => {
      if (!accountsToConnections[address]) {
        accountsToConnections[address] = [];
      }
      const metadata = subjectMetadata[subjectKey];
      accountsToConnections[address].push({
        origin: subjectKey,
        ...metadata
      });
    });
  });
  return accountsToConnections;
});
const getAllConnectedAccounts = exports.getAllConnectedAccounts = (0, _util3.createDeepEqualSelector)(getConnectedSubjectsForAllAddresses, connectedSubjects => {
  return Object.keys(connectedSubjects);
});
const getConnectedSitesList = exports.getConnectedSitesList = (0, _util3.createDeepEqualSelector)(getConnectedSubjectsForAllAddresses, _accounts.getInternalAccounts, getAllConnectedAccounts, (connectedSubjectsForAllAddresses, internalAccounts, connectedAddresses) => {
  const sitesList = {};
  connectedAddresses.forEach(connectedAddress => {
    connectedSubjectsForAllAddresses[connectedAddress].forEach(app => {
      const siteKey = app.origin;
      const internalAccount = internalAccounts.find(account => (0, _stringUtils.isEqualCaseInsensitive)(account.address, connectedAddress));
      if (sitesList[siteKey]) {
        sitesList[siteKey].addresses.push(connectedAddress);
        sitesList[siteKey].addressToNameMap[connectedAddress] = (internalAccount === null || internalAccount === void 0 ? void 0 : internalAccount.metadata.name) || ''; // Map address to name
      } else {
        sitesList[siteKey] = {
          ...app,
          addresses: [connectedAddress],
          addressToNameMap: {
            [connectedAddress]: (internalAccount === null || internalAccount === void 0 ? void 0 : internalAccount.metadata.name) || ''
          }
        };
      }
    });
  });
  return sitesList;
});
const getMemoizedCurrentChainId = exports.getMemoizedCurrentChainId = (0, _util3.createDeepEqualSelector)(_networks.getCurrentChainId, chainId => chainId);
function getSnaps(state) {
  return state.metamask.snaps;
}
function getLocale(state) {
  return state.metamask.currentLocale;
}
const getSnap = exports.getSnap = (0, _util3.createDeepEqualSelector)(getSnaps, (_, snapId) => snapId, (snaps, snapId) => {
  return snaps[snapId];
});

/**
 * Get a selector that returns all Snaps metadata (name and description) for all Snaps.
 *
 * @param {object} state - The Redux state object.
 * @returns {object} An object mapping all installed snaps to their metadata, which contains the snap name and description.
 */
const getSnapsMetadata = exports.getSnapsMetadata = (0, _util3.createDeepEqualSelector)(getLocale, getSnaps, (locale, snaps) => {
  return Object.values(snaps).reduce((snapsMetadata, snap) => {
    const snapId = snap.id;
    const manifest = snap.localizationFiles ? (0, _snapsUtils.getLocalizedSnapManifest)(snap.manifest, locale, snap.localizationFiles) : snap.manifest;
    snapsMetadata[snapId] = {
      name: manifest.proposedName,
      description: manifest.description,
      hidden: snap.hidden
    };
    return snapsMetadata;
  }, {});
});

/**
 * Get a selector that returns the snap metadata (name and description) for a
 * given `snapId`.
 *
 * @param {object} state - The Redux state object.
 * @param {string} snapId - The snap ID to get the metadata for.
 * @returns {object} An object containing the snap name and description.
 */
const getSnapMetadata = exports.getSnapMetadata = (0, _util3.createDeepEqualSelector)(getSnapsMetadata, (_, snapId) => snapId, (metadata, snapId) => {
  return metadata[snapId] ?? {
    name: snapId ? (0, _snapsUtils.stripSnapPrefix)(snapId) : null
  };
});
const getEnabledSnaps = exports.getEnabledSnaps = (0, _util3.createDeepEqualSelector)(getSnaps, snaps => {
  return Object.values(snaps).reduce((acc, cur) => {
    if (cur.enabled) {
      acc[cur.id] = cur;
    }
    return acc;
  }, {});
});
const getPreinstalledSnaps = exports.getPreinstalledSnaps = (0, _util3.createDeepEqualSelector)(getSnaps, snaps => {
  return Object.values(snaps).reduce((acc, snap) => {
    if (snap.preinstalled) {
      acc[snap.id] = snap;
    }
    return acc;
  }, {});
});
const getInsightSnaps = exports.getInsightSnaps = (0, _util3.createDeepEqualSelector)(getEnabledSnaps, getPermissionSubjects, (snaps, subjects) => {
  return Object.values(snaps).filter(({
    id
  }) => {
    var _subjects$id;
    return (_subjects$id = subjects[id]) === null || _subjects$id === void 0 ? void 0 : _subjects$id.permissions['endowment:transaction-insight'];
  });
});
const getSettingsPageSnaps = exports.getSettingsPageSnaps = (0, _util3.createDeepEqualSelector)(getEnabledSnaps, getPermissionSubjects, (snaps, subjects) => {
  return Object.values(snaps).filter(({
    id,
    preinstalled
  }) => {
    var _subjects$id2;
    return ((_subjects$id2 = subjects[id]) === null || _subjects$id2 === void 0 ? void 0 : _subjects$id2.permissions[_snapsRpcMethods.SnapEndowments.SettingsPage]) && preinstalled && !(0, _snaps.isSnapIgnoredInProd)(id);
  });
});
const getSignatureInsightSnaps = exports.getSignatureInsightSnaps = (0, _util3.createDeepEqualSelector)(getEnabledSnaps, getPermissionSubjects, (snaps, subjects) => {
  return Object.values(snaps).filter(({
    id
  }) => {
    var _subjects$id3;
    return (_subjects$id3 = subjects[id]) === null || _subjects$id3 === void 0 ? void 0 : _subjects$id3.permissions['endowment:signature-insight'];
  });
});
const getSignatureInsightSnapIds = exports.getSignatureInsightSnapIds = (0, _util3.createDeepEqualSelector)(getSignatureInsightSnaps, snaps => snaps.map(snap => snap.id));
const getInsightSnapIds = exports.getInsightSnapIds = (0, _util3.createDeepEqualSelector)(getInsightSnaps, snaps => snaps.map(snap => snap.id));
const getNameLookupSnapsIds = exports.getNameLookupSnapsIds = (0, _util3.createDeepEqualSelector)(getEnabledSnaps, getPermissionSubjects, (snaps, subjects) => {
  return Object.values(snaps).filter(({
    id
  }) => {
    var _subjects$id4;
    return (_subjects$id4 = subjects[id]) === null || _subjects$id4 === void 0 ? void 0 : _subjects$id4.permissions['endowment:name-lookup'];
  }).map(snap => snap.id);
});
const getNameLookupSnaps = exports.getNameLookupSnaps = (0, _util3.createDeepEqualSelector)(getEnabledSnaps, getPermissionSubjects, (snaps, subjects) => {
  return Object.values(snaps).filter(({
    id
  }) => {
    var _subjects$id5;
    return (_subjects$id5 = subjects[id]) === null || _subjects$id5 === void 0 ? void 0 : _subjects$id5.permissions['endowment:name-lookup'];
  }).map(snap => {
    var _subjects$snap$id;
    return {
      id: snap.id,
      permission: (_subjects$snap$id = subjects[snap.id]) === null || _subjects$snap$id === void 0 ? void 0 : _subjects$snap$id.permissions['endowment:name-lookup']
    };
  });
});
const getSettingsPageSnapsIds = exports.getSettingsPageSnapsIds = (0, _util3.createDeepEqualSelector)(getSettingsPageSnaps, snaps => snaps.map(snap => snap.id));
const getNotifySnaps = exports.getNotifySnaps = (0, _util3.createDeepEqualSelector)(getEnabledSnaps, getPermissionSubjects, (snaps, subjects) => {
  return Object.values(snaps).filter(({
    id
  }) => {
    var _subjects$id6;
    return (_subjects$id6 = subjects[id]) === null || _subjects$id6 === void 0 ? void 0 : _subjects$id6.permissions.snap_notify;
  });
});
/**
 * Get non-preinstalled snaps that have the snap_notify permission.
 *
 * @param {object} state - The Redux state object.
 * @returns {object[]} An array of notify snaps that are not preinstalled.
 */
const getThirdPartyNotifySnaps = exports.getThirdPartyNotifySnaps = (0, _util3.createDeepEqualSelector)(getNotifySnaps, snaps => snaps.filter(snap => !snap.preinstalled));
function getAllSnapInsights(state) {
  return state.metamask.insights;
}
const getSnapInsights = exports.getSnapInsights = (0, _util3.createDeepEqualSelector)(getAllSnapInsights, (_, id) => id, (insights, id) => insights === null || insights === void 0 ? void 0 : insights[id]);

/**
 * Get an object of announcement IDs and if they are allowed or not.
 *
 * @returns {object}
 */
function getAllowedAnnouncementIds() {
  return {};
}

/**
 * @typedef {object} Announcement
 * @property {number} id - A unique identifier for the announcement
 * @property {string} date - A date in YYYY-MM-DD format, identifying when the notification was first committed
 */

/**
 * Announcements are managed by the announcement controller and referenced by
 * `state.metamask.announcements`. This function returns a list of announcements
 * the can be shown to the user. This list includes all announcements that do not
 * have a truthy `isShown` property.
 *
 * The returned announcements are sorted by date.
 *
 * @param {object} state - the redux state object
 * @returns {Announcement[]} An array of announcements that can be shown to the user
 */

function getSortedAnnouncementsToShow(state) {
  const announcements = Object.values(state.metamask.announcements);
  const allowedAnnouncementIds = getAllowedAnnouncementIds(state);
  const announcementsToShow = announcements.filter(announcement => !announcement.isShown && allowedAnnouncementIds[announcement.id]);
  const announcementsSortedByDate = announcementsToShow.sort((a, b) => new Date(b.date) - new Date(a.date));
  return announcementsSortedByDate;
}

/**
 * @param state
 * @returns {{networkId: string}[]}
 */
function getOrderedNetworksList(state) {
  return state.metamask.orderedNetworkList;
}
function getPinnedAccountsList(state) {
  return state.metamask.pinnedAccountList;
}
function getHiddenAccountsList(state) {
  return state.metamask.hiddenAccountList;
}
function getShowRecoveryPhraseReminder(state) {
  const {
    recoveryPhraseReminderLastShown,
    recoveryPhraseReminderHasBeenShown
  } = state.metamask;
  const currentTime = new Date().getTime();
  const frequency = recoveryPhraseReminderHasBeenShown ? _time.DAY * 90 : _time.DAY * 2;
  return currentTime - recoveryPhraseReminderLastShown >= frequency;
}

/**
 * Retrieves the number of unapproved transactions and messages
 *
 * @param state - Redux state object.
 * @returns Number of unapproved transactions
 */
function getNumberOfAllUnapprovedTransactionsAndMessages(state) {
  const unapprovedTxs = (0, _transactions.getAllUnapprovedTransactions)(state);
  const allUnapprovedMessages = {
    ...unapprovedTxs,
    ...state.metamask.unapprovedDecryptMsgs,
    ...state.metamask.unapprovedPersonalMsgs,
    ...state.metamask.unapprovedEncryptionPublicKeyMsgs,
    ...state.metamask.unapprovedTypedMessages
  };
  const numUnapprovedMessages = Object.keys(allUnapprovedMessages).length;
  return numUnapprovedMessages;
}
const getCurrentNetwork = exports.getCurrentNetwork = (0, _util3.createDeepEqualSelector)(_networks.getNetworkConfigurationsByChainId, _networks.getCurrentChainId,
/**
 * Get the current network configuration.
 *
 * @param networkConfigurationsByChainId
 * @param currentChainId
 * @returns {{
 *   chainId: `0x${string}`;
 *   id?: string;
 *   nickname?: string;
 *   providerType?: string;
 *   rpcPrefs?: { blockExplorerUrl?: string; imageUrl?: string; };
 *   rpcUrl: string;
 *   ticker: string;
 * }} networkConfiguration - Configuration for the current network.
 */
(networkConfigurationsByChainId, currentChainId) => {
  var _currentNetwork$block;
  const currentNetwork = networkConfigurationsByChainId[currentChainId];
  const rpcEndpoint = currentNetwork.rpcEndpoints[currentNetwork.defaultRpcEndpointIndex];
  const blockExplorerUrl = (_currentNetwork$block = currentNetwork.blockExplorerUrls) === null || _currentNetwork$block === void 0 ? void 0 : _currentNetwork$block[currentNetwork.defaultBlockExplorerUrlIndex];
  return {
    chainId: currentNetwork.chainId,
    id: rpcEndpoint.networkClientId,
    nickname: currentNetwork.name,
    rpcUrl: rpcEndpoint.url,
    ticker: currentNetwork.nativeCurrency,
    blockExplorerUrl,
    rpcPrefs: {
      blockExplorerUrl,
      imageUrl: _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[currentNetwork.chainId]
    },
    ...(rpcEndpoint.type === _networkController.RpcEndpointType.Infura && {
      providerType: rpcEndpoint.networkClientId
    })
  };
});
const getSelectedNetwork = exports.getSelectedNetwork = (0, _util3.createDeepEqualSelector)(_networks.getSelectedNetworkClientId, _networks.getNetworkConfigurationsByChainId, (selectedNetworkClientId, networkConfigurationsByChainId) => {
  if (selectedNetworkClientId === undefined) {
    throw new Error('No network is selected');
  }

  // TODO: Add `networkConfigurationsByNetworkClientId` to NetworkController state so this is easier to do
  const possibleNetworkConfiguration = Object.values(networkConfigurationsByChainId).find(networkConfiguration => {
    return networkConfiguration.rpcEndpoints.some(rpcEndpoint => {
      return rpcEndpoint.networkClientId === selectedNetworkClientId;
    });
  });
  if (possibleNetworkConfiguration === undefined) {
    throw new Error('Could not find network configuration for selected network client');
  }
  return {
    configuration: possibleNetworkConfiguration,
    clientId: selectedNetworkClientId
  };
});
const getConnectedSitesListWithNetworkInfo = exports.getConnectedSitesListWithNetworkInfo = (0, _util3.createDeepEqualSelector)(getConnectedSitesList, getAllDomains, _networks.getNetworkConfigurationsByChainId, getCurrentNetwork, (sitesList, domains, networks, currentNetwork) => {
  Object.keys(sitesList).forEach(siteKey => {
    const connectedNetwork = Object.values(networks).find(network => network.rpcEndpoints.some(rpcEndpoint => rpcEndpoint.networkClientId === domains[siteKey]));

    // For the testnets, if we do not have an image, we will have a fallback string
    sitesList[siteKey].networkIconUrl = _network.CHAIN_ID_TO_NETWORK_IMAGE_URL_MAP[connectedNetwork === null || connectedNetwork === void 0 ? void 0 : connectedNetwork.chainId] || '';
    sitesList[siteKey].networkName = (connectedNetwork === null || connectedNetwork === void 0 ? void 0 : connectedNetwork.name) || (currentNetwork === null || currentNetwork === void 0 ? void 0 : currentNetwork.nickname) || '';
  });
  return sitesList;
});

/**
 * Returns the network client ID of the network that should be auto-switched to
 * based on the current tab origin and its last network connected to
 *
 * @param state - Redux state object.
 * @returns Network ID to switch to
 */
function getNetworkToAutomaticallySwitchTo(state) {
  const numberOfUnapprovedTx = getNumberOfAllUnapprovedTransactionsAndMessages(state);

  // This block autoswitches chains based on the last chain used
  // for a given dapp, when there are no pending confimrations
  // This allows the user to be connected on one chain
  // for one dapp, and automatically change for another
  const selectedTabOrigin = getOriginOfCurrentTab(state);
  if ((0, _util.getEnvironmentType)() === _app2.ENVIRONMENT_TYPE_POPUP && (0, _metamask.getIsUnlocked)(state) && selectedTabOrigin && numberOfUnapprovedTx === 0) {
    const domainNetworks = getAllDomains(state);
    const networkIdForThisDomain = domainNetworks[selectedTabOrigin];
    const currentNetwork = getCurrentNetwork(state);

    // If we have a match, "silently" switch networks if the network differs
    // from the current network
    if (networkIdForThisDomain && currentNetwork.id !== networkIdForThisDomain) {
      return networkIdForThisDomain;
    }
  }
  return null;
}
function getShowTermsOfUse(state) {
  const {
    termsOfUseLastAgreed
  } = state.metamask;
  if (!termsOfUseLastAgreed) {
    return true;
  }
  return new Date(termsOfUseLastAgreed).getTime() < new Date(_terms.TERMS_OF_USE_LAST_UPDATED).getTime();
}
function getLastViewedUserSurvey(state) {
  return state.metamask.lastViewedUserSurvey;
}
function getShowOutdatedBrowserWarning(state) {
  const {
    outdatedBrowserWarningLastShown
  } = state.metamask;
  if (!outdatedBrowserWarningLastShown) {
    return true;
  }
  const currentTime = new Date().getTime();
  return currentTime - outdatedBrowserWarningLastShown >= _time.DAY * 2;
}
function getOnboardingDate(state) {
  return state.metamask.onboardingDate;
}
function getShowBetaHeader(state) {
  return state.metamask.showBetaHeader;
}
function getShowPermissionsTour(state) {
  return state.metamask.showPermissionsTour;
}
function getShowNetworkBanner(state) {
  return state.metamask.showNetworkBanner;
}
function getShowAccountBanner(state) {
  return state.metamask.showAccountBanner;
}
function getShowDownloadMobileAppSlide(state) {
  return state.metamask.showDownloadMobileAppSlide;
}

/**
 * To get the useTokenDetection flag which determines whether a static or dynamic token list is used
 *
 * @param {*} state
 * @returns Boolean
 */
function getUseTokenDetection(state) {
  return Boolean(state.metamask.useTokenDetection);
}

/**
 * To get the useNftDetection flag which determines whether we autodetect NFTs
 *
 * @param {*} state
 * @returns Boolean
 */
function getUseNftDetection(state) {
  return Boolean(state.metamask.useNftDetection);
}

/**
 * To get the useBlockie flag which determines whether we show blockies or Jazzicons
 *
 * @param {*} state
 * @returns Boolean
 */
function getUseBlockie(state) {
  return Boolean(state.metamask.useBlockie);
}

/**
 * To get the openSeaEnabled flag which determines whether we use OpenSea's API
 *
 * @param {*} state
 * @returns Boolean
 */
function getOpenSeaEnabled(state) {
  return Boolean(state.metamask.openSeaEnabled);
}

/**
 * To get the `theme` value which determines which theme is selected
 *
 * @param {*} state
 * @returns Boolean
 */
function getTheme(state) {
  return state.metamask.theme;
}
function doesAddressRequireLedgerHidConnection(state, address) {
  const addressIsLedger = (0, _metamask.isAddressLedger)(state, address);
  const transportTypePreferenceIsWebHID = (0, _metamask.getLedgerTransportType)(state) === _hardwareWallets.LedgerTransportTypes.webhid;
  const webHidIsNotConnected = (0, _app.getLedgerWebHidConnectedStatus)(state) !== _hardwareWallets.WebHIDConnectedStatuses.connected;
  const ledgerTransportStatus = (0, _app.getLedgerTransportStatus)(state);
  const transportIsNotSuccessfullyCreated = ledgerTransportStatus !== _hardwareWallets.HardwareTransportStates.verified;
  return addressIsLedger && transportTypePreferenceIsWebHID && (webHidIsNotConnected || transportIsNotSuccessfullyCreated);
}
const getAllEnabledNetworks = exports.getAllEnabledNetworks = (0, _util3.createDeepEqualSelector)(_networks.getNetworkConfigurationsByChainId, getShowTestNetworks, (networkConfigurationsByChainId, showTestNetworks) => Object.entries(networkConfigurationsByChainId).reduce((acc, [chainId, network]) => {
  if (showTestNetworks || !_network.TEST_CHAINS.includes(chainId)) {
    acc[chainId] = network;
  }
  return acc;
}, {}));

/*
 * USE THIS WITH CAUTION
 *
 * Only use this selector if you are absolutely sure that your UI component needs
 * data from _all chains_ to compute a value. Else, use `getChainIdsToPoll`.
 *
 * Examples:
 * - Components that should NOT use this selector:
 *   - Token list: This only needs to poll for chains based on the network filter
 *     (potentially only one chain). In this case, use `getChainIdsToPoll`.
 * - Components that SHOULD use this selector:
 *   - Aggregated balance: This needs to display data regardless of network filter
 *     selection (always showing aggregated balances across all chains).
 *
 * Key Considerations:
 * - This selector can cause expensive computations. It should only be used when
 *   necessary, and where possible, optimized to use `getChainIdsToPoll` instead.
 * - Logic Overview:
 *   - If `PORTFOLIO_VIEW` is not enabled, the selector returns only the `currentChainId`.
 *   - Otherwise, it includes all chains from `networkConfigurations`, excluding
 *     `TEST_CHAINS`, while ensuring the `currentChainId` is included.
 */
// @deprecated('Use `getEnabledChainIds` instead')
const getAllChainsToPoll = exports.getAllChainsToPoll = (0, _util3.createDeepEqualSelector)(_networks.getNetworkConfigurationsByChainId, _networks.getCurrentChainId, (networkConfigurations, currentChainId) => {
  if (!"true") {
    return [currentChainId];
  }
  return Object.keys(networkConfigurations).filter(chainId => chainId === currentChainId || _network.FEATURED_NETWORK_CHAIN_IDS.includes(chainId));
});

// @deprecated('Use `getEnabledChainIds` instead')
const getChainIdsToPoll = exports.getChainIdsToPoll = (0, _util3.createDeepEqualSelector)(_networks.getNetworkConfigurationsByChainId, _networks.getCurrentChainId, getIsTokenNetworkFilterEqualCurrentNetwork, (networkConfigurations, currentChainId, isTokenNetworkFilterEqualCurrentNetwork) => {
  if (!"true" || isTokenNetworkFilterEqualCurrentNetwork) {
    return [currentChainId];
  }
  return Object.keys(networkConfigurations).filter(chainId => chainId === currentChainId || _network.FEATURED_NETWORK_CHAIN_IDS.includes(chainId));
});

// @deprecated('Use `getEnabledNetworkClientIds` instead')
const getNetworkClientIdsToPoll = exports.getNetworkClientIdsToPoll = (0, _util3.createDeepEqualSelector)(_networks.getNetworkConfigurationsByChainId, _networks.getCurrentChainId, getIsTokenNetworkFilterEqualCurrentNetwork, (networkConfigurations, currentChainId, isTokenNetworkFilterEqualCurrentNetwork) => {
  if (!"true" || isTokenNetworkFilterEqualCurrentNetwork) {
    const networkConfiguration = networkConfigurations[currentChainId];
    return [networkConfiguration.rpcEndpoints[networkConfiguration.defaultRpcEndpointIndex].networkClientId];
  }
  return Object.entries(networkConfigurations).reduce((acc, [chainId, network]) => {
    if (chainId === currentChainId || _network.FEATURED_NETWORK_CHAIN_IDS.includes(chainId)) {
      acc.push(network.rpcEndpoints[network.defaultRpcEndpointIndex].networkClientId);
    }
    return acc;
  }, []);
});

/**
 *  To retrieve the maxBaseFee and priorityFee the user has set as default
 *
 * @param {*} state
 * @returns {{maxBaseFee: string, priorityFee: string} | undefined}
 */
function getAdvancedGasFeeValues(state) {
  // This will not work when we switch to supporting multi-chain.
  // There are four non-test files that use this selector.
  // advanced-gas-fee-defaults
  // base-fee-input
  // priority-fee-input
  // useGasItemFeeDetails
  // The first three are part of the AdvancedGasFeePopover
  // The latter is used by the EditGasPopover
  // Both of those are used in Confirmations as well as transaction-list-item
  // All of the call sites have access to the GasFeeContext, which has a
  // transaction object set on it, but there are currently no guarantees that
  // the transaction has a chainId associated with it. To have this method
  // support multichain we'll need a reliable way for the chainId of the
  // transaction being modified to be available to all callsites and either
  // pass it in to the selector as a second parameter, or access it at the
  // callsite.
  return state.metamask.advancedGasFee[(0, _networks.getCurrentChainId)(state)];
}

/**
 * To get the name of the network that support token detection based in chainId.
 *
 * @param state
 * @returns string e.g. ethereum, bsc or polygon
 */
const getTokenDetectionSupportNetworkByChainId = state => {
  const chainId = (0, _networks.getCurrentChainId)(state);
  switch (chainId) {
    case _network.CHAIN_IDS.MAINNET:
      return _network.MAINNET_DISPLAY_NAME;
    case _network.CHAIN_IDS.BSC:
      return _network.BSC_DISPLAY_NAME;
    case _network.CHAIN_IDS.POLYGON:
      return _network.POLYGON_DISPLAY_NAME;
    case _network.CHAIN_IDS.AVALANCHE:
      return _network.AVALANCHE_DISPLAY_NAME;
    case _network.CHAIN_IDS.LINEA_GOERLI:
      return _network.LINEA_GOERLI_DISPLAY_NAME;
    case _network.CHAIN_IDS.LINEA_SEPOLIA:
      return _network.LINEA_SEPOLIA_DISPLAY_NAME;
    case _network.CHAIN_IDS.LINEA_MAINNET:
      return _network.LINEA_MAINNET_DISPLAY_NAME;
    case _network.CHAIN_IDS.ARBITRUM:
      return _network.ARBITRUM_DISPLAY_NAME;
    case _network.CHAIN_IDS.OPTIMISM:
      return _network.OPTIMISM_DISPLAY_NAME;
    case _network.CHAIN_IDS.BASE:
      return _network.BASE_DISPLAY_NAME;
    case _network.CHAIN_IDS.ZKSYNC_ERA:
      return _network.ZK_SYNC_ERA_DISPLAY_NAME;
    case _network.CHAIN_IDS.CRONOS:
      return _network.CRONOS_DISPLAY_NAME;
    case _network.CHAIN_IDS.CELO:
      return _network.CELO_DISPLAY_NAME;
    case _network.CHAIN_IDS.GNOSIS:
      return _network.GNOSIS_DISPLAY_NAME;
    case _network.CHAIN_IDS.FANTOM:
      return _network.FANTOM_DISPLAY_NAME;
    case _network.CHAIN_IDS.POLYGON_ZKEVM:
      return _network.POLYGON_ZKEVM_DISPLAY_NAME;
    case _network.CHAIN_IDS.MOONBEAM:
      return _network.MOONBEAM_DISPLAY_NAME;
    case _network.CHAIN_IDS.MOONRIVER:
      return _network.MOONRIVER_DISPLAY_NAME;
    default:
      return '';
  }
};
/**
 * Returns true if a token list is available for the current network.
 *
 * @param {*} state
 * @returns Boolean
 */
exports.getTokenDetectionSupportNetworkByChainId = getTokenDetectionSupportNetworkByChainId;
function getIsDynamicTokenListAvailable(state) {
  const chainId = (0, _networks.getCurrentChainId)(state);
  return [_network.CHAIN_IDS.MAINNET, _network.CHAIN_IDS.BSC, _network.CHAIN_IDS.POLYGON, _network.CHAIN_IDS.AVALANCHE, _network.CHAIN_IDS.LINEA_GOERLI, _network.CHAIN_IDS.LINEA_SEPOLIA, _network.CHAIN_IDS.LINEA_MAINNET, _network.CHAIN_IDS.ARBITRUM, _network.CHAIN_IDS.OPTIMISM, _network.CHAIN_IDS.BASE, _network.CHAIN_IDS.ZKSYNC_ERA, _network.CHAIN_IDS.CRONOS, _network.CHAIN_IDS.CELO, _network.CHAIN_IDS.GNOSIS, _network.CHAIN_IDS.FANTOM, _network.CHAIN_IDS.POLYGON_ZKEVM, _network.CHAIN_IDS.MOONBEAM, _network.CHAIN_IDS.MOONRIVER, _network.CHAIN_IDS.SEI].includes(chainId);
}

/**
 * To retrieve the list of tokens detected and saved on the state to detectedToken object.
 *
 * @param {*} state
 * @returns list of token objects
 */
function getDetectedTokensInCurrentNetwork(state) {
  var _state$metamask$allDe;
  const currentChainId = (0, _networks.getCurrentChainId)(state);
  const {
    address: selectedAddress
  } = (0, _accounts.getSelectedInternalAccount)(state);
  return (_state$metamask$allDe = state.metamask.allDetectedTokens) === null || _state$metamask$allDe === void 0 || (_state$metamask$allDe = _state$metamask$allDe[currentChainId]) === null || _state$metamask$allDe === void 0 ? void 0 : _state$metamask$allDe[selectedAddress];
}
function getAllDetectedTokens(state) {
  return state.metamask.allDetectedTokens;
}

/**
 * To retrieve the list of tokens detected across all chains.
 *
 * @param {*} state
 * @returns list of token objects on all networks
 */
function getAllDetectedTokensForSelectedAddress(state) {
  const completedOnboarding = (0, _metamask.getCompletedOnboarding)(state);
  if (!completedOnboarding) {
    return {};
  }
  const {
    address: selectedAddress
  } = (0, _accounts.getSelectedInternalAccount)(state);
  const tokensByChainId = Object.entries(state.metamask.allDetectedTokens || {}).reduce((acc, [chainId, chainTokens]) => {
    const tokensForAddress = chainTokens[selectedAddress];
    if (tokensForAddress) {
      acc[chainId] = tokensForAddress.map(token => ({
        ...token,
        chainId
      }));
    }
    return acc;
  }, {});
  return tokensByChainId;
}

/**
 * To check if the token detection is OFF and the network is Mainnet
 * so that the user can skip third party token api fetch
 * and use the static tokenlist from contract-metadata
 *
 * @param {*} state
 * @returns Boolean
 */
function getIsTokenDetectionInactiveOnMainnet(state) {
  const isMainnet = getIsMainnet(state);
  const useTokenDetection = getUseTokenDetection(state);
  return !useTokenDetection && isMainnet;
}

/**
 * To check for the chainId that supports token detection ,
 * currently it returns true for Ethereum Mainnet, Polygon, BSC, and Avalanche
 *
 * @param {*} state
 * @returns Boolean
 */
function getIsTokenDetectionSupported(state) {
  const useTokenDetection = getUseTokenDetection(state);
  const isDynamicTokenListAvailable = getIsDynamicTokenListAvailable(state);
  return useTokenDetection && isDynamicTokenListAvailable;
}

/**
 * To check if the token detection is OFF for the token detection supported networks
 * and the network is not Mainnet
 *
 * @param {*} state
 * @returns Boolean
 */
function getIstokenDetectionInactiveOnNonMainnetSupportedNetwork(state) {
  const useTokenDetection = getUseTokenDetection(state);
  const isMainnet = getIsMainnet(state);
  const isDynamicTokenListAvailable = getIsDynamicTokenListAvailable(state);
  return isDynamicTokenListAvailable && !useTokenDetection && !isMainnet;
}

/**
 * To get the `getIsSecurityAlertsEnabled` value which determines whether security check is enabled
 *
 * @param {*} state
 * @returns Boolean
 */
function getIsSecurityAlertsEnabled(state) {
  return state.metamask.securityAlertsEnabled;
}

/**
 * To get the `getUsePhishDetect` value which determines whether phishing detection is enabled
 *
 * @param {*} state
 * @returns Boolean
 */
function getUsePhishDetect(state) {
  return state.metamask.usePhishDetect;
}

/**
 * Gets the cached address security alert response for a given address
 *
 * @param {*} state
 * @param {string} address - The address to get security alert for
 * @returns the cached address security alert response for the given address
 */
function getAddressSecurityAlertResponse(state, address) {
  var _state$metamask$addre;
  if (!address) {
    return undefined;
  }
  return (_state$metamask$addre = state.metamask.addressSecurityAlertResponses) === null || _state$metamask$addre === void 0 ? void 0 : _state$metamask$addre[address.toLowerCase()];
}

/**
 * Gets the cached url scan result for a given hostname
 *
 * @param {*} state
 * @param {string | undefined} hostname - The hostname to get the url scan result for
 * @returns the cached url scan result for the given hostname or undefined if the hostname is not provided
 */
function getUrlScanCacheResult(state, hostname) {
  var _state$metamask$urlSc;
  if (!hostname) {
    return undefined;
  }
  return (_state$metamask$urlSc = state.metamask.urlScanCache) === null || _state$metamask$urlSc === void 0 ? void 0 : _state$metamask$urlSc[hostname];
}

/**
 * Gets the token scan cache from state
 *
 * @param {*} state
 * @returns The token scan cache object
 */
function getTokenScanCache(state) {
  return state.metamask.tokenScanCache;
}

/**
 * Gets specific token scan results for given addresses.
 *
 * @param {*} state
 * @param {string} chainId
 * @param {string[]} tokenAddresses
 * @returns {Record<string, TokenScanCacheResult>}
 */
const getTokenScanResultsForAddresses = exports.getTokenScanResultsForAddresses = (0, _util3.createDeepEqualSelector)(getTokenScanCache, (_state, chainId) => chainId, (_state, _chainId, tokenAddresses) => tokenAddresses, (tokenScanCache, chainId, tokenAddresses) => {
  if (!chainId || !tokenAddresses || !Array.isArray(tokenAddresses)) {
    return {};
  }
  const results = {};
  tokenAddresses.forEach(tokenAddress => {
    if (tokenAddress) {
      const cacheKey = (0, _tokenCacheUtils.generateTokenCacheKey)(chainId, tokenAddress);
      if (tokenScanCache !== null && tokenScanCache !== void 0 && tokenScanCache[cacheKey]) {
        results[cacheKey] = tokenScanCache[cacheKey];
      }
    }
  });
  return results;
});

///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
/**
 * Get the state of the `addSnapAccountEnabled` flag.
 *
 * @param {*} state
 * @returns The state of the `addSnapAccountEnabled` flag.
 */
function getIsAddSnapAccountEnabled(state) {
  return state.metamask.addSnapAccountEnabled;
}
///: END:ONLY_INCLUDE_IF

/**
 * Get the state of the `solanaTestnetsEnabled` remote feature flag.
 *
 * @param {*} state
 * @returns The state of the `solanaTestnetsEnabled` remote feature flag.
 */
function getIsSolanaTestnetSupportEnabled(state) {
  const {
    solanaTestnetsEnabled
  } = (0, _remoteFeatureFlags.getRemoteFeatureFlags)(state);
  return Boolean(solanaTestnetsEnabled);
}

/**
 * Get the state of the `bitcoinTestnetsEnabled` remote feature flag.
 *
 * @param {*} state
 * @returns The state of the `bitcoinTestnetsEnabled` remote feature flag.
 */
function getIsBitcoinTestnetSupportEnabled(state) {
  const {
    bitcoinTestnetsEnabled
  } = (0, _remoteFeatureFlags.getRemoteFeatureFlags)(state);
  return Boolean(bitcoinTestnetsEnabled);
}
function getIsWatchEthereumAccountEnabled(state) {
  return state.metamask.watchEthereumAccountEnabled;
}

/**
 * Get the state of the `bitcoinAccounts` feature flag with version check.
 *
 * @param {*} _state
 * @returns The state of the `bitcoinAccounts` feature flag.
 */
function getIsBitcoinSupportEnabled(
// Use `_` prefix to avoid lint issue if `bitcoin` code-fence is not enabled
_state) {
  // When bitcoin is not enabled, always return false
  let enabled = false;
  return enabled;
}

/**
 * Get the state of the `solanaAccounts` feature flag with version check.
 *
 * @param {*} state
 * @returns The state of the `solanaAccounts` feature flag.
 */
function getIsSolanaSupportEnabled(state) {
  const {
    solanaAccounts
  } = (0, _remoteFeatureFlags.getRemoteFeatureFlags)(state);
  return (0, _multichainFeatureFlags.isMultichainFeatureEnabled)(solanaAccounts);
}

/**
 * Checks if the new settings redesign is enabled
 *
 * @param state - The state of the application
 * @returns true if the new settings redesign is enabled, false otherwise
 */
function getIsNewSettingsEnabled(state) {
  const {
    settingsRedesign
  } = (0, _remoteFeatureFlags.getRemoteFeatureFlags)(state);
  return Boolean(settingsRedesign);
}
function getManageInstitutionalWallets(state) {
  return state.metamask.manageInstitutionalWallets;
}
/**
 * Get the state of the `defiPositionsEnabled` remote feature flag.
 *
 * @param {*} state
 * @returns The state of the `defiPositionsEnabled` remote feature flag.
 */
function getIsDefiPositionsEnabled(state) {
  const {
    assetsDefiPositionsEnabled
  } = (0, _remoteFeatureFlags.getRemoteFeatureFlags)(state);
  return Boolean(assetsDefiPositionsEnabled);
}
function getIsCustomNetwork(state) {
  const chainId = (0, _networks.getCurrentChainId)(state);
  return !_network.CHAIN_ID_TO_RPC_URL_MAP[chainId];
}

/**
 * Get the state of the `neNetworkDiscoverButton` remote feature flag.
 * This flag determines whether the user should see a `Discover` button on the network menu list.
 *
 * @param {*} state
 * @returns The state of the `neNetworkDiscoverButton` remote feature flag.
 */
function getNetworkDiscoverButtonEnabled(state) {
  const {
    neNetworkDiscoverButton
  } = (0, _remoteFeatureFlags.getRemoteFeatureFlags)(state);
  return neNetworkDiscoverButton;
}
function getBlockExplorerLinkText(state, accountDetailsModalComponent = false) {
  const isCustomNetwork = getIsCustomNetwork(state);
  const rpcPrefs = getRpcPrefsForCurrentProvider(state);
  let blockExplorerLinkText = {
    firstPart: 'addBlockExplorer',
    secondPart: ''
  };
  if (rpcPrefs.blockExplorerUrl) {
    blockExplorerLinkText = accountDetailsModalComponent ? {
      firstPart: 'blockExplorerView',
      secondPart: (0, _util2.getURLHostName)(rpcPrefs.blockExplorerUrl)
    } : {
      firstPart: 'viewinExplorer',
      secondPart: 'blockExplorerAccountAction'
    };
  } else if (isCustomNetwork === false) {
    blockExplorerLinkText = accountDetailsModalComponent ? {
      firstPart: 'etherscanViewOn',
      secondPart: ''
    } : {
      firstPart: 'viewOnEtherscan',
      secondPart: 'blockExplorerAccountAction'
    };
  }
  return blockExplorerLinkText;
}
function getAllAccountsOnNetworkAreEmpty(state) {
  const balances = getMetaMaskCachedBalances(state) ?? {};
  const hasNoNativeFundsOnAnyAccounts = Object.values(balances).every(balance => balance === '0x0' || balance === '0x00');
  const hasNoTokens = getNumberOfTokens(state) === 0;
  return hasNoNativeFundsOnAnyAccounts && hasNoTokens;
}
function getUnconnectedAccounts(state, activeTab) {
  const accounts = getMetaMaskAccountsOrdered(state);
  const connectedAccounts = getOrderedConnectedAccountsForConnectedDapp(state, activeTab);
  const unConnectedAccounts = accounts.filter(account => {
    return !connectedAccounts.some(connectedAccount => connectedAccount.address === account.address);
  });
  return unConnectedAccounts;
}
const getOrderedConnectedAccountsForActiveTab = exports.getOrderedConnectedAccountsForActiveTab = (0, _util3.createDeepEqualSelector)(state => state.activeTab, state => state.metamask.permissionHistory, getMetaMaskAccountsOrdered, getAllPermittedAccountsForCurrentTab, (activeTab, permissionHistory, orderedAccounts, connectedAccounts) => {
  var _permissionHistory$ac;
  const permissionHistoryByAccount = ((_permissionHistory$ac = permissionHistory[activeTab.origin]) === null || _permissionHistory$ac === void 0 || (_permissionHistory$ac = _permissionHistory$ac.eth_accounts) === null || _permissionHistory$ac === void 0 ? void 0 : _permissionHistory$ac.accounts) || {};
  const connectedAccountsAddresses = connectedAccounts.map(caipAccountId => {
    const {
      address
    } = (0, _utils.parseCaipAccountId)(caipAccountId);
    return address;
  });
  return orderedAccounts.filter(account => connectedAccountsAddresses.includes(account.address)).map(account => ({
    ...account,
    metadata: {
      ...account.metadata,
      lastActive: permissionHistoryByAccount === null || permissionHistoryByAccount === void 0 ? void 0 : permissionHistoryByAccount[account.address]
    }
  })).sort(({
    lastSelected: lastSelectedA
  }, {
    lastSelected: lastSelectedB
  }) => {
    if (lastSelectedA === lastSelectedB) {
      return 0;
    } else if (lastSelectedA === undefined) {
      return 1;
    } else if (lastSelectedB === undefined) {
      return -1;
    }
    return lastSelectedB - lastSelectedA;
  });
});
const getUpdatedAndSortedAccounts = exports.getUpdatedAndSortedAccounts = (0, _util3.createDeepEqualSelector)(getMetaMaskAccountsOrdered, getPinnedAccountsList, getHiddenAccountsList, getOrderedConnectedAccountsForActiveTab, (accounts, pinnedAddresses, hiddenAddresses, connectedAccounts) => {
  connectedAccounts.forEach(connection => {
    // Find if the connection exists in accounts
    const matchingAccount = accounts.find(account => account.id === connection.id);

    // If a matching account is found and the connection has metadata, add the connections property to true and lastSelected timestamp from metadata
    if (matchingAccount && connection.metadata) {
      matchingAccount.connections = true;
      matchingAccount.lastSelected = connection.metadata.lastSelected;
    }
  });

  // Find the account with the most recent lastSelected timestamp among accounts with metadata
  const accountsWithLastSelected = accounts.filter(account => account.connections && account.lastSelected);
  const mostRecentAccount = accountsWithLastSelected.length > 0 ? accountsWithLastSelected.reduce((prev, current) => prev.lastSelected > current.lastSelected ? prev : current) : null;
  accounts.forEach(account => {
    account.pinned = Boolean(pinnedAddresses.includes(account.address));
    account.hidden = Boolean(hiddenAddresses.includes(account.address));
    account.active = Boolean(mostRecentAccount && account.id === mostRecentAccount.id);
  });
  const sortedPinnedAccounts = pinnedAddresses === null || pinnedAddresses === void 0 ? void 0 : pinnedAddresses.map(address => accounts.find(account => account.address === address)).filter(account => Boolean(account && pinnedAddresses.includes(account.address) && !(hiddenAddresses !== null && hiddenAddresses !== void 0 && hiddenAddresses.includes(account.address))));
  const notPinnedAccounts = accounts.filter(account => !pinnedAddresses.includes(account.address) && !hiddenAddresses.includes(account.address));
  const filteredHiddenAccounts = accounts.filter(account => hiddenAddresses.includes(account.address));
  const sortedSearchResults = [...sortedPinnedAccounts, ...notPinnedAccounts, ...filteredHiddenAccounts];
  return sortedSearchResults;
});
const getUpdatedAndSortedAccountsWithCaipAccountId = exports.getUpdatedAndSortedAccountsWithCaipAccountId = (0, _util3.createDeepEqualSelector)(getUpdatedAndSortedAccounts, accounts => {
  return accounts.map(account => {
    const {
      namespace,
      reference
    } = (0, _utils.parseCaipChainId)(account.scopes[0]);
    return {
      ...account,
      caipAccountId: `${namespace}:${reference}:${account.address}`
    };
  });
});
const useSafeChainsListValidationSelector = state => {
  return state.metamask.useSafeChainsListValidation;
};
exports.useSafeChainsListValidationSelector = useSafeChainsListValidationSelector;
function getShowFiatInTestnets(state) {
  const {
    showFiatInTestnets
  } = getPreferences(state);
  return showFiatInTestnets;
}

/**
 * To get the useCurrencyRateCheck flag which to check if the user prefers currency conversion
 *
 * @param {*} state
 * @returns Boolean
 */
function getUseCurrencyRateCheck(state) {
  return Boolean(state.metamask.useCurrencyRateCheck);
}
function getNames(state) {
  return state.metamask.names || {};
}
function getEthereumAddressNames(state) {
  var _state$metamask$names;
  return ((_state$metamask$names = state.metamask.names) === null || _state$metamask$names === void 0 ? void 0 : _state$metamask$names[_nameController.NameType.ETHEREUM_ADDRESS]) || {};
}
function getNameSources(state) {
  return state.metamask.nameSources || {};
}
function getMetaMetricsDataDeletionId(state) {
  return state.metamask.metaMetricsDataDeletionId;
}
function getMetaMetricsDataDeletionTimestamp(state) {
  return state.metamask.metaMetricsDataDeletionTimestamp;
}
function getMetaMetricsDataDeletionStatus(state) {
  return state.metamask.metaMetricsDataDeletionStatus;
}

/**
 * To get all installed snaps with proper metadata
 *
 * @param {*} state
 * @returns Boolean
 */
function getSnapsList(state) {
  const snaps = getSnaps(state);
  return Object.entries(snaps).filter(([_key, snap]) => {
    // Always hide installing Snaps.
    if (snap.status === _snapsUtils.SnapStatus.Installing) {
      return false;
    }

    // For backwards compatibility, preinstalled Snaps must specify hidden = false to be displayed.
    if (snap.preinstalled) {
      return snap.hidden === false;
    }
    return true;
  }).map(([key, snap]) => {
    const targetSubjectMetadata = getTargetSubjectMetadata(state, snap === null || snap === void 0 ? void 0 : snap.id);
    return {
      key,
      id: snap.id,
      iconUrl: targetSubjectMetadata === null || targetSubjectMetadata === void 0 ? void 0 : targetSubjectMetadata.iconUrl,
      subjectType: targetSubjectMetadata === null || targetSubjectMetadata === void 0 ? void 0 : targetSubjectMetadata.subjectType,
      packageName: (0, _snapsUtils.stripSnapPrefix)(snap.id),
      name: getSnapMetadata(state, snap.id).name
    };
  });
}

/**
 * To get the state of snaps privacy warning popover.
 *
 * @param state - Redux state object.
 * @returns True if popover has been shown, false otherwise.
 */
function getSnapsInstallPrivacyWarningShown(state) {
  const {
    snapsInstallPrivacyWarningShown
  } = state.metamask;
  if (snapsInstallPrivacyWarningShown === undefined || snapsInstallPrivacyWarningShown === null) {
    return false;
  }
  return snapsInstallPrivacyWarningShown;
}

///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
function getsnapsAddSnapAccountModalDismissed(state) {
  const {
    snapsAddSnapAccountModalDismissed
  } = state.metamask;
  return snapsAddSnapAccountModalDismissed;
}
function getSnapRegistry(state) {
  const {
    snapRegistryList
  } = state.metamask;
  return snapRegistryList;
}
function getKeyringSnapAccounts(state) {
  const internalAccounts = (0, _accounts.getInternalAccounts)(state);
  const keyringAccounts = Object.values(internalAccounts).filter(internalAccount => {
    const {
      keyring
    } = internalAccount.metadata;
    return keyring.type === _keyring.KeyringType.snap;
  });
  return keyringAccounts;
}
///: END:ONLY_INCLUDE_IF

const getSelectedKeyringByIdOrDefault = exports.getSelectedKeyringByIdOrDefault = (0, _reselect.createSelector)(getMetaMaskKeyrings, (_state, keyringId) => keyringId, (keyrings, keyringId) => {
  return keyrings.find(keyring => keyring.metadata.id === keyringId) ?? keyrings[0];
});
const getHdKeyringIndexByIdOrDefault = exports.getHdKeyringIndexByIdOrDefault = (0, _reselect.createSelector)(getMetaMaskHdKeyrings, (_state, keyringId) => keyringId, (keyrings, keyringId) => {
  return (
    // 0 is the default hd keyring index.
    keyrings.findIndex(keyring => keyring.metadata.id === keyringId) ?? 0
  );
});
const getKeyringOfSelectedAccount = exports.getKeyringOfSelectedAccount = (0, _reselect.createSelector)(_accounts.getSelectedInternalAccount, getMetaMaskKeyrings, (selectedAccount, keyrings) => {
  return keyrings.find(keyring => keyring.accounts.some(account => (0, _stringUtils.isEqualCaseInsensitive)(account, selectedAccount.address)));
});
const getHdKeyringOfSelectedAccountOrPrimaryKeyring = exports.getHdKeyringOfSelectedAccountOrPrimaryKeyring = (0, _reselect.createSelector)(getKeyringOfSelectedAccount, getMetaMaskHdKeyrings, (keyringOfSelectedAccount, hdKeyrings) => {
  if (keyringOfSelectedAccount.type === _keyringController.KeyringTypes.hd) {
    return keyringOfSelectedAccount;
  }
  return hdKeyrings[0];
});

// #region permissions selectors

/**
 * Deep equal selector to get the permission subjects object.
 *
 * @param {object} state - The current state.
 * @returns {object} The permissions subjects object.
 */
const getPermissionSubjectsDeepEqual = exports.getPermissionSubjectsDeepEqual = (0, _util3.createDeepEqualSelector)(state => state.metamask.subjects || {}, subjects => subjects);

/**
 * Deep equal selector to get the subject metadata object.
 *
 * @param {object} state - The current state.
 * @returns {object} The subject metadata object.
 */
const getSubjectMetadataDeepEqual = exports.getSubjectMetadataDeepEqual = (0, _util3.createDeepEqualSelector)(state => state.metamask.subjectMetadata, metadata => metadata);

/**
 * Selector to get the permission subjects object.
 *
 * @param {object} state - The current state.
 * @returns {object} The permissions subjects object.
 */
function getPermissionSubjects(state) {
  return state.metamask.subjects || {};
}

/**
 * Selects the permitted accounts from the eth_accounts permission given state
 * and an origin.
 *
 * @param {object} state - The current state.
 * @param {string} origin - The origin/subject to get the permitted accounts for.
 * @returns {Array<string>} An empty array or an array of accounts.
 */
function getPermittedEVMAccounts(state, origin) {
  return getEVMAccountsFromPermission(getCaip25PermissionFromSubject(subjectSelector(state, origin)));
}
function getPermittedEVMChains(state, origin) {
  return getEVMChainsFromPermission(getCaip25PermissionFromSubject(subjectSelector(state, origin)));
}
function getAllPermittedAccounts(state, origin) {
  const caip25Permission = getCaip25PermissionFromSubject(subjectSelector(state, origin));
  const caip25Caveat = (0, _chainAgnosticPermission.getCaip25CaveatFromPermission)(caip25Permission);
  return caip25Caveat ? (0, _chainAgnosticPermission.getCaipAccountIdsFromCaip25CaveatValue)(caip25Caveat.value) : [];
}
function getAllPermittedScopes(state, origin) {
  const caip25Permission = getCaip25PermissionFromSubject(subjectSelector(state, origin));
  return caip25Permission ? (0, _chainAgnosticPermission.getAllScopesFromPermission)(caip25Permission) : [];
}

/**
 * Selects the permitted accounts from the eth_accounts permission for the
 * origin of the current tab.
 *
 * @param {object} state - The current state.
 * @returns {Array<string>} An empty array or an array of accounts.
 */
function getPermittedEVMAccountsForCurrentTab(state) {
  return getPermittedEVMAccounts(state, getOriginOfCurrentTab(state));
}
function getPermittedEVMAccountsForSelectedTab(state, activeTab) {
  return getPermittedEVMAccounts(state, activeTab);
}
function getAllPermittedAccountsForCurrentTab(state) {
  return getAllPermittedAccounts(state, getOriginOfCurrentTab(state));
}
function getAllPermittedAccountsForSelectedTab(state, activeTab) {
  return getAllPermittedAccounts(state, activeTab);
}
function getPermittedEVMChainsForSelectedTab(state, activeTab) {
  return getPermittedEVMChains(state, activeTab);
}
function getAllPermittedChainsForSelectedTab(state, activeTab) {
  const permittedScopes = getAllPermittedScopes(state, activeTab);
  // our `endowment:caip25` permission can include a special class of `wallet` scopes,
  // see https://github.com/ChainAgnostic/namespaces/tree/main/wallet &
  // https://github.com/ChainAgnostic/namespaces/blob/main/wallet/caip2.md
  // amongs the other chainId scopes. We want to exclude the `wallet` scopes here.
  return permittedScopes.filter(caipChainId => {
    try {
      const {
        namespace
      } = (0, _utils.parseCaipChainId)(caipChainId);
      return namespace !== _utils.KnownCaipNamespace.Wallet;
    } catch (err) {
      return false;
    }
  });
}

/**
 * Returns a map of permitted accounts by origin for all origins.
 *
 * @param {object} state - The current state.
 * @returns {object} Permitted accounts by origin.
 */
function getPermittedAccountsByOrigin(state) {
  const subjects = getPermissionSubjects(state);
  return Object.keys(subjects).reduce((acc, subjectKey) => {
    const accounts = getAccountsFromSubject(subjects[subjectKey]);
    if (accounts.length > 0) {
      acc[subjectKey] = accounts;
    }
    return acc;
  }, {});
}
function getPermittedEVMChainsByOrigin(state) {
  const subjects = getPermissionSubjects(state);
  return Object.keys(subjects).reduce((acc, subjectKey) => {
    const chains = getEVMChainsFromSubject(subjects[subjectKey]);
    if (chains.length > 0) {
      acc[subjectKey] = chains;
    }
    return acc;
  }, {});
}
function getSubjectMetadata(state) {
  return state.metamask.subjectMetadata;
}

/**
 * Returns an array of connected subject objects, with the following properties:
 * - extensionId
 * - key (i.e. origin)
 * - name
 * - icon
 *
 * @param {object} state - The current state.
 * @returns {Array<object>} An array of connected subject objects.
 */
function getConnectedSubjectsForSelectedAddress(state) {
  const selectedInternalAccount = (0, _accounts.getSelectedInternalAccount)(state);
  const subjects = getPermissionSubjects(state);
  const subjectMetadata = getSubjectMetadata(state);
  const connectedSubjects = [];
  Object.entries(subjects).forEach(([subjectKey, subjectValue]) => {
    const exposedAccounts = getAccountsFromSubject(subjectValue);
    if (!exposedAccounts.includes(selectedInternalAccount.address)) {
      return;
    }
    const {
      extensionId,
      name,
      iconUrl
    } = subjectMetadata[subjectKey] || {};
    connectedSubjects.push({
      extensionId,
      origin: subjectKey,
      name,
      iconUrl
    });
  });
  return connectedSubjects;
}
function getSubjectsWithPermission(state, permissionName) {
  const subjects = getPermissionSubjects(state);
  const connectedSubjects = [];
  Object.entries(subjects).forEach(([origin, {
    permissions
  }]) => {
    if (permissions[permissionName]) {
      const {
        extensionId,
        name,
        iconUrl
      } = getTargetSubjectMetadata(state, origin) || {};
      connectedSubjects.push({
        extensionId,
        origin,
        name,
        iconUrl
      });
    }
  });
  return connectedSubjects;
}
function getSubjectsWithSnapPermission(state, snapId) {
  const subjects = getPermissionSubjects(state);
  return Object.entries(subjects).filter(([_origin, {
    permissions
  }]) => {
    var _permissions$WALLET_S;
    return (_permissions$WALLET_S = permissions[_snapsRpcMethods.WALLET_SNAP_PERMISSION_KEY]) === null || _permissions$WALLET_S === void 0 ? void 0 : _permissions$WALLET_S.caveats[0].value[snapId];
  }).map(([origin, _subject]) => {
    const {
      extensionId,
      name,
      iconUrl
    } = getTargetSubjectMetadata(state, origin) || {};
    return {
      extensionId,
      origin,
      name,
      iconUrl
    };
  });
}

/**
 * Returns an object mapping addresses to objects mapping origins to connected
 * subject info. Subject info objects have the following properties:
 * - iconUrl
 * - name
 *
 * @param {object} state - The current state.
 * @returns {object} A mapping of addresses to a mapping of origins to
 * connected subject info.
 */
function getAddressConnectedSubjectMap(state) {
  const subjectMetadata = getSubjectMetadata(state);
  const accountsMap = getPermittedAccountsByOrigin(state);
  const addressConnectedIconMap = {};
  Object.keys(accountsMap).forEach(subjectKey => {
    const {
      iconUrl,
      name
    } = subjectMetadata[subjectKey] || {};
    accountsMap[subjectKey].forEach(address => {
      const nameToRender = name || subjectKey;
      addressConnectedIconMap[address] = addressConnectedIconMap[address] ? {
        ...addressConnectedIconMap[address],
        [subjectKey]: {
          iconUrl,
          name: nameToRender
        }
      } : {
        [subjectKey]: {
          iconUrl,
          name: nameToRender
        }
      };
    });
  });
  return addressConnectedIconMap;
}
const isAccountConnectedToCurrentTab = exports.isAccountConnectedToCurrentTab = (0, _util3.createDeepEqualSelector)(getPermittedEVMAccountsForCurrentTab, (_state, address) => address, (permittedAccounts, address) => {
  return permittedAccounts.some(account => account === address);
});

// selector helpers
function getCaip25PermissionFromSubject(subject = {}) {
  var _subject$permissions;
  return (_subject$permissions = subject.permissions) === null || _subject$permissions === void 0 ? void 0 : _subject$permissions[_chainAgnosticPermission.Caip25EndowmentPermissionName];
}
function getAccountsFromSubject(subject) {
  return getEVMAccountsFromPermission(getCaip25PermissionFromSubject(subject));
}
function getEVMChainsFromSubject(subject) {
  return getEVMChainsFromPermission(getCaip25PermissionFromSubject(subject));
}
function getEVMAccountsFromPermission(caip25Permission) {
  if (!caip25Permission) {
    return [];
  }
  const caip25Caveat = (0, _chainAgnosticPermission.getCaip25CaveatFromPermission)(caip25Permission);
  return caip25Caveat ? (0, _chainAgnosticPermission.getEthAccounts)(caip25Caveat.value) : [];
}
function getEVMChainsFromPermission(caip25Permission) {
  if (!caip25Permission) {
    return [];
  }
  const caip25Caveat = (0, _chainAgnosticPermission.getCaip25CaveatFromPermission)(caip25Permission);
  return caip25Caveat ? (0, _chainAgnosticPermission.getPermittedEthChainIds)(caip25Caveat.value) : [];
}
function subjectSelector(state, origin) {
  var _state$metamask$subje;
  return origin && ((_state$metamask$subje = state.metamask.subjects) === null || _state$metamask$subje === void 0 ? void 0 : _state$metamask$subje[origin]);
}
function getAccountToConnectToActiveTab(state) {
  const selectedInternalAccount = (0, _accounts.getSelectedInternalAccount)(state);
  const connectedAccounts = getPermittedEVMAccountsForCurrentTab(state);
  const {
    metamask: {
      internalAccounts: {
        accounts
      }
    }
  } = state;
  const numberOfAccounts = Object.keys(accounts).length;
  if (connectedAccounts.length && connectedAccounts.length !== numberOfAccounts) {
    if (connectedAccounts.findIndex(address => address === selectedInternalAccount.address) === -1) {
      return getInternalAccount(state, selectedInternalAccount.id);
    }
  }
  return undefined;
}
function getOrderedConnectedAccountsForConnectedDapp(state, activeTab) {
  var _permissionHistory$ac2;
  const {
    metamask: {
      permissionHistory
    }
  } = state;
  const permissionHistoryByAccount = // eslint-disable-next-line camelcase
  (_permissionHistory$ac2 = permissionHistory[activeTab.origin]) === null || _permissionHistory$ac2 === void 0 || (_permissionHistory$ac2 = _permissionHistory$ac2.eth_accounts) === null || _permissionHistory$ac2 === void 0 ? void 0 : _permissionHistory$ac2.accounts;
  const orderedAccounts = getMetaMaskAccountsOrdered(state);
  const connectedAccounts = getPermittedEVMAccountsForSelectedTab(state, activeTab);
  return orderedAccounts.filter(account => connectedAccounts.includes(account.address)).filter(account => (0, _keyringApi.isEvmAccountType)(account.type)).map(account => ({
    ...account,
    metadata: {
      ...account.metadata,
      lastActive: permissionHistoryByAccount === null || permissionHistoryByAccount === void 0 ? void 0 : permissionHistoryByAccount[account.address]
    }
  })).sort(({
    lastSelected: lastSelectedA
  }, {
    lastSelected: lastSelectedB
  }) => {
    if (lastSelectedA === lastSelectedB) {
      return 0;
    } else if (lastSelectedA === undefined) {
      return 1;
    } else if (lastSelectedB === undefined) {
      return -1;
    }
    return lastSelectedB - lastSelectedA;
  });
}
function getPermissionsForActiveTab(state) {
  var _subjects$activeTab$o;
  const {
    activeTab,
    metamask
  } = state;
  const {
    subjects = {}
  } = metamask;
  const permissions = ((_subjects$activeTab$o = subjects[activeTab.origin]) === null || _subjects$activeTab$o === void 0 ? void 0 : _subjects$activeTab$o.permissions) ?? {};
  return Object.keys(permissions).map(parentCapability => {
    return {
      key: parentCapability,
      value: permissions[parentCapability]
    };
  });
}
function activeTabHasPermissions(state) {
  var _subjects$activeTab$o2;
  const {
    activeTab,
    metamask
  } = state;
  const {
    subjects = {}
  } = metamask;
  return Boolean(Object.keys(((_subjects$activeTab$o2 = subjects[activeTab.origin]) === null || _subjects$activeTab$o2 === void 0 ? void 0 : _subjects$activeTab$o2.permissions) || {}).length > 0);
}

/**
 * Get the connected accounts history for all origins.
 *
 * @param {Record<string, unknown>} state - The MetaMask state.
 * @returns {Record<string, { accounts: Record<string, number> }>} An object
 * with account connection histories by origin.
 */
function getLastConnectedInfo(state) {
  const {
    permissionHistory = {}
  } = state.metamask;
  return Object.keys(permissionHistory).reduce((lastConnectedInfo, origin) => {
    if (permissionHistory[origin].eth_accounts) {
      lastConnectedInfo[origin] = JSON.parse(JSON.stringify(permissionHistory[origin].eth_accounts));
    }
    return lastConnectedInfo;
  }, {});
}
function getSnapInstallOrUpdateRequests(state) {
  return Object.values(state.metamask.pendingApprovals).filter(({
    type
  }) => type === 'wallet_installSnap' || type === 'wallet_updateSnap' || type === 'wallet_installSnapResult').map(({
    requestData
  }) => requestData);
}
function getFirstSnapInstallOrUpdateRequest(state) {
  var _getSnapInstallOrUpda;
  return ((_getSnapInstallOrUpda = getSnapInstallOrUpdateRequests(state)) === null || _getSnapInstallOrUpda === void 0 ? void 0 : _getSnapInstallOrUpda[0]) ?? null;
}
function getPermissionsRequests(state) {
  var _getApprovalRequestsB;
  return (_getApprovalRequestsB = (0, _approvals.getApprovalRequestsByType)(state, _controllerUtils.ApprovalType.WalletRequestPermissions)) === null || _getApprovalRequestsB === void 0 ? void 0 : _getApprovalRequestsB.map(({
    requestData
  }) => requestData);
}
function getFirstPermissionRequest(state) {
  const requests = getPermissionsRequests(state);
  return requests && requests[0] ? requests[0] : null;
}
function getPermissions(state, origin) {
  var _getPermissionSubject;
  return (_getPermissionSubject = getPermissionSubjects(state)[origin]) === null || _getPermissionSubject === void 0 ? void 0 : _getPermissionSubject.permissions;
}
function getRequestState(state, id) {
  var _state$metamask$pendi;
  return (_state$metamask$pendi = state.metamask.pendingApprovals[id]) === null || _state$metamask$pendi === void 0 ? void 0 : _state$metamask$pendi.requestState;
}
function getRequestType(state, id) {
  var _state$metamask$pendi2;
  return (_state$metamask$pendi2 = state.metamask.pendingApprovals[id]) === null || _state$metamask$pendi2 === void 0 ? void 0 : _state$metamask$pendi2.type;
}

// #endregion permissions selectors

/**
 * Determines whether the update modal should be shown.
 *
 * @param {__import__('../../ui/store/store').MetaMaskReduxState} state - The MetaMask state.
 * @returns {boolean} True if the update modal should be shown, false otherwise.
 */
function getShowUpdateModal(state) {
  var _global$platform;
  const {
    metamask: {
      isUpdateAvailable,
      updateModalLastDismissedAt,
      lastUpdatedAt
    }
  } = state;
  const remoteFeatureFlags = (0, _remoteFeatureFlags.getRemoteFeatureFlags)(state);
  const extensionCurrentVersion = _semver.default.valid(_semver.default.coerce((_global$platform = global.platform) === null || _global$platform === void 0 ? void 0 : _global$platform.getVersion()));
  const extensionUpdatePromptMinimumVersion = _semver.default.valid(_semver.default.coerce(remoteFeatureFlags.extensionUpdatePromptMinimumVersion));
  const isExtensionOutdated = extensionCurrentVersion && extensionUpdatePromptMinimumVersion ? _semver.default.lt(extensionCurrentVersion, extensionUpdatePromptMinimumVersion) : false;
  const currentTime = Date.now();
  const updateModalCooldown = 24 * 60 * 60 * 1000; // 24 hours
  const enoughTimePassedSinceLastDismissal = updateModalLastDismissedAt ? currentTime - updateModalLastDismissedAt > updateModalCooldown : true;
  const enoughTimePassedSinceLastUpdate = lastUpdatedAt ? currentTime - lastUpdatedAt > updateModalCooldown : true;
  const showUpdateModal = isExtensionOutdated && isUpdateAvailable && enoughTimePassedSinceLastDismissal && enoughTimePassedSinceLastUpdate;
  return showUpdateModal;
}

/**
 * Selector to get the allow list for non-zero unused approvals from remote feature flags.
 *
 * @param state - The MetaMask state object
 * @returns {string[]} Array of URL strings for the allow list
 */
const selectNonZeroUnusedApprovalsAllowList = exports.selectNonZeroUnusedApprovalsAllowList = (0, _reselect.createSelector)(_remoteFeatureFlags.getRemoteFeatureFlags, remoteFeatureFlags => (remoteFeatureFlags === null || remoteFeatureFlags === void 0 ? void 0 : remoteFeatureFlags.nonZeroUnusedApprovals) ?? _shared.EMPTY_ARRAY);

/**
 * @param {MetaMaskReduxState} state - The Redux state
 * @returns {__import__('../../shared/constants/app-state').NetworkConnectionBanner}
 */
function getNetworkConnectionBanner(state) {
  return state.metamask.networkConnectionBanner;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\selectors.js",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\shared.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Cshared.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EMPTY_OBJECT = exports.EMPTY_ARRAY = void 0;
const EMPTY_ARRAY = exports.EMPTY_ARRAY = Object.freeze([]);
const EMPTY_OBJECT = exports.EMPTY_OBJECT = Object.freeze({});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\shared.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\selectors\\transactions.js", {"../../shared/constants/transaction":"D:\\code\\v\\metamask-extension\\shared\\constants\\transaction.ts","../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../shared/modules/selectors/util":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\util.js","../helpers/constants/transactions":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\transactions.js","../helpers/utils/tx-helper":"D:\\code\\v\\metamask-extension\\ui\\helpers\\utils\\tx-helper.ts","./accounts":"D:\\code\\v\\metamask-extension\\ui\\selectors\\accounts.ts","./approvals":"D:\\code\\v\\metamask-extension\\ui\\selectors\\approvals.ts","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/smart-transactions-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","reselect":"D:\\code\\v\\metamask-extension\\node_modules\\reselect\\dist\\cjs\\reselect.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cselectors%5Ctransactions.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupAndSortTransactionsByNonce = exports.getUnapprovedTransactions = exports.getTransactions = exports.getCurrentNetworkTransactions = exports.getApprovedAndSignedTransactions = exports.getAllUnapprovedTransactions = exports.getAllNetworkTransactions = void 0;
exports.hasTransactionPendingApprovals = hasTransactionPendingApprovals;
exports.nonceSortedTransactionsSelectorAllChains = exports.nonceSortedTransactionsSelector = exports.nonceSortedPendingTransactionsSelectorAllChains = exports.nonceSortedPendingTransactionsSelector = exports.nonceSortedCompletedTransactionsSelectorAllChains = exports.nonceSortedCompletedTransactionsSelector = exports.incomingTxListSelectorAllChains = exports.incomingTxListSelector = void 0;
exports.selectTransactionMetadata = selectTransactionMetadata;
exports.unapprovedTypedMessagesSelector = exports.unapprovedPersonalMsgsSelector = exports.unapprovedMessagesSelector = exports.unapprovedEncryptionPublicKeyMsgsSelector = exports.unapprovedDecryptMsgsSelector = exports.transactionsSelectorAllChains = exports.transactionsSelector = exports.transactionSubSelectorAllChains = exports.transactionSubSelector = exports.submittedPendingTransactionsSelector = exports.smartTransactionsListSelector = exports.selectedAddressTxListSelectorAllChain = exports.selectedAddressTxListSelector = exports.selectTransactionSender = void 0;
var _controllerUtils = require("@metamask/controller-utils");
var _reselect = require("reselect");
var _transactionController = require("@metamask/transaction-controller");
var _smartTransactionsController = require("@metamask/smart-transactions-controller");
var _transactions = require("../helpers/constants/transactions");
var _txHelper = _interopRequireDefault(require("../helpers/utils/tx-helper"));
var _transaction = require("../../shared/constants/transaction");
var _conversion = require("../../shared/modules/conversion.utils");
var _networks = require("../../shared/modules/selectors/networks");
var _util = require("../../shared/modules/selectors/util");
var _accounts = require("./accounts");
var _approvals = require("./approvals");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const INVALID_INITIAL_TRANSACTION_TYPES = [_transactionController.TransactionType.cancel, _transactionController.TransactionType.retry];

// The statuses listed below are allowed in the Activity list for Smart Swaps.
// SUCCESS and REVERTED statuses are excluded because smart transactions with
// those statuses are already in the regular transaction list.
// TODO: When Swaps and non-Swaps transactions are treated the same,
// we will only allow the PENDING smart transaction status in the Activity list.
const allowedSwapsSmartTransactionStatusesForActivityList = [_smartTransactionsController.SmartTransactionStatuses.PENDING, _smartTransactionsController.SmartTransactionStatuses.UNKNOWN, _smartTransactionsController.SmartTransactionStatuses.RESOLVED, _smartTransactionsController.SmartTransactionStatuses.CANCELLED];
const getTransactions = exports.getTransactions = (0, _util.createDeepEqualSelector)(state => {
  const {
    transactions
  } = state.metamask ?? {};
  if (!(transactions !== null && transactions !== void 0 && transactions.length)) {
    return [];
  }
  return [...transactions].sort((a, b) => a.time - b.time); // Ascending
}, transactions => transactions);
const getAllNetworkTransactions = exports.getAllNetworkTransactions = (0, _util.createDeepEqualSelector)(
// Input Selector: Retrieve all transactions from the state.
getTransactions,
// Output Selector: Filter transactions by popular networks.
transactions => {
  if (!transactions.length) {
    return [];
  }
  return transactions;
});
const getCurrentNetworkTransactions = exports.getCurrentNetworkTransactions = (0, _util.createDeepEqualSelector)(state => {
  const transactions = getTransactions(state);
  if (!transactions.length) {
    return [];
  }
  const {
    chainId
  } = (0, _networks.getProviderConfig)(state);
  return transactions.filter(transaction => transaction.chainId === chainId);
}, transactions => transactions);
const incomingTxListSelectorAllChains = exports.incomingTxListSelectorAllChains = (0, _util.createDeepEqualSelector)(state => {
  const allNetworkTransactions = getAllNetworkTransactions(state);
  const {
    address: selectedAddress
  } = (0, _accounts.getSelectedInternalAccount)(state);
  return allNetworkTransactions.filter(tx => tx.type === _transactionController.TransactionType.incoming && tx.txParams.to === selectedAddress);
}, transactions => transactions);
const getUnapprovedTransactions = exports.getUnapprovedTransactions = (0, _util.createDeepEqualSelector)(state => {
  const transactions = getTransactions(state);
  return (0, _util.filterAndShapeUnapprovedTransactions)(transactions);
}, transactions => transactions);

// Unlike `getUnapprovedTransactions` and `getCurrentNetworkTransactions`
// returns the total number of unapproved transactions on all networks
const getAllUnapprovedTransactions = exports.getAllUnapprovedTransactions = (0, _util.createDeepEqualSelector)(state => {
  const {
    transactions
  } = state.metamask || [];
  if (!(transactions !== null && transactions !== void 0 && transactions.length)) {
    return [];
  }
  const sortedTransactions = [...transactions].sort((a, b) => a.time - b.time);
  return (0, _util.filterAndShapeUnapprovedTransactions)(sortedTransactions);
}, transactions => transactions);
const getApprovedAndSignedTransactions = exports.getApprovedAndSignedTransactions = (0, _util.createDeepEqualSelector)(state => {
  // Fetch transactions across all networks to address a nonce management limitation.
  // This issue arises when a pending transaction exists on one network, and the user initiates another transaction on a different network.
  const transactions = getTransactions(state);
  return transactions.filter(transaction => [_transactionController.TransactionStatus.approved, _transactionController.TransactionStatus.signed].includes(transaction.status));
}, transactions => transactions);
const incomingTxListSelector = exports.incomingTxListSelector = (0, _util.createDeepEqualSelector)(state => {
  const currentNetworkTransactions = getCurrentNetworkTransactions(state);
  const {
    address: selectedAddress
  } = (0, _accounts.getSelectedInternalAccount)(state);
  return currentNetworkTransactions.filter(tx => tx.type === _transactionController.TransactionType.incoming && tx.txParams.to === selectedAddress);
}, transactions => transactions);
const unapprovedPersonalMsgsSelector = state => state.metamask.unapprovedPersonalMsgs;
exports.unapprovedPersonalMsgsSelector = unapprovedPersonalMsgsSelector;
const unapprovedDecryptMsgsSelector = state => state.metamask.unapprovedDecryptMsgs;
exports.unapprovedDecryptMsgsSelector = unapprovedDecryptMsgsSelector;
const unapprovedEncryptionPublicKeyMsgsSelector = state => state.metamask.unapprovedEncryptionPublicKeyMsgs;
exports.unapprovedEncryptionPublicKeyMsgsSelector = unapprovedEncryptionPublicKeyMsgsSelector;
const unapprovedTypedMessagesSelector = state => state.metamask.unapprovedTypedMessages;
exports.unapprovedTypedMessagesSelector = unapprovedTypedMessagesSelector;
const smartTransactionsListSelector = state => {
  var _state$metamask$smart;
  const {
    address: selectedAddress
  } = (0, _accounts.getSelectedInternalAccount)(state);
  return (_state$metamask$smart = state.metamask.smartTransactionsState) === null || _state$metamask$smart === void 0 || (_state$metamask$smart = _state$metamask$smart.smartTransactions) === null || _state$metamask$smart === void 0 || (_state$metamask$smart = _state$metamask$smart[(0, _networks.getCurrentChainId)(state)]) === null || _state$metamask$smart === void 0 ? void 0 : _state$metamask$smart.filter(smartTransaction => {
    var _smartTransaction$txP;
    if (((_smartTransaction$txP = smartTransaction.txParams) === null || _smartTransaction$txP === void 0 ? void 0 : _smartTransaction$txP.from) !== selectedAddress || smartTransaction.confirmed) {
      return false;
    }
    // If a swap or non-swap smart transaction is pending, we want to show it in the Activity list.
    if (smartTransaction.status === _smartTransactionsController.SmartTransactionStatuses.PENDING) {
      return true;
    }
    // In the future we should have the same behavior for Swaps and non-Swaps transactions.
    // For that we need to submit Smart Swaps via the TransactionController as we do for
    // non-Swaps Smart Transactions.
    return (smartTransaction.type === _transactionController.TransactionType.swap || smartTransaction.type === _transactionController.TransactionType.swapApproval) && allowedSwapsSmartTransactionStatusesForActivityList.includes(smartTransaction.status);
  }).map(stx => {
    var _stx$status;
    return {
      ...stx,
      isSmartTransaction: true,
      status: (_stx$status = stx.status) !== null && _stx$status !== void 0 && _stx$status.startsWith('cancelled') ? _transaction.SmartTransactionStatus.cancelled : stx.status
    };
  });
};
exports.smartTransactionsListSelector = smartTransactionsListSelector;
const selectedAddressTxListSelectorAllChain = exports.selectedAddressTxListSelectorAllChain = (0, _reselect.createSelector)(_accounts.getSelectedInternalAccount, getAllNetworkTransactions, smartTransactionsListSelector, (selectedInternalAccount, transactions = [], smTransactions = []) => {
  return transactions.filter(({
    txParams
  }) => txParams.from === selectedInternalAccount.address).filter(({
    type
  }) => type !== _transactionController.TransactionType.incoming).concat(smTransactions);
});
const selectedAddressTxListSelector = exports.selectedAddressTxListSelector = (0, _reselect.createSelector)(_accounts.getSelectedInternalAccount, getCurrentNetworkTransactions, smartTransactionsListSelector, (selectedInternalAccount, transactions = [], smTransactions = []) => {
  return transactions.filter(({
    txParams
  }) => txParams.from === selectedInternalAccount.address).filter(({
    type
  }) => type !== _transactionController.TransactionType.incoming).concat(smTransactions);
});
const unapprovedMessagesSelector = exports.unapprovedMessagesSelector = (0, _reselect.createSelector)(unapprovedPersonalMsgsSelector, unapprovedDecryptMsgsSelector, unapprovedEncryptionPublicKeyMsgsSelector, unapprovedTypedMessagesSelector, _networks.getCurrentChainId, (unapprovedPersonalMsgs = {}, unapprovedDecryptMsgs = {}, unapprovedEncryptionPublicKeyMsgs = {}, unapprovedTypedMessages = {}, chainId) => (0, _txHelper.default)({}, unapprovedPersonalMsgs, unapprovedDecryptMsgs, unapprovedEncryptionPublicKeyMsgs, unapprovedTypedMessages, chainId) || []);
const transactionSubSelectorAllChains = exports.transactionSubSelectorAllChains = (0, _reselect.createSelector)(unapprovedMessagesSelector, incomingTxListSelectorAllChains, (unapprovedMessages = [], incomingTxList = []) => {
  return unapprovedMessages.concat(incomingTxList);
});
const transactionSubSelector = exports.transactionSubSelector = (0, _reselect.createSelector)(unapprovedMessagesSelector, incomingTxListSelector, (unapprovedMessages = [], incomingTxList = []) => {
  return unapprovedMessages.concat(incomingTxList);
});
const transactionsSelector = exports.transactionsSelector = (0, _reselect.createSelector)(transactionSubSelector, selectedAddressTxListSelector, (subSelectorTxList = [], selectedAddressTxList = []) => {
  const txsToRender = selectedAddressTxList.concat(subSelectorTxList);
  return [...txsToRender].sort((a, b) => b.time - a.time);
});
const transactionsSelectorAllChains = exports.transactionsSelectorAllChains = (0, _reselect.createSelector)(transactionSubSelectorAllChains, selectedAddressTxListSelectorAllChain, (subSelectorTxList = [], selectedAddressTxList = []) => {
  const txsToRender = selectedAddressTxList.concat(subSelectorTxList);
  return [...txsToRender].sort((a, b) => b.time - a.time);
});

/**
 * @name insertOrderedNonce
 * @private
 * @description Inserts (mutates) a nonce into an array of ordered nonces, sorted in ascending
 * order.
 * @param {string[]} nonces - Array of nonce strings in hex
 * @param {string} nonceToInsert - Nonce string in hex to be inserted into the array of nonces.
 */
const insertOrderedNonce = (nonces, nonceToInsert) => {
  let insertIndex = nonces.length;
  for (let i = 0; i < nonces.length; i++) {
    const nonce = nonces[i];
    if (Number((0, _conversion.hexToDecimal)(nonce.split('-')[0])) > Number((0, _conversion.hexToDecimal)(nonceToInsert.split('-')[0]))) {
      insertIndex = i;
      break;
    }
  }
  nonces.splice(insertIndex, 0, nonceToInsert);
};

/**
 * @name insertTransactionByTime
 * @private
 * @description Inserts (mutates) a transaction object into an array of ordered transactions, sorted
 * in ascending order by time.
 * @param {object[]} transactions - Array of transaction objects.
 * @param {object} transaction - Transaction object to be inserted into the array of transactions.
 */
const insertTransactionByTime = (transactions, transaction) => {
  const {
    time
  } = transaction;
  let insertIndex = transactions.length;
  for (let i = 0; i < transactions.length; i++) {
    const tx = transactions[i];
    if (tx.time > time) {
      insertIndex = i;
      break;
    }
  }
  transactions.splice(insertIndex, 0, transaction);
};

/**
 * Contains transactions and properties associated with those transactions of the same nonce.
 *
 * @typedef {object} transactionGroup
 * @property {string} nonce - The nonce that the transactions within this transactionGroup share.
 * @property {object[]} transactions - An array of transaction (txMeta) objects.
 * @property {object} initialTransaction - The transaction (txMeta) with the lowest "time".
 * @property {object} primaryTransaction - Either the latest transaction or the confirmed
 * transaction.
 * @property {boolean} hasRetried - True if a transaction in the group was a retry transaction.
 * @property {boolean} hasCancelled - True if a transaction in the group was a cancel transaction.
 */

/**
 * @name insertTransactionGroupByTime
 * @private
 * @description Inserts (mutates) a transactionGroup object into an array of ordered
 * transactionGroups, sorted in ascending order by nonce.
 * @param {transactionGroup[]} transactionGroups - Array of transactionGroup objects.
 * @param {transactionGroup} transactionGroup - transactionGroup object to be inserted into the
 * array of transactionGroups.
 */
const insertTransactionGroupByTime = (transactionGroups, transactionGroup) => {
  const {
    primaryTransaction: {
      time: groupToInsertTime
    } = {}
  } = transactionGroup;
  let insertIndex = transactionGroups.length;
  for (let i = 0; i < transactionGroups.length; i++) {
    const txGroup = transactionGroups[i];
    const {
      primaryTransaction: {
        time
      } = {}
    } = txGroup;
    if (time > groupToInsertTime) {
      insertIndex = i;
      break;
    }
  }
  transactionGroups.splice(insertIndex, 0, transactionGroup);
};

/**
 * @name mergeNonNonceTransactionGroups
 * @private
 * @description Inserts (mutates) transactionGroups that are not to be ordered by nonce into an array
 * of nonce-ordered transactionGroups by time.
 * @param {transactionGroup[]} orderedTransactionGroups - Array of transactionGroups ordered by
 * nonce.
 * @param {transactionGroup[]} nonNonceTransactionGroups - Array of transactionGroups not intended to be ordered by nonce,
 * but intended to be ordered by timestamp
 */
const mergeNonNonceTransactionGroups = (orderedTransactionGroups, nonNonceTransactionGroups) => {
  nonNonceTransactionGroups.forEach(transactionGroup => {
    insertTransactionGroupByTime(orderedTransactionGroups, transactionGroup);
  });
};
const groupAndSortTransactionsByNonce = transactions => {
  const unapprovedTransactionGroups = [];
  const incomingTransactionGroups = [];
  const orderedNonces = [];
  const nonceToTransactionsMap = {};
  transactions.forEach(transaction => {
    const {
      networkClientId,
      txParams: {
        nonce
      } = {},
      status,
      type,
      time: txTime,
      txReceipt
    } = transaction;
    const nonceNetworkKey = `${nonce}-${networkClientId}`;
    // Don't group transactions by nonce if:
    // 1. Tx nonce is undefined
    // 2. Tx is incoming (deposit)
    const shouldNotBeGrouped = typeof nonce === 'undefined' || type === _transactionController.TransactionType.incoming;
    if (shouldNotBeGrouped) {
      const transactionGroup = {
        transactions: [transaction],
        initialTransaction: transaction,
        primaryTransaction: transaction,
        hasRetried: false,
        hasCancelled: false,
        nonce
      };
      if (type === _transactionController.TransactionType.incoming) {
        incomingTransactionGroups.push(transactionGroup);
      } else {
        insertTransactionGroupByTime(unapprovedTransactionGroups, transactionGroup);
      }
    } else if (nonceNetworkKey in nonceToTransactionsMap) {
      var _nonceProps$primaryTr, _nonceProps$initialTr;
      const nonceProps = nonceToTransactionsMap[nonceNetworkKey];
      insertTransactionByTime(nonceProps.transactions, transaction);
      const {
        primaryTransaction: {
          time: primaryTxTime = 0
        } = {},
        initialTransaction: {
          time: initialTxTime = 0
        } = {}
      } = nonceProps;
      const currentTransaction = {
        // A on-chain failure means the current transaction was submitted and
        // considered for inclusion in a block but something prevented it
        // from being included, such as slippage on gas prices and conversion
        // when doing a swap. These transactions will have a '0x0' value in
        // the txReceipt.status field.
        isOnChainFailure: (txReceipt === null || txReceipt === void 0 ? void 0 : txReceipt.status) === '0x0',
        // Another type of failure is a "off chain" or "network" failure,
        // where the error occurs on the JSON RPC call to the network client
        // (Like Infura). These transactions are never broadcast for
        // inclusion and the nonce associated with them is not consumed. When
        // this occurs  the next transaction will have the same nonce as the
        // current, failed transaction. A failed on chain transaction will
        // not have the FAILED status although it should (future TODO: add a
        // new FAILED_ON_CHAIN) status. I use the word "Ephemeral" here
        // because a failed transaction that does not get broadcast is not
        // known outside of the user's local MetaMask and the nonce
        // associated will be applied to the next.
        isEphemeral: status === _transactionController.TransactionStatus.failed && (txReceipt === null || txReceipt === void 0 ? void 0 : txReceipt.status) !== '0x0',
        // We never want to use a speed up (retry) or cancel as the initial
        // transaction in a group, regardless of time order. This is because
        // useTransactionDisplayData cannot parse a retry or cancel because
        // it lacks information on whether it's a simple send, token transfer,
        // etc.
        isRetryOrCancel: INVALID_INITIAL_TRANSACTION_TYPES.includes(type),
        // Primary transactions usually are the latest transaction by time,
        // but not always. This value shows whether this transaction occurred
        // after the current primary.
        occurredAfterPrimary: txTime > primaryTxTime,
        // Priority Statuses are those that are either already confirmed
        // on-chain, submitted to the network, or waiting for user approval.
        // These statuses typically indicate a transaction that needs to have
        // its status reflected in the UI.
        hasPriorityStatus: status in _transactions.PRIORITY_STATUS_HASH,
        // A confirmed transaction is the most valid transaction status to
        // display because no other transaction of the same nonce can have a
        // more valid status.
        isConfirmed: status === _transactionController.TransactionStatus.confirmed,
        // Initial transactions usually are the earliest transaction by time,
        // but not always. This value shows whether this transaction occurred
        // before the current initial.
        occurredBeforeInitial: txTime < initialTxTime,
        // We only allow users to retry the transaction in certain scenarios
        // to help shield from expensive operations and other unwanted side
        // effects. This value is used to determine if the entire transaction
        // group should be marked as having had a retry.
        isValidRetry: type === _transactionController.TransactionType.retry && (status in _transactions.PRIORITY_STATUS_HASH || status === _transactionController.TransactionStatus.dropped),
        // We only allow users to cancel the transaction in certain scenarios
        // to help shield from expensive operations and other unwanted side
        // effects. This value is used to determine if the entire transaction
        // group should be marked as having had a cancel.
        isValidCancel: type === _transactionController.TransactionType.cancel && (status in _transactions.PRIORITY_STATUS_HASH || status === _transactionController.TransactionStatus.dropped),
        eligibleForInitial: !INVALID_INITIAL_TRANSACTION_TYPES.includes(type) && status !== _transactionController.TransactionStatus.failed,
        shouldBePrimary: status === _transactionController.TransactionStatus.confirmed || (txReceipt === null || txReceipt === void 0 ? void 0 : txReceipt.status) === '0x0'
      };
      const previousPrimaryTransaction = {
        isEphemeral: nonceProps.primaryTransaction.status === _transactionController.TransactionStatus.failed && ((_nonceProps$primaryTr = nonceProps.primaryTransaction) === null || _nonceProps$primaryTr === void 0 || (_nonceProps$primaryTr = _nonceProps$primaryTr.txReceipt) === null || _nonceProps$primaryTr === void 0 ? void 0 : _nonceProps$primaryTr.status) !== '0x0'
      };
      const previousInitialTransaction = {
        isEphemeral: nonceProps.initialTransaction.status === _transactionController.TransactionStatus.failed && ((_nonceProps$initialTr = nonceProps.initialTransaction.txReceipt) === null || _nonceProps$initialTr === void 0 ? void 0 : _nonceProps$initialTr.status) !== '0x0'
      };
      if (currentTransaction.shouldBePrimary || previousPrimaryTransaction.isEphemeral || currentTransaction.occurredAfterPrimary && currentTransaction.hasPriorityStatus) {
        nonceProps.primaryTransaction = transaction;
      }
      if (currentTransaction.occurredBeforeInitial && currentTransaction.eligibleForInitial || previousInitialTransaction.isEphemeral && currentTransaction.eligibleForInitial) {
        nonceProps.initialTransaction = transaction;
      }
      if (currentTransaction.isValidRetry) {
        nonceProps.hasRetried = true;
      }
      if (currentTransaction.isValidCancel) {
        nonceProps.hasCancelled = true;
      }
    } else {
      nonceToTransactionsMap[nonceNetworkKey] = {
        nonce,
        transactions: [transaction],
        initialTransaction: transaction,
        primaryTransaction: transaction,
        hasRetried: type === _transactionController.TransactionType.retry && (status in _transactions.PRIORITY_STATUS_HASH || status === _transactionController.TransactionStatus.dropped),
        hasCancelled: type === _transactionController.TransactionType.cancel && (status in _transactions.PRIORITY_STATUS_HASH || status === _transactionController.TransactionStatus.dropped)
      };
      insertOrderedNonce(orderedNonces, nonceNetworkKey);
    }
  });
  const orderedTransactionGroups = orderedNonces.map(nonce => nonceToTransactionsMap[nonce]);
  mergeNonNonceTransactionGroups(orderedTransactionGroups, incomingTransactionGroups);
  return unapprovedTransactionGroups.concat(orderedTransactionGroups).map(txGroup => {
    var _txGroup$initialTrans;
    if (INVALID_INITIAL_TRANSACTION_TYPES.includes((_txGroup$initialTrans = txGroup.initialTransaction) === null || _txGroup$initialTrans === void 0 ? void 0 : _txGroup$initialTrans.type)) {
      const nonRetryOrCancel = txGroup.transactions.find(tx => !INVALID_INITIAL_TRANSACTION_TYPES.includes(tx.type));
      if (nonRetryOrCancel) {
        return {
          ...txGroup,
          initialTransaction: nonRetryOrCancel
        };
      }
    }
    return txGroup;
  });
};

/**
 * @name nonceSortedTransactionsSelector
 * @description Returns an array of transactionGroups sorted by nonce in ascending order.
 * @returns {transactionGroup[]}
 */
exports.groupAndSortTransactionsByNonce = groupAndSortTransactionsByNonce;
const nonceSortedTransactionsSelector = exports.nonceSortedTransactionsSelector = (0, _reselect.createSelector)(transactionsSelector, (transactions = []) => groupAndSortTransactionsByNonce(transactions));

/**
 * @name nonceSortedTransactionsSelectorAllChains
 * @description Returns an array of transactionGroups sorted by nonce in ascending order.
 * @returns {transactionGroup[]}
 */
const nonceSortedTransactionsSelectorAllChains = exports.nonceSortedTransactionsSelectorAllChains = (0, _reselect.createSelector)(transactionsSelectorAllChains, (transactions = []) => groupAndSortTransactionsByNonce(transactions));

/**
 * @name nonceSortedPendingTransactionsSelectorAllChains
 * @description Returns an array of transactionGroups where transactions are still pending sorted by
 * nonce in descending order for all chains.
 * @returns {transactionGroup[]}
 */
const nonceSortedPendingTransactionsSelectorAllChains = exports.nonceSortedPendingTransactionsSelectorAllChains = (0, _reselect.createSelector)(nonceSortedTransactionsSelectorAllChains, (transactions = []) => transactions.filter(({
  primaryTransaction
}) => primaryTransaction.status in _transactions.PENDING_STATUS_HASH));

/**
 * @name nonceSortedCompletedTransactionsSelectorAllChains
 * @description Returns an array of transactionGroups where transactions are confirmed sorted by
 * nonce in descending order for all chains.
 * @returns {transactionGroup[]}
 */
const nonceSortedCompletedTransactionsSelectorAllChains = exports.nonceSortedCompletedTransactionsSelectorAllChains = (0, _reselect.createSelector)(nonceSortedTransactionsSelectorAllChains, (transactions = []) => transactions.filter(({
  primaryTransaction
}) => !(primaryTransaction.status in _transactions.PENDING_STATUS_HASH)).reverse());

/**
 * @name nonceSortedPendingTransactionsSelector
 * @description Returns an array of transactionGroups where transactions are still pending sorted by
 * nonce in descending order.
 * @returns {transactionGroup[]}
 */
const nonceSortedPendingTransactionsSelector = exports.nonceSortedPendingTransactionsSelector = (0, _reselect.createSelector)(nonceSortedTransactionsSelector, (transactions = []) => transactions.filter(({
  primaryTransaction
}) => primaryTransaction.status in _transactions.PENDING_STATUS_HASH));

/**
 * @name nonceSortedCompletedTransactionsSelector
 * @description Returns an array of transactionGroups where transactions are confirmed sorted by
 * nonce in descending order.
 * @returns {transactionGroup[]}
 */
const nonceSortedCompletedTransactionsSelector = exports.nonceSortedCompletedTransactionsSelector = (0, _reselect.createSelector)(nonceSortedTransactionsSelector, (transactions = []) => transactions.filter(({
  primaryTransaction
}) => !(primaryTransaction.status in _transactions.PENDING_STATUS_HASH)).reverse());
const submittedPendingTransactionsSelector = exports.submittedPendingTransactionsSelector = (0, _reselect.createSelector)(transactionsSelector, (transactions = []) => transactions.filter(transaction => transaction.status === _transactionController.TransactionStatus.submitted));
const TRANSACTION_APPROVAL_TYPES = [_controllerUtils.ApprovalType.EthDecrypt, _controllerUtils.ApprovalType.EthGetEncryptionPublicKey, _controllerUtils.ApprovalType.EthSignTypedData, _controllerUtils.ApprovalType.PersonalSign];
function hasTransactionPendingApprovals(state) {
  const unapprovedTxRequests = (0, _approvals.getApprovalRequestsByType)(state, _controllerUtils.ApprovalType.Transaction);
  return unapprovedTxRequests.length > 0 || (0, _approvals.hasPendingApprovals)(state, TRANSACTION_APPROVAL_TYPES);
}
function selectTransactionMetadata(state, transactionId) {
  return state.metamask.transactions.find(transaction => transaction.id === transactionId);
}
const selectTransactionSender = exports.selectTransactionSender = (0, _reselect.createSelector)((state, transactionId) => selectTransactionMetadata(state, transactionId), transaction => {
  var _transaction$txParams;
  return transaction === null || transaction === void 0 || (_transaction$txParams = transaction.txParams) === null || _transaction$txParams === void 0 ? void 0 : _transaction$txParams.from;
});

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\selectors\\transactions.js",}],
["D:\\code\\v\\metamask-extension\\ui\\store\\actionConstants.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cstore%5CactionConstants.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOGGLE_CURRENCY_INPUT_SWITCH = exports.TOGGLE_ACCOUNT_MENU = exports.SHOW_SETTINGS_PAGE_ERROR = exports.SHOW_SEND_TOKEN_PAGE = exports.SHOW_PRIVATE_KEY = exports.SHOW_PERMITTED_NETWORK_TOAST_OPEN = exports.SHOW_PERMITTED_NETWORK_TOAST_CLOSE = exports.SHOW_NFT_STILL_FETCHING_INDICATION = exports.SHOW_NFT_DETECTION_ENABLEMENT_TOAST = exports.SHOW_LOADING = exports.SHOW_KEYRING_SNAP_REMOVAL_RESULT = exports.SHOW_IPFS_MODAL_OPEN = exports.SHOW_IPFS_MODAL_CLOSE = exports.SHOW_CONF_TX_PAGE = exports.SHOW_BASIC_FUNCTIONALITY_MODAL_OPEN = exports.SHOW_BASIC_FUNCTIONALITY_MODAL_CLOSE = exports.SHOW_ACCOUNTS_PAGE = exports.SET_WEBHID_CONNECTED_STATUS = exports.SET_SMART_TRANSACTIONS_ERROR = exports.SET_SLIDES = exports.SET_SHOW_SUPPORT_DATA_CONSENT_MODAL = exports.SET_SHOW_SHIELD_ENTRY_MODAL_ONCE = exports.SET_SHOW_PASSWORD_CHANGE_TOAST = exports.SET_SHOW_NFT_AUTO_DETECT_MODAL_UPGRADE = exports.SET_SHOW_NEW_SRP_ADDED_TOAST = exports.SET_SHOW_COPY_ADDRESS_TOAST = exports.SET_SHOW_CONNECTIONS_REMOVED = exports.SET_SHOW_CLAIM_SUBMIT_TOAST = exports.SET_SELECTED_NETWORK_CONFIGURATION_ID = exports.SET_SELECTED_NETWORKS_FOR_DAPP_CONNECTIONS = exports.SET_SELECTED_ACCOUNTS_FOR_DAPP_CONNECTIONS = exports.SET_REQUEST_ACCOUNT_TABS = exports.SET_REMOVE_NFT_MESSAGE = exports.SET_PENDING_TOKENS = exports.SET_PARTICIPATE_IN_METAMETRICS = exports.SET_OPEN_METAMASK_TAB_IDS = exports.SET_NEXT_NONCE = exports.SET_NEW_TOKENS_IMPORTED_ERROR = exports.SET_NEW_TOKENS_IMPORTED = exports.SET_NEW_NFT_ADDED_MESSAGE = exports.SET_NEW_NETWORK_ADDED = exports.SET_LEDGER_TRANSPORT_STATUS = exports.SET_HARDWARE_WALLET_DEFAULT_HD_PATH = exports.SET_FIRST_TIME_FLOW_TYPE = exports.SET_EDIT_NETWORK = exports.SET_DATA_COLLECTION_FOR_MARKETING = exports.SET_CUSTOM_TOKEN_AMOUNT = exports.SET_CURRENT_LOCALE = exports.SET_CONFIRMATION_EXCHANGE_RATES = exports.SET_ACCOUNT_LABEL = exports.SET_ACCOUNT_DETAILS_ADDRESS = exports.SELECTED_ADDRESS_CHANGED = exports.SELECTED_ACCOUNT_CHANGED = exports.RESET_SOCIAL_LOGIN_ONBOARDING = exports.RESET_ONBOARDING = exports.QR_CODE_DETECTED = exports.ONBOARDING_TOGGLE_BASIC_FUNCTIONALITY_ON = exports.ONBOARDING_TOGGLE_BASIC_FUNCTIONALITY_OFF = exports.ONBOARDED_IN_THIS_UI_SESSION = exports.NETWORK_DROPDOWN_OPEN = exports.NETWORK_DROPDOWN_CLOSE = exports.MODAL_OPEN = exports.MODAL_CLOSE = exports.LOCK_METAMASK = exports.LOADING_METHOD_DATA_STARTED = exports.LOADING_METHOD_DATA_FINISHED = exports.IMPORT_TOKENS_POPOVER_OPEN = exports.IMPORT_TOKENS_POPOVER_CLOSE = exports.IMPORT_NFTS_MODAL_OPEN = exports.IMPORT_NFTS_MODAL_CLOSE = exports.HIDE_WHATS_NEW_POPUP = exports.HIDE_WARNING = exports.HIDE_SETTINGS_PAGE_ERROR = exports.HIDE_NFT_STILL_FETCHING_INDICATION = exports.HIDE_LOADING = exports.HIDE_KEYRING_SNAP_REMOVAL_RESULT = exports.GO_HOME = exports.GAS_FEE_ESTIMATES_UPDATED = exports.DISPLAY_WARNING = exports.DISMISS_SMART_TRANSACTIONS_ERROR_MESSAGE = exports.DEPRECATED_NETWORK_POPOVER_OPEN = exports.DEPRECATED_NETWORK_POPOVER_CLOSE = exports.DELETE_METAMETRICS_DATA_MODAL_OPEN = exports.DELETE_METAMETRICS_DATA_MODAL_CLOSE = exports.DATA_DELETION_ERROR_MODAL_OPEN = exports.DATA_DELETION_ERROR_MODAL_CLOSE = exports.CONNECT_ACCOUNTS_MODAL_OPEN = exports.CONNECT_ACCOUNTS_MODAL_CLOSE = exports.COMPLETE_ONBOARDING = exports.COMPLETED_TX = exports.CLOSE_WELCOME_SCREEN = exports.CLEAR_SWAP_AND_SEND_STATE = exports.CLEAR_PENDING_TOKENS = exports.CLEAR_ACCOUNT_DETAILS = exports.CHAIN_CHANGED = exports.CAPTURE_SINGLE_EXCEPTION = exports.ALERT_OPEN = exports.ALERT_CLOSE = exports.ADDRESS_BOOK_UPDATED = exports.ACCOUNT_CHANGED = void 0;
exports.UPDATE_TRANSACTION_PARAMS = exports.UPDATE_METAMASK_STATE = exports.UPDATE_CUSTOM_NONCE = exports.UNLOCK_SUCCEEDED = exports.UNLOCK_IN_PROGRESS = exports.UNLOCK_FAILED = exports.TRANSACTION_ERROR = exports.TOKEN_SORT_CRITERIA = exports.TOGGLE_NETWORK_MENU = exports.TOGGLE_GAS_LOADING_ANIMATION = void 0;
const GO_HOME = exports.GO_HOME = 'GO_HOME';
// modal state
const MODAL_OPEN = exports.MODAL_OPEN = 'UI_MODAL_OPEN';
const MODAL_CLOSE = exports.MODAL_CLOSE = 'UI_MODAL_CLOSE';
const SET_CONFIRMATION_EXCHANGE_RATES = exports.SET_CONFIRMATION_EXCHANGE_RATES = 'SET_CONFIRMATION_EXCHANGE_RATES';
// alert state
const ALERT_OPEN = exports.ALERT_OPEN = 'UI_ALERT_OPEN';
const ALERT_CLOSE = exports.ALERT_CLOSE = 'UI_ALERT_CLOSE';
const QR_CODE_DETECTED = exports.QR_CODE_DETECTED = 'UI_QR_CODE_DETECTED';
// network dropdown open
const NETWORK_DROPDOWN_OPEN = exports.NETWORK_DROPDOWN_OPEN = 'UI_NETWORK_DROPDOWN_OPEN';
const NETWORK_DROPDOWN_CLOSE = exports.NETWORK_DROPDOWN_CLOSE = 'UI_NETWORK_DROPDOWN_CLOSE';
const IMPORT_NFTS_MODAL_OPEN = exports.IMPORT_NFTS_MODAL_OPEN = 'UI_IMPORT_NFTS_MODAL_OPEN';
const IMPORT_NFTS_MODAL_CLOSE = exports.IMPORT_NFTS_MODAL_CLOSE = 'UI_IMPORT_NFTS_MODAL_CLOSE';
const SHOW_IPFS_MODAL_OPEN = exports.SHOW_IPFS_MODAL_OPEN = 'UI_IPFS_MODAL_OPEN';
const SHOW_PERMITTED_NETWORK_TOAST_OPEN = exports.SHOW_PERMITTED_NETWORK_TOAST_OPEN = 'UI_PERMITTED_NETWORK_TOAST_OPEN';
const SHOW_PERMITTED_NETWORK_TOAST_CLOSE = exports.SHOW_PERMITTED_NETWORK_TOAST_CLOSE = 'UI_PERMITTED_NETWORK_TOAST_CLOSE';
const SHOW_IPFS_MODAL_CLOSE = exports.SHOW_IPFS_MODAL_CLOSE = 'UI_IPFS_MODAL_CLOSE';
const IMPORT_TOKENS_POPOVER_OPEN = exports.IMPORT_TOKENS_POPOVER_OPEN = 'UI_IMPORT_TOKENS_POPOVER_OPEN';
const IMPORT_TOKENS_POPOVER_CLOSE = exports.IMPORT_TOKENS_POPOVER_CLOSE = 'UI_IMPORT_TOKENS_POPOVER_CLOSE';
const SHOW_BASIC_FUNCTIONALITY_MODAL_OPEN = exports.SHOW_BASIC_FUNCTIONALITY_MODAL_OPEN = 'SHOW_BASIC_FUNCTIONALITY_MODAL_OPEN';
const SHOW_BASIC_FUNCTIONALITY_MODAL_CLOSE = exports.SHOW_BASIC_FUNCTIONALITY_MODAL_CLOSE = 'SHOW_BASIC_FUNCTIONALITY_MODAL_CLOSE';
const ONBOARDING_TOGGLE_BASIC_FUNCTIONALITY_ON = exports.ONBOARDING_TOGGLE_BASIC_FUNCTIONALITY_ON = 'ONBOARDING_TOGGLE_BASIC_FUNCTIONALITY_ON';
const ONBOARDING_TOGGLE_BASIC_FUNCTIONALITY_OFF = exports.ONBOARDING_TOGGLE_BASIC_FUNCTIONALITY_OFF = 'ONBOARDING_TOGGLE_BASIC_FUNCTIONALITY_OFF';

// remote state
const UPDATE_METAMASK_STATE = exports.UPDATE_METAMASK_STATE = 'UPDATE_METAMASK_STATE';
const SELECTED_ADDRESS_CHANGED = exports.SELECTED_ADDRESS_CHANGED = 'SELECTED_ADDRESS_CHANGED';
const SELECTED_ACCOUNT_CHANGED = exports.SELECTED_ACCOUNT_CHANGED = 'SELECTED_ACCOUNT_CHANGED';
const ACCOUNT_CHANGED = exports.ACCOUNT_CHANGED = 'ACCOUNT_CHANGED';
const CHAIN_CHANGED = exports.CHAIN_CHANGED = 'CHAIN_CHANGED';
const ADDRESS_BOOK_UPDATED = exports.ADDRESS_BOOK_UPDATED = 'ADDRESS_BOOK_UPDATED';
const GAS_FEE_ESTIMATES_UPDATED = exports.GAS_FEE_ESTIMATES_UPDATED = 'GAS_FEE_ESTIMATES_UPDATED';
const CLOSE_WELCOME_SCREEN = exports.CLOSE_WELCOME_SCREEN = 'CLOSE_WELCOME_SCREEN';
// send state
const CLEAR_SWAP_AND_SEND_STATE = exports.CLEAR_SWAP_AND_SEND_STATE = 'CLEAR_SWAP_AND_SEND_STATE';
// unlock screen
const UNLOCK_IN_PROGRESS = exports.UNLOCK_IN_PROGRESS = 'UNLOCK_IN_PROGRESS';
const UNLOCK_FAILED = exports.UNLOCK_FAILED = 'UNLOCK_FAILED';
const UNLOCK_SUCCEEDED = exports.UNLOCK_SUCCEEDED = 'UNLOCK_SUCCEEDED';
const LOCK_METAMASK = exports.LOCK_METAMASK = 'LOCK_METAMASK';
// error handling
const DISPLAY_WARNING = exports.DISPLAY_WARNING = 'DISPLAY_WARNING';
const HIDE_WARNING = exports.HIDE_WARNING = 'HIDE_WARNING';
const SHOW_SETTINGS_PAGE_ERROR = exports.SHOW_SETTINGS_PAGE_ERROR = 'SHOW_SETTINGS_PAGE_ERROR';
const HIDE_SETTINGS_PAGE_ERROR = exports.HIDE_SETTINGS_PAGE_ERROR = 'HIDE_SETTINGS_PAGE_ERROR';
const CAPTURE_SINGLE_EXCEPTION = exports.CAPTURE_SINGLE_EXCEPTION = 'CAPTURE_SINGLE_EXCEPTION';
// accounts screen
const SHOW_ACCOUNTS_PAGE = exports.SHOW_ACCOUNTS_PAGE = 'SHOW_ACCOUNTS_PAGE';
const SHOW_CONF_TX_PAGE = exports.SHOW_CONF_TX_PAGE = 'SHOW_CONF_TX_PAGE';
// account detail screen
const SHOW_SEND_TOKEN_PAGE = exports.SHOW_SEND_TOKEN_PAGE = 'SHOW_SEND_TOKEN_PAGE';
const SHOW_PRIVATE_KEY = exports.SHOW_PRIVATE_KEY = 'SHOW_PRIVATE_KEY';
const SET_ACCOUNT_LABEL = exports.SET_ACCOUNT_LABEL = 'SET_ACCOUNT_LABEL';
const CLEAR_ACCOUNT_DETAILS = exports.CLEAR_ACCOUNT_DETAILS = 'CLEAR_ACCOUNT_DETAILS';
const SET_ACCOUNT_DETAILS_ADDRESS = exports.SET_ACCOUNT_DETAILS_ADDRESS = 'SET_ACCOUNT_DETAILS_ADDRESS';
// tx conf screen
const COMPLETED_TX = exports.COMPLETED_TX = 'COMPLETED_TX';
const TRANSACTION_ERROR = exports.TRANSACTION_ERROR = 'TRANSACTION_ERROR';
const UPDATE_TRANSACTION_PARAMS = exports.UPDATE_TRANSACTION_PARAMS = 'UPDATE_TRANSACTION_PARAMS';
const SET_NEXT_NONCE = exports.SET_NEXT_NONCE = 'SET_NEXT_NONCE';
// config screen
const SET_HARDWARE_WALLET_DEFAULT_HD_PATH = exports.SET_HARDWARE_WALLET_DEFAULT_HD_PATH = 'SET_HARDWARE_WALLET_DEFAULT_HD_PATH';
// loading overlay
const SHOW_LOADING = exports.SHOW_LOADING = 'SHOW_LOADING_INDICATION';
const HIDE_LOADING = exports.HIDE_LOADING = 'HIDE_LOADING_INDICATION';

// Nft still fetching indication spinners
const SHOW_NFT_STILL_FETCHING_INDICATION = exports.SHOW_NFT_STILL_FETCHING_INDICATION = 'SHOW_NFT_STILL_FETCHING_INDICATION';
const HIDE_NFT_STILL_FETCHING_INDICATION = exports.HIDE_NFT_STILL_FETCHING_INDICATION = 'HIDE_NFT_STILL_FETCHING_INDICATION';
const SHOW_NFT_DETECTION_ENABLEMENT_TOAST = exports.SHOW_NFT_DETECTION_ENABLEMENT_TOAST = 'SHOW_NFT_DETECTION_ENABLEMENT_TOAST';
const TOGGLE_ACCOUNT_MENU = exports.TOGGLE_ACCOUNT_MENU = 'TOGGLE_ACCOUNT_MENU';
const TOGGLE_NETWORK_MENU = exports.TOGGLE_NETWORK_MENU = 'TOGGLE_NETWORK_MENU';
const SET_SELECTED_ACCOUNTS_FOR_DAPP_CONNECTIONS = exports.SET_SELECTED_ACCOUNTS_FOR_DAPP_CONNECTIONS = 'SET_SELECTED_ACCOUNTS_FOR_DAPP_CONNECTIONS';
const SET_SELECTED_NETWORKS_FOR_DAPP_CONNECTIONS = exports.SET_SELECTED_NETWORKS_FOR_DAPP_CONNECTIONS = 'SET_SELECTED_NETWORKS_FOR_DAPP_CONNECTIONS';

// deprecated network modal
const DEPRECATED_NETWORK_POPOVER_OPEN = exports.DEPRECATED_NETWORK_POPOVER_OPEN = 'DEPRECATED_NETWORK_POPOVER_OPEN';
const DEPRECATED_NETWORK_POPOVER_CLOSE = exports.DEPRECATED_NETWORK_POPOVER_CLOSE = 'DEPRECATED_NETWORK_POPOVER_CLOSE';

// preferences
const UPDATE_CUSTOM_NONCE = exports.UPDATE_CUSTOM_NONCE = 'UPDATE_CUSTOM_NONCE';
const SET_PARTICIPATE_IN_METAMETRICS = exports.SET_PARTICIPATE_IN_METAMETRICS = 'SET_PARTICIPATE_IN_METAMETRICS';
const SET_DATA_COLLECTION_FOR_MARKETING = exports.SET_DATA_COLLECTION_FOR_MARKETING = 'SET_DATA_COLLECTION_FOR_MARKETING';
const DELETE_METAMETRICS_DATA_MODAL_OPEN = exports.DELETE_METAMETRICS_DATA_MODAL_OPEN = 'DELETE_METAMETRICS_DATA_MODAL_OPEN';
const DELETE_METAMETRICS_DATA_MODAL_CLOSE = exports.DELETE_METAMETRICS_DATA_MODAL_CLOSE = 'DELETE_METAMETRICS_DATA_MODAL_CLOSE';
const DATA_DELETION_ERROR_MODAL_OPEN = exports.DATA_DELETION_ERROR_MODAL_OPEN = 'DELETE_METAMETRICS_DATA_ERROR_MODAL_OPEN';
const DATA_DELETION_ERROR_MODAL_CLOSE = exports.DATA_DELETION_ERROR_MODAL_CLOSE = 'DELETE_METAMETRICS_DATA_ERROR_MODAL_CLOSE';

// locale
const SET_CURRENT_LOCALE = exports.SET_CURRENT_LOCALE = 'SET_CURRENT_LOCALE';

// Onboarding

const COMPLETE_ONBOARDING = exports.COMPLETE_ONBOARDING = 'COMPLETE_ONBOARDING';
const RESET_ONBOARDING = exports.RESET_ONBOARDING = 'RESET_ONBOARDING';
const ONBOARDED_IN_THIS_UI_SESSION = exports.ONBOARDED_IN_THIS_UI_SESSION = 'ONBOARDED_IN_THIS_UI_SESSION';

// social login onboarding
const RESET_SOCIAL_LOGIN_ONBOARDING = exports.RESET_SOCIAL_LOGIN_ONBOARDING = 'RESET_SOCIAL_LOGIN_ONBOARDING';

// Ledger

const SET_WEBHID_CONNECTED_STATUS = exports.SET_WEBHID_CONNECTED_STATUS = 'SET_WEBHID_CONNECTED_STATUS';
const SET_LEDGER_TRANSPORT_STATUS = exports.SET_LEDGER_TRANSPORT_STATUS = 'SET_LEDGER_TRANSPORT_STATUS';

// Network
const SET_PENDING_TOKENS = exports.SET_PENDING_TOKENS = 'SET_PENDING_TOKENS';
const CLEAR_PENDING_TOKENS = exports.CLEAR_PENDING_TOKENS = 'CLEAR_PENDING_TOKENS';
const SET_FIRST_TIME_FLOW_TYPE = exports.SET_FIRST_TIME_FLOW_TYPE = 'SET_FIRST_TIME_FLOW_TYPE';
const SET_SELECTED_NETWORK_CONFIGURATION_ID = exports.SET_SELECTED_NETWORK_CONFIGURATION_ID = 'SET_SELECTED_NETWORK_CONFIGURATION_ID';
const SET_NEW_NETWORK_ADDED = exports.SET_NEW_NETWORK_ADDED = 'SET_NEW_NETWORK_ADDED';
const SET_EDIT_NETWORK = exports.SET_EDIT_NETWORK = 'SET_EDIT_NETWORK';
const SET_NEW_NFT_ADDED_MESSAGE = exports.SET_NEW_NFT_ADDED_MESSAGE = 'SET_NEW_NFT_ADDED_MESSAGE';
const SET_REMOVE_NFT_MESSAGE = exports.SET_REMOVE_NFT_MESSAGE = 'SET_REMOVE_NFT_MESSAGE';
const LOADING_METHOD_DATA_STARTED = exports.LOADING_METHOD_DATA_STARTED = 'LOADING_METHOD_DATA_STARTED';
const LOADING_METHOD_DATA_FINISHED = exports.LOADING_METHOD_DATA_FINISHED = 'LOADING_METHOD_DATA_FINISHED';
const SET_REQUEST_ACCOUNT_TABS = exports.SET_REQUEST_ACCOUNT_TABS = 'SET_REQUEST_ACCOUNT_TABS';
const SET_OPEN_METAMASK_TAB_IDS = exports.SET_OPEN_METAMASK_TAB_IDS = 'SET_OPEN_METAMASK_TAB_IDS';

// Home Screen
const HIDE_WHATS_NEW_POPUP = exports.HIDE_WHATS_NEW_POPUP = 'HIDE_WHATS_NEW_POPUP';
const TOGGLE_GAS_LOADING_ANIMATION = exports.TOGGLE_GAS_LOADING_ANIMATION = 'TOGGLE_GAS_LOADING_ANIMATION';

// Smart Transactions
const SET_SMART_TRANSACTIONS_ERROR = exports.SET_SMART_TRANSACTIONS_ERROR = 'SET_SMART_TRANSACTIONS_ERROR';
const DISMISS_SMART_TRANSACTIONS_ERROR_MESSAGE = exports.DISMISS_SMART_TRANSACTIONS_ERROR_MESSAGE = 'DISMISS_SMART_TRANSACTIONS_ERROR_MESSAGE';
const TOGGLE_CURRENCY_INPUT_SWITCH = exports.TOGGLE_CURRENCY_INPUT_SWITCH = 'TOGGLE_CURRENCY_INPUT_SWITCH';

// Token detection v2
const SET_NEW_TOKENS_IMPORTED = exports.SET_NEW_TOKENS_IMPORTED = 'SET_NEW_TOKENS_IMPORTED';
const SET_NEW_TOKENS_IMPORTED_ERROR = exports.SET_NEW_TOKENS_IMPORTED_ERROR = 'SET_NEW_TOKENS_IMPORTED_ERROR';

// Token allowance
const SET_CUSTOM_TOKEN_AMOUNT = exports.SET_CUSTOM_TOKEN_AMOUNT = 'SET_CUSTOM_TOKEN_AMOUNT';

// Connections Modal
const CONNECT_ACCOUNTS_MODAL_OPEN = exports.CONNECT_ACCOUNTS_MODAL_OPEN = 'UI_CONNECT_ACCOUNTS_MODAL_OPEN';
const CONNECT_ACCOUNTS_MODAL_CLOSE = exports.CONNECT_ACCOUNTS_MODAL_CLOSE = 'UI_CONNECT_ACCOUNTS_MODAL_CLOSE';

///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
const SHOW_KEYRING_SNAP_REMOVAL_RESULT = exports.SHOW_KEYRING_SNAP_REMOVAL_RESULT = 'SHOW_KEYRING_SNAP_REMOVAL_RESULT';
const HIDE_KEYRING_SNAP_REMOVAL_RESULT = exports.HIDE_KEYRING_SNAP_REMOVAL_RESULT = 'HIDE_KEYRING_SNAP_REMOVAL_RESULT';
///: END:ONLY_INCLUDE_IF

const SET_SHOW_NFT_AUTO_DETECT_MODAL_UPGRADE = exports.SET_SHOW_NFT_AUTO_DETECT_MODAL_UPGRADE = 'SET_SHOW_NFT_AUTO_DETECT_MODAL_UPGRADE';
const TOKEN_SORT_CRITERIA = exports.TOKEN_SORT_CRITERIA = 'TOKEN_SORT_CRITERIA';
const SET_SLIDES = exports.SET_SLIDES = 'SET_SLIDES';
const SET_SHOW_NEW_SRP_ADDED_TOAST = exports.SET_SHOW_NEW_SRP_ADDED_TOAST = 'SET_SHOW_NEW_SRP_ADDED_TOAST';
const SET_SHOW_PASSWORD_CHANGE_TOAST = exports.SET_SHOW_PASSWORD_CHANGE_TOAST = 'SET_SHOW_PASSWORD_CHANGE_TOAST';
const SET_SHOW_COPY_ADDRESS_TOAST = exports.SET_SHOW_COPY_ADDRESS_TOAST = 'SET_SHOW_COPY_ADDRESS_TOAST';
const SET_SHOW_CLAIM_SUBMIT_TOAST = exports.SET_SHOW_CLAIM_SUBMIT_TOAST = 'SET_SHOW_CLAIM_SUBMIT_TOAST';
const SET_SHOW_SUPPORT_DATA_CONSENT_MODAL = exports.SET_SHOW_SUPPORT_DATA_CONSENT_MODAL = 'SET_SHOW_SUPPORT_DATA_CONSENT_MODAL';
const SET_SHOW_CONNECTIONS_REMOVED = exports.SET_SHOW_CONNECTIONS_REMOVED = 'SET_SHOW_CONNECTIONS_REMOVED';
const SET_SHOW_SHIELD_ENTRY_MODAL_ONCE = exports.SET_SHOW_SHIELD_ENTRY_MODAL_ONCE = 'SET_SHOW_SHIELD_ENTRY_MODAL_ONCE';

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\store\\actionConstants.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\store\\actions.ts", {"../../app/scripts/lib/util":"D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\util.ts","../../shared/constants/app":"D:\\code\\v\\metamask-extension\\shared\\constants\\app.ts","../../shared/constants/app-state":"D:\\code\\v\\metamask-extension\\shared\\constants\\app-state.ts","../../shared/constants/hardware-wallets":"D:\\code\\v\\metamask-extension\\shared\\constants\\hardware-wallets.ts","../../shared/constants/metametrics":"D:\\code\\v\\metamask-extension\\shared\\constants\\metametrics.ts","../../shared/lib/four-byte":"D:\\code\\v\\metamask-extension\\shared\\lib\\four-byte.ts","../../shared/lib/sentry":"D:\\code\\v\\metamask-extension\\shared\\lib\\sentry.ts","../../shared/lib/switch-direction":"D:\\code\\v\\metamask-extension\\shared\\lib\\switch-direction.js","../../shared/lib/trace":"D:\\code\\v\\metamask-extension\\shared\\lib\\trace.ts","../../shared/modules/conversion.utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\conversion.utils.ts","../../shared/modules/error":"D:\\code\\v\\metamask-extension\\shared\\modules\\error.ts","../../shared/modules/hexstring-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\hexstring-utils.ts","../../shared/modules/i18n":"D:\\code\\v\\metamask-extension\\shared\\modules\\i18n.ts","../../shared/modules/selectors":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\index.ts","../../shared/modules/selectors/networks":"D:\\code\\v\\metamask-extension\\shared\\modules\\selectors\\networks.ts","../../shared/modules/string-utils":"D:\\code\\v\\metamask-extension\\shared\\modules\\string-utils.ts","../components/app/toast-master/utils":"D:\\code\\v\\metamask-extension\\ui\\components\\app\\toast-master\\utils.ts","../ducks/alerts/unconnected-account":"D:\\code\\v\\metamask-extension\\ui\\ducks\\alerts\\unconnected-account.js","../ducks/metamask/metamask":"D:\\code\\v\\metamask-extension\\ui\\ducks\\metamask\\metamask.js","../ducks/send":"D:\\code\\v\\metamask-extension\\ui\\ducks\\send\\index.js","../helpers/constants/notifications":"D:\\code\\v\\metamask-extension\\ui\\helpers\\constants\\notifications.ts","../hooks/multichain-accounts/utils":"D:\\code\\v\\metamask-extension\\ui\\hooks\\multichain-accounts\\utils.ts","../pages/confirmations/selectors/preferences":"D:\\code\\v\\metamask-extension\\ui\\pages\\confirmations\\selectors\\preferences.ts","../pages/swaps/swaps.util":"D:\\code\\v\\metamask-extension\\ui\\pages\\swaps\\swaps.util.ts","../selectors":"D:\\code\\v\\metamask-extension\\ui\\selectors\\index.js","./actionConstants":"D:\\code\\v\\metamask-extension\\ui\\store\\actionConstants.ts","./background-connection":"D:\\code\\v\\metamask-extension\\ui\\store\\background-connection.ts","@metamask/account-tree-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\account-tree-controller\\dist\\index.cjs","@metamask/chain-agnostic-permission":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\chain-agnostic-permission\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js","immer":"D:\\code\\v\\metamask-extension\\node_modules\\immer\\dist\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","loglevel":"D:\\code\\v\\metamask-extension\\node_modules\\loglevel\\lib\\loglevel.js","webextension-polyfill":"D:\\code\\v\\metamask-extension\\node_modules\\webextension-polyfill\\dist\\browser-polyfill.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cstore%5Cactions.ts
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.abortTransactionSigning = abortTransactionSigning;
exports.accountTrackerStartPolling = accountTrackerStartPolling;
exports.accountTrackerStopPollingByPollingToken = accountTrackerStopPollingByPollingToken;
exports.addImportedTokens = addImportedTokens;
exports.addNetwork = addNetwork;
exports.addNewAccount = addNewAccount;
exports.addNft = addNft;
exports.addNftVerifyOwnership = addNftVerifyOwnership;
exports.addPermittedAccount = addPermittedAccount;
exports.addPermittedAccounts = addPermittedAccounts;
exports.addPermittedChain = addPermittedChain;
exports.addPermittedChains = addPermittedChains;
exports.addPollingTokenToAppState = addPollingTokenToAppState;
exports.addToAddressBook = addToAddressBook;
exports.addToken = addToken;
exports.addTransaction = addTransaction;
exports.addTransactionAndRouteToConfirmationPage = addTransactionAndRouteToConfirmationPage;
exports.addTransactionAndWaitForPublish = addTransactionAndWaitForPublish;
exports.alignMultichainWallets = alignMultichainWallets;
exports.applyTransactionContainersExisting = applyTransactionContainersExisting;
exports.approvePermissionsRequest = approvePermissionsRequest;
exports.attemptCloseNotificationPopup = attemptCloseNotificationPopup;
exports.attemptLedgerTransportCreation = attemptLedgerTransportCreation;
exports.automaticallySwitchNetwork = automaticallySwitchNetwork;
exports.backupUserData = backupUserData;
exports.cancelDecryptMsg = cancelDecryptMsg;
exports.cancelEncryptionPublicKeyMsg = cancelEncryptionPublicKeyMsg;
exports.cancelQrCodeScan = cancelQrCodeScan;
exports.cancelSmartTransaction = cancelSmartTransaction;
exports.cancelSubscription = cancelSubscription;
exports.cancelTx = cancelTx;
exports.cancelTxs = cancelTxs;
exports.captureSingleException = captureSingleException;
exports.captureTestBackgroundError = captureTestBackgroundError;
exports.changePassword = changePassword;
exports.checkAccountsPresence = checkAccountsPresence;
exports.checkAndUpdateAllNftsOwnershipStatus = checkAndUpdateAllNftsOwnershipStatus;
exports.checkAndUpdateSingleNftOwnershipStatus = checkAndUpdateSingleNftOwnershipStatus;
exports.checkHardwareStatus = checkHardwareStatus;
exports.checkIsSeedlessPasswordOutdated = checkIsSeedlessPasswordOutdated;
exports.clearAccountDetails = clearAccountDetails;
exports.clearPendingTokens = clearPendingTokens;
exports.clearProductTour = clearProductTour;
exports.clearSmartTransactionFees = clearSmartTransactionFees;
exports.clearSwapsQuotes = clearSwapsQuotes;
exports.closeCurrentNotificationWindow = closeCurrentNotificationWindow;
exports.closeWelcomeScreen = closeWelcomeScreen;
exports.completeOnboarding = completeOnboarding;
exports.completeQrCodeScan = completeQrCodeScan;
exports.completedTx = completedTx;
exports.connectHardware = connectHardware;
exports.createCancelTransaction = createCancelTransaction;
exports.createEventFragment = createEventFragment;
exports.createMetaMetricsDataDeletionTask = createMetaMetricsDataDeletionTask;
exports.createNewVault = createNewVault;
exports.createNewVaultAndGetSeedPhrase = createNewVaultAndGetSeedPhrase;
exports.createNewVaultAndRestore = createNewVaultAndRestore;
exports.createNewVaultAndSyncWithSocial = createNewVaultAndSyncWithSocial;
exports.createNextMultichainAccountGroup = createNextMultichainAccountGroup;
exports.createOnChainTriggers = createOnChainTriggers;
exports.createRetryTransaction = createRetryTransaction;
exports.createSeedPhraseBackup = createSeedPhraseBackup;
exports.createSnapAccount = createSnapAccount;
exports.createSpeedUpTransaction = createSpeedUpTransaction;
exports.createTransactionEventFragment = createTransactionEventFragment;
exports.currencyRateStartPolling = currencyRateStartPolling;
exports.currencyRateStopPollingByPollingToken = currencyRateStopPollingByPollingToken;
exports.decodeTransactionData = decodeTransactionData;
exports.decryptMsg = decryptMsg;
exports.decryptMsgInline = decryptMsgInline;
exports.deleteAccountSyncingDataFromUserStorage = deleteAccountSyncingDataFromUserStorage;
exports.deleteExpiredNotifications = deleteExpiredNotifications;
exports.deleteInterface = deleteInterface;
exports.deleteNotificationsById = deleteNotificationsById;
exports.detectNfts = detectNfts;
exports.detectTokens = detectTokens;
exports.disableAccounts = disableAccounts;
exports.disableMetamaskNotifications = disableMetamaskNotifications;
exports.disableSnap = disableSnap;
exports.disconnectOriginFromSnap = disconnectOriginFromSnap;
exports.dismissSmartTransactionsErrorMessage = dismissSmartTransactionsErrorMessage;
exports.displayWarning = displayWarning;
exports.enableAccounts = enableAccounts;
exports.enableMetamaskNotifications = enableMetamaskNotifications;
exports.enableSnap = enableSnap;
exports.encryptionPublicKeyMsg = encryptionPublicKeyMsg;
exports.endBackgroundTrace = endBackgroundTrace;
exports.estimateGas = estimateGas;
exports.exportAccount = exportAccount;
exports.exportAccounts = exportAccounts;
exports.fetchAndSetQuotes = fetchAndSetQuotes;
exports.fetchAndUpdateMetamaskNotifications = fetchAndUpdateMetamaskNotifications;
exports.fetchHistoricalPricesForAsset = fetchHistoricalPricesForAsset;
exports.fetchSmartTransactionFees = fetchSmartTransactionFees;
exports.fetchSmartTransactionsLiveness = fetchSmartTransactionsLiveness;
exports.finalizeEventFragment = finalizeEventFragment;
exports.findNetworkClientIdByChainId = findNetworkClientIdByChainId;
exports.forceUpdateMetamaskState = forceUpdateMetamaskState;
exports.forgetDevice = forgetDevice;
exports.gasFeeStartPollingByNetworkClientId = gasFeeStartPollingByNetworkClientId;
exports.gasFeeStopPollingByPollingToken = gasFeeStopPollingByPollingToken;
exports.generateNewMnemonicAndAddToVault = generateNewMnemonicAndAddToVault;
exports.getBalancesInSingleCall = getBalancesInSingleCall;
exports.getCode = getCode;
exports.getContractMethodData = getContractMethodData;
exports.getCurrentNetworkEIP1559Compatibility = getCurrentNetworkEIP1559Compatibility;
exports.getERC1155BalanceOf = getERC1155BalanceOf;
exports.getGasFeeTimeEstimate = getGasFeeTimeEstimate;
exports.getLastInteractedConfirmationInfo = getLastInteractedConfirmationInfo;
exports.getLayer1GasFee = getLayer1GasFee;
exports.getLayer1GasFeeValue = getLayer1GasFeeValue;
exports.getMarketingConsent = getMarketingConsent;
exports.getNFTContractInfo = getNFTContractInfo;
exports.getNetworkConfigurationByNetworkClientId = getNetworkConfigurationByNetworkClientId;
exports.getNetworksWithTransactionActivityByAccounts = getNetworksWithTransactionActivityByAccounts;
exports.getNextAvailableAccountName = getNextAvailableAccountName;
exports.getNextNonce = getNextNonce;
exports.getOpenMetamaskTabsIds = getOpenMetamaskTabsIds;
exports.getPhishingResult = getPhishingResult;
exports.getRequestAccountTabIds = getRequestAccountTabIds;
exports.getRpcMethodPreferences = getRpcMethodPreferences;
exports.getSeedPhrase = getSeedPhrase;
exports.getSnapAccountsById = getSnapAccountsById;
exports.getSubscriptionBillingPortalUrl = getSubscriptionBillingPortalUrl;
exports.getSubscriptionCryptoApprovalAmount = getSubscriptionCryptoApprovalAmount;
exports.getSubscriptionPricing = getSubscriptionPricing;
exports.getSubscriptions = getSubscriptions;
exports.getSubscriptionsEligibilities = getSubscriptionsEligibilities;
exports.getTokenStandardAndDetails = getTokenStandardAndDetails;
exports.getTokenStandardAndDetailsByChain = getTokenStandardAndDetailsByChain;
exports.getTokenSymbol = getTokenSymbol;
exports.getTransactions = getTransactions;
exports.getUserProfileLineage = getUserProfileLineage;
exports.goHome = goHome;
exports.handleSnapRequest = handleSnapRequest;
exports.hideAccountBanner = hideAccountBanner;
exports.hideAlert = hideAlert;
exports.hideBetaHeader = hideBetaHeader;
exports.hideDeprecatedNetworkModal = hideDeprecatedNetworkModal;
exports.hideImportNftsModal = hideImportNftsModal;
exports.hideImportTokensModal = hideImportTokensModal;
exports.hideIpfsModal = hideIpfsModal;
exports.hideKeyringRemovalResultModal = hideKeyringRemovalResultModal;
exports.hideLoadingIndication = hideLoadingIndication;
exports.hideModal = hideModal;
exports.hideNetworkBanner = hideNetworkBanner;
exports.hideNetworkDropdown = hideNetworkDropdown;
exports.hideNftStillFetchingIndication = hideNftStillFetchingIndication;
exports.hidePermissionsTour = hidePermissionsTour;
exports.hidePermittedNetworkToast = hidePermittedNetworkToast;
exports.hideTestNetMessage = hideTestNetMessage;
exports.hideWarning = hideWarning;
exports.ignoreTokens = ignoreTokens;
exports.importMnemonicToVault = importMnemonicToVault;
exports.importNewAccount = importNewAccount;
exports.isNftOwner = isNftOwner;
exports.isRelaySupported = isRelaySupported;
exports.isSendBundleSupported = isSendBundleSupported;
exports.lockMetamask = lockMetamask;
exports.lookupSelectedNetworks = lookupSelectedNetworks;
exports.markMetamaskNotificationsAsRead = markMetamaskNotificationsAsRead;
exports.markPasswordForgotten = markPasswordForgotten;
exports.multichainUpdateBalance = multichainUpdateBalance;
exports.multichainUpdateTransactions = multichainUpdateTransactions;
exports.openUpdateTabAndReload = openUpdateTabAndReload;
exports.performSignIn = performSignIn;
exports.performSignOut = performSignOut;
exports.qrCodeDetected = qrCodeDetected;
exports.rejectAllApprovals = rejectAllApprovals;
exports.rejectAllMessages = rejectAllMessages;
exports.rejectPendingApproval = rejectPendingApproval;
exports.rejectPermissionsRequest = rejectPermissionsRequest;
exports.removeAccount = removeAccount;
exports.removeAndIgnoreNft = removeAndIgnoreNft;
exports.removeFromAddressBook = removeFromAddressBook;
exports.removeNetwork = removeNetwork;
exports.removeNft = removeNft;
exports.removePermissionsFor = removePermissionsFor;
exports.removePermittedAccount = removePermittedAccount;
exports.removePermittedChain = removePermittedChain;
exports.removePollingTokenFromAppState = removePollingTokenFromAppState;
exports.removeSlide = removeSlide;
exports.removeSnap = removeSnap;
exports.requestAccountsAndChainPermissionsWithId = requestAccountsAndChainPermissionsWithId;
exports.requestRevealSeedWords = requestRevealSeedWords;
exports.requestSafeReload = requestSafeReload;
exports.requestUserApproval = requestUserApproval;
exports.resetAccount = resetAccount;
exports.resetBackgroundSwapsState = resetBackgroundSwapsState;
exports.resetOAuthLoginState = resetOAuthLoginState;
exports.resetOnboarding = resetOnboarding;
exports.resetOnboardingAction = resetOnboardingAction;
exports.resetSwapsPostFetchState = resetSwapsPostFetchState;
exports.resetViewedNotifications = resetViewedNotifications;
exports.resolvePendingApproval = resolvePendingApproval;
exports.restoreSocialBackupAndGetSeedPhrase = restoreSocialBackupAndGetSeedPhrase;
exports.restoreUserData = restoreUserData;
exports.revokeDynamicSnapPermissions = revokeDynamicSnapPermissions;
exports.rollbackToPreviousProvider = rollbackToPreviousProvider;
exports.safeRefetchQuotes = safeRefetchQuotes;
exports.sendMultichainTransaction = sendMultichainTransaction;
exports.setAccountDetailsAddress = setAccountDetailsAddress;
exports.setAccountGroupHidden = setAccountGroupHidden;
exports.setAccountGroupName = setAccountGroupName;
exports.setAccountGroupPinned = setAccountGroupPinned;
exports.setAccountLabel = setAccountLabel;
exports.setActiveNetwork = setActiveNetwork;
exports.setActiveNetworkConfigurationId = setActiveNetworkConfigurationId;
exports.setActiveNetworkWithError = setActiveNetworkWithError;
exports.setAddSnapAccountEnabled = setAddSnapAccountEnabled;
exports.setAdvancedGasFee = setAdvancedGasFee;
exports.setAlertEnabledness = setAlertEnabledness;
exports.setAutoLockTimeLimit = setAutoLockTimeLimit;
exports.setAvatarType = setAvatarType;
exports.setBackgroundSwapRouteState = setBackgroundSwapRouteState;
exports.setCompletedOnboarding = setCompletedOnboarding;
exports.setConfirmationAdvancedDetailsOpen = setConfirmationAdvancedDetailsOpen;
exports.setConfirmationExchangeRates = setConfirmationExchangeRates;
exports.setConnectedStatusPopoverHasBeenShown = setConnectedStatusPopoverHasBeenShown;
exports.setCurrentCurrency = setCurrentCurrency;
exports.setCurrentExtensionPopupId = setCurrentExtensionPopupId;
exports.setCurrentLocale = setCurrentLocale;
exports.setCustomApproveTxData = setCustomApproveTxData;
exports.setDataCollectionForMarketing = setDataCollectionForMarketing;
exports.setDefaultHomeActiveTabName = setDefaultHomeActiveTabName;
exports.setDismissSeedBackUpReminder = setDismissSeedBackUpReminder;
exports.setDismissSmartAccountSuggestionEnabled = setDismissSmartAccountSuggestionEnabled;
exports.setEditedNetwork = setEditedNetwork;
exports.setEnableEnforcedSimulationsForTransaction = setEnableEnforcedSimulationsForTransaction;
exports.setEnabledAllPopularNetworks = setEnabledAllPopularNetworks;
exports.setEnabledNetworks = setEnabledNetworks;
exports.setEnforcedSimulationsSlippageForTransaction = setEnforcedSimulationsSlippageForTransaction;
exports.setFeatureAnnouncementsEnabled = setFeatureAnnouncementsEnabled;
exports.setFeatureFlag = setFeatureFlag;
exports.setFeatureNotificationsEnabled = setFeatureNotificationsEnabled;
exports.setFirstTimeFlowType = setFirstTimeFlowType;
exports.setHardwareWalletDefaultHdPath = setHardwareWalletDefaultHdPath;
exports.setHideZeroBalanceTokens = setHideZeroBalanceTokens;
exports.setInitialGasEstimate = setInitialGasEstimate;
exports.setIpfsGateway = setIpfsGateway;
exports.setIsBackupAndSyncFeatureEnabled = setIsBackupAndSyncFeatureEnabled;
exports.setIsIpfsGatewayEnabled = setIsIpfsGatewayEnabled;
exports.setLastActiveTime = setLastActiveTime;
exports.setLastInteractedConfirmationInfo = setLastInteractedConfirmationInfo;
exports.setLastViewedUserSurvey = setLastViewedUserSurvey;
exports.setManageInstitutionalWallets = setManageInstitutionalWallets;
exports.setMarketingConsent = setMarketingConsent;
exports.setMultichainAccountsIntroModalShown = setMultichainAccountsIntroModalShown;
exports.setName = setName;
exports.setNetworkClientIdForDomain = setNetworkClientIdForDomain;
exports.setNewNetworkAdded = setNewNetworkAdded;
exports.setNewNftAddedMessage = setNewNftAddedMessage;
exports.setNewTokensImported = setNewTokensImported;
exports.setNewTokensImportedError = setNewTokensImportedError;
exports.setNextNonce = setNextNonce;
exports.setOpenMetamaskTabsIDs = setOpenMetamaskTabsIDs;
exports.setOpenSeaEnabled = setOpenSeaEnabled;
exports.setOutdatedBrowserWarningLastShown = setOutdatedBrowserWarningLastShown;
exports.setOverrideContentSecurityPolicyHeader = setOverrideContentSecurityPolicyHeader;
exports.setParticipateInMetaMetrics = setParticipateInMetaMetrics;
exports.setPendingTokens = setPendingTokens;
exports.setPermittedAccounts = setPermittedAccounts;
exports.setPermittedChains = setPermittedChains;
exports.setPreference = setPreference;
exports.setPrivacyMode = setPrivacyMode;
exports.setRecoveryPhraseReminderHasBeenShown = setRecoveryPhraseReminderHasBeenShown;
exports.setRecoveryPhraseReminderLastShown = setRecoveryPhraseReminderLastShown;
exports.setRemoveNftMessage = setRemoveNftMessage;
exports.setRequestAccountTabIds = setRequestAccountTabIds;
exports.setSecurityAlertsEnabled = setSecurityAlertsEnabled;
exports.setSeedPhraseBackedUp = setSeedPhraseBackedUp;
exports.setSelectedAccount = setSelectedAccount;
exports.setSelectedInternalAccount = setSelectedInternalAccount;
exports.setSelectedInternalAccountWithoutLoading = setSelectedInternalAccountWithoutLoading;
exports.setSelectedMultichainAccount = setSelectedMultichainAccount;
exports.setSelectedNetworkConfigurationId = setSelectedNetworkConfigurationId;
exports.setSelectedQuoteAggId = setSelectedQuoteAggId;
exports.setServiceWorkerKeepAlivePreference = setServiceWorkerKeepAlivePreference;
exports.setShowConnectionsRemovedModal = setShowConnectionsRemovedModal;
exports.setShowExtensionInFullSizeView = setShowExtensionInFullSizeView;
exports.setShowFiatConversionOnTestnetsPreference = setShowFiatConversionOnTestnetsPreference;
exports.setShowMultiRpcModal = setShowMultiRpcModal;
exports.setShowNativeTokenAsMainBalancePreference = setShowNativeTokenAsMainBalancePreference;
exports.setShowShieldEntryModalOnce = setShowShieldEntryModalOnce;
exports.setShowShieldEntryModalOnceAction = setShowShieldEntryModalOnceAction;
exports.setShowSupportDataConsentModal = setShowSupportDataConsentModal;
exports.setShowTestNetworks = setShowTestNetworks;
exports.setSkipDeepLinkInterstitial = setSkipDeepLinkInterstitial;
exports.setSlides = setSlides;
exports.setSmartAccountOptIn = setSmartAccountOptIn;
exports.setSmartTransactionsPreferenceEnabled = setSmartTransactionsPreferenceEnabled;
exports.setSmartTransactionsRefreshInterval = setSmartTransactionsRefreshInterval;
exports.setSnapsAddSnapAccountModalDismissed = setSnapsAddSnapAccountModalDismissed;
exports.setSnapsInstallPrivacyWarningShownStatus = setSnapsInstallPrivacyWarningShownStatus;
exports.setSwapsErrorKey = setSwapsErrorKey;
exports.setSwapsFeatureFlags = setSwapsFeatureFlags;
exports.setSwapsLiveness = setSwapsLiveness;
exports.setSwapsQuotesPollingLimitEnabled = setSwapsQuotesPollingLimitEnabled;
exports.setSwapsTokens = setSwapsTokens;
exports.setSwapsTxGasLimit = setSwapsTxGasLimit;
exports.setSwapsTxGasPrice = setSwapsTxGasPrice;
exports.setTermsOfUseLastAgreed = setTermsOfUseLastAgreed;
exports.setTheme = setTheme;
exports.setTokenNetworkFilter = setTokenNetworkFilter;
exports.setTokenSortConfig = setTokenSortConfig;
exports.setTransactionActive = setTransactionActive;
exports.setUnconnectedAccountAlertShown = setUnconnectedAccountAlertShown;
exports.setUpdateModalLastDismissedAt = setUpdateModalLastDismissedAt;
exports.setUse4ByteResolution = setUse4ByteResolution;
exports.setUseAddressBarEnsResolution = setUseAddressBarEnsResolution;
exports.setUseBlockie = setUseBlockie;
exports.setUseCurrencyRateCheck = setUseCurrencyRateCheck;
exports.setUseExternalNameSources = setUseExternalNameSources;
exports.setUseMultiAccountBalanceChecker = setUseMultiAccountBalanceChecker;
exports.setUseNftDetection = setUseNftDetection;
exports.setUsePhishDetect = setUsePhishDetect;
exports.setUseSafeChainsListValidation = setUseSafeChainsListValidation;
exports.setUseTokenDetection = setUseTokenDetection;
exports.setUseTransactionSimulations = setUseTransactionSimulations;
exports.setWatchEthereumAccountEnabled = setWatchEthereumAccountEnabled;
exports.setWeb3ShimUsageAlertDismissed = setWeb3ShimUsageAlertDismissed;
exports.showAccountsPage = showAccountsPage;
exports.showAlert = showAlert;
exports.showConfTxPage = showConfTxPage;
exports.showConfirmTurnOnMetamaskNotifications = showConfirmTurnOnMetamaskNotifications;
exports.showDeprecatedNetworkModal = showDeprecatedNetworkModal;
exports.showImportNftsModal = showImportNftsModal;
exports.showImportTokensModal = showImportTokensModal;
exports.showIpfsModal = showIpfsModal;
exports.showKeyringSnapRemovalModal = showKeyringSnapRemovalModal;
exports.showLoadingIndication = showLoadingIndication;
exports.showModal = showModal;
exports.showNetworkDropdown = showNetworkDropdown;
exports.showNftStillFetchingIndication = showNftStillFetchingIndication;
exports.showPermittedNetworkToast = showPermittedNetworkToast;
exports.showPrivateKey = showPrivateKey;
exports.showQrScanner = showQrScanner;
exports.showSendTokenPage = showSendTokenPage;
exports.signAndSendSmartTransaction = signAndSendSmartTransaction;
exports.startOAuthLogin = startOAuthLogin;
exports.startSubscriptionWithCard = startSubscriptionWithCard;
exports.startSubscriptionWithCrypto = startSubscriptionWithCrypto;
exports.stopPollingForQuotes = stopPollingForQuotes;
exports.storeKeyringEncryptionKey = storeKeyringEncryptionKey;
exports.submitPassword = submitPassword;
exports.submitShieldClaim = submitShieldClaim;
exports.submitSubscriptionUserEvents = submitSubscriptionUserEvents;
exports.subscriptionsStartPolling = subscriptionsStartPolling;
exports.syncAccountTreeWithUserStorage = syncAccountTreeWithUserStorage;
exports.syncContactsWithUserStorage = syncContactsWithUserStorage;
exports.syncSeedPhrases = syncSeedPhrases;
exports.throwTestBackgroundError = throwTestBackgroundError;
exports.toggleAccountMenu = toggleAccountMenu;
exports.toggleExternalServices = toggleExternalServices;
exports.toggleNetworkMenu = toggleNetworkMenu;
exports.tokenBalancesStartPolling = tokenBalancesStartPolling;
exports.tokenBalancesStopPollingByPollingToken = tokenBalancesStopPollingByPollingToken;
exports.tokenDetectionStartPolling = tokenDetectionStartPolling;
exports.tokenDetectionStopPollingByPollingToken = tokenDetectionStopPollingByPollingToken;
exports.tokenListStartPolling = tokenListStartPolling;
exports.tokenListStopPollingByPollingToken = tokenListStopPollingByPollingToken;
exports.tokenRatesStartPolling = tokenRatesStartPolling;
exports.tokenRatesStopPollingByPollingToken = tokenRatesStopPollingByPollingToken;
exports.trackInsightSnapUsage = trackInsightSnapUsage;
exports.trackMetaMetricsEvent = trackMetaMetricsEvent;
exports.trackMetaMetricsPage = trackMetaMetricsPage;
exports.tryReverseResolveAddress = tryReverseResolveAddress;
exports.tryUnlockMetamask = tryUnlockMetamask;
exports.unCancelSubscription = unCancelSubscription;
exports.unMarkPasswordForgotten = unMarkPasswordForgotten;
exports.unlockAndGetSeedPhrase = unlockAndGetSeedPhrase;
exports.unlockFailed = unlockFailed;
exports.unlockHardwareWalletAccounts = unlockHardwareWalletAccounts;
exports.unlockInProgress = unlockInProgress;
exports.unlockSucceeded = unlockSucceeded;
exports.updateAccountsList = updateAccountsList;
exports.updateAndApproveTx = updateAndApproveTx;
exports.updateBalancesFoAccounts = updateBalancesFoAccounts;
exports.updateCurrentLocale = updateCurrentLocale;
exports.updateCustomNonce = updateCustomNonce;
exports.updateCustomSwapsEIP1559GasParams = updateCustomSwapsEIP1559GasParams;
exports.updateDataDeletionTaskStatus = updateDataDeletionTaskStatus;
exports.updateEditableParams = updateEditableParams;
exports.updateEventFragment = updateEventFragment;
exports.updateHiddenAccountsList = updateHiddenAccountsList;
exports.updateIncomingTransactions = updateIncomingTransactions;
exports.updateInterfaceState = updateInterfaceState;
exports.updateMetamaskState = updateMetamaskState;
exports.updateNetwork = updateNetwork;
exports.updateNetworkConnectionBanner = updateNetworkConnectionBanner;
exports.updateNetworksList = updateNetworksList;
exports.updateNftDropDownState = updateNftDropDownState;
exports.updatePreviousGasParams = updatePreviousGasParams;
exports.updateProposedNames = updateProposedNames;
exports.updateSlides = updateSlides;
exports.updateSmartTransaction = updateSmartTransaction;
exports.updateSnap = updateSnap;
exports.updateSubscriptionCardPaymentMethod = updateSubscriptionCardPaymentMethod;
exports.updateSubscriptionCryptoPaymentMethod = updateSubscriptionCryptoPaymentMethod;
exports.updateSwapsUserFeeLevel = updateSwapsUserFeeLevel;
exports.updateThrottledOriginState = updateThrottledOriginState;
exports.updateTokenType = updateTokenType;
exports.updateTransaction = updateTransaction;
exports.updateTransactionGasFees = updateTransactionGasFees;
exports.updateTransactionParams = updateTransactionParams;
exports.updateTransactionSendFlowHistory = updateTransactionSendFlowHistory;
exports.updateViewedNotifications = updateViewedNotifications;
exports.verifyPassword = verifyPassword;
var _webextensionPolyfill = _interopRequireDefault(require("webextension-polyfill"));
var _loglevel = _interopRequireDefault(require("loglevel"));
var _lodash = require("lodash");
var _rpcErrors = require("@metamask/rpc-errors");
var _immer = require("immer");
var _snapsUtils = require("@metamask/snaps-utils");
var _accountTreeController = require("@metamask/account-tree-controller");
var _chainAgnosticPermission = require("@metamask/chain-agnostic-permission");
var _sentry = require("../../shared/lib/sentry");
var _switchDirection = require("../../shared/lib/switch-direction");
var _app = require("../../shared/constants/app");
var _util = require("../../app/scripts/lib/util");
var _selectors = require("../selectors");
var _networks = require("../../shared/modules/selectors/networks");
var _send = require("../ducks/send");
var _unconnectedAccount = require("../ducks/alerts/unconnected-account");
var _metamask = require("../ducks/metamask/metamask");
var _hexstringUtils = require("../../shared/modules/hexstring-utils");
var _hardwareWallets = require("../../shared/constants/hardware-wallets");
var _metametrics = require("../../shared/constants/metametrics");
var _swaps = require("../pages/swaps/swaps.util");
var _stringUtils = require("../../shared/modules/string-utils");
var _selectors2 = require("../../shared/modules/selectors");
var _i18n = require("../../shared/modules/i18n");
var _conversion = require("../../shared/modules/conversion.utils");
var _error = require("../../shared/modules/error");
var _fourByte = require("../../shared/lib/four-byte");
var _trace = require("../../shared/lib/trace");
var _notifications = require("../helpers/constants/notifications");
var _preferences = require("../pages/confirmations/selectors/preferences");
var _utils = require("../components/app/toast-master/utils");
var _utils2 = require("../hooks/multichain-accounts/utils");
var _appState = require("../../shared/constants/app-state");
var actionConstants = _interopRequireWildcard(require("./actionConstants"));
var _backgroundConnection = require("./background-connection");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-nocheck `redux-thunk` and `@reduxjs/toolkit` are not compatible with
// TypeScript 5.3.3. We can't update them because we rely on an old version of
// @reduxjs/toolkit to be patched by our patch files. The patch is 6000+ lines.
// I don't want to try to figure that one out.

///: BEGIN:ONLY_INCLUDE_IF(multichain)

///: END:ONLY_INCLUDE_IF

// TODO: Remove restricted __import__
// eslint-disable-next-line import/no-restricted-paths

function goHome() {
  return {
    type: actionConstants.GO_HOME
  };
}
// async actions

/**
 * Starts the OAuth2 login process for the given Social Login type
 * and authenticate the user with the Seedless Onboarding Services.
 *
 * @param authConnection - The authentication connection to use (google | apple).
 * @param bufferedTrace - The buffered trace function from MetaMetrics context.
 * @param bufferedEndTrace - The buffered end trace function from MetaMetrics context.
 * @returns The social login result.
 */
function startOAuthLogin(authConnection, bufferedTrace, bufferedEndTrace) {
  return async dispatch => {
    dispatch(showLoadingIndication());
    try {
      const oauth2LoginResult = await (0, _backgroundConnection.submitRequestToBackground)('startOAuthLogin', [authConnection]);
      let seedlessAuthSuccess = false;
      let isNewUser = false;
      try {
        bufferedTrace === null || bufferedTrace === void 0 || bufferedTrace({
          name: _trace.TraceName.OnboardingOAuthSeedlessAuthenticate,
          op: _trace.TraceOperation.OnboardingSecurityOp
        });
        ({
          isNewUser
        } = await (0, _backgroundConnection.submitRequestToBackground)('authenticate', [oauth2LoginResult]));
        seedlessAuthSuccess = true;
      } catch (error) {
        const errorMessage = error instanceof Error ? error.message : 'Unknown error';
        bufferedTrace === null || bufferedTrace === void 0 || bufferedTrace({
          name: _trace.TraceName.OnboardingOAuthSeedlessAuthenticateError,
          op: _trace.TraceOperation.OnboardingError,
          tags: {
            errorMessage
          }
        });
        bufferedEndTrace === null || bufferedEndTrace === void 0 || bufferedEndTrace({
          name: _trace.TraceName.OnboardingOAuthSeedlessAuthenticateError
        });
        throw error;
      } finally {
        bufferedEndTrace === null || bufferedEndTrace === void 0 || bufferedEndTrace({
          name: _trace.TraceName.OnboardingOAuthSeedlessAuthenticate,
          data: {
            success: seedlessAuthSuccess
          }
        });
      }
      return isNewUser;
    } catch (error) {
      dispatch(displayWarning(error));
      if ((0, _error.isErrorWithMessage)(error)) {
        throw new Error((0, _error.getErrorMessage)(error));
      } else {
        throw error;
      }
    } finally {
      dispatch(hideLoadingIndication());
    }
  };
}

/**
 * Resets the social login state.
 *
 * This function is used to reset the social login state when the user
 * wants to login with a different method after the successful social login.
 */
function resetOAuthLoginState() {
  return async dispatch => {
    dispatch(showLoadingIndication());
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('resetOAuthLoginState');
      dispatch({
        type: actionConstants.RESET_SOCIAL_LOGIN_ONBOARDING
      });
    } catch (error) {
      dispatch(displayWarning(error));
      if ((0, _error.isErrorWithMessage)(error)) {
        throw new Error((0, _error.getErrorMessage)(error));
      } else {
        throw error;
      }
    } finally {
      dispatch(hideLoadingIndication());
    }
  };
}

/**
 * Creates a new vault and backups/syncs the seed phrase with social login.
 *
 * @param password - The password.
 * @returns The seed phrase.
 */
function createNewVaultAndSyncWithSocial(password) {
  return async dispatch => {
    try {
      const primaryKeyring = await createNewVault(password);
      if (!primaryKeyring) {
        throw new Error('No keyring found');
      }
      const seedPhrase = await getSeedPhrase(password);
      await createSeedPhraseBackup(password, seedPhrase, primaryKeyring.metadata.id);
      dispatch(hideWarning());
      // force update the state after creating the vault
      await forceUpdateMetamaskState(dispatch);
      return seedPhrase;
    } catch (error) {
      dispatch(displayWarning(error));
      if ((0, _error.isErrorWithMessage)(error)) {
        throw new Error((0, _error.getErrorMessage)(error));
      } else {
        throw error;
      }
    }
  };
}

/**
 * Starts polling for the subscriptions.
 */
function subscriptionsStartPolling() {
  return async dispatch => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('subscriptionsStartPolling');
    } catch (error) {
      _loglevel.default.error('[subscriptionsStartPolling] error', error);
      dispatch(displayWarning(error));
    }
  };
}

/**
 * Fetches the subscription eligibilities.
 *
 * @returns The subscription eligibilities.
 */
function getSubscriptionsEligibilities() {
  return async dispatch => {
    try {
      return await (0, _backgroundConnection.submitRequestToBackground)('getSubscriptionsEligibilities');
    } catch (error) {
      _loglevel.default.error('[getSubscriptionsEligibilities] error', error);
      dispatch(displayWarning(error));
      throw error;
    }
  };
}

/**
 * Submits a user event.
 *
 * @param eventRequest - The event request.
 * @returns resolved promise.
 */
function submitSubscriptionUserEvents(eventRequest) {
  return async dispatch => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('submitSubscriptionUserEvents', [eventRequest]);
    } catch (error) {
      _loglevel.default.error('[submitSubscriptionUserEvents] error', error);
      dispatch(displayWarning(error));
    }
  };
}

/**
 * Fetches user subscriptions.
 *
 * @returns The subscriptions.
 */
function getSubscriptions() {
  return async _dispatch => {
    return await (0, _backgroundConnection.submitRequestToBackground)('getSubscriptions');
  };
}

/**
 * Fetches the subscription pricing.
 *
 * @returns The subscription pricing.
 */
function getSubscriptionPricing() {
  return async _dispatch => {
    return await (0, _backgroundConnection.submitRequestToBackground)('getSubscriptionPricing');
  };
}

/**
 * Get crypto total amount needed for a subscription.
 *
 * @param params - The parameters.
 * @param params.price - The price.
 * @param params.tokenPaymentInfo - The token payment info.
 * @returns The subscription crypto approval amount.
 */
async function getSubscriptionCryptoApprovalAmount(params) {
  return await (0, _backgroundConnection.submitRequestToBackground)('getSubscriptionCryptoApprovalAmount', [params]);
}

/**
 * Starts a subscription with a card.
 *
 * @param params - The parameters.
 * @param params.products - The list of products.
 * @param params.isTrialRequested - Is trial requested.
 * @param params.recurringInterval - The recurring interval.
 * @returns The subscription response.
 */
function startSubscriptionWithCard(params) {
  return async _dispatch => {
    try {
      const currentTab = await global.platform.currentTab();
      const subscriptions = await (0, _backgroundConnection.submitRequestToBackground)('startSubscriptionWithCard', [params, currentTab === null || currentTab === void 0 ? void 0 : currentTab.id]);
      return subscriptions;
    } catch (error) {
      console.error('[startSubscriptionWithCard] error', error);
      throw error;
    }
  };
}
function updateSubscriptionCardPaymentMethod(params) {
  return async _dispatch => {
    const currentTab = await global.platform.currentTab();
    const subscriptions = await (0, _backgroundConnection.submitRequestToBackground)('updateSubscriptionCardPaymentMethod', [params, currentTab === null || currentTab === void 0 ? void 0 : currentTab.id]);
    return subscriptions;
  };
}
function startSubscriptionWithCrypto(params) {
  return async _dispatch => {
    return await (0, _backgroundConnection.submitRequestToBackground)('startSubscriptionWithCrypto', [params]);
  };
}
function updateSubscriptionCryptoPaymentMethod(params) {
  return async _dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('updateSubscriptionCryptoPaymentMethod', [params]);
  };
}
function cancelSubscription(params) {
  return async _dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('cancelSubscription', [params]);
  };
}
function unCancelSubscription(params) {
  return async _dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('unCancelSubscription', [params]);
  };
}
function getSubscriptionBillingPortalUrl() {
  return async _dispatch => {
    const res = await (0, _backgroundConnection.submitRequestToBackground)('getSubscriptionBillingPortalUrl', []);
    return res;
  };
}
function setShowShieldEntryModalOnce(show, shouldSubmitEvents = false) {
  return async dispatch => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('setShowShieldEntryModalOnce', [show]);
      dispatch(setShowShieldEntryModalOnceAction({
        show: Boolean(show),
        shouldSubmitEvents
      }));
    } catch (error) {
      _loglevel.default.error('[setShowShieldEntryModalOnce] error', error);
      dispatch(displayWarning(error));
      throw error;
    }
  };
}
function setShowShieldEntryModalOnceAction(payload) {
  return {
    type: actionConstants.SET_SHOW_SHIELD_ENTRY_MODAL_ONCE,
    payload
  };
}

/**
 * Fetches and restores the seed phrase from the metadata store using the social login and restore the vault using the seed phrase.
 *
 * @param password - The password.
 * @returns The seed phrase.
 */
function restoreSocialBackupAndGetSeedPhrase(password) {
  return async dispatch => {
    try {
      // restore the vault using the seed phrase
      const mnemonic = await (0, _backgroundConnection.submitRequestToBackground)('restoreSocialBackupAndGetSeedPhrase', [password]);

      // sync marketing consent with metametrics
      const marketingConsent = await getMarketingConsent();
      dispatch(setDataCollectionForMarketing(marketingConsent));
      dispatch(hideWarning());
      await forceUpdateMetamaskState(dispatch);
      return mnemonic;
    } catch (error) {
      _loglevel.default.error('[restoreSocialBackupAndGetSeedPhrase] error', error);
      dispatch(displayWarning(error.message));
      throw error;
    }
  };
}
function syncSeedPhrases() {
  return async dispatch => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('syncSeedPhrases');
      dispatch(hideWarning());
      await forceUpdateMetamaskState(dispatch);
    } catch (error) {
      _loglevel.default.error('[syncSeedPhrases] error', error);
      dispatch(displayWarning(error.message));
      throw error;
    }
  };
}

/**
 * Changes the password of the currently unlocked account.
 *
 * This function changes the password of the currently unlocked account (Keyring Vault) and
 * also change the wallet password of the social login account.
 *
 * This changes affects the multiple devices sync, i.e. users will have to unlock the account
 * using new password on any other devices where the account is unlocked.
 *
 * @param newPassword - The new password.
 * @param oldPassword - The old password.
 */
function changePassword(newPassword, oldPassword) {
  return async dispatch => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('changePassword', [newPassword, oldPassword]);
    } catch (error) {
      dispatch(displayWarning(error));
      throw error;
    }
  };
}
function storeKeyringEncryptionKey(encryptionKey) {
  return (0, _backgroundConnection.submitRequestToBackground)('storeKeyringEncryptionKey', [encryptionKey]);
}
function tryUnlockMetamask(password) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return dispatch => {
    dispatch(showLoadingIndication());
    dispatch(unlockInProgress());
    _loglevel.default.debug(`background.syncPasswordAndUnlockWallet`);
    return new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('syncPasswordAndUnlockWallet', [password], (error, isPasswordSynced) => {
        if (error) {
          reject(error);
          return;
        }
        // if password is not synced show connections removal warning to user.
        if (!isPasswordSynced) {
          dispatch(setShowConnectionsRemovedModal(true));
        }
        resolve();
      });
    }).then(() => {
      dispatch(unlockSucceeded());
      return forceUpdateMetamaskState(dispatch);
    }).then(() => {
      dispatch(hideLoadingIndication());
      dispatch(hideWarning());
    }).catch(err => {
      dispatch(unlockFailed((0, _error.getErrorMessage)(err)));
      dispatch(hideLoadingIndication());
      return Promise.reject(err);
    });
  };
}
function checkIsSeedlessPasswordOutdated(skipCache = true) {
  return async dispatch => {
    let isPasswordOutdated = false;
    try {
      isPasswordOutdated = await (0, _backgroundConnection.submitRequestToBackground)('checkIsSeedlessPasswordOutdated', [skipCache]);
      if (isPasswordOutdated) {
        await forceUpdateMetamaskState(dispatch);
      }
    } catch (error) {
      _loglevel.default.warn('checkIsSeedlessPasswordOutdated error', error);
    }
    return isPasswordOutdated;
  };
}

/**
 * Adds a new account where all data is encrypted using the given password and
 * where all addresses are generated from a given seed phrase.
 *
 * @param password - The password.
 * @param seedPhrase - The seed phrase.
 * @returns The updated state of the keyring controller.
 */
function createNewVaultAndRestore(password, seedPhrase) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return dispatch => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`background.createNewVaultAndRestore`);

    // Encode the secret recovery phrase as an array of integers so that it is
    // serialized as JSON properly.
    const encodedSeedPhrase = Array.from(Buffer.from(seedPhrase, 'utf8').values());
    return new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('createNewVaultAndRestore', [password, encodedSeedPhrase], err => {
        if (err) {
          reject(err);
          return;
        }
        resolve();
      });
    }).then(() => dispatch(unMarkPasswordForgotten())).then(() => {
      dispatch(showAccountsPage());
      dispatch(hideLoadingIndication());
    }).catch(err => {
      dispatch(displayWarning(err));
      dispatch(hideLoadingIndication());
      return Promise.reject(err);
    });
  };
}
function importMnemonicToVault(mnemonic) {
  return async dispatch => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`background.importMnemonicToVault`);
    return new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('importMnemonicToVault', [mnemonic], (err, result) => {
        if (err) {
          reject(err);
          return;
        }
        resolve(result);
      });
    }).then(async result => {
      dispatch(hideLoadingIndication());
      dispatch(hideWarning());
      dispatch((0, _utils.setShowNewSrpAddedToast)(true));
      return result;
    }).catch(err => {
      dispatch(displayWarning(err));
      dispatch(hideLoadingIndication());
      return Promise.reject(err);
    });
  };
}
function generateNewMnemonicAndAddToVault() {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return dispatch => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`background.generateNewMnemonicAndAddToVault`);
    return new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('generateNewMnemonicAndAddToVault', [], err => {
        if (err) {
          reject(err);
          return;
        }
        resolve();
      });
    }).then(async () => {
      dispatch(hideLoadingIndication());
    }).catch(err => {
      dispatch(displayWarning(err));
      dispatch(hideLoadingIndication());
      return Promise.reject(err);
    });
  };
}
function createNewVaultAndGetSeedPhrase(password) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    try {
      await createNewVault(password);
      const seedPhrase = await getSeedPhrase(password);

      // force update the state after creating the vault
      await forceUpdateMetamaskState(dispatch);
      return seedPhrase;
    } catch (error) {
      dispatch(displayWarning(error));
      if ((0, _error.isErrorWithMessage)(error)) {
        throw new Error((0, _error.getErrorMessage)(error));
      } else {
        throw error;
      }
    }
  };
}
function unlockAndGetSeedPhrase(password) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    try {
      await submitPassword(password);
      const seedPhrase = await getSeedPhrase(password);
      await forceUpdateMetamaskState(dispatch);
      return seedPhrase;
    } catch (error) {
      dispatch(displayWarning(error));
      if ((0, _error.isErrorWithMessage)(error)) {
        throw new Error((0, _error.getErrorMessage)(error));
      } else {
        throw error;
      }
    }
  };
}
function submitPassword(password) {
  return new Promise((resolve, reject) => {
    (0, _backgroundConnection.callBackgroundMethod)('submitPassword', [password], error => {
      if (error) {
        reject(error);
        return;
      }
      resolve();
    });
  });
}

/**
 * Creates a seed phrase backup in the metadata store for seedless onboarding flow.
 *
 * @param password - The password.
 * @param seedPhrase - The seed phrase.
 * @param keyringId - The keyring id of the backup seed phrase.
 */
async function createSeedPhraseBackup(password, seedPhrase, keyringId) {
  const encodedSeedPhrase = Array.from(Buffer.from(seedPhrase, 'utf8').values());
  await (0, _backgroundConnection.submitRequestToBackground)('createSeedPhraseBackup', [password, encodedSeedPhrase, keyringId]);
}
function createNewVault(password) {
  return new Promise((resolve, reject) => {
    (0, _backgroundConnection.callBackgroundMethod)('createNewVaultAndKeychain', [password], (error, keyring) => {
      if (error) {
        reject(error);
        return;
      }
      resolve(keyring);
    });
  });
}
function verifyPassword(password) {
  return new Promise((resolve, reject) => {
    (0, _backgroundConnection.callBackgroundMethod)('verifyPassword', [password], error => {
      if (error) {
        reject(error);
        return;
      }
      resolve(true);
    });
  });
}
async function getSeedPhrase(password, keyringId) {
  const encodedSeedPhrase = await (0, _backgroundConnection.submitRequestToBackground)('getSeedPhrase', [password, keyringId]);
  return Buffer.from(encodedSeedPhrase).toString('utf8');
}
function requestRevealSeedWords(password, keyringId) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`background.verifyPassword`);
    try {
      await verifyPassword(password);
      const seedPhrase = await getSeedPhrase(password, keyringId);
      return seedPhrase;
    } finally {
      dispatch(hideLoadingIndication());
    }
  };
}
function tryReverseResolveAddress(address) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return () => {
    return new Promise(resolve => {
      (0, _backgroundConnection.callBackgroundMethod)('tryReverseResolveAddress', [address], err => {
        if (err) {
          (0, _error.logErrorWithMessage)(err);
        }
        resolve();
      });
    });
  };
}
function resetAccount() {
  return dispatch => {
    dispatch(showLoadingIndication());
    return new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('resetAccount', [], (err, account) => {
        dispatch(hideLoadingIndication());
        if (err) {
          if ((0, _error.isErrorWithMessage)(err)) {
            dispatch(displayWarning(err));
          }
          reject(err);
          return;
        }
        _loglevel.default.info(`Transaction history reset for ${account}`);
        dispatch(showAccountsPage());
        resolve(account);
      });
    });
  };
}
function removeAccount(address) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    dispatch(showLoadingIndication());
    try {
      await new Promise((resolve, reject) => {
        (0, _backgroundConnection.callBackgroundMethod)('removeAccount', [address], (error, account) => {
          if (error) {
            reject(error);
            return;
          }
          resolve(account);
        });
      });
      await forceUpdateMetamaskState(dispatch);
    } catch (error) {
      dispatch(displayWarning(error));
      throw error;
    } finally {
      dispatch(hideLoadingIndication());
    }
    _loglevel.default.info(`Account removed: ${address}`);
    dispatch(showAccountsPage());
  };
}
function importNewAccount(strategy,
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
args, loadingMessage) {
  return async dispatch => {
    dispatch(showLoadingIndication(loadingMessage));
    try {
      _loglevel.default.debug(`background.importAccountWithStrategy`);
      await (0, _backgroundConnection.submitRequestToBackground)('importAccountWithStrategy', [strategy, args]);
    } finally {
      dispatch(hideLoadingIndication());
    }
    return await forceUpdateMetamaskState(dispatch);
  };
}
function addNewAccount(keyringId, showLoading = true) {
  _loglevel.default.debug(`background.addNewAccount`);
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async (dispatch, getState) => {
    const keyrings = (0, _selectors.getMetaMaskHdKeyrings)(getState());
    const [defaultPrimaryKeyring] = keyrings;

    // The HD keyring to add the account for.
    let hdKeyring = defaultPrimaryKeyring;
    if (keyringId) {
      hdKeyring = keyrings.find(keyring => keyring.metadata.id === keyringId);
    }
    // Fail-safe in case we could not find the associated HD keyring.
    if (!hdKeyring) {
      _loglevel.default.error('Should never reach this. There is always a keyring');
      throw new Error('Keyring not found');
    }
    const oldAccounts = hdKeyring.accounts;
    if (showLoading) {
      dispatch(showLoadingIndication());
    }
    let newAccount;
    try {
      const addedAccountAddress = await (0, _backgroundConnection.submitRequestToBackground)('addNewAccount', [oldAccounts.length, keyringId]);
      await forceUpdateMetamaskState(dispatch);
      const newState = getState();
      newAccount = (0, _selectors.getInternalAccountByAddress)(newState, addedAccountAddress);
    } catch (error) {
      dispatch(displayWarning(error));
      throw error;
    } finally {
      if (showLoading) {
        dispatch(hideLoadingIndication());
      }
    }
    return newAccount;
  };
}
function checkHardwareStatus(deviceName, hdPath) {
  _loglevel.default.debug(`background.checkHardwareStatus`, deviceName, hdPath);
  return async dispatch => {
    dispatch(showLoadingIndication());
    let unlocked = false;
    try {
      unlocked = await (0, _backgroundConnection.submitRequestToBackground)('checkHardwareStatus', [deviceName, hdPath]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      dispatch(displayWarning(error));
      throw error;
    } finally {
      dispatch(hideLoadingIndication());
    }
    await forceUpdateMetamaskState(dispatch);
    return unlocked;
  };
}
function forgetDevice(deviceName) {
  _loglevel.default.debug(`background.forgetDevice`, deviceName);
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    dispatch(showLoadingIndication());
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('forgetDevice', [deviceName]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      dispatch(displayWarning(error));
      throw error;
    } finally {
      dispatch(hideLoadingIndication());
    }
    await forceUpdateMetamaskState(dispatch);
  };
}

// TODO: Define an Account Type for the return type of this method and anywhere
// else dealing with accounts.
function connectHardware(deviceName, page, hdPath, loadHid, t) {
  _loglevel.default.debug(`background.connectHardware`, deviceName, page, hdPath);
  return async (dispatch, getState) => {
    const {
      ledgerTransportType
    } = getState().metamask;
    dispatch(showLoadingIndication(`Looking for your ${(0, _lodash.capitalize)(deviceName)}...`));
    let accounts;
    try {
      if (loadHid && deviceName === _hardwareWallets.HardwareDeviceNames.ledger && ledgerTransportType === _hardwareWallets.LedgerTransportTypes.webhid) {
        const inE2eTest = false && "undefined" === 'undefined';
        let connectedDevices = [];
        if (!inE2eTest) {
          connectedDevices = await window.navigator.hid.requestDevice({
            // The types for web hid were provided by @types/w3c-web-hid and may
            // not be fully formed or correct, because LEDGER_USB_VENDOR_ID is a
            // string and this integration with Navigator.hid works before
            // TypeScript. As a note, on the next declaration we convert the
            // LEDGER_USB_VENDOR_ID to a number for a different API so....
            // TODO: Get David Walsh's opinion here
            filters: [{
              vendorId: _hardwareWallets.LEDGER_USB_VENDOR_ID
            }]
          });
        }
        const userApprovedWebHidConnection = inE2eTest || connectedDevices.some(device => device.vendorId === Number(_hardwareWallets.LEDGER_USB_VENDOR_ID));
        if (!userApprovedWebHidConnection) {
          throw new Error(t('ledgerWebHIDNotConnectedErrorMessage'));
        }
      }
      accounts = await (0, _backgroundConnection.submitRequestToBackground)('connectHardware', [deviceName, page, hdPath]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      const message = (0, _error.getErrorMessage)(error);
      if (deviceName === _hardwareWallets.HardwareDeviceNames.ledger && ledgerTransportType === _hardwareWallets.LedgerTransportTypes.webhid && (0, _error.isErrorWithMessage)(error) && message.match('Failed to open the device')) {
        dispatch(displayWarning(t('ledgerDeviceOpenFailureMessage')));
        throw new Error(t('ledgerDeviceOpenFailureMessage'));
      } else {
        if (deviceName !== _hardwareWallets.HardwareDeviceNames.qr) {
          dispatch(displayWarning(error));
        }
        throw error;
      }
    } finally {
      dispatch(hideLoadingIndication());
    }
    await forceUpdateMetamaskState(dispatch);
    return accounts;
  };
}
function unlockHardwareWalletAccounts(indexes, deviceName, hdPath, hdPathDescription) {
  _loglevel.default.debug(`background.unlockHardwareWalletAccount`, indexes, deviceName, hdPath, hdPathDescription);
  return async dispatch => {
    dispatch(showLoadingIndication());
    for (const index of indexes) {
      try {
        await (0, _backgroundConnection.submitRequestToBackground)('unlockHardwareWalletAccount', [index, deviceName, hdPath, hdPathDescription]);
      } catch (err) {
        (0, _error.logErrorWithMessage)(err);
        dispatch(displayWarning(err));
        dispatch(hideLoadingIndication());
        throw err;
      }
    }
    dispatch(hideLoadingIndication());
    return undefined;
  };
}
function showQrScanner() {
  return dispatch => {
    dispatch(showModal({
      name: 'QR_SCANNER'
    }));
  };
}
function setCurrentCurrency(currencyCode) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`background.setCurrentCurrency`);
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('setCurrentCurrency', [currencyCode]);
      await forceUpdateMetamaskState(dispatch);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      dispatch(displayWarning(error));
      return;
    } finally {
      dispatch(hideLoadingIndication());
    }
  };
}
function decryptMsgInline(decryptedMsgData) {
  _loglevel.default.debug('action - decryptMsgInline');
  return async dispatch => {
    _loglevel.default.debug(`actions calling background.decryptMessageInline`);
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('decryptMessageInline', [decryptedMsgData]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      dispatch(displayWarning(error));
      throw error;
    }
    const newState = await forceUpdateMetamaskState(dispatch);
    return newState.unapprovedDecryptMsgs[decryptedMsgData.metamaskId];
  };
}
function decryptMsg(decryptedMsgData) {
  _loglevel.default.debug('action - decryptMsg');
  return async dispatch => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`actions calling background.decryptMessage`);
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('decryptMessage', [decryptedMsgData]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      dispatch(displayWarning(error));
      throw error;
    } finally {
      dispatch(hideLoadingIndication());
    }
    await forceUpdateMetamaskState(dispatch);
    dispatch(completedTx(decryptedMsgData.metamaskId));
    dispatch(closeCurrentNotificationWindow());
    return decryptedMsgData;
  };
}
function encryptionPublicKeyMsg(msgData) {
  _loglevel.default.debug('action - encryptionPublicKeyMsg');
  return async dispatch => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`actions calling background.encryptionPublicKey`);
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('encryptionPublicKey', [msgData]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      dispatch(displayWarning(error));
      throw error;
    } finally {
      dispatch(hideLoadingIndication());
    }
    await forceUpdateMetamaskState(dispatch);
    dispatch(completedTx(msgData.metamaskId));
    dispatch(closeCurrentNotificationWindow());
    return msgData;
  };
}
function updateCustomNonce(value) {
  return {
    type: actionConstants.UPDATE_CUSTOM_NONCE,
    value
  };
}

/**
 * TODO: update previousGasParams to use typed gas params object
 * TODO: Not a thunk, but rather a wrapper around a background call
 *
 * @param txId - MetaMask internal transaction id
 * @param previousGasParams - Object of gas params to set as previous
 */
function updatePreviousGasParams(txId,
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
previousGasParams) {
  return async () => {
    let updatedTransaction;
    try {
      updatedTransaction = await (0, _backgroundConnection.submitRequestToBackground)('updatePreviousGasParams', [txId, previousGasParams]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      throw error;
    }
    return updatedTransaction;
  };
}
function updateEditableParams(...args) {
  return async dispatch => {
    let updatedTransaction;
    try {
      updatedTransaction = await (0, _backgroundConnection.submitRequestToBackground)('updateEditableParams', args);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      throw error;
    }
    await forceUpdateMetamaskState(dispatch);
    return updatedTransaction;
  };
}

/**
 * Appends new send flow history to a transaction
 * TODO: Not a thunk, but rather a wrapper around a background call
 *
 * @param txId - the id of the transaction to update
 * @param currentSendFlowHistoryLength - sendFlowHistory entries currently
 * @param sendFlowHistory - the new send flow history to append to the
 * transaction
 * @returns
 */
function updateTransactionSendFlowHistory(txId, currentSendFlowHistoryLength, sendFlowHistory) {
  return async () => {
    let updatedTransaction;
    try {
      updatedTransaction = await (0, _backgroundConnection.submitRequestToBackground)('updateTransactionSendFlowHistory', [txId, currentSendFlowHistoryLength, sendFlowHistory]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      throw error;
    }
    return updatedTransaction;
  };
}
async function backupUserData() {
  let backedupData;
  try {
    backedupData = await (0, _backgroundConnection.submitRequestToBackground)('backupUserData');
  } catch (error) {
    (0, _error.logErrorWithMessage)(error);
    throw error;
  }
  return backedupData;
}
async function restoreUserData(jsonString) {
  try {
    await (0, _backgroundConnection.submitRequestToBackground)('restoreUserData', [jsonString]);
  } catch (error) {
    (0, _error.logErrorWithMessage)(error);
    throw error;
  }
  return true;
}
function updateSlides(slides) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async () => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('updateSlides', [slides]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      throw error;
    }
  };
}
function removeSlide(id) {
  return async () => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('removeSlide', [id]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      throw error;
    }
  };
}
async function setEnableEnforcedSimulationsForTransaction(transactionId, enable) {
  try {
    await (0, _backgroundConnection.submitRequestToBackground)('setEnableEnforcedSimulationsForTransaction', [transactionId, enable]);
  } catch (error) {
    (0, _error.logErrorWithMessage)(error);
    throw error;
  }
}
async function setEnforcedSimulationsSlippageForTransaction(transactionId, value) {
  try {
    await (0, _backgroundConnection.submitRequestToBackground)('setEnforcedSimulationsSlippageForTransaction', [transactionId, value]);
  } catch (error) {
    (0, _error.logErrorWithMessage)(error);
    throw error;
  }
}

// TODO: Not a thunk, but rather a wrapper around a background call
function updateTransactionGasFees(txId, txGasFees) {
  return async () => {
    let updatedTransaction;
    try {
      updatedTransaction = await (0, _backgroundConnection.submitRequestToBackground)('updateTransactionGasFees', [txId, txGasFees]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      throw error;
    }
    return updatedTransaction;
  };
}
function updateTransaction(txMeta, dontShowLoadingIndicator) {
  return async dispatch => {
    !dontShowLoadingIndicator && dispatch(showLoadingIndication());
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('updateTransaction', [txMeta]);
    } catch (error) {
      dispatch(updateTransactionParams(txMeta.id, txMeta.txParams));
      dispatch(hideLoadingIndication());
      dispatch(goHome());
      (0, _error.logErrorWithMessage)(error);
      throw error;
    }
    try {
      dispatch(updateTransactionParams(txMeta.id, txMeta.txParams));
      await forceUpdateMetamaskState(dispatch);
      dispatch(showConfTxPage({
        id: txMeta.id
      }));
      return txMeta;
    } finally {
      dispatch(hideLoadingIndication());
    }
  };
}

/**
 * Action to create a new transaction in the controller and route to the
 * confirmation page. Returns the newly created txMeta in case additional logic
 * should be applied to the transaction after creation.
 *
 * @param txParams - The transaction parameters
 * @param options
 * @param options.networkClientId - ID of the network client to use for the transaction.
 * @param options.sendFlowHistory - The history of the send flow at time of creation.
 * @param options.type - The type of the transaction being added.
 * @returns
 */
function addTransactionAndRouteToConfirmationPage(txParams, options) {
  return async dispatch => {
    const actionId = (0, _backgroundConnection.generateActionId)();
    try {
      _loglevel.default.debug('background.addTransaction');
      const transactionMeta = await (0, _backgroundConnection.submitRequestToBackground)('addTransaction', [txParams, {
        ...options,
        actionId,
        origin: _app.ORIGIN_METAMASK
      }]);
      dispatch(showConfTxPage());
      return transactionMeta;
    } catch (error) {
      dispatch(hideLoadingIndication());
      dispatch(displayWarning(error));
      throw error;
    }
  };
}

/**
 * Wrapper around the promisifedBackground to create a new unapproved
 * transaction in the background and return the newly created txMeta.
 * This method does not show errors or route to a confirmation page and is
 * used primarily for swaps functionality.
 *
 * @param txParams - the transaction parameters
 * @param options - Additional options for the transaction.
 * @param options.method
 * @param options.networkClientId - ID of the network client to use for the transaction.
 * @param options.requireApproval - Whether the transaction requires approval.
 * @param options.swaps - Options specific to swaps transactions.
 * @param options.swaps.hasApproveTx - Whether the swap required an approval transaction.
 * @param options.swaps.meta - Additional transaction metadata required by swaps.
 * @param options.type
 * @returns
 */
async function addTransactionAndWaitForPublish(txParams, options) {
  _loglevel.default.debug('background.addTransactionAndWaitForPublish');
  const actionId = (0, _backgroundConnection.generateActionId)();
  return await (0, _backgroundConnection.submitRequestToBackground)('addTransactionAndWaitForPublish', [txParams, {
    ...options,
    origin: _app.ORIGIN_METAMASK,
    actionId
  }]);
}

/**
 * Wrapper around the promisifedBackground to create a new unapproved
 * transaction in the background and return the newly created txMeta.
 * This method does not show errors or route to a confirmation page
 *
 * @param txParams - the transaction parameters
 * @param options - Additional options for the transaction.
 * @param options.method
 * @param options.networkClientId - ID of the network client to use for the transaction.
 * @param options.requireApproval - Whether the transaction requires approval.
 * @param options.swaps - Options specific to swaps transactions.
 * @param options.swaps.hasApproveTx - Whether the swap required an approval transaction.
 * @param options.swaps.meta - Additional transaction metadata required by swaps.
 * @param options.type
 * @returns
 */
async function addTransaction(txParams, options) {
  _loglevel.default.debug('background.addTransaction');
  const actionId = (0, _backgroundConnection.generateActionId)();
  return await (0, _backgroundConnection.submitRequestToBackground)('addTransaction', [txParams, {
    ...options,
    origin: _app.ORIGIN_METAMASK,
    actionId
  }]);
}
function updateAndApproveTx(txMeta, dontShowLoadingIndicator, loadingIndicatorMessage) {
  return (dispatch, getState) => {
    !dontShowLoadingIndicator && dispatch(showLoadingIndication(loadingIndicatorMessage));
    const getIsSendActive = () => Boolean(getState().send.stage !== _send.SEND_STAGES.INACTIVE);
    return new Promise((resolve, reject) => {
      const actionId = (0, _backgroundConnection.generateActionId)();
      (0, _backgroundConnection.callBackgroundMethod)('resolvePendingApproval', [String(txMeta.id), {
        txMeta,
        actionId
      }, {
        waitForResult: true
      }], err => {
        dispatch(updateTransactionParams(txMeta.id, txMeta.txParams));
        if (!getIsSendActive()) {
          dispatch((0, _send.resetSendState)());
        }
        if (err) {
          dispatch(goHome());
          (0, _error.logErrorWithMessage)(err);
          reject(err);
          return;
        }
        resolve(txMeta);
      });
    }).then(() => forceUpdateMetamaskState(dispatch)).then(() => {
      if (!getIsSendActive()) {
        dispatch((0, _send.resetSendState)());
      }
      dispatch(completedTx(txMeta.id));
      dispatch(hideLoadingIndication());
      dispatch(updateCustomNonce(''));
      dispatch(closeCurrentNotificationWindow());
      return txMeta;
    }).catch(err => {
      dispatch(hideLoadingIndication());
      return Promise.reject(err);
    });
  };
}
async function getTransactions(filters = {}) {
  return await (0, _backgroundConnection.submitRequestToBackground)('getTransactions', [filters]);
}
function completedTx(txId) {
  return dispatch => {
    dispatch({
      type: actionConstants.COMPLETED_TX,
      value: {
        id: txId
      }
    });
  };
}
function updateTransactionParams(txId, txParams) {
  return {
    type: actionConstants.UPDATE_TRANSACTION_PARAMS,
    id: txId,
    value: txParams
  };
}
function disableSnap(snapId) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('disableSnap', [snapId]);
    await forceUpdateMetamaskState(dispatch);
  };
}
function enableSnap(snapId) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('enableSnap', [snapId]);
    await forceUpdateMetamaskState(dispatch);
  };
}
function updateSnap(origin, snap) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async (dispatch, getState) => {
    await (0, _backgroundConnection.submitRequestToBackground)('updateSnap', [origin, snap]);
    await forceUpdateMetamaskState(dispatch);
    const state = getState();
    const approval = (0, _selectors.getFirstSnapInstallOrUpdateRequest)(state);
    return approval === null || approval === void 0 ? void 0 : approval.metadata.id;
  };
}
async function getPhishingResult(website) {
  return await (0, _backgroundConnection.submitRequestToBackground)('getPhishingResult', [website]);
}

// TODO: Clean this up.
function removeSnap(snapId) {
  return async (dispatch,
  ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
  getState
  ///: END:ONLY_INCLUDE_IF
  ) => {
    var _subjects$snapId;
    dispatch(showLoadingIndication());
    ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
    const subjects = (0, _selectors.getPermissionSubjects)(getState());
    const isAccountsSnap = ((_subjects$snapId = subjects[snapId]) === null || _subjects$snapId === void 0 || (_subjects$snapId = _subjects$snapId.permissions) === null || _subjects$snapId === void 0 ? void 0 : _subjects$snapId.snap_manageAccounts) !== undefined;
    ///: END:ONLY_INCLUDE_IF

    try {
      ///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
      if (isAccountsSnap) {
        const addresses = await (0, _backgroundConnection.submitRequestToBackground)('getAccountsBySnapId', [snapId]);
        for (const address of addresses) {
          await (0, _backgroundConnection.submitRequestToBackground)('removeAccount', [address]);
        }
      }
      ///: END:ONLY_INCLUDE_IF

      await (0, _backgroundConnection.submitRequestToBackground)('removeSnap', [snapId]);
      await forceUpdateMetamaskState(dispatch);
    } catch (error) {
      dispatch(displayWarning(error));
      throw error;
    } finally {
      dispatch(hideLoadingIndication());
    }
  };
}
async function handleSnapRequest(args) {
  return (0, _backgroundConnection.submitRequestToBackground)('handleSnapRequest', [args]);
}
function revokeDynamicSnapPermissions(snapId, permissionNames) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('revokeDynamicSnapPermissions', [snapId, permissionNames]);
    await forceUpdateMetamaskState(dispatch);
  };
}
function deleteExpiredNotifications() {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async (dispatch, getState) => {
    const state = getState();
    const notifications = state.metamask.metamaskNotificationsList;
    const notificationIdsToDelete = notifications.filter(notification => {
      const expirationTime = new Date(Date.now() - _notifications.NOTIFICATIONS_EXPIRATION_DELAY);
      return Boolean(notification.readDate && new Date(notification.readDate) < expirationTime);
    }).map(({
      id
    }) => id);
    if (notificationIdsToDelete.length) {
      await (0, _backgroundConnection.submitRequestToBackground)('deleteNotificationsById', [notificationIdsToDelete]);
      await forceUpdateMetamaskState(dispatch);
    }
  };
}

/**
 * Disconnects a given origin from a snap.
 *
 * This revokes the permission granted to the origin
 * that provides the capability to communicate with a snap.
 *
 * @param origin - The origin.
 * @param snapId - The snap ID.
 */
function disconnectOriginFromSnap(origin, snapId) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('disconnectOriginFromSnap', [origin, snapId]);
    await forceUpdateMetamaskState(dispatch);
  };
}
function cancelDecryptMsg(msgData) {
  return async dispatch => {
    dispatch(showLoadingIndication());
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('cancelDecryptMessage', [msgData.id]);
    } finally {
      dispatch(hideLoadingIndication());
    }
    await forceUpdateMetamaskState(dispatch);
    dispatch(completedTx(msgData.id));
    dispatch(closeCurrentNotificationWindow());
    return msgData;
  };
}
function cancelEncryptionPublicKeyMsg(msgData) {
  return async dispatch => {
    dispatch(showLoadingIndication());
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('cancelEncryptionPublicKey', [msgData.id]);
    } finally {
      dispatch(hideLoadingIndication());
    }
    await forceUpdateMetamaskState(dispatch);
    dispatch(completedTx(msgData.id));
    dispatch(closeCurrentNotificationWindow());
    return msgData;
  };
}
function cancelTx(txMeta, _showLoadingIndication = true) {
  return dispatch => {
    _showLoadingIndication && dispatch(showLoadingIndication());
    return new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('rejectPendingApproval', [String(txMeta.id), _rpcErrors.providerErrors.userRejectedRequest().serialize()], error => {
        if (error) {
          reject(error);
          return;
        }
        resolve();
      });
    }).then(() => forceUpdateMetamaskState(dispatch)).then(() => {
      dispatch((0, _send.resetSendState)());
      dispatch(completedTx(txMeta.id));
      dispatch(hideLoadingIndication());
      dispatch(closeCurrentNotificationWindow());
      return txMeta;
    }).catch(error => {
      dispatch(hideLoadingIndication());
      throw error;
    });
  };
}

/**
 * Cancels all of the given transactions
 *
 * @param txMetaList
 * @returns
 */
function cancelTxs(txMetaList) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    dispatch(showLoadingIndication());
    try {
      const txIds = txMetaList.map(({
        id
      }) => id);
      const cancellations = txIds.map(id => new Promise((resolve, reject) => {
        (0, _backgroundConnection.callBackgroundMethod)('rejectPendingApproval', [String(id), _rpcErrors.providerErrors.userRejectedRequest().serialize()], err => {
          if (err) {
            reject(err);
            return;
          }
          resolve();
        });
      }));
      await Promise.all(cancellations);
      await forceUpdateMetamaskState(dispatch);
      dispatch((0, _send.resetSendState)());
      txIds.forEach(id => {
        dispatch(completedTx(id));
      });
    } finally {
      if ((0, _util.getEnvironmentType)() === _app.ENVIRONMENT_TYPE_NOTIFICATION) {
        attemptCloseNotificationPopup();
      } else {
        dispatch(hideLoadingIndication());
      }
    }
  };
}
function markPasswordForgotten() {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    try {
      await new Promise((resolve, reject) => {
        (0, _backgroundConnection.callBackgroundMethod)('markPasswordForgotten', [], error => {
          if (error) {
            reject(error);
            return;
          }
          resolve();
        });
      });
    } finally {
      // TODO: handle errors
      dispatch(hideLoadingIndication());
      await forceUpdateMetamaskState(dispatch);
    }
  };
}
function unMarkPasswordForgotten() {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return dispatch => {
    return new Promise(resolve => {
      (0, _backgroundConnection.callBackgroundMethod)('unMarkPasswordForgotten', [], () => {
        resolve();
      });
    }).then(() => forceUpdateMetamaskState(dispatch));
  };
}
function closeWelcomeScreen() {
  return {
    type: actionConstants.CLOSE_WELCOME_SCREEN
  };
}

//
// unlock screen
//

function unlockInProgress() {
  return {
    type: actionConstants.UNLOCK_IN_PROGRESS
  };
}
function unlockFailed(message) {
  return {
    type: actionConstants.UNLOCK_FAILED,
    value: message
  };
}
function unlockSucceeded(message) {
  return {
    type: actionConstants.UNLOCK_SUCCEEDED,
    value: message
  };
}
function setShowConnectionsRemovedModal(showConnectionsRemovedModal) {
  return {
    type: actionConstants.SET_SHOW_CONNECTIONS_REMOVED,
    value: showConnectionsRemovedModal
  };
}
function updateMetamaskState(patches) {
  return (dispatch, getState) => {
    var _newState$addressBook, _currentState$address;
    const state = getState();
    const providerConfig = (0, _networks.getProviderConfig)(state);
    const {
      metamask: currentState
    } = state;
    if (!(patches !== null && patches !== void 0 && patches.length)) {
      return currentState;
    }
    const newState = applyPatches(currentState, patches);
    const {
      currentLocale
    } = currentState;
    const currentInternalAccount = (0, _selectors.getSelectedInternalAccount)(state);
    const selectedAddress = currentInternalAccount === null || currentInternalAccount === void 0 ? void 0 : currentInternalAccount.address;
    const {
      currentLocale: newLocale
    } = newState;
    const newProviderConfig = (0, _networks.getProviderConfig)({
      metamask: newState
    });
    const newInternalAccount = (0, _selectors.getSelectedInternalAccount)({
      metamask: newState
    });
    const newSelectedAddress = newInternalAccount === null || newInternalAccount === void 0 ? void 0 : newInternalAccount.address;
    if (currentLocale && newLocale && currentLocale !== newLocale) {
      dispatch(updateCurrentLocale(newLocale));
    }
    if (selectedAddress !== newSelectedAddress) {
      dispatch({
        type: actionConstants.SELECTED_ADDRESS_CHANGED
      });
    }
    const newAddressBook = ((_newState$addressBook = newState.addressBook) === null || _newState$addressBook === void 0 ? void 0 : _newState$addressBook[newProviderConfig === null || newProviderConfig === void 0 ? void 0 : newProviderConfig.chainId]) ?? {};
    const oldAddressBook = ((_currentState$address = currentState.addressBook) === null || _currentState$address === void 0 ? void 0 : _currentState$address[providerConfig === null || providerConfig === void 0 ? void 0 : providerConfig.chainId]) ?? {};

    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    const newAccounts = (0, _selectors.getMetaMaskAccounts)({
      metamask: newState
    });

    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    const oldAccounts = (0, _selectors.getMetaMaskAccounts)({
      metamask: currentState
    });
    const newSelectedAccount = newAccounts[newSelectedAddress];
    const oldSelectedAccount = newAccounts[selectedAddress];
    // dispatch an ACCOUNT_CHANGED for any account whose balance or other
    // properties changed in this update
    Object.entries(oldAccounts).forEach(([address, oldAccount]) => {
      if (!(0, _lodash.isEqual)(oldAccount, newAccounts[address])) {
        dispatch({
          type: actionConstants.ACCOUNT_CHANGED,
          payload: {
            account: newAccounts[address]
          }
        });
      }
    });

    // Also emit an event for the selected account changing, either due to a
    // property update or if the entire account changes.
    if ((0, _lodash.isEqual)(oldSelectedAccount, newSelectedAccount) === false) {
      dispatch({
        type: actionConstants.SELECTED_ACCOUNT_CHANGED,
        payload: {
          account: newSelectedAccount
        }
      });
    }
    // We need to keep track of changing address book entries
    if ((0, _lodash.isEqual)(oldAddressBook, newAddressBook) === false) {
      dispatch({
        type: actionConstants.ADDRESS_BOOK_UPDATED,
        payload: {
          addressBook: newAddressBook
        }
      });
    }

    // track when gasFeeEstimates change
    if ((0, _lodash.isEqual)(currentState.gasFeeEstimates, newState.gasFeeEstimates) === false) {
      dispatch({
        type: actionConstants.GAS_FEE_ESTIMATES_UPDATED,
        payload: {
          gasFeeEstimates: newState.gasFeeEstimates,
          gasEstimateType: newState.gasEstimateType
        }
      });
    }
    dispatch({
      type: actionConstants.UPDATE_METAMASK_STATE,
      value: newState
    });
    if (providerConfig.chainId !== newProviderConfig.chainId) {
      dispatch({
        type: actionConstants.CHAIN_CHANGED,
        payload: newProviderConfig.chainId
      });
      // We dispatch this action to ensure that the send state stays up to date
      // after the chain changes. This async thunk will fail gracefully in the
      // event that we are not yet on the send flow with a draftTransaction in
      // progress.

      dispatch((0, _send.initializeSendState)({
        chainHasChanged: true
      }));
    }
    return newState;
  };
}
const backgroundSetLocked = () => {
  return new Promise((resolve, reject) => {
    (0, _backgroundConnection.callBackgroundMethod)('setLocked', [], error => {
      if (error) {
        reject(error);
        return;
      }
      resolve();
    });
  });
};
function lockMetamask(message) {
  _loglevel.default.debug(`background.setLocked`);

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return dispatch => {
    dispatch(showLoadingIndication(message));
    return backgroundSetLocked().then(() => forceUpdateMetamaskState(dispatch)).catch(error => {
      dispatch(displayWarning((0, _error.getErrorMessage)(error)));
      return Promise.reject(error);
    }).then(() => {
      dispatch(hideLoadingIndication());
      dispatch({
        type: actionConstants.LOCK_METAMASK
      });
    }).catch(() => {
      dispatch(hideLoadingIndication());
      dispatch({
        type: actionConstants.LOCK_METAMASK
      });
    });
  };
}
async function _setSelectedInternalAccount(accountId) {
  _loglevel.default.debug(`background.setSelectedInternalAccount`);
  await (0, _backgroundConnection.submitRequestToBackground)('setSelectedInternalAccount', [accountId]);
}

/**
 * Update the selected multichain account.
 *
 * @param accountGroupId - ID of an account group representing the multichain account.
 */
function setSelectedMultichainAccount(accountGroupId) {
  return async (dispatch, _getState) => {
    _loglevel.default.debug(`background.setSelectedMultichainAccount`);
    try {
      dispatch(showLoadingIndication());
      await (0, _backgroundConnection.submitRequestToBackground)('setSelectedMultichainAccount', [accountGroupId]);
      // Forcing update of the state speeds up the UI update process
      // and makes UX better
      await forceUpdateMetamaskState(dispatch);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
    } finally {
      dispatch(hideLoadingIndication());
    }
  };
}

/**
 * Create a new multichain account.
 *
 * @param walletId - ID of a wallet.
 */
function createNextMultichainAccountGroup(walletId) {
  return async dispatch => {
    _loglevel.default.debug(`background.createNextMultichainAccountGroup`);
    try {
      const walletIdWithoutTypePrefix = (0, _utils2.stripWalletTypePrefixFromWalletId)(walletId);
      await (0, _backgroundConnection.submitRequestToBackground)('createNextMultichainAccountGroup', [walletIdWithoutTypePrefix]);
      // Forcing update of the state speeds up the UI update process
      // and makes UX better
      await forceUpdateMetamaskState(dispatch);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
    }
  };
}

/**
 * Set the pinned state of an account group.
 *
 * @param accountGroupId - ID of an account group.
 * @param pinned - Whether the account group should be pinned.
 */
function setAccountGroupPinned(accountGroupId, pinned) {
  return async dispatch => {
    _loglevel.default.debug(`background.setAccountGroupPinned`);
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('setAccountGroupPinned', [accountGroupId, pinned]);
      // Forcing update of the state speeds up the UI update process
      // and makes UX better
      await forceUpdateMetamaskState(dispatch);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
    }
  };
}

/**
 * Set the hidden state of an account group.
 *
 * @param accountGroupId - ID of an account group.
 * @param hidden - Whether the account group should be hidden.
 */
function setAccountGroupHidden(accountGroupId, hidden) {
  return async dispatch => {
    _loglevel.default.debug(`background.setAccountGroupHidden`);
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('setAccountGroupHidden', [accountGroupId, hidden]);
      // Forcing update of the state speeds up the UI update process
      // and makes UX better
      await forceUpdateMetamaskState(dispatch);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
    }
  };
}

/**
 * Set a new account group name (rename a multichain account).
 *
 * @param accountGroupId - ID of a multichain account group.
 * @param newAccountName - New name for a multichain account.
 */
function setAccountGroupName(accountGroupId, newAccountName) {
  return async dispatch => {
    _loglevel.default.debug(`background.setAccountGroupName`);
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('setAccountGroupName', [accountGroupId, newAccountName]);
      // Forcing update of the state speeds up the UI update process
      // and makes UX better
      await forceUpdateMetamaskState(dispatch);
      return true;
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      return false;
    }
  };
}

/**
 * Sets the selected internal account.
 *
 * @param accountId - The ID of the account to set as selected.
 * @returns A thunk action that dispatches loading and warning indications.
 */
function setSelectedInternalAccount(accountId) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`background.setSelectedInternalAccount`);
    try {
      await _setSelectedInternalAccount(accountId);
    } catch (error) {
      dispatch(displayWarning(error));
      return;
    } finally {
      dispatch(hideLoadingIndication());
    }
  };
}

/**
 * Sets the selected internal account without loading indication.
 *
 * @param accountId - The ID of the account to set as selected.
 * @returns A thunk action that dispatches an account switch.
 */
function setSelectedInternalAccountWithoutLoading(accountId) {
  return async dispatch => {
    try {
      await _setSelectedInternalAccount(accountId);
      await forceUpdateMetamaskState(dispatch);
    } catch (error) {
      dispatch(displayWarning(error));
    }
  };
}
function setSelectedAccount(address) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async (dispatch, getState) => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`background.setSelectedAccount`);
    const state = getState();
    const unconnectedAccountAccountAlertIsEnabled = (0, _metamask.getUnconnectedAccountAlertEnabledness)(state);
    const activeTabOrigin = state.activeTab.origin;
    const prevAccount = (0, _selectors.getSelectedInternalAccount)(state);
    const nextAccount = (0, _selectors.getInternalAccountByAddress)(state, address);
    const permittedAccountsForCurrentTab = (0, _selectors.getAllPermittedAccountsForCurrentTab)(state);
    const currentTabIsConnectedToPreviousAddress = (0, _chainAgnosticPermission.isInternalAccountInPermittedAccountIds)(prevAccount, permittedAccountsForCurrentTab);
    const currentTabIsConnectedToNextAddress = (0, _chainAgnosticPermission.isInternalAccountInPermittedAccountIds)(nextAccount, permittedAccountsForCurrentTab);
    const switchingToUnconnectedAddress = Boolean(activeTabOrigin) && currentTabIsConnectedToPreviousAddress && !currentTabIsConnectedToNextAddress;
    try {
      await _setSelectedInternalAccount(nextAccount.id);
      await forceUpdateMetamaskState(dispatch);
    } catch (error) {
      dispatch(displayWarning(error));
      return;
    } finally {
      dispatch(hideLoadingIndication());
    }
    if (unconnectedAccountAccountAlertIsEnabled && switchingToUnconnectedAddress) {
      dispatch((0, _unconnectedAccount.switchedToUnconnectedAccount)());
      await setUnconnectedAccountAlertShown(activeTabOrigin);
    }
  };
}
function addPermittedAccount(origin, address) {
  return async dispatch => {
    await new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('addPermittedAccount', [origin, address], error => {
        if (error) {
          reject(error);
          return;
        }
        resolve();
      });
    });
    await forceUpdateMetamaskState(dispatch);
  };
}
function addPermittedAccounts(origin, address) {
  return async dispatch => {
    await new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('addPermittedAccounts', [origin, address], error => {
        if (error) {
          reject(error);
          return;
        }
        resolve();
      });
    });
    await forceUpdateMetamaskState(dispatch);
  };
}
function removePermittedAccount(origin, address) {
  return async dispatch => {
    await new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('removePermittedAccount', [origin, address], error => {
        if (error) {
          reject(error);
          return;
        }
        resolve();
      });
    });
    await forceUpdateMetamaskState(dispatch);
  };
}
function setPermittedAccounts(origin, caipAccountIds) {
  return async dispatch => {
    await new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('setPermittedAccounts', [origin, caipAccountIds], error => {
        if (error) {
          reject(error);
          return;
        }
        resolve();
      });
    });
    await forceUpdateMetamaskState(dispatch);
  };
}
function addPermittedChain(origin, chainId) {
  return async dispatch => {
    await new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('addPermittedChain', [origin, chainId], error => {
        if (error) {
          reject(error);
          return;
        }
        resolve();
      });
    });
    await forceUpdateMetamaskState(dispatch);
  };
}
function addPermittedChains(origin, chainIds) {
  return async dispatch => {
    await new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('addPermittedChains', [origin, chainIds], error => {
        if (error) {
          reject(error);
          return;
        }
        resolve();
      });
    });
    await forceUpdateMetamaskState(dispatch);
  };
}
function removePermittedChain(origin, chainId) {
  return async dispatch => {
    await new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('removePermittedChain', [origin, chainId], error => {
        if (error) {
          reject(error);
          return;
        }
        resolve();
      });
    });
    await forceUpdateMetamaskState(dispatch);
  };
}
function setPermittedChains(origin, chainIds) {
  return async dispatch => {
    await new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('setPermittedChains', [origin, chainIds], error => {
        if (error) {
          reject(error);
          return;
        }
        resolve();
      });
    });
    await forceUpdateMetamaskState(dispatch);
  };
}
function showAccountsPage() {
  return {
    type: actionConstants.SHOW_ACCOUNTS_PAGE
  };
}
function showConfTxPage({
  id
} = {}) {
  return {
    type: actionConstants.SHOW_CONF_TX_PAGE,
    id
  };
}
function setShowSupportDataConsentModal(show) {
  return {
    type: actionConstants.SET_SHOW_SUPPORT_DATA_CONSENT_MODAL,
    payload: show
  };
}
function clearProductTour() {
  return async () => {
    return (0, _backgroundConnection.submitRequestToBackground)('setProductTour', ['']);
  };
}
function addToken({
  address,
  symbol,
  decimals,
  image,
  networkClientId
}, dontShowLoadingIndicator) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    if (!address) {
      throw new Error('MetaMask - Cannot add token without address');
    }
    if (!dontShowLoadingIndicator) {
      dispatch(showLoadingIndication());
    }
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('addToken', [{
        address,
        symbol,
        decimals,
        image,
        networkClientId
      }]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      dispatch(displayWarning(error));
    } finally {
      await forceUpdateMetamaskState(dispatch);
      dispatch(hideLoadingIndication());
    }
  };
}

/**
 * To add the tokens user selected to state
 *
 * @param tokensToImport
 * @param networkClientId
 */
function addImportedTokens(tokensToImport, networkClientId) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('addImportedTokens', [tokensToImport, networkClientId]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
    } finally {
      await forceUpdateMetamaskState(dispatch);
    }
  };
}

/**
 * To add ignored token addresses to state
 *
 * @param options
 * @param options.tokensToIgnore
 * @param options.networkClientId
 * @param options.dontShowLoadingIndicator
 */
function ignoreTokens({
  tokensToIgnore,
  dontShowLoadingIndicator = false,
  networkClientId = null
}) {
  const _tokensToIgnore = Array.isArray(tokensToIgnore) ? tokensToIgnore : [tokensToIgnore];

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    if (!dontShowLoadingIndicator) {
      dispatch(showLoadingIndication());
    }
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('ignoreTokens', [_tokensToIgnore, networkClientId]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      dispatch(displayWarning(error));
    } finally {
      await forceUpdateMetamaskState(dispatch);
      dispatch(hideLoadingIndication());
    }
  };
}

/**
 * To fetch the ERC20 tokens with non-zero balance in a single call
 *
 * @param selectedAddress - the targeted account
 * @param tokensToDetect - the targeted list of tokens
 * @param networkClientId - unique identifier for the network client
 */
async function getBalancesInSingleCall(selectedAddress, tokensToDetect, networkClientId) {
  return await (0, _backgroundConnection.submitRequestToBackground)('getBalancesInSingleCall', [selectedAddress, tokensToDetect, networkClientId]);
}

/**
 * Find networkClientId for the chainId passed.
 *
 * @param chainId - chainId of the network
 */
async function findNetworkClientIdByChainId(chainId) {
  return await (0, _backgroundConnection.submitRequestToBackground)('findNetworkClientIdByChainId', [chainId]);
}
function addNft(address, tokenID, networkClientId, dontShowLoadingIndicator) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    if (!address) {
      throw new Error('MetaMask - Cannot add NFT without address');
    }
    if (!tokenID) {
      throw new Error('MetaMask - Cannot add NFT without tokenID');
    }
    if (!dontShowLoadingIndicator) {
      dispatch(showLoadingIndication());
    }
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('addNft', [address, tokenID, networkClientId]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      dispatch(displayWarning(error));
    } finally {
      await forceUpdateMetamaskState(dispatch);
      dispatch(hideLoadingIndication());
    }
  };
}
function addNftVerifyOwnership(address, tokenID, networkClientId, dontShowLoadingIndicator) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    if (!address) {
      throw new Error('MetaMask - Cannot add NFT without address');
    }
    if (!tokenID) {
      throw new Error('MetaMask - Cannot add NFT without tokenID');
    }
    if (!networkClientId) {
      throw new Error('MetaMask - Cannot add NFT without a networkClientId');
    }
    if (!dontShowLoadingIndicator) {
      dispatch(showLoadingIndication());
    }
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('addNftVerifyOwnership', [address, tokenID, networkClientId]);
    } catch (error) {
      if ((0, _error.isErrorWithMessage)(error)) {
        const message = (0, _error.getErrorMessage)(error);
        if (message.includes('This NFT is not owned by the user') || message.includes('Unable to verify ownership')) {
          throw error;
        } else {
          (0, _error.logErrorWithMessage)(error);
          dispatch(displayWarning(error));
        }
      }
    } finally {
      await forceUpdateMetamaskState(dispatch);
      dispatch(hideLoadingIndication());
    }
  };
}
function removeAndIgnoreNft(address, tokenID, networkClientId, shouldShowLoadingIndicator) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    if (!address) {
      throw new Error('MetaMask - Cannot ignore NFT without address');
    }
    if (!tokenID) {
      throw new Error('MetaMask - Cannot ignore NFT without tokenID');
    }
    if (!shouldShowLoadingIndicator) {
      dispatch(showLoadingIndication());
    }
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('removeAndIgnoreNft', [address, tokenID, networkClientId]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      dispatch(displayWarning(error));
      throw error;
    } finally {
      await forceUpdateMetamaskState(dispatch);
      dispatch(hideLoadingIndication());
    }
  };
}
function removeNft(address, tokenID, networkClientId, dontShowLoadingIndicator) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    if (!address) {
      throw new Error('MetaMask - Cannot remove NFT without address');
    }
    if (!tokenID) {
      throw new Error('MetaMask - Cannot remove NFT without tokenID');
    }
    if (!dontShowLoadingIndicator) {
      dispatch(showLoadingIndication());
    }
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('removeNft', [address, tokenID, networkClientId]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      dispatch(displayWarning(error));
    } finally {
      await forceUpdateMetamaskState(dispatch);
      dispatch(hideLoadingIndication());
    }
  };
}
async function checkAndUpdateAllNftsOwnershipStatus(networkClientId) {
  await (0, _backgroundConnection.submitRequestToBackground)('checkAndUpdateAllNftsOwnershipStatus', [networkClientId]);
}
async function isNftOwner(ownerAddress, nftAddress, nftId, networkClientId) {
  return await (0, _backgroundConnection.submitRequestToBackground)('isNftOwner', [ownerAddress, nftAddress, nftId, networkClientId]);
}
async function checkAndUpdateSingleNftOwnershipStatus(nft, networkClientId) {
  await (0, _backgroundConnection.submitRequestToBackground)('checkAndUpdateSingleNftOwnershipStatus', [nft, false, networkClientId]);
}
async function getNFTContractInfo(contractAddresses, chainId) {
  return await (0, _backgroundConnection.submitRequestToBackground)('getNFTContractInfo', [contractAddresses, chainId]);
}

// When we upgrade to TypeScript 4.5 this is part of the language. It will get
// the underlying type of a Promise generic type. So Awaited<Promise<void>> is
// void.
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention

async function getTokenStandardAndDetails(address, userAddress, tokenId) {
  return await (0, _backgroundConnection.submitRequestToBackground)('getTokenStandardAndDetails', [address, userAddress, tokenId]);
}
async function getTokenStandardAndDetailsByChain(address, userAddress, tokenId, chainId) {
  return await (0, _backgroundConnection.submitRequestToBackground)('getTokenStandardAndDetailsByChain', [address, userAddress, tokenId, chainId]);
}
async function getTokenSymbol(address) {
  return await (0, _backgroundConnection.submitRequestToBackground)('getTokenSymbol', [address]);
}
function clearPendingTokens() {
  return {
    type: actionConstants.CLEAR_PENDING_TOKENS
  };
}

/**
 * Action to switch globally selected network and set switched network details
 * for the purpose of displaying the user a toast about the network change
 *
 * @param networkClientIdForThisDomain - Thet network client ID last used by the origin
 */
function automaticallySwitchNetwork(networkClientIdForThisDomain) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await dispatch(setActiveNetworkConfigurationId(networkClientIdForThisDomain));
    await forceUpdateMetamaskState(dispatch);
  };
}

/**
 * Update the currentPopupid generated when the user opened the popup
 *
 * @param id - The Snap interface ID.
 * @returns Promise Resolved on successfully submitted background request.
 */
function setCurrentExtensionPopupId(id) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('setCurrentExtensionPopupId', [id]);
    await forceUpdateMetamaskState(dispatch);
  };
}
function abortTransactionSigning(transactionId

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
) {
  return async dispatch => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('abortTransactionSigning', [transactionId]);
    } catch (error) {
      dispatch(displayWarning(error));
    }
  };
}
function getLayer1GasFee({
  chainId,
  networkClientId,
  transactionParams
}) {
  return async () => await (0, _backgroundConnection.submitRequestToBackground)('getLayer1GasFee', [{
    chainId,
    networkClientId,
    transactionParams
  }]);
}
function createCancelTransaction(txId, customGasSettings, options = {}) {
  _loglevel.default.debug('background.createCancelTransaction');
  let newTxId;

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return dispatch => {
    const actionId = (0, _backgroundConnection.generateActionId)();
    return new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('createCancelTransaction', [txId, customGasSettings, {
        ...options,
        actionId
      }], (err, newState) => {
        if (err) {
          var _err$message;
          if (err !== null && err !== void 0 && (_err$message = err.message) !== null && _err$message !== void 0 && _err$message.includes('Previous transaction is already confirmed')) {
            dispatch(showModal({
              name: 'TRANSACTION_ALREADY_CONFIRMED',
              originalTransactionId: txId
            }));
          }
          dispatch(displayWarning(err));
          reject(err);
          return;
        }
        if (newState) {
          const currentNetworkTxList = (0, _selectors.getCurrentNetworkTransactions)({
            metamask: newState
          });
          const {
            id
          } = currentNetworkTxList[currentNetworkTxList.length - 1];
          newTxId = id;
          resolve();
        }
      });
    }).then(() => forceUpdateMetamaskState(dispatch)).then(() => newTxId);
  };
}
function createSpeedUpTransaction(txId, customGasSettings, options = {}) {
  _loglevel.default.debug('background.createSpeedUpTransaction');
  let newTx;

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return dispatch => {
    const actionId = (0, _backgroundConnection.generateActionId)();
    return new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('createSpeedUpTransaction', [txId, customGasSettings, {
        ...options,
        actionId
      }], (err, newState) => {
        if (err) {
          dispatch(displayWarning(err));
          reject(err);
          return;
        }
        if (newState) {
          const currentNetworkTxList = (0, _selectors.getCurrentNetworkTransactions)(newState);
          newTx = currentNetworkTxList[currentNetworkTxList.length - 1];
          resolve();
        }
      });
    }).then(() => forceUpdateMetamaskState(dispatch)).then(() => newTx);
  };
}
function updateIncomingTransactions() {
  return async dispatch => {
    _loglevel.default.debug(`background.updateIncomingTransactions`);
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('updateIncomingTransactions');
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      dispatch(displayWarning('Had a problem updating incoming transactions!'));
    }
  };
}
function createRetryTransaction(txId, customGasSettings) {
  let newTx;

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return dispatch => {
    return new Promise((resolve, reject) => {
      const actionId = (0, _backgroundConnection.generateActionId)();
      (0, _backgroundConnection.callBackgroundMethod)('createSpeedUpTransaction', [txId, customGasSettings, {
        actionId
      }], (err, newState) => {
        if (err) {
          dispatch(displayWarning(err));
          reject(err);
          return;
        }
        if (newState) {
          const currentNetworkTxList = (0, _selectors.getCurrentNetworkTransactions)(newState);
          newTx = currentNetworkTxList[currentNetworkTxList.length - 1];
          resolve();
        }
      });
    }).then(() => forceUpdateMetamaskState(dispatch)).then(() => newTx);
  };
}
function addNetwork(networkConfiguration) {
  return async dispatch => {
    _loglevel.default.debug(`background.addNetwork`, networkConfiguration);
    try {
      return await (0, _backgroundConnection.submitRequestToBackground)('addNetwork', [networkConfiguration]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      dispatch(displayWarning('Had a problem adding networks!'));
    }
    return undefined;
  };
}
function updateNetwork(networkConfiguration, options = {}) {
  return async dispatch => {
    _loglevel.default.debug(`background.updateNetwork`, networkConfiguration);
    try {
      return await (0, _backgroundConnection.submitRequestToBackground)('updateNetwork', [networkConfiguration.chainId, networkConfiguration, options]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      dispatch(displayWarning('Had a problem updading networks!'));
    }
    return undefined;
  };
}
function setActiveNetwork(id) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    _loglevel.default.debug(`background.setActiveNetwork: ${id}`);
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('setActiveNetwork', [id]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      dispatch(displayWarning('Had a problem changing networks!'));
    }
  };
}
function setActiveNetworkWithError(networkConfigurationId) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    _loglevel.default.debug(`background.setActiveNetwork: ${networkConfigurationId}`);
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('setActiveNetwork', [networkConfigurationId]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      dispatch(displayWarning('Had a problem changing networks!'));
      throw new Error('Had a problem changing networks!');
    }
  };
}
function getNetworksWithTransactionActivityByAccounts() {
  return async () => {
    _loglevel.default.debug('background.getNetworksWithTransactionActivityByAccounts');
    try {
      return await (0, _backgroundConnection.submitRequestToBackground)('getNetworksWithTransactionActivityByAccounts');
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      throw new Error('Had a problem getting networks with activity by accounts!');
    }
  };
}
function setActiveNetworkConfigurationId(networkConfigurationId) {
  return async () => {
    _loglevel.default.debug(`background.setActiveNetworkConfigurationId: ${networkConfigurationId}`);
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('setActiveNetworkConfigurationId', [networkConfigurationId]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
    }
  };
}
function rollbackToPreviousProvider() {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('rollbackToPreviousProvider');
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      dispatch(displayWarning('Had a problem changing networks!'));
    }
  };
}
function removeNetwork(chainId) {
  return async () => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('removeNetwork', [chainId]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
    }
  };
}

// Calls the addressBookController to add a new address.
function addToAddressBook(recipient, nickname = '', memo = '', customChainId) {
  _loglevel.default.debug(`background.addToAddressBook`);

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async (dispatch, getState) => {
    const chainId = customChainId || (0, _networks.getProviderConfig)(getState()).chainId;
    let set;
    try {
      set = await (0, _backgroundConnection.submitRequestToBackground)('setAddressBook', [(0, _hexstringUtils.toChecksumHexAddress)(recipient), nickname, chainId, memo]);
      await forceUpdateMetamaskState(dispatch);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      dispatch(displayWarning('Address book failed to update'));
      throw error;
    }
    if (!set) {
      dispatch(displayWarning('Address book failed to update'));
    }
  };
}

/**
 * @description Calls the addressBookController to remove an existing address.
 * @param chainId
 * @param addressToRemove - Address of the entry to remove from the address book
 */
function removeFromAddressBook(chainId, addressToRemove) {
  _loglevel.default.debug(`background.removeFromAddressBook`);

  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('removeFromAddressBook', [chainId, (0, _hexstringUtils.toChecksumHexAddress)(addressToRemove)]);
    await forceUpdateMetamaskState(dispatch);
  };
}
function showNetworkDropdown() {
  return {
    type: actionConstants.NETWORK_DROPDOWN_OPEN
  };
}
function hideNetworkDropdown() {
  return {
    type: actionConstants.NETWORK_DROPDOWN_CLOSE
  };
}
function showImportTokensModal() {
  return {
    type: actionConstants.IMPORT_TOKENS_POPOVER_OPEN
  };
}
function hideImportTokensModal() {
  return {
    type: actionConstants.IMPORT_TOKENS_POPOVER_CLOSE
  };
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any

function showModal(payload) {
  return {
    type: actionConstants.MODAL_OPEN,
    payload
  };
}
function hideModal() {
  return {
    type: actionConstants.MODAL_CLOSE
  };
}
function showImportNftsModal(payload) {
  return {
    type: actionConstants.IMPORT_NFTS_MODAL_OPEN,
    payload
  };
}
function hideImportNftsModal() {
  return {
    type: actionConstants.IMPORT_NFTS_MODAL_CLOSE
  };
}
function hidePermittedNetworkToast() {
  return {
    type: actionConstants.SHOW_PERMITTED_NETWORK_TOAST_CLOSE
  };
}
function showPermittedNetworkToast() {
  return {
    type: actionConstants.SHOW_PERMITTED_NETWORK_TOAST_OPEN
  };
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function setConfirmationExchangeRates(value) {
  return {
    type: actionConstants.SET_CONFIRMATION_EXCHANGE_RATES,
    value
  };
}
function showIpfsModal() {
  return {
    type: actionConstants.SHOW_IPFS_MODAL_OPEN
  };
}
function hideIpfsModal() {
  return {
    type: actionConstants.SHOW_IPFS_MODAL_CLOSE
  };
}
function closeCurrentNotificationWindow() {
  return (_, getState) => {
    const state = getState();
    const approvalFlows = (0, _selectors.getApprovalFlows)(state);
    if ((0, _util.getEnvironmentType)() === _app.ENVIRONMENT_TYPE_NOTIFICATION && !(0, _selectors.hasTransactionPendingApprovals)(state) && !(0, _selectors.getIsSigningQRHardwareTransaction)(state) && approvalFlows.length === 0) {
      attemptCloseNotificationPopup();
    }
  };
}
function showAlert(msg) {
  return {
    type: actionConstants.ALERT_OPEN,
    payload: msg
  };
}
function hideAlert() {
  return {
    type: actionConstants.ALERT_CLOSE
  };
}
function showDeprecatedNetworkModal() {
  return {
    type: actionConstants.DEPRECATED_NETWORK_POPOVER_OPEN
  };
}
function hideDeprecatedNetworkModal() {
  return {
    type: actionConstants.DEPRECATED_NETWORK_POPOVER_CLOSE
  };
}

/**
 * TODO: this should be moved somewhere else when it makese sense to do so
 */

function updateNftDropDownState(value) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('updateNftDropDownState', [value]);
    await forceUpdateMetamaskState(dispatch);
  };
}
/**
 * This action will receive two types of values via qrCodeData
 * an object with the following structure {type, values}
 * or null (used to clear the previous value)
 *
 * @param qrCodeData
 */
function qrCodeDetected(qrCodeData) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await dispatch({
      type: actionConstants.QR_CODE_DETECTED,
      value: qrCodeData
    });

    // If on the send page, the send slice will listen for the QR_CODE_DETECTED
    // action and update its state. Address changes need to recompute gasLimit
    // so we fire this method so that the send page gasLimit can be recomputed
    dispatch((0, _send.computeEstimatedGasLimit)());
  };
}
function showLoadingIndication(message) {
  return {
    type: actionConstants.SHOW_LOADING,
    payload: message
  };
}
function showNftStillFetchingIndication() {
  return {
    type: actionConstants.SHOW_NFT_STILL_FETCHING_INDICATION
  };
}
function setHardwareWalletDefaultHdPath({
  device,
  path
}) {
  return {
    type: actionConstants.SET_HARDWARE_WALLET_DEFAULT_HD_PATH,
    payload: {
      device,
      path
    }
  };
}
function hideLoadingIndication() {
  return {
    type: actionConstants.HIDE_LOADING
  };
}
function setSlides(slides) {
  return {
    type: actionConstants.SET_SLIDES,
    slides
  };
}
function hideNftStillFetchingIndication() {
  return {
    type: actionConstants.HIDE_NFT_STILL_FETCHING_INDICATION
  };
}

/**
 * An action creator for display a warning to the user in various places in the
 * UI. It will not be cleared until a new warning replaces it or `hideWarning`
 * is called.
 *
 * @deprecated This way of displaying a warning is confusing for users and
 * should no longer be used.
 * @param payload - The warning to show.
 * @returns The action to display the warning.
 */
function displayWarning(payload) {
  if ((0, _error.isErrorWithMessage)(payload)) {
    var _cause;
    return {
      type: actionConstants.DISPLAY_WARNING,
      payload: (payload === null || payload === void 0 || (_cause = payload.cause) === null || _cause === void 0 ? void 0 : _cause.message) || payload.message
    };
  } else if (typeof payload === 'string') {
    return {
      type: actionConstants.DISPLAY_WARNING,
      payload
    };
  }
  return {
    type: actionConstants.DISPLAY_WARNING,
    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31893
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    payload: `${payload}`
  };
}
function hideWarning() {
  return {
    type: actionConstants.HIDE_WARNING
  };
}
function exportAccount(password, address, setPrivateKey, setShowHoldToReveal) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return function (dispatch) {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`background.verifyPassword`);
    return new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('verifyPassword', [password], function (err) {
        if (err) {
          _loglevel.default.error('Error in verifying password.');
          dispatch(hideLoadingIndication());
          dispatch(displayWarning('Incorrect Password.'));
          reject(err);
          return;
        }
        _loglevel.default.debug(`background.exportAccount`);
        (0, _backgroundConnection.callBackgroundMethod)('exportAccount', [address, password], function (err2, result) {
          dispatch(hideLoadingIndication());
          if (err2) {
            (0, _error.logErrorWithMessage)(err2);
            dispatch(displayWarning('Had a problem exporting the account.'));
            reject(err2);
            return;
          }
          setPrivateKey(result);
          setShowHoldToReveal(true);
          resolve(result);
        });
      });
    });
  };
}
function exportAccounts(password, addresses) {
  return function (dispatch) {
    _loglevel.default.debug(`background.verifyPassword`);
    return new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('verifyPassword', [password], function (err) {
        if (err) {
          _loglevel.default.error('Error in submitting password.');
          reject(err);
          return;
        }
        _loglevel.default.debug(`background.exportAccounts`);
        const accountPromises = addresses.map(address => new Promise((resolve2, reject2) => (0, _backgroundConnection.callBackgroundMethod)('exportAccount', [address, password], function (err2, result) {
          if (err2) {
            (0, _error.logErrorWithMessage)(err2);
            dispatch(displayWarning('Had a problem exporting the account.'));
            reject2(err2);
            return;
          }
          resolve2(result);
        })));
        resolve(Promise.all(accountPromises));
      });
    });
  };
}
function showPrivateKey(key) {
  return {
    type: actionConstants.SHOW_PRIVATE_KEY,
    payload: key
  };
}
function setAccountLabel(account, label) {
  return dispatch => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`background.setAccountLabel`);
    return new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('setAccountLabel', [account, label], err => {
        dispatch(hideLoadingIndication());
        if (err) {
          dispatch(displayWarning(err));
          reject(err);
          return;
        }
        dispatch({
          type: actionConstants.SET_ACCOUNT_LABEL,
          value: {
            account,
            label
          }
        });
        resolve(account);
      });
    });
  };
}
function clearAccountDetails() {
  return {
    type: actionConstants.CLEAR_ACCOUNT_DETAILS
  };
}
function showSendTokenPage() {
  return {
    type: actionConstants.SHOW_SEND_TOKEN_PAGE
  };
}

// TODO: Lift to shared folder when it makes sense

function setFeatureFlag(feature, activated, notificationType) {
  return dispatch => {
    dispatch(showLoadingIndication());
    return new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('setFeatureFlag', [feature, activated], (err, updatedFeatureFlags) => {
        dispatch(hideLoadingIndication());
        if (err) {
          dispatch(displayWarning(err));
          reject(err);
          return;
        }
        notificationType && dispatch(showModal({
          name: notificationType
        }));
        resolve(updatedFeatureFlags);
      });
    });
  };
}
function setPreference(preference, value, showLoading = true) {
  return dispatch => {
    showLoading && dispatch(showLoadingIndication());
    return new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('setPreference', [preference, value], (err, updatedPreferences) => {
        showLoading && dispatch(hideLoadingIndication());
        if (err) {
          dispatch(displayWarning(err));
          reject(err);
          return;
        }
        resolve(updatedPreferences);
      });
    });
  };
}
function setDefaultHomeActiveTabName(value) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('setDefaultHomeActiveTabName', [value]);
    await forceUpdateMetamaskState(dispatch);
  };
}
function setShowNativeTokenAsMainBalancePreference(value) {
  return setPreference('showNativeTokenAsMainBalance', value);
}
function setHideZeroBalanceTokens(value) {
  return setPreference('hideZeroBalanceTokens', value);
}
function setShowFiatConversionOnTestnetsPreference(value) {
  return setPreference('showFiatInTestnets', value);
}
function setShowTestNetworks(value) {
  return setPreference('showTestNetworks', value);
}
function setPrivacyMode(value) {
  return setPreference('privacyMode', value, false);
}
function setFeatureNotificationsEnabled(value) {
  return setPreference('featureNotificationsEnabled', value);
}
function setShowExtensionInFullSizeView(value) {
  return setPreference('showExtensionInFullSizeView', value);
}
function setDismissSmartAccountSuggestionEnabled(value) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async (dispatch, getState) => {
    const prevDismissSmartAccountSuggestionEnabled = (0, _preferences.getDismissSmartAccountSuggestionEnabled)(getState());
    trackMetaMetricsEvent({
      category: _metametrics.MetaMetricsEventCategory.Settings,
      event: _metametrics.MetaMetricsEventName.SettingsUpdated,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        dismiss_smt_acc_suggestion_enabled: value,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        prev_dismiss_smt_acc_suggestion_enabled: prevDismissSmartAccountSuggestionEnabled
      }
    });
    await dispatch(setPreference('dismissSmartAccountSuggestionEnabled', value));
    await forceUpdateMetamaskState(dispatch);
  };
}
function setSmartAccountOptIn(value) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async (dispatch, getState) => {
    const prevUseSmartAccount = (0, _preferences.getUseSmartAccount)(getState());
    trackMetaMetricsEvent({
      category: _metametrics.MetaMetricsEventCategory.Settings,
      event: _metametrics.MetaMetricsEventName.SettingsUpdated,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        use_smart_account: value,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        prev_use_smart_account: prevUseSmartAccount
      }
    });
    await dispatch(setPreference('smartAccountOptIn', value));
    await forceUpdateMetamaskState(dispatch);
  };
}
function setTokenSortConfig(value) {
  return setPreference('tokenSortConfig', value, false);
}
function setTokenNetworkFilter(value) {
  return setPreference('tokenNetworkFilter', value, false);
}
function setSmartTransactionsPreferenceEnabled(value) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async (dispatch, getState) => {
    const smartTransactionsOptInStatus = (0, _selectors2.getSmartTransactionsOptInStatusInternal)(getState());
    trackMetaMetricsEvent({
      category: _metametrics.MetaMetricsEventCategory.Settings,
      event: _metametrics.MetaMetricsEventName.SettingsUpdated,
      properties: {
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        stx_opt_in: value,
        // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
        // eslint-disable-next-line @typescript-eslint/naming-convention
        prev_stx_opt_in: smartTransactionsOptInStatus
      }
    });
    await dispatch(setPreference('smartTransactionsOptInStatus', value));
    await forceUpdateMetamaskState(dispatch);
  };
}
function setShowMultiRpcModal(value) {
  return setPreference('showMultiRpcModal', value);
}
function setAutoLockTimeLimit(value) {
  return setPreference('autoLockTimeLimit', value);
}
function setCompletedOnboarding() {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    dispatch(showLoadingIndication());
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('completeOnboarding');
      dispatch(completeOnboarding());
    } catch (err) {
      dispatch(displayWarning(err));
      throw err;
    } finally {
      dispatch(hideLoadingIndication());
    }
  };
}
function completeOnboarding() {
  return {
    type: actionConstants.COMPLETE_ONBOARDING
  };
}
function resetOnboarding() {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async (dispatch, getState) => {
    try {
      const isSocialLoginFlow = (0, _selectors.getIsSocialLoginFlow)(getState());
      dispatch(resetOnboardingAction());
      if (isSocialLoginFlow) {
        await dispatch(resetOAuthLoginState());
      }

      // reset metametrics optin status
      dispatch(setParticipateInMetaMetrics(null));
    } catch (err) {
      console.error(err);
    }
  };
}
function resetOnboardingAction() {
  return {
    type: actionConstants.RESET_ONBOARDING
  };
}
function setServiceWorkerKeepAlivePreference(value) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`background.setServiceWorkerKeepAlivePreference`);
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('setServiceWorkerKeepAlivePreference', [value]);
    } catch (error) {
      dispatch(displayWarning(error));
    } finally {
      dispatch(hideLoadingIndication());
    }
  };
}
async function forceUpdateMetamaskState(dispatch) {
  let pendingPatches;
  try {
    pendingPatches = await (0, _backgroundConnection.submitRequestToBackground)('getStatePatches');
  } catch (error) {
    dispatch(displayWarning(error));
    throw error;
  }
  return dispatch(updateMetamaskState(pendingPatches));
}
function toggleAccountMenu() {
  return {
    type: actionConstants.TOGGLE_ACCOUNT_MENU
  };
}
function toggleNetworkMenu(payload) {
  return {
    type: actionConstants.TOGGLE_NETWORK_MENU,
    payload
  };
}
function setAccountDetailsAddress(address) {
  return {
    type: actionConstants.SET_ACCOUNT_DETAILS_ADDRESS,
    payload: address
  };
}
function setParticipateInMetaMetrics(participationPreference) {
  return dispatch => {
    _loglevel.default.debug(`background.setParticipateInMetaMetrics`);
    return new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('setParticipateInMetaMetrics', [participationPreference], (err, metaMetricsId) => {
        _loglevel.default.debug(err);
        if (err) {
          dispatch(displayWarning(err));
          reject(err);
          return;
        }
        dispatch({
          type: actionConstants.SET_PARTICIPATE_IN_METAMETRICS,
          value: participationPreference
        });
        resolve([participationPreference, metaMetricsId]);
      });
    });
  };
}
function setDataCollectionForMarketing(dataCollectionPreference) {
  return async dispatch => {
    _loglevel.default.debug(`background.setDataCollectionForMarketing`);
    await (0, _backgroundConnection.submitRequestToBackground)('setDataCollectionForMarketing', [dataCollectionPreference]);
    dispatch({
      type: actionConstants.SET_DATA_COLLECTION_FOR_MARKETING,
      value: dataCollectionPreference
    });
  };
}

/**
 * Sets marketing consent with OAuth service for social login users.
 *
 * @param hasEmailMarketingConsent - Boolean value for marketing consent
 */
function setMarketingConsent(hasEmailMarketingConsent) {
  return async () => {
    try {
      const res = await (0, _backgroundConnection.submitRequestToBackground)('setMarketingConsent', [hasEmailMarketingConsent]);
      return Boolean(res);
    } catch (error) {
      (0, _error.logErrorWithMessage)((0, _error.getErrorMessage)(error));
      return false;
    }
  };
}

/**
 * Gets marketing consent with OAuth service for social login users.
 */
async function getMarketingConsent() {
  try {
    const res = await (0, _backgroundConnection.submitRequestToBackground)('getMarketingConsent');
    return Boolean(res);
  } catch (error) {
    (0, _error.logErrorWithMessage)((0, _error.getErrorMessage)(error));
    return false;
  }
}

/**
 * @deprecated Use setAvatarType instead
 * @param val - Boolean value for blockie preference
 */
function setUseBlockie(val) {
  return dispatch => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`background.setUseBlockie`);
    (0, _backgroundConnection.callBackgroundMethod)('setUseBlockie', [val], err => {
      dispatch(hideLoadingIndication());
      if (err) {
        dispatch(displayWarning(err));
      }
    });
  };
}
function setAvatarType(value) {
  return setPreference('avatarType', value);
}
function setUsePhishDetect(val) {
  return dispatch => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`background.setUsePhishDetect`);
    (0, _backgroundConnection.callBackgroundMethod)('setUsePhishDetect', [val], err => {
      dispatch(hideLoadingIndication());
      if (err) {
        dispatch(displayWarning(err));
      }
    });
  };
}
function setUseMultiAccountBalanceChecker(val) {
  return dispatch => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`background.setUseMultiAccountBalanceChecker`);
    (0, _backgroundConnection.callBackgroundMethod)('setUseMultiAccountBalanceChecker', [val], err => {
      dispatch(hideLoadingIndication());
      if (err) {
        dispatch(displayWarning(err));
      }
    });
  };
}
function setUseSafeChainsListValidation(val) {
  return dispatch => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`background.setUseSafeChainsListValidation`);
    (0, _backgroundConnection.callBackgroundMethod)('setUseSafeChainsListValidation', [val], err => {
      dispatch(hideLoadingIndication());
      if (err) {
        dispatch(displayWarning(err));
      }
    });
  };
}
function setUseTokenDetection(val) {
  return dispatch => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`background.setUseTokenDetection`);
    (0, _backgroundConnection.callBackgroundMethod)('setUseTokenDetection', [val], err => {
      dispatch(hideLoadingIndication());
      if (err) {
        dispatch(displayWarning(err));
      }
    });
  };
}
function setOpenSeaEnabled(val) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`background.setOpenSeaEnabled`);
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('setOpenSeaEnabled', [val]);
    } finally {
      dispatch(hideLoadingIndication());
    }
  };
}
function setUseNftDetection(val) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`background.setUseNftDetection`);
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('setUseNftDetection', [val]);
    } finally {
      dispatch(hideLoadingIndication());
    }
  };
}
function setUse4ByteResolution(val) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`background.setUse4ByteResolution`);
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('setUse4ByteResolution', [val]);
    } catch (error) {
      dispatch(displayWarning(error));
    } finally {
      dispatch(hideLoadingIndication());
    }
  };
}
function setUseCurrencyRateCheck(val) {
  return dispatch => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`background.setUseCurrencyRateCheck`);
    (0, _backgroundConnection.callBackgroundMethod)('setUseCurrencyRateCheck', [val], err => {
      dispatch(hideLoadingIndication());
      if (err) {
        dispatch(displayWarning(err));
      }
    });
  };
}

// MultichainAssetsRatesController
function fetchHistoricalPricesForAsset(address, internalAccount) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    _loglevel.default.debug(`background.fetchHistoricalPricesForAsset`);
    await (0, _backgroundConnection.submitRequestToBackground)('fetchHistoricalPricesForAsset', [address, internalAccount]);
    await forceUpdateMetamaskState(dispatch);
  };
}

// TokenDetectionController
function detectTokens() {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`background.detectTokens`);
    await (0, _backgroundConnection.submitRequestToBackground)('detectTokens');
    dispatch(hideLoadingIndication());
    await forceUpdateMetamaskState(dispatch);
  };
}

// TODO: with support of non EVM, check if possible to refactor this and get chainIds from the state in the fct instead of passing it as a param
function detectNfts(chainIds) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    dispatch(showNftStillFetchingIndication());
    _loglevel.default.debug(`background.detectNfts`);
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('detectNfts', [chainIds]);
    } finally {
      dispatch(hideNftStillFetchingIndication());
    }
    await forceUpdateMetamaskState(dispatch);
  };
}
function setAdvancedGasFee(val) {
  return dispatch => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`background.setAdvancedGasFee`);
    (0, _backgroundConnection.callBackgroundMethod)('setAdvancedGasFee', [val], err => {
      dispatch(hideLoadingIndication());
      if (err) {
        dispatch(displayWarning(err));
      }
    });
  };
}
function setTheme(val) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    dispatch(showLoadingIndication());
    _loglevel.default.debug(`background.setTheme`);
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('setTheme', [val]);
    } finally {
      dispatch(hideLoadingIndication());
    }
  };
}
function setIpfsGateway(val) {
  return dispatch => {
    _loglevel.default.debug(`background.setIpfsGateway`);
    (0, _backgroundConnection.callBackgroundMethod)('setIpfsGateway', [val], err => {
      if (err) {
        dispatch(displayWarning(err));
      }
    });
  };
}
function toggleExternalServices(val) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    _loglevel.default.debug(`background.toggleExternalServices`);
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('toggleExternalServices', [val]);
      await forceUpdateMetamaskState(dispatch);
    } catch (err) {
      dispatch(displayWarning(err));
    }
  };
}
function setIsIpfsGatewayEnabled(val) {
  return dispatch => {
    _loglevel.default.debug(`background.setIsIpfsGatewayEnabled`);
    (0, _backgroundConnection.callBackgroundMethod)('setIsIpfsGatewayEnabled', [val], err => {
      if (err) {
        dispatch(displayWarning(err));
      }
    });
  };
}
function setUseAddressBarEnsResolution(val) {
  return dispatch => {
    _loglevel.default.debug(`background.setUseAddressBarEnsResolution`);
    (0, _backgroundConnection.callBackgroundMethod)('setUseAddressBarEnsResolution', [val], err => {
      if (err) {
        dispatch(displayWarning(err));
      }
    });
  };
}
function updateCurrentLocale(key) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    dispatch(showLoadingIndication());
    try {
      await (0, _i18n.loadRelativeTimeFormatLocaleData)(key);
      const localeMessages = await (0, _i18n.fetchLocale)(key);
      const textDirection = await (0, _backgroundConnection.submitRequestToBackground)('setCurrentLocale', [key]);
      (0, _switchDirection.switchDirection)(textDirection);
      dispatch(setCurrentLocale(key, localeMessages));
    } catch (error) {
      dispatch(displayWarning(error));
      return;
    } finally {
      dispatch(hideLoadingIndication());
    }
  };
}
function setCurrentLocale(locale, messages) {
  return {
    type: actionConstants.SET_CURRENT_LOCALE,
    payload: {
      locale,
      messages
    }
  };
}
function setPendingTokens(pendingTokens) {
  const {
    customToken,
    selectedTokens = {},
    tokenAddressList = []
  } = pendingTokens;
  const tokens = customToken !== null && customToken !== void 0 && customToken.address && customToken !== null && customToken !== void 0 && customToken.symbol && Boolean((customToken === null || customToken === void 0 ? void 0 : customToken.decimals) >= 0 && (customToken === null || customToken === void 0 ? void 0 : customToken.decimals) <= 36) ? {
    ...selectedTokens,
    [customToken.address]: {
      ...customToken,
      isCustom: true
    }
  } : selectedTokens;
  Object.keys(tokens).forEach(tokenAddress => {
    const found = tokenAddressList.find(addr => (0, _stringUtils.isEqualCaseInsensitive)(addr, tokenAddress));
    tokens[tokenAddress] = {
      ...tokens[tokenAddress],
      unlisted: !found
    };
  });
  return {
    type: actionConstants.SET_PENDING_TOKENS,
    payload: tokens
  };
}

// Swaps

function setSwapsLiveness(swapsLiveness) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('setSwapsLiveness', [swapsLiveness]);
    await forceUpdateMetamaskState(dispatch);
  };
}
function setSwapsFeatureFlags(featureFlags) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('setSwapsFeatureFlags', [featureFlags]);
    await forceUpdateMetamaskState(dispatch);
  };
}
function fetchAndSetQuotes(fetchParams, fetchParamsMetaData) {
  return async dispatch => {
    const [quotes, selectedAggId] = await (0, _trace.trace)({
      name: _trace.TraceName.SwapQuotesFetched
    }, async () => await (0, _backgroundConnection.submitRequestToBackground)('fetchAndSetQuotes', [fetchParams, fetchParamsMetaData]));
    await forceUpdateMetamaskState(dispatch);
    return [quotes, selectedAggId];
  };
}
function setSelectedQuoteAggId(aggId) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('setSelectedQuoteAggId', [aggId]);
    await forceUpdateMetamaskState(dispatch);
  };
}
function setSwapsTokens(tokens) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('setSwapsTokens', [tokens]);
    await forceUpdateMetamaskState(dispatch);
  };
}
function clearSwapsQuotes() {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('clearSwapsQuotes');
    await forceUpdateMetamaskState(dispatch);
  };
}
function resetBackgroundSwapsState() {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('resetSwapsState');
    await forceUpdateMetamaskState(dispatch);
  };
}
function setCustomApproveTxData(data) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('setCustomApproveTxData', [data]);
    await forceUpdateMetamaskState(dispatch);
  };
}
function setSwapsTxGasPrice(gasPrice) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('setSwapsTxGasPrice', [gasPrice]);
    await forceUpdateMetamaskState(dispatch);
  };
}
function setSwapsTxGasLimit(gasLimit) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('setSwapsTxGasLimit', [gasLimit, true]);
    await forceUpdateMetamaskState(dispatch);
  };
}
function updateCustomSwapsEIP1559GasParams({
  gasLimit,
  maxFeePerGas,
  maxPriorityFeePerGas
}) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await Promise.all([(0, _backgroundConnection.submitRequestToBackground)('setSwapsTxGasLimit', [gasLimit]), (0, _backgroundConnection.submitRequestToBackground)('setSwapsTxMaxFeePerGas', [maxFeePerGas]), (0, _backgroundConnection.submitRequestToBackground)('setSwapsTxMaxFeePriorityPerGas', [maxPriorityFeePerGas])]);
    await forceUpdateMetamaskState(dispatch);
  };
}

// Note that the type widening happening below will resolve when we switch gas
// constants to TypeScript, at which point we'll get better type safety.
// TODO: Remove this comment when gas constants is typescript
function updateSwapsUserFeeLevel(swapsCustomUserFeeLevel) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('setSwapsUserFeeLevel', [swapsCustomUserFeeLevel]);
    await forceUpdateMetamaskState(dispatch);
  };
}
function setSwapsQuotesPollingLimitEnabled(quotesPollingLimitEnabled) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('setSwapsQuotesPollingLimitEnabled', [quotesPollingLimitEnabled]);
    await forceUpdateMetamaskState(dispatch);
  };
}
function safeRefetchQuotes() {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('safeRefetchQuotes');
    await forceUpdateMetamaskState(dispatch);
  };
}
function stopPollingForQuotes() {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('stopPollingForQuotes');
    await forceUpdateMetamaskState(dispatch);
  };
}
function setBackgroundSwapRouteState(routeState) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('setBackgroundSwapRouteState', [routeState]);
    await forceUpdateMetamaskState(dispatch);
  };
}
function resetSwapsPostFetchState() {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('resetPostFetchState');
    await forceUpdateMetamaskState(dispatch);
  };
}
function setSwapsErrorKey(errorKey) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('setSwapsErrorKey', [errorKey]);
    await forceUpdateMetamaskState(dispatch);
  };
}
function setInitialGasEstimate(initialAggId) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('setInitialGasEstimate', [initialAggId]);
    await forceUpdateMetamaskState(dispatch);
  };
}

// Permissions

function requestAccountsAndChainPermissionsWithId(origin) {
  return async dispatch => {
    const id = await (0, _backgroundConnection.submitRequestToBackground)('requestAccountsAndChainPermissionsWithId', [origin]);
    await forceUpdateMetamaskState(dispatch);
    return id;
  };
}

/**
 * Approves the permissions request.
 *
 * @param request - The permissions request to approve.
 */
function approvePermissionsRequest(request) {
  return dispatch => {
    (0, _backgroundConnection.callBackgroundMethod)('approvePermissionsRequest', [request], err => {
      if (err) {
        dispatch(displayWarning(err));
      }
      forceUpdateMetamaskState(dispatch);
    });
  };
}

/**
 * Rejects the permissions request with the given ID.
 *
 * @param requestId - The id of the request to be rejected
 */
function rejectPermissionsRequest(requestId) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return dispatch => {
    return new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('rejectPermissionsRequest', [requestId], err => {
        if (err) {
          dispatch(displayWarning(err));
          reject(err);
          return;
        }
        forceUpdateMetamaskState(dispatch).then(resolve).catch(reject);
      });
    });
  };
}

/**
 * Clears the given permissions for the given origin.
 *
 * @param subjects
 */
function removePermissionsFor(subjects) {
  return dispatch => {
    (0, _backgroundConnection.callBackgroundMethod)('removePermissionsFor', [subjects], err => {
      if (err) {
        dispatch(displayWarning(err));
      }
    });
  };
}

/**
 * Updates the order of networks after drag and drop
 *
 * @param chainIds - An array of hexadecimal chain IDs
 */
function updateNetworksList(chainIds) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async () => {
    await (0, _backgroundConnection.submitRequestToBackground)('updateNetworksList', [chainIds]);
  };
}

/**
 * Updates the pinned accounts list
 *
 * @param pinnedAccountList
 */
function updateAccountsList(pinnedAccountList) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async () => {
    await (0, _backgroundConnection.submitRequestToBackground)('updateAccountsList', [pinnedAccountList]);
  };
}

/**
 * Sets the enabled networks in the controller state.
 * This method updates the enabledNetworkMap to mark specified networks as enabled.
 * It can handle both a single chain ID or an array of chain IDs.
 *
 * Sets the enabled networks in the controller state.
 * Only a single network or all networks can be enabled at once, not an arbitrary subset.
 * Uses actions from controller-actions/network-order-controller.ts for better control.
 *
 * @param chainId - A single chainId (e.g. 'eip155:1') to be enabled. All other networks will be implicitly disabled.
 */
function setEnabledNetworks(chainId) {
  return async () => {
    await (0, _backgroundConnection.submitRequestToBackground)('setEnabledNetworks', [chainId]);
  };
}

/**
 * Enables all popular networks in the controller state.
 *
 * @returns callback to enable all popular networks.
 */
function setEnabledAllPopularNetworks() {
  return async () => {
    await (0, _backgroundConnection.submitRequestToBackground)('setEnabledAllPopularNetworks');
  };
}

/**
 * Hides account in the accounts list
 *
 * @param hiddenAccountList
 */
function updateHiddenAccountsList(hiddenAccountList) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async () => {
    await (0, _backgroundConnection.submitRequestToBackground)('updateHiddenAccountsList', [hiddenAccountList]);
  };
}

// Pending Approvals

/**
 * Resolves a pending approval and closes the current notification window if no
 * further approvals are pending after the background state updates.
 *
 * @param id - The pending approval id
 * @param [value] - The value required to confirm a pending approval
 */
function resolvePendingApproval(id, value) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async _dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('resolvePendingApproval', [id, value]);
    // Before closing the current window, check if any additional confirmations
    // are added as a result of this confirmation being accepted

    const {
      pendingApprovals
    } = await forceUpdateMetamaskState(_dispatch);
    if (Object.values(pendingApprovals).length === 0) {
      _dispatch(closeCurrentNotificationWindow());
    }
  };
}

/**
 * Rejects a pending approval and closes the current notification window if no
 * further approvals are pending after the background state updates.
 *
 * @param id - The pending approval id
 * @param [error] - The error to throw when rejecting the approval
 */
function rejectPendingApproval(id, error) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('rejectPendingApproval', [id, error]);
    // Before closing the current window, check if any additional confirmations
    // are added as a result of this confirmation being rejected
    const {
      pendingApprovals
    } = await forceUpdateMetamaskState(dispatch);
    if (Object.values(pendingApprovals).length === 0) {
      dispatch(closeCurrentNotificationWindow());
    }
  };
}

/**
 * Rejects all approvals for the given messages
 *
 * @param messageList - The list of messages to reject
 */
function rejectAllMessages(messageList) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    const userRejectionError = (0, _rpcErrors.serializeError)(_rpcErrors.providerErrors.userRejectedRequest());
    await Promise.all(messageList.map(async ({
      id
    }) => await (0, _backgroundConnection.submitRequestToBackground)('rejectPendingApproval', [id, userRejectionError])));
    const {
      pendingApprovals
    } = await forceUpdateMetamaskState(dispatch);
    if (Object.values(pendingApprovals).length === 0) {
      dispatch(closeCurrentNotificationWindow());
    }
  };
}
function updateThrottledOriginState(origin, throttledOriginState) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async () => {
    await (0, _backgroundConnection.submitRequestToBackground)('updateThrottledOriginState', [origin, throttledOriginState]);
  };
}
function setFirstTimeFlowType(type) {
  return async dispatch => {
    try {
      _loglevel.default.debug(`background.setFirstTimeFlowType`);
      await (0, _backgroundConnection.submitRequestToBackground)('setFirstTimeFlowType', [type]);
      dispatch({
        type: actionConstants.SET_FIRST_TIME_FLOW_TYPE,
        value: type
      });
    } catch (err) {
      dispatch(displayWarning(err));
    }
  };
}
function setSelectedNetworkConfigurationId(networkConfigurationId) {
  return {
    type: actionConstants.SET_SELECTED_NETWORK_CONFIGURATION_ID,
    payload: networkConfigurationId
  };
}
function setNewNetworkAdded({
  networkConfigurationId,
  nickname
}) {
  return {
    type: actionConstants.SET_NEW_NETWORK_ADDED,
    payload: {
      networkConfigurationId,
      nickname
    }
  };
}
function setEditedNetwork(payload = undefined) {
  return {
    type: actionConstants.SET_EDIT_NETWORK,
    payload
  };
}
function setNewNftAddedMessage(newNftAddedMessage) {
  return {
    type: actionConstants.SET_NEW_NFT_ADDED_MESSAGE,
    payload: newNftAddedMessage
  };
}
function setRemoveNftMessage(removeNftMessage) {
  return {
    type: actionConstants.SET_REMOVE_NFT_MESSAGE,
    payload: removeNftMessage
  };
}
function setNewTokensImported(newTokensImported) {
  return {
    type: actionConstants.SET_NEW_TOKENS_IMPORTED,
    payload: newTokensImported
  };
}
function setNewTokensImportedError(newTokensImportedError) {
  return {
    type: actionConstants.SET_NEW_TOKENS_IMPORTED_ERROR,
    payload: newTokensImportedError
  };
}
function setLastActiveTime() {
  return dispatch => {
    (0, _backgroundConnection.callBackgroundMethod)('setLastActiveTime', [], err => {
      if (err) {
        dispatch(displayWarning(err));
      }
    });
  };
}
function setDismissSeedBackUpReminder(value) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    dispatch(showLoadingIndication());
    await (0, _backgroundConnection.submitRequestToBackground)('setDismissSeedBackUpReminder', [value]);
    dispatch(hideLoadingIndication());
  };
}
function setOverrideContentSecurityPolicyHeader(value) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    dispatch(showLoadingIndication());
    await (0, _backgroundConnection.submitRequestToBackground)('setOverrideContentSecurityPolicyHeader', [value]);
    dispatch(hideLoadingIndication());
  };
}
function setManageInstitutionalWallets(value) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    dispatch(showLoadingIndication());
    await (0, _backgroundConnection.submitRequestToBackground)('setManageInstitutionalWallets', [value]);
    dispatch(hideLoadingIndication());
  };
}
function getRpcMethodPreferences() {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    dispatch(showLoadingIndication());
    await (0, _backgroundConnection.submitRequestToBackground)('getRpcMethodPreferences', []);
    dispatch(hideLoadingIndication());
  };
}
function setConnectedStatusPopoverHasBeenShown() {
  return () => {
    (0, _backgroundConnection.callBackgroundMethod)('setConnectedStatusPopoverHasBeenShown', [], err => {
      if ((0, _error.isErrorWithMessage)(err)) {
        throw new Error((0, _error.getErrorMessage)(err));
      }
    });
  };
}
function setRecoveryPhraseReminderHasBeenShown() {
  return () => {
    (0, _backgroundConnection.callBackgroundMethod)('setRecoveryPhraseReminderHasBeenShown', [], err => {
      if ((0, _error.isErrorWithMessage)(err)) {
        throw new Error((0, _error.getErrorMessage)(err));
      }
    });
  };
}
function setRecoveryPhraseReminderLastShown(lastShown) {
  return () => {
    (0, _backgroundConnection.callBackgroundMethod)('setRecoveryPhraseReminderLastShown', [lastShown], err => {
      if ((0, _error.isErrorWithMessage)(err)) {
        throw new Error((0, _error.getErrorMessage)(err));
      }
    });
  };
}
function setTermsOfUseLastAgreed(lastAgreed) {
  return async () => {
    await (0, _backgroundConnection.submitRequestToBackground)('setTermsOfUseLastAgreed', [lastAgreed]);
  };
}
async function setUpdateModalLastDismissedAt(updateModalLastDismissedAt) {
  await (0, _backgroundConnection.submitRequestToBackground)('setUpdateModalLastDismissedAt', [updateModalLastDismissedAt]);
}
function setLastViewedUserSurvey(id) {
  return async () => {
    await (0, _backgroundConnection.submitRequestToBackground)('setLastViewedUserSurvey', [id]);
  };
}
function setOutdatedBrowserWarningLastShown(lastShown) {
  return async () => {
    await (0, _backgroundConnection.submitRequestToBackground)('setOutdatedBrowserWarningLastShown', [lastShown]);
  };
}
function getContractMethodData(data = '') {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async (dispatch, getState) => {
    const prefixedData = (0, _util.addHexPrefix)(data);
    const fourBytePrefix = prefixedData.slice(0, 10);
    if (fourBytePrefix.length < 10) {
      return {};
    }
    const {
      knownMethodData,
      use4ByteResolution
    } = getState().metamask;
    if (knownMethodData !== null && knownMethodData !== void 0 && knownMethodData[fourBytePrefix] && Object.keys(knownMethodData[fourBytePrefix]).length !== 0) {
      return knownMethodData[fourBytePrefix];
    }
    _loglevel.default.debug(`loadingMethodData`);
    const {
      name,
      params
    } = await (0, _fourByte.getMethodDataAsync)(fourBytePrefix, use4ByteResolution);
    (0, _backgroundConnection.callBackgroundMethod)('addKnownMethodData', [fourBytePrefix, {
      name,
      params
    }], err => {
      if (err) {
        dispatch(displayWarning(err));
      }
    });
    return {
      name,
      params
    };
  };
}
function setSeedPhraseBackedUp(seedPhraseBackupState) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return dispatch => {
    _loglevel.default.debug(`background.setSeedPhraseBackedUp`);
    return new Promise((resolve, reject) => {
      (0, _backgroundConnection.callBackgroundMethod)('setSeedPhraseBackedUp', [seedPhraseBackupState], err => {
        if (err) {
          dispatch(displayWarning(err));
          reject(err);
          return;
        }
        forceUpdateMetamaskState(dispatch).then(resolve).catch(reject);
      });
    });
  };
}
function setNextNonce(nextNonce) {
  return {
    type: actionConstants.SET_NEXT_NONCE,
    payload: nextNonce
  };
}

/**
 * This function initiates the nonceLock in the background for the given
 * address, and returns the next nonce to use. It then calls setNextNonce which
 * sets the nonce in state on the nextNonce key. NOTE: The nextNonce key is
 * actually ephemeral application state. It does not appear to be part of the
 * background state.
 *
 * TODO: move this to a different slice, MetaMask slice will eventually be
 * deprecated because it should not contain any ephemeral/app state but just
 * background state. In addition we should key nextNonce by address to prevent
 * accidental usage of a stale nonce as the call to getNextNonce only works for
 * the currently selected address.
 *
 * @param address - address for which nonce lock should be obtained.
 * @param networkClientId - networkClientId for network for which nonce lock is needed.
 * @returns
 */
function getNextNonce(address, networkClientId) {
  return async (dispatch, getState) => {
    const networkClientIdValue = networkClientId ?? (0, _networks.getSelectedNetworkClientId)(getState());
    let nextNonce;
    try {
      nextNonce = await (0, _backgroundConnection.submitRequestToBackground)('getNextNonce', [address, networkClientIdValue]);
    } catch (error) {
      dispatch(displayWarning(error));
      throw error;
    }
    dispatch(setNextNonce(nextNonce));
    return nextNonce;
  };
}
function setRequestAccountTabIds(requestAccountTabIds) {
  return {
    type: actionConstants.SET_REQUEST_ACCOUNT_TABS,
    payload: requestAccountTabIds
  };
}
function getRequestAccountTabIds() {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    const requestAccountTabIds = await (0, _backgroundConnection.submitRequestToBackground)('getRequestAccountTabIds');
    dispatch(setRequestAccountTabIds(requestAccountTabIds));
  };
}
function setOpenMetamaskTabsIDs(openMetaMaskTabIDs) {
  return {
    type: actionConstants.SET_OPEN_METAMASK_TAB_IDS,
    payload: openMetaMaskTabIDs
  };
}
function getOpenMetamaskTabsIds() {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    const openMetaMaskTabIDs = await (0, _backgroundConnection.submitRequestToBackground)('getOpenMetamaskTabsIds');
    dispatch(setOpenMetamaskTabsIDs(openMetaMaskTabIDs));
  };
}
async function attemptLedgerTransportCreation() {
  return await (0, _backgroundConnection.submitRequestToBackground)('attemptLedgerTransportCreation');
}

/**
 * This method deduplicates error reports to sentry by maintaining a state
 * object 'singleExceptions' in the app slice. The only place this state object
 * is accessed from is within this method, to check if it has already seen and
 * therefore tracked this error. This is to avoid overloading sentry with lots
 * of duplicate errors.
 *
 * @param error
 * @returns
 */
function captureSingleException(error) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async (dispatch, getState) => {
    const {
      singleExceptions
    } = getState().appState;
    if (!(error in singleExceptions)) {
      dispatch({
        type: actionConstants.CAPTURE_SINGLE_EXCEPTION,
        value: error
      });
      (0, _sentry.captureException)(Error(error));
    }
  };
}

// Wrappers around promisifedBackground
/**
 * The "actions" below are not actions nor action creators. They cannot use
 * dispatch nor should they be dispatched when used. Instead they can be
 * called directly. These wrappers will be moved into their location at some
 * point in the future.
 */

function estimateGas(params) {
  return (0, _backgroundConnection.submitRequestToBackground)('estimateGas', [params]);
}
async function updateTokenType(tokenAddress) {
  try {
    return await (0, _backgroundConnection.submitRequestToBackground)('updateTokenType', [tokenAddress]);
  } catch (error) {
    (0, _error.logErrorWithMessage)(error);
  }
  return undefined;
}
async function addPollingTokenToAppState(pollingToken) {
  return (0, _backgroundConnection.submitRequestToBackground)('addPollingTokenToAppState', [pollingToken, _app.POLLING_TOKEN_ENVIRONMENT_TYPES[(0, _util.getEnvironmentType)()]]);
}
async function removePollingTokenFromAppState(pollingToken) {
  return (0, _backgroundConnection.submitRequestToBackground)('removePollingTokenFromAppState', [pollingToken, _app.POLLING_TOKEN_ENVIRONMENT_TYPES[(0, _util.getEnvironmentType)()]]);
}

/**
 * Informs the CurrencyRateController that the UI requires currency rate polling
 *
 * @param nativeCurrencies - An array of native currency symbols
 * @returns polling token that can be used to stop polling
 */
async function currencyRateStartPolling(nativeCurrencies) {
  const pollingToken = await (0, _backgroundConnection.submitRequestToBackground)('currencyRateStartPolling', [{
    nativeCurrencies
  }]);
  await addPollingTokenToAppState(pollingToken);
  return pollingToken;
}

/**
 * Informs the CurrencyRateController that the UI no longer requires currency rate polling
 * for the given network client.
 * If all network clients unsubscribe, the controller stops polling.
 *
 * @param pollingToken - Poll token received from calling currencyRateStartPolling
 */
async function currencyRateStopPollingByPollingToken(pollingToken) {
  await (0, _backgroundConnection.submitRequestToBackground)('currencyRateStopPollingByPollingToken', [pollingToken]);
  await removePollingTokenFromAppState(pollingToken);
}

/**
 * Informs the TokenDetectionController that the UI requires token detection polling
 *
 * @param chainIds - An array of chain ids to poll token detection on.
 * @returns polling token that can be used to stop polling.
 */
async function tokenDetectionStartPolling(chainIds) {
  const pollingToken = await (0, _backgroundConnection.submitRequestToBackground)('tokenDetectionStartPolling', [{
    chainIds
  }]);
  await addPollingTokenToAppState(pollingToken);
  return pollingToken;
}

/**
 * Informs the TokenDetectionController that the UI no longer token detection polling
 *
 * @param pollingToken - Poll token received from calling tokenDetectionStartPolling
 */
async function tokenDetectionStopPollingByPollingToken(pollingToken) {
  await (0, _backgroundConnection.submitRequestToBackground)('tokenDetectionStopPollingByPollingToken', [pollingToken]);
  await removePollingTokenFromAppState(pollingToken);
}

/**
 * Informs the TokenListController that the UI requires token list polling
 *
 * @param chainId
 * @returns polling token that can be used to stop polling
 */
async function tokenListStartPolling(chainId) {
  const pollingToken = await (0, _backgroundConnection.submitRequestToBackground)('tokenListStartPolling', [{
    chainId
  }]);
  await addPollingTokenToAppState(pollingToken);
  return pollingToken;
}

/**
 * Informs the TokenListController that the UI no longer token list polling
 *
 * @param pollingToken - Poll token received from calling tokenListStartPolling
 */
async function tokenListStopPollingByPollingToken(pollingToken) {
  await (0, _backgroundConnection.submitRequestToBackground)('tokenListStopPollingByPollingToken', [pollingToken]);
  await removePollingTokenFromAppState(pollingToken);
}
async function tokenBalancesStartPolling(chainIds) {
  const pollingToken = await (0, _backgroundConnection.submitRequestToBackground)('tokenBalancesStartPolling', [{
    chainIds
  }]);
  await addPollingTokenToAppState(pollingToken);
  return pollingToken;
}
async function tokenBalancesStopPollingByPollingToken(pollingToken) {
  await (0, _backgroundConnection.submitRequestToBackground)('tokenBalancesStopPollingByPollingToken', [pollingToken]);
  await removePollingTokenFromAppState(pollingToken);
}
async function updateBalancesFoAccounts(chainIds, queryAllAccounts) {
  await (0, _backgroundConnection.submitRequestToBackground)('updateBalances', [{
    chainIds,
    queryAllAccounts
  }]);
}

/**
 * Informs the TokenRatesController that the UI requires
 * token rate polling for the given chain id.
 *
 * @param chainIds - An array of chain ids to poll token rates on.
 * @returns polling token that can be used to stop polling
 */
async function tokenRatesStartPolling(chainIds) {
  const pollingToken = await (0, _backgroundConnection.submitRequestToBackground)('tokenRatesStartPolling', [{
    chainIds
  }]);
  await addPollingTokenToAppState(pollingToken);
  return pollingToken;
}

/**
 * Informs the TokenRatesController that the UI no longer
 * requires token rate polling for the given chain id.
 *
 * @param pollingToken -
 */
async function tokenRatesStopPollingByPollingToken(pollingToken) {
  await (0, _backgroundConnection.submitRequestToBackground)('tokenRatesStopPollingByPollingToken', [pollingToken]);
  await removePollingTokenFromAppState(pollingToken);
}

/**
 * Starts polling on accountTrackerController with the networkClientId
 *
 * @param networkClientId - The network client ID to pull balances for.
 * @returns polling token used to stop polling
 */
async function accountTrackerStartPolling(networkClientId) {
  const pollingToken = await (0, _backgroundConnection.submitRequestToBackground)('accountTrackerStartPolling', [networkClientId]);
  await addPollingTokenToAppState(pollingToken);
  return pollingToken;
}

/**
 * Stops polling on the account tracker controller.
 *
 * @param pollingToken - polling token to use to stop polling.
 */
async function accountTrackerStopPollingByPollingToken(pollingToken) {
  await (0, _backgroundConnection.submitRequestToBackground)('accountTrackerStopPollingByPollingToken', [pollingToken]);
  await removePollingTokenFromAppState(pollingToken);
}

/**
 * Informs the GasFeeController that the UI requires gas fee polling
 *
 * @param networkClientId - unique identifier for the network client
 * @returns polling token that can be used to stop polling
 */
async function gasFeeStartPollingByNetworkClientId(networkClientId) {
  const pollingToken = await (0, _backgroundConnection.submitRequestToBackground)('gasFeeStartPolling', [{
    networkClientId
  }]);
  await addPollingTokenToAppState(pollingToken);
  return pollingToken;
}

/**
 * Informs the GasFeeController that the UI no longer requires gas fee polling
 * for the given network client.
 * If all network clients unsubscribe, the controller stops polling.
 *
 * @param pollingToken - Poll token received from calling gasFeeStartPolling
 */
async function gasFeeStopPollingByPollingToken(pollingToken) {
  await (0, _backgroundConnection.submitRequestToBackground)('gasFeeStopPollingByPollingToken', [pollingToken]);
  await removePollingTokenFromAppState(pollingToken);
}
function getGasFeeTimeEstimate(maxPriorityFeePerGas, maxFeePerGas) {
  return (0, _backgroundConnection.submitRequestToBackground)('getGasFeeTimeEstimate', [maxPriorityFeePerGas, maxFeePerGas]);
}
async function attemptCloseNotificationPopup() {
  // Check if the current window is NOT a popup - if confirmed, we should not close it
  try {
    const currentWindow = await _webextensionPolyfill.default.windows.getCurrent();
    if (currentWindow.type && currentWindow.type !== 'popup') {
      console.warn(`Not safe to close a window that is not a popup: It is of type: ${currentWindow.type}`);
      // We've confirmed this is not a popup window, so it's not safe to close.
      return;
    }
  } catch (error) {
    // Error occurred while checking window type - we cannot confirm rule out a popup, so continue
    // with the closing attempt as we haven't ruled out that it might be a popup
    console.warn('attemptCloseNotificationPopup: Error encountered while checking window type', error);
  }
  await (0, _backgroundConnection.submitRequestToBackground)('markNotificationPopupAsAutomaticallyClosed');

  // First attempt: Try window.close()
  // This has limitations according to MDN:
  // - Only works on windows opened by Window.open()
  // - Or top-level windows with single history entry
  // - Otherwise fails silently with console error: "Scripts may not close windows that were not opened by script"
  //
  // Note: we opted for window.close() instead of browser.windows.remove(id) because the latter closes the
  // entire window and all its tabs (if there are other tabs open).
  window.close();

  // Second attempt: If we reach here, window.close() failed
  // Try to close via the browser tabs API
  try {
    const tab = await _webextensionPolyfill.default.tabs.getCurrent();
    await _webextensionPolyfill.default.tabs.remove(tab.id);
  } catch (error) {
    // If closing the tab fails, we don't want to close the entire browser window.
    // See issue: https://github.com/MetaMask/metamask-extension/issues/29821
    console.error('attemptCloseNotificationPopup: Failed to close tab', error);
  }
}

/**
 * @param payload - details of the event to track
 * @param options - options for routing/handling of event
 * @returns
 */
function trackMetaMetricsEvent(payload, options) {
  return (0, _backgroundConnection.submitRequestToBackground)('trackMetaMetricsEvent', [{
    ...payload,
    actionId: (0, _backgroundConnection.generateActionId)()
  }, options]);
}
function createEventFragment(options) {
  const actionId = (0, _backgroundConnection.generateActionId)();
  return (0, _backgroundConnection.submitRequestToBackground)('createEventFragment', [{
    ...options,
    actionId
  }]);
}
function createTransactionEventFragment(transactionId) {
  const actionId = (0, _backgroundConnection.generateActionId)();
  return (0, _backgroundConnection.submitRequestToBackground)('createTransactionEventFragment', [{
    transactionId,
    actionId
  }]);
}
function updateEventFragment(id, payload) {
  return (0, _backgroundConnection.submitRequestToBackground)('updateEventFragment', [id, payload]);
}
function finalizeEventFragment(id, options) {
  return (0, _backgroundConnection.submitRequestToBackground)('finalizeEventFragment', [id, options]);
}

/**
 * @param payload - details of the page viewed
 * @param options - options for handling the page view
 */
function trackMetaMetricsPage(payload, options) {
  return (0, _backgroundConnection.submitRequestToBackground)('trackMetaMetricsPage', [{
    ...payload,
    actionId: (0, _backgroundConnection.generateActionId)()
  }, options]);
}
function resetViewedNotifications() {
  return (0, _backgroundConnection.submitRequestToBackground)('resetViewedNotifications');
}
function updateViewedNotifications(notificationIdViewedStatusMap) {
  return (0, _backgroundConnection.submitRequestToBackground)('updateViewedNotifications', [notificationIdViewedStatusMap]);
}
async function setAlertEnabledness(alertId, enabledness) {
  await (0, _backgroundConnection.submitRequestToBackground)('setAlertEnabledness', [alertId, enabledness]);
}
async function setUnconnectedAccountAlertShown(origin) {
  await (0, _backgroundConnection.submitRequestToBackground)('setUnconnectedAccountAlertShown', [origin]);
}
async function setWeb3ShimUsageAlertDismissed(origin) {
  await (0, _backgroundConnection.submitRequestToBackground)('setWeb3ShimUsageAlertDismissed', [origin]);
}

// Smart Transactions Controller
function clearSmartTransactionFees() {
  (0, _backgroundConnection.submitRequestToBackground)('clearSmartTransactionFees');
}
function fetchSmartTransactionFees(unsignedTransaction, approveTxParams) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    if (approveTxParams) {
      approveTxParams.value = '0x0';
    }
    try {
      const smartTransactionFees = await await (0, _backgroundConnection.submitRequestToBackground)('fetchSmartTransactionFees', [unsignedTransaction, approveTxParams]);
      dispatch({
        type: actionConstants.SET_SMART_TRANSACTIONS_ERROR,
        payload: null
      });
      return smartTransactionFees;
    } catch (err) {
      (0, _error.logErrorWithMessage)(err);
      if ((0, _error.isErrorWithMessage)(err)) {
        const errorMessage = (0, _error.getErrorMessage)(err);
        if (errorMessage.startsWith('Fetch error:')) {
          const errorObj = (0, _swaps.parseSmartTransactionsError)(errorMessage);
          dispatch({
            type: actionConstants.SET_SMART_TRANSACTIONS_ERROR,
            payload: errorObj
          });
        }
      }
      throw err;
    }
  };
}
const createSignedTransactions = async (unsignedTransaction, fees, areCancelTransactions) => {
  const unsignedTransactionsWithFees = fees.map(fee => {
    const unsignedTransactionWithFees = {
      ...unsignedTransaction,
      maxFeePerGas: (0, _conversion.decimalToHex)(fee.maxFeePerGas),
      maxPriorityFeePerGas: (0, _conversion.decimalToHex)(fee.maxPriorityFeePerGas),
      gas: areCancelTransactions ? (0, _conversion.decimalToHex)(21000) // It has to be 21000 for cancel transactions, otherwise the API would reject it.
      : unsignedTransaction.gas,
      value: unsignedTransaction.value
    };
    if (areCancelTransactions) {
      unsignedTransactionWithFees.to = unsignedTransactionWithFees.from;
      unsignedTransactionWithFees.data = '0x';
    }
    return unsignedTransactionWithFees;
  });
  const signedTransactions = await (0, _backgroundConnection.submitRequestToBackground)('approveTransactionsWithSameNonce', [unsignedTransactionsWithFees]);
  return signedTransactions;
};
function signAndSendSmartTransaction({
  unsignedTransaction,
  smartTransactionFees
}) {
  return async dispatch => {
    const signedTransactions = await createSignedTransactions(unsignedTransaction, smartTransactionFees.fees);
    try {
      const response = await (0, _backgroundConnection.submitRequestToBackground)('submitSignedTransactions', [{
        signedTransactions,
        // The "signedCanceledTransactions" parameter is still expected by the STX controller but is no longer used.
        // So we are passing an empty array. The parameter may be deprecated in a future update.
        signedCanceledTransactions: [],
        txParams: unsignedTransaction
      }]); // Returns e.g.: { uuid: 'dP23W7c2kt4FK9TmXOkz1UM2F20' }
      return response.uuid;
    } catch (err) {
      (0, _error.logErrorWithMessage)(err);
      if ((0, _error.isErrorWithMessage)(err)) {
        const errorMessage = (0, _error.getErrorMessage)(err);
        if (errorMessage.startsWith('Fetch error:')) {
          const errorObj = (0, _swaps.parseSmartTransactionsError)(errorMessage);
          dispatch({
            type: actionConstants.SET_SMART_TRANSACTIONS_ERROR,
            payload: errorObj
          });
        }
      }
      throw err;
    }
  };
}
function updateSmartTransaction(uuid, txMeta) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('updateSmartTransaction', [{
        uuid,
        ...txMeta
      }]);
    } catch (err) {
      (0, _error.logErrorWithMessage)(err);
      if ((0, _error.isErrorWithMessage)(err)) {
        const errorMessage = (0, _error.getErrorMessage)(err);
        if (errorMessage.startsWith('Fetch error:')) {
          const errorObj = (0, _swaps.parseSmartTransactionsError)(errorMessage);
          dispatch({
            type: actionConstants.SET_SMART_TRANSACTIONS_ERROR,
            payload: errorObj
          });
        }
      }
      throw err;
    }
  };
}
function setSmartTransactionsRefreshInterval(refreshInterval) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async () => {
    if (refreshInterval === undefined || refreshInterval === null) {
      return;
    }
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('setStatusRefreshInterval', [refreshInterval]);
    } catch (err) {
      (0, _error.logErrorWithMessage)(err);
    }
  };
}
function cancelSmartTransaction(uuid) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('cancelSmartTransaction', [uuid]);
    } catch (err) {
      (0, _error.logErrorWithMessage)(err);
      if ((0, _error.isErrorWithMessage)(err)) {
        const errorMessage = (0, _error.getErrorMessage)(err);
        if (errorMessage.startsWith('Fetch error:')) {
          const errorObj = (0, _swaps.parseSmartTransactionsError)(errorMessage);
          dispatch({
            type: actionConstants.SET_SMART_TRANSACTIONS_ERROR,
            payload: errorObj
          });
        }
      }
      throw err;
    }
  };
}

// TODO: Not a thunk but rather a wrapper around a background call
function fetchSmartTransactionsLiveness({
  networkClientId
} = {}) {
  return async () => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('fetchSmartTransactionsLiveness', [{
        networkClientId
      }]);
    } catch (err) {
      (0, _error.logErrorWithMessage)(err);
    }
  };
}
function dismissSmartTransactionsErrorMessage() {
  return {
    type: actionConstants.DISMISS_SMART_TRANSACTIONS_ERROR_MESSAGE
  };
}

// App state
function hideTestNetMessage() {
  return (0, _backgroundConnection.submitRequestToBackground)('setShowTestnetMessageInDropdown', [false]);
}
function hideBetaHeader() {
  return (0, _backgroundConnection.submitRequestToBackground)('setShowBetaHeader', [false]);
}
function hidePermissionsTour() {
  return (0, _backgroundConnection.submitRequestToBackground)('setShowPermissionsTour', [false]);
}
function hideAccountBanner() {
  return (0, _backgroundConnection.submitRequestToBackground)('setShowAccountBanner', [false]);
}
function hideNetworkBanner() {
  return (0, _backgroundConnection.submitRequestToBackground)('setShowNetworkBanner', [false]);
}
function updateNetworkConnectionBanner(networkConnectionBanner) {
  return async () => {
    await (0, _backgroundConnection.submitRequestToBackground)('updateNetworkConnectionBanner', [networkConnectionBanner]);
  };
}

/**
 * Sends the background state the networkClientId and domain upon network switch
 *
 * @param selectedTabOrigin - The origin to set the new networkClientId for
 * @param networkClientId - The new networkClientId
 */
function setNetworkClientIdForDomain(selectedTabOrigin, networkClientId) {
  return (0, _backgroundConnection.submitRequestToBackground)('setNetworkClientIdForDomain', [selectedTabOrigin, networkClientId]);
}
function setSecurityAlertsEnabled(val) {
  try {
    (0, _backgroundConnection.submitRequestToBackground)('setSecurityAlertsEnabled', [val]);
  } catch (error) {
    (0, _error.logErrorWithMessage)(error);
  }
}
async function setWatchEthereumAccountEnabled(value) {
  try {
    await (0, _backgroundConnection.submitRequestToBackground)('setWatchEthereumAccountEnabled', [value]);
  } catch (error) {
    (0, _error.logErrorWithMessage)(error);
  }
}

///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
async function setAddSnapAccountEnabled(value) {
  try {
    await (0, _backgroundConnection.submitRequestToBackground)('setAddSnapAccountEnabled', [value]);
  } catch (error) {
    (0, _error.logErrorWithMessage)(error);
  }
}
function showKeyringSnapRemovalModal(payload) {
  return {
    type: actionConstants.SHOW_KEYRING_SNAP_REMOVAL_RESULT,
    payload
  };
}
function hideKeyringRemovalResultModal() {
  return {
    type: actionConstants.HIDE_KEYRING_SNAP_REMOVAL_RESULT
  };
}
async function getSnapAccountsById(snapId) {
  const addresses = await (0, _backgroundConnection.submitRequestToBackground)('getAccountsBySnapId', [snapId]);
  return addresses;
}
///: END:ONLY_INCLUDE_IF

function setUseExternalNameSources(val) {
  try {
    (0, _backgroundConnection.submitRequestToBackground)('setUseExternalNameSources', [val]);
  } catch (error) {
    (0, _error.logErrorWithMessage)(error);
  }
}
function setUseTransactionSimulations(val) {
  try {
    (0, _backgroundConnection.submitRequestToBackground)('setUseTransactionSimulations', [val]);
  } catch (error) {
    (0, _error.logErrorWithMessage)(error);
  }
}

// QR Hardware Wallets

function completeQrCodeScan(scanResult) {
  return async () => {
    await (0, _backgroundConnection.submitRequestToBackground)('completeQrCodeScan', [scanResult]);
  };
}
function cancelQrCodeScan() {
  return async () => {
    await (0, _backgroundConnection.submitRequestToBackground)('cancelQrCodeScan');
  };
}
function requestUserApproval({
  origin,
  type,
  requestData
}) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async dispatch => {
    try {
      return await (0, _backgroundConnection.submitRequestToBackground)('requestUserApproval', [{
        origin,
        type,
        requestData
      }]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      dispatch(displayWarning('Had trouble requesting user approval'));
      return null;
    }
  };
}
function rejectAllApprovals() {
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('rejectAllPendingApprovals');
    const {
      pendingApprovals
    } = await forceUpdateMetamaskState(dispatch);
    if (Object.values(pendingApprovals).length === 0) {
      dispatch(closeCurrentNotificationWindow());
    }
  };
}
async function getCurrentNetworkEIP1559Compatibility() {
  let networkEIP1559Compatibility;
  try {
    networkEIP1559Compatibility = await (0, _backgroundConnection.submitRequestToBackground)('getCurrentNetworkEIP1559Compatibility');
  } catch (error) {
    console.error(error);
  }
  return networkEIP1559Compatibility;
}
async function getNetworkConfigurationByNetworkClientId(networkClientId) {
  let networkConfiguration;
  try {
    networkConfiguration = await (0, _backgroundConnection.submitRequestToBackground)('getNetworkConfigurationByNetworkClientId', [networkClientId]);
  } catch (error) {
    console.error(error);
  }
  return networkConfiguration;
}

/**
 * Gathers metadata (primarily connectivity status) about the globally selected
 * network as well as each enabled network and persists it to state.
 */
function lookupSelectedNetworks() {
  return async () => {
    await (0, _backgroundConnection.submitRequestToBackground)('lookupSelectedNetworks');
  };
}
function updateProposedNames(request) {
  return async () => {
    const data = await (0, _backgroundConnection.submitRequestToBackground)('updateProposedNames', [request]);
    return data;

    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
  };
}
function setName(request) {
  return async () => {
    await (0, _backgroundConnection.submitRequestToBackground)('setName', [request]);

    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
  };
}

/**
 * To create a data deletion regulation for MetaMetrics data deletion
 */
async function createMetaMetricsDataDeletionTask() {
  return await (0, _backgroundConnection.submitRequestToBackground)('createMetaMetricsDataDeletionTask');
}

/**
 * To check the status of the current delete regulation.
 */
async function updateDataDeletionTaskStatus() {
  return await (0, _backgroundConnection.submitRequestToBackground)('updateDataDeletionTaskStatus');
}

/**
 * Throw an error in the background for testing purposes.
 *
 * @param message - The error message.
 * @deprecated This is only meant to facilitate manual and E2E tests testing. We should not use
 * this for handling errors.
 */
async function throwTestBackgroundError(message) {
  await (0, _backgroundConnection.submitRequestToBackground)('throwTestError', [message]);
}

/**
 * Capture an error in the background for testing purposes.
 *
 * @param message - The error message.
 * @deprecated This is only meant to facilitate manual and E2E tests testing. We should not use
 * this for handling errors.
 */
async function captureTestBackgroundError(message) {
  await (0, _backgroundConnection.submitRequestToBackground)('captureTestError', [message]);
}

/**
 * Set status of popover warning for the first snap installation.
 *
 * @param shown - True if popover has been shown.
 * @returns Promise Resolved on successfully submitted background request.
 */
function setSnapsInstallPrivacyWarningShownStatus(shown) {
  return async () => {
    await (0, _backgroundConnection.submitRequestToBackground)('setSnapsInstallPrivacyWarningShownStatus', [shown]);
  };
}

/**
 * Update the state of a given Snap interface.
 *
 * @param id - The Snap interface ID.
 * @param state - The interface state.
 * @returns Promise Resolved on successfully submitted background request.
 */
function updateInterfaceState(id, state) {
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('updateInterfaceState', [id, state]);
    await forceUpdateMetamaskState(dispatch);

    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
  };
}

/**
 * Delete the Snap interface from state.
 *
 * @param id - The Snap interface ID.
 * @returns Promise Resolved on successfully submitted background request.
 */
function deleteInterface(id) {
  return async dispatch => {
    await (0, _backgroundConnection.submitRequestToBackground)('deleteInterface', [id]);
    await forceUpdateMetamaskState(dispatch);

    // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
  };
}
function trackInsightSnapUsage(snapId) {
  return async () => {
    await (0, _backgroundConnection.submitRequestToBackground)('trackInsightSnapView', [snapId]);
  };
}

///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
async function setSnapsAddSnapAccountModalDismissed() {
  await (0, _backgroundConnection.submitRequestToBackground)('setSnapsAddSnapAccountModalDismissed', [true]);
}
///: END:ONLY_INCLUDE_IF

/**
 * Initiates the sign-in process.
 *
 * This function dispatches a request to the background script to perform the sign-in operation.
 * Upon success, it dispatches an action with type `PERFORM_SIGN_IN` to update the Redux state.
 * If the operation fails, it logs the error message and rethrows the error.
 *
 * @returns A thunk action that performs the sign-in operation.
 */
function performSignIn() {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async () => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('performSignIn');
    } catch (error) {
      const errorMessage = error instanceof Error ? error.message : 'Unknown error occurred during sign-in.';
      (0, _error.logErrorWithMessage)(errorMessage);
      throw error;
    }
  };
}

/**
 * Initiates the sign-out process.
 *
 * This function dispatches a request to the background script to perform the sign-out operation.
 * Upon success, it dispatches an action with type `PERFORM_SIGN_OUT` to update the Redux state.
 * If the operation fails, it logs the error message and rethrows the error.
 *
 * @returns A thunk action that performs the sign-out operation.
 */
function performSignOut() {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async () => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('performSignOut');
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      throw error;
    }
  };
}

/**
 * Enables or disables a backup and sync feature.
 *
 * This function sends a request to the background script to enable or disable a specific
 * backup and sync feature.
 * If the operation encounters an error, it logs the error message and rethrows the error to be handled by the caller.
 *
 * @param feature - The feature to enable or disable.
 * @param enabled - A boolean indicating whether to enable or disable the feature.
 * @returns A thunk action that, when dispatched, attempts to enable or disable a backup and sync feature.
 */
function setIsBackupAndSyncFeatureEnabled(feature, enabled) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async () => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('setIsBackupAndSyncFeatureEnabled', [feature, enabled]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      throw error;
    }
  };
}

/**
 * Fetches the user profile lineage from the authentication API.
 *
 * @returns A thunk action that, when dispatched, attempts to fetch the user profile lineage.
 */
async function getUserProfileLineage() {
  try {
    const userProfileLineage = await (0, _backgroundConnection.submitRequestToBackground)('getUserProfileLineage');
    return userProfileLineage;
  } catch (error) {
    (0, _error.logErrorWithMessage)(error);
    return undefined;
  }
}

/**
 * Initiates the creation of on-chain triggers.
 *
 * This function dispatches a request to the background script to create on-chain triggers.
 * Upon success, it dispatches an action with type `CREATE_ON_CHAIN_TRIGGERS` to update the Redux state.
 * If the operation fails, it logs the error message and rethrows the error to ensure it is handled appropriately.
 *
 * @returns A thunk action that, when dispatched, attempts to create on-chain triggers.
 */
function createOnChainTriggers() {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async () => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('createOnChainTriggers');
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      throw error;
    }
  };
}

/**
 * Deletes on-chain triggers associated with specified accounts.
 *
 * This function sends a request to the background script to delete on-chain triggers for the provided accounts.
 * Upon success, it dispatches an action with type `DELETE_ON_CHAIN_TRIGGERS_BY_ACCOUNT` to update the Redux state.
 * If the operation encounters an error, it logs the error message and rethrows the error to ensure it is handled appropriately.
 *
 * @param accounts - An array of account identifiers for which on-chain triggers should be deleted.
 * @returns A thunk action that, when dispatched, attempts to delete on-chain triggers for the specified accounts.
 */
function disableAccounts(accounts) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async () => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('disableAccounts', [accounts]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      throw error;
    }
  };
}

/**
 * Updates on-chain triggers for specified accounts.
 *
 * This function dispatches a request to the background script to update on-chain triggers associated with the given accounts.
 * Upon success, it dispatches an action with type `UPDATE_ON_CHAIN_TRIGGERS_BY_ACCOUNT` to update the Redux state.
 * If the operation fails, it logs the error message and rethrows the error to ensure proper error handling.
 *
 * @param accounts - An array of account identifiers for which on-chain triggers should be updated.
 * @returns A thunk action that, when dispatched, attempts to update on-chain triggers for the specified accounts.
 */
function enableAccounts(accounts) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async () => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('enableAccounts', [accounts]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      throw error;
    }
  };
}

/**
 * Fetches and updates MetaMask notifications.
 *
 * This function sends a request to the background script to fetch the latest notifications.
 * If the operation encounters an error, it logs the error message and rethrows the error to ensure it is handled appropriately.
 *
 * @param previewToken - Optional preview token for fetching draft feature announcements.
 * @returns A thunk action that, when dispatched, attempts to fetch and update MetaMask notifications.
 */
function fetchAndUpdateMetamaskNotifications(previewToken) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async () => {
    try {
      const response = await (0, _backgroundConnection.submitRequestToBackground)('fetchAndUpdateMetamaskNotifications', [previewToken]);
      return response;
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      throw error;
    }
  };
}

/**
 * Deletes notifications by their id.
 *
 * This function sends a request to the background script to delete notifications by the passed in ids and updates the state accordingly.
 * If the operation encounters an error, it logs the error message and rethrows the error to ensure it is handled appropriately.
 *
 * @param ids - The ids of the notifications to delete.
 * @returns A thunk action that, when dispatched, attempts to delete a notification by its id.
 */
function deleteNotificationsById(ids) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async () => {
    try {
      const response = await (0, _backgroundConnection.submitRequestToBackground)('deleteNotificationsById', [ids]);
      return response;
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      throw error;
    }
  };
}

/**
 * Synchronizes account tree data with user storage between devices.
 *
 * This function sends a request to the background script to sync accounts data and update the state accordingly.
 * If the operation encounters an error, it logs the error message and rethrows the error to ensure it is handled appropriately.
 *
 * @returns A thunk action that, when dispatched, attempts to synchronize accounts data with user storage between devices.
 */
function syncAccountTreeWithUserStorage() {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async () => {
    try {
      const response = await (0, _backgroundConnection.submitRequestToBackground)('syncAccountTreeWithUserStorage');
      return response;
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      throw error;
    }
  };
}

/**
 * Delete all of current user's accounts data from user storage.
 *
 * This function sends a request to the background script to sync accounts data and update the state accordingly.
 * If the operation encounters an error, it logs the error message and rethrows the error to ensure it is handled appropriately.
 *
 * @returns A thunk action that, when dispatched, attempts to synchronize accounts data with user storage between devices.
 */
function deleteAccountSyncingDataFromUserStorage() {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async () => {
    try {
      await Promise.all([(0, _backgroundConnection.submitRequestToBackground)('deleteAccountSyncingDataFromUserStorage', [_accountTreeController.USER_STORAGE_GROUPS_FEATURE_KEY]), (0, _backgroundConnection.submitRequestToBackground)('deleteAccountSyncingDataFromUserStorage', [_accountTreeController.USER_STORAGE_WALLETS_FEATURE_KEY])]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      throw error;
    }
  };
}

/**
 * Synchronizes address book data with user storage between devices.
 *
 * This function sends a request to the background script to sync address book data and update the state accordingly.
 * If the operation encounters an error, it logs the error message and rethrows the error to ensure it is handled appropriately.
 *
 * @returns A thunk action that, when dispatched, attempts to synchronize address book data with user storage between devices.
 */
function syncContactsWithUserStorage() {
  return async () => {
    try {
      const response = await (0, _backgroundConnection.submitRequestToBackground)('syncContactsWithUserStorage');
      return response;
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      throw error;
    }
  };
}

/**
 * Marks MetaMask notifications as read.
 *
 * This function sends a request to the background script to mark the specified notifications as read.
 * Upon success, it dispatches an action with type `MARK_METAMASK_NOTIFICATIONS_AS_READ` to update the Redux state.
 * If the operation encounters an error, it logs the error message and rethrows the error to ensure it is handled appropriately.
 *
 * @param notifications - An array of notification identifiers to be marked as read.
 * @returns A thunk action that, when dispatched, attempts to mark MetaMask notifications as read.
 */
function markMetamaskNotificationsAsRead(notifications) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async () => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('markMetamaskNotificationsAsRead', [notifications]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      throw error;
    }
  };
}

/**
 * Enables or disables feature announcements.
 *
 * This function sends a request to the background script to toggle the enabled state of feature announcements.
 * Upon success, it dispatches an action with type `SET_FEATURE_ANNOUNCEMENTS_ENABLED` to update the Redux state.
 * If the operation encounters an error, it logs the error message and rethrows the error to ensure it is handled appropriately.
 *
 * @param state - A boolean indicating whether to enable (true) or disable (false) feature announcements.
 * @returns A thunk action that, when dispatched, attempts to set the enabled state of feature announcements.
 */
function setFeatureAnnouncementsEnabled(state) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async () => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('setFeatureAnnouncementsEnabled', [state]);
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      throw error;
    }
  };
}

/**
 * Checks the presence of accounts in user storage.
 *
 * This function sends a request to the background script to check the presence of specified accounts in user storage.
 * Upon success, it dispatches an action with type `CHECK_ACCOUNTS_PRESENCE` to update the Redux state.
 * If the operation encounters an error, it logs the error message and rethrows the error to ensure it is handled appropriately.
 *
 * @param accounts - An array of account addresses to be checked.
 * @returns A thunk action that, when dispatched, attempts to check the presence of accounts in user storage.
 */
function checkAccountsPresence(accounts) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async () => {
    try {
      const response = await (0, _backgroundConnection.submitRequestToBackground)('checkAccountsPresence', [accounts]);
      return response;
    } catch (error) {
      (0, _error.logErrorWithMessage)(error);
      throw error;
    }
  };
}
/**
 * Triggers a modal to confirm the action of turning on MetaMask notifications.
 * This function dispatches an action to show a modal dialog asking the user to confirm if they want to turn on MetaMask notifications.
 *
 * @returns A thunk action that, when dispatched, shows the confirmation modal.
 */
function showConfirmTurnOnMetamaskNotifications() {
  return dispatch => {
    dispatch(showModal({
      name: 'TURN_ON_METAMASK_NOTIFICATIONS'
    }));
  };
}

/**
 * Enables MetaMask notifications.
 * This function dispatches a request to the background script to enable MetaMask notifications.
 * If the operation fails, it logs the error message and rethrows the error to ensure it is handled appropriately.
 *
 * @returns A thunk action that, when dispatched, attempts to enable MetaMask notifications.
 */
function enableMetamaskNotifications() {
  return async () => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('enableMetamaskNotifications');
    } catch (error) {
      _loglevel.default.error(error);
      throw error;
    }
  };
}

/**
 * Disables MetaMask notifications.
 * This function dispatches a request to the background script to disable MetaMask notifications.
 * If the operation fails, it logs the error message and rethrows the error to ensure it is handled appropriately.
 *
 * @returns A thunk action that, when dispatched, attempts to disable MetaMask notifications.
 */
function disableMetamaskNotifications() {
  return async () => {
    try {
      await (0, _backgroundConnection.submitRequestToBackground)('disableMetamaskNotifications');
    } catch (error) {
      _loglevel.default.error(error);
      throw error;
    }
  };
}
function setConfirmationAdvancedDetailsOpen(value) {
  return setPreference('showConfirmationAdvancedDetails', value);
}
function setMultichainAccountsIntroModalShown(value) {
  return async () => {
    await (0, _backgroundConnection.submitRequestToBackground)('setHasShownMultichainAccountsIntroModal', [value]);
  };
}
async function getNextAvailableAccountName(keyring) {
  return await (0, _backgroundConnection.submitRequestToBackground)('getNextAvailableAccountName', [keyring]);
}
async function decodeTransactionData({
  transactionData,
  contractAddress,
  chainId
}) {
  return await (0, _backgroundConnection.submitRequestToBackground)('decodeTransactionData', [{
    transactionData,
    contractAddress,
    chainId
  }]);
}
///: BEGIN:ONLY_INCLUDE_IF(multichain)
async function multichainUpdateBalance(accountId) {
  return await (0, _backgroundConnection.submitRequestToBackground)('multichainUpdateBalance', [accountId]);
}
async function multichainUpdateTransactions(accountId) {
  return await (0, _backgroundConnection.submitRequestToBackground)('multichainUpdateTransactions', [accountId]);
}
async function alignMultichainWallets() {
  return await (0, _backgroundConnection.submitRequestToBackground)('alignMultichainWallets', []);
}

///: END:ONLY_INCLUDE_IF

async function getLastInteractedConfirmationInfo() {
  return await (0, _backgroundConnection.submitRequestToBackground)('getLastInteractedConfirmationInfo');
}
async function setLastInteractedConfirmationInfo(info) {
  return await (0, _backgroundConnection.submitRequestToBackground)('setLastInteractedConfirmationInfo', [info]);
}
async function endBackgroundTrace(request) {
  // We want to record the timestamp immediately, not after the request reaches the background.
  // Sentry uses the Performance interface for more accuracy, so we also must use it to align with
  // other timings.
  const timestamp =
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31880
  // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
  request.timestamp || performance.timeOrigin + performance.now();
  await (0, _backgroundConnection.submitRequestToBackground)('endTrace', [{
    ...request,
    timestamp
  }]);
}
function applyPatches(oldState, patches) {
  const immer = new _immer.Immer();
  immer.setAutoFreeze(false);
  return immer.applyPatches(oldState, patches);
}

///: BEGIN:ONLY_INCLUDE_IF(multichain)
async function sendMultichainTransaction(snapId, {
  account,
  scope,
  assetType
}) {
  await handleSnapRequest({
    snapId,
    origin: 'metamask',
    handler: _snapsUtils.HandlerType.OnRpcRequest,
    request: {
      method: 'startSendTransactionFlow',
      params: {
        account,
        scope,
        assetId: assetType // The Solana snap names the parameter `assetId` while it is in fact an `assetType`
      }
    }
  });
}
///: END:ONLY_INCLUDE_IF

///: BEGIN:ONLY_INCLUDE_IF(keyring-snaps)
async function createSnapAccount(snapId, options, internalOptions) {
  return await (0, _backgroundConnection.submitRequestToBackground)('createSnapAccount', [snapId, options, internalOptions]);
}
///: END:ONLY_INCLUDE_IF

async function getCode(address, networkClientId) {
  return await (0, _backgroundConnection.submitRequestToBackground)('getCode', [address, networkClientId]);
}
function setTransactionActive(transactionId, isFocused) {
  // TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31879
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async () => {
    await (0, _backgroundConnection.submitRequestToBackground)('setTransactionActive', [transactionId, isFocused]);
  };
}
async function isRelaySupported(chainId) {
  return await (0, _backgroundConnection.submitRequestToBackground)('isRelaySupported', [chainId]);
}
async function isSendBundleSupported(chainId) {
  return await (0, _backgroundConnection.submitRequestToBackground)('isSendBundleSupported', [chainId]);
}

/**
 * Sets the preference for skipping the interstitial page when opening a deep link.
 *
 * @param value - Whether to skip the interstitial page when opening a deep link.
 * @returns A promise that resolves when the preference is set.
 */
function setSkipDeepLinkInterstitial(value) {
  return setPreference('skipDeepLinkInterstitial', value, false);
}

/**
 * Asks the UI to reload the browser extension safely.
 *
 * Much better than `browser.runtime.reload()`, as safeReload will wait for all
 * writes to finish!
 *
 * @returns
 */
async function requestSafeReload() {
  return await (0, _backgroundConnection.submitRequestToBackground)('requestSafeReload');
}

/**
 * Opens the "Updating" page in a new tab and then triggers a safe extension reload.
 *
 * Used when an update is available to reload the extension.
 *
 * If opening the tab fails, the error is logged, and the reload proceeds anyway.
 */
async function openUpdateTabAndReload() {
  return await (0, _backgroundConnection.submitRequestToBackground)('openUpdateTabAndReload');
}
async function getERC1155BalanceOf(userAddress, tokenAddress, tokenId, networkClientId) {
  return await (0, _backgroundConnection.submitRequestToBackground)('getERC1155BalanceOf', [userAddress, tokenAddress, tokenId, networkClientId]);
}
async function applyTransactionContainersExisting(transactionId, containerTypes) {
  return await (0, _backgroundConnection.submitRequestToBackground)('applyTransactionContainersExisting', [transactionId, containerTypes]);
}
async function getLayer1GasFeeValue({
  chainId,
  networkClientId,
  transactionParams
}) {
  return await (0, _backgroundConnection.submitRequestToBackground)('getLayer1GasFee', [{
    chainId,
    networkClientId,
    transactionParams
  }]);
}

/**
 * Submits a shield claim.
 *
 * @param params - The parameters.
 * @param params.email - The email.
 * @param params.impactedWalletAddress - The impacted wallet address.
 * @param params.impactedTransactionHash - The impacted transaction hash.
 * @param params.reimbursementWalletAddress - The reimbursement wallet address.
 * @param params.caseDescription - The description.
 * @param params.files - The files.
 * @returns The subscription response.
 */
async function submitShieldClaim(params) {
  const baseUrl = "https://claims.dev-api.cx.metamask.io" ?? 'https://claims.dev-api.cx.metamask.io';
  const claimsUrl = `${baseUrl}/claims`;
  const formData = new FormData();
  formData.append('email', params.email);
  formData.append('impactedWalletAddress', params.impactedWalletAddress);
  formData.append('impactedTxHash', params.impactedTransactionHash);
  formData.append('reimbursementWalletAddress', params.reimbursementWalletAddress);
  formData.append('description', params.caseDescription);
  // TODO: temporary value for signature, update to correct signature after implement signature verification
  formData.append('signature', '0x1234567890abcdef1234567890abcdef1234567890abcdef1234567890abcdef1234567890abcdef1234567890abcdef1234567890abcdef1234567890abcdef12');
  formData.append('timestamp', Date.now().toString());

  // add files to form data
  if (params.files) {
    Array.from(params.files).forEach(file => {
      formData.append('attachments', file, file.name);
    });
  }
  const accessToken = await (0, _backgroundConnection.submitRequestToBackground)('getBearerToken');

  // we do the request here instead of background controllers because files are not serializable
  const response = await fetch(claimsUrl, {
    method: 'POST',
    body: formData,
    headers: {
      Authorization: `Bearer ${accessToken}`
    }
  });
  if (!response.ok) {
    const errorMessage = await response.json();
    if (errorMessage.message) {
      throw new Error(errorMessage.message);
    }
    throw new Error(_appState.ClaimSubmitToastType.Errored);
  }
  return _appState.ClaimSubmitToastType.Success;
}

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\store\\actions.ts",}],
["D:\\code\\v\\metamask-extension\\ui\\store\\background-connection.ts", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cui%5Cstore%5Cbackground-connection.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateActionId = exports.callBackgroundMethod = void 0;
exports.setBackgroundConnection = setBackgroundConnection;
exports.submitRequestToBackground = submitRequestToBackground;
// eslint-disable-next-line import/no-restricted-paths

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31973
// eslint-disable-next-line @typescript-eslint/no-explicit-any

const NO_BACKGROUND_CONNECTION_MESSAGE = 'Background connection is not set. Please initialize the background connection before making requests.';
let background;
const generateActionId = () => Date.now() + Math.random();

/**
 * Promise-style call to background method invokes promisifiedBackground method directly.
 *
 * @param method - name of the background method
 * @param [args] - arguments to that method, if any
 * @returns
 */
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
exports.generateActionId = generateActionId;
function submitRequestToBackground(method, args) {
  if (false) {
    // tests don't always set the `background` property for convenience, as
    // the return values for various RPC calls aren't always used. In production
    // builds, this will not happen, and even if it did MM wouldn't work.
    if (!background) {
      console.warn(NO_BACKGROUND_CONNECTION_MESSAGE);
      return Promise.resolve();
    }
  }
  return background[method](...(args ?? []));
}

// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention

/**
 * [Deprecated] Callback-style call to background method
 * invokes promisifiedBackground method directly.
 *
 * @deprecated Use async `submitRequestToBackground` function instead.
 * @param method - name of the background method
 * @param [args] - arguments to that method, if any
 * @param callback - Node style (error, result) callback for finishing the operation
 */
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
const callBackgroundMethod = (method, args, callback) => {
  submitRequestToBackground(method, args).then(result => callback(null, result), callback);
};

/**
 * Sets/replaces the background connection reference
 *
 * @param backgroundConnection
 */
exports.callBackgroundMethod = callBackgroundMethod;
async function setBackgroundConnection(backgroundConnection) {
  background = backgroundConnection;
}

      };
    };
  }
  }
}, {package:"$root$",file:"ui\\store\\background-connection.ts",}]],[],{})

//# sourceMappingURL=data:application/json;charset=utf8;base64,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