LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-sig-util\\node_modules\\@scure\\base\\lib\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-sig-util%5Cnode_modules%5C@scure%5Cbase%5Clib%5Cindex.js
      return function (require, module, exports) {
"use strict";
/*! scure-base - MIT License (c) 2022 Paul Miller (paulmillr.com) */
Object.defineProperty(exports, "__esModule", { value: true });
exports.bytes = exports.stringToBytes = exports.str = exports.bytesToString = exports.hex = exports.utf8 = exports.bech32m = exports.bech32 = exports.base58check = exports.createBase58check = exports.base58xmr = exports.base58xrp = exports.base58flickr = exports.base58 = exports.base64urlnopad = exports.base64url = exports.base64nopad = exports.base64 = exports.base32crockford = exports.base32hexnopad = exports.base32hex = exports.base32nopad = exports.base32 = exports.base16 = exports.utils = void 0;
exports.assertNumber = assertNumber;
// Utilities
/**
 * @__NO_SIDE_EFFECTS__
 */
function assertNumber(n) {
    if (!Number.isSafeInteger(n))
        throw new Error(`Wrong integer: ${n}`);
}
function isBytes(a) {
    return (a instanceof Uint8Array ||
        (a != null && typeof a === 'object' && a.constructor.name === 'Uint8Array'));
}
/**
 * @__NO_SIDE_EFFECTS__
 */
function chain(...args) {
    const id = (a) => a;
    // Wrap call in closure so JIT can inline calls
    const wrap = (a, b) => (c) => a(b(c));
    // Construct chain of args[-1].encode(args[-2].encode([...]))
    const encode = args.map((x) => x.encode).reduceRight(wrap, id);
    // Construct chain of args[0].decode(args[1].decode(...))
    const decode = args.map((x) => x.decode).reduce(wrap, id);
    return { encode, decode };
}
/**
 * Encodes integer radix representation to array of strings using alphabet and back
 * @__NO_SIDE_EFFECTS__
 */
function alphabet(alphabet) {
    return {
        encode: (digits) => {
            if (!Array.isArray(digits) || (digits.length && typeof digits[0] !== 'number'))
                throw new Error('alphabet.encode input should be an array of numbers');
            return digits.map((i) => {
                assertNumber(i);
                if (i < 0 || i >= alphabet.length)
                    throw new Error(`Digit index outside alphabet: ${i} (alphabet: ${alphabet.length})`);
                return alphabet[i];
            });
        },
        decode: (input) => {
            if (!Array.isArray(input) || (input.length && typeof input[0] !== 'string'))
                throw new Error('alphabet.decode input should be array of strings');
            return input.map((letter) => {
                if (typeof letter !== 'string')
                    throw new Error(`alphabet.decode: not string element=${letter}`);
                const index = alphabet.indexOf(letter);
                if (index === -1)
                    throw new Error(`Unknown letter: "${letter}". Allowed: ${alphabet}`);
                return index;
            });
        },
    };
}
/**
 * @__NO_SIDE_EFFECTS__
 */
function join(separator = '') {
    if (typeof separator !== 'string')
        throw new Error('join separator should be string');
    return {
        encode: (from) => {
            if (!Array.isArray(from) || (from.length && typeof from[0] !== 'string'))
                throw new Error('join.encode input should be array of strings');
            for (let i of from)
                if (typeof i !== 'string')
                    throw new Error(`join.encode: non-string input=${i}`);
            return from.join(separator);
        },
        decode: (to) => {
            if (typeof to !== 'string')
                throw new Error('join.decode input should be string');
            return to.split(separator);
        },
    };
}
/**
 * Pad strings array so it has integer number of bits
 * @__NO_SIDE_EFFECTS__
 */
function padding(bits, chr = '=') {
    assertNumber(bits);
    if (typeof chr !== 'string')
        throw new Error('padding chr should be string');
    return {
        encode(data) {
            if (!Array.isArray(data) || (data.length && typeof data[0] !== 'string'))
                throw new Error('padding.encode input should be array of strings');
            for (let i of data)
                if (typeof i !== 'string')
                    throw new Error(`padding.encode: non-string input=${i}`);
            while ((data.length * bits) % 8)
                data.push(chr);
            return data;
        },
        decode(input) {
            if (!Array.isArray(input) || (input.length && typeof input[0] !== 'string'))
                throw new Error('padding.encode input should be array of strings');
            for (let i of input)
                if (typeof i !== 'string')
                    throw new Error(`padding.decode: non-string input=${i}`);
            let end = input.length;
            if ((end * bits) % 8)
                throw new Error('Invalid padding: string should have whole number of bytes');
            for (; end > 0 && input[end - 1] === chr; end--) {
                if (!(((end - 1) * bits) % 8))
                    throw new Error('Invalid padding: string has too much padding');
            }
            return input.slice(0, end);
        },
    };
}
/**
 * @__NO_SIDE_EFFECTS__
 */
function normalize(fn) {
    if (typeof fn !== 'function')
        throw new Error('normalize fn should be function');
    return { encode: (from) => from, decode: (to) => fn(to) };
}
/**
 * Slow: O(n^2) time complexity
 * @__NO_SIDE_EFFECTS__
 */
function convertRadix(data, from, to) {
    // base 1 is impossible
    if (from < 2)
        throw new Error(`convertRadix: wrong from=${from}, base cannot be less than 2`);
    if (to < 2)
        throw new Error(`convertRadix: wrong to=${to}, base cannot be less than 2`);
    if (!Array.isArray(data))
        throw new Error('convertRadix: data should be array');
    if (!data.length)
        return [];
    let pos = 0;
    const res = [];
    const digits = Array.from(data);
    digits.forEach((d) => {
        assertNumber(d);
        if (d < 0 || d >= from)
            throw new Error(`Wrong integer: ${d}`);
    });
    while (true) {
        let carry = 0;
        let done = true;
        for (let i = pos; i < digits.length; i++) {
            const digit = digits[i];
            const digitBase = from * carry + digit;
            if (!Number.isSafeInteger(digitBase) ||
                (from * carry) / from !== carry ||
                digitBase - digit !== from * carry) {
                throw new Error('convertRadix: carry overflow');
            }
            carry = digitBase % to;
            const rounded = Math.floor(digitBase / to);
            digits[i] = rounded;
            if (!Number.isSafeInteger(rounded) || rounded * to + carry !== digitBase)
                throw new Error('convertRadix: carry overflow');
            if (!done)
                continue;
            else if (!rounded)
                pos = i;
            else
                done = false;
        }
        res.push(carry);
        if (done)
            break;
    }
    for (let i = 0; i < data.length - 1 && data[i] === 0; i++)
        res.push(0);
    return res.reverse();
}
const gcd = /* @__NO_SIDE_EFFECTS__ */ (a, b) => (!b ? a : gcd(b, a % b));
const radix2carry = /*@__NO_SIDE_EFFECTS__ */ (from, to) => from + (to - gcd(from, to));
/**
 * Implemented with numbers, because BigInt is 5x slower
 * @__NO_SIDE_EFFECTS__
 */
function convertRadix2(data, from, to, padding) {
    if (!Array.isArray(data))
        throw new Error('convertRadix2: data should be array');
    if (from <= 0 || from > 32)
        throw new Error(`convertRadix2: wrong from=${from}`);
    if (to <= 0 || to > 32)
        throw new Error(`convertRadix2: wrong to=${to}`);
    if (radix2carry(from, to) > 32) {
        throw new Error(`convertRadix2: carry overflow from=${from} to=${to} carryBits=${radix2carry(from, to)}`);
    }
    let carry = 0;
    let pos = 0; // bitwise position in current element
    const mask = 2 ** to - 1;
    const res = [];
    for (const n of data) {
        assertNumber(n);
        if (n >= 2 ** from)
            throw new Error(`convertRadix2: invalid data word=${n} from=${from}`);
        carry = (carry << from) | n;
        if (pos + from > 32)
            throw new Error(`convertRadix2: carry overflow pos=${pos} from=${from}`);
        pos += from;
        for (; pos >= to; pos -= to)
            res.push(((carry >> (pos - to)) & mask) >>> 0);
        carry &= 2 ** pos - 1; // clean carry, otherwise it will cause overflow
    }
    carry = (carry << (to - pos)) & mask;
    if (!padding && pos >= from)
        throw new Error('Excess padding');
    if (!padding && carry)
        throw new Error(`Non-zero padding: ${carry}`);
    if (padding && pos > 0)
        res.push(carry >>> 0);
    return res;
}
/**
 * @__NO_SIDE_EFFECTS__
 */
function radix(num) {
    assertNumber(num);
    return {
        encode: (bytes) => {
            if (!isBytes(bytes))
                throw new Error('radix.encode input should be Uint8Array');
            return convertRadix(Array.from(bytes), 2 ** 8, num);
        },
        decode: (digits) => {
            if (!Array.isArray(digits) || (digits.length && typeof digits[0] !== 'number'))
                throw new Error('radix.decode input should be array of numbers');
            return Uint8Array.from(convertRadix(digits, num, 2 ** 8));
        },
    };
}
/**
 * If both bases are power of same number (like `2**8 <-> 2**64`),
 * there is a linear algorithm. For now we have implementation for power-of-two bases only.
 * @__NO_SIDE_EFFECTS__
 */
function radix2(bits, revPadding = false) {
    assertNumber(bits);
    if (bits <= 0 || bits > 32)
        throw new Error('radix2: bits should be in (0..32]');
    if (radix2carry(8, bits) > 32 || radix2carry(bits, 8) > 32)
        throw new Error('radix2: carry overflow');
    return {
        encode: (bytes) => {
            if (!isBytes(bytes))
                throw new Error('radix2.encode input should be Uint8Array');
            return convertRadix2(Array.from(bytes), 8, bits, !revPadding);
        },
        decode: (digits) => {
            if (!Array.isArray(digits) || (digits.length && typeof digits[0] !== 'number'))
                throw new Error('radix2.decode input should be array of numbers');
            return Uint8Array.from(convertRadix2(digits, bits, 8, revPadding));
        },
    };
}
/**
 * @__NO_SIDE_EFFECTS__
 */
function unsafeWrapper(fn) {
    if (typeof fn !== 'function')
        throw new Error('unsafeWrapper fn should be function');
    return function (...args) {
        try {
            return fn.apply(null, args);
        }
        catch (e) { }
    };
}
/**
 * @__NO_SIDE_EFFECTS__
 */
function checksum(len, fn) {
    assertNumber(len);
    if (typeof fn !== 'function')
        throw new Error('checksum fn should be function');
    return {
        encode(data) {
            if (!isBytes(data))
                throw new Error('checksum.encode: input should be Uint8Array');
            const checksum = fn(data).slice(0, len);
            const res = new Uint8Array(data.length + len);
            res.set(data);
            res.set(checksum, data.length);
            return res;
        },
        decode(data) {
            if (!isBytes(data))
                throw new Error('checksum.decode: input should be Uint8Array');
            const payload = data.slice(0, -len);
            const newChecksum = fn(payload).slice(0, len);
            const oldChecksum = data.slice(-len);
            for (let i = 0; i < len; i++)
                if (newChecksum[i] !== oldChecksum[i])
                    throw new Error('Invalid checksum');
            return payload;
        },
    };
}
// prettier-ignore
exports.utils = {
    alphabet, chain, checksum, convertRadix, convertRadix2, radix, radix2, join, padding,
};
// RFC 4648 aka RFC 3548
// ---------------------
exports.base16 = chain(radix2(4), alphabet('0123456789ABCDEF'), join(''));
exports.base32 = chain(radix2(5), alphabet('ABCDEFGHIJKLMNOPQRSTUVWXYZ234567'), padding(5), join(''));
exports.base32nopad = chain(radix2(5), alphabet('ABCDEFGHIJKLMNOPQRSTUVWXYZ234567'), join(''));
exports.base32hex = chain(radix2(5), alphabet('0123456789ABCDEFGHIJKLMNOPQRSTUV'), padding(5), join(''));
exports.base32hexnopad = chain(radix2(5), alphabet('0123456789ABCDEFGHIJKLMNOPQRSTUV'), join(''));
exports.base32crockford = chain(radix2(5), alphabet('0123456789ABCDEFGHJKMNPQRSTVWXYZ'), join(''), normalize((s) => s.toUpperCase().replace(/O/g, '0').replace(/[IL]/g, '1')));
exports.base64 = chain(radix2(6), alphabet('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'), padding(6), join(''));
exports.base64nopad = chain(radix2(6), alphabet('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'), join(''));
exports.base64url = chain(radix2(6), alphabet('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_'), padding(6), join(''));
exports.base64urlnopad = chain(radix2(6), alphabet('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_'), join(''));
// base58 code
// -----------
const genBase58 = (abc) => chain(radix(58), alphabet(abc), join(''));
exports.base58 = genBase58('123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz');
exports.base58flickr = genBase58('123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ');
exports.base58xrp = genBase58('rpshnaf39wBUDNEGHJKLM4PQRST7VWXYZ2bcdeCg65jkm8oFqi1tuvAxyz');
// xmr ver is done in 8-byte blocks (which equals 11 chars in decoding). Last (non-full) block padded with '1' to size in XMR_BLOCK_LEN.
// Block encoding significantly reduces quadratic complexity of base58.
// Data len (index) -> encoded block len
const XMR_BLOCK_LEN = [0, 2, 3, 5, 6, 7, 9, 10, 11];
exports.base58xmr = {
    encode(data) {
        let res = '';
        for (let i = 0; i < data.length; i += 8) {
            const block = data.subarray(i, i + 8);
            res += exports.base58.encode(block).padStart(XMR_BLOCK_LEN[block.length], '1');
        }
        return res;
    },
    decode(str) {
        let res = [];
        for (let i = 0; i < str.length; i += 11) {
            const slice = str.slice(i, i + 11);
            const blockLen = XMR_BLOCK_LEN.indexOf(slice.length);
            const block = exports.base58.decode(slice);
            for (let j = 0; j < block.length - blockLen; j++) {
                if (block[j] !== 0)
                    throw new Error('base58xmr: wrong padding');
            }
            res = res.concat(Array.from(block.slice(block.length - blockLen)));
        }
        return Uint8Array.from(res);
    },
};
const createBase58check = (sha256) => chain(checksum(4, (data) => sha256(sha256(data))), exports.base58);
exports.createBase58check = createBase58check;
// legacy export, bad name
exports.base58check = exports.createBase58check;
const BECH_ALPHABET = /* @__PURE__ */ chain(alphabet('qpzry9x8gf2tvdw0s3jn54khce6mua7l'), join(''));
const POLYMOD_GENERATORS = [0x3b6a57b2, 0x26508e6d, 0x1ea119fa, 0x3d4233dd, 0x2a1462b3];
/**
 * @__NO_SIDE_EFFECTS__
 */
function bech32Polymod(pre) {
    const b = pre >> 25;
    let chk = (pre & 0x1ffffff) << 5;
    for (let i = 0; i < POLYMOD_GENERATORS.length; i++) {
        if (((b >> i) & 1) === 1)
            chk ^= POLYMOD_GENERATORS[i];
    }
    return chk;
}
/**
 * @__NO_SIDE_EFFECTS__
 */
function bechChecksum(prefix, words, encodingConst = 1) {
    const len = prefix.length;
    let chk = 1;
    for (let i = 0; i < len; i++) {
        const c = prefix.charCodeAt(i);
        if (c < 33 || c > 126)
            throw new Error(`Invalid prefix (${prefix})`);
        chk = bech32Polymod(chk) ^ (c >> 5);
    }
    chk = bech32Polymod(chk);
    for (let i = 0; i < len; i++)
        chk = bech32Polymod(chk) ^ (prefix.charCodeAt(i) & 0x1f);
    for (let v of words)
        chk = bech32Polymod(chk) ^ v;
    for (let i = 0; i < 6; i++)
        chk = bech32Polymod(chk);
    chk ^= encodingConst;
    return BECH_ALPHABET.encode(convertRadix2([chk % 2 ** 30], 30, 5, false));
}
/**
 * @__NO_SIDE_EFFECTS__
 */
function genBech32(encoding) {
    const ENCODING_CONST = encoding === 'bech32' ? 1 : 0x2bc830a3;
    const _words = radix2(5);
    const fromWords = _words.decode;
    const toWords = _words.encode;
    const fromWordsUnsafe = unsafeWrapper(fromWords);
    function encode(prefix, words, limit = 90) {
        if (typeof prefix !== 'string')
            throw new Error(`bech32.encode prefix should be string, not ${typeof prefix}`);
        if (words instanceof Uint8Array)
            words = Array.from(words);
        if (!Array.isArray(words) || (words.length && typeof words[0] !== 'number'))
            throw new Error(`bech32.encode words should be array of numbers, not ${typeof words}`);
        if (prefix.length === 0)
            throw new TypeError(`Invalid prefix length ${prefix.length}`);
        const actualLength = prefix.length + 7 + words.length;
        if (limit !== false && actualLength > limit)
            throw new TypeError(`Length ${actualLength} exceeds limit ${limit}`);
        const lowered = prefix.toLowerCase();
        const sum = bechChecksum(lowered, words, ENCODING_CONST);
        return `${lowered}1${BECH_ALPHABET.encode(words)}${sum}`;
    }
    function decode(str, limit = 90) {
        if (typeof str !== 'string')
            throw new Error(`bech32.decode input should be string, not ${typeof str}`);
        if (str.length < 8 || (limit !== false && str.length > limit))
            throw new TypeError(`Wrong string length: ${str.length} (${str}). Expected (8..${limit})`);
        // don't allow mixed case
        const lowered = str.toLowerCase();
        if (str !== lowered && str !== str.toUpperCase())
            throw new Error(`String must be lowercase or uppercase`);
        const sepIndex = lowered.lastIndexOf('1');
        if (sepIndex === 0 || sepIndex === -1)
            throw new Error(`Letter "1" must be present between prefix and data only`);
        const prefix = lowered.slice(0, sepIndex);
        const data = lowered.slice(sepIndex + 1);
        if (data.length < 6)
            throw new Error('Data must be at least 6 characters long');
        const words = BECH_ALPHABET.decode(data).slice(0, -6);
        const sum = bechChecksum(prefix, words, ENCODING_CONST);
        if (!data.endsWith(sum))
            throw new Error(`Invalid checksum in ${str}: expected "${sum}"`);
        return { prefix, words };
    }
    const decodeUnsafe = unsafeWrapper(decode);
    function decodeToBytes(str) {
        const { prefix, words } = decode(str, false);
        return { prefix, words, bytes: fromWords(words) };
    }
    function encodeFromBytes(prefix, bytes) {
        return encode(prefix, toWords(bytes));
    }
    return {
        encode,
        decode,
        encodeFromBytes,
        decodeToBytes,
        decodeUnsafe,
        fromWords,
        fromWordsUnsafe,
        toWords,
    };
}
exports.bech32 = genBech32('bech32');
exports.bech32m = genBech32('bech32m');
exports.utf8 = {
    encode: (data) => new TextDecoder().decode(data),
    decode: (str) => new TextEncoder().encode(str),
};
exports.hex = chain(radix2(4), alphabet('0123456789abcdef'), join(''), normalize((s) => {
    if (typeof s !== 'string' || s.length % 2)
        throw new TypeError(`hex.decode: expected string, got ${typeof s} with length ${s.length}`);
    return s.toLowerCase();
}));
// prettier-ignore
const CODERS = {
    utf8: exports.utf8, hex: exports.hex, base16: exports.base16, base32: exports.base32, base64: exports.base64, base64url: exports.base64url, base58: exports.base58, base58xmr: exports.base58xmr
};
const coderTypeError = 'Invalid encoding type. Available types: utf8, hex, base16, base32, base64, base64url, base58, base58xmr';
const bytesToString = (type, bytes) => {
    if (typeof type !== 'string' || !CODERS.hasOwnProperty(type))
        throw new TypeError(coderTypeError);
    if (!isBytes(bytes))
        throw new TypeError('bytesToString() expects Uint8Array');
    return CODERS[type].encode(bytes);
};
exports.bytesToString = bytesToString;
exports.str = exports.bytesToString; // as in python, but for bytes only
const stringToBytes = (type, str) => {
    if (!CODERS.hasOwnProperty(type))
        throw new TypeError(coderTypeError);
    if (typeof str !== 'string')
        throw new TypeError('stringToBytes() expects string');
    return CODERS[type].decode(str);
};
exports.stringToBytes = stringToBytes;
exports.bytes = exports.stringToBytes;

      };
    };
  }
  }
}, {package:"@metamask/eth-sig-util>@scure/base",file:"node_modules\\@metamask\\eth-sig-util\\node_modules\\@scure\\base\\lib\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-simple-keyring\\dist\\index.cjs", {"./simple-keyring.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-simple-keyring\\dist\\simple-keyring.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-simple-keyring%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = void 0;
var simple_keyring_1 = require("./simple-keyring.cjs");
Object.defineProperty(exports, "default", { enumerable: true, get: function () { return __importDefault(simple_keyring_1).default; } });

      };
    };
  }
  }
}, {package:"@metamask/keyring-controller>@metamask/eth-simple-keyring",file:"node_modules\\@metamask\\eth-simple-keyring\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-simple-keyring\\dist\\simple-keyring.cjs", {"@ethereumjs/util":"D:\\code\\v\\metamask-extension\\node_modules\\@ethereumjs\\util\\dist\\cjs\\index.js","@metamask/eth-sig-util":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-sig-util\\dist\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js","ethereum-cryptography/keccak":"D:\\code\\v\\metamask-extension\\node_modules\\ethereum-cryptography\\keccak.js","randombytes":"D:\\code\\v\\metamask-extension\\node_modules\\randombytes\\browser.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-simple-keyring%5Cdist%5Csimple-keyring.cjs
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _SimpleKeyring_instances, _SimpleKeyring_wallets, _SimpleKeyring_getPrivateKeyFor, _SimpleKeyring_getWalletForAccount;
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("@ethereumjs/util");
const eth_sig_util_1 = require("@metamask/eth-sig-util");
const utils_1 = require("@metamask/utils");
const keccak_1 = require("ethereum-cryptography/keccak");
const randombytes_1 = __importDefault(require("randombytes"));
const TYPE = 'Simple Key Pair';
// FIXME: This should not be exported as default.
class SimpleKeyring {
    constructor(privateKeys = []) {
        _SimpleKeyring_instances.add(this);
        _SimpleKeyring_wallets.set(this, void 0);
        this.type = TYPE;
        __classPrivateFieldSet(this, _SimpleKeyring_wallets, [], "f");
        /* istanbul ignore next: It's not possible to write a unit test for this, because a constructor isn't allowed
         * to be async. Jest can't await the constructor, and when the error gets thrown, Jest can't catch it. */
        this.deserialize(privateKeys).catch((error) => {
            throw new Error(`Problem deserializing SimpleKeyring ${error.message}`);
        });
    }
    async serialize() {
        return __classPrivateFieldGet(this, _SimpleKeyring_wallets, "f").map((a) => a.privateKey.toString('hex'));
    }
    async deserialize(privateKeys) {
        __classPrivateFieldSet(this, _SimpleKeyring_wallets, privateKeys.map((hexPrivateKey) => {
            const strippedHexPrivateKey = (0, util_1.stripHexPrefix)(hexPrivateKey);
            const privateKey = Buffer.from(strippedHexPrivateKey, 'hex');
            const publicKey = Buffer.from((0, util_1.privateToPublic)(privateKey));
            return { privateKey, publicKey };
        }), "f");
    }
    async addAccounts(numAccounts = 1) {
        const newWallets = [];
        for (let i = 0; i < numAccounts; i++) {
            const privateKey = generateKey();
            const publicKey = Buffer.from((0, util_1.privateToPublic)(privateKey));
            newWallets.push({ privateKey, publicKey });
        }
        __classPrivateFieldSet(this, _SimpleKeyring_wallets, __classPrivateFieldGet(this, _SimpleKeyring_wallets, "f").concat(newWallets), "f");
        const hexWallets = newWallets.map(({ publicKey }) => (0, utils_1.add0x)((0, utils_1.bytesToHex)((0, util_1.publicToAddress)(publicKey))));
        return hexWallets;
    }
    async getAccounts() {
        return __classPrivateFieldGet(this, _SimpleKeyring_wallets, "f").map(({ publicKey }) => (0, utils_1.add0x)((0, utils_1.bytesToHex)((0, util_1.publicToAddress)(publicKey))));
    }
    async signTransaction(address, transaction, opts = {}) {
        const privKey = __classPrivateFieldGet(this, _SimpleKeyring_instances, "m", _SimpleKeyring_getPrivateKeyFor).call(this, address, opts);
        const signedTx = transaction.sign(privKey);
        // Newer versions of Ethereumjs-tx are immutable and return a new tx object
        return signedTx ?? transaction;
    }
    async signEip7702Authorization(address, authorization, opts = {}) {
        const privateKey = __classPrivateFieldGet(this, _SimpleKeyring_instances, "m", _SimpleKeyring_getPrivateKeyFor).call(this, address, opts);
        return (0, eth_sig_util_1.signEIP7702Authorization)({ privateKey, authorization });
    }
    // For eth_sign, we need to sign arbitrary data:
    async signMessage(address, data, opts = { withAppKeyOrigin: '', validateMessage: true }) {
        const message = (0, util_1.stripHexPrefix)(data);
        if (opts.validateMessage &&
            (message.length === 0 || !message.match(/^[a-fA-F0-9]*$/u))) {
            throw new Error('Cannot sign invalid message');
        }
        const privKey = __classPrivateFieldGet(this, _SimpleKeyring_instances, "m", _SimpleKeyring_getPrivateKeyFor).call(this, address, opts);
        const msgSig = (0, util_1.ecsign)(Buffer.from(message, 'hex'), privKey);
        const rawMsgSig = (0, eth_sig_util_1.concatSig)(Buffer.from((0, utils_1.bigIntToBytes)(msgSig.v)), Buffer.from(msgSig.r), Buffer.from(msgSig.s));
        return rawMsgSig;
    }
    // For personal_sign, we need to prefix the message:
    async signPersonalMessage(address, msgHex, opts = { withAppKeyOrigin: '' }) {
        const privKey = __classPrivateFieldGet(this, _SimpleKeyring_instances, "m", _SimpleKeyring_getPrivateKeyFor).call(this, address, opts);
        return (0, eth_sig_util_1.personalSign)({ privateKey: privKey, data: msgHex });
    }
    // For eth_decryptMessage:
    async decryptMessage(withAccount, encryptedData) {
        const wallet = __classPrivateFieldGet(this, _SimpleKeyring_instances, "m", _SimpleKeyring_getWalletForAccount).call(this, withAccount);
        const privateKey = wallet.privateKey.toString('hex');
        return (0, eth_sig_util_1.decrypt)({ privateKey, encryptedData });
    }
    async signTypedData(address, data, options) {
        let { version } = options ?? { version: eth_sig_util_1.SignTypedDataVersion.V1 };
        // Treat invalid versions as "V1"
        if (!version || !isSignTypedDataVersion(version)) {
            version = eth_sig_util_1.SignTypedDataVersion.V1;
        }
        const privateKey = __classPrivateFieldGet(this, _SimpleKeyring_instances, "m", _SimpleKeyring_getPrivateKeyFor).call(this, address, options);
        return (0, eth_sig_util_1.signTypedData)({ privateKey, data, version });
    }
    // get public key for nacl
    async getEncryptionPublicKey(withAccount, opts) {
        const privKey = __classPrivateFieldGet(this, _SimpleKeyring_instances, "m", _SimpleKeyring_getPrivateKeyFor).call(this, withAccount, opts);
        const publicKey = (0, eth_sig_util_1.getEncryptionPublicKey)(privKey.toString('hex'));
        return publicKey;
    }
    // returns an address specific to an app
    async getAppKeyAddress(address, origin) {
        if (!origin || typeof origin !== 'string') {
            throw new Error(`'origin' must be a non-empty string`);
        }
        const wallet = __classPrivateFieldGet(this, _SimpleKeyring_instances, "m", _SimpleKeyring_getWalletForAccount).call(this, address, {
            withAppKeyOrigin: origin,
        });
        const appKeyAddress = (0, utils_1.add0x)((0, utils_1.bytesToHex)((0, util_1.publicToAddress)(wallet.publicKey)));
        return appKeyAddress;
    }
    // exportAccount should return a hex-encoded private key:
    async exportAccount(address, opts = { withAppKeyOrigin: '' }) {
        const wallet = __classPrivateFieldGet(this, _SimpleKeyring_instances, "m", _SimpleKeyring_getWalletForAccount).call(this, address, opts);
        return wallet.privateKey.toString('hex');
    }
    removeAccount(address) {
        if (!__classPrivateFieldGet(this, _SimpleKeyring_wallets, "f")
            .map(({ publicKey }) => (0, utils_1.bytesToHex)((0, util_1.publicToAddress)(publicKey)).toLowerCase())
            .includes(address.toLowerCase())) {
            throw new Error(`Address ${address} not found in this keyring`);
        }
        __classPrivateFieldSet(this, _SimpleKeyring_wallets, __classPrivateFieldGet(this, _SimpleKeyring_wallets, "f").filter(({ publicKey }) => (0, utils_1.bytesToHex)((0, util_1.publicToAddress)(publicKey)).toLowerCase() !==
            address.toLowerCase()), "f");
    }
}
_SimpleKeyring_wallets = new WeakMap(), _SimpleKeyring_instances = new WeakSet(), _SimpleKeyring_getPrivateKeyFor = function _SimpleKeyring_getPrivateKeyFor(address, opts = { withAppKeyOrigin: '' }) {
    if (!address) {
        throw new Error('Must specify address.');
    }
    const wallet = __classPrivateFieldGet(this, _SimpleKeyring_instances, "m", _SimpleKeyring_getWalletForAccount).call(this, address, opts);
    return wallet.privateKey;
}, _SimpleKeyring_getWalletForAccount = function _SimpleKeyring_getWalletForAccount(account, opts = {}) {
    const address = (0, eth_sig_util_1.normalize)(account);
    let wallet = __classPrivateFieldGet(this, _SimpleKeyring_wallets, "f").find(({ publicKey }) => (0, utils_1.bytesToHex)((0, util_1.publicToAddress)(publicKey)) === address);
    if (!wallet) {
        throw new Error('Simple Keyring - Unable to find matching address.');
    }
    if (opts.withAppKeyOrigin) {
        const { privateKey } = wallet;
        const appKeyOriginBuffer = Buffer.from(opts.withAppKeyOrigin, 'utf8');
        const appKeyBuffer = Buffer.concat([privateKey, appKeyOriginBuffer]);
        const appKeyPrivateKey = (0, keccak_1.keccak256)(appKeyBuffer);
        const appKeyPublicKey = (0, util_1.privateToPublic)(appKeyPrivateKey);
        wallet = {
            privateKey: Buffer.from(appKeyPrivateKey),
            publicKey: Buffer.from(appKeyPublicKey),
        };
    }
    return wallet;
};
SimpleKeyring.type = TYPE;
exports.default = SimpleKeyring;
/**
 * Generate and validate a new random key of 32 bytes.
 *
 * @returns Buffer The generated key.
 */
function generateKey() {
    const privateKey = (0, randombytes_1.default)(32);
    if (!(0, util_1.isValidPrivate)(privateKey)) {
        throw new Error('Private key does not satisfy the curve requirements (ie. it is invalid)');
    }
    return privateKey;
}
/**
 * Type predicate type guard to check if a string is in the enum SignTypedDataVersion.
 *
 * @param version - The string to check.
 * @returns Whether it's in the enum.
 */
// TODO: Put this in @metamask/eth-sig-util
function isSignTypedDataVersion(version) {
    return version in eth_sig_util_1.SignTypedDataVersion;
}

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"@metamask/keyring-controller>@metamask/eth-simple-keyring",file:"node_modules\\@metamask\\eth-simple-keyring\\dist\\simple-keyring.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\CaseInsensitiveMap.cjs", {"./util.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\util.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cdist%5CCaseInsensitiveMap.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CaseInsensitiveMap = void 0;
const util_1 = require("./util.cjs");
/**
 * A case-insensitive map that stores key-value pairs.
 */
class CaseInsensitiveMap extends Map {
    /**
     * Create a new case-insensitive map from a plain object.
     *
     * @param obj - An object with entries to initialize the map with.
     * @returns A new case-insensitive map with all entries from `obj`.
     */
    static fromObject(obj) {
        return new CaseInsensitiveMap(Object.entries(obj));
    }
    /**
     * Return a plain object with all entries from this map.
     *
     * @returns A plain object with all entries from this map.
     */
    toObject() {
        return Object.fromEntries(this.entries());
    }
    /**
     * Return the value associated to the given key, or `undefined` if the key is
     * not found.
     *
     * @param key - The key to get the value for.
     * @returns The value associated to the given key, or `undefined` if the key
     * is not found.
     */
    get(key) {
        return super.get(key.toLowerCase());
    }
    /**
     * Return the value associated with the given key, or throw an error if the
     * key is not found.
     *
     * @param key - The key to look up in the map.
     * @param name - Optional name of the key to include in the error message.
     * @returns The value associated with the given key.
     */
    getOrThrow(key, name = 'Key') {
        return this.get(key) ?? (0, util_1.throwError)(`${name} '${key}' not found`);
    }
    /**
     * Check whether the given key is present in the map.
     *
     * @param key - The key to check for.
     * @returns `true` if the key is present in the map, `false` otherwise.
     */
    has(key) {
        return super.has(key.toLowerCase());
    }
    /**
     * Set the value for the given key. If the key already exists in the map, its
     * value will be updated.
     *
     * The key is converted to lowercase before being stored in the map to ensure
     * case-insensitivity.
     *
     * @param key - The key to set the value for.
     * @param value - The value to set.
     * @returns The map instance.
     */
    set(key, value) {
        return super.set(key.toLowerCase(), value);
    }
    /**
     * Delete the entry for the given key.
     *
     * @param key - The key to delete the entry for.
     * @returns `true` if the entry was present in the map, `false` otherwise.
     */
    delete(key) {
        return super.delete(key.toLowerCase());
    }
}
exports.CaseInsensitiveMap = CaseInsensitiveMap;

      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring",file:"node_modules\\@metamask\\eth-snap-keyring\\dist\\CaseInsensitiveMap.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\DeferredPromise.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cdist%5CDeferredPromise.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeferredPromise = void 0;
/**
 * A deferred promise can be resolved by a caller different from the one who
 * created it.
 *
 * Example:
 * - "A" creates a deferred promise "P", adds it to a list, and awaits it
 * - "B" gets "P" from the list and resolves it
 * - "A" gets the resolved value
 */
class DeferredPromise {
    constructor() {
        this.resolve = undefined;
        this.reject = undefined;
        this.promise = new Promise((resolve, reject) => {
            this.resolve = resolve;
            this.reject = reject;
        });
        // This is a sanity check to make sure that the promise constructor
        // actually set the `resolve` and `reject` functions.
        /* istanbul ignore next */
        if (!this.resolve || !this.reject) {
            throw new Error('Promise constructor failed');
        }
    }
}
exports.DeferredPromise = DeferredPromise;

      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring",file:"node_modules\\@metamask\\eth-snap-keyring\\dist\\DeferredPromise.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\SnapIdMap.cjs", {"./CaseInsensitiveMap.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\CaseInsensitiveMap.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cdist%5CSnapIdMap.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _SnapIdMap_map;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnapIdMap = exports.InvalidSnapIdError = void 0;
const CaseInsensitiveMap_1 = require("./CaseInsensitiveMap.cjs");
/**
 * Error thrown when an invalid Snap ID is encountered.
 */
class InvalidSnapIdError extends Error {
    /**
     * Creates an instance of `InvalidSnapIdError`.
     *
     * @param snapId - The invalid Snap ID.
     * @param key - The key associated with the invalid Snap ID.
     */
    constructor(snapId, key) {
        super(`Snap "${snapId}" is not allowed to set "${key}"`);
        this.name = 'InvalidSnapIdError';
        this.snapId = snapId;
        this.key = key;
    }
}
exports.InvalidSnapIdError = InvalidSnapIdError;
/**
 * A map that associates a string key with a value that has a `snapId`
 * property. Note that the key is case-insensitive.
 *
 * The `snapId` property is used to ensure that only the Snap that added an
 * item to the map can modify or delete it.
 */
class SnapIdMap {
    /**
     * Creates a new `SnapIdMap` object.
     *
     * Example:
     *
     * ```ts
     * const items = [
     *   ['foo', { snapId: '1', name: 'foo' }],
     *   ['bar', { snapId: '1', name: 'bar' }],
     * ];
     * const map = new SnapIdMap(items);
     * ```
     *
     * @param iterable - An iterable object whose elements are key-value pairs.
     * Each key-value pair will be added to the new map.
     */
    constructor(iterable) {
        _SnapIdMap_map.set(this, void 0);
        __classPrivateFieldSet(this, _SnapIdMap_map, new CaseInsensitiveMap_1.CaseInsensitiveMap(iterable), "f");
    }
    /**
     * Returns a plain object with the same key-value pairs as this map.
     *
     * Example:
     *
     * ```ts
     * const items = [
     *   ['foo', { snapId: '1', name: 'foo' }],
     *   ['bar', { snapId: '1', name: 'bar' }],
     * ];
     * const map = new SnapIdMap(items);
     * map.toObject();
     * // Returns
     * // {
     * //   foo: { snapId: '1', name: 'foo' },
     * //   bar: { snapId: '1', name: 'bar' },
     * // }
     * ```
     *
     * @returns A plain object with the same key-value pairs as this map.
     */
    toObject() {
        return __classPrivateFieldGet(this, _SnapIdMap_map, "f").toObject();
    }
    /**
     * Returns a new `SnapIdMap` object from an plain object.
     *
     * Example:
     *
     * ```ts
     * const obj = {
     *   foo: { snapId: '1', name: 'foo' },
     *   bar: { snapId: '1', name: 'bar' },
     * };
     * const map = SnapIdMap.fromObject(obj);
     * ```
     *
     * @param obj - A plain object whose elements will be added to the new map.
     * @returns A new `SnapIdMap` containing the elements of the given object.
     */
    static fromObject(obj) {
        return new SnapIdMap(Object.entries(obj));
    }
    /**
     * Gets a value from the map.
     *
     * If the given key is not present in the map or the Snap ID of the value is
     * different from the given Snap ID, returns `undefined`.
     *
     * Example:
     *
     * ```ts
     * const map = new SnapIdMap();
     * map.set('foo', { snapId: '1', name: 'foo' });
     * map.get('1', 'foo'); // Returns { snapId: '1', name: 'foo' }
     * map.get('2', 'foo'); // Returns `undefined`
     * map.get('1', 'bar'); // Returns `undefined`
     * ```
     *
     * @param snapId - Snap ID present in the value to get.
     * @param key - Key of the element to get.
     * @returns The value associated with the given key and Snap ID.
     */
    get(snapId, key) {
        const value = __classPrivateFieldGet(this, _SnapIdMap_map, "f").get(key);
        return value?.snapId === snapId ? value : undefined;
    }
    /**
     * Gets a Snap ID that's associated with the given key from the map.
     *
     * @param key - Key of the element to get.
     * @returns The Snap ID associated with the given key.
     */
    getSnapId(key) {
        return __classPrivateFieldGet(this, _SnapIdMap_map, "f").get(key)?.snapId;
    }
    /**
     * Gets and delete a value from the map.
     *
     * If the given key is not present in the map or the Snap ID of the value is
     * different from the given Snap ID, returns `undefined`.
     *
     * Example:
     *
     * ```ts
     * const map = new SnapIdMap();
     * map.set('foo', { snapId: '1', name: 'foo' });
     * map.pop('1', 'foo'); // Returns { snapId: '1', name: 'foo' }
     * map.pop('1', 'foo'); // Returns `undefined` (already returned and deleted)
     * map.pop('1', 'bar'); // Returns `undefined`
     * ```
     *
     * @param snapId - Snap ID present in the value to get.
     * @param key - Key of the element to get.
     * @returns The value associated with the given key and Snap ID.
     */
    pop(snapId, key) {
        const value = this.get(snapId, key);
        this.delete(snapId, key);
        return value;
    }
    /**
     * Checks if a key is present in the map.
     *
     * If the given key is not present in the map or the Snap ID of the value is
     * different from the given Snap ID, returns `false`.
     *
     * Example:
     *
     * ```ts
     * const map = new SnapIdMap();
     * map.set('foo', { snapId: '1', name: 'foo' });
     * map.has('1', 'foo'); // Returns `true`
     * map.has('2', 'foo'); // Returns `false`
     * map.has('1', 'bar'); // Returns `false`
     * ```
     *
     * @param snapId - Snap ID present in the value to check.
     * @param key - Key of the element to check.
     * @returns `true` if the key is present in the map and the Snap ID of the
     * value is equal to the given Snap ID, `false` otherwise.
     */
    has(snapId, key) {
        return this.get(snapId, key) !== undefined;
    }
    /**
     * Checks if a snap ID exists in the map.
     *
     * @param snapId - Snap ID present in the value to check.
     * @returns `true` if the snap ID is present in the map, `false` otherwise.
     */
    hasSnapId(snapId) {
        // We could use a reverse-mapping to map Snap ID to their actual key too, but
        // for now, this will do the trick.
        return [...__classPrivateFieldGet(this, _SnapIdMap_map, "f").values()].some((value) => value.snapId === snapId);
    }
    /**
     * Deletes a key from the map.
     *
     * If the given key is not present in the map or the Snap IDs don't match,
     * returns `false` and does nothing.
     *
     * Example:
     *
     * ```ts
     * const map = new SnapIdMap();
     * map.set('foo', { snapId: '1', name: 'foo' });
     * map.delete('2', 'foo'); // Returns `false`
     * map.delete('1', 'bar'); // Returns `false`
     * map.delete('1', 'foo'); // Returns `true`
     * ```
     *
     * @param snapId - Snap ID present in the value to delete.
     * @param key - Key of the element to delete.
     * @returns `true` if the key was present in the map and the Snap ID of the
     * value was equal to the given Snap ID, `false` otherwise.
     */
    delete(snapId, key) {
        return this.has(snapId, key) && __classPrivateFieldGet(this, _SnapIdMap_map, "f").delete(key);
    }
    /* eslint-disable jsdoc/check-indentation */
    /**
     * Adds or updates a key-value pair in the map.
     *
     * Note that this method has a different behavior from the `Map.set`.
     *
     * - If the given key is not already present in the map, this method adds the
     *   key-value pair to the map.
     *
     * - If the given key is already present in the map and the Snap IDs match,
     *   this method updates the value associated with the key.
     *
     * - However, if the given key is already present in the map but the Snap IDs
     *   do not match, this method throws an error.
     *
     * @param key - Key of the element to add or update.
     * @param value - Value of the element to add or update.
     * @returns The map itself.
     */
    /* eslint-enable jsdoc/check-indentation */
    set(key, value) {
        // If the key is present in the map but isn't associated with the given
        // Snap ID, it means that the item was added to the map by a different
        // Snap. In this case, throw an error.
        if (__classPrivateFieldGet(this, _SnapIdMap_map, "f").has(key) && !this.has(value.snapId, key)) {
            throw new InvalidSnapIdError(value.snapId, key);
        }
        __classPrivateFieldGet(this, _SnapIdMap_map, "f").set(key, value);
        return this;
    }
    /**
     * Returns an iterable of the values in the map.
     *
     * Example:
     *
     * ```ts
     * const map = new SnapIdMap([
     *   ['foo', { snapId: '1', name: 'foo' }],
     *   ['bar', { snapId: '1', name: 'bar' }],
     * ]);
     * const values = [...map.values()];
     * // Returns
     * // [
     * //   { snapId: '1', name: 'foo' },
     * //   { snapId: '1', name: 'bar' },
     * // ]
     * ```
     *
     * @returns An iterable of the values in the map.
     */
    values() {
        return __classPrivateFieldGet(this, _SnapIdMap_map, "f").values();
    }
    /**
     * Returns the number of key-value pairs in the map.
     *
     * @returns The number of key-value pairs in the map.
     */
    get size() {
        return __classPrivateFieldGet(this, _SnapIdMap_map, "f").size;
    }
}
exports.SnapIdMap = SnapIdMap;
_SnapIdMap_map = new WeakMap();

      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring",file:"node_modules\\@metamask\\eth-snap-keyring\\dist\\SnapIdMap.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\SnapKeyring.cjs", {"./DeferredPromise.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\DeferredPromise.cjs","./SnapIdMap.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\SnapIdMap.cjs","./SnapKeyringMessenger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\SnapKeyringMessenger.cjs","./account.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\account.cjs","./events.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\events.cjs","./logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\logger.cjs","./migrations/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\migrations\\index.cjs","./options.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\options.cjs","./types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\types.cjs","./util.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\util.cjs","./versions.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\versions.cjs","@ethereumjs/tx":"D:\\code\\v\\metamask-extension\\node_modules\\@ethereumjs\\tx\\dist\\cjs\\index.js","@metamask/eth-sig-util":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-sig-util\\dist\\index.js","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/keyring-internal-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-internal-api\\dist\\index.cjs","@metamask/keyring-internal-snap-client":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-internal-snap-client\\dist\\index.cjs","@metamask/keyring-snap-sdk":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-sdk\\dist\\index.cjs","@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","uuid":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cdist%5CSnapKeyring.cjs
      return function (require, module, exports) {
"use strict";
/* eslint-disable @typescript-eslint/no-redundant-type-constituents */
// This rule seems to be triggering a false positive. Possibly eslint is not
// inferring the `EthMethod`, `BtcMethod`, and `InternalAccount` types correctly.
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _SnapKeyring_instances, _SnapKeyring_messenger, _SnapKeyring_snapClient, _SnapKeyring_accounts, _SnapKeyring_selectedAccounts, _SnapKeyring_requests, _SnapKeyring_options, _SnapKeyring_callbacks, _SnapKeyring_isAnyAccountTypeAllowed, _SnapKeyring_getKeyringVersion, _SnapKeyring_getInternalOptions, _SnapKeyring_handleAccountCreated, _SnapKeyring_handleAccountUpdated, _SnapKeyring_handleAccountDeleted, _SnapKeyring_handleGetSelectedAccounts, _SnapKeyring_handleRequestApproved, _SnapKeyring_handleRequestRejected, _SnapKeyring_rePublishAccountEvent, _SnapKeyring_handleAccountBalancesUpdated, _SnapKeyring_handleAccountAssetListUpdated, _SnapKeyring_handleAccountTransactionsUpdated, _SnapKeyring_getAccount, _SnapKeyring_submitRequest, _SnapKeyring_submitSnapRequestForVersion, _SnapKeyring_submitSnapRequest, _SnapKeyring_hasMethod, _SnapKeyring_createRequestPromise, _SnapKeyring_clearRequestPromise, _SnapKeyring_handleSyncResponse, _SnapKeyring_handleAsyncResponse, _SnapKeyring_sanitizeRedirectUrl, _SnapKeyring_validateRedirectUrl, _SnapKeyring_deleteAccount, _SnapKeyring_resolveAddress, _SnapKeyring_updateSelectedAccountsMap, _SnapKeyring_getSnap, _SnapKeyring_getSnapMetadata, _SnapKeyring_getSnapAllowedOrigins;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnapKeyring = exports.SNAP_KEYRING_TYPE = void 0;
const tx_1 = require("@ethereumjs/tx");
const eth_sig_util_1 = require("@metamask/eth-sig-util");
const keyring_api_1 = require("@metamask/keyring-api");
const keyring_internal_api_1 = require("@metamask/keyring-internal-api");
const keyring_internal_snap_client_1 = require("@metamask/keyring-internal-snap-client");
const keyring_snap_sdk_1 = require("@metamask/keyring-snap-sdk");
const keyring_utils_1 = require("@metamask/keyring-utils");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const uuid_1 = require("uuid");
const account_1 = require("./account.cjs");
const DeferredPromise_1 = require("./DeferredPromise.cjs");
const events_1 = require("./events.cjs");
const logger_1 = require("./logger.cjs");
const migrations_1 = require("./migrations/index.cjs");
const options_1 = require("./options.cjs");
const SnapIdMap_1 = require("./SnapIdMap.cjs");
const SnapKeyringMessenger_1 = require("./SnapKeyringMessenger.cjs");
const types_1 = require("./types.cjs");
const util_1 = require("./util.cjs");
const versions_1 = require("./versions.cjs");
exports.SNAP_KEYRING_TYPE = 'Snap Keyring';
/**
 * Normalize account's address.
 *
 * @param account - The account.
 * @returns The normalized account address.
 */
function normalizeAccountAddress(account) {
    // FIXME: Is it required to lowercase the address here? For now we'll keep this behavior
    // only for Ethereum addresses and use the original address for other non-EVM accounts.
    // For example, Solana addresses are case-sensitives.
    return (0, keyring_api_1.isEvmAccountType)(account.type)
        ? account.address.toLowerCase()
        : account.address;
}
/**
 * Keyring bridge implementation to support Snaps.
 */
class SnapKeyring {
    /**
     * Create a new Snap keyring.
     *
     * @param options - Constructor options.
     * @param options.messenger - Snap keyring messenger.
     * @param options.callbacks - Callbacks used to interact with other components.
     * @param options.isAnyAccountTypeAllowed - Whether to allow the `AnyAccountType` generic account type.
     * @returns A new Snap keyring.
     */
    constructor({ messenger, callbacks, isAnyAccountTypeAllowed = false, }) {
        _SnapKeyring_instances.add(this);
        // Name and state are required for modular initialisation.
        this.name = SnapKeyringMessenger_1.SNAP_KEYRING_NAME;
        this.state = null;
        /**
         * Messenger to dispatch requests to the Snaps controller.
         */
        _SnapKeyring_messenger.set(this, void 0);
        /**
         * Client used to call the Snap keyring.
         */
        _SnapKeyring_snapClient.set(this, void 0);
        /**
         * Mapping between account IDs and an object that contains the associated
         * account object and Snap ID.
         */
        _SnapKeyring_accounts.set(this, void 0);
        /**
         * Mapping between Snap IDs and the selected accounts.
         */
        _SnapKeyring_selectedAccounts.set(this, void 0);
        /**
         * Mapping between request IDs and their deferred promises.
         */
        _SnapKeyring_requests.set(this, void 0);
        /**
         * Mapping between internal options, a correlation ID and a Snap ID.
         */
        _SnapKeyring_options.set(this, void 0);
        /**
         * Callbacks used to interact with other components.
         */
        _SnapKeyring_callbacks.set(this, void 0);
        /**
         * Whether to allow the creation and update of generic accounts.
         *
         * Account deletion is not affected by this flag and is always allowed.
         */
        _SnapKeyring_isAnyAccountTypeAllowed.set(this, void 0);
        this.type = SnapKeyring.type;
        __classPrivateFieldSet(this, _SnapKeyring_messenger, messenger, "f");
        __classPrivateFieldSet(this, _SnapKeyring_snapClient, new keyring_internal_snap_client_1.KeyringInternalSnapClient({ messenger }), "f");
        __classPrivateFieldSet(this, _SnapKeyring_requests, new SnapIdMap_1.SnapIdMap(), "f");
        __classPrivateFieldSet(this, _SnapKeyring_accounts, new SnapIdMap_1.SnapIdMap(), "f");
        __classPrivateFieldSet(this, _SnapKeyring_options, new SnapIdMap_1.SnapIdMap(), "f");
        __classPrivateFieldSet(this, _SnapKeyring_callbacks, callbacks, "f");
        __classPrivateFieldSet(this, _SnapKeyring_isAnyAccountTypeAllowed, isAnyAccountTypeAllowed, "f");
        __classPrivateFieldSet(this, _SnapKeyring_selectedAccounts, new Map(), "f");
    }
    /**
     * Handle a message from a Snap.
     *
     * @param snapId - ID of the Snap.
     * @param message - Message sent by the Snap.
     * @returns The execution result.
     */
    async handleKeyringSnapMessage(snapId, message) {
        (0, superstruct_1.assert)(message, types_1.SnapMessageStruct);
        switch (message.method) {
            case `${keyring_api_1.KeyringEvent.AccountCreated}`: {
                return __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_handleAccountCreated).call(this, snapId, message);
            }
            case `${keyring_api_1.KeyringEvent.AccountUpdated}`: {
                return __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_handleAccountUpdated).call(this, snapId, message);
            }
            case `${keyring_api_1.KeyringEvent.AccountDeleted}`: {
                return __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_handleAccountDeleted).call(this, snapId, message);
            }
            case `${keyring_api_1.KeyringEvent.RequestApproved}`: {
                return __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_handleRequestApproved).call(this, snapId, message);
            }
            case `${keyring_api_1.KeyringEvent.RequestRejected}`: {
                return __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_handleRequestRejected).call(this, snapId, message);
            }
            // Assets related events:
            case `${keyring_api_1.KeyringEvent.AccountBalancesUpdated}`: {
                return __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_handleAccountBalancesUpdated).call(this, snapId, message);
            }
            case `${keyring_api_1.KeyringEvent.AccountAssetListUpdated}`: {
                return __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_handleAccountAssetListUpdated).call(this, snapId, message);
            }
            case `${keyring_api_1.KeyringEvent.AccountTransactionsUpdated}`: {
                return __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_handleAccountTransactionsUpdated).call(this, snapId, message);
            }
            case `${keyring_snap_sdk_1.SnapManageAccountsMethod.GetSelectedAccounts}`: {
                return __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_handleGetSelectedAccounts).call(this, snapId, message);
            }
            default:
                throw new Error(`Method not supported: ${message.method}`);
        }
    }
    /**
     * Serialize the keyring state.
     *
     * @returns Serialized keyring state.
     */
    async serialize() {
        return {
            accounts: __classPrivateFieldGet(this, _SnapKeyring_accounts, "f").toObject(),
        };
    }
    /**
     * Deserialize the keyring state into this keyring.
     *
     * @param state - Serialized keyring state.
     */
    async deserialize(state) {
        // If the state is undefined, it means that this is a new keyring, so we
        // don't need to do anything.
        if (state === undefined) {
            return;
        }
        // Running Snap keyring migrations. We might have some accounts that have a
        // different "version" than the one we expect.
        //
        // In this case, we "transform" then directly when deserializing to convert
        // them in the final account version.
        const accounts = {};
        for (const [snapId, entry] of Object.entries(state.accounts)) {
            // V1 accounts are missing the scopes.
            if ((0, migrations_1.isAccountV1)(entry.account)) {
                console.info(`SnapKeyring - Found a KeyringAccountV1, migrating to V2: ${entry.account.id}`);
                accounts[snapId] = {
                    ...entry,
                    account: (0, migrations_1.migrateAccountV1)(entry.account),
                };
            }
            else {
                accounts[snapId] = entry;
            }
        }
        __classPrivateFieldSet(this, _SnapKeyring_accounts, SnapIdMap_1.SnapIdMap.fromObject(accounts), "f");
    }
    /**
     * Get the addresses of the accounts in this keyring.
     *
     * @returns The addresses of the accounts in this keyring.
     */
    async getAccounts() {
        return (0, util_1.unique)([...__classPrivateFieldGet(this, _SnapKeyring_accounts, "f").values()].map(({ account }) => normalizeAccountAddress(account)));
    }
    /**
     * Get the addresses of the accounts associated with a given Snap.
     *
     * @param snapId - Snap ID to filter by.
     * @returns The addresses of the accounts associated with the given Snap.
     */
    async getAccountsBySnapId(snapId) {
        return (0, util_1.unique)([...__classPrivateFieldGet(this, _SnapKeyring_accounts, "f").values()]
            .filter(({ snapId: accountSnapId }) => accountSnapId === snapId)
            .map(({ account }) => normalizeAccountAddress(account)));
    }
    /**
     * Create an account.
     *
     * @param snapId - Snap ID to create the account for.
     * @param options - Account creation options. Differs between keyrings.
     * @param internalOptions - Internal Snap keyring options.
     * @returns The account object.
     */
    async createAccount(snapId, options, internalOptions) {
        const client = new keyring_internal_snap_client_1.KeyringInternalSnapClient({
            messenger: __classPrivateFieldGet(this, _SnapKeyring_messenger, "f"),
            snapId,
        });
        // The 'metamask' field is reserved, so we have to prevent use of it on
        // the "normal options".
        const reserved = 'metamask';
        if ((0, utils_1.hasProperty)(options, reserved)) {
            throw new Error(`The '${reserved}' property is reserved for internal use`);
        }
        // Those internal options are optional. If not set, we avoid registering anything
        // to internal map (to avoid holding resources for nothing). In this case, it's
        // just a normal `keyring_createAccount`.
        if (!internalOptions) {
            return await client.createAccount(options);
        }
        // A unique ID to identify this execution flow which allows to associate the
        // internal options and the current `keyring_createAccount` flow for that Snap.
        const correlationId = (0, uuid_1.v4)();
        // Register those internal options to use them during the `keyring_createAccount`
        // flow.
        __classPrivateFieldGet(this, _SnapKeyring_options, "f").set(correlationId, {
            snapId,
            options: internalOptions,
        });
        return await client.createAccount({
            ...options,
            // Create internal options context.
            // NOTE: Those options HAVE TO be re-emitted during the `notify:accountCreated` event.
            ...{
                metamask: {
                    correlationId,
                },
            },
        });
    }
    /**
     * Checks if a Snap ID is known from the keyring.
     *
     * @param snapId - Snap ID.
     * @returns `true` if the Snap ID is known, `false` otherwise.
     */
    hasSnapId(snapId) {
        return __classPrivateFieldGet(this, _SnapKeyring_accounts, "f").hasSnapId(snapId);
    }
    /**
     * Resolve the Snap account's address associated from a signing request.
     *
     * @param snapId - Snap ID.
     * @param scope - CAIP-2 chain ID.
     * @param request - Signing request object.
     * @throws An error if the Snap ID is not known from the keyring.
     * @returns The resolved address if found, `null` otherwise.
     */
    async resolveAccountAddress(snapId, scope, request) {
        // We do check that the incoming Snap ID is known by the keyring.
        if (!this.hasSnapId(snapId)) {
            throw new Error(`Unable to resolve account address: unknown Snap ID: ${snapId}`);
        }
        return await __classPrivateFieldGet(this, _SnapKeyring_snapClient, "f")
            .withSnapId(snapId)
            .resolveAccountAddress(scope, request);
    }
    /**
     * Submit a request to a Snap from an account ID.
     *
     * This request cannot be an asynchronous keyring request.
     *
     * @param opts - Request options.
     * @param opts.origin - Send origin.
     * @param opts.account - Account ID.
     * @param opts.method - Method to call.
     * @param opts.params - Method parameters.
     * @param opts.scope - Selected chain ID (CAIP-2).
     * @returns Promise that resolves to the result of the method call.
     */
    async submitRequest({ origin, account: accountId, method, params, scope, }) {
        const { account, snapId } = __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_getAccount).call(this, accountId);
        return await __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_submitSnapRequest).call(this, {
            origin,
            snapId,
            account,
            method: method,
            params,
            scope,
            // For non-EVM (in the context of the multichain API and SIP-26), we enforce responses
            // to be synchronous.
            noPending: true,
        });
    }
    /**
     * Sign a transaction.
     *
     * @param address - Sender's address.
     * @param transaction - Transaction.
     * @param _opts - Transaction options (not used).
     * @returns A promise that resolves to the signed transaction.
     */
    async signTransaction(address, transaction, _opts = {}) {
        const chainId = transaction.common.chainId();
        const tx = (0, util_1.toJson)({
            ...transaction.toJSON(),
            from: address,
            type: `0x${transaction.type.toString(16)}`,
            chainId: (0, utils_1.bigIntToHex)(chainId),
        });
        const signedTx = await __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_submitRequest).call(this, {
            origin: 'metamask',
            address,
            method: keyring_api_1.EthMethod.SignTransaction,
            params: [tx],
            scope: (0, utils_1.toCaipChainId)(utils_1.KnownCaipNamespace.Eip155, `${chainId}`),
        });
        // ! It's *** CRITICAL *** that we mask the signature here, otherwise the
        // ! Snap could overwrite the transaction.
        const signature = (0, superstruct_1.mask)(signedTx, (0, superstruct_1.object)({
            r: (0, superstruct_1.string)(),
            s: (0, superstruct_1.string)(),
            v: (0, superstruct_1.string)(),
        }));
        return tx_1.TransactionFactory.fromTxData({
            ...tx,
            r: signature.r,
            s: signature.s,
            v: signature.v,
        });
    }
    /**
     * Sign a typed data message.
     *
     * @param address - Signer's address.
     * @param data - Data to sign.
     * @param opts - Signing options.
     * @returns The signature.
     */
    async signTypedData(address, data, opts = { version: eth_sig_util_1.SignTypedDataVersion.V1 }) {
        const methods = {
            [eth_sig_util_1.SignTypedDataVersion.V1]: keyring_api_1.EthMethod.SignTypedDataV1,
            [eth_sig_util_1.SignTypedDataVersion.V3]: keyring_api_1.EthMethod.SignTypedDataV3,
            [eth_sig_util_1.SignTypedDataVersion.V4]: keyring_api_1.EthMethod.SignTypedDataV4,
        };
        // Use 'V1' by default to match other keyring implementations. V1 will be
        // used if the version is not specified or not supported.
        const method = methods[opts.version] || keyring_api_1.EthMethod.SignTypedDataV1;
        // Extract chain ID as if it was a typed message (as defined by EIP-712), if
        // input is not a typed message, then chain ID will be undefined!
        const chainId = data.domain?.chainId;
        return (0, keyring_utils_1.strictMask)(await __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_submitRequest).call(this, {
            origin: 'metamask',
            address,
            method,
            params: (0, util_1.toJson)([address, data]),
            ...(chainId === undefined
                ? {}
                : {
                    scope: (0, utils_1.toCaipChainId)(utils_1.KnownCaipNamespace.Eip155, `${chainId}`),
                }),
        }), keyring_api_1.EthBytesStruct);
    }
    /**
     * Sign a message.
     *
     * @param address - Signer's address.
     * @param hash - Data to sign.
     * @returns The signature.
     */
    async signMessage(address, hash) {
        return (0, keyring_utils_1.strictMask)(await __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_submitRequest).call(this, {
            origin: 'metamask',
            address,
            method: keyring_api_1.EthMethod.Sign,
            params: (0, util_1.toJson)([address, hash]),
        }), keyring_api_1.EthBytesStruct);
    }
    /**
     * Sign a personal message.
     *
     * Note: KeyringController says this should return a Buffer but it actually
     * expects a string.
     *
     * @param address - Signer's address.
     * @param data - Data to sign.
     * @returns Promise of the signature.
     */
    async signPersonalMessage(address, data) {
        return (0, keyring_utils_1.strictMask)(await __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_submitRequest).call(this, {
            origin: 'metamask',
            address,
            method: keyring_api_1.EthMethod.PersonalSign,
            params: (0, util_1.toJson)([data, address]),
        }), keyring_api_1.EthBytesStruct);
    }
    /**
     * Convert a base transaction to a base UserOperation.
     *
     * @param address - Address of the sender.
     * @param transactions - Base transactions to include in the UserOperation.
     * @param context - Keyring execution context.
     * @returns A pseudo-UserOperation that can be used to construct a real.
     */
    async prepareUserOperation(address, transactions, context) {
        return (0, keyring_utils_1.strictMask)(await __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_submitRequest).call(this, {
            origin: 'metamask',
            address,
            method: keyring_api_1.EthMethod.PrepareUserOperation,
            params: (0, util_1.toJson)(transactions),
            noPending: true,
            // We assume the chain ID is already well formatted
            scope: (0, utils_1.toCaipChainId)(utils_1.KnownCaipNamespace.Eip155, context.chainId),
        }), keyring_api_1.EthBaseUserOperationStruct);
    }
    /**
     * Patches properties of a UserOperation. Currently, only the
     * `paymasterAndData` can be patched.
     *
     * @param address - Address of the sender.
     * @param userOp - UserOperation to patch.
     * @param context - Keyring execution context.
     * @returns A patch to apply to the UserOperation.
     */
    async patchUserOperation(address, userOp, context) {
        return (0, keyring_utils_1.strictMask)(await __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_submitRequest).call(this, {
            origin: 'metamask',
            address,
            method: keyring_api_1.EthMethod.PatchUserOperation,
            params: (0, util_1.toJson)([userOp]),
            noPending: true,
            // We assume the chain ID is already well formatted
            scope: (0, utils_1.toCaipChainId)(utils_1.KnownCaipNamespace.Eip155, context.chainId),
        }), keyring_api_1.EthUserOperationPatchStruct);
    }
    /**
     * Signs an UserOperation.
     *
     * @param address - Address of the sender.
     * @param userOp - UserOperation to sign.
     * @param context - Leyring execution context.
     * @returns The signature of the UserOperation.
     */
    async signUserOperation(address, userOp, context) {
        return (0, keyring_utils_1.strictMask)(await __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_submitRequest).call(this, {
            origin: 'metamask',
            address,
            method: keyring_api_1.EthMethod.SignUserOperation,
            params: (0, util_1.toJson)([userOp]),
            // We assume the chain ID is already well formatted
            scope: (0, utils_1.toCaipChainId)(utils_1.KnownCaipNamespace.Eip155, context.chainId),
        }), keyring_api_1.EthBytesStruct);
    }
    /**
     * Gets the private data associated with the given address so
     * that it may be exported.
     *
     * If this keyring contains duplicate public keys the first
     * matching address is exported.
     *
     * Used by the UI to export an account.
     *
     * @param _address - Address of the account to export.
     */
    exportAccount(_address) {
        throw new Error('Exporting accounts from snaps is not supported.');
    }
    /**
     * Removes the account matching the given address.
     *
     * @param address - Address of the account to remove.
     */
    async removeAccount(address) {
        const { account, snapId } = __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_resolveAddress).call(this, address);
        await __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_deleteAccount).call(this, snapId, account);
    }
    /**
     * Set the selected accounts.
     *
     * @param accounts - The accounts to set as selected.
     */
    async setSelectedAccounts(accounts) {
        __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_updateSelectedAccountsMap).call(this, accounts);
        const entries = [...__classPrivateFieldGet(this, _SnapKeyring_selectedAccounts, "f").entries()];
        await Promise.all(entries.map(async ([snapId, accountIds]) => {
            try {
                await __classPrivateFieldGet(this, _SnapKeyring_snapClient, "f")
                    .withSnapId(snapId)
                    .setSelectedAccounts(accountIds);
            }
            catch (error) {
                console.error(`Failed to set selected accounts for ${snapId} snap: '${error.message}'`);
            }
        }));
    }
    /**
     * Return an internal account object for a given address.
     *
     * @param address - Address of the account to return.
     * @returns An internal account object for the given address.
     */
    getAccountByAddress(address) {
        const accounts = this.listAccounts();
        return accounts.find(({ address: accountAddress }) => (0, util_1.equalsIgnoreCase)(accountAddress, address));
    }
    /**
     * List all Snap keyring accounts.
     *
     * @returns An array containing all Snap keyring accounts.
     */
    listAccounts() {
        return [...__classPrivateFieldGet(this, _SnapKeyring_accounts, "f").values()].map(({ account, snapId }) => {
            const snap = __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_getSnapMetadata).call(this, snapId);
            return {
                ...account,
                // TODO: Do not convert the address to lowercase.
                //
                // This is a workaround to support the current UI which expects the
                // account address to be lowercase. This workaround should be removed
                // once we migrated the UI to use the account ID instead of the account
                // address.
                //
                // NOTE: We convert the address only for EVM accounts, see
                // `normalizeAccountAddress`.
                address: normalizeAccountAddress(account),
                metadata: {
                    name: '',
                    importTime: 0,
                    keyring: {
                        type: this.type,
                    },
                    ...(snap !== undefined && { snap }),
                },
            };
        });
    }
}
exports.SnapKeyring = SnapKeyring;
_SnapKeyring_messenger = new WeakMap(), _SnapKeyring_snapClient = new WeakMap(), _SnapKeyring_accounts = new WeakMap(), _SnapKeyring_selectedAccounts = new WeakMap(), _SnapKeyring_requests = new WeakMap(), _SnapKeyring_options = new WeakMap(), _SnapKeyring_callbacks = new WeakMap(), _SnapKeyring_isAnyAccountTypeAllowed = new WeakMap(), _SnapKeyring_instances = new WeakSet(), _SnapKeyring_getKeyringVersion = function _SnapKeyring_getKeyringVersion(snapId) {
    return (0, versions_1.getKeyringVersionFromPlatform)((version) => {
        return __classPrivateFieldGet(this, _SnapKeyring_messenger, "f").call('SnapController:isMinimumPlatformVersion', snapId, version);
    });
}, _SnapKeyring_getInternalOptions = function _SnapKeyring_getInternalOptions(snapId, correlationId) {
    if (correlationId) {
        // We still need to check if the correlation ID is valid and associated to
        // some internal options.
        //
        // NOTE: `found` will be `undefined` if a Snap tried to use a correlation ID that
        // belongs to another Snap ID. However, if a Snap starts 2 parallel flow (which
        // will results in 2 different correlation IDs), we won't be able to prevent
        // the Snap from swapping/mixing up those correlation IDs he owns.
        const found = __classPrivateFieldGet(this, _SnapKeyring_options, "f").pop(snapId, correlationId);
        if (found) {
            return found.options;
        }
        console.warn(`SnapKeyring - Received unmapped correlation ID: "${correlationId}"`);
    }
    return undefined;
}, _SnapKeyring_handleAccountCreated = 
/**
 * Handle an Account Created event from a Snap.
 *
 * @param snapId - Snap ID.
 * @param message - Event message.
 * @returns `null`.
 */
async function _SnapKeyring_handleAccountCreated(snapId, message) {
    (0, superstruct_1.assert)(message, events_1.AccountCreatedEventStruct);
    const { metamask, // Used for internal options.
    account: newAccountFromEvent, accountNameSuggestion, displayAccountNameSuggestion, displayConfirmation, } = message.params;
    // READ THIS CAREFULLY:
    // ------------------------------------------------------------------------
    // The account creation flow is now asynchronous. We expect the Snap to
    // first create the account data and then fire the "AccountCreated" event.
    // Potentially migrate the account.
    const account = (0, account_1.transformAccount)(newAccountFromEvent);
    // The `AnyAccountType.Account` generic account type is allowed only during
    // development, so we check whether it's allowed before continuing.
    if (!__classPrivateFieldGet(this, _SnapKeyring_isAnyAccountTypeAllowed, "f") &&
        account.type === keyring_api_1.AnyAccountType.Account) {
        throw new Error(`Cannot create generic account '${account.id}'`);
    }
    // The UI still uses the account address to identify accounts, so we need
    // to block the creation of duplicate accounts for now to prevent accounts
    // from being overwritten.
    const address = normalizeAccountAddress(account);
    if (await __classPrivateFieldGet(this, _SnapKeyring_callbacks, "f").addressExists(address)) {
        throw new Error(`Account address '${address}' already exists`);
    }
    // A Snap could try to create an account with a different address but with
    // an existing ID, so the above test only is not enough.
    if (__classPrivateFieldGet(this, _SnapKeyring_accounts, "f").has(snapId, account.id)) {
        throw new Error(`Account '${account.id}' already exists`);
    }
    // A deferred promise that will be resolved once the Snap keyring has saved
    // its internal state.
    // This part of the flow is run asynchronously, so we have no other way of
    // letting the MetaMask client that this "save" has been run.
    // NOTE: Another way of fixing that could be to rely on events through the
    // messenger maybe?
    const onceSaved = new DeferredPromise_1.DeferredPromise();
    // Add the account to the keyring, but wait for the MetaMask client to
    // approve the account creation first.
    await __classPrivateFieldGet(this, _SnapKeyring_callbacks, "f").addAccount(address, snapId, 
    // This callback is passed to the MetaMask client, it will be called whenever
    // the end user will accept or not the account creation.
    async (accepted) => {
        if (accepted) {
            // We consider the account to be created on the Snap keyring only if
            // the user accepted it. Meaning that the Snap MIGHT HAVE created the
            // account on its own state, but the Snap keyring MIGHT NOT HAVE it yet.
            //
            // e.g The account creation dialog crashed on MetaMask, this callback
            // will never be called, but the Snap still has the account.
            __classPrivateFieldGet(this, _SnapKeyring_accounts, "f").set(account.id, { account, snapId });
            // This is the "true async part". We do not `await` for this call, mainly
            // because this callback will persist the account on the client side
            // (through the `AccountsController`).
            //
            // Since this will happen after the Snap account creation and Snap
            // event, if anything goes wrong, we will delete the account by
            // calling `deleteAccount` on the Snap.
            // eslint-disable-next-line no-void
            void __classPrivateFieldGet(this, _SnapKeyring_callbacks, "f")
                .saveState()
                .then(() => {
                // This allows the MetaMask client to be "notified" when then
                // Snap keyring has truly persisted its state. From there, we should
                // be able to use the account (e.g. to display account creation
                // confirmation dialogs).
                onceSaved.resolve(account.id);
            })
                .catch(async (error) => {
                // FIXME: There's a potential race condition here, if the Snap did
                // not persist the account yet (this should mostly be for older Snaps).
                await __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_deleteAccount).call(this, snapId, account);
                // This allows the MetaMask client to be "notified" that something went
                // wrong with the Snap keyring. (e.g. useful to display account creation
                // error dialogs).
                onceSaved.reject(error);
            });
        }
    }, onceSaved.promise, accountNameSuggestion, (0, options_1.getInternalOptionsOf)([
        // 1. We use the internal options from the Snap keyring.
        __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_getInternalOptions).call(this, snapId, metamask?.correlationId) ?? {},
        // 2. We use the ones coming from the Snap.
        {
            displayConfirmation,
            displayAccountNameSuggestion,
        },
    ]));
    return null;
}, _SnapKeyring_handleAccountUpdated = 
/**
 * Handle an Account Updated event from a Snap.
 *
 * @param snapId - Snap ID.
 * @param message - Event message.
 * @returns `null`.
 */
async function _SnapKeyring_handleAccountUpdated(snapId, message) {
    (0, superstruct_1.assert)(message, events_1.AccountUpdatedEventStruct);
    const { account: newAccountFromEvent } = message.params;
    const { account: oldAccount } = __classPrivateFieldGet(this, _SnapKeyring_accounts, "f").get(snapId, newAccountFromEvent.id) ??
        (0, util_1.throwError)(`Account '${newAccountFromEvent.id}' not found`);
    // Potentially migrate the account.
    const newAccount = (0, account_1.transformAccount)(newAccountFromEvent);
    // The `AnyAccountType.Account` generic account type is allowed only during
    // development, so we check whether it's allowed before continuing.
    //
    // An account cannot be updated if the `isAnyAccountTypeAllowed` flag is
    // set to `false` and the new or old account is a generic account.
    const isGenericAccountInvolved = newAccount.type === keyring_api_1.AnyAccountType.Account ||
        oldAccount.type === keyring_api_1.AnyAccountType.Account;
    if (!__classPrivateFieldGet(this, _SnapKeyring_isAnyAccountTypeAllowed, "f") && isGenericAccountInvolved) {
        throw new Error(`Cannot update generic account '${newAccount.id}'`);
    }
    // The address of the account cannot be changed. In the future, we will
    // support changing the address of an account since it will be required to
    // support UTXO-based chains.
    if (!(0, util_1.equalsIgnoreCase)(oldAccount.address, newAccount.address)) {
        throw new Error(`Cannot change address of account '${newAccount.id}'`);
    }
    __classPrivateFieldGet(this, _SnapKeyring_accounts, "f").set(newAccount.id, { account: newAccount, snapId });
    await __classPrivateFieldGet(this, _SnapKeyring_callbacks, "f").saveState();
    return null;
}, _SnapKeyring_handleAccountDeleted = 
/**
 * Handle an Account Deleted event from a Snap.
 *
 * @param snapId - Snap ID.
 * @param message - Event message.
 * @returns `null`.
 */
async function _SnapKeyring_handleAccountDeleted(snapId, message) {
    (0, superstruct_1.assert)(message, events_1.AccountDeletedEventStruct);
    const { id } = message.params;
    const entry = __classPrivateFieldGet(this, _SnapKeyring_accounts, "f").get(snapId, id);
    // We can ignore the case where the account was already removed from the
    // keyring, making the deletion idempotent.
    //
    // This happens when the keyring calls the Snap to delete an account, and
    // the Snap calls the keyring back with an `AccountDeleted` event.
    if (entry === undefined) {
        return null;
    }
    // At this point we know that the account exists, so we can safely
    // destructure it.
    const { account } = entry;
    await __classPrivateFieldGet(this, _SnapKeyring_callbacks, "f").removeAccount(normalizeAccountAddress(account), snapId, async (accepted) => {
        if (accepted) {
            await __classPrivateFieldGet(this, _SnapKeyring_callbacks, "f").saveState();
        }
    });
    return null;
}, _SnapKeyring_handleGetSelectedAccounts = 
/**
 * Handle a Get Selected Accounts method call from a Snap.
 *
 * @param snapId - Snap ID.
 * @param message - Method call message.
 * @returns The selected accounts.
 */
async function _SnapKeyring_handleGetSelectedAccounts(snapId, message) {
    (0, superstruct_1.assert)(message, keyring_snap_sdk_1.GetSelectedAccountsRequestStruct);
    return __classPrivateFieldGet(this, _SnapKeyring_selectedAccounts, "f").get(snapId) ?? [];
}, _SnapKeyring_handleRequestApproved = 
/**
 * Handle an Request Approved event from a Snap.
 *
 * @param snapId - Snap ID.
 * @param message - Event message.
 * @returns `null`.
 */
async function _SnapKeyring_handleRequestApproved(snapId, message) {
    (0, superstruct_1.assert)(message, events_1.RequestApprovedEventStruct);
    const { id, result } = message.params;
    const { promise } = __classPrivateFieldGet(this, _SnapKeyring_requests, "f").get(snapId, id) ?? (0, util_1.throwError)(`Request '${id}' not found`);
    __classPrivateFieldGet(this, _SnapKeyring_requests, "f").delete(snapId, id);
    promise.resolve(result);
    return null;
}, _SnapKeyring_handleRequestRejected = 
/**
 * Handle an Request Rejected event from a Snap.
 *
 * @param snapId - Snap ID.
 * @param message - Event message.
 * @returns `null`.
 */
async function _SnapKeyring_handleRequestRejected(snapId, message) {
    (0, superstruct_1.assert)(message, events_1.RequestRejectedEventStruct);
    const { id } = message.params;
    const { promise } = __classPrivateFieldGet(this, _SnapKeyring_requests, "f").get(snapId, id) ?? (0, util_1.throwError)(`Request '${id}' not found`);
    __classPrivateFieldGet(this, _SnapKeyring_requests, "f").delete(snapId, id);
    promise.reject(new Error(`Request rejected by user or snap.`));
    return null;
}, _SnapKeyring_rePublishAccountEvent = 
/**
 * Re-publish an account event.
 *
 * @param snapId - Snap ID.
 * @param event - The event type. This is a unique identifier for this event.
 * @param filteredEventCallback - A callback that returns the event to re-publish. This callback takes a filtering
 * function as parameter that can be used to filter out account ID that do not belong to this Snap ID.
 * @template EventType - A Snap keyring event type.
 * @returns `null`.
 */
async function _SnapKeyring_rePublishAccountEvent(snapId, event, filteredEventCallback) {
    // This callback can be used to filter out the accounts that no longer exists on the Snap (fail-safe) or to
    // prevent other Snaps from updating accounts they do not own.
    const filter = (accountMapping) => {
        return Object.entries(accountMapping).reduce((filtered, [accountId, entry]) => {
            if (__classPrivateFieldGet(this, _SnapKeyring_accounts, "f").has(snapId, accountId)) {
                // If the Snap owns this account, we can use it.
                filtered[accountId] = entry;
            }
            else {
                // Otherwise, we just filter it out and log it (for debugging/tracking purposes).
                console.warn(`SnapKeyring - ${event} - Found an unknown account ID "${accountId}" for Snap ID "${snapId}". Skipping.`);
            }
            return filtered;
        }, {});
    };
    __classPrivateFieldGet(this, _SnapKeyring_messenger, "f").publish(event, ...filteredEventCallback(filter));
    return null;
}, _SnapKeyring_handleAccountBalancesUpdated = 
/**
 * Handle a balances updated event from a Snap.
 *
 * @param snapId - ID of the Snap.
 * @param message - Event message.
 * @returns `null`.
 */
async function _SnapKeyring_handleAccountBalancesUpdated(snapId, message) {
    (0, superstruct_1.assert)(message, keyring_api_1.AccountBalancesUpdatedEventStruct);
    const event = message.params;
    return __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_rePublishAccountEvent).call(this, snapId, 'SnapKeyring:accountBalancesUpdated', (filter) => {
        event.balances = filter(event.balances);
        return [event];
    });
}, _SnapKeyring_handleAccountAssetListUpdated = 
/**
 * Handle a asset list updated event from a Snap.
 *
 * @param snapId - ID of the Snap.
 * @param message - Event message.
 * @returns `null`.
 */
async function _SnapKeyring_handleAccountAssetListUpdated(snapId, message) {
    (0, superstruct_1.assert)(message, keyring_api_1.AccountAssetListUpdatedEventStruct);
    const event = message.params;
    return __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_rePublishAccountEvent).call(this, snapId, 'SnapKeyring:accountAssetListUpdated', (filter) => {
        event.assets = filter(event.assets);
        return [event];
    });
}, _SnapKeyring_handleAccountTransactionsUpdated = 
/**
 * Handle a transactions updated event from a Snap.
 *
 * @param snapId - ID of the Snap.
 * @param message - Event message.
 * @returns `null`.
 */
async function _SnapKeyring_handleAccountTransactionsUpdated(snapId, message) {
    (0, superstruct_1.assert)(message, keyring_api_1.AccountTransactionsUpdatedEventStruct);
    const event = message.params;
    return __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_rePublishAccountEvent).call(this, snapId, 'SnapKeyring:accountTransactionsUpdated', (filter) => {
        event.transactions = filter(event.transactions);
        return [event];
    });
}, _SnapKeyring_getAccount = function _SnapKeyring_getAccount(id) {
    const found = [...__classPrivateFieldGet(this, _SnapKeyring_accounts, "f").values()].find((entry) => entry.account.id === id);
    if (!found) {
        throw new Error(`Unable to get account: unknown account ID: '${id}'`);
    }
    return found;
}, _SnapKeyring_submitRequest = 
/**
 * Submit a request to a Snap from an account address.
 *
 * @param opts - Request options.
 * @param opts.origin - Sender origin.
 * @param opts.address - Account address.
 * @param opts.method - Method to call.
 * @param opts.params - Method parameters.
 * @param opts.scope - Selected chain ID (CAIP-2).
 * @param opts.noPending - Whether the response is allowed to be pending.
 * @returns Promise that resolves to the result of the method call.
 */
async function _SnapKeyring_submitRequest({ origin, address, method, params, scope = '', noPending = false, }) {
    const { account, snapId } = __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_resolveAddress).call(this, address);
    return await __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_submitSnapRequest).call(this, {
        origin,
        snapId,
        account,
        method: method,
        params,
        scope,
        noPending,
    });
}, _SnapKeyring_submitSnapRequestForVersion = 
/**
 * Submits a request to a Snap and fix-up the payload depending on the version currently supported.
 *
 * @param options - The options for the Snap request.
 * @param options.version - The supported keyring version for the Snap.
 * @param options.snapId - The Snap ID to submit the request to.
 * @param options.request - The Snap request.
 * @returns A promise that resolves to the keyring response from the Snap.
 */
async function _SnapKeyring_submitSnapRequestForVersion({ snapId, version, request, }) {
    // Get specific client for that Snap.
    const client = __classPrivateFieldGet(this, _SnapKeyring_snapClient, "f").withSnapId(snapId);
    if (version === keyring_internal_api_1.KeyringVersion.V1) {
        return await client.submitRequestV1((0, keyring_internal_api_1.toKeyringRequestV1)(request));
    }
    return await client.submitRequest(request);
}, _SnapKeyring_submitSnapRequest = 
/**
 * Submits a request to a Snap.
 *
 * @param options - The options for the Snap request.
 * @param options.origin - The sender origin.
 * @param options.snapId - The Snap ID to submit the request to.
 * @param options.account - The account to use for the request.
 * @param options.method - The Ethereum method to call.
 * @param options.params - The parameters to pass to the method, can be undefined.
 * @param options.scope - The chain ID to use for the request, can be an empty string.
 * @param options.noPending - Whether the response is allowed to be pending.
 * @returns A promise that resolves to the keyring response from the Snap.
 * @throws An error if the Snap fails to respond or if there's an issue with the request submission.
 */
async function _SnapKeyring_submitSnapRequest({ origin, snapId, account, method, params, scope, noPending, }) {
    if (!__classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_hasMethod).call(this, account, method)) {
        throw new Error(`Method '${method}' not supported for account ${account.address}`);
    }
    // Will both catch `undefined` and "empty" origins.
    if (!origin?.trim()) {
        throw new Error('An `origin` is required');
    }
    // Generate a new random request ID to keep track of the request execution flow.
    const requestId = (0, uuid_1.v4)();
    // Create the promise before calling the Snap to prevent a race condition
    // where the Snap responds before we have a chance to create it.
    const requestPromise = __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_createRequestPromise).call(this, requestId, snapId);
    try {
        const version = __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_getKeyringVersion).call(this, snapId);
        const request = {
            id: requestId,
            origin,
            scope,
            account: account.id,
            request: {
                method,
                ...(params !== undefined && { params }),
            },
        };
        (0, logger_1.projectLogger)('Submit Snap request: ', request);
        const response = await __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_submitSnapRequestForVersion).call(this, {
            version,
            snapId,
            request,
        });
        // Some methods, like the ones used to prepare and patch user operations,
        // require the Snap to answer synchronously in order to work with the
        // confirmation flow. This check lets the caller enforce this behavior.
        if (noPending && response.pending) {
            throw new Error(`Request '${requestId}' to Snap '${snapId}' is pending and noPending is true.`);
        }
        // If the Snap answers synchronously, the promise must be removed from the
        // map to prevent a leak.
        if (!response.pending) {
            return __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_handleSyncResponse).call(this, response, requestId, snapId);
        }
        // If the Snap answers asynchronously, we will inform the user with a redirect
        if (response.redirect?.message || response.redirect?.url) {
            await __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_handleAsyncResponse).call(this, response.redirect, snapId);
        }
        return requestPromise.promise;
    }
    catch (error) {
        (0, logger_1.projectLogger)('Snap Request failed: ', { requestId });
        // If the Snap failed to respond, delete the promise to prevent a leak.
        __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_clearRequestPromise).call(this, requestId, snapId);
        throw error;
    }
}, _SnapKeyring_hasMethod = function _SnapKeyring_hasMethod(account, method) {
    return account.methods.includes(method);
}, _SnapKeyring_createRequestPromise = function _SnapKeyring_createRequestPromise(requestId, snapId) {
    const promise = new DeferredPromise_1.DeferredPromise();
    __classPrivateFieldGet(this, _SnapKeyring_requests, "f").set(requestId, { promise, snapId });
    return promise;
}, _SnapKeyring_clearRequestPromise = function _SnapKeyring_clearRequestPromise(requestId, snapId) {
    __classPrivateFieldGet(this, _SnapKeyring_requests, "f").delete(snapId, requestId);
}, _SnapKeyring_handleSyncResponse = function _SnapKeyring_handleSyncResponse(response, requestId, snapId) {
    __classPrivateFieldGet(this, _SnapKeyring_requests, "f").delete(snapId, requestId);
    // We consider `Response` to be compatible with `result` here.
    return response.result;
}, _SnapKeyring_handleAsyncResponse = 
/**
 * Handles the async redirect and response from a Snap. Validates the redirect URL and informs the user with a message and URL if provided.
 *
 * @param redirect - The redirect information including message and URL.
 * @param redirect.message - The message to show to the user if provided.
 * @param redirect.url - The URL to redirect the user to if provided.
 * @param snapId - The Snap ID associated with the request.
 * @throws An error if the redirect URL is not an allowed origin for the Snap.
 */
async function _SnapKeyring_handleAsyncResponse(redirect, snapId) {
    const { message = '', url: redirectUrl = '' } = redirect;
    const url = __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_sanitizeRedirectUrl).call(this, redirectUrl);
    if (url) {
        __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_validateRedirectUrl).call(this, url, snapId);
    }
    await __classPrivateFieldGet(this, _SnapKeyring_callbacks, "f").redirectUser(snapId, url, message);
}, _SnapKeyring_sanitizeRedirectUrl = function _SnapKeyring_sanitizeRedirectUrl(url) {
    // We do check if the URL is empty or not since the Snap might not returns any URL at all.
    return url ? (0, util_1.sanitizeUrl)(url) : url;
}, _SnapKeyring_validateRedirectUrl = function _SnapKeyring_validateRedirectUrl(url, snapId) {
    const { origin } = new URL(url);
    const snap = __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_getSnap).call(this, snapId);
    if (!snap) {
        throw new Error(`Snap '${snapId}' not found.`);
    }
    const allowedOrigins = __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_getSnapAllowedOrigins).call(this, snap);
    if (!allowedOrigins.includes(origin)) {
        throw new Error(`Redirect URL domain '${origin}' is not an allowed origin by snap '${snapId}'`);
    }
}, _SnapKeyring_deleteAccount = 
/**
 * Removes an account.
 *
 * @param snapId - Snap ID.
 * @param account - Account to delete.
 */
async function _SnapKeyring_deleteAccount(snapId, account) {
    // Always remove the account from the maps, even if the Snap is going to
    // fail to delete it.
    __classPrivateFieldGet(this, _SnapKeyring_accounts, "f").delete(snapId, account.id);
    try {
        await __classPrivateFieldGet(this, _SnapKeyring_snapClient, "f").withSnapId(snapId).deleteAccount(account.id);
    }
    catch (error) {
        // If the Snap failed to delete the account, log the error and continue
        // with the account deletion, otherwise the account will be stuck in the
        // keyring.
        console.error(`Account '${account.address}' may not have been removed from snap '${snapId}':`, error);
    }
}, _SnapKeyring_resolveAddress = function _SnapKeyring_resolveAddress(address) {
    return ([...__classPrivateFieldGet(this, _SnapKeyring_accounts, "f").values()].find(({ account }) => (0, util_1.equalsIgnoreCase)(account.address, address)) ?? (0, util_1.throwError)(`Account '${address}' not found`));
}, _SnapKeyring_updateSelectedAccountsMap = function _SnapKeyring_updateSelectedAccountsMap(accounts) {
    const selectedAccounts = __classPrivateFieldGet(this, _SnapKeyring_selectedAccounts, "f");
    selectedAccounts.clear();
    for (const account of accounts) {
        const snapId = __classPrivateFieldGet(this, _SnapKeyring_accounts, "f").getSnapId(account);
        if (!snapId) {
            continue;
        }
        const snapAccounts = selectedAccounts.get(snapId) ?? [];
        snapAccounts.push(account);
        selectedAccounts.set(snapId, snapAccounts);
    }
}, _SnapKeyring_getSnap = function _SnapKeyring_getSnap(snapId) {
    return __classPrivateFieldGet(this, _SnapKeyring_messenger, "f").call('SnapController:get', snapId);
}, _SnapKeyring_getSnapMetadata = function _SnapKeyring_getSnapMetadata(snapId) {
    const snap = __classPrivateFieldGet(this, _SnapKeyring_instances, "m", _SnapKeyring_getSnap).call(this, snapId);
    return snap
        ? { id: snapId, name: snap.manifest.proposedName, enabled: snap.enabled }
        : undefined;
}, _SnapKeyring_getSnapAllowedOrigins = function _SnapKeyring_getSnapAllowedOrigins(snap) {
    return (snap.manifest.initialPermissions['endowment:keyring']?.allowedOrigins ??
        []);
};
SnapKeyring.type = exports.SNAP_KEYRING_TYPE;

      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring",file:"node_modules\\@metamask\\eth-snap-keyring\\dist\\SnapKeyring.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\SnapKeyringMessenger.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cdist%5CSnapKeyringMessenger.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SNAP_KEYRING_NAME = void 0;
exports.SNAP_KEYRING_NAME = 'SnapKeyring';

      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring",file:"node_modules\\@metamask\\eth-snap-keyring\\dist\\SnapKeyringMessenger.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\account.cjs", {"./migrations/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\migrations\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cdist%5Caccount.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeyringAccountV1Struct = void 0;
exports.assertKeyringAccount = assertKeyringAccount;
exports.transformAccount = transformAccount;
const keyring_api_1 = require("@metamask/keyring-api");
const superstruct_1 = require("@metamask/superstruct");
const migrations_1 = require("./migrations/index.cjs");
/**
 * A `KeyringAccount` with some optional fields which can be used to keep
 * the retro-compatility with older version of keyring accounts/events.
 */
exports.KeyringAccountV1Struct = (0, superstruct_1.omit)(keyring_api_1.KeyringAccountStruct, ['scopes']);
/**
 * Assert that an account-like object matches its actual account type.
 *
 * @param account - The account-like object.
 * @returns The account as normal `KeyringAccount`.
 */
function assertKeyringAccount(account) {
    // TODO: We should use a `selectiveUnion` for this and probably use it to define
    // the `KeyringAccount`. This would also required to have a "generic `KeyringAccount`"
    // definition.
    switch (account.type) {
        case keyring_api_1.BtcAccountType.P2pkh: {
            (0, superstruct_1.assert)(account, keyring_api_1.BtcP2pkhAccountStruct);
            return account;
        }
        case keyring_api_1.BtcAccountType.P2sh: {
            (0, superstruct_1.assert)(account, keyring_api_1.BtcP2shAccountStruct);
            return account;
        }
        case keyring_api_1.BtcAccountType.P2wpkh: {
            (0, superstruct_1.assert)(account, keyring_api_1.BtcP2wpkhAccountStruct);
            return account;
        }
        case keyring_api_1.BtcAccountType.P2tr: {
            (0, superstruct_1.assert)(account, keyring_api_1.BtcP2trAccountStruct);
            return account;
        }
        case keyring_api_1.SolAccountType.DataAccount: {
            (0, superstruct_1.assert)(account, keyring_api_1.SolDataAccountStruct);
            return account;
        }
        case keyring_api_1.EthAccountType.Erc4337: {
            (0, superstruct_1.assert)(account, keyring_api_1.EthErc4337AccountStruct);
            return account;
        }
        case keyring_api_1.EthAccountType.Eoa: {
            (0, superstruct_1.assert)(account, keyring_api_1.EthEoaAccountStruct);
            return account;
        }
        case keyring_api_1.TrxAccountType.Eoa: {
            (0, superstruct_1.assert)(account, keyring_api_1.TrxEoaAccountStruct);
            return account;
        }
        case keyring_api_1.AnyAccountType.Account: {
            (0, superstruct_1.assert)(account, keyring_api_1.KeyringAccountStruct);
            return account;
        }
        default: {
            // For now, we cannot much more than this (this should also, never happen)!
            // NOTE: We could use a  "generic `KeyringAccount` type" here though.
            throw new Error(`Unknown account type: '${account.type}'`);
        }
    }
}
/**
 * Transform any versionned account to a `KeyringAccount`.
 *
 * @param accountToTransform - The account to transform.
 * @returns A valid transformed `KeyringAccount`.
 */
function transformAccount(
// eslint-disable-next-line @typescript-eslint/no-redundant-type-constituents
accountToTransform) {
    // To keep the retro-compatibility with older keyring-api versions, we identify the account's
    // version and transform it to the latest `KeyringAccount` representation.
    const account = (0, migrations_1.isAccountV1)(accountToTransform)
        ? (0, migrations_1.transformAccountV1)(accountToTransform)
        : accountToTransform;
    // We still assert that the converted account is valid according to their account's type.
    return assertKeyringAccount(account);
}

      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring",file:"node_modules\\@metamask\\eth-snap-keyring\\dist\\account.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\events.cjs", {"./account.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\account.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cdist%5Cevents.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RequestRejectedEventStruct = exports.RequestApprovedEventStruct = exports.AccountDeletedEventStruct = exports.AccountUpdatedEventStruct = exports.AccountCreatedEventStruct = void 0;
const keyring_api_1 = require("@metamask/keyring-api");
Object.defineProperty(exports, "AccountDeletedEventStruct", { enumerable: true, get: function () { return keyring_api_1.AccountDeletedEventStruct; } });
Object.defineProperty(exports, "RequestApprovedEventStruct", { enumerable: true, get: function () { return keyring_api_1.RequestApprovedEventStruct; } });
Object.defineProperty(exports, "RequestRejectedEventStruct", { enumerable: true, get: function () { return keyring_api_1.RequestRejectedEventStruct; } });
const keyring_utils_1 = require("@metamask/keyring-utils");
const superstruct_1 = require("@metamask/superstruct");
const account_1 = require("./account.cjs");
exports.AccountCreatedEventStruct = (0, keyring_utils_1.object)({
    ...keyring_api_1.AccountCreatedEventStruct.schema,
    params: (0, keyring_utils_1.object)({
        ...keyring_api_1.AccountCreatedEventStruct.schema.params.schema,
        account: (0, superstruct_1.union)([account_1.KeyringAccountV1Struct, keyring_api_1.KeyringAccountStruct]),
    }),
});
exports.AccountUpdatedEventStruct = (0, keyring_utils_1.object)({
    ...keyring_api_1.AccountUpdatedEventStruct.schema,
    params: (0, keyring_utils_1.object)({
        ...keyring_api_1.AccountUpdatedEventStruct.schema.params.schema,
        account: (0, superstruct_1.union)([account_1.KeyringAccountV1Struct, keyring_api_1.KeyringAccountStruct]),
    }),
});

      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring",file:"node_modules\\@metamask\\eth-snap-keyring\\dist\\events.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\index.cjs", {"./SnapKeyring.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\SnapKeyring.cjs","./options.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\options.cjs","./types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\types.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./options.cjs"), exports);
__exportStar(require("./types.cjs"), exports);
__exportStar(require("./SnapKeyring.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring",file:"node_modules\\@metamask\\eth-snap-keyring\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\logger.cjs", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cdist%5Clogger.cjs
      return function (require, module, exports) {
"use strict";
// istanbul ignore file
Object.defineProperty(exports, "__esModule", { value: true });
exports.createModuleLogger = exports.projectLogger = void 0;
const utils_1 = require("@metamask/utils");
Object.defineProperty(exports, "createModuleLogger", { enumerable: true, get: function () { return utils_1.createModuleLogger; } });
exports.projectLogger = (0, utils_1.createProjectLogger)('eth-snap-keyring');

      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring",file:"node_modules\\@metamask\\eth-snap-keyring\\dist\\logger.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\migrations\\index.cjs", {"./v1.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\migrations\\v1.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cdist%5Cmigrations%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./v1.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring",file:"node_modules\\@metamask\\eth-snap-keyring\\dist\\migrations\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\migrations\\v1.cjs", {"../account.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\account.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cdist%5Cmigrations%5Cv1.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isAccountV1 = isAccountV1;
exports.getScopesForAccountV1 = getScopesForAccountV1;
exports.transformAccountV1 = transformAccountV1;
exports.migrateAccountV1 = migrateAccountV1;
const keyring_api_1 = require("@metamask/keyring-api");
const keyring_utils_1 = require("@metamask/keyring-utils");
const superstruct_1 = require("@metamask/superstruct");
const account_1 = require("../account.cjs");
/**
 * Checks if an account is an `KeyringAccount` v1.
 *
 * @param account - A v1 account to check.
 * @returns True if the account is v1, false otherwise.
 */
function isAccountV1(
// eslint-disable-next-line @typescript-eslint/no-redundant-type-constituents
account) {
    return (0, superstruct_1.is)(account, account_1.KeyringAccountV1Struct);
}
/**
 * Gets default scopes for a v1 account.
 *
 * @param accountV1 - A v1 account.
 * @returns The list of scopes for that accounts.
 */
function getScopesForAccountV1(accountV1) {
    switch (accountV1.type) {
        case keyring_api_1.EthAccountType.Eoa: {
            // EVM EOA account are compatible with any EVM networks, we use the
            // 'eip155:0' scope as defined in the EVM CAIP-10 namespaces.
            //
            // See: https://namespaces.chainagnostic.org/eip155/caip10
            return [keyring_api_1.EthScope.Eoa];
        }
        case keyring_api_1.EthAccountType.Erc4337: {
            // EVM Erc4337 account
            // NOTE: A Smart Contract account might not be compatible with every chain, in this case we just default
            // to testnet since we cannot really "guess" it from here.
            // Also, there's no official Snap as of today that uses this account type. So this case should never happen
            // in production.
            return [keyring_api_1.EthScope.Testnet];
        }
        case keyring_api_1.BtcAccountType.P2pkh:
        case keyring_api_1.BtcAccountType.P2sh:
        case keyring_api_1.BtcAccountType.P2wpkh:
        case keyring_api_1.BtcAccountType.P2tr: {
            // Bitcoin uses different accounts for testnet and mainnet
            return [
                (0, keyring_utils_1.isBtcMainnetAddress)(accountV1.address)
                    ? keyring_api_1.BtcScope.Mainnet
                    : keyring_api_1.BtcScope.Testnet,
            ];
        }
        case keyring_api_1.SolAccountType.DataAccount: {
            // Solana account supports multiple chains.
            return [keyring_api_1.SolScope.Mainnet, keyring_api_1.SolScope.Testnet, keyring_api_1.SolScope.Devnet];
        }
        case keyring_api_1.TrxAccountType.Eoa: {
            // TRON account supports multiple chains.
            return [keyring_api_1.TrxScope.Mainnet, keyring_api_1.TrxScope.Nile, keyring_api_1.TrxScope.Shasta];
        }
        default:
            // We re-use EOA scopes if we don't know what to do for now.
            return [keyring_api_1.EthScope.Eoa];
    }
}
/**
 * Transform an account v1. This account might have optional fields that are now required by
 * the Keyring API. This function will automatically provides the missing fields with some
 * default values.
 *
 * @param accountV1 - A v1 account to transform.
 * @throws An error if the v1 account cannot be transformed.
 * @returns A valid KeyringAccount.
 */
function transformAccountV1(accountV1) {
    const { type } = accountV1;
    // EVM EOA account are compatible with any EVM networks, and we use CAIP-2
    // namespaces when the scope relates to ALL chains (from that namespace).
    // So we can automatically inject a valid `scopes` for this, but not for
    // other kind of accounts.
    if (type === keyring_api_1.EthAccountType.Eoa) {
        return {
            ...accountV1,
            scopes: getScopesForAccountV1(accountV1),
        };
    }
    // For all other non-EVM and ERC4337 Snap accounts, the `scopes` is required, and
    // each `*AccountStruct` should assert that automatically.
    return (0, account_1.assertKeyringAccount)(accountV1);
}
/**
 * Migrate an account v1. This account might have optional fields that are now required by
 * the Keyring API. This function will automatically provides the missing fields with some
 * meaningful default values.
 *
 * @param accountV1 - The account to migrate.
 * @returns A valid KeyringAccount.
 */
function migrateAccountV1(accountV1) {
    if (!isAccountV1(accountV1)) {
        // Nothing to do in this case.
        return accountV1;
    }
    return {
        ...accountV1,
        scopes: getScopesForAccountV1(accountV1),
    };
}

      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring",file:"node_modules\\@metamask\\eth-snap-keyring\\dist\\migrations\\v1.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\options.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cdist%5Coptions.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDefaultInternalOptions = getDefaultInternalOptions;
exports.getInternalOptionsOf = getInternalOptionsOf;
/**
 * Get the default internal options.
 *
 * @returns The default internal options.
 */
function getDefaultInternalOptions() {
    return {
        displayAccountNameSuggestion: true,
        displayConfirmation: true,
        setSelectedAccount: true,
    };
}
/**
 * Combine multiple internal options together. The internal options
 * in the list will be merged in the order they are provided. The first
 * appearance of a key is used, and the following are ignored. If some options
 * are still not defined, it will fallback to the default ones.
 *
 * @param internalOptions - List of internal options to combine.
 * @returns Computed internal options.
 */
function getInternalOptionsOf(internalOptions) {
    const combined = {};
    const defaults = getDefaultInternalOptions();
    const keys = Object.keys(defaults);
    for (const key of keys) {
        // We start off with `undefined` and check every option in the list. If
        // we find any that is defined, we use it. In the end, we will fallback
        // to the default ones that are guaranteed to be defined (thanks to the
        // use of `Required`).
        combined[key] = undefined;
        // We use `defaults` as the last element, so we are guaranteed to have
        // a defined value.
        for (const options of [...internalOptions, defaults]) {
            if (options[key] !== undefined && combined[key] === undefined) {
                combined[key] = options[key];
            }
        }
    }
    // Again, this is safe, see comment above.
    return combined;
}

      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring",file:"node_modules\\@metamask\\eth-snap-keyring\\dist\\options.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\types.cjs", {"@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cdist%5Ctypes.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnapMessageStruct = void 0;
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
exports.SnapMessageStruct = (0, superstruct_1.object)({
    method: (0, superstruct_1.string)(),
    params: (0, superstruct_1.optional)((0, superstruct_1.union)([(0, superstruct_1.array)(utils_1.JsonStruct), (0, superstruct_1.record)((0, superstruct_1.string)(), utils_1.JsonStruct)])),
});

      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring",file:"node_modules\\@metamask\\eth-snap-keyring\\dist\\types.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\util.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cdist%5Cutil.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.unique = unique;
exports.toJson = toJson;
exports.ensureDefined = ensureDefined;
exports.throwError = throwError;
exports.equalsIgnoreCase = equalsIgnoreCase;
exports.sanitizeUrl = sanitizeUrl;
/**
 * Remove duplicate entries from an array.
 *
 * @param array - Array to remove duplicates from.
 * @returns Array with duplicates removed.
 */
function unique(array) {
    return [...new Set(array)];
}
/**
 * Convert a value to a valid JSON object.
 *
 * The function chains JSON.stringify and JSON.parse to ensure that the result
 * is a valid JSON object. In objects, undefined values are removed, and in
 * arrays, they are replaced with null.
 *
 * @param value - Value to convert to JSON.
 * @returns JSON representation of the value.
 */
function toJson(value) {
    return JSON.parse(JSON.stringify(value));
}
/**
 * Asserts that the given value is defined.
 *
 * @param value - Value to check.
 */
function ensureDefined(value) {
    if (value === undefined) {
        throw new Error('Argument is undefined');
    }
}
/**
 * Helper function that throws an error.
 *
 * @param message - Error message to throw.
 */
function throwError(message) {
    throw new Error(message);
}
/**
 * Compares two strings for equality, ignoring case.
 *
 * @param a - The first string to compare.
 * @param b - The second string to compare.
 * @returns `true` if the strings are equal, ignoring case. `false` otherwise.
 */
function equalsIgnoreCase(a, b) {
    return a.toLowerCase() === b.toLowerCase();
}
/**
 * Sanitize a URL.
 *
 * @param url - The URL to sanitize.
 * @returns The new sanitized redirect URL.
 */
function sanitizeUrl(url) {
    // We use a `URL` object to detect any badly formatted URL and to normalize/sanitize them.
    const saferUrl = new URL(url);
    return saferUrl.toString();
}

      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring",file:"node_modules\\@metamask\\eth-snap-keyring\\dist\\util.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\dist\\versions.cjs", {"@metamask/keyring-internal-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-internal-api\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cdist%5Cversions.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PLATFORM_VERSION_TO_KEYRING_VERSION = void 0;
exports.getKeyringVersionFromPlatform = getKeyringVersionFromPlatform;
const keyring_internal_api_1 = require("@metamask/keyring-internal-api");
/**
 * Mapping of the Snap platform version to its `KeyringVersion` equivalent.
 *
 * NOTE: We use an array here to preserve ordering of each versions.
 */
exports.PLATFORM_VERSION_TO_KEYRING_VERSION = [
    // ! NOTE: This versions needs to be sorted in a descending order (highest platform version first).
    // Introduction of `KeyringRequest.origin`.
    ['7.0.0', keyring_internal_api_1.KeyringVersion.V2],
];
/**
 * Gets keyring's version for a given Snap.
 *
 * @param isSupportedVersion - Predicate to check if the version is supported.
 * @returns The Snap's keyring version.
 */
function getKeyringVersionFromPlatform(isSupportedVersion) {
    for (const [platformVersion, keyringVersion,] of exports.PLATFORM_VERSION_TO_KEYRING_VERSION) {
        // NOTE: We are type-casting, but we have a unit tests that make sure all
        // versions are following the semver spec.
        if (isSupportedVersion(platformVersion)) {
            return keyringVersion;
        }
    }
    return keyring_internal_api_1.KeyringVersion.V1;
}

      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring",file:"node_modules\\@metamask\\eth-snap-keyring\\dist\\versions.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\index.js", {"./nil.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\nil.js","./parse.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\parse.js","./stringify.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\stringify.js","./v1.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\v1.js","./v3.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\v3.js","./v4.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\v4.js","./v5.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\v5.js","./validate.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\validate.js","./version.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\version.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cnode_modules%5Cuuid%5Cdist%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NIL", {
  enumerable: true,
  get: function () {
    return _nil.default;
  }
});
Object.defineProperty(exports, "parse", {
  enumerable: true,
  get: function () {
    return _parse.default;
  }
});
Object.defineProperty(exports, "stringify", {
  enumerable: true,
  get: function () {
    return _stringify.default;
  }
});
Object.defineProperty(exports, "v1", {
  enumerable: true,
  get: function () {
    return _v.default;
  }
});
Object.defineProperty(exports, "v3", {
  enumerable: true,
  get: function () {
    return _v2.default;
  }
});
Object.defineProperty(exports, "v4", {
  enumerable: true,
  get: function () {
    return _v3.default;
  }
});
Object.defineProperty(exports, "v5", {
  enumerable: true,
  get: function () {
    return _v4.default;
  }
});
Object.defineProperty(exports, "validate", {
  enumerable: true,
  get: function () {
    return _validate.default;
  }
});
Object.defineProperty(exports, "version", {
  enumerable: true,
  get: function () {
    return _version.default;
  }
});

var _v = _interopRequireDefault(require("./v1.js"));

var _v2 = _interopRequireDefault(require("./v3.js"));

var _v3 = _interopRequireDefault(require("./v4.js"));

var _v4 = _interopRequireDefault(require("./v5.js"));

var _nil = _interopRequireDefault(require("./nil.js"));

var _version = _interopRequireDefault(require("./version.js"));

var _validate = _interopRequireDefault(require("./validate.js"));

var _stringify = _interopRequireDefault(require("./stringify.js"));

var _parse = _interopRequireDefault(require("./parse.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring>uuid",file:"node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\md5-browser.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cnode_modules%5Cuuid%5Cdist%5Cmd5-browser.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

/*
 * Browser-compatible JavaScript MD5
 *
 * Modification of JavaScript MD5
 * https://github.com/blueimp/JavaScript-MD5
 *
 * Copyright 2011, Sebastian Tschan
 * https://blueimp.net
 *
 * Licensed under the MIT license:
 * https://opensource.org/licenses/MIT
 *
 * Based on
 * A JavaScript implementation of the RSA Data Security, Inc. MD5 Message
 * Digest Algorithm, as defined in RFC 1321.
 * Version 2.2 Copyright (C) Paul Johnston 1999 - 2009
 * Other contributors: Greg Holt, Andrew Kepert, Ydnar, Lostinet
 * Distributed under the BSD License
 * See http://pajhome.org.uk/crypt/md5 for more info.
 */
function md5(bytes) {
  if (typeof bytes === 'string') {
    const msg = unescape(encodeURIComponent(bytes)); // UTF8 escape

    bytes = new Uint8Array(msg.length);

    for (let i = 0; i < msg.length; ++i) {
      bytes[i] = msg.charCodeAt(i);
    }
  }

  return md5ToHexEncodedArray(wordsToMd5(bytesToWords(bytes), bytes.length * 8));
}
/*
 * Convert an array of little-endian words to an array of bytes
 */


function md5ToHexEncodedArray(input) {
  const output = [];
  const length32 = input.length * 32;
  const hexTab = '0123456789abcdef';

  for (let i = 0; i < length32; i += 8) {
    const x = input[i >> 5] >>> i % 32 & 0xff;
    const hex = parseInt(hexTab.charAt(x >>> 4 & 0x0f) + hexTab.charAt(x & 0x0f), 16);
    output.push(hex);
  }

  return output;
}
/**
 * Calculate output length with padding and bit length
 */


function getOutputLength(inputLength8) {
  return (inputLength8 + 64 >>> 9 << 4) + 14 + 1;
}
/*
 * Calculate the MD5 of an array of little-endian words, and a bit length.
 */


function wordsToMd5(x, len) {
  /* append padding */
  x[len >> 5] |= 0x80 << len % 32;
  x[getOutputLength(len) - 1] = len;
  let a = 1732584193;
  let b = -271733879;
  let c = -1732584194;
  let d = 271733878;

  for (let i = 0; i < x.length; i += 16) {
    const olda = a;
    const oldb = b;
    const oldc = c;
    const oldd = d;
    a = md5ff(a, b, c, d, x[i], 7, -680876936);
    d = md5ff(d, a, b, c, x[i + 1], 12, -389564586);
    c = md5ff(c, d, a, b, x[i + 2], 17, 606105819);
    b = md5ff(b, c, d, a, x[i + 3], 22, -1044525330);
    a = md5ff(a, b, c, d, x[i + 4], 7, -176418897);
    d = md5ff(d, a, b, c, x[i + 5], 12, 1200080426);
    c = md5ff(c, d, a, b, x[i + 6], 17, -1473231341);
    b = md5ff(b, c, d, a, x[i + 7], 22, -45705983);
    a = md5ff(a, b, c, d, x[i + 8], 7, 1770035416);
    d = md5ff(d, a, b, c, x[i + 9], 12, -1958414417);
    c = md5ff(c, d, a, b, x[i + 10], 17, -42063);
    b = md5ff(b, c, d, a, x[i + 11], 22, -1990404162);
    a = md5ff(a, b, c, d, x[i + 12], 7, 1804603682);
    d = md5ff(d, a, b, c, x[i + 13], 12, -40341101);
    c = md5ff(c, d, a, b, x[i + 14], 17, -1502002290);
    b = md5ff(b, c, d, a, x[i + 15], 22, 1236535329);
    a = md5gg(a, b, c, d, x[i + 1], 5, -165796510);
    d = md5gg(d, a, b, c, x[i + 6], 9, -1069501632);
    c = md5gg(c, d, a, b, x[i + 11], 14, 643717713);
    b = md5gg(b, c, d, a, x[i], 20, -373897302);
    a = md5gg(a, b, c, d, x[i + 5], 5, -701558691);
    d = md5gg(d, a, b, c, x[i + 10], 9, 38016083);
    c = md5gg(c, d, a, b, x[i + 15], 14, -660478335);
    b = md5gg(b, c, d, a, x[i + 4], 20, -405537848);
    a = md5gg(a, b, c, d, x[i + 9], 5, 568446438);
    d = md5gg(d, a, b, c, x[i + 14], 9, -1019803690);
    c = md5gg(c, d, a, b, x[i + 3], 14, -187363961);
    b = md5gg(b, c, d, a, x[i + 8], 20, 1163531501);
    a = md5gg(a, b, c, d, x[i + 13], 5, -1444681467);
    d = md5gg(d, a, b, c, x[i + 2], 9, -51403784);
    c = md5gg(c, d, a, b, x[i + 7], 14, 1735328473);
    b = md5gg(b, c, d, a, x[i + 12], 20, -1926607734);
    a = md5hh(a, b, c, d, x[i + 5], 4, -378558);
    d = md5hh(d, a, b, c, x[i + 8], 11, -2022574463);
    c = md5hh(c, d, a, b, x[i + 11], 16, 1839030562);
    b = md5hh(b, c, d, a, x[i + 14], 23, -35309556);
    a = md5hh(a, b, c, d, x[i + 1], 4, -1530992060);
    d = md5hh(d, a, b, c, x[i + 4], 11, 1272893353);
    c = md5hh(c, d, a, b, x[i + 7], 16, -155497632);
    b = md5hh(b, c, d, a, x[i + 10], 23, -1094730640);
    a = md5hh(a, b, c, d, x[i + 13], 4, 681279174);
    d = md5hh(d, a, b, c, x[i], 11, -358537222);
    c = md5hh(c, d, a, b, x[i + 3], 16, -722521979);
    b = md5hh(b, c, d, a, x[i + 6], 23, 76029189);
    a = md5hh(a, b, c, d, x[i + 9], 4, -640364487);
    d = md5hh(d, a, b, c, x[i + 12], 11, -421815835);
    c = md5hh(c, d, a, b, x[i + 15], 16, 530742520);
    b = md5hh(b, c, d, a, x[i + 2], 23, -995338651);
    a = md5ii(a, b, c, d, x[i], 6, -198630844);
    d = md5ii(d, a, b, c, x[i + 7], 10, 1126891415);
    c = md5ii(c, d, a, b, x[i + 14], 15, -1416354905);
    b = md5ii(b, c, d, a, x[i + 5], 21, -57434055);
    a = md5ii(a, b, c, d, x[i + 12], 6, 1700485571);
    d = md5ii(d, a, b, c, x[i + 3], 10, -1894986606);
    c = md5ii(c, d, a, b, x[i + 10], 15, -1051523);
    b = md5ii(b, c, d, a, x[i + 1], 21, -2054922799);
    a = md5ii(a, b, c, d, x[i + 8], 6, 1873313359);
    d = md5ii(d, a, b, c, x[i + 15], 10, -30611744);
    c = md5ii(c, d, a, b, x[i + 6], 15, -1560198380);
    b = md5ii(b, c, d, a, x[i + 13], 21, 1309151649);
    a = md5ii(a, b, c, d, x[i + 4], 6, -145523070);
    d = md5ii(d, a, b, c, x[i + 11], 10, -1120210379);
    c = md5ii(c, d, a, b, x[i + 2], 15, 718787259);
    b = md5ii(b, c, d, a, x[i + 9], 21, -343485551);
    a = safeAdd(a, olda);
    b = safeAdd(b, oldb);
    c = safeAdd(c, oldc);
    d = safeAdd(d, oldd);
  }

  return [a, b, c, d];
}
/*
 * Convert an array bytes to an array of little-endian words
 * Characters >255 have their high-byte silently ignored.
 */


function bytesToWords(input) {
  if (input.length === 0) {
    return [];
  }

  const length8 = input.length * 8;
  const output = new Uint32Array(getOutputLength(length8));

  for (let i = 0; i < length8; i += 8) {
    output[i >> 5] |= (input[i / 8] & 0xff) << i % 32;
  }

  return output;
}
/*
 * Add integers, wrapping at 2^32. This uses 16-bit operations internally
 * to work around bugs in some JS interpreters.
 */


function safeAdd(x, y) {
  const lsw = (x & 0xffff) + (y & 0xffff);
  const msw = (x >> 16) + (y >> 16) + (lsw >> 16);
  return msw << 16 | lsw & 0xffff;
}
/*
 * Bitwise rotate a 32-bit number to the left.
 */


function bitRotateLeft(num, cnt) {
  return num << cnt | num >>> 32 - cnt;
}
/*
 * These functions implement the four basic operations the algorithm uses.
 */


function md5cmn(q, a, b, x, s, t) {
  return safeAdd(bitRotateLeft(safeAdd(safeAdd(a, q), safeAdd(x, t)), s), b);
}

function md5ff(a, b, c, d, x, s, t) {
  return md5cmn(b & c | ~b & d, a, b, x, s, t);
}

function md5gg(a, b, c, d, x, s, t) {
  return md5cmn(b & d | c & ~d, a, b, x, s, t);
}

function md5hh(a, b, c, d, x, s, t) {
  return md5cmn(b ^ c ^ d, a, b, x, s, t);
}

function md5ii(a, b, c, d, x, s, t) {
  return md5cmn(c ^ (b | ~d), a, b, x, s, t);
}

var _default = md5;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring>uuid",file:"node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\md5-browser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\native-browser.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cnode_modules%5Cuuid%5Cdist%5Cnative-browser.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
const randomUUID = typeof crypto !== 'undefined' && crypto.randomUUID && crypto.randomUUID.bind(crypto);
var _default = {
  randomUUID
};
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring>uuid",file:"node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\native-browser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\nil.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cnode_modules%5Cuuid%5Cdist%5Cnil.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default = '00000000-0000-0000-0000-000000000000';
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring>uuid",file:"node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\nil.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\parse.js", {"./validate.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\validate.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cnode_modules%5Cuuid%5Cdist%5Cparse.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _validate = _interopRequireDefault(require("./validate.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function parse(uuid) {
  if (!(0, _validate.default)(uuid)) {
    throw TypeError('Invalid UUID');
  }

  let v;
  const arr = new Uint8Array(16); // Parse ########-....-....-....-............

  arr[0] = (v = parseInt(uuid.slice(0, 8), 16)) >>> 24;
  arr[1] = v >>> 16 & 0xff;
  arr[2] = v >>> 8 & 0xff;
  arr[3] = v & 0xff; // Parse ........-####-....-....-............

  arr[4] = (v = parseInt(uuid.slice(9, 13), 16)) >>> 8;
  arr[5] = v & 0xff; // Parse ........-....-####-....-............

  arr[6] = (v = parseInt(uuid.slice(14, 18), 16)) >>> 8;
  arr[7] = v & 0xff; // Parse ........-....-....-####-............

  arr[8] = (v = parseInt(uuid.slice(19, 23), 16)) >>> 8;
  arr[9] = v & 0xff; // Parse ........-....-....-....-############
  // (Use "/" to avoid 32-bit truncation when bit-shifting high-order bytes)

  arr[10] = (v = parseInt(uuid.slice(24, 36), 16)) / 0x10000000000 & 0xff;
  arr[11] = v / 0x100000000 & 0xff;
  arr[12] = v >>> 24 & 0xff;
  arr[13] = v >>> 16 & 0xff;
  arr[14] = v >>> 8 & 0xff;
  arr[15] = v & 0xff;
  return arr;
}

var _default = parse;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring>uuid",file:"node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\parse.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\regex.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cnode_modules%5Cuuid%5Cdist%5Cregex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default = /^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring>uuid",file:"node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\regex.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\rng-browser.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cnode_modules%5Cuuid%5Cdist%5Crng-browser.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = rng;
// Unique ID creation requires a high quality random # generator. In the browser we therefore
// require the crypto API and do not support built-in fallback to lower quality random number
// generators (like Math.random()).
let getRandomValues;
const rnds8 = new Uint8Array(16);

function rng() {
  // lazy load so that environments that need to polyfill have a chance to do so
  if (!getRandomValues) {
    // getRandomValues needs to be invoked in a context where "this" is a Crypto implementation.
    getRandomValues = typeof crypto !== 'undefined' && crypto.getRandomValues && crypto.getRandomValues.bind(crypto);

    if (!getRandomValues) {
      throw new Error('crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported');
    }
  }

  return getRandomValues(rnds8);
}
      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring>uuid",file:"node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\rng-browser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\sha1-browser.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cnode_modules%5Cuuid%5Cdist%5Csha1-browser.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

// Adapted from Chris Veness' SHA1 code at
// http://www.movable-type.co.uk/scripts/sha1.html
function f(s, x, y, z) {
  switch (s) {
    case 0:
      return x & y ^ ~x & z;

    case 1:
      return x ^ y ^ z;

    case 2:
      return x & y ^ x & z ^ y & z;

    case 3:
      return x ^ y ^ z;
  }
}

function ROTL(x, n) {
  return x << n | x >>> 32 - n;
}

function sha1(bytes) {
  const K = [0x5a827999, 0x6ed9eba1, 0x8f1bbcdc, 0xca62c1d6];
  const H = [0x67452301, 0xefcdab89, 0x98badcfe, 0x10325476, 0xc3d2e1f0];

  if (typeof bytes === 'string') {
    const msg = unescape(encodeURIComponent(bytes)); // UTF8 escape

    bytes = [];

    for (let i = 0; i < msg.length; ++i) {
      bytes.push(msg.charCodeAt(i));
    }
  } else if (!Array.isArray(bytes)) {
    // Convert Array-like to Array
    bytes = Array.prototype.slice.call(bytes);
  }

  bytes.push(0x80);
  const l = bytes.length / 4 + 2;
  const N = Math.ceil(l / 16);
  const M = new Array(N);

  for (let i = 0; i < N; ++i) {
    const arr = new Uint32Array(16);

    for (let j = 0; j < 16; ++j) {
      arr[j] = bytes[i * 64 + j * 4] << 24 | bytes[i * 64 + j * 4 + 1] << 16 | bytes[i * 64 + j * 4 + 2] << 8 | bytes[i * 64 + j * 4 + 3];
    }

    M[i] = arr;
  }

  M[N - 1][14] = (bytes.length - 1) * 8 / Math.pow(2, 32);
  M[N - 1][14] = Math.floor(M[N - 1][14]);
  M[N - 1][15] = (bytes.length - 1) * 8 & 0xffffffff;

  for (let i = 0; i < N; ++i) {
    const W = new Uint32Array(80);

    for (let t = 0; t < 16; ++t) {
      W[t] = M[i][t];
    }

    for (let t = 16; t < 80; ++t) {
      W[t] = ROTL(W[t - 3] ^ W[t - 8] ^ W[t - 14] ^ W[t - 16], 1);
    }

    let a = H[0];
    let b = H[1];
    let c = H[2];
    let d = H[3];
    let e = H[4];

    for (let t = 0; t < 80; ++t) {
      const s = Math.floor(t / 20);
      const T = ROTL(a, 5) + f(s, b, c, d) + e + K[s] + W[t] >>> 0;
      e = d;
      d = c;
      c = ROTL(b, 30) >>> 0;
      b = a;
      a = T;
    }

    H[0] = H[0] + a >>> 0;
    H[1] = H[1] + b >>> 0;
    H[2] = H[2] + c >>> 0;
    H[3] = H[3] + d >>> 0;
    H[4] = H[4] + e >>> 0;
  }

  return [H[0] >> 24 & 0xff, H[0] >> 16 & 0xff, H[0] >> 8 & 0xff, H[0] & 0xff, H[1] >> 24 & 0xff, H[1] >> 16 & 0xff, H[1] >> 8 & 0xff, H[1] & 0xff, H[2] >> 24 & 0xff, H[2] >> 16 & 0xff, H[2] >> 8 & 0xff, H[2] & 0xff, H[3] >> 24 & 0xff, H[3] >> 16 & 0xff, H[3] >> 8 & 0xff, H[3] & 0xff, H[4] >> 24 & 0xff, H[4] >> 16 & 0xff, H[4] >> 8 & 0xff, H[4] & 0xff];
}

var _default = sha1;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring>uuid",file:"node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\sha1-browser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\stringify.js", {"./validate.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\validate.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cnode_modules%5Cuuid%5Cdist%5Cstringify.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.unsafeStringify = unsafeStringify;

var _validate = _interopRequireDefault(require("./validate.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Convert array of 16 byte values to UUID string format of the form:
 * XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX
 */
const byteToHex = [];

for (let i = 0; i < 256; ++i) {
  byteToHex.push((i + 0x100).toString(16).slice(1));
}

function unsafeStringify(arr, offset = 0) {
  // Note: Be careful editing this code!  It's been tuned for performance
  // and works in ways you may not expect. See https://github.com/uuidjs/uuid/pull/434
  return byteToHex[arr[offset + 0]] + byteToHex[arr[offset + 1]] + byteToHex[arr[offset + 2]] + byteToHex[arr[offset + 3]] + '-' + byteToHex[arr[offset + 4]] + byteToHex[arr[offset + 5]] + '-' + byteToHex[arr[offset + 6]] + byteToHex[arr[offset + 7]] + '-' + byteToHex[arr[offset + 8]] + byteToHex[arr[offset + 9]] + '-' + byteToHex[arr[offset + 10]] + byteToHex[arr[offset + 11]] + byteToHex[arr[offset + 12]] + byteToHex[arr[offset + 13]] + byteToHex[arr[offset + 14]] + byteToHex[arr[offset + 15]];
}

function stringify(arr, offset = 0) {
  const uuid = unsafeStringify(arr, offset); // Consistency check for valid UUID.  If this throws, it's likely due to one
  // of the following:
  // - One or more input array values don't map to a hex octet (leading to
  // "undefined" in the uuid)
  // - Invalid input values for the RFC `version` or `variant` fields

  if (!(0, _validate.default)(uuid)) {
    throw TypeError('Stringified UUID is invalid');
  }

  return uuid;
}

var _default = stringify;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring>uuid",file:"node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\stringify.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\v1.js", {"./rng.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\rng-browser.js","./stringify.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\stringify.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cnode_modules%5Cuuid%5Cdist%5Cv1.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _rng = _interopRequireDefault(require("./rng.js"));

var _stringify = require("./stringify.js");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// **`v1()` - Generate time-based UUID**
//
// Inspired by https://github.com/LiosK/UUID.js
// and http://docs.python.org/library/uuid.html
let _nodeId;

let _clockseq; // Previous uuid creation time


let _lastMSecs = 0;
let _lastNSecs = 0; // See https://github.com/uuidjs/uuid for API details

function v1(options, buf, offset) {
  let i = buf && offset || 0;
  const b = buf || new Array(16);
  options = options || {};
  let node = options.node || _nodeId;
  let clockseq = options.clockseq !== undefined ? options.clockseq : _clockseq; // node and clockseq need to be initialized to random values if they're not
  // specified.  We do this lazily to minimize issues related to insufficient
  // system entropy.  See #189

  if (node == null || clockseq == null) {
    const seedBytes = options.random || (options.rng || _rng.default)();

    if (node == null) {
      // Per 4.5, create and 48-bit node id, (47 random bits + multicast bit = 1)
      node = _nodeId = [seedBytes[0] | 0x01, seedBytes[1], seedBytes[2], seedBytes[3], seedBytes[4], seedBytes[5]];
    }

    if (clockseq == null) {
      // Per 4.2.2, randomize (14 bit) clockseq
      clockseq = _clockseq = (seedBytes[6] << 8 | seedBytes[7]) & 0x3fff;
    }
  } // UUID timestamps are 100 nano-second units since the Gregorian epoch,
  // (1582-10-15 00:00).  JSNumbers aren't precise enough for this, so
  // time is handled internally as 'msecs' (integer milliseconds) and 'nsecs'
  // (100-nanoseconds offset from msecs) since unix epoch, 1970-01-01 00:00.


  let msecs = options.msecs !== undefined ? options.msecs : Date.now(); // Per 4.2.1.2, use count of uuid's generated during the current clock
  // cycle to simulate higher resolution clock

  let nsecs = options.nsecs !== undefined ? options.nsecs : _lastNSecs + 1; // Time since last uuid creation (in msecs)

  const dt = msecs - _lastMSecs + (nsecs - _lastNSecs) / 10000; // Per 4.2.1.2, Bump clockseq on clock regression

  if (dt < 0 && options.clockseq === undefined) {
    clockseq = clockseq + 1 & 0x3fff;
  } // Reset nsecs if clock regresses (new clockseq) or we've moved onto a new
  // time interval


  if ((dt < 0 || msecs > _lastMSecs) && options.nsecs === undefined) {
    nsecs = 0;
  } // Per 4.2.1.2 Throw error if too many uuids are requested


  if (nsecs >= 10000) {
    throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");
  }

  _lastMSecs = msecs;
  _lastNSecs = nsecs;
  _clockseq = clockseq; // Per 4.1.4 - Convert from unix epoch to Gregorian epoch

  msecs += 12219292800000; // `time_low`

  const tl = ((msecs & 0xfffffff) * 10000 + nsecs) % 0x100000000;
  b[i++] = tl >>> 24 & 0xff;
  b[i++] = tl >>> 16 & 0xff;
  b[i++] = tl >>> 8 & 0xff;
  b[i++] = tl & 0xff; // `time_mid`

  const tmh = msecs / 0x100000000 * 10000 & 0xfffffff;
  b[i++] = tmh >>> 8 & 0xff;
  b[i++] = tmh & 0xff; // `time_high_and_version`

  b[i++] = tmh >>> 24 & 0xf | 0x10; // include version

  b[i++] = tmh >>> 16 & 0xff; // `clock_seq_hi_and_reserved` (Per 4.2.2 - include variant)

  b[i++] = clockseq >>> 8 | 0x80; // `clock_seq_low`

  b[i++] = clockseq & 0xff; // `node`

  for (let n = 0; n < 6; ++n) {
    b[i + n] = node[n];
  }

  return buf || (0, _stringify.unsafeStringify)(b);
}

var _default = v1;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring>uuid",file:"node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\v1.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\v3.js", {"./md5.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\md5-browser.js","./v35.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\v35.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cnode_modules%5Cuuid%5Cdist%5Cv3.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _v = _interopRequireDefault(require("./v35.js"));

var _md = _interopRequireDefault(require("./md5.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const v3 = (0, _v.default)('v3', 0x30, _md.default);
var _default = v3;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring>uuid",file:"node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\v3.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\v35.js", {"./parse.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\parse.js","./stringify.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\stringify.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cnode_modules%5Cuuid%5Cdist%5Cv35.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URL = exports.DNS = void 0;
exports.default = v35;

var _stringify = require("./stringify.js");

var _parse = _interopRequireDefault(require("./parse.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function stringToBytes(str) {
  str = unescape(encodeURIComponent(str)); // UTF8 escape

  const bytes = [];

  for (let i = 0; i < str.length; ++i) {
    bytes.push(str.charCodeAt(i));
  }

  return bytes;
}

const DNS = '6ba7b810-9dad-11d1-80b4-00c04fd430c8';
exports.DNS = DNS;
const URL = '6ba7b811-9dad-11d1-80b4-00c04fd430c8';
exports.URL = URL;

function v35(name, version, hashfunc) {
  function generateUUID(value, namespace, buf, offset) {
    var _namespace;

    if (typeof value === 'string') {
      value = stringToBytes(value);
    }

    if (typeof namespace === 'string') {
      namespace = (0, _parse.default)(namespace);
    }

    if (((_namespace = namespace) === null || _namespace === void 0 ? void 0 : _namespace.length) !== 16) {
      throw TypeError('Namespace must be array-like (16 iterable integer values, 0-255)');
    } // Compute hash of namespace and value, Per 4.3
    // Future: Use spread syntax when supported on all platforms, e.g. `bytes =
    // hashfunc([...namespace, ... value])`


    let bytes = new Uint8Array(16 + value.length);
    bytes.set(namespace);
    bytes.set(value, namespace.length);
    bytes = hashfunc(bytes);
    bytes[6] = bytes[6] & 0x0f | version;
    bytes[8] = bytes[8] & 0x3f | 0x80;

    if (buf) {
      offset = offset || 0;

      for (let i = 0; i < 16; ++i) {
        buf[offset + i] = bytes[i];
      }

      return buf;
    }

    return (0, _stringify.unsafeStringify)(bytes);
  } // Function#name is not settable on some platforms (#270)


  try {
    generateUUID.name = name; // eslint-disable-next-line no-empty
  } catch (err) {} // For CommonJS default export support


  generateUUID.DNS = DNS;
  generateUUID.URL = URL;
  return generateUUID;
}
      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring>uuid",file:"node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\v35.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\v4.js", {"./native.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\native-browser.js","./rng.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\rng-browser.js","./stringify.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\stringify.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cnode_modules%5Cuuid%5Cdist%5Cv4.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _native = _interopRequireDefault(require("./native.js"));

var _rng = _interopRequireDefault(require("./rng.js"));

var _stringify = require("./stringify.js");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function v4(options, buf, offset) {
  if (_native.default.randomUUID && !buf && !options) {
    return _native.default.randomUUID();
  }

  options = options || {};

  const rnds = options.random || (options.rng || _rng.default)(); // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`


  rnds[6] = rnds[6] & 0x0f | 0x40;
  rnds[8] = rnds[8] & 0x3f | 0x80; // Copy bytes to buffer, if provided

  if (buf) {
    offset = offset || 0;

    for (let i = 0; i < 16; ++i) {
      buf[offset + i] = rnds[i];
    }

    return buf;
  }

  return (0, _stringify.unsafeStringify)(rnds);
}

var _default = v4;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring>uuid",file:"node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\v4.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\v5.js", {"./sha1.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\sha1-browser.js","./v35.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\v35.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cnode_modules%5Cuuid%5Cdist%5Cv5.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _v = _interopRequireDefault(require("./v35.js"));

var _sha = _interopRequireDefault(require("./sha1.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const v5 = (0, _v.default)('v5', 0x50, _sha.default);
var _default = v5;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring>uuid",file:"node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\v5.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\validate.js", {"./regex.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\regex.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cnode_modules%5Cuuid%5Cdist%5Cvalidate.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _regex = _interopRequireDefault(require("./regex.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function validate(uuid) {
  return typeof uuid === 'string' && _regex.default.test(uuid);
}

var _default = validate;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring>uuid",file:"node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\validate.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\version.js", {"./validate.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\validate.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-snap-keyring%5Cnode_modules%5Cuuid%5Cdist%5Cversion.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _validate = _interopRequireDefault(require("./validate.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function version(uuid) {
  if (!(0, _validate.default)(uuid)) {
    throw TypeError('Invalid UUID');
  }

  return parseInt(uuid.slice(14, 15), 16);
}

var _default = version;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring>uuid",file:"node_modules\\@metamask\\eth-snap-keyring\\node_modules\\uuid\\dist\\version.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\account-link.js", {"./helpers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\helpers.js","./prefix-for-chain":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\prefix-for-chain.js","./prefix-for-network":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\prefix-for-network.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cetherscan-link%5Cdist%5Caccount-link.js
      return function (require, module, exports) {
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAccountLink = exports.createCustomAccountLink = exports.createAccountLinkForChain = exports.createAccountLink = void 0;
const helpers_1 = require("./helpers");
const prefix_for_chain_1 = __importDefault(require("./prefix-for-chain"));
const prefix_for_network_1 = __importDefault(require("./prefix-for-network"));
function createAccountLink(address, networkId) {
    const prefix = prefix_for_network_1.default(networkId);
    return prefix === null ? '' : `https://${prefix}etherscan.io/address/${address}`;
}
exports.createAccountLink = createAccountLink;
function createAccountLinkForChain(address, chainId) {
    const prefix = prefix_for_chain_1.default(chainId);
    return prefix === null ? '' : `https://${prefix}etherscan.io/address/${address}`;
}
exports.createAccountLinkForChain = createAccountLinkForChain;
function createCustomAccountLink(address, customNetworkUrl) {
    const parsedUrl = helpers_1.addPathToUrl(customNetworkUrl, 'address', address);
    return parsedUrl;
}
exports.createCustomAccountLink = createCustomAccountLink;
function getAccountLink(address, chainId, rpcPrefs = {}, networkId = '') {
    if (rpcPrefs.blockExplorerUrl) {
        return createCustomAccountLink(address, rpcPrefs.blockExplorerUrl);
    }
    if (networkId) {
        return createAccountLink(address, networkId);
    }
    return createAccountLinkForChain(address, chainId);
}
exports.getAccountLink = getAccountLink;

      };
    };
  }
  }
}, {package:"@metamask/etherscan-link",file:"node_modules\\@metamask\\etherscan-link\\dist\\account-link.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\explorer-link.js", {"./helpers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\helpers.js","./prefix-for-chain":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\prefix-for-chain.js","./prefix-for-network":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\prefix-for-network.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cetherscan-link%5Cdist%5Cexplorer-link.js
      return function (require, module, exports) {
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getBlockExplorerLink = exports.createExplorerLinkForChain = exports.createExplorerLink = exports.createCustomExplorerLink = void 0;
const helpers_1 = require("./helpers");
const prefix_for_chain_1 = __importDefault(require("./prefix-for-chain"));
const prefix_for_network_1 = __importDefault(require("./prefix-for-network"));
function createCustomExplorerLink(hash, customNetworkUrl) {
    const parsedUrl = helpers_1.addPathToUrl(customNetworkUrl, 'tx', hash);
    return parsedUrl;
}
exports.createCustomExplorerLink = createCustomExplorerLink;
function createExplorerLink(hash, network) {
    const prefix = prefix_for_network_1.default(network);
    return prefix === null ? '' : `https://${prefix}etherscan.io/tx/${hash}`;
}
exports.createExplorerLink = createExplorerLink;
function createExplorerLinkForChain(hash, chainId) {
    const prefix = prefix_for_chain_1.default(chainId);
    return prefix === null ? '' : `https://${prefix}etherscan.io/tx/${hash}`;
}
exports.createExplorerLinkForChain = createExplorerLinkForChain;
function getBlockExplorerLink(transaction, rpcPrefs = {}) {
    if (rpcPrefs.blockExplorerUrl) {
        return createCustomExplorerLink(transaction.hash, rpcPrefs.blockExplorerUrl);
    }
    if (transaction.chainId) {
        return createExplorerLinkForChain(transaction.hash, transaction.chainId);
    }
    return createExplorerLink(transaction.hash, transaction.metamaskNetworkId);
}
exports.getBlockExplorerLink = getBlockExplorerLink;

      };
    };
  }
  }
}, {package:"@metamask/etherscan-link",file:"node_modules\\@metamask\\etherscan-link\\dist\\explorer-link.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\helpers.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cetherscan-link%5Cdist%5Chelpers.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addPathToUrl = void 0;
exports.addPathToUrl = (customNetworkUrl, linkType, suffixType) => {
    const { username, password, protocol, host, pathname, search, hash } = new URL(customNetworkUrl);
    const newPath = pathname.endsWith('/') ? `${pathname}${linkType}/${suffixType}` : `${pathname}/${linkType}/${suffixType}`;
    const auth = username ? `${username}:${password}` : '';
    const parsedUrl = new URL(`${protocol}//${auth}${host}${newPath}${search}${hash}`);
    return parsedUrl.toString();
};

      };
    };
  }
  }
}, {package:"@metamask/etherscan-link",file:"node_modules\\@metamask\\etherscan-link\\dist\\helpers.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\index.js", {"./account-link":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\account-link.js","./explorer-link":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\explorer-link.js","./token-tracker-link":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\token-tracker-link.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cetherscan-link%5Cdist%5Cindex.js
      return function (require, module, exports) {
"use strict";
const account_link_1 = require("./account-link");
const explorer_link_1 = require("./explorer-link");
const token_tracker_link_1 = require("./token-tracker-link");
module.exports = {
    createExplorerLink: explorer_link_1.createExplorerLink,
    createCustomExplorerLink: explorer_link_1.createCustomExplorerLink,
    createExplorerLinkForChain: explorer_link_1.createExplorerLinkForChain,
    createAccountLink: account_link_1.createAccountLink,
    createCustomAccountLink: account_link_1.createCustomAccountLink,
    createAccountLinkForChain: account_link_1.createAccountLinkForChain,
    createTokenTrackerLink: token_tracker_link_1.createTokenTrackerLink,
    createCustomTokenTrackerLink: token_tracker_link_1.createCustomTokenTrackerLink,
    createTokenTrackerLinkForChain: token_tracker_link_1.createTokenTrackerLinkForChain,
    getBlockExplorerLink: explorer_link_1.getBlockExplorerLink,
    getAccountLink: account_link_1.getAccountLink,
    getTokenTrackerLink: token_tracker_link_1.getTokenTrackerLink,
};

      };
    };
  }
  }
}, {package:"@metamask/etherscan-link",file:"node_modules\\@metamask\\etherscan-link\\dist\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\prefix-for-chain.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cetherscan-link%5Cdist%5Cprefix-for-chain.js
      return function (require, module, exports) {
"use strict";
module.exports = function getPrefixForChain(chainId) {
    let prefix;
    switch (chainId) {
        case '0x1': // main net
            prefix = '';
            break;
        case '0x5': // goerli test net
            prefix = 'goerli.';
            break;
        case '0xaa36a7': // sepolia test net
            prefix = 'sepolia.';
            break;
        default:
            prefix = null;
    }
    return prefix;
};

      };
    };
  }
  }
}, {package:"@metamask/etherscan-link",file:"node_modules\\@metamask\\etherscan-link\\dist\\prefix-for-chain.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\prefix-for-network.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cetherscan-link%5Cdist%5Cprefix-for-network.js
      return function (require, module, exports) {
"use strict";
module.exports = function getPrefixForNetwork(networkId) {
    // eslint-disable-next-line radix
    const net = parseInt(networkId);
    let prefix;
    switch (net) {
        case 1: // main net
            prefix = '';
            break;
        case 5: // goerli test net
            prefix = 'goerli.';
            break;
        case 11155111: // sepolia test net
            prefix = 'sepolia.';
            break;
        default:
            prefix = null;
    }
    return prefix;
};

      };
    };
  }
  }
}, {package:"@metamask/etherscan-link",file:"node_modules\\@metamask\\etherscan-link\\dist\\prefix-for-network.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\token-tracker-link.js", {"./helpers":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\helpers.js","./prefix-for-chain":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\prefix-for-chain.js","./prefix-for-network":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\etherscan-link\\dist\\prefix-for-network.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cetherscan-link%5Cdist%5Ctoken-tracker-link.js
      return function (require, module, exports) {
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTokenTrackerLink = exports.createTokenTrackerLinkForChain = exports.createCustomTokenTrackerLink = exports.createTokenTrackerLink = void 0;
const helpers_1 = require("./helpers");
const prefix_for_chain_1 = __importDefault(require("./prefix-for-chain"));
const prefix_for_network_1 = __importDefault(require("./prefix-for-network"));
function createTokenTrackerLink(tokenAddress, networkId, holderAddress) {
    const prefix = prefix_for_network_1.default(networkId);
    return prefix === null ? '' :
        `https://${prefix}etherscan.io/token/${tokenAddress}${holderAddress ? `?a=${holderAddress}` : ''}`;
}
exports.createTokenTrackerLink = createTokenTrackerLink;
function createCustomTokenTrackerLink(tokenAddress, customNetworkUrl) {
    const parsedUrl = helpers_1.addPathToUrl(customNetworkUrl, 'token', tokenAddress);
    return parsedUrl;
}
exports.createCustomTokenTrackerLink = createCustomTokenTrackerLink;
function createTokenTrackerLinkForChain(tokenAddress, chainId, holderAddress) {
    const prefix = prefix_for_chain_1.default(chainId);
    return prefix === null ? '' :
        `https://${prefix}etherscan.io/token/${tokenAddress}${holderAddress ? `?a=${holderAddress}` : ''}`;
}
exports.createTokenTrackerLinkForChain = createTokenTrackerLinkForChain;
function getTokenTrackerLink(tokenAddress, chainId, networkId, holderAddress, rpcPrefs = {}) {
    if (rpcPrefs.blockExplorerUrl) {
        return createCustomTokenTrackerLink(tokenAddress, rpcPrefs.blockExplorerUrl);
    }
    if (networkId) {
        return createTokenTrackerLink(tokenAddress, networkId, holderAddress);
    }
    return createTokenTrackerLinkForChain(tokenAddress, chainId, holderAddress);
}
exports.getTokenTrackerLink = getTokenTrackerLink;

      };
    };
  }
  }
}, {package:"@metamask/etherscan-link",file:"node_modules\\@metamask\\etherscan-link\\dist\\token-tracker-link.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ethjs-contract\\lib\\contract.js", {"./has-tx-object":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ethjs-contract\\lib\\has-tx-object.js","@babel/runtime/helpers/asyncToGenerator":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\asyncToGenerator.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/regenerator":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\regenerator\\index.js","@metamask/ethjs-filter":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ethjs-filter\\lib\\index.js","@metamask/ethjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ethjs-util\\lib\\index.js","ethjs-abi":"D:\\code\\v\\metamask-extension\\node_modules\\ethjs-abi\\lib\\index.js","js-sha3":"D:\\code\\v\\metamask-extension\\node_modules\\js-sha3\\src\\sha3.js","promise-to-callback":"D:\\code\\v\\metamask-extension\\node_modules\\promise-to-callback\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cethjs-contract%5Clib%5Ccontract.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var abi = require('ethjs-abi'); // eslint-disable-line
var EthFilter = require('@metamask/ethjs-filter'); // eslint-disable-line
var getKeys = require('@metamask/ethjs-util').getKeys; // eslint-disable-line
var keccak256 = require('js-sha3').keccak_256; // eslint-disable-line
var promiseToCallback = require('promise-to-callback');
var hasTransactionObject = require('./has-tx-object');
module.exports = Contract;
function Contract() {
  var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var self = this;
  self.abi = opts.contractABI || [];
  self.query = opts.query;
  self.address = opts.address || '0x';
  self.bytecode = opts.contractBytecode || '0x';
  self.defaultTxObject = opts.contractDefaultTxObject || {};
  self.filters = new EthFilter(self.query);
  getCallableMethodsFromABI(self.abi).forEach(function (methodObject) {
    if (methodObject.type === 'function') {
      self[methodObject.name] = createContractFunction(methodObject);
    } else if (methodObject.type === 'event') {
      self[methodObject.name] = createContractEvent(methodObject);
    }
  });
  function createContractEvent(methodObject) {
    return function contractEvent() {
      var methodArgs = [].slice.call(arguments); // eslint-disable-line

      var filterInputTypes = getKeys(methodObject.inputs, 'type', false);
      var filterTopic = "0x" + keccak256(methodObject.name + "(" + filterInputTypes.join(',') + ")");
      var filterTopcis = [filterTopic];
      var argsObject = Object.assign({}, methodArgs[0]) || {};
      var defaultFilterObject = Object.assign({}, methodArgs[0] || {}, {
        to: self.address,
        topics: filterTopcis
      });
      var filterOpts = Object.assign({}, argsObject, {
        decoder: function decoder(logData) {
          return abi.decodeEvent(methodObject, logData, filterTopcis);
        },
        defaultFilterObject: defaultFilterObject
      });
      return new self.filters.Filter(filterOpts);
    };
  }
  function createContractFunction(methodObject) {
    return function contractFunction() {
      var methodCallback; // eslint-disable-line
      var methodArgs = [].slice.call(arguments); // eslint-disable-line
      if (typeof methodArgs[methodArgs.length - 1] === 'function') {
        methodCallback = methodArgs.pop();
      }
      var promise = performCall({
        methodObject: methodObject,
        methodArgs: methodArgs
      });
      if (methodCallback) {
        return promiseToCallback(promise)(methodCallback);
      }
      return promise;
    };
  }
  function performCall(_x) {
    return _performCall.apply(this, arguments);
  }
  function _performCall() {
    _performCall = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(_ref) {
      var methodObject, methodArgs, queryMethod, providedTxObject, methodTxObject, queryResult, decodedMethodResult, decodingError;
      return _regenerator["default"].wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            methodObject = _ref.methodObject, methodArgs = _ref.methodArgs;
            queryMethod = 'call'; // eslint-disable-line
            providedTxObject = {}; // eslint-disable-line
            if (hasTransactionObject(methodArgs)) providedTxObject = methodArgs.pop();
            methodTxObject = Object.assign({}, self.defaultTxObject, providedTxObject, {
              to: self.address
            });
            methodTxObject.data = abi.encodeMethod(methodObject, methodArgs);
            if (methodObject.constant === false) {
              queryMethod = 'sendTransaction';
            }
            _context.next = 9;
            return self.query[queryMethod](methodTxObject);
          case 9:
            queryResult = _context.sent;
            if (!(queryMethod === 'call')) {
              _context.next = 20;
              break;
            }
            _context.prev = 11;
            decodedMethodResult = abi.decodeMethod(methodObject, queryResult);
            return _context.abrupt("return", decodedMethodResult);
          case 16:
            _context.prev = 16;
            _context.t0 = _context["catch"](11);
            decodingError = new Error("[ethjs-contract] while formatting incoming raw call data " + JSON.stringify(queryResult) + " " + _context.t0);
            throw decodingError;
          case 20:
            return _context.abrupt("return", queryResult);
          case 21:
          case "end":
            return _context.stop();
        }
      }, _callee, null, [[11, 16]]);
    }));
    return _performCall.apply(this, arguments);
  }
}
function getCallableMethodsFromABI(contractABI) {
  return contractABI.filter(function (json) {
    return (json.type === 'function' || json.type === 'event') && json.name.length > 0;
  });
}
      };
    };
  }
  }
}, {package:"eth-method-registry>@metamask/ethjs-contract",file:"node_modules\\@metamask\\ethjs-contract\\lib\\contract.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ethjs-contract\\lib\\has-tx-object.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cethjs-contract%5Clib%5Chas-tx-object.js
      return function (require, module, exports) {
"use strict";

var txObjectProperties = ['from', 'to', 'data', 'value', 'gasPrice', 'gas'];
module.exports = hasTransactionObject;
function hasTransactionObject(args) {
  // bad/empty args: bad
  if (!Array.isArray(args) || args.length === 0) {
    return false;
  }
  var lastArg = args[args.length - 1];
  // missing or non-object: bad
  if (!lastArg) return false;
  if (typeof lastArg !== 'object') {
    return false;
  }
  // empty object: good
  if (Object.keys(lastArg).length === 0) {
    return true;
  }
  // txParams object: good
  var keys = Object.keys(lastArg);
  var hasMatchingKeys = txObjectProperties.some(function (value) {
    return keys.includes(value);
  });
  if (hasMatchingKeys) {
    return true;
  }
  // no match
  return false;
}
      };
    };
  }
  }
}, {package:"eth-method-registry>@metamask/ethjs-contract",file:"node_modules\\@metamask\\ethjs-contract\\lib\\has-tx-object.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ethjs-contract\\lib\\index.js", {"./contract":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ethjs-contract\\lib\\contract.js","./has-tx-object":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ethjs-contract\\lib\\has-tx-object.js","@metamask/ethjs-filter":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ethjs-filter\\lib\\index.js","@metamask/ethjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ethjs-util\\lib\\index.js","ethjs-abi":"D:\\code\\v\\metamask-extension\\node_modules\\ethjs-abi\\lib\\index.js","js-sha3":"D:\\code\\v\\metamask-extension\\node_modules\\js-sha3\\src\\sha3.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cethjs-contract%5Clib%5Cindex.js
      return function (require, module, exports) {
"use strict";

var abi = require('ethjs-abi'); // eslint-disable-line
var keccak256 = require('js-sha3').keccak_256; // eslint-disable-line
var EthFilter = require('@metamask/ethjs-filter'); // eslint-disable-line
var getKeys = require('@metamask/ethjs-util').getKeys; // eslint-disable-line
var Contract = require('./contract');
var hasTransactionObject = require('./has-tx-object');
module.exports = EthContract;
function EthContract(query) {
  return function contractFactory(contractABI, contractBytecode, contractDefaultTxObject) {
    // validate params
    if (!Array.isArray(contractABI)) {
      throw new Error("[ethjs-contract] Contract ABI must be type Array, got type " + typeof contractABI);
    }
    if (typeof contractBytecode !== 'undefined' && typeof contractBytecode !== 'string') {
      throw new Error("[ethjs-contract] Contract bytecode must be type String, got type " + typeof contractBytecode);
    }
    if (typeof contractDefaultTxObject !== 'undefined' && typeof contractDefaultTxObject !== 'object') {
      throw new Error("[ethjs-contract] Contract default tx object must be type Object, got type " + typeof contractABI);
    }

    // build contract object
    var output = {};
    output.at = function contractAtAddress(address) {
      return new Contract({
        address: address,
        query: query,
        contractBytecode: contractBytecode,
        contractDefaultTxObject: contractDefaultTxObject,
        contractABI: contractABI
      });
    };
    output["new"] = function newContract() {
      var providedTxObject = {}; // eslint-disable-line
      var newMethodCallback = null; // eslint-disable-line
      var newMethodArgs = [].slice.call(arguments); // eslint-disable-line
      if (typeof newMethodArgs[newMethodArgs.length - 1] === 'function') newMethodCallback = newMethodArgs.pop();
      if (hasTransactionObject(newMethodArgs)) providedTxObject = newMethodArgs.pop();
      var constructorMethod = getConstructorFromABI(contractABI);
      var assembleTxObject = Object.assign({}, contractDefaultTxObject, providedTxObject);

      // set contract deploy bytecode
      if (contractBytecode) {
        assembleTxObject.data = contractBytecode;
      }

      // append encoded constructor arguments
      if (constructorMethod) {
        var constructorBytecode = abi.encodeParams(getKeys(constructorMethod.inputs, 'type'), newMethodArgs).substring(2); // eslint-disable-line
        assembleTxObject.data = "" + assembleTxObject.data + constructorBytecode;
      }
      return newMethodCallback ? query.sendTransaction(assembleTxObject, newMethodCallback) : query.sendTransaction(assembleTxObject);
    };
    return output;
  };
}
function getConstructorFromABI(contractABI) {
  return contractABI.filter(function (json) {
    return json.type === 'constructor';
  })[0];
}
      };
    };
  }
  }
}, {package:"eth-method-registry>@metamask/ethjs-contract",file:"node_modules\\@metamask\\ethjs-contract\\lib\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ethjs-filter\\lib\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cethjs-filter%5Clib%5Cindex.js
      return function (require, module, exports) {
"use strict";

function constructFilter(filterName, query) {
  function Filter(options) {
    var self = this;
    self.filterId = null;
    self.options = Object.assign({
      delay: 300,
      decoder: function decodeData(data) {
        return data;
      },
      defaultFilterObject: {}
    }, options || {});
    self.watchers = {};
    self.interval = setInterval(function () {
      if (self.filterId !== null && Object.keys(self.watchers).length > 0) {
        query.getFilterChanges(self.filterId, function (changeError, changeResult) {
          var decodedChangeResults = [];
          var decodingError = null; // eslint-disable-line

          if (!changeError) {
            try {
              changeResult.forEach(function (log, logIndex) {
                decodedChangeResults[logIndex] = changeResult[logIndex];
                if (typeof changeResult[logIndex] === 'object') {
                  decodedChangeResults[logIndex].data = self.options.decoder(decodedChangeResults[logIndex].data);
                }
              });
            } catch (decodingErrorMesage) {
              decodingError = new Error("[ethjs-filter] while decoding filter change event data from RPC '" + JSON.stringify(decodedChangeResults) + "': " + decodingErrorMesage);
            }
          }
          Object.keys(self.watchers).forEach(function (id) {
            var watcher = self.watchers[id];
            if (watcher.stop === true) {
              delete self.watchers[id];
              return;
            }
            if (decodingError) {
              watcher.callback(decodingError, null);
            } else if (changeError) {
              watcher.callback(changeError, null);
            } else if (Array.isArray(decodedChangeResults) && changeResult.length > 0) {
              watcher.callback(changeError, decodedChangeResults);
            }
          });
        });
      }
    }, self.options.delay);
  }
  Filter.prototype.at = function atFilter(filterId) {
    var self = this;
    self.filterId = filterId;
  };
  Filter.prototype.watch = function watchFilter(watchCallbackInput) {
    var callback = watchCallbackInput || function () {}; // eslint-disable-line
    var self = this;
    var id = Math.random().toString(36).substring(7);
    self.watchers[id] = {
      callback: callback,
      stop: false,
      stopWatching: function stopWatching() {
        self.watchers[id].stop = true;
      }
    };
    return self.watchers[id];
  };
  Filter.prototype.uninstall = function uninstallFilter(cb) {
    var self = this;
    var callback = cb || null;
    self.watchers = Object.assign({});
    clearInterval(self.interval);
    var prom = new Promise(function (resolve, reject) {
      query.uninstallFilter(self.filterId, function (uninstallError, uninstallResilt) {
        if (uninstallError) {
          reject(uninstallError);
        } else {
          resolve(uninstallResilt);
        }
      });
    });
    if (callback) {
      prom.then(function (res) {
        return callback(null, res);
      })["catch"](function (err) {
        return callback(err, null);
      });
    }
    return callback ? null : prom;
  };
  Filter.prototype["new"] = function newFilter() {
    var callback = null; // eslint-disable-line
    var self = this;
    var filterInputs = [];
    var args = [].slice.call(arguments); // eslint-disable-line
    // pop callback if provided
    if (typeof args[args.length - 1] === 'function') {
      callback = args.pop();
    }

    // if a param object was presented, push that into the inputs
    if (filterName === 'Filter') {
      filterInputs.push(Object.assign(self.options.defaultFilterObject, args[args.length - 1] || {}));
    }
    var prom = new Promise(function (resolve, reject) {
      // add complex callback
      filterInputs.push(function (setupError, filterId) {
        if (!setupError) {
          self.filterId = filterId;
          resolve(filterId);
        } else {
          reject(setupError);
        }
      });

      // apply filter, call new.. filter method
      // eslint-disable-next-line prefer-spread
      query["new" + filterName].apply(query, filterInputs);
    });
    if (callback) {
      prom.then(function (res) {
        return callback(null, res);
      })["catch"](function (err) {
        return callback(err, null);
      });
    }
    return callback ? null : prom;
  };
  return Filter;
}

/**
 * EthFilter constructor, intakes a query, helps manage filter event polling
 *
 * @method EthFilter
 * @param {Object} query the `ethjs-query` or `eth-query` object
 * @returns {Object} output an EthFilter instance
 * @throws error if new is not used
 */

function EthFilter(query) {
  var self = this;
  if (!(self instanceof EthFilter)) {
    throw new Error('the EthFilter object must be instantiated with `new` flag.. (e.g. `const filters = new EthFilter(query);`)');
  }
  if (typeof query !== 'object') {
    throw new Error('the EthFilter object must be instantiated with an EthQuery instance (e.g. `const filters = new EthFilter(new EthQuery(provider));`). See github.com/ethjs/ethjs-query for more details..');
  }
  self.Filter = constructFilter('Filter', query);
  self.BlockFilter = constructFilter('BlockFilter', query);
  self.PendingTransactionFilter = constructFilter('PendingTransactionFilter', query);
}

// export EthFilter
module.exports = EthFilter;
      };
    };
  }
  }
}, {package:"eth-method-registry>@metamask/ethjs-contract>@metamask/ethjs-filter",file:"node_modules\\@metamask\\ethjs-filter\\lib\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ethjs-format\\lib\\index.js", {"@metamask/ethjs-util":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ethjs-util\\lib\\index.js","@metamask/number-to-bn":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\number-to-bn\\src\\index.js","ethjs-schema":"D:\\code\\v\\metamask-extension\\node_modules\\ethjs-schema\\src\\schema.json","strip-hex-prefix":"D:\\code\\v\\metamask-extension\\node_modules\\strip-hex-prefix\\src\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cethjs-format%5Clib%5Cindex.js
      return function (require, module, exports) {
"use strict";

var numberToBN = require('@metamask/number-to-bn');
var schema = require('ethjs-schema');
var _require = require('@metamask/ethjs-util'),
  arrayContainsArray = _require.arrayContainsArray,
  getBinarySize = _require.getBinarySize,
  padToEven = _require.padToEven;
var stripHexPrefix = require('strip-hex-prefix');

/**
 * Format quantity values, either encode to hex or decode to BigNumber
 * should intake null, stringNumber, number, BN
 *
 * @method formatQuantity
 * @param {String|BigNumber|Number} value quantity or tag to convert
 * @param {Boolean} encode to hex or decode to BigNumber
 * @returns {Optional} output to BigNumber or string
 * @throws error if value is a float
 */
function formatQuantity(value, encode, pad) {
  if (['string', 'number', 'object'].indexOf(typeof value) === -1 || value === null) {
    return value;
  }
  var numberValue = numberToBN(value);
  var numPadding = pad && numberValue.toString(16).length % 2 ? '0' : '';
  if (numberToBN(value).isNeg()) {
    throw new Error("[ethjs-format] while formatting quantity '" + numberValue.toString(10) + "', invalid negative number. Number must be positive or zero.");
  }
  return encode ? "0x" + numPadding + numberValue.toString(16) : numberValue;
}

/**
 * Format quantity or tag, if tag bypass return, else format quantity
 * should intake null, stringNumber, number, BN, string tag
 *
 * @method formatQuantityOrTag
 * @param {String|BigNumber|Number} value quantity or tag to convert
 * @param {Boolean} encode encode the number to hex or decode to BigNumber
 * @returns {Object|String} output to BigNumber or string
 * @throws error if value is a float
 */
function formatQuantityOrTag(value, encode) {
  var output = value; // eslint-disable-line

  // if the value is a tag, bypass
  if (schema.tags.indexOf(value) === -1) {
    output = formatQuantity(value, encode);
  }
  return output;
}

/**
 * FormatData under strict conditions hex prefix
 *
 * @method formatData
 * @param {String} value the bytes data to be formatted
 * @param {Number} byteLength the required byte length (usually 20 or 32)
 * @returns {String} output output formatted data
 * @throws error if minimum length isnt met
 */
function formatData(value, byteLength) {
  var output = value; // eslint-disable-line
  var outputByteLength = 0; // eslint-disable-line

  // prefix only under strict conditions, else bypass
  if (typeof value === 'string') {
    output = "0x" + padToEven(stripHexPrefix(value));
    outputByteLength = getBinarySize(output);
  }

  // format double padded zeros.
  if (output === '0x00') {
    output = '0x0';
  }

  // throw if bytelength is not correct
  if (typeof byteLength === 'number' && value !== null && output !== '0x' && output !== '0x0' // support empty values
  && (!/^[0-9A-Fa-f]+$/.test(stripHexPrefix(output)) || outputByteLength !== 2 + byteLength * 2)) {
    throw new Error("[ethjs-format] hex string '" + output + "' must be an alphanumeric " + (2 + byteLength * 2) + " utf8 byte hex (chars: a-fA-F) string, is " + outputByteLength + " bytes");
  }
  return output;
}

/**
 * Format object, even with random RPC caviets
 *
 * @method formatObject
 * @param {String|Array} formatter the unit to convert to, default ether
 * @param {Object} value the object value
 * @param {Boolean} encode encode to hex or decode to BigNumber
 * @returns {Object} output object
 * @throws error if value is a float
 */
function formatObject(formatter, value, encode) {
  var output = Object.assign({}, value); // eslint-disable-line
  var formatObject = null; // eslint-disable-line

  // if the object is a string flag, then retreive the object
  if (typeof formatter === 'string') {
    if (formatter === 'Boolean|EthSyncing') {
      formatObject = Object.assign({}, schema.objects.EthSyncing);
    } else if (formatter === 'DATA|Transaction') {
      formatObject = Object.assign({}, schema.objects.Transaction);
    } else {
      formatObject = Object.assign({}, schema.objects[formatter]);
    }
  }

  // check if all required data keys are fulfilled
  if (!arrayContainsArray(Object.keys(value), formatObject.__required)) {
    // eslint-disable-line
    throw new Error("[ethjs-format] object " + JSON.stringify(value) + " must contain properties: " + formatObject.__required.join(', ')); // eslint-disable-line
  }

  // assume formatObject is an object, go through keys and format each
  Object.keys(formatObject).forEach(function (valueKey) {
    if (valueKey !== '__required' && typeof value[valueKey] !== 'undefined') {
      output[valueKey] = format(formatObject[valueKey], value[valueKey], encode);
    }
  });
  return output;
}

/**
 * Format array
 *
 * @method formatArray
 * @param {String|Array} formatter the unit to convert to, default ether
 * @param {Object} value the value in question
 * @param {Boolean} encode encode to hex or decode to BigNumber
 * @param {Number} lengthRequirement the required minimum array length
 * @returns {Object} output object
 * @throws error if minimum length isnt met
 */
function formatArray(formatter, value, encode, lengthRequirement) {
  var output = value.slice(); // eslint-disable-line
  var formatObject = formatter; // eslint-disable-line

  // if the formatter is an array or data, then make format object an array data
  if (formatter === 'Array|DATA') {
    formatObject = ['D'];
  }

  // if formatter is a FilterChange and acts like a BlockFilter
  // or PendingTx change format object to tx hash array
  if (formatter === 'FilterChange' && typeof value[0] === 'string') {
    formatObject = ['D32'];
  }

  // enforce minimum value length requirements
  if (encode === true && typeof lengthRequirement === 'number' && value.length < lengthRequirement) {
    throw new Error("array " + JSON.stringify(value) + " must contain at least " + lengthRequirement + " params, but only contains " + value.length + "."); // eslint-disable-line
  }

  // make new array, avoid mutation
  formatObject = formatObject.slice();

  // assume formatObject is an object, go through keys and format each
  value.forEach(function (valueKey, valueIndex) {
    // use key zero as formatter for all values, unless otherwise specified
    var formatObjectKey = 0; // eslint-disable-line

    // if format array is exact, check each argument against formatter argument
    if (formatObject.length > 1) {
      formatObjectKey = valueIndex;
    }
    output[valueIndex] = format(formatObject[formatObjectKey], valueKey, encode);
  });
  return output;
}

/**
 * Format various kinds of data to RPC spec or into digestable JS objects
 *
 * @method format
 * @param {String|Array} formatter the data formatter
 * @param {String|Array|Object|Null|Number} value the data value input
 * @param {Boolean} encode encode to hex or decode to BigNumbers, Strings, Booleans, Null
 * @param {Number} lengthRequirement the minimum data length requirement
 * @throws error if minimum length isnt met
 */
function format(formatter, value, encode, lengthRequirement) {
  var output = value; // eslint-disable-line

  // if formatter is quantity or quantity or tag
  if (formatter === 'Q') {
    output = formatQuantity(value, encode);
  } else if (formatter === 'QP') {
    output = formatQuantity(value, encode, true);
  } else if (formatter === 'Q|T') {
    output = formatQuantityOrTag(value, encode);
  } else if (formatter === 'D') {
    output = formatData(value); // dont format data flagged objects like compiler output
  } else if (formatter === 'D20') {
    output = formatData(value, 20); // dont format data flagged objects like compiler output
  } else if (formatter === 'D32') {
    output = formatData(value, 32); // dont format data flagged objects like compiler output
  } else if (typeof value === 'object'
  // if value is an object or array
  && value !== null && Array.isArray(value) === false) {
    output = formatObject(formatter, value, encode);
  } else if (Array.isArray(value)) {
    output = formatArray(formatter, value, encode, lengthRequirement);
  }
  return output;
}

/**
 * Format RPC inputs generally to the node or TestRPC
 *
 * @method formatInputs
 * @param {Object} method the data formatter
 * @param {Array} inputs the data inputs
 * @returns {Array} output the formatted inputs array
 * @throws error if minimum length isnt met
 */
function formatInputs(method, inputs) {
  return format(schema.methods[method][0], inputs, true, schema.methods[method][2]);
}

/**
 * Format RPC outputs generally from the node or TestRPC
 *
 * @method formatOutputs
 * @param {Object} method the data formatter
 * @param {Array|String|Null|Boolean|Object} outputs the data inputs
 * @returns {Array|String|Null|Boolean|Object} output the formatted data
 */
function formatOutputs(method, outputs) {
  return format(schema.methods[method][1], outputs, false);
}

// export formatters
module.exports = {
  schema: schema,
  formatQuantity: formatQuantity,
  formatQuantityOrTag: formatQuantityOrTag,
  formatObject: formatObject,
  formatArray: formatArray,
  format: format,
  formatInputs: formatInputs,
  formatOutputs: formatOutputs
};
      };
    };
  }
  }
}, {package:"eth-method-registry>@metamask/ethjs-query>@metamask/ethjs-format",file:"node_modules\\@metamask\\ethjs-format\\lib\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ethjs-query\\lib\\index.js", {"@metamask/ethjs-format":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ethjs-format\\lib\\index.js","@metamask/ethjs-rpc":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ethjs-rpc\\lib\\index.js","promise-to-callback":"D:\\code\\v\\metamask-extension\\node_modules\\promise-to-callback\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cethjs-query%5Clib%5Cindex.js
      return function (require, module, exports) {
"use strict";

var format = require('@metamask/ethjs-format');
var EthRPC = require('@metamask/ethjs-rpc');
var promiseToCallback = require('promise-to-callback');
module.exports = Eth;
function Eth(provider, options) {
  var self = this;
  var optionsObject = options || {};
  if (!(this instanceof Eth)) {
    throw new Error('[ethjs-query] the Eth object requires the "new" flag in order to function normally (i.e. `const eth = new Eth(provider);`).');
  }
  if (typeof provider !== 'object') {
    throw new Error("[ethjs-query] the Eth object requires that the first input 'provider' must be an object, got '" + typeof provider + "' (i.e. 'const eth = new Eth(provider);')");
  }
  self.options = Object.assign({
    debug: optionsObject.debug || false,
    logger: optionsObject.logger || console,
    jsonSpace: optionsObject.jsonSpace || 0
  });
  self.rpc = new EthRPC(provider);
  self.setProvider = self.rpc.setProvider;
}
Eth.prototype.log = function log(message) {
  var self = this;
  if (self.options.debug) self.options.logger.log("[ethjs-query log] " + message);
};
Object.keys(format.schema.methods).forEach(function (rpcMethodName) {
  Object.defineProperty(Eth.prototype, rpcMethodName.replace('eth_', ''), {
    enumerable: true,
    value: generateFnFor(rpcMethodName, format.schema.methods[rpcMethodName])
  });
});
function generateFnFor(rpcMethodName, methodObject) {
  return function outputMethod() {
    var callback = null; // eslint-disable-line
    var inputs = null; // eslint-disable-line
    var inputError = null; // eslint-disable-line
    var self = this;
    var args = [].slice.call(arguments); // eslint-disable-line
    var protoMethodName = rpcMethodName.replace('eth_', ''); // eslint-disable-line

    if (args.length > 0 && typeof args[args.length - 1] === 'function') {
      callback = args.pop();
    }
    var promise = performCall.call(this);

    // if callback provided, convert promise to callback
    if (callback) {
      return promiseToCallback(promise)(callback);
    }

    // only return promise if no callback provided
    return promise;
    function performCall() {
      var _this = this;
      return new Promise(function (resolve, reject) {
        // validate arg length
        if (args.length < methodObject[2]) {
          reject(new Error("[ethjs-query] method '" + protoMethodName + "' requires at least " + methodObject[2] + " input (format type " + methodObject[0][0] + "), " + args.length + " provided. For more information visit: https://github.com/ethereum/wiki/wiki/JSON-RPC#" + rpcMethodName.toLowerCase()));
          return;
        }
        if (args.length > methodObject[0].length) {
          reject(new Error("[ethjs-query] method '" + protoMethodName + "' requires at most " + methodObject[0].length + " params, " + args.length + " provided '" + JSON.stringify(args, null, self.options.jsonSpace) + "'. For more information visit: https://github.com/ethereum/wiki/wiki/JSON-RPC#" + rpcMethodName.toLowerCase()));
          return;
        }

        // set default block
        if (methodObject[3] && args.length < methodObject[3]) {
          args.push('latest');
        }

        // format inputs
        _this.log("attempting method formatting for '" + protoMethodName + "' with inputs " + JSON.stringify(args, null, _this.options.jsonSpace));
        try {
          inputs = format.formatInputs(rpcMethodName, args);
          _this.log("method formatting success for '" + protoMethodName + "' with formatted result: " + JSON.stringify(inputs, null, _this.options.jsonSpace));
        } catch (formattingError) {
          reject(new Error("[ethjs-query] while formatting inputs '" + JSON.stringify(args, null, _this.options.jsonSpace) + "' for method '" + protoMethodName + "' error: " + formattingError));
          return;
        }

        // perform rpc call
        _this.rpc.sendAsync({
          method: rpcMethodName,
          params: inputs
        }).then(function (result) {
          // format result
          _this.log("attempting method formatting for '" + protoMethodName + "' with raw outputs: " + JSON.stringify(result, null, _this.options.jsonSpace));
          var methodOutputs = format.formatOutputs(rpcMethodName, result);
          _this.log("method formatting success for '" + protoMethodName + "' formatted result: " + JSON.stringify(methodOutputs, null, _this.options.jsonSpace));
          resolve(methodOutputs);
        })["catch"](function (error) {
          reject(error);
        });
      });
    }
  };
}
      };
    };
  }
  }
}, {package:"eth-method-registry>@metamask/ethjs-query",file:"node_modules\\@metamask\\ethjs-query\\lib\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ethjs-rpc\\lib\\index.js", {"promise-to-callback":"D:\\code\\v\\metamask-extension\\node_modules\\promise-to-callback\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cethjs-rpc%5Clib%5Cindex.js
      return function (require, module, exports) {
"use strict";

var promiseToCallback = require('promise-to-callback');
module.exports = EthRPC;

/**
 * Constructs the EthRPC instance
 *
 * @method EthRPC
 * @param {Object} cprovider the eth rpc provider web3 standard..
 * @param {Object} options the options, if any
 * @returns {Object} ethrpc instance
 */
function EthRPC(cprovider, options) {
  var self = this;
  var optionsObject = options || {};
  if (!(this instanceof EthRPC)) {
    throw new Error('[ethjs-rpc] the EthRPC object requires the "new" flag in order to function normally (i.e. `const eth = new EthRPC(provider);`).');
  }
  self.options = Object.assign({
    jsonSpace: optionsObject.jsonSpace || 0,
    max: optionsObject.max || 9999999999999
  });
  self.idCounter = Math.floor(Math.random() * self.options.max);
  self.setProvider = function (provider) {
    if (typeof provider !== 'object') {
      throw new Error("[ethjs-rpc] the EthRPC object requires that the first input 'provider' must be an object, got '" + typeof provider + "' (i.e. 'const eth = new EthRPC(provider);')");
    }
    self.currentProvider = provider;
  };
  self.setProvider(cprovider);
}

/**
 * The main send async method
 *
 * @method sendAsync
 * @param {Object} payload the rpc payload object
 * @param {Function} cb the async standard callback
 * @callback {Object|Array|Boolean|String} vary result instance output
 */
EthRPC.prototype.sendAsync = function sendAsync(payload, callback) {
  var self = this;
  self.idCounter = self.idCounter % self.options.max;
  var parsedPayload = createPayload(payload, self.idCounter++);
  var promise = new Promise(function (resolve, reject) {
    self.currentProvider.sendAsync(parsedPayload, function (err, response) {
      var responseObject = response || {};
      if (err || responseObject.error) {
        var payloadErrorMessage = "[ethjs-rpc] " + (responseObject.error && 'rpc' || '') + " error with payload " + JSON.stringify(parsedPayload, null, self.options.jsonSpace) + " " + (err ? String(err) : JSON.stringify(responseObject.error, null, self.options.jsonSpace));
        var payloadError = new Error(payloadErrorMessage);
        payloadError.value = err || responseObject.error;
        reject(payloadError);
        return;
      }
      resolve(responseObject.result);
    });
  });
  if (callback) {
    // connect promise resolve handlers to callback
    return promiseToCallback(promise)(callback);
  }

  // only return promise if no callback specified
  return promise;
};

/**
 * A simple create payload method
 *
 * @method createPayload
 * @param {Object} data the rpc payload data
 * @param {String} id the rpc data payload ID
 * @returns {Object} payload the completed payload object
 */
function createPayload(data, id) {
  return Object.assign({}, {
    id: id,
    jsonrpc: '2.0',
    params: []
  }, data);
}
      };
    };
  }
  }
}, {package:"eth-method-registry>@metamask/ethjs-query>@metamask/ethjs-rpc",file:"node_modules\\@metamask\\ethjs-rpc\\lib\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ethjs-unit\\lib\\index.js", {"@metamask/number-to-bn":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\number-to-bn\\src\\index.js","bn.js":"D:\\code\\v\\metamask-extension\\node_modules\\bn.js\\lib\\bn.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cethjs-unit%5Clib%5Cindex.js
      return function (require, module, exports) {
"use strict";

/*
Primary Attribution
Richard Moore <ricmoo@me.com>
https://github.com/ethers-io

Note, Richard is a god of ether gods. Follow and respect him, and use Ethers.io!
*/

var BN = require('bn.js');
var numberToBN = require('@metamask/number-to-bn');
var zero = new BN(0);
var negative1 = new BN(-1);

// complete ethereum unit map
var unitMap = {
  'noether': '0',
  // eslint-disable-line
  'wei': '1',
  // eslint-disable-line
  'kwei': '1000',
  // eslint-disable-line
  'Kwei': '1000',
  // eslint-disable-line
  'babbage': '1000',
  // eslint-disable-line
  'femtoether': '1000',
  // eslint-disable-line
  'mwei': '1000000',
  // eslint-disable-line
  'Mwei': '1000000',
  // eslint-disable-line
  'lovelace': '1000000',
  // eslint-disable-line
  'picoether': '1000000',
  // eslint-disable-line
  'gwei': '1000000000',
  // eslint-disable-line
  'Gwei': '1000000000',
  // eslint-disable-line
  'shannon': '1000000000',
  // eslint-disable-line
  'nanoether': '1000000000',
  // eslint-disable-line
  'nano': '1000000000',
  // eslint-disable-line
  'szabo': '1000000000000',
  // eslint-disable-line
  'microether': '1000000000000',
  // eslint-disable-line
  'micro': '1000000000000',
  // eslint-disable-line
  'finney': '1000000000000000',
  // eslint-disable-line
  'milliether': '1000000000000000',
  // eslint-disable-line
  'milli': '1000000000000000',
  // eslint-disable-line
  'ether': '1000000000000000000',
  // eslint-disable-line
  'kether': '1000000000000000000000',
  // eslint-disable-line
  'grand': '1000000000000000000000',
  // eslint-disable-line
  'mether': '1000000000000000000000000',
  // eslint-disable-line
  'gether': '1000000000000000000000000000',
  // eslint-disable-line
  'tether': '1000000000000000000000000000000' // eslint-disable-line
};

/**
 * Returns value of unit in Wei
 *
 * @method getValueOfUnit
 * @param {String} unit the unit to convert to, default ether
 * @returns {BigNumber} value of the unit (in Wei)
 * @throws error if the unit is not correct:w
 */
function getValueOfUnit(unitInput) {
  var unit = unitInput ? unitInput.toLowerCase() : 'ether';
  var unitValue = unitMap[unit]; // eslint-disable-line

  if (typeof unitValue !== 'string') {
    throw new Error("[ethjs-unit] the unit provided " + unitInput + " doesn't exists, please use the one of the following units " + JSON.stringify(unitMap, null, 2));
  }
  return new BN(unitValue, 10);
}
function numberToString(arg) {
  if (typeof arg === 'string') {
    if (!arg.match(/^-?[0-9.]+$/)) {
      throw new Error("while converting number to string, invalid number value '" + arg + "', should be a number matching (^-?[0-9.]+).");
    }
    return arg;
  }
  if (typeof arg === 'number') {
    return String(arg);
  }
  if (typeof arg === 'object' && arg.toString && (arg.toTwos || arg.dividedToIntegerBy)) {
    if (arg.toPrecision) {
      return String(arg.toPrecision());
    }
    return arg.toString(10);
  }
  throw new Error("while converting number to string, invalid number value '" + arg + "' type " + typeof arg + ".");
}
function fromWei(weiInput, unit, optionsInput) {
  var wei = numberToBN(weiInput); // eslint-disable-line
  var negative = wei.lt(zero); // eslint-disable-line
  var base = getValueOfUnit(unit);
  var baseLength = unitMap[unit].length - 1 || 1;
  var options = optionsInput || {};
  if (negative) {
    wei = wei.mul(negative1);
  }
  var fraction = wei.mod(base).toString(10); // eslint-disable-line

  while (fraction.length < baseLength) {
    fraction = "0" + fraction;
  }
  if (!options.pad) {
    fraction = fraction.match(/^([0-9]*[1-9]|0)(0*)/)[1]; // eslint-disable-line prefer-destructuring
  }

  var whole = wei.div(base).toString(10); // eslint-disable-line

  if (options.commify) {
    whole = whole.replace(/\B(?=(\d{3})+(?!\d))/g, ',');
  }
  var value = "" + whole + (fraction == '0' ? '' : "." + fraction); // eslint-disable-line

  if (negative) {
    value = "-" + value;
  }
  return value;
}
function toWei(etherInput, unit) {
  var ether = numberToString(etherInput); // eslint-disable-line
  var base = getValueOfUnit(unit);
  var baseLength = unitMap[unit].length - 1 || 1;

  // Is it negative?
  var negative = ether.substring(0, 1) === '-'; // eslint-disable-line
  if (negative) {
    ether = ether.substring(1);
  }
  if (ether === '.') {
    throw new Error("[ethjs-unit] while converting number " + etherInput + " to wei, invalid value");
  }

  // Split it into a whole and fractional part
  var comps = ether.split('.'); // eslint-disable-line
  if (comps.length > 2) {
    throw new Error("[ethjs-unit] while converting number " + etherInput + " to wei,  too many decimal points");
  }
  var whole = comps[0],
    fraction = comps[1]; // eslint-disable-line

  if (!whole) {
    whole = '0';
  }
  if (!fraction) {
    fraction = '0';
  }
  if (fraction.length > baseLength) {
    throw new Error("[ethjs-unit] while converting number " + etherInput + " to wei, too many decimal places");
  }
  while (fraction.length < baseLength) {
    fraction += '0';
  }
  whole = new BN(whole);
  fraction = new BN(fraction);
  var wei = whole.mul(base).add(fraction); // eslint-disable-line

  if (negative) {
    wei = wei.mul(negative1);
  }
  return new BN(wei.toString(10), 10);
}
module.exports = {
  unitMap: unitMap,
  numberToString: numberToString,
  getValueOfUnit: getValueOfUnit,
  fromWei: fromWei,
  toWei: toWei
};
      };
    };
  }
  }
}, {package:"@metamask/controller-utils>@metamask/ethjs-unit",file:"node_modules\\@metamask\\ethjs-unit\\lib\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\ethjs-util\\lib\\index.js", {"buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js","is-hex-prefixed":"D:\\code\\v\\metamask-extension\\node_modules\\is-hex-prefixed\\src\\index.js","strip-hex-prefix":"D:\\code\\v\\metamask-extension\\node_modules\\strip-hex-prefix\\src\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cethjs-util%5Clib%5Cindex.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";

var isHexPrefixed = require('is-hex-prefixed');
var stripHexPrefix = require('strip-hex-prefix');

/**
 * Pads a `String` to have an even length
 * @param {String} value
 * @return {String} output
 */
function padToEven(value) {
  var a = value; // eslint-disable-line

  if (typeof a !== 'string') {
    throw new Error("[ethjs-util] while padding to even, value must be string, is currently " + typeof a + ", while padToEven.");
  }
  if (a.length % 2) {
    a = "0" + a;
  }
  return a;
}

/**
 * Converts a `Number` into a hex `String`
 * @param {Number} i
 * @return {String}
 */
function intToHex(i) {
  var hex = i.toString(16); // eslint-disable-line

  return "0x" + hex;
}

/**
 * Converts an `Number` to a `Buffer`
 * @param {Number} i
 * @return {Buffer}
 */
function intToBuffer(i) {
  var hex = intToHex(i);
  return Buffer.from(padToEven(hex.slice(2)), 'hex');
}

/**
 * Get the binary size of a string
 * @param {String} str
 * @return {Number}
 */
function getBinarySize(str) {
  if (typeof str !== 'string') {
    throw new Error("[ethjs-util] while getting binary size, method getBinarySize requires input 'str' to be type String, got '" + typeof str + "'.");
  }
  return Buffer.byteLength(str, 'utf8');
}

/**
 * Returns TRUE if the first specified array contains all elements
 * from the second one. FALSE otherwise.
 *
 * @param {array} superset
 * @param {array} subset
 *
 * @returns {boolean}
 */
function arrayContainsArray(superset, subset, some) {
  if (Array.isArray(superset) !== true) {
    throw new Error("[ethjs-util] method arrayContainsArray requires input 'superset' to be an array got type '" + typeof superset + "'");
  }
  if (Array.isArray(subset) !== true) {
    throw new Error("[ethjs-util] method arrayContainsArray requires input 'subset' to be an array got type '" + typeof subset + "'");
  }
  return subset[Boolean(some) && 'some' || 'every'](function (value) {
    return superset.indexOf(value) >= 0;
  });
}

/**
 * Should be called to get utf8 from it's hex representation
 *
 * @method toUtf8
 * @param {String} string in hex
 * @returns {String} ascii string representation of hex value
 */
function toUtf8(hex) {
  var bufferValue = Buffer.from(padToEven(stripHexPrefix(hex).replace(/^0+|0+$/g, '')), 'hex');
  return bufferValue.toString('utf8');
}

/**
 * Should be called to get ascii from it's hex representation
 *
 * @method toAscii
 * @param {String} string in hex
 * @returns {String} ascii string representation of hex value
 */
function toAscii(hex) {
  var str = ''; // eslint-disable-line
  var i = 0,
    l = hex.length; // eslint-disable-line

  if (hex.substring(0, 2) === '0x') {
    i = 2;
  }
  for (; i < l; i += 2) {
    var code = parseInt(hex.substr(i, 2), 16);
    str += String.fromCharCode(code);
  }
  return str;
}

/**
 * Should be called to get hex representation (prefixed by 0x) of utf8 string
 *
 * @method fromUtf8
 * @param {String} string
 * @param {Number} optional padding
 * @returns {String} hex representation of input string
 */
function fromUtf8(stringValue) {
  var str = Buffer.from(stringValue, 'utf8');
  return "0x" + padToEven(str.toString('hex')).replace(/^0+|0+$/g, '');
}

/**
 * Should be called to get hex representation (prefixed by 0x) of ascii string
 *
 * @method fromAscii
 * @param {String} string
 * @param {Number} optional padding
 * @returns {String} hex representation of input string
 */
function fromAscii(stringValue) {
  var hex = ''; // eslint-disable-line
  for (var i = 0; i < stringValue.length; i++) {
    // eslint-disable-line
    var code = stringValue.charCodeAt(i);
    var n = code.toString(16);
    hex += n.length < 2 ? "0" + n : n;
  }
  return "0x" + hex;
}

/**
 * getKeys([{a: 1, b: 2}, {a: 3, b: 4}], 'a') => [1, 3]
 *
 * @method getKeys get specific key from inner object array of objects
 * @param {String} params
 * @param {String} key
 * @param {Boolean} allowEmpty
 * @returns {Array} output just a simple array of output keys
 */
function getKeys(params, key, allowEmpty) {
  if (!Array.isArray(params)) {
    throw new Error("[ethjs-util] method getKeys expecting type Array as 'params' input, got '" + typeof params + "'");
  }
  if (typeof key !== 'string') {
    throw new Error("[ethjs-util] method getKeys expecting type String for input 'key' got '" + typeof key + "'.");
  }
  var result = []; // eslint-disable-line

  for (var i = 0; i < params.length; i++) {
    // eslint-disable-line
    var value = params[i][key]; // eslint-disable-line
    if (allowEmpty && !value) {
      value = '';
    } else if (typeof value !== 'string') {
      throw new Error('invalid abi');
    }
    result.push(value);
  }
  return result;
}

/**
 * Is the string a hex string.
 *
 * @method check if string is hex string of specific length
 * @param {String} value
 * @param {Number} length
 * @returns {Boolean} output the string is a hex string
 */
function isHexString(value, length) {
  if (typeof value !== 'string' || !value.match(/^0x[0-9A-Fa-f]*$/)) {
    return false;
  }
  if (length && value.length !== 2 + 2 * length) {
    return false;
  }
  return true;
}
module.exports = {
  arrayContainsArray: arrayContainsArray,
  intToBuffer: intToBuffer,
  getBinarySize: getBinarySize,
  isHexPrefixed: isHexPrefixed,
  stripHexPrefix: stripHexPrefix,
  padToEven: padToEven,
  intToHex: intToHex,
  fromAscii: fromAscii,
  fromUtf8: fromUtf8,
  toAscii: toAscii,
  toUtf8: toUtf8,
  getKeys: getKeys,
  isHexString: isHexString
};
}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"eth-method-registry>@metamask/ethjs-contract>@metamask/ethjs-util",file:"node_modules\\@metamask\\ethjs-util\\lib\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gas-fee-controller\\dist\\GasFeeController.cjs", {"./determineGasFeeCalculations.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gas-fee-controller\\dist\\determineGasFeeCalculations.cjs","./gas-util.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gas-fee-controller\\dist\\gas-util.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/eth-query":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-query\\index.js","@metamask/polling-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\polling-controller\\dist\\index.cjs","uuid":"D:\\code\\v\\metamask-extension\\node_modules\\uuid\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cgas-fee-controller%5Cdist%5CGasFeeController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _GasFeeController_instances, _GasFeeController_getProvider, _GasFeeController_onNetworkControllerDidChange;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GasFeeController = exports.GAS_ESTIMATE_TYPES = exports.LEGACY_GAS_PRICES_API_URL = void 0;
const controller_utils_1 = require("@metamask/controller-utils");
const eth_query_1 = __importDefault(require("@metamask/eth-query"));
const polling_controller_1 = require("@metamask/polling-controller");
const uuid_1 = require("uuid");
const determineGasFeeCalculations_1 = __importDefault(require("./determineGasFeeCalculations.cjs"));
const gas_util_1 = require("./gas-util.cjs");
exports.LEGACY_GAS_PRICES_API_URL = `https://api.metaswap.codefi.network/gasPrices`;
/**
 * Indicates which type of gasEstimate the controller is currently returning.
 * This is useful as a way of asserting that the shape of gasEstimates matches
 * expectations. NONE is a special case indicating that no previous gasEstimate
 * has been fetched.
 */
exports.GAS_ESTIMATE_TYPES = {
    FEE_MARKET: 'fee-market',
    LEGACY: 'legacy',
    ETH_GASPRICE: 'eth_gasPrice',
    NONE: 'none',
};
const metadata = {
    gasFeeEstimatesByChainId: {
        includeInStateLogs: true,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
    gasFeeEstimates: {
        includeInStateLogs: true,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
    estimatedGasFeeTimeBounds: {
        includeInStateLogs: true,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
    gasEstimateType: {
        includeInStateLogs: true,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
    nonRPCGasFeeApisDisabled: {
        includeInStateLogs: true,
        persist: true,
        anonymous: false,
        usedInUi: false,
    },
};
const name = 'GasFeeController';
const defaultState = {
    gasFeeEstimatesByChainId: {},
    gasFeeEstimates: {},
    estimatedGasFeeTimeBounds: {},
    gasEstimateType: exports.GAS_ESTIMATE_TYPES.NONE,
    nonRPCGasFeeApisDisabled: false,
};
/**
 * Controller that retrieves gas fee estimate data and polls for updated data on a set interval
 */
class GasFeeController extends (0, polling_controller_1.StaticIntervalPollingController)() {
    /**
     * Creates a GasFeeController instance.
     *
     * @param options - The controller options.
     * @param options.interval - The time in milliseconds to wait between polls.
     * @param options.messenger - The controller messenger.
     * @param options.state - The initial state.
     * @param options.getCurrentNetworkEIP1559Compatibility - Determines whether or not the current
     * network is EIP-1559 compatible.
     * @param options.getCurrentNetworkLegacyGasAPICompatibility - Determines whether or not the
     * current network is compatible with the legacy gas price API.
     * @param options.getCurrentAccountEIP1559Compatibility - Determines whether or not the current
     * account is EIP-1559 compatible.
     * @param options.getChainId - Returns the current chain ID.
     * @param options.getProvider - Returns a network provider for the current network.
     * @param options.onNetworkDidChange - A function for registering an event handler for the
     * network state change event.
     * @param options.legacyAPIEndpoint - The legacy gas price API URL. This option is primarily for
     * testing purposes.
     * @param options.EIP1559APIEndpoint - The EIP-1559 gas price API URL.
     * @param options.clientId - The client ID used to identify to the gas estimation API who is
     * asking for estimates.
     */
    constructor({ interval = 15000, messenger, state, getCurrentNetworkEIP1559Compatibility, getCurrentAccountEIP1559Compatibility, getChainId, getCurrentNetworkLegacyGasAPICompatibility, getProvider, onNetworkDidChange, legacyAPIEndpoint = exports.LEGACY_GAS_PRICES_API_URL, EIP1559APIEndpoint, clientId, }) {
        super({
            name,
            metadata,
            messenger,
            state: { ...defaultState, ...state },
        });
        _GasFeeController_instances.add(this);
        _GasFeeController_getProvider.set(this, void 0);
        this.intervalDelay = interval;
        this.setIntervalLength(interval);
        this.pollTokens = new Set();
        this.getCurrentNetworkEIP1559Compatibility =
            getCurrentNetworkEIP1559Compatibility;
        this.getCurrentNetworkLegacyGasAPICompatibility =
            getCurrentNetworkLegacyGasAPICompatibility;
        this.getCurrentAccountEIP1559Compatibility =
            getCurrentAccountEIP1559Compatibility;
        __classPrivateFieldSet(this, _GasFeeController_getProvider, getProvider, "f");
        this.EIP1559APIEndpoint = EIP1559APIEndpoint;
        this.legacyAPIEndpoint = legacyAPIEndpoint;
        this.clientId = clientId;
        this.ethQuery = new eth_query_1.default(__classPrivateFieldGet(this, _GasFeeController_getProvider, "f").call(this));
        if (onNetworkDidChange && getChainId) {
            this.currentChainId = getChainId();
            // TODO: Either fix this lint violation or explain why it's necessary to ignore.
            // eslint-disable-next-line @typescript-eslint/no-misused-promises
            onNetworkDidChange(async (networkControllerState) => {
                await __classPrivateFieldGet(this, _GasFeeController_instances, "m", _GasFeeController_onNetworkControllerDidChange).call(this, networkControllerState);
            });
        }
        else {
            const { selectedNetworkClientId } = this.messagingSystem.call('NetworkController:getState');
            this.currentChainId = this.messagingSystem.call('NetworkController:getNetworkClientById', selectedNetworkClientId).configuration.chainId;
            this.messagingSystem.subscribe('NetworkController:networkDidChange', 
            // TODO: Either fix this lint violation or explain why it's necessary to ignore.
            // eslint-disable-next-line @typescript-eslint/no-misused-promises
            async (networkControllerState) => {
                await __classPrivateFieldGet(this, _GasFeeController_instances, "m", _GasFeeController_onNetworkControllerDidChange).call(this, networkControllerState);
            });
        }
    }
    async resetPolling() {
        if (this.pollTokens.size !== 0) {
            const tokens = Array.from(this.pollTokens);
            this.stopPolling();
            await this.getGasFeeEstimatesAndStartPolling(tokens[0]);
            tokens.slice(1).forEach((token) => {
                this.pollTokens.add(token);
            });
        }
    }
    async fetchGasFeeEstimates(options) {
        return await this._fetchGasFeeEstimateData(options);
    }
    async getGasFeeEstimatesAndStartPolling(pollToken) {
        const _pollToken = pollToken || (0, uuid_1.v1)();
        this.pollTokens.add(_pollToken);
        if (this.pollTokens.size === 1) {
            await this._fetchGasFeeEstimateData();
            this._poll();
        }
        return _pollToken;
    }
    /**
     * Gets and sets gasFeeEstimates in state.
     *
     * @param options - The gas fee estimate options.
     * @param options.shouldUpdateState - Determines whether the state should be updated with the
     * updated gas estimates.
     * @returns The gas fee estimates.
     */
    async _fetchGasFeeEstimateData(options = {}) {
        const { shouldUpdateState = true, networkClientId } = options;
        let ethQuery, isEIP1559Compatible, isLegacyGasAPICompatible, decimalChainId;
        if (networkClientId !== undefined) {
            const networkClient = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId);
            isLegacyGasAPICompatible = networkClient.configuration.chainId === '0x38';
            decimalChainId = (0, controller_utils_1.convertHexToDecimal)(networkClient.configuration.chainId);
            try {
                const result = await this.messagingSystem.call('NetworkController:getEIP1559Compatibility', networkClientId);
                isEIP1559Compatible = result || false;
            }
            catch {
                isEIP1559Compatible = false;
            }
            ethQuery = new eth_query_1.default(networkClient.provider);
        }
        ethQuery ?? (ethQuery = this.ethQuery);
        isLegacyGasAPICompatible ?? (isLegacyGasAPICompatible = this.getCurrentNetworkLegacyGasAPICompatibility());
        decimalChainId ?? (decimalChainId = (0, controller_utils_1.convertHexToDecimal)(this.currentChainId));
        try {
            isEIP1559Compatible ?? (isEIP1559Compatible = await this.getEIP1559Compatibility());
        }
        catch (e) {
            console.error(e);
            isEIP1559Compatible ?? (isEIP1559Compatible = false);
        }
        const gasFeeCalculations = await (0, determineGasFeeCalculations_1.default)({
            isEIP1559Compatible,
            isLegacyGasAPICompatible,
            fetchGasEstimates: gas_util_1.fetchGasEstimates,
            fetchGasEstimatesUrl: this.EIP1559APIEndpoint.replace('<chain_id>', `${decimalChainId}`),
            fetchLegacyGasPriceEstimates: gas_util_1.fetchLegacyGasPriceEstimates,
            fetchLegacyGasPriceEstimatesUrl: this.legacyAPIEndpoint.replace('<chain_id>', `${decimalChainId}`),
            fetchEthGasPriceEstimate: gas_util_1.fetchEthGasPriceEstimate,
            calculateTimeEstimate: gas_util_1.calculateTimeEstimate,
            clientId: this.clientId,
            ethQuery,
            nonRPCGasFeeApisDisabled: this.state.nonRPCGasFeeApisDisabled,
        });
        if (shouldUpdateState) {
            const chainId = (0, controller_utils_1.toHex)(decimalChainId);
            this.update((state) => {
                if (this.currentChainId === chainId) {
                    state.gasFeeEstimates = gasFeeCalculations.gasFeeEstimates;
                    state.estimatedGasFeeTimeBounds =
                        gasFeeCalculations.estimatedGasFeeTimeBounds;
                    state.gasEstimateType = gasFeeCalculations.gasEstimateType;
                }
                state.gasFeeEstimatesByChainId ?? (state.gasFeeEstimatesByChainId = {});
                state.gasFeeEstimatesByChainId[chainId] = {
                    gasFeeEstimates: gasFeeCalculations.gasFeeEstimates,
                    estimatedGasFeeTimeBounds: gasFeeCalculations.estimatedGasFeeTimeBounds,
                    gasEstimateType: gasFeeCalculations.gasEstimateType,
                };
            });
        }
        return gasFeeCalculations;
    }
    /**
     * Remove the poll token, and stop polling if the set of poll tokens is empty.
     *
     * @param pollToken - The poll token to disconnect.
     */
    disconnectPoller(pollToken) {
        this.pollTokens.delete(pollToken);
        if (this.pollTokens.size === 0) {
            this.stopPolling();
        }
    }
    stopPolling() {
        if (this.intervalId) {
            clearInterval(this.intervalId);
        }
        this.pollTokens.clear();
        this.resetState();
    }
    /**
     * Prepare to discard this controller.
     *
     * This stops any active polling.
     */
    destroy() {
        super.destroy();
        this.stopPolling();
    }
    _poll() {
        if (this.intervalId) {
            clearInterval(this.intervalId);
        }
        // TODO: Either fix this lint violation or explain why it's necessary to ignore.
        // eslint-disable-next-line @typescript-eslint/no-misused-promises
        this.intervalId = setInterval(async () => {
            await (0, controller_utils_1.safelyExecute)(() => this._fetchGasFeeEstimateData());
        }, this.intervalDelay);
    }
    /**
     * Fetching token list from the Token Service API.
     *
     * @private
     * @param input - The input for the poll.
     * @param input.networkClientId - The ID of the network client triggering the fetch.
     * @returns A promise that resolves when this operation completes.
     */
    async _executePoll({ networkClientId }) {
        await this._fetchGasFeeEstimateData({ networkClientId });
    }
    resetState() {
        this.update(() => {
            return defaultState;
        });
    }
    async getEIP1559Compatibility() {
        const currentNetworkIsEIP1559Compatible = await this.getCurrentNetworkEIP1559Compatibility();
        const currentAccountIsEIP1559Compatible = this.getCurrentAccountEIP1559Compatibility?.() ?? true;
        return (currentNetworkIsEIP1559Compatible && currentAccountIsEIP1559Compatible);
    }
    getTimeEstimate(maxPriorityFeePerGas, maxFeePerGas) {
        if (!this.state.gasFeeEstimates ||
            this.state.gasEstimateType !== exports.GAS_ESTIMATE_TYPES.FEE_MARKET) {
            return {};
        }
        return (0, gas_util_1.calculateTimeEstimate)(maxPriorityFeePerGas, maxFeePerGas, this.state.gasFeeEstimates);
    }
    enableNonRPCGasFeeApis() {
        this.update((state) => {
            state.nonRPCGasFeeApisDisabled = false;
        });
    }
    disableNonRPCGasFeeApis() {
        this.update((state) => {
            state.nonRPCGasFeeApisDisabled = true;
        });
    }
}
exports.GasFeeController = GasFeeController;
_GasFeeController_getProvider = new WeakMap(), _GasFeeController_instances = new WeakSet(), _GasFeeController_onNetworkControllerDidChange = async function _GasFeeController_onNetworkControllerDidChange({ selectedNetworkClientId, }) {
    const newChainId = this.messagingSystem.call('NetworkController:getNetworkClientById', selectedNetworkClientId).configuration.chainId;
    if (newChainId !== this.currentChainId) {
        this.ethQuery = new eth_query_1.default(__classPrivateFieldGet(this, _GasFeeController_getProvider, "f").call(this));
        await this.resetPolling();
        this.currentChainId = newChainId;
    }
};
exports.default = GasFeeController;

      };
    };
  }
  }
}, {package:"@metamask/gas-fee-controller",file:"node_modules\\@metamask\\gas-fee-controller\\dist\\GasFeeController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gas-fee-controller\\dist\\determineGasFeeCalculations.cjs", {"./GasFeeController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gas-fee-controller\\dist\\GasFeeController.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cgas-fee-controller%5Cdist%5CdetermineGasFeeCalculations.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const GasFeeController_1 = require("./GasFeeController.cjs");
/**
 * Obtains a set of max base and priority fee estimates along with time estimates so that we
 * can present them to users when they are sending transactions or making swaps.
 *
 * @param args - The arguments.
 * @param args.isEIP1559Compatible - Governs whether or not we can use an EIP-1559-only method to
 * produce estimates.
 * @param args.isLegacyGasAPICompatible - Governs whether or not we can use a non-EIP-1559 method to
 * produce estimates (for instance, testnets do not support estimates altogether).
 * @param args.fetchGasEstimates - A function that fetches gas estimates using an EIP-1559-specific
 * API.
 * @param args.fetchGasEstimatesUrl - The URL for the API we can use to obtain EIP-1559-specific
 * estimates.
 * @param args.fetchLegacyGasPriceEstimates - A function that fetches gas estimates using an
 * non-EIP-1559-specific API.
 * @param args.fetchLegacyGasPriceEstimatesUrl - The URL for the API we can use to obtain
 * non-EIP-1559-specific estimates.
 * @param args.fetchEthGasPriceEstimate - A function that fetches gas estimates using
 * `eth_gasPrice`.
 * @param args.calculateTimeEstimate - A function that determine time estimate bounds.
 * @param args.clientId - An identifier that an API can use to know who is asking for estimates.
 * @param args.ethQuery - An EthQuery instance we can use to talk to Ethereum directly.
 * @param args.nonRPCGasFeeApisDisabled - Whether to disable requests to the legacyAPIEndpoint and the EIP1559APIEndpoint
 * @returns The gas fee calculations.
 */
async function determineGasFeeCalculations(args) {
    try {
        return await getEstimatesUsingFallbacks(args);
    }
    catch (error) {
        if (error instanceof Error) {
            throw new Error(`Gas fee/price estimation failed. Message: ${error.message}`);
        }
        throw error;
    }
}
exports.default = determineGasFeeCalculations;
/**
 * Retrieve the gas fee estimates using a series of fallback mechanisms.
 * @param request - The request object.
 * @returns The gas fee estimates.
 */
async function getEstimatesUsingFallbacks(request) {
    const { isEIP1559Compatible, isLegacyGasAPICompatible, nonRPCGasFeeApisDisabled, } = request;
    try {
        if (isEIP1559Compatible && !nonRPCGasFeeApisDisabled) {
            return await getEstimatesUsingFeeMarketEndpoint(request);
        }
        if (isLegacyGasAPICompatible && !nonRPCGasFeeApisDisabled) {
            return await getEstimatesUsingLegacyEndpoint(request);
        }
        throw new Error('Main gas fee/price estimation failed. Use fallback');
    }
    catch {
        return await getEstimatesUsingProvider(request);
    }
}
/**
 * Retrieve gas fee estimates using the EIP-1559 endpoint of the gas API.
 * @param request - The request object.
 * @returns The gas fee estimates.
 */
async function getEstimatesUsingFeeMarketEndpoint(request) {
    const { fetchGasEstimates, fetchGasEstimatesUrl, clientId, calculateTimeEstimate, } = request;
    const estimates = await fetchGasEstimates(fetchGasEstimatesUrl, clientId);
    const { suggestedMaxPriorityFeePerGas, suggestedMaxFeePerGas } = estimates.medium;
    const estimatedGasFeeTimeBounds = calculateTimeEstimate(suggestedMaxPriorityFeePerGas, suggestedMaxFeePerGas, estimates);
    return {
        gasFeeEstimates: estimates,
        estimatedGasFeeTimeBounds,
        gasEstimateType: GasFeeController_1.GAS_ESTIMATE_TYPES.FEE_MARKET,
    };
}
/**
 * Retrieve gas fee estimates using the legacy endpoint of the gas API.
 * @param request - The request object.
 * @returns The gas fee estimates.
 */
async function getEstimatesUsingLegacyEndpoint(request) {
    const { fetchLegacyGasPriceEstimates, fetchLegacyGasPriceEstimatesUrl, clientId, } = request;
    const estimates = await fetchLegacyGasPriceEstimates(fetchLegacyGasPriceEstimatesUrl, clientId);
    return {
        gasFeeEstimates: estimates,
        estimatedGasFeeTimeBounds: {},
        gasEstimateType: GasFeeController_1.GAS_ESTIMATE_TYPES.LEGACY,
    };
}
/**
 * Retrieve gas fee estimates using an `eth_gasPrice` call to the RPC provider.
 * @param request - The request object.
 * @returns The gas fee estimates.
 */
async function getEstimatesUsingProvider(request) {
    const { ethQuery, fetchEthGasPriceEstimate } = request;
    const estimates = await fetchEthGasPriceEstimate(ethQuery);
    return {
        gasFeeEstimates: estimates,
        estimatedGasFeeTimeBounds: {},
        gasEstimateType: GasFeeController_1.GAS_ESTIMATE_TYPES.ETH_GASPRICE,
    };
}

      };
    };
  }
  }
}, {package:"@metamask/gas-fee-controller",file:"node_modules\\@metamask\\gas-fee-controller\\dist\\determineGasFeeCalculations.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gas-fee-controller\\dist\\gas-util.cjs", {"@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","bn.js":"D:\\code\\v\\metamask-extension\\node_modules\\bn.js\\lib\\bn.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cgas-fee-controller%5Cdist%5Cgas-util.cjs
      return function (require, module, exports) {
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.calculateTimeEstimate = exports.fetchEthGasPriceEstimate = exports.fetchLegacyGasPriceEstimates = exports.fetchGasEstimates = exports.normalizeGWEIDecimalNumbers = void 0;
const controller_utils_1 = require("@metamask/controller-utils");
const bn_js_1 = __importDefault(require("bn.js"));
const makeClientIdHeader = (clientId) => ({ 'X-Client-Id': clientId });
/**
 * Convert a decimal GWEI value to a decimal string rounded to the nearest WEI.
 *
 * @param n - The input GWEI amount, as a decimal string or a number.
 * @returns The decimal string GWEI amount.
 */
function normalizeGWEIDecimalNumbers(n) {
    const numberAsWEIHex = (0, controller_utils_1.gweiDecToWEIBN)(n).toString(16);
    const numberAsGWEI = (0, controller_utils_1.weiHexToGweiDec)(numberAsWEIHex);
    return numberAsGWEI;
}
exports.normalizeGWEIDecimalNumbers = normalizeGWEIDecimalNumbers;
/**
 * Fetch gas estimates from the given URL.
 *
 * @param url - The gas estimate URL.
 * @param clientId - The client ID used to identify to the API who is asking for estimates.
 * @returns The gas estimates.
 */
async function fetchGasEstimates(url, clientId) {
    const estimates = await (0, controller_utils_1.handleFetch)(url, clientId ? { headers: makeClientIdHeader(clientId) } : undefined);
    return {
        low: {
            ...estimates.low,
            suggestedMaxPriorityFeePerGas: normalizeGWEIDecimalNumbers(estimates.low.suggestedMaxPriorityFeePerGas),
            suggestedMaxFeePerGas: normalizeGWEIDecimalNumbers(estimates.low.suggestedMaxFeePerGas),
        },
        medium: {
            ...estimates.medium,
            suggestedMaxPriorityFeePerGas: normalizeGWEIDecimalNumbers(estimates.medium.suggestedMaxPriorityFeePerGas),
            suggestedMaxFeePerGas: normalizeGWEIDecimalNumbers(estimates.medium.suggestedMaxFeePerGas),
        },
        high: {
            ...estimates.high,
            suggestedMaxPriorityFeePerGas: normalizeGWEIDecimalNumbers(estimates.high.suggestedMaxPriorityFeePerGas),
            suggestedMaxFeePerGas: normalizeGWEIDecimalNumbers(estimates.high.suggestedMaxFeePerGas),
        },
        estimatedBaseFee: normalizeGWEIDecimalNumbers(estimates.estimatedBaseFee),
        historicalBaseFeeRange: estimates.historicalBaseFeeRange,
        baseFeeTrend: estimates.baseFeeTrend,
        latestPriorityFeeRange: estimates.latestPriorityFeeRange,
        historicalPriorityFeeRange: estimates.historicalPriorityFeeRange,
        priorityFeeTrend: estimates.priorityFeeTrend,
        networkCongestion: estimates.networkCongestion,
    };
}
exports.fetchGasEstimates = fetchGasEstimates;
/**
 * Hit the legacy MetaSwaps gasPrices estimate api and return the low, medium
 * high values from that API.
 *
 * @param url - The URL to fetch gas price estimates from.
 * @param clientId - The client ID used to identify to the API who is asking for estimates.
 * @returns The gas price estimates.
 */
async function fetchLegacyGasPriceEstimates(url, clientId) {
    const result = await (0, controller_utils_1.handleFetch)(url, {
        referrer: url,
        referrerPolicy: 'no-referrer-when-downgrade',
        method: 'GET',
        mode: 'cors',
        headers: {
            'Content-Type': 'application/json',
            ...(clientId && makeClientIdHeader(clientId)),
        },
    });
    return {
        low: result.SafeGasPrice,
        medium: result.ProposeGasPrice,
        high: result.FastGasPrice,
    };
}
exports.fetchLegacyGasPriceEstimates = fetchLegacyGasPriceEstimates;
/**
 * Get a gas price estimate from the network using the `eth_gasPrice` method.
 *
 * @param ethQuery - The EthQuery instance to call the network with.
 * @returns A gas price estimate.
 */
async function fetchEthGasPriceEstimate(ethQuery) {
    const gasPrice = await (0, controller_utils_1.query)(ethQuery, 'gasPrice');
    return {
        gasPrice: (0, controller_utils_1.weiHexToGweiDec)(gasPrice).toString(),
    };
}
exports.fetchEthGasPriceEstimate = fetchEthGasPriceEstimate;
/**
 * Estimate the time it will take for a transaction to be confirmed.
 *
 * @param maxPriorityFeePerGas - The max priority fee per gas.
 * @param maxFeePerGas - The max fee per gas.
 * @param gasFeeEstimates - The gas fee estimates.
 * @returns The estimated lower and upper bounds for when this transaction will be confirmed.
 */
function calculateTimeEstimate(maxPriorityFeePerGas, maxFeePerGas, gasFeeEstimates) {
    const { low, medium, high, estimatedBaseFee } = gasFeeEstimates;
    const maxPriorityFeePerGasInWEI = (0, controller_utils_1.gweiDecToWEIBN)(maxPriorityFeePerGas);
    const maxFeePerGasInWEI = (0, controller_utils_1.gweiDecToWEIBN)(maxFeePerGas);
    const estimatedBaseFeeInWEI = (0, controller_utils_1.gweiDecToWEIBN)(estimatedBaseFee);
    const effectiveMaxPriorityFee = bn_js_1.default.min(maxPriorityFeePerGasInWEI, maxFeePerGasInWEI.sub(estimatedBaseFeeInWEI));
    const lowMaxPriorityFeeInWEI = (0, controller_utils_1.gweiDecToWEIBN)(low.suggestedMaxPriorityFeePerGas);
    const mediumMaxPriorityFeeInWEI = (0, controller_utils_1.gweiDecToWEIBN)(medium.suggestedMaxPriorityFeePerGas);
    const highMaxPriorityFeeInWEI = (0, controller_utils_1.gweiDecToWEIBN)(high.suggestedMaxPriorityFeePerGas);
    let lowerTimeBound;
    let upperTimeBound;
    if (effectiveMaxPriorityFee.lt(lowMaxPriorityFeeInWEI)) {
        lowerTimeBound = null;
        upperTimeBound = 'unknown';
    }
    else if (effectiveMaxPriorityFee.gte(lowMaxPriorityFeeInWEI) &&
        effectiveMaxPriorityFee.lt(mediumMaxPriorityFeeInWEI)) {
        lowerTimeBound = low.minWaitTimeEstimate;
        upperTimeBound = low.maxWaitTimeEstimate;
    }
    else if (effectiveMaxPriorityFee.gte(mediumMaxPriorityFeeInWEI) &&
        effectiveMaxPriorityFee.lt(highMaxPriorityFeeInWEI)) {
        lowerTimeBound = medium.minWaitTimeEstimate;
        upperTimeBound = medium.maxWaitTimeEstimate;
    }
    else if (effectiveMaxPriorityFee.eq(highMaxPriorityFeeInWEI)) {
        lowerTimeBound = high.minWaitTimeEstimate;
        upperTimeBound = high.maxWaitTimeEstimate;
    }
    else {
        lowerTimeBound = 0;
        upperTimeBound = high.maxWaitTimeEstimate;
    }
    return {
        lowerTimeBound,
        upperTimeBound,
    };
}
exports.calculateTimeEstimate = calculateTimeEstimate;

      };
    };
  }
  }
}, {package:"@metamask/gas-fee-controller",file:"node_modules\\@metamask\\gas-fee-controller\\dist\\gas-util.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gas-fee-controller\\dist\\index.cjs", {"./GasFeeController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gas-fee-controller\\dist\\GasFeeController.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cgas-fee-controller%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./GasFeeController.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/gas-fee-controller",file:"node_modules\\@metamask\\gas-fee-controller\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\GatorPermissionsController.cjs", {"./decodePermission/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\decodePermission\\index.cjs","./errors.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\errors.cjs","./logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\logger.cjs","./types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\types.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\utils.cjs","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/delegation-deployments":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\node_modules\\@metamask\\delegation-deployments\\dist\\index.js","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cgator-permissions-controller%5Cdist%5CGatorPermissionsController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _GatorPermissionsController_instances, _GatorPermissionsController_setIsFetchingGatorPermissions, _GatorPermissionsController_setIsGatorPermissionsEnabled, _GatorPermissionsController_registerMessageHandlers, _GatorPermissionsController_assertGatorPermissionsEnabled, _GatorPermissionsController_handleSnapRequestToGatorPermissionsProvider, _GatorPermissionsController_sanitizeStoredGatorPermission, _GatorPermissionsController_categorizePermissionsDataByTypeAndChainId;
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDefaultGatorPermissionsControllerState = exports.DELEGATION_FRAMEWORK_VERSION = void 0;
const base_controller_1 = require("@metamask/base-controller");
const delegation_deployments_1 = require("@metamask/delegation-deployments");
const snaps_utils_1 = require("@metamask/snaps-utils");
const decodePermission_1 = require("./decodePermission/index.cjs");
const errors_1 = require("./errors.cjs");
const logger_1 = require("./logger.cjs");
const types_1 = require("./types.cjs");
const utils_1 = require("./utils.cjs");
// === GENERAL ===
// Unique name for the controller
const controllerName = 'GatorPermissionsController';
// Default value for the gator permissions provider snap id
const defaultGatorPermissionsProviderSnapId = 'npm:@metamask/gator-permissions-snap';
const defaultGatorPermissionsMap = {
    'native-token-stream': {},
    'native-token-periodic': {},
    'erc20-token-stream': {},
    'erc20-token-periodic': {},
    other: {},
};
/**
 * Delegation framework version used to select the correct deployed enforcer
 * contract addresses from `@metamask/delegation-deployments`.
 */
exports.DELEGATION_FRAMEWORK_VERSION = '1.3.0';
const contractsByChainId = delegation_deployments_1.DELEGATOR_CONTRACTS[exports.DELEGATION_FRAMEWORK_VERSION];
const gatorPermissionsControllerMetadata = {
    isGatorPermissionsEnabled: {
        includeInStateLogs: true,
        persist: true,
        anonymous: false,
        usedInUi: false,
    },
    gatorPermissionsMapSerialized: {
        includeInStateLogs: true,
        persist: true,
        anonymous: false,
        usedInUi: true,
    },
    isFetchingGatorPermissions: {
        includeInStateLogs: true,
        persist: false,
        anonymous: false,
        usedInUi: false,
    },
    gatorPermissionsProviderSnapId: {
        includeInStateLogs: true,
        persist: false,
        anonymous: false,
        usedInUi: false,
    },
};
/**
 * Constructs the default {@link GatorPermissionsController} state. This allows
 * consumers to provide a partial state object when initializing the controller
 * and also helps in constructing complete state objects for this controller in
 * tests.
 *
 * @returns The default {@link GatorPermissionsController} state.
 */
function getDefaultGatorPermissionsControllerState() {
    return {
        isGatorPermissionsEnabled: false,
        gatorPermissionsMapSerialized: (0, utils_1.serializeGatorPermissionsMap)(defaultGatorPermissionsMap),
        isFetchingGatorPermissions: false,
        gatorPermissionsProviderSnapId: defaultGatorPermissionsProviderSnapId,
    };
}
exports.getDefaultGatorPermissionsControllerState = getDefaultGatorPermissionsControllerState;
/**
 * Controller that manages gator permissions by reading from profile sync
 */
class GatorPermissionsController extends base_controller_1.BaseController {
    /**
     * Creates a GatorPermissionsController instance.
     *
     * @param args - The arguments to this function.
     * @param args.messenger - Messenger used to communicate with BaseV2 controller.
     * @param args.state - Initial state to set on this controller.
     */
    constructor({ messenger, state, }) {
        super({
            name: controllerName,
            metadata: gatorPermissionsControllerMetadata,
            messenger,
            state: {
                ...getDefaultGatorPermissionsControllerState(),
                ...state,
                isFetchingGatorPermissions: false,
            },
        });
        _GatorPermissionsController_instances.add(this);
        __classPrivateFieldGet(this, _GatorPermissionsController_instances, "m", _GatorPermissionsController_registerMessageHandlers).call(this);
    }
    /**
     * Gets the gator permissions map from the state.
     *
     * @returns The gator permissions map.
     */
    get gatorPermissionsMap() {
        return (0, utils_1.deserializeGatorPermissionsMap)(this.state.gatorPermissionsMapSerialized);
    }
    /**
     * Gets the gator permissions provider snap id that is used to fetch gator permissions.
     *
     * @returns The gator permissions provider snap id.
     */
    get permissionsProviderSnapId() {
        return this.state.gatorPermissionsProviderSnapId;
    }
    /**
     * Enables gator permissions for the user.
     */
    async enableGatorPermissions() {
        __classPrivateFieldGet(this, _GatorPermissionsController_instances, "m", _GatorPermissionsController_setIsGatorPermissionsEnabled).call(this, true);
    }
    /**
     * Clears the gator permissions map and disables the feature.
     */
    async disableGatorPermissions() {
        this.update((state) => {
            state.isGatorPermissionsEnabled = false;
            state.gatorPermissionsMapSerialized = (0, utils_1.serializeGatorPermissionsMap)(defaultGatorPermissionsMap);
        });
    }
    /**
     * Fetches the gator permissions from profile sync and updates the state.
     *
     * @returns A promise that resolves to the gator permissions map.
     * @throws {GatorPermissionsFetchError} If the gator permissions fetch fails.
     */
    async fetchAndUpdateGatorPermissions() {
        try {
            __classPrivateFieldGet(this, _GatorPermissionsController_instances, "m", _GatorPermissionsController_setIsFetchingGatorPermissions).call(this, true);
            __classPrivateFieldGet(this, _GatorPermissionsController_instances, "m", _GatorPermissionsController_assertGatorPermissionsEnabled).call(this);
            const permissionsData = await __classPrivateFieldGet(this, _GatorPermissionsController_instances, "m", _GatorPermissionsController_handleSnapRequestToGatorPermissionsProvider).call(this, {
                snapId: this.state.gatorPermissionsProviderSnapId,
            });
            const gatorPermissionsMap = __classPrivateFieldGet(this, _GatorPermissionsController_instances, "m", _GatorPermissionsController_categorizePermissionsDataByTypeAndChainId).call(this, permissionsData);
            this.update((state) => {
                state.gatorPermissionsMapSerialized =
                    (0, utils_1.serializeGatorPermissionsMap)(gatorPermissionsMap);
            });
            return gatorPermissionsMap;
        }
        catch (error) {
            (0, logger_1.controllerLog)('Failed to fetch gator permissions', error);
            throw new errors_1.GatorPermissionsFetchError({
                message: 'Failed to fetch gator permissions',
                cause: error,
            });
        }
        finally {
            __classPrivateFieldGet(this, _GatorPermissionsController_instances, "m", _GatorPermissionsController_setIsFetchingGatorPermissions).call(this, false);
        }
    }
    /**
     * Decodes a permission context into a structured permission for a specific origin.
     *
     * This method validates the caller origin, decodes the provided `permissionContext`
     * into delegations, identifies the permission type from the caveat enforcers,
     * extracts the permission-specific data and expiry, and reconstructs a
     * {@link DecodedPermission} containing chainId, account addresses, signer, type and data.
     *
     * @param args - The arguments to this function.
     * @param args.origin - The caller's origin; must match the configured permissions provider Snap id.
     * @param args.chainId - Numeric EIP-155 chain id used for resolving enforcer contracts and encoding.
     * @param args.delegation - delegation representing the permission.
     * @param args.metadata - metadata included in the request.
     * @param args.metadata.justification - the justification as specified in the request metadata.
     * @param args.metadata.origin - the origin as specified in the request metadata.
     *
     * @returns A decoded permission object suitable for UI consumption and follow-up actions.
     * @throws If the origin is not allowed, the context cannot be decoded into exactly one delegation,
     * or the enforcers/terms do not match a supported permission type.
     */
    decodePermissionFromPermissionContextForOrigin({ origin, chainId, delegation: { caveats, delegator, delegate, authority }, metadata: { justification, origin: specifiedOrigin }, }) {
        if (origin !== this.permissionsProviderSnapId) {
            throw new errors_1.OriginNotAllowedError({ origin });
        }
        const contracts = contractsByChainId[chainId];
        if (!contracts) {
            throw new Error(`Contracts not found for chainId: ${chainId}`);
        }
        try {
            const enforcers = caveats.map((caveat) => caveat.enforcer);
            const permissionType = (0, decodePermission_1.identifyPermissionByEnforcers)({
                enforcers,
                contracts,
            });
            const { expiry, data } = (0, decodePermission_1.getPermissionDataAndExpiry)({
                contracts,
                caveats,
                permissionType,
            });
            const permission = (0, decodePermission_1.reconstructDecodedPermission)({
                chainId,
                permissionType,
                delegator,
                delegate,
                authority,
                expiry,
                data,
                justification,
                specifiedOrigin,
            });
            return permission;
        }
        catch (error) {
            throw new errors_1.PermissionDecodingError({
                cause: error,
            });
        }
    }
}
_GatorPermissionsController_instances = new WeakSet(), _GatorPermissionsController_setIsFetchingGatorPermissions = function _GatorPermissionsController_setIsFetchingGatorPermissions(isFetchingGatorPermissions) {
    this.update((state) => {
        state.isFetchingGatorPermissions = isFetchingGatorPermissions;
    });
}, _GatorPermissionsController_setIsGatorPermissionsEnabled = function _GatorPermissionsController_setIsGatorPermissionsEnabled(isGatorPermissionsEnabled) {
    this.update((state) => {
        state.isGatorPermissionsEnabled = isGatorPermissionsEnabled;
    });
}, _GatorPermissionsController_registerMessageHandlers = function _GatorPermissionsController_registerMessageHandlers() {
    this.messagingSystem.registerActionHandler(`${controllerName}:fetchAndUpdateGatorPermissions`, this.fetchAndUpdateGatorPermissions.bind(this));
    this.messagingSystem.registerActionHandler(`${controllerName}:enableGatorPermissions`, this.enableGatorPermissions.bind(this));
    this.messagingSystem.registerActionHandler(`${controllerName}:disableGatorPermissions`, this.disableGatorPermissions.bind(this));
    this.messagingSystem.registerActionHandler(`${controllerName}:decodePermissionFromPermissionContextForOrigin`, this.decodePermissionFromPermissionContextForOrigin.bind(this));
}, _GatorPermissionsController_assertGatorPermissionsEnabled = function _GatorPermissionsController_assertGatorPermissionsEnabled() {
    if (!this.state.isGatorPermissionsEnabled) {
        throw new errors_1.GatorPermissionsNotEnabledError();
    }
}, _GatorPermissionsController_handleSnapRequestToGatorPermissionsProvider = 
/**
 * Forwards a Snap request to the SnapController.
 *
 * @param args - The request parameters.
 * @param args.snapId - The ID of the Snap of the gator permissions provider snap.
 * @returns A promise that resolves with the gator permissions.
 */
async function _GatorPermissionsController_handleSnapRequestToGatorPermissionsProvider({ snapId, }) {
    try {
        const response = (await this.messagingSystem.call('SnapController:handleRequest', {
            snapId,
            origin: 'metamask',
            handler: snaps_utils_1.HandlerType.OnRpcRequest,
            request: {
                jsonrpc: '2.0',
                method: types_1.GatorPermissionsSnapRpcMethod.PermissionProviderGetGrantedPermissions,
            },
        }));
        return response;
    }
    catch (error) {
        (0, logger_1.controllerLog)('Failed to handle snap request to gator permissions provider', error);
        throw new errors_1.GatorPermissionsProviderError({
            method: types_1.GatorPermissionsSnapRpcMethod.PermissionProviderGetGrantedPermissions,
            cause: error,
        });
    }
}, _GatorPermissionsController_sanitizeStoredGatorPermission = function _GatorPermissionsController_sanitizeStoredGatorPermission(storedGatorPermission) {
    const { permissionResponse } = storedGatorPermission;
    const { rules, dependencyInfo, signer, ...rest } = permissionResponse;
    return {
        ...storedGatorPermission,
        permissionResponse: {
            ...rest,
        },
    };
}, _GatorPermissionsController_categorizePermissionsDataByTypeAndChainId = function _GatorPermissionsController_categorizePermissionsDataByTypeAndChainId(storedGatorPermissions) {
    if (!storedGatorPermissions) {
        return defaultGatorPermissionsMap;
    }
    return storedGatorPermissions.reduce((gatorPermissionsMap, storedGatorPermission) => {
        const { permissionResponse } = storedGatorPermission;
        const permissionType = permissionResponse.permission.type;
        const { chainId } = permissionResponse;
        const sanitizedStoredGatorPermission = __classPrivateFieldGet(this, _GatorPermissionsController_instances, "m", _GatorPermissionsController_sanitizeStoredGatorPermission).call(this, storedGatorPermission);
        switch (permissionType) {
            case 'native-token-stream':
            case 'native-token-periodic':
            case 'erc20-token-stream':
            case 'erc20-token-periodic':
                if (!gatorPermissionsMap[permissionType][chainId]) {
                    gatorPermissionsMap[permissionType][chainId] = [];
                }
                gatorPermissionsMap[permissionType][chainId].push(sanitizedStoredGatorPermission);
                break;
            default:
                if (!gatorPermissionsMap.other[chainId]) {
                    gatorPermissionsMap.other[chainId] = [];
                }
                gatorPermissionsMap.other[chainId].push(sanitizedStoredGatorPermission);
                break;
        }
        return gatorPermissionsMap;
    }, {
        'native-token-stream': {},
        'native-token-periodic': {},
        'erc20-token-stream': {},
        'erc20-token-periodic': {},
        other: {},
    });
};
exports.default = GatorPermissionsController;

      };
    };
  }
  }
}, {package:"@metamask/gator-permissions-controller",file:"node_modules\\@metamask\\gator-permissions-controller\\dist\\GatorPermissionsController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\decodePermission\\decodePermission.cjs", {"./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\decodePermission\\utils.cjs","@metamask/delegation-core":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\delegation-core\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cgator-permissions-controller%5Cdist%5CdecodePermission%5CdecodePermission.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.reconstructDecodedPermission = exports.getPermissionDataAndExpiry = exports.identifyPermissionByEnforcers = void 0;
const delegation_core_1 = require("@metamask/delegation-core");
const utils_1 = require("@metamask/utils");
const utils_2 = require("./utils.cjs");
/**
 * Identifies the unique permission type that matches a given set of enforcer
 * contract addresses for a specific chain.
 *
 * A permission type matches when:
 * - All of its required enforcers are present in the provided list; and
 * - No provided enforcer falls outside the union of the type's required and
 * allowed enforcers (currently only `TimestampEnforcer` is allowed extra).
 *
 * If exactly one permission type matches, its identifier is returned.
 *
 * @param args - The arguments to this function.
 * @param args.enforcers - List of enforcer contract addresses (hex strings).
 *
 * @param args.contracts - The deployed contracts for the chain.
 * @returns The identifier of the matching permission type.
 * @throws If no permission type matches, or if more than one permission type matches.
 */
const identifyPermissionByEnforcers = ({ enforcers, contracts, }) => {
    const enforcersSet = new Set(enforcers.map(utils_1.getChecksumAddress));
    const permissionRules = (0, utils_2.createPermissionRulesForChainId)(contracts);
    let matchingPermissionType = null;
    for (const { allowedEnforcers, requiredEnforcers, permissionType, } of permissionRules) {
        const hasAllRequiredEnforcers = (0, utils_2.isSubset)(requiredEnforcers, enforcersSet);
        let hasForbiddenEnforcers = false;
        for (const caveat of enforcersSet) {
            if (!allowedEnforcers.has(caveat) && !requiredEnforcers.has(caveat)) {
                hasForbiddenEnforcers = true;
                break;
            }
        }
        if (hasAllRequiredEnforcers && !hasForbiddenEnforcers) {
            if (matchingPermissionType) {
                throw new Error('Multiple permission types match');
            }
            matchingPermissionType = permissionType;
        }
    }
    if (!matchingPermissionType) {
        throw new Error('Unable to identify permission type');
    }
    return matchingPermissionType;
};
exports.identifyPermissionByEnforcers = identifyPermissionByEnforcers;
/**
 * Extracts the permission-specific data payload and the expiry timestamp from
 * the provided caveats for a given permission type.
 *
 * This function locates the relevant caveat enforcer for the `permissionType`,
 * interprets its `terms` by splitting the hex string into byte-sized segments,
 * and converts each segment into the appropriate numeric or address shape.
 *
 * The expiry timestamp is derived from the `TimestampEnforcer` terms and must
 * have a zero `timestampAfterThreshold` and a positive `timestampBeforeThreshold`.
 *
 * @param args - The arguments to this function.
 * @param args.contracts - The deployed contracts for the chain.
 * @param args.caveats - Caveats decoded from the permission context.
 * @param args.permissionType - The previously identified permission type.
 *
 * @returns An object containing the `expiry` timestamp and the decoded `data` payload.
 * @throws If the caveats are malformed, missing, or the terms fail to decode.
 */
const getPermissionDataAndExpiry = ({ contracts, caveats, permissionType, }) => {
    const checksumCaveats = caveats.map((caveat) => ({
        ...caveat,
        enforcer: (0, utils_1.getChecksumAddress)(caveat.enforcer),
    }));
    const { erc20StreamingEnforcer, erc20PeriodicEnforcer, nativeTokenStreamingEnforcer, nativeTokenPeriodicEnforcer, timestampEnforcer, } = (0, utils_2.getChecksumEnforcersByChainId)(contracts);
    const expiryTerms = (0, utils_2.getTermsByEnforcer)({
        caveats: checksumCaveats,
        enforcer: timestampEnforcer,
        throwIfNotFound: false,
    });
    let expiry = null;
    if (expiryTerms) {
        const [after, before] = (0, utils_2.splitHex)(expiryTerms, [16, 16]);
        if ((0, utils_1.hexToNumber)(after) !== 0) {
            throw new Error('Invalid expiry');
        }
        expiry = (0, utils_1.hexToNumber)(before);
    }
    let data;
    switch (permissionType) {
        case 'erc20-token-stream': {
            const erc20StreamingTerms = (0, utils_2.getTermsByEnforcer)({
                caveats: checksumCaveats,
                enforcer: erc20StreamingEnforcer,
            });
            const [tokenAddress, initialAmount, maxAmount, amountPerSecond, startTimeRaw,] = (0, utils_2.splitHex)(erc20StreamingTerms, [20, 32, 32, 32, 32]);
            data = {
                tokenAddress,
                initialAmount,
                maxAmount,
                amountPerSecond,
                startTime: (0, utils_1.hexToNumber)(startTimeRaw),
            };
            break;
        }
        case 'erc20-token-periodic': {
            const erc20PeriodicTerms = (0, utils_2.getTermsByEnforcer)({
                caveats: checksumCaveats,
                enforcer: erc20PeriodicEnforcer,
            });
            const [tokenAddress, periodAmount, periodDurationRaw, startTimeRaw] = (0, utils_2.splitHex)(erc20PeriodicTerms, [20, 32, 32, 32]);
            data = {
                tokenAddress,
                periodAmount,
                periodDuration: (0, utils_1.hexToNumber)(periodDurationRaw),
                startTime: (0, utils_1.hexToNumber)(startTimeRaw),
            };
            break;
        }
        case 'native-token-stream': {
            const nativeTokenStreamingTerms = (0, utils_2.getTermsByEnforcer)({
                caveats: checksumCaveats,
                enforcer: nativeTokenStreamingEnforcer,
            });
            const [initialAmount, maxAmount, amountPerSecond, startTimeRaw] = (0, utils_2.splitHex)(nativeTokenStreamingTerms, [32, 32, 32, 32]);
            data = {
                initialAmount,
                maxAmount,
                amountPerSecond,
                startTime: (0, utils_1.hexToNumber)(startTimeRaw),
            };
            break;
        }
        case 'native-token-periodic': {
            const nativeTokenPeriodicTerms = (0, utils_2.getTermsByEnforcer)({
                caveats: checksumCaveats,
                enforcer: nativeTokenPeriodicEnforcer,
            });
            const [periodAmount, periodDurationRaw, startTimeRaw] = (0, utils_2.splitHex)(nativeTokenPeriodicTerms, [32, 32, 32]);
            data = {
                periodAmount,
                periodDuration: (0, utils_1.hexToNumber)(periodDurationRaw),
                startTime: (0, utils_1.hexToNumber)(startTimeRaw),
            };
            break;
        }
        default:
            throw new Error('Invalid permission type');
    }
    return { expiry, data };
};
exports.getPermissionDataAndExpiry = getPermissionDataAndExpiry;
/**
 * Reconstructs a {@link DecodedPermission} object from primitive values
 * obtained while decoding a permission context.
 *
 * The resulting object contains:
 * - `chainId` encoded as hex (`0x…`)
 * - `address` set to the delegator (user account)
 * - `signer` set to an account signer with the delegate address
 * - `permission` with the identified type and decoded data
 * - `expiry` timestamp (or null)
 *
 * @param args - The arguments to this function.
 * @param args.chainId - Chain ID.
 * @param args.permissionType - Identified permission type.
 * @param args.delegator - Address of the account delegating permission.
 * @param args.delegate - Address that will act under the granted permission.
 * @param args.authority - Authority identifier; must be ROOT_AUTHORITY.
 * @param args.expiry - Expiry timestamp (unix seconds) or null if unbounded.
 * @param args.data - Permission-specific decoded data payload.
 * @param args.justification - Human-readable justification for the permission.
 * @param args.specifiedOrigin - The origin reported in the request metadata.
 *
 * @returns The reconstructed {@link DecodedPermission}.
 */
const reconstructDecodedPermission = ({ chainId, permissionType, delegator, delegate, authority, expiry, data, justification, specifiedOrigin, }) => {
    if (authority !== delegation_core_1.ROOT_AUTHORITY) {
        throw new Error('Invalid authority');
    }
    const permission = {
        chainId: (0, utils_1.numberToHex)(chainId),
        address: delegator,
        signer: { type: 'account', data: { address: delegate } },
        permission: {
            type: permissionType,
            data,
            justification,
        },
        expiry,
        origin: specifiedOrigin,
    };
    return permission;
};
exports.reconstructDecodedPermission = reconstructDecodedPermission;

      };
    };
  }
  }
}, {package:"@metamask/gator-permissions-controller",file:"node_modules\\@metamask\\gator-permissions-controller\\dist\\decodePermission\\decodePermission.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\decodePermission\\index.cjs", {"./decodePermission.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\decodePermission\\decodePermission.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cgator-permissions-controller%5Cdist%5CdecodePermission%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.reconstructDecodedPermission = exports.getPermissionDataAndExpiry = exports.identifyPermissionByEnforcers = void 0;
var decodePermission_1 = require("./decodePermission.cjs");
Object.defineProperty(exports, "identifyPermissionByEnforcers", { enumerable: true, get: function () { return decodePermission_1.identifyPermissionByEnforcers; } });
Object.defineProperty(exports, "getPermissionDataAndExpiry", { enumerable: true, get: function () { return decodePermission_1.getPermissionDataAndExpiry; } });
Object.defineProperty(exports, "reconstructDecodedPermission", { enumerable: true, get: function () { return decodePermission_1.reconstructDecodedPermission; } });

      };
    };
  }
  }
}, {package:"@metamask/gator-permissions-controller",file:"node_modules\\@metamask\\gator-permissions-controller\\dist\\decodePermission\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\decodePermission\\utils.cjs", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cgator-permissions-controller%5Cdist%5CdecodePermission%5Cutils.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.splitHex = exports.getTermsByEnforcer = exports.isSubset = exports.createPermissionRulesForChainId = exports.getChecksumEnforcersByChainId = void 0;
const utils_1 = require("@metamask/utils");
/**
 * The names of the enforcer contracts for each permission type.
 */
const ENFORCER_CONTRACT_NAMES = {
    ERC20PeriodTransferEnforcer: 'ERC20PeriodTransferEnforcer',
    ERC20StreamingEnforcer: 'ERC20StreamingEnforcer',
    ExactCalldataEnforcer: 'ExactCalldataEnforcer',
    NativeTokenPeriodTransferEnforcer: 'NativeTokenPeriodTransferEnforcer',
    NativeTokenStreamingEnforcer: 'NativeTokenStreamingEnforcer',
    TimestampEnforcer: 'TimestampEnforcer',
    ValueLteEnforcer: 'ValueLteEnforcer',
    NonceEnforcer: 'NonceEnforcer',
};
/**
 * Resolves and returns checksummed addresses of all known enforcer contracts
 * for a given `chainId` under the current delegation framework version.
 *
 * @param contracts - The deployed contracts for the chain.
 * @returns An object mapping enforcer names to checksummed contract addresses.
 * @throws If the chain or an expected enforcer contract is not found.
 */
const getChecksumEnforcersByChainId = (contracts) => {
    const getChecksumContractAddress = (contractName) => {
        const address = contracts[contractName];
        if (!address) {
            throw new Error(`Contract not found: ${contractName}`);
        }
        return (0, utils_1.getChecksumAddress)(address);
    };
    // permission type specific enforcers
    const erc20StreamingEnforcer = getChecksumContractAddress(ENFORCER_CONTRACT_NAMES.ERC20StreamingEnforcer);
    const erc20PeriodicEnforcer = getChecksumContractAddress(ENFORCER_CONTRACT_NAMES.ERC20PeriodTransferEnforcer);
    const nativeTokenStreamingEnforcer = getChecksumContractAddress(ENFORCER_CONTRACT_NAMES.NativeTokenStreamingEnforcer);
    const nativeTokenPeriodicEnforcer = getChecksumContractAddress(ENFORCER_CONTRACT_NAMES.NativeTokenPeriodTransferEnforcer);
    // general enforcers
    const exactCalldataEnforcer = getChecksumContractAddress(ENFORCER_CONTRACT_NAMES.ExactCalldataEnforcer);
    const valueLteEnforcer = getChecksumContractAddress(ENFORCER_CONTRACT_NAMES.ValueLteEnforcer);
    const timestampEnforcer = getChecksumContractAddress(ENFORCER_CONTRACT_NAMES.TimestampEnforcer);
    const nonceEnforcer = getChecksumContractAddress(ENFORCER_CONTRACT_NAMES.NonceEnforcer);
    return {
        erc20StreamingEnforcer,
        erc20PeriodicEnforcer,
        nativeTokenStreamingEnforcer,
        nativeTokenPeriodicEnforcer,
        exactCalldataEnforcer,
        valueLteEnforcer,
        timestampEnforcer,
        nonceEnforcer,
    };
};
exports.getChecksumEnforcersByChainId = getChecksumEnforcersByChainId;
/**
 * Builds the canonical set of permission matching rules for a chain.
 *
 * Each rule specifies the `permissionType`, the set of `requiredEnforcers`
 * that must be present, and the set of `allowedEnforcers` that may appear in
 * addition to the required set.
 *
 * @param contracts - The deployed contracts for the chain.
 * @returns A list of permission rules used to identify permission types.
 * @throws Propagates any errors from resolving enforcer addresses.
 */
const createPermissionRulesForChainId = (contracts) => {
    const { erc20StreamingEnforcer, erc20PeriodicEnforcer, nativeTokenStreamingEnforcer, nativeTokenPeriodicEnforcer, exactCalldataEnforcer, valueLteEnforcer, timestampEnforcer, nonceEnforcer, } = (0, exports.getChecksumEnforcersByChainId)(contracts);
    // the allowed enforcers are the same for all permission types
    const allowedEnforcers = new Set([timestampEnforcer]);
    const permissionRules = [
        {
            requiredEnforcers: new Set([
                nativeTokenStreamingEnforcer,
                exactCalldataEnforcer,
                nonceEnforcer,
            ]),
            allowedEnforcers,
            permissionType: 'native-token-stream',
        },
        {
            requiredEnforcers: new Set([
                nativeTokenPeriodicEnforcer,
                exactCalldataEnforcer,
                nonceEnforcer,
            ]),
            allowedEnforcers,
            permissionType: 'native-token-periodic',
        },
        {
            requiredEnforcers: new Set([
                erc20StreamingEnforcer,
                valueLteEnforcer,
                nonceEnforcer,
            ]),
            allowedEnforcers,
            permissionType: 'erc20-token-stream',
        },
        {
            requiredEnforcers: new Set([
                erc20PeriodicEnforcer,
                valueLteEnforcer,
                nonceEnforcer,
            ]),
            allowedEnforcers,
            permissionType: 'erc20-token-periodic',
        },
    ];
    return permissionRules;
};
exports.createPermissionRulesForChainId = createPermissionRulesForChainId;
/**
 * Determines whether all elements of `subset` are contained within `superset`.
 *
 * @param subset - The candidate subset to test.
 * @param superset - The set expected to contain all elements of `subset`.
 * @returns `true` if `subset` ⊆ `superset`, otherwise `false`.
 */
const isSubset = (subset, superset) => {
    for (const x of subset) {
        if (!superset.has(x)) {
            return false;
        }
    }
    return true;
};
exports.isSubset = isSubset;
/**
 * Gets the terms for a given enforcer from a list of caveats.
 *
 * @param args - The arguments to this function.
 * @param  args.throwIfNotFound - Whether to throw an error if no matching enforcer is found. Default is true.
 * @param args.caveats - The list of caveats to search.
 * @param args.enforcer - The enforcer to search for.
 * @returns The terms for the given enforcer.
 */
function getTermsByEnforcer({ caveats, enforcer, throwIfNotFound, }) {
    const matchingCaveats = caveats.filter((caveat) => caveat.enforcer === enforcer);
    if (matchingCaveats.length === 0) {
        if (throwIfNotFound ?? true) {
            throw new Error('Invalid caveats');
        }
        return null;
    }
    if (matchingCaveats.length > 1) {
        throw new Error('Invalid caveats');
    }
    return matchingCaveats[0].terms;
}
exports.getTermsByEnforcer = getTermsByEnforcer;
/**
 * Splits a 0x-prefixed hex string into parts according to the provided byte lengths.
 *
 * Each entry in `lengths` represents a part length in bytes; internally this is
 * multiplied by 2 to derive the number of hexadecimal characters to slice. The
 * returned substrings do not include the `0x` prefix and preserve leading zeros.
 *
 * Note: This function does not perform input validation (e.g., verifying the
 * payload length equals the sum of requested lengths). Callers are expected to
 * provide well-formed inputs.
 *
 * Example:
 * splitHex('0x12345678', [1, 3]) => ['0x12', '0x345678']
 *
 * @param value - The 0x-prefixed hex string to split.
 * @param lengths - The lengths of each part, in bytes.
 * @returns An array of hex substrings (each with `0x` prefix), one for each part.
 */
function splitHex(value, lengths) {
    let start = 2;
    const parts = [];
    for (const partLength of lengths) {
        const partCharLength = partLength * 2;
        const part = value.slice(start, start + partCharLength);
        start += partCharLength;
        parts.push(`0x${part}`);
    }
    return parts;
}
exports.splitHex = splitHex;

      };
    };
  }
  }
}, {package:"@metamask/gator-permissions-controller",file:"node_modules\\@metamask\\gator-permissions-controller\\dist\\decodePermission\\utils.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\errors.cjs", {"./types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\types.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cgator-permissions-controller%5Cdist%5Cerrors.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PermissionDecodingError = exports.OriginNotAllowedError = exports.GatorPermissionsProviderError = exports.GatorPermissionsNotEnabledError = exports.GatorPermissionsMapSerializationError = exports.GatorPermissionsFetchError = exports.GatorPermissionsControllerError = void 0;
const types_1 = require("./types.cjs");
class GatorPermissionsControllerError extends Error {
    constructor({ cause, message, code }) {
        super(message);
        this.cause = cause;
        this.code = code;
    }
}
exports.GatorPermissionsControllerError = GatorPermissionsControllerError;
class GatorPermissionsFetchError extends GatorPermissionsControllerError {
    constructor({ cause, message }) {
        super({
            cause,
            message,
            code: types_1.GatorPermissionsControllerErrorCode.GatorPermissionsFetchError,
        });
    }
}
exports.GatorPermissionsFetchError = GatorPermissionsFetchError;
class GatorPermissionsMapSerializationError extends GatorPermissionsControllerError {
    constructor({ cause, message, data, }) {
        super({
            cause,
            message,
            code: types_1.GatorPermissionsControllerErrorCode.GatorPermissionsMapSerializationError,
        });
        this.data = data;
    }
}
exports.GatorPermissionsMapSerializationError = GatorPermissionsMapSerializationError;
class GatorPermissionsNotEnabledError extends GatorPermissionsControllerError {
    constructor() {
        super({
            cause: new Error('Gator permissions are not enabled'),
            message: 'Gator permissions are not enabled',
            code: types_1.GatorPermissionsControllerErrorCode.GatorPermissionsNotEnabled,
        });
    }
}
exports.GatorPermissionsNotEnabledError = GatorPermissionsNotEnabledError;
class GatorPermissionsProviderError extends GatorPermissionsControllerError {
    constructor({ cause, method, }) {
        super({
            cause,
            message: `Failed to handle snap request to gator permissions provider for method ${method}`,
            code: types_1.GatorPermissionsControllerErrorCode.GatorPermissionsProviderError,
        });
    }
}
exports.GatorPermissionsProviderError = GatorPermissionsProviderError;
class OriginNotAllowedError extends GatorPermissionsControllerError {
    constructor({ origin }) {
        const message = `Origin ${origin} not allowed`;
        super({
            cause: new Error(message),
            message,
            code: types_1.GatorPermissionsControllerErrorCode.OriginNotAllowedError,
        });
    }
}
exports.OriginNotAllowedError = OriginNotAllowedError;
class PermissionDecodingError extends GatorPermissionsControllerError {
    constructor({ cause }) {
        super({
            cause,
            message: `Failed to decode permission`,
            code: types_1.GatorPermissionsControllerErrorCode.PermissionDecodingError,
        });
    }
}
exports.PermissionDecodingError = PermissionDecodingError;

      };
    };
  }
  }
}, {package:"@metamask/gator-permissions-controller",file:"node_modules\\@metamask\\gator-permissions-controller\\dist\\errors.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\index.cjs", {"./GatorPermissionsController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\GatorPermissionsController.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\utils.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cgator-permissions-controller%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deserializeGatorPermissionsMap = exports.serializeGatorPermissionsMap = exports.GatorPermissionsController = void 0;
var GatorPermissionsController_1 = require("./GatorPermissionsController.cjs");
Object.defineProperty(exports, "GatorPermissionsController", { enumerable: true, get: function () { return __importDefault(GatorPermissionsController_1).default; } });
var utils_1 = require("./utils.cjs");
Object.defineProperty(exports, "serializeGatorPermissionsMap", { enumerable: true, get: function () { return utils_1.serializeGatorPermissionsMap; } });
Object.defineProperty(exports, "deserializeGatorPermissionsMap", { enumerable: true, get: function () { return utils_1.deserializeGatorPermissionsMap; } });

      };
    };
  }
  }
}, {package:"@metamask/gator-permissions-controller",file:"node_modules\\@metamask\\gator-permissions-controller\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\logger.cjs", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cgator-permissions-controller%5Cdist%5Clogger.cjs
      return function (require, module, exports) {
"use strict";
/* istanbul ignore file */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createModuleLogger = exports.utilsLog = exports.controllerLog = exports.projectLogger = void 0;
const utils_1 = require("@metamask/utils");
Object.defineProperty(exports, "createModuleLogger", { enumerable: true, get: function () { return utils_1.createModuleLogger; } });
exports.projectLogger = (0, utils_1.createProjectLogger)('gator-permissions-controller');
exports.controllerLog = (0, utils_1.createModuleLogger)(exports.projectLogger, 'GatorPermissionsController');
exports.utilsLog = (0, utils_1.createModuleLogger)(exports.projectLogger, 'utils');

      };
    };
  }
  }
}, {package:"@metamask/gator-permissions-controller",file:"node_modules\\@metamask\\gator-permissions-controller\\dist\\logger.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\types.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cgator-permissions-controller%5Cdist%5Ctypes.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GatorPermissionsSnapRpcMethod = exports.GatorPermissionsControllerErrorCode = void 0;
/**
 * Enum for the error codes of the gator permissions controller.
 */
var GatorPermissionsControllerErrorCode;
(function (GatorPermissionsControllerErrorCode) {
    GatorPermissionsControllerErrorCode["GatorPermissionsFetchError"] = "gator-permissions-fetch-error";
    GatorPermissionsControllerErrorCode["GatorPermissionsNotEnabled"] = "gator-permissions-not-enabled";
    GatorPermissionsControllerErrorCode["GatorPermissionsProviderError"] = "gator-permissions-provider-error";
    GatorPermissionsControllerErrorCode["GatorPermissionsMapSerializationError"] = "gator-permissions-map-serialization-error";
    GatorPermissionsControllerErrorCode["PermissionDecodingError"] = "permission-decoding-error";
    GatorPermissionsControllerErrorCode["OriginNotAllowedError"] = "origin-not-allowed-error";
})(GatorPermissionsControllerErrorCode || (exports.GatorPermissionsControllerErrorCode = GatorPermissionsControllerErrorCode = {}));
/**
 * Enum for the RPC methods of the gator permissions provider snap.
 */
var GatorPermissionsSnapRpcMethod;
(function (GatorPermissionsSnapRpcMethod) {
    /**
     * This method is used by the metamask to request a permissions provider to get granted permissions for all sites.
     */
    GatorPermissionsSnapRpcMethod["PermissionProviderGetGrantedPermissions"] = "permissionsProvider_getGrantedPermissions";
})(GatorPermissionsSnapRpcMethod || (exports.GatorPermissionsSnapRpcMethod = GatorPermissionsSnapRpcMethod = {}));

      };
    };
  }
  }
}, {package:"@metamask/gator-permissions-controller",file:"node_modules\\@metamask\\gator-permissions-controller\\dist\\types.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\utils.cjs", {"./errors.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\errors.cjs","./logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\dist\\logger.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cgator-permissions-controller%5Cdist%5Cutils.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deserializeGatorPermissionsMap = exports.serializeGatorPermissionsMap = void 0;
const errors_1 = require("./errors.cjs");
const logger_1 = require("./logger.cjs");
/**
 * Serializes a gator permissions map to a string.
 *
 * @param gatorPermissionsMap - The gator permissions map to serialize.
 * @returns The serialized gator permissions map.
 */
function serializeGatorPermissionsMap(gatorPermissionsMap) {
    try {
        return JSON.stringify(gatorPermissionsMap);
    }
    catch (error) {
        (0, logger_1.utilsLog)('Failed to serialize gator permissions map', error);
        throw new errors_1.GatorPermissionsMapSerializationError({
            cause: error,
            message: 'Failed to serialize gator permissions map',
            data: gatorPermissionsMap,
        });
    }
}
exports.serializeGatorPermissionsMap = serializeGatorPermissionsMap;
/**
 * Deserializes a gator permissions map from a string.
 *
 * @param gatorPermissionsMap - The gator permissions map to deserialize.
 * @returns The deserialized gator permissions map.
 */
function deserializeGatorPermissionsMap(gatorPermissionsMap) {
    try {
        return JSON.parse(gatorPermissionsMap);
    }
    catch (error) {
        (0, logger_1.utilsLog)('Failed to deserialize gator permissions map', error);
        throw new errors_1.GatorPermissionsMapSerializationError({
            cause: error,
            message: 'Failed to deserialize gator permissions map',
            data: gatorPermissionsMap,
        });
    }
}
exports.deserializeGatorPermissionsMap = deserializeGatorPermissionsMap;

      };
    };
  }
  }
}, {package:"@metamask/gator-permissions-controller",file:"node_modules\\@metamask\\gator-permissions-controller\\dist\\utils.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\gator-permissions-controller\\node_modules\\@metamask\\delegation-deployments\\dist\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cgator-permissions-controller%5Cnode_modules%5C@metamask%5Cdelegation-deployments%5Cdist%5Cindex.js
      return function (require, module, exports) {
"use strict";Object.defineProperty(exports, "__esModule", {value: true});// src/contractAddresses.ts
var deployments_1_3_0 = {
  DelegationManager: "0xdb9B1e94B5b69Df7e401DDbedE43491141047dB3",
  EntryPoint: "0x0000000071727De22E5E9d8BAf0edAc6f37da032",
  SimpleFactory: "0x69Aa2f9fe1572F1B640E1bbc512f5c3a734fc77c",
  // Implementations
  MultiSigDeleGatorImpl: "0x56a9EdB16a0105eb5a4C54f4C062e2868844f3A7",
  HybridDeleGatorImpl: "0x48dBe696A4D990079e039489bA2053B36E8FFEC4",
  EIP7702StatelessDeleGatorImpl: "0x63c0c19a282a1B52b07dD5a65b58948A07DAE32B",
  // Caveat Enforcers
  AllowedCalldataEnforcer: "0xc2b0d624c1c4319760C96503BA27C347F3260f55",
  AllowedMethodsEnforcer: "0x2c21fD0Cb9DC8445CB3fb0DC5E7Bb0Aca01842B5",
  AllowedTargetsEnforcer: "0x7F20f61b1f09b08D970938F6fa563634d65c4EeB",
  BlockNumberEnforcer: "0x5d9818dF0AE3f66e9c3D0c5029DAF99d1823ca6c",
  DeployedEnforcer: "0x24ff2AA430D53a8CD6788018E902E098083dcCd2",
  ERC20BalanceChangeEnforcer: "0xcdF6aB796408598Cea671d79506d7D48E97a5437",
  ERC20TransferAmountEnforcer: "0xf100b0819427117EcF76Ed94B358B1A5b5C6D2Fc",
  ERC20PeriodTransferEnforcer: "0x474e3Ae7E169e940607cC624Da8A15Eb120139aB",
  ERC20StreamingEnforcer: "0x56c97aE02f233B29fa03502Ecc0457266d9be00e",
  ERC721BalanceChangeEnforcer: "0x8aFdf96eDBbe7e1eD3f5Cd89C7E084841e12A09e",
  ERC721TransferEnforcer: "0x3790e6B7233f779b09DA74C72b6e94813925b9aF",
  ERC1155BalanceChangeEnforcer: "0x63c322732695cAFbbD488Fc6937A0A7B66fC001A",
  ExactCalldataBatchEnforcer: "0x982FD5C86BBF425d7d1451f974192d4525113DfD",
  ExactCalldataEnforcer: "0x99F2e9bF15ce5eC84685604836F71aB835DBBdED",
  ExactExecutionBatchEnforcer: "0x1e141e455d08721Dd5BCDA1BaA6Ea5633Afd5017",
  ExactExecutionEnforcer: "0x146713078D39eCC1F5338309c28405ccf85Abfbb",
  IdEnforcer: "0xC8B5D93463c893401094cc70e66A206fb5987997",
  LimitedCallsEnforcer: "0x04658B29F6b82ed55274221a06Fc97D318E25416",
  NativeBalanceChangeEnforcer: "0xbD7B277507723490Cd50b12EaaFe87C616be6880",
  ArgsEqualityCheckEnforcer: "0x44B8C6ae3C304213c3e298495e12497Ed3E56E41",
  NativeTokenPaymentEnforcer: "0x4803a326ddED6dDBc60e659e5ed12d85c7582811",
  NativeTokenTransferAmountEnforcer: "0xF71af580b9c3078fbc2BBF16FbB8EEd82b330320",
  NativeTokenStreamingEnforcer: "0xD10b97905a320b13a0608f7E9cC506b56747df19",
  NativeTokenPeriodTransferEnforcer: "0x9BC0FAf4Aca5AE429F4c06aEEaC517520CB16BD9",
  NonceEnforcer: "0xDE4f2FAC4B3D87A1d9953Ca5FC09FCa7F366254f",
  OwnershipTransferEnforcer: "0x7EEf9734E7092032B5C56310Eb9BbD1f4A524681",
  RedeemerEnforcer: "0xE144b0b2618071B4E56f746313528a669c7E65c5",
  SpecificActionERC20TransferBatchEnforcer: "0x00e0251aaA263dfE3B3541B758A82D1CBA1c3B6D",
  TimestampEnforcer: "0x1046bb45C8d673d4ea75321280DB34899413c069",
  ValueLteEnforcer: "0x92Bf12322527cAA612fd31a0e810472BBB106A8F",
  MultiTokenPeriodEnforcer: "0xFB2f1a9BD76d3701B730E5d69C3219D42D80eBb7"
};
var deployments_1_1_0 = {
  DelegationManager: "0x56D56e07e3d6Ee5a24e30203A37a0a460f42D7A3",
  EntryPoint: "0x0000000071727De22E5E9d8BAf0edAc6f37da032",
  SimpleFactory: "0x6ff518884f21168c30c58CB21184D6AdBC18Ad90",
  // Implementations
  MultiSigDeleGatorImpl: "0xd1f421EDbA5e3FA9efe3874827114b20C5BEC40C",
  HybridDeleGatorImpl: "0x941f3a016F8726d5643Ce62452d0D78492D42b42",
  // Caveat Enforcers
  AllowedCalldataEnforcer: "0xff71d60f3208469cBCE0859717B5198042DCB3F3",
  AllowedMethodsEnforcer: "0xe32C2561792e8446Abe73B9f557B881C13906186",
  AllowedTargetsEnforcer: "0x06aaE4c67EEA95277c46Bf79b1583d4a01772D22",
  BlockNumberEnforcer: "0x8E470D2Ae278457b42d2405E0B8Cd4BE21Ed9045",
  DeployedEnforcer: "0xf9088f013dBD9ebb7Cebd66fEB48253c6Ac5a820",
  ERC20BalanceGteEnforcer: "0xB7B6f32ec6343261D814e55Ed8C5925d91Cab861",
  ERC20TransferAmountEnforcer: "0x9A069b18032B31429A363AeCFb1B6A0564b44471",
  IdEnforcer: "0x91015c3b9D9523966eD2399885e5Df7A567f916c",
  LimitedCallsEnforcer: "0xe694bFfffEA3E85923b1210b37e6a0175e910863",
  NonceEnforcer: "0xE83BCFD8bBE672A96747e831050a91cf44F4F87A",
  TimestampEnforcer: "0x550FdD13eEBC1f22ea2a2480024BacBF0Ad7e5CE",
  ValueLteEnforcer: "0xBE32a6DB7471F63BB168C088c57Db01AfAe87967",
  NativeTokenTransferAmountEnforcer: "0x5eD3833d7B957A8DB8A461c3AF2d668Ec25382E0",
  NativeBalanceGteEnforcer: "0x376a98860E210DdEda3689fb39565592c563cB0A",
  ArgsEqualityCheckEnforcer: "0x7378dE585998d3E18Ce147867C335C25B3dB8Ee5",
  NativeTokenPaymentEnforcer: "0x87Fe18EbF99e42fcE8A03a25F1d20E119407f8e7",
  RedeemerEnforcer: "0x926672b130D1EF60A9d6b11D2048d121b30f40C1"
};
var deployments_1_0_0 = {
  DelegationManager: "0xbe4138886cb096bdc1b930f2f0ca7892aa234d78",
  EntryPoint: "0x0000000071727De22E5E9d8BAf0edAc6f37da032",
  SimpleFactory: "0x6ff518884f21168c30c58CB21184D6AdBC18Ad90",
  // Implementations
  MultiSigDeleGatorImpl: "0x11f555af5844d85bfcf5d61d2a22866527eb585a",
  HybridDeleGatorImpl: "0xd6edd1256deccb2b06bdecef92dc16bcf26e531b",
  // Caveat Enforcers
  AllowedCalldataEnforcer: "0x48db3835a873d64a4af2c09f014052407c003bd7",
  AllowedMethodsEnforcer: "0xfd731951bf1c52afccee3e6f14ab656475b76dd4",
  AllowedTargetsEnforcer: "0xbc8673c0afa52d86d991c06881e55b2966920564",
  BlockNumberEnforcer: "0xc15faffa0d879b9263c15a46ce31eacfa2e0e8ae",
  DeployedEnforcer: "0x5accb9559b56a6c1e3f90e342c85c42d93720d43",
  ERC20BalanceGteEnforcer: "0xb5d6b1ec6d868a3bae5b7f48178eaa2686a7a087",
  ERC20TransferAmountEnforcer: "0x92ac423b9c111962179a6242e1adb58d02c103be",
  IdEnforcer: "0x34152d9f3f8f74338d50703e780389e829b4abac",
  LimitedCallsEnforcer: "0x4b3adad4a328bee8ba17b86074d92fe7372180cd",
  NonceEnforcer: "0x2f32ff3fc3086d7f63f16fe8d0065390d460b40d",
  TimestampEnforcer: "0x78e05f779490c24bf3bfa135b4112e7003b321cd",
  ValueLteEnforcer: "0xfc20ede0a1132e839fbda9d7ed3904ff3c89540f"
};

// src/index.ts
var CHAIN_ID = {
  // Mainnets
  mainnet: 1,
  optimism: 10,
  bsc: 56,
  gnosis: 100,
  polygon: 137,
  base: 8453,
  arbitrum: 42161,
  linea: 59144,
  berachain: 80094,
  unichain: 130,
  arbitrumNova: 42170,
  // Testnets
  bscTestnet: 97,
  megaEthTestnet: 6342,
  chiado: 10200,
  lineaSepolia: 59141,
  berachainBepolia: 80069,
  baseSepolia: 84532,
  arbitrumSepolia: 421614,
  sepolia: 11155111,
  optimismSepolia: 11155420,
  unichainSepolia: 1301,
  polygonAmoy: 80002,
  monadTestnet: 10143,
  // decommissioned
  lineaGoerli: 59140
};
var DELEGATOR_CONTRACTS = {
  "1.0.0": {
    // Mainnets
    [CHAIN_ID.optimism]: deployments_1_0_0,
    [CHAIN_ID.polygon]: deployments_1_0_0,
    [CHAIN_ID.base]: deployments_1_0_0,
    [CHAIN_ID.arbitrum]: deployments_1_0_0,
    [CHAIN_ID.linea]: deployments_1_0_0,
    // Testnets
    [CHAIN_ID.sepolia]: {
      ...deployments_1_0_0,
      HybridDeleGatorImpl: "0x5989F5D13DF8fc818EdA65e417AED90459fD67F7"
    },
    [CHAIN_ID.lineaSepolia]: {
      ...deployments_1_0_0,
      HybridDeleGatorImpl: "0x5989F5D13DF8fc818EdA65e417AED90459fD67F7"
    }
  },
  "1.1.0": {
    // Mainnets
    [CHAIN_ID.arbitrum]: deployments_1_1_0,
    [CHAIN_ID.base]: deployments_1_1_0,
    [CHAIN_ID.linea]: deployments_1_1_0,
    [CHAIN_ID.optimism]: deployments_1_1_0,
    [CHAIN_ID.polygon]: deployments_1_1_0,
    // Testnets
    [CHAIN_ID.sepolia]: deployments_1_1_0,
    [CHAIN_ID.lineaSepolia]: deployments_1_1_0,
    [CHAIN_ID.baseSepolia]: {
      ...deployments_1_1_0,
      SimpleFactory: "0xE8eA1DE8D6AfE400B7C8C1A81B7C29B7876b4d02"
    }
  },
  "1.3.0": {
    // Mainnets
    [CHAIN_ID.mainnet]: deployments_1_3_0,
    [CHAIN_ID.polygon]: deployments_1_3_0,
    [CHAIN_ID.bsc]: deployments_1_3_0,
    [CHAIN_ID.optimism]: deployments_1_3_0,
    [CHAIN_ID.arbitrum]: deployments_1_3_0,
    [CHAIN_ID.linea]: deployments_1_3_0,
    [CHAIN_ID.base]: deployments_1_3_0,
    [CHAIN_ID.gnosis]: deployments_1_3_0,
    [CHAIN_ID.berachain]: deployments_1_3_0,
    [CHAIN_ID.unichain]: deployments_1_3_0,
    [CHAIN_ID.arbitrumNova]: deployments_1_3_0,
    // Testnets
    [CHAIN_ID.sepolia]: deployments_1_3_0,
    [CHAIN_ID.lineaSepolia]: deployments_1_3_0,
    [CHAIN_ID.baseSepolia]: deployments_1_3_0,
    [CHAIN_ID.megaEthTestnet]: deployments_1_3_0,
    [CHAIN_ID.chiado]: deployments_1_3_0,
    [CHAIN_ID.bscTestnet]: deployments_1_3_0,
    [CHAIN_ID.optimismSepolia]: deployments_1_3_0,
    [CHAIN_ID.arbitrumSepolia]: deployments_1_3_0,
    [CHAIN_ID.berachainBepolia]: deployments_1_3_0,
    [CHAIN_ID.unichainSepolia]: deployments_1_3_0,
    [CHAIN_ID.polygonAmoy]: deployments_1_3_0,
    [CHAIN_ID.monadTestnet]: deployments_1_3_0
  }
};



exports.CHAIN_ID = CHAIN_ID; exports.DELEGATOR_CONTRACTS = DELEGATOR_CONTRACTS;

      };
    };
  }
  }
}, {package:"@metamask/gator-permissions-controller>@metamask/delegation-deployments",file:"node_modules\\@metamask\\gator-permissions-controller\\node_modules\\@metamask\\delegation-deployments\\dist\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\jazzicon\\colors.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cjazzicon%5Ccolors.js
      return function (require, module, exports) {
module.exports = [
	'#01888C', // teal
  '#FC7500', // bright orange
  '#034F5D', // dark teal
  '#F73F01', // orangered
  '#FC1960', // magenta
  '#C7144C', // raspberry
  '#F3C100', // goldenrod
  '#1598F2', // lightning blue
  '#2465E1', // sail blue
  '#F19E02', // gold
]

      };
    };
  }
  }
}, {package:"@metamask/jazzicon",file:"node_modules\\@metamask\\jazzicon\\colors.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\jazzicon\\index.js", {"./colors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\jazzicon\\colors.js","./paper":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\jazzicon\\paper.js","color":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\jazzicon\\node_modules\\color\\index.js","mersenne-twister":"D:\\code\\v\\metamask-extension\\node_modules\\mersenne-twister\\src\\mersenne-twister.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cjazzicon%5Cindex.js
      return function (require, module, exports) {
var MersenneTwister = require('mersenne-twister');
var paperGen = require('./paper')
var Color = require('color')
var colors = require('./colors')
var shapeCount = 4
var svgns = 'http://www.w3.org/2000/svg'

module.exports = generateIdenticon

var generator
function generateIdenticon(diameter, seed) {
  generator = new MersenneTwister(seed);
  var remainingColors = hueShift(colors.slice(), generator)

  var elements = paperGen(diameter, genColor(remainingColors))
  var container = elements.container

  var svg = document.createElementNS(svgns, 'svg')
  svg.setAttributeNS(null, 'x', '0')
  svg.setAttributeNS(null, 'y', '0')
  svg.setAttributeNS(null, 'width', diameter)
  svg.setAttributeNS(null, 'height', diameter)

  container.appendChild(svg)

  for(var i = 0; i < shapeCount - 1; i++) {
    genShape(remainingColors, diameter, i, shapeCount - 1, svg)
  }

  return container
}

function genShape(remainingColors, diameter, i, total, svg) {
  var center = diameter / 2

  var shape = document.createElementNS(svgns, 'rect')
  shape.setAttributeNS(null, 'x', '0')
  shape.setAttributeNS(null, 'y', '0')
  shape.setAttributeNS(null, 'width', diameter)
  shape.setAttributeNS(null, 'height', diameter)

  var firstRot = generator.random()
  var angle = Math.PI * 2 * firstRot
  var velocity = diameter / total * generator.random() + (i * diameter / total)

  var tx = (Math.cos(angle) * velocity)
  var ty = (Math.sin(angle) * velocity)

  // Prevent rounding errors, which causes intermittent failures when running Jest snapshot tests
  var translate = 'translate(' + tx.toFixed(14) + ' ' +  ty.toFixed(14) + ')'

  // Third random is a shape rotation on top of all of that.
  var secondRot = generator.random()
  var rot = (firstRot * 360) + secondRot * 180
  // Prevent rounding errors, which causes intermittent failures when running Jest snapshot tests
  var rotate = 'rotate(' + rot.toFixed(1) + ' ' + center.toFixed(14) + ' ' + center.toFixed(14) + ')'
  var transform = translate + ' ' + rotate
  shape.setAttributeNS(null, 'transform', transform)
  var fill = genColor(remainingColors)
  shape.setAttributeNS(null, 'fill', fill)

  svg.appendChild(shape)
}

function genColor(colors) {
  var rand = generator.random()
  var idx = Math.floor(colors.length * generator.random())
  var color = colors.splice(idx,1)[0]
  return color
}

var wobble = 30
function hueShift(colors, generator) {
  var amount = (generator.random() * 30) - (wobble / 2)
  return colors.map(function(hex) {
    var color = Color(hex)
    color.rotate(amount)
    return color.hexString()
  })
}

      };
    };
  }
  }
}, {package:"@metamask/jazzicon",file:"node_modules\\@metamask\\jazzicon\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\jazzicon\\node_modules\\color-convert\\conversions.js", {"color-name":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\jazzicon\\node_modules\\color-name\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cjazzicon%5Cnode_modules%5Ccolor-convert%5Cconversions.js
      return function (require, module, exports) {
/* MIT license */
var cssKeywords = require('color-name');

// NOTE: conversions should only return primitive values (i.e. arrays, or
//       values that give correct `typeof` results).
//       do not use box values types (i.e. Number(), String(), etc.)

var reverseKeywords = {};
for (var key in cssKeywords) {
	if (cssKeywords.hasOwnProperty(key)) {
		reverseKeywords[cssKeywords[key]] = key;
	}
}

var convert = module.exports = {
	rgb: {channels: 3, labels: 'rgb'},
	hsl: {channels: 3, labels: 'hsl'},
	hsv: {channels: 3, labels: 'hsv'},
	hwb: {channels: 3, labels: 'hwb'},
	cmyk: {channels: 4, labels: 'cmyk'},
	xyz: {channels: 3, labels: 'xyz'},
	lab: {channels: 3, labels: 'lab'},
	lch: {channels: 3, labels: 'lch'},
	hex: {channels: 1, labels: ['hex']},
	keyword: {channels: 1, labels: ['keyword']},
	ansi16: {channels: 1, labels: ['ansi16']},
	ansi256: {channels: 1, labels: ['ansi256']},
	hcg: {channels: 3, labels: ['h', 'c', 'g']},
	apple: {channels: 3, labels: ['r16', 'g16', 'b16']},
	gray: {channels: 1, labels: ['gray']}
};

// hide .channels and .labels properties
for (var model in convert) {
	if (convert.hasOwnProperty(model)) {
		if (!('channels' in convert[model])) {
			throw new Error('missing channels property: ' + model);
		}

		if (!('labels' in convert[model])) {
			throw new Error('missing channel labels property: ' + model);
		}

		if (convert[model].labels.length !== convert[model].channels) {
			throw new Error('channel and label counts mismatch: ' + model);
		}

		var channels = convert[model].channels;
		var labels = convert[model].labels;
		delete convert[model].channels;
		delete convert[model].labels;
		Object.defineProperty(convert[model], 'channels', {value: channels});
		Object.defineProperty(convert[model], 'labels', {value: labels});
	}
}

convert.rgb.hsl = function (rgb) {
	var r = rgb[0] / 255;
	var g = rgb[1] / 255;
	var b = rgb[2] / 255;
	var min = Math.min(r, g, b);
	var max = Math.max(r, g, b);
	var delta = max - min;
	var h;
	var s;
	var l;

	if (max === min) {
		h = 0;
	} else if (r === max) {
		h = (g - b) / delta;
	} else if (g === max) {
		h = 2 + (b - r) / delta;
	} else if (b === max) {
		h = 4 + (r - g) / delta;
	}

	h = Math.min(h * 60, 360);

	if (h < 0) {
		h += 360;
	}

	l = (min + max) / 2;

	if (max === min) {
		s = 0;
	} else if (l <= 0.5) {
		s = delta / (max + min);
	} else {
		s = delta / (2 - max - min);
	}

	return [h, s * 100, l * 100];
};

convert.rgb.hsv = function (rgb) {
	var rdif;
	var gdif;
	var bdif;
	var h;
	var s;

	var r = rgb[0] / 255;
	var g = rgb[1] / 255;
	var b = rgb[2] / 255;
	var v = Math.max(r, g, b);
	var diff = v - Math.min(r, g, b);
	var diffc = function (c) {
		return (v - c) / 6 / diff + 1 / 2;
	};

	if (diff === 0) {
		h = s = 0;
	} else {
		s = diff / v;
		rdif = diffc(r);
		gdif = diffc(g);
		bdif = diffc(b);

		if (r === v) {
			h = bdif - gdif;
		} else if (g === v) {
			h = (1 / 3) + rdif - bdif;
		} else if (b === v) {
			h = (2 / 3) + gdif - rdif;
		}
		if (h < 0) {
			h += 1;
		} else if (h > 1) {
			h -= 1;
		}
	}

	return [
		h * 360,
		s * 100,
		v * 100
	];
};

convert.rgb.hwb = function (rgb) {
	var r = rgb[0];
	var g = rgb[1];
	var b = rgb[2];
	var h = convert.rgb.hsl(rgb)[0];
	var w = 1 / 255 * Math.min(r, Math.min(g, b));

	b = 1 - 1 / 255 * Math.max(r, Math.max(g, b));

	return [h, w * 100, b * 100];
};

convert.rgb.cmyk = function (rgb) {
	var r = rgb[0] / 255;
	var g = rgb[1] / 255;
	var b = rgb[2] / 255;
	var c;
	var m;
	var y;
	var k;

	k = Math.min(1 - r, 1 - g, 1 - b);
	c = (1 - r - k) / (1 - k) || 0;
	m = (1 - g - k) / (1 - k) || 0;
	y = (1 - b - k) / (1 - k) || 0;

	return [c * 100, m * 100, y * 100, k * 100];
};

/**
 * See https://en.m.wikipedia.org/wiki/Euclidean_distance#Squared_Euclidean_distance
 * */
function comparativeDistance(x, y) {
	return (
		Math.pow(x[0] - y[0], 2) +
		Math.pow(x[1] - y[1], 2) +
		Math.pow(x[2] - y[2], 2)
	);
}

convert.rgb.keyword = function (rgb) {
	var reversed = reverseKeywords[rgb];
	if (reversed) {
		return reversed;
	}

	var currentClosestDistance = Infinity;
	var currentClosestKeyword;

	for (var keyword in cssKeywords) {
		if (cssKeywords.hasOwnProperty(keyword)) {
			var value = cssKeywords[keyword];

			// Compute comparative distance
			var distance = comparativeDistance(rgb, value);

			// Check if its less, if so set as closest
			if (distance < currentClosestDistance) {
				currentClosestDistance = distance;
				currentClosestKeyword = keyword;
			}
		}
	}

	return currentClosestKeyword;
};

convert.keyword.rgb = function (keyword) {
	return cssKeywords[keyword];
};

convert.rgb.xyz = function (rgb) {
	var r = rgb[0] / 255;
	var g = rgb[1] / 255;
	var b = rgb[2] / 255;

	// assume sRGB
	r = r > 0.04045 ? Math.pow(((r + 0.055) / 1.055), 2.4) : (r / 12.92);
	g = g > 0.04045 ? Math.pow(((g + 0.055) / 1.055), 2.4) : (g / 12.92);
	b = b > 0.04045 ? Math.pow(((b + 0.055) / 1.055), 2.4) : (b / 12.92);

	var x = (r * 0.4124) + (g * 0.3576) + (b * 0.1805);
	var y = (r * 0.2126) + (g * 0.7152) + (b * 0.0722);
	var z = (r * 0.0193) + (g * 0.1192) + (b * 0.9505);

	return [x * 100, y * 100, z * 100];
};

convert.rgb.lab = function (rgb) {
	var xyz = convert.rgb.xyz(rgb);
	var x = xyz[0];
	var y = xyz[1];
	var z = xyz[2];
	var l;
	var a;
	var b;

	x /= 95.047;
	y /= 100;
	z /= 108.883;

	x = x > 0.008856 ? Math.pow(x, 1 / 3) : (7.787 * x) + (16 / 116);
	y = y > 0.008856 ? Math.pow(y, 1 / 3) : (7.787 * y) + (16 / 116);
	z = z > 0.008856 ? Math.pow(z, 1 / 3) : (7.787 * z) + (16 / 116);

	l = (116 * y) - 16;
	a = 500 * (x - y);
	b = 200 * (y - z);

	return [l, a, b];
};

convert.hsl.rgb = function (hsl) {
	var h = hsl[0] / 360;
	var s = hsl[1] / 100;
	var l = hsl[2] / 100;
	var t1;
	var t2;
	var t3;
	var rgb;
	var val;

	if (s === 0) {
		val = l * 255;
		return [val, val, val];
	}

	if (l < 0.5) {
		t2 = l * (1 + s);
	} else {
		t2 = l + s - l * s;
	}

	t1 = 2 * l - t2;

	rgb = [0, 0, 0];
	for (var i = 0; i < 3; i++) {
		t3 = h + 1 / 3 * -(i - 1);
		if (t3 < 0) {
			t3++;
		}
		if (t3 > 1) {
			t3--;
		}

		if (6 * t3 < 1) {
			val = t1 + (t2 - t1) * 6 * t3;
		} else if (2 * t3 < 1) {
			val = t2;
		} else if (3 * t3 < 2) {
			val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;
		} else {
			val = t1;
		}

		rgb[i] = val * 255;
	}

	return rgb;
};

convert.hsl.hsv = function (hsl) {
	var h = hsl[0];
	var s = hsl[1] / 100;
	var l = hsl[2] / 100;
	var smin = s;
	var lmin = Math.max(l, 0.01);
	var sv;
	var v;

	l *= 2;
	s *= (l <= 1) ? l : 2 - l;
	smin *= lmin <= 1 ? lmin : 2 - lmin;
	v = (l + s) / 2;
	sv = l === 0 ? (2 * smin) / (lmin + smin) : (2 * s) / (l + s);

	return [h, sv * 100, v * 100];
};

convert.hsv.rgb = function (hsv) {
	var h = hsv[0] / 60;
	var s = hsv[1] / 100;
	var v = hsv[2] / 100;
	var hi = Math.floor(h) % 6;

	var f = h - Math.floor(h);
	var p = 255 * v * (1 - s);
	var q = 255 * v * (1 - (s * f));
	var t = 255 * v * (1 - (s * (1 - f)));
	v *= 255;

	switch (hi) {
		case 0:
			return [v, t, p];
		case 1:
			return [q, v, p];
		case 2:
			return [p, v, t];
		case 3:
			return [p, q, v];
		case 4:
			return [t, p, v];
		case 5:
			return [v, p, q];
	}
};

convert.hsv.hsl = function (hsv) {
	var h = hsv[0];
	var s = hsv[1] / 100;
	var v = hsv[2] / 100;
	var vmin = Math.max(v, 0.01);
	var lmin;
	var sl;
	var l;

	l = (2 - s) * v;
	lmin = (2 - s) * vmin;
	sl = s * vmin;
	sl /= (lmin <= 1) ? lmin : 2 - lmin;
	sl = sl || 0;
	l /= 2;

	return [h, sl * 100, l * 100];
};

// http://dev.w3.org/csswg/css-color/#hwb-to-rgb
convert.hwb.rgb = function (hwb) {
	var h = hwb[0] / 360;
	var wh = hwb[1] / 100;
	var bl = hwb[2] / 100;
	var ratio = wh + bl;
	var i;
	var v;
	var f;
	var n;

	// wh + bl cant be > 1
	if (ratio > 1) {
		wh /= ratio;
		bl /= ratio;
	}

	i = Math.floor(6 * h);
	v = 1 - bl;
	f = 6 * h - i;

	if ((i & 0x01) !== 0) {
		f = 1 - f;
	}

	n = wh + f * (v - wh); // linear interpolation

	var r;
	var g;
	var b;
	switch (i) {
		default:
		case 6:
		case 0: r = v; g = n; b = wh; break;
		case 1: r = n; g = v; b = wh; break;
		case 2: r = wh; g = v; b = n; break;
		case 3: r = wh; g = n; b = v; break;
		case 4: r = n; g = wh; b = v; break;
		case 5: r = v; g = wh; b = n; break;
	}

	return [r * 255, g * 255, b * 255];
};

convert.cmyk.rgb = function (cmyk) {
	var c = cmyk[0] / 100;
	var m = cmyk[1] / 100;
	var y = cmyk[2] / 100;
	var k = cmyk[3] / 100;
	var r;
	var g;
	var b;

	r = 1 - Math.min(1, c * (1 - k) + k);
	g = 1 - Math.min(1, m * (1 - k) + k);
	b = 1 - Math.min(1, y * (1 - k) + k);

	return [r * 255, g * 255, b * 255];
};

convert.xyz.rgb = function (xyz) {
	var x = xyz[0] / 100;
	var y = xyz[1] / 100;
	var z = xyz[2] / 100;
	var r;
	var g;
	var b;

	r = (x * 3.2406) + (y * -1.5372) + (z * -0.4986);
	g = (x * -0.9689) + (y * 1.8758) + (z * 0.0415);
	b = (x * 0.0557) + (y * -0.2040) + (z * 1.0570);

	// assume sRGB
	r = r > 0.0031308
		? ((1.055 * Math.pow(r, 1.0 / 2.4)) - 0.055)
		: r * 12.92;

	g = g > 0.0031308
		? ((1.055 * Math.pow(g, 1.0 / 2.4)) - 0.055)
		: g * 12.92;

	b = b > 0.0031308
		? ((1.055 * Math.pow(b, 1.0 / 2.4)) - 0.055)
		: b * 12.92;

	r = Math.min(Math.max(0, r), 1);
	g = Math.min(Math.max(0, g), 1);
	b = Math.min(Math.max(0, b), 1);

	return [r * 255, g * 255, b * 255];
};

convert.xyz.lab = function (xyz) {
	var x = xyz[0];
	var y = xyz[1];
	var z = xyz[2];
	var l;
	var a;
	var b;

	x /= 95.047;
	y /= 100;
	z /= 108.883;

	x = x > 0.008856 ? Math.pow(x, 1 / 3) : (7.787 * x) + (16 / 116);
	y = y > 0.008856 ? Math.pow(y, 1 / 3) : (7.787 * y) + (16 / 116);
	z = z > 0.008856 ? Math.pow(z, 1 / 3) : (7.787 * z) + (16 / 116);

	l = (116 * y) - 16;
	a = 500 * (x - y);
	b = 200 * (y - z);

	return [l, a, b];
};

convert.lab.xyz = function (lab) {
	var l = lab[0];
	var a = lab[1];
	var b = lab[2];
	var x;
	var y;
	var z;

	y = (l + 16) / 116;
	x = a / 500 + y;
	z = y - b / 200;

	var y2 = Math.pow(y, 3);
	var x2 = Math.pow(x, 3);
	var z2 = Math.pow(z, 3);
	y = y2 > 0.008856 ? y2 : (y - 16 / 116) / 7.787;
	x = x2 > 0.008856 ? x2 : (x - 16 / 116) / 7.787;
	z = z2 > 0.008856 ? z2 : (z - 16 / 116) / 7.787;

	x *= 95.047;
	y *= 100;
	z *= 108.883;

	return [x, y, z];
};

convert.lab.lch = function (lab) {
	var l = lab[0];
	var a = lab[1];
	var b = lab[2];
	var hr;
	var h;
	var c;

	hr = Math.atan2(b, a);
	h = hr * 360 / 2 / Math.PI;

	if (h < 0) {
		h += 360;
	}

	c = Math.sqrt(a * a + b * b);

	return [l, c, h];
};

convert.lch.lab = function (lch) {
	var l = lch[0];
	var c = lch[1];
	var h = lch[2];
	var a;
	var b;
	var hr;

	hr = h / 360 * 2 * Math.PI;
	a = c * Math.cos(hr);
	b = c * Math.sin(hr);

	return [l, a, b];
};

convert.rgb.ansi16 = function (args) {
	var r = args[0];
	var g = args[1];
	var b = args[2];
	var value = 1 in arguments ? arguments[1] : convert.rgb.hsv(args)[2]; // hsv -> ansi16 optimization

	value = Math.round(value / 50);

	if (value === 0) {
		return 30;
	}

	var ansi = 30
		+ ((Math.round(b / 255) << 2)
		| (Math.round(g / 255) << 1)
		| Math.round(r / 255));

	if (value === 2) {
		ansi += 60;
	}

	return ansi;
};

convert.hsv.ansi16 = function (args) {
	// optimization here; we already know the value and don't need to get
	// it converted for us.
	return convert.rgb.ansi16(convert.hsv.rgb(args), args[2]);
};

convert.rgb.ansi256 = function (args) {
	var r = args[0];
	var g = args[1];
	var b = args[2];

	// we use the extended greyscale palette here, with the exception of
	// black and white. normal palette only has 4 greyscale shades.
	if (r === g && g === b) {
		if (r < 8) {
			return 16;
		}

		if (r > 248) {
			return 231;
		}

		return Math.round(((r - 8) / 247) * 24) + 232;
	}

	var ansi = 16
		+ (36 * Math.round(r / 255 * 5))
		+ (6 * Math.round(g / 255 * 5))
		+ Math.round(b / 255 * 5);

	return ansi;
};

convert.ansi16.rgb = function (args) {
	var color = args % 10;

	// handle greyscale
	if (color === 0 || color === 7) {
		if (args > 50) {
			color += 3.5;
		}

		color = color / 10.5 * 255;

		return [color, color, color];
	}

	var mult = (~~(args > 50) + 1) * 0.5;
	var r = ((color & 1) * mult) * 255;
	var g = (((color >> 1) & 1) * mult) * 255;
	var b = (((color >> 2) & 1) * mult) * 255;

	return [r, g, b];
};

convert.ansi256.rgb = function (args) {
	// handle greyscale
	if (args >= 232) {
		var c = (args - 232) * 10 + 8;
		return [c, c, c];
	}

	args -= 16;

	var rem;
	var r = Math.floor(args / 36) / 5 * 255;
	var g = Math.floor((rem = args % 36) / 6) / 5 * 255;
	var b = (rem % 6) / 5 * 255;

	return [r, g, b];
};

convert.rgb.hex = function (args) {
	var integer = ((Math.round(args[0]) & 0xFF) << 16)
		+ ((Math.round(args[1]) & 0xFF) << 8)
		+ (Math.round(args[2]) & 0xFF);

	var string = integer.toString(16).toUpperCase();
	return '000000'.substring(string.length) + string;
};

convert.hex.rgb = function (args) {
	var match = args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);
	if (!match) {
		return [0, 0, 0];
	}

	var colorString = match[0];

	if (match[0].length === 3) {
		colorString = colorString.split('').map(function (char) {
			return char + char;
		}).join('');
	}

	var integer = parseInt(colorString, 16);
	var r = (integer >> 16) & 0xFF;
	var g = (integer >> 8) & 0xFF;
	var b = integer & 0xFF;

	return [r, g, b];
};

convert.rgb.hcg = function (rgb) {
	var r = rgb[0] / 255;
	var g = rgb[1] / 255;
	var b = rgb[2] / 255;
	var max = Math.max(Math.max(r, g), b);
	var min = Math.min(Math.min(r, g), b);
	var chroma = (max - min);
	var grayscale;
	var hue;

	if (chroma < 1) {
		grayscale = min / (1 - chroma);
	} else {
		grayscale = 0;
	}

	if (chroma <= 0) {
		hue = 0;
	} else
	if (max === r) {
		hue = ((g - b) / chroma) % 6;
	} else
	if (max === g) {
		hue = 2 + (b - r) / chroma;
	} else {
		hue = 4 + (r - g) / chroma + 4;
	}

	hue /= 6;
	hue %= 1;

	return [hue * 360, chroma * 100, grayscale * 100];
};

convert.hsl.hcg = function (hsl) {
	var s = hsl[1] / 100;
	var l = hsl[2] / 100;
	var c = 1;
	var f = 0;

	if (l < 0.5) {
		c = 2.0 * s * l;
	} else {
		c = 2.0 * s * (1.0 - l);
	}

	if (c < 1.0) {
		f = (l - 0.5 * c) / (1.0 - c);
	}

	return [hsl[0], c * 100, f * 100];
};

convert.hsv.hcg = function (hsv) {
	var s = hsv[1] / 100;
	var v = hsv[2] / 100;

	var c = s * v;
	var f = 0;

	if (c < 1.0) {
		f = (v - c) / (1 - c);
	}

	return [hsv[0], c * 100, f * 100];
};

convert.hcg.rgb = function (hcg) {
	var h = hcg[0] / 360;
	var c = hcg[1] / 100;
	var g = hcg[2] / 100;

	if (c === 0.0) {
		return [g * 255, g * 255, g * 255];
	}

	var pure = [0, 0, 0];
	var hi = (h % 1) * 6;
	var v = hi % 1;
	var w = 1 - v;
	var mg = 0;

	switch (Math.floor(hi)) {
		case 0:
			pure[0] = 1; pure[1] = v; pure[2] = 0; break;
		case 1:
			pure[0] = w; pure[1] = 1; pure[2] = 0; break;
		case 2:
			pure[0] = 0; pure[1] = 1; pure[2] = v; break;
		case 3:
			pure[0] = 0; pure[1] = w; pure[2] = 1; break;
		case 4:
			pure[0] = v; pure[1] = 0; pure[2] = 1; break;
		default:
			pure[0] = 1; pure[1] = 0; pure[2] = w;
	}

	mg = (1.0 - c) * g;

	return [
		(c * pure[0] + mg) * 255,
		(c * pure[1] + mg) * 255,
		(c * pure[2] + mg) * 255
	];
};

convert.hcg.hsv = function (hcg) {
	var c = hcg[1] / 100;
	var g = hcg[2] / 100;

	var v = c + g * (1.0 - c);
	var f = 0;

	if (v > 0.0) {
		f = c / v;
	}

	return [hcg[0], f * 100, v * 100];
};

convert.hcg.hsl = function (hcg) {
	var c = hcg[1] / 100;
	var g = hcg[2] / 100;

	var l = g * (1.0 - c) + 0.5 * c;
	var s = 0;

	if (l > 0.0 && l < 0.5) {
		s = c / (2 * l);
	} else
	if (l >= 0.5 && l < 1.0) {
		s = c / (2 * (1 - l));
	}

	return [hcg[0], s * 100, l * 100];
};

convert.hcg.hwb = function (hcg) {
	var c = hcg[1] / 100;
	var g = hcg[2] / 100;
	var v = c + g * (1.0 - c);
	return [hcg[0], (v - c) * 100, (1 - v) * 100];
};

convert.hwb.hcg = function (hwb) {
	var w = hwb[1] / 100;
	var b = hwb[2] / 100;
	var v = 1 - b;
	var c = v - w;
	var g = 0;

	if (c < 1) {
		g = (v - c) / (1 - c);
	}

	return [hwb[0], c * 100, g * 100];
};

convert.apple.rgb = function (apple) {
	return [(apple[0] / 65535) * 255, (apple[1] / 65535) * 255, (apple[2] / 65535) * 255];
};

convert.rgb.apple = function (rgb) {
	return [(rgb[0] / 255) * 65535, (rgb[1] / 255) * 65535, (rgb[2] / 255) * 65535];
};

convert.gray.rgb = function (args) {
	return [args[0] / 100 * 255, args[0] / 100 * 255, args[0] / 100 * 255];
};

convert.gray.hsl = convert.gray.hsv = function (args) {
	return [0, 0, args[0]];
};

convert.gray.hwb = function (gray) {
	return [0, 100, gray[0]];
};

convert.gray.cmyk = function (gray) {
	return [0, 0, 0, gray[0]];
};

convert.gray.lab = function (gray) {
	return [gray[0], 0, 0];
};

convert.gray.hex = function (gray) {
	var val = Math.round(gray[0] / 100 * 255) & 0xFF;
	var integer = (val << 16) + (val << 8) + val;

	var string = integer.toString(16).toUpperCase();
	return '000000'.substring(string.length) + string;
};

convert.rgb.gray = function (rgb) {
	var val = (rgb[0] + rgb[1] + rgb[2]) / 3;
	return [val / 255 * 100];
};

      };
    };
  }
  }
}, {package:"@metamask/jazzicon>color>color-convert",file:"node_modules\\@metamask\\jazzicon\\node_modules\\color-convert\\conversions.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\jazzicon\\node_modules\\color-convert\\index.js", {"./conversions":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\jazzicon\\node_modules\\color-convert\\conversions.js","./route":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\jazzicon\\node_modules\\color-convert\\route.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cjazzicon%5Cnode_modules%5Ccolor-convert%5Cindex.js
      return function (require, module, exports) {
var conversions = require('./conversions');
var route = require('./route');

var convert = {};

var models = Object.keys(conversions);

function wrapRaw(fn) {
	var wrappedFn = function (args) {
		if (args === undefined || args === null) {
			return args;
		}

		if (arguments.length > 1) {
			args = Array.prototype.slice.call(arguments);
		}

		return fn(args);
	};

	// preserve .conversion property if there is one
	if ('conversion' in fn) {
		wrappedFn.conversion = fn.conversion;
	}

	return wrappedFn;
}

function wrapRounded(fn) {
	var wrappedFn = function (args) {
		if (args === undefined || args === null) {
			return args;
		}

		if (arguments.length > 1) {
			args = Array.prototype.slice.call(arguments);
		}

		var result = fn(args);

		// we're assuming the result is an array here.
		// see notice in conversions.js; don't use box types
		// in conversion functions.
		if (typeof result === 'object') {
			for (var len = result.length, i = 0; i < len; i++) {
				result[i] = Math.round(result[i]);
			}
		}

		return result;
	};

	// preserve .conversion property if there is one
	if ('conversion' in fn) {
		wrappedFn.conversion = fn.conversion;
	}

	return wrappedFn;
}

models.forEach(function (fromModel) {
	convert[fromModel] = {};

	Object.defineProperty(convert[fromModel], 'channels', {value: conversions[fromModel].channels});
	Object.defineProperty(convert[fromModel], 'labels', {value: conversions[fromModel].labels});

	var routes = route(fromModel);
	var routeModels = Object.keys(routes);

	routeModels.forEach(function (toModel) {
		var fn = routes[toModel];

		convert[fromModel][toModel] = wrapRounded(fn);
		convert[fromModel][toModel].raw = wrapRaw(fn);
	});
});

module.exports = convert;

      };
    };
  }
  }
}, {package:"@metamask/jazzicon>color>color-convert",file:"node_modules\\@metamask\\jazzicon\\node_modules\\color-convert\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\jazzicon\\node_modules\\color-convert\\route.js", {"./conversions":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\jazzicon\\node_modules\\color-convert\\conversions.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cjazzicon%5Cnode_modules%5Ccolor-convert%5Croute.js
      return function (require, module, exports) {
var conversions = require('./conversions');

/*
	this function routes a model to all other models.

	all functions that are routed have a property `.conversion` attached
	to the returned synthetic function. This property is an array
	of strings, each with the steps in between the 'from' and 'to'
	color models (inclusive).

	conversions that are not possible simply are not included.
*/

function buildGraph() {
	var graph = {};
	// https://jsperf.com/object-keys-vs-for-in-with-closure/3
	var models = Object.keys(conversions);

	for (var len = models.length, i = 0; i < len; i++) {
		graph[models[i]] = {
			// http://jsperf.com/1-vs-infinity
			// micro-opt, but this is simple.
			distance: -1,
			parent: null
		};
	}

	return graph;
}

// https://en.wikipedia.org/wiki/Breadth-first_search
function deriveBFS(fromModel) {
	var graph = buildGraph();
	var queue = [fromModel]; // unshift -> queue -> pop

	graph[fromModel].distance = 0;

	while (queue.length) {
		var current = queue.pop();
		var adjacents = Object.keys(conversions[current]);

		for (var len = adjacents.length, i = 0; i < len; i++) {
			var adjacent = adjacents[i];
			var node = graph[adjacent];

			if (node.distance === -1) {
				node.distance = graph[current].distance + 1;
				node.parent = current;
				queue.unshift(adjacent);
			}
		}
	}

	return graph;
}

function link(from, to) {
	return function (args) {
		return to(from(args));
	};
}

function wrapConversion(toModel, graph) {
	var path = [graph[toModel].parent, toModel];
	var fn = conversions[graph[toModel].parent][toModel];

	var cur = graph[toModel].parent;
	while (graph[cur].parent) {
		path.unshift(graph[cur].parent);
		fn = link(conversions[graph[cur].parent][cur], fn);
		cur = graph[cur].parent;
	}

	fn.conversion = path;
	return fn;
}

module.exports = function (fromModel) {
	var graph = deriveBFS(fromModel);
	var conversion = {};

	var models = Object.keys(graph);
	for (var len = models.length, i = 0; i < len; i++) {
		var toModel = models[i];
		var node = graph[toModel];

		if (node.parent === null) {
			// no possible conversion, or this node is the source model.
			continue;
		}

		conversion[toModel] = wrapConversion(toModel, graph);
	}

	return conversion;
};


      };
    };
  }
  }
}, {package:"@metamask/jazzicon>color>color-convert",file:"node_modules\\@metamask\\jazzicon\\node_modules\\color-convert\\route.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\jazzicon\\node_modules\\color-name\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cjazzicon%5Cnode_modules%5Ccolor-name%5Cindex.js
      return function (require, module, exports) {
'use strict'

module.exports = {
	"aliceblue": [240, 248, 255],
	"antiquewhite": [250, 235, 215],
	"aqua": [0, 255, 255],
	"aquamarine": [127, 255, 212],
	"azure": [240, 255, 255],
	"beige": [245, 245, 220],
	"bisque": [255, 228, 196],
	"black": [0, 0, 0],
	"blanchedalmond": [255, 235, 205],
	"blue": [0, 0, 255],
	"blueviolet": [138, 43, 226],
	"brown": [165, 42, 42],
	"burlywood": [222, 184, 135],
	"cadetblue": [95, 158, 160],
	"chartreuse": [127, 255, 0],
	"chocolate": [210, 105, 30],
	"coral": [255, 127, 80],
	"cornflowerblue": [100, 149, 237],
	"cornsilk": [255, 248, 220],
	"crimson": [220, 20, 60],
	"cyan": [0, 255, 255],
	"darkblue": [0, 0, 139],
	"darkcyan": [0, 139, 139],
	"darkgoldenrod": [184, 134, 11],
	"darkgray": [169, 169, 169],
	"darkgreen": [0, 100, 0],
	"darkgrey": [169, 169, 169],
	"darkkhaki": [189, 183, 107],
	"darkmagenta": [139, 0, 139],
	"darkolivegreen": [85, 107, 47],
	"darkorange": [255, 140, 0],
	"darkorchid": [153, 50, 204],
	"darkred": [139, 0, 0],
	"darksalmon": [233, 150, 122],
	"darkseagreen": [143, 188, 143],
	"darkslateblue": [72, 61, 139],
	"darkslategray": [47, 79, 79],
	"darkslategrey": [47, 79, 79],
	"darkturquoise": [0, 206, 209],
	"darkviolet": [148, 0, 211],
	"deeppink": [255, 20, 147],
	"deepskyblue": [0, 191, 255],
	"dimgray": [105, 105, 105],
	"dimgrey": [105, 105, 105],
	"dodgerblue": [30, 144, 255],
	"firebrick": [178, 34, 34],
	"floralwhite": [255, 250, 240],
	"forestgreen": [34, 139, 34],
	"fuchsia": [255, 0, 255],
	"gainsboro": [220, 220, 220],
	"ghostwhite": [248, 248, 255],
	"gold": [255, 215, 0],
	"goldenrod": [218, 165, 32],
	"gray": [128, 128, 128],
	"green": [0, 128, 0],
	"greenyellow": [173, 255, 47],
	"grey": [128, 128, 128],
	"honeydew": [240, 255, 240],
	"hotpink": [255, 105, 180],
	"indianred": [205, 92, 92],
	"indigo": [75, 0, 130],
	"ivory": [255, 255, 240],
	"khaki": [240, 230, 140],
	"lavender": [230, 230, 250],
	"lavenderblush": [255, 240, 245],
	"lawngreen": [124, 252, 0],
	"lemonchiffon": [255, 250, 205],
	"lightblue": [173, 216, 230],
	"lightcoral": [240, 128, 128],
	"lightcyan": [224, 255, 255],
	"lightgoldenrodyellow": [250, 250, 210],
	"lightgray": [211, 211, 211],
	"lightgreen": [144, 238, 144],
	"lightgrey": [211, 211, 211],
	"lightpink": [255, 182, 193],
	"lightsalmon": [255, 160, 122],
	"lightseagreen": [32, 178, 170],
	"lightskyblue": [135, 206, 250],
	"lightslategray": [119, 136, 153],
	"lightslategrey": [119, 136, 153],
	"lightsteelblue": [176, 196, 222],
	"lightyellow": [255, 255, 224],
	"lime": [0, 255, 0],
	"limegreen": [50, 205, 50],
	"linen": [250, 240, 230],
	"magenta": [255, 0, 255],
	"maroon": [128, 0, 0],
	"mediumaquamarine": [102, 205, 170],
	"mediumblue": [0, 0, 205],
	"mediumorchid": [186, 85, 211],
	"mediumpurple": [147, 112, 219],
	"mediumseagreen": [60, 179, 113],
	"mediumslateblue": [123, 104, 238],
	"mediumspringgreen": [0, 250, 154],
	"mediumturquoise": [72, 209, 204],
	"mediumvioletred": [199, 21, 133],
	"midnightblue": [25, 25, 112],
	"mintcream": [245, 255, 250],
	"mistyrose": [255, 228, 225],
	"moccasin": [255, 228, 181],
	"navajowhite": [255, 222, 173],
	"navy": [0, 0, 128],
	"oldlace": [253, 245, 230],
	"olive": [128, 128, 0],
	"olivedrab": [107, 142, 35],
	"orange": [255, 165, 0],
	"orangered": [255, 69, 0],
	"orchid": [218, 112, 214],
	"palegoldenrod": [238, 232, 170],
	"palegreen": [152, 251, 152],
	"paleturquoise": [175, 238, 238],
	"palevioletred": [219, 112, 147],
	"papayawhip": [255, 239, 213],
	"peachpuff": [255, 218, 185],
	"peru": [205, 133, 63],
	"pink": [255, 192, 203],
	"plum": [221, 160, 221],
	"powderblue": [176, 224, 230],
	"purple": [128, 0, 128],
	"rebeccapurple": [102, 51, 153],
	"red": [255, 0, 0],
	"rosybrown": [188, 143, 143],
	"royalblue": [65, 105, 225],
	"saddlebrown": [139, 69, 19],
	"salmon": [250, 128, 114],
	"sandybrown": [244, 164, 96],
	"seagreen": [46, 139, 87],
	"seashell": [255, 245, 238],
	"sienna": [160, 82, 45],
	"silver": [192, 192, 192],
	"skyblue": [135, 206, 235],
	"slateblue": [106, 90, 205],
	"slategray": [112, 128, 144],
	"slategrey": [112, 128, 144],
	"snow": [255, 250, 250],
	"springgreen": [0, 255, 127],
	"steelblue": [70, 130, 180],
	"tan": [210, 180, 140],
	"teal": [0, 128, 128],
	"thistle": [216, 191, 216],
	"tomato": [255, 99, 71],
	"turquoise": [64, 224, 208],
	"violet": [238, 130, 238],
	"wheat": [245, 222, 179],
	"white": [255, 255, 255],
	"whitesmoke": [245, 245, 245],
	"yellow": [255, 255, 0],
	"yellowgreen": [154, 205, 50]
};

      };
    };
  }
  }
}, {package:"@metamask/jazzicon>color>color-convert>color-name",file:"node_modules\\@metamask\\jazzicon\\node_modules\\color-name\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\jazzicon\\node_modules\\color\\index.js", {"clone":"D:\\code\\v\\metamask-extension\\node_modules\\clone\\clone.js","color-convert":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\jazzicon\\node_modules\\color-convert\\index.js","color-string":"D:\\code\\v\\metamask-extension\\node_modules\\color-string\\color-string.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cjazzicon%5Cnode_modules%5Ccolor%5Cindex.js
      return function (require, module, exports) {
/* MIT license */
var clone = require('clone');
var convert = require('color-convert');
var string = require('color-string');

var Color = function (obj) {
	if (obj instanceof Color) {
		return obj;
	}
	if (!(this instanceof Color)) {
		return new Color(obj);
	}

	this.values = {
		rgb: [0, 0, 0],
		hsl: [0, 0, 0],
		hsv: [0, 0, 0],
		hwb: [0, 0, 0],
		cmyk: [0, 0, 0, 0],
		alpha: 1
	};

	// parse Color() argument
	var vals;
	if (typeof obj === 'string') {
		vals = string.getRgba(obj);
		if (vals) {
			this.setValues('rgb', vals);
		} else if (vals = string.getHsla(obj)) {
			this.setValues('hsl', vals);
		} else if (vals = string.getHwb(obj)) {
			this.setValues('hwb', vals);
		} else {
			throw new Error('Unable to parse color from string "' + obj + '"');
		}
	} else if (typeof obj === 'object') {
		vals = obj;
		if (vals.r !== undefined || vals.red !== undefined) {
			this.setValues('rgb', vals);
		} else if (vals.l !== undefined || vals.lightness !== undefined) {
			this.setValues('hsl', vals);
		} else if (vals.v !== undefined || vals.value !== undefined) {
			this.setValues('hsv', vals);
		} else if (vals.w !== undefined || vals.whiteness !== undefined) {
			this.setValues('hwb', vals);
		} else if (vals.c !== undefined || vals.cyan !== undefined) {
			this.setValues('cmyk', vals);
		} else {
			throw new Error('Unable to parse color from object ' + JSON.stringify(obj));
		}
	}
};

Color.prototype = {
	rgb: function () {
		return this.setSpace('rgb', arguments);
	},
	hsl: function () {
		return this.setSpace('hsl', arguments);
	},
	hsv: function () {
		return this.setSpace('hsv', arguments);
	},
	hwb: function () {
		return this.setSpace('hwb', arguments);
	},
	cmyk: function () {
		return this.setSpace('cmyk', arguments);
	},

	rgbArray: function () {
		return this.values.rgb;
	},
	hslArray: function () {
		return this.values.hsl;
	},
	hsvArray: function () {
		return this.values.hsv;
	},
	hwbArray: function () {
		if (this.values.alpha !== 1) {
			return this.values.hwb.concat([this.values.alpha]);
		}
		return this.values.hwb;
	},
	cmykArray: function () {
		return this.values.cmyk;
	},
	rgbaArray: function () {
		var rgb = this.values.rgb;
		return rgb.concat([this.values.alpha]);
	},
	rgbaArrayNormalized: function () {
		var rgb = this.values.rgb;
		var glRgba = [];
		for (var i = 0; i < 3; i++) {
			glRgba[i] = rgb[i] / 255;
		}
		glRgba.push(this.values.alpha);
		return glRgba;
	},
	hslaArray: function () {
		var hsl = this.values.hsl;
		return hsl.concat([this.values.alpha]);
	},
	alpha: function (val) {
		if (val === undefined) {
			return this.values.alpha;
		}
		this.setValues('alpha', val);
		return this;
	},

	red: function (val) {
		return this.setChannel('rgb', 0, val);
	},
	green: function (val) {
		return this.setChannel('rgb', 1, val);
	},
	blue: function (val) {
		return this.setChannel('rgb', 2, val);
	},
	hue: function (val) {
		if (val) {
			val %= 360;
			val = val < 0 ? 360 + val : val;
		}
		return this.setChannel('hsl', 0, val);
	},
	saturation: function (val) {
		return this.setChannel('hsl', 1, val);
	},
	lightness: function (val) {
		return this.setChannel('hsl', 2, val);
	},
	saturationv: function (val) {
		return this.setChannel('hsv', 1, val);
	},
	whiteness: function (val) {
		return this.setChannel('hwb', 1, val);
	},
	blackness: function (val) {
		return this.setChannel('hwb', 2, val);
	},
	value: function (val) {
		return this.setChannel('hsv', 2, val);
	},
	cyan: function (val) {
		return this.setChannel('cmyk', 0, val);
	},
	magenta: function (val) {
		return this.setChannel('cmyk', 1, val);
	},
	yellow: function (val) {
		return this.setChannel('cmyk', 2, val);
	},
	black: function (val) {
		return this.setChannel('cmyk', 3, val);
	},

	hexString: function () {
		return string.hexString(this.values.rgb);
	},
	rgbString: function () {
		return string.rgbString(this.values.rgb, this.values.alpha);
	},
	rgbaString: function () {
		return string.rgbaString(this.values.rgb, this.values.alpha);
	},
	percentString: function () {
		return string.percentString(this.values.rgb, this.values.alpha);
	},
	hslString: function () {
		return string.hslString(this.values.hsl, this.values.alpha);
	},
	hslaString: function () {
		return string.hslaString(this.values.hsl, this.values.alpha);
	},
	hwbString: function () {
		return string.hwbString(this.values.hwb, this.values.alpha);
	},
	keyword: function () {
		return string.keyword(this.values.rgb, this.values.alpha);
	},

	rgbNumber: function () {
		return (this.values.rgb[0] << 16) | (this.values.rgb[1] << 8) | this.values.rgb[2];
	},

	luminosity: function () {
		// http://www.w3.org/TR/WCAG20/#relativeluminancedef
		var rgb = this.values.rgb;
		var lum = [];
		for (var i = 0; i < rgb.length; i++) {
			var chan = rgb[i] / 255;
			lum[i] = (chan <= 0.03928) ? chan / 12.92 : Math.pow(((chan + 0.055) / 1.055), 2.4);
		}
		return 0.2126 * lum[0] + 0.7152 * lum[1] + 0.0722 * lum[2];
	},

	contrast: function (color2) {
		// http://www.w3.org/TR/WCAG20/#contrast-ratiodef
		var lum1 = this.luminosity();
		var lum2 = color2.luminosity();
		if (lum1 > lum2) {
			return (lum1 + 0.05) / (lum2 + 0.05);
		}
		return (lum2 + 0.05) / (lum1 + 0.05);
	},

	level: function (color2) {
		var contrastRatio = this.contrast(color2);
		if (contrastRatio >= 7.1) {
			return 'AAA';
		}

		return (contrastRatio >= 4.5) ? 'AA' : '';
	},

	dark: function () {
		// YIQ equation from http://24ways.org/2010/calculating-color-contrast
		var rgb = this.values.rgb;
		var yiq = (rgb[0] * 299 + rgb[1] * 587 + rgb[2] * 114) / 1000;
		return yiq < 128;
	},

	light: function () {
		return !this.dark();
	},

	negate: function () {
		var rgb = [];
		for (var i = 0; i < 3; i++) {
			rgb[i] = 255 - this.values.rgb[i];
		}
		this.setValues('rgb', rgb);
		return this;
	},

	lighten: function (ratio) {
		this.values.hsl[2] += this.values.hsl[2] * ratio;
		this.setValues('hsl', this.values.hsl);
		return this;
	},

	darken: function (ratio) {
		this.values.hsl[2] -= this.values.hsl[2] * ratio;
		this.setValues('hsl', this.values.hsl);
		return this;
	},

	saturate: function (ratio) {
		this.values.hsl[1] += this.values.hsl[1] * ratio;
		this.setValues('hsl', this.values.hsl);
		return this;
	},

	desaturate: function (ratio) {
		this.values.hsl[1] -= this.values.hsl[1] * ratio;
		this.setValues('hsl', this.values.hsl);
		return this;
	},

	whiten: function (ratio) {
		this.values.hwb[1] += this.values.hwb[1] * ratio;
		this.setValues('hwb', this.values.hwb);
		return this;
	},

	blacken: function (ratio) {
		this.values.hwb[2] += this.values.hwb[2] * ratio;
		this.setValues('hwb', this.values.hwb);
		return this;
	},

	greyscale: function () {
		var rgb = this.values.rgb;
		// http://en.wikipedia.org/wiki/Grayscale#Converting_color_to_grayscale
		var val = rgb[0] * 0.3 + rgb[1] * 0.59 + rgb[2] * 0.11;
		this.setValues('rgb', [val, val, val]);
		return this;
	},

	clearer: function (ratio) {
		this.setValues('alpha', this.values.alpha - (this.values.alpha * ratio));
		return this;
	},

	opaquer: function (ratio) {
		this.setValues('alpha', this.values.alpha + (this.values.alpha * ratio));
		return this;
	},

	rotate: function (degrees) {
		var hue = this.values.hsl[0];
		hue = (hue + degrees) % 360;
		hue = hue < 0 ? 360 + hue : hue;
		this.values.hsl[0] = hue;
		this.setValues('hsl', this.values.hsl);
		return this;
	},

	/**
	 * Ported from sass implementation in C
	 * https://github.com/sass/libsass/blob/0e6b4a2850092356aa3ece07c6b249f0221caced/functions.cpp#L209
	 */
	mix: function (mixinColor, weight) {
		var color1 = this;
		var color2 = mixinColor;
		var p = weight === undefined ? 0.5 : weight;

		var w = 2 * p - 1;
		var a = color1.alpha() - color2.alpha();

		var w1 = (((w * a === -1) ? w : (w + a) / (1 + w * a)) + 1) / 2.0;
		var w2 = 1 - w1;

		return this
			.rgb(
				w1 * color1.red() + w2 * color2.red(),
				w1 * color1.green() + w2 * color2.green(),
				w1 * color1.blue() + w2 * color2.blue()
			)
			.alpha(color1.alpha() * p + color2.alpha() * (1 - p));
	},

	toJSON: function () {
		return this.rgb();
	},

	clone: function () {
		var col = new Color();
		col.values = clone(this.values);
		return col;
	}
};

Color.prototype.getValues = function (space) {
	var vals = {};

	for (var i = 0; i < space.length; i++) {
		vals[space.charAt(i)] = this.values[space][i];
	}

	if (this.values.alpha !== 1) {
		vals.a = this.values.alpha;
	}

	// {r: 255, g: 255, b: 255, a: 0.4}
	return vals;
};

Color.prototype.setValues = function (space, vals) {
	var spaces = {
		rgb: ['red', 'green', 'blue'],
		hsl: ['hue', 'saturation', 'lightness'],
		hsv: ['hue', 'saturation', 'value'],
		hwb: ['hue', 'whiteness', 'blackness'],
		cmyk: ['cyan', 'magenta', 'yellow', 'black']
	};

	var maxes = {
		rgb: [255, 255, 255],
		hsl: [360, 100, 100],
		hsv: [360, 100, 100],
		hwb: [360, 100, 100],
		cmyk: [100, 100, 100, 100]
	};

	var i;
	var alpha = 1;
	if (space === 'alpha') {
		alpha = vals;
	} else if (vals.length) {
		// [10, 10, 10]
		this.values[space] = vals.slice(0, space.length);
		alpha = vals[space.length];
	} else if (vals[space.charAt(0)] !== undefined) {
		// {r: 10, g: 10, b: 10}
		for (i = 0; i < space.length; i++) {
			this.values[space][i] = vals[space.charAt(i)];
		}

		alpha = vals.a;
	} else if (vals[spaces[space][0]] !== undefined) {
		// {red: 10, green: 10, blue: 10}
		var chans = spaces[space];

		for (i = 0; i < space.length; i++) {
			this.values[space][i] = vals[chans[i]];
		}

		alpha = vals.alpha;
	}

	this.values.alpha = Math.max(0, Math.min(1, (alpha === undefined ? this.values.alpha : alpha)));

	if (space === 'alpha') {
		return false;
	}

	var capped;

	// cap values of the space prior converting all values
	for (i = 0; i < space.length; i++) {
		capped = Math.max(0, Math.min(maxes[space][i], this.values[space][i]));
		this.values[space][i] = Math.round(capped);
	}

	// convert to all the other color spaces
	for (var sname in spaces) {
		if (sname !== space) {
			this.values[sname] = convert[space][sname](this.values[space]);
		}

		// cap values
		for (i = 0; i < sname.length; i++) {
			capped = Math.max(0, Math.min(maxes[sname][i], this.values[sname][i]));
			this.values[sname][i] = Math.round(capped);
		}
	}

	return true;
};

Color.prototype.setSpace = function (space, args) {
	var vals = args[0];

	if (vals === undefined) {
		// color.rgb()
		return this.getValues(space);
	}

	// color.rgb(10, 10, 10)
	if (typeof vals === 'number') {
		vals = Array.prototype.slice.call(args);
	}

	this.setValues(space, vals);
	return this;
};

Color.prototype.setChannel = function (space, index, val) {
	if (val === undefined) {
		// color.red()
		return this.values[space][index];
	} else if (val === this.values[space][index]) {
		// color.red(color.red())
		return this;
	}

	// color.red(100)
	this.values[space][index] = val;
	this.setValues(space, this.values[space]);

	return this;
};

module.exports = Color;

      };
    };
  }
  }
}, {package:"@metamask/jazzicon>color",file:"node_modules\\@metamask\\jazzicon\\node_modules\\color\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\jazzicon\\paper.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cjazzicon%5Cpaper.js
      return function (require, module, exports) {
function newPaper(diameter, color) {
  var container = document.createElement('div')
  container.style.borderRadius = '50px'
  container.style.overflow = 'hidden'
  container.style.padding = '0px'
  container.style.margin = '0px'
  container.style.width = '' + diameter + 'px'
  container.style.height = '' + diameter + 'px'
  container.style.display = 'inline-block'
  container.style.background = color
  return {
    container: container,
  }
}

module.exports = newPaper

      };
    };
  }
  }
}, {package:"@metamask/jazzicon",file:"node_modules\\@metamask\\jazzicon\\paper.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-engine\\dist\\JsonRpcEngine.cjs", {"@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/safe-event-emitter":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\safe-event-emitter\\dist\\cjs\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cjson-rpc-engine%5Cdist%5CJsonRpcEngine.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _JsonRpcEngine_instances, _a, _JsonRpcEngine_isDestroyed, _JsonRpcEngine_middleware, _JsonRpcEngine_notificationHandler, _JsonRpcEngine_assertIsNotDestroyed, _JsonRpcEngine_handleBatch, _JsonRpcEngine_handle, _JsonRpcEngine_processRequest, _JsonRpcEngine_runAllMiddleware, _JsonRpcEngine_runMiddleware, _JsonRpcEngine_runReturnHandlers, _JsonRpcEngine_checkForCompletion;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonRpcEngine = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const safe_event_emitter_1 = __importDefault(require("@metamask/safe-event-emitter"));
const utils_1 = require("@metamask/utils");
const DESTROYED_ERROR_MESSAGE = 'This engine is destroyed and can no longer be used.';
/**
 * A JSON-RPC request and response processor.
 * Give it a stack of middleware, pass it requests, and get back responses.
 */
class JsonRpcEngine extends safe_event_emitter_1.default {
    /**
     * Constructs a {@link JsonRpcEngine} instance.
     *
     * @param options - Options bag.
     * @param options.notificationHandler - A function for handling JSON-RPC
     * notifications. A JSON-RPC notification is defined as a JSON-RPC request
     * without an `id` property. If this option is _not_ provided, notifications
     * will be treated the same as requests. If this option _is_ provided,
     * notifications will be passed to the handler function without touching
     * the engine's middleware stack. This function should not throw or reject.
     */
    constructor({ notificationHandler } = {}) {
        super();
        _JsonRpcEngine_instances.add(this);
        /**
         * Indicating whether this engine is destroyed or not.
         */
        _JsonRpcEngine_isDestroyed.set(this, false);
        _JsonRpcEngine_middleware.set(this, void 0);
        _JsonRpcEngine_notificationHandler.set(this, void 0);
        __classPrivateFieldSet(this, _JsonRpcEngine_middleware, [], "f");
        __classPrivateFieldSet(this, _JsonRpcEngine_notificationHandler, notificationHandler, "f");
    }
    /**
     * Calls the `destroy()` function of any middleware with that property, clears
     * the middleware array, and marks this engine as destroyed. A destroyed
     * engine cannot be used.
     */
    destroy() {
        __classPrivateFieldGet(this, _JsonRpcEngine_middleware, "f").forEach((middleware) => {
            if (
            // `in` walks the prototype chain, which is probably the desired
            // behavior here.
            'destroy' in middleware &&
                typeof middleware.destroy === 'function') {
                // eslint-disable-next-line @typescript-eslint/no-floating-promises
                middleware.destroy();
            }
        });
        __classPrivateFieldSet(this, _JsonRpcEngine_middleware, [], "f");
        __classPrivateFieldSet(this, _JsonRpcEngine_isDestroyed, true, "f");
    }
    /**
     * Add a middleware function to the engine's middleware stack.
     *
     * @param middleware - The middleware function to add.
     */
    push(middleware) {
        __classPrivateFieldGet(this, _JsonRpcEngine_instances, "m", _JsonRpcEngine_assertIsNotDestroyed).call(this);
        __classPrivateFieldGet(this, _JsonRpcEngine_middleware, "f").push(middleware);
    }
    handle(req, callback) {
        __classPrivateFieldGet(this, _JsonRpcEngine_instances, "m", _JsonRpcEngine_assertIsNotDestroyed).call(this);
        if (callback && typeof callback !== 'function') {
            throw new Error('"callback" must be a function if provided.');
        }
        if (Array.isArray(req)) {
            if (callback) {
                return __classPrivateFieldGet(this, _JsonRpcEngine_instances, "m", _JsonRpcEngine_handleBatch).call(this, req, 
                // This assertion is safe because of the runtime checks validating that `req` is an array and `callback` is defined.
                // There is only one overload signature that satisfies both conditions, and its `callback` type is the one that's being asserted.
                callback);
            }
            return __classPrivateFieldGet(this, _JsonRpcEngine_instances, "m", _JsonRpcEngine_handleBatch).call(this, req);
        }
        if (callback) {
            return __classPrivateFieldGet(this, _JsonRpcEngine_instances, "m", _JsonRpcEngine_handle).call(this, req, callback);
        }
        return this._promiseHandle(req);
    }
    /**
     * Returns this engine as a middleware function that can be pushed to other
     * engines.
     *
     * @returns This engine as a middleware function.
     */
    asMiddleware() {
        __classPrivateFieldGet(this, _JsonRpcEngine_instances, "m", _JsonRpcEngine_assertIsNotDestroyed).call(this);
        // eslint-disable-next-line @typescript-eslint/no-misused-promises
        return async (req, res, next, end) => {
            try {
                const [middlewareError, isComplete, returnHandlers] = await __classPrivateFieldGet(_a, _a, "m", _JsonRpcEngine_runAllMiddleware).call(_a, req, res, __classPrivateFieldGet(this, _JsonRpcEngine_middleware, "f"));
                if (isComplete) {
                    await __classPrivateFieldGet(_a, _a, "m", _JsonRpcEngine_runReturnHandlers).call(_a, returnHandlers);
                    return end(middlewareError);
                }
                // eslint-disable-next-line @typescript-eslint/no-misused-promises
                return next(async (handlerCallback) => {
                    try {
                        await __classPrivateFieldGet(_a, _a, "m", _JsonRpcEngine_runReturnHandlers).call(_a, returnHandlers);
                    }
                    catch (error) {
                        return handlerCallback(error);
                    }
                    return handlerCallback();
                });
            }
            catch (error) {
                return end(error);
            }
        };
    }
    /**
     * A promise-wrapped _handle.
     *
     * @param request - The JSON-RPC request.
     * @returns The JSON-RPC response.
     */
    // This function is used in tests, so we cannot easily change it to use the
    // hash syntax.
    // eslint-disable-next-line no-restricted-syntax
    async _promiseHandle(request) {
        return new Promise((resolve, reject) => {
            __classPrivateFieldGet(this, _JsonRpcEngine_instances, "m", _JsonRpcEngine_handle).call(this, request, (error, res) => {
                // For notifications, the response will be `undefined`, and any caught
                // errors are unexpected and should be surfaced to the caller.
                if (error && res === undefined) {
                    reject(error);
                }
                else {
                    // Excepting notifications, there will always be a response, and it will
                    // always have any error that is caught and propagated.
                    resolve(res);
                }
            }).catch(reject);
        });
    }
}
exports.JsonRpcEngine = JsonRpcEngine;
_a = JsonRpcEngine, _JsonRpcEngine_isDestroyed = new WeakMap(), _JsonRpcEngine_middleware = new WeakMap(), _JsonRpcEngine_notificationHandler = new WeakMap(), _JsonRpcEngine_instances = new WeakSet(), _JsonRpcEngine_assertIsNotDestroyed = function _JsonRpcEngine_assertIsNotDestroyed() {
    if (__classPrivateFieldGet(this, _JsonRpcEngine_isDestroyed, "f")) {
        throw new Error(DESTROYED_ERROR_MESSAGE);
    }
}, _JsonRpcEngine_handleBatch = 
/**
 * Handles a batch of JSON-RPC requests, either in `async` or callback
 * fashion.
 *
 * @param requests - The request objects to process.
 * @param callback - The completion callback.
 * @returns The array of responses, or nothing if a callback was specified.
 */
async function _JsonRpcEngine_handleBatch(requests, callback) {
    // The order here is important
    try {
        // If the batch is an empty array, the response array must contain a single object
        if (requests.length === 0) {
            const response = [
                {
                    id: null,
                    jsonrpc: '2.0',
                    error: new rpc_errors_1.JsonRpcError(rpc_errors_1.errorCodes.rpc.invalidRequest, 'Request batch must contain plain objects. Received an empty array'),
                },
            ];
            if (callback) {
                return callback(null, response);
            }
            return response;
        }
        // 2. Wait for all requests to finish, or throw on some kind of fatal
        // error
        const responses = (await Promise.all(
        // 1. Begin executing each request in the order received
        requests.map(this._promiseHandle.bind(this)))).filter(
        // Filter out any notification responses.
        (response) => response !== undefined);
        // 3. Return batch response
        if (callback) {
            return callback(null, responses);
        }
        return responses;
    }
    catch (error) {
        if (callback) {
            return callback(error);
        }
        throw error;
    }
}, _JsonRpcEngine_handle = 
/**
 * Ensures that the request / notification object is valid, processes it, and
 * passes any error and response object to the given callback.
 *
 * Does not reject.
 *
 * @param callerReq - The request object from the caller.
 * @param callback - The callback function.
 * @returns Nothing.
 */
async function _JsonRpcEngine_handle(callerReq, callback) {
    if (!callerReq ||
        Array.isArray(callerReq) ||
        typeof callerReq !== 'object') {
        const error = new rpc_errors_1.JsonRpcError(rpc_errors_1.errorCodes.rpc.invalidRequest, `Requests must be plain objects. Received: ${typeof callerReq}`, { request: callerReq });
        return callback(error, { id: null, jsonrpc: '2.0', error });
    }
    if (typeof callerReq.method !== 'string') {
        const error = new rpc_errors_1.JsonRpcError(rpc_errors_1.errorCodes.rpc.invalidRequest, `Must specify a string method. Received: ${typeof callerReq.method}`, { request: callerReq });
        if (__classPrivateFieldGet(this, _JsonRpcEngine_notificationHandler, "f") && !(0, utils_1.isJsonRpcRequest)(callerReq)) {
            // Do not reply to notifications, even if they are malformed.
            return callback(null);
        }
        return callback(error, {
            // Typecast: This could be a notification, but we want to access the
            // `id` even if it doesn't exist.
            id: callerReq.id ?? null,
            jsonrpc: '2.0',
            error,
        });
    }
    else if (__classPrivateFieldGet(this, _JsonRpcEngine_notificationHandler, "f") &&
        (0, utils_1.isJsonRpcNotification)(callerReq) &&
        !(0, utils_1.isJsonRpcRequest)(callerReq)) {
        try {
            await __classPrivateFieldGet(this, _JsonRpcEngine_notificationHandler, "f").call(this, callerReq);
        }
        catch (error) {
            return callback(error);
        }
        return callback(null);
    }
    let error = null;
    // Handle requests.
    // Typecast: Permit missing id's for backwards compatibility.
    const req = { ...callerReq };
    const res = {
        id: req.id,
        jsonrpc: req.jsonrpc,
    };
    try {
        await __classPrivateFieldGet(_a, _a, "m", _JsonRpcEngine_processRequest).call(_a, req, res, __classPrivateFieldGet(this, _JsonRpcEngine_middleware, "f"));
    }
    catch (_error) {
        // A request handler error, a re-thrown middleware error, or something
        // unexpected.
        error = _error;
    }
    if (error) {
        // Ensure no result is present on an errored response
        delete res.result;
        if (!res.error) {
            res.error = (0, rpc_errors_1.serializeError)(error);
        }
    }
    return callback(error, res);
}, _JsonRpcEngine_processRequest = async function _JsonRpcEngine_processRequest(req, res, middlewares) {
    const [error, isComplete, returnHandlers] = await __classPrivateFieldGet(_a, _a, "m", _JsonRpcEngine_runAllMiddleware).call(_a, req, res, middlewares);
    // Throw if "end" was not called, or if the response has neither a result
    // nor an error.
    __classPrivateFieldGet(_a, _a, "m", _JsonRpcEngine_checkForCompletion).call(_a, req, res, isComplete);
    // The return handlers should run even if an error was encountered during
    // middleware processing.
    await __classPrivateFieldGet(_a, _a, "m", _JsonRpcEngine_runReturnHandlers).call(_a, returnHandlers);
    // Now we re-throw the middleware processing error, if any, to catch it
    // further up the call chain.
    if (error) {
        // eslint-disable-next-line @typescript-eslint/only-throw-error
        throw error;
    }
}, _JsonRpcEngine_runAllMiddleware = async function _JsonRpcEngine_runAllMiddleware(req, res, middlewares) {
    const returnHandlers = [];
    let error = null;
    let isComplete = false;
    // Go down stack of middleware, call and collect optional returnHandlers
    for (const middleware of middlewares) {
        [error, isComplete] = await __classPrivateFieldGet(_a, _a, "m", _JsonRpcEngine_runMiddleware).call(_a, req, res, middleware, returnHandlers);
        if (isComplete) {
            break;
        }
    }
    return [error, isComplete, returnHandlers.reverse()];
}, _JsonRpcEngine_runMiddleware = async function _JsonRpcEngine_runMiddleware(request, response, middleware, returnHandlers) {
    return new Promise((resolve) => {
        const end = (error) => {
            const parsedError = error || response.error;
            if (parsedError) {
                response.error = (0, rpc_errors_1.serializeError)(parsedError);
            }
            // True indicates that the request should end
            resolve([parsedError, true]);
        };
        const next = (returnHandler) => {
            if (response.error) {
                end(response.error);
            }
            else {
                if (returnHandler) {
                    if (typeof returnHandler !== 'function') {
                        end(new rpc_errors_1.JsonRpcError(rpc_errors_1.errorCodes.rpc.internal, `JsonRpcEngine: "next" return handlers must be functions. ` +
                            `Received "${typeof returnHandler}" for request:\n${jsonify(request)}`, { request }));
                    }
                    returnHandlers.push(returnHandler);
                }
                // False indicates that the request should not end
                resolve([null, false]);
            }
        };
        try {
            middleware(request, response, next, end);
        }
        catch (error) {
            end(error);
        }
    });
}, _JsonRpcEngine_runReturnHandlers = async function _JsonRpcEngine_runReturnHandlers(handlers) {
    for (const handler of handlers) {
        await new Promise((resolve, reject) => {
            handler((error) => (error ? reject(error) : resolve()));
        });
    }
}, _JsonRpcEngine_checkForCompletion = function _JsonRpcEngine_checkForCompletion(request, response, isComplete) {
    if (!(0, utils_1.hasProperty)(response, 'result') && !(0, utils_1.hasProperty)(response, 'error')) {
        throw new rpc_errors_1.JsonRpcError(rpc_errors_1.errorCodes.rpc.internal, `JsonRpcEngine: Response has no error or result for request:\n${jsonify(request)}`, { request });
    }
    if (!isComplete) {
        throw new rpc_errors_1.JsonRpcError(rpc_errors_1.errorCodes.rpc.internal, `JsonRpcEngine: Nothing ended request:\n${jsonify(request)}`, { request });
    }
};
/**
 * JSON-stringifies a request object.
 *
 * @param request - The request object to JSON-stringify.
 * @returns The JSON-stringified request object.
 */
function jsonify(request) {
    return JSON.stringify(request, null, 2);
}

      };
    };
  }
  }
}, {package:"@metamask/json-rpc-engine",file:"node_modules\\@metamask\\json-rpc-engine\\dist\\JsonRpcEngine.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-engine\\dist\\createAsyncMiddleware.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cjson-rpc-engine%5Cdist%5CcreateAsyncMiddleware.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAsyncMiddleware = void 0;
/**
 * JsonRpcEngine only accepts callback-based middleware directly.
 * createAsyncMiddleware exists to enable consumers to pass in async middleware
 * functions.
 *
 * Async middleware have no "end" function. Instead, they "end" if they return
 * without calling "next". Rather than passing in explicit return handlers,
 * async middleware can simply await "next", and perform operations on the
 * response object when execution resumes.
 *
 * To accomplish this, createAsyncMiddleware passes the async middleware a
 * wrapped "next" function. That function calls the internal JsonRpcEngine
 * "next" function with a return handler that resolves a promise when called.
 *
 * The return handler will always be called. Its resolution of the promise
 * enables the control flow described above.
 *
 * @param asyncMiddleware - The asynchronous middleware function to wrap.
 * @returns The wrapped asynchronous middleware function, ready to be consumed
 * by JsonRpcEngine.
 */
function createAsyncMiddleware(asyncMiddleware) {
    // eslint-disable-next-line @typescript-eslint/no-misused-promises
    return async (request, response, next, end) => {
        // nextPromise is the key to the implementation
        // it is resolved by the return handler passed to the
        // "next" function
        let resolveNextPromise;
        const nextPromise = new Promise((resolve) => {
            resolveNextPromise = resolve;
        });
        let returnHandlerCallback = null;
        let nextWasCalled = false;
        // This will be called by the consumer's async middleware.
        const asyncNext = async () => {
            nextWasCalled = true;
            // We pass a return handler to next(). When it is called by the engine,
            // the consumer's async middleware will resume executing.
            next((runReturnHandlersCallback) => {
                // This callback comes from JsonRpcEngine._runReturnHandlers
                returnHandlerCallback = runReturnHandlersCallback;
                resolveNextPromise();
            });
            return nextPromise;
        };
        try {
            await asyncMiddleware(request, response, asyncNext);
            if (nextWasCalled) {
                await nextPromise; // we must wait until the return handler is called
                returnHandlerCallback(null);
            }
            else {
                end(null);
            }
        }
        catch (error) {
            if (returnHandlerCallback) {
                returnHandlerCallback(error);
            }
            else {
                end(error);
            }
        }
    };
}
exports.createAsyncMiddleware = createAsyncMiddleware;

      };
    };
  }
  }
}, {package:"@metamask/json-rpc-engine",file:"node_modules\\@metamask\\json-rpc-engine\\dist\\createAsyncMiddleware.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-engine\\dist\\createScaffoldMiddleware.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cjson-rpc-engine%5Cdist%5CcreateScaffoldMiddleware.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createScaffoldMiddleware = void 0;
/**
 * Creates a middleware function from an object of RPC method handler functions,
 * keyed to particular method names. If a method corresponding to a key of this
 * object is requested, this middleware will pass it to the corresponding
 * handler and return the result.
 *
 * @param handlers - The RPC method handler functions.
 * @returns The scaffold middleware function.
 */
function createScaffoldMiddleware(handlers) {
    return (req, res, next, end) => {
        const handler = handlers[req.method];
        // if no handler, return
        if (handler === undefined) {
            return next();
        }
        // if handler is fn, call as middleware
        if (typeof handler === 'function') {
            return handler(req, res, next, end);
        }
        // if handler is some other value, use as result
        res.result = handler;
        return end();
    };
}
exports.createScaffoldMiddleware = createScaffoldMiddleware;

      };
    };
  }
  }
}, {package:"@metamask/json-rpc-engine",file:"node_modules\\@metamask\\json-rpc-engine\\dist\\createScaffoldMiddleware.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-engine\\dist\\getUniqueId.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cjson-rpc-engine%5Cdist%5CgetUniqueId.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getUniqueId = void 0;
// uint32 (two's complement) max
// more conservative than Number.MAX_SAFE_INTEGER
const MAX = 4294967295;
let idCounter = Math.floor(Math.random() * MAX);
/**
 * Gets an ID that is guaranteed to be unique so long as no more than
 * 4_294_967_295 (uint32 max) IDs are created, or the IDs are rapidly turned
 * over.
 *
 * @returns The unique ID.
 */
function getUniqueId() {
    idCounter = (idCounter + 1) % MAX;
    return idCounter;
}
exports.getUniqueId = getUniqueId;

      };
    };
  }
  }
}, {package:"@metamask/json-rpc-engine",file:"node_modules\\@metamask\\json-rpc-engine\\dist\\getUniqueId.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-engine\\dist\\idRemapMiddleware.cjs", {"./getUniqueId.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-engine\\dist\\getUniqueId.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cjson-rpc-engine%5Cdist%5CidRemapMiddleware.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createIdRemapMiddleware = void 0;
const getUniqueId_1 = require("./getUniqueId.cjs");
/**
 * Returns a middleware function that overwrites the `id` property of each
 * request with an ID that is guaranteed to be unique, and restores the original
 * ID in a return handler.
 *
 * If used, should be the first middleware in the stack.
 *
 * @returns The ID remap middleware function.
 */
function createIdRemapMiddleware() {
    return (request, response, next, _end) => {
        const originalId = request.id;
        const newId = (0, getUniqueId_1.getUniqueId)();
        request.id = newId;
        response.id = newId;
        next((done) => {
            request.id = originalId;
            response.id = originalId;
            done();
        });
    };
}
exports.createIdRemapMiddleware = createIdRemapMiddleware;

      };
    };
  }
  }
}, {package:"@metamask/json-rpc-engine",file:"node_modules\\@metamask\\json-rpc-engine\\dist\\idRemapMiddleware.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-engine\\dist\\index.cjs", {"./JsonRpcEngine.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-engine\\dist\\JsonRpcEngine.cjs","./createAsyncMiddleware.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-engine\\dist\\createAsyncMiddleware.cjs","./createScaffoldMiddleware.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-engine\\dist\\createScaffoldMiddleware.cjs","./getUniqueId.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-engine\\dist\\getUniqueId.cjs","./idRemapMiddleware.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-engine\\dist\\idRemapMiddleware.cjs","./mergeMiddleware.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-engine\\dist\\mergeMiddleware.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cjson-rpc-engine%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeMiddleware = exports.JsonRpcEngine = exports.createIdRemapMiddleware = exports.getUniqueId = exports.createScaffoldMiddleware = exports.createAsyncMiddleware = void 0;
var createAsyncMiddleware_1 = require("./createAsyncMiddleware.cjs");
Object.defineProperty(exports, "createAsyncMiddleware", { enumerable: true, get: function () { return createAsyncMiddleware_1.createAsyncMiddleware; } });
var createScaffoldMiddleware_1 = require("./createScaffoldMiddleware.cjs");
Object.defineProperty(exports, "createScaffoldMiddleware", { enumerable: true, get: function () { return createScaffoldMiddleware_1.createScaffoldMiddleware; } });
var getUniqueId_1 = require("./getUniqueId.cjs");
Object.defineProperty(exports, "getUniqueId", { enumerable: true, get: function () { return getUniqueId_1.getUniqueId; } });
var idRemapMiddleware_1 = require("./idRemapMiddleware.cjs");
Object.defineProperty(exports, "createIdRemapMiddleware", { enumerable: true, get: function () { return idRemapMiddleware_1.createIdRemapMiddleware; } });
var JsonRpcEngine_1 = require("./JsonRpcEngine.cjs");
Object.defineProperty(exports, "JsonRpcEngine", { enumerable: true, get: function () { return JsonRpcEngine_1.JsonRpcEngine; } });
var mergeMiddleware_1 = require("./mergeMiddleware.cjs");
Object.defineProperty(exports, "mergeMiddleware", { enumerable: true, get: function () { return mergeMiddleware_1.mergeMiddleware; } });

      };
    };
  }
  }
}, {package:"@metamask/json-rpc-engine",file:"node_modules\\@metamask\\json-rpc-engine\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-engine\\dist\\mergeMiddleware.cjs", {"./JsonRpcEngine.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-engine\\dist\\JsonRpcEngine.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cjson-rpc-engine%5Cdist%5CmergeMiddleware.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeMiddleware = void 0;
const JsonRpcEngine_1 = require("./JsonRpcEngine.cjs");
/**
 * Takes a stack of middleware and joins them into a single middleware function.
 *
 * @param middlewareStack - The middleware stack to merge.
 * @returns The merged middleware function.
 */
function mergeMiddleware(middlewareStack) {
    const engine = new JsonRpcEngine_1.JsonRpcEngine();
    middlewareStack.forEach((middleware) => engine.push(middleware));
    return engine.asMiddleware();
}
exports.mergeMiddleware = mergeMiddleware;

      };
    };
  }
  }
}, {package:"@metamask/json-rpc-engine",file:"node_modules\\@metamask\\json-rpc-engine\\dist\\mergeMiddleware.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-middleware-stream\\dist\\createEngineStream.cjs", {"readable-stream":"D:\\code\\v\\metamask-extension\\node_modules\\readable-stream\\readable-browser.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cjson-rpc-middleware-stream%5Cdist%5CcreateEngineStream.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const readable_stream_1 = require("readable-stream");
/**
 * Takes a JsonRpcEngine and returns a Duplex stream wrapping it.
 *
 * @param opts - Options bag.
 * @param opts.engine - The JsonRpcEngine to wrap in a stream.
 * @returns The stream wrapping the engine.
 */
function createEngineStream(opts) {
    if (!opts?.engine) {
        throw new Error('Missing engine parameter!');
    }
    const { engine } = opts;
    const stream = new readable_stream_1.Duplex({ objectMode: true, read: () => undefined, write });
    // forward notifications
    if (engine.on) {
        engine.on('notification', (message) => {
            stream.push(message);
        });
    }
    return stream;
    /**
     * Write a JSON-RPC request to the stream.
     *
     * @param req - The JSON-rpc request.
     * @param _encoding - The stream encoding, not used.
     * @param streamWriteCallback - The stream write callback.
     */
    function write(req, _encoding, streamWriteCallback) {
        engine.handle(req, (_err, res) => {
            stream.push(res);
        });
        streamWriteCallback();
    }
}
exports.default = createEngineStream;

      };
    };
  }
  }
}, {package:"@metamask/json-rpc-middleware-stream",file:"node_modules\\@metamask\\json-rpc-middleware-stream\\dist\\createEngineStream.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-middleware-stream\\dist\\createStreamMiddleware.cjs", {"@metamask/safe-event-emitter":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\safe-event-emitter\\dist\\cjs\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","readable-stream":"D:\\code\\v\\metamask-extension\\node_modules\\readable-stream\\readable-browser.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cjson-rpc-middleware-stream%5Cdist%5CcreateStreamMiddleware.cjs
      return function (require, module, exports) {
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const safe_event_emitter_1 = __importDefault(require("@metamask/safe-event-emitter"));
const utils_1 = require("@metamask/utils");
const readable_stream_1 = require("readable-stream");
/**
 * Creates a JsonRpcEngine middleware with an associated Duplex stream and
 * EventEmitter. The middleware, and by extension stream, assume that middleware
 * parameters are properly formatted. No runtime type checking or validation is
 * performed.
 *
 * @param options - Configuration options for middleware.
 * @returns The event emitter, middleware, and stream.
 */
function createStreamMiddleware(options = {}) {
    const idMap = {}; // TODO: replace with actual Map
    const stream = new readable_stream_1.Duplex({
        objectMode: true,
        read: () => undefined,
        write: processMessage,
    });
    const events = new safe_event_emitter_1.default();
    const middleware = (req, res, next, end) => {
        // register request on id map *before* sending it to the stream, to avoid race issues
        idMap[req.id] = { req, res, next, end };
        // write req to stream
        sendToStream(req);
    };
    return { events, middleware, stream };
    /**
     * Forwards JSON-RPC request to the stream.
     *
     * @param req - The JSON-RPC request object.
     */
    function sendToStream(req) {
        // TODO: limiting retries could be implemented here
        stream.push(req);
    }
    /**
     * Writes a JSON-RPC object to the stream.
     *
     * @param res - The JSON-RPC response object.
     * @param _encoding - The stream encoding, not used.
     * @param streamWriteCallback - The stream write callback.
     */
    function processMessage(res, _encoding, streamWriteCallback) {
        let errorObj = null;
        try {
            const isNotification = !(0, utils_1.hasProperty)(res, 'id');
            if (isNotification) {
                processNotification(res);
            }
            else {
                processResponse(res);
            }
        }
        catch (_err) {
            errorObj = _err;
        }
        // continue processing stream
        streamWriteCallback(errorObj);
    }
    /**
     * Processes a JSON-RPC response.
     *
     * @param res - The response to process.
     */
    function processResponse(res) {
        const { id: responseId } = res;
        if (responseId === null) {
            return;
        }
        const context = idMap[responseId];
        if (!context) {
            console.warn(`StreamMiddleware - Unknown response id "${responseId}"`);
            return;
        }
        delete idMap[responseId];
        // copy whole res onto original res
        Object.assign(context.res, res);
        // run callback on empty stack,
        // prevent internal stream-handler from catching errors
        // TODO: remove eslint-disable once issue #1989 is resolved.
        // eslint-disable-next-line @typescript-eslint/no-implied-eval
        setTimeout(context.end);
    }
    /**
     * Processes a JSON-RPC notification.
     *
     * @param notif - The notification to process.
     */
    function processNotification(notif) {
        if (options?.retryOnMessage && notif.method === options.retryOnMessage) {
            retryStuckRequests();
        }
        events.emit('notification', notif);
    }
    /**
     * Retry pending requests.
     */
    function retryStuckRequests() {
        Object.values(idMap).forEach(({ req, retryCount = 0 }) => {
            // Avoid retrying requests without an id - they cannot have matching responses so retry logic doesn't apply
            // Check for retry count below ensure that a request is not retried more than 3 times
            if (!req.id) {
                return;
            }
            if (retryCount >= 3) {
                throw new Error(`StreamMiddleware - Retry limit exceeded for request id "${req.id}"`);
            }
            const idMapObject = idMap[req.id];
            if (idMapObject) {
                idMapObject.retryCount = retryCount + 1;
            }
            sendToStream(req);
        });
    }
}
exports.default = createStreamMiddleware;

      };
    };
  }
  }
}, {package:"@metamask/json-rpc-middleware-stream",file:"node_modules\\@metamask\\json-rpc-middleware-stream\\dist\\createStreamMiddleware.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-middleware-stream\\dist\\index.cjs", {"./createEngineStream.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-middleware-stream\\dist\\createEngineStream.cjs","./createStreamMiddleware.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\json-rpc-middleware-stream\\dist\\createStreamMiddleware.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cjson-rpc-middleware-stream%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createStreamMiddleware = exports.createEngineStream = void 0;
const createEngineStream_1 = __importDefault(require("./createEngineStream.cjs"));
exports.createEngineStream = createEngineStream_1.default;
const createStreamMiddleware_1 = __importDefault(require("./createStreamMiddleware.cjs"));
exports.createStreamMiddleware = createStreamMiddleware_1.default;

      };
    };
  }
  }
}, {package:"@metamask/json-rpc-middleware-stream",file:"node_modules\\@metamask\\json-rpc-middleware-stream\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\BIP44CoinTypeNode.cjs", {"./BIP44Node.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\BIP44Node.cjs","./SLIP10Node.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\SLIP10Node.cjs","./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\constants.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\utils.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckey-tree%5Cdist%5CBIP44CoinTypeNode.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _BIP44CoinTypeNode_node;
Object.defineProperty(exports, "__esModule", { value: true });
exports.getBIP44AddressKeyDeriver = exports.deriveBIP44AddressKey = exports.BIP44CoinTypeNode = exports.BIP_44_COIN_TYPE_DEPTH = void 0;
const BIP44Node_1 = require("./BIP44Node.cjs");
const constants_1 = require("./constants.cjs");
const SLIP10Node_1 = require("./SLIP10Node.cjs");
const utils_1 = require("./utils.cjs");
exports.BIP_44_COIN_TYPE_DEPTH = 2;
/**
 * A wrapper object for BIP-44 `coin_type` keys. `coin_type` is the index
 * specifying the protocol for which deeper keys are intended. For the
 * authoritative list of coin types, please see
 * [SLIP-44](https://github.com/satoshilabs/slips/blob/master/slip-0044.md).
 *
 * Recall that a BIP-44 HD tree path consists of the following nodes:
 *
 * `m / 44' / coin_type' / account' / change / address_index`
 *
 * With the following depths:
 *
 * `0 / 1 / 2 / 3 / 4 / 5`
 *
 */
class BIP44CoinTypeNode {
    /**
     * Constructs a BIP-44 `coin_type` node. `coin_type` is the index
     * specifying the protocol for which deeper keys are intended. For the
     * authoritative list of coin types, please see
     * [SLIP-44](https://github.com/satoshilabs/slips/blob/master/slip-0044.md).
     *
     * Recall that a BIP-44 HD tree path consists of the following nodes:
     *
     * `m / 44' / coin_type' / account' / change / address_index`
     *
     * With the following depths:
     *
     * `0 / 1 / 2 / 3 / 4 / 5`
     *
     * @param json - The {@link JsonBIP44Node} for the key of this node.
     * @param coin_type - The coin_type index of this node. Must be a non-negative
     * integer.
     * @param cryptographicFunctions - The cryptographic functions to use. If
     * provided, these will be used instead of the built-in implementations.
     * @returns A BIP44CoinType node.
     */
    static async fromJSON(json, coin_type, cryptographicFunctions) {
        validateCoinType(coin_type);
        validateCoinTypeNodeDepth(json.depth);
        const node = await BIP44Node_1.BIP44Node.fromExtendedKey({
            depth: json.depth,
            index: json.index,
            network: json.network,
            parentFingerprint: json.parentFingerprint,
            chainCode: (0, utils_1.hexStringToBytes)(json.chainCode),
            privateKey: (0, utils_1.nullableHexStringToBytes)(json.privateKey),
            publicKey: (0, utils_1.hexStringToBytes)(json.publicKey),
        }, cryptographicFunctions);
        return new BIP44CoinTypeNode(node, coin_type);
    }
    /**
     * Construct a BIP-44 `coin_type` node. `coin_type` is the index
     * specifying the protocol for which deeper keys are intended. For the
     * authoritative list of coin types, please see
     * [SLIP-44](https://github.com/satoshilabs/slips/blob/master/slip-0044.md).
     *
     * Recall that a BIP-44 HD tree path consists of the following nodes:
     *
     * `m / 44' / coin_type' / account' / change / address_index`
     *
     * With the following depths:
     *
     * `0 / 1 / 2 / 3 / 4 / 5`
     *
     * @param derivationPath - The derivation path for the key of this node.
     * @param network - The network for the node. This is only used for extended
     * keys, and defaults to `mainnet`.
     * @param cryptographicFunctions - The cryptographic functions to use. If
     * provided, these will be used instead of the built-in implementations.
     * @returns A BIP44CoinType node.
     */
    static async fromDerivationPath(derivationPath, network, cryptographicFunctions) {
        validateCoinTypeNodeDepth(derivationPath.length - 1);
        const node = await BIP44Node_1.BIP44Node.fromDerivationPath({
            derivationPath,
            network,
        }, cryptographicFunctions);
        const coinType = (0, utils_1.getBIP44CoinType)(derivationPath);
        return new BIP44CoinTypeNode(node, coinType);
    }
    /**
     * Create a new BIP-44 coin type node from a BIP-39 seed. The derivation path
     * must be rooted, i.e. it must begin with a BIP-39 node, given as a
     * `Uint8Array` of the seed bytes.
     *
     * All parameters are stringently validated, and an error is thrown if
     * validation fails.
     *
     * @param options - The options for the new node.
     * @param options.derivationPath - The rooted HD tree path that will be used
     * to derive the key of this node.
     * @param options.network - The network for the node. This is only used for
     * extended keys, and defaults to `mainnet`.
     * @param cryptographicFunctions - The cryptographic functions to use. If
     * provided, these will be used instead of the built-in implementations.
     * @returns A new BIP-44 node.
     */
    static async fromSeed({ derivationPath, network }, cryptographicFunctions) {
        validateCoinTypeNodeDepth(derivationPath.length - 1);
        const node = await BIP44Node_1.BIP44Node.fromSeed({
            derivationPath,
            network,
        }, cryptographicFunctions);
        const coinType = (0, utils_1.getBIP44CoinType)(derivationPath);
        return new BIP44CoinTypeNode(node, coinType);
    }
    /**
     * Constructs a BIP-44 `coin_type` node. `coin_type` is the index
     * specifying the protocol for which deeper keys are intended. For the
     * authoritative list of coin types, please see
     * [SLIP-44](https://github.com/satoshilabs/slips/blob/master/slip-0044.md).
     *
     * Recall that a BIP-44 HD tree path consists of the following nodes:
     *
     * `m / 44' / coin_type' / account' / change / address_index`
     *
     * With the following depths:
     *
     * `0 / 1 / 2 / 3 / 4 / 5`
     *
     * @param node - The {@link BIP44Node} for the key of this node.
     * @param coin_type - The coin_type index of this node. Must be a non-negative
     * integer.
     * @returns A BIP44CoinType node.
     */
    static async fromNode(node, coin_type) {
        if (!(node instanceof BIP44Node_1.BIP44Node)) {
            throw new Error('Invalid node: Expected an instance of BIP44Node.');
        }
        validateCoinType(coin_type);
        validateCoinTypeNodeDepth(node.depth);
        // TODO: Make this function not async in a future version.
        return Promise.resolve(new BIP44CoinTypeNode(node, coin_type));
    }
    // Constructors cannot use hash names.
    // eslint-disable-next-line no-restricted-syntax
    constructor(node, coin_type) {
        _BIP44CoinTypeNode_node.set(this, void 0);
        __classPrivateFieldSet(this, _BIP44CoinTypeNode_node, node, "f");
        this.coin_type = coin_type;
        this.path = (0, utils_1.getBIP44CoinTypePathString)(coin_type);
        Object.freeze(this);
    }
    get depth() {
        return __classPrivateFieldGet(this, _BIP44CoinTypeNode_node, "f").depth;
    }
    get privateKeyBytes() {
        return __classPrivateFieldGet(this, _BIP44CoinTypeNode_node, "f").privateKeyBytes;
    }
    get publicKeyBytes() {
        return __classPrivateFieldGet(this, _BIP44CoinTypeNode_node, "f").publicKeyBytes;
    }
    get chainCodeBytes() {
        return __classPrivateFieldGet(this, _BIP44CoinTypeNode_node, "f").chainCodeBytes;
    }
    get privateKey() {
        return __classPrivateFieldGet(this, _BIP44CoinTypeNode_node, "f").privateKey;
    }
    get publicKey() {
        return __classPrivateFieldGet(this, _BIP44CoinTypeNode_node, "f").publicKey;
    }
    get compressedPublicKey() {
        return __classPrivateFieldGet(this, _BIP44CoinTypeNode_node, "f").compressedPublicKey;
    }
    get compressedPublicKeyBytes() {
        return __classPrivateFieldGet(this, _BIP44CoinTypeNode_node, "f").compressedPublicKeyBytes;
    }
    get chainCode() {
        return __classPrivateFieldGet(this, _BIP44CoinTypeNode_node, "f").chainCode;
    }
    get address() {
        return __classPrivateFieldGet(this, _BIP44CoinTypeNode_node, "f").address;
    }
    get masterFingerprint() {
        return __classPrivateFieldGet(this, _BIP44CoinTypeNode_node, "f").masterFingerprint;
    }
    get parentFingerprint() {
        return __classPrivateFieldGet(this, _BIP44CoinTypeNode_node, "f").parentFingerprint;
    }
    get fingerprint() {
        return __classPrivateFieldGet(this, _BIP44CoinTypeNode_node, "f").fingerprint;
    }
    get index() {
        return __classPrivateFieldGet(this, _BIP44CoinTypeNode_node, "f").index;
    }
    get network() {
        return __classPrivateFieldGet(this, _BIP44CoinTypeNode_node, "f").network;
    }
    get curve() {
        return __classPrivateFieldGet(this, _BIP44CoinTypeNode_node, "f").curve;
    }
    get extendedKey() {
        return __classPrivateFieldGet(this, _BIP44CoinTypeNode_node, "f").extendedKey;
    }
    /**
     * Derives a BIP-44 `address_index` key corresponding to the path of this
     * node and the specified `account`, `change`, and `address_index` values.
     * `address_index` keys are normally the keys used to generate user account
     * addresses.
     *
     * Recall that a BIP-44 HD tree path consists of the following nodes:
     *
     * `m / 44' / coin_type' / account' / change / address_index`
     *
     * With the following depths:
     *
     * `0 / 1 / 2 / 3 / 4 / 5`
     *
     * @param indices - The BIP-44 index values to use in key derivation.
     * @param indices.account - The `account` index. Default: `0`
     * @param indices.change - The `change` index. Default: `0`
     * @param indices.address_index - The `address_index` index.
     * @returns The derived BIP-44 `address_index` node.
     */
    async deriveBIP44AddressKey({ account = 0, change = 0, address_index, }) {
        return await __classPrivateFieldGet(this, _BIP44CoinTypeNode_node, "f").derive((0, utils_1.getBIP44CoinTypeToAddressPathTuple)({ account, change, address_index }));
    }
    toJSON() {
        return {
            ...__classPrivateFieldGet(this, _BIP44CoinTypeNode_node, "f").toJSON(),
            coin_type: this.coin_type,
            path: this.path,
        };
    }
}
exports.BIP44CoinTypeNode = BIP44CoinTypeNode;
_BIP44CoinTypeNode_node = new WeakMap();
/**
 * Validates the depth of a `coin_type` node. Simply, ensures that it is the
 * number `2`. An error is thrown if validation fails.
 *
 * @param depth - The depth to validate.
 */
function validateCoinTypeNodeDepth(depth) {
    if (depth !== exports.BIP_44_COIN_TYPE_DEPTH) {
        throw new Error(`Invalid depth: Coin type nodes must be of depth ${exports.BIP_44_COIN_TYPE_DEPTH}. Received: "${depth}"`);
    }
}
/**
 * Validates that the coin type is a non-negative integer number. An error is
 * thrown if validation fails.
 *
 * @param coin_type - The coin type to validate.
 */
function validateCoinType(coin_type) {
    if (typeof coin_type !== 'number' ||
        !Number.isInteger(coin_type) ||
        coin_type < 0) {
        throw new Error('Invalid coin type: The specified coin type must be a non-negative integer number.');
    }
}
/**
 * Derives a BIP-44 address key corresponding to the specified derivation path,
 * given either by a {@link BIP44CoinTypeNode} or derivation path tuple.
 *
 * Recall that a BIP-44 HD tree path consists of the following nodes:
 *
 * `m / 44' / coin_type' / account' / change / address_index`
 *
 * With the following depths:
 *
 * `0 / 1 / 2 / 3 / 4 / 5`
 *
 * @param parentKeyOrNode - The `coin_type` parent key to derive from.
 * @param indices - The BIP-44 index values to use in key derivation.
 * @param indices.account - The `account` index. Default: `0`.
 * @param indices.change - The `change` index. Default: `0`.
 * @param indices.address_index - The `address_index` index.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns The derived `address_index` key for the specified derivation path.
 */
async function deriveBIP44AddressKey(parentKeyOrNode, { account = 0, change = 0, address_index }, cryptographicFunctions) {
    const path = (0, utils_1.getBIP44CoinTypeToAddressPathTuple)({
        account,
        change,
        address_index,
    });
    const node = await getNode(parentKeyOrNode, cryptographicFunctions);
    const childNode = await (0, SLIP10Node_1.deriveChildNode)({
        path,
        node,
    }, cryptographicFunctions);
    return new BIP44Node_1.BIP44Node(childNode);
}
exports.deriveBIP44AddressKey = deriveBIP44AddressKey;
/**
 * Creates a function that derives BIP-44 address keys corresponding to the
 * specified derivation path, given either by a {@link BIP44CoinTypeNode} or
 * derivation path tuple.
 *
 * Recall that a BIP-44 HD tree path consists of the following nodes:
 *
 * `m / 44' / coin_type' / account' / change / address_index`
 *
 * With the following depths:
 *
 * `0 / 1 / 2 / 3 / 4 / 5`
 *
 * @param node - The {@link BIP44CoinTypeNode} to derive address keys from.
 * This node contains a BIP-44 key of depth 2, `coin_type`.
 * @param accountAndChangeIndices - The `account` and `change` indices that
 * will be used to derive addresses.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns The deriver function for the derivation path specified by the
 * `coin_type` node, `account`, and `change` indices.
 */
async function getBIP44AddressKeyDeriver(node, accountAndChangeIndices, cryptographicFunctions) {
    const { account = 0, change = 0 } = accountAndChangeIndices ?? {};
    const actualNode = await getNode(node, cryptographicFunctions);
    const accountNode = (0, utils_1.getHardenedBIP32NodeToken)(account);
    const changeNode = (0, utils_1.getBIP32NodeToken)(change);
    const bip44AddressKeyDeriver = async (address_index, isHardened = false) => {
        const slip10Node = await (0, SLIP10Node_1.deriveChildNode)({
            path: [
                accountNode,
                changeNode,
                isHardened
                    ? (0, utils_1.getHardenedBIP32NodeToken)(address_index)
                    : (0, utils_1.getUnhardenedBIP32NodeToken)(address_index),
            ],
            node: actualNode,
        }, cryptographicFunctions);
        return new BIP44Node_1.BIP44Node(slip10Node);
    };
    bip44AddressKeyDeriver.coin_type = actualNode.coin_type;
    bip44AddressKeyDeriver.path = (0, utils_1.getBIP44ChangePathString)(actualNode.path, {
        account,
        change,
    });
    Object.freeze(bip44AddressKeyDeriver);
    return bip44AddressKeyDeriver;
}
exports.getBIP44AddressKeyDeriver = getBIP44AddressKeyDeriver;
/**
 * Get a BIP-44 coin type node from a JSON node or extended key string. If an existing coin type
 * node is provided, the same node is returned.
 *
 * The depth of the node is validated to be a valid coin type node.
 *
 * @param node - A BIP-44 coin type node, JSON node or extended key.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations. This is
 * only used if the node is an extended key string or JSON object.
 * @returns A BIP44CoinType node.
 */
async function getNode(node, cryptographicFunctions) {
    if (node instanceof BIP44CoinTypeNode) {
        validateCoinTypeNodeDepth(node.depth);
        return node;
    }
    if (typeof node === 'string') {
        const bip44Node = await BIP44Node_1.BIP44Node.fromExtendedKey(node, cryptographicFunctions);
        const coinTypeNode = await BIP44CoinTypeNode.fromNode(bip44Node, bip44Node.index - constants_1.BIP_32_HARDENED_OFFSET);
        validateCoinTypeNodeDepth(coinTypeNode.depth);
        return coinTypeNode;
    }
    return BIP44CoinTypeNode.fromJSON(node, node.coin_type, cryptographicFunctions);
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules\\@metamask\\key-tree\\dist\\BIP44CoinTypeNode.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\BIP44Node.cjs", {"./SLIP10Node.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\SLIP10Node.cjs","./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\constants.cjs","./extended-keys.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\extended-keys.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\utils.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckey-tree%5Cdist%5CBIP44Node.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var _BIP44Node_node;
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateBIP44Depth = exports.BIP44Node = void 0;
const utils_1 = require("@metamask/utils");
const constants_1 = require("./constants.cjs");
const extended_keys_1 = require("./extended-keys.cjs");
const SLIP10Node_1 = require("./SLIP10Node.cjs");
const utils_2 = require("./utils.cjs");
/**
 * A wrapper for BIP-44 Hierarchical Deterministic (HD) tree nodes, i.e.
 * cryptographic keys used to generate keypairs and addresses for cryptocurrency
 * protocols.
 *
 * This class contains methods and fields that may not serialize well. Use
 * {@link BIP44Node.toJSON} to get a JSON-compatible representation.
 */
class BIP44Node {
    /**
     * Wrapper of the {@link fromExtendedKey} function. Refer to that function
     * for documentation.
     *
     * @param json - The JSON representation of a SLIP-10 node.
     * @param cryptographicFunctions - The cryptographic functions to use. If
     * provided, these will be used instead of the built-in implementations.
     * @returns A BIP44 node.
     */
    static async fromJSON(json, cryptographicFunctions) {
        return BIP44Node.fromExtendedKey(json, cryptographicFunctions);
    }
    /**
     * Create a new BIP-44 node from a key and chain code. You must specify
     * either a private key or a public key. When specifying a private key,
     * the public key will be derived from the private key.
     *
     * All parameters are stringently validated, and an error is thrown if
     * validation fails.
     *
     * @param options - An object containing the extended key, or an extended
     * public (xpub) or private (xprv) key.
     * @param options.depth - The depth of the node.
     * @param options.network - The network for the node. This is only used for
     * extended keys, and defaults to `mainnet`.
     * @param options.privateKey - The private key for the node.
     * @param options.publicKey - The public key for the node. If a private key is
     * specified, this parameter is ignored.
     * @param options.chainCode - The chain code for the node.
     * @param cryptographicFunctions - The cryptographic functions to use. If
     * provided, these will be used instead of the built-in implementations.
     * @returns A BIP44 node.
     */
    static async fromExtendedKey(options, cryptographicFunctions) {
        if (typeof options === 'string') {
            const extendedKey = (0, extended_keys_1.decodeExtendedKey)(options);
            const { type, chainCode, depth, parentFingerprint, index, network } = extendedKey;
            if (type === 'private') {
                const { privateKey } = extendedKey;
                return BIP44Node.fromExtendedKey({
                    depth,
                    parentFingerprint,
                    index,
                    network,
                    privateKey,
                    chainCode,
                }, cryptographicFunctions);
            }
            const { publicKey } = extendedKey;
            return BIP44Node.fromExtendedKey({
                depth,
                parentFingerprint,
                index,
                network,
                publicKey,
                chainCode,
            }, cryptographicFunctions);
        }
        const { privateKey, publicKey, chainCode, depth, parentFingerprint, index, network, } = options;
        validateBIP44Depth(depth);
        const node = await SLIP10Node_1.SLIP10Node.fromExtendedKey({
            privateKey,
            publicKey,
            chainCode,
            depth,
            parentFingerprint,
            index,
            network,
            curve: 'secp256k1',
        }, cryptographicFunctions);
        return new BIP44Node(node);
    }
    /**
     * Create a new BIP-44 node from a derivation path. The derivation path
     * must be rooted, i.e. it must begin with a BIP-39 node, given as a string of
     * the form `bip39:MNEMONIC`, where `MNEMONIC` is a space-separated list of
     * BIP-39 seed phrase words.
     *
     * All parameters are stringently validated, and an error is thrown if
     * validation fails.
     *
     * Recall that a BIP-44 HD tree path consists of the following nodes:
     *
     * `m / 44' / coin_type' / account' / change / address_index`
     *
     * With the following depths:
     *
     * `0 / 1 / 2 / 3 / 4 / 5`
     *
     * @param options - An object containing the derivation path.
     * @param options.derivationPath - The rooted HD tree path that will be used
     * to derive the key of this node.
     * @param options.network - The network for the node. This is only used for
     * extended keys, and defaults to `mainnet`.
     * @param cryptographicFunctions - The cryptographic functions to use. If
     * provided, these will be used instead of the built-in implementations.
     * @returns A BIP44 node.
     */
    static async fromDerivationPath({ derivationPath, network }, cryptographicFunctions) {
        validateBIP44Depth(derivationPath.length - 1);
        validateBIP44DerivationPath(derivationPath, constants_1.MIN_BIP_44_DEPTH);
        const node = await SLIP10Node_1.SLIP10Node.fromDerivationPath({
            derivationPath,
            network,
            curve: 'secp256k1',
        }, cryptographicFunctions);
        return new BIP44Node(node);
    }
    /**
     * Create a new BIP-44 node from a BIP-39 seed. The derivation path must be
     * rooted, i.e. it must begin with a BIP-39 node, given as a `Uint8Array` of
     * the seed bytes.
     *
     * All parameters are stringently validated, and an error is thrown if
     * validation fails.
     *
     * @param options - The options for the new node.
     * @param options.derivationPath - The rooted HD tree path that will be used
     * to derive the key of this node.
     * @param options.network - The network for the node. This is only used for
     * extended keys, and defaults to `mainnet`.
     * @param cryptographicFunctions - The cryptographic functions to use. If
     * provided, these will be used instead of the built-in implementations.
     * @returns A new BIP-44 node.
     */
    static async fromSeed({ derivationPath, network }, cryptographicFunctions) {
        validateBIP44Depth(derivationPath.length - 1);
        validateBIP44DerivationPath(derivationPath, constants_1.MIN_BIP_44_DEPTH);
        const node = await SLIP10Node_1.SLIP10Node.fromSeed({
            derivationPath,
            network,
            curve: 'secp256k1',
        }, cryptographicFunctions);
        return new BIP44Node(node);
    }
    get depth() {
        return __classPrivateFieldGet(this, _BIP44Node_node, "f").depth;
    }
    get privateKeyBytes() {
        return __classPrivateFieldGet(this, _BIP44Node_node, "f").privateKeyBytes;
    }
    get publicKeyBytes() {
        return __classPrivateFieldGet(this, _BIP44Node_node, "f").publicKeyBytes;
    }
    get chainCodeBytes() {
        return __classPrivateFieldGet(this, _BIP44Node_node, "f").chainCodeBytes;
    }
    get privateKey() {
        return __classPrivateFieldGet(this, _BIP44Node_node, "f").privateKey;
    }
    get publicKey() {
        return __classPrivateFieldGet(this, _BIP44Node_node, "f").publicKey;
    }
    get compressedPublicKey() {
        return __classPrivateFieldGet(this, _BIP44Node_node, "f").compressedPublicKey;
    }
    get compressedPublicKeyBytes() {
        return __classPrivateFieldGet(this, _BIP44Node_node, "f").compressedPublicKeyBytes;
    }
    get chainCode() {
        return __classPrivateFieldGet(this, _BIP44Node_node, "f").chainCode;
    }
    get address() {
        return __classPrivateFieldGet(this, _BIP44Node_node, "f").address;
    }
    get masterFingerprint() {
        return __classPrivateFieldGet(this, _BIP44Node_node, "f").masterFingerprint;
    }
    get parentFingerprint() {
        return __classPrivateFieldGet(this, _BIP44Node_node, "f").parentFingerprint;
    }
    get fingerprint() {
        return __classPrivateFieldGet(this, _BIP44Node_node, "f").fingerprint;
    }
    get index() {
        return __classPrivateFieldGet(this, _BIP44Node_node, "f").index;
    }
    get network() {
        return __classPrivateFieldGet(this, _BIP44Node_node, "f").network;
    }
    get extendedKey() {
        return __classPrivateFieldGet(this, _BIP44Node_node, "f").extendedKey;
    }
    get curve() {
        return __classPrivateFieldGet(this, _BIP44Node_node, "f").curve;
    }
    constructor(node) {
        _BIP44Node_node.set(this, void 0);
        __classPrivateFieldSet(this, _BIP44Node_node, node, "f");
        Object.freeze(this);
    }
    /**
     * Get a neutered version of this node, i.e. a node without a private key.
     *
     * @returns A neutered version of this node.
     */
    neuter() {
        const node = __classPrivateFieldGet(this, _BIP44Node_node, "f").neuter();
        return new BIP44Node(node);
    }
    /**
     * Derives a child of the key contains be this node and returns a new
     * {@link BIP44Node} containing the child key.
     *
     * The specified path must be a valid HD path from this node, per BIP-44.
     * At present, this means that the path must consist of no more than 5 BIP-32
     * nodes, depending on the depth of this node.
     *
     * Recall that a BIP-44 HD tree path consists of the following nodes:
     *
     * `m / 44' / coin_type' / account' / change / address_index`
     *
     * With the following depths:
     *
     * `0 / 1 / 2 / 3 / 4 / 5`
     *
     * @param path - The partial (non-rooted) BIP-44 HD tree path will be used
     * to derive a child key from the parent key contained within this node.
     * @returns The {@link BIP44Node} corresponding to the derived child key.
     */
    async derive(path) {
        if (this.depth === constants_1.MAX_BIP_44_DEPTH) {
            throw new Error('Illegal operation: This HD tree node is already a leaf node.');
        }
        const newDepth = this.depth + path.length;
        validateBIP44Depth(newDepth);
        validateBIP44DerivationPath(path, (this.depth + 1));
        const node = await __classPrivateFieldGet(this, _BIP44Node_node, "f").derive(path);
        return new BIP44Node(node);
    }
    // This is documented in the interface of this class.
    toJSON() {
        return {
            depth: this.depth,
            masterFingerprint: this.masterFingerprint,
            parentFingerprint: this.parentFingerprint,
            index: this.index,
            network: this.network,
            privateKey: this.privateKey,
            publicKey: this.publicKey,
            chainCode: this.chainCode,
        };
    }
}
exports.BIP44Node = BIP44Node;
_BIP44Node_node = new WeakMap();
/**
 * Validates a BIP-44 path depth. Effectively, asserts that the depth is an
 * integer `number` N such that 0 <= N <= 5. Throws an error if validation
 * fails.
 *
 * @param depth - The depth to validate.
 */
function validateBIP44Depth(depth) {
    (0, SLIP10Node_1.validateBIP32Depth)(depth);
    if (depth < constants_1.MIN_BIP_44_DEPTH || depth > constants_1.MAX_BIP_44_DEPTH) {
        throw new Error(`Invalid HD tree path depth: The depth must be a positive integer N such that 0 <= N <= 5. Received: "${depth}"`);
    }
}
exports.validateBIP44Depth = validateBIP44Depth;
/**
 * Ensures that the given derivation is valid by BIP-44.
 *
 * Recall that a BIP-44 HD tree path consists of the following nodes:
 *
 * `m / 44' / coin_type' / account' / change / address_index`
 *
 * With the following depths:
 *
 * `0 / 1 / 2 / 3 / 4 / 5`
 *
 * @param path - The path to validate.
 * @param startingDepth - The depth of the first node of the derivation path.
 */
function validateBIP44DerivationPath(path, startingDepth) {
    path.forEach((nodeToken, index) => {
        const currentDepth = startingDepth + index;
        if (currentDepth === constants_1.MIN_BIP_44_DEPTH) {
            if (!(nodeToken instanceof Uint8Array) &&
                !constants_1.BIP_39_PATH_REGEX.test(nodeToken)) {
                throw new Error('Invalid derivation path: The "m" / seed node (depth 0) must be a BIP-39 node.');
            }
            return;
        }
        (0, utils_1.assert)(typeof nodeToken === 'string');
        // eslint-disable-next-line default-case
        switch (currentDepth) {
            case 1:
                if (nodeToken !== constants_1.BIP44PurposeNodeToken) {
                    throw new Error(`Invalid derivation path: The "purpose" node (depth 1) must be the string "${constants_1.BIP44PurposeNodeToken}".`);
                }
                break;
            case 2:
                if (!constants_1.BIP_32_PATH_REGEX.test(nodeToken) || !(0, utils_2.isHardened)(nodeToken)) {
                    throw new Error('Invalid derivation path: The "coin_type" node (depth 2) must be a hardened BIP-32 node.');
                }
                break;
            case 3:
                if (!constants_1.BIP_32_PATH_REGEX.test(nodeToken) || !(0, utils_2.isHardened)(nodeToken)) {
                    throw new Error('Invalid derivation path: The "account" node (depth 3) must be a hardened BIP-32 node.');
                }
                break;
            case 4:
                if (!constants_1.BIP_32_PATH_REGEX.test(nodeToken)) {
                    throw new Error('Invalid derivation path: The "change" node (depth 4) must be a BIP-32 node.');
                }
                break;
            case constants_1.MAX_BIP_44_DEPTH: // 5
                if (!constants_1.BIP_32_PATH_REGEX.test(nodeToken)) {
                    throw new Error('Invalid derivation path: The "address_index" node (depth 5) must be a BIP-32 node.');
                }
                break;
        }
    });
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules\\@metamask\\key-tree\\dist\\BIP44Node.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\SLIP10Node.cjs", {"./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\constants.cjs","./curves/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\curves\\index.cjs","./derivation.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\derivation.cjs","./derivers/bip32.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\derivers\\bip32.cjs","./derivers/bip39.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\derivers\\bip39.cjs","./extended-keys.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\extended-keys.cjs","./guard.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\guard.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\utils.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckey-tree%5Cdist%5CSLIP10Node.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var _a, _SLIP10Node_constructorGuard, _SLIP10Node_publicKeyBytes, _SLIP10Node_cryptographicFunctions;
Object.defineProperty(exports, "__esModule", { value: true });
exports.deriveChildNode = exports.validateRootIndex = exports.validateMasterParentFingerprint = exports.validateParentFingerprint = exports.validateBIP32Depth = exports.SLIP10Node = void 0;
const utils_1 = require("@metamask/utils");
const constants_1 = require("./constants.cjs");
const curves_1 = require("./curves/index.cjs");
const derivation_1 = require("./derivation.cjs");
const bip32_1 = require("./derivers/bip32.cjs");
const bip39_1 = require("./derivers/bip39.cjs");
const extended_keys_1 = require("./extended-keys.cjs");
const guard_1 = require("./guard.cjs");
const utils_2 = require("./utils.cjs");
class SLIP10Node {
    /**
     * Wrapper of the {@link fromExtendedKey} function. Refer to that function
     * for documentation.
     *
     * @param json - The JSON representation of a SLIP-10 node.
     * @param cryptographicFunctions - The cryptographic functions to use. If
     * provided, these will be used instead of the built-in implementations.
     * @returns A SLIP10 node.
     */
    static async fromJSON(json, cryptographicFunctions) {
        return _a.fromExtendedKey(json, cryptographicFunctions);
    }
    /**
     * Create a new SLIP-10 node from a key and chain code. You must specify
     * either a private key or a public key. When specifying a private key,
     * the public key will be derived from the private key.
     *
     * All parameters are stringently validated, and an error is thrown if
     * validation fails.
     *
     * @param options - The options for the new node. This can be an object
     * containing the extended key options, or a string containing the extended
     * key.
     * @param options.depth - The depth of the node.
     * @param options.masterFingerprint - The fingerprint of the master node, i.e., the
     * node at depth 0. May be undefined if this node was created from an extended
     * key.
     * @param options.parentFingerprint - The fingerprint of the parent key, or 0 if
     * the node is a master node.
     * @param options.index - The index of the node, or 0 if the node is a master node.
     * @param options.privateKey - The private key for the node.
     * @param options.publicKey - The public key for the node. If a private key is
     * specified, this parameter is ignored.
     * @param options.chainCode - The chain code for the node.
     * @param options.curve - The curve used by the node.
     * @param cryptographicFunctions - The cryptographic functions to use. If
     * provided, these will be used instead of the built-in implementations.
     * @returns A SLIP10 node.
     */
    static async fromExtendedKey(options, cryptographicFunctions) {
        if (typeof options === 'string') {
            const extendedKey = (0, extended_keys_1.decodeExtendedKey)(options);
            const { chainCode, depth, parentFingerprint, index } = extendedKey;
            if (extendedKey.type === 'private') {
                const { privateKey } = extendedKey;
                return _a.fromExtendedKey({
                    depth,
                    parentFingerprint,
                    index,
                    privateKey,
                    chainCode,
                    // BIP-32 key serialisation assumes `secp256k1`.
                    curve: 'secp256k1',
                }, cryptographicFunctions);
            }
            const { publicKey } = extendedKey;
            return _a.fromExtendedKey({
                depth,
                parentFingerprint,
                index,
                publicKey,
                chainCode,
                // BIP-32 key serialisation assumes `secp256k1`.
                curve: 'secp256k1',
            }, cryptographicFunctions);
        }
        const { depth, masterFingerprint, parentFingerprint, index, network, privateKey, publicKey, chainCode, curve, guard, } = options;
        const chainCodeBytes = (0, utils_2.getBytes)(chainCode, constants_1.BYTES_KEY_LENGTH);
        (0, utils_2.validateCurve)(curve);
        validateBIP32Depth(depth);
        (0, utils_2.validateBIP32Index)(index);
        validateRootIndex(index, depth);
        (0, utils_2.validateNetwork)(network);
        validateParentFingerprint(parentFingerprint, depth);
        validateMasterParentFingerprint(masterFingerprint, parentFingerprint, depth);
        const curveObject = (0, curves_1.getCurveByName)(curve);
        if (privateKey) {
            const privateKeyBytes = (0, utils_2.getBytesUnsafe)(privateKey, curveObject.privateKeyLength);
            (0, utils_1.assert)(curveObject.isValidPrivateKey(privateKeyBytes), `Invalid private key: Value is not a valid ${curve} private key.`);
            const trustedPublicKey = guard === guard_1.PUBLIC_KEY_GUARD && publicKey
                ? // `publicKey` is typed as `string | Uint8Array`, but we know it's
                    // a `Uint8Array` because of the guard. We use `getBytes` to ensure
                    // the type is correct.
                    (0, utils_2.getBytes)(publicKey, curveObject.publicKeyLength)
                : undefined;
            return new _a({
                depth,
                masterFingerprint,
                parentFingerprint,
                index,
                network,
                chainCode: chainCodeBytes,
                privateKey: privateKeyBytes,
                publicKey: trustedPublicKey,
                curve,
            }, cryptographicFunctions, __classPrivateFieldGet(this, _a, "f", _SLIP10Node_constructorGuard));
        }
        if (publicKey) {
            const publicKeyBytes = (0, utils_2.getBytes)(publicKey, curveObject.publicKeyLength);
            return new _a({
                depth,
                masterFingerprint,
                parentFingerprint,
                index,
                network,
                chainCode: chainCodeBytes,
                publicKey: publicKeyBytes,
                curve,
            }, cryptographicFunctions, __classPrivateFieldGet(this, _a, "f", _SLIP10Node_constructorGuard));
        }
        throw new Error('Invalid options: Must provide either a private key or a public key.');
    }
    /**
     * Create a new SLIP-10 node from a derivation path. The derivation path
     * must be rooted, i.e. it must begin with a BIP-39 node, given as a string of
     * the form `bip39:MNEMONIC`, where `MNEMONIC` is a space-separated list of
     * BIP-39 seed phrase words.
     *
     * All parameters are stringently validated, and an error is thrown if
     * validation fails.
     *
     * Recall that a BIP-44 HD tree path consists of the following nodes:
     *
     * `m / 44' / coin_type' / account' / change / address_index`
     *
     * With the following depths:
     *
     * `0 / 1 / 2 / 3 / 4 / 5`
     *
     * @param options - The options for the new node.
     * @param options.derivationPath - The rooted HD tree path that will be used
     * to derive the key of this node.
     * @param options.curve - The curve used by the node.
     * @param options.network - The network for the node. This is only used for
     * extended keys, and defaults to `mainnet`.
     * @param cryptographicFunctions - The cryptographic functions to use. If
     * provided, these will be used instead of the built-in implementations.
     * @returns A new SLIP-10 node.
     */
    static async fromDerivationPath({ derivationPath, network, curve }, cryptographicFunctions) {
        (0, utils_2.validateCurve)(curve);
        if (!derivationPath) {
            throw new Error('Invalid options: Must provide a derivation path.');
        }
        if (derivationPath.length === 0) {
            throw new Error('Invalid derivation path: May not specify an empty derivation path.');
        }
        // `deriveKeyFromPath` expects a seed derivation path, so we need to
        // convert the rooted path to a seed path.
        const seedDerivationPath = await (0, bip39_1.getDerivationPathWithSeed)({
            path: derivationPath,
            curve,
        }, cryptographicFunctions);
        return await (0, derivation_1.deriveKeyFromPath)({
            path: seedDerivationPath,
            depth: derivationPath.length - 1,
            network,
            curve,
        }, cryptographicFunctions);
    }
    /**
     * Create a new SLIP-10 node from a BIP-39 seed. The derivation path
     * must be rooted, i.e. it must begin with a BIP-39 node, given as a
     * `Uint8Array` of the seed bytes.
     *
     * All parameters are stringently validated, and an error is thrown if
     * validation fails.
     *
     * @param options - The options for the new node.
     * @param options.derivationPath - The rooted HD tree path that will be used
     * to derive the key of this node.
     * @param options.curve - The curve used by the node.
     * @param options.network - The network for the node. This is only used for
     * extended keys, and defaults to `mainnet`.
     * @param cryptographicFunctions - The cryptographic functions to use. If
     * provided, these will be used instead of the built-in implementations.
     * @returns A new SLIP-10 node.
     */
    static async fromSeed({ derivationPath, network, curve }, cryptographicFunctions) {
        (0, utils_2.validateCurve)(curve);
        if (curve === 'ed25519Bip32') {
            throw new Error('Invalid curve: The curve "ed25519Bip32" is not supported by the `fromSeed` function.');
        }
        if (!derivationPath) {
            throw new Error('Invalid options: Must provide a derivation path.');
        }
        if (derivationPath.length === 0) {
            throw new Error('Invalid derivation path: May not specify an empty derivation path.');
        }
        return await (0, derivation_1.deriveKeyFromPath)({
            path: derivationPath,
            depth: derivationPath.length - 1,
            network,
            curve,
        }, cryptographicFunctions);
    }
    // eslint-disable-next-line no-restricted-syntax
    constructor({ depth, masterFingerprint, parentFingerprint, index, network = 'mainnet', chainCode, privateKey, publicKey, curve, }, cryptographicFunctions = {}, constructorGuard) {
        _SLIP10Node_publicKeyBytes.set(this, void 0);
        _SLIP10Node_cryptographicFunctions.set(this, void 0);
        (0, utils_1.assert)(constructorGuard === __classPrivateFieldGet(_a, _a, "f", _SLIP10Node_constructorGuard), 'SLIP10Node can only be constructed using `SLIP10Node.fromJSON`, `SLIP10Node.fromExtendedKey`, `SLIP10Node.fromDerivationPath`, or `SLIP10Node.fromSeed`.');
        (0, utils_1.assert)(privateKey !== undefined || publicKey !== undefined, 'SLIP10Node requires either a private key or a public key to be set.');
        this.depth = depth;
        this.masterFingerprint = masterFingerprint;
        this.parentFingerprint = parentFingerprint;
        this.index = index;
        this.network = network;
        this.chainCodeBytes = chainCode;
        this.privateKeyBytes = privateKey;
        this.curve = curve;
        __classPrivateFieldSet(this, _SLIP10Node_publicKeyBytes, publicKey, "f");
        __classPrivateFieldSet(this, _SLIP10Node_cryptographicFunctions, cryptographicFunctions, "f");
        Object.freeze(this);
    }
    get chainCode() {
        return (0, utils_1.bytesToHex)(this.chainCodeBytes);
    }
    get privateKey() {
        if (this.privateKeyBytes) {
            return (0, utils_1.bytesToHex)(this.privateKeyBytes);
        }
        return undefined;
    }
    get publicKey() {
        return (0, utils_1.bytesToHex)(this.publicKeyBytes);
    }
    /**
     * Get the public key bytes. This will lazily derive the public key from the
     * private key if it is not already set.
     *
     * @returns The public key bytes.
     */
    get publicKeyBytes() {
        if (__classPrivateFieldGet(this, _SLIP10Node_publicKeyBytes, "f") !== undefined) {
            return __classPrivateFieldGet(this, _SLIP10Node_publicKeyBytes, "f");
        }
        // This assertion is mainly for type safety, as `SLIP10Node` requires either
        // a private key or a public key to always be set.
        (0, utils_1.assert)(this.privateKeyBytes, 'Either a private key or public key is required.');
        __classPrivateFieldSet(this, _SLIP10Node_publicKeyBytes, (0, curves_1.getCurveByName)(this.curve).getPublicKey(this.privateKeyBytes), "f");
        return __classPrivateFieldGet(this, _SLIP10Node_publicKeyBytes, "f");
    }
    get compressedPublicKeyBytes() {
        return (0, curves_1.getCurveByName)(this.curve).compressPublicKey(this.publicKeyBytes);
    }
    get compressedPublicKey() {
        return (0, utils_1.bytesToHex)(this.compressedPublicKeyBytes);
    }
    get address() {
        if (this.curve !== 'secp256k1') {
            throw new Error('Unable to get address for this node: Only secp256k1 is supported.');
        }
        return (0, utils_1.bytesToHex)((0, bip32_1.publicKeyToEthAddress)(this.publicKeyBytes));
    }
    get fingerprint() {
        return (0, utils_2.getFingerprint)(this.compressedPublicKeyBytes, (0, curves_1.getCurveByName)(this.curve).compressedPublicKeyLength);
    }
    /**
     * Get the extended public or private key for the SLIP-10 node. SLIP-10
     * doesn't specify a format for extended keys, so we use the BIP-32 format.
     *
     * This property is only supported for `secp256k1` nodes, as other curves
     * don't specify a standard format for extended keys.
     *
     * @returns The extended public or private key for the node.
     */
    get extendedKey() {
        (0, utils_1.assert)(this.curve === 'secp256k1', 'Unable to get extended key for this node: Only secp256k1 is supported.');
        const data = {
            depth: this.depth,
            parentFingerprint: this.parentFingerprint,
            index: this.index,
            network: this.network,
            chainCode: this.chainCodeBytes,
        };
        if (this.privateKeyBytes) {
            return (0, extended_keys_1.encodeExtendedKey)({
                ...data,
                type: 'private',
                privateKey: this.privateKeyBytes,
            });
        }
        return (0, extended_keys_1.encodeExtendedKey)({
            ...data,
            type: 'public',
            publicKey: this.publicKeyBytes,
        });
    }
    /**
     * Get a neutered version of this node, i.e. a node without a private key.
     *
     * @returns A neutered version of this node.
     */
    neuter() {
        return new _a({
            depth: this.depth,
            masterFingerprint: this.masterFingerprint,
            parentFingerprint: this.parentFingerprint,
            index: this.index,
            chainCode: this.chainCodeBytes,
            publicKey: this.publicKeyBytes,
            curve: this.curve,
            network: this.network,
        }, __classPrivateFieldGet(this, _SLIP10Node_cryptographicFunctions, "f"), __classPrivateFieldGet(_a, _a, "f", _SLIP10Node_constructorGuard));
    }
    /**
     * Derives a child of the key contains be this node and returns a new
     * {@link SLIP10Node} containing the child key.
     *
     * The specified path must be a valid HD path from this node, per SLIP-10.
     *
     * @param path - The partial (non-rooted) SLIP-10 HD tree path will be used
     * to derive a child key from the parent key contained within this node.
     * @returns The {@link SLIP10Node} corresponding to the derived child key.
     */
    async derive(path) {
        return await deriveChildNode({
            path,
            node: this,
        }, __classPrivateFieldGet(this, _SLIP10Node_cryptographicFunctions, "f"));
    }
    // This is documented in the interface of this class.
    toJSON() {
        return {
            depth: this.depth,
            masterFingerprint: this.masterFingerprint,
            parentFingerprint: this.parentFingerprint,
            index: this.index,
            network: this.network,
            curve: this.curve,
            privateKey: this.privateKey,
            publicKey: this.publicKey,
            chainCode: this.chainCode,
        };
    }
}
exports.SLIP10Node = SLIP10Node;
_a = SLIP10Node, _SLIP10Node_publicKeyBytes = new WeakMap(), _SLIP10Node_cryptographicFunctions = new WeakMap();
_SLIP10Node_constructorGuard = { value: Symbol('SLIP10Node.constructor') };
/**
 * Validates a BIP-32 path depth. Effectively, asserts that the depth is an
 * integer `number`. Throws an error if validation fails.
 *
 * @param depth - The depth to validate.
 */
function validateBIP32Depth(depth) {
    if (!(0, utils_2.isValidInteger)(depth)) {
        throw new Error(`Invalid HD tree path depth: The depth must be a positive integer. Received: "${String(depth)}".`);
    }
}
exports.validateBIP32Depth = validateBIP32Depth;
/**
 * Validates a BIP-32 parent fingerprint. Effectively, asserts that the fingerprint is an
 * integer `number`. Throws an error if validation fails.
 *
 * @param parentFingerprint - The parent fingerprint to validate.
 * @param depth - The depth of the node to validate.
 * @throws If the parent fingerprint is not a positive integer, or invalid for
 * the current depth.
 */
function validateParentFingerprint(parentFingerprint, depth) {
    if (!(0, utils_2.isValidInteger)(parentFingerprint)) {
        throw new Error(`Invalid parent fingerprint: The fingerprint must be a positive integer. Received: "${String(parentFingerprint)}".`);
    }
    if (depth === 0 && parentFingerprint !== 0) {
        throw new Error(`Invalid parent fingerprint: The fingerprint of the root node must be 0. Received: "${String(parentFingerprint)}".`);
    }
    if (depth > 0 && parentFingerprint === 0) {
        throw new Error(`Invalid parent fingerprint: The fingerprint of a child node must not be 0. Received: "${String(parentFingerprint)}".`);
    }
}
exports.validateParentFingerprint = validateParentFingerprint;
/**
 * Validate that a given combination of master fingerprint and parent
 * fingerprint is valid for the given depth.
 *
 * @param masterFingerprint - The master fingerprint to validate.
 * @param parentFingerprint - The parent fingerprint to validate.
 * @param depth - The depth of the node to validate.
 * @throws If the combination of master fingerprint and parent fingerprint is
 * invalid for the given depth.
 */
function validateMasterParentFingerprint(masterFingerprint, parentFingerprint, depth) {
    // The master fingerprint is optional.
    if (!masterFingerprint) {
        return;
    }
    if (depth >= 2 && masterFingerprint === parentFingerprint) {
        throw new Error(`Invalid parent fingerprint: The fingerprint of a child node cannot be equal to the master fingerprint. Received: "${String(parentFingerprint)}".`);
    }
}
exports.validateMasterParentFingerprint = validateMasterParentFingerprint;
/**
 * Validate that the index is zero for the root node.
 *
 * @param index - The index to validate.
 * @param depth - The depth of the node to validate.
 * @throws If the index is not zero for the root node.
 */
function validateRootIndex(index, depth) {
    if (depth === 0 && index !== 0) {
        throw new Error(`Invalid index: The index of the root node must be 0. Received: "${String(index)}".`);
    }
}
exports.validateRootIndex = validateRootIndex;
/**
 * Derives a child key from the given parent key.
 *
 * @param options - The options to use when deriving the child key.
 * @param options.node - The node to derive from.
 * @param options.path - The path to the child node / key.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns The derived key and depth.
 */
async function deriveChildNode({ path, node }, cryptographicFunctions) {
    if (path.length === 0) {
        throw new Error('Invalid HD tree derivation path: Deriving a path of length 0 is not defined.');
    }
    // Note that we do not subtract 1 from the length of the path to the child,
    // unlike when we calculate the depth of a rooted path.
    const newDepth = node.depth + path.length;
    validateBIP32Depth(newDepth);
    return await (0, derivation_1.deriveKeyFromPath)({
        path,
        node,
        depth: newDepth,
    }, cryptographicFunctions);
}
exports.deriveChildNode = deriveChildNode;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules\\@metamask\\key-tree\\dist\\SLIP10Node.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\constants.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckey-tree%5Cdist%5Cconstants.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BIP_32_HARDENED_OFFSET = exports.BIP_39_PATH_REGEX = exports.CIP_3_PATH_REGEX = exports.SLIP_10_PATH_REGEX = exports.BIP_32_PATH_REGEX = exports.UNPREFIXED_BIP_32_PATH_REGEX = exports.UNPREFIXED_PATH_REGEX = exports.BIP44PurposeNodeToken = exports.MAX_BIP_32_INDEX = exports.MAX_UNHARDENED_BIP_32_INDEX = exports.MAX_BIP_44_DEPTH = exports.MIN_BIP_44_DEPTH = exports.BYTES_KEY_LENGTH = void 0;
exports.BYTES_KEY_LENGTH = 32;
exports.MIN_BIP_44_DEPTH = 0;
exports.MAX_BIP_44_DEPTH = 5;
exports.MAX_UNHARDENED_BIP_32_INDEX = 0x7fffffff; // 2^31 - 1
exports.MAX_BIP_32_INDEX = 0xffffffff; // 2^32 - 1
exports.BIP44PurposeNodeToken = `bip32:44'`;
exports.UNPREFIXED_PATH_REGEX = /^\d+$/u;
/**
 * e.g.
 * -  0
 * -  0'
 */
exports.UNPREFIXED_BIP_32_PATH_REGEX = /^(?<index>\d+)'?$/u;
/**
 * e.g.
 * -  bip32:0
 * -  bip32:0'
 */
exports.BIP_32_PATH_REGEX = /^bip32:\d+'?$/u;
/**
 * e.g.
 * -  slip10:0
 * -  slip10:0'
 */
exports.SLIP_10_PATH_REGEX = /^slip10:\d+'?$/u;
/**
 * e.g.
 * -  cip3:0
 * -  cip3:0'
 */
exports.CIP_3_PATH_REGEX = /^cip3:\d+'?$/u;
/**
 * bip39:<SPACE_DELMITED_SEED_PHRASE>
 *
 * The seed phrase must consist of 12 <= 24 words.
 */
exports.BIP_39_PATH_REGEX = /^bip39:([a-z]+){1}( [a-z]+){11,23}$/u;
exports.BIP_32_HARDENED_OFFSET = 0x80000000;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules\\@metamask\\key-tree\\dist\\constants.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\cryptography.cjs", {"./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\utils.cjs","@noble/hashes/hmac":"D:\\code\\v\\metamask-extension\\node_modules\\@noble\\hashes\\hmac.js","@noble/hashes/pbkdf2":"D:\\code\\v\\metamask-extension\\node_modules\\@noble\\hashes\\pbkdf2.js","@noble/hashes/ripemd160":"D:\\code\\v\\metamask-extension\\node_modules\\@noble\\hashes\\ripemd160.js","@noble/hashes/sha256":"D:\\code\\v\\metamask-extension\\node_modules\\@noble\\hashes\\sha256.js","@noble/hashes/sha3":"D:\\code\\v\\metamask-extension\\node_modules\\@noble\\hashes\\sha3.js","@noble/hashes/sha512":"D:\\code\\v\\metamask-extension\\node_modules\\@noble\\hashes\\sha512.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckey-tree%5Cdist%5Ccryptography.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sha256 = exports.ripemd160 = exports.pbkdf2Sha512 = exports.keccak256 = exports.hmacSha512 = void 0;
const hmac_1 = require("@noble/hashes/hmac");
const pbkdf2_1 = require("@noble/hashes/pbkdf2");
const ripemd160_1 = require("@noble/hashes/ripemd160");
const sha256_1 = require("@noble/hashes/sha256");
const sha3_1 = require("@noble/hashes/sha3");
const sha512_1 = require("@noble/hashes/sha512");
const utils_1 = require("./utils.cjs");
/**
 * Compute the HMAC-SHA-512 of the given data using the given key.
 *
 * This function uses the Web Crypto API if available, falling back to a
 * JavaScript implementation if not.
 *
 * @param key - The key to use.
 * @param data - The data to hash.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns The HMAC-SHA-512 of the data.
 */
async function hmacSha512(key, data, cryptographicFunctions = {}) {
    if (cryptographicFunctions.hmacSha512) {
        return await cryptographicFunctions.hmacSha512(key, data);
    }
    if ((0, utils_1.isWebCryptoSupported)()) {
        /* eslint-disable no-restricted-globals */
        const subtleKey = await crypto.subtle.importKey('raw', key, { name: 'HMAC', hash: 'SHA-512' }, false, ['sign']);
        const result = await crypto.subtle.sign('HMAC', subtleKey, data);
        return new Uint8Array(result);
        /* eslint-enable no-restricted-globals */
    }
    return (0, hmac_1.hmac)(sha512_1.sha512, key, data);
}
exports.hmacSha512 = hmacSha512;
/**
 * Compute the Keccak-256 of the given data synchronously.
 *
 * Right now this is just a wrapper around `keccak256` from the `@noble/hashes`
 * package, but it's here in case we want to change the implementation in the
 * future to allow for asynchronous hashing.
 *
 * @param data - The data to hash.
 * @returns The Keccak-256 of the data.
 */
function keccak256(data) {
    return (0, sha3_1.keccak_256)(data);
}
exports.keccak256 = keccak256;
/**
 * Compute the PBKDF2 of the given password, salt, iterations, and key length.
 * The hash function used is SHA-512.
 *
 * @param password - The password to hash.
 * @param salt - The salt to use.
 * @param iterations - The number of iterations.
 * @param keyLength - The desired key length.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns The PBKDF2 of the password.
 */
async function pbkdf2Sha512(password, salt, iterations, keyLength, cryptographicFunctions = {}) {
    if (cryptographicFunctions.pbkdf2Sha512) {
        return await cryptographicFunctions.pbkdf2Sha512(password, salt, iterations, keyLength);
    }
    if ((0, utils_1.isWebCryptoSupported)()) {
        /* eslint-disable no-restricted-globals */
        const key = await crypto.subtle.importKey('raw', password, { name: 'PBKDF2' }, false, ['deriveBits']);
        const derivedBits = await crypto.subtle.deriveBits({
            name: 'PBKDF2',
            salt,
            iterations,
            hash: { name: 'SHA-512' },
        }, key, 
        // `keyLength` is the number of bytes, but `deriveBits` expects the
        // number of bits, so we multiply by 8.
        keyLength * 8);
        return new Uint8Array(derivedBits);
        /* eslint-enable no-restricted-globals */
    }
    return await (0, pbkdf2_1.pbkdf2Async)(sha512_1.sha512, password, salt, {
        c: iterations,
        dkLen: keyLength,
    });
}
exports.pbkdf2Sha512 = pbkdf2Sha512;
/**
 * Compute the RIPEMD-160 of the given data.
 *
 * Right now this is just a wrapper around `ripemd160` from the `@noble/hashes`
 * package, but it's here in case we want to change the implementation in the
 * future to allow for asynchronous hashing.
 *
 * @param data - The data to hash.
 * @returns The RIPEMD-160 of the data.
 */
function ripemd160(data) {
    return (0, ripemd160_1.ripemd160)(data);
}
exports.ripemd160 = ripemd160;
/**
 * Compute the SHA-256 of the given data synchronously.
 *
 * Right now this is just a wrapper around `sha256` from the `@noble/hashes`
 * package, but it's here in case we want to change the implementation in the
 * future to allow for asynchronous hashing.
 *
 * @param data - The data to hash.
 * @returns The SHA-256 of the data.
 */
function sha256(data) {
    return (0, sha256_1.sha256)(data);
}
exports.sha256 = sha256;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules\\@metamask\\key-tree\\dist\\cryptography.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\curves\\curve.cjs", {"./ed25519.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\curves\\ed25519.cjs","./ed25519Bip32.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\curves\\ed25519Bip32.cjs","./secp256k1.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\curves\\secp256k1.cjs","@noble/curves/abstract/modular":"D:\\code\\v\\metamask-extension\\node_modules\\@noble\\curves\\abstract\\modular.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckey-tree%5Cdist%5Ccurves%5Ccurve.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mod = exports.getCurveByName = exports.curves = void 0;
const ed25519 = __importStar(require("./ed25519.cjs"));
const ed25519Bip32 = __importStar(require("./ed25519Bip32.cjs"));
const secp256k1 = __importStar(require("./secp256k1.cjs"));
exports.curves = {
    secp256k1,
    ed25519,
    ed25519Bip32,
};
/**
 * Get a curve by name.
 *
 * @param curveName - The name of the curve to get.
 * @returns The curve.
 */
function getCurveByName(curveName) {
    return exports.curves[curveName];
}
exports.getCurveByName = getCurveByName;
var modular_1 = require("@noble/curves/abstract/modular");
Object.defineProperty(exports, "mod", { enumerable: true, get: function () { return modular_1.mod; } });

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules\\@metamask\\key-tree\\dist\\curves\\curve.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\curves\\ed25519.cjs", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","@noble/curves/ed25519":"D:\\code\\v\\metamask-extension\\node_modules\\@noble\\curves\\ed25519.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckey-tree%5Cdist%5Ccurves%5Ced25519.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compressedPublicKeyLength = exports.masterNodeGenerationSpec = exports.privateKeyLength = exports.decompressPublicKey = exports.compressPublicKey = exports.publicAdd = exports.getPublicKey = exports.publicKeyLength = exports.deriveUnhardenedKeys = exports.isValidPrivateKey = exports.secret = exports.name = exports.curve = void 0;
const utils_1 = require("@metamask/utils");
const ed25519_1 = require("@noble/curves/ed25519");
exports.curve = ed25519_1.ed25519.CURVE;
exports.name = 'ed25519';
// Secret is defined in SLIP-10:
// https://github.com/satoshilabs/slips/blob/133ea52a8e43d338b98be208907e144277e44c0e/slip-0010.md#master-key-generation
exports.secret = (0, utils_1.stringToBytes)('ed25519 seed');
// All private keys are valid for ed25519:
// https://github.com/satoshilabs/slips/blob/133ea52a8e43d338b98be208907e144277e44c0e/slip-0010.md#master-key-generation
const isValidPrivateKey = (_privateKey) => true;
exports.isValidPrivateKey = isValidPrivateKey;
exports.deriveUnhardenedKeys = false;
exports.publicKeyLength = 33;
const getGetPublicKey = () => {
    let hasSetWindowSize = false;
    const getPublicKey = (privateKey, _compressed) => {
        if (!hasSetWindowSize) {
            ed25519_1.ed25519.ExtendedPoint.BASE._setWindowSize(4);
            hasSetWindowSize = true;
        }
        const publicKey = ed25519_1.ed25519.getPublicKey(privateKey);
        return (0, utils_1.concatBytes)([new Uint8Array([0]), publicKey]);
    };
    return getPublicKey;
};
exports.getPublicKey = getGetPublicKey();
const publicAdd = (_publicKey, _tweak) => {
    throw new Error('Ed25519 does not support public key derivation.');
};
exports.publicAdd = publicAdd;
const compressPublicKey = (publicKey) => {
    // Ed25519 public keys don't have a compressed form.
    return publicKey;
};
exports.compressPublicKey = compressPublicKey;
const decompressPublicKey = (publicKey) => {
    // Ed25519 public keys don't have a compressed form.
    return publicKey;
};
exports.decompressPublicKey = decompressPublicKey;
exports.privateKeyLength = 32;
exports.masterNodeGenerationSpec = 'slip10';
exports.compressedPublicKeyLength = 33;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules\\@metamask\\key-tree\\dist\\curves\\ed25519.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\curves\\ed25519Bip32.cjs", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","@noble/curves/abstract/modular":"D:\\code\\v\\metamask-extension\\node_modules\\@noble\\curves\\abstract\\modular.js","@noble/curves/ed25519":"D:\\code\\v\\metamask-extension\\node_modules\\@noble\\curves\\ed25519.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckey-tree%5Cdist%5Ccurves%5Ced25519Bip32.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compressedPublicKeyLength = exports.masterNodeGenerationSpec = exports.privateKeyLength = exports.decompressPublicKey = exports.compressPublicKey = exports.publicAdd = exports.getPublicKey = exports.multiplyWithBase = exports.bytesToNumberLE = exports.publicKeyLength = exports.deriveUnhardenedKeys = exports.isValidPrivateKey = exports.secret = exports.name = exports.curve = void 0;
const utils_1 = require("@metamask/utils");
const modular_1 = require("@noble/curves/abstract/modular");
const ed25519_1 = require("@noble/curves/ed25519");
exports.curve = ed25519_1.ed25519.CURVE;
/**
 * Named after whitepaper: BIP32-Ed25519 Hierarchical Deterministic Keys over a Non-linear Keyspace
 * https://input-output-hk.github.io/adrestia/static/Ed25519_BIP.pdf
 * "vanilla" "ed25519" curve follows SLIP10: https://tezos.stackexchange.com/questions/2837/can-i-use-bip32-hd-key-pairs-to-derive-ed25519-addresses
 * note that that the important difference of the "bip32" version is that it allows unhardened key derivation
 */
exports.name = 'ed25519Bip32';
// Secret is empty string if not provided by user
exports.secret = (0, utils_1.stringToBytes)('');
/**
 * Get a byte from a private key at a given index.
 *
 * @param privateKey - The private key.
 * @param index - The index of the byte to get.
 * @returns The byte at the given index.
 * @throws If the private key is too short.
 */
function getByte(privateKey, index) {
    const byte = privateKey[index];
    (0, utils_1.assert)(byte !== undefined, 'Private key is too short.');
    return byte;
}
/**
 * Check if a private key is valid.
 *
 * @param privateKey - The private key to check.
 * @returns Whether the private key is valid.
 */
const isValidPrivateKey = (privateKey) => {
    /* eslint-disable no-bitwise */
    // Lowest 3 bits of the first byte must be zero
    if ((getByte(privateKey, 0) & 0b00000111) !== 0) {
        return false;
    }
    // The highest bit of the last byte must be zero
    if ((getByte(privateKey, 31) & 0b10000000) !== 0) {
        return false;
    }
    // The second highest bit of the last byte must be one
    if ((getByte(privateKey, 31) & 0b01000000) !== 0b01000000) {
        return false;
    }
    /* eslint-enable no-bitwise */
    return true;
};
exports.isValidPrivateKey = isValidPrivateKey;
exports.deriveUnhardenedKeys = true;
exports.publicKeyLength = 32;
/**
 * Converts a Uint8Array of bytes to a bigint in little-endian format.
 *
 * @param bytes - The Uint8Array of bytes to convert.
 * @returns The converted bigint value.
 */
const bytesToNumberLE = (bytes) => {
    return (0, utils_1.hexToBigInt)((0, utils_1.bytesToHex)(Uint8Array.from(bytes).reverse()));
};
exports.bytesToNumberLE = bytesToNumberLE;
/**
 * Multiplies the given key with the base point on the Edwards curve.
 * equivalent to https://github.com/jedisct1/libsodium/blob/93a6e79750a31bc0b946bf483b2ba1c77f9e94ce/src/libsodium/crypto_scalarmult/ed25519/ref10/scalarmult_ed25519_ref10.c#L105 .
 * which is used by cardano-js-sdk/crypto https://github.com/input-output-hk/cardano-js-sdk/blob/8a6db2a251cd1c956f52730a0d35de2b7fc67404/packages/crypto/src/Bip32/Bip32PrivateKey.ts#L161 .
 *
 * @param key - The key to multiply with the base point.
 * @returns The resulting point on the Edwards curve.
 */
const multiplyWithBase = (key) => {
    // Little-endian SHA512 with modulo n
    const scalar = (0, modular_1.mod)((0, exports.bytesToNumberLE)(key), exports.curve.n); // The actual scalar
    const point = ed25519_1.ed25519.ExtendedPoint.BASE.multiply(scalar); // Point on Edwards curve aka public key
    return point.toRawBytes(); // Uint8Array representation
};
exports.multiplyWithBase = multiplyWithBase;
/**
 * Calculates the public key corresponding to a given private key.
 *
 * @param privateKey - The private key.
 * @param _compressed - Optional parameter to indicate if the public key should be compressed.
 * @returns The public key.
 */
const getPublicKey = (privateKey, _compressed) => {
    return (0, exports.multiplyWithBase)(privateKey.slice(0, 32));
};
exports.getPublicKey = getPublicKey;
/**
 * Adds a tweak to a public key.
 *
 * @param publicKey - The public key.
 * @param tweak - The tweak to add.
 * @returns The resulting public key.
 */
const publicAdd = (publicKey, tweak) => {
    return ed25519_1.ed25519.ExtendedPoint.fromHex((0, utils_1.remove0x)((0, utils_1.bytesToHex)(publicKey)))
        .add(ed25519_1.ed25519.ExtendedPoint.fromHex((0, utils_1.remove0x)((0, utils_1.bytesToHex)(tweak))))
        .toRawBytes();
};
exports.publicAdd = publicAdd;
/**
 * Compresses an Ed25519 public key.
 *
 * @param publicKey - The public key to compress.
 * @returns The compressed public key.
 */
const compressPublicKey = (publicKey) => {
    // Ed25519 public keys don't have a compressed form.
    return publicKey;
};
exports.compressPublicKey = compressPublicKey;
/**
 * Decompresses a compressed Ed25519Bip32 public key.
 *
 * @param publicKey - The compressed public key.
 * @returns The decompressed public key.
 */
const decompressPublicKey = (publicKey) => {
    // Ed25519 public keys don't have a compressed form.
    return publicKey;
};
exports.decompressPublicKey = decompressPublicKey;
exports.privateKeyLength = 64;
exports.masterNodeGenerationSpec = 'cip3';
exports.compressedPublicKeyLength = 32;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules\\@metamask\\key-tree\\dist\\curves\\ed25519Bip32.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\curves\\index.cjs", {"./curve.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\curves\\curve.cjs","./ed25519.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\curves\\ed25519.cjs","./ed25519Bip32.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\curves\\ed25519Bip32.cjs","./secp256k1.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\curves\\secp256k1.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckey-tree%5Cdist%5Ccurves%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ed25519Bip32 = exports.ed25519 = exports.secp256k1 = void 0;
__exportStar(require("./curve.cjs"), exports);
exports.secp256k1 = __importStar(require("./secp256k1.cjs"));
exports.ed25519 = __importStar(require("./ed25519.cjs"));
exports.ed25519Bip32 = __importStar(require("./ed25519Bip32.cjs"));

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules\\@metamask\\key-tree\\dist\\curves\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\curves\\secp256k1.cjs", {"../utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\utils.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","@noble/curves/secp256k1":"D:\\code\\v\\metamask-extension\\node_modules\\@noble\\curves\\secp256k1.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckey-tree%5Cdist%5Ccurves%5Csecp256k1.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compressedPublicKeyLength = exports.masterNodeGenerationSpec = exports.privateKeyLength = exports.decompressPublicKey = exports.compressPublicKey = exports.publicAdd = exports.getPublicKey = exports.isValidPrivateKey = exports.publicKeyLength = exports.deriveUnhardenedKeys = exports.secret = exports.name = exports.curve = void 0;
const utils_1 = require("@metamask/utils");
const secp256k1_1 = require("@noble/curves/secp256k1");
const utils_2 = require("../utils.cjs");
exports.curve = secp256k1_1.secp256k1.CURVE;
exports.name = 'secp256k1';
// Secret is defined in BIP-32 and SLIP-10:
// https://github.com/bitcoin/bips/blob/274fa400d630ba757bec0c03b35ebe2345197108/bip-0032.mediawiki#master-key-generation
// https://github.com/satoshilabs/slips/blob/133ea52a8e43d338b98be208907e144277e44c0e/slip-0010.md#master-key-generation
exports.secret = (0, utils_1.stringToBytes)('Bitcoin seed');
exports.deriveUnhardenedKeys = true;
exports.publicKeyLength = 65;
const isValidPrivateKey = (privateKey) => {
    return secp256k1_1.secp256k1.utils.isValidPrivateKey(privateKey);
};
exports.isValidPrivateKey = isValidPrivateKey;
const getGetPublicKey = () => {
    let hasSetWindowSize = false;
    const getPublicKey = (privateKey, compressed = false) => {
        if (!hasSetWindowSize) {
            secp256k1_1.secp256k1.ProjectivePoint.BASE._setWindowSize(4);
            hasSetWindowSize = true;
        }
        return secp256k1_1.secp256k1.getPublicKey(privateKey, compressed);
    };
    return getPublicKey;
};
exports.getPublicKey = getGetPublicKey();
const publicAdd = (publicKey, tweak) => {
    (0, utils_1.assert)((0, utils_2.isValidBytesKey)(tweak, 32), 'Invalid tweak: Tweak must be a non-zero 32-byte Uint8Array.');
    const point = secp256k1_1.secp256k1.ProjectivePoint.fromHex(publicKey);
    // The returned child key Ki is point(parse256(IL)) + Kpar.
    // This multiplies the tweak with the base point of the curve (Gx, Gy).
    // https://github.com/bitcoin/bips/blob/274fa400d630ba757bec0c03b35ebe2345197108/bip-0032.mediawiki#public-parent-key--public-child-key
    const newPoint = point.add(secp256k1_1.secp256k1.ProjectivePoint.fromPrivateKey(tweak));
    newPoint.assertValidity();
    return newPoint.toRawBytes(false);
};
exports.publicAdd = publicAdd;
const compressPublicKey = (publicKey) => {
    const point = secp256k1_1.secp256k1.ProjectivePoint.fromHex(publicKey);
    return point.toRawBytes(true);
};
exports.compressPublicKey = compressPublicKey;
const decompressPublicKey = (publicKey) => {
    // This calculates a point on the elliptic curve from a compressed public key. We can then use
    // this to get the uncompressed version of the public key.
    const point = secp256k1_1.secp256k1.ProjectivePoint.fromHex(publicKey);
    return point.toRawBytes(false);
};
exports.decompressPublicKey = decompressPublicKey;
exports.privateKeyLength = 32;
exports.masterNodeGenerationSpec = 'slip10';
exports.compressedPublicKeyLength = 33;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules\\@metamask\\key-tree\\dist\\curves\\secp256k1.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\derivation.cjs", {"./BIP44CoinTypeNode.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\BIP44CoinTypeNode.cjs","./BIP44Node.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\BIP44Node.cjs","./SLIP10Node.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\SLIP10Node.cjs","./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\constants.cjs","./curves/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\curves\\index.cjs","./derivers/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\derivers\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckey-tree%5Cdist%5Cderivation.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validatePathSegment = exports.deriveKeyFromPath = void 0;
const utils_1 = require("@metamask/utils");
const BIP44CoinTypeNode_1 = require("./BIP44CoinTypeNode.cjs");
const BIP44Node_1 = require("./BIP44Node.cjs");
const constants_1 = require("./constants.cjs");
const curves_1 = require("./curves/index.cjs");
const derivers_1 = require("./derivers/index.cjs");
const SLIP10Node_1 = require("./SLIP10Node.cjs");
/**
 * Takes a full or partial HD path string and returns the key corresponding to
 * the given path, with the following constraints:
 *
 * - If the path starts with a BIP-32 node, a parent key must be provided.
 * - If the path starts with a BIP-39 node, a parent key must NOT be provided.
 * - The path cannot exceed 5 BIP-32 nodes in length, optionally preceded by
 * a single BIP-39 node.
 *
 * WARNING: It is the consumer's responsibility to ensure that the path is valid
 * relative to its parent key.
 *
 * @param args - The arguments for deriving a key from a path.
 * @param args.path - A full or partial HD path, e.g.:
 * `bip39:SEED_PHRASE/bip32:44'/bip32:60'/bip32:0'/bip32:0/bip32:0`.
 * BIP-39 seed phrases must be lowercase, space-delimited, and 12-24 words long.
 * @param args.node - The node to derive from.
 * @param args.depth - The depth of the segment.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns The derived key.
 */
async function deriveKeyFromPath(args, cryptographicFunctions) {
    const { path, depth = path.length } = args;
    const node = 'node' in args ? args.node : undefined;
    const network = 'network' in args ? args.network : node?.network;
    const curve = 'curve' in args ? args.curve : node?.curve;
    if (node &&
        !(node instanceof SLIP10Node_1.SLIP10Node) &&
        !(node instanceof BIP44Node_1.BIP44Node) &&
        !(node instanceof BIP44CoinTypeNode_1.BIP44CoinTypeNode)) {
        throw new Error('Invalid arguments: Node must be a SLIP-10 node or a BIP-44 node when provided.');
    }
    if (!curve) {
        throw new Error('Invalid arguments: Must specify either a parent node or curve.');
    }
    validatePathSegment(path, Boolean(node?.privateKey) || Boolean(node?.publicKey), depth);
    // Derive through each part of path. `pathSegment` needs to be cast because
    // `HDPathTuple.reduce()` doesn't work. Note that the first element of the
    // path can be a Uint8Array.
    return await path.reduce(async (promise, pathNode, index) => {
        const derivedNode = await promise;
        if (typeof pathNode === 'string') {
            const [pathType, pathPart] = pathNode.split(':');
            (0, utils_1.assert)(pathType);
            (0, utils_1.assert)(pathPart);
            (0, utils_1.assert)(hasDeriver(pathType), `Unknown derivation type: "${pathType}".`);
            const deriver = derivers_1.derivers[pathType];
            return await deriver.deriveChildKey({
                path: pathPart,
                node: derivedNode,
                curve: (0, curves_1.getCurveByName)(curve),
                network,
            }, cryptographicFunctions);
        }
        // Only the first path segment can be a Uint8Array.
        (0, utils_1.assert)(index === 0, getMalformedError());
        return await derivers_1.derivers.bip39.deriveChildKey({
            path: pathNode,
            node: derivedNode,
            curve: (0, curves_1.getCurveByName)(curve),
            network,
        }, cryptographicFunctions);
    }, Promise.resolve(node));
}
exports.deriveKeyFromPath = deriveKeyFromPath;
/**
 * Check if the given path type is a valid deriver.
 *
 * @param pathType - The path type to check.
 * @returns Whether the path type is a valid deriver.
 */
function hasDeriver(pathType) {
    return pathType in derivers_1.derivers;
}
/**
 * The path segment must be one of the following:
 * - A lone BIP-32 path node.
 * - A lone BIP-39 path node.
 * - A multipath.
 *
 * @param path - The path segment string to validate.
 * @param hasKey - Whether the path segment has a key.
 * @param depth - The depth of the segment.
 */
function validatePathSegment(path, hasKey, depth) {
    if (path.length === 0) {
        throw new Error(`Invalid HD path segment: The segment must not be empty.`);
    }
    let startsWithBip39 = false;
    path.forEach((node, index) => {
        if (index === 0) {
            startsWithBip39 =
                node instanceof Uint8Array || constants_1.BIP_39_PATH_REGEX.test(node);
            if (
            // TypeScript is unable to infer that `node` is a string here, so we
            // need to explicitly check it again.
            !(node instanceof Uint8Array) &&
                !startsWithBip39 &&
                !constants_1.BIP_32_PATH_REGEX.test(node) &&
                !constants_1.SLIP_10_PATH_REGEX.test(node) &&
                !constants_1.CIP_3_PATH_REGEX.test(node)) {
                throw getMalformedError();
            }
        }
        else if (node instanceof Uint8Array ||
            (!constants_1.BIP_32_PATH_REGEX.test(node) &&
                !constants_1.SLIP_10_PATH_REGEX.test(node) &&
                !constants_1.CIP_3_PATH_REGEX.test(node))) {
            throw getMalformedError();
        }
    });
    if (depth === constants_1.MIN_BIP_44_DEPTH && (!startsWithBip39 || path.length !== 1)) {
        throw new Error(`Invalid HD path segment: The segment must consist of a single BIP-39 node for depths of ${constants_1.MIN_BIP_44_DEPTH}. Received: "${String(path)}".`);
    }
    if (!hasKey && !startsWithBip39) {
        throw new Error('Invalid derivation parameters: Must specify parent key if the first node of the path segment is not a BIP-39 node.');
    }
    if (hasKey && startsWithBip39) {
        throw new Error('Invalid derivation parameters: May not specify parent key if the path segment starts with a BIP-39 node.');
    }
    const pathWithoutKey = (startsWithBip39 ? path.slice(1) : path);
    if (pathWithoutKey.length > 0) {
        const firstSegmentType = pathWithoutKey[0]?.split(':')[0];
        (0, utils_1.assert)(firstSegmentType);
        (0, utils_1.assert)(pathWithoutKey.every((segment) => segment.startsWith(`${firstSegmentType}:`)), `Invalid HD path segment: Cannot mix 'bip32' and 'slip10' path segments.`);
    }
}
exports.validatePathSegment = validatePathSegment;
/**
 * Get the error for a malformed path segment.
 *
 * @returns The error.
 */
function getMalformedError() {
    return new Error('Invalid HD path segment: The path segment is malformed.');
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules\\@metamask\\key-tree\\dist\\derivation.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\derivers\\bip32.cjs", {"../constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\constants.cjs","../cryptography.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\cryptography.cjs","../curves/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\curves\\index.cjs","../utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\utils.cjs","./shared.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\derivers\\shared.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckey-tree%5Cdist%5Cderivers%5Cbip32.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deriveChildKey = exports.publicKeyToEthAddress = exports.privateKeyToEthAddress = void 0;
const utils_1 = require("@metamask/utils");
const shared_1 = require("./shared.cjs");
const constants_1 = require("../constants.cjs");
const cryptography_1 = require("../cryptography.cjs");
const curves_1 = require("../curves/index.cjs");
const utils_2 = require("../utils.cjs");
/**
 * Converts a BIP-32 private key to an Ethereum address.
 *
 * **WARNING:** Only validates that the key is non-zero and of the correct
 * length. It is the consumer's responsibility to ensure that the specified
 * key is a valid BIP-44 Ethereum `address_index` key.
 *
 * @param key - The `address_index` private key bytes to convert to an Ethereum
 * address.
 * @returns The Ethereum address corresponding to the given key.
 */
function privateKeyToEthAddress(key) {
    (0, utils_1.assert)(key instanceof Uint8Array && (0, utils_2.isValidBytesKey)(key, constants_1.BYTES_KEY_LENGTH), 'Invalid key: The key must be a 32-byte, non-zero Uint8Array.');
    const publicKey = curves_1.secp256k1.getPublicKey(key, false);
    return publicKeyToEthAddress(publicKey);
}
exports.privateKeyToEthAddress = privateKeyToEthAddress;
/**
 * Converts a BIP-32 public key to an Ethereum address.
 *
 * **WARNING:** Only validates that the key is non-zero and of the correct
 * length. It is the consumer's responsibility to ensure that the specified
 * key is a valid BIP-44 Ethereum `address_index` key.
 *
 * @param key - The `address_index` public key bytes to convert to an Ethereum
 * address.
 * @returns The Ethereum address corresponding to the given key.
 */
function publicKeyToEthAddress(key) {
    (0, utils_1.assert)(key instanceof Uint8Array &&
        (0, utils_2.isValidBytesKey)(key, curves_1.secp256k1.publicKeyLength), 'Invalid key: The key must be a 65-byte, non-zero Uint8Array.');
    return (0, cryptography_1.keccak256)(key.slice(1)).slice(-20);
}
exports.publicKeyToEthAddress = publicKeyToEthAddress;
/**
 * Derive a BIP-32 child key with a given path from a parent key.
 *
 * @param options - The options for deriving a child key.
 * @param options.path - The derivation path part to derive.
 * @param options.node - The node to derive from.
 * @param options.curve - The curve to use for derivation.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns The derived child key as a {@link SLIP10Node}.
 */
async function deriveChildKey(options, cryptographicFunctions) {
    (0, utils_1.assert)(options.curve.name === 'secp256k1', 'Invalid curve: Only secp256k1 is supported by BIP-32.');
    return (0, shared_1.deriveChildKey)(options, handleError, cryptographicFunctions);
}
exports.deriveChildKey = deriveChildKey;
/**
 * Handles an error thrown during derivation by incrementing the child index
 * and retrying.
 *
 * @param _ - The error that was thrown.
 * @param options - The options for deriving a child key.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns The options for deriving a child key with the child index
 * incremented by one.
 */
async function handleError(_, options, cryptographicFunctions) {
    const { childIndex, privateKey, publicKey, isHardened, chainCode, curve } = options;
    (0, utils_2.validateBIP32Index)(childIndex + 1);
    if (privateKey) {
        const secretExtension = await (0, shared_1.deriveSecretExtension)({
            privateKey,
            publicKey: curve.compressPublicKey(publicKey),
            childIndex: childIndex + 1,
            isHardened,
            curve,
        });
        const newEntropy = await (0, shared_1.generateEntropy)({
            chainCode,
            extension: secretExtension,
        }, cryptographicFunctions);
        return {
            ...options,
            childIndex: childIndex + 1,
            entropy: newEntropy,
        };
    }
    const publicExtension = (0, shared_1.derivePublicExtension)({
        parentPublicKey: publicKey,
        childIndex: childIndex + 1,
    });
    const newEntropy = await (0, shared_1.generateEntropy)({
        chainCode,
        extension: publicExtension,
    });
    return {
        ...options,
        childIndex: childIndex + 1,
        entropy: newEntropy,
    };
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules\\@metamask\\key-tree\\dist\\derivers\\bip32.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\derivers\\bip39.cjs", {"../SLIP10Node.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\SLIP10Node.cjs","../constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\constants.cjs","../cryptography.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\cryptography.cjs","../curves/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\curves\\index.cjs","../guard.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\guard.cjs","../utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\utils.cjs","@metamask/scure-bip39":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\scure-bip39\\dist\\index.js","@metamask/scure-bip39/dist/wordlists/english.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\scure-bip39\\dist\\wordlists\\english.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckey-tree%5Cdist%5Cderivers%5Cbip39.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.entropyToCip3MasterNode = exports.createBip39KeyFromSeed = exports.deriveChildKey = exports.getDerivationPathWithSeed = exports.multipathToBip39Mnemonic = exports.bip39MnemonicToMultipath = exports.mnemonicToSeed = void 0;
const scure_bip39_1 = require("@metamask/scure-bip39");
const english_1 = require("@metamask/scure-bip39/dist/wordlists/english.js");
const utils_1 = require("@metamask/utils");
const constants_1 = require("../constants.cjs");
const cryptography_1 = require("../cryptography.cjs");
const curves_1 = require("../curves/index.cjs");
const guard_1 = require("../guard.cjs");
const SLIP10Node_1 = require("../SLIP10Node.cjs");
const utils_2 = require("../utils.cjs");
const MNEMONIC_PHRASE_LENGTHS = [12, 15, 18, 21, 24];
/**
 * Validate a BIP-39 mnemonic phrase. The phrase must:
 *
 * - Consist of 12, 15, 18, 21, or 24 words.
 * - Contain only words from the English wordlist.
 *
 * @param mnemonicPhrase - The mnemonic phrase to validate.
 * @throws If the mnemonic phrase is invalid.
 */
function validateMnemonicPhrase(mnemonicPhrase) {
    const words = mnemonicPhrase.split(' ');
    (0, utils_1.assert)(MNEMONIC_PHRASE_LENGTHS.includes(words.length), `Invalid mnemonic phrase: The mnemonic phrase must consist of 12, 15, 18, 21, or 24 words.`);
    (0, utils_1.assert)(words.every((word) => english_1.wordlist.includes(word)), 'Invalid mnemonic phrase: The mnemonic phrase contains an unknown word.');
}
/**
 * Encode a BIP-39 mnemonic phrase to a `Uint8Array` for use in seed generation.
 * If the mnemonic is already a `Uint8Array`, it is assumed to contain the
 * indices of the words in the wordlist.
 *
 * @param mnemonic - The mnemonic phrase to encode.
 * @param wordlist - The wordlist to use.
 * @returns The encoded mnemonic phrase.
 */
function encodeMnemonicPhrase(mnemonic, wordlist) {
    if (typeof mnemonic === 'string') {
        validateMnemonicPhrase(mnemonic);
        return (0, utils_1.stringToBytes)(mnemonic.normalize('NFKD'));
    }
    const mnemonicString = Array.from(new Uint16Array(mnemonic.buffer))
        .map((i) => wordlist[i])
        .join(' ');
    validateMnemonicPhrase(mnemonicString);
    return (0, utils_1.stringToBytes)(mnemonicString);
}
/**
 * Convert a BIP-39 mnemonic phrase to a seed.
 *
 * @param mnemonic - The BIP-39 mnemonic phrase to convert. If the mnemonic is a
 * `Uint8Array`, it is assumed to contain the indices of the words in the
 * English wordlist.
 * @param passphrase - The passphrase to use.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns The seed.
 */
async function mnemonicToSeed(mnemonic, passphrase = '', cryptographicFunctions) {
    const salt = `mnemonic${passphrase}`.normalize('NFKD');
    return await (0, cryptography_1.pbkdf2Sha512)(encodeMnemonicPhrase(mnemonic, english_1.wordlist), (0, utils_1.stringToBytes)(salt), 2048, 64, cryptographicFunctions);
}
exports.mnemonicToSeed = mnemonicToSeed;
/**
 * Convert a BIP-39 mnemonic phrase to a multi path.
 *
 * @param mnemonic - The BIP-39 mnemonic phrase to convert.
 * @returns The multi path.
 */
function bip39MnemonicToMultipath(mnemonic) {
    return `bip39:${mnemonic.toLowerCase().trim()}`;
}
exports.bip39MnemonicToMultipath = bip39MnemonicToMultipath;
/**
 * Convert a multi path to a BIP-39 mnemonic phrase.
 *
 * @param value - The multi path to convert.
 * @returns The BIP-39 mnemonic phrase.
 */
function multipathToBip39Mnemonic(value) {
    if (value instanceof Uint8Array) {
        return value;
    }
    (0, utils_1.assert)(value.startsWith('bip39:'), 'Invalid HD path segment: The BIP-39 path must start with "bip39:".');
    return value.slice(6);
}
exports.multipathToBip39Mnemonic = multipathToBip39Mnemonic;
/**
 * Get a {@link RootedSLIP10SeedPathTuple} from a {@link RootedSLIP10PathTuple}.
 *
 * @param options - The options for getting the derivation path.
 * @param options.path - The derivation path to convert.
 * @param options.curve - The curve to use for derivation.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns The derivation path with the seed, or entropy in the case of CIP-3.
 */
async function getDerivationPathWithSeed({ path, curve: curveName }, cryptographicFunctions) {
    const [mnemonicPhrase, ...rest] = path;
    const plainMnemonicPhrase = multipathToBip39Mnemonic(mnemonicPhrase);
    const curve = (0, curves_1.getCurveByName)(curveName);
    switch (curve.masterNodeGenerationSpec) {
        case 'slip10': {
            const seed = await mnemonicToSeed(plainMnemonicPhrase, '', cryptographicFunctions);
            return [seed, ...rest];
        }
        case 'cip3': {
            const seed = (0, scure_bip39_1.mnemonicToEntropy)(plainMnemonicPhrase, english_1.wordlist);
            return [seed, ...rest];
        }
        /* istanbul ignore next */
        default:
            return (0, utils_1.assertExhaustive)(curve);
    }
}
exports.getDerivationPathWithSeed = getDerivationPathWithSeed;
/**
 * Create a {@link SLIP10Node} from a BIP-39 seed.
 *
 * @param options - The options for creating the node.
 * @param options.path - The multi path. This is expected to be the BIP-39 seed,
 * or the entropy in the case of CIP-3, not the mnemonic phrase itself.
 * @param options.curve - The curve to use for derivation.
 * @param options.network - The network for the node. This is only used for
 * extended keys, and defaults to `mainnet`.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns The node.
 */
async function deriveChildKey({ path, curve, network }, cryptographicFunctions) {
    (0, utils_1.assert)(path instanceof Uint8Array, 'Invalid path: The path must be a Uint8Array.');
    switch (curve.masterNodeGenerationSpec) {
        case 'slip10':
            return createBip39KeyFromSeed(path, curve, network, cryptographicFunctions);
        case 'cip3':
            return entropyToCip3MasterNode(path, curve, network, cryptographicFunctions);
        default:
            throw new Error('Unsupported master node generation spec.');
    }
}
exports.deriveChildKey = deriveChildKey;
/**
 * Create a {@link SLIP10Node} from a BIP-39 seed.
 *
 * @param seed - The cryptographic seed bytes.
 * @param curve - The curve to use.
 * @param network - The network for the node. This is only used for extended
 * keys, and defaults to `mainnet`.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns An object containing the corresponding BIP-39 master key and chain
 * code.
 */
async function createBip39KeyFromSeed(seed, curve, network, cryptographicFunctions) {
    (0, utils_1.assert)(seed.length >= 16 && seed.length <= 64, 'Invalid seed: The seed must be between 16 and 64 bytes long.');
    const key = await (0, cryptography_1.hmacSha512)(curve.secret, seed, cryptographicFunctions);
    const privateKey = key.slice(0, constants_1.BYTES_KEY_LENGTH);
    const chainCode = key.slice(constants_1.BYTES_KEY_LENGTH);
    (0, utils_1.assert)(curve.isValidPrivateKey(privateKey), 'Invalid private key: The private key must greater than 0 and less than the curve order.');
    const publicKey = curve.getPublicKey(privateKey, false);
    const masterFingerprint = (0, utils_2.getFingerprint)(curve.compressPublicKey(publicKey), curve.compressedPublicKeyLength);
    return SLIP10Node_1.SLIP10Node.fromExtendedKey({
        privateKey,
        publicKey,
        chainCode,
        masterFingerprint,
        network,
        depth: 0,
        parentFingerprint: 0,
        index: 0,
        curve: curve.name,
        guard: guard_1.PUBLIC_KEY_GUARD,
    }, cryptographicFunctions);
}
exports.createBip39KeyFromSeed = createBip39KeyFromSeed;
/**
 * Create a {@link SLIP10Node} from BIP-39 entropy.
 * This function is consistent with the Icarus derivation scheme.
 * Icarus root key derivation scheme: https://github.com/cardano-foundation/CIPs/blob/09d7d8ee1bd64f7e6b20b5a6cae088039dce00cb/CIP-0003/Icarus.md.
 * CIP3: https://github.com/cardano-foundation/CIPs/blob/09d7d8ee1bd64f7e6b20b5a6cae088039dce00cb/CIP-0003/CIP-0003.md#master-key-generation.
 *
 * @param entropy - The entropy value.
 * @param curve - The curve to use.
 * @param network - The network for the node. This is only used for extended
 * keys, and defaults to `mainnet`.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns The root key pair consisting of 64-byte private key and 32-byte chain code.
 */
async function entropyToCip3MasterNode(entropy, curve, network, cryptographicFunctions) {
    (0, utils_1.assert)(entropy.length >= 16 && entropy.length <= 64, 'Invalid entropy: The entropy must be between 16 and 64 bytes long.');
    const rootNode = await (0, cryptography_1.pbkdf2Sha512)(curve.secret, entropy, 4096, 96, cryptographicFunctions);
    // Consistent with the Icarus derivation scheme.
    // https://github.com/cardano-foundation/CIPs/blob/09d7d8ee1bd64f7e6b20b5a6cae088039dce00cb/CIP-0003/Icarus.md
    /* eslint-disable no-bitwise */
    rootNode[0] &= 248;
    rootNode[31] &= 31;
    rootNode[31] |= 64;
    /* eslint-enable no-bitwise */
    const privateKey = rootNode.slice(0, curve.privateKeyLength);
    const chainCode = rootNode.slice(curve.privateKeyLength);
    (0, utils_1.assert)(curve.isValidPrivateKey(privateKey), 'Invalid private key.');
    const publicKey = curve.getPublicKey(privateKey, false);
    const masterFingerprint = (0, utils_2.getFingerprint)(curve.compressPublicKey(publicKey), curve.compressedPublicKeyLength);
    return SLIP10Node_1.SLIP10Node.fromExtendedKey({
        privateKey,
        publicKey,
        chainCode,
        masterFingerprint,
        network,
        depth: 0,
        parentFingerprint: 0,
        index: 0,
        curve: curve.name,
        guard: guard_1.PUBLIC_KEY_GUARD,
    }, cryptographicFunctions);
}
exports.entropyToCip3MasterNode = entropyToCip3MasterNode;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules\\@metamask\\key-tree\\dist\\derivers\\bip39.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\derivers\\cip3.cjs", {"../SLIP10Node.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\SLIP10Node.cjs","../constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\constants.cjs","../curves/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\curves\\index.cjs","../utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\utils.cjs","./shared.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\derivers\\shared.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckey-tree%5Cdist%5Cderivers%5Ccip3.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deriveChildKey = exports.derivePublicKey = exports.deriveChainCode = exports.derivePrivateKey = exports.getKeyExtension = exports.add = exports.mod2Pow256 = exports.trunc28Mul8 = exports.padEnd32Bytes = exports.bigIntToBytes = exports.bytesToBigInt = exports.toReversed = void 0;
const utils_1 = require("@metamask/utils");
const shared_1 = require("./shared.cjs");
const constants_1 = require("../constants.cjs");
const curves_1 = require("../curves/index.cjs");
const SLIP10Node_1 = require("../SLIP10Node.cjs");
const utils_2 = require("../utils.cjs");
/**
 * CIP-3 https://github.com/cardano-foundation/CIPs/blob/09d7d8ee1bd64f7e6b20b5a6cae088039dce00cb/CIP-0003/CIP-0003.md.
 *
 * CIP-3 defines standards for deriving keys on Cardano.
 *
 * Key attributes.
 * - Root/Master key is derived from entropy, not seed. For this implementation we work with Icarus standard as it is the most widely used.
 * - See https://github.com/cardano-foundation/CIPs/blob/09d7d8ee1bd64f7e6b20b5a6cae088039dce00cb/CIP-0003/Icarus.md.
 *
 * - HD node consists of a 64 byte private key, 32 byte public key and 32 byte chain code.
 * - See https://github.com/cardano-foundation/CIPs/blob/09d7d8ee1bd64f7e6b20b5a6cae088039dce00cb/CIP-0003/CIP-0003.md#master-key-generation.
 *
 * - For derivation of BIP32 HD nodes, it uses modified version called BIP32-Ed25519.
 * - See https://input-output-hk.github.io/adrestia/static/Ed25519_BIP.pdf.
 */
/**
 * Reverses the order of bytes in a Uint8Array.
 *
 * Native BigInt uses big-endian. Since cip3(bip32Edd25519) uses little-endian.
 * We need to reverse the bytes and have separate functions for bigIntToBytes and bytesToBigInt.
 * .slice() is used just to make a copy of the array.
 *
 * @param bytes - The input Uint8Array.
 * @returns A new Uint8Array with the bytes in reversed order.
 */
const toReversed = (bytes) => bytes.slice().reverse();
exports.toReversed = toReversed;
/**
 * Converts an array of bytes to a BigInt.
 *
 * @param bytes - The array of bytes to convert.
 * @returns The BigInt representation of the bytes.
 */
const bytesToBigInt = (bytes) => {
    const reversed = (0, exports.toReversed)(bytes);
    const bytesInHex = (0, utils_1.bytesToHex)(reversed);
    return BigInt(bytesInHex);
};
exports.bytesToBigInt = bytesToBigInt;
/**
 * Converts a BigInt to a byte array.
 *
 * @param bigInt - The BigInt to convert.
 * @returns The byte array representation of the BigInt.
 */
const bigIntToBytes = (bigInt) => {
    const hexadecimal = bigInt.toString(16);
    return (0, exports.toReversed)((0, utils_1.hexToBytes)(hexadecimal));
};
exports.bigIntToBytes = bigIntToBytes;
/**
 * Pads end of the given bytes array with zeros to a length of 32 bytes.
 *
 * @param bytes - The bytes array to pad.
 * @returns The padded bytes array.
 */
const padEnd32Bytes = (bytes) => {
    return (0, utils_1.concatBytes)([
        bytes,
        new Uint8Array(Math.max(32 - bytes.length, 0)).fill(0),
    ]);
};
exports.padEnd32Bytes = padEnd32Bytes;
/**
 * Truncates to first 28 bytes and multiplies by 8.
 *
 * @param bytes - Little-Endian big number in bytes.
 * @returns PadEnd32Bytes(left[0, 28] * 8)).
 */
const trunc28Mul8 = (bytes) => {
    const truncLeftMul8 = (0, exports.bytesToBigInt)(bytes.slice(0, 28)) * BigInt(8);
    return (0, exports.padEnd32Bytes)((0, exports.bigIntToBytes)(truncLeftMul8));
};
exports.trunc28Mul8 = trunc28Mul8;
/**
 * Does module 2^256.
 *
 * @param bytes - Little-Endian big number in bytes.
 * @returns PadEnd32Bytes(mod(bytes, 2^256))).
 */
const mod2Pow256 = (bytes) => {
    return (0, exports.padEnd32Bytes)((0, exports.bigIntToBytes)((0, curves_1.mod)((0, exports.bytesToBigInt)(bytes), BigInt(2) ** BigInt(256))));
};
exports.mod2Pow256 = mod2Pow256;
/**
 * Adds the left to the right.
 *
 * @param left - Left hand side Little-Endian big number.
 * @param right - Right hand side Little-Endian big number.
 * @returns PadEnd32Bytes(left + right).
 */
const add = (left, right) => {
    const added = (0, exports.bytesToBigInt)(left) + (0, exports.bytesToBigInt)(right);
    return (0, exports.padEnd32Bytes)((0, exports.bigIntToBytes)(added)).slice(0, 32);
};
exports.add = add;
/**
 * Concat tag, key and childIndex.
 *
 * @param tag - Key specific tag.
 * @param key - Key.
 * @param childIndex - Child index.
 * @returns PadEnd32Bytes(left + right).
 */
const getKeyExtension = (tag, key, childIndex) => {
    return (0, utils_1.concatBytes)([
        new Uint8Array([tag]),
        key,
        (0, utils_2.numberToUint32)(childIndex, true),
    ]);
};
exports.getKeyExtension = getKeyExtension;
const Z_TAGS = {
    normal: 2,
    hardened: 0,
};
/**
 * Derive a private child key.
 *
 * Following "Section V. BIP32-ED25519: SPECIFICATION, C.1,2" in
 * https://input-output-hk.github.io/adrestia/static/Ed25519_BIP.pdf.
 *
 * @param options - The parameters for deriving a child key.
 * @param options.parentNode - The parent node containing private key, chain
 * code, and public key.
 * @param options.childIndex - The index of the child key.
 * @param options.isHardened - Indicates if the child key is hardened.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns The derived child key.
 */
const derivePrivateKey = async ({ parentNode, childIndex, isHardened }, cryptographicFunctions) => {
    // extension = i >= 2^31 ? (0x00||kp||i) : (0x02||Ap||i)
    const extension = isHardened
        ? (0, exports.getKeyExtension)(Z_TAGS.hardened, parentNode.privateKeyBytes, childIndex + constants_1.BIP_32_HARDENED_OFFSET)
        : (0, exports.getKeyExtension)(Z_TAGS.normal, parentNode.publicKeyBytes, childIndex);
    // entropy = Fcp(extension)
    const entropy = await (0, shared_1.generateEntropy)({
        chainCode: parentNode.chainCodeBytes,
        extension,
    }, cryptographicFunctions);
    const zl = entropy.subarray(0, 32);
    const zr = entropy.subarray(32);
    const parentKl = parentNode.privateKeyBytes.subarray(0, 32);
    const parentKr = parentNode.privateKeyBytes.subarray(32);
    // 8[ZL] + kPL
    const childKl = (0, exports.add)((0, exports.trunc28Mul8)(zl), parentKl);
    // ZR + kPR
    const childKr = (0, exports.add)(zr, parentKr);
    return (0, utils_1.concatBytes)([childKl, childKr]);
};
exports.derivePrivateKey = derivePrivateKey;
const CHAIN_CODE_TAGS = {
    normal: 3,
    hardened: 1,
};
/**
 * Derive a child chainCode.
 *
 * Following "Section V. BIP32-ED25519: SPECIFICATION, C.3" in
 * https://input-output-hk.github.io/adrestia/static/Ed25519_BIP.pdf.
 *
 * @param options - The parameters for deriving a child chainCode.
 * @param options.parentNode - The parent node containing optionally a private
 * key, chain code, and public key.
 * @param options.childIndex - The index of the child key.
 * @param options.isHardened - Indicates if the child key is hardened.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns The derived child chainCode.
 */
const deriveChainCode = async ({ parentNode, childIndex, isHardened, }, cryptographicFunctions) => {
    // extension = i >= 2^31 ? (0x01||kp||i) : (0x03||Ap||i)
    const extension = isHardened
        ? (0, exports.getKeyExtension)(CHAIN_CODE_TAGS.hardened, parentNode.privateKeyBytes, childIndex + constants_1.BIP_32_HARDENED_OFFSET)
        : (0, exports.getKeyExtension)(CHAIN_CODE_TAGS.normal, parentNode.publicKeyBytes, childIndex);
    // entropy = Fcp(extension)
    const entropy = await (0, shared_1.generateEntropy)({
        chainCode: parentNode.chainCodeBytes,
        extension,
    }, cryptographicFunctions);
    return entropy.subarray(32);
};
exports.deriveChainCode = deriveChainCode;
const PUBLIC_KEY_TAGS = {
    normal: 2,
};
/**
 * Derive a public key.
 *
 * Following "Section V. BIP32-ED25519: SPECIFICATION, D" in
 * https://input-output-hk.github.io/adrestia/static/Ed25519_BIP.pdf.
 *
 * @param options - The parameters for deriving a child public key.
 * @param options.parentNode - The parent node containing chain code, and public key.
 * @param options.childIndex - The index of the child key.
 * @param options.curve - Derivation curve.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns The derived child public key.
 */
const derivePublicKey = async ({ parentNode, childIndex, curve }, cryptographicFunctions) => {
    // extension = (0x02||Ap||i)
    const extension = (0, exports.getKeyExtension)(PUBLIC_KEY_TAGS.normal, parentNode.publicKeyBytes, childIndex);
    // entropy = Fcp(extension)
    const entropy = await (0, shared_1.generateEntropy)({
        chainCode: parentNode.chainCodeBytes,
        extension,
    }, cryptographicFunctions);
    const zl = entropy.slice(0, 32);
    // right = [8ZL] * B
    const right = curve.getPublicKey(
    // [8ZL]
    (0, exports.trunc28Mul8)(zl));
    // Ai = AP + [8ZL]B,
    return curve.publicAdd(parentNode.publicKeyBytes, right);
};
exports.derivePublicKey = derivePublicKey;
/**
 * Derive a SLIP-10 child key with a given path from a parent key.
 *
 * @param options - The options for deriving a child key.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns SLIP10Node.
 */
async function deriveChildKey(options, cryptographicFunctions) {
    const { curve, node, path } = options;
    (0, shared_1.validateNode)(node);
    const { childIndex, isHardened } = (0, shared_1.getValidatedPath)(path, node, curve);
    if (curve.name !== 'ed25519Bip32' || !node) {
        throw new Error('Unsupported curve: Only ed25519Bip32 is supported by CIP3.');
    }
    const actualChildIndex = childIndex + (isHardened ? constants_1.BIP_32_HARDENED_OFFSET : 0);
    const { privateKeyBytes, chainCodeBytes, publicKeyBytes, masterFingerprint, depth, fingerprint: parentFingerprint, } = node;
    if (privateKeyBytes) {
        const parentNode = {
            privateKeyBytes,
            chainCodeBytes,
            publicKeyBytes,
        };
        const privateKey = await (0, exports.derivePrivateKey)({
            parentNode,
            childIndex,
            isHardened,
        }, cryptographicFunctions);
        const chainCode = await (0, exports.deriveChainCode)({
            parentNode,
            childIndex,
            isHardened,
        }, cryptographicFunctions);
        return SLIP10Node_1.SLIP10Node.fromExtendedKey({
            privateKey: (0, utils_1.bytesToHex)(privateKey),
            chainCode: (0, utils_1.bytesToHex)(chainCode),
            masterFingerprint,
            depth: depth + 1,
            parentFingerprint,
            index: actualChildIndex,
            curve: curve.name,
        }, cryptographicFunctions);
    }
    (0, utils_1.assert)(!isHardened, 'Invalid parameters: Cannot derive hardened child keys without a private key.');
    const parentNode = {
        chainCodeBytes,
        publicKeyBytes,
    };
    const publicKey = await (0, exports.derivePublicKey)({
        parentNode,
        childIndex,
        isHardened: false,
        curve,
    }, cryptographicFunctions);
    const chainCode = await (0, exports.deriveChainCode)({
        parentNode,
        childIndex,
        isHardened: false,
    }, cryptographicFunctions);
    return SLIP10Node_1.SLIP10Node.fromExtendedKey({
        publicKey: (0, utils_1.bytesToHex)(publicKey),
        chainCode: (0, utils_1.bytesToHex)(chainCode),
        masterFingerprint,
        depth: depth + 1,
        parentFingerprint,
        index: actualChildIndex,
        curve: curve.name,
    }, cryptographicFunctions);
}
exports.deriveChildKey = deriveChildKey;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules\\@metamask\\key-tree\\dist\\derivers\\cip3.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\derivers\\index.cjs", {"./bip32.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\derivers\\bip32.cjs","./bip39.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\derivers\\bip39.cjs","./cip3.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\derivers\\cip3.cjs","./slip10.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\derivers\\slip10.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckey-tree%5Cdist%5Cderivers%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mnemonicToSeed = exports.createBip39KeyFromSeed = exports.derivers = void 0;
const bip32 = __importStar(require("./bip32.cjs"));
const bip39 = __importStar(require("./bip39.cjs"));
const cip3 = __importStar(require("./cip3.cjs"));
const slip10 = __importStar(require("./slip10.cjs"));
exports.derivers = {
    bip32,
    bip39,
    slip10,
    cip3,
};
var bip39_1 = require("./bip39.cjs");
Object.defineProperty(exports, "createBip39KeyFromSeed", { enumerable: true, get: function () { return bip39_1.createBip39KeyFromSeed; } });
Object.defineProperty(exports, "mnemonicToSeed", { enumerable: true, get: function () { return bip39_1.mnemonicToSeed; } });

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules\\@metamask\\key-tree\\dist\\derivers\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\derivers\\shared.cjs", {"../SLIP10Node.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\SLIP10Node.cjs","../constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\constants.cjs","../cryptography.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\cryptography.cjs","../curves/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\curves\\index.cjs","../guard.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\guard.cjs","../utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\utils.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckey-tree%5Cdist%5Cderivers%5Cshared.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getValidatedPath = exports.validateNode = exports.generateEntropy = exports.privateAdd = exports.derivePublicChildKey = exports.derivePublicExtension = exports.deriveSecretExtension = exports.deriveChildKey = void 0;
const utils_1 = require("@metamask/utils");
const constants_1 = require("../constants.cjs");
const cryptography_1 = require("../cryptography.cjs");
const curves_1 = require("../curves/index.cjs");
const guard_1 = require("../guard.cjs");
const SLIP10Node_1 = require("../SLIP10Node.cjs");
const utils_2 = require("../utils.cjs");
/**
 * Derive a BIP-32 or SLIP-10 child key with a given path from a parent key.
 *
 * Since BIP-32 and SLIP-10 are very similar, this function can be used to
 * derive both types of keys.
 *
 * @param options - The options for deriving a child key.
 * @param options.path - The derivation path part to derive.
 * @param options.node - The node to derive from.
 * @param options.curve - The curve to use for derivation.
 * @param options.network - The network for the node. This is only used for
 * extended keys, and defaults to `mainnet`.
 * @param handleError - A function that can handle errors that occur during
 * derivation.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns The derived node.
 */
async function deriveChildKey({ path, node, curve, network }, handleError, cryptographicFunctions) {
    validateNode(node);
    const { childIndex, isHardened } = getValidatedPath(path, node, curve);
    const args = {
        chainCode: node.chainCodeBytes,
        childIndex,
        isHardened,
        depth: node.depth,
        parentFingerprint: node.fingerprint,
        masterFingerprint: node.masterFingerprint,
        curve,
        network,
    };
    if (node.privateKeyBytes) {
        const secretExtension = await deriveSecretExtension({
            privateKey: node.privateKeyBytes,
            get publicKey() {
                return node.compressedPublicKeyBytes;
            },
            childIndex,
            isHardened,
            curve,
        });
        const entropy = await generateEntropy({
            chainCode: node.chainCodeBytes,
            extension: secretExtension,
        }, cryptographicFunctions);
        return await deriveNode({
            privateKey: node.privateKeyBytes,
            get publicKey() {
                return node.publicKeyBytes;
            },
            entropy,
            ...args,
        }, handleError, cryptographicFunctions);
    }
    const publicExtension = derivePublicExtension({
        parentPublicKey: node.compressedPublicKeyBytes,
        childIndex,
    });
    const entropy = await generateEntropy({
        chainCode: node.chainCodeBytes,
        extension: publicExtension,
    }, cryptographicFunctions);
    return await deriveNode({
        publicKey: node.compressedPublicKeyBytes,
        entropy,
        ...args,
    }, handleError, cryptographicFunctions);
}
exports.deriveChildKey = deriveChildKey;
/**
 * Derive a SLIP-10 child key from a parent key.
 *
 * @param options - The options for deriving a child key.
 * @param options.privateKey - The private key to derive from.
 * @param options.publicKey - The public key to derive from.
 * @param options.entropy - The entropy to use for deriving the child key.
 * @param options.chainCode - The chain code to use for deriving the child key.
 * @param options.childIndex - The child index to use for deriving the child key.
 * @param options.isHardened - Whether the child key is hardened.
 * @param options.depth - The depth of the child key.
 * @param options.parentFingerprint - The fingerprint of the parent key.
 * @param options.masterFingerprint - The fingerprint of the master key.
 * @param options.curve - The curve to use for deriving the child key.
 * @param handleError - A function to handle errors during derivation.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns The derived child key as {@link SLIP10Node}.
 */
async function deriveNode(options, handleError, cryptographicFunctions) {
    const { privateKey, publicKey, entropy, childIndex, isHardened, depth, parentFingerprint, masterFingerprint, curve, network, } = options;
    try {
        if (privateKey) {
            return await derivePrivateChildKey({
                entropy,
                privateKey,
                depth,
                masterFingerprint,
                parentFingerprint,
                childIndex,
                isHardened,
                curve,
                network,
            }, cryptographicFunctions);
        }
        return await derivePublicChildKey({
            entropy,
            publicKey,
            depth,
            masterFingerprint,
            parentFingerprint,
            childIndex,
            curve,
            network,
        }, cryptographicFunctions);
    }
    catch (error) {
        return await deriveNode(await handleError(error, options, cryptographicFunctions), handleError, cryptographicFunctions);
    }
}
/**
 * Derive a BIP-32 secret extension from a parent key and child index.
 *
 * @param options - The options for deriving a secret extension.
 * @param options.privateKey - The parent private key bytes.
 * @param options.publicKey - The parent compressed public key bytes.
 * @param options.childIndex - The child index to derive.
 * @param options.isHardened - Whether the child index is hardened.
 * @param options.curve - The curve to use for derivation.
 * @returns The secret extension bytes.
 */
async function deriveSecretExtension({ privateKey, publicKey, childIndex, isHardened, curve, }) {
    if (isHardened) {
        // Hardened child
        return (0, utils_1.concatBytes)([
            new Uint8Array([0]),
            privateKey,
            (0, utils_2.numberToUint32)(childIndex + constants_1.BIP_32_HARDENED_OFFSET),
        ]);
    }
    // Normal child
    (0, utils_2.validateBytes)(publicKey, curve.compressedPublicKeyLength);
    return derivePublicExtension({ parentPublicKey: publicKey, childIndex });
}
exports.deriveSecretExtension = deriveSecretExtension;
/**
 * Derive a BIP-32 public extension from a parent key and child index.
 *
 * @param options - The options for deriving a public extension.
 * @param options.parentPublicKey - The parent public key bytes.
 * @param options.childIndex - The child index to derive.
 * @returns The public extension bytes.
 */
function derivePublicExtension({ parentPublicKey, childIndex, }) {
    return (0, utils_1.concatBytes)([parentPublicKey, (0, utils_2.numberToUint32)(childIndex)]);
}
exports.derivePublicExtension = derivePublicExtension;
/**
 * Derive a BIP-32 key from a parent key and secret extension.
 *
 * @param options - The options for deriving a key.
 * @param options.privateKey - The parent private key bytes.
 * @param options.entropy - The entropy bytes.
 * @param options.curve - The curve to use for derivation.
 * @returns The derived key.
 */
function generateKey({ privateKey, entropy, curve }) {
    const keyMaterial = entropy.slice(0, 32);
    const childChainCode = entropy.slice(32);
    // If curve is ed25519: The returned child key ki is parse256(IL).
    // https://github.com/satoshilabs/slips/blob/133ea52a8e43d338b98be208907e144277e44c0e/slip-0010.md#private-parent-key--private-child-key
    if (curve.name === 'ed25519') {
        return { privateKey: keyMaterial, chainCode: childChainCode };
    }
    const childPrivateKey = privateAdd(privateKey, keyMaterial, curve);
    return { privateKey: childPrivateKey, chainCode: childChainCode };
}
/**
 * Derive a BIP-32 private child key with a given path from a parent key.
 *
 * @param args - The arguments for deriving a private child key.
 * @param args.entropy - The entropy to use for derivation.
 * @param args.privateKey - The parent private key to use for derivation.
 * @param args.depth - The depth of the parent node.
 * @param args.masterFingerprint - The fingerprint of the master node.
 * @param args.parentFingerprint - The fingerprint of the parent node.
 * @param args.childIndex - The child index to derive.
 * @param args.isHardened - Whether the child index is hardened.
 * @param args.curve - The curve to use for derivation.
 * @param args.network - The network for the node. This is only used for
 * extended keys, and defaults to `mainnet`.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns The derived {@link SLIP10Node}.
 */
async function derivePrivateChildKey({ entropy, privateKey, depth, masterFingerprint, parentFingerprint, childIndex, isHardened, curve, network, }, cryptographicFunctions) {
    const actualChildIndex = childIndex + (isHardened ? constants_1.BIP_32_HARDENED_OFFSET : 0);
    const { privateKey: childPrivateKey, chainCode: childChainCode } = generateKey({
        privateKey,
        entropy,
        curve,
    });
    return await SLIP10Node_1.SLIP10Node.fromExtendedKey({
        privateKey: childPrivateKey,
        chainCode: childChainCode,
        depth: depth + 1,
        masterFingerprint,
        parentFingerprint,
        index: actualChildIndex,
        curve: curve.name,
        network,
        guard: guard_1.PUBLIC_KEY_GUARD,
    }, cryptographicFunctions);
}
/**
 * Derive a BIP-32 public key from a parent key and public extension.
 *
 * @param options - The options for deriving a public key.
 * @param options.publicKey - The parent public key bytes.
 * @param options.entropy - The entropy bytes.
 * @param options.curve - The curve to use for derivation.
 * @returns The derived public key.
 */
function generatePublicKey({ publicKey, entropy, curve, }) {
    const keyMaterial = entropy.slice(0, 32);
    const childChainCode = entropy.slice(32);
    // This function may fail if the resulting key is invalid.
    const childPublicKey = curve.publicAdd(publicKey, keyMaterial);
    return {
        publicKey: childPublicKey,
        chainCode: childChainCode,
    };
}
/**
 * Derive a BIP-32 public child key with a given path from a parent key.
 *
 * @param args - The arguments for deriving a public child key.
 * @param args.entropy - The entropy to use for derivation.
 * @param args.publicKey - The parent public key to use for derivation.
 * @param args.depth - The depth of the parent node.
 * @param args.masterFingerprint - The fingerprint of the master node.
 * @param args.parentFingerprint - The fingerprint of the parent node.
 * @param args.childIndex - The child index to derive.
 * @param args.curve - The curve to use for derivation.
 * @param args.network - The network for the node. This is only used for
 * extended keys, and defaults to `mainnet`.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns The derived {@link SLIP10Node}.
 */
async function derivePublicChildKey({ entropy, publicKey, depth, masterFingerprint, parentFingerprint, childIndex, curve, network, }, cryptographicFunctions) {
    const { publicKey: childPublicKey, chainCode: childChainCode } = generatePublicKey({
        publicKey,
        entropy,
        curve,
    });
    return await SLIP10Node_1.SLIP10Node.fromExtendedKey({
        publicKey: childPublicKey,
        chainCode: childChainCode,
        depth: depth + 1,
        masterFingerprint,
        parentFingerprint,
        index: childIndex,
        curve: curve.name,
        network,
    }, cryptographicFunctions);
}
exports.derivePublicChildKey = derivePublicChildKey;
/**
 * Add a tweak to the private key: `(privateKey + tweak) % n`.
 *
 * @param privateKeyBytes - The private key as 32 byte Uint8Array.
 * @param tweakBytes - The tweak as 32 byte Uint8Array.
 * @param curve - The curve to use.
 * @throws If the private key or tweak is invalid.
 * @returns The private key with the tweak added to it.
 */
function privateAdd(privateKeyBytes, tweakBytes, curve) {
    (0, utils_1.assert)((0, utils_2.isValidBytesKey)(tweakBytes, 32), 'Invalid tweak: Tweak must be a non-zero 32-byte Uint8Array.');
    const privateKey = (0, utils_1.bytesToBigInt)(privateKeyBytes);
    const tweak = (0, utils_1.bytesToBigInt)(tweakBytes);
    if (tweak >= curve.curve.n) {
        throw new Error('Invalid tweak: Tweak is larger than the curve order.');
    }
    const added = (0, curves_1.mod)(privateKey + tweak, curve.curve.n);
    const bytes = (0, utils_1.hexToBytes)(added.toString(16).padStart(64, '0'));
    if (!curve.isValidPrivateKey(bytes)) {
        throw new Error('Invalid private key or tweak: The resulting private key is invalid.');
    }
    return bytes;
}
exports.privateAdd = privateAdd;
/**
 * Generate 64 bytes of (deterministic) entropy from a chain code and secret
 * extension.
 *
 * @param args - The arguments for generating entropy.
 * @param args.chainCode - The parent chain code bytes.
 * @param args.extension - The extension bytes.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns The generated entropy bytes.
 */
async function generateEntropy({ chainCode, extension }, cryptographicFunctions) {
    return await (0, cryptography_1.hmacSha512)(chainCode, extension, cryptographicFunctions);
}
exports.generateEntropy = generateEntropy;
/**
 * Validate that a node is specified.
 *
 * @param node - The node to validate.
 * @throws If the node is not specified.
 */
function validateNode(node) {
    (0, utils_1.assert)(node, 'Invalid parameters: Must specify a node to derive from.');
}
exports.validateNode = validateNode;
/**
 * Validate a path.
 *
 * @param path - The path to validate.
 * @param node - The node to validate the path against.
 * @param curve - The curve to validate the path against.
 * @throws If the path is invalid.
 */
function validatePath(path, node, curve) {
    (0, utils_1.assert)(typeof path === 'string', 'Invalid path: Must be a string.');
    const isHardened = path.endsWith(`'`);
    (0, utils_1.assert)(!isHardened || node.privateKey, 'Invalid parameters: Cannot derive hardened child keys without a private key.');
    (0, utils_1.assert)(isHardened || curve.deriveUnhardenedKeys, `Invalid path: Cannot derive unhardened child keys with ${curve.name}.`);
}
/**
 * Validate a path and return the child index and whether it is hardened.
 *
 * @param path - The path to validate.
 * @param node - The node to validate the path against.
 * @param curve - The curve to validate the path against.
 * @returns The child index and whether it is hardened.
 */
function getValidatedPath(path, node, curve) {
    validatePath(path, node, curve);
    const indexPart = path.split(`'`)[0];
    (0, utils_1.assert)(indexPart);
    const childIndex = parseInt(indexPart, 10);
    if (!constants_1.UNPREFIXED_PATH_REGEX.test(indexPart) ||
        !Number.isInteger(childIndex) ||
        childIndex < 0 ||
        childIndex >= constants_1.BIP_32_HARDENED_OFFSET) {
        throw new Error(`Invalid path: The index must be a non-negative decimal integer less than ${constants_1.BIP_32_HARDENED_OFFSET}.`);
    }
    return { childIndex, isHardened: path.includes(`'`) };
}
exports.getValidatedPath = getValidatedPath;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules\\@metamask\\key-tree\\dist\\derivers\\shared.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\derivers\\slip10.cjs", {"../constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\constants.cjs","../utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\utils.cjs","./shared.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\derivers\\shared.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckey-tree%5Cdist%5Cderivers%5Cslip10.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deriveChildKey = void 0;
const utils_1 = require("@metamask/utils");
const shared_1 = require("./shared.cjs");
const constants_1 = require("../constants.cjs");
const utils_2 = require("../utils.cjs");
/**
 * Derive a SLIP-10 child key with a given path from a parent key.
 *
 * @param options - The options for deriving a child key.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns A tuple containing the derived private key, public key and chain
 * code.
 */
async function deriveChildKey(options, cryptographicFunctions) {
    return await (0, shared_1.deriveChildKey)(options, handleError, cryptographicFunctions);
}
exports.deriveChildKey = deriveChildKey;
/**
 * Handle an error that occurs during SLIP-10 derivation.
 *
 * @param error - The error that occurred.
 * @param options - The options that were used for derivation.
 * @param cryptographicFunctions - The cryptographic functions to use. If
 * provided, these will be used instead of the built-in implementations.
 * @returns The new options to use for derivation.
 */
async function handleError(error, options, cryptographicFunctions) {
    const { curve, isHardened, childIndex, entropy, chainCode } = options;
    // `ed25519` keys are always valid, so this error should never be thrown. If
    // it is, we re-throw it.
    if (curve.name === 'ed25519') {
        throw error;
    }
    const actualChildIndex = isHardened
        ? childIndex + constants_1.BIP_32_HARDENED_OFFSET
        : childIndex;
    // As per SLIP-10, if the resulting key is invalid, the new entropy is
    // generated as follows:
    // Key material (32 bytes), child chain code (32 bytes) =
    //   HMAC-SHA512(parent chain code, 0x01 || chain code from invalid key || index).
    const newEntropy = await (0, shared_1.generateEntropy)({
        chainCode,
        extension: (0, utils_1.concatBytes)([
            0x01,
            entropy.slice(32, 64),
            (0, utils_2.numberToUint32)(actualChildIndex),
        ]),
    }, cryptographicFunctions);
    return {
        ...options,
        entropy: newEntropy,
    };
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules\\@metamask\\key-tree\\dist\\derivers\\slip10.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\extended-keys.cjs", {"./BIP44Node.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\BIP44Node.cjs","./curves/secp256k1.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\curves\\secp256k1.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\utils.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckey-tree%5Cdist%5Cextended-keys.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.encodeExtendedKey = exports.decodeExtendedKey = void 0;
const utils_1 = require("@metamask/utils");
const BIP44Node_1 = require("./BIP44Node.cjs");
const secp256k1_1 = require("./curves/secp256k1.cjs");
const utils_2 = require("./utils.cjs");
// https://github.com/bitcoin/bips/blob/274fa400d630ba757bec0c03b35ebe2345197108/bip-0032.mediawiki#Serialization_format
const PUBLIC_KEY_VERSION = 0x0488b21e;
const PRIVATE_KEY_VERSION = 0x0488ade4;
const TESTNET_PUBLIC_KEY_VERSION = 0x043587cf;
const TESTNET_PRIVATE_KEY_VERSION = 0x04358394;
/**
 * Get the version options for a given version.
 *
 * @param version - The version to get the options for.
 * @returns The version options.
 */
function getVersionOptions(version) {
    switch (version) {
        case PUBLIC_KEY_VERSION:
            return { type: 'public', network: 'mainnet' };
        case TESTNET_PUBLIC_KEY_VERSION:
            return { type: 'public', network: 'testnet' };
        case PRIVATE_KEY_VERSION:
            return { type: 'private', network: 'mainnet' };
        case TESTNET_PRIVATE_KEY_VERSION:
            return { type: 'private', network: 'testnet' };
        default:
            throw new Error(`Invalid extended key: Expected a public (xpub) or private key (xprv) version.`);
    }
}
/**
 * Get the version for a given network and type.
 *
 * @param network - The network to get the version for.
 * @param type - The type to get the version for.
 * @returns The version.
 */
function getVersionFromNetwork(network, type) {
    switch (network) {
        case 'mainnet':
            return type === 'public' ? PUBLIC_KEY_VERSION : PRIVATE_KEY_VERSION;
        case 'testnet':
            return type === 'public'
                ? TESTNET_PUBLIC_KEY_VERSION
                : TESTNET_PRIVATE_KEY_VERSION;
        default:
            return (0, utils_1.assertExhaustive)(network);
    }
}
/**
 * Decode an extended public or private key. In the case of an extended public
 * key, the public key is returned in the uncompressed form.
 *
 * Throws an error if the extended key is invalid.
 *
 * @param extendedKey - The extended key string to attempt to decode.
 * @returns The decoded extended key.
 */
const decodeExtendedKey = (extendedKey) => {
    const bytes = (0, utils_2.decodeBase58check)(extendedKey);
    if (bytes.length !== 78) {
        throw new Error(`Invalid extended key: Expected a length of 78, got ${bytes.length}.`);
    }
    const view = (0, utils_1.createDataView)(bytes);
    const version = view.getUint32(0, false);
    const { network, type } = getVersionOptions(version);
    const depth = view.getUint8(4);
    (0, BIP44Node_1.validateBIP44Depth)(depth);
    const parentFingerprint = view.getUint32(5, false);
    const index = view.getUint32(9, false);
    const chainCode = bytes.slice(13, 45);
    if (!(0, utils_2.isValidBytesKey)(chainCode, 32)) {
        throw new Error(`Invalid extended key: Chain code must be a 32-byte non-zero byte array.`);
    }
    const key = bytes.slice(45, 78);
    if (!(0, utils_2.isValidBytesKey)(key, 33)) {
        throw new Error(`Invalid extended key: Key must be a 33-byte non-zero byte array.`);
    }
    const keyView = (0, utils_1.createDataView)(key);
    if (type === 'public') {
        if (keyView.getUint8(0) !== 0x02 && keyView.getUint8(0) !== 0x03) {
            throw new Error(`Invalid extended key: Public key must start with 0x02 or 0x03.`);
        }
        return {
            type,
            depth,
            parentFingerprint,
            index,
            network,
            chainCode,
            publicKey: (0, secp256k1_1.decompressPublicKey)(key),
        };
    }
    if (keyView.getUint8(0) !== 0x00) {
        throw new Error(`Invalid extended key: Private key must start with 0x00.`);
    }
    return {
        type,
        depth,
        parentFingerprint,
        index,
        network,
        chainCode,
        privateKey: key.slice(1),
    };
};
exports.decodeExtendedKey = decodeExtendedKey;
/**
 * Encodes an extended public or private key. Assumes that all the inputs are verified beforehand.
 *
 * @param extendedKey - The extended key data to encode.
 * @returns The encoded extended key.
 */
const encodeExtendedKey = (extendedKey) => {
    const { type, depth, parentFingerprint, index, network, chainCode } = extendedKey;
    const bytes = new Uint8Array(78);
    const view = (0, utils_1.createDataView)(bytes);
    const version = getVersionFromNetwork(network, type);
    view.setUint32(0, version, false);
    view.setUint8(4, depth);
    view.setUint32(5, parentFingerprint, false);
    view.setUint32(9, index, false);
    bytes.set(chainCode, 13);
    if (type === 'public') {
        const { publicKey } = extendedKey;
        const compressedPublicKey = (0, secp256k1_1.compressPublicKey)(publicKey);
        bytes.set(compressedPublicKey, 45);
    }
    if (type === 'private') {
        const { privateKey } = extendedKey;
        bytes.set(privateKey, 46);
    }
    return (0, utils_2.encodeBase58check)(bytes);
};
exports.encodeExtendedKey = encodeExtendedKey;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules\\@metamask\\key-tree\\dist\\extended-keys.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\guard.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckey-tree%5Cdist%5Cguard.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PUBLIC_KEY_GUARD = void 0;
/**
 * A guard symbol to prevent untrusted public keys from being passed to
 * `SLIP10Node` constructors.
 *
 * This is a private symbol and should not be exported from the module.
 */
exports.PUBLIC_KEY_GUARD = Symbol('Public key guard. Do not export this from the module.');

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules\\@metamask\\key-tree\\dist\\guard.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\index.cjs", {"./BIP44CoinTypeNode.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\BIP44CoinTypeNode.cjs","./BIP44Node.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\BIP44Node.cjs","./SLIP10Node.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\SLIP10Node.cjs","./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\constants.cjs","./curves/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\curves\\index.cjs","./derivers/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\derivers\\index.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\utils.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckey-tree%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mnemonicToSeed = exports.createBip39KeyFromSeed = exports.mnemonicPhraseToBytes = exports.isValidBIP32PathSegment = exports.getBIP44CoinTypeToAddressPathTuple = exports.getBIP44AddressKeyDeriver = exports.deriveBIP44AddressKey = exports.BIP_44_COIN_TYPE_DEPTH = exports.BIP44CoinTypeNode = exports.ed25519Bip32 = exports.ed25519 = exports.secp256k1 = exports.SLIP10Node = exports.BIP44Node = void 0;
var BIP44Node_1 = require("./BIP44Node.cjs");
Object.defineProperty(exports, "BIP44Node", { enumerable: true, get: function () { return BIP44Node_1.BIP44Node; } });
var SLIP10Node_1 = require("./SLIP10Node.cjs");
Object.defineProperty(exports, "SLIP10Node", { enumerable: true, get: function () { return SLIP10Node_1.SLIP10Node; } });
var curves_1 = require("./curves/index.cjs");
Object.defineProperty(exports, "secp256k1", { enumerable: true, get: function () { return curves_1.secp256k1; } });
Object.defineProperty(exports, "ed25519", { enumerable: true, get: function () { return curves_1.ed25519; } });
Object.defineProperty(exports, "ed25519Bip32", { enumerable: true, get: function () { return curves_1.ed25519Bip32; } });
var BIP44CoinTypeNode_1 = require("./BIP44CoinTypeNode.cjs");
Object.defineProperty(exports, "BIP44CoinTypeNode", { enumerable: true, get: function () { return BIP44CoinTypeNode_1.BIP44CoinTypeNode; } });
Object.defineProperty(exports, "BIP_44_COIN_TYPE_DEPTH", { enumerable: true, get: function () { return BIP44CoinTypeNode_1.BIP_44_COIN_TYPE_DEPTH; } });
Object.defineProperty(exports, "deriveBIP44AddressKey", { enumerable: true, get: function () { return BIP44CoinTypeNode_1.deriveBIP44AddressKey; } });
Object.defineProperty(exports, "getBIP44AddressKeyDeriver", { enumerable: true, get: function () { return BIP44CoinTypeNode_1.getBIP44AddressKeyDeriver; } });
__exportStar(require("./constants.cjs"), exports);
var utils_1 = require("./utils.cjs");
Object.defineProperty(exports, "getBIP44CoinTypeToAddressPathTuple", { enumerable: true, get: function () { return utils_1.getBIP44CoinTypeToAddressPathTuple; } });
Object.defineProperty(exports, "isValidBIP32PathSegment", { enumerable: true, get: function () { return utils_1.isValidBIP32PathSegment; } });
Object.defineProperty(exports, "mnemonicPhraseToBytes", { enumerable: true, get: function () { return utils_1.mnemonicPhraseToBytes; } });
var derivers_1 = require("./derivers/index.cjs");
Object.defineProperty(exports, "createBip39KeyFromSeed", { enumerable: true, get: function () { return derivers_1.createBip39KeyFromSeed; } });
Object.defineProperty(exports, "mnemonicToSeed", { enumerable: true, get: function () { return derivers_1.mnemonicToSeed; } });

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules\\@metamask\\key-tree\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\utils.cjs", {"./BIP44CoinTypeNode.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\BIP44CoinTypeNode.cjs","./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\constants.cjs","./cryptography.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\cryptography.cjs","./curves/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\curves\\index.cjs","@metamask/scure-bip39/dist/wordlists/english.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\scure-bip39\\dist\\wordlists\\english.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","@scure/base":"D:\\code\\v\\metamask-extension\\node_modules\\@scure\\base\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckey-tree%5Cdist%5Cutils.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getBIP44CoinType = exports.validateNetwork = exports.isWebCryptoSupported = exports.numberToUint32 = exports.validateCurve = exports.mnemonicPhraseToBytes = exports.getFingerprint = exports.encodeBase58check = exports.decodeBase58check = exports.validateBytes = exports.getBytesUnsafe = exports.getBytes = exports.isValidInteger = exports.isValidBytesKey = exports.nullableHexStringToBytes = exports.hexStringToBytes = exports.isHardened = exports.isValidBIP32PathSegment = exports.isValidBIP32Index = exports.validateBIP32Index = exports.getBIP32NodeToken = exports.getUnhardenedBIP32NodeToken = exports.getHardenedBIP32NodeToken = exports.getBIP44CoinTypeToAddressPathTuple = exports.getBIP44ChangePathString = exports.getBIP44CoinTypePathString = void 0;
const english_1 = require("@metamask/scure-bip39/dist/wordlists/english.js");
const utils_1 = require("@metamask/utils");
const base_1 = require("@scure/base");
const BIP44CoinTypeNode_1 = require("./BIP44CoinTypeNode.cjs");
const constants_1 = require("./constants.cjs");
const cryptography_1 = require("./cryptography.cjs");
const curves_1 = require("./curves/index.cjs");
/**
 * Gets a string representation of a BIP-44 path of depth 2, i.e.:
 * `m / 44' / coin_type'`
 *
 * For display purposes only.
 *
 * @param coin_type - The `coin_type` index to create a path visualization for.
 * @returns The visualization of the BIP-44 path for thte specified `coin_type`.
 */
function getBIP44CoinTypePathString(coin_type) {
    return `m / ${constants_1.BIP44PurposeNodeToken} / ${getHardenedBIP32NodeToken(coin_type)}`;
}
exports.getBIP44CoinTypePathString = getBIP44CoinTypePathString;
/**
 * Gets a string representation of a BIP-44 path of depth 4, i.e.:
 * `m / 44' / coin_type' / account' / change`
 *
 * For display purposes only.
 *
 * @param coinTypePath - The parent `coin_type` path.
 * @param indices - The `account` and `change` index to create a path visualization for.
 * @returns The visualization of the BIP-44 path for the specified `coin_type`
 * and `change` indices.
 */
function getBIP44ChangePathString(coinTypePath, indices) {
    return `${coinTypePath} / ${getHardenedBIP32NodeToken(indices.account ?? 0)} / ${getBIP32NodeToken(indices.change ?? 0)}`;
}
exports.getBIP44ChangePathString = getBIP44ChangePathString;
/**
 * Gets a BIP-44 path tuple of the form `account' / change / address_index`,
 * which can be used to derive address keys together with a `coin_type` key.
 *
 * @param indices - The BIP-44 derivation index values.
 * @param indices.account - The `account` index value.
 * @param indices.change - The `change` index value.
 * @param indices.address_index - The `address_index` index value.
 * @returns The `account' / change / address_index` path corresponding to the
 * specified indices.
 */
function getBIP44CoinTypeToAddressPathTuple({ account = 0, change = 0, address_index, }) {
    return [
        getHardenedBIP32NodeToken(account),
        getBIP32NodeToken(change),
        getBIP32NodeToken(address_index),
    ];
}
exports.getBIP44CoinTypeToAddressPathTuple = getBIP44CoinTypeToAddressPathTuple;
/**
 * A hardened BIP-32 node token, e.g. `bip32:0'`.
 * Validates that the index is a non-negative integer number, and throws an
 * error if validation fails.
 *
 * @param index - The index of the node.
 * @returns The hardened BIP-32 node token.
 */
function getHardenedBIP32NodeToken(index) {
    validateBIP32Index(index);
    return `${getUnhardenedBIP32NodeToken(index)}'`;
}
exports.getHardenedBIP32NodeToken = getHardenedBIP32NodeToken;
/**
 * An unhardened BIP-32 node token, e.g. `bip32:0`.
 * Validates that the index is a non-negative integer number, and throws an
 * error if validation fails.
 *
 * @param index - The index of the node.
 * @returns The unhardened BIP-32 node token.
 */
function getUnhardenedBIP32NodeToken(index) {
    validateBIP32Index(index);
    return `bip32:${index}`;
}
exports.getUnhardenedBIP32NodeToken = getUnhardenedBIP32NodeToken;
/**
 * A hardened or unhardened BIP-32 node token, e.g. `bip32:0` or `bip32:0'`.
 * Validates that the index is a non-negative integer number, and throws an
 * error if validation fails.
 *
 * @param index - The index of the node.
 * @returns The hardened or unhardened BIP-32 node token.
 */
function getBIP32NodeToken(index) {
    if (typeof index === 'number') {
        return getUnhardenedBIP32NodeToken(index);
    }
    if (!index ||
        !Number.isInteger(index.index) ||
        typeof index.hardened !== 'boolean') {
        throw new Error('Invalid BIP-32 index: Must be an object containing the index and whether it is hardened.');
    }
    if (index.hardened) {
        return getHardenedBIP32NodeToken(index.index);
    }
    return getUnhardenedBIP32NodeToken(index.index);
}
exports.getBIP32NodeToken = getBIP32NodeToken;
/**
 * Validates that the index is a non-negative integer number. Throws an
 * error if validation fails.
 *
 * @param addressIndex - The index to validate.
 */
function validateBIP32Index(addressIndex) {
    if (!isValidBIP32Index(addressIndex)) {
        throw new Error(`Invalid BIP-32 index: Must be a non-negative integer.`);
    }
}
exports.validateBIP32Index = validateBIP32Index;
/**
 * Check if the index is a valid BIP-32 index.
 *
 * @param index - The BIP-32 index to test.
 * @returns Whether the index is a non-negative integer number.
 */
function isValidBIP32Index(index) {
    return isValidInteger(index) && index <= constants_1.MAX_BIP_32_INDEX;
}
exports.isValidBIP32Index = isValidBIP32Index;
/**
 * Check if the value is a valid BIP-32 path segment, i.e., a string of the form
 * `0'`.
 *
 * @param segment - The BIP-32 path segment to test.
 * @returns Whether the path segment is a valid BIP-32 path segment.
 */
function isValidBIP32PathSegment(segment) {
    if (typeof segment !== 'string') {
        return false;
    }
    const match = segment.match(constants_1.UNPREFIXED_BIP_32_PATH_REGEX);
    if (typeof match?.groups?.index === 'undefined') {
        return false;
    }
    const index = parseInt(match.groups.index, 10);
    return isValidInteger(index) && index <= constants_1.MAX_UNHARDENED_BIP_32_INDEX;
}
exports.isValidBIP32PathSegment = isValidBIP32PathSegment;
/**
 * Check if the value is a hardened BIP-32 index. This only checks if the value
 * ends with a `'` character, and does not validate that the index is a valid
 * BIP-32 index.
 *
 * @param bip32Token - The token to test.
 * @returns Whether the token is hardened, i.e. ends with `'`.
 */
function isHardened(bip32Token) {
    return bip32Token.endsWith(`'`);
}
exports.isHardened = isHardened;
/**
 * Get a `Uint8Array` from a hexadecimal string or a `Uint8Array`. If the input
 * is a hexadecimal string, it is converted to a `Uint8Array`. If the input is
 * a `Uint8Array`, it is returned as-is.
 *
 * @param hexString - The hexadecimal string to convert.
 * @returns The `Uint8Array` corresponding to the hexadecimal string.
 */
function hexStringToBytes(hexString) {
    if (hexString instanceof Uint8Array) {
        return hexString;
    }
    return (0, utils_1.hexToBytes)(hexString);
}
exports.hexStringToBytes = hexStringToBytes;
/**
 * The same as {@link hexStringToBytes}, but returns `undefined` if the input
 * is `undefined`.
 *
 * @param hexString - The hexadecimal string to convert.
 * @returns The `Uint8Array` corresponding to the hexadecimal string.
 */
function nullableHexStringToBytes(hexString) {
    if (hexString !== undefined) {
        return hexStringToBytes(hexString);
    }
    return undefined;
}
exports.nullableHexStringToBytes = nullableHexStringToBytes;
/**
 * Tests whether the specified `Uint8Array` is a valid BIP-32 key.
 * A valid bytes key is 64 bytes long and has at least one non-zero byte.
 *
 * @param bytes - The `Uint8Array` to test.
 * @param expectedLength - The expected length of the Uint8Array.
 * @returns Whether the Uint8Array represents a valid BIP-32 key.
 */
function isValidBytesKey(bytes, expectedLength) {
    if (bytes.length !== expectedLength) {
        return false;
    }
    for (const byte of bytes) {
        if (byte !== 0) {
            return true;
        }
    }
    return false;
}
exports.isValidBytesKey = isValidBytesKey;
/**
 * Tests whether the specified number is a valid integer equal to or greater than 0.
 *
 * @param value - The number to test.
 * @returns Whether the number is a valid integer.
 */
function isValidInteger(value) {
    return typeof value === 'number' && Number.isInteger(value) && value >= 0;
}
exports.isValidInteger = isValidInteger;
/**
 * Get a `Uint8Array` from a hexadecimal string or `Uint8Array`. Validates that the
 * length of the `Uint8Array` matches the specified length, and that the `Uint8Array`
 * is not empty.
 *
 * @param value - The value to convert to a `Uint8Array`.
 * @param length - The length to validate the `Uint8Array` against.
 * @returns The `Uint8Array` corresponding to the hexadecimal string.
 */
function getBytes(value, length) {
    if (value instanceof Uint8Array) {
        validateBytes(value, length);
        return value;
    }
    if (typeof value === 'string') {
        const bytes = (0, utils_1.hexToBytes)(value);
        validateBytes(bytes, length);
        return bytes;
    }
    throw new Error(`Invalid value: Expected an instance of Uint8Array or hexadecimal string.`);
}
exports.getBytes = getBytes;
/**
 * Get a `Uint8Array` from a hexadecimal string or `Uint8Array`. Validates that
 * the length of the `Uint8Array` matches the specified length.
 *
 * This function is "unsafe," in the sense that it does not validate that the
 * `Uint8Array` is not empty (i.e., all bytes are zero).
 *
 * @param value - The value to convert to a `Uint8Array`.
 * @param length - The length to validate the `Uint8Array` against.
 * @returns The `Uint8Array` corresponding to the hexadecimal string.
 */
function getBytesUnsafe(value, length) {
    if (value instanceof Uint8Array) {
        (0, utils_1.assert)(value.length === length, `Invalid value: Must be a ${length}-byte byte array.`);
        return value;
    }
    if (typeof value === 'string') {
        return getBytesUnsafe((0, utils_1.hexToBytes)(value), length);
    }
    throw new Error(`Invalid value: Expected an instance of Uint8Array or hexadecimal string.`);
}
exports.getBytesUnsafe = getBytesUnsafe;
/**
 * Validate that the specified `Uint8Array` is not empty and has the specified
 * length.
 *
 * @param bytes - The `Uint8Array` to validate.
 * @param length - The length to validate the `Uint8Array` against.
 * @throws An error if the `Uint8Array` is empty or has the wrong length.
 */
function validateBytes(bytes, length) {
    if (!isValidBytesKey(bytes, length)) {
        throw new Error(`Invalid value: Must be a non-zero ${length}-byte byte array.`);
    }
}
exports.validateBytes = validateBytes;
const decodeBase58check = (value) => {
    const base58Check = (0, base_1.base58check)(cryptography_1.sha256);
    try {
        return base58Check.decode(value);
    }
    catch {
        throw new Error(`Invalid extended key: Value is not base58-encoded, or the checksum is invalid.`);
    }
};
exports.decodeBase58check = decodeBase58check;
const encodeBase58check = (value) => {
    const base58Check = (0, base_1.base58check)(cryptography_1.sha256);
    return base58Check.encode(value);
};
exports.encodeBase58check = encodeBase58check;
/**
 * Get the fingerprint of a compressed public key as number.
 *
 * @param publicKey - The compressed public key to get the fingerprint for.
 * @param compressedPublicKeyLength - The length of the compressed public key.
 * @returns The fingerprint of the public key.
 */
const getFingerprint = (publicKey, compressedPublicKeyLength) => {
    if (!isValidBytesKey(publicKey, compressedPublicKeyLength)) {
        throw new Error(`Invalid public key: The key must be a ${compressedPublicKeyLength}-byte, non-zero byte array.`);
    }
    const bytes = (0, cryptography_1.ripemd160)((0, cryptography_1.sha256)(publicKey));
    const view = (0, utils_1.createDataView)(bytes);
    return view.getUint32(0, false);
};
exports.getFingerprint = getFingerprint;
/**
 * Get a secret recovery phrase (or mnemonic phrase) in string form as a
 * `Uint8Array`. The secret recovery phrase is split into words, and each word
 * is converted to a number using the BIP-39 word list. The numbers are then
 * converted to bytes, and the bytes are concatenated into a single
 * `Uint8Array`.
 *
 * @param mnemonicPhrase - The secret recovery phrase to convert.
 * @returns The `Uint8Array` corresponding to the secret recovery phrase.
 */
function mnemonicPhraseToBytes(mnemonicPhrase) {
    const words = mnemonicPhrase.split(' ');
    const indices = words.map((word) => {
        const index = english_1.wordlist.indexOf(word);
        (0, utils_1.assert)(index !== -1, `Invalid mnemonic phrase: Unknown word "${word}".`);
        return index;
    });
    return new Uint8Array(new Uint16Array(indices).buffer);
}
exports.mnemonicPhraseToBytes = mnemonicPhraseToBytes;
/**
 * Validates the curve name.
 *
 * @param curveName - The name of the curve to validate.
 */
function validateCurve(curveName) {
    if (!curveName || typeof curveName !== 'string') {
        throw new Error('Invalid curve: Must specify a curve.');
    }
    if (!Object.keys(curves_1.curves).includes(curveName)) {
        throw new Error(`Invalid curve: Only the following curves are supported: ${Object.keys(curves_1.curves).join(', ')}.`);
    }
}
exports.validateCurve = validateCurve;
/**
 * Get a 4-byte-long `Uint8Array` from a numeric value.
 *
 * @param value - The value to convert to a `Uint8Array`.
 * @param littleEndian - Whether to use little endian byte order.
 * @returns The `Uint8Array` corresponding to the `bigint` value.
 */
function numberToUint32(value, littleEndian = false) {
    const bytes = new Uint8Array(4);
    const view = (0, utils_1.createDataView)(bytes);
    view.setUint32(0, value, littleEndian);
    return bytes;
}
exports.numberToUint32 = numberToUint32;
/**
 * A utility function to check if the Web Crypto API is supported in the current
 * environment.
 *
 * @returns Whether the Web Crypto API is supported.
 */
function isWebCryptoSupported() {
    return Boolean(globalThis.crypto?.subtle);
}
exports.isWebCryptoSupported = isWebCryptoSupported;
/**
 * Validate the network. If the network is specified, it must be either
 * "mainnet" or "testnet". This function throws an error if the network is
 * invalid.
 *
 * @param network - The network to validate.
 * @throws An error if the network is invalid.
 */
function validateNetwork(network) {
    if (network === undefined) {
        return;
    }
    if (typeof network !== 'string') {
        throw new Error('Invalid network: Must be a string if specified.');
    }
    if (!['mainnet', 'testnet'].includes(network)) {
        throw new Error(`Invalid network: Must be either "mainnet" or "testnet" if specified.`);
    }
}
exports.validateNetwork = validateNetwork;
/**
 * Get the BIP-44 coin type from a {@link CoinTypeHDPathTuple} or
 * {@link CoinTypeSeedPathTuple}.
 *
 * This function does not validate the derivation path, and assumes that the
 * derivation path is valid.
 *
 * @param derivationPath - The derivation path to get the BIP-44 coin type from.
 * @returns The BIP-44 coin type.
 */
function getBIP44CoinType(derivationPath) {
    const pathPart = derivationPath[BIP44CoinTypeNode_1.BIP_44_COIN_TYPE_DEPTH].split(':')[1]?.replace(`'`, '');
    (0, utils_1.assert)(pathPart, 'Invalid derivation path: Coin type is not specified.');
    const value = Number.parseInt(pathPart, 10);
    (0, utils_1.assert)(isValidInteger(value), 'Invalid derivation path: Coin type is not a valid integer.');
    return value;
}
exports.getBIP44CoinType = getBIP44CoinType;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk>@metamask/key-tree",file:"node_modules\\@metamask\\key-tree\\dist\\utils.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\account-options.cjs", {"@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Capi%5Caccount-options.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeyringAccountOptionsStruct = exports.KeyringAccountEntropyOptionsStruct = exports.KeyringAccountEntropyPrivateKeyOptionsStruct = exports.KeyringAccountEntropyMnemonicOptionsStruct = exports.KeyringAccountEntropyTypeOption = void 0;
const keyring_utils_1 = require("@metamask/keyring-utils");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
/**
 * Keyring account entropy valid types.
 */
var KeyringAccountEntropyTypeOption;
(function (KeyringAccountEntropyTypeOption) {
    /**
     * Indicates that the account was created from a mnemonic phrase.
     */
    KeyringAccountEntropyTypeOption["Mnemonic"] = "mnemonic";
    /**
     * Indicates that the account was imported from a private key.
     */
    KeyringAccountEntropyTypeOption["PrivateKey"] = "private-key";
})(KeyringAccountEntropyTypeOption || (exports.KeyringAccountEntropyTypeOption = KeyringAccountEntropyTypeOption = {}));
/**
 * Keyring account options struct for mnemonics (BIP-44).
 */
exports.KeyringAccountEntropyMnemonicOptionsStruct = (0, superstruct_1.object)({
    /**
     * Indicates that the account was created from a mnemonic phrase.
     */
    type: (0, superstruct_1.literal)(`${KeyringAccountEntropyTypeOption.Mnemonic}`),
    /**
     * The ID of the entropy source.
     */
    id: (0, superstruct_1.string)(), // TODO: Define a struct for entropy source.
    /**
     * The BIP-44 derivation path used to derive the account.
     */
    derivationPath: (0, superstruct_1.string)(),
    /**
     * Index used to group accounts in the UI.
     *
     * Accounts sharing the same `groupIndex` are displayed together as a
     * multichain account group.
     */
    groupIndex: (0, superstruct_1.number)(),
});
/**
 * Keyring account options struct for private keys.
 */
exports.KeyringAccountEntropyPrivateKeyOptionsStruct = (0, superstruct_1.object)({
    /**
     * Indicates that the account was imported from a private key.
     */
    type: (0, superstruct_1.literal)(`${KeyringAccountEntropyTypeOption.PrivateKey}`),
});
/**
 * Keyring account entropy options struct.
 */
exports.KeyringAccountEntropyOptionsStruct = (0, keyring_utils_1.selectiveUnion)((value) => {
    return (0, utils_1.isPlainObject)(value) &&
        value.type === KeyringAccountEntropyTypeOption.PrivateKey
        ? exports.KeyringAccountEntropyPrivateKeyOptionsStruct
        : exports.KeyringAccountEntropyMnemonicOptionsStruct;
});
/**
 * Keyring options struct. This represents various options for a Keyring account object.
 *
 * See {@link KeyringAccountEntropyMnemonicOptionsStruct} and
 * {@link KeyringAccountEntropyPrivateKeyOptionsStruct}.
 *
 * @example
 * ```ts
 * {
 *   entropy: {
 *     type: 'mnemonic',
 *     id: '01K0BX6VDR5DPDPGGNA8PZVBVB',
 *     derivationPath: "m/44'/60'/0'/0/0",
 *     groupIndex: 0,
 *   },
 * }
 * ```
 *
 * @example
 * ```ts
 * {
 *   entropy: {
 *     type: 'private-key',
 *   },
 *   exportable: true,
 * }
 * ```
 *
 * @example
 * ```ts
 * {
 *   some: {
 *     untyped: 'options',
 *     something: true,
 *   },
 * }
 * ```
 */
exports.KeyringAccountOptionsStruct = (0, superstruct_1.intersection)([
    // Non-Typed options (retro-compatibility):
    (0, superstruct_1.record)((0, superstruct_1.string)(), utils_1.JsonStruct),
    // Typed options. We use `type` instead of `object` here, to allow
    // extra properties. Also, since we use `record` + `intersection` we
    // are guaranteed that all field values will match the `JsonStruct`.
    //
    // READ THIS CAREFULLY:
    // Previous options that can be matched by this struct will be breaking
    // existing keyring account options.
    (0, keyring_utils_1.type)({
        /**
         * Entropy options.
         */
        entropy: (0, keyring_utils_1.exactOptional)(exports.KeyringAccountEntropyOptionsStruct),
        /**
         * Indicates whether the account can be exported.
         */
        exportable: (0, keyring_utils_1.exactOptional)((0, superstruct_1.boolean)()),
    }),
]);

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\api\\account-options.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\account.cjs", {"./account-options.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\account-options.cjs","./caip.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\caip.cjs","@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Capi%5Caccount.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeyringAccountStruct = exports.AnyAccountType = exports.TrxAccountType = exports.SolAccountType = exports.BtcAccountType = exports.EthAccountType = void 0;
const keyring_utils_1 = require("@metamask/keyring-utils");
const superstruct_1 = require("@metamask/superstruct");
const account_options_1 = require("./account-options.cjs");
const caip_1 = require("./caip.cjs");
/**
 * Supported Ethereum account types.
 */
var EthAccountType;
(function (EthAccountType) {
    EthAccountType["Eoa"] = "eip155:eoa";
    EthAccountType["Erc4337"] = "eip155:erc4337";
})(EthAccountType || (exports.EthAccountType = EthAccountType = {}));
/**
 * Supported Bitcoin account types.
 */
var BtcAccountType;
(function (BtcAccountType) {
    BtcAccountType["P2pkh"] = "bip122:p2pkh";
    BtcAccountType["P2sh"] = "bip122:p2sh";
    BtcAccountType["P2wpkh"] = "bip122:p2wpkh";
    BtcAccountType["P2tr"] = "bip122:p2tr";
})(BtcAccountType || (exports.BtcAccountType = BtcAccountType = {}));
/**
 * Supported Solana account types.
 */
var SolAccountType;
(function (SolAccountType) {
    SolAccountType["DataAccount"] = "solana:data-account";
})(SolAccountType || (exports.SolAccountType = SolAccountType = {}));
/**
 * Supported Tron account types.
 */
var TrxAccountType;
(function (TrxAccountType) {
    TrxAccountType["Eoa"] = "tron:eoa";
})(TrxAccountType || (exports.TrxAccountType = TrxAccountType = {}));
/**
 * A generic account type. It can be used to represent any account type that is
 * not covered by the other account types. It only applies to non-EVM chains.
 */
var AnyAccountType;
(function (AnyAccountType) {
    AnyAccountType["Account"] = "any:account";
})(AnyAccountType || (exports.AnyAccountType = AnyAccountType = {}));
/**
 * A struct which represents a Keyring account object. It is abstract enough to
 * be used with any blockchain. Specific blockchain account types should extend
 * this struct.
 *
 * See {@link KeyringAccount}.
 */
exports.KeyringAccountStruct = (0, keyring_utils_1.object)({
    /**
     * Account ID (UUIDv4).
     */
    id: keyring_utils_1.AccountIdStruct,
    /**
     * Account type.
     */
    type: (0, superstruct_1.enums)([
        `${EthAccountType.Eoa}`,
        `${EthAccountType.Erc4337}`,
        `${BtcAccountType.P2pkh}`,
        `${BtcAccountType.P2sh}`,
        `${BtcAccountType.P2wpkh}`,
        `${BtcAccountType.P2tr}`,
        `${SolAccountType.DataAccount}`,
        `${TrxAccountType.Eoa}`,
        `${AnyAccountType.Account}`,
    ]),
    /**
     * Account main address.
     */
    address: (0, superstruct_1.string)(),
    /**
     * Account supported scopes (CAIP-2 chain IDs).
     */
    scopes: (0, superstruct_1.nonempty)((0, superstruct_1.array)(caip_1.CaipChainIdStruct)),
    /**
     * Account options.
     */
    options: account_options_1.KeyringAccountOptionsStruct,
    /**
     * Account supported methods.
     */
    methods: (0, superstruct_1.array)((0, superstruct_1.string)()),
});

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\api\\account.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\address.cjs", {"@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Capi%5Caddress.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResolvedAccountAddressStruct = void 0;
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
/**
 * An account's address that has been resolved from a signing request.
 */
exports.ResolvedAccountAddressStruct = (0, superstruct_1.object)({
    /**
     * Account main address (CAIP-10 account ID).
     */
    address: utils_1.CaipAccountIdStruct,
});

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\api\\address.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\asset.cjs", {"@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Capi%5Casset.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssetStruct = exports.NonFungibleAssetStruct = exports.FungibleAssetStruct = exports.FungibleAssetAmountStruct = void 0;
const keyring_utils_1 = require("@metamask/keyring-utils");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
/**
 * Fungible asset amount struct.
 */
exports.FungibleAssetAmountStruct = (0, keyring_utils_1.object)({
    /**
     * Asset unit.
     */
    unit: (0, superstruct_1.string)(),
    /**
     * Asset amount.
     */
    amount: keyring_utils_1.StringNumberStruct,
});
/**
 * Fungible asset struct.
 */
exports.FungibleAssetStruct = (0, keyring_utils_1.object)({
    /**
     * It is a fungible asset.
     */
    fungible: (0, superstruct_1.literal)(true),
    /**
     * Asset type (CAIP-19).
     */
    type: utils_1.CaipAssetTypeStruct,
    ...exports.FungibleAssetAmountStruct.schema,
});
/**
 * Non-fungible asset struct.
 */
exports.NonFungibleAssetStruct = (0, keyring_utils_1.object)({
    /**
     * It is a non-fungible asset.
     */
    fungible: (0, superstruct_1.literal)(false),
    /**
     * Asset ID (CAIP-19).
     */
    id: utils_1.CaipAssetIdStruct,
});
/**
 * Asset struct. This represents a fungible or non-fungible asset. Fungible
 * assets include an amount and a unit in addition to the asset type. While
 * non-fungible assets include only an asset ID.
 *
 * See {@link NonFungibleAssetStruct} and {@link FungibleAssetStruct}.
 *
 * All assets have a `fungible` property that is used to tag the union and
 * allow the following pattern:
 *
 * ```ts
 * if (asset.fungible) {
 *   // Use asset.type
 * } else {
 *   // Use asset.id
 * }
 * ```
 *
 * @example
 * ```ts
 * {
 *   fungible: true,
 *   type: 'eip155:1/slip44:60',
 *   unit: 'ETH',
 *   amount: '0.01',
 * }
 * ```
 *
 * @example
 * ```ts
 * {
 *   fungible: false,
 *   id: 'eip155:1/erc721:0x06012c8cf97BEaD5deAe237070F9587f8E7A266d/771769',
 * }
 * ```
 */
exports.AssetStruct = (0, keyring_utils_1.selectiveUnion)((value) => {
    return (0, utils_1.isPlainObject)(value) && !value.fungible
        ? exports.NonFungibleAssetStruct
        : exports.FungibleAssetStruct;
});

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\api\\asset.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\balance.cjs", {"@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Capi%5Cbalance.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BalanceStruct = void 0;
const keyring_utils_1 = require("@metamask/keyring-utils");
const superstruct_1 = require("@metamask/superstruct");
exports.BalanceStruct = (0, keyring_utils_1.object)({
    amount: keyring_utils_1.StringNumberStruct,
    unit: (0, superstruct_1.string)(),
});

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\api\\balance.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\caip.cjs", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Capi%5Ccaip.cjs
      return function (require, module, exports) {
"use strict";
// istanbul ignore file
Object.defineProperty(exports, "__esModule", { value: true });
exports.CaipChainIdStruct = exports.CaipAssetTypeOrIdStruct = exports.CaipAssetTypeStruct = exports.CaipAssetIdStruct = exports.CaipAccountIdStruct = void 0;
const utils_1 = require("@metamask/utils");
Object.defineProperty(exports, "CaipAccountIdStruct", { enumerable: true, get: function () { return utils_1.CaipAccountIdStruct; } });
Object.defineProperty(exports, "CaipAssetIdStruct", { enumerable: true, get: function () { return utils_1.CaipAssetIdStruct; } });
Object.defineProperty(exports, "CaipAssetTypeStruct", { enumerable: true, get: function () { return utils_1.CaipAssetTypeStruct; } });
Object.defineProperty(exports, "CaipAssetTypeOrIdStruct", { enumerable: true, get: function () { return utils_1.CaipAssetTypeOrIdStruct; } });
Object.defineProperty(exports, "CaipChainIdStruct", { enumerable: true, get: function () { return utils_1.CaipChainIdStruct; } });

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\api\\caip.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\derivation.cjs", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Capi%5Cderivation.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DerivationPathStruct = void 0;
const utils_1 = require("@metamask/utils");
exports.DerivationPathStruct = (0, utils_1.definePattern)('DerivationPath', /^m(?:\/\d+'?)+$/u);

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\api\\derivation.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\discovery.cjs", {"./caip.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\caip.cjs","./derivation.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\derivation.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Capi%5Cdiscovery.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DiscoveredAccountStruct = exports.DiscoveredBip44AccountStruct = exports.DiscoveredAccountType = void 0;
const superstruct_1 = require("@metamask/superstruct");
const caip_1 = require("./caip.cjs");
const derivation_1 = require("./derivation.cjs");
/**
 * Account type tag.
 *
 * The main use of this enum is to tag the {@link DiscoveredAccount} type for
 * future use.
 */
var DiscoveredAccountType;
(function (DiscoveredAccountType) {
    // BIP-44 compatible accounts.
    DiscoveredAccountType["Bip44"] = "bip44";
})(DiscoveredAccountType || (exports.DiscoveredAccountType = DiscoveredAccountType = {}));
/**
 * This struct represents a discovered BIP-44 compatible account.
 *
 * It supports BIP-44 in a non-strict way. The derivation path MUST HAVE at
 * least 1 segment.
 */
exports.DiscoveredBip44AccountStruct = (0, superstruct_1.object)({
    /**
     * Account type.
     */
    type: (0, superstruct_1.literal)(`${DiscoveredAccountType.Bip44}`),
    /**
     * Account supported scopes (CAIP-2 chain IDs).
     */
    scopes: (0, superstruct_1.array)(caip_1.CaipChainIdStruct),
    /**
     * The derivation path for this account. It MUST HAVE at least 1 segment.
     */
    derivationPath: derivation_1.DerivationPathStruct,
});
// Could become a union if we have new discovered account type.
exports.DiscoveredAccountStruct = exports.DiscoveredBip44AccountStruct;

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\api\\discovery.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\export.cjs", {"@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Capi%5Cexport.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeyringAccountDataStruct = void 0;
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
exports.KeyringAccountDataStruct = (0, superstruct_1.record)((0, superstruct_1.string)(), utils_1.JsonStruct);

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\api\\export.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\index.cjs", {"./account-options.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\account-options.cjs","./account.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\account.cjs","./address.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\address.cjs","./asset.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\asset.cjs","./balance.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\balance.cjs","./caip.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\caip.cjs","./discovery.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\discovery.cjs","./export.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\export.cjs","./options.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\options.cjs","./pagination.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\pagination.cjs","./request.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\request.cjs","./response.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\response.cjs","./transaction.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\transaction.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Capi%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./account.cjs"), exports);
__exportStar(require("./account-options.cjs"), exports);
__exportStar(require("./address.cjs"), exports);
__exportStar(require("./asset.cjs"), exports);
__exportStar(require("./balance.cjs"), exports);
__exportStar(require("./caip.cjs"), exports);
__exportStar(require("./discovery.cjs"), exports);
__exportStar(require("./export.cjs"), exports);
__exportStar(require("./request.cjs"), exports);
__exportStar(require("./response.cjs"), exports);
__exportStar(require("./transaction.cjs"), exports);
__exportStar(require("./pagination.cjs"), exports);
__exportStar(require("./options.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\api\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\options.cjs", {"@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Capi%5Coptions.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetaMaskOptionsStruct = void 0;
const keyring_utils_1 = require("@metamask/keyring-utils");
exports.MetaMaskOptionsStruct = (0, keyring_utils_1.object)({
    /**
     * MetaMask internal options. The 'metamask' field will only be set when
     * the keyring API is being used by a MetaMask client.
     */
    metamask: (0, keyring_utils_1.exactOptional)((0, keyring_utils_1.object)({
        /**
         * Correlation ID that can be passed by MetaMask.
         */
        correlationId: keyring_utils_1.UuidStruct,
    })),
});

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\api\\options.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\pagination.cjs", {"@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Capi%5Cpagination.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PaginationStruct = void 0;
const keyring_utils_1 = require("@metamask/keyring-utils");
const superstruct_1 = require("@metamask/superstruct");
/**
 * Pagination struct. This struct is used to specify the limit of items to
 * return and the next cursor to iterate over the results.
 *
 * @example
 * ```ts
 * {
 *   limit: 10,
 *   next: 'c3y1Q6QtqtstbxKX+oqVdEW6',
 * }
 * ```
 */
exports.PaginationStruct = (0, keyring_utils_1.object)({
    /**
     * Maximum number of items to return.
     */
    limit: (0, superstruct_1.number)(),
    /**
     * Next cursor to iterate over the results.
     */
    next: (0, keyring_utils_1.exactOptional)((0, superstruct_1.nullable)((0, superstruct_1.string)())),
});

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\api\\pagination.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\request.cjs", {"@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Capi%5Crequest.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeyringRequestStruct = void 0;
const keyring_utils_1 = require("@metamask/keyring-utils");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
exports.KeyringRequestStruct = (0, keyring_utils_1.object)({
    /**
     * Keyring request ID (UUIDv4).
     */
    id: keyring_utils_1.UuidStruct,
    /**
     * Request's scope (CAIP-2 chain ID).
     */
    scope: (0, superstruct_1.string)(),
    /**
     * Account ID (UUIDv4).
     */
    account: keyring_utils_1.UuidStruct,
    /**
     * Origin of the sender.
     */
    origin: (0, superstruct_1.string)(),
    /**
     * Inner request sent by the client application.
     */
    request: (0, keyring_utils_1.object)({
        method: (0, superstruct_1.string)(),
        params: (0, keyring_utils_1.exactOptional)((0, superstruct_1.union)([(0, superstruct_1.array)(utils_1.JsonStruct), (0, superstruct_1.record)((0, superstruct_1.string)(), utils_1.JsonStruct)])),
    }),
});

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\api\\request.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\response.cjs", {"@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Capi%5Cresponse.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeyringResponseStruct = void 0;
const keyring_utils_1 = require("@metamask/keyring-utils");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
exports.KeyringResponseStruct = (0, superstruct_1.union)([
    (0, keyring_utils_1.object)({
        /**
         * Pending flag.
         *
         * Setting the pending flag to true indicates that the request will be
         * handled asynchronously. The keyring must be called with `approveRequest`
         * or `rejectRequest` to resolve the request.
         */
        pending: (0, superstruct_1.literal)(true),
        /**
         * Redirect URL.
         *
         * If present in the response, MetaMask will display a confirmation dialog
         * with a link to the redirect URL. The user can choose to follow the link
         * or cancel the request.
         */
        redirect: (0, keyring_utils_1.exactOptional)((0, keyring_utils_1.object)({
            message: (0, keyring_utils_1.exactOptional)((0, superstruct_1.string)()),
            url: (0, keyring_utils_1.exactOptional)((0, superstruct_1.string)()),
        })),
    }),
    (0, keyring_utils_1.object)({
        /**
         * Pending flag.
         *
         * Setting the pending flag to false indicates that the request will be
         * handled synchronously. The keyring must return the result of the
         * request execution.
         */
        pending: (0, superstruct_1.literal)(false),
        /**
         * Request result.
         */
        result: utils_1.JsonStruct,
    }),
]);

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\api\\response.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\transaction.cjs", {"./asset.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\asset.cjs","./caip.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\caip.cjs","@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Capi%5Ctransaction.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TransactionsPageStruct = exports.TransactionStruct = exports.TransactionEventStruct = exports.TransactionType = exports.TransactionStatus = exports.FeeType = void 0;
const keyring_utils_1 = require("@metamask/keyring-utils");
const superstruct_1 = require("@metamask/superstruct");
const asset_1 = require("./asset.cjs");
const caip_1 = require("./caip.cjs");
/**
 * This struct represents a participant in a transaction.
 *
 * @example
 * ```ts
 * {
 *   address: '0x1234...',
 *   asset: {
 *     fungible: true,
 *     type: 'eip155:1/slip44:60',
 *     unit: 'ETH',
 *     amount: '0.01',
 *   },
 * },
 * ```
 *
 * @example
 * ```ts
 * {
 *   address: '0x1234...',
 *   asset: {
 *     fungible: false,
 *     id: 'eip155:1/erc721:0x06012c8cf97BEaD5deAe237070F9587f8E7A266d/771769',
 *   },
 * },
 * ```
 *
 * @example
 * ```ts
 * {
 *   address: '0x1234...',
 *   asset: null,
 * },
 * ```
 */
const ParticipantStruct = (0, keyring_utils_1.object)({
    /**
     * Participant address.
     */
    address: (0, superstruct_1.string)(),
    /**
     * Asset being transferred.
     */
    asset: (0, superstruct_1.nullable)(asset_1.AssetStruct),
});
/**
 * Fee types.
 */
var FeeType;
(function (FeeType) {
    /**
     * Base fee. It is the minimum fee required to include a transaction in the
     * blockchain.
     *
     * For non-confirmed transactions, it must be the maximum base fee. For
     * confirmed transactions, it must be the actual base fee paid.
     */
    FeeType["Base"] = "base";
    /**
     * Priority fee. It is an optional fee used to prioritize the transaction.
     *
     * For non-confirmed transactions, it must be the maximum priority fee. For
     * confirmed transactions, it must be the actual priority fee paid.
     */
    FeeType["Priority"] = "priority";
})(FeeType || (exports.FeeType = FeeType = {}));
/**
 * This struct represents a transaction fee.
 */
const FeeStruct = (0, keyring_utils_1.object)({
    /**
     * Fee type {@see FeeType}.
     */
    type: (0, superstruct_1.enums)([`${FeeType.Base}`, `${FeeType.Priority}`]),
    /**
     * Asset used to pay for the fee.
     */
    asset: asset_1.AssetStruct,
});
/**
 * Transaction statuses.
 */
var TransactionStatus;
(function (TransactionStatus) {
    /**
     * The transaction has been submitted but is not yet in the
     * blockchain. For example, it can be in the mempool.
     */
    TransactionStatus["Submitted"] = "submitted";
    /**
     * The transaction is in the blockchain but has not been
     * confirmed yet.
     */
    TransactionStatus["Unconfirmed"] = "unconfirmed";
    /**
     * The transaction has been confirmed.
     */
    TransactionStatus["Confirmed"] = "confirmed";
    /**
     * The transaction has failed. For example, it has been reverted.
     */
    TransactionStatus["Failed"] = "failed";
})(TransactionStatus || (exports.TransactionStatus = TransactionStatus = {}));
/**
 * Transaction types.
 */
var TransactionType;
(function (TransactionType) {
    /**
     * The transaction was originated by the account. If the transaction
     * has a change output that goes back to the same account, it must be tagged
     * as a send transaction.
     */
    TransactionType["Send"] = "send";
    /**
     * The transaction was received by the account, but originated by
     * another account.
     */
    TransactionType["Receive"] = "receive";
    /**
     * The transaction is a swap. It decreases the balance of one asset and
     * increases the balance of another asset in a single transaction.
     *
     * A swap transaction must be originated by the account.
     */
    TransactionType["Swap"] = "swap";
    /**
     * Represents an outgoing bridge transaction, transferring assets from
     * the account to another blockchain.
     */
    TransactionType["BridgeSend"] = "bridge:send";
    /**
     * Represents an incoming bridge transaction, transferring assets from
     * another blockchain to the account.
     */
    TransactionType["BridgeReceive"] = "bridge:receive";
    /**
     * The transaction type is unknown. It's not possible to determine the
     * transaction type based on the information available.
     */
    TransactionType["Unknown"] = "unknown";
})(TransactionType || (exports.TransactionType = TransactionType = {}));
/**
 * This struct represents a transaction event.
 */
exports.TransactionEventStruct = (0, keyring_utils_1.object)({
    /**
     * New status of the transaction.
     */
    status: (0, superstruct_1.enums)([
        `${TransactionStatus.Submitted}`,
        `${TransactionStatus.Unconfirmed}`,
        `${TransactionStatus.Confirmed}`,
        `${TransactionStatus.Failed}`,
    ]),
    /**
     * UNIX timestamp of when the event occurred.
     */
    timestamp: (0, superstruct_1.nullable)((0, superstruct_1.number)()),
});
/**
 * This struct represents a blockchain transaction.
 *
 * @example
 * ```ts
 * const tx = {
 *   id: 'f5d8ee39a430901c91a5917b9f2dc19d6d1a0e9cea205b009ca73dd04470b9a6',
 *   chain: 'bip122:000000000019d6689c085ae165831e93',
 *   account: 'b9beb861-9761-4b97-89ce-d992be5f34da',
 *   status: 'confirmed',
 *   timestamp: 1716367781,
 *   type: 'send',
 *   from: [
 *     {
 *       address: 'bc1qrp0yzgkf8rawkuvdlhnjfj2fnjwm0m8727kgah',
 *       asset: {
 *         fungible: true,
 *         type: 'bip122:000000000019d6689c085ae165831e93/slip44:0',
 *         unit: 'BTC',
 *         amount: '0.1',
 *       },
 *     },
 *   ],
 *   to: [
 *     {
 *       address: 'bc1qrp0yzgkf8rawkuvdlhnjfj2fnjwm0m8727kgah',
 *       asset: {
 *         fungible: true,
 *         type: 'bip122:000000000019d6689c085ae165831e93/slip44:0',
 *         unit: 'BTC',
 *         amount: '0.1',
 *       },
 *     },
 *     {
 *       address: 'bc1qwl8399fz829uqvqly9tcatgrgtwp3udnhxfq4k',
 *       asset: {
 *         fungible: true,
 *         type: 'bip122:000000000019d6689c085ae165831e93/slip44:0',
 *         unit: 'BTC',
 *         amount: '0.1',
 *       },
 *     },
 *   ],
 *   fees: [
 *     {
 *       type: 'priority',
 *       asset: {
 *         fungible: true,
 *         type: 'bip122:000000000019d6689c085ae165831e93/slip44:0',
 *         unit: 'BTC',
 *         amount: '0.1',
 *       },
 *     },
 *   ],
 * };
 * ```
 */
exports.TransactionStruct = (0, keyring_utils_1.object)({
    /**
     * Chain-specific transaction ID.
     */
    id: (0, superstruct_1.string)(),
    /**
     * Chain ID (CAIP-2).
     */
    chain: caip_1.CaipChainIdStruct,
    /**
     * Account ID (UUIDv4).
     */
    account: keyring_utils_1.UuidStruct,
    /**
     * Transaction status {@see TransactionStatus}.
     */
    status: (0, superstruct_1.enums)([
        `${TransactionStatus.Submitted}`,
        `${TransactionStatus.Unconfirmed}`,
        `${TransactionStatus.Confirmed}`,
        `${TransactionStatus.Failed}`,
    ]),
    /**
     * UNIX timestamp of when the transaction was added to the blockchain. The
     * timestamp can be null if the transaction has not been included in the
     * blockchain yet.
     */
    timestamp: (0, superstruct_1.nullable)((0, superstruct_1.number)()),
    /**
     * Transaction type {@see TransactionType}. This will be used by MetaMask to enrich the transaction
     * details on the UI.
     */
    type: (0, superstruct_1.enums)([
        `${TransactionType.Send}`,
        `${TransactionType.Receive}`,
        `${TransactionType.Swap}`,
        `${TransactionType.BridgeSend}`,
        `${TransactionType.BridgeReceive}`,
        `${TransactionType.Unknown}`,
    ]),
    /**
     * Transaction sender addresses and amounts.
     */
    from: (0, superstruct_1.array)(ParticipantStruct),
    /**
     * Transaction receiver addresses and amounts.
     */
    to: (0, superstruct_1.array)(ParticipantStruct),
    /**
     * Total transaction fee.
     */
    fees: (0, superstruct_1.array)(FeeStruct),
    /**
     * List of events related to the transaction {@see TransactionEventStruct}.
     *
     * The events are tracked in a best-effort basis and may not be available for
     * all transactions.
     */
    events: (0, superstruct_1.array)(exports.TransactionEventStruct),
});
/**
 * This struct represents a page of transactions.
 *
 * @example
 * ```ts
 * {
 *   data: [
 *     {
 *       // Transaction object
 *     }
 *   ],
 *   next: 'c3y1Q6QtqtstbxKX+oqVdEW6',
 * }
 * ```
 *
 * @example
 * ```ts
 * {
 *   data: [
 *     {
 *       // Transaction object
 *     }
 *   ],
 *   next: null, // No more results
 * }**
 * ```
 */
exports.TransactionsPageStruct = (0, keyring_utils_1.object)({
    /**
     * List of transactions.
     */
    data: (0, superstruct_1.array)(exports.TransactionStruct),
    /**
     * Next cursor to iterate over the results. If null, there are no more
     * results.
     */
    next: (0, superstruct_1.nullable)((0, superstruct_1.string)()),
});

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\api\\transaction.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\btc\\constants.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Cbtc%5Cconstants.cjs
      return function (require, module, exports) {
"use strict";
// istanbul ignore file
Object.defineProperty(exports, "__esModule", { value: true });
exports.BtcScope = void 0;
/**
 * Scopes for Bitcoin account type. See {@link KeyringAccount.scopes}.
 */
var BtcScope;
(function (BtcScope) {
    BtcScope["Mainnet"] = "bip122:000000000019d6689c085ae165831e93";
    BtcScope["Testnet"] = "bip122:000000000933ea01ad0ee984209779ba";
    BtcScope["Testnet4"] = "bip122:00000000da84f2bafbbc53dee25a72ae";
    BtcScope["Signet"] = "bip122:00000008819873e925422c1ff0f99f7c";
    BtcScope["Regtest"] = "bip122:regtest";
})(BtcScope || (exports.BtcScope = BtcScope = {}));

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\btc\\constants.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\btc\\index.cjs", {"./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\btc\\constants.cjs","./types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\btc\\types.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Cbtc%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./constants.cjs"), exports);
__exportStar(require("./types.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\btc\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\btc\\types.cjs", {"../api/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\index.cjs","@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","bitcoin-address-validation":"D:\\code\\v\\metamask-extension\\node_modules\\bitcoin-address-validation\\lib\\index.cjs.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Cbtc%5Ctypes.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BtcP2trAccountStruct = exports.BtcP2wpkhAccountStruct = exports.BtcP2shAccountStruct = exports.BtcP2pkhAccountStruct = exports.BtcMethod = exports.BtcP2trAddressStruct = exports.BtcP2wpkhAddressStruct = exports.BtcP2shAddressStruct = exports.BtcP2pkhAddressStruct = void 0;
const keyring_utils_1 = require("@metamask/keyring-utils");
const superstruct_1 = require("@metamask/superstruct");
const bitcoin_address_validation_1 = require("bitcoin-address-validation");
const api_1 = require("../api/index.cjs");
const validateAddress = (address, type) => {
    try {
        const addressInfo = (0, bitcoin_address_validation_1.getAddressInfo)(address);
        if (addressInfo.type === type) {
            return true;
        }
        return new Error(`Invalid ${type} address`);
    }
    catch (error) {
        return new Error(`Failed to decode ${type} address: ${error.message}`);
    }
};
exports.BtcP2pkhAddressStruct = (0, superstruct_1.refine)((0, superstruct_1.string)(), 'BtcP2pkhAddressStruct', (address) => {
    return validateAddress(address, bitcoin_address_validation_1.AddressType.p2pkh);
});
exports.BtcP2shAddressStruct = (0, superstruct_1.refine)((0, superstruct_1.string)(), 'BtcP2shAddressStruct', (address) => {
    return validateAddress(address, bitcoin_address_validation_1.AddressType.p2sh);
});
exports.BtcP2wpkhAddressStruct = (0, superstruct_1.refine)((0, superstruct_1.string)(), 'BtcP2wpkhAddressStruct', (address) => {
    return validateAddress(address, bitcoin_address_validation_1.AddressType.p2wpkh);
});
exports.BtcP2trAddressStruct = (0, superstruct_1.refine)((0, superstruct_1.string)(), 'BtcP2trAddressStruct', (address) => {
    return validateAddress(address, bitcoin_address_validation_1.AddressType.p2tr);
});
/**
 * Supported Bitcoin methods.
 */
var BtcMethod;
(function (BtcMethod) {
    BtcMethod["SignPsbt"] = "signPsbt";
    BtcMethod["ComputeFee"] = "computeFee";
    BtcMethod["FillPsbt"] = "fillPsbt";
    BtcMethod["BroadcastPsbt"] = "broadcastPsbt";
    BtcMethod["SendTransfer"] = "sendTransfer";
    BtcMethod["GetUtxo"] = "getUtxo";
    BtcMethod["ListUtxos"] = "listUtxos";
    BtcMethod["PublicDescriptor"] = "publicDescriptor";
    BtcMethod["SignMessage"] = "signMessage";
})(BtcMethod || (exports.BtcMethod = BtcMethod = {}));
const BtcAccountStruct = (0, keyring_utils_1.object)({
    ...api_1.KeyringAccountStruct.schema,
    /**
     * Account supported scopes (CAIP-2 chain ID).
     */
    scopes: (0, superstruct_1.nonempty)((0, superstruct_1.array)(api_1.CaipChainIdStruct)),
    /**
     * Account supported methods.
     */
    methods: (0, superstruct_1.array)((0, superstruct_1.enums)(Object.values(BtcMethod))),
});
exports.BtcP2pkhAccountStruct = (0, keyring_utils_1.object)({
    ...BtcAccountStruct.schema,
    /**
     * Account P2PKH address.
     */
    address: exports.BtcP2pkhAddressStruct,
    /**
     * Account type.
     */
    type: (0, superstruct_1.literal)(`${api_1.BtcAccountType.P2pkh}`),
});
exports.BtcP2shAccountStruct = (0, keyring_utils_1.object)({
    ...BtcAccountStruct.schema,
    /**
     * Account P2SH address.
     */
    address: exports.BtcP2shAddressStruct,
    /**
     * Account type.
     */
    type: (0, superstruct_1.literal)(`${api_1.BtcAccountType.P2sh}`),
});
exports.BtcP2wpkhAccountStruct = (0, keyring_utils_1.object)({
    ...BtcAccountStruct.schema,
    /**
     * Account P2WPKH address.
     */
    address: exports.BtcP2wpkhAddressStruct,
    /**
     * Account type.
     */
    type: (0, superstruct_1.literal)(`${api_1.BtcAccountType.P2wpkh}`),
});
exports.BtcP2trAccountStruct = (0, keyring_utils_1.object)({
    ...BtcAccountStruct.schema,
    /**
     * Account P2TR address.
     */
    address: exports.BtcP2trAddressStruct,
    /**
     * Account type.
     */
    type: (0, superstruct_1.literal)(`${api_1.BtcAccountType.P2tr}`),
});

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\btc\\types.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\eth\\constants.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Ceth%5Cconstants.cjs
      return function (require, module, exports) {
"use strict";
// istanbul ignore file
Object.defineProperty(exports, "__esModule", { value: true });
exports.EthScope = void 0;
/**
 * Scopes for EVM account type. See {@link KeyringAccount.scopes}.
 */
var EthScope;
(function (EthScope) {
    EthScope["Eoa"] = "eip155:0";
    EthScope["Mainnet"] = "eip155:1";
    EthScope["Testnet"] = "eip155:11155111";
})(EthScope || (exports.EthScope = EthScope = {}));

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\eth\\constants.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\eth\\erc4337\\index.cjs", {"./types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\eth\\erc4337\\types.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Ceth%5Cerc4337%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./types.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\eth\\erc4337\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\eth\\erc4337\\types.cjs", {"../types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\eth\\types.cjs","@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Ceth%5Cerc4337%5Ctypes.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EthUserOperationPatchStruct = exports.EthBaseUserOperationStruct = exports.EthBaseTransactionStruct = exports.EthUserOperationStruct = void 0;
const keyring_utils_1 = require("@metamask/keyring-utils");
const types_1 = require("../types.cjs");
/**
 * Struct of a UserOperation as defined by ERC-4337.
 *
 * @see https://eips.ethereum.org/EIPS/eip-4337#definitions
 */
exports.EthUserOperationStruct = (0, keyring_utils_1.object)({
    sender: types_1.EthAddressStruct,
    nonce: types_1.EthUint256Struct,
    initCode: types_1.EthBytesStruct,
    callData: types_1.EthBytesStruct,
    callGasLimit: types_1.EthUint256Struct,
    verificationGasLimit: types_1.EthUint256Struct,
    preVerificationGas: types_1.EthUint256Struct,
    maxFeePerGas: types_1.EthUint256Struct,
    maxPriorityFeePerGas: types_1.EthUint256Struct,
    paymasterAndData: types_1.EthBytesStruct,
    signature: types_1.EthBytesStruct,
});
/**
 * Struct containing the most basic transaction information required to
 * construct a UserOperation.
 */
exports.EthBaseTransactionStruct = (0, keyring_utils_1.object)({
    /**
     * Address of the transaction recipient.
     */
    to: types_1.EthAddressStruct,
    /**
     * Amount of wei to transfer to the recipient.
     */
    value: types_1.EthUint256Struct,
    /**
     * Data to pass to the recipient.
     */
    data: types_1.EthBytesStruct,
});
exports.EthBaseUserOperationStruct = (0, keyring_utils_1.object)({
    nonce: types_1.EthUint256Struct,
    initCode: types_1.EthBytesStruct,
    callData: types_1.EthBytesStruct,
    gasLimits: (0, keyring_utils_1.exactOptional)((0, keyring_utils_1.object)({
        callGasLimit: types_1.EthUint256Struct,
        verificationGasLimit: types_1.EthUint256Struct,
        preVerificationGas: types_1.EthUint256Struct,
    })),
    dummyPaymasterAndData: types_1.EthBytesStruct,
    dummySignature: types_1.EthBytesStruct,
    bundlerUrl: keyring_utils_1.UrlStruct,
});
exports.EthUserOperationPatchStruct = (0, keyring_utils_1.object)({
    paymasterAndData: types_1.EthBytesStruct,
    callGasLimit: (0, keyring_utils_1.exactOptional)(types_1.EthUint256Struct),
    verificationGasLimit: (0, keyring_utils_1.exactOptional)(types_1.EthUint256Struct),
    preVerificationGas: (0, keyring_utils_1.exactOptional)(types_1.EthUint256Struct),
});

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\eth\\erc4337\\types.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\eth\\index.cjs", {"./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\eth\\constants.cjs","./erc4337/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\eth\\erc4337\\index.cjs","./types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\eth\\types.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\eth\\utils.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Ceth%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./constants.cjs"), exports);
__exportStar(require("./erc4337/index.cjs"), exports);
__exportStar(require("./types.cjs"), exports);
__exportStar(require("./utils.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\eth\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\eth\\types.cjs", {"../api/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\index.cjs","./index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\eth\\index.cjs","@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Ceth%5Ctypes.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EthErc4337AccountStruct = exports.EthEoaAccountStruct = exports.EthMethod = exports.EthUint256Struct = exports.EthAddressStruct = exports.EthBytesStruct = void 0;
const keyring_utils_1 = require("@metamask/keyring-utils");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const _1 = require("./index.cjs");
const api_1 = require("../api/index.cjs");
exports.EthBytesStruct = (0, utils_1.definePattern)('EthBytes', /^0x[0-9a-f]*$/iu);
exports.EthAddressStruct = (0, utils_1.definePattern)('EthAddress', /^0x[0-9a-f]{40}$/iu);
exports.EthUint256Struct = (0, utils_1.definePattern)('EthUint256', /^0x([1-9a-f][0-9a-f]*|0)$/iu);
/**
 * Supported Ethereum methods.
 */
var EthMethod;
(function (EthMethod) {
    // General signing methods
    EthMethod["PersonalSign"] = "personal_sign";
    EthMethod["Sign"] = "eth_sign";
    EthMethod["SignTransaction"] = "eth_signTransaction";
    EthMethod["SignTypedDataV1"] = "eth_signTypedData_v1";
    EthMethod["SignTypedDataV3"] = "eth_signTypedData_v3";
    EthMethod["SignTypedDataV4"] = "eth_signTypedData_v4";
    // ERC-4337 methods
    EthMethod["PrepareUserOperation"] = "eth_prepareUserOperation";
    EthMethod["PatchUserOperation"] = "eth_patchUserOperation";
    EthMethod["SignUserOperation"] = "eth_signUserOperation";
})(EthMethod || (exports.EthMethod = EthMethod = {}));
exports.EthEoaAccountStruct = (0, keyring_utils_1.object)({
    ...api_1.KeyringAccountStruct.schema,
    /**
     * Account address.
     */
    address: exports.EthAddressStruct,
    /**
     * Account type.
     */
    type: (0, superstruct_1.literal)(`${api_1.EthAccountType.Eoa}`),
    /**
     * Account scopes (must be ['eip155:0']).
     */
    scopes: (0, superstruct_1.nonempty)((0, superstruct_1.array)((0, superstruct_1.literal)(_1.EthScope.Eoa))),
    /**
     * Account supported methods.
     */
    methods: (0, superstruct_1.array)((0, superstruct_1.enums)([
        `${EthMethod.PersonalSign}`,
        `${EthMethod.Sign}`,
        `${EthMethod.SignTransaction}`,
        `${EthMethod.SignTypedDataV1}`,
        `${EthMethod.SignTypedDataV3}`,
        `${EthMethod.SignTypedDataV4}`,
    ])),
});
exports.EthErc4337AccountStruct = (0, keyring_utils_1.object)({
    ...api_1.KeyringAccountStruct.schema,
    /**
     * Account address.
     */
    address: exports.EthAddressStruct,
    /**
     * Account type.
     */
    type: (0, superstruct_1.literal)(`${api_1.EthAccountType.Erc4337}`),
    /**
     * Account supported scopes (CAIP-2 chain IDs).
     */
    scopes: (0, superstruct_1.nonempty)((0, superstruct_1.array)(api_1.CaipChainIdStruct)),
    /**
     * Account supported methods.
     */
    methods: (0, superstruct_1.array)((0, superstruct_1.enums)([
        `${EthMethod.PersonalSign}`,
        `${EthMethod.Sign}`,
        `${EthMethod.SignTypedDataV1}`,
        `${EthMethod.SignTypedDataV3}`,
        `${EthMethod.SignTypedDataV4}`,
        `${EthMethod.PrepareUserOperation}`,
        `${EthMethod.PatchUserOperation}`,
        `${EthMethod.SignUserOperation}`,
    ])),
});

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\eth\\types.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\eth\\utils.cjs", {"../api/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Ceth%5Cutils.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isEvmAccountType = isEvmAccountType;
const api_1 = require("../api/index.cjs");
/**
 * Checks if the given type is an EVM account type.
 *
 * @param type - The type to check.
 * @returns Returns true if the type is an EVM account type, false otherwise.
 */
function isEvmAccountType(type) {
    return type === api_1.EthAccountType.Eoa || type === api_1.EthAccountType.Erc4337;
}

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\eth\\utils.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\events.cjs", {"./api/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\index.cjs","@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Cevents.cjs
      return function (require, module, exports) {
"use strict";
/* eslint-disable @typescript-eslint/no-redundant-type-constituents */
// FIXME: This rule seems to be triggering a false positive on the `KeyringEvents`.
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccountAssetListUpdatedEventStruct = exports.AccountTransactionsUpdatedEventStruct = exports.AccountBalancesUpdatedEventStruct = exports.RequestRejectedEventStruct = exports.RequestApprovedEventStruct = exports.AccountDeletedEventStruct = exports.AccountUpdatedEventStruct = exports.AccountCreatedEventStruct = exports.KeyringEvent = void 0;
const keyring_utils_1 = require("@metamask/keyring-utils");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const api_1 = require("./api/index.cjs");
/**
 * Supported keyring events.
 */
var KeyringEvent;
(function (KeyringEvent) {
    // Account events
    KeyringEvent["AccountCreated"] = "notify:accountCreated";
    KeyringEvent["AccountUpdated"] = "notify:accountUpdated";
    KeyringEvent["AccountDeleted"] = "notify:accountDeleted";
    // Request events
    KeyringEvent["RequestApproved"] = "notify:requestApproved";
    KeyringEvent["RequestRejected"] = "notify:requestRejected";
    // Assets related events
    KeyringEvent["AccountBalancesUpdated"] = "notify:accountBalancesUpdated";
    KeyringEvent["AccountAssetListUpdated"] = "notify:accountAssetListUpdated";
    KeyringEvent["AccountTransactionsUpdated"] = "notify:accountTransactionsUpdated";
})(KeyringEvent || (exports.KeyringEvent = KeyringEvent = {}));
exports.AccountCreatedEventStruct = (0, keyring_utils_1.object)({
    method: (0, superstruct_1.literal)(`${KeyringEvent.AccountCreated}`),
    params: (0, keyring_utils_1.object)({
        /**
         * New account object.
         */
        account: api_1.KeyringAccountStruct,
        /**
         * Account name suggestion provided to the MetaMask client.
         *
         * The keyring can suggest a name for the account, but it's up to the
         * client to decide whether to use it. The keyring won't be informed if the
         * client decides to use a different name.
         */
        accountNameSuggestion: (0, keyring_utils_1.exactOptional)((0, superstruct_1.string)()),
        /**
         * Instructs MetaMask to display the add account confirmation dialog in the UI.
         *
         * **Note:** This is not guaranteed to be honored by the MetaMask client.
         */
        displayConfirmation: (0, keyring_utils_1.exactOptional)((0, superstruct_1.boolean)()),
        /**
         * Instructs MetaMask to display the name confirmation dialog in the UI.
         * Otherwise, the account will be added with the suggested name, if it's not
         * already in use; if it is, a suffix will be appended to the name to make it
         * unique.
         *
         * **Note:** This is not guaranteed to be honored by the MetaMask client.
         */
        displayAccountNameSuggestion: (0, keyring_utils_1.exactOptional)((0, superstruct_1.boolean)()),
        /**
         * Metamask internal options.
         */
        ...api_1.MetaMaskOptionsStruct.schema,
    }),
});
exports.AccountUpdatedEventStruct = (0, keyring_utils_1.object)({
    method: (0, superstruct_1.literal)(`${KeyringEvent.AccountUpdated}`),
    params: (0, keyring_utils_1.object)({
        /**
         * Updated account object.
         */
        account: api_1.KeyringAccountStruct,
    }),
});
exports.AccountDeletedEventStruct = (0, keyring_utils_1.object)({
    method: (0, superstruct_1.literal)(`${KeyringEvent.AccountDeleted}`),
    params: (0, keyring_utils_1.object)({
        /**
         * Deleted account ID.
         */
        id: keyring_utils_1.UuidStruct,
    }),
});
exports.RequestApprovedEventStruct = (0, keyring_utils_1.object)({
    method: (0, superstruct_1.literal)(`${KeyringEvent.RequestApproved}`),
    params: (0, keyring_utils_1.object)({
        /**
         * Request ID.
         */
        id: keyring_utils_1.UuidStruct,
        /**
         * Request result.
         */
        result: utils_1.JsonStruct,
    }),
});
exports.RequestRejectedEventStruct = (0, keyring_utils_1.object)({
    method: (0, superstruct_1.literal)(`${KeyringEvent.RequestRejected}`),
    params: (0, keyring_utils_1.object)({
        /**
         * Request ID.
         */
        id: keyring_utils_1.UuidStruct,
    }),
});
// Assets related events:
// -----------------------------------------------------------------------------------------------
/**
 * Event emitted when the balances of an account are updated.
 *
 * Only changes are reported.
 *
 * The Snap can choose to emit this event for multiple accounts at once.
 */
exports.AccountBalancesUpdatedEventStruct = (0, keyring_utils_1.object)({
    method: (0, superstruct_1.literal)(`${KeyringEvent.AccountBalancesUpdated}`),
    params: (0, keyring_utils_1.object)({
        /**
         * Balances updates of accounts owned by the Snap.
         */
        balances: (0, superstruct_1.record)(
        /**
         * Account ID.
         */
        keyring_utils_1.AccountIdStruct, 
        /**
         * Mapping of each owned assets and their respective balances for that account.
         */
        (0, superstruct_1.record)(
        /**
         * Asset type (CAIP-19).
         */
        utils_1.CaipAssetTypeStruct, 
        /**
         * Balance information for a given asset.
         */
        api_1.FungibleAssetAmountStruct)),
    }),
});
/**
 * Event emitted when the transactions of an account are updated (added or
 * changed).
 *
 * Only changes are reported.
 *
 * The Snap can choose to emit this event for multiple accounts at once.
 */
exports.AccountTransactionsUpdatedEventStruct = (0, keyring_utils_1.object)({
    method: (0, superstruct_1.literal)(`${KeyringEvent.AccountTransactionsUpdated}`),
    params: (0, keyring_utils_1.object)({
        /**
         * Transactions updates of accounts owned by the Snap.
         */
        transactions: (0, superstruct_1.record)(
        /**
         * Account ID.
         */
        keyring_utils_1.AccountIdStruct, 
        /**
         * List of updated transactions for that account.
         */
        (0, superstruct_1.array)(api_1.TransactionStruct)),
    }),
});
/**
 * Event emitted when the assets of an account are updated.
 *
 * Only changes are reported.
 *
 * The Snap can choose to emit this event for multiple accounts at once.
 */
exports.AccountAssetListUpdatedEventStruct = (0, keyring_utils_1.object)({
    method: (0, superstruct_1.literal)(`${KeyringEvent.AccountAssetListUpdated}`),
    params: (0, keyring_utils_1.object)({
        /**
         * Asset list update of accounts owned by the Snap.
         */
        assets: (0, superstruct_1.record)(
        /**
         * Account ID.
         */
        keyring_utils_1.AccountIdStruct, 
        /**
         * Asset list changes for that account.
         */
        (0, keyring_utils_1.object)({
            /**
             * New assets detected.
             */
            added: (0, superstruct_1.array)(utils_1.CaipAssetTypeOrIdStruct),
            /**
             * Assets no longer available on that account.
             */
            removed: (0, superstruct_1.array)(utils_1.CaipAssetTypeOrIdStruct),
        })),
    }),
});

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\events.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs", {"./api/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\index.cjs","./btc/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\btc\\index.cjs","./eth/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\eth\\index.cjs","./events.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\events.cjs","./rpc.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\rpc.cjs","./sol/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\sol\\index.cjs","./trx/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\trx\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./api/index.cjs"), exports);
__exportStar(require("./btc/index.cjs"), exports);
__exportStar(require("./sol/index.cjs"), exports);
__exportStar(require("./eth/index.cjs"), exports);
__exportStar(require("./trx/index.cjs"), exports);
__exportStar(require("./rpc.cjs"), exports);
__exportStar(require("./events.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\rpc.cjs", {"./api/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\index.cjs","@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Crpc.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RejectRequestResponseStruct = exports.RejectRequestRequestStruct = exports.ApproveRequestResponseStruct = exports.ApproveRequestRequestStruct = exports.SubmitRequestResponseStruct = exports.SubmitRequestRequestStruct = exports.GetRequestResponseStruct = exports.GetRequestRequestStruct = exports.ListRequestsResponseStruct = exports.ListRequestsRequestStruct = exports.ExportAccountResponseStruct = exports.ExportAccountRequestStruct = exports.DeleteAccountResponseStruct = exports.DeleteAccountRequestStruct = exports.UpdateAccountResponseStruct = exports.UpdateAccountRequestStruct = exports.FilterAccountChainsResponseStruct = exports.FilterAccountChainsStruct = exports.ResolveAccountAddressResponseStruct = exports.ResolveAccountAddressRequestStruct = exports.GetAccountBalancesResponseStruct = exports.GetAccountBalancesRequestStruct = exports.ListAccountAssetsResponseStruct = exports.ListAccountAssetsRequestStruct = exports.ListAccountTransactionsResponseStruct = exports.ListAccountTransactionsRequestStruct = exports.DiscoverAccountsResponseStruct = exports.DiscoverAccountsRequestStruct = exports.SetSelectedAccountsResponseStruct = exports.SetSelectedAccountsRequestStruct = exports.CreateAccountResponseStruct = exports.CreateAccountRequestStruct = exports.GetAccountResponseStruct = exports.GetAccountRequestStruct = exports.ListAccountsResponseStruct = exports.ListAccountsRequestStruct = exports.KeyringRpcMethod = void 0;
exports.isKeyringRpcMethod = isKeyringRpcMethod;
const keyring_utils_1 = require("@metamask/keyring-utils");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const api_1 = require("./api/index.cjs");
/**
 * Keyring RPC methods used by the API.
 */
var KeyringRpcMethod;
(function (KeyringRpcMethod) {
    KeyringRpcMethod["ListAccounts"] = "keyring_listAccounts";
    KeyringRpcMethod["GetAccount"] = "keyring_getAccount";
    KeyringRpcMethod["CreateAccount"] = "keyring_createAccount";
    KeyringRpcMethod["DiscoverAccounts"] = "keyring_discoverAccounts";
    KeyringRpcMethod["ListAccountAssets"] = "keyring_listAccountAssets";
    KeyringRpcMethod["ListAccountTransactions"] = "keyring_listAccountTransactions";
    KeyringRpcMethod["GetAccountBalances"] = "keyring_getAccountBalances";
    KeyringRpcMethod["ResolveAccountAddress"] = "keyring_resolveAccountAddress";
    KeyringRpcMethod["FilterAccountChains"] = "keyring_filterAccountChains";
    KeyringRpcMethod["UpdateAccount"] = "keyring_updateAccount";
    KeyringRpcMethod["DeleteAccount"] = "keyring_deleteAccount";
    KeyringRpcMethod["ExportAccount"] = "keyring_exportAccount";
    KeyringRpcMethod["ListRequests"] = "keyring_listRequests";
    KeyringRpcMethod["GetRequest"] = "keyring_getRequest";
    KeyringRpcMethod["SubmitRequest"] = "keyring_submitRequest";
    KeyringRpcMethod["ApproveRequest"] = "keyring_approveRequest";
    KeyringRpcMethod["RejectRequest"] = "keyring_rejectRequest";
    KeyringRpcMethod["SetSelectedAccounts"] = "keyring_setSelectedAccounts";
})(KeyringRpcMethod || (exports.KeyringRpcMethod = KeyringRpcMethod = {}));
/**
 * Check if a method is a keyring RPC method.
 *
 * @param method - Method to check.
 * @returns Whether the method is a keyring RPC method.
 */
function isKeyringRpcMethod(method) {
    return Object.values(KeyringRpcMethod).includes(method);
}
// ----------------------------------------------------------------------------
const CommonHeader = {
    jsonrpc: (0, superstruct_1.literal)('2.0'),
    id: (0, superstruct_1.union)([(0, superstruct_1.string)(), (0, superstruct_1.number)(), (0, superstruct_1.literal)(null)]),
};
// ----------------------------------------------------------------------------
// List accounts
exports.ListAccountsRequestStruct = (0, keyring_utils_1.object)({
    ...CommonHeader,
    method: (0, superstruct_1.literal)('keyring_listAccounts'),
});
exports.ListAccountsResponseStruct = (0, superstruct_1.array)(api_1.KeyringAccountStruct);
// ----------------------------------------------------------------------------
// Get account
exports.GetAccountRequestStruct = (0, keyring_utils_1.object)({
    ...CommonHeader,
    method: (0, superstruct_1.literal)('keyring_getAccount'),
    params: (0, keyring_utils_1.object)({
        id: keyring_utils_1.UuidStruct,
    }),
});
exports.GetAccountResponseStruct = api_1.KeyringAccountStruct;
// ----------------------------------------------------------------------------
// Create account
exports.CreateAccountRequestStruct = (0, keyring_utils_1.object)({
    ...CommonHeader,
    method: (0, superstruct_1.literal)('keyring_createAccount'),
    params: (0, keyring_utils_1.object)({
        options: (0, superstruct_1.record)((0, superstruct_1.string)(), utils_1.JsonStruct),
    }),
});
exports.CreateAccountResponseStruct = api_1.KeyringAccountStruct;
// ----------------------------------------------------------------------------
// Set selected accounts
exports.SetSelectedAccountsRequestStruct = (0, keyring_utils_1.object)({
    ...CommonHeader,
    method: (0, superstruct_1.literal)('keyring_setSelectedAccounts'),
    params: (0, keyring_utils_1.object)({
        accounts: (0, superstruct_1.array)((0, superstruct_1.string)()),
    }),
});
exports.SetSelectedAccountsResponseStruct = (0, superstruct_1.literal)(null);
// ----------------------------------------------------------------------------
// Discover accounts
exports.DiscoverAccountsRequestStruct = (0, keyring_utils_1.object)({
    ...CommonHeader,
    method: (0, superstruct_1.literal)('keyring_discoverAccounts'),
    params: (0, keyring_utils_1.object)({
        scopes: (0, superstruct_1.array)(api_1.CaipChainIdStruct),
        entropySource: (0, superstruct_1.string)(),
        groupIndex: (0, superstruct_1.number)(),
    }),
});
exports.DiscoverAccountsResponseStruct = (0, superstruct_1.array)(api_1.DiscoveredAccountStruct);
// ----------------------------------------------------------------------------
// List account transactions
exports.ListAccountTransactionsRequestStruct = (0, keyring_utils_1.object)({
    ...CommonHeader,
    method: (0, superstruct_1.literal)('keyring_listAccountTransactions'),
    params: (0, keyring_utils_1.object)({
        id: keyring_utils_1.UuidStruct,
        pagination: api_1.PaginationStruct,
    }),
});
exports.ListAccountTransactionsResponseStruct = api_1.TransactionsPageStruct;
// ----------------------------------------------------------------------------
// List account assets
exports.ListAccountAssetsRequestStruct = (0, keyring_utils_1.object)({
    ...CommonHeader,
    method: (0, superstruct_1.literal)('keyring_listAccountAssets'),
    params: (0, keyring_utils_1.object)({
        id: keyring_utils_1.UuidStruct,
    }),
});
exports.ListAccountAssetsResponseStruct = (0, superstruct_1.array)(api_1.CaipAssetTypeOrIdStruct);
// ----------------------------------------------------------------------------
// Get account balances
exports.GetAccountBalancesRequestStruct = (0, keyring_utils_1.object)({
    ...CommonHeader,
    method: (0, superstruct_1.literal)(`${KeyringRpcMethod.GetAccountBalances}`),
    params: (0, keyring_utils_1.object)({
        id: keyring_utils_1.UuidStruct,
        assets: (0, superstruct_1.array)(api_1.CaipAssetTypeStruct),
    }),
});
exports.GetAccountBalancesResponseStruct = (0, superstruct_1.record)(api_1.CaipAssetTypeStruct, api_1.BalanceStruct);
// ----------------------------------------------------------------------------
// Resolve account address
exports.ResolveAccountAddressRequestStruct = (0, keyring_utils_1.object)({
    ...CommonHeader,
    method: (0, superstruct_1.literal)('keyring_resolveAccountAddress'),
    params: (0, keyring_utils_1.object)({
        scope: api_1.CaipChainIdStruct,
        request: keyring_utils_1.JsonRpcRequestStruct,
    }),
});
exports.ResolveAccountAddressResponseStruct = (0, superstruct_1.nullable)((0, keyring_utils_1.object)({
    address: api_1.CaipAccountIdStruct,
}));
// ----------------------------------------------------------------------------
// Filter account chains
exports.FilterAccountChainsStruct = (0, keyring_utils_1.object)({
    ...CommonHeader,
    method: (0, superstruct_1.literal)('keyring_filterAccountChains'),
    params: (0, keyring_utils_1.object)({
        id: keyring_utils_1.UuidStruct,
        chains: (0, superstruct_1.array)((0, superstruct_1.string)()),
    }),
});
exports.FilterAccountChainsResponseStruct = (0, superstruct_1.array)((0, superstruct_1.string)());
// ----------------------------------------------------------------------------
// Update account
exports.UpdateAccountRequestStruct = (0, keyring_utils_1.object)({
    ...CommonHeader,
    method: (0, superstruct_1.literal)('keyring_updateAccount'),
    params: (0, keyring_utils_1.object)({
        account: api_1.KeyringAccountStruct,
    }),
});
exports.UpdateAccountResponseStruct = (0, superstruct_1.literal)(null);
// ----------------------------------------------------------------------------
// Delete account
exports.DeleteAccountRequestStruct = (0, keyring_utils_1.object)({
    ...CommonHeader,
    method: (0, superstruct_1.literal)('keyring_deleteAccount'),
    params: (0, keyring_utils_1.object)({
        id: keyring_utils_1.UuidStruct,
    }),
});
exports.DeleteAccountResponseStruct = (0, superstruct_1.literal)(null);
// ----------------------------------------------------------------------------
// Export account
exports.ExportAccountRequestStruct = (0, keyring_utils_1.object)({
    ...CommonHeader,
    method: (0, superstruct_1.literal)('keyring_exportAccount'),
    params: (0, keyring_utils_1.object)({
        id: keyring_utils_1.UuidStruct,
    }),
});
exports.ExportAccountResponseStruct = api_1.KeyringAccountDataStruct;
// ----------------------------------------------------------------------------
// List requests
exports.ListRequestsRequestStruct = (0, keyring_utils_1.object)({
    ...CommonHeader,
    method: (0, superstruct_1.literal)('keyring_listRequests'),
});
exports.ListRequestsResponseStruct = (0, superstruct_1.array)(api_1.KeyringRequestStruct);
// ----------------------------------------------------------------------------
// Get request
exports.GetRequestRequestStruct = (0, keyring_utils_1.object)({
    ...CommonHeader,
    method: (0, superstruct_1.literal)('keyring_getRequest'),
    params: (0, keyring_utils_1.object)({
        id: keyring_utils_1.UuidStruct,
    }),
});
exports.GetRequestResponseStruct = api_1.KeyringRequestStruct;
// ----------------------------------------------------------------------------
// Submit request
exports.SubmitRequestRequestStruct = (0, keyring_utils_1.object)({
    ...CommonHeader,
    method: (0, superstruct_1.literal)('keyring_submitRequest'),
    params: api_1.KeyringRequestStruct,
});
exports.SubmitRequestResponseStruct = api_1.KeyringResponseStruct;
// ----------------------------------------------------------------------------
// Approve request
exports.ApproveRequestRequestStruct = (0, keyring_utils_1.object)({
    ...CommonHeader,
    method: (0, superstruct_1.literal)('keyring_approveRequest'),
    params: (0, keyring_utils_1.object)({
        id: keyring_utils_1.UuidStruct,
        data: (0, superstruct_1.record)((0, superstruct_1.string)(), utils_1.JsonStruct),
    }),
});
exports.ApproveRequestResponseStruct = (0, superstruct_1.literal)(null);
// ----------------------------------------------------------------------------
// Reject request
exports.RejectRequestRequestStruct = (0, keyring_utils_1.object)({
    ...CommonHeader,
    method: (0, superstruct_1.literal)('keyring_rejectRequest'),
    params: (0, keyring_utils_1.object)({
        id: keyring_utils_1.UuidStruct,
    }),
});
exports.RejectRequestResponseStruct = (0, superstruct_1.literal)(null);

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\rpc.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\sol\\constants.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Csol%5Cconstants.cjs
      return function (require, module, exports) {
"use strict";
// istanbul ignore file
Object.defineProperty(exports, "__esModule", { value: true });
exports.SolScope = void 0;
/**
 * Scopes for Solana account type. See {@link KeyringAccount.scopes}.
 */
var SolScope;
(function (SolScope) {
    SolScope["Devnet"] = "solana:EtWTRABZaYq6iMfeYKouRu166VU2xqa1";
    SolScope["Mainnet"] = "solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp";
    SolScope["Testnet"] = "solana:4uhcVJyU9pJkvQyS88uRDiswHXSCkY3z";
})(SolScope || (exports.SolScope = SolScope = {}));

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\sol\\constants.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\sol\\index.cjs", {"./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\sol\\constants.cjs","./types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\sol\\types.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Csol%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./constants.cjs"), exports);
__exportStar(require("./types.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\sol\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\sol\\types.cjs", {"../api/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\index.cjs","@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Csol%5Ctypes.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SolDataAccountStruct = exports.SolMethod = exports.SolAddressStruct = void 0;
const keyring_utils_1 = require("@metamask/keyring-utils");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const api_1 = require("../api/index.cjs");
/**
 * Solana addresses are represented in the format of a 256-bit ed25519 public key and
 * are encoded using base58.
 * They are usually 32 to 44 characters long.
 */
exports.SolAddressStruct = (0, utils_1.definePattern)('SolAddress', /^[1-9A-HJ-NP-Za-km-z]{32,44}$/iu);
/**
 * Supported Solana methods.
 */
var SolMethod;
(function (SolMethod) {
    // General transaction methods
    // @deprecated
    // TODO: Remove this once the new methods are fully adopted
    SolMethod["SendAndConfirmTransaction"] = "sendAndConfirmTransaction";
    SolMethod["SignAndSendTransaction"] = "signAndSendTransaction";
    SolMethod["SignTransaction"] = "signTransaction";
    SolMethod["SignMessage"] = "signMessage";
    SolMethod["SignIn"] = "signIn";
})(SolMethod || (exports.SolMethod = SolMethod = {}));
exports.SolDataAccountStruct = (0, keyring_utils_1.object)({
    ...api_1.KeyringAccountStruct.schema,
    /**
     * Account address.
     */
    address: exports.SolAddressStruct,
    /**
     * Account type.
     */
    type: (0, superstruct_1.literal)(`${api_1.SolAccountType.DataAccount}`),
    /**
     * Account supported scopes (CAIP-2 chain IDs).
     */
    scopes: (0, superstruct_1.nonempty)((0, superstruct_1.array)(api_1.CaipChainIdStruct)),
    /**
     * Account supported methods.
     */
    methods: (0, superstruct_1.array)((0, superstruct_1.enums)(Object.values(SolMethod))),
});

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\sol\\types.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\trx\\constants.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Ctrx%5Cconstants.cjs
      return function (require, module, exports) {
"use strict";
// istanbul ignore file
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrxScope = void 0;
/**
 * Scopes for TRON account type. See {@link KeyringAccount.scopes}.
 */
var TrxScope;
(function (TrxScope) {
    TrxScope["Mainnet"] = "tron:728126428";
    TrxScope["Nile"] = "tron:3448148188";
    TrxScope["Shasta"] = "tron:2494104990";
})(TrxScope || (exports.TrxScope = TrxScope = {}));

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\trx\\constants.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\trx\\index.cjs", {"./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\trx\\constants.cjs","./types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\trx\\types.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Ctrx%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./constants.cjs"), exports);
__exportStar(require("./types.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\trx\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\trx\\types.cjs", {"../api/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\api\\index.cjs","@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Ctrx%5Ctypes.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrxEoaAccountStruct = exports.TrxMethod = exports.TrxAddressStruct = void 0;
const keyring_utils_1 = require("@metamask/keyring-utils");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const api_1 = require("../api/index.cjs");
/**
 * TRON addresses are Base58-encoded strings that are exactly 34 characters long
 * and start with the letter 'T'.
 */
exports.TrxAddressStruct = (0, utils_1.definePattern)('TrxAddress', /^T[1-9A-HJ-NP-Za-km-z]{33}$/iu);
/**
 * Supported TRON methods.
 */
var TrxMethod;
(function (TrxMethod) {
    TrxMethod["SignMessageV2"] = "signMessageV2";
    TrxMethod["VerifyMessageV2"] = "verifyMessageV2";
})(TrxMethod || (exports.TrxMethod = TrxMethod = {}));
exports.TrxEoaAccountStruct = (0, keyring_utils_1.object)({
    ...api_1.KeyringAccountStruct.schema,
    /**
     * Account address.
     */
    address: exports.TrxAddressStruct,
    /**
     * Account type.
     */
    type: (0, superstruct_1.literal)(`${api_1.TrxAccountType.Eoa}`),
    /**
     * Account supported scopes (CAIP-2 chain IDs).
     */
    scopes: (0, superstruct_1.nonempty)((0, superstruct_1.array)(api_1.CaipChainIdStruct)),
    /**
     * Account supported methods.
     */
    methods: (0, superstruct_1.array)((0, superstruct_1.enums)(Object.values(TrxMethod))),
});

      };
    };
  }
  }
}, {package:"@metamask/keyring-api",file:"node_modules\\@metamask\\keyring-api\\dist\\trx\\types.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\KeyringController.cjs", {"./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\constants.cjs","@ethereumjs/util":"D:\\code\\v\\metamask-extension\\node_modules\\@ethereumjs\\util\\dist\\cjs\\index.js","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/browser-passworder":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\browser-passworder\\dist\\index.js","@metamask/eth-hd-keyring":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-hd-keyring\\dist\\index.cjs","@metamask/eth-sig-util":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-sig-util\\dist\\index.js","@metamask/eth-simple-keyring":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-simple-keyring\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","async-mutex":"D:\\code\\v\\metamask-extension\\node_modules\\async-mutex\\lib\\index.js","ethereumjs-wallet":"D:\\code\\v\\metamask-extension\\node_modules\\ethereumjs-wallet\\dist.browser\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js","ulid":"D:\\code\\v\\metamask-extension\\node_modules\\ulid\\dist\\index.umd.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-controller%5Cdist%5CKeyringController.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _KeyringController_instances, _KeyringController_controllerOperationMutex, _KeyringController_vaultOperationMutex, _KeyringController_keyringBuilders, _KeyringController_encryptor, _KeyringController_cacheEncryptionKey, _KeyringController_keyrings, _KeyringController_unsupportedKeyrings, _KeyringController_password, _KeyringController_registerMessageHandlers, _KeyringController_getKeyringById, _KeyringController_getKeyringByIdOrDefault, _KeyringController_getKeyringMetadata, _KeyringController_getKeyringBuilderForType, _KeyringController_createNewVaultWithKeyring, _KeyringController_verifySeedPhrase, _KeyringController_getUpdatedKeyrings, _KeyringController_getSerializedKeyrings, _KeyringController_getSessionState, _KeyringController_restoreSerializedKeyrings, _KeyringController_unlockKeyrings, _KeyringController_updateVault, _KeyringController_isNewEncryptionAvailable, _KeyringController_getAccountsFromKeyrings, _KeyringController_createKeyringWithFirstAccount, _KeyringController_newKeyring, _KeyringController_createKeyring, _KeyringController_clearKeyrings, _KeyringController_restoreKeyring, _KeyringController_destroyKeyring, _KeyringController_removeEmptyKeyrings, _KeyringController_assertNoDuplicateAccounts, _KeyringController_setUnlocked, _KeyringController_assertIsUnlocked, _KeyringController_persistOrRollback, _KeyringController_withRollback, _KeyringController_assertControllerMutexIsLocked, _KeyringController_withControllerLock, _KeyringController_withVaultLock;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeyringController = exports.getDefaultKeyringState = exports.keyringBuilderFactory = exports.SignTypedDataVersion = exports.AccountImportStrategy = exports.isCustodyKeyring = exports.KeyringTypes = void 0;
const util_1 = require("@ethereumjs/util");
const base_controller_1 = require("@metamask/base-controller");
const encryptorUtils = __importStar(require("@metamask/browser-passworder"));
const eth_hd_keyring_1 = require("@metamask/eth-hd-keyring");
const eth_sig_util_1 = require("@metamask/eth-sig-util");
const eth_simple_keyring_1 = __importDefault(require("@metamask/eth-simple-keyring"));
const utils_1 = require("@metamask/utils");
const async_mutex_1 = require("async-mutex");
const ethereumjs_wallet_1 = __importStar(require("ethereumjs-wallet"));
const lodash_1 = require("lodash");
// When generating a ULID within the same millisecond, monotonicFactory provides some guarantees regarding sort order.
const ulid_1 = require("ulid");
const constants_1 = require("./constants.cjs");
const name = 'KeyringController';
/**
 * Available keyring types
 */
var KeyringTypes;
(function (KeyringTypes) {
    KeyringTypes["simple"] = "Simple Key Pair";
    KeyringTypes["hd"] = "HD Key Tree";
    KeyringTypes["qr"] = "QR Hardware Wallet Device";
    KeyringTypes["trezor"] = "Trezor Hardware";
    KeyringTypes["oneKey"] = "OneKey Hardware";
    KeyringTypes["ledger"] = "Ledger Hardware";
    KeyringTypes["lattice"] = "Lattice Hardware";
    KeyringTypes["snap"] = "Snap Keyring";
})(KeyringTypes || (exports.KeyringTypes = KeyringTypes = {}));
/**
 * Custody keyring types are a special case, as they are not a single type
 * but they all start with the prefix "Custody".
 *
 * @param keyringType - The type of the keyring.
 * @returns Whether the keyring type is a custody keyring.
 */
const isCustodyKeyring = (keyringType) => {
    return keyringType.startsWith('Custody');
};
exports.isCustodyKeyring = isCustodyKeyring;
/**
 * A strategy for importing an account
 */
var AccountImportStrategy;
(function (AccountImportStrategy) {
    AccountImportStrategy["privateKey"] = "privateKey";
    AccountImportStrategy["json"] = "json";
})(AccountImportStrategy || (exports.AccountImportStrategy = AccountImportStrategy = {}));
/**
 * The `signTypedMessage` version
 *
 * @see https://docs.metamask.io/guide/signing-data.html
 */
var SignTypedDataVersion;
(function (SignTypedDataVersion) {
    SignTypedDataVersion["V1"] = "V1";
    SignTypedDataVersion["V3"] = "V3";
    SignTypedDataVersion["V4"] = "V4";
})(SignTypedDataVersion || (exports.SignTypedDataVersion = SignTypedDataVersion = {}));
/**
 * Get builder function for `Keyring`
 *
 * Returns a builder function for `Keyring` with a `type` property.
 *
 * @param KeyringConstructor - The Keyring class for the builder.
 * @returns A builder function for the given Keyring.
 */
function keyringBuilderFactory(KeyringConstructor) {
    const builder = () => new KeyringConstructor();
    builder.type = KeyringConstructor.type;
    return builder;
}
exports.keyringBuilderFactory = keyringBuilderFactory;
const defaultKeyringBuilders = [
    // todo: keyring types are mismatched, this should be fixed in they keyrings themselves
    // @ts-expect-error keyring types are mismatched
    keyringBuilderFactory(eth_simple_keyring_1.default),
    keyringBuilderFactory(eth_hd_keyring_1.HdKeyring),
];
const getDefaultKeyringState = () => {
    return {
        isUnlocked: false,
        keyrings: [],
    };
};
exports.getDefaultKeyringState = getDefaultKeyringState;
/**
 * Assert that the given keyring has an exportable
 * mnemonic.
 *
 * @param keyring - The keyring to check
 * @throws When the keyring does not have a mnemonic
 */
function assertHasUint8ArrayMnemonic(keyring) {
    if (!((0, utils_1.hasProperty)(keyring, 'mnemonic') && keyring.mnemonic instanceof Uint8Array)) {
        throw new Error("Can't get mnemonic bytes from keyring");
    }
}
/**
 * Assert that the provided encryptor supports
 * encryption and encryption key export.
 *
 * @param encryptor - The encryptor to check.
 * @throws If the encryptor does not support key encryption.
 */
function assertIsExportableKeyEncryptor(encryptor) {
    if (!('importKey' in encryptor &&
        typeof encryptor.importKey === 'function' &&
        'decryptWithKey' in encryptor &&
        typeof encryptor.decryptWithKey === 'function' &&
        'encryptWithKey' in encryptor &&
        typeof encryptor.encryptWithKey === 'function')) {
        throw new Error(constants_1.KeyringControllerError.UnsupportedEncryptionKeyExport);
    }
}
/**
 * Assert that the provided password is a valid non-empty string.
 *
 * @param password - The password to check.
 * @throws If the password is not a valid string.
 */
function assertIsValidPassword(password) {
    if (typeof password !== 'string') {
        throw new Error(constants_1.KeyringControllerError.WrongPasswordType);
    }
    if (!password || !password.length) {
        throw new Error(constants_1.KeyringControllerError.InvalidEmptyPassword);
    }
}
/**
 * Assert that the provided encryption key is a valid non-empty string.
 *
 * @param encryptionKey - The encryption key to check.
 * @throws If the encryption key is not a valid string.
 */
function assertIsEncryptionKeySet(encryptionKey) {
    if (!encryptionKey) {
        throw new Error(constants_1.KeyringControllerError.EncryptionKeyNotSet);
    }
}
/**
 * Checks if the provided value is a serialized keyrings array.
 *
 * @param array - The value to check.
 * @returns True if the value is a serialized keyrings array.
 */
function isSerializedKeyringsArray(array) {
    return (typeof array === 'object' &&
        Array.isArray(array) &&
        array.every((value) => value.type && (0, utils_1.isValidJson)(value.data)));
}
/**
 * Display For Keyring
 *
 * Is used for adding the current keyrings to the state object.
 *
 * @param keyringWithMetadata - The keyring and its metadata.
 * @param keyringWithMetadata.keyring - The keyring to display.
 * @param keyringWithMetadata.metadata - The metadata of the keyring.
 * @returns A keyring display object, with type and accounts properties.
 */
async function displayForKeyring({ keyring, metadata, }) {
    const accounts = await keyring.getAccounts();
    return {
        type: keyring.type,
        // Cast to `string[]` here is safe here because `accounts` has no nullish
        // values, and `normalize` returns `string` unless given a nullish value
        accounts: accounts.map(normalize),
        metadata,
    };
}
/**
 * Check if address is an ethereum address
 *
 * @param address - An address.
 * @returns Returns true if the address is an ethereum one, false otherwise.
 */
function isEthAddress(address) {
    // We first check if it's a matching `Hex` string, so that is narrows down
    // `address` as an `Hex` type, allowing us to use `isValidHexAddress`
    return (
    // NOTE: This function only checks for lowercased strings
    (0, utils_1.isStrictHexString)(address.toLowerCase()) &&
        // This checks for lowercased addresses and checksum addresses too
        (0, utils_1.isValidHexAddress)(address));
}
/**
 * Normalize ethereum or non-EVM address.
 *
 * @param address - Ethereum or non-EVM address.
 * @returns The normalized address.
 */
function normalize(address) {
    // Since the `KeyringController` is only dealing with address, we have
    // no other way to get the associated account type with this address. So we
    // are down to check the actual address format for now
    // TODO: Find a better way to not have those runtime checks based on the
    //       address value!
    return isEthAddress(address) ? (0, eth_sig_util_1.normalize)(address) : address;
}
/**
 * Controller responsible for establishing and managing user identity.
 *
 * This class is a wrapper around the `eth-keyring-controller` package. The
 * `eth-keyring-controller` manages the "vault", which is an encrypted store of private keys, and
 * it manages the wallet "lock" state. This wrapper class has convenience methods for interacting
 * with the internal keyring controller and handling certain complex operations that involve the
 * keyrings.
 */
class KeyringController extends base_controller_1.BaseController {
    /**
     * Creates a KeyringController instance.
     *
     * @param options - Initial options used to configure this controller
     * @param options.encryptor - An optional object for defining encryption schemes.
     * @param options.keyringBuilders - Set a new name for account.
     * @param options.cacheEncryptionKey - Whether to cache or not encryption key.
     * @param options.messenger - A restricted messenger.
     * @param options.state - Initial state to set on this controller.
     */
    constructor(options) {
        const { encryptor = encryptorUtils, keyringBuilders, messenger, state, } = options;
        super({
            name,
            metadata: {
                vault: {
                    includeInStateLogs: false,
                    persist: true,
                    anonymous: false,
                    usedInUi: false,
                },
                isUnlocked: {
                    includeInStateLogs: true,
                    persist: false,
                    anonymous: true,
                    usedInUi: true,
                },
                keyrings: {
                    includeInStateLogs: true,
                    persist: false,
                    anonymous: false,
                    usedInUi: true,
                },
                encryptionKey: {
                    includeInStateLogs: false,
                    persist: false,
                    anonymous: false,
                    usedInUi: false,
                },
                encryptionSalt: {
                    includeInStateLogs: false,
                    persist: false,
                    anonymous: false,
                    usedInUi: false,
                },
            },
            messenger,
            state: {
                ...(0, exports.getDefaultKeyringState)(),
                ...state,
            },
        });
        _KeyringController_instances.add(this);
        _KeyringController_controllerOperationMutex.set(this, new async_mutex_1.Mutex());
        _KeyringController_vaultOperationMutex.set(this, new async_mutex_1.Mutex());
        _KeyringController_keyringBuilders.set(this, void 0);
        _KeyringController_encryptor.set(this, void 0);
        _KeyringController_cacheEncryptionKey.set(this, void 0);
        _KeyringController_keyrings.set(this, void 0);
        _KeyringController_unsupportedKeyrings.set(this, void 0);
        _KeyringController_password.set(this, void 0);
        __classPrivateFieldSet(this, _KeyringController_keyringBuilders, keyringBuilders
            ? keyringBuilders.concat(defaultKeyringBuilders)
            : defaultKeyringBuilders, "f");
        __classPrivateFieldSet(this, _KeyringController_encryptor, encryptor, "f");
        __classPrivateFieldSet(this, _KeyringController_keyrings, [], "f");
        __classPrivateFieldSet(this, _KeyringController_unsupportedKeyrings, [], "f");
        // This option allows the controller to cache an exported key
        // for use in decrypting and encrypting data without password
        __classPrivateFieldSet(this, _KeyringController_cacheEncryptionKey, Boolean(options.cacheEncryptionKey), "f");
        if (__classPrivateFieldGet(this, _KeyringController_cacheEncryptionKey, "f")) {
            assertIsExportableKeyEncryptor(encryptor);
        }
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_registerMessageHandlers).call(this);
    }
    /**
     * Adds a new account to the default (first) HD seed phrase keyring.
     *
     * @param accountCount - Number of accounts before adding a new one, used to
     * make the method idempotent.
     * @returns Promise resolving to the added account address.
     */
    async addNewAccount(accountCount) {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        return __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_persistOrRollback).call(this, async () => {
            const primaryKeyring = this.getKeyringsByType('HD Key Tree')[0];
            if (!primaryKeyring) {
                throw new Error('No HD keyring found');
            }
            const oldAccounts = await primaryKeyring.getAccounts();
            if (accountCount && oldAccounts.length !== accountCount) {
                if (accountCount > oldAccounts.length) {
                    throw new Error('Account out of sequence');
                }
                // we return the account already existing at index `accountCount`
                const existingAccount = oldAccounts[accountCount];
                if (!existingAccount) {
                    throw new Error(`Can't find account at index ${accountCount}`);
                }
                return existingAccount;
            }
            const [addedAccountAddress] = await primaryKeyring.addAccounts(1);
            await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_verifySeedPhrase).call(this);
            return addedAccountAddress;
        });
    }
    /**
     * Adds a new account to the specified keyring.
     *
     * @param keyring - Keyring to add the account to.
     * @param accountCount - Number of accounts before adding a new one, used to make the method idempotent.
     * @returns Promise resolving to the added account address
     */
    async addNewAccountForKeyring(keyring, accountCount) {
        // READ THIS CAREFULLY:
        // We still uses `Hex` here, since we are not using this method when creating
        // and account using a "Snap Keyring". This function assume the `keyring` is
        // ethereum compatible, but "Snap Keyring" might not be.
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        return __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_persistOrRollback).call(this, async () => {
            const oldAccounts = await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_getAccountsFromKeyrings).call(this);
            if (accountCount && oldAccounts.length !== accountCount) {
                if (accountCount > oldAccounts.length) {
                    throw new Error('Account out of sequence');
                }
                const existingAccount = oldAccounts[accountCount];
                (0, utils_1.assertIsStrictHexString)(existingAccount);
                return existingAccount;
            }
            await keyring.addAccounts(1);
            const addedAccountAddress = (await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_getAccountsFromKeyrings).call(this)).find((selectedAddress) => !oldAccounts.includes(selectedAddress));
            (0, utils_1.assertIsStrictHexString)(addedAccountAddress);
            return addedAccountAddress;
        });
    }
    /**
     * Effectively the same as creating a new keychain then populating it
     * using the given seed phrase.
     *
     * @param password - Password to unlock keychain.
     * @param seed - A BIP39-compliant seed phrase as Uint8Array,
     * either as a string or an array of UTF-8 bytes that represent the string.
     * @returns Promise resolving when the operation ends successfully.
     */
    async createNewVaultAndRestore(password, seed) {
        return __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_persistOrRollback).call(this, async () => {
            assertIsValidPassword(password);
            await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_createNewVaultWithKeyring).call(this, password, {
                type: KeyringTypes.hd,
                opts: {
                    mnemonic: seed,
                    numberOfAccounts: 1,
                },
            });
        });
    }
    /**
     * Create a new vault and primary keyring.
     *
     * This only works if keyrings are empty. If there is a pre-existing unlocked vault, calling this will have no effect.
     * If there is a pre-existing locked vault, it will be replaced.
     *
     * @param password - Password to unlock the new vault.
     * @returns Promise resolving when the operation ends successfully.
     */
    async createNewVaultAndKeychain(password) {
        return __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_persistOrRollback).call(this, async () => {
            const accounts = await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_getAccountsFromKeyrings).call(this);
            if (!accounts.length) {
                await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_createNewVaultWithKeyring).call(this, password, {
                    type: KeyringTypes.hd,
                });
            }
        });
    }
    /**
     * Adds a new keyring of the given `type`.
     *
     * @param type - Keyring type name.
     * @param opts - Keyring options.
     * @throws If a builder for the given `type` does not exist.
     * @returns Promise resolving to the new keyring metadata.
     */
    async addNewKeyring(type, opts) {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        return __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_getKeyringMetadata).call(this, await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_persistOrRollback).call(this, async () => __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_newKeyring).call(this, type, opts)));
    }
    /**
     * Method to verify a given password validity. Throws an
     * error if the password is invalid.
     *
     * @param password - Password of the keyring.
     */
    async verifyPassword(password) {
        if (!this.state.vault) {
            throw new Error(constants_1.KeyringControllerError.VaultError);
        }
        await __classPrivateFieldGet(this, _KeyringController_encryptor, "f").decrypt(password, this.state.vault);
    }
    /**
     * Returns the status of the vault.
     *
     * @returns Boolean returning true if the vault is unlocked.
     */
    isUnlocked() {
        return this.state.isUnlocked;
    }
    /**
     * Gets the seed phrase of the HD keyring.
     *
     * @param password - Password of the keyring.
     * @param keyringId - The id of the keyring.
     * @returns Promise resolving to the seed phrase.
     */
    async exportSeedPhrase(password, keyringId) {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        await this.verifyPassword(password);
        const selectedKeyring = __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_getKeyringByIdOrDefault).call(this, keyringId);
        if (!selectedKeyring) {
            throw new Error('Keyring not found');
        }
        assertHasUint8ArrayMnemonic(selectedKeyring);
        return selectedKeyring.mnemonic;
    }
    /**
     * Gets the private key from the keyring controlling an address.
     *
     * @param password - Password of the keyring.
     * @param address - Address to export.
     * @returns Promise resolving to the private key for an address.
     */
    async exportAccount(password, address) {
        await this.verifyPassword(password);
        const keyring = (await this.getKeyringForAccount(address));
        if (!keyring.exportAccount) {
            throw new Error(constants_1.KeyringControllerError.UnsupportedExportAccount);
        }
        return await keyring.exportAccount(normalize(address));
    }
    /**
     * Returns the public addresses of all accounts from every keyring.
     *
     * @returns A promise resolving to an array of addresses.
     */
    async getAccounts() {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        return this.state.keyrings.reduce((accounts, keyring) => accounts.concat(keyring.accounts), []);
    }
    /**
     * Get encryption public key.
     *
     * @param account - An account address.
     * @param opts - Additional encryption options.
     * @throws If the `account` does not exist or does not support the `getEncryptionPublicKey` method
     * @returns Promise resolving to encyption public key of the `account` if one exists.
     */
    async getEncryptionPublicKey(account, opts) {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        const address = (0, eth_sig_util_1.normalize)(account);
        const keyring = (await this.getKeyringForAccount(account));
        if (!keyring.getEncryptionPublicKey) {
            throw new Error(constants_1.KeyringControllerError.UnsupportedGetEncryptionPublicKey);
        }
        return await keyring.getEncryptionPublicKey(address, opts);
    }
    /**
     * Attempts to decrypt the provided message parameters.
     *
     * @param messageParams - The decryption message parameters.
     * @param messageParams.from - The address of the account you want to use to decrypt the message.
     * @param messageParams.data - The encrypted data that you want to decrypt.
     * @returns The raw decryption result.
     */
    async decryptMessage(messageParams) {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        const address = (0, eth_sig_util_1.normalize)(messageParams.from);
        const keyring = (await this.getKeyringForAccount(address));
        if (!keyring.decryptMessage) {
            throw new Error(constants_1.KeyringControllerError.UnsupportedDecryptMessage);
        }
        return keyring.decryptMessage(address, messageParams.data);
    }
    /**
     * Returns the currently initialized keyring that manages
     * the specified `address` if one exists.
     *
     * @deprecated Use of this method is discouraged as actions executed directly on
     * keyrings are not being reflected in the KeyringController state and not
     * persisted in the vault. Use `withKeyring` instead.
     * @param account - An account address.
     * @returns Promise resolving to keyring of the `account` if one exists.
     */
    async getKeyringForAccount(account) {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        const address = normalize(account);
        const candidates = await Promise.all(__classPrivateFieldGet(this, _KeyringController_keyrings, "f").map(async ({ keyring }) => {
            return Promise.all([keyring, keyring.getAccounts()]);
        }));
        const winners = candidates.filter((candidate) => {
            const accounts = candidate[1].map(normalize);
            return accounts.includes(address);
        });
        if (winners.length && winners[0]?.length) {
            return winners[0][0];
        }
        // Adding more info to the error
        let errorInfo = '';
        if (!candidates.length) {
            errorInfo = 'There are no keyrings';
        }
        else if (!winners.length) {
            errorInfo = 'There are keyrings, but none match the address';
        }
        throw new Error(`${constants_1.KeyringControllerError.NoKeyring}. Error info: ${errorInfo}`);
    }
    /**
     * Returns all keyrings of the given type.
     *
     * @deprecated Use of this method is discouraged as actions executed directly on
     * keyrings are not being reflected in the KeyringController state and not
     * persisted in the vault. Use `withKeyring` instead.
     * @param type - Keyring type name.
     * @returns An array of keyrings of the given type.
     */
    getKeyringsByType(type) {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        return __classPrivateFieldGet(this, _KeyringController_keyrings, "f")
            .filter(({ keyring }) => keyring.type === type)
            .map(({ keyring }) => keyring);
    }
    /**
     * Persist all serialized keyrings in the vault.
     *
     * @deprecated This method is being phased out in favor of `withKeyring`.
     * @returns Promise resolving with `true` value when the
     * operation completes.
     */
    async persistAllKeyrings() {
        return __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_withRollback).call(this, async () => {
            __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
            await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_updateVault).call(this);
            return true;
        });
    }
    /**
     * Imports an account with the specified import strategy.
     *
     * @param strategy - Import strategy name.
     * @param args - Array of arguments to pass to the underlying stategy.
     * @throws Will throw when passed an unrecognized strategy.
     * @returns Promise resolving to the imported account address.
     */
    async importAccountWithStrategy(strategy, 
    // TODO: Replace `any` with type
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    args) {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        return __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_persistOrRollback).call(this, async () => {
            let privateKey;
            switch (strategy) {
                case AccountImportStrategy.privateKey:
                    const [importedKey] = args;
                    if (!importedKey) {
                        throw new Error('Cannot import an empty key.');
                    }
                    const prefixed = (0, utils_1.add0x)(importedKey);
                    let bufferedPrivateKey;
                    try {
                        bufferedPrivateKey = (0, utils_1.hexToBytes)(prefixed);
                    }
                    catch {
                        throw new Error('Cannot import invalid private key.');
                    }
                    if (!(0, util_1.isValidPrivate)(bufferedPrivateKey) ||
                        // ensures that the key is 64 bytes long
                        (0, util_1.getBinarySize)(prefixed) !== 64 + '0x'.length) {
                        throw new Error('Cannot import invalid private key.');
                    }
                    privateKey = (0, utils_1.remove0x)(prefixed);
                    break;
                case AccountImportStrategy.json:
                    let wallet;
                    const [input, password] = args;
                    try {
                        wallet = ethereumjs_wallet_1.thirdparty.fromEtherWallet(input, password);
                    }
                    catch (e) {
                        wallet = wallet || (await ethereumjs_wallet_1.default.fromV3(input, password, true));
                    }
                    privateKey = (0, utils_1.bytesToHex)(wallet.getPrivateKey());
                    break;
                default:
                    throw new Error(`Unexpected import strategy: '${String(strategy)}'`);
            }
            const newKeyring = (await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_newKeyring).call(this, KeyringTypes.simple, [
                privateKey,
            ]));
            const accounts = await newKeyring.getAccounts();
            return accounts[0];
        });
    }
    /**
     * Removes an account from keyring state.
     *
     * @param address - Address of the account to remove.
     * @fires KeyringController:accountRemoved
     * @returns Promise resolving when the account is removed.
     */
    async removeAccount(address) {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_persistOrRollback).call(this, async () => {
            const keyring = (await this.getKeyringForAccount(address));
            const keyringIndex = this.state.keyrings.findIndex((kr) => kr.accounts.includes(address));
            const isPrimaryKeyring = keyringIndex === 0;
            const shouldRemoveKeyring = (await keyring.getAccounts()).length === 1;
            // Primary keyring should never be removed, so we need to keep at least one account in it
            if (isPrimaryKeyring && shouldRemoveKeyring) {
                throw new Error(constants_1.KeyringControllerError.LastAccountInPrimaryKeyring);
            }
            // Not all the keyrings support this, so we have to check
            if (!keyring.removeAccount) {
                throw new Error(constants_1.KeyringControllerError.UnsupportedRemoveAccount);
            }
            // The `removeAccount` method of snaps keyring is async. We have to update
            // the interface of the other keyrings to be async as well.
            // FIXME: We do cast to `Hex` to makes the type checker happy here, and
            // because `Keyring<State>.removeAccount` requires address to be `Hex`. Those
            // type would need to be updated for a full non-EVM support.
            keyring.removeAccount(address);
            if (shouldRemoveKeyring) {
                await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_removeEmptyKeyrings).call(this);
            }
        });
        this.messagingSystem.publish(`${name}:accountRemoved`, address);
    }
    /**
     * Deallocates all secrets and locks the wallet.
     *
     * @returns Promise resolving when the operation completes.
     */
    async setLocked() {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        return __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_withRollback).call(this, async () => {
            __classPrivateFieldSet(this, _KeyringController_password, undefined, "f");
            await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_clearKeyrings).call(this);
            this.update((state) => {
                state.isUnlocked = false;
                state.keyrings = [];
                delete state.encryptionKey;
                delete state.encryptionSalt;
            });
            this.messagingSystem.publish(`${name}:lock`);
        });
    }
    /**
     * Signs message by calling down into a specific keyring.
     *
     * @param messageParams - PersonalMessageParams object to sign.
     * @returns Promise resolving to a signed message string.
     */
    async signMessage(messageParams) {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        if (!messageParams.data) {
            throw new Error("Can't sign an empty message");
        }
        const address = (0, eth_sig_util_1.normalize)(messageParams.from);
        const keyring = (await this.getKeyringForAccount(address));
        if (!keyring.signMessage) {
            throw new Error(constants_1.KeyringControllerError.UnsupportedSignMessage);
        }
        return await keyring.signMessage(address, messageParams.data);
    }
    /**
     * Signs EIP-7702 Authorization message by calling down into a specific keyring.
     *
     * @param params - EIP7702AuthorizationParams object to sign.
     * @returns Promise resolving to an EIP-7702 Authorization signature.
     * @throws Will throw UnsupportedSignEIP7702Authorization if the keyring does not support signing EIP-7702 Authorization messages.
     */
    async signEip7702Authorization(params) {
        const from = (0, eth_sig_util_1.normalize)(params.from);
        const keyring = (await this.getKeyringForAccount(from));
        if (!keyring.signEip7702Authorization) {
            throw new Error(constants_1.KeyringControllerError.UnsupportedSignEip7702Authorization);
        }
        const { chainId, nonce } = params;
        const contractAddress = (0, eth_sig_util_1.normalize)(params.contractAddress);
        if (contractAddress === undefined) {
            throw new Error(constants_1.KeyringControllerError.MissingEip7702AuthorizationContractAddress);
        }
        return await keyring.signEip7702Authorization(from, [
            chainId,
            contractAddress,
            nonce,
        ]);
    }
    /**
     * Signs personal message by calling down into a specific keyring.
     *
     * @param messageParams - PersonalMessageParams object to sign.
     * @returns Promise resolving to a signed message string.
     */
    async signPersonalMessage(messageParams) {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        const address = (0, eth_sig_util_1.normalize)(messageParams.from);
        const keyring = (await this.getKeyringForAccount(address));
        if (!keyring.signPersonalMessage) {
            throw new Error(constants_1.KeyringControllerError.UnsupportedSignPersonalMessage);
        }
        const normalizedData = normalize(messageParams.data);
        return await keyring.signPersonalMessage(address, normalizedData);
    }
    /**
     * Signs typed message by calling down into a specific keyring.
     *
     * @param messageParams - TypedMessageParams object to sign.
     * @param version - Compatibility version EIP712.
     * @throws Will throw when passed an unrecognized version.
     * @returns Promise resolving to a signed message string or an error if any.
     */
    async signTypedMessage(messageParams, version) {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        try {
            if (![
                SignTypedDataVersion.V1,
                SignTypedDataVersion.V3,
                SignTypedDataVersion.V4,
            ].includes(version)) {
                throw new Error(`Unexpected signTypedMessage version: '${version}'`);
            }
            // Cast to `Hex` here is safe here because `messageParams.from` is not nullish.
            // `normalize` returns `Hex` unless given a nullish value.
            const address = (0, eth_sig_util_1.normalize)(messageParams.from);
            const keyring = (await this.getKeyringForAccount(address));
            if (!keyring.signTypedData) {
                throw new Error(constants_1.KeyringControllerError.UnsupportedSignTypedMessage);
            }
            return await keyring.signTypedData(address, version !== SignTypedDataVersion.V1 &&
                typeof messageParams.data === 'string'
                ? JSON.parse(messageParams.data)
                : messageParams.data, { version });
        }
        catch (error) {
            // TODO: Either fix this lint violation or explain why it's necessary to ignore.
            // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
            throw new Error(`Keyring Controller signTypedMessage: ${error}`);
        }
    }
    /**
     * Signs a transaction by calling down into a specific keyring.
     *
     * @param transaction - Transaction object to sign. Must be a `ethereumjs-tx` transaction instance.
     * @param from - Address to sign from, should be in keychain.
     * @param opts - An optional options object.
     * @returns Promise resolving to a signed transaction string.
     */
    async signTransaction(transaction, from, opts) {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        const address = (0, eth_sig_util_1.normalize)(from);
        const keyring = (await this.getKeyringForAccount(address));
        if (!keyring.signTransaction) {
            throw new Error(constants_1.KeyringControllerError.UnsupportedSignTransaction);
        }
        return await keyring.signTransaction(address, transaction, opts);
    }
    /**
     * Convert a base transaction to a base UserOperation.
     *
     * @param from - Address of the sender.
     * @param transactions - Base transactions to include in the UserOperation.
     * @param executionContext - The execution context to use for the UserOperation.
     * @returns A pseudo-UserOperation that can be used to construct a real.
     */
    async prepareUserOperation(from, transactions, executionContext) {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        const address = (0, eth_sig_util_1.normalize)(from);
        const keyring = (await this.getKeyringForAccount(address));
        if (!keyring.prepareUserOperation) {
            throw new Error(constants_1.KeyringControllerError.UnsupportedPrepareUserOperation);
        }
        return await keyring.prepareUserOperation(address, transactions, executionContext);
    }
    /**
     * Patches properties of a UserOperation. Currently, only the
     * `paymasterAndData` can be patched.
     *
     * @param from - Address of the sender.
     * @param userOp - UserOperation to patch.
     * @param executionContext - The execution context to use for the UserOperation.
     * @returns A patch to apply to the UserOperation.
     */
    async patchUserOperation(from, userOp, executionContext) {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        const address = (0, eth_sig_util_1.normalize)(from);
        const keyring = (await this.getKeyringForAccount(address));
        if (!keyring.patchUserOperation) {
            throw new Error(constants_1.KeyringControllerError.UnsupportedPatchUserOperation);
        }
        return await keyring.patchUserOperation(address, userOp, executionContext);
    }
    /**
     * Signs an UserOperation.
     *
     * @param from - Address of the sender.
     * @param userOp - UserOperation to sign.
     * @param executionContext - The execution context to use for the UserOperation.
     * @returns The signature of the UserOperation.
     */
    async signUserOperation(from, userOp, executionContext) {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        const address = (0, eth_sig_util_1.normalize)(from);
        const keyring = (await this.getKeyringForAccount(address));
        if (!keyring.signUserOperation) {
            throw new Error(constants_1.KeyringControllerError.UnsupportedSignUserOperation);
        }
        return await keyring.signUserOperation(address, userOp, executionContext);
    }
    /**
     * Changes the password used to encrypt the vault.
     *
     * @param password - The new password.
     * @returns Promise resolving when the operation completes.
     */
    changePassword(password) {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        // If the password is the same, do nothing.
        if (__classPrivateFieldGet(this, _KeyringController_password, "f") === password) {
            return Promise.resolve();
        }
        return __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_persistOrRollback).call(this, async () => {
            assertIsValidPassword(password);
            __classPrivateFieldSet(this, _KeyringController_password, password, "f");
            // We need to clear encryption key and salt from state
            // to force the controller to re-encrypt the vault using
            // the new password.
            if (__classPrivateFieldGet(this, _KeyringController_cacheEncryptionKey, "f")) {
                this.update((state) => {
                    delete state.encryptionKey;
                    delete state.encryptionSalt;
                });
            }
        });
    }
    /**
     * Attempts to decrypt the current vault and load its keyrings, using the
     * given encryption key and salt. The optional salt can be used to check for
     * consistency with the vault salt.
     *
     * @param encryptionKey - Key to unlock the keychain.
     * @param encryptionSalt - Optional salt to unlock the keychain.
     * @returns Promise resolving when the operation completes.
     */
    async submitEncryptionKey(encryptionKey, encryptionSalt) {
        const { newMetadata } = await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_withRollback).call(this, async () => {
            const result = await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_unlockKeyrings).call(this, undefined, encryptionKey, encryptionSalt);
            __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_setUnlocked).call(this);
            return result;
        });
        try {
            // if new metadata has been generated during login, we
            // can attempt to upgrade the vault.
            await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_withRollback).call(this, async () => {
                if (newMetadata) {
                    await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_updateVault).call(this);
                }
            });
        }
        catch (error) {
            // We don't want to throw an error if the upgrade fails
            // since the controller is already unlocked.
            console.error('Failed to update vault during login:', error);
        }
    }
    /**
     * Exports the vault encryption key.
     *
     * @returns The vault encryption key.
     */
    async exportEncryptionKey() {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        return await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_withControllerLock).call(this, async () => {
            const { encryptionKey } = this.state;
            assertIsEncryptionKeySet(encryptionKey);
            return encryptionKey;
        });
    }
    /**
     * Attempts to decrypt the current vault and load its keyrings,
     * using the given password.
     *
     * @param password - Password to unlock the keychain.
     * @returns Promise resolving when the operation completes.
     */
    async submitPassword(password) {
        const { newMetadata } = await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_withRollback).call(this, async () => {
            const result = await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_unlockKeyrings).call(this, password);
            __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_setUnlocked).call(this);
            return result;
        });
        try {
            // If there are stronger encryption params available, or
            // if new metadata has been generated during login, we
            // can attempt to upgrade the vault.
            await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_withRollback).call(this, async () => {
                if (newMetadata || __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_isNewEncryptionAvailable).call(this)) {
                    await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_updateVault).call(this);
                }
            });
        }
        catch (error) {
            // We don't want to throw an error if the upgrade fails
            // since the controller is already unlocked.
            console.error('Failed to update vault during login:', error);
        }
    }
    /**
     * Verifies the that the seed phrase restores the current keychain's accounts.
     *
     * @param keyringId - The id of the keyring to verify.
     * @returns Promise resolving to the seed phrase as Uint8Array.
     */
    async verifySeedPhrase(keyringId) {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        return __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_withControllerLock).call(this, async () => __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_verifySeedPhrase).call(this, keyringId));
    }
    async withKeyring(selector, operation, options = {
        createIfMissing: false,
    }) {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        return __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_persistOrRollback).call(this, async () => {
            let keyring;
            if ('address' in selector) {
                keyring = (await this.getKeyringForAccount(selector.address));
            }
            else if ('type' in selector) {
                keyring = this.getKeyringsByType(selector.type)[selector.index || 0];
                if (!keyring && options.createIfMissing) {
                    keyring = (await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_newKeyring).call(this, selector.type, options.createWithData));
                }
            }
            else if ('id' in selector) {
                keyring = __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_getKeyringById).call(this, selector.id);
            }
            if (!keyring) {
                throw new Error(constants_1.KeyringControllerError.KeyringNotFound);
            }
            const result = await operation({
                keyring,
                metadata: __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_getKeyringMetadata).call(this, keyring),
            });
            if (Object.is(result, keyring)) {
                // Access to a keyring instance outside of controller safeguards
                // should be discouraged, as it can lead to unexpected behavior.
                // This error is thrown to prevent consumers using `withKeyring`
                // as a way to get a reference to a keyring instance.
                throw new Error(constants_1.KeyringControllerError.UnsafeDirectKeyringAccess);
            }
            return result;
        });
    }
    async getAccountKeyringType(account) {
        __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertIsUnlocked).call(this);
        const keyring = (await this.getKeyringForAccount(account));
        return keyring.type;
    }
}
exports.KeyringController = KeyringController;
_KeyringController_controllerOperationMutex = new WeakMap(), _KeyringController_vaultOperationMutex = new WeakMap(), _KeyringController_keyringBuilders = new WeakMap(), _KeyringController_encryptor = new WeakMap(), _KeyringController_cacheEncryptionKey = new WeakMap(), _KeyringController_keyrings = new WeakMap(), _KeyringController_unsupportedKeyrings = new WeakMap(), _KeyringController_password = new WeakMap(), _KeyringController_instances = new WeakSet(), _KeyringController_registerMessageHandlers = function _KeyringController_registerMessageHandlers() {
    this.messagingSystem.registerActionHandler(`${name}:signMessage`, this.signMessage.bind(this));
    this.messagingSystem.registerActionHandler(`${name}:signEip7702Authorization`, this.signEip7702Authorization.bind(this));
    this.messagingSystem.registerActionHandler(`${name}:signPersonalMessage`, this.signPersonalMessage.bind(this));
    this.messagingSystem.registerActionHandler(`${name}:signTypedMessage`, this.signTypedMessage.bind(this));
    this.messagingSystem.registerActionHandler(`${name}:decryptMessage`, this.decryptMessage.bind(this));
    this.messagingSystem.registerActionHandler(`${name}:getEncryptionPublicKey`, this.getEncryptionPublicKey.bind(this));
    this.messagingSystem.registerActionHandler(`${name}:getAccounts`, this.getAccounts.bind(this));
    this.messagingSystem.registerActionHandler(`${name}:getKeyringsByType`, this.getKeyringsByType.bind(this));
    this.messagingSystem.registerActionHandler(`${name}:getKeyringForAccount`, this.getKeyringForAccount.bind(this));
    this.messagingSystem.registerActionHandler(`${name}:persistAllKeyrings`, this.persistAllKeyrings.bind(this));
    this.messagingSystem.registerActionHandler(`${name}:prepareUserOperation`, this.prepareUserOperation.bind(this));
    this.messagingSystem.registerActionHandler(`${name}:patchUserOperation`, this.patchUserOperation.bind(this));
    this.messagingSystem.registerActionHandler(`${name}:signUserOperation`, this.signUserOperation.bind(this));
    this.messagingSystem.registerActionHandler(`${name}:addNewAccount`, this.addNewAccount.bind(this));
    this.messagingSystem.registerActionHandler(`${name}:withKeyring`, this.withKeyring.bind(this));
    this.messagingSystem.registerActionHandler(`${name}:addNewKeyring`, this.addNewKeyring.bind(this));
}, _KeyringController_getKeyringById = function _KeyringController_getKeyringById(keyringId) {
    return __classPrivateFieldGet(this, _KeyringController_keyrings, "f").find(({ metadata }) => metadata.id === keyringId)
        ?.keyring;
}, _KeyringController_getKeyringByIdOrDefault = function _KeyringController_getKeyringByIdOrDefault(keyringId) {
    if (!keyringId) {
        return __classPrivateFieldGet(this, _KeyringController_keyrings, "f")[0]?.keyring;
    }
    return __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_getKeyringById).call(this, keyringId);
}, _KeyringController_getKeyringMetadata = function _KeyringController_getKeyringMetadata(keyring) {
    const keyringWithMetadata = __classPrivateFieldGet(this, _KeyringController_keyrings, "f").find((candidate) => candidate.keyring === keyring);
    if (!keyringWithMetadata) {
        throw new Error(constants_1.KeyringControllerError.KeyringNotFound);
    }
    return keyringWithMetadata.metadata;
}, _KeyringController_getKeyringBuilderForType = function _KeyringController_getKeyringBuilderForType(type) {
    return __classPrivateFieldGet(this, _KeyringController_keyringBuilders, "f").find((keyringBuilder) => keyringBuilder.type === type);
}, _KeyringController_createNewVaultWithKeyring = 
/**
 * Create new vault with an initial keyring
 *
 * Destroys any old encrypted storage,
 * creates a new encrypted store with the given password,
 * creates a new wallet with 1 account.
 *
 * @fires KeyringController:unlock
 * @param password - The password to encrypt the vault with.
 * @param keyring - A object containing the params to instantiate a new keyring.
 * @param keyring.type - The keyring type.
 * @param keyring.opts - Optional parameters required to instantiate the keyring.
 * @returns A promise that resolves to the state.
 */
async function _KeyringController_createNewVaultWithKeyring(password, keyring) {
    __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertControllerMutexIsLocked).call(this);
    if (typeof password !== 'string') {
        throw new TypeError(constants_1.KeyringControllerError.WrongPasswordType);
    }
    this.update((state) => {
        delete state.encryptionKey;
        delete state.encryptionSalt;
    });
    __classPrivateFieldSet(this, _KeyringController_password, password, "f");
    await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_clearKeyrings).call(this);
    await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_createKeyringWithFirstAccount).call(this, keyring.type, keyring.opts);
    __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_setUnlocked).call(this);
}, _KeyringController_verifySeedPhrase = 
/**
 * Internal non-exclusive method to verify the seed phrase.
 *
 * @param keyringId - The id of the keyring to verify the seed phrase for.
 * @returns A promise resolving to the seed phrase as Uint8Array.
 */
async function _KeyringController_verifySeedPhrase(keyringId) {
    __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertControllerMutexIsLocked).call(this);
    const keyring = __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_getKeyringByIdOrDefault).call(this, keyringId);
    if (!keyring) {
        throw new Error(constants_1.KeyringControllerError.KeyringNotFound);
    }
    // eslint-disable-next-line @typescript-eslint/no-unsafe-enum-comparison
    if (keyring.type !== KeyringTypes.hd) {
        throw new Error(constants_1.KeyringControllerError.UnsupportedVerifySeedPhrase);
    }
    assertHasUint8ArrayMnemonic(keyring);
    const seedWords = keyring.mnemonic;
    const accounts = await keyring.getAccounts();
    /* istanbul ignore if */
    if (accounts.length === 0) {
        throw new Error('Cannot verify an empty keyring.');
    }
    // The HD Keyring Builder is a default keyring builder
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    const hdKeyringBuilder = __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_getKeyringBuilderForType).call(this, KeyringTypes.hd);
    const hdKeyring = hdKeyringBuilder();
    // @ts-expect-error @metamask/eth-hd-keyring correctly handles
    // Uint8Array seed phrases in the `deserialize` method.
    await hdKeyring.deserialize({
        mnemonic: seedWords,
        numberOfAccounts: accounts.length,
    });
    const testAccounts = await hdKeyring.getAccounts();
    /* istanbul ignore if */
    if (testAccounts.length !== accounts.length) {
        throw new Error('Seed phrase imported incorrect number of accounts.');
    }
    testAccounts.forEach((account, i) => {
        /* istanbul ignore if */
        if (account.toLowerCase() !== accounts[i].toLowerCase()) {
            throw new Error('Seed phrase imported different accounts.');
        }
    });
    return seedWords;
}, _KeyringController_getUpdatedKeyrings = 
/**
 * Get the updated array of each keyring's type and
 * accounts list.
 *
 * @returns A promise resolving to the updated keyrings array.
 */
async function _KeyringController_getUpdatedKeyrings() {
    return Promise.all(__classPrivateFieldGet(this, _KeyringController_keyrings, "f").map(displayForKeyring));
}, _KeyringController_getSerializedKeyrings = 
/**
 * Serialize the current array of keyring instances,
 * including unsupported keyrings by default.
 *
 * @param options - Method options.
 * @param options.includeUnsupported - Whether to include unsupported keyrings.
 * @returns The serialized keyrings.
 */
async function _KeyringController_getSerializedKeyrings({ includeUnsupported } = {
    includeUnsupported: true,
}) {
    const serializedKeyrings = await Promise.all(__classPrivateFieldGet(this, _KeyringController_keyrings, "f").map(async ({ keyring, metadata }) => {
        return {
            type: keyring.type,
            data: await keyring.serialize(),
            metadata,
        };
    }));
    if (includeUnsupported) {
        serializedKeyrings.push(...__classPrivateFieldGet(this, _KeyringController_unsupportedKeyrings, "f"));
    }
    return serializedKeyrings;
}, _KeyringController_getSessionState = 
/**
 * Get a snapshot of session data held by class variables.
 *
 * @returns An object with serialized keyrings, keyrings metadata,
 * and the user password.
 */
async function _KeyringController_getSessionState() {
    return {
        keyrings: await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_getSerializedKeyrings).call(this),
        password: __classPrivateFieldGet(this, _KeyringController_password, "f"),
    };
}, _KeyringController_restoreSerializedKeyrings = 
/**
 * Restore a serialized keyrings array.
 *
 * @param serializedKeyrings - The serialized keyrings array.
 * @returns The restored keyrings.
 */
async function _KeyringController_restoreSerializedKeyrings(serializedKeyrings) {
    await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_clearKeyrings).call(this);
    const keyrings = [];
    let newMetadata = false;
    for (const serializedKeyring of serializedKeyrings) {
        const result = await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_restoreKeyring).call(this, serializedKeyring);
        if (result) {
            const { keyring, metadata } = result;
            keyrings.push({ keyring, metadata });
            if (result.newMetadata) {
                newMetadata = true;
            }
        }
    }
    return { keyrings, newMetadata };
}, _KeyringController_unlockKeyrings = 
/**
 * Unlock Keyrings, decrypting the vault and deserializing all
 * keyrings contained in it, using a password or an encryption key with salt.
 *
 * @param password - The keyring controller password.
 * @param encryptionKey - An exported key string to unlock keyrings with.
 * @param encryptionSalt - The salt used to encrypt the vault.
 * @returns A promise resolving to the deserialized keyrings array.
 */
async function _KeyringController_unlockKeyrings(password, encryptionKey, encryptionSalt) {
    return __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_withVaultLock).call(this, async () => {
        const encryptedVault = this.state.vault;
        if (!encryptedVault) {
            throw new Error(constants_1.KeyringControllerError.VaultError);
        }
        let vault;
        const updatedState = {};
        if (__classPrivateFieldGet(this, _KeyringController_cacheEncryptionKey, "f")) {
            assertIsExportableKeyEncryptor(__classPrivateFieldGet(this, _KeyringController_encryptor, "f"));
            if (password) {
                const result = await __classPrivateFieldGet(this, _KeyringController_encryptor, "f").decryptWithDetail(password, encryptedVault);
                vault = result.vault;
                __classPrivateFieldSet(this, _KeyringController_password, password, "f");
                updatedState.encryptionKey = result.exportedKeyString;
                updatedState.encryptionSalt = result.salt;
            }
            else {
                const parsedEncryptedVault = JSON.parse(encryptedVault);
                if (encryptionSalt && encryptionSalt !== parsedEncryptedVault.salt) {
                    throw new Error(constants_1.KeyringControllerError.ExpiredCredentials);
                }
                else {
                    encryptionSalt = parsedEncryptedVault.salt;
                }
                if (typeof encryptionKey !== 'string') {
                    throw new TypeError(constants_1.KeyringControllerError.WrongPasswordType);
                }
                const key = await __classPrivateFieldGet(this, _KeyringController_encryptor, "f").importKey(encryptionKey);
                vault = await __classPrivateFieldGet(this, _KeyringController_encryptor, "f").decryptWithKey(key, parsedEncryptedVault);
                // This call is required on the first call because encryptionKey
                // is not yet inside the memStore
                updatedState.encryptionKey = encryptionKey;
                updatedState.encryptionSalt = encryptionSalt;
            }
        }
        else {
            if (typeof password !== 'string') {
                throw new TypeError(constants_1.KeyringControllerError.WrongPasswordType);
            }
            vault = await __classPrivateFieldGet(this, _KeyringController_encryptor, "f").decrypt(password, encryptedVault);
            __classPrivateFieldSet(this, _KeyringController_password, password, "f");
        }
        if (!isSerializedKeyringsArray(vault)) {
            throw new Error(constants_1.KeyringControllerError.VaultDataError);
        }
        const { keyrings, newMetadata } = await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_restoreSerializedKeyrings).call(this, vault);
        const updatedKeyrings = await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_getUpdatedKeyrings).call(this);
        this.update((state) => {
            state.keyrings = updatedKeyrings;
            if (updatedState.encryptionKey || updatedState.encryptionSalt) {
                state.encryptionKey = updatedState.encryptionKey;
                state.encryptionSalt = updatedState.encryptionSalt;
            }
        });
        return { keyrings, newMetadata };
    });
}, _KeyringController_updateVault = function _KeyringController_updateVault() {
    return __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_withVaultLock).call(this, async () => {
        // Ensure no duplicate accounts are persisted.
        await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertNoDuplicateAccounts).call(this);
        const { encryptionKey, encryptionSalt, vault } = this.state;
        // READ THIS CAREFULLY:
        // We do check if the vault is still considered up-to-date, if not, we would not re-use the
        // cached key and we will re-generate a new one (based on the password).
        //
        // This helps doing seamless updates of the vault. Useful in case we change some cryptographic
        // parameters to the KDF.
        const useCachedKey = encryptionKey && vault && __classPrivateFieldGet(this, _KeyringController_encryptor, "f").isVaultUpdated?.(vault);
        if (!__classPrivateFieldGet(this, _KeyringController_password, "f") && !encryptionKey) {
            throw new Error(constants_1.KeyringControllerError.MissingCredentials);
        }
        const serializedKeyrings = await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_getSerializedKeyrings).call(this);
        if (!serializedKeyrings.some((keyring) => keyring.type === KeyringTypes.hd)) {
            throw new Error(constants_1.KeyringControllerError.NoHdKeyring);
        }
        const updatedState = {};
        if (__classPrivateFieldGet(this, _KeyringController_cacheEncryptionKey, "f")) {
            assertIsExportableKeyEncryptor(__classPrivateFieldGet(this, _KeyringController_encryptor, "f"));
            if (useCachedKey) {
                const key = await __classPrivateFieldGet(this, _KeyringController_encryptor, "f").importKey(encryptionKey);
                const vaultJSON = await __classPrivateFieldGet(this, _KeyringController_encryptor, "f").encryptWithKey(key, serializedKeyrings);
                vaultJSON.salt = encryptionSalt;
                updatedState.vault = JSON.stringify(vaultJSON);
            }
            else if (__classPrivateFieldGet(this, _KeyringController_password, "f")) {
                const { vault: newVault, exportedKeyString } = await __classPrivateFieldGet(this, _KeyringController_encryptor, "f").encryptWithDetail(__classPrivateFieldGet(this, _KeyringController_password, "f"), serializedKeyrings);
                updatedState.vault = newVault;
                updatedState.encryptionKey = exportedKeyString;
            }
        }
        else {
            assertIsValidPassword(__classPrivateFieldGet(this, _KeyringController_password, "f"));
            updatedState.vault = await __classPrivateFieldGet(this, _KeyringController_encryptor, "f").encrypt(__classPrivateFieldGet(this, _KeyringController_password, "f"), serializedKeyrings);
        }
        if (!updatedState.vault) {
            throw new Error(constants_1.KeyringControllerError.MissingVaultData);
        }
        const updatedKeyrings = await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_getUpdatedKeyrings).call(this);
        this.update((state) => {
            state.vault = updatedState.vault;
            state.keyrings = updatedKeyrings;
            if (updatedState.encryptionKey) {
                state.encryptionKey = updatedState.encryptionKey;
                state.encryptionSalt = JSON.parse(updatedState.vault).salt;
            }
        });
        return true;
    });
}, _KeyringController_isNewEncryptionAvailable = function _KeyringController_isNewEncryptionAvailable() {
    const { vault } = this.state;
    if (!vault || !__classPrivateFieldGet(this, _KeyringController_password, "f") || !__classPrivateFieldGet(this, _KeyringController_encryptor, "f").isVaultUpdated) {
        return false;
    }
    return !__classPrivateFieldGet(this, _KeyringController_encryptor, "f").isVaultUpdated(vault);
}, _KeyringController_getAccountsFromKeyrings = 
/**
 * Retrieves all the accounts from keyrings instances
 * that are currently in memory.
 *
 * @param additionalKeyrings - Additional keyrings to include in the search.
 * @returns A promise resolving to an array of accounts.
 */
async function _KeyringController_getAccountsFromKeyrings(additionalKeyrings = []) {
    const keyrings = __classPrivateFieldGet(this, _KeyringController_keyrings, "f").map(({ keyring }) => keyring);
    const keyringArrays = await Promise.all([...keyrings, ...additionalKeyrings].map(async (keyring) => keyring.getAccounts()));
    const addresses = keyringArrays.reduce((res, arr) => {
        return res.concat(arr);
    }, []);
    // Cast to `string[]` here is safe here because `addresses` has no nullish
    // values, and `normalize` returns `string` unless given a nullish value
    return addresses.map(normalize);
}, _KeyringController_createKeyringWithFirstAccount = 
/**
 * Create a new keyring, ensuring that the first account is
 * also created.
 *
 * @param type - Keyring type to instantiate.
 * @param opts - Optional parameters required to instantiate the keyring.
 * @returns A promise that resolves if the operation is successful.
 */
async function _KeyringController_createKeyringWithFirstAccount(type, opts) {
    __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertControllerMutexIsLocked).call(this);
    const keyring = (await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_newKeyring).call(this, type, opts));
    const [firstAccount] = await keyring.getAccounts();
    if (!firstAccount) {
        throw new Error(constants_1.KeyringControllerError.NoFirstAccount);
    }
    return firstAccount;
}, _KeyringController_newKeyring = 
/**
 * Instantiate, initialize and return a new keyring of the given `type`,
 * using the given `opts`. The keyring is built using the keyring builder
 * registered for the given `type`.
 *
 * The internal keyring and keyring metadata arrays are updated with the new
 * keyring as well.
 *
 * @param type - The type of keyring to add.
 * @param data - Keyring initialization options.
 * @returns The new keyring.
 * @throws If the keyring includes duplicated accounts.
 */
async function _KeyringController_newKeyring(type, data) {
    const keyring = await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_createKeyring).call(this, type, data);
    __classPrivateFieldGet(this, _KeyringController_keyrings, "f").push({ keyring, metadata: getDefaultKeyringMetadata() });
    return keyring;
}, _KeyringController_createKeyring = 
/**
 * Instantiate, initialize and return a keyring of the given `type` using the
 * given `opts`. The keyring is built using the keyring builder registered
 * for the given `type`.
 *
 * The keyring might be new, or it might be restored from the vault. This
 * function should only be called from `#newKeyring` or `#restoreKeyring`,
 * for the "new" and "restore" cases respectively.
 *
 * The internal keyring and keyring metadata arrays are *not* updated, the
 * caller is expected to update them.
 *
 * @param type - The type of keyring to add.
 * @param data - Keyring initialization options.
 * @returns The new keyring.
 * @throws If the keyring includes duplicated accounts.
 */
async function _KeyringController_createKeyring(type, data) {
    __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertControllerMutexIsLocked).call(this);
    const keyringBuilder = __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_getKeyringBuilderForType).call(this, type);
    if (!keyringBuilder) {
        throw new Error(`${constants_1.KeyringControllerError.NoKeyringBuilder}. Keyring type: ${type}`);
    }
    const keyring = keyringBuilder();
    if (data) {
        // @ts-expect-error Enforce data type after updating clients
        await keyring.deserialize(data);
    }
    if (keyring.init) {
        await keyring.init();
    }
    if (type === KeyringTypes.hd && (!(0, utils_1.isObject)(data) || !data.mnemonic)) {
        if (!keyring.generateRandomMnemonic) {
            throw new Error(constants_1.KeyringControllerError.UnsupportedGenerateRandomMnemonic);
        }
        // NOTE: Not all keyrings implement this method in a asynchronous-way. Using `await` for
        // non-thenable will still be valid (despite not being really useful). It allows us to cover both
        // cases and allow retro-compatibility too.
        await keyring.generateRandomMnemonic();
        await keyring.addAccounts(1);
    }
    return keyring;
}, _KeyringController_clearKeyrings = 
/**
 * Remove all managed keyrings, destroying all their
 * instances in memory.
 */
async function _KeyringController_clearKeyrings() {
    __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertControllerMutexIsLocked).call(this);
    for (const { keyring } of __classPrivateFieldGet(this, _KeyringController_keyrings, "f")) {
        await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_destroyKeyring).call(this, keyring);
    }
    __classPrivateFieldSet(this, _KeyringController_keyrings, [], "f");
    __classPrivateFieldSet(this, _KeyringController_unsupportedKeyrings, [], "f");
}, _KeyringController_restoreKeyring = 
/**
 * Restore a Keyring from a provided serialized payload.
 * On success, returns the resulting keyring instance.
 *
 * @param serialized - The serialized keyring.
 * @returns The deserialized keyring or undefined if the keyring type is unsupported.
 */
async function _KeyringController_restoreKeyring(serialized) {
    __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertControllerMutexIsLocked).call(this);
    try {
        const { type, data, metadata: serializedMetadata } = serialized;
        let newMetadata = false;
        let metadata = serializedMetadata;
        const keyring = await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_createKeyring).call(this, type, data);
        await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertNoDuplicateAccounts).call(this, [keyring]);
        // If metadata is missing, assume the data is from an installation before
        // we had keyring metadata.
        if (!metadata) {
            newMetadata = true;
            metadata = getDefaultKeyringMetadata();
        }
        // The keyring is added to the keyrings array only if it's successfully restored
        // and the metadata is successfully added to the controller
        __classPrivateFieldGet(this, _KeyringController_keyrings, "f").push({
            keyring,
            metadata,
        });
        return { keyring, metadata, newMetadata };
    }
    catch (error) {
        console.error(error);
        __classPrivateFieldGet(this, _KeyringController_unsupportedKeyrings, "f").push(serialized);
        return undefined;
    }
}, _KeyringController_destroyKeyring = 
/**
 * Destroy Keyring
 *
 * Some keyrings support a method called `destroy`, that destroys the
 * keyring along with removing all its event listeners and, in some cases,
 * clears the keyring bridge iframe from the DOM.
 *
 * @param keyring - The keyring to destroy.
 */
async function _KeyringController_destroyKeyring(keyring) {
    await keyring.destroy?.();
}, _KeyringController_removeEmptyKeyrings = 
/**
 * Remove empty keyrings.
 *
 * Loops through the keyrings and removes the ones with empty accounts
 * (usually after removing the last / only account) from a keyring.
 */
async function _KeyringController_removeEmptyKeyrings() {
    __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertControllerMutexIsLocked).call(this);
    const validKeyrings = [];
    // Since getAccounts returns a Promise
    // We need to wait to hear back form each keyring
    // in order to decide which ones are now valid (accounts.length > 0)
    await Promise.all(__classPrivateFieldGet(this, _KeyringController_keyrings, "f").map(async ({ keyring, metadata }) => {
        const accounts = await keyring.getAccounts();
        if (accounts.length > 0) {
            validKeyrings.push({ keyring, metadata });
        }
        else {
            await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_destroyKeyring).call(this, keyring);
        }
    }));
    __classPrivateFieldSet(this, _KeyringController_keyrings, validKeyrings, "f");
}, _KeyringController_assertNoDuplicateAccounts = 
/**
 * Assert that there are no duplicate accounts in the keyrings.
 *
 * @param additionalKeyrings - Additional keyrings to include in the check.
 * @throws If there are duplicate accounts.
 */
async function _KeyringController_assertNoDuplicateAccounts(additionalKeyrings = []) {
    const accounts = await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_getAccountsFromKeyrings).call(this, additionalKeyrings);
    if (new Set(accounts).size !== accounts.length) {
        throw new Error(constants_1.KeyringControllerError.DuplicatedAccount);
    }
}, _KeyringController_setUnlocked = function _KeyringController_setUnlocked() {
    __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertControllerMutexIsLocked).call(this);
    this.update((state) => {
        state.isUnlocked = true;
    });
    this.messagingSystem.publish(`${name}:unlock`);
}, _KeyringController_assertIsUnlocked = function _KeyringController_assertIsUnlocked() {
    if (!this.state.isUnlocked) {
        throw new Error(constants_1.KeyringControllerError.ControllerLocked);
    }
}, _KeyringController_persistOrRollback = 
/**
 * Execute the given function after acquiring the controller lock
 * and save the vault to state after it (only if needed), or rollback to their
 * previous state in case of error.
 *
 * @param callback - The function to execute.
 * @returns The result of the function.
 */
async function _KeyringController_persistOrRollback(callback) {
    return __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_withRollback).call(this, async ({ releaseLock }) => {
        const oldState = JSON.stringify(await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_getSessionState).call(this));
        const callbackResult = await callback({ releaseLock });
        const newState = JSON.stringify(await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_getSessionState).call(this));
        // State is committed only if the operation is successful and need to trigger a vault update.
        if (!(0, lodash_1.isEqual)(oldState, newState)) {
            await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_updateVault).call(this);
        }
        return callbackResult;
    });
}, _KeyringController_withRollback = 
/**
 * Execute the given function after acquiring the controller lock
 * and rollback keyrings and password states in case of error.
 *
 * @param callback - The function to execute atomically.
 * @returns The result of the function.
 */
async function _KeyringController_withRollback(callback) {
    return __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_withControllerLock).call(this, async ({ releaseLock }) => {
        const currentSerializedKeyrings = await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_getSerializedKeyrings).call(this);
        const currentPassword = __classPrivateFieldGet(this, _KeyringController_password, "f");
        try {
            return await callback({ releaseLock });
        }
        catch (e) {
            // Keyrings and password are restored to their previous state
            __classPrivateFieldSet(this, _KeyringController_password, currentPassword, "f");
            await __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_restoreSerializedKeyrings).call(this, currentSerializedKeyrings);
            throw e;
        }
    });
}, _KeyringController_assertControllerMutexIsLocked = function _KeyringController_assertControllerMutexIsLocked() {
    if (!__classPrivateFieldGet(this, _KeyringController_controllerOperationMutex, "f").isLocked()) {
        throw new Error(constants_1.KeyringControllerError.ControllerLockRequired);
    }
}, _KeyringController_withControllerLock = 
/**
 * Lock the controller mutex before executing the given function,
 * and release it after the function is resolved or after an
 * error is thrown.
 *
 * This wrapper ensures that each mutable operation that interacts with the
 * controller and that changes its state is executed in a mutually exclusive way,
 * preventing unsafe concurrent access that could lead to unpredictable behavior.
 *
 * @param callback - The function to execute while the controller mutex is locked.
 * @returns The result of the function.
 */
async function _KeyringController_withControllerLock(callback) {
    return withLock(__classPrivateFieldGet(this, _KeyringController_controllerOperationMutex, "f"), callback);
}, _KeyringController_withVaultLock = 
/**
 * Lock the vault mutex before executing the given function,
 * and release it after the function is resolved or after an
 * error is thrown.
 *
 * This ensures that each operation that interacts with the vault
 * is executed in a mutually exclusive way.
 *
 * @param callback - The function to execute while the vault mutex is locked.
 * @returns The result of the function.
 */
async function _KeyringController_withVaultLock(callback) {
    __classPrivateFieldGet(this, _KeyringController_instances, "m", _KeyringController_assertControllerMutexIsLocked).call(this);
    return withLock(__classPrivateFieldGet(this, _KeyringController_vaultOperationMutex, "f"), callback);
};
/**
 * Lock the given mutex before executing the given function,
 * and release it after the function is resolved or after an
 * error is thrown.
 *
 * @param mutex - The mutex to lock.
 * @param callback - The function to execute while the mutex is locked.
 * @returns The result of the function.
 */
async function withLock(mutex, callback) {
    const releaseLock = await mutex.acquire();
    try {
        return await callback({ releaseLock });
    }
    finally {
        releaseLock();
    }
}
/**
 * Generate a new keyring metadata object.
 *
 * @returns Keyring metadata.
 */
function getDefaultKeyringMetadata() {
    return { id: (0, ulid_1.ulid)(), name: '' };
}
exports.default = KeyringController;

      };
    };
  }
  }
}, {package:"@metamask/keyring-controller",file:"node_modules\\@metamask\\keyring-controller\\dist\\KeyringController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\constants.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-controller%5Cdist%5Cconstants.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeyringControllerError = void 0;
var KeyringControllerError;
(function (KeyringControllerError) {
    KeyringControllerError["NoKeyring"] = "KeyringController - No keyring found";
    KeyringControllerError["KeyringNotFound"] = "KeyringController - Keyring not found.";
    KeyringControllerError["UnsafeDirectKeyringAccess"] = "KeyringController - Returning keyring instances is unsafe";
    KeyringControllerError["WrongPasswordType"] = "KeyringController - Password must be of type string.";
    KeyringControllerError["InvalidEmptyPassword"] = "KeyringController - Password cannot be empty.";
    KeyringControllerError["NoFirstAccount"] = "KeyringController - First Account not found.";
    KeyringControllerError["DuplicatedAccount"] = "KeyringController - The account you are trying to import is a duplicate";
    KeyringControllerError["VaultError"] = "KeyringController - Cannot unlock without a previous vault.";
    KeyringControllerError["VaultDataError"] = "KeyringController - The decrypted vault has an unexpected shape.";
    KeyringControllerError["UnsupportedEncryptionKeyExport"] = "KeyringController - The encryptor does not support encryption key export.";
    KeyringControllerError["UnsupportedGenerateRandomMnemonic"] = "KeyringController - The current keyring does not support the method generateRandomMnemonic.";
    KeyringControllerError["UnsupportedExportAccount"] = "`KeyringController - The keyring for the current address does not support the method exportAccount";
    KeyringControllerError["UnsupportedRemoveAccount"] = "`KeyringController - The keyring for the current address does not support the method removeAccount";
    KeyringControllerError["UnsupportedSignTransaction"] = "KeyringController - The keyring for the current address does not support the method signTransaction.";
    KeyringControllerError["UnsupportedSignMessage"] = "KeyringController - The keyring for the current address does not support the method signMessage.";
    KeyringControllerError["UnsupportedSignPersonalMessage"] = "KeyringController - The keyring for the current address does not support the method signPersonalMessage.";
    KeyringControllerError["UnsupportedSignEip7702Authorization"] = "KeyringController - The keyring for the current address does not support the method signEip7702Authorization.";
    KeyringControllerError["UnsupportedGetEncryptionPublicKey"] = "KeyringController - The keyring for the current address does not support the method getEncryptionPublicKey.";
    KeyringControllerError["UnsupportedDecryptMessage"] = "KeyringController - The keyring for the current address does not support the method decryptMessage.";
    KeyringControllerError["UnsupportedSignTypedMessage"] = "KeyringController - The keyring for the current address does not support the method signTypedMessage.";
    KeyringControllerError["UnsupportedGetAppKeyAddress"] = "KeyringController - The keyring for the current address does not support the method getAppKeyAddress.";
    KeyringControllerError["UnsupportedExportAppKeyForAddress"] = "KeyringController - The keyring for the current address does not support the method exportAppKeyForAddress.";
    KeyringControllerError["UnsupportedPrepareUserOperation"] = "KeyringController - The keyring for the current address does not support the method prepareUserOperation.";
    KeyringControllerError["UnsupportedPatchUserOperation"] = "KeyringController - The keyring for the current address does not support the method patchUserOperation.";
    KeyringControllerError["UnsupportedSignUserOperation"] = "KeyringController - The keyring for the current address does not support the method signUserOperation.";
    KeyringControllerError["UnsupportedVerifySeedPhrase"] = "KeyringController - The keyring does not support the method verifySeedPhrase.";
    KeyringControllerError["MissingEip7702AuthorizationContractAddress"] = "KeyringController - The EIP-7702 Authorization is invalid. No contract address provided.";
    KeyringControllerError["NoAccountOnKeychain"] = "KeyringController - The keychain doesn't have accounts.";
    KeyringControllerError["ControllerLocked"] = "KeyringController - The operation cannot be completed while the controller is locked.";
    KeyringControllerError["MissingCredentials"] = "KeyringController - Cannot persist vault without password and encryption key";
    KeyringControllerError["MissingVaultData"] = "KeyringController - Cannot persist vault without vault information";
    KeyringControllerError["ExpiredCredentials"] = "KeyringController - Encryption key and salt provided are expired";
    KeyringControllerError["NoKeyringBuilder"] = "KeyringController - No keyringBuilder found for keyring";
    KeyringControllerError["DataType"] = "KeyringController - Incorrect data type provided";
    KeyringControllerError["NoHdKeyring"] = "KeyringController - No HD Keyring found";
    KeyringControllerError["ControllerLockRequired"] = "KeyringController - attempt to update vault during a non mutually exclusive operation";
    KeyringControllerError["LastAccountInPrimaryKeyring"] = "KeyringController - Last account in primary keyring cannot be removed";
    KeyringControllerError["EncryptionKeyNotSet"] = "KeyringController - Encryption key not set";
})(KeyringControllerError || (exports.KeyringControllerError = KeyringControllerError = {}));

      };
    };
  }
  }
}, {package:"@metamask/keyring-controller",file:"node_modules\\@metamask\\keyring-controller\\dist\\constants.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs", {"./KeyringController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\KeyringController.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-controller%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./KeyringController.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/keyring-controller",file:"node_modules\\@metamask\\keyring-controller\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-internal-api\\dist\\compatibility\\index.cjs", {"./v1.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-internal-api\\dist\\compatibility\\v1.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-internal-api%5Cdist%5Ccompatibility%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./v1.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/keyring-internal-api",file:"node_modules\\@metamask\\keyring-internal-api\\dist\\compatibility\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-internal-api\\dist\\compatibility\\v1.cjs", {"@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-internal-api%5Cdist%5Ccompatibility%5Cv1.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubmitRequestResponseV1Struct = exports.KeyringResponseV1Struct = exports.KeyringRequestV1Struct = void 0;
exports.toKeyringRequestV1 = toKeyringRequestV1;
const keyring_api_1 = require("@metamask/keyring-api");
const superstruct_1 = require("@metamask/superstruct");
/**
 * Keyring request (v1).
 */
exports.KeyringRequestV1Struct = (0, superstruct_1.omit)(keyring_api_1.KeyringRequestStruct, ['origin']);
/**
 * Response to a call to `submitRequest` (v1).
 */
exports.KeyringResponseV1Struct = keyring_api_1.KeyringResponseStruct;
exports.SubmitRequestResponseV1Struct = exports.KeyringResponseV1Struct;
/**
 * Converts a keyring request to a keyring request v1.
 *
 * @param request - A keyring request.
 * @returns A keyring request v1.
 */
function toKeyringRequestV1(request) {
    const { origin, ...requestV1 } = request;
    return requestV1;
}

      };
    };
  }
  }
}, {package:"@metamask/keyring-internal-api",file:"node_modules\\@metamask\\keyring-internal-api\\dist\\compatibility\\v1.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-internal-api\\dist\\index.cjs", {"./compatibility/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-internal-api\\dist\\compatibility\\index.cjs","./types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-internal-api\\dist\\types.cjs","./versions.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-internal-api\\dist\\versions.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-internal-api%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./compatibility/index.cjs"), exports);
__exportStar(require("./types.cjs"), exports);
__exportStar(require("./versions.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/keyring-internal-api",file:"node_modules\\@metamask\\keyring-internal-api\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-internal-api\\dist\\types.cjs", {"@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-internal-api%5Cdist%5Ctypes.cjs
      return function (require, module, exports) {
"use strict";
/* eslint-disable @typescript-eslint/no-redundant-type-constituents */
/* eslint-disable @typescript-eslint/no-duplicate-type-constituents */
// FIXME: Those rules seem to be triggering a false positive on the `InternalAccountStructs`
// and `InternalAccountTypes`.
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternalAccountStruct = exports.InternalAccountStructs = exports.InternalTrxEoaAccountStruct = exports.InternalSolDataAccountStruct = exports.InternalBtcP2trAccountStruct = exports.InternalBtcP2wpkhAccountStruct = exports.InternalBtcP2shAccountStruct = exports.InternalBtcP2pkhAccountStruct = exports.InternalEthErc4337AccountStruct = exports.InternalEthEoaAccountStruct = exports.InternalAccountMetadataStruct = void 0;
const keyring_api_1 = require("@metamask/keyring-api");
const keyring_utils_1 = require("@metamask/keyring-utils");
const superstruct_1 = require("@metamask/superstruct");
exports.InternalAccountMetadataStruct = (0, keyring_utils_1.object)({
    metadata: (0, keyring_utils_1.object)({
        name: (0, superstruct_1.string)(),
        nameLastUpdatedAt: (0, keyring_utils_1.exactOptional)((0, superstruct_1.number)()),
        snap: (0, keyring_utils_1.exactOptional)((0, keyring_utils_1.object)({
            id: (0, superstruct_1.string)(),
            enabled: (0, superstruct_1.boolean)(),
            name: (0, superstruct_1.string)(),
        })),
        lastSelected: (0, keyring_utils_1.exactOptional)((0, superstruct_1.number)()),
        importTime: (0, superstruct_1.number)(),
        keyring: (0, keyring_utils_1.object)({
            type: (0, superstruct_1.string)(),
        }),
    }),
});
exports.InternalEthEoaAccountStruct = (0, keyring_utils_1.object)({
    ...keyring_api_1.EthEoaAccountStruct.schema,
    ...exports.InternalAccountMetadataStruct.schema,
});
exports.InternalEthErc4337AccountStruct = (0, keyring_utils_1.object)({
    ...keyring_api_1.EthErc4337AccountStruct.schema,
    ...exports.InternalAccountMetadataStruct.schema,
});
exports.InternalBtcP2pkhAccountStruct = (0, keyring_utils_1.object)({
    ...keyring_api_1.BtcP2pkhAccountStruct.schema,
    ...exports.InternalAccountMetadataStruct.schema,
});
exports.InternalBtcP2shAccountStruct = (0, keyring_utils_1.object)({
    ...keyring_api_1.BtcP2shAccountStruct.schema,
    ...exports.InternalAccountMetadataStruct.schema,
});
exports.InternalBtcP2wpkhAccountStruct = (0, keyring_utils_1.object)({
    ...keyring_api_1.BtcP2wpkhAccountStruct.schema,
    ...exports.InternalAccountMetadataStruct.schema,
});
exports.InternalBtcP2trAccountStruct = (0, keyring_utils_1.object)({
    ...keyring_api_1.BtcP2trAccountStruct.schema,
    ...exports.InternalAccountMetadataStruct.schema,
});
exports.InternalSolDataAccountStruct = (0, keyring_utils_1.object)({
    ...keyring_api_1.SolDataAccountStruct.schema,
    ...exports.InternalAccountMetadataStruct.schema,
});
exports.InternalTrxEoaAccountStruct = (0, keyring_utils_1.object)({
    ...keyring_api_1.TrxEoaAccountStruct.schema,
    ...exports.InternalAccountMetadataStruct.schema,
});
exports.InternalAccountStructs = {
    [`${keyring_api_1.EthAccountType.Eoa}`]: exports.InternalEthEoaAccountStruct,
    [`${keyring_api_1.EthAccountType.Erc4337}`]: exports.InternalEthErc4337AccountStruct,
    [`${keyring_api_1.BtcAccountType.P2pkh}`]: exports.InternalBtcP2pkhAccountStruct,
    [`${keyring_api_1.BtcAccountType.P2sh}`]: exports.InternalBtcP2shAccountStruct,
    [`${keyring_api_1.BtcAccountType.P2wpkh}`]: exports.InternalBtcP2wpkhAccountStruct,
    [`${keyring_api_1.BtcAccountType.P2tr}`]: exports.InternalBtcP2trAccountStruct,
    [`${keyring_api_1.SolAccountType.DataAccount}`]: exports.InternalSolDataAccountStruct,
    [`${keyring_api_1.TrxAccountType.Eoa}`]: exports.InternalTrxEoaAccountStruct,
};
exports.InternalAccountStruct = (0, keyring_utils_1.object)({
    ...keyring_api_1.KeyringAccountStruct.schema,
    ...exports.InternalAccountMetadataStruct.schema,
});

      };
    };
  }
  }
}, {package:"@metamask/keyring-internal-api",file:"node_modules\\@metamask\\keyring-internal-api\\dist\\types.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-internal-api\\dist\\versions.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-internal-api%5Cdist%5Cversions.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeyringVersion = void 0;
var KeyringVersion;
(function (KeyringVersion) {
    /** Default. */
    KeyringVersion["V1"] = "v1";
    /**
     * Introduction of `KeyringRequest.origin`.
     *
     * Snap will now receive the `origin` as part of a `KeyringRequest` when `submitRequest` is invoked.
     * We also expect Snaps to display this `origin` in their confirmation screens (if any).
     */
    KeyringVersion["V2"] = "v2";
})(KeyringVersion || (exports.KeyringVersion = KeyringVersion = {}));

      };
    };
  }
  }
}, {package:"@metamask/keyring-internal-api",file:"node_modules\\@metamask\\keyring-internal-api\\dist\\versions.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-internal-snap-client\\dist\\KeyringInternalSnapClient.cjs", {"@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/keyring-internal-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-internal-api\\dist\\index.cjs","@metamask/keyring-snap-client":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\dist\\index.cjs","@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-internal-snap-client%5Cdist%5CKeyringInternalSnapClient.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _SnapControllerMessengerSender_snapId, _SnapControllerMessengerSender_origin, _SnapControllerMessengerSender_messenger, _SnapControllerMessengerSender_handler, _KeyringInternalSnapClient_messenger;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeyringInternalSnapClient = void 0;
const keyring_api_1 = require("@metamask/keyring-api");
const keyring_internal_api_1 = require("@metamask/keyring-internal-api");
const keyring_snap_client_1 = require("@metamask/keyring-snap-client");
const keyring_utils_1 = require("@metamask/keyring-utils");
/**
 * Implementation of the `Sender` interface that can be used to send requests
 * to a Snap through a `Messenger`.
 */
class SnapControllerMessengerSender {
    /**
     * Create a new instance of `SnapControllerSender`.
     *
     * @param messenger - The `Messenger` instance used when dispatching controllers actions.
     * @param snapId - The ID of the Snap to use.
     * @param origin - The sender's origin.
     * @param handler - The handler type.
     */
    constructor(messenger, snapId, origin, handler) {
        _SnapControllerMessengerSender_snapId.set(this, void 0);
        _SnapControllerMessengerSender_origin.set(this, void 0);
        _SnapControllerMessengerSender_messenger.set(this, void 0);
        _SnapControllerMessengerSender_handler.set(this, void 0);
        __classPrivateFieldSet(this, _SnapControllerMessengerSender_messenger, messenger, "f");
        __classPrivateFieldSet(this, _SnapControllerMessengerSender_snapId, snapId, "f");
        __classPrivateFieldSet(this, _SnapControllerMessengerSender_origin, origin, "f");
        __classPrivateFieldSet(this, _SnapControllerMessengerSender_handler, handler, "f");
    }
    /**
     * Send a request to the Snap and return the response.
     *
     * @param request - JSON-RPC request to send to the Snap.
     * @returns A promise that resolves to the response of the request.
     */
    async send(request) {
        return __classPrivateFieldGet(this, _SnapControllerMessengerSender_messenger, "f").call('SnapController:handleRequest', {
            snapId: __classPrivateFieldGet(this, _SnapControllerMessengerSender_snapId, "f"),
            origin: __classPrivateFieldGet(this, _SnapControllerMessengerSender_origin, "f"),
            handler: __classPrivateFieldGet(this, _SnapControllerMessengerSender_handler, "f"),
            request,
        });
    }
}
_SnapControllerMessengerSender_snapId = new WeakMap(), _SnapControllerMessengerSender_origin = new WeakMap(), _SnapControllerMessengerSender_messenger = new WeakMap(), _SnapControllerMessengerSender_handler = new WeakMap();
/**
 * A `KeyringClient` that allows the communication with a Snap through a
 * `Messenger`.
 */
class KeyringInternalSnapClient extends keyring_snap_client_1.KeyringClient {
    /**
     * Create a new instance of `KeyringInternalSnapClient`.
     *
     * The `handlerType` argument has a hard-coded default `string` value instead
     * of a `HandlerType` value to prevent the `@metamask/snaps-utils` module
     * from being required at runtime.
     *
     * @param args - Constructor arguments.
     * @param args.messenger - The `KeyringInternalSnapClientMessenger` instance to use.
     * @param args.snapId - The ID of the Snap to use (default: `'undefined'`).
     * @param args.origin - The sender's origin (default: `'metamask'`).
     * @param args.handler - The handler type (default: `'onKeyringRequest'`).
     */
    constructor({ messenger, snapId = 'undefined', origin = 'metamask', handler = 'onKeyringRequest', }) {
        super(new SnapControllerMessengerSender(messenger, snapId, origin, handler));
        _KeyringInternalSnapClient_messenger.set(this, void 0);
        __classPrivateFieldSet(this, _KeyringInternalSnapClient_messenger, messenger, "f");
    }
    /**
     * Create a new instance of `KeyringInternalSnapClient` with the specified
     * `snapId`.
     *
     * @param snapId - The ID of the Snap to use in the new instance.
     * @returns A new instance of `KeyringInternalSnapClient` with the
     * specified Snap ID.
     */
    withSnapId(snapId) {
        return new KeyringInternalSnapClient({
            messenger: __classPrivateFieldGet(this, _KeyringInternalSnapClient_messenger, "f"),
            snapId,
        });
    }
    /**
     * Submit a keyring request v1 (with no `origin`).
     *
     * @param request - Keyring request.
     * @returns Keyring request's response.
     */
    async submitRequestV1(request) {
        return (0, keyring_utils_1.strictMask)(await this.send({
            method: keyring_api_1.KeyringRpcMethod.SubmitRequest,
            params: request,
        }), keyring_internal_api_1.SubmitRequestResponseV1Struct);
    }
}
exports.KeyringInternalSnapClient = KeyringInternalSnapClient;
_KeyringInternalSnapClient_messenger = new WeakMap();

      };
    };
  }
  }
}, {package:"@metamask/keyring-internal-snap-client",file:"node_modules\\@metamask\\keyring-internal-snap-client\\dist\\KeyringInternalSnapClient.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-internal-snap-client\\dist\\index.cjs", {"./KeyringInternalSnapClient.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-internal-snap-client\\dist\\KeyringInternalSnapClient.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-internal-snap-client%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./KeyringInternalSnapClient.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/keyring-internal-snap-client",file:"node_modules\\@metamask\\keyring-internal-snap-client\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\dist\\KeyringClient.cjs", {"@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","uuid":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-client%5Cdist%5CKeyringClient.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _KeyringClient_sender;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeyringClient = void 0;
const keyring_api_1 = require("@metamask/keyring-api");
const keyring_utils_1 = require("@metamask/keyring-utils");
const superstruct_1 = require("@metamask/superstruct");
const uuid_1 = require("uuid");
class KeyringClient {
    /**
     * Create a new instance of `KeyringClient`.
     *
     * @param sender - The `Sender` instance to use to send requests to the snap.
     */
    constructor(sender) {
        _KeyringClient_sender.set(this, void 0);
        __classPrivateFieldSet(this, _KeyringClient_sender, sender, "f");
    }
    /**
     * Send a request to the snap and return the response.
     *
     * @param partial - A partial JSON-RPC request (method and params).
     * @returns A promise that resolves to the response to the request.
     */
    async send(partial) {
        return __classPrivateFieldGet(this, _KeyringClient_sender, "f").send({
            jsonrpc: '2.0',
            id: (0, uuid_1.v4)(),
            ...partial,
        });
    }
    async listAccounts() {
        return (0, keyring_utils_1.strictMask)(await this.send({
            method: keyring_api_1.KeyringRpcMethod.ListAccounts,
        }), keyring_api_1.ListAccountsResponseStruct);
    }
    async getAccount(id) {
        return (0, keyring_utils_1.strictMask)(await this.send({
            method: keyring_api_1.KeyringRpcMethod.GetAccount,
            params: { id },
        }), keyring_api_1.GetAccountResponseStruct);
    }
    async getAccountBalances(id, assets) {
        return (0, keyring_utils_1.strictMask)(await this.send({
            method: keyring_api_1.KeyringRpcMethod.GetAccountBalances,
            params: { id, assets },
        }), keyring_api_1.GetAccountBalancesResponseStruct);
    }
    async createAccount(options = {}) {
        return (0, keyring_utils_1.strictMask)(await this.send({
            method: keyring_api_1.KeyringRpcMethod.CreateAccount,
            params: { options },
        }), keyring_api_1.CreateAccountResponseStruct);
    }
    async discoverAccounts(scopes, entropySource, groupIndex) {
        return (0, keyring_utils_1.strictMask)(await this.send({
            method: keyring_api_1.KeyringRpcMethod.DiscoverAccounts,
            params: { scopes, entropySource, groupIndex },
        }), keyring_api_1.DiscoverAccountsResponseStruct);
    }
    async listAccountTransactions(id, pagination) {
        return (0, keyring_utils_1.strictMask)(await this.send({
            method: keyring_api_1.KeyringRpcMethod.ListAccountTransactions,
            params: { id, pagination },
        }), keyring_api_1.ListAccountTransactionsResponseStruct);
    }
    async listAccountAssets(id) {
        return (0, keyring_utils_1.strictMask)(await this.send({
            method: keyring_api_1.KeyringRpcMethod.ListAccountAssets,
            params: { id },
        }), keyring_api_1.ListAccountAssetsResponseStruct);
    }
    async resolveAccountAddress(scope, request) {
        return (0, keyring_utils_1.strictMask)(await this.send({
            method: keyring_api_1.KeyringRpcMethod.ResolveAccountAddress,
            params: { scope, request },
        }), keyring_api_1.ResolveAccountAddressResponseStruct);
    }
    async setSelectedAccounts(accounts) {
        (0, keyring_utils_1.strictMask)(await this.send({
            method: keyring_api_1.KeyringRpcMethod.SetSelectedAccounts,
            params: { accounts },
        }), keyring_api_1.SetSelectedAccountsResponseStruct);
    }
    async filterAccountChains(id, chains) {
        return (0, keyring_utils_1.strictMask)(await this.send({
            method: keyring_api_1.KeyringRpcMethod.FilterAccountChains,
            params: { id, chains },
        }), keyring_api_1.FilterAccountChainsResponseStruct);
    }
    async updateAccount(account) {
        (0, superstruct_1.assert)(await this.send({
            method: keyring_api_1.KeyringRpcMethod.UpdateAccount,
            params: { account },
        }), keyring_api_1.UpdateAccountResponseStruct);
    }
    async deleteAccount(id) {
        (0, superstruct_1.assert)(await this.send({
            method: keyring_api_1.KeyringRpcMethod.DeleteAccount,
            params: { id },
        }), keyring_api_1.DeleteAccountResponseStruct);
    }
    async exportAccount(id) {
        return (0, keyring_utils_1.strictMask)(await this.send({
            method: keyring_api_1.KeyringRpcMethod.ExportAccount,
            params: { id },
        }), keyring_api_1.ExportAccountResponseStruct);
    }
    async listRequests() {
        return (0, keyring_utils_1.strictMask)(await this.send({
            method: keyring_api_1.KeyringRpcMethod.ListRequests,
        }), keyring_api_1.ListRequestsResponseStruct);
    }
    async getRequest(id) {
        return (0, keyring_utils_1.strictMask)(await this.send({
            method: keyring_api_1.KeyringRpcMethod.GetRequest,
            params: { id },
        }), keyring_api_1.GetRequestResponseStruct);
    }
    async submitRequest(request) {
        return (0, keyring_utils_1.strictMask)(await this.send({
            method: keyring_api_1.KeyringRpcMethod.SubmitRequest,
            params: request,
        }), keyring_api_1.SubmitRequestResponseStruct);
    }
    async approveRequest(id, data = {}) {
        (0, superstruct_1.assert)(await this.send({
            method: keyring_api_1.KeyringRpcMethod.ApproveRequest,
            params: { id, data },
        }), keyring_api_1.ApproveRequestResponseStruct);
    }
    async rejectRequest(id) {
        (0, superstruct_1.assert)(await this.send({
            method: keyring_api_1.KeyringRpcMethod.RejectRequest,
            params: { id },
        }), keyring_api_1.RejectRequestResponseStruct);
    }
}
exports.KeyringClient = KeyringClient;
_KeyringClient_sender = new WeakMap();

      };
    };
  }
  }
}, {package:"@metamask/keyring-snap-client",file:"node_modules\\@metamask\\keyring-snap-client\\dist\\KeyringClient.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\dist\\KeyringPublicClient.cjs", {"./KeyringClient.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\dist\\KeyringClient.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-client%5Cdist%5CKeyringPublicClient.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _KeyringPublicClient_client;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeyringPublicClient = exports.KeyringPublicRpcMethod = void 0;
const keyring_api_1 = require("@metamask/keyring-api");
const KeyringClient_1 = require("./KeyringClient.cjs");
/**
 * Public methods list.
 */
exports.KeyringPublicRpcMethod = [
    keyring_api_1.KeyringRpcMethod.CreateAccount,
    keyring_api_1.KeyringRpcMethod.GetAccount,
    keyring_api_1.KeyringRpcMethod.UpdateAccount,
    keyring_api_1.KeyringRpcMethod.DeleteAccount,
    keyring_api_1.KeyringRpcMethod.ExportAccount,
    keyring_api_1.KeyringRpcMethod.ListAccounts,
    keyring_api_1.KeyringRpcMethod.FilterAccountChains,
    keyring_api_1.KeyringRpcMethod.GetRequest,
    keyring_api_1.KeyringRpcMethod.ApproveRequest,
    keyring_api_1.KeyringRpcMethod.RejectRequest,
    keyring_api_1.KeyringRpcMethod.ListRequests,
];
/**
 * A client that can be used by companion dapp. Only some keyring methods are
 * available with this client.
 */
class KeyringPublicClient {
    /**
     * Create a new instance of `KeyringPublicClient`.
     *
     * @param sender - The `Sender` instance to use to send requests to the snap.
     */
    constructor(sender) {
        _KeyringPublicClient_client.set(this, void 0);
        __classPrivateFieldSet(this, _KeyringPublicClient_client, new KeyringClient_1.KeyringClient(sender), "f");
    }
    async createAccount(options) {
        return __classPrivateFieldGet(this, _KeyringPublicClient_client, "f").createAccount(options);
    }
    async deleteAccount(id) {
        return __classPrivateFieldGet(this, _KeyringPublicClient_client, "f").deleteAccount(id);
    }
    async listAccounts() {
        return __classPrivateFieldGet(this, _KeyringPublicClient_client, "f").listAccounts();
    }
    async getAccount(id) {
        return __classPrivateFieldGet(this, _KeyringPublicClient_client, "f").getAccount(id);
    }
    async getRequest(id) {
        return __classPrivateFieldGet(this, _KeyringPublicClient_client, "f").getRequest(id);
    }
    async listRequests() {
        return __classPrivateFieldGet(this, _KeyringPublicClient_client, "f").listRequests();
    }
    async updateAccount(account) {
        return __classPrivateFieldGet(this, _KeyringPublicClient_client, "f").updateAccount(account);
    }
    async approveRequest(id, data) {
        return __classPrivateFieldGet(this, _KeyringPublicClient_client, "f").approveRequest(id, data);
    }
    async rejectRequest(id) {
        return __classPrivateFieldGet(this, _KeyringPublicClient_client, "f").rejectRequest(id);
    }
    async filterAccountChains(id, chains) {
        return __classPrivateFieldGet(this, _KeyringPublicClient_client, "f").filterAccountChains(id, chains);
    }
    async exportAccount(id) {
        return __classPrivateFieldGet(this, _KeyringPublicClient_client, "f").exportAccount(id);
    }
}
exports.KeyringPublicClient = KeyringPublicClient;
_KeyringPublicClient_client = new WeakMap();

      };
    };
  }
  }
}, {package:"@metamask/keyring-snap-client",file:"node_modules\\@metamask\\keyring-snap-client\\dist\\KeyringPublicClient.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\dist\\KeyringSnapRpcClient.cjs", {"./KeyringPublicClient.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\dist\\KeyringPublicClient.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-client%5Cdist%5CKeyringSnapRpcClient.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _SnapRpcSender_origin, _SnapRpcSender_provider;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeyringSnapRpcClient = exports.SnapRpcSender = void 0;
const KeyringPublicClient_1 = require("./KeyringPublicClient.cjs");
/**
 * Implementation of the `Sender` interface that can be used to send requests
 * to a snap through the snap JSON-RPC API.
 */
class SnapRpcSender {
    /**
     * Create a new instance of `SnapRpcSender`.
     *
     * @param origin - The caller's origin.
     * @param provider - The `MetaMaskInpageProvider` instance to use.
     */
    constructor(origin, provider) {
        _SnapRpcSender_origin.set(this, void 0);
        _SnapRpcSender_provider.set(this, void 0);
        __classPrivateFieldSet(this, _SnapRpcSender_origin, origin, "f");
        __classPrivateFieldSet(this, _SnapRpcSender_provider, provider, "f");
    }
    /**
     * Send a request to the snap and return the response.
     *
     * @param request - The JSON-RPC request to send to the snap.
     * @returns A promise that resolves to the response of the request.
     */
    async send(request) {
        return __classPrivateFieldGet(this, _SnapRpcSender_provider, "f").request({
            method: 'wallet_invokeKeyring',
            params: {
                snapId: __classPrivateFieldGet(this, _SnapRpcSender_origin, "f"),
                request,
            },
        });
    }
}
exports.SnapRpcSender = SnapRpcSender;
_SnapRpcSender_origin = new WeakMap(), _SnapRpcSender_provider = new WeakMap();
/**
 * A client that allows the communication with a snap through the snap
 * JSON-RPC API to call keyring methods.
 */
class KeyringSnapRpcClient extends KeyringPublicClient_1.KeyringPublicClient {
    /**
     * Create a new instance of `KeyringSnapRpcClient`.
     *
     * @param origin - Caller's origin.
     * @param provider - The `MetaMaskInpageProvider` instance to use.
     */
    constructor(origin, provider) {
        super(new SnapRpcSender(origin, provider));
    }
}
exports.KeyringSnapRpcClient = KeyringSnapRpcClient;

      };
    };
  }
  }
}, {package:"@metamask/keyring-snap-client",file:"node_modules\\@metamask\\keyring-snap-client\\dist\\KeyringSnapRpcClient.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\dist\\index.cjs", {"./KeyringClient.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\dist\\KeyringClient.cjs","./KeyringPublicClient.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\dist\\KeyringPublicClient.cjs","./KeyringSnapRpcClient.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\dist\\KeyringSnapRpcClient.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-client%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./KeyringClient.cjs"), exports);
__exportStar(require("./KeyringSnapRpcClient.cjs"), exports);
__exportStar(require("./KeyringPublicClient.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/keyring-snap-client",file:"node_modules\\@metamask\\keyring-snap-client\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\index.js", {"./nil.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\nil.js","./parse.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\parse.js","./stringify.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\stringify.js","./v1.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\v1.js","./v3.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\v3.js","./v4.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\v4.js","./v5.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\v5.js","./validate.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\validate.js","./version.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\version.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-client%5Cnode_modules%5Cuuid%5Cdist%5Cindex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "NIL", {
  enumerable: true,
  get: function () {
    return _nil.default;
  }
});
Object.defineProperty(exports, "parse", {
  enumerable: true,
  get: function () {
    return _parse.default;
  }
});
Object.defineProperty(exports, "stringify", {
  enumerable: true,
  get: function () {
    return _stringify.default;
  }
});
Object.defineProperty(exports, "v1", {
  enumerable: true,
  get: function () {
    return _v.default;
  }
});
Object.defineProperty(exports, "v3", {
  enumerable: true,
  get: function () {
    return _v2.default;
  }
});
Object.defineProperty(exports, "v4", {
  enumerable: true,
  get: function () {
    return _v3.default;
  }
});
Object.defineProperty(exports, "v5", {
  enumerable: true,
  get: function () {
    return _v4.default;
  }
});
Object.defineProperty(exports, "validate", {
  enumerable: true,
  get: function () {
    return _validate.default;
  }
});
Object.defineProperty(exports, "version", {
  enumerable: true,
  get: function () {
    return _version.default;
  }
});

var _v = _interopRequireDefault(require("./v1.js"));

var _v2 = _interopRequireDefault(require("./v3.js"));

var _v3 = _interopRequireDefault(require("./v4.js"));

var _v4 = _interopRequireDefault(require("./v5.js"));

var _nil = _interopRequireDefault(require("./nil.js"));

var _version = _interopRequireDefault(require("./version.js"));

var _validate = _interopRequireDefault(require("./validate.js"));

var _stringify = _interopRequireDefault(require("./stringify.js"));

var _parse = _interopRequireDefault(require("./parse.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
      };
    };
  }
  }
}, {package:"@metamask/keyring-snap-client>uuid",file:"node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\md5-browser.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-client%5Cnode_modules%5Cuuid%5Cdist%5Cmd5-browser.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

/*
 * Browser-compatible JavaScript MD5
 *
 * Modification of JavaScript MD5
 * https://github.com/blueimp/JavaScript-MD5
 *
 * Copyright 2011, Sebastian Tschan
 * https://blueimp.net
 *
 * Licensed under the MIT license:
 * https://opensource.org/licenses/MIT
 *
 * Based on
 * A JavaScript implementation of the RSA Data Security, Inc. MD5 Message
 * Digest Algorithm, as defined in RFC 1321.
 * Version 2.2 Copyright (C) Paul Johnston 1999 - 2009
 * Other contributors: Greg Holt, Andrew Kepert, Ydnar, Lostinet
 * Distributed under the BSD License
 * See http://pajhome.org.uk/crypt/md5 for more info.
 */
function md5(bytes) {
  if (typeof bytes === 'string') {
    const msg = unescape(encodeURIComponent(bytes)); // UTF8 escape

    bytes = new Uint8Array(msg.length);

    for (let i = 0; i < msg.length; ++i) {
      bytes[i] = msg.charCodeAt(i);
    }
  }

  return md5ToHexEncodedArray(wordsToMd5(bytesToWords(bytes), bytes.length * 8));
}
/*
 * Convert an array of little-endian words to an array of bytes
 */


function md5ToHexEncodedArray(input) {
  const output = [];
  const length32 = input.length * 32;
  const hexTab = '0123456789abcdef';

  for (let i = 0; i < length32; i += 8) {
    const x = input[i >> 5] >>> i % 32 & 0xff;
    const hex = parseInt(hexTab.charAt(x >>> 4 & 0x0f) + hexTab.charAt(x & 0x0f), 16);
    output.push(hex);
  }

  return output;
}
/**
 * Calculate output length with padding and bit length
 */


function getOutputLength(inputLength8) {
  return (inputLength8 + 64 >>> 9 << 4) + 14 + 1;
}
/*
 * Calculate the MD5 of an array of little-endian words, and a bit length.
 */


function wordsToMd5(x, len) {
  /* append padding */
  x[len >> 5] |= 0x80 << len % 32;
  x[getOutputLength(len) - 1] = len;
  let a = 1732584193;
  let b = -271733879;
  let c = -1732584194;
  let d = 271733878;

  for (let i = 0; i < x.length; i += 16) {
    const olda = a;
    const oldb = b;
    const oldc = c;
    const oldd = d;
    a = md5ff(a, b, c, d, x[i], 7, -680876936);
    d = md5ff(d, a, b, c, x[i + 1], 12, -389564586);
    c = md5ff(c, d, a, b, x[i + 2], 17, 606105819);
    b = md5ff(b, c, d, a, x[i + 3], 22, -1044525330);
    a = md5ff(a, b, c, d, x[i + 4], 7, -176418897);
    d = md5ff(d, a, b, c, x[i + 5], 12, 1200080426);
    c = md5ff(c, d, a, b, x[i + 6], 17, -1473231341);
    b = md5ff(b, c, d, a, x[i + 7], 22, -45705983);
    a = md5ff(a, b, c, d, x[i + 8], 7, 1770035416);
    d = md5ff(d, a, b, c, x[i + 9], 12, -1958414417);
    c = md5ff(c, d, a, b, x[i + 10], 17, -42063);
    b = md5ff(b, c, d, a, x[i + 11], 22, -1990404162);
    a = md5ff(a, b, c, d, x[i + 12], 7, 1804603682);
    d = md5ff(d, a, b, c, x[i + 13], 12, -40341101);
    c = md5ff(c, d, a, b, x[i + 14], 17, -1502002290);
    b = md5ff(b, c, d, a, x[i + 15], 22, 1236535329);
    a = md5gg(a, b, c, d, x[i + 1], 5, -165796510);
    d = md5gg(d, a, b, c, x[i + 6], 9, -1069501632);
    c = md5gg(c, d, a, b, x[i + 11], 14, 643717713);
    b = md5gg(b, c, d, a, x[i], 20, -373897302);
    a = md5gg(a, b, c, d, x[i + 5], 5, -701558691);
    d = md5gg(d, a, b, c, x[i + 10], 9, 38016083);
    c = md5gg(c, d, a, b, x[i + 15], 14, -660478335);
    b = md5gg(b, c, d, a, x[i + 4], 20, -405537848);
    a = md5gg(a, b, c, d, x[i + 9], 5, 568446438);
    d = md5gg(d, a, b, c, x[i + 14], 9, -1019803690);
    c = md5gg(c, d, a, b, x[i + 3], 14, -187363961);
    b = md5gg(b, c, d, a, x[i + 8], 20, 1163531501);
    a = md5gg(a, b, c, d, x[i + 13], 5, -1444681467);
    d = md5gg(d, a, b, c, x[i + 2], 9, -51403784);
    c = md5gg(c, d, a, b, x[i + 7], 14, 1735328473);
    b = md5gg(b, c, d, a, x[i + 12], 20, -1926607734);
    a = md5hh(a, b, c, d, x[i + 5], 4, -378558);
    d = md5hh(d, a, b, c, x[i + 8], 11, -2022574463);
    c = md5hh(c, d, a, b, x[i + 11], 16, 1839030562);
    b = md5hh(b, c, d, a, x[i + 14], 23, -35309556);
    a = md5hh(a, b, c, d, x[i + 1], 4, -1530992060);
    d = md5hh(d, a, b, c, x[i + 4], 11, 1272893353);
    c = md5hh(c, d, a, b, x[i + 7], 16, -155497632);
    b = md5hh(b, c, d, a, x[i + 10], 23, -1094730640);
    a = md5hh(a, b, c, d, x[i + 13], 4, 681279174);
    d = md5hh(d, a, b, c, x[i], 11, -358537222);
    c = md5hh(c, d, a, b, x[i + 3], 16, -722521979);
    b = md5hh(b, c, d, a, x[i + 6], 23, 76029189);
    a = md5hh(a, b, c, d, x[i + 9], 4, -640364487);
    d = md5hh(d, a, b, c, x[i + 12], 11, -421815835);
    c = md5hh(c, d, a, b, x[i + 15], 16, 530742520);
    b = md5hh(b, c, d, a, x[i + 2], 23, -995338651);
    a = md5ii(a, b, c, d, x[i], 6, -198630844);
    d = md5ii(d, a, b, c, x[i + 7], 10, 1126891415);
    c = md5ii(c, d, a, b, x[i + 14], 15, -1416354905);
    b = md5ii(b, c, d, a, x[i + 5], 21, -57434055);
    a = md5ii(a, b, c, d, x[i + 12], 6, 1700485571);
    d = md5ii(d, a, b, c, x[i + 3], 10, -1894986606);
    c = md5ii(c, d, a, b, x[i + 10], 15, -1051523);
    b = md5ii(b, c, d, a, x[i + 1], 21, -2054922799);
    a = md5ii(a, b, c, d, x[i + 8], 6, 1873313359);
    d = md5ii(d, a, b, c, x[i + 15], 10, -30611744);
    c = md5ii(c, d, a, b, x[i + 6], 15, -1560198380);
    b = md5ii(b, c, d, a, x[i + 13], 21, 1309151649);
    a = md5ii(a, b, c, d, x[i + 4], 6, -145523070);
    d = md5ii(d, a, b, c, x[i + 11], 10, -1120210379);
    c = md5ii(c, d, a, b, x[i + 2], 15, 718787259);
    b = md5ii(b, c, d, a, x[i + 9], 21, -343485551);
    a = safeAdd(a, olda);
    b = safeAdd(b, oldb);
    c = safeAdd(c, oldc);
    d = safeAdd(d, oldd);
  }

  return [a, b, c, d];
}
/*
 * Convert an array bytes to an array of little-endian words
 * Characters >255 have their high-byte silently ignored.
 */


function bytesToWords(input) {
  if (input.length === 0) {
    return [];
  }

  const length8 = input.length * 8;
  const output = new Uint32Array(getOutputLength(length8));

  for (let i = 0; i < length8; i += 8) {
    output[i >> 5] |= (input[i / 8] & 0xff) << i % 32;
  }

  return output;
}
/*
 * Add integers, wrapping at 2^32. This uses 16-bit operations internally
 * to work around bugs in some JS interpreters.
 */


function safeAdd(x, y) {
  const lsw = (x & 0xffff) + (y & 0xffff);
  const msw = (x >> 16) + (y >> 16) + (lsw >> 16);
  return msw << 16 | lsw & 0xffff;
}
/*
 * Bitwise rotate a 32-bit number to the left.
 */


function bitRotateLeft(num, cnt) {
  return num << cnt | num >>> 32 - cnt;
}
/*
 * These functions implement the four basic operations the algorithm uses.
 */


function md5cmn(q, a, b, x, s, t) {
  return safeAdd(bitRotateLeft(safeAdd(safeAdd(a, q), safeAdd(x, t)), s), b);
}

function md5ff(a, b, c, d, x, s, t) {
  return md5cmn(b & c | ~b & d, a, b, x, s, t);
}

function md5gg(a, b, c, d, x, s, t) {
  return md5cmn(b & d | c & ~d, a, b, x, s, t);
}

function md5hh(a, b, c, d, x, s, t) {
  return md5cmn(b ^ c ^ d, a, b, x, s, t);
}

function md5ii(a, b, c, d, x, s, t) {
  return md5cmn(c ^ (b | ~d), a, b, x, s, t);
}

var _default = md5;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/keyring-snap-client>uuid",file:"node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\md5-browser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\native-browser.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-client%5Cnode_modules%5Cuuid%5Cdist%5Cnative-browser.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
const randomUUID = typeof crypto !== 'undefined' && crypto.randomUUID && crypto.randomUUID.bind(crypto);
var _default = {
  randomUUID
};
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/keyring-snap-client>uuid",file:"node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\native-browser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\nil.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-client%5Cnode_modules%5Cuuid%5Cdist%5Cnil.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default = '00000000-0000-0000-0000-000000000000';
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/keyring-snap-client>uuid",file:"node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\nil.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\parse.js", {"./validate.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\validate.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-client%5Cnode_modules%5Cuuid%5Cdist%5Cparse.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _validate = _interopRequireDefault(require("./validate.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function parse(uuid) {
  if (!(0, _validate.default)(uuid)) {
    throw TypeError('Invalid UUID');
  }

  let v;
  const arr = new Uint8Array(16); // Parse ########-....-....-....-............

  arr[0] = (v = parseInt(uuid.slice(0, 8), 16)) >>> 24;
  arr[1] = v >>> 16 & 0xff;
  arr[2] = v >>> 8 & 0xff;
  arr[3] = v & 0xff; // Parse ........-####-....-....-............

  arr[4] = (v = parseInt(uuid.slice(9, 13), 16)) >>> 8;
  arr[5] = v & 0xff; // Parse ........-....-####-....-............

  arr[6] = (v = parseInt(uuid.slice(14, 18), 16)) >>> 8;
  arr[7] = v & 0xff; // Parse ........-....-....-####-............

  arr[8] = (v = parseInt(uuid.slice(19, 23), 16)) >>> 8;
  arr[9] = v & 0xff; // Parse ........-....-....-....-############
  // (Use "/" to avoid 32-bit truncation when bit-shifting high-order bytes)

  arr[10] = (v = parseInt(uuid.slice(24, 36), 16)) / 0x10000000000 & 0xff;
  arr[11] = v / 0x100000000 & 0xff;
  arr[12] = v >>> 24 & 0xff;
  arr[13] = v >>> 16 & 0xff;
  arr[14] = v >>> 8 & 0xff;
  arr[15] = v & 0xff;
  return arr;
}

var _default = parse;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/keyring-snap-client>uuid",file:"node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\parse.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\regex.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-client%5Cnode_modules%5Cuuid%5Cdist%5Cregex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default = /^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/keyring-snap-client>uuid",file:"node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\regex.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\rng-browser.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-client%5Cnode_modules%5Cuuid%5Cdist%5Crng-browser.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = rng;
// Unique ID creation requires a high quality random # generator. In the browser we therefore
// require the crypto API and do not support built-in fallback to lower quality random number
// generators (like Math.random()).
let getRandomValues;
const rnds8 = new Uint8Array(16);

function rng() {
  // lazy load so that environments that need to polyfill have a chance to do so
  if (!getRandomValues) {
    // getRandomValues needs to be invoked in a context where "this" is a Crypto implementation.
    getRandomValues = typeof crypto !== 'undefined' && crypto.getRandomValues && crypto.getRandomValues.bind(crypto);

    if (!getRandomValues) {
      throw new Error('crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported');
    }
  }

  return getRandomValues(rnds8);
}
      };
    };
  }
  }
}, {package:"@metamask/keyring-snap-client>uuid",file:"node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\rng-browser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\sha1-browser.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-client%5Cnode_modules%5Cuuid%5Cdist%5Csha1-browser.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

// Adapted from Chris Veness' SHA1 code at
// http://www.movable-type.co.uk/scripts/sha1.html
function f(s, x, y, z) {
  switch (s) {
    case 0:
      return x & y ^ ~x & z;

    case 1:
      return x ^ y ^ z;

    case 2:
      return x & y ^ x & z ^ y & z;

    case 3:
      return x ^ y ^ z;
  }
}

function ROTL(x, n) {
  return x << n | x >>> 32 - n;
}

function sha1(bytes) {
  const K = [0x5a827999, 0x6ed9eba1, 0x8f1bbcdc, 0xca62c1d6];
  const H = [0x67452301, 0xefcdab89, 0x98badcfe, 0x10325476, 0xc3d2e1f0];

  if (typeof bytes === 'string') {
    const msg = unescape(encodeURIComponent(bytes)); // UTF8 escape

    bytes = [];

    for (let i = 0; i < msg.length; ++i) {
      bytes.push(msg.charCodeAt(i));
    }
  } else if (!Array.isArray(bytes)) {
    // Convert Array-like to Array
    bytes = Array.prototype.slice.call(bytes);
  }

  bytes.push(0x80);
  const l = bytes.length / 4 + 2;
  const N = Math.ceil(l / 16);
  const M = new Array(N);

  for (let i = 0; i < N; ++i) {
    const arr = new Uint32Array(16);

    for (let j = 0; j < 16; ++j) {
      arr[j] = bytes[i * 64 + j * 4] << 24 | bytes[i * 64 + j * 4 + 1] << 16 | bytes[i * 64 + j * 4 + 2] << 8 | bytes[i * 64 + j * 4 + 3];
    }

    M[i] = arr;
  }

  M[N - 1][14] = (bytes.length - 1) * 8 / Math.pow(2, 32);
  M[N - 1][14] = Math.floor(M[N - 1][14]);
  M[N - 1][15] = (bytes.length - 1) * 8 & 0xffffffff;

  for (let i = 0; i < N; ++i) {
    const W = new Uint32Array(80);

    for (let t = 0; t < 16; ++t) {
      W[t] = M[i][t];
    }

    for (let t = 16; t < 80; ++t) {
      W[t] = ROTL(W[t - 3] ^ W[t - 8] ^ W[t - 14] ^ W[t - 16], 1);
    }

    let a = H[0];
    let b = H[1];
    let c = H[2];
    let d = H[3];
    let e = H[4];

    for (let t = 0; t < 80; ++t) {
      const s = Math.floor(t / 20);
      const T = ROTL(a, 5) + f(s, b, c, d) + e + K[s] + W[t] >>> 0;
      e = d;
      d = c;
      c = ROTL(b, 30) >>> 0;
      b = a;
      a = T;
    }

    H[0] = H[0] + a >>> 0;
    H[1] = H[1] + b >>> 0;
    H[2] = H[2] + c >>> 0;
    H[3] = H[3] + d >>> 0;
    H[4] = H[4] + e >>> 0;
  }

  return [H[0] >> 24 & 0xff, H[0] >> 16 & 0xff, H[0] >> 8 & 0xff, H[0] & 0xff, H[1] >> 24 & 0xff, H[1] >> 16 & 0xff, H[1] >> 8 & 0xff, H[1] & 0xff, H[2] >> 24 & 0xff, H[2] >> 16 & 0xff, H[2] >> 8 & 0xff, H[2] & 0xff, H[3] >> 24 & 0xff, H[3] >> 16 & 0xff, H[3] >> 8 & 0xff, H[3] & 0xff, H[4] >> 24 & 0xff, H[4] >> 16 & 0xff, H[4] >> 8 & 0xff, H[4] & 0xff];
}

var _default = sha1;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/keyring-snap-client>uuid",file:"node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\sha1-browser.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\stringify.js", {"./validate.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\validate.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-client%5Cnode_modules%5Cuuid%5Cdist%5Cstringify.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.unsafeStringify = unsafeStringify;

var _validate = _interopRequireDefault(require("./validate.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Convert array of 16 byte values to UUID string format of the form:
 * XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX
 */
const byteToHex = [];

for (let i = 0; i < 256; ++i) {
  byteToHex.push((i + 0x100).toString(16).slice(1));
}

function unsafeStringify(arr, offset = 0) {
  // Note: Be careful editing this code!  It's been tuned for performance
  // and works in ways you may not expect. See https://github.com/uuidjs/uuid/pull/434
  return byteToHex[arr[offset + 0]] + byteToHex[arr[offset + 1]] + byteToHex[arr[offset + 2]] + byteToHex[arr[offset + 3]] + '-' + byteToHex[arr[offset + 4]] + byteToHex[arr[offset + 5]] + '-' + byteToHex[arr[offset + 6]] + byteToHex[arr[offset + 7]] + '-' + byteToHex[arr[offset + 8]] + byteToHex[arr[offset + 9]] + '-' + byteToHex[arr[offset + 10]] + byteToHex[arr[offset + 11]] + byteToHex[arr[offset + 12]] + byteToHex[arr[offset + 13]] + byteToHex[arr[offset + 14]] + byteToHex[arr[offset + 15]];
}

function stringify(arr, offset = 0) {
  const uuid = unsafeStringify(arr, offset); // Consistency check for valid UUID.  If this throws, it's likely due to one
  // of the following:
  // - One or more input array values don't map to a hex octet (leading to
  // "undefined" in the uuid)
  // - Invalid input values for the RFC `version` or `variant` fields

  if (!(0, _validate.default)(uuid)) {
    throw TypeError('Stringified UUID is invalid');
  }

  return uuid;
}

var _default = stringify;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/keyring-snap-client>uuid",file:"node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\stringify.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\v1.js", {"./rng.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\rng-browser.js","./stringify.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\stringify.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-client%5Cnode_modules%5Cuuid%5Cdist%5Cv1.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _rng = _interopRequireDefault(require("./rng.js"));

var _stringify = require("./stringify.js");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// **`v1()` - Generate time-based UUID**
//
// Inspired by https://github.com/LiosK/UUID.js
// and http://docs.python.org/library/uuid.html
let _nodeId;

let _clockseq; // Previous uuid creation time


let _lastMSecs = 0;
let _lastNSecs = 0; // See https://github.com/uuidjs/uuid for API details

function v1(options, buf, offset) {
  let i = buf && offset || 0;
  const b = buf || new Array(16);
  options = options || {};
  let node = options.node || _nodeId;
  let clockseq = options.clockseq !== undefined ? options.clockseq : _clockseq; // node and clockseq need to be initialized to random values if they're not
  // specified.  We do this lazily to minimize issues related to insufficient
  // system entropy.  See #189

  if (node == null || clockseq == null) {
    const seedBytes = options.random || (options.rng || _rng.default)();

    if (node == null) {
      // Per 4.5, create and 48-bit node id, (47 random bits + multicast bit = 1)
      node = _nodeId = [seedBytes[0] | 0x01, seedBytes[1], seedBytes[2], seedBytes[3], seedBytes[4], seedBytes[5]];
    }

    if (clockseq == null) {
      // Per 4.2.2, randomize (14 bit) clockseq
      clockseq = _clockseq = (seedBytes[6] << 8 | seedBytes[7]) & 0x3fff;
    }
  } // UUID timestamps are 100 nano-second units since the Gregorian epoch,
  // (1582-10-15 00:00).  JSNumbers aren't precise enough for this, so
  // time is handled internally as 'msecs' (integer milliseconds) and 'nsecs'
  // (100-nanoseconds offset from msecs) since unix epoch, 1970-01-01 00:00.


  let msecs = options.msecs !== undefined ? options.msecs : Date.now(); // Per 4.2.1.2, use count of uuid's generated during the current clock
  // cycle to simulate higher resolution clock

  let nsecs = options.nsecs !== undefined ? options.nsecs : _lastNSecs + 1; // Time since last uuid creation (in msecs)

  const dt = msecs - _lastMSecs + (nsecs - _lastNSecs) / 10000; // Per 4.2.1.2, Bump clockseq on clock regression

  if (dt < 0 && options.clockseq === undefined) {
    clockseq = clockseq + 1 & 0x3fff;
  } // Reset nsecs if clock regresses (new clockseq) or we've moved onto a new
  // time interval


  if ((dt < 0 || msecs > _lastMSecs) && options.nsecs === undefined) {
    nsecs = 0;
  } // Per 4.2.1.2 Throw error if too many uuids are requested


  if (nsecs >= 10000) {
    throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");
  }

  _lastMSecs = msecs;
  _lastNSecs = nsecs;
  _clockseq = clockseq; // Per 4.1.4 - Convert from unix epoch to Gregorian epoch

  msecs += 12219292800000; // `time_low`

  const tl = ((msecs & 0xfffffff) * 10000 + nsecs) % 0x100000000;
  b[i++] = tl >>> 24 & 0xff;
  b[i++] = tl >>> 16 & 0xff;
  b[i++] = tl >>> 8 & 0xff;
  b[i++] = tl & 0xff; // `time_mid`

  const tmh = msecs / 0x100000000 * 10000 & 0xfffffff;
  b[i++] = tmh >>> 8 & 0xff;
  b[i++] = tmh & 0xff; // `time_high_and_version`

  b[i++] = tmh >>> 24 & 0xf | 0x10; // include version

  b[i++] = tmh >>> 16 & 0xff; // `clock_seq_hi_and_reserved` (Per 4.2.2 - include variant)

  b[i++] = clockseq >>> 8 | 0x80; // `clock_seq_low`

  b[i++] = clockseq & 0xff; // `node`

  for (let n = 0; n < 6; ++n) {
    b[i + n] = node[n];
  }

  return buf || (0, _stringify.unsafeStringify)(b);
}

var _default = v1;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/keyring-snap-client>uuid",file:"node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\v1.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\v3.js", {"./md5.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\md5-browser.js","./v35.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\v35.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-client%5Cnode_modules%5Cuuid%5Cdist%5Cv3.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _v = _interopRequireDefault(require("./v35.js"));

var _md = _interopRequireDefault(require("./md5.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const v3 = (0, _v.default)('v3', 0x30, _md.default);
var _default = v3;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/keyring-snap-client>uuid",file:"node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\v3.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\v35.js", {"./parse.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\parse.js","./stringify.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\stringify.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-client%5Cnode_modules%5Cuuid%5Cdist%5Cv35.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URL = exports.DNS = void 0;
exports.default = v35;

var _stringify = require("./stringify.js");

var _parse = _interopRequireDefault(require("./parse.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function stringToBytes(str) {
  str = unescape(encodeURIComponent(str)); // UTF8 escape

  const bytes = [];

  for (let i = 0; i < str.length; ++i) {
    bytes.push(str.charCodeAt(i));
  }

  return bytes;
}

const DNS = '6ba7b810-9dad-11d1-80b4-00c04fd430c8';
exports.DNS = DNS;
const URL = '6ba7b811-9dad-11d1-80b4-00c04fd430c8';
exports.URL = URL;

function v35(name, version, hashfunc) {
  function generateUUID(value, namespace, buf, offset) {
    var _namespace;

    if (typeof value === 'string') {
      value = stringToBytes(value);
    }

    if (typeof namespace === 'string') {
      namespace = (0, _parse.default)(namespace);
    }

    if (((_namespace = namespace) === null || _namespace === void 0 ? void 0 : _namespace.length) !== 16) {
      throw TypeError('Namespace must be array-like (16 iterable integer values, 0-255)');
    } // Compute hash of namespace and value, Per 4.3
    // Future: Use spread syntax when supported on all platforms, e.g. `bytes =
    // hashfunc([...namespace, ... value])`


    let bytes = new Uint8Array(16 + value.length);
    bytes.set(namespace);
    bytes.set(value, namespace.length);
    bytes = hashfunc(bytes);
    bytes[6] = bytes[6] & 0x0f | version;
    bytes[8] = bytes[8] & 0x3f | 0x80;

    if (buf) {
      offset = offset || 0;

      for (let i = 0; i < 16; ++i) {
        buf[offset + i] = bytes[i];
      }

      return buf;
    }

    return (0, _stringify.unsafeStringify)(bytes);
  } // Function#name is not settable on some platforms (#270)


  try {
    generateUUID.name = name; // eslint-disable-next-line no-empty
  } catch (err) {} // For CommonJS default export support


  generateUUID.DNS = DNS;
  generateUUID.URL = URL;
  return generateUUID;
}
      };
    };
  }
  }
}, {package:"@metamask/keyring-snap-client>uuid",file:"node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\v35.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\v4.js", {"./native.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\native-browser.js","./rng.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\rng-browser.js","./stringify.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\stringify.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-client%5Cnode_modules%5Cuuid%5Cdist%5Cv4.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _native = _interopRequireDefault(require("./native.js"));

var _rng = _interopRequireDefault(require("./rng.js"));

var _stringify = require("./stringify.js");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function v4(options, buf, offset) {
  if (_native.default.randomUUID && !buf && !options) {
    return _native.default.randomUUID();
  }

  options = options || {};

  const rnds = options.random || (options.rng || _rng.default)(); // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`


  rnds[6] = rnds[6] & 0x0f | 0x40;
  rnds[8] = rnds[8] & 0x3f | 0x80; // Copy bytes to buffer, if provided

  if (buf) {
    offset = offset || 0;

    for (let i = 0; i < 16; ++i) {
      buf[offset + i] = rnds[i];
    }

    return buf;
  }

  return (0, _stringify.unsafeStringify)(rnds);
}

var _default = v4;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/keyring-snap-client>uuid",file:"node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\v4.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\v5.js", {"./sha1.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\sha1-browser.js","./v35.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\v35.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-client%5Cnode_modules%5Cuuid%5Cdist%5Cv5.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _v = _interopRequireDefault(require("./v35.js"));

var _sha = _interopRequireDefault(require("./sha1.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const v5 = (0, _v.default)('v5', 0x50, _sha.default);
var _default = v5;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/keyring-snap-client>uuid",file:"node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\v5.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\validate.js", {"./regex.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\regex.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-client%5Cnode_modules%5Cuuid%5Cdist%5Cvalidate.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _regex = _interopRequireDefault(require("./regex.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function validate(uuid) {
  return typeof uuid === 'string' && _regex.default.test(uuid);
}

var _default = validate;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/keyring-snap-client>uuid",file:"node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\validate.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\version.js", {"./validate.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\validate.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-client%5Cnode_modules%5Cuuid%5Cdist%5Cversion.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _validate = _interopRequireDefault(require("./validate.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function version(uuid) {
  if (!(0, _validate.default)(uuid)) {
    throw TypeError('Invalid UUID');
  }

  return parseInt(uuid.slice(14, 15), 16);
}

var _default = version;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@metamask/keyring-snap-client>uuid",file:"node_modules\\@metamask\\keyring-snap-client\\node_modules\\uuid\\dist\\version.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-sdk\\dist\\index.cjs", {"./methods.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-sdk\\dist\\methods.cjs","./rpc-handler.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-sdk\\dist\\rpc-handler.cjs","./snap-utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-sdk\\dist\\snap-utils.cjs","./time.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-sdk\\dist\\time.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-sdk%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./rpc-handler.cjs"), exports);
__exportStar(require("./snap-utils.cjs"), exports);
__exportStar(require("./time.cjs"), exports);
__exportStar(require("./methods.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring>@metamask/keyring-snap-sdk",file:"node_modules\\@metamask\\keyring-snap-sdk\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-sdk\\dist\\methods.cjs", {"@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-sdk%5Cdist%5Cmethods.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetSelectedAccountsResponseStruct = exports.GetSelectedAccountsRequestStruct = exports.SnapManageAccountsMethod = void 0;
const superstruct_1 = require("@metamask/superstruct");
var SnapManageAccountsMethod;
(function (SnapManageAccountsMethod) {
    SnapManageAccountsMethod["GetSelectedAccounts"] = "getSelectedAccounts";
})(SnapManageAccountsMethod || (exports.SnapManageAccountsMethod = SnapManageAccountsMethod = {}));
exports.GetSelectedAccountsRequestStruct = (0, superstruct_1.object)({
    method: (0, superstruct_1.literal)(SnapManageAccountsMethod.GetSelectedAccounts),
});
exports.GetSelectedAccountsResponseStruct = (0, superstruct_1.array)((0, superstruct_1.string)());

      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring>@metamask/keyring-snap-sdk",file:"node_modules\\@metamask\\keyring-snap-sdk\\dist\\methods.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-sdk\\dist\\rpc-handler.cjs", {"@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-sdk%5Cdist%5Crpc-handler.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MethodNotSupportedError = void 0;
exports.handleKeyringRequest = handleKeyringRequest;
const keyring_api_1 = require("@metamask/keyring-api");
const keyring_utils_1 = require("@metamask/keyring-utils");
const superstruct_1 = require("@metamask/superstruct");
/**
 * Error thrown when a keyring JSON-RPC method is not supported.
 */
class MethodNotSupportedError extends Error {
    constructor(method) {
        super(`Method not supported: ${method}`);
    }
}
exports.MethodNotSupportedError = MethodNotSupportedError;
/**
 * Inner function that dispatches JSON-RPC request to the associated Keyring
 * methods.
 *
 * @param keyring - Keyring instance.
 * @param request - Keyring JSON-RPC request.
 * @returns A promise that resolves to the keyring response.
 */
async function dispatchRequest(keyring, request) {
    // We first have to make sure that the request is a valid JSON-RPC request so
    // we can check its method name.
    (0, superstruct_1.assert)(request, keyring_utils_1.JsonRpcRequestStruct);
    switch (request.method) {
        case `${keyring_api_1.KeyringRpcMethod.ListAccounts}`: {
            (0, superstruct_1.assert)(request, keyring_api_1.ListAccountsRequestStruct);
            return keyring.listAccounts();
        }
        case `${keyring_api_1.KeyringRpcMethod.GetAccount}`: {
            (0, superstruct_1.assert)(request, keyring_api_1.GetAccountRequestStruct);
            return keyring.getAccount(request.params.id);
        }
        case `${keyring_api_1.KeyringRpcMethod.CreateAccount}`: {
            (0, superstruct_1.assert)(request, keyring_api_1.CreateAccountRequestStruct);
            return keyring.createAccount(request.params.options);
        }
        case `${keyring_api_1.KeyringRpcMethod.DiscoverAccounts}`: {
            if (keyring.discoverAccounts === undefined) {
                throw new MethodNotSupportedError(request.method);
            }
            (0, superstruct_1.assert)(request, keyring_api_1.DiscoverAccountsRequestStruct);
            return keyring.discoverAccounts(request.params.scopes, request.params.entropySource, request.params.groupIndex);
        }
        case `${keyring_api_1.KeyringRpcMethod.ListAccountTransactions}`: {
            if (keyring.listAccountTransactions === undefined) {
                throw new MethodNotSupportedError(request.method);
            }
            (0, superstruct_1.assert)(request, keyring_api_1.ListAccountTransactionsRequestStruct);
            return keyring.listAccountTransactions(request.params.id, request.params.pagination);
        }
        case `${keyring_api_1.KeyringRpcMethod.ListAccountAssets}`: {
            if (keyring.listAccountAssets === undefined) {
                throw new MethodNotSupportedError(request.method);
            }
            (0, superstruct_1.assert)(request, keyring_api_1.ListAccountAssetsRequestStruct);
            return keyring.listAccountAssets(request.params.id);
        }
        case `${keyring_api_1.KeyringRpcMethod.GetAccountBalances}`: {
            if (keyring.getAccountBalances === undefined) {
                throw new MethodNotSupportedError(request.method);
            }
            (0, superstruct_1.assert)(request, keyring_api_1.GetAccountBalancesRequestStruct);
            return keyring.getAccountBalances(request.params.id, request.params.assets);
        }
        case `${keyring_api_1.KeyringRpcMethod.ResolveAccountAddress}`: {
            if (keyring.resolveAccountAddress === undefined) {
                throw new MethodNotSupportedError(request.method);
            }
            (0, superstruct_1.assert)(request, keyring_api_1.ResolveAccountAddressRequestStruct);
            return keyring.resolveAccountAddress(request.params.scope, request.params.request);
        }
        case `${keyring_api_1.KeyringRpcMethod.SetSelectedAccounts}`: {
            if (keyring.setSelectedAccounts === undefined) {
                throw new MethodNotSupportedError(request.method);
            }
            (0, superstruct_1.assert)(request, keyring_api_1.SetSelectedAccountsRequestStruct);
            return keyring.setSelectedAccounts(request.params.accounts);
        }
        case `${keyring_api_1.KeyringRpcMethod.FilterAccountChains}`: {
            (0, superstruct_1.assert)(request, keyring_api_1.FilterAccountChainsStruct);
            return keyring.filterAccountChains(request.params.id, request.params.chains);
        }
        case `${keyring_api_1.KeyringRpcMethod.UpdateAccount}`: {
            (0, superstruct_1.assert)(request, keyring_api_1.UpdateAccountRequestStruct);
            return keyring.updateAccount(request.params.account);
        }
        case `${keyring_api_1.KeyringRpcMethod.DeleteAccount}`: {
            (0, superstruct_1.assert)(request, keyring_api_1.DeleteAccountRequestStruct);
            return keyring.deleteAccount(request.params.id);
        }
        case `${keyring_api_1.KeyringRpcMethod.ExportAccount}`: {
            if (keyring.exportAccount === undefined) {
                throw new MethodNotSupportedError(request.method);
            }
            (0, superstruct_1.assert)(request, keyring_api_1.ExportAccountRequestStruct);
            return keyring.exportAccount(request.params.id);
        }
        case `${keyring_api_1.KeyringRpcMethod.ListRequests}`: {
            if (keyring.listRequests === undefined) {
                throw new MethodNotSupportedError(request.method);
            }
            (0, superstruct_1.assert)(request, keyring_api_1.ListRequestsRequestStruct);
            return keyring.listRequests();
        }
        case `${keyring_api_1.KeyringRpcMethod.GetRequest}`: {
            if (keyring.getRequest === undefined) {
                throw new MethodNotSupportedError(request.method);
            }
            (0, superstruct_1.assert)(request, keyring_api_1.GetRequestRequestStruct);
            return keyring.getRequest(request.params.id);
        }
        case `${keyring_api_1.KeyringRpcMethod.SubmitRequest}`: {
            (0, superstruct_1.assert)(request, keyring_api_1.SubmitRequestRequestStruct);
            return keyring.submitRequest(request.params);
        }
        case `${keyring_api_1.KeyringRpcMethod.ApproveRequest}`: {
            if (keyring.approveRequest === undefined) {
                throw new MethodNotSupportedError(request.method);
            }
            (0, superstruct_1.assert)(request, keyring_api_1.ApproveRequestRequestStruct);
            return keyring.approveRequest(request.params.id, request.params.data);
        }
        case `${keyring_api_1.KeyringRpcMethod.RejectRequest}`: {
            if (keyring.rejectRequest === undefined) {
                throw new MethodNotSupportedError(request.method);
            }
            (0, superstruct_1.assert)(request, keyring_api_1.RejectRequestRequestStruct);
            return keyring.rejectRequest(request.params.id);
        }
        default: {
            throw new MethodNotSupportedError(request.method);
        }
    }
}
/**
 * Handles a keyring JSON-RPC request.
 *
 * This function is meant to be used as a handler for Keyring JSON-RPC requests
 * in an Accounts Snap.
 *
 * @param keyring - Keyring instance.
 * @param request - Keyring JSON-RPC request.
 * @returns A promise that resolves to the keyring response.
 * @example
 * ```ts
 * export const onKeyringRequest: OnKeyringRequestHandler = async ({
 *   origin,
 *   request,
 * }) => {
 *   return await handleKeyringRequest(keyring, request);
 * };
 * ```
 */
async function handleKeyringRequest(keyring, request) {
    try {
        return await dispatchRequest(keyring, request);
    }
    catch (error) {
        const message = error instanceof Error && typeof error.message === 'string'
            ? error.message
            : 'An unknown error occurred while handling the keyring request';
        throw new Error(message);
    }
}

      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring>@metamask/keyring-snap-sdk",file:"node_modules\\@metamask\\keyring-snap-sdk\\dist\\rpc-handler.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-sdk\\dist\\snap-utils.cjs", {"./methods.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-sdk\\dist\\methods.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-sdk%5Cdist%5Csnap-utils.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.emitSnapKeyringEvent = emitSnapKeyringEvent;
exports.getSelectedAccounts = getSelectedAccounts;
const superstruct_1 = require("@metamask/superstruct");
const methods_1 = require("./methods.cjs");
/**
 * Emit a keyring event from a snap.
 *
 * @param snap - The global snap object.
 * @param event - The event name.
 * @param data - The event data.
 */
async function emitSnapKeyringEvent(snap, event, data) {
    await snap.request({
        method: 'snap_manageAccounts',
        params: {
            method: event,
            params: { ...data },
        },
    });
}
/**
 * Get the selected accounts from a snap.
 *
 * @param snap - The global snap object.
 * @returns The selected accounts.
 */
async function getSelectedAccounts(snap) {
    const response = await snap.request({
        method: 'snap_manageAccounts',
        params: {
            method: methods_1.SnapManageAccountsMethod.GetSelectedAccounts,
        },
    });
    (0, superstruct_1.assert)(response, methods_1.GetSelectedAccountsResponseStruct);
    return response;
}

      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring>@metamask/keyring-snap-sdk",file:"node_modules\\@metamask\\keyring-snap-sdk\\dist\\snap-utils.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-snap-sdk\\dist\\time.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-snap-sdk%5Cdist%5Ctime.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toUnixTimestamp = toUnixTimestamp;
exports.getCurrentUnixTimestamp = getCurrentUnixTimestamp;
/**
 * Convert a date to its UNIX timestamp equivalent.
 *
 * @param date - The date object to convert.
 * @returns A UNIX timestamp.
 */
function toUnixTimestamp(date) {
    return Math.floor(date.getTime() / 1000);
}
/**
 * Get the current UNIX timestamp.
 *
 * @returns The current UNIX timestamp.
 */
function getCurrentUnixTimestamp() {
    return toUnixTimestamp(new Date());
}

      };
    };
  }
  }
}, {package:"@metamask/eth-snap-keyring>@metamask/keyring-snap-sdk",file:"node_modules\\@metamask\\keyring-snap-sdk\\dist\\time.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\JsonRpcRequest.cjs", {"./index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-utils%5Cdist%5CJsonRpcRequest.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonRpcRequestStruct = void 0;
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const _1 = require("./index.cjs");
exports.JsonRpcRequestStruct = (0, _1.object)({
    jsonrpc: (0, superstruct_1.literal)('2.0'),
    id: (0, superstruct_1.union)([(0, superstruct_1.string)(), (0, superstruct_1.number)(), (0, superstruct_1.literal)(null)]),
    method: (0, superstruct_1.string)(),
    params: (0, _1.exactOptional)((0, superstruct_1.union)([(0, superstruct_1.array)(utils_1.JsonStruct), (0, superstruct_1.record)((0, superstruct_1.string)(), utils_1.JsonStruct)])),
});

      };
    };
  }
  }
}, {package:"@metamask/keyring-utils",file:"node_modules\\@metamask\\keyring-utils\\dist\\JsonRpcRequest.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\btc\\address.cjs", {"bitcoin-address-validation":"D:\\code\\v\\metamask-extension\\node_modules\\bitcoin-address-validation\\lib\\index.cjs.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-utils%5Cdist%5Cbtc%5Caddress.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isBtcMainnetAddress = isBtcMainnetAddress;
exports.isBtcTestnetAddress = isBtcTestnetAddress;
const bitcoin_address_validation_1 = require("bitcoin-address-validation");
/**
 * Returns whether an address is on the Bitcoin mainnet.
 *
 * @param address - The address to check.
 * @returns `true` if the address is on the Bitcoin mainnet, `false` otherwise.
 */
function isBtcMainnetAddress(address) {
    return (0, bitcoin_address_validation_1.validate)(address, bitcoin_address_validation_1.Network.mainnet);
}
/**
 * Returns whether an address is on the Bitcoin testnet.
 *
 * @param address - The address to check.
 * @returns `true` if the address is on the Bitcoin testnet, `false` otherwise.
 */
function isBtcTestnetAddress(address) {
    return (0, bitcoin_address_validation_1.validate)(address, bitcoin_address_validation_1.Network.testnet);
}

      };
    };
  }
  }
}, {package:"@metamask/keyring-utils",file:"node_modules\\@metamask\\keyring-utils\\dist\\btc\\address.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\btc\\index.cjs", {"./address.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\btc\\address.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-utils%5Cdist%5Cbtc%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./address.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/keyring-utils",file:"node_modules\\@metamask\\keyring-utils\\dist\\btc\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs", {"./JsonRpcRequest.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\JsonRpcRequest.cjs","./btc/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\btc\\index.cjs","./scopes.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\scopes.cjs","./superstruct.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\superstruct.cjs","./types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\types.cjs","./typing.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\typing.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-utils%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./btc/index.cjs"), exports);
__exportStar(require("./types.cjs"), exports);
__exportStar(require("./typing.cjs"), exports);
__exportStar(require("./scopes.cjs"), exports);
__exportStar(require("./superstruct.cjs"), exports);
__exportStar(require("./JsonRpcRequest.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/keyring-utils",file:"node_modules\\@metamask\\keyring-utils\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\scopes.cjs", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-utils%5Cdist%5Cscopes.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ETH_SCOPE_EOA = void 0;
exports.isScopeEqual = isScopeEqual;
exports.isScopeEqualToAny = isScopeEqualToAny;
const utils_1 = require("@metamask/utils");
// We do not use the `EthScope` from `@metamask/keyring-api` here to avoid pulling it
// as a dependency.
exports.ETH_SCOPE_EOA = `${utils_1.KnownCaipNamespace.Eip155}:0`;
// We use a string prefix when comparing EOAs to avoid unecessary splits.
const ETH_SCOPE_PREFIX = `${utils_1.KnownCaipNamespace.Eip155}:`;
/**
 * Check if scope matches another scope. It also supports the special
 * case of `eip155:0` for EVM EOA chain ID which is compatible with any EVM chain
 * ID (`eip155:*`).
 *
 * @param scope - The scope (CAIP-2 chain ID) to check.
 * @param other - Another scope to compare to.
 * @returns True if both scope are compatible, false otherwise.
 */
function isScopeEqual(scope, other) {
    const isScopeEoa = scope === exports.ETH_SCOPE_EOA;
    const isOtherEoa = other === exports.ETH_SCOPE_EOA;
    // Special case for EOA scopes (we check on both sides).
    if (isScopeEoa) {
        return other.startsWith(ETH_SCOPE_PREFIX);
    }
    if (isOtherEoa) {
        return scope.startsWith(ETH_SCOPE_PREFIX);
    }
    // Normal case, if both scopes strictly match, then they are compatible.
    return scope === other;
}
/**
 * Check if `scope` matches any scope from `scopes`. It also supports the special
 * case of `eip155:0` for EVM EOA chain ID which is compatible with any EVM chain
 * ID (`eip155:*`).
 *
 * @param scope - The scope (CAIP-2 chain ID) to check.
 * @param scopes - The list of scopes to check against.
 * @returns True if `scope` matches any scope from `scopes`, false otherwise.
 */
function isScopeEqualToAny(scope, scopes) {
    return scopes.some((other) => isScopeEqual(scope, other));
}

      };
    };
  }
  }
}, {package:"@metamask/keyring-utils",file:"node_modules\\@metamask\\keyring-utils\\dist\\scopes.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\superstruct.cjs", {"@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-utils%5Cdist%5Csuperstruct.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.object = object;
exports.type = type;
exports.exactOptional = exactOptional;
exports.strictMask = strictMask;
exports.selectiveUnion = selectiveUnion;
const superstruct_1 = require("@metamask/superstruct");
/**
 * Change the return type of a superstruct's `object` function to support
 * exact optional properties.
 *
 * @param schema - The object schema.
 * @returns A struct representing an object with a known set of properties.
 */
function object(schema) {
    return (0, superstruct_1.object)(schema);
}
/**
 * Change the return type of a superstruct's `type` function to support
 * exact optional properties.
 *
 * @param schema - The object schema.
 * @returns A struct representing an object with a known set of properties
 * and ignore unknown properties.
 */
function type(schema) {
    return (0, superstruct_1.type)(schema);
}
/**
 * Check if the current property is present in its parent object.
 *
 * @param ctx - The context to check.
 * @returns `true` if the property is present, `false` otherwise.
 */
function hasOptional(ctx) {
    const property = ctx.path[ctx.path.length - 1];
    const parent = ctx.branch[ctx.branch.length - 2];
    return property in parent;
}
/**
 * Augment a struct to allow exact-optional values. Exact-optional values can
 * be omitted but cannot be `undefined`.
 *
 * ```ts
 * const foo = object({ bar: exactOptional(string()) });
 * type Foo = Infer<typeof foo>;
 * // Foo = { bar?: string }
 * ```
 *
 * @param struct - The struct to augment.
 * @returns The augmented struct.
 */
function exactOptional(struct) {
    return new superstruct_1.Struct({
        ...struct,
        validator: (value, ctx) => !hasOptional(ctx) || struct.validator(value, ctx),
        refiner: (value, ctx) => !hasOptional(ctx) || struct.refiner(value, ctx),
    });
}
/**
 * Assert that a value is valid according to a struct.
 *
 * It is similar to superstruct's mask function, but it does not ignore extra
 * properties.
 *
 * @param value - Value to check.
 * @param struct - Struct to validate the value against.
 * @param message - Error message to throw if the value is not valid.
 * @returns The value if it is valid.
 */
function strictMask(value, struct, message) {
    (0, superstruct_1.assert)(value, struct, message);
    return value;
}
/**
 * Create a custom union struct that uses a `selector` function for choosing
 * the validation path.
 *
 * @param selector - The selector function choosing the struct to validate with.
 * @returns The `superstruct` struct, which validates that the value satisfies
 * one of the structs.
 */
function selectiveUnion(selector) {
    return new superstruct_1.Struct({
        type: 'union',
        schema: null,
        *entries(value, context) {
            yield* selector(value).entries(value, context);
        },
        *refiner(value, context) {
            yield* selector(value).refiner(value, context);
        },
        coercer(value, context) {
            return selector(value).coercer(value, context);
        },
        validator(value, context) {
            // This only validates the root of the struct, entries does the rest of
            // the work.
            return selector(value).validator(value, context);
        },
    });
}

      };
    };
  }
  }
}, {package:"@metamask/keyring-utils",file:"node_modules\\@metamask\\keyring-utils\\dist\\superstruct.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\types.cjs", {"@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-utils%5Cdist%5Ctypes.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StringNumberStruct = exports.UrlStruct = exports.AccountIdStruct = exports.UuidStruct = void 0;
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
/**
 * UUIDv4 struct.
 */
exports.UuidStruct = (0, utils_1.definePattern)('UuidV4', /^[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/iu);
/**
 * Account ID (UUIDv4).
 */
exports.AccountIdStruct = exports.UuidStruct; // Alias for better naming purposes.
/**
 * Validates if a given value is a valid URL.
 *
 * @param value - The value to be validated.
 * @returns A boolean indicating if the value is a valid URL.
 */
exports.UrlStruct = (0, superstruct_1.define)('Url', (value) => {
    try {
        const url = new URL(value);
        return url.protocol === 'http:' || url.protocol === 'https:';
    }
    catch {
        return false;
    }
});
/**
 * A string which contains a positive float number.
 */
exports.StringNumberStruct = (0, utils_1.definePattern)('StringNumber', /^\d+(\.\d+)?$/u);

      };
    };
  }
  }
}, {package:"@metamask/keyring-utils",file:"node_modules\\@metamask\\keyring-utils\\dist\\types.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\typing.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ckeyring-utils%5Cdist%5Ctyping.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.expectTrue = expectTrue;
/**
 * Assert that a type extends `true`. It can be used, for example, to assert
 * that a given type extends another type.
 *
 * @example
 * ```ts
 * expectTrue<Extends<{a: string, b: string}, {a: string}>>(); // Ok
 * expectTrue<Extends<{a: string}, {a: string, b: string}>>(); // Error
 * ```
 *
 * This function follows the naming pattern used on `tsd`.
 */
// eslint-disable-next-line @typescript-eslint/no-unused-vars
function expectTrue() {
    // Intentionally empty
}

      };
    };
  }
  }
}, {package:"@metamask/keyring-utils",file:"node_modules\\@metamask\\keyring-utils\\dist\\typing.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\logging-controller\\dist\\LoggingController.cjs", {"@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","uuid":"D:\\code\\v\\metamask-extension\\node_modules\\uuid\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Clogging-controller%5Cdist%5CLoggingController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _LoggingController_instances, _LoggingController_generateId;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoggingController = void 0;
const base_controller_1 = require("@metamask/base-controller");
const uuid_1 = require("uuid");
const name = 'LoggingController';
const metadata = {
    logs: { persist: true, anonymous: false },
};
const defaultState = {
    logs: {},
};
/**
 * Controller that manages a list of logs for signature requests.
 */
class LoggingController extends base_controller_1.BaseController {
    /**
     * Creates a LoggingController instance.
     *
     * @param options - Constructor options
     * @param options.messenger - An instance of the Messenger
     * @param options.state - Initial state to set on this controller.
     */
    constructor({ messenger, state, }) {
        super({
            name,
            metadata,
            messenger,
            state: {
                ...defaultState,
                ...state,
            },
        });
        _LoggingController_instances.add(this);
        this.messagingSystem.registerActionHandler(`${name}:add`, (log) => this.add(log));
    }
    /**
     * Add log to the state.
     *
     * @param log - Log to add to the controller
     */
    add(log) {
        const newLog = {
            id: __classPrivateFieldGet(this, _LoggingController_instances, "m", _LoggingController_generateId).call(this),
            timestamp: Date.now(),
            log,
        };
        this.update((state) => {
            state.logs[newLog.id] = newLog;
        });
    }
    /**
     * Removes all log entries.
     */
    clear() {
        this.update((state) => {
            state.logs = {};
        });
    }
}
exports.LoggingController = LoggingController;
_LoggingController_instances = new WeakSet(), _LoggingController_generateId = function _LoggingController_generateId() {
    let id = (0, uuid_1.v1)();
    while (id in this.state.logs) {
        id = (0, uuid_1.v1)();
    }
    return id;
};

      };
    };
  }
  }
}, {package:"@metamask/logging-controller",file:"node_modules\\@metamask\\logging-controller\\dist\\LoggingController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\logging-controller\\dist\\index.cjs", {"./LoggingController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\logging-controller\\dist\\LoggingController.cjs","./logTypes/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\logging-controller\\dist\\logTypes\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Clogging-controller%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./LoggingController.cjs"), exports);
__exportStar(require("./logTypes/index.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/logging-controller",file:"node_modules\\@metamask\\logging-controller\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\logging-controller\\dist\\logTypes\\EthSignLog.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Clogging-controller%5Cdist%5ClogTypes%5CEthSignLog.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SigningStage = exports.SigningMethod = void 0;
/**
 * An enum of the signing method types that we are interested in logging.
 */
var SigningMethod;
(function (SigningMethod) {
    SigningMethod["PersonalSign"] = "personal_sign";
    SigningMethod["EthSignTypedData"] = "eth_signTypedData";
    SigningMethod["EthSignTypedDataV3"] = "eth_signTypedData_v3";
    SigningMethod["EthSignTypedDataV4"] = "eth_signTypedData_v4";
})(SigningMethod || (exports.SigningMethod = SigningMethod = {}));
/**
 * An enum of the various stages of the signing request
 */
var SigningStage;
(function (SigningStage) {
    SigningStage["Proposed"] = "proposed";
    SigningStage["Rejected"] = "rejected";
    SigningStage["Signed"] = "signed";
})(SigningStage || (exports.SigningStage = SigningStage = {}));

      };
    };
  }
  }
}, {package:"@metamask/logging-controller",file:"node_modules\\@metamask\\logging-controller\\dist\\logTypes\\EthSignLog.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\logging-controller\\dist\\logTypes\\GenericLog.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Clogging-controller%5Cdist%5ClogTypes%5CGenericLog.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });

      };
    };
  }
  }
}, {package:"@metamask/logging-controller",file:"node_modules\\@metamask\\logging-controller\\dist\\logTypes\\GenericLog.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\logging-controller\\dist\\logTypes\\LogType.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Clogging-controller%5Cdist%5ClogTypes%5CLogType.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogType = void 0;
/**
 * An enum representing the allowed types of log messages supported by this
 * controller. When adding new types of special cased log types, make sure to
 * extend this enum with the new type name.
 */
var LogType;
(function (LogType) {
    LogType["GenericLog"] = "GenericLog";
    LogType["EthSignLog"] = "EthSignLog";
})(LogType || (exports.LogType = LogType = {}));

      };
    };
  }
  }
}, {package:"@metamask/logging-controller",file:"node_modules\\@metamask\\logging-controller\\dist\\logTypes\\LogType.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\logging-controller\\dist\\logTypes\\index.cjs", {"./EthSignLog.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\logging-controller\\dist\\logTypes\\EthSignLog.cjs","./GenericLog.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\logging-controller\\dist\\logTypes\\GenericLog.cjs","./LogType.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\logging-controller\\dist\\logTypes\\LogType.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Clogging-controller%5Cdist%5ClogTypes%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Export all other types from these files for usage by clients
 */
__exportStar(require("./EthSignLog.cjs"), exports);
__exportStar(require("./GenericLog.cjs"), exports);
__exportStar(require("./LogType.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/logging-controller",file:"node_modules\\@metamask\\logging-controller\\dist\\logTypes\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\metamask-eth-abis\\dist\\abis\\abiERC1155.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmetamask-eth-abis%5Cdist%5Cabis%5CabiERC1155.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.abiERC1155 = void 0;
exports.abiERC1155 = [
    {
        inputs: [
            {
                internalType: 'string',
                name: 'uri_',
                type: 'string',
            },
        ],
        stateMutability: 'nonpayable',
        type: 'constructor',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'account',
                type: 'address',
            },
            {
                indexed: true,
                internalType: 'address',
                name: 'operator',
                type: 'address',
            },
            {
                indexed: false,
                internalType: 'bool',
                name: 'approved',
                type: 'bool',
            },
        ],
        name: 'ApprovalForAll',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'operator',
                type: 'address',
            },
            {
                indexed: true,
                internalType: 'address',
                name: 'from',
                type: 'address',
            },
            {
                indexed: true,
                internalType: 'address',
                name: 'to',
                type: 'address',
            },
            {
                indexed: false,
                internalType: 'uint256[]',
                name: 'ids',
                type: 'uint256[]',
            },
            {
                indexed: false,
                internalType: 'uint256[]',
                name: 'values',
                type: 'uint256[]',
            },
        ],
        name: 'TransferBatch',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'operator',
                type: 'address',
            },
            {
                indexed: true,
                internalType: 'address',
                name: 'from',
                type: 'address',
            },
            {
                indexed: true,
                internalType: 'address',
                name: 'to',
                type: 'address',
            },
            {
                indexed: false,
                internalType: 'uint256',
                name: 'id',
                type: 'uint256',
            },
            {
                indexed: false,
                internalType: 'uint256',
                name: 'value',
                type: 'uint256',
            },
        ],
        name: 'TransferSingle',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: false,
                internalType: 'string',
                name: 'value',
                type: 'string',
            },
            {
                indexed: true,
                internalType: 'uint256',
                name: 'id',
                type: 'uint256',
            },
        ],
        name: 'URI',
        type: 'event',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'account',
                type: 'address',
            },
            {
                internalType: 'uint256',
                name: 'id',
                type: 'uint256',
            },
        ],
        name: 'balanceOf',
        outputs: [
            {
                internalType: 'uint256',
                name: '',
                type: 'uint256',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address[]',
                name: 'accounts',
                type: 'address[]',
            },
            {
                internalType: 'uint256[]',
                name: 'ids',
                type: 'uint256[]',
            },
        ],
        name: 'balanceOfBatch',
        outputs: [
            {
                internalType: 'uint256[]',
                name: '',
                type: 'uint256[]',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'account',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'operator',
                type: 'address',
            },
        ],
        name: 'isApprovedForAll',
        outputs: [
            {
                internalType: 'bool',
                name: '',
                type: 'bool',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'from',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'to',
                type: 'address',
            },
            {
                internalType: 'uint256[]',
                name: 'ids',
                type: 'uint256[]',
            },
            {
                internalType: 'uint256[]',
                name: 'amounts',
                type: 'uint256[]',
            },
            {
                internalType: 'bytes',
                name: 'data',
                type: 'bytes',
            },
        ],
        name: 'safeBatchTransferFrom',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'from',
                type: 'address',
            },
            {
                internalType: 'address',
                name: 'to',
                type: 'address',
            },
            {
                internalType: 'uint256',
                name: 'id',
                type: 'uint256',
            },
            {
                internalType: 'uint256',
                name: 'amount',
                type: 'uint256',
            },
            {
                internalType: 'bytes',
                name: 'data',
                type: 'bytes',
            },
        ],
        name: 'safeTransferFrom',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: 'operator',
                type: 'address',
            },
            {
                internalType: 'bool',
                name: 'approved',
                type: 'bool',
            },
        ],
        name: 'setApprovalForAll',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'bytes4',
                name: 'interfaceId',
                type: 'bytes4',
            },
        ],
        name: 'supportsInterface',
        outputs: [
            {
                internalType: 'bool',
                name: '',
                type: 'bool',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'uint256',
                name: '',
                type: 'uint256',
            },
        ],
        name: 'uri',
        outputs: [
            {
                internalType: 'string',
                name: '',
                type: 'string',
            },
        ],
        stateMutability: 'view',
        type: 'function',
    },
];

      };
    };
  }
  }
}, {package:"@metamask/metamask-eth-abis",file:"node_modules\\@metamask\\metamask-eth-abis\\dist\\abis\\abiERC1155.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\metamask-eth-abis\\dist\\abis\\abiERC20.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmetamask-eth-abis%5Cdist%5Cabis%5CabiERC20.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.abiERC20 = void 0;
exports.abiERC20 = [
    {
        constant: true,
        inputs: [],
        name: 'name',
        outputs: [
            {
                name: '',
                type: 'string',
            },
        ],
        payable: false,
        type: 'function',
    },
    {
        constant: false,
        inputs: [
            {
                name: '_spender',
                type: 'address',
            },
            {
                name: '_value',
                type: 'uint256',
            },
        ],
        name: 'approve',
        outputs: [
            {
                name: 'success',
                type: 'bool',
            },
        ],
        payable: false,
        type: 'function',
    },
    {
        constant: true,
        inputs: [],
        name: 'totalSupply',
        outputs: [
            {
                name: '',
                type: 'uint256',
            },
        ],
        payable: false,
        type: 'function',
    },
    {
        constant: false,
        inputs: [
            {
                name: '_from',
                type: 'address',
            },
            {
                name: '_to',
                type: 'address',
            },
            {
                name: '_value',
                type: 'uint256',
            },
        ],
        name: 'transferFrom',
        outputs: [
            {
                name: 'success',
                type: 'bool',
            },
        ],
        payable: false,
        type: 'function',
    },
    {
        constant: true,
        inputs: [],
        name: 'decimals',
        outputs: [
            {
                name: '',
                type: 'uint256',
            },
        ],
        payable: false,
        type: 'function',
    },
    {
        constant: true,
        inputs: [],
        name: 'version',
        outputs: [
            {
                name: '',
                type: 'string',
            },
        ],
        payable: false,
        type: 'function',
    },
    {
        constant: true,
        inputs: [
            {
                name: '_owner',
                type: 'address',
            },
        ],
        name: 'balanceOf',
        outputs: [
            {
                name: 'balance',
                type: 'uint256',
            },
        ],
        payable: false,
        type: 'function',
    },
    {
        constant: true,
        inputs: [],
        name: 'symbol',
        outputs: [
            {
                name: '',
                type: 'string',
            },
        ],
        payable: false,
        type: 'function',
    },
    {
        constant: false,
        inputs: [
            {
                name: '_to',
                type: 'address',
            },
            {
                name: '_value',
                type: 'uint256',
            },
        ],
        name: 'transfer',
        outputs: [
            {
                name: 'success',
                type: 'bool',
            },
        ],
        payable: false,
        type: 'function',
    },
    {
        constant: false,
        inputs: [
            {
                name: '_spender',
                type: 'address',
            },
            {
                name: '_value',
                type: 'uint256',
            },
            {
                name: '_extraData',
                type: 'bytes',
            },
        ],
        name: 'approveAndCall',
        outputs: [
            {
                name: 'success',
                type: 'bool',
            },
        ],
        payable: false,
        type: 'function',
    },
    {
        constant: true,
        inputs: [
            {
                name: '_owner',
                type: 'address',
            },
            {
                name: '_spender',
                type: 'address',
            },
        ],
        name: 'allowance',
        outputs: [
            {
                name: 'remaining',
                type: 'uint256',
            },
        ],
        payable: false,
        type: 'function',
    },
    {
        inputs: [
            {
                name: '_initialAmount',
                type: 'uint256',
            },
            {
                name: '_tokenName',
                type: 'string',
            },
            {
                name: '_decimalUnits',
                type: 'uint8',
            },
            {
                name: '_tokenSymbol',
                type: 'string',
            },
        ],
        type: 'constructor',
    },
    {
        payable: false,
        type: 'fallback',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                name: '_from',
                type: 'address',
            },
            {
                indexed: true,
                name: '_to',
                type: 'address',
            },
            {
                indexed: false,
                name: '_value',
                type: 'uint256',
            },
        ],
        name: 'Transfer',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                name: '_owner',
                type: 'address',
            },
            {
                indexed: true,
                name: '_spender',
                type: 'address',
            },
            {
                indexed: false,
                name: '_value',
                type: 'uint256',
            },
        ],
        name: 'Approval',
        type: 'event',
    },
];

      };
    };
  }
  }
}, {package:"@metamask/metamask-eth-abis",file:"node_modules\\@metamask\\metamask-eth-abis\\dist\\abis\\abiERC20.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\metamask-eth-abis\\dist\\abis\\abiERC721.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmetamask-eth-abis%5Cdist%5Cabis%5CabiERC721.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.abiERC721 = void 0;
exports.abiERC721 = [
    {
        constant: true,
        inputs: [
            {
                name: 'interfaceID',
                type: 'bytes4',
            },
        ],
        name: 'supportsInterface',
        outputs: [
            {
                name: '',
                type: 'bool',
            },
        ],
        payable: false,
        stateMutability: 'view',
        type: 'function',
    },
    {
        constant: true,
        inputs: [],
        name: 'name',
        outputs: [
            {
                name: '_name',
                type: 'string',
            },
        ],
        payable: false,
        stateMutability: 'view',
        type: 'function',
    },
    {
        constant: true,
        inputs: [
            {
                name: '_tokenId',
                type: 'uint256',
            },
        ],
        name: 'getApproved',
        outputs: [
            {
                name: '',
                type: 'address',
            },
        ],
        payable: false,
        stateMutability: 'view',
        type: 'function',
    },
    {
        constant: false,
        inputs: [
            {
                name: '_approved',
                type: 'address',
            },
            {
                name: '_tokenId',
                type: 'uint256',
            },
        ],
        name: 'approve',
        outputs: [],
        payable: true,
        stateMutability: 'payable',
        type: 'function',
    },
    {
        constant: true,
        inputs: [],
        name: 'totalSupply',
        outputs: [
            {
                name: '',
                type: 'uint256',
            },
        ],
        payable: false,
        stateMutability: 'view',
        type: 'function',
    },
    {
        constant: false,
        inputs: [
            {
                name: '_from',
                type: 'address',
            },
            {
                name: '_to',
                type: 'address',
            },
            {
                name: '_tokenId',
                type: 'uint256',
            },
        ],
        name: 'transferFrom',
        outputs: [],
        payable: true,
        stateMutability: 'payable',
        type: 'function',
    },
    {
        constant: true,
        inputs: [
            {
                name: '_owner',
                type: 'address',
            },
            {
                name: '_index',
                type: 'uint256',
            },
        ],
        name: 'tokenOfOwnerByIndex',
        outputs: [
            {
                name: '',
                type: 'uint256',
            },
        ],
        payable: false,
        stateMutability: 'view',
        type: 'function',
    },
    {
        constant: false,
        inputs: [
            {
                name: '_from',
                type: 'address',
            },
            {
                name: '_to',
                type: 'address',
            },
            {
                name: '_tokenId',
                type: 'uint256',
            },
        ],
        name: 'safeTransferFrom',
        outputs: [],
        payable: true,
        stateMutability: 'payable',
        type: 'function',
    },
    {
        constant: true,
        inputs: [
            {
                name: '_index',
                type: 'uint256',
            },
        ],
        name: 'tokenByIndex',
        outputs: [
            {
                name: '',
                type: 'uint256',
            },
        ],
        payable: false,
        stateMutability: 'view',
        type: 'function',
    },
    {
        constant: true,
        inputs: [
            {
                name: '_tokenId',
                type: 'uint256',
            },
        ],
        name: 'ownerOf',
        outputs: [
            {
                name: '',
                type: 'address',
            },
        ],
        payable: false,
        stateMutability: 'view',
        type: 'function',
    },
    {
        constant: true,
        inputs: [
            {
                name: '_owner',
                type: 'address',
            },
        ],
        name: 'balanceOf',
        outputs: [
            {
                name: '',
                type: 'uint256',
            },
        ],
        payable: false,
        stateMutability: 'view',
        type: 'function',
    },
    {
        constant: true,
        inputs: [],
        name: 'symbol',
        outputs: [
            {
                name: '_symbol',
                type: 'string',
            },
        ],
        payable: false,
        stateMutability: 'view',
        type: 'function',
    },
    {
        constant: false,
        inputs: [
            {
                name: '_operator',
                type: 'address',
            },
            {
                name: '_approved',
                type: 'bool',
            },
        ],
        name: 'setApprovalForAll',
        outputs: [],
        payable: false,
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        constant: false,
        inputs: [
            {
                name: '_from',
                type: 'address',
            },
            {
                name: '_to',
                type: 'address',
            },
            {
                name: '_tokenId',
                type: 'uint256',
            },
            {
                name: 'data',
                type: 'bytes',
            },
        ],
        name: 'safeTransferFrom',
        outputs: [],
        payable: true,
        stateMutability: 'payable',
        type: 'function',
    },
    {
        constant: true,
        inputs: [
            {
                name: '_tokenId',
                type: 'uint256',
            },
        ],
        name: 'tokenURI',
        outputs: [
            {
                name: '',
                type: 'string',
            },
        ],
        payable: false,
        stateMutability: 'view',
        type: 'function',
    },
    {
        constant: true,
        inputs: [
            {
                name: '_owner',
                type: 'address',
            },
            {
                name: '_operator',
                type: 'address',
            },
        ],
        name: 'isApprovedForAll',
        outputs: [
            {
                name: '',
                type: 'bool',
            },
        ],
        payable: false,
        stateMutability: 'view',
        type: 'function',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                name: '_from',
                type: 'address',
            },
            {
                indexed: true,
                name: '_to',
                type: 'address',
            },
            {
                indexed: true,
                name: '_tokenId',
                type: 'uint256',
            },
        ],
        name: 'Transfer',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                name: '_owner',
                type: 'address',
            },
            {
                indexed: true,
                name: '_approved',
                type: 'address',
            },
            {
                indexed: true,
                name: '_tokenId',
                type: 'uint256',
            },
        ],
        name: 'Approval',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                name: '_owner',
                type: 'address',
            },
            {
                indexed: true,
                name: '_operator',
                type: 'address',
            },
            {
                indexed: false,
                name: '_approved',
                type: 'bool',
            },
        ],
        name: 'ApprovalForAll',
        type: 'event',
    },
];

      };
    };
  }
  }
}, {package:"@metamask/metamask-eth-abis",file:"node_modules\\@metamask\\metamask-eth-abis\\dist\\abis\\abiERC721.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\metamask-eth-abis\\dist\\abis\\fiatTokenV2.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmetamask-eth-abis%5Cdist%5Cabis%5CfiatTokenV2.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.abiFiatTokenV2 = void 0;
exports.abiFiatTokenV2 = [
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'owner',
                type: 'address',
            },
            {
                indexed: true,
                internalType: 'address',
                name: 'spender',
                type: 'address',
            },
            {
                indexed: false,
                internalType: 'uint256',
                name: 'value',
                type: 'uint256',
            },
        ],
        name: 'Approval',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'authorizer',
                type: 'address',
            },
            {
                indexed: true,
                internalType: 'bytes32',
                name: 'nonce',
                type: 'bytes32',
            },
        ],
        name: 'AuthorizationCanceled',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'authorizer',
                type: 'address',
            },
            {
                indexed: true,
                internalType: 'bytes32',
                name: 'nonce',
                type: 'bytes32',
            },
        ],
        name: 'AuthorizationUsed',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: '_account',
                type: 'address',
            },
        ],
        name: 'Blacklisted',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'newBlacklister',
                type: 'address',
            },
        ],
        name: 'BlacklisterChanged',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'burner',
                type: 'address',
            },
            {
                indexed: false,
                internalType: 'uint256',
                name: 'amount',
                type: 'uint256',
            },
        ],
        name: 'Burn',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'newMasterMinter',
                type: 'address',
            },
        ],
        name: 'MasterMinterChanged',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'minter',
                type: 'address',
            },
            {
                indexed: true,
                internalType: 'address',
                name: 'to',
                type: 'address',
            },
            {
                indexed: false,
                internalType: 'uint256',
                name: 'amount',
                type: 'uint256',
            },
        ],
        name: 'Mint',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'minter',
                type: 'address',
            },
            {
                indexed: false,
                internalType: 'uint256',
                name: 'minterAllowedAmount',
                type: 'uint256',
            },
        ],
        name: 'MinterConfigured',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'oldMinter',
                type: 'address',
            },
        ],
        name: 'MinterRemoved',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: false,
                internalType: 'address',
                name: 'previousOwner',
                type: 'address',
            },
            {
                indexed: false,
                internalType: 'address',
                name: 'newOwner',
                type: 'address',
            },
        ],
        name: 'OwnershipTransferred',
        type: 'event',
    },
    { anonymous: false, inputs: [], name: 'Pause', type: 'event' },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'newAddress',
                type: 'address',
            },
        ],
        name: 'PauserChanged',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'newRescuer',
                type: 'address',
            },
        ],
        name: 'RescuerChanged',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: 'from',
                type: 'address',
            },
            {
                indexed: true,
                internalType: 'address',
                name: 'to',
                type: 'address',
            },
            {
                indexed: false,
                internalType: 'uint256',
                name: 'value',
                type: 'uint256',
            },
        ],
        name: 'Transfer',
        type: 'event',
    },
    {
        anonymous: false,
        inputs: [
            {
                indexed: true,
                internalType: 'address',
                name: '_account',
                type: 'address',
            },
        ],
        name: 'UnBlacklisted',
        type: 'event',
    },
    { anonymous: false, inputs: [], name: 'Unpause', type: 'event' },
    {
        inputs: [],
        name: 'CANCEL_AUTHORIZATION_TYPEHASH',
        outputs: [{ internalType: 'bytes32', name: '', type: 'bytes32' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'DOMAIN_SEPARATOR',
        outputs: [{ internalType: 'bytes32', name: '', type: 'bytes32' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'PERMIT_TYPEHASH',
        outputs: [{ internalType: 'bytes32', name: '', type: 'bytes32' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'RECEIVE_WITH_AUTHORIZATION_TYPEHASH',
        outputs: [{ internalType: 'bytes32', name: '', type: 'bytes32' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'TRANSFER_WITH_AUTHORIZATION_TYPEHASH',
        outputs: [{ internalType: 'bytes32', name: '', type: 'bytes32' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            { internalType: 'address', name: 'owner', type: 'address' },
            { internalType: 'address', name: 'spender', type: 'address' },
        ],
        name: 'allowance',
        outputs: [{ internalType: 'uint256', name: '', type: 'uint256' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            { internalType: 'address', name: 'spender', type: 'address' },
            { internalType: 'uint256', name: 'value', type: 'uint256' },
        ],
        name: 'approve',
        outputs: [{ internalType: 'bool', name: '', type: 'bool' }],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            { internalType: 'address', name: 'authorizer', type: 'address' },
            { internalType: 'bytes32', name: 'nonce', type: 'bytes32' },
        ],
        name: 'authorizationState',
        outputs: [{ internalType: 'bool', name: '', type: 'bool' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [{ internalType: 'address', name: 'account', type: 'address' }],
        name: 'balanceOf',
        outputs: [{ internalType: 'uint256', name: '', type: 'uint256' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [{ internalType: 'address', name: '_account', type: 'address' }],
        name: 'blacklist',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [],
        name: 'blacklister',
        outputs: [{ internalType: 'address', name: '', type: 'address' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [{ internalType: 'uint256', name: '_amount', type: 'uint256' }],
        name: 'burn',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            { internalType: 'address', name: 'authorizer', type: 'address' },
            { internalType: 'bytes32', name: 'nonce', type: 'bytes32' },
            { internalType: 'uint8', name: 'v', type: 'uint8' },
            { internalType: 'bytes32', name: 'r', type: 'bytes32' },
            { internalType: 'bytes32', name: 's', type: 'bytes32' },
        ],
        name: 'cancelAuthorization',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            { internalType: 'address', name: 'authorizer', type: 'address' },
            { internalType: 'bytes32', name: 'nonce', type: 'bytes32' },
            { internalType: 'bytes', name: 'signature', type: 'bytes' },
        ],
        name: 'cancelAuthorization',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            { internalType: 'address', name: 'minter', type: 'address' },
            {
                internalType: 'uint256',
                name: 'minterAllowedAmount',
                type: 'uint256',
            },
        ],
        name: 'configureMinter',
        outputs: [{ internalType: 'bool', name: '', type: 'bool' }],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [],
        name: 'currency',
        outputs: [{ internalType: 'string', name: '', type: 'string' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'decimals',
        outputs: [{ internalType: 'uint8', name: '', type: 'uint8' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            { internalType: 'address', name: 'spender', type: 'address' },
            { internalType: 'uint256', name: 'decrement', type: 'uint256' },
        ],
        name: 'decreaseAllowance',
        outputs: [{ internalType: 'bool', name: '', type: 'bool' }],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            { internalType: 'address', name: 'spender', type: 'address' },
            { internalType: 'uint256', name: 'increment', type: 'uint256' },
        ],
        name: 'increaseAllowance',
        outputs: [{ internalType: 'bool', name: '', type: 'bool' }],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            { internalType: 'string', name: 'tokenName', type: 'string' },
            { internalType: 'string', name: 'tokenSymbol', type: 'string' },
            { internalType: 'string', name: 'tokenCurrency', type: 'string' },
            { internalType: 'uint8', name: 'tokenDecimals', type: 'uint8' },
            { internalType: 'address', name: 'newMasterMinter', type: 'address' },
            { internalType: 'address', name: 'newPauser', type: 'address' },
            { internalType: 'address', name: 'newBlacklister', type: 'address' },
            { internalType: 'address', name: 'newOwner', type: 'address' },
        ],
        name: 'initialize',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [{ internalType: 'string', name: 'newName', type: 'string' }],
        name: 'initializeV2',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            { internalType: 'address', name: 'lostAndFound', type: 'address' },
        ],
        name: 'initializeV2_1',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address[]',
                name: 'accountsToBlacklist',
                type: 'address[]',
            },
            { internalType: 'string', name: 'newSymbol', type: 'string' },
        ],
        name: 'initializeV2_2',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [{ internalType: 'address', name: '_account', type: 'address' }],
        name: 'isBlacklisted',
        outputs: [{ internalType: 'bool', name: '', type: 'bool' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [{ internalType: 'address', name: 'account', type: 'address' }],
        name: 'isMinter',
        outputs: [{ internalType: 'bool', name: '', type: 'bool' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'masterMinter',
        outputs: [{ internalType: 'address', name: '', type: 'address' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            { internalType: 'address', name: '_to', type: 'address' },
            { internalType: 'uint256', name: '_amount', type: 'uint256' },
        ],
        name: 'mint',
        outputs: [{ internalType: 'bool', name: '', type: 'bool' }],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [{ internalType: 'address', name: 'minter', type: 'address' }],
        name: 'minterAllowance',
        outputs: [{ internalType: 'uint256', name: '', type: 'uint256' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'name',
        outputs: [{ internalType: 'string', name: '', type: 'string' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [{ internalType: 'address', name: 'owner', type: 'address' }],
        name: 'nonces',
        outputs: [{ internalType: 'uint256', name: '', type: 'uint256' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'owner',
        outputs: [{ internalType: 'address', name: '', type: 'address' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'pause',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [],
        name: 'paused',
        outputs: [{ internalType: 'bool', name: '', type: 'bool' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'pauser',
        outputs: [{ internalType: 'address', name: '', type: 'address' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            { internalType: 'address', name: 'owner', type: 'address' },
            { internalType: 'address', name: 'spender', type: 'address' },
            { internalType: 'uint256', name: 'value', type: 'uint256' },
            { internalType: 'uint256', name: 'deadline', type: 'uint256' },
            { internalType: 'bytes', name: 'signature', type: 'bytes' },
        ],
        name: 'permit',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            { internalType: 'address', name: 'owner', type: 'address' },
            { internalType: 'address', name: 'spender', type: 'address' },
            { internalType: 'uint256', name: 'value', type: 'uint256' },
            { internalType: 'uint256', name: 'deadline', type: 'uint256' },
            { internalType: 'uint8', name: 'v', type: 'uint8' },
            { internalType: 'bytes32', name: 'r', type: 'bytes32' },
            { internalType: 'bytes32', name: 's', type: 'bytes32' },
        ],
        name: 'permit',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            { internalType: 'address', name: 'from', type: 'address' },
            { internalType: 'address', name: 'to', type: 'address' },
            { internalType: 'uint256', name: 'value', type: 'uint256' },
            { internalType: 'uint256', name: 'validAfter', type: 'uint256' },
            { internalType: 'uint256', name: 'validBefore', type: 'uint256' },
            { internalType: 'bytes32', name: 'nonce', type: 'bytes32' },
            { internalType: 'bytes', name: 'signature', type: 'bytes' },
        ],
        name: 'receiveWithAuthorization',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            { internalType: 'address', name: 'from', type: 'address' },
            { internalType: 'address', name: 'to', type: 'address' },
            { internalType: 'uint256', name: 'value', type: 'uint256' },
            { internalType: 'uint256', name: 'validAfter', type: 'uint256' },
            { internalType: 'uint256', name: 'validBefore', type: 'uint256' },
            { internalType: 'bytes32', name: 'nonce', type: 'bytes32' },
            { internalType: 'uint8', name: 'v', type: 'uint8' },
            { internalType: 'bytes32', name: 'r', type: 'bytes32' },
            { internalType: 'bytes32', name: 's', type: 'bytes32' },
        ],
        name: 'receiveWithAuthorization',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [{ internalType: 'address', name: 'minter', type: 'address' }],
        name: 'removeMinter',
        outputs: [{ internalType: 'bool', name: '', type: 'bool' }],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'contract IERC20',
                name: 'tokenContract',
                type: 'address',
            },
            { internalType: 'address', name: 'to', type: 'address' },
            { internalType: 'uint256', name: 'amount', type: 'uint256' },
        ],
        name: 'rescueERC20',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [],
        name: 'rescuer',
        outputs: [{ internalType: 'address', name: '', type: 'address' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'symbol',
        outputs: [{ internalType: 'string', name: '', type: 'string' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [],
        name: 'totalSupply',
        outputs: [{ internalType: 'uint256', name: '', type: 'uint256' }],
        stateMutability: 'view',
        type: 'function',
    },
    {
        inputs: [
            { internalType: 'address', name: 'to', type: 'address' },
            { internalType: 'uint256', name: 'value', type: 'uint256' },
        ],
        name: 'transfer',
        outputs: [{ internalType: 'bool', name: '', type: 'bool' }],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            { internalType: 'address', name: 'from', type: 'address' },
            { internalType: 'address', name: 'to', type: 'address' },
            { internalType: 'uint256', name: 'value', type: 'uint256' },
        ],
        name: 'transferFrom',
        outputs: [{ internalType: 'bool', name: '', type: 'bool' }],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [{ internalType: 'address', name: 'newOwner', type: 'address' }],
        name: 'transferOwnership',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            { internalType: 'address', name: 'from', type: 'address' },
            { internalType: 'address', name: 'to', type: 'address' },
            { internalType: 'uint256', name: 'value', type: 'uint256' },
            { internalType: 'uint256', name: 'validAfter', type: 'uint256' },
            { internalType: 'uint256', name: 'validBefore', type: 'uint256' },
            { internalType: 'bytes32', name: 'nonce', type: 'bytes32' },
            { internalType: 'bytes', name: 'signature', type: 'bytes' },
        ],
        name: 'transferWithAuthorization',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            { internalType: 'address', name: 'from', type: 'address' },
            { internalType: 'address', name: 'to', type: 'address' },
            { internalType: 'uint256', name: 'value', type: 'uint256' },
            { internalType: 'uint256', name: 'validAfter', type: 'uint256' },
            { internalType: 'uint256', name: 'validBefore', type: 'uint256' },
            { internalType: 'bytes32', name: 'nonce', type: 'bytes32' },
            { internalType: 'uint8', name: 'v', type: 'uint8' },
            { internalType: 'bytes32', name: 'r', type: 'bytes32' },
            { internalType: 'bytes32', name: 's', type: 'bytes32' },
        ],
        name: 'transferWithAuthorization',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [{ internalType: 'address', name: '_account', type: 'address' }],
        name: 'unBlacklist',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [],
        name: 'unpause',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            { internalType: 'address', name: '_newBlacklister', type: 'address' },
        ],
        name: 'updateBlacklister',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [
            {
                internalType: 'address',
                name: '_newMasterMinter',
                type: 'address',
            },
        ],
        name: 'updateMasterMinter',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [{ internalType: 'address', name: '_newPauser', type: 'address' }],
        name: 'updatePauser',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [{ internalType: 'address', name: 'newRescuer', type: 'address' }],
        name: 'updateRescuer',
        outputs: [],
        stateMutability: 'nonpayable',
        type: 'function',
    },
    {
        inputs: [],
        name: 'version',
        outputs: [{ internalType: 'string', name: '', type: 'string' }],
        stateMutability: 'pure',
        type: 'function',
    },
];

      };
    };
  }
  }
}, {package:"@metamask/metamask-eth-abis",file:"node_modules\\@metamask\\metamask-eth-abis\\dist\\abis\\fiatTokenV2.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\metamask-eth-abis\\dist\\index.js", {"./abis/abiERC1155":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\metamask-eth-abis\\dist\\abis\\abiERC1155.js","./abis/abiERC20":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\metamask-eth-abis\\dist\\abis\\abiERC20.js","./abis/abiERC721":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\metamask-eth-abis\\dist\\abis\\abiERC721.js","./abis/fiatTokenV2":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\metamask-eth-abis\\dist\\abis\\fiatTokenV2.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmetamask-eth-abis%5Cdist%5Cindex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.abiFiatTokenV2 = exports.abiERC1155 = exports.abiERC721 = exports.abiERC20 = void 0;
const abiERC20_1 = require("./abis/abiERC20");
Object.defineProperty(exports, "abiERC20", { enumerable: true, get: function () { return abiERC20_1.abiERC20; } });
const abiERC721_1 = require("./abis/abiERC721");
Object.defineProperty(exports, "abiERC721", { enumerable: true, get: function () { return abiERC721_1.abiERC721; } });
const abiERC1155_1 = require("./abis/abiERC1155");
Object.defineProperty(exports, "abiERC1155", { enumerable: true, get: function () { return abiERC1155_1.abiERC1155; } });
const fiatTokenV2_1 = require("./abis/fiatTokenV2");
Object.defineProperty(exports, "abiFiatTokenV2", { enumerable: true, get: function () { return fiatTokenV2_1.abiFiatTokenV2; } });

      };
    };
  }
  }
}, {package:"@metamask/metamask-eth-abis",file:"node_modules\\@metamask\\metamask-eth-abis\\dist\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\MultichainNetworkController\\MultichainNetworkController.cjs", {"../api/accounts-api.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\api\\accounts-api.cjs","../constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\constants.cjs","../types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\types.cjs","../utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\utils.cjs","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-network-controller%5Cdist%5CMultichainNetworkController%5CMultichainNetworkController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _MultichainNetworkController_instances, _MultichainNetworkController_networkService, _MultichainNetworkController_setActiveEvmNetwork, _MultichainNetworkController_setActiveNonEvmNetwork, _MultichainNetworkController_removeEvmNetwork, _MultichainNetworkController_removeNonEvmNetwork, _MultichainNetworkController_handleOnSelectedAccountChange, _MultichainNetworkController_subscribeToMessageEvents, _MultichainNetworkController_registerMessageHandlers;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultichainNetworkController = void 0;
const base_controller_1 = require("@metamask/base-controller");
const keyring_api_1 = require("@metamask/keyring-api");
const utils_1 = require("@metamask/utils");
const accounts_api_1 = require("../api/accounts-api.cjs");
const constants_1 = require("../constants.cjs");
const types_1 = require("../types.cjs");
const utils_2 = require("../utils.cjs");
/**
 * The MultichainNetworkController is responsible for fetching and caching account
 * balances.
 */
class MultichainNetworkController extends base_controller_1.BaseController {
    constructor({ messenger, state, networkService, }) {
        super({
            messenger,
            name: types_1.MULTICHAIN_NETWORK_CONTROLLER_NAME,
            metadata: constants_1.MULTICHAIN_NETWORK_CONTROLLER_METADATA,
            state: {
                ...(0, constants_1.getDefaultMultichainNetworkControllerState)(),
                ...state,
                // We can keep the current network as a hardcoded value
                // since it is not expected to add/remove networks yet.
                multichainNetworkConfigurationsByChainId: constants_1.AVAILABLE_MULTICHAIN_NETWORK_CONFIGURATIONS,
            },
        });
        _MultichainNetworkController_instances.add(this);
        _MultichainNetworkController_networkService.set(this, void 0);
        __classPrivateFieldSet(this, _MultichainNetworkController_networkService, networkService, "f");
        __classPrivateFieldGet(this, _MultichainNetworkController_instances, "m", _MultichainNetworkController_subscribeToMessageEvents).call(this);
        __classPrivateFieldGet(this, _MultichainNetworkController_instances, "m", _MultichainNetworkController_registerMessageHandlers).call(this);
    }
    /**
     * Sets the active network.
     *
     * @param id - The non-EVM Caip chain ID or EVM client ID of the network to set active.
     * @returns - A promise that resolves when the network is set active.
     */
    async setActiveNetwork(id) {
        if ((0, utils_1.isCaipChainId)(id)) {
            const isSupportedCaipChainId = (0, utils_2.checkIfSupportedCaipChainId)(id);
            if (!isSupportedCaipChainId) {
                throw new Error(`Unsupported Caip chain ID: ${String(id)}`);
            }
            return __classPrivateFieldGet(this, _MultichainNetworkController_instances, "m", _MultichainNetworkController_setActiveNonEvmNetwork).call(this, id);
        }
        return await __classPrivateFieldGet(this, _MultichainNetworkController_instances, "m", _MultichainNetworkController_setActiveEvmNetwork).call(this, id);
    }
    /**
     * Returns the active networks for the available EVM addresses (non-EVM networks will be supported in the future).
     * Fetches the data from the API and caches it in state.
     *
     * @returns A promise that resolves to the active networks for the available addresses
     */
    async getNetworksWithTransactionActivityByAccounts() {
        // TODO: We are filtering out non-EVN accounts for now
        // Support for non-EVM networks will be added in the coming weeks
        const evmAccounts = this.messagingSystem
            .call('AccountsController:listMultichainAccounts')
            .filter((account) => (0, keyring_api_1.isEvmAccountType)(account.type));
        if (!evmAccounts || evmAccounts.length === 0) {
            return this.state.networksWithTransactionActivity;
        }
        const formattedAccounts = evmAccounts
            .map((account) => (0, accounts_api_1.toAllowedCaipAccountIds)(account))
            .flat();
        const activeNetworks = await __classPrivateFieldGet(this, _MultichainNetworkController_networkService, "f").fetchNetworkActivity(formattedAccounts);
        const formattedNetworks = (0, accounts_api_1.toActiveNetworksByAddress)(activeNetworks);
        this.update((state) => {
            state.networksWithTransactionActivity = formattedNetworks;
        });
        return this.state.networksWithTransactionActivity;
    }
    /**
     * Removes a network from the list of networks.
     * It only supports EVM networks.
     *
     * @param chainId - The chain ID of the network to remove.
     * @returns - A promise that resolves when the network is removed.
     */
    async removeNetwork(chainId) {
        if ((0, utils_2.isEvmCaipChainId)(chainId)) {
            return await __classPrivateFieldGet(this, _MultichainNetworkController_instances, "m", _MultichainNetworkController_removeEvmNetwork).call(this, chainId);
        }
        return __classPrivateFieldGet(this, _MultichainNetworkController_instances, "m", _MultichainNetworkController_removeNonEvmNetwork).call(this, chainId);
    }
}
exports.MultichainNetworkController = MultichainNetworkController;
_MultichainNetworkController_networkService = new WeakMap(), _MultichainNetworkController_instances = new WeakSet(), _MultichainNetworkController_setActiveEvmNetwork = 
/**
 * Sets the active EVM network.
 *
 * @param id - The client ID of the EVM network to set active.
 */
async function _MultichainNetworkController_setActiveEvmNetwork(id) {
    const { selectedNetworkClientId } = this.messagingSystem.call('NetworkController:getState');
    const shouldSetEvmActive = !this.state.isEvmSelected;
    const shouldNotifyNetworkChange = id !== selectedNetworkClientId;
    // No changes needed if EVM is active and network is already selected
    if (!shouldSetEvmActive && !shouldNotifyNetworkChange) {
        return;
    }
    // Update EVM selection state if needed
    if (shouldSetEvmActive) {
        this.update((state) => {
            state.isEvmSelected = true;
        });
    }
    // Only notify the network controller if the selected evm network is different
    if (shouldNotifyNetworkChange) {
        await this.messagingSystem.call('NetworkController:setActiveNetwork', id);
    }
    // Only publish the networkDidChange event if either the EVM network is different or we're switching between EVM and non-EVM networks
    if (shouldSetEvmActive || shouldNotifyNetworkChange) {
        this.messagingSystem.publish('MultichainNetworkController:networkDidChange', id);
    }
}, _MultichainNetworkController_setActiveNonEvmNetwork = function _MultichainNetworkController_setActiveNonEvmNetwork(id) {
    if (id === this.state.selectedMultichainNetworkChainId &&
        !this.state.isEvmSelected) {
        // Same non-EVM network is already selected, no need to update
        return;
    }
    this.update((state) => {
        state.selectedMultichainNetworkChainId = id;
        state.isEvmSelected = false;
    });
    // Notify listeners that the network changed
    this.messagingSystem.publish('MultichainNetworkController:networkDidChange', id);
}, _MultichainNetworkController_removeEvmNetwork = 
/**
 * Removes an EVM network from the list of networks.
 * This method re-directs the request to the network-controller.
 *
 * @param chainId - The chain ID of the network to remove.
 * @returns - A promise that resolves when the network is removed.
 */
async function _MultichainNetworkController_removeEvmNetwork(chainId) {
    const hexChainId = (0, utils_2.convertEvmCaipToHexChainId)(chainId);
    const selectedChainId = this.messagingSystem.call('NetworkController:getSelectedChainId');
    if (selectedChainId === hexChainId) {
        // We prevent removing the currently selected network.
        if (this.state.isEvmSelected) {
            throw new Error('Cannot remove the currently selected network');
        }
        // If a non-EVM network is selected, we can delete the currently EVM selected network, but
        // we automatically switch to EVM mainnet.
        const ethereumMainnetHexChainId = '0x1'; // TODO: Should probably be a constant.
        const clientId = this.messagingSystem.call('NetworkController:findNetworkClientIdByChainId', ethereumMainnetHexChainId);
        await this.messagingSystem.call('NetworkController:setActiveNetwork', clientId);
    }
    this.messagingSystem.call('NetworkController:removeNetwork', hexChainId);
}, _MultichainNetworkController_removeNonEvmNetwork = function _MultichainNetworkController_removeNonEvmNetwork(_chainId) {
    throw new Error('Removal of non-EVM networks is not supported');
}, _MultichainNetworkController_handleOnSelectedAccountChange = function _MultichainNetworkController_handleOnSelectedAccountChange(account) {
    const { type: accountType, scopes } = account;
    const isEvmAccount = (0, keyring_api_1.isEvmAccountType)(accountType);
    // Handle switching to EVM network
    if (isEvmAccount) {
        if (this.state.isEvmSelected) {
            // No need to update if already on evm network
            return;
        }
        // Make EVM network active
        this.update((state) => {
            state.isEvmSelected = true;
        });
        return;
    }
    // Handle switching to non-EVM network
    if (scopes.includes(this.state.selectedMultichainNetworkChainId)) {
        // No need to update if the account's scope includes the active network
        this.update((state) => {
            state.isEvmSelected = false;
        });
        return;
    }
    const nonEvmChainId = (0, utils_2.getChainIdForNonEvm)(scopes);
    this.update((state) => {
        state.selectedMultichainNetworkChainId = nonEvmChainId;
        state.isEvmSelected = false;
    });
    // No need to publish NetworkController:setActiveNetwork because EVM accounts falls back to use the last selected EVM network
    // DO NOT publish MultichainNetworkController:networkDidChange to prevent circular listener loops
}, _MultichainNetworkController_subscribeToMessageEvents = function _MultichainNetworkController_subscribeToMessageEvents() {
    // Handle network switch when account is changed
    this.messagingSystem.subscribe('AccountsController:selectedAccountChange', (account) => __classPrivateFieldGet(this, _MultichainNetworkController_instances, "m", _MultichainNetworkController_handleOnSelectedAccountChange).call(this, account));
}, _MultichainNetworkController_registerMessageHandlers = function _MultichainNetworkController_registerMessageHandlers() {
    this.messagingSystem.registerActionHandler('MultichainNetworkController:setActiveNetwork', this.setActiveNetwork.bind(this));
    this.messagingSystem.registerActionHandler('MultichainNetworkController:getNetworksWithTransactionActivityByAccounts', this.getNetworksWithTransactionActivityByAccounts.bind(this));
};

      };
    };
  }
  }
}, {package:"@metamask/multichain-network-controller",file:"node_modules\\@metamask\\multichain-network-controller\\dist\\MultichainNetworkController\\MultichainNetworkController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\MultichainNetworkService\\MultichainNetworkService.cjs", {"../api/accounts-api.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\api\\accounts-api.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-network-controller%5Cdist%5CMultichainNetworkService%5CMultichainNetworkService.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _MultichainNetworkService_instances, _MultichainNetworkService_fetch, _MultichainNetworkService_batchSize, _MultichainNetworkService_fetchNetworkActivityBatch;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultichainNetworkService = void 0;
const superstruct_1 = require("@metamask/superstruct");
const lodash_1 = require("lodash");
const accounts_api_1 = require("../api/accounts-api.cjs");
/**
 * Service responsible for fetching network activity data from the API.
 */
class MultichainNetworkService {
    constructor({ fetch: fetchFunction, batchSize, }) {
        _MultichainNetworkService_instances.add(this);
        _MultichainNetworkService_fetch.set(this, void 0);
        _MultichainNetworkService_batchSize.set(this, void 0);
        __classPrivateFieldSet(this, _MultichainNetworkService_fetch, fetchFunction, "f");
        __classPrivateFieldSet(this, _MultichainNetworkService_batchSize, batchSize ?? 20, "f");
    }
    /**
     * Fetches active networks for the given account IDs.
     * Automatically handles batching requests to comply with URL length limitations.
     *
     * @param accountIds - Array of CAIP-10 account IDs to fetch activity for.
     * @returns Promise resolving to the combined active networks response.
     * @throws Error if the response format is invalid or the request fails.
     */
    async fetchNetworkActivity(accountIds) {
        if (accountIds.length === 0) {
            return { activeNetworks: [] };
        }
        if (accountIds.length <= __classPrivateFieldGet(this, _MultichainNetworkService_batchSize, "f")) {
            return __classPrivateFieldGet(this, _MultichainNetworkService_instances, "m", _MultichainNetworkService_fetchNetworkActivityBatch).call(this, accountIds);
        }
        const batches = (0, lodash_1.chunk)(accountIds, __classPrivateFieldGet(this, _MultichainNetworkService_batchSize, "f"));
        const batchResults = await Promise.all(batches.map((batch) => __classPrivateFieldGet(this, _MultichainNetworkService_instances, "m", _MultichainNetworkService_fetchNetworkActivityBatch).call(this, batch)));
        const combinedResponse = {
            activeNetworks: batchResults.flatMap((response) => response.activeNetworks),
        };
        return combinedResponse;
    }
}
exports.MultichainNetworkService = MultichainNetworkService;
_MultichainNetworkService_fetch = new WeakMap(), _MultichainNetworkService_batchSize = new WeakMap(), _MultichainNetworkService_instances = new WeakSet(), _MultichainNetworkService_fetchNetworkActivityBatch = 
/**
 * Internal method to fetch a single batch of account IDs.
 *
 * @param accountIds - Batch of account IDs to fetch
 * @returns Promise resolving to the active networks response for this batch
 * @throws Error if the response format is invalid or the request fails
 */
async function _MultichainNetworkService_fetchNetworkActivityBatch(accountIds) {
    try {
        const url = (0, accounts_api_1.buildActiveNetworksUrl)(accountIds);
        const response = await __classPrivateFieldGet(this, _MultichainNetworkService_fetch, "f").call(this, url.toString(), {
            method: 'GET',
            headers: {
                [accounts_api_1.MULTICHAIN_ACCOUNTS_CLIENT_HEADER]: accounts_api_1.MULTICHAIN_ACCOUNTS_CLIENT_ID,
                Accept: 'application/json',
            },
        });
        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }
        const data = await response.json();
        (0, superstruct_1.assert)(data, accounts_api_1.ActiveNetworksResponseStruct);
        return data;
    }
    catch (error) {
        if (error instanceof Error) {
            if (error.name === 'AbortError') {
                throw new Error('Request timeout: Failed to fetch active networks');
            }
            throw error;
        }
        throw new Error(`Failed to fetch active networks: ${String(error)}`);
    }
};

      };
    };
  }
  }
}, {package:"@metamask/multichain-network-controller",file:"node_modules\\@metamask\\multichain-network-controller\\dist\\MultichainNetworkService\\MultichainNetworkService.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\api\\accounts-api.cjs", {"@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-network-controller%5Cdist%5Capi%5Caccounts-api.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildActiveNetworksUrl = exports.toActiveNetworksByAddress = exports.toAllowedCaipAccountIds = exports.MULTICHAIN_ALLOWED_ACTIVE_NETWORK_SCOPES = exports.MULTICHAIN_ACCOUNTS_CLIENT_ID = exports.MULTICHAIN_ACCOUNTS_CLIENT_HEADER = exports.MULTICHAIN_ACCOUNTS_BASE_URL = exports.ActiveNetworksResponseStruct = void 0;
const keyring_api_1 = require("@metamask/keyring-api");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
exports.ActiveNetworksResponseStruct = (0, superstruct_1.object)({
    activeNetworks: (0, superstruct_1.array)(utils_1.CaipAccountIdStruct),
});
/**
 * The domain for multichain accounts API.
 */
exports.MULTICHAIN_ACCOUNTS_BASE_URL = 'https://accounts.api.cx.metamask.io';
/**
 * The client header for the multichain accounts API.
 */
exports.MULTICHAIN_ACCOUNTS_CLIENT_HEADER = 'x-metamask-clientproduct';
/**
 * The client ID for the multichain accounts API.
 */
exports.MULTICHAIN_ACCOUNTS_CLIENT_ID = 'metamask-multichain-network-controller';
/**
 * The allowed active network scopes for the multichain network controller.
 */
exports.MULTICHAIN_ALLOWED_ACTIVE_NETWORK_SCOPES = [
    String(keyring_api_1.BtcScope.Mainnet),
    String(keyring_api_1.BtcScope.Testnet),
    String(keyring_api_1.BtcScope.Testnet4),
    String(keyring_api_1.BtcScope.Signet),
    String(keyring_api_1.BtcScope.Regtest),
    String(keyring_api_1.SolScope.Mainnet),
    String(keyring_api_1.SolScope.Devnet),
    String(keyring_api_1.EthScope.Mainnet),
    String(keyring_api_1.EthScope.Testnet),
    String(keyring_api_1.EthScope.Eoa),
    String(keyring_api_1.TrxScope.Mainnet),
    String(keyring_api_1.TrxScope.Nile),
    String(keyring_api_1.TrxScope.Shasta),
];
/**
 * Converts an internal account to an array of CAIP-10 account IDs.
 *
 * @param account - The internal account to convert
 * @returns The CAIP-10 account IDs
 */
function toAllowedCaipAccountIds(account) {
    const formattedAccounts = [];
    for (const scope of account.scopes) {
        if (exports.MULTICHAIN_ALLOWED_ACTIVE_NETWORK_SCOPES.includes(scope)) {
            formattedAccounts.push(`${scope}:${account.address}`);
        }
    }
    return formattedAccounts;
}
exports.toAllowedCaipAccountIds = toAllowedCaipAccountIds;
/**
 * Formats the API response into our state structure.
 * Example input: ["eip155:1:0x123...", "eip155:137:0x123...", "solana:1:0xabc..."]
 *
 * @param response - The raw API response
 * @returns Formatted networks by address
 */
function toActiveNetworksByAddress(response) {
    const networksByAddress = {};
    response.activeNetworks.forEach((network) => {
        const { address, chain: { namespace, reference }, } = (0, utils_1.parseCaipAccountId)(network);
        if (!networksByAddress[address]) {
            networksByAddress[address] = {
                namespace,
                activeChains: [],
            };
        }
        networksByAddress[address].activeChains.push(reference);
    });
    return networksByAddress;
}
exports.toActiveNetworksByAddress = toActiveNetworksByAddress;
/**
 * Constructs the URL for the active networks API endpoint.
 *
 * @param accountIds - Array of account IDs
 * @returns URL object for the API endpoint
 */
function buildActiveNetworksUrl(accountIds) {
    const url = new URL(`${exports.MULTICHAIN_ACCOUNTS_BASE_URL}/v2/activeNetworks`);
    url.searchParams.append('accountIds', accountIds.join(','));
    return url;
}
exports.buildActiveNetworksUrl = buildActiveNetworksUrl;

      };
    };
  }
  }
}, {package:"@metamask/multichain-network-controller",file:"node_modules\\@metamask\\multichain-network-controller\\dist\\api\\accounts-api.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\constants.cjs", {"@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/network-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\network-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-network-controller%5Cdist%5Cconstants.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MULTICHAIN_NETWORK_DECIMAL_PLACES = exports.MULTICHAIN_NETWORK_TICKER = exports.MULTICHAIN_NETWORK_CONTROLLER_METADATA = exports.getDefaultMultichainNetworkControllerState = exports.NETWORKS_METADATA = exports.NON_EVM_TESTNET_IDS = exports.AVAILABLE_MULTICHAIN_NETWORK_CONFIGURATIONS = exports.TRX_SHASTA_NATIVE_ASSET = exports.TRX_NILE_NATIVE_ASSET = exports.TRX_NATIVE_ASSET = exports.SOL_DEVNET_NATIVE_ASSET = exports.SOL_TESTNET_NATIVE_ASSET = exports.SOL_NATIVE_ASSET = exports.BTC_REGTEST_NATIVE_ASSET = exports.BTC_SIGNET_NATIVE_ASSET = exports.BTC_TESTNET4_NATIVE_ASSET = exports.BTC_TESTNET_NATIVE_ASSET = exports.BTC_NATIVE_ASSET = void 0;
const keyring_api_1 = require("@metamask/keyring-api");
const network_controller_1 = require("@metamask/network-controller");
exports.BTC_NATIVE_ASSET = `${keyring_api_1.BtcScope.Mainnet}/slip44:0`;
exports.BTC_TESTNET_NATIVE_ASSET = `${keyring_api_1.BtcScope.Testnet}/slip44:0`;
exports.BTC_TESTNET4_NATIVE_ASSET = `${keyring_api_1.BtcScope.Testnet4}/slip44:0`;
exports.BTC_SIGNET_NATIVE_ASSET = `${keyring_api_1.BtcScope.Signet}/slip44:0`;
exports.BTC_REGTEST_NATIVE_ASSET = `${keyring_api_1.BtcScope.Regtest}/slip44:0`;
exports.SOL_NATIVE_ASSET = `${keyring_api_1.SolScope.Mainnet}/slip44:501`;
exports.SOL_TESTNET_NATIVE_ASSET = `${keyring_api_1.SolScope.Testnet}/slip44:501`;
exports.SOL_DEVNET_NATIVE_ASSET = `${keyring_api_1.SolScope.Devnet}/slip44:501`;
exports.TRX_NATIVE_ASSET = `${keyring_api_1.TrxScope.Mainnet}/slip44:195`;
exports.TRX_NILE_NATIVE_ASSET = `${keyring_api_1.TrxScope.Nile}/slip44:195`;
exports.TRX_SHASTA_NATIVE_ASSET = `${keyring_api_1.TrxScope.Shasta}/slip44:195`;
/**
 * Supported networks by the MultichainNetworkController
 */
exports.AVAILABLE_MULTICHAIN_NETWORK_CONFIGURATIONS = {
    [keyring_api_1.BtcScope.Mainnet]: {
        chainId: keyring_api_1.BtcScope.Mainnet,
        name: 'Bitcoin',
        nativeCurrency: exports.BTC_NATIVE_ASSET,
        isEvm: false,
    },
    [keyring_api_1.BtcScope.Testnet]: {
        chainId: keyring_api_1.BtcScope.Testnet,
        name: 'Bitcoin Testnet',
        nativeCurrency: exports.BTC_TESTNET_NATIVE_ASSET,
        isEvm: false,
    },
    [keyring_api_1.BtcScope.Testnet4]: {
        chainId: keyring_api_1.BtcScope.Testnet4,
        name: 'Bitcoin Testnet4',
        nativeCurrency: exports.BTC_TESTNET4_NATIVE_ASSET,
        isEvm: false,
    },
    [keyring_api_1.BtcScope.Signet]: {
        chainId: keyring_api_1.BtcScope.Signet,
        name: 'Bitcoin Mutinynet',
        nativeCurrency: exports.BTC_SIGNET_NATIVE_ASSET,
        isEvm: false,
    },
    [keyring_api_1.BtcScope.Regtest]: {
        chainId: keyring_api_1.BtcScope.Regtest,
        name: 'Bitcoin Regtest',
        nativeCurrency: exports.BTC_REGTEST_NATIVE_ASSET,
        isEvm: false,
    },
    [keyring_api_1.SolScope.Mainnet]: {
        chainId: keyring_api_1.SolScope.Mainnet,
        name: 'Solana',
        nativeCurrency: exports.SOL_NATIVE_ASSET,
        isEvm: false,
    },
    [keyring_api_1.SolScope.Testnet]: {
        chainId: keyring_api_1.SolScope.Testnet,
        name: 'Solana Testnet',
        nativeCurrency: exports.SOL_TESTNET_NATIVE_ASSET,
        isEvm: false,
    },
    [keyring_api_1.SolScope.Devnet]: {
        chainId: keyring_api_1.SolScope.Devnet,
        name: 'Solana Devnet',
        nativeCurrency: exports.SOL_DEVNET_NATIVE_ASSET,
        isEvm: false,
    },
    [keyring_api_1.TrxScope.Mainnet]: {
        chainId: keyring_api_1.TrxScope.Mainnet,
        name: 'Tron',
        nativeCurrency: exports.TRX_NATIVE_ASSET,
        isEvm: false,
    },
    [keyring_api_1.TrxScope.Nile]: {
        chainId: keyring_api_1.TrxScope.Nile,
        name: 'Tron Nile',
        nativeCurrency: exports.TRX_NILE_NATIVE_ASSET,
        isEvm: false,
    },
    [keyring_api_1.TrxScope.Shasta]: {
        chainId: keyring_api_1.TrxScope.Shasta,
        name: 'Tron Shasta',
        nativeCurrency: exports.TRX_SHASTA_NATIVE_ASSET,
        isEvm: false,
    },
};
/**
 * Array of all the Non-EVM chain IDs.
 * This is a temporary mention until we develop
 * a more robust solution to identify testnet networks.
 */
exports.NON_EVM_TESTNET_IDS = [
    keyring_api_1.BtcScope.Testnet,
    keyring_api_1.BtcScope.Testnet4,
    keyring_api_1.BtcScope.Signet,
    keyring_api_1.BtcScope.Regtest,
    keyring_api_1.SolScope.Testnet,
    keyring_api_1.SolScope.Devnet,
    keyring_api_1.TrxScope.Nile,
    keyring_api_1.TrxScope.Shasta,
];
/**
 * Metadata for the supported networks.
 */
exports.NETWORKS_METADATA = {
    [keyring_api_1.BtcScope.Mainnet]: {
        features: [],
        status: network_controller_1.NetworkStatus.Available,
    },
    [keyring_api_1.SolScope.Mainnet]: {
        features: [],
        status: network_controller_1.NetworkStatus.Available,
    },
    [keyring_api_1.TrxScope.Mainnet]: {
        features: [],
        status: network_controller_1.NetworkStatus.Available,
    },
};
/**
 * Default state of the {@link MultichainNetworkController}.
 *
 * @returns The default state of the {@link MultichainNetworkController}.
 */
const getDefaultMultichainNetworkControllerState = () => ({
    multichainNetworkConfigurationsByChainId: exports.AVAILABLE_MULTICHAIN_NETWORK_CONFIGURATIONS,
    selectedMultichainNetworkChainId: keyring_api_1.SolScope.Mainnet,
    isEvmSelected: true,
    networksWithTransactionActivity: {},
});
exports.getDefaultMultichainNetworkControllerState = getDefaultMultichainNetworkControllerState;
/**
 * {@link MultichainNetworkController}'s metadata.
 *
 * This allows us to choose if fields of the state should be persisted or not
 * using the `persist` flag; and if they can be sent to Sentry or not, using
 * the `anonymous` flag.
 */
exports.MULTICHAIN_NETWORK_CONTROLLER_METADATA = {
    multichainNetworkConfigurationsByChainId: {
        includeInStateLogs: true,
        persist: true,
        anonymous: true,
        usedInUi: true,
    },
    selectedMultichainNetworkChainId: {
        includeInStateLogs: true,
        persist: true,
        anonymous: true,
        usedInUi: true,
    },
    isEvmSelected: {
        includeInStateLogs: true,
        persist: true,
        anonymous: true,
        usedInUi: true,
    },
    networksWithTransactionActivity: {
        includeInStateLogs: true,
        persist: true,
        anonymous: true,
        usedInUi: true,
    },
};
/**
 * Multichain network ticker for the supported networks.
 * TODO: This should be part of the assets-controllers or the snap itself.
 */
exports.MULTICHAIN_NETWORK_TICKER = {
    [keyring_api_1.BtcScope.Mainnet]: 'BTC',
    [keyring_api_1.BtcScope.Testnet]: 'tBTC',
    [keyring_api_1.BtcScope.Testnet4]: 'tBTC',
    [keyring_api_1.BtcScope.Signet]: 'sBTC',
    [keyring_api_1.BtcScope.Regtest]: 'rBTC',
    [keyring_api_1.SolScope.Mainnet]: 'SOL',
    [keyring_api_1.SolScope.Testnet]: 'tSOL',
    [keyring_api_1.SolScope.Devnet]: 'dSOL',
    [keyring_api_1.TrxScope.Mainnet]: 'TRX',
    [keyring_api_1.TrxScope.Nile]: 'tTRX',
    [keyring_api_1.TrxScope.Shasta]: 'sTRX',
};
/**
 * Multichain network asset decimals for the supported networks.
 * TODO: This should be part of the assets-controllers or the snap itself.
 */
exports.MULTICHAIN_NETWORK_DECIMAL_PLACES = {
    [keyring_api_1.BtcScope.Mainnet]: 8,
    [keyring_api_1.BtcScope.Testnet]: 8,
    [keyring_api_1.BtcScope.Testnet4]: 8,
    [keyring_api_1.BtcScope.Signet]: 8,
    [keyring_api_1.BtcScope.Regtest]: 8,
    [keyring_api_1.SolScope.Mainnet]: 5,
    [keyring_api_1.SolScope.Testnet]: 5,
    [keyring_api_1.SolScope.Devnet]: 5,
    [keyring_api_1.TrxScope.Mainnet]: 6,
    [keyring_api_1.TrxScope.Nile]: 6,
    [keyring_api_1.TrxScope.Shasta]: 6,
};

      };
    };
  }
  }
}, {package:"@metamask/multichain-network-controller",file:"node_modules\\@metamask\\multichain-network-controller\\dist\\constants.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\index.cjs", {"./MultichainNetworkController/MultichainNetworkController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\MultichainNetworkController\\MultichainNetworkController.cjs","./MultichainNetworkService/MultichainNetworkService.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\MultichainNetworkService\\MultichainNetworkService.cjs","./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\constants.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\utils.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-network-controller%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toEvmCaipChainId = exports.toMultichainNetworkConfigurationsByChainId = exports.toMultichainNetworkConfiguration = exports.checkIfSupportedCaipChainId = exports.AVAILABLE_MULTICHAIN_NETWORK_CONFIGURATIONS = exports.MULTICHAIN_NETWORK_DECIMAL_PLACES = exports.MULTICHAIN_NETWORK_TICKER = exports.NON_EVM_TESTNET_IDS = exports.getDefaultMultichainNetworkControllerState = exports.MultichainNetworkService = exports.MultichainNetworkController = void 0;
var MultichainNetworkController_1 = require("./MultichainNetworkController/MultichainNetworkController.cjs");
Object.defineProperty(exports, "MultichainNetworkController", { enumerable: true, get: function () { return MultichainNetworkController_1.MultichainNetworkController; } });
var MultichainNetworkService_1 = require("./MultichainNetworkService/MultichainNetworkService.cjs");
Object.defineProperty(exports, "MultichainNetworkService", { enumerable: true, get: function () { return MultichainNetworkService_1.MultichainNetworkService; } });
var constants_1 = require("./constants.cjs");
Object.defineProperty(exports, "getDefaultMultichainNetworkControllerState", { enumerable: true, get: function () { return constants_1.getDefaultMultichainNetworkControllerState; } });
Object.defineProperty(exports, "NON_EVM_TESTNET_IDS", { enumerable: true, get: function () { return constants_1.NON_EVM_TESTNET_IDS; } });
Object.defineProperty(exports, "MULTICHAIN_NETWORK_TICKER", { enumerable: true, get: function () { return constants_1.MULTICHAIN_NETWORK_TICKER; } });
Object.defineProperty(exports, "MULTICHAIN_NETWORK_DECIMAL_PLACES", { enumerable: true, get: function () { return constants_1.MULTICHAIN_NETWORK_DECIMAL_PLACES; } });
Object.defineProperty(exports, "AVAILABLE_MULTICHAIN_NETWORK_CONFIGURATIONS", { enumerable: true, get: function () { return constants_1.AVAILABLE_MULTICHAIN_NETWORK_CONFIGURATIONS; } });
var utils_1 = require("./utils.cjs");
Object.defineProperty(exports, "checkIfSupportedCaipChainId", { enumerable: true, get: function () { return utils_1.checkIfSupportedCaipChainId; } });
Object.defineProperty(exports, "toMultichainNetworkConfiguration", { enumerable: true, get: function () { return utils_1.toMultichainNetworkConfiguration; } });
Object.defineProperty(exports, "toMultichainNetworkConfigurationsByChainId", { enumerable: true, get: function () { return utils_1.toMultichainNetworkConfigurationsByChainId; } });
Object.defineProperty(exports, "toEvmCaipChainId", { enumerable: true, get: function () { return utils_1.toEvmCaipChainId; } });

      };
    };
  }
  }
}, {package:"@metamask/multichain-network-controller",file:"node_modules\\@metamask\\multichain-network-controller\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\types.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-network-controller%5Cdist%5Ctypes.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MULTICHAIN_NETWORK_CONTROLLER_NAME = void 0;
exports.MULTICHAIN_NETWORK_CONTROLLER_NAME = 'MultichainNetworkController';

      };
    };
  }
  }
}, {package:"@metamask/multichain-network-controller",file:"node_modules\\@metamask\\multichain-network-controller\\dist\\types.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\utils.cjs", {"./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-network-controller\\dist\\constants.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-network-controller%5Cdist%5Cutils.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isKnownCaipNamespace = exports.toMultichainNetworkConfigurationsByChainId = exports.toMultichainNetworkConfiguration = exports.convertEvmCaipToHexChainId = exports.toEvmCaipChainId = exports.checkIfSupportedCaipChainId = exports.getChainIdForNonEvm = exports.isEvmCaipChainId = void 0;
const utils_1 = require("@metamask/utils");
const constants_1 = require("./constants.cjs");
/**
 * Checks if the chain ID is EVM.
 *
 * @param chainId - The account type to check.
 * @returns Whether the network is EVM.
 */
function isEvmCaipChainId(chainId) {
    const { namespace } = (0, utils_1.parseCaipChainId)(chainId);
    return namespace === utils_1.KnownCaipNamespace.Eip155;
}
exports.isEvmCaipChainId = isEvmCaipChainId;
/**
 * Returns the chain id of the non-EVM network based on the account scopes.
 *
 * @param scopes - The scopes to check.
 * @returns The caip chain id of the non-EVM network.
 */
function getChainIdForNonEvm(scopes) {
    const supportedScope = scopes.find((scope) => Object.keys(constants_1.AVAILABLE_MULTICHAIN_NETWORK_CONFIGURATIONS).includes(scope));
    if (supportedScope) {
        return supportedScope;
    }
    throw new Error(`Unsupported scope: ${scopes.join(', ')}.`);
}
exports.getChainIdForNonEvm = getChainIdForNonEvm;
/**
 * Checks if the Caip chain ID is supported.
 *
 * @param id - The Caip chain IDto check.
 * @returns Whether the chain ID is supported.
 */
function checkIfSupportedCaipChainId(id) {
    // Check if the chain id is supported
    return Object.keys(constants_1.AVAILABLE_MULTICHAIN_NETWORK_CONFIGURATIONS).includes(id);
}
exports.checkIfSupportedCaipChainId = checkIfSupportedCaipChainId;
/**
 * Converts a hex chain ID to a Caip chain ID.
 *
 * @param chainId - The hex chain ID to convert.
 * @returns The Caip chain ID.
 */
const toEvmCaipChainId = (chainId) => (0, utils_1.toCaipChainId)(utils_1.KnownCaipNamespace.Eip155, (0, utils_1.hexToNumber)(chainId).toString());
exports.toEvmCaipChainId = toEvmCaipChainId;
/**
 * Convert an eip155 CAIP chain ID to a hex chain ID.
 *
 * @param chainId - The CAIP chain ID to convert.
 * @returns The hex chain ID.
 */
function convertEvmCaipToHexChainId(chainId) {
    const { namespace, reference } = (0, utils_1.parseCaipChainId)(chainId);
    if (namespace === utils_1.KnownCaipNamespace.Eip155) {
        return (0, utils_1.add0x)(parseInt(reference, 10).toString(16));
    }
    throw new Error(`Unsupported CAIP chain ID namespace: ${namespace}. Only eip155 is supported.`);
}
exports.convertEvmCaipToHexChainId = convertEvmCaipToHexChainId;
/**
 * Updates a network configuration to the format used by the MultichainNetworkController.
 * This method is exclusive for EVM networks with hex identifiers from the NetworkController.
 *
 * @param network - The network configuration to update.
 * @returns The updated network configuration.
 */
const toMultichainNetworkConfiguration = (network) => {
    const { chainId, name, rpcEndpoints, defaultRpcEndpointIndex, nativeCurrency, blockExplorerUrls, defaultBlockExplorerUrlIndex, } = network;
    return {
        chainId: (0, exports.toEvmCaipChainId)(chainId),
        isEvm: true,
        name: name || rpcEndpoints[defaultRpcEndpointIndex].url,
        nativeCurrency,
        blockExplorerUrls,
        defaultBlockExplorerUrlIndex: defaultBlockExplorerUrlIndex || 0,
    };
};
exports.toMultichainNetworkConfiguration = toMultichainNetworkConfiguration;
/**
 * Updates a record of network configurations to the format used by the MultichainNetworkController.
 * This method is exclusive for EVM networks with hex identifiers from the NetworkController.
 *
 * @param networkConfigurationsByChainId - The network configurations to update.
 * @returns The updated network configurations.
 */
const toMultichainNetworkConfigurationsByChainId = (networkConfigurationsByChainId) => Object.entries(networkConfigurationsByChainId).reduce((acc, [, network]) => ({
    ...acc,
    [(0, exports.toEvmCaipChainId)(network.chainId)]: (0, exports.toMultichainNetworkConfiguration)(network),
}), {});
exports.toMultichainNetworkConfigurationsByChainId = toMultichainNetworkConfigurationsByChainId;
// TODO: This currently isn't being used anymore but could benefit from being moved to @metamask/utils
/**
 * Type guard to check if a namespace is a known CAIP namespace.
 *
 * @param namespace - The namespace to check
 * @returns Whether the namespace is a known CAIP namespace
 */
function isKnownCaipNamespace(namespace) {
    return Object.values(utils_1.KnownCaipNamespace).includes(namespace);
}
exports.isKnownCaipNamespace = isKnownCaipNamespace;

      };
    };
  }
  }
}, {package:"@metamask/multichain-network-controller",file:"node_modules\\@metamask\\multichain-network-controller\\dist\\utils.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-transactions-controller\\dist\\MultichainTransactionsController.cjs", {"@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/keyring-api":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-transactions-controller\\node_modules\\@metamask\\keyring-api\\dist\\index.cjs","@metamask/keyring-snap-client":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-transactions-controller\\node_modules\\@metamask\\keyring-snap-client\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-transactions-controller%5Cdist%5CMultichainTransactionsController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _MultichainTransactionsController_instances, _MultichainTransactionsController_listMultichainAccounts, _MultichainTransactionsController_listAccounts, _MultichainTransactionsController_getTransactions, _MultichainTransactionsController_isNonEvmAccount, _MultichainTransactionsController_handleOnAccountAdded, _MultichainTransactionsController_handleOnAccountRemoved, _MultichainTransactionsController_publishTransactionUpdateEvent, _MultichainTransactionsController_handleOnAccountTransactionsUpdated, _MultichainTransactionsController_getClient;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultichainTransactionsController = exports.getDefaultMultichainTransactionsControllerState = void 0;
const base_controller_1 = require("@metamask/base-controller");
const keyring_api_1 = require("@metamask/keyring-api");
const keyring_snap_client_1 = require("@metamask/keyring-snap-client");
const snaps_utils_1 = require("@metamask/snaps-utils");
const controllerName = 'MultichainTransactionsController';
/**
 * Constructs the default {@link MultichainTransactionsController} state.
 *
 * @returns The default {@link MultichainTransactionsController} state.
 */
function getDefaultMultichainTransactionsControllerState() {
    return {
        nonEvmTransactions: {},
    };
}
exports.getDefaultMultichainTransactionsControllerState = getDefaultMultichainTransactionsControllerState;
/**
 * {@link MultichainTransactionsController}'s metadata.
 *
 * This allows us to choose if fields of the state should be persisted or not
 * using the `persist` flag; and if they can be sent to Sentry or not, using
 * the `anonymous` flag.
 */
const multichainTransactionsControllerMetadata = {
    nonEvmTransactions: {
        persist: true,
        anonymous: false,
    },
};
/**
 * The MultichainTransactionsController is responsible for fetching and caching account
 * transactions for non-EVM accounts.
 */
class MultichainTransactionsController extends base_controller_1.BaseController {
    constructor({ messenger, state, }) {
        super({
            messenger,
            name: controllerName,
            metadata: multichainTransactionsControllerMetadata,
            state: {
                ...getDefaultMultichainTransactionsControllerState(),
                ...state,
            },
        });
        _MultichainTransactionsController_instances.add(this);
        // Fetch initial transactions for all non-EVM accounts
        for (const account of __classPrivateFieldGet(this, _MultichainTransactionsController_instances, "m", _MultichainTransactionsController_listAccounts).call(this)) {
            this.updateTransactionsForAccount(account.id).catch((error) => {
                console.error(`Failed to fetch initial transactions for account ${account.id}:`, error);
            });
        }
        this.messagingSystem.subscribe('AccountsController:accountAdded', (account) => __classPrivateFieldGet(this, _MultichainTransactionsController_instances, "m", _MultichainTransactionsController_handleOnAccountAdded).call(this, account));
        this.messagingSystem.subscribe('AccountsController:accountRemoved', (accountId) => __classPrivateFieldGet(this, _MultichainTransactionsController_instances, "m", _MultichainTransactionsController_handleOnAccountRemoved).call(this, accountId));
        this.messagingSystem.subscribe('AccountsController:accountTransactionsUpdated', (transactionsUpdate) => __classPrivateFieldGet(this, _MultichainTransactionsController_instances, "m", _MultichainTransactionsController_handleOnAccountTransactionsUpdated).call(this, transactionsUpdate));
    }
    /**
     * Updates transactions for a specific account. This is used for the initial fetch
     * when an account is first added.
     *
     * @param accountId - The ID of the account to get transactions for.
     */
    async updateTransactionsForAccount(accountId) {
        const { isUnlocked } = this.messagingSystem.call('KeyringController:getState');
        if (!isUnlocked) {
            return;
        }
        try {
            const account = __classPrivateFieldGet(this, _MultichainTransactionsController_instances, "m", _MultichainTransactionsController_listAccounts).call(this).find((accountItem) => accountItem.id === accountId);
            if (account?.metadata.snap) {
                const response = await __classPrivateFieldGet(this, _MultichainTransactionsController_instances, "m", _MultichainTransactionsController_getTransactions).call(this, account.id, account.metadata.snap.id, { limit: 10 });
                const transactionsByChain = {};
                response.data.forEach((transaction) => {
                    const { chain } = transaction;
                    if (!transactionsByChain[chain]) {
                        transactionsByChain[chain] = [];
                    }
                    transactionsByChain[chain].push(transaction);
                });
                const chainUpdates = Object.entries(transactionsByChain).map(([chain, transactions]) => ({
                    chain,
                    entry: {
                        transactions,
                        next: response.next,
                        lastUpdated: Date.now(),
                    },
                }));
                this.update((state) => {
                    if (!state.nonEvmTransactions[account.id]) {
                        state.nonEvmTransactions[account.id] = {};
                    }
                    chainUpdates.forEach(({ chain, entry }) => {
                        state.nonEvmTransactions[account.id][chain] = entry;
                    });
                });
            }
        }
        catch (error) {
            console.error(`Failed to fetch transactions for account ${accountId}:`, error);
        }
    }
}
exports.MultichainTransactionsController = MultichainTransactionsController;
_MultichainTransactionsController_instances = new WeakSet(), _MultichainTransactionsController_listMultichainAccounts = function _MultichainTransactionsController_listMultichainAccounts() {
    return this.messagingSystem.call('AccountsController:listMultichainAccounts');
}, _MultichainTransactionsController_listAccounts = function _MultichainTransactionsController_listAccounts() {
    const accounts = __classPrivateFieldGet(this, _MultichainTransactionsController_instances, "m", _MultichainTransactionsController_listMultichainAccounts).call(this);
    return accounts.filter((account) => __classPrivateFieldGet(this, _MultichainTransactionsController_instances, "m", _MultichainTransactionsController_isNonEvmAccount).call(this, account));
}, _MultichainTransactionsController_getTransactions = 
/**
 * Gets transactions for an account.
 *
 * @param accountId - The ID of the account to get transactions for.
 * @param snapId - The ID of the snap that manages the account.
 * @param pagination - Options for paginating transaction results.
 * @returns A promise that resolves to the transaction data and pagination info.
 */
async function _MultichainTransactionsController_getTransactions(accountId, snapId, pagination) {
    return await __classPrivateFieldGet(this, _MultichainTransactionsController_instances, "m", _MultichainTransactionsController_getClient).call(this, snapId).listAccountTransactions(accountId, pagination);
}, _MultichainTransactionsController_isNonEvmAccount = function _MultichainTransactionsController_isNonEvmAccount(account) {
    return (!(0, keyring_api_1.isEvmAccountType)(account.type) &&
        // Non-EVM accounts are backed by a Snap for now
        account.metadata.snap !== undefined);
}, _MultichainTransactionsController_handleOnAccountAdded = 
/**
 * Handles changes when a new account has been added.
 *
 * @param account - The new account being added.
 */
async function _MultichainTransactionsController_handleOnAccountAdded(account) {
    if (!__classPrivateFieldGet(this, _MultichainTransactionsController_instances, "m", _MultichainTransactionsController_isNonEvmAccount).call(this, account)) {
        return;
    }
    await this.updateTransactionsForAccount(account.id);
}, _MultichainTransactionsController_handleOnAccountRemoved = 
/**
 * Handles changes when a new account has been removed.
 *
 * @param accountId - The account ID being removed.
 */
async function _MultichainTransactionsController_handleOnAccountRemoved(accountId) {
    if (accountId in this.state.nonEvmTransactions) {
        this.update((state) => {
            delete state.nonEvmTransactions[accountId];
        });
    }
}, _MultichainTransactionsController_publishTransactionUpdateEvent = function _MultichainTransactionsController_publishTransactionUpdateEvent(updatedTransaction) {
    if (updatedTransaction.status === keyring_api_1.TransactionStatus.Confirmed) {
        this.messagingSystem.publish('MultichainTransactionsController:transactionConfirmed', updatedTransaction);
    }
    if (updatedTransaction.status === keyring_api_1.TransactionStatus.Submitted) {
        this.messagingSystem.publish('MultichainTransactionsController:transactionSubmitted', updatedTransaction);
    }
}, _MultichainTransactionsController_handleOnAccountTransactionsUpdated = function _MultichainTransactionsController_handleOnAccountTransactionsUpdated(transactionsUpdate) {
    const updatedTransactions = {};
    const transactionsToPublish = [];
    if (!transactionsUpdate?.transactions) {
        return;
    }
    Object.entries(transactionsUpdate.transactions).forEach(([accountId, newTransactions]) => {
        updatedTransactions[accountId] = {};
        newTransactions.forEach((tx) => {
            const { chain } = tx;
            if (!updatedTransactions[accountId][chain]) {
                updatedTransactions[accountId][chain] = [];
            }
            updatedTransactions[accountId][chain].push(tx);
            transactionsToPublish.push(tx);
        });
        Object.entries(updatedTransactions[accountId]).forEach(([chain, chainTransactions]) => {
            // Account might not have any transactions yet, so use `[]` in that case.
            const oldTransactions = this.state.nonEvmTransactions[accountId]?.[chain]
                ?.transactions ?? [];
            // Uses a `Map` to deduplicate transactions by ID, ensuring we keep the latest version
            // of each transaction while preserving older transactions and transactions from other accounts.
            // Transactions are sorted by timestamp (newest first).
            const transactions = new Map();
            oldTransactions.forEach((tx) => {
                transactions.set(tx.id, tx);
            });
            chainTransactions.forEach((tx) => {
                transactions.set(tx.id, tx);
            });
            // Sorted by timestamp (newest first). If the timestamp is not provided, those
            // transactions will be put in the end of this list.
            updatedTransactions[accountId][chain] = Array.from(transactions.values()).sort((a, b) => (b.timestamp ?? 0) - (a.timestamp ?? 0));
        });
    });
    this.update((state) => {
        Object.entries(updatedTransactions).forEach(([accountId, chainsData]) => {
            if (!state.nonEvmTransactions[accountId]) {
                state.nonEvmTransactions[accountId] = {};
            }
            Object.entries(chainsData).forEach(([chain, transactions]) => {
                state.nonEvmTransactions[accountId][chain] = {
                    transactions,
                    next: null,
                    lastUpdated: Date.now(),
                };
            });
        });
    });
    // After we update the state, publish the events for new/updated transactions
    transactionsToPublish.forEach((tx) => {
        __classPrivateFieldGet(this, _MultichainTransactionsController_instances, "m", _MultichainTransactionsController_publishTransactionUpdateEvent).call(this, tx);
    });
}, _MultichainTransactionsController_getClient = function _MultichainTransactionsController_getClient(snapId) {
    return new keyring_snap_client_1.KeyringClient({
        send: async (request) => (await this.messagingSystem.call('SnapController:handleRequest', {
            snapId: snapId,
            origin: 'metamask',
            handler: snaps_utils_1.HandlerType.OnKeyringRequest,
            request,
        })),
    });
};

      };
    };
  }
  }
}, {package:"@metamask/multichain-transactions-controller",file:"node_modules\\@metamask\\multichain-transactions-controller\\dist\\MultichainTransactionsController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-transactions-controller\\dist\\constants.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-transactions-controller%5Cdist%5Cconstants.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultichainNativeAsset = exports.MultichainNetwork = void 0;
/**
 * The network identifiers for supported networks in CAIP-2 format.
 * Note: This is a temporary workaround until we have a more robust
 * solution for network identifiers.
 */
var MultichainNetwork;
(function (MultichainNetwork) {
    MultichainNetwork["Bitcoin"] = "bip122:000000000019d6689c085ae165831e93";
    MultichainNetwork["BitcoinTestnet"] = "bip122:000000000933ea01ad0ee984209779ba";
    MultichainNetwork["Solana"] = "solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp";
    MultichainNetwork["SolanaDevnet"] = "solana:EtWTRABZaYq6iMfeYKouRu166VU2xqa1";
    MultichainNetwork["SolanaTestnet"] = "solana:4uhcVJyU9pJkvQyS88uRDiswHXSCkY3z";
})(MultichainNetwork || (exports.MultichainNetwork = MultichainNetwork = {}));
var MultichainNativeAsset;
(function (MultichainNativeAsset) {
    MultichainNativeAsset["Bitcoin"] = "bip122:000000000019d6689c085ae165831e93/slip44:0";
    MultichainNativeAsset["BitcoinTestnet"] = "bip122:000000000933ea01ad0ee984209779ba/slip44:0";
    MultichainNativeAsset["Solana"] = "solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp/slip44:501";
    MultichainNativeAsset["SolanaDevnet"] = "solana:EtWTRABZaYq6iMfeYKouRu166VU2xqa1/slip44:501";
    MultichainNativeAsset["SolanaTestnet"] = "solana:4uhcVJyU9pJkvQyS88uRDiswHXSCkY3z/slip44:501";
})(MultichainNativeAsset || (exports.MultichainNativeAsset = MultichainNativeAsset = {}));

      };
    };
  }
  }
}, {package:"@metamask/multichain-transactions-controller",file:"node_modules\\@metamask\\multichain-transactions-controller\\dist\\constants.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-transactions-controller\\dist\\index.cjs", {"./MultichainTransactionsController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-transactions-controller\\dist\\MultichainTransactionsController.cjs","./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-transactions-controller\\dist\\constants.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-transactions-controller%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultichainNativeAsset = exports.MultichainNetwork = exports.MultichainTransactionsController = void 0;
var MultichainTransactionsController_1 = require("./MultichainTransactionsController.cjs");
Object.defineProperty(exports, "MultichainTransactionsController", { enumerable: true, get: function () { return MultichainTransactionsController_1.MultichainTransactionsController; } });
var constants_1 = require("./constants.cjs");
Object.defineProperty(exports, "MultichainNetwork", { enumerable: true, get: function () { return constants_1.MultichainNetwork; } });
Object.defineProperty(exports, "MultichainNativeAsset", { enumerable: true, get: function () { return constants_1.MultichainNativeAsset; } });

      };
    };
  }
  }
}, {package:"@metamask/multichain-transactions-controller",file:"node_modules\\@metamask\\multichain-transactions-controller\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-transactions-controller\\node_modules\\@metamask\\keyring-api\\dist\\api\\account-options.cjs", {"@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-transactions-controller%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Capi%5Caccount-options.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeyringAccountOptionsStruct = exports.KeyringAccountEntropyOptionsStruct = exports.KeyringAccountEntropyPrivateKeyOptionsStruct = exports.KeyringAccountEntropyMnemonicOptionsStruct = exports.KeyringAccountEntropyTypeOption = void 0;
const keyring_utils_1 = require("@metamask/keyring-utils");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
/**
 * Keyring account entropy valid types.
 */
var KeyringAccountEntropyTypeOption;
(function (KeyringAccountEntropyTypeOption) {
    /**
     * Indicates that the account was created from a mnemonic phrase.
     */
    KeyringAccountEntropyTypeOption["Mnemonic"] = "mnemonic";
    /**
     * Indicates that the account was imported from a private key.
     */
    KeyringAccountEntropyTypeOption["PrivateKey"] = "private-key";
})(KeyringAccountEntropyTypeOption || (exports.KeyringAccountEntropyTypeOption = KeyringAccountEntropyTypeOption = {}));
/**
 * Keyring account options struct for mnemonics (BIP-44).
 */
exports.KeyringAccountEntropyMnemonicOptionsStruct = (0, superstruct_1.object)({
    /**
     * Indicates that the account was created from a mnemonic phrase.
     */
    type: (0, superstruct_1.literal)(`${KeyringAccountEntropyTypeOption.Mnemonic}`),
    /**
     * The ID of the entropy source.
     */
    id: (0, superstruct_1.string)(), // TODO: Define a struct for entropy source.
    /**
     * The BIP-44 derivation path used to derive the account.
     */
    derivationPath: (0, superstruct_1.string)(),
    /**
     * Index used to group accounts in the UI.
     *
     * Accounts sharing the same `groupIndex` are displayed together as a
     * multichain account group.
     */
    groupIndex: (0, superstruct_1.number)(),
});
/**
 * Keyring account options struct for private keys.
 */
exports.KeyringAccountEntropyPrivateKeyOptionsStruct = (0, superstruct_1.object)({
    /**
     * Indicates that the account was imported from a private key.
     */
    type: (0, superstruct_1.literal)(`${KeyringAccountEntropyTypeOption.PrivateKey}`),
});
/**
 * Keyring account entropy options struct.
 */
exports.KeyringAccountEntropyOptionsStruct = (0, keyring_utils_1.selectiveUnion)((value) => {
    return (0, utils_1.isPlainObject)(value) &&
        value.type === KeyringAccountEntropyTypeOption.PrivateKey
        ? exports.KeyringAccountEntropyPrivateKeyOptionsStruct
        : exports.KeyringAccountEntropyMnemonicOptionsStruct;
});
/**
 * Keyring options struct. This represents various options for a Keyring account object.
 *
 * See {@link KeyringAccountEntropyMnemonicOptionsStruct} and
 * {@link KeyringAccountEntropyPrivateKeyOptionsStruct}.
 *
 * @example
 * ```ts
 * {
 *   entropy: {
 *     type: 'mnemonic',
 *     id: '01K0BX6VDR5DPDPGGNA8PZVBVB',
 *     derivationPath: "m/44'/60'/0'/0/0",
 *     groupIndex: 0,
 *   },
 * }
 * ```
 *
 * @example
 * ```ts
 * {
 *   entropy: {
 *     type: 'private-key',
 *   },
 *   exportable: true,
 * }
 * ```
 *
 * @example
 * ```ts
 * {
 *   some: {
 *     untyped: 'options',
 *     something: true,
 *   },
 * }
 * ```
 */
exports.KeyringAccountOptionsStruct = (0, superstruct_1.intersection)([
    // Non-Typed options (retro-compatibility):
    (0, superstruct_1.record)((0, superstruct_1.string)(), utils_1.JsonStruct),
    // Typed options. We use `type` instead of `object` here, to allow
    // extra properties. Also, since we use `record` + `intersection` we
    // are guaranteed that all field values will match the `JsonStruct`.
    //
    // READ THIS CAREFULLY:
    // Previous options that can be matched by this struct will be breaking
    // existing keyring account options.
    (0, keyring_utils_1.type)({
        /**
         * Entropy options.
         */
        entropy: (0, keyring_utils_1.exactOptional)(exports.KeyringAccountEntropyOptionsStruct),
        /**
         * Indicates whether the account can be exported.
         */
        exportable: (0, keyring_utils_1.exactOptional)((0, superstruct_1.boolean)()),
    }),
]);

      };
    };
  }
  }
}, {package:"@metamask/multichain-transactions-controller>@metamask/keyring-api",file:"node_modules\\@metamask\\multichain-transactions-controller\\node_modules\\@metamask\\keyring-api\\dist\\api\\account-options.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-transactions-controller\\node_modules\\@metamask\\keyring-api\\dist\\api\\account.cjs", {"./account-options.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-transactions-controller\\node_modules\\@metamask\\keyring-api\\dist\\api\\account-options.cjs","./caip.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\multichain-transactions-controller\\node_modules\\@metamask\\keyring-api\\dist\\api\\caip.cjs","@metamask/keyring-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cmultichain-transactions-controller%5Cnode_modules%5C@metamask%5Ckeyring-api%5Cdist%5Capi%5Caccount.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeyringAccountStruct = exports.AnyAccountType = exports.TrxAccountType = exports.SolAccountType = exports.BtcAccountType = expor