LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\scure-bip39\\node_modules\\@scure\\base\\lib\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cscure-bip39%5Cnode_modules%5C@scure%5Cbase%5Clib%5Cindex.js
      return function (require, module, exports) {
"use strict";
/*! scure-base - MIT License (c) 2022 Paul Miller (paulmillr.com) */
Object.defineProperty(exports, "__esModule", { value: true });
exports.bytes = exports.stringToBytes = exports.str = exports.bytesToString = exports.hex = exports.utf8 = exports.bech32m = exports.bech32 = exports.base58check = exports.createBase58check = exports.base58xmr = exports.base58xrp = exports.base58flickr = exports.base58 = exports.base64urlnopad = exports.base64url = exports.base64nopad = exports.base64 = exports.base32crockford = exports.base32hexnopad = exports.base32hex = exports.base32nopad = exports.base32 = exports.base16 = exports.utils = void 0;
exports.assertNumber = assertNumber;
// Utilities
/**
 * @__NO_SIDE_EFFECTS__
 */
function assertNumber(n) {
    if (!Number.isSafeInteger(n))
        throw new Error(`Wrong integer: ${n}`);
}
function isBytes(a) {
    return (a instanceof Uint8Array ||
        (a != null && typeof a === 'object' && a.constructor.name === 'Uint8Array'));
}
/**
 * @__NO_SIDE_EFFECTS__
 */
function chain(...args) {
    const id = (a) => a;
    // Wrap call in closure so JIT can inline calls
    const wrap = (a, b) => (c) => a(b(c));
    // Construct chain of args[-1].encode(args[-2].encode([...]))
    const encode = args.map((x) => x.encode).reduceRight(wrap, id);
    // Construct chain of args[0].decode(args[1].decode(...))
    const decode = args.map((x) => x.decode).reduce(wrap, id);
    return { encode, decode };
}
/**
 * Encodes integer radix representation to array of strings using alphabet and back
 * @__NO_SIDE_EFFECTS__
 */
function alphabet(alphabet) {
    return {
        encode: (digits) => {
            if (!Array.isArray(digits) || (digits.length && typeof digits[0] !== 'number'))
                throw new Error('alphabet.encode input should be an array of numbers');
            return digits.map((i) => {
                assertNumber(i);
                if (i < 0 || i >= alphabet.length)
                    throw new Error(`Digit index outside alphabet: ${i} (alphabet: ${alphabet.length})`);
                return alphabet[i];
            });
        },
        decode: (input) => {
            if (!Array.isArray(input) || (input.length && typeof input[0] !== 'string'))
                throw new Error('alphabet.decode input should be array of strings');
            return input.map((letter) => {
                if (typeof letter !== 'string')
                    throw new Error(`alphabet.decode: not string element=${letter}`);
                const index = alphabet.indexOf(letter);
                if (index === -1)
                    throw new Error(`Unknown letter: "${letter}". Allowed: ${alphabet}`);
                return index;
            });
        },
    };
}
/**
 * @__NO_SIDE_EFFECTS__
 */
function join(separator = '') {
    if (typeof separator !== 'string')
        throw new Error('join separator should be string');
    return {
        encode: (from) => {
            if (!Array.isArray(from) || (from.length && typeof from[0] !== 'string'))
                throw new Error('join.encode input should be array of strings');
            for (let i of from)
                if (typeof i !== 'string')
                    throw new Error(`join.encode: non-string input=${i}`);
            return from.join(separator);
        },
        decode: (to) => {
            if (typeof to !== 'string')
                throw new Error('join.decode input should be string');
            return to.split(separator);
        },
    };
}
/**
 * Pad strings array so it has integer number of bits
 * @__NO_SIDE_EFFECTS__
 */
function padding(bits, chr = '=') {
    assertNumber(bits);
    if (typeof chr !== 'string')
        throw new Error('padding chr should be string');
    return {
        encode(data) {
            if (!Array.isArray(data) || (data.length && typeof data[0] !== 'string'))
                throw new Error('padding.encode input should be array of strings');
            for (let i of data)
                if (typeof i !== 'string')
                    throw new Error(`padding.encode: non-string input=${i}`);
            while ((data.length * bits) % 8)
                data.push(chr);
            return data;
        },
        decode(input) {
            if (!Array.isArray(input) || (input.length && typeof input[0] !== 'string'))
                throw new Error('padding.encode input should be array of strings');
            for (let i of input)
                if (typeof i !== 'string')
                    throw new Error(`padding.decode: non-string input=${i}`);
            let end = input.length;
            if ((end * bits) % 8)
                throw new Error('Invalid padding: string should have whole number of bytes');
            for (; end > 0 && input[end - 1] === chr; end--) {
                if (!(((end - 1) * bits) % 8))
                    throw new Error('Invalid padding: string has too much padding');
            }
            return input.slice(0, end);
        },
    };
}
/**
 * @__NO_SIDE_EFFECTS__
 */
function normalize(fn) {
    if (typeof fn !== 'function')
        throw new Error('normalize fn should be function');
    return { encode: (from) => from, decode: (to) => fn(to) };
}
/**
 * Slow: O(n^2) time complexity
 * @__NO_SIDE_EFFECTS__
 */
function convertRadix(data, from, to) {
    // base 1 is impossible
    if (from < 2)
        throw new Error(`convertRadix: wrong from=${from}, base cannot be less than 2`);
    if (to < 2)
        throw new Error(`convertRadix: wrong to=${to}, base cannot be less than 2`);
    if (!Array.isArray(data))
        throw new Error('convertRadix: data should be array');
    if (!data.length)
        return [];
    let pos = 0;
    const res = [];
    const digits = Array.from(data);
    digits.forEach((d) => {
        assertNumber(d);
        if (d < 0 || d >= from)
            throw new Error(`Wrong integer: ${d}`);
    });
    while (true) {
        let carry = 0;
        let done = true;
        for (let i = pos; i < digits.length; i++) {
            const digit = digits[i];
            const digitBase = from * carry + digit;
            if (!Number.isSafeInteger(digitBase) ||
                (from * carry) / from !== carry ||
                digitBase - digit !== from * carry) {
                throw new Error('convertRadix: carry overflow');
            }
            carry = digitBase % to;
            const rounded = Math.floor(digitBase / to);
            digits[i] = rounded;
            if (!Number.isSafeInteger(rounded) || rounded * to + carry !== digitBase)
                throw new Error('convertRadix: carry overflow');
            if (!done)
                continue;
            else if (!rounded)
                pos = i;
            else
                done = false;
        }
        res.push(carry);
        if (done)
            break;
    }
    for (let i = 0; i < data.length - 1 && data[i] === 0; i++)
        res.push(0);
    return res.reverse();
}
const gcd = /* @__NO_SIDE_EFFECTS__ */ (a, b) => (!b ? a : gcd(b, a % b));
const radix2carry = /*@__NO_SIDE_EFFECTS__ */ (from, to) => from + (to - gcd(from, to));
/**
 * Implemented with numbers, because BigInt is 5x slower
 * @__NO_SIDE_EFFECTS__
 */
function convertRadix2(data, from, to, padding) {
    if (!Array.isArray(data))
        throw new Error('convertRadix2: data should be array');
    if (from <= 0 || from > 32)
        throw new Error(`convertRadix2: wrong from=${from}`);
    if (to <= 0 || to > 32)
        throw new Error(`convertRadix2: wrong to=${to}`);
    if (radix2carry(from, to) > 32) {
        throw new Error(`convertRadix2: carry overflow from=${from} to=${to} carryBits=${radix2carry(from, to)}`);
    }
    let carry = 0;
    let pos = 0; // bitwise position in current element
    const mask = 2 ** to - 1;
    const res = [];
    for (const n of data) {
        assertNumber(n);
        if (n >= 2 ** from)
            throw new Error(`convertRadix2: invalid data word=${n} from=${from}`);
        carry = (carry << from) | n;
        if (pos + from > 32)
            throw new Error(`convertRadix2: carry overflow pos=${pos} from=${from}`);
        pos += from;
        for (; pos >= to; pos -= to)
            res.push(((carry >> (pos - to)) & mask) >>> 0);
        carry &= 2 ** pos - 1; // clean carry, otherwise it will cause overflow
    }
    carry = (carry << (to - pos)) & mask;
    if (!padding && pos >= from)
        throw new Error('Excess padding');
    if (!padding && carry)
        throw new Error(`Non-zero padding: ${carry}`);
    if (padding && pos > 0)
        res.push(carry >>> 0);
    return res;
}
/**
 * @__NO_SIDE_EFFECTS__
 */
function radix(num) {
    assertNumber(num);
    return {
        encode: (bytes) => {
            if (!isBytes(bytes))
                throw new Error('radix.encode input should be Uint8Array');
            return convertRadix(Array.from(bytes), 2 ** 8, num);
        },
        decode: (digits) => {
            if (!Array.isArray(digits) || (digits.length && typeof digits[0] !== 'number'))
                throw new Error('radix.decode input should be array of numbers');
            return Uint8Array.from(convertRadix(digits, num, 2 ** 8));
        },
    };
}
/**
 * If both bases are power of same number (like `2**8 <-> 2**64`),
 * there is a linear algorithm. For now we have implementation for power-of-two bases only.
 * @__NO_SIDE_EFFECTS__
 */
function radix2(bits, revPadding = false) {
    assertNumber(bits);
    if (bits <= 0 || bits > 32)
        throw new Error('radix2: bits should be in (0..32]');
    if (radix2carry(8, bits) > 32 || radix2carry(bits, 8) > 32)
        throw new Error('radix2: carry overflow');
    return {
        encode: (bytes) => {
            if (!isBytes(bytes))
                throw new Error('radix2.encode input should be Uint8Array');
            return convertRadix2(Array.from(bytes), 8, bits, !revPadding);
        },
        decode: (digits) => {
            if (!Array.isArray(digits) || (digits.length && typeof digits[0] !== 'number'))
                throw new Error('radix2.decode input should be array of numbers');
            return Uint8Array.from(convertRadix2(digits, bits, 8, revPadding));
        },
    };
}
/**
 * @__NO_SIDE_EFFECTS__
 */
function unsafeWrapper(fn) {
    if (typeof fn !== 'function')
        throw new Error('unsafeWrapper fn should be function');
    return function (...args) {
        try {
            return fn.apply(null, args);
        }
        catch (e) { }
    };
}
/**
 * @__NO_SIDE_EFFECTS__
 */
function checksum(len, fn) {
    assertNumber(len);
    if (typeof fn !== 'function')
        throw new Error('checksum fn should be function');
    return {
        encode(data) {
            if (!isBytes(data))
                throw new Error('checksum.encode: input should be Uint8Array');
            const checksum = fn(data).slice(0, len);
            const res = new Uint8Array(data.length + len);
            res.set(data);
            res.set(checksum, data.length);
            return res;
        },
        decode(data) {
            if (!isBytes(data))
                throw new Error('checksum.decode: input should be Uint8Array');
            const payload = data.slice(0, -len);
            const newChecksum = fn(payload).slice(0, len);
            const oldChecksum = data.slice(-len);
            for (let i = 0; i < len; i++)
                if (newChecksum[i] !== oldChecksum[i])
                    throw new Error('Invalid checksum');
            return payload;
        },
    };
}
// prettier-ignore
exports.utils = {
    alphabet, chain, checksum, convertRadix, convertRadix2, radix, radix2, join, padding,
};
// RFC 4648 aka RFC 3548
// ---------------------
exports.base16 = chain(radix2(4), alphabet('0123456789ABCDEF'), join(''));
exports.base32 = chain(radix2(5), alphabet('ABCDEFGHIJKLMNOPQRSTUVWXYZ234567'), padding(5), join(''));
exports.base32nopad = chain(radix2(5), alphabet('ABCDEFGHIJKLMNOPQRSTUVWXYZ234567'), join(''));
exports.base32hex = chain(radix2(5), alphabet('0123456789ABCDEFGHIJKLMNOPQRSTUV'), padding(5), join(''));
exports.base32hexnopad = chain(radix2(5), alphabet('0123456789ABCDEFGHIJKLMNOPQRSTUV'), join(''));
exports.base32crockford = chain(radix2(5), alphabet('0123456789ABCDEFGHJKMNPQRSTVWXYZ'), join(''), normalize((s) => s.toUpperCase().replace(/O/g, '0').replace(/[IL]/g, '1')));
exports.base64 = chain(radix2(6), alphabet('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'), padding(6), join(''));
exports.base64nopad = chain(radix2(6), alphabet('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'), join(''));
exports.base64url = chain(radix2(6), alphabet('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_'), padding(6), join(''));
exports.base64urlnopad = chain(radix2(6), alphabet('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_'), join(''));
// base58 code
// -----------
const genBase58 = (abc) => chain(radix(58), alphabet(abc), join(''));
exports.base58 = genBase58('123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz');
exports.base58flickr = genBase58('123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ');
exports.base58xrp = genBase58('rpshnaf39wBUDNEGHJKLM4PQRST7VWXYZ2bcdeCg65jkm8oFqi1tuvAxyz');
// xmr ver is done in 8-byte blocks (which equals 11 chars in decoding). Last (non-full) block padded with '1' to size in XMR_BLOCK_LEN.
// Block encoding significantly reduces quadratic complexity of base58.
// Data len (index) -> encoded block len
const XMR_BLOCK_LEN = [0, 2, 3, 5, 6, 7, 9, 10, 11];
exports.base58xmr = {
    encode(data) {
        let res = '';
        for (let i = 0; i < data.length; i += 8) {
            const block = data.subarray(i, i + 8);
            res += exports.base58.encode(block).padStart(XMR_BLOCK_LEN[block.length], '1');
        }
        return res;
    },
    decode(str) {
        let res = [];
        for (let i = 0; i < str.length; i += 11) {
            const slice = str.slice(i, i + 11);
            const blockLen = XMR_BLOCK_LEN.indexOf(slice.length);
            const block = exports.base58.decode(slice);
            for (let j = 0; j < block.length - blockLen; j++) {
                if (block[j] !== 0)
                    throw new Error('base58xmr: wrong padding');
            }
            res = res.concat(Array.from(block.slice(block.length - blockLen)));
        }
        return Uint8Array.from(res);
    },
};
const createBase58check = (sha256) => chain(checksum(4, (data) => sha256(sha256(data))), exports.base58);
exports.createBase58check = createBase58check;
// legacy export, bad name
exports.base58check = exports.createBase58check;
const BECH_ALPHABET = /* @__PURE__ */ chain(alphabet('qpzry9x8gf2tvdw0s3jn54khce6mua7l'), join(''));
const POLYMOD_GENERATORS = [0x3b6a57b2, 0x26508e6d, 0x1ea119fa, 0x3d4233dd, 0x2a1462b3];
/**
 * @__NO_SIDE_EFFECTS__
 */
function bech32Polymod(pre) {
    const b = pre >> 25;
    let chk = (pre & 0x1ffffff) << 5;
    for (let i = 0; i < POLYMOD_GENERATORS.length; i++) {
        if (((b >> i) & 1) === 1)
            chk ^= POLYMOD_GENERATORS[i];
    }
    return chk;
}
/**
 * @__NO_SIDE_EFFECTS__
 */
function bechChecksum(prefix, words, encodingConst = 1) {
    const len = prefix.length;
    let chk = 1;
    for (let i = 0; i < len; i++) {
        const c = prefix.charCodeAt(i);
        if (c < 33 || c > 126)
            throw new Error(`Invalid prefix (${prefix})`);
        chk = bech32Polymod(chk) ^ (c >> 5);
    }
    chk = bech32Polymod(chk);
    for (let i = 0; i < len; i++)
        chk = bech32Polymod(chk) ^ (prefix.charCodeAt(i) & 0x1f);
    for (let v of words)
        chk = bech32Polymod(chk) ^ v;
    for (let i = 0; i < 6; i++)
        chk = bech32Polymod(chk);
    chk ^= encodingConst;
    return BECH_ALPHABET.encode(convertRadix2([chk % 2 ** 30], 30, 5, false));
}
/**
 * @__NO_SIDE_EFFECTS__
 */
function genBech32(encoding) {
    const ENCODING_CONST = encoding === 'bech32' ? 1 : 0x2bc830a3;
    const _words = radix2(5);
    const fromWords = _words.decode;
    const toWords = _words.encode;
    const fromWordsUnsafe = unsafeWrapper(fromWords);
    function encode(prefix, words, limit = 90) {
        if (typeof prefix !== 'string')
            throw new Error(`bech32.encode prefix should be string, not ${typeof prefix}`);
        if (words instanceof Uint8Array)
            words = Array.from(words);
        if (!Array.isArray(words) || (words.length && typeof words[0] !== 'number'))
            throw new Error(`bech32.encode words should be array of numbers, not ${typeof words}`);
        if (prefix.length === 0)
            throw new TypeError(`Invalid prefix length ${prefix.length}`);
        const actualLength = prefix.length + 7 + words.length;
        if (limit !== false && actualLength > limit)
            throw new TypeError(`Length ${actualLength} exceeds limit ${limit}`);
        const lowered = prefix.toLowerCase();
        const sum = bechChecksum(lowered, words, ENCODING_CONST);
        return `${lowered}1${BECH_ALPHABET.encode(words)}${sum}`;
    }
    function decode(str, limit = 90) {
        if (typeof str !== 'string')
            throw new Error(`bech32.decode input should be string, not ${typeof str}`);
        if (str.length < 8 || (limit !== false && str.length > limit))
            throw new TypeError(`Wrong string length: ${str.length} (${str}). Expected (8..${limit})`);
        // don't allow mixed case
        const lowered = str.toLowerCase();
        if (str !== lowered && str !== str.toUpperCase())
            throw new Error(`String must be lowercase or uppercase`);
        const sepIndex = lowered.lastIndexOf('1');
        if (sepIndex === 0 || sepIndex === -1)
            throw new Error(`Letter "1" must be present between prefix and data only`);
        const prefix = lowered.slice(0, sepIndex);
        const data = lowered.slice(sepIndex + 1);
        if (data.length < 6)
            throw new Error('Data must be at least 6 characters long');
        const words = BECH_ALPHABET.decode(data).slice(0, -6);
        const sum = bechChecksum(prefix, words, ENCODING_CONST);
        if (!data.endsWith(sum))
            throw new Error(`Invalid checksum in ${str}: expected "${sum}"`);
        return { prefix, words };
    }
    const decodeUnsafe = unsafeWrapper(decode);
    function decodeToBytes(str) {
        const { prefix, words } = decode(str, false);
        return { prefix, words, bytes: fromWords(words) };
    }
    function encodeFromBytes(prefix, bytes) {
        return encode(prefix, toWords(bytes));
    }
    return {
        encode,
        decode,
        encodeFromBytes,
        decodeToBytes,
        decodeUnsafe,
        fromWords,
        fromWordsUnsafe,
        toWords,
    };
}
exports.bech32 = genBech32('bech32');
exports.bech32m = genBech32('bech32m');
exports.utf8 = {
    encode: (data) => new TextDecoder().decode(data),
    decode: (str) => new TextEncoder().encode(str),
};
exports.hex = chain(radix2(4), alphabet('0123456789abcdef'), join(''), normalize((s) => {
    if (typeof s !== 'string' || s.length % 2)
        throw new TypeError(`hex.decode: expected string, got ${typeof s} with length ${s.length}`);
    return s.toLowerCase();
}));
// prettier-ignore
const CODERS = {
    utf8: exports.utf8, hex: exports.hex, base16: exports.base16, base32: exports.base32, base64: exports.base64, base64url: exports.base64url, base58: exports.base58, base58xmr: exports.base58xmr
};
const coderTypeError = 'Invalid encoding type. Available types: utf8, hex, base16, base32, base64, base64url, base58, base58xmr';
const bytesToString = (type, bytes) => {
    if (typeof type !== 'string' || !CODERS.hasOwnProperty(type))
        throw new TypeError(coderTypeError);
    if (!isBytes(bytes))
        throw new TypeError('bytesToString() expects Uint8Array');
    return CODERS[type].encode(bytes);
};
exports.bytesToString = bytesToString;
exports.str = exports.bytesToString; // as in python, but for bytes only
const stringToBytes = (type, str) => {
    if (!CODERS.hasOwnProperty(type))
        throw new TypeError(coderTypeError);
    if (typeof str !== 'string')
        throw new TypeError('stringToBytes() expects string');
    return CODERS[type].decode(str);
};
exports.stringToBytes = stringToBytes;
exports.bytes = exports.stringToBytes;

      };
    };
  }
  }
}, {package:"@metamask/scure-bip39>@scure/base",file:"node_modules\\@metamask\\scure-bip39\\node_modules\\@scure\\base\\lib\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\SecretMetadata.cjs", {"./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\constants.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cseedless-onboarding-controller%5Cdist%5CSecretMetadata.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _SecretMetadata_data, _SecretMetadata_timestamp, _SecretMetadata_type, _SecretMetadata_version;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretMetadata = void 0;
const utils_1 = require("@metamask/utils");
const constants_1 = require("./constants.cjs");
/**
 * SecretMetadata is a class that adds metadata to the secret.
 *
 * It contains the secret and the timestamp when it was created.
 * It is used to store the secret in the metadata store.
 *
 * @example
 * ```ts
 * const secretMetadata = new SecretMetadata(secret);
 * ```
 */
class SecretMetadata {
    /**
     * Create a new SecretMetadata instance.
     *
     * @param data - The secret to add metadata to.
     * @param options - The options for the secret metadata.
     * @param options.timestamp - The timestamp when the secret was created.
     * @param options.type - The type of the secret.
     */
    constructor(data, options) {
        _SecretMetadata_data.set(this, void 0);
        _SecretMetadata_timestamp.set(this, void 0);
        _SecretMetadata_type.set(this, void 0);
        _SecretMetadata_version.set(this, void 0);
        __classPrivateFieldSet(this, _SecretMetadata_data, data, "f");
        __classPrivateFieldSet(this, _SecretMetadata_timestamp, options?.timestamp ?? Date.now(), "f");
        __classPrivateFieldSet(this, _SecretMetadata_type, options?.type ?? constants_1.SecretType.Mnemonic, "f");
        __classPrivateFieldSet(this, _SecretMetadata_version, options?.version ?? constants_1.SecretMetadataVersion.V1, "f");
    }
    /**
     * Create an Array of SecretMetadata instances from an array of secrets.
     *
     * To respect the order of the secrets, we add the index to the timestamp
     * so that the first secret backup will have the oldest timestamp
     * and the last secret backup will have the newest timestamp.
     *
     * @param data - The data to add metadata to.
     * @param data.value - The SeedPhrase/PrivateKey to add metadata to.
     * @param data.options - The options for the seed phrase metadata.
     * @returns The SecretMetadata instances.
     */
    static fromBatch(data) {
        const timestamp = Date.now();
        return data.map((d, index) => {
            // To respect the order of the seed phrases, we add the index to the timestamp
            // so that the first seed phrase backup will have the oldest timestamp
            // and the last seed phrase backup will have the newest timestamp
            const backupCreatedAt = d.options?.timestamp ?? timestamp + index * 5;
            return new SecretMetadata(d.value, {
                timestamp: backupCreatedAt,
                type: d.options?.type,
            });
        });
    }
    /**
     * Assert that the provided value is a valid seed phrase metadata.
     *
     * @param value - The value to check.
     * @throws If the value is not a valid seed phrase metadata.
     */
    static assertIsValidSecretMetadataJson(value) {
        if (typeof value !== 'object' ||
            !value ||
            !('data' in value) ||
            typeof value.data !== 'string' ||
            !('timestamp' in value) ||
            typeof value.timestamp !== 'number') {
            throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.InvalidSecretMetadata);
        }
    }
    /**
     * Parse the SecretMetadata from the metadata store and return the array of SecretMetadata instances.
     *
     * This method also sorts the secrets by timestamp in ascending order, i.e. the oldest secret will be the first element in the array.
     *
     * @param secretMetadataArr - The array of SecretMetadata from the metadata store.
     * @param filterType - The type of the secret to filter.
     * @returns The array of SecretMetadata instances.
     */
    static parseSecretsFromMetadataStore(secretMetadataArr, filterType) {
        const parsedSecertMetadata = secretMetadataArr.map((metadata) => SecretMetadata.fromRawMetadata(metadata));
        const secrets = SecretMetadata.sort(parsedSecertMetadata);
        if (filterType) {
            return secrets.filter((secret) => secret.type === filterType);
        }
        return secrets;
    }
    /**
     * Parse and create the SecretMetadata instance from the raw metadata bytes.
     *
     * @param rawMetadata - The raw metadata.
     * @returns The parsed secret metadata.
     */
    static fromRawMetadata(rawMetadata) {
        const serializedMetadata = (0, utils_1.bytesToString)(rawMetadata);
        const parsedMetadata = JSON.parse(serializedMetadata);
        SecretMetadata.assertIsValidSecretMetadataJson(parsedMetadata);
        // if the type is not provided, we default to Mnemonic for the backwards compatibility
        const type = parsedMetadata.type ?? constants_1.SecretType.Mnemonic;
        const version = parsedMetadata.version ?? constants_1.SecretMetadataVersion.V1;
        let data;
        try {
            data = (0, utils_1.base64ToBytes)(parsedMetadata.data);
        }
        catch {
            data = parsedMetadata.data;
        }
        return new SecretMetadata(data, {
            timestamp: parsedMetadata.timestamp,
            type,
            version,
        });
    }
    /**
     * Sort the seed phrases by timestamp.
     *
     * @param data - The secret metadata array to sort.
     * @param order - The order to sort the seed phrases. Default is `desc`.
     *
     * @returns The sorted secret metadata array.
     */
    static sort(data, order = 'asc') {
        return data.sort((a, b) => {
            if (order === 'asc') {
                return a.timestamp - b.timestamp;
            }
            return b.timestamp - a.timestamp;
        });
    }
    get data() {
        return __classPrivateFieldGet(this, _SecretMetadata_data, "f");
    }
    get timestamp() {
        return __classPrivateFieldGet(this, _SecretMetadata_timestamp, "f");
    }
    get type() {
        return __classPrivateFieldGet(this, _SecretMetadata_type, "f");
    }
    get version() {
        return __classPrivateFieldGet(this, _SecretMetadata_version, "f");
    }
    /**
     * Serialize the secret metadata and convert it to a Uint8Array.
     *
     * @returns The serialized SecretMetadata value in bytes.
     */
    toBytes() {
        let _data = __classPrivateFieldGet(this, _SecretMetadata_data, "f");
        if (__classPrivateFieldGet(this, _SecretMetadata_data, "f") instanceof Uint8Array) {
            // encode the raw secret to base64 encoded string
            // to create more compacted metadata
            _data = (0, utils_1.bytesToBase64)(__classPrivateFieldGet(this, _SecretMetadata_data, "f"));
        }
        // serialize the metadata to a JSON string
        const serializedMetadata = JSON.stringify({
            data: _data,
            timestamp: __classPrivateFieldGet(this, _SecretMetadata_timestamp, "f"),
            type: __classPrivateFieldGet(this, _SecretMetadata_type, "f"),
            version: __classPrivateFieldGet(this, _SecretMetadata_version, "f"),
        });
        // convert the serialized metadata to bytes(Uint8Array)
        return (0, utils_1.stringToBytes)(serializedMetadata);
    }
}
exports.SecretMetadata = SecretMetadata;
_SecretMetadata_data = new WeakMap(), _SecretMetadata_timestamp = new WeakMap(), _SecretMetadata_type = new WeakMap(), _SecretMetadata_version = new WeakMap();

      };
    };
  }
  }
}, {package:"@metamask/seedless-onboarding-controller",file:"node_modules\\@metamask\\seedless-onboarding-controller\\dist\\SecretMetadata.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\SeedlessOnboardingController.cjs", {"./SecretMetadata.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\SecretMetadata.cjs","./assertions.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\assertions.cjs","./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\constants.cjs","./errors.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\errors.cjs","./logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\logger.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\utils.cjs","@metamask/auth-network-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\auth-network-utils\\dist\\index.cjs","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/toprf-secure-backup":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\toprf-secure-backup\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","@noble/ciphers/aes":"D:\\code\\v\\metamask-extension\\node_modules\\@noble\\ciphers\\aes.js","@noble/ciphers/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@noble\\ciphers\\utils.js","@noble/ciphers/webcrypto":"D:\\code\\v\\metamask-extension\\node_modules\\@noble\\ciphers\\webcrypto.js","@noble/curves/secp256k1":"D:\\code\\v\\metamask-extension\\node_modules\\@noble\\curves\\secp256k1.js","async-mutex":"D:\\code\\v\\metamask-extension\\node_modules\\async-mutex\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cseedless-onboarding-controller%5Cdist%5CSeedlessOnboardingController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _SeedlessOnboardingController_instances, _SeedlessOnboardingController_vaultEncryptor, _SeedlessOnboardingController_controllerOperationMutex, _SeedlessOnboardingController_vaultOperationMutex, _SeedlessOnboardingController_refreshJWTToken, _SeedlessOnboardingController_revokeRefreshToken, _SeedlessOnboardingController_renewRefreshToken, _SeedlessOnboardingController_passwordOutdatedCacheTTL, _SeedlessOnboardingController_isUnlocked, _SeedlessOnboardingController_cachedDecryptedVaultData, _SeedlessOnboardingController_submitGlobalPassword, _SeedlessOnboardingController_getAccessToken, _SeedlessOnboardingController_setUnlocked, _SeedlessOnboardingController_persistOprfKey, _SeedlessOnboardingController_persistAuthPubKey, _SeedlessOnboardingController_storeKeyringEncryptionKey, _SeedlessOnboardingController_loadKeyringEncryptionKey, _SeedlessOnboardingController_loadSeedlessEncryptionKey, _SeedlessOnboardingController_recoverAuthPubKey, _SeedlessOnboardingController_recoverEncKey, _SeedlessOnboardingController_fetchAllSecretDataFromMetadataStore, _SeedlessOnboardingController_changeEncryptionKey, _SeedlessOnboardingController_encryptAndStoreSecretData, _SeedlessOnboardingController_unlockVaultAndGetVaultData, _SeedlessOnboardingController_decryptAndParseVaultData, _SeedlessOnboardingController_withPersistedSecretMetadataBackupsState, _SeedlessOnboardingController_filterDupesAndUpdateSocialBackupsMetadata, _SeedlessOnboardingController_createNewVaultWithAuthData, _SeedlessOnboardingController_updateVault, _SeedlessOnboardingController_withControllerLock, _SeedlessOnboardingController_withVaultLock, _SeedlessOnboardingController_parseVaultData, _SeedlessOnboardingController_assertIsUnlocked, _SeedlessOnboardingController_assertIsAuthenticatedUser, _SeedlessOnboardingController_assertIsSRPBackedUpUser, _SeedlessOnboardingController_assertPasswordInSync, _SeedlessOnboardingController_resetPasswordOutdatedCache, _SeedlessOnboardingController_addRefreshTokenToRevokeList, _SeedlessOnboardingController_isTokenExpiredError, _SeedlessOnboardingController_isMaxKeyChainLengthError, _SeedlessOnboardingController_executeWithTokenRefresh;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SeedlessOnboardingController = exports.getInitialSeedlessOnboardingControllerStateWithDefaults = void 0;
const auth_network_utils_1 = require("@metamask/auth-network-utils");
const base_controller_1 = require("@metamask/base-controller");
const toprf_secure_backup_1 = require("@metamask/toprf-secure-backup");
const utils_1 = require("@metamask/utils");
const aes_1 = require("@noble/ciphers/aes");
const utils_2 = require("@noble/ciphers/utils");
const webcrypto_1 = require("@noble/ciphers/webcrypto");
const secp256k1_1 = require("@noble/curves/secp256k1");
const async_mutex_1 = require("async-mutex");
const assertions_1 = require("./assertions.cjs");
const constants_1 = require("./constants.cjs");
const errors_1 = require("./errors.cjs");
const logger_1 = require("./logger.cjs");
const SecretMetadata_1 = require("./SecretMetadata.cjs");
const utils_3 = require("./utils.cjs");
const log = (0, logger_1.createModuleLogger)(logger_1.projectLogger, constants_1.controllerName);
/**
 * Get the initial state for the Seedless Onboarding Controller with defaults.
 *
 * @param overrides - The overrides for the initial state.
 * @returns The initial state for the Seedless Onboarding Controller.
 */
function getInitialSeedlessOnboardingControllerStateWithDefaults(overrides) {
    const initialState = {
        socialBackupsMetadata: [],
        isSeedlessOnboardingUserAuthenticated: false,
        ...overrides,
    };
    // Ensure authenticated flag is set correctly.
    try {
        (0, assertions_1.assertIsSeedlessOnboardingUserAuthenticated)(initialState);
        initialState.isSeedlessOnboardingUserAuthenticated = true;
    }
    catch {
        initialState.isSeedlessOnboardingUserAuthenticated = false;
    }
    return initialState;
}
exports.getInitialSeedlessOnboardingControllerStateWithDefaults = getInitialSeedlessOnboardingControllerStateWithDefaults;
/**
 * Seedless Onboarding Controller State Metadata.
 *
 * This allows us to choose if fields of the state should be persisted or not
 * using the `persist` flag; and if they can be sent to Sentry or not, using
 * the `anonymous` flag.
 */
const seedlessOnboardingMetadata = {
    vault: {
        persist: true,
        anonymous: false,
    },
    socialBackupsMetadata: {
        persist: true,
        anonymous: false,
    },
    nodeAuthTokens: {
        persist: true,
        anonymous: false,
    },
    authConnection: {
        persist: true,
        anonymous: true,
    },
    authConnectionId: {
        persist: true,
        anonymous: true,
    },
    groupedAuthConnectionId: {
        persist: true,
        anonymous: true,
    },
    userId: {
        persist: true,
        anonymous: false,
    },
    socialLoginEmail: {
        persist: true,
        anonymous: false,
    },
    vaultEncryptionKey: {
        persist: false,
        anonymous: false,
    },
    vaultEncryptionSalt: {
        persist: false,
        anonymous: false,
    },
    authPubKey: {
        persist: true,
        anonymous: false,
    },
    passwordOutdatedCache: {
        persist: true,
        anonymous: true,
    },
    refreshToken: {
        persist: true,
        anonymous: false,
    },
    revokeToken: {
        persist: false,
        anonymous: false,
    },
    pendingToBeRevokedTokens: {
        persist: true,
        anonymous: false,
    },
    // stays in vault
    accessToken: {
        persist: false,
        anonymous: false,
    },
    // stays outside of vault as this token is accessed by the metadata service
    // before the vault is created or unlocked.
    metadataAccessToken: {
        persist: true,
        anonymous: false,
    },
    encryptedSeedlessEncryptionKey: {
        persist: true,
        anonymous: false,
    },
    encryptedKeyringEncryptionKey: {
        persist: true,
        anonymous: false,
    },
    isSeedlessOnboardingUserAuthenticated: {
        persist: true,
        anonymous: true,
    },
};
class SeedlessOnboardingController extends base_controller_1.BaseController {
    /**
     * Creates a new SeedlessOnboardingController instance.
     *
     * @param options - The options for the SeedlessOnboardingController.
     * @param options.messenger - A restricted messenger.
     * @param options.state - Initial state to set on this controller.
     * @param options.encryptor - An optional encryptor to use for encrypting and decrypting seedless onboarding vault.
     * @param options.toprfKeyDeriver - An optional key derivation interface for the TOPRF client.
     * @param options.network - The network to be used for the Seedless Onboarding flow.
     * @param options.refreshJWTToken - A function to get a new jwt token using refresh token.
     * @param options.revokeRefreshToken - A function to revoke the refresh token.
     * @param options.renewRefreshToken - A function to renew the refresh token and get new revoke token.
     * @param options.passwordOutdatedCacheTTL - The TTL of the password outdated cache in milliseconds.,
     */
    constructor({ messenger, state, encryptor, toprfKeyDeriver, network = constants_1.Web3AuthNetwork.Mainnet, refreshJWTToken, revokeRefreshToken, renewRefreshToken, passwordOutdatedCacheTTL = constants_1.PASSWORD_OUTDATED_CACHE_TTL_MS, }) {
        super({
            name: constants_1.controllerName,
            metadata: seedlessOnboardingMetadata,
            state: getInitialSeedlessOnboardingControllerStateWithDefaults(state),
            messenger,
        });
        _SeedlessOnboardingController_instances.add(this);
        _SeedlessOnboardingController_vaultEncryptor.set(this, void 0);
        _SeedlessOnboardingController_controllerOperationMutex.set(this, new async_mutex_1.Mutex());
        _SeedlessOnboardingController_vaultOperationMutex.set(this, new async_mutex_1.Mutex());
        _SeedlessOnboardingController_refreshJWTToken.set(this, void 0);
        _SeedlessOnboardingController_revokeRefreshToken.set(this, void 0);
        _SeedlessOnboardingController_renewRefreshToken.set(this, void 0);
        /**
         * The TTL of the password outdated cache in milliseconds.
         */
        _SeedlessOnboardingController_passwordOutdatedCacheTTL.set(this, void 0);
        /**
         * Controller lock state.
         *
         * The controller lock is synchronized with the keyring lock.
         */
        _SeedlessOnboardingController_isUnlocked.set(this, false);
        /**
         * Cached decrypted vault data.
         *
         * This is used to cache the decrypted vault data to avoid decrypting the vault data multiple times.
         */
        _SeedlessOnboardingController_cachedDecryptedVaultData.set(this, void 0);
        (0, assertions_1.assertIsPasswordOutdatedCacheValid)(passwordOutdatedCacheTTL);
        __classPrivateFieldSet(this, _SeedlessOnboardingController_passwordOutdatedCacheTTL, passwordOutdatedCacheTTL, "f");
        __classPrivateFieldSet(this, _SeedlessOnboardingController_vaultEncryptor, encryptor, "f");
        this.toprfClient = new toprf_secure_backup_1.ToprfSecureBackup({
            network,
            keyDeriver: toprfKeyDeriver,
            fetchMetadataAccessCreds: this.fetchMetadataAccessCreds.bind(this),
        });
        __classPrivateFieldSet(this, _SeedlessOnboardingController_refreshJWTToken, refreshJWTToken, "f");
        __classPrivateFieldSet(this, _SeedlessOnboardingController_revokeRefreshToken, revokeRefreshToken, "f");
        __classPrivateFieldSet(this, _SeedlessOnboardingController_renewRefreshToken, renewRefreshToken, "f");
    }
    async fetchMetadataAccessCreds() {
        const { metadataAccessToken } = this.state;
        if (!metadataAccessToken) {
            throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.InvalidMetadataAccessToken);
        }
        // Check if token is expired and refresh if needed
        const decodedToken = (0, utils_3.decodeJWTToken)(metadataAccessToken);
        if (decodedToken.exp < Math.floor(Date.now() / 1000)) {
            // Token is expired, refresh it
            await this.refreshAuthTokens();
            // Get the new token after refresh
            const { metadataAccessToken: newMetadataAccessToken } = this.state;
            return {
                metadataAccessToken: newMetadataAccessToken,
            };
        }
        return { metadataAccessToken };
    }
    /**
     * Authenticate OAuth user using the seedless onboarding flow
     * and determine if the user is already registered or not.
     *
     * @param params - The parameters for authenticate OAuth user.
     * @param params.idTokens - The ID token(s) issued by OAuth verification service. Currently this array only contains a single idToken which is verified by all the nodes, in future we are considering to issue a unique idToken for each node.
     * @param params.authConnection - The social login provider.
     * @param params.authConnectionId - OAuth authConnectionId from dashboard
     * @param params.userId - user email or id from Social login
     * @param params.groupedAuthConnectionId - Optional grouped authConnectionId to be used for the authenticate request.
     * @param params.socialLoginEmail - The user email from Social login.
     * @param params.refreshToken - refresh token for refreshing expired nodeAuthTokens.
     * @param params.revokeToken - revoke token for revoking refresh token and get new refresh token and new revoke token.
     * @param params.accessToken - Access token for pairing with profile sync auth service and to access other services.
     * @param params.metadataAccessToken - Metadata access token for accessing the metadata service before the vault is created or unlocked.
     * @param params.skipLock - Optional flag to skip acquiring the controller lock. (to prevent deadlock in case the caller already acquired the lock)
     * @returns A promise that resolves to the authentication result.
     */
    async authenticate(params) {
        const doAuthenticateWithNodes = async () => {
            try {
                const { idTokens, authConnectionId, groupedAuthConnectionId, userId, authConnection, socialLoginEmail, refreshToken, revokeToken, accessToken, metadataAccessToken, } = params;
                const authenticationResult = await this.toprfClient.authenticate({
                    authConnectionId,
                    userId,
                    idTokens,
                    groupedAuthConnectionId,
                });
                // update the state with the authenticated user info
                this.update((state) => {
                    state.nodeAuthTokens = authenticationResult.nodeAuthTokens;
                    state.authConnectionId = authConnectionId;
                    state.groupedAuthConnectionId = groupedAuthConnectionId;
                    state.userId = userId;
                    state.authConnection = authConnection;
                    state.socialLoginEmail = socialLoginEmail;
                    state.metadataAccessToken = metadataAccessToken;
                    state.accessToken = accessToken;
                    if (refreshToken) {
                        state.refreshToken = refreshToken;
                    }
                    if (revokeToken) {
                        // Temporarily store revoke token in state for later vault creation
                        state.revokeToken = revokeToken;
                    }
                    // we will check if the controller state is properly set with the authenticated user info
                    // before setting the isSeedlessOnboardingUserAuthenticated to true
                    (0, assertions_1.assertIsSeedlessOnboardingUserAuthenticated)(state);
                    state.isSeedlessOnboardingUserAuthenticated = true;
                });
                return authenticationResult;
            }
            catch (error) {
                log('Error authenticating user', error);
                throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.AuthenticationError);
            }
        };
        return params.skipLock
            ? await doAuthenticateWithNodes()
            : await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_withControllerLock).call(this, doAuthenticateWithNodes);
    }
    /**
     * Create a new TOPRF encryption key using given password and backups the provided seed phrase.
     *
     * @param password - The password used to create new wallet and seedphrase
     * @param seedPhrase - The initial seed phrase (Mnemonic) created together with the wallet.
     * @param keyringId - The keyring id of the backup seed phrase
     * @returns A promise that resolves to the encrypted seed phrase and the encryption key.
     */
    async createToprfKeyAndBackupSeedPhrase(password, seedPhrase, keyringId) {
        return await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_withControllerLock).call(this, async () => {
            // to make sure that fail fast,
            // assert that the user is authenticated before creating the TOPRF key and backing up the seed phrase
            __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_assertIsAuthenticatedUser).call(this, this.state);
            // locally evaluate the encryption key from the password
            const { encKey, pwEncKey, authKeyPair, oprfKey } = await this.toprfClient.createLocalKey({
                password,
            });
            const performKeyCreationAndBackup = async () => {
                // encrypt and store the secret data
                await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_encryptAndStoreSecretData).call(this, {
                    data: seedPhrase,
                    type: constants_1.SecretType.Mnemonic,
                    encKey,
                    authKeyPair,
                    options: {
                        keyringId,
                    },
                });
                // store/persist the encryption key shares
                // We store the secret metadata in the metadata store first. If this operation fails,
                // we avoid persisting the encryption key shares to prevent a situation where a user appears
                // to have an account but with no associated data.
                await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_persistOprfKey).call(this, oprfKey, authKeyPair.pk);
                // create a new vault with the resulting authentication data
                await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_createNewVaultWithAuthData).call(this, {
                    password,
                    rawToprfEncryptionKey: encKey,
                    rawToprfPwEncryptionKey: pwEncKey,
                    rawToprfAuthKeyPair: authKeyPair,
                });
            };
            await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_executeWithTokenRefresh).call(this, performKeyCreationAndBackup, 'createToprfKeyAndBackupSeedPhrase');
        });
    }
    /**
     * encrypt and add a new secret data to the metadata store.
     *
     * @param data - The data to add.
     * @param type - The type of the secret data.
     * @param options - Optional options object, which includes optional data to be added to the metadata store.
     * @param options.keyringId - The keyring id of the backup keyring (SRP).
     * @returns A promise that resolves to the success of the operation.
     */
    async addNewSecretData(data, type, options) {
        return await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_withControllerLock).call(this, async () => {
            __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_assertIsUnlocked).call(this);
            await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_assertPasswordInSync).call(this, {
                skipCache: true,
                skipLock: true, // skip lock since we already have the lock
            });
            const performBackup = async () => {
                // verify the password and unlock the vault
                const { toprfEncryptionKey, toprfAuthKeyPair } = await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_unlockVaultAndGetVaultData).call(this);
                // encrypt and store the secret data
                await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_encryptAndStoreSecretData).call(this, {
                    data,
                    type,
                    encKey: toprfEncryptionKey,
                    authKeyPair: toprfAuthKeyPair,
                    options,
                });
            };
            await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_executeWithTokenRefresh).call(this, performBackup, 'addNewSecretData');
        });
    }
    /**
     * Fetches all encrypted secret data and metadata for user's account from the metadata store.
     *
     * Decrypts the secret data and returns the decrypted secret data using the recovered encryption key from the password.
     *
     * @param password - The optional password used to create new wallet. If not provided, `cached Encryption Key` will be used.
     * @returns A promise that resolves to the secret data.
     */
    async fetchAllSecretData(password) {
        return await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_withControllerLock).call(this, async () => {
            // assert that the user is authenticated before fetching the secret data
            __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_assertIsAuthenticatedUser).call(this, this.state);
            let encKey;
            let pwEncKey;
            let authKeyPair;
            if (password) {
                const recoverEncKeyResult = await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_recoverEncKey).call(this, password);
                encKey = recoverEncKeyResult.encKey;
                pwEncKey = recoverEncKeyResult.pwEncKey;
                authKeyPair = recoverEncKeyResult.authKeyPair;
            }
            else {
                __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_assertIsUnlocked).call(this);
                // verify the password and unlock the vault
                const keysFromVault = await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_unlockVaultAndGetVaultData).call(this);
                encKey = keysFromVault.toprfEncryptionKey;
                pwEncKey = keysFromVault.toprfPwEncryptionKey;
                authKeyPair = keysFromVault.toprfAuthKeyPair;
            }
            const performFetch = async () => {
                const secrets = await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_fetchAllSecretDataFromMetadataStore).call(this, encKey, authKeyPair);
                if (password) {
                    // if password is provided, we need to create a new vault with the auth data. (supposedly the user is trying to rehydrate the wallet)
                    await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_createNewVaultWithAuthData).call(this, {
                        password,
                        rawToprfEncryptionKey: encKey,
                        rawToprfPwEncryptionKey: pwEncKey,
                        rawToprfAuthKeyPair: authKeyPair,
                    });
                }
                return secrets;
            };
            return await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_executeWithTokenRefresh).call(this, performFetch, 'fetchAllSecretData');
        });
    }
    /**
     * Update the password of the seedless onboarding flow.
     *
     * Changing password will also update the encryption key, metadata store and the vault with new encrypted values.
     *
     * @param newPassword - The new password to update.
     * @param oldPassword - The old password to verify.
     * @returns A promise that resolves to the success of the operation.
     */
    async changePassword(newPassword, oldPassword) {
        return await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_withControllerLock).call(this, async () => {
            __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_assertIsUnlocked).call(this);
            // verify the old password of the encrypted vault
            await this.verifyVaultPassword(oldPassword, {
                skipLock: true, // skip lock since we already have the lock
            });
            const { latestKeyIndex } = await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_assertPasswordInSync).call(this, {
                skipCache: true,
                skipLock: true, // skip lock since we already have the lock
            });
            const attemptChangePassword = async () => {
                // load keyring encryption key if it exists
                let keyringEncryptionKey;
                if (this.state.encryptedKeyringEncryptionKey) {
                    keyringEncryptionKey = await this.loadKeyringEncryptionKey();
                }
                // update the encryption key with new password and update the Metadata Store
                const { encKey: newEncKey, pwEncKey: newPwEncKey, authKeyPair: newAuthKeyPair, } = await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_changeEncryptionKey).call(this, {
                    oldPassword,
                    newPassword,
                    latestKeyIndex,
                });
                // update and encrypt the vault with new password
                await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_createNewVaultWithAuthData).call(this, {
                    password: newPassword,
                    rawToprfEncryptionKey: newEncKey,
                    rawToprfPwEncryptionKey: newPwEncKey,
                    rawToprfAuthKeyPair: newAuthKeyPair,
                });
                __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_resetPasswordOutdatedCache).call(this);
                // store the keyring encryption key if it exists
                if (keyringEncryptionKey) {
                    await this.storeKeyringEncryptionKey(keyringEncryptionKey);
                }
            };
            try {
                await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_executeWithTokenRefresh).call(this, attemptChangePassword, 'changePassword');
            }
            catch (error) {
                log('Error changing password', error);
                throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.FailedToChangePassword);
            }
        });
    }
    /**
     * Update the backup metadata state for the given secret data.
     *
     * @param secretData - The data to backup, can be a single backup or array of backups.
     * @param secretData.keyringId - The keyring id associated with the backup secret data.
     * @param secretData.data - The secret data to update the backup metadata state.
     */
    updateBackupMetadataState(secretData) {
        __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_assertIsUnlocked).call(this);
        __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_filterDupesAndUpdateSocialBackupsMetadata).call(this, secretData);
    }
    /**
     * Verify the password validity by decrypting the vault.
     *
     * @param password - The password to verify.
     * @param options - Optional options object.
     * @param options.skipLock - Whether to skip the lock acquisition. (to prevent deadlock in case the caller already acquired the lock)
     * @returns A promise that resolves to the success of the operation.
     * @throws {Error} If the password is invalid or the vault is not initialized.
     */
    async verifyVaultPassword(password, options) {
        const doVerify = async () => {
            if (!this.state.vault) {
                throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.VaultError);
            }
            await __classPrivateFieldGet(this, _SeedlessOnboardingController_vaultEncryptor, "f").decrypt(password, this.state.vault);
        };
        return options?.skipLock
            ? await doVerify()
            : await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_withControllerLock).call(this, doVerify);
    }
    /**
     * Get backup state of the given secret data, from the controller state.
     *
     * If the given secret data is not backed up and not found in the state, it will return `undefined`.
     *
     * @param data - The data to get the backup state of.
     * @param type - The type of the secret data.
     * @returns The backup state of the given secret data.
     */
    getSecretDataBackupState(data, type = constants_1.SecretType.Mnemonic) {
        const secretDataHash = (0, auth_network_utils_1.keccak256AndHexify)(data);
        return this.state.socialBackupsMetadata.find((backup) => backup.hash === secretDataHash && backup.type === type);
    }
    /**
     * Submit the password to the controller, verify the password validity and unlock the controller.
     *
     * This method will be used especially when user rehydrate/unlock the wallet.
     * The provided password will be verified against the encrypted vault, encryption key will be derived and saved in the controller state.
     *
     * This operation is useful when user performs some actions that requires the user password/encryption key. e.g. add new srp backup
     *
     * @param password - The password to submit.
     * @returns A promise that resolves to the success of the operation.
     */
    async submitPassword(password) {
        return await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_withControllerLock).call(this, async () => {
            await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_unlockVaultAndGetVaultData).call(this, { password });
            __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_setUnlocked).call(this);
        });
    }
    /**
     * Set the controller to locked state, and deallocate the secrets (vault encryption key and salt).
     *
     * When the controller is locked, the user will not be able to perform any operations on the controller/vault.
     *
     * @returns A promise that resolves to the success of the operation.
     */
    async setLocked() {
        return await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_withControllerLock).call(this, async () => {
            this.update((state) => {
                delete state.vaultEncryptionKey;
                delete state.vaultEncryptionSalt;
                delete state.revokeToken;
                delete state.accessToken;
            });
            __classPrivateFieldSet(this, _SeedlessOnboardingController_cachedDecryptedVaultData, undefined, "f");
            __classPrivateFieldSet(this, _SeedlessOnboardingController_isUnlocked, false, "f");
        });
    }
    /**
     * Sync the latest global password to the controller.
     * reset vault with latest globalPassword,
     * persist the latest global password authPubKey
     *
     * @param params - The parameters for syncing the latest global password.
     * @param params.globalPassword - The latest global password.
     * @returns A promise that resolves to the success of the operation.
     */
    async syncLatestGlobalPassword({ globalPassword, }) {
        return await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_withControllerLock).call(this, async () => {
            __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_assertIsUnlocked).call(this);
            const doSyncPassword = async () => {
                // update vault with latest globalPassword
                const { encKey, pwEncKey, authKeyPair } = await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_recoverEncKey).call(this, globalPassword);
                // update and encrypt the vault with new password
                await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_createNewVaultWithAuthData).call(this, {
                    password: globalPassword,
                    rawToprfEncryptionKey: encKey,
                    rawToprfPwEncryptionKey: pwEncKey,
                    rawToprfAuthKeyPair: authKeyPair,
                });
                __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_resetPasswordOutdatedCache).call(this);
            };
            return await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_executeWithTokenRefresh).call(this, doSyncPassword, 'syncLatestGlobalPassword');
        });
    }
    /**
     * @description Unlock the controller with the latest global password.
     *
     * @param params - The parameters for unlocking the controller.
     * @param params.maxKeyChainLength - The maximum chain length of the pwd encryption keys.
     * @param params.globalPassword - The latest global password.
     * @returns A promise that resolves to the success of the operation.
     */
    async submitGlobalPassword({ globalPassword, maxKeyChainLength = 5, }) {
        return await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_withControllerLock).call(this, async () => {
            return await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_executeWithTokenRefresh).call(this, async () => {
                const currentDeviceAuthPubKey = __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_recoverAuthPubKey).call(this);
                await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_submitGlobalPassword).call(this, {
                    targetAuthPubKey: currentDeviceAuthPubKey,
                    globalPassword,
                    maxKeyChainLength,
                });
            }, 'submitGlobalPassword');
        });
    }
    /**
     * @description Check if the current password is outdated compare to the global password.
     *
     * @param options - Optional options object.
     * @param options.globalAuthPubKey - The global auth public key to compare with the current auth public key.
     * If not provided, the global auth public key will be fetched from the backend.
     * @param options.skipCache - If true, bypass the cache and force a fresh check.
     * @param options.skipLock - Whether to skip the lock acquisition. (to prevent deadlock in case the caller already acquired the lock)
     * @returns A promise that resolves to true if the password is outdated, false otherwise.
     */
    async checkIsPasswordOutdated(options) {
        const doCheckIsPasswordExpired = async () => {
            __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_assertIsAuthenticatedUser).call(this, this.state);
            // cache result to reduce load on infra
            // Check cache first unless skipCache is true
            if (!options?.skipCache) {
                const { passwordOutdatedCache } = this.state;
                const now = Date.now();
                const isCacheValid = passwordOutdatedCache &&
                    now - passwordOutdatedCache.timestamp <
                        __classPrivateFieldGet(this, _SeedlessOnboardingController_passwordOutdatedCacheTTL, "f");
                if (isCacheValid) {
                    return passwordOutdatedCache.isExpiredPwd;
                }
            }
            const { nodeAuthTokens, authConnectionId, groupedAuthConnectionId, userId, } = this.state;
            const currentDeviceAuthPubKey = __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_recoverAuthPubKey).call(this);
            let globalAuthPubKey = options?.globalAuthPubKey;
            if (!globalAuthPubKey) {
                const { authPubKey } = await this.toprfClient
                    .fetchAuthPubKey({
                    nodeAuthTokens,
                    authConnectionId,
                    groupedAuthConnectionId,
                    userId,
                })
                    .catch((error) => {
                    log('Error fetching auth pub key', error);
                    throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.FailedToFetchAuthPubKey);
                });
                globalAuthPubKey = authPubKey;
            }
            // use noble lib to deserialize and compare curve point
            const isExpiredPwd = !secp256k1_1.secp256k1.ProjectivePoint.fromHex(currentDeviceAuthPubKey).equals(secp256k1_1.secp256k1.ProjectivePoint.fromHex(globalAuthPubKey));
            // Cache the result in state
            this.update((state) => {
                state.passwordOutdatedCache = { isExpiredPwd, timestamp: Date.now() };
            });
            return isExpiredPwd;
        };
        return await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_executeWithTokenRefresh).call(this, async () => options?.skipLock
            ? await doCheckIsPasswordExpired()
            : await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_withControllerLock).call(this, doCheckIsPasswordExpired), 'checkIsPasswordOutdated');
    }
    /**
     * Clears the current state of the SeedlessOnboardingController.
     */
    clearState() {
        const defaultState = getInitialSeedlessOnboardingControllerStateWithDefaults();
        this.update(() => {
            return defaultState;
        });
    }
    /**
     * Store the keyring encryption key in state, encrypted under the current
     * encryption key.
     *
     * @param keyringEncryptionKey - The keyring encryption key.
     */
    async storeKeyringEncryptionKey(keyringEncryptionKey) {
        const { toprfPwEncryptionKey: encKey } = await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_unlockVaultAndGetVaultData).call(this);
        await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_storeKeyringEncryptionKey).call(this, encKey, keyringEncryptionKey);
    }
    /**
     * Load the keyring encryption key from state, decrypted under the current
     * encryption key.
     *
     * @returns The keyring encryption key.
     */
    async loadKeyringEncryptionKey() {
        const { toprfPwEncryptionKey: encKey } = await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_unlockVaultAndGetVaultData).call(this);
        return await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_loadKeyringEncryptionKey).call(this, encKey);
    }
    /**
     * Refresh expired nodeAuthTokens, accessToken, and metadataAccessToken using the stored refresh token.
     *
     * This method retrieves the refresh token from the vault and uses it to obtain
     * new nodeAuthTokens when the current ones have expired.
     *
     * @returns A promise that resolves to the new nodeAuthTokens.
     */
    async refreshAuthTokens() {
        __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_assertIsAuthenticatedUser).call(this, this.state);
        const { refreshToken } = this.state;
        try {
            const res = await __classPrivateFieldGet(this, _SeedlessOnboardingController_refreshJWTToken, "f").call(this, {
                connection: this.state.authConnection,
                refreshToken,
            });
            const { idTokens, accessToken, metadataAccessToken } = res;
            // re-authenticate with the new id tokens to set new node auth tokens
            await this.authenticate({
                idTokens,
                accessToken,
                metadataAccessToken,
                authConnection: this.state.authConnection,
                authConnectionId: this.state.authConnectionId,
                groupedAuthConnectionId: this.state.groupedAuthConnectionId,
                userId: this.state.userId,
                skipLock: true,
            });
        }
        catch (error) {
            log('Error refreshing node auth tokens', error);
            throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.AuthenticationError);
        }
    }
    /**
     * Renew the refresh token - get new refresh token and new revoke token
     * and also updates the vault with the new revoke token.
     * This method is to be called after user is authenticated.
     *
     * @param password - The password to encrypt the vault.
     * @returns A Promise that resolves to void.
     */
    async renewRefreshToken(password) {
        return await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_withControllerLock).call(this, async () => {
            __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_assertIsAuthenticatedUser).call(this, this.state);
            const { refreshToken, vaultEncryptionKey } = this.state;
            const { toprfEncryptionKey: rawToprfEncryptionKey, toprfPwEncryptionKey: rawToprfPwEncryptionKey, toprfAuthKeyPair: rawToprfAuthKeyPair, revokeToken, } = await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_unlockVaultAndGetVaultData).call(this, {
                password,
                encryptionKey: vaultEncryptionKey,
            });
            if (!revokeToken) {
                throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.InvalidRevokeToken);
            }
            const { newRevokeToken, newRefreshToken } = await __classPrivateFieldGet(this, _SeedlessOnboardingController_renewRefreshToken, "f").call(this, {
                connection: this.state.authConnection,
                revokeToken,
            });
            if (newRevokeToken && newRefreshToken) {
                this.update((state) => {
                    // set new revoke token in state temporarily for persisting in vault
                    state.revokeToken = newRevokeToken;
                    // set new refresh token to persist in state
                    state.refreshToken = newRefreshToken;
                });
                // add the old refresh token to the list to be revoked later when possible
                __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_addRefreshTokenToRevokeList).call(this, {
                    refreshToken,
                    revokeToken,
                });
                await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_createNewVaultWithAuthData).call(this, {
                    password,
                    rawToprfEncryptionKey,
                    rawToprfPwEncryptionKey,
                    rawToprfAuthKeyPair,
                });
            }
        });
    }
    /**
     * Revoke all pending refresh tokens.
     *
     * This method is to be called after user is authenticated.
     *
     * @returns A Promise that resolves to void.
     */
    async revokePendingRefreshTokens() {
        return await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_withControllerLock).call(this, async () => {
            __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_assertIsAuthenticatedUser).call(this, this.state);
            const { pendingToBeRevokedTokens } = this.state;
            if (!pendingToBeRevokedTokens || pendingToBeRevokedTokens.length === 0) {
                return;
            }
            // revoke all pending refresh tokens in parallel
            const promises = pendingToBeRevokedTokens.map(({ revokeToken }) => {
                const revokePromise = async () => {
                    try {
                        await __classPrivateFieldGet(this, _SeedlessOnboardingController_revokeRefreshToken, "f").call(this, {
                            connection: this.state.authConnection,
                            revokeToken,
                        });
                        return revokeToken;
                    }
                    catch (error) {
                        log('Error revoking refresh token', error);
                        return null;
                    }
                };
                return revokePromise();
            });
            const result = await Promise.all(promises); // no need to do Promise.allSettled because the promise already handle try catch
            // filter out the null values
            const revokedTokens = result.filter((token) => token !== null);
            if (revokedTokens.length > 0) {
                // update the state to remove the revoked tokens once all concurrent token revoke finish
                this.update((state) => {
                    state.pendingToBeRevokedTokens =
                        state.pendingToBeRevokedTokens?.filter((token) => !revokedTokens.includes(token.revokeToken));
                });
            }
        });
    }
    /**
     * Check if the current node auth token is expired.
     *
     * @returns True if the current node auth token is expired, false otherwise.
     */
    checkNodeAuthTokenExpired() {
        __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_assertIsAuthenticatedUser).call(this, this.state);
        const { nodeAuthTokens } = this.state;
        // all auth tokens should be expired at the same time so we can check the first one
        const firstAuthToken = nodeAuthTokens[0]?.authToken;
        // node auth token is base64 encoded json object
        const decodedToken = (0, utils_3.decodeNodeAuthToken)(firstAuthToken);
        // check if the token is expired
        return decodedToken.exp < Date.now() / 1000;
    }
    /**
     * Check if the current metadata access token is expired.
     *
     * @returns True if the metadata access token is expired, false otherwise.
     */
    checkMetadataAccessTokenExpired() {
        try {
            __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_assertIsAuthenticatedUser).call(this, this.state);
            const { metadataAccessToken } = this.state;
            // assertIsAuthenticatedUser will throw if metadataAccessToken is missing
            const decodedToken = (0, utils_3.decodeJWTToken)(metadataAccessToken);
            return decodedToken.exp < Math.floor(Date.now() / 1000);
        }
        catch {
            return true; // Consider unauthenticated user as having expired tokens
        }
    }
    /**
     * Check if the current access token is expired.
     * When the vault is locked, the access token is not accessible, so we return false.
     *
     * @returns True if the access token is expired, false otherwise.
     */
    checkAccessTokenExpired() {
        try {
            __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_assertIsAuthenticatedUser).call(this, this.state);
            const { accessToken } = this.state;
            if (!accessToken) {
                return true; // Consider missing token as expired
            }
            const decodedToken = (0, utils_3.decodeJWTToken)(accessToken);
            return decodedToken.exp < Math.floor(Date.now() / 1000);
        }
        catch {
            return true; // Consider unauthenticated user as having expired tokens
        }
    }
}
exports.SeedlessOnboardingController = SeedlessOnboardingController;
_SeedlessOnboardingController_vaultEncryptor = new WeakMap(), _SeedlessOnboardingController_controllerOperationMutex = new WeakMap(), _SeedlessOnboardingController_vaultOperationMutex = new WeakMap(), _SeedlessOnboardingController_refreshJWTToken = new WeakMap(), _SeedlessOnboardingController_revokeRefreshToken = new WeakMap(), _SeedlessOnboardingController_renewRefreshToken = new WeakMap(), _SeedlessOnboardingController_passwordOutdatedCacheTTL = new WeakMap(), _SeedlessOnboardingController_isUnlocked = new WeakMap(), _SeedlessOnboardingController_cachedDecryptedVaultData = new WeakMap(), _SeedlessOnboardingController_instances = new WeakSet(), _SeedlessOnboardingController_submitGlobalPassword = 
/**
 * @description Submit the global password to the controller, verify the
 * password validity and unlock the controller.
 *
 * @param params - The parameters for submitting the global password.
 * @param params.maxKeyChainLength - The maximum chain length of the pwd encryption keys.
 * @param params.targetAuthPubKey - The target public key of the keyring
 * encryption key to recover.
 * @param params.globalPassword - The latest global password.
 * @returns A promise that resolves to the keyring encryption key
 * corresponding to the current authPubKey in state.
 */
async function _SeedlessOnboardingController_submitGlobalPassword({ targetAuthPubKey, globalPassword, maxKeyChainLength, }) {
    const { pwEncKey: curPwEncKey, authKeyPair: curAuthKeyPair } = await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_recoverEncKey).call(this, globalPassword);
    try {
        // Recover vault encryption key.
        const res = await this.toprfClient.recoverPwEncKey({
            targetAuthPubKey,
            curPwEncKey,
            curAuthKeyPair,
            maxPwChainLength: maxKeyChainLength,
        });
        const { pwEncKey } = res;
        const vaultKey = await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_loadSeedlessEncryptionKey).call(this, pwEncKey);
        // Unlock the controller
        await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_unlockVaultAndGetVaultData).call(this, {
            encryptionKey: vaultKey,
        });
        __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_setUnlocked).call(this);
    }
    catch (error) {
        if (__classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_isTokenExpiredError).call(this, error)) {
            throw error;
        }
        if (__classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_isMaxKeyChainLengthError).call(this, error)) {
            throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.MaxKeyChainLengthExceeded);
        }
        throw errors_1.PasswordSyncError.getInstance(error);
    }
}, _SeedlessOnboardingController_getAccessToken = 
/**
 * Get the access token from the state or the vault.
 * If the access token is not in the state, it will be retrieved from the vault by decrypting it with the password.
 *
 * If both the access token and the vault are not available, an error will be thrown.
 *
 * @param password - The optional password to unlock the vault. If not provided, the access token will be retrieved from the vault.
 * @returns The access token.
 */
async function _SeedlessOnboardingController_getAccessToken(password) {
    const { accessToken, vault } = this.state;
    if (accessToken) {
        // if the access token is in the state, return it
        return accessToken;
    }
    // otherwise, check the vault availability and decrypt the access token from the vault
    if (!vault) {
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.InvalidAccessToken);
    }
    const { vaultData } = await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_decryptAndParseVaultData).call(this, {
        password,
    });
    return vaultData.accessToken;
}, _SeedlessOnboardingController_setUnlocked = function _SeedlessOnboardingController_setUnlocked() {
    __classPrivateFieldSet(this, _SeedlessOnboardingController_isUnlocked, true, "f");
}, _SeedlessOnboardingController_persistOprfKey = 
/**
 * Persist the encryption key for the seedless onboarding flow.
 *
 * @param oprfKey - The OPRF key to be splited and persisted.
 * @param authPubKey - The authentication public key.
 * @returns A promise that resolves to the success of the operation.
 */
async function _SeedlessOnboardingController_persistOprfKey(oprfKey, authPubKey) {
    __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_assertIsAuthenticatedUser).call(this, this.state);
    const { authConnectionId, groupedAuthConnectionId, userId } = this.state;
    try {
        await this.toprfClient.persistLocalKey({
            nodeAuthTokens: this.state.nodeAuthTokens,
            authConnectionId,
            groupedAuthConnectionId,
            userId,
            oprfKey,
            authPubKey,
        });
    }
    catch (error) {
        if (__classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_isTokenExpiredError).call(this, error)) {
            throw error;
        }
        log('Error persisting local encryption key', error);
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.FailedToPersistOprfKey);
    }
}, _SeedlessOnboardingController_persistAuthPubKey = function _SeedlessOnboardingController_persistAuthPubKey(params) {
    this.update((state) => {
        state.authPubKey = (0, utils_1.bytesToBase64)(params.authPubKey);
    });
}, _SeedlessOnboardingController_storeKeyringEncryptionKey = 
/**
 * Encrypt the keyring encryption key and store it in state.
 *
 * @param encKey - The encryption key.
 * @param keyringEncryptionKey - The keyring encryption key.
 */
async function _SeedlessOnboardingController_storeKeyringEncryptionKey(encKey, keyringEncryptionKey) {
    const aes = (0, webcrypto_1.managedNonce)(aes_1.gcm)(encKey);
    const encryptedKeyringEncryptionKey = aes.encrypt((0, utils_2.utf8ToBytes)(keyringEncryptionKey));
    this.update((state) => {
        state.encryptedKeyringEncryptionKey = (0, utils_1.bytesToBase64)(encryptedKeyringEncryptionKey);
    });
}, _SeedlessOnboardingController_loadKeyringEncryptionKey = 
/**
 * Decrypt the keyring encryption key from state.
 *
 * @param encKey - The encryption key.
 * @returns The keyring encryption key.
 */
async function _SeedlessOnboardingController_loadKeyringEncryptionKey(encKey) {
    const { encryptedKeyringEncryptionKey: encryptedKey } = this.state;
    assertIsEncryptedKeyringEncryptionKeySet(encryptedKey);
    const encryptedPasswordBytes = (0, utils_1.base64ToBytes)(encryptedKey);
    const aes = (0, webcrypto_1.managedNonce)(aes_1.gcm)(encKey);
    const password = aes.decrypt(encryptedPasswordBytes);
    return (0, utils_2.bytesToUtf8)(password);
}, _SeedlessOnboardingController_loadSeedlessEncryptionKey = 
/**
 * Decrypt the seedless encryption key from state.
 *
 * @param encKey - The encryption key.
 * @returns The seedless encryption key.
 */
async function _SeedlessOnboardingController_loadSeedlessEncryptionKey(encKey) {
    const { encryptedSeedlessEncryptionKey: encryptedKey } = this.state;
    assertIsEncryptedSeedlessEncryptionKeySet(encryptedKey);
    const encryptedKeyBytes = (0, utils_1.base64ToBytes)(encryptedKey);
    const aes = (0, webcrypto_1.managedNonce)(aes_1.gcm)(encKey);
    const seedlessEncryptionKey = aes.decrypt(encryptedKeyBytes);
    return (0, utils_2.bytesToUtf8)(seedlessEncryptionKey);
}, _SeedlessOnboardingController_recoverAuthPubKey = function _SeedlessOnboardingController_recoverAuthPubKey() {
    __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_assertIsSRPBackedUpUser).call(this, this.state);
    const { authPubKey } = this.state;
    return (0, utils_1.base64ToBytes)(authPubKey);
}, _SeedlessOnboardingController_recoverEncKey = 
/**
 * Recover the encryption key from password.
 *
 * @param password - The password used to derive/recover the encryption key.
 * @returns A promise that resolves to the encryption key and authentication key pair.
 * @throws RecoveryError - If failed to recover the encryption key.
 */
async function _SeedlessOnboardingController_recoverEncKey(password) {
    __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_assertIsAuthenticatedUser).call(this, this.state);
    const { authConnectionId, groupedAuthConnectionId, userId } = this.state;
    try {
        const recoverEncKeyResult = await this.toprfClient.recoverEncKey({
            nodeAuthTokens: this.state.nodeAuthTokens,
            password,
            authConnectionId,
            groupedAuthConnectionId,
            userId,
        });
        return recoverEncKeyResult;
    }
    catch (error) {
        // throw token expired error for token refresh handler
        if (__classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_isTokenExpiredError).call(this, error)) {
            throw error;
        }
        throw errors_1.RecoveryError.getInstance(error);
    }
}, _SeedlessOnboardingController_fetchAllSecretDataFromMetadataStore = async function _SeedlessOnboardingController_fetchAllSecretDataFromMetadataStore(encKey, authKeyPair) {
    let secretData = [];
    try {
        // fetch and decrypt the secret data from the metadata store
        secretData = await this.toprfClient.fetchAllSecretDataItems({
            decKey: encKey,
            authKeyPair,
        });
    }
    catch (error) {
        log('Error fetching secret data', error);
        if (__classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_isTokenExpiredError).call(this, error)) {
            throw error;
        }
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.FailedToFetchSecretMetadata);
    }
    // user must have at least one secret data
    if (secretData?.length > 0) {
        const secrets = SecretMetadata_1.SecretMetadata.parseSecretsFromMetadataStore(secretData);
        // validate the primary secret data is a mnemonic (SRP)
        const primarySecret = secrets[0];
        if (primarySecret.type !== constants_1.SecretType.Mnemonic) {
            throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.InvalidPrimarySecretDataType);
        }
        return secrets;
    }
    throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.NoSecretDataFound);
}, _SeedlessOnboardingController_changeEncryptionKey = 
/**
 * Update the encryption key with new password and update the Metadata Store with new encryption key.
 *
 * @param params - The function parameters.
 * @param params.oldPassword - The old password to verify.
 * @param params.newPassword - The new password to update.
 * @param params.latestKeyIndex - The key index of the latest key.
 * @returns A promise that resolves to new encryption key and authentication key pair.
 */
async function _SeedlessOnboardingController_changeEncryptionKey({ oldPassword, newPassword, latestKeyIndex, }) {
    __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_assertIsAuthenticatedUser).call(this, this.state);
    const { authConnectionId, groupedAuthConnectionId, userId } = this.state;
    let encKey;
    let pwEncKey;
    let authKeyPair;
    let globalKeyIndex = latestKeyIndex;
    if (!globalKeyIndex) {
        ({
            encKey,
            pwEncKey,
            authKeyPair,
            keyShareIndex: globalKeyIndex,
        } = await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_recoverEncKey).call(this, oldPassword));
    }
    else {
        ({
            toprfEncryptionKey: encKey,
            toprfPwEncryptionKey: pwEncKey,
            toprfAuthKeyPair: authKeyPair,
        } = await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_unlockVaultAndGetVaultData).call(this, { password: oldPassword }));
    }
    const result = await this.toprfClient.changeEncKey({
        nodeAuthTokens: this.state.nodeAuthTokens,
        authConnectionId,
        groupedAuthConnectionId,
        userId,
        oldEncKey: encKey,
        oldPwEncKey: pwEncKey,
        oldAuthKeyPair: authKeyPair,
        newKeyShareIndex: globalKeyIndex,
        newPassword,
    });
    return result;
}, _SeedlessOnboardingController_encryptAndStoreSecretData = 
/**
 * Encrypt and store the secret data backup in the metadata store.
 *
 * @param params - The parameters for encrypting and storing the secret data backup.
 * @param params.data - The secret data to store.
 * @param params.type - The type of the secret data.
 * @param params.encKey - The encryption key to store.
 * @param params.authKeyPair - The authentication key pair to store.
 * @param params.options - Optional options object, which includes optional data to be added to the metadata store.
 * @param params.options.keyringId - The keyring id of the backup keyring (SRP).
 *
 * @returns A promise that resolves to the success of the operation.
 */
async function _SeedlessOnboardingController_encryptAndStoreSecretData(params) {
    const { options, data, encKey, authKeyPair, type } = params;
    // before encrypting and create backup, we will check the state if the secret data is already backed up
    const backupState = this.getSecretDataBackupState(data, type);
    if (backupState) {
        return;
    }
    const secretMetadata = new SecretMetadata_1.SecretMetadata(data, {
        type,
    });
    const secretData = secretMetadata.toBytes();
    const keyringId = options?.keyringId;
    if (type === constants_1.SecretType.Mnemonic && !keyringId) {
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.MissingKeyringId);
    }
    try {
        await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_withPersistedSecretMetadataBackupsState).call(this, async () => {
            await this.toprfClient.addSecretDataItem({
                encKey,
                secretData,
                authKeyPair,
            });
            return {
                keyringId,
                data,
                type,
            };
        });
    }
    catch (error) {
        if (__classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_isTokenExpiredError).call(this, error)) {
            throw error;
        }
        log('Error encrypting and storing secret data backup', error);
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.FailedToEncryptAndStoreSecretData);
    }
}, _SeedlessOnboardingController_unlockVaultAndGetVaultData = 
/**
 * Unlocks the encrypted vault using the provided password and returns the decrypted vault data.
 * This method ensures thread-safety by using a mutex lock when accessing the vault.
 *
 * @param params - The parameters for unlocking the vault.
 * @param params.password - The optional password to unlock the vault.
 * @param params.encryptionKey - The optional encryption key to unlock the vault.
 * @returns A promise that resolves to an object containing:
 * - toprfEncryptionKey: The decrypted TOPRF encryption key
 * - toprfAuthKeyPair: The decrypted TOPRF authentication key pair
 * - revokeToken: The decrypted revoke token
 * - accessToken: The decrypted access token
 * @throws {Error} If:
 * - The password is invalid or empty
 * - The vault is not initialized
 * - The password is incorrect (from encryptor.decrypt)
 * - The decrypted vault data is malformed
 */
async function _SeedlessOnboardingController_unlockVaultAndGetVaultData(params) {
    return __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_withVaultLock).call(this, async () => {
        if (__classPrivateFieldGet(this, _SeedlessOnboardingController_cachedDecryptedVaultData, "f")) {
            return __classPrivateFieldGet(this, _SeedlessOnboardingController_cachedDecryptedVaultData, "f");
        }
        const { vaultData, vaultEncryptionKey, vaultEncryptionSalt } = await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_decryptAndParseVaultData).call(this, params);
        this.update((state) => {
            state.vaultEncryptionKey = vaultEncryptionKey;
            state.vaultEncryptionSalt = vaultEncryptionSalt;
            state.revokeToken = vaultData.revokeToken;
            state.accessToken = vaultData.accessToken;
        });
        const deserializedVaultData = (0, utils_3.deserializeVaultData)(vaultData);
        __classPrivateFieldSet(this, _SeedlessOnboardingController_cachedDecryptedVaultData, deserializedVaultData, "f");
        return deserializedVaultData;
    });
}, _SeedlessOnboardingController_decryptAndParseVaultData = 
/**
 * Decrypts the vault data and parses it into a usable format.
 *
 * @param params - The parameters for decrypting the vault.
 * @param params.password - The optional password to decrypt the vault.
 * @param params.encryptionKey - The optional encryption key to decrypt the vault.
 * @returns A promise that resolves to an object containing:
 */
async function _SeedlessOnboardingController_decryptAndParseVaultData(params) {
    let { vaultEncryptionKey, vaultEncryptionSalt } = this.state;
    const { vault: encryptedVault } = this.state;
    if (!encryptedVault) {
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.VaultError);
    }
    if (params?.encryptionKey) {
        vaultEncryptionKey = params.encryptionKey;
    }
    let decryptedVaultData;
    // if the encryption key is available, we will use it to decrypt the vault
    if (vaultEncryptionKey) {
        const parsedEncryptedVault = JSON.parse(encryptedVault);
        if (vaultEncryptionSalt &&
            vaultEncryptionSalt !== parsedEncryptedVault.salt) {
            throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.ExpiredCredentials);
        }
        const key = await __classPrivateFieldGet(this, _SeedlessOnboardingController_vaultEncryptor, "f").importKey(vaultEncryptionKey);
        decryptedVaultData = await __classPrivateFieldGet(this, _SeedlessOnboardingController_vaultEncryptor, "f").decryptWithKey(key, parsedEncryptedVault);
    }
    else {
        // if the encryption key is not available, we will use the password to decrypt the vault
        assertIsValidPassword(params?.password);
        // Note that vault decryption using the password is a very costly operation as it involves deriving the encryption key
        // from the password using an intentionally slow key derivation function.
        // We should make sure that we only call it very intentionally.
        const result = await __classPrivateFieldGet(this, _SeedlessOnboardingController_vaultEncryptor, "f").decryptWithDetail(params.password, encryptedVault);
        decryptedVaultData = result.vault;
        vaultEncryptionKey = result.exportedKeyString;
        vaultEncryptionSalt = result.salt;
    }
    const vaultData = __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_parseVaultData).call(this, decryptedVaultData);
    return {
        vaultData,
        vaultEncryptionKey,
        vaultEncryptionSalt,
    };
}, _SeedlessOnboardingController_withPersistedSecretMetadataBackupsState = 
/**
 * Executes a callback function that creates or restores secret data and persists their hashes in the controller state.
 *
 * This method:
 * 1. Executes the provided callback to create/restore secret data
 * 2. Generates keccak256 hashes of the secret data
 * 3. Merges new hashes with existing ones in the state, ensuring uniqueness
 * 4. Updates the controller state with the combined hashes
 *
 * This is a wrapper method that should be used around any operation that creates
 * or restores secret data to ensure their hashes are properly tracked.
 *
 * @param createSecretMetadataBackupCallback - function that returns either a single secret data
 * or an array of secret data as Uint8Array(s)
 * @returns The original secret data(s) returned by the callback
 * @throws Rethrows any errors from the callback with additional logging
 */
async function _SeedlessOnboardingController_withPersistedSecretMetadataBackupsState(createSecretMetadataBackupCallback) {
    try {
        const newBackup = await createSecretMetadataBackupCallback();
        __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_filterDupesAndUpdateSocialBackupsMetadata).call(this, newBackup);
        return newBackup;
    }
    catch (error) {
        log('Error persisting secret data backups', error);
        throw error;
    }
}, _SeedlessOnboardingController_filterDupesAndUpdateSocialBackupsMetadata = function _SeedlessOnboardingController_filterDupesAndUpdateSocialBackupsMetadata(secretData) {
    const currentBackupsMetadata = this.state.socialBackupsMetadata;
    const newBackupsMetadata = Array.isArray(secretData)
        ? secretData
        : [secretData];
    const filteredNewBackupsMetadata = [];
    // filter out the backed up metadata that already exists in the state
    // to prevent duplicates
    newBackupsMetadata.forEach((item) => {
        const { keyringId, data, type } = item;
        const backupHash = (0, auth_network_utils_1.keccak256AndHexify)(data);
        const backupStateAlreadyExisted = currentBackupsMetadata.some((backup) => backup.hash === backupHash && backup.type === type);
        if (!backupStateAlreadyExisted) {
            filteredNewBackupsMetadata.push({
                keyringId,
                hash: backupHash,
                type,
            });
        }
    });
    if (filteredNewBackupsMetadata.length > 0) {
        this.update((state) => {
            state.socialBackupsMetadata = [
                ...state.socialBackupsMetadata,
                ...filteredNewBackupsMetadata,
            ];
        });
    }
}, _SeedlessOnboardingController_createNewVaultWithAuthData = 
/**
 * Create a new vault with the given authentication data.
 *
 * Serialize the authentication and key data which will be stored in the vault.
 *
 * @param params - The parameters for creating a new vault.
 * @param params.password - The password to encrypt the vault.
 * @param params.rawToprfEncryptionKey - The encryption key to encrypt the vault.
 * @param params.rawToprfPwEncryptionKey - The encryption key to encrypt the password.
 * @param params.rawToprfAuthKeyPair - The authentication key pair for Toprf operations.
 */
async function _SeedlessOnboardingController_createNewVaultWithAuthData({ password, rawToprfEncryptionKey, rawToprfPwEncryptionKey, rawToprfAuthKeyPair, }) {
    __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_assertIsAuthenticatedUser).call(this, this.state);
    const { revokeToken } = this.state;
    const accessToken = await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_getAccessToken).call(this, password);
    const vaultData = {
        toprfAuthKeyPair: rawToprfAuthKeyPair,
        toprfEncryptionKey: rawToprfEncryptionKey,
        toprfPwEncryptionKey: rawToprfPwEncryptionKey,
        revokeToken,
        accessToken,
    };
    await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_updateVault).call(this, {
        password,
        vaultData,
        pwEncKey: rawToprfPwEncryptionKey,
    });
    // update the authPubKey in the state
    __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_persistAuthPubKey).call(this, {
        authPubKey: rawToprfAuthKeyPair.pk,
    });
    __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_setUnlocked).call(this);
}, _SeedlessOnboardingController_updateVault = 
/**
 * Encrypt and update the vault with the given authentication data.
 *
 * @param params - The parameters for updating the vault.
 * @param params.password - The password to encrypt the vault.
 * @param params.vaultData - The raw vault data to update the vault with.
 * @param params.pwEncKey - The global password encryption key.
 * @returns A promise that resolves to the updated vault.
 */
async function _SeedlessOnboardingController_updateVault({ password, vaultData, pwEncKey, }) {
    await __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_withVaultLock).call(this, async () => {
        assertIsValidPassword(password);
        // cache the vault data to avoid decrypting the vault data multiple times
        __classPrivateFieldSet(this, _SeedlessOnboardingController_cachedDecryptedVaultData, vaultData, "f");
        const serializedVaultData = (0, utils_3.serializeVaultData)(vaultData);
        // Note that vault encryption using the password is a very costly operation as it involves deriving the encryption key
        // from the password using an intentionally slow key derivation function.
        // We should make sure that we only call it very intentionally.
        const { vault, exportedKeyString } = await __classPrivateFieldGet(this, _SeedlessOnboardingController_vaultEncryptor, "f").encryptWithDetail(password, serializedVaultData);
        // Encrypt vault key.
        const aes = (0, webcrypto_1.managedNonce)(aes_1.gcm)(pwEncKey);
        const encryptedKey = aes.encrypt((0, utils_2.utf8ToBytes)(exportedKeyString));
        this.update((state) => {
            state.vault = vault;
            state.vaultEncryptionKey = exportedKeyString;
            state.vaultEncryptionSalt = JSON.parse(vault).salt;
            state.encryptedSeedlessEncryptionKey = (0, utils_1.bytesToBase64)(encryptedKey);
        });
    });
}, _SeedlessOnboardingController_withControllerLock = 
/**
 * Lock the controller mutex before executing the given function,
 * and release it after the function is resolved or after an
 * error is thrown.
 *
 * This wrapper ensures that each mutable operation that interacts with the
 * controller and that changes its state is executed in a mutually exclusive way,
 * preventing unsafe concurrent access that could lead to unpredictable behavior.
 *
 * @param callback - The function to execute while the controller mutex is locked.
 * @returns The result of the function.
 */
async function _SeedlessOnboardingController_withControllerLock(callback) {
    return await withLock(__classPrivateFieldGet(this, _SeedlessOnboardingController_controllerOperationMutex, "f"), callback);
}, _SeedlessOnboardingController_withVaultLock = 
/**
 * Lock the vault mutex before executing the given function,
 * and release it after the function is resolved or after an
 * error is thrown.
 *
 * This ensures that each operation that interacts with the vault
 * is executed in a mutually exclusive way.
 *
 * @param callback - The function to execute while the vault mutex is locked.
 * @returns The result of the function.
 */
async function _SeedlessOnboardingController_withVaultLock(callback) {
    return await withLock(__classPrivateFieldGet(this, _SeedlessOnboardingController_vaultOperationMutex, "f"), callback);
}, _SeedlessOnboardingController_parseVaultData = function _SeedlessOnboardingController_parseVaultData(data) {
    if (typeof data !== 'string') {
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.VaultDataError);
    }
    let parsedVaultData;
    try {
        parsedVaultData = JSON.parse(data);
    }
    catch {
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.VaultDataError);
    }
    (0, assertions_1.assertIsValidVaultData)(parsedVaultData);
    return parsedVaultData;
}, _SeedlessOnboardingController_assertIsUnlocked = function _SeedlessOnboardingController_assertIsUnlocked() {
    if (!__classPrivateFieldGet(this, _SeedlessOnboardingController_isUnlocked, "f")) {
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.ControllerLocked);
    }
}, _SeedlessOnboardingController_assertIsAuthenticatedUser = function _SeedlessOnboardingController_assertIsAuthenticatedUser(value) {
    try {
        (0, assertions_1.assertIsSeedlessOnboardingUserAuthenticated)(value);
    }
    catch (error) {
        this.update((state) => {
            state.isSeedlessOnboardingUserAuthenticated = false;
        });
        throw error;
    }
}, _SeedlessOnboardingController_assertIsSRPBackedUpUser = function _SeedlessOnboardingController_assertIsSRPBackedUpUser(value) {
    if (!this.state.authPubKey) {
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.SRPNotBackedUpError);
    }
}, _SeedlessOnboardingController_assertPasswordInSync = 
/**
 * Assert that the password is in sync with the global password.
 *
 * @param options - The options for asserting the password is in sync.
 * @param options.skipCache - Whether to skip the cache check.
 * @param options.skipLock - Whether to skip the lock acquisition. (to prevent deadlock in case the caller already acquired the lock)
 * @returns The global auth public key and the latest key index.
 * @throws If the password is outdated.
 */
async function _SeedlessOnboardingController_assertPasswordInSync(options) {
    __classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_assertIsAuthenticatedUser).call(this, this.state);
    const { nodeAuthTokens, authConnectionId, groupedAuthConnectionId, userId, } = this.state;
    const { authPubKey, keyIndex: latestKeyIndex } = await this.toprfClient
        .fetchAuthPubKey({
        nodeAuthTokens,
        authConnectionId,
        groupedAuthConnectionId,
        userId,
    })
        .catch((error) => {
        log('Error fetching auth pub key', error);
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.FailedToFetchAuthPubKey);
    });
    const isPasswordOutdated = await this.checkIsPasswordOutdated({
        ...options,
        globalAuthPubKey: authPubKey,
    });
    if (isPasswordOutdated) {
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.OutdatedPassword);
    }
    return { authPubKey, latestKeyIndex };
}, _SeedlessOnboardingController_resetPasswordOutdatedCache = function _SeedlessOnboardingController_resetPasswordOutdatedCache() {
    this.update((state) => {
        delete state.passwordOutdatedCache;
    });
}, _SeedlessOnboardingController_addRefreshTokenToRevokeList = function _SeedlessOnboardingController_addRefreshTokenToRevokeList({ refreshToken, revokeToken, }) {
    this.update((state) => {
        state.pendingToBeRevokedTokens = [
            ...(state.pendingToBeRevokedTokens || []),
            { refreshToken, revokeToken },
        ];
    });
}, _SeedlessOnboardingController_isTokenExpiredError = function _SeedlessOnboardingController_isTokenExpiredError(error) {
    if (error instanceof toprf_secure_backup_1.TOPRFError) {
        // eslint-disable-next-line @typescript-eslint/no-unsafe-enum-comparison
        return error.code === toprf_secure_backup_1.TOPRFErrorCode.AuthTokenExpired;
    }
    return false;
}, _SeedlessOnboardingController_isMaxKeyChainLengthError = function _SeedlessOnboardingController_isMaxKeyChainLengthError(error) {
    if (error instanceof toprf_secure_backup_1.TOPRFError) {
        return (error.code ===
            toprf_secure_backup_1.TOPRFErrorCode.MaxKeyChainLengthExceeded);
    }
    return false;
}, _SeedlessOnboardingController_executeWithTokenRefresh = 
/**
 * Executes an operation with automatic token refresh on expiration.
 *
 * This wrapper method automatically handles token expiration by refreshing tokens
 * and retrying the operation. It can be used by any method that might encounter
 * token expiration errors.
 *
 * @param operation - The operation to execute that might require valid tokens.
 * @param operationName - A descriptive name for the operation (used in error messages).
 * @returns A promise that resolves to the result of the operation.
 * @throws The original error if it's not token-related, or refresh error if token refresh fails.
 */
async function _SeedlessOnboardingController_executeWithTokenRefresh(operation, operationName) {
    try {
        // proactively check for expired tokens and refresh them if needed
        const isNodeAuthTokenExpired = this.checkNodeAuthTokenExpired();
        const isMetadataAccessTokenExpired = this.checkMetadataAccessTokenExpired();
        // access token is only accessible when the vault is unlocked
        // so skip the check if the vault is locked
        let isAccessTokenExpired = false;
        if (__classPrivateFieldGet(this, _SeedlessOnboardingController_isUnlocked, "f")) {
            isAccessTokenExpired = this.checkAccessTokenExpired();
        }
        if (isNodeAuthTokenExpired ||
            isMetadataAccessTokenExpired ||
            isAccessTokenExpired) {
            log(`JWT token expired during ${operationName}, attempting to refresh tokens`, 'node auth token exp check');
            await this.refreshAuthTokens();
        }
        return await operation();
    }
    catch (error) {
        // Check if this is a token expiration error
        if (__classPrivateFieldGet(this, _SeedlessOnboardingController_instances, "m", _SeedlessOnboardingController_isTokenExpiredError).call(this, error)) {
            log(`Token expired during ${operationName}, attempting to refresh tokens`, error);
            try {
                // Refresh the tokens
                await this.refreshAuthTokens();
                // Retry the operation with fresh tokens
                return await operation();
            }
            catch (refreshError) {
                log(`Error refreshing tokens during ${operationName}`, refreshError);
                throw refreshError;
            }
        }
        else {
            // Re-throw non-token-related errors
            throw error;
        }
    }
};
/**
 * Assert that the provided password is a valid non-empty string.
 *
 * @param password - The password to check.
 * @throws If the password is not a valid string.
 */
function assertIsValidPassword(password) {
    if (typeof password !== 'string') {
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.WrongPasswordType);
    }
    if (!password || !password.length) {
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.InvalidEmptyPassword);
    }
}
/**
 * Lock the given mutex before executing the given function,
 * and release it after the function is resolved or after an
 * error is thrown.
 *
 * @param mutex - The mutex to lock.
 * @param callback - The function to execute while the mutex is locked.
 * @returns The result of the function.
 */
async function withLock(mutex, callback) {
    const releaseLock = await mutex.acquire();
    try {
        return await callback({ releaseLock });
    }
    finally {
        releaseLock();
    }
}
/**
 * Assert that the provided encrypted keyring encryption key is a valid non-empty string.
 *
 * @param encryptedKeyringEncryptionKey - The encrypted keyring encryption key to check.
 * @throws If the encrypted keyring encryption key is not a valid string.
 */
function assertIsEncryptedKeyringEncryptionKeySet(encryptedKeyringEncryptionKey) {
    if (!encryptedKeyringEncryptionKey) {
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.EncryptedKeyringEncryptionKeyNotSet);
    }
}
/**
 * Assert that the provided encrypted seedless encryption key is a valid non-empty string.
 *
 * @param encryptedSeedlessEncryptionKey - The encrypted seedless encryption key to check.
 * @throws If the encrypted seedless encryption key is not a valid string.
 */
function assertIsEncryptedSeedlessEncryptionKeySet(encryptedSeedlessEncryptionKey) {
    if (!encryptedSeedlessEncryptionKey) {
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.EncryptedSeedlessEncryptionKeyNotSet);
    }
}

      };
    };
  }
  }
}, {package:"@metamask/seedless-onboarding-controller",file:"node_modules\\@metamask\\seedless-onboarding-controller\\dist\\SeedlessOnboardingController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\assertions.cjs", {"./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\constants.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cseedless-onboarding-controller%5Cdist%5Cassertions.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assertIsValidVaultData = exports.assertIsPasswordOutdatedCacheValid = exports.assertIsSeedlessOnboardingUserAuthenticated = void 0;
const constants_1 = require("./constants.cjs");
/**
 * Check if the provided value is a valid authenticated user.
 *
 * @param value - The value to check.
 * @throws If the value is not a valid authenticated user.
 */
function assertIsSeedlessOnboardingUserAuthenticated(value) {
    if (!value ||
        typeof value !== 'object' ||
        !('authConnectionId' in value) ||
        typeof value.authConnectionId !== 'string' ||
        !('userId' in value) ||
        typeof value.userId !== 'string') {
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.MissingAuthUserInfo);
    }
    if (!('nodeAuthTokens' in value) ||
        typeof value.nodeAuthTokens !== 'object' ||
        !Array.isArray(value.nodeAuthTokens) ||
        value.nodeAuthTokens.length < 3 // At least 3 auth tokens are required for Threshold OPRF service
    ) {
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.InsufficientAuthToken);
    }
    if (!('refreshToken' in value) || typeof value.refreshToken !== 'string') {
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.InvalidRefreshToken);
    }
    if (!('metadataAccessToken' in value) ||
        typeof value.metadataAccessToken !== 'string') {
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.InvalidMetadataAccessToken);
    }
}
exports.assertIsSeedlessOnboardingUserAuthenticated = assertIsSeedlessOnboardingUserAuthenticated;
/**
 * Check if the provided value is a valid password outdated cache.
 *
 * @param value - The value to check.
 * @throws If the value is not a valid password outdated cache.
 */
function assertIsPasswordOutdatedCacheValid(value) {
    if (typeof value !== 'number') {
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.InvalidPasswordOutdatedCache);
    }
    if (value < 0 || isNaN(value) || !isFinite(value)) {
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.InvalidPasswordOutdatedCache);
    }
}
exports.assertIsPasswordOutdatedCacheValid = assertIsPasswordOutdatedCacheValid;
/**
 * Check if the provided value is a valid vault data.
 *
 * @param value - The value to check.
 * @throws If the value is not a valid vault data.
 */
function assertIsValidVaultData(value) {
    // value is not valid vault data if any of the following conditions are true:
    if (!value || // value is not defined
        typeof value !== 'object' || // value is not an object
        !('toprfEncryptionKey' in value) || // toprfEncryptionKey is not defined
        typeof value.toprfEncryptionKey !== 'string' || // toprfEncryptionKey is not a string
        !('toprfPwEncryptionKey' in value) || // toprfPwEncryptionKey is not defined
        typeof value.toprfPwEncryptionKey !== 'string' || // toprfPwEncryptionKey is not a string
        !('toprfAuthKeyPair' in value) || // toprfAuthKeyPair is not defined
        typeof value.toprfAuthKeyPair !== 'string' || // toprfAuthKeyPair is not a string
        // revoke token exists but is not a string and is not undefined
        ('revokeToken' in value &&
            typeof value.revokeToken !== 'string' &&
            value.revokeToken !== undefined) ||
        !('accessToken' in value) || // accessToken is not defined
        typeof value.accessToken !== 'string' // accessToken is not a string
    ) {
        throw new Error(constants_1.SeedlessOnboardingControllerErrorMessage.InvalidVaultData);
    }
}
exports.assertIsValidVaultData = assertIsValidVaultData;

      };
    };
  }
  }
}, {package:"@metamask/seedless-onboarding-controller",file:"node_modules\\@metamask\\seedless-onboarding-controller\\dist\\assertions.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\constants.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cseedless-onboarding-controller%5Cdist%5Cconstants.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SeedlessOnboardingControllerErrorMessage = exports.SecretMetadataVersion = exports.SecretType = exports.AuthConnection = exports.Web3AuthNetwork = exports.PASSWORD_OUTDATED_CACHE_TTL_MS = exports.controllerName = void 0;
exports.controllerName = 'SeedlessOnboardingController';
exports.PASSWORD_OUTDATED_CACHE_TTL_MS = 10000; // 10 seconds
var Web3AuthNetwork;
(function (Web3AuthNetwork) {
    Web3AuthNetwork["Mainnet"] = "sapphire_mainnet";
    Web3AuthNetwork["Devnet"] = "sapphire_devnet";
})(Web3AuthNetwork || (exports.Web3AuthNetwork = Web3AuthNetwork = {}));
/**
 * The type of social login provider.
 */
var AuthConnection;
(function (AuthConnection) {
    AuthConnection["Google"] = "google";
    AuthConnection["Apple"] = "apple";
})(AuthConnection || (exports.AuthConnection = AuthConnection = {}));
var SecretType;
(function (SecretType) {
    SecretType["Mnemonic"] = "mnemonic";
    SecretType["PrivateKey"] = "privateKey";
})(SecretType || (exports.SecretType = SecretType = {}));
var SecretMetadataVersion;
(function (SecretMetadataVersion) {
    SecretMetadataVersion["V1"] = "v1";
})(SecretMetadataVersion || (exports.SecretMetadataVersion = SecretMetadataVersion = {}));
var SeedlessOnboardingControllerErrorMessage;
(function (SeedlessOnboardingControllerErrorMessage) {
    SeedlessOnboardingControllerErrorMessage["ControllerLocked"] = "SeedlessOnboardingController - The operation cannot be completed while the controller is locked.";
    SeedlessOnboardingControllerErrorMessage["AuthenticationError"] = "SeedlessOnboardingController - Authentication error";
    SeedlessOnboardingControllerErrorMessage["MissingAuthUserInfo"] = "SeedlessOnboardingController - Missing authenticated user information";
    SeedlessOnboardingControllerErrorMessage["FailedToPersistOprfKey"] = "SeedlessOnboardingController - Failed to persist OPRF key";
    SeedlessOnboardingControllerErrorMessage["LoginFailedError"] = "SeedlessOnboardingController - Login failed";
    SeedlessOnboardingControllerErrorMessage["InsufficientAuthToken"] = "SeedlessOnboardingController - Insufficient auth token";
    SeedlessOnboardingControllerErrorMessage["InvalidRefreshToken"] = "SeedlessOnboardingController - Invalid refresh token";
    SeedlessOnboardingControllerErrorMessage["InvalidRevokeToken"] = "SeedlessOnboardingController - Invalid revoke token";
    SeedlessOnboardingControllerErrorMessage["InvalidAccessToken"] = "SeedlessOnboardingController - Invalid access token";
    SeedlessOnboardingControllerErrorMessage["InvalidMetadataAccessToken"] = "SeedlessOnboardingController - Invalid metadata access token";
    SeedlessOnboardingControllerErrorMessage["MissingCredentials"] = "SeedlessOnboardingController - Cannot unlock vault without password and encryption key";
    SeedlessOnboardingControllerErrorMessage["ExpiredCredentials"] = "SeedlessOnboardingController - Encryption key and salt provided are expired";
    SeedlessOnboardingControllerErrorMessage["InvalidEmptyPassword"] = "SeedlessOnboardingController - Password cannot be empty.";
    SeedlessOnboardingControllerErrorMessage["WrongPasswordType"] = "SeedlessOnboardingController - Password must be of type string.";
    SeedlessOnboardingControllerErrorMessage["InvalidVaultData"] = "SeedlessOnboardingController - Invalid vault data";
    SeedlessOnboardingControllerErrorMessage["VaultDataError"] = "SeedlessOnboardingController - The decrypted vault has an unexpected shape.";
    SeedlessOnboardingControllerErrorMessage["VaultError"] = "SeedlessOnboardingController - Cannot unlock without a previous vault.";
    SeedlessOnboardingControllerErrorMessage["InvalidSecretMetadata"] = "SeedlessOnboardingController - Invalid secret metadata";
    SeedlessOnboardingControllerErrorMessage["MissingKeyringId"] = "SeedlessOnboardingController - Keyring ID is required to store SRP backups.";
    SeedlessOnboardingControllerErrorMessage["FailedToEncryptAndStoreSecretData"] = "SeedlessOnboardingController - Failed to encrypt and store secret data";
    SeedlessOnboardingControllerErrorMessage["FailedToFetchSecretMetadata"] = "SeedlessOnboardingController - Failed to fetch secret metadata";
    SeedlessOnboardingControllerErrorMessage["NoSecretDataFound"] = "SeedlessOnboardingController - No secret data found";
    SeedlessOnboardingControllerErrorMessage["InvalidPrimarySecretDataType"] = "SeedlessOnboardingController - Primary secret data must be of type mnemonic.";
    SeedlessOnboardingControllerErrorMessage["FailedToChangePassword"] = "SeedlessOnboardingController - Failed to change password";
    SeedlessOnboardingControllerErrorMessage["TooManyLoginAttempts"] = "SeedlessOnboardingController - Too many login attempts";
    SeedlessOnboardingControllerErrorMessage["IncorrectPassword"] = "SeedlessOnboardingController - Incorrect password";
    SeedlessOnboardingControllerErrorMessage["OutdatedPassword"] = "SeedlessOnboardingController - Outdated password";
    SeedlessOnboardingControllerErrorMessage["CouldNotRecoverPassword"] = "SeedlessOnboardingController - Could not recover password";
    SeedlessOnboardingControllerErrorMessage["SRPNotBackedUpError"] = "SeedlessOnboardingController - SRP not backed up";
    SeedlessOnboardingControllerErrorMessage["EncryptedKeyringEncryptionKeyNotSet"] = "SeedlessOnboardingController - Encrypted keyring encryption key is not set";
    SeedlessOnboardingControllerErrorMessage["EncryptedSeedlessEncryptionKeyNotSet"] = "SeedlessOnboardingController - Encrypted seedless encryption key is not set";
    SeedlessOnboardingControllerErrorMessage["MaxKeyChainLengthExceeded"] = "SeedlessOnboardingController - Max key chain length exceeded";
    SeedlessOnboardingControllerErrorMessage["FailedToFetchAuthPubKey"] = "SeedlessOnboardingController - Failed to fetch latest auth pub key";
    SeedlessOnboardingControllerErrorMessage["InvalidPasswordOutdatedCache"] = "SeedlessOnboardingController - Invalid password outdated cache provided.";
})(SeedlessOnboardingControllerErrorMessage || (exports.SeedlessOnboardingControllerErrorMessage = SeedlessOnboardingControllerErrorMessage = {}));

      };
    };
  }
  }
}, {package:"@metamask/seedless-onboarding-controller",file:"node_modules\\@metamask\\seedless-onboarding-controller\\dist\\constants.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\errors.cjs", {"./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\constants.cjs","@metamask/toprf-secure-backup":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\toprf-secure-backup\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cseedless-onboarding-controller%5Cdist%5Cerrors.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RecoveryError = exports.PasswordSyncError = exports.getErrorMessageFromTOPRFErrorCode = void 0;
const toprf_secure_backup_1 = require("@metamask/toprf-secure-backup");
const constants_1 = require("./constants.cjs");
/**
 * Get the error message from the TOPRF error code.
 *
 * @param errorCode - The TOPRF error code.
 * @param defaultMessage - The default error message if the error code is not found.
 * @returns The error message.
 */
function getErrorMessageFromTOPRFErrorCode(errorCode, defaultMessage) {
    switch (errorCode) {
        case toprf_secure_backup_1.TOPRFErrorCode.RateLimitExceeded:
            return constants_1.SeedlessOnboardingControllerErrorMessage.TooManyLoginAttempts;
        case toprf_secure_backup_1.TOPRFErrorCode.CouldNotDeriveEncryptionKey:
            return constants_1.SeedlessOnboardingControllerErrorMessage.IncorrectPassword;
        case toprf_secure_backup_1.TOPRFErrorCode.CouldNotFetchPassword:
            return constants_1.SeedlessOnboardingControllerErrorMessage.CouldNotRecoverPassword;
        case toprf_secure_backup_1.TOPRFErrorCode.AuthTokenExpired:
            return constants_1.SeedlessOnboardingControllerErrorMessage.InsufficientAuthToken;
        default:
            return defaultMessage;
    }
}
exports.getErrorMessageFromTOPRFErrorCode = getErrorMessageFromTOPRFErrorCode;
/**
 * Check if the provided error is a rate limit error triggered by too many login attempts.
 *
 * Return a new TooManyLoginAttemptsError if the error is a rate limit error, otherwise undefined.
 *
 * @param error - The error to check.
 * @returns The rate limit error if the error is a rate limit error, otherwise undefined.
 */
function getRateLimitErrorData(error) {
    if (error.meta && // error metadata must be present
        error.code === toprf_secure_backup_1.TOPRFErrorCode.RateLimitExceeded &&
        typeof error.meta.rateLimitDetails === 'object' &&
        error.meta.rateLimitDetails !== null &&
        'remainingTime' in error.meta.rateLimitDetails &&
        typeof error.meta.rateLimitDetails.remainingTime === 'number' &&
        'message' in error.meta.rateLimitDetails &&
        typeof error.meta.rateLimitDetails.message === 'string' &&
        'lockTime' in error.meta.rateLimitDetails &&
        typeof error.meta.rateLimitDetails.lockTime === 'number' &&
        'guessCount' in error.meta.rateLimitDetails &&
        typeof error.meta.rateLimitDetails.guessCount === 'number') {
        return {
            remainingTime: error.meta.rateLimitDetails.remainingTime,
            message: error.meta.rateLimitDetails.message,
            lockTime: error.meta.rateLimitDetails.lockTime,
            guessCount: error.meta.rateLimitDetails.guessCount,
        };
    }
    return undefined;
}
/**
 * The PasswordSyncError class is used to handle errors that occur during the password sync process.
 */
class PasswordSyncError extends Error {
    constructor(message) {
        super(message);
        this.name = 'SeedlessOnboardingController - PasswordSyncError';
    }
    /**
     * Get an instance of the PasswordSyncError class.
     *
     * @param error - The error to get the instance of.
     * @returns The instance of the PasswordSyncError class.
     */
    static getInstance(error) {
        if (error instanceof toprf_secure_backup_1.TOPRFError) {
            const errorMessage = getErrorMessageFromTOPRFErrorCode(error.code, constants_1.SeedlessOnboardingControllerErrorMessage.CouldNotRecoverPassword);
            return new PasswordSyncError(errorMessage);
        }
        return new PasswordSyncError(constants_1.SeedlessOnboardingControllerErrorMessage.CouldNotRecoverPassword);
    }
}
exports.PasswordSyncError = PasswordSyncError;
/**
 * The RecoveryError class is used to handle errors that occur during the recover encryption key process from the passwrord.
 * It extends the Error class and includes a data property that can be used to store additional information.
 */
class RecoveryError extends Error {
    constructor(message, data) {
        super(message);
        this.data = data;
        this.name = 'SeedlessOnboardingController - RecoveryError';
    }
    /**
     * Get an instance of the RecoveryError class.
     *
     * @param error - The error to get the instance of.
     * @returns The instance of the RecoveryError class.
     */
    static getInstance(error) {
        if (!(error instanceof toprf_secure_backup_1.TOPRFError)) {
            return new RecoveryError(constants_1.SeedlessOnboardingControllerErrorMessage.LoginFailedError);
        }
        const rateLimitErrorData = getRateLimitErrorData(error);
        const recoveryErrorData = rateLimitErrorData
            ? {
                numberOfAttempts: rateLimitErrorData.guessCount,
                remainingTime: rateLimitErrorData.remainingTime,
            }
            : undefined;
        const errorMessage = getErrorMessageFromTOPRFErrorCode(error.code, constants_1.SeedlessOnboardingControllerErrorMessage.LoginFailedError);
        return new RecoveryError(errorMessage, recoveryErrorData);
    }
}
exports.RecoveryError = RecoveryError;

      };
    };
  }
  }
}, {package:"@metamask/seedless-onboarding-controller",file:"node_modules\\@metamask\\seedless-onboarding-controller\\dist\\errors.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\index.cjs", {"./SecretMetadata.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\SecretMetadata.cjs","./SeedlessOnboardingController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\SeedlessOnboardingController.cjs","./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\constants.cjs","./errors.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\errors.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cseedless-onboarding-controller%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RecoveryError = exports.SecretMetadata = exports.SecretType = exports.AuthConnection = exports.SeedlessOnboardingControllerErrorMessage = exports.Web3AuthNetwork = exports.getDefaultSeedlessOnboardingControllerState = exports.SeedlessOnboardingController = void 0;
var SeedlessOnboardingController_1 = require("./SeedlessOnboardingController.cjs");
Object.defineProperty(exports, "SeedlessOnboardingController", { enumerable: true, get: function () { return SeedlessOnboardingController_1.SeedlessOnboardingController; } });
Object.defineProperty(exports, "getDefaultSeedlessOnboardingControllerState", { enumerable: true, get: function () { return SeedlessOnboardingController_1.getInitialSeedlessOnboardingControllerStateWithDefaults; } });
var constants_1 = require("./constants.cjs");
Object.defineProperty(exports, "Web3AuthNetwork", { enumerable: true, get: function () { return constants_1.Web3AuthNetwork; } });
Object.defineProperty(exports, "SeedlessOnboardingControllerErrorMessage", { enumerable: true, get: function () { return constants_1.SeedlessOnboardingControllerErrorMessage; } });
Object.defineProperty(exports, "AuthConnection", { enumerable: true, get: function () { return constants_1.AuthConnection; } });
Object.defineProperty(exports, "SecretType", { enumerable: true, get: function () { return constants_1.SecretType; } });
var SecretMetadata_1 = require("./SecretMetadata.cjs");
Object.defineProperty(exports, "SecretMetadata", { enumerable: true, get: function () { return SecretMetadata_1.SecretMetadata; } });
var errors_1 = require("./errors.cjs");
Object.defineProperty(exports, "RecoveryError", { enumerable: true, get: function () { return errors_1.RecoveryError; } });

      };
    };
  }
  }
}, {package:"@metamask/seedless-onboarding-controller",file:"node_modules\\@metamask\\seedless-onboarding-controller\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\logger.cjs", {"./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\constants.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cseedless-onboarding-controller%5Cdist%5Clogger.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createModuleLogger = exports.projectLogger = void 0;
const utils_1 = require("@metamask/utils");
Object.defineProperty(exports, "createModuleLogger", { enumerable: true, get: function () { return utils_1.createModuleLogger; } });
const constants_1 = require("./constants.cjs");
exports.projectLogger = (0, utils_1.createProjectLogger)(constants_1.controllerName);

      };
    };
  }
  }
}, {package:"@metamask/seedless-onboarding-controller",file:"node_modules\\@metamask\\seedless-onboarding-controller\\dist\\logger.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\seedless-onboarding-controller\\dist\\utils.cjs", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","@noble/ciphers/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@noble\\ciphers\\utils.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cseedless-onboarding-controller%5Cdist%5Cutils.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deserializeAuthKeyPair = exports.serializeToprfAuthKeyPair = exports.deserializeVaultData = exports.serializeVaultData = exports.decodeJWTToken = exports.decodeNodeAuthToken = void 0;
const utils_1 = require("@metamask/utils");
const utils_2 = require("@noble/ciphers/utils");
/**
 * Decode the node auth token from base64 to json object.
 *
 * @param token - The node auth token to decode.
 * @returns The decoded node auth token.
 */
function decodeNodeAuthToken(token) {
    return JSON.parse((0, utils_2.bytesToUtf8)((0, utils_1.base64ToBytes)(token)));
}
exports.decodeNodeAuthToken = decodeNodeAuthToken;
/**
 * Decode JWT token
 *
 * @param token - The JWT token to decode.
 * @returns The decoded JWT token.
 */
function decodeJWTToken(token) {
    // JWT tokens have 3 parts separated by dots: header.payload.signature
    const parts = token.split('.');
    if (parts.length !== 3) {
        throw new Error('Invalid JWT token format');
    }
    // Decode the payload (second part)
    const payload = parts[1];
    // Add padding if needed for base64 decoding
    const paddedPayload = payload + '='.repeat((4 - (payload.length % 4)) % 4);
    const decoded = JSON.parse((0, utils_2.bytesToUtf8)((0, utils_1.base64ToBytes)(paddedPayload)));
    return decoded;
}
exports.decodeJWTToken = decodeJWTToken;
/**
 * Serialize the vault data.
 *
 * @param data - The vault data to serialize.
 * @returns The serialized vault data.
 */
function serializeVaultData(data) {
    const toprfEncryptionKey = (0, utils_1.bytesToBase64)(data.toprfEncryptionKey);
    const toprfPwEncryptionKey = (0, utils_1.bytesToBase64)(data.toprfPwEncryptionKey);
    const toprfAuthKeyPair = serializeToprfAuthKeyPair(data.toprfAuthKeyPair);
    return JSON.stringify({
        toprfEncryptionKey,
        toprfPwEncryptionKey,
        toprfAuthKeyPair,
        revokeToken: data.revokeToken,
        accessToken: data.accessToken,
    });
}
exports.serializeVaultData = serializeVaultData;
/**
 * Deserialize the vault data.
 *
 * @param value - The stringified vault data.
 * @returns The deserialized vault data.
 */
function deserializeVaultData(value) {
    const toprfEncryptionKey = (0, utils_1.base64ToBytes)(value.toprfEncryptionKey);
    const toprfPwEncryptionKey = (0, utils_1.base64ToBytes)(value.toprfPwEncryptionKey);
    const toprfAuthKeyPair = deserializeAuthKeyPair(value.toprfAuthKeyPair);
    return {
        ...value,
        toprfEncryptionKey,
        toprfPwEncryptionKey,
        toprfAuthKeyPair,
    };
}
exports.deserializeVaultData = deserializeVaultData;
/**
 * Serialize TOPRF authentication key pair.
 *
 * @param keyPair - The authentication key pair to serialize.
 * @returns The serialized authentication key pair.
 */
function serializeToprfAuthKeyPair(keyPair) {
    const b64EncodedAuthKeyPair = JSON.stringify({
        sk: (0, utils_1.bigIntToHex)(keyPair.sk),
        pk: (0, utils_1.bytesToBase64)(keyPair.pk),
    });
    return b64EncodedAuthKeyPair;
}
exports.serializeToprfAuthKeyPair = serializeToprfAuthKeyPair;
/**
 * Deserialize the authentication key pair.
 *
 * @param value - The stringified authentication key pair.
 * @returns The deserialized authentication key pair.
 */
function deserializeAuthKeyPair(value) {
    const parsedKeyPair = JSON.parse(value);
    return {
        sk: (0, utils_1.hexToBigInt)(parsedKeyPair.sk),
        pk: (0, utils_1.base64ToBytes)(parsedKeyPair.pk),
    };
}
exports.deserializeAuthKeyPair = deserializeAuthKeyPair;

      };
    };
  }
  }
}, {package:"@metamask/seedless-onboarding-controller",file:"node_modules\\@metamask\\seedless-onboarding-controller\\dist\\utils.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\signature-controller\\dist\\SignatureController.cjs", {"./logger.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\signature-controller\\dist\\logger.cjs","./types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\signature-controller\\dist\\types.cjs","./utils/decoding-api.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\signature-controller\\dist\\utils\\decoding-api.cjs","./utils/delegations.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\signature-controller\\dist\\utils\\delegations.cjs","./utils/normalize.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\signature-controller\\dist\\utils\\normalize.cjs","./utils/validation.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\signature-controller\\dist\\utils\\validation.cjs","@metamask/base-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\base-controller\\dist\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs","@metamask/logging-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\logging-controller\\dist\\index.cjs","events":"D:\\code\\v\\metamask-extension\\node_modules\\events\\events.js","uuid":"D:\\code\\v\\metamask-extension\\node_modules\\uuid\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csignature-controller%5Cdist%5CSignatureController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _SignatureController_instances, _SignatureController_decodingApiUrl, _SignatureController_isDecodeSignatureRequestEnabled, _SignatureController_trace, _SignatureController_tryGetDecodedPermissionIfDelegation, _SignatureController_parseTypedData, _SignatureController_processSignatureRequest, _SignatureController_addMetadata, _SignatureController_processApproval, _SignatureController_approveAndSignRequest, _SignatureController_signRequest, _SignatureController_errorSignatureRequest, _SignatureController_rejectSignatureRequest, _SignatureController_waitForFinished, _SignatureController_requestApproval, _SignatureController_updateMetadata, _SignatureController_updateState, _SignatureController_generateLegacyState, _SignatureController_addLog, _SignatureController_getSignTypeForLogger, _SignatureController_getChainId, _SignatureController_decodePermitSignatureRequest, _SignatureController_getInternalAccounts;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SignatureController = void 0;
const base_controller_1 = require("@metamask/base-controller");
const controller_utils_1 = require("@metamask/controller-utils");
const keyring_controller_1 = require("@metamask/keyring-controller");
const logging_controller_1 = require("@metamask/logging-controller");
// This package purposefully relies on Node's EventEmitter module.
// eslint-disable-next-line import-x/no-nodejs-modules
const events_1 = __importDefault(require("events"));
const uuid_1 = require("uuid");
const logger_1 = require("./logger.cjs");
const types_1 = require("./types.cjs");
const decoding_api_1 = require("./utils/decoding-api.cjs");
const delegations_1 = require("./utils/delegations.cjs");
const normalize_1 = require("./utils/normalize.cjs");
const validation_1 = require("./utils/validation.cjs");
const controllerName = 'SignatureController';
const stateMetadata = {
    signatureRequests: {
        includeInStateLogs: true,
        persist: false,
        anonymous: false,
        usedInUi: true,
    },
    unapprovedPersonalMsgs: {
        includeInStateLogs: true,
        persist: false,
        anonymous: false,
        usedInUi: true,
    },
    unapprovedTypedMessages: {
        includeInStateLogs: true,
        persist: false,
        anonymous: false,
        usedInUi: true,
    },
    unapprovedPersonalMsgCount: {
        includeInStateLogs: true,
        persist: false,
        anonymous: false,
        usedInUi: true,
    },
    unapprovedTypedMessagesCount: {
        includeInStateLogs: true,
        persist: false,
        anonymous: false,
        usedInUi: true,
    },
};
const getDefaultState = () => ({
    signatureRequests: {},
    unapprovedPersonalMsgs: {},
    unapprovedTypedMessages: {},
    unapprovedPersonalMsgCount: 0,
    unapprovedTypedMessagesCount: 0,
});
/** List of statuses that will not be updated and trigger the finished event. */
const FINAL_STATUSES = [
    types_1.SignatureRequestStatus.Signed,
    types_1.SignatureRequestStatus.Rejected,
    types_1.SignatureRequestStatus.Errored,
];
/**
 * Controller for creating signing requests requiring user approval.
 */
class SignatureController extends base_controller_1.BaseController {
    /**
     * Construct a Sign controller.
     *
     * @param options - The controller options.
     * @param options.decodingApiUrl - Api used to get decoded data for permits.
     * @param options.isDecodeSignatureRequestEnabled - Function to check is decoding signature request is enabled.
     * @param options.messenger - The restricted messenger for the sign controller.
     * @param options.state - Initial state to set on this controller.
     * @param options.trace - Callback to generate trace information.
     */
    constructor({ decodingApiUrl, isDecodeSignatureRequestEnabled, messenger, state, trace, }) {
        super({
            name: controllerName,
            metadata: stateMetadata,
            messenger,
            state: {
                ...getDefaultState(),
                ...state,
            },
        });
        _SignatureController_instances.add(this);
        _SignatureController_decodingApiUrl.set(this, void 0);
        _SignatureController_isDecodeSignatureRequestEnabled.set(this, void 0);
        _SignatureController_trace.set(this, void 0);
        this.hub = new events_1.default();
        __classPrivateFieldSet(this, _SignatureController_trace, trace ?? ((_request, fn) => fn?.()), "f");
        __classPrivateFieldSet(this, _SignatureController_decodingApiUrl, decodingApiUrl, "f");
        __classPrivateFieldSet(this, _SignatureController_isDecodeSignatureRequestEnabled, isDecodeSignatureRequestEnabled, "f");
    }
    /**
     * A getter for the number of 'unapproved' PersonalMessages in this.messages.
     *
     * @deprecated Use `signatureRequests` state instead.
     * @returns The number of 'unapproved' PersonalMessages in this.messages
     */
    get unapprovedPersonalMessagesCount() {
        return this.state.unapprovedPersonalMsgCount;
    }
    /**
     * A getter for the number of 'unapproved' TypedMessages in this.messages.
     *
     * @deprecated Use `signatureRequests` state instead.
     * @returns The number of 'unapproved' TypedMessages in this.messages
     */
    get unapprovedTypedMessagesCount() {
        return this.state.unapprovedTypedMessagesCount;
    }
    /**
     * A getter for returning all messages.
     *
     * @deprecated Use `signatureRequests` state instead.
     * @returns The object containing all messages.
     */
    get messages() {
        return this.state.signatureRequests;
    }
    /**
     * Reset the controller state to the initial state.
     */
    resetState() {
        __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_updateState).call(this, (state) => {
            Object.assign(state, getDefaultState());
        });
    }
    /**
     * Reject all unapproved messages of any type.
     *
     * @param reason - A message to indicate why.
     */
    rejectUnapproved(reason) {
        const unapprovedSignatureRequests = Object.values(this.state.signatureRequests).filter((metadata) => metadata.status ===
            types_1.SignatureRequestStatus.Unapproved);
        for (const metadata of unapprovedSignatureRequests) {
            __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_rejectSignatureRequest).call(this, metadata.id, reason);
        }
    }
    /**
     * Clears all unapproved messages from memory.
     */
    clearUnapproved() {
        __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_updateState).call(this, (state) => {
            Object.values(state.signatureRequests)
                .filter((metadata) => metadata.status ===
                types_1.SignatureRequestStatus.Unapproved)
                .forEach((metadata) => delete state.signatureRequests[metadata.id]);
        });
    }
    /**
     * Called when a dApp uses the personal_sign method.
     * We currently provide personal_sign mostly for legacy dApps.
     *
     * @param messageParams - The params of the message to sign and return to the dApp.
     * @param request - The original request, containing the origin.
     * @param options - An options bag for the method.
     * @param options.traceContext - The parent context for any new traces.
     * @returns Promise resolving to the raw signature hash generated from the signature request.
     */
    async newUnsignedPersonalMessage(messageParams, request, options = {}) {
        (0, validation_1.validatePersonalSignatureRequest)(messageParams);
        const normalizedMessageParams = (0, normalize_1.normalizePersonalMessageParams)(messageParams);
        normalizedMessageParams.siwe = (0, controller_utils_1.detectSIWE)(messageParams);
        return __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_processSignatureRequest).call(this, {
            messageParams: normalizedMessageParams,
            request,
            type: types_1.SignatureRequestType.PersonalSign,
            approvalType: controller_utils_1.ApprovalType.PersonalSign,
            traceContext: options.traceContext,
        });
    }
    /**
     * Called when a dapp uses the eth_signTypedData method, per EIP-712.
     *
     * @param messageParams - The params of the message to sign and return to the dApp.
     * @param request - The original request, containing the origin.
     * @param versionString - The version of the signTypedData request.
     * @param signingOptions - Options for signing the typed message.
     * @param options - An options bag for the method.
     * @param options.traceContext - The parent context for any new traces.
     * @returns Promise resolving to the raw signature hash generated from the signature request.
     */
    async newUnsignedTypedMessage(messageParams, request, versionString, signingOptions, options = {}) {
        const chainId = __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_getChainId).call(this, request);
        const internalAccounts = __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_getInternalAccounts).call(this);
        const version = versionString;
        const decodedPermission = __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_tryGetDecodedPermissionIfDelegation).call(this, {
            messageParams,
            version,
            request,
        });
        (0, validation_1.validateTypedSignatureRequest)({
            currentChainId: chainId,
            internalAccounts,
            messageData: messageParams,
            request,
            version,
            decodedPermission,
        });
        const normalizedMessageParams = (0, normalize_1.normalizeTypedMessageParams)(messageParams, version);
        return __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_processSignatureRequest).call(this, {
            approvalType: controller_utils_1.ApprovalType.EthSignTypedData,
            messageParams: normalizedMessageParams,
            request,
            signingOptions,
            traceContext: options.traceContext,
            type: types_1.SignatureRequestType.TypedSign,
            version,
            decodedPermission,
        });
    }
    /**
     * Provide a signature for a pending signature request that used `deferSetAsSigned`.
     * Changes the status of the signature request to `signed`.
     *
     * @param signatureRequestId - The ID of the signature request.
     * @param signature - The signature to provide.
     */
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    setDeferredSignSuccess(signatureRequestId, signature) {
        __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_updateMetadata).call(this, signatureRequestId, (draftMetadata) => {
            draftMetadata.rawSig = signature;
            draftMetadata.status =
                types_1.SignatureRequestStatus.Signed;
        });
    }
    /**
     * Set custom metadata on a signature request.
     *
     * @param signatureRequestId - The ID of the signature request.
     * @param metadata - The custom metadata to set.
     */
    setMessageMetadata(signatureRequestId, metadata) {
        __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_updateMetadata).call(this, signatureRequestId, (draftMetadata) => {
            draftMetadata.metadata = metadata;
        });
    }
    /**
     * Reject a pending signature request that used `deferSetAsSigned`.
     * Changes the status of the signature request to `rejected`.
     *
     * @param signatureRequestId - The ID of the signature request.
     */
    setDeferredSignError(signatureRequestId) {
        __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_updateMetadata).call(this, signatureRequestId, (draftMetadata) => {
            draftMetadata.status = types_1.SignatureRequestStatus.Rejected;
        });
    }
    /**
     * Set the status of a signature request to 'inProgress'.
     *
     * @param signatureRequestId - The ID of the signature request.
     */
    setTypedMessageInProgress(signatureRequestId) {
        __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_updateMetadata).call(this, signatureRequestId, (draftMetadata) => {
            draftMetadata.status = types_1.SignatureRequestStatus.InProgress;
        });
    }
    /**
     * Set the status of a signature request to 'inProgress'.
     *
     * @param signatureRequestId - The ID of the signature request.
     */
    setPersonalMessageInProgress(signatureRequestId) {
        this.setTypedMessageInProgress(signatureRequestId);
    }
}
exports.SignatureController = SignatureController;
_SignatureController_decodingApiUrl = new WeakMap(), _SignatureController_isDecodeSignatureRequestEnabled = new WeakMap(), _SignatureController_trace = new WeakMap(), _SignatureController_instances = new WeakSet(), _SignatureController_tryGetDecodedPermissionIfDelegation = function _SignatureController_tryGetDecodedPermissionIfDelegation({ messageParams, version, request, }) {
    let data;
    try {
        data = __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_parseTypedData).call(this, messageParams, version)
            .data;
    }
    catch (error) {
        (0, logger_1.projectLogger)('Failed to parse typed data', error);
        return undefined;
    }
    const isRequestDelegationRequest = (0, delegations_1.isDelegationRequest)(data);
    if (!isRequestDelegationRequest ||
        !request.origin ||
        version !== keyring_controller_1.SignTypedDataVersion.V4) {
        return undefined;
    }
    let decodedPermission;
    try {
        (0, delegations_1.validateExecutionPermissionMetadata)(data);
        decodedPermission = (0, delegations_1.decodePermissionFromRequest)({
            origin: request.origin,
            data,
            messenger: this.messagingSystem,
        });
    }
    catch (error) {
        // we ignore this error, because it simply means the request could not be
        // decoded into a permission in which case we will not set a
        // decodedPermission on the metadata, and may fail validation if the
        // request is invalid.
        (0, logger_1.projectLogger)('Failed to decode permission', error.message);
    }
    return decodedPermission;
}, _SignatureController_parseTypedData = function _SignatureController_parseTypedData(messageParams, version) {
    if (![keyring_controller_1.SignTypedDataVersion.V3, keyring_controller_1.SignTypedDataVersion.V4].includes(version) ||
        typeof messageParams.data !== 'string') {
        return messageParams;
    }
    return {
        ...messageParams,
        data: JSON.parse(messageParams.data),
    };
}, _SignatureController_processSignatureRequest = async function _SignatureController_processSignatureRequest({ chainId: optionChainId, messageParams, request, type, approvalType, version, signingOptions, traceContext, decodedPermission, }) {
    (0, logger_1.projectLogger)('Processing signature request', {
        messageParams,
        request,
        type,
        version,
    });
    const chainId = optionChainId ?? __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_getChainId).call(this, request);
    __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_addLog).call(this, type, version, logging_controller_1.SigningStage.Proposed, messageParams);
    const metadata = __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_addMetadata).call(this, {
        chainId,
        messageParams,
        request,
        signingOptions,
        type,
        version,
        decodedPermission,
    });
    let resultCallbacks;
    let approveOrSignError;
    const finalMetadataPromise = __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_waitForFinished).call(this, metadata.id);
    __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_decodePermitSignatureRequest).call(this, metadata.id, request, chainId);
    try {
        resultCallbacks = await __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_processApproval).call(this, {
            approvalType,
            metadata,
            request,
            traceContext,
        });
        await __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_approveAndSignRequest).call(this, metadata, traceContext);
    }
    catch (error) {
        (0, logger_1.projectLogger)('Signature request failed', error.message);
        approveOrSignError = error;
    }
    const finalMetadata = await finalMetadataPromise;
    const { error, id, messageParams: finalMessageParams, rawSig: signature, } = finalMetadata;
    switch (finalMetadata.status) {
        case types_1.SignatureRequestStatus.Signed:
            (0, logger_1.projectLogger)('Signature request finished', { id, signature });
            __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_addLog).call(this, type, version, logging_controller_1.SigningStage.Signed, finalMessageParams);
            resultCallbacks?.success(signature);
            return finalMetadata.rawSig;
        case types_1.SignatureRequestStatus.Rejected:
            /* istanbul ignore next */
            const rejectedError = (approveOrSignError ??
                new Error(`MetaMask ${type} Signature: User denied message signature.`));
            resultCallbacks?.error(rejectedError);
            throw rejectedError;
        case types_1.SignatureRequestStatus.Errored:
            /* istanbul ignore next */
            const erroredError = (approveOrSignError ??
                new Error(`MetaMask ${type} Signature: ${error}`));
            resultCallbacks?.error(erroredError);
            throw erroredError;
        /* istanbul ignore next */
        default:
            throw new Error(`MetaMask ${type} Signature: Unknown problem: ${JSON.stringify(finalMessageParams)}`);
    }
}, _SignatureController_addMetadata = function _SignatureController_addMetadata({ chainId, messageParams, request, signingOptions, type, version, decodedPermission, }) {
    const id = (0, uuid_1.v1)();
    const origin = request?.origin ?? messageParams.origin;
    const requestId = request?.id;
    const securityAlertResponse = request?.securityAlertResponse;
    const networkClientId = request?.networkClientId;
    const finalMessageParams = {
        ...messageParams,
        metamaskId: id,
        origin,
        requestId,
        version,
    };
    const metadata = {
        chainId,
        id,
        messageParams: finalMessageParams,
        networkClientId,
        securityAlertResponse,
        signingOptions,
        status: types_1.SignatureRequestStatus.Unapproved,
        time: Date.now(),
        type,
        version,
        decodedPermission,
    };
    __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_updateState).call(this, (state) => {
        state.signatureRequests[metadata.id] = metadata;
    });
    (0, logger_1.projectLogger)('Added signature request', metadata);
    this.hub.emit('unapprovedMessage', {
        messageParams,
        metamaskId: metadata.id,
    });
    return metadata;
}, _SignatureController_processApproval = async function _SignatureController_processApproval({ approvalType, metadata, request, traceContext, }) {
    const { id, messageParams, type, version } = metadata;
    try {
        const acceptResult = await __classPrivateFieldGet(this, _SignatureController_trace, "f").call(this, { name: 'Await Approval', parentContext: traceContext }, (context) => __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_requestApproval).call(this, metadata, approvalType, {
            traceContext: context,
            actionId: request?.id?.toString(),
        }));
        return acceptResult.resultCallbacks;
    }
    catch (error) {
        (0, logger_1.projectLogger)('User rejected request', { id, error });
        __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_addLog).call(this, type, version, logging_controller_1.SigningStage.Rejected, messageParams);
        __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_rejectSignatureRequest).call(this, id);
        throw error;
    }
}, _SignatureController_approveAndSignRequest = async function _SignatureController_approveAndSignRequest(metadata, traceContext) {
    const { id } = metadata;
    __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_updateMetadata).call(this, id, (draftMetadata) => {
        draftMetadata.status = types_1.SignatureRequestStatus.Approved;
    });
    await __classPrivateFieldGet(this, _SignatureController_trace, "f").call(this, { name: 'Sign', parentContext: traceContext }, () => __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_signRequest).call(this, metadata));
}, _SignatureController_signRequest = async function _SignatureController_signRequest(metadata) {
    const { id, messageParams, signingOptions, type } = metadata;
    try {
        let signature;
        switch (type) {
            case types_1.SignatureRequestType.PersonalSign:
                signature = await this.messagingSystem.call('KeyringController:signPersonalMessage', 
                // Keyring controller temporarily using message manager types.
                // eslint-disable-next-line @typescript-eslint/no-explicit-any
                messageParams);
                break;
            case types_1.SignatureRequestType.TypedSign:
                const finalRequest = signingOptions?.parseJsonData
                    ? __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_parseTypedData).call(this, messageParams, metadata.version)
                    : messageParams;
                signature = await this.messagingSystem.call('KeyringController:signTypedMessage', finalRequest, metadata.version);
                break;
            /* istanbul ignore next */
            default:
                throw new Error(`Unknown signature request type: ${type}`);
        }
        this.hub.emit(`${type}:signed`, { signature, messageId: id });
        if (messageParams.deferSetAsSigned) {
            return;
        }
        __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_updateMetadata).call(this, id, (draftMetadata) => {
            draftMetadata.rawSig = signature;
            draftMetadata.status = types_1.SignatureRequestStatus.Signed;
        });
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
    }
    catch (error) {
        if (type === types_1.SignatureRequestType.TypedSign) {
            __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_errorSignatureRequest).call(this, id, error.message);
        }
        else {
            __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_rejectSignatureRequest).call(this, id);
        }
        this.hub.emit(`${id}:signError`, { error });
        throw error;
    }
}, _SignatureController_errorSignatureRequest = function _SignatureController_errorSignatureRequest(id, error) {
    __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_updateMetadata).call(this, id, (draftMetadata) => {
        draftMetadata.status = types_1.SignatureRequestStatus.Errored;
        draftMetadata.error = error;
    });
}, _SignatureController_rejectSignatureRequest = function _SignatureController_rejectSignatureRequest(signatureRequestId, reason) {
    if (reason) {
        const metadata = this.state.signatureRequests[signatureRequestId];
        this.hub.emit('cancelWithReason', { metadata, reason });
    }
    __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_updateMetadata).call(this, signatureRequestId, (draftMetadata) => {
        draftMetadata.status = types_1.SignatureRequestStatus.Rejected;
    });
}, _SignatureController_waitForFinished = async function _SignatureController_waitForFinished(id) {
    return new Promise((resolve) => {
        this.hub.once(`${id}:finished`, (metadata) => {
            resolve(metadata);
        });
    });
}, _SignatureController_requestApproval = async function _SignatureController_requestApproval(metadata, type, { traceContext, actionId, }) {
    const { id, messageParams } = metadata;
    const origin = messageParams.origin || controller_utils_1.ORIGIN_METAMASK;
    await __classPrivateFieldGet(this, _SignatureController_trace, "f").call(this, {
        name: 'Notification Display',
        id: actionId,
        parentContext: traceContext,
    });
    return (await this.messagingSystem.call('ApprovalController:addRequest', {
        id,
        origin,
        type,
        requestData: { ...messageParams },
        expectsResult: true,
    }, true));
}, _SignatureController_updateMetadata = function _SignatureController_updateMetadata(id, callback) {
    let statusChanged = false;
    const { nextState } = __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_updateState).call(this, (state) => {
        const metadata = state.signatureRequests[id];
        if (!metadata) {
            throw new Error(`Signature request with id ${id} not found`);
        }
        const originalStatus = metadata.status;
        callback(metadata);
        statusChanged = metadata.status !== originalStatus;
    });
    const updatedMetadata = nextState.signatureRequests[id];
    if (statusChanged &&
        FINAL_STATUSES.includes(updatedMetadata.status)) {
        this.hub.emit(`${id}:finished`, updatedMetadata);
    }
    return updatedMetadata;
}, _SignatureController_updateState = function _SignatureController_updateState(callback) {
    return this.update((state) => {
        callback(state);
        const unapprovedRequests = Object.values(state.signatureRequests).filter((request) => request.status === types_1.SignatureRequestStatus.Unapproved);
        const personalSignMessages = __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_generateLegacyState).call(this, unapprovedRequests, types_1.SignatureRequestType.PersonalSign);
        const typedSignMessages = __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_generateLegacyState).call(this, unapprovedRequests, types_1.SignatureRequestType.TypedSign);
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        state.unapprovedPersonalMsgs = personalSignMessages;
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        state.unapprovedTypedMessages = typedSignMessages;
        state.unapprovedPersonalMsgCount =
            Object.values(personalSignMessages).length;
        state.unapprovedTypedMessagesCount =
            Object.values(typedSignMessages).length;
    });
}, _SignatureController_generateLegacyState = function _SignatureController_generateLegacyState(signatureRequests, type) {
    return signatureRequests
        .filter((request) => request.type === type)
        .reduce((acc, request) => ({
        ...acc,
        [request.id]: { ...request, msgParams: request.messageParams },
    }), {});
}, _SignatureController_addLog = function _SignatureController_addLog(signatureRequestType, version, stage, signingData) {
    const signingMethod = __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_getSignTypeForLogger).call(this, signatureRequestType, version);
    this.messagingSystem.call('LoggingController:add', {
        type: logging_controller_1.LogType.EthSignLog,
        data: {
            signingMethod,
            stage,
            signingData,
        },
    });
}, _SignatureController_getSignTypeForLogger = function _SignatureController_getSignTypeForLogger(requestType, version) {
    if (requestType === types_1.SignatureRequestType.PersonalSign) {
        return logging_controller_1.SigningMethod.PersonalSign;
    }
    if (requestType === types_1.SignatureRequestType.TypedSign &&
        version === keyring_controller_1.SignTypedDataVersion.V3) {
        return logging_controller_1.SigningMethod.EthSignTypedDataV3;
    }
    if (requestType === types_1.SignatureRequestType.TypedSign &&
        version === keyring_controller_1.SignTypedDataVersion.V4) {
        return logging_controller_1.SigningMethod.EthSignTypedDataV4;
    }
    return logging_controller_1.SigningMethod.EthSignTypedData;
}, _SignatureController_getChainId = function _SignatureController_getChainId(request) {
    const { networkClientId } = request;
    if (!networkClientId) {
        throw new Error('Network client ID not found in request');
    }
    const networkClient = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId);
    return networkClient.configuration.chainId;
}, _SignatureController_decodePermitSignatureRequest = function _SignatureController_decodePermitSignatureRequest(signatureRequestId, request, chainId) {
    if (!__classPrivateFieldGet(this, _SignatureController_isDecodeSignatureRequestEnabled, "f")?.call(this) || !__classPrivateFieldGet(this, _SignatureController_decodingApiUrl, "f")) {
        return;
    }
    __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_updateMetadata).call(this, signatureRequestId, (draftMetadata) => {
        draftMetadata.decodingLoading = true;
    });
    (0, decoding_api_1.decodeSignature)(request, chainId, __classPrivateFieldGet(this, _SignatureController_decodingApiUrl, "f"))
        .then((decodingData) => __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_updateMetadata).call(this, signatureRequestId, (draftMetadata) => {
        draftMetadata.decodingData = decodingData;
        draftMetadata.decodingLoading = false;
    }))
        .catch((error) => __classPrivateFieldGet(this, _SignatureController_instances, "m", _SignatureController_updateMetadata).call(this, signatureRequestId, (draftMetadata) => {
        draftMetadata.decodingData = {
            stateChanges: null,
            error: {
                message: error.message,
                type: decoding_api_1.DECODING_API_ERRORS.DECODING_FAILED_WITH_ERROR,
            },
        };
        draftMetadata.decodingLoading = false;
    }));
}, _SignatureController_getInternalAccounts = function _SignatureController_getInternalAccounts() {
    const state = this.messagingSystem.call('AccountsController:getState');
    /* istanbul ignore next */
    return Object.values(state.internalAccounts?.accounts ?? {})
        .filter((account) => account.type === 'eip155:eoa')
        .map((account) => account.address);
};

      };
    };
  }
  }
}, {package:"@metamask/signature-controller",file:"node_modules\\@metamask\\signature-controller\\dist\\SignatureController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\signature-controller\\dist\\index.cjs", {"./SignatureController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\signature-controller\\dist\\SignatureController.cjs","./types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\signature-controller\\dist\\types.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csignature-controller%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./SignatureController.cjs"), exports);
__exportStar(require("./types.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/signature-controller",file:"node_modules\\@metamask\\signature-controller\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\signature-controller\\dist\\logger.cjs", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csignature-controller%5Cdist%5Clogger.cjs
      return function (require, module, exports) {
"use strict";
/* istanbul ignore file */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createModuleLogger = exports.projectLogger = void 0;
const utils_1 = require("@metamask/utils");
Object.defineProperty(exports, "createModuleLogger", { enumerable: true, get: function () { return utils_1.createModuleLogger; } });
exports.projectLogger = (0, utils_1.createProjectLogger)('signature-controller');

      };
    };
  }
  }
}, {package:"@metamask/signature-controller",file:"node_modules\\@metamask\\signature-controller\\dist\\logger.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\signature-controller\\dist\\types.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csignature-controller%5Cdist%5Ctypes.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SignatureRequestType = exports.SignatureRequestStatus = exports.DecodingDataChangeType = exports.EthMethod = void 0;
/**
 * Supported signature methods.
 */
var EthMethod;
(function (EthMethod) {
    EthMethod["PersonalSign"] = "personal_sign";
    EthMethod["SignTransaction"] = "eth_signTransaction";
    EthMethod["SignTypedDataV1"] = "eth_signTypedData_v1";
    EthMethod["SignTypedDataV3"] = "eth_signTypedData_v3";
    EthMethod["SignTypedDataV4"] = "eth_signTypedData_v4";
})(EthMethod || (exports.EthMethod = EthMethod = {}));
/** Different decoding data state change types */
var DecodingDataChangeType;
(function (DecodingDataChangeType) {
    DecodingDataChangeType["Receive"] = "RECEIVE";
    DecodingDataChangeType["Transfer"] = "TRANSFER";
    DecodingDataChangeType["Approve"] = "APPROVE";
    DecodingDataChangeType["Revoke"] = "REVOKE_APPROVE";
    DecodingDataChangeType["Bidding"] = "BIDDING";
    DecodingDataChangeType["Listing"] = "LISTING";
})(DecodingDataChangeType || (exports.DecodingDataChangeType = DecodingDataChangeType = {}));
/** Status of a signature request. */
var SignatureRequestStatus;
(function (SignatureRequestStatus) {
    SignatureRequestStatus["Unapproved"] = "unapproved";
    SignatureRequestStatus["Approved"] = "approved";
    SignatureRequestStatus["Rejected"] = "rejected";
    SignatureRequestStatus["InProgress"] = "inProgress";
    SignatureRequestStatus["Signed"] = "signed";
    SignatureRequestStatus["Errored"] = "errored";
})(SignatureRequestStatus || (exports.SignatureRequestStatus = SignatureRequestStatus = {}));
/** Type of supported signature requests. */
var SignatureRequestType;
(function (SignatureRequestType) {
    SignatureRequestType["PersonalSign"] = "personal_sign";
    SignatureRequestType["TypedSign"] = "eth_signTypedData";
})(SignatureRequestType || (exports.SignatureRequestType = SignatureRequestType = {}));

      };
    };
  }
  }
}, {package:"@metamask/signature-controller",file:"node_modules\\@metamask\\signature-controller\\dist\\types.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\signature-controller\\dist\\utils\\decoding-api.cjs", {"../types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\signature-controller\\dist\\types.cjs","./normalize.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\signature-controller\\dist\\utils\\normalize.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csignature-controller%5Cdist%5Cutils%5Cdecoding-api.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decodeSignature = exports.DECODING_API_ERRORS = void 0;
const normalize_1 = require("./normalize.cjs");
const types_1 = require("../types.cjs");
exports.DECODING_API_ERRORS = {
    UNSUPPORTED_SIGNATURE: 'UNSUPPORTED_SIGNATURE',
    DECODING_FAILED_WITH_ERROR: 'DECODING_FAILED_WITH_ERROR',
};
/**
 * The function calls decoding api for typed signature V4 requests and returns the result.
 *
 * @param request - Signature request.
 * @param chainId - chainId of network of signature request.
 * @param decodingApiUrl - URL of decoding api.
 * @returns Promise that resolved to give decoded data.
 */
async function decodeSignature(request, chainId, decodingApiUrl) {
    try {
        const { method, origin, params } = request;
        if (request.method === types_1.EthMethod.SignTypedDataV3 ||
            request.method === types_1.EthMethod.SignTypedDataV4) {
            const response = await fetch(`${decodingApiUrl}/signature?chainId=${chainId}`, {
                method: 'POST',
                body: JSON.stringify({
                    method,
                    origin,
                    params: [params[0], (0, normalize_1.normalizeParam)(params[1])],
                }),
                headers: { 'Content-Type': 'application/json' },
            });
            return await response.json();
        }
        return {
            error: {
                message: 'Unsupported signature.',
                type: exports.DECODING_API_ERRORS.UNSUPPORTED_SIGNATURE,
            },
        };
    }
    catch (error) {
        return {
            error: {
                message: error.message,
                type: exports.DECODING_API_ERRORS.DECODING_FAILED_WITH_ERROR,
            },
        };
    }
}
exports.decodeSignature = decodeSignature;

      };
    };
  }
  }
}, {package:"@metamask/signature-controller",file:"node_modules\\@metamask\\signature-controller\\dist\\utils\\decoding-api.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\signature-controller\\dist\\utils\\delegations.cjs", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csignature-controller%5Cdist%5Cutils%5Cdelegations.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateExecutionPermissionMetadata = exports.decodePermissionFromRequest = exports.isDelegationRequest = void 0;
const utils_1 = require("@metamask/utils");
const DELEGATION_PRIMARY_TYPE = 'Delegation';
/**
 * Determines whether the provided EIP-712 typed data represents a Delegation request.
 *
 * Accepts either a pre-parsed typed data object or a JSON string. If a string is
 * provided, it is parsed. Returns true when the `primaryType` is "Delegation".
 *
 * @param data - EIP-712 typed data object or its JSON string representation.
 *
 * @returns True if the typed message is a Delegation request; otherwise false.
 */
function isDelegationRequest(data) {
    const { primaryType } = data;
    return primaryType === DELEGATION_PRIMARY_TYPE;
}
exports.isDelegationRequest = isDelegationRequest;
/**
 * Decodes a permission from a Delegation EIP-712 request using the permissions controller.
 *
 * Parses the typed data from `messageParams`, validates and extracts `metadata.origin`
 * and `metadata.justification`, determines the `chainId`, and forwards the delegation
 * context to the permissions controller via the supplied messenger.
 *
 * @param params - Wrapper object for parameters.
 * @param params.messenger - Messenger used to call the permissions controller.
 * @param params.origin - The origin of the request.
 * @param params.data - The typed data to decode.
 *
 * @returns A decoded permission, or `undefined` if no permission can be derived.
 * @throws {Error} If required metadata (origin or justification) is missing or invalid.
 */
function decodePermissionFromRequest({ origin, data, messenger, }) {
    const { metadata: { origin: specifiedOrigin, justification }, } = data;
    if (typeof data.domain.chainId !== 'number') {
        throw new Error('Invalid chainId');
    }
    const { chainId } = data.domain;
    const { delegate, delegator, authority, caveats } = data.message;
    if (!(
    // isHexAddress requires a lowercase hex string
    ((0, utils_1.isHexAddress)(delegate?.toLowerCase()) &&
        (0, utils_1.isHexAddress)(delegator?.toLowerCase()) &&
        (0, utils_1.isStrictHexString)(authority) &&
        caveats))) {
        return undefined;
    }
    const decodedPermission = messenger.call('GatorPermissionsController:decodePermissionFromPermissionContextForOrigin', {
        origin,
        chainId,
        delegation: { delegate, delegator, caveats, authority },
        metadata: { justification, origin: specifiedOrigin },
    });
    return decodedPermission;
}
exports.decodePermissionFromRequest = decodePermissionFromRequest;
/**
 * Validates the provided MessageParamsTypedData contains valid EIP-7715
 * execution permissions metadata.
 *
 * @param data - The typed data to validate.
 * @throws {Error} If the metadata is invalid.
 */
function validateExecutionPermissionMetadata(data) {
    if (!('metadata' in data)) {
        throw new Error('Invalid metadata');
    }
    const { metadata } = data;
    if (!metadata ||
        !(typeof metadata.origin === 'string') ||
        !(typeof metadata.justification === 'string')) {
        throw new Error('Invalid metadata');
    }
}
exports.validateExecutionPermissionMetadata = validateExecutionPermissionMetadata;

      };
    };
  }
  }
}, {package:"@metamask/signature-controller",file:"node_modules\\@metamask\\signature-controller\\dist\\utils\\delegations.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\signature-controller\\dist\\utils\\normalize.cjs", {"@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csignature-controller%5Cdist%5Cutils%5Cnormalize.cjs
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalizeParam = exports.normalizeTypedMessageParams = exports.normalizePersonalMessageParams = void 0;
const keyring_controller_1 = require("@metamask/keyring-controller");
const utils_1 = require("@metamask/utils");
/**
 * Normalize personal message params.
 *
 * @param messageParams - The message params to normalize.
 * @returns The normalized message params.
 */
function normalizePersonalMessageParams(messageParams) {
    return {
        ...messageParams,
        data: normalizePersonalMessageData(messageParams.data),
    };
}
exports.normalizePersonalMessageParams = normalizePersonalMessageParams;
/**
 * Normalize typed message params.
 *
 * @param messageParams - The message params to normalize.
 * @param version - The version of the typed signature request.
 * @returns The normalized message params.
 */
function normalizeTypedMessageParams(messageParams, version) {
    const normalizedMessageParams = { ...messageParams };
    if (typeof messageParams.data !== 'string' &&
        (version === keyring_controller_1.SignTypedDataVersion.V3 || version === keyring_controller_1.SignTypedDataVersion.V4)) {
        normalizedMessageParams.data = JSON.stringify(messageParams.data);
    }
    return normalizedMessageParams;
}
exports.normalizeTypedMessageParams = normalizeTypedMessageParams;
/**
 * Converts raw message data buffer to a hex, or just returns the data if
 * it is already formatted as a hex.
 *
 * @param data - The buffer data to convert to a hex.
 * @returns A hex string conversion of the buffer data.
 */
function normalizePersonalMessageData(data) {
    try {
        const stripped = (0, utils_1.remove0x)(data);
        if (stripped.match(/^[0-9A-Fa-f]+$/gu)) {
            return (0, utils_1.add0x)(stripped);
        }
    }
    catch (e) {
        /* istanbul ignore next */
    }
    return (0, utils_1.bytesToHex)(Buffer.from(data, 'utf8'));
}
/**
 * The method will convery all values in a JSON to string.
 * Currently decoding api is not able to take numeric values,
 * once apiis fixed we can get rid of this normalization.
 *
 * @param value - JSON to be normalized.
 * @returns JSON with all values converted to string.
 */
function convertJSONValuesToString(value) {
    if (Array.isArray(value)) {
        return value.map((val) => convertJSONValuesToString(val));
    }
    if (typeof value === 'object' && value !== null) {
        for (const key in value) {
            if (Object.prototype.hasOwnProperty.call(value, key)) {
                value[key] = convertJSONValuesToString(value[key]);
            }
        }
        return value;
    }
    return value?.toString() ?? '';
}
/**
 * Takes a stringified JSON and replaces stringifying all values.
 *
 * @param param - of JSON to be fixed.
 * @returns JSON with all values converted to quoted strings.
 */
function normalizeParam(param) {
    if (!param) {
        return {};
    }
    const parsedParam = typeof param === 'string' ? JSON.parse(param) : param;
    return convertJSONValuesToString(parsedParam);
}
exports.normalizeParam = normalizeParam;

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"@metamask/signature-controller",file:"node_modules\\@metamask\\signature-controller\\dist\\utils\\normalize.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\signature-controller\\dist\\utils\\validation.cjs", {"./delegations.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\signature-controller\\dist\\utils\\delegations.cjs","@metamask/approval-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\approval-controller\\dist\\index.cjs","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/eth-sig-util":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-sig-util\\dist\\index.js","@metamask/keyring-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\keyring-controller\\dist\\index.cjs","jsonschema":"D:\\code\\v\\metamask-extension\\node_modules\\jsonschema\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csignature-controller%5Cdist%5Cutils%5Cvalidation.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateTypedSignatureRequest = exports.validatePersonalSignatureRequest = exports.DELEGATOR_FIELD = exports.PRIMARY_TYPE_DELEGATION = void 0;
const approval_controller_1 = require("@metamask/approval-controller");
const controller_utils_1 = require("@metamask/controller-utils");
const eth_sig_util_1 = require("@metamask/eth-sig-util");
const keyring_controller_1 = require("@metamask/keyring-controller");
const jsonschema_1 = require("jsonschema");
const delegations_1 = require("./delegations.cjs");
exports.PRIMARY_TYPE_DELEGATION = 'Delegation';
exports.DELEGATOR_FIELD = 'delegator';
/**
 * Validate a personal signature request.
 *
 * @param messageData - The message data to validate.
 */
function validatePersonalSignatureRequest(messageData) {
    const { from, data } = messageData;
    validateAddress(from, 'from');
    if (!data || typeof data !== 'string') {
        throw new Error(`Invalid message "data": ${data} must be a valid string.`);
    }
}
exports.validatePersonalSignatureRequest = validatePersonalSignatureRequest;
/**
 * Validate a typed signature request.
 *
 * @param options - Options bag.
 * @param options.currentChainId - The current chain ID.
 * @param options.internalAccounts - The addresses of all internal accounts.
 * @param options.messageData - The message data to validate.
 * @param options.request - The original request.
 * @param options.version - The version of the typed signature request.
 * @param options.decodedPermission - The decoded permission.
 */
function validateTypedSignatureRequest({ currentChainId, internalAccounts, messageData, request, version, decodedPermission, }) {
    validateAddress(messageData.from, 'from');
    if (version === keyring_controller_1.SignTypedDataVersion.V1) {
        validateTypedSignatureRequestV1(messageData);
    }
    else {
        validateTypedSignatureRequestV3V4({
            currentChainId,
            internalAccounts,
            messageData,
            request,
            decodedPermission,
        });
    }
}
exports.validateTypedSignatureRequest = validateTypedSignatureRequest;
/**
 * Validate a V1 typed signature request.
 *
 * @param messageData - The message data to validate.
 */
function validateTypedSignatureRequestV1(messageData) {
    if (!messageData.data || !Array.isArray(messageData.data)) {
        throw new Error(
        // TODO: Either fix this lint violation or explain why it's necessary to ignore.
        // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
        `Invalid message "data": ${messageData.data} must be a valid array.`);
    }
    try {
        // typedSignatureHash will throw if the data is invalid.
        // TODO: Replace `any` with type
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        (0, eth_sig_util_1.typedSignatureHash)(messageData.data);
    }
    catch (e) {
        throw new Error(`Expected EIP712 typed data.`);
    }
}
/**
 * Validate a V3 or V4 typed signature request.
 *
 * @param options - Options bag.
 * @param options.currentChainId - The current chain ID.
 * @param options.internalAccounts - The addresses of all internal accounts.
 * @param options.messageData - The message data to validate.
 * @param options.request - The original request.
 * @param options.decodedPermission - The decoded permission.
 */
function validateTypedSignatureRequestV3V4({ currentChainId, internalAccounts, messageData, request, decodedPermission, }) {
    if (!messageData.data ||
        Array.isArray(messageData.data) ||
        (typeof messageData.data !== 'object' &&
            typeof messageData.data !== 'string')) {
        throw new Error(`Invalid message "data": Must be a valid string or object.`);
    }
    let data;
    if (typeof messageData.data === 'object') {
        data = messageData.data;
    }
    else {
        try {
            data = JSON.parse(messageData.data);
        }
        catch (e) {
            throw new Error('Data must be passed as a valid JSON string.');
        }
    }
    const validation = (0, jsonschema_1.validate)(data, eth_sig_util_1.TYPED_MESSAGE_SCHEMA);
    if (validation.errors.length > 0) {
        throw new Error('Data must conform to EIP-712 schema. See https://git.io/fNtcx.');
    }
    if (!currentChainId) {
        throw new Error('Current chainId cannot be null or undefined.');
    }
    let { chainId } = data.domain;
    if (chainId) {
        if (typeof chainId === 'string') {
            chainId = parseInt(chainId, chainId.startsWith('0x') ? 16 : 10);
        }
        const activeChainId = parseInt(currentChainId, 16);
        if (Number.isNaN(activeChainId)) {
            throw new Error(`Cannot sign messages for chainId "${chainId}", because MetaMask is switching networks.`);
        }
        if (chainId !== activeChainId) {
            throw new Error(`Provided chainId "${chainId}" must match the active chainId "${activeChainId}"`);
        }
    }
    const origin = request?.origin ?? messageData?.origin;
    validateVerifyingContract({
        data,
        internalAccounts,
        origin,
    });
    validateDelegation({
        data,
        internalAccounts,
        origin,
        decodedPermission,
    });
}
/**
 * Validate an Ethereum address.
 *
 * @param address - The address to validate.
 * @param propertyName - The name of the property source to use in the error message.
 */
function validateAddress(address, propertyName) {
    if (!address || typeof address !== 'string' || !(0, controller_utils_1.isValidHexAddress)(address)) {
        throw new Error(`Invalid "${propertyName}" address: ${address} must be a valid string.`);
    }
}
/**
 * Validate the verifying contract from a typed signature request.
 *
 * @param options - Options bag.
 * @param options.data - The typed data to validate.
 * @param options.internalAccounts - The internal accounts.
 * @param options.origin - The origin of the request.
 */
function validateVerifyingContract({ data, internalAccounts, origin, }) {
    const verifyingContract = data?.domain?.verifyingContract;
    const isExternal = origin && origin !== approval_controller_1.ORIGIN_METAMASK;
    if (verifyingContract &&
        typeof verifyingContract === 'string' &&
        isExternal &&
        internalAccounts.some((internalAccount) => internalAccount.toLowerCase() === verifyingContract.toLowerCase())) {
        throw new Error(`External signature requests cannot use internal accounts as the verifying contract.`);
    }
}
/**
 * Validate a delegation signature request.
 *
 * @param options - Options bag.
 * @param options.data - The typed data to validate.
 * @param options.internalAccounts - The internal accounts.
 * @param options.origin - The origin of the request.
 * @param options.decodedPermission - The decoded permission.
 */
function validateDelegation({ data, internalAccounts, origin, decodedPermission, }) {
    if (!(0, delegations_1.isDelegationRequest)(data)) {
        return;
    }
    const hasDecodedPermission = decodedPermission !== undefined;
    if (!hasDecodedPermission) {
        const isOriginExternal = origin && origin !== approval_controller_1.ORIGIN_METAMASK;
        const delegatorAddressLowercase = data.message?.[exports.DELEGATOR_FIELD]?.toLowerCase();
        const isSignerInternal = internalAccounts.some((internalAccount) => internalAccount.toLowerCase() === delegatorAddressLowercase);
        if (isOriginExternal && isSignerInternal) {
            throw new Error(`External signature requests cannot sign delegations for internal accounts.`);
        }
    }
}

      };
    };
  }
  }
}, {package:"@metamask/signature-controller",file:"node_modules\\@metamask\\signature-controller\\dist\\utils\\validation.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\slip44\\slip44.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cslip44%5Cslip44.json
      return function (require, module, exports) {
module.exports={
  "0": {
    "index": "0",
    "hex": "0x80000000",
    "symbol": "BTC",
    "name": "Bitcoin"
  },
  "1": {
    "index": "1",
    "hex": "0x80000001",
    "symbol": "",
    "name": "Testnet (all coins)"
  },
  "2": {
    "index": "2",
    "hex": "0x80000002",
    "symbol": "LTC",
    "name": "Litecoin"
  },
  "3": {
    "index": "3",
    "hex": "0x80000003",
    "symbol": "DOGE",
    "name": "Dogecoin"
  },
  "4": {
    "index": "4",
    "hex": "0x80000004",
    "symbol": "RDD",
    "name": "Reddcoin"
  },
  "5": {
    "index": "5",
    "hex": "0x80000005",
    "symbol": "DASH",
    "name": "Dash"
  },
  "6": {
    "index": "6",
    "hex": "0x80000006",
    "symbol": "PPC",
    "name": "Peercoin"
  },
  "7": {
    "index": "7",
    "hex": "0x80000007",
    "symbol": "NMC",
    "name": "Namecoin"
  },
  "8": {
    "index": "8",
    "hex": "0x80000008",
    "symbol": "FTC",
    "name": "Feathercoin"
  },
  "9": {
    "index": "9",
    "hex": "0x80000009",
    "symbol": "XCP",
    "name": "Counterparty"
  },
  "10": {
    "index": "10",
    "hex": "0x8000000a",
    "symbol": "BLK",
    "name": "Blackcoin"
  },
  "11": {
    "index": "11",
    "hex": "0x8000000b",
    "symbol": "NSR",
    "name": "NuShares"
  },
  "12": {
    "index": "12",
    "hex": "0x8000000c",
    "symbol": "NBT",
    "name": "NuBits"
  },
  "13": {
    "index": "13",
    "hex": "0x8000000d",
    "symbol": "MZC",
    "name": "Mazacoin"
  },
  "14": {
    "index": "14",
    "hex": "0x8000000e",
    "symbol": "VIA",
    "name": "Viacoin"
  },
  "15": {
    "index": "15",
    "hex": "0x8000000f",
    "symbol": "XCH",
    "name": "ClearingHouse"
  },
  "16": {
    "index": "16",
    "hex": "0x80000010",
    "symbol": "RBY",
    "name": "Rubycoin"
  },
  "17": {
    "index": "17",
    "hex": "0x80000011",
    "symbol": "GRS",
    "name": "Groestlcoin"
  },
  "18": {
    "index": "18",
    "hex": "0x80000012",
    "symbol": "DGC",
    "name": "Digitalcoin"
  },
  "19": {
    "index": "19",
    "hex": "0x80000013",
    "symbol": "CCN",
    "name": "Cannacoin"
  },
  "20": {
    "index": "20",
    "hex": "0x80000014",
    "symbol": "DGB",
    "name": "DigiByte"
  },
  "21": {
    "index": "21",
    "hex": "0x80000015",
    "symbol": "",
    "name": "Open Assets"
  },
  "22": {
    "index": "22",
    "hex": "0x80000016",
    "symbol": "MONA",
    "name": "Monacoin"
  },
  "23": {
    "index": "23",
    "hex": "0x80000017",
    "symbol": "CLAM",
    "name": "Clams"
  },
  "24": {
    "index": "24",
    "hex": "0x80000018",
    "symbol": "XPM",
    "name": "Primecoin"
  },
  "25": {
    "index": "25",
    "hex": "0x80000019",
    "symbol": "NEOS",
    "name": "Neoscoin"
  },
  "26": {
    "index": "26",
    "hex": "0x8000001a",
    "symbol": "JBS",
    "name": "Jumbucks"
  },
  "27": {
    "index": "27",
    "hex": "0x8000001b",
    "symbol": "ZRC",
    "name": "ziftrCOIN"
  },
  "28": {
    "index": "28",
    "hex": "0x8000001c",
    "symbol": "VTC",
    "name": "Vertcoin"
  },
  "29": {
    "index": "29",
    "hex": "0x8000001d",
    "symbol": "NXT",
    "name": "NXT"
  },
  "30": {
    "index": "30",
    "hex": "0x8000001e",
    "symbol": "BURST",
    "name": "Burst"
  },
  "31": {
    "index": "31",
    "hex": "0x8000001f",
    "symbol": "MUE",
    "name": "MonetaryUnit"
  },
  "32": {
    "index": "32",
    "hex": "0x80000020",
    "symbol": "ZOOM",
    "name": "Zoom"
  },
  "33": {
    "index": "33",
    "hex": "0x80000021",
    "symbol": "VASH",
    "name": "Virtual Cash"
  },
  "34": {
    "index": "34",
    "hex": "0x80000022",
    "symbol": "CDN",
    "name": "Canada eCoin"
  },
  "35": {
    "index": "35",
    "hex": "0x80000023",
    "symbol": "SDC",
    "name": "ShadowCash"
  },
  "36": {
    "index": "36",
    "hex": "0x80000024",
    "symbol": "PKB",
    "name": "ParkByte"
  },
  "37": {
    "index": "37",
    "hex": "0x80000025",
    "symbol": "PND",
    "name": "Pandacoin"
  },
  "38": {
    "index": "38",
    "hex": "0x80000026",
    "symbol": "START",
    "name": "StartCOIN"
  },
  "39": {
    "index": "39",
    "hex": "0x80000027",
    "symbol": "MOIN",
    "name": "MOIN"
  },
  "40": {
    "index": "40",
    "hex": "0x80000028",
    "symbol": "EXP",
    "name": "Expanse"
  },
  "41": {
    "index": "41",
    "hex": "0x80000029",
    "symbol": "EMC2",
    "name": "Einsteinium"
  },
  "42": {
    "index": "42",
    "hex": "0x8000002a",
    "symbol": "DCR",
    "name": "Decred"
  },
  "43": {
    "index": "43",
    "hex": "0x8000002b",
    "symbol": "XEM",
    "name": "NEM"
  },
  "44": {
    "index": "44",
    "hex": "0x8000002c",
    "symbol": "PART",
    "name": "Particl"
  },
  "45": {
    "index": "45",
    "hex": "0x8000002d",
    "symbol": "ARG",
    "name": "Argentum (dead)"
  },
  "46": {
    "index": "46",
    "hex": "0x8000002e",
    "symbol": "",
    "name": "Libertas"
  },
  "47": {
    "index": "47",
    "hex": "0x8000002f",
    "symbol": "",
    "name": "Posw coin"
  },
  "48": {
    "index": "48",
    "hex": "0x80000030",
    "symbol": "SHR",
    "name": "Shreeji"
  },
  "49": {
    "index": "49",
    "hex": "0x80000031",
    "symbol": "GCR",
    "name": "Global Currency Reserve (GCRcoin)"
  },
  "50": {
    "index": "50",
    "hex": "0x80000032",
    "symbol": "NVC",
    "name": "Novacoin"
  },
  "51": {
    "index": "51",
    "hex": "0x80000033",
    "symbol": "AC",
    "name": "Asiacoin"
  },
  "52": {
    "index": "52",
    "hex": "0x80000034",
    "symbol": "BTCD",
    "name": "BitcoinDark"
  },
  "53": {
    "index": "53",
    "hex": "0x80000035",
    "symbol": "DOPE",
    "name": "Dopecoin"
  },
  "54": {
    "index": "54",
    "hex": "0x80000036",
    "symbol": "TPC",
    "name": "Templecoin"
  },
  "55": {
    "index": "55",
    "hex": "0x80000037",
    "symbol": "AIB",
    "name": "AIB"
  },
  "56": {
    "index": "56",
    "hex": "0x80000038",
    "symbol": "EDRC",
    "name": "EDRCoin"
  },
  "57": {
    "index": "57",
    "hex": "0x80000039",
    "symbol": "SYS",
    "name": "Syscoin"
  },
  "58": {
    "index": "58",
    "hex": "0x8000003a",
    "symbol": "SLR",
    "name": "Solarcoin"
  },
  "59": {
    "index": "59",
    "hex": "0x8000003b",
    "symbol": "SMLY",
    "name": "Smileycoin"
  },
  "60": {
    "index": "60",
    "hex": "0x8000003c",
    "symbol": "ETH",
    "name": "Ethereum"
  },
  "61": {
    "index": "61",
    "hex": "0x8000003d",
    "symbol": "ETC",
    "name": "Ether Classic"
  },
  "62": {
    "index": "62",
    "hex": "0x8000003e",
    "symbol": "PSB",
    "name": "Pesobit"
  },
  "63": {
    "index": "63",
    "hex": "0x8000003f",
    "symbol": "LDCN",
    "name": "Landcoin (dead)"
  },
  "64": {
    "index": "64",
    "hex": "0x80000040",
    "symbol": "",
    "name": "Open Chain"
  },
  "65": {
    "index": "65",
    "hex": "0x80000041",
    "symbol": "XBC",
    "name": "Bitcoinplus"
  },
  "66": {
    "index": "66",
    "hex": "0x80000042",
    "symbol": "IOP",
    "name": "Internet of People"
  },
  "67": {
    "index": "67",
    "hex": "0x80000043",
    "symbol": "NXS",
    "name": "Nexus"
  },
  "68": {
    "index": "68",
    "hex": "0x80000044",
    "symbol": "INSN",
    "name": "InsaneCoin"
  },
  "69": {
    "index": "69",
    "hex": "0x80000045",
    "symbol": "OK",
    "name": "OKCash"
  },
  "70": {
    "index": "70",
    "hex": "0x80000046",
    "symbol": "BRIT",
    "name": "BritCoin"
  },
  "71": {
    "index": "71",
    "hex": "0x80000047",
    "symbol": "CMP",
    "name": "Compcoin"
  },
  "72": {
    "index": "72",
    "hex": "0x80000048",
    "symbol": "CRW",
    "name": "Crown"
  },
  "73": {
    "index": "73",
    "hex": "0x80000049",
    "symbol": "BELA",
    "name": "BelaCoin"
  },
  "74": {
    "index": "74",
    "hex": "0x8000004a",
    "symbol": "ICX",
    "name": "ICON"
  },
  "75": {
    "index": "75",
    "hex": "0x8000004b",
    "symbol": "FJC",
    "name": "FujiCoin"
  },
  "76": {
    "index": "76",
    "hex": "0x8000004c",
    "symbol": "MIX",
    "name": "MIX"
  },
  "77": {
    "index": "77",
    "hex": "0x8000004d",
    "symbol": "XVG",
    "name": "Verge Currency"
  },
  "78": {
    "index": "78",
    "hex": "0x8000004e",
    "symbol": "EFL",
    "name": "Electronic Gulden"
  },
  "79": {
    "index": "79",
    "hex": "0x8000004f",
    "symbol": "CLUB",
    "name": "ClubCoin"
  },
  "80": {
    "index": "80",
    "hex": "0x80000050",
    "symbol": "RICHX",
    "name": "RichCoin"
  },
  "81": {
    "index": "81",
    "hex": "0x80000051",
    "symbol": "POT",
    "name": "Potcoin"
  },
  "82": {
    "index": "82",
    "hex": "0x80000052",
    "symbol": "QRK",
    "name": "Quarkcoin"
  },
  "83": {
    "index": "83",
    "hex": "0x80000053",
    "symbol": "TRC",
    "name": "Terracoin"
  },
  "84": {
    "index": "84",
    "hex": "0x80000054",
    "symbol": "GRC",
    "name": "Gridcoin"
  },
  "85": {
    "index": "85",
    "hex": "0x80000055",
    "symbol": "AUR",
    "name": "Auroracoin"
  },
  "86": {
    "index": "86",
    "hex": "0x80000056",
    "symbol": "IXC",
    "name": "IXCoin"
  },
  "87": {
    "index": "87",
    "hex": "0x80000057",
    "symbol": "NLG",
    "name": "Gulden"
  },
  "88": {
    "index": "88",
    "hex": "0x80000058",
    "symbol": "BITB",
    "name": "BitBean"
  },
  "89": {
    "index": "89",
    "hex": "0x80000059",
    "symbol": "BTA",
    "name": "Bata"
  },
  "90": {
    "index": "90",
    "hex": "0x8000005a",
    "symbol": "XMY",
    "name": "Myriadcoin"
  },
  "91": {
    "index": "91",
    "hex": "0x8000005b",
    "symbol": "BSD",
    "name": "BitSend"
  },
  "92": {
    "index": "92",
    "hex": "0x8000005c",
    "symbol": "UNO",
    "name": "Unobtanium"
  },
  "93": {
    "index": "93",
    "hex": "0x8000005d",
    "symbol": "MTR",
    "name": "MasterTrader"
  },
  "94": {
    "index": "94",
    "hex": "0x8000005e",
    "symbol": "GB",
    "name": "GoldBlocks"
  },
  "95": {
    "index": "95",
    "hex": "0x8000005f",
    "symbol": "SHM",
    "name": "Saham"
  },
  "96": {
    "index": "96",
    "hex": "0x80000060",
    "symbol": "CRX",
    "name": "Chronos"
  },
  "97": {
    "index": "97",
    "hex": "0x80000061",
    "symbol": "BIQ",
    "name": "Ubiquoin"
  },
  "98": {
    "index": "98",
    "hex": "0x80000062",
    "symbol": "EVO",
    "name": "Evotion"
  },
  "99": {
    "index": "99",
    "hex": "0x80000063",
    "symbol": "STO",
    "name": "SaveTheOcean"
  },
  "100": {
    "index": "100",
    "hex": "0x80000064",
    "symbol": "BIGUP",
    "name": "BigUp"
  },
  "101": {
    "index": "101",
    "hex": "0x80000065",
    "symbol": "GAME",
    "name": "GameCredits"
  },
  "102": {
    "index": "102",
    "hex": "0x80000066",
    "symbol": "DLC",
    "name": "Dollarcoins"
  },
  "103": {
    "index": "103",
    "hex": "0x80000067",
    "symbol": "ZYD",
    "name": "Zayedcoin"
  },
  "104": {
    "index": "104",
    "hex": "0x80000068",
    "symbol": "DBIC",
    "name": "Dubaicoin"
  },
  "105": {
    "index": "105",
    "hex": "0x80000069",
    "symbol": "STRAT",
    "name": "Stratis"
  },
  "106": {
    "index": "106",
    "hex": "0x8000006a",
    "symbol": "SH",
    "name": "Shilling"
  },
  "107": {
    "index": "107",
    "hex": "0x8000006b",
    "symbol": "MARS",
    "name": "MarsCoin"
  },
  "108": {
    "index": "108",
    "hex": "0x8000006c",
    "symbol": "UBQ",
    "name": "Ubiq"
  },
  "109": {
    "index": "109",
    "hex": "0x8000006d",
    "symbol": "PTC",
    "name": "Pesetacoin"
  },
  "110": {
    "index": "110",
    "hex": "0x8000006e",
    "symbol": "NRO",
    "name": "Neurocoin"
  },
  "111": {
    "index": "111",
    "hex": "0x8000006f",
    "symbol": "ARK",
    "name": "ARK"
  },
  "112": {
    "index": "112",
    "hex": "0x80000070",
    "symbol": "USC",
    "name": "UltimateSecureCashMain"
  },
  "113": {
    "index": "113",
    "hex": "0x80000071",
    "symbol": "THC",
    "name": "Hempcoin"
  },
  "114": {
    "index": "114",
    "hex": "0x80000072",
    "symbol": "LINX",
    "name": "Linx"
  },
  "115": {
    "index": "115",
    "hex": "0x80000073",
    "symbol": "ECN",
    "name": "Ecoin"
  },
  "116": {
    "index": "116",
    "hex": "0x80000074",
    "symbol": "DNR",
    "name": "Denarius"
  },
  "117": {
    "index": "117",
    "hex": "0x80000075",
    "symbol": "PINK",
    "name": "Pinkcoin"
  },
  "118": {
    "index": "118",
    "hex": "0x80000076",
    "symbol": "ATOM",
    "name": "Atom"
  },
  "119": {
    "index": "119",
    "hex": "0x80000077",
    "symbol": "PIVX",
    "name": "Pivx"
  },
  "120": {
    "index": "120",
    "hex": "0x80000078",
    "symbol": "FLASH",
    "name": "Flashcoin"
  },
  "121": {
    "index": "121",
    "hex": "0x80000079",
    "symbol": "ZEN",
    "name": "Zencash"
  },
  "122": {
    "index": "122",
    "hex": "0x8000007a",
    "symbol": "PUT",
    "name": "Putincoin"
  },
  "123": {
    "index": "123",
    "hex": "0x8000007b",
    "symbol": "ZNY",
    "name": "BitZeny"
  },
  "124": {
    "index": "124",
    "hex": "0x8000007c",
    "symbol": "UNIFY",
    "name": "Unify"
  },
  "125": {
    "index": "125",
    "hex": "0x8000007d",
    "symbol": "XST",
    "name": "StealthCoin"
  },
  "126": {
    "index": "126",
    "hex": "0x8000007e",
    "symbol": "BRK",
    "name": "Breakout Coin"
  },
  "127": {
    "index": "127",
    "hex": "0x8000007f",
    "symbol": "VC",
    "name": "Vcash"
  },
  "128": {
    "index": "128",
    "hex": "0x80000080",
    "symbol": "XMR",
    "name": "Monero"
  },
  "129": {
    "index": "129",
    "hex": "0x80000081",
    "symbol": "VOX",
    "name": "Voxels"
  },
  "130": {
    "index": "130",
    "hex": "0x80000082",
    "symbol": "NAV",
    "name": "NavCoin"
  },
  "131": {
    "index": "131",
    "hex": "0x80000083",
    "symbol": "FCT",
    "name": "Factom Factoids"
  },
  "132": {
    "index": "132",
    "hex": "0x80000084",
    "symbol": "EC",
    "name": "Factom Entry Credits"
  },
  "133": {
    "index": "133",
    "hex": "0x80000085",
    "symbol": "ZEC",
    "name": "Zcash"
  },
  "134": {
    "index": "134",
    "hex": "0x80000086",
    "symbol": "LSK",
    "name": "Lisk"
  },
  "135": {
    "index": "135",
    "hex": "0x80000087",
    "symbol": "STEEM",
    "name": "Steem"
  },
  "136": {
    "index": "136",
    "hex": "0x80000088",
    "symbol": "XZC",
    "name": "ZCoin"
  },
  "137": {
    "index": "137",
    "hex": "0x80000089",
    "symbol": "RBTC",
    "name": "Rootstock"
  },
  "138": {
    "index": "138",
    "hex": "0x8000008a",
    "symbol": "",
    "name": "Giftblock"
  },
  "139": {
    "index": "139",
    "hex": "0x8000008b",
    "symbol": "RPT",
    "name": "RealPointCoin"
  },
  "140": {
    "index": "140",
    "hex": "0x8000008c",
    "symbol": "LBC",
    "name": "LBRY Credits"
  },
  "141": {
    "index": "141",
    "hex": "0x8000008d",
    "symbol": "KMD",
    "name": "Komodo"
  },
  "142": {
    "index": "142",
    "hex": "0x8000008e",
    "symbol": "BSQ",
    "name": "bisq Token"
  },
  "143": {
    "index": "143",
    "hex": "0x8000008f",
    "symbol": "RIC",
    "name": "Riecoin"
  },
  "144": {
    "index": "144",
    "hex": "0x80000090",
    "symbol": "XRP",
    "name": "XRP"
  },
  "145": {
    "index": "145",
    "hex": "0x80000091",
    "symbol": "BCH",
    "name": "Bitcoin Cash"
  },
  "146": {
    "index": "146",
    "hex": "0x80000092",
    "symbol": "NEBL",
    "name": "Neblio"
  },
  "147": {
    "index": "147",
    "hex": "0x80000093",
    "symbol": "ZCL",
    "name": "ZClassic"
  },
  "148": {
    "index": "148",
    "hex": "0x80000094",
    "symbol": "XLM",
    "name": "Stellar Lumens"
  },
  "149": {
    "index": "149",
    "hex": "0x80000095",
    "symbol": "NLC2",
    "name": "NoLimitCoin2"
  },
  "150": {
    "index": "150",
    "hex": "0x80000096",
    "symbol": "WHL",
    "name": "WhaleCoin"
  },
  "151": {
    "index": "151",
    "hex": "0x80000097",
    "symbol": "ERC",
    "name": "EuropeCoin"
  },
  "152": {
    "index": "152",
    "hex": "0x80000098",
    "symbol": "DMD",
    "name": "Diamond"
  },
  "153": {
    "index": "153",
    "hex": "0x80000099",
    "symbol": "BTM",
    "name": "Bytom"
  },
  "154": {
    "index": "154",
    "hex": "0x8000009a",
    "symbol": "BIO",
    "name": "Biocoin"
  },
  "155": {
    "index": "155",
    "hex": "0x8000009b",
    "symbol": "XWCC",
    "name": "Whitecoin Classic"
  },
  "156": {
    "index": "156",
    "hex": "0x8000009c",
    "symbol": "BTG",
    "name": "Bitcoin Gold"
  },
  "157": {
    "index": "157",
    "hex": "0x8000009d",
    "symbol": "BTC2X",
    "name": "Bitcoin 2x"
  },
  "158": {
    "index": "158",
    "hex": "0x8000009e",
    "symbol": "SSN",
    "name": "SuperSkynet"
  },
  "159": {
    "index": "159",
    "hex": "0x8000009f",
    "symbol": "TOA",
    "name": "TOACoin"
  },
  "160": {
    "index": "160",
    "hex": "0x800000a0",
    "symbol": "BTX",
    "name": "Bitcore"
  },
  "161": {
    "index": "161",
    "hex": "0x800000a1",
    "symbol": "ACC",
    "name": "Adcoin"
  },
  "162": {
    "index": "162",
    "hex": "0x800000a2",
    "symbol": "BCO",
    "name": "Bridgecoin"
  },
  "163": {
    "index": "163",
    "hex": "0x800000a3",
    "symbol": "ELLA",
    "name": "Ellaism"
  },
  "164": {
    "index": "164",
    "hex": "0x800000a4",
    "symbol": "PIRL",
    "name": "Pirl"
  },
  "165": {
    "index": "165",
    "hex": "0x800000a5",
    "symbol": "XNO",
    "name": "Nano"
  },
  "166": {
    "index": "166",
    "hex": "0x800000a6",
    "symbol": "VIVO",
    "name": "Vivo"
  },
  "167": {
    "index": "167",
    "hex": "0x800000a7",
    "symbol": "FRST",
    "name": "Firstcoin"
  },
  "168": {
    "index": "168",
    "hex": "0x800000a8",
    "symbol": "HNC",
    "name": "Helleniccoin"
  },
  "169": {
    "index": "169",
    "hex": "0x800000a9",
    "symbol": "BUZZ",
    "name": "BUZZ"
  },
  "170": {
    "index": "170",
    "hex": "0x800000aa",
    "symbol": "MBRS",
    "name": "Ember"
  },
  "171": {
    "index": "171",
    "hex": "0x800000ab",
    "symbol": "HC",
    "name": "Hcash"
  },
  "172": {
    "index": "172",
    "hex": "0x800000ac",
    "symbol": "HTML",
    "name": "HTMLCOIN"
  },
  "173": {
    "index": "173",
    "hex": "0x800000ad",
    "symbol": "ODN",
    "name": "Obsidian"
  },
  "174": {
    "index": "174",
    "hex": "0x800000ae",
    "symbol": "ONX",
    "name": "OnixCoin"
  },
  "175": {
    "index": "175",
    "hex": "0x800000af",
    "symbol": "RVN",
    "name": "Ravencoin"
  },
  "176": {
    "index": "176",
    "hex": "0x800000b0",
    "symbol": "GBX",
    "name": "GoByte"
  },
  "177": {
    "index": "177",
    "hex": "0x800000b1",
    "symbol": "BTCZ",
    "name": "BitcoinZ"
  },
  "178": {
    "index": "178",
    "hex": "0x800000b2",
    "symbol": "POA",
    "name": "Poa"
  },
  "179": {
    "index": "179",
    "hex": "0x800000b3",
    "symbol": "NYC",
    "name": "NewYorkCoin"
  },
  "180": {
    "index": "180",
    "hex": "0x800000b4",
    "symbol": "MXT",
    "name": "MarteXcoin"
  },
  "181": {
    "index": "181",
    "hex": "0x800000b5",
    "symbol": "WC",
    "name": "Wincoin"
  },
  "182": {
    "index": "182",
    "hex": "0x800000b6",
    "symbol": "MNX",
    "name": "Minexcoin"
  },
  "183": {
    "index": "183",
    "hex": "0x800000b7",
    "symbol": "BTCP",
    "name": "Bitcoin Private"
  },
  "184": {
    "index": "184",
    "hex": "0x800000b8",
    "symbol": "MUSIC",
    "name": "Musicoin"
  },
  "185": {
    "index": "185",
    "hex": "0x800000b9",
    "symbol": "BCA",
    "name": "Bitcoin Atom"
  },
  "186": {
    "index": "186",
    "hex": "0x800000ba",
    "symbol": "CRAVE",
    "name": "Crave"
  },
  "187": {
    "index": "187",
    "hex": "0x800000bb",
    "symbol": "STAK",
    "name": "STRAKS"
  },
  "188": {
    "index": "188",
    "hex": "0x800000bc",
    "symbol": "WBTC",
    "name": "World Bitcoin"
  },
  "189": {
    "index": "189",
    "hex": "0x800000bd",
    "symbol": "LCH",
    "name": "LiteCash"
  },
  "190": {
    "index": "190",
    "hex": "0x800000be",
    "symbol": "EXCL",
    "name": "ExclusiveCoin"
  },
  "191": {
    "index": "191",
    "hex": "0x800000bf",
    "symbol": "LYNX",
    "name": "Lynx"
  },
  "192": {
    "index": "192",
    "hex": "0x800000c0",
    "symbol": "LCC",
    "name": "LitecoinCash"
  },
  "193": {
    "index": "193",
    "hex": "0x800000c1",
    "symbol": "XFE",
    "name": "Feirm"
  },
  "194": {
    "index": "194",
    "hex": "0x800000c2",
    "symbol": "EOS",
    "name": "EOS"
  },
  "195": {
    "index": "195",
    "hex": "0x800000c3",
    "symbol": "TRX",
    "name": "Tron"
  },
  "196": {
    "index": "196",
    "hex": "0x800000c4",
    "symbol": "KOBO",
    "name": "Kobocoin"
  },
  "197": {
    "index": "197",
    "hex": "0x800000c5",
    "symbol": "HUSH",
    "name": "HUSH"
  },
  "198": {
    "index": "198",
    "hex": "0x800000c6",
    "symbol": "BAN",
    "name": "Banano"
  },
  "199": {
    "index": "199",
    "hex": "0x800000c7",
    "symbol": "ETF",
    "name": "ETF"
  },
  "200": {
    "index": "200",
    "hex": "0x800000c8",
    "symbol": "OMNI",
    "name": "Omni"
  },
  "201": {
    "index": "201",
    "hex": "0x800000c9",
    "symbol": "BIFI",
    "name": "BitcoinFile"
  },
  "202": {
    "index": "202",
    "hex": "0x800000ca",
    "symbol": "UFO",
    "name": "Uniform Fiscal Object"
  },
  "203": {
    "index": "203",
    "hex": "0x800000cb",
    "symbol": "CNMC",
    "name": "Cryptonodes"
  },
  "204": {
    "index": "204",
    "hex": "0x800000cc",
    "symbol": "BCN",
    "name": "Bytecoin"
  },
  "205": {
    "index": "205",
    "hex": "0x800000cd",
    "symbol": "RIN",
    "name": "Ringo"
  },
  "206": {
    "index": "206",
    "hex": "0x800000ce",
    "symbol": "ATP",
    "name": "Alaya"
  },
  "207": {
    "index": "207",
    "hex": "0x800000cf",
    "symbol": "EVT",
    "name": "everiToken"
  },
  "208": {
    "index": "208",
    "hex": "0x800000d0",
    "symbol": "ATN",
    "name": "ATN"
  },
  "209": {
    "index": "209",
    "hex": "0x800000d1",
    "symbol": "BIS",
    "name": "Bismuth"
  },
  "210": {
    "index": "210",
    "hex": "0x800000d2",
    "symbol": "NEET",
    "name": "NEETCOIN"
  },
  "211": {
    "index": "211",
    "hex": "0x800000d3",
    "symbol": "BOPO",
    "name": "BopoChain"
  },
  "212": {
    "index": "212",
    "hex": "0x800000d4",
    "symbol": "OOT",
    "name": "Utrum"
  },
  "213": {
    "index": "213",
    "hex": "0x800000d5",
    "symbol": "ALIAS",
    "name": "Alias"
  },
  "214": {
    "index": "214",
    "hex": "0x800000d6",
    "symbol": "MONK",
    "name": "Monkey Project"
  },
  "215": {
    "index": "215",
    "hex": "0x800000d7",
    "symbol": "BOXY",
    "name": "BoxyCoin"
  },
  "216": {
    "index": "216",
    "hex": "0x800000d8",
    "symbol": "FLO",
    "name": "Flo"
  },
  "217": {
    "index": "217",
    "hex": "0x800000d9",
    "symbol": "MEC",
    "name": "Megacoin"
  },
  "218": {
    "index": "218",
    "hex": "0x800000da",
    "symbol": "BTDX",
    "name": "BitCloud"
  },
  "219": {
    "index": "219",
    "hex": "0x800000db",
    "symbol": "XAX",
    "name": "Artax"
  },
  "220": {
    "index": "220",
    "hex": "0x800000dc",
    "symbol": "ANON",
    "name": "ANON"
  },
  "221": {
    "index": "221",
    "hex": "0x800000dd",
    "symbol": "LTZ",
    "name": "LitecoinZ"
  },
  "222": {
    "index": "222",
    "hex": "0x800000de",
    "symbol": "BITG",
    "name": "Bitcoin Green"
  },
  "223": {
    "index": "223",
    "hex": "0x800000df",
    "symbol": "ICP",
    "name": "Internet Computer (DFINITY)"
  },
  "224": {
    "index": "224",
    "hex": "0x800000e0",
    "symbol": "SMART",
    "name": "Smartcash"
  },
  "225": {
    "index": "225",
    "hex": "0x800000e1",
    "symbol": "XUEZ",
    "name": "XUEZ"
  },
  "226": {
    "index": "226",
    "hex": "0x800000e2",
    "symbol": "HLM",
    "name": "Helium"
  },
  "227": {
    "index": "227",
    "hex": "0x800000e3",
    "symbol": "WEB",
    "name": "Webchain"
  },
  "228": {
    "index": "228",
    "hex": "0x800000e4",
    "symbol": "ACM",
    "name": "Actinium"
  },
  "229": {
    "index": "229",
    "hex": "0x800000e5",
    "symbol": "NOS",
    "name": "NOS Stable Coins"
  },
  "230": {
    "index": "230",
    "hex": "0x800000e6",
    "symbol": "BITC",
    "name": "BitCash"
  },
  "231": {
    "index": "231",
    "hex": "0x800000e7",
    "symbol": "HTH",
    "name": "Help The Homeless Coin"
  },
  "232": {
    "index": "232",
    "hex": "0x800000e8",
    "symbol": "TZC",
    "name": "Trezarcoin"
  },
  "233": {
    "index": "233",
    "hex": "0x800000e9",
    "symbol": "VAR",
    "name": "Varda"
  },
  "234": {
    "index": "234",
    "hex": "0x800000ea",
    "symbol": "IOV",
    "name": "IOV"
  },
  "235": {
    "index": "235",
    "hex": "0x800000eb",
    "symbol": "FIO",
    "name": "FIO"
  },
  "236": {
    "index": "236",
    "hex": "0x800000ec",
    "symbol": "BSV",
    "name": "BitcoinSV"
  },
  "237": {
    "index": "237",
    "hex": "0x800000ed",
    "symbol": "DXN",
    "name": "DEXON"
  },
  "238": {
    "index": "238",
    "hex": "0x800000ee",
    "symbol": "QRL",
    "name": "Quantum Resistant Ledger"
  },
  "239": {
    "index": "239",
    "hex": "0x800000ef",
    "symbol": "PCX",
    "name": "ChainX"
  },
  "240": {
    "index": "240",
    "hex": "0x800000f0",
    "symbol": "LOKI",
    "name": "Loki"
  },
  "241": {
    "index": "241",
    "hex": "0x800000f1",
    "symbol": "",
    "name": "Imagewallet"
  },
  "242": {
    "index": "242",
    "hex": "0x800000f2",
    "symbol": "NIM",
    "name": "Nimiq"
  },
  "243": {
    "index": "243",
    "hex": "0x800000f3",
    "symbol": "SOV",
    "name": "Sovereign Coin"
  },
  "244": {
    "index": "244",
    "hex": "0x800000f4",
    "symbol": "JCT",
    "name": "Jibital Coin"
  },
  "245": {
    "index": "245",
    "hex": "0x800000f5",
    "symbol": "SLP",
    "name": "Simple Ledger Protocol"
  },
  "246": {
    "index": "246",
    "hex": "0x800000f6",
    "symbol": "EWT",
    "name": "Energy Web"
  },
  "247": {
    "index": "247",
    "hex": "0x800000f7",
    "symbol": "UC",
    "name": "Ulord"
  },
  "248": {
    "index": "248",
    "hex": "0x800000f8",
    "symbol": "EXOS",
    "name": "EXOS"
  },
  "249": {
    "index": "249",
    "hex": "0x800000f9",
    "symbol": "ECA",
    "name": "Electra"
  },
  "250": {
    "index": "250",
    "hex": "0x800000fa",
    "symbol": "SOOM",
    "name": "Soom"
  },
  "251": {
    "index": "251",
    "hex": "0x800000fb",
    "symbol": "XRD",
    "name": "Redstone"
  },
  "252": {
    "index": "252",
    "hex": "0x800000fc",
    "symbol": "FREE",
    "name": "FreeCoin"
  },
  "253": {
    "index": "253",
    "hex": "0x800000fd",
    "symbol": "NPW",
    "name": "NewPowerCoin"
  },
  "254": {
    "index": "254",
    "hex": "0x800000fe",
    "symbol": "BST",
    "name": "BlockStamp"
  },
  "255": {
    "index": "255",
    "hex": "0x800000ff",
    "symbol": "",
    "name": "SmartHoldem"
  },
  "256": {
    "index": "256",
    "hex": "0x80000100",
    "symbol": "NANO",
    "name": "Bitcoin Nano"
  },
  "257": {
    "index": "257",
    "hex": "0x80000101",
    "symbol": "BTCC",
    "name": "Bitcoin Core"
  },
  "258": {
    "index": "258",
    "hex": "0x80000102",
    "symbol": "",
    "name": "Zen Protocol"
  },
  "259": {
    "index": "259",
    "hex": "0x80000103",
    "symbol": "ZEST",
    "name": "Zest"
  },
  "260": {
    "index": "260",
    "hex": "0x80000104",
    "symbol": "ABT",
    "name": "ArcBlock"
  },
  "261": {
    "index": "261",
    "hex": "0x80000105",
    "symbol": "PION",
    "name": "Pion"
  },
  "262": {
    "index": "262",
    "hex": "0x80000106",
    "symbol": "DT3",
    "name": "DreamTeam3"
  },
  "263": {
    "index": "263",
    "hex": "0x80000107",
    "symbol": "ZBUX",
    "name": "Zbux"
  },
  "264": {
    "index": "264",
    "hex": "0x80000108",
    "symbol": "KPL",
    "name": "Kepler"
  },
  "265": {
    "index": "265",
    "hex": "0x80000109",
    "symbol": "TPAY",
    "name": "TokenPay"
  },
  "266": {
    "index": "266",
    "hex": "0x8000010a",
    "symbol": "ZILLA",
    "name": "ChainZilla"
  },
  "267": {
    "index": "267",
    "hex": "0x8000010b",
    "symbol": "ANK",
    "name": "Anker"
  },
  "268": {
    "index": "268",
    "hex": "0x8000010c",
    "symbol": "BCC",
    "name": "BCChain"
  },
  "269": {
    "index": "269",
    "hex": "0x8000010d",
    "symbol": "HPB",
    "name": "HPB"
  },
  "270": {
    "index": "270",
    "hex": "0x8000010e",
    "symbol": "ONE",
    "name": "ONE"
  },
  "271": {
    "index": "271",
    "hex": "0x8000010f",
    "symbol": "SBC",
    "name": "SBC"
  },
  "272": {
    "index": "272",
    "hex": "0x80000110",
    "symbol": "IPC",
    "name": "IPChain"
  },
  "273": {
    "index": "273",
    "hex": "0x80000111",
    "symbol": "DMTC",
    "name": "Dominantchain"
  },
  "274": {
    "index": "274",
    "hex": "0x80000112",
    "symbol": "OGC",
    "name": "Onegram"
  },
  "275": {
    "index": "275",
    "hex": "0x80000113",
    "symbol": "SHIT",
    "name": "Shitcoin"
  },
  "276": {
    "index": "276",
    "hex": "0x80000114",
    "symbol": "ANDES",
    "name": "Andescoin"
  },
  "277": {
    "index": "277",
    "hex": "0x80000115",
    "symbol": "AREPA",
    "name": "Arepacoin"
  },
  "278": {
    "index": "278",
    "hex": "0x80000116",
    "symbol": "BOLI",
    "name": "Bolivarcoin"
  },
  "279": {
    "index": "279",
    "hex": "0x80000117",
    "symbol": "RIL",
    "name": "Rilcoin"
  },
  "280": {
    "index": "280",
    "hex": "0x80000118",
    "symbol": "HTR",
    "name": "Hathor Network"
  },
  "281": {
    "index": "281",
    "hex": "0x80000119",
    "symbol": "ACME",
    "name": "Accumulate"
  },
  "282": {
    "index": "282",
    "hex": "0x8000011a",
    "symbol": "BRAVO",
    "name": "BRAVO"
  },
  "283": {
    "index": "283",
    "hex": "0x8000011b",
    "symbol": "ALGO",
    "name": "Algorand"
  },
  "284": {
    "index": "284",
    "hex": "0x8000011c",
    "symbol": "BZX",
    "name": "Bitcoinzero"
  },
  "285": {
    "index": "285",
    "hex": "0x8000011d",
    "symbol": "GXX",
    "name": "GravityCoin"
  },
  "286": {
    "index": "286",
    "hex": "0x8000011e",
    "symbol": "HEAT",
    "name": "HEAT"
  },
  "287": {
    "index": "287",
    "hex": "0x8000011f",
    "symbol": "XDN",
    "name": "DigitalNote"
  },
  "288": {
    "index": "288",
    "hex": "0x80000120",
    "symbol": "FSN",
    "name": "FUSION"
  },
  "289": {
    "index": "289",
    "hex": "0x80000121",
    "symbol": "CPC",
    "name": "Capricoin"
  },
  "290": {
    "index": "290",
    "hex": "0x80000122",
    "symbol": "BOLD",
    "name": "Bold"
  },
  "291": {
    "index": "291",
    "hex": "0x80000123",
    "symbol": "IOST",
    "name": "IOST"
  },
  "292": {
    "index": "292",
    "hex": "0x80000124",
    "symbol": "TKEY",
    "name": "Tkeycoin"
  },
  "293": {
    "index": "293",
    "hex": "0x80000125",
    "symbol": "USE",
    "name": "Usechain"
  },
  "294": {
    "index": "294",
    "hex": "0x80000126",
    "symbol": "BCZ",
    "name": "BitcoinCZ"
  },
  "295": {
    "index": "295",
    "hex": "0x80000127",
    "symbol": "IOC",
    "name": "Iocoin"
  },
  "296": {
    "index": "296",
    "hex": "0x80000128",
    "symbol": "ASF",
    "name": "Asofe"
  },
  "297": {
    "index": "297",
    "hex": "0x80000129",
    "symbol": "MASS",
    "name": "MASS"
  },
  "298": {
    "index": "298",
    "hex": "0x8000012a",
    "symbol": "FAIR",
    "name": "FairCoin"
  },
  "299": {
    "index": "299",
    "hex": "0x8000012b",
    "symbol": "NUKO",
    "name": "Nekonium"
  },
  "300": {
    "index": "300",
    "hex": "0x8000012c",
    "symbol": "GNX",
    "name": "Genaro Network"
  },
  "301": {
    "index": "301",
    "hex": "0x8000012d",
    "symbol": "DIVI",
    "name": "Divi Project"
  },
  "302": {
    "index": "302",
    "hex": "0x8000012e",
    "symbol": "CMT",
    "name": "Community"
  },
  "303": {
    "index": "303",
    "hex": "0x8000012f",
    "symbol": "EUNO",
    "name": "EUNO"
  },
  "304": {
    "index": "304",
    "hex": "0x80000130",
    "symbol": "IOTX",
    "name": "IoTeX"
  },
  "305": {
    "index": "305",
    "hex": "0x80000131",
    "symbol": "ONION",
    "name": "DeepOnion"
  },
  "306": {
    "index": "306",
    "hex": "0x80000132",
    "symbol": "8BIT",
    "name": "8Bit"
  },
  "307": {
    "index": "307",
    "hex": "0x80000133",
    "symbol": "ATC",
    "name": "AToken Coin"
  },
  "308": {
    "index": "308",
    "hex": "0x80000134",
    "symbol": "BTS",
    "name": "Bitshares"
  },
  "309": {
    "index": "309",
    "hex": "0x80000135",
    "symbol": "CKB",
    "name": "Nervos CKB"
  },
  "310": {
    "index": "310",
    "hex": "0x80000136",
    "symbol": "UGAS",
    "name": "Ultrain"
  },
  "311": {
    "index": "311",
    "hex": "0x80000137",
    "symbol": "ADS",
    "name": "Adshares"
  },
  "312": {
    "index": "312",
    "hex": "0x80000138",
    "symbol": "ARA",
    "name": "Aura"
  },
  "313": {
    "index": "313",
    "hex": "0x80000139",
    "symbol": "ZIL",
    "name": "Zilliqa"
  },
  "314": {
    "index": "314",
    "hex": "0x8000013a",
    "symbol": "MOAC",
    "name": "MOAC"
  },
  "315": {
    "index": "315",
    "hex": "0x8000013b",
    "symbol": "SWTC",
    "name": "SWTC"
  },
  "316": {
    "index": "316",
    "hex": "0x8000013c",
    "symbol": "VNSC",
    "name": "vnscoin"
  },
  "317": {
    "index": "317",
    "hex": "0x8000013d",
    "symbol": "PLUG",
    "name": "Pl^g"
  },
  "318": {
    "index": "318",
    "hex": "0x8000013e",
    "symbol": "MAN",
    "name": "Matrix AI Network"
  },
  "319": {
    "index": "319",
    "hex": "0x8000013f",
    "symbol": "ECC",
    "name": "ECCoin"
  },
  "320": {
    "index": "320",
    "hex": "0x80000140",
    "symbol": "RPD",
    "name": "Rapids"
  },
  "321": {
    "index": "321",
    "hex": "0x80000141",
    "symbol": "RAP",
    "name": "Rapture"
  },
  "322": {
    "index": "322",
    "hex": "0x80000142",
    "symbol": "GARD",
    "name": "Hashgard"
  },
  "323": {
    "index": "323",
    "hex": "0x80000143",
    "symbol": "ZER",
    "name": "Zero"
  },
  "324": {
    "index": "324",
    "hex": "0x80000144",
    "symbol": "EBST",
    "name": "eBoost"
  },
  "325": {
    "index": "325",
    "hex": "0x80000145",
    "symbol": "SHARD",
    "name": "Shard"
  },
  "326": {
    "index": "326",
    "hex": "0x80000146",
    "symbol": "MRX",
    "name": "Metrix Coin"
  },
  "327": {
    "index": "327",
    "hex": "0x80000147",
    "symbol": "CMM",
    "name": "Commercium"
  },
  "328": {
    "index": "328",
    "hex": "0x80000148",
    "symbol": "BLOCK",
    "name": "Blocknet"
  },
  "329": {
    "index": "329",
    "hex": "0x80000149",
    "symbol": "AUDAX",
    "name": "AUDAX"
  },
  "330": {
    "index": "330",
    "hex": "0x8000014a",
    "symbol": "LUNA",
    "name": "Terra"
  },
  "331": {
    "index": "331",
    "hex": "0x8000014b",
    "symbol": "ZPM",
    "name": "zPrime"
  },
  "332": {
    "index": "332",
    "hex": "0x8000014c",
    "symbol": "KUVA",
    "name": "Kuva Utility Note"
  },
  "333": {
    "index": "333",
    "hex": "0x8000014d",
    "symbol": "MEM",
    "name": "MemCoin"
  },
  "334": {
    "index": "334",
    "hex": "0x8000014e",
    "symbol": "CS",
    "name": "Credits"
  },
  "335": {
    "index": "335",
    "hex": "0x8000014f",
    "symbol": "SWIFT",
    "name": "SwiftCash"
  },
  "336": {
    "index": "336",
    "hex": "0x80000150",
    "symbol": "FIX",
    "name": "FIX"
  },
  "337": {
    "index": "337",
    "hex": "0x80000151",
    "symbol": "CPC",
    "name": "CPChain"
  },
  "338": {
    "index": "338",
    "hex": "0x80000152",
    "symbol": "VGO",
    "name": "VirtualGoodsToken"
  },
  "339": {
    "index": "339",
    "hex": "0x80000153",
    "symbol": "DVT",
    "name": "DeVault"
  },
  "340": {
    "index": "340",
    "hex": "0x80000154",
    "symbol": "N8V",
    "name": "N8VCoin"
  },
  "341": {
    "index": "341",
    "hex": "0x80000155",
    "symbol": "MTNS",
    "name": "OmotenashiCoin"
  },
  "342": {
    "index": "342",
    "hex": "0x80000156",
    "symbol": "BLAST",
    "name": "BLAST"
  },
  "343": {
    "index": "343",
    "hex": "0x80000157",
    "symbol": "DCT",
    "name": "DECENT"
  },
  "344": {
    "index": "344",
    "hex": "0x80000158",
    "symbol": "AUX",
    "name": "Auxilium"
  },
  "345": {
    "index": "345",
    "hex": "0x80000159",
    "symbol": "USDP",
    "name": "USDP"
  },
  "346": {
    "index": "346",
    "hex": "0x8000015a",
    "symbol": "HTDF",
    "name": "HTDF"
  },
  "347": {
    "index": "347",
    "hex": "0x8000015b",
    "symbol": "YEC",
    "name": "Ycash"
  },
  "348": {
    "index": "348",
    "hex": "0x8000015c",
    "symbol": "QLC",
    "name": "QLC Chain"
  },
  "349": {
    "index": "349",
    "hex": "0x8000015d",
    "symbol": "TEA",
    "name": "Icetea Blockchain"
  },
  "350": {
    "index": "350",
    "hex": "0x8000015e",
    "symbol": "ARW",
    "name": "ArrowChain"
  },
  "351": {
    "index": "351",
    "hex": "0x8000015f",
    "symbol": "MDM",
    "name": "Medium"
  },
  "352": {
    "index": "352",
    "hex": "0x80000160",
    "symbol": "CYB",
    "name": "Cybex"
  },
  "353": {
    "index": "353",
    "hex": "0x80000161",
    "symbol": "LTO",
    "name": "LTO Network"
  },
  "354": {
    "index": "354",
    "hex": "0x80000162",
    "symbol": "DOT",
    "name": "Polkadot"
  },
  "355": {
    "index": "355",
    "hex": "0x80000163",
    "symbol": "AEON",
    "name": "Aeon"
  },
  "356": {
    "index": "356",
    "hex": "0x80000164",
    "symbol": "RES",
    "name": "Resistance"
  },
  "357": {
    "index": "357",
    "hex": "0x80000165",
    "symbol": "AYA",
    "name": "Aryacoin"
  },
  "358": {
    "index": "358",
    "hex": "0x80000166",
    "symbol": "DAPS",
    "name": "Dapscoin"
  },
  "359": {
    "index": "359",
    "hex": "0x80000167",
    "symbol": "CSC",
    "name": "CasinoCoin"
  },
  "360": {
    "index": "360",
    "hex": "0x80000168",
    "symbol": "VSYS",
    "name": "V Systems"
  },
  "361": {
    "index": "361",
    "hex": "0x80000169",
    "symbol": "NOLLAR",
    "name": "Nollar"
  },
  "362": {
    "index": "362",
    "hex": "0x8000016a",
    "symbol": "XNOS",
    "name": "NOS"
  },
  "363": {
    "index": "363",
    "hex": "0x8000016b",
    "symbol": "CPU",
    "name": "CPUchain"
  },
  "364": {
    "index": "364",
    "hex": "0x8000016c",
    "symbol": "LAMB",
    "name": "Lambda Storage Chain"
  },
  "365": {
    "index": "365",
    "hex": "0x8000016d",
    "symbol": "VCT",
    "name": "ValueCyber"
  },
  "366": {
    "index": "366",
    "hex": "0x8000016e",
    "symbol": "CZR",
    "name": "Canonchain"
  },
  "367": {
    "index": "367",
    "hex": "0x8000016f",
    "symbol": "ABBC",
    "name": "ABBC"
  },
  "368": {
    "index": "368",
    "hex": "0x80000170",
    "symbol": "HET",
    "name": "HET"
  },
  "369": {
    "index": "369",
    "hex": "0x80000171",
    "symbol": "XAS",
    "name": "Asch"
  },
  "370": {
    "index": "370",
    "hex": "0x80000172",
    "symbol": "VDL",
    "name": "Vidulum"
  },
  "371": {
    "index": "371",
    "hex": "0x80000173",
    "symbol": "MED",
    "name": "MediBloc"
  },
  "372": {
    "index": "372",
    "hex": "0x80000174",
    "symbol": "ZVC",
    "name": "ZVChain"
  },
  "373": {
    "index": "373",
    "hex": "0x80000175",
    "symbol": "VESTX",
    "name": "Vestx"
  },
  "374": {
    "index": "374",
    "hex": "0x80000176",
    "symbol": "DBT",
    "name": "DarkBit"
  },
  "375": {
    "index": "375",
    "hex": "0x80000177",
    "symbol": "SEOS",
    "name": "SuperEOS"
  },
  "376": {
    "index": "376",
    "hex": "0x80000178",
    "symbol": "MXW",
    "name": "Maxonrow"
  },
  "377": {
    "index": "377",
    "hex": "0x80000179",
    "symbol": "ZNZ",
    "name": "ZENZO"
  },
  "378": {
    "index": "378",
    "hex": "0x8000017a",
    "symbol": "XCX",
    "name": "XChain"
  },
  "379": {
    "index": "379",
    "hex": "0x8000017b",
    "symbol": "SOX",
    "name": "SonicX"
  },
  "380": {
    "index": "380",
    "hex": "0x8000017c",
    "symbol": "NYZO",
    "name": "Nyzo"
  },
  "381": {
    "index": "381",
    "hex": "0x8000017d",
    "symbol": "ULC",
    "name": "ULCoin"
  },
  "382": {
    "index": "382",
    "hex": "0x8000017e",
    "symbol": "RYO",
    "name": "Ryo Currency"
  },
  "383": {
    "index": "383",
    "hex": "0x8000017f",
    "symbol": "KAL",
    "name": "Kaleidochain"
  },
  "384": {
    "index": "384",
    "hex": "0x80000180",
    "symbol": "XSN",
    "name": "Stakenet"
  },
  "385": {
    "index": "385",
    "hex": "0x80000181",
    "symbol": "DOGEC",
    "name": "DogeCash"
  },
  "386": {
    "index": "386",
    "hex": "0x80000182",
    "symbol": "BMV",
    "name": "Bitcoin Matteo's Vision"
  },
  "387": {
    "index": "387",
    "hex": "0x80000183",
    "symbol": "QBC",
    "name": "Quebecoin"
  },
  "388": {
    "index": "388",
    "hex": "0x80000184",
    "symbol": "IMG",
    "name": "ImageCoin"
  },
  "389": {
    "index": "389",
    "hex": "0x80000185",
    "symbol": "QOS",
    "name": "QOS"
  },
  "390": {
    "index": "390",
    "hex": "0x80000186",
    "symbol": "PKT",
    "name": "PKT"
  },
  "391": {
    "index": "391",
    "hex": "0x80000187",
    "symbol": "LHD",
    "name": "LitecoinHD"
  },
  "392": {
    "index": "392",
    "hex": "0x80000188",
    "symbol": "CENNZ",
    "name": "CENNZnet"
  },
  "393": {
    "index": "393",
    "hex": "0x80000189",
    "symbol": "HSN",
    "name": "Hyper Speed Network"
  },
  "394": {
    "index": "394",
    "hex": "0x8000018a",
    "symbol": "CRO",
    "name": "Crypto Chain"
  },
  "395": {
    "index": "395",
    "hex": "0x8000018b",
    "symbol": "UMBRU",
    "name": "Umbru"
  },
  "396": {
    "index": "396",
    "hex": "0x8000018c",
    "symbol": "EVER",
    "name": "Everscale"
  },
  "397": {
    "index": "397",
    "hex": "0x8000018d",
    "symbol": "NEAR",
    "name": "NEAR Protocol"
  },
  "398": {
    "index": "398",
    "hex": "0x8000018e",
    "symbol": "XPC",
    "name": "XPChain"
  },
  "399": {
    "index": "399",
    "hex": "0x8000018f",
    "symbol": "ZOC",
    "name": "01coin"
  },
  "400": {
    "index": "400",
    "hex": "0x80000190",
    "symbol": "NIX",
    "name": "NIX"
  },
  "401": {
    "index": "401",
    "hex": "0x80000191",
    "symbol": "UC",
    "name": "Utopiacoin"
  },
  "402": {
    "index": "402",
    "hex": "0x80000192",
    "symbol": "GALI",
    "name": "Galilel"
  },
  "403": {
    "index": "403",
    "hex": "0x80000193",
    "symbol": "OLT",
    "name": "Oneledger"
  },
  "404": {
    "index": "404",
    "hex": "0x80000194",
    "symbol": "XBI",
    "name": "XBI"
  },
  "405": {
    "index": "405",
    "hex": "0x80000195",
    "symbol": "DONU",
    "name": "DONU"
  },
  "406": {
    "index": "406",
    "hex": "0x80000196",
    "symbol": "EARTHS",
    "name": "Earths"
  },
  "407": {
    "index": "407",
    "hex": "0x80000197",
    "symbol": "HDD",
    "name": "HDDCash"
  },
  "408": {
    "index": "408",
    "hex": "0x80000198",
    "symbol": "SUGAR",
    "name": "Sugarchain"
  },
  "409": {
    "index": "409",
    "hex": "0x80000199",
    "symbol": "AILE",
    "name": "AileCoin"
  },
  "410": {
    "index": "410",
    "hex": "0x8000019a",
    "symbol": "TENT",
    "name": "TENT"
  },
  "411": {
    "index": "411",
    "hex": "0x8000019b",
    "symbol": "TAN",
    "name": "Tangerine Network"
  },
  "412": {
    "index": "412",
    "hex": "0x8000019c",
    "symbol": "AIN",
    "name": "AIN"
  },
  "413": {
    "index": "413",
    "hex": "0x8000019d",
    "symbol": "MSR",
    "name": "Masari"
  },
  "414": {
    "index": "414",
    "hex": "0x8000019e",
    "symbol": "SUMO",
    "name": "Sumokoin"
  },
  "415": {
    "index": "415",
    "hex": "0x8000019f",
    "symbol": "ETN",
    "name": "Electroneum"
  },
  "416": {
    "index": "416",
    "hex": "0x800001a0",
    "symbol": "BYTZ",
    "name": "BYTZ"
  },
  "417": {
    "index": "417",
    "hex": "0x800001a1",
    "symbol": "WOW",
    "name": "Wownero"
  },
  "418": {
    "index": "418",
    "hex": "0x800001a2",
    "symbol": "XTNC",
    "name": "XtendCash"
  },
  "419": {
    "index": "419",
    "hex": "0x800001a3",
    "symbol": "LTHN",
    "name": "Lethean"
  },
  "420": {
    "index": "420",
    "hex": "0x800001a4",
    "symbol": "NODE",
    "name": "NodeHost"
  },
  "421": {
    "index": "421",
    "hex": "0x800001a5",
    "symbol": "AGM",
    "name": "Argoneum"
  },
  "422": {
    "index": "422",
    "hex": "0x800001a6",
    "symbol": "CCX",
    "name": "Conceal Network"
  },
  "423": {
    "index": "423",
    "hex": "0x800001a7",
    "symbol": "TNET",
    "name": "Title Network"
  },
  "424": {
    "index": "424",
    "hex": "0x800001a8",
    "symbol": "TELOS",
    "name": "TelosCoin"
  },
  "425": {
    "index": "425",
    "hex": "0x800001a9",
    "symbol": "AION",
    "name": "Aion"
  },
  "426": {
    "index": "426",
    "hex": "0x800001aa",
    "symbol": "BC",
    "name": "Bitcoin Confidential"
  },
  "427": {
    "index": "427",
    "hex": "0x800001ab",
    "symbol": "KTV",
    "name": "KmushiCoin"
  },
  "428": {
    "index": "428",
    "hex": "0x800001ac",
    "symbol": "ZCR",
    "name": "ZCore"
  },
  "429": {
    "index": "429",
    "hex": "0x800001ad",
    "symbol": "ERG",
    "name": "Ergo"
  },
  "430": {
    "index": "430",
    "hex": "0x800001ae",
    "symbol": "PESO",
    "name": "Criptopeso"
  },
  "431": {
    "index": "431",
    "hex": "0x800001af",
    "symbol": "BTC2",
    "name": "Bitcoin 2"
  },
  "432": {
    "index": "432",
    "hex": "0x800001b0",
    "symbol": "XRPHD",
    "name": "XRPHD"
  },
  "433": {
    "index": "433",
    "hex": "0x800001b1",
    "symbol": "WE",
    "name": "WE Coin"
  },
  "434": {
    "index": "434",
    "hex": "0x800001b2",
    "symbol": "KSM",
    "name": "Kusama"
  },
  "435": {
    "index": "435",
    "hex": "0x800001b3",
    "symbol": "PCN",
    "name": "Peepcoin"
  },
  "436": {
    "index": "436",
    "hex": "0x800001b4",
    "symbol": "NCH",
    "name": "NetCloth"
  },
  "437": {
    "index": "437",
    "hex": "0x800001b5",
    "symbol": "ICU",
    "name": "CHIPO"
  },
  "438": {
    "index": "438",
    "hex": "0x800001b6",
    "symbol": "FNSA",
    "name": "FINSCHIA"
  },
  "439": {
    "index": "439",
    "hex": "0x800001b7",
    "symbol": "DTP",
    "name": "DeVault Token Protocol"
  },
  "440": {
    "index": "440",
    "hex": "0x800001b8",
    "symbol": "BTCR",
    "name": "Bitcoin Royale"
  },
  "441": {
    "index": "441",
    "hex": "0x800001b9",
    "symbol": "AERGO",
    "name": "AERGO"
  },
  "442": {
    "index": "442",
    "hex": "0x800001ba",
    "symbol": "XTH",
    "name": "Dothereum"
  },
  "443": {
    "index": "443",
    "hex": "0x800001bb",
    "symbol": "LV",
    "name": "Lava"
  },
  "444": {
    "index": "444",
    "hex": "0x800001bc",
    "symbol": "PHR",
    "name": "Phore"
  },
  "445": {
    "index": "445",
    "hex": "0x800001bd",
    "symbol": "VITAE",
    "name": "Vitae"
  },
  "446": {
    "index": "446",
    "hex": "0x800001be",
    "symbol": "COCOS",
    "name": "Cocos-BCX"
  },
  "447": {
    "index": "447",
    "hex": "0x800001bf",
    "symbol": "DIN",
    "name": "Dinero"
  },
  "448": {
    "index": "448",
    "hex": "0x800001c0",
    "symbol": "SPL",
    "name": "Simplicity"
  },
  "449": {
    "index": "449",
    "hex": "0x800001c1",
    "symbol": "YCE",
    "name": "MYCE"
  },
  "450": {
    "index": "450",
    "hex": "0x800001c2",
    "symbol": "XLR",
    "name": "Solaris"
  },
  "451": {
    "index": "451",
    "hex": "0x800001c3",
    "symbol": "KTS",
    "name": "Klimatas"
  },
  "452": {
    "index": "452",
    "hex": "0x800001c4",
    "symbol": "DGLD",
    "name": "DGLD"
  },
  "453": {
    "index": "453",
    "hex": "0x800001c5",
    "symbol": "XNS",
    "name": "Insolar"
  },
  "454": {
    "index": "454",
    "hex": "0x800001c6",
    "symbol": "EM",
    "name": "EMPOW"
  },
  "455": {
    "index": "455",
    "hex": "0x800001c7",
    "symbol": "SHN",
    "name": "ShineBlocks"
  },
  "456": {
    "index": "456",
    "hex": "0x800001c8",
    "symbol": "SEELE",
    "name": "Seele"
  },
  "457": {
    "index": "457",
    "hex": "0x800001c9",
    "symbol": "AE",
    "name": "æternity"
  },
  "458": {
    "index": "458",
    "hex": "0x800001ca",
    "symbol": "ODX",
    "name": "ObsidianX"
  },
  "459": {
    "index": "459",
    "hex": "0x800001cb",
    "symbol": "KAVA",
    "name": "Kava"
  },
  "460": {
    "index": "460",
    "hex": "0x800001cc",
    "symbol": "GLEEC",
    "name": "GLEEC"
  },
  "461": {
    "index": "461",
    "hex": "0x800001cd",
    "symbol": "FIL",
    "name": "Filecoin"
  },
  "462": {
    "index": "462",
    "hex": "0x800001ce",
    "symbol": "RUTA",
    "name": "Rutanio"
  },
  "463": {
    "index": "463",
    "hex": "0x800001cf",
    "symbol": "CSDT",
    "name": "CSDT"
  },
  "464": {
    "index": "464",
    "hex": "0x800001d0",
    "symbol": "ETI",
    "name": "EtherInc"
  },
  "465": {
    "index": "465",
    "hex": "0x800001d1",
    "symbol": "ZSLP",
    "name": "Zclassic Simple Ledger Protocol"
  },
  "466": {
    "index": "466",
    "hex": "0x800001d2",
    "symbol": "ERE",
    "name": "EtherCore"
  },
  "467": {
    "index": "467",
    "hex": "0x800001d3",
    "symbol": "DX",
    "name": "DxChain Token"
  },
  "468": {
    "index": "468",
    "hex": "0x800001d4",
    "symbol": "CPS",
    "name": "Capricoin+"
  },
  "469": {
    "index": "469",
    "hex": "0x800001d5",
    "symbol": "BTH",
    "name": "Bithereum"
  },
  "470": {
    "index": "470",
    "hex": "0x800001d6",
    "symbol": "MESG",
    "name": "MESG"
  },
  "471": {
    "index": "471",
    "hex": "0x800001d7",
    "symbol": "FIMK",
    "name": "FIMK"
  },
  "472": {
    "index": "472",
    "hex": "0x800001d8",
    "symbol": "AR",
    "name": "Arweave"
  },
  "473": {
    "index": "473",
    "hex": "0x800001d9",
    "symbol": "OGO",
    "name": "Origo"
  },
  "474": {
    "index": "474",
    "hex": "0x800001da",
    "symbol": "ROSE",
    "name": "Oasis Network"
  },
  "475": {
    "index": "475",
    "hex": "0x800001db",
    "symbol": "BARE",
    "name": "BARE Network"
  },
  "476": {
    "index": "476",
    "hex": "0x800001dc",
    "symbol": "GLEEC",
    "name": "GleecBTC"
  },
  "477": {
    "index": "477",
    "hex": "0x800001dd",
    "symbol": "CLR",
    "name": "Color Coin"
  },
  "478": {
    "index": "478",
    "hex": "0x800001de",
    "symbol": "RNG",
    "name": "Ring"
  },
  "479": {
    "index": "479",
    "hex": "0x800001df",
    "symbol": "OLO",
    "name": "Tool Global"
  },
  "480": {
    "index": "480",
    "hex": "0x800001e0",
    "symbol": "PEXA",
    "name": "Pexa"
  },
  "481": {
    "index": "481",
    "hex": "0x800001e1",
    "symbol": "MOON",
    "name": "Mooncoin"
  },
  "482": {
    "index": "482",
    "hex": "0x800001e2",
    "symbol": "OCEAN",
    "name": "Ocean Protocol"
  },
  "483": {
    "index": "483",
    "hex": "0x800001e3",
    "symbol": "BNT",
    "name": "Bluzelle Native"
  },
  "484": {
    "index": "484",
    "hex": "0x800001e4",
    "symbol": "AMO",
    "name": "AMO Blockchain"
  },
  "485": {
    "index": "485",
    "hex": "0x800001e5",
    "symbol": "FCH",
    "name": "FreeCash"
  },
  "486": {
    "index": "486",
    "hex": "0x800001e6",
    "symbol": "LAT",
    "name": "PlatON"
  },
  "487": {
    "index": "487",
    "hex": "0x800001e7",
    "symbol": "COIN",
    "name": "Bitcoin Bank"
  },
  "488": {
    "index": "488",
    "hex": "0x800001e8",
    "symbol": "VEO",
    "name": "Amoveo"
  },
  "489": {
    "index": "489",
    "hex": "0x800001e9",
    "symbol": "CCA",
    "name": "Counos Coin"
  },
  "490": {
    "index": "490",
    "hex": "0x800001ea",
    "symbol": "GFN",
    "name": "Graphene"
  },
  "491": {
    "index": "491",
    "hex": "0x800001eb",
    "symbol": "BIP",
    "name": "Minter Network"
  },
  "492": {
    "index": "492",
    "hex": "0x800001ec",
    "symbol": "KPG",
    "name": "Kunpeng Network"
  },
  "493": {
    "index": "493",
    "hex": "0x800001ed",
    "symbol": "FIN",
    "name": "FINL Chain"
  },
  "494": {
    "index": "494",
    "hex": "0x800001ee",
    "symbol": "BAND",
    "name": "Band"
  },
  "495": {
    "index": "495",
    "hex": "0x800001ef",
    "symbol": "DROP",
    "name": "Dropil"
  },
  "496": {
    "index": "496",
    "hex": "0x800001f0",
    "symbol": "BHT",
    "name": "Bluehelix Chain"
  },
  "497": {
    "index": "497",
    "hex": "0x800001f1",
    "symbol": "LYRA",
    "name": "Scrypta"
  },
  "498": {
    "index": "498",
    "hex": "0x800001f2",
    "symbol": "CS",
    "name": "Credits"
  },
  "499": {
    "index": "499",
    "hex": "0x800001f3",
    "symbol": "RUPX",
    "name": "Rupaya"
  },
  "500": {
    "index": "500",
    "hex": "0x800001f4",
    "symbol": "THETA",
    "name": "Theta"
  },
  "501": {
    "index": "501",
    "hex": "0x800001f5",
    "symbol": "SOL",
    "name": "Solana"
  },
  "502": {
    "index": "502",
    "hex": "0x800001f6",
    "symbol": "THT",
    "name": "ThoughtAI"
  },
  "503": {
    "index": "503",
    "hex": "0x800001f7",
    "symbol": "CFX",
    "name": "Conflux"
  },
  "504": {
    "index": "504",
    "hex": "0x800001f8",
    "symbol": "KUMA",
    "name": "Kumacoin"
  },
  "505": {
    "index": "505",
    "hex": "0x800001f9",
    "symbol": "HASH",
    "name": "Provenance"
  },
  "506": {
    "index": "506",
    "hex": "0x800001fa",
    "symbol": "CSPR",
    "name": "Casper"
  },
  "507": {
    "index": "507",
    "hex": "0x800001fb",
    "symbol": "EARTH",
    "name": "EARTH"
  },
  "508": {
    "index": "508",
    "hex": "0x800001fc",
    "symbol": "EGLD",
    "name": "MultiversX"
  },
  "509": {
    "index": "509",
    "hex": "0x800001fd",
    "symbol": "CHI",
    "name": "Xaya"
  },
  "510": {
    "index": "510",
    "hex": "0x800001fe",
    "symbol": "KOTO",
    "name": "Koto"
  },
  "511": {
    "index": "511",
    "hex": "0x800001ff",
    "symbol": "OTC",
    "name": "θ"
  },
  "512": {
    "index": "512",
    "hex": "0x80000200",
    "symbol": "RXD",
    "name": "Radiant"
  },
  "513": {
    "index": "513",
    "hex": "0x80000201",
    "symbol": "SEELEN",
    "name": "Seele-N"
  },
  "514": {
    "index": "514",
    "hex": "0x80000202",
    "symbol": "AETH",
    "name": "AETH"
  },
  "515": {
    "index": "515",
    "hex": "0x80000203",
    "symbol": "DNA",
    "name": "Idena"
  },
  "516": {
    "index": "516",
    "hex": "0x80000204",
    "symbol": "VEE",
    "name": "Virtual Economy Era"
  },
  "517": {
    "index": "517",
    "hex": "0x80000205",
    "symbol": "SIERRA",
    "name": "SierraCoin"
  },
  "518": {
    "index": "518",
    "hex": "0x80000206",
    "symbol": "LET",
    "name": "Linkeye"
  },
  "519": {
    "index": "519",
    "hex": "0x80000207",
    "symbol": "BSC",
    "name": "Bitcoin Smart Contract"
  },
  "520": {
    "index": "520",
    "hex": "0x80000208",
    "symbol": "BTCV",
    "name": "BitcoinVIP"
  },
  "521": {
    "index": "521",
    "hex": "0x80000209",
    "symbol": "ABA",
    "name": "Dabacus"
  },
  "522": {
    "index": "522",
    "hex": "0x8000020a",
    "symbol": "SCC",
    "name": "StakeCubeCoin"
  },
  "523": {
    "index": "523",
    "hex": "0x8000020b",
    "symbol": "EDG",
    "name": "Edgeware"
  },
  "524": {
    "index": "524",
    "hex": "0x8000020c",
    "symbol": "AMS",
    "name": "AmsterdamCoin"
  },
  "525": {
    "index": "525",
    "hex": "0x8000020d",
    "symbol": "GOSS",
    "name": "GOSSIP Coin"
  },
  "526": {
    "index": "526",
    "hex": "0x8000020e",
    "symbol": "BU",
    "name": "BUMO"
  },
  "527": {
    "index": "527",
    "hex": "0x8000020f",
    "symbol": "GRAM",
    "name": "GRAM"
  },
  "528": {
    "index": "528",
    "hex": "0x80000210",
    "symbol": "YAP",
    "name": "Yapstone"
  },
  "529": {
    "index": "529",
    "hex": "0x80000211",
    "symbol": "SCRT",
    "name": "Secret Network"
  },
  "530": {
    "index": "530",
    "hex": "0x80000212",
    "symbol": "NOVO",
    "name": "Novo"
  },
  "531": {
    "index": "531",
    "hex": "0x80000213",
    "symbol": "GHOST",
    "name": "Ghost"
  },
  "532": {
    "index": "532",
    "hex": "0x80000214",
    "symbol": "HST",
    "name": "HST"
  },
  "533": {
    "index": "533",
    "hex": "0x80000215",
    "symbol": "PRJ",
    "name": "ProjectCoin"
  },
  "534": {
    "index": "534",
    "hex": "0x80000216",
    "symbol": "YOU",
    "name": "YOUChain"
  },
  "535": {
    "index": "535",
    "hex": "0x80000217",
    "symbol": "XHV",
    "name": "Haven Protocol"
  },
  "536": {
    "index": "536",
    "hex": "0x80000218",
    "symbol": "BYND",
    "name": "Beyondcoin"
  },
  "537": {
    "index": "537",
    "hex": "0x80000219",
    "symbol": "JOYS",
    "name": "Joys Digital"
  },
  "538": {
    "index": "538",
    "hex": "0x8000021a",
    "symbol": "VAL",
    "name": "Valorbit"
  },
  "539": {
    "index": "539",
    "hex": "0x8000021b",
    "symbol": "FLOW",
    "name": "Flow"
  },
  "540": {
    "index": "540",
    "hex": "0x8000021c",
    "symbol": "SMESH",
    "name": "Spacemesh Coin"
  },
  "541": {
    "index": "541",
    "hex": "0x8000021d",
    "symbol": "SCDO",
    "name": "SCDO"
  },
  "542": {
    "index": "542",
    "hex": "0x8000021e",
    "symbol": "IQS",
    "name": "IQ-Cash"
  },
  "543": {
    "index": "543",
    "hex": "0x8000021f",
    "symbol": "BIND",
    "name": "Compendia"
  },
  "544": {
    "index": "544",
    "hex": "0x80000220",
    "symbol": "COINEVO",
    "name": "Coinevo"
  },
  "545": {
    "index": "545",
    "hex": "0x80000221",
    "symbol": "SCRIBE",
    "name": "Scribe"
  },
  "546": {
    "index": "546",
    "hex": "0x80000222",
    "symbol": "HYN",
    "name": "Hyperion"
  },
  "547": {
    "index": "547",
    "hex": "0x80000223",
    "symbol": "BHP",
    "name": "BHP"
  },
  "548": {
    "index": "548",
    "hex": "0x80000224",
    "symbol": "BBC",
    "name": "BigBang Core"
  },
  "549": {
    "index": "549",
    "hex": "0x80000225",
    "symbol": "MKF",
    "name": "MarketFinance"
  },
  "550": {
    "index": "550",
    "hex": "0x80000226",
    "symbol": "XDC",
    "name": "XinFin"
  },
  "551": {
    "index": "551",
    "hex": "0x80000227",
    "symbol": "STR",
    "name": "Straightedge"
  },
  "552": {
    "index": "552",
    "hex": "0x80000228",
    "symbol": "SUM",
    "name": "Sumcoin"
  },
  "553": {
    "index": "553",
    "hex": "0x80000229",
    "symbol": "HBC",
    "name": "HuobiChain"
  },
  "555": {
    "index": "555",
    "hex": "0x8000022b",
    "symbol": "BCS",
    "name": "Bitcoin Smart"
  },
  "556": {
    "index": "556",
    "hex": "0x8000022c",
    "symbol": "KTS",
    "name": "Kratos"
  },
  "557": {
    "index": "557",
    "hex": "0x8000022d",
    "symbol": "LKR",
    "name": "Lkrcoin"
  },
  "558": {
    "index": "558",
    "hex": "0x8000022e",
    "symbol": "TAO",
    "name": "Tao"
  },
  "559": {
    "index": "559",
    "hex": "0x8000022f",
    "symbol": "XWC",
    "name": "Whitecoin"
  },
  "560": {
    "index": "560",
    "hex": "0x80000230",
    "symbol": "DEAL",
    "name": "DEAL"
  },
  "561": {
    "index": "561",
    "hex": "0x80000231",
    "symbol": "NTY",
    "name": "Nexty"
  },
  "562": {
    "index": "562",
    "hex": "0x80000232",
    "symbol": "TOP",
    "name": "TOP NetWork"
  },
  "564": {
    "index": "564",
    "hex": "0x80000234",
    "symbol": "AG",
    "name": "Agoric"
  },
  "565": {
    "index": "565",
    "hex": "0x80000235",
    "symbol": "CICO",
    "name": "Coinicles"
  },
  "566": {
    "index": "566",
    "hex": "0x80000236",
    "symbol": "IRIS",
    "name": "Irisnet"
  },
  "567": {
    "index": "567",
    "hex": "0x80000237",
    "symbol": "NCG",
    "name": "Nine Chronicles"
  },
  "568": {
    "index": "568",
    "hex": "0x80000238",
    "symbol": "LRG",
    "name": "Large Coin"
  },
  "569": {
    "index": "569",
    "hex": "0x80000239",
    "symbol": "SERO",
    "name": "Super Zero Protocol"
  },
  "570": {
    "index": "570",
    "hex": "0x8000023a",
    "symbol": "BDX",
    "name": "Beldex"
  },
  "571": {
    "index": "571",
    "hex": "0x8000023b",
    "symbol": "CCXX",
    "name": "Counos X"
  },
  "572": {
    "index": "572",
    "hex": "0x8000023c",
    "symbol": "SLS",
    "name": "Saluscoin"
  },
  "573": {
    "index": "573",
    "hex": "0x8000023d",
    "symbol": "SRM",
    "name": "Serum"
  },
  "575": {
    "index": "575",
    "hex": "0x8000023f",
    "symbol": "VIVT",
    "name": "VIDT Datalink"
  },
  "576": {
    "index": "576",
    "hex": "0x80000240",
    "symbol": "BPS",
    "name": "BitcoinPoS"
  },
  "577": {
    "index": "577",
    "hex": "0x80000241",
    "symbol": "NKN",
    "name": "NKN"
  },
  "578": {
    "index": "578",
    "hex": "0x80000242",
    "symbol": "ICL",
    "name": "ILCOIN"
  },
  "579": {
    "index": "579",
    "hex": "0x80000243",
    "symbol": "BONO",
    "name": "Bonorum"
  },
  "580": {
    "index": "580",
    "hex": "0x80000244",
    "symbol": "PLC",
    "name": "PLATINCOIN"
  },
  "581": {
    "index": "581",
    "hex": "0x80000245",
    "symbol": "DUN",
    "name": "Dune"
  },
  "582": {
    "index": "582",
    "hex": "0x80000246",
    "symbol": "DMCH",
    "name": "Darmacash"
  },
  "583": {
    "index": "583",
    "hex": "0x80000247",
    "symbol": "CTC",
    "name": "Creditcoin"
  },
  "584": {
    "index": "584",
    "hex": "0x80000248",
    "symbol": "KELP",
    "name": "Haidai Network"
  },
  "585": {
    "index": "585",
    "hex": "0x80000249",
    "symbol": "GBCR",
    "name": "GoldBCR"
  },
  "586": {
    "index": "586",
    "hex": "0x8000024a",
    "symbol": "XDAG",
    "name": "XDAG"
  },
  "587": {
    "index": "587",
    "hex": "0x8000024b",
    "symbol": "PRV",
    "name": "Incognito Privacy"
  },
  "588": {
    "index": "588",
    "hex": "0x8000024c",
    "symbol": "SCAP",
    "name": "SafeCapital"
  },
  "589": {
    "index": "589",
    "hex": "0x8000024d",
    "symbol": "TFUEL",
    "name": "Theta Fuel"
  },
  "590": {
    "index": "590",
    "hex": "0x8000024e",
    "symbol": "GTM",
    "name": "Gentarium"
  },
  "591": {
    "index": "591",
    "hex": "0x8000024f",
    "symbol": "RNL",
    "name": "RentalChain"
  },
  "592": {
    "index": "592",
    "hex": "0x80000250",
    "symbol": "GRIN",
    "name": "Grin"
  },
  "593": {
    "index": "593",
    "hex": "0x80000251",
    "symbol": "MWC",
    "name": "MimbleWimbleCoin"
  },
  "594": {
    "index": "594",
    "hex": "0x80000252",
    "symbol": "DOCK",
    "name": "Dock"
  },
  "595": {
    "index": "595",
    "hex": "0x80000253",
    "symbol": "POLYX",
    "name": "Polymesh"
  },
  "596": {
    "index": "596",
    "hex": "0x80000254",
    "symbol": "DIVER",
    "name": "Divergenti"
  },
  "597": {
    "index": "597",
    "hex": "0x80000255",
    "symbol": "XEP",
    "name": "Electra Protocol"
  },
  "598": {
    "index": "598",
    "hex": "0x80000256",
    "symbol": "APN",
    "name": "Apron"
  },
  "599": {
    "index": "599",
    "hex": "0x80000257",
    "symbol": "TFC",
    "name": "Turbo File Coin"
  },
  "600": {
    "index": "600",
    "hex": "0x80000258",
    "symbol": "UTE",
    "name": "Unit-e"
  },
  "601": {
    "index": "601",
    "hex": "0x80000259",
    "symbol": "MTC",
    "name": "Metacoin"
  },
  "602": {
    "index": "602",
    "hex": "0x8000025a",
    "symbol": "NC",
    "name": "NobodyCash"
  },
  "603": {
    "index": "603",
    "hex": "0x8000025b",
    "symbol": "XINY",
    "name": "Xinyuehu"
  },
  "604": {
    "index": "604",
    "hex": "0x8000025c",
    "symbol": "DYN",
    "name": "Dynamo"
  },
  "605": {
    "index": "605",
    "hex": "0x8000025d",
    "symbol": "BUFS",
    "name": "Buffer"
  },
  "606": {
    "index": "606",
    "hex": "0x8000025e",
    "symbol": "STOS",
    "name": "Stratos"
  },
  "607": {
    "index": "607",
    "hex": "0x8000025f",
    "symbol": "TON",
    "name": "TON"
  },
  "608": {
    "index": "608",
    "hex": "0x80000260",
    "symbol": "TAFT",
    "name": "TAFT"
  },
  "609": {
    "index": "609",
    "hex": "0x80000261",
    "symbol": "HYDRA",
    "name": "HYDRA"
  },
  "610": {
    "index": "610",
    "hex": "0x80000262",
    "symbol": "NOR",
    "name": "Noir"
  },
  "611": {
    "index": "611",
    "hex": "0x80000263",
    "symbol": "",
    "name": "Manta Network Private Asset"
  },
  "612": {
    "index": "612",
    "hex": "0x80000264",
    "symbol": "",
    "name": "Calamari Network Private Asset"
  },
  "613": {
    "index": "613",
    "hex": "0x80000265",
    "symbol": "WCN",
    "name": "Widecoin"
  },
  "614": {
    "index": "614",
    "hex": "0x80000266",
    "symbol": "OPT",
    "name": "Optimistic Ethereum"
  },
  "615": {
    "index": "615",
    "hex": "0x80000267",
    "symbol": "PSWAP",
    "name": "PolkaSwap"
  },
  "616": {
    "index": "616",
    "hex": "0x80000268",
    "symbol": "VAL",
    "name": "Validator"
  },
  "617": {
    "index": "617",
    "hex": "0x80000269",
    "symbol": "XOR",
    "name": "Sora"
  },
  "618": {
    "index": "618",
    "hex": "0x8000026a",
    "symbol": "SSP",
    "name": "SmartShare"
  },
  "619": {
    "index": "619",
    "hex": "0x8000026b",
    "symbol": "DEI",
    "name": "DeimosX"
  },
  "621": {
    "index": "621",
    "hex": "0x8000026d",
    "symbol": "ZERO",
    "name": "Singularity"
  },
  "622": {
    "index": "622",
    "hex": "0x8000026e",
    "symbol": "ALPHA",
    "name": "AlphaDAO"
  },
  "623": {
    "index": "623",
    "hex": "0x8000026f",
    "symbol": "BDECO",
    "name": "BDCashProtocol Ecosystem"
  },
  "624": {
    "index": "624",
    "hex": "0x80000270",
    "symbol": "NOBL",
    "name": "Nobility"
  },
  "625": {
    "index": "625",
    "hex": "0x80000271",
    "symbol": "EAST",
    "name": "Eastcoin"
  },
  "626": {
    "index": "626",
    "hex": "0x80000272",
    "symbol": "KDA",
    "name": "Kadena"
  },
  "627": {
    "index": "627",
    "hex": "0x80000273",
    "symbol": "SOUL",
    "name": "Phantasma"
  },
  "628": {
    "index": "628",
    "hex": "0x80000274",
    "symbol": "LORE",
    "name": "Gitopia"
  },
  "629": {
    "index": "629",
    "hex": "0x80000275",
    "symbol": "FNR",
    "name": "Fincor"
  },
  "630": {
    "index": "630",
    "hex": "0x80000276",
    "symbol": "NEXUS",
    "name": "Nexus"
  },
  "631": {
    "index": "631",
    "hex": "0x80000277",
    "symbol": "QTZ",
    "name": "Quartz"
  },
  "632": {
    "index": "632",
    "hex": "0x80000278",
    "symbol": "MAS",
    "name": "Massa"
  },
  "633": {
    "index": "633",
    "hex": "0x80000279",
    "symbol": "CALL",
    "name": "Callchain"
  },
  "634": {
    "index": "634",
    "hex": "0x8000027a",
    "symbol": "VAL",
    "name": "Validity"
  },
  "635": {
    "index": "635",
    "hex": "0x8000027b",
    "symbol": "POKT",
    "name": "Pocket Network"
  },
  "636": {
    "index": "636",
    "hex": "0x8000027c",
    "symbol": "EMIT",
    "name": "EMIT"
  },
  "637": {
    "index": "637",
    "hex": "0x8000027d",
    "symbol": "APTOS",
    "name": "Aptos"
  },
  "638": {
    "index": "638",
    "hex": "0x8000027e",
    "symbol": "ADON",
    "name": "ADON"
  },
  "639": {
    "index": "639",
    "hex": "0x8000027f",
    "symbol": "BTSG",
    "name": "BitSong"
  },
  "640": {
    "index": "640",
    "hex": "0x80000280",
    "symbol": "LFC",
    "name": "Leofcoin"
  },
  "641": {
    "index": "641",
    "hex": "0x80000281",
    "symbol": "KCS",
    "name": "KuCoin Shares"
  },
  "642": {
    "index": "642",
    "hex": "0x80000282",
    "symbol": "KCC",
    "name": "KuCoin Community Chain"
  },
  "643": {
    "index": "643",
    "hex": "0x80000283",
    "symbol": "AZERO",
    "name": "Aleph Zero"
  },
  "644": {
    "index": "644",
    "hex": "0x80000284",
    "symbol": "TREE",
    "name": "Tree"
  },
  "645": {
    "index": "645",
    "hex": "0x80000285",
    "symbol": "LX",
    "name": "Lynx"
  },
  "646": {
    "index": "646",
    "hex": "0x80000286",
    "symbol": "XLN",
    "name": "Lunarium"
  },
  "647": {
    "index": "647",
    "hex": "0x80000287",
    "symbol": "CIC",
    "name": "CIC Chain"
  },
  "648": {
    "index": "648",
    "hex": "0x80000288",
    "symbol": "ZRB",
    "name": "Zarb"
  },
  "650": {
    "index": "650",
    "hex": "0x8000028a",
    "symbol": "UCO",
    "name": "Archethic"
  },
  "651": {
    "index": "651",
    "hex": "0x8000028b",
    "symbol": "SFX",
    "name": "Safex Cash"
  },
  "652": {
    "index": "652",
    "hex": "0x8000028c",
    "symbol": "SFT",
    "name": "Safex Token"
  },
  "653": {
    "index": "653",
    "hex": "0x8000028d",
    "symbol": "WSFX",
    "name": "Wrapped Safex Cash"
  },
  "654": {
    "index": "654",
    "hex": "0x8000028e",
    "symbol": "USDG",
    "name": "US Digital Gold"
  },
  "655": {
    "index": "655",
    "hex": "0x8000028f",
    "symbol": "WMP",
    "name": "WAMP"
  },
  "656": {
    "index": "656",
    "hex": "0x80000290",
    "symbol": "EKTA",
    "name": "Ekta"
  },
  "657": {
    "index": "657",
    "hex": "0x80000291",
    "symbol": "YDA",
    "name": "YadaCoin"
  },
  "658": {
    "index": "658",
    "hex": "0x80000292",
    "symbol": "WHIVE",
    "name": "Whive"
  },
  "659": {
    "index": "659",
    "hex": "0x80000293",
    "symbol": "KOIN",
    "name": "Koinos"
  },
  "660": {
    "index": "660",
    "hex": "0x80000294",
    "symbol": "PIRATE",
    "name": "PirateCash"
  },
  "661": {
    "index": "661",
    "hex": "0x80000295",
    "symbol": "UNQ",
    "name": "Unique"
  },
  "662": {
    "index": "662",
    "hex": "0x80000296",
    "symbol": "ULM",
    "name": "UltonSmartchain"
  },
  "663": {
    "index": "663",
    "hex": "0x80000297",
    "symbol": "SFRX",
    "name": "EtherGem Sapphire"
  },
  "664": {
    "index": "664",
    "hex": "0x80000298",
    "symbol": "BSTY",
    "name": "GlobalBoost-Y"
  },
  "665": {
    "index": "665",
    "hex": "0x80000299",
    "symbol": "IMP",
    "name": "Impact Protocol"
  },
  "666": {
    "index": "666",
    "hex": "0x8000029a",
    "symbol": "ACT",
    "name": "Achain"
  },
  "667": {
    "index": "667",
    "hex": "0x8000029b",
    "symbol": "PRKL",
    "name": "Perkle"
  },
  "668": {
    "index": "668",
    "hex": "0x8000029c",
    "symbol": "SSC",
    "name": "SelfSell"
  },
  "669": {
    "index": "669",
    "hex": "0x8000029d",
    "symbol": "GC",
    "name": "GateChain"
  },
  "670": {
    "index": "670",
    "hex": "0x8000029e",
    "symbol": "PLGR",
    "name": "Pledger"
  },
  "671": {
    "index": "671",
    "hex": "0x8000029f",
    "symbol": "MPLGR",
    "name": "Pledger"
  },
  "672": {
    "index": "672",
    "hex": "0x800002a0",
    "symbol": "KNOX",
    "name": "Knox"
  },
  "673": {
    "index": "673",
    "hex": "0x800002a1",
    "symbol": "ZED",
    "name": "ZED"
  },
  "674": {
    "index": "674",
    "hex": "0x800002a2",
    "symbol": "CNDL",
    "name": "Candle"
  },
  "675": {
    "index": "675",
    "hex": "0x800002a3",
    "symbol": "WLKR",
    "name": "Walker Crypto Innovation Index"
  },
  "676": {
    "index": "676",
    "hex": "0x800002a4",
    "symbol": "WLKRR",
    "name": "Walker"
  },
  "677": {
    "index": "677",
    "hex": "0x800002a5",
    "symbol": "YUNGE",
    "name": "Yunge"
  },
  "678": {
    "index": "678",
    "hex": "0x800002a6",
    "symbol": "Voken",
    "name": "Voken"
  },
  "679": {
    "index": "679",
    "hex": "0x800002a7",
    "symbol": "APL",
    "name": "Apollo"
  },
  "680": {
    "index": "680",
    "hex": "0x800002a8",
    "symbol": "Evrynet",
    "name": "Evrynet"
  },
  "681": {
    "index": "681",
    "hex": "0x800002a9",
    "symbol": "NENG",
    "name": "Nengcoin"
  },
  "682": {
    "index": "682",
    "hex": "0x800002aa",
    "symbol": "CHTA",
    "name": "Cheetahcoin"
  },
  "683": {
    "index": "683",
    "hex": "0x800002ab",
    "symbol": "ALEO",
    "name": "Aleo Network"
  },
  "684": {
    "index": "684",
    "hex": "0x800002ac",
    "symbol": "HMS",
    "name": "Hemis"
  },
  "685": {
    "index": "685",
    "hex": "0x800002ad",
    "symbol": "OAS",
    "name": "Oasys"
  },
  "686": {
    "index": "686",
    "hex": "0x800002ae",
    "symbol": "KAR",
    "name": "Karura Network"
  },
  "687": {
    "index": "687",
    "hex": "0x800002af",
    "symbol": "FLON",
    "name": "FullOn Network"
  },
  "688": {
    "index": "688",
    "hex": "0x800002b0",
    "symbol": "CET",
    "name": "CoinEx Chain"
  },
  "689": {
    "index": "689",
    "hex": "0x800002b1",
    "symbol": "XLINK",
    "name": "XLink Chain"
  },
  "690": {
    "index": "690",
    "hex": "0x800002b2",
    "symbol": "KLV",
    "name": "KleverChain"
  },
  "691": {
    "index": "691",
    "hex": "0x800002b3",
    "symbol": "TNT",
    "name": "Tangle"
  },
  "692": {
    "index": "692",
    "hex": "0x800002b4",
    "symbol": "GTG",
    "name": "Gotigin"
  },
  "693": {
    "index": "693",
    "hex": "0x800002b5",
    "symbol": "NET",
    "name": "RealityNet"
  },
  "694": {
    "index": "694",
    "hex": "0x800002b6",
    "symbol": "VTBC",
    "name": "VTB Community"
  },
  "695": {
    "index": "695",
    "hex": "0x800002b7",
    "symbol": "DIONE",
    "name": "Odyssey Chain"
  },
  "696": {
    "index": "696",
    "hex": "0x800002b8",
    "symbol": "LUM",
    "name": "Lumos"
  },
  "697": {
    "index": "697",
    "hex": "0x800002b9",
    "symbol": "AVA",
    "name": "Avalon"
  },
  "698": {
    "index": "698",
    "hex": "0x800002ba",
    "symbol": "VEIL",
    "name": "Veil"
  },
  "699": {
    "index": "699",
    "hex": "0x800002bb",
    "symbol": "GTB",
    "name": "GotaBit"
  },
  "700": {
    "index": "700",
    "hex": "0x800002bc",
    "symbol": "XDAI",
    "name": "xDai"
  },
  "701": {
    "index": "701",
    "hex": "0x800002bd",
    "symbol": "COM",
    "name": "Commercio"
  },
  "702": {
    "index": "702",
    "hex": "0x800002be",
    "symbol": "CCC",
    "name": "Commercio Cash Credit"
  },
  "703": {
    "index": "703",
    "hex": "0x800002bf",
    "symbol": "SNR",
    "name": "Sonr"
  },
  "704": {
    "index": "704",
    "hex": "0x800002c0",
    "symbol": "RAQ",
    "name": "Ra Quantum"
  },
  "705": {
    "index": "705",
    "hex": "0x800002c1",
    "symbol": "PEG",
    "name": "Pegasus Token"
  },
  "706": {
    "index": "706",
    "hex": "0x800002c2",
    "symbol": "LKG",
    "name": "Lionking"
  },
  "707": {
    "index": "707",
    "hex": "0x800002c3",
    "symbol": "MCOIN",
    "name": "Moneta Coin"
  },
  "709": {
    "index": "709",
    "hex": "0x800002c5",
    "symbol": "AVAIL",
    "name": "Avail"
  },
  "710": {
    "index": "710",
    "hex": "0x800002c6",
    "symbol": "FURY",
    "name": "Highbury"
  },
  "711": {
    "index": "711",
    "hex": "0x800002c7",
    "symbol": "CHC",
    "name": "Chaincoin"
  },
  "712": {
    "index": "712",
    "hex": "0x800002c8",
    "symbol": "SERF",
    "name": "Serfnet"
  },
  "713": {
    "index": "713",
    "hex": "0x800002c9",
    "symbol": "XTL",
    "name": "Katal Chain"
  },
  "714": {
    "index": "714",
    "hex": "0x800002ca",
    "symbol": "BNB",
    "name": "Binance"
  },
  "715": {
    "index": "715",
    "hex": "0x800002cb",
    "symbol": "SIN",
    "name": "Sinovate"
  },
  "716": {
    "index": "716",
    "hex": "0x800002cc",
    "symbol": "DLN",
    "name": "Delion"
  },
  "717": {
    "index": "717",
    "hex": "0x800002cd",
    "symbol": "BONTE",
    "name": "Bontecoin"
  },
  "718": {
    "index": "718",
    "hex": "0x800002ce",
    "symbol": "PEER",
    "name": "Peer"
  },
  "719": {
    "index": "719",
    "hex": "0x800002cf",
    "symbol": "ZET",
    "name": "Zetacoin"
  },
  "720": {
    "index": "720",
    "hex": "0x800002d0",
    "symbol": "ABY",
    "name": "Artbyte"
  },
  "721": {
    "index": "721",
    "hex": "0x800002d1",
    "symbol": "PGX",
    "name": "Mirai Chain"
  },
  "722": {
    "index": "722",
    "hex": "0x800002d2",
    "symbol": "IL8P",
    "name": "InfiniLooP"
  },
  "723": {
    "index": "723",
    "hex": "0x800002d3",
    "symbol": "VOI",
    "name": "Voi"
  },
  "724": {
    "index": "724",
    "hex": "0x800002d4",
    "symbol": "XVC",
    "name": "Vanillacash"
  },
  "725": {
    "index": "725",
    "hex": "0x800002d5",
    "symbol": "MCX",
    "name": "MultiCash"
  },
  "726": {
    "index": "726",
    "hex": "0x800002d6",
    "symbol": "TARA",
    "name": "Taraxa"
  },
  "727": {
    "index": "727",
    "hex": "0x800002d7",
    "symbol": "BLU",
    "name": "BluCrates"
  },
  "728": {
    "index": "728",
    "hex": "0x800002d8",
    "symbol": "BFC",
    "name": "BFC"
  },
  "729": {
    "index": "729",
    "hex": "0x800002d9",
    "symbol": "DCC",
    "name": "DecentraCast"
  },
  "730": {
    "index": "730",
    "hex": "0x800002da",
    "symbol": "HEALIOS",
    "name": "Tenacity"
  },
  "731": {
    "index": "731",
    "hex": "0x800002db",
    "symbol": "BMK",
    "name": "Bitmark"
  },
  "732": {
    "index": "732",
    "hex": "0x800002dc",
    "symbol": "FUGA",
    "name": "Fuga token"
  },
  "733": {
    "index": "733",
    "hex": "0x800002dd",
    "symbol": "TBC",
    "name": "TBChat"
  },
  "734": {
    "index": "734",
    "hex": "0x800002de",
    "symbol": "DENTX",
    "name": "DENTNet"
  },
  "735": {
    "index": "735",
    "hex": "0x800002df",
    "symbol": "NBY",
    "name": "Neobytes"
  },
  "736": {
    "index": "736",
    "hex": "0x800002e0",
    "symbol": "BABY",
    "name": "BABY"
  },
  "737": {
    "index": "737",
    "hex": "0x800002e1",
    "symbol": "ATOP",
    "name": "Financial Blockchain"
  },
  "738": {
    "index": "738",
    "hex": "0x800002e2",
    "symbol": "BTE",
    "name": "Bitweb"
  },
  "739": {
    "index": "739",
    "hex": "0x800002e3",
    "symbol": "DPC",
    "name": "Dpowcoin (DualPowCoin)"
  },
  "740": {
    "index": "740",
    "hex": "0x800002e4",
    "symbol": "MDC",
    "name": "MyDataCoin"
  },
  "741": {
    "index": "741",
    "hex": "0x800002e5",
    "symbol": "RIV",
    "name": "Rigvid"
  },
  "742": {
    "index": "742",
    "hex": "0x800002e6",
    "symbol": "LTO",
    "name": "LTO Network"
  },
  "743": {
    "index": "743",
    "hex": "0x800002e7",
    "symbol": "LKY",
    "name": "LuckyCoin"
  },
  "744": {
    "index": "744",
    "hex": "0x800002e8",
    "symbol": "DUSK",
    "name": "Dusk"
  },
  "745": {
    "index": "745",
    "hex": "0x800002e9",
    "symbol": "DIMI",
    "name": "DiminutiveCoin"
  },
  "747": {
    "index": "747",
    "hex": "0x800002eb",
    "symbol": "CFG",
    "name": "Centrifuge"
  },
  "750": {
    "index": "750",
    "hex": "0x800002ee",
    "symbol": "XPRT",
    "name": "Persistence"
  },
  "753": {
    "index": "753",
    "hex": "0x800002f1",
    "symbol": "",
    "name": "Age X25519 Encryption"
  },
  "754": {
    "index": "754",
    "hex": "0x800002f2",
    "symbol": "",
    "name": "Age NIST Encryption"
  },
  "757": {
    "index": "757",
    "hex": "0x800002f5",
    "symbol": "HONEY",
    "name": "HoneyWood"
  },
  "758": {
    "index": "758",
    "hex": "0x800002f6",
    "symbol": "XDD",
    "name": "XDDCoin"
  },
  "759": {
    "index": "759",
    "hex": "0x800002f7",
    "symbol": "TBI",
    "name": "TBicloud"
  },
  "765": {
    "index": "765",
    "hex": "0x800002fd",
    "symbol": "TGN",
    "name": "Tagion"
  },
  "767": {
    "index": "767",
    "hex": "0x800002ff",
    "symbol": "LLD",
    "name": "Liberland"
  },
  "768": {
    "index": "768",
    "hex": "0x80000300",
    "symbol": "BALLZ",
    "name": "Ballzcoin"
  },
  "770": {
    "index": "770",
    "hex": "0x80000302",
    "symbol": "COSA",
    "name": "Cosanta"
  },
  "771": {
    "index": "771",
    "hex": "0x80000303",
    "symbol": "BR",
    "name": "BR"
  },
  "773": {
    "index": "773",
    "hex": "0x80000305",
    "symbol": "CSB",
    "name": "CosmoBliss"
  },
  "775": {
    "index": "775",
    "hex": "0x80000307",
    "symbol": "PLSR",
    "name": "Pulsar Coin"
  },
  "776": {
    "index": "776",
    "hex": "0x80000308",
    "symbol": "KEY",
    "name": "Keymaker Coin"
  },
  "777": {
    "index": "777",
    "hex": "0x80000309",
    "symbol": "BTW",
    "name": "Bitcoin World"
  },
  "779": {
    "index": "779",
    "hex": "0x8000030b",
    "symbol": "UCHAIN",
    "name": "UCHAIN"
  },
  "780": {
    "index": "780",
    "hex": "0x8000030c",
    "symbol": "PLCUC",
    "name": "PLC Ultima Classic"
  },
  "781": {
    "index": "781",
    "hex": "0x8000030d",
    "symbol": "PLCUX",
    "name": "PLC Ultima X"
  },
  "782": {
    "index": "782",
    "hex": "0x8000030e",
    "symbol": "PLCU",
    "name": "PLC Ultima"
  },
  "783": {
    "index": "783",
    "hex": "0x8000030f",
    "symbol": "SMARTBC",
    "name": "SMART Blockchain"
  },
  "784": {
    "index": "784",
    "hex": "0x80000310",
    "symbol": "SUI",
    "name": "Sui"
  },
  "785": {
    "index": "785",
    "hex": "0x80000311",
    "symbol": "ULTIMA",
    "name": "ULTIMA"
  },
  "786": {
    "index": "786",
    "hex": "0x80000312",
    "symbol": "UIDD",
    "name": "UIDD"
  },
  "787": {
    "index": "787",
    "hex": "0x80000313",
    "symbol": "ACA",
    "name": "Acala"
  },
  "788": {
    "index": "788",
    "hex": "0x80000314",
    "symbol": "BNC",
    "name": "Bifrost"
  },
  "789": {
    "index": "789",
    "hex": "0x80000315",
    "symbol": "TAU",
    "name": "Lamden"
  },
  "790": {
    "index": "790",
    "hex": "0x80000316",
    "symbol": "LKY",
    "name": "Luckycoin"
  },
  "791": {
    "index": "791",
    "hex": "0x80000317",
    "symbol": "SOMA",
    "name": "Soma"
  },
  "794": {
    "index": "794",
    "hex": "0x8000031a",
    "symbol": "INTR",
    "name": "Interlay"
  },
  "795": {
    "index": "795",
    "hex": "0x8000031b",
    "symbol": "KINT",
    "name": "Kintsugi"
  },
  "799": {
    "index": "799",
    "hex": "0x8000031f",
    "symbol": "PDEX",
    "name": "Polkadex"
  },
  "800": {
    "index": "800",
    "hex": "0x80000320",
    "symbol": "BEET",
    "name": "Beetle Coin"
  },
  "801": {
    "index": "801",
    "hex": "0x80000321",
    "symbol": "DST",
    "name": "DSTRA"
  },
  "802": {
    "index": "802",
    "hex": "0x80000322",
    "symbol": "CY",
    "name": "Cyberyen"
  },
  "803": {
    "index": "803",
    "hex": "0x80000323",
    "symbol": "RYME",
    "name": "Ryme Network"
  },
  "804": {
    "index": "804",
    "hex": "0x80000324",
    "symbol": "ZKS",
    "name": "zkSync"
  },
  "805": {
    "index": "805",
    "hex": "0x80000325",
    "symbol": "SCASH",
    "name": "Scash"
  },
  "808": {
    "index": "808",
    "hex": "0x80000328",
    "symbol": "QVT",
    "name": "Qvolta"
  },
  "809": {
    "index": "809",
    "hex": "0x80000329",
    "symbol": "SDN",
    "name": "Shiden Network"
  },
  "810": {
    "index": "810",
    "hex": "0x8000032a",
    "symbol": "ASTR",
    "name": "Astar Network"
  },
  "813": {
    "index": "813",
    "hex": "0x8000032d",
    "symbol": "MEER",
    "name": "Qitmeer"
  },
  "815": {
    "index": "815",
    "hex": "0x8000032f",
    "symbol": "FACT",
    "name": "ImFACT"
  },
  "816": {
    "index": "816",
    "hex": "0x80000330",
    "symbol": "FSC",
    "name": "FSC"
  },
  "818": {
    "index": "818",
    "hex": "0x80000332",
    "symbol": "VET",
    "name": "VeChain Token"
  },
  "819": {
    "index": "819",
    "hex": "0x80000333",
    "symbol": "REEF",
    "name": "Reef"
  },
  "820": {
    "index": "820",
    "hex": "0x80000334",
    "symbol": "CLO",
    "name": "Callisto"
  },
  "822": {
    "index": "822",
    "hex": "0x80000336",
    "symbol": "BDB",
    "name": "BigchainDB"
  },
  "824": {
    "index": "824",
    "hex": "0x80000338",
    "symbol": "RBNT",
    "name": "Redbelly Network"
  },
  "827": {
    "index": "827",
    "hex": "0x8000033b",
    "symbol": "ACE",
    "name": "Endurance"
  },
  "828": {
    "index": "828",
    "hex": "0x8000033c",
    "symbol": "CCN",
    "name": "ComputeCoin"
  },
  "829": {
    "index": "829",
    "hex": "0x8000033d",
    "symbol": "BBA",
    "name": "BBACHAIN"
  },
  "831": {
    "index": "831",
    "hex": "0x8000033f",
    "symbol": "CRUZ",
    "name": "cruzbit"
  },
  "832": {
    "index": "832",
    "hex": "0x80000340",
    "symbol": "SAPP",
    "name": "Sapphire"
  },
  "833": {
    "index": "833",
    "hex": "0x80000341",
    "symbol": "777",
    "name": "Jackpot"
  },
  "834": {
    "index": "834",
    "hex": "0x80000342",
    "symbol": "KYAN",
    "name": "Kyanite"
  },
  "835": {
    "index": "835",
    "hex": "0x80000343",
    "symbol": "AZR",
    "name": "Azzure"
  },
  "836": {
    "index": "836",
    "hex": "0x80000344",
    "symbol": "CFL",
    "name": "CryptoFlow"
  },
  "837": {
    "index": "837",
    "hex": "0x80000345",
    "symbol": "DASHD",
    "name": "Dash Diamond"
  },
  "838": {
    "index": "838",
    "hex": "0x80000346",
    "symbol": "TRTT",
    "name": "Trittium"
  },
  "839": {
    "index": "839",
    "hex": "0x80000347",
    "symbol": "UCR",
    "name": "Ultra Clear"
  },
  "840": {
    "index": "840",
    "hex": "0x80000348",
    "symbol": "PNY",
    "name": "Peony"
  },
  "841": {
    "index": "841",
    "hex": "0x80000349",
    "symbol": "BECN",
    "name": "Beacon"
  },
  "842": {
    "index": "842",
    "hex": "0x8000034a",
    "symbol": "MONK",
    "name": "Monk"
  },
  "843": {
    "index": "843",
    "hex": "0x8000034b",
    "symbol": "SAGA",
    "name": "CryptoSaga"
  },
  "844": {
    "index": "844",
    "hex": "0x8000034c",
    "symbol": "SUV",
    "name": "Suvereno"
  },
  "845": {
    "index": "845",
    "hex": "0x8000034d",
    "symbol": "ESK",
    "name": "EskaCoin"
  },
  "846": {
    "index": "846",
    "hex": "0x8000034e",
    "symbol": "OWO",
    "name": "OneWorld Coin"
  },
  "847": {
    "index": "847",
    "hex": "0x8000034f",
    "symbol": "PEPS",
    "name": "PEPS Coin"
  },
  "848": {
    "index": "848",
    "hex": "0x80000350",
    "symbol": "BIR",
    "name": "Birake"
  },
  "849": {
    "index": "849",
    "hex": "0x80000351",
    "symbol": "MOBIC",
    "name": "MobilityCoin"
  },
  "850": {
    "index": "850",
    "hex": "0x80000352",
    "symbol": "FLS",
    "name": "Flits"
  },
  "851": {
    "index": "851",
    "hex": "0x80000353",
    "symbol": "FRECO",
    "name": "Freco"
  },
  "852": {
    "index": "852",
    "hex": "0x80000354",
    "symbol": "DSM",
    "name": "Desmos"
  },
  "853": {
    "index": "853",
    "hex": "0x80000355",
    "symbol": "PRCY",
    "name": "PRCY Coin"
  },
  "858": {
    "index": "858",
    "hex": "0x8000035a",
    "symbol": "HVH",
    "name": "HAVAH"
  },
  "860": {
    "index": "860",
    "hex": "0x8000035c",
    "symbol": "XBIT",
    "name": "XBIT Coin"
  },
  "864": {
    "index": "864",
    "hex": "0x80000360",
    "symbol": "CVM",
    "name": "Convex"
  },
  "866": {
    "index": "866",
    "hex": "0x80000362",
    "symbol": "MOB",
    "name": "MobileCoin"
  },
  "868": {
    "index": "868",
    "hex": "0x80000364",
    "symbol": "IF",
    "name": "Infinitefuture"
  },
  "873": {
    "index": "873",
    "hex": "0x80000369",
    "symbol": "QUORUM",
    "name": "Quorum"
  },
  "877": {
    "index": "877",
    "hex": "0x8000036d",
    "symbol": "NAM",
    "name": "Namada"
  },
  "878": {
    "index": "878",
    "hex": "0x8000036e",
    "symbol": "SCR",
    "name": "Scorum Network"
  },
  "880": {
    "index": "880",
    "hex": "0x80000370",
    "symbol": "LUM",
    "name": "Lum Network"
  },
  "881": {
    "index": "881",
    "hex": "0x80000371",
    "symbol": "AEGS",
    "name": "Aegisum"
  },
  "883": {
    "index": "883",
    "hex": "0x80000373",
    "symbol": "ZBC",
    "name": "ZooBC"
  },
  "886": {
    "index": "886",
    "hex": "0x80000376",
    "symbol": "ADF",
    "name": "AD Token"
  },
  "888": {
    "index": "888",
    "hex": "0x80000378",
    "symbol": "NEO",
    "name": "NEO"
  },
  "889": {
    "index": "889",
    "hex": "0x80000379",
    "symbol": "TOMO",
    "name": "TOMO"
  },
  "890": {
    "index": "890",
    "hex": "0x8000037a",
    "symbol": "XSEL",
    "name": "Seln"
  },
  "896": {
    "index": "896",
    "hex": "0x80000380",
    "symbol": "LKSC",
    "name": "LKSCoin"
  },
  "898": {
    "index": "898",
    "hex": "0x80000382",
    "symbol": "AS",
    "name": "Assetchain"
  },
  "899": {
    "index": "899",
    "hex": "0x80000383",
    "symbol": "XEC",
    "name": "eCash"
  },
  "900": {
    "index": "900",
    "hex": "0x80000384",
    "symbol": "LMO",
    "name": "Lumeneo"
  },
  "901": {
    "index": "901",
    "hex": "0x80000385",
    "symbol": "NXT",
    "name": "NxtMeta"
  },
  "904": {
    "index": "904",
    "hex": "0x80000388",
    "symbol": "HNT",
    "name": "Helium"
  },
  "906": {
    "index": "906",
    "hex": "0x8000038a",
    "symbol": "XPX",
    "name": "Sirius"
  },
  "907": {
    "index": "907",
    "hex": "0x8000038b",
    "symbol": "FIS",
    "name": "StaFi"
  },
  "909": {
    "index": "909",
    "hex": "0x8000038d",
    "symbol": "SGE",
    "name": "Saage"
  },
  "911": {
    "index": "911",
    "hex": "0x8000038f",
    "symbol": "GERT",
    "name": "Gert"
  },
  "913": {
    "index": "913",
    "hex": "0x80000391",
    "symbol": "VARA",
    "name": "Vara Network"
  },
  "916": {
    "index": "916",
    "hex": "0x80000394",
    "symbol": "META",
    "name": "Metadium"
  },
  "917": {
    "index": "917",
    "hex": "0x80000395",
    "symbol": "FRA",
    "name": "Findora"
  },
  "919": {
    "index": "919",
    "hex": "0x80000397",
    "symbol": "CCD",
    "name": "Concordium"
  },
  "921": {
    "index": "921",
    "hex": "0x80000399",
    "symbol": "AVN",
    "name": "Avian Network"
  },
  "925": {
    "index": "925",
    "hex": "0x8000039d",
    "symbol": "DIP",
    "name": "Dipper Network"
  },
  "928": {
    "index": "928",
    "hex": "0x800003a0",
    "symbol": "GHM",
    "name": "HermitMatrixNetwork"
  },
  "931": {
    "index": "931",
    "hex": "0x800003a3",
    "symbol": "RUNE",
    "name": "THORChain (RUNE)"
  },
  "938": {
    "index": "938",
    "hex": "0x800003aa",
    "symbol": "MGO",
    "name": "Mango Network"
  },
  "939": {
    "index": "939",
    "hex": "0x800003ab",
    "symbol": "AB",
    "name": "Argot Protocol"
  },
  "942": {
    "index": "942",
    "hex": "0x800003ae",
    "symbol": "KCN",
    "name": "Kylacoin"
  },
  "943": {
    "index": "943",
    "hex": "0x800003af",
    "symbol": "LCN",
    "name": "Lyncoin"
  },
  "945": {
    "index": "945",
    "hex": "0x800003b1",
    "symbol": "UNLOCK",
    "name": "Jasiri protocol"
  },
  "950": {
    "index": "950",
    "hex": "0x800003b6",
    "symbol": "CNDT",
    "name": "Conduct Protocol"
  },
  "955": {
    "index": "955",
    "hex": "0x800003bb",
    "symbol": "LTP",
    "name": "LifetionCoin"
  },
  "958": {
    "index": "958",
    "hex": "0x800003be",
    "symbol": "",
    "name": "KickSoccer"
  },
  "960": {
    "index": "960",
    "hex": "0x800003c0",
    "symbol": "VKAX",
    "name": "Vkax"
  },
  "965": {
    "index": "965",
    "hex": "0x800003c5",
    "symbol": "ATLA",
    "name": "Atleta Network"
  },
  "966": {
    "index": "966",
    "hex": "0x800003c6",
    "symbol": "MATIC",
    "name": "Matic"
  },
  "968": {
    "index": "968",
    "hex": "0x800003c8",
    "symbol": "UNW",
    "name": "UNW"
  },
  "969": {
    "index": "969",
    "hex": "0x800003c9",
    "symbol": "QI",
    "name": "Quai Network"
  },
  "970": {
    "index": "970",
    "hex": "0x800003ca",
    "symbol": "TWINS",
    "name": "TWINS"
  },
  "975": {
    "index": "975",
    "hex": "0x800003cf",
    "symbol": "",
    "name": "TrustNet"
  },
  "977": {
    "index": "977",
    "hex": "0x800003d1",
    "symbol": "TLOS",
    "name": "Telos"
  },
  "981": {
    "index": "981",
    "hex": "0x800003d5",
    "symbol": "TAFECO",
    "name": "Taf ECO Chain"
  },
  "985": {
    "index": "985",
    "hex": "0x800003d9",
    "symbol": "AU",
    "name": "Autonomy"
  },
  "987": {
    "index": "987",
    "hex": "0x800003db",
    "symbol": "VCG",
    "name": "VipCoin"
  },
  "988": {
    "index": "988",
    "hex": "0x800003dc",
    "symbol": "XAZAB",
    "name": "Xazab core"
  },
  "989": {
    "index": "989",
    "hex": "0x800003dd",
    "symbol": "AIOZ",
    "name": "AIOZ"
  },
  "990": {
    "index": "990",
    "hex": "0x800003de",
    "symbol": "CORE",
    "name": "Coreum"
  },
  "991": {
    "index": "991",
    "hex": "0x800003df",
    "symbol": "PEC",
    "name": "Phoenix"
  },
  "992": {
    "index": "992",
    "hex": "0x800003e0",
    "symbol": "UNT",
    "name": "Unit"
  },
  "993": {
    "index": "993",
    "hex": "0x800003e1",
    "symbol": "XRB",
    "name": "X Currency"
  },
  "994": {
    "index": "994",
    "hex": "0x800003e2",
    "symbol": "QUAI",
    "name": "Quai Network"
  },
  "995": {
    "index": "995",
    "hex": "0x800003e3",
    "symbol": "CAPS",
    "name": "Ternoa"
  },
  "996": {
    "index": "996",
    "hex": "0x800003e4",
    "symbol": "OKT",
    "name": "OKChain Token"
  },
  "997": {
    "index": "997",
    "hex": "0x800003e5",
    "symbol": "SUM",
    "name": "Solidum"
  },
  "998": {
    "index": "998",
    "hex": "0x800003e6",
    "symbol": "LBTC",
    "name": "Lightning Bitcoin"
  },
  "999": {
    "index": "999",
    "hex": "0x800003e7",
    "symbol": "BCD",
    "name": "Bitcoin Diamond"
  },
  "1000": {
    "index": "1000",
    "hex": "0x800003e8",
    "symbol": "BTN",
    "name": "Bitcoin New"
  },
  "1001": {
    "index": "1001",
    "hex": "0x800003e9",
    "symbol": "TT",
    "name": "ThunderCore"
  },
  "1002": {
    "index": "1002",
    "hex": "0x800003ea",
    "symbol": "BKT",
    "name": "BanKitt"
  },
  "1003": {
    "index": "1003",
    "hex": "0x800003eb",
    "symbol": "NODL",
    "name": "Nodle"
  },
  "1004": {
    "index": "1004",
    "hex": "0x800003ec",
    "symbol": "PCOIN",
    "name": "PCOIN"
  },
  "1005": {
    "index": "1005",
    "hex": "0x800003ed",
    "symbol": "TAO",
    "name": "Bittensor"
  },
  "1006": {
    "index": "1006",
    "hex": "0x800003ee",
    "symbol": "HSK",
    "name": "HashKey Chain"
  },
  "1007": {
    "index": "1007",
    "hex": "0x800003ef",
    "symbol": "FTM",
    "name": "Fantom"
  },
  "1008": {
    "index": "1008",
    "hex": "0x800003f0",
    "symbol": "RPG",
    "name": "RPG"
  },
  "1009": {
    "index": "1009",
    "hex": "0x800003f1",
    "symbol": "LAKE",
    "name": "iconLake"
  },
  "1010": {
    "index": "1010",
    "hex": "0x800003f2",
    "symbol": "HT",
    "name": "Huobi ECO Chain"
  },
  "1011": {
    "index": "1011",
    "hex": "0x800003f3",
    "symbol": "ELV",
    "name": "Eluvio"
  },
  "1012": {
    "index": "1012",
    "hex": "0x800003f4",
    "symbol": "JOC",
    "name": "Japan Open Chain"
  },
  "1013": {
    "index": "1013",
    "hex": "0x800003f5",
    "symbol": "BIC",
    "name": "Beincrypto"
  },
  "1014": {
    "index": "1014",
    "hex": "0x800003f6",
    "symbol": "JOY",
    "name": "Joystream"
  },
  "1015": {
    "index": "1015",
    "hex": "0x800003f7",
    "symbol": "ZCX",
    "name": "ZEN Exchange Token"
  },
  "1017": {
    "index": "1017",
    "hex": "0x800003f9",
    "symbol": "ZTC",
    "name": "Zenchain"
  },
  "1020": {
    "index": "1020",
    "hex": "0x800003fc",
    "symbol": "EVC",
    "name": "Evrice"
  },
  "1022": {
    "index": "1022",
    "hex": "0x800003fe",
    "symbol": "XRD",
    "name": "Radix DLT"
  },
  "1023": {
    "index": "1023",
    "hex": "0x800003ff",
    "symbol": "ONE",
    "name": "HARMONY-ONE (Legacy)"
  },
  "1024": {
    "index": "1024",
    "hex": "0x80000400",
    "symbol": "ONT",
    "name": "Ontology"
  },
  "1025": {
    "index": "1025",
    "hex": "0x80000401",
    "symbol": "CZZ",
    "name": "Classzz"
  },
  "1026": {
    "index": "1026",
    "hex": "0x80000402",
    "symbol": "KEX",
    "name": "Kira Exchange Token"
  },
  "1027": {
    "index": "1027",
    "hex": "0x80000403",
    "symbol": "MCM",
    "name": "Mochimo"
  },
  "1028": {
    "index": "1028",
    "hex": "0x80000404",
    "symbol": "PLS",
    "name": "Pulse Coin"
  },
  "1032": {
    "index": "1032",
    "hex": "0x80000408",
    "symbol": "BTCR",
    "name": "BTCR"
  },
  "1042": {
    "index": "1042",
    "hex": "0x80000412",
    "symbol": "MFID",
    "name": "Moonfish ID"
  },
  "1100": {
    "index": "1100",
    "hex": "0x8000044c",
    "symbol": "CROSS",
    "name": "Cross Chain"
  },
  "1110": {
    "index": "1110",
    "hex": "0x80000456",
    "symbol": "ZRA",
    "name": "ZERA"
  },
  "1111": {
    "index": "1111",
    "hex": "0x80000457",
    "symbol": "BBC",
    "name": "Big Bitcoin"
  },
  "1116": {
    "index": "1116",
    "hex": "0x8000045c",
    "symbol": "CORE",
    "name": "Core"
  },
  "1120": {
    "index": "1120",
    "hex": "0x80000460",
    "symbol": "RISE",
    "name": "RISE"
  },
  "1122": {
    "index": "1122",
    "hex": "0x80000462",
    "symbol": "CMT",
    "name": "CyberMiles Token"
  },
  "1128": {
    "index": "1128",
    "hex": "0x80000468",
    "symbol": "ETSC",
    "name": "Ethereum Social"
  },
  "1129": {
    "index": "1129",
    "hex": "0x80000469",
    "symbol": "DFI",
    "name": "DeFiChain"
  },
  "1130": {
    "index": "1130",
    "hex": "0x8000046a",
    "symbol": "DFI",
    "name": "DeFiChain EVM Network"
  },
  "1134": {
    "index": "1134",
    "hex": "0x8000046e",
    "symbol": "MESH",
    "name": "StateMesh"
  },
  "1137": {
    "index": "1137",
    "hex": "0x80000471",
    "symbol": "$DAG",
    "name": "Constellation Labs"
  },
  "1145": {
    "index": "1145",
    "hex": "0x80000479",
    "symbol": "CDY",
    "name": "Bitcoin Candy"
  },
  "1155": {
    "index": "1155",
    "hex": "0x80000483",
    "symbol": "ENJ",
    "name": "Enjin Coin"
  },
  "1170": {
    "index": "1170",
    "hex": "0x80000492",
    "symbol": "HOO",
    "name": "Hoo Smart Chain"
  },
  "1200": {
    "index": "1200",
    "hex": "0x800004b0",
    "symbol": "GNK",
    "name": "Gonka"
  },
  "1234": {
    "index": "1234",
    "hex": "0x800004d2",
    "symbol": "ALPH",
    "name": "Alephium"
  },
  "1236": {
    "index": "1236",
    "hex": "0x800004d4",
    "symbol": "",
    "name": "Masca"
  },
  "1237": {
    "index": "1237",
    "hex": "0x800004d5",
    "symbol": "",
    "name": "Nostr"
  },
  "1280": {
    "index": "1280",
    "hex": "0x80000500",
    "symbol": "",
    "name": "Kudos Setler"
  },
  "1284": {
    "index": "1284",
    "hex": "0x80000504",
    "symbol": "GLMR",
    "name": "Moonbeam"
  },
  "1285": {
    "index": "1285",
    "hex": "0x80000505",
    "symbol": "MOVR",
    "name": "Moonriver"
  },
  "1286": {
    "index": "1286",
    "hex": "0x80000506",
    "symbol": "DSG",
    "name": "Dessage Social Protocol"
  },
  "1298": {
    "index": "1298",
    "hex": "0x80000512",
    "symbol": "WPC",
    "name": "Wpc"
  },
  "1308": {
    "index": "1308",
    "hex": "0x8000051c",
    "symbol": "WEI",
    "name": "WEI"
  },
  "1312": {
    "index": "1312",
    "hex": "0x80000520",
    "symbol": "BITS",
    "name": "Entropy"
  },
  "1337": {
    "index": "1337",
    "hex": "0x80000539",
    "symbol": "DFC",
    "name": "Defcoin"
  },
  "1338": {
    "index": "1338",
    "hex": "0x8000053a",
    "symbol": "IRON",
    "name": "Iron Fish"
  },
  "1348": {
    "index": "1348",
    "hex": "0x80000544",
    "symbol": "ISLM",
    "name": "IslamicCoin"
  },
  "1397": {
    "index": "1397",
    "hex": "0x80000575",
    "symbol": "HYC",
    "name": "Hycon"
  },
  "1410": {
    "index": "1410",
    "hex": "0x80000582",
    "symbol": "TENTSLP",
    "name": "TENT Simple Ledger Protocol"
  },
  "1420": {
    "index": "1420",
    "hex": "0x8000058c",
    "symbol": "DEV",
    "name": "DogecoinEV"
  },
  "1510": {
    "index": "1510",
    "hex": "0x800005e6",
    "symbol": "XSC",
    "name": "XT Smart Chain"
  },
  "1512": {
    "index": "1512",
    "hex": "0x800005e8",
    "symbol": "AAC",
    "name": "Double-A Chain"
  },
  "1524": {
    "index": "1524",
    "hex": "0x800005f4",
    "symbol": "",
    "name": "Taler"
  },
  "1533": {
    "index": "1533",
    "hex": "0x800005fd",
    "symbol": "BEAM",
    "name": "Beam"
  },
  "1536": {
    "index": "1536",
    "hex": "0x80000600",
    "symbol": "GAS",
    "name": "BubiChain"
  },
  "1540": {
    "index": "1540",
    "hex": "0x80000604",
    "symbol": "ATHENA",
    "name": "Athena"
  },
  "1551": {
    "index": "1551",
    "hex": "0x8000060f",
    "symbol": "SDK",
    "name": "Sovereign SDK"
  },
  "1555": {
    "index": "1555",
    "hex": "0x80000613",
    "symbol": "APC",
    "name": "Apc Chain"
  },
  "1616": {
    "index": "1616",
    "hex": "0x80000650",
    "symbol": "ELF",
    "name": "AELF"
  },
  "1618": {
    "index": "1618",
    "hex": "0x80000652",
    "symbol": "AUDL",
    "name": "AUDL"
  },
  "1620": {
    "index": "1620",
    "hex": "0x80000654",
    "symbol": "ATH",
    "name": "Atheios"
  },
  "1627": {
    "index": "1627",
    "hex": "0x8000065b",
    "symbol": "LUME",
    "name": "Lume Web"
  },
  "1642": {
    "index": "1642",
    "hex": "0x8000066a",
    "symbol": "NEW",
    "name": "Newton"
  },
  "1657": {
    "index": "1657",
    "hex": "0x80000679",
    "symbol": "BTA",
    "name": "Btachain"
  },
  "1668": {
    "index": "1668",
    "hex": "0x80000684",
    "symbol": "NEOX",
    "name": "Neoxa"
  },
  "1669": {
    "index": "1669",
    "hex": "0x80000685",
    "symbol": "MEWC",
    "name": "Meowcoin"
  },
  "1688": {
    "index": "1688",
    "hex": "0x80000698",
    "symbol": "BCX",
    "name": "BitcoinX"
  },
  "1729": {
    "index": "1729",
    "hex": "0x800006c1",
    "symbol": "XTZ",
    "name": "Tezos"
  },
  "1776": {
    "index": "1776",
    "hex": "0x800006f0",
    "symbol": "LBTC",
    "name": "Liquid BTC"
  },
  "1777": {
    "index": "1777",
    "hex": "0x800006f1",
    "symbol": "BBP",
    "name": "Biblepay"
  },
  "1784": {
    "index": "1784",
    "hex": "0x800006f8",
    "symbol": "JPYS",
    "name": "JPY Stablecoin"
  },
  "1789": {
    "index": "1789",
    "hex": "0x800006fd",
    "symbol": "VEGA",
    "name": "Vega Protocol"
  },
  "1815": {
    "index": "1815",
    "hex": "0x80000717",
    "symbol": "ADA",
    "name": "Cardano"
  },
  "1818": {
    "index": "1818",
    "hex": "0x8000071a",
    "symbol": "CUBE",
    "name": "Cube Chain Native Token"
  },
  "1888": {
    "index": "1888",
    "hex": "0x80000760",
    "symbol": "ZTX",
    "name": "Zetrix"
  },
  "1899": {
    "index": "1899",
    "hex": "0x8000076b",
    "symbol": "XEC",
    "name": "eCash token"
  },
  "1900": {
    "index": "1900",
    "hex": "0x8000076c",
    "symbol": "XNA",
    "name": "Neurai"
  },
  "1901": {
    "index": "1901",
    "hex": "0x8000076d",
    "symbol": "CLC",
    "name": "Classica"
  },
  "1907": {
    "index": "1907",
    "hex": "0x80000773",
    "symbol": "BITCI",
    "name": "Bitcicoin"
  },
  "1918": {
    "index": "1918",
    "hex": "0x8000077e",
    "symbol": "BKC",
    "name": "Briskcoin"
  },
  "1919": {
    "index": "1919",
    "hex": "0x8000077f",
    "symbol": "VIPS",
    "name": "VIPSTARCOIN"
  },
  "1926": {
    "index": "1926",
    "hex": "0x80000786",
    "symbol": "CITY",
    "name": "City Coin"
  },
  "1951": {
    "index": "1951",
    "hex": "0x8000079f",
    "symbol": "ESA",
    "name": "Esa"
  },
  "1952": {
    "index": "1952",
    "hex": "0x800007a0",
    "symbol": "ESC",
    "name": "EsaCoin"
  },
  "1955": {
    "index": "1955",
    "hex": "0x800007a3",
    "symbol": "XX",
    "name": "xx coin"
  },
  "1969": {
    "index": "1969",
    "hex": "0x800007b1",
    "symbol": "MVRK",
    "name": "Mavryk Network"
  },
  "1977": {
    "index": "1977",
    "hex": "0x800007b9",
    "symbol": "XMX",
    "name": "Xuma"
  },
  "1984": {
    "index": "1984",
    "hex": "0x800007c0",
    "symbol": "TRTL",
    "name": "TurtleCoin"
  },
  "1985": {
    "index": "1985",
    "hex": "0x800007c1",
    "symbol": "SLRT",
    "name": "Solarti Chain"
  },
  "1986": {
    "index": "1986",
    "hex": "0x800007c2",
    "symbol": "QTH",
    "name": "Qing Tong Horizon"
  },
  "1987": {
    "index": "1987",
    "hex": "0x800007c3",
    "symbol": "EGEM",
    "name": "EtherGem"
  },
  "1988": {
    "index": "1988",
    "hex": "0x800007c4",
    "symbol": "MIRA",
    "name": "Mira Chain"
  },
  "1989": {
    "index": "1989",
    "hex": "0x800007c5",
    "symbol": "HODL",
    "name": "HOdlcoin"
  },
  "1990": {
    "index": "1990",
    "hex": "0x800007c6",
    "symbol": "PHL",
    "name": "Placeholders"
  },
  "1991": {
    "index": "1991",
    "hex": "0x800007c7",
    "symbol": "SC",
    "name": "Sia"
  },
  "1996": {
    "index": "1996",
    "hex": "0x800007cc",
    "symbol": "MYT",
    "name": "Mineyourtime"
  },
  "1997": {
    "index": "1997",
    "hex": "0x800007cd",
    "symbol": "POLIS",
    "name": "Polis"
  },
  "1998": {
    "index": "1998",
    "hex": "0x800007ce",
    "symbol": "XMCC",
    "name": "Monoeci"
  },
  "1999": {
    "index": "1999",
    "hex": "0x800007cf",
    "symbol": "COLX",
    "name": "ColossusXT"
  },
  "2000": {
    "index": "2000",
    "hex": "0x800007d0",
    "symbol": "GIN",
    "name": "GinCoin"
  },
  "2001": {
    "index": "2001",
    "hex": "0x800007d1",
    "symbol": "MNP",
    "name": "MNPCoin"
  },
  "2002": {
    "index": "2002",
    "hex": "0x800007d2",
    "symbol": "MLN",
    "name": "Miraland"
  },
  "2003": {
    "index": "2003",
    "hex": "0x800007d3",
    "symbol": "ISNA",
    "name": "iSarrana"
  },
  "2010": {
    "index": "2010",
    "hex": "0x800007da",
    "symbol": "XBT",
    "name": "Bitcoin Classic"
  },
  "2013": {
    "index": "2013",
    "hex": "0x800007dd",
    "symbol": "JKC",
    "name": "Junkcoin"
  },
  "2015": {
    "index": "2015",
    "hex": "0x800007df",
    "symbol": "TEER",
    "name": "Integritee"
  },
  "2017": {
    "index": "2017",
    "hex": "0x800007e1",
    "symbol": "KIN",
    "name": "Kin"
  },
  "2018": {
    "index": "2018",
    "hex": "0x800007e2",
    "symbol": "EOSC",
    "name": "EOSClassic"
  },
  "2019": {
    "index": "2019",
    "hex": "0x800007e3",
    "symbol": "GBT",
    "name": "GoldBean Token"
  },
  "2020": {
    "index": "2020",
    "hex": "0x800007e4",
    "symbol": "PKC",
    "name": "PKC"
  },
  "2021": {
    "index": "2021",
    "hex": "0x800007e5",
    "symbol": "SKT",
    "name": "Sukhavati"
  },
  "2022": {
    "index": "2022",
    "hex": "0x800007e6",
    "symbol": "XHT",
    "name": "Xinghuo Token"
  },
  "2023": {
    "index": "2023",
    "hex": "0x800007e7",
    "symbol": "COC",
    "name": "Chat On Chain"
  },
  "2024": {
    "index": "2024",
    "hex": "0x800007e8",
    "symbol": "USBC",
    "name": "Universal Ledger USBC"
  },
  "2025": {
    "index": "2025",
    "hex": "0x800007e9",
    "symbol": "ROCK",
    "name": "Zenrock Labs"
  },
  "2026": {
    "index": "2026",
    "hex": "0x800007ea",
    "symbol": "ASTRON",
    "name": "ASTRON Token"
  },
  "2046": {
    "index": "2046",
    "hex": "0x800007fe",
    "symbol": "ANY",
    "name": "Any"
  },
  "2048": {
    "index": "2048",
    "hex": "0x80000800",
    "symbol": "MCASH",
    "name": "MCashChain"
  },
  "2049": {
    "index": "2049",
    "hex": "0x80000801",
    "symbol": "TRUE",
    "name": "TrueChain"
  },
  "2050": {
    "index": "2050",
    "hex": "0x80000802",
    "symbol": "MOVO",
    "name": "Movo Smart Chain"
  },
  "2086": {
    "index": "2086",
    "hex": "0x80000826",
    "symbol": "KILT",
    "name": "KILT Spiritnet"
  },
  "2091": {
    "index": "2091",
    "hex": "0x8000082b",
    "symbol": "FRQCY",
    "name": "Frequency"
  },
  "2109": {
    "index": "2109",
    "hex": "0x8000083d",
    "symbol": "SAMA",
    "name": "Exosama Network"
  },
  "2112": {
    "index": "2112",
    "hex": "0x80000840",
    "symbol": "IoTE",
    "name": "IoTE"
  },
  "2121": {
    "index": "2121",
    "hex": "0x80000849",
    "symbol": "CBTC",
    "name": "Coordinate BTC (Anduro)"
  },
  "2122": {
    "index": "2122",
    "hex": "0x8000084a",
    "symbol": "QBTC",
    "name": "Quasar BTC (Anduro)"
  },
  "2125": {
    "index": "2125",
    "hex": "0x8000084d",
    "symbol": "BAY",
    "name": "BitBay"
  },
  "2137": {
    "index": "2137",
    "hex": "0x80000859",
    "symbol": "XRG",
    "name": "Ergon"
  },
  "2199": {
    "index": "2199",
    "hex": "0x80000897",
    "symbol": "SAMA",
    "name": "Moonsama Network"
  },
  "2221": {
    "index": "2221",
    "hex": "0x800008ad",
    "symbol": "ASK",
    "name": "ASK"
  },
  "2222": {
    "index": "2222",
    "hex": "0x800008ae",
    "symbol": "CWEB",
    "name": "Coinweb"
  },
  "2285": {
    "index": "2285",
    "hex": "0x800008ed",
    "symbol": "",
    "name": "Qiyi Chain"
  },
  "2301": {
    "index": "2301",
    "hex": "0x800008fd",
    "symbol": "QTUM",
    "name": "QTUM"
  },
  "2302": {
    "index": "2302",
    "hex": "0x800008fe",
    "symbol": "ETP",
    "name": "Metaverse"
  },
  "2303": {
    "index": "2303",
    "hex": "0x800008ff",
    "symbol": "GXC",
    "name": "GXChain"
  },
  "2304": {
    "index": "2304",
    "hex": "0x80000900",
    "symbol": "CRP",
    "name": "CranePay"
  },
  "2305": {
    "index": "2305",
    "hex": "0x80000901",
    "symbol": "ELA",
    "name": "Elastos"
  },
  "2338": {
    "index": "2338",
    "hex": "0x80000922",
    "symbol": "SNOW",
    "name": "Snowblossom"
  },
  "2365": {
    "index": "2365",
    "hex": "0x8000093d",
    "symbol": "XIN",
    "name": "Mixin"
  },
  "2500": {
    "index": "2500",
    "hex": "0x800009c4",
    "symbol": "NEXI",
    "name": "Nexi"
  },
  "2570": {
    "index": "2570",
    "hex": "0x80000a0a",
    "symbol": "AOA",
    "name": "Aurora"
  },
  "2686": {
    "index": "2686",
    "hex": "0x80000a7e",
    "symbol": "AIPG",
    "name": "AIPowerGrid"
  },
  "2718": {
    "index": "2718",
    "hex": "0x80000a9e",
    "symbol": "NAS",
    "name": "Nebulas"
  },
  "2809": {
    "index": "2809",
    "hex": "0x80000af9",
    "symbol": "LAN",
    "name": "Lanify"
  },
  "2894": {
    "index": "2894",
    "hex": "0x80000b4e",
    "symbol": "REOSC",
    "name": "REOSC Ecosystem"
  },
  "2941": {
    "index": "2941",
    "hex": "0x80000b7d",
    "symbol": "BND",
    "name": "Blocknode"
  },
  "3000": {
    "index": "3000",
    "hex": "0x80000bb8",
    "symbol": "SM",
    "name": "Stealth Message"
  },
  "3003": {
    "index": "3003",
    "hex": "0x80000bbb",
    "symbol": "LUX",
    "name": "LUX"
  },
  "3030": {
    "index": "3030",
    "hex": "0x80000bd6",
    "symbol": "HBAR",
    "name": "Hedera HBAR"
  },
  "3054": {
    "index": "3054",
    "hex": "0x80000bee",
    "symbol": "HIVE",
    "name": "Hive Blockchain"
  },
  "3077": {
    "index": "3077",
    "hex": "0x80000c05",
    "symbol": "COS",
    "name": "Contentos"
  },
  "3131": {
    "index": "3131",
    "hex": "0x80000c3b",
    "symbol": "EZC",
    "name": "Ezcon Blockchain"
  },
  "3141": {
    "index": "3141",
    "hex": "0x80000c45",
    "symbol": "B1T",
    "name": "Bit"
  },
  "3276": {
    "index": "3276",
    "hex": "0x80000ccc",
    "symbol": "CCC",
    "name": "CodeChain"
  },
  "3333": {
    "index": "3333",
    "hex": "0x80000d05",
    "symbol": "SXP",
    "name": "Solar"
  },
  "3338": {
    "index": "3338",
    "hex": "0x80000d0a",
    "symbol": "PEAQ",
    "name": "peaq"
  },
  "3344": {
    "index": "3344",
    "hex": "0x80000d10",
    "symbol": "PLMC",
    "name": "Polimec"
  },
  "3377": {
    "index": "3377",
    "hex": "0x80000d31",
    "symbol": "ROI",
    "name": "ROIcoin"
  },
  "3381": {
    "index": "3381",
    "hex": "0x80000d35",
    "symbol": "DYN",
    "name": "Dynamic"
  },
  "3383": {
    "index": "3383",
    "hex": "0x80000d37",
    "symbol": "SEQ",
    "name": "Sequence"
  },
  "3434": {
    "index": "3434",
    "hex": "0x80000d6a",
    "symbol": "PEPE",
    "name": "Pepecoin Core"
  },
  "3501": {
    "index": "3501",
    "hex": "0x80000dad",
    "symbol": "JFIN",
    "name": "JFIN Coin"
  },
  "3552": {
    "index": "3552",
    "hex": "0x80000de0",
    "symbol": "DEO",
    "name": "Destocoin"
  },
  "3564": {
    "index": "3564",
    "hex": "0x80000dec",
    "symbol": "DST",
    "name": "DeStream"
  },
  "3601": {
    "index": "3601",
    "hex": "0x80000e11",
    "symbol": "CY",
    "name": "Cybits"
  },
  "3630": {
    "index": "3630",
    "hex": "0x80000e2e",
    "symbol": "EPPIE",
    "name": "Eppie"
  },
  "3757": {
    "index": "3757",
    "hex": "0x80000ead",
    "symbol": "MPC",
    "name": "Partisia Blockchain"
  },
  "3840": {
    "index": "3840",
    "hex": "0x80000f00",
    "symbol": "RED",
    "name": "ReDeFi RED"
  },
  "4040": {
    "index": "4040",
    "hex": "0x80000fc8",
    "symbol": "FC8",
    "name": "FCH Network"
  },
  "4096": {
    "index": "4096",
    "hex": "0x80001000",
    "symbol": "YEE",
    "name": "YeeCo"
  },
  "4218": {
    "index": "4218",
    "hex": "0x8000107a",
    "symbol": "IOTA",
    "name": "IOTA"
  },
  "4219": {
    "index": "4219",
    "hex": "0x8000107b",
    "symbol": "SMR",
    "name": "Shimmer"
  },
  "4242": {
    "index": "4242",
    "hex": "0x80001092",
    "symbol": "AXE",
    "name": "Axe"
  },
  "4343": {
    "index": "4343",
    "hex": "0x800010f7",
    "symbol": "XYM",
    "name": "Symbol"
  },
  "4444": {
    "index": "4444",
    "hex": "0x8000115c",
    "symbol": "C4E",
    "name": "Chain4Energy"
  },
  "4474": {
    "index": "4474",
    "hex": "0x8000117a",
    "symbol": "SHIC",
    "name": "ShibaCoin"
  },
  "4646": {
    "index": "4646",
    "hex": "0x80001226",
    "symbol": "MST",
    "name": "MST"
  },
  "4919": {
    "index": "4919",
    "hex": "0x80001337",
    "symbol": "XVM",
    "name": "Venidium"
  },
  "4976": {
    "index": "4976",
    "hex": "0x80001370",
    "symbol": "VARA",
    "name": "Vara"
  },
  "4999": {
    "index": "4999",
    "hex": "0x80001387",
    "symbol": "BXN",
    "name": "BlackFort Exchange Network"
  },
  "5000": {
    "index": "5000",
    "hex": "0x80001388",
    "symbol": "V12",
    "name": "Vet The Vote"
  },
  "5006": {
    "index": "5006",
    "hex": "0x8000138e",
    "symbol": "SBC",
    "name": "Senior Blockchain"
  },
  "5248": {
    "index": "5248",
    "hex": "0x80001480",
    "symbol": "FIC",
    "name": "FIC"
  },
  "5353": {
    "index": "5353",
    "hex": "0x800014e9",
    "symbol": "HNS",
    "name": "Handshake"
  },
  "5404": {
    "index": "5404",
    "hex": "0x8000151c",
    "symbol": "ISK",
    "name": "ISKRA"
  },
  "5467": {
    "index": "5467",
    "hex": "0x8000155b",
    "symbol": "ALTME",
    "name": "ALTME"
  },
  "5555": {
    "index": "5555",
    "hex": "0x800015b3",
    "symbol": "FUND",
    "name": "Unification"
  },
  "5757": {
    "index": "5757",
    "hex": "0x8000167d",
    "symbol": "STX",
    "name": "Stacks"
  },
  "5895": {
    "index": "5895",
    "hex": "0x80001707",
    "symbol": "VOW",
    "name": "VowChain VOW"
  },
  "5920": {
    "index": "5920",
    "hex": "0x80001720",
    "symbol": "SLU",
    "name": "SILUBIUM"
  },
  "5995": {
    "index": "5995",
    "hex": "0x8000176B",
    "symbol": "DUSK",
    "name": "Dusk Network"
  },
  "6060": {
    "index": "6060",
    "hex": "0x800017ac",
    "symbol": "GO",
    "name": "GoChain GO"
  },
  "6144": {
    "index": "6144",
    "hex": "0x80001800",
    "symbol": "DTS",
    "name": "Datos"
  },
  "6174": {
    "index": "6174",
    "hex": "0x8000181e",
    "symbol": "MOI",
    "name": "My Own Internet"
  },
  "6278": {
    "index": "6278",
    "hex": "0x80001886",
    "symbol": "STEAMX",
    "name": "Rails Network Mainnet"
  },
  "6310": {
    "index": "6310",
    "hex": "0x800018a6",
    "symbol": "VRL",
    "name": "Virel Protocol"
  },
  "6532": {
    "index": "6532",
    "hex": "0x80001984",
    "symbol": "UM",
    "name": "Penumbra"
  },
  "6599": {
    "index": "6599",
    "hex": "0x800019c7",
    "symbol": "RSC",
    "name": "Royal Sports City"
  },
  "6666": {
    "index": "6666",
    "hex": "0x80001a0a",
    "symbol": "BPA",
    "name": "Bitcoin Pizza"
  },
  "6688": {
    "index": "6688",
    "hex": "0x80001a20",
    "symbol": "SAFE",
    "name": "SAFE"
  },
  "6767": {
    "index": "6767",
    "hex": "0x80001a6f",
    "symbol": "CC",
    "name": "Canton Coin"
  },
  "6779": {
    "index": "6779",
    "hex": "0x80001a7b",
    "symbol": "COTI",
    "name": "COTI"
  },
  "6969": {
    "index": "6969",
    "hex": "0x80001b39",
    "symbol": "ROGER",
    "name": "TheHolyrogerCoin"
  },
  "7000": {
    "index": "7000",
    "hex": "0x80001b58",
    "symbol": "ZETA",
    "name": "ZetaChain"
  },
  "7027": {
    "index": "7027",
    "hex": "0x80001b73",
    "symbol": "ELLA",
    "name": "Ella the heart"
  },
  "7028": {
    "index": "7028",
    "hex": "0x80001b74",
    "symbol": "AA",
    "name": "Arthera"
  },
  "7070": {
    "index": "7070",
    "hex": "0x80001b9e",
    "symbol": "DOI",
    "name": "Doichain"
  },
  "7091": {
    "index": "7091",
    "hex": "0x80001bb3",
    "symbol": "TOPL",
    "name": "Topl"
  },
  "7272": {
    "index": "7272",
    "hex": "0x80001c68",
    "symbol": "ABTC",
    "name": "Alys BTC (Anduro)"
  },
  "7331": {
    "index": "7331",
    "hex": "0x80001ca3",
    "symbol": "KLY",
    "name": "KLYNTAR"
  },
  "7341": {
    "index": "7341",
    "hex": "0x80001cad",
    "symbol": "SHFT",
    "name": "Shyft"
  },
  "7518": {
    "index": "7518",
    "hex": "0x80001d5e",
    "symbol": "MEV",
    "name": "MEVerse"
  },
  "7576": {
    "index": "7576",
    "hex": "0x80001d98",
    "symbol": "ADIL",
    "name": "ADIL Chain"
  },
  "7777": {
    "index": "7777",
    "hex": "0x80001e61",
    "symbol": "BTV",
    "name": "Bitvote"
  },
  "7779": {
    "index": "7779",
    "hex": "0x80001e63",
    "symbol": "CPV",
    "name": "Compverse"
  },
  "8000": {
    "index": "8000",
    "hex": "0x80001f40",
    "symbol": "SKY",
    "name": "Skycoin"
  },
  "8008": {
    "index": "8008",
    "hex": "0x80001f48",
    "symbol": "BERA",
    "name": "Berachain"
  },
  "8017": {
    "index": "8017",
    "hex": "0x80001f51",
    "symbol": "ISC",
    "name": "iSunCoin"
  },
  "8080": {
    "index": "8080",
    "hex": "0x80001f90",
    "symbol": "",
    "name": "DSRV"
  },
  "8181": {
    "index": "8181",
    "hex": "0x80001ff5",
    "symbol": "BOC",
    "name": "BeOne Chain"
  },
  "8192": {
    "index": "8192",
    "hex": "0x80002000",
    "symbol": "PAC",
    "name": "pacprotocol"
  },
  "8217": {
    "index": "8217",
    "hex": "0x80002019",
    "symbol": "KAIA",
    "name": "KAIA"
  },
  "8339": {
    "index": "8339",
    "hex": "0x80002093",
    "symbol": "BTQ",
    "name": "BitcoinQuark"
  },
  "8444": {
    "index": "8444",
    "hex": "0x800020fc",
    "symbol": "XCH",
    "name": "Chia"
  },
  "8453": {
    "index": "8453",
    "hex": "0x80002105",
    "symbol": "",
    "name": "Base"
  },
  "8680": {
    "index": "8680",
    "hex": "0x800021e8",
    "symbol": "PLMNT",
    "name": "Planetmint"
  },
  "8732": {
    "index": "8732",
    "hex": "0x8000221c",
    "symbol": "BLN",
    "name": "Bullions"
  },
  "8738": {
    "index": "8738",
    "hex": "0x80002222",
    "symbol": "ALPH",
    "name": "Alph Network"
  },
  "8866": {
    "index": "8866",
    "hex": "0x800022a2",
    "symbol": "GGX",
    "name": "Golden Gate"
  },
  "8886": {
    "index": "8886",
    "hex": "0x800022b6",
    "symbol": "GGXT",
    "name": "Golden Gate Sydney"
  },
  "8888": {
    "index": "8888",
    "hex": "0x800022b8",
    "symbol": "SBTC",
    "name": "Super Bitcoin"
  },
  "8964": {
    "index": "8964",
    "hex": "0x80002304",
    "symbol": "NULS",
    "name": "NULS"
  },
  "8997": {
    "index": "8997",
    "hex": "0x80002325",
    "symbol": "BBC",
    "name": "Babacoin"
  },
  "8998": {
    "index": "8998",
    "hex": "0x80002326",
    "symbol": "JGC",
    "name": "JagoanCoin"
  },
  "8999": {
    "index": "8999",
    "hex": "0x80002327",
    "symbol": "BTP",
    "name": "Bitcoin Pay"
  },
  "9000": {
    "index": "9000",
    "hex": "0x80002328",
    "symbol": "AVAX",
    "name": "Avalanche"
  },
  "9001": {
    "index": "9001",
    "hex": "0x80002329",
    "symbol": "ARB1",
    "name": "Arbitrum"
  },
  "9002": {
    "index": "9002",
    "hex": "0x8000232a",
    "symbol": "BOBA",
    "name": "Boba"
  },
  "9003": {
    "index": "9003",
    "hex": "0x8000232b",
    "symbol": "LOOP",
    "name": "Loopring"
  },
  "9004": {
    "index": "9004",
    "hex": "0x8000232c",
    "symbol": "STRK",
    "name": "StarkNet"
  },
  "9005": {
    "index": "9005",
    "hex": "0x8000232d",
    "symbol": "AVAXC",
    "name": "Avalanche C-Chain"
  },
  "9006": {
    "index": "9006",
    "hex": "0x8000232e",
    "symbol": "BSC",
    "name": "Binance Smart Chain"
  },
  "9007": {
    "index": "9007",
    "hex": "0x8000232f",
    "symbol": "SATOX",
    "name": "Satoxcoin"
  },
  "9797": {
    "index": "9797",
    "hex": "0x80002645",
    "symbol": "NRG",
    "name": "Energi"
  },
  "9888": {
    "index": "9888",
    "hex": "0x800026a0",
    "symbol": "BTF",
    "name": "Bitcoin Faith"
  },
  "9969": {
    "index": "9969",
    "hex": "0x800026f1",
    "symbol": "OSMI",
    "name": "Osmium"
  },
  "9999": {
    "index": "9999",
    "hex": "0x8000270f",
    "symbol": "GOD",
    "name": "Bitcoin God"
  },
  "10000": {
    "index": "10000",
    "hex": "0x80002710",
    "symbol": "FO",
    "name": "FIBOS"
  },
  "10001": {
    "index": "10001",
    "hex": "0x80002711",
    "symbol": "SPACE",
    "name": "Space"
  },
  "10007": {
    "index": "10007",
    "hex": "0x80002717",
    "symbol": "S",
    "name": "SONIC"
  },
  "10111": {
    "index": "10111",
    "hex": "0x8000277f",
    "symbol": "DHP",
    "name": "dHealth"
  },
  "10226": {
    "index": "10226",
    "hex": "0x800027f2",
    "symbol": "RTM",
    "name": "Raptoreum"
  },
  "10242": {
    "index": "10242",
    "hex": "0x80002802",
    "symbol": "AA",
    "name": "Arthera"
  },
  "10291": {
    "index": "10291",
    "hex": "0x80002833",
    "symbol": "XRC",
    "name": "XRhodium"
  },
  "10507": {
    "index": "10507",
    "hex": "0x8000290b",
    "symbol": "NUM",
    "name": "Numbers Protocol"
  },
  "10605": {
    "index": "10605",
    "hex": "0x8000296d",
    "symbol": "XPI",
    "name": "Lotus"
  },
  "11111": {
    "index": "11111",
    "hex": "0x80002b67",
    "symbol": "ESS",
    "name": "Essentia One"
  },
  "11742": {
    "index": "11742",
    "hex": "0x80002dde",
    "symbol": "VARCH",
    "name": "InvArch"
  },
  "11743": {
    "index": "11743",
    "hex": "0x80002ddf",
    "symbol": "TNKR",
    "name": "Tinkernet"
  },
  "12345": {
    "index": "12345",
    "hex": "0x80003039",
    "symbol": "IPOS",
    "name": "IPOS"
  },
  "12586": {
    "index": "12586",
    "hex": "0x8000312a",
    "symbol": "MINA",
    "name": "Mina"
  },
  "12850": {
    "index": "12850",
    "hex": "0x80003232",
    "symbol": "ANLOG",
    "name": "Analog Timechain"
  },
  "13107": {
    "index": "13107",
    "hex": "0x80003333",
    "symbol": "BTY",
    "name": "BitYuan"
  },
  "13108": {
    "index": "13108",
    "hex": "0x80003334",
    "symbol": "YCC",
    "name": "Yuan Chain Coin"
  },
  "13381": {
    "index": "13381",
    "hex": "0x80003445",
    "symbol": "PHX",
    "name": "Phoenix"
  },
  "14001": {
    "index": "14001",
    "hex": "0x800036b1",
    "symbol": "WAX",
    "name": "Worldwide Asset Exchange"
  },
  "15845": {
    "index": "15845",
    "hex": "0x80003de5",
    "symbol": "SDGO",
    "name": "SanDeGo"
  },
  "16181": {
    "index": "16181",
    "hex": "0x80003f35",
    "symbol": "XTX",
    "name": "Totem Live Network"
  },
  "16754": {
    "index": "16754",
    "hex": "0x80004172",
    "symbol": "ARDR",
    "name": "Ardor"
  },
  "18000": {
    "index": "18000",
    "hex": "0x80004650",
    "symbol": "MTR",
    "name": "Meter"
  },
  "19165": {
    "index": "19165",
    "hex": "0x80004add",
    "symbol": "SAFE",
    "name": "Safecoin"
  },
  "19167": {
    "index": "19167",
    "hex": "0x80004adf",
    "symbol": "FLUX",
    "name": "Flux"
  },
  "19169": {
    "index": "19169",
    "hex": "0x80004ae1",
    "symbol": "RITO",
    "name": "Ritocoin"
  },
  "19788": {
    "index": "19788",
    "hex": "0x80004d4c",
    "symbol": "ML",
    "name": "Mintlayer"
  },
  "20036": {
    "index": "20036",
    "hex": "0x80004e44",
    "symbol": "XND",
    "name": "ndau"
  },
  "21004": {
    "index": "21004",
    "hex": "0x8000520c",
    "symbol": "C4EI",
    "name": "c4ei"
  },
  "21337": {
    "index": "21337",
    "hex": "0x80005359",
    "symbol": "XAH",
    "name": "Xahau"
  },
  "21888": {
    "index": "21888",
    "hex": "0x80005580",
    "symbol": "PAC",
    "name": "Pactus"
  },
  "22504": {
    "index": "22504",
    "hex": "0x800057e8",
    "symbol": "PWR",
    "name": "PWRcoin"
  },
  "23000": {
    "index": "23000",
    "hex": "0x800059d8",
    "symbol": "EPIC",
    "name": "Epic Cash"
  },
  "25252": {
    "index": "25252",
    "hex": "0x800062a4",
    "symbol": "BELL",
    "name": "Bellcoin"
  },
  "25718": {
    "index": "25718",
    "hex": "0x80006476",
    "symbol": "CHX",
    "name": "Own"
  },
  "26417": {
    "index": "26417",
    "hex": "0x80006731",
    "symbol": "G1",
    "name": "Ğ1"
  },
  "29223": {
    "index": "29223",
    "hex": "0x80007227",
    "symbol": "NEXA",
    "name": "Nexa"
  },
  "31102": {
    "index": "31102",
    "hex": "0x8000797e",
    "symbol": "ESN",
    "name": "EtherSocial Network"
  },
  "31337": {
    "index": "31337",
    "hex": "0x80007a69",
    "symbol": "",
    "name": "ThePower"
  },
  "33416": {
    "index": "33416",
    "hex": "0x80008288",
    "symbol": "TEO",
    "name": "Trust Eth reOrigin"
  },
  "33878": {
    "index": "33878",
    "hex": "0x80008456",
    "symbol": "BTCS",
    "name": "Bitcoin Stake"
  },
  "34952": {
    "index": "34952",
    "hex": "0x80008888",
    "symbol": "BTT",
    "name": "ByteTrade"
  },
  "37992": {
    "index": "37992",
    "hex": "0x80009468",
    "symbol": "FXTC",
    "name": "FixedTradeCoin"
  },
  "39321": {
    "index": "39321",
    "hex": "0x80009999",
    "symbol": "AMA",
    "name": "Amabig"
  },
  "42069": {
    "index": "42069",
    "hex": "0x8000a455",
    "symbol": "FACT",
    "name": "FACT0RN"
  },
  "43028": {
    "index": "43028",
    "hex": "0x8000a814",
    "symbol": "AXIV",
    "name": "AXIV"
  },
  "47803": {
    "index": "47803",
    "hex": "0x8000babb",
    "symbol": "BAX",
    "name": "BAX"
  },
  "49262": {
    "index": "49262",
    "hex": "0x8000c06e",
    "symbol": "EVE",
    "name": "evan"
  },
  "49344": {
    "index": "49344",
    "hex": "0x8000c0c0",
    "symbol": "STASH",
    "name": "STASH"
  },
  "52752": {
    "index": "52752",
    "hex": "0x8000ce10",
    "symbol": "CELO",
    "name": "Celo"
  },
  "54176": {
    "index": "54176",
    "hex": "0x8000d3a0",
    "symbol": "OVER",
    "name": "OverProtocol"
  },
  "61616": {
    "index": "61616",
    "hex": "0x8000f0b0",
    "symbol": "TH",
    "name": "TianHe"
  },
  "65536": {
    "index": "65536",
    "hex": "0x80010000",
    "symbol": "KETH",
    "name": "Krypton World"
  },
  "69420": {
    "index": "69420",
    "hex": "0x80010f2c",
    "symbol": "GRLC",
    "name": "Garlicoin"
  },
  "70007": {
    "index": "70007",
    "hex": "0x80011177",
    "symbol": "GWL",
    "name": "Gewel"
  },
  "77777": {
    "index": "77777",
    "hex": "0x80012fd1",
    "symbol": "ZYN",
    "name": "Wethio"
  },
  "83293": {
    "index": "83293",
    "hex": "0x8001455d",
    "symbol": "QUBIC",
    "name": "Qubic"
  },
  "88888": {
    "index": "88888",
    "hex": "0x80015b38",
    "symbol": "RYO",
    "name": "c0ban"
  },
  "99999": {
    "index": "99999",
    "hex": "0x8001869f",
    "symbol": "WICC",
    "name": "Waykichain"
  },
  "100500": {
    "index": "100500",
    "hex": "0x80018894",
    "symbol": "HOME",
    "name": "HomeCoin"
  },
  "101010": {
    "index": "101010",
    "hex": "0x80018a92",
    "symbol": "STC",
    "name": "Starcoin"
  },
  "104109": {
    "index": "104109",
    "hex": "0x800196ad",
    "symbol": "",
    "name": "Seed Hypermedia"
  },
  "105105": {
    "index": "105105",
    "hex": "0x80019a91",
    "symbol": "STRAX",
    "name": "Strax"
  },
  "111111": {
    "index": "111111",
    "hex": "0x8001b207",
    "symbol": "KAS",
    "name": "Kaspa"
  },
  "121337": {
    "index": "121337",
    "hex": "0x8001d9f9",
    "symbol": "KLS",
    "name": "Karlsen"
  },
  "123456": {
    "index": "123456",
    "hex": "0x8001e240",
    "symbol": "SPR",
    "name": "Spectre"
  },
  "130822": {
    "index": "130822",
    "hex": "0x8001ff06",
    "symbol": "WBT",
    "name": "WhiteBIT Coin"
  },
  "161803": {
    "index": "161803",
    "hex": "0x8002780b",
    "symbol": "APTA",
    "name": "Bloqs4Good"
  },
  "200625": {
    "index": "200625",
    "hex": "0x80030fb1",
    "symbol": "AKA",
    "name": "Akroma"
  },
  "200901": {
    "index": "200901",
    "hex": "0x800310c5",
    "symbol": "BTR",
    "name": "Bitlayer"
  },
  "224433": {
    "index": "224433",
    "hex": "0x80036cb1",
    "symbol": "CONET",
    "name": "CONET Holesky Network"
  },
  "246529": {
    "index": "246529",
    "hex": "0x8003c301",
    "symbol": "ATS",
    "name": "ARTIS sigma1"
  },
  "261131": {
    "index": "261131",
    "hex": "0x8003fc0b",
    "symbol": "ZAMA",
    "name": "Zama"
  },
  "314159": {
    "index": "314159",
    "hex": "0x8004cb2f",
    "symbol": "PI",
    "name": "Pi Network"
  },
  "333332": {
    "index": "333332",
    "hex": "0x80051614",
    "symbol": "VALUE",
    "name": "Value Chain"
  },
  "333333": {
    "index": "333333",
    "hex": "0x80051615",
    "symbol": "3333",
    "name": "Pi Value Consensus"
  },
  "424242": {
    "index": "424242",
    "hex": "0x80067932",
    "symbol": "X42",
    "name": "x42"
  },
  "440017": {
    "index": "440017",
    "hex": "0x8006b6d1",
    "symbol": "@G",
    "name": "Graphite"
  },
  "534352": {
    "index": "534352",
    "hex": "0x80082750",
    "symbol": "SCR",
    "name": "Scroll"
  },
  "666666": {
    "index": "666666",
    "hex": "0x800a2c2a",
    "symbol": "VITE",
    "name": "Vite"
  },
  "696365": {
    "index": "696365",
    "hex": "0x800b3206",
    "symbol": "ICE",
    "name": "Ice Network"
  },
  "827166": {
    "index": "827166",
    "hex": "0x800c9f1e",
    "symbol": "",
    "name": "RGB on Bitcoin (mainnet)"
  },
  "827167": {
    "index": "827167",
    "hex": "0x800c9f1f",
    "symbol": "",
    "name": "RGB on Bitcoin (testnet)"
  },
  "828942": {
    "index": "828942",
    "hex": "0x800ca60e",
    "symbol": "",
    "name": "RGB on Liquid (mainnet)"
  },
  "888888": {
    "index": "888888",
    "hex": "0x800d9038",
    "symbol": "SEA",
    "name": "Second Exchange Alliance"
  },
  "1048576": {
    "index": "1048576",
    "hex": "0x80100000",
    "symbol": "AMAX",
    "name": "Armonia Meta Chain"
  },
  "1171337": {
    "index": "1171337",
    "hex": "0x8011df89",
    "symbol": "ILT",
    "name": "iOlite"
  },
  "1313114": {
    "index": "1313114",
    "hex": "0x8014095a",
    "symbol": "ETHO",
    "name": "Etho Protocol"
  },
  "1313500": {
    "index": "1313500",
    "hex": "0x80140adc",
    "symbol": "XERO",
    "name": "Xerom"
  },
  "1712144": {
    "index": "1712144",
    "hex": "0x801a2010",
    "symbol": "LAX",
    "name": "LAPO"
  },
  "3924011": {
    "index": "3924011",
    "hex": "0x803be02b",
    "symbol": "EPK",
    "name": "EPIK Protocol"
  },
  "4741444": {
    "index": "4741444",
    "hex": "0x80485944",
    "symbol": "HYD",
    "name": "Hydra Token"
  },
  "5063758": {
    "index": "5063758",
    "hex": "0x804d444e",
    "symbol": "",
    "name": "Miden"
  },
  "5249353": {
    "index": "5249353",
    "hex": "0x80501949",
    "symbol": "BCO",
    "name": "BitcoinOre"
  },
  "5249354": {
    "index": "5249354",
    "hex": "0x8050194a",
    "symbol": "BHD",
    "name": "BitcoinHD"
  },
  "5264462": {
    "index": "5264462",
    "hex": "0x8050544e",
    "symbol": "PTN",
    "name": "PalletOne"
  },
  "5655640": {
    "index": "5655640",
    "hex": "0x80564c58",
    "symbol": "VLX",
    "name": "Velas"
  },
  "5718350": {
    "index": "5718350",
    "hex": "0x8057414e",
    "symbol": "WAN",
    "name": "Wanchain"
  },
  "5741564": {
    "index": "5741564",
    "hex": "0x80579bfc",
    "symbol": "WAVES",
    "name": "Waves"
  },
  "5741565": {
    "index": "5741565",
    "hex": "0x80579bfd",
    "symbol": "WEST",
    "name": "Waves Enterprise"
  },
  "6382179": {
    "index": "6382179",
    "hex": "0x80616263",
    "symbol": "ABC",
    "name": "Abcmint"
  },
  "6517357": {
    "index": "6517357",
    "hex": "0x8063726d",
    "symbol": "CRM",
    "name": "Creamcoin"
  },
  "7171666": {
    "index": "7171666",
    "hex": "0x806d6e52",
    "symbol": "BROCK",
    "name": "Bitrock"
  },
  "7562605": {
    "index": "7562605",
    "hex": "0x8073656d",
    "symbol": "SEM",
    "name": "Semux"
  },
  "7567736": {
    "index": "7567736",
    "hex": "0x80737978",
    "symbol": "ION",
    "name": "ION"
  },
  "7777777": {
    "index": "7777777",
    "hex": "0x8076adf1",
    "symbol": "FCT",
    "name": "FirmaChain"
  },
  "7825266": {
    "index": "7825266",
    "hex": "0x80776772",
    "symbol": "WGR",
    "name": "WGR"
  },
  "7825267": {
    "index": "7825267",
    "hex": "0x80776773",
    "symbol": "OBSR",
    "name": "OBServer"
  },
  "8163271": {
    "index": "8163271",
    "hex": "0x807c8fc7",
    "symbol": "AFS",
    "name": "ANFS"
  },
  "10000118": {
    "index": "10000118",
    "hex": "0x805d30b6",
    "symbol": "OSMO",
    "name": "Osmosis"
  },
  "11259375": {
    "index": "11259375",
    "hex": "0x80abcdef",
    "symbol": "LBR",
    "name": "0L"
  },
  "15118976": {
    "index": "15118976",
    "hex": "0x80e6b280",
    "symbol": "XDS",
    "name": "XDS"
  },
  "19000118": {
    "index": "19000118",
    "hex": "0x8121eb36",
    "symbol": "SEI",
    "name": "SEI"
  },
  "20230101": {
    "index": "20230101",
    "hex": "0x8134afd5",
    "symbol": "ROH",
    "name": "Rooch"
  },
  "20240430": {
    "index": "20240430",
    "hex": "0x8134d82e",
    "symbol": "NLK",
    "name": "NuLinkCoin"
  },
  "22000118": {
    "index": "22000118",
    "hex": "0x814fb1f6",
    "symbol": "DYDX",
    "name": "Dydx"
  },
  "61717561": {
    "index": "61717561",
    "hex": "0x83adbc39",
    "symbol": "AQUA",
    "name": "Aquachain"
  },
  "77777777": {
    "index": "77777777",
    "hex": "0x84a2cb71",
    "symbol": "AZT",
    "name": "Aztecoin"
  },
  "88888888": {
    "index": "88888888",
    "hex": "0x854c5638",
    "symbol": "HATCH",
    "name": "Hatch"
  },
  "91927009": {
    "index": "91927009",
    "hex": "0x857ab1e1",
    "symbol": "kUSD",
    "name": "kUSD"
  },
  "99999996": {
    "index": "99999996",
    "hex": "0x85f5e0fc",
    "symbol": "GENS",
    "name": "GENS"
  },
  "99999997": {
    "index": "99999997",
    "hex": "0x85f5e0fd",
    "symbol": "EQ",
    "name": "EQ"
  },
  "99999998": {
    "index": "99999998",
    "hex": "0x85f5e0fe",
    "symbol": "FLUID",
    "name": "Fluid Chains"
  },
  "99999999": {
    "index": "99999999",
    "hex": "0x85f5e0ff",
    "symbol": "QKC",
    "name": "QuarkChain"
  },
  "240079435": {
    "index": "240079435",
    "hex": "0x8e4f524b",
    "symbol": "ZORK",
    "name": "Zork Network"
  },
  "608589380": {
    "index": "608589380",
    "hex": "0xa4465644",
    "symbol": "FVDC",
    "name": "ForumCoin"
  },
  "1010101010": {
    "index": "1010101010",
    "hex": "0xbc34eb12",
    "symbol": "FAIC",
    "name": "Free AI Chain"
  },
  "1179993420": {
    "index": "1179993420",
    "hex": "0xc655454c",
    "symbol": "",
    "name": "Fuel"
  },
  "1179993421": {
    "index": "1179993421",
    "hex": "0xc655454d",
    "symbol": "TTNC",
    "name": "TakeTitan"
  },
  "1179993431": {
    "index": "1179993431",
    "hex": "0xc6554557",
    "symbol": "MTGBP",
    "name": "MTGBP"
  },
  "1179993441": {
    "index": "1179993441",
    "hex": "0xc6554561",
    "symbol": "QFS",
    "name": "Qfs"
  },
  "1179993451": {
    "index": "1179993451",
    "hex": "0xc655456b",
    "symbol": "RWA",
    "name": "Asset Chain"
  },
  "1179993461": {
    "index": "1179993461",
    "hex": "0xc6554575",
    "symbol": "HXC",
    "name": "HuaXia Chain"
  },
  "1179993471": {
    "index": "1179993471",
    "hex": "0xc655457f",
    "symbol": "AME",
    "name": "AME Chain"
  }
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-utils>@metamask/slip44",file:"node_modules\\@metamask\\slip44\\slip44.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\dist\\SmartTransactionsController.cjs", {"./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\dist\\constants.cjs","./types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\dist\\types.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\dist\\utils.cjs","@ethersproject/bytes":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\bytes\\lib\\index.js","@metamask/controller-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\controller-utils\\dist\\index.cjs","@metamask/eth-query":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-query\\index.js","@metamask/polling-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\polling-controller\\dist\\index.cjs","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\node_modules\\bignumber.js\\bignumber.js","lodash/cloneDeep.js":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\cloneDeep.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csmart-transactions-controller%5Cdist%5CSmartTransactionsController.cjs
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _SmartTransactionsController_instances, _SmartTransactionsController_interval, _SmartTransactionsController_clientId, _SmartTransactionsController_chainId, _SmartTransactionsController_supportedChainIds, _SmartTransactionsController_ethQuery, _SmartTransactionsController_trackMetaMetricsEvent, _SmartTransactionsController_getMetaMetricsProps, _SmartTransactionsController_getFeatureFlags, _SmartTransactionsController_trace, _SmartTransactionsController_fetch, _SmartTransactionsController_updateSmartTransaction, _SmartTransactionsController_addMetaMetricsPropsToNewSmartTransaction, _SmartTransactionsController_createOrUpdateSmartTransaction, _SmartTransactionsController_doesTransactionNeedConfirmation, _SmartTransactionsController_confirmSmartTransaction, _SmartTransactionsController_addNonceToTransaction, _SmartTransactionsController_getChainId, _SmartTransactionsController_getChainIds, _SmartTransactionsController_getNetworkClientId, _SmartTransactionsController_getEthQuery, _SmartTransactionsController_getCurrentSmartTransactions, _SmartTransactionsController_wipeSmartTransactionsPerChainId;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmartTransactionsController = exports.getDefaultSmartTransactionsControllerState = exports.DEFAULT_INTERVAL = void 0;
const bytes_1 = require("@ethersproject/bytes");
const controller_utils_1 = require("@metamask/controller-utils");
const eth_query_1 = __importDefault(require("@metamask/eth-query"));
const polling_controller_1 = require("@metamask/polling-controller");
const transaction_controller_1 = require("@metamask/transaction-controller");
const bignumber_js_1 = require("bignumber.js");
const cloneDeep_1 = __importDefault(require("lodash/cloneDeep.js"));
const constants_1 = require("./constants.cjs");
const types_1 = require("./types.cjs");
const utils_1 = require("./utils.cjs");
const SECOND = 1000;
exports.DEFAULT_INTERVAL = SECOND * 5;
const ETH_QUERY_ERROR_MSG = '`ethQuery` is not defined on SmartTransactionsController';
/**
 * The name of the {@link SmartTransactionsController}
 */
const controllerName = 'SmartTransactionsController';
const controllerMetadata = {
    smartTransactionsState: {
        includeInStateLogs: true,
        persist: false,
        anonymous: true,
        usedInUi: true,
    },
};
/**
 * Get the default {@link SmartTransactionsController} state.
 *
 * @returns The default {@link SmartTransactionsController} state.
 */
function getDefaultSmartTransactionsControllerState() {
    return {
        smartTransactionsState: {
            smartTransactions: {},
            userOptIn: null,
            userOptInV2: null,
            fees: {
                approvalTxFees: null,
                tradeTxFees: null,
            },
            liveness: true,
            livenessByChainId: {
                [controller_utils_1.ChainId.mainnet]: true,
                [controller_utils_1.ChainId.sepolia]: true,
            },
            feesByChainId: {
                [controller_utils_1.ChainId.mainnet]: {
                    approvalTxFees: null,
                    tradeTxFees: null,
                },
                [controller_utils_1.ChainId.sepolia]: {
                    approvalTxFees: null,
                    tradeTxFees: null,
                },
            },
        },
    };
}
exports.getDefaultSmartTransactionsControllerState = getDefaultSmartTransactionsControllerState;
class SmartTransactionsController extends (0, polling_controller_1.StaticIntervalPollingController)() {
    constructor({ interval = exports.DEFAULT_INTERVAL, clientId, chainId: InitialChainId = controller_utils_1.ChainId.mainnet, supportedChainIds = [controller_utils_1.ChainId.mainnet, controller_utils_1.ChainId.sepolia], trackMetaMetricsEvent, state = {}, messenger, getMetaMetricsProps, getFeatureFlags, trace, }) {
        super({
            name: controllerName,
            metadata: controllerMetadata,
            messenger,
            state: Object.assign(Object.assign({}, getDefaultSmartTransactionsControllerState()), state),
        });
        _SmartTransactionsController_instances.add(this);
        _SmartTransactionsController_interval.set(this, void 0);
        _SmartTransactionsController_clientId.set(this, void 0);
        _SmartTransactionsController_chainId.set(this, void 0);
        _SmartTransactionsController_supportedChainIds.set(this, void 0);
        _SmartTransactionsController_ethQuery.set(this, void 0);
        _SmartTransactionsController_trackMetaMetricsEvent.set(this, void 0);
        _SmartTransactionsController_getMetaMetricsProps.set(this, void 0);
        _SmartTransactionsController_getFeatureFlags.set(this, void 0);
        _SmartTransactionsController_trace.set(this, void 0);
        __classPrivateFieldSet(this, _SmartTransactionsController_interval, interval, "f");
        __classPrivateFieldSet(this, _SmartTransactionsController_clientId, clientId, "f");
        __classPrivateFieldSet(this, _SmartTransactionsController_chainId, InitialChainId, "f");
        __classPrivateFieldSet(this, _SmartTransactionsController_supportedChainIds, supportedChainIds, "f");
        this.setIntervalLength(interval);
        __classPrivateFieldSet(this, _SmartTransactionsController_ethQuery, undefined, "f");
        __classPrivateFieldSet(this, _SmartTransactionsController_trackMetaMetricsEvent, trackMetaMetricsEvent, "f");
        __classPrivateFieldSet(this, _SmartTransactionsController_getMetaMetricsProps, getMetaMetricsProps, "f");
        __classPrivateFieldSet(this, _SmartTransactionsController_getFeatureFlags, getFeatureFlags, "f");
        __classPrivateFieldSet(this, _SmartTransactionsController_trace, trace !== null && trace !== void 0 ? trace : ((_request, fn) => fn === null || fn === void 0 ? void 0 : fn()), "f");
        this.initializeSmartTransactionsForChainId();
        this.messagingSystem.subscribe('NetworkController:stateChange', ({ selectedNetworkClientId }) => {
            const { configuration: { chainId }, provider, } = this.messagingSystem.call('NetworkController:getNetworkClientById', selectedNetworkClientId);
            __classPrivateFieldSet(this, _SmartTransactionsController_chainId, chainId, "f");
            __classPrivateFieldSet(this, _SmartTransactionsController_ethQuery, new eth_query_1.default(provider), "f");
            this.initializeSmartTransactionsForChainId();
            this.checkPoll(this.state);
        });
        this.messagingSystem.subscribe(`${controllerName}:stateChange`, (currentState) => this.checkPoll(currentState));
    }
    async _executePoll({ chainIds, }) {
        // if this is going to be truly UI driven polling we shouldn't really reach here
        // with a networkClientId that is not supported, but for now I'll add a check in case
        // wondering if we should add some kind of predicate to the polling controller to check whether
        // we should poll or not
        const filteredChainIds = (chainIds !== null && chainIds !== void 0 ? chainIds : []).filter((chainId) => __classPrivateFieldGet(this, _SmartTransactionsController_supportedChainIds, "f").includes(chainId));
        if (filteredChainIds.length === 0) {
            return Promise.resolve();
        }
        return this.updateSmartTransactions({ chainIds: filteredChainIds });
    }
    checkPoll({ smartTransactionsState: { smartTransactions }, }) {
        const smartTransactionsForAllChains = Object.values(smartTransactions).flat();
        const pendingTransactions = smartTransactionsForAllChains === null || smartTransactionsForAllChains === void 0 ? void 0 : smartTransactionsForAllChains.filter(utils_1.isSmartTransactionPending);
        if (!this.timeoutHandle && (pendingTransactions === null || pendingTransactions === void 0 ? void 0 : pendingTransactions.length) > 0) {
            this.poll();
        }
        else if (this.timeoutHandle && (pendingTransactions === null || pendingTransactions === void 0 ? void 0 : pendingTransactions.length) === 0) {
            this.stop();
        }
    }
    initializeSmartTransactionsForChainId() {
        if (__classPrivateFieldGet(this, _SmartTransactionsController_supportedChainIds, "f").includes(__classPrivateFieldGet(this, _SmartTransactionsController_chainId, "f"))) {
            this.update((state) => {
                var _a;
                state.smartTransactionsState.smartTransactions[__classPrivateFieldGet(this, _SmartTransactionsController_chainId, "f")] =
                    (_a = state.smartTransactionsState.smartTransactions[__classPrivateFieldGet(this, _SmartTransactionsController_chainId, "f")]) !== null && _a !== void 0 ? _a : [];
            });
        }
    }
    async poll(interval) {
        if (interval) {
            __classPrivateFieldSet(this, _SmartTransactionsController_interval, interval, "f");
        }
        this.timeoutHandle && clearInterval(this.timeoutHandle);
        if (!__classPrivateFieldGet(this, _SmartTransactionsController_supportedChainIds, "f").includes(__classPrivateFieldGet(this, _SmartTransactionsController_chainId, "f"))) {
            return;
        }
        this.timeoutHandle = setInterval(() => {
            (0, controller_utils_1.safelyExecute)(async () => this.updateSmartTransactions());
        }, __classPrivateFieldGet(this, _SmartTransactionsController_interval, "f"));
        await (0, controller_utils_1.safelyExecute)(async () => this.updateSmartTransactions());
    }
    async stop() {
        this.timeoutHandle && clearInterval(this.timeoutHandle);
        this.timeoutHandle = undefined;
    }
    setOptInState(optInState) {
        this.update((state) => {
            state.smartTransactionsState.userOptInV2 = optInState;
        });
    }
    trackStxStatusChange(smartTransaction, prevSmartTransaction) {
        let updatedSmartTransaction = (0, cloneDeep_1.default)(smartTransaction);
        updatedSmartTransaction = Object.assign(Object.assign({}, (0, cloneDeep_1.default)(prevSmartTransaction)), updatedSmartTransaction);
        if (updatedSmartTransaction.status === (prevSmartTransaction === null || prevSmartTransaction === void 0 ? void 0 : prevSmartTransaction.status)) {
            return; // If status hasn't changed, don't track it again.
        }
        __classPrivateFieldGet(this, _SmartTransactionsController_trackMetaMetricsEvent, "f").call(this, {
            event: constants_1.MetaMetricsEventName.StxStatusUpdated,
            category: constants_1.MetaMetricsEventCategory.Transactions,
            properties: (0, utils_1.getSmartTransactionMetricsProperties)(updatedSmartTransaction),
            sensitiveProperties: (0, utils_1.getSmartTransactionMetricsSensitiveProperties)(updatedSmartTransaction),
        });
    }
    isNewSmartTransaction(smartTransactionUuid, chainId) {
        const { smartTransactionsState: { smartTransactions }, } = this.state;
        const currentSmartTransactions = smartTransactions[chainId !== null && chainId !== void 0 ? chainId : __classPrivateFieldGet(this, _SmartTransactionsController_chainId, "f")];
        const currentIndex = currentSmartTransactions === null || currentSmartTransactions === void 0 ? void 0 : currentSmartTransactions.findIndex((stx) => stx.uuid === smartTransactionUuid);
        return currentIndex === -1 || currentIndex === undefined;
    }
    updateSmartTransaction(smartTransaction, { networkClientId } = {}) {
        let ethQuery = __classPrivateFieldGet(this, _SmartTransactionsController_ethQuery, "f");
        let chainId = __classPrivateFieldGet(this, _SmartTransactionsController_chainId, "f");
        if (networkClientId) {
            const { configuration, provider } = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId);
            chainId = configuration.chainId;
            ethQuery = new eth_query_1.default(provider);
        }
        __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_createOrUpdateSmartTransaction).call(this, smartTransaction, {
            chainId,
            ethQuery,
        });
    }
    async updateSmartTransactions({ chainIds, } = {
        chainIds: __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_getChainIds).call(this),
    }) {
        const { smartTransactionsState: { smartTransactions }, } = this.state;
        // Iterate over each chain group directly
        for (const [chainId, transactions] of Object.entries(smartTransactions)) {
            if (chainIds && !chainIds.includes(chainId)) {
                continue;
            }
            // Filter pending transactions and map them to the desired shape
            const pendingTransactions = transactions
                .filter(utils_1.isSmartTransactionPending)
                .map((pendingSmartTransaction) => {
                // Use the transaction's chainId (from the key) to derive a networkClientId
                const networkClientIdToUse = __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_getNetworkClientId).call(this, {
                    chainId: chainId,
                });
                return {
                    uuid: pendingSmartTransaction.uuid,
                    networkClientId: networkClientIdToUse,
                    chainId: pendingSmartTransaction.chainId, // same as the key, but explicit on the transaction
                };
            });
            if (pendingTransactions.length > 0) {
                // Since each group is per chain, all transactions share the same chainId.
                await this.fetchSmartTransactionsStatus(pendingTransactions);
            }
        }
    }
    // ! Ask backend API to accept list of uuids as params
    async fetchSmartTransactionsStatus(transactions) {
        // Since transactions come from the same chain group, take the chainId from the first one.
        const { chainId } = transactions[0];
        // Build query parameters with all UUIDs
        const uuids = transactions.map((tx) => tx.uuid);
        const params = new URLSearchParams({ uuids: uuids.join(',') });
        // Get the ethQuery for the first transaction's networkClientId
        const ethQuery = __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_getEthQuery).call(this, {
            networkClientId: transactions[0].networkClientId,
        });
        // Construct the URL and fetch the data
        const url = `${(0, utils_1.getAPIRequestURL)(types_1.APIType.BATCH_STATUS, chainId)}?${params.toString()}`;
        const data = (await __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_fetch).call(this, url));
        // Process each returned status
        for (const [uuid, stxStatus] of Object.entries(data)) {
            const matchingTx = transactions.find((tx) => tx.uuid === uuid);
            if (!matchingTx) {
                console.error(`No matching transaction found for uuid: ${uuid}`);
                continue;
            }
            const smartTransaction = {
                statusMetadata: stxStatus,
                status: (0, utils_1.calculateStatus)(stxStatus),
                cancellable: (0, utils_1.isSmartTransactionCancellable)(stxStatus),
                uuid,
                networkClientId: matchingTx.networkClientId,
            };
            await __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_createOrUpdateSmartTransaction).call(this, smartTransaction, {
                chainId,
                ethQuery,
            });
        }
        return data;
    }
    clearFees() {
        const fees = {
            approvalTxFees: null,
            tradeTxFees: null,
        };
        this.update((state) => {
            state.smartTransactionsState.fees = fees;
        });
        return fees;
    }
    async getFees(tradeTx, approvalTx, { networkClientId } = {}) {
        const selectedNetworkClientId = networkClientId !== null && networkClientId !== void 0 ? networkClientId : this.messagingSystem.call('NetworkController:getState')
            .selectedNetworkClientId;
        const chainId = __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_getChainId).call(this, {
            networkClientId: selectedNetworkClientId,
        });
        const transactions = [];
        let unsignedTradeTransactionWithNonce;
        if (approvalTx) {
            const unsignedApprovalTransactionWithNonce = await __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_addNonceToTransaction).call(this, approvalTx, selectedNetworkClientId);
            transactions.push(unsignedApprovalTransactionWithNonce);
            unsignedTradeTransactionWithNonce = Object.assign(Object.assign({}, tradeTx), { 
                // If there is an approval tx, the trade tx's nonce is increased by 1.
                nonce: (0, utils_1.incrementNonceInHex)(unsignedApprovalTransactionWithNonce.nonce) });
        }
        else if (tradeTx.nonce) {
            unsignedTradeTransactionWithNonce = tradeTx;
        }
        else {
            unsignedTradeTransactionWithNonce = await __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_addNonceToTransaction).call(this, tradeTx, selectedNetworkClientId);
        }
        transactions.push(unsignedTradeTransactionWithNonce);
        const data = await __classPrivateFieldGet(this, _SmartTransactionsController_trace, "f").call(this, { name: constants_1.SmartTransactionsTraceName.GetFees }, async () => await __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_fetch).call(this, (0, utils_1.getAPIRequestURL)(types_1.APIType.GET_FEES, chainId), {
            method: 'POST',
            body: JSON.stringify({
                txs: transactions,
            }),
        }));
        let approvalTxFees;
        let tradeTxFees;
        if (approvalTx) {
            approvalTxFees = data === null || data === void 0 ? void 0 : data.txs[0];
            tradeTxFees = data === null || data === void 0 ? void 0 : data.txs[1];
        }
        else {
            approvalTxFees = null;
            tradeTxFees = data === null || data === void 0 ? void 0 : data.txs[0];
        }
        this.update((state) => {
            if (chainId === __classPrivateFieldGet(this, _SmartTransactionsController_chainId, "f")) {
                state.smartTransactionsState.fees = {
                    approvalTxFees,
                    tradeTxFees,
                };
            }
            state.smartTransactionsState.feesByChainId[chainId] = {
                approvalTxFees,
                tradeTxFees,
            };
        });
        return {
            approvalTxFees,
            tradeTxFees,
        };
    }
    // * After this successful call client must add a nonce representative to
    // * transaction controller external transactions list
    async submitSignedTransactions({ transactionMeta, txParams, signedTransactions, signedCanceledTransactions = [], networkClientId, }) {
        var _a, _b;
        const selectedNetworkClientId = networkClientId !== null && networkClientId !== void 0 ? networkClientId : this.messagingSystem.call('NetworkController:getState')
            .selectedNetworkClientId;
        const chainId = __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_getChainId).call(this, {
            networkClientId: selectedNetworkClientId,
        });
        const ethQuery = __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_getEthQuery).call(this, {
            networkClientId: selectedNetworkClientId,
        });
        const data = await __classPrivateFieldGet(this, _SmartTransactionsController_trace, "f").call(this, { name: constants_1.SmartTransactionsTraceName.SubmitTransactions }, async () => await __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_fetch).call(this, (0, utils_1.getAPIRequestURL)(types_1.APIType.SUBMIT_TRANSACTIONS, chainId), {
            method: 'POST',
            body: JSON.stringify({
                rawTxs: signedTransactions,
                rawCancelTxs: signedCanceledTransactions,
            }),
        }));
        const time = Date.now();
        let preTxBalance;
        try {
            if (txParams === null || txParams === void 0 ? void 0 : txParams.from) {
                const preTxBalanceBN = await (0, controller_utils_1.query)(ethQuery, 'getBalance', [
                    txParams.from,
                ]);
                preTxBalance = new bignumber_js_1.BigNumber(preTxBalanceBN).toString(16);
            }
        }
        catch (error) {
            console.error('ethQuery.getBalance error:', error);
        }
        const requiresNonce = txParams && !txParams.nonce;
        let nonce;
        let nonceLock;
        let nonceDetails = {};
        // This should only happen for Swaps. Non-swaps transactions should already have a nonce
        if (requiresNonce) {
            try {
                nonceLock = await this.messagingSystem.call('TransactionController:getNonceLock', txParams.from, selectedNetworkClientId);
                nonce = (0, bytes_1.hexlify)(nonceLock.nextNonce);
                nonceDetails = nonceLock.nonceDetails;
                (_a = txParams.nonce) !== null && _a !== void 0 ? _a : (txParams.nonce = nonce);
            }
            catch (error) {
                console.error('Failed to acquire nonce lock:', error);
                throw error;
            }
        }
        const txHashes = signedTransactions.map((tx) => (0, utils_1.getTxHash)(tx));
        const submitTransactionResponse = Object.assign(Object.assign({}, data), { txHash: txHashes[txHashes.length - 1], // For backward compatibility - use the last tx hash
            txHashes });
        try {
            await __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_createOrUpdateSmartTransaction).call(this, {
                chainId,
                nonceDetails,
                preTxBalance,
                status: types_1.SmartTransactionStatuses.PENDING,
                time,
                txParams,
                uuid: submitTransactionResponse.uuid,
                txHash: submitTransactionResponse.txHash,
                cancellable: true,
                type: (_b = transactionMeta === null || transactionMeta === void 0 ? void 0 : transactionMeta.type) !== null && _b !== void 0 ? _b : 'swap',
                transactionId: transactionMeta === null || transactionMeta === void 0 ? void 0 : transactionMeta.id,
                networkClientId: selectedNetworkClientId,
                txHashes, // Add support for multiple transaction hashes
            }, { chainId, ethQuery });
        }
        catch (error) {
            console.error('Failed to create a smart transaction:', error);
            throw error;
        }
        finally {
            if (nonceLock) {
                nonceLock.releaseLock();
            }
        }
        return submitTransactionResponse;
    }
    // TODO: This should return if the cancellation was on chain or not (for nonce management)
    // After this successful call client must update nonce representative
    // in transaction controller external transactions list
    async cancelSmartTransaction(uuid, { networkClientId, } = {}) {
        const chainId = __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_getChainId).call(this, { networkClientId });
        await __classPrivateFieldGet(this, _SmartTransactionsController_trace, "f").call(this, { name: constants_1.SmartTransactionsTraceName.CancelTransaction }, async () => await __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_fetch).call(this, (0, utils_1.getAPIRequestURL)(types_1.APIType.CANCEL, chainId), {
            method: 'POST',
            body: JSON.stringify({ uuid }),
        }));
    }
    async fetchLiveness({ networkClientId, } = {}) {
        const chainId = __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_getChainId).call(this, { networkClientId });
        let liveness = false;
        try {
            const response = await __classPrivateFieldGet(this, _SmartTransactionsController_trace, "f").call(this, { name: constants_1.SmartTransactionsTraceName.FetchLiveness }, async () => await __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_fetch).call(this, (0, utils_1.getAPIRequestURL)(types_1.APIType.LIVENESS, chainId)));
            liveness = Boolean(response.smartTransactions);
        }
        catch (error) {
            console.log('"fetchLiveness" API call failed');
        }
        this.update((state) => {
            if (chainId === __classPrivateFieldGet(this, _SmartTransactionsController_chainId, "f")) {
                state.smartTransactionsState.liveness = liveness;
            }
            state.smartTransactionsState.livenessByChainId[chainId] = liveness;
        });
        return liveness;
    }
    async setStatusRefreshInterval(interval) {
        if (interval !== __classPrivateFieldGet(this, _SmartTransactionsController_interval, "f")) {
            __classPrivateFieldSet(this, _SmartTransactionsController_interval, interval, "f");
        }
    }
    getTransactions({ addressFrom, status, }) {
        const currentSmartTransactions = __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_getCurrentSmartTransactions).call(this);
        return currentSmartTransactions.filter((stx) => {
            var _a;
            return stx.status === status && ((_a = stx.txParams) === null || _a === void 0 ? void 0 : _a.from) === addressFrom;
        });
    }
    getSmartTransactionByMinedTxHash(txHash) {
        if (!txHash) {
            return undefined;
        }
        const currentSmartTransactions = __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_getCurrentSmartTransactions).call(this);
        return currentSmartTransactions.find((smartTransaction) => {
            var _a, _b;
            return (((_b = (_a = smartTransaction.statusMetadata) === null || _a === void 0 ? void 0 : _a.minedHash) === null || _b === void 0 ? void 0 : _b.toLowerCase()) ===
                txHash.toLowerCase());
        });
    }
    wipeSmartTransactions({ address, ignoreNetwork, }) {
        if (!address) {
            return;
        }
        const addressLowerCase = address.toLowerCase();
        if (ignoreNetwork) {
            const { smartTransactionsState: { smartTransactions }, } = this.state;
            Object.keys(smartTransactions).forEach((chainId) => {
                __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_wipeSmartTransactionsPerChainId).call(this, {
                    chainId,
                    addressLowerCase,
                });
            });
        }
        else {
            __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_wipeSmartTransactionsPerChainId).call(this, {
                chainId: __classPrivateFieldGet(this, _SmartTransactionsController_chainId, "f"),
                addressLowerCase,
            });
        }
    }
}
exports.SmartTransactionsController = SmartTransactionsController;
_SmartTransactionsController_interval = new WeakMap(), _SmartTransactionsController_clientId = new WeakMap(), _SmartTransactionsController_chainId = new WeakMap(), _SmartTransactionsController_supportedChainIds = new WeakMap(), _SmartTransactionsController_ethQuery = new WeakMap(), _SmartTransactionsController_trackMetaMetricsEvent = new WeakMap(), _SmartTransactionsController_getMetaMetricsProps = new WeakMap(), _SmartTransactionsController_getFeatureFlags = new WeakMap(), _SmartTransactionsController_trace = new WeakMap(), _SmartTransactionsController_instances = new WeakSet(), _SmartTransactionsController_fetch = 
/* istanbul ignore next */
async function _SmartTransactionsController_fetch(request, options) {
    const fetchOptions = Object.assign(Object.assign({}, options), { headers: Object.assign({ 'Content-Type': 'application/json' }, (__classPrivateFieldGet(this, _SmartTransactionsController_clientId, "f") && { 'X-Client-Id': __classPrivateFieldGet(this, _SmartTransactionsController_clientId, "f") })) });
    return (0, utils_1.handleFetch)(request, fetchOptions);
}, _SmartTransactionsController_updateSmartTransaction = function _SmartTransactionsController_updateSmartTransaction(smartTransaction, { chainId = __classPrivateFieldGet(this, _SmartTransactionsController_chainId, "f"), }) {
    var _a;
    const { smartTransactionsState: { smartTransactions }, } = this.state;
    const currentSmartTransactions = (_a = smartTransactions[chainId]) !== null && _a !== void 0 ? _a : [];
    const currentIndex = currentSmartTransactions === null || currentSmartTransactions === void 0 ? void 0 : currentSmartTransactions.findIndex((stx) => stx.uuid === smartTransaction.uuid);
    if (currentIndex === -1) {
        return; // Smart transaction not found, don't update anything.
    }
    if (!(0, controller_utils_1.isSafeDynamicKey)(chainId)) {
        return;
    }
    this.update((state) => {
        state.smartTransactionsState.smartTransactions[chainId][currentIndex] = Object.assign(Object.assign({}, state.smartTransactionsState.smartTransactions[chainId][currentIndex]), smartTransaction);
    });
}, _SmartTransactionsController_addMetaMetricsPropsToNewSmartTransaction = async function _SmartTransactionsController_addMetaMetricsPropsToNewSmartTransaction(smartTransaction) {
    const metaMetricsProps = await __classPrivateFieldGet(this, _SmartTransactionsController_getMetaMetricsProps, "f").call(this);
    smartTransaction.accountHardwareType =
        metaMetricsProps === null || metaMetricsProps === void 0 ? void 0 : metaMetricsProps.accountHardwareType;
    smartTransaction.accountType = metaMetricsProps === null || metaMetricsProps === void 0 ? void 0 : metaMetricsProps.accountType;
    smartTransaction.deviceModel = metaMetricsProps === null || metaMetricsProps === void 0 ? void 0 : metaMetricsProps.deviceModel;
}, _SmartTransactionsController_createOrUpdateSmartTransaction = async function _SmartTransactionsController_createOrUpdateSmartTransaction(smartTransaction, { chainId = __classPrivateFieldGet(this, _SmartTransactionsController_chainId, "f"), ethQuery = __classPrivateFieldGet(this, _SmartTransactionsController_ethQuery, "f"), }) {
    var _a;
    const { smartTransactionsState: { smartTransactions }, } = this.state;
    const currentSmartTransactions = (_a = smartTransactions[chainId]) !== null && _a !== void 0 ? _a : [];
    const currentIndex = currentSmartTransactions === null || currentSmartTransactions === void 0 ? void 0 : currentSmartTransactions.findIndex((stx) => stx.uuid === smartTransaction.uuid);
    const isNewSmartTransaction = this.isNewSmartTransaction(smartTransaction.uuid, chainId);
    if (ethQuery === undefined) {
        throw new Error(ETH_QUERY_ERROR_MSG);
    }
    if (isNewSmartTransaction) {
        try {
            await __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_addMetaMetricsPropsToNewSmartTransaction).call(this, smartTransaction);
        }
        catch (error) {
            console.error('Failed to add metrics props to smart transaction:', error);
            // Continue without metrics props
        }
    }
    this.trackStxStatusChange(smartTransaction, isNewSmartTransaction
        ? undefined
        : currentSmartTransactions[currentIndex]);
    if (isNewSmartTransaction) {
        // add smart transaction
        const cancelledNonceIndex = currentSmartTransactions === null || currentSmartTransactions === void 0 ? void 0 : currentSmartTransactions.findIndex((stx) => {
            var _a, _b, _c;
            return ((_a = stx.txParams) === null || _a === void 0 ? void 0 : _a.nonce) === ((_b = smartTransaction.txParams) === null || _b === void 0 ? void 0 : _b.nonce) &&
                ((_c = stx.status) === null || _c === void 0 ? void 0 : _c.startsWith('cancelled'));
        });
        const snapshot = (0, cloneDeep_1.default)(smartTransaction);
        const history = [snapshot];
        const historifiedSmartTransaction = Object.assign(Object.assign({}, smartTransaction), { history });
        const nextSmartTransactions = cancelledNonceIndex > -1
            ? currentSmartTransactions
                .slice(0, cancelledNonceIndex)
                .concat(currentSmartTransactions.slice(cancelledNonceIndex + 1))
                .concat(historifiedSmartTransaction)
            : currentSmartTransactions.concat(historifiedSmartTransaction);
        this.update((state) => {
            state.smartTransactionsState.smartTransactions[chainId] =
                nextSmartTransactions;
        });
        return;
    }
    const currentSmartTransaction = currentSmartTransactions[currentIndex];
    const nextSmartTransaction = Object.assign(Object.assign({}, currentSmartTransaction), smartTransaction);
    // We have to emit this event here, because then a txHash is returned to the TransactionController once it's available
    // and the #doesTransactionNeedConfirmation function will work properly, since it will find the txHash in the regular transactions list.
    this.messagingSystem.publish(`SmartTransactionsController:smartTransaction`, nextSmartTransaction);
    if ((0, utils_1.shouldMarkRegularTransactionAsFailed)({
        smartTransaction: nextSmartTransaction,
        clientId: __classPrivateFieldGet(this, _SmartTransactionsController_clientId, "f"),
        getFeatureFlags: __classPrivateFieldGet(this, _SmartTransactionsController_getFeatureFlags, "f"),
    })) {
        (0, utils_1.markRegularTransactionAsFailed)({
            smartTransaction: nextSmartTransaction,
            getRegularTransactions: () => this.messagingSystem.call('TransactionController:getTransactions'),
            updateTransaction: (transactionMeta, note) => this.messagingSystem.call('TransactionController:updateTransaction', transactionMeta, note),
        });
    }
    if ((smartTransaction.status === types_1.SmartTransactionStatuses.SUCCESS ||
        smartTransaction.status === types_1.SmartTransactionStatuses.REVERTED) &&
        !smartTransaction.confirmed) {
        await __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_confirmSmartTransaction).call(this, nextSmartTransaction, {
            chainId,
            ethQuery,
        });
    }
    else {
        __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_updateSmartTransaction).call(this, smartTransaction, {
            chainId,
        });
    }
}, _SmartTransactionsController_doesTransactionNeedConfirmation = function _SmartTransactionsController_doesTransactionNeedConfirmation(txHash) {
    if (!txHash) {
        return true;
    }
    const transactions = this.messagingSystem.call('TransactionController:getTransactions');
    const foundTransaction = transactions === null || transactions === void 0 ? void 0 : transactions.find((tx) => {
        var _a;
        return ((_a = tx.hash) === null || _a === void 0 ? void 0 : _a.toLowerCase()) === txHash.toLowerCase();
    });
    if (!foundTransaction) {
        return true;
    }
    // If a found transaction is either confirmed or submitted, it doesn't need confirmation from the STX controller.
    // When it's in the submitted state, the TransactionController checks its status and confirms it,
    // so no need to confirm it again here.
    return ![transaction_controller_1.TransactionStatus.confirmed, transaction_controller_1.TransactionStatus.submitted].includes(foundTransaction.status);
}, _SmartTransactionsController_confirmSmartTransaction = async function _SmartTransactionsController_confirmSmartTransaction(smartTransaction, { chainId = __classPrivateFieldGet(this, _SmartTransactionsController_chainId, "f"), ethQuery = __classPrivateFieldGet(this, _SmartTransactionsController_ethQuery, "f"), }) {
    var _a;
    if (ethQuery === undefined) {
        throw new Error(ETH_QUERY_ERROR_MSG);
    }
    const txHash = (_a = smartTransaction.statusMetadata) === null || _a === void 0 ? void 0 : _a.minedHash;
    try {
        const transactionReceipt = await (0, controller_utils_1.query)(ethQuery, 'getTransactionReceipt', [txHash]);
        const transaction = await (0, controller_utils_1.query)(ethQuery, 'getTransactionByHash', [txHash]);
        const maxFeePerGas = transaction === null || transaction === void 0 ? void 0 : transaction.maxFeePerGas;
        const maxPriorityFeePerGas = transaction === null || transaction === void 0 ? void 0 : transaction.maxPriorityFeePerGas;
        if (transactionReceipt === null || transactionReceipt === void 0 ? void 0 : transactionReceipt.blockNumber) {
            const blockData = await (0, controller_utils_1.query)(ethQuery, 'getBlockByNumber', [transactionReceipt === null || transactionReceipt === void 0 ? void 0 : transactionReceipt.blockNumber, false]);
            const baseFeePerGas = blockData === null || blockData === void 0 ? void 0 : blockData.baseFeePerGas;
            const updatedTxParams = Object.assign(Object.assign({}, smartTransaction.txParams), { maxFeePerGas,
                maxPriorityFeePerGas });
            // call confirmExternalTransaction
            const originalTxMeta = Object.assign(Object.assign({}, smartTransaction), { id: smartTransaction.uuid, status: transaction_controller_1.TransactionStatus.confirmed, hash: txHash, txParams: updatedTxParams });
            // create txMeta snapshot for history
            const snapshot = (0, utils_1.snapshotFromTxMeta)(originalTxMeta);
            // recover previous tx state obj
            const previousState = (0, utils_1.replayHistory)(originalTxMeta.history);
            // generate history entry and add to history
            const entry = (0, utils_1.generateHistoryEntry)(previousState, snapshot, 'txStateManager: setting status to confirmed');
            const txMeta = entry.length > 0
                ? Object.assign(Object.assign({}, originalTxMeta), { history: originalTxMeta.history.concat(entry) }) : originalTxMeta;
            if (__classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_doesTransactionNeedConfirmation).call(this, txHash)) {
                this.messagingSystem.call('TransactionController:confirmExternalTransaction', 
                // TODO: Replace 'as' assertion with correct typing for `txMeta`
                txMeta, transactionReceipt, 
                // TODO: Replace 'as' assertion with correct typing for `baseFeePerGas`
                baseFeePerGas);
            }
            __classPrivateFieldGet(this, _SmartTransactionsController_trackMetaMetricsEvent, "f").call(this, {
                event: constants_1.MetaMetricsEventName.StxConfirmed,
                category: constants_1.MetaMetricsEventCategory.Transactions,
                properties: (0, utils_1.getSmartTransactionMetricsProperties)(smartTransaction),
                sensitiveProperties: (0, utils_1.getSmartTransactionMetricsSensitiveProperties)(smartTransaction),
            });
            __classPrivateFieldGet(this, _SmartTransactionsController_instances, "m", _SmartTransactionsController_updateSmartTransaction).call(this, Object.assign(Object.assign({}, smartTransaction), { confirmed: true }), {
                chainId,
            });
        }
    }
    catch (error) {
        __classPrivateFieldGet(this, _SmartTransactionsController_trackMetaMetricsEvent, "f").call(this, {
            event: constants_1.MetaMetricsEventName.StxConfirmationFailed,
            category: constants_1.MetaMetricsEventCategory.Transactions,
        });
        console.error('confirm error', error);
    }
    finally {
        this.messagingSystem.publish(`SmartTransactionsController:smartTransactionConfirmationDone`, smartTransaction);
    }
}, _SmartTransactionsController_addNonceToTransaction = async function _SmartTransactionsController_addNonceToTransaction(transaction, networkClientId) {
    const nonceLock = await this.messagingSystem.call('TransactionController:getNonceLock', transaction.from, networkClientId);
    const nonce = nonceLock.nextNonce;
    nonceLock.releaseLock();
    return Object.assign(Object.assign({}, transaction), { nonce: `0x${nonce.toString(16)}` });
}, _SmartTransactionsController_getChainId = function _SmartTransactionsController_getChainId({ networkClientId, } = {}) {
    if (networkClientId) {
        return this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId).configuration.chainId;
    }
    return __classPrivateFieldGet(this, _SmartTransactionsController_chainId, "f");
}, _SmartTransactionsController_getChainIds = function _SmartTransactionsController_getChainIds() {
    const { networkConfigurationsByChainId } = this.messagingSystem.call('NetworkController:getState');
    return Object.keys(networkConfigurationsByChainId).filter((chainId) => __classPrivateFieldGet(this, _SmartTransactionsController_supportedChainIds, "f").includes(chainId));
}, _SmartTransactionsController_getNetworkClientId = function _SmartTransactionsController_getNetworkClientId({ chainId }) {
    const { networkConfigurationsByChainId } = this.messagingSystem.call('NetworkController:getState');
    return networkConfigurationsByChainId[chainId].rpcEndpoints[networkConfigurationsByChainId[chainId].defaultRpcEndpointIndex].networkClientId;
}, _SmartTransactionsController_getEthQuery = function _SmartTransactionsController_getEthQuery({ networkClientId, } = {}) {
    if (networkClientId) {
        const { provider } = this.messagingSystem.call('NetworkController:getNetworkClientById', networkClientId);
        return new eth_query_1.default(provider);
    }
    if (__classPrivateFieldGet(this, _SmartTransactionsController_ethQuery, "f") === undefined) {
        throw new Error(ETH_QUERY_ERROR_MSG);
    }
    return __classPrivateFieldGet(this, _SmartTransactionsController_ethQuery, "f");
}, _SmartTransactionsController_getCurrentSmartTransactions = function _SmartTransactionsController_getCurrentSmartTransactions() {
    const { smartTransactionsState: { smartTransactions }, } = this.state;
    const smartTransactionsForAllChains = Object.values(smartTransactions).flat();
    if (!smartTransactionsForAllChains ||
        smartTransactionsForAllChains.length === 0) {
        return [];
    }
    return smartTransactionsForAllChains;
}, _SmartTransactionsController_wipeSmartTransactionsPerChainId = function _SmartTransactionsController_wipeSmartTransactionsPerChainId({ chainId, addressLowerCase, }) {
    const { smartTransactionsState: { smartTransactions }, } = this.state;
    const smartTransactionsForSelectedChain = smartTransactions === null || smartTransactions === void 0 ? void 0 : smartTransactions[chainId];
    if (!smartTransactionsForSelectedChain ||
        smartTransactionsForSelectedChain.length === 0) {
        return;
    }
    const newSmartTransactionsForSelectedChain = smartTransactionsForSelectedChain.filter((smartTransaction) => { var _a; return ((_a = smartTransaction.txParams) === null || _a === void 0 ? void 0 : _a.from) !== addressLowerCase; });
    this.update((state) => {
        state.smartTransactionsState.smartTransactions[chainId] =
            newSmartTransactionsForSelectedChain;
    });
};

      };
    };
  }
  }
}, {package:"@metamask/smart-transactions-controller",file:"node_modules\\@metamask\\smart-transactions-controller\\dist\\SmartTransactionsController.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\dist\\constants.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csmart-transactions-controller%5Cdist%5Cconstants.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmartTransactionsTraceName = exports.MetaMetricsEventCategory = exports.MetaMetricsEventName = exports.SENTINEL_API_BASE_URL_MAP = exports.API_BASE_URL = void 0;
exports.API_BASE_URL = 'https://transaction.api.cx.metamask.io';
// The map with types applied
exports.SENTINEL_API_BASE_URL_MAP = {
    1: 'https://tx-sentinel-ethereum-mainnet.api.cx.metamask.io',
    56: 'https://tx-sentinel-bsc-mainnet.api.cx.metamask.io',
    8453: 'https://tx-sentinel-base-mainnet.api.cx.metamask.io',
    42161: 'https://tx-sentinel-arbitrum-mainnet.api.cx.metamask.io',
    59144: 'https://tx-sentinel-linea-mainnet.api.cx.metamask.io',
    11155111: 'https://tx-sentinel-ethereum-sepolia.api.cx.metamask.io',
};
var MetaMetricsEventName;
(function (MetaMetricsEventName) {
    MetaMetricsEventName["StxStatusUpdated"] = "STX Status Updated";
    MetaMetricsEventName["StxConfirmed"] = "STX Confirmed";
    MetaMetricsEventName["StxConfirmationFailed"] = "STX Confirmation Failed";
    MetaMetricsEventName["ReceiveRequest"] = "Receive Request";
})(MetaMetricsEventName = exports.MetaMetricsEventName || (exports.MetaMetricsEventName = {}));
var MetaMetricsEventCategory;
(function (MetaMetricsEventCategory) {
    MetaMetricsEventCategory["Transactions"] = "Transactions";
    MetaMetricsEventCategory["Navigation"] = "Navigation";
})(MetaMetricsEventCategory = exports.MetaMetricsEventCategory || (exports.MetaMetricsEventCategory = {}));
var SmartTransactionsTraceName;
(function (SmartTransactionsTraceName) {
    SmartTransactionsTraceName["GetFees"] = "Smart Transactions: Get Fees";
    SmartTransactionsTraceName["SubmitTransactions"] = "Smart Transactions: Submit Transactions";
    SmartTransactionsTraceName["CancelTransaction"] = "Smart Transactions: Cancel Transaction";
    SmartTransactionsTraceName["FetchLiveness"] = "Smart Transactions: Fetch Liveness";
})(SmartTransactionsTraceName = exports.SmartTransactionsTraceName || (exports.SmartTransactionsTraceName = {}));

      };
    };
  }
  }
}, {package:"@metamask/smart-transactions-controller",file:"node_modules\\@metamask\\smart-transactions-controller\\dist\\constants.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\dist\\index.cjs", {"./SmartTransactionsController.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\dist\\SmartTransactionsController.cjs","./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\dist\\constants.cjs","./types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\dist\\types.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\dist\\utils.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csmart-transactions-controller%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSmartTransactionMetricsSensitiveProperties = exports.getSmartTransactionMetricsProperties = exports.MetaMetricsEventCategory = exports.MetaMetricsEventName = exports.ClientId = exports.SmartTransactionStatuses = exports.SmartTransactionCancellationReason = exports.SmartTransactionMinedTx = exports.SmartTransactionsController = void 0;
var SmartTransactionsController_1 = require("./SmartTransactionsController.cjs");
Object.defineProperty(exports, "SmartTransactionsController", { enumerable: true, get: function () { return SmartTransactionsController_1.SmartTransactionsController; } });
var types_1 = require("./types.cjs");
Object.defineProperty(exports, "SmartTransactionMinedTx", { enumerable: true, get: function () { return types_1.SmartTransactionMinedTx; } });
Object.defineProperty(exports, "SmartTransactionCancellationReason", { enumerable: true, get: function () { return types_1.SmartTransactionCancellationReason; } });
Object.defineProperty(exports, "SmartTransactionStatuses", { enumerable: true, get: function () { return types_1.SmartTransactionStatuses; } });
Object.defineProperty(exports, "ClientId", { enumerable: true, get: function () { return types_1.ClientId; } });
var constants_1 = require("./constants.cjs");
Object.defineProperty(exports, "MetaMetricsEventName", { enumerable: true, get: function () { return constants_1.MetaMetricsEventName; } });
Object.defineProperty(exports, "MetaMetricsEventCategory", { enumerable: true, get: function () { return constants_1.MetaMetricsEventCategory; } });
var utils_1 = require("./utils.cjs");
Object.defineProperty(exports, "getSmartTransactionMetricsProperties", { enumerable: true, get: function () { return utils_1.getSmartTransactionMetricsProperties; } });
Object.defineProperty(exports, "getSmartTransactionMetricsSensitiveProperties", { enumerable: true, get: function () { return utils_1.getSmartTransactionMetricsSensitiveProperties; } });

      };
    };
  }
  }
}, {package:"@metamask/smart-transactions-controller",file:"node_modules\\@metamask\\smart-transactions-controller\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\dist\\types.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csmart-transactions-controller%5Cdist%5Ctypes.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cancellationReasonToStatusMap = exports.ClientId = exports.SmartTransactionStatuses = exports.SmartTransactionCancellationReason = exports.SmartTransactionMinedTx = exports.APIType = void 0;
/** API */
var APIType;
(function (APIType) {
    APIType[APIType["GET_FEES"] = 0] = "GET_FEES";
    APIType[APIType["ESTIMATE_GAS"] = 1] = "ESTIMATE_GAS";
    APIType[APIType["SUBMIT_TRANSACTIONS"] = 2] = "SUBMIT_TRANSACTIONS";
    APIType[APIType["CANCEL"] = 3] = "CANCEL";
    APIType[APIType["BATCH_STATUS"] = 4] = "BATCH_STATUS";
    APIType[APIType["LIVENESS"] = 5] = "LIVENESS";
})(APIType = exports.APIType || (exports.APIType = {}));
/** SmartTransactions */
var SmartTransactionMinedTx;
(function (SmartTransactionMinedTx) {
    SmartTransactionMinedTx["NOT_MINED"] = "not_mined";
    SmartTransactionMinedTx["SUCCESS"] = "success";
    SmartTransactionMinedTx["CANCELLED"] = "cancelled";
    SmartTransactionMinedTx["REVERTED"] = "reverted";
    SmartTransactionMinedTx["UNKNOWN"] = "unknown";
})(SmartTransactionMinedTx = exports.SmartTransactionMinedTx || (exports.SmartTransactionMinedTx = {}));
var SmartTransactionCancellationReason;
(function (SmartTransactionCancellationReason) {
    SmartTransactionCancellationReason["WOULD_REVERT"] = "would_revert";
    SmartTransactionCancellationReason["TOO_CHEAP"] = "too_cheap";
    SmartTransactionCancellationReason["DEADLINE_MISSED"] = "deadline_missed";
    SmartTransactionCancellationReason["INVALID_NONCE"] = "invalid_nonce";
    SmartTransactionCancellationReason["USER_CANCELLED"] = "user_cancelled";
    SmartTransactionCancellationReason["NOT_CANCELLED"] = "not_cancelled";
})(SmartTransactionCancellationReason = exports.SmartTransactionCancellationReason || (exports.SmartTransactionCancellationReason = {}));
var SmartTransactionStatuses;
(function (SmartTransactionStatuses) {
    SmartTransactionStatuses["PENDING"] = "pending";
    SmartTransactionStatuses["SUCCESS"] = "success";
    SmartTransactionStatuses["REVERTED"] = "reverted";
    SmartTransactionStatuses["UNKNOWN"] = "unknown";
    SmartTransactionStatuses["CANCELLED"] = "cancelled";
    SmartTransactionStatuses["CANCELLED_USER_CANCELLED"] = "cancelled_user_cancelled";
    SmartTransactionStatuses["RESOLVED"] = "resolved";
})(SmartTransactionStatuses = exports.SmartTransactionStatuses || (exports.SmartTransactionStatuses = {}));
var ClientId;
(function (ClientId) {
    ClientId["Mobile"] = "mobile";
    ClientId["Extension"] = "extension";
})(ClientId = exports.ClientId || (exports.ClientId = {}));
exports.cancellationReasonToStatusMap = {
    [SmartTransactionCancellationReason.WOULD_REVERT]: SmartTransactionStatuses.CANCELLED,
    [SmartTransactionCancellationReason.TOO_CHEAP]: SmartTransactionStatuses.CANCELLED,
    [SmartTransactionCancellationReason.DEADLINE_MISSED]: SmartTransactionStatuses.CANCELLED,
    [SmartTransactionCancellationReason.INVALID_NONCE]: SmartTransactionStatuses.CANCELLED,
    [SmartTransactionCancellationReason.USER_CANCELLED]: SmartTransactionStatuses.CANCELLED_USER_CANCELLED,
};

      };
    };
  }
  }
}, {package:"@metamask/smart-transactions-controller",file:"node_modules\\@metamask\\smart-transactions-controller\\dist\\types.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\dist\\utils.cjs", {"../package.json":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\package.json","./constants.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\dist\\constants.cjs","./types.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\dist\\types.cjs","@ethersproject/bytes":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\bytes\\lib\\index.js","@ethersproject/keccak256":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\keccak256\\lib\\index.js","@ethersproject/transactions":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\transactions\\lib\\index.js","@metamask/transaction-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\transaction-controller\\dist\\index.cjs","bignumber.js":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\node_modules\\bignumber.js\\bignumber.js","fast-json-patch":"D:\\code\\v\\metamask-extension\\node_modules\\fast-json-patch\\index.js","lodash":"D:\\code\\v\\metamask-extension\\node_modules\\lodash\\lodash.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csmart-transactions-controller%5Cdist%5Cutils.cjs
      return function (require, module, exports) {
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.markRegularTransactionAsFailed = exports.shouldMarkRegularTransactionAsFailed = exports.getReturnTxHashAsap = exports.getSmartTransactionMetricsSensitiveProperties = exports.getSmartTransactionMetricsProperties = exports.getTxHash = exports.incrementNonceInHex = exports.isSmartTransactionCancellable = exports.handleFetch = exports.mapKeysToCamel = exports.getStxProcessingTime = exports.snapshotFromTxMeta = exports.replayHistory = exports.generateHistoryEntry = exports.calculateStatus = exports.getAPIRequestURL = exports.isSmartTransactionStatusResolved = exports.isSmartTransactionPending = void 0;
const bytes_1 = require("@ethersproject/bytes");
const keccak256_1 = require("@ethersproject/keccak256");
const transactions_1 = require("@ethersproject/transactions");
const transaction_controller_1 = require("@metamask/transaction-controller");
const bignumber_js_1 = require("bignumber.js");
const fast_json_patch_1 = __importDefault(require("fast-json-patch"));
const lodash_1 = __importDefault(require("lodash"));
// Ignoring TypeScript errors here because this import is disallowed for production builds, because
// the `package.json` file is above the root directory.
// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-ignore
const package_json_1 = __importDefault(require("../package.json"));
const constants_1 = require("./constants.cjs");
const types_1 = require("./types.cjs");
function isSmartTransactionPending(smartTransaction) {
    return smartTransaction.status === types_1.SmartTransactionStatuses.PENDING;
}
exports.isSmartTransactionPending = isSmartTransactionPending;
const isSmartTransactionStatusResolved = (stxStatus) => stxStatus === 'uuid_not_found';
exports.isSmartTransactionStatusResolved = isSmartTransactionStatusResolved;
// TODO use actual url once API is defined
function getAPIRequestURL(apiType, chainId) {
    const chainIdDec = parseInt(chainId, 16);
    switch (apiType) {
        case types_1.APIType.GET_FEES: {
            return `${constants_1.API_BASE_URL}/networks/${chainIdDec}/getFees`;
        }
        case types_1.APIType.ESTIMATE_GAS: {
            return `${constants_1.API_BASE_URL}/networks/${chainIdDec}/estimateGas`;
        }
        case types_1.APIType.SUBMIT_TRANSACTIONS: {
            return `${constants_1.API_BASE_URL}/networks/${chainIdDec}/submitTransactions?stxControllerVersion=${package_json_1.default.version}`;
        }
        case types_1.APIType.CANCEL: {
            return `${constants_1.API_BASE_URL}/networks/${chainIdDec}/cancel`;
        }
        case types_1.APIType.BATCH_STATUS: {
            return `${constants_1.API_BASE_URL}/networks/${chainIdDec}/batchStatus`;
        }
        case types_1.APIType.LIVENESS: {
            return `${constants_1.SENTINEL_API_BASE_URL_MAP[chainIdDec]}/network`;
        }
        default: {
            throw new Error(`Invalid APIType`); // It can never get here thanks to TypeScript.
        }
    }
}
exports.getAPIRequestURL = getAPIRequestURL;
const calculateStatus = (stxStatus) => {
    if ((0, exports.isSmartTransactionStatusResolved)(stxStatus)) {
        return types_1.SmartTransactionStatuses.RESOLVED;
    }
    const cancellations = [
        types_1.SmartTransactionCancellationReason.WOULD_REVERT,
        types_1.SmartTransactionCancellationReason.TOO_CHEAP,
        types_1.SmartTransactionCancellationReason.DEADLINE_MISSED,
        types_1.SmartTransactionCancellationReason.INVALID_NONCE,
        types_1.SmartTransactionCancellationReason.USER_CANCELLED,
    ];
    if ((stxStatus === null || stxStatus === void 0 ? void 0 : stxStatus.minedTx) === types_1.SmartTransactionMinedTx.NOT_MINED) {
        if (stxStatus.cancellationReason ===
            types_1.SmartTransactionCancellationReason.NOT_CANCELLED) {
            return types_1.SmartTransactionStatuses.PENDING;
        }
        const isCancellation = cancellations.findIndex((cancellation) => cancellation === stxStatus.cancellationReason) > -1;
        if (stxStatus.cancellationReason && isCancellation) {
            if (!stxStatus.isSettled) {
                return types_1.SmartTransactionStatuses.PENDING;
            }
            return types_1.cancellationReasonToStatusMap[stxStatus.cancellationReason];
        }
    }
    else if ((stxStatus === null || stxStatus === void 0 ? void 0 : stxStatus.minedTx) === types_1.SmartTransactionMinedTx.SUCCESS) {
        return types_1.SmartTransactionStatuses.SUCCESS;
    }
    else if ((stxStatus === null || stxStatus === void 0 ? void 0 : stxStatus.minedTx) === types_1.SmartTransactionMinedTx.CANCELLED) {
        return types_1.SmartTransactionStatuses.CANCELLED;
    }
    else if ((stxStatus === null || stxStatus === void 0 ? void 0 : stxStatus.minedTx) === types_1.SmartTransactionMinedTx.REVERTED) {
        return types_1.SmartTransactionStatuses.REVERTED;
    }
    else if ((stxStatus === null || stxStatus === void 0 ? void 0 : stxStatus.minedTx) === types_1.SmartTransactionMinedTx.UNKNOWN) {
        return types_1.SmartTransactionStatuses.UNKNOWN;
    }
    return types_1.SmartTransactionStatuses.UNKNOWN;
};
exports.calculateStatus = calculateStatus;
/**
  Generates an array of history objects sense the previous state.
  The object has the keys
    op (the operation performed),
    path (the key and if a nested object then each key will be separated with a `/`)
    value
  with the first entry having the note and a timestamp when the change took place
  @param previousState - the previous state of the object
  @param newState - the update object
  @param [note] - a optional note for the state change
  @returns
*/
function generateHistoryEntry(previousState, newState, note) {
    const entry = fast_json_patch_1.default.compare(previousState, newState);
    // Add a note to the first op, since it breaks if we append it to the entry
    if (entry[0]) {
        if (note) {
            entry[0].note = note;
        }
        entry[0].timestamp = Date.now();
    }
    return entry;
}
exports.generateHistoryEntry = generateHistoryEntry;
/**
  Recovers previous txMeta state obj
  @returns
*/
function replayHistory(_shortHistory) {
    const shortHistory = lodash_1.default.cloneDeep(_shortHistory);
    return shortHistory.reduce((val, entry) => fast_json_patch_1.default.applyPatch(val, entry).newDocument);
}
exports.replayHistory = replayHistory;
/**
 * Snapshot {@code txMeta}
 * @param txMeta - the tx metadata object
 * @returns a deep clone without history
 */
function snapshotFromTxMeta(txMeta) {
    const shallow = Object.assign({}, txMeta);
    delete shallow.history;
    return lodash_1.default.cloneDeep(shallow);
}
exports.snapshotFromTxMeta = snapshotFromTxMeta;
/**
 * Returns processing time for an STX in seconds.
 * @param smartTransactionSubmittedtime
 * @returns Processing time in seconds.
 */
const getStxProcessingTime = (smartTransactionSubmittedtime) => {
    if (!smartTransactionSubmittedtime) {
        return undefined;
    }
    return Math.round((Date.now() - smartTransactionSubmittedtime) / 1000);
};
exports.getStxProcessingTime = getStxProcessingTime;
const mapKeysToCamel = (obj) => {
    if (!lodash_1.default.isObject(obj)) {
        return obj;
    }
    const mappedValues = lodash_1.default.mapValues(obj, (val) => {
        if (lodash_1.default.isArray(val)) {
            return val.map(exports.mapKeysToCamel);
        }
        else if (lodash_1.default.isObject(val)) {
            return (0, exports.mapKeysToCamel)(val);
        }
        return val;
    });
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    return lodash_1.default.mapKeys(mappedValues, (value, key) => lodash_1.default.camelCase(key));
};
exports.mapKeysToCamel = mapKeysToCamel;
async function handleFetch(request, options) {
    const response = await fetch(request, options);
    const json = await response.json();
    if (!response.ok) {
        console.log(`response`, response);
        throw new Error(`Fetch error:${JSON.stringify(Object.assign({ status: response.status }, (0, exports.mapKeysToCamel)(json)))}`);
    }
    return json;
}
exports.handleFetch = handleFetch;
const isSmartTransactionCancellable = (stxStatus) => {
    return (stxStatus.minedTx === types_1.SmartTransactionMinedTx.NOT_MINED &&
        (!stxStatus.cancellationReason ||
            stxStatus.cancellationReason ===
                types_1.SmartTransactionCancellationReason.NOT_CANCELLED));
};
exports.isSmartTransactionCancellable = isSmartTransactionCancellable;
const incrementNonceInHex = (nonceInHex) => {
    const nonceInDec = new bignumber_js_1.BigNumber(nonceInHex, 16).toString(10);
    return (0, bytes_1.hexlify)(Number(nonceInDec) + 1);
};
exports.incrementNonceInHex = incrementNonceInHex;
const isType4Transaction = (signedTxHex) => {
    return typeof signedTxHex === 'string' && signedTxHex.startsWith('0x04');
};
const getTxHash = (signedTxHex) => {
    var _a;
    if (!signedTxHex) {
        return '';
    }
    try {
        const parsed = (0, transactions_1.parse)(signedTxHex);
        return (_a = parsed === null || parsed === void 0 ? void 0 : parsed.hash) !== null && _a !== void 0 ? _a : '';
    }
    catch (error) {
        if (isType4Transaction(signedTxHex)) {
            return (0, bytes_1.hexlify)((0, keccak256_1.keccak256)((0, bytes_1.arrayify)(signedTxHex)));
        }
        throw error;
    }
};
exports.getTxHash = getTxHash;
const getSmartTransactionMetricsProperties = (smartTransaction) => {
    if (!smartTransaction) {
        return {};
    }
    const smartTransactionStatusMetadata = smartTransaction.statusMetadata;
    return {
        stx_status: smartTransaction.status,
        type: smartTransaction.type,
        processing_time: (0, exports.getStxProcessingTime)(smartTransaction.time),
        is_smart_transaction: true,
        stx_enabled: true,
        current_stx_enabled: true,
        stx_user_opt_in: true,
        stx_duplicated: smartTransactionStatusMetadata === null || smartTransactionStatusMetadata === void 0 ? void 0 : smartTransactionStatusMetadata.duplicated,
        stx_timed_out: smartTransactionStatusMetadata === null || smartTransactionStatusMetadata === void 0 ? void 0 : smartTransactionStatusMetadata.timedOut,
        stx_proxied: smartTransactionStatusMetadata === null || smartTransactionStatusMetadata === void 0 ? void 0 : smartTransactionStatusMetadata.proxied,
    };
};
exports.getSmartTransactionMetricsProperties = getSmartTransactionMetricsProperties;
const getSmartTransactionMetricsSensitiveProperties = (smartTransaction) => {
    if (!smartTransaction) {
        return {};
    }
    return {
        token_from_symbol: smartTransaction.sourceTokenSymbol,
        token_to_symbol: smartTransaction.destinationTokenSymbol,
        account_hardware_type: smartTransaction.accountHardwareType,
        account_type: smartTransaction.accountType,
        device_model: smartTransaction.deviceModel,
    };
};
exports.getSmartTransactionMetricsSensitiveProperties = getSmartTransactionMetricsSensitiveProperties;
const getReturnTxHashAsap = (clientId, smartTransactionsFeatureFlags) => {
    return clientId === types_1.ClientId.Extension
        ? smartTransactionsFeatureFlags === null || smartTransactionsFeatureFlags === void 0 ? void 0 : smartTransactionsFeatureFlags.extensionReturnTxHashAsap
        : smartTransactionsFeatureFlags === null || smartTransactionsFeatureFlags === void 0 ? void 0 : smartTransactionsFeatureFlags.mobileReturnTxHashAsap;
};
exports.getReturnTxHashAsap = getReturnTxHashAsap;
const shouldMarkRegularTransactionAsFailed = ({ smartTransaction, clientId, getFeatureFlags, }) => {
    var _a;
    const { status, transactionId } = smartTransaction;
    const failureStatuses = [
        types_1.SmartTransactionStatuses.CANCELLED,
        types_1.SmartTransactionStatuses.CANCELLED_USER_CANCELLED,
        types_1.SmartTransactionStatuses.UNKNOWN,
        types_1.SmartTransactionStatuses.RESOLVED,
    ];
    if (!status ||
        !failureStatuses.includes(status)) {
        return false;
    }
    const { smartTransactions: smartTransactionsFeatureFlags } = (_a = getFeatureFlags()) !== null && _a !== void 0 ? _a : {};
    const returnTxHashAsapEnabled = (0, exports.getReturnTxHashAsap)(clientId, smartTransactionsFeatureFlags);
    return Boolean(returnTxHashAsapEnabled && transactionId);
};
exports.shouldMarkRegularTransactionAsFailed = shouldMarkRegularTransactionAsFailed;
const markRegularTransactionAsFailed = ({ smartTransaction, getRegularTransactions, updateTransaction, }) => {
    const { transactionId, status } = smartTransaction;
    const originalTransaction = getRegularTransactions().find((transaction) => transaction.id === transactionId);
    if (!originalTransaction) {
        throw new Error('Cannot find regular transaction to mark it as failed');
    }
    if (originalTransaction.status === transaction_controller_1.TransactionStatus.failed) {
        return; // Already marked as failed.
    }
    const updatedTransaction = Object.assign(Object.assign({}, originalTransaction), { status: transaction_controller_1.TransactionStatus.failed, error: {
            name: 'SmartTransactionFailed',
            message: `Smart transaction failed with status: ${status}`,
        } });
    updateTransaction(updatedTransaction, `Smart transaction status: ${status}`);
};
exports.markRegularTransactionAsFailed = markRegularTransactionAsFailed;

      };
    };
  }
  }
}, {package:"@metamask/smart-transactions-controller",file:"node_modules\\@metamask\\smart-transactions-controller\\dist\\utils.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\node_modules\\bignumber.js\\bignumber.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csmart-transactions-controller%5Cnode_modules%5Cbignumber.js%5Cbignumber.js
      return function (require, module, exports) {
;(function (globalObject) {
  'use strict';

/*
 *      bignumber.js v9.3.0
 *      A JavaScript library for arbitrary-precision arithmetic.
 *      https://github.com/MikeMcl/bignumber.js
 *      Copyright (c) 2025 Michael Mclaughlin <M8ch88l@gmail.com>
 *      MIT Licensed.
 *
 *      BigNumber.prototype methods     |  BigNumber methods
 *                                      |
 *      absoluteValue            abs    |  clone
 *      comparedTo                      |  config               set
 *      decimalPlaces            dp     |      DECIMAL_PLACES
 *      dividedBy                div    |      ROUNDING_MODE
 *      dividedToIntegerBy       idiv   |      EXPONENTIAL_AT
 *      exponentiatedBy          pow    |      RANGE
 *      integerValue                    |      CRYPTO
 *      isEqualTo                eq     |      MODULO_MODE
 *      isFinite                        |      POW_PRECISION
 *      isGreaterThan            gt     |      FORMAT
 *      isGreaterThanOrEqualTo   gte    |      ALPHABET
 *      isInteger                       |  isBigNumber
 *      isLessThan               lt     |  maximum              max
 *      isLessThanOrEqualTo      lte    |  minimum              min
 *      isNaN                           |  random
 *      isNegative                      |  sum
 *      isPositive                      |
 *      isZero                          |
 *      minus                           |
 *      modulo                   mod    |
 *      multipliedBy             times  |
 *      negated                         |
 *      plus                            |
 *      precision                sd     |
 *      shiftedBy                       |
 *      squareRoot               sqrt   |
 *      toExponential                   |
 *      toFixed                         |
 *      toFormat                        |
 *      toFraction                      |
 *      toJSON                          |
 *      toNumber                        |
 *      toPrecision                     |
 *      toString                        |
 *      valueOf                         |
 *
 */


  var BigNumber,
    isNumeric = /^-?(?:\d+(?:\.\d*)?|\.\d+)(?:e[+-]?\d+)?$/i,
    mathceil = Math.ceil,
    mathfloor = Math.floor,

    bignumberError = '[BigNumber Error] ',
    tooManyDigits = bignumberError + 'Number primitive has more than 15 significant digits: ',

    BASE = 1e14,
    LOG_BASE = 14,
    MAX_SAFE_INTEGER = 0x1fffffffffffff,         // 2^53 - 1
    // MAX_INT32 = 0x7fffffff,                   // 2^31 - 1
    POWS_TEN = [1, 10, 100, 1e3, 1e4, 1e5, 1e6, 1e7, 1e8, 1e9, 1e10, 1e11, 1e12, 1e13],
    SQRT_BASE = 1e7,

    // EDITABLE
    // The limit on the value of DECIMAL_PLACES, TO_EXP_NEG, TO_EXP_POS, MIN_EXP, MAX_EXP, and
    // the arguments to toExponential, toFixed, toFormat, and toPrecision.
    MAX = 1E9;                                   // 0 to MAX_INT32


  /*
   * Create and return a BigNumber constructor.
   */
  function clone(configObject) {
    var div, convertBase, parseNumeric,
      P = BigNumber.prototype = { constructor: BigNumber, toString: null, valueOf: null },
      ONE = new BigNumber(1),


      //----------------------------- EDITABLE CONFIG DEFAULTS -------------------------------


      // The default values below must be integers within the inclusive ranges stated.
      // The values can also be changed at run-time using BigNumber.set.

      // The maximum number of decimal places for operations involving division.
      DECIMAL_PLACES = 20,                     // 0 to MAX

      // The rounding mode used when rounding to the above decimal places, and when using
      // toExponential, toFixed, toFormat and toPrecision, and round (default value).
      // UP         0 Away from zero.
      // DOWN       1 Towards zero.
      // CEIL       2 Towards +Infinity.
      // FLOOR      3 Towards -Infinity.
      // HALF_UP    4 Towards nearest neighbour. If equidistant, up.
      // HALF_DOWN  5 Towards nearest neighbour. If equidistant, down.
      // HALF_EVEN  6 Towards nearest neighbour. If equidistant, towards even neighbour.
      // HALF_CEIL  7 Towards nearest neighbour. If equidistant, towards +Infinity.
      // HALF_FLOOR 8 Towards nearest neighbour. If equidistant, towards -Infinity.
      ROUNDING_MODE = 4,                       // 0 to 8

      // EXPONENTIAL_AT : [TO_EXP_NEG , TO_EXP_POS]

      // The exponent value at and beneath which toString returns exponential notation.
      // Number type: -7
      TO_EXP_NEG = -7,                         // 0 to -MAX

      // The exponent value at and above which toString returns exponential notation.
      // Number type: 21
      TO_EXP_POS = 21,                         // 0 to MAX

      // RANGE : [MIN_EXP, MAX_EXP]

      // The minimum exponent value, beneath which underflow to zero occurs.
      // Number type: -324  (5e-324)
      MIN_EXP = -1e7,                          // -1 to -MAX

      // The maximum exponent value, above which overflow to Infinity occurs.
      // Number type:  308  (1.7976931348623157e+308)
      // For MAX_EXP > 1e7, e.g. new BigNumber('1e100000000').plus(1) may be slow.
      MAX_EXP = 1e7,                           // 1 to MAX

      // Whether to use cryptographically-secure random number generation, if available.
      CRYPTO = false,                          // true or false

      // The modulo mode used when calculating the modulus: a mod n.
      // The quotient (q = a / n) is calculated according to the corresponding rounding mode.
      // The remainder (r) is calculated as: r = a - n * q.
      //
      // UP        0 The remainder is positive if the dividend is negative, else is negative.
      // DOWN      1 The remainder has the same sign as the dividend.
      //             This modulo mode is commonly known as 'truncated division' and is
      //             equivalent to (a % n) in JavaScript.
      // FLOOR     3 The remainder has the same sign as the divisor (Python %).
      // HALF_EVEN 6 This modulo mode implements the IEEE 754 remainder function.
      // EUCLID    9 Euclidian division. q = sign(n) * floor(a / abs(n)).
      //             The remainder is always positive.
      //
      // The truncated division, floored division, Euclidian division and IEEE 754 remainder
      // modes are commonly used for the modulus operation.
      // Although the other rounding modes can also be used, they may not give useful results.
      MODULO_MODE = 1,                         // 0 to 9

      // The maximum number of significant digits of the result of the exponentiatedBy operation.
      // If POW_PRECISION is 0, there will be unlimited significant digits.
      POW_PRECISION = 0,                       // 0 to MAX

      // The format specification used by the BigNumber.prototype.toFormat method.
      FORMAT = {
        prefix: '',
        groupSize: 3,
        secondaryGroupSize: 0,
        groupSeparator: ',',
        decimalSeparator: '.',
        fractionGroupSize: 0,
        fractionGroupSeparator: '\xA0',        // non-breaking space
        suffix: ''
      },

      // The alphabet used for base conversion. It must be at least 2 characters long, with no '+',
      // '-', '.', whitespace, or repeated character.
      // '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$_'
      ALPHABET = '0123456789abcdefghijklmnopqrstuvwxyz',
      alphabetHasNormalDecimalDigits = true;


    //------------------------------------------------------------------------------------------


    // CONSTRUCTOR


    /*
     * The BigNumber constructor and exported function.
     * Create and return a new instance of a BigNumber object.
     *
     * v {number|string|BigNumber} A numeric value.
     * [b] {number} The base of v. Integer, 2 to ALPHABET.length inclusive.
     */
    function BigNumber(v, b) {
      var alphabet, c, caseChanged, e, i, isNum, len, str,
        x = this;

      // Enable constructor call without `new`.
      if (!(x instanceof BigNumber)) return new BigNumber(v, b);

      if (b == null) {

        if (v && v._isBigNumber === true) {
          x.s = v.s;

          if (!v.c || v.e > MAX_EXP) {
            x.c = x.e = null;
          } else if (v.e < MIN_EXP) {
            x.c = [x.e = 0];
          } else {
            x.e = v.e;
            x.c = v.c.slice();
          }

          return;
        }

        if ((isNum = typeof v == 'number') && v * 0 == 0) {

          // Use `1 / n` to handle minus zero also.
          x.s = 1 / v < 0 ? (v = -v, -1) : 1;

          // Fast path for integers, where n < 2147483648 (2**31).
          if (v === ~~v) {
            for (e = 0, i = v; i >= 10; i /= 10, e++);

            if (e > MAX_EXP) {
              x.c = x.e = null;
            } else {
              x.e = e;
              x.c = [v];
            }

            return;
          }

          str = String(v);
        } else {

          if (!isNumeric.test(str = String(v))) return parseNumeric(x, str, isNum);

          x.s = str.charCodeAt(0) == 45 ? (str = str.slice(1), -1) : 1;
        }

        // Decimal point?
        if ((e = str.indexOf('.')) > -1) str = str.replace('.', '');

        // Exponential form?
        if ((i = str.search(/e/i)) > 0) {

          // Determine exponent.
          if (e < 0) e = i;
          e += +str.slice(i + 1);
          str = str.substring(0, i);
        } else if (e < 0) {

          // Integer.
          e = str.length;
        }

      } else {

        // '[BigNumber Error] Base {not a primitive number|not an integer|out of range}: {b}'
        intCheck(b, 2, ALPHABET.length, 'Base');

        // Allow exponential notation to be used with base 10 argument, while
        // also rounding to DECIMAL_PLACES as with other bases.
        if (b == 10 && alphabetHasNormalDecimalDigits) {
          x = new BigNumber(v);
          return round(x, DECIMAL_PLACES + x.e + 1, ROUNDING_MODE);
        }

        str = String(v);

        if (isNum = typeof v == 'number') {

          // Avoid potential interpretation of Infinity and NaN as base 44+ values.
          if (v * 0 != 0) return parseNumeric(x, str, isNum, b);

          x.s = 1 / v < 0 ? (str = str.slice(1), -1) : 1;

          // '[BigNumber Error] Number primitive has more than 15 significant digits: {n}'
          if (BigNumber.DEBUG && str.replace(/^0\.0*|\./, '').length > 15) {
            throw Error
             (tooManyDigits + v);
          }
        } else {
          x.s = str.charCodeAt(0) === 45 ? (str = str.slice(1), -1) : 1;
        }

        alphabet = ALPHABET.slice(0, b);
        e = i = 0;

        // Check that str is a valid base b number.
        // Don't use RegExp, so alphabet can contain special characters.
        for (len = str.length; i < len; i++) {
          if (alphabet.indexOf(c = str.charAt(i)) < 0) {
            if (c == '.') {

              // If '.' is not the first character and it has not be found before.
              if (i > e) {
                e = len;
                continue;
              }
            } else if (!caseChanged) {

              // Allow e.g. hexadecimal 'FF' as well as 'ff'.
              if (str == str.toUpperCase() && (str = str.toLowerCase()) ||
                  str == str.toLowerCase() && (str = str.toUpperCase())) {
                caseChanged = true;
                i = -1;
                e = 0;
                continue;
              }
            }

            return parseNumeric(x, String(v), isNum, b);
          }
        }

        // Prevent later check for length on converted number.
        isNum = false;
        str = convertBase(str, b, 10, x.s);

        // Decimal point?
        if ((e = str.indexOf('.')) > -1) str = str.replace('.', '');
        else e = str.length;
      }

      // Determine leading zeros.
      for (i = 0; str.charCodeAt(i) === 48; i++);

      // Determine trailing zeros.
      for (len = str.length; str.charCodeAt(--len) === 48;);

      if (str = str.slice(i, ++len)) {
        len -= i;

        // '[BigNumber Error] Number primitive has more than 15 significant digits: {n}'
        if (isNum && BigNumber.DEBUG &&
          len > 15 && (v > MAX_SAFE_INTEGER || v !== mathfloor(v))) {
            throw Error
             (tooManyDigits + (x.s * v));
        }

         // Overflow?
        if ((e = e - i - 1) > MAX_EXP) {

          // Infinity.
          x.c = x.e = null;

        // Underflow?
        } else if (e < MIN_EXP) {

          // Zero.
          x.c = [x.e = 0];
        } else {
          x.e = e;
          x.c = [];

          // Transform base

          // e is the base 10 exponent.
          // i is where to slice str to get the first element of the coefficient array.
          i = (e + 1) % LOG_BASE;
          if (e < 0) i += LOG_BASE;  // i < 1

          if (i < len) {
            if (i) x.c.push(+str.slice(0, i));

            for (len -= LOG_BASE; i < len;) {
              x.c.push(+str.slice(i, i += LOG_BASE));
            }

            i = LOG_BASE - (str = str.slice(i)).length;
          } else {
            i -= len;
          }

          for (; i--; str += '0');
          x.c.push(+str);
        }
      } else {

        // Zero.
        x.c = [x.e = 0];
      }
    }


    // CONSTRUCTOR PROPERTIES


    BigNumber.clone = clone;

    BigNumber.ROUND_UP = 0;
    BigNumber.ROUND_DOWN = 1;
    BigNumber.ROUND_CEIL = 2;
    BigNumber.ROUND_FLOOR = 3;
    BigNumber.ROUND_HALF_UP = 4;
    BigNumber.ROUND_HALF_DOWN = 5;
    BigNumber.ROUND_HALF_EVEN = 6;
    BigNumber.ROUND_HALF_CEIL = 7;
    BigNumber.ROUND_HALF_FLOOR = 8;
    BigNumber.EUCLID = 9;


    /*
     * Configure infrequently-changing library-wide settings.
     *
     * Accept an object with the following optional properties (if the value of a property is
     * a number, it must be an integer within the inclusive range stated):
     *
     *   DECIMAL_PLACES   {number}           0 to MAX
     *   ROUNDING_MODE    {number}           0 to 8
     *   EXPONENTIAL_AT   {number|number[]}  -MAX to MAX  or  [-MAX to 0, 0 to MAX]
     *   RANGE            {number|number[]}  -MAX to MAX (not zero)  or  [-MAX to -1, 1 to MAX]
     *   CRYPTO           {boolean}          true or false
     *   MODULO_MODE      {number}           0 to 9
     *   POW_PRECISION       {number}           0 to MAX
     *   ALPHABET         {string}           A string of two or more unique characters which does
     *                                       not contain '.'.
     *   FORMAT           {object}           An object with some of the following properties:
     *     prefix                 {string}
     *     groupSize              {number}
     *     secondaryGroupSize     {number}
     *     groupSeparator         {string}
     *     decimalSeparator       {string}
     *     fractionGroupSize      {number}
     *     fractionGroupSeparator {string}
     *     suffix                 {string}
     *
     * (The values assigned to the above FORMAT object properties are not checked for validity.)
     *
     * E.g.
     * BigNumber.config({ DECIMAL_PLACES : 20, ROUNDING_MODE : 4 })
     *
     * Ignore properties/parameters set to null or undefined, except for ALPHABET.
     *
     * Return an object with the properties current values.
     */
    BigNumber.config = BigNumber.set = function (obj) {
      var p, v;

      if (obj != null) {

        if (typeof obj == 'object') {

          // DECIMAL_PLACES {number} Integer, 0 to MAX inclusive.
          // '[BigNumber Error] DECIMAL_PLACES {not a primitive number|not an integer|out of range}: {v}'
          if (obj.hasOwnProperty(p = 'DECIMAL_PLACES')) {
            v = obj[p];
            intCheck(v, 0, MAX, p);
            DECIMAL_PLACES = v;
          }

          // ROUNDING_MODE {number} Integer, 0 to 8 inclusive.
          // '[BigNumber Error] ROUNDING_MODE {not a primitive number|not an integer|out of range}: {v}'
          if (obj.hasOwnProperty(p = 'ROUNDING_MODE')) {
            v = obj[p];
            intCheck(v, 0, 8, p);
            ROUNDING_MODE = v;
          }

          // EXPONENTIAL_AT {number|number[]}
          // Integer, -MAX to MAX inclusive or
          // [integer -MAX to 0 inclusive, 0 to MAX inclusive].
          // '[BigNumber Error] EXPONENTIAL_AT {not a primitive number|not an integer|out of range}: {v}'
          if (obj.hasOwnProperty(p = 'EXPONENTIAL_AT')) {
            v = obj[p];
            if (v && v.pop) {
              intCheck(v[0], -MAX, 0, p);
              intCheck(v[1], 0, MAX, p);
              TO_EXP_NEG = v[0];
              TO_EXP_POS = v[1];
            } else {
              intCheck(v, -MAX, MAX, p);
              TO_EXP_NEG = -(TO_EXP_POS = v < 0 ? -v : v);
            }
          }

          // RANGE {number|number[]} Non-zero integer, -MAX to MAX inclusive or
          // [integer -MAX to -1 inclusive, integer 1 to MAX inclusive].
          // '[BigNumber Error] RANGE {not a primitive number|not an integer|out of range|cannot be zero}: {v}'
          if (obj.hasOwnProperty(p = 'RANGE')) {
            v = obj[p];
            if (v && v.pop) {
              intCheck(v[0], -MAX, -1, p);
              intCheck(v[1], 1, MAX, p);
              MIN_EXP = v[0];
              MAX_EXP = v[1];
            } else {
              intCheck(v, -MAX, MAX, p);
              if (v) {
                MIN_EXP = -(MAX_EXP = v < 0 ? -v : v);
              } else {
                throw Error
                 (bignumberError + p + ' cannot be zero: ' + v);
              }
            }
          }

          // CRYPTO {boolean} true or false.
          // '[BigNumber Error] CRYPTO not true or false: {v}'
          // '[BigNumber Error] crypto unavailable'
          if (obj.hasOwnProperty(p = 'CRYPTO')) {
            v = obj[p];
            if (v === !!v) {
              if (v) {
                if (typeof crypto != 'undefined' && crypto &&
                 (crypto.getRandomValues || crypto.randomBytes)) {
                  CRYPTO = v;
                } else {
                  CRYPTO = !v;
                  throw Error
                   (bignumberError + 'crypto unavailable');
                }
              } else {
                CRYPTO = v;
              }
            } else {
              throw Error
               (bignumberError + p + ' not true or false: ' + v);
            }
          }

          // MODULO_MODE {number} Integer, 0 to 9 inclusive.
          // '[BigNumber Error] MODULO_MODE {not a primitive number|not an integer|out of range}: {v}'
          if (obj.hasOwnProperty(p = 'MODULO_MODE')) {
            v = obj[p];
            intCheck(v, 0, 9, p);
            MODULO_MODE = v;
          }

          // POW_PRECISION {number} Integer, 0 to MAX inclusive.
          // '[BigNumber Error] POW_PRECISION {not a primitive number|not an integer|out of range}: {v}'
          if (obj.hasOwnProperty(p = 'POW_PRECISION')) {
            v = obj[p];
            intCheck(v, 0, MAX, p);
            POW_PRECISION = v;
          }

          // FORMAT {object}
          // '[BigNumber Error] FORMAT not an object: {v}'
          if (obj.hasOwnProperty(p = 'FORMAT')) {
            v = obj[p];
            if (typeof v == 'object') FORMAT = v;
            else throw Error
             (bignumberError + p + ' not an object: ' + v);
          }

          // ALPHABET {string}
          // '[BigNumber Error] ALPHABET invalid: {v}'
          if (obj.hasOwnProperty(p = 'ALPHABET')) {
            v = obj[p];

            // Disallow if less than two characters,
            // or if it contains '+', '-', '.', whitespace, or a repeated character.
            if (typeof v == 'string' && !/^.?$|[+\-.\s]|(.).*\1/.test(v)) {
              alphabetHasNormalDecimalDigits = v.slice(0, 10) == '0123456789';
              ALPHABET = v;
            } else {
              throw Error
               (bignumberError + p + ' invalid: ' + v);
            }
          }

        } else {

          // '[BigNumber Error] Object expected: {v}'
          throw Error
           (bignumberError + 'Object expected: ' + obj);
        }
      }

      return {
        DECIMAL_PLACES: DECIMAL_PLACES,
        ROUNDING_MODE: ROUNDING_MODE,
        EXPONENTIAL_AT: [TO_EXP_NEG, TO_EXP_POS],
        RANGE: [MIN_EXP, MAX_EXP],
        CRYPTO: CRYPTO,
        MODULO_MODE: MODULO_MODE,
        POW_PRECISION: POW_PRECISION,
        FORMAT: FORMAT,
        ALPHABET: ALPHABET
      };
    };


    /*
     * Return true if v is a BigNumber instance, otherwise return false.
     *
     * If BigNumber.DEBUG is true, throw if a BigNumber instance is not well-formed.
     *
     * v {any}
     *
     * '[BigNumber Error] Invalid BigNumber: {v}'
     */
    BigNumber.isBigNumber = function (v) {
      if (!v || v._isBigNumber !== true) return false;
      if (!BigNumber.DEBUG) return true;

      var i, n,
        c = v.c,
        e = v.e,
        s = v.s;

      out: if ({}.toString.call(c) == '[object Array]') {

        if ((s === 1 || s === -1) && e >= -MAX && e <= MAX && e === mathfloor(e)) {

          // If the first element is zero, the BigNumber value must be zero.
          if (c[0] === 0) {
            if (e === 0 && c.length === 1) return true;
            break out;
          }

          // Calculate number of digits that c[0] should have, based on the exponent.
          i = (e + 1) % LOG_BASE;
          if (i < 1) i += LOG_BASE;

          // Calculate number of digits of c[0].
          //if (Math.ceil(Math.log(c[0] + 1) / Math.LN10) == i) {
          if (String(c[0]).length == i) {

            for (i = 0; i < c.length; i++) {
              n = c[i];
              if (n < 0 || n >= BASE || n !== mathfloor(n)) break out;
            }

            // Last element cannot be zero, unless it is the only element.
            if (n !== 0) return true;
          }
        }

      // Infinity/NaN
      } else if (c === null && e === null && (s === null || s === 1 || s === -1)) {
        return true;
      }

      throw Error
        (bignumberError + 'Invalid BigNumber: ' + v);
    };


    /*
     * Return a new BigNumber whose value is the maximum of the arguments.
     *
     * arguments {number|string|BigNumber}
     */
    BigNumber.maximum = BigNumber.max = function () {
      return maxOrMin(arguments, -1);
    };


    /*
     * Return a new BigNumber whose value is the minimum of the arguments.
     *
     * arguments {number|string|BigNumber}
     */
    BigNumber.minimum = BigNumber.min = function () {
      return maxOrMin(arguments, 1);
    };


    /*
     * Return a new BigNumber with a random value equal to or greater than 0 and less than 1,
     * and with dp, or DECIMAL_PLACES if dp is omitted, decimal places (or less if trailing
     * zeros are produced).
     *
     * [dp] {number} Decimal places. Integer, 0 to MAX inclusive.
     *
     * '[BigNumber Error] Argument {not a primitive number|not an integer|out of range}: {dp}'
     * '[BigNumber Error] crypto unavailable'
     */
    BigNumber.random = (function () {
      var pow2_53 = 0x20000000000000;

      // Return a 53 bit integer n, where 0 <= n < 9007199254740992.
      // Check if Math.random() produces more than 32 bits of randomness.
      // If it does, assume at least 53 bits are produced, otherwise assume at least 30 bits.
      // 0x40000000 is 2^30, 0x800000 is 2^23, 0x1fffff is 2^21 - 1.
      var random53bitInt = (Math.random() * pow2_53) & 0x1fffff
       ? function () { return mathfloor(Math.random() * pow2_53); }
       : function () { return ((Math.random() * 0x40000000 | 0) * 0x800000) +
         (Math.random() * 0x800000 | 0); };

      return function (dp) {
        var a, b, e, k, v,
          i = 0,
          c = [],
          rand = new BigNumber(ONE);

        if (dp == null) dp = DECIMAL_PLACES;
        else intCheck(dp, 0, MAX);

        k = mathceil(dp / LOG_BASE);

        if (CRYPTO) {

          // Browsers supporting crypto.getRandomValues.
          if (crypto.getRandomValues) {

            a = crypto.getRandomValues(new Uint32Array(k *= 2));

            for (; i < k;) {

              // 53 bits:
              // ((Math.pow(2, 32) - 1) * Math.pow(2, 21)).toString(2)
              // 11111 11111111 11111111 11111111 11100000 00000000 00000000
              // ((Math.pow(2, 32) - 1) >>> 11).toString(2)
              //                                     11111 11111111 11111111
              // 0x20000 is 2^21.
              v = a[i] * 0x20000 + (a[i + 1] >>> 11);

              // Rejection sampling:
              // 0 <= v < 9007199254740992
              // Probability that v >= 9e15, is
              // 7199254740992 / 9007199254740992 ~= 0.0008, i.e. 1 in 1251
              if (v >= 9e15) {
                b = crypto.getRandomValues(new Uint32Array(2));
                a[i] = b[0];
                a[i + 1] = b[1];
              } else {

                // 0 <= v <= 8999999999999999
                // 0 <= (v % 1e14) <= 99999999999999
                c.push(v % 1e14);
                i += 2;
              }
            }
            i = k / 2;

          // Node.js supporting crypto.randomBytes.
          } else if (crypto.randomBytes) {

            // buffer
            a = crypto.randomBytes(k *= 7);

            for (; i < k;) {

              // 0x1000000000000 is 2^48, 0x10000000000 is 2^40
              // 0x100000000 is 2^32, 0x1000000 is 2^24
              // 11111 11111111 11111111 11111111 11111111 11111111 11111111
              // 0 <= v < 9007199254740992
              v = ((a[i] & 31) * 0x1000000000000) + (a[i + 1] * 0x10000000000) +
                 (a[i + 2] * 0x100000000) + (a[i + 3] * 0x1000000) +
                 (a[i + 4] << 16) + (a[i + 5] << 8) + a[i + 6];

              if (v >= 9e15) {
                crypto.randomBytes(7).copy(a, i);
              } else {

                // 0 <= (v % 1e14) <= 99999999999999
                c.push(v % 1e14);
                i += 7;
              }
            }
            i = k / 7;
          } else {
            CRYPTO = false;
            throw Error
             (bignumberError + 'crypto unavailable');
          }
        }

        // Use Math.random.
        if (!CRYPTO) {

          for (; i < k;) {
            v = random53bitInt();
            if (v < 9e15) c[i++] = v % 1e14;
          }
        }

        k = c[--i];
        dp %= LOG_BASE;

        // Convert trailing digits to zeros according to dp.
        if (k && dp) {
          v = POWS_TEN[LOG_BASE - dp];
          c[i] = mathfloor(k / v) * v;
        }

        // Remove trailing elements which are zero.
        for (; c[i] === 0; c.pop(), i--);

        // Zero?
        if (i < 0) {
          c = [e = 0];
        } else {

          // Remove leading elements which are zero and adjust exponent accordingly.
          for (e = -1 ; c[0] === 0; c.splice(0, 1), e -= LOG_BASE);

          // Count the digits of the first element of c to determine leading zeros, and...
          for (i = 1, v = c[0]; v >= 10; v /= 10, i++);

          // adjust the exponent accordingly.
          if (i < LOG_BASE) e -= LOG_BASE - i;
        }

        rand.e = e;
        rand.c = c;
        return rand;
      };
    })();


    /*
     * Return a BigNumber whose value is the sum of the arguments.
     *
     * arguments {number|string|BigNumber}
     */
    BigNumber.sum = function () {
      var i = 1,
        args = arguments,
        sum = new BigNumber(args[0]);
      for (; i < args.length;) sum = sum.plus(args[i++]);
      return sum;
    };


    // PRIVATE FUNCTIONS


    // Called by BigNumber and BigNumber.prototype.toString.
    convertBase = (function () {
      var decimal = '0123456789';

      /*
       * Convert string of baseIn to an array of numbers of baseOut.
       * Eg. toBaseOut('255', 10, 16) returns [15, 15].
       * Eg. toBaseOut('ff', 16, 10) returns [2, 5, 5].
       */
      function toBaseOut(str, baseIn, baseOut, alphabet) {
        var j,
          arr = [0],
          arrL,
          i = 0,
          len = str.length;

        for (; i < len;) {
          for (arrL = arr.length; arrL--; arr[arrL] *= baseIn);

          arr[0] += alphabet.indexOf(str.charAt(i++));

          for (j = 0; j < arr.length; j++) {

            if (arr[j] > baseOut - 1) {
              if (arr[j + 1] == null) arr[j + 1] = 0;
              arr[j + 1] += arr[j] / baseOut | 0;
              arr[j] %= baseOut;
            }
          }
        }

        return arr.reverse();
      }

      // Convert a numeric string of baseIn to a numeric string of baseOut.
      // If the caller is toString, we are converting from base 10 to baseOut.
      // If the caller is BigNumber, we are converting from baseIn to base 10.
      return function (str, baseIn, baseOut, sign, callerIsToString) {
        var alphabet, d, e, k, r, x, xc, y,
          i = str.indexOf('.'),
          dp = DECIMAL_PLACES,
          rm = ROUNDING_MODE;

        // Non-integer.
        if (i >= 0) {
          k = POW_PRECISION;

          // Unlimited precision.
          POW_PRECISION = 0;
          str = str.replace('.', '');
          y = new BigNumber(baseIn);
          x = y.pow(str.length - i);
          POW_PRECISION = k;

          // Convert str as if an integer, then restore the fraction part by dividing the
          // result by its base raised to a power.

          y.c = toBaseOut(toFixedPoint(coeffToString(x.c), x.e, '0'),
           10, baseOut, decimal);
          y.e = y.c.length;
        }

        // Convert the number as integer.

        xc = toBaseOut(str, baseIn, baseOut, callerIsToString
         ? (alphabet = ALPHABET, decimal)
         : (alphabet = decimal, ALPHABET));

        // xc now represents str as an integer and converted to baseOut. e is the exponent.
        e = k = xc.length;

        // Remove trailing zeros.
        for (; xc[--k] == 0; xc.pop());

        // Zero?
        if (!xc[0]) return alphabet.charAt(0);

        // Does str represent an integer? If so, no need for the division.
        if (i < 0) {
          --e;
        } else {
          x.c = xc;
          x.e = e;

          // The sign is needed for correct rounding.
          x.s = sign;
          x = div(x, y, dp, rm, baseOut);
          xc = x.c;
          r = x.r;
          e = x.e;
        }

        // xc now represents str converted to baseOut.

        // The index of the rounding digit.
        d = e + dp + 1;

        // The rounding digit: the digit to the right of the digit that may be rounded up.
        i = xc[d];

        // Look at the rounding digits and mode to determine whether to round up.

        k = baseOut / 2;
        r = r || d < 0 || xc[d + 1] != null;

        r = rm < 4 ? (i != null || r) && (rm == 0 || rm == (x.s < 0 ? 3 : 2))
              : i > k || i == k &&(rm == 4 || r || rm == 6 && xc[d - 1] & 1 ||
               rm == (x.s < 0 ? 8 : 7));

        // If the index of the rounding digit is not greater than zero, or xc represents
        // zero, then the result of the base conversion is zero or, if rounding up, a value
        // such as 0.00001.
        if (d < 1 || !xc[0]) {

          // 1^-dp or 0
          str = r ? toFixedPoint(alphabet.charAt(1), -dp, alphabet.charAt(0)) : alphabet.charAt(0);
        } else {

          // Truncate xc to the required number of decimal places.
          xc.length = d;

          // Round up?
          if (r) {

            // Rounding up may mean the previous digit has to be rounded up and so on.
            for (--baseOut; ++xc[--d] > baseOut;) {
              xc[d] = 0;

              if (!d) {
                ++e;
                xc = [1].concat(xc);
              }
            }
          }

          // Determine trailing zeros.
          for (k = xc.length; !xc[--k];);

          // E.g. [4, 11, 15] becomes 4bf.
          for (i = 0, str = ''; i <= k; str += alphabet.charAt(xc[i++]));

          // Add leading zeros, decimal point and trailing zeros as required.
          str = toFixedPoint(str, e, alphabet.charAt(0));
        }

        // The caller will add the sign.
        return str;
      };
    })();


    // Perform division in the specified base. Called by div and convertBase.
    div = (function () {

      // Assume non-zero x and k.
      function multiply(x, k, base) {
        var m, temp, xlo, xhi,
          carry = 0,
          i = x.length,
          klo = k % SQRT_BASE,
          khi = k / SQRT_BASE | 0;

        for (x = x.slice(); i--;) {
          xlo = x[i] % SQRT_BASE;
          xhi = x[i] / SQRT_BASE | 0;
          m = khi * xlo + xhi * klo;
          temp = klo * xlo + ((m % SQRT_BASE) * SQRT_BASE) + carry;
          carry = (temp / base | 0) + (m / SQRT_BASE | 0) + khi * xhi;
          x[i] = temp % base;
        }

        if (carry) x = [carry].concat(x);

        return x;
      }

      function compare(a, b, aL, bL) {
        var i, cmp;

        if (aL != bL) {
          cmp = aL > bL ? 1 : -1;
        } else {

          for (i = cmp = 0; i < aL; i++) {

            if (a[i] != b[i]) {
              cmp = a[i] > b[i] ? 1 : -1;
              break;
            }
          }
        }

        return cmp;
      }

      function subtract(a, b, aL, base) {
        var i = 0;

        // Subtract b from a.
        for (; aL--;) {
          a[aL] -= i;
          i = a[aL] < b[aL] ? 1 : 0;
          a[aL] = i * base + a[aL] - b[aL];
        }

        // Remove leading zeros.
        for (; !a[0] && a.length > 1; a.splice(0, 1));
      }

      // x: dividend, y: divisor.
      return function (x, y, dp, rm, base) {
        var cmp, e, i, more, n, prod, prodL, q, qc, rem, remL, rem0, xi, xL, yc0,
          yL, yz,
          s = x.s == y.s ? 1 : -1,
          xc = x.c,
          yc = y.c;

        // Either NaN, Infinity or 0?
        if (!xc || !xc[0] || !yc || !yc[0]) {

          return new BigNumber(

           // Return NaN if either NaN, or both Infinity or 0.
           !x.s || !y.s || (xc ? yc && xc[0] == yc[0] : !yc) ? NaN :

            // Return ±0 if x is ±0 or y is ±Infinity, or return ±Infinity as y is ±0.
            xc && xc[0] == 0 || !yc ? s * 0 : s / 0
         );
        }

        q = new BigNumber(s);
        qc = q.c = [];
        e = x.e - y.e;
        s = dp + e + 1;

        if (!base) {
          base = BASE;
          e = bitFloor(x.e / LOG_BASE) - bitFloor(y.e / LOG_BASE);
          s = s / LOG_BASE | 0;
        }

        // Result exponent may be one less then the current value of e.
        // The coefficients of the BigNumbers from convertBase may have trailing zeros.
        for (i = 0; yc[i] == (xc[i] || 0); i++);

        if (yc[i] > (xc[i] || 0)) e--;

        if (s < 0) {
          qc.push(1);
          more = true;
        } else {
          xL = xc.length;
          yL = yc.length;
          i = 0;
          s += 2;

          // Normalise xc and yc so highest order digit of yc is >= base / 2.

          n = mathfloor(base / (yc[0] + 1));

          // Not necessary, but to handle odd bases where yc[0] == (base / 2) - 1.
          // if (n > 1 || n++ == 1 && yc[0] < base / 2) {
          if (n > 1) {
            yc = multiply(yc, n, base);
            xc = multiply(xc, n, base);
            yL = yc.length;
            xL = xc.length;
          }

          xi = yL;
          rem = xc.slice(0, yL);
          remL = rem.length;

          // Add zeros to make remainder as long as divisor.
          for (; remL < yL; rem[remL++] = 0);
          yz = yc.slice();
          yz = [0].concat(yz);
          yc0 = yc[0];
          if (yc[1] >= base / 2) yc0++;
          // Not necessary, but to prevent trial digit n > base, when using base 3.
          // else if (base == 3 && yc0 == 1) yc0 = 1 + 1e-15;

          do {
            n = 0;

            // Compare divisor and remainder.
            cmp = compare(yc, rem, yL, remL);

            // If divisor < remainder.
            if (cmp < 0) {

              // Calculate trial digit, n.

              rem0 = rem[0];
              if (yL != remL) rem0 = rem0 * base + (rem[1] || 0);

              // n is how many times the divisor goes into the current remainder.
              n = mathfloor(rem0 / yc0);

              //  Algorithm:
              //  product = divisor multiplied by trial digit (n).
              //  Compare product and remainder.
              //  If product is greater than remainder:
              //    Subtract divisor from product, decrement trial digit.
              //  Subtract product from remainder.
              //  If product was less than remainder at the last compare:
              //    Compare new remainder and divisor.
              //    If remainder is greater than divisor:
              //      Subtract divisor from remainder, increment trial digit.

              if (n > 1) {

                // n may be > base only when base is 3.
                if (n >= base) n = base - 1;

                // product = divisor * trial digit.
                prod = multiply(yc, n, base);
                prodL = prod.length;
                remL = rem.length;

                // Compare product and remainder.
                // If product > remainder then trial digit n too high.
                // n is 1 too high about 5% of the time, and is not known to have
                // ever been more than 1 too high.
                while (compare(prod, rem, prodL, remL) == 1) {
                  n--;

                  // Subtract divisor from product.
                  subtract(prod, yL < prodL ? yz : yc, prodL, base);
                  prodL = prod.length;
                  cmp = 1;
                }
              } else {

                // n is 0 or 1, cmp is -1.
                // If n is 0, there is no need to compare yc and rem again below,
                // so change cmp to 1 to avoid it.
                // If n is 1, leave cmp as -1, so yc and rem are compared again.
                if (n == 0) {

                  // divisor < remainder, so n must be at least 1.
                  cmp = n = 1;
                }

                // product = divisor
                prod = yc.slice();
                prodL = prod.length;
              }

              if (prodL < remL) prod = [0].concat(prod);

              // Subtract product from remainder.
              subtract(rem, prod, remL, base);
              remL = rem.length;

               // If product was < remainder.
              if (cmp == -1) {

                // Compare divisor and new remainder.
                // If divisor < new remainder, subtract divisor from remainder.
                // Trial digit n too low.
                // n is 1 too low about 5% of the time, and very rarely 2 too low.
                while (compare(yc, rem, yL, remL) < 1) {
                  n++;

                  // Subtract divisor from remainder.
                  subtract(rem, yL < remL ? yz : yc, remL, base);
                  remL = rem.length;
                }
              }
            } else if (cmp === 0) {
              n++;
              rem = [0];
            } // else cmp === 1 and n will be 0

            // Add the next digit, n, to the result array.
            qc[i++] = n;

            // Update the remainder.
            if (rem[0]) {
              rem[remL++] = xc[xi] || 0;
            } else {
              rem = [xc[xi]];
              remL = 1;
            }
          } while ((xi++ < xL || rem[0] != null) && s--);

          more = rem[0] != null;

          // Leading zero?
          if (!qc[0]) qc.splice(0, 1);
        }

        if (base == BASE) {

          // To calculate q.e, first get the number of digits of qc[0].
          for (i = 1, s = qc[0]; s >= 10; s /= 10, i++);

          round(q, dp + (q.e = i + e * LOG_BASE - 1) + 1, rm, more);

        // Caller is convertBase.
        } else {
          q.e = e;
          q.r = +more;
        }

        return q;
      };
    })();


    /*
     * Return a string representing the value of BigNumber n in fixed-point or exponential
     * notation rounded to the specified decimal places or significant digits.
     *
     * n: a BigNumber.
     * i: the index of the last digit required (i.e. the digit that may be rounded up).
     * rm: the rounding mode.
     * id: 1 (toExponential) or 2 (toPrecision).
     */
    function format(n, i, rm, id) {
      var c0, e, ne, len, str;

      if (rm == null) rm = ROUNDING_MODE;
      else intCheck(rm, 0, 8);

      if (!n.c) return n.toString();

      c0 = n.c[0];
      ne = n.e;

      if (i == null) {
        str = coeffToString(n.c);
        str = id == 1 || id == 2 && (ne <= TO_EXP_NEG || ne >= TO_EXP_POS)
         ? toExponential(str, ne)
         : toFixedPoint(str, ne, '0');
      } else {
        n = round(new BigNumber(n), i, rm);

        // n.e may have changed if the value was rounded up.
        e = n.e;

        str = coeffToString(n.c);
        len = str.length;

        // toPrecision returns exponential notation if the number of significant digits
        // specified is less than the number of digits necessary to represent the integer
        // part of the value in fixed-point notation.

        // Exponential notation.
        if (id == 1 || id == 2 && (i <= e || e <= TO_EXP_NEG)) {

          // Append zeros?
          for (; len < i; str += '0', len++);
          str = toExponential(str, e);

        // Fixed-point notation.
        } else {
          i -= ne;
          str = toFixedPoint(str, e, '0');

          // Append zeros?
          if (e + 1 > len) {
            if (--i > 0) for (str += '.'; i--; str += '0');
          } else {
            i += e - len;
            if (i > 0) {
              if (e + 1 == len) str += '.';
              for (; i--; str += '0');
            }
          }
        }
      }

      return n.s < 0 && c0 ? '-' + str : str;
    }


    // Handle BigNumber.max and BigNumber.min.
    // If any number is NaN, return NaN.
    function maxOrMin(args, n) {
      var k, y,
        i = 1,
        x = new BigNumber(args[0]);

      for (; i < args.length; i++) {
        y = new BigNumber(args[i]);
        if (!y.s || (k = compare(x, y)) === n || k === 0 && x.s === n) {
          x = y;
        }
      }

      return x;
    }


    /*
     * Strip trailing zeros, calculate base 10 exponent and check against MIN_EXP and MAX_EXP.
     * Called by minus, plus and times.
     */
    function normalise(n, c, e) {
      var i = 1,
        j = c.length;

       // Remove trailing zeros.
      for (; !c[--j]; c.pop());

      // Calculate the base 10 exponent. First get the number of digits of c[0].
      for (j = c[0]; j >= 10; j /= 10, i++);

      // Overflow?
      if ((e = i + e * LOG_BASE - 1) > MAX_EXP) {

        // Infinity.
        n.c = n.e = null;

      // Underflow?
      } else if (e < MIN_EXP) {

        // Zero.
        n.c = [n.e = 0];
      } else {
        n.e = e;
        n.c = c;
      }

      return n;
    }


    // Handle values that fail the validity test in BigNumber.
    parseNumeric = (function () {
      var basePrefix = /^(-?)0([xbo])(?=\w[\w.]*$)/i,
        dotAfter = /^([^.]+)\.$/,
        dotBefore = /^\.([^.]+)$/,
        isInfinityOrNaN = /^-?(Infinity|NaN)$/,
        whitespaceOrPlus = /^\s*\+(?=[\w.])|^\s+|\s+$/g;

      return function (x, str, isNum, b) {
        var base,
          s = isNum ? str : str.replace(whitespaceOrPlus, '');

        // No exception on ±Infinity or NaN.
        if (isInfinityOrNaN.test(s)) {
          x.s = isNaN(s) ? null : s < 0 ? -1 : 1;
        } else {
          if (!isNum) {

            // basePrefix = /^(-?)0([xbo])(?=\w[\w.]*$)/i
            s = s.replace(basePrefix, function (m, p1, p2) {
              base = (p2 = p2.toLowerCase()) == 'x' ? 16 : p2 == 'b' ? 2 : 8;
              return !b || b == base ? p1 : m;
            });

            if (b) {
              base = b;

              // E.g. '1.' to '1', '.1' to '0.1'
              s = s.replace(dotAfter, '$1').replace(dotBefore, '0.$1');
            }

            if (str != s) return new BigNumber(s, base);
          }

          // '[BigNumber Error] Not a number: {n}'
          // '[BigNumber Error] Not a base {b} number: {n}'
          if (BigNumber.DEBUG) {
            throw Error
              (bignumberError + 'Not a' + (b ? ' base ' + b : '') + ' number: ' + str);
          }

          // NaN
          x.s = null;
        }

        x.c = x.e = null;
      }
    })();


    /*
     * Round x to sd significant digits using rounding mode rm. Check for over/under-flow.
     * If r is truthy, it is known that there are more digits after the rounding digit.
     */
    function round(x, sd, rm, r) {
      var d, i, j, k, n, ni, rd,
        xc = x.c,
        pows10 = POWS_TEN;

      // if x is not Infinity or NaN...
      if (xc) {

        // rd is the rounding digit, i.e. the digit after the digit that may be rounded up.
        // n is a base 1e14 number, the value of the element of array x.c containing rd.
        // ni is the index of n within x.c.
        // d is the number of digits of n.
        // i is the index of rd within n including leading zeros.
        // j is the actual index of rd within n (if < 0, rd is a leading zero).
        out: {

          // Get the number of digits of the first element of xc.
          for (d = 1, k = xc[0]; k >= 10; k /= 10, d++);
          i = sd - d;

          // If the rounding digit is in the first element of xc...
          if (i < 0) {
            i += LOG_BASE;
            j = sd;
            n = xc[ni = 0];

            // Get the rounding digit at index j of n.
            rd = mathfloor(n / pows10[d - j - 1] % 10);
          } else {
            ni = mathceil((i + 1) / LOG_BASE);

            if (ni >= xc.length) {

              if (r) {

                // Needed by sqrt.
                for (; xc.length <= ni; xc.push(0));
                n = rd = 0;
                d = 1;
                i %= LOG_BASE;
                j = i - LOG_BASE + 1;
              } else {
                break out;
              }
            } else {
              n = k = xc[ni];

              // Get the number of digits of n.
              for (d = 1; k >= 10; k /= 10, d++);

              // Get the index of rd within n.
              i %= LOG_BASE;

              // Get the index of rd within n, adjusted for leading zeros.
              // The number of leading zeros of n is given by LOG_BASE - d.
              j = i - LOG_BASE + d;

              // Get the rounding digit at index j of n.
              rd = j < 0 ? 0 : mathfloor(n / pows10[d - j - 1] % 10);
            }
          }

          r = r || sd < 0 ||

          // Are there any non-zero digits after the rounding digit?
          // The expression  n % pows10[d - j - 1]  returns all digits of n to the right
          // of the digit at j, e.g. if n is 908714 and j is 2, the expression gives 714.
           xc[ni + 1] != null || (j < 0 ? n : n % pows10[d - j - 1]);

          r = rm < 4
           ? (rd || r) && (rm == 0 || rm == (x.s < 0 ? 3 : 2))
           : rd > 5 || rd == 5 && (rm == 4 || r || rm == 6 &&

            // Check whether the digit to the left of the rounding digit is odd.
            ((i > 0 ? j > 0 ? n / pows10[d - j] : 0 : xc[ni - 1]) % 10) & 1 ||
             rm == (x.s < 0 ? 8 : 7));

          if (sd < 1 || !xc[0]) {
            xc.length = 0;

            if (r) {

              // Convert sd to decimal places.
              sd -= x.e + 1;

              // 1, 0.1, 0.01, 0.001, 0.0001 etc.
              xc[0] = pows10[(LOG_BASE - sd % LOG_BASE) % LOG_BASE];
              x.e = -sd || 0;
            } else {

              // Zero.
              xc[0] = x.e = 0;
            }

            return x;
          }

          // Remove excess digits.
          if (i == 0) {
            xc.length = ni;
            k = 1;
            ni--;
          } else {
            xc.length = ni + 1;
            k = pows10[LOG_BASE - i];

            // E.g. 56700 becomes 56000 if 7 is the rounding digit.
            // j > 0 means i > number of leading zeros of n.
            xc[ni] = j > 0 ? mathfloor(n / pows10[d - j] % pows10[j]) * k : 0;
          }

          // Round up?
          if (r) {

            for (; ;) {

              // If the digit to be rounded up is in the first element of xc...
              if (ni == 0) {

                // i will be the length of xc[0] before k is added.
                for (i = 1, j = xc[0]; j >= 10; j /= 10, i++);
                j = xc[0] += k;
                for (k = 1; j >= 10; j /= 10, k++);

                // if i != k the length has increased.
                if (i != k) {
                  x.e++;
                  if (xc[0] == BASE) xc[0] = 1;
                }

                break;
              } else {
                xc[ni] += k;
                if (xc[ni] != BASE) break;
                xc[ni--] = 0;
                k = 1;
              }
            }
          }

          // Remove trailing zeros.
          for (i = xc.length; xc[--i] === 0; xc.pop());
        }

        // Overflow? Infinity.
        if (x.e > MAX_EXP) {
          x.c = x.e = null;

        // Underflow? Zero.
        } else if (x.e < MIN_EXP) {
          x.c = [x.e = 0];
        }
      }

      return x;
    }


    function valueOf(n) {
      var str,
        e = n.e;

      if (e === null) return n.toString();

      str = coeffToString(n.c);

      str = e <= TO_EXP_NEG || e >= TO_EXP_POS
        ? toExponential(str, e)
        : toFixedPoint(str, e, '0');

      return n.s < 0 ? '-' + str : str;
    }


    // PROTOTYPE/INSTANCE METHODS


    /*
     * Return a new BigNumber whose value is the absolute value of this BigNumber.
     */
    P.absoluteValue = P.abs = function () {
      var x = new BigNumber(this);
      if (x.s < 0) x.s = 1;
      return x;
    };


    /*
     * Return
     *   1 if the value of this BigNumber is greater than the value of BigNumber(y, b),
     *   -1 if the value of this BigNumber is less than the value of BigNumber(y, b),
     *   0 if they have the same value,
     *   or null if the value of either is NaN.
     */
    P.comparedTo = function (y, b) {
      return compare(this, new BigNumber(y, b));
    };


    /*
     * If dp is undefined or null or true or false, return the number of decimal places of the
     * value of this BigNumber, or null if the value of this BigNumber is ±Infinity or NaN.
     *
     * Otherwise, if dp is a number, return a new BigNumber whose value is the value of this
     * BigNumber rounded to a maximum of dp decimal places using rounding mode rm, or
     * ROUNDING_MODE if rm is omitted.
     *
     * [dp] {number} Decimal places: integer, 0 to MAX inclusive.
     * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
     *
     * '[BigNumber Error] Argument {not a primitive number|not an integer|out of range}: {dp|rm}'
     */
    P.decimalPlaces = P.dp = function (dp, rm) {
      var c, n, v,
        x = this;

      if (dp != null) {
        intCheck(dp, 0, MAX);
        if (rm == null) rm = ROUNDING_MODE;
        else intCheck(rm, 0, 8);

        return round(new BigNumber(x), dp + x.e + 1, rm);
      }

      if (!(c = x.c)) return null;
      n = ((v = c.length - 1) - bitFloor(this.e / LOG_BASE)) * LOG_BASE;

      // Subtract the number of trailing zeros of the last number.
      if (v = c[v]) for (; v % 10 == 0; v /= 10, n--);
      if (n < 0) n = 0;

      return n;
    };


    /*
     *  n / 0 = I
     *  n / N = N
     *  n / I = 0
     *  0 / n = 0
     *  0 / 0 = N
     *  0 / N = N
     *  0 / I = 0
     *  N / n = N
     *  N / 0 = N
     *  N / N = N
     *  N / I = N
     *  I / n = I
     *  I / 0 = I
     *  I / N = N
     *  I / I = N
     *
     * Return a new BigNumber whose value is the value of this BigNumber divided by the value of
     * BigNumber(y, b), rounded according to DECIMAL_PLACES and ROUNDING_MODE.
     */
    P.dividedBy = P.div = function (y, b) {
      return div(this, new BigNumber(y, b), DECIMAL_PLACES, ROUNDING_MODE);
    };


    /*
     * Return a new BigNumber whose value is the integer part of dividing the value of this
     * BigNumber by the value of BigNumber(y, b).
     */
    P.dividedToIntegerBy = P.idiv = function (y, b) {
      return div(this, new BigNumber(y, b), 0, 1);
    };


    /*
     * Return a BigNumber whose value is the value of this BigNumber exponentiated by n.
     *
     * If m is present, return the result modulo m.
     * If n is negative round according to DECIMAL_PLACES and ROUNDING_MODE.
     * If POW_PRECISION is non-zero and m is not present, round to POW_PRECISION using ROUNDING_MODE.
     *
     * The modular power operation works efficiently when x, n, and m are integers, otherwise it
     * is equivalent to calculating x.exponentiatedBy(n).modulo(m) with a POW_PRECISION of 0.
     *
     * n {number|string|BigNumber} The exponent. An integer.
     * [m] {number|string|BigNumber} The modulus.
     *
     * '[BigNumber Error] Exponent not an integer: {n}'
     */
    P.exponentiatedBy = P.pow = function (n, m) {
      var half, isModExp, i, k, more, nIsBig, nIsNeg, nIsOdd, y,
        x = this;

      n = new BigNumber(n);

      // Allow NaN and ±Infinity, but not other non-integers.
      if (n.c && !n.isInteger()) {
        throw Error
          (bignumberError + 'Exponent not an integer: ' + valueOf(n));
      }

      if (m != null) m = new BigNumber(m);

      // Exponent of MAX_SAFE_INTEGER is 15.
      nIsBig = n.e > 14;

      // If x is NaN, ±Infinity, ±0 or ±1, or n is ±Infinity, NaN or ±0.
      if (!x.c || !x.c[0] || x.c[0] == 1 && !x.e && x.c.length == 1 || !n.c || !n.c[0]) {

        // The sign of the result of pow when x is negative depends on the evenness of n.
        // If +n overflows to ±Infinity, the evenness of n would be not be known.
        y = new BigNumber(Math.pow(+valueOf(x), nIsBig ? n.s * (2 - isOdd(n)) : +valueOf(n)));
        return m ? y.mod(m) : y;
      }

      nIsNeg = n.s < 0;

      if (m) {

        // x % m returns NaN if abs(m) is zero, or m is NaN.
        if (m.c ? !m.c[0] : !m.s) return new BigNumber(NaN);

        isModExp = !nIsNeg && x.isInteger() && m.isInteger();

        if (isModExp) x = x.mod(m);

      // Overflow to ±Infinity: >=2**1e10 or >=1.0000024**1e15.
      // Underflow to ±0: <=0.79**1e10 or <=0.9999975**1e15.
      } else if (n.e > 9 && (x.e > 0 || x.e < -1 || (x.e == 0
        // [1, 240000000]
        ? x.c[0] > 1 || nIsBig && x.c[1] >= 24e7
        // [80000000000000]  [99999750000000]
        : x.c[0] < 8e13 || nIsBig && x.c[0] <= 9999975e7))) {

        // If x is negative and n is odd, k = -0, else k = 0.
        k = x.s < 0 && isOdd(n) ? -0 : 0;

        // If x >= 1, k = ±Infinity.
        if (x.e > -1) k = 1 / k;

        // If n is negative return ±0, else return ±Infinity.
        return new BigNumber(nIsNeg ? 1 / k : k);

      } else if (POW_PRECISION) {

        // Truncating each coefficient array to a length of k after each multiplication
        // equates to truncating significant digits to POW_PRECISION + [28, 41],
        // i.e. there will be a minimum of 28 guard digits retained.
        k = mathceil(POW_PRECISION / LOG_BASE + 2);
      }

      if (nIsBig) {
        half = new BigNumber(0.5);
        if (nIsNeg) n.s = 1;
        nIsOdd = isOdd(n);
      } else {
        i = Math.abs(+valueOf(n));
        nIsOdd = i % 2;
      }

      y = new BigNumber(ONE);

      // Performs 54 loop iterations for n of 9007199254740991.
      for (; ;) {

        if (nIsOdd) {
          y = y.times(x);
          if (!y.c) break;

          if (k) {
            if (y.c.length > k) y.c.length = k;
          } else if (isModExp) {
            y = y.mod(m);    //y = y.minus(div(y, m, 0, MODULO_MODE).times(m));
          }
        }

        if (i) {
          i = mathfloor(i / 2);
          if (i === 0) break;
          nIsOdd = i % 2;
        } else {
          n = n.times(half);
          round(n, n.e + 1, 1);

          if (n.e > 14) {
            nIsOdd = isOdd(n);
          } else {
            i = +valueOf(n);
            if (i === 0) break;
            nIsOdd = i % 2;
          }
        }

        x = x.times(x);

        if (k) {
          if (x.c && x.c.length > k) x.c.length = k;
        } else if (isModExp) {
          x = x.mod(m);    //x = x.minus(div(x, m, 0, MODULO_MODE).times(m));
        }
      }

      if (isModExp) return y;
      if (nIsNeg) y = ONE.div(y);

      return m ? y.mod(m) : k ? round(y, POW_PRECISION, ROUNDING_MODE, more) : y;
    };


    /*
     * Return a new BigNumber whose value is the value of this BigNumber rounded to an integer
     * using rounding mode rm, or ROUNDING_MODE if rm is omitted.
     *
     * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
     *
     * '[BigNumber Error] Argument {not a primitive number|not an integer|out of range}: {rm}'
     */
    P.integerValue = function (rm) {
      var n = new BigNumber(this);
      if (rm == null) rm = ROUNDING_MODE;
      else intCheck(rm, 0, 8);
      return round(n, n.e + 1, rm);
    };


    /*
     * Return true if the value of this BigNumber is equal to the value of BigNumber(y, b),
     * otherwise return false.
     */
    P.isEqualTo = P.eq = function (y, b) {
      return compare(this, new BigNumber(y, b)) === 0;
    };


    /*
     * Return true if the value of this BigNumber is a finite number, otherwise return false.
     */
    P.isFinite = function () {
      return !!this.c;
    };


    /*
     * Return true if the value of this BigNumber is greater than the value of BigNumber(y, b),
     * otherwise return false.
     */
    P.isGreaterThan = P.gt = function (y, b) {
      return compare(this, new BigNumber(y, b)) > 0;
    };


    /*
     * Return true if the value of this BigNumber is greater than or equal to the value of
     * BigNumber(y, b), otherwise return false.
     */
    P.isGreaterThanOrEqualTo = P.gte = function (y, b) {
      return (b = compare(this, new BigNumber(y, b))) === 1 || b === 0;

    };


    /*
     * Return true if the value of this BigNumber is an integer, otherwise return false.
     */
    P.isInteger = function () {
      return !!this.c && bitFloor(this.e / LOG_BASE) > this.c.length - 2;
    };


    /*
     * Return true if the value of this BigNumber is less than the value of BigNumber(y, b),
     * otherwise return false.
     */
    P.isLessThan = P.lt = function (y, b) {
      return compare(this, new BigNumber(y, b)) < 0;
    };


    /*
     * Return true if the value of this BigNumber is less than or equal to the value of
     * BigNumber(y, b), otherwise return false.
     */
    P.isLessThanOrEqualTo = P.lte = function (y, b) {
      return (b = compare(this, new BigNumber(y, b))) === -1 || b === 0;
    };


    /*
     * Return true if the value of this BigNumber is NaN, otherwise return false.
     */
    P.isNaN = function () {
      return !this.s;
    };


    /*
     * Return true if the value of this BigNumber is negative, otherwise return false.
     */
    P.isNegative = function () {
      return this.s < 0;
    };


    /*
     * Return true if the value of this BigNumber is positive, otherwise return false.
     */
    P.isPositive = function () {
      return this.s > 0;
    };


    /*
     * Return true if the value of this BigNumber is 0 or -0, otherwise return false.
     */
    P.isZero = function () {
      return !!this.c && this.c[0] == 0;
    };


    /*
     *  n - 0 = n
     *  n - N = N
     *  n - I = -I
     *  0 - n = -n
     *  0 - 0 = 0
     *  0 - N = N
     *  0 - I = -I
     *  N - n = N
     *  N - 0 = N
     *  N - N = N
     *  N - I = N
     *  I - n = I
     *  I - 0 = I
     *  I - N = N
     *  I - I = N
     *
     * Return a new BigNumber whose value is the value of this BigNumber minus the value of
     * BigNumber(y, b).
     */
    P.minus = function (y, b) {
      var i, j, t, xLTy,
        x = this,
        a = x.s;

      y = new BigNumber(y, b);
      b = y.s;

      // Either NaN?
      if (!a || !b) return new BigNumber(NaN);

      // Signs differ?
      if (a != b) {
        y.s = -b;
        return x.plus(y);
      }

      var xe = x.e / LOG_BASE,
        ye = y.e / LOG_BASE,
        xc = x.c,
        yc = y.c;

      if (!xe || !ye) {

        // Either Infinity?
        if (!xc || !yc) return xc ? (y.s = -b, y) : new BigNumber(yc ? x : NaN);

        // Either zero?
        if (!xc[0] || !yc[0]) {

          // Return y if y is non-zero, x if x is non-zero, or zero if both are zero.
          return yc[0] ? (y.s = -b, y) : new BigNumber(xc[0] ? x :

           // IEEE 754 (2008) 6.3: n - n = -0 when rounding to -Infinity
           ROUNDING_MODE == 3 ? -0 : 0);
        }
      }

      xe = bitFloor(xe);
      ye = bitFloor(ye);
      xc = xc.slice();

      // Determine which is the bigger number.
      if (a = xe - ye) {

        if (xLTy = a < 0) {
          a = -a;
          t = xc;
        } else {
          ye = xe;
          t = yc;
        }

        t.reverse();

        // Prepend zeros to equalise exponents.
        for (b = a; b--; t.push(0));
        t.reverse();
      } else {

        // Exponents equal. Check digit by digit.
        j = (xLTy = (a = xc.length) < (b = yc.length)) ? a : b;

        for (a = b = 0; b < j; b++) {

          if (xc[b] != yc[b]) {
            xLTy = xc[b] < yc[b];
            break;
          }
        }
      }

      // x < y? Point xc to the array of the bigger number.
      if (xLTy) {
        t = xc;
        xc = yc;
        yc = t;
        y.s = -y.s;
      }

      b = (j = yc.length) - (i = xc.length);

      // Append zeros to xc if shorter.
      // No need to add zeros to yc if shorter as subtract only needs to start at yc.length.
      if (b > 0) for (; b--; xc[i++] = 0);
      b = BASE - 1;

      // Subtract yc from xc.
      for (; j > a;) {

        if (xc[--j] < yc[j]) {
          for (i = j; i && !xc[--i]; xc[i] = b);
          --xc[i];
          xc[j] += BASE;
        }

        xc[j] -= yc[j];
      }

      // Remove leading zeros and adjust exponent accordingly.
      for (; xc[0] == 0; xc.splice(0, 1), --ye);

      // Zero?
      if (!xc[0]) {

        // Following IEEE 754 (2008) 6.3,
        // n - n = +0  but  n - n = -0  when rounding towards -Infinity.
        y.s = ROUNDING_MODE == 3 ? -1 : 1;
        y.c = [y.e = 0];
        return y;
      }

      // No need to check for Infinity as +x - +y != Infinity && -x - -y != Infinity
      // for finite x and y.
      return normalise(y, xc, ye);
    };


    /*
     *   n % 0 =  N
     *   n % N =  N
     *   n % I =  n
     *   0 % n =  0
     *  -0 % n = -0
     *   0 % 0 =  N
     *   0 % N =  N
     *   0 % I =  0
     *   N % n =  N
     *   N % 0 =  N
     *   N % N =  N
     *   N % I =  N
     *   I % n =  N
     *   I % 0 =  N
     *   I % N =  N
     *   I % I =  N
     *
     * Return a new BigNumber whose value is the value of this BigNumber modulo the value of
     * BigNumber(y, b). The result depends on the value of MODULO_MODE.
     */
    P.modulo = P.mod = function (y, b) {
      var q, s,
        x = this;

      y = new BigNumber(y, b);

      // Return NaN if x is Infinity or NaN, or y is NaN or zero.
      if (!x.c || !y.s || y.c && !y.c[0]) {
        return new BigNumber(NaN);

      // Return x if y is Infinity or x is zero.
      } else if (!y.c || x.c && !x.c[0]) {
        return new BigNumber(x);
      }

      if (MODULO_MODE == 9) {

        // Euclidian division: q = sign(y) * floor(x / abs(y))
        // r = x - qy    where  0 <= r < abs(y)
        s = y.s;
        y.s = 1;
        q = div(x, y, 0, 3);
        y.s = s;
        q.s *= s;
      } else {
        q = div(x, y, 0, MODULO_MODE);
      }

      y = x.minus(q.times(y));

      // To match JavaScript %, ensure sign of zero is sign of dividend.
      if (!y.c[0] && MODULO_MODE == 1) y.s = x.s;

      return y;
    };


    /*
     *  n * 0 = 0
     *  n * N = N
     *  n * I = I
     *  0 * n = 0
     *  0 * 0 = 0
     *  0 * N = N
     *  0 * I = N
     *  N * n = N
     *  N * 0 = N
     *  N * N = N
     *  N * I = N
     *  I * n = I
     *  I * 0 = N
     *  I * N = N
     *  I * I = I
     *
     * Return a new BigNumber whose value is the value of this BigNumber multiplied by the value
     * of BigNumber(y, b).
     */
    P.multipliedBy = P.times = function (y, b) {
      var c, e, i, j, k, m, xcL, xlo, xhi, ycL, ylo, yhi, zc,
        base, sqrtBase,
        x = this,
        xc = x.c,
        yc = (y = new BigNumber(y, b)).c;

      // Either NaN, ±Infinity or ±0?
      if (!xc || !yc || !xc[0] || !yc[0]) {

        // Return NaN if either is NaN, or one is 0 and the other is Infinity.
        if (!x.s || !y.s || xc && !xc[0] && !yc || yc && !yc[0] && !xc) {
          y.c = y.e = y.s = null;
        } else {
          y.s *= x.s;

          // Return ±Infinity if either is ±Infinity.
          if (!xc || !yc) {
            y.c = y.e = null;

          // Return ±0 if either is ±0.
          } else {
            y.c = [0];
            y.e = 0;
          }
        }

        return y;
      }

      e = bitFloor(x.e / LOG_BASE) + bitFloor(y.e / LOG_BASE);
      y.s *= x.s;
      xcL = xc.length;
      ycL = yc.length;

      // Ensure xc points to longer array and xcL to its length.
      if (xcL < ycL) {
        zc = xc;
        xc = yc;
        yc = zc;
        i = xcL;
        xcL = ycL;
        ycL = i;
      }

      // Initialise the result array with zeros.
      for (i = xcL + ycL, zc = []; i--; zc.push(0));

      base = BASE;
      sqrtBase = SQRT_BASE;

      for (i = ycL; --i >= 0;) {
        c = 0;
        ylo = yc[i] % sqrtBase;
        yhi = yc[i] / sqrtBase | 0;

        for (k = xcL, j = i + k; j > i;) {
          xlo = xc[--k] % sqrtBase;
          xhi = xc[k] / sqrtBase | 0;
          m = yhi * xlo + xhi * ylo;
          xlo = ylo * xlo + ((m % sqrtBase) * sqrtBase) + zc[j] + c;
          c = (xlo / base | 0) + (m / sqrtBase | 0) + yhi * xhi;
          zc[j--] = xlo % base;
        }

        zc[j] = c;
      }

      if (c) {
        ++e;
      } else {
        zc.splice(0, 1);
      }

      return normalise(y, zc, e);
    };


    /*
     * Return a new BigNumber whose value is the value of this BigNumber negated,
     * i.e. multiplied by -1.
     */
    P.negated = function () {
      var x = new BigNumber(this);
      x.s = -x.s || null;
      return x;
    };


    /*
     *  n + 0 = n
     *  n + N = N
     *  n + I = I
     *  0 + n = n
     *  0 + 0 = 0
     *  0 + N = N
     *  0 + I = I
     *  N + n = N
     *  N + 0 = N
     *  N + N = N
     *  N + I = N
     *  I + n = I
     *  I + 0 = I
     *  I + N = N
     *  I + I = I
     *
     * Return a new BigNumber whose value is the value of this BigNumber plus the value of
     * BigNumber(y, b).
     */
    P.plus = function (y, b) {
      var t,
        x = this,
        a = x.s;

      y = new BigNumber(y, b);
      b = y.s;

      // Either NaN?
      if (!a || !b) return new BigNumber(NaN);

      // Signs differ?
       if (a != b) {
        y.s = -b;
        return x.minus(y);
      }

      var xe = x.e / LOG_BASE,
        ye = y.e / LOG_BASE,
        xc = x.c,
        yc = y.c;

      if (!xe || !ye) {

        // Return ±Infinity if either ±Infinity.
        if (!xc || !yc) return new BigNumber(a / 0);

        // Either zero?
        // Return y if y is non-zero, x if x is non-zero, or zero if both are zero.
        if (!xc[0] || !yc[0]) return yc[0] ? y : new BigNumber(xc[0] ? x : a * 0);
      }

      xe = bitFloor(xe);
      ye = bitFloor(ye);
      xc = xc.slice();

      // Prepend zeros to equalise exponents. Faster to use reverse then do unshifts.
      if (a = xe - ye) {
        if (a > 0) {
          ye = xe;
          t = yc;
        } else {
          a = -a;
          t = xc;
        }

        t.reverse();
        for (; a--; t.push(0));
        t.reverse();
      }

      a = xc.length;
      b = yc.length;

      // Point xc to the longer array, and b to the shorter length.
      if (a - b < 0) {
        t = yc;
        yc = xc;
        xc = t;
        b = a;
      }

      // Only start adding at yc.length - 1 as the further digits of xc can be ignored.
      for (a = 0; b;) {
        a = (xc[--b] = xc[b] + yc[b] + a) / BASE | 0;
        xc[b] = BASE === xc[b] ? 0 : xc[b] % BASE;
      }

      if (a) {
        xc = [a].concat(xc);
        ++ye;
      }

      // No need to check for zero, as +x + +y != 0 && -x + -y != 0
      // ye = MAX_EXP + 1 possible
      return normalise(y, xc, ye);
    };


    /*
     * If sd is undefined or null or true or false, return the number of significant digits of
     * the value of this BigNumber, or null if the value of this BigNumber is ±Infinity or NaN.
     * If sd is true include integer-part trailing zeros in the count.
     *
     * Otherwise, if sd is a number, return a new BigNumber whose value is the value of this
     * BigNumber rounded to a maximum of sd significant digits using rounding mode rm, or
     * ROUNDING_MODE if rm is omitted.
     *
     * sd {number|boolean} number: significant digits: integer, 1 to MAX inclusive.
     *                     boolean: whether to count integer-part trailing zeros: true or false.
     * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
     *
     * '[BigNumber Error] Argument {not a primitive number|not an integer|out of range}: {sd|rm}'
     */
    P.precision = P.sd = function (sd, rm) {
      var c, n, v,
        x = this;

      if (sd != null && sd !== !!sd) {
        intCheck(sd, 1, MAX);
        if (rm == null) rm = ROUNDING_MODE;
        else intCheck(rm, 0, 8);

        return round(new BigNumber(x), sd, rm);
      }

      if (!(c = x.c)) return null;
      v = c.length - 1;
      n = v * LOG_BASE + 1;

      if (v = c[v]) {

        // Subtract the number of trailing zeros of the last element.
        for (; v % 10 == 0; v /= 10, n--);

        // Add the number of digits of the first element.
        for (v = c[0]; v >= 10; v /= 10, n++);
      }

      if (sd && x.e + 1 > n) n = x.e + 1;

      return n;
    };


    /*
     * Return a new BigNumber whose value is the value of this BigNumber shifted by k places
     * (powers of 10). Shift to the right if n > 0, and to the left if n < 0.
     *
     * k {number} Integer, -MAX_SAFE_INTEGER to MAX_SAFE_INTEGER inclusive.
     *
     * '[BigNumber Error] Argument {not a primitive number|not an integer|out of range}: {k}'
     */
    P.shiftedBy = function (k) {
      intCheck(k, -MAX_SAFE_INTEGER, MAX_SAFE_INTEGER);
      return this.times('1e' + k);
    };


    /*
     *  sqrt(-n) =  N
     *  sqrt(N) =  N
     *  sqrt(-I) =  N
     *  sqrt(I) =  I
     *  sqrt(0) =  0
     *  sqrt(-0) = -0
     *
     * Return a new BigNumber whose value is the square root of the value of this BigNumber,
     * rounded according to DECIMAL_PLACES and ROUNDING_MODE.
     */
    P.squareRoot = P.sqrt = function () {
      var m, n, r, rep, t,
        x = this,
        c = x.c,
        s = x.s,
        e = x.e,
        dp = DECIMAL_PLACES + 4,
        half = new BigNumber('0.5');

      // Negative/NaN/Infinity/zero?
      if (s !== 1 || !c || !c[0]) {
        return new BigNumber(!s || s < 0 && (!c || c[0]) ? NaN : c ? x : 1 / 0);
      }

      // Initial estimate.
      s = Math.sqrt(+valueOf(x));

      // Math.sqrt underflow/overflow?
      // Pass x to Math.sqrt as integer, then adjust the exponent of the result.
      if (s == 0 || s == 1 / 0) {
        n = coeffToString(c);
        if ((n.length + e) % 2 == 0) n += '0';
        s = Math.sqrt(+n);
        e = bitFloor((e + 1) / 2) - (e < 0 || e % 2);

        if (s == 1 / 0) {
          n = '5e' + e;
        } else {
          n = s.toExponential();
          n = n.slice(0, n.indexOf('e') + 1) + e;
        }

        r = new BigNumber(n);
      } else {
        r = new BigNumber(s + '');
      }

      // Check for zero.
      // r could be zero if MIN_EXP is changed after the this value was created.
      // This would cause a division by zero (x/t) and hence Infinity below, which would cause
      // coeffToString to throw.
      if (r.c[0]) {
        e = r.e;
        s = e + dp;
        if (s < 3) s = 0;

        // Newton-Raphson iteration.
        for (; ;) {
          t = r;
          r = half.times(t.plus(div(x, t, dp, 1)));

          if (coeffToString(t.c).slice(0, s) === (n = coeffToString(r.c)).slice(0, s)) {

            // The exponent of r may here be one less than the final result exponent,
            // e.g 0.0009999 (e-4) -- > 0.001 (e-3), so adjust s so the rounding digits
            // are indexed correctly.
            if (r.e < e) --s;
            n = n.slice(s - 3, s + 1);

            // The 4th rounding digit may be in error by -1 so if the 4 rounding digits
            // are 9999 or 4999 (i.e. approaching a rounding boundary) continue the
            // iteration.
            if (n == '9999' || !rep && n == '4999') {

              // On the first iteration only, check to see if rounding up gives the
              // exact result as the nines may infinitely repeat.
              if (!rep) {
                round(t, t.e + DECIMAL_PLACES + 2, 0);

                if (t.times(t).eq(x)) {
                  r = t;
                  break;
                }
              }

              dp += 4;
              s += 4;
              rep = 1;
            } else {

              // If rounding digits are null, 0{0,4} or 50{0,3}, check for exact
              // result. If not, then there are further digits and m will be truthy.
              if (!+n || !+n.slice(1) && n.charAt(0) == '5') {

                // Truncate to the first rounding digit.
                round(r, r.e + DECIMAL_PLACES + 2, 1);
                m = !r.times(r).eq(x);
              }

              break;
            }
          }
        }
      }

      return round(r, r.e + DECIMAL_PLACES + 1, ROUNDING_MODE, m);
    };


    /*
     * Return a string representing the value of this BigNumber in exponential notation and
     * rounded using ROUNDING_MODE to dp fixed decimal places.
     *
     * [dp] {number} Decimal places. Integer, 0 to MAX inclusive.
     * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
     *
     * '[BigNumber Error] Argument {not a primitive number|not an integer|out of range}: {dp|rm}'
     */
    P.toExponential = function (dp, rm) {
      if (dp != null) {
        intCheck(dp, 0, MAX);
        dp++;
      }
      return format(this, dp, rm, 1);
    };


    /*
     * Return a string representing the value of this BigNumber in fixed-point notation rounding
     * to dp fixed decimal places using rounding mode rm, or ROUNDING_MODE if rm is omitted.
     *
     * Note: as with JavaScript's number type, (-0).toFixed(0) is '0',
     * but e.g. (-0.00001).toFixed(0) is '-0'.
     *
     * [dp] {number} Decimal places. Integer, 0 to MAX inclusive.
     * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
     *
     * '[BigNumber Error] Argument {not a primitive number|not an integer|out of range}: {dp|rm}'
     */
    P.toFixed = function (dp, rm) {
      if (dp != null) {
        intCheck(dp, 0, MAX);
        dp = dp + this.e + 1;
      }
      return format(this, dp, rm);
    };


    /*
     * Return a string representing the value of this BigNumber in fixed-point notation rounded
     * using rm or ROUNDING_MODE to dp decimal places, and formatted according to the properties
     * of the format or FORMAT object (see BigNumber.set).
     *
     * The formatting object may contain some or all of the properties shown below.
     *
     * FORMAT = {
     *   prefix: '',
     *   groupSize: 3,
     *   secondaryGroupSize: 0,
     *   groupSeparator: ',',
     *   decimalSeparator: '.',
     *   fractionGroupSize: 0,
     *   fractionGroupSeparator: '\xA0',      // non-breaking space
     *   suffix: ''
     * };
     *
     * [dp] {number} Decimal places. Integer, 0 to MAX inclusive.
     * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
     * [format] {object} Formatting options. See FORMAT pbject above.
     *
     * '[BigNumber Error] Argument {not a primitive number|not an integer|out of range}: {dp|rm}'
     * '[BigNumber Error] Argument not an object: {format}'
     */
    P.toFormat = function (dp, rm, format) {
      var str,
        x = this;

      if (format == null) {
        if (dp != null && rm && typeof rm == 'object') {
          format = rm;
          rm = null;
        } else if (dp && typeof dp == 'object') {
          format = dp;
          dp = rm = null;
        } else {
          format = FORMAT;
        }
      } else if (typeof format != 'object') {
        throw Error
          (bignumberError + 'Argument not an object: ' + format);
      }

      str = x.toFixed(dp, rm);

      if (x.c) {
        var i,
          arr = str.split('.'),
          g1 = +format.groupSize,
          g2 = +format.secondaryGroupSize,
          groupSeparator = format.groupSeparator || '',
          intPart = arr[0],
          fractionPart = arr[1],
          isNeg = x.s < 0,
          intDigits = isNeg ? intPart.slice(1) : intPart,
          len = intDigits.length;

        if (g2) {
          i = g1;
          g1 = g2;
          g2 = i;
          len -= i;
        }

        if (g1 > 0 && len > 0) {
          i = len % g1 || g1;
          intPart = intDigits.substr(0, i);
          for (; i < len; i += g1) intPart += groupSeparator + intDigits.substr(i, g1);
          if (g2 > 0) intPart += groupSeparator + intDigits.slice(i);
          if (isNeg) intPart = '-' + intPart;
        }

        str = fractionPart
         ? intPart + (format.decimalSeparator || '') + ((g2 = +format.fractionGroupSize)
          ? fractionPart.replace(new RegExp('\\d{' + g2 + '}\\B', 'g'),
           '$&' + (format.fractionGroupSeparator || ''))
          : fractionPart)
         : intPart;
      }

      return (format.prefix || '') + str + (format.suffix || '');
    };


    /*
     * Return an array of two BigNumbers representing the value of this BigNumber as a simple
     * fraction with an integer numerator and an integer denominator.
     * The denominator will be a positive non-zero value less than or equal to the specified
     * maximum denominator. If a maximum denominator is not specified, the denominator will be
     * the lowest value necessary to represent the number exactly.
     *
     * [md] {number|string|BigNumber} Integer >= 1, or Infinity. The maximum denominator.
     *
     * '[BigNumber Error] Argument {not an integer|out of range} : {md}'
     */
    P.toFraction = function (md) {
      var d, d0, d1, d2, e, exp, n, n0, n1, q, r, s,
        x = this,
        xc = x.c;

      if (md != null) {
        n = new BigNumber(md);

        // Throw if md is less than one or is not an integer, unless it is Infinity.
        if (!n.isInteger() && (n.c || n.s !== 1) || n.lt(ONE)) {
          throw Error
            (bignumberError + 'Argument ' +
              (n.isInteger() ? 'out of range: ' : 'not an integer: ') + valueOf(n));
        }
      }

      if (!xc) return new BigNumber(x);

      d = new BigNumber(ONE);
      n1 = d0 = new BigNumber(ONE);
      d1 = n0 = new BigNumber(ONE);
      s = coeffToString(xc);

      // Determine initial denominator.
      // d is a power of 10 and the minimum max denominator that specifies the value exactly.
      e = d.e = s.length - x.e - 1;
      d.c[0] = POWS_TEN[(exp = e % LOG_BASE) < 0 ? LOG_BASE + exp : exp];
      md = !md || n.comparedTo(d) > 0 ? (e > 0 ? d : n1) : n;

      exp = MAX_EXP;
      MAX_EXP = 1 / 0;
      n = new BigNumber(s);

      // n0 = d1 = 0
      n0.c[0] = 0;

      for (; ;)  {
        q = div(n, d, 0, 1);
        d2 = d0.plus(q.times(d1));
        if (d2.comparedTo(md) == 1) break;
        d0 = d1;
        d1 = d2;
        n1 = n0.plus(q.times(d2 = n1));
        n0 = d2;
        d = n.minus(q.times(d2 = d));
        n = d2;
      }

      d2 = div(md.minus(d0), d1, 0, 1);
      n0 = n0.plus(d2.times(n1));
      d0 = d0.plus(d2.times(d1));
      n0.s = n1.s = x.s;
      e = e * 2;

      // Determine which fraction is closer to x, n0/d0 or n1/d1
      r = div(n1, d1, e, ROUNDING_MODE).minus(x).abs().comparedTo(
          div(n0, d0, e, ROUNDING_MODE).minus(x).abs()) < 1 ? [n1, d1] : [n0, d0];

      MAX_EXP = exp;

      return r;
    };


    /*
     * Return the value of this BigNumber converted to a number primitive.
     */
    P.toNumber = function () {
      return +valueOf(this);
    };


    /*
     * Return a string representing the value of this BigNumber rounded to sd significant digits
     * using rounding mode rm or ROUNDING_MODE. If sd is less than the number of digits
     * necessary to represent the integer part of the value in fixed-point notation, then use
     * exponential notation.
     *
     * [sd] {number} Significant digits. Integer, 1 to MAX inclusive.
     * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
     *
     * '[BigNumber Error] Argument {not a primitive number|not an integer|out of range}: {sd|rm}'
     */
    P.toPrecision = function (sd, rm) {
      if (sd != null) intCheck(sd, 1, MAX);
      return format(this, sd, rm, 2);
    };


    /*
     * Return a string representing the value of this BigNumber in base b, or base 10 if b is
     * omitted. If a base is specified, including base 10, round according to DECIMAL_PLACES and
     * ROUNDING_MODE. If a base is not specified, and this BigNumber has a positive exponent
     * that is equal to or greater than TO_EXP_POS, or a negative exponent equal to or less than
     * TO_EXP_NEG, return exponential notation.
     *
     * [b] {number} Integer, 2 to ALPHABET.length inclusive.
     *
     * '[BigNumber Error] Base {not a primitive number|not an integer|out of range}: {b}'
     */
    P.toString = function (b) {
      var str,
        n = this,
        s = n.s,
        e = n.e;

      // Infinity or NaN?
      if (e === null) {
        if (s) {
          str = 'Infinity';
          if (s < 0) str = '-' + str;
        } else {
          str = 'NaN';
        }
      } else {
        if (b == null) {
          str = e <= TO_EXP_NEG || e >= TO_EXP_POS
           ? toExponential(coeffToString(n.c), e)
           : toFixedPoint(coeffToString(n.c), e, '0');
        } else if (b === 10 && alphabetHasNormalDecimalDigits) {
          n = round(new BigNumber(n), DECIMAL_PLACES + e + 1, ROUNDING_MODE);
          str = toFixedPoint(coeffToString(n.c), n.e, '0');
        } else {
          intCheck(b, 2, ALPHABET.length, 'Base');
          str = convertBase(toFixedPoint(coeffToString(n.c), e, '0'), 10, b, s, true);
        }

        if (s < 0 && n.c[0]) str = '-' + str;
      }

      return str;
    };


    /*
     * Return as toString, but do not accept a base argument, and include the minus sign for
     * negative zero.
     */
    P.valueOf = P.toJSON = function () {
      return valueOf(this);
    };


    P._isBigNumber = true;

    if (configObject != null) BigNumber.set(configObject);

    return BigNumber;
  }


  // PRIVATE HELPER FUNCTIONS

  // These functions don't need access to variables,
  // e.g. DECIMAL_PLACES, in the scope of the `clone` function above.


  function bitFloor(n) {
    var i = n | 0;
    return n > 0 || n === i ? i : i - 1;
  }


  // Return a coefficient array as a string of base 10 digits.
  function coeffToString(a) {
    var s, z,
      i = 1,
      j = a.length,
      r = a[0] + '';

    for (; i < j;) {
      s = a[i++] + '';
      z = LOG_BASE - s.length;
      for (; z--; s = '0' + s);
      r += s;
    }

    // Determine trailing zeros.
    for (j = r.length; r.charCodeAt(--j) === 48;);

    return r.slice(0, j + 1 || 1);
  }


  // Compare the value of BigNumbers x and y.
  function compare(x, y) {
    var a, b,
      xc = x.c,
      yc = y.c,
      i = x.s,
      j = y.s,
      k = x.e,
      l = y.e;

    // Either NaN?
    if (!i || !j) return null;

    a = xc && !xc[0];
    b = yc && !yc[0];

    // Either zero?
    if (a || b) return a ? b ? 0 : -j : i;

    // Signs differ?
    if (i != j) return i;

    a = i < 0;
    b = k == l;

    // Either Infinity?
    if (!xc || !yc) return b ? 0 : !xc ^ a ? 1 : -1;

    // Compare exponents.
    if (!b) return k > l ^ a ? 1 : -1;

    j = (k = xc.length) < (l = yc.length) ? k : l;

    // Compare digit by digit.
    for (i = 0; i < j; i++) if (xc[i] != yc[i]) return xc[i] > yc[i] ^ a ? 1 : -1;

    // Compare lengths.
    return k == l ? 0 : k > l ^ a ? 1 : -1;
  }


  /*
   * Check that n is a primitive number, an integer, and in range, otherwise throw.
   */
  function intCheck(n, min, max, name) {
    if (n < min || n > max || n !== mathfloor(n)) {
      throw Error
       (bignumberError + (name || 'Argument') + (typeof n == 'number'
         ? n < min || n > max ? ' out of range: ' : ' not an integer: '
         : ' not a primitive number: ') + String(n));
    }
  }


  // Assumes finite n.
  function isOdd(n) {
    var k = n.c.length - 1;
    return bitFloor(n.e / LOG_BASE) == k && n.c[k] % 2 != 0;
  }


  function toExponential(str, e) {
    return (str.length > 1 ? str.charAt(0) + '.' + str.slice(1) : str) +
     (e < 0 ? 'e' : 'e+') + e;
  }


  function toFixedPoint(str, e, z) {
    var len, zs;

    // Negative exponent?
    if (e < 0) {

      // Prepend zeros.
      for (zs = z + '.'; ++e; zs += z);
      str = zs + str;

    // Positive exponent
    } else {
      len = str.length;

      // Append zeros.
      if (++e > len) {
        for (zs = z, e -= len; --e; zs += z);
        str += zs;
      } else if (e < len) {
        str = str.slice(0, e) + '.' + str.slice(e);
      }
    }

    return str;
  }


  // EXPORT


  BigNumber = clone();
  BigNumber['default'] = BigNumber.BigNumber = BigNumber;

  // AMD.
  if (typeof define == 'function' && define.amd) {
    define(function () { return BigNumber; });

  // Node.js and other environments that support module.exports.
  } else if (typeof module != 'undefined' && module.exports) {
    module.exports = BigNumber;

  // Browser.
  } else {
    if (!globalObject) {
      globalObject = typeof self != 'undefined' && self ? self : window;
    }

    globalObject.BigNumber = BigNumber;
  }
})(this);

      };
    };
  }
  }
}, {package:"@metamask/smart-transactions-controller>bignumber.js",file:"node_modules\\@metamask\\smart-transactions-controller\\node_modules\\bignumber.js\\bignumber.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\smart-transactions-controller\\package.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csmart-transactions-controller%5Cpackage.json
      return function (require, module, exports) {
module.exports={
  "name": "@metamask/smart-transactions-controller",
  "version": "19.2.1",
  "description": "Improves success rates for swaps by trialing transactions privately and finding minimum fees",
  "repository": {
    "type": "git",
    "url": "https://github.com/MetaMask/smart-transactions-controller.git"
  },
  "license": "SEE LICENSE IN LICENSE",
  "sideEffects": false,
  "exports": {
    ".": {
      "import": {
        "types": "./dist/index.d.mts",
        "default": "./dist/index.mjs"
      },
      "require": {
        "types": "./dist/index.d.cts",
        "default": "./dist/index.cjs"
      }
    },
    "./package.json": "./package.json"
  },
  "main": "./dist/index.cjs",
  "module": "./dist/index.mjs",
  "types": "./dist/index.d.cts",
  "files": [
    "dist"
  ],
  "scripts": {
    "build": "ts-bridge --project tsconfig.build.json --clean",
    "lint": "yarn lint:eslint && yarn lint:misc --check && yarn lint:changelog",
    "lint:changelog": "auto-changelog validate --prettier",
    "lint:eslint": "eslint . --cache --ext js,ts",
    "lint:fix": "yarn lint:eslint --fix && yarn lint:misc --write && yarn lint:changelog",
    "lint:misc": "prettier '**/*.json' '**/*.md' '**/*.yml' '!.yarnrc.yml' --ignore-path .gitignore --no-error-on-unmatched-pattern",
    "prepack": "./scripts/prepack.sh",
    "test": "jest && attw --pack",
    "test:watch": "jest --watchAll"
  },
  "dependencies": {
    "@babel/runtime": "^7.24.1",
    "@ethereumjs/tx": "^5.2.1",
    "@ethereumjs/util": "^9.0.2",
    "@ethersproject/bytes": "^5.7.0",
    "@ethersproject/keccak256": "^5.8.0",
    "@ethersproject/transactions": "^5.7.0",
    "@metamask/base-controller": "^8.3.0",
    "@metamask/controller-utils": "^11.0.0",
    "@metamask/eth-json-rpc-provider": "^4.1.6",
    "@metamask/eth-query": "^4.0.0",
    "@metamask/polling-controller": "^14.0.0",
    "bignumber.js": "^9.0.1",
    "fast-json-patch": "^3.1.0",
    "lodash": "^4.17.21"
  },
  "devDependencies": {
    "@arethetypeswrong/cli": "^0.18.2",
    "@lavamoat/allow-scripts": "^3.2.1",
    "@lavamoat/preinstall-always-fail": "^2.1.0",
    "@metamask/auto-changelog": "^3.1.0",
    "@metamask/eslint-config": "^12.2.0",
    "@metamask/eslint-config-jest": "^12.1.0",
    "@metamask/eslint-config-nodejs": "^12.1.0",
    "@metamask/eslint-config-typescript": "^12.1.0",
    "@metamask/gas-fee-controller": "^22.0.0",
    "@metamask/json-rpc-engine": "^10.0.1",
    "@metamask/network-controller": "^24.0.0",
    "@metamask/transaction-controller": "^60.4.0",
    "@ts-bridge/cli": "^0.6.3",
    "@types/jest": "^26.0.24",
    "@types/lodash": "^4.14.194",
    "@types/node": "^18.19.17",
    "@types/sinon": "^9.0.10",
    "@typescript-eslint/eslint-plugin": "^5.33.0",
    "@typescript-eslint/parser": "^5.33.0",
    "eslint": "^8.48.0",
    "eslint-config-prettier": "^8.8.0",
    "eslint-plugin-import": "~2.26.0",
    "eslint-plugin-jest": "^27.1.5",
    "eslint-plugin-jsdoc": "^39.2.9",
    "eslint-plugin-n": "^15.7.0",
    "eslint-plugin-prettier": "^4.2.1",
    "eslint-plugin-promise": "^6.1.1",
    "isomorphic-fetch": "^3.0.0",
    "jest": "^29.7.0",
    "nock": "^14.0.0-beta.7",
    "prettier": "^2.8.8",
    "prettier-plugin-packagejson": "^2.4.3",
    "sinon": "^9.2.4",
    "ts-jest": "^29.1.4",
    "typescript": "~4.8.4"
  },
  "peerDependencies": {
    "@metamask/network-controller": "^24.0.0",
    "@metamask/transaction-controller": "^60.4.0"
  },
  "peerDependenciesMeta": {
    "@metamask/accounts-controller": {
      "optional": true
    },
    "@metamask/approval-controller": {
      "optional": true
    },
    "@metamask/eth-block-tracker": {
      "optional": true
    },
    "@metamask/gas-fee-controller": {
      "optional": true
    },
    "@metamask/remote-feature-flag-controller": {
      "optional": true
    }
  },
  "packageManager": "yarn@3.2.1",
  "engines": {
    "node": "^18.18 || >=20"
  },
  "publishConfig": {
    "access": "public",
    "registry": "https://registry.npmjs.org/"
  },
  "lavamoat": {
    "allowScripts": {
      "@lavamoat/preinstall-always-fail": false,
      "@metamask/controller-utils>ethereumjs-util>ethereum-cryptography>keccak": false,
      "@metamask/controller-utils>ethereumjs-util>ethereum-cryptography>secp256k1": false,
      "@metamask/controller-utils>babel-runtime>core-js": false
    }
  }
}
      };
    };
  }
  }
}, {package:"@metamask/smart-transactions-controller",file:"node_modules\\@metamask\\smart-transactions-controller\\package.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\assets.cjs", {"./caveats/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\caveats\\index.cjs","./enum.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\enum.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cendowments%5Cassets.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAssetsCaveatMapper = exports.assetsEndowmentBuilder = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
const caveats_1 = require("./caveats/index.cjs");
const enum_1 = require("./enum.cjs");
const permissionName = enum_1.SnapEndowments.Assets;
/**
 * `endowment:assets` returns nothing; it is intended to be used as a flag to determine whether the Snap can run asset queries.
 *
 * @param _builderOptions - Optional specification builder options.
 * @returns The specification for the assets endowment.
 */
const specificationBuilder = _builderOptions => {
  return {
    permissionType: permission_controller_1.PermissionType.Endowment,
    targetName: permissionName,
    allowedCaveats: [snaps_utils_1.SnapCaveatType.ChainIds],
    endowmentGetter: _getterOptions => null,
    subjectTypes: [permission_controller_1.SubjectType.Snap],
    validator: (0, caveats_1.createGenericPermissionValidator)([{
      type: snaps_utils_1.SnapCaveatType.ChainIds
    }, {
      type: snaps_utils_1.SnapCaveatType.MaxRequestTime,
      optional: true
    }])
  };
};
exports.assetsEndowmentBuilder = Object.freeze({
  targetName: permissionName,
  specificationBuilder
});
/**
 * Map a raw value from the `initialPermissions` to a caveat specification.
 * Note that this function does not do any validation, that's handled by the
 * PermissionsController when the permission is requested.
 *
 * @param value - The raw value from the `initialPermissions`.
 * @returns The caveat specification.
 */
function getAssetsCaveatMapper(value) {
  (0, utils_1.assert)((0, utils_1.isObject)(value) && value.scopes);
  return {
    caveats: [{
      type: snaps_utils_1.SnapCaveatType.ChainIds,
      value: value.scopes
    }]
  };
}
exports.getAssetsCaveatMapper = getAssetsCaveatMapper;

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\assets.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\caveats\\generic.cjs", {"@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cendowments%5Ccaveats%5Cgeneric.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGenericPermissionValidator = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
/**
 * Create a generic permission validator that validates the presence of certain caveats.
 *
 * This validator only validates the types of the caveats, not the values.
 *
 * @param caveatsToValidate - A list of objects that represent caveats.
 * @param caveatsToValidate.type - The string defining the caveat type.
 * @param caveatsToValidate.optional - An optional boolean flag that defines
 * whether the caveat is optional or not.
 * @returns A function that validates a permission.
 */
function createGenericPermissionValidator(caveatsToValidate) {
  const validCaveatTypes = new Set(caveatsToValidate.map(caveat => caveat.type));
  const requiredCaveats = caveatsToValidate.filter(caveat => !caveat.optional);
  return function ({
    caveats
  }) {
    const actualCaveats = caveats ?? [];
    const passedCaveatTypes = actualCaveats.map(caveat => caveat.type);
    const passedCaveatsSet = new Set(passedCaveatTypes);
    // Disallow duplicates
    if (passedCaveatsSet.size !== passedCaveatTypes.length) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: 'Duplicate caveats are not allowed.'
      });
    }
    // Disallow caveats that don't match expected types
    if (!actualCaveats.every(caveat => validCaveatTypes.has(caveat.type))) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Expected the following caveats: ${caveatsToValidate.map(caveat => `"${caveat.type}"`).join(', ')}, received ${actualCaveats.map(caveat => `"${caveat.type}"`).join(', ')}.`
      });
    }
    // Fail if not all required caveats are specified
    if (!requiredCaveats.every(caveat => passedCaveatsSet.has(caveat.type))) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Expected the following caveats: ${requiredCaveats.map(caveat => `"${caveat.type}"`).join(', ')}.`
      });
    }
  };
}
exports.createGenericPermissionValidator = createGenericPermissionValidator;

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\caveats\\generic.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\caveats\\index.cjs", {"./generic.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\caveats\\generic.cjs","./requestTime.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\caveats\\requestTime.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cendowments%5Ccaveats%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
__exportStar(require("./generic.cjs"), exports);
__exportStar(require("./requestTime.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\caveats\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\caveats\\requestTime.cjs", {"@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cendowments%5Ccaveats%5CrequestTime.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.maxRequestTimeCaveatSpecifications = exports.getMaxRequestTimeCaveat = exports.createMaxRequestTimeMapper = exports.getMaxRequestTimeCaveatMapper = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
/**
 * Asserts that the given value is a valid `maxRequestTime` value.
 *
 * @param value - The value to assert.
 * @param ErrorWrapper - An optional error wrapper to use. Defaults to
 * {@link AssertionError}.
 * @throws If the value is not a valid `maxRequestTime` value.
 */
function assertIsMaxRequestTime(value, ErrorWrapper) {
  (0, utils_1.assertStruct)(value, snaps_utils_1.MaxRequestTimeStruct, 'Invalid maxRequestTime', ErrorWrapper);
}
/**
 * Validate the value of a caveat. This does not validate the type of the
 * caveat itself, only the value of the caveat.
 *
 * @param caveat - The caveat to validate.
 * @throws If the caveat value is invalid.
 */
function validateMaxRequestTimeCaveat(caveat) {
  if (!(0, utils_1.hasProperty)(caveat, 'value')) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Invalid maxRequestTime caveat.'
    });
  }
  const {
    value
  } = caveat;
  assertIsMaxRequestTime(value, rpc_errors_1.rpcErrors.invalidParams);
}
/**
 * Map a raw value from the `initialPermissions` to a caveat specification.
 * Note that this function does not do any validation, that's handled by the
 * PermissionsController when the permission is requested.
 *
 * @param value - The raw value from the `initialPermissions`.
 * @returns The caveat specification.
 */
function getMaxRequestTimeCaveatMapper(value) {
  if (!value || !(0, utils_1.isObject)(value) || (0, utils_1.isObject)(value) && !(0, utils_1.hasProperty)(value, 'maxRequestTime')) {
    return {
      caveats: null
    };
  }
  return {
    caveats: [{
      type: snaps_utils_1.SnapCaveatType.MaxRequestTime,
      value: value.maxRequestTime
    }]
  };
}
exports.getMaxRequestTimeCaveatMapper = getMaxRequestTimeCaveatMapper;
/**
 * Creates a wrapping caveat mapper that creates the `maxRequestTime` caveat
 * and merges it with any other caveats created by the mapper function.
 *
 * @param mapper - Another caveat mapper function.
 * @returns The caveat specification.
 */
function createMaxRequestTimeMapper(mapper) {
  return function (value) {
    // We assume this to be used only with caveats of this type
    const {
      maxRequestTime,
      ...rest
    } = value;
    const mapperResult = mapper(rest);
    if (!maxRequestTime) {
      return mapperResult;
    }
    return {
      ...mapperResult,
      caveats: [...(mapperResult.caveats ?? []), {
        type: snaps_utils_1.SnapCaveatType.MaxRequestTime,
        value: maxRequestTime
      }]
    };
  };
}
exports.createMaxRequestTimeMapper = createMaxRequestTimeMapper;
/**
 * Getter function to get the {@link MaxRequestTime} caveat value from a permission if specified.
 *
 * @param permission - The permission to get the caveat value from.
 * @returns The caveat value if present, otherwise null.
 */
function getMaxRequestTimeCaveat(permission) {
  var _permission$caveats;
  const foundCaveat = permission === null || permission === void 0 || (_permission$caveats = permission.caveats) === null || _permission$caveats === void 0 ? void 0 : _permission$caveats.find(caveat => caveat.type === snaps_utils_1.SnapCaveatType.MaxRequestTime);
  return (foundCaveat === null || foundCaveat === void 0 ? void 0 : foundCaveat.value) ?? null;
}
exports.getMaxRequestTimeCaveat = getMaxRequestTimeCaveat;
exports.maxRequestTimeCaveatSpecifications = {
  [snaps_utils_1.SnapCaveatType.MaxRequestTime]: Object.freeze({
    type: snaps_utils_1.SnapCaveatType.MaxRequestTime,
    validator: caveat => validateMaxRequestTimeCaveat(caveat)
  })
};

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\caveats\\requestTime.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\cronjob.cjs", {"./caveats/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\caveats\\index.cjs","./enum.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\enum.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cendowments%5Ccronjob.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cronjobCaveatSpecifications = exports.validateCronjobCaveat = exports.getCronjobCaveatJobs = exports.getCronjobCaveatMapper = exports.cronjobEndowmentBuilder = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
const caveats_1 = require("./caveats/index.cjs");
const enum_1 = require("./enum.cjs");
const permissionName = enum_1.SnapEndowments.Cronjob;
/**
 * `endowment:cronjob` returns nothing; it is intended to be used as a flag to determine whether the snap wants to run cronjobs.
 *
 * @param _builderOptions - Optional specification builder options.
 * @returns The specification for the cronjob endowment.
 */
const specificationBuilder = _builderOptions => {
  return {
    permissionType: permission_controller_1.PermissionType.Endowment,
    targetName: permissionName,
    allowedCaveats: [snaps_utils_1.SnapCaveatType.SnapCronjob],
    endowmentGetter: _getterOptions => null,
    subjectTypes: [permission_controller_1.SubjectType.Snap],
    validator: (0, caveats_1.createGenericPermissionValidator)([{
      type: snaps_utils_1.SnapCaveatType.SnapCronjob,
      optional: true
    }, {
      type: snaps_utils_1.SnapCaveatType.MaxRequestTime,
      optional: true
    }])
  };
};
exports.cronjobEndowmentBuilder = Object.freeze({
  targetName: permissionName,
  specificationBuilder
});
/**
 * Map a raw value from the `initialPermissions` to a caveat specification.
 * Note that this function does not do any validation, that's handled by the
 * PermissionsController when the permission is requested.
 *
 * @param value - The raw value from the `initialPermissions`.
 * @returns The caveat specification.
 */
function getCronjobCaveatMapper(value) {
  if (!value || !(0, utils_1.isObject)(value) || Object.keys(value).length === 0) {
    return {
      caveats: null
    };
  }
  return {
    caveats: [{
      type: snaps_utils_1.SnapCaveatType.SnapCronjob,
      value
    }]
  };
}
exports.getCronjobCaveatMapper = getCronjobCaveatMapper;
/**
 * Getter function to get the cronjobs from a permission.
 *
 * This does basic validation of the caveat, but does not validate the type or
 * value of the namespaces object itself, as this is handled by the
 * `PermissionsController` when the permission is requested.
 *
 * @param permission - The permission to get the keyring namespaces from.
 * @returns The cronjobs, or `null` if the permission does not have a
 * cronjob caveat.
 */
function getCronjobCaveatJobs(permission) {
  var _caveat$value;
  if (!(permission !== null && permission !== void 0 && permission.caveats)) {
    return null;
  }
  (0, utils_1.assert)(permission.caveats.length === 1);
  (0, utils_1.assert)(permission.caveats[0].type === snaps_utils_1.SnapCaveatType.SnapCronjob);
  const caveat = permission.caveats[0];
  return ((_caveat$value = caveat.value) === null || _caveat$value === void 0 ? void 0 : _caveat$value.jobs) ?? null;
}
exports.getCronjobCaveatJobs = getCronjobCaveatJobs;
/**
 * Validate the cronjob specification values associated with a caveat.
 * This validates that the value is a non-empty array with valid
 * cronjob expression and request object.
 *
 * @param caveat - The caveat to validate.
 * @throws If the value is invalid.
 */
function validateCronjobCaveat(caveat) {
  if (!(0, utils_1.hasProperty)(caveat, 'value') || !(0, utils_1.isPlainObject)(caveat.value)) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Expected a plain object.'
    });
  }
  const {
    value
  } = caveat;
  if (!(0, utils_1.hasProperty)(value, 'jobs') || !(0, utils_1.isPlainObject)(value)) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Expected a plain object.'
    });
  }
  if (!(0, snaps_utils_1.isCronjobSpecificationArray)(value.jobs)) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Expected a valid cronjob specification array.'
    });
  }
}
exports.validateCronjobCaveat = validateCronjobCaveat;
/**
 * Caveat specification for the Cronjob.
 */
exports.cronjobCaveatSpecifications = {
  [snaps_utils_1.SnapCaveatType.SnapCronjob]: Object.freeze({
    type: snaps_utils_1.SnapCaveatType.SnapCronjob,
    validator: caveat => validateCronjobCaveat(caveat)
  })
};

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\cronjob.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\enum.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cendowments%5Cenum.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapEndowments = void 0;
var SnapEndowments;
(function (SnapEndowments) {
  SnapEndowments["NetworkAccess"] = "endowment:network-access";
  SnapEndowments["SignatureInsight"] = "endowment:signature-insight";
  SnapEndowments["TransactionInsight"] = "endowment:transaction-insight";
  SnapEndowments["Cronjob"] = "endowment:cronjob";
  SnapEndowments["EthereumProvider"] = "endowment:ethereum-provider";
  SnapEndowments["Rpc"] = "endowment:rpc";
  SnapEndowments["WebAssemblyAccess"] = "endowment:webassembly";
  SnapEndowments["NameLookup"] = "endowment:name-lookup";
  SnapEndowments["LifecycleHooks"] = "endowment:lifecycle-hooks";
  SnapEndowments["Keyring"] = "endowment:keyring";
  SnapEndowments["HomePage"] = "endowment:page-home";
  SnapEndowments["SettingsPage"] = "endowment:page-settings";
  SnapEndowments["Assets"] = "endowment:assets";
  SnapEndowments["Protocol"] = "endowment:protocol";
})(SnapEndowments || (exports.SnapEndowments = SnapEndowments = {}));

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\enum.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\ethereum-provider.cjs", {"./enum.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\enum.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cendowments%5Cethereum-provider.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ethereumProviderEndowmentBuilder = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const enum_1 = require("./enum.cjs");
const permissionName = enum_1.SnapEndowments.EthereumProvider;
/**
 * `endowment:ethereum-provider` returns the name of the ethereum global browser API.
 * This is intended to populate the endowments of the
 * SES Compartment in which a Snap executes.
 *
 * This populates the global scope with an EIP-1193 provider, which DOES NOT implement all legacy functionality exposed to dapps.
 *
 * @param _builderOptions - Optional specification builder options.
 * @returns The specification for the network endowment.
 */
const specificationBuilder = _builderOptions => {
  return {
    permissionType: permission_controller_1.PermissionType.Endowment,
    targetName: permissionName,
    allowedCaveats: null,
    endowmentGetter: _getterOptions => {
      return ['ethereum'];
    },
    subjectTypes: [permission_controller_1.SubjectType.Snap]
  };
};
exports.ethereumProviderEndowmentBuilder = Object.freeze({
  targetName: permissionName,
  specificationBuilder
});

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\ethereum-provider.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\home-page.cjs", {"./enum.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\enum.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cendowments%5Chome-page.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.homePageEndowmentBuilder = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const enum_1 = require("./enum.cjs");
const permissionName = enum_1.SnapEndowments.HomePage;
/**
 * `endowment:page-home` returns nothing; it is intended to be used as a
 * flag by the snap controller to detect whether the snap has the capability to
 * use the snap home page feature.
 *
 * @param _builderOptions - Optional specification builder options.
 * @returns The specification for the `snap-pages` endowment.
 */
const specificationBuilder = _builderOptions => {
  return {
    permissionType: permission_controller_1.PermissionType.Endowment,
    targetName: permissionName,
    allowedCaveats: null,
    endowmentGetter: _getterOptions => null,
    subjectTypes: [permission_controller_1.SubjectType.Snap]
  };
};
exports.homePageEndowmentBuilder = Object.freeze({
  targetName: permissionName,
  specificationBuilder
});

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\home-page.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\index.cjs", {"./assets.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\assets.cjs","./caveats/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\caveats\\index.cjs","./cronjob.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\cronjob.cjs","./enum.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\enum.cjs","./ethereum-provider.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\ethereum-provider.cjs","./home-page.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\home-page.cjs","./keyring.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\keyring.cjs","./lifecycle-hooks.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\lifecycle-hooks.cjs","./name-lookup.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\name-lookup.cjs","./network-access.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\network-access.cjs","./protocol.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\protocol.cjs","./rpc.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\rpc.cjs","./settings-page.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\settings-page.cjs","./signature-insight.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\signature-insight.cjs","./transaction-insight.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\transaction-insight.cjs","./web-assembly.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\web-assembly.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cendowments%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProtocolCaveatScopes = exports.getCronjobCaveatJobs = exports.getMaxRequestTimeCaveat = exports.getKeyringCaveatOrigins = exports.getLookupMatchersCaveat = exports.getChainIdsCaveat = exports.getTransactionOriginCaveat = exports.getSignatureOriginCaveat = exports.getRpcCaveatOrigins = exports.handlerEndowments = exports.endowmentCaveatMappers = exports.endowmentCaveatSpecifications = exports.endowmentPermissionBuilders = void 0;
const snaps_utils_1 = require("@metamask/snaps-utils");
const assets_1 = require("./assets.cjs");
const caveats_1 = require("./caveats/index.cjs");
const cronjob_1 = require("./cronjob.cjs");
const ethereum_provider_1 = require("./ethereum-provider.cjs");
const home_page_1 = require("./home-page.cjs");
const keyring_1 = require("./keyring.cjs");
const lifecycle_hooks_1 = require("./lifecycle-hooks.cjs");
const name_lookup_1 = require("./name-lookup.cjs");
const network_access_1 = require("./network-access.cjs");
const protocol_1 = require("./protocol.cjs");
const rpc_1 = require("./rpc.cjs");
const settings_page_1 = require("./settings-page.cjs");
const signature_insight_1 = require("./signature-insight.cjs");
const transaction_insight_1 = require("./transaction-insight.cjs");
const web_assembly_1 = require("./web-assembly.cjs");
exports.endowmentPermissionBuilders = {
  [network_access_1.networkAccessEndowmentBuilder.targetName]: network_access_1.networkAccessEndowmentBuilder,
  [transaction_insight_1.transactionInsightEndowmentBuilder.targetName]: transaction_insight_1.transactionInsightEndowmentBuilder,
  [cronjob_1.cronjobEndowmentBuilder.targetName]: cronjob_1.cronjobEndowmentBuilder,
  [ethereum_provider_1.ethereumProviderEndowmentBuilder.targetName]: ethereum_provider_1.ethereumProviderEndowmentBuilder,
  [rpc_1.rpcEndowmentBuilder.targetName]: rpc_1.rpcEndowmentBuilder,
  [web_assembly_1.webAssemblyEndowmentBuilder.targetName]: web_assembly_1.webAssemblyEndowmentBuilder,
  [name_lookup_1.nameLookupEndowmentBuilder.targetName]: name_lookup_1.nameLookupEndowmentBuilder,
  [lifecycle_hooks_1.lifecycleHooksEndowmentBuilder.targetName]: lifecycle_hooks_1.lifecycleHooksEndowmentBuilder,
  [keyring_1.keyringEndowmentBuilder.targetName]: keyring_1.keyringEndowmentBuilder,
  [settings_page_1.settingsPageEndowmentBuilder.targetName]: settings_page_1.settingsPageEndowmentBuilder,
  [protocol_1.protocolEndowmentBuilder.targetName]: protocol_1.protocolEndowmentBuilder,
  [home_page_1.homePageEndowmentBuilder.targetName]: home_page_1.homePageEndowmentBuilder,
  [signature_insight_1.signatureInsightEndowmentBuilder.targetName]: signature_insight_1.signatureInsightEndowmentBuilder,
  [assets_1.assetsEndowmentBuilder.targetName]: assets_1.assetsEndowmentBuilder
};
exports.endowmentCaveatSpecifications = {
  ...cronjob_1.cronjobCaveatSpecifications,
  ...transaction_insight_1.transactionInsightCaveatSpecifications,
  ...rpc_1.rpcCaveatSpecifications,
  ...name_lookup_1.nameLookupCaveatSpecifications,
  ...keyring_1.keyringCaveatSpecifications,
  ...signature_insight_1.signatureInsightCaveatSpecifications,
  ...caveats_1.maxRequestTimeCaveatSpecifications,
  ...protocol_1.protocolCaveatSpecifications
};
exports.endowmentCaveatMappers = {
  [cronjob_1.cronjobEndowmentBuilder.targetName]: (0, caveats_1.createMaxRequestTimeMapper)(cronjob_1.getCronjobCaveatMapper),
  [transaction_insight_1.transactionInsightEndowmentBuilder.targetName]: (0, caveats_1.createMaxRequestTimeMapper)(transaction_insight_1.getTransactionInsightCaveatMapper),
  [rpc_1.rpcEndowmentBuilder.targetName]: (0, caveats_1.createMaxRequestTimeMapper)(rpc_1.getRpcCaveatMapper),
  [name_lookup_1.nameLookupEndowmentBuilder.targetName]: (0, caveats_1.createMaxRequestTimeMapper)(name_lookup_1.getNameLookupCaveatMapper),
  [keyring_1.keyringEndowmentBuilder.targetName]: (0, caveats_1.createMaxRequestTimeMapper)(keyring_1.getKeyringCaveatMapper),
  [protocol_1.protocolEndowmentBuilder.targetName]: (0, caveats_1.createMaxRequestTimeMapper)(protocol_1.getProtocolCaveatMapper),
  [signature_insight_1.signatureInsightEndowmentBuilder.targetName]: (0, caveats_1.createMaxRequestTimeMapper)(signature_insight_1.getSignatureInsightCaveatMapper),
  [lifecycle_hooks_1.lifecycleHooksEndowmentBuilder.targetName]: caveats_1.getMaxRequestTimeCaveatMapper,
  [home_page_1.homePageEndowmentBuilder.targetName]: caveats_1.getMaxRequestTimeCaveatMapper,
  [settings_page_1.settingsPageEndowmentBuilder.targetName]: caveats_1.getMaxRequestTimeCaveatMapper,
  [assets_1.assetsEndowmentBuilder.targetName]: (0, caveats_1.createMaxRequestTimeMapper)(assets_1.getAssetsCaveatMapper)
};
// We allow null because a permitted handler does not have an endowment
exports.handlerEndowments = {
  [snaps_utils_1.HandlerType.OnRpcRequest]: rpc_1.rpcEndowmentBuilder.targetName,
  [snaps_utils_1.HandlerType.OnTransaction]: transaction_insight_1.transactionInsightEndowmentBuilder.targetName,
  [snaps_utils_1.HandlerType.OnCronjob]: cronjob_1.cronjobEndowmentBuilder.targetName,
  [snaps_utils_1.HandlerType.OnNameLookup]: name_lookup_1.nameLookupEndowmentBuilder.targetName,
  [snaps_utils_1.HandlerType.OnInstall]: lifecycle_hooks_1.lifecycleHooksEndowmentBuilder.targetName,
  [snaps_utils_1.HandlerType.OnUpdate]: lifecycle_hooks_1.lifecycleHooksEndowmentBuilder.targetName,
  [snaps_utils_1.HandlerType.OnStart]: lifecycle_hooks_1.lifecycleHooksEndowmentBuilder.targetName,
  [snaps_utils_1.HandlerType.OnActive]: lifecycle_hooks_1.lifecycleHooksEndowmentBuilder.targetName,
  [snaps_utils_1.HandlerType.OnInactive]: lifecycle_hooks_1.lifecycleHooksEndowmentBuilder.targetName,
  [snaps_utils_1.HandlerType.OnKeyringRequest]: keyring_1.keyringEndowmentBuilder.targetName,
  [snaps_utils_1.HandlerType.OnHomePage]: home_page_1.homePageEndowmentBuilder.targetName,
  [snaps_utils_1.HandlerType.OnSettingsPage]: settings_page_1.settingsPageEndowmentBuilder.targetName,
  [snaps_utils_1.HandlerType.OnSignature]: signature_insight_1.signatureInsightEndowmentBuilder.targetName,
  [snaps_utils_1.HandlerType.OnUserInput]: null,
  [snaps_utils_1.HandlerType.OnAssetHistoricalPrice]: assets_1.assetsEndowmentBuilder.targetName,
  [snaps_utils_1.HandlerType.OnAssetsLookup]: assets_1.assetsEndowmentBuilder.targetName,
  [snaps_utils_1.HandlerType.OnAssetsConversion]: assets_1.assetsEndowmentBuilder.targetName,
  [snaps_utils_1.HandlerType.OnAssetsMarketData]: assets_1.assetsEndowmentBuilder.targetName,
  [snaps_utils_1.HandlerType.OnProtocolRequest]: protocol_1.protocolEndowmentBuilder.targetName,
  [snaps_utils_1.HandlerType.OnClientRequest]: null,
  [snaps_utils_1.HandlerType.OnWebSocketEvent]: network_access_1.networkAccessEndowmentBuilder.targetName
};
__exportStar(require("./enum.cjs"), exports);
var rpc_2 = require("./rpc.cjs");
Object.defineProperty(exports, "getRpcCaveatOrigins", {
  enumerable: true,
  get: function () {
    return rpc_2.getRpcCaveatOrigins;
  }
});
var signature_insight_2 = require("./signature-insight.cjs");
Object.defineProperty(exports, "getSignatureOriginCaveat", {
  enumerable: true,
  get: function () {
    return signature_insight_2.getSignatureOriginCaveat;
  }
});
var transaction_insight_2 = require("./transaction-insight.cjs");
Object.defineProperty(exports, "getTransactionOriginCaveat", {
  enumerable: true,
  get: function () {
    return transaction_insight_2.getTransactionOriginCaveat;
  }
});
var name_lookup_2 = require("./name-lookup.cjs");
Object.defineProperty(exports, "getChainIdsCaveat", {
  enumerable: true,
  get: function () {
    return name_lookup_2.getChainIdsCaveat;
  }
});
Object.defineProperty(exports, "getLookupMatchersCaveat", {
  enumerable: true,
  get: function () {
    return name_lookup_2.getLookupMatchersCaveat;
  }
});
var keyring_2 = require("./keyring.cjs");
Object.defineProperty(exports, "getKeyringCaveatOrigins", {
  enumerable: true,
  get: function () {
    return keyring_2.getKeyringCaveatOrigins;
  }
});
var caveats_2 = require("./caveats/index.cjs");
Object.defineProperty(exports, "getMaxRequestTimeCaveat", {
  enumerable: true,
  get: function () {
    return caveats_2.getMaxRequestTimeCaveat;
  }
});
var cronjob_2 = require("./cronjob.cjs");
Object.defineProperty(exports, "getCronjobCaveatJobs", {
  enumerable: true,
  get: function () {
    return cronjob_2.getCronjobCaveatJobs;
  }
});
var protocol_2 = require("./protocol.cjs");
Object.defineProperty(exports, "getProtocolCaveatScopes", {
  enumerable: true,
  get: function () {
    return protocol_2.getProtocolCaveatScopes;
  }
});

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\keyring.cjs", {"./caveats/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\caveats\\index.cjs","./enum.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\enum.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cendowments%5Ckeyring.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.keyringCaveatSpecifications = exports.getKeyringCaveatOrigins = exports.getKeyringCaveatMapper = exports.keyringEndowmentBuilder = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
const caveats_1 = require("./caveats/index.cjs");
const enum_1 = require("./enum.cjs");
const permissionName = enum_1.SnapEndowments.Keyring;
/**
 * `endowment:keyring` returns nothing; it is intended to be used as a flag
 * by the client to detect whether the snap has keyring capabilities.
 *
 * @param _builderOptions - Optional specification builder options.
 * @returns The specification for the keyring endowment.
 */
const specificationBuilder = _builderOptions => {
  return {
    permissionType: permission_controller_1.PermissionType.Endowment,
    targetName: permissionName,
    allowedCaveats: [snaps_utils_1.SnapCaveatType.KeyringOrigin, snaps_utils_1.SnapCaveatType.MaxRequestTime],
    endowmentGetter: _getterOptions => null,
    validator: (0, caveats_1.createGenericPermissionValidator)([{
      type: snaps_utils_1.SnapCaveatType.KeyringOrigin
    }, {
      type: snaps_utils_1.SnapCaveatType.MaxRequestTime,
      optional: true
    }]),
    subjectTypes: [permission_controller_1.SubjectType.Snap]
  };
};
exports.keyringEndowmentBuilder = Object.freeze({
  targetName: permissionName,
  specificationBuilder
});
/**
 * Validate the value of a caveat. This does not validate the type of the
 * caveat itself, only the value of the caveat.
 *
 * @param caveat - The caveat to validate.
 * @throws If the caveat value is invalid.
 */
function validateCaveatOrigins(caveat) {
  if (!(0, utils_1.hasProperty)(caveat, 'value') || !(0, utils_1.isPlainObject)(caveat.value)) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Invalid keyring origins: Expected a plain object.'
    });
  }
  const {
    value
  } = caveat;
  (0, snaps_utils_1.assertIsKeyringOrigins)(value, rpc_errors_1.rpcErrors.invalidParams);
}
/**
 * Map a raw value from the `initialPermissions` to a caveat specification.
 * Note that this function does not do any validation, that's handled by the
 * PermissionsController when the permission is requested.
 *
 * @param value - The raw value from the `initialPermissions`.
 * @returns The caveat specification.
 */
function getKeyringCaveatMapper(value) {
  return {
    caveats: [{
      type: snaps_utils_1.SnapCaveatType.KeyringOrigin,
      value
    }]
  };
}
exports.getKeyringCaveatMapper = getKeyringCaveatMapper;
/**
 * Getter function to get the {@link KeyringOrigins} caveat value from a
 * permission.
 *
 * @param permission - The permission to get the caveat value from.
 * @returns The caveat value.
 * @throws If the permission does not have a valid {@link KeyringOrigins}
 * caveat.
 */
function getKeyringCaveatOrigins(permission) {
  (0, utils_1.assert)(permission === null || permission === void 0 ? void 0 : permission.caveats);
  (0, utils_1.assert)(permission.caveats.length === 1);
  (0, utils_1.assert)(permission.caveats[0].type === snaps_utils_1.SnapCaveatType.KeyringOrigin);
  const caveat = permission.caveats[0];
  return caveat.value;
}
exports.getKeyringCaveatOrigins = getKeyringCaveatOrigins;
exports.keyringCaveatSpecifications = {
  [snaps_utils_1.SnapCaveatType.KeyringOrigin]: Object.freeze({
    type: snaps_utils_1.SnapCaveatType.KeyringOrigin,
    validator: caveat => validateCaveatOrigins(caveat)
  })
};

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\keyring.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\lifecycle-hooks.cjs", {"./enum.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\enum.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cendowments%5Clifecycle-hooks.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lifecycleHooksEndowmentBuilder = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const enum_1 = require("./enum.cjs");
const permissionName = enum_1.SnapEndowments.LifecycleHooks;
/**
 * `endowment:lifecycle-hooks` returns nothing; it is intended to be used as a
 * flag by the snap controller to detect whether the snap has the capability to
 * use lifecycle hooks.
 *
 * @param _builderOptions - Optional specification builder options.
 * @returns The specification for the `lifecycle-hooks` endowment.
 */
const specificationBuilder = _builderOptions => {
  return {
    permissionType: permission_controller_1.PermissionType.Endowment,
    targetName: permissionName,
    allowedCaveats: null,
    endowmentGetter: _getterOptions => null,
    subjectTypes: [permission_controller_1.SubjectType.Snap]
  };
};
exports.lifecycleHooksEndowmentBuilder = Object.freeze({
  targetName: permissionName,
  specificationBuilder
});

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\lifecycle-hooks.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\name-lookup.cjs", {"./caveats/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\caveats\\index.cjs","./enum.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\enum.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cendowments%5Cname-lookup.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nameLookupCaveatSpecifications = exports.getLookupMatchersCaveat = exports.getChainIdsCaveat = exports.getNameLookupCaveatMapper = exports.nameLookupEndowmentBuilder = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
const caveats_1 = require("./caveats/index.cjs");
const enum_1 = require("./enum.cjs");
const permissionName = enum_1.SnapEndowments.NameLookup;
/**
 * `endowment:name-lookup` returns nothing; it is intended to be used as a flag
 * by the extension to detect whether the snap has the capability to resolve a domain/address.
 *
 * @param _builderOptions - Optional specification builder options.
 * @returns The specification for the name-lookup endowment.
 */
const specificationBuilder = _builderOptions => {
  return {
    permissionType: permission_controller_1.PermissionType.Endowment,
    targetName: permissionName,
    allowedCaveats: [snaps_utils_1.SnapCaveatType.ChainIds, snaps_utils_1.SnapCaveatType.LookupMatchers, snaps_utils_1.SnapCaveatType.MaxRequestTime],
    endowmentGetter: _getterOptions => null,
    validator: (0, caveats_1.createGenericPermissionValidator)([{
      type: snaps_utils_1.SnapCaveatType.ChainIds,
      optional: true
    }, {
      type: snaps_utils_1.SnapCaveatType.LookupMatchers,
      optional: true
    }, {
      type: snaps_utils_1.SnapCaveatType.MaxRequestTime,
      optional: true
    }]),
    subjectTypes: [permission_controller_1.SubjectType.Snap]
  };
};
exports.nameLookupEndowmentBuilder = Object.freeze({
  targetName: permissionName,
  specificationBuilder
});
/**
 * Validates the type of the caveat value.
 *
 * @param caveat - The caveat to validate.
 * @throws If the caveat value is invalid.
 */
function validateCaveat(caveat) {
  if (!(0, utils_1.hasProperty)(caveat, 'value') || !(0, utils_1.isPlainObject)(caveat)) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Expected a plain object.'
    });
  }
  const {
    value
  } = caveat;
  switch (caveat.type) {
    case snaps_utils_1.SnapCaveatType.ChainIds:
      (0, utils_1.assertStruct)(value, snaps_utils_1.ChainIdsStruct);
      break;
    case snaps_utils_1.SnapCaveatType.LookupMatchers:
      (0, utils_1.assertStruct)(value, snaps_utils_1.LookupMatchersStruct);
      break;
    default:
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: 'Invalid caveat type, must be one of the following: "chainIds", "matchers".'
      });
  }
}
/**
 * Map a raw value from the `initialPermissions` to a caveat specification.
 * Note that this function does not do any validation, that's handled by the
 * PermissionsController when the permission is requested.
 *
 * @param value - The raw value from the `initialPermissions`.
 * @returns The caveat specification.
 */
function getNameLookupCaveatMapper(value) {
  if (!value || !(0, utils_1.isObject)(value) || Object.keys(value).length === 0) {
    return {
      caveats: null
    };
  }
  const caveats = [];
  if (value.chains) {
    caveats.push({
      type: snaps_utils_1.SnapCaveatType.ChainIds,
      value: value.chains
    });
  }
  if (value.matchers) {
    caveats.push({
      type: snaps_utils_1.SnapCaveatType.LookupMatchers,
      value: value.matchers
    });
  }
  (0, utils_1.assert)(caveats.length > 0);
  return {
    caveats: caveats
  };
}
exports.getNameLookupCaveatMapper = getNameLookupCaveatMapper;
/**
 * Getter function to get the chainIds caveat from a permission.
 *
 * This does basic validation of the caveat, but does not validate the type or
 * value of the namespaces object itself, as this is handled by the
 * `PermissionsController` when the permission is requested.
 *
 * @param permission - The permission to get the `chainIds` caveat from.
 * @returns An array of `chainIds` that the snap supports.
 */
function getChainIdsCaveat(permission) {
  if (!(permission !== null && permission !== void 0 && permission.caveats)) {
    return null;
  }
  const caveat = permission.caveats.find(permCaveat => permCaveat.type === snaps_utils_1.SnapCaveatType.ChainIds);
  return caveat ? caveat.value : null;
}
exports.getChainIdsCaveat = getChainIdsCaveat;
/**
 * Getter function to get the matchers caveat from a permission.
 *
 * This does basic validation of the caveat, but does not validate the type or
 * value of the namespaces object itself, as this is handled by the
 * `PermissionsController` when the permission is requested.
 *
 * @param permission - The permission to get the `matchers` caveat from.
 * @returns A `matchers` object that defines the input that the snap supports.
 */
function getLookupMatchersCaveat(permission) {
  if (!(permission !== null && permission !== void 0 && permission.caveats)) {
    return null;
  }
  const caveat = permission.caveats.find(permCaveat => permCaveat.type === snaps_utils_1.SnapCaveatType.LookupMatchers);
  return caveat ? caveat.value : null;
}
exports.getLookupMatchersCaveat = getLookupMatchersCaveat;
exports.nameLookupCaveatSpecifications = {
  [snaps_utils_1.SnapCaveatType.ChainIds]: Object.freeze({
    type: snaps_utils_1.SnapCaveatType.ChainIds,
    validator: caveat => validateCaveat(caveat)
  }),
  [snaps_utils_1.SnapCaveatType.LookupMatchers]: Object.freeze({
    type: snaps_utils_1.SnapCaveatType.LookupMatchers,
    validator: caveat => validateCaveat(caveat)
  })
};

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\name-lookup.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\network-access.cjs", {"./enum.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\enum.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cendowments%5Cnetwork-access.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.networkAccessEndowmentBuilder = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const enum_1 = require("./enum.cjs");
const permissionName = enum_1.SnapEndowments.NetworkAccess;
/**
 * `endowment:network-access` returns the name of global browser API(s) that
 * enable network access. This is intended to populate the endowments of the
 * SES Compartment in which a Snap executes.
 *
 * @param _builderOptions - Optional specification builder options.
 * @returns The specification for the network endowment.
 */
const specificationBuilder = _builderOptions => {
  return {
    permissionType: permission_controller_1.PermissionType.Endowment,
    targetName: permissionName,
    allowedCaveats: null,
    endowmentGetter: _getterOptions => {
      return ['fetch', 'Request', 'Headers', 'Response'];
    },
    subjectTypes: [permission_controller_1.SubjectType.Snap]
  };
};
exports.networkAccessEndowmentBuilder = Object.freeze({
  targetName: permissionName,
  specificationBuilder
});

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\network-access.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\protocol.cjs", {"./caveats/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\caveats\\index.cjs","./enum.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\enum.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cendowments%5Cprotocol.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.protocolCaveatSpecifications = exports.getProtocolCaveatScopes = exports.getProtocolCaveatMapper = exports.protocolEndowmentBuilder = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
const caveats_1 = require("./caveats/index.cjs");
const enum_1 = require("./enum.cjs");
const permissionName = enum_1.SnapEndowments.Protocol;
/**
 * `endowment:protocol` returns nothing; it is intended to be used as a flag
 * by the client to detect whether the Snap supports the Protocol API.
 *
 * @param _builderOptions - Optional specification builder options.
 * @returns The specification for the accounts chain endowment.
 */
const specificationBuilder = _builderOptions => {
  return {
    permissionType: permission_controller_1.PermissionType.Endowment,
    targetName: permissionName,
    allowedCaveats: [snaps_utils_1.SnapCaveatType.ProtocolSnapScopes, snaps_utils_1.SnapCaveatType.MaxRequestTime],
    endowmentGetter: _getterOptions => null,
    validator: (0, caveats_1.createGenericPermissionValidator)([{
      type: snaps_utils_1.SnapCaveatType.ProtocolSnapScopes
    }, {
      type: snaps_utils_1.SnapCaveatType.MaxRequestTime,
      optional: true
    }]),
    subjectTypes: [permission_controller_1.SubjectType.Snap]
  };
};
exports.protocolEndowmentBuilder = Object.freeze({
  targetName: permissionName,
  specificationBuilder
});
/**
 * Map a raw value from the `initialPermissions` to a caveat specification.
 * Note that this function does not do any validation, that's handled by the
 * PermissionsController when the permission is requested.
 *
 * @param value - The raw value from the `initialPermissions`.
 * @returns The caveat specification.
 */
function getProtocolCaveatMapper(value) {
  if (!value || !(0, utils_1.isObject)(value) || Object.keys(value).length === 0) {
    return {
      caveats: null
    };
  }
  const caveats = [];
  if (value.scopes) {
    caveats.push({
      type: snaps_utils_1.SnapCaveatType.ProtocolSnapScopes,
      value: value.scopes
    });
  }
  return {
    caveats: caveats
  };
}
exports.getProtocolCaveatMapper = getProtocolCaveatMapper;
/**
 * Getter function to get the {@link ProtocolSnapScopes} caveat value from a
 * permission.
 *
 * @param permission - The permission to get the caveat value from.
 * @returns The caveat value.
 */
function getProtocolCaveatScopes(permission) {
  var _permission$caveats;
  const caveat = permission === null || permission === void 0 || (_permission$caveats = permission.caveats) === null || _permission$caveats === void 0 ? void 0 : _permission$caveats.find(permCaveat => permCaveat.type === snaps_utils_1.SnapCaveatType.ProtocolSnapScopes);
  return caveat ? caveat.value : null;
}
exports.getProtocolCaveatScopes = getProtocolCaveatScopes;
/**
 * Validates the type of the caveat value.
 *
 * @param caveat - The caveat to validate.
 * @throws If the caveat value is invalid.
 */
function validateCaveat(caveat) {
  if (!(0, utils_1.hasProperty)(caveat, 'value') || !(0, utils_1.isPlainObject)(caveat)) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Expected a plain object.'
    });
  }
  const {
    value
  } = caveat;
  (0, utils_1.assertStruct)(value, snaps_utils_1.ProtocolScopesStruct, 'Invalid scopes specified', rpc_errors_1.rpcErrors.invalidParams);
}
exports.protocolCaveatSpecifications = {
  [snaps_utils_1.SnapCaveatType.ProtocolSnapScopes]: Object.freeze({
    type: snaps_utils_1.SnapCaveatType.ProtocolSnapScopes,
    validator: caveat => validateCaveat(caveat)
  })
};

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\protocol.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\rpc.cjs", {"./caveats/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\caveats\\index.cjs","./enum.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\enum.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cendowments%5Crpc.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rpcCaveatSpecifications = exports.getRpcCaveatOrigins = exports.getRpcCaveatMapper = exports.rpcEndowmentBuilder = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
const caveats_1 = require("./caveats/index.cjs");
const enum_1 = require("./enum.cjs");
const targetName = enum_1.SnapEndowments.Rpc;
/**
 * The specification builder for the JSON-RPC endowment permission.
 *
 * @param _builderOptions - Optional specification builder options.
 * @returns The specification for the JSON-RPC endowment permission.
 */
const specificationBuilder = _builderOptions => {
  return {
    permissionType: permission_controller_1.PermissionType.Endowment,
    targetName,
    allowedCaveats: [snaps_utils_1.SnapCaveatType.RpcOrigin, snaps_utils_1.SnapCaveatType.MaxRequestTime],
    endowmentGetter: _getterOptions => null,
    validator: (0, caveats_1.createGenericPermissionValidator)([{
      type: snaps_utils_1.SnapCaveatType.RpcOrigin
    }, {
      type: snaps_utils_1.SnapCaveatType.MaxRequestTime,
      optional: true
    }]),
    subjectTypes: [permission_controller_1.SubjectType.Snap]
  };
};
exports.rpcEndowmentBuilder = Object.freeze({
  targetName,
  specificationBuilder
});
/**
 * Validate the value of a caveat. This does not validate the type of the
 * caveat itself, only the value of the caveat.
 *
 * @param caveat - The caveat to validate.
 * @throws If the caveat value is invalid.
 */
function validateCaveatOrigins(caveat) {
  if (!(0, utils_1.hasProperty)(caveat, 'value') || !(0, utils_1.isPlainObject)(caveat.value)) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Invalid JSON-RPC origins: Expected a plain object.'
    });
  }
  const {
    value
  } = caveat;
  (0, snaps_utils_1.assertIsRpcOrigins)(value, rpc_errors_1.rpcErrors.invalidParams);
}
/**
 * Map a raw value from the `initialPermissions` to a caveat specification.
 * Note that this function does not do any validation, that's handled by the
 * PermissionsController when the permission is requested.
 *
 * @param value - The raw value from the `initialPermissions`.
 * @returns The caveat specification.
 */
function getRpcCaveatMapper(value) {
  return {
    caveats: [{
      type: snaps_utils_1.SnapCaveatType.RpcOrigin,
      value
    }]
  };
}
exports.getRpcCaveatMapper = getRpcCaveatMapper;
/**
 * Getter function to get the {@link RpcOrigins} caveat value from a permission.
 *
 * @param permission - The permission to get the caveat value from.
 * @returns The caveat value.
 * @throws If the permission does not have a valid {@link RpcOrigins} caveat.
 */
function getRpcCaveatOrigins(permission) {
  var _permission$caveats;
  const caveats = permission === null || permission === void 0 || (_permission$caveats = permission.caveats) === null || _permission$caveats === void 0 ? void 0 : _permission$caveats.filter(caveat => caveat.type === snaps_utils_1.SnapCaveatType.RpcOrigin);
  (0, utils_1.assert)(caveats);
  (0, utils_1.assert)(caveats.length === 1);
  const caveat = caveats[0];
  return caveat.value;
}
exports.getRpcCaveatOrigins = getRpcCaveatOrigins;
exports.rpcCaveatSpecifications = {
  [snaps_utils_1.SnapCaveatType.RpcOrigin]: Object.freeze({
    type: snaps_utils_1.SnapCaveatType.RpcOrigin,
    validator: caveat => validateCaveatOrigins(caveat)
  })
};

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\rpc.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\settings-page.cjs", {"./enum.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\enum.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cendowments%5Csettings-page.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.settingsPageEndowmentBuilder = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const enum_1 = require("./enum.cjs");
const permissionName = enum_1.SnapEndowments.SettingsPage;
/**
 * `endowment:settings-page` returns nothing; it is intended to be used as a
 * flag by the snap controller to detect whether the snap has the capability to
 * use the snap settings page feature.
 *
 * @param _builderOptions - Optional specification builder options.
 * @returns The specification for the `settings-page` endowment.
 */
const specificationBuilder = _builderOptions => {
  return {
    permissionType: permission_controller_1.PermissionType.Endowment,
    targetName: permissionName,
    allowedCaveats: null,
    endowmentGetter: _getterOptions => null,
    subjectTypes: [permission_controller_1.SubjectType.Snap]
  };
};
exports.settingsPageEndowmentBuilder = Object.freeze({
  targetName: permissionName,
  specificationBuilder
});

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\settings-page.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\signature-insight.cjs", {"./caveats/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\caveats\\index.cjs","./enum.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\enum.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cendowments%5Csignature-insight.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.signatureInsightCaveatSpecifications = exports.getSignatureOriginCaveat = exports.getSignatureInsightCaveatMapper = exports.signatureInsightEndowmentBuilder = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
const caveats_1 = require("./caveats/index.cjs");
const enum_1 = require("./enum.cjs");
const permissionName = enum_1.SnapEndowments.SignatureInsight;
/**
 * `endowment:signature-insight` returns nothing; it is intended to be used as a flag
 * by the extension to detect whether the snap has the capability to show information on the signature confirmation screen.
 *
 * @param _builderOptions - Optional specification builder options.
 * @returns The specification for the signature-insight endowment.
 */
const specificationBuilder = _builderOptions => {
  return {
    permissionType: permission_controller_1.PermissionType.Endowment,
    targetName: permissionName,
    allowedCaveats: [snaps_utils_1.SnapCaveatType.SignatureOrigin],
    endowmentGetter: _getterOptions => null,
    validator: (0, caveats_1.createGenericPermissionValidator)([{
      type: snaps_utils_1.SnapCaveatType.SignatureOrigin,
      optional: true
    }, {
      type: snaps_utils_1.SnapCaveatType.MaxRequestTime,
      optional: true
    }]),
    subjectTypes: [permission_controller_1.SubjectType.Snap]
  };
};
exports.signatureInsightEndowmentBuilder = Object.freeze({
  targetName: permissionName,
  specificationBuilder
});
/**
 * Validates the type of the caveat value.
 *
 * @param caveat - The caveat to validate.
 * @throws If the caveat value is invalid.
 */
function validateCaveat(caveat) {
  if (!(0, utils_1.hasProperty)(caveat, 'value') || !(0, utils_1.isPlainObject)(caveat)) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Expected a plain object.'
    });
  }
  const {
    value
  } = caveat;
  (0, utils_1.assert)(typeof value === 'boolean', 'Expected caveat value to have type "boolean"');
}
/**
 * Map a raw value from the `initialPermissions` to a caveat specification.
 * Note that this function does not do any validation, that's handled by the
 * PermissionController when the permission is requested.
 *
 * @param value - The raw value from the `initialPermissions`.
 * @returns The caveat specification.
 */
function getSignatureInsightCaveatMapper(value) {
  if (!value || !(0, utils_1.isObject)(value) || (0, utils_1.isObject)(value) && Object.keys(value).length === 0) {
    return {
      caveats: null
    };
  }
  return {
    caveats: [{
      type: snaps_utils_1.SnapCaveatType.SignatureOrigin,
      value: (0, utils_1.hasProperty)(value, 'allowSignatureOrigin') && value.allowSignatureOrigin
    }]
  };
}
exports.getSignatureInsightCaveatMapper = getSignatureInsightCaveatMapper;
/**
 * Getter function to get the signature origin caveat from a permission.
 *
 * This does basic validation of the caveat, but does not validate the type or
 * value of the namespaces object itself, as this is handled by the
 * `PermissionsController` when the permission is requested.
 *
 * @param permission - The permission to get the signature origin caveat from.
 * @returns The signature origin, or `null` if the permission does not have a
 * signature origin caveat.
 */
function getSignatureOriginCaveat(permission) {
  if (!(permission !== null && permission !== void 0 && permission.caveats)) {
    return null;
  }
  (0, utils_1.assert)(permission.caveats.length === 1);
  (0, utils_1.assert)(permission.caveats[0].type === snaps_utils_1.SnapCaveatType.SignatureOrigin);
  const caveat = permission.caveats[0];
  return caveat.value ?? null;
}
exports.getSignatureOriginCaveat = getSignatureOriginCaveat;
exports.signatureInsightCaveatSpecifications = {
  [snaps_utils_1.SnapCaveatType.SignatureOrigin]: Object.freeze({
    type: snaps_utils_1.SnapCaveatType.SignatureOrigin,
    validator: caveat => validateCaveat(caveat)
  })
};

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\signature-insight.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\transaction-insight.cjs", {"./caveats/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\caveats\\index.cjs","./enum.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\enum.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cendowments%5Ctransaction-insight.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transactionInsightCaveatSpecifications = exports.getTransactionOriginCaveat = exports.getTransactionInsightCaveatMapper = exports.transactionInsightEndowmentBuilder = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
const caveats_1 = require("./caveats/index.cjs");
const enum_1 = require("./enum.cjs");
const permissionName = enum_1.SnapEndowments.TransactionInsight;
/**
 * `endowment:transaction-insight` returns nothing; it is intended to be used as a flag
 * by the extension to detect whether the snap has the capability to show information on the transaction confirmation screen.
 *
 * @param _builderOptions - Optional specification builder options.
 * @returns The specification for the transaction-insight endowment.
 */
const specificationBuilder = _builderOptions => {
  return {
    permissionType: permission_controller_1.PermissionType.Endowment,
    targetName: permissionName,
    allowedCaveats: [snaps_utils_1.SnapCaveatType.TransactionOrigin, snaps_utils_1.SnapCaveatType.MaxRequestTime],
    endowmentGetter: _getterOptions => null,
    validator: (0, caveats_1.createGenericPermissionValidator)([{
      type: snaps_utils_1.SnapCaveatType.TransactionOrigin,
      optional: true
    }, {
      type: snaps_utils_1.SnapCaveatType.MaxRequestTime,
      optional: true
    }]),
    subjectTypes: [permission_controller_1.SubjectType.Snap]
  };
};
exports.transactionInsightEndowmentBuilder = Object.freeze({
  targetName: permissionName,
  specificationBuilder
});
/**
 * Validates the type of the caveat value.
 *
 * @param caveat - The caveat to validate.
 * @throws If the caveat value is invalid.
 */
function validateCaveat(caveat) {
  if (!(0, utils_1.hasProperty)(caveat, 'value') || !(0, utils_1.isPlainObject)(caveat)) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Expected a plain object.'
    });
  }
  const {
    value
  } = caveat;
  (0, utils_1.assert)(typeof value === 'boolean', 'Expected caveat value to have type "boolean"');
}
/**
 * Map a raw value from the `initialPermissions` to a caveat specification.
 * Note that this function does not do any validation, that's handled by the
 * PermissionsController when the permission is requested.
 *
 * @param value - The raw value from the `initialPermissions`.
 * @returns The caveat specification.
 */
function getTransactionInsightCaveatMapper(value) {
  if (!value || !(0, utils_1.isObject)(value) || (0, utils_1.isObject)(value) && Object.keys(value).length === 0) {
    return {
      caveats: null
    };
  }
  return {
    caveats: [{
      type: snaps_utils_1.SnapCaveatType.TransactionOrigin,
      value: (0, utils_1.hasProperty)(value, 'allowTransactionOrigin') && value.allowTransactionOrigin
    }]
  };
}
exports.getTransactionInsightCaveatMapper = getTransactionInsightCaveatMapper;
/**
 * Getter function to get the transaction origin caveat from a permission.
 *
 * This does basic validation of the caveat, but does not validate the type or
 * value of the namespaces object itself, as this is handled by the
 * `PermissionsController` when the permission is requested.
 *
 * @param permission - The permission to get the transaction origin caveat from.
 * @returns The transaction origin, or `null` if the permission does not have a
 * transaction origin caveat.
 */
function getTransactionOriginCaveat(permission) {
  if (!(permission !== null && permission !== void 0 && permission.caveats)) {
    return null;
  }
  (0, utils_1.assert)(permission.caveats.length === 1);
  (0, utils_1.assert)(permission.caveats[0].type === snaps_utils_1.SnapCaveatType.TransactionOrigin);
  const caveat = permission.caveats[0];
  return caveat.value ?? null;
}
exports.getTransactionOriginCaveat = getTransactionOriginCaveat;
exports.transactionInsightCaveatSpecifications = {
  [snaps_utils_1.SnapCaveatType.TransactionOrigin]: Object.freeze({
    type: snaps_utils_1.SnapCaveatType.TransactionOrigin,
    validator: caveat => validateCaveat(caveat)
  })
};

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\transaction-insight.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\web-assembly.cjs", {"./enum.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\enum.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cendowments%5Cweb-assembly.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.webAssemblyEndowmentBuilder = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const enum_1 = require("./enum.cjs");
const permissionName = enum_1.SnapEndowments.WebAssemblyAccess;
/**
 * `endowment:webassembly` returns the name of global browser API(s) that
 * enable access to the WebAssembly API.
 * This is intended to populate the endowments of the SES Compartment
 * in which a Snap executes.
 *
 * @param _builderOptions - Optional specification builder options.
 * @returns The specification for the WebAssembly endowment.
 */
const specificationBuilder = _builderOptions => {
  return {
    permissionType: permission_controller_1.PermissionType.Endowment,
    targetName: permissionName,
    allowedCaveats: null,
    endowmentGetter: _getterOptions => {
      return ['WebAssembly'];
    },
    subjectTypes: [permission_controller_1.SubjectType.Snap]
  };
};
exports.webAssemblyEndowmentBuilder = Object.freeze({
  targetName: permissionName,
  specificationBuilder
});

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\web-assembly.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\index.cjs", {"./endowments/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\index.cjs","./middleware/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\middleware\\index.cjs","./permissions.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permissions.cjs","./permitted/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\index.cjs","./restricted/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\index.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\utils.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectHooks = exports.SnapCaveatType = exports.createSnapsMethodMiddleware = exports.permittedMethods = void 0;
var permitted_1 = require("./permitted/index.cjs");
Object.defineProperty(exports, "permittedMethods", {
  enumerable: true,
  get: function () {
    return permitted_1.handlers;
  }
});
Object.defineProperty(exports, "createSnapsMethodMiddleware", {
  enumerable: true,
  get: function () {
    return permitted_1.createSnapsMethodMiddleware;
  }
});
var snaps_utils_1 = require("@metamask/snaps-utils");
Object.defineProperty(exports, "SnapCaveatType", {
  enumerable: true,
  get: function () {
    return snaps_utils_1.SnapCaveatType;
  }
});
var utils_1 = require("./utils.cjs");
Object.defineProperty(exports, "selectHooks", {
  enumerable: true,
  get: function () {
    return utils_1.selectHooks;
  }
});
__exportStar(require("./endowments/index.cjs"), exports);
__exportStar(require("./middleware/index.cjs"), exports);
__exportStar(require("./permissions.cjs"), exports);
__exportStar(require("./restricted/index.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\middleware\\index.cjs", {"./preinstalled-snaps.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\middleware\\preinstalled-snaps.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cmiddleware%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
__exportStar(require("./preinstalled-snaps.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\middleware\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\middleware\\preinstalled-snaps.cjs", {"../endowments/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cmiddleware%5Cpreinstalled-snaps.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPreinstalledSnapsMiddleware = void 0;
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
const endowments_1 = require("../endowments/index.cjs");
const WILDCARD_SCOPE = 'wallet:eip155';
/**
 * Create a middleware that automatically grants account permissions to preinstalled Snaps
 * that want to use the Ethereum provider endowment.
 *
 * @param hooks - The hooks used by the middleware.
 * @param hooks.getAllEvmAccounts - Hook for retriveing all available EVM addresses.
 * @param hooks.getPermissions - Hook for retrieving the permissions of the requesting origin.
 * @param hooks.grantPermissions - Hook for granting permissions to the requesting origin.
 * @returns The middleware.
 */
function createPreinstalledSnapsMiddleware({
  getAllEvmAccounts,
  getPermissions,
  grantPermissions
}) {
  return function methodMiddleware(request, _response, next, _end) {
    var _existingEndowment$ca, _existingOptionalScop;
    if (request.method.startsWith('snap')) {
      return next();
    }
    const permissions = getPermissions();
    if (!permissions || !(0, utils_1.hasProperty)(permissions, endowments_1.SnapEndowments.EthereumProvider)) {
      return next();
    }
    const existingEndowment = permissions['endowment:caip25'];
    const existingCaveat = existingEndowment === null || existingEndowment === void 0 || (_existingEndowment$ca = existingEndowment.caveats) === null || _existingEndowment$ca === void 0 || (_existingEndowment$ca = _existingEndowment$ca.find(caveat => caveat.type === 'authorizedScopes')) === null || _existingEndowment$ca === void 0 ? void 0 : _existingEndowment$ca.value;
    const existingRequiredScopes = (existingCaveat === null || existingCaveat === void 0 ? void 0 : existingCaveat.requiredScopes) ?? {};
    const existingOptionalScopes = (existingCaveat === null || existingCaveat === void 0 ? void 0 : existingCaveat.optionalScopes) ?? {};
    const existingEvmAccounts = ((_existingOptionalScop = existingOptionalScopes[WILDCARD_SCOPE]) === null || _existingOptionalScop === void 0 ? void 0 : _existingOptionalScop.accounts.map(account => account.slice(WILDCARD_SCOPE.length + 1))) ?? [];
    const evmAccounts = getAllEvmAccounts();
    if ((0, snaps_utils_1.isEqual)(evmAccounts, existingEvmAccounts)) {
      return next();
    }
    grantPermissions({
      'endowment:caip25': {
        caveats: [{
          type: 'authorizedScopes',
          value: {
            requiredScopes: existingRequiredScopes,
            optionalScopes: {
              ...existingOptionalScopes,
              [WILDCARD_SCOPE]: {
                accounts: evmAccounts.map(account => `${WILDCARD_SCOPE}:${account}`)
              }
            },
            sessionProperties: {},
            isMultichainOrigin: false
          }
        }]
      }
    });
    return next();
  };
}
exports.createPreinstalledSnapsMiddleware = createPreinstalledSnapsMiddleware;

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\middleware\\preinstalled-snaps.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permissions.cjs", {"./endowments/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\index.cjs","./restricted/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\index.cjs","./utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\utils.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermissions.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildSnapRestrictedMethodSpecifications = exports.buildSnapEndowmentSpecifications = exports.processSnapPermissions = void 0;
const utils_1 = require("@metamask/utils");
const endowments_1 = require("./endowments/index.cjs");
const restricted_1 = require("./restricted/index.cjs");
const utils_2 = require("./utils.cjs");
/**
 * Map initial permissions as defined in a Snap manifest to something that can
 * be processed by the PermissionsController. Each caveat mapping function
 * should return a valid permission caveat value.
 *
 * This function does not validate the caveat values, since that is done by
 * the PermissionsController itself, upon requesting the permissions.
 *
 * @param initialPermissions - The initial permissions to process.
 * @returns The processed permissions.
 */
function processSnapPermissions(initialPermissions) {
  return Object.fromEntries(Object.entries(initialPermissions).map(([initialPermission, value]) => {
    if ((0, utils_1.hasProperty)(restricted_1.caveatMappers, initialPermission)) {
      return [initialPermission, restricted_1.caveatMappers[initialPermission](value)];
    } else if ((0, utils_1.hasProperty)(endowments_1.endowmentCaveatMappers, initialPermission)) {
      return [initialPermission, endowments_1.endowmentCaveatMappers[initialPermission](value)];
    }
    // If we have no mapping, this may be a non-snap permission, return as-is
    return [initialPermission, value];
  }));
}
exports.processSnapPermissions = processSnapPermissions;
const buildSnapEndowmentSpecifications = excludedEndowments => Object.values(endowments_1.endowmentPermissionBuilders).reduce((allSpecifications, {
  targetName,
  specificationBuilder
}) => {
  if (!excludedEndowments.includes(targetName)) {
    allSpecifications[targetName] = specificationBuilder({});
  }
  return allSpecifications;
}, {});
exports.buildSnapEndowmentSpecifications = buildSnapEndowmentSpecifications;
const buildSnapRestrictedMethodSpecifications = (excludedPermissions, hooks) => Object.values(restricted_1.restrictedMethodPermissionBuilders).reduce((specifications, {
  targetName,
  specificationBuilder,
  methodHooks
}) => {
  if (!excludedPermissions.includes(targetName)) {
    specifications[targetName] = specificationBuilder({
      // @ts-expect-error The selectHooks type is wonky
      methodHooks: (0, utils_2.selectHooks)(hooks, methodHooks)
    });
  }
  return specifications;
}, {});
exports.buildSnapRestrictedMethodSpecifications = buildSnapRestrictedMethodSpecifications;

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permissions.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\cancelBackgroundEvent.cjs", {"../endowments/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CcancelBackgroundEvent.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cancelBackgroundEventHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const superstruct_1 = require("@metamask/superstruct");
const endowments_1 = require("../endowments/index.cjs");
const methodName = 'snap_cancelBackgroundEvent';
const hookNames = {
  cancelBackgroundEvent: true,
  hasPermission: true
};
exports.cancelBackgroundEventHandler = {
  methodNames: [methodName],
  implementation: getCancelBackgroundEventImplementation,
  hookNames
};
const CancelBackgroundEventsParametersStruct = (0, superstruct_1.object)({
  id: (0, superstruct_1.string)()
});
/**
 * The `snap_cancelBackgroundEvent` method implementation.
 *
 * @param req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this
 * function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.cancelBackgroundEvent - The function to cancel a background event.
 * @param hooks.hasPermission - The function to check if a snap has the `endowment:cronjob` permission.
 * @returns Nothing.
 */
async function getCancelBackgroundEventImplementation(req, res, _next, end, {
  cancelBackgroundEvent,
  hasPermission
}) {
  const {
    params
  } = req;
  if (!hasPermission(endowments_1.SnapEndowments.Cronjob)) {
    return end(rpc_errors_1.providerErrors.unauthorized());
  }
  try {
    const validatedParams = getValidatedParams(params);
    const {
      id
    } = validatedParams;
    cancelBackgroundEvent(id);
    res.result = null;
  } catch (error) {
    return end(error);
  }
  return end();
}
/**
 * Validate the cancelBackgroundEvent method `params` and returns them cast to the correct type. Throws if validation fails.
 *
 * @param params - The unvalidated params object from the method request.
 * @returns The validated resolveInterface method parameter object.
 */
function getValidatedParams(params) {
  try {
    return (0, superstruct_1.create)(params, CancelBackgroundEventsParametersStruct);
  } catch (error) {
    if (error instanceof superstruct_1.StructError) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Invalid params: ${error.message}.`
      });
    }
    /* istanbul ignore next */
    throw rpc_errors_1.rpcErrors.internal();
  }
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\cancelBackgroundEvent.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\clearState.cjs", {"../restricted/manageState.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\manageState.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CclearState.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.clearStateHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const superstruct_1 = require("@metamask/superstruct");
const manageState_1 = require("../restricted/manageState.cjs");
const hookNames = {
  clearSnapState: true,
  hasPermission: true
};
/**
 * `snap_clearState` clears the state of the Snap.
 */
exports.clearStateHandler = {
  methodNames: ['snap_clearState'],
  implementation: clearStateImplementation,
  hookNames
};
const ClearStateParametersStruct = (0, superstruct_1.object)({
  encrypted: (0, superstruct_1.optional)((0, superstruct_1.boolean)())
});
/**
 * The `snap_clearState` method implementation.
 *
 * @param request - The JSON-RPC request object.
 * @param response - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this
 * function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.clearSnapState - A function that clears the state of the
 * requesting Snap.
 * @param hooks.hasPermission - Check whether a given origin has a given
 * permission.
 * @returns Nothing.
 */
async function clearStateImplementation(request, response, _next, end, {
  clearSnapState,
  hasPermission
}) {
  const {
    params
  } = request;
  if (!hasPermission(manageState_1.manageStateBuilder.targetName)) {
    return end(rpc_errors_1.providerErrors.unauthorized());
  }
  try {
    const validatedParams = getValidatedParams(params);
    const {
      encrypted = true
    } = validatedParams;
    clearSnapState(encrypted);
    response.result = null;
  } catch (error) {
    return end(error);
  }
  return end();
}
/**
 * Validate the parameters of the `snap_clearState` method.
 *
 * @param params - The parameters to validate.
 * @returns The validated parameters.
 */
function getValidatedParams(params) {
  try {
    return (0, superstruct_1.create)(params, ClearStateParametersStruct);
  } catch (error) {
    if (error instanceof superstruct_1.StructError) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Invalid params: ${error.message}.`
      });
    }
    /* istanbul ignore next */
    throw rpc_errors_1.rpcErrors.internal();
  }
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\clearState.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\closeWebSocket.cjs", {"../endowments/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CcloseWebSocket.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.closeWebSocketHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const superstruct_1 = require("@metamask/superstruct");
const endowments_1 = require("../endowments/index.cjs");
const hookNames = {
  hasPermission: true,
  closeWebSocket: true
};
const CloseWebSocketParametersStruct = (0, superstruct_1.object)({
  id: (0, superstruct_1.string)()
});
/**
 * Handler for the `snap_closeWebSocket` method.
 */
exports.closeWebSocketHandler = {
  methodNames: ['snap_closeWebSocket'],
  implementation: closeWebSocketImplementation,
  hookNames
};
/**
 * The `snap_closeWebSocket` method implementation.
 *
 * @param req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.hasPermission - The function to check if a snap has the `endowment:network-access` permission.
 * @param hooks.closeWebSocket - The function to close a WebSocket.
 * @returns Nothing.
 */
function closeWebSocketImplementation(req, res, _next, end, {
  hasPermission,
  closeWebSocket
}) {
  if (!hasPermission(endowments_1.SnapEndowments.NetworkAccess)) {
    return end(rpc_errors_1.providerErrors.unauthorized());
  }
  const {
    params
  } = req;
  try {
    const {
      id
    } = getValidatedParams(params);
    closeWebSocket(id);
    res.result = null;
  } catch (error) {
    return end(error);
  }
  return end();
}
/**
 * Validates the parameters for the snap_closeWebSocket method.
 *
 * @param params - Parameters to validate.
 * @returns Validated parameters.
 * @throws Throws RPC error if validation fails.
 */
function getValidatedParams(params) {
  try {
    return (0, superstruct_1.create)(params, CloseWebSocketParametersStruct);
  } catch (error) {
    if (error instanceof superstruct_1.StructError) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Invalid params: ${error.message}.`
      });
    }
    /* istanbul ignore next */
    throw rpc_errors_1.rpcErrors.internal();
  }
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\closeWebSocket.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\createInterface.cjs", {"@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-sdk":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CcreateInterface.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInterfaceHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_sdk_1 = require("@metamask/snaps-sdk");
const superstruct_1 = require("@metamask/superstruct");
const hookNames = {
  createInterface: true
};
exports.createInterfaceHandler = {
  methodNames: ['snap_createInterface'],
  implementation: getCreateInterfaceImplementation,
  hookNames
};
const CreateInterfaceParametersStruct = (0, superstruct_1.object)({
  ui: snaps_sdk_1.ComponentOrElementStruct,
  context: (0, superstruct_1.optional)(snaps_sdk_1.InterfaceContextStruct)
});
/**
 * The `snap_createInterface` method implementation.
 *
 * @param req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this
 * function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.createInterface - The function to create the interface.
 * @returns Nothing.
 */
function getCreateInterfaceImplementation(req, res, _next, end, {
  createInterface
}) {
  const {
    params
  } = req;
  try {
    const validatedParams = getValidatedParams(params);
    const {
      ui,
      context
    } = validatedParams;
    res.result = createInterface(ui, context);
  } catch (error) {
    return end(error);
  }
  return end();
}
/**
 * Validate the createInterface method `params` and returns them cast to the correct
 * type. Throws if validation fails.
 *
 * @param params - The unvalidated params object from the method request.
 * @returns The validated createInterface method parameter object.
 */
function getValidatedParams(params) {
  try {
    return (0, superstruct_1.create)(params, CreateInterfaceParametersStruct);
  } catch (error) {
    if (error instanceof superstruct_1.StructError) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Invalid params: ${error.message}.`
      });
    }
    /* istanbul ignore next */
    throw rpc_errors_1.rpcErrors.internal();
  }
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\createInterface.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\endTrace.cjs", {"@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CendTrace.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.endTraceHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const superstruct_1 = require("@metamask/superstruct");
const hookNames = {
  endTrace: true,
  getSnap: true
};
const EndTraceParametersStruct = (0, superstruct_1.object)({
  id: (0, superstruct_1.exactOptional)((0, superstruct_1.string)()),
  name: (0, superstruct_1.string)(),
  timestamp: (0, superstruct_1.exactOptional)((0, superstruct_1.number)())
});
/**
 * Handler for the `snap_endTrace` method.
 */
exports.endTraceHandler = {
  methodNames: ['snap_endTrace'],
  implementation: getEndTraceImplementation,
  hookNames
};
/**
 * The `snap_endTrace` method implementation. This method is used to end a
 * performance trace in Sentry. It is only available to preinstalled Snaps.
 *
 * @param request - The JSON-RPC request object.
 * @param response - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this
 * function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.endTrace - The hook function to end a performance trace.
 * @param hooks.getSnap - The hook function to get Snap metadata.
 * @returns Nothing.
 */
function getEndTraceImplementation(request, response, _next, end, {
  endTrace,
  getSnap
}) {
  const snap = getSnap(request.origin);
  if (!(snap !== null && snap !== void 0 && snap.preinstalled)) {
    return end(rpc_errors_1.rpcErrors.methodNotFound());
  }
  const {
    params
  } = request;
  try {
    const validatedParams = getValidatedParams(params);
    endTrace(validatedParams);
    response.result = null;
  } catch (error) {
    return end(error);
  }
  return end();
}
/**
 * Validate the parameters for the `snap_endTrace` method.
 *
 * @param params - Parameters to validate.
 * @returns Validated parameters.
 * @throws Throws RPC error if validation fails.
 */
function getValidatedParams(params) {
  try {
    return (0, superstruct_1.create)(params, EndTraceParametersStruct);
  } catch (error) {
    if (error instanceof superstruct_1.StructError) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Invalid params: ${error.message}.`
      });
    }
    /* istanbul ignore next */
    throw rpc_errors_1.rpcErrors.internal();
  }
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\endTrace.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\experimentalProviderRequest.cjs", {"../endowments/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CexperimentalProviderRequest.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.providerRequestHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const endowments_1 = require("../endowments/index.cjs");
// Read-only methods that are currently allowed for this RPC method.
const METHOD_ALLOWLIST = Object.freeze(['eth_blockNumber', 'eth_call', 'eth_chainId', 'eth_coinbase', 'eth_estimateGas', 'eth_feeHistory', 'eth_gasPrice', 'eth_getBalance', 'eth_getBlockByHash', 'eth_getBlockByNumber', 'eth_getBlockTransactionCountByHash', 'eth_getBlockTransactionCountByNumber', 'eth_getCode', 'eth_getFilterChanges', 'eth_getFilterLogs', 'eth_getLogs', 'eth_getProof', 'eth_getStorageAt', 'eth_getTransactionByBlockHashAndIndex', 'eth_getTransactionByBlockNumberAndIndex', 'eth_getTransactionByHash', 'eth_getTransactionCount', 'eth_getTransactionReceipt', 'eth_getUncleByBlockHashAndIndex', 'eth_getUncleByBlockNumberAndIndex', 'eth_getUncleCountByBlockHash', 'eth_getUncleCountByBlockNumber', 'eth_getWork', 'eth_hashrate', 'eth_mining', 'eth_newBlockFilter', 'eth_newFilter', 'eth_newPendingTransactionFilter', 'eth_protocolVersion', 'eth_sendRawTransaction', 'eth_submitHashrate', 'eth_submitWork', 'eth_syncing', 'eth_uninstallFilter', 'net_listening', 'net_peerCount', 'net_version', 'web3_clientVersion', 'web3_sha3']);
const hookNames = {
  hasPermission: true,
  getNetworkConfigurationByChainId: true,
  getNetworkClientById: true
};
exports.providerRequestHandler = {
  methodNames: ['snap_experimentalProviderRequest'],
  implementation: providerRequestImplementation,
  hookNames
};
const ProviderRequestParametersStruct = (0, superstruct_1.object)({
  chainId: utils_1.CaipChainIdStruct,
  request: (0, superstruct_1.type)({
    method: (0, superstruct_1.string)(),
    params: (0, superstruct_1.optional)(utils_1.JsonRpcParamsStruct)
  })
});
/**
 * The `snap_experimentalProviderRequest` method implementation.
 *
 * This RPC method lets Snaps make requests to MetaMask networks that are not currently selected in the UI.
 *
 * The RPC method requires the caller to have the endowment:ethereum-provider permission.
 *
 * NOTE: This implementation is experimental and may be removed or changed without warning.
 *
 * @param req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this
 * function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.hasPermission - Checks whether a given origin has a given permission.
 * @param hooks.getNetworkConfigurationByChainId - Get a network configuration for a given chain ID.
 * @param hooks.getNetworkClientById - Get a network client for a given ID.
 * @returns Nothing.
 */
async function providerRequestImplementation(req,
// `ProviderRequestResult` is an alias for `Json` (which is the default type
// argument for `PendingJsonRpcResponse`), but that may not be the case in the
// future. We use `ProviderRequestResult` here to make it clear that this is
// the expected type of the result.
// eslint-disable-next-line @typescript-eslint/no-unnecessary-type-arguments
res, _next, end, {
  hasPermission,
  getNetworkConfigurationByChainId,
  getNetworkClientById
}) {
  if (!hasPermission(endowments_1.SnapEndowments.EthereumProvider)) {
    return end(rpc_errors_1.rpcErrors.methodNotFound());
  }
  const {
    params
  } = req;
  try {
    const {
      chainId,
      request
    } = getValidatedParams(params);
    if (!METHOD_ALLOWLIST.includes(request.method)) {
      return end(rpc_errors_1.rpcErrors.methodNotFound());
    }
    const parsedChainId = (0, utils_1.parseCaipChainId)(chainId);
    if (parsedChainId.namespace !== 'eip155') {
      return end(rpc_errors_1.rpcErrors.invalidParams({
        message: 'Only EVM networks are currently supported.'
      }));
    }
    const numericalChainId = BigInt(parsedChainId.reference);
    const networkConfiguration = getNetworkConfigurationByChainId((0, utils_1.bigIntToHex)(numericalChainId));
    if (!networkConfiguration) {
      return end(rpc_errors_1.rpcErrors.invalidParams({
        message: 'The requested network is not available.'
      }));
    }
    const rpc = networkConfiguration.rpcEndpoints[networkConfiguration.defaultRpcEndpointIndex];
    const networkClient = getNetworkClientById(rpc.networkClientId);
    const {
      provider
    } = networkClient;
    res.result = await provider.request(request);
  } catch (error) {
    return end(error);
  }
  return end();
}
/**
 * Validate the method `params` and returns them cast to the correct
 * type. Throws if validation fails.
 *
 * @param params - The unvalidated params object from the method request.
 * @returns The validated updateInterface method parameter object.
 */
function getValidatedParams(params) {
  try {
    return (0, superstruct_1.create)(params, ProviderRequestParametersStruct);
  } catch (error) {
    if (error instanceof superstruct_1.StructError) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Invalid params: ${error.message}.`
      });
    }
    /* istanbul ignore next */
    throw rpc_errors_1.rpcErrors.internal();
  }
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\experimentalProviderRequest.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getAllSnaps.cjs", {"@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CgetAllSnaps.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAllSnapsHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const hookNames = {
  getAllSnaps: true
};
/**
 * `wallet_getAllSnaps` gets all installed Snaps. Currently, this can only be
 * called from `https://snaps.metamask.io`.
 */
exports.getAllSnapsHandler = {
  methodNames: ['wallet_getAllSnaps'],
  implementation: getAllSnapsImplementation,
  hookNames
};
/**
 * The `wallet_getAllSnaps` method implementation.
 * Fetches all installed snaps and adds them to the JSON-RPC response.
 *
 * @param request - The JSON-RPC request object.
 * @param response - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this
 * function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.getAllSnaps - A function that returns all installed snaps.
 * @returns Nothing.
 */
async function getAllSnapsImplementation(request, response, _next, end, {
  getAllSnaps
}) {
  // The origin is added by the MetaMask middleware stack.
  const {
    origin
  } = request;
  if (origin !== 'https://snaps.metamask.io') {
    return end(rpc_errors_1.rpcErrors.methodNotFound());
  }
  response.result = await getAllSnaps();
  return end();
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getAllSnaps.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getBackgroundEvents.cjs", {"../endowments/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CgetBackgroundEvents.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBackgroundEventsHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const endowments_1 = require("../endowments/index.cjs");
const methodName = 'snap_getBackgroundEvents';
const hookNames = {
  getBackgroundEvents: true,
  hasPermission: true
};
exports.getBackgroundEventsHandler = {
  methodNames: [methodName],
  implementation: getGetBackgroundEventsImplementation,
  hookNames
};
/**
 * The `snap_getBackgroundEvents` method implementation.
 *
 * @param _req - The JSON-RPC request object. Not used by this function.
 * @param res - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback.
 * Not used by this function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.getBackgroundEvents - The function to get the background events.
 * @param hooks.hasPermission - The function to check if a snap has the `endowment:cronjob` permission.
 * @returns An array of background events.
 */
async function getGetBackgroundEventsImplementation(_req, res, _next, end, {
  getBackgroundEvents,
  hasPermission
}) {
  if (!hasPermission(endowments_1.SnapEndowments.Cronjob)) {
    return end(rpc_errors_1.providerErrors.unauthorized());
  }
  try {
    const events = getBackgroundEvents();
    res.result = events;
  } catch (error) {
    return end(error);
  }
  return end();
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getBackgroundEvents.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getClientStatus.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CgetClientStatus.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getClientStatusHandler = void 0;
const hookNames = {
  getIsLocked: true,
  getIsActive: true
};
/**
 * `snap_getClientStatus` returns useful information about the client running the snap.
 */
exports.getClientStatusHandler = {
  methodNames: ['snap_getClientStatus'],
  implementation: getClientStatusImplementation,
  hookNames
};
/**
 * The `snap_getClientStatus` method implementation.
 * Returns useful information about the client running the snap.
 *
 * @param _request - The JSON-RPC request object. Not used by this function.
 * @param response - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this
 * function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.getIsLocked - A function that returns whether the client is locked or not.
 * @param hooks.getIsActive - A function that returns whether the client is opened or not.
 * @returns Nothing.
 */
async function getClientStatusImplementation(_request, response, _next, end, {
  getIsLocked,
  getIsActive
}) {
  response.result = {
    locked: getIsLocked(),
    active: getIsActive()
  };
  return end();
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getClientStatus.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getCurrencyRate.cjs", {"@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CgetCurrencyRate.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCurrencyRateHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
const superstruct_1 = require("@metamask/superstruct");
const hookNames = {
  getCurrencyRate: true
};
exports.getCurrencyRateHandler = {
  methodNames: ['snap_getCurrencyRate'],
  implementation: getGetCurrencyRateImplementation,
  hookNames
};
const GetCurrencyRateParametersStruct = (0, superstruct_1.object)({
  currency: (0, superstruct_1.union)([(0, snaps_utils_1.currency)('btc')])
});
/**
 * The `snap_getCurrencyRate` method implementation.
 *
 * @param req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this
 * function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.getCurrencyRate - The function to get the rate.
 * @returns Nothing.
 */
function getGetCurrencyRateImplementation(req, res, _next, end, {
  getCurrencyRate
}) {
  const {
    params
  } = req;
  try {
    const validatedParams = getValidatedParams(params);
    const {
      currency: selectedCurrency
    } = validatedParams;
    res.result = getCurrencyRate(selectedCurrency) ?? null;
  } catch (error) {
    return end(error);
  }
  return end();
}
/**
 * Validate the getCurrencyRate method `params` and returns them cast to the correct
 * type. Throws if validation fails.
 *
 * @param params - The unvalidated params object from the method request.
 * @returns The validated getCurrencyRate method parameter object.
 */
function getValidatedParams(params) {
  try {
    return (0, superstruct_1.create)(params, GetCurrencyRateParametersStruct);
  } catch (error) {
    if (error instanceof superstruct_1.StructError) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Invalid params: ${error.message}.`
      });
    }
    /* istanbul ignore next */
    throw rpc_errors_1.rpcErrors.internal();
  }
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getCurrencyRate.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getFile.cjs", {"@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-sdk":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CgetFile.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFileHandler = exports.GetFileArgsStruct = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_sdk_1 = require("@metamask/snaps-sdk");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
exports.GetFileArgsStruct = (0, superstruct_1.object)({
  path: (0, superstruct_1.string)(),
  encoding: (0, superstruct_1.optional)((0, superstruct_1.union)([(0, snaps_sdk_1.enumValue)(snaps_sdk_1.AuxiliaryFileEncoding.Base64), (0, snaps_sdk_1.enumValue)(snaps_sdk_1.AuxiliaryFileEncoding.Hex), (0, snaps_sdk_1.enumValue)(snaps_sdk_1.AuxiliaryFileEncoding.Utf8)]))
});
const hookNames = {
  getSnapFile: true
};
exports.getFileHandler = {
  methodNames: ['snap_getFile'],
  implementation,
  hookNames
};
/**
 * The `snap_getFile` method implementation.
 *
 * @param req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this
 * function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.getSnapFile - The function to load a static snap file.
 * @returns Nothing.
 */
async function implementation(req, res, _next, end, {
  getSnapFile
}) {
  const {
    params
  } = req;
  (0, utils_1.assertStruct)(params, exports.GetFileArgsStruct, 'Invalid "snap_getFile" parameters', rpc_errors_1.rpcErrors.invalidParams);
  try {
    res.result = await getSnapFile(params.path, params.encoding ?? snaps_sdk_1.AuxiliaryFileEncoding.Base64);
  } catch (error) {
    return end(error);
  }
  return end();
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getFile.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getInterfaceContext.cjs", {"@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CgetInterfaceContext.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInterfaceContextHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const superstruct_1 = require("@metamask/superstruct");
const hookNames = {
  getInterfaceContext: true
};
exports.getInterfaceContextHandler = {
  methodNames: ['snap_getInterfaceContext'],
  implementation: getInterfaceContextImplementation,
  hookNames
};
const GetInterfaceContextParametersStruct = (0, superstruct_1.object)({
  id: (0, superstruct_1.string)()
});
/**
 * The `snap_getInterfaceContext` method implementation.
 *
 * @param req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this
 * function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.getInterfaceContext - The function to get the interface context.
 * @returns Noting.
 */
function getInterfaceContextImplementation(req, res, _next, end, {
  getInterfaceContext
}) {
  const {
    params
  } = req;
  try {
    const validatedParams = getValidatedParams(params);
    const {
      id
    } = validatedParams;
    res.result = getInterfaceContext(id);
  } catch (error) {
    return end(error);
  }
  return end();
}
/**
 * Validate the getInterfaceContext method `params` and returns them cast to the correct
 * type. Throws if validation fails.
 *
 * @param params - The unvalidated params object from the method request.
 * @returns The validated getInterfaceContext method parameter object.
 */
function getValidatedParams(params) {
  try {
    return (0, superstruct_1.create)(params, GetInterfaceContextParametersStruct);
  } catch (error) {
    if (error instanceof superstruct_1.StructError) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Invalid params: ${error.message}.`
      });
    }
    /* istanbul ignore next */
    throw rpc_errors_1.rpcErrors.internal();
  }
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getInterfaceContext.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getInterfaceState.cjs", {"@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CgetInterfaceState.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInterfaceStateHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const superstruct_1 = require("@metamask/superstruct");
const hookNames = {
  getInterfaceState: true
};
exports.getInterfaceStateHandler = {
  methodNames: ['snap_getInterfaceState'],
  implementation: getGetInterfaceStateImplementation,
  hookNames
};
const GetInterfaceStateParametersStruct = (0, superstruct_1.object)({
  id: (0, superstruct_1.string)()
});
/**
 * The `snap_getInterfaceState` method implementation.
 *
 * @param req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this
 * function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.getInterfaceState - The function to get the interface state.
 * @returns Noting.
 */
function getGetInterfaceStateImplementation(req, res, _next, end, {
  getInterfaceState
}) {
  const {
    params
  } = req;
  try {
    const validatedParams = getValidatedParams(params);
    const {
      id
    } = validatedParams;
    res.result = getInterfaceState(id);
  } catch (error) {
    return end(error);
  }
  return end();
}
/**
 * Validate the getInterfaceState method `params` and returns them cast to the correct
 * type. Throws if validation fails.
 *
 * @param params - The unvalidated params object from the method request.
 * @returns The validated getInterfaceState method parameter object.
 */
function getValidatedParams(params) {
  try {
    return (0, superstruct_1.create)(params, GetInterfaceStateParametersStruct);
  } catch (error) {
    if (error instanceof superstruct_1.StructError) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Invalid params: ${error.message}.`
      });
    }
    /* istanbul ignore next */
    throw rpc_errors_1.rpcErrors.internal();
  }
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getInterfaceState.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getSnaps.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CgetSnaps.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSnapsHandler = void 0;
const hookNames = {
  getSnaps: true
};
/**
 * `wallet_getSnaps` gets the requester's permitted and installed Snaps.
 */
exports.getSnapsHandler = {
  methodNames: ['wallet_getSnaps'],
  implementation: getSnapsImplementation,
  hookNames
};
/**
 * The `wallet_getSnaps` method implementation.
 * Fetches available snaps for the requesting origin and adds them to the JSON-RPC response.
 *
 * @param _req - The JSON-RPC request object. Not used by this function.
 * @param res - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this
 * function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.getSnaps - A function that returns the snaps available for the requesting origin.
 * @returns Nothing.
 */
async function getSnapsImplementation(_req, res, _next, end, {
  getSnaps
}) {
  // getSnaps is already bound to the origin
  res.result = await getSnaps();
  return end();
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getSnaps.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getState.cjs", {"../restricted/manageState.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\manageState.cjs","../utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\utils.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CgetState.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.get = exports.getStateHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const manageState_1 = require("../restricted/manageState.cjs");
const utils_2 = require("../utils.cjs");
const hookNames = {
  hasPermission: true,
  getSnapState: true,
  getUnlockPromise: true
};
/**
 * `snap_getState` gets the state of the Snap.
 */
exports.getStateHandler = {
  methodNames: ['snap_getState'],
  implementation: getStateImplementation,
  hookNames
};
const GetStateParametersStruct = (0, superstruct_1.object)({
  key: (0, superstruct_1.optional)(utils_2.StateKeyStruct),
  encrypted: (0, superstruct_1.optional)((0, superstruct_1.boolean)())
});
/**
 * The `snap_getState` method implementation.
 *
 * @param request - The JSON-RPC request object.
 * @param response - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this
 * function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.hasPermission - Check whether a given origin has a given
 * permission.
 * @param hooks.getSnapState - Get the state of the requesting Snap.
 * @param hooks.getUnlockPromise - Wait for the extension to be unlocked.
 * @returns Nothing.
 */
async function getStateImplementation(request,
// `GetStateResult` is an alias for `Json` (which is the default type argument
// for `PendingJsonRpcResponse`), but that may not be the case in the future.
// We use `GetStateResult` here to make it clear that this is the expected
// type of the result.
// eslint-disable-next-line @typescript-eslint/no-unnecessary-type-arguments
response, _next, end, {
  hasPermission,
  getSnapState,
  getUnlockPromise
}) {
  const {
    params
  } = request;
  if (!hasPermission(manageState_1.manageStateBuilder.targetName)) {
    return end(rpc_errors_1.providerErrors.unauthorized());
  }
  try {
    const validatedParams = getValidatedParams(params);
    const {
      key,
      encrypted = true
    } = validatedParams;
    if (encrypted) {
      await getUnlockPromise(true);
    }
    const state = await getSnapState(encrypted);
    response.result = get(state, key);
  } catch (error) {
    return end(error);
  }
  return end();
}
/**
 * Validate the parameters of the `snap_getState` method.
 *
 * @param params - The parameters to validate.
 * @returns The validated parameters.
 */
function getValidatedParams(params) {
  try {
    return (0, superstruct_1.create)(params, GetStateParametersStruct);
  } catch (error) {
    if (error instanceof superstruct_1.StructError) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Invalid params: ${error.message}.`
      });
    }
    /* istanbul ignore next */
    throw rpc_errors_1.rpcErrors.internal();
  }
}
/**
 * Get the value of a key in an object. The key may contain Lodash-style path
 * syntax, e.g., `a.b.c` (with the exception of array syntax). If the key does
 * not exist, `null` is returned.
 *
 * This is a simplified version of Lodash's `get` function, but Lodash doesn't
 * seem to be maintained anymore, so we're using our own implementation.
 *
 * @param value - The object to get the key from.
 * @param key - The key to get.
 * @returns The value of the key in the object, or `null` if the key does not
 * exist.
 */
function get(value, key) {
  if (key === undefined) {
    return value;
  }
  const keys = key.split('.');
  let result = value;
  // Intentionally using a classic for loop here for performance reasons.
  // eslint-disable-next-line @typescript-eslint/prefer-for-of
  for (let i = 0; i < keys.length; i++) {
    const currentKey = keys[i];
    if (utils_2.FORBIDDEN_KEYS.includes(currentKey)) {
      throw rpc_errors_1.rpcErrors.invalidParams('Invalid params: Key contains forbidden characters.');
    }
    if ((0, utils_1.isObject)(result)) {
      if (!(0, utils_1.hasProperty)(result, currentKey)) {
        return null;
      }
      result = result[currentKey];
      continue;
    }
    return null;
  }
  return result;
}
exports.get = get;

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getState.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getWebSockets.cjs", {"../endowments/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CgetWebSockets.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getWebSocketsHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const endowments_1 = require("../endowments/index.cjs");
const hookNames = {
  hasPermission: true,
  getWebSockets: true
};
/**
 * Handler for the `snap_getWebSockets` method.
 */
exports.getWebSocketsHandler = {
  methodNames: ['snap_getWebSockets'],
  implementation: getWebSocketsImplementation,
  hookNames
};
/**
 * The `snap_getWebSockets` method implementation.
 *
 * @param _req - The JSON-RPC request object. Not used by this function.
 * @param res - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.hasPermission - The function to check if a snap has the `endowment:network-access` permission.
 * @param hooks.getWebSockets - The function to get the connected WebSockets for the origin.
 * @returns Nothing.
 */
function getWebSocketsImplementation(_req, res, _next, end, {
  hasPermission,
  getWebSockets
}) {
  if (!hasPermission(endowments_1.SnapEndowments.NetworkAccess)) {
    return end(rpc_errors_1.providerErrors.unauthorized());
  }
  try {
    res.result = getWebSockets();
  } catch (error) {
    return end(error);
  }
  return end();
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getWebSockets.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\handlers.cjs", {"./cancelBackgroundEvent.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\cancelBackgroundEvent.cjs","./clearState.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\clearState.cjs","./closeWebSocket.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\closeWebSocket.cjs","./createInterface.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\createInterface.cjs","./endTrace.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\endTrace.cjs","./experimentalProviderRequest.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\experimentalProviderRequest.cjs","./getAllSnaps.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getAllSnaps.cjs","./getBackgroundEvents.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getBackgroundEvents.cjs","./getClientStatus.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getClientStatus.cjs","./getCurrencyRate.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getCurrencyRate.cjs","./getFile.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getFile.cjs","./getInterfaceContext.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getInterfaceContext.cjs","./getInterfaceState.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getInterfaceState.cjs","./getSnaps.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getSnaps.cjs","./getState.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getState.cjs","./getWebSockets.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\getWebSockets.cjs","./invokeKeyring.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\invokeKeyring.cjs","./invokeSnapSugar.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\invokeSnapSugar.cjs","./listEntropySources.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\listEntropySources.cjs","./openWebSocket.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\openWebSocket.cjs","./requestSnaps.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\requestSnaps.cjs","./resolveInterface.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\resolveInterface.cjs","./scheduleBackgroundEvent.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\scheduleBackgroundEvent.cjs","./sendWebSocketMessage.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\sendWebSocketMessage.cjs","./setState.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\setState.cjs","./startTrace.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\startTrace.cjs","./trackError.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\trackError.cjs","./trackEvent.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\trackEvent.cjs","./updateInterface.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\updateInterface.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5Chandlers.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handlers = exports.methodHandlers = void 0;
const cancelBackgroundEvent_1 = require("./cancelBackgroundEvent.cjs");
const clearState_1 = require("./clearState.cjs");
const closeWebSocket_1 = require("./closeWebSocket.cjs");
const createInterface_1 = require("./createInterface.cjs");
const endTrace_1 = require("./endTrace.cjs");
const experimentalProviderRequest_1 = require("./experimentalProviderRequest.cjs");
const getAllSnaps_1 = require("./getAllSnaps.cjs");
const getBackgroundEvents_1 = require("./getBackgroundEvents.cjs");
const getClientStatus_1 = require("./getClientStatus.cjs");
const getCurrencyRate_1 = require("./getCurrencyRate.cjs");
const getFile_1 = require("./getFile.cjs");
const getInterfaceContext_1 = require("./getInterfaceContext.cjs");
const getInterfaceState_1 = require("./getInterfaceState.cjs");
const getSnaps_1 = require("./getSnaps.cjs");
const getState_1 = require("./getState.cjs");
const getWebSockets_1 = require("./getWebSockets.cjs");
const invokeKeyring_1 = require("./invokeKeyring.cjs");
const invokeSnapSugar_1 = require("./invokeSnapSugar.cjs");
const listEntropySources_1 = require("./listEntropySources.cjs");
const openWebSocket_1 = require("./openWebSocket.cjs");
const requestSnaps_1 = require("./requestSnaps.cjs");
const resolveInterface_1 = require("./resolveInterface.cjs");
const scheduleBackgroundEvent_1 = require("./scheduleBackgroundEvent.cjs");
const sendWebSocketMessage_1 = require("./sendWebSocketMessage.cjs");
const setState_1 = require("./setState.cjs");
const startTrace_1 = require("./startTrace.cjs");
const trackError_1 = require("./trackError.cjs");
const trackEvent_1 = require("./trackEvent.cjs");
const updateInterface_1 = require("./updateInterface.cjs");
/* eslint-disable @typescript-eslint/naming-convention */
exports.methodHandlers = {
  wallet_getAllSnaps: getAllSnaps_1.getAllSnapsHandler,
  wallet_getSnaps: getSnaps_1.getSnapsHandler,
  wallet_requestSnaps: requestSnaps_1.requestSnapsHandler,
  wallet_invokeSnap: invokeSnapSugar_1.invokeSnapSugarHandler,
  wallet_invokeKeyring: invokeKeyring_1.invokeKeyringHandler,
  snap_clearState: clearState_1.clearStateHandler,
  snap_getClientStatus: getClientStatus_1.getClientStatusHandler,
  snap_getFile: getFile_1.getFileHandler,
  snap_getState: getState_1.getStateHandler,
  snap_createInterface: createInterface_1.createInterfaceHandler,
  snap_updateInterface: updateInterface_1.updateInterfaceHandler,
  snap_getInterfaceState: getInterfaceState_1.getInterfaceStateHandler,
  snap_getInterfaceContext: getInterfaceContext_1.getInterfaceContextHandler,
  snap_listEntropySources: listEntropySources_1.listEntropySourcesHandler,
  snap_resolveInterface: resolveInterface_1.resolveInterfaceHandler,
  snap_getCurrencyRate: getCurrencyRate_1.getCurrencyRateHandler,
  snap_experimentalProviderRequest: experimentalProviderRequest_1.providerRequestHandler,
  snap_scheduleBackgroundEvent: scheduleBackgroundEvent_1.scheduleBackgroundEventHandler,
  snap_cancelBackgroundEvent: cancelBackgroundEvent_1.cancelBackgroundEventHandler,
  snap_getBackgroundEvents: getBackgroundEvents_1.getBackgroundEventsHandler,
  snap_setState: setState_1.setStateHandler,
  snap_trackError: trackError_1.trackErrorHandler,
  snap_trackEvent: trackEvent_1.trackEventHandler,
  snap_openWebSocket: openWebSocket_1.openWebSocketHandler,
  snap_closeWebSocket: closeWebSocket_1.closeWebSocketHandler,
  snap_sendWebSocketMessage: sendWebSocketMessage_1.sendWebSocketMessageHandler,
  snap_getWebSockets: getWebSockets_1.getWebSocketsHandler,
  snap_startTrace: startTrace_1.startTraceHandler,
  snap_endTrace: endTrace_1.endTraceHandler
};
/* eslint-enable @typescript-eslint/naming-convention */
exports.handlers = Object.values(exports.methodHandlers);

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\handlers.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\index.cjs", {"./handlers.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\handlers.cjs","./middleware.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\middleware.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
__exportStar(require("./handlers.cjs"), exports);
__exportStar(require("./middleware.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\invokeKeyring.cjs", {"./invokeSnapSugar.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\invokeSnapSugar.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CinvokeKeyring.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.invokeKeyringHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
const invokeSnapSugar_1 = require("./invokeSnapSugar.cjs");
const hookNames = {
  hasPermission: true,
  handleSnapRpcRequest: true,
  getSnap: true,
  getAllowedKeyringMethods: true
};
/**
 * `wallet_invokeKeyring` gets the requester's permitted and installed Snaps.
 */
exports.invokeKeyringHandler = {
  methodNames: ['wallet_invokeKeyring'],
  implementation: invokeKeyringImplementation,
  hookNames
};
/**
 * The `wallet_invokeKeyring` method implementation.
 * Invokes onKeyringRequest if the snap requested is installed and connected to the dapp.
 *
 * @param req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this
 * function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.handleSnapRpcRequest - Invokes a snap with a given RPC request.
 * @param hooks.hasPermission - Checks whether a given origin has a given permission.
 * @param hooks.getSnap - Gets information about a given snap.
 * @param hooks.getAllowedKeyringMethods - Get the list of allowed Keyring
 * methods for a given origin.
 * @returns Nothing.
 */
async function invokeKeyringImplementation(req,
// `InvokeKeyringResult` is an alias for `Json` (which is the default type
// argument for `PendingJsonRpcResponse`), but that may not be the case in the
// future. We use `InvokeKeyringResult` here to make it clear that this is the
// expected type of the result.
// eslint-disable-next-line @typescript-eslint/no-unnecessary-type-arguments
res, _next, end, {
  handleSnapRpcRequest,
  hasPermission,
  getSnap,
  getAllowedKeyringMethods
}) {
  let params;
  try {
    params = (0, invokeSnapSugar_1.getValidatedParams)(req.params);
  } catch (error) {
    return end(error);
  }
  // We expect the MM middleware stack to always add the origin to requests
  const {
    origin
  } = req;
  const {
    snapId,
    request
  } = params;
  if (!origin || !hasPermission(snaps_utils_1.WALLET_SNAP_PERMISSION_KEY)) {
    return end(rpc_errors_1.rpcErrors.invalidRequest({
      message: `The snap "${snapId}" is not connected to "${origin}". Please connect before invoking the snap.`
    }));
  }
  if (!getSnap(snapId)) {
    return end(rpc_errors_1.rpcErrors.invalidRequest({
      message: `The snap "${snapId}" is not installed. Please install it first, before invoking the snap.`
    }));
  }
  if (!(0, utils_1.hasProperty)(request, 'method') || typeof request.method !== 'string') {
    return end(rpc_errors_1.rpcErrors.invalidRequest({
      message: 'The request must have a method.'
    }));
  }
  const allowedMethods = getAllowedKeyringMethods();
  if (!allowedMethods.includes(request.method)) {
    return end(rpc_errors_1.rpcErrors.invalidRequest({
      message: `The origin "${origin}" is not allowed to invoke the method "${request.method}".`
    }));
  }
  try {
    res.result = await handleSnapRpcRequest({
      snapId,
      request,
      handler: snaps_utils_1.HandlerType.OnKeyringRequest
    });
  } catch (error) {
    return end(error);
  }
  return end();
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\invokeKeyring.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\invokeSnapSugar.cjs", {"@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CinvokeSnapSugar.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValidatedParams = exports.invokeSnapSugar = exports.invokeSnapSugarHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const utils_1 = require("@metamask/utils");
/**
 * `wallet_invokeSnap` attempts to invoke an RPC method of the specified Snap.
 */
exports.invokeSnapSugarHandler = {
  methodNames: ['wallet_invokeSnap'],
  implementation: invokeSnapSugar,
  hookNames: {
    invokeSnap: true
  }
};
/**
 * The `wallet_invokeSnap` method implementation.
 * Effectively calls `wallet_snap` under the hood.
 *
 * @param req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.invokeSnap - A function to invoke a snap designated by its parameters,
 * bound to the requesting origin.
 * @returns Nothing.
 * @throws If the params are invalid.
 */
async function invokeSnapSugar(req,
// `InvokeSnapResult` is an alias for `Json` (which is the default type
// argument for `PendingJsonRpcResponse`), but that may not be the case in the
// future. We use `InvokeSnapResult` here to make it clear that this is the
// expected type of the result.
// eslint-disable-next-line @typescript-eslint/no-unnecessary-type-arguments
res, _next, end, {
  invokeSnap
}) {
  try {
    const params = getValidatedParams(req.params);
    res.result = await invokeSnap(params);
  } catch (error) {
    return end(error);
  }
  return end();
}
exports.invokeSnapSugar = invokeSnapSugar;
/**
 * Validates the wallet_invokeSnap method `params` and returns them cast to the correct
 * type. Throws if validation fails.
 *
 * @param params - The unvalidated params object from the method request.
 * @returns The validated method parameter object.
 */
function getValidatedParams(params) {
  if (!(0, utils_1.isObject)(params)) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Expected params to be a single object.'
    });
  }
  const {
    snapId,
    request
  } = params;
  if (!snapId || typeof snapId !== 'string' || snapId === '') {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Must specify a valid snap ID.'
    });
  }
  if (!(0, utils_1.isObject)(request)) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Expected request to be a single object.'
    });
  }
  return params;
}
exports.getValidatedParams = getValidatedParams;

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\invokeSnapSugar.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\listEntropySources.cjs", {"../restricted/getBip32Entropy.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getBip32Entropy.cjs","../restricted/getBip32PublicKey.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getBip32PublicKey.cjs","../restricted/getBip44Entropy.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getBip44Entropy.cjs","../restricted/getEntropy.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getEntropy.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5ClistEntropySources.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.listEntropySourcesHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const getBip32Entropy_1 = require("../restricted/getBip32Entropy.cjs");
const getBip32PublicKey_1 = require("../restricted/getBip32PublicKey.cjs");
const getBip44Entropy_1 = require("../restricted/getBip44Entropy.cjs");
const getEntropy_1 = require("../restricted/getEntropy.cjs");
/**
 * A list of permissions that the requesting origin must have at least one of
 * in order to call this method.
 */
const REQUIRED_PERMISSIONS = [getBip32Entropy_1.getBip32EntropyBuilder.targetName, getBip32PublicKey_1.getBip32PublicKeyBuilder.targetName, getBip44Entropy_1.getBip44EntropyBuilder.targetName, getEntropy_1.getEntropyBuilder.targetName];
const hookNames = {
  hasPermission: true,
  getEntropySources: true,
  getUnlockPromise: true
};
exports.listEntropySourcesHandler = {
  methodNames: ['snap_listEntropySources'],
  implementation: listEntropySourcesImplementation,
  hookNames
};
/**
 * The `snap_listEntropySources` method implementation.
 *
 * @param _request - The JSON-RPC request object. Not used by this function.
 * @param response - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this
 * function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.hasPermission - The function to check if the origin has a
 * permission.
 * @param hooks.getEntropySources - The function to get the entropy sources.
 * @param hooks.getUnlockPromise - The function to get the unlock promise.
 * @returns Noting.
 */
async function listEntropySourcesImplementation(_request, response, _next, end, {
  hasPermission,
  getEntropySources,
  getUnlockPromise
}) {
  const isPermitted = REQUIRED_PERMISSIONS.some(hasPermission);
  if (!isPermitted) {
    return end(rpc_errors_1.providerErrors.unauthorized());
  }
  await getUnlockPromise(true);
  response.result = getEntropySources();
  return end();
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\listEntropySources.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\middleware.cjs", {"../utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\utils.cjs","./handlers.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\handlers.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5Cmiddleware.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSnapsMethodMiddleware = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
const handlers_1 = require("./handlers.cjs");
const utils_1 = require("../utils.cjs");
/**
 * Creates a middleware that handles permitted snap RPC methods.
 *
 * @param isSnap - A flag that should indicate whether the requesting origin is a snap or not.
 * @param hooks - An object containing the hooks made available to the permitted RPC methods.
 * @returns The middleware.
 */
function createSnapsMethodMiddleware(isSnap, hooks) {
  // This is not actually a misused promise, the type is just wrong
  // eslint-disable-next-line @typescript-eslint/no-misused-promises
  return async function methodMiddleware(request, response, next, end) {
    const handler = handlers_1.methodHandlers[request.method];
    if (handler) {
      if (String.prototype.startsWith.call(request.method, 'snap_') && !isSnap) {
        return end(rpc_errors_1.rpcErrors.methodNotFound());
      }
      // TODO: Once json-rpc-engine types are up to date, we should type this correctly
      const {
        implementation,
        hookNames
      } = handler;
      try {
        // Implementations may or may not be async, so we must await them.
        return await implementation(request, response, next, end, (0, utils_1.selectHooks)(hooks, hookNames));
      } catch (error) {
        (0, snaps_utils_1.logError)(error);
        return end(error);
      }
    }
    return next();
  };
}
exports.createSnapsMethodMiddleware = createSnapsMethodMiddleware;

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\middleware.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\openWebSocket.cjs", {"../endowments/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-sdk":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CopenWebSocket.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openWebSocketHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_sdk_1 = require("@metamask/snaps-sdk");
const snaps_utils_1 = require("@metamask/snaps-utils");
const superstruct_1 = require("@metamask/superstruct");
const endowments_1 = require("../endowments/index.cjs");
const hookNames = {
  hasPermission: true,
  openWebSocket: true
};
const OpenWebSocketParametersStruct = (0, superstruct_1.object)({
  url: (0, snaps_utils_1.uri)({
    protocol: (0, snaps_sdk_1.union)([(0, snaps_sdk_1.literal)('wss:'), (0, snaps_sdk_1.literal)('ws:')])
  }),
  protocols: (0, superstruct_1.optional)((0, superstruct_1.array)((0, superstruct_1.string)()))
});
/**
 * Handler for the `snap_openWebSocket` method.
 */
exports.openWebSocketHandler = {
  methodNames: ['snap_openWebSocket'],
  implementation: openWebSocketImplementation,
  hookNames
};
/**
 * The `snap_openWebSocket` method implementation.
 *
 * @param req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.hasPermission - The function to check if a snap has the `endowment:network-access` permission.
 * @param hooks.openWebSocket - The function to open a WebSocket.
 * @returns Nothing.
 */
async function openWebSocketImplementation(req, res, _next, end, {
  hasPermission,
  openWebSocket
}) {
  if (!hasPermission(endowments_1.SnapEndowments.NetworkAccess)) {
    return end(rpc_errors_1.providerErrors.unauthorized());
  }
  const {
    params
  } = req;
  try {
    const {
      url,
      protocols
    } = getValidatedParams(params);
    res.result = await openWebSocket(url, protocols);
  } catch (error) {
    return end(error);
  }
  return end();
}
/**
 * Validates the parameters for the snap_openWebSocket method.
 *
 * @param params - Parameters to validate.
 * @returns Validated parameters.
 * @throws Throws RPC error if validation fails.
 */
function getValidatedParams(params) {
  try {
    return (0, superstruct_1.create)(params, OpenWebSocketParametersStruct);
  } catch (error) {
    if (error instanceof superstruct_1.StructError) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Invalid params: ${error.message}.`
      });
    }
    /* istanbul ignore next */
    throw rpc_errors_1.rpcErrors.internal();
  }
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\openWebSocket.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\requestSnaps.cjs", {"../restricted/invokeSnap.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\invokeSnap.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CrequestSnaps.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSnapPermissionsRequest = exports.hasRequestedSnaps = exports.requestSnapsHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
const invokeSnap_1 = require("../restricted/invokeSnap.cjs");
const hookNames = {
  installSnaps: true,
  requestPermissions: true,
  getPermissions: true
};
/**
 * `wallet_requestSnaps` installs the requested Snaps and requests permission to use them if necessary.
 */
exports.requestSnapsHandler = {
  methodNames: ['wallet_requestSnaps'],
  implementation: requestSnapsImplementation,
  hookNames
};
/**
 * Checks whether an origin has existing `wallet_snap` permission and
 * whether or not it has the requested snapIds caveat.
 *
 * @param existingPermissions - The existing permissions for the origin.
 * @param requestedSnaps - The requested snaps.
 * @returns True if the existing permissions satisfy the requested snaps, otherwise false.
 */
function hasRequestedSnaps(existingPermissions, requestedSnaps) {
  var _existingPermissions$;
  const snapIdCaveat = (_existingPermissions$ = existingPermissions[invokeSnap_1.WALLET_SNAP_PERMISSION_KEY]) === null || _existingPermissions$ === void 0 || (_existingPermissions$ = _existingPermissions$.caveats) === null || _existingPermissions$ === void 0 ? void 0 : _existingPermissions$.find(caveat => caveat.type === snaps_utils_1.SnapCaveatType.SnapIds);
  const permittedSnaps = snapIdCaveat === null || snapIdCaveat === void 0 ? void 0 : snapIdCaveat.value;
  if ((0, utils_1.isObject)(permittedSnaps)) {
    return Object.keys(requestedSnaps).every(requestedSnap => (0, utils_1.hasProperty)(permittedSnaps, requestedSnap));
  }
  return false;
}
exports.hasRequestedSnaps = hasRequestedSnaps;
/**
 * Constructs a valid permission request with merged caveats based on existing permissions
 * and the requested snaps.
 *
 * @param existingPermissions - The existing permissions for the origin.
 * @param requestedPermissions - The permission request passed into `requestPermissions`.
 * @returns `requestedPermissions`.
 */
function getSnapPermissionsRequest(existingPermissions, requestedPermissions) {
  var _existingPermissions$2;
  (0, snaps_utils_1.verifyRequestedSnapPermissions)(requestedPermissions);
  if (!existingPermissions[invokeSnap_1.WALLET_SNAP_PERMISSION_KEY]) {
    return requestedPermissions;
  }
  const snapIdCaveat = (_existingPermissions$2 = existingPermissions[invokeSnap_1.WALLET_SNAP_PERMISSION_KEY].caveats) === null || _existingPermissions$2 === void 0 ? void 0 : _existingPermissions$2.find(caveat => caveat.type === snaps_utils_1.SnapCaveatType.SnapIds);
  const permittedSnaps = (snapIdCaveat === null || snapIdCaveat === void 0 ? void 0 : snapIdCaveat.value) ?? {};
  const requestedSnaps = requestedPermissions[invokeSnap_1.WALLET_SNAP_PERMISSION_KEY].caveats[0].value;
  const snapIdSet = new Set([...Object.keys(permittedSnaps), ...Object.keys(requestedSnaps)]);
  const mergedCaveatValue = [...snapIdSet].reduce((request, snapId) => {
    request[snapId] = requestedSnaps[snapId] ?? permittedSnaps[snapId];
    return request;
  }, {});
  requestedPermissions[invokeSnap_1.WALLET_SNAP_PERMISSION_KEY].caveats[0].value = mergedCaveatValue;
  return requestedPermissions;
}
exports.getSnapPermissionsRequest = getSnapPermissionsRequest;
/**
 * The `wallet_requestSnaps` method implementation.
 * Tries to install the requested snaps and adds them to the JSON-RPC response.
 *
 * @param req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this
 * function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.installSnaps - A function that tries to install a given snap, prompting the user if necessary.
 * @param hooks.requestPermissions - A function that requests permissions on
 * behalf of a subject.
 * @param hooks.getPermissions - A function that gets the current permissions.
 * @returns A promise that resolves once the JSON-RPC response has been modified.
 * @throws If the params are invalid.
 */
async function requestSnapsImplementation(req, res, _next, end, {
  installSnaps,
  requestPermissions,
  getPermissions
}) {
  const requestedSnaps = req.params;
  if (!(0, utils_1.isObject)(requestedSnaps)) {
    return end(rpc_errors_1.rpcErrors.invalidParams({
      message: '"params" must be an object.'
    }));
  }
  try {
    if (Object.keys(requestedSnaps).length === 0) {
      return end(rpc_errors_1.rpcErrors.invalidParams({
        message: 'Request must have at least one requested snap.'
      }));
    }
    const requestedPermissions = {
      [invokeSnap_1.WALLET_SNAP_PERMISSION_KEY]: {
        caveats: [{
          type: snaps_utils_1.SnapCaveatType.SnapIds,
          value: requestedSnaps
        }]
      }
    };
    const existingPermissions = await getPermissions();
    if (!existingPermissions) {
      const [, metadata] = await requestPermissions(requestedPermissions);
      res.result = metadata.data[invokeSnap_1.WALLET_SNAP_PERMISSION_KEY];
    } else if (hasRequestedSnaps(existingPermissions, requestedSnaps)) {
      res.result = await installSnaps(requestedSnaps);
    } else {
      const mergedPermissionsRequest = getSnapPermissionsRequest(existingPermissions, requestedPermissions);
      const [, metadata] = await requestPermissions(mergedPermissionsRequest);
      res.result = metadata.data[invokeSnap_1.WALLET_SNAP_PERMISSION_KEY];
    }
  } catch (error) {
    res.error = error;
  }
  return end();
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\requestSnaps.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\resolveInterface.cjs", {"@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CresolveInterface.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveInterfaceHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const hookNames = {
  resolveInterface: true
};
exports.resolveInterfaceHandler = {
  methodNames: ['snap_resolveInterface'],
  implementation: getResolveInterfaceImplementation,
  hookNames
};
const ResolveInterfaceParametersStruct = (0, superstruct_1.object)({
  id: (0, superstruct_1.string)(),
  value: utils_1.JsonStruct
});
/**
 * The `snap_resolveInterface` method implementation.
 *
 * @param req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this
 * function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.resolveInterface - The function to resolve the interface.
 * @returns Nothing.
 */
async function getResolveInterfaceImplementation(req, res, _next, end, {
  resolveInterface
}) {
  const {
    params
  } = req;
  try {
    const validatedParams = getValidatedParams(params);
    const {
      id,
      value
    } = validatedParams;
    await resolveInterface(id, value);
    res.result = null;
  } catch (error) {
    return end(error);
  }
  return end();
}
/**
 * Validate the resolveInterface method `params` and returns them cast to the correct
 * type. Throws if validation fails.
 *
 * @param params - The unvalidated params object from the method request.
 * @returns The validated resolveInterface method parameter object.
 */
function getValidatedParams(params) {
  try {
    return (0, superstruct_1.create)(params, ResolveInterfaceParametersStruct);
  } catch (error) {
    if (error instanceof superstruct_1.StructError) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Invalid params: ${error.message}.`
      });
    }
    /* istanbul ignore next */
    throw rpc_errors_1.rpcErrors.internal();
  }
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\resolveInterface.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\scheduleBackgroundEvent.cjs", {"../endowments/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-sdk":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CscheduleBackgroundEvent.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleBackgroundEventHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_sdk_1 = require("@metamask/snaps-sdk");
const snaps_utils_1 = require("@metamask/snaps-utils");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const endowments_1 = require("../endowments/index.cjs");
const methodName = 'snap_scheduleBackgroundEvent';
const hookNames = {
  scheduleBackgroundEvent: true,
  hasPermission: true
};
exports.scheduleBackgroundEventHandler = {
  methodNames: [methodName],
  implementation: getScheduleBackgroundEventImplementation,
  hookNames
};
const ScheduleBackgroundEventParametersWithDateStruct = (0, superstruct_1.object)({
  date: snaps_utils_1.ISO8601DateStruct,
  request: snaps_utils_1.CronjobRpcRequestStruct
});
const ScheduleBackgroundEventParametersWithDurationStruct = (0, superstruct_1.object)({
  duration: snaps_utils_1.ISO8601DurationStruct,
  request: snaps_utils_1.CronjobRpcRequestStruct
});
const ScheduleBackgroundEventParametersStruct = (0, snaps_sdk_1.selectiveUnion)(val => {
  if ((0, utils_1.hasProperty)(val, 'date')) {
    return ScheduleBackgroundEventParametersWithDateStruct;
  }
  return ScheduleBackgroundEventParametersWithDurationStruct;
});
/**
 * Get the schedule for a background event based on the provided parameters.
 *
 * @param params - The parameters for the background event.
 * @returns The schedule parameters for the background event.
 */
function getSchedule(params) {
  if ((0, utils_1.hasProperty)(params, 'date')) {
    // TODO: Check why `params.date` is not a string.
    return params.date;
  }
  return params.duration;
}
/**
 * The `snap_scheduleBackgroundEvent` method implementation.
 *
 * @param req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this
 * function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.scheduleBackgroundEvent - The function to schedule a background event.
 * @param hooks.hasPermission - The function to check if a snap has the `endowment:cronjob` permission.
 * @returns An id representing the background event.
 */
async function getScheduleBackgroundEventImplementation(req, res, _next, end, {
  scheduleBackgroundEvent,
  hasPermission
}) {
  const {
    params
  } = req;
  if (!hasPermission(endowments_1.SnapEndowments.Cronjob)) {
    return end(rpc_errors_1.providerErrors.unauthorized());
  }
  try {
    const validatedParams = getValidatedParams(params);
    const {
      request
    } = validatedParams;
    const schedule = getSchedule(validatedParams);
    const id = scheduleBackgroundEvent({
      schedule,
      request
    });
    res.result = id;
  } catch (error) {
    return end(error);
  }
  return end();
}
/**
 * Validate the scheduleBackgroundEvent method `params` and returns them cast to the correct
 * type. Throws if validation fails.
 *
 * @param params - The unvalidated params object from the method request.
 * @returns The validated resolveInterface method parameter object.
 */
function getValidatedParams(params) {
  try {
    return (0, superstruct_1.create)(params, ScheduleBackgroundEventParametersStruct);
  } catch (error) {
    if (error instanceof superstruct_1.StructError) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Invalid params: ${error.message}.`
      });
    }
    /* istanbul ignore next */
    throw rpc_errors_1.rpcErrors.internal();
  }
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\scheduleBackgroundEvent.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\sendWebSocketMessage.cjs", {"../endowments/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\endowments\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-sdk":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CsendWebSocketMessage.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendWebSocketMessageHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_sdk_1 = require("@metamask/snaps-sdk");
const superstruct_1 = require("@metamask/superstruct");
const endowments_1 = require("../endowments/index.cjs");
const hookNames = {
  hasPermission: true,
  sendWebSocketMessage: true
};
const SendWebSocketMessageParametersStruct = (0, superstruct_1.object)({
  id: (0, superstruct_1.string)(),
  message: (0, snaps_sdk_1.union)([(0, superstruct_1.string)(), (0, superstruct_1.array)((0, superstruct_1.number)())])
});
/**
 * Handler for the `snap_sendWebSocketMessage` method.
 */
exports.sendWebSocketMessageHandler = {
  methodNames: ['snap_sendWebSocketMessage'],
  implementation: sendWebSocketMessageImplementation,
  hookNames
};
/**
 * The `snap_sendWebSocketMessage` method implementation.
 *
 * @param req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.hasPermission - The function to check if a snap has the `endowment:network-access` permission.
 * @param hooks.sendWebSocketMessage - The function to send a WebSocket message.
 * @returns Nothing.
 */
async function sendWebSocketMessageImplementation(req, res, _next, end, {
  hasPermission,
  sendWebSocketMessage
}) {
  if (!hasPermission(endowments_1.SnapEndowments.NetworkAccess)) {
    return end(rpc_errors_1.providerErrors.unauthorized());
  }
  const {
    params
  } = req;
  try {
    const {
      id,
      message
    } = getValidatedParams(params);
    await sendWebSocketMessage(id, message);
    res.result = null;
  } catch (error) {
    return end(error);
  }
  return end();
}
/**
 * Validates the parameters for the snap_sendWebSocketMessage method.
 *
 * @param params - Parameters to validate.
 * @returns Validated parameters.
 * @throws Throws RPC error if validation fails.
 */
function getValidatedParams(params) {
  try {
    return (0, superstruct_1.create)(params, SendWebSocketMessageParametersStruct);
  } catch (error) {
    if (error instanceof superstruct_1.StructError) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Invalid params: ${error.message}.`
      });
    }
    /* istanbul ignore next */
    throw rpc_errors_1.rpcErrors.internal();
  }
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\sendWebSocketMessage.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\setState.cjs", {"../restricted/manageState.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\manageState.cjs","../utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\utils.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CsetState.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.set = exports.setStateHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const manageState_1 = require("../restricted/manageState.cjs");
const utils_2 = require("../utils.cjs");
const hookNames = {
  hasPermission: true,
  getSnapState: true,
  getUnlockPromise: true,
  updateSnapState: true,
  getSnap: true
};
/**
 * `snap_setState` sets the state of the Snap.
 */
exports.setStateHandler = {
  methodNames: ['snap_setState'],
  implementation: setStateImplementation,
  hookNames
};
const SetStateParametersStruct = (0, superstruct_1.object)({
  key: (0, superstruct_1.optional)(utils_2.StateKeyStruct),
  value: utils_1.JsonStruct,
  encrypted: (0, superstruct_1.optional)((0, superstruct_1.boolean)())
});
/**
 * The `snap_setState` method implementation.
 *
 * @param request - The JSON-RPC request object.
 * @param response - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this
 * function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.hasPermission - Check whether a given origin has a given
 * permission.
 * @param hooks.getSnapState - Get the state of the requesting Snap.
 * @param hooks.getUnlockPromise - Wait for the extension to be unlocked.
 * @param hooks.updateSnapState - Update the state of the requesting Snap.
 * @param hooks.getSnap - The hook function to get Snap metadata.
 * @returns Nothing.
 */
async function setStateImplementation(request, response, _next, end, {
  hasPermission,
  getSnapState,
  getUnlockPromise,
  updateSnapState,
  getSnap
}) {
  const {
    params
  } = request;
  if (!hasPermission(manageState_1.manageStateBuilder.targetName)) {
    return end(rpc_errors_1.providerErrors.unauthorized());
  }
  try {
    const validatedParams = getValidatedParams(params);
    const {
      key,
      value,
      encrypted = true
    } = validatedParams;
    if (key === undefined && !(0, utils_1.isObject)(value)) {
      return end(rpc_errors_1.rpcErrors.invalidParams('Invalid params: Value must be an object if key is not provided.'));
    }
    if (encrypted) {
      await getUnlockPromise(true);
    }
    const newState = await getNewState(key, value, encrypted, getSnapState);
    const snap = getSnap(request.origin);
    if (!(snap !== null && snap !== void 0 && snap.preinstalled)) {
      // We know that the state is valid JSON as per previous validation.
      const size = (0, snaps_utils_1.getJsonSizeUnsafe)(newState, true);
      if (size > manageState_1.STORAGE_SIZE_LIMIT) {
        throw rpc_errors_1.rpcErrors.invalidParams({
          message: `Invalid params: The new state must not exceed ${manageState_1.STORAGE_SIZE_LIMIT / 1000000} MB in size.`
        });
      }
    }
    await updateSnapState(newState, encrypted);
    response.result = null;
  } catch (error) {
    return end(error);
  }
  return end();
}
/**
 * Validate the parameters of the `snap_setState` method.
 *
 * @param params - The parameters to validate.
 * @returns The validated parameters.
 */
function getValidatedParams(params) {
  try {
    return (0, superstruct_1.create)(params, SetStateParametersStruct);
  } catch (error) {
    if (error instanceof superstruct_1.StructError) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Invalid params: ${error.message}.`
      });
    }
    /* istanbul ignore next */
    throw rpc_errors_1.rpcErrors.internal();
  }
}
/**
 * Get the new state of the Snap.
 *
 * If the key is `undefined`, the value is expected to be an object. In this
 * case, the value is returned as the new state.
 *
 * If the key is not `undefined`, the value is set in the state at the key. If
 * the key does not exist, it is created (and any missing intermediate keys are
 * created as well).
 *
 * @param key - The key to set.
 * @param value - The value to set the key to.
 * @param encrypted - Whether the state is encrypted.
 * @param getSnapState - The `getSnapState` hook.
 * @returns The new state of the Snap.
 */
async function getNewState(key, value, encrypted, getSnapState) {
  if (key === undefined) {
    (0, utils_1.assert)((0, utils_1.isObject)(value));
    return value;
  }
  const state = await getSnapState(encrypted);
  return set(state, key, value);
}
/**
 * Set the value of a key in an object. The key may contain Lodash-style path
 * syntax, e.g., `a.b.c` (with the exception of array syntax). If the key does
 * not exist, it is created (and any missing intermediate keys are created as
 * well).
 *
 * This is a simplified version of Lodash's `set` function, but Lodash doesn't
 * seem to be maintained anymore, so we're using our own implementation.
 *
 * @param object - The object to get the key from.
 * @param key - The key to set.
 * @param value - The value to set the key to.
 * @returns The new object with the key set to the value.
 */
function set(object, key, value) {
  const keys = key.split('.');
  const requiredObject = object ?? {};
  let currentObject = requiredObject;
  for (let i = 0; i < keys.length; i++) {
    const currentKey = keys[i];
    if (utils_2.FORBIDDEN_KEYS.includes(currentKey)) {
      throw rpc_errors_1.rpcErrors.invalidParams('Invalid params: Key contains forbidden characters.');
    }
    if (i === keys.length - 1) {
      currentObject[currentKey] = value;
      return requiredObject;
    }
    if (!(0, utils_1.hasProperty)(currentObject, currentKey) || currentObject[currentKey] === null) {
      currentObject[currentKey] = {};
    } else if (!(0, utils_1.isObject)(currentObject[currentKey])) {
      throw rpc_errors_1.rpcErrors.invalidParams('Invalid params: Cannot overwrite non-object value.');
    }
    currentObject = currentObject[currentKey];
  }
  // This should never be reached.
  /* istanbul ignore next */
  throw new Error('Unexpected error while setting the state.');
}
exports.set = set;

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\setState.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\startTrace.cjs", {"@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CstartTrace.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startTraceHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const hookNames = {
  startTrace: true,
  getSnap: true
};
const StartTraceParametersStruct = (0, superstruct_1.object)({
  data: (0, superstruct_1.exactOptional)((0, superstruct_1.record)((0, superstruct_1.string)(), (0, superstruct_1.union)([(0, superstruct_1.string)(), (0, superstruct_1.number)(), (0, superstruct_1.boolean)()]))),
  id: (0, superstruct_1.exactOptional)((0, superstruct_1.string)()),
  name: (0, superstruct_1.string)(),
  parentContext: (0, superstruct_1.exactOptional)(utils_1.JsonStruct),
  startTime: (0, superstruct_1.exactOptional)((0, superstruct_1.number)()),
  tags: (0, superstruct_1.exactOptional)((0, superstruct_1.record)((0, superstruct_1.string)(), (0, superstruct_1.union)([(0, superstruct_1.string)(), (0, superstruct_1.number)(), (0, superstruct_1.boolean)()])))
});
/**
 * Handler for the `snap_startTrace` method.
 */
exports.startTraceHandler = {
  methodNames: ['snap_startTrace'],
  implementation: getStartTraceImplementation,
  hookNames
};
/**
 * The `snap_startTrace` method implementation. This method is used to start a
 * performance trace in Sentry. It is only available to preinstalled Snaps.
 *
 * @param request - The JSON-RPC request object.
 * @param response - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this
 * function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.startTrace - The hook function to start a performance trace.
 * @param hooks.getSnap - The hook function to get Snap metadata.
 * @returns Nothing.
 */
function getStartTraceImplementation(request, response, _next, end, {
  startTrace,
  getSnap
}) {
  const snap = getSnap(request.origin);
  if (!(snap !== null && snap !== void 0 && snap.preinstalled)) {
    return end(rpc_errors_1.rpcErrors.methodNotFound());
  }
  const {
    params
  } = request;
  try {
    const validatedParams = getValidatedParams(params);
    response.result = startTrace(validatedParams);
  } catch (error) {
    return end(error);
  }
  return end();
}
/**
 * Validate the parameters for the `snap_startTrace` method.
 *
 * @param params - Parameters to validate.
 * @returns Validated parameters.
 * @throws Throws RPC error if validation fails.
 */
function getValidatedParams(params) {
  try {
    return (0, superstruct_1.create)(params, StartTraceParametersStruct);
  } catch (error) {
    if (error instanceof superstruct_1.StructError) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Invalid params: ${error.message}.`
      });
    }
    /* istanbul ignore next */
    throw rpc_errors_1.rpcErrors.internal();
  }
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\startTrace.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\trackError.cjs", {"@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CtrackError.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.trackErrorHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
const superstruct_1 = require("@metamask/superstruct");
const hookNames = {
  trackError: true,
  getSnap: true
};
const TrackErrorParametersStruct = (0, superstruct_1.object)({
  error: snaps_utils_1.TrackableErrorStruct
});
/**
 * Handler for the `snap_trackError` method.
 */
exports.trackErrorHandler = {
  methodNames: ['snap_trackError'],
  implementation: getTrackErrorImplementation,
  hookNames
};
/**
 * The `snap_trackError` method implementation. This method allows preinstalled
 * Snaps to send errors to the Sentry instance in the client for tracking.
 *
 * @param request - The JSON-RPC request object.
 * @param response - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this
 * function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.trackError - The hook function to track an error.
 * @param hooks.getSnap - The hook function to get Snap metadata.
 * @returns Nothing.
 */
function getTrackErrorImplementation(request, response, _next, end, {
  trackError,
  getSnap
}) {
  const snap = getSnap(request.origin);
  if (!(snap !== null && snap !== void 0 && snap.preinstalled)) {
    return end(rpc_errors_1.rpcErrors.methodNotFound());
  }
  const {
    params
  } = request;
  try {
    const validatedParams = getValidatedParams(params);
    const error = deserializeError(validatedParams.error);
    response.result = trackError(error);
  } catch (error) {
    return end(error);
  }
  return end();
}
/**
 * Validate the parameters for the `snap_trackError` method.
 *
 * @param params - Parameters to validate.
 * @returns Validated parameters.
 * @throws Throws RPC error if validation fails.
 */
function getValidatedParams(params) {
  try {
    return (0, superstruct_1.create)(params, TrackErrorParametersStruct);
  } catch (error) {
    if (error instanceof superstruct_1.StructError) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Invalid params: ${error.message}.`
      });
    }
    /* istanbul ignore next */
    throw rpc_errors_1.rpcErrors.internal();
  }
}
/**
 * Deserialize a {@link TrackableError} into a standard {@link Error} object.
 *
 * @param error - The error to deserialize.
 * @returns A standard {@link Error} object with the same properties as the
 * original {@link TrackableError}.
 */
function deserializeError(error) {
  const deserializedError = new Error(error.message);
  deserializedError.name = error.name;
  deserializedError.stack = error.stack ?? undefined;
  deserializedError.cause = error.cause ? deserializeError(error.cause) : undefined;
  return deserializedError;
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\trackError.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\trackEvent.cjs", {"@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CtrackEvent.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.trackEventHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const PropertiesStruct = (0, superstruct_1.optional)((0, superstruct_1.record)((0, superstruct_1.string)(), utils_1.JsonStruct));
const snakeCaseRegex = /^[a-z][a-z0-9]*(?:_[a-z0-9]+)*$/u;
const SnakeCasePropertiesStruct = (0, superstruct_1.refine)(PropertiesStruct, 'snake_case_keys', value => {
  if (!value) {
    return true;
  }
  return Object.keys(value).every(key => snakeCaseRegex.test(key));
});
const hookNames = {
  trackEvent: true,
  getSnap: true
};
const TrackEventParametersStruct = (0, superstruct_1.object)({
  event: (0, superstruct_1.object)({
    event: (0, superstruct_1.string)(),
    properties: SnakeCasePropertiesStruct,
    sensitiveProperties: SnakeCasePropertiesStruct
  })
});
/**
 * Handler for the `snap_trackEvent` method.
 */
exports.trackEventHandler = {
  methodNames: ['snap_trackEvent'],
  implementation: getTrackEventImplementation,
  hookNames
};
/**
 * The `snap_trackEvent` method implementation.
 * This method allows pre-installed Snaps to submit tracking events to the client.
 *
 * @param req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.trackEvent - The function to track the event.
 * @param hooks.getSnap - The function to get Snap metadata.
 * @returns Nothing.
 */
function getTrackEventImplementation(req, res, _next, end, {
  trackEvent,
  getSnap
}) {
  const snap = getSnap(req.origin);
  if (!(snap !== null && snap !== void 0 && snap.preinstalled)) {
    return end(rpc_errors_1.rpcErrors.methodNotFound());
  }
  const {
    params
  } = req;
  try {
    const validatedParams = getValidatedParams(params);
    trackEvent(validatedParams.event);
    res.result = null;
  } catch (error) {
    return end(error);
  }
  return end();
}
/**
 * Validates the parameters for the snap_trackEvent method.
 *
 * @param params - Parameters to validate.
 * @returns Validated parameters.
 * @throws Throws RPC error if validation fails.
 */
function getValidatedParams(params) {
  try {
    return (0, superstruct_1.create)(params, TrackEventParametersStruct);
  } catch (error) {
    if (error instanceof superstruct_1.StructError) {
      if (error.refinement === 'snake_case_keys') {
        throw rpc_errors_1.rpcErrors.invalidParams({
          message: `Invalid params: All property keys must be in snake_case format. The following key contains invalid properties: "${error.key}".`
        });
      }
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Invalid params: ${error.message}.`
      });
    }
    /* istanbul ignore next */
    throw rpc_errors_1.rpcErrors.internal();
  }
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\trackEvent.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\updateInterface.cjs", {"@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-sdk":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cpermitted%5CupdateInterface.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateInterfaceHandler = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_sdk_1 = require("@metamask/snaps-sdk");
const superstruct_1 = require("@metamask/superstruct");
const hookNames = {
  updateInterface: true
};
exports.updateInterfaceHandler = {
  methodNames: ['snap_updateInterface'],
  implementation: getUpdateInterfaceImplementation,
  hookNames
};
const UpdateInterfaceParametersStruct = (0, superstruct_1.object)({
  id: (0, superstruct_1.string)(),
  ui: snaps_sdk_1.ComponentOrElementStruct,
  context: (0, superstruct_1.optional)(snaps_sdk_1.InterfaceContextStruct)
});
/**
 * The `snap_updateInterface` method implementation.
 *
 * @param req - The JSON-RPC request object.
 * @param res - The JSON-RPC response object.
 * @param _next - The `json-rpc-engine` "next" callback. Not used by this
 * function.
 * @param end - The `json-rpc-engine` "end" callback.
 * @param hooks - The RPC method hooks.
 * @param hooks.updateInterface - The function to update the interface.
 * @returns Nothing.
 */
function getUpdateInterfaceImplementation(req, res, _next, end, {
  updateInterface
}) {
  const {
    params
  } = req;
  try {
    const validatedParams = getValidatedParams(params);
    const {
      id,
      ui,
      context
    } = validatedParams;
    updateInterface(id, ui, context);
    res.result = null;
  } catch (error) {
    return end(error);
  }
  return end();
}
/**
 * Validate the updateInterface method `params` and returns them cast to the correct
 * type. Throws if validation fails.
 *
 * @param params - The unvalidated params object from the method request.
 * @returns The validated updateInterface method parameter object.
 */
function getValidatedParams(params) {
  try {
    return (0, superstruct_1.create)(params, UpdateInterfaceParametersStruct);
  } catch (error) {
    if (error instanceof superstruct_1.StructError) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Invalid params: ${error.message}.`
      });
    }
    /* istanbul ignore next */
    throw rpc_errors_1.rpcErrors.internal();
  }
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\permitted\\updateInterface.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\caveats\\index.cjs", {"../getBip32Entropy.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getBip32Entropy.cjs","../getBip32PublicKey.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getBip32PublicKey.cjs","../getBip44Entropy.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getBip44Entropy.cjs","../invokeSnap.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\invokeSnap.cjs","./permittedCoinTypes.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\caveats\\permittedCoinTypes.cjs","./permittedDerivationPaths.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\caveats\\permittedDerivationPaths.cjs","./snapIds.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\caveats\\snapIds.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Crestricted%5Ccaveats%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.caveatMappers = exports.caveatSpecifications = void 0;
const permittedCoinTypes_1 = require("./permittedCoinTypes.cjs");
const permittedDerivationPaths_1 = require("./permittedDerivationPaths.cjs");
const snapIds_1 = require("./snapIds.cjs");
const getBip32Entropy_1 = require("../getBip32Entropy.cjs");
const getBip32PublicKey_1 = require("../getBip32PublicKey.cjs");
const getBip44Entropy_1 = require("../getBip44Entropy.cjs");
const invokeSnap_1 = require("../invokeSnap.cjs");
exports.caveatSpecifications = {
  ...permittedDerivationPaths_1.PermittedDerivationPathsCaveatSpecification,
  ...permittedCoinTypes_1.PermittedCoinTypesCaveatSpecification,
  ...snapIds_1.SnapIdsCaveatSpecification
};
exports.caveatMappers = {
  [getBip32Entropy_1.getBip32EntropyBuilder.targetName]: permittedDerivationPaths_1.permittedDerivationPathsCaveatMapper,
  [getBip32PublicKey_1.getBip32PublicKeyBuilder.targetName]: permittedDerivationPaths_1.permittedDerivationPathsCaveatMapper,
  [getBip44Entropy_1.getBip44EntropyBuilder.targetName]: permittedCoinTypes_1.permittedCoinTypesCaveatMapper,
  [invokeSnap_1.invokeSnapBuilder.targetName]: snapIds_1.snapIdsCaveatMapper
};

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\caveats\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\caveats\\permittedCoinTypes.cjs", {"@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Crestricted%5Ccaveats%5CpermittedCoinTypes.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PermittedCoinTypesCaveatSpecification = exports.validateBIP44Caveat = exports.validateBIP44Params = exports.permittedCoinTypesCaveatMapper = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
/**
 * Map a raw value from the `initialPermissions` to a caveat specification.
 * Note that this function does not do any validation, that's handled by the
 * PermissionsController when the permission is requested.
 *
 * @param value - The raw value from the `initialPermissions`.
 * @returns The caveat specification.
 */
function permittedCoinTypesCaveatMapper(value) {
  return {
    caveats: [{
      type: snaps_utils_1.SnapCaveatType.PermittedCoinTypes,
      value
    }]
  };
}
exports.permittedCoinTypesCaveatMapper = permittedCoinTypesCaveatMapper;
/**
 * Validate the params for `snap_getBip44Entropy`.
 *
 * @param value - The params to validate.
 * @throws If the params are invalid.
 */
function validateBIP44Params(value) {
  if (!(0, utils_1.isPlainObject)(value) || !(0, utils_1.hasProperty)(value, 'coinType')) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Expected a plain object containing a coin type.'
    });
  }
  if (typeof value.coinType !== 'number' || !Number.isInteger(value.coinType) || value.coinType < 0 || value.coinType > 0x7fffffff) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Invalid "coinType" parameter. Coin type must be a non-negative integer.'
    });
  }
  if ((0, utils_1.hasProperty)(value, 'source') && typeof value.source !== 'undefined' && typeof value.source !== 'string') {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Invalid "source" parameter. Source must be a string if provided.'
    });
  }
  if (snaps_utils_1.FORBIDDEN_COIN_TYPES.includes(value.coinType)) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: `Coin type ${value.coinType} is forbidden.`
    });
  }
}
exports.validateBIP44Params = validateBIP44Params;
/**
 * Validate the coin types values associated with a caveat. This checks if the
 * values are non-negative integers (>= 0).
 *
 * @param caveat - The caveat to validate.
 * @throws If the caveat is invalid.
 */
function validateBIP44Caveat(caveat) {
  if (!(0, utils_1.hasProperty)(caveat, 'value') || !Array.isArray(caveat.value) || caveat.value.length === 0) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Expected non-empty array of coin types.'
    });
  }
  caveat.value.forEach(validateBIP44Params);
}
exports.validateBIP44Caveat = validateBIP44Caveat;
exports.PermittedCoinTypesCaveatSpecification = {
  [snaps_utils_1.SnapCaveatType.PermittedCoinTypes]: Object.freeze({
    type: snaps_utils_1.SnapCaveatType.PermittedCoinTypes,
    decorator: (method, caveat) => {
      return async args => {
        const {
          params
        } = args;
        validateBIP44Params(params);
        const coinType = caveat.value.find(caveatValue => caveatValue.coinType === params.coinType);
        if (!coinType) {
          throw rpc_errors_1.providerErrors.unauthorized({
            message: 'The requested coin type is not permitted. Allowed coin types must be specified in the snap manifest.'
          });
        }
        return await method(args);
      };
    },
    validator: caveat => validateBIP44Caveat(caveat)
  })
};

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\caveats\\permittedCoinTypes.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\caveats\\permittedDerivationPaths.cjs", {"@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Crestricted%5Ccaveats%5CpermittedDerivationPaths.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PermittedDerivationPathsCaveatSpecification = exports.validateBIP32CaveatPaths = exports.validateBIP32Path = exports.permittedDerivationPathsCaveatMapper = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
/**
 * Map a raw value from the `initialPermissions` to a caveat specification.
 * Note that this function does not do any validation, that's handled by the
 * PermissionsController when the permission is requested.
 *
 * @param value - The raw value from the `initialPermissions`.
 * @returns The caveat specification.
 */
function permittedDerivationPathsCaveatMapper(value) {
  return {
    caveats: [{
      type: snaps_utils_1.SnapCaveatType.PermittedDerivationPaths,
      value
    }]
  };
}
exports.permittedDerivationPathsCaveatMapper = permittedDerivationPathsCaveatMapper;
/**
 * Validate a caveat path object. The object must consist of a `path` array and
 * a `curve` string. Paths must start with `m`, and must contain at
 * least two indices. If `ed25519` is used, this checks if all the path indices
 * are hardened.
 *
 * @param value - The value to validate.
 * @throws If the value is invalid.
 */
function validateBIP32Path(value) {
  (0, utils_1.assertStruct)(value, snaps_utils_1.Bip32EntropyStruct, 'Invalid BIP-32 entropy path definition', rpc_errors_1.rpcErrors.invalidParams);
}
exports.validateBIP32Path = validateBIP32Path;
/**
 * Validate the path values associated with a caveat. This validates that the
 * value is a non-empty array with valid derivation paths and curves.
 *
 * @param caveat - The caveat to validate.
 * @throws If the value is invalid.
 */
function validateBIP32CaveatPaths(caveat) {
  (0, utils_1.assertStruct)(caveat, (0, superstruct_1.type)({
    value: (0, superstruct_1.size)((0, superstruct_1.array)(snaps_utils_1.Bip32EntropyStruct), 1, Infinity)
  }), 'Invalid BIP-32 entropy caveat', rpc_errors_1.rpcErrors.internal);
}
exports.validateBIP32CaveatPaths = validateBIP32CaveatPaths;
exports.PermittedDerivationPathsCaveatSpecification = {
  [snaps_utils_1.SnapCaveatType.PermittedDerivationPaths]: Object.freeze({
    type: snaps_utils_1.SnapCaveatType.PermittedDerivationPaths,
    decorator: (method, caveat) => {
      return async args => {
        const {
          params
        } = args;
        validateBIP32Path(params);
        const path = caveat.value.find(caveatPath => (0, snaps_utils_1.isEqual)(params.path.slice(0, caveatPath.path.length), caveatPath.path) && caveatPath.curve === params.curve);
        if (!path) {
          throw rpc_errors_1.providerErrors.unauthorized({
            message: 'The requested path is not permitted. Allowed paths must be specified in the snap manifest.'
          });
        }
        return await method(args);
      };
    },
    validator: caveat => validateBIP32CaveatPaths(caveat)
  })
};

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\caveats\\permittedDerivationPaths.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\caveats\\snapIds.cjs", {"@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Crestricted%5Ccaveats%5CsnapIds.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapIdsCaveatSpecification = exports.validateSnapIdsCaveat = exports.snapIdsCaveatMapper = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
/**
 * Map a raw value from the `initialPermissions` to a caveat specification.
 * Note that this function does not do any validation, that's handled by the
 * PermissionsController when the permission is requested.
 *
 * @param value - The raw value from the `initialPermissions`.
 * @returns The caveat specification.
 */
function snapIdsCaveatMapper(value) {
  return {
    caveats: [{
      type: snaps_utils_1.SnapCaveatType.SnapIds,
      value
    }]
  };
}
exports.snapIdsCaveatMapper = snapIdsCaveatMapper;
/**
 * Validates that the caveat value exists and is a non-empty object.
 *
 * @param caveat - The caveat to validate.
 * @throws If the caveat is invalid.
 */
function validateSnapIdsCaveat(caveat) {
  (0, utils_1.assertStruct)(caveat, (0, superstruct_1.type)({
    value: snaps_utils_1.SnapIdsStruct
  }), 'Expected caveat to have a value property of a non-empty object of snap IDs.', rpc_errors_1.rpcErrors.invalidParams);
}
exports.validateSnapIdsCaveat = validateSnapIdsCaveat;
exports.SnapIdsCaveatSpecification = {
  [snaps_utils_1.SnapCaveatType.SnapIds]: Object.freeze({
    type: snaps_utils_1.SnapCaveatType.SnapIds,
    validator: caveat => validateSnapIdsCaveat(caveat),
    decorator: (method, caveat) => {
      return async args => {
        const {
          params,
          context: {
            origin
          }
        } = args;
        const snapIds = caveat.value;
        const {
          snapId
        } = params;
        if (!(0, utils_1.hasProperty)(snapIds, snapId)) {
          throw new Error(`${origin} does not have permission to invoke ${snapId} snap.`);
        }
        return await method(args);
      };
    }
  })
};

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\caveats\\snapIds.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\dialog.cjs", {"@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-sdk":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Crestricted%5Cdialog.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDialogImplementation = exports.dialogBuilder = exports.DIALOG_APPROVAL_TYPES = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_sdk_1 = require("@metamask/snaps-sdk");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const methodName = 'snap_dialog';
exports.DIALOG_APPROVAL_TYPES = {
  [snaps_sdk_1.DialogType.Alert]: `${methodName}:alert`,
  [snaps_sdk_1.DialogType.Confirmation]: `${methodName}:confirmation`,
  [snaps_sdk_1.DialogType.Prompt]: `${methodName}:prompt`,
  default: methodName
};
const PlaceholderStruct = (0, superstruct_1.optional)((0, superstruct_1.size)((0, superstruct_1.string)(), 1, 40));
/**
 * The specification builder for the `snap_dialog` permission. `snap_dialog`
 * lets the Snap display one of the following dialogs to the user:
 * - An alert, for displaying information.
 * - A confirmation, for accepting or rejecting some action.
 * - A prompt, for inputting some information.
 *
 * @param options - The specification builder options.
 * @param options.allowedCaveats - The optional allowed caveats for the
 * permission.
 * @param options.methodHooks - The RPC method hooks needed by the method
 * implementation.
 * @returns The specification for the `snap_dialog` permission.
 */
const specificationBuilder = ({
  allowedCaveats = null,
  methodHooks
}) => {
  return {
    permissionType: permission_controller_1.PermissionType.RestrictedMethod,
    targetName: methodName,
    allowedCaveats,
    methodImplementation: getDialogImplementation(methodHooks),
    subjectTypes: [permission_controller_1.SubjectType.Snap]
  };
};
const methodHooks = {
  requestUserApproval: true,
  createInterface: true,
  getInterface: true
};
exports.dialogBuilder = Object.freeze({
  targetName: methodName,
  specificationBuilder,
  methodHooks
});
const AlertParametersWithContentStruct = (0, superstruct_1.object)({
  type: (0, snaps_sdk_1.enumValue)(snaps_sdk_1.DialogType.Alert),
  content: snaps_sdk_1.ComponentOrElementStruct
});
const AlertParametersWithIdStruct = (0, superstruct_1.object)({
  type: (0, snaps_sdk_1.enumValue)(snaps_sdk_1.DialogType.Alert),
  id: (0, superstruct_1.string)()
});
const AlertParametersStruct = (0, snaps_sdk_1.selectiveUnion)(value => {
  if ((0, utils_1.isPlainObject)(value) && (0, utils_1.hasProperty)(value, 'id')) {
    return AlertParametersWithIdStruct;
  }
  return AlertParametersWithContentStruct;
});
const ConfirmationParametersWithContentStruct = (0, superstruct_1.object)({
  type: (0, snaps_sdk_1.enumValue)(snaps_sdk_1.DialogType.Confirmation),
  content: snaps_sdk_1.ComponentOrElementStruct
});
const ConfirmationParametersWithIdStruct = (0, superstruct_1.object)({
  type: (0, snaps_sdk_1.enumValue)(snaps_sdk_1.DialogType.Confirmation),
  id: (0, superstruct_1.string)()
});
const ConfirmationParametersStruct = (0, snaps_sdk_1.selectiveUnion)(value => {
  if ((0, utils_1.isPlainObject)(value) && (0, utils_1.hasProperty)(value, 'id')) {
    return ConfirmationParametersWithIdStruct;
  }
  return ConfirmationParametersWithContentStruct;
});
const PromptParametersWithContentStruct = (0, superstruct_1.object)({
  type: (0, snaps_sdk_1.enumValue)(snaps_sdk_1.DialogType.Prompt),
  content: snaps_sdk_1.ComponentOrElementStruct,
  placeholder: PlaceholderStruct
});
const PromptParametersWithIdStruct = (0, superstruct_1.object)({
  type: (0, snaps_sdk_1.enumValue)(snaps_sdk_1.DialogType.Prompt),
  id: (0, superstruct_1.string)(),
  placeholder: PlaceholderStruct
});
const PromptParametersStruct = (0, snaps_sdk_1.selectiveUnion)(value => {
  if ((0, utils_1.isPlainObject)(value) && (0, utils_1.hasProperty)(value, 'id')) {
    return PromptParametersWithIdStruct;
  }
  return PromptParametersWithContentStruct;
});
const DefaultParametersWithContentStruct = (0, superstruct_1.object)({
  content: snaps_sdk_1.ComponentOrElementStruct
});
const DefaultParametersWithIdStruct = (0, superstruct_1.object)({
  id: (0, superstruct_1.string)()
});
const DefaultParametersStruct = (0, snaps_sdk_1.selectiveUnion)(value => {
  if ((0, utils_1.isPlainObject)(value) && (0, utils_1.hasProperty)(value, 'id')) {
    return DefaultParametersWithIdStruct;
  }
  return DefaultParametersWithContentStruct;
});
const DialogParametersStruct = (0, snaps_sdk_1.selectiveUnion)(value => {
  if ((0, utils_1.isPlainObject)(value) && (0, utils_1.hasProperty)(value, 'type')) {
    switch (value.type) {
      // We cannot use typedUnion here unfortunately.
      case snaps_sdk_1.DialogType.Alert:
        return AlertParametersStruct;
      case snaps_sdk_1.DialogType.Confirmation:
        return ConfirmationParametersStruct;
      case snaps_sdk_1.DialogType.Prompt:
        return PromptParametersStruct;
      default:
        throw new Error(`The "type" property must be one of: ${Object.values(snaps_sdk_1.DialogType).join(', ')}.`);
    }
  }
  return DefaultParametersStruct;
});
/**
 * Builds the method implementation for `snap_dialog`.
 *
 * @param hooks - The RPC method hooks.
 * @param hooks.requestUserApproval - A function that creates a new Approval in the ApprovalController.
 * This function should return a Promise that resolves with the appropriate value when the user has approved or rejected the request.
 * @param hooks.createInterface - A function that creates the interface in SnapInterfaceController.
 * @param hooks.getInterface - A function that gets an interface from SnapInterfaceController.
 * @returns The method implementation which return value depends on the dialog
 * type, valid return types are: string, boolean, null.
 */
function getDialogImplementation({
  requestUserApproval,
  createInterface,
  getInterface
}) {
  return async function dialogImplementation(args) {
    const {
      params,
      context: {
        origin
      }
    } = args;
    if (!(0, utils_1.isObject)(params)) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: 'Invalid params: Expected params to be a single object.'
      });
    }
    const validatedParams = getValidatedParams(params);
    const placeholder = isPromptDialog(validatedParams) ? validatedParams.placeholder : undefined;
    const validatedType = (0, utils_1.hasProperty)(validatedParams, 'type') ? validatedParams.type : 'default';
    const approvalType = exports.DIALOG_APPROVAL_TYPES[validatedType];
    if ((0, utils_1.hasProperty)(validatedParams, 'content')) {
      const id = await createInterface(origin, validatedParams.content);
      return requestUserApproval({
        id: approvalType === exports.DIALOG_APPROVAL_TYPES.default ? id : undefined,
        origin,
        type: approvalType,
        requestData: {
          id,
          placeholder
        }
      });
    }
    validateInterface(origin, validatedParams.id, getInterface);
    return requestUserApproval({
      id: approvalType === exports.DIALOG_APPROVAL_TYPES.default ? validatedParams.id : undefined,
      origin,
      type: approvalType,
      requestData: {
        id: validatedParams.id,
        placeholder
      }
    });
  };
}
exports.getDialogImplementation = getDialogImplementation;
/**
 * Validate that the interface ID is valid.
 *
 * @param origin - The origin of the request.
 * @param id - The interface ID.
 * @param getInterface - The function to get the interface.
 */
function validateInterface(origin, id, getInterface) {
  try {
    getInterface(origin, id);
  } catch (error) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: `Invalid params: ${error.message}`
    });
  }
}
/**
 * Gets the dialog type from the dialog parameters.
 *
 * @param params - The dialog parameters.
 * @returns The dialog type.
 */
function getDialogType(params) {
  return (0, utils_1.hasProperty)(params, 'type') ? params.type : undefined;
}
/**
 * Checks if the dialog parameters are for a prompt dialog.
 *
 * @param params - The dialog parameters.
 * @returns `true` if the dialog parameters are for a prompt dialog, `false` otherwise.
 */
function isPromptDialog(params) {
  return getDialogType(params) === snaps_sdk_1.DialogType.Prompt;
}
/**
 * Validates the confirm method `params` and returns them cast to the correct
 * type. Throws if validation fails.
 *
 * @param params - The unvalidated params object from the method request.
 * @returns The validated confirm method parameter object.
 */
function getValidatedParams(params) {
  try {
    return (0, superstruct_1.create)(params, DialogParametersStruct);
  } catch (error) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: `Invalid params: ${error.message}`
    });
  }
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\dialog.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getBip32Entropy.cjs", {"../utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\utils.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Crestricted%5CgetBip32Entropy.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBip32EntropyImplementation = exports.getBip32EntropyBuilder = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
const utils_2 = require("../utils.cjs");
const targetName = 'snap_getBip32Entropy';
/**
 * The specification builder for the `snap_getBip32Entropy` permission.
 * `snap_getBip32Entropy` lets the Snap control private keys for a particular
 * BIP-32 node.
 *
 * @param options - The specification builder options.
 * @param options.methodHooks - The RPC method hooks needed by the method implementation.
 * @returns The specification for the `snap_getBip32Entropy` permission.
 */
const specificationBuilder = ({
  methodHooks
}) => {
  return {
    permissionType: permission_controller_1.PermissionType.RestrictedMethod,
    targetName,
    allowedCaveats: [snaps_utils_1.SnapCaveatType.PermittedDerivationPaths],
    methodImplementation: getBip32EntropyImplementation(methodHooks),
    validator: ({
      caveats
    }) => {
      if ((caveats === null || caveats === void 0 ? void 0 : caveats.length) !== 1 || caveats[0].type !== snaps_utils_1.SnapCaveatType.PermittedDerivationPaths) {
        throw rpc_errors_1.rpcErrors.invalidParams({
          message: `Expected a single "${snaps_utils_1.SnapCaveatType.PermittedDerivationPaths}" caveat.`
        });
      }
    },
    subjectTypes: [permission_controller_1.SubjectType.Snap]
  };
};
const methodHooks = {
  getMnemonic: true,
  getMnemonicSeed: true,
  getUnlockPromise: true,
  getClientCryptography: true
};
exports.getBip32EntropyBuilder = Object.freeze({
  targetName,
  specificationBuilder,
  methodHooks
});
/**
 * Builds the method implementation for `snap_getBip32Entropy`.
 *
 * @param hooks - The RPC method hooks.
 * @param hooks.getMnemonic - A function to retrieve the Secret Recovery Phrase of the user.
 * @param hooks.getMnemonicSeed - A function to retrieve the BIP-39 seed of the user.
 * @param hooks.getUnlockPromise - A function that resolves once the MetaMask extension is unlocked
 * and prompts the user to unlock their MetaMask if it is locked.
 * @param hooks.getClientCryptography - A function to retrieve the cryptographic
 * functions to use for the client.
 * @returns The method implementation which returns a `JsonSLIP10Node`.
 * @throws If the params are invalid.
 */
function getBip32EntropyImplementation({
  getMnemonic,
  getMnemonicSeed,
  getUnlockPromise,
  getClientCryptography
}) {
  return async function getBip32Entropy(args) {
    await getUnlockPromise(true);
    const {
      params
    } = args;
    (0, utils_1.assert)(params);
    // Using the seed is much faster, but we can only do it for these specific curves.
    if (params.curve === 'secp256k1' || params.curve === 'ed25519') {
      const seed = await (0, utils_2.getValueFromEntropySource)(getMnemonicSeed, params.source);
      const node = await (0, utils_2.getNodeFromSeed)({
        curve: params.curve,
        path: params.path,
        seed,
        cryptographicFunctions: getClientCryptography()
      });
      return node.toJSON();
    }
    const secretRecoveryPhrase = await (0, utils_2.getValueFromEntropySource)(getMnemonic, params.source);
    const node = await (0, utils_2.getNodeFromMnemonic)({
      curve: params.curve,
      path: params.path,
      secretRecoveryPhrase,
      cryptographicFunctions: getClientCryptography()
    });
    return node.toJSON();
  };
}
exports.getBip32EntropyImplementation = getBip32EntropyImplementation;

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getBip32Entropy.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getBip32PublicKey.cjs", {"../utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\utils.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Crestricted%5CgetBip32PublicKey.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBip32PublicKeyImplementation = exports.getBip32PublicKeyBuilder = exports.Bip32PublicKeyArgsStruct = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const utils_2 = require("../utils.cjs");
const targetName = 'snap_getBip32PublicKey';
exports.Bip32PublicKeyArgsStruct = (0, snaps_utils_1.bip32entropy)((0, superstruct_1.object)({
  path: snaps_utils_1.Bip32PathStruct,
  curve: snaps_utils_1.CurveStruct,
  compressed: (0, superstruct_1.optional)((0, superstruct_1.boolean)()),
  source: (0, superstruct_1.optional)((0, superstruct_1.string)())
}));
/**
 * The specification builder for the `snap_getBip32PublicKey` permission.
 * `snap_getBip32PublicKey` lets the Snap retrieve public keys for a particular
 * BIP-32 node.
 *
 * @param options - The specification builder options.
 * @param options.methodHooks - The RPC method hooks needed by the method implementation.
 * @returns The specification for the `snap_getBip32PublicKey` permission.
 */
const specificationBuilder = ({
  methodHooks
}) => {
  return {
    permissionType: permission_controller_1.PermissionType.RestrictedMethod,
    targetName,
    allowedCaveats: [snaps_utils_1.SnapCaveatType.PermittedDerivationPaths],
    methodImplementation: getBip32PublicKeyImplementation(methodHooks),
    validator: ({
      caveats
    }) => {
      if ((caveats === null || caveats === void 0 ? void 0 : caveats.length) !== 1 || caveats[0].type !== snaps_utils_1.SnapCaveatType.PermittedDerivationPaths) {
        throw rpc_errors_1.rpcErrors.invalidParams({
          message: `Expected a single "${snaps_utils_1.SnapCaveatType.PermittedDerivationPaths}" caveat.`
        });
      }
    },
    subjectTypes: [permission_controller_1.SubjectType.Snap]
  };
};
const methodHooks = {
  getMnemonic: true,
  getMnemonicSeed: true,
  getUnlockPromise: true,
  getClientCryptography: true
};
exports.getBip32PublicKeyBuilder = Object.freeze({
  targetName,
  specificationBuilder,
  methodHooks
});
/**
 * Builds the method implementation for `snap_getBip32PublicKey`.
 *
 * @param hooks - The RPC method hooks.
 * @param hooks.getMnemonic - A function to retrieve the Secret Recovery Phrase of the user.
 * @param hooks.getMnemonicSeed - A function to retrieve the BIP-39 seed of the user.
 * @param hooks.getUnlockPromise - A function that resolves once the MetaMask extension is unlocked
 * and prompts the user to unlock their MetaMask if it is locked.
 * @param hooks.getClientCryptography - A function to retrieve the cryptographic
 * functions to use for the client.
 * @returns The method implementation which returns a public key.
 * @throws If the params are invalid.
 */
function getBip32PublicKeyImplementation({
  getMnemonic,
  getMnemonicSeed,
  getUnlockPromise,
  getClientCryptography
}) {
  return async function getBip32PublicKey(args) {
    await getUnlockPromise(true);
    (0, utils_1.assertStruct)(args.params, exports.Bip32PublicKeyArgsStruct, 'Invalid BIP-32 public key params', rpc_errors_1.rpcErrors.invalidParams);
    const {
      params
    } = args;
    // Using the seed is much faster, but we can only do it for these specific curves.
    if (params.curve === 'secp256k1' || params.curve === 'ed25519') {
      const seed = await (0, utils_2.getValueFromEntropySource)(getMnemonicSeed, params.source);
      const node = await (0, utils_2.getNodeFromSeed)({
        curve: params.curve,
        path: params.path,
        seed,
        cryptographicFunctions: getClientCryptography()
      });
      if (params.compressed) {
        return node.compressedPublicKey;
      }
      return node.publicKey;
    }
    const secretRecoveryPhrase = await (0, utils_2.getValueFromEntropySource)(getMnemonic, params.source);
    const node = await (0, utils_2.getNodeFromMnemonic)({
      curve: params.curve,
      path: params.path,
      secretRecoveryPhrase,
      cryptographicFunctions: getClientCryptography()
    });
    if (params.compressed) {
      return node.compressedPublicKey;
    }
    return node.publicKey;
  };
}
exports.getBip32PublicKeyImplementation = getBip32PublicKeyImplementation;

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getBip32PublicKey.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getBip44Entropy.cjs", {"../utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\utils.cjs","@metamask/key-tree":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\index.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Crestricted%5CgetBip44Entropy.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBip44EntropyImplementation = exports.getBip44EntropyBuilder = void 0;
const key_tree_1 = require("@metamask/key-tree");
const permission_controller_1 = require("@metamask/permission-controller");
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("../utils.cjs");
const targetName = 'snap_getBip44Entropy';
/**
 * The specification builder for the `snap_getBip44Entropy` permission.
 * `snap_getBip44Entropy_*` lets the Snap control private keys for a particular
 * BIP-32 coin type.
 *
 * @param options - The specification builder options.
 * @param options.methodHooks - The RPC method hooks needed by the method
 * implementation.
 * @returns The specification for the `snap_getBip44Entropy` permission.
 */
const specificationBuilder = ({
  methodHooks
}) => {
  return {
    permissionType: permission_controller_1.PermissionType.RestrictedMethod,
    targetName,
    allowedCaveats: [snaps_utils_1.SnapCaveatType.PermittedCoinTypes],
    methodImplementation: getBip44EntropyImplementation(methodHooks),
    validator: ({
      caveats
    }) => {
      if ((caveats === null || caveats === void 0 ? void 0 : caveats.length) !== 1 || caveats[0].type !== snaps_utils_1.SnapCaveatType.PermittedCoinTypes) {
        throw rpc_errors_1.rpcErrors.invalidParams({
          message: `Expected a single "${snaps_utils_1.SnapCaveatType.PermittedCoinTypes}" caveat.`
        });
      }
    },
    subjectTypes: [permission_controller_1.SubjectType.Snap]
  };
};
const methodHooks = {
  getMnemonicSeed: true,
  getUnlockPromise: true,
  getClientCryptography: true
};
exports.getBip44EntropyBuilder = Object.freeze({
  targetName,
  specificationBuilder,
  methodHooks
});
/**
 * Builds the method implementation for `snap_getBip44Entropy`.
 *
 * @param hooks - The RPC method hooks.
 * @param hooks.getMnemonicSeed - A function to retrieve the BIP-39 seed
 * of the user.
 * @param hooks.getUnlockPromise - A function that resolves once the MetaMask
 * extension is unlocked and prompts the user to unlock their MetaMask if it is
 * locked.
 * @param hooks.getClientCryptography - A function to retrieve the cryptographic
 * functions to use for the client.
 * @returns The method implementation which returns a `BIP44CoinTypeNode`.
 * @throws If the params are invalid.
 */
function getBip44EntropyImplementation({
  getMnemonicSeed,
  getUnlockPromise,
  getClientCryptography
}) {
  return async function getBip44Entropy(args) {
    await getUnlockPromise(true);
    // `args.params` is validated by the decorator, so it's safe to assert here.
    const params = args.params;
    const seed = await (0, utils_1.getValueFromEntropySource)(getMnemonicSeed, params.source);
    const node = await key_tree_1.BIP44CoinTypeNode.fromSeed({
      derivationPath: [seed, `bip32:44'`, `bip32:${params.coinType}'`],
      network: 'mainnet'
    }, getClientCryptography());
    return node.toJSON();
  };
}
exports.getBip44EntropyImplementation = getBip44EntropyImplementation;

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getBip44Entropy.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getEntropy.cjs", {"../utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\utils.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Crestricted%5CgetEntropy.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntropyBuilder = exports.GetEntropyArgsStruct = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const utils_2 = require("../utils.cjs");
const targetName = 'snap_getEntropy';
exports.GetEntropyArgsStruct = (0, superstruct_1.object)({
  version: (0, superstruct_1.literal)(1),
  salt: (0, superstruct_1.optional)((0, superstruct_1.string)()),
  source: (0, superstruct_1.optional)((0, superstruct_1.string)())
});
const specificationBuilder = ({
  allowedCaveats = null,
  methodHooks
}) => {
  return {
    permissionType: permission_controller_1.PermissionType.RestrictedMethod,
    targetName,
    allowedCaveats,
    methodImplementation: getEntropyImplementation(methodHooks),
    subjectTypes: [permission_controller_1.SubjectType.Snap]
  };
};
const methodHooks = {
  getMnemonicSeed: true,
  getUnlockPromise: true,
  getClientCryptography: true
};
exports.getEntropyBuilder = Object.freeze({
  targetName,
  specificationBuilder,
  methodHooks
});
/**
 * Builds the method implementation for `snap_getEntropy`. The implementation
 * is based on the reference implementation of
 * [SIP-6](https://metamask.github.io/SIPs/SIPS/sip-6).
 *
 * @param hooks - The RPC method hooks.
 * @param hooks.getMnemonicSeed - A function to retrieve the BIP-39 seed
 * of the user.
 * @param hooks.getUnlockPromise - The method to get a promise that resolves
 * once the extension is unlocked.
 * @param hooks.getClientCryptography - A function to retrieve the cryptographic
 * functions to use for the client.
 * @returns The method implementation.
 */
function getEntropyImplementation({
  getMnemonicSeed,
  getUnlockPromise,
  getClientCryptography
}) {
  return async function getEntropy(options) {
    const {
      params,
      context: {
        origin
      }
    } = options;
    (0, utils_1.assertStruct)(params, exports.GetEntropyArgsStruct, 'Invalid "snap_getEntropy" parameters', rpc_errors_1.rpcErrors.invalidParams);
    await getUnlockPromise(true);
    const seed = await (0, utils_2.getValueFromEntropySource)(getMnemonicSeed, params.source);
    return (0, utils_2.deriveEntropyFromSeed)({
      input: origin,
      salt: params.salt,
      seed,
      magic: snaps_utils_1.SIP_6_MAGIC_VALUE,
      cryptographicFunctions: getClientCryptography()
    });
  };
}

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getEntropy.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getLocale.cjs", {"@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Crestricted%5CgetLocale.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getImplementation = exports.getLocaleBuilder = exports.specificationBuilder = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const methodName = 'snap_getLocale';
/**
 * The specification builder for the `snap_getLocale` permission.
 * `snap_getLocale` allows snaps to get the user selected locale.
 *
 * @param options - The specification builder options.
 * @param options.allowedCaveats - The optional allowed caveats for the permission.
 * @param options.methodHooks - The RPC method hooks needed by the method implementation.
 * @returns The specification for the `snap_getLocale` permission.
 * @deprecated - To be removed in favor of `snap_getPreferences`.
 */
const specificationBuilder = ({
  allowedCaveats = null,
  methodHooks
}) => {
  return {
    permissionType: permission_controller_1.PermissionType.RestrictedMethod,
    targetName: methodName,
    allowedCaveats,
    methodImplementation: getImplementation(methodHooks),
    subjectTypes: [permission_controller_1.SubjectType.Snap]
  };
};
exports.specificationBuilder = specificationBuilder;
const methodHooks = {
  getPreferences: true
};
exports.getLocaleBuilder = Object.freeze({
  targetName: methodName,
  specificationBuilder: exports.specificationBuilder,
  methodHooks
});
/**
 * Builds the method implementation for `snap_getLocale`.
 *
 * @param hooks - The RPC method hooks.
 * @param hooks.getPreferences - A function that returns the user selected preferences.
 * @returns The user selected locale.
 */
function getImplementation({
  getPreferences
}) {
  return async function implementation(_args) {
    return getPreferences().locale;
  };
}
exports.getImplementation = getImplementation;

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getLocale.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getPreferences.cjs", {"@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Crestricted%5CgetPreferences.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getImplementation = exports.getPreferencesBuilder = exports.specificationBuilder = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const methodName = 'snap_getPreferences';
/**
 * The specification builder for the `snap_getPreferences` permission.
 * `snap_getPreferences` allows snaps to access user preferences.
 *
 * @param options - The specification builder options.
 * @param options.allowedCaveats - The optional allowed caveats for the permission.
 * @param options.methodHooks - The RPC method hooks needed by the method implementation.
 * @returns The specification for the `snap_getPreferences` permission.
 */
const specificationBuilder = ({
  allowedCaveats = null,
  methodHooks
}) => {
  return {
    permissionType: permission_controller_1.PermissionType.RestrictedMethod,
    targetName: methodName,
    allowedCaveats,
    methodImplementation: getImplementation(methodHooks),
    subjectTypes: [permission_controller_1.SubjectType.Snap]
  };
};
exports.specificationBuilder = specificationBuilder;
const methodHooks = {
  getPreferences: true
};
exports.getPreferencesBuilder = Object.freeze({
  targetName: methodName,
  specificationBuilder: exports.specificationBuilder,
  methodHooks
});
/**
 * Builds the method implementation for `snap_getPreferences`.
 *
 * @param hooks - The RPC method hooks.
 * @param hooks.getPreferences - A function that returns the user selected preferences.
 * @returns The user preferences.
 */
function getImplementation({
  getPreferences
}) {
  return async function implementation(_args) {
    return getPreferences();
  };
}
exports.getImplementation = getImplementation;

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getPreferences.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\index.cjs", {"./caveats/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\caveats\\index.cjs","./dialog.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\dialog.cjs","./getBip32Entropy.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getBip32Entropy.cjs","./getBip32PublicKey.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getBip32PublicKey.cjs","./getBip44Entropy.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getBip44Entropy.cjs","./getEntropy.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getEntropy.cjs","./getLocale.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getLocale.cjs","./getPreferences.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\getPreferences.cjs","./invokeSnap.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\invokeSnap.cjs","./manageAccounts.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\manageAccounts.cjs","./manageState.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\manageState.cjs","./notify.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\notify.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Crestricted%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DIALOG_APPROVAL_TYPES = exports.restrictedMethodPermissionBuilders = exports.getEncryptionEntropy = exports.WALLET_SNAP_PERMISSION_KEY = void 0;
const dialog_1 = require("./dialog.cjs");
const getBip32Entropy_1 = require("./getBip32Entropy.cjs");
const getBip32PublicKey_1 = require("./getBip32PublicKey.cjs");
const getBip44Entropy_1 = require("./getBip44Entropy.cjs");
const getEntropy_1 = require("./getEntropy.cjs");
const getLocale_1 = require("./getLocale.cjs");
const getPreferences_1 = require("./getPreferences.cjs");
const invokeSnap_1 = require("./invokeSnap.cjs");
const manageAccounts_1 = require("./manageAccounts.cjs");
const manageState_1 = require("./manageState.cjs");
const notify_1 = require("./notify.cjs");
var invokeSnap_2 = require("./invokeSnap.cjs");
Object.defineProperty(exports, "WALLET_SNAP_PERMISSION_KEY", {
  enumerable: true,
  get: function () {
    return invokeSnap_2.WALLET_SNAP_PERMISSION_KEY;
  }
});
var manageState_2 = require("./manageState.cjs");
Object.defineProperty(exports, "getEncryptionEntropy", {
  enumerable: true,
  get: function () {
    return manageState_2.getEncryptionEntropy;
  }
});
exports.restrictedMethodPermissionBuilders = {
  [dialog_1.dialogBuilder.targetName]: dialog_1.dialogBuilder,
  [getBip32Entropy_1.getBip32EntropyBuilder.targetName]: getBip32Entropy_1.getBip32EntropyBuilder,
  [getBip32PublicKey_1.getBip32PublicKeyBuilder.targetName]: getBip32PublicKey_1.getBip32PublicKeyBuilder,
  [getBip44Entropy_1.getBip44EntropyBuilder.targetName]: getBip44Entropy_1.getBip44EntropyBuilder,
  [getEntropy_1.getEntropyBuilder.targetName]: getEntropy_1.getEntropyBuilder,
  [invokeSnap_1.invokeSnapBuilder.targetName]: invokeSnap_1.invokeSnapBuilder,
  [manageState_1.manageStateBuilder.targetName]: manageState_1.manageStateBuilder,
  [notify_1.notifyBuilder.targetName]: notify_1.notifyBuilder,
  [manageAccounts_1.manageAccountsBuilder.targetName]: manageAccounts_1.manageAccountsBuilder,
  [getLocale_1.getLocaleBuilder.targetName]: getLocale_1.getLocaleBuilder,
  [getPreferences_1.getPreferencesBuilder.targetName]: getPreferences_1.getPreferencesBuilder
};
__exportStar(require("./caveats/index.cjs"), exports);
var dialog_2 = require("./dialog.cjs");
Object.defineProperty(exports, "DIALOG_APPROVAL_TYPES", {
  enumerable: true,
  get: function () {
    return dialog_2.DIALOG_APPROVAL_TYPES;
  }
});

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\invokeSnap.cjs", {"@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Crestricted%5CinvokeSnap.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInvokeSnapImplementation = exports.invokeSnapBuilder = exports.handleSnapInstall = exports.WALLET_SNAP_PERMISSION_KEY = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_utils_1 = require("@metamask/snaps-utils");
exports.WALLET_SNAP_PERMISSION_KEY = 'wallet_snap';
/**
 * The side-effect method to handle the snap install.
 *
 * @param params - The side-effect params.
 * @param params.requestData - The request data associated to the requested permission.
 * @param params.messagingSystem - The messenger to call an action.
 * @returns The result of the Snap installation.
 */
const handleSnapInstall = async ({
  requestData,
  messagingSystem
}) => {
  var _requestData$permissi;
  const snaps = (_requestData$permissi = requestData.permissions[exports.WALLET_SNAP_PERMISSION_KEY].caveats) === null || _requestData$permissi === void 0 ? void 0 : _requestData$permissi[0].value;
  const permittedSnaps = messagingSystem.call(`SnapController:getPermitted`, requestData.metadata.origin);
  const dedupedSnaps = Object.keys(snaps).reduce((filteredSnaps, snap) => {
    if (!permittedSnaps[snap]) {
      filteredSnaps[snap] = snaps[snap];
    }
    return filteredSnaps;
  }, {});
  return messagingSystem.call(`SnapController:install`, requestData.metadata.origin, dedupedSnaps);
};
exports.handleSnapInstall = handleSnapInstall;
/**
 * The specification builder for the `wallet_snap_*` permission.
 *
 * `wallet_snap_*` attempts to invoke an RPC method of the specified Snap.
 *
 * Requesting its corresponding permission will attempt to connect to the Snap,
 * and install it if it's not available yet.
 *
 * @param options - The specification builder options.
 * @param options.methodHooks - The RPC method hooks needed by the method implementation.
 * @returns The specification for the `wallet_snap_*` permission.
 */
const specificationBuilder = ({
  methodHooks
}) => {
  return {
    permissionType: permission_controller_1.PermissionType.RestrictedMethod,
    targetName: exports.WALLET_SNAP_PERMISSION_KEY,
    allowedCaveats: [snaps_utils_1.SnapCaveatType.SnapIds],
    methodImplementation: getInvokeSnapImplementation(methodHooks),
    validator: ({
      caveats
    }) => {
      if ((caveats === null || caveats === void 0 ? void 0 : caveats.length) !== 1 || caveats[0].type !== snaps_utils_1.SnapCaveatType.SnapIds) {
        throw rpc_errors_1.rpcErrors.invalidParams({
          message: `Expected a single "${snaps_utils_1.SnapCaveatType.SnapIds}" caveat.`
        });
      }
    },
    sideEffect: {
      onPermitted: exports.handleSnapInstall
    }
  };
};
const methodHooks = {
  getSnap: true,
  handleSnapRpcRequest: true
};
exports.invokeSnapBuilder = Object.freeze({
  targetName: exports.WALLET_SNAP_PERMISSION_KEY,
  specificationBuilder,
  methodHooks
});
/**
 * Builds the method implementation for `wallet_snap_*`.
 *
 * @param hooks - The RPC method hooks.
 * @param hooks.getSnap - A function that retrieves all information stored about a snap.
 * @param hooks.handleSnapRpcRequest - A function that sends an RPC request to a snap's RPC handler or throws if that fails.
 * @returns The method implementation which returns the result of `handleSnapRpcRequest`.
 * @throws If the params are invalid.
 */
function getInvokeSnapImplementation({
  getSnap,
  handleSnapRpcRequest
}) {
  return async function invokeSnap(options) {
    const {
      params = {},
      context
    } = options;
    const {
      snapId,
      request
    } = params;
    if (!getSnap(snapId)) {
      throw rpc_errors_1.rpcErrors.invalidRequest({
        message: `The snap "${snapId}" is not installed. Please install it first, before invoking the snap.`
      });
    }
    const {
      origin
    } = context;
    return await handleSnapRpcRequest({
      snapId,
      origin,
      request,
      handler: snaps_utils_1.HandlerType.OnRpcRequest
    });
  };
}
exports.getInvokeSnapImplementation = getInvokeSnapImplementation;

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\invokeSnap.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\manageAccounts.cjs", {"@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Crestricted%5CmanageAccounts.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.manageAccountsBuilder = exports.manageAccountsImplementation = exports.specificationBuilder = exports.methodName = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const SnapMessageStruct = (0, superstruct_1.union)([(0, superstruct_1.object)({
  method: (0, superstruct_1.string)()
}), (0, superstruct_1.object)({
  method: (0, superstruct_1.string)(),
  params: (0, superstruct_1.union)([(0, superstruct_1.array)(utils_1.JsonStruct), (0, superstruct_1.record)((0, superstruct_1.string)(), utils_1.JsonStruct)])
})]);
exports.methodName = 'snap_manageAccounts';
/**
 * The specification builder for the `snap_manageAccounts` permission.
 * `snap_manageAccounts` lets the Snap manage a set of accounts via a custom keyring.
 *
 * @param options - The specification builder options.
 * @param options.allowedCaveats - The optional allowed caveats for the permission.
 * @param options.methodHooks - The RPC method hooks needed by the method implementation.
 * @returns The specification for the `snap_manageAccounts` permission.
 */
const specificationBuilder = ({
  allowedCaveats = null,
  methodHooks
}) => {
  return {
    permissionType: permission_controller_1.PermissionType.RestrictedMethod,
    targetName: exports.methodName,
    allowedCaveats,
    methodImplementation: manageAccountsImplementation(methodHooks),
    subjectTypes: [permission_controller_1.SubjectType.Snap]
  };
};
exports.specificationBuilder = specificationBuilder;
/**
 * Builds the method implementation for `snap_manageAccounts`.
 *
 * @param hooks - The RPC method hooks.
 * @param hooks.getSnapKeyring - A function to get the snap keyring.
 * @returns The method implementation which either returns `null` for a
 * successful state update/deletion or returns the decrypted state.
 * @throws If the params are invalid.
 */
function manageAccountsImplementation({
  getSnapKeyring
}) {
  return async function manageAccounts(options) {
    const {
      context: {
        origin
      },
      params
    } = options;
    (0, superstruct_1.assert)(params, SnapMessageStruct);
    const keyring = await getSnapKeyring(origin);
    return await keyring.handleKeyringSnapMessage(origin, params);
  };
}
exports.manageAccountsImplementation = manageAccountsImplementation;
exports.manageAccountsBuilder = Object.freeze({
  targetName: exports.methodName,
  specificationBuilder: exports.specificationBuilder,
  methodHooks: {
    getSnapKeyring: true
  }
});

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\manageAccounts.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\manageState.cjs", {"../utils.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\utils.cjs","@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-sdk":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Crestricted%5CmanageState.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValidatedParams = exports.getManageStateImplementation = exports.getEncryptionEntropy = exports.STORAGE_SIZE_LIMIT = exports.manageStateBuilder = exports.specificationBuilder = exports.STATE_ENCRYPTION_SALT = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_sdk_1 = require("@metamask/snaps-sdk");
const snaps_utils_1 = require("@metamask/snaps-utils");
const utils_1 = require("@metamask/utils");
const utils_2 = require("../utils.cjs");
// The salt used for SIP-6-based entropy derivation.
exports.STATE_ENCRYPTION_SALT = 'snap_manageState encryption';
const methodName = 'snap_manageState';
/**
 * The specification builder for the `snap_manageState` permission.
 * `snap_manageState` lets the Snap store and manage some of its state on
 * your device.
 *
 * @param options - The specification builder options.
 * @param options.allowedCaveats - The optional allowed caveats for the permission.
 * @param options.methodHooks - The RPC method hooks needed by the method implementation.
 * @returns The specification for the `snap_manageState` permission.
 */
const specificationBuilder = ({
  allowedCaveats = null,
  methodHooks
}) => {
  return {
    permissionType: permission_controller_1.PermissionType.RestrictedMethod,
    targetName: methodName,
    allowedCaveats,
    methodImplementation: getManageStateImplementation(methodHooks),
    subjectTypes: [permission_controller_1.SubjectType.Snap]
  };
};
exports.specificationBuilder = specificationBuilder;
const methodHooks = {
  getUnlockPromise: true,
  clearSnapState: true,
  getSnapState: true,
  updateSnapState: true,
  getSnap: true
};
exports.manageStateBuilder = Object.freeze({
  targetName: methodName,
  specificationBuilder: exports.specificationBuilder,
  methodHooks
});
exports.STORAGE_SIZE_LIMIT = 64000000; // In bytes (64 MB)
/**
 * Get a deterministic encryption key to use for encrypting and decrypting the
 * state.
 *
 * This key should only be used for state encryption using `snap_manageState`.
 * To get other encryption keys, a different salt can be used.
 *
 * @param args - The encryption key args.
 * @param args.snapId - The ID of the snap to get the encryption key for.
 * @param args.seed - The mnemonic seed to derive the encryption key
 * from.
 * @param args.cryptographicFunctions - The cryptographic functions to use for
 * the client.
 * @returns The state encryption key.
 */
async function getEncryptionEntropy({
  seed,
  snapId,
  cryptographicFunctions
}) {
  return await (0, utils_2.deriveEntropyFromSeed)({
    seed,
    input: snapId,
    salt: exports.STATE_ENCRYPTION_SALT,
    magic: snaps_utils_1.STATE_ENCRYPTION_MAGIC_VALUE,
    cryptographicFunctions
  });
}
exports.getEncryptionEntropy = getEncryptionEntropy;
/**
 * Builds the method implementation for `snap_manageState`.
 *
 * @param hooks - The RPC method hooks.
 * @param hooks.clearSnapState - A function that clears the state stored for a
 * snap.
 * @param hooks.getSnapState - A function that fetches the persisted decrypted
 * state for a snap.
 * @param hooks.updateSnapState - A function that updates the state stored for a
 * snap.
 * @param hooks.getUnlockPromise - A function that resolves once the MetaMask
 * extension is unlocked and prompts the user to unlock their MetaMask if it is
 * locked.
 * @param hooks.getSnap - The hook function to get Snap metadata.
 * @returns The method implementation which either returns `null` for a
 * successful state update/deletion or returns the decrypted state.
 * @throws If the params are invalid.
 */
function getManageStateImplementation({
  getUnlockPromise,
  clearSnapState,
  getSnapState,
  updateSnapState,
  getSnap
}) {
  return async function manageState(options) {
    const {
      params = {},
      method,
      context: {
        origin
      }
    } = options;
    const validatedParams = getValidatedParams(params, method);
    const snap = getSnap(origin);
    if (!(snap !== null && snap !== void 0 && snap.preinstalled) && validatedParams.operation === snaps_sdk_1.ManageStateOperation.UpdateState) {
      const size = (0, snaps_utils_1.getJsonSizeUnsafe)(validatedParams.newState, true);
      if (size > exports.STORAGE_SIZE_LIMIT) {
        throw rpc_errors_1.rpcErrors.invalidParams({
          message: `Invalid ${method} "newState" parameter: The new state must not exceed ${exports.STORAGE_SIZE_LIMIT / 1000000} MB in size.`
        });
      }
    }
    // If the encrypted param is undefined or null we default to true.
    const shouldEncrypt = validatedParams.encrypted ?? true;
    // We only need to prompt the user when the mnemonic is needed
    // which it isn't for the clear operation or unencrypted storage.
    if (shouldEncrypt && validatedParams.operation !== snaps_sdk_1.ManageStateOperation.ClearState) {
      await getUnlockPromise(true);
    }
    switch (validatedParams.operation) {
      case snaps_sdk_1.ManageStateOperation.ClearState:
        clearSnapState(origin, shouldEncrypt);
        return null;
      case snaps_sdk_1.ManageStateOperation.GetState:
        {
          return await getSnapState(origin, shouldEncrypt);
        }
      case snaps_sdk_1.ManageStateOperation.UpdateState:
        {
          await updateSnapState(origin, validatedParams.newState, shouldEncrypt);
          return null;
        }
      /* istanbul ignore next */
      default:
        throw rpc_errors_1.rpcErrors.invalidParams(`Invalid ${method} operation: "${validatedParams.operation}"`);
    }
  };
}
exports.getManageStateImplementation = getManageStateImplementation;
/**
 * Validates the manageState method `params` and returns them cast to the correct
 * type. Throws if validation fails.
 *
 * @param params - The unvalidated params object from the method request.
 * @param method - RPC method name used for debugging errors.
 * @returns The validated method parameter object.
 */
function getValidatedParams(params, method) {
  if (!(0, utils_1.isObject)(params)) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Expected params to be a single object.'
    });
  }
  const {
    operation,
    newState,
    encrypted
  } = params;
  if (!operation || typeof operation !== 'string' || !Object.values(snaps_sdk_1.ManageStateOperation).includes(operation)) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Must specify a valid manage state "operation".'
    });
  }
  if (encrypted !== undefined && typeof encrypted !== 'boolean') {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: '"encrypted" parameter must be a boolean if specified.'
    });
  }
  if (operation === snaps_sdk_1.ManageStateOperation.UpdateState) {
    if (!(0, utils_1.isObject)(newState)) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Invalid ${method} "newState" parameter: The new state must be a plain object.`
      });
    }
    if (!(0, utils_1.isValidJson)(newState)) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: `Invalid ${method} "newState" parameter: The new state must be JSON serializable.`
      });
    }
  }
  return params;
}
exports.getValidatedParams = getValidatedParams;

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\manageState.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\notify.cjs", {"@metamask/permission-controller":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\permission-controller\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/snaps-sdk":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\index.cjs","@metamask/snaps-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-utils\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Crestricted%5Cnotify.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValidatedParams = exports.getImplementation = exports.notifyBuilder = exports.specificationBuilder = void 0;
const permission_controller_1 = require("@metamask/permission-controller");
const rpc_errors_1 = require("@metamask/rpc-errors");
const snaps_sdk_1 = require("@metamask/snaps-sdk");
const snaps_utils_1 = require("@metamask/snaps-utils");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const methodName = 'snap_notify';
const NativeNotificationStruct = (0, superstruct_1.object)({
  type: (0, snaps_sdk_1.enumValue)(snaps_sdk_1.NotificationType.Native),
  message: (0, superstruct_1.string)()
});
const InAppNotificationStruct = (0, superstruct_1.object)({
  type: (0, snaps_sdk_1.enumValue)(snaps_sdk_1.NotificationType.InApp),
  message: (0, superstruct_1.string)()
});
const InAppNotificationWithDetailsStruct = (0, superstruct_1.object)({
  type: (0, snaps_sdk_1.enumValue)(snaps_sdk_1.NotificationType.InApp),
  message: (0, superstruct_1.string)(),
  content: snaps_sdk_1.ComponentOrElementStruct,
  title: (0, superstruct_1.string)(),
  footerLink: (0, superstruct_1.optional)((0, superstruct_1.object)({
    href: (0, superstruct_1.string)(),
    text: (0, superstruct_1.string)()
  }))
});
const NotificationParametersStruct = (0, snaps_sdk_1.union)([InAppNotificationStruct, InAppNotificationWithDetailsStruct, NativeNotificationStruct]);
/**
 * The specification builder for the `snap_notify` permission.
 * `snap_notify` allows snaps to send multiple types of notifications to its users.
 *
 * @param options - The specification builder options.
 * @param options.allowedCaveats - The optional allowed caveats for the permission.
 * @param options.methodHooks - The RPC method hooks needed by the method implementation.
 * @returns The specification for the `snap_notify` permission.
 */
const specificationBuilder = ({
  allowedCaveats = null,
  methodHooks
}) => {
  return {
    permissionType: permission_controller_1.PermissionType.RestrictedMethod,
    targetName: methodName,
    allowedCaveats,
    methodImplementation: getImplementation(methodHooks),
    subjectTypes: [permission_controller_1.SubjectType.Snap]
  };
};
exports.specificationBuilder = specificationBuilder;
const methodHooks = {
  showNativeNotification: true,
  showInAppNotification: true,
  isOnPhishingList: true,
  maybeUpdatePhishingList: true,
  createInterface: true,
  getSnap: true
};
exports.notifyBuilder = Object.freeze({
  targetName: methodName,
  specificationBuilder: exports.specificationBuilder,
  methodHooks
});
/**
 * Builds the method implementation for `snap_notify`.
 *
 * @param hooks - The RPC method hooks.
 * @param hooks.showNativeNotification - A function that shows a native browser notification.
 * @param hooks.showInAppNotification - A function that shows a notification in the MetaMask UI.
 * @param hooks.isOnPhishingList - A function that checks for links against the phishing list.
 * @param hooks.maybeUpdatePhishingList - A function that updates the phishing list if needed.
 * @param hooks.createInterface - A function that creates the interface in SnapInterfaceController.
 * @param hooks.getSnap - A function that checks if a snap is installed.
 * @returns The method implementation which returns `null` on success.
 * @throws If the params are invalid.
 */
function getImplementation({
  showNativeNotification,
  showInAppNotification,
  isOnPhishingList,
  maybeUpdatePhishingList,
  createInterface,
  getSnap
}) {
  return async function implementation(args) {
    const {
      params,
      context: {
        origin
      }
    } = args;
    await maybeUpdatePhishingList();
    const validatedParams = getValidatedParams(params, isOnPhishingList, getSnap);
    if ((0, utils_1.hasProperty)(validatedParams, 'content')) {
      const id = await createInterface(origin, validatedParams.content, undefined, snaps_sdk_1.ContentType.Notification);
      validatedParams.content = id;
    }
    switch (validatedParams.type) {
      case snaps_sdk_1.NotificationType.Native:
        return await showNativeNotification(origin, validatedParams);
      case snaps_sdk_1.NotificationType.InApp:
        return await showInAppNotification(origin, validatedParams);
      default:
        throw rpc_errors_1.rpcErrors.invalidParams({
          message: 'Must specify a valid notification "type".'
        });
    }
  };
}
exports.getImplementation = getImplementation;
/**
 * Validates the notify method `params` and returns them cast to the correct
 * type. Throws if validation fails.
 *
 * @param params - The unvalidated params object from the method request.
 * @param isOnPhishingList - The function that checks for links against the phishing list.
 * @param getSnap - A function that checks if a snap is installed.
 * @returns The validated method parameter object.
 * @throws If the params are invalid.
 */
function getValidatedParams(params, isOnPhishingList, getSnap) {
  if (!(0, utils_1.isObject)(params)) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Expected params to be a single object.'
    });
  }
  const {
    type,
    message
  } = params;
  if (!type || typeof type !== 'string' || !Object.values(snaps_sdk_1.NotificationType).includes(type)) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Must specify a valid notification "type".'
    });
  }
  const isNotString = !message || typeof message !== 'string';
  // Set to the max message length on a Mac notification for now.
  if (type === snaps_sdk_1.NotificationType.Native && (isNotString || message.length >= 50)) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Must specify a non-empty string "message" less than 50 characters long.'
    });
  }
  if (type === snaps_sdk_1.NotificationType.InApp && (isNotString || message.length >= 500)) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: 'Must specify a non-empty string "message" less than 500 characters long.'
    });
  }
  try {
    const validatedParams = (0, snaps_utils_1.createUnion)(params, NotificationParametersStruct, 'type');
    (0, snaps_utils_1.validateTextLinks)(validatedParams.message, isOnPhishingList, getSnap);
    if ((0, utils_1.hasProperty)(validatedParams, 'footerLink')) {
      (0, snaps_utils_1.validateLink)(validatedParams.footerLink.href, isOnPhishingList, getSnap);
    }
    return validatedParams;
  } catch (error) {
    throw rpc_errors_1.rpcErrors.invalidParams({
      message: `Invalid params: ${(0, snaps_sdk_1.getErrorMessage)(error)}`
    });
  }
}
exports.getValidatedParams = getValidatedParams;

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\restricted\\notify.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-rpc-methods\\dist\\utils.cjs", {"@metamask/key-tree":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\key-tree\\dist\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","@noble/hashes/sha3":"D:\\code\\v\\metamask-extension\\node_modules\\@noble\\hashes\\sha3.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-rpc-methods%5Cdist%5Cutils.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValueFromEntropySource = exports.StateKeyStruct = exports.isValidStateKey = exports.getNodeFromSeed = exports.getNodeFromMnemonic = exports.getPathPrefix = exports.deriveEntropyFromSeed = exports.selectHooks = exports.FORBIDDEN_KEYS = void 0;
const key_tree_1 = require("@metamask/key-tree");
const rpc_errors_1 = require("@metamask/rpc-errors");
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const sha3_1 = require("@noble/hashes/sha3");
const HARDENED_VALUE = 0x80000000;
exports.FORBIDDEN_KEYS = ['constructor', '__proto__', 'prototype'];
/**
 * Returns the subset of the specified `hooks` that are included in the
 * `hookNames` object. This is a Principle of Least Authority (POLA) measure
 * to ensure that each RPC method implementation only has access to the
 * API "hooks" it needs to do its job.
 *
 * @param hooks - The hooks to select from.
 * @param hookNames - The names of the hooks to select.
 * @returns The selected hooks.
 * @template Hooks - The hooks to select from.
 * @template HookName - The names of the hooks to select.
 */
function selectHooks(hooks, hookNames) {
  if (hookNames) {
    return Object.keys(hookNames).reduce((hookSubset, _hookName) => {
      const hookName = _hookName;
      hookSubset[hookName] = hooks[hookName];
      return hookSubset;
    }, {});
  }
  return undefined;
}
exports.selectHooks = selectHooks;
/**
 * Get a BIP-32 derivation path array from a hash, which is compatible with
 * `@metamask/key-tree`. The hash is assumed to be 32 bytes long.
 *
 * @param hash - The hash to derive indices from.
 * @returns The derived indices as a {@link HardenedBIP32Node} array.
 */
function getDerivationPathArray(hash) {
  const array = [];
  const view = (0, utils_1.createDataView)(hash);
  for (let index = 0; index < 8; index++) {
    const uint32 = view.getUint32(index * 4);
    // This is essentially `index | 0x80000000`. Because JavaScript numbers are
    // signed, we use the bitwise unsigned right shift operator to ensure that
    // the result is a positive number.
    // eslint-disable-next-line no-bitwise
    const pathIndex = (uint32 | HARDENED_VALUE) >>> 0;
    array.push(`bip32:${pathIndex - HARDENED_VALUE}'`);
  }
  return array;
}
/**
 * Get the derivation path to use for entropy derivation.
 *
 * This is based on the reference implementation of
 * [SIP-6](https://metamask.github.io/SIPs/SIPS/sip-6).
 *
 * @param options - The options for entropy derivation.
 * @param options.input - The input value to derive entropy from.
 * @param options.salt - An optional salt to use when deriving entropy.
 * @param options.magic - A hardened BIP-32 index, which is used to derive the
 * root key from the mnemonic phrase.
 * @returns The derivation path to be used for entropy key derivation.
 */
function getEntropyDerivationPath({
  input,
  salt,
  magic
}) {
  const inputBytes = (0, utils_1.stringToBytes)(input);
  const saltBytes = (0, utils_1.stringToBytes)(salt);
  // Get the derivation path from the snap ID.
  const hash = (0, sha3_1.keccak_256)((0, utils_1.concatBytes)([inputBytes, (0, sha3_1.keccak_256)(saltBytes)]));
  const computedDerivationPath = getDerivationPathArray(hash);
  return [`bip32:${magic}`, ...computedDerivationPath];
}
/**
 * Derive entropy from the given mnemonic seed and salt.
 *
 * This is based on the reference implementation of
 * [SIP-6](https://metamask.github.io/SIPs/SIPS/sip-6).
 *
 * @param options - The options for entropy derivation.
 * @param options.input - The input value to derive entropy from.
 * @param options.salt - An optional salt to use when deriving entropy.
 * @param options.seed - The mnemonic seed to use for entropy
 * derivation.
 * @param options.magic - A hardened BIP-32 index, which is used to derive the
 * root key from the mnemonic phrase.
 * @param options.cryptographicFunctions - The cryptographic functions to use
 * for the derivation.
 * @returns The derived entropy.
 */
async function deriveEntropyFromSeed({
  input,
  salt = '',
  seed,
  magic,
  cryptographicFunctions
}) {
  const computedDerivationPath = getEntropyDerivationPath({
    input,
    salt,
    magic
  });
  // Derive the private key using BIP-32.
  const {
    privateKey
  } = await key_tree_1.SLIP10Node.fromSeed({
    derivationPath: [seed, ...computedDerivationPath],
    curve: 'secp256k1'
  }, cryptographicFunctions);
  // This should never happen, but this keeps TypeScript happy.
  (0, utils_1.assert)(privateKey, 'Failed to derive the entropy.');
  return (0, utils_1.add0x)(privateKey);
}
exports.deriveEntropyFromSeed = deriveEntropyFromSeed;
/**
 * Get the path prefix to use for key derivation in `key-tree`. This assumes the
 * following:
 *
 * - The Secp256k1 curve always uses the BIP-32 specification.
 * - The Ed25519 curve always uses the SLIP-10 specification.
 * - The BIP-32-Ed25519 curve always uses the CIP-3 specification.
 *
 * While this does not matter in most situations (no known case at the time of
 * writing), `key-tree` requires a specific specification to be used.
 *
 * @param curve - The curve to get the path prefix for. The curve is NOT
 * validated by this function.
 * @returns The path prefix, i.e., `bip32` or `slip10`.
 */
function getPathPrefix(curve) {
  switch (curve) {
    case 'secp256k1':
      return 'bip32';
    case 'ed25519':
      return 'slip10';
    case 'ed25519Bip32':
      return 'cip3';
    default:
      return (0, utils_1.assertExhaustive)(curve);
  }
}
exports.getPathPrefix = getPathPrefix;
/**
 * Get a `key-tree`-compatible node.
 *
 * Note: This function assumes that all the parameters have been validated
 * beforehand.
 *
 * @param options - The derivation options.
 * @param options.curve - The curve to use for derivation.
 * @param options.secretRecoveryPhrase - The secret recovery phrase to use for
 * derivation.
 * @param options.path - The derivation path to use as array, starting with an
 * "m" as the first item.
 * @param options.cryptographicFunctions - The cryptographic functions to use
 * for the node.
 * @returns The `key-tree` SLIP-10 node.
 */
async function getNodeFromMnemonic({
  curve,
  secretRecoveryPhrase,
  path,
  cryptographicFunctions
}) {
  const prefix = getPathPrefix(curve);
  return await key_tree_1.SLIP10Node.fromDerivationPath({
    curve,
    derivationPath: [secretRecoveryPhrase, ...path.slice(1).map(index => `${prefix}:${index}`)]
  }, cryptographicFunctions);
}
exports.getNodeFromMnemonic = getNodeFromMnemonic;
/**
 * Get a `key-tree`-compatible node.
 *
 * Note: This function assumes that all the parameters have been validated
 * beforehand.
 *
 * @param options - The derivation options.
 * @param options.curve - The curve to use for derivation.
 * @param options.seed - The BIP-39 to use for
 * derivation.
 * @param options.path - The derivation path to use as array, starting with an
 * "m" as the first item.
 * @param options.cryptographicFunctions - The cryptographic functions to use
 * for the node.
 * @returns The `key-tree` SLIP-10 node.
 */
async function getNodeFromSeed({
  curve,
  seed,
  path,
  cryptographicFunctions
}) {
  const prefix = getPathPrefix(curve);
  return await key_tree_1.SLIP10Node.fromSeed({
    curve,
    derivationPath: [seed, ...path.slice(1).map(index => `${prefix}:${index}`)]
  }, cryptographicFunctions);
}
exports.getNodeFromSeed = getNodeFromSeed;
/**
 * Validate the key of a state object.
 *
 * @param key - The key to validate.
 * @returns `true` if the key is valid, `false` otherwise.
 */
function isValidStateKey(key) {
  if (key === undefined) {
    return true;
  }
  return key.split('.').every(part => part.length > 0);
}
exports.isValidStateKey = isValidStateKey;
exports.StateKeyStruct = (0, superstruct_1.refine)((0, superstruct_1.string)(), 'state key', value => {
  if (!isValidStateKey(value)) {
    return 'Invalid state key. Each part of the key must be non-empty.';
  }
  return true;
});
/**
 * Get a value using the entropy source hooks: getMnemonic or getMnemonicSeed.
 * This function calls the passed hook and handles any errors that occur,
 * throwing formatted JSON-RPC errors.
 *
 * @param hook - The hook.
 * @param source - The entropy source to use.
 * @returns The secret recovery phrase.
 */
async function getValueFromEntropySource(hook, source) {
  try {
    return await hook(source);
  } catch (error) {
    if (error instanceof Error) {
      throw rpc_errors_1.rpcErrors.invalidParams({
        message: error.message
      });
    }
    throw rpc_errors_1.rpcErrors.internal({
      message: 'An unknown error occurred.',
      data: {
        error: error.toString()
      }
    });
  }
}
exports.getValueFromEntropySource = getValueFromEntropySource;

      };
    };
  }
  }
}, {package:"@metamask/snaps-rpc-methods",file:"node_modules\\@metamask\\snaps-rpc-methods\\dist\\utils.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\error-wrappers.cjs", {"./internals/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\internals\\index.cjs","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cerror-wrappers.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserRejectedRequestError = exports.UnsupportedMethodError = exports.UnauthorizedError = exports.DisconnectedError = exports.ChainDisconnectedError = exports.TransactionRejected = exports.ResourceUnavailableError = exports.ResourceNotFoundError = exports.ParseError = exports.MethodNotSupportedError = exports.MethodNotFoundError = exports.LimitExceededError = exports.InvalidRequestError = exports.InvalidParamsError = exports.InvalidInputError = exports.InternalError = void 0;
const rpc_errors_1 = require("@metamask/rpc-errors");
const internals_1 = require("./internals/index.cjs");
/**
 * A JSON-RPC 2.0 Internal (-32603) error.
 *
 * This can be thrown by a Snap to indicate that an internal error occurred,
 * without crashing the Snap.
 *
 * @see https://www.jsonrpc.org/specification#error_object
 */
exports.InternalError = (0, internals_1.createSnapError)(rpc_errors_1.rpcErrors.internal);
/**
 * An Ethereum JSON-RPC Invalid Input (-32000) error.
 *
 * This can be thrown by a Snap to indicate that the input to a method is
 * invalid, without crashing the Snap.
 *
 * @see https://eips.ethereum.org/EIPS/eip-1474#error-codes
 */
exports.InvalidInputError = (0, internals_1.createSnapError)(rpc_errors_1.rpcErrors.invalidInput);
/**
 * A JSON-RPC 2.0 Invalid Params (-32602) error.
 *
 * This can be thrown by a Snap to indicate that the parameters to a method are
 * invalid, without crashing the Snap.
 *
 * @see https://www.jsonrpc.org/specification#error_object
 */
exports.InvalidParamsError = (0, internals_1.createSnapError)(rpc_errors_1.rpcErrors.invalidParams);
/**
 * A JSON-RPC 2.0 Invalid Request (-32600) error.
 *
 * This can be thrown by a Snap to indicate that the request is invalid, without
 * crashing the Snap.
 *
 * @see https://www.jsonrpc.org/specification#error_object
 */
exports.InvalidRequestError = (0, internals_1.createSnapError)(rpc_errors_1.rpcErrors.invalidRequest);
/**
 * An Ethereum JSON-RPC Limit Exceeded (-32005) error.
 *
 * This can be thrown by a Snap to indicate that a limit has been exceeded,
 * without crashing the Snap.
 *
 * @see https://eips.ethereum.org/EIPS/eip-1474#error-codes
 */
exports.LimitExceededError = (0, internals_1.createSnapError)(rpc_errors_1.rpcErrors.limitExceeded);
/**
 * An Ethereum JSON-RPC Method Not Found (-32601) error.
 *
 * This can be thrown by a Snap to indicate that a method does not exist,
 * without crashing the Snap.
 *
 * @see https://eips.ethereum.org/EIPS/eip-1474#error-codes
 */
exports.MethodNotFoundError = (0, internals_1.createSnapError)(rpc_errors_1.rpcErrors.methodNotFound);
/**
 * An Ethereum JSON-RPC Method Not Supported (-32004) error.
 *
 * This can be thrown by a Snap to indicate that a method is not supported,
 * without crashing the Snap.
 */
exports.MethodNotSupportedError = (0, internals_1.createSnapError)(rpc_errors_1.rpcErrors.methodNotSupported);
/**
 * A JSON-RPC 2.0 Parse (-32700) error.
 *
 * This can be thrown by a Snap to indicate that a request is not valid JSON,
 * without crashing the Snap.
 *
 * @see https://www.jsonrpc.org/specification#error_object
 */
exports.ParseError = (0, internals_1.createSnapError)(rpc_errors_1.rpcErrors.parse);
/**
 * An Ethereum JSON-RPC Resource Not Found (-32001) error.
 *
 * This can be thrown by a Snap to indicate that a resource does not exist,
 * without crashing the Snap.
 *
 * @see https://eips.ethereum.org/EIPS/eip-1474#error-codes
 */
exports.ResourceNotFoundError = (0, internals_1.createSnapError)(rpc_errors_1.rpcErrors.resourceNotFound);
/**
 * An Ethereum JSON-RPC Resource Unavailable (-32002) error.
 *
 * This can be thrown by a Snap to indicate that a resource is unavailable,
 * without crashing the Snap.
 *
 * @see https://eips.ethereum.org/EIPS/eip-1474#error-codes
 */
exports.ResourceUnavailableError = (0, internals_1.createSnapError)(rpc_errors_1.rpcErrors.resourceUnavailable);
/**
 * An Ethereum JSON-RPC Transaction Rejected (-32003) error.
 *
 * This can be thrown by a Snap to indicate that a transaction was rejected,
 * without crashing the Snap.
 *
 * @see https://eips.ethereum.org/EIPS/eip-1474#error-codes
 */
exports.TransactionRejected = (0, internals_1.createSnapError)(rpc_errors_1.rpcErrors.transactionRejected);
/**
 * An Ethereum Provider Chain Disconnected (4901) error.
 *
 * This can be thrown by a Snap to indicate that the provider is disconnected
 * from the requested chain, without crashing the Snap.
 *
 * @see https://eips.ethereum.org/EIPS/eip-1193#provider-errors
 */
exports.ChainDisconnectedError = (0, internals_1.createSnapError)(rpc_errors_1.providerErrors.chainDisconnected);
/**
 * An Ethereum Provider Disconnected (4900) error.
 *
 * This can be thrown by a Snap to indicate that the provider is disconnected,
 * without crashing the Snap.
 *
 * @see https://eips.ethereum.org/EIPS/eip-1193#provider-errors
 */
exports.DisconnectedError = (0, internals_1.createSnapError)(rpc_errors_1.providerErrors.disconnected);
/**
 * An Ethereum Provider Unauthorized (4100) error.
 *
 * This can be thrown by a Snap to indicate that the requested method / account
 * is not authorized by the user, without crashing the Snap.
 */
exports.UnauthorizedError = (0, internals_1.createSnapError)(rpc_errors_1.providerErrors.unauthorized);
/**
 * An Ethereum Provider Unsupported Method (4200) error.
 *
 * This can be thrown by a Snap to indicate that the requested method is not
 * supported by the provider, without crashing the Snap.
 *
 * @see https://eips.ethereum.org/EIPS/eip-1193#provider-errors
 */
exports.UnsupportedMethodError = (0, internals_1.createSnapError)(rpc_errors_1.providerErrors.unsupportedMethod);
/**
 * An Ethereum Provider User Rejected Request (4001) error.
 *
 * This can be thrown by a Snap to indicate that the user rejected the request,
 * without crashing the Snap.
 *
 * @see https://eips.ethereum.org/EIPS/eip-1193#provider-errors
 */
exports.UserRejectedRequestError = (0, internals_1.createSnapError)(rpc_errors_1.providerErrors.userRejectedRequest);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\error-wrappers.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\errors.cjs", {"./internals/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\internals\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cerrors.cjs
      return function (require, module, exports) {
"use strict";

function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getJsonError = exports.SnapError = void 0;
const utils_1 = require("@metamask/utils");
const internals_1 = require("./internals/index.cjs");
/**
 * A generic error which can be thrown by a Snap, without it causing the Snap to
 * crash.
 */
var _code = /*#__PURE__*/new WeakMap();
var _message = /*#__PURE__*/new WeakMap();
var _data = /*#__PURE__*/new WeakMap();
var _stack = /*#__PURE__*/new WeakMap();
class SnapError extends Error {
  /**
   * Create a new `SnapError`.
   *
   * @param error - The error to create the `SnapError` from. If this is a
   * `string`, it will be used as the error message. If this is an `Error`, its
   * `message` property will be used as the error message. If this is a
   * `JsonRpcError`, its `message` property will be used as the error message
   * and its `code` property will be used as the error code. Otherwise, the
   * error will be converted to a string and used as the error message.
   * @param data - Additional data to include in the error. This will be merged
   * with the error data, if any.
   */
  constructor(error, data = {}) {
    const message = (0, internals_1.getErrorMessage)(error);
    super(message);
    _classPrivateFieldInitSpec(this, _code, void 0);
    _classPrivateFieldInitSpec(this, _message, void 0);
    _classPrivateFieldInitSpec(this, _data, void 0);
    _classPrivateFieldInitSpec(this, _stack, void 0);
    _classPrivateFieldSet(_message, this, message);
    _classPrivateFieldSet(_code, this, (0, internals_1.getErrorCode)(error));
    const mergedData = {
      ...(0, internals_1.getErrorData)(error),
      ...data
    };
    if (Object.keys(mergedData).length > 0) {
      _classPrivateFieldSet(_data, this, mergedData);
    }
    _classPrivateFieldSet(_stack, this, super.stack);
  }
  /**
   * The error name.
   *
   * @returns The error name.
   */
  get name() {
    return 'SnapError';
  }
  /**
   * The error code.
   *
   * @returns The error code.
   */
  get code() {
    return _classPrivateFieldGet(_code, this);
  }
  /**
   * The error message.
   *
   * @returns The error message.
   */
  // This line is covered, but Jest doesn't pick it up for some reason.
  /* istanbul ignore next */
  get message() {
    return _classPrivateFieldGet(_message, this);
  }
  /**
   * Additional data for the error.
   *
   * @returns Additional data for the error.
   */
  get data() {
    return _classPrivateFieldGet(_data, this);
  }
  /**
   * The error stack.
   *
   * @returns The error stack.
   */
  // This line is covered, but Jest doesn't pick it up for some reason.
  /* istanbul ignore next */
  get stack() {
    return _classPrivateFieldGet(_stack, this);
  }
  /**
   * Convert the error to a JSON object.
   *
   * @returns The JSON object.
   */
  toJSON() {
    return {
      code: internals_1.SNAP_ERROR_CODE,
      message: internals_1.SNAP_ERROR_MESSAGE,
      data: {
        cause: {
          code: this.code,
          message: this.message,
          stack: this.stack,
          ...(this.data ? {
            data: this.data
          } : {})
        }
      }
    };
  }
  /**
   * Serialize the error to a JSON object. This is called by
   * `@metamask/rpc-errors` when serializing the error.
   *
   * @returns The JSON object.
   */
  serialize() {
    return this.toJSON();
  }
}
exports.SnapError = SnapError;
/**
 * Get a serialised JSON error from a given error. This is intended to be used
 * with `snap_trackError` to convert an error to a JSON object that can be
 * tracked by the Sentry instance in the client.
 *
 * @param error - The error to convert to a JSON error. This can be a string, an
 * `Error`, a `JsonRpcError`, or any other type. If it is not a string or an
 * `Error`, it will be converted to a string using its `toString()` method.
 * @returns A JSON object containing the error message and stack trace, if
 * available.
 * @example
 * try {
 *   // Some code that may throw an error
 * } catch (error) {
 *   await snap.request({
 *     method: 'snap_trackError',
 *     params: {
 *       error: getJsonError(error),
 *     },
 *   });
 * }
 */
function getJsonError(
// TypeScript will narrow this to `unknown`, but we specify all the types for
// clarity.
error) {
  if (typeof error === 'string') {
    return {
      name: 'Error',
      message: error,
      stack: null,
      cause: null
    };
  }
  if ((0, utils_1.isJsonRpcError)(error)) {
    return {
      name: 'JsonRpcError',
      message: (0, internals_1.getErrorMessage)(error),
      stack: (0, internals_1.getErrorStack)(error) ?? (0, internals_1.getErrorStack)(error.data) ?? null,
      cause: null
    };
  }
  const cause = (0, internals_1.getErrorCause)(error);
  return {
    name: (0, internals_1.getErrorName)(error),
    message: (0, internals_1.getErrorMessage)(error),
    stack: (0, internals_1.getErrorStack)(error) ?? null,
    cause: cause === null ? null : getJsonError(cause)
  };
}
exports.getJsonError = getJsonError;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\errors.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\images.cjs", {"./ui/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\ui\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cimages.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getImageComponent = exports.getImageData = void 0;
const utils_1 = require("@metamask/utils");
const ui_1 = require("./ui/index.cjs");
/**
 * Get raw image data from a URL.
 *
 * @param url - The URL to get the image data from.
 * @param options - The options to use when fetching the image data. This is
 * passed directly to `fetch`.
 * @returns A promise that resolves to the image data as a blob.
 */
async function getRawImageData(url, options) {
  if (typeof fetch !== 'function') {
    throw new Error(`Failed to fetch image data from "${url}": Using this function requires the "endowment:network-access" permission.`);
  }
  return fetch(url, options).then(async response => {
    if (!response.ok) {
      throw new Error(`Failed to fetch image data from "${url}": ${response.status} ${response.statusText}`);
    }
    const blob = await response.blob();
    (0, utils_1.assert)(blob.type === 'image/jpeg' || blob.type === 'image/png', 'Expected image data to be a JPEG or PNG image.');
    return blob;
  });
}
/**
 * Get image data as data-string from a URL. This is useful for embedding images
 * inside of SVGs. Only JPEG and PNG images are supported.
 *
 * Note: This function uses `fetch` to get the image data. This means that using
 * it requires the `endowment:network-access` permission.
 *
 * @example
 * const imageData = await getImageData('https://cataas.com/cat');
 * const svg = `
 *   <svg width="100" height="100" xmlns="http://www.w3.org/2000/svg">
 *     <image href="${imageData}" />
 *   </svg>
 * `;
 *
 * // Render the SVG in a Snap UI.
 * const ui = image(svg);
 * @param url - The URL to get the image data from.
 * @param options - The options to use when fetching the image data. This is
 * passed directly to `fetch`.
 * @returns A promise that resolves to the image data as a data-string.
 */
async function getImageData(url, options) {
  const blob = await getRawImageData(url, options);
  const bytes = new Uint8Array(await blob.arrayBuffer());
  return `data:${blob.type};base64,${(0, utils_1.bytesToBase64)(bytes)}`;
}
exports.getImageData = getImageData;
/**
 * Get an image component from a URL. This is useful for embedding images inside
 * Snap UIs. Only JPEG and PNG images are supported.
 *
 * Note: This function uses `fetch` to get the image data. This means that using
 * it requires the `endowment:network-access` permission.
 *
 * @example
 * const component = await getImage('https://cataas.com/cat');
 *
 * return await snap.request({
 *   method: 'snap_dialog',
 *   params: {
 *     type: 'alert',
 *     content: panel([
 *       component,
 *     ]),
 *   },
 * });
 * @param url - The URL to get the image data from.
 * @param options - The options to use when fetching and rendering the image.
 * @param options.width - The width of the image.
 * @param options.height - The height of the image. If this is not provided, the
 * width will be used as the height.
 * @param options.request - The options to use when fetching the image data.
 * This is passed directly to `fetch`.
 * @returns A promise that resolves to the image data as an image component.
 */
async function getImageComponent(url, {
  width,
  height = width,
  request
}) {
  (0, utils_1.assert)(typeof width === 'number' && width > 0, 'Expected width to be a number greater than 0.');
  (0, utils_1.assert)(typeof height === 'number' && height > 0, 'Expected height to be a number greater than 0.');
  const imageData = await getImageData(url, request);
  const size = `width="${width}" height="${height}"`;
  return (0, ui_1.image)(`<svg ${size.trim()} xmlns="http://www.w3.org/2000/svg"><image ${size.trim()} href="${imageData}" /></svg>`);
}
exports.getImageComponent = getImageComponent;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\images.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\index.cjs", {"./error-wrappers.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\error-wrappers.cjs","./errors.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\errors.cjs","./images.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\images.cjs","./internals/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\internals\\index.cjs","./types/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\index.cjs","./ui/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\ui\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assert = exports.nonEmptyRecord = exports.selectiveUnion = exports.typedUnion = exports.enumValue = exports.union = exports.literal = exports.SNAP_ERROR_MESSAGE = exports.SNAP_ERROR_CODE = exports.getErrorStack = exports.getErrorMessage = exports.getErrorData = void 0;
var internals_1 = require("./internals/index.cjs");
Object.defineProperty(exports, "getErrorData", {
  enumerable: true,
  get: function () {
    return internals_1.getErrorData;
  }
});
Object.defineProperty(exports, "getErrorMessage", {
  enumerable: true,
  get: function () {
    return internals_1.getErrorMessage;
  }
});
Object.defineProperty(exports, "getErrorStack", {
  enumerable: true,
  get: function () {
    return internals_1.getErrorStack;
  }
});
Object.defineProperty(exports, "SNAP_ERROR_CODE", {
  enumerable: true,
  get: function () {
    return internals_1.SNAP_ERROR_CODE;
  }
});
Object.defineProperty(exports, "SNAP_ERROR_MESSAGE", {
  enumerable: true,
  get: function () {
    return internals_1.SNAP_ERROR_MESSAGE;
  }
});
Object.defineProperty(exports, "literal", {
  enumerable: true,
  get: function () {
    return internals_1.literal;
  }
});
Object.defineProperty(exports, "union", {
  enumerable: true,
  get: function () {
    return internals_1.union;
  }
});
Object.defineProperty(exports, "enumValue", {
  enumerable: true,
  get: function () {
    return internals_1.enumValue;
  }
});
Object.defineProperty(exports, "typedUnion", {
  enumerable: true,
  get: function () {
    return internals_1.typedUnion;
  }
});
Object.defineProperty(exports, "selectiveUnion", {
  enumerable: true,
  get: function () {
    return internals_1.selectiveUnion;
  }
});
Object.defineProperty(exports, "nonEmptyRecord", {
  enumerable: true,
  get: function () {
    return internals_1.nonEmptyRecord;
  }
});
var utils_1 = require("@metamask/utils");
Object.defineProperty(exports, "assert", {
  enumerable: true,
  get: function () {
    return utils_1.assert;
  }
});
__exportStar(require("./errors.cjs"), exports);
__exportStar(require("./error-wrappers.cjs"), exports);
__exportStar(require("./images.cjs"), exports);
__exportStar(require("./types/index.cjs"), exports);
__exportStar(require("./ui/index.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\internals\\error-wrappers.cjs", {"../errors.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\errors.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cinternals%5Cerror-wrappers.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSnapError = void 0;
const errors_1 = require("../errors.cjs");
/**
 * Create a `SnapError` class from an error function from
 * `@metamask/rpc-errors`. This is useful for creating custom error classes
 * which can be thrown by a Snap.
 *
 * The created class will inherit the message, code, and data properties from
 * the error function.
 *
 * @param fn - The error function to create the class from.
 * @returns The created `SnapError` class.
 */
function createSnapError(fn) {
  return class SnapJsonRpcError extends errors_1.SnapError {
    /**
     * Create a new `SnapJsonRpcError` from a message and data.
     *
     * @param message - The message to create the error from.
     * @param data - The data to create the error from.
     */
    constructor(message, data) {
      if (typeof message === 'object') {
        const error = fn();
        super({
          code: error.code,
          message: error.message,
          data: message
        });
        return;
      }
      const error = fn(message);
      super({
        code: error.code,
        message: error.message,
        data
      });
    }
  };
}
exports.createSnapError = createSnapError;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\internals\\error-wrappers.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\internals\\errors.cjs", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cinternals%5Cerrors.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getErrorData = exports.getErrorCause = exports.getErrorCode = exports.getErrorName = exports.getErrorStack = exports.getErrorMessage = exports.SNAP_ERROR_MESSAGE = exports.SNAP_ERROR_CODE = void 0;
const utils_1 = require("@metamask/utils");
exports.SNAP_ERROR_CODE = -31002;
exports.SNAP_ERROR_MESSAGE = 'Snap Error';
/**
 * Get a property from an object, or return a fallback value if the property
 * does not exist.
 *
 * @param object - The object to get the property from.
 * @param property - The property to get from the object.
 * @param fallback - The fallback value to return if the property does not
 * exist.
 * @returns The value of the property if it exists, or the fallback value if
 * the property does not exist.
 */
function getObjectProperty(object, property, fallback = null) {
  if ((0, utils_1.isObject)(object) && (0, utils_1.hasProperty)(object, property)) {
    return object[property];
  }
  return fallback;
}
/**
 * Get a string property from an object, or convert the object to a string
 * if the property does not exist or is not a string.
 *
 * @param object - The object to get the property from.
 * @param property - The property to get from the object.
 * @param fallback - The fallback value to return if the property does not exist
 * or is not a string. Defaults to the string representation of the object.
 * @returns The value of the property if it exists and is a string, or the
 * fallback value if it does not exist or is not a string.
 */
function getObjectStringProperty(object, property, fallback = String(object)) {
  const value = getObjectProperty(object, property);
  if (typeof value === 'string') {
    return value;
  }
  return fallback;
}
/**
 * Get the error message from an unknown error type.
 *
 * - If the error is an object with a `message` property, return the message.
 * - Otherwise, return the error converted to a string.
 *
 * @param error - The error to get the message from.
 * @returns The error message.
 * @internal
 */
function getErrorMessage(error) {
  return getObjectStringProperty(error, 'message');
}
exports.getErrorMessage = getErrorMessage;
/**
 * Get the error stack from an unknown error type.
 *
 * @param error - The error to get the stack from.
 * @returns The error stack, or undefined if the error does not have a valid
 * stack.
 * @internal
 */
function getErrorStack(error) {
  return getObjectStringProperty(error, 'stack', null);
}
exports.getErrorStack = getErrorStack;
/**
 * Get the error name from an unknown error type.
 *
 * @param error - The error to get the name from.
 * @returns The error name, or `'Error'` if the error does not have a valid
 * name.
 */
function getErrorName(error) {
  const fallbackName = error instanceof Error ? error.name : 'Error';
  return getObjectStringProperty(error, 'name', fallbackName);
}
exports.getErrorName = getErrorName;
/**
 * Get the error code from an unknown error type.
 *
 * @param error - The error to get the code from.
 * @returns The error code, or `-32603` if the error does not have a valid code.
 * @internal
 */
function getErrorCode(error) {
  const value = getObjectProperty(error, 'code');
  if (typeof value === 'number' && Number.isInteger(value)) {
    return value;
  }
  return -32603;
}
exports.getErrorCode = getErrorCode;
/**
 * Get the error cause from an unknown error type.
 *
 * @param error - The error to get the cause from.
 * @returns The error cause, or `null` if the error does not have a valid
 * cause.
 */
function getErrorCause(error) {
  return getObjectProperty(error, 'cause');
}
exports.getErrorCause = getErrorCause;
/**
 * Get the error data from an unknown error type.
 *
 * @param error - The error to get the data from.
 * @returns The error data, or an empty object if the error does not have valid
 * data.
 * @internal
 */
function getErrorData(error) {
  const value = getObjectProperty(error, 'data');
  if (value !== null && (0, utils_1.isValidJson)(value) && !Array.isArray(value)) {
    return value;
  }
  return {};
}
exports.getErrorData = getErrorData;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\internals\\errors.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\internals\\index.cjs", {"./error-wrappers.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\internals\\error-wrappers.cjs","./errors.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\internals\\errors.cjs","./jsx.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\internals\\jsx.cjs","./structs.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\internals\\structs.cjs","./svg.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\internals\\svg.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cinternals%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
__exportStar(require("./error-wrappers.cjs"), exports);
__exportStar(require("./errors.cjs"), exports);
__exportStar(require("./structs.cjs"), exports);
__exportStar(require("./jsx.cjs"), exports);
__exportStar(require("./svg.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\internals\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\internals\\jsx.cjs", {"./structs.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\internals\\structs.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cinternals%5Cjsx.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nullUnion = void 0;
const structs_1 = require("./structs.cjs");
/**
 * Create a union struct that uses `null` for the schema type, for better
 * compatibility with `Describe`.
 *
 * @param structs - The structs to union.
 * @returns The `superstruct` struct, which validates that the value satisfies
 * one of the structs.
 */
function nullUnion(structs) {
  return (0, structs_1.union)(structs);
}
exports.nullUnion = nullUnion;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\internals\\jsx.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\internals\\structs.cjs", {"@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cinternals%5Cstructs.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nonEmptyRecord = exports.selectiveUnion = exports.typedUnion = exports.enumValue = exports.union = exports.literal = void 0;
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
/**
 * A wrapper of `superstruct`'s `literal` struct that also defines the name of
 * the struct as the literal value.
 *
 * This is useful for improving the error messages returned by `superstruct`.
 * For example, instead of returning an error like:
 *
 * ```
 * Expected the value to satisfy a union of `literal | literal`, but received: \"baz\"
 * ```
 *
 * This struct will return an error like:
 *
 * ```
 * Expected the value to satisfy a union of `"foo" | "bar"`, but received: \"baz\"
 * ```
 *
 * @param value - The literal value.
 * @returns The `superstruct` struct, which validates that the value is equal
 * to the literal value.
 */
function literal(value) {
  return (0, superstruct_1.define)(JSON.stringify(value), (0, superstruct_1.literal)(value).validator);
}
exports.literal = literal;
/**
 * A wrapper of `superstruct`'s `union` struct that also defines the schema as
 * the union of the schemas of the structs.
 *
 * This is useful for improving the error messages returned by `superstruct`.
 *
 * @param structs - The structs to union.
 * @param structs."0" - The first struct.
 * @param structs."1" - The remaining structs.
 * @returns The `superstruct` struct, which validates that the value satisfies
 * one of the structs.
 */
function union([head, ...tail]) {
  const struct = (0, superstruct_1.union)([head, ...tail]);
  return new superstruct_1.Struct({
    ...struct,
    schema: [head, ...tail]
  });
}
exports.union = union;
/**
 * Superstruct struct for validating an enum value. This allows using both the
 * enum string values and the enum itself as values.
 *
 * @param constant - The enum to validate against.
 * @returns The superstruct struct.
 */
function enumValue(constant) {
  return literal(constant);
}
exports.enumValue = enumValue;
/**
 * Create a custom union struct that validates exclusively based on a `type` field.
 *
 * This should improve error messaging for unions with many structs in them.
 *
 * @param structs - The structs to union.
 * @returns The `superstruct` struct, which validates that the value satisfies
 * one of the structs.
 */
function typedUnion(structs) {
  const flatStructs = structs.map(struct => struct.type === 'union' && Array.isArray(struct.schema) ? struct.schema : struct).flat(Infinity);
  const types = flatStructs.map(({
    schema
  }) => schema.type.type);
  const structMap = flatStructs.reduce((accumulator, struct) => {
    accumulator[JSON.parse(struct.schema.type.type)] = struct;
    return accumulator;
  }, {});
  return new superstruct_1.Struct({
    type: 'union',
    schema: flatStructs,
    *entries(value, context) {
      if (!(0, utils_1.isObject)(value) || !(0, utils_1.hasProperty)(value, 'type') || typeof value.type !== 'string') {
        return;
      }
      const {
        type
      } = value;
      const struct = structMap[type];
      if (!struct) {
        return;
      }
      for (const entry of struct.entries(value, context)) {
        yield entry;
      }
    },
    coercer(value, context) {
      if (!(0, utils_1.isObject)(value) || !(0, utils_1.hasProperty)(value, 'type') || typeof value.type !== 'string') {
        return value;
      }
      const {
        type
      } = value;
      const struct = structMap[type];
      if (struct) {
        return struct.coercer(value, context);
      }
      return value;
    },
    // At this point we know the value to be an object.
    *refiner(value, context) {
      const struct = structMap[value.type];
      yield* struct.refiner(value, context);
    },
    validator(value, context) {
      if (!(0, utils_1.isObject)(value) || !(0, utils_1.hasProperty)(value, 'type') || typeof value.type !== 'string') {
        return `Expected type to be one of: ${types.join(', ')}, but received: undefined`;
      }
      const {
        type
      } = value;
      const struct = structMap[type];
      if (struct) {
        // This only validates the root of the struct, entries does the rest of the work.
        return struct.validator(value, context);
      }
      return `Expected type to be one of: ${types.join(', ')}, but received: "${type}"`;
    }
  });
}
exports.typedUnion = typedUnion;
/**
 * Create a custom union struct that uses a `selector` function for choosing
 * the validation path.
 *
 * @param selector - The selector function choosing the struct to validate with.
 * @returns The `superstruct` struct, which validates that the value satisfies
 * one of the structs.
 */
function selectiveUnion(selector) {
  return new superstruct_1.Struct({
    type: 'union',
    schema: null,
    *entries(value, context) {
      const struct = selector(value);
      for (const entry of struct.entries(value, context)) {
        yield entry;
      }
    },
    *refiner(value, context) {
      const struct = selector(value);
      yield* struct.refiner(value, context);
    },
    coercer(value, context) {
      const struct = selector(value);
      return struct.coercer(value, context);
    },
    validator(value, context) {
      const struct = selector(value);
      // This only validates the root of the struct, entries does the rest of the work.
      return struct.validator(value, context);
    }
  });
}
exports.selectiveUnion = selectiveUnion;
/**
 * Refine a struct to be a non-empty record and disallows usage of arrays.
 *
 * @param Key - The struct for the record key.
 * @param Value - The struct for the record value.
 * @returns The refined struct.
 */
function nonEmptyRecord(Key, Value) {
  return (0, superstruct_1.refine)((0, superstruct_1.record)(Key, Value), 'Non-empty record', value => {
    return !Array.isArray(value) && Object.keys(value).length > 0;
  });
}
exports.nonEmptyRecord = nonEmptyRecord;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\internals\\structs.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\internals\\svg.cjs", {"@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cinternals%5Csvg.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.svg = void 0;
const superstruct_1 = require("@metamask/superstruct");
/**
 * Get a Struct that validates a string as a valid SVG.
 *
 * @returns A Struct that validates a string as a valid SVG.
 * @internal
 */
function svg() {
  return (0, superstruct_1.refine)((0, superstruct_1.string)(), 'SVG', value => {
    // This validation is intentionally very basic, we don't need to be that strict
    // and merely have this extra validation as a helpful error if devs aren't
    // passing in SVGs.
    if (!value.includes('<svg')) {
      return 'Value is not a valid SVG.';
    }
    return true;
  });
}
exports.svg = svg;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\internals\\svg.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponent.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSnapComponent = void 0;
/**
 * Remove undefined props from an object.
 *
 * @param props - The object to remove undefined props from.
 * @returns The object without undefined props.
 */
function removeUndefinedProps(props) {
  return Object.fromEntries(Object.entries(props).filter(([, value]) => value !== undefined));
}
/**
 * Create a Snap component from a type. This is a helper function that creates a
 * Snap component function.
 *
 * @param type - The type of the component.
 * @returns A function that creates a Snap element.
 * @see SnapComponent
 */
function createSnapComponent(type) {
  return props => {
    const {
      key = null,
      ...rest
    } = props;
    return {
      type,
      props: removeUndefinedProps(rest),
      key
    };
  };
}
exports.createSnapComponent = createSnapComponent;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Address.cjs", {"../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5CAddress.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Address = void 0;
const component_1 = require("../component.cjs");
const TYPE = 'Address';
/**
 * An address component, which is used to display a CAIP-10 address or a Ethereum address.
 *
 * This component does not accept any children.
 *
 * @param props - The props of the component.
 * @param props.address - The address to display. This should be a
 * valid Ethereum address, starting with `0x`, or a valid CAIP-10 address.
 * @param props.truncate - Whether to truncate the address. Defaults to `true`.
 * @param props.displayName - Whether to show the account name. Defaults to `false`.
 * @param props.avatar - Whether to show the address avatar. Defaults to `true`.
 * @returns An address element.
 * @example
 * <Address address="0x1234567890123456789012345678901234567890" />
 * @example
 * <Address address="eip155:1:0x1234567890123456789012345678901234567890" />
 * @example
 * <Address address="bip122:000000000019d6689c085ae165831e93:128Lkh3S7CkDTBZ8W7BbpsN3YYizJMp8p6" />
 * @example
 * <Address address="0x1234567890123456789012345678901234567890" truncate={false} avatar={false} />
 * @example
 * <Address address="0x1234567890123456789012345678901234567890" displayName={true} />
 */
exports.Address = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Address.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Avatar.cjs", {"../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5CAvatar.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Avatar = void 0;
const component_1 = require("../component.cjs");
const TYPE = 'Avatar';
/**
 * An avatar component, which is used to display an avatar for a CAIP-10 address.
 *
 * This component does not accept any children.
 *
 * @param props - The props of the component.
 * @param props.address - The address to display. This should be a valid CAIP-10 address.
 * @param props.size - The size of the avatar. Can be `sm`, `md`, or `lg`. Defaults to `md`.
 * @returns An avatar element.
 * @example
 * <Avatar address="eip155:1:0x1234567890123456789012345678901234567890" />
 * @example
 * <Avatar address="bip122:000000000019d6689c085ae165831e93:128Lkh3S7CkDTBZ8W7BbpsN3YYizJMp8p6" />
 */
exports.Avatar = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Avatar.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Banner.cjs", {"../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5CBanner.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Banner = void 0;
const component_1 = require("../component.cjs");
const TYPE = 'Banner';
/**
 * A Banner component, which is used to display custom banner alerts.
 *
 * @param props - The props of the component.
 * @param props.children - The content to display in the banner.
 * @param props.title - Title of the banner.
 * @param props.severity - Severity level of the banner.
 * @example
 * <Banner title="Success banner" severity="success">
 *   <Text>Here is the banner content!</Text>
 * </Banner>
 */
exports.Banner = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Banner.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Box.cjs", {"../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5CBox.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Box = void 0;
const component_1 = require("../component.cjs");
const TYPE = 'Box';
/**
 * A box component, which is used to group multiple components together.
 *
 * @param props - The props of the component.
 * @param props.children - The children of the box.
 * @param props.direction - The direction to stack the components within the box. Defaults to `vertical`.
 * @param props.alignment - The alignment mode to use within the box. Defaults to `start`.
 * @param props.crossAlignment - The cross alignment mode to use within the box.
 * @param props.center - Whether to center the children within the box. Defaults to `false`.
 * @returns A box element.
 * @example
 * <Box>
 *   <Text>Hello world!</Text>
 * </Box>
 */
exports.Box = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Box.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Card.cjs", {"../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5CCard.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Card = void 0;
const component_1 = require("../component.cjs");
const TYPE = 'Card';
/**
 * A card component which can be used to display values within a card structure.
 *
 * @param props - The props of the component.
 * @param props.image - The image to show as part of the card, must be an SVG string.
 * @param props.title - The title.
 * @param props.description - The description, shown below the title.
 * @param props.value - The value, shown on the right side.
 * @param props.extra - An additional optional value shown below the value.
 * @returns A card element.
 * @example
 * <Card image="<svg />" title="Title" description="Description" value="$1200" extra="0.12 ETH" />
 */
exports.Card = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Card.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Container.cjs", {"../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5CContainer.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Container = void 0;
const component_1 = require("../component.cjs");
const TYPE = 'Container';
/**
 * A container component, which is used to create a container with a box and a footer.
 *
 * @param props - The props of the component.
 * @param props.backgroundColor - The color of the background.
 * @param props.children - The Box and the Footer or the Box element.
 * @returns A container element.
 * @example
 * <Container backgroundColor="default">
 *   <Box>
 *     <Text>Hello world!</Text>
 *   </Box>
 *   <Footer>
 *     <Button name="cancel">Cancel</Button>
 *     <Button name="confirm">Confirm</Button>
 *   </Footer>
 * </Container>
 */
exports.Container = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Container.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Copyable.cjs", {"../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5CCopyable.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Copyable = void 0;
const component_1 = require("../component.cjs");
const TYPE = 'Copyable';
/**
 * A copyable component, which is used to display text that can be copied by the
 * user.
 *
 * @param props - The props of the component.
 * @param props.value - The value to copy when the user clicks on the copyable
 * element.
 * @param props.sensitive - Whether the value is sensitive. If `true`, the value
 * will be hidden when the user is not interacting with the copyable element.
 * @example
 * <Copyable value="0x1234567890123456789012345678901234567890" />
 * <Copyable value="0x1234567890123456789012345678901234567890" sensitive />
 */
exports.Copyable = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Copyable.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Divider.cjs", {"../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5CDivider.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Divider = void 0;
const component_1 = require("../component.cjs");
const TYPE = 'Divider';
/**
 * A divider component, which is used to create a horizontal line between
 * elements.
 *
 * This component does not have any props.
 *
 * @returns A divider element.
 * @example
 * <Divider />
 */
exports.Divider = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Divider.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Footer.cjs", {"../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5CFooter.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Footer = void 0;
const component_1 = require("../component.cjs");
const TYPE = 'Footer';
/**
 * A footer component, which is used to create a footer with buttons.
 *
 * @param props - The props of the component.
 * @param props.children - The single or multiple buttons in the footer.
 * @returns A footer element.
 * @example
 * <Footer>
 *   <Button name="cancel">Cancel</Button>
 *   <Button name="confirm">Confirm</Button>
 * </Footer>
 */
exports.Footer = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Footer.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Heading.cjs", {"../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5CHeading.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Heading = void 0;
const component_1 = require("../component.cjs");
const TYPE = 'Heading';
/**
 * A heading component, which is used to display heading text.
 *
 * @param props - The props of the component.
 * @param props.children - The text to display in the heading.
 * @param props.size - The size of the heading. Defaults to `sm`.
 * @returns A heading element.
 * @example
 * <Heading>Hello world!</Heading>
 * @example
 * <Heading size="lg">Hello world!</Heading>
 */
exports.Heading = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Heading.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Icon.cjs", {"../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5CIcon.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Icon = exports.IconName = void 0;
const component_1 = require("../component.cjs");
// Copied from https://github.com/MetaMask/metamask-extension/blob/main/ui/components/component-library/icon/icon.types.ts
// Currently requires manual syncing when new icon is added.
var IconName;
(function (IconName) {
  IconName["Accessibility"] = "accessibility";
  IconName["Activity"] = "activity";
  IconName["AddCard"] = "add-card";
  IconName["AddCircle"] = "add-circle";
  IconName["AddSquare"] = "add-square";
  IconName["Add"] = "add";
  IconName["Ai"] = "ai";
  IconName["AlternateEmail"] = "alternate-email";
  IconName["Apple"] = "apple";
  IconName["Apps"] = "apps";
  IconName["Arrow2Down"] = "arrow-2-down";
  IconName["Arrow2Left"] = "arrow-2-left";
  IconName["Arrow2Right"] = "arrow-2-right";
  IconName["Arrow2UpRight"] = "arrow-2-up-right";
  IconName["Arrow2Up"] = "arrow-2-up";
  IconName["ArrowCircleDown"] = "arrow-circle-down";
  IconName["ArrowCircleUp"] = "arrow-circle-up";
  IconName["ArrowDoubleLeft"] = "arrow-double-left";
  IconName["ArrowDoubleRight"] = "arrow-double-right";
  IconName["ArrowDown"] = "arrow-down";
  IconName["ArrowDropDownCircle"] = "arrow-drop-down-circle";
  IconName["ArrowLeft"] = "arrow-left";
  IconName["ArrowRight"] = "arrow-right";
  IconName["ArrowUp"] = "arrow-up";
  IconName["Attachment"] = "attachment";
  IconName["Ban"] = "ban";
  IconName["BankAssured"] = "bank-assured";
  IconName["Bank"] = "bank";
  IconName["Bold"] = "bold";
  IconName["Book"] = "book";
  IconName["Bookmark"] = "bookmark";
  IconName["Bridge"] = "bridge";
  IconName["Briefcase"] = "briefcase";
  IconName["Bulb"] = "bulb";
  IconName["BuySell"] = "buy-sell";
  IconName["Cake"] = "cake";
  IconName["Calculator"] = "calculator";
  IconName["Calendar"] = "calendar";
  IconName["Call"] = "call";
  IconName["Camera"] = "camera";
  IconName["Campaign"] = "campaign";
  IconName["CardPos"] = "card-pos";
  IconName["Card"] = "card";
  IconName["Cash"] = "cash";
  IconName["Category"] = "category";
  IconName["Chart"] = "chart";
  IconName["CheckBold"] = "check-bold";
  IconName["Check"] = "check";
  IconName["CircleX"] = "circle-x";
  IconName["ClockFilled"] = "clock-filled";
  IconName["Clock"] = "clock";
  IconName["Close"] = "close";
  IconName["CloudDownload"] = "cloud-download";
  IconName["CloudUpload"] = "cloud-upload";
  IconName["Cloud"] = "cloud";
  IconName["CodeCircle"] = "code-circle";
  IconName["Code"] = "code";
  IconName["Coin"] = "coin";
  IconName["Collapse"] = "collapse";
  IconName["Confirmation"] = "confirmation";
  IconName["Connect"] = "connect";
  IconName["CopySuccess"] = "copy-success";
  IconName["Copy"] = "copy";
  IconName["CreditCheck"] = "credit-check";
  IconName["CurrencyFranc"] = "currency-franc";
  IconName["CurrencyLira"] = "currency-lira";
  IconName["CurrencyPound"] = "currency-pound";
  IconName["CurrencyYuan"] = "currency-yuan";
  IconName["Customize"] = "customize";
  IconName["Danger"] = "danger";
  IconName["DarkFilled"] = "dark-filled";
  IconName["Dark"] = "dark";
  IconName["Data"] = "data";
  IconName["Description"] = "description";
  IconName["Details"] = "details";
  IconName["Diagram"] = "diagram";
  IconName["DocumentCode"] = "document-code";
  IconName["Download"] = "download";
  IconName["Draft"] = "draft";
  IconName["EcoLeaf"] = "eco-leaf";
  IconName["EditSquare"] = "edit-square";
  IconName["Edit"] = "edit";
  IconName["EncryptedAdd"] = "encrypted-add";
  IconName["Eraser"] = "eraser";
  IconName["Error"] = "error";
  IconName["Ethereum"] = "ethereum";
  IconName["Exchange"] = "exchange";
  IconName["ExpandVertical"] = "expand-vertical";
  IconName["Expand"] = "expand";
  IconName["ExploreFilled"] = "explore-filled";
  IconName["Explore"] = "explore";
  IconName["Export"] = "export";
  IconName["Extension"] = "extension";
  IconName["EyeSlash"] = "eye-slash";
  IconName["Eye"] = "eye";
  IconName["FaceId"] = "face-id";
  IconName["Feedback"] = "feedback";
  IconName["File"] = "file";
  IconName["Filter"] = "filter";
  IconName["Fingerprint"] = "fingerprint";
  IconName["Fire"] = "fire";
  IconName["FirstPage"] = "first-page";
  IconName["Flag"] = "flag";
  IconName["FlashSlash"] = "flash-slash";
  IconName["Flash"] = "flash";
  IconName["Flask"] = "flask";
  IconName["Flower"] = "flower";
  IconName["Folder"] = "folder";
  IconName["Forest"] = "forest";
  IconName["FullCircle"] = "full-circle";
  IconName["Gas"] = "gas";
  IconName["Gift"] = "gift";
  IconName["GlobalSearch"] = "global-search";
  IconName["Global"] = "global";
  IconName["Graph"] = "graph";
  IconName["Hardware"] = "hardware";
  IconName["HashTag"] = "hash-tag";
  IconName["HeartFilled"] = "heart-filled";
  IconName["Heart"] = "heart";
  IconName["Hierarchy"] = "hierarchy";
  IconName["HomeFilled"] = "home-filled";
  IconName["Home"] = "home";
  IconName["Image"] = "image";
  IconName["Info"] = "info";
  IconName["Inventory"] = "inventory";
  IconName["Joystick"] = "joystick";
  IconName["KeepFilled"] = "keep-filled";
  IconName["Keep"] = "keep";
  IconName["Key"] = "key";
  IconName["LastPage"] = "last-page";
  IconName["LightFilled"] = "light-filled";
  IconName["Light"] = "light";
  IconName["Link"] = "link";
  IconName["Loading"] = "loading";
  IconName["Location"] = "location";
  IconName["LockSlash"] = "lock-slash";
  IconName["Lock"] = "lock";
  IconName["LockedFilled"] = "locked-filled";
  IconName["Login"] = "login";
  IconName["Logout"] = "logout";
  IconName["Mail"] = "mail";
  IconName["Map"] = "map";
  IconName["Menu"] = "menu";
  IconName["MessageQuestion"] = "message-question";
  IconName["Messages"] = "messages";
  IconName["Mic"] = "mic";
  IconName["MinusBold"] = "minus-bold";
  IconName["MinusSquare"] = "minus-square";
  IconName["Minus"] = "minus";
  IconName["Mobile"] = "mobile";
  IconName["MoneyBag"] = "money-bag";
  IconName["Money"] = "money";
  IconName["Monitor"] = "monitor";
  IconName["MoreHorizontal"] = "more-horizontal";
  IconName["MoreVertical"] = "more-vertical";
  IconName["MountainFlag"] = "mountain-flag";
  IconName["MusicNote"] = "music-note";
  IconName["Notification"] = "notification";
  IconName["PageInfo"] = "page-info";
  IconName["Palette"] = "palette";
  IconName["PasswordCheck"] = "password-check";
  IconName["Pending"] = "pending";
  IconName["People"] = "people";
  IconName["PersonCancel"] = "person-cancel";
  IconName["Pin"] = "pin";
  IconName["Plant"] = "plant";
  IconName["Plug"] = "plug";
  IconName["PlusAndMinus"] = "plus-and-minus";
  IconName["PolicyAlert"] = "policy-alert";
  IconName["Print"] = "print";
  IconName["PriorityHigh"] = "priority-high";
  IconName["PrivacyTip"] = "privacy-tip";
  IconName["ProgrammingArrows"] = "programming-arrows";
  IconName["Publish"] = "publish";
  IconName["QrCode"] = "qr-code";
  IconName["Question"] = "question";
  IconName["Receive"] = "receive";
  IconName["Received"] = "received";
  IconName["Refresh"] = "refresh";
  IconName["RemoveMinus"] = "remove-minus";
  IconName["Report"] = "report";
  IconName["Rocket"] = "rocket";
  IconName["SaveFilled"] = "save-filled";
  IconName["Save"] = "save";
  IconName["Saving"] = "saving";
  IconName["ScanBarcode"] = "scan-barcode";
  IconName["ScanFocus"] = "scan-focus";
  IconName["Scan"] = "scan";
  IconName["Search"] = "search";
  IconName["SecurityAlert"] = "security-alert";
  IconName["SecurityCross"] = "security-cross";
  IconName["SecurityKey"] = "security-key";
  IconName["SecuritySearch"] = "security-search";
  IconName["SecuritySlash"] = "security-slash";
  IconName["SecurityTick"] = "security-tick";
  IconName["SecurityTime"] = "security-time";
  IconName["SecurityUser"] = "security-user";
  IconName["Security"] = "security";
  IconName["Send"] = "send";
  IconName["SentimentDissatisfied"] = "sentiment-dissatisfied";
  IconName["SentimentNeutral"] = "sentiment-neutral";
  IconName["SentimentSatisfied"] = "sentiment-satisfied";
  IconName["SentimentVerySatisfied"] = "sentiment-very-satisfied";
  IconName["SettingFilled"] = "setting-filled";
  IconName["Setting"] = "setting";
  IconName["Share"] = "share";
  IconName["ShieldLock"] = "shield-lock";
  IconName["ShoppingBag"] = "shopping-bag";
  IconName["ShoppingCart"] = "shopping-cart";
  IconName["SignalCellular"] = "signal-cellular";
  IconName["Slash"] = "slash";
  IconName["Sms"] = "sms";
  IconName["SnapsMobile"] = "snaps-mobile";
  IconName["SnapsPlus"] = "snaps-plus";
  IconName["SnapsRound"] = "snaps-round";
  IconName["Snaps"] = "snaps";
  IconName["SortByAlpha"] = "sort-by-alpha";
  IconName["Sort"] = "sort";
  IconName["Sparkle"] = "sparkle";
  IconName["Speed"] = "speed";
  IconName["Speedometer"] = "speedometer";
  IconName["Square"] = "square";
  IconName["Stake"] = "stake";
  IconName["StarFilled"] = "star-filled";
  IconName["Star"] = "star";
  IconName["Start"] = "start";
  IconName["Storefront"] = "storefront";
  IconName["Student"] = "student";
  IconName["SwapHorizontal"] = "swap-horizontal";
  IconName["SwapVertical"] = "swap-vertical";
  IconName["TabClose"] = "tab-close";
  IconName["TableRow"] = "table-row";
  IconName["Tablet"] = "tablet";
  IconName["Tag"] = "tag";
  IconName["ThumbDownFilled"] = "thumb-down-filled";
  IconName["ThumbDown"] = "thumb-down";
  IconName["ThumbUpFilled"] = "thumb-up-filled";
  IconName["ThumbUp"] = "thumb-up";
  IconName["Tint"] = "tint";
  IconName["Tooltip"] = "tooltip";
  IconName["Translate"] = "translate";
  IconName["Trash"] = "trash";
  IconName["TrendDown"] = "trend-down";
  IconName["TrendUp"] = "trend-up";
  IconName["TriangleUp"] = "triangle-up";
  IconName["TriangleDown"] = "triangle-down";
  IconName["Undo"] = "undo";
  IconName["Unfold"] = "unfold";
  IconName["UnlockedFilled"] = "unlocked-filled";
  IconName["Unpin"] = "unpin";
  IconName["UploadFile"] = "upload-file";
  IconName["Upload"] = "upload";
  IconName["Usb"] = "usb";
  IconName["UserCheck"] = "user-check";
  IconName["UserCircleAdd"] = "user-circle-add";
  IconName["UserCircleRemove"] = "user-circle-remove";
  IconName["UserCircle"] = "user-circle";
  IconName["User"] = "user";
  IconName["VerifiedFilled"] = "verified-filled";
  IconName["Verified"] = "verified";
  IconName["Videocam"] = "videocam";
  IconName["ViewColumn"] = "view-column";
  IconName["ViewInAr"] = "view-in-ar";
  IconName["VolumeOff"] = "volume-off";
  IconName["VolumeUp"] = "volume-up";
  IconName["WalletFilled"] = "wallet-filled";
  IconName["Wallet"] = "wallet";
  IconName["Warning"] = "warning";
  IconName["WebTraffic"] = "web-traffic";
  IconName["Widgets"] = "widgets";
  IconName["WifiOff"] = "wifi-off";
  IconName["Wifi"] = "wifi";
  IconName["X"] = "x";
})(IconName || (exports.IconName = IconName = {}));
const TYPE = 'Icon';
/**
 * An icon component which is used to display an icon from a pre-defined list.
 *
 * @param props - The props of the component.
 * @param props.name - The name of the icon to display from a pre-defined list.
 * @param props.color - The color of the displayed icon.
 * @param props.size - The size of the displayed icon. Use `inherit` to size it the same as the text.
 * @returns An icon element.
 * @example
 * <Icon name="warning" color="warning" size="md" />
 */
exports.Icon = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Icon.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Image.cjs", {"../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5CImage.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Image = void 0;
const component_1 = require("../component.cjs");
const TYPE = 'Image';
/**
 * An image component, which is used to display an image.
 *
 * This component does not accept any children.
 *
 * @param props - The props of the component.
 * @param props.src - The URL of the image to display. This should be an SVG
 * string, and other formats such as PNG and JPEG are not supported directly.
 * You can use the `data:` URL scheme to embed images inside the SVG.
 * @param props.alt - The alternative text of the image, which describes the
 * image for users who cannot see it.
 * @param props.borderRadius - The border radius applied to the image.
 * @returns An image element.
 * @example
 * <Image src="<svg>...</svg>" alt="An example image" />
 */
exports.Image = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Image.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Link.cjs", {"../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5CLink.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Link = void 0;
const component_1 = require("../component.cjs");
const TYPE = 'Link';
/**
 * A link component, which is used to display a hyperlink.
 *
 * @param props - The props of the component.
 * @param props.children - The text to display in the link.
 * @param props.href - The URL to link to. This must be an `https` or `mailto`
 * URL. `http` is not allowed.
 * @returns A link element.
 * @example
 * <Link href="https://example.com">Click here</Link>
 */
exports.Link = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Link.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Row.cjs", {"../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5CRow.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Row = void 0;
const component_1 = require("../component.cjs");
const TYPE = 'Row';
/**
 * A row component, which is used to display a row of information.
 *
 * @param props - The props of the component.
 * @param props.label - The label of the row.
 * @param props.children - The content of the row. This can be an address, an
 * image, or text.
 * @param props.variant - The variant of the row.
 * @param props.tooltip - An optional tooltip to show for the row.
 * @returns A row element.
 * @example
 * <Row label="From" variant="warning" tooltip="This address has been deemed dangerous.">
 *   <Address address="0x1234567890123456789012345678901234567890" />
 * </Row>
 */
exports.Row = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Row.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Section.cjs", {"../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5CSection.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Section = void 0;
const component_1 = require("../component.cjs");
const TYPE = 'Section';
/**
 * A section component, which is used to group multiple components together.
 * The component itself is 16px padded with a default background and a border radius of 8px.
 *
 * @param props - The props of the component.
 * @param props.children - The children of the section.
 * @param props.direction - The direction that the children are aligned.
 * @param props.alignment - The alignment of the children (a justify-content value).
 * @returns A section element.
 * @example
 * <Section>
 *   <Row label="From">
 *     <Address address="0x1234567890123456789012345678901234567890" />
 *   </Row>
 *   <Row label="To" variant="warning" tooltip="This address has been deemed dangerous.">
 *     <Address address="0x0000000000000000000000000000000000000000" />
 *   </Row>
 * </Section>
 */
exports.Section = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Section.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Skeleton.cjs", {"../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5CSkeleton.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = void 0;
const component_1 = require("../component.cjs");
const TYPE = 'Skeleton';
/**
 * A Skeleton component, which is used to display skeleton of loading content.
 *
 * @param props - The props of the component.
 * @param props.width - Width of the Skeleton.
 * @param props.width - Height of the Skeleton.
 * @param props.borderRadius - Border radius of the Skeleton.
 * @example
 * <Skeleton height={32} width="50%" />
 */
exports.Skeleton = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Skeleton.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Spinner.cjs", {"../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5CSpinner.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Spinner = void 0;
const component_1 = require("../component.cjs");
const TYPE = 'Spinner';
/**
 * A spinner component, which is used to display a spinner, indicating that some
 * operation is in progress.
 *
 * This component does not accept any props.
 *
 * @returns A spinner element.
 * @example
 * <Spinner />
 */
exports.Spinner = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Spinner.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Text.cjs", {"../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5CText.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Text = void 0;
const component_1 = require("../component.cjs");
const TYPE = 'Text';
/**
 * A text component, which is used to display text.
 *
 * @param props - The props of the component.
 * @param props.alignment - The alignment of the text.
 * @param props.color - The color of the text.
 * @param props.children - The text to display.
 * @param props.size - The size of the text. Defaults to `md`.
 * @param props.fontWeight - The font weight of the text. Defaults to `regular`.
 * @returns A text element.
 * @example
 * <Text>
 *   Hello <Bold>world</Bold>!
 * </Text>
 * @example
 * <Text alignment="end">
 *   Hello <Bold>world</Bold>!
 * </Text>
 * @example
 * <Text size="sm">
 *   Hello <Bold>world</Bold>!
 * </Text>
 * @example
 * <Text fontWeight="medium">
 *   Hello <Bold>world</Bold>!
 * </Text>
 */
exports.Text = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Text.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Tooltip.cjs", {"../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5CTooltip.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tooltip = void 0;
const component_1 = require("../component.cjs");
const TYPE = 'Tooltip';
/**
 * A tooltip component, which is used to display text in a tooltip.
 *
 * @param props - The props of the component.
 * @param props.children - The children of the tooltip.
 * @param props.content - The text to display in the tooltip.
 * @returns A tooltip element.
 * @example
 * <Tooltip content="Tooltip text">
 *   <Text>Hello world!</Text>
 * </Tooltip>
 * @example
 * <Tooltip content={<Text>Text with <Bold>formatting</Bold></Text>}>
 *   <Text>Hello world!</Text>
 * </Tooltip>
 */
exports.Tooltip = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Tooltip.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Value.cjs", {"../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5CValue.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Value = void 0;
const component_1 = require("../component.cjs");
const TYPE = 'Value';
/**
 * A value component, which can be used to display two different text values side by side.
 *
 * This component can only be used as a child of the {@link Row} component.
 *
 * This component does not accept any children.
 *
 * @param props - The props of the component.
 * @param props.value - The value shown on the right side.
 * @param props.extra - The extra text shown on the left side.
 * @returns A value element.
 * @example
 * <Value value="0.05 ETH" extra="$200" />
 * @example
 * <Value value={<Text color='error'>0.05 ETH</Text>} extra={<Text color='error'>$200</Text>} />
 */
exports.Value = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Value.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\AccountSelector.cjs", {"../../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5Cform%5CAccountSelector.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountSelector = void 0;
const component_1 = require("../../component.cjs");
const TYPE = 'AccountSelector';
/**
 * An account selector component, which is used to create an account selector.
 *
 * @param props - The props of the component.
 * @param props.name - The name of the account selector. This is used to identify the
 * state in the form data.
 * @param props.hideExternalAccounts - Whether to hide accounts that doesn't belong to the snap.
 * @param props.chainIds - The chain IDs to filter the accounts to show.
 * @param props.switchGlobalAccount - Whether to switch the selected account in the client.
 * @param props.value - The selected address.
 * @param props.disabled - Whether the account selector is disabled.
 * @returns An account selector element.
 * @example
 * <AccountSelector name="account-selector" />
 * @example
 * <AccountSelector name="account-selector" hideExternalAccounts />
 * @example
 * <AccountSelector name="account-selector" chainIds={['eip155:1']} />
 * @example
 * <AccountSelector name="account-selector" switchGlobalAccount />
 * @example
 * <AccountSelector name="account-selector" value="eip155:1:0x1234..." />
 * @example
 * <AccountSelector name="account-selector" hideExternalAccounts chainIds={['eip155:1']} switchGlobalAccount value="eip155:1:0x1234..." />
 */
exports.AccountSelector = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\AccountSelector.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\AddressInput.cjs", {"../../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5Cform%5CAddressInput.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddressInput = void 0;
const component_1 = require("../../component.cjs");
const TYPE = 'AddressInput';
/**
 * An input component for entering an address. Resolves the address to a display name and avatar.
 *
 * @param props - The props of the component.
 * @param props.name - The name of the input field.
 * @param props.value - The value of the input field.
 * @param props.chainId - The CAIP-2 chain ID of the address.
 * @param props.placeholder - The placeholder text of the input field.
 * @param props.disabled - Whether the input field is disabled.
 * @param props.displayAvatar - Whether to display the avatar of the address.
 * @returns An input element.
 * @example
 * <AddressInput name="address" value="0x1234567890123456789012345678901234567890" chainId="eip155:1" />
 */
exports.AddressInput = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\AddressInput.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\AssetSelector.cjs", {"../../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5Cform%5CAssetSelector.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetSelector = void 0;
const component_1 = require("../../component.cjs");
const TYPE = 'AssetSelector';
/**
 * An asset selector component, which is used to create an asset selector.
 *
 * @param props - The props of the component.
 * @property addresses - The addresses of the account to pull the assets from as CAIP-10 Account IDs.
 * Multiple CAIP-10 Account IDs can be provided, but the account address should be the same on all Account IDs.
 * Only non-EIP-155 namespaces are supported for now.
 * @param props.chainIds - The chain IDs to filter the assets.
 * Only non-EIP-155 namespaces are supported for now.
 * @param props.value - The selected value of the asset selector.
 * Only non-EIP-155 namespaces are supported for now.
 * @param props.disabled - Whether the asset selector is disabled.
 * @returns An asset selector element.
 * @example
 * <AssetSelector
 *  addresses={[
 *    'solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp:7S3P4HxJpyyigGzodYwHtCxZyUQe9JiBMHyRWXArAaKv',
 *    'solana:EtWTRABZaYq6iMfeYKouRu166VU2xqa1:7S3P4HxJpyyigGzodYwHtCxZyUQe9JiBMHyRWXArAaKv',
 *  ]}
 *  value="solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp/token:EPjFWdd5AufqSSqeM2qN1xzybapC8G4wEGGkZwyTDt1v"
 * />
 * @example
 * <AssetSelector
 *  addresses={[
 *    'solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp:7S3P4HxJpyyigGzodYwHtCxZyUQe9JiBMHyRWXArAaKv',
 *    'solana:EtWTRABZaYq6iMfeYKouRu166VU2xqa1:7S3P4HxJpyyigGzodYwHtCxZyUQe9JiBMHyRWXArAaKv',
 *  ]}
 *  chainIds={['solana:5eykt4UsFv8P8NJdTREpY1vzqKqZKvdp']}
 * />
 */
exports.AssetSelector = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\AssetSelector.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Button.cjs", {"../../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5Cform%5CButton.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Button = void 0;
const component_1 = require("../../component.cjs");
const TYPE = 'Button';
/**
 * A button component, which is used to create a clickable button.
 *
 * @param props - The props of the component.
 * @param props.children - The text to display on the button. This should be a
 * string or an array of strings.
 * @returns A button element.
 * @example
 * <Button name="my-button">Click me</Button>
 */
exports.Button = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Button.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Checkbox.cjs", {"../../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5Cform%5CCheckbox.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Checkbox = void 0;
const component_1 = require("../../component.cjs");
const TYPE = 'Checkbox';
/**
 * A checkbox component, which is used to create a checkbox.
 *
 * @param props - The props of the component.
 * @param props.name - The name of the checkbox. This is used to identify the
 * state in the form data.
 * @param props.checked - Whether the checkbox is checked or not.
 * @param props.label - An optional label for the checkbox.
 * @param props.variant - An optional variant for the checkbox.
 * @param props.disabled - Whether the checkbox is disabled.
 * @returns A checkbox element.
 * @example
 * <Checkbox name="accept-terms" />
 */
exports.Checkbox = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Checkbox.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Dropdown.cjs", {"../../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5Cform%5CDropdown.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Dropdown = void 0;
const component_1 = require("../../component.cjs");
const TYPE = 'Dropdown';
/**
 * A dropdown component, which is used to create a dropdown.
 *
 * @param props - The props of the component.
 * @param props.name - The name of the dropdown field. This is used to identify the
 * state in the form data.
 * @param props.value - The selected value of the dropdown.
 * @param props.children - The children of the dropdown.
 * @param props.disabled - Whether the dropdown is disabled.
 * @returns A dropdown element.
 * @example
 * <Dropdown name="dropdown">
 *  <Option value="option1">Option 1</Option>
 *  <Option value="option2">Option 2</Option>
 *  <Option value="option3">Option 3</Option>
 * </Dropdown>
 */
exports.Dropdown = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Dropdown.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Field.cjs", {"../../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5Cform%5CField.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Field = void 0;
const component_1 = require("../../component.cjs");
const TYPE = 'Field';
/**
 * A field component, which is used to create a form field.
 *
 * @param props - The props of the component.
 * @param props.label - The label of the field.
 * @param props.error - The error message of the field.
 * @param props.children - The input field and the submit button.
 * @returns A field element.
 * @example
 * <Field label="Username">
 *   <Input name="username" type="text" />
 *   <Button type="submit">Submit</Button>
 * </Field>
 * @example
 * <Field label="Upload file">
 *   <FileInput name="file" accept={['image/*']} multiple />
 * </Field>
 */
exports.Field = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Field.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\FileInput.cjs", {"../../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5Cform%5CFileInput.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileInput = void 0;
const component_1 = require("../../component.cjs");
const TYPE = 'FileInput';
/**
 * A file input component, which is used to create a file input field. This
 * component can only be used as a child of the {@link Field} component.
 *
 * The total size of the files that can be uploaded may not exceed 64 MB.
 *
 * @param props - The props of the component.
 * @param props.name - The name of the file input field. This is used to
 * identify the file input field in the form data.
 * @param props.accept - The file types that the file input field accepts. If
 * not specified, the file input field accepts all file types. For examples of
 * valid values, see the [MDN documentation](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/accept).
 * @param props.compact - Whether the file input field is compact. Default is
 * `false`.
 * @param props.disabled - Whether the file input is disabled.
 * @returns A file input element.
 * @example
 * <FileInput name="file" accept={['image/*']} />
 * @example
 * <FileInput name="file" compact />
 * @example
 * <Field label="Upload file">
 *   <FileInput name="file" />
 * </Field>
 */
exports.FileInput = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\FileInput.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Form.cjs", {"../../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5Cform%5CForm.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Form = void 0;
const component_1 = require("../../component.cjs");
const TYPE = 'Form';
/**
 * A form component, which is used to create a form.
 *
 * @param props - The props of the component.
 * @param props.children - The form fields. This should be a single field or an
 * array of fields.
 * @param props.name - The name of the form. This is used to identify the form
 * in the event handler.
 * @returns A form element.
 * @example
 * <Form name="my-form">
 *   <Field label="Username">
 *     <Input name="username" type="text" />
 *   </Field>
 *   <Button type="submit">Submit</Button>
 * </Form>
 */
exports.Form = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Form.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Input.cjs", {"../../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5Cform%5CInput.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Input = void 0;
const component_1 = require("../../component.cjs");
const TYPE = 'Input';
/**
 * An input component, which is used to create an input field.
 *
 * @param props - The props of the component.
 * @param props.name - The name of the input field. This is used to identify the
 * input field in the form data.
 * @param props.type - The type of the input field.
 * @param props.value - The value of the input field.
 * @param props.placeholder - The placeholder text of the input field.
 * @param props.min - The minimum value of the input field.
 * Only applicable to the type `number` input.
 * @param props.max - The maximum value of the input field.
 * Only applicable to the type `number` input.
 * @param props.step - The step value of the input field.
 * Only applicable to the type `number` input.
 * @param props.disabled - Whether the input is disabled.
 * @returns An input element.
 * @example
 * <Input name="username" type="text" />
 * @example
 * <Input name="numeric" type="number" min={1} max={100} step={1} />
 */
exports.Input = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Input.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Option.cjs", {"../../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5Cform%5COption.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Option = void 0;
const component_1 = require("../../component.cjs");
const TYPE = 'Option';
/**
 * A dropdown option component, which is used to create a dropdown option. This component
 * can only be used as a child of the {@link Dropdown} component.
 *
 * @param props - The props of the component.
 * @param props.value - The value of the dropdown option. This is used to populate the
 * state in the form data.
 * @param props.children - The text to display.
 * @param props.disabled - Whether the option is disabled.
 * @returns A dropdown option element.
 * @example
 * <Dropdown name="dropdown">
 *  <Option value="option1">Option 1</Option>
 *  <Option value="option2">Option 2</Option>
 *  <Option value="option3">Option 3</Option>
 * </Dropdown>
 */
exports.Option = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Option.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Radio.cjs", {"../../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5Cform%5CRadio.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Radio = void 0;
const component_1 = require("../../component.cjs");
const TYPE = 'Radio';
/**
 * A radio component, which is used to create a radio option. This component
 * can only be used as a child of the {@link RadioGroup} component.
 *
 * @param props - The props of the component.
 * @param props.value - The value of the radio option. This is used to populate the
 * state in the form data.
 * @param props.children - The text to display.
 * @param props.disabled - Whether the radio is disabled.
 * @returns A radio element.
 * @example
 * <RadioGroup name="radio-group">
 *  <Radio value="option1">Option 1</Radio>
 *  <Radio value="option2">Option 2</Radio>
 *  <Radio value="option3">Option 3</Radio>
 * </RadioGroup>
 */
exports.Radio = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Radio.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\RadioGroup.cjs", {"../../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5Cform%5CRadioGroup.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RadioGroup = void 0;
const component_1 = require("../../component.cjs");
const TYPE = 'RadioGroup';
/**
 * A RadioGroup component, used to display multiple choices, where only one can be chosen.
 *
 * @param props.name - The name of the dropdown. This is used to identify the
 * state in the form data.
 * @param props.value - The value of the radio group element.
 * @param props.children - Radio options in form of <Radio> elements.
 * @param props.disabled - Whether the radio group is disabled.
 * @returns A RadioGroup element.
 * @example
 * <RadioGroup />
 */
exports.RadioGroup = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\RadioGroup.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Selector.cjs", {"../../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5Cform%5CSelector.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Selector = void 0;
const component_1 = require("../../component.cjs");
const TYPE = 'Selector';
/**
 * A selector component, which is used to create a selector.
 *
 * @param props - The props of the component.
 * @param props.name - The name of the selector field. This is used to identify the
 * state in the form data.
 * @param props.title - The title of the selector field. This is displayed in the UI.
 * @param props.value - The selected value of the selector.
 * @param props.children - The children of the selector.
 * @property disabled - Whether the selector is disabled.
 * @returns A selector element.
 * @example
 * <Selector name="selector">
 *  <SelectorOption value="option1"><Card title="Option 1" value="Foo" /></SelectorOption>
 *  <SelectorOption value="option2"><Card title="Option 2" value="Bar" /></SelectorOption>
 *  <SelectorOption value="option3"><Card title="Option 3" value="Baz" /></SelectorOption>
 * </Selector>
 */
exports.Selector = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Selector.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\SelectorOption.cjs", {"../../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5Cform%5CSelectorOption.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectorOption = void 0;
const component_1 = require("../../component.cjs");
const TYPE = 'SelectorOption';
/**
 * A selector option component, which is used to create a selector option. This component
 * can only be used as a child of the {@link Selector} component.
 *
 * @param props - The props of the component.
 * @param props.value - The value of the selector option. This is used to populate the
 * state in the form data.
 * @param props.children - The component to display.
 * @param props.disabled - Whether the selector option is disabled.
 * @returns A selector option element.
 * @example
 * <Selector name="selector">
 *  <SelectorOption value="option1"><Card title="Option 1" value="Foo" /></SelectorOption>
 *  <SelectorOption value="option2"><Card title="Option 2" value="Bar" /></SelectorOption>
 *  <SelectorOption value="option3"><Card title="Option 3" value="Baz" /></SelectorOption>
 * </Selector>
 */
exports.SelectorOption = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\SelectorOption.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\index.cjs", {"./AccountSelector.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\AccountSelector.cjs","./AddressInput.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\AddressInput.cjs","./AssetSelector.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\AssetSelector.cjs","./Button.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Button.cjs","./Checkbox.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Checkbox.cjs","./Dropdown.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Dropdown.cjs","./Field.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Field.cjs","./FileInput.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\FileInput.cjs","./Form.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Form.cjs","./Input.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Input.cjs","./Option.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Option.cjs","./Radio.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Radio.cjs","./RadioGroup.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\RadioGroup.cjs","./Selector.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\Selector.cjs","./SelectorOption.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\SelectorOption.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5Cform%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
__exportStar(require("./AccountSelector.cjs"), exports);
__exportStar(require("./AddressInput.cjs"), exports);
__exportStar(require("./AssetSelector.cjs"), exports);
__exportStar(require("./Button.cjs"), exports);
__exportStar(require("./Checkbox.cjs"), exports);
__exportStar(require("./Dropdown.cjs"), exports);
__exportStar(require("./Option.cjs"), exports);
__exportStar(require("./Radio.cjs"), exports);
__exportStar(require("./RadioGroup.cjs"), exports);
__exportStar(require("./Field.cjs"), exports);
__exportStar(require("./FileInput.cjs"), exports);
__exportStar(require("./Form.cjs"), exports);
__exportStar(require("./Input.cjs"), exports);
__exportStar(require("./Selector.cjs"), exports);
__exportStar(require("./SelectorOption.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\formatting\\Bold.cjs", {"../../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs","../Text.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Text.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5Cformatting%5CBold.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Bold = void 0;
const component_1 = require("../../component.cjs");
// eslint-disable-next-line @typescript-eslint/no-unused-vars
const Text_1 = require("../Text.cjs");
const TYPE = 'Bold';
/**
 * A bold component, which is used to display text in bold. This component can
 * only be used as a child of the {@link Text} component.
 *
 * @param props - The props of the component.
 * @param props.children - The text to display in bold.
 * @returns A bold element.
 * @example
 * <Text>
 *   Hello <Bold>world</Bold>!
 * </Text>
 */
exports.Bold = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\formatting\\Bold.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\formatting\\Italic.cjs", {"../../component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5Cformatting%5CItalic.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Italic = void 0;
const component_1 = require("../../component.cjs");
const TYPE = 'Italic';
/**
 * An italic component, which is used to display text in italic. This componen
 * can only be used as a child of the {@link Text} component.
 *
 * @param props - The props of the component.
 * @param props.children - The text to display in italic. This should be a
 * string or an array of strings.
 * @returns An italic element.
 * @example
 * <Text>
 *   Hello <Italic>world</Italic>!
 * </Text>
 */
exports.Italic = (0, component_1.createSnapComponent)(TYPE);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\formatting\\Italic.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\formatting\\index.cjs", {"./Bold.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\formatting\\Bold.cjs","./Italic.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\formatting\\Italic.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5Cformatting%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
__exportStar(require("./Bold.cjs"), exports);
__exportStar(require("./Italic.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\formatting\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\index.cjs", {"./Address.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Address.cjs","./Avatar.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Avatar.cjs","./Banner.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Banner.cjs","./Box.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Box.cjs","./Card.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Card.cjs","./Container.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Container.cjs","./Copyable.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Copyable.cjs","./Divider.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Divider.cjs","./Footer.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Footer.cjs","./Heading.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Heading.cjs","./Icon.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Icon.cjs","./Image.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Image.cjs","./Link.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Link.cjs","./Row.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Row.cjs","./Section.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Section.cjs","./Skeleton.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Skeleton.cjs","./Spinner.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Spinner.cjs","./Text.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Text.cjs","./Tooltip.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Tooltip.cjs","./Value.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\Value.cjs","./form/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\form\\index.cjs","./formatting/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\formatting\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Ccomponents%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
__exportStar(require("./form/index.cjs"), exports);
__exportStar(require("./formatting/index.cjs"), exports);
__exportStar(require("./Address.cjs"), exports);
__exportStar(require("./Avatar.cjs"), exports);
__exportStar(require("./Box.cjs"), exports);
__exportStar(require("./Card.cjs"), exports);
__exportStar(require("./Copyable.cjs"), exports);
__exportStar(require("./Divider.cjs"), exports);
__exportStar(require("./Value.cjs"), exports);
__exportStar(require("./Heading.cjs"), exports);
__exportStar(require("./Icon.cjs"), exports);
__exportStar(require("./Image.cjs"), exports);
__exportStar(require("./Link.cjs"), exports);
__exportStar(require("./Row.cjs"), exports);
__exportStar(require("./Spinner.cjs"), exports);
__exportStar(require("./Text.cjs"), exports);
__exportStar(require("./Tooltip.cjs"), exports);
__exportStar(require("./Footer.cjs"), exports);
__exportStar(require("./Container.cjs"), exports);
__exportStar(require("./Section.cjs"), exports);
__exportStar(require("./Banner.cjs"), exports);
__exportStar(require("./Skeleton.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\index.cjs", {"./component.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\component.cjs","./components/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\index.cjs","./jsx-dev-runtime.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\jsx-dev-runtime.cjs","./jsx-runtime.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\jsx-runtime.cjs","./validation.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\validation.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldChildUnionStruct = exports.FormChildStruct = exports.BoxChildStruct = exports.assertJSXElement = exports.isJSXElementUnsafe = exports.isJSXElement = exports.RootJSXElementStruct = exports.JSXElementStruct = void 0;
__exportStar(require("./component.cjs"), exports);
__exportStar(require("./components/index.cjs"), exports);
__exportStar(require("./jsx-runtime.cjs"), exports);
__exportStar(require("./jsx-dev-runtime.cjs"), exports);
var validation_1 = require("./validation.cjs");
Object.defineProperty(exports, "JSXElementStruct", {
  enumerable: true,
  get: function () {
    return validation_1.JSXElementStruct;
  }
});
Object.defineProperty(exports, "RootJSXElementStruct", {
  enumerable: true,
  get: function () {
    return validation_1.RootJSXElementStruct;
  }
});
Object.defineProperty(exports, "isJSXElement", {
  enumerable: true,
  get: function () {
    return validation_1.isJSXElement;
  }
});
Object.defineProperty(exports, "isJSXElementUnsafe", {
  enumerable: true,
  get: function () {
    return validation_1.isJSXElementUnsafe;
  }
});
Object.defineProperty(exports, "assertJSXElement", {
  enumerable: true,
  get: function () {
    return validation_1.assertJSXElement;
  }
});
Object.defineProperty(exports, "BoxChildStruct", {
  enumerable: true,
  get: function () {
    return validation_1.BoxChildStruct;
  }
});
Object.defineProperty(exports, "FormChildStruct", {
  enumerable: true,
  get: function () {
    return validation_1.FormChildStruct;
  }
});
Object.defineProperty(exports, "FieldChildUnionStruct", {
  enumerable: true,
  get: function () {
    return validation_1.FieldChildUnionStruct;
  }
});

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\jsx-dev-runtime.cjs", {"./jsx-runtime.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\jsx-runtime.cjs","./validation.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\validation.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Cjsx-dev-runtime.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jsxDEV = void 0;
const jsx_runtime_1 = require("./jsx-runtime.cjs");
const validation_1 = require("./validation.cjs");
/**
 * The JSX runtime for Snaps SDK components. This function is used to render
 * Snap components into a format that can be used by the Snaps.
 *
 * This is the "development" version of the runtime, which includes additional
 * validation, which is otherwise handled by MetaMask. To use this runtime,
 * specify `@metamask/snaps-sdk` as import source for JSX, and use
 * `react-jsxdev` as the pragma.
 *
 * @param component - The component to render.
 * @param props - The props to pass to the component.
 * @param key - The key of the component.
 * @returns The rendered component.
 * @see https://www.typescriptlang.org/tsconfig/#jsx
 */
function jsxDEV(component, props, key) {
  const element = (0, jsx_runtime_1.jsx)(component, props, key);
  (0, validation_1.assertJSXElement)(element);
  return element;
}
exports.jsxDEV = jsxDEV;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\jsx-dev-runtime.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\jsx-runtime.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Cjsx-runtime.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jsxs = exports.jsx = void 0;
/**
 * The JSX runtime for Snaps SDK components. This function is used to render
 * Snap components into a format that can be used by the Snaps.
 *
 * This is the "production" version of the runtime, which does not include
 * additional validation, as it is handled by MetaMask. To use this runtime,
 * specify `@metamask/snaps-sdk` as import source for JSX, and use `react-jsx`
 * as the pragma.
 *
 * @param component - The component to render.
 * @param props - The props to pass to the component.
 * @param key - The key of the component.
 * @returns The rendered component.
 * @see https://www.typescriptlang.org/tsconfig/#jsx
 */
function jsx(component, props, key) {
  if (typeof component === 'string') {
    // If component is a string, it is a built-in HTML element. This is not
    // supported in Snaps, so we throw an error.
    throw new Error(`An HTML element ("${String(component)}") was used in a Snap component, which is not supported by Snaps UI. Please use one of the supported Snap components.`);
  }
  if (!component) {
    // If component is undefined, a JSX fragment `<>...</>` was used, which is
    // not supported in Snaps.
    throw new Error('A JSX fragment was used in a Snap component, which is not supported by Snaps UI. Please use one of the supported Snap components.');
  }
  return component({
    ...props,
    key
  });
}
exports.jsx = jsx;
/**
 * The JSX runtime for Snaps SDK components. This function is used to render
 * Snap components into a format that can be used by the Snaps.
 *
 * The `jsxs` function is used for rendering nested components.
 *
 * This is the "production" version of the runtime, which does not include
 * additional validation, as it is handled by MetaMask. To use this runtime,
 * specify `@metamask/snaps-sdk` as import source for JSX, and use `react-jsx`
 * as the pragma.
 *
 * @param component - The component to render.
 * @param props - The props to pass to the component.
 * @param key - The key of the component.
 * @returns The rendered component.
 * @see https://www.typescriptlang.org/tsconfig/#jsx
 */
function jsxs(component, props, key) {
  return jsx(component, props, key);
}
exports.jsxs = jsxs;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\jsx-runtime.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\validation.cjs", {"../internals/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\internals\\index.cjs","../types/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\index.cjs","./components/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\components\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cjsx%5Cvalidation.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RowStruct = exports.BannerStruct = exports.TooltipStruct = exports.TooltipContentStruct = exports.TooltipChildStruct = exports.ValueStruct = exports.TextStruct = exports.SkeletonStruct = exports.LinkStruct = exports.HeadingStruct = exports.DividerStruct = exports.CopyableStruct = exports.FooterStruct = exports.FooterChildStruct = exports.SectionStruct = exports.FormStruct = exports.FormChildStruct = exports.BoxStruct = exports.BoxChildrenStruct = exports.AvatarStruct = exports.FormattingStruct = exports.ItalicStruct = exports.BoldStruct = exports.FieldStruct = exports.FieldChildUnionStruct = exports.FileInputStruct = exports.RadioGroupStruct = exports.RadioStruct = exports.AssetSelectorStruct = exports.SelectorStruct = exports.SelectorOptionStruct = exports.CardStruct = exports.AccountSelectorStruct = exports.AddressStruct = exports.DropdownStruct = exports.OptionStruct = exports.AddressInputStruct = exports.InputStruct = exports.NumberInputPropsStruct = exports.PasswordInputPropsStruct = exports.TextInputPropsStruct = exports.GenericInputPropsStruct = exports.CheckboxStruct = exports.ButtonStruct = exports.IconStruct = exports.ImageStruct = exports.BorderRadiusStruct = exports.ElementStruct = exports.StringElementStruct = exports.KeyStruct = void 0;
exports.assertJSXElement = exports.isJSXElementUnsafe = exports.isJSXElement = exports.JSXElementStruct = exports.RootJSXElementStruct = exports.ContainerStruct = exports.BoxChildStruct = exports.SpinnerStruct = void 0;
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const components_1 = require("./components/index.cjs");
const internals_1 = require("../internals/index.cjs");
const types_1 = require("../types/index.cjs");
/**
 * A struct for the {@link Key} type.
 */
exports.KeyStruct = (0, internals_1.nullUnion)([(0, superstruct_1.string)(), (0, superstruct_1.number)()]);
/**
 * A struct for the {@link StringElement} type.
 */
exports.StringElementStruct = children([(0, superstruct_1.string)()]);
/**
 * A struct for the {@link GenericSnapElement} type.
 */
exports.ElementStruct = (0, superstruct_1.object)({
  type: (0, superstruct_1.string)(),
  props: (0, superstruct_1.record)((0, superstruct_1.string)(), utils_1.JsonStruct),
  key: (0, superstruct_1.nullable)(exports.KeyStruct)
});
/**
 * A helper function for creating a struct for a {@link Nestable} type.
 *
 * @param struct - The struct for the type to test.
 * @returns The struct for the nestable type.
 */
function nestable(struct) {
  const nestableStruct = (0, internals_1.selectiveUnion)(value => {
    if (Array.isArray(value)) {
      return (0, superstruct_1.array)((0, superstruct_1.lazy)(() => nestableStruct));
    }
    return struct;
  });
  return nestableStruct;
}
/**
 * A helper function for creating a struct which allows children of a specific
 * type, as well as `null` and `boolean`.
 *
 * @param structs - The structs to allow as children.
 * @returns The struct for the children.
 */
function children(structs) {
  const potentialUnion = structs.length === 1 ? structs[0] : (0, internals_1.nullUnion)(structs);
  return nestable((0, superstruct_1.nullable)((0, internals_1.selectiveUnion)(value => {
    if (typeof value === 'boolean') {
      return (0, superstruct_1.boolean)();
    }
    return potentialUnion;
  })));
}
/**
 * A helper function for creating a struct which allows a single child of a specific
 * type, as well as `null` and `boolean`.
 *
 * @param struct - The struct to allow as a single child.
 * @returns The struct for the children.
 */
function singleChild(struct) {
  return (0, superstruct_1.nullable)((0, internals_1.selectiveUnion)(value => {
    if (typeof value === 'boolean') {
      return (0, superstruct_1.boolean)();
    }
    return struct;
  }));
}
/**
 * A helper function for creating a struct for a JSX element.
 *
 * @param name - The name of the element.
 * @param props - The props of the element.
 * @returns The struct for the element.
 */
function element(name, props = {}) {
  return (0, superstruct_1.object)({
    type: (0, internals_1.literal)(name),
    props: (0, superstruct_1.object)(props),
    key: (0, superstruct_1.nullable)(exports.KeyStruct)
  });
}
/**
 * A helper function for creating a struct for a JSX element with selective props.
 *
 * @param name - The name of the element.
 * @param selector - The selector function choosing the struct to validate with.
 * @returns The struct for the element.
 */
function elementWithSelectiveProps(name, selector) {
  return (0, superstruct_1.object)({
    type: (0, internals_1.literal)(name),
    props: (0, internals_1.selectiveUnion)(selector),
    key: (0, superstruct_1.nullable)(exports.KeyStruct)
  });
}
/**
 * Shared struct used to validate border radius values used by various Snaps components.
 */
exports.BorderRadiusStruct = (0, internals_1.nullUnion)([(0, internals_1.literal)('none'), (0, internals_1.literal)('medium'), (0, internals_1.literal)('full')]);
/**
 * A struct for the {@link ImageElement} type.
 */
exports.ImageStruct = element('Image', {
  src: (0, internals_1.svg)(),
  alt: (0, superstruct_1.optional)((0, superstruct_1.string)()),
  borderRadius: (0, superstruct_1.optional)(exports.BorderRadiusStruct)
});
const IconNameStruct = (0, internals_1.nullUnion)(Object.values(components_1.IconName).map(name => (0, internals_1.literal)(name)));
/**
 * A struct for the {@link IconElement} type.
 */
exports.IconStruct = element('Icon', {
  name: IconNameStruct,
  color: (0, superstruct_1.optional)((0, internals_1.nullUnion)([(0, internals_1.literal)('default'), (0, internals_1.literal)('primary'), (0, internals_1.literal)('muted')])),
  size: (0, superstruct_1.optional)((0, internals_1.nullUnion)([(0, internals_1.literal)('md'), (0, internals_1.literal)('inherit')]))
});
/**
 * A struct for the {@link ButtonElement} type.
 */
exports.ButtonStruct = element('Button', {
  children: children([exports.StringElementStruct, exports.ImageStruct, exports.IconStruct]),
  name: (0, superstruct_1.optional)((0, superstruct_1.string)()),
  type: (0, superstruct_1.optional)((0, internals_1.nullUnion)([(0, internals_1.literal)('button'), (0, internals_1.literal)('submit')])),
  variant: (0, superstruct_1.optional)((0, internals_1.nullUnion)([(0, internals_1.literal)('primary'), (0, internals_1.literal)('destructive')])),
  size: (0, superstruct_1.optional)((0, internals_1.nullUnion)([(0, internals_1.literal)('sm'), (0, internals_1.literal)('md')])),
  disabled: (0, superstruct_1.optional)((0, superstruct_1.boolean)()),
  loading: (0, superstruct_1.optional)((0, superstruct_1.boolean)()),
  form: (0, superstruct_1.optional)((0, superstruct_1.string)())
});
/**
 * A struct for the {@link CheckboxElement} type.
 */
exports.CheckboxStruct = element('Checkbox', {
  name: (0, superstruct_1.string)(),
  checked: (0, superstruct_1.optional)((0, superstruct_1.boolean)()),
  label: (0, superstruct_1.optional)((0, superstruct_1.string)()),
  variant: (0, superstruct_1.optional)((0, internals_1.nullUnion)([(0, internals_1.literal)('default'), (0, internals_1.literal)('toggle')])),
  disabled: (0, superstruct_1.optional)((0, superstruct_1.boolean)())
});
/**
 * A struct for the generic input element props.
 */
exports.GenericInputPropsStruct = (0, superstruct_1.object)({
  name: (0, superstruct_1.string)(),
  value: (0, superstruct_1.optional)((0, superstruct_1.string)()),
  placeholder: (0, superstruct_1.optional)((0, superstruct_1.string)()),
  disabled: (0, superstruct_1.optional)((0, superstruct_1.boolean)())
});
/**
 * A struct for the text type input props.
 */
exports.TextInputPropsStruct = (0, superstruct_1.assign)(exports.GenericInputPropsStruct, (0, superstruct_1.object)({
  type: (0, internals_1.literal)('text')
}));
/**
 * A struct for the password type input props.
 */
exports.PasswordInputPropsStruct = (0, superstruct_1.assign)(exports.GenericInputPropsStruct, (0, superstruct_1.object)({
  type: (0, internals_1.literal)('password')
}));
/**
 * A struct for the number type input props.
 */
exports.NumberInputPropsStruct = (0, superstruct_1.assign)(exports.GenericInputPropsStruct, (0, superstruct_1.object)({
  type: (0, internals_1.literal)('number'),
  min: (0, superstruct_1.optional)((0, superstruct_1.number)()),
  max: (0, superstruct_1.optional)((0, superstruct_1.number)()),
  step: (0, superstruct_1.optional)((0, superstruct_1.number)())
}));
/**
 * A struct for the {@link InputElement} type.
 */
exports.InputStruct = elementWithSelectiveProps('Input', value => {
  if ((0, utils_1.isPlainObject)(value) && (0, utils_1.hasProperty)(value, 'type')) {
    switch (value.type) {
      case 'text':
        return exports.TextInputPropsStruct;
      case 'password':
        return exports.PasswordInputPropsStruct;
      case 'number':
        return exports.NumberInputPropsStruct;
      default:
        return exports.GenericInputPropsStruct;
    }
  }
  return exports.GenericInputPropsStruct;
});
/**
 * A struct for the {@link AddressInputElement} type.
 */
exports.AddressInputStruct = element('AddressInput', {
  name: (0, superstruct_1.string)(),
  chainId: utils_1.CaipChainIdStruct,
  value: (0, superstruct_1.optional)((0, superstruct_1.string)()),
  placeholder: (0, superstruct_1.optional)((0, superstruct_1.string)()),
  disabled: (0, superstruct_1.optional)((0, superstruct_1.boolean)()),
  displayAvatar: (0, superstruct_1.optional)((0, superstruct_1.boolean)())
});
/**
 * A struct for the {@link OptionElement} type.
 */
exports.OptionStruct = element('Option', {
  value: (0, superstruct_1.string)(),
  children: (0, superstruct_1.string)(),
  disabled: (0, superstruct_1.optional)((0, superstruct_1.boolean)())
});
/**
 * A struct for the {@link DropdownElement} type.
 */
exports.DropdownStruct = element('Dropdown', {
  name: (0, superstruct_1.string)(),
  value: (0, superstruct_1.optional)((0, superstruct_1.string)()),
  children: children([exports.OptionStruct]),
  disabled: (0, superstruct_1.optional)((0, superstruct_1.boolean)())
});
/**
 * A struct for the {@link AddressElement} type.
 */
exports.AddressStruct = element('Address', {
  address: (0, internals_1.selectiveUnion)(value => {
    if (typeof value === 'string' && value.startsWith('0x')) {
      return utils_1.HexChecksumAddressStruct;
    }
    return utils_1.CaipAccountIdStruct;
  }),
  truncate: (0, superstruct_1.optional)((0, superstruct_1.boolean)()),
  displayName: (0, superstruct_1.optional)((0, superstruct_1.boolean)()),
  avatar: (0, superstruct_1.optional)((0, superstruct_1.boolean)())
});
/**
 * A struct for the {@link AccountSelectorElement} type.
 */
exports.AccountSelectorStruct = element('AccountSelector', {
  name: (0, superstruct_1.string)(),
  hideExternalAccounts: (0, superstruct_1.optional)((0, superstruct_1.boolean)()),
  chainIds: (0, superstruct_1.optional)((0, superstruct_1.array)(utils_1.CaipChainIdStruct)),
  switchGlobalAccount: (0, superstruct_1.optional)((0, superstruct_1.boolean)()),
  value: (0, superstruct_1.optional)(utils_1.CaipAccountIdStruct),
  disabled: (0, superstruct_1.optional)((0, superstruct_1.boolean)())
});
/**
 * A struct for the {@link CardElement} type.
 */
exports.CardStruct = element('Card', {
  image: (0, superstruct_1.optional)((0, superstruct_1.string)()),
  title: (0, internals_1.selectiveUnion)(value => {
    if (typeof value === 'object') {
      return exports.AddressStruct;
    }
    return (0, superstruct_1.string)();
  }),
  description: (0, superstruct_1.optional)((0, superstruct_1.string)()),
  value: (0, superstruct_1.string)(),
  extra: (0, superstruct_1.optional)((0, superstruct_1.string)())
});
/**
 * A struct for the {@link SelectorOptionElement} type.
 */
exports.SelectorOptionStruct = element('SelectorOption', {
  value: (0, superstruct_1.string)(),
  children: exports.CardStruct,
  disabled: (0, superstruct_1.optional)((0, superstruct_1.boolean)())
});
/**
 * A struct for the {@link SelectorElement} type.
 */
exports.SelectorStruct = element('Selector', {
  name: (0, superstruct_1.string)(),
  title: (0, superstruct_1.string)(),
  value: (0, superstruct_1.optional)((0, superstruct_1.string)()),
  children: children([exports.SelectorOptionStruct]),
  disabled: (0, superstruct_1.optional)((0, superstruct_1.boolean)())
});
/**
 * A struct for the {@link AssetSelectorElement} type.
 */
exports.AssetSelectorStruct = element('AssetSelector', {
  name: (0, superstruct_1.string)(),
  addresses: types_1.NonEip155CaipAccountIdsMatchedByAddressAndNamespaceStruct,
  chainIds: (0, superstruct_1.optional)((0, superstruct_1.array)(types_1.NonEip155ChainIdStruct)),
  value: (0, superstruct_1.optional)(types_1.NonEip155AssetTypeStruct),
  disabled: (0, superstruct_1.optional)((0, superstruct_1.boolean)())
});
/**
 * A struct for the {@link RadioElement} type.
 */
exports.RadioStruct = element('Radio', {
  value: (0, superstruct_1.string)(),
  children: (0, superstruct_1.string)(),
  disabled: (0, superstruct_1.optional)((0, superstruct_1.boolean)())
});
/**
 * A struct for the {@link RadioGroupElement} type.
 */
exports.RadioGroupStruct = element('RadioGroup', {
  name: (0, superstruct_1.string)(),
  value: (0, superstruct_1.optional)((0, superstruct_1.string)()),
  children: children([exports.RadioStruct]),
  disabled: (0, superstruct_1.optional)((0, superstruct_1.boolean)())
});
/**
 * A struct for the {@link FileInputElement} type.
 */
exports.FileInputStruct = element('FileInput', {
  name: (0, superstruct_1.string)(),
  accept: (0, internals_1.nullUnion)([(0, superstruct_1.optional)((0, superstruct_1.array)((0, superstruct_1.string)()))]),
  compact: (0, superstruct_1.optional)((0, superstruct_1.boolean)()),
  disabled: (0, superstruct_1.optional)((0, superstruct_1.boolean)())
});
/**
 * A subset of JSX elements that represent the tuple Box + Input of the Field children.
 */
const BOX_INPUT_LEFT = [
// eslint-disable-next-line @typescript-eslint/no-use-before-define
singleChild((0, superstruct_1.lazy)(() => exports.BoxChildStruct)), exports.InputStruct];
/**
 * A subset of JSX elements that represent the tuple Input + Box of the Field children.
 */
const BOX_INPUT_RIGHT = [exports.InputStruct,
// eslint-disable-next-line @typescript-eslint/no-use-before-define
singleChild((0, superstruct_1.lazy)(() => exports.BoxChildStruct))];
/**
 * A subset of JSX elements that represent the tuple Box + Input + Box of the Field children.
 */
const BOX_INPUT_BOTH = [
// eslint-disable-next-line @typescript-eslint/no-use-before-define
singleChild((0, superstruct_1.lazy)(() => exports.BoxChildStruct)), exports.InputStruct,
// eslint-disable-next-line @typescript-eslint/no-use-before-define
singleChild((0, superstruct_1.lazy)(() => exports.BoxChildStruct))];
/**
 * A subset of JSX elements that are allowed as single children of the Field component.
 */
const FIELD_CHILDREN_ARRAY = [exports.AssetSelectorStruct, exports.AddressInputStruct, exports.AccountSelectorStruct, exports.InputStruct, exports.DropdownStruct, exports.RadioGroupStruct, exports.FileInputStruct, exports.CheckboxStruct, exports.SelectorStruct];
/**
 * A union of the allowed children of the Field component.
 * This is mainly used in the simulator for validation purposes.
 */
exports.FieldChildUnionStruct = (0, internals_1.nullUnion)([...FIELD_CHILDREN_ARRAY, ...BOX_INPUT_LEFT, ...BOX_INPUT_RIGHT, ...BOX_INPUT_BOTH]);
/**
 * A subset of JSX elements that are allowed as children of the Field component.
 */
const FieldChildStruct = (0, internals_1.selectiveUnion)(value => {
  const isArray = Array.isArray(value);
  if (isArray && value.length === 3) {
    return (0, superstruct_1.tuple)(BOX_INPUT_BOTH);
  }
  if (isArray && value.length === 2) {
    var _value$;
    return ((_value$ = value[0]) === null || _value$ === void 0 ? void 0 : _value$.type) === 'Box' ? (0, superstruct_1.tuple)(BOX_INPUT_LEFT) : (0, superstruct_1.tuple)(BOX_INPUT_RIGHT);
  }
  return (0, internals_1.typedUnion)(FIELD_CHILDREN_ARRAY);
});
/**
 * A struct for the {@link FieldElement} type.
 */
exports.FieldStruct = element('Field', {
  label: (0, superstruct_1.optional)((0, superstruct_1.string)()),
  error: (0, superstruct_1.optional)((0, superstruct_1.string)()),
  children: FieldChildStruct
});
/**
 * A struct for the {@link BoldElement} type.
 */
exports.BoldStruct = element('Bold', {
  children: children([(0, internals_1.selectiveUnion)(value => {
    if (typeof value === 'string') {
      return (0, superstruct_1.string)();
    }
    // eslint-disable-next-line @typescript-eslint/no-use-before-define
    return exports.ItalicStruct;
  })])
});
/**
 * A struct for the {@link ItalicElement} type.
 */
exports.ItalicStruct = element('Italic', {
  children: children([(0, internals_1.selectiveUnion)(value => {
    if (typeof value === 'string') {
      return (0, superstruct_1.string)();
    }
    return exports.BoldStruct;
  })])
});
exports.FormattingStruct = (0, internals_1.typedUnion)([exports.BoldStruct, exports.ItalicStruct]);
/**
 * A struct for the {@link AvatarElement} type.
 */
exports.AvatarStruct = element('Avatar', {
  address: utils_1.CaipAccountIdStruct,
  size: (0, superstruct_1.optional)((0, internals_1.nullUnion)([(0, internals_1.literal)('sm'), (0, internals_1.literal)('md'), (0, internals_1.literal)('lg')]))
});
exports.BoxChildrenStruct = children(
// eslint-disable-next-line @typescript-eslint/no-use-before-define
[(0, superstruct_1.lazy)(() => exports.BoxChildStruct)]);
/**
 * A struct for the {@link BoxElement} type.
 */
exports.BoxStruct = element('Box', {
  children: exports.BoxChildrenStruct,
  direction: (0, superstruct_1.optional)((0, internals_1.nullUnion)([(0, internals_1.literal)('horizontal'), (0, internals_1.literal)('vertical')])),
  alignment: (0, superstruct_1.optional)((0, internals_1.nullUnion)([(0, internals_1.literal)('start'), (0, internals_1.literal)('center'), (0, internals_1.literal)('end'), (0, internals_1.literal)('space-between'), (0, internals_1.literal)('space-around')])),
  crossAlignment: (0, superstruct_1.optional)((0, internals_1.nullUnion)([(0, internals_1.literal)('start'), (0, internals_1.literal)('center'), (0, internals_1.literal)('end')])),
  center: (0, superstruct_1.optional)((0, superstruct_1.boolean)())
});
/**
 * A subset of JSX elements that are allowed as children of the Form component.
 */
exports.FormChildStruct = exports.BoxChildrenStruct;
/**
 * A struct for the {@link FormElement} type.
 */
exports.FormStruct = element('Form', {
  children: exports.FormChildStruct,
  name: (0, superstruct_1.string)()
});
const FooterButtonStruct = (0, superstruct_1.refine)(exports.ButtonStruct, 'FooterButton', value => {
  if (typeof value.props.children === 'string' || typeof value.props.children === 'boolean' || value.props.children === null) {
    return true;
  }
  if (Array.isArray(value.props.children)) {
    const hasNonTextElements = value.props.children.some(child => typeof child !== 'string' && typeof child !== 'boolean' && child !== null);
    if (!hasNonTextElements) {
      return true;
    }
  }
  return 'Footer buttons may only contain text.';
});
/**
 * A struct for the {@link SectionElement} type.
 */
exports.SectionStruct = element('Section', {
  children: exports.BoxChildrenStruct,
  direction: (0, superstruct_1.optional)((0, internals_1.nullUnion)([(0, internals_1.literal)('horizontal'), (0, internals_1.literal)('vertical')])),
  alignment: (0, superstruct_1.optional)((0, internals_1.nullUnion)([(0, internals_1.literal)('start'), (0, internals_1.literal)('center'), (0, internals_1.literal)('end'), (0, internals_1.literal)('space-between'), (0, internals_1.literal)('space-around')]))
});
/**
 * A subset of JSX elements that are allowed as children of the Footer component.
 * This set should include a single button or a tuple of two buttons.
 */
exports.FooterChildStruct = (0, internals_1.selectiveUnion)(value => {
  if (Array.isArray(value)) {
    return (0, superstruct_1.tuple)([FooterButtonStruct, FooterButtonStruct]);
  }
  return FooterButtonStruct;
});
/**
 * A struct for the {@link FooterElement} type.
 */
exports.FooterStruct = element('Footer', {
  children: exports.FooterChildStruct
});
/**
 * A struct for the {@link CopyableElement} type.
 */
exports.CopyableStruct = element('Copyable', {
  value: (0, superstruct_1.string)(),
  sensitive: (0, superstruct_1.optional)((0, superstruct_1.boolean)())
});
/**
 * A struct for the {@link DividerElement} type.
 */
exports.DividerStruct = element('Divider');
/**
 * A struct for the {@link HeadingElement} type.
 */
exports.HeadingStruct = element('Heading', {
  children: exports.StringElementStruct,
  size: (0, superstruct_1.optional)((0, internals_1.nullUnion)([(0, internals_1.literal)('sm'), (0, internals_1.literal)('md'), (0, internals_1.literal)('lg')]))
});
/**
 * A struct for the {@link LinkElement} type.
 */
exports.LinkStruct = element('Link', {
  href: (0, superstruct_1.string)(),
  children: children([(0, internals_1.selectiveUnion)(value => {
    if (typeof value === 'string') {
      return (0, superstruct_1.string)();
    }
    return (0, internals_1.typedUnion)([exports.FormattingStruct, exports.IconStruct, exports.ImageStruct, exports.AddressStruct]);
  })])
});
/**
 * A struct for the {@link SkeletonElement} type.
 */
exports.SkeletonStruct = element('Skeleton', {
  width: (0, superstruct_1.optional)((0, superstruct_1.union)([(0, superstruct_1.number)(), (0, superstruct_1.string)()])),
  height: (0, superstruct_1.optional)((0, superstruct_1.union)([(0, superstruct_1.number)(), (0, superstruct_1.string)()])),
  borderRadius: (0, superstruct_1.optional)(exports.BorderRadiusStruct)
});
/**
 * A struct for the {@link TextElement} type.
 */
exports.TextStruct = element('Text', {
  children: children([(0, internals_1.selectiveUnion)(value => {
    if (typeof value === 'string') {
      return (0, superstruct_1.string)();
    }
    return (0, internals_1.typedUnion)([exports.BoldStruct, exports.ItalicStruct, exports.LinkStruct, exports.IconStruct, exports.SkeletonStruct]);
  })]),
  alignment: (0, superstruct_1.optional)((0, internals_1.nullUnion)([(0, internals_1.literal)('start'), (0, internals_1.literal)('center'), (0, internals_1.literal)('end')])),
  color: (0, superstruct_1.optional)((0, internals_1.nullUnion)([(0, internals_1.literal)('default'), (0, internals_1.literal)('alternative'), (0, internals_1.literal)('muted'), (0, internals_1.literal)('error'), (0, internals_1.literal)('success'), (0, internals_1.literal)('warning')])),
  size: (0, superstruct_1.optional)((0, internals_1.nullUnion)([(0, internals_1.literal)('sm'), (0, internals_1.literal)('md')])),
  fontWeight: (0, superstruct_1.optional)((0, internals_1.nullUnion)([(0, internals_1.literal)('regular'), (0, internals_1.literal)('medium'), (0, internals_1.literal)('bold')]))
});
/**
 * A struct for the {@link ValueElement} type.
 */
exports.ValueStruct = element('Value', {
  value: (0, internals_1.selectiveUnion)(value => {
    if (typeof value === 'string') {
      return (0, superstruct_1.string)();
    }
    return exports.TextStruct;
  }),
  extra: (0, internals_1.selectiveUnion)(value => {
    if (typeof value === 'string') {
      return (0, superstruct_1.string)();
    }
    return exports.TextStruct;
  })
});
/**
 * A subset of JSX elements that are allowed as children of the Tooltip component.
 * This set should include all text components and the Image.
 */
exports.TooltipChildStruct = (0, internals_1.selectiveUnion)(value => {
  if (typeof value === 'boolean') {
    return (0, superstruct_1.boolean)();
  }
  return (0, internals_1.typedUnion)([exports.TextStruct, exports.BoldStruct, exports.ItalicStruct, exports.LinkStruct, exports.ImageStruct, exports.IconStruct]);
});
/**
 * A subset of JSX elements that are allowed as content of the Tooltip component.
 * This set should include all text components.
 */
exports.TooltipContentStruct = (0, internals_1.selectiveUnion)(value => {
  if (typeof value === 'string') {
    return (0, superstruct_1.string)();
  }
  return (0, internals_1.typedUnion)([exports.TextStruct, exports.BoldStruct, exports.ItalicStruct, exports.LinkStruct, exports.IconStruct]);
});
/**
 * A struct for the {@link TooltipElement} type.
 */
exports.TooltipStruct = element('Tooltip', {
  children: (0, superstruct_1.nullable)(exports.TooltipChildStruct),
  content: exports.TooltipContentStruct
});
/**
 * A struct for the {@link BannerElement} type.
 */
exports.BannerStruct = element('Banner', {
  children: children([(0, internals_1.typedUnion)([exports.TextStruct, exports.LinkStruct, exports.IconStruct, exports.ButtonStruct, exports.BoldStruct, exports.ItalicStruct, exports.SkeletonStruct])]),
  title: (0, superstruct_1.string)(),
  severity: (0, superstruct_1.union)([(0, internals_1.literal)('danger'), (0, internals_1.literal)('info'), (0, internals_1.literal)('success'), (0, internals_1.literal)('warning')])
});
/**
 * A struct for the {@link RowElement} type.
 */
exports.RowStruct = element('Row', {
  label: (0, superstruct_1.string)(),
  children: (0, superstruct_1.lazy)(() =>
  // eslint-disable-next-line @typescript-eslint/no-use-before-define
  (0, internals_1.typedUnion)([exports.ValueStruct, exports.BoxChildStruct])),
  variant: (0, superstruct_1.optional)((0, internals_1.nullUnion)([(0, internals_1.literal)('default'), (0, internals_1.literal)('warning'), (0, internals_1.literal)('critical')])),
  tooltip: (0, superstruct_1.optional)((0, superstruct_1.string)())
});
/**
 * A struct for the {@link SpinnerElement} type.
 */
exports.SpinnerStruct = element('Spinner');
/**
 * A subset of JSX elements that are allowed as children of the Box component.
 * This set includes all components, except components that need to be nested in
 * another component (e.g., Field must be contained in a Form).
 */
exports.BoxChildStruct = (0, internals_1.typedUnion)([exports.AccountSelectorStruct, exports.AddressStruct, exports.AssetSelectorStruct, exports.AddressInputStruct, exports.BoldStruct, exports.BoxStruct, exports.ButtonStruct, exports.CopyableStruct, exports.DividerStruct, exports.DropdownStruct, exports.RadioGroupStruct, exports.FieldStruct, exports.FileInputStruct, exports.FormStruct, exports.HeadingStruct, exports.InputStruct, exports.ImageStruct, exports.ItalicStruct, exports.LinkStruct, exports.RowStruct, exports.SpinnerStruct, exports.TextStruct, exports.TooltipStruct, exports.CheckboxStruct, exports.CardStruct, exports.IconStruct, exports.SelectorStruct, exports.SectionStruct, exports.AvatarStruct, exports.BannerStruct, exports.SkeletonStruct]);
/**
 * A struct for the {@link ContainerElement} type.
 */
exports.ContainerStruct = element('Container', {
  children: (0, internals_1.selectiveUnion)(value => {
    if (Array.isArray(value)) {
      return (0, superstruct_1.tuple)([exports.BoxChildStruct, exports.FooterStruct]);
    }
    return exports.BoxChildStruct;
  }),
  backgroundColor: (0, superstruct_1.optional)((0, internals_1.nullUnion)([(0, internals_1.literal)('default'), (0, internals_1.literal)('alternative')]))
});
/**
 * For now, the allowed JSX elements at the root are the same as the allowed
 * children of the Box component.
 */
exports.RootJSXElementStruct = (0, internals_1.typedUnion)([exports.BoxChildStruct, exports.ContainerStruct]);
/**
 * A struct for the {@link JSXElement} type.
 */
exports.JSXElementStruct = (0, internals_1.typedUnion)([exports.AssetSelectorStruct, exports.AddressInputStruct, exports.AccountSelectorStruct, exports.ButtonStruct, exports.InputStruct, exports.FileInputStruct, exports.FieldStruct, exports.FormStruct, exports.BoldStruct, exports.ItalicStruct, exports.AddressStruct, exports.BoxStruct, exports.CopyableStruct, exports.DividerStruct, exports.HeadingStruct, exports.ImageStruct, exports.LinkStruct, exports.RowStruct, exports.SpinnerStruct, exports.TextStruct, exports.DropdownStruct, exports.OptionStruct, exports.RadioGroupStruct, exports.RadioStruct, exports.ValueStruct, exports.TooltipStruct, exports.CheckboxStruct, exports.FooterStruct, exports.ContainerStruct, exports.CardStruct, exports.IconStruct, exports.SelectorStruct, exports.SelectorOptionStruct, exports.SectionStruct, exports.AvatarStruct, exports.BannerStruct, exports.SkeletonStruct]);
/**
 * Check if a value is a JSX element.
 *
 * @param value - The value to check.
 * @returns True if the value is a JSX element, false otherwise.
 */
function isJSXElement(value) {
  return (0, superstruct_1.is)(value, exports.JSXElementStruct);
}
exports.isJSXElement = isJSXElement;
/**
 * Check if a value is a JSX element, without validating all of its contents.
 * This is useful when you want to validate the structure of a value, but not
 * all the children.
 *
 * This should only be used when you are sure that the value is safe to use,
 * i.e., after using {@link isJSXElement}.
 *
 * @param value - The value to check.
 * @returns True if the value is a JSX element, false otherwise.
 */
function isJSXElementUnsafe(value) {
  return (0, utils_1.isPlainObject)(value) && (0, utils_1.hasProperty)(value, 'type') && (0, utils_1.hasProperty)(value, 'props') && (0, utils_1.hasProperty)(value, 'key');
}
exports.isJSXElementUnsafe = isJSXElementUnsafe;
/**
 * Assert that a value is a JSX element.
 *
 * @param value - The value to check.
 * @throws If the value is not a JSX element.
 */
function assertJSXElement(value) {
  // TODO: We should use the error parsing utils from `snaps-utils` to improve
  // the error messages. It currently includes colours and potentially other
  // formatting that we might not want to include in the SDK.
  if (!isJSXElement(value)) {
    throw new Error(`Expected a JSX element, but received ${JSON.stringify(value)}. Please refer to the documentation for the supported JSX elements and their props.`);
  }
}
exports.assertJSXElement = assertJSXElement;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\validation.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\caip.cjs", {"@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Ctypes%5Ccaip.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NonEip155AssetTypeStruct = exports.NonEip155ChainIdStruct = exports.NonEip155CaipAccountIdsMatchedByAddressAndNamespaceStruct = void 0;
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
/**
 * A struct representing a list of non-EIP-155 CAIP-10 account IDs where the account addresses are the same.
 */
exports.NonEip155CaipAccountIdsMatchedByAddressAndNamespaceStruct = (0, superstruct_1.refine)((0, superstruct_1.array)(utils_1.CaipAccountIdStruct), 'Non-EIP-155 Matching Addresses Account ID List', value => {
  const parsedAccountIds = value.map(accountId => (0, utils_1.parseCaipAccountId)(accountId));
  if (!parsedAccountIds.every(({
    address,
    chain: {
      namespace
    }
  }) => address === parsedAccountIds[0].address && namespace === parsedAccountIds[0].chain.namespace)) {
    return 'All account IDs must have the same address and namespace.';
  }
  const containsEip155 = parsedAccountIds.some(({
    chain: {
      namespace
    }
  }) => {
    return namespace === utils_1.KnownCaipNamespace.Eip155;
  });
  if (containsEip155) {
    return 'All account IDs must have non-EIP-155 namespaces.';
  }
  return true;
});
/**
 * A struct representing a non-EIP-155 chain ID.
 */
exports.NonEip155ChainIdStruct = (0, superstruct_1.refine)(utils_1.CaipChainIdStruct, 'Non-EIP-155 Chain ID', value => {
  const {
    namespace
  } = (0, utils_1.parseCaipChainId)(value);
  if (namespace === utils_1.KnownCaipNamespace.Eip155) {
    return 'Chain ID must not be an EIP-155 chain ID.';
  }
  return true;
});
/**
 * A struct representing a non-EIP-155 asset type.
 */
exports.NonEip155AssetTypeStruct = (0, superstruct_1.refine)(utils_1.CaipAssetTypeStruct, 'Non-EIP-155 Asset Type', value => {
  const {
    chain: {
      namespace
    }
  } = (0, utils_1.parseCaipAssetType)(value);
  if (namespace === utils_1.KnownCaipNamespace.Eip155) {
    return 'Asset type must not be an EIP-155 asset type.';
  }
  return true;
});

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\types\\caip.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\global.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Ctypes%5Cglobal.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\types\\global.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\handlers\\assets-lookup.cjs", {"../../internals/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\internals\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Ctypes%5Chandlers%5Cassets-lookup.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnAssetsLookupResponseStruct = exports.AssetMetadataStruct = exports.NonFungibleAssetMetadataStruct = exports.NonFungibleAssetCollectionStruct = exports.FungibleAssetMetadataStruct = exports.AssetIconUrlStruct = exports.FungibleAssetUnitStruct = void 0;
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const internals_1 = require("../../internals/index.cjs");
exports.FungibleAssetUnitStruct = (0, superstruct_1.object)({
  name: (0, superstruct_1.optional)((0, superstruct_1.string)()),
  symbol: (0, superstruct_1.optional)((0, superstruct_1.string)()),
  decimals: (0, superstruct_1.number)()
});
exports.AssetIconUrlStruct = (0, superstruct_1.refine)((0, superstruct_1.string)(), 'Asset URL', value => {
  try {
    const url = new URL(value);
    // For now, we require asset URLs to either be base64 SVGs or remote HTTPS URLs
    (0, utils_1.assert)(url.protocol === 'https:' || value.startsWith('data:image/svg+xml;base64,'));
    return true;
  } catch {
    return 'Invalid URL';
  }
});
/**
 * A struct representing the metadata for a fungible asset.
 *
 * @property name - The name of the asset, if available.
 * @property symbol - The symbol of the asset, if available.
 * @property fungible - Indicates that this is a fungible asset. This is always `
 * true` for fungible assets.
 * @property iconUrl - The URL of the asset's icon, which can be a base64 SVG or a remote HTTPS URL.
 * @property units - An array of units for the asset, each represented by {@link FungibleAssetUnitStruct}.
 */
exports.FungibleAssetMetadataStruct = (0, superstruct_1.object)({
  name: (0, superstruct_1.optional)((0, superstruct_1.string)()),
  symbol: (0, superstruct_1.optional)((0, superstruct_1.string)()),
  fungible: (0, superstruct_1.literal)(true),
  iconUrl: exports.AssetIconUrlStruct,
  units: (0, superstruct_1.size)((0, superstruct_1.array)(exports.FungibleAssetUnitStruct), 1, Infinity)
});
/**
 * A collection of non-fungible assets, which can be used to group
 * assets that share a common theme or creator.
 *
 * @property name - The name of the collection.
 * @property address - The CAIP-10 account ID of the collection's creator.
 * @property symbol - The symbol of the collection.
 * @property tokenCount - The number of tokens in the collection, if available.
 * @property creator - The CAIP-10 account ID of the collection's creator, if
 * available.
 * @property imageUrl - The URL of the collection's image.
 */
exports.NonFungibleAssetCollectionStruct = (0, superstruct_1.object)({
  name: (0, superstruct_1.string)(),
  address: utils_1.CaipAccountIdStruct,
  symbol: (0, superstruct_1.string)(),
  tokenCount: (0, superstruct_1.optional)((0, superstruct_1.number)()),
  creator: (0, superstruct_1.optional)(utils_1.CaipAccountIdStruct),
  imageUrl: (0, superstruct_1.optional)(exports.AssetIconUrlStruct)
});
/**
 * A struct representing the metadata for a non-fungible asset.
 *
 * @property fungible - Indicates that this is a non-fungible asset.
 * This is always `false` for non-fungible assets.
 * @property name - The name of the asset, if available.
 * @property symbol - The symbol of the asset, if available.
 * @property imageUrl - The URL of the asset's image, which can be a base64 SVG or a remote HTTPS URL.
 * @property description - A description of the asset, if available.
 * @property acquiredAt - The timestamp when the asset was acquired, if available.
 * @property isPossibleSpam - Indicates if the asset is possibly spam, if available.
 * @property attributes - Additional attributes of the asset, represented as a record of string keys and
 * string or number values.
 * @property collection - The collection the asset belongs to, if available. See {@link NonFungibleAssetCollectionStruct}.
 */
exports.NonFungibleAssetMetadataStruct = (0, superstruct_1.object)({
  fungible: (0, superstruct_1.literal)(false),
  name: (0, superstruct_1.optional)((0, superstruct_1.string)()),
  symbol: (0, superstruct_1.optional)((0, superstruct_1.string)()),
  imageUrl: (0, superstruct_1.optional)(exports.AssetIconUrlStruct),
  description: (0, superstruct_1.optional)((0, superstruct_1.string)()),
  acquiredAt: (0, superstruct_1.optional)((0, superstruct_1.number)()),
  isPossibleSpam: (0, superstruct_1.optional)((0, superstruct_1.boolean)()),
  attributes: (0, superstruct_1.optional)((0, superstruct_1.record)((0, superstruct_1.string)(), (0, superstruct_1.union)([(0, superstruct_1.string)(), (0, superstruct_1.number)()]))),
  collection: (0, superstruct_1.optional)(exports.NonFungibleAssetCollectionStruct)
});
/**
 * A struct representing the metadata for an asset, which can be either
 * {@link FungibleAssetMetadataStruct} or {@link NonFungibleAssetMetadataStruct}.
 */
exports.AssetMetadataStruct = (0, internals_1.selectiveUnion)(metadata => {
  if ((0, utils_1.isObject)(metadata) && metadata.fungible) {
    return exports.FungibleAssetMetadataStruct;
  }
  return exports.NonFungibleAssetMetadataStruct;
});
/**
 * A struct representing the response of the `onAssetsLookup` method.
 *
 * @property assets - An object containing a mapping between the CAIP-19 key and a metadata object or null.
 */
exports.OnAssetsLookupResponseStruct = (0, superstruct_1.object)({
  assets: (0, superstruct_1.record)(utils_1.CaipAssetTypeOrIdStruct, (0, superstruct_1.nullable)(exports.AssetMetadataStruct))
});

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\types\\handlers\\assets-lookup.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\handlers\\index.cjs", {"./assets-lookup.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\handlers\\assets-lookup.cjs","./transaction.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\handlers\\transaction.cjs","./user-input.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\handlers\\user-input.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Ctypes%5Chandlers%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
__exportStar(require("./assets-lookup.cjs"), exports);
__exportStar(require("./transaction.cjs"), exports);
__exportStar(require("./user-input.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\types\\handlers\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\handlers\\transaction.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Ctypes%5Chandlers%5Ctransaction.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeverityLevel = void 0;
/**
 * The severity level of content being returned from a transaction insight.
 * Currently only one level is supported:
 *
 * - `critical` - The transaction is critical and should not be submitted by the
 * user.
 */
var SeverityLevel;
(function (SeverityLevel) {
  SeverityLevel["Critical"] = "critical";
})(SeverityLevel || (exports.SeverityLevel = SeverityLevel = {}));

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\types\\handlers\\transaction.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\handlers\\user-input.cjs", {"../../internals/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\internals\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Ctypes%5Chandlers%5Cuser-input.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserInputEventStruct = exports.FileUploadEventStruct = exports.InputChangeEventStruct = exports.FormSubmitEventStruct = exports.AssetSelectorStateStruct = exports.FileStruct = exports.AccountSelectorStateStruct = exports.ButtonClickEventStruct = exports.GenericEventStruct = exports.UserInputEventType = void 0;
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const internals_1 = require("../../internals/index.cjs");
/**
 * The type of user input event fired.
 * Currently only three events are supported:
 *
 * - `ButtonClickEvent` - A button has been clicked in the UI.
 * - `FormSubmitEvent` - A Form has been submitted in the UI.
 * - `InputChangeEvent` - The value of an input field has changed in the UI.
 * - `FileUploadEvent` - A file has been uploaded in the UI.
 */
var UserInputEventType;
(function (UserInputEventType) {
  UserInputEventType["ButtonClickEvent"] = "ButtonClickEvent";
  UserInputEventType["FormSubmitEvent"] = "FormSubmitEvent";
  UserInputEventType["InputChangeEvent"] = "InputChangeEvent";
  UserInputEventType["FileUploadEvent"] = "FileUploadEvent";
})(UserInputEventType || (exports.UserInputEventType = UserInputEventType = {}));
exports.GenericEventStruct = (0, superstruct_1.object)({
  type: (0, superstruct_1.string)(),
  name: (0, superstruct_1.optional)((0, superstruct_1.string)())
});
exports.ButtonClickEventStruct = (0, superstruct_1.assign)(exports.GenericEventStruct, (0, superstruct_1.object)({
  type: (0, internals_1.literal)(UserInputEventType.ButtonClickEvent),
  name: (0, superstruct_1.optional)((0, superstruct_1.string)())
}));
exports.AccountSelectorStateStruct = (0, superstruct_1.object)({
  accountId: (0, superstruct_1.string)(),
  addresses: (0, superstruct_1.array)(utils_1.CaipAccountIdStruct)
});
exports.FileStruct = (0, superstruct_1.object)({
  name: (0, superstruct_1.string)(),
  size: (0, superstruct_1.number)(),
  contentType: (0, superstruct_1.string)(),
  contents: (0, superstruct_1.string)()
});
exports.AssetSelectorStateStruct = (0, superstruct_1.object)({
  asset: utils_1.CaipAssetTypeStruct,
  name: (0, superstruct_1.string)(),
  symbol: (0, superstruct_1.string)()
});
exports.FormSubmitEventStruct = (0, superstruct_1.assign)(exports.GenericEventStruct, (0, superstruct_1.object)({
  type: (0, internals_1.literal)(UserInputEventType.FormSubmitEvent),
  value: (0, superstruct_1.record)((0, superstruct_1.string)(), (0, superstruct_1.nullable)((0, superstruct_1.union)([(0, superstruct_1.string)(), exports.FileStruct, (0, superstruct_1.boolean)(), exports.AccountSelectorStateStruct, exports.AssetSelectorStateStruct]))),
  name: (0, superstruct_1.string)()
}));
exports.InputChangeEventStruct = (0, superstruct_1.assign)(exports.GenericEventStruct, (0, superstruct_1.object)({
  type: (0, internals_1.literal)(UserInputEventType.InputChangeEvent),
  name: (0, superstruct_1.string)(),
  value: (0, superstruct_1.union)([(0, superstruct_1.string)(), (0, superstruct_1.boolean)(), exports.AccountSelectorStateStruct, exports.AssetSelectorStateStruct])
}));
exports.FileUploadEventStruct = (0, superstruct_1.assign)(exports.GenericEventStruct, (0, superstruct_1.object)({
  type: (0, internals_1.literal)(UserInputEventType.FileUploadEvent),
  name: (0, superstruct_1.string)(),
  file: (0, superstruct_1.nullable)(exports.FileStruct)
}));
exports.UserInputEventStruct = (0, internals_1.typedUnion)([exports.ButtonClickEventStruct, exports.FormSubmitEventStruct, exports.InputChangeEventStruct, exports.FileUploadEventStruct]);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\types\\handlers\\user-input.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\images.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Ctypes%5Cimages.cjs
      return function (require, module, exports) {
"use strict";

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\types\\images.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\index.cjs", {"./caip.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\caip.cjs","./global.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\global.cjs","./handlers/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\handlers\\index.cjs","./images.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\images.cjs","./interface.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\interface.cjs","./methods/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\methods\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Ctypes%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
// This is intentionally imported, rather than re-exported.
/* eslint-disable import-x/no-unassigned-import */
require("./global.cjs");
require("./images.cjs");
/* eslint-enable import-x/no-unassigned-import */
__exportStar(require("./caip.cjs"), exports);
__exportStar(require("./handlers/index.cjs"), exports);
__exportStar(require("./methods/index.cjs"), exports);
__exportStar(require("./interface.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\types\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\interface.cjs", {"../internals/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\internals\\index.cjs","../jsx/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\jsx\\index.cjs","../ui/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\ui\\index.cjs","./handlers/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\handlers\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Ctypes%5Cinterface.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentType = exports.InterfaceContextStruct = exports.ComponentOrElementStruct = exports.InterfaceStateStruct = exports.FormStateStruct = exports.StateStruct = void 0;
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const handlers_1 = require("./handlers/index.cjs");
const internals_1 = require("../internals/index.cjs");
const jsx_1 = require("../jsx/index.cjs");
const ui_1 = require("../ui/index.cjs");
/**
 * To avoid typing problems with the interface state when manipulating it we
 * have to differentiate the state of a form (that will be contained inside the
 * root state) and the root state since a key in the root stat can contain
 * either the value of an input or a sub-state of a form.
 */
exports.StateStruct = (0, superstruct_1.union)([handlers_1.AccountSelectorStateStruct, handlers_1.AssetSelectorStateStruct, handlers_1.FileStruct, (0, superstruct_1.string)(), (0, superstruct_1.boolean)(), utils_1.CaipAccountIdStruct]);
exports.FormStateStruct = (0, superstruct_1.record)((0, superstruct_1.string)(), (0, superstruct_1.nullable)(exports.StateStruct));
exports.InterfaceStateStruct = (0, superstruct_1.record)((0, superstruct_1.string)(), (0, superstruct_1.union)([exports.FormStateStruct, (0, superstruct_1.nullable)(exports.StateStruct)]));
exports.ComponentOrElementStruct = (0, internals_1.selectiveUnion)(value => {
  if ((0, utils_1.isObject)(value) && !(0, utils_1.hasProperty)(value, 'props')) {
    return ui_1.ComponentStruct;
  }
  return jsx_1.RootJSXElementStruct;
});
exports.InterfaceContextStruct = (0, superstruct_1.record)((0, superstruct_1.string)(), utils_1.JsonStruct);
var ContentType;
(function (ContentType) {
  ContentType["Insight"] = "Insight";
  ContentType["Dialog"] = "Dialog";
  ContentType["Notification"] = "Notification";
  ContentType["HomePage"] = "HomePage";
})(ContentType || (exports.ContentType = ContentType = {}));

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\types\\interface.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\methods\\dialog.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Ctypes%5Cmethods%5Cdialog.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DialogType = void 0;
/**
 * The type of dialog to display.
 *
 * - `alert` - A dialog with a single button.
 * - `confirmation` - A dialog with two buttons, one to confirm and one to
 * cancel.
 * - `prompt` - A dialog with two buttons and a text input.
 */
var DialogType;
(function (DialogType) {
  DialogType["Alert"] = "alert";
  DialogType["Confirmation"] = "confirmation";
  DialogType["Prompt"] = "prompt";
})(DialogType || (exports.DialogType = DialogType = {}));

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\types\\methods\\dialog.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\methods\\get-file.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Ctypes%5Cmethods%5Cget-file.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuxiliaryFileEncoding = void 0;
/**
 * The encoding to use when retrieving the file. Defaults to `Base64`.
 */
var AuxiliaryFileEncoding;
(function (AuxiliaryFileEncoding) {
  AuxiliaryFileEncoding["Base64"] = "base64";
  AuxiliaryFileEncoding["Hex"] = "hex";
  AuxiliaryFileEncoding["Utf8"] = "utf8";
})(AuxiliaryFileEncoding || (exports.AuxiliaryFileEncoding = AuxiliaryFileEncoding = {}));

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\types\\methods\\get-file.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\methods\\index.cjs", {"./dialog.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\methods\\dialog.cjs","./get-file.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\methods\\get-file.cjs","./manage-state.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\methods\\manage-state.cjs","./notify.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\methods\\notify.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Ctypes%5Cmethods%5Cindex.cjs
      return function (require, module, exports) {
"use strict";

var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", {
  value: true
});
__exportStar(require("./dialog.cjs"), exports);
__exportStar(require("./get-file.cjs"), exports);
__exportStar(require("./manage-state.cjs"), exports);
__exportStar(require("./notify.cjs"), exports);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\types\\methods\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\methods\\manage-state.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Ctypes%5Cmethods%5Cmanage-state.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageStateOperation = void 0;
/**
 * The operations that can be performed on the state.
 */
var ManageStateOperation;
(function (ManageStateOperation) {
  ManageStateOperation["ClearState"] = "clear";
  ManageStateOperation["GetState"] = "get";
  ManageStateOperation["UpdateState"] = "update";
})(ManageStateOperation || (exports.ManageStateOperation = ManageStateOperation = {}));

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\types\\methods\\manage-state.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\types\\methods\\notify.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Ctypes%5Cmethods%5Cnotify.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationType = void 0;
/**
 * The types of notifications that can be displayed.
 *
 * - `InApp` - A notification that is displayed in by the MetaMask extension.
 * - `Native` - A notification that is displayed by the operating system.
 */
var NotificationType;
(function (NotificationType) {
  NotificationType["InApp"] = "inApp";
  NotificationType["Native"] = "native";
})(NotificationType || (exports.NotificationType = NotificationType = {}));

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\types\\methods\\notify.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\ui\\builder.cjs", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cui%5Cbuilder.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createBuilder = void 0;
const utils_1 = require("@metamask/utils");
/**
 * A function that returns a function to "build" a {@link Component}. It infers
 * the type of the component from the given struct, and performs validation on
 * the created component.
 *
 * The returned function can handle the node arguments in two ways:
 * 1. As a single object, with the keys corresponding to the node's properties,
 * excluding the `type` property.
 * 2. As an array of arguments, with the order corresponding to the given keys.
 *
 * @param type - The type of the component to build.
 * @param struct - The struct to use to validate the component.
 * @param keys - The keys of the component to use as arguments to the builder.
 * The order of the keys determines the order of the arguments.
 * @returns A function that builds a component of the given type.
 * @internal
 */
function createBuilder(type, struct, keys = []) {
  return (...args) => {
    // Node passed as a single object.
    if (args.length === 1 && (0, utils_1.isPlainObject)(args[0])) {
      const node = {
        ...args[0],
        type
      };
      // The user could be passing invalid values to the builder, so we need to
      // validate them as per the component's struct.
      (0, utils_1.assertStruct)(node, struct, `Invalid ${type} component`);
      return node;
    }
    // Node passed as an array of arguments.
    const node = keys.reduce((partialNode, key, index) => {
      if (args[index] !== undefined) {
        return {
          ...partialNode,
          [key]: args[index]
        };
      }
      return partialNode;
    }, {
      type
    });
    // The user could be passing invalid values to the builder, so we need to
    // validate them as per the component's struct.
    (0, utils_1.assertStruct)(node, struct, `Invalid ${type} component`);
    return node;
  };
}
exports.createBuilder = createBuilder;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\ui\\builder.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\ui\\component.cjs", {"./components/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\ui\\components\\index.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cui%5Ccomponent.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assertIsComponent = exports.isComponent = void 0;
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const components_1 = require("./components/index.cjs");
/**
 * Check if the given value is a {@link Component}. This performs recursive
 * validation of the component's children (if any).
 *
 * @param value - The value to check.
 * @returns `true` if the value is a {@link Component}, `false` otherwise.
 */
function isComponent(value) {
  return (0, superstruct_1.is)(value, components_1.ComponentStruct);
}
exports.isComponent = isComponent;
/**
 * Assert that the given value is a {@link Component}. This performs recursive
 * validation of the component's children (if any).
 *
 * @param value - The value to check.
 * @throws If the value is not a {@link Component}.
 */
function assertIsComponent(value) {
  (0, utils_1.assertStruct)(value, components_1.ComponentStruct, 'Invalid component');
}
exports.assertIsComponent = assertIsComponent;

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\ui\\component.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\ui\\components\\address.cjs", {"../../internals/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\internals\\index.cjs","../builder.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\ui\\builder.cjs","../nodes.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\ui\\nodes.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cui%5Ccomponents%5Caddress.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.address = exports.AddressStruct = void 0;
const superstruct_1 = require("@metamask/superstruct");
const utils_1 = require("@metamask/utils");
const internals_1 = require("../../internals/index.cjs");
const builder_1 = require("../builder.cjs");
const nodes_1 = require("../nodes.cjs");
exports.AddressStruct = (0, superstruct_1.assign)(nodes_1.LiteralStruct, (0, superstruct_1.object)({
  type: (0, internals_1.literal)(nodes_1.NodeType.Address),
  value: utils_1.HexChecksumAddressStruct
}));
/**
 * Create an {@link Address} node.
 *
 * @param args - The node arguments. This can either be a string, or an object
 * with the `value` property.
 * @param args.value - The address to be rendered.
 * @returns The address node as an object.
 * @deprecated Snaps component functions are deprecated, in favor of the new JSX
 * components. This function will be removed in a future release.
 * @example
 * const node = address({ value: '0x4bbeeb066ed09b7aed07bf39eee0460dfa261520' });
 * const node = address('0x4bbeeb066ed09b7aed07bf39eee0460dfa261520');
 */
exports.address = (0, builder_1.createBuilder)(nodes_1.NodeType.Address, exports.AddressStruct, ['value']);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\ui\\components\\address.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\ui\\components\\button.cjs", {"../../internals/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\internals\\index.cjs","../builder.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\ui\\builder.cjs","../nodes.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\ui\\nodes.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cui%5Ccomponents%5Cbutton.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.button = exports.ButtonStruct = exports.ButtonType = exports.ButtonVariant = void 0;
const superstruct_1 = require("@metamask/superstruct");
const internals_1 = require("../../internals/index.cjs");
const builder_1 = require("../builder.cjs");
const nodes_1 = require("../nodes.cjs");
var ButtonVariant;
(function (ButtonVariant) {
  ButtonVariant["Primary"] = "primary";
  ButtonVariant["Secondary"] = "secondary";
})(ButtonVariant || (exports.ButtonVariant = ButtonVariant = {}));
var ButtonType;
(function (ButtonType) {
  ButtonType["Button"] = "button";
  ButtonType["Submit"] = "submit";
})(ButtonType || (exports.ButtonType = ButtonType = {}));
exports.ButtonStruct = (0, superstruct_1.assign)(nodes_1.LiteralStruct, (0, superstruct_1.object)({
  type: (0, internals_1.literal)(nodes_1.NodeType.Button),
  value: (0, superstruct_1.string)(),
  variant: (0, superstruct_1.optional)((0, superstruct_1.union)([(0, internals_1.enumValue)(ButtonVariant.Primary), (0, internals_1.enumValue)(ButtonVariant.Secondary)])),
  buttonType: (0, superstruct_1.optional)((0, superstruct_1.union)([(0, internals_1.enumValue)(ButtonType.Button), (0, internals_1.enumValue)(ButtonType.Submit)])),
  name: (0, superstruct_1.optional)((0, superstruct_1.string)())
}));
/**
 * Create a {@link Button} node.
 *
 * @param args - The node arguments. This can be either a string, or an object
 * with a `value` property. A set of optional properties can be passed.
 * @param args.variant - The optional variant of the button.
 * @param args.value - The text content of the node.
 * @param args.name - The optional name of the button.
 * @returns The text node as object.
 * @deprecated Snaps component functions are deprecated, in favor of the new JSX
 * components. This function will be removed in a future release.
 * @example
 * ```typescript
 * const node = button({  variant: 'primary', text: 'Hello, world!', name: 'myButton' });
 * const node = button('Hello, world!', 'button', 'myButton', 'primary');
 * const node = button('Hello, world!');
 * ```
 */
exports.button = (0, builder_1.createBuilder)(nodes_1.NodeType.Button, exports.ButtonStruct, ['value', 'buttonType', 'name', 'variant']);

      };
    };
  }
  }
}, {package:"@metamask/snaps-sdk",file:"node_modules\\@metamask\\snaps-sdk\\dist\\ui\\components\\button.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\ui\\components\\copyable.cjs", {"../../internals/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\internals\\index.cjs","../builder.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\ui\\builder.cjs","../nodes.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\snaps-sdk\\dist\\ui\\nodes.cjs","@metamask/superstruct":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\superstruct\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Csnaps-sdk%5Cdist%5Cui%5Ccomponents%5Ccopyable.cjs
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value