LavaPack.loadBundle([
["D:\\code\\v\\metamask-extension\\app\\scripts\\lib\\metaRPCClientFactory.ts", {"../../../shared/lib/transactions-controller-utils":"D:\\code\\v\\metamask-extension\\shared\\lib\\transactions-controller-utils.js","../../../shared/modules/random-id":"D:\\code\\v\\metamask-extension\\shared\\modules\\random-id.js","@metamask/rpc-errors":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\rpc-errors\\dist\\index.cjs","@metamask/safe-event-emitter":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\safe-event-emitter\\dist\\cjs\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Capp%5Cscripts%5Clib%5CmetaRPCClientFactory.ts
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetaRPCClient = exports.DisconnectError = void 0;
exports.default = metaRPCClientFactory;
var _safeEventEmitter = _interopRequireDefault(require("@metamask/safe-event-emitter"));
var _utils = require("@metamask/utils");
var _rpcErrors = require("@metamask/rpc-errors");
var _transactionsControllerUtils = require("../../../shared/lib/transactions-controller-utils");
var _randomId = _interopRequireDefault(require("../../../shared/modules/random-id"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
// It *is* used: in TypeDoc comment, you silly goose.
// eslint-disable-next-line @typescript-eslint/no-unused-vars

const JSON_RPC_VERSION = '2.0';

/**
 * A JSON-RPC 2.0 request object, types with our request types.
 */

/**
 * A JSON-RPC 2.0 response object, typed with our response types.
 */

/**
 * The shape for the object that provides our list of functions that can be
 * called on the RPC client.
 */
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention

/**
 * Api methods, promisified. All RPC methods are remote and have to be handled
 * asynchronously, so we wrap the return types in a Promise.
 */

/**
 * Checks if the given data is a JsonRpcFailure.
 *
 * @param data - The data to check.
 * @returns True if the data is a JsonRpcFailure, false otherwise.
 */
function isError(data) {
  return (0, _utils.hasProperty)(data, 'error');
}

/**
 * Type guard for checking if a property is in an object. Differs from
 * {@link hasProperty} in that it checks the prototype chain and the type guard
 * checks the property, not the object.
 *
 * @param property - The property to check.
 * @param obj - The object to check.
 * @returns True if the property is in the object, false otherwise.
 */
// TODO: Fix in https://github.com/MetaMask/metamask-extension/issues/31860
// eslint-disable-next-line @typescript-eslint/naming-convention
function propertyIn(property, obj) {
  return Reflect.has(obj, property);
}
class DisconnectError extends Error {}

/**
 * A JSON-RPC 2.0 client that communicates over a stream.
 */
exports.DisconnectError = DisconnectError;
var _rpcCache = /*#__PURE__*/new WeakMap();
var _connectionStream = /*#__PURE__*/new WeakMap();
var _notificationChannel = /*#__PURE__*/new WeakMap();
var _uncaughtErrorChannel = /*#__PURE__*/new WeakMap();
class MetaRPCClient {
  /**
   * Creates a new MetaRPCClient instance.
   *
   * @param connectionStream - The stream to use for the RPC client.
   */
  constructor(connectionStream) {
    _classPrivateFieldInitSpec(this, _rpcCache, new Map());
    /**
     * The stream used to communicate with the server.
     */
    _classPrivateFieldInitSpec(this, _connectionStream, void 0);
    _classPrivateFieldInitSpec(this, _notificationChannel, new _safeEventEmitter.default());
    _classPrivateFieldInitSpec(this, _uncaughtErrorChannel, new _safeEventEmitter.default());
    /**
     * A map of requests that are currently pending.
     */
    _defineProperty(this, "requests", new Map());
    /**
     * Gets a resolver function for the specified method.
     *
     * @returns A function that resolves the method on the client.
     */
    _defineProperty(this, "getRpcResolver", () => {
      return (client, method, receiver) => {
        if (propertyIn(method, client)) {
          // Return any properties present on `MetaRPCClient`
          return Reflect.get(client, method, receiver);
        }
        const cachedRpc = _classPrivateFieldGet(_rpcCache, this).get(method);
        if (cachedRpc) {
          return cachedRpc;
        }
        const rpc = async (...params) => await client.send({
          id: (0, _randomId.default)(),
          jsonrpc: JSON_RPC_VERSION,
          method,
          params
        });
        // Cache the method to avoid creating it again
        _classPrivateFieldGet(_rpcCache, this).set(method, rpc);
        return rpc;
      };
    });
    /**
     * Sets up a listener for JSON-RPC notifications.
     *
     * @param handler - The handler to call when a notification is received.
     */
    _defineProperty(this, "onNotification", handler => {
      _classPrivateFieldGet(_notificationChannel, this).addListener('notification', handler);
    });
    /**
     * Sets up a listener for uncaught errors.
     *
     * @param handler - The handler to call when an error is received.
     */
    _defineProperty(this, "onUncaughtError", handler => {
      _classPrivateFieldGet(_uncaughtErrorChannel, this).addListener('error', handler);
    });
    /**
     * Closes the connection and cleans up.
     *
     * @param reason
     */
    _defineProperty(this, "close", (reason = 'disconnected') => {
      // stop processing the stream
      _classPrivateFieldGet(_connectionStream, this).off('data', this.handleResponse);
      _classPrivateFieldGet(_connectionStream, this).off('end', this.close);

      // fail all unfinished requests
      this.requests.forEach(({
        reject,
        timer
      }) => {
        clearTimeout(timer);
        reject(new DisconnectError(reason));
      });
      this.requests.clear();

      // remove all external listeners
      _classPrivateFieldGet(_notificationChannel, this).removeAllListeners();
      _classPrivateFieldGet(_uncaughtErrorChannel, this).removeAllListeners();
    });
    /**
     * Handles a JSON-RPC response.
     *
     * @param response - The response to handle.
     */
    _defineProperty(this, "handleResponse", response => {
      if (!(0, _utils.isObject)(response) || !(0, _utils.hasProperty)(response, 'jsonrpc') || response.jsonrpc !== JSON_RPC_VERSION) {
        // ignore noise which can cause processing errors
        return;
      }
      if ((0, _utils.hasProperty)(response, 'method')) {
        if (!(0, _utils.hasProperty)(response, 'id')) {
          // react to server-side to client-side notifications.
          // A JSON-RPC notification is a request without an `id`.
          _classPrivateFieldGet(_notificationChannel, this).emit('notification', response);
        }
        // ignore server-side to client side *requests* (messages with an `id` and
        // a `method`).
        return;
      }
      const {
        id
      } = response;
      const {
        requests
      } = this;
      const request = requests.get(id);
      if (isError(response)) {
        const {
          error
        } = response;
        const {
          code,
          message,
          data,
          stack
        } = error;
        const e = new _rpcErrors.JsonRpcError(code, message, data);
        // preserve the stack
        e.stack = stack;
        if (request) {
          requests.delete(id);
          clearTimeout(request.timer);
          request.reject(e);
        } else {
          _classPrivateFieldGet(_uncaughtErrorChannel, this).emit('error', e);
        }
      } else if (request) {
        requests.delete(id);
        clearTimeout(request.timer);
        request.resolve(response.result);
      }
    });
    _classPrivateFieldSet(_connectionStream, this, connectionStream.on('data', this.handleResponse).on('end', this.close));
  }
  /**
   * Sends a JSON-RPC request over the connection stream and returns a promise
   * that resolves to the result of the method call.
   *
   * @param payload - The payload to send.
   * @returns A promise that resolves to the result of the method call.
   */
  async send(payload) {
    return new Promise((resolve, reject) => {
      let timer;
      if (payload.method === 'getState') {
        timer = setTimeout(() => {
          this.requests.delete(payload.id);
          reject(new Error('No response from RPC'));
        }, _transactionsControllerUtils.TEN_SECONDS_IN_MILLISECONDS);
      }
      this.requests.set(payload.id, {
        resolve,
        reject,
        timer
      });
      _classPrivateFieldGet(_connectionStream, this).write(payload);
    });
  }
}
exports.MetaRPCClient = MetaRPCClient;
/**
 * Creates a `MetaRPCClient` instance that also proxies requests/responses to
 * the background process over the provided `connectionStream`. It listens to
 * the stream bi-directionally, allowing it to send requests and receive
 * both responses and unsolicited notifications.
 *
 * It can parse JSON-RPC 2.0 requests and responses.
 *
 * In practice, this is used to send messages to from the UI to the background's
 * API methods configured within {@link MetamaskController}.
 *
 * @template Api - The type of the methods available on the MetaRPCClient.
 * @param connectionStream - The connection stream to use for the RPC client.
 * @returns An API that blends methods of our `MetaRPCClient` and an RPC service
 * that communicates over the provided `connectionStream` in order to remote
 * invoke methods available over the provided `Api` template type.
 */
function metaRPCClientFactory(connectionStream) {
  const metaRPCClient = new MetaRPCClient(connectionStream);
  return new Proxy(metaRPCClient, {
    get: metaRPCClient.getRpcResolver()
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"app\\scripts\\lib\\metaRPCClientFactory.ts",}],
["D:\\code\\v\\metamask-extension\\development\\wdyr.ts", {"@welldone-software/why-did-you-render":"D:\\code\\v\\metamask-extension\\node_modules\\@welldone-software\\why-did-you-render\\dist\\whyDidYouRender.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cdevelopment%5Cwdyr.ts
      return function (require, module, exports) {
"use strict";

var _react = _interopRequireDefault(require("react"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// eslint-disable-next-line spaced-comment
/// <reference types="@welldone-software/why-did-you-render" />

if (false) {
  // eslint-disable-next-line @typescript-eslint/no-require-imports, @typescript-eslint/no-var-requires
  const whyDidYouRender = require('@welldone-software/why-did-you-render');
  whyDidYouRender(_react.default, {
    trackAllPureComponents: true
  });
}

      };
    };
  }
  }
}, {package:"$root$",file:"development\\wdyr.ts",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\assertThisInitialized.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@babel%5Cruntime%5Chelpers%5CassertThisInitialized.js
      return function (require, module, exports) {
function _assertThisInitialized(e) {
  if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  return e;
}
module.exports = _assertThisInitialized, module.exports.__esModule = true, module.exports["default"] = module.exports;
      };
    };
  }
  }
}, {package:"@babel/runtime",file:"node_modules\\@babel\\runtime\\helpers\\assertThisInitialized.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\classCallCheck.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@babel%5Cruntime%5Chelpers%5CclassCallCheck.js
      return function (require, module, exports) {
function _classCallCheck(a, n) {
  if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function");
}
module.exports = _classCallCheck, module.exports.__esModule = true, module.exports["default"] = module.exports;
      };
    };
  }
  }
}, {package:"@babel/runtime",file:"node_modules\\@babel\\runtime\\helpers\\classCallCheck.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\createClass.js", {"./toPropertyKey.js":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\toPropertyKey.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@babel%5Cruntime%5Chelpers%5CcreateClass.js
      return function (require, module, exports) {
var toPropertyKey = require("./toPropertyKey.js");
function _defineProperties(e, r) {
  for (var t = 0; t < r.length; t++) {
    var o = r[t];
    o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, toPropertyKey(o.key), o);
  }
}
function _createClass(e, r, t) {
  return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", {
    writable: !1
  }), e;
}
module.exports = _createClass, module.exports.__esModule = true, module.exports["default"] = module.exports;
      };
    };
  }
  }
}, {package:"@babel/runtime",file:"node_modules\\@babel\\runtime\\helpers\\createClass.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\getPrototypeOf.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@babel%5Cruntime%5Chelpers%5CgetPrototypeOf.js
      return function (require, module, exports) {
function _getPrototypeOf(t) {
  return module.exports = _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) {
    return t.__proto__ || Object.getPrototypeOf(t);
  }, module.exports.__esModule = true, module.exports["default"] = module.exports, _getPrototypeOf(t);
}
module.exports = _getPrototypeOf, module.exports.__esModule = true, module.exports["default"] = module.exports;
      };
    };
  }
  }
}, {package:"@babel/runtime",file:"node_modules\\@babel\\runtime\\helpers\\getPrototypeOf.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\inherits.js", {"./setPrototypeOf.js":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\setPrototypeOf.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@babel%5Cruntime%5Chelpers%5Cinherits.js
      return function (require, module, exports) {
var setPrototypeOf = require("./setPrototypeOf.js");
function _inherits(t, e) {
  if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function");
  t.prototype = Object.create(e && e.prototype, {
    constructor: {
      value: t,
      writable: !0,
      configurable: !0
    }
  }), Object.defineProperty(t, "prototype", {
    writable: !1
  }), e && setPrototypeOf(t, e);
}
module.exports = _inherits, module.exports.__esModule = true, module.exports["default"] = module.exports;
      };
    };
  }
  }
}, {package:"@babel/runtime",file:"node_modules\\@babel\\runtime\\helpers\\inherits.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\possibleConstructorReturn.js", {"./assertThisInitialized.js":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\assertThisInitialized.js","./typeof.js":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\typeof.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@babel%5Cruntime%5Chelpers%5CpossibleConstructorReturn.js
      return function (require, module, exports) {
var _typeof = require("./typeof.js")["default"];
var assertThisInitialized = require("./assertThisInitialized.js");
function _possibleConstructorReturn(t, e) {
  if (e && ("object" == _typeof(e) || "function" == typeof e)) return e;
  if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined");
  return assertThisInitialized(t);
}
module.exports = _possibleConstructorReturn, module.exports.__esModule = true, module.exports["default"] = module.exports;
      };
    };
  }
  }
}, {package:"@babel/runtime",file:"node_modules\\@babel\\runtime\\helpers\\possibleConstructorReturn.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@blockaid\\ppom_release\\package.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@blockaid%5Cppom_release%5Cpackage.json
      return function (require, module, exports) {
module.exports={
  "name": "@blockaid/ppom_release",
  "version": "1.5.3",
  "files": [
    "ppom_bg.wasm",
    "ppom.js",
    "ppom.d.ts"
  ],
  "module": "ppom.js",
  "types": "ppom.d.ts"
}
      };
    };
  }
  }
}, {package:"@blockaid/ppom_release",file:"node_modules\\@blockaid\\ppom_release\\package.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry-eth\\dist\\bc-ur-registry-eth.cjs.development.js", {"@ethereumjs/util":"D:\\code\\v\\metamask-extension\\node_modules\\@ethereumjs\\util\\dist\\cjs\\index.js","@keystonehq/bc-ur-registry":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\index.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js","hdkey":"D:\\code\\v\\metamask-extension\\node_modules\\hdkey\\lib\\hdkey.js","uuid":"D:\\code\\v\\metamask-extension\\node_modules\\uuid\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry-eth%5Cdist%5Cbc-ur-registry-eth.cjs.development.js
      return function (require, module, exports) {
(function (Buffer){(function (){
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var bcUrRegistry = require('@keystonehq/bc-ur-registry');
var uuid = require('uuid');
var HDKey = _interopDefault(require('hdkey'));
var util = require('@ethereumjs/util');

const ExtendedRegistryTypes = {
  ETH_SIGN_REQUEST: /*#__PURE__*/new bcUrRegistry.RegistryType("eth-sign-request", 401),
  ETH_SIGNATURE: /*#__PURE__*/new bcUrRegistry.RegistryType("eth-signature", 402),
  ETH_NFT_ITEM: /*#__PURE__*/new bcUrRegistry.RegistryType("eth-nft-item", 403)
};

const {
  decodeToDataItem,
  RegistryTypes
} = bcUrRegistry.extend;
var Keys;
(function (Keys) {
  Keys[Keys["requestId"] = 1] = "requestId";
  Keys[Keys["signData"] = 2] = "signData";
  Keys[Keys["dataType"] = 3] = "dataType";
  Keys[Keys["chainId"] = 4] = "chainId";
  Keys[Keys["derivationPath"] = 5] = "derivationPath";
  Keys[Keys["address"] = 6] = "address";
  Keys[Keys["origin"] = 7] = "origin";
})(Keys || (Keys = {}));
(function (DataType) {
  DataType[DataType["transaction"] = 1] = "transaction";
  DataType[DataType["typedData"] = 2] = "typedData";
  DataType[DataType["personalMessage"] = 3] = "personalMessage";
  DataType[DataType["typedTransaction"] = 4] = "typedTransaction";
})(exports.DataType || (exports.DataType = {}));
class EthSignRequest extends bcUrRegistry.RegistryItem {
  constructor(args) {
    super();
    this.getRegistryType = () => ExtendedRegistryTypes.ETH_SIGN_REQUEST;
    this.getRequestId = () => this.requestId;
    this.getSignData = () => this.signData;
    this.getDataType = () => this.dataType;
    this.getChainId = () => this.chainId;
    this.getDerivationPath = () => this.derivationPath.getPath();
    this.getSourceFingerprint = () => this.derivationPath.getSourceFingerprint();
    this.getSignRequestAddress = () => this.address;
    this.getOrigin = () => this.origin;
    this.toDataItem = () => {
      const map = {};
      if (this.requestId) {
        map[Keys.requestId] = new bcUrRegistry.DataItem(this.requestId, RegistryTypes.UUID.getTag());
      }
      if (this.address) {
        map[Keys.address] = this.address;
      }
      if (this.chainId) {
        map[Keys.chainId] = Number(this.chainId);
      }
      if (this.origin) {
        map[Keys.origin] = this.origin;
      }
      map[Keys.signData] = this.signData;
      map[Keys.dataType] = this.dataType;
      const keyPath = this.derivationPath.toDataItem();
      keyPath.setTag(this.derivationPath.getRegistryType().getTag());
      map[Keys.derivationPath] = keyPath;
      return new bcUrRegistry.DataItem(map);
    };
    this.requestId = args.requestId;
    this.signData = args.signData;
    this.dataType = args.dataType;
    this.chainId = args.chainId;
    this.derivationPath = args.derivationPath;
    this.address = args.address;
    this.origin = args.origin;
  }
  static constructETHRequest(signData, signDataType, hdPath, xfp, uuidString, chainId, address, origin) {
    const paths = hdPath.replace(/[m|M]\//, "").split("/");
    const hdpathObject = new bcUrRegistry.CryptoKeypath(paths.map(path => {
      const index = parseInt(path.replace("'", ""));
      let isHardened = false;
      if (path.endsWith("'")) {
        isHardened = true;
      }
      return new bcUrRegistry.PathComponent({
        index,
        hardened: isHardened
      });
    }), Buffer.from(xfp, "hex"));
    return new EthSignRequest({
      requestId: uuidString ? Buffer.from(uuid.parse(uuidString)) : undefined,
      signData,
      dataType: signDataType,
      derivationPath: hdpathObject,
      chainId,
      address: address ? Buffer.from(address.replace("0x", ""), "hex") : undefined,
      origin: origin || undefined
    });
  }
}
EthSignRequest.fromDataItem = dataItem => {
  const map = dataItem.getData();
  const signData = map[Keys.signData];
  const dataType = map[Keys.dataType];
  const derivationPath = bcUrRegistry.CryptoKeypath.fromDataItem(map[Keys.derivationPath]);
  const chainId = map[Keys.chainId] ? map[Keys.chainId] : undefined;
  const address = map[Keys.address] ? map[Keys.address] : undefined;
  const requestId = map[Keys.requestId] ? map[Keys.requestId].getData() : undefined;
  const origin = map[Keys.origin] ? map[Keys.origin] : undefined;
  return new EthSignRequest({
    requestId,
    signData,
    dataType,
    chainId,
    derivationPath,
    address,
    origin
  });
};
EthSignRequest.fromCBOR = _cborPayload => {
  const dataItem = decodeToDataItem(_cborPayload);
  return EthSignRequest.fromDataItem(dataItem);
};

const {
  RegistryTypes: RegistryTypes$1,
  decodeToDataItem: decodeToDataItem$1
} = bcUrRegistry.extend;
var Keys$1;
(function (Keys) {
  Keys[Keys["requestId"] = 1] = "requestId";
  Keys[Keys["signature"] = 2] = "signature";
  Keys[Keys["origin"] = 3] = "origin";
})(Keys$1 || (Keys$1 = {}));
class ETHSignature extends bcUrRegistry.RegistryItem {
  constructor(signature, requestId, origin) {
    super();
    this.getRegistryType = () => ExtendedRegistryTypes.ETH_SIGNATURE;
    this.getRequestId = () => this.requestId;
    this.getSignature = () => this.signature;
    this.getOrigin = () => this.origin;
    this.toDataItem = () => {
      const map = {};
      if (this.requestId) {
        map[Keys$1.requestId] = new bcUrRegistry.DataItem(this.requestId, RegistryTypes$1.UUID.getTag());
      }
      if (this.origin) map[Keys$1.origin] = this.origin;
      map[Keys$1.signature] = this.signature;
      return new bcUrRegistry.DataItem(map);
    };
    this.signature = signature;
    this.requestId = requestId;
    this.origin = origin;
  }
}
ETHSignature.fromDataItem = dataItem => {
  const map = dataItem.getData();
  const signature = map[Keys$1.signature];
  const requestId = map[Keys$1.requestId] ? map[Keys$1.requestId].getData() : undefined;
  return new ETHSignature(signature, requestId, map[Keys$1.origin]);
};
ETHSignature.fromCBOR = _cborPayload => {
  const dataItem = decodeToDataItem$1(_cborPayload);
  return ETHSignature.fromDataItem(dataItem);
};

const {
  decodeToDataItem: decodeToDataItem$2
} = bcUrRegistry.extend;
var Keys$2;
(function (Keys) {
  Keys[Keys["chainId"] = 1] = "chainId";
  Keys[Keys["contractAddress"] = 2] = "contractAddress";
  Keys[Keys["contractName"] = 3] = "contractName";
  Keys[Keys["name"] = 4] = "name";
  Keys[Keys["mediaData"] = 5] = "mediaData";
})(Keys$2 || (Keys$2 = {}));
class ETHNFTItem extends bcUrRegistry.RegistryItem {
  constructor(args) {
    super();
    this.getRegistryType = () => ExtendedRegistryTypes.ETH_NFT_ITEM;
    this.getChainId = () => this.chainId;
    this.getName = () => this.name;
    this.getmediaData = () => this.mediaData;
    this.getContractAddress = () => this.contractAddress;
    this.getContractName = () => this.contractName;
    this.toDataItem = () => {
      const map = {};
      map[Keys$2.chainId] = this.chainId;
      map[Keys$2.name] = this.name;
      map[Keys$2.contractAddress] = this.contractAddress;
      map[Keys$2.contractName] = this.contractName;
      map[Keys$2.mediaData] = this.mediaData;
      return new bcUrRegistry.DataItem(map);
    };
    this.chainId = args.chainId;
    this.name = args.name;
    this.contractAddress = args.contractAddress;
    this.contractName = args.contractName;
    this.mediaData = args.mediaData; // remove the data perfix for android usage
  }
  static constructETHNFTItem(chainId, contractAddress, contractName, name, mediaData) {
    return new ETHNFTItem({
      chainId,
      contractAddress,
      contractName,
      mediaData,
      name
    });
  }
}
ETHNFTItem.fromDataItem = dataItem => {
  const map = dataItem.getData();
  const chainId = map[Keys$2.chainId];
  const name = map[Keys$2.name];
  const mediaData = map[Keys$2.mediaData];
  const contractAddress = map[Keys$2.contractAddress];
  const contractName = map[Keys$2.contractName];
  return new ETHNFTItem({
    chainId,
    name,
    contractAddress,
    contractName,
    mediaData
  });
};
ETHNFTItem.fromCBOR = _cborPayload => {
  const dataItem = decodeToDataItem$2(_cborPayload);
  return ETHNFTItem.fromDataItem(dataItem);
};

// @ts-ignore
const generateAddressFromXpub = (xpub, derivePath) => {
  // @ts-ignore
  const node = HDKey.fromExtendedKey(xpub);
  const publicKey = node.derive(derivePath);
  const address = "0x" + Buffer.from(util.publicToAddress(publicKey.publicKey, true)).toString("hex");
  return util.toChecksumAddress(address);
};
const findHDPathFromAddress = (address, xpub, numberLimit, rootPath) => {
  for (let i = 0; i < numberLimit; i++) {
    const path = `M/0/${i}`;
    const _address = generateAddressFromXpub(xpub, path);
    if (address.toLowerCase() == _address.toLowerCase()) {
      return `${rootPath}/0/${i}`;
    }
  }
  return null;
};

bcUrRegistry.patchTags(Object.values(ExtendedRegistryTypes).filter(rt => !!rt.getTag()).map(rt => rt.getTag()));

Object.keys(bcUrRegistry).forEach(function (k) {
  if (k !== 'default') Object.defineProperty(exports, k, {
    enumerable: true,
    get: function () {
      return bcUrRegistry[k];
    }
  });
});
exports.ETHNFTItem = ETHNFTItem;
exports.ETHSignature = ETHSignature;
exports.EthSignRequest = EthSignRequest;
exports.findHDPathFromAddress = findHDPathFromAddress;
exports.generateAddressFromXpub = generateAddressFromXpub;


}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth",file:"node_modules\\@keystonehq\\bc-ur-registry-eth\\dist\\bc-ur-registry-eth.cjs.development.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry-eth\\dist\\bc-ur-registry-eth.cjs.production.min.js", {"@ethereumjs/util":"D:\\code\\v\\metamask-extension\\node_modules\\@ethereumjs\\util\\dist\\cjs\\index.js","@keystonehq/bc-ur-registry":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\index.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js","hdkey":"D:\\code\\v\\metamask-extension\\node_modules\\hdkey\\lib\\hdkey.js","uuid":"D:\\code\\v\\metamask-extension\\node_modules\\uuid\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry-eth%5Cdist%5Cbc-ur-registry-eth.cjs.production.min.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var t,e=require("@keystonehq/bc-ur-registry"),a=require("uuid"),s=(t=require("hdkey"))&&"object"==typeof t&&"default"in t?t.default:t,i=require("@ethereumjs/util");const r={ETH_SIGN_REQUEST:new e.RegistryType("eth-sign-request",401),ETH_SIGNATURE:new e.RegistryType("eth-signature",402),ETH_NFT_ITEM:new e.RegistryType("eth-nft-item",403)},{decodeToDataItem:n,RegistryTypes:d}=e.extend;var o,h;!function(t){t[t.requestId=1]="requestId",t[t.signData=2]="signData",t[t.dataType=3]="dataType",t[t.chainId=4]="chainId",t[t.derivationPath=5]="derivationPath",t[t.address=6]="address",t[t.origin=7]="origin"}(o||(o={})),(h=exports.DataType||(exports.DataType={}))[h.transaction=1]="transaction",h[h.typedData=2]="typedData",h[h.personalMessage=3]="personalMessage",h[h.typedTransaction=4]="typedTransaction";class c extends e.RegistryItem{constructor(t){super(),this.getRegistryType=()=>r.ETH_SIGN_REQUEST,this.getRequestId=()=>this.requestId,this.getSignData=()=>this.signData,this.getDataType=()=>this.dataType,this.getChainId=()=>this.chainId,this.getDerivationPath=()=>this.derivationPath.getPath(),this.getSourceFingerprint=()=>this.derivationPath.getSourceFingerprint(),this.getSignRequestAddress=()=>this.address,this.getOrigin=()=>this.origin,this.toDataItem=()=>{const t={};this.requestId&&(t[o.requestId]=new e.DataItem(this.requestId,d.UUID.getTag())),this.address&&(t[o.address]=this.address),this.chainId&&(t[o.chainId]=Number(this.chainId)),this.origin&&(t[o.origin]=this.origin),t[o.signData]=this.signData,t[o.dataType]=this.dataType;const a=this.derivationPath.toDataItem();return a.setTag(this.derivationPath.getRegistryType().getTag()),t[o.derivationPath]=a,new e.DataItem(t)},this.requestId=t.requestId,this.signData=t.signData,this.dataType=t.dataType,this.chainId=t.chainId,this.derivationPath=t.derivationPath,this.address=t.address,this.origin=t.origin}static constructETHRequest(t,s,i,r,n,d,o,h){const g=i.replace(/[m|M]\//,"").split("/"),u=new e.CryptoKeypath(g.map(t=>{const a=parseInt(t.replace("'",""));let s=!1;return t.endsWith("'")&&(s=!0),new e.PathComponent({index:a,hardened:s})}),Buffer.from(r,"hex"));return new c({requestId:n?Buffer.from(a.parse(n)):void 0,signData:t,dataType:s,derivationPath:u,chainId:d,address:o?Buffer.from(o.replace("0x",""),"hex"):void 0,origin:h||void 0})}}c.fromDataItem=t=>{const a=t.getData(),s=a[o.signData],i=a[o.dataType],r=e.CryptoKeypath.fromDataItem(a[o.derivationPath]),n=a[o.chainId]?a[o.chainId]:void 0,d=a[o.address]?a[o.address]:void 0,h=a[o.requestId]?a[o.requestId].getData():void 0;return new c({requestId:h,signData:s,dataType:i,chainId:n,derivationPath:r,address:d,origin:a[o.origin]?a[o.origin]:void 0})},c.fromCBOR=t=>{const e=n(t);return c.fromDataItem(e)};const{RegistryTypes:g,decodeToDataItem:u}=e.extend;var m;!function(t){t[t.requestId=1]="requestId",t[t.signature=2]="signature",t[t.origin=3]="origin"}(m||(m={}));class I extends e.RegistryItem{constructor(t,a,s){super(),this.getRegistryType=()=>r.ETH_SIGNATURE,this.getRequestId=()=>this.requestId,this.getSignature=()=>this.signature,this.getOrigin=()=>this.origin,this.toDataItem=()=>{const t={};return this.requestId&&(t[m.requestId]=new e.DataItem(this.requestId,g.UUID.getTag())),this.origin&&(t[m.origin]=this.origin),t[m.signature]=this.signature,new e.DataItem(t)},this.signature=t,this.requestId=a,this.origin=s}}I.fromDataItem=t=>{const e=t.getData(),a=e[m.signature],s=e[m.requestId]?e[m.requestId].getData():void 0;return new I(a,s,e[m.origin])},I.fromCBOR=t=>{const e=u(t);return I.fromDataItem(e)};const{decodeToDataItem:p}=e.extend;var D;!function(t){t[t.chainId=1]="chainId",t[t.contractAddress=2]="contractAddress",t[t.contractName=3]="contractName",t[t.name=4]="name",t[t.mediaData=5]="mediaData"}(D||(D={}));class T extends e.RegistryItem{constructor(t){super(),this.getRegistryType=()=>r.ETH_NFT_ITEM,this.getChainId=()=>this.chainId,this.getName=()=>this.name,this.getmediaData=()=>this.mediaData,this.getContractAddress=()=>this.contractAddress,this.getContractName=()=>this.contractName,this.toDataItem=()=>{const t={};return t[D.chainId]=this.chainId,t[D.name]=this.name,t[D.contractAddress]=this.contractAddress,t[D.contractName]=this.contractName,t[D.mediaData]=this.mediaData,new e.DataItem(t)},this.chainId=t.chainId,this.name=t.name,this.contractAddress=t.contractAddress,this.contractName=t.contractName,this.mediaData=t.mediaData}static constructETHNFTItem(t,e,a,s,i){return new T({chainId:t,contractAddress:e,contractName:a,mediaData:i,name:s})}}T.fromDataItem=t=>{const e=t.getData();return new T({chainId:e[D.chainId],name:e[D.name],contractAddress:e[D.contractAddress],contractName:e[D.contractName],mediaData:e[D.mediaData]})},T.fromCBOR=t=>{const e=p(t);return T.fromDataItem(e)};const y=(t,e)=>{const a=s.fromExtendedKey(t).derive(e),r="0x"+Buffer.from(i.publicToAddress(a.publicKey,!0)).toString("hex");return i.toChecksumAddress(r)};e.patchTags(Object.values(r).filter(t=>!!t.getTag()).map(t=>t.getTag())),Object.keys(e).forEach((function(t){"default"!==t&&Object.defineProperty(exports,t,{enumerable:!0,get:function(){return e[t]}})})),exports.ETHNFTItem=T,exports.ETHSignature=I,exports.EthSignRequest=c,exports.findHDPathFromAddress=(t,e,a,s)=>{for(let i=0;i<a;i++){const a=y(e,"M/0/"+i);if(t.toLowerCase()==a.toLowerCase())return`${s}/0/${i}`}return null},exports.generateAddressFromXpub=y;


}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth",file:"node_modules\\@keystonehq\\bc-ur-registry-eth\\dist\\bc-ur-registry-eth.cjs.production.min.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry-eth\\dist\\index.js", {"./bc-ur-registry-eth.cjs.development.js":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry-eth\\dist\\bc-ur-registry-eth.cjs.development.js","./bc-ur-registry-eth.cjs.production.min.js":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry-eth\\dist\\bc-ur-registry-eth.cjs.production.min.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry-eth%5Cdist%5Cindex.js
      return function (require, module, exports) {

'use strict'

if ("development" === 'production') {
  module.exports = require('./bc-ur-registry-eth.cjs.production.min.js')
} else {
  module.exports = require('./bc-ur-registry-eth.cjs.development.js')
}

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth",file:"node_modules\\@keystonehq\\bc-ur-registry-eth\\dist\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\Bytes.js", {"./RegistryItem":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryItem.js","./RegistryType":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryType.js","./lib":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5CBytes.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bytes = void 0;
const lib_1 = require("./lib");
const RegistryItem_1 = require("./RegistryItem");
const RegistryType_1 = require("./RegistryType");
class Bytes extends RegistryItem_1.RegistryItem {
    constructor(bytes) {
        super();
        this.bytes = bytes;
        this.getRegistryType = () => {
            return RegistryType_1.RegistryTypes.BYTES;
        };
        this.getData = () => this.bytes;
        this.toDataItem = () => {
            return new lib_1.DataItem(this.bytes);
        };
    }
}
exports.Bytes = Bytes;
Bytes.fromDataItem = (dataItem) => {
    const bytes = dataItem.getData();
    if (!bytes) {
        throw new Error(`#[ur-registry][Bytes][fn.fromDataItem]: decoded [dataItem][#data] is undefined: ${dataItem}`);
    }
    return new Bytes(bytes);
};
Bytes.fromCBOR = (_cborPayload) => {
    const dataItem = (0, lib_1.decodeToDataItem)(_cborPayload);
    return Bytes.fromDataItem(dataItem);
};

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\Bytes.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoAccount.js", {".":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\index.js","./RegistryItem":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryItem.js","./RegistryType":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryType.js","./lib":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\index.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5CCryptoAccount.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CryptoAccount = void 0;
const _1 = require(".");
const lib_1 = require("./lib");
const RegistryItem_1 = require("./RegistryItem");
const RegistryType_1 = require("./RegistryType");
var Keys;
(function (Keys) {
    Keys[Keys["masterFingerprint"] = 1] = "masterFingerprint";
    Keys[Keys["outputDescriptors"] = 2] = "outputDescriptors";
})(Keys || (Keys = {}));
class CryptoAccount extends RegistryItem_1.RegistryItem {
    constructor(masterFingerprint, outputDescriptors) {
        super();
        this.masterFingerprint = masterFingerprint;
        this.outputDescriptors = outputDescriptors;
        this.getRegistryType = () => {
            return RegistryType_1.RegistryTypes.CRYPTO_ACCOUNT;
        };
        this.getMasterFingerprint = () => this.masterFingerprint;
        this.getOutputDescriptors = () => this.outputDescriptors;
        this.toDataItem = () => {
            const map = {};
            if (this.masterFingerprint) {
                map[Keys.masterFingerprint] = this.masterFingerprint.readUInt32BE(0);
            }
            if (this.outputDescriptors) {
                map[Keys.outputDescriptors] = this.outputDescriptors.map((item) => item.toDataItem());
            }
            return new lib_1.DataItem(map);
        };
    }
}
exports.CryptoAccount = CryptoAccount;
CryptoAccount.fromDataItem = (dataItem) => {
    const map = dataItem.getData();
    const masterFingerprint = Buffer.alloc(4);
    const _masterFingerprint = map[Keys.masterFingerprint];
    if (_masterFingerprint) {
        masterFingerprint.writeUInt32BE(_masterFingerprint, 0);
    }
    const outputDescriptors = map[Keys.outputDescriptors];
    const cryptoOutputs = outputDescriptors.map((item) => _1.CryptoOutput.fromDataItem(item));
    return new CryptoAccount(masterFingerprint, cryptoOutputs);
};
CryptoAccount.fromCBOR = (_cborPayload) => {
    const dataItem = (0, lib_1.decodeToDataItem)(_cborPayload);
    return CryptoAccount.fromDataItem(dataItem);
};

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoAccount.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoCoinInfo.js", {"./RegistryItem":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryItem.js","./RegistryType":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryType.js","./lib":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5CCryptoCoinInfo.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CryptoCoinInfo = exports.Network = exports.Type = void 0;
const lib_1 = require("./lib");
const RegistryItem_1 = require("./RegistryItem");
const RegistryType_1 = require("./RegistryType");
var Keys;
(function (Keys) {
    Keys["type"] = "1";
    Keys["network"] = "2";
})(Keys || (Keys = {}));
var Type;
(function (Type) {
    Type[Type["bitcoin"] = 0] = "bitcoin";
})(Type = exports.Type || (exports.Type = {}));
var Network;
(function (Network) {
    Network[Network["mainnet"] = 0] = "mainnet";
    Network[Network["testnet"] = 1] = "testnet";
})(Network = exports.Network || (exports.Network = {}));
class CryptoCoinInfo extends RegistryItem_1.RegistryItem {
    constructor(type, network) {
        super();
        this.type = type;
        this.network = network;
        this.getRegistryType = () => {
            return RegistryType_1.RegistryTypes.CRYPTO_COIN_INFO;
        };
        this.getType = () => {
            return this.type || Type.bitcoin;
        };
        this.getNetwork = () => {
            return this.network || Network.mainnet;
        };
        this.toDataItem = () => {
            const map = {};
            if (this.type) {
                map[Keys.type] = this.type;
            }
            if (this.network) {
                map[Keys.network] = this.network;
            }
            return new lib_1.DataItem(map);
        };
    }
}
exports.CryptoCoinInfo = CryptoCoinInfo;
CryptoCoinInfo.fromDataItem = (dataItem) => {
    const map = dataItem.getData();
    const type = map[Keys.type];
    const network = map[Keys.network];
    return new CryptoCoinInfo(type, network);
};
CryptoCoinInfo.fromCBOR = (_cborPayload) => {
    const dataItem = (0, lib_1.decodeToDataItem)(_cborPayload);
    return CryptoCoinInfo.fromDataItem(dataItem);
};

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoCoinInfo.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoECKey.js", {"./RegistryItem":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryItem.js","./RegistryType":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryType.js","./lib":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5CCryptoECKey.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CryptoECKey = void 0;
const lib_1 = require("./lib");
const RegistryItem_1 = require("./RegistryItem");
const RegistryType_1 = require("./RegistryType");
var Keys;
(function (Keys) {
    Keys[Keys["curve"] = 1] = "curve";
    Keys[Keys["private"] = 2] = "private";
    Keys[Keys["data"] = 3] = "data";
})(Keys || (Keys = {}));
class CryptoECKey extends RegistryItem_1.RegistryItem {
    constructor(args) {
        super();
        this.isECKey = () => {
            return true;
        };
        this.getCurve = () => this.curve || 0;
        this.isPrivateKey = () => this.privateKey || false;
        this.getData = () => this.data;
        this.getRegistryType = () => {
            return RegistryType_1.RegistryTypes.CRYPTO_ECKEY;
        };
        this.toDataItem = () => {
            const map = {};
            if (this.curve) {
                map[Keys.curve] = this.curve;
            }
            if (this.privateKey !== undefined) {
                map[Keys.private] = this.privateKey;
            }
            map[Keys.data] = this.data;
            return new lib_1.DataItem(map);
        };
        this.getOutputDescriptorContent = () => {
            return this.data.toString('hex');
        };
        this.data = args.data;
        this.curve = args.curve;
        this.privateKey = args.privateKey || undefined;
    }
}
exports.CryptoECKey = CryptoECKey;
CryptoECKey.fromDataItem = (dataItem) => {
    const map = dataItem.getData();
    const curve = map[Keys.curve];
    const privateKey = map[Keys.private];
    const data = map[Keys.data];
    if (!data) {
        throw new Error(`#[ur-registry][CryptoECKey][fn.fromDataItem]: decoded [dataItem][#data.data] is undefined: ${dataItem}`);
    }
    return new CryptoECKey({ data, curve, privateKey });
};
CryptoECKey.fromCBOR = (_cborPayload) => {
    const dataItem = (0, lib_1.decodeToDataItem)(_cborPayload);
    return CryptoECKey.fromDataItem(dataItem);
};

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoECKey.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoHDKey.js", {"./CryptoCoinInfo":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoCoinInfo.js","./CryptoKeypath":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoKeypath.js","./RegistryItem":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryItem.js","./RegistryType":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryType.js","./lib":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\index.js","bs58check":"D:\\code\\v\\metamask-extension\\node_modules\\bs58check\\index.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5CCryptoHDKey.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CryptoHDKey = void 0;
const bs58check_1 = require("bs58check");
const CryptoCoinInfo_1 = require("./CryptoCoinInfo");
const CryptoKeypath_1 = require("./CryptoKeypath");
const lib_1 = require("./lib");
const RegistryItem_1 = require("./RegistryItem");
const RegistryType_1 = require("./RegistryType");
var Keys;
(function (Keys) {
    Keys[Keys["is_master"] = 1] = "is_master";
    Keys[Keys["is_private"] = 2] = "is_private";
    Keys[Keys["key_data"] = 3] = "key_data";
    Keys[Keys["chain_code"] = 4] = "chain_code";
    Keys[Keys["use_info"] = 5] = "use_info";
    Keys[Keys["origin"] = 6] = "origin";
    Keys[Keys["children"] = 7] = "children";
    Keys[Keys["parent_fingerprint"] = 8] = "parent_fingerprint";
    Keys[Keys["name"] = 9] = "name";
    Keys[Keys["note"] = 10] = "note";
})(Keys || (Keys = {}));
class CryptoHDKey extends RegistryItem_1.RegistryItem {
    constructor(args) {
        super();
        this.isECKey = () => {
            return false;
        };
        this.getKey = () => this.key;
        this.getChainCode = () => this.chainCode;
        this.isMaster = () => this.master;
        this.isPrivateKey = () => !!this.privateKey;
        this.getUseInfo = () => this.useInfo;
        this.getOrigin = () => this.origin;
        this.getChildren = () => this.children;
        this.getParentFingerprint = () => this.parentFingerprint;
        this.getName = () => this.name;
        this.getNote = () => this.note;
        this.getBip32Key = () => {
            var _a, _b, _c;
            let version;
            let depth;
            let index = 0;
            let parentFingerprint = Buffer.alloc(4).fill(0);
            if (this.isMaster()) {
                version = Buffer.from('0488ADE4', 'hex');
                depth = 0;
                index = 0;
            }
            else {
                depth = ((_a = this.getOrigin()) === null || _a === void 0 ? void 0 : _a.getComponents().length) || ((_b = this.getOrigin()) === null || _b === void 0 ? void 0 : _b.getDepth());
                const paths = (_c = this.getOrigin()) === null || _c === void 0 ? void 0 : _c.getComponents();
                const lastPath = paths[paths.length - 1];
                if (lastPath) {
                    index = lastPath.isHardened() ? lastPath.getIndex() + 0x80000000 : lastPath.getIndex();
                    if (this.getParentFingerprint()) {
                        parentFingerprint = this.getParentFingerprint();
                    }
                }
                if (this.isPrivateKey()) {
                    version = Buffer.from('0488ADE4', 'hex');
                }
                else {
                    version = Buffer.from('0488B21E', 'hex');
                }
            }
            const depthBuffer = Buffer.alloc(1);
            depthBuffer.writeUInt8(depth, 0);
            const indexBuffer = Buffer.alloc(4);
            indexBuffer.writeUInt32BE(index, 0);
            const chainCode = this.getChainCode();
            const key = this.getKey();
            return (0, bs58check_1.encode)(Buffer.concat([version, depthBuffer, parentFingerprint, indexBuffer, chainCode, key]));
        };
        this.getRegistryType = () => {
            return RegistryType_1.RegistryTypes.CRYPTO_HDKEY;
        };
        this.getOutputDescriptorContent = () => {
            var _a, _b, _c, _d, _e, _f, _g;
            let result = '';
            if (this.getOrigin()) {
                if (((_a = this.getOrigin()) === null || _a === void 0 ? void 0 : _a.getSourceFingerprint()) && ((_b = this.getOrigin()) === null || _b === void 0 ? void 0 : _b.getPath())) {
                    result += `${(_d = (_c = this.getOrigin()) === null || _c === void 0 ? void 0 : _c.getSourceFingerprint()) === null || _d === void 0 ? void 0 : _d.toString('hex')}/${(_e = this.getOrigin()) === null || _e === void 0 ? void 0 : _e.getPath()}`;
                }
            }
            result += this.getBip32Key();
            if (this.getChildren()) {
                if ((_f = this.getChildren()) === null || _f === void 0 ? void 0 : _f.getPath()) {
                    result += `/${(_g = this.getChildren()) === null || _g === void 0 ? void 0 : _g.getPath()}`;
                }
            }
            return result;
        };
        this.setupMasterKey = (args) => {
            this.master = true;
            this.key = args.key;
            this.chainCode = args.chainCode;
        };
        this.setupDeriveKey = (args) => {
            this.master = false;
            this.privateKey = args.isPrivateKey;
            this.key = args.key;
            this.chainCode = args.chainCode;
            this.useInfo = args.useInfo;
            this.origin = args.origin;
            this.children = args.children;
            this.parentFingerprint = args.parentFingerprint;
            this.name = args.name;
            this.note = args.note;
        };
        this.toDataItem = () => {
            const map = {};
            if (this.master) {
                map[Keys.is_master] = true;
                map[Keys.key_data] = this.key;
                map[Keys.chain_code] = this.chainCode;
            }
            else {
                if (this.privateKey !== undefined) {
                    map[Keys.is_private] = this.privateKey;
                }
                map[Keys.key_data] = this.key;
                if (this.chainCode) {
                    map[Keys.chain_code] = this.chainCode;
                }
                if (this.useInfo) {
                    const useInfo = this.useInfo.toDataItem();
                    useInfo.setTag(this.useInfo.getRegistryType().getTag());
                    map[Keys.use_info] = useInfo;
                }
                if (this.origin) {
                    const origin = this.origin.toDataItem();
                    origin.setTag(this.origin.getRegistryType().getTag());
                    map[Keys.origin] = origin;
                }
                if (this.children) {
                    const children = this.children.toDataItem();
                    children.setTag(this.children.getRegistryType().getTag());
                    map[Keys.children] = children;
                }
                if (this.parentFingerprint) {
                    map[Keys.parent_fingerprint] = this.parentFingerprint.readUInt32BE(0);
                }
                if (this.name !== undefined) {
                    map[Keys.name] = this.name;
                }
                if (this.note !== undefined) {
                    map[Keys.note] = this.note;
                }
            }
            return new lib_1.DataItem(map);
        };
        if (args.isMaster) {
            this.setupMasterKey(args);
        }
        else {
            this.setupDeriveKey(args);
        }
    }
}
exports.CryptoHDKey = CryptoHDKey;
CryptoHDKey.fromDataItem = (dataItem) => {
    const map = dataItem.getData();
    const isMaster = !!map[Keys.is_master];
    const isPrivateKey = map[Keys.is_private];
    const key = map[Keys.key_data];
    const chainCode = map[Keys.chain_code];
    const useInfo = map[Keys.use_info]
        ? CryptoCoinInfo_1.CryptoCoinInfo.fromDataItem(map[Keys.use_info])
        : undefined;
    const origin = map[Keys.origin]
        ? CryptoKeypath_1.CryptoKeypath.fromDataItem(map[Keys.origin])
        : undefined;
    const children = map[Keys.children]
        ? CryptoKeypath_1.CryptoKeypath.fromDataItem(map[Keys.children])
        : undefined;
    const _parentFingerprint = map[Keys.parent_fingerprint];
    let parentFingerprint = undefined;
    if (_parentFingerprint) {
        parentFingerprint = Buffer.alloc(4);
        parentFingerprint.writeUInt32BE(_parentFingerprint, 0);
    }
    const name = map[Keys.name];
    const note = map[Keys.note];
    return new CryptoHDKey({
        isMaster,
        isPrivateKey,
        key,
        chainCode,
        useInfo,
        origin,
        children,
        parentFingerprint,
        name,
        note,
    });
};
CryptoHDKey.fromCBOR = (_cborPayload) => {
    const dataItem = (0, lib_1.decodeToDataItem)(_cborPayload);
    return CryptoHDKey.fromDataItem(dataItem);
};

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoHDKey.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoKeypath.js", {"./PathComponent":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\PathComponent.js","./RegistryItem":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryItem.js","./RegistryType":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryType.js","./lib":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\index.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5CCryptoKeypath.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CryptoKeypath = void 0;
const lib_1 = require("./lib");
const PathComponent_1 = require("./PathComponent");
const RegistryItem_1 = require("./RegistryItem");
const RegistryType_1 = require("./RegistryType");
var Keys;
(function (Keys) {
    Keys[Keys["components"] = 1] = "components";
    Keys[Keys["source_fingerprint"] = 2] = "source_fingerprint";
    Keys[Keys["depth"] = 3] = "depth";
})(Keys || (Keys = {}));
class CryptoKeypath extends RegistryItem_1.RegistryItem {
    constructor(components = [], sourceFingerprint, depth) {
        super();
        this.components = components;
        this.sourceFingerprint = sourceFingerprint;
        this.depth = depth;
        this.getRegistryType = () => {
            return RegistryType_1.RegistryTypes.CRYPTO_KEYPATH;
        };
        this.getPath = () => {
            if (this.components.length === 0) {
                return undefined;
            }
            const components = this.components.map((component) => {
                return `${component.isWildcard() ? '*' : component.getIndex()}${component.isHardened() ? "'" : ''}`;
            });
            return components.join('/');
        };
        this.getComponents = () => this.components;
        this.getSourceFingerprint = () => this.sourceFingerprint;
        this.getDepth = () => this.depth;
        this.toDataItem = () => {
            const map = {};
            const components = [];
            this.components &&
                this.components.forEach((component) => {
                    if (component.isWildcard()) {
                        components.push([]);
                    }
                    else {
                        components.push(component.getIndex());
                    }
                    components.push(component.isHardened());
                });
            map[Keys.components] = components;
            if (this.sourceFingerprint) {
                map[Keys.source_fingerprint] = this.sourceFingerprint.readUInt32BE(0);
            }
            if (this.depth !== undefined) {
                map[Keys.depth] = this.depth;
            }
            return new lib_1.DataItem(map);
        };
    }
}
exports.CryptoKeypath = CryptoKeypath;
CryptoKeypath.fromDataItem = (dataItem) => {
    const map = dataItem.getData();
    const pathComponents = [];
    const components = map[Keys.components];
    if (components) {
        for (let i = 0; i < components.length; i += 2) {
            const isHardened = components[i + 1];
            const path = components[i];
            if (typeof path === 'number') {
                pathComponents.push(new PathComponent_1.PathComponent({ index: path, hardened: isHardened }));
            }
            else {
                pathComponents.push(new PathComponent_1.PathComponent({ hardened: isHardened }));
            }
        }
    }
    const _sourceFingerprint = map[Keys.source_fingerprint];
    let sourceFingerprint;
    if (_sourceFingerprint) {
        sourceFingerprint = Buffer.alloc(4);
        sourceFingerprint.writeUInt32BE(_sourceFingerprint, 0);
    }
    const depth = map[Keys.depth];
    return new CryptoKeypath(pathComponents, sourceFingerprint, depth);
};
CryptoKeypath.fromCBOR = (_cborPayload) => {
    const dataItem = (0, lib_1.decodeToDataItem)(_cborPayload);
    return CryptoKeypath.fromDataItem(dataItem);
};

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoKeypath.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoOutput.js", {"./CryptoECKey":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoECKey.js","./CryptoHDKey":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoHDKey.js","./MultiKey":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\MultiKey.js","./RegistryItem":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryItem.js","./RegistryType":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryType.js","./ScriptExpression":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\ScriptExpression.js","./lib":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5CCryptoOutput.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CryptoOutput = void 0;
const CryptoECKey_1 = require("./CryptoECKey");
const CryptoHDKey_1 = require("./CryptoHDKey");
const lib_1 = require("./lib");
const MultiKey_1 = require("./MultiKey");
const RegistryItem_1 = require("./RegistryItem");
const RegistryType_1 = require("./RegistryType");
const ScriptExpression_1 = require("./ScriptExpression");
class CryptoOutput extends RegistryItem_1.RegistryItem {
    constructor(scriptExpressions, cryptoKey) {
        super();
        this.scriptExpressions = scriptExpressions;
        this.cryptoKey = cryptoKey;
        this.getRegistryType = () => {
            return RegistryType_1.RegistryTypes.CRYPTO_OUTPUT;
        };
        this.getCryptoKey = () => this.cryptoKey;
        this.getHDKey = () => {
            if (this.cryptoKey instanceof CryptoHDKey_1.CryptoHDKey) {
                return this.cryptoKey;
            }
            else {
                return undefined;
            }
        };
        this.getECKey = () => {
            if (this.cryptoKey instanceof CryptoECKey_1.CryptoECKey) {
                return this.cryptoKey;
            }
            else {
                return undefined;
            }
        };
        this.getMultiKey = () => {
            if (this.cryptoKey instanceof MultiKey_1.MultiKey) {
                return this.cryptoKey;
            }
            else {
                return undefined;
            }
        };
        this.getScriptExpressions = () => this.scriptExpressions;
        this._toOutputDescriptor = (seIndex) => {
            if (seIndex >= this.scriptExpressions.length) {
                return this.cryptoKey.getOutputDescriptorContent();
            }
            else {
                return `${this.scriptExpressions[seIndex].getExpression()}(${this._toOutputDescriptor(seIndex + 1)})`;
            }
        };
        this.toString = () => {
            return this._toOutputDescriptor(0);
        };
        this.toDataItem = () => {
            let dataItem = this.cryptoKey.toDataItem();
            if (this.cryptoKey instanceof CryptoECKey_1.CryptoECKey ||
                this.cryptoKey instanceof CryptoHDKey_1.CryptoHDKey) {
                dataItem.setTag(this.cryptoKey.getRegistryType().getTag());
            }
            const clonedSe = [...this.scriptExpressions];
            clonedSe.reverse().forEach((se) => {
                const tagValue = se.getTag();
                if (dataItem.getTag() === undefined) {
                    dataItem.setTag(tagValue);
                }
                else {
                    dataItem = new lib_1.DataItem(dataItem, tagValue);
                }
            });
            return dataItem;
        };
    }
}
exports.CryptoOutput = CryptoOutput;
CryptoOutput.fromDataItem = (dataItem) => {
    const scriptExpressions = [];
    let _dataItem = dataItem;
    while (true) {
        let _tag = _dataItem.getTag();
        const se = ScriptExpression_1.ScriptExpression.fromTag(_tag);
        if (se) {
            scriptExpressions.push(se);
            if (_dataItem.getData() instanceof lib_1.DataItem) {
                _dataItem = _dataItem.getData();
                _tag = _dataItem.getTag();
            }
            else {
                break;
            }
        }
        else {
            break;
        }
    }
    const seLength = scriptExpressions.length;
    const isMultiKey = seLength > 0 &&
        (scriptExpressions[seLength - 1].getExpression() ===
            ScriptExpression_1.ScriptExpressions.MULTISIG.getExpression() ||
            scriptExpressions[seLength - 1].getExpression() ===
                ScriptExpression_1.ScriptExpressions.SORTED_MULTISIG.getExpression());
    if (isMultiKey) {
        const multiKey = MultiKey_1.MultiKey.fromDataItem(_dataItem);
        return new CryptoOutput(scriptExpressions, multiKey);
    }
    if (_dataItem.getTag() === RegistryType_1.RegistryTypes.CRYPTO_HDKEY.getTag()) {
        const cryptoHDKey = CryptoHDKey_1.CryptoHDKey.fromDataItem(_dataItem);
        return new CryptoOutput(scriptExpressions, cryptoHDKey);
    }
    else {
        const cryptoECKey = CryptoECKey_1.CryptoECKey.fromDataItem(_dataItem);
        return new CryptoOutput(scriptExpressions, cryptoECKey);
    }
};
CryptoOutput.fromCBOR = (_cborPayload) => {
    const dataItem = (0, lib_1.decodeToDataItem)(_cborPayload);
    return CryptoOutput.fromDataItem(dataItem);
};

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoOutput.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoPSBT.js", {"./RegistryItem":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryItem.js","./RegistryType":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryType.js","./lib":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5CCryptoPSBT.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CryptoPSBT = void 0;
const lib_1 = require("./lib");
const RegistryItem_1 = require("./RegistryItem");
const RegistryType_1 = require("./RegistryType");
class CryptoPSBT extends RegistryItem_1.RegistryItem {
    constructor(psbt) {
        super();
        this.psbt = psbt;
        this.getRegistryType = () => RegistryType_1.RegistryTypes.CRYPTO_PSBT;
        this.getPSBT = () => this.psbt;
        this.toDataItem = () => {
            return new lib_1.DataItem(this.psbt);
        };
    }
}
exports.CryptoPSBT = CryptoPSBT;
CryptoPSBT.fromDataItem = (dataItem) => {
    const psbt = dataItem.getData();
    if (!psbt) {
        throw new Error(`#[ur-registry][CryptoPSBT][fn.fromDataItem]: decoded [dataItem][#data] is undefined: ${dataItem}`);
    }
    return new CryptoPSBT(psbt);
};
CryptoPSBT.fromCBOR = (_cborPayload) => {
    const dataItem = (0, lib_1.decodeToDataItem)(_cborPayload);
    return CryptoPSBT.fromDataItem(dataItem);
};

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoPSBT.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\Decoder\\index.js", {"..":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\index.js","../RegistryType":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryType.js","../errors":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\errors\\index.js","@ngraveio/bc-ur":"D:\\code\\v\\metamask-extension\\node_modules\\@ngraveio\\bc-ur\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5CDecoder%5Cindex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.URRegistryDecoder = void 0;
const bc_ur_1 = require("@ngraveio/bc-ur");
const __1 = require("..");
const RegistryType_1 = require("../RegistryType");
const errors_1 = require("../errors");
class URRegistryDecoder extends bc_ur_1.URDecoder {
    constructor() {
        super(...arguments);
        this.resultRegistryType = () => {
            const ur = this.resultUR();
            switch (ur.type) {
                case RegistryType_1.RegistryTypes.BYTES.getType():
                    return __1.Bytes.fromCBOR(ur.cbor);
                case RegistryType_1.RegistryTypes.CRYPTO_HDKEY.getType():
                    return __1.CryptoHDKey.fromCBOR(ur.cbor);
                case RegistryType_1.RegistryTypes.CRYPTO_KEYPATH.getType():
                    return __1.CryptoKeypath.fromCBOR(ur.cbor);
                case RegistryType_1.RegistryTypes.CRYPTO_COIN_INFO.getType():
                    return __1.CryptoCoinInfo.fromCBOR(ur.cbor);
                case RegistryType_1.RegistryTypes.CRYPTO_ECKEY.getType():
                    return __1.CryptoECKey.fromCBOR(ur.cbor);
                case RegistryType_1.RegistryTypes.CRYPTO_OUTPUT.getType():
                    return __1.CryptoOutput.fromCBOR(ur.cbor);
                case RegistryType_1.RegistryTypes.CRYPTO_PSBT.getType():
                    return __1.CryptoPSBT.fromCBOR(ur.cbor);
                case RegistryType_1.RegistryTypes.CRYPTO_ACCOUNT.getType():
                    return __1.CryptoAccount.fromCBOR(ur.cbor);
                default:
                    throw new errors_1.UnknownURTypeError(`#[ur-registry][Decoder][fn.resultRegistryType]: registry type ${ur.type} is not supported now`);
            }
        };
    }
}
exports.URRegistryDecoder = URRegistryDecoder;

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\Decoder\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\MultiKey.js", {"./CryptoECKey":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoECKey.js","./CryptoHDKey":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoHDKey.js","./RegistryItem":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryItem.js","./RegistryType":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryType.js","./lib/DataItem":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\DataItem.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5CMultiKey.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultiKey = void 0;
const CryptoECKey_1 = require("./CryptoECKey");
const CryptoHDKey_1 = require("./CryptoHDKey");
const DataItem_1 = require("./lib/DataItem");
const RegistryItem_1 = require("./RegistryItem");
const RegistryType_1 = require("./RegistryType");
var Keys;
(function (Keys) {
    Keys[Keys["threshold"] = 1] = "threshold";
    Keys[Keys["keys"] = 2] = "keys";
})(Keys || (Keys = {}));
class MultiKey extends RegistryItem_1.RegistryItem {
    constructor(threshold, keys) {
        super();
        this.threshold = threshold;
        this.keys = keys;
        this.getThreshold = () => this.threshold;
        this.getKeys = () => this.keys;
        this.toDataItem = () => {
            const map = {};
            map[Keys.threshold] = this.threshold;
            const keys = this.keys.map((k) => {
                const dataItem = k.toDataItem();
                dataItem.setTag(k.getRegistryType().getTag());
                return dataItem;
            });
            map[Keys.keys] = keys;
            return new DataItem_1.DataItem(map);
        };
        this.getOutputDescriptorContent = () => {
            return [this.getThreshold(),
                this.keys.map(k => k.getOutputDescriptorContent()).join(','),
            ].join(',');
        };
    }
}
exports.MultiKey = MultiKey;
MultiKey.fromDataItem = (dataItem) => {
    const map = dataItem.getData();
    const threshold = map[Keys.threshold];
    const _keys = map[Keys.keys];
    const keys = [];
    _keys.forEach((k) => {
        if (k.getTag() === RegistryType_1.RegistryTypes.CRYPTO_HDKEY.getTag()) {
            keys.push(CryptoHDKey_1.CryptoHDKey.fromDataItem(k));
        }
        else if (k.getTag() === RegistryType_1.RegistryTypes.CRYPTO_ECKEY.getTag()) {
            keys.push(CryptoECKey_1.CryptoECKey.fromDataItem(k));
        }
    });
    return new MultiKey(threshold, keys);
};

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\MultiKey.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\PathComponent.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5CPathComponent.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PathComponent = void 0;
class PathComponent {
    constructor(args) {
        this.getIndex = () => this.index;
        this.isWildcard = () => this.wildcard;
        this.isHardened = () => this.hardened;
        this.index = args.index;
        this.hardened = args.hardened;
        if (this.index !== undefined) {
            this.wildcard = false;
        }
        else {
            this.wildcard = true;
        }
        if (this.index && (this.index & PathComponent.HARDENED_BIT) !== 0) {
            throw new Error(`#[ur-registry][PathComponent][fn.constructor]: Invalid index ${this.index} - most significant bit cannot be set`);
        }
    }
}
exports.PathComponent = PathComponent;
PathComponent.HARDENED_BIT = 0x80000000;

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\PathComponent.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryItem.js", {"./lib":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\index.js","@ngraveio/bc-ur":"D:\\code\\v\\metamask-extension\\node_modules\\@ngraveio\\bc-ur\\dist\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5CRegistryItem.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RegistryItem = void 0;
const bc_ur_1 = require("@ngraveio/bc-ur");
const lib_1 = require("./lib");
class RegistryItem {
    constructor() {
        this.toCBOR = () => {
            if (this.toDataItem() === undefined) {
                throw new Error(`#[ur-registry][RegistryItem][fn.toCBOR]: registry ${this.getRegistryType()}'s method toDataItem returns undefined`);
            }
            return (0, lib_1.encodeDataItem)(this.toDataItem());
        };
        this.toUR = () => {
            return new bc_ur_1.UR(this.toCBOR(), this.getRegistryType().getType());
        };
        this.toUREncoder = (maxFragmentLength, firstSeqNum, minFragmentLength) => {
            const ur = this.toUR();
            const urEncoder = new bc_ur_1.UREncoder(ur, maxFragmentLength, firstSeqNum, minFragmentLength);
            return urEncoder;
        };
    }
}
exports.RegistryItem = RegistryItem;

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryItem.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryType.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5CRegistryType.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RegistryTypes = exports.RegistryType = void 0;
class RegistryType {
    constructor(type, tag) {
        this.type = type;
        this.tag = tag;
        this.getTag = () => this.tag;
        this.getType = () => this.type;
    }
}
exports.RegistryType = RegistryType;
exports.RegistryTypes = {
    UUID: new RegistryType('uuid', 37),
    BYTES: new RegistryType('bytes', undefined),
    CRYPTO_HDKEY: new RegistryType('crypto-hdkey', 303),
    CRYPTO_KEYPATH: new RegistryType('crypto-keypath', 304),
    CRYPTO_COIN_INFO: new RegistryType('crypto-coin-info', 305),
    CRYPTO_ECKEY: new RegistryType('crypto-eckey', 306),
    CRYPTO_OUTPUT: new RegistryType('crypto-output', 308),
    CRYPTO_PSBT: new RegistryType('crypto-psbt', 310),
    CRYPTO_ACCOUNT: new RegistryType('crypto-account', 311),
    CRYPTO_MULTI_ACCOUNTS: new RegistryType("crypto-multi-accounts", 1103),
    QR_HARDWARE_CALL: new RegistryType("qr-hardware-call", 1201),
    KEY_DERIVATION_CALL: new RegistryType("key-derivation-call", 1301),
    KEY_DERIVATION_SCHEMA: new RegistryType("key-derivation-schema", 1302),
};

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryType.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\ScriptExpression.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5CScriptExpression.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScriptExpressions = exports.ScriptExpression = void 0;
class ScriptExpression {
    constructor(tag, expression) {
        this.tag = tag;
        this.expression = expression;
        this.getTag = () => this.tag;
        this.getExpression = () => this.expression;
    }
}
exports.ScriptExpression = ScriptExpression;
ScriptExpression.fromTag = (tag) => {
    const se = Object.values(exports.ScriptExpressions).find((se) => se.getTag() === tag);
    return se;
};
exports.ScriptExpressions = {
    SCRIPT_HASH: new ScriptExpression(400, 'sh'),
    WITNESS_SCRIPT_HASH: new ScriptExpression(401, 'wsh'),
    PUBLIC_KEY: new ScriptExpression(402, 'pk'),
    PUBLIC_KEY_HASH: new ScriptExpression(403, 'pkh'),
    WITNESS_PUBLIC_KEY_HASH: new ScriptExpression(404, 'wpkh'),
    COMBO: new ScriptExpression(405, 'combo'),
    MULTISIG: new ScriptExpression(406, 'multi'),
    SORTED_MULTISIG: new ScriptExpression(407, 'sortedmulti'),
    ADDRESS: new ScriptExpression(307, 'addr'),
    RAW_SCRIPT: new ScriptExpression(408, 'raw'),
};

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\ScriptExpression.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\errors\\index.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5Cerrors%5Cindex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnknownURTypeError = void 0;
class UnknownURTypeError extends Error {
    constructor(message) {
        super(message);
    }
}
exports.UnknownURTypeError = UnknownURTypeError;

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\errors\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\extended\\CryptoMultiAccounts.js", {"../CryptoHDKey":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoHDKey.js","../RegistryItem":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryItem.js","../RegistryType":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryType.js","../lib":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\index.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5Cextended%5CCryptoMultiAccounts.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CryptoMultiAccounts = void 0;
const RegistryType_1 = require("../RegistryType");
const CryptoHDKey_1 = require("../CryptoHDKey");
const RegistryItem_1 = require("../RegistryItem");
const lib_1 = require("../lib");
var Keys;
(function (Keys) {
    Keys[Keys["masterFingerprint"] = 1] = "masterFingerprint";
    Keys[Keys["keys"] = 2] = "keys";
    Keys[Keys["device"] = 3] = "device";
    Keys[Keys["deviceId"] = 4] = "deviceId";
    Keys[Keys["version"] = 5] = "version";
})(Keys || (Keys = {}));
class CryptoMultiAccounts extends RegistryItem_1.RegistryItem {
    constructor(masterFingerprint, keys, device, deviceId, version) {
        super();
        this.masterFingerprint = masterFingerprint;
        this.keys = keys;
        this.device = device;
        this.deviceId = deviceId;
        this.version = version;
        this.getRegistryType = () => RegistryType_1.RegistryTypes.CRYPTO_MULTI_ACCOUNTS;
        this.getMasterFingerprint = () => this.masterFingerprint;
        this.getKeys = () => this.keys;
        this.getDevice = () => this.device;
        this.getDeviceId = () => this.deviceId;
        this.getVersion = () => this.version;
        this.toDataItem = () => {
            const map = {};
            if (this.masterFingerprint) {
                map[Keys.masterFingerprint] = this.masterFingerprint.readUInt32BE(0);
            }
            if (this.keys) {
                map[Keys.keys] = this.keys.map((item) => {
                    const dataItem = item.toDataItem();
                    dataItem.setTag(item.getRegistryType().getTag());
                    return dataItem;
                });
            }
            if (this.device) {
                map[Keys.device] = this.device;
            }
            if (this.deviceId) {
                map[Keys.deviceId] = this.deviceId;
            }
            if (this.version) {
                map[Keys.version] = this.version;
            }
            return new lib_1.DataItem(map);
        };
    }
}
exports.CryptoMultiAccounts = CryptoMultiAccounts;
CryptoMultiAccounts.fromDataItem = (dataItem) => {
    const map = dataItem.getData();
    const masterFingerprint = Buffer.alloc(4);
    const _masterFingerprint = map[Keys.masterFingerprint];
    if (_masterFingerprint) {
        masterFingerprint.writeUInt32BE(_masterFingerprint, 0);
    }
    const keys = map[Keys.keys];
    const cryptoHDKeys = keys.map((item) => CryptoHDKey_1.CryptoHDKey.fromDataItem(item));
    const device = map[Keys.device];
    const deviceId = map[Keys.deviceId];
    const version = map[Keys.version];
    return new CryptoMultiAccounts(masterFingerprint, cryptoHDKeys, device, deviceId, version);
};
CryptoMultiAccounts.fromCBOR = (_cborPayload) => {
    const dataItem = (0, lib_1.decodeToDataItem)(_cborPayload);
    return CryptoMultiAccounts.fromDataItem(dataItem);
};

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\extended\\CryptoMultiAccounts.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\extended\\DerivationSchema.js", {"../CryptoKeypath":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoKeypath.js","../RegistryItem":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryItem.js","../RegistryType":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryType.js","../lib":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5Cextended%5CDerivationSchema.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeyDerivationSchema = exports.DerivationAlgorithm = exports.Curve = void 0;
const RegistryType_1 = require("../RegistryType");
const RegistryItem_1 = require("../RegistryItem");
const lib_1 = require("../lib");
const CryptoKeypath_1 = require("../CryptoKeypath");
var Keys;
(function (Keys) {
    Keys[Keys["keyPath"] = 1] = "keyPath";
    Keys[Keys["curve"] = 2] = "curve";
    Keys[Keys["algo"] = 3] = "algo";
    Keys[Keys["chainType"] = 4] = "chainType";
})(Keys || (Keys = {}));
var Curve;
(function (Curve) {
    Curve[Curve["secp256k1"] = 0] = "secp256k1";
    Curve[Curve["ed25519"] = 1] = "ed25519";
})(Curve = exports.Curve || (exports.Curve = {}));
var DerivationAlgorithm;
(function (DerivationAlgorithm) {
    DerivationAlgorithm[DerivationAlgorithm["slip10"] = 0] = "slip10";
    DerivationAlgorithm[DerivationAlgorithm["bip32ed25519"] = 1] = "bip32ed25519";
})(DerivationAlgorithm = exports.DerivationAlgorithm || (exports.DerivationAlgorithm = {}));
class KeyDerivationSchema extends RegistryItem_1.RegistryItem {
    constructor(keypath, curve = Curve.secp256k1, algo = DerivationAlgorithm.slip10, chainType) {
        super();
        this.keypath = keypath;
        this.curve = curve;
        this.algo = algo;
        this.chainType = chainType;
        this.getRegistryType = () => RegistryType_1.RegistryTypes.KEY_DERIVATION_SCHEMA;
        this.getKeypath = () => this.keypath;
        this.getCurve = () => this.curve;
        this.getAlgo = () => this.algo;
        this.getChainType = () => this.chainType;
        this.toDataItem = () => {
            const map = {};
            const dataItem = this.getKeypath().toDataItem();
            dataItem.setTag(this.getKeypath().getRegistryType().getTag());
            map[Keys.keyPath] = dataItem;
            map[Keys.curve] = this.curve;
            map[Keys.algo] = this.algo;
            if (this.chainType) {
                map[Keys.chainType] = this.chainType;
            }
            return new lib_1.DataItem(map);
        };
    }
}
exports.KeyDerivationSchema = KeyDerivationSchema;
KeyDerivationSchema.fromDataItem = (dataItem) => {
    const map = dataItem.getData();
    const keypaths = CryptoKeypath_1.CryptoKeypath.fromDataItem(map[Keys.keyPath]);
    const curve = map[Keys.curve];
    const algo = map[Keys.algo];
    const chainType = map[Keys.chainType];
    return new KeyDerivationSchema(keypaths, curve, algo, chainType);
};
KeyDerivationSchema.fromCBOR = (_cborPayload) => {
    const dataItem = (0, lib_1.decodeToDataItem)(_cborPayload);
    return KeyDerivationSchema.fromDataItem(dataItem);
};

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\extended\\DerivationSchema.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\extended\\KeyDerivation.js", {"../RegistryItem":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryItem.js","../RegistryType":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryType.js","../lib":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\index.js","./DerivationSchema":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\extended\\DerivationSchema.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5Cextended%5CKeyDerivation.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeyDerivation = void 0;
const RegistryType_1 = require("../RegistryType");
const RegistryItem_1 = require("../RegistryItem");
const lib_1 = require("../lib");
const DerivationSchema_1 = require("./DerivationSchema");
var Keys;
(function (Keys) {
    Keys[Keys["schemas"] = 1] = "schemas";
})(Keys || (Keys = {}));
class KeyDerivation extends RegistryItem_1.RegistryItem {
    constructor(schemas) {
        super();
        this.schemas = schemas;
        this.getRegistryType = () => RegistryType_1.RegistryTypes.KEY_DERIVATION_CALL;
        this.getSchemas = () => this.schemas;
        this.toDataItem = () => {
            const map = {};
            map[Keys.schemas] = this.schemas.map(schema => {
                const dataItem = schema.toDataItem();
                dataItem.setTag(schema.getRegistryType().getTag());
                return dataItem;
            });
            return new lib_1.DataItem(map);
        };
    }
}
exports.KeyDerivation = KeyDerivation;
KeyDerivation.fromDataItem = (dataItem) => {
    const map = dataItem.getData();
    const schemas = map[Keys.schemas].map(keypath => DerivationSchema_1.KeyDerivationSchema.fromDataItem(keypath));
    return new KeyDerivation(schemas);
};
KeyDerivation.fromCBOR = (_cborPayload) => {
    const dataItem = (0, lib_1.decodeToDataItem)(_cborPayload);
    return KeyDerivation.fromDataItem(dataItem);
};

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\extended\\KeyDerivation.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\extended\\QRHardwareCall.js", {"../RegistryItem":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryItem.js","../RegistryType":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryType.js","../lib":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\index.js","./KeyDerivation":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\extended\\KeyDerivation.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5Cextended%5CQRHardwareCall.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.QRHardwareCall = exports.QRHardwareCallVersion = exports.QRHardwareCallType = void 0;
const RegistryType_1 = require("../RegistryType");
const RegistryItem_1 = require("../RegistryItem");
const lib_1 = require("../lib");
const KeyDerivation_1 = require("./KeyDerivation");
var Keys;
(function (Keys) {
    Keys[Keys["type"] = 1] = "type";
    Keys[Keys["params"] = 2] = "params";
    Keys[Keys["origin"] = 3] = "origin";
    Keys[Keys["version"] = 4] = "version";
})(Keys || (Keys = {}));
var QRHardwareCallType;
(function (QRHardwareCallType) {
    QRHardwareCallType[QRHardwareCallType["KeyDerivation"] = 0] = "KeyDerivation";
})(QRHardwareCallType = exports.QRHardwareCallType || (exports.QRHardwareCallType = {}));
var QRHardwareCallVersion;
(function (QRHardwareCallVersion) {
    QRHardwareCallVersion[QRHardwareCallVersion["V0"] = 0] = "V0";
    QRHardwareCallVersion[QRHardwareCallVersion["V1"] = 1] = "V1";
})(QRHardwareCallVersion = exports.QRHardwareCallVersion || (exports.QRHardwareCallVersion = {}));
class QRHardwareCall extends RegistryItem_1.RegistryItem {
    constructor(type, params, origin, version) {
        super();
        this.type = type;
        this.params = params;
        this.origin = origin;
        this.version = version;
        this.getRegistryType = () => RegistryType_1.RegistryTypes.QR_HARDWARE_CALL;
        this.getType = () => this.type;
        this.getParams = () => this.params;
        this.getOrigin = () => this.origin;
        this.getVersion = () => this.version;
        this.toDataItem = () => {
            const map = {};
            map[Keys.type] = this.type;
            const param = this.params.toDataItem();
            param.setTag(this.params.getRegistryType().getTag());
            map[Keys.params] = param;
            if (this.origin) {
                map[Keys.origin] = this.origin;
            }
            if (this.version) {
                map[Keys.version] = this.version;
            }
            return new lib_1.DataItem(map);
        };
    }
}
exports.QRHardwareCall = QRHardwareCall;
QRHardwareCall.fromDataItem = (dataItem) => {
    const map = dataItem.getData();
    const type = map[Keys.type] || QRHardwareCallType.KeyDerivation;
    let params;
    switch (type) {
        case QRHardwareCallType.KeyDerivation:
            params = KeyDerivation_1.KeyDerivation.fromDataItem(map[Keys.params]);
    }
    const origin = map[Keys.origin];
    const version = map[Keys.version];
    return new QRHardwareCall(type, params, origin, version);
};
QRHardwareCall.fromCBOR = (_cborPayload) => {
    const dataItem = (0, lib_1.decodeToDataItem)(_cborPayload);
    return QRHardwareCall.fromDataItem(dataItem);
};

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\extended\\QRHardwareCall.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\index.js", {"./Bytes":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\Bytes.js","./CryptoAccount":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoAccount.js","./CryptoCoinInfo":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoCoinInfo.js","./CryptoECKey":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoECKey.js","./CryptoHDKey":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoHDKey.js","./CryptoKeypath":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoKeypath.js","./CryptoOutput":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoOutput.js","./CryptoPSBT":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\CryptoPSBT.js","./Decoder":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\Decoder\\index.js","./MultiKey":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\MultiKey.js","./PathComponent":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\PathComponent.js","./RegistryItem":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryItem.js","./RegistryType":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryType.js","./ScriptExpression":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\ScriptExpression.js","./errors":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\errors\\index.js","./extended/CryptoMultiAccounts":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\extended\\CryptoMultiAccounts.js","./extended/DerivationSchema":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\extended\\DerivationSchema.js","./extended/KeyDerivation":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\extended\\KeyDerivation.js","./extended/QRHardwareCall":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\extended\\QRHardwareCall.js","./lib":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\index.js","./patchCBOR":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\patchCBOR.js","./types":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\types.js","./utils":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\utils.js","buffer/":"D:\\code\\v\\metamask-extension\\node_modules\\buffer\\index.js","tslib":"D:\\code\\v\\metamask-extension\\node_modules\\tslib\\tslib.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5Cindex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Buffer = exports.extend = exports.PathComponent = exports.ScriptExpressions = exports.MultiKey = exports.CryptoPSBT = exports.CryptoOutput = exports.CryptoECKey = exports.CryptoCoinInfoNetwork = exports.CryptoCoinInfoType = exports.CryptoCoinInfo = exports.CryptoKeypath = exports.CryptoMultiAccounts = exports.CryptoHDKey = exports.CryptoAccount = exports.Bytes = exports.URRegistryDecoder = exports.DataItem = void 0;
const tslib_1 = require("tslib");
require("./patchCBOR");
const buffer_1 = require("buffer/");
Object.defineProperty(exports, "Buffer", { enumerable: true, get: function () { return buffer_1.Buffer; } });
const CryptoHDKey_1 = require("./CryptoHDKey");
Object.defineProperty(exports, "CryptoHDKey", { enumerable: true, get: function () { return CryptoHDKey_1.CryptoHDKey; } });
const CryptoKeypath_1 = require("./CryptoKeypath");
Object.defineProperty(exports, "CryptoKeypath", { enumerable: true, get: function () { return CryptoKeypath_1.CryptoKeypath; } });
const CryptoCoinInfo_1 = require("./CryptoCoinInfo");
Object.defineProperty(exports, "CryptoCoinInfo", { enumerable: true, get: function () { return CryptoCoinInfo_1.CryptoCoinInfo; } });
Object.defineProperty(exports, "CryptoCoinInfoType", { enumerable: true, get: function () { return CryptoCoinInfo_1.Type; } });
Object.defineProperty(exports, "CryptoCoinInfoNetwork", { enumerable: true, get: function () { return CryptoCoinInfo_1.Network; } });
const CryptoECKey_1 = require("./CryptoECKey");
Object.defineProperty(exports, "CryptoECKey", { enumerable: true, get: function () { return CryptoECKey_1.CryptoECKey; } });
const Bytes_1 = require("./Bytes");
Object.defineProperty(exports, "Bytes", { enumerable: true, get: function () { return Bytes_1.Bytes; } });
const CryptoOutput_1 = require("./CryptoOutput");
Object.defineProperty(exports, "CryptoOutput", { enumerable: true, get: function () { return CryptoOutput_1.CryptoOutput; } });
const CryptoPSBT_1 = require("./CryptoPSBT");
Object.defineProperty(exports, "CryptoPSBT", { enumerable: true, get: function () { return CryptoPSBT_1.CryptoPSBT; } });
const CryptoAccount_1 = require("./CryptoAccount");
Object.defineProperty(exports, "CryptoAccount", { enumerable: true, get: function () { return CryptoAccount_1.CryptoAccount; } });
const Decoder_1 = require("./Decoder");
Object.defineProperty(exports, "URRegistryDecoder", { enumerable: true, get: function () { return Decoder_1.URRegistryDecoder; } });
const MultiKey_1 = require("./MultiKey");
Object.defineProperty(exports, "MultiKey", { enumerable: true, get: function () { return MultiKey_1.MultiKey; } });
const ScriptExpression_1 = require("./ScriptExpression");
Object.defineProperty(exports, "ScriptExpressions", { enumerable: true, get: function () { return ScriptExpression_1.ScriptExpressions; } });
const PathComponent_1 = require("./PathComponent");
Object.defineProperty(exports, "PathComponent", { enumerable: true, get: function () { return PathComponent_1.PathComponent; } });
const RegistryItem_1 = require("./RegistryItem");
const RegistryType_1 = require("./RegistryType");
const lib_1 = require("./lib");
var lib_2 = require("./lib");
Object.defineProperty(exports, "DataItem", { enumerable: true, get: function () { return lib_2.DataItem; } });
const utils_1 = require("./utils");
const CryptoMultiAccounts_1 = require("./extended/CryptoMultiAccounts");
Object.defineProperty(exports, "CryptoMultiAccounts", { enumerable: true, get: function () { return CryptoMultiAccounts_1.CryptoMultiAccounts; } });
const URlib = {
    URRegistryDecoder: Decoder_1.URRegistryDecoder,
    Bytes: Bytes_1.Bytes,
    CryptoAccount: CryptoAccount_1.CryptoAccount,
    CryptoHDKey: CryptoHDKey_1.CryptoHDKey,
    CryptoMultiAccounts: CryptoMultiAccounts_1.CryptoMultiAccounts,
    CryptoKeypath: CryptoKeypath_1.CryptoKeypath,
    CryptoCoinInfo: CryptoCoinInfo_1.CryptoCoinInfo,
    CryptoCoinInfoType: CryptoCoinInfo_1.Type,
    CryptoCoinInfoNetwork: CryptoCoinInfo_1.Network,
    CryptoECKey: CryptoECKey_1.CryptoECKey,
    CryptoOutput: CryptoOutput_1.CryptoOutput,
    CryptoPSBT: CryptoPSBT_1.CryptoPSBT,
    MultiKey: MultiKey_1.MultiKey,
    ScriptExpressions: ScriptExpression_1.ScriptExpressions,
    PathComponent: PathComponent_1.PathComponent,
};
const cbor = {
    addReader: lib_1.addReader,
    addSemanticDecode: lib_1.addSemanticDecode,
    addSemanticEncode: lib_1.addSemanticEncode,
    addWriter: lib_1.addWriter,
    patchTags: utils_1.patchTags,
};
const extend = {
    RegistryTypes: RegistryType_1.RegistryTypes,
    RegistryItem: RegistryItem_1.RegistryItem,
    RegistryType: RegistryType_1.RegistryType,
    decodeToDataItem: lib_1.decodeToDataItem,
    encodeDataItem: lib_1.encodeDataItem,
    cbor,
};
exports.extend = extend;
(0, tslib_1.__exportStar)(require("./errors"), exports);
(0, tslib_1.__exportStar)(require("./Decoder"), exports);
(0, tslib_1.__exportStar)(require("./lib"), exports);
(0, tslib_1.__exportStar)(require("./CryptoAccount"), exports);
(0, tslib_1.__exportStar)(require("./CryptoPSBT"), exports);
(0, tslib_1.__exportStar)(require("./CryptoHDKey"), exports);
(0, tslib_1.__exportStar)(require("./extended/CryptoMultiAccounts"), exports);
(0, tslib_1.__exportStar)(require("./extended/QRHardwareCall"), exports);
(0, tslib_1.__exportStar)(require("./extended/KeyDerivation"), exports);
(0, tslib_1.__exportStar)(require("./extended/DerivationSchema"), exports);
(0, tslib_1.__exportStar)(require("./CryptoOutput"), exports);
(0, tslib_1.__exportStar)(require("./CryptoCoinInfo"), exports);
(0, tslib_1.__exportStar)(require("./CryptoECKey"), exports);
(0, tslib_1.__exportStar)(require("./MultiKey"), exports);
(0, tslib_1.__exportStar)(require("./CryptoKeypath"), exports);
(0, tslib_1.__exportStar)(require("./patchCBOR"), exports);
(0, tslib_1.__exportStar)(require("./PathComponent"), exports);
(0, tslib_1.__exportStar)(require("./RegistryItem"), exports);
(0, tslib_1.__exportStar)(require("./RegistryType"), exports);
(0, tslib_1.__exportStar)(require("./types"), exports);
(0, tslib_1.__exportStar)(require("./utils"), exports);
exports.default = URlib;

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\DataItem.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5Clib%5CDataItem.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataItem = void 0;
class DataItem {
    constructor(data, tag) {
        this.setTag = (tag) => {
            this.tag = tag;
        };
        this.clearTag = () => {
            this.tag = undefined;
        };
        this.getTag = () => {
            return this.tag;
        };
        this.getData = () => {
            return this.data;
        };
        this.data = data;
        this.tag = tag;
    }
}
exports.DataItem = DataItem;

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\DataItem.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\cbor-sync.js", {"./DataItem":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\DataItem.js","buffer":"D:\\code\\v\\metamask-extension\\node_modules\\browserify\\node_modules\\buffer\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5Clib%5Ccbor-sync.js
      return function (require, module, exports) {
(function (Buffer){(function (){
"use strict";
(function (global, factory) {
    if (typeof define === 'function' && define.amd) {
        define([], factory);
    }
    else if (typeof module !== 'undefined' && module.exports) {
        module.exports = factory();
    }
    else {
        global.CBOR = factory();
    }
})(this, function () {
    const { DataItem } = require('./DataItem');
    var CBOR = (function () {
        function BinaryHex(hex) {
            this.$hex = hex;
        }
        BinaryHex.prototype = {
            length: function () {
                return this.$hex.length / 2;
            },
            toString: function (format) {
                if (!format || format === 'hex' || format === 16)
                    return this.$hex;
                if (format === 'utf-8') {
                    var encoded = '';
                    for (var i = 0; i < this.$hex.length; i += 2) {
                        encoded += '%' + this.$hex.substring(i, i + 2);
                    }
                    return decodeURIComponent(encoded);
                }
                if (format === 'latin') {
                    var encoded = [];
                    for (var i = 0; i < this.$hex.length; i += 2) {
                        encoded.push(parseInt(this.$hex.substring(i, i + 2), 16));
                    }
                    return String.fromCharCode.apply(String, encoded);
                }
                throw new Error('Unrecognised format: ' + format);
            },
        };
        BinaryHex.fromLatinString = function (latinString) {
            var hex = '';
            for (var i = 0; i < latinString.length; i++) {
                var pair = latinString.charCodeAt(i).toString(16);
                if (pair.length === 1)
                    pair = '0' + pair;
                hex += pair;
            }
            return new BinaryHex(hex);
        };
        BinaryHex.fromUtf8String = function (utf8String) {
            var encoded = encodeURIComponent(utf8String);
            var hex = '';
            for (var i = 0; i < encoded.length; i++) {
                if (encoded.charAt(i) === '%') {
                    hex += encoded.substring(i + 1, i + 3);
                    i += 2;
                }
                else {
                    var hexPair = encoded.charCodeAt(i).toString(16);
                    if (hexPair.length < 2)
                        hexPair = '0' + hexPair;
                    hex += hexPair;
                }
            }
            return new BinaryHex(hex);
        };
        var semanticEncoders = [];
        var semanticDecoders = {};
        var notImplemented = function (label) {
            return function () {
                throw new Error(label + ' not implemented');
            };
        };
        function Reader() { }
        Reader.prototype = {
            peekByte: notImplemented('peekByte'),
            readByte: notImplemented('readByte'),
            readChunk: notImplemented('readChunk'),
            readFloat16: function () {
                var half = this.readUint16();
                var exponent = (half & 0x7fff) >> 10;
                var mantissa = half & 0x3ff;
                var negative = half & 0x8000;
                if (exponent === 0x1f) {
                    if (mantissa === 0) {
                        return negative ? -Infinity : Infinity;
                    }
                    return NaN;
                }
                var magnitude = exponent
                    ? Math.pow(2, exponent - 25) * (1024 + mantissa)
                    : Math.pow(2, -24) * mantissa;
                return negative ? -magnitude : magnitude;
            },
            readFloat32: function () {
                var intValue = this.readUint32();
                var exponent = (intValue & 0x7fffffff) >> 23;
                var mantissa = intValue & 0x7fffff;
                var negative = intValue & 0x80000000;
                if (exponent === 0xff) {
                    if (mantissa === 0) {
                        return negative ? -Infinity : Infinity;
                    }
                    return NaN;
                }
                var magnitude = exponent
                    ? Math.pow(2, exponent - 23 - 127) * (8388608 + mantissa)
                    : Math.pow(2, -23 - 126) * mantissa;
                return negative ? -magnitude : magnitude;
            },
            readFloat64: function () {
                var int1 = this.readUint32(), int2 = this.readUint32();
                var exponent = (int1 >> 20) & 0x7ff;
                var mantissa = (int1 & 0xfffff) * 4294967296 + int2;
                var negative = int1 & 0x80000000;
                if (exponent === 0x7ff) {
                    if (mantissa === 0) {
                        return negative ? -Infinity : Infinity;
                    }
                    return NaN;
                }
                var magnitude = exponent
                    ? Math.pow(2, exponent - 52 - 1023) * (4503599627370496 + mantissa)
                    : Math.pow(2, -52 - 1022) * mantissa;
                return negative ? -magnitude : magnitude;
            },
            readUint16: function () {
                return this.readByte() * 256 + this.readByte();
            },
            readUint32: function () {
                return this.readUint16() * 65536 + this.readUint16();
            },
            readUint64: function () {
                return this.readUint32() * 4294967296 + this.readUint32();
            },
        };
        function Writer() { }
        Writer.prototype = {
            writeByte: notImplemented('writeByte'),
            result: notImplemented('result'),
            writeFloat16: notImplemented('writeFloat16'),
            writeFloat32: notImplemented('writeFloat32'),
            writeFloat64: notImplemented('writeFloat64'),
            writeUint16: function (value) {
                this.writeByte((value >> 8) & 0xff);
                this.writeByte(value & 0xff);
            },
            writeUint32: function (value) {
                this.writeUint16((value >> 16) & 0xffff);
                this.writeUint16(value & 0xffff);
            },
            writeUint64: function (value) {
                if (value >= 9007199254740992 || value <= -9007199254740992) {
                    throw new Error('Cannot encode Uint64 of: ' +
                        value +
                        ' magnitude to big (floating point errors)');
                }
                this.writeUint32(Math.floor(value / 4294967296));
                this.writeUint32(value % 4294967296);
            },
            writeString: notImplemented('writeString'),
            canWriteBinary: function (chunk) {
                return false;
            },
            writeBinary: notImplemented('writeChunk'),
        };
        function readHeaderRaw(reader) {
            var firstByte = reader.readByte();
            var majorType = firstByte >> 5, value = firstByte & 0x1f;
            return { type: majorType, value: value };
        }
        function valueFromHeader(header, reader) {
            var value = header.value;
            if (value < 24) {
                return value;
            }
            else if (value == 24) {
                return reader.readByte();
            }
            else if (value == 25) {
                return reader.readUint16();
            }
            else if (value == 26) {
                return reader.readUint32();
            }
            else if (value == 27) {
                return reader.readUint64();
            }
            else if (value == 31) {
                return null;
            }
            notImplemented('Additional info: ' + value)();
        }
        function writeHeaderRaw(type, value, writer) {
            writer.writeByte((type << 5) | value);
        }
        function writeHeader(type, value, writer) {
            var firstByte = type << 5;
            if (value < 24) {
                writer.writeByte(firstByte | value);
            }
            else if (value < 256) {
                writer.writeByte(firstByte | 24);
                writer.writeByte(value);
            }
            else if (value < 65536) {
                writer.writeByte(firstByte | 25);
                writer.writeUint16(value);
            }
            else if (value < 4294967296) {
                writer.writeByte(firstByte | 26);
                writer.writeUint32(value);
            }
            else {
                writer.writeByte(firstByte | 27);
                writer.writeUint64(value);
            }
        }
        var stopCode = new Error();
        function decodeReader(reader) {
            var header = readHeaderRaw(reader);
            switch (header.type) {
                case 0:
                    return valueFromHeader(header, reader);
                case 1:
                    return -1 - valueFromHeader(header, reader);
                case 2:
                    return reader.readChunk(valueFromHeader(header, reader));
                case 3:
                    var buffer = reader.readChunk(valueFromHeader(header, reader));
                    return buffer.toString('utf-8');
                case 4:
                case 5:
                    var arrayLength = valueFromHeader(header, reader);
                    var result = [];
                    if (arrayLength !== null) {
                        if (header.type === 5) {
                            arrayLength *= 2;
                        }
                        for (var i = 0; i < arrayLength; i++) {
                            result[i] = decodeReader(reader);
                        }
                    }
                    else {
                        var item;
                        while ((item = decodeReader(reader)) !== stopCode) {
                            result.push(item);
                        }
                    }
                    if (header.type === 5) {
                        var objResult = {};
                        for (var i = 0; i < result.length; i += 2) {
                            objResult[result[i]] = result[i + 1];
                        }
                        return objResult;
                    }
                    else {
                        return result;
                    }
                case 6:
                    var tag = valueFromHeader(header, reader);
                    var decoder = semanticDecoders[tag];
                    var result = decodeReader(reader);
                    return decoder ? decoder(result) : result;
                case 7:
                    if (header.value === 25) {
                        return reader.readFloat16();
                    }
                    else if (header.value === 26) {
                        return reader.readFloat32();
                    }
                    else if (header.value === 27) {
                        return reader.readFloat64();
                    }
                    switch (valueFromHeader(header, reader)) {
                        case 20:
                            return false;
                        case 21:
                            return true;
                        case 22:
                            return null;
                        case 23:
                            return undefined;
                        case null:
                            return stopCode;
                        default:
                            throw new Error('Unknown fixed value: ' + header.value);
                    }
                default:
                    throw new Error('Unsupported header: ' + JSON.stringify(header));
            }
            throw new Error('not implemented yet');
        }
        function encodeWriter(data, writer) {
            for (var i = 0; i < semanticEncoders.length; i++) {
                var replacement = semanticEncoders[i].fn(data);
                if (replacement !== undefined) {
                    writeHeader(6, semanticEncoders[i].tag, writer);
                    return encodeWriter(replacement, writer);
                }
            }
            if (data && typeof data.toCBOR === 'function') {
                data = data.toCBOR();
            }
            if (data === false) {
                writeHeader(7, 20, writer);
            }
            else if (data === true) {
                writeHeader(7, 21, writer);
            }
            else if (data === null) {
                writeHeader(7, 22, writer);
            }
            else if (data === undefined) {
                writeHeader(7, 23, writer);
            }
            else if (typeof data === 'number') {
                if (Math.floor(data) === data &&
                    data < 9007199254740992 &&
                    data > -9007199254740992) {
                    if (data < 0) {
                        writeHeader(1, -1 - data, writer);
                    }
                    else {
                        writeHeader(0, data, writer);
                    }
                }
                else {
                    writeHeaderRaw(7, 27, writer);
                    writer.writeFloat64(data);
                }
            }
            else if (typeof data === 'string') {
                writer.writeString(data, function (length) {
                    writeHeader(3, length, writer);
                });
            }
            else if (writer.canWriteBinary(data)) {
                writer.writeBinary(data, function (length) {
                    writeHeader(2, length, writer);
                });
            }
            else if (typeof data === 'object') {
                if (api.config.useToJSON && typeof data.toJSON === 'function') {
                    data = data.toJSON();
                }
                if (Array.isArray(data)) {
                    writeHeader(4, data.length, writer);
                    for (var i = 0; i < data.length; i++) {
                        encodeWriter(data[i], writer);
                    }
                }
                else {
                    var keys = Object.keys(data);
                    writeHeader(5, keys.length, writer);
                    for (var i = 0; i < keys.length; i++) {
                        const number = parseInt(keys[i]);
                        if (isNaN(number)) {
                            encodeWriter(keys[i], writer);
                            encodeWriter(data[keys[i]], writer);
                        }
                        else {
                            encodeWriter(number, writer);
                            encodeWriter(data[keys[i]], writer);
                        }
                    }
                }
            }
            else {
                throw new Error('CBOR encoding not supported: ' + data);
            }
        }
        var readerFunctions = [];
        var writerFunctions = [];
        var api = {
            config: {
                useToJSON: true,
            },
            addWriter: function (format, writerFunction) {
                if (typeof format === 'string') {
                    writerFunctions.push(function (f) {
                        if (format === f)
                            return writerFunction(f);
                    });
                }
                else {
                    writerFunctions.push(format);
                }
            },
            addReader: function (format, readerFunction) {
                if (typeof format === 'string') {
                    readerFunctions.push(function (data, f) {
                        if (format === f)
                            return readerFunction(data, f);
                    });
                }
                else {
                    readerFunctions.push(format);
                }
            },
            encode: function (data, format) {
                for (var i = 0; i < writerFunctions.length; i++) {
                    var func = writerFunctions[i];
                    var writer = func(format);
                    if (writer) {
                        encodeWriter(data, writer);
                        return writer.result();
                    }
                }
                throw new Error('Unsupported output format: ' + format);
            },
            encodeDataItem: function (data, format) {
                for (var i = 0; i < writerFunctions.length; i++) {
                    var func = writerFunctions[i];
                    var writer = func(format);
                    if (writer) {
                        if (data.getTag() !== undefined) {
                            encodeWriter(data, writer);
                            return writer.result();
                        }
                        else {
                            encodeWriter(data.getData(), writer);
                            return writer.result();
                        }
                    }
                }
                throw new Error('Unsupported output format: ' + format);
            },
            decode: function (data, format) {
                for (var i = 0; i < readerFunctions.length; i++) {
                    var func = readerFunctions[i];
                    var reader = func(data, format);
                    if (reader) {
                        return decodeReader(reader);
                    }
                }
                throw new Error('Unsupported input format: ' + format);
            },
            decodeToDataItem: function (data, format) {
                for (var i = 0; i < readerFunctions.length; i++) {
                    var func = readerFunctions[i];
                    var reader = func(data, format);
                    if (reader) {
                        const result = decodeReader(reader);
                        if (result instanceof DataItem) {
                            return result;
                        }
                        else {
                            return new DataItem(result);
                        }
                    }
                }
                throw new Error('Unsupported input format: ' + format);
            },
            addSemanticEncode: function (tag, fn) {
                if (typeof tag !== 'number' || tag % 1 !== 0 || tag < 0) {
                    throw new Error('Tag must be a positive integer');
                }
                semanticEncoders.push({ tag: tag, fn: fn });
                return this;
            },
            addSemanticDecode: function (tag, fn) {
                if (typeof tag !== 'number' || tag % 1 !== 0 || tag < 0) {
                    throw new Error('Tag must be a positive integer');
                }
                semanticDecoders[tag] = fn;
                return this;
            },
        };
        function BufferReader(buffer) {
            this.buffer = buffer;
            this.pos = 0;
        }
        BufferReader.prototype = Object.create(Reader.prototype);
        BufferReader.prototype.peekByte = function () {
            return this.buffer[this.pos];
        };
        BufferReader.prototype.readByte = function () {
            return this.buffer[this.pos++];
        };
        BufferReader.prototype.readUint16 = function () {
            var result = this.buffer.readUInt16BE(this.pos);
            this.pos += 2;
            return result;
        };
        BufferReader.prototype.readUint32 = function () {
            var result = this.buffer.readUInt32BE(this.pos);
            this.pos += 4;
            return result;
        };
        BufferReader.prototype.readFloat32 = function () {
            var result = this.buffer.readFloatBE(this.pos);
            this.pos += 4;
            return result;
        };
        BufferReader.prototype.readFloat64 = function () {
            var result = this.buffer.readDoubleBE(this.pos);
            this.pos += 8;
            return result;
        };
        BufferReader.prototype.readChunk = function (length) {
            var result = Buffer.alloc(length);
            this.buffer.copy(result, 0, this.pos, (this.pos += length));
            return result;
        };
        function BufferWriter(stringFormat) {
            this.byteLength = 0;
            this.defaultBufferLength = 16384;
            this.latestBuffer = Buffer.alloc(this.defaultBufferLength);
            this.latestBufferOffset = 0;
            this.completeBuffers = [];
            this.stringFormat = stringFormat;
        }
        BufferWriter.prototype = Object.create(Writer.prototype);
        BufferWriter.prototype.writeByte = function (value) {
            this.latestBuffer[this.latestBufferOffset++] = value;
            if (this.latestBufferOffset >= this.latestBuffer.length) {
                this.completeBuffers.push(this.latestBuffer);
                this.latestBuffer = Buffer.alloc(this.defaultBufferLength);
                this.latestBufferOffset = 0;
            }
            this.byteLength++;
        };
        BufferWriter.prototype.writeFloat32 = function (value) {
            var buffer = Buffer.alloc(4);
            buffer.writeFloatBE(value, 0);
            this.writeBuffer(buffer);
        };
        BufferWriter.prototype.writeFloat64 = function (value) {
            var buffer = Buffer.alloc(8);
            buffer.writeDoubleBE(value, 0);
            this.writeBuffer(buffer);
        };
        BufferWriter.prototype.writeString = function (string, lengthFunc) {
            var buffer = Buffer.from(string, 'utf-8');
            lengthFunc(buffer.length);
            this.writeBuffer(buffer);
        };
        BufferWriter.prototype.canWriteBinary = function (data) {
            return data instanceof Buffer;
        };
        BufferWriter.prototype.writeBinary = function (buffer, lengthFunc) {
            lengthFunc(buffer.length);
            this.writeBuffer(buffer);
        };
        BufferWriter.prototype.writeBuffer = function (chunk) {
            if (!(chunk instanceof Buffer))
                throw new TypeError('BufferWriter only accepts Buffers');
            if (!this.latestBufferOffset) {
                this.completeBuffers.push(chunk);
            }
            else if (this.latestBuffer.length - this.latestBufferOffset >=
                chunk.length) {
                chunk.copy(this.latestBuffer, this.latestBufferOffset);
                this.latestBufferOffset += chunk.length;
                if (this.latestBufferOffset >= this.latestBuffer.length) {
                    this.completeBuffers.push(this.latestBuffer);
                    this.latestBuffer = Buffer.alloc(this.defaultBufferLength);
                    this.latestBufferOffset = 0;
                }
            }
            else {
                this.completeBuffers.push(this.latestBuffer.slice(0, this.latestBufferOffset));
                this.completeBuffers.push(chunk);
                this.latestBuffer = Buffer.alloc(this.defaultBufferLength);
                this.latestBufferOffset = 0;
            }
            this.byteLength += chunk.length;
        };
        BufferWriter.prototype.result = function () {
            var result = Buffer.alloc(this.byteLength);
            var offset = 0;
            for (var i = 0; i < this.completeBuffers.length; i++) {
                var buffer = this.completeBuffers[i];
                buffer.copy(result, offset, 0, buffer.length);
                offset += buffer.length;
            }
            if (this.latestBufferOffset) {
                this.latestBuffer.copy(result, offset, 0, this.latestBufferOffset);
            }
            if (this.stringFormat)
                return result.toString(this.stringFormat);
            return result;
        };
        if (typeof Buffer === 'function') {
            api.addReader(function (data, format) {
                if (Buffer.isBuffer(data)) {
                    return new BufferReader(data);
                }
                if (format === 'hex' || format === 'base64') {
                    var buffer = Buffer.from(data, format);
                    return new BufferReader(buffer);
                }
            });
            api.addWriter(function (format) {
                if (!format || format === 'buffer') {
                    return new BufferWriter();
                }
                else if (format === 'hex' || format === 'base64') {
                    return new BufferWriter(format);
                }
            });
        }
        function HexReader(hex) {
            this.hex = hex;
            this.pos = 0;
        }
        HexReader.prototype = Object.create(Reader.prototype);
        HexReader.prototype.peekByte = function () {
            var pair = this.hex.substring(this.pos, 2);
            return parseInt(pair, 16);
        };
        HexReader.prototype.readByte = function () {
            var pair = this.hex.substring(this.pos, this.pos + 2);
            this.pos += 2;
            return parseInt(pair, 16);
        };
        HexReader.prototype.readChunk = function (length) {
            var hex = this.hex.substring(this.pos, this.pos + length * 2);
            this.pos += length * 2;
            if (typeof Buffer === 'function')
                return Buffer.from(hex, 'hex');
            return new BinaryHex(hex);
        };
        function HexWriter(finalFormat) {
            this.$hex = '';
            this.finalFormat = finalFormat || 'hex';
        }
        HexWriter.prototype = Object.create(Writer.prototype);
        HexWriter.prototype.writeByte = function (value) {
            if (value < 0 || value > 255)
                throw new Error('Byte value out of range: ' + value);
            var hex = value.toString(16);
            if (hex.length == 1) {
                hex = '0' + hex;
            }
            this.$hex += hex;
        };
        HexWriter.prototype.canWriteBinary = function (chunk) {
            return (chunk instanceof BinaryHex ||
                (typeof Buffer === 'function' && chunk instanceof Buffer));
        };
        HexWriter.prototype.writeBinary = function (chunk, lengthFunction) {
            if (chunk instanceof BinaryHex) {
                lengthFunction(chunk.length());
                this.$hex += chunk.$hex;
            }
            else if (typeof Buffer === 'function' && chunk instanceof Buffer) {
                lengthFunction(chunk.length);
                this.$hex += chunk.toString('hex');
            }
            else {
                throw new TypeError('HexWriter only accepts BinaryHex or Buffers');
            }
        };
        HexWriter.prototype.result = function () {
            if (this.finalFormat === 'buffer' && typeof Buffer === 'function') {
                return Buffer.from(this.$hex, 'hex');
            }
            return new BinaryHex(this.$hex).toString(this.finalFormat);
        };
        HexWriter.prototype.writeString = function (string, lengthFunction) {
            var buffer = BinaryHex.fromUtf8String(string);
            lengthFunction(buffer.length());
            this.$hex += buffer.$hex;
        };
        api.addReader(function (data, format) {
            if (data instanceof BinaryHex || data.$hex) {
                return new HexReader(data.$hex);
            }
            if (format === 'hex') {
                return new HexReader(data);
            }
        });
        api.addWriter(function (format) {
            if (format === 'hex') {
                return new HexWriter();
            }
        });
        return api;
    })();
    CBOR.addSemanticEncode(0, function (data) {
        if (data instanceof Date) {
            return data.toISOString();
        }
    })
        .addSemanticDecode(0, function (isoString) {
        return new Date(isoString);
    })
        .addSemanticDecode(1, function (isoString) {
        return new Date(isoString);
    });
    return CBOR;
});

}).call(this)}).call(this,require("buffer").Buffer)

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\cbor-sync.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\index.js", {"./DataItem":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\DataItem.js","./cbor-sync":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\cbor-sync.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5Clib%5Cindex.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataItem = exports.addWriter = exports.addReader = exports.addSemanticEncode = exports.addSemanticDecode = exports.decodeToDataItem = exports.encodeDataItem = void 0;
var cbor_sync_1 = require("./cbor-sync");
Object.defineProperty(exports, "encodeDataItem", { enumerable: true, get: function () { return cbor_sync_1.encodeDataItem; } });
Object.defineProperty(exports, "decodeToDataItem", { enumerable: true, get: function () { return cbor_sync_1.decodeToDataItem; } });
Object.defineProperty(exports, "addSemanticDecode", { enumerable: true, get: function () { return cbor_sync_1.addSemanticDecode; } });
Object.defineProperty(exports, "addSemanticEncode", { enumerable: true, get: function () { return cbor_sync_1.addSemanticEncode; } });
Object.defineProperty(exports, "addReader", { enumerable: true, get: function () { return cbor_sync_1.addReader; } });
Object.defineProperty(exports, "addWriter", { enumerable: true, get: function () { return cbor_sync_1.addWriter; } });
var DataItem_1 = require("./DataItem");
Object.defineProperty(exports, "DataItem", { enumerable: true, get: function () { return DataItem_1.DataItem; } });

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\patchCBOR.js", {"./RegistryType":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\RegistryType.js","./ScriptExpression":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\ScriptExpression.js","./utils":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\utils.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5CpatchCBOR.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("./utils");
const RegistryType_1 = require("./RegistryType");
const ScriptExpression_1 = require("./ScriptExpression");
const registryTags = Object.values(RegistryType_1.RegistryTypes)
    .filter((r) => !!r.getTag())
    .map((r) => r.getTag());
const scriptExpressionTags = Object.values(ScriptExpression_1.ScriptExpressions).map((se) => se.getTag());
(0, utils_1.patchTags)(registryTags.concat(scriptExpressionTags));

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\patchCBOR.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\types.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5Ctypes.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\types.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\utils.js", {"./lib":"D:\\code\\v\\metamask-extension\\node_modules\\@keystonehq\\bc-ur-registry\\dist\\lib\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@keystonehq%5Cbc-ur-registry%5Cdist%5Cutils.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.patchTags = void 0;
const lib_1 = require("./lib");
const alreadyPatchedTag = [];
const patchTags = (tags) => {
    tags.forEach((tag) => {
        if (alreadyPatchedTag.find((i) => i === tag))
            return;
        (0, lib_1.addSemanticEncode)(tag, (data) => {
            if (data instanceof lib_1.DataItem) {
                if (data.getTag() === tag) {
                    return data.getData();
                }
            }
        });
        (0, lib_1.addSemanticDecode)(tag, (data) => {
            return new lib_1.DataItem(data, tag);
        });
        alreadyPatchedTag.push(tag);
    });
};
exports.patchTags = patchTags;

      };
    };
  }
  }
}, {package:"@keystonehq/bc-ur-registry-eth>@keystonehq/bc-ur-registry",file:"node_modules\\@keystonehq\\bc-ur-registry\\dist\\utils.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@kurkle\\color\\dist\\color.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@kurkle%5Ccolor%5Cdist%5Ccolor.cjs
      return function (require, module, exports) {
/*!
 * @kurkle/color v0.3.2
 * https://github.com/kurkle/color#readme
 * (c) 2023 Jukka Kurkela
 * Released under the MIT License
 */
(function (global, factory) {
typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
typeof define === 'function' && define.amd ? define(factory) :
(global = typeof globalThis !== 'undefined' ? globalThis : global || self, global["@kurkle/color"] = factory());
})(this, (function () { 'use strict';

function round(v) {
  return v + 0.5 | 0;
}
const lim = (v, l, h) => Math.max(Math.min(v, h), l);
function p2b(v) {
  return lim(round(v * 2.55), 0, 255);
}
function b2p(v) {
  return lim(round(v / 2.55), 0, 100);
}
function n2b(v) {
  return lim(round(v * 255), 0, 255);
}
function b2n(v) {
  return lim(round(v / 2.55) / 100, 0, 1);
}
function n2p(v) {
  return lim(round(v * 100), 0, 100);
}

const map$1 = {0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, A: 10, B: 11, C: 12, D: 13, E: 14, F: 15, a: 10, b: 11, c: 12, d: 13, e: 14, f: 15};
const hex = [...'0123456789ABCDEF'];
const h1 = b => hex[b & 0xF];
const h2 = b => hex[(b & 0xF0) >> 4] + hex[b & 0xF];
const eq = b => ((b & 0xF0) >> 4) === (b & 0xF);
const isShort = v => eq(v.r) && eq(v.g) && eq(v.b) && eq(v.a);
function hexParse(str) {
  var len = str.length;
  var ret;
  if (str[0] === '#') {
    if (len === 4 || len === 5) {
      ret = {
        r: 255 & map$1[str[1]] * 17,
        g: 255 & map$1[str[2]] * 17,
        b: 255 & map$1[str[3]] * 17,
        a: len === 5 ? map$1[str[4]] * 17 : 255
      };
    } else if (len === 7 || len === 9) {
      ret = {
        r: map$1[str[1]] << 4 | map$1[str[2]],
        g: map$1[str[3]] << 4 | map$1[str[4]],
        b: map$1[str[5]] << 4 | map$1[str[6]],
        a: len === 9 ? (map$1[str[7]] << 4 | map$1[str[8]]) : 255
      };
    }
  }
  return ret;
}
const alpha = (a, f) => a < 255 ? f(a) : '';
function hexString(v) {
  var f = isShort(v) ? h1 : h2;
  return v
    ? '#' + f(v.r) + f(v.g) + f(v.b) + alpha(v.a, f)
    : undefined;
}

const HUE_RE = /^(hsla?|hwb|hsv)\(\s*([-+.e\d]+)(?:deg)?[\s,]+([-+.e\d]+)%[\s,]+([-+.e\d]+)%(?:[\s,]+([-+.e\d]+)(%)?)?\s*\)$/;
function hsl2rgbn(h, s, l) {
  const a = s * Math.min(l, 1 - l);
  const f = (n, k = (n + h / 30) % 12) => l - a * Math.max(Math.min(k - 3, 9 - k, 1), -1);
  return [f(0), f(8), f(4)];
}
function hsv2rgbn(h, s, v) {
  const f = (n, k = (n + h / 60) % 6) => v - v * s * Math.max(Math.min(k, 4 - k, 1), 0);
  return [f(5), f(3), f(1)];
}
function hwb2rgbn(h, w, b) {
  const rgb = hsl2rgbn(h, 1, 0.5);
  let i;
  if (w + b > 1) {
    i = 1 / (w + b);
    w *= i;
    b *= i;
  }
  for (i = 0; i < 3; i++) {
    rgb[i] *= 1 - w - b;
    rgb[i] += w;
  }
  return rgb;
}
function hueValue(r, g, b, d, max) {
  if (r === max) {
    return ((g - b) / d) + (g < b ? 6 : 0);
  }
  if (g === max) {
    return (b - r) / d + 2;
  }
  return (r - g) / d + 4;
}
function rgb2hsl(v) {
  const range = 255;
  const r = v.r / range;
  const g = v.g / range;
  const b = v.b / range;
  const max = Math.max(r, g, b);
  const min = Math.min(r, g, b);
  const l = (max + min) / 2;
  let h, s, d;
  if (max !== min) {
    d = max - min;
    s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
    h = hueValue(r, g, b, d, max);
    h = h * 60 + 0.5;
  }
  return [h | 0, s || 0, l];
}
function calln(f, a, b, c) {
  return (
    Array.isArray(a)
      ? f(a[0], a[1], a[2])
      : f(a, b, c)
  ).map(n2b);
}
function hsl2rgb(h, s, l) {
  return calln(hsl2rgbn, h, s, l);
}
function hwb2rgb(h, w, b) {
  return calln(hwb2rgbn, h, w, b);
}
function hsv2rgb(h, s, v) {
  return calln(hsv2rgbn, h, s, v);
}
function hue(h) {
  return (h % 360 + 360) % 360;
}
function hueParse(str) {
  const m = HUE_RE.exec(str);
  let a = 255;
  let v;
  if (!m) {
    return;
  }
  if (m[5] !== v) {
    a = m[6] ? p2b(+m[5]) : n2b(+m[5]);
  }
  const h = hue(+m[2]);
  const p1 = +m[3] / 100;
  const p2 = +m[4] / 100;
  if (m[1] === 'hwb') {
    v = hwb2rgb(h, p1, p2);
  } else if (m[1] === 'hsv') {
    v = hsv2rgb(h, p1, p2);
  } else {
    v = hsl2rgb(h, p1, p2);
  }
  return {
    r: v[0],
    g: v[1],
    b: v[2],
    a: a
  };
}
function rotate(v, deg) {
  var h = rgb2hsl(v);
  h[0] = hue(h[0] + deg);
  h = hsl2rgb(h);
  v.r = h[0];
  v.g = h[1];
  v.b = h[2];
}
function hslString(v) {
  if (!v) {
    return;
  }
  const a = rgb2hsl(v);
  const h = a[0];
  const s = n2p(a[1]);
  const l = n2p(a[2]);
  return v.a < 255
    ? `hsla(${h}, ${s}%, ${l}%, ${b2n(v.a)})`
    : `hsl(${h}, ${s}%, ${l}%)`;
}

const map = {
  x: 'dark',
  Z: 'light',
  Y: 're',
  X: 'blu',
  W: 'gr',
  V: 'medium',
  U: 'slate',
  A: 'ee',
  T: 'ol',
  S: 'or',
  B: 'ra',
  C: 'lateg',
  D: 'ights',
  R: 'in',
  Q: 'turquois',
  E: 'hi',
  P: 'ro',
  O: 'al',
  N: 'le',
  M: 'de',
  L: 'yello',
  F: 'en',
  K: 'ch',
  G: 'arks',
  H: 'ea',
  I: 'ightg',
  J: 'wh'
};
const names$1 = {
  OiceXe: 'f0f8ff',
  antiquewEte: 'faebd7',
  aqua: 'ffff',
  aquamarRe: '7fffd4',
  azuY: 'f0ffff',
  beige: 'f5f5dc',
  bisque: 'ffe4c4',
  black: '0',
  blanKedOmond: 'ffebcd',
  Xe: 'ff',
  XeviTet: '8a2be2',
  bPwn: 'a52a2a',
  burlywood: 'deb887',
  caMtXe: '5f9ea0',
  KartYuse: '7fff00',
  KocTate: 'd2691e',
  cSO: 'ff7f50',
  cSnflowerXe: '6495ed',
  cSnsilk: 'fff8dc',
  crimson: 'dc143c',
  cyan: 'ffff',
  xXe: '8b',
  xcyan: '8b8b',
  xgTMnPd: 'b8860b',
  xWay: 'a9a9a9',
  xgYF: '6400',
  xgYy: 'a9a9a9',
  xkhaki: 'bdb76b',
  xmagFta: '8b008b',
  xTivegYF: '556b2f',
  xSange: 'ff8c00',
  xScEd: '9932cc',
  xYd: '8b0000',
  xsOmon: 'e9967a',
  xsHgYF: '8fbc8f',
  xUXe: '483d8b',
  xUWay: '2f4f4f',
  xUgYy: '2f4f4f',
  xQe: 'ced1',
  xviTet: '9400d3',
  dAppRk: 'ff1493',
  dApskyXe: 'bfff',
  dimWay: '696969',
  dimgYy: '696969',
  dodgerXe: '1e90ff',
  fiYbrick: 'b22222',
  flSOwEte: 'fffaf0',
  foYstWAn: '228b22',
  fuKsia: 'ff00ff',
  gaRsbSo: 'dcdcdc',
  ghostwEte: 'f8f8ff',
  gTd: 'ffd700',
  gTMnPd: 'daa520',
  Way: '808080',
  gYF: '8000',
  gYFLw: 'adff2f',
  gYy: '808080',
  honeyMw: 'f0fff0',
  hotpRk: 'ff69b4',
  RdianYd: 'cd5c5c',
  Rdigo: '4b0082',
  ivSy: 'fffff0',
  khaki: 'f0e68c',
  lavFMr: 'e6e6fa',
  lavFMrXsh: 'fff0f5',
  lawngYF: '7cfc00',
  NmoncEffon: 'fffacd',
  ZXe: 'add8e6',
  ZcSO: 'f08080',
  Zcyan: 'e0ffff',
  ZgTMnPdLw: 'fafad2',
  ZWay: 'd3d3d3',
  ZgYF: '90ee90',
  ZgYy: 'd3d3d3',
  ZpRk: 'ffb6c1',
  ZsOmon: 'ffa07a',
  ZsHgYF: '20b2aa',
  ZskyXe: '87cefa',
  ZUWay: '778899',
  ZUgYy: '778899',
  ZstAlXe: 'b0c4de',
  ZLw: 'ffffe0',
  lime: 'ff00',
  limegYF: '32cd32',
  lRF: 'faf0e6',
  magFta: 'ff00ff',
  maPon: '800000',
  VaquamarRe: '66cdaa',
  VXe: 'cd',
  VScEd: 'ba55d3',
  VpurpN: '9370db',
  VsHgYF: '3cb371',
  VUXe: '7b68ee',
  VsprRggYF: 'fa9a',
  VQe: '48d1cc',
  VviTetYd: 'c71585',
  midnightXe: '191970',
  mRtcYam: 'f5fffa',
  mistyPse: 'ffe4e1',
  moccasR: 'ffe4b5',
  navajowEte: 'ffdead',
  navy: '80',
  Tdlace: 'fdf5e6',
  Tive: '808000',
  TivedBb: '6b8e23',
  Sange: 'ffa500',
  SangeYd: 'ff4500',
  ScEd: 'da70d6',
  pOegTMnPd: 'eee8aa',
  pOegYF: '98fb98',
  pOeQe: 'afeeee',
  pOeviTetYd: 'db7093',
  papayawEp: 'ffefd5',
  pHKpuff: 'ffdab9',
  peru: 'cd853f',
  pRk: 'ffc0cb',
  plum: 'dda0dd',
  powMrXe: 'b0e0e6',
  purpN: '800080',
  YbeccapurpN: '663399',
  Yd: 'ff0000',
  Psybrown: 'bc8f8f',
  PyOXe: '4169e1',
  saddNbPwn: '8b4513',
  sOmon: 'fa8072',
  sandybPwn: 'f4a460',
  sHgYF: '2e8b57',
  sHshell: 'fff5ee',
  siFna: 'a0522d',
  silver: 'c0c0c0',
  skyXe: '87ceeb',
  UXe: '6a5acd',
  UWay: '708090',
  UgYy: '708090',
  snow: 'fffafa',
  sprRggYF: 'ff7f',
  stAlXe: '4682b4',
  tan: 'd2b48c',
  teO: '8080',
  tEstN: 'd8bfd8',
  tomato: 'ff6347',
  Qe: '40e0d0',
  viTet: 'ee82ee',
  JHt: 'f5deb3',
  wEte: 'ffffff',
  wEtesmoke: 'f5f5f5',
  Lw: 'ffff00',
  LwgYF: '9acd32'
};
function unpack() {
  const unpacked = {};
  const keys = Object.keys(names$1);
  const tkeys = Object.keys(map);
  let i, j, k, ok, nk;
  for (i = 0; i < keys.length; i++) {
    ok = nk = keys[i];
    for (j = 0; j < tkeys.length; j++) {
      k = tkeys[j];
      nk = nk.replace(k, map[k]);
    }
    k = parseInt(names$1[ok], 16);
    unpacked[nk] = [k >> 16 & 0xFF, k >> 8 & 0xFF, k & 0xFF];
  }
  return unpacked;
}

let names;
function nameParse(str) {
  if (!names) {
    names = unpack();
    names.transparent = [0, 0, 0, 0];
  }
  const a = names[str.toLowerCase()];
  return a && {
    r: a[0],
    g: a[1],
    b: a[2],
    a: a.length === 4 ? a[3] : 255
  };
}

const RGB_RE = /^rgba?\(\s*([-+.\d]+)(%)?[\s,]+([-+.e\d]+)(%)?[\s,]+([-+.e\d]+)(%)?(?:[\s,/]+([-+.e\d]+)(%)?)?\s*\)$/;
function rgbParse(str) {
  const m = RGB_RE.exec(str);
  let a = 255;
  let r, g, b;
  if (!m) {
    return;
  }
  if (m[7] !== r) {
    const v = +m[7];
    a = m[8] ? p2b(v) : lim(v * 255, 0, 255);
  }
  r = +m[1];
  g = +m[3];
  b = +m[5];
  r = 255 & (m[2] ? p2b(r) : lim(r, 0, 255));
  g = 255 & (m[4] ? p2b(g) : lim(g, 0, 255));
  b = 255 & (m[6] ? p2b(b) : lim(b, 0, 255));
  return {
    r: r,
    g: g,
    b: b,
    a: a
  };
}
function rgbString(v) {
  return v && (
    v.a < 255
      ? `rgba(${v.r}, ${v.g}, ${v.b}, ${b2n(v.a)})`
      : `rgb(${v.r}, ${v.g}, ${v.b})`
  );
}

const to = v => v <= 0.0031308 ? v * 12.92 : Math.pow(v, 1.0 / 2.4) * 1.055 - 0.055;
const from = v => v <= 0.04045 ? v / 12.92 : Math.pow((v + 0.055) / 1.055, 2.4);
function interpolate(rgb1, rgb2, t) {
  const r = from(b2n(rgb1.r));
  const g = from(b2n(rgb1.g));
  const b = from(b2n(rgb1.b));
  return {
    r: n2b(to(r + t * (from(b2n(rgb2.r)) - r))),
    g: n2b(to(g + t * (from(b2n(rgb2.g)) - g))),
    b: n2b(to(b + t * (from(b2n(rgb2.b)) - b))),
    a: rgb1.a + t * (rgb2.a - rgb1.a)
  };
}

function modHSL(v, i, ratio) {
  if (v) {
    let tmp = rgb2hsl(v);
    tmp[i] = Math.max(0, Math.min(tmp[i] + tmp[i] * ratio, i === 0 ? 360 : 1));
    tmp = hsl2rgb(tmp);
    v.r = tmp[0];
    v.g = tmp[1];
    v.b = tmp[2];
  }
}
function clone(v, proto) {
  return v ? Object.assign(proto || {}, v) : v;
}
function fromObject(input) {
  var v = {r: 0, g: 0, b: 0, a: 255};
  if (Array.isArray(input)) {
    if (input.length >= 3) {
      v = {r: input[0], g: input[1], b: input[2], a: 255};
      if (input.length > 3) {
        v.a = n2b(input[3]);
      }
    }
  } else {
    v = clone(input, {r: 0, g: 0, b: 0, a: 1});
    v.a = n2b(v.a);
  }
  return v;
}
function functionParse(str) {
  if (str.charAt(0) === 'r') {
    return rgbParse(str);
  }
  return hueParse(str);
}
class Color {
  constructor(input) {
    if (input instanceof Color) {
      return input;
    }
    const type = typeof input;
    let v;
    if (type === 'object') {
      v = fromObject(input);
    } else if (type === 'string') {
      v = hexParse(input) || nameParse(input) || functionParse(input);
    }
    this._rgb = v;
    this._valid = !!v;
  }
  get valid() {
    return this._valid;
  }
  get rgb() {
    var v = clone(this._rgb);
    if (v) {
      v.a = b2n(v.a);
    }
    return v;
  }
  set rgb(obj) {
    this._rgb = fromObject(obj);
  }
  rgbString() {
    return this._valid ? rgbString(this._rgb) : undefined;
  }
  hexString() {
    return this._valid ? hexString(this._rgb) : undefined;
  }
  hslString() {
    return this._valid ? hslString(this._rgb) : undefined;
  }
  mix(color, weight) {
    if (color) {
      const c1 = this.rgb;
      const c2 = color.rgb;
      let w2;
      const p = weight === w2 ? 0.5 : weight;
      const w = 2 * p - 1;
      const a = c1.a - c2.a;
      const w1 = ((w * a === -1 ? w : (w + a) / (1 + w * a)) + 1) / 2.0;
      w2 = 1 - w1;
      c1.r = 0xFF & w1 * c1.r + w2 * c2.r + 0.5;
      c1.g = 0xFF & w1 * c1.g + w2 * c2.g + 0.5;
      c1.b = 0xFF & w1 * c1.b + w2 * c2.b + 0.5;
      c1.a = p * c1.a + (1 - p) * c2.a;
      this.rgb = c1;
    }
    return this;
  }
  interpolate(color, t) {
    if (color) {
      this._rgb = interpolate(this._rgb, color._rgb, t);
    }
    return this;
  }
  clone() {
    return new Color(this.rgb);
  }
  alpha(a) {
    this._rgb.a = n2b(a);
    return this;
  }
  clearer(ratio) {
    const rgb = this._rgb;
    rgb.a *= 1 - ratio;
    return this;
  }
  greyscale() {
    const rgb = this._rgb;
    const val = round(rgb.r * 0.3 + rgb.g * 0.59 + rgb.b * 0.11);
    rgb.r = rgb.g = rgb.b = val;
    return this;
  }
  opaquer(ratio) {
    const rgb = this._rgb;
    rgb.a *= 1 + ratio;
    return this;
  }
  negate() {
    const v = this._rgb;
    v.r = 255 - v.r;
    v.g = 255 - v.g;
    v.b = 255 - v.b;
    return this;
  }
  lighten(ratio) {
    modHSL(this._rgb, 2, ratio);
    return this;
  }
  darken(ratio) {
    modHSL(this._rgb, 2, -ratio);
    return this;
  }
  saturate(ratio) {
    modHSL(this._rgb, 1, ratio);
    return this;
  }
  desaturate(ratio) {
    modHSL(this._rgb, 1, -ratio);
    return this;
  }
  rotate(deg) {
    rotate(this._rgb, deg);
    return this;
  }
}

function index_esm(input) {
  return new Color(input);
}

var color = /*#__PURE__*/Object.freeze({
__proto__: null,
Color: Color,
default: index_esm,
round: round,
lim: lim,
p2b: p2b,
b2p: b2p,
n2b: n2b,
b2n: b2n,
n2p: n2p,
hexParse: hexParse,
hexString: hexString,
rgb2hsl: rgb2hsl,
hsl2rgb: hsl2rgb,
hwb2rgb: hwb2rgb,
hsv2rgb: hsv2rgb,
hueParse: hueParse,
rotate: rotate,
hslString: hslString,
nameParse: nameParse,
rgbParse: rgbParse,
rgbString: rgbString
});

var index = Object.assign(index_esm, color);

return index;

}));

      };
    };
  }
  }
}, {package:"chart.js>@kurkle/color",file:"node_modules\\@kurkle\\color\\dist\\color.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@lavamoat\\lavadome-react\\build\\main.js", {"react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@lavamoat%5Clavadome-react%5Cbuild%5Cmain.js
      return function (require, module, exports) {
(()=>{"use strict";var e={n:t=>{var o=t&&t.__esModule?()=>t.default:()=>t;return e.d(o,{a:o}),o},d:(t,o)=>{for(var n in o)e.o(o,n)&&!e.o(t,n)&&Object.defineProperty(t,n,{enumerable:!0,get:o[n]})},o:(e,t)=>Object.prototype.hasOwnProperty.call(e,t),r:e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})}},t={};e.r(t),e.d(t,{LavaDome:()=>me,toLavaDomeToken:()=>de});const o=require("react");var n=e.n(o);const{Object:a,Array:r,Function:s,Math:l,parseInt:i,WeakMap:u,Error:p,JSON:c,navigation:d}=globalThis,{defineProperties:m,assign:f,getOwnPropertyDescriptor:v,entries:g,create:h,hasOwn:y}=a,{from:b}=r,{random:w}=l,{stringify:T}=c,O=(e,t,o)=>e&&s.prototype.call.bind(v(e,t)[o]),S=O(globalThis?.Node?.prototype,"ownerDocument","get"),D=O(globalThis?.EventTarget?.prototype,"addEventListener","value"),M=O(globalThis?.DocumentFragment?.prototype,"replaceChildren","value"),E=O(globalThis?.Element?.prototype,"attachShadow","value"),x=O(globalThis?.Document?.prototype,"createElement","value"),_=O(globalThis?.Node?.prototype,"appendChild","value"),k=O(globalThis?.Node?.prototype,"textContent","set"),I=O(globalThis?.Element?.prototype,"setAttribute","value"),L=O(globalThis?.String?.prototype,"toUpperCase","value"),N=O(globalThis?.String?.prototype,"includes","value"),j=O(globalThis?.Array?.prototype,"map","value"),P=O(globalThis?.Array?.prototype,"join","value"),C=O(globalThis?.Array?.prototype,"keys","value"),A=O(globalThis?.Array?.prototype,"at","value"),$=O(globalThis?.WeakMap?.prototype,"get","value"),F=O(globalThis?.WeakMap?.prototype,"set","value"),z=O(globalThis?.Number?.prototype,"toFixed","value"),R=O(globalThis?.NavigateEvent?.prototype,"destination","get"),U=O(globalThis?.NavigationDestination?.prototype,"url","get"),W=O(globalThis?.Event?.prototype,"preventDefault","value"),q=O(globalThis?.Event?.prototype,"stopPropagation","value"),G={isInnerInstance:Symbol("isInnerInstance"),unsafeOpenModeShadow:"unsafeOpenModeShadow"},J=e=>function(t,o,n){const a=e[t];return y(e,t)?typeof a!==o?n:a:n},Y="abcdefghijklmnopqrstuvwxyz",B="0123456789",H="!@#$%^&*()?.;:\"'[]{}+=-_/",K={letters:Y,digits:B,symbols:H,alphanumeric:Y+B,all:Y+L(Y)+B+H},{letters:Q,alphanumeric:V,all:X}=K,Z=(e,t)=>e[i(z(w()*t))],ee=e=>Z(Q,26)+P(j(b(C(r(e))),(()=>Z(V,36))),"");function te(e,t,o=""){return e=P(j(g(e),(([e,t])=>`${e}: ${t} !important`)),"; "),function(){const n=x(document,t());return I(n,"style",e),k(n,o),n}}const oe=e=>()=>e(),ne=oe(te({"font-family":ee(20),"-webkit-user-modify":"unset","-webkit-user-select":"none","user-select":"none"},(()=>ee(7)))),ae=oe(te({top:"-10px",right:"-10px",position:"fixed","font-size":"1px"},(()=>"span"),X)),re=oe(te({display:"none"},(()=>"iframe"))),se=new u;function le(e,t){t=function(e={}){const{unsafeOpenModeShadow:t,isInnerInstance:o}=G,n=J(f(h(null),e)),a=h(null);return a.isInnerInstance=n(o,"boolean",!1),a.unsafeOpenModeShadow=n(t,"boolean",!1),a}(t),m(this,{text:{value:function(e){if("string"!=typeof e)throw new p(`LavaDomeCore: first argument must be a string, instead got ${T(e)}`);if(void 0===A(b(e),1))return k(a,e);_(o,n),j(b(e),(e=>{const o=x(document,"span");t[G.isInnerInstance]=!0,new le(o,t).text(e),_(a,o)})),_(a,ae())}}});const o=function(e,t){const{unsafeOpenModeShadow:o,isInnerInstance:n}=t;let a=$(se,e);if(!a){const t={mode:"closed"};o&&(t.mode="open",n||console.warn("LavaDome:",`Initiated with "${G.unsafeOpenModeShadow}" set to true.`,"This leaves LavaDome fully vulnerable, ONLY USE FOR TESTING!")),a=E(e,t),F(se,e,a)}return a}(e,t);M(o);const n=re();D(n,"load",(()=>{if(S(n)!==document)throw M(o),new p("LavaDomeCore: The document to which LavaDome was originally introduced must be the same as the one this instance is inserted to")}));const a=ne();_(o,a)}d?.addEventListener("navigate",(e=>{const t=U(R(e));if(N(t,":~:"))throw W(e),q(e),new p("LavaDomeCore: in-app redirection to text-fragments links is blocked to ensure security")}));const{all:ie}=K,ue=new u,pe=new u,ce=h(null),de=e=>{if("string"!=typeof e)throw new Error(`LavaDomeReact: first argument must be a string, instead got ${T(e)}`);if(!y(ce,e)){const t=h(null);ce[e]=t,F(ue,t,e)}return ce[e]},me=({text:e,unsafeOpenModeShadow:t})=>{const a=e,r=(0,o.useRef)(null);return n().createElement("span",{ref:r,__source:{fileName:"/Users/weizman/Documents/lavamoat/lavadome/packages/react/src/lavadome.jsx",lineNumber:57,columnNumber:9},__self:void 0},n().createElement(fe,{host:r,token:a,unsafeOpenModeShadow:t,__source:{fileName:"/Users/weizman/Documents/lavamoat/lavadome/packages/react/src/lavadome.jsx",lineNumber:58,columnNumber:13},__self:void 0}))};function fe({host:e,token:t,unsafeOpenModeShadow:a}){const r=function(e){const t=$(ue,e);if(!y(ce,t))throw new Error("LavaDomeReact: first argument must be a valid LavaDome token (replace \"text={'secret'}\" with \"text={toLavaDomeToken('secret')}\")");return t}(t),s=function(e){let t=$(pe,e);return t||(t=h(null),F(pe,e,t)),t}(t);return(0,o.useEffect)((()=>{new le(e.current,{unsafeOpenModeShadow:a}).text(r)}),[s]),n().createElement(n().Fragment,null)}var ve=exports;for(var ge in t)ve[ge]=t[ge];t.__esModule&&Object.defineProperty(ve,"__esModule",{value:!0})})();

      };
    };
  }
  }
}, {package:"@lavamoat/lavadome-react",file:"node_modules\\@lavamoat\\lavadome-react\\build\\main.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FilledInput\\FilledInput.js", {"../InputBase":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\InputBase\\index.js","../styles/withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withStyles.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js","clsx":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\node_modules\\clsx\\dist\\clsx.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CFilledInput%5CFilledInput.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _utils = require("@material-ui/utils");

var _InputBase = _interopRequireDefault(require("../InputBase"));

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var styles = function styles(theme) {
  var light = theme.palette.type === 'light';
  var bottomLineColor = light ? 'rgba(0, 0, 0, 0.42)' : 'rgba(255, 255, 255, 0.7)';
  var backgroundColor = light ? 'rgba(0, 0, 0, 0.09)' : 'rgba(255, 255, 255, 0.09)';
  return {
    /* Styles applied to the root element. */
    root: {
      position: 'relative',
      backgroundColor: backgroundColor,
      borderTopLeftRadius: theme.shape.borderRadius,
      borderTopRightRadius: theme.shape.borderRadius,
      transition: theme.transitions.create('background-color', {
        duration: theme.transitions.duration.shorter,
        easing: theme.transitions.easing.easeOut
      }),
      '&:hover': {
        backgroundColor: light ? 'rgba(0, 0, 0, 0.13)' : 'rgba(255, 255, 255, 0.13)',
        // Reset on touch devices, it doesn't add specificity
        '@media (hover: none)': {
          backgroundColor: backgroundColor
        }
      },
      '&$focused': {
        backgroundColor: light ? 'rgba(0, 0, 0, 0.09)' : 'rgba(255, 255, 255, 0.09)'
      },
      '&$disabled': {
        backgroundColor: light ? 'rgba(0, 0, 0, 0.12)' : 'rgba(255, 255, 255, 0.12)'
      }
    },

    /* Styles applied to the root element if color secondary. */
    colorSecondary: {
      '&$underline:after': {
        borderBottomColor: theme.palette.secondary.main
      }
    },

    /* Styles applied to the root element if `disableUnderline={false}`. */
    underline: {
      '&:after': {
        borderBottom: "2px solid ".concat(theme.palette.primary.main),
        left: 0,
        bottom: 0,
        // Doing the other way around crash on IE 11 "''" https://github.com/cssinjs/jss/issues/242
        content: '""',
        position: 'absolute',
        right: 0,
        transform: 'scaleX(0)',
        transition: theme.transitions.create('transform', {
          duration: theme.transitions.duration.shorter,
          easing: theme.transitions.easing.easeOut
        }),
        pointerEvents: 'none' // Transparent to the hover style.

      },
      '&$focused:after': {
        transform: 'scaleX(1)'
      },
      '&$error:after': {
        borderBottomColor: theme.palette.error.main,
        transform: 'scaleX(1)' // error is always underlined in red

      },
      '&:before': {
        borderBottom: "1px solid ".concat(bottomLineColor),
        left: 0,
        bottom: 0,
        // Doing the other way around crash on IE 11 "''" https://github.com/cssinjs/jss/issues/242
        content: '"\\00a0"',
        position: 'absolute',
        right: 0,
        transition: theme.transitions.create('border-bottom-color', {
          duration: theme.transitions.duration.shorter
        }),
        pointerEvents: 'none' // Transparent to the hover style.

      },
      '&:hover:before': {
        borderBottom: "1px solid ".concat(theme.palette.text.primary)
      },
      '&$disabled:before': {
        borderBottomStyle: 'dotted'
      }
    },

    /* Pseudo-class applied to the root element if the component is focused. */
    focused: {},

    /* Pseudo-class applied to the root element if `disabled={true}`. */
    disabled: {},

    /* Styles applied to the root element if `startAdornment` is provided. */
    adornedStart: {
      paddingLeft: 12
    },

    /* Styles applied to the root element if `endAdornment` is provided. */
    adornedEnd: {
      paddingRight: 12
    },

    /* Pseudo-class applied to the root element if `error={true}`. */
    error: {},

    /* Styles applied to the `input` element if `margin="dense"`. */
    marginDense: {},

    /* Styles applied to the root element if `multiline={true}`. */
    multiline: {
      padding: '27px 12px 10px',
      '&$marginDense': {
        paddingTop: 23,
        paddingBottom: 6
      }
    },

    /* Styles applied to the `input` element. */
    input: {
      padding: '27px 12px 10px',
      '&:-webkit-autofill': {
        WebkitBoxShadow: theme.palette.type === 'light' ? null : '0 0 0 100px #266798 inset',
        WebkitTextFillColor: theme.palette.type === 'light' ? null : '#fff',
        caretColor: theme.palette.type === 'light' ? null : '#fff',
        borderTopLeftRadius: 'inherit',
        borderTopRightRadius: 'inherit'
      }
    },

    /* Styles applied to the `input` element if `margin="dense"`. */
    inputMarginDense: {
      paddingTop: 23,
      paddingBottom: 6
    },

    /* Styles applied to the `input` if in `<FormControl hiddenLabel />`. */
    inputHiddenLabel: {
      paddingTop: 18,
      paddingBottom: 19,
      '&$inputMarginDense': {
        paddingTop: 10,
        paddingBottom: 11
      }
    },

    /* Styles applied to the `input` element if `multiline={true}`. */
    inputMultiline: {
      padding: 0
    },

    /* Styles applied to the `input` element if `startAdornment` is provided. */
    inputAdornedStart: {
      paddingLeft: 0
    },

    /* Styles applied to the `input` element if `endAdornment` is provided. */
    inputAdornedEnd: {
      paddingRight: 0
    }
  };
};

exports.styles = styles;
var FilledInput = /*#__PURE__*/React.forwardRef(function FilledInput(props, ref) {
  var disableUnderline = props.disableUnderline,
      classes = props.classes,
      _props$fullWidth = props.fullWidth,
      fullWidth = _props$fullWidth === void 0 ? false : _props$fullWidth,
      _props$inputComponent = props.inputComponent,
      inputComponent = _props$inputComponent === void 0 ? 'input' : _props$inputComponent,
      _props$multiline = props.multiline,
      multiline = _props$multiline === void 0 ? false : _props$multiline,
      _props$type = props.type,
      type = _props$type === void 0 ? 'text' : _props$type,
      other = (0, _objectWithoutProperties2.default)(props, ["disableUnderline", "classes", "fullWidth", "inputComponent", "multiline", "type"]);
  return /*#__PURE__*/React.createElement(_InputBase.default, (0, _extends2.default)({
    classes: (0, _extends2.default)({}, classes, {
      root: (0, _clsx.default)(classes.root, !disableUnderline && classes.underline),
      underline: null
    }),
    fullWidth: fullWidth,
    inputComponent: inputComponent,
    multiline: multiline,
    ref: ref,
    type: type
  }, other));
});
"development" !== "production" ? FilledInput.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * This prop helps users to fill forms faster, especially on mobile devices.
   * The name can be confusing, as it's more like an autofill.
   * You can learn more about it [following the specification](https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#autofill).
   */
  autoComplete: _propTypes.default.string,

  /**
   * If `true`, the `input` element will be focused during the first mount.
   */
  autoFocus: _propTypes.default.bool,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object,

  /**
   * The color of the component. It supports those theme colors that make sense for this component.
   */
  color: _propTypes.default.oneOf(['primary', 'secondary']),

  /**
   * The default `input` element value. Use when the component is not controlled.
   */
  defaultValue: _propTypes.default.any,

  /**
   * If `true`, the `input` element will be disabled.
   */
  disabled: _propTypes.default.bool,

  /**
   * If `true`, the input will not have an underline.
   */
  disableUnderline: _propTypes.default.bool,

  /**
   * End `InputAdornment` for this component.
   */
  endAdornment: _propTypes.default.node,

  /**
   * If `true`, the input will indicate an error. This is normally obtained via context from
   * FormControl.
   */
  error: _propTypes.default.bool,

  /**
   * If `true`, the input will take up the full width of its container.
   */
  fullWidth: _propTypes.default.bool,

  /**
   * The id of the `input` element.
   */
  id: _propTypes.default.string,

  /**
   * The component used for the `input` element.
   * Either a string to use a HTML element or a component.
   */
  inputComponent: _propTypes.default.elementType,

  /**
   * [Attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Attributes) applied to the `input` element.
   */
  inputProps: _propTypes.default.object,

  /**
   * Pass a ref to the `input` element.
   */
  inputRef: _utils.refType,

  /**
   * If `dense`, will adjust vertical spacing. This is normally obtained via context from
   * FormControl.
   */
  margin: _propTypes.default.oneOf(['dense', 'none']),

  /**
   * Maximum number of rows to display when multiline option is set to true.
   */
  maxRows: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * If `true`, a textarea element will be rendered.
   */
  multiline: _propTypes.default.bool,

  /**
   * Name attribute of the `input` element.
   */
  name: _propTypes.default.string,

  /**
   * Callback fired when the value is changed.
   *
   * @param {object} event The event source of the callback.
   * You can pull out the new value by accessing `event.target.value` (string).
   */
  onChange: _propTypes.default.func,

  /**
   * The short hint displayed in the input before the user enters a value.
   */
  placeholder: _propTypes.default.string,

  /**
   * It prevents the user from changing the value of the field
   * (not from interacting with the field).
   */
  readOnly: _propTypes.default.bool,

  /**
   * If `true`, the `input` element will be required.
   */
  required: _propTypes.default.bool,

  /**
   * Number of rows to display when multiline option is set to true.
   */
  rows: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * Start `InputAdornment` for this component.
   */
  startAdornment: _propTypes.default.node,

  /**
   * Type of the `input` element. It should be [a valid HTML5 input type](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Form_%3Cinput%3E_types).
   */
  type: _propTypes.default.string,

  /**
   * The value of the `input` element, required for a controlled component.
   */
  value: _propTypes.default.any
} : void 0;
FilledInput.muiName = 'Input';

var _default = (0, _withStyles.default)(styles, {
  name: 'MuiFilledInput'
})(FilledInput);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\FilledInput\\FilledInput.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FilledInput\\index.js", {"./FilledInput":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FilledInput\\FilledInput.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CFilledInput%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _FilledInput.default;
  }
});

var _FilledInput = _interopRequireDefault(require("./FilledInput"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\FilledInput\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\FormControl.js", {"../InputBase/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\InputBase\\utils.js","../styles/withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withStyles.js","../utils/capitalize":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\capitalize.js","../utils/isMuiElement":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\isMuiElement.js","./FormControlContext":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\FormControlContext.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","clsx":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\node_modules\\clsx\\dist\\clsx.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CFormControl%5CFormControl.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _utils = require("../InputBase/utils");

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var _capitalize = _interopRequireDefault(require("../utils/capitalize"));

var _isMuiElement = _interopRequireDefault(require("../utils/isMuiElement"));

var _FormControlContext = _interopRequireDefault(require("./FormControlContext"));

var styles = {
  /* Styles applied to the root element. */
  root: {
    display: 'inline-flex',
    flexDirection: 'column',
    position: 'relative',
    // Reset fieldset default style.
    minWidth: 0,
    padding: 0,
    margin: 0,
    border: 0,
    verticalAlign: 'top' // Fix alignment issue on Safari.

  },

  /* Styles applied to the root element if `margin="normal"`. */
  marginNormal: {
    marginTop: 16,
    marginBottom: 8
  },

  /* Styles applied to the root element if `margin="dense"`. */
  marginDense: {
    marginTop: 8,
    marginBottom: 4
  },

  /* Styles applied to the root element if `fullWidth={true}`. */
  fullWidth: {
    width: '100%'
  }
};
/**
 * Provides context such as filled/focused/error/required for form inputs.
 * Relying on the context provides high flexibility and ensures that the state always stays
 * consistent across the children of the `FormControl`.
 * This context is used by the following components:
 *
 *  - FormLabel
 *  - FormHelperText
 *  - Input
 *  - InputLabel
 *
 * You can find one composition example below and more going to [the demos](/components/text-fields/#components).
 *
 * ```jsx
 * <FormControl>
 *   <InputLabel htmlFor="my-input">Email address</InputLabel>
 *   <Input id="my-input" aria-describedby="my-helper-text" />
 *   <FormHelperText id="my-helper-text">We'll never share your email.</FormHelperText>
 * </FormControl>
 * ```
 *
 * ⚠️Only one input can be used within a FormControl.
 */

exports.styles = styles;
var FormControl = /*#__PURE__*/React.forwardRef(function FormControl(props, ref) {
  var children = props.children,
      classes = props.classes,
      className = props.className,
      _props$color = props.color,
      color = _props$color === void 0 ? 'primary' : _props$color,
      _props$component = props.component,
      Component = _props$component === void 0 ? 'div' : _props$component,
      _props$disabled = props.disabled,
      disabled = _props$disabled === void 0 ? false : _props$disabled,
      _props$error = props.error,
      error = _props$error === void 0 ? false : _props$error,
      _props$fullWidth = props.fullWidth,
      fullWidth = _props$fullWidth === void 0 ? false : _props$fullWidth,
      visuallyFocused = props.focused,
      _props$hiddenLabel = props.hiddenLabel,
      hiddenLabel = _props$hiddenLabel === void 0 ? false : _props$hiddenLabel,
      _props$margin = props.margin,
      margin = _props$margin === void 0 ? 'none' : _props$margin,
      _props$required = props.required,
      required = _props$required === void 0 ? false : _props$required,
      size = props.size,
      _props$variant = props.variant,
      variant = _props$variant === void 0 ? 'standard' : _props$variant,
      other = (0, _objectWithoutProperties2.default)(props, ["children", "classes", "className", "color", "component", "disabled", "error", "fullWidth", "focused", "hiddenLabel", "margin", "required", "size", "variant"]);

  var _React$useState = React.useState(function () {
    // We need to iterate through the children and find the Input in order
    // to fully support server-side rendering.
    var initialAdornedStart = false;

    if (children) {
      React.Children.forEach(children, function (child) {
        if (!(0, _isMuiElement.default)(child, ['Input', 'Select'])) {
          return;
        }

        var input = (0, _isMuiElement.default)(child, ['Select']) ? child.props.input : child;

        if (input && (0, _utils.isAdornedStart)(input.props)) {
          initialAdornedStart = true;
        }
      });
    }

    return initialAdornedStart;
  }),
      adornedStart = _React$useState[0],
      setAdornedStart = _React$useState[1];

  var _React$useState2 = React.useState(function () {
    // We need to iterate through the children and find the Input in order
    // to fully support server-side rendering.
    var initialFilled = false;

    if (children) {
      React.Children.forEach(children, function (child) {
        if (!(0, _isMuiElement.default)(child, ['Input', 'Select'])) {
          return;
        }

        if ((0, _utils.isFilled)(child.props, true)) {
          initialFilled = true;
        }
      });
    }

    return initialFilled;
  }),
      filled = _React$useState2[0],
      setFilled = _React$useState2[1];

  var _React$useState3 = React.useState(false),
      _focused = _React$useState3[0],
      setFocused = _React$useState3[1];

  var focused = visuallyFocused !== undefined ? visuallyFocused : _focused;

  if (disabled && focused) {
    setFocused(false);
  }

  var registerEffect;

  if ("development" !== 'production') {
    // eslint-disable-next-line react-hooks/rules-of-hooks
    var registeredInput = React.useRef(false);

    registerEffect = function registerEffect() {
      if (registeredInput.current) {
        console.error(['Material-UI: There are multiple InputBase components inside a FormControl.', 'This is not supported. It might cause infinite rendering loops.', 'Only use one InputBase.'].join('\n'));
      }

      registeredInput.current = true;
      return function () {
        registeredInput.current = false;
      };
    };
  }

  var onFilled = React.useCallback(function () {
    setFilled(true);
  }, []);
  var onEmpty = React.useCallback(function () {
    setFilled(false);
  }, []);
  var childContext = {
    adornedStart: adornedStart,
    setAdornedStart: setAdornedStart,
    color: color,
    disabled: disabled,
    error: error,
    filled: filled,
    focused: focused,
    fullWidth: fullWidth,
    hiddenLabel: hiddenLabel,
    margin: (size === 'small' ? 'dense' : undefined) || margin,
    onBlur: function onBlur() {
      setFocused(false);
    },
    onEmpty: onEmpty,
    onFilled: onFilled,
    onFocus: function onFocus() {
      setFocused(true);
    },
    registerEffect: registerEffect,
    required: required,
    variant: variant
  };
  return /*#__PURE__*/React.createElement(_FormControlContext.default.Provider, {
    value: childContext
  }, /*#__PURE__*/React.createElement(Component, (0, _extends2.default)({
    className: (0, _clsx.default)(classes.root, className, margin !== 'none' && classes["margin".concat((0, _capitalize.default)(margin))], fullWidth && classes.fullWidth),
    ref: ref
  }, other), children));
});
"development" !== "production" ? FormControl.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * The contents of the form control.
   */
  children: _propTypes.default.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object,

  /**
   * @ignore
   */
  className: _propTypes.default.string,

  /**
   * The color of the component. It supports those theme colors that make sense for this component.
   */
  color: _propTypes.default.oneOf(['primary', 'secondary']),

  /**
   * The component used for the root node.
   * Either a string to use a HTML element or a component.
   */
  component: _propTypes.default
  /* @typescript-to-proptypes-ignore */
  .elementType,

  /**
   * If `true`, the label, input and helper text should be displayed in a disabled state.
   */
  disabled: _propTypes.default.bool,

  /**
   * If `true`, the label should be displayed in an error state.
   */
  error: _propTypes.default.bool,

  /**
   * If `true`, the component will be displayed in focused state.
   */
  focused: _propTypes.default.bool,

  /**
   * If `true`, the component will take up the full width of its container.
   */
  fullWidth: _propTypes.default.bool,

  /**
   * If `true`, the label will be hidden.
   * This is used to increase density for a `FilledInput`.
   * Be sure to add `aria-label` to the `input` element.
   */
  hiddenLabel: _propTypes.default.bool,

  /**
   * If `dense` or `normal`, will adjust vertical spacing of this and contained components.
   */
  margin: _propTypes.default.oneOf(['dense', 'none', 'normal']),

  /**
   * If `true`, the label will indicate that the input is required.
   */
  required: _propTypes.default.bool,

  /**
   * The size of the text field.
   */
  size: _propTypes.default.oneOf(['medium', 'small']),

  /**
   * The variant to use.
   */
  variant: _propTypes.default.oneOf(['filled', 'outlined', 'standard'])
} : void 0;

var _default = (0, _withStyles.default)(styles, {
  name: 'MuiFormControl'
})(FormControl);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\FormControl\\FormControl.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\FormControlContext.js", {"@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CFormControl%5CFormControlContext.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFormControl = useFormControl;
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

/**
 * @ignore - internal component.
 */
var FormControlContext = React.createContext();

if ("development" !== 'production') {
  FormControlContext.displayName = 'FormControlContext';
}

function useFormControl() {
  return React.useContext(FormControlContext);
}

var _default = FormControlContext;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\FormControl\\FormControlContext.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\formControlState.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CFormControl%5CformControlState.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = formControlState;

function formControlState(_ref) {
  var props = _ref.props,
      states = _ref.states,
      muiFormControl = _ref.muiFormControl;
  return states.reduce(function (acc, state) {
    acc[state] = props[state];

    if (muiFormControl) {
      if (typeof props[state] === 'undefined') {
        acc[state] = muiFormControl[state];
      }
    }

    return acc;
  }, {});
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\FormControl\\formControlState.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\index.js", {"./FormControl":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\FormControl.js","./useFormControl":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\useFormControl.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CFormControl%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _FormControl.default;
  }
});
Object.defineProperty(exports, "useFormControl", {
  enumerable: true,
  get: function get() {
    return _useFormControl.default;
  }
});

var _FormControl = _interopRequireDefault(require("./FormControl"));

var _useFormControl = _interopRequireDefault(require("./useFormControl"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\FormControl\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\useFormControl.js", {"./FormControlContext":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\FormControlContext.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CFormControl%5CuseFormControl.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useFormControl;

var React = _interopRequireWildcard(require("react"));

var _FormControlContext = _interopRequireDefault(require("./FormControlContext"));

function useFormControl() {
  return React.useContext(_FormControlContext.default);
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\FormControl\\useFormControl.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormHelperText\\FormHelperText.js", {"../FormControl/formControlState":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\formControlState.js","../FormControl/useFormControl":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\useFormControl.js","../styles/withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withStyles.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","clsx":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\node_modules\\clsx\\dist\\clsx.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CFormHelperText%5CFormHelperText.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _formControlState = _interopRequireDefault(require("../FormControl/formControlState"));

var _useFormControl = _interopRequireDefault(require("../FormControl/useFormControl"));

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var styles = function styles(theme) {
  return {
    /* Styles applied to the root element. */
    root: (0, _extends2.default)({
      color: theme.palette.text.secondary
    }, theme.typography.caption, {
      textAlign: 'left',
      marginTop: 3,
      margin: 0,
      '&$disabled': {
        color: theme.palette.text.disabled
      },
      '&$error': {
        color: theme.palette.error.main
      }
    }),

    /* Pseudo-class applied to the root element if `error={true}`. */
    error: {},

    /* Pseudo-class applied to the root element if `disabled={true}`. */
    disabled: {},

    /* Styles applied to the root element if `margin="dense"`. */
    marginDense: {
      marginTop: 4
    },

    /* Styles applied to the root element if `variant="filled"` or `variant="outlined"`. */
    contained: {
      marginLeft: 14,
      marginRight: 14
    },

    /* Pseudo-class applied to the root element if `focused={true}`. */
    focused: {},

    /* Pseudo-class applied to the root element if `filled={true}`. */
    filled: {},

    /* Pseudo-class applied to the root element if `required={true}`. */
    required: {}
  };
};

exports.styles = styles;
var FormHelperText = /*#__PURE__*/React.forwardRef(function FormHelperText(props, ref) {
  var children = props.children,
      classes = props.classes,
      className = props.className,
      _props$component = props.component,
      Component = _props$component === void 0 ? 'p' : _props$component,
      disabled = props.disabled,
      error = props.error,
      filled = props.filled,
      focused = props.focused,
      margin = props.margin,
      required = props.required,
      variant = props.variant,
      other = (0, _objectWithoutProperties2.default)(props, ["children", "classes", "className", "component", "disabled", "error", "filled", "focused", "margin", "required", "variant"]);
  var muiFormControl = (0, _useFormControl.default)();
  var fcs = (0, _formControlState.default)({
    props: props,
    muiFormControl: muiFormControl,
    states: ['variant', 'margin', 'disabled', 'error', 'filled', 'focused', 'required']
  });
  return /*#__PURE__*/React.createElement(Component, (0, _extends2.default)({
    className: (0, _clsx.default)(classes.root, (fcs.variant === 'filled' || fcs.variant === 'outlined') && classes.contained, className, fcs.disabled && classes.disabled, fcs.error && classes.error, fcs.filled && classes.filled, fcs.focused && classes.focused, fcs.required && classes.required, fcs.margin === 'dense' && classes.marginDense),
    ref: ref
  }, other), children === ' ' ?
  /*#__PURE__*/
  // eslint-disable-next-line react/no-danger
  React.createElement("span", {
    dangerouslySetInnerHTML: {
      __html: '&#8203;'
    }
  }) : children);
});
"development" !== "production" ? FormHelperText.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * The content of the component.
   *
   * If `' '` is provided, the component reserves one line height for displaying a future message.
   */
  children: _propTypes.default.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object,

  /**
   * @ignore
   */
  className: _propTypes.default.string,

  /**
   * The component used for the root node.
   * Either a string to use a HTML element or a component.
   */
  component: _propTypes.default
  /* @typescript-to-proptypes-ignore */
  .elementType,

  /**
   * If `true`, the helper text should be displayed in a disabled state.
   */
  disabled: _propTypes.default.bool,

  /**
   * If `true`, helper text should be displayed in an error state.
   */
  error: _propTypes.default.bool,

  /**
   * If `true`, the helper text should use filled classes key.
   */
  filled: _propTypes.default.bool,

  /**
   * If `true`, the helper text should use focused classes key.
   */
  focused: _propTypes.default.bool,

  /**
   * If `dense`, will adjust vertical spacing. This is normally obtained via context from
   * FormControl.
   */
  margin: _propTypes.default.oneOf(['dense']),

  /**
   * If `true`, the helper text should use required classes key.
   */
  required: _propTypes.default.bool,

  /**
   * The variant to use.
   */
  variant: _propTypes.default.oneOf(['filled', 'outlined', 'standard'])
} : void 0;

var _default = (0, _withStyles.default)(styles, {
  name: 'MuiFormHelperText'
})(FormHelperText);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\FormHelperText\\FormHelperText.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormHelperText\\index.js", {"./FormHelperText":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormHelperText\\FormHelperText.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CFormHelperText%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _FormHelperText.default;
  }
});

var _FormHelperText = _interopRequireDefault(require("./FormHelperText"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\FormHelperText\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormLabel\\FormLabel.js", {"../FormControl/formControlState":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\formControlState.js","../FormControl/useFormControl":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\useFormControl.js","../styles/withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withStyles.js","../utils/capitalize":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\capitalize.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","clsx":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\node_modules\\clsx\\dist\\clsx.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CFormLabel%5CFormLabel.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _formControlState = _interopRequireDefault(require("../FormControl/formControlState"));

var _useFormControl = _interopRequireDefault(require("../FormControl/useFormControl"));

var _capitalize = _interopRequireDefault(require("../utils/capitalize"));

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var styles = function styles(theme) {
  return {
    /* Styles applied to the root element. */
    root: (0, _extends2.default)({
      color: theme.palette.text.secondary
    }, theme.typography.body1, {
      lineHeight: 1,
      padding: 0,
      '&$focused': {
        color: theme.palette.primary.main
      },
      '&$disabled': {
        color: theme.palette.text.disabled
      },
      '&$error': {
        color: theme.palette.error.main
      }
    }),

    /* Styles applied to the root element if the color is secondary. */
    colorSecondary: {
      '&$focused': {
        color: theme.palette.secondary.main
      }
    },

    /* Pseudo-class applied to the root element if `focused={true}`. */
    focused: {},

    /* Pseudo-class applied to the root element if `disabled={true}`. */
    disabled: {},

    /* Pseudo-class applied to the root element if `error={true}`. */
    error: {},

    /* Pseudo-class applied to the root element if `filled={true}`. */
    filled: {},

    /* Pseudo-class applied to the root element if `required={true}`. */
    required: {},

    /* Styles applied to the asterisk element. */
    asterisk: {
      '&$error': {
        color: theme.palette.error.main
      }
    }
  };
};

exports.styles = styles;
var FormLabel = /*#__PURE__*/React.forwardRef(function FormLabel(props, ref) {
  var children = props.children,
      classes = props.classes,
      className = props.className,
      color = props.color,
      _props$component = props.component,
      Component = _props$component === void 0 ? 'label' : _props$component,
      disabled = props.disabled,
      error = props.error,
      filled = props.filled,
      focused = props.focused,
      required = props.required,
      other = (0, _objectWithoutProperties2.default)(props, ["children", "classes", "className", "color", "component", "disabled", "error", "filled", "focused", "required"]);
  var muiFormControl = (0, _useFormControl.default)();
  var fcs = (0, _formControlState.default)({
    props: props,
    muiFormControl: muiFormControl,
    states: ['color', 'required', 'focused', 'disabled', 'error', 'filled']
  });
  return /*#__PURE__*/React.createElement(Component, (0, _extends2.default)({
    className: (0, _clsx.default)(classes.root, classes["color".concat((0, _capitalize.default)(fcs.color || 'primary'))], className, fcs.disabled && classes.disabled, fcs.error && classes.error, fcs.filled && classes.filled, fcs.focused && classes.focused, fcs.required && classes.required),
    ref: ref
  }, other), children, fcs.required && /*#__PURE__*/React.createElement("span", {
    "aria-hidden": true,
    className: (0, _clsx.default)(classes.asterisk, fcs.error && classes.error)
  }, "\u2009", '*'));
});
"development" !== "production" ? FormLabel.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * The content of the component.
   */
  children: _propTypes.default.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object,

  /**
   * @ignore
   */
  className: _propTypes.default.string,

  /**
   * The color of the component. It supports those theme colors that make sense for this component.
   */
  color: _propTypes.default.oneOf(['primary', 'secondary']),

  /**
   * The component used for the root node.
   * Either a string to use a HTML element or a component.
   */
  component: _propTypes.default
  /* @typescript-to-proptypes-ignore */
  .elementType,

  /**
   * If `true`, the label should be displayed in a disabled state.
   */
  disabled: _propTypes.default.bool,

  /**
   * If `true`, the label should be displayed in an error state.
   */
  error: _propTypes.default.bool,

  /**
   * If `true`, the label should use filled classes key.
   */
  filled: _propTypes.default.bool,

  /**
   * If `true`, the input of this label is focused (used by `FormGroup` components).
   */
  focused: _propTypes.default.bool,

  /**
   * If `true`, the label will indicate that the input is required.
   */
  required: _propTypes.default.bool
} : void 0;

var _default = (0, _withStyles.default)(styles, {
  name: 'MuiFormLabel'
})(FormLabel);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\FormLabel\\FormLabel.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormLabel\\index.js", {"./FormLabel":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormLabel\\FormLabel.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CFormLabel%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _FormLabel.default;
  }
});

var _FormLabel = _interopRequireDefault(require("./FormLabel"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\FormLabel\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Grow\\Grow.js", {"../styles/useTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\useTheme.js","../transitions/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\transitions\\utils.js","../utils/useForkRef":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\useForkRef.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@babel/runtime/helpers/slicedToArray":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\slicedToArray.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-transition-group":"D:\\code\\v\\metamask-extension\\node_modules\\react-transition-group\\cjs\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CGrow%5CGrow.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactTransitionGroup = require("react-transition-group");

var _useTheme = _interopRequireDefault(require("../styles/useTheme"));

var _utils = require("../transitions/utils");

var _useForkRef = _interopRequireDefault(require("../utils/useForkRef"));

function getScale(value) {
  return "scale(".concat(value, ", ").concat(Math.pow(value, 2), ")");
}

var styles = {
  entering: {
    opacity: 1,
    transform: getScale(1)
  },
  entered: {
    opacity: 1,
    transform: 'none'
  }
};
/**
 * The Grow transition is used by the [Tooltip](/components/tooltips/) and
 * [Popover](/components/popover/) components.
 * It uses [react-transition-group](https://github.com/reactjs/react-transition-group) internally.
 */

var Grow = /*#__PURE__*/React.forwardRef(function Grow(props, ref) {
  var children = props.children,
      _props$disableStrictM = props.disableStrictModeCompat,
      disableStrictModeCompat = _props$disableStrictM === void 0 ? false : _props$disableStrictM,
      inProp = props.in,
      onEnter = props.onEnter,
      onEntered = props.onEntered,
      onEntering = props.onEntering,
      onExit = props.onExit,
      onExited = props.onExited,
      onExiting = props.onExiting,
      style = props.style,
      _props$timeout = props.timeout,
      timeout = _props$timeout === void 0 ? 'auto' : _props$timeout,
      _props$TransitionComp = props.TransitionComponent,
      TransitionComponent = _props$TransitionComp === void 0 ? _reactTransitionGroup.Transition : _props$TransitionComp,
      other = (0, _objectWithoutProperties2.default)(props, ["children", "disableStrictModeCompat", "in", "onEnter", "onEntered", "onEntering", "onExit", "onExited", "onExiting", "style", "timeout", "TransitionComponent"]);
  var timer = React.useRef();
  var autoTimeout = React.useRef();
  var theme = (0, _useTheme.default)();
  var enableStrictModeCompat = theme.unstable_strictMode && !disableStrictModeCompat;
  var nodeRef = React.useRef(null);
  var foreignRef = (0, _useForkRef.default)(children.ref, ref);
  var handleRef = (0, _useForkRef.default)(enableStrictModeCompat ? nodeRef : undefined, foreignRef);

  var normalizedTransitionCallback = function normalizedTransitionCallback(callback) {
    return function (nodeOrAppearing, maybeAppearing) {
      if (callback) {
        var _ref = enableStrictModeCompat ? [nodeRef.current, nodeOrAppearing] : [nodeOrAppearing, maybeAppearing],
            _ref2 = (0, _slicedToArray2.default)(_ref, 2),
            node = _ref2[0],
            isAppearing = _ref2[1]; // onEnterXxx and onExitXxx callbacks have a different arguments.length value.


        if (isAppearing === undefined) {
          callback(node);
        } else {
          callback(node, isAppearing);
        }
      }
    };
  };

  var handleEntering = normalizedTransitionCallback(onEntering);
  var handleEnter = normalizedTransitionCallback(function (node, isAppearing) {
    (0, _utils.reflow)(node); // So the animation always start from the start.

    var _getTransitionProps = (0, _utils.getTransitionProps)({
      style: style,
      timeout: timeout
    }, {
      mode: 'enter'
    }),
        transitionDuration = _getTransitionProps.duration,
        delay = _getTransitionProps.delay;

    var duration;

    if (timeout === 'auto') {
      duration = theme.transitions.getAutoHeightDuration(node.clientHeight);
      autoTimeout.current = duration;
    } else {
      duration = transitionDuration;
    }

    node.style.transition = [theme.transitions.create('opacity', {
      duration: duration,
      delay: delay
    }), theme.transitions.create('transform', {
      duration: duration * 0.666,
      delay: delay
    })].join(',');

    if (onEnter) {
      onEnter(node, isAppearing);
    }
  });
  var handleEntered = normalizedTransitionCallback(onEntered);
  var handleExiting = normalizedTransitionCallback(onExiting);
  var handleExit = normalizedTransitionCallback(function (node) {
    var _getTransitionProps2 = (0, _utils.getTransitionProps)({
      style: style,
      timeout: timeout
    }, {
      mode: 'exit'
    }),
        transitionDuration = _getTransitionProps2.duration,
        delay = _getTransitionProps2.delay;

    var duration;

    if (timeout === 'auto') {
      duration = theme.transitions.getAutoHeightDuration(node.clientHeight);
      autoTimeout.current = duration;
    } else {
      duration = transitionDuration;
    }

    node.style.transition = [theme.transitions.create('opacity', {
      duration: duration,
      delay: delay
    }), theme.transitions.create('transform', {
      duration: duration * 0.666,
      delay: delay || duration * 0.333
    })].join(',');
    node.style.opacity = '0';
    node.style.transform = getScale(0.75);

    if (onExit) {
      onExit(node);
    }
  });
  var handleExited = normalizedTransitionCallback(onExited);

  var addEndListener = function addEndListener(nodeOrNext, maybeNext) {
    var next = enableStrictModeCompat ? nodeOrNext : maybeNext;

    if (timeout === 'auto') {
      timer.current = setTimeout(next, autoTimeout.current || 0);
    }
  };

  React.useEffect(function () {
    return function () {
      clearTimeout(timer.current);
    };
  }, []);
  return /*#__PURE__*/React.createElement(TransitionComponent, (0, _extends2.default)({
    appear: true,
    in: inProp,
    nodeRef: enableStrictModeCompat ? nodeRef : undefined,
    onEnter: handleEnter,
    onEntered: handleEntered,
    onEntering: handleEntering,
    onExit: handleExit,
    onExited: handleExited,
    onExiting: handleExiting,
    addEndListener: addEndListener,
    timeout: timeout === 'auto' ? null : timeout
  }, other), function (state, childProps) {
    return /*#__PURE__*/React.cloneElement(children, (0, _extends2.default)({
      style: (0, _extends2.default)({
        opacity: 0,
        transform: getScale(0.75),
        visibility: state === 'exited' && !inProp ? 'hidden' : undefined
      }, styles[state], style, children.props.style),
      ref: handleRef
    }, childProps));
  });
});
"development" !== "production" ? Grow.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * A single child content element.
   */
  children: _propTypes.default.element,

  /**
   * Enable this prop if you encounter 'Function components cannot be given refs',
   * use `unstable_createStrictModeTheme`,
   * and can't forward the ref in the child component.
   */
  disableStrictModeCompat: _propTypes.default.bool,

  /**
   * If `true`, show the component; triggers the enter or exit animation.
   */
  in: _propTypes.default.bool,

  /**
   * @ignore
   */
  onEnter: _propTypes.default.func,

  /**
   * @ignore
   */
  onEntered: _propTypes.default.func,

  /**
   * @ignore
   */
  onEntering: _propTypes.default.func,

  /**
   * @ignore
   */
  onExit: _propTypes.default.func,

  /**
   * @ignore
   */
  onExited: _propTypes.default.func,

  /**
   * @ignore
   */
  onExiting: _propTypes.default.func,

  /**
   * @ignore
   */
  style: _propTypes.default.object,

  /**
   * The duration for the transition, in milliseconds.
   * You may specify a single timeout for all transitions, or individually with an object.
   *
   * Set to 'auto' to automatically calculate transition time based on height.
   */
  timeout: _propTypes.default.oneOfType([_propTypes.default.oneOf(['auto']), _propTypes.default.number, _propTypes.default.shape({
    appear: _propTypes.default.number,
    enter: _propTypes.default.number,
    exit: _propTypes.default.number
  })])
} : void 0;
Grow.muiSupportAuto = true;
var _default = Grow;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Grow\\Grow.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Grow\\index.js", {"./Grow":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Grow\\Grow.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CGrow%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _Grow.default;
  }
});

var _Grow = _interopRequireDefault(require("./Grow"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Grow\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\InputAdornment\\InputAdornment.js", {"../FormControl/FormControlContext":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\FormControlContext.js","../Typography":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Typography\\index.js","../styles/withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withStyles.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","clsx":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\node_modules\\clsx\\dist\\clsx.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CInputAdornment%5CInputAdornment.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _Typography = _interopRequireDefault(require("../Typography"));

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var _FormControlContext = _interopRequireWildcard(require("../FormControl/FormControlContext"));

var styles = {
  /* Styles applied to the root element. */
  root: {
    display: 'flex',
    height: '0.01em',
    // Fix IE 11 flexbox alignment. To remove at some point.
    maxHeight: '2em',
    alignItems: 'center',
    whiteSpace: 'nowrap'
  },

  /* Styles applied to the root element if `variant="filled"`. */
  filled: {
    '&$positionStart:not($hiddenLabel)': {
      marginTop: 16
    }
  },

  /* Styles applied to the root element if `position="start"`. */
  positionStart: {
    marginRight: 8
  },

  /* Styles applied to the root element if `position="end"`. */
  positionEnd: {
    marginLeft: 8
  },

  /* Styles applied to the root element if `disablePointerEvents=true`. */
  disablePointerEvents: {
    pointerEvents: 'none'
  },

  /* Styles applied if the adornment is used inside <FormControl hiddenLabel />. */
  hiddenLabel: {},

  /* Styles applied if the adornment is used inside <FormControl margin="dense" />. */
  marginDense: {}
};
exports.styles = styles;
var InputAdornment = /*#__PURE__*/React.forwardRef(function InputAdornment(props, ref) {
  var children = props.children,
      classes = props.classes,
      className = props.className,
      _props$component = props.component,
      Component = _props$component === void 0 ? 'div' : _props$component,
      _props$disablePointer = props.disablePointerEvents,
      disablePointerEvents = _props$disablePointer === void 0 ? false : _props$disablePointer,
      _props$disableTypogra = props.disableTypography,
      disableTypography = _props$disableTypogra === void 0 ? false : _props$disableTypogra,
      position = props.position,
      variantProp = props.variant,
      other = (0, _objectWithoutProperties2.default)(props, ["children", "classes", "className", "component", "disablePointerEvents", "disableTypography", "position", "variant"]);
  var muiFormControl = (0, _FormControlContext.useFormControl)() || {};
  var variant = variantProp;

  if (variantProp && muiFormControl.variant) {
    if ("development" !== 'production') {
      if (variantProp === muiFormControl.variant) {
        console.error('Material-UI: The `InputAdornment` variant infers the variant prop ' + 'you do not have to provide one.');
      }
    }
  }

  if (muiFormControl && !variant) {
    variant = muiFormControl.variant;
  }

  return /*#__PURE__*/React.createElement(_FormControlContext.default.Provider, {
    value: null
  }, /*#__PURE__*/React.createElement(Component, (0, _extends2.default)({
    className: (0, _clsx.default)(classes.root, className, position === 'end' ? classes.positionEnd : classes.positionStart, disablePointerEvents && classes.disablePointerEvents, muiFormControl.hiddenLabel && classes.hiddenLabel, variant === 'filled' && classes.filled, muiFormControl.margin === 'dense' && classes.marginDense),
    ref: ref
  }, other), typeof children === 'string' && !disableTypography ? /*#__PURE__*/React.createElement(_Typography.default, {
    color: "textSecondary"
  }, children) : children));
});
"development" !== "production" ? InputAdornment.propTypes = {
  /**
   * The content of the component, normally an `IconButton` or string.
   */
  children: _propTypes.default.node.isRequired,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object.isRequired,

  /**
   * @ignore
   */
  className: _propTypes.default.string,

  /**
   * The component used for the root node.
   * Either a string to use a HTML element or a component.
   */
  component: _propTypes.default
  /* @typescript-to-proptypes-ignore */
  .elementType,

  /**
   * Disable pointer events on the root.
   * This allows for the content of the adornment to focus the input on click.
   */
  disablePointerEvents: _propTypes.default.bool,

  /**
   * If children is a string then disable wrapping in a Typography component.
   */
  disableTypography: _propTypes.default.bool,

  /**
   * @ignore
   */
  muiFormControl: _propTypes.default.object,

  /**
   * The position this adornment should appear relative to the `Input`.
   */
  position: _propTypes.default.oneOf(['start', 'end']).isRequired,

  /**
   * The variant to use.
   * Note: If you are using the `TextField` component or the `FormControl` component
   * you do not have to set this manually.
   */
  variant: _propTypes.default.oneOf(['standard', 'outlined', 'filled'])
} : void 0;

var _default = (0, _withStyles.default)(styles, {
  name: 'MuiInputAdornment'
})(InputAdornment);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\InputAdornment\\InputAdornment.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\InputAdornment\\index.js", {"./InputAdornment":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\InputAdornment\\InputAdornment.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CInputAdornment%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _InputAdornment.default;
  }
});

var _InputAdornment = _interopRequireDefault(require("./InputAdornment"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\InputAdornment\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\InputBase\\InputBase.js", {"../FormControl/FormControlContext":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\FormControlContext.js","../FormControl/formControlState":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\formControlState.js","../TextareaAutosize":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\TextareaAutosize\\index.js","../styles/withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withStyles.js","../utils/capitalize":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\capitalize.js","../utils/useForkRef":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\useForkRef.js","./utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\InputBase\\utils.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js","clsx":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\node_modules\\clsx\\dist\\clsx.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CInputBase%5CInputBase.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _utils = require("@material-ui/utils");

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _formControlState = _interopRequireDefault(require("../FormControl/formControlState"));

var _FormControlContext = _interopRequireWildcard(require("../FormControl/FormControlContext"));

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var _capitalize = _interopRequireDefault(require("../utils/capitalize"));

var _useForkRef = _interopRequireDefault(require("../utils/useForkRef"));

var _TextareaAutosize = _interopRequireDefault(require("../TextareaAutosize"));

var _utils2 = require("./utils");

/* eslint-disable jsx-a11y/click-events-have-key-events, jsx-a11y/no-static-element-interactions */
var styles = function styles(theme) {
  var light = theme.palette.type === 'light';
  var placeholder = {
    color: 'currentColor',
    opacity: light ? 0.42 : 0.5,
    transition: theme.transitions.create('opacity', {
      duration: theme.transitions.duration.shorter
    })
  };
  var placeholderHidden = {
    opacity: '0 !important'
  };
  var placeholderVisible = {
    opacity: light ? 0.42 : 0.5
  };
  return {
    '@global': {
      '@keyframes mui-auto-fill': {},
      '@keyframes mui-auto-fill-cancel': {}
    },

    /* Styles applied to the root element. */
    root: (0, _extends2.default)({}, theme.typography.body1, {
      color: theme.palette.text.primary,
      lineHeight: '1.1876em',
      // Reset (19px), match the native input line-height
      boxSizing: 'border-box',
      // Prevent padding issue with fullWidth.
      position: 'relative',
      cursor: 'text',
      display: 'inline-flex',
      alignItems: 'center',
      '&$disabled': {
        color: theme.palette.text.disabled,
        cursor: 'default'
      }
    }),

    /* Styles applied to the root element if the component is a descendant of `FormControl`. */
    formControl: {},

    /* Styles applied to the root element if the component is focused. */
    focused: {},

    /* Styles applied to the root element if `disabled={true}`. */
    disabled: {},

    /* Styles applied to the root element if `startAdornment` is provided. */
    adornedStart: {},

    /* Styles applied to the root element if `endAdornment` is provided. */
    adornedEnd: {},

    /* Pseudo-class applied to the root element if `error={true}`. */
    error: {},

    /* Styles applied to the `input` element if `margin="dense"`. */
    marginDense: {},

    /* Styles applied to the root element if `multiline={true}`. */
    multiline: {
      padding: "".concat(8 - 2, "px 0 ").concat(8 - 1, "px"),
      '&$marginDense': {
        paddingTop: 4 - 1
      }
    },

    /* Styles applied to the root element if the color is secondary. */
    colorSecondary: {},

    /* Styles applied to the root element if `fullWidth={true}`. */
    fullWidth: {
      width: '100%'
    },

    /* Styles applied to the `input` element. */
    input: {
      font: 'inherit',
      letterSpacing: 'inherit',
      color: 'currentColor',
      padding: "".concat(8 - 2, "px 0 ").concat(8 - 1, "px"),
      border: 0,
      boxSizing: 'content-box',
      background: 'none',
      height: '1.1876em',
      // Reset (19px), match the native input line-height
      margin: 0,
      // Reset for Safari
      WebkitTapHighlightColor: 'transparent',
      display: 'block',
      // Make the flex item shrink with Firefox
      minWidth: 0,
      width: '100%',
      // Fix IE 11 width issue
      animationName: 'mui-auto-fill-cancel',
      animationDuration: '10ms',
      '&::-webkit-input-placeholder': placeholder,
      '&::-moz-placeholder': placeholder,
      // Firefox 19+
      '&:-ms-input-placeholder': placeholder,
      // IE 11
      '&::-ms-input-placeholder': placeholder,
      // Edge
      '&:focus': {
        outline: 0
      },
      // Reset Firefox invalid required input style
      '&:invalid': {
        boxShadow: 'none'
      },
      '&::-webkit-search-decoration': {
        // Remove the padding when type=search.
        '-webkit-appearance': 'none'
      },
      // Show and hide the placeholder logic
      'label[data-shrink=false] + $formControl &': {
        '&::-webkit-input-placeholder': placeholderHidden,
        '&::-moz-placeholder': placeholderHidden,
        // Firefox 19+
        '&:-ms-input-placeholder': placeholderHidden,
        // IE 11
        '&::-ms-input-placeholder': placeholderHidden,
        // Edge
        '&:focus::-webkit-input-placeholder': placeholderVisible,
        '&:focus::-moz-placeholder': placeholderVisible,
        // Firefox 19+
        '&:focus:-ms-input-placeholder': placeholderVisible,
        // IE 11
        '&:focus::-ms-input-placeholder': placeholderVisible // Edge

      },
      '&$disabled': {
        opacity: 1 // Reset iOS opacity

      },
      '&:-webkit-autofill': {
        animationDuration: '5000s',
        animationName: 'mui-auto-fill'
      }
    },

    /* Styles applied to the `input` element if `margin="dense"`. */
    inputMarginDense: {
      paddingTop: 4 - 1
    },

    /* Styles applied to the `input` element if `multiline={true}`. */
    inputMultiline: {
      height: 'auto',
      resize: 'none',
      padding: 0
    },

    /* Styles applied to the `input` element if `type="search"`. */
    inputTypeSearch: {
      // Improve type search style.
      '-moz-appearance': 'textfield',
      '-webkit-appearance': 'textfield'
    },

    /* Styles applied to the `input` element if `startAdornment` is provided. */
    inputAdornedStart: {},

    /* Styles applied to the `input` element if `endAdornment` is provided. */
    inputAdornedEnd: {},

    /* Styles applied to the `input` element if `hiddenLabel={true}`. */
    inputHiddenLabel: {}
  };
};

exports.styles = styles;
var useEnhancedEffect = typeof window === 'undefined' ? React.useEffect : React.useLayoutEffect;
/**
 * `InputBase` contains as few styles as possible.
 * It aims to be a simple building block for creating an input.
 * It contains a load of style reset and some state logic.
 */

var InputBase = /*#__PURE__*/React.forwardRef(function InputBase(props, ref) {
  var ariaDescribedby = props['aria-describedby'],
      autoComplete = props.autoComplete,
      autoFocus = props.autoFocus,
      classes = props.classes,
      className = props.className,
      color = props.color,
      defaultValue = props.defaultValue,
      disabled = props.disabled,
      endAdornment = props.endAdornment,
      error = props.error,
      _props$fullWidth = props.fullWidth,
      fullWidth = _props$fullWidth === void 0 ? false : _props$fullWidth,
      id = props.id,
      _props$inputComponent = props.inputComponent,
      inputComponent = _props$inputComponent === void 0 ? 'input' : _props$inputComponent,
      _props$inputProps = props.inputProps,
      inputPropsProp = _props$inputProps === void 0 ? {} : _props$inputProps,
      inputRefProp = props.inputRef,
      margin = props.margin,
      _props$multiline = props.multiline,
      multiline = _props$multiline === void 0 ? false : _props$multiline,
      name = props.name,
      onBlur = props.onBlur,
      onChange = props.onChange,
      onClick = props.onClick,
      onFocus = props.onFocus,
      onKeyDown = props.onKeyDown,
      onKeyUp = props.onKeyUp,
      placeholder = props.placeholder,
      readOnly = props.readOnly,
      renderSuffix = props.renderSuffix,
      rows = props.rows,
      rowsMax = props.rowsMax,
      rowsMin = props.rowsMin,
      maxRows = props.maxRows,
      minRows = props.minRows,
      startAdornment = props.startAdornment,
      _props$type = props.type,
      type = _props$type === void 0 ? 'text' : _props$type,
      valueProp = props.value,
      other = (0, _objectWithoutProperties2.default)(props, ["aria-describedby", "autoComplete", "autoFocus", "classes", "className", "color", "defaultValue", "disabled", "endAdornment", "error", "fullWidth", "id", "inputComponent", "inputProps", "inputRef", "margin", "multiline", "name", "onBlur", "onChange", "onClick", "onFocus", "onKeyDown", "onKeyUp", "placeholder", "readOnly", "renderSuffix", "rows", "rowsMax", "rowsMin", "maxRows", "minRows", "startAdornment", "type", "value"]);
  var value = inputPropsProp.value != null ? inputPropsProp.value : valueProp;

  var _React$useRef = React.useRef(value != null),
      isControlled = _React$useRef.current;

  var inputRef = React.useRef();
  var handleInputRefWarning = React.useCallback(function (instance) {
    if ("development" !== 'production') {
      if (instance && instance.nodeName !== 'INPUT' && !instance.focus) {
        console.error(['Material-UI: You have provided a `inputComponent` to the input component', 'that does not correctly handle the `inputRef` prop.', 'Make sure the `inputRef` prop is called with a HTMLInputElement.'].join('\n'));
      }
    }
  }, []);
  var handleInputPropsRefProp = (0, _useForkRef.default)(inputPropsProp.ref, handleInputRefWarning);
  var handleInputRefProp = (0, _useForkRef.default)(inputRefProp, handleInputPropsRefProp);
  var handleInputRef = (0, _useForkRef.default)(inputRef, handleInputRefProp);

  var _React$useState = React.useState(false),
      focused = _React$useState[0],
      setFocused = _React$useState[1];

  var muiFormControl = (0, _FormControlContext.useFormControl)();

  if ("development" !== 'production') {
    // eslint-disable-next-line react-hooks/rules-of-hooks
    React.useEffect(function () {
      if (muiFormControl) {
        return muiFormControl.registerEffect();
      }

      return undefined;
    }, [muiFormControl]);
  }

  var fcs = (0, _formControlState.default)({
    props: props,
    muiFormControl: muiFormControl,
    states: ['color', 'disabled', 'error', 'hiddenLabel', 'margin', 'required', 'filled']
  });
  fcs.focused = muiFormControl ? muiFormControl.focused : focused; // The blur won't fire when the disabled state is set on a focused input.
  // We need to book keep the focused state manually.

  React.useEffect(function () {
    if (!muiFormControl && disabled && focused) {
      setFocused(false);

      if (onBlur) {
        onBlur();
      }
    }
  }, [muiFormControl, disabled, focused, onBlur]);
  var onFilled = muiFormControl && muiFormControl.onFilled;
  var onEmpty = muiFormControl && muiFormControl.onEmpty;
  var checkDirty = React.useCallback(function (obj) {
    if ((0, _utils2.isFilled)(obj)) {
      if (onFilled) {
        onFilled();
      }
    } else if (onEmpty) {
      onEmpty();
    }
  }, [onFilled, onEmpty]);
  useEnhancedEffect(function () {
    if (isControlled) {
      checkDirty({
        value: value
      });
    }
  }, [value, checkDirty, isControlled]);

  var handleFocus = function handleFocus(event) {
    // Fix a bug with IE 11 where the focus/blur events are triggered
    // while the input is disabled.
    if (fcs.disabled) {
      event.stopPropagation();
      return;
    }

    if (onFocus) {
      onFocus(event);
    }

    if (inputPropsProp.onFocus) {
      inputPropsProp.onFocus(event);
    }

    if (muiFormControl && muiFormControl.onFocus) {
      muiFormControl.onFocus(event);
    } else {
      setFocused(true);
    }
  };

  var handleBlur = function handleBlur(event) {
    if (onBlur) {
      onBlur(event);
    }

    if (inputPropsProp.onBlur) {
      inputPropsProp.onBlur(event);
    }

    if (muiFormControl && muiFormControl.onBlur) {
      muiFormControl.onBlur(event);
    } else {
      setFocused(false);
    }
  };

  var handleChange = function handleChange(event) {
    if (!isControlled) {
      var element = event.target || inputRef.current;

      if (element == null) {
        throw new Error("development" !== "production" ? "Material-UI: Expected valid input target. Did you use a custom `inputComponent` and forget to forward refs? See https://mui.com/r/input-component-ref-interface for more info." : (0, _utils.formatMuiErrorMessage)(1));
      }

      checkDirty({
        value: element.value
      });
    }

    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    if (inputPropsProp.onChange) {
      inputPropsProp.onChange.apply(inputPropsProp, [event].concat(args));
    } // Perform in the willUpdate


    if (onChange) {
      onChange.apply(void 0, [event].concat(args));
    }
  }; // Check the input state on mount, in case it was filled by the user
  // or auto filled by the browser before the hydration (for SSR).


  React.useEffect(function () {
    checkDirty(inputRef.current);
  }, []); // eslint-disable-line react-hooks/exhaustive-deps

  var handleClick = function handleClick(event) {
    if (inputRef.current && event.currentTarget === event.target) {
      inputRef.current.focus();
    }

    if (onClick) {
      onClick(event);
    }
  };

  var InputComponent = inputComponent;
  var inputProps = (0, _extends2.default)({}, inputPropsProp, {
    ref: handleInputRef
  });

  if (typeof InputComponent !== 'string') {
    inputProps = (0, _extends2.default)({
      // Rename ref to inputRef as we don't know the
      // provided `inputComponent` structure.
      inputRef: handleInputRef,
      type: type
    }, inputProps, {
      ref: null
    });
  } else if (multiline) {
    if (rows && !maxRows && !minRows && !rowsMax && !rowsMin) {
      InputComponent = 'textarea';
    } else {
      inputProps = (0, _extends2.default)({
        minRows: rows || minRows,
        rowsMax: rowsMax,
        maxRows: maxRows
      }, inputProps);
      InputComponent = _TextareaAutosize.default;
    }
  } else {
    inputProps = (0, _extends2.default)({
      type: type
    }, inputProps);
  }

  var handleAutoFill = function handleAutoFill(event) {
    // Provide a fake value as Chrome might not let you access it for security reasons.
    checkDirty(event.animationName === 'mui-auto-fill-cancel' ? inputRef.current : {
      value: 'x'
    });
  };

  React.useEffect(function () {
    if (muiFormControl) {
      muiFormControl.setAdornedStart(Boolean(startAdornment));
    }
  }, [muiFormControl, startAdornment]);
  return /*#__PURE__*/React.createElement("div", (0, _extends2.default)({
    className: (0, _clsx.default)(classes.root, classes["color".concat((0, _capitalize.default)(fcs.color || 'primary'))], className, fcs.disabled && classes.disabled, fcs.error && classes.error, fullWidth && classes.fullWidth, fcs.focused && classes.focused, muiFormControl && classes.formControl, multiline && classes.multiline, startAdornment && classes.adornedStart, endAdornment && classes.adornedEnd, fcs.margin === 'dense' && classes.marginDense),
    onClick: handleClick,
    ref: ref
  }, other), startAdornment, /*#__PURE__*/React.createElement(_FormControlContext.default.Provider, {
    value: null
  }, /*#__PURE__*/React.createElement(InputComponent, (0, _extends2.default)({
    "aria-invalid": fcs.error,
    "aria-describedby": ariaDescribedby,
    autoComplete: autoComplete,
    autoFocus: autoFocus,
    defaultValue: defaultValue,
    disabled: fcs.disabled,
    id: id,
    onAnimationStart: handleAutoFill,
    name: name,
    placeholder: placeholder,
    readOnly: readOnly,
    required: fcs.required,
    rows: rows,
    value: value,
    onKeyDown: onKeyDown,
    onKeyUp: onKeyUp
  }, inputProps, {
    className: (0, _clsx.default)(classes.input, inputPropsProp.className, fcs.disabled && classes.disabled, multiline && classes.inputMultiline, fcs.hiddenLabel && classes.inputHiddenLabel, startAdornment && classes.inputAdornedStart, endAdornment && classes.inputAdornedEnd, type === 'search' && classes.inputTypeSearch, fcs.margin === 'dense' && classes.inputMarginDense),
    onBlur: handleBlur,
    onChange: handleChange,
    onFocus: handleFocus
  }))), endAdornment, renderSuffix ? renderSuffix((0, _extends2.default)({}, fcs, {
    startAdornment: startAdornment
  })) : null);
});
"development" !== "production" ? InputBase.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * @ignore
   */
  'aria-describedby': _propTypes.default.string,

  /**
   * This prop helps users to fill forms faster, especially on mobile devices.
   * The name can be confusing, as it's more like an autofill.
   * You can learn more about it [following the specification](https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#autofill).
   */
  autoComplete: _propTypes.default.string,

  /**
   * If `true`, the `input` element will be focused during the first mount.
   */
  autoFocus: _propTypes.default.bool,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object,

  /**
   * @ignore
   */
  className: _propTypes.default.string,

  /**
   * The color of the component. It supports those theme colors that make sense for this component.
   */
  color: _propTypes.default.oneOf(['primary', 'secondary']),

  /**
   * The default `input` element value. Use when the component is not controlled.
   */
  defaultValue: _propTypes.default.any,

  /**
   * If `true`, the `input` element will be disabled.
   */
  disabled: _propTypes.default.bool,

  /**
   * End `InputAdornment` for this component.
   */
  endAdornment: _propTypes.default.node,

  /**
   * If `true`, the input will indicate an error. This is normally obtained via context from
   * FormControl.
   */
  error: _propTypes.default.bool,

  /**
   * If `true`, the input will take up the full width of its container.
   */
  fullWidth: _propTypes.default.bool,

  /**
   * The id of the `input` element.
   */
  id: _propTypes.default.string,

  /**
   * The component used for the `input` element.
   * Either a string to use a HTML element or a component.
   */
  inputComponent: _propTypes.default.elementType,

  /**
   * [Attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Attributes) applied to the `input` element.
   */
  inputProps: _propTypes.default.object,

  /**
   * Pass a ref to the `input` element.
   */
  inputRef: _utils.refType,

  /**
   * If `dense`, will adjust vertical spacing. This is normally obtained via context from
   * FormControl.
   */
  margin: _propTypes.default.oneOf(['dense', 'none']),

  /**
   * Maximum number of rows to display when multiline option is set to true.
   */
  maxRows: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * Minimum number of rows to display when multiline option is set to true.
   */
  minRows: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * If `true`, a textarea element will be rendered.
   */
  multiline: _propTypes.default.bool,

  /**
   * Name attribute of the `input` element.
   */
  name: _propTypes.default.string,

  /**
   * Callback fired when the input is blurred.
   *
   * Notice that the first argument (event) might be undefined.
   */
  onBlur: _propTypes.default.func,

  /**
   * Callback fired when the value is changed.
   *
   * @param {object} event The event source of the callback.
   * You can pull out the new value by accessing `event.target.value` (string).
   */
  onChange: _propTypes.default.func,

  /**
   * @ignore
   */
  onClick: _propTypes.default.func,

  /**
   * @ignore
   */
  onFocus: _propTypes.default.func,

  /**
   * @ignore
   */
  onKeyDown: _propTypes.default.func,

  /**
   * @ignore
   */
  onKeyUp: _propTypes.default.func,

  /**
   * The short hint displayed in the input before the user enters a value.
   */
  placeholder: _propTypes.default.string,

  /**
   * It prevents the user from changing the value of the field
   * (not from interacting with the field).
   */
  readOnly: _propTypes.default.bool,

  /**
   * @ignore
   */
  renderSuffix: _propTypes.default.func,

  /**
   * If `true`, the `input` element will be required.
   */
  required: _propTypes.default.bool,

  /**
   * Number of rows to display when multiline option is set to true.
   */
  rows: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * Maximum number of rows to display.
   * @deprecated Use `maxRows` instead.
   */
  rowsMax: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * Minimum number of rows to display.
   * @deprecated Use `minRows` instead.
   */
  rowsMin: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * Start `InputAdornment` for this component.
   */
  startAdornment: _propTypes.default.node,

  /**
   * Type of the `input` element. It should be [a valid HTML5 input type](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Form_%3Cinput%3E_types).
   */
  type: _propTypes.default.string,

  /**
   * The value of the `input` element, required for a controlled component.
   */
  value: _propTypes.default.any
} : void 0;

var _default = (0, _withStyles.default)(styles, {
  name: 'MuiInputBase'
})(InputBase);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\InputBase\\InputBase.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\InputBase\\index.js", {"./InputBase":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\InputBase\\InputBase.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CInputBase%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _InputBase.default;
  }
});

var _InputBase = _interopRequireDefault(require("./InputBase"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\InputBase\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\InputBase\\utils.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CInputBase%5Cutils.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasValue = hasValue;
exports.isFilled = isFilled;
exports.isAdornedStart = isAdornedStart;

// Supports determination of isControlled().
// Controlled input accepts its current value as a prop.
//
// @see https://facebook.github.io/react/docs/forms.html#controlled-components
// @param value
// @returns {boolean} true if string (including '') or number (including zero)
function hasValue(value) {
  return value != null && !(Array.isArray(value) && value.length === 0);
} // Determine if field is empty or filled.
// Response determines if label is presented above field or as placeholder.
//
// @param obj
// @param SSR
// @returns {boolean} False when not present or empty string.
//                    True when any number or string with length.


function isFilled(obj) {
  var SSR = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  return obj && (hasValue(obj.value) && obj.value !== '' || SSR && hasValue(obj.defaultValue) && obj.defaultValue !== '');
} // Determine if an Input is adorned on start.
// It's corresponding to the left with LTR.
//
// @param obj
// @returns {boolean} False when no adornments.
//                    True when adorned at the start.


function isAdornedStart(obj) {
  return obj.startAdornment;
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\InputBase\\utils.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\InputLabel\\InputLabel.js", {"../FormControl/formControlState":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\formControlState.js","../FormControl/useFormControl":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\useFormControl.js","../FormLabel":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormLabel\\index.js","../styles/withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withStyles.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","clsx":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\node_modules\\clsx\\dist\\clsx.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CInputLabel%5CInputLabel.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _formControlState = _interopRequireDefault(require("../FormControl/formControlState"));

var _useFormControl = _interopRequireDefault(require("../FormControl/useFormControl"));

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var _FormLabel = _interopRequireDefault(require("../FormLabel"));

var styles = function styles(theme) {
  return {
    /* Styles applied to the root element. */
    root: {
      display: 'block',
      transformOrigin: 'top left'
    },

    /* Pseudo-class applied to the root element if `focused={true}`. */
    focused: {},

    /* Pseudo-class applied to the root element if `disabled={true}`. */
    disabled: {},

    /* Pseudo-class applied to the root element if `error={true}`. */
    error: {},

    /* Pseudo-class applied to the root element if `required={true}`. */
    required: {},

    /* Pseudo-class applied to the asterisk element. */
    asterisk: {},

    /* Styles applied to the root element if the component is a descendant of `FormControl`. */
    formControl: {
      position: 'absolute',
      left: 0,
      top: 0,
      // slight alteration to spec spacing to match visual spec result
      transform: 'translate(0, 24px) scale(1)'
    },

    /* Styles applied to the root element if `margin="dense"`. */
    marginDense: {
      // Compensation for the `Input.inputDense` style.
      transform: 'translate(0, 21px) scale(1)'
    },

    /* Styles applied to the `input` element if `shrink={true}`. */
    shrink: {
      transform: 'translate(0, 1.5px) scale(0.75)',
      transformOrigin: 'top left'
    },

    /* Styles applied to the `input` element if `disableAnimation={false}`. */
    animated: {
      transition: theme.transitions.create(['color', 'transform'], {
        duration: theme.transitions.duration.shorter,
        easing: theme.transitions.easing.easeOut
      })
    },

    /* Styles applied to the root element if `variant="filled"`. */
    filled: {
      // Chrome's autofill feature gives the input field a yellow background.
      // Since the input field is behind the label in the HTML tree,
      // the input field is drawn last and hides the label with an opaque background color.
      // zIndex: 1 will raise the label above opaque background-colors of input.
      zIndex: 1,
      pointerEvents: 'none',
      transform: 'translate(12px, 20px) scale(1)',
      '&$marginDense': {
        transform: 'translate(12px, 17px) scale(1)'
      },
      '&$shrink': {
        transform: 'translate(12px, 10px) scale(0.75)',
        '&$marginDense': {
          transform: 'translate(12px, 7px) scale(0.75)'
        }
      }
    },

    /* Styles applied to the root element if `variant="outlined"`. */
    outlined: {
      // see comment above on filled.zIndex
      zIndex: 1,
      pointerEvents: 'none',
      transform: 'translate(14px, 20px) scale(1)',
      '&$marginDense': {
        transform: 'translate(14px, 12px) scale(1)'
      },
      '&$shrink': {
        transform: 'translate(14px, -6px) scale(0.75)'
      }
    }
  };
};

exports.styles = styles;
var InputLabel = /*#__PURE__*/React.forwardRef(function InputLabel(props, ref) {
  var classes = props.classes,
      className = props.className,
      _props$disableAnimati = props.disableAnimation,
      disableAnimation = _props$disableAnimati === void 0 ? false : _props$disableAnimati,
      margin = props.margin,
      shrinkProp = props.shrink,
      variant = props.variant,
      other = (0, _objectWithoutProperties2.default)(props, ["classes", "className", "disableAnimation", "margin", "shrink", "variant"]);
  var muiFormControl = (0, _useFormControl.default)();
  var shrink = shrinkProp;

  if (typeof shrink === 'undefined' && muiFormControl) {
    shrink = muiFormControl.filled || muiFormControl.focused || muiFormControl.adornedStart;
  }

  var fcs = (0, _formControlState.default)({
    props: props,
    muiFormControl: muiFormControl,
    states: ['margin', 'variant']
  });
  return /*#__PURE__*/React.createElement(_FormLabel.default, (0, _extends2.default)({
    "data-shrink": shrink,
    className: (0, _clsx.default)(classes.root, className, muiFormControl && classes.formControl, !disableAnimation && classes.animated, shrink && classes.shrink, fcs.margin === 'dense' && classes.marginDense, {
      'filled': classes.filled,
      'outlined': classes.outlined
    }[fcs.variant]),
    classes: {
      focused: classes.focused,
      disabled: classes.disabled,
      error: classes.error,
      required: classes.required,
      asterisk: classes.asterisk
    },
    ref: ref
  }, other));
});
"development" !== "production" ? InputLabel.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * The contents of the `InputLabel`.
   */
  children: _propTypes.default.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object,

  /**
   * @ignore
   */
  className: _propTypes.default.string,

  /**
   * The color of the component. It supports those theme colors that make sense for this component.
   */
  color: _propTypes.default.oneOf(['primary', 'secondary']),

  /**
   * If `true`, the transition animation is disabled.
   */
  disableAnimation: _propTypes.default.bool,

  /**
   * If `true`, apply disabled class.
   */
  disabled: _propTypes.default.bool,

  /**
   * If `true`, the label will be displayed in an error state.
   */
  error: _propTypes.default.bool,

  /**
   * If `true`, the input of this label is focused.
   */
  focused: _propTypes.default.bool,

  /**
   * If `dense`, will adjust vertical spacing. This is normally obtained via context from
   * FormControl.
   */
  margin: _propTypes.default.oneOf(['dense']),

  /**
   * if `true`, the label will indicate that the input is required.
   */
  required: _propTypes.default.bool,

  /**
   * If `true`, the label is shrunk.
   */
  shrink: _propTypes.default.bool,

  /**
   * The variant to use.
   */
  variant: _propTypes.default.oneOf(['filled', 'outlined', 'standard'])
} : void 0;

var _default = (0, _withStyles.default)(styles, {
  name: 'MuiInputLabel'
})(InputLabel);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\InputLabel\\InputLabel.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\InputLabel\\index.js", {"./InputLabel":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\InputLabel\\InputLabel.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CInputLabel%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _InputLabel.default;
  }
});

var _InputLabel = _interopRequireDefault(require("./InputLabel"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\InputLabel\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Input\\Input.js", {"../InputBase":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\InputBase\\index.js","../styles/withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withStyles.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js","clsx":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\node_modules\\clsx\\dist\\clsx.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CInput%5CInput.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _utils = require("@material-ui/utils");

var _InputBase = _interopRequireDefault(require("../InputBase"));

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var styles = function styles(theme) {
  var light = theme.palette.type === 'light';
  var bottomLineColor = light ? 'rgba(0, 0, 0, 0.42)' : 'rgba(255, 255, 255, 0.7)';
  return {
    /* Styles applied to the root element. */
    root: {
      position: 'relative'
    },

    /* Styles applied to the root element if the component is a descendant of `FormControl`. */
    formControl: {
      'label + &': {
        marginTop: 16
      }
    },

    /* Styles applied to the root element if the component is focused. */
    focused: {},

    /* Styles applied to the root element if `disabled={true}`. */
    disabled: {},

    /* Styles applied to the root element if color secondary. */
    colorSecondary: {
      '&$underline:after': {
        borderBottomColor: theme.palette.secondary.main
      }
    },

    /* Styles applied to the root element if `disableUnderline={false}`. */
    underline: {
      '&:after': {
        borderBottom: "2px solid ".concat(theme.palette.primary.main),
        left: 0,
        bottom: 0,
        // Doing the other way around crash on IE 11 "''" https://github.com/cssinjs/jss/issues/242
        content: '""',
        position: 'absolute',
        right: 0,
        transform: 'scaleX(0)',
        transition: theme.transitions.create('transform', {
          duration: theme.transitions.duration.shorter,
          easing: theme.transitions.easing.easeOut
        }),
        pointerEvents: 'none' // Transparent to the hover style.

      },
      '&$focused:after': {
        transform: 'scaleX(1)'
      },
      '&$error:after': {
        borderBottomColor: theme.palette.error.main,
        transform: 'scaleX(1)' // error is always underlined in red

      },
      '&:before': {
        borderBottom: "1px solid ".concat(bottomLineColor),
        left: 0,
        bottom: 0,
        // Doing the other way around crash on IE 11 "''" https://github.com/cssinjs/jss/issues/242
        content: '"\\00a0"',
        position: 'absolute',
        right: 0,
        transition: theme.transitions.create('border-bottom-color', {
          duration: theme.transitions.duration.shorter
        }),
        pointerEvents: 'none' // Transparent to the hover style.

      },
      '&:hover:not($disabled):before': {
        borderBottom: "2px solid ".concat(theme.palette.text.primary),
        // Reset on touch devices, it doesn't add specificity
        '@media (hover: none)': {
          borderBottom: "1px solid ".concat(bottomLineColor)
        }
      },
      '&$disabled:before': {
        borderBottomStyle: 'dotted'
      }
    },

    /* Pseudo-class applied to the root element if `error={true}`. */
    error: {},

    /* Styles applied to the `input` element if `margin="dense"`. */
    marginDense: {},

    /* Styles applied to the root element if `multiline={true}`. */
    multiline: {},

    /* Styles applied to the root element if `fullWidth={true}`. */
    fullWidth: {},

    /* Styles applied to the `input` element. */
    input: {},

    /* Styles applied to the `input` element if `margin="dense"`. */
    inputMarginDense: {},

    /* Styles applied to the `input` element if `multiline={true}`. */
    inputMultiline: {},

    /* Styles applied to the `input` element if `type="search"`. */
    inputTypeSearch: {}
  };
};

exports.styles = styles;
var Input = /*#__PURE__*/React.forwardRef(function Input(props, ref) {
  var disableUnderline = props.disableUnderline,
      classes = props.classes,
      _props$fullWidth = props.fullWidth,
      fullWidth = _props$fullWidth === void 0 ? false : _props$fullWidth,
      _props$inputComponent = props.inputComponent,
      inputComponent = _props$inputComponent === void 0 ? 'input' : _props$inputComponent,
      _props$multiline = props.multiline,
      multiline = _props$multiline === void 0 ? false : _props$multiline,
      _props$type = props.type,
      type = _props$type === void 0 ? 'text' : _props$type,
      other = (0, _objectWithoutProperties2.default)(props, ["disableUnderline", "classes", "fullWidth", "inputComponent", "multiline", "type"]);
  return /*#__PURE__*/React.createElement(_InputBase.default, (0, _extends2.default)({
    classes: (0, _extends2.default)({}, classes, {
      root: (0, _clsx.default)(classes.root, !disableUnderline && classes.underline),
      underline: null
    }),
    fullWidth: fullWidth,
    inputComponent: inputComponent,
    multiline: multiline,
    ref: ref,
    type: type
  }, other));
});
"development" !== "production" ? Input.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * This prop helps users to fill forms faster, especially on mobile devices.
   * The name can be confusing, as it's more like an autofill.
   * You can learn more about it [following the specification](https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#autofill).
   */
  autoComplete: _propTypes.default.string,

  /**
   * If `true`, the `input` element will be focused during the first mount.
   */
  autoFocus: _propTypes.default.bool,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object,

  /**
   * The color of the component. It supports those theme colors that make sense for this component.
   */
  color: _propTypes.default.oneOf(['primary', 'secondary']),

  /**
   * The default `input` element value. Use when the component is not controlled.
   */
  defaultValue: _propTypes.default.any,

  /**
   * If `true`, the `input` element will be disabled.
   */
  disabled: _propTypes.default.bool,

  /**
   * If `true`, the input will not have an underline.
   */
  disableUnderline: _propTypes.default.bool,

  /**
   * End `InputAdornment` for this component.
   */
  endAdornment: _propTypes.default.node,

  /**
   * If `true`, the input will indicate an error. This is normally obtained via context from
   * FormControl.
   */
  error: _propTypes.default.bool,

  /**
   * If `true`, the input will take up the full width of its container.
   */
  fullWidth: _propTypes.default.bool,

  /**
   * The id of the `input` element.
   */
  id: _propTypes.default.string,

  /**
   * The component used for the `input` element.
   * Either a string to use a HTML element or a component.
   */
  inputComponent: _propTypes.default.elementType,

  /**
   * [Attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Attributes) applied to the `input` element.
   */
  inputProps: _propTypes.default.object,

  /**
   * Pass a ref to the `input` element.
   */
  inputRef: _utils.refType,

  /**
   * If `dense`, will adjust vertical spacing. This is normally obtained via context from
   * FormControl.
   */
  margin: _propTypes.default.oneOf(['dense', 'none']),

  /**
   * Maximum number of rows to display when multiline option is set to true.
   */
  maxRows: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * If `true`, a textarea element will be rendered.
   */
  multiline: _propTypes.default.bool,

  /**
   * Name attribute of the `input` element.
   */
  name: _propTypes.default.string,

  /**
   * Callback fired when the value is changed.
   *
   * @param {object} event The event source of the callback.
   * You can pull out the new value by accessing `event.target.value` (string).
   */
  onChange: _propTypes.default.func,

  /**
   * The short hint displayed in the input before the user enters a value.
   */
  placeholder: _propTypes.default.string,

  /**
   * It prevents the user from changing the value of the field
   * (not from interacting with the field).
   */
  readOnly: _propTypes.default.bool,

  /**
   * If `true`, the `input` element will be required.
   */
  required: _propTypes.default.bool,

  /**
   * Number of rows to display when multiline option is set to true.
   */
  rows: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * Start `InputAdornment` for this component.
   */
  startAdornment: _propTypes.default.node,

  /**
   * Type of the `input` element. It should be [a valid HTML5 input type](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Form_%3Cinput%3E_types).
   */
  type: _propTypes.default.string,

  /**
   * The value of the `input` element, required for a controlled component.
   */
  value: _propTypes.default.any
} : void 0;
Input.muiName = 'Input';

var _default = (0, _withStyles.default)(styles, {
  name: 'MuiInput'
})(Input);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Input\\Input.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Input\\index.js", {"./Input":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Input\\Input.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CInput%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _Input.default;
  }
});

var _Input = _interopRequireDefault(require("./Input"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Input\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\List\\List.js", {"../styles/withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withStyles.js","./ListContext":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\List\\ListContext.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","clsx":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\node_modules\\clsx\\dist\\clsx.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CList%5CList.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var _ListContext = _interopRequireDefault(require("./ListContext"));

var styles = {
  /* Styles applied to the root element. */
  root: {
    listStyle: 'none',
    margin: 0,
    padding: 0,
    position: 'relative'
  },

  /* Styles applied to the root element if `disablePadding={false}`. */
  padding: {
    paddingTop: 8,
    paddingBottom: 8
  },

  /* Styles applied to the root element if dense. */
  dense: {},

  /* Styles applied to the root element if a `subheader` is provided. */
  subheader: {
    paddingTop: 0
  }
};
exports.styles = styles;
var List = /*#__PURE__*/React.forwardRef(function List(props, ref) {
  var children = props.children,
      classes = props.classes,
      className = props.className,
      _props$component = props.component,
      Component = _props$component === void 0 ? 'ul' : _props$component,
      _props$dense = props.dense,
      dense = _props$dense === void 0 ? false : _props$dense,
      _props$disablePadding = props.disablePadding,
      disablePadding = _props$disablePadding === void 0 ? false : _props$disablePadding,
      subheader = props.subheader,
      other = (0, _objectWithoutProperties2.default)(props, ["children", "classes", "className", "component", "dense", "disablePadding", "subheader"]);
  var context = React.useMemo(function () {
    return {
      dense: dense
    };
  }, [dense]);
  return /*#__PURE__*/React.createElement(_ListContext.default.Provider, {
    value: context
  }, /*#__PURE__*/React.createElement(Component, (0, _extends2.default)({
    className: (0, _clsx.default)(classes.root, className, dense && classes.dense, !disablePadding && classes.padding, subheader && classes.subheader),
    ref: ref
  }, other), subheader, children));
});
"development" !== "production" ? List.propTypes = {
  /**
   * The content of the component.
   */
  children: _propTypes.default.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object.isRequired,

  /**
   * @ignore
   */
  className: _propTypes.default.string,

  /**
   * The component used for the root node.
   * Either a string to use a HTML element or a component.
   */
  component: _propTypes.default
  /* @typescript-to-proptypes-ignore */
  .elementType,

  /**
   * If `true`, compact vertical padding designed for keyboard and mouse input will be used for
   * the list and list items.
   * The prop is available to descendant components as the `dense` context.
   */
  dense: _propTypes.default.bool,

  /**
   * If `true`, vertical padding will be removed from the list.
   */
  disablePadding: _propTypes.default.bool,

  /**
   * The content of the subheader, normally `ListSubheader`.
   */
  subheader: _propTypes.default.node
} : void 0;

var _default = (0, _withStyles.default)(styles, {
  name: 'MuiList'
})(List);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\List\\List.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\List\\ListContext.js", {"@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CList%5CListContext.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

/**
 * @ignore - internal component.
 */
var ListContext = React.createContext({});

if ("development" !== 'production') {
  ListContext.displayName = 'ListContext';
}

var _default = ListContext;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\List\\ListContext.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\List\\index.js", {"./List":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\List\\List.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CList%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _List.default;
  }
});

var _List = _interopRequireDefault(require("./List"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\List\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\MenuList\\MenuList.js", {"../List":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\List\\index.js","../utils/getScrollbarSize":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\getScrollbarSize.js","../utils/ownerDocument":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\ownerDocument.js","../utils/useForkRef":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\useForkRef.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-dom\\index.js","react-is":"D:\\code\\v\\metamask-extension\\node_modules\\react-is\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CMenuList%5CMenuList.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var React = _interopRequireWildcard(require("react"));

var _reactIs = require("react-is");

var _propTypes = _interopRequireDefault(require("prop-types"));

var ReactDOM = _interopRequireWildcard(require("react-dom"));

var _ownerDocument = _interopRequireDefault(require("../utils/ownerDocument"));

var _List = _interopRequireDefault(require("../List"));

var _getScrollbarSize = _interopRequireDefault(require("../utils/getScrollbarSize"));

var _useForkRef = _interopRequireDefault(require("../utils/useForkRef"));

function nextItem(list, item, disableListWrap) {
  if (list === item) {
    return list.firstChild;
  }

  if (item && item.nextElementSibling) {
    return item.nextElementSibling;
  }

  return disableListWrap ? null : list.firstChild;
}

function previousItem(list, item, disableListWrap) {
  if (list === item) {
    return disableListWrap ? list.firstChild : list.lastChild;
  }

  if (item && item.previousElementSibling) {
    return item.previousElementSibling;
  }

  return disableListWrap ? null : list.lastChild;
}

function textCriteriaMatches(nextFocus, textCriteria) {
  if (textCriteria === undefined) {
    return true;
  }

  var text = nextFocus.innerText;

  if (text === undefined) {
    // jsdom doesn't support innerText
    text = nextFocus.textContent;
  }

  text = text.trim().toLowerCase();

  if (text.length === 0) {
    return false;
  }

  if (textCriteria.repeating) {
    return text[0] === textCriteria.keys[0];
  }

  return text.indexOf(textCriteria.keys.join('')) === 0;
}

function moveFocus(list, currentFocus, disableListWrap, disabledItemsFocusable, traversalFunction, textCriteria) {
  var wrappedOnce = false;
  var nextFocus = traversalFunction(list, currentFocus, currentFocus ? disableListWrap : false);

  while (nextFocus) {
    // Prevent infinite loop.
    if (nextFocus === list.firstChild) {
      if (wrappedOnce) {
        return;
      }

      wrappedOnce = true;
    } // Same logic as useAutocomplete.js


    var nextFocusDisabled = disabledItemsFocusable ? false : nextFocus.disabled || nextFocus.getAttribute('aria-disabled') === 'true';

    if (!nextFocus.hasAttribute('tabindex') || !textCriteriaMatches(nextFocus, textCriteria) || nextFocusDisabled) {
      // Move to the next element.
      nextFocus = traversalFunction(list, nextFocus, disableListWrap);
    } else {
      nextFocus.focus();
      return;
    }
  }
}

var useEnhancedEffect = typeof window === 'undefined' ? React.useEffect : React.useLayoutEffect;
/**
 * A permanently displayed menu following https://www.w3.org/TR/wai-aria-practices/#menubutton.
 * It's exposed to help customization of the [`Menu`](/api/menu/) component. If you
 * use it separately you need to move focus into the component manually. Once
 * the focus is placed inside the component it is fully keyboard accessible.
 */

var MenuList = /*#__PURE__*/React.forwardRef(function MenuList(props, ref) {
  var actions = props.actions,
      _props$autoFocus = props.autoFocus,
      autoFocus = _props$autoFocus === void 0 ? false : _props$autoFocus,
      _props$autoFocusItem = props.autoFocusItem,
      autoFocusItem = _props$autoFocusItem === void 0 ? false : _props$autoFocusItem,
      children = props.children,
      className = props.className,
      _props$disabledItemsF = props.disabledItemsFocusable,
      disabledItemsFocusable = _props$disabledItemsF === void 0 ? false : _props$disabledItemsF,
      _props$disableListWra = props.disableListWrap,
      disableListWrap = _props$disableListWra === void 0 ? false : _props$disableListWra,
      onKeyDown = props.onKeyDown,
      _props$variant = props.variant,
      variant = _props$variant === void 0 ? 'selectedMenu' : _props$variant,
      other = (0, _objectWithoutProperties2.default)(props, ["actions", "autoFocus", "autoFocusItem", "children", "className", "disabledItemsFocusable", "disableListWrap", "onKeyDown", "variant"]);
  var listRef = React.useRef(null);
  var textCriteriaRef = React.useRef({
    keys: [],
    repeating: true,
    previousKeyMatched: true,
    lastTime: null
  });
  useEnhancedEffect(function () {
    if (autoFocus) {
      listRef.current.focus();
    }
  }, [autoFocus]);
  React.useImperativeHandle(actions, function () {
    return {
      adjustStyleForScrollbar: function adjustStyleForScrollbar(containerElement, theme) {
        // Let's ignore that piece of logic if users are already overriding the width
        // of the menu.
        var noExplicitWidth = !listRef.current.style.width;

        if (containerElement.clientHeight < listRef.current.clientHeight && noExplicitWidth) {
          var scrollbarSize = "".concat((0, _getScrollbarSize.default)(true), "px");
          listRef.current.style[theme.direction === 'rtl' ? 'paddingLeft' : 'paddingRight'] = scrollbarSize;
          listRef.current.style.width = "calc(100% + ".concat(scrollbarSize, ")");
        }

        return listRef.current;
      }
    };
  }, []);

  var handleKeyDown = function handleKeyDown(event) {
    var list = listRef.current;
    var key = event.key;
    /**
     * @type {Element} - will always be defined since we are in a keydown handler
     * attached to an element. A keydown event is either dispatched to the activeElement
     * or document.body or document.documentElement. Only the first case will
     * trigger this specific handler.
     */

    var currentFocus = (0, _ownerDocument.default)(list).activeElement;

    if (key === 'ArrowDown') {
      // Prevent scroll of the page
      event.preventDefault();
      moveFocus(list, currentFocus, disableListWrap, disabledItemsFocusable, nextItem);
    } else if (key === 'ArrowUp') {
      event.preventDefault();
      moveFocus(list, currentFocus, disableListWrap, disabledItemsFocusable, previousItem);
    } else if (key === 'Home') {
      event.preventDefault();
      moveFocus(list, null, disableListWrap, disabledItemsFocusable, nextItem);
    } else if (key === 'End') {
      event.preventDefault();
      moveFocus(list, null, disableListWrap, disabledItemsFocusable, previousItem);
    } else if (key.length === 1) {
      var criteria = textCriteriaRef.current;
      var lowerKey = key.toLowerCase();
      var currTime = performance.now();

      if (criteria.keys.length > 0) {
        // Reset
        if (currTime - criteria.lastTime > 500) {
          criteria.keys = [];
          criteria.repeating = true;
          criteria.previousKeyMatched = true;
        } else if (criteria.repeating && lowerKey !== criteria.keys[0]) {
          criteria.repeating = false;
        }
      }

      criteria.lastTime = currTime;
      criteria.keys.push(lowerKey);
      var keepFocusOnCurrent = currentFocus && !criteria.repeating && textCriteriaMatches(currentFocus, criteria);

      if (criteria.previousKeyMatched && (keepFocusOnCurrent || moveFocus(list, currentFocus, false, disabledItemsFocusable, nextItem, criteria))) {
        event.preventDefault();
      } else {
        criteria.previousKeyMatched = false;
      }
    }

    if (onKeyDown) {
      onKeyDown(event);
    }
  };

  var handleOwnRef = React.useCallback(function (instance) {
    // #StrictMode ready
    listRef.current = ReactDOM.findDOMNode(instance);
  }, []);
  var handleRef = (0, _useForkRef.default)(handleOwnRef, ref);
  /**
   * the index of the item should receive focus
   * in a `variant="selectedMenu"` it's the first `selected` item
   * otherwise it's the very first item.
   */

  var activeItemIndex = -1; // since we inject focus related props into children we have to do a lookahead
  // to check if there is a `selected` item. We're looking for the last `selected`
  // item and use the first valid item as a fallback

  React.Children.forEach(children, function (child, index) {
    if (! /*#__PURE__*/React.isValidElement(child)) {
      return;
    }

    if ("development" !== 'production') {
      if ((0, _reactIs.isFragment)(child)) {
        console.error(["Material-UI: The Menu component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
      }
    }

    if (!child.props.disabled) {
      if (variant === 'selectedMenu' && child.props.selected) {
        activeItemIndex = index;
      } else if (activeItemIndex === -1) {
        activeItemIndex = index;
      }
    }
  });
  var items = React.Children.map(children, function (child, index) {
    if (index === activeItemIndex) {
      var newChildProps = {};

      if (autoFocusItem) {
        newChildProps.autoFocus = true;
      }

      if (child.props.tabIndex === undefined && variant === 'selectedMenu') {
        newChildProps.tabIndex = 0;
      }

      return /*#__PURE__*/React.cloneElement(child, newChildProps);
    }

    return child;
  });
  return /*#__PURE__*/React.createElement(_List.default, (0, _extends2.default)({
    role: "menu",
    ref: handleRef,
    className: className,
    onKeyDown: handleKeyDown,
    tabIndex: autoFocus ? 0 : -1
  }, other), items);
});
"development" !== "production" ? MenuList.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * If `true`, will focus the `[role="menu"]` container and move into tab order.
   */
  autoFocus: _propTypes.default.bool,

  /**
   * If `true`, will focus the first menuitem if `variant="menu"` or selected item
   * if `variant="selectedMenu"`.
   */
  autoFocusItem: _propTypes.default.bool,

  /**
   * MenuList contents, normally `MenuItem`s.
   */
  children: _propTypes.default.node,

  /**
   * @ignore
   */
  className: _propTypes.default.string,

  /**
   * If `true`, will allow focus on disabled items.
   */
  disabledItemsFocusable: _propTypes.default.bool,

  /**
   * If `true`, the menu items will not wrap focus.
   */
  disableListWrap: _propTypes.default.bool,

  /**
   * @ignore
   */
  onKeyDown: _propTypes.default.func,

  /**
   * The variant to use. Use `menu` to prevent selected items from impacting the initial focus
   * and the vertical alignment relative to the anchor element.
   */
  variant: _propTypes.default.oneOf(['menu', 'selectedMenu'])
} : void 0;
var _default = MenuList;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\MenuList\\MenuList.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\MenuList\\index.js", {"./MenuList":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\MenuList\\MenuList.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CMenuList%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _MenuList.default;
  }
});

var _MenuList = _interopRequireDefault(require("./MenuList"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\MenuList\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Menu\\Menu.js", {"../MenuList":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\MenuList\\index.js","../Popover":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Popover\\index.js","../styles/useTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\useTheme.js","../styles/withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withStyles.js","../utils/deprecatedPropType":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\deprecatedPropType.js","../utils/setRef":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\setRef.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js","clsx":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\node_modules\\clsx\\dist\\clsx.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-dom\\index.js","react-is":"D:\\code\\v\\metamask-extension\\node_modules\\react-is\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CMenu%5CMenu.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var React = _interopRequireWildcard(require("react"));

var _reactIs = require("react-is");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _utils = require("@material-ui/utils");

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var _Popover = _interopRequireDefault(require("../Popover"));

var _MenuList = _interopRequireDefault(require("../MenuList"));

var ReactDOM = _interopRequireWildcard(require("react-dom"));

var _setRef = _interopRequireDefault(require("../utils/setRef"));

var _useTheme = _interopRequireDefault(require("../styles/useTheme"));

var _deprecatedPropType = _interopRequireDefault(require("../utils/deprecatedPropType"));

var RTL_ORIGIN = {
  vertical: 'top',
  horizontal: 'right'
};
var LTR_ORIGIN = {
  vertical: 'top',
  horizontal: 'left'
};
var styles = {
  /* Styles applied to the `Paper` component. */
  paper: {
    // specZ: The maximum height of a simple menu should be one or more rows less than the view
    // height. This ensures a tapable area outside of the simple menu with which to dismiss
    // the menu.
    maxHeight: 'calc(100% - 96px)',
    // Add iOS momentum scrolling.
    WebkitOverflowScrolling: 'touch'
  },

  /* Styles applied to the `List` component via `MenuList`. */
  list: {
    // We disable the focus ring for mouse, touch and keyboard users.
    outline: 0
  }
};
exports.styles = styles;
var Menu = /*#__PURE__*/React.forwardRef(function Menu(props, ref) {
  var _props$autoFocus = props.autoFocus,
      autoFocus = _props$autoFocus === void 0 ? true : _props$autoFocus,
      children = props.children,
      classes = props.classes,
      _props$disableAutoFoc = props.disableAutoFocusItem,
      disableAutoFocusItem = _props$disableAutoFoc === void 0 ? false : _props$disableAutoFoc,
      _props$MenuListProps = props.MenuListProps,
      MenuListProps = _props$MenuListProps === void 0 ? {} : _props$MenuListProps,
      onClose = props.onClose,
      onEnteringProp = props.onEntering,
      open = props.open,
      _props$PaperProps = props.PaperProps,
      PaperProps = _props$PaperProps === void 0 ? {} : _props$PaperProps,
      PopoverClasses = props.PopoverClasses,
      _props$transitionDura = props.transitionDuration,
      transitionDuration = _props$transitionDura === void 0 ? 'auto' : _props$transitionDura,
      _props$TransitionProp = props.TransitionProps;
  _props$TransitionProp = _props$TransitionProp === void 0 ? {} : _props$TransitionProp;
  var onEntering = _props$TransitionProp.onEntering,
      TransitionProps = (0, _objectWithoutProperties2.default)(_props$TransitionProp, ["onEntering"]),
      _props$variant = props.variant,
      variant = _props$variant === void 0 ? 'selectedMenu' : _props$variant,
      other = (0, _objectWithoutProperties2.default)(props, ["autoFocus", "children", "classes", "disableAutoFocusItem", "MenuListProps", "onClose", "onEntering", "open", "PaperProps", "PopoverClasses", "transitionDuration", "TransitionProps", "variant"]);
  var theme = (0, _useTheme.default)();
  var autoFocusItem = autoFocus && !disableAutoFocusItem && open;
  var menuListActionsRef = React.useRef(null);
  var contentAnchorRef = React.useRef(null);

  var getContentAnchorEl = function getContentAnchorEl() {
    return contentAnchorRef.current;
  };

  var handleEntering = function handleEntering(element, isAppearing) {
    if (menuListActionsRef.current) {
      menuListActionsRef.current.adjustStyleForScrollbar(element, theme);
    }

    if (onEnteringProp) {
      onEnteringProp(element, isAppearing);
    }

    if (onEntering) {
      onEntering(element, isAppearing);
    }
  };

  var handleListKeyDown = function handleListKeyDown(event) {
    if (event.key === 'Tab') {
      event.preventDefault();

      if (onClose) {
        onClose(event, 'tabKeyDown');
      }
    }
  };
  /**
   * the index of the item should receive focus
   * in a `variant="selectedMenu"` it's the first `selected` item
   * otherwise it's the very first item.
   */


  var activeItemIndex = -1; // since we inject focus related props into children we have to do a lookahead
  // to check if there is a `selected` item. We're looking for the last `selected`
  // item and use the first valid item as a fallback

  React.Children.map(children, function (child, index) {
    if (! /*#__PURE__*/React.isValidElement(child)) {
      return;
    }

    if ("development" !== 'production') {
      if ((0, _reactIs.isFragment)(child)) {
        console.error(["Material-UI: The Menu component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
      }
    }

    if (!child.props.disabled) {
      if (variant !== "menu" && child.props.selected) {
        activeItemIndex = index;
      } else if (activeItemIndex === -1) {
        activeItemIndex = index;
      }
    }
  });
  var items = React.Children.map(children, function (child, index) {
    if (index === activeItemIndex) {
      return /*#__PURE__*/React.cloneElement(child, {
        ref: function ref(instance) {
          // #StrictMode ready
          contentAnchorRef.current = ReactDOM.findDOMNode(instance);
          (0, _setRef.default)(child.ref, instance);
        }
      });
    }

    return child;
  });
  return /*#__PURE__*/React.createElement(_Popover.default, (0, _extends2.default)({
    getContentAnchorEl: getContentAnchorEl,
    classes: PopoverClasses,
    onClose: onClose,
    TransitionProps: (0, _extends2.default)({
      onEntering: handleEntering
    }, TransitionProps),
    anchorOrigin: theme.direction === 'rtl' ? RTL_ORIGIN : LTR_ORIGIN,
    transformOrigin: theme.direction === 'rtl' ? RTL_ORIGIN : LTR_ORIGIN,
    PaperProps: (0, _extends2.default)({}, PaperProps, {
      classes: (0, _extends2.default)({}, PaperProps.classes, {
        root: classes.paper
      })
    }),
    open: open,
    ref: ref,
    transitionDuration: transitionDuration
  }, other), /*#__PURE__*/React.createElement(_MenuList.default, (0, _extends2.default)({
    onKeyDown: handleListKeyDown,
    actions: menuListActionsRef,
    autoFocus: autoFocus && (activeItemIndex === -1 || disableAutoFocusItem),
    autoFocusItem: autoFocusItem,
    variant: variant
  }, MenuListProps, {
    className: (0, _clsx.default)(classes.list, MenuListProps.className)
  }), items));
});
"development" !== "production" ? Menu.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * A HTML element, or a function that returns it.
   * It's used to set the position of the menu.
   */
  anchorEl: _propTypes.default
  /* @typescript-to-proptypes-ignore */
  .oneOfType([_utils.HTMLElementType, _propTypes.default.func]),

  /**
   * If `true` (Default) will focus the `[role="menu"]` if no focusable child is found. Disabled
   * children are not focusable. If you set this prop to `false` focus will be placed
   * on the parent modal container. This has severe accessibility implications
   * and should only be considered if you manage focus otherwise.
   */
  autoFocus: _propTypes.default.bool,

  /**
   * Menu contents, normally `MenuItem`s.
   */
  children: _propTypes.default.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object,

  /**
   * When opening the menu will not focus the active item but the `[role="menu"]`
   * unless `autoFocus` is also set to `false`. Not using the default means not
   * following WAI-ARIA authoring practices. Please be considerate about possible
   * accessibility implications.
   */
  disableAutoFocusItem: _propTypes.default.bool,

  /**
   * Props applied to the [`MenuList`](/api/menu-list/) element.
   */
  MenuListProps: _propTypes.default.object,

  /**
   * Callback fired when the component requests to be closed.
   *
   * @param {object} event The event source of the callback.
   * @param {string} reason Can be: `"escapeKeyDown"`, `"backdropClick"`, `"tabKeyDown"`.
   */
  onClose: _propTypes.default.func,

  /**
   * Callback fired before the Menu enters.
   * @deprecated Use the `TransitionProps` prop instead.
   */
  onEnter: (0, _deprecatedPropType.default)(_propTypes.default.func, 'Use the `TransitionProps` prop instead.'),

  /**
   * Callback fired when the Menu has entered.
   * @deprecated Use the `TransitionProps` prop instead.
   */
  onEntered: (0, _deprecatedPropType.default)(_propTypes.default.func, 'Use the `TransitionProps` prop instead.'),

  /**
   * Callback fired when the Menu is entering.
   * @deprecated Use the `TransitionProps` prop instead.
   */
  onEntering: (0, _deprecatedPropType.default)(_propTypes.default.func, 'Use the `TransitionProps` prop instead.'),

  /**
   * Callback fired before the Menu exits.
   * @deprecated Use the `TransitionProps` prop instead.
   */
  onExit: (0, _deprecatedPropType.default)(_propTypes.default.func, 'Use the `TransitionProps` prop instead.'),

  /**
   * Callback fired when the Menu has exited.
   * @deprecated Use the `TransitionProps` prop instead.
   */
  onExited: (0, _deprecatedPropType.default)(_propTypes.default.func, 'Use the `TransitionProps` prop instead.'),

  /**
   * Callback fired when the Menu is exiting.
   * @deprecated Use the `TransitionProps` prop instead.
   */
  onExiting: (0, _deprecatedPropType.default)(_propTypes.default.func, 'Use the `TransitionProps` prop instead.'),

  /**
   * If `true`, the menu is visible.
   */
  open: _propTypes.default.bool.isRequired,

  /**
   * @ignore
   */
  PaperProps: _propTypes.default.object,

  /**
   * `classes` prop applied to the [`Popover`](/api/popover/) element.
   */
  PopoverClasses: _propTypes.default.object,

  /**
   * The length of the transition in `ms`, or 'auto'
   */
  transitionDuration: _propTypes.default.oneOfType([_propTypes.default.oneOf(['auto']), _propTypes.default.number, _propTypes.default.shape({
    appear: _propTypes.default.number,
    enter: _propTypes.default.number,
    exit: _propTypes.default.number
  })]),

  /**
   * Props applied to the transition element.
   * By default, the element is based on this [`Transition`](http://reactcommunity.org/react-transition-group/transition) component.
   */
  TransitionProps: _propTypes.default.object,

  /**
   * The variant to use. Use `menu` to prevent selected items from impacting the initial focus
   * and the vertical alignment relative to the anchor element.
   */
  variant: _propTypes.default.oneOf(['menu', 'selectedMenu'])
} : void 0;

var _default = (0, _withStyles.default)(styles, {
  name: 'MuiMenu'
})(Menu);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Menu\\Menu.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Modal\\Modal.js", {"../Portal":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Portal\\index.js","../Unstable_TrapFocus":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Unstable_TrapFocus\\index.js","../styles/zIndex":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\zIndex.js","../utils/createChainedFunction":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\createChainedFunction.js","../utils/deprecatedPropType":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\deprecatedPropType.js","../utils/ownerDocument":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\ownerDocument.js","../utils/useEventCallback":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\useEventCallback.js","../utils/useForkRef":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\useForkRef.js","./ModalManager":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Modal\\ModalManager.js","./SimpleBackdrop":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Modal\\SimpleBackdrop.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@material-ui/styles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\index.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CModal%5CModal.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var React = _interopRequireWildcard(require("react"));

var ReactDOM = _interopRequireWildcard(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _styles = require("@material-ui/styles");

var _utils = require("@material-ui/utils");

var _deprecatedPropType = _interopRequireDefault(require("../utils/deprecatedPropType"));

var _ownerDocument = _interopRequireDefault(require("../utils/ownerDocument"));

var _Portal = _interopRequireDefault(require("../Portal"));

var _createChainedFunction = _interopRequireDefault(require("../utils/createChainedFunction"));

var _useForkRef = _interopRequireDefault(require("../utils/useForkRef"));

var _useEventCallback = _interopRequireDefault(require("../utils/useEventCallback"));

var _zIndex = _interopRequireDefault(require("../styles/zIndex"));

var _ModalManager = _interopRequireWildcard(require("./ModalManager"));

var _Unstable_TrapFocus = _interopRequireDefault(require("../Unstable_TrapFocus"));

var _SimpleBackdrop = _interopRequireDefault(require("./SimpleBackdrop"));

function getContainer(container) {
  container = typeof container === 'function' ? container() : container;
  return ReactDOM.findDOMNode(container);
}

function getHasTransition(props) {
  return props.children ? props.children.props.hasOwnProperty('in') : false;
} // A modal manager used to track and manage the state of open Modals.
// Modals don't open on the server so this won't conflict with concurrent requests.


var defaultManager = new _ModalManager.default();

var styles = function styles(theme) {
  return {
    /* Styles applied to the root element. */
    root: {
      position: 'fixed',
      zIndex: theme.zIndex.modal,
      right: 0,
      bottom: 0,
      top: 0,
      left: 0
    },

    /* Styles applied to the root element if the `Modal` has exited. */
    hidden: {
      visibility: 'hidden'
    }
  };
};
/**
 * Modal is a lower-level construct that is leveraged by the following components:
 *
 * - [Dialog](/api/dialog/)
 * - [Drawer](/api/drawer/)
 * - [Menu](/api/menu/)
 * - [Popover](/api/popover/)
 *
 * If you are creating a modal dialog, you probably want to use the [Dialog](/api/dialog/) component
 * rather than directly using Modal.
 *
 * This component shares many concepts with [react-overlays](https://react-bootstrap.github.io/react-overlays/#modals).
 */


exports.styles = styles;
var Modal = /*#__PURE__*/React.forwardRef(function Modal(inProps, ref) {
  var theme = (0, _styles.useTheme)();
  var props = (0, _styles.getThemeProps)({
    name: 'MuiModal',
    props: (0, _extends2.default)({}, inProps),
    theme: theme
  });
  var _props$BackdropCompon = props.BackdropComponent,
      BackdropComponent = _props$BackdropCompon === void 0 ? _SimpleBackdrop.default : _props$BackdropCompon,
      BackdropProps = props.BackdropProps,
      children = props.children,
      _props$closeAfterTran = props.closeAfterTransition,
      closeAfterTransition = _props$closeAfterTran === void 0 ? false : _props$closeAfterTran,
      container = props.container,
      _props$disableAutoFoc = props.disableAutoFocus,
      disableAutoFocus = _props$disableAutoFoc === void 0 ? false : _props$disableAutoFoc,
      _props$disableBackdro = props.disableBackdropClick,
      disableBackdropClick = _props$disableBackdro === void 0 ? false : _props$disableBackdro,
      _props$disableEnforce = props.disableEnforceFocus,
      disableEnforceFocus = _props$disableEnforce === void 0 ? false : _props$disableEnforce,
      _props$disableEscapeK = props.disableEscapeKeyDown,
      disableEscapeKeyDown = _props$disableEscapeK === void 0 ? false : _props$disableEscapeK,
      _props$disablePortal = props.disablePortal,
      disablePortal = _props$disablePortal === void 0 ? false : _props$disablePortal,
      _props$disableRestore = props.disableRestoreFocus,
      disableRestoreFocus = _props$disableRestore === void 0 ? false : _props$disableRestore,
      _props$disableScrollL = props.disableScrollLock,
      disableScrollLock = _props$disableScrollL === void 0 ? false : _props$disableScrollL,
      _props$hideBackdrop = props.hideBackdrop,
      hideBackdrop = _props$hideBackdrop === void 0 ? false : _props$hideBackdrop,
      _props$keepMounted = props.keepMounted,
      keepMounted = _props$keepMounted === void 0 ? false : _props$keepMounted,
      _props$manager = props.manager,
      manager = _props$manager === void 0 ? defaultManager : _props$manager,
      onBackdropClick = props.onBackdropClick,
      onClose = props.onClose,
      onEscapeKeyDown = props.onEscapeKeyDown,
      onRendered = props.onRendered,
      open = props.open,
      other = (0, _objectWithoutProperties2.default)(props, ["BackdropComponent", "BackdropProps", "children", "closeAfterTransition", "container", "disableAutoFocus", "disableBackdropClick", "disableEnforceFocus", "disableEscapeKeyDown", "disablePortal", "disableRestoreFocus", "disableScrollLock", "hideBackdrop", "keepMounted", "manager", "onBackdropClick", "onClose", "onEscapeKeyDown", "onRendered", "open"]);

  var _React$useState = React.useState(true),
      exited = _React$useState[0],
      setExited = _React$useState[1];

  var modal = React.useRef({});
  var mountNodeRef = React.useRef(null);
  var modalRef = React.useRef(null);
  var handleRef = (0, _useForkRef.default)(modalRef, ref);
  var hasTransition = getHasTransition(props);

  var getDoc = function getDoc() {
    return (0, _ownerDocument.default)(mountNodeRef.current);
  };

  var getModal = function getModal() {
    modal.current.modalRef = modalRef.current;
    modal.current.mountNode = mountNodeRef.current;
    return modal.current;
  };

  var handleMounted = function handleMounted() {
    manager.mount(getModal(), {
      disableScrollLock: disableScrollLock
    }); // Fix a bug on Chrome where the scroll isn't initially 0.

    modalRef.current.scrollTop = 0;
  };

  var handleOpen = (0, _useEventCallback.default)(function () {
    var resolvedContainer = getContainer(container) || getDoc().body;
    manager.add(getModal(), resolvedContainer); // The element was already mounted.

    if (modalRef.current) {
      handleMounted();
    }
  });
  var isTopModal = React.useCallback(function () {
    return manager.isTopModal(getModal());
  }, [manager]);
  var handlePortalRef = (0, _useEventCallback.default)(function (node) {
    mountNodeRef.current = node;

    if (!node) {
      return;
    }

    if (onRendered) {
      onRendered();
    }

    if (open && isTopModal()) {
      handleMounted();
    } else {
      (0, _ModalManager.ariaHidden)(modalRef.current, true);
    }
  });
  var handleClose = React.useCallback(function () {
    manager.remove(getModal());
  }, [manager]);
  React.useEffect(function () {
    return function () {
      handleClose();
    };
  }, [handleClose]);
  React.useEffect(function () {
    if (open) {
      handleOpen();
    } else if (!hasTransition || !closeAfterTransition) {
      handleClose();
    }
  }, [open, handleClose, hasTransition, closeAfterTransition, handleOpen]);

  if (!keepMounted && !open && (!hasTransition || exited)) {
    return null;
  }

  var handleEnter = function handleEnter() {
    setExited(false);
  };

  var handleExited = function handleExited() {
    setExited(true);

    if (closeAfterTransition) {
      handleClose();
    }
  };

  var handleBackdropClick = function handleBackdropClick(event) {
    if (event.target !== event.currentTarget) {
      return;
    }

    if (onBackdropClick) {
      onBackdropClick(event);
    }

    if (!disableBackdropClick && onClose) {
      onClose(event, 'backdropClick');
    }
  };

  var handleKeyDown = function handleKeyDown(event) {
    // The handler doesn't take event.defaultPrevented into account:
    //
    // event.preventDefault() is meant to stop default behaviours like
    // clicking a checkbox to check it, hitting a button to submit a form,
    // and hitting left arrow to move the cursor in a text input etc.
    // Only special HTML elements have these default behaviors.
    if (event.key !== 'Escape' || !isTopModal()) {
      return;
    }

    if (onEscapeKeyDown) {
      onEscapeKeyDown(event);
    }

    if (!disableEscapeKeyDown) {
      // Swallow the event, in case someone is listening for the escape key on the body.
      event.stopPropagation();

      if (onClose) {
        onClose(event, 'escapeKeyDown');
      }
    }
  };

  var inlineStyle = styles(theme || {
    zIndex: _zIndex.default
  });
  var childProps = {};

  if (children.props.tabIndex === undefined) {
    childProps.tabIndex = children.props.tabIndex || '-1';
  } // It's a Transition like component


  if (hasTransition) {
    childProps.onEnter = (0, _createChainedFunction.default)(handleEnter, children.props.onEnter);
    childProps.onExited = (0, _createChainedFunction.default)(handleExited, children.props.onExited);
  }

  return /*#__PURE__*/React.createElement(_Portal.default, {
    ref: handlePortalRef,
    container: container,
    disablePortal: disablePortal
  }, /*#__PURE__*/React.createElement("div", (0, _extends2.default)({
    ref: handleRef,
    onKeyDown: handleKeyDown,
    role: "presentation"
  }, other, {
    style: (0, _extends2.default)({}, inlineStyle.root, !open && exited ? inlineStyle.hidden : {}, other.style)
  }), hideBackdrop ? null : /*#__PURE__*/React.createElement(BackdropComponent, (0, _extends2.default)({
    open: open,
    onClick: handleBackdropClick
  }, BackdropProps)), /*#__PURE__*/React.createElement(_Unstable_TrapFocus.default, {
    disableEnforceFocus: disableEnforceFocus,
    disableAutoFocus: disableAutoFocus,
    disableRestoreFocus: disableRestoreFocus,
    getDoc: getDoc,
    isEnabled: isTopModal,
    open: open
  }, /*#__PURE__*/React.cloneElement(children, childProps))));
});
"development" !== "production" ? Modal.propTypes = {
  /**
   * A backdrop component. This prop enables custom backdrop rendering.
   */
  BackdropComponent: _propTypes.default.elementType,

  /**
   * Props applied to the [`Backdrop`](/api/backdrop/) element.
   */
  BackdropProps: _propTypes.default.object,

  /**
   * A single child content element.
   */
  children: _utils.elementAcceptingRef.isRequired,

  /**
   * When set to true the Modal waits until a nested Transition is completed before closing.
   */
  closeAfterTransition: _propTypes.default.bool,

  /**
   * A HTML element, component instance, or function that returns either.
   * The `container` will have the portal children appended to it.
   *
   * By default, it uses the body of the top-level document object,
   * so it's simply `document.body` most of the time.
   */
  container: _propTypes.default
  /* @typescript-to-proptypes-ignore */
  .oneOfType([_utils.HTMLElementType, _propTypes.default.instanceOf(React.Component), _propTypes.default.func]),

  /**
   * If `true`, the modal will not automatically shift focus to itself when it opens, and
   * replace it to the last focused element when it closes.
   * This also works correctly with any modal children that have the `disableAutoFocus` prop.
   *
   * Generally this should never be set to `true` as it makes the modal less
   * accessible to assistive technologies, like screen readers.
   */
  disableAutoFocus: _propTypes.default.bool,

  /**
   * If `true`, clicking the backdrop will not fire `onClose`.
   */
  disableBackdropClick: (0, _deprecatedPropType.default)(_propTypes.default.bool, 'Use the onClose prop with the `reason` argument to filter the `backdropClick` events.'),

  /**
   * If `true`, the modal will not prevent focus from leaving the modal while open.
   *
   * Generally this should never be set to `true` as it makes the modal less
   * accessible to assistive technologies, like screen readers.
   */
  disableEnforceFocus: _propTypes.default.bool,

  /**
   * If `true`, hitting escape will not fire `onClose`.
   */
  disableEscapeKeyDown: _propTypes.default.bool,

  /**
   * Disable the portal behavior.
   * The children stay within it's parent DOM hierarchy.
   */
  disablePortal: _propTypes.default.bool,

  /**
   * If `true`, the modal will not restore focus to previously focused element once
   * modal is hidden.
   */
  disableRestoreFocus: _propTypes.default.bool,

  /**
   * Disable the scroll lock behavior.
   */
  disableScrollLock: _propTypes.default.bool,

  /**
   * If `true`, the backdrop is not rendered.
   */
  hideBackdrop: _propTypes.default.bool,

  /**
   * Always keep the children in the DOM.
   * This prop can be useful in SEO situation or
   * when you want to maximize the responsiveness of the Modal.
   */
  keepMounted: _propTypes.default.bool,

  /**
   * @ignore
   */
  manager: _propTypes.default.object,

  /**
   * Callback fired when the backdrop is clicked.
   */
  onBackdropClick: (0, _deprecatedPropType.default)(_propTypes.default.func, 'Use the onClose prop with the `reason` argument to handle the `backdropClick` events.'),

  /**
   * Callback fired when the component requests to be closed.
   * The `reason` parameter can optionally be used to control the response to `onClose`.
   *
   * @param {object} event The event source of the callback.
   * @param {string} reason Can be: `"escapeKeyDown"`, `"backdropClick"`.
   */
  onClose: _propTypes.default.func,

  /**
   * Callback fired when the escape key is pressed,
   * `disableEscapeKeyDown` is false and the modal is in focus.
   */
  onEscapeKeyDown: (0, _deprecatedPropType.default)(_propTypes.default.func, 'Use the onClose prop with the `reason` argument to handle the `escapeKeyDown` events.'),

  /**
   * Callback fired once the children has been mounted into the `container`.
   * It signals that the `open={true}` prop took effect.
   *
   * This prop will be removed in v5, the ref can be used instead.
   */
  onRendered: (0, _deprecatedPropType.default)(_propTypes.default.func, 'Use the ref instead.'),

  /**
   * If `true`, the modal is open.
   */
  open: _propTypes.default.bool.isRequired
} : void 0;
var _default = Modal;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Modal\\Modal.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Modal\\ModalManager.js", {"../utils/getScrollbarSize":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\getScrollbarSize.js","../utils/ownerDocument":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\ownerDocument.js","../utils/ownerWindow":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\ownerWindow.js","@babel/runtime/helpers/classCallCheck":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\classCallCheck.js","@babel/runtime/helpers/createClass":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\createClass.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/toConsumableArray":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\toConsumableArray.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CModal%5CModalManager.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ariaHidden = ariaHidden;
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _getScrollbarSize = _interopRequireDefault(require("../utils/getScrollbarSize"));

var _ownerDocument = _interopRequireDefault(require("../utils/ownerDocument"));

var _ownerWindow = _interopRequireDefault(require("../utils/ownerWindow"));

// Is a vertical scrollbar displayed?
function isOverflowing(container) {
  var doc = (0, _ownerDocument.default)(container);

  if (doc.body === container) {
    return (0, _ownerWindow.default)(doc).innerWidth > doc.documentElement.clientWidth;
  }

  return container.scrollHeight > container.clientHeight;
}

function ariaHidden(node, show) {
  if (show) {
    node.setAttribute('aria-hidden', 'true');
  } else {
    node.removeAttribute('aria-hidden');
  }
}

function getPaddingRight(node) {
  return parseInt(window.getComputedStyle(node)['padding-right'], 10) || 0;
}

function ariaHiddenSiblings(container, mountNode, currentNode) {
  var nodesToExclude = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : [];
  var show = arguments.length > 4 ? arguments[4] : undefined;
  var blacklist = [mountNode, currentNode].concat((0, _toConsumableArray2.default)(nodesToExclude));
  var blacklistTagNames = ['TEMPLATE', 'SCRIPT', 'STYLE'];
  [].forEach.call(container.children, function (node) {
    if (node.nodeType === 1 && blacklist.indexOf(node) === -1 && blacklistTagNames.indexOf(node.tagName) === -1) {
      ariaHidden(node, show);
    }
  });
}

function findIndexOf(containerInfo, callback) {
  var idx = -1;
  containerInfo.some(function (item, index) {
    if (callback(item)) {
      idx = index;
      return true;
    }

    return false;
  });
  return idx;
}

function handleContainer(containerInfo, props) {
  var restoreStyle = [];
  var restorePaddings = [];
  var container = containerInfo.container;
  var fixedNodes;

  if (!props.disableScrollLock) {
    if (isOverflowing(container)) {
      // Compute the size before applying overflow hidden to avoid any scroll jumps.
      var scrollbarSize = (0, _getScrollbarSize.default)();
      restoreStyle.push({
        value: container.style.paddingRight,
        key: 'padding-right',
        el: container
      }); // Use computed style, here to get the real padding to add our scrollbar width.

      container.style['padding-right'] = "".concat(getPaddingRight(container) + scrollbarSize, "px"); // .mui-fixed is a global helper.

      fixedNodes = (0, _ownerDocument.default)(container).querySelectorAll('.mui-fixed');
      [].forEach.call(fixedNodes, function (node) {
        restorePaddings.push(node.style.paddingRight);
        node.style.paddingRight = "".concat(getPaddingRight(node) + scrollbarSize, "px");
      });
    } // Improve Gatsby support
    // https://css-tricks.com/snippets/css/force-vertical-scrollbar/


    var parent = container.parentElement;
    var scrollContainer = parent.nodeName === 'HTML' && window.getComputedStyle(parent)['overflow-y'] === 'scroll' ? parent : container; // Block the scroll even if no scrollbar is visible to account for mobile keyboard
    // screensize shrink.

    restoreStyle.push({
      value: scrollContainer.style.overflow,
      key: 'overflow',
      el: scrollContainer
    });
    scrollContainer.style.overflow = 'hidden';
  }

  var restore = function restore() {
    if (fixedNodes) {
      [].forEach.call(fixedNodes, function (node, i) {
        if (restorePaddings[i]) {
          node.style.paddingRight = restorePaddings[i];
        } else {
          node.style.removeProperty('padding-right');
        }
      });
    }

    restoreStyle.forEach(function (_ref) {
      var value = _ref.value,
          el = _ref.el,
          key = _ref.key;

      if (value) {
        el.style.setProperty(key, value);
      } else {
        el.style.removeProperty(key);
      }
    });
  };

  return restore;
}

function getHiddenSiblings(container) {
  var hiddenSiblings = [];
  [].forEach.call(container.children, function (node) {
    if (node.getAttribute && node.getAttribute('aria-hidden') === 'true') {
      hiddenSiblings.push(node);
    }
  });
  return hiddenSiblings;
}
/**
 * @ignore - do not document.
 *
 * Proper state management for containers and the modals in those containers.
 * Simplified, but inspired by react-overlay's ModalManager class.
 * Used by the Modal to ensure proper styling of containers.
 */


var ModalManager = /*#__PURE__*/function () {
  function ModalManager() {
    (0, _classCallCheck2.default)(this, ModalManager);
    // this.modals[modalIndex] = modal
    this.modals = []; // this.containers[containerIndex] = {
    //   modals: [],
    //   container,
    //   restore: null,
    // }

    this.containers = [];
  }

  (0, _createClass2.default)(ModalManager, [{
    key: "add",
    value: function add(modal, container) {
      var modalIndex = this.modals.indexOf(modal);

      if (modalIndex !== -1) {
        return modalIndex;
      }

      modalIndex = this.modals.length;
      this.modals.push(modal); // If the modal we are adding is already in the DOM.

      if (modal.modalRef) {
        ariaHidden(modal.modalRef, false);
      }

      var hiddenSiblingNodes = getHiddenSiblings(container);
      ariaHiddenSiblings(container, modal.mountNode, modal.modalRef, hiddenSiblingNodes, true);
      var containerIndex = findIndexOf(this.containers, function (item) {
        return item.container === container;
      });

      if (containerIndex !== -1) {
        this.containers[containerIndex].modals.push(modal);
        return modalIndex;
      }

      this.containers.push({
        modals: [modal],
        container: container,
        restore: null,
        hiddenSiblingNodes: hiddenSiblingNodes
      });
      return modalIndex;
    }
  }, {
    key: "mount",
    value: function mount(modal, props) {
      var containerIndex = findIndexOf(this.containers, function (item) {
        return item.modals.indexOf(modal) !== -1;
      });
      var containerInfo = this.containers[containerIndex];

      if (!containerInfo.restore) {
        containerInfo.restore = handleContainer(containerInfo, props);
      }
    }
  }, {
    key: "remove",
    value: function remove(modal) {
      var modalIndex = this.modals.indexOf(modal);

      if (modalIndex === -1) {
        return modalIndex;
      }

      var containerIndex = findIndexOf(this.containers, function (item) {
        return item.modals.indexOf(modal) !== -1;
      });
      var containerInfo = this.containers[containerIndex];
      containerInfo.modals.splice(containerInfo.modals.indexOf(modal), 1);
      this.modals.splice(modalIndex, 1); // If that was the last modal in a container, clean up the container.

      if (containerInfo.modals.length === 0) {
        // The modal might be closed before it had the chance to be mounted in the DOM.
        if (containerInfo.restore) {
          containerInfo.restore();
        }

        if (modal.modalRef) {
          // In case the modal wasn't in the DOM yet.
          ariaHidden(modal.modalRef, true);
        }

        ariaHiddenSiblings(containerInfo.container, modal.mountNode, modal.modalRef, containerInfo.hiddenSiblingNodes, false);
        this.containers.splice(containerIndex, 1);
      } else {
        // Otherwise make sure the next top modal is visible to a screen reader.
        var nextTop = containerInfo.modals[containerInfo.modals.length - 1]; // as soon as a modal is adding its modalRef is undefined. it can't set
        // aria-hidden because the dom element doesn't exist either
        // when modal was unmounted before modalRef gets null

        if (nextTop.modalRef) {
          ariaHidden(nextTop.modalRef, false);
        }
      }

      return modalIndex;
    }
  }, {
    key: "isTopModal",
    value: function isTopModal(modal) {
      return this.modals.length > 0 && this.modals[this.modals.length - 1] === modal;
    }
  }]);
  return ModalManager;
}();

exports.default = ModalManager;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Modal\\ModalManager.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Modal\\SimpleBackdrop.js", {"@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CModal%5CSimpleBackdrop.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var styles = {
  /* Styles applied to the root element. */
  root: {
    zIndex: -1,
    position: 'fixed',
    right: 0,
    bottom: 0,
    top: 0,
    left: 0,
    backgroundColor: 'rgba(0, 0, 0, 0.5)',
    WebkitTapHighlightColor: 'transparent'
  },

  /* Styles applied to the root element if `invisible={true}`. */
  invisible: {
    backgroundColor: 'transparent'
  }
};
/**
 * @ignore - internal component.
 */

exports.styles = styles;
var SimpleBackdrop = /*#__PURE__*/React.forwardRef(function SimpleBackdrop(props, ref) {
  var _props$invisible = props.invisible,
      invisible = _props$invisible === void 0 ? false : _props$invisible,
      open = props.open,
      other = (0, _objectWithoutProperties2.default)(props, ["invisible", "open"]);
  return open ? /*#__PURE__*/React.createElement("div", (0, _extends2.default)({
    "aria-hidden": true,
    ref: ref
  }, other, {
    style: (0, _extends2.default)({}, styles.root, invisible ? styles.invisible : {}, other.style)
  })) : null;
});
"development" !== "production" ? SimpleBackdrop.propTypes = {
  /**
   * If `true`, the backdrop is invisible.
   * It can be used when rendering a popover or a custom select component.
   */
  invisible: _propTypes.default.bool,

  /**
   * If `true`, the backdrop is open.
   */
  open: _propTypes.default.bool.isRequired
} : void 0;
var _default = SimpleBackdrop;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Modal\\SimpleBackdrop.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Modal\\index.js", {"./Modal":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Modal\\Modal.js","./ModalManager":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Modal\\ModalManager.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CModal%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _Modal.default;
  }
});
Object.defineProperty(exports, "ModalManager", {
  enumerable: true,
  get: function get() {
    return _ModalManager.default;
  }
});

var _Modal = _interopRequireDefault(require("./Modal"));

var _ModalManager = _interopRequireDefault(require("./ModalManager"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Modal\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\NativeSelect\\NativeSelect.js", {"../FormControl/formControlState":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\formControlState.js","../FormControl/useFormControl":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\useFormControl.js","../Input":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Input\\index.js","../internal/svg-icons/ArrowDropDown":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\internal\\svg-icons\\ArrowDropDown.js","../styles/withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withStyles.js","./NativeSelectInput":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\NativeSelect\\NativeSelectInput.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CNativeSelect%5CNativeSelect.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _NativeSelectInput = _interopRequireDefault(require("./NativeSelectInput"));

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var _formControlState = _interopRequireDefault(require("../FormControl/formControlState"));

var _useFormControl = _interopRequireDefault(require("../FormControl/useFormControl"));

var _ArrowDropDown = _interopRequireDefault(require("../internal/svg-icons/ArrowDropDown"));

var _Input = _interopRequireDefault(require("../Input"));

var styles = function styles(theme) {
  return {
    /* Styles applied to the select component `root` class. */
    root: {},

    /* Styles applied to the select component `select` class. */
    select: {
      '-moz-appearance': 'none',
      // Reset
      '-webkit-appearance': 'none',
      // Reset
      // When interacting quickly, the text can end up selected.
      // Native select can't be selected either.
      userSelect: 'none',
      borderRadius: 0,
      // Reset
      minWidth: 16,
      // So it doesn't collapse.
      cursor: 'pointer',
      '&:focus': {
        // Show that it's not an text input
        backgroundColor: theme.palette.type === 'light' ? 'rgba(0, 0, 0, 0.05)' : 'rgba(255, 255, 255, 0.05)',
        borderRadius: 0 // Reset Chrome style

      },
      // Remove IE 11 arrow
      '&::-ms-expand': {
        display: 'none'
      },
      '&$disabled': {
        cursor: 'default'
      },
      '&[multiple]': {
        height: 'auto'
      },
      '&:not([multiple]) option, &:not([multiple]) optgroup': {
        backgroundColor: theme.palette.background.paper
      },
      '&&': {
        paddingRight: 24
      }
    },

    /* Styles applied to the select component if `variant="filled"`. */
    filled: {
      '&&': {
        paddingRight: 32
      }
    },

    /* Styles applied to the select component if `variant="outlined"`. */
    outlined: {
      borderRadius: theme.shape.borderRadius,
      '&&': {
        paddingRight: 32
      }
    },

    /* Styles applied to the select component `selectMenu` class. */
    selectMenu: {
      height: 'auto',
      // Resets for multpile select with chips
      minHeight: '1.1876em',
      // Required for select\text-field height consistency
      textOverflow: 'ellipsis',
      whiteSpace: 'nowrap',
      overflow: 'hidden'
    },

    /* Pseudo-class applied to the select component `disabled` class. */
    disabled: {},

    /* Styles applied to the icon component. */
    icon: {
      // We use a position absolute over a flexbox in order to forward the pointer events
      // to the input and to support wrapping tags..
      position: 'absolute',
      right: 0,
      top: 'calc(50% - 12px)',
      // Center vertically
      pointerEvents: 'none',
      // Don't block pointer events on the select under the icon.
      color: theme.palette.action.active,
      '&$disabled': {
        color: theme.palette.action.disabled
      }
    },

    /* Styles applied to the icon component if the popup is open. */
    iconOpen: {
      transform: 'rotate(180deg)'
    },

    /* Styles applied to the icon component if `variant="filled"`. */
    iconFilled: {
      right: 7
    },

    /* Styles applied to the icon component if `variant="outlined"`. */
    iconOutlined: {
      right: 7
    },

    /* Styles applied to the underlying native input component. */
    nativeInput: {
      bottom: 0,
      left: 0,
      position: 'absolute',
      opacity: 0,
      pointerEvents: 'none',
      width: '100%'
    }
  };
};

exports.styles = styles;
var defaultInput = /*#__PURE__*/React.createElement(_Input.default, null);
/**
 * An alternative to `<Select native />` with a much smaller bundle size footprint.
 */

var NativeSelect = /*#__PURE__*/React.forwardRef(function NativeSelect(props, ref) {
  var children = props.children,
      classes = props.classes,
      _props$IconComponent = props.IconComponent,
      IconComponent = _props$IconComponent === void 0 ? _ArrowDropDown.default : _props$IconComponent,
      _props$input = props.input,
      input = _props$input === void 0 ? defaultInput : _props$input,
      inputProps = props.inputProps,
      variant = props.variant,
      other = (0, _objectWithoutProperties2.default)(props, ["children", "classes", "IconComponent", "input", "inputProps", "variant"]);
  var muiFormControl = (0, _useFormControl.default)();
  var fcs = (0, _formControlState.default)({
    props: props,
    muiFormControl: muiFormControl,
    states: ['variant']
  });
  return /*#__PURE__*/React.cloneElement(input, (0, _extends2.default)({
    // Most of the logic is implemented in `NativeSelectInput`.
    // The `Select` component is a simple API wrapper to expose something better to play with.
    inputComponent: _NativeSelectInput.default,
    inputProps: (0, _extends2.default)({
      children: children,
      classes: classes,
      IconComponent: IconComponent,
      variant: fcs.variant,
      type: undefined
    }, inputProps, input ? input.props.inputProps : {}),
    ref: ref
  }, other));
});
"development" !== "production" ? NativeSelect.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * The option elements to populate the select with.
   * Can be some `<option>` elements.
   */
  children: _propTypes.default.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object,

  /**
   * The icon that displays the arrow.
   */
  IconComponent: _propTypes.default.elementType,

  /**
   * An `Input` element; does not have to be a material-ui specific `Input`.
   */
  input: _propTypes.default.element,

  /**
   * Attributes applied to the `select` element.
   */
  inputProps: _propTypes.default.object,

  /**
   * Callback function fired when a menu item is selected.
   *
   * @param {object} event The event source of the callback.
   * You can pull out the new value by accessing `event.target.value` (string).
   */
  onChange: _propTypes.default.func,

  /**
   * The input value. The DOM API casts this to a string.
   */
  value: _propTypes.default.any,

  /**
   * The variant to use.
   */
  variant: _propTypes.default.oneOf(['filled', 'outlined', 'standard'])
} : void 0;
NativeSelect.muiName = 'Select';

var _default = (0, _withStyles.default)(styles, {
  name: 'MuiNativeSelect'
})(NativeSelect);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\NativeSelect\\NativeSelect.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\NativeSelect\\NativeSelectInput.js", {"../utils/capitalize":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\capitalize.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js","clsx":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\node_modules\\clsx\\dist\\clsx.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CNativeSelect%5CNativeSelectInput.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _utils = require("@material-ui/utils");

var _capitalize = _interopRequireDefault(require("../utils/capitalize"));

/**
 * @ignore - internal component.
 */
var NativeSelectInput = /*#__PURE__*/React.forwardRef(function NativeSelectInput(props, ref) {
  var classes = props.classes,
      className = props.className,
      disabled = props.disabled,
      IconComponent = props.IconComponent,
      inputRef = props.inputRef,
      _props$variant = props.variant,
      variant = _props$variant === void 0 ? 'standard' : _props$variant,
      other = (0, _objectWithoutProperties2.default)(props, ["classes", "className", "disabled", "IconComponent", "inputRef", "variant"]);
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("select", (0, _extends2.default)({
    className: (0, _clsx.default)(classes.root, // TODO v5: merge root and select
    classes.select, classes[variant], className, disabled && classes.disabled),
    disabled: disabled,
    ref: inputRef || ref
  }, other)), props.multiple ? null : /*#__PURE__*/React.createElement(IconComponent, {
    className: (0, _clsx.default)(classes.icon, classes["icon".concat((0, _capitalize.default)(variant))], disabled && classes.disabled)
  }));
});
"development" !== "production" ? NativeSelectInput.propTypes = {
  /**
   * The option elements to populate the select with.
   * Can be some `<option>` elements.
   */
  children: _propTypes.default.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object.isRequired,

  /**
   * The CSS class name of the select element.
   */
  className: _propTypes.default.string,

  /**
   * If `true`, the select will be disabled.
   */
  disabled: _propTypes.default.bool,

  /**
   * The icon that displays the arrow.
   */
  IconComponent: _propTypes.default.elementType.isRequired,

  /**
   * Use that prop to pass a ref to the native select element.
   * @deprecated
   */
  inputRef: _utils.refType,

  /**
   * @ignore
   */
  multiple: _propTypes.default.bool,

  /**
   * Name attribute of the `select` or hidden `input` element.
   */
  name: _propTypes.default.string,

  /**
   * Callback function fired when a menu item is selected.
   *
   * @param {object} event The event source of the callback.
   * You can pull out the new value by accessing `event.target.value` (string).
   */
  onChange: _propTypes.default.func,

  /**
   * The input value.
   */
  value: _propTypes.default.any,

  /**
   * The variant to use.
   */
  variant: _propTypes.default.oneOf(['standard', 'outlined', 'filled'])
} : void 0;
var _default = NativeSelectInput;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\NativeSelect\\NativeSelectInput.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\OutlinedInput\\NotchedOutline.js", {"../styles/useTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\useTheme.js","../styles/withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withStyles.js","../utils/capitalize":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\capitalize.js","@babel/runtime/helpers/defineProperty":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\defineProperty.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","clsx":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\node_modules\\clsx\\dist\\clsx.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5COutlinedInput%5CNotchedOutline.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _extends3 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var _useTheme = _interopRequireDefault(require("../styles/useTheme"));

var _capitalize = _interopRequireDefault(require("../utils/capitalize"));

var styles = function styles(theme) {
  return {
    /* Styles applied to the root element. */
    root: {
      position: 'absolute',
      bottom: 0,
      right: 0,
      top: -5,
      left: 0,
      margin: 0,
      padding: '0 8px',
      pointerEvents: 'none',
      borderRadius: 'inherit',
      borderStyle: 'solid',
      borderWidth: 1,
      overflow: 'hidden'
    },

    /* Styles applied to the legend element when `labelWidth` is provided. */
    legend: {
      textAlign: 'left',
      padding: 0,
      lineHeight: '11px',
      // sync with `height` in `legend` styles
      transition: theme.transitions.create('width', {
        duration: 150,
        easing: theme.transitions.easing.easeOut
      })
    },

    /* Styles applied to the legend element. */
    legendLabelled: {
      display: 'block',
      width: 'auto',
      textAlign: 'left',
      padding: 0,
      height: 11,
      // sync with `lineHeight` in `legend` styles
      fontSize: '0.75em',
      visibility: 'hidden',
      maxWidth: 0.01,
      transition: theme.transitions.create('max-width', {
        duration: 50,
        easing: theme.transitions.easing.easeOut
      }),
      '& > span': {
        paddingLeft: 5,
        paddingRight: 5,
        display: 'inline-block'
      }
    },

    /* Styles applied to the legend element is notched. */
    legendNotched: {
      maxWidth: 1000,
      transition: theme.transitions.create('max-width', {
        duration: 100,
        easing: theme.transitions.easing.easeOut,
        delay: 50
      })
    }
  };
};
/**
 * @ignore - internal component.
 */


exports.styles = styles;
var NotchedOutline = /*#__PURE__*/React.forwardRef(function NotchedOutline(props, ref) {
  var children = props.children,
      classes = props.classes,
      className = props.className,
      label = props.label,
      labelWidthProp = props.labelWidth,
      notched = props.notched,
      style = props.style,
      other = (0, _objectWithoutProperties2.default)(props, ["children", "classes", "className", "label", "labelWidth", "notched", "style"]);
  var theme = (0, _useTheme.default)();
  var align = theme.direction === 'rtl' ? 'right' : 'left';

  if (label !== undefined) {
    return /*#__PURE__*/React.createElement("fieldset", (0, _extends3.default)({
      "aria-hidden": true,
      className: (0, _clsx.default)(classes.root, className),
      ref: ref,
      style: style
    }, other), /*#__PURE__*/React.createElement("legend", {
      className: (0, _clsx.default)(classes.legendLabelled, notched && classes.legendNotched)
    }, label ? /*#__PURE__*/React.createElement("span", null, label) : /*#__PURE__*/React.createElement("span", {
      dangerouslySetInnerHTML: {
        __html: '&#8203;'
      }
    })));
  }

  var labelWidth = labelWidthProp > 0 ? labelWidthProp * 0.75 + 8 : 0.01;
  return /*#__PURE__*/React.createElement("fieldset", (0, _extends3.default)({
    "aria-hidden": true,
    style: (0, _extends3.default)((0, _defineProperty2.default)({}, "padding".concat((0, _capitalize.default)(align)), 8), style),
    className: (0, _clsx.default)(classes.root, className),
    ref: ref
  }, other), /*#__PURE__*/React.createElement("legend", {
    className: classes.legend,
    style: {
      // IE 11: fieldset with legend does not render
      // a border radius. This maintains consistency
      // by always having a legend rendered
      width: notched ? labelWidth : 0.01
    }
  }, /*#__PURE__*/React.createElement("span", {
    dangerouslySetInnerHTML: {
      __html: '&#8203;'
    }
  })));
});
"development" !== "production" ? NotchedOutline.propTypes = {
  /**
   * The content of the component.
   */
  children: _propTypes.default.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object,

  /**
   * @ignore
   */
  className: _propTypes.default.string,

  /**
   * The label.
   */
  label: _propTypes.default.node,

  /**
   * The width of the label.
   */
  labelWidth: _propTypes.default.number.isRequired,

  /**
   * If `true`, the outline is notched to accommodate the label.
   */
  notched: _propTypes.default.bool.isRequired,

  /**
   * @ignore
   */
  style: _propTypes.default.object
} : void 0;

var _default = (0, _withStyles.default)(styles, {
  name: 'PrivateNotchedOutline'
})(NotchedOutline);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\OutlinedInput\\NotchedOutline.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\OutlinedInput\\OutlinedInput.js", {"../InputBase":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\InputBase\\index.js","../styles/withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withStyles.js","./NotchedOutline":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\OutlinedInput\\NotchedOutline.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js","clsx":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\node_modules\\clsx\\dist\\clsx.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5COutlinedInput%5COutlinedInput.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _utils = require("@material-ui/utils");

var _InputBase = _interopRequireDefault(require("../InputBase"));

var _NotchedOutline = _interopRequireDefault(require("./NotchedOutline"));

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var styles = function styles(theme) {
  var borderColor = theme.palette.type === 'light' ? 'rgba(0, 0, 0, 0.23)' : 'rgba(255, 255, 255, 0.23)';
  return {
    /* Styles applied to the root element. */
    root: {
      position: 'relative',
      borderRadius: theme.shape.borderRadius,
      '&:hover $notchedOutline': {
        borderColor: theme.palette.text.primary
      },
      // Reset on touch devices, it doesn't add specificity
      '@media (hover: none)': {
        '&:hover $notchedOutline': {
          borderColor: borderColor
        }
      },
      '&$focused $notchedOutline': {
        borderColor: theme.palette.primary.main,
        borderWidth: 2
      },
      '&$error $notchedOutline': {
        borderColor: theme.palette.error.main
      },
      '&$disabled $notchedOutline': {
        borderColor: theme.palette.action.disabled
      }
    },

    /* Styles applied to the root element if the color is secondary. */
    colorSecondary: {
      '&$focused $notchedOutline': {
        borderColor: theme.palette.secondary.main
      }
    },

    /* Styles applied to the root element if the component is focused. */
    focused: {},

    /* Styles applied to the root element if `disabled={true}`. */
    disabled: {},

    /* Styles applied to the root element if `startAdornment` is provided. */
    adornedStart: {
      paddingLeft: 14
    },

    /* Styles applied to the root element if `endAdornment` is provided. */
    adornedEnd: {
      paddingRight: 14
    },

    /* Pseudo-class applied to the root element if `error={true}`. */
    error: {},

    /* Styles applied to the `input` element if `margin="dense"`. */
    marginDense: {},

    /* Styles applied to the root element if `multiline={true}`. */
    multiline: {
      padding: '18.5px 14px',
      '&$marginDense': {
        paddingTop: 10.5,
        paddingBottom: 10.5
      }
    },

    /* Styles applied to the `NotchedOutline` element. */
    notchedOutline: {
      borderColor: borderColor
    },

    /* Styles applied to the `input` element. */
    input: {
      padding: '18.5px 14px',
      '&:-webkit-autofill': {
        WebkitBoxShadow: theme.palette.type === 'light' ? null : '0 0 0 100px #266798 inset',
        WebkitTextFillColor: theme.palette.type === 'light' ? null : '#fff',
        caretColor: theme.palette.type === 'light' ? null : '#fff',
        borderRadius: 'inherit'
      }
    },

    /* Styles applied to the `input` element if `margin="dense"`. */
    inputMarginDense: {
      paddingTop: 10.5,
      paddingBottom: 10.5
    },

    /* Styles applied to the `input` element if `multiline={true}`. */
    inputMultiline: {
      padding: 0
    },

    /* Styles applied to the `input` element if `startAdornment` is provided. */
    inputAdornedStart: {
      paddingLeft: 0
    },

    /* Styles applied to the `input` element if `endAdornment` is provided. */
    inputAdornedEnd: {
      paddingRight: 0
    }
  };
};

exports.styles = styles;
var OutlinedInput = /*#__PURE__*/React.forwardRef(function OutlinedInput(props, ref) {
  var classes = props.classes,
      _props$fullWidth = props.fullWidth,
      fullWidth = _props$fullWidth === void 0 ? false : _props$fullWidth,
      _props$inputComponent = props.inputComponent,
      inputComponent = _props$inputComponent === void 0 ? 'input' : _props$inputComponent,
      label = props.label,
      _props$labelWidth = props.labelWidth,
      labelWidth = _props$labelWidth === void 0 ? 0 : _props$labelWidth,
      _props$multiline = props.multiline,
      multiline = _props$multiline === void 0 ? false : _props$multiline,
      notched = props.notched,
      _props$type = props.type,
      type = _props$type === void 0 ? 'text' : _props$type,
      other = (0, _objectWithoutProperties2.default)(props, ["classes", "fullWidth", "inputComponent", "label", "labelWidth", "multiline", "notched", "type"]);
  return /*#__PURE__*/React.createElement(_InputBase.default, (0, _extends2.default)({
    renderSuffix: function renderSuffix(state) {
      return /*#__PURE__*/React.createElement(_NotchedOutline.default, {
        className: classes.notchedOutline,
        label: label,
        labelWidth: labelWidth,
        notched: typeof notched !== 'undefined' ? notched : Boolean(state.startAdornment || state.filled || state.focused)
      });
    },
    classes: (0, _extends2.default)({}, classes, {
      root: (0, _clsx.default)(classes.root, classes.underline),
      notchedOutline: null
    }),
    fullWidth: fullWidth,
    inputComponent: inputComponent,
    multiline: multiline,
    ref: ref,
    type: type
  }, other));
});
"development" !== "production" ? OutlinedInput.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * This prop helps users to fill forms faster, especially on mobile devices.
   * The name can be confusing, as it's more like an autofill.
   * You can learn more about it [following the specification](https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#autofill).
   */
  autoComplete: _propTypes.default.string,

  /**
   * If `true`, the `input` element will be focused during the first mount.
   */
  autoFocus: _propTypes.default.bool,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object,

  /**
   * The color of the component. It supports those theme colors that make sense for this component.
   */
  color: _propTypes.default.oneOf(['primary', 'secondary']),

  /**
   * The default `input` element value. Use when the component is not controlled.
   */
  defaultValue: _propTypes.default.any,

  /**
   * If `true`, the `input` element will be disabled.
   */
  disabled: _propTypes.default.bool,

  /**
   * End `InputAdornment` for this component.
   */
  endAdornment: _propTypes.default.node,

  /**
   * If `true`, the input will indicate an error. This is normally obtained via context from
   * FormControl.
   */
  error: _propTypes.default.bool,

  /**
   * If `true`, the input will take up the full width of its container.
   */
  fullWidth: _propTypes.default.bool,

  /**
   * The id of the `input` element.
   */
  id: _propTypes.default.string,

  /**
   * The component used for the `input` element.
   * Either a string to use a HTML element or a component.
   */
  inputComponent: _propTypes.default.elementType,

  /**
   * [Attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Attributes) applied to the `input` element.
   */
  inputProps: _propTypes.default.object,

  /**
   * Pass a ref to the `input` element.
   */
  inputRef: _utils.refType,

  /**
   * The label of the input. It is only used for layout. The actual labelling
   * is handled by `InputLabel`. If specified `labelWidth` is ignored.
   */
  label: _propTypes.default.node,

  /**
   * The width of the label. Is ignored if `label` is provided. Prefer `label`
   * if the input label appears with a strike through.
   */
  labelWidth: _propTypes.default.number,

  /**
   * If `dense`, will adjust vertical spacing. This is normally obtained via context from
   * FormControl.
   */
  margin: _propTypes.default.oneOf(['dense', 'none']),

  /**
   * Maximum number of rows to display when multiline option is set to true.
   */
  maxRows: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * If `true`, a textarea element will be rendered.
   */
  multiline: _propTypes.default.bool,

  /**
   * Name attribute of the `input` element.
   */
  name: _propTypes.default.string,

  /**
   * If `true`, the outline is notched to accommodate the label.
   */
  notched: _propTypes.default.bool,

  /**
   * Callback fired when the value is changed.
   *
   * @param {object} event The event source of the callback.
   * You can pull out the new value by accessing `event.target.value` (string).
   */
  onChange: _propTypes.default.func,

  /**
   * The short hint displayed in the input before the user enters a value.
   */
  placeholder: _propTypes.default.string,

  /**
   * It prevents the user from changing the value of the field
   * (not from interacting with the field).
   */
  readOnly: _propTypes.default.bool,

  /**
   * If `true`, the `input` element will be required.
   */
  required: _propTypes.default.bool,

  /**
   * Number of rows to display when multiline option is set to true.
   */
  rows: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * Start `InputAdornment` for this component.
   */
  startAdornment: _propTypes.default.node,

  /**
   * Type of the `input` element. It should be [a valid HTML5 input type](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Form_%3Cinput%3E_types).
   */
  type: _propTypes.default.string,

  /**
   * The value of the `input` element, required for a controlled component.
   */
  value: _propTypes.default.any
} : void 0;
OutlinedInput.muiName = 'Input';

var _default = (0, _withStyles.default)(styles, {
  name: 'MuiOutlinedInput'
})(OutlinedInput);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\OutlinedInput\\OutlinedInput.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\OutlinedInput\\index.js", {"./OutlinedInput":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\OutlinedInput\\OutlinedInput.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5COutlinedInput%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _OutlinedInput.default;
  }
});

var _OutlinedInput = _interopRequireDefault(require("./OutlinedInput"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\OutlinedInput\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Paper\\Paper.js", {"../styles/withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withStyles.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js","clsx":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\node_modules\\clsx\\dist\\clsx.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CPaper%5CPaper.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _utils = require("@material-ui/utils");

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var styles = function styles(theme) {
  var elevations = {};
  theme.shadows.forEach(function (shadow, index) {
    elevations["elevation".concat(index)] = {
      boxShadow: shadow
    };
  });
  return (0, _extends2.default)({
    /* Styles applied to the root element. */
    root: {
      backgroundColor: theme.palette.background.paper,
      color: theme.palette.text.primary,
      transition: theme.transitions.create('box-shadow')
    },

    /* Styles applied to the root element if `square={false}`. */
    rounded: {
      borderRadius: theme.shape.borderRadius
    },

    /* Styles applied to the root element if `variant="outlined"`. */
    outlined: {
      border: "1px solid ".concat(theme.palette.divider)
    }
  }, elevations);
};

exports.styles = styles;
var Paper = /*#__PURE__*/React.forwardRef(function Paper(props, ref) {
  var classes = props.classes,
      className = props.className,
      _props$component = props.component,
      Component = _props$component === void 0 ? 'div' : _props$component,
      _props$square = props.square,
      square = _props$square === void 0 ? false : _props$square,
      _props$elevation = props.elevation,
      elevation = _props$elevation === void 0 ? 1 : _props$elevation,
      _props$variant = props.variant,
      variant = _props$variant === void 0 ? 'elevation' : _props$variant,
      other = (0, _objectWithoutProperties2.default)(props, ["classes", "className", "component", "square", "elevation", "variant"]);
  return /*#__PURE__*/React.createElement(Component, (0, _extends2.default)({
    className: (0, _clsx.default)(classes.root, className, variant === 'outlined' ? classes.outlined : classes["elevation".concat(elevation)], !square && classes.rounded),
    ref: ref
  }, other));
});
"development" !== "production" ? Paper.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * The content of the component.
   */
  children: _propTypes.default.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object,

  /**
   * @ignore
   */
  className: _propTypes.default.string,

  /**
   * The component used for the root node.
   * Either a string to use a HTML element or a component.
   */
  component: _propTypes.default
  /* @typescript-to-proptypes-ignore */
  .elementType,

  /**
   * Shadow depth, corresponds to `dp` in the spec.
   * It accepts values between 0 and 24 inclusive.
   */
  elevation: (0, _utils.chainPropTypes)(_propTypes.default.number, function (props) {
    var classes = props.classes,
        elevation = props.elevation; // in case `withStyles` fails to inject we don't need this warning

    if (classes === undefined) {
      return null;
    }

    if (elevation != null && classes["elevation".concat(elevation)] === undefined) {
      return new Error("Material-UI: This elevation `".concat(elevation, "` is not implemented."));
    }

    return null;
  }),

  /**
   * If `true`, rounded corners are disabled.
   */
  square: _propTypes.default.bool,

  /**
   * The variant to use.
   */
  variant: _propTypes.default.oneOf(['elevation', 'outlined'])
} : void 0;

var _default = (0, _withStyles.default)(styles, {
  name: 'MuiPaper'
})(Paper);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Paper\\Paper.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Paper\\index.js", {"./Paper":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Paper\\Paper.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CPaper%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _Paper.default;
  }
});

var _Paper = _interopRequireDefault(require("./Paper"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Paper\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Popover\\Popover.js", {"../Grow":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Grow\\index.js","../Modal":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Modal\\index.js","../Paper":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Paper\\index.js","../styles/withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withStyles.js","../utils/createChainedFunction":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\createChainedFunction.js","../utils/debounce":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\debounce.js","../utils/deprecatedPropType":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\deprecatedPropType.js","../utils/ownerDocument":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\ownerDocument.js","../utils/ownerWindow":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\ownerWindow.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js","clsx":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\node_modules\\clsx\\dist\\clsx.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CPopover%5CPopover.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOffsetTop = getOffsetTop;
exports.getOffsetLeft = getOffsetLeft;
exports.default = exports.styles = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var ReactDOM = _interopRequireWildcard(require("react-dom"));

var _utils = require("@material-ui/utils");

var _debounce = _interopRequireDefault(require("../utils/debounce"));

var _clsx = _interopRequireDefault(require("clsx"));

var _ownerDocument = _interopRequireDefault(require("../utils/ownerDocument"));

var _ownerWindow = _interopRequireDefault(require("../utils/ownerWindow"));

var _createChainedFunction = _interopRequireDefault(require("../utils/createChainedFunction"));

var _deprecatedPropType = _interopRequireDefault(require("../utils/deprecatedPropType"));

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var _Modal = _interopRequireDefault(require("../Modal"));

var _Grow = _interopRequireDefault(require("../Grow"));

var _Paper = _interopRequireDefault(require("../Paper"));

function getOffsetTop(rect, vertical) {
  var offset = 0;

  if (typeof vertical === 'number') {
    offset = vertical;
  } else if (vertical === 'center') {
    offset = rect.height / 2;
  } else if (vertical === 'bottom') {
    offset = rect.height;
  }

  return offset;
}

function getOffsetLeft(rect, horizontal) {
  var offset = 0;

  if (typeof horizontal === 'number') {
    offset = horizontal;
  } else if (horizontal === 'center') {
    offset = rect.width / 2;
  } else if (horizontal === 'right') {
    offset = rect.width;
  }

  return offset;
}

function getTransformOriginValue(transformOrigin) {
  return [transformOrigin.horizontal, transformOrigin.vertical].map(function (n) {
    return typeof n === 'number' ? "".concat(n, "px") : n;
  }).join(' ');
} // Sum the scrollTop between two elements.


function getScrollParent(parent, child) {
  var element = child;
  var scrollTop = 0;

  while (element && element !== parent) {
    element = element.parentElement;
    scrollTop += element.scrollTop;
  }

  return scrollTop;
}

function getAnchorEl(anchorEl) {
  return typeof anchorEl === 'function' ? anchorEl() : anchorEl;
}

var styles = {
  /* Styles applied to the root element. */
  root: {},

  /* Styles applied to the `Paper` component. */
  paper: {
    position: 'absolute',
    overflowY: 'auto',
    overflowX: 'hidden',
    // So we see the popover when it's empty.
    // It's most likely on issue on userland.
    minWidth: 16,
    minHeight: 16,
    maxWidth: 'calc(100% - 32px)',
    maxHeight: 'calc(100% - 32px)',
    // We disable the focus ring for mouse, touch and keyboard users.
    outline: 0
  }
};
exports.styles = styles;
var Popover = /*#__PURE__*/React.forwardRef(function Popover(props, ref) {
  var action = props.action,
      anchorEl = props.anchorEl,
      _props$anchorOrigin = props.anchorOrigin,
      anchorOrigin = _props$anchorOrigin === void 0 ? {
    vertical: 'top',
    horizontal: 'left'
  } : _props$anchorOrigin,
      anchorPosition = props.anchorPosition,
      _props$anchorReferenc = props.anchorReference,
      anchorReference = _props$anchorReferenc === void 0 ? 'anchorEl' : _props$anchorReferenc,
      children = props.children,
      classes = props.classes,
      className = props.className,
      containerProp = props.container,
      _props$elevation = props.elevation,
      elevation = _props$elevation === void 0 ? 8 : _props$elevation,
      getContentAnchorEl = props.getContentAnchorEl,
      _props$marginThreshol = props.marginThreshold,
      marginThreshold = _props$marginThreshol === void 0 ? 16 : _props$marginThreshol,
      onEnter = props.onEnter,
      onEntered = props.onEntered,
      onEntering = props.onEntering,
      onExit = props.onExit,
      onExited = props.onExited,
      onExiting = props.onExiting,
      open = props.open,
      _props$PaperProps = props.PaperProps,
      PaperProps = _props$PaperProps === void 0 ? {} : _props$PaperProps,
      _props$transformOrigi = props.transformOrigin,
      transformOrigin = _props$transformOrigi === void 0 ? {
    vertical: 'top',
    horizontal: 'left'
  } : _props$transformOrigi,
      _props$TransitionComp = props.TransitionComponent,
      TransitionComponent = _props$TransitionComp === void 0 ? _Grow.default : _props$TransitionComp,
      _props$transitionDura = props.transitionDuration,
      transitionDurationProp = _props$transitionDura === void 0 ? 'auto' : _props$transitionDura,
      _props$TransitionProp = props.TransitionProps,
      TransitionProps = _props$TransitionProp === void 0 ? {} : _props$TransitionProp,
      other = (0, _objectWithoutProperties2.default)(props, ["action", "anchorEl", "anchorOrigin", "anchorPosition", "anchorReference", "children", "classes", "className", "container", "elevation", "getContentAnchorEl", "marginThreshold", "onEnter", "onEntered", "onEntering", "onExit", "onExited", "onExiting", "open", "PaperProps", "transformOrigin", "TransitionComponent", "transitionDuration", "TransitionProps"]);
  var paperRef = React.useRef(); // Returns the top/left offset of the position
  // to attach to on the anchor element (or body if none is provided)

  var getAnchorOffset = React.useCallback(function (contentAnchorOffset) {
    if (anchorReference === 'anchorPosition') {
      if ("development" !== 'production') {
        if (!anchorPosition) {
          console.error('Material-UI: You need to provide a `anchorPosition` prop when using ' + '<Popover anchorReference="anchorPosition" />.');
        }
      }

      return anchorPosition;
    }

    var resolvedAnchorEl = getAnchorEl(anchorEl); // If an anchor element wasn't provided, just use the parent body element of this Popover

    var anchorElement = resolvedAnchorEl && resolvedAnchorEl.nodeType === 1 ? resolvedAnchorEl : (0, _ownerDocument.default)(paperRef.current).body;
    var anchorRect = anchorElement.getBoundingClientRect();

    if ("development" !== 'production') {
      var box = anchorElement.getBoundingClientRect();

      if ("development" !== 'test' && box.top === 0 && box.left === 0 && box.right === 0 && box.bottom === 0) {
        console.warn(['Material-UI: The `anchorEl` prop provided to the component is invalid.', 'The anchor element should be part of the document layout.', "Make sure the element is present in the document or that it's not display none."].join('\n'));
      }
    }

    var anchorVertical = contentAnchorOffset === 0 ? anchorOrigin.vertical : 'center';
    return {
      top: anchorRect.top + getOffsetTop(anchorRect, anchorVertical),
      left: anchorRect.left + getOffsetLeft(anchorRect, anchorOrigin.horizontal)
    };
  }, [anchorEl, anchorOrigin.horizontal, anchorOrigin.vertical, anchorPosition, anchorReference]); // Returns the vertical offset of inner content to anchor the transform on if provided

  var getContentAnchorOffset = React.useCallback(function (element) {
    var contentAnchorOffset = 0;

    if (getContentAnchorEl && anchorReference === 'anchorEl') {
      var contentAnchorEl = getContentAnchorEl(element);

      if (contentAnchorEl && element.contains(contentAnchorEl)) {
        var scrollTop = getScrollParent(element, contentAnchorEl);
        contentAnchorOffset = contentAnchorEl.offsetTop + contentAnchorEl.clientHeight / 2 - scrollTop || 0;
      } // != the default value


      if ("development" !== 'production') {
        if (anchorOrigin.vertical !== 'top') {
          console.error(['Material-UI: You can not change the default `anchorOrigin.vertical` value ', 'when also providing the `getContentAnchorEl` prop to the popover component.', 'Only use one of the two props.', 'Set `getContentAnchorEl` to `null | undefined`' + ' or leave `anchorOrigin.vertical` unchanged.'].join('\n'));
        }
      }
    }

    return contentAnchorOffset;
  }, [anchorOrigin.vertical, anchorReference, getContentAnchorEl]); // Return the base transform origin using the element
  // and taking the content anchor offset into account if in use

  var getTransformOrigin = React.useCallback(function (elemRect) {
    var contentAnchorOffset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    return {
      vertical: getOffsetTop(elemRect, transformOrigin.vertical) + contentAnchorOffset,
      horizontal: getOffsetLeft(elemRect, transformOrigin.horizontal)
    };
  }, [transformOrigin.horizontal, transformOrigin.vertical]);
  var getPositioningStyle = React.useCallback(function (element) {
    // Check if the parent has requested anchoring on an inner content node
    var contentAnchorOffset = getContentAnchorOffset(element);
    var elemRect = {
      width: element.offsetWidth,
      height: element.offsetHeight
    }; // Get the transform origin point on the element itself

    var elemTransformOrigin = getTransformOrigin(elemRect, contentAnchorOffset);

    if (anchorReference === 'none') {
      return {
        top: null,
        left: null,
        transformOrigin: getTransformOriginValue(elemTransformOrigin)
      };
    } // Get the offset of of the anchoring element


    var anchorOffset = getAnchorOffset(contentAnchorOffset); // Calculate element positioning

    var top = anchorOffset.top - elemTransformOrigin.vertical;
    var left = anchorOffset.left - elemTransformOrigin.horizontal;
    var bottom = top + elemRect.height;
    var right = left + elemRect.width; // Use the parent window of the anchorEl if provided

    var containerWindow = (0, _ownerWindow.default)(getAnchorEl(anchorEl)); // Window thresholds taking required margin into account

    var heightThreshold = containerWindow.innerHeight - marginThreshold;
    var widthThreshold = containerWindow.innerWidth - marginThreshold; // Check if the vertical axis needs shifting

    if (top < marginThreshold) {
      var diff = top - marginThreshold;
      top -= diff;
      elemTransformOrigin.vertical += diff;
    } else if (bottom > heightThreshold) {
      var _diff = bottom - heightThreshold;

      top -= _diff;
      elemTransformOrigin.vertical += _diff;
    }

    if ("development" !== 'production') {
      if (elemRect.height > heightThreshold && elemRect.height && heightThreshold) {
        console.error(['Material-UI: The popover component is too tall.', "Some part of it can not be seen on the screen (".concat(elemRect.height - heightThreshold, "px)."), 'Please consider adding a `max-height` to improve the user-experience.'].join('\n'));
      }
    } // Check if the horizontal axis needs shifting


    if (left < marginThreshold) {
      var _diff2 = left - marginThreshold;

      left -= _diff2;
      elemTransformOrigin.horizontal += _diff2;
    } else if (right > widthThreshold) {
      var _diff3 = right - widthThreshold;

      left -= _diff3;
      elemTransformOrigin.horizontal += _diff3;
    }

    return {
      top: "".concat(Math.round(top), "px"),
      left: "".concat(Math.round(left), "px"),
      transformOrigin: getTransformOriginValue(elemTransformOrigin)
    };
  }, [anchorEl, anchorReference, getAnchorOffset, getContentAnchorOffset, getTransformOrigin, marginThreshold]);
  var setPositioningStyles = React.useCallback(function () {
    var element = paperRef.current;

    if (!element) {
      return;
    }

    var positioning = getPositioningStyle(element);

    if (positioning.top !== null) {
      element.style.top = positioning.top;
    }

    if (positioning.left !== null) {
      element.style.left = positioning.left;
    }

    element.style.transformOrigin = positioning.transformOrigin;
  }, [getPositioningStyle]);

  var handleEntering = function handleEntering(element, isAppearing) {
    if (onEntering) {
      onEntering(element, isAppearing);
    }

    setPositioningStyles();
  };

  var handlePaperRef = React.useCallback(function (instance) {
    // #StrictMode ready
    paperRef.current = ReactDOM.findDOMNode(instance);
  }, []);
  React.useEffect(function () {
    if (open) {
      setPositioningStyles();
    }
  });
  React.useImperativeHandle(action, function () {
    return open ? {
      updatePosition: function updatePosition() {
        setPositioningStyles();
      }
    } : null;
  }, [open, setPositioningStyles]);
  React.useEffect(function () {
    if (!open) {
      return undefined;
    }

    var handleResize = (0, _debounce.default)(function () {
      setPositioningStyles();
    });
    window.addEventListener('resize', handleResize);
    return function () {
      handleResize.clear();
      window.removeEventListener('resize', handleResize);
    };
  }, [open, setPositioningStyles]);
  var transitionDuration = transitionDurationProp;

  if (transitionDurationProp === 'auto' && !TransitionComponent.muiSupportAuto) {
    transitionDuration = undefined;
  } // If the container prop is provided, use that
  // If the anchorEl prop is provided, use its parent body element as the container
  // If neither are provided let the Modal take care of choosing the container


  var container = containerProp || (anchorEl ? (0, _ownerDocument.default)(getAnchorEl(anchorEl)).body : undefined);
  return /*#__PURE__*/React.createElement(_Modal.default, (0, _extends2.default)({
    container: container,
    open: open,
    ref: ref,
    BackdropProps: {
      invisible: true
    },
    className: (0, _clsx.default)(classes.root, className)
  }, other), /*#__PURE__*/React.createElement(TransitionComponent, (0, _extends2.default)({
    appear: true,
    in: open,
    onEnter: onEnter,
    onEntered: onEntered,
    onExit: onExit,
    onExited: onExited,
    onExiting: onExiting,
    timeout: transitionDuration
  }, TransitionProps, {
    onEntering: (0, _createChainedFunction.default)(handleEntering, TransitionProps.onEntering)
  }), /*#__PURE__*/React.createElement(_Paper.default, (0, _extends2.default)({
    elevation: elevation,
    ref: handlePaperRef
  }, PaperProps, {
    className: (0, _clsx.default)(classes.paper, PaperProps.className)
  }), children)));
});
"development" !== "production" ? Popover.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * A ref for imperative actions.
   * It currently only supports updatePosition() action.
   */
  action: _utils.refType,

  /**
   * A HTML element, or a function that returns it.
   * It's used to set the position of the popover.
   */
  anchorEl: (0, _utils.chainPropTypes)(_propTypes.default.oneOfType([_utils.HTMLElementType, _propTypes.default.func]), function (props) {
    if (props.open && (!props.anchorReference || props.anchorReference === 'anchorEl')) {
      var resolvedAnchorEl = getAnchorEl(props.anchorEl);

      if (resolvedAnchorEl && resolvedAnchorEl.nodeType === 1) {
        var box = resolvedAnchorEl.getBoundingClientRect();

        if ("development" !== 'test' && box.top === 0 && box.left === 0 && box.right === 0 && box.bottom === 0) {
          return new Error(['Material-UI: The `anchorEl` prop provided to the component is invalid.', 'The anchor element should be part of the document layout.', "Make sure the element is present in the document or that it's not display none."].join('\n'));
        }
      } else {
        return new Error(['Material-UI: The `anchorEl` prop provided to the component is invalid.', "It should be an Element instance but it's `".concat(resolvedAnchorEl, "` instead.")].join('\n'));
      }
    }

    return null;
  }),

  /**
   * This is the point on the anchor where the popover's
   * `anchorEl` will attach to. This is not used when the
   * anchorReference is 'anchorPosition'.
   *
   * Options:
   * vertical: [top, center, bottom];
   * horizontal: [left, center, right].
   */
  anchorOrigin: _propTypes.default.shape({
    horizontal: _propTypes.default.oneOfType([_propTypes.default.oneOf(['center', 'left', 'right']), _propTypes.default.number]).isRequired,
    vertical: _propTypes.default.oneOfType([_propTypes.default.oneOf(['bottom', 'center', 'top']), _propTypes.default.number]).isRequired
  }),

  /**
   * This is the position that may be used
   * to set the position of the popover.
   * The coordinates are relative to
   * the application's client area.
   */
  anchorPosition: _propTypes.default.shape({
    left: _propTypes.default.number.isRequired,
    top: _propTypes.default.number.isRequired
  }),

  /**
   * This determines which anchor prop to refer to to set
   * the position of the popover.
   */
  anchorReference: _propTypes.default.oneOf(['anchorEl', 'anchorPosition', 'none']),

  /**
   * The content of the component.
   */
  children: _propTypes.default.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object,

  /**
   * @ignore
   */
  className: _propTypes.default.string,

  /**
   * A HTML element, component instance, or function that returns either.
   * The `container` will passed to the Modal component.
   *
   * By default, it uses the body of the anchorEl's top-level document object,
   * so it's simply `document.body` most of the time.
   */
  container: _propTypes.default
  /* @typescript-to-proptypes-ignore */
  .oneOfType([_utils.HTMLElementType, _propTypes.default.instanceOf(React.Component), _propTypes.default.func]),

  /**
   * The elevation of the popover.
   */
  elevation: _propTypes.default.number,

  /**
   * This function is called in order to retrieve the content anchor element.
   * It's the opposite of the `anchorEl` prop.
   * The content anchor element should be an element inside the popover.
   * It's used to correctly scroll and set the position of the popover.
   * The positioning strategy tries to make the content anchor element just above the
   * anchor element.
   */
  getContentAnchorEl: _propTypes.default.func,

  /**
   * Specifies how close to the edge of the window the popover can appear.
   */
  marginThreshold: _propTypes.default.number,

  /**
   * Callback fired when the component requests to be closed.
   */
  onClose: _propTypes.default.func,

  /**
   * Callback fired before the component is entering.
   * @deprecated Use the `TransitionProps` prop instead.
   */
  onEnter: (0, _deprecatedPropType.default)(_propTypes.default.func, 'Use the `TransitionProps` prop instead.'),

  /**
   * Callback fired when the component has entered.
   * @deprecated Use the `TransitionProps` prop instead.
   */
  onEntered: (0, _deprecatedPropType.default)(_propTypes.default.func, 'Use the `TransitionProps` prop instead.'),

  /**
   * Callback fired when the component is entering.
   * @deprecated Use the `TransitionProps` prop instead.
   */
  onEntering: (0, _deprecatedPropType.default)(_propTypes.default.func, 'Use the `TransitionProps` prop instead.'),

  /**
   * Callback fired before the component is exiting.
   * @deprecated Use the `TransitionProps` prop instead.
   */
  onExit: (0, _deprecatedPropType.default)(_propTypes.default.func, 'Use the `TransitionProps` prop instead.'),

  /**
   * Callback fired when the component has exited.
   * @deprecated Use the `TransitionProps` prop instead.
   */
  onExited: (0, _deprecatedPropType.default)(_propTypes.default.func, 'Use the `TransitionProps` prop instead.'),

  /**
   * Callback fired when the component is exiting.
   * @deprecated Use the `TransitionProps` prop instead.
   */
  onExiting: (0, _deprecatedPropType.default)(_propTypes.default.func, 'Use the `TransitionProps` prop instead.'),

  /**
   * If `true`, the popover is visible.
   */
  open: _propTypes.default.bool.isRequired,

  /**
   * Props applied to the [`Paper`](/api/paper/) element.
   */
  PaperProps: _propTypes.default
  /* @typescript-to-proptypes-ignore */
  .shape({
    component: _utils.elementTypeAcceptingRef
  }),

  /**
   * This is the point on the popover which
   * will attach to the anchor's origin.
   *
   * Options:
   * vertical: [top, center, bottom, x(px)];
   * horizontal: [left, center, right, x(px)].
   */
  transformOrigin: _propTypes.default.shape({
    horizontal: _propTypes.default.oneOfType([_propTypes.default.oneOf(['center', 'left', 'right']), _propTypes.default.number]).isRequired,
    vertical: _propTypes.default.oneOfType([_propTypes.default.oneOf(['bottom', 'center', 'top']), _propTypes.default.number]).isRequired
  }),

  /**
   * The component used for the transition.
   * [Follow this guide](/components/transitions/#transitioncomponent-prop) to learn more about the requirements for this component.
   */
  TransitionComponent: _propTypes.default.elementType,

  /**
   * Set to 'auto' to automatically calculate transition time based on height.
   */
  transitionDuration: _propTypes.default.oneOfType([_propTypes.default.oneOf(['auto']), _propTypes.default.number, _propTypes.default.shape({
    appear: _propTypes.default.number,
    enter: _propTypes.default.number,
    exit: _propTypes.default.number
  })]),

  /**
   * Props applied to the [`Transition`](http://reactcommunity.org/react-transition-group/transition#Transition-props) element.
   */
  TransitionProps: _propTypes.default.object
} : void 0;

var _default = (0, _withStyles.default)(styles, {
  name: 'MuiPopover'
})(Popover);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Popover\\Popover.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Popover\\index.js", {"./Popover":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Popover\\Popover.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CPopover%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _Popover.default;
  }
});

var _Popover = _interopRequireDefault(require("./Popover"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Popover\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Popper\\Popper.js", {"../Portal":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Portal\\index.js","../utils/createChainedFunction":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\createChainedFunction.js","../utils/setRef":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\setRef.js","../utils/useForkRef":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\useForkRef.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@material-ui/styles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\index.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js","popper.js":"D:\\code\\v\\metamask-extension\\node_modules\\popper.js\\dist\\umd\\popper.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CPopper%5CPopper.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _popper = _interopRequireDefault(require("popper.js"));

var _utils = require("@material-ui/utils");

var _styles = require("@material-ui/styles");

var _Portal = _interopRequireDefault(require("../Portal"));

var _createChainedFunction = _interopRequireDefault(require("../utils/createChainedFunction"));

var _setRef = _interopRequireDefault(require("../utils/setRef"));

var _useForkRef = _interopRequireDefault(require("../utils/useForkRef"));

function flipPlacement(placement, theme) {
  var direction = theme && theme.direction || 'ltr';

  if (direction === 'ltr') {
    return placement;
  }

  switch (placement) {
    case 'bottom-end':
      return 'bottom-start';

    case 'bottom-start':
      return 'bottom-end';

    case 'top-end':
      return 'top-start';

    case 'top-start':
      return 'top-end';

    default:
      return placement;
  }
}

function getAnchorEl(anchorEl) {
  return typeof anchorEl === 'function' ? anchorEl() : anchorEl;
}

var useEnhancedEffect = typeof window !== 'undefined' ? React.useLayoutEffect : React.useEffect;
var defaultPopperOptions = {};
/**
 * Poppers rely on the 3rd party library [Popper.js](https://popper.js.org/docs/v1/) for positioning.
 */

var Popper = /*#__PURE__*/React.forwardRef(function Popper(props, ref) {
  var anchorEl = props.anchorEl,
      children = props.children,
      container = props.container,
      _props$disablePortal = props.disablePortal,
      disablePortal = _props$disablePortal === void 0 ? false : _props$disablePortal,
      _props$keepMounted = props.keepMounted,
      keepMounted = _props$keepMounted === void 0 ? false : _props$keepMounted,
      modifiers = props.modifiers,
      open = props.open,
      _props$placement = props.placement,
      initialPlacement = _props$placement === void 0 ? 'bottom' : _props$placement,
      _props$popperOptions = props.popperOptions,
      popperOptions = _props$popperOptions === void 0 ? defaultPopperOptions : _props$popperOptions,
      popperRefProp = props.popperRef,
      style = props.style,
      _props$transition = props.transition,
      transition = _props$transition === void 0 ? false : _props$transition,
      other = (0, _objectWithoutProperties2.default)(props, ["anchorEl", "children", "container", "disablePortal", "keepMounted", "modifiers", "open", "placement", "popperOptions", "popperRef", "style", "transition"]);
  var tooltipRef = React.useRef(null);
  var ownRef = (0, _useForkRef.default)(tooltipRef, ref);
  var popperRef = React.useRef(null);
  var handlePopperRef = (0, _useForkRef.default)(popperRef, popperRefProp);
  var handlePopperRefRef = React.useRef(handlePopperRef);
  useEnhancedEffect(function () {
    handlePopperRefRef.current = handlePopperRef;
  }, [handlePopperRef]);
  React.useImperativeHandle(popperRefProp, function () {
    return popperRef.current;
  }, []);

  var _React$useState = React.useState(true),
      exited = _React$useState[0],
      setExited = _React$useState[1];

  var theme = (0, _styles.useTheme)();
  var rtlPlacement = flipPlacement(initialPlacement, theme);
  /**
   * placement initialized from prop but can change during lifetime if modifiers.flip.
   * modifiers.flip is essentially a flip for controlled/uncontrolled behavior
   */

  var _React$useState2 = React.useState(rtlPlacement),
      placement = _React$useState2[0],
      setPlacement = _React$useState2[1];

  React.useEffect(function () {
    if (popperRef.current) {
      popperRef.current.update();
    }
  });
  var handleOpen = React.useCallback(function () {
    if (!tooltipRef.current || !anchorEl || !open) {
      return;
    }

    if (popperRef.current) {
      popperRef.current.destroy();
      handlePopperRefRef.current(null);
    }

    var handlePopperUpdate = function handlePopperUpdate(data) {
      setPlacement(data.placement);
    };

    var resolvedAnchorEl = getAnchorEl(anchorEl);

    if ("development" !== 'production') {
      if (resolvedAnchorEl && resolvedAnchorEl.nodeType === 1) {
        var box = resolvedAnchorEl.getBoundingClientRect();

        if ("development" !== 'test' && box.top === 0 && box.left === 0 && box.right === 0 && box.bottom === 0) {
          console.warn(['Material-UI: The `anchorEl` prop provided to the component is invalid.', 'The anchor element should be part of the document layout.', "Make sure the element is present in the document or that it's not display none."].join('\n'));
        }
      }
    }

    var popper = new _popper.default(getAnchorEl(anchorEl), tooltipRef.current, (0, _extends2.default)({
      placement: rtlPlacement
    }, popperOptions, {
      modifiers: (0, _extends2.default)({}, disablePortal ? {} : {
        // It's using scrollParent by default, we can use the viewport when using a portal.
        preventOverflow: {
          boundariesElement: 'window'
        }
      }, modifiers, popperOptions.modifiers),
      // We could have been using a custom modifier like react-popper is doing.
      // But it seems this is the best public API for this use case.
      onCreate: (0, _createChainedFunction.default)(handlePopperUpdate, popperOptions.onCreate),
      onUpdate: (0, _createChainedFunction.default)(handlePopperUpdate, popperOptions.onUpdate)
    }));
    handlePopperRefRef.current(popper);
  }, [anchorEl, disablePortal, modifiers, open, rtlPlacement, popperOptions]);
  var handleRef = React.useCallback(function (node) {
    (0, _setRef.default)(ownRef, node);
    handleOpen();
  }, [ownRef, handleOpen]);

  var handleEnter = function handleEnter() {
    setExited(false);
  };

  var handleClose = function handleClose() {
    if (!popperRef.current) {
      return;
    }

    popperRef.current.destroy();
    handlePopperRefRef.current(null);
  };

  var handleExited = function handleExited() {
    setExited(true);
    handleClose();
  };

  React.useEffect(function () {
    return function () {
      handleClose();
    };
  }, []);
  React.useEffect(function () {
    if (!open && !transition) {
      // Otherwise handleExited will call this.
      handleClose();
    }
  }, [open, transition]);

  if (!keepMounted && !open && (!transition || exited)) {
    return null;
  }

  var childProps = {
    placement: placement
  };

  if (transition) {
    childProps.TransitionProps = {
      in: open,
      onEnter: handleEnter,
      onExited: handleExited
    };
  }

  return /*#__PURE__*/React.createElement(_Portal.default, {
    disablePortal: disablePortal,
    container: container
  }, /*#__PURE__*/React.createElement("div", (0, _extends2.default)({
    ref: handleRef,
    role: "tooltip"
  }, other, {
    style: (0, _extends2.default)({
      // Prevents scroll issue, waiting for Popper.js to add this style once initiated.
      position: 'fixed',
      // Fix Popper.js display issue
      top: 0,
      left: 0,
      display: !open && keepMounted && !transition ? 'none' : null
    }, style)
  }), typeof children === 'function' ? children(childProps) : children));
});
"development" !== "production" ? Popper.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * A HTML element, [referenceObject](https://popper.js.org/docs/v1/#referenceObject),
   * or a function that returns either.
   * It's used to set the position of the popper.
   * The return value will passed as the reference object of the Popper instance.
   */
  anchorEl: (0, _utils.chainPropTypes)(_propTypes.default.oneOfType([_utils.HTMLElementType, _propTypes.default.object, _propTypes.default.func]), function (props) {
    if (props.open) {
      var resolvedAnchorEl = getAnchorEl(props.anchorEl);

      if (resolvedAnchorEl && resolvedAnchorEl.nodeType === 1) {
        var box = resolvedAnchorEl.getBoundingClientRect();

        if ("development" !== 'test' && box.top === 0 && box.left === 0 && box.right === 0 && box.bottom === 0) {
          return new Error(['Material-UI: The `anchorEl` prop provided to the component is invalid.', 'The anchor element should be part of the document layout.', "Make sure the element is present in the document or that it's not display none."].join('\n'));
        }
      } else if (!resolvedAnchorEl || typeof resolvedAnchorEl.clientWidth !== 'number' || typeof resolvedAnchorEl.clientHeight !== 'number' || typeof resolvedAnchorEl.getBoundingClientRect !== 'function') {
        return new Error(['Material-UI: The `anchorEl` prop provided to the component is invalid.', 'It should be an HTML element instance or a referenceObject ', '(https://popper.js.org/docs/v1/#referenceObject).'].join('\n'));
      }
    }

    return null;
  }),

  /**
   * Popper render function or node.
   */
  children: _propTypes.default
  /* @typescript-to-proptypes-ignore */
  .oneOfType([_propTypes.default.node, _propTypes.default.func]).isRequired,

  /**
   * A HTML element, component instance, or function that returns either.
   * The `container` will have the portal children appended to it.
   *
   * By default, it uses the body of the top-level document object,
   * so it's simply `document.body` most of the time.
   */
  container: _propTypes.default
  /* @typescript-to-proptypes-ignore */
  .oneOfType([_utils.HTMLElementType, _propTypes.default.instanceOf(React.Component), _propTypes.default.func]),

  /**
   * Disable the portal behavior.
   * The children stay within it's parent DOM hierarchy.
   */
  disablePortal: _propTypes.default.bool,

  /**
   * Always keep the children in the DOM.
   * This prop can be useful in SEO situation or
   * when you want to maximize the responsiveness of the Popper.
   */
  keepMounted: _propTypes.default.bool,

  /**
   * Popper.js is based on a "plugin-like" architecture,
   * most of its features are fully encapsulated "modifiers".
   *
   * A modifier is a function that is called each time Popper.js needs to
   * compute the position of the popper.
   * For this reason, modifiers should be very performant to avoid bottlenecks.
   * To learn how to create a modifier, [read the modifiers documentation](https://popper.js.org/docs/v1/#modifiers).
   */
  modifiers: _propTypes.default.object,

  /**
   * If `true`, the popper is visible.
   */
  open: _propTypes.default.bool.isRequired,

  /**
   * Popper placement.
   */
  placement: _propTypes.default.oneOf(['bottom-end', 'bottom-start', 'bottom', 'left-end', 'left-start', 'left', 'right-end', 'right-start', 'right', 'top-end', 'top-start', 'top']),

  /**
   * Options provided to the [`popper.js`](https://popper.js.org/docs/v1/) instance.
   */
  popperOptions: _propTypes.default.object,

  /**
   * A ref that points to the used popper instance.
   */
  popperRef: _utils.refType,

  /**
   * @ignore
   */
  style: _propTypes.default.object,

  /**
   * Help supporting a react-transition-group/Transition component.
   */
  transition: _propTypes.default.bool
} : void 0;
var _default = Popper;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Popper\\Popper.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Popper\\index.js", {"./Popper":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Popper\\Popper.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CPopper%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _Popper.default;
  }
});

var _Popper = _interopRequireDefault(require("./Popper"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Popper\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Portal\\Portal.js", {"../utils/deprecatedPropType":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\deprecatedPropType.js","../utils/setRef":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\setRef.js","../utils/useForkRef":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\useForkRef.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CPortal%5CPortal.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var ReactDOM = _interopRequireWildcard(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _utils = require("@material-ui/utils");

var _deprecatedPropType = _interopRequireDefault(require("../utils/deprecatedPropType"));

var _setRef = _interopRequireDefault(require("../utils/setRef"));

var _useForkRef = _interopRequireDefault(require("../utils/useForkRef"));

function getContainer(container) {
  container = typeof container === 'function' ? container() : container; // #StrictMode ready

  return ReactDOM.findDOMNode(container);
}

var useEnhancedEffect = typeof window !== 'undefined' ? React.useLayoutEffect : React.useEffect;
/**
 * Portals provide a first-class way to render children into a DOM node
 * that exists outside the DOM hierarchy of the parent component.
 */

var Portal = /*#__PURE__*/React.forwardRef(function Portal(props, ref) {
  var children = props.children,
      container = props.container,
      _props$disablePortal = props.disablePortal,
      disablePortal = _props$disablePortal === void 0 ? false : _props$disablePortal,
      onRendered = props.onRendered;

  var _React$useState = React.useState(null),
      mountNode = _React$useState[0],
      setMountNode = _React$useState[1];

  var handleRef = (0, _useForkRef.default)( /*#__PURE__*/React.isValidElement(children) ? children.ref : null, ref);
  useEnhancedEffect(function () {
    if (!disablePortal) {
      setMountNode(getContainer(container) || document.body);
    }
  }, [container, disablePortal]);
  useEnhancedEffect(function () {
    if (mountNode && !disablePortal) {
      (0, _setRef.default)(ref, mountNode);
      return function () {
        (0, _setRef.default)(ref, null);
      };
    }

    return undefined;
  }, [ref, mountNode, disablePortal]);
  useEnhancedEffect(function () {
    if (onRendered && (mountNode || disablePortal)) {
      onRendered();
    }
  }, [onRendered, mountNode, disablePortal]);

  if (disablePortal) {
    if ( /*#__PURE__*/React.isValidElement(children)) {
      return /*#__PURE__*/React.cloneElement(children, {
        ref: handleRef
      });
    }

    return children;
  }

  return mountNode ? /*#__PURE__*/ReactDOM.createPortal(children, mountNode) : mountNode;
});
"development" !== "production" ? Portal.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * The children to render into the `container`.
   */
  children: _propTypes.default.node,

  /**
   * A HTML element, component instance, or function that returns either.
   * The `container` will have the portal children appended to it.
   *
   * By default, it uses the body of the top-level document object,
   * so it's simply `document.body` most of the time.
   */
  container: _propTypes.default
  /* @typescript-to-proptypes-ignore */
  .oneOfType([_utils.HTMLElementType, _propTypes.default.instanceOf(React.Component), _propTypes.default.func]),

  /**
   * Disable the portal behavior.
   * The children stay within it's parent DOM hierarchy.
   */
  disablePortal: _propTypes.default.bool,

  /**
   * Callback fired once the children has been mounted into the `container`.
   *
   * This prop will be removed in v5, the ref can be used instead.
   * @deprecated Use the ref instead.
   */
  onRendered: (0, _deprecatedPropType.default)(_propTypes.default.func, 'Use the ref instead.')
} : void 0;

if ("development" !== 'production') {
  // eslint-disable-next-line
  Portal['propTypes' + ''] = (0, _utils.exactProp)(Portal.propTypes);
}

var _default = Portal;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Portal\\Portal.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Portal\\index.js", {"./Portal":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Portal\\Portal.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CPortal%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _Portal.default;
  }
});

var _Portal = _interopRequireDefault(require("./Portal"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Portal\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Select\\Select.js", {"../FilledInput":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FilledInput\\index.js","../FormControl/formControlState":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\formControlState.js","../FormControl/useFormControl":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\useFormControl.js","../Input":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Input\\index.js","../NativeSelect/NativeSelect":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\NativeSelect\\NativeSelect.js","../NativeSelect/NativeSelectInput":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\NativeSelect\\NativeSelectInput.js","../OutlinedInput":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\OutlinedInput\\index.js","../internal/svg-icons/ArrowDropDown":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\internal\\svg-icons\\ArrowDropDown.js","../styles/withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withStyles.js","./SelectInput":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Select\\SelectInput.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@material-ui/styles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CSelect%5CSelect.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _styles = require("@material-ui/styles");

var _SelectInput = _interopRequireDefault(require("./SelectInput"));

var _formControlState = _interopRequireDefault(require("../FormControl/formControlState"));

var _useFormControl = _interopRequireDefault(require("../FormControl/useFormControl"));

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var _ArrowDropDown = _interopRequireDefault(require("../internal/svg-icons/ArrowDropDown"));

var _Input = _interopRequireDefault(require("../Input"));

var _NativeSelect = require("../NativeSelect/NativeSelect");

var _NativeSelectInput = _interopRequireDefault(require("../NativeSelect/NativeSelectInput"));

var _FilledInput = _interopRequireDefault(require("../FilledInput"));

var _OutlinedInput = _interopRequireDefault(require("../OutlinedInput"));

var styles = _NativeSelect.styles;
exports.styles = styles;

var _ref = /*#__PURE__*/React.createElement(_Input.default, null);

var _ref2 = /*#__PURE__*/React.createElement(_FilledInput.default, null);

var Select = /*#__PURE__*/React.forwardRef(function Select(props, ref) {
  var _props$autoWidth = props.autoWidth,
      autoWidth = _props$autoWidth === void 0 ? false : _props$autoWidth,
      children = props.children,
      classes = props.classes,
      _props$displayEmpty = props.displayEmpty,
      displayEmpty = _props$displayEmpty === void 0 ? false : _props$displayEmpty,
      _props$IconComponent = props.IconComponent,
      IconComponent = _props$IconComponent === void 0 ? _ArrowDropDown.default : _props$IconComponent,
      id = props.id,
      input = props.input,
      inputProps = props.inputProps,
      label = props.label,
      labelId = props.labelId,
      _props$labelWidth = props.labelWidth,
      labelWidth = _props$labelWidth === void 0 ? 0 : _props$labelWidth,
      MenuProps = props.MenuProps,
      _props$multiple = props.multiple,
      multiple = _props$multiple === void 0 ? false : _props$multiple,
      _props$native = props.native,
      native = _props$native === void 0 ? false : _props$native,
      onClose = props.onClose,
      onOpen = props.onOpen,
      open = props.open,
      renderValue = props.renderValue,
      SelectDisplayProps = props.SelectDisplayProps,
      _props$variant = props.variant,
      variantProps = _props$variant === void 0 ? 'standard' : _props$variant,
      other = (0, _objectWithoutProperties2.default)(props, ["autoWidth", "children", "classes", "displayEmpty", "IconComponent", "id", "input", "inputProps", "label", "labelId", "labelWidth", "MenuProps", "multiple", "native", "onClose", "onOpen", "open", "renderValue", "SelectDisplayProps", "variant"]);
  var inputComponent = native ? _NativeSelectInput.default : _SelectInput.default;
  var muiFormControl = (0, _useFormControl.default)();
  var fcs = (0, _formControlState.default)({
    props: props,
    muiFormControl: muiFormControl,
    states: ['variant']
  });
  var variant = fcs.variant || variantProps;
  var InputComponent = input || {
    standard: _ref,
    outlined: /*#__PURE__*/React.createElement(_OutlinedInput.default, {
      label: label,
      labelWidth: labelWidth
    }),
    filled: _ref2
  }[variant];
  return /*#__PURE__*/React.cloneElement(InputComponent, (0, _extends2.default)({
    // Most of the logic is implemented in `SelectInput`.
    // The `Select` component is a simple API wrapper to expose something better to play with.
    inputComponent: inputComponent,
    inputProps: (0, _extends2.default)({
      children: children,
      IconComponent: IconComponent,
      variant: variant,
      type: undefined,
      // We render a select. We can ignore the type provided by the `Input`.
      multiple: multiple
    }, native ? {
      id: id
    } : {
      autoWidth: autoWidth,
      displayEmpty: displayEmpty,
      labelId: labelId,
      MenuProps: MenuProps,
      onClose: onClose,
      onOpen: onOpen,
      open: open,
      renderValue: renderValue,
      SelectDisplayProps: (0, _extends2.default)({
        id: id
      }, SelectDisplayProps)
    }, inputProps, {
      classes: inputProps ? (0, _styles.mergeClasses)({
        baseClasses: classes,
        newClasses: inputProps.classes,
        Component: Select
      }) : classes
    }, input ? input.props.inputProps : {}),
    ref: ref
  }, other));
});
"development" !== "production" ? Select.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * If `true`, the width of the popover will automatically be set according to the items inside the
   * menu, otherwise it will be at least the width of the select input.
   */
  autoWidth: _propTypes.default.bool,

  /**
   * The option elements to populate the select with.
   * Can be some `MenuItem` when `native` is false and `option` when `native` is true.
   *
   * ⚠️The `MenuItem` elements **must** be direct descendants when `native` is false.
   */
  children: _propTypes.default.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object,

  /**
   * The default element value. Use when the component is not controlled.
   */
  defaultValue: _propTypes.default.any,

  /**
   * If `true`, a value is displayed even if no items are selected.
   *
   * In order to display a meaningful value, a function should be passed to the `renderValue` prop which returns the value to be displayed when no items are selected.
   * You can only use it when the `native` prop is `false` (default).
   */
  displayEmpty: _propTypes.default.bool,

  /**
   * The icon that displays the arrow.
   */
  IconComponent: _propTypes.default.elementType,

  /**
   * The `id` of the wrapper element or the `select` element when `native`.
   */
  id: _propTypes.default.string,

  /**
   * An `Input` element; does not have to be a material-ui specific `Input`.
   */
  input: _propTypes.default.element,

  /**
   * [Attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Attributes) applied to the `input` element.
   * When `native` is `true`, the attributes are applied on the `select` element.
   */
  inputProps: _propTypes.default.object,

  /**
   * See [OutlinedInput#label](/api/outlined-input/#props)
   */
  label: _propTypes.default.node,

  /**
   * The ID of an element that acts as an additional label. The Select will
   * be labelled by the additional label and the selected value.
   */
  labelId: _propTypes.default.string,

  /**
   * See [OutlinedInput#label](/api/outlined-input/#props)
   */
  labelWidth: _propTypes.default.number,

  /**
   * Props applied to the [`Menu`](/api/menu/) element.
   */
  MenuProps: _propTypes.default.object,

  /**
   * If `true`, `value` must be an array and the menu will support multiple selections.
   */
  multiple: _propTypes.default.bool,

  /**
   * If `true`, the component will be using a native `select` element.
   */
  native: _propTypes.default.bool,

  /**
   * Callback function fired when a menu item is selected.
   *
   * @param {object} event The event source of the callback.
   * You can pull out the new value by accessing `event.target.value` (any).
   * @param {object} [child] The react element that was selected when `native` is `false` (default).
   */
  onChange: _propTypes.default.func,

  /**
   * Callback fired when the component requests to be closed.
   * Use in controlled mode (see open).
   *
   * @param {object} event The event source of the callback.
   */
  onClose: _propTypes.default.func,

  /**
   * Callback fired when the component requests to be opened.
   * Use in controlled mode (see open).
   *
   * @param {object} event The event source of the callback.
   */
  onOpen: _propTypes.default.func,

  /**
   * Control `select` open state.
   * You can only use it when the `native` prop is `false` (default).
   */
  open: _propTypes.default.bool,

  /**
   * Render the selected value.
   * You can only use it when the `native` prop is `false` (default).
   *
   * @param {any} value The `value` provided to the component.
   * @returns {ReactNode}
   */
  renderValue: _propTypes.default.func,

  /**
   * Props applied to the clickable div element.
   */
  SelectDisplayProps: _propTypes.default.object,

  /**
   * The input value. Providing an empty string will select no options.
   * This prop is required when the `native` prop is `false` (default).
   * Set to an empty string `''` if you don't want any of the available options to be selected.
   *
   * If the value is an object it must have reference equality with the option in order to be selected.
   * If the value is not an object, the string representation must match with the string representation of the option in order to be selected.
   */
  value: _propTypes.default.any,

  /**
   * The variant to use.
   */
  variant: _propTypes.default.oneOf(['filled', 'outlined', 'standard'])
} : void 0;
Select.muiName = 'Select';

var _default = (0, _withStyles.default)(styles, {
  name: 'MuiSelect'
})(Select);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Select\\Select.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Select\\SelectInput.js", {"../InputBase/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\InputBase\\utils.js","../Menu/Menu":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Menu\\Menu.js","../utils/capitalize":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\capitalize.js","../utils/ownerDocument":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\ownerDocument.js","../utils/useControlled":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\useControlled.js","../utils/useForkRef":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\useForkRef.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@babel/runtime/helpers/slicedToArray":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\slicedToArray.js","@babel/runtime/helpers/typeof":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\typeof.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js","clsx":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\node_modules\\clsx\\dist\\clsx.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-is":"D:\\code\\v\\metamask-extension\\node_modules\\react-is\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CSelect%5CSelectInput.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _utils = require("@material-ui/utils");

var React = _interopRequireWildcard(require("react"));

var _reactIs = require("react-is");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _ownerDocument = _interopRequireDefault(require("../utils/ownerDocument"));

var _capitalize = _interopRequireDefault(require("../utils/capitalize"));

var _Menu = _interopRequireDefault(require("../Menu/Menu"));

var _utils2 = require("../InputBase/utils");

var _useForkRef = _interopRequireDefault(require("../utils/useForkRef"));

var _useControlled3 = _interopRequireDefault(require("../utils/useControlled"));

function areEqualValues(a, b) {
  if ((0, _typeof2.default)(b) === 'object' && b !== null) {
    return a === b;
  }

  return String(a) === String(b);
}

function isEmpty(display) {
  return display == null || typeof display === 'string' && !display.trim();
}
/**
 * @ignore - internal component.
 */


var SelectInput = /*#__PURE__*/React.forwardRef(function SelectInput(props, ref) {
  var ariaLabel = props['aria-label'],
      autoFocus = props.autoFocus,
      autoWidth = props.autoWidth,
      children = props.children,
      classes = props.classes,
      className = props.className,
      defaultValue = props.defaultValue,
      disabled = props.disabled,
      displayEmpty = props.displayEmpty,
      IconComponent = props.IconComponent,
      inputRefProp = props.inputRef,
      labelId = props.labelId,
      _props$MenuProps = props.MenuProps,
      MenuProps = _props$MenuProps === void 0 ? {} : _props$MenuProps,
      multiple = props.multiple,
      name = props.name,
      onBlur = props.onBlur,
      onChange = props.onChange,
      onClose = props.onClose,
      onFocus = props.onFocus,
      onOpen = props.onOpen,
      openProp = props.open,
      readOnly = props.readOnly,
      renderValue = props.renderValue,
      _props$SelectDisplayP = props.SelectDisplayProps,
      SelectDisplayProps = _props$SelectDisplayP === void 0 ? {} : _props$SelectDisplayP,
      tabIndexProp = props.tabIndex,
      type = props.type,
      valueProp = props.value,
      _props$variant = props.variant,
      variant = _props$variant === void 0 ? 'standard' : _props$variant,
      other = (0, _objectWithoutProperties2.default)(props, ["aria-label", "autoFocus", "autoWidth", "children", "classes", "className", "defaultValue", "disabled", "displayEmpty", "IconComponent", "inputRef", "labelId", "MenuProps", "multiple", "name", "onBlur", "onChange", "onClose", "onFocus", "onOpen", "open", "readOnly", "renderValue", "SelectDisplayProps", "tabIndex", "type", "value", "variant"]);

  var _useControlled = (0, _useControlled3.default)({
    controlled: valueProp,
    default: defaultValue,
    name: 'Select'
  }),
      _useControlled2 = (0, _slicedToArray2.default)(_useControlled, 2),
      value = _useControlled2[0],
      setValue = _useControlled2[1];

  var inputRef = React.useRef(null);

  var _React$useState = React.useState(null),
      displayNode = _React$useState[0],
      setDisplayNode = _React$useState[1];

  var _React$useRef = React.useRef(openProp != null),
      isOpenControlled = _React$useRef.current;

  var _React$useState2 = React.useState(),
      menuMinWidthState = _React$useState2[0],
      setMenuMinWidthState = _React$useState2[1];

  var _React$useState3 = React.useState(false),
      openState = _React$useState3[0],
      setOpenState = _React$useState3[1];

  var handleRef = (0, _useForkRef.default)(ref, inputRefProp);
  React.useImperativeHandle(handleRef, function () {
    return {
      focus: function focus() {
        displayNode.focus();
      },
      node: inputRef.current,
      value: value
    };
  }, [displayNode, value]);
  React.useEffect(function () {
    if (autoFocus && displayNode) {
      displayNode.focus();
    }
  }, [autoFocus, displayNode]);
  React.useEffect(function () {
    if (displayNode) {
      var label = (0, _ownerDocument.default)(displayNode).getElementById(labelId);

      if (label) {
        var handler = function handler() {
          if (getSelection().isCollapsed) {
            displayNode.focus();
          }
        };

        label.addEventListener('click', handler);
        return function () {
          label.removeEventListener('click', handler);
        };
      }
    }

    return undefined;
  }, [labelId, displayNode]);

  var update = function update(open, event) {
    if (open) {
      if (onOpen) {
        onOpen(event);
      }
    } else if (onClose) {
      onClose(event);
    }

    if (!isOpenControlled) {
      setMenuMinWidthState(autoWidth ? null : displayNode.clientWidth);
      setOpenState(open);
    }
  };

  var handleMouseDown = function handleMouseDown(event) {
    // Ignore everything but left-click
    if (event.button !== 0) {
      return;
    } // Hijack the default focus behavior.


    event.preventDefault();
    displayNode.focus();
    update(true, event);
  };

  var handleClose = function handleClose(event) {
    update(false, event);
  };

  var childrenArray = React.Children.toArray(children); // Support autofill.

  var handleChange = function handleChange(event) {
    var index = childrenArray.map(function (child) {
      return child.props.value;
    }).indexOf(event.target.value);

    if (index === -1) {
      return;
    }

    var child = childrenArray[index];
    setValue(child.props.value);

    if (onChange) {
      onChange(event, child);
    }
  };

  var handleItemClick = function handleItemClick(child) {
    return function (event) {
      if (!multiple) {
        update(false, event);
      }

      var newValue;

      if (multiple) {
        newValue = Array.isArray(value) ? value.slice() : [];
        var itemIndex = value.indexOf(child.props.value);

        if (itemIndex === -1) {
          newValue.push(child.props.value);
        } else {
          newValue.splice(itemIndex, 1);
        }
      } else {
        newValue = child.props.value;
      }

      if (child.props.onClick) {
        child.props.onClick(event);
      }

      if (value === newValue) {
        return;
      }

      setValue(newValue);

      if (onChange) {
        event.persist(); // Preact support, target is read only property on a native event.

        Object.defineProperty(event, 'target', {
          writable: true,
          value: {
            value: newValue,
            name: name
          }
        });
        onChange(event, child);
      }
    };
  };

  var handleKeyDown = function handleKeyDown(event) {
    if (!readOnly) {
      var validKeys = [' ', 'ArrowUp', 'ArrowDown', // The native select doesn't respond to enter on MacOS, but it's recommended by
      // https://www.w3.org/TR/wai-aria-practices/examples/listbox/listbox-collapsible.html
      'Enter'];

      if (validKeys.indexOf(event.key) !== -1) {
        event.preventDefault();
        update(true, event);
      }
    }
  };

  var open = displayNode !== null && (isOpenControlled ? openProp : openState);

  var handleBlur = function handleBlur(event) {
    // if open event.stopImmediatePropagation
    if (!open && onBlur) {
      event.persist(); // Preact support, target is read only property on a native event.

      Object.defineProperty(event, 'target', {
        writable: true,
        value: {
          value: value,
          name: name
        }
      });
      onBlur(event);
    }
  };

  delete other['aria-invalid'];
  var display;
  var displaySingle;
  var displayMultiple = [];
  var computeDisplay = false;
  var foundMatch = false; // No need to display any value if the field is empty.

  if ((0, _utils2.isFilled)({
    value: value
  }) || displayEmpty) {
    if (renderValue) {
      display = renderValue(value);
    } else {
      computeDisplay = true;
    }
  }

  var items = childrenArray.map(function (child) {
    if (! /*#__PURE__*/React.isValidElement(child)) {
      return null;
    }

    if ("development" !== 'production') {
      if ((0, _reactIs.isFragment)(child)) {
        console.error(["Material-UI: The Select component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
      }
    }

    var selected;

    if (multiple) {
      if (!Array.isArray(value)) {
        throw new Error("development" !== "production" ? "Material-UI: The `value` prop must be an array when using the `Select` component with `multiple`." : (0, _utils.formatMuiErrorMessage)(2));
      }

      selected = value.some(function (v) {
        return areEqualValues(v, child.props.value);
      });

      if (selected && computeDisplay) {
        displayMultiple.push(child.props.children);
      }
    } else {
      selected = areEqualValues(value, child.props.value);

      if (selected && computeDisplay) {
        displaySingle = child.props.children;
      }
    }

    if (selected) {
      foundMatch = true;
    }

    return /*#__PURE__*/React.cloneElement(child, {
      'aria-selected': selected ? 'true' : undefined,
      onClick: handleItemClick(child),
      onKeyUp: function onKeyUp(event) {
        if (event.key === ' ') {
          // otherwise our MenuItems dispatches a click event
          // it's not behavior of the native <option> and causes
          // the select to close immediately since we open on space keydown
          event.preventDefault();
        }

        if (child.props.onKeyUp) {
          child.props.onKeyUp(event);
        }
      },
      role: 'option',
      selected: selected,
      value: undefined,
      // The value is most likely not a valid HTML attribute.
      'data-value': child.props.value // Instead, we provide it as a data attribute.

    });
  });

  if ("development" !== 'production') {
    // eslint-disable-next-line react-hooks/rules-of-hooks
    React.useEffect(function () {
      if (!foundMatch && !multiple && value !== '') {
        var values = childrenArray.map(function (child) {
          return child.props.value;
        });
        console.warn(["Material-UI: You have provided an out-of-range value `".concat(value, "` for the select ").concat(name ? "(name=\"".concat(name, "\") ") : '', "component."), "Consider providing a value that matches one of the available options or ''.", "The available values are ".concat(values.filter(function (x) {
          return x != null;
        }).map(function (x) {
          return "`".concat(x, "`");
        }).join(', ') || '""', ".")].join('\n'));
      }
    }, [foundMatch, childrenArray, multiple, name, value]);
  }

  if (computeDisplay) {
    display = multiple ? displayMultiple.join(', ') : displaySingle;
  } // Avoid performing a layout computation in the render method.


  var menuMinWidth = menuMinWidthState;

  if (!autoWidth && isOpenControlled && displayNode) {
    menuMinWidth = displayNode.clientWidth;
  }

  var tabIndex;

  if (typeof tabIndexProp !== 'undefined') {
    tabIndex = tabIndexProp;
  } else {
    tabIndex = disabled ? null : 0;
  }

  var buttonId = SelectDisplayProps.id || (name ? "mui-component-select-".concat(name) : undefined);
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("div", (0, _extends2.default)({
    className: (0, _clsx.default)(classes.root, // TODO v5: merge root and select
    classes.select, classes.selectMenu, classes[variant], className, disabled && classes.disabled),
    ref: setDisplayNode,
    tabIndex: tabIndex,
    role: "button",
    "aria-disabled": disabled ? 'true' : undefined,
    "aria-expanded": open ? 'true' : undefined,
    "aria-haspopup": "listbox",
    "aria-label": ariaLabel,
    "aria-labelledby": [labelId, buttonId].filter(Boolean).join(' ') || undefined,
    onKeyDown: handleKeyDown,
    onMouseDown: disabled || readOnly ? null : handleMouseDown,
    onBlur: handleBlur,
    onFocus: onFocus
  }, SelectDisplayProps, {
    // The id is required for proper a11y
    id: buttonId
  }), isEmpty(display) ?
  /*#__PURE__*/
  // eslint-disable-next-line react/no-danger
  React.createElement("span", {
    dangerouslySetInnerHTML: {
      __html: '&#8203;'
    }
  }) : display), /*#__PURE__*/React.createElement("input", (0, _extends2.default)({
    value: Array.isArray(value) ? value.join(',') : value,
    name: name,
    ref: inputRef,
    "aria-hidden": true,
    onChange: handleChange,
    tabIndex: -1,
    className: classes.nativeInput,
    autoFocus: autoFocus
  }, other)), /*#__PURE__*/React.createElement(IconComponent, {
    className: (0, _clsx.default)(classes.icon, classes["icon".concat((0, _capitalize.default)(variant))], open && classes.iconOpen, disabled && classes.disabled)
  }), /*#__PURE__*/React.createElement(_Menu.default, (0, _extends2.default)({
    id: "menu-".concat(name || ''),
    anchorEl: displayNode,
    open: open,
    onClose: handleClose
  }, MenuProps, {
    MenuListProps: (0, _extends2.default)({
      'aria-labelledby': labelId,
      role: 'listbox',
      disableListWrap: true
    }, MenuProps.MenuListProps),
    PaperProps: (0, _extends2.default)({}, MenuProps.PaperProps, {
      style: (0, _extends2.default)({
        minWidth: menuMinWidth
      }, MenuProps.PaperProps != null ? MenuProps.PaperProps.style : null)
    })
  }), items));
});
"development" !== "production" ? SelectInput.propTypes = {
  /**
   * @ignore
   */
  'aria-label': _propTypes.default.string,

  /**
   * @ignore
   */
  autoFocus: _propTypes.default.bool,

  /**
   * If `true`, the width of the popover will automatically be set according to the items inside the
   * menu, otherwise it will be at least the width of the select input.
   */
  autoWidth: _propTypes.default.bool,

  /**
   * The option elements to populate the select with.
   * Can be some `<MenuItem>` elements.
   */
  children: _propTypes.default.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object.isRequired,

  /**
   * The CSS class name of the select element.
   */
  className: _propTypes.default.string,

  /**
   * The default element value. Use when the component is not controlled.
   */
  defaultValue: _propTypes.default.any,

  /**
   * If `true`, the select will be disabled.
   */
  disabled: _propTypes.default.bool,

  /**
   * If `true`, the selected item is displayed even if its value is empty.
   */
  displayEmpty: _propTypes.default.bool,

  /**
   * The icon that displays the arrow.
   */
  IconComponent: _propTypes.default.elementType.isRequired,

  /**
   * Imperative handle implementing `{ value: T, node: HTMLElement, focus(): void }`
   * Equivalent to `ref`
   */
  inputRef: _utils.refType,

  /**
   * The ID of an element that acts as an additional label. The Select will
   * be labelled by the additional label and the selected value.
   */
  labelId: _propTypes.default.string,

  /**
   * Props applied to the [`Menu`](/api/menu/) element.
   */
  MenuProps: _propTypes.default.object,

  /**
   * If `true`, `value` must be an array and the menu will support multiple selections.
   */
  multiple: _propTypes.default.bool,

  /**
   * Name attribute of the `select` or hidden `input` element.
   */
  name: _propTypes.default.string,

  /**
   * @ignore
   */
  onBlur: _propTypes.default.func,

  /**
   * Callback function fired when a menu item is selected.
   *
   * @param {object} event The event source of the callback.
   * You can pull out the new value by accessing `event.target.value` (any).
   * @param {object} [child] The react element that was selected.
   */
  onChange: _propTypes.default.func,

  /**
   * Callback fired when the component requests to be closed.
   * Use in controlled mode (see open).
   *
   * @param {object} event The event source of the callback.
   */
  onClose: _propTypes.default.func,

  /**
   * @ignore
   */
  onFocus: _propTypes.default.func,

  /**
   * Callback fired when the component requests to be opened.
   * Use in controlled mode (see open).
   *
   * @param {object} event The event source of the callback.
   */
  onOpen: _propTypes.default.func,

  /**
   * Control `select` open state.
   */
  open: _propTypes.default.bool,

  /**
   * @ignore
   */
  readOnly: _propTypes.default.bool,

  /**
   * Render the selected value.
   *
   * @param {any} value The `value` provided to the component.
   * @returns {ReactNode}
   */
  renderValue: _propTypes.default.func,

  /**
   * Props applied to the clickable div element.
   */
  SelectDisplayProps: _propTypes.default.object,

  /**
   * @ignore
   */
  tabIndex: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * @ignore
   */
  type: _propTypes.default.any,

  /**
   * The input value.
   */
  value: _propTypes.default.any,

  /**
   * The variant to use.
   */
  variant: _propTypes.default.oneOf(['standard', 'outlined', 'filled'])
} : void 0;
var _default = SelectInput;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Select\\SelectInput.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Select\\index.js", {"./Select":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Select\\Select.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CSelect%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _Select.default;
  }
});

var _Select = _interopRequireDefault(require("./Select"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Select\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\SvgIcon\\SvgIcon.js", {"../styles/withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withStyles.js","../utils/capitalize":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\capitalize.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js","clsx":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\node_modules\\clsx\\dist\\clsx.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CSvgIcon%5CSvgIcon.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _utils = require("@material-ui/utils");

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var _capitalize = _interopRequireDefault(require("../utils/capitalize"));

var styles = function styles(theme) {
  return {
    /* Styles applied to the root element. */
    root: {
      userSelect: 'none',
      width: '1em',
      height: '1em',
      display: 'inline-block',
      fill: 'currentColor',
      flexShrink: 0,
      fontSize: theme.typography.pxToRem(24),
      transition: theme.transitions.create('fill', {
        duration: theme.transitions.duration.shorter
      })
    },

    /* Styles applied to the root element if `color="primary"`. */
    colorPrimary: {
      color: theme.palette.primary.main
    },

    /* Styles applied to the root element if `color="secondary"`. */
    colorSecondary: {
      color: theme.palette.secondary.main
    },

    /* Styles applied to the root element if `color="action"`. */
    colorAction: {
      color: theme.palette.action.active
    },

    /* Styles applied to the root element if `color="error"`. */
    colorError: {
      color: theme.palette.error.main
    },

    /* Styles applied to the root element if `color="disabled"`. */
    colorDisabled: {
      color: theme.palette.action.disabled
    },

    /* Styles applied to the root element if `fontSize="inherit"`. */
    fontSizeInherit: {
      fontSize: 'inherit'
    },

    /* Styles applied to the root element if `fontSize="small"`. */
    fontSizeSmall: {
      fontSize: theme.typography.pxToRem(20)
    },

    /* Styles applied to the root element if `fontSize="large"`. */
    fontSizeLarge: {
      fontSize: theme.typography.pxToRem(35)
    }
  };
};

exports.styles = styles;
var SvgIcon = /*#__PURE__*/React.forwardRef(function SvgIcon(props, ref) {
  var children = props.children,
      classes = props.classes,
      className = props.className,
      _props$color = props.color,
      color = _props$color === void 0 ? 'inherit' : _props$color,
      _props$component = props.component,
      Component = _props$component === void 0 ? 'svg' : _props$component,
      _props$fontSize = props.fontSize,
      fontSize = _props$fontSize === void 0 ? 'medium' : _props$fontSize,
      htmlColor = props.htmlColor,
      titleAccess = props.titleAccess,
      _props$viewBox = props.viewBox,
      viewBox = _props$viewBox === void 0 ? '0 0 24 24' : _props$viewBox,
      other = (0, _objectWithoutProperties2.default)(props, ["children", "classes", "className", "color", "component", "fontSize", "htmlColor", "titleAccess", "viewBox"]);
  return /*#__PURE__*/React.createElement(Component, (0, _extends2.default)({
    className: (0, _clsx.default)(classes.root, className, color !== 'inherit' && classes["color".concat((0, _capitalize.default)(color))], fontSize !== 'default' && fontSize !== 'medium' && classes["fontSize".concat((0, _capitalize.default)(fontSize))]),
    focusable: "false",
    viewBox: viewBox,
    color: htmlColor,
    "aria-hidden": titleAccess ? undefined : true,
    role: titleAccess ? 'img' : undefined,
    ref: ref
  }, other), children, titleAccess ? /*#__PURE__*/React.createElement("title", null, titleAccess) : null);
});
"development" !== "production" ? SvgIcon.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * Node passed into the SVG element.
   */
  children: _propTypes.default.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object,

  /**
   * @ignore
   */
  className: _propTypes.default.string,

  /**
   * The color of the component. It supports those theme colors that make sense for this component.
   * You can use the `htmlColor` prop to apply a color attribute to the SVG element.
   */
  color: _propTypes.default.oneOf(['action', 'disabled', 'error', 'inherit', 'primary', 'secondary']),

  /**
   * The component used for the root node.
   * Either a string to use a HTML element or a component.
   */
  component: _propTypes.default
  /* @typescript-to-proptypes-ignore */
  .elementType,

  /**
   * The fontSize applied to the icon. Defaults to 24px, but can be configure to inherit font size.
   */
  fontSize: (0, _utils.chainPropTypes)(_propTypes.default.oneOf(['default', 'inherit', 'large', 'medium', 'small']), function (props) {
    var fontSize = props.fontSize;

    if (fontSize === 'default') {
      throw new Error('Material-UI: `fontSize="default"` is deprecated. Use `fontSize="medium"` instead.');
    }

    return null;
  }),

  /**
   * Applies a color attribute to the SVG element.
   */
  htmlColor: _propTypes.default.string,

  /**
   * The shape-rendering attribute. The behavior of the different options is described on the
   * [MDN Web Docs](https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/shape-rendering).
   * If you are having issues with blurry icons you should investigate this property.
   */
  shapeRendering: _propTypes.default.string,

  /**
   * Provides a human-readable title for the element that contains it.
   * https://www.w3.org/TR/SVG-access/#Equivalent
   */
  titleAccess: _propTypes.default.string,

  /**
   * Allows you to redefine what the coordinates without units mean inside an SVG element.
   * For example, if the SVG element is 500 (width) by 200 (height),
   * and you pass viewBox="0 0 50 20",
   * this means that the coordinates inside the SVG will go from the top left corner (0,0)
   * to bottom right (50,20) and each unit will be worth 10px.
   */
  viewBox: _propTypes.default.string
} : void 0;
SvgIcon.muiName = 'SvgIcon';

var _default = (0, _withStyles.default)(styles, {
  name: 'MuiSvgIcon'
})(SvgIcon);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\SvgIcon\\SvgIcon.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\SvgIcon\\index.js", {"./SvgIcon":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\SvgIcon\\SvgIcon.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CSvgIcon%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _SvgIcon.default;
  }
});

var _SvgIcon = _interopRequireDefault(require("./SvgIcon"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\SvgIcon\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\TextField\\TextField.js", {"../FilledInput":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FilledInput\\index.js","../FormControl":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormControl\\index.js","../FormHelperText":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\FormHelperText\\index.js","../Input":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Input\\index.js","../InputLabel":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\InputLabel\\index.js","../OutlinedInput":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\OutlinedInput\\index.js","../Select":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Select\\index.js","../styles/withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withStyles.js","../utils/deprecatedPropType":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\deprecatedPropType.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js","clsx":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\node_modules\\clsx\\dist\\clsx.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CTextField%5CTextField.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _utils = require("@material-ui/utils");

var _deprecatedPropType = _interopRequireDefault(require("../utils/deprecatedPropType"));

var _Input = _interopRequireDefault(require("../Input"));

var _FilledInput = _interopRequireDefault(require("../FilledInput"));

var _OutlinedInput = _interopRequireDefault(require("../OutlinedInput"));

var _InputLabel = _interopRequireDefault(require("../InputLabel"));

var _FormControl = _interopRequireDefault(require("../FormControl"));

var _FormHelperText = _interopRequireDefault(require("../FormHelperText"));

var _Select = _interopRequireDefault(require("../Select"));

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var variantComponent = {
  standard: _Input.default,
  filled: _FilledInput.default,
  outlined: _OutlinedInput.default
};
var styles = {
  /* Styles applied to the root element. */
  root: {}
};
/**
 * The `TextField` is a convenience wrapper for the most common cases (80%).
 * It cannot be all things to all people, otherwise the API would grow out of control.
 *
 * ## Advanced Configuration
 *
 * It's important to understand that the text field is a simple abstraction
 * on top of the following components:
 *
 * - [FormControl](/api/form-control/)
 * - [InputLabel](/api/input-label/)
 * - [FilledInput](/api/filled-input/)
 * - [OutlinedInput](/api/outlined-input/)
 * - [Input](/api/input/)
 * - [FormHelperText](/api/form-helper-text/)
 *
 * If you wish to alter the props applied to the `input` element, you can do so as follows:
 *
 * ```jsx
 * const inputProps = {
 *   step: 300,
 * };
 *
 * return <TextField id="time" type="time" inputProps={inputProps} />;
 * ```
 *
 * For advanced cases, please look at the source of TextField by clicking on the
 * "Edit this page" button above. Consider either:
 *
 * - using the upper case props for passing values directly to the components
 * - using the underlying components directly as shown in the demos
 */

exports.styles = styles;
var TextField = /*#__PURE__*/React.forwardRef(function TextField(props, ref) {
  var autoComplete = props.autoComplete,
      _props$autoFocus = props.autoFocus,
      autoFocus = _props$autoFocus === void 0 ? false : _props$autoFocus,
      children = props.children,
      classes = props.classes,
      className = props.className,
      _props$color = props.color,
      color = _props$color === void 0 ? 'primary' : _props$color,
      defaultValue = props.defaultValue,
      _props$disabled = props.disabled,
      disabled = _props$disabled === void 0 ? false : _props$disabled,
      _props$error = props.error,
      error = _props$error === void 0 ? false : _props$error,
      FormHelperTextProps = props.FormHelperTextProps,
      _props$fullWidth = props.fullWidth,
      fullWidth = _props$fullWidth === void 0 ? false : _props$fullWidth,
      helperText = props.helperText,
      hiddenLabel = props.hiddenLabel,
      id = props.id,
      InputLabelProps = props.InputLabelProps,
      inputProps = props.inputProps,
      InputProps = props.InputProps,
      inputRef = props.inputRef,
      label = props.label,
      _props$multiline = props.multiline,
      multiline = _props$multiline === void 0 ? false : _props$multiline,
      name = props.name,
      onBlur = props.onBlur,
      onChange = props.onChange,
      onFocus = props.onFocus,
      placeholder = props.placeholder,
      _props$required = props.required,
      required = _props$required === void 0 ? false : _props$required,
      rows = props.rows,
      rowsMax = props.rowsMax,
      maxRows = props.maxRows,
      minRows = props.minRows,
      _props$select = props.select,
      select = _props$select === void 0 ? false : _props$select,
      SelectProps = props.SelectProps,
      type = props.type,
      value = props.value,
      _props$variant = props.variant,
      variant = _props$variant === void 0 ? 'standard' : _props$variant,
      other = (0, _objectWithoutProperties2.default)(props, ["autoComplete", "autoFocus", "children", "classes", "className", "color", "defaultValue", "disabled", "error", "FormHelperTextProps", "fullWidth", "helperText", "hiddenLabel", "id", "InputLabelProps", "inputProps", "InputProps", "inputRef", "label", "multiline", "name", "onBlur", "onChange", "onFocus", "placeholder", "required", "rows", "rowsMax", "maxRows", "minRows", "select", "SelectProps", "type", "value", "variant"]);

  if ("development" !== 'production') {
    if (select && !children) {
      console.error('Material-UI: `children` must be passed when using the `TextField` component with `select`.');
    }
  }

  var InputMore = {};

  if (variant === 'outlined') {
    if (InputLabelProps && typeof InputLabelProps.shrink !== 'undefined') {
      InputMore.notched = InputLabelProps.shrink;
    }

    if (label) {
      var _InputLabelProps$requ;

      var displayRequired = (_InputLabelProps$requ = InputLabelProps === null || InputLabelProps === void 0 ? void 0 : InputLabelProps.required) !== null && _InputLabelProps$requ !== void 0 ? _InputLabelProps$requ : required;
      InputMore.label = /*#__PURE__*/React.createElement(React.Fragment, null, label, displayRequired && "\xA0*");
    }
  }

  if (select) {
    // unset defaults from textbox inputs
    if (!SelectProps || !SelectProps.native) {
      InputMore.id = undefined;
    }

    InputMore['aria-describedby'] = undefined;
  }

  var helperTextId = helperText && id ? "".concat(id, "-helper-text") : undefined;
  var inputLabelId = label && id ? "".concat(id, "-label") : undefined;
  var InputComponent = variantComponent[variant];
  var InputElement = /*#__PURE__*/React.createElement(InputComponent, (0, _extends2.default)({
    "aria-describedby": helperTextId,
    autoComplete: autoComplete,
    autoFocus: autoFocus,
    defaultValue: defaultValue,
    fullWidth: fullWidth,
    multiline: multiline,
    name: name,
    rows: rows,
    rowsMax: rowsMax,
    maxRows: maxRows,
    minRows: minRows,
    type: type,
    value: value,
    id: id,
    inputRef: inputRef,
    onBlur: onBlur,
    onChange: onChange,
    onFocus: onFocus,
    placeholder: placeholder,
    inputProps: inputProps
  }, InputMore, InputProps));
  return /*#__PURE__*/React.createElement(_FormControl.default, (0, _extends2.default)({
    className: (0, _clsx.default)(classes.root, className),
    disabled: disabled,
    error: error,
    fullWidth: fullWidth,
    hiddenLabel: hiddenLabel,
    ref: ref,
    required: required,
    color: color,
    variant: variant
  }, other), label && /*#__PURE__*/React.createElement(_InputLabel.default, (0, _extends2.default)({
    htmlFor: id,
    id: inputLabelId
  }, InputLabelProps), label), select ? /*#__PURE__*/React.createElement(_Select.default, (0, _extends2.default)({
    "aria-describedby": helperTextId,
    id: id,
    labelId: inputLabelId,
    value: value,
    input: InputElement
  }, SelectProps), children) : InputElement, helperText && /*#__PURE__*/React.createElement(_FormHelperText.default, (0, _extends2.default)({
    id: helperTextId
  }, FormHelperTextProps), helperText));
});
"development" !== "production" ? TextField.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * This prop helps users to fill forms faster, especially on mobile devices.
   * The name can be confusing, as it's more like an autofill.
   * You can learn more about it [following the specification](https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#autofill).
   */
  autoComplete: _propTypes.default.string,

  /**
   * If `true`, the `input` element will be focused during the first mount.
   */
  autoFocus: _propTypes.default.bool,

  /**
   * @ignore
   */
  children: _propTypes.default.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object,

  /**
   * @ignore
   */
  className: _propTypes.default.string,

  /**
   * The color of the component. It supports those theme colors that make sense for this component.
   */
  color: _propTypes.default.oneOf(['primary', 'secondary']),

  /**
   * The default value of the `input` element.
   */
  defaultValue: _propTypes.default.any,

  /**
   * If `true`, the `input` element will be disabled.
   */
  disabled: _propTypes.default.bool,

  /**
   * If `true`, the label will be displayed in an error state.
   */
  error: _propTypes.default.bool,

  /**
   * Props applied to the [`FormHelperText`](/api/form-helper-text/) element.
   */
  FormHelperTextProps: _propTypes.default.object,

  /**
   * If `true`, the input will take up the full width of its container.
   */
  fullWidth: _propTypes.default.bool,

  /**
   * The helper text content.
   */
  helperText: _propTypes.default.node,

  /**
   * @ignore
   */
  hiddenLabel: _propTypes.default.bool,

  /**
   * The id of the `input` element.
   * Use this prop to make `label` and `helperText` accessible for screen readers.
   */
  id: _propTypes.default.string,

  /**
   * Props applied to the [`InputLabel`](/api/input-label/) element.
   */
  InputLabelProps: _propTypes.default.object,

  /**
   * [Attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Attributes) applied to the `input` element.
   */
  inputProps: _propTypes.default.object,

  /**
   * Props applied to the Input element.
   * It will be a [`FilledInput`](/api/filled-input/),
   * [`OutlinedInput`](/api/outlined-input/) or [`Input`](/api/input/)
   * component depending on the `variant` prop value.
   */
  InputProps: _propTypes.default.object,

  /**
   * Pass a ref to the `input` element.
   */
  inputRef: _utils.refType,

  /**
   * The label content.
   */
  label: _propTypes.default.node,

  /**
   * If `dense` or `normal`, will adjust vertical spacing of this and contained components.
   */
  margin: _propTypes.default.oneOf(['dense', 'none', 'normal']),

  /**
   * Maximum number of rows to display when multiline option is set to true.
   */
  maxRows: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * Minimum number of rows to display.
   */
  minRows: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * If `true`, a textarea element will be rendered instead of an input.
   */
  multiline: _propTypes.default.bool,

  /**
   * Name attribute of the `input` element.
   */
  name: _propTypes.default.string,

  /**
   * @ignore
   */
  onBlur: _propTypes.default.func,

  /**
   * Callback fired when the value is changed.
   *
   * @param {object} event The event source of the callback.
   * You can pull out the new value by accessing `event.target.value` (string).
   */
  onChange: _propTypes.default.func,

  /**
   * @ignore
   */
  onFocus: _propTypes.default.func,

  /**
   * The short hint displayed in the input before the user enters a value.
   */
  placeholder: _propTypes.default.string,

  /**
   * If `true`, the label is displayed as required and the `input` element` will be required.
   */
  required: _propTypes.default.bool,

  /**
   * Number of rows to display when multiline option is set to true.
   * @deprecated Use `minRows` instead.
   */
  rows: (0, _deprecatedPropType.default)(_propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]), 'Use `minRows` instead'),

  /**
   * Maximum number of rows to display.
   * @deprecated Use `maxRows` instead.
   */
  rowsMax: (0, _deprecatedPropType.default)(_propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]), 'Use `maxRows` instead'),

  /**
   * Render a [`Select`](/api/select/) element while passing the Input element to `Select` as `input` parameter.
   * If this option is set you must pass the options of the select as children.
   */
  select: _propTypes.default.bool,

  /**
   * Props applied to the [`Select`](/api/select/) element.
   */
  SelectProps: _propTypes.default.object,

  /**
   * The size of the text field.
   */
  size: _propTypes.default.oneOf(['medium', 'small']),

  /**
   * Type of the `input` element. It should be [a valid HTML5 input type](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Form_%3Cinput%3E_types).
   */
  type: _propTypes.default.string,

  /**
   * The value of the `input` element, required for a controlled component.
   */
  value: _propTypes.default.any,

  /**
   * The variant to use.
   */
  variant: _propTypes.default.oneOf(['filled', 'outlined', 'standard'])
} : void 0;

var _default = (0, _withStyles.default)(styles, {
  name: 'MuiTextField'
})(TextField);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\TextField\\TextField.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\TextField\\index.js", {"./TextField":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\TextField\\TextField.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CTextField%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _TextField.default;
  }
});

var _TextField = _interopRequireDefault(require("./TextField"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\TextField\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\TextareaAutosize\\TextareaAutosize.js", {"../utils/debounce":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\debounce.js","../utils/deprecatedPropType":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\deprecatedPropType.js","../utils/useForkRef":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\useForkRef.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CTextareaAutosize%5CTextareaAutosize.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _debounce = _interopRequireDefault(require("../utils/debounce"));

var _useForkRef = _interopRequireDefault(require("../utils/useForkRef"));

var _deprecatedPropType = _interopRequireDefault(require("../utils/deprecatedPropType"));

function getStyleValue(computedStyle, property) {
  return parseInt(computedStyle[property], 10) || 0;
}

var useEnhancedEffect = typeof window !== 'undefined' ? React.useLayoutEffect : React.useEffect;
var styles = {
  /* Styles applied to the shadow textarea element. */
  shadow: {
    // Visibility needed to hide the extra text area on iPads
    visibility: 'hidden',
    // Remove from the content flow
    position: 'absolute',
    // Ignore the scrollbar width
    overflow: 'hidden',
    height: 0,
    top: 0,
    left: 0,
    // Create a new layer, increase the isolation of the computed values
    transform: 'translateZ(0)'
  }
};
var TextareaAutosize = /*#__PURE__*/React.forwardRef(function TextareaAutosize(props, ref) {
  var onChange = props.onChange,
      rows = props.rows,
      rowsMax = props.rowsMax,
      rowsMinProp = props.rowsMin,
      maxRowsProp = props.maxRows,
      _props$minRows = props.minRows,
      minRowsProp = _props$minRows === void 0 ? 1 : _props$minRows,
      style = props.style,
      value = props.value,
      other = (0, _objectWithoutProperties2.default)(props, ["onChange", "rows", "rowsMax", "rowsMin", "maxRows", "minRows", "style", "value"]);
  var maxRows = maxRowsProp || rowsMax;
  var minRows = rows || rowsMinProp || minRowsProp;

  var _React$useRef = React.useRef(value != null),
      isControlled = _React$useRef.current;

  var inputRef = React.useRef(null);
  var handleRef = (0, _useForkRef.default)(ref, inputRef);
  var shadowRef = React.useRef(null);
  var renders = React.useRef(0);

  var _React$useState = React.useState({}),
      state = _React$useState[0],
      setState = _React$useState[1];

  var syncHeight = React.useCallback(function () {
    var input = inputRef.current;
    var computedStyle = window.getComputedStyle(input);
    var inputShallow = shadowRef.current;
    inputShallow.style.width = computedStyle.width;
    inputShallow.value = input.value || props.placeholder || 'x';

    if (inputShallow.value.slice(-1) === '\n') {
      // Certain fonts which overflow the line height will cause the textarea
      // to report a different scrollHeight depending on whether the last line
      // is empty. Make it non-empty to avoid this issue.
      inputShallow.value += ' ';
    }

    var boxSizing = computedStyle['box-sizing'];
    var padding = getStyleValue(computedStyle, 'padding-bottom') + getStyleValue(computedStyle, 'padding-top');
    var border = getStyleValue(computedStyle, 'border-bottom-width') + getStyleValue(computedStyle, 'border-top-width'); // The height of the inner content

    var innerHeight = inputShallow.scrollHeight - padding; // Measure height of a textarea with a single row

    inputShallow.value = 'x';
    var singleRowHeight = inputShallow.scrollHeight - padding; // The height of the outer content

    var outerHeight = innerHeight;

    if (minRows) {
      outerHeight = Math.max(Number(minRows) * singleRowHeight, outerHeight);
    }

    if (maxRows) {
      outerHeight = Math.min(Number(maxRows) * singleRowHeight, outerHeight);
    }

    outerHeight = Math.max(outerHeight, singleRowHeight); // Take the box sizing into account for applying this value as a style.

    var outerHeightStyle = outerHeight + (boxSizing === 'border-box' ? padding + border : 0);
    var overflow = Math.abs(outerHeight - innerHeight) <= 1;
    setState(function (prevState) {
      // Need a large enough difference to update the height.
      // This prevents infinite rendering loop.
      if (renders.current < 20 && (outerHeightStyle > 0 && Math.abs((prevState.outerHeightStyle || 0) - outerHeightStyle) > 1 || prevState.overflow !== overflow)) {
        renders.current += 1;
        return {
          overflow: overflow,
          outerHeightStyle: outerHeightStyle
        };
      }

      if ("development" !== 'production') {
        if (renders.current === 20) {
          console.error(['Material-UI: Too many re-renders. The layout is unstable.', 'TextareaAutosize limits the number of renders to prevent an infinite loop.'].join('\n'));
        }
      }

      return prevState;
    });
  }, [maxRows, minRows, props.placeholder]);
  React.useEffect(function () {
    var handleResize = (0, _debounce.default)(function () {
      renders.current = 0;
      syncHeight();
    });
    window.addEventListener('resize', handleResize);
    return function () {
      handleResize.clear();
      window.removeEventListener('resize', handleResize);
    };
  }, [syncHeight]);
  useEnhancedEffect(function () {
    syncHeight();
  });
  React.useEffect(function () {
    renders.current = 0;
  }, [value]);

  var handleChange = function handleChange(event) {
    renders.current = 0;

    if (!isControlled) {
      syncHeight();
    }

    if (onChange) {
      onChange(event);
    }
  };

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("textarea", (0, _extends2.default)({
    value: value,
    onChange: handleChange,
    ref: handleRef // Apply the rows prop to get a "correct" first SSR paint
    ,
    rows: minRows,
    style: (0, _extends2.default)({
      height: state.outerHeightStyle,
      // Need a large enough difference to allow scrolling.
      // This prevents infinite rendering loop.
      overflow: state.overflow ? 'hidden' : null
    }, style)
  }, other)), /*#__PURE__*/React.createElement("textarea", {
    "aria-hidden": true,
    className: props.className,
    readOnly: true,
    ref: shadowRef,
    tabIndex: -1,
    style: (0, _extends2.default)({}, styles.shadow, style)
  }));
});
"development" !== "production" ? TextareaAutosize.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * @ignore
   */
  className: _propTypes.default.string,

  /**
   * Maximum number of rows to display.
   */
  maxRows: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * Minimum number of rows to display.
   */
  minRows: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * @ignore
   */
  onChange: _propTypes.default.func,

  /**
   * @ignore
   */
  placeholder: _propTypes.default.string,

  /**
   * Minimum number of rows to display.
   * @deprecated Use `minRows` instead.
   */
  rows: (0, _deprecatedPropType.default)(_propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]), 'Use `minRows` instead.'),

  /**
   * Maximum number of rows to display.
   * @deprecated Use `maxRows` instead.
   */
  rowsMax: (0, _deprecatedPropType.default)(_propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]), 'Use `maxRows` instead.'),

  /**
   * Minimum number of rows to display.
   * @deprecated Use `minRows` instead.
   */
  rowsMin: (0, _deprecatedPropType.default)(_propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]), 'Use `minRows` instead.'),

  /**
   * @ignore
   */
  style: _propTypes.default.object,

  /**
   * @ignore
   */
  value: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.string), _propTypes.default.number, _propTypes.default.string])
} : void 0;
var _default = TextareaAutosize;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\TextareaAutosize\\TextareaAutosize.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\TextareaAutosize\\index.js", {"./TextareaAutosize":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\TextareaAutosize\\TextareaAutosize.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CTextareaAutosize%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _TextareaAutosize.default;
  }
});

var _TextareaAutosize = _interopRequireDefault(require("./TextareaAutosize"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\TextareaAutosize\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Tooltip\\Tooltip.js", {"../Grow":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Grow\\index.js","../Popper":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Popper\\index.js","../styles/colorManipulator":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\colorManipulator.js","../styles/useTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\useTheme.js","../styles/withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withStyles.js","../utils/capitalize":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\capitalize.js","../utils/setRef":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\setRef.js","../utils/unstable_useId":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\unstable_useId.js","../utils/useControlled":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\useControlled.js","../utils/useForkRef":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\useForkRef.js","../utils/useIsFocusVisible":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\useIsFocusVisible.js","@babel/runtime/helpers/defineProperty":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\defineProperty.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@babel/runtime/helpers/slicedToArray":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\slicedToArray.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js","clsx":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\node_modules\\clsx\\dist\\clsx.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CTooltip%5CTooltip.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testReset = testReset;
exports.default = exports.styles = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var React = _interopRequireWildcard(require("react"));

var ReactDOM = _interopRequireWildcard(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _utils = require("@material-ui/utils");

var _colorManipulator = require("../styles/colorManipulator");

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var _capitalize = _interopRequireDefault(require("../utils/capitalize"));

var _Grow = _interopRequireDefault(require("../Grow"));

var _Popper = _interopRequireDefault(require("../Popper"));

var _useForkRef = _interopRequireDefault(require("../utils/useForkRef"));

var _unstable_useId = _interopRequireDefault(require("../utils/unstable_useId"));

var _setRef = _interopRequireDefault(require("../utils/setRef"));

var _useIsFocusVisible2 = _interopRequireDefault(require("../utils/useIsFocusVisible"));

var _useControlled3 = _interopRequireDefault(require("../utils/useControlled"));

var _useTheme = _interopRequireDefault(require("../styles/useTheme"));

function round(value) {
  return Math.round(value * 1e5) / 1e5;
}

function arrowGenerator() {
  return {
    '&[x-placement*="bottom"] $arrow': {
      top: 0,
      left: 0,
      marginTop: '-0.71em',
      marginLeft: 4,
      marginRight: 4,
      '&::before': {
        transformOrigin: '0 100%'
      }
    },
    '&[x-placement*="top"] $arrow': {
      bottom: 0,
      left: 0,
      marginBottom: '-0.71em',
      marginLeft: 4,
      marginRight: 4,
      '&::before': {
        transformOrigin: '100% 0'
      }
    },
    '&[x-placement*="right"] $arrow': {
      left: 0,
      marginLeft: '-0.71em',
      height: '1em',
      width: '0.71em',
      marginTop: 4,
      marginBottom: 4,
      '&::before': {
        transformOrigin: '100% 100%'
      }
    },
    '&[x-placement*="left"] $arrow': {
      right: 0,
      marginRight: '-0.71em',
      height: '1em',
      width: '0.71em',
      marginTop: 4,
      marginBottom: 4,
      '&::before': {
        transformOrigin: '0 0'
      }
    }
  };
}

var styles = function styles(theme) {
  return {
    /* Styles applied to the Popper component. */
    popper: {
      zIndex: theme.zIndex.tooltip,
      pointerEvents: 'none' // disable jss-rtl plugin

    },

    /* Styles applied to the Popper component if `interactive={true}`. */
    popperInteractive: {
      pointerEvents: 'auto'
    },

    /* Styles applied to the Popper component if `arrow={true}`. */
    popperArrow: arrowGenerator(),

    /* Styles applied to the tooltip (label wrapper) element. */
    tooltip: {
      backgroundColor: (0, _colorManipulator.alpha)(theme.palette.grey[700], 0.9),
      borderRadius: theme.shape.borderRadius,
      color: theme.palette.common.white,
      fontFamily: theme.typography.fontFamily,
      padding: '4px 8px',
      fontSize: theme.typography.pxToRem(10),
      lineHeight: "".concat(round(14 / 10), "em"),
      maxWidth: 300,
      wordWrap: 'break-word',
      fontWeight: theme.typography.fontWeightMedium
    },

    /* Styles applied to the tooltip (label wrapper) element if `arrow={true}`. */
    tooltipArrow: {
      position: 'relative',
      margin: '0'
    },

    /* Styles applied to the arrow element. */
    arrow: {
      overflow: 'hidden',
      position: 'absolute',
      width: '1em',
      height: '0.71em'
      /* = width / sqrt(2) = (length of the hypotenuse) */
      ,
      boxSizing: 'border-box',
      color: (0, _colorManipulator.alpha)(theme.palette.grey[700], 0.9),
      '&::before': {
        content: '""',
        margin: 'auto',
        display: 'block',
        width: '100%',
        height: '100%',
        backgroundColor: 'currentColor',
        transform: 'rotate(45deg)'
      }
    },

    /* Styles applied to the tooltip (label wrapper) element if the tooltip is opened by touch. */
    touch: {
      padding: '8px 16px',
      fontSize: theme.typography.pxToRem(14),
      lineHeight: "".concat(round(16 / 14), "em"),
      fontWeight: theme.typography.fontWeightRegular
    },

    /* Styles applied to the tooltip (label wrapper) element if `placement` contains "left". */
    tooltipPlacementLeft: (0, _defineProperty2.default)({
      transformOrigin: 'right center',
      margin: '0 24px '
    }, theme.breakpoints.up('sm'), {
      margin: '0 14px'
    }),

    /* Styles applied to the tooltip (label wrapper) element if `placement` contains "right". */
    tooltipPlacementRight: (0, _defineProperty2.default)({
      transformOrigin: 'left center',
      margin: '0 24px'
    }, theme.breakpoints.up('sm'), {
      margin: '0 14px'
    }),

    /* Styles applied to the tooltip (label wrapper) element if `placement` contains "top". */
    tooltipPlacementTop: (0, _defineProperty2.default)({
      transformOrigin: 'center bottom',
      margin: '24px 0'
    }, theme.breakpoints.up('sm'), {
      margin: '14px 0'
    }),

    /* Styles applied to the tooltip (label wrapper) element if `placement` contains "bottom". */
    tooltipPlacementBottom: (0, _defineProperty2.default)({
      transformOrigin: 'center top',
      margin: '24px 0'
    }, theme.breakpoints.up('sm'), {
      margin: '14px 0'
    })
  };
};

exports.styles = styles;
var hystersisOpen = false;
var hystersisTimer = null;

function testReset() {
  hystersisOpen = false;
  clearTimeout(hystersisTimer);
}

var Tooltip = /*#__PURE__*/React.forwardRef(function Tooltip(props, ref) {
  var _props$arrow = props.arrow,
      arrow = _props$arrow === void 0 ? false : _props$arrow,
      children = props.children,
      classes = props.classes,
      _props$disableFocusLi = props.disableFocusListener,
      disableFocusListener = _props$disableFocusLi === void 0 ? false : _props$disableFocusLi,
      _props$disableHoverLi = props.disableHoverListener,
      disableHoverListener = _props$disableHoverLi === void 0 ? false : _props$disableHoverLi,
      _props$disableTouchLi = props.disableTouchListener,
      disableTouchListener = _props$disableTouchLi === void 0 ? false : _props$disableTouchLi,
      _props$enterDelay = props.enterDelay,
      enterDelay = _props$enterDelay === void 0 ? 100 : _props$enterDelay,
      _props$enterNextDelay = props.enterNextDelay,
      enterNextDelay = _props$enterNextDelay === void 0 ? 0 : _props$enterNextDelay,
      _props$enterTouchDela = props.enterTouchDelay,
      enterTouchDelay = _props$enterTouchDela === void 0 ? 700 : _props$enterTouchDela,
      idProp = props.id,
      _props$interactive = props.interactive,
      interactive = _props$interactive === void 0 ? false : _props$interactive,
      _props$leaveDelay = props.leaveDelay,
      leaveDelay = _props$leaveDelay === void 0 ? 0 : _props$leaveDelay,
      _props$leaveTouchDela = props.leaveTouchDelay,
      leaveTouchDelay = _props$leaveTouchDela === void 0 ? 1500 : _props$leaveTouchDela,
      onClose = props.onClose,
      onOpen = props.onOpen,
      openProp = props.open,
      _props$placement = props.placement,
      placement = _props$placement === void 0 ? 'bottom' : _props$placement,
      _props$PopperComponen = props.PopperComponent,
      PopperComponent = _props$PopperComponen === void 0 ? _Popper.default : _props$PopperComponen,
      PopperProps = props.PopperProps,
      title = props.title,
      _props$TransitionComp = props.TransitionComponent,
      TransitionComponent = _props$TransitionComp === void 0 ? _Grow.default : _props$TransitionComp,
      TransitionProps = props.TransitionProps,
      other = (0, _objectWithoutProperties2.default)(props, ["arrow", "children", "classes", "disableFocusListener", "disableHoverListener", "disableTouchListener", "enterDelay", "enterNextDelay", "enterTouchDelay", "id", "interactive", "leaveDelay", "leaveTouchDelay", "onClose", "onOpen", "open", "placement", "PopperComponent", "PopperProps", "title", "TransitionComponent", "TransitionProps"]);
  var theme = (0, _useTheme.default)();

  var _React$useState = React.useState(),
      childNode = _React$useState[0],
      setChildNode = _React$useState[1];

  var _React$useState2 = React.useState(null),
      arrowRef = _React$useState2[0],
      setArrowRef = _React$useState2[1];

  var ignoreNonTouchEvents = React.useRef(false);
  var closeTimer = React.useRef();
  var enterTimer = React.useRef();
  var leaveTimer = React.useRef();
  var touchTimer = React.useRef();

  var _useControlled = (0, _useControlled3.default)({
    controlled: openProp,
    default: false,
    name: 'Tooltip',
    state: 'open'
  }),
      _useControlled2 = (0, _slicedToArray2.default)(_useControlled, 2),
      openState = _useControlled2[0],
      setOpenState = _useControlled2[1];

  var open = openState;

  if ("development" !== 'production') {
    // eslint-disable-next-line react-hooks/rules-of-hooks
    var _React$useRef = React.useRef(openProp !== undefined),
        isControlled = _React$useRef.current; // eslint-disable-next-line react-hooks/rules-of-hooks


    React.useEffect(function () {
      if (childNode && childNode.disabled && !isControlled && title !== '' && childNode.tagName.toLowerCase() === 'button') {
        console.error(['Material-UI: You are providing a disabled `button` child to the Tooltip component.', 'A disabled element does not fire events.', "Tooltip needs to listen to the child element's events to display the title.", '', 'Add a simple wrapper element, such as a `span`.'].join('\n'));
      }
    }, [title, childNode, isControlled]);
  }

  var id = (0, _unstable_useId.default)(idProp);
  React.useEffect(function () {
    return function () {
      clearTimeout(closeTimer.current);
      clearTimeout(enterTimer.current);
      clearTimeout(leaveTimer.current);
      clearTimeout(touchTimer.current);
    };
  }, []);

  var handleOpen = function handleOpen(event) {
    clearTimeout(hystersisTimer);
    hystersisOpen = true; // The mouseover event will trigger for every nested element in the tooltip.
    // We can skip rerendering when the tooltip is already open.
    // We are using the mouseover event instead of the mouseenter event to fix a hide/show issue.

    setOpenState(true);

    if (onOpen) {
      onOpen(event);
    }
  };

  var handleEnter = function handleEnter() {
    var forward = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
    return function (event) {
      var childrenProps = children.props;

      if (event.type === 'mouseover' && childrenProps.onMouseOver && forward) {
        childrenProps.onMouseOver(event);
      }

      if (ignoreNonTouchEvents.current && event.type !== 'touchstart') {
        return;
      } // Remove the title ahead of time.
      // We don't want to wait for the next render commit.
      // We would risk displaying two tooltips at the same time (native + this one).


      if (childNode) {
        childNode.removeAttribute('title');
      }

      clearTimeout(enterTimer.current);
      clearTimeout(leaveTimer.current);

      if (enterDelay || hystersisOpen && enterNextDelay) {
        event.persist();
        enterTimer.current = setTimeout(function () {
          handleOpen(event);
        }, hystersisOpen ? enterNextDelay : enterDelay);
      } else {
        handleOpen(event);
      }
    };
  };

  var _useIsFocusVisible = (0, _useIsFocusVisible2.default)(),
      isFocusVisible = _useIsFocusVisible.isFocusVisible,
      onBlurVisible = _useIsFocusVisible.onBlurVisible,
      focusVisibleRef = _useIsFocusVisible.ref;

  var _React$useState3 = React.useState(false),
      childIsFocusVisible = _React$useState3[0],
      setChildIsFocusVisible = _React$useState3[1];

  var handleBlur = function handleBlur() {
    if (childIsFocusVisible) {
      setChildIsFocusVisible(false);
      onBlurVisible();
    }
  };

  var handleFocus = function handleFocus() {
    var forward = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
    return function (event) {
      // Workaround for https://github.com/facebook/react/issues/7769
      // The autoFocus of React might trigger the event before the componentDidMount.
      // We need to account for this eventuality.
      if (!childNode) {
        setChildNode(event.currentTarget);
      }

      if (isFocusVisible(event)) {
        setChildIsFocusVisible(true);
        handleEnter()(event);
      }

      var childrenProps = children.props;

      if (childrenProps.onFocus && forward) {
        childrenProps.onFocus(event);
      }
    };
  };

  var handleClose = function handleClose(event) {
    clearTimeout(hystersisTimer);
    hystersisTimer = setTimeout(function () {
      hystersisOpen = false;
    }, 800 + leaveDelay);
    setOpenState(false);

    if (onClose) {
      onClose(event);
    }

    clearTimeout(closeTimer.current);
    closeTimer.current = setTimeout(function () {
      ignoreNonTouchEvents.current = false;
    }, theme.transitions.duration.shortest);
  };

  var handleLeave = function handleLeave() {
    var forward = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
    return function (event) {
      var childrenProps = children.props;

      if (event.type === 'blur') {
        if (childrenProps.onBlur && forward) {
          childrenProps.onBlur(event);
        }

        handleBlur();
      }

      if (event.type === 'mouseleave' && childrenProps.onMouseLeave && event.currentTarget === childNode) {
        childrenProps.onMouseLeave(event);
      }

      clearTimeout(enterTimer.current);
      clearTimeout(leaveTimer.current);
      event.persist();
      leaveTimer.current = setTimeout(function () {
        handleClose(event);
      }, leaveDelay);
    };
  };

  var detectTouchStart = function detectTouchStart(event) {
    ignoreNonTouchEvents.current = true;
    var childrenProps = children.props;

    if (childrenProps.onTouchStart) {
      childrenProps.onTouchStart(event);
    }
  };

  var handleTouchStart = function handleTouchStart(event) {
    detectTouchStart(event);
    clearTimeout(leaveTimer.current);
    clearTimeout(closeTimer.current);
    clearTimeout(touchTimer.current);
    event.persist();
    touchTimer.current = setTimeout(function () {
      handleEnter()(event);
    }, enterTouchDelay);
  };

  var handleTouchEnd = function handleTouchEnd(event) {
    if (children.props.onTouchEnd) {
      children.props.onTouchEnd(event);
    }

    clearTimeout(touchTimer.current);
    clearTimeout(leaveTimer.current);
    event.persist();
    leaveTimer.current = setTimeout(function () {
      handleClose(event);
    }, leaveTouchDelay);
  };

  var handleUseRef = (0, _useForkRef.default)(setChildNode, ref);
  var handleFocusRef = (0, _useForkRef.default)(focusVisibleRef, handleUseRef); // can be removed once we drop support for non ref forwarding class components

  var handleOwnRef = React.useCallback(function (instance) {
    // #StrictMode ready
    (0, _setRef.default)(handleFocusRef, ReactDOM.findDOMNode(instance));
  }, [handleFocusRef]);
  var handleRef = (0, _useForkRef.default)(children.ref, handleOwnRef); // There is no point in displaying an empty tooltip.

  if (title === '') {
    open = false;
  } // For accessibility and SEO concerns, we render the title to the DOM node when
  // the tooltip is hidden. However, we have made a tradeoff when
  // `disableHoverListener` is set. This title logic is disabled.
  // It's allowing us to keep the implementation size minimal.
  // We are open to change the tradeoff.


  var shouldShowNativeTitle = !open && !disableHoverListener;
  var childrenProps = (0, _extends2.default)({
    'aria-describedby': open ? id : null,
    title: shouldShowNativeTitle && typeof title === 'string' ? title : null
  }, other, children.props, {
    className: (0, _clsx.default)(other.className, children.props.className),
    onTouchStart: detectTouchStart,
    ref: handleRef
  });
  var interactiveWrapperListeners = {};

  if (!disableTouchListener) {
    childrenProps.onTouchStart = handleTouchStart;
    childrenProps.onTouchEnd = handleTouchEnd;
  }

  if (!disableHoverListener) {
    childrenProps.onMouseOver = handleEnter();
    childrenProps.onMouseLeave = handleLeave();

    if (interactive) {
      interactiveWrapperListeners.onMouseOver = handleEnter(false);
      interactiveWrapperListeners.onMouseLeave = handleLeave(false);
    }
  }

  if (!disableFocusListener) {
    childrenProps.onFocus = handleFocus();
    childrenProps.onBlur = handleLeave();

    if (interactive) {
      interactiveWrapperListeners.onFocus = handleFocus(false);
      interactiveWrapperListeners.onBlur = handleLeave(false);
    }
  }

  if ("development" !== 'production') {
    if (children.props.title) {
      console.error(['Material-UI: You have provided a `title` prop to the child of <Tooltip />.', "Remove this title prop `".concat(children.props.title, "` or the Tooltip component.")].join('\n'));
    }
  }

  var mergedPopperProps = React.useMemo(function () {
    return (0, _utils.deepmerge)({
      popperOptions: {
        modifiers: {
          arrow: {
            enabled: Boolean(arrowRef),
            element: arrowRef
          }
        }
      }
    }, PopperProps);
  }, [arrowRef, PopperProps]);
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.cloneElement(children, childrenProps), /*#__PURE__*/React.createElement(PopperComponent, (0, _extends2.default)({
    className: (0, _clsx.default)(classes.popper, interactive && classes.popperInteractive, arrow && classes.popperArrow),
    placement: placement,
    anchorEl: childNode,
    open: childNode ? open : false,
    id: childrenProps['aria-describedby'],
    transition: true
  }, interactiveWrapperListeners, mergedPopperProps), function (_ref) {
    var placementInner = _ref.placement,
        TransitionPropsInner = _ref.TransitionProps;
    return /*#__PURE__*/React.createElement(TransitionComponent, (0, _extends2.default)({
      timeout: theme.transitions.duration.shorter
    }, TransitionPropsInner, TransitionProps), /*#__PURE__*/React.createElement("div", {
      className: (0, _clsx.default)(classes.tooltip, classes["tooltipPlacement".concat((0, _capitalize.default)(placementInner.split('-')[0]))], ignoreNonTouchEvents.current && classes.touch, arrow && classes.tooltipArrow)
    }, title, arrow ? /*#__PURE__*/React.createElement("span", {
      className: classes.arrow,
      ref: setArrowRef
    }) : null));
  }));
});
"development" !== "production" ? Tooltip.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * If `true`, adds an arrow to the tooltip.
   */
  arrow: _propTypes.default.bool,

  /**
   * Tooltip reference element.
   */
  children: _utils.elementAcceptingRef.isRequired,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object,

  /**
   * @ignore
   */
  className: _propTypes.default.string,

  /**
   * Do not respond to focus events.
   */
  disableFocusListener: _propTypes.default.bool,

  /**
   * Do not respond to hover events.
   */
  disableHoverListener: _propTypes.default.bool,

  /**
   * Do not respond to long press touch events.
   */
  disableTouchListener: _propTypes.default.bool,

  /**
   * The number of milliseconds to wait before showing the tooltip.
   * This prop won't impact the enter touch delay (`enterTouchDelay`).
   */
  enterDelay: _propTypes.default.number,

  /**
   * The number of milliseconds to wait before showing the tooltip when one was already recently opened.
   */
  enterNextDelay: _propTypes.default.number,

  /**
   * The number of milliseconds a user must touch the element before showing the tooltip.
   */
  enterTouchDelay: _propTypes.default.number,

  /**
   * This prop is used to help implement the accessibility logic.
   * If you don't provide this prop. It falls back to a randomly generated id.
   */
  id: _propTypes.default.string,

  /**
   * Makes a tooltip interactive, i.e. will not close when the user
   * hovers over the tooltip before the `leaveDelay` is expired.
   */
  interactive: _propTypes.default.bool,

  /**
   * The number of milliseconds to wait before hiding the tooltip.
   * This prop won't impact the leave touch delay (`leaveTouchDelay`).
   */
  leaveDelay: _propTypes.default.number,

  /**
   * The number of milliseconds after the user stops touching an element before hiding the tooltip.
   */
  leaveTouchDelay: _propTypes.default.number,

  /**
   * Callback fired when the component requests to be closed.
   *
   * @param {object} event The event source of the callback.
   */
  onClose: _propTypes.default.func,

  /**
   * Callback fired when the component requests to be open.
   *
   * @param {object} event The event source of the callback.
   */
  onOpen: _propTypes.default.func,

  /**
   * If `true`, the tooltip is shown.
   */
  open: _propTypes.default.bool,

  /**
   * Tooltip placement.
   */
  placement: _propTypes.default.oneOf(['bottom-end', 'bottom-start', 'bottom', 'left-end', 'left-start', 'left', 'right-end', 'right-start', 'right', 'top-end', 'top-start', 'top']),

  /**
   * The component used for the popper.
   */
  PopperComponent: _propTypes.default.elementType,

  /**
   * Props applied to the [`Popper`](/api/popper/) element.
   */
  PopperProps: _propTypes.default.object,

  /**
   * Tooltip title. Zero-length titles string are never displayed.
   */
  title: _propTypes.default
  /* @typescript-to-proptypes-ignore */
  .node.isRequired,

  /**
   * The component used for the transition.
   * [Follow this guide](/components/transitions/#transitioncomponent-prop) to learn more about the requirements for this component.
   */
  TransitionComponent: _propTypes.default.elementType,

  /**
   * Props applied to the [`Transition`](http://reactcommunity.org/react-transition-group/transition#Transition-props) element.
   */
  TransitionProps: _propTypes.default.object
} : void 0;

var _default = (0, _withStyles.default)(styles, {
  name: 'MuiTooltip',
  flip: false
})(Tooltip);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Tooltip\\Tooltip.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Tooltip\\index.js", {"./Tooltip":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Tooltip\\Tooltip.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CTooltip%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _Tooltip.default;
  }
});

var _Tooltip = _interopRequireDefault(require("./Tooltip"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Tooltip\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Typography\\Typography.js", {"../styles/withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withStyles.js","../utils/capitalize":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\capitalize.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","clsx":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\node_modules\\clsx\\dist\\clsx.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CTypography%5CTypography.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var React = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _withStyles = _interopRequireDefault(require("../styles/withStyles"));

var _capitalize = _interopRequireDefault(require("../utils/capitalize"));

var styles = function styles(theme) {
  return {
    /* Styles applied to the root element. */
    root: {
      margin: 0
    },

    /* Styles applied to the root element if `variant="body2"`. */
    body2: theme.typography.body2,

    /* Styles applied to the root element if `variant="body1"`. */
    body1: theme.typography.body1,

    /* Styles applied to the root element if `variant="caption"`. */
    caption: theme.typography.caption,

    /* Styles applied to the root element if `variant="button"`. */
    button: theme.typography.button,

    /* Styles applied to the root element if `variant="h1"`. */
    h1: theme.typography.h1,

    /* Styles applied to the root element if `variant="h2"`. */
    h2: theme.typography.h2,

    /* Styles applied to the root element if `variant="h3"`. */
    h3: theme.typography.h3,

    /* Styles applied to the root element if `variant="h4"`. */
    h4: theme.typography.h4,

    /* Styles applied to the root element if `variant="h5"`. */
    h5: theme.typography.h5,

    /* Styles applied to the root element if `variant="h6"`. */
    h6: theme.typography.h6,

    /* Styles applied to the root element if `variant="subtitle1"`. */
    subtitle1: theme.typography.subtitle1,

    /* Styles applied to the root element if `variant="subtitle2"`. */
    subtitle2: theme.typography.subtitle2,

    /* Styles applied to the root element if `variant="overline"`. */
    overline: theme.typography.overline,

    /* Styles applied to the root element if `variant="srOnly"`. Only accessible to screen readers. */
    srOnly: {
      position: 'absolute',
      height: 1,
      width: 1,
      overflow: 'hidden'
    },

    /* Styles applied to the root element if `align="left"`. */
    alignLeft: {
      textAlign: 'left'
    },

    /* Styles applied to the root element if `align="center"`. */
    alignCenter: {
      textAlign: 'center'
    },

    /* Styles applied to the root element if `align="right"`. */
    alignRight: {
      textAlign: 'right'
    },

    /* Styles applied to the root element if `align="justify"`. */
    alignJustify: {
      textAlign: 'justify'
    },

    /* Styles applied to the root element if `nowrap={true}`. */
    noWrap: {
      overflow: 'hidden',
      textOverflow: 'ellipsis',
      whiteSpace: 'nowrap'
    },

    /* Styles applied to the root element if `gutterBottom={true}`. */
    gutterBottom: {
      marginBottom: '0.35em'
    },

    /* Styles applied to the root element if `paragraph={true}`. */
    paragraph: {
      marginBottom: 16
    },

    /* Styles applied to the root element if `color="inherit"`. */
    colorInherit: {
      color: 'inherit'
    },

    /* Styles applied to the root element if `color="primary"`. */
    colorPrimary: {
      color: theme.palette.primary.main
    },

    /* Styles applied to the root element if `color="secondary"`. */
    colorSecondary: {
      color: theme.palette.secondary.main
    },

    /* Styles applied to the root element if `color="textPrimary"`. */
    colorTextPrimary: {
      color: theme.palette.text.primary
    },

    /* Styles applied to the root element if `color="textSecondary"`. */
    colorTextSecondary: {
      color: theme.palette.text.secondary
    },

    /* Styles applied to the root element if `color="error"`. */
    colorError: {
      color: theme.palette.error.main
    },

    /* Styles applied to the root element if `display="inline"`. */
    displayInline: {
      display: 'inline'
    },

    /* Styles applied to the root element if `display="block"`. */
    displayBlock: {
      display: 'block'
    }
  };
};

exports.styles = styles;
var defaultVariantMapping = {
  h1: 'h1',
  h2: 'h2',
  h3: 'h3',
  h4: 'h4',
  h5: 'h5',
  h6: 'h6',
  subtitle1: 'h6',
  subtitle2: 'h6',
  body1: 'p',
  body2: 'p'
};
var Typography = /*#__PURE__*/React.forwardRef(function Typography(props, ref) {
  var _props$align = props.align,
      align = _props$align === void 0 ? 'inherit' : _props$align,
      classes = props.classes,
      className = props.className,
      _props$color = props.color,
      color = _props$color === void 0 ? 'initial' : _props$color,
      component = props.component,
      _props$display = props.display,
      display = _props$display === void 0 ? 'initial' : _props$display,
      _props$gutterBottom = props.gutterBottom,
      gutterBottom = _props$gutterBottom === void 0 ? false : _props$gutterBottom,
      _props$noWrap = props.noWrap,
      noWrap = _props$noWrap === void 0 ? false : _props$noWrap,
      _props$paragraph = props.paragraph,
      paragraph = _props$paragraph === void 0 ? false : _props$paragraph,
      _props$variant = props.variant,
      variant = _props$variant === void 0 ? 'body1' : _props$variant,
      _props$variantMapping = props.variantMapping,
      variantMapping = _props$variantMapping === void 0 ? defaultVariantMapping : _props$variantMapping,
      other = (0, _objectWithoutProperties2.default)(props, ["align", "classes", "className", "color", "component", "display", "gutterBottom", "noWrap", "paragraph", "variant", "variantMapping"]);
  var Component = component || (paragraph ? 'p' : variantMapping[variant] || defaultVariantMapping[variant]) || 'span';
  return /*#__PURE__*/React.createElement(Component, (0, _extends2.default)({
    className: (0, _clsx.default)(classes.root, className, variant !== 'inherit' && classes[variant], color !== 'initial' && classes["color".concat((0, _capitalize.default)(color))], noWrap && classes.noWrap, gutterBottom && classes.gutterBottom, paragraph && classes.paragraph, align !== 'inherit' && classes["align".concat((0, _capitalize.default)(align))], display !== 'initial' && classes["display".concat((0, _capitalize.default)(display))]),
    ref: ref
  }, other));
});
"development" !== "production" ? Typography.propTypes = {
  /**
   * Set the text-align on the component.
   */
  align: _propTypes.default.oneOf(['inherit', 'left', 'center', 'right', 'justify']),

  /**
   * The content of the component.
   */
  children: _propTypes.default.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object.isRequired,

  /**
   * @ignore
   */
  className: _propTypes.default.string,

  /**
   * The color of the component. It supports those theme colors that make sense for this component.
   */
  color: _propTypes.default.oneOf(['initial', 'inherit', 'primary', 'secondary', 'textPrimary', 'textSecondary', 'error']),

  /**
   * The component used for the root node.
   * Either a string to use a HTML element or a component.
   * Overrides the behavior of the `variantMapping` prop.
   */
  component: _propTypes.default
  /* @typescript-to-proptypes-ignore */
  .elementType,

  /**
   * Controls the display type
   */
  display: _propTypes.default.oneOf(['initial', 'block', 'inline']),

  /**
   * If `true`, the text will have a bottom margin.
   */
  gutterBottom: _propTypes.default.bool,

  /**
   * If `true`, the text will not wrap, but instead will truncate with a text overflow ellipsis.
   *
   * Note that text overflow can only happen with block or inline-block level elements
   * (the element needs to have a width in order to overflow).
   */
  noWrap: _propTypes.default.bool,

  /**
   * If `true`, the text will have a bottom margin.
   */
  paragraph: _propTypes.default.bool,

  /**
   * Applies the theme typography styles.
   */
  variant: _propTypes.default.oneOf(['h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'subtitle1', 'subtitle2', 'body1', 'body2', 'caption', 'button', 'overline', 'srOnly', 'inherit']),

  /**
   * The component maps the variant prop to a range of different HTML element types.
   * For instance, subtitle1 to `<h6>`.
   * If you wish to change that mapping, you can provide your own.
   * Alternatively, you can use the `component` prop.
   */
  variantMapping: _propTypes.default.object
} : void 0;

var _default = (0, _withStyles.default)(styles, {
  name: 'MuiTypography'
})(Typography);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Typography\\Typography.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Typography\\index.js", {"./Typography":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Typography\\Typography.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CTypography%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _Typography.default;
  }
});

var _Typography = _interopRequireDefault(require("./Typography"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Typography\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Unstable_TrapFocus\\Unstable_TrapFocus.js", {"../utils/ownerDocument":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\ownerDocument.js","../utils/useForkRef":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\useForkRef.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CUnstable_TrapFocus%5CUnstable_TrapFocus.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var ReactDOM = _interopRequireWildcard(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _ownerDocument = _interopRequireDefault(require("../utils/ownerDocument"));

var _useForkRef = _interopRequireDefault(require("../utils/useForkRef"));

var _utils = require("@material-ui/utils");

/* eslint-disable consistent-return, jsx-a11y/no-noninteractive-tabindex, camelcase */

/**
 * Utility component that locks focus inside the component.
 */
function Unstable_TrapFocus(props) {
  var children = props.children,
      _props$disableAutoFoc = props.disableAutoFocus,
      disableAutoFocus = _props$disableAutoFoc === void 0 ? false : _props$disableAutoFoc,
      _props$disableEnforce = props.disableEnforceFocus,
      disableEnforceFocus = _props$disableEnforce === void 0 ? false : _props$disableEnforce,
      _props$disableRestore = props.disableRestoreFocus,
      disableRestoreFocus = _props$disableRestore === void 0 ? false : _props$disableRestore,
      getDoc = props.getDoc,
      isEnabled = props.isEnabled,
      open = props.open;
  var ignoreNextEnforceFocus = React.useRef();
  var sentinelStart = React.useRef(null);
  var sentinelEnd = React.useRef(null);
  var nodeToRestore = React.useRef();
  var rootRef = React.useRef(null); // can be removed once we drop support for non ref forwarding class components

  var handleOwnRef = React.useCallback(function (instance) {
    // #StrictMode ready
    rootRef.current = ReactDOM.findDOMNode(instance);
  }, []);
  var handleRef = (0, _useForkRef.default)(children.ref, handleOwnRef);
  var prevOpenRef = React.useRef();
  React.useEffect(function () {
    prevOpenRef.current = open;
  }, [open]);

  if (!prevOpenRef.current && open && typeof window !== 'undefined') {
    // WARNING: Potentially unsafe in concurrent mode.
    // The way the read on `nodeToRestore` is setup could make this actually safe.
    // Say we render `open={false}` -> `open={true}` but never commit.
    // We have now written a state that wasn't committed. But no committed effect
    // will read this wrong value. We only read from `nodeToRestore` in effects
    // that were committed on `open={true}`
    // WARNING: Prevents the instance from being garbage collected. Should only
    // hold a weak ref.
    nodeToRestore.current = getDoc().activeElement;
  }

  React.useEffect(function () {
    if (!open) {
      return;
    }

    var doc = (0, _ownerDocument.default)(rootRef.current); // We might render an empty child.

    if (!disableAutoFocus && rootRef.current && !rootRef.current.contains(doc.activeElement)) {
      if (!rootRef.current.hasAttribute('tabIndex')) {
        if ("development" !== 'production') {
          console.error(['Material-UI: The modal content node does not accept focus.', 'For the benefit of assistive technologies, ' + 'the tabIndex of the node is being set to "-1".'].join('\n'));
        }

        rootRef.current.setAttribute('tabIndex', -1);
      }

      rootRef.current.focus();
    }

    var contain = function contain() {
      var rootElement = rootRef.current; // Cleanup functions are executed lazily in React 17.
      // Contain can be called between the component being unmounted and its cleanup function being run.

      if (rootElement === null) {
        return;
      }

      if (!doc.hasFocus() || disableEnforceFocus || !isEnabled() || ignoreNextEnforceFocus.current) {
        ignoreNextEnforceFocus.current = false;
        return;
      }

      if (rootRef.current && !rootRef.current.contains(doc.activeElement)) {
        rootRef.current.focus();
      }
    };

    var loopFocus = function loopFocus(event) {
      // 9 = Tab
      if (disableEnforceFocus || !isEnabled() || event.keyCode !== 9) {
        return;
      } // Make sure the next tab starts from the right place.


      if (doc.activeElement === rootRef.current) {
        // We need to ignore the next contain as
        // it will try to move the focus back to the rootRef element.
        ignoreNextEnforceFocus.current = true;

        if (event.shiftKey) {
          sentinelEnd.current.focus();
        } else {
          sentinelStart.current.focus();
        }
      }
    };

    doc.addEventListener('focus', contain, true);
    doc.addEventListener('keydown', loopFocus, true); // With Edge, Safari and Firefox, no focus related events are fired when the focused area stops being a focused area
    // e.g. https://bugzilla.mozilla.org/show_bug.cgi?id=559561.
    //
    // The whatwg spec defines how the browser should behave but does not explicitly mention any events:
    // https://html.spec.whatwg.org/multipage/interaction.html#focus-fixup-rule.

    var interval = setInterval(function () {
      contain();
    }, 50);
    return function () {
      clearInterval(interval);
      doc.removeEventListener('focus', contain, true);
      doc.removeEventListener('keydown', loopFocus, true); // restoreLastFocus()

      if (!disableRestoreFocus) {
        // In IE 11 it is possible for document.activeElement to be null resulting
        // in nodeToRestore.current being null.
        // Not all elements in IE 11 have a focus method.
        // Once IE 11 support is dropped the focus() call can be unconditional.
        if (nodeToRestore.current && nodeToRestore.current.focus) {
          nodeToRestore.current.focus();
        }

        nodeToRestore.current = null;
      }
    };
  }, [disableAutoFocus, disableEnforceFocus, disableRestoreFocus, isEnabled, open]);
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("div", {
    tabIndex: 0,
    ref: sentinelStart,
    "data-test": "sentinelStart"
  }), /*#__PURE__*/React.cloneElement(children, {
    ref: handleRef
  }), /*#__PURE__*/React.createElement("div", {
    tabIndex: 0,
    ref: sentinelEnd,
    "data-test": "sentinelEnd"
  }));
}

"development" !== "production" ? Unstable_TrapFocus.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit the d.ts file and run "yarn proptypes"     |
  // ----------------------------------------------------------------------

  /**
   * A single child content element.
   */
  children: _propTypes.default.node,

  /**
   * If `true`, the trap focus will not automatically shift focus to itself when it opens, and
   * replace it to the last focused element when it closes.
   * This also works correctly with any trap focus children that have the `disableAutoFocus` prop.
   *
   * Generally this should never be set to `true` as it makes the trap focus less
   * accessible to assistive technologies, like screen readers.
   */
  disableAutoFocus: _propTypes.default.bool,

  /**
   * If `true`, the trap focus will not prevent focus from leaving the trap focus while open.
   *
   * Generally this should never be set to `true` as it makes the trap focus less
   * accessible to assistive technologies, like screen readers.
   */
  disableEnforceFocus: _propTypes.default.bool,

  /**
   * If `true`, the trap focus will not restore focus to previously focused element once
   * trap focus is hidden.
   */
  disableRestoreFocus: _propTypes.default.bool,

  /**
   * Return the document to consider.
   * We use it to implement the restore focus between different browser documents.
   */
  getDoc: _propTypes.default.func.isRequired,

  /**
   * Do we still want to enforce the focus?
   * This prop helps nesting TrapFocus elements.
   */
  isEnabled: _propTypes.default.func.isRequired,

  /**
   * If `true`, focus will be locked.
   */
  open: _propTypes.default.bool.isRequired
} : void 0;

if ("development" !== 'production') {
  // eslint-disable-next-line
  Unstable_TrapFocus['propTypes' + ''] = (0, _utils.exactProp)(Unstable_TrapFocus.propTypes);
}

var _default = Unstable_TrapFocus;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Unstable_TrapFocus\\Unstable_TrapFocus.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Unstable_TrapFocus\\index.js", {"./Unstable_TrapFocus":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\Unstable_TrapFocus\\Unstable_TrapFocus.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5CUnstable_TrapFocus%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _Unstable_TrapFocus.default;
  }
});

var _Unstable_TrapFocus = _interopRequireDefault(require("./Unstable_TrapFocus"));
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\Unstable_TrapFocus\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\colors\\blue.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Ccolors%5Cblue.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var blue = {
  50: '#e3f2fd',
  100: '#bbdefb',
  200: '#90caf9',
  300: '#64b5f6',
  400: '#42a5f5',
  500: '#2196f3',
  600: '#1e88e5',
  700: '#1976d2',
  800: '#1565c0',
  900: '#0d47a1',
  A100: '#82b1ff',
  A200: '#448aff',
  A400: '#2979ff',
  A700: '#2962ff'
};
var _default = blue;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\colors\\blue.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\colors\\common.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Ccolors%5Ccommon.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var common = {
  black: '#000',
  white: '#fff'
};
var _default = common;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\colors\\common.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\colors\\green.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Ccolors%5Cgreen.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var green = {
  50: '#e8f5e9',
  100: '#c8e6c9',
  200: '#a5d6a7',
  300: '#81c784',
  400: '#66bb6a',
  500: '#4caf50',
  600: '#43a047',
  700: '#388e3c',
  800: '#2e7d32',
  900: '#1b5e20',
  A100: '#b9f6ca',
  A200: '#69f0ae',
  A400: '#00e676',
  A700: '#00c853'
};
var _default = green;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\colors\\green.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\colors\\grey.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Ccolors%5Cgrey.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var grey = {
  50: '#fafafa',
  100: '#f5f5f5',
  200: '#eeeeee',
  300: '#e0e0e0',
  400: '#bdbdbd',
  500: '#9e9e9e',
  600: '#757575',
  700: '#616161',
  800: '#424242',
  900: '#212121',
  A100: '#d5d5d5',
  A200: '#aaaaaa',
  A400: '#303030',
  A700: '#616161'
};
var _default = grey;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\colors\\grey.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\colors\\indigo.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Ccolors%5Cindigo.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var indigo = {
  50: '#e8eaf6',
  100: '#c5cae9',
  200: '#9fa8da',
  300: '#7986cb',
  400: '#5c6bc0',
  500: '#3f51b5',
  600: '#3949ab',
  700: '#303f9f',
  800: '#283593',
  900: '#1a237e',
  A100: '#8c9eff',
  A200: '#536dfe',
  A400: '#3d5afe',
  A700: '#304ffe'
};
var _default = indigo;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\colors\\indigo.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\colors\\orange.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Ccolors%5Corange.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var orange = {
  50: '#fff3e0',
  100: '#ffe0b2',
  200: '#ffcc80',
  300: '#ffb74d',
  400: '#ffa726',
  500: '#ff9800',
  600: '#fb8c00',
  700: '#f57c00',
  800: '#ef6c00',
  900: '#e65100',
  A100: '#ffd180',
  A200: '#ffab40',
  A400: '#ff9100',
  A700: '#ff6d00'
};
var _default = orange;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\colors\\orange.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\colors\\pink.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Ccolors%5Cpink.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var pink = {
  50: '#fce4ec',
  100: '#f8bbd0',
  200: '#f48fb1',
  300: '#f06292',
  400: '#ec407a',
  500: '#e91e63',
  600: '#d81b60',
  700: '#c2185b',
  800: '#ad1457',
  900: '#880e4f',
  A100: '#ff80ab',
  A200: '#ff4081',
  A400: '#f50057',
  A700: '#c51162'
};
var _default = pink;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\colors\\pink.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\colors\\red.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Ccolors%5Cred.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var red = {
  50: '#ffebee',
  100: '#ffcdd2',
  200: '#ef9a9a',
  300: '#e57373',
  400: '#ef5350',
  500: '#f44336',
  600: '#e53935',
  700: '#d32f2f',
  800: '#c62828',
  900: '#b71c1c',
  A100: '#ff8a80',
  A200: '#ff5252',
  A400: '#ff1744',
  A700: '#d50000'
};
var _default = red;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\colors\\red.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\internal\\svg-icons\\ArrowDropDown.js", {"../../utils/createSvgIcon":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\createSvgIcon.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cinternal%5Csvg-icons%5CArrowDropDown.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _createSvgIcon = _interopRequireDefault(require("../../utils/createSvgIcon"));

/**
 * @ignore - internal component.
 */
var _default = (0, _createSvgIcon.default)( /*#__PURE__*/React.createElement("path", {
  d: "M7 10l5 5 5-5z"
}), 'ArrowDropDown');

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\internal\\svg-icons\\ArrowDropDown.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\node_modules\\clsx\\dist\\clsx.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cnode_modules%5Cclsx%5Cdist%5Cclsx.js
      return function (require, module, exports) {
function toVal(mix) {
	var k, y, str='';

	if (typeof mix === 'string' || typeof mix === 'number') {
		str += mix;
	} else if (typeof mix === 'object') {
		if (Array.isArray(mix)) {
			for (k=0; k < mix.length; k++) {
				if (mix[k]) {
					if (y = toVal(mix[k])) {
						str && (str += ' ');
						str += y;
					}
				}
			}
		} else {
			for (k in mix) {
				if (mix[k]) {
					str && (str += ' ');
					str += k;
				}
			}
		}
	}

	return str;
}

module.exports = function () {
	var i=0, tmp, x, str='';
	while (i < arguments.length) {
		if (tmp = arguments[i++]) {
			if (x = toVal(tmp)) {
				str && (str += ' ');
				str += x
			}
		}
	}
	return str;
}

      };
    };
  }
  }
}, {package:"@material-ui/core>clsx",file:"node_modules\\@material-ui\\core\\node_modules\\clsx\\dist\\clsx.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\colorManipulator.js", {"@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cstyles%5CcolorManipulator.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hexToRgb = hexToRgb;
exports.rgbToHex = rgbToHex;
exports.hslToRgb = hslToRgb;
exports.decomposeColor = decomposeColor;
exports.recomposeColor = recomposeColor;
exports.getContrastRatio = getContrastRatio;
exports.getLuminance = getLuminance;
exports.emphasize = emphasize;
exports.fade = fade;
exports.alpha = alpha;
exports.darken = darken;
exports.lighten = lighten;

var _utils = require("@material-ui/utils");

/* eslint-disable no-use-before-define */

/**
 * Returns a number whose value is limited to the given range.
 *
 * @param {number} value The value to be clamped
 * @param {number} min The lower boundary of the output range
 * @param {number} max The upper boundary of the output range
 * @returns {number} A number in the range [min, max]
 */
function clamp(value) {
  var min = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
  var max = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;

  if ("development" !== 'production') {
    if (value < min || value > max) {
      console.error("Material-UI: The value provided ".concat(value, " is out of range [").concat(min, ", ").concat(max, "]."));
    }
  }

  return Math.min(Math.max(min, value), max);
}
/**
 * Converts a color from CSS hex format to CSS rgb format.
 *
 * @param {string} color - Hex color, i.e. #nnn or #nnnnnn
 * @returns {string} A CSS rgb color string
 */


function hexToRgb(color) {
  color = color.substr(1);
  var re = new RegExp(".{1,".concat(color.length >= 6 ? 2 : 1, "}"), 'g');
  var colors = color.match(re);

  if (colors && colors[0].length === 1) {
    colors = colors.map(function (n) {
      return n + n;
    });
  }

  return colors ? "rgb".concat(colors.length === 4 ? 'a' : '', "(").concat(colors.map(function (n, index) {
    return index < 3 ? parseInt(n, 16) : Math.round(parseInt(n, 16) / 255 * 1000) / 1000;
  }).join(', '), ")") : '';
}

function intToHex(int) {
  var hex = int.toString(16);
  return hex.length === 1 ? "0".concat(hex) : hex;
}
/**
 * Converts a color from CSS rgb format to CSS hex format.
 *
 * @param {string} color - RGB color, i.e. rgb(n, n, n)
 * @returns {string} A CSS rgb color string, i.e. #nnnnnn
 */


function rgbToHex(color) {
  // Idempotent
  if (color.indexOf('#') === 0) {
    return color;
  }

  var _decomposeColor = decomposeColor(color),
      values = _decomposeColor.values;

  return "#".concat(values.map(function (n) {
    return intToHex(n);
  }).join(''));
}
/**
 * Converts a color from hsl format to rgb format.
 *
 * @param {string} color - HSL color values
 * @returns {string} rgb color values
 */


function hslToRgb(color) {
  color = decomposeColor(color);
  var _color = color,
      values = _color.values;
  var h = values[0];
  var s = values[1] / 100;
  var l = values[2] / 100;
  var a = s * Math.min(l, 1 - l);

  var f = function f(n) {
    var k = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : (n + h / 30) % 12;
    return l - a * Math.max(Math.min(k - 3, 9 - k, 1), -1);
  };

  var type = 'rgb';
  var rgb = [Math.round(f(0) * 255), Math.round(f(8) * 255), Math.round(f(4) * 255)];

  if (color.type === 'hsla') {
    type += 'a';
    rgb.push(values[3]);
  }

  return recomposeColor({
    type: type,
    values: rgb
  });
}
/**
 * Returns an object with the type and values of a color.
 *
 * Note: Does not support rgb % values.
 *
 * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
 * @returns {object} - A MUI color object: {type: string, values: number[]}
 */


function decomposeColor(color) {
  // Idempotent
  if (color.type) {
    return color;
  }

  if (color.charAt(0) === '#') {
    return decomposeColor(hexToRgb(color));
  }

  var marker = color.indexOf('(');
  var type = color.substring(0, marker);

  if (['rgb', 'rgba', 'hsl', 'hsla'].indexOf(type) === -1) {
    throw new Error("development" !== "production" ? "Material-UI: Unsupported `".concat(color, "` color.\nWe support the following formats: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla().") : (0, _utils.formatMuiErrorMessage)(3, color));
  }

  var values = color.substring(marker + 1, color.length - 1).split(',');
  values = values.map(function (value) {
    return parseFloat(value);
  });
  return {
    type: type,
    values: values
  };
}
/**
 * Converts a color object with type and values to a string.
 *
 * @param {object} color - Decomposed color
 * @param {string} color.type - One of: 'rgb', 'rgba', 'hsl', 'hsla'
 * @param {array} color.values - [n,n,n] or [n,n,n,n]
 * @returns {string} A CSS color string
 */


function recomposeColor(color) {
  var type = color.type;
  var values = color.values;

  if (type.indexOf('rgb') !== -1) {
    // Only convert the first 3 values to int (i.e. not alpha)
    values = values.map(function (n, i) {
      return i < 3 ? parseInt(n, 10) : n;
    });
  } else if (type.indexOf('hsl') !== -1) {
    values[1] = "".concat(values[1], "%");
    values[2] = "".concat(values[2], "%");
  }

  return "".concat(type, "(").concat(values.join(', '), ")");
}
/**
 * Calculates the contrast ratio between two colors.
 *
 * Formula: https://www.w3.org/TR/WCAG20-TECHS/G17.html#G17-tests
 *
 * @param {string} foreground - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
 * @param {string} background - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
 * @returns {number} A contrast ratio value in the range 0 - 21.
 */


function getContrastRatio(foreground, background) {
  var lumA = getLuminance(foreground);
  var lumB = getLuminance(background);
  return (Math.max(lumA, lumB) + 0.05) / (Math.min(lumA, lumB) + 0.05);
}
/**
 * The relative brightness of any point in a color space,
 * normalized to 0 for darkest black and 1 for lightest white.
 *
 * Formula: https://www.w3.org/TR/WCAG20-TECHS/G17.html#G17-tests
 *
 * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
 * @returns {number} The relative brightness of the color in the range 0 - 1
 */


function getLuminance(color) {
  color = decomposeColor(color);
  var rgb = color.type === 'hsl' ? decomposeColor(hslToRgb(color)).values : color.values;
  rgb = rgb.map(function (val) {
    val /= 255; // normalized

    return val <= 0.03928 ? val / 12.92 : Math.pow((val + 0.055) / 1.055, 2.4);
  }); // Truncate at 3 digits

  return Number((0.2126 * rgb[0] + 0.7152 * rgb[1] + 0.0722 * rgb[2]).toFixed(3));
}
/**
 * Darken or lighten a color, depending on its luminance.
 * Light colors are darkened, dark colors are lightened.
 *
 * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
 * @param {number} coefficient=0.15 - multiplier in the range 0 - 1
 * @returns {string} A CSS color string. Hex input values are returned as rgb
 */


function emphasize(color) {
  var coefficient = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0.15;
  return getLuminance(color) > 0.5 ? darken(color, coefficient) : lighten(color, coefficient);
}

var warnedOnce = false;
/**
 * Set the absolute transparency of a color.
 * Any existing alpha values are overwritten.
 *
 * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
 * @param {number} value - value to set the alpha channel to in the range 0 -1
 * @returns {string} A CSS color string. Hex input values are returned as rgb
 *
 * @deprecated
 * Use `import { alpha } from '@material-ui/core/styles'` instead.
 */

function fade(color, value) {
  if ("development" !== 'production') {
    if (!warnedOnce) {
      warnedOnce = true;
      console.error(['Material-UI: The `fade` color utility was renamed to `alpha` to better describe its functionality.', '', "You should use `import { alpha } from '@material-ui/core/styles'`"].join('\n'));
    }
  }

  return alpha(color, value);
}
/**
 * Set the absolute transparency of a color.
 * Any existing alpha value is overwritten.
 *
 * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
 * @param {number} value - value to set the alpha channel to in the range 0-1
 * @returns {string} A CSS color string. Hex input values are returned as rgb
 */


function alpha(color, value) {
  color = decomposeColor(color);
  value = clamp(value);

  if (color.type === 'rgb' || color.type === 'hsl') {
    color.type += 'a';
  }

  color.values[3] = value;
  return recomposeColor(color);
}
/**
 * Darkens a color.
 *
 * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
 * @param {number} coefficient - multiplier in the range 0 - 1
 * @returns {string} A CSS color string. Hex input values are returned as rgb
 */


function darken(color, coefficient) {
  color = decomposeColor(color);
  coefficient = clamp(coefficient);

  if (color.type.indexOf('hsl') !== -1) {
    color.values[2] *= 1 - coefficient;
  } else if (color.type.indexOf('rgb') !== -1) {
    for (var i = 0; i < 3; i += 1) {
      color.values[i] *= 1 - coefficient;
    }
  }

  return recomposeColor(color);
}
/**
 * Lightens a color.
 *
 * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
 * @param {number} coefficient - multiplier in the range 0 - 1
 * @returns {string} A CSS color string. Hex input values are returned as rgb
 */


function lighten(color, coefficient) {
  color = decomposeColor(color);
  coefficient = clamp(coefficient);

  if (color.type.indexOf('hsl') !== -1) {
    color.values[2] += (100 - color.values[2]) * coefficient;
  } else if (color.type.indexOf('rgb') !== -1) {
    for (var i = 0; i < 3; i += 1) {
      color.values[i] += (255 - color.values[i]) * coefficient;
    }
  }

  return recomposeColor(color);
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\styles\\colorManipulator.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\createBreakpoints.js", {"@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cstyles%5CcreateBreakpoints.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createBreakpoints;
exports.keys = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

// Sorted ASC by size. That's important.
// It can't be configured as it's used statically for propTypes.
var keys = ['xs', 'sm', 'md', 'lg', 'xl']; // Keep in mind that @media is inclusive by the CSS specification.

exports.keys = keys;

function createBreakpoints(breakpoints) {
  var _breakpoints$values = breakpoints.values,
      values = _breakpoints$values === void 0 ? {
    xs: 0,
    sm: 600,
    md: 960,
    lg: 1280,
    xl: 1920
  } : _breakpoints$values,
      _breakpoints$unit = breakpoints.unit,
      unit = _breakpoints$unit === void 0 ? 'px' : _breakpoints$unit,
      _breakpoints$step = breakpoints.step,
      step = _breakpoints$step === void 0 ? 5 : _breakpoints$step,
      other = (0, _objectWithoutProperties2.default)(breakpoints, ["values", "unit", "step"]);

  function up(key) {
    var value = typeof values[key] === 'number' ? values[key] : key;
    return "@media (min-width:".concat(value).concat(unit, ")");
  }

  function down(key) {
    var endIndex = keys.indexOf(key) + 1;
    var upperbound = values[keys[endIndex]];

    if (endIndex === keys.length) {
      // xl down applies to all sizes
      return up('xs');
    }

    var value = typeof upperbound === 'number' && endIndex > 0 ? upperbound : key;
    return "@media (max-width:".concat(value - step / 100).concat(unit, ")");
  }

  function between(start, end) {
    var endIndex = keys.indexOf(end);

    if (endIndex === keys.length - 1) {
      return up(start);
    }

    return "@media (min-width:".concat(typeof values[start] === 'number' ? values[start] : start).concat(unit, ") and ") + "(max-width:".concat((endIndex !== -1 && typeof values[keys[endIndex + 1]] === 'number' ? values[keys[endIndex + 1]] : end) - step / 100).concat(unit, ")");
  }

  function only(key) {
    return between(key, key);
  }

  var warnedOnce = false;

  function width(key) {
    if ("development" !== 'production') {
      if (!warnedOnce) {
        warnedOnce = true;
        console.warn(["Material-UI: The `theme.breakpoints.width` utility is deprecated because it's redundant.", 'Use the `theme.breakpoints.values` instead.'].join('\n'));
      }
    }

    return values[key];
  }

  return (0, _extends2.default)({
    keys: keys,
    values: values,
    up: up,
    down: down,
    between: between,
    only: only,
    width: width
  }, other);
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\styles\\createBreakpoints.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\createMixins.js", {"@babel/runtime/helpers/defineProperty":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\defineProperty.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cstyles%5CcreateMixins.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createMixins;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _extends3 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

function createMixins(breakpoints, spacing, mixins) {
  var _toolbar;

  return (0, _extends3.default)({
    gutters: function gutters() {
      var styles = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      console.warn(['Material-UI: theme.mixins.gutters() is deprecated.', 'You can use the source of the mixin directly:', "\n      paddingLeft: theme.spacing(2),\n      paddingRight: theme.spacing(2),\n      [theme.breakpoints.up('sm')]: {\n        paddingLeft: theme.spacing(3),\n        paddingRight: theme.spacing(3),\n      },\n      "].join('\n'));
      return (0, _extends3.default)({
        paddingLeft: spacing(2),
        paddingRight: spacing(2)
      }, styles, (0, _defineProperty2.default)({}, breakpoints.up('sm'), (0, _extends3.default)({
        paddingLeft: spacing(3),
        paddingRight: spacing(3)
      }, styles[breakpoints.up('sm')])));
    },
    toolbar: (_toolbar = {
      minHeight: 56
    }, (0, _defineProperty2.default)(_toolbar, "".concat(breakpoints.up('xs'), " and (orientation: landscape)"), {
      minHeight: 48
    }), (0, _defineProperty2.default)(_toolbar, breakpoints.up('sm'), {
      minHeight: 64
    }), _toolbar)
  }, mixins);
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\styles\\createMixins.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\createMuiStrictModeTheme.js", {"./createTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\createTheme.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cstyles%5CcreateMuiStrictModeTheme.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createMuiStrictModeTheme;

var _utils = require("@material-ui/utils");

var _createTheme = _interopRequireDefault(require("./createTheme"));

function createMuiStrictModeTheme(options) {
  for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    args[_key - 1] = arguments[_key];
  }

  return _createTheme.default.apply(void 0, [(0, _utils.deepmerge)({
    unstable_strictMode: true
  }, options)].concat(args));
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\styles\\createMuiStrictModeTheme.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\createPalette.js", {"../colors/blue":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\colors\\blue.js","../colors/common":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\colors\\common.js","../colors/green":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\colors\\green.js","../colors/grey":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\colors\\grey.js","../colors/indigo":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\colors\\indigo.js","../colors/orange":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\colors\\orange.js","../colors/pink":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\colors\\pink.js","../colors/red":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\colors\\red.js","./colorManipulator":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\colorManipulator.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cstyles%5CcreatePalette.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createPalette;
exports.dark = exports.light = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _utils = require("@material-ui/utils");

var _common = _interopRequireDefault(require("../colors/common"));

var _grey = _interopRequireDefault(require("../colors/grey"));

var _indigo = _interopRequireDefault(require("../colors/indigo"));

var _pink = _interopRequireDefault(require("../colors/pink"));

var _red = _interopRequireDefault(require("../colors/red"));

var _orange = _interopRequireDefault(require("../colors/orange"));

var _blue = _interopRequireDefault(require("../colors/blue"));

var _green = _interopRequireDefault(require("../colors/green"));

var _colorManipulator = require("./colorManipulator");

var light = {
  // The colors used to style the text.
  text: {
    // The most important text.
    primary: 'rgba(0, 0, 0, 0.87)',
    // Secondary text.
    secondary: 'rgba(0, 0, 0, 0.54)',
    // Disabled text have even lower visual prominence.
    disabled: 'rgba(0, 0, 0, 0.38)',
    // Text hints.
    hint: 'rgba(0, 0, 0, 0.38)'
  },
  // The color used to divide different elements.
  divider: 'rgba(0, 0, 0, 0.12)',
  // The background colors used to style the surfaces.
  // Consistency between these values is important.
  background: {
    paper: _common.default.white,
    default: _grey.default[50]
  },
  // The colors used to style the action elements.
  action: {
    // The color of an active action like an icon button.
    active: 'rgba(0, 0, 0, 0.54)',
    // The color of an hovered action.
    hover: 'rgba(0, 0, 0, 0.04)',
    hoverOpacity: 0.04,
    // The color of a selected action.
    selected: 'rgba(0, 0, 0, 0.08)',
    selectedOpacity: 0.08,
    // The color of a disabled action.
    disabled: 'rgba(0, 0, 0, 0.26)',
    // The background color of a disabled action.
    disabledBackground: 'rgba(0, 0, 0, 0.12)',
    disabledOpacity: 0.38,
    focus: 'rgba(0, 0, 0, 0.12)',
    focusOpacity: 0.12,
    activatedOpacity: 0.12
  }
};
exports.light = light;
var dark = {
  text: {
    primary: _common.default.white,
    secondary: 'rgba(255, 255, 255, 0.7)',
    disabled: 'rgba(255, 255, 255, 0.5)',
    hint: 'rgba(255, 255, 255, 0.5)',
    icon: 'rgba(255, 255, 255, 0.5)'
  },
  divider: 'rgba(255, 255, 255, 0.12)',
  background: {
    paper: _grey.default[800],
    default: '#303030'
  },
  action: {
    active: _common.default.white,
    hover: 'rgba(255, 255, 255, 0.08)',
    hoverOpacity: 0.08,
    selected: 'rgba(255, 255, 255, 0.16)',
    selectedOpacity: 0.16,
    disabled: 'rgba(255, 255, 255, 0.3)',
    disabledBackground: 'rgba(255, 255, 255, 0.12)',
    disabledOpacity: 0.38,
    focus: 'rgba(255, 255, 255, 0.12)',
    focusOpacity: 0.12,
    activatedOpacity: 0.24
  }
};
exports.dark = dark;

function addLightOrDark(intent, direction, shade, tonalOffset) {
  var tonalOffsetLight = tonalOffset.light || tonalOffset;
  var tonalOffsetDark = tonalOffset.dark || tonalOffset * 1.5;

  if (!intent[direction]) {
    if (intent.hasOwnProperty(shade)) {
      intent[direction] = intent[shade];
    } else if (direction === 'light') {
      intent.light = (0, _colorManipulator.lighten)(intent.main, tonalOffsetLight);
    } else if (direction === 'dark') {
      intent.dark = (0, _colorManipulator.darken)(intent.main, tonalOffsetDark);
    }
  }
}

function createPalette(palette) {
  var _palette$primary = palette.primary,
      primary = _palette$primary === void 0 ? {
    light: _indigo.default[300],
    main: _indigo.default[500],
    dark: _indigo.default[700]
  } : _palette$primary,
      _palette$secondary = palette.secondary,
      secondary = _palette$secondary === void 0 ? {
    light: _pink.default.A200,
    main: _pink.default.A400,
    dark: _pink.default.A700
  } : _palette$secondary,
      _palette$error = palette.error,
      error = _palette$error === void 0 ? {
    light: _red.default[300],
    main: _red.default[500],
    dark: _red.default[700]
  } : _palette$error,
      _palette$warning = palette.warning,
      warning = _palette$warning === void 0 ? {
    light: _orange.default[300],
    main: _orange.default[500],
    dark: _orange.default[700]
  } : _palette$warning,
      _palette$info = palette.info,
      info = _palette$info === void 0 ? {
    light: _blue.default[300],
    main: _blue.default[500],
    dark: _blue.default[700]
  } : _palette$info,
      _palette$success = palette.success,
      success = _palette$success === void 0 ? {
    light: _green.default[300],
    main: _green.default[500],
    dark: _green.default[700]
  } : _palette$success,
      _palette$type = palette.type,
      type = _palette$type === void 0 ? 'light' : _palette$type,
      _palette$contrastThre = palette.contrastThreshold,
      contrastThreshold = _palette$contrastThre === void 0 ? 3 : _palette$contrastThre,
      _palette$tonalOffset = palette.tonalOffset,
      tonalOffset = _palette$tonalOffset === void 0 ? 0.2 : _palette$tonalOffset,
      other = (0, _objectWithoutProperties2.default)(palette, ["primary", "secondary", "error", "warning", "info", "success", "type", "contrastThreshold", "tonalOffset"]); // Use the same logic as
  // Bootstrap: https://github.com/twbs/bootstrap/blob/1d6e3710dd447de1a200f29e8fa521f8a0908f70/scss/_functions.scss#L59
  // and material-components-web https://github.com/material-components/material-components-web/blob/ac46b8863c4dab9fc22c4c662dc6bd1b65dd652f/packages/mdc-theme/_functions.scss#L54

  function getContrastText(background) {
    var contrastText = (0, _colorManipulator.getContrastRatio)(background, dark.text.primary) >= contrastThreshold ? dark.text.primary : light.text.primary;

    if ("development" !== 'production') {
      var contrast = (0, _colorManipulator.getContrastRatio)(background, contrastText);

      if (contrast < 3) {
        console.error(["Material-UI: The contrast ratio of ".concat(contrast, ":1 for ").concat(contrastText, " on ").concat(background), 'falls below the WCAG recommended absolute minimum contrast ratio of 3:1.', 'https://www.w3.org/TR/2008/REC-WCAG20-20081211/#visual-audio-contrast-contrast'].join('\n'));
      }
    }

    return contrastText;
  }

  var augmentColor = function augmentColor(color) {
    var mainShade = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 500;
    var lightShade = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 300;
    var darkShade = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 700;
    color = (0, _extends2.default)({}, color);

    if (!color.main && color[mainShade]) {
      color.main = color[mainShade];
    }

    if (!color.main) {
      throw new Error("development" !== "production" ? "Material-UI: The color provided to augmentColor(color) is invalid.\nThe color object needs to have a `main` property or a `".concat(mainShade, "` property.") : (0, _utils.formatMuiErrorMessage)(4, mainShade));
    }

    if (typeof color.main !== 'string') {
      throw new Error("development" !== "production" ? "Material-UI: The color provided to augmentColor(color) is invalid.\n`color.main` should be a string, but `".concat(JSON.stringify(color.main), "` was provided instead.\n\nDid you intend to use one of the following approaches?\n\nimport {\xA0green } from \"@material-ui/core/colors\";\n\nconst theme1 = createTheme({ palette: {\n  primary: green,\n} });\n\nconst theme2 = createTheme({ palette: {\n  primary: { main: green[500] },\n} });") : _formatMuiErrorMessage(5, JSON.stringify(color.main)));
    }

    addLightOrDark(color, 'light', lightShade, tonalOffset);
    addLightOrDark(color, 'dark', darkShade, tonalOffset);

    if (!color.contrastText) {
      color.contrastText = getContrastText(color.main);
    }

    return color;
  };

  var types = {
    dark: dark,
    light: light
  };

  if ("development" !== 'production') {
    if (!types[type]) {
      console.error("Material-UI: The palette type `".concat(type, "` is not supported."));
    }
  }

  var paletteOutput = (0, _utils.deepmerge)((0, _extends2.default)({
    // A collection of common colors.
    common: _common.default,
    // The palette type, can be light or dark.
    type: type,
    // The colors used to represent primary interface elements for a user.
    primary: augmentColor(primary),
    // The colors used to represent secondary interface elements for a user.
    secondary: augmentColor(secondary, 'A400', 'A200', 'A700'),
    // The colors used to represent interface elements that the user should be made aware of.
    error: augmentColor(error),
    // The colors used to represent potentially dangerous actions or important messages.
    warning: augmentColor(warning),
    // The colors used to present information to the user that is neutral and not necessarily important.
    info: augmentColor(info),
    // The colors used to indicate the successful completion of an action that user triggered.
    success: augmentColor(success),
    // The grey colors.
    grey: _grey.default,
    // Used by `getContrastText()` to maximize the contrast between
    // the background and the text.
    contrastThreshold: contrastThreshold,
    // Takes a background color and returns the text color that maximizes the contrast.
    getContrastText: getContrastText,
    // Generate a rich color object.
    augmentColor: augmentColor,
    // Used by the functions below to shift a color's luminance by approximately
    // two indexes within its tonal palette.
    // E.g., shift from Red 500 to Red 300 or Red 700.
    tonalOffset: tonalOffset
  }, types[type]), other);
  return paletteOutput;
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\styles\\createPalette.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\createSpacing.js", {"@material-ui/system":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cstyles%5CcreateSpacing.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createSpacing;

var _system = require("@material-ui/system");

var warnOnce;

function createSpacing() {
  var spacingInput = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 8;

  // Already transformed.
  if (spacingInput.mui) {
    return spacingInput;
  } // Material Design layouts are visually balanced. Most measurements align to an 8dp grid applied, which aligns both spacing and the overall layout.
  // Smaller components, such as icons and type, can align to a 4dp grid.
  // https://material.io/design/layout/understanding-layout.html#usage


  var transform = (0, _system.createUnarySpacing)({
    spacing: spacingInput
  });

  var spacing = function spacing() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    if ("development" !== 'production') {
      if (!(args.length <= 4)) {
        console.error("Material-UI: Too many arguments provided, expected between 0 and 4, got ".concat(args.length));
      }
    }

    if (args.length === 0) {
      return transform(1);
    }

    if (args.length === 1) {
      return transform(args[0]);
    }

    return args.map(function (argument) {
      if (typeof argument === 'string') {
        return argument;
      }

      var output = transform(argument);
      return typeof output === 'number' ? "".concat(output, "px") : output;
    }).join(' ');
  }; // Backward compatibility, to remove in v5.


  Object.defineProperty(spacing, 'unit', {
    get: function get() {
      if ("development" !== 'production') {
        if (!warnOnce || "development" === 'test') {
          console.error(['Material-UI: theme.spacing.unit usage has been deprecated.', 'It will be removed in v5.', 'You can replace `theme.spacing.unit * y` with `theme.spacing(y)`.', '', 'You can use the `https://github.com/mui-org/material-ui/tree/master/packages/material-ui-codemod/README.md#theme-spacing-api` migration helper to make the process smoother.'].join('\n'));
        }

        warnOnce = true;
      }

      return spacingInput;
    }
  });
  spacing.mui = true;
  return spacing;
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\styles\\createSpacing.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\createStyles.js", {"@material-ui/styles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cstyles%5CcreateStyles.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createStyles;

var _styles = require("@material-ui/styles");

// let warnOnce = false;
// To remove in v5
function createStyles(styles) {
  // warning(
  //   warnOnce,
  //   [
  //     'Material-UI: createStyles from @material-ui/core/styles is deprecated.',
  //     'Please use @material-ui/styles/createStyles',
  //   ].join('\n'),
  // );
  // warnOnce = true;
  return (0, _styles.createStyles)(styles);
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\styles\\createStyles.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\createTheme.js", {"./createBreakpoints":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\createBreakpoints.js","./createMixins":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\createMixins.js","./createPalette":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\createPalette.js","./createSpacing":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\createSpacing.js","./createTypography":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\createTypography.js","./shadows":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\shadows.js","./shape":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\shape.js","./transitions":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\transitions.js","./zIndex":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\zIndex.js","@babel/runtime/helpers/defineProperty":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\defineProperty.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cstyles%5CcreateTheme.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMuiTheme = createMuiTheme;
exports.default = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _utils = require("@material-ui/utils");

var _createBreakpoints = _interopRequireDefault(require("./createBreakpoints"));

var _createMixins = _interopRequireDefault(require("./createMixins"));

var _createPalette = _interopRequireDefault(require("./createPalette"));

var _createTypography = _interopRequireDefault(require("./createTypography"));

var _shadows = _interopRequireDefault(require("./shadows"));

var _shape = _interopRequireDefault(require("./shape"));

var _createSpacing = _interopRequireDefault(require("./createSpacing"));

var _transitions = _interopRequireDefault(require("./transitions"));

var _zIndex = _interopRequireDefault(require("./zIndex"));

function createTheme() {
  var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var _options$breakpoints = options.breakpoints,
      breakpointsInput = _options$breakpoints === void 0 ? {} : _options$breakpoints,
      _options$mixins = options.mixins,
      mixinsInput = _options$mixins === void 0 ? {} : _options$mixins,
      _options$palette = options.palette,
      paletteInput = _options$palette === void 0 ? {} : _options$palette,
      spacingInput = options.spacing,
      _options$typography = options.typography,
      typographyInput = _options$typography === void 0 ? {} : _options$typography,
      other = (0, _objectWithoutProperties2.default)(options, ["breakpoints", "mixins", "palette", "spacing", "typography"]);
  var palette = (0, _createPalette.default)(paletteInput);
  var breakpoints = (0, _createBreakpoints.default)(breakpointsInput);
  var spacing = (0, _createSpacing.default)(spacingInput);
  var muiTheme = (0, _utils.deepmerge)({
    breakpoints: breakpoints,
    direction: 'ltr',
    mixins: (0, _createMixins.default)(breakpoints, spacing, mixinsInput),
    overrides: {},
    // Inject custom styles
    palette: palette,
    props: {},
    // Provide default props
    shadows: _shadows.default,
    typography: (0, _createTypography.default)(palette, typographyInput),
    spacing: spacing,
    shape: _shape.default,
    transitions: _transitions.default,
    zIndex: _zIndex.default
  }, other);

  for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    args[_key - 1] = arguments[_key];
  }

  muiTheme = args.reduce(function (acc, argument) {
    return (0, _utils.deepmerge)(acc, argument);
  }, muiTheme);

  if ("development" !== 'production') {
    var pseudoClasses = ['checked', 'disabled', 'error', 'focused', 'focusVisible', 'required', 'expanded', 'selected'];

    var traverse = function traverse(node, parentKey) {
      var depth = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;
      var key; // eslint-disable-next-line guard-for-in, no-restricted-syntax

      for (key in node) {
        var child = node[key];

        if (depth === 1) {
          if (key.indexOf('Mui') === 0 && child) {
            traverse(child, key, depth + 1);
          }
        } else if (pseudoClasses.indexOf(key) !== -1 && Object.keys(child).length > 0) {
          if ("development" !== 'production') {
            console.error(["Material-UI: The `".concat(parentKey, "` component increases ") + "the CSS specificity of the `".concat(key, "` internal state."), 'You can not override it like this: ', JSON.stringify(node, null, 2), '', 'Instead, you need to use the $ruleName syntax:', JSON.stringify({
              root: (0, _defineProperty2.default)({}, "&$".concat(key), child)
            }, null, 2), '', 'https://mui.com/r/pseudo-classes-guide'].join('\n'));
          } // Remove the style to prevent global conflicts.


          node[key] = {};
        }
      }
    };

    traverse(muiTheme.overrides);
  }

  return muiTheme;
}

var warnedOnce = false;

function createMuiTheme() {
  if ("development" !== 'production') {
    if (!warnedOnce) {
      warnedOnce = true;
      console.error(['Material-UI: the createMuiTheme function was renamed to createTheme.', '', "You should use `import { createTheme } from '@material-ui/core/styles'`"].join('\n'));
    }
  }

  return createTheme.apply(void 0, arguments);
}

var _default = createTheme;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\styles\\createTheme.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\createTypography.js", {"@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cstyles%5CcreateTypography.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createTypography;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _utils = require("@material-ui/utils");

function round(value) {
  return Math.round(value * 1e5) / 1e5;
}

var warnedOnce = false;

function roundWithDeprecationWarning(value) {
  if ("development" !== 'production') {
    if (!warnedOnce) {
      console.warn(['Material-UI: The `theme.typography.round` helper is deprecated.', 'Head to https://mui.com/r/migration-v4/#theme for a migration path.'].join('\n'));
      warnedOnce = true;
    }
  }

  return round(value);
}

var caseAllCaps = {
  textTransform: 'uppercase'
};
var defaultFontFamily = '"Roboto", "Helvetica", "Arial", sans-serif';
/**
 * @see @link{https://material.io/design/typography/the-type-system.html}
 * @see @link{https://material.io/design/typography/understanding-typography.html}
 */

function createTypography(palette, typography) {
  var _ref = typeof typography === 'function' ? typography(palette) : typography,
      _ref$fontFamily = _ref.fontFamily,
      fontFamily = _ref$fontFamily === void 0 ? defaultFontFamily : _ref$fontFamily,
      _ref$fontSize = _ref.fontSize,
      fontSize = _ref$fontSize === void 0 ? 14 : _ref$fontSize,
      _ref$fontWeightLight = _ref.fontWeightLight,
      fontWeightLight = _ref$fontWeightLight === void 0 ? 300 : _ref$fontWeightLight,
      _ref$fontWeightRegula = _ref.fontWeightRegular,
      fontWeightRegular = _ref$fontWeightRegula === void 0 ? 400 : _ref$fontWeightRegula,
      _ref$fontWeightMedium = _ref.fontWeightMedium,
      fontWeightMedium = _ref$fontWeightMedium === void 0 ? 500 : _ref$fontWeightMedium,
      _ref$fontWeightBold = _ref.fontWeightBold,
      fontWeightBold = _ref$fontWeightBold === void 0 ? 700 : _ref$fontWeightBold,
      _ref$htmlFontSize = _ref.htmlFontSize,
      htmlFontSize = _ref$htmlFontSize === void 0 ? 16 : _ref$htmlFontSize,
      allVariants = _ref.allVariants,
      pxToRem2 = _ref.pxToRem,
      other = (0, _objectWithoutProperties2.default)(_ref, ["fontFamily", "fontSize", "fontWeightLight", "fontWeightRegular", "fontWeightMedium", "fontWeightBold", "htmlFontSize", "allVariants", "pxToRem"]);

  if ("development" !== 'production') {
    if (typeof fontSize !== 'number') {
      console.error('Material-UI: `fontSize` is required to be a number.');
    }

    if (typeof htmlFontSize !== 'number') {
      console.error('Material-UI: `htmlFontSize` is required to be a number.');
    }
  }

  var coef = fontSize / 14;

  var pxToRem = pxToRem2 || function (size) {
    return "".concat(size / htmlFontSize * coef, "rem");
  };

  var buildVariant = function buildVariant(fontWeight, size, lineHeight, letterSpacing, casing) {
    return (0, _extends2.default)({
      fontFamily: fontFamily,
      fontWeight: fontWeight,
      fontSize: pxToRem(size),
      // Unitless following https://meyerweb.com/eric/thoughts/2006/02/08/unitless-line-heights/
      lineHeight: lineHeight
    }, fontFamily === defaultFontFamily ? {
      letterSpacing: "".concat(round(letterSpacing / size), "em")
    } : {}, casing, allVariants);
  };

  var variants = {
    h1: buildVariant(fontWeightLight, 96, 1.167, -1.5),
    h2: buildVariant(fontWeightLight, 60, 1.2, -0.5),
    h3: buildVariant(fontWeightRegular, 48, 1.167, 0),
    h4: buildVariant(fontWeightRegular, 34, 1.235, 0.25),
    h5: buildVariant(fontWeightRegular, 24, 1.334, 0),
    h6: buildVariant(fontWeightMedium, 20, 1.6, 0.15),
    subtitle1: buildVariant(fontWeightRegular, 16, 1.75, 0.15),
    subtitle2: buildVariant(fontWeightMedium, 14, 1.57, 0.1),
    body1: buildVariant(fontWeightRegular, 16, 1.5, 0.15),
    body2: buildVariant(fontWeightRegular, 14, 1.43, 0.15),
    button: buildVariant(fontWeightMedium, 14, 1.75, 0.4, caseAllCaps),
    caption: buildVariant(fontWeightRegular, 12, 1.66, 0.4),
    overline: buildVariant(fontWeightRegular, 12, 2.66, 1, caseAllCaps)
  };
  return (0, _utils.deepmerge)((0, _extends2.default)({
    htmlFontSize: htmlFontSize,
    pxToRem: pxToRem,
    round: roundWithDeprecationWarning,
    // TODO v5: remove
    fontFamily: fontFamily,
    fontSize: fontSize,
    fontWeightLight: fontWeightLight,
    fontWeightRegular: fontWeightRegular,
    fontWeightMedium: fontWeightMedium,
    fontWeightBold: fontWeightBold
  }, variants), other, {
    clone: false // No need to clone deep

  });
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\styles\\createTypography.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\cssUtils.js", {"@babel/runtime/helpers/defineProperty":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\defineProperty.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cstyles%5CcssUtils.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isUnitless = isUnitless;
exports.getUnit = getUnit;
exports.toUnitless = toUnitless;
exports.convertLength = convertLength;
exports.alignProperty = alignProperty;
exports.fontGrid = fontGrid;
exports.responsiveProperty = responsiveProperty;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

function isUnitless(value) {
  return String(parseFloat(value)).length === String(value).length;
} // Ported from Compass
// https://github.com/Compass/compass/blob/master/core/stylesheets/compass/typography/_units.scss
// Emulate the sass function "unit"


function getUnit(input) {
  return String(input).match(/[\d.\-+]*\s*(.*)/)[1] || '';
} // Emulate the sass function "unitless"


function toUnitless(length) {
  return parseFloat(length);
} // Convert any CSS <length> or <percentage> value to any another.
// From https://github.com/KyleAMathews/convert-css-length


function convertLength(baseFontSize) {
  return function (length, toUnit) {
    var fromUnit = getUnit(length); // Optimize for cases where `from` and `to` units are accidentally the same.

    if (fromUnit === toUnit) {
      return length;
    } // Convert input length to pixels.


    var pxLength = toUnitless(length);

    if (fromUnit !== 'px') {
      if (fromUnit === 'em') {
        pxLength = toUnitless(length) * toUnitless(baseFontSize);
      } else if (fromUnit === 'rem') {
        pxLength = toUnitless(length) * toUnitless(baseFontSize);
        return length;
      }
    } // Convert length in pixels to the output unit


    var outputLength = pxLength;

    if (toUnit !== 'px') {
      if (toUnit === 'em') {
        outputLength = pxLength / toUnitless(baseFontSize);
      } else if (toUnit === 'rem') {
        outputLength = pxLength / toUnitless(baseFontSize);
      } else {
        return length;
      }
    }

    return parseFloat(outputLength.toFixed(5)) + toUnit;
  };
}

function alignProperty(_ref) {
  var size = _ref.size,
      grid = _ref.grid;
  var sizeBelow = size - size % grid;
  var sizeAbove = sizeBelow + grid;
  return size - sizeBelow < sizeAbove - size ? sizeBelow : sizeAbove;
} // fontGrid finds a minimal grid (in rem) for the fontSize values so that the
// lineHeight falls under a x pixels grid, 4px in the case of Material Design,
// without changing the relative line height


function fontGrid(_ref2) {
  var lineHeight = _ref2.lineHeight,
      pixels = _ref2.pixels,
      htmlFontSize = _ref2.htmlFontSize;
  return pixels / (lineHeight * htmlFontSize);
}
/**
 * generate a responsive version of a given CSS property
 * @example
 * responsiveProperty({
 *   cssProperty: 'fontSize',
 *   min: 15,
 *   max: 20,
 *   unit: 'px',
 *   breakpoints: [300, 600],
 * })
 *
 * // this returns
 *
 * {
 *   fontSize: '15px',
 *   '@media (min-width:300px)': {
 *     fontSize: '17.5px',
 *   },
 *   '@media (min-width:600px)': {
 *     fontSize: '20px',
 *   },
 * }
 *
 * @param {Object} params
 * @param {string} params.cssProperty - The CSS property to be made responsive
 * @param {number} params.min - The smallest value of the CSS property
 * @param {number} params.max - The largest value of the CSS property
 * @param {string} [params.unit] - The unit to be used for the CSS property
 * @param {Array.number} [params.breakpoints]  - An array of breakpoints
 * @param {number} [params.alignStep] - Round scaled value to fall under this grid
 * @returns {Object} responsive styles for {params.cssProperty}
 */


function responsiveProperty(_ref3) {
  var cssProperty = _ref3.cssProperty,
      min = _ref3.min,
      max = _ref3.max,
      _ref3$unit = _ref3.unit,
      unit = _ref3$unit === void 0 ? 'rem' : _ref3$unit,
      _ref3$breakpoints = _ref3.breakpoints,
      breakpoints = _ref3$breakpoints === void 0 ? [600, 960, 1280] : _ref3$breakpoints,
      _ref3$transform = _ref3.transform,
      transform = _ref3$transform === void 0 ? null : _ref3$transform;
  var output = (0, _defineProperty2.default)({}, cssProperty, "".concat(min).concat(unit));
  var factor = (max - min) / breakpoints[breakpoints.length - 1];
  breakpoints.forEach(function (breakpoint) {
    var value = min + factor * breakpoint;

    if (transform !== null) {
      value = transform(value);
    }

    output["@media (min-width:".concat(breakpoint, "px)")] = (0, _defineProperty2.default)({}, cssProperty, "".concat(Math.round(value * 10000) / 10000).concat(unit));
  });
  return output;
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\styles\\cssUtils.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\defaultTheme.js", {"./createTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\createTheme.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cstyles%5CdefaultTheme.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _createTheme = _interopRequireDefault(require("./createTheme"));

var defaultTheme = (0, _createTheme.default)();
var _default = defaultTheme;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\styles\\defaultTheme.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\index.js", {"./colorManipulator":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\colorManipulator.js","./createMuiStrictModeTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\createMuiStrictModeTheme.js","./createStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\createStyles.js","./createTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\createTheme.js","./makeStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\makeStyles.js","./responsiveFontSizes":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\responsiveFontSizes.js","./styled":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\styled.js","./transitions":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\transitions.js","./useTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\useTheme.js","./withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withStyles.js","./withTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withTheme.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@material-ui/styles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cstyles%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  createTheme: true,
  createMuiTheme: true,
  unstable_createMuiStrictModeTheme: true,
  createStyles: true,
  makeStyles: true,
  responsiveFontSizes: true,
  styled: true,
  useTheme: true,
  withStyles: true,
  withTheme: true,
  createGenerateClassName: true,
  jssPreset: true,
  ServerStyleSheets: true,
  StylesProvider: true,
  MuiThemeProvider: true,
  ThemeProvider: true
};
Object.defineProperty(exports, "createTheme", {
  enumerable: true,
  get: function get() {
    return _createTheme.default;
  }
});
Object.defineProperty(exports, "createMuiTheme", {
  enumerable: true,
  get: function get() {
    return _createTheme.createMuiTheme;
  }
});
Object.defineProperty(exports, "unstable_createMuiStrictModeTheme", {
  enumerable: true,
  get: function get() {
    return _createMuiStrictModeTheme.default;
  }
});
Object.defineProperty(exports, "createStyles", {
  enumerable: true,
  get: function get() {
    return _createStyles.default;
  }
});
Object.defineProperty(exports, "makeStyles", {
  enumerable: true,
  get: function get() {
    return _makeStyles.default;
  }
});
Object.defineProperty(exports, "responsiveFontSizes", {
  enumerable: true,
  get: function get() {
    return _responsiveFontSizes.default;
  }
});
Object.defineProperty(exports, "styled", {
  enumerable: true,
  get: function get() {
    return _styled.default;
  }
});
Object.defineProperty(exports, "useTheme", {
  enumerable: true,
  get: function get() {
    return _useTheme.default;
  }
});
Object.defineProperty(exports, "withStyles", {
  enumerable: true,
  get: function get() {
    return _withStyles.default;
  }
});
Object.defineProperty(exports, "withTheme", {
  enumerable: true,
  get: function get() {
    return _withTheme.default;
  }
});
Object.defineProperty(exports, "createGenerateClassName", {
  enumerable: true,
  get: function get() {
    return _styles.createGenerateClassName;
  }
});
Object.defineProperty(exports, "jssPreset", {
  enumerable: true,
  get: function get() {
    return _styles.jssPreset;
  }
});
Object.defineProperty(exports, "ServerStyleSheets", {
  enumerable: true,
  get: function get() {
    return _styles.ServerStyleSheets;
  }
});
Object.defineProperty(exports, "StylesProvider", {
  enumerable: true,
  get: function get() {
    return _styles.StylesProvider;
  }
});
Object.defineProperty(exports, "MuiThemeProvider", {
  enumerable: true,
  get: function get() {
    return _styles.ThemeProvider;
  }
});
Object.defineProperty(exports, "ThemeProvider", {
  enumerable: true,
  get: function get() {
    return _styles.ThemeProvider;
  }
});

var _colorManipulator = require("./colorManipulator");

Object.keys(_colorManipulator).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _colorManipulator[key];
    }
  });
});

var _createTheme = _interopRequireWildcard(require("./createTheme"));

var _createMuiStrictModeTheme = _interopRequireDefault(require("./createMuiStrictModeTheme"));

var _createStyles = _interopRequireDefault(require("./createStyles"));

var _makeStyles = _interopRequireDefault(require("./makeStyles"));

var _responsiveFontSizes = _interopRequireDefault(require("./responsiveFontSizes"));

var _styled = _interopRequireDefault(require("./styled"));

var _transitions = require("./transitions");

Object.keys(_transitions).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _transitions[key];
    }
  });
});

var _useTheme = _interopRequireDefault(require("./useTheme"));

var _withStyles = _interopRequireDefault(require("./withStyles"));

var _withTheme = _interopRequireDefault(require("./withTheme"));

var _styles = require("@material-ui/styles");
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\styles\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\makeStyles.js", {"./defaultTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\defaultTheme.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@material-ui/styles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cstyles%5CmakeStyles.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _styles = require("@material-ui/styles");

var _defaultTheme = _interopRequireDefault(require("./defaultTheme"));

function makeStyles(stylesOrCreator) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  return (0, _styles.makeStyles)(stylesOrCreator, (0, _extends2.default)({
    defaultTheme: _defaultTheme.default
  }, options));
}

var _default = makeStyles;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\styles\\makeStyles.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\responsiveFontSizes.js", {"./cssUtils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\cssUtils.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cstyles%5CresponsiveFontSizes.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = responsiveFontSizes;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _utils = require("@material-ui/utils");

var _cssUtils = require("./cssUtils");

function responsiveFontSizes(themeInput) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _options$breakpoints = options.breakpoints,
      breakpoints = _options$breakpoints === void 0 ? ['sm', 'md', 'lg'] : _options$breakpoints,
      _options$disableAlign = options.disableAlign,
      disableAlign = _options$disableAlign === void 0 ? false : _options$disableAlign,
      _options$factor = options.factor,
      factor = _options$factor === void 0 ? 2 : _options$factor,
      _options$variants = options.variants,
      variants = _options$variants === void 0 ? ['h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'subtitle1', 'subtitle2', 'body1', 'body2', 'caption', 'button', 'overline'] : _options$variants;
  var theme = (0, _extends2.default)({}, themeInput);
  theme.typography = (0, _extends2.default)({}, theme.typography);
  var typography = theme.typography; // Convert between css lengths e.g. em->px or px->rem
  // Set the baseFontSize for your project. Defaults to 16px (also the browser default).

  var convert = (0, _cssUtils.convertLength)(typography.htmlFontSize);
  var breakpointValues = breakpoints.map(function (x) {
    return theme.breakpoints.values[x];
  });
  variants.forEach(function (variant) {
    var style = typography[variant];
    var remFontSize = parseFloat(convert(style.fontSize, 'rem'));

    if (remFontSize <= 1) {
      return;
    }

    var maxFontSize = remFontSize;
    var minFontSize = 1 + (maxFontSize - 1) / factor;
    var lineHeight = style.lineHeight;

    if (!(0, _cssUtils.isUnitless)(lineHeight) && !disableAlign) {
      throw new Error("development" !== "production" ? "Material-UI: Unsupported non-unitless line height with grid alignment.\nUse unitless line heights instead." : (0, _utils.formatMuiErrorMessage)(6));
    }

    if (!(0, _cssUtils.isUnitless)(lineHeight)) {
      // make it unitless
      lineHeight = parseFloat(convert(lineHeight, 'rem')) / parseFloat(remFontSize);
    }

    var transform = null;

    if (!disableAlign) {
      transform = function transform(value) {
        return (0, _cssUtils.alignProperty)({
          size: value,
          grid: (0, _cssUtils.fontGrid)({
            pixels: 4,
            lineHeight: lineHeight,
            htmlFontSize: typography.htmlFontSize
          })
        });
      };
    }

    typography[variant] = (0, _extends2.default)({}, style, (0, _cssUtils.responsiveProperty)({
      cssProperty: 'fontSize',
      min: minFontSize,
      max: maxFontSize,
      unit: 'rem',
      breakpoints: breakpointValues,
      transform: transform
    }));
  });
  return theme;
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\styles\\responsiveFontSizes.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\shadows.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cstyles%5Cshadows.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var shadowKeyUmbraOpacity = 0.2;
var shadowKeyPenumbraOpacity = 0.14;
var shadowAmbientShadowOpacity = 0.12;

function createShadow() {
  return ["".concat(arguments.length <= 0 ? undefined : arguments[0], "px ").concat(arguments.length <= 1 ? undefined : arguments[1], "px ").concat(arguments.length <= 2 ? undefined : arguments[2], "px ").concat(arguments.length <= 3 ? undefined : arguments[3], "px rgba(0,0,0,").concat(shadowKeyUmbraOpacity, ")"), "".concat(arguments.length <= 4 ? undefined : arguments[4], "px ").concat(arguments.length <= 5 ? undefined : arguments[5], "px ").concat(arguments.length <= 6 ? undefined : arguments[6], "px ").concat(arguments.length <= 7 ? undefined : arguments[7], "px rgba(0,0,0,").concat(shadowKeyPenumbraOpacity, ")"), "".concat(arguments.length <= 8 ? undefined : arguments[8], "px ").concat(arguments.length <= 9 ? undefined : arguments[9], "px ").concat(arguments.length <= 10 ? undefined : arguments[10], "px ").concat(arguments.length <= 11 ? undefined : arguments[11], "px rgba(0,0,0,").concat(shadowAmbientShadowOpacity, ")")].join(',');
} // Values from https://github.com/material-components/material-components-web/blob/be8747f94574669cb5e7add1a7c54fa41a89cec7/packages/mdc-elevation/_variables.scss


var shadows = ['none', createShadow(0, 2, 1, -1, 0, 1, 1, 0, 0, 1, 3, 0), createShadow(0, 3, 1, -2, 0, 2, 2, 0, 0, 1, 5, 0), createShadow(0, 3, 3, -2, 0, 3, 4, 0, 0, 1, 8, 0), createShadow(0, 2, 4, -1, 0, 4, 5, 0, 0, 1, 10, 0), createShadow(0, 3, 5, -1, 0, 5, 8, 0, 0, 1, 14, 0), createShadow(0, 3, 5, -1, 0, 6, 10, 0, 0, 1, 18, 0), createShadow(0, 4, 5, -2, 0, 7, 10, 1, 0, 2, 16, 1), createShadow(0, 5, 5, -3, 0, 8, 10, 1, 0, 3, 14, 2), createShadow(0, 5, 6, -3, 0, 9, 12, 1, 0, 3, 16, 2), createShadow(0, 6, 6, -3, 0, 10, 14, 1, 0, 4, 18, 3), createShadow(0, 6, 7, -4, 0, 11, 15, 1, 0, 4, 20, 3), createShadow(0, 7, 8, -4, 0, 12, 17, 2, 0, 5, 22, 4), createShadow(0, 7, 8, -4, 0, 13, 19, 2, 0, 5, 24, 4), createShadow(0, 7, 9, -4, 0, 14, 21, 2, 0, 5, 26, 4), createShadow(0, 8, 9, -5, 0, 15, 22, 2, 0, 6, 28, 5), createShadow(0, 8, 10, -5, 0, 16, 24, 2, 0, 6, 30, 5), createShadow(0, 8, 11, -5, 0, 17, 26, 2, 0, 6, 32, 5), createShadow(0, 9, 11, -5, 0, 18, 28, 2, 0, 7, 34, 6), createShadow(0, 9, 12, -6, 0, 19, 29, 2, 0, 7, 36, 6), createShadow(0, 10, 13, -6, 0, 20, 31, 3, 0, 8, 38, 7), createShadow(0, 10, 13, -6, 0, 21, 33, 3, 0, 8, 40, 7), createShadow(0, 10, 14, -6, 0, 22, 35, 3, 0, 8, 42, 7), createShadow(0, 11, 14, -7, 0, 23, 36, 3, 0, 9, 44, 8), createShadow(0, 11, 15, -7, 0, 24, 38, 3, 0, 9, 46, 8)];
var _default = shadows;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\styles\\shadows.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\shape.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cstyles%5Cshape.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var shape = {
  borderRadius: 4
};
var _default = shape;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\styles\\shape.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\styled.js", {"./defaultTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\defaultTheme.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@material-ui/styles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cstyles%5Cstyled.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _styles = require("@material-ui/styles");

var _defaultTheme = _interopRequireDefault(require("./defaultTheme"));

var styled = function styled(Component) {
  var componentCreator = (0, _styles.styled)(Component);
  return function (style, options) {
    return componentCreator(style, (0, _extends2.default)({
      defaultTheme: _defaultTheme.default
    }, options));
  };
};

var _default = styled;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\styles\\styled.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\transitions.js", {"@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cstyles%5Ctransitions.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.duration = exports.easing = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

// Follow https://material.google.com/motion/duration-easing.html#duration-easing-natural-easing-curves
// to learn the context in which each easing should be used.
var easing = {
  // This is the most common easing curve.
  easeInOut: 'cubic-bezier(0.4, 0, 0.2, 1)',
  // Objects enter the screen at full velocity from off-screen and
  // slowly decelerate to a resting point.
  easeOut: 'cubic-bezier(0.0, 0, 0.2, 1)',
  // Objects leave the screen at full velocity. They do not decelerate when off-screen.
  easeIn: 'cubic-bezier(0.4, 0, 1, 1)',
  // The sharp curve is used by objects that may return to the screen at any time.
  sharp: 'cubic-bezier(0.4, 0, 0.6, 1)'
}; // Follow https://material.io/guidelines/motion/duration-easing.html#duration-easing-common-durations
// to learn when use what timing

exports.easing = easing;
var duration = {
  shortest: 150,
  shorter: 200,
  short: 250,
  // most basic recommended timing
  standard: 300,
  // this is to be used in complex animations
  complex: 375,
  // recommended when something is entering screen
  enteringScreen: 225,
  // recommended when something is leaving screen
  leavingScreen: 195
};
exports.duration = duration;

function formatMs(milliseconds) {
  return "".concat(Math.round(milliseconds), "ms");
}
/**
 * @param {string|Array} props
 * @param {object} param
 * @param {string} param.prop
 * @param {number} param.duration
 * @param {string} param.easing
 * @param {number} param.delay
 */


var _default = {
  easing: easing,
  duration: duration,
  create: function create() {
    var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : ['all'];
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var _options$duration = options.duration,
        durationOption = _options$duration === void 0 ? duration.standard : _options$duration,
        _options$easing = options.easing,
        easingOption = _options$easing === void 0 ? easing.easeInOut : _options$easing,
        _options$delay = options.delay,
        delay = _options$delay === void 0 ? 0 : _options$delay,
        other = (0, _objectWithoutProperties2.default)(options, ["duration", "easing", "delay"]);

    if ("development" !== 'production') {
      var isString = function isString(value) {
        return typeof value === 'string';
      };

      var isNumber = function isNumber(value) {
        return !isNaN(parseFloat(value));
      };

      if (!isString(props) && !Array.isArray(props)) {
        console.error('Material-UI: Argument "props" must be a string or Array.');
      }

      if (!isNumber(durationOption) && !isString(durationOption)) {
        console.error("Material-UI: Argument \"duration\" must be a number or a string but found ".concat(durationOption, "."));
      }

      if (!isString(easingOption)) {
        console.error('Material-UI: Argument "easing" must be a string.');
      }

      if (!isNumber(delay) && !isString(delay)) {
        console.error('Material-UI: Argument "delay" must be a number or a string.');
      }

      if (Object.keys(other).length !== 0) {
        console.error("Material-UI: Unrecognized argument(s) [".concat(Object.keys(other).join(','), "]."));
      }
    }

    return (Array.isArray(props) ? props : [props]).map(function (animatedProp) {
      return "".concat(animatedProp, " ").concat(typeof durationOption === 'string' ? durationOption : formatMs(durationOption), " ").concat(easingOption, " ").concat(typeof delay === 'string' ? delay : formatMs(delay));
    }).join(',');
  },
  getAutoHeightDuration: function getAutoHeightDuration(height) {
    if (!height) {
      return 0;
    }

    var constant = height / 36; // https://www.wolframalpha.com/input/?i=(4+%2B+15+*+(x+%2F+36+)+**+0.25+%2B+(x+%2F+36)+%2F+5)+*+10

    return Math.round((4 + 15 * Math.pow(constant, 0.25) + constant / 5) * 10);
  }
};
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\styles\\transitions.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\useTheme.js", {"./defaultTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\defaultTheme.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@material-ui/styles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cstyles%5CuseTheme.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useTheme;

var _styles = require("@material-ui/styles");

var _react = _interopRequireDefault(require("react"));

var _defaultTheme = _interopRequireDefault(require("./defaultTheme"));

function useTheme() {
  var theme = (0, _styles.useTheme)() || _defaultTheme.default;

  if ("development" !== 'production') {
    // eslint-disable-next-line react-hooks/rules-of-hooks
    _react.default.useDebugValue(theme);
  }

  return theme;
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\styles\\useTheme.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withStyles.js", {"./defaultTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\defaultTheme.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@material-ui/styles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cstyles%5CwithStyles.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _styles = require("@material-ui/styles");

var _defaultTheme = _interopRequireDefault(require("./defaultTheme"));

function withStyles(stylesOrCreator, options) {
  return (0, _styles.withStyles)(stylesOrCreator, (0, _extends2.default)({
    defaultTheme: _defaultTheme.default
  }, options));
}

var _default = withStyles;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\styles\\withStyles.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\withTheme.js", {"./defaultTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\defaultTheme.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@material-ui/styles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cstyles%5CwithTheme.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _styles = require("@material-ui/styles");

var _defaultTheme = _interopRequireDefault(require("./defaultTheme"));

var withTheme = (0, _styles.withThemeCreator)({
  defaultTheme: _defaultTheme.default
});
var _default = withTheme;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\styles\\withTheme.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\styles\\zIndex.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cstyles%5CzIndex.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
// We need to centralize the zIndex definitions as they work
// like global values in the browser.
var zIndex = {
  mobileStepper: 1000,
  speedDial: 1050,
  appBar: 1100,
  drawer: 1200,
  modal: 1300,
  snackbar: 1400,
  tooltip: 1500
};
var _default = zIndex;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\styles\\zIndex.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\transitions\\utils.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Ctransitions%5Cutils.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransitionProps = getTransitionProps;
exports.reflow = void 0;

var reflow = function reflow(node) {
  return node.scrollTop;
};

exports.reflow = reflow;

function getTransitionProps(props, options) {
  var timeout = props.timeout,
      _props$style = props.style,
      style = _props$style === void 0 ? {} : _props$style;
  return {
    duration: style.transitionDuration || typeof timeout === 'number' ? timeout : timeout[options.mode] || 0,
    delay: style.transitionDelay
  };
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\transitions\\utils.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\capitalize.js", {"@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cutils%5Ccapitalize.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = capitalize;

var _utils = require("@material-ui/utils");

// It should to be noted that this function isn't equivalent to `text-transform: capitalize`.
//
// A strict capitalization should uppercase the first letter of each word a the sentence.
// We only handle the first word.
function capitalize(string) {
  if (typeof string !== 'string') {
    throw new Error("development" !== "production" ? "Material-UI: capitalize(string) expects a string argument." : (0, _utils.formatMuiErrorMessage)(7));
  }

  return string.charAt(0).toUpperCase() + string.slice(1);
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\utils\\capitalize.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\createChainedFunction.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cutils%5CcreateChainedFunction.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createChainedFunction;

/**
 * Safe chained function
 *
 * Will only create a new function if needed,
 * otherwise will pass back existing functions or null.
 *
 * @param {function} functions to chain
 * @returns {function|null}
 */
function createChainedFunction() {
  for (var _len = arguments.length, funcs = new Array(_len), _key = 0; _key < _len; _key++) {
    funcs[_key] = arguments[_key];
  }

  return funcs.reduce(function (acc, func) {
    if (func == null) {
      return acc;
    }

    if ("development" !== 'production') {
      if (typeof func !== 'function') {
        console.error('Material-UI: Invalid Argument Type, must only provide functions, undefined, or null.');
      }
    }

    return function chainedFunction() {
      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      acc.apply(this, args);
      func.apply(this, args);
    };
  }, function () {});
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\utils\\createChainedFunction.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\createSvgIcon.js", {"../SvgIcon":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\SvgIcon\\index.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cutils%5CcreateSvgIcon.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createSvgIcon;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _SvgIcon = _interopRequireDefault(require("../SvgIcon"));

/**
 * Private module reserved for @material-ui/x packages.
 */
function createSvgIcon(path, displayName) {
  var Component = function Component(props, ref) {
    return /*#__PURE__*/_react.default.createElement(_SvgIcon.default, (0, _extends2.default)({
      ref: ref
    }, props), path);
  };

  if ("development" !== 'production') {
    // Need to set `displayName` on the inner component for React.memo.
    // React prior to 16.14 ignores `displayName` on the wrapper.
    Component.displayName = "".concat(displayName, "Icon");
  }

  Component.muiName = _SvgIcon.default.muiName;
  return /*#__PURE__*/_react.default.memo( /*#__PURE__*/_react.default.forwardRef(Component));
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\utils\\createSvgIcon.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\debounce.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cutils%5Cdebounce.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = debounce;

// Corresponds to 10 frames at 60 Hz.
// A few bytes payload overhead when lodash/debounce is ~3 kB and debounce ~300 B.
function debounce(func) {
  var wait = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 166;
  var timeout;

  function debounced() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    // eslint-disable-next-line consistent-this
    var that = this;

    var later = function later() {
      func.apply(that, args);
    };

    clearTimeout(timeout);
    timeout = setTimeout(later, wait);
  }

  debounced.clear = function () {
    clearTimeout(timeout);
  };

  return debounced;
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\utils\\debounce.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\deprecatedPropType.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cutils%5CdeprecatedPropType.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = deprecatedPropType;

function deprecatedPropType(validator, reason) {
  if ("development" === 'production') {
    return function () {
      return null;
    };
  }

  return function (props, propName, componentName, location, propFullName) {
    var componentNameSafe = componentName || '<<anonymous>>';
    var propFullNameSafe = propFullName || propName;

    if (typeof props[propName] !== 'undefined') {
      return new Error("The ".concat(location, " `").concat(propFullNameSafe, "` of ") + "`".concat(componentNameSafe, "` is deprecated. ").concat(reason));
    }

    return null;
  };
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\utils\\deprecatedPropType.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\getScrollbarSize.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cutils%5CgetScrollbarSize.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getScrollbarSize;

// A change of the browser zoom change the scrollbar size.
// Credit https://github.com/twbs/bootstrap/blob/3ffe3a5d82f6f561b82ff78d82b32a7d14aed558/js/src/modal.js#L512-L519
function getScrollbarSize() {
  var scrollDiv = document.createElement('div');
  scrollDiv.style.width = '99px';
  scrollDiv.style.height = '99px';
  scrollDiv.style.position = 'absolute';
  scrollDiv.style.top = '-9999px';
  scrollDiv.style.overflow = 'scroll';
  document.body.appendChild(scrollDiv);
  var scrollbarSize = scrollDiv.offsetWidth - scrollDiv.clientWidth;
  document.body.removeChild(scrollDiv);
  return scrollbarSize;
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\utils\\getScrollbarSize.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\isMuiElement.js", {"@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cutils%5CisMuiElement.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = isMuiElement;

var React = _interopRequireWildcard(require("react"));

function isMuiElement(element, muiNames) {
  return /*#__PURE__*/React.isValidElement(element) && muiNames.indexOf(element.type.muiName) !== -1;
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\utils\\isMuiElement.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\ownerDocument.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cutils%5CownerDocument.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ownerDocument;

function ownerDocument(node) {
  return node && node.ownerDocument || document;
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\utils\\ownerDocument.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\ownerWindow.js", {"./ownerDocument":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\ownerDocument.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cutils%5CownerWindow.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ownerWindow;

var _ownerDocument = _interopRequireDefault(require("./ownerDocument"));

function ownerWindow(node) {
  var doc = (0, _ownerDocument.default)(node);
  return doc.defaultView || window;
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\utils\\ownerWindow.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\setRef.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cutils%5CsetRef.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = setRef;

// TODO v5: consider to make it private
function setRef(ref, value) {
  if (typeof ref === 'function') {
    ref(value);
  } else if (ref) {
    ref.current = value;
  }
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\utils\\setRef.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\unstable_useId.js", {"@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cutils%5Cunstable_useId.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useId;

var React = _interopRequireWildcard(require("react"));

/**
 * Private module reserved for @material-ui/x packages.
 */
function useId(idOverride) {
  var _React$useState = React.useState(idOverride),
      defaultId = _React$useState[0],
      setDefaultId = _React$useState[1];

  var id = idOverride || defaultId;
  React.useEffect(function () {
    if (defaultId == null) {
      // Fallback to this default id when possible.
      // Use the random value for client-side rendering only.
      // We can't use it server-side.
      setDefaultId("mui-".concat(Math.round(Math.random() * 1e5)));
    }
  }, [defaultId]);
  return id;
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\utils\\unstable_useId.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\useControlled.js", {"@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cutils%5CuseControlled.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useControlled;

var React = _interopRequireWildcard(require("react"));

/* eslint-disable react-hooks/rules-of-hooks, react-hooks/exhaustive-deps */
function useControlled(_ref) {
  var controlled = _ref.controlled,
      defaultProp = _ref.default,
      name = _ref.name,
      _ref$state = _ref.state,
      state = _ref$state === void 0 ? 'value' : _ref$state;

  var _React$useRef = React.useRef(controlled !== undefined),
      isControlled = _React$useRef.current;

  var _React$useState = React.useState(defaultProp),
      valueState = _React$useState[0],
      setValue = _React$useState[1];

  var value = isControlled ? controlled : valueState;

  if ("development" !== 'production') {
    React.useEffect(function () {
      if (isControlled !== (controlled !== undefined)) {
        console.error(["Material-UI: A component is changing the ".concat(isControlled ? '' : 'un', "controlled ").concat(state, " state of ").concat(name, " to be ").concat(isControlled ? 'un' : '', "controlled."), 'Elements should not switch from uncontrolled to controlled (or vice versa).', "Decide between using a controlled or uncontrolled ".concat(name, " ") + 'element for the lifetime of the component.', "The nature of the state is determined during the first render, it's considered controlled if the value is not `undefined`.", 'More info: https://fb.me/react-controlled-components'].join('\n'));
      }
    }, [controlled]);

    var _React$useRef2 = React.useRef(defaultProp),
        defaultValue = _React$useRef2.current;

    React.useEffect(function () {
      if (!isControlled && defaultValue !== defaultProp) {
        console.error(["Material-UI: A component is changing the default ".concat(state, " state of an uncontrolled ").concat(name, " after being initialized. ") + "To suppress this warning opt to use a controlled ".concat(name, ".")].join('\n'));
      }
    }, [JSON.stringify(defaultProp)]);
  }

  var setValueIfUncontrolled = React.useCallback(function (newValue) {
    if (!isControlled) {
      setValue(newValue);
    }
  }, []);
  return [value, setValueIfUncontrolled];
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\utils\\useControlled.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\useEventCallback.js", {"@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cutils%5CuseEventCallback.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useEventCallback;

var React = _interopRequireWildcard(require("react"));

var useEnhancedEffect = typeof window !== 'undefined' ? React.useLayoutEffect : React.useEffect;
/**
 * https://github.com/facebook/react/issues/14099#issuecomment-440013892
 *
 * @param {function} fn
 */

function useEventCallback(fn) {
  var ref = React.useRef(fn);
  useEnhancedEffect(function () {
    ref.current = fn;
  });
  return React.useCallback(function () {
    return (0, ref.current).apply(void 0, arguments);
  }, []);
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\utils\\useEventCallback.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\useForkRef.js", {"./setRef":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\setRef.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cutils%5CuseForkRef.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useForkRef;

var React = _interopRequireWildcard(require("react"));

var _setRef = _interopRequireDefault(require("./setRef"));

function useForkRef(refA, refB) {
  /**
   * This will create a new function if the ref props change and are defined.
   * This means react will call the old forkRef with `null` and the new forkRef
   * with the ref. Cleanup naturally emerges from this behavior
   */
  return React.useMemo(function () {
    if (refA == null && refB == null) {
      return null;
    }

    return function (refValue) {
      (0, _setRef.default)(refA, refValue);
      (0, _setRef.default)(refB, refValue);
    };
  }, [refA, refB]);
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\utils\\useForkRef.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\core\\utils\\useIsFocusVisible.js", {"@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js","react-dom":"D:\\code\\v\\metamask-extension\\node_modules\\react-dom\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Ccore%5Cutils%5CuseIsFocusVisible.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.teardown = teardown;
exports.default = useIsFocusVisible;

var React = _interopRequireWildcard(require("react"));

var ReactDOM = _interopRequireWildcard(require("react-dom"));

// based on https://github.com/WICG/focus-visible/blob/v4.1.5/src/focus-visible.js
var hadKeyboardEvent = true;
var hadFocusVisibleRecently = false;
var hadFocusVisibleRecentlyTimeout = null;
var inputTypesWhitelist = {
  text: true,
  search: true,
  url: true,
  tel: true,
  email: true,
  password: true,
  number: true,
  date: true,
  month: true,
  week: true,
  time: true,
  datetime: true,
  'datetime-local': true
};
/**
 * Computes whether the given element should automatically trigger the
 * `focus-visible` class being added, i.e. whether it should always match
 * `:focus-visible` when focused.
 * @param {Element} node
 * @return {boolean}
 */

function focusTriggersKeyboardModality(node) {
  var type = node.type,
      tagName = node.tagName;

  if (tagName === 'INPUT' && inputTypesWhitelist[type] && !node.readOnly) {
    return true;
  }

  if (tagName === 'TEXTAREA' && !node.readOnly) {
    return true;
  }

  if (node.isContentEditable) {
    return true;
  }

  return false;
}
/**
 * Keep track of our keyboard modality state with `hadKeyboardEvent`.
 * If the most recent user interaction was via the keyboard;
 * and the key press did not include a meta, alt/option, or control key;
 * then the modality is keyboard. Otherwise, the modality is not keyboard.
 * @param {KeyboardEvent} event
 */


function handleKeyDown(event) {
  if (event.metaKey || event.altKey || event.ctrlKey) {
    return;
  }

  hadKeyboardEvent = true;
}
/**
 * If at any point a user clicks with a pointing device, ensure that we change
 * the modality away from keyboard.
 * This avoids the situation where a user presses a key on an already focused
 * element, and then clicks on a different element, focusing it with a
 * pointing device, while we still think we're in keyboard modality.
 */


function handlePointerDown() {
  hadKeyboardEvent = false;
}

function handleVisibilityChange() {
  if (this.visibilityState === 'hidden') {
    // If the tab becomes active again, the browser will handle calling focus
    // on the element (Safari actually calls it twice).
    // If this tab change caused a blur on an element with focus-visible,
    // re-apply the class when the user switches back to the tab.
    if (hadFocusVisibleRecently) {
      hadKeyboardEvent = true;
    }
  }
}

function prepare(doc) {
  doc.addEventListener('keydown', handleKeyDown, true);
  doc.addEventListener('mousedown', handlePointerDown, true);
  doc.addEventListener('pointerdown', handlePointerDown, true);
  doc.addEventListener('touchstart', handlePointerDown, true);
  doc.addEventListener('visibilitychange', handleVisibilityChange, true);
}

function teardown(doc) {
  doc.removeEventListener('keydown', handleKeyDown, true);
  doc.removeEventListener('mousedown', handlePointerDown, true);
  doc.removeEventListener('pointerdown', handlePointerDown, true);
  doc.removeEventListener('touchstart', handlePointerDown, true);
  doc.removeEventListener('visibilitychange', handleVisibilityChange, true);
}

function isFocusVisible(event) {
  var target = event.target;

  try {
    return target.matches(':focus-visible');
  } catch (error) {} // browsers not implementing :focus-visible will throw a SyntaxError
  // we use our own heuristic for those browsers
  // rethrow might be better if it's not the expected error but do we really
  // want to crash if focus-visible malfunctioned?
  // no need for validFocusTarget check. the user does that by attaching it to
  // focusable events only


  return hadKeyboardEvent || focusTriggersKeyboardModality(target);
}
/**
 * Should be called if a blur event is fired on a focus-visible element
 */


function handleBlurVisible() {
  // To detect a tab/window switch, we look for a blur event followed
  // rapidly by a visibility change.
  // If we don't see a visibility change within 100ms, it's probably a
  // regular focus change.
  hadFocusVisibleRecently = true;
  window.clearTimeout(hadFocusVisibleRecentlyTimeout);
  hadFocusVisibleRecentlyTimeout = window.setTimeout(function () {
    hadFocusVisibleRecently = false;
  }, 100);
}

function useIsFocusVisible() {
  var ref = React.useCallback(function (instance) {
    var node = ReactDOM.findDOMNode(instance);

    if (node != null) {
      prepare(node.ownerDocument);
    }
  }, []);

  if ("development" !== 'production') {
    // eslint-disable-next-line react-hooks/rules-of-hooks
    React.useDebugValue(isFocusVisible);
  }

  return {
    isFocusVisible: isFocusVisible,
    onBlurVisible: handleBlurVisible,
    ref: ref
  };
}
      };
    };
  }
  }
}, {package:"@material-ui/core",file:"node_modules\\@material-ui\\core\\utils\\useIsFocusVisible.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\ServerStyleSheets\\ServerStyleSheets.js", {"../StylesProvider":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\StylesProvider\\index.js","../createGenerateClassName":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\createGenerateClassName\\index.js","@babel/runtime/helpers/classCallCheck":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\classCallCheck.js","@babel/runtime/helpers/createClass":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\createClass.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","jss":"D:\\code\\v\\metamask-extension\\node_modules\\jss\\dist\\jss.cjs.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CServerStyleSheets%5CServerStyleSheets.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _react = _interopRequireDefault(require("react"));

var _jss = require("jss");

var _StylesProvider = _interopRequireDefault(require("../StylesProvider"));

var _createGenerateClassName = _interopRequireDefault(require("../createGenerateClassName"));

var ServerStyleSheets = /*#__PURE__*/function () {
  function ServerStyleSheets() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    (0, _classCallCheck2.default)(this, ServerStyleSheets);
    this.options = options;
  }

  (0, _createClass2.default)(ServerStyleSheets, [{
    key: "collect",
    value: function collect(children) {
      // This is needed in order to deduplicate the injection of CSS in the page.
      var sheetsManager = new Map(); // This is needed in order to inject the critical CSS.

      this.sheetsRegistry = new _jss.SheetsRegistry(); // A new class name generator

      var generateClassName = (0, _createGenerateClassName.default)();
      return /*#__PURE__*/_react.default.createElement(_StylesProvider.default, (0, _extends2.default)({
        sheetsManager: sheetsManager,
        serverGenerateClassName: generateClassName,
        sheetsRegistry: this.sheetsRegistry
      }, this.options), children);
    }
  }, {
    key: "toString",
    value: function toString() {
      return this.sheetsRegistry ? this.sheetsRegistry.toString() : '';
    }
  }, {
    key: "getStyleElement",
    value: function getStyleElement(props) {
      return /*#__PURE__*/_react.default.createElement('style', (0, _extends2.default)({
        id: 'jss-server-side',
        key: 'jss-server-side',
        dangerouslySetInnerHTML: {
          __html: this.toString()
        }
      }, props));
    }
  }]);
  return ServerStyleSheets;
}();

exports.default = ServerStyleSheets;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\ServerStyleSheets\\ServerStyleSheets.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\ServerStyleSheets\\index.js", {"./ServerStyleSheets":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\ServerStyleSheets\\ServerStyleSheets.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CServerStyleSheets%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _ServerStyleSheets.default;
  }
});

var _ServerStyleSheets = _interopRequireDefault(require("./ServerStyleSheets"));
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\ServerStyleSheets\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\StylesProvider\\StylesProvider.js", {"../createGenerateClassName":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\createGenerateClassName\\index.js","../jssPreset":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\jssPreset\\index.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js","jss":"D:\\code\\v\\metamask-extension\\node_modules\\jss\\dist\\jss.cjs.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CStylesProvider%5CStylesProvider.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = StylesProvider;
exports.StylesContext = exports.sheetsManager = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _utils = require("@material-ui/utils");

var _createGenerateClassName = _interopRequireDefault(require("../createGenerateClassName"));

var _jss = require("jss");

var _jssPreset = _interopRequireDefault(require("../jssPreset"));

// Default JSS instance.
var jss = (0, _jss.create)((0, _jssPreset.default)()); // Use a singleton or the provided one by the context.
//
// The counter-based approach doesn't tolerate any mistake.
// It's much safer to use the same counter everywhere.

var generateClassName = (0, _createGenerateClassName.default)(); // Exported for test purposes

var sheetsManager = new Map();
exports.sheetsManager = sheetsManager;
var defaultOptions = {
  disableGeneration: false,
  generateClassName: generateClassName,
  jss: jss,
  sheetsCache: null,
  sheetsManager: sheetsManager,
  sheetsRegistry: null
};

var StylesContext = _react.default.createContext(defaultOptions);

exports.StylesContext = StylesContext;

if ("development" !== 'production') {
  StylesContext.displayName = 'StylesContext';
}

var injectFirstNode;

function StylesProvider(props) {
  var children = props.children,
      _props$injectFirst = props.injectFirst,
      injectFirst = _props$injectFirst === void 0 ? false : _props$injectFirst,
      _props$disableGenerat = props.disableGeneration,
      disableGeneration = _props$disableGenerat === void 0 ? false : _props$disableGenerat,
      localOptions = (0, _objectWithoutProperties2.default)(props, ["children", "injectFirst", "disableGeneration"]);

  var outerOptions = _react.default.useContext(StylesContext);

  var context = (0, _extends2.default)({}, outerOptions, {
    disableGeneration: disableGeneration
  }, localOptions);

  if ("development" !== 'production') {
    if (typeof window === 'undefined' && !context.sheetsManager) {
      console.error('Material-UI: You need to use the ServerStyleSheets API when rendering on the server.');
    }
  }

  if ("development" !== 'production') {
    if (context.jss.options.insertionPoint && injectFirst) {
      console.error('Material-UI: You cannot use a custom insertionPoint and <StylesContext injectFirst> at the same time.');
    }
  }

  if ("development" !== 'production') {
    if (injectFirst && localOptions.jss) {
      console.error('Material-UI: You cannot use the jss and injectFirst props at the same time.');
    }
  }

  if (!context.jss.options.insertionPoint && injectFirst && typeof window !== 'undefined') {
    if (!injectFirstNode) {
      var head = document.head;
      injectFirstNode = document.createComment('mui-inject-first');
      head.insertBefore(injectFirstNode, head.firstChild);
    }

    context.jss = (0, _jss.create)({
      plugins: (0, _jssPreset.default)().plugins,
      insertionPoint: injectFirstNode
    });
  }

  return /*#__PURE__*/_react.default.createElement(StylesContext.Provider, {
    value: context
  }, children);
}

"development" !== "production" ? StylesProvider.propTypes = {
  /**
   * Your component tree.
   */
  children: _propTypes.default.node.isRequired,

  /**
   * You can disable the generation of the styles with this option.
   * It can be useful when traversing the React tree outside of the HTML
   * rendering step on the server.
   * Let's say you are using react-apollo to extract all
   * the queries made by the interface server-side - you can significantly speed up the traversal with this prop.
   */
  disableGeneration: _propTypes.default.bool,

  /**
   * JSS's class name generator.
   */
  generateClassName: _propTypes.default.func,

  /**
   * By default, the styles are injected last in the <head> element of the page.
   * As a result, they gain more specificity than any other style sheet.
   * If you want to override Material-UI's styles, set this prop.
   */
  injectFirst: _propTypes.default.bool,

  /**
   * JSS's instance.
   */
  jss: _propTypes.default.object,

  /**
   * @ignore
   */
  serverGenerateClassName: _propTypes.default.func,

  /**
   * @ignore
   *
   * Beta feature.
   *
   * Cache for the sheets.
   */
  sheetsCache: _propTypes.default.object,

  /**
   * @ignore
   *
   * The sheetsManager is used to deduplicate style sheet injection in the page.
   * It's deduplicating using the (theme, styles) couple.
   * On the server, you should provide a new instance for each request.
   */
  sheetsManager: _propTypes.default.object,

  /**
   * @ignore
   *
   * Collect the sheets.
   */
  sheetsRegistry: _propTypes.default.object
} : void 0;

if ("development" !== 'production') {
  "development" !== "production" ? StylesProvider.propTypes = (0, _utils.exactProp)(StylesProvider.propTypes) : void 0;
}
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\StylesProvider\\StylesProvider.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\StylesProvider\\index.js", {"./StylesProvider":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\StylesProvider\\StylesProvider.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CStylesProvider%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {};
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _StylesProvider.default;
  }
});

var _StylesProvider = _interopRequireWildcard(require("./StylesProvider"));

Object.keys(_StylesProvider).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _StylesProvider[key];
    }
  });
});
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\StylesProvider\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\ThemeProvider\\ThemeProvider.js", {"../useTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\useTheme\\index.js","../useTheme/ThemeContext":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\useTheme\\ThemeContext.js","./nested":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\ThemeProvider\\nested.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CThemeProvider%5CThemeProvider.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _utils = require("@material-ui/utils");

var _ThemeContext = _interopRequireDefault(require("../useTheme/ThemeContext"));

var _useTheme = _interopRequireDefault(require("../useTheme"));

var _nested = _interopRequireDefault(require("./nested"));

// To support composition of theme.
function mergeOuterLocalTheme(outerTheme, localTheme) {
  if (typeof localTheme === 'function') {
    var mergedTheme = localTheme(outerTheme);

    if ("development" !== 'production') {
      if (!mergedTheme) {
        console.error(['Material-UI: You should return an object from your theme function, i.e.', '<ThemeProvider theme={() => ({})} />'].join('\n'));
      }
    }

    return mergedTheme;
  }

  return (0, _extends2.default)({}, outerTheme, localTheme);
}
/**
 * This component takes a `theme` prop.
 * It makes the `theme` available down the React tree thanks to React context.
 * This component should preferably be used at **the root of your component tree**.
 */


function ThemeProvider(props) {
  var children = props.children,
      localTheme = props.theme;
  var outerTheme = (0, _useTheme.default)();

  if ("development" !== 'production') {
    if (outerTheme === null && typeof localTheme === 'function') {
      console.error(['Material-UI: You are providing a theme function prop to the ThemeProvider component:', '<ThemeProvider theme={outerTheme => outerTheme} />', '', 'However, no outer theme is present.', 'Make sure a theme is already injected higher in the React tree ' + 'or provide a theme object.'].join('\n'));
    }
  }

  var theme = _react.default.useMemo(function () {
    var output = outerTheme === null ? localTheme : mergeOuterLocalTheme(outerTheme, localTheme);

    if (output != null) {
      output[_nested.default] = outerTheme !== null;
    }

    return output;
  }, [localTheme, outerTheme]);

  return /*#__PURE__*/_react.default.createElement(_ThemeContext.default.Provider, {
    value: theme
  }, children);
}

"development" !== "production" ? ThemeProvider.propTypes = {
  /**
   * Your component tree.
   */
  children: _propTypes.default.node.isRequired,

  /**
   * A theme object. You can provide a function to extend the outer theme.
   */
  theme: _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.func]).isRequired
} : void 0;

if ("development" !== 'production') {
  "development" !== "production" ? ThemeProvider.propTypes = (0, _utils.exactProp)(ThemeProvider.propTypes) : void 0;
}

var _default = ThemeProvider;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\ThemeProvider\\ThemeProvider.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\ThemeProvider\\index.js", {"./ThemeProvider":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\ThemeProvider\\ThemeProvider.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CThemeProvider%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _ThemeProvider.default;
  }
});

var _ThemeProvider = _interopRequireDefault(require("./ThemeProvider"));
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\ThemeProvider\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\ThemeProvider\\nested.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CThemeProvider%5Cnested.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var hasSymbol = typeof Symbol === 'function' && Symbol.for;

var _default = hasSymbol ? Symbol.for('mui.nested') : '__THEME_NESTED__';

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\ThemeProvider\\nested.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\createGenerateClassName\\createGenerateClassName.js", {"../ThemeProvider/nested":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\ThemeProvider\\nested.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CcreateGenerateClassName%5CcreateGenerateClassName.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createGenerateClassName;

var _nested = _interopRequireDefault(require("../ThemeProvider/nested"));

/**
 * This is the list of the style rule name we use as drop in replacement for the built-in
 * pseudo classes (:checked, :disabled, :focused, etc.).
 *
 * Why do they exist in the first place?
 * These classes are used at a specificity of 2.
 * It allows them to override previously definied styles as well as
 * being untouched by simple user overrides.
 */
var pseudoClasses = ['checked', 'disabled', 'error', 'focused', 'focusVisible', 'required', 'expanded', 'selected']; // Returns a function which generates unique class names based on counters.
// When new generator function is created, rule counter is reset.
// We need to reset the rule counter for SSR for each request.
//
// It's inspired by
// https://github.com/cssinjs/jss/blob/4e6a05dd3f7b6572fdd3ab216861d9e446c20331/src/utils/createGenerateClassName.js

function createGenerateClassName() {
  var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var _options$disableGloba = options.disableGlobal,
      disableGlobal = _options$disableGloba === void 0 ? false : _options$disableGloba,
      _options$productionPr = options.productionPrefix,
      productionPrefix = _options$productionPr === void 0 ? 'jss' : _options$productionPr,
      _options$seed = options.seed,
      seed = _options$seed === void 0 ? '' : _options$seed;
  var seedPrefix = seed === '' ? '' : "".concat(seed, "-");
  var ruleCounter = 0;

  var getNextCounterId = function getNextCounterId() {
    ruleCounter += 1;

    if ("development" !== 'production') {
      if (ruleCounter >= 1e10) {
        console.warn(['Material-UI: You might have a memory leak.', 'The ruleCounter is not supposed to grow that much.'].join(''));
      }
    }

    return ruleCounter;
  };

  return function (rule, styleSheet) {
    var name = styleSheet.options.name; // Is a global static MUI style?

    if (name && name.indexOf('Mui') === 0 && !styleSheet.options.link && !disableGlobal) {
      // We can use a shorthand class name, we never use the keys to style the components.
      if (pseudoClasses.indexOf(rule.key) !== -1) {
        return "Mui-".concat(rule.key);
      }

      var prefix = "".concat(seedPrefix).concat(name, "-").concat(rule.key);

      if (!styleSheet.options.theme[_nested.default] || seed !== '') {
        return prefix;
      }

      return "".concat(prefix, "-").concat(getNextCounterId());
    }

    if ("development" === 'production') {
      return "".concat(seedPrefix).concat(productionPrefix).concat(getNextCounterId());
    }

    var suffix = "".concat(rule.key, "-").concat(getNextCounterId()); // Help with debuggability.

    if (styleSheet.options.classNamePrefix) {
      return "".concat(seedPrefix).concat(styleSheet.options.classNamePrefix, "-").concat(suffix);
    }

    return "".concat(seedPrefix).concat(suffix);
  };
}
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\createGenerateClassName\\createGenerateClassName.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\createGenerateClassName\\index.js", {"./createGenerateClassName":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\createGenerateClassName\\createGenerateClassName.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CcreateGenerateClassName%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _createGenerateClassName.default;
  }
});

var _createGenerateClassName = _interopRequireDefault(require("./createGenerateClassName"));
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\createGenerateClassName\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\createStyles\\createStyles.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CcreateStyles%5CcreateStyles.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createStyles;

function createStyles(styles) {
  return styles;
}
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\createStyles\\createStyles.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\createStyles\\index.js", {"./createStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\createStyles\\createStyles.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CcreateStyles%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _createStyles.default;
  }
});

var _createStyles = _interopRequireDefault(require("./createStyles"));
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\createStyles\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\getStylesCreator\\getStylesCreator.js", {"./noopTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\getStylesCreator\\noopTheme.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/typeof":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\typeof.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CgetStylesCreator%5CgetStylesCreator.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getStylesCreator;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _utils = require("@material-ui/utils");

var _noopTheme = _interopRequireDefault(require("./noopTheme"));

function getStylesCreator(stylesOrCreator) {
  var themingEnabled = typeof stylesOrCreator === 'function';

  if ("development" !== 'production') {
    if ((0, _typeof2.default)(stylesOrCreator) !== 'object' && !themingEnabled) {
      console.error(['Material-UI: The `styles` argument provided is invalid.', 'You need to provide a function generating the styles or a styles object.'].join('\n'));
    }
  }

  return {
    create: function create(theme, name) {
      var styles;

      try {
        styles = themingEnabled ? stylesOrCreator(theme) : stylesOrCreator;
      } catch (err) {
        if ("development" !== 'production') {
          if (themingEnabled === true && theme === _noopTheme.default) {
            // TODO: prepend error message/name instead
            console.error(['Material-UI: The `styles` argument provided is invalid.', 'You are providing a function without a theme in the context.', 'One of the parent elements needs to use a ThemeProvider.'].join('\n'));
          }
        }

        throw err;
      }

      if (!name || !theme.overrides || !theme.overrides[name]) {
        return styles;
      }

      var overrides = theme.overrides[name];
      var stylesWithOverrides = (0, _extends2.default)({}, styles);
      Object.keys(overrides).forEach(function (key) {
        if ("development" !== 'production') {
          if (!stylesWithOverrides[key]) {
            console.warn(['Material-UI: You are trying to override a style that does not exist.', "Fix the `".concat(key, "` key of `theme.overrides.").concat(name, "`.")].join('\n'));
          }
        }

        stylesWithOverrides[key] = (0, _utils.deepmerge)(stylesWithOverrides[key], overrides[key]);
      });
      return stylesWithOverrides;
    },
    options: {}
  };
}
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\getStylesCreator\\getStylesCreator.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\getStylesCreator\\index.js", {"./getStylesCreator":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\getStylesCreator\\getStylesCreator.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CgetStylesCreator%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _getStylesCreator.default;
  }
});

var _getStylesCreator = _interopRequireDefault(require("./getStylesCreator"));
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\getStylesCreator\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\getStylesCreator\\noopTheme.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CgetStylesCreator%5CnoopTheme.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
// We use the same empty object to ref count the styles that don't need a theme object.
var noopTheme = {};
var _default = noopTheme;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\getStylesCreator\\noopTheme.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\getThemeProps\\getThemeProps.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CgetThemeProps%5CgetThemeProps.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getThemeProps;

/* eslint-disable no-restricted-syntax */
function getThemeProps(params) {
  var theme = params.theme,
      name = params.name,
      props = params.props;

  if (!theme || !theme.props || !theme.props[name]) {
    return props;
  } // Resolve default props, code borrow from React source.
  // https://github.com/facebook/react/blob/15a8f031838a553e41c0b66eb1bcf1da8448104d/packages/react/src/ReactElement.js#L221


  var defaultProps = theme.props[name];
  var propName;

  for (propName in defaultProps) {
    if (props[propName] === undefined) {
      props[propName] = defaultProps[propName];
    }
  }

  return props;
}
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\getThemeProps\\getThemeProps.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\getThemeProps\\index.js", {"./getThemeProps":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\getThemeProps\\getThemeProps.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CgetThemeProps%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _getThemeProps.default;
  }
});

var _getThemeProps = _interopRequireDefault(require("./getThemeProps"));
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\getThemeProps\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\index.js", {"./ServerStyleSheets":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\ServerStyleSheets\\index.js","./StylesProvider":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\StylesProvider\\index.js","./ThemeProvider":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\ThemeProvider\\index.js","./createGenerateClassName":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\createGenerateClassName\\index.js","./createStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\createStyles\\index.js","./getThemeProps":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\getThemeProps\\index.js","./jssPreset":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\jssPreset\\index.js","./makeStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\makeStyles\\index.js","./mergeClasses":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\mergeClasses\\index.js","./styled":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\styled\\index.js","./useTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\useTheme\\index.js","./withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\withStyles\\index.js","./withTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\withTheme\\index.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5Cindex.js
      return function (require, module, exports) {
/** @license Material-UI v4.11.5
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  createGenerateClassName: true,
  createStyles: true,
  getThemeProps: true,
  jssPreset: true,
  makeStyles: true,
  mergeClasses: true,
  ServerStyleSheets: true,
  styled: true,
  StylesProvider: true,
  ThemeProvider: true,
  useTheme: true,
  withStyles: true,
  withTheme: true
};
Object.defineProperty(exports, "createGenerateClassName", {
  enumerable: true,
  get: function get() {
    return _createGenerateClassName.default;
  }
});
Object.defineProperty(exports, "createStyles", {
  enumerable: true,
  get: function get() {
    return _createStyles.default;
  }
});
Object.defineProperty(exports, "getThemeProps", {
  enumerable: true,
  get: function get() {
    return _getThemeProps.default;
  }
});
Object.defineProperty(exports, "jssPreset", {
  enumerable: true,
  get: function get() {
    return _jssPreset.default;
  }
});
Object.defineProperty(exports, "makeStyles", {
  enumerable: true,
  get: function get() {
    return _makeStyles.default;
  }
});
Object.defineProperty(exports, "mergeClasses", {
  enumerable: true,
  get: function get() {
    return _mergeClasses.default;
  }
});
Object.defineProperty(exports, "ServerStyleSheets", {
  enumerable: true,
  get: function get() {
    return _ServerStyleSheets.default;
  }
});
Object.defineProperty(exports, "styled", {
  enumerable: true,
  get: function get() {
    return _styled.default;
  }
});
Object.defineProperty(exports, "StylesProvider", {
  enumerable: true,
  get: function get() {
    return _StylesProvider.default;
  }
});
Object.defineProperty(exports, "ThemeProvider", {
  enumerable: true,
  get: function get() {
    return _ThemeProvider.default;
  }
});
Object.defineProperty(exports, "useTheme", {
  enumerable: true,
  get: function get() {
    return _useTheme.default;
  }
});
Object.defineProperty(exports, "withStyles", {
  enumerable: true,
  get: function get() {
    return _withStyles.default;
  }
});
Object.defineProperty(exports, "withTheme", {
  enumerable: true,
  get: function get() {
    return _withTheme.default;
  }
});

var _utils = require("@material-ui/utils");

var _createGenerateClassName = _interopRequireWildcard(require("./createGenerateClassName"));

Object.keys(_createGenerateClassName).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _createGenerateClassName[key];
    }
  });
});

var _createStyles = _interopRequireWildcard(require("./createStyles"));

Object.keys(_createStyles).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _createStyles[key];
    }
  });
});

var _getThemeProps = _interopRequireWildcard(require("./getThemeProps"));

Object.keys(_getThemeProps).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _getThemeProps[key];
    }
  });
});

var _jssPreset = _interopRequireWildcard(require("./jssPreset"));

Object.keys(_jssPreset).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _jssPreset[key];
    }
  });
});

var _makeStyles = _interopRequireWildcard(require("./makeStyles"));

Object.keys(_makeStyles).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _makeStyles[key];
    }
  });
});

var _mergeClasses = _interopRequireWildcard(require("./mergeClasses"));

Object.keys(_mergeClasses).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _mergeClasses[key];
    }
  });
});

var _ServerStyleSheets = _interopRequireWildcard(require("./ServerStyleSheets"));

Object.keys(_ServerStyleSheets).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _ServerStyleSheets[key];
    }
  });
});

var _styled = _interopRequireWildcard(require("./styled"));

Object.keys(_styled).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _styled[key];
    }
  });
});

var _StylesProvider = _interopRequireWildcard(require("./StylesProvider"));

Object.keys(_StylesProvider).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _StylesProvider[key];
    }
  });
});

var _ThemeProvider = _interopRequireWildcard(require("./ThemeProvider"));

Object.keys(_ThemeProvider).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _ThemeProvider[key];
    }
  });
});

var _useTheme = _interopRequireWildcard(require("./useTheme"));

Object.keys(_useTheme).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _useTheme[key];
    }
  });
});

var _withStyles = _interopRequireWildcard(require("./withStyles"));

Object.keys(_withStyles).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _withStyles[key];
    }
  });
});

var _withTheme = _interopRequireWildcard(require("./withTheme"));

Object.keys(_withTheme).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _withTheme[key];
    }
  });
});

/* eslint-disable import/export */

/* Warning if there are several instances of @material-ui/styles */
if ("development" !== 'production' && "development" !== 'test' && typeof window !== 'undefined') {
  _utils.ponyfillGlobal['__@material-ui/styles-init__'] = _utils.ponyfillGlobal['__@material-ui/styles-init__'] || 0;

  if (_utils.ponyfillGlobal['__@material-ui/styles-init__'] === 1) {
    console.warn(['It looks like there are several instances of `@material-ui/styles` initialized in this application.', 'This may cause theme propagation issues, broken class names, ' + 'specificity issues, and makes your application bigger without a good reason.', '', 'See https://mui.com/r/styles-instance-warning for more info.'].join('\n'));
  }

  _utils.ponyfillGlobal['__@material-ui/styles-init__'] += 1;
}
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\jssPreset\\index.js", {"./jssPreset":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\jssPreset\\jssPreset.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CjssPreset%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _jssPreset.default;
  }
});

var _jssPreset = _interopRequireDefault(require("./jssPreset"));
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\jssPreset\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\jssPreset\\jssPreset.js", {"@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","jss-plugin-camel-case":"D:\\code\\v\\metamask-extension\\node_modules\\jss-plugin-camel-case\\dist\\jss-plugin-camel-case.cjs.js","jss-plugin-default-unit":"D:\\code\\v\\metamask-extension\\node_modules\\jss-plugin-default-unit\\dist\\jss-plugin-default-unit.cjs.js","jss-plugin-global":"D:\\code\\v\\metamask-extension\\node_modules\\jss-plugin-global\\dist\\jss-plugin-global.cjs.js","jss-plugin-nested":"D:\\code\\v\\metamask-extension\\node_modules\\jss-plugin-nested\\dist\\jss-plugin-nested.cjs.js","jss-plugin-props-sort":"D:\\code\\v\\metamask-extension\\node_modules\\jss-plugin-props-sort\\dist\\jss-plugin-props-sort.cjs.js","jss-plugin-rule-value-function":"D:\\code\\v\\metamask-extension\\node_modules\\jss-plugin-rule-value-function\\dist\\jss-plugin-rule-value-function.cjs.js","jss-plugin-vendor-prefixer":"D:\\code\\v\\metamask-extension\\node_modules\\jss-plugin-vendor-prefixer\\dist\\jss-plugin-vendor-prefixer.cjs.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CjssPreset%5CjssPreset.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = jssPreset;

var _jssPluginRuleValueFunction = _interopRequireDefault(require("jss-plugin-rule-value-function"));

var _jssPluginGlobal = _interopRequireDefault(require("jss-plugin-global"));

var _jssPluginNested = _interopRequireDefault(require("jss-plugin-nested"));

var _jssPluginCamelCase = _interopRequireDefault(require("jss-plugin-camel-case"));

var _jssPluginDefaultUnit = _interopRequireDefault(require("jss-plugin-default-unit"));

var _jssPluginVendorPrefixer = _interopRequireDefault(require("jss-plugin-vendor-prefixer"));

var _jssPluginPropsSort = _interopRequireDefault(require("jss-plugin-props-sort"));

// Subset of jss-preset-default with only the plugins the Material-UI components are using.
function jssPreset() {
  return {
    plugins: [(0, _jssPluginRuleValueFunction.default)(), (0, _jssPluginGlobal.default)(), (0, _jssPluginNested.default)(), (0, _jssPluginCamelCase.default)(), (0, _jssPluginDefaultUnit.default)(), // Disable the vendor prefixer server-side, it does nothing.
    // This way, we can get a performance boost.
    // In the documentation, we are using `autoprefixer` to solve this problem.
    typeof window === 'undefined' ? null : (0, _jssPluginVendorPrefixer.default)(), (0, _jssPluginPropsSort.default)()]
  };
}
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\jssPreset\\jssPreset.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\makeStyles\\index.js", {"./makeStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\makeStyles\\makeStyles.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CmakeStyles%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _makeStyles.default;
  }
});

var _makeStyles = _interopRequireDefault(require("./makeStyles"));
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\makeStyles\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\makeStyles\\indexCounter.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CmakeStyles%5CindexCounter.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.increment = increment;

/* eslint-disable import/prefer-default-export */
// Global index counter to preserve source order.
// We create the style sheet during the creation of the component,
// children are handled after the parents, so the order of style elements would be parent->child.
// It is a problem though when a parent passes a className
// which needs to override any child's styles.
// StyleSheet of the child has a higher specificity, because of the source order.
// So our solution is to render sheets them in the reverse order child->sheet, so
// that parent has a higher specificity.
var indexCounter = -1e9;

function increment() {
  indexCounter += 1;

  if ("development" !== 'production') {
    if (indexCounter >= 0) {
      console.warn(['Material-UI: You might have a memory leak.', 'The indexCounter is not supposed to grow that much.'].join('\n'));
    }
  }

  return indexCounter;
}
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\makeStyles\\indexCounter.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\makeStyles\\makeStyles.js", {"../StylesProvider":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\StylesProvider\\index.js","../getStylesCreator":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\getStylesCreator\\index.js","../getStylesCreator/noopTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\getStylesCreator\\noopTheme.js","../mergeClasses":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\mergeClasses\\index.js","../useTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\useTheme\\index.js","./indexCounter":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\makeStyles\\indexCounter.js","./multiKeyStore":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\makeStyles\\multiKeyStore.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","jss":"D:\\code\\v\\metamask-extension\\node_modules\\jss\\dist\\jss.cjs.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CmakeStyles%5CmakeStyles.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = makeStyles;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _jss = require("jss");

var _mergeClasses = _interopRequireDefault(require("../mergeClasses"));

var _multiKeyStore = _interopRequireDefault(require("./multiKeyStore"));

var _useTheme = _interopRequireDefault(require("../useTheme"));

var _StylesProvider = require("../StylesProvider");

var _indexCounter = require("./indexCounter");

var _getStylesCreator = _interopRequireDefault(require("../getStylesCreator"));

var _noopTheme = _interopRequireDefault(require("../getStylesCreator/noopTheme"));

function getClasses(_ref, classes, Component) {
  var state = _ref.state,
      stylesOptions = _ref.stylesOptions;

  if (stylesOptions.disableGeneration) {
    return classes || {};
  }

  if (!state.cacheClasses) {
    state.cacheClasses = {
      // Cache for the finalized classes value.
      value: null,
      // Cache for the last used classes prop pointer.
      lastProp: null,
      // Cache for the last used rendered classes pointer.
      lastJSS: {}
    };
  } // Tracks if either the rendered classes or classes prop has changed,
  // requiring the generation of a new finalized classes object.


  var generate = false;

  if (state.classes !== state.cacheClasses.lastJSS) {
    state.cacheClasses.lastJSS = state.classes;
    generate = true;
  }

  if (classes !== state.cacheClasses.lastProp) {
    state.cacheClasses.lastProp = classes;
    generate = true;
  }

  if (generate) {
    state.cacheClasses.value = (0, _mergeClasses.default)({
      baseClasses: state.cacheClasses.lastJSS,
      newClasses: classes,
      Component: Component
    });
  }

  return state.cacheClasses.value;
}

function attach(_ref2, props) {
  var state = _ref2.state,
      theme = _ref2.theme,
      stylesOptions = _ref2.stylesOptions,
      stylesCreator = _ref2.stylesCreator,
      name = _ref2.name;

  if (stylesOptions.disableGeneration) {
    return;
  }

  var sheetManager = _multiKeyStore.default.get(stylesOptions.sheetsManager, stylesCreator, theme);

  if (!sheetManager) {
    sheetManager = {
      refs: 0,
      staticSheet: null,
      dynamicStyles: null
    };

    _multiKeyStore.default.set(stylesOptions.sheetsManager, stylesCreator, theme, sheetManager);
  }

  var options = (0, _extends2.default)({}, stylesCreator.options, stylesOptions, {
    theme: theme,
    flip: typeof stylesOptions.flip === 'boolean' ? stylesOptions.flip : theme.direction === 'rtl'
  });
  options.generateId = options.serverGenerateClassName || options.generateClassName;
  var sheetsRegistry = stylesOptions.sheetsRegistry;

  if (sheetManager.refs === 0) {
    var staticSheet;

    if (stylesOptions.sheetsCache) {
      staticSheet = _multiKeyStore.default.get(stylesOptions.sheetsCache, stylesCreator, theme);
    }

    var styles = stylesCreator.create(theme, name);

    if (!staticSheet) {
      staticSheet = stylesOptions.jss.createStyleSheet(styles, (0, _extends2.default)({
        link: false
      }, options));
      staticSheet.attach();

      if (stylesOptions.sheetsCache) {
        _multiKeyStore.default.set(stylesOptions.sheetsCache, stylesCreator, theme, staticSheet);
      }
    }

    if (sheetsRegistry) {
      sheetsRegistry.add(staticSheet);
    }

    sheetManager.staticSheet = staticSheet;
    sheetManager.dynamicStyles = (0, _jss.getDynamicStyles)(styles);
  }

  if (sheetManager.dynamicStyles) {
    var dynamicSheet = stylesOptions.jss.createStyleSheet(sheetManager.dynamicStyles, (0, _extends2.default)({
      link: true
    }, options));
    dynamicSheet.update(props);
    dynamicSheet.attach();
    state.dynamicSheet = dynamicSheet;
    state.classes = (0, _mergeClasses.default)({
      baseClasses: sheetManager.staticSheet.classes,
      newClasses: dynamicSheet.classes
    });

    if (sheetsRegistry) {
      sheetsRegistry.add(dynamicSheet);
    }
  } else {
    state.classes = sheetManager.staticSheet.classes;
  }

  sheetManager.refs += 1;
}

function update(_ref3, props) {
  var state = _ref3.state;

  if (state.dynamicSheet) {
    state.dynamicSheet.update(props);
  }
}

function detach(_ref4) {
  var state = _ref4.state,
      theme = _ref4.theme,
      stylesOptions = _ref4.stylesOptions,
      stylesCreator = _ref4.stylesCreator;

  if (stylesOptions.disableGeneration) {
    return;
  }

  var sheetManager = _multiKeyStore.default.get(stylesOptions.sheetsManager, stylesCreator, theme);

  sheetManager.refs -= 1;
  var sheetsRegistry = stylesOptions.sheetsRegistry;

  if (sheetManager.refs === 0) {
    _multiKeyStore.default.delete(stylesOptions.sheetsManager, stylesCreator, theme);

    stylesOptions.jss.removeStyleSheet(sheetManager.staticSheet);

    if (sheetsRegistry) {
      sheetsRegistry.remove(sheetManager.staticSheet);
    }
  }

  if (state.dynamicSheet) {
    stylesOptions.jss.removeStyleSheet(state.dynamicSheet);

    if (sheetsRegistry) {
      sheetsRegistry.remove(state.dynamicSheet);
    }
  }
}

function useSynchronousEffect(func, values) {
  var key = _react.default.useRef([]);

  var output; // Store "generation" key. Just returns a new object every time

  var currentKey = _react.default.useMemo(function () {
    return {};
  }, values); // eslint-disable-line react-hooks/exhaustive-deps
  // "the first render", or "memo dropped the value"


  if (key.current !== currentKey) {
    key.current = currentKey;
    output = func();
  }

  _react.default.useEffect(function () {
    return function () {
      if (output) {
        output();
      }
    };
  }, [currentKey] // eslint-disable-line react-hooks/exhaustive-deps
  );
}

function makeStyles(stylesOrCreator) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var name = options.name,
      classNamePrefixOption = options.classNamePrefix,
      Component = options.Component,
      _options$defaultTheme = options.defaultTheme,
      defaultTheme = _options$defaultTheme === void 0 ? _noopTheme.default : _options$defaultTheme,
      stylesOptions2 = (0, _objectWithoutProperties2.default)(options, ["name", "classNamePrefix", "Component", "defaultTheme"]);
  var stylesCreator = (0, _getStylesCreator.default)(stylesOrCreator);
  var classNamePrefix = name || classNamePrefixOption || 'makeStyles';
  stylesCreator.options = {
    index: (0, _indexCounter.increment)(),
    name: name,
    meta: classNamePrefix,
    classNamePrefix: classNamePrefix
  };

  var useStyles = function useStyles() {
    var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var theme = (0, _useTheme.default)() || defaultTheme;
    var stylesOptions = (0, _extends2.default)({}, _react.default.useContext(_StylesProvider.StylesContext), stylesOptions2);

    var instance = _react.default.useRef();

    var shouldUpdate = _react.default.useRef();

    useSynchronousEffect(function () {
      var current = {
        name: name,
        state: {},
        stylesCreator: stylesCreator,
        stylesOptions: stylesOptions,
        theme: theme
      };
      attach(current, props);
      shouldUpdate.current = false;
      instance.current = current;
      return function () {
        detach(current);
      };
    }, [theme, stylesCreator]);

    _react.default.useEffect(function () {
      if (shouldUpdate.current) {
        update(instance.current, props);
      }

      shouldUpdate.current = true;
    });

    var classes = getClasses(instance.current, props.classes, Component);

    if ("development" !== 'production') {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      _react.default.useDebugValue(classes);
    }

    return classes;
  };

  return useStyles;
}
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\makeStyles\\makeStyles.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\makeStyles\\multiKeyStore.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CmakeStyles%5CmultiKeyStore.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
// Used https://github.com/thinkloop/multi-key-cache as inspiration
var multiKeyStore = {
  set: function set(cache, key1, key2, value) {
    var subCache = cache.get(key1);

    if (!subCache) {
      subCache = new Map();
      cache.set(key1, subCache);
    }

    subCache.set(key2, value);
  },
  get: function get(cache, key1, key2) {
    var subCache = cache.get(key1);
    return subCache ? subCache.get(key2) : undefined;
  },
  delete: function _delete(cache, key1, key2) {
    var subCache = cache.get(key1);
    subCache.delete(key2);
  }
};
var _default = multiKeyStore;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\makeStyles\\multiKeyStore.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\mergeClasses\\index.js", {"./mergeClasses":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\mergeClasses\\mergeClasses.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CmergeClasses%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _mergeClasses.default;
  }
});

var _mergeClasses = _interopRequireDefault(require("./mergeClasses"));
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\mergeClasses\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\mergeClasses\\mergeClasses.js", {"@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CmergeClasses%5CmergeClasses.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = mergeClasses;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _utils = require("@material-ui/utils");

function mergeClasses() {
  var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var baseClasses = options.baseClasses,
      newClasses = options.newClasses,
      Component = options.Component;

  if (!newClasses) {
    return baseClasses;
  }

  var nextClasses = (0, _extends2.default)({}, baseClasses);

  if ("development" !== 'production') {
    if (typeof newClasses === 'string') {
      console.error(["Material-UI: The value `".concat(newClasses, "` ") + "provided to the classes prop of ".concat((0, _utils.getDisplayName)(Component), " is incorrect."), 'You might want to use the className prop instead.'].join('\n'));
      return baseClasses;
    }
  }

  Object.keys(newClasses).forEach(function (key) {
    if ("development" !== 'production') {
      if (!baseClasses[key] && newClasses[key]) {
        console.error(["Material-UI: The key `".concat(key, "` ") + "provided to the classes prop is not implemented in ".concat((0, _utils.getDisplayName)(Component), "."), "You can only override one of the following: ".concat(Object.keys(baseClasses).join(','), ".")].join('\n'));
      }

      if (newClasses[key] && typeof newClasses[key] !== 'string') {
        console.error(["Material-UI: The key `".concat(key, "` ") + "provided to the classes prop is not valid for ".concat((0, _utils.getDisplayName)(Component), "."), "You need to provide a non empty string instead of: ".concat(newClasses[key], ".")].join('\n'));
      }
    }

    if (newClasses[key]) {
      nextClasses[key] = "".concat(baseClasses[key], " ").concat(newClasses[key]);
    }
  });
  return nextClasses;
}
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\mergeClasses\\mergeClasses.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\node_modules\\clsx\\dist\\clsx.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5Cnode_modules%5Cclsx%5Cdist%5Cclsx.js
      return function (require, module, exports) {
function toVal(mix) {
	var k, y, str='';

	if (typeof mix === 'string' || typeof mix === 'number') {
		str += mix;
	} else if (typeof mix === 'object') {
		if (Array.isArray(mix)) {
			for (k=0; k < mix.length; k++) {
				if (mix[k]) {
					if (y = toVal(mix[k])) {
						str && (str += ' ');
						str += y;
					}
				}
			}
		} else {
			for (k in mix) {
				if (mix[k]) {
					str && (str += ' ');
					str += k;
				}
			}
		}
	}

	return str;
}

module.exports = function () {
	var i=0, tmp, x, str='';
	while (i < arguments.length) {
		if (tmp = arguments[i++]) {
			if (x = toVal(tmp)) {
				str && (str += ' ');
				str += x
			}
		}
	}
	return str;
}

      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles>clsx",file:"node_modules\\@material-ui\\styles\\node_modules\\clsx\\dist\\clsx.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\styled\\index.js", {"./styled":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\styled\\styled.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5Cstyled%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _styled.default;
  }
});

var _styled = _interopRequireDefault(require("./styled"));
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\styled\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\styled\\styled.js", {"../makeStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\makeStyles\\index.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js","clsx":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\node_modules\\clsx\\dist\\clsx.js","hoist-non-react-statics":"D:\\code\\v\\metamask-extension\\node_modules\\hoist-non-react-statics\\dist\\hoist-non-react-statics.cjs.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5Cstyled%5Cstyled.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = styled;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _clsx = _interopRequireDefault(require("clsx"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _utils = require("@material-ui/utils");

var _hoistNonReactStatics = _interopRequireDefault(require("hoist-non-react-statics"));

var _makeStyles = _interopRequireDefault(require("../makeStyles"));

function omit(input, fields) {
  var output = {};
  Object.keys(input).forEach(function (prop) {
    if (fields.indexOf(prop) === -1) {
      output[prop] = input[prop];
    }
  });
  return output;
} // styled-components's API removes the mapping between components and styles.
// Using components as a low-level styling construct can be simpler.


function styled(Component) {
  var componentCreator = function componentCreator(style) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var name = options.name,
        stylesOptions = (0, _objectWithoutProperties2.default)(options, ["name"]);

    if ("development" !== 'production' && Component === undefined) {
      throw new Error(['You are calling styled(Component)(style) with an undefined component.', 'You may have forgotten to import it.'].join('\n'));
    }

    var classNamePrefix = name;

    if ("development" !== 'production') {
      if (!name) {
        // Provide a better DX outside production.
        var displayName = (0, _utils.getDisplayName)(Component);

        if (displayName !== undefined) {
          classNamePrefix = displayName;
        }
      }
    }

    var stylesOrCreator = typeof style === 'function' ? function (theme) {
      return {
        root: function root(props) {
          return style((0, _extends2.default)({
            theme: theme
          }, props));
        }
      };
    } : {
      root: style
    };
    var useStyles = (0, _makeStyles.default)(stylesOrCreator, (0, _extends2.default)({
      Component: Component,
      name: name || Component.displayName,
      classNamePrefix: classNamePrefix
    }, stylesOptions));
    var filterProps;
    var propTypes = {};

    if (style.filterProps) {
      filterProps = style.filterProps;
      delete style.filterProps;
    }
    /* eslint-disable react/forbid-foreign-prop-types */


    if (style.propTypes) {
      propTypes = style.propTypes;
      delete style.propTypes;
    }
    /* eslint-enable react/forbid-foreign-prop-types */


    var StyledComponent = /*#__PURE__*/_react.default.forwardRef(function StyledComponent(props, ref) {
      var children = props.children,
          classNameProp = props.className,
          clone = props.clone,
          ComponentProp = props.component,
          other = (0, _objectWithoutProperties2.default)(props, ["children", "className", "clone", "component"]);
      var classes = useStyles(props);
      var className = (0, _clsx.default)(classes.root, classNameProp);
      var spread = other;

      if (filterProps) {
        spread = omit(spread, filterProps);
      }

      if (clone) {
        return /*#__PURE__*/_react.default.cloneElement(children, (0, _extends2.default)({
          className: (0, _clsx.default)(children.props.className, className)
        }, spread));
      }

      if (typeof children === 'function') {
        return children((0, _extends2.default)({
          className: className
        }, spread));
      }

      var FinalComponent = ComponentProp || Component;
      return /*#__PURE__*/_react.default.createElement(FinalComponent, (0, _extends2.default)({
        ref: ref,
        className: className
      }, spread), children);
    });

    "development" !== "production" ? StyledComponent.propTypes = (0, _extends2.default)({
      /**
       * A render function or node.
       */
      children: _propTypes.default.oneOfType([_propTypes.default.node, _propTypes.default.func]),

      /**
       * @ignore
       */
      className: _propTypes.default.string,

      /**
       * If `true`, the component will recycle it's children HTML element.
       * It's using `React.cloneElement` internally.
       *
       * This prop will be deprecated and removed in v5
       */
      clone: (0, _utils.chainPropTypes)(_propTypes.default.bool, function (props) {
        if (props.clone && props.component) {
          return new Error('You can not use the clone and component prop at the same time.');
        }

        return null;
      }),

      /**
       * The component used for the root node.
       * Either a string to use a HTML element or a component.
       */
      component: _propTypes.default
      /* @typescript-to-proptypes-ignore */
      .elementType
    }, propTypes) : void 0;

    if ("development" !== 'production') {
      StyledComponent.displayName = "Styled(".concat(classNamePrefix, ")");
    }

    (0, _hoistNonReactStatics.default)(StyledComponent, Component);
    return StyledComponent;
  };

  return componentCreator;
}
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\styled\\styled.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\useTheme\\ThemeContext.js", {"@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CuseTheme%5CThemeContext.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var ThemeContext = _react.default.createContext(null);

if ("development" !== 'production') {
  ThemeContext.displayName = 'ThemeContext';
}

var _default = ThemeContext;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\useTheme\\ThemeContext.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\useTheme\\index.js", {"./useTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\useTheme\\useTheme.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CuseTheme%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _useTheme.default;
  }
});

var _useTheme = _interopRequireDefault(require("./useTheme"));
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\useTheme\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\useTheme\\useTheme.js", {"./ThemeContext":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\useTheme\\ThemeContext.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CuseTheme%5CuseTheme.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useTheme;

var _react = _interopRequireDefault(require("react"));

var _ThemeContext = _interopRequireDefault(require("./ThemeContext"));

function useTheme() {
  var theme = _react.default.useContext(_ThemeContext.default);

  if ("development" !== 'production') {
    // eslint-disable-next-line react-hooks/rules-of-hooks
    _react.default.useDebugValue(theme);
  }

  return theme;
}
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\useTheme\\useTheme.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\withStyles\\index.js", {"./withStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\withStyles\\withStyles.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CwithStyles%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _withStyles.default;
  }
});

var _withStyles = _interopRequireDefault(require("./withStyles"));
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\withStyles\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\withStyles\\withStyles.js", {"../getThemeProps":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\getThemeProps\\index.js","../makeStyles":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\makeStyles\\index.js","../useTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\useTheme\\index.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js","hoist-non-react-statics":"D:\\code\\v\\metamask-extension\\node_modules\\hoist-non-react-statics\\dist\\hoist-non-react-statics.cjs.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CwithStyles%5CwithStyles.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _hoistNonReactStatics = _interopRequireDefault(require("hoist-non-react-statics"));

var _utils = require("@material-ui/utils");

var _makeStyles = _interopRequireDefault(require("../makeStyles"));

var _getThemeProps = _interopRequireDefault(require("../getThemeProps"));

var _useTheme = _interopRequireDefault(require("../useTheme"));

// Link a style sheet with a component.
// It does not modify the component passed to it;
// instead, it returns a new component, with a `classes` property.
var withStyles = function withStyles(stylesOrCreator) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  return function (Component) {
    var defaultTheme = options.defaultTheme,
        _options$withTheme = options.withTheme,
        withTheme = _options$withTheme === void 0 ? false : _options$withTheme,
        name = options.name,
        stylesOptions = (0, _objectWithoutProperties2.default)(options, ["defaultTheme", "withTheme", "name"]);

    if ("development" !== 'production') {
      if (Component === undefined) {
        throw new Error(['You are calling withStyles(styles)(Component) with an undefined component.', 'You may have forgotten to import it.'].join('\n'));
      }
    }

    var classNamePrefix = name;

    if ("development" !== 'production') {
      if (!name) {
        // Provide a better DX outside production.
        var displayName = (0, _utils.getDisplayName)(Component);

        if (displayName !== undefined) {
          classNamePrefix = displayName;
        }
      }
    }

    var useStyles = (0, _makeStyles.default)(stylesOrCreator, (0, _extends2.default)({
      defaultTheme: defaultTheme,
      Component: Component,
      name: name || Component.displayName,
      classNamePrefix: classNamePrefix
    }, stylesOptions));

    var WithStyles = /*#__PURE__*/_react.default.forwardRef(function WithStyles(props, ref) {
      var classesProp = props.classes,
          innerRef = props.innerRef,
          other = (0, _objectWithoutProperties2.default)(props, ["classes", "innerRef"]); // The wrapper receives only user supplied props, which could be a subset of
      // the actual props Component might receive due to merging with defaultProps.
      // So copying it here would give us the same result in the wrapper as well.

      var classes = useStyles((0, _extends2.default)({}, Component.defaultProps, props));
      var theme;
      var more = other;

      if (typeof name === 'string' || withTheme) {
        // name and withTheme are invariant in the outer scope
        // eslint-disable-next-line react-hooks/rules-of-hooks
        theme = (0, _useTheme.default)() || defaultTheme;

        if (name) {
          more = (0, _getThemeProps.default)({
            theme: theme,
            name: name,
            props: other
          });
        } // Provide the theme to the wrapped component.
        // So we don't have to use the `withTheme()` Higher-order Component.


        if (withTheme && !more.theme) {
          more.theme = theme;
        }
      }

      return /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({
        ref: innerRef || ref,
        classes: classes
      }, more));
    });

    "development" !== "production" ? WithStyles.propTypes = {
      /**
       * Override or extend the styles applied to the component.
       */
      classes: _propTypes.default.object,

      /**
       * Use that prop to pass a ref to the decorated component.
       * @deprecated
       */
      innerRef: (0, _utils.chainPropTypes)(_propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]), function (props) {
        if (props.innerRef == null) {
          return null;
        }

        return null; // return new Error(
        //   'Material-UI: The `innerRef` prop is deprecated and will be removed in v5. ' +
        //     'Refs are now automatically forwarded to the inner component.',
        // );
      })
    } : void 0;

    if ("development" !== 'production') {
      WithStyles.displayName = "WithStyles(".concat((0, _utils.getDisplayName)(Component), ")");
    }

    (0, _hoistNonReactStatics.default)(WithStyles, Component);

    if ("development" !== 'production') {
      // Exposed for test purposes.
      WithStyles.Naked = Component;
      WithStyles.options = options;
      WithStyles.useStyles = useStyles;
    }

    return WithStyles;
  };
};

var _default = withStyles;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\withStyles\\withStyles.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\withTheme\\index.js", {"./withTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\withTheme\\withTheme.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CwithTheme%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {};
Object.defineProperty(exports, "default", {
  enumerable: true,
  get: function get() {
    return _withTheme.default;
  }
});

var _withTheme = _interopRequireWildcard(require("./withTheme"));

Object.keys(_withTheme).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _withTheme[key];
    }
  });
});
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\withTheme\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\withTheme\\withTheme.js", {"../useTheme":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\styles\\useTheme\\index.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/objectWithoutProperties":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\objectWithoutProperties.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js","hoist-non-react-statics":"D:\\code\\v\\metamask-extension\\node_modules\\hoist-non-react-statics\\dist\\hoist-non-react-statics.cjs.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js","react":"D:\\code\\v\\metamask-extension\\node_modules\\react\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cstyles%5CwithTheme%5CwithTheme.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withThemeCreator = withThemeCreator;
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _hoistNonReactStatics = _interopRequireDefault(require("hoist-non-react-statics"));

var _utils = require("@material-ui/utils");

var _useTheme = _interopRequireDefault(require("../useTheme"));

function withThemeCreator() {
  var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var defaultTheme = options.defaultTheme;

  var withTheme = function withTheme(Component) {
    if ("development" !== 'production') {
      if (Component === undefined) {
        throw new Error(['You are calling withTheme(Component) with an undefined component.', 'You may have forgotten to import it.'].join('\n'));
      }
    }

    var WithTheme = /*#__PURE__*/_react.default.forwardRef(function WithTheme(props, ref) {
      var innerRef = props.innerRef,
          other = (0, _objectWithoutProperties2.default)(props, ["innerRef"]);
      var theme = (0, _useTheme.default)() || defaultTheme;
      return /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({
        theme: theme,
        ref: innerRef || ref
      }, other));
    });

    "development" !== "production" ? WithTheme.propTypes = {
      /**
       * Use that prop to pass a ref to the decorated component.
       * @deprecated
       */
      innerRef: (0, _utils.chainPropTypes)(_propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]), function (props) {
        if (props.innerRef == null) {
          return null;
        }

        return new Error('Material-UI: The `innerRef` prop is deprecated and will be removed in v5. ' + 'Refs are now automatically forwarded to the inner component.');
      })
    } : void 0;

    if ("development" !== 'production') {
      WithTheme.displayName = "WithTheme(".concat((0, _utils.getDisplayName)(Component), ")");
    }

    (0, _hoistNonReactStatics.default)(WithTheme, Component);

    if ("development" !== 'production') {
      // Exposed for test purposes.
      WithTheme.Naked = Component;
    }

    return WithTheme;
  };

  return withTheme;
} // Provide the theme object as a prop to the input component.
// It's an alternative API to useTheme().
// We encourage the usage of useTheme() where possible.


var withTheme = withThemeCreator();
var _default = withTheme;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/styles",file:"node_modules\\@material-ui\\styles\\withTheme\\withTheme.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\borders.js", {"./compose":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\compose.js","./style":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\style.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Csystem%5Cborders.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.borderRadius = exports.borderColor = exports.borderLeft = exports.borderBottom = exports.borderRight = exports.borderTop = exports.border = void 0;

var _style = _interopRequireDefault(require("./style"));

var _compose = _interopRequireDefault(require("./compose"));

function getBorder(value) {
  if (typeof value !== 'number') {
    return value;
  }

  return "".concat(value, "px solid");
}

var border = (0, _style.default)({
  prop: 'border',
  themeKey: 'borders',
  transform: getBorder
});
exports.border = border;
var borderTop = (0, _style.default)({
  prop: 'borderTop',
  themeKey: 'borders',
  transform: getBorder
});
exports.borderTop = borderTop;
var borderRight = (0, _style.default)({
  prop: 'borderRight',
  themeKey: 'borders',
  transform: getBorder
});
exports.borderRight = borderRight;
var borderBottom = (0, _style.default)({
  prop: 'borderBottom',
  themeKey: 'borders',
  transform: getBorder
});
exports.borderBottom = borderBottom;
var borderLeft = (0, _style.default)({
  prop: 'borderLeft',
  themeKey: 'borders',
  transform: getBorder
});
exports.borderLeft = borderLeft;
var borderColor = (0, _style.default)({
  prop: 'borderColor',
  themeKey: 'palette'
});
exports.borderColor = borderColor;
var borderRadius = (0, _style.default)({
  prop: 'borderRadius',
  themeKey: 'shape'
});
exports.borderRadius = borderRadius;
var borders = (0, _compose.default)(border, borderTop, borderRight, borderBottom, borderLeft, borderColor, borderRadius);
var _default = borders;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/system",file:"node_modules\\@material-ui\\system\\borders.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\breakpoints.js", {"./merge":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\merge.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/toConsumableArray":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\toConsumableArray.js","@babel/runtime/helpers/typeof":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\typeof.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Csystem%5Cbreakpoints.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleBreakpoints = handleBreakpoints;
exports.default = void 0;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _merge = _interopRequireDefault(require("./merge"));

// The breakpoint **start** at this value.
// For instance with the first breakpoint xs: [xs, sm[.
var values = {
  xs: 0,
  sm: 600,
  md: 960,
  lg: 1280,
  xl: 1920
};
var defaultBreakpoints = {
  // Sorted ASC by size. That's important.
  // It can't be configured as it's used statically for propTypes.
  keys: ['xs', 'sm', 'md', 'lg', 'xl'],
  up: function up(key) {
    return "@media (min-width:".concat(values[key], "px)");
  }
};

function handleBreakpoints(props, propValue, styleFromPropValue) {
  if ("development" !== 'production') {
    if (!props.theme) {
      console.error('Material-UI: You are calling a style function without a theme value.');
    }
  }

  if (Array.isArray(propValue)) {
    var themeBreakpoints = props.theme.breakpoints || defaultBreakpoints;
    return propValue.reduce(function (acc, item, index) {
      acc[themeBreakpoints.up(themeBreakpoints.keys[index])] = styleFromPropValue(propValue[index]);
      return acc;
    }, {});
  }

  if ((0, _typeof2.default)(propValue) === 'object') {
    var _themeBreakpoints = props.theme.breakpoints || defaultBreakpoints;

    return Object.keys(propValue).reduce(function (acc, breakpoint) {
      acc[_themeBreakpoints.up(breakpoint)] = styleFromPropValue(propValue[breakpoint]);
      return acc;
    }, {});
  }

  var output = styleFromPropValue(propValue);
  return output;
}

function breakpoints(styleFunction) {
  var newStyleFunction = function newStyleFunction(props) {
    var base = styleFunction(props);
    var themeBreakpoints = props.theme.breakpoints || defaultBreakpoints;
    var extended = themeBreakpoints.keys.reduce(function (acc, key) {
      if (props[key]) {
        acc = acc || {};
        acc[themeBreakpoints.up(key)] = styleFunction((0, _extends2.default)({
          theme: props.theme
        }, props[key]));
      }

      return acc;
    }, null);
    return (0, _merge.default)(base, extended);
  };

  newStyleFunction.propTypes = "development" !== 'production' ? (0, _extends2.default)({}, styleFunction.propTypes, {
    xs: _propTypes.default.object,
    sm: _propTypes.default.object,
    md: _propTypes.default.object,
    lg: _propTypes.default.object,
    xl: _propTypes.default.object
  }) : {};
  newStyleFunction.filterProps = ['xs', 'sm', 'md', 'lg', 'xl'].concat((0, _toConsumableArray2.default)(styleFunction.filterProps));
  return newStyleFunction;
}

var _default = breakpoints;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/system",file:"node_modules\\@material-ui\\system\\breakpoints.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\compose.js", {"./merge":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\merge.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Csystem%5Ccompose.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _merge = _interopRequireDefault(require("./merge"));

function compose() {
  for (var _len = arguments.length, styles = new Array(_len), _key = 0; _key < _len; _key++) {
    styles[_key] = arguments[_key];
  }

  var fn = function fn(props) {
    return styles.reduce(function (acc, style) {
      var output = style(props);

      if (output) {
        return (0, _merge.default)(acc, output);
      }

      return acc;
    }, {});
  }; // Alternative approach that doesn't yield any performance gain.
  // const handlers = styles.reduce((acc, style) => {
  //   style.filterProps.forEach(prop => {
  //     acc[prop] = style;
  //   });
  //   return acc;
  // }, {});
  // const fn = props => {
  //   return Object.keys(props).reduce((acc, prop) => {
  //     if (handlers[prop]) {
  //       return merge(acc, handlers[prop](props));
  //     }
  //     return acc;
  //   }, {});
  // };


  fn.propTypes = "development" !== 'production' ? styles.reduce(function (acc, style) {
    return (0, _extends2.default)(acc, style.propTypes);
  }, {}) : {};
  fn.filterProps = styles.reduce(function (acc, style) {
    return acc.concat(style.filterProps);
  }, []);
  return fn;
}

var _default = compose;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/system",file:"node_modules\\@material-ui\\system\\compose.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\display.js", {"./compose":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\compose.js","./style":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\style.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Csystem%5Cdisplay.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.whiteSpace = exports.visibility = exports.textOverflow = exports.overflow = exports.displayRaw = exports.displayPrint = void 0;

var _style = _interopRequireDefault(require("./style"));

var _compose = _interopRequireDefault(require("./compose"));

var displayPrint = (0, _style.default)({
  prop: 'displayPrint',
  cssProperty: false,
  transform: function transform(value) {
    return {
      '@media print': {
        display: value
      }
    };
  }
});
exports.displayPrint = displayPrint;
var displayRaw = (0, _style.default)({
  prop: 'display'
});
exports.displayRaw = displayRaw;
var overflow = (0, _style.default)({
  prop: 'overflow'
});
exports.overflow = overflow;
var textOverflow = (0, _style.default)({
  prop: 'textOverflow'
});
exports.textOverflow = textOverflow;
var visibility = (0, _style.default)({
  prop: 'visibility'
});
exports.visibility = visibility;
var whiteSpace = (0, _style.default)({
  prop: 'whiteSpace'
});
exports.whiteSpace = whiteSpace;

var _default = (0, _compose.default)(displayPrint, displayRaw, overflow, textOverflow, visibility, whiteSpace);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/system",file:"node_modules\\@material-ui\\system\\display.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\flexbox.js", {"./compose":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\compose.js","./style":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\style.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Csystem%5Cflexbox.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.justifySelf = exports.justifyItems = exports.alignSelf = exports.flexShrink = exports.flexGrow = exports.flex = exports.order = exports.alignContent = exports.alignItems = exports.justifyContent = exports.flexWrap = exports.flexDirection = exports.flexBasis = void 0;

var _style = _interopRequireDefault(require("./style"));

var _compose = _interopRequireDefault(require("./compose"));

var flexBasis = (0, _style.default)({
  prop: 'flexBasis'
});
exports.flexBasis = flexBasis;
var flexDirection = (0, _style.default)({
  prop: 'flexDirection'
});
exports.flexDirection = flexDirection;
var flexWrap = (0, _style.default)({
  prop: 'flexWrap'
});
exports.flexWrap = flexWrap;
var justifyContent = (0, _style.default)({
  prop: 'justifyContent'
});
exports.justifyContent = justifyContent;
var alignItems = (0, _style.default)({
  prop: 'alignItems'
});
exports.alignItems = alignItems;
var alignContent = (0, _style.default)({
  prop: 'alignContent'
});
exports.alignContent = alignContent;
var order = (0, _style.default)({
  prop: 'order'
});
exports.order = order;
var flex = (0, _style.default)({
  prop: 'flex'
});
exports.flex = flex;
var flexGrow = (0, _style.default)({
  prop: 'flexGrow'
});
exports.flexGrow = flexGrow;
var flexShrink = (0, _style.default)({
  prop: 'flexShrink'
});
exports.flexShrink = flexShrink;
var alignSelf = (0, _style.default)({
  prop: 'alignSelf'
});
exports.alignSelf = alignSelf;
var justifyItems = (0, _style.default)({
  prop: 'justifyItems'
});
exports.justifyItems = justifyItems;
var justifySelf = (0, _style.default)({
  prop: 'justifySelf'
});
exports.justifySelf = justifySelf;
var flexbox = (0, _compose.default)(flexBasis, flexDirection, flexWrap, justifyContent, alignItems, alignContent, order, flex, flexGrow, flexShrink, alignSelf, justifyItems, justifySelf);
var _default = flexbox;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/system",file:"node_modules\\@material-ui\\system\\flexbox.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\grid.js", {"./compose":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\compose.js","./style":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\style.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Csystem%5Cgrid.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.gridArea = exports.gridTemplateAreas = exports.gridTemplateRows = exports.gridTemplateColumns = exports.gridAutoRows = exports.gridAutoColumns = exports.gridAutoFlow = exports.gridRow = exports.gridColumn = exports.gridRowGap = exports.gridColumnGap = exports.gridGap = void 0;

var _style = _interopRequireDefault(require("./style"));

var _compose = _interopRequireDefault(require("./compose"));

var gridGap = (0, _style.default)({
  prop: 'gridGap'
});
exports.gridGap = gridGap;
var gridColumnGap = (0, _style.default)({
  prop: 'gridColumnGap'
});
exports.gridColumnGap = gridColumnGap;
var gridRowGap = (0, _style.default)({
  prop: 'gridRowGap'
});
exports.gridRowGap = gridRowGap;
var gridColumn = (0, _style.default)({
  prop: 'gridColumn'
});
exports.gridColumn = gridColumn;
var gridRow = (0, _style.default)({
  prop: 'gridRow'
});
exports.gridRow = gridRow;
var gridAutoFlow = (0, _style.default)({
  prop: 'gridAutoFlow'
});
exports.gridAutoFlow = gridAutoFlow;
var gridAutoColumns = (0, _style.default)({
  prop: 'gridAutoColumns'
});
exports.gridAutoColumns = gridAutoColumns;
var gridAutoRows = (0, _style.default)({
  prop: 'gridAutoRows'
});
exports.gridAutoRows = gridAutoRows;
var gridTemplateColumns = (0, _style.default)({
  prop: 'gridTemplateColumns'
});
exports.gridTemplateColumns = gridTemplateColumns;
var gridTemplateRows = (0, _style.default)({
  prop: 'gridTemplateRows'
});
exports.gridTemplateRows = gridTemplateRows;
var gridTemplateAreas = (0, _style.default)({
  prop: 'gridTemplateAreas'
});
exports.gridTemplateAreas = gridTemplateAreas;
var gridArea = (0, _style.default)({
  prop: 'gridArea'
});
exports.gridArea = gridArea;
var grid = (0, _compose.default)(gridGap, gridColumnGap, gridRowGap, gridColumn, gridRow, gridAutoFlow, gridAutoColumns, gridAutoRows, gridTemplateColumns, gridTemplateRows, gridTemplateAreas, gridArea);
var _default = grid;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/system",file:"node_modules\\@material-ui\\system\\grid.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\index.js", {"./borders":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\borders.js","./breakpoints":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\breakpoints.js","./compose":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\compose.js","./display":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\display.js","./flexbox":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\flexbox.js","./grid":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\grid.js","./palette":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\palette.js","./positions":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\positions.js","./shadows":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\shadows.js","./sizing":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\sizing.js","./spacing":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\spacing.js","./style":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\style.js","./styleFunctionSx":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\styleFunctionSx.js","./typography":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\typography.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Csystem%5Cindex.js
      return function (require, module, exports) {
/** @license Material-UI v4.12.2
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  borders: true,
  breakpoints: true,
  compose: true,
  styleFunctionSx: true,
  display: true,
  flexbox: true,
  grid: true,
  palette: true,
  positions: true,
  shadows: true,
  sizing: true,
  spacing: true,
  style: true,
  typography: true
};
Object.defineProperty(exports, "borders", {
  enumerable: true,
  get: function get() {
    return _borders.default;
  }
});
Object.defineProperty(exports, "breakpoints", {
  enumerable: true,
  get: function get() {
    return _breakpoints.default;
  }
});
Object.defineProperty(exports, "compose", {
  enumerable: true,
  get: function get() {
    return _compose.default;
  }
});
Object.defineProperty(exports, "styleFunctionSx", {
  enumerable: true,
  get: function get() {
    return _styleFunctionSx.default;
  }
});
Object.defineProperty(exports, "display", {
  enumerable: true,
  get: function get() {
    return _display.default;
  }
});
Object.defineProperty(exports, "flexbox", {
  enumerable: true,
  get: function get() {
    return _flexbox.default;
  }
});
Object.defineProperty(exports, "grid", {
  enumerable: true,
  get: function get() {
    return _grid.default;
  }
});
Object.defineProperty(exports, "palette", {
  enumerable: true,
  get: function get() {
    return _palette.default;
  }
});
Object.defineProperty(exports, "positions", {
  enumerable: true,
  get: function get() {
    return _positions.default;
  }
});
Object.defineProperty(exports, "shadows", {
  enumerable: true,
  get: function get() {
    return _shadows.default;
  }
});
Object.defineProperty(exports, "sizing", {
  enumerable: true,
  get: function get() {
    return _sizing.default;
  }
});
Object.defineProperty(exports, "spacing", {
  enumerable: true,
  get: function get() {
    return _spacing.default;
  }
});
Object.defineProperty(exports, "style", {
  enumerable: true,
  get: function get() {
    return _style.default;
  }
});
Object.defineProperty(exports, "typography", {
  enumerable: true,
  get: function get() {
    return _typography.default;
  }
});

var _borders = _interopRequireWildcard(require("./borders"));

Object.keys(_borders).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _borders[key];
    }
  });
});

var _breakpoints = _interopRequireDefault(require("./breakpoints"));

var _compose = _interopRequireDefault(require("./compose"));

var _styleFunctionSx = _interopRequireWildcard(require("./styleFunctionSx"));

Object.keys(_styleFunctionSx).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _styleFunctionSx[key];
    }
  });
});

var _display = _interopRequireDefault(require("./display"));

var _flexbox = _interopRequireWildcard(require("./flexbox"));

Object.keys(_flexbox).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _flexbox[key];
    }
  });
});

var _grid = _interopRequireWildcard(require("./grid"));

Object.keys(_grid).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _grid[key];
    }
  });
});

var _palette = _interopRequireWildcard(require("./palette"));

Object.keys(_palette).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _palette[key];
    }
  });
});

var _positions = _interopRequireWildcard(require("./positions"));

Object.keys(_positions).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _positions[key];
    }
  });
});

var _shadows = _interopRequireDefault(require("./shadows"));

var _sizing = _interopRequireWildcard(require("./sizing"));

Object.keys(_sizing).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _sizing[key];
    }
  });
});

var _spacing = _interopRequireWildcard(require("./spacing"));

Object.keys(_spacing).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _spacing[key];
    }
  });
});

var _style = _interopRequireDefault(require("./style"));

var _typography = _interopRequireWildcard(require("./typography"));

Object.keys(_typography).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _typography[key];
    }
  });
});
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/system",file:"node_modules\\@material-ui\\system\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\memoize.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Csystem%5Cmemoize.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = memoize;

function memoize(fn) {
  var cache = {};
  return function (arg) {
    if (cache[arg] === undefined) {
      cache[arg] = fn(arg);
    }

    return cache[arg];
  };
}
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/system",file:"node_modules\\@material-ui\\system\\memoize.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\merge.js", {"@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Csystem%5Cmerge.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _utils = require("@material-ui/utils");

function merge(acc, item) {
  if (!item) {
    return acc;
  }

  return (0, _utils.deepmerge)(acc, item, {
    clone: false // No need to clone deep, it's way faster.

  });
}

var _default = merge;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/system",file:"node_modules\\@material-ui\\system\\merge.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\palette.js", {"./compose":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\compose.js","./style":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\style.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Csystem%5Cpalette.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.bgcolor = exports.color = void 0;

var _style = _interopRequireDefault(require("./style"));

var _compose = _interopRequireDefault(require("./compose"));

var color = (0, _style.default)({
  prop: 'color',
  themeKey: 'palette'
});
exports.color = color;
var bgcolor = (0, _style.default)({
  prop: 'bgcolor',
  cssProperty: 'backgroundColor',
  themeKey: 'palette'
});
exports.bgcolor = bgcolor;
var palette = (0, _compose.default)(color, bgcolor);
var _default = palette;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/system",file:"node_modules\\@material-ui\\system\\palette.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\positions.js", {"./compose":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\compose.js","./style":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\style.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Csystem%5Cpositions.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.left = exports.bottom = exports.right = exports.top = exports.zIndex = exports.position = void 0;

var _style = _interopRequireDefault(require("./style"));

var _compose = _interopRequireDefault(require("./compose"));

var position = (0, _style.default)({
  prop: 'position'
});
exports.position = position;
var zIndex = (0, _style.default)({
  prop: 'zIndex',
  themeKey: 'zIndex'
});
exports.zIndex = zIndex;
var top = (0, _style.default)({
  prop: 'top'
});
exports.top = top;
var right = (0, _style.default)({
  prop: 'right'
});
exports.right = right;
var bottom = (0, _style.default)({
  prop: 'bottom'
});
exports.bottom = bottom;
var left = (0, _style.default)({
  prop: 'left'
});
exports.left = left;

var _default = (0, _compose.default)(position, zIndex, top, right, bottom, left);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/system",file:"node_modules\\@material-ui\\system\\positions.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\responsivePropType.js", {"@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Csystem%5CresponsivePropType.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var responsivePropType = "development" !== 'production' ? _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string, _propTypes.default.object, _propTypes.default.array]) : {};
var _default = responsivePropType;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/system",file:"node_modules\\@material-ui\\system\\responsivePropType.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\shadows.js", {"./style":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\style.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Csystem%5Cshadows.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _style = _interopRequireDefault(require("./style"));

var boxShadow = (0, _style.default)({
  prop: 'boxShadow',
  themeKey: 'shadows'
});
var _default = boxShadow;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/system",file:"node_modules\\@material-ui\\system\\shadows.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\sizing.js", {"./compose":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\compose.js","./style":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\style.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Csystem%5Csizing.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.boxSizing = exports.sizeHeight = exports.sizeWidth = exports.minHeight = exports.maxHeight = exports.height = exports.minWidth = exports.maxWidth = exports.width = void 0;

var _style = _interopRequireDefault(require("./style"));

var _compose = _interopRequireDefault(require("./compose"));

function transform(value) {
  return value <= 1 ? "".concat(value * 100, "%") : value;
}

var width = (0, _style.default)({
  prop: 'width',
  transform: transform
});
exports.width = width;
var maxWidth = (0, _style.default)({
  prop: 'maxWidth',
  transform: transform
});
exports.maxWidth = maxWidth;
var minWidth = (0, _style.default)({
  prop: 'minWidth',
  transform: transform
});
exports.minWidth = minWidth;
var height = (0, _style.default)({
  prop: 'height',
  transform: transform
});
exports.height = height;
var maxHeight = (0, _style.default)({
  prop: 'maxHeight',
  transform: transform
});
exports.maxHeight = maxHeight;
var minHeight = (0, _style.default)({
  prop: 'minHeight',
  transform: transform
});
exports.minHeight = minHeight;
var sizeWidth = (0, _style.default)({
  prop: 'size',
  cssProperty: 'width',
  transform: transform
});
exports.sizeWidth = sizeWidth;
var sizeHeight = (0, _style.default)({
  prop: 'size',
  cssProperty: 'height',
  transform: transform
});
exports.sizeHeight = sizeHeight;
var boxSizing = (0, _style.default)({
  prop: 'boxSizing'
});
exports.boxSizing = boxSizing;
var sizing = (0, _compose.default)(width, maxWidth, minWidth, height, maxHeight, minHeight, boxSizing);
var _default = sizing;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/system",file:"node_modules\\@material-ui\\system\\sizing.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\spacing.js", {"./breakpoints":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\breakpoints.js","./memoize":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\memoize.js","./merge":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\merge.js","./responsivePropType":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\responsivePropType.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/slicedToArray":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\slicedToArray.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Csystem%5Cspacing.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUnarySpacing = createUnarySpacing;
exports.default = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _responsivePropType = _interopRequireDefault(require("./responsivePropType"));

var _breakpoints = require("./breakpoints");

var _merge = _interopRequireDefault(require("./merge"));

var _memoize = _interopRequireDefault(require("./memoize"));

var properties = {
  m: 'margin',
  p: 'padding'
};
var directions = {
  t: 'Top',
  r: 'Right',
  b: 'Bottom',
  l: 'Left',
  x: ['Left', 'Right'],
  y: ['Top', 'Bottom']
};
var aliases = {
  marginX: 'mx',
  marginY: 'my',
  paddingX: 'px',
  paddingY: 'py'
}; // memoize() impact:
// From 300,000 ops/sec
// To 350,000 ops/sec

var getCssProperties = (0, _memoize.default)(function (prop) {
  // It's not a shorthand notation.
  if (prop.length > 2) {
    if (aliases[prop]) {
      prop = aliases[prop];
    } else {
      return [prop];
    }
  }

  var _prop$split = prop.split(''),
      _prop$split2 = (0, _slicedToArray2.default)(_prop$split, 2),
      a = _prop$split2[0],
      b = _prop$split2[1];

  var property = properties[a];
  var direction = directions[b] || '';
  return Array.isArray(direction) ? direction.map(function (dir) {
    return property + dir;
  }) : [property + direction];
});
var spacingKeys = ['m', 'mt', 'mr', 'mb', 'ml', 'mx', 'my', 'p', 'pt', 'pr', 'pb', 'pl', 'px', 'py', 'margin', 'marginTop', 'marginRight', 'marginBottom', 'marginLeft', 'marginX', 'marginY', 'padding', 'paddingTop', 'paddingRight', 'paddingBottom', 'paddingLeft', 'paddingX', 'paddingY'];

function createUnarySpacing(theme) {
  var themeSpacing = theme.spacing || 8;

  if (typeof themeSpacing === 'number') {
    return function (abs) {
      if ("development" !== 'production') {
        if (typeof abs !== 'number') {
          console.error("Material-UI: Expected spacing argument to be a number, got ".concat(abs, "."));
        }
      }

      return themeSpacing * abs;
    };
  }

  if (Array.isArray(themeSpacing)) {
    return function (abs) {
      if ("development" !== 'production') {
        if (abs > themeSpacing.length - 1) {
          console.error(["Material-UI: The value provided (".concat(abs, ") overflows."), "The supported values are: ".concat(JSON.stringify(themeSpacing), "."), "".concat(abs, " > ").concat(themeSpacing.length - 1, ", you need to add the missing values.")].join('\n'));
        }
      }

      return themeSpacing[abs];
    };
  }

  if (typeof themeSpacing === 'function') {
    return themeSpacing;
  }

  if ("development" !== 'production') {
    console.error(["Material-UI: The `theme.spacing` value (".concat(themeSpacing, ") is invalid."), 'It should be a number, an array or a function.'].join('\n'));
  }

  return function () {
    return undefined;
  };
}

function getValue(transformer, propValue) {
  if (typeof propValue === 'string' || propValue == null) {
    return propValue;
  }

  var abs = Math.abs(propValue);
  var transformed = transformer(abs);

  if (propValue >= 0) {
    return transformed;
  }

  if (typeof transformed === 'number') {
    return -transformed;
  }

  return "-".concat(transformed);
}

function getStyleFromPropValue(cssProperties, transformer) {
  return function (propValue) {
    return cssProperties.reduce(function (acc, cssProperty) {
      acc[cssProperty] = getValue(transformer, propValue);
      return acc;
    }, {});
  };
}

function spacing(props) {
  var theme = props.theme;
  var transformer = createUnarySpacing(theme);
  return Object.keys(props).map(function (prop) {
    // Using a hash computation over an array iteration could be faster, but with only 28 items,
    // it's doesn't worth the bundle size.
    if (spacingKeys.indexOf(prop) === -1) {
      return null;
    }

    var cssProperties = getCssProperties(prop);
    var styleFromPropValue = getStyleFromPropValue(cssProperties, transformer);
    var propValue = props[prop];
    return (0, _breakpoints.handleBreakpoints)(props, propValue, styleFromPropValue);
  }).reduce(_merge.default, {});
}

spacing.propTypes = "development" !== 'production' ? spacingKeys.reduce(function (obj, key) {
  obj[key] = _responsivePropType.default;
  return obj;
}, {}) : {};
spacing.filterProps = spacingKeys;
var _default = spacing;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/system",file:"node_modules\\@material-ui\\system\\spacing.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\style.js", {"./breakpoints":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\breakpoints.js","./responsivePropType":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\responsivePropType.js","@babel/runtime/helpers/defineProperty":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\defineProperty.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Csystem%5Cstyle.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _responsivePropType = _interopRequireDefault(require("./responsivePropType"));

var _breakpoints = require("./breakpoints");

function getPath(obj, path) {
  if (!path || typeof path !== 'string') {
    return null;
  }

  return path.split('.').reduce(function (acc, item) {
    return acc && acc[item] ? acc[item] : null;
  }, obj);
}

function style(options) {
  var prop = options.prop,
      _options$cssProperty = options.cssProperty,
      cssProperty = _options$cssProperty === void 0 ? options.prop : _options$cssProperty,
      themeKey = options.themeKey,
      transform = options.transform;

  var fn = function fn(props) {
    if (props[prop] == null) {
      return null;
    }

    var propValue = props[prop];
    var theme = props.theme;
    var themeMapping = getPath(theme, themeKey) || {};

    var styleFromPropValue = function styleFromPropValue(propValueFinal) {
      var value;

      if (typeof themeMapping === 'function') {
        value = themeMapping(propValueFinal);
      } else if (Array.isArray(themeMapping)) {
        value = themeMapping[propValueFinal] || propValueFinal;
      } else {
        value = getPath(themeMapping, propValueFinal) || propValueFinal;

        if (transform) {
          value = transform(value);
        }
      }

      if (cssProperty === false) {
        return value;
      }

      return (0, _defineProperty2.default)({}, cssProperty, value);
    };

    return (0, _breakpoints.handleBreakpoints)(props, propValue, styleFromPropValue);
  };

  fn.propTypes = "development" !== 'production' ? (0, _defineProperty2.default)({}, prop, _responsivePropType.default) : {};
  fn.filterProps = [prop];
  return fn;
}

var _default = style;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/system",file:"node_modules\\@material-ui\\system\\style.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\styleFunctionSx.js", {"./merge":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\merge.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/toConsumableArray":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\toConsumableArray.js","@material-ui/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Csystem%5CstyleFunctionSx.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.css = css;
exports.default = void 0;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _utils = require("@material-ui/utils");

var _merge = _interopRequireDefault(require("./merge"));

function omit(input, fields) {
  var output = {};
  Object.keys(input).forEach(function (prop) {
    if (fields.indexOf(prop) === -1) {
      output[prop] = input[prop];
    }
  });
  return output;
}

var warnedOnce = false;

function styleFunctionSx(styleFunction) {
  var newStyleFunction = function newStyleFunction(props) {
    var output = styleFunction(props);

    if (props.css) {
      return (0, _extends2.default)({}, (0, _merge.default)(output, styleFunction((0, _extends2.default)({
        theme: props.theme
      }, props.css))), omit(props.css, [styleFunction.filterProps]));
    }

    if (props.sx) {
      return (0, _extends2.default)({}, (0, _merge.default)(output, styleFunction((0, _extends2.default)({
        theme: props.theme
      }, props.sx))), omit(props.sx, [styleFunction.filterProps]));
    }

    return output;
  };

  newStyleFunction.propTypes = "development" !== 'production' ? (0, _extends2.default)({}, styleFunction.propTypes, {
    css: (0, _utils.chainPropTypes)(_propTypes.default.object, function (props) {
      if (!warnedOnce && props.css !== undefined) {
        warnedOnce = true;
        return new Error('Material-UI: The `css` prop is deprecated, please use the `sx` prop instead.');
      }

      return null;
    }),
    sx: _propTypes.default.object
  }) : {};
  newStyleFunction.filterProps = ['css', 'sx'].concat((0, _toConsumableArray2.default)(styleFunction.filterProps));
  return newStyleFunction;
}
/**
 *
 * @deprecated
 * The css style function is deprecated. Use the `styleFunctionSx` instead.
 */


function css(styleFunction) {
  if ("development" !== 'production') {
    console.warn('Material-UI: The `css` function is deprecated. Use the `styleFunctionSx` instead.');
  }

  return styleFunctionSx(styleFunction);
}

var _default = styleFunctionSx;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/system",file:"node_modules\\@material-ui\\system\\styleFunctionSx.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\typography.js", {"./compose":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\compose.js","./style":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\system\\style.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Csystem%5Ctypography.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.textAlign = exports.lineHeight = exports.letterSpacing = exports.fontWeight = exports.fontStyle = exports.fontSize = exports.fontFamily = void 0;

var _style = _interopRequireDefault(require("./style"));

var _compose = _interopRequireDefault(require("./compose"));

var fontFamily = (0, _style.default)({
  prop: 'fontFamily',
  themeKey: 'typography'
});
exports.fontFamily = fontFamily;
var fontSize = (0, _style.default)({
  prop: 'fontSize',
  themeKey: 'typography'
});
exports.fontSize = fontSize;
var fontStyle = (0, _style.default)({
  prop: 'fontStyle',
  themeKey: 'typography'
});
exports.fontStyle = fontStyle;
var fontWeight = (0, _style.default)({
  prop: 'fontWeight',
  themeKey: 'typography'
});
exports.fontWeight = fontWeight;
var letterSpacing = (0, _style.default)({
  prop: 'letterSpacing'
});
exports.letterSpacing = letterSpacing;
var lineHeight = (0, _style.default)({
  prop: 'lineHeight'
});
exports.lineHeight = lineHeight;
var textAlign = (0, _style.default)({
  prop: 'textAlign'
});
exports.textAlign = textAlign;
var typography = (0, _compose.default)(fontFamily, fontSize, fontStyle, fontWeight, letterSpacing, lineHeight, textAlign);
var _default = typography;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/system",file:"node_modules\\@material-ui\\system\\typography.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\HTMLElementType.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cutils%5CHTMLElementType.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = HTMLElementType;

function HTMLElementType(props, propName, componentName, location, propFullName) {
  if ("development" === 'production') {
    return null;
  }

  var propValue = props[propName];
  var safePropName = propFullName || propName;

  if (propValue == null) {
    return null;
  }

  if (propValue && propValue.nodeType !== 1) {
    return new Error("Invalid ".concat(location, " `").concat(safePropName, "` supplied to `").concat(componentName, "`. ") + "Expected an HTMLElement.");
  }

  return null;
}
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/utils",file:"node_modules\\@material-ui\\utils\\HTMLElementType.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\chainPropTypes.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cutils%5CchainPropTypes.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = chainPropTypes;

function chainPropTypes(propType1, propType2) {
  if ("development" === 'production') {
    return function () {
      return null;
    };
  }

  return function validate() {
    return propType1.apply(void 0, arguments) || propType2.apply(void 0, arguments);
  };
}
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/utils",file:"node_modules\\@material-ui\\utils\\chainPropTypes.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\deepmerge.js", {"@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/typeof":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\typeof.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cutils%5Cdeepmerge.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isPlainObject = isPlainObject;
exports.default = deepmerge;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

function isPlainObject(item) {
  return item && (0, _typeof2.default)(item) === 'object' && item.constructor === Object;
}

function deepmerge(target, source) {
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {
    clone: true
  };
  var output = options.clone ? (0, _extends2.default)({}, target) : target;

  if (isPlainObject(target) && isPlainObject(source)) {
    Object.keys(source).forEach(function (key) {
      // Avoid prototype pollution
      if (key === '__proto__') {
        return;
      }

      if (isPlainObject(source[key]) && key in target) {
        output[key] = deepmerge(target[key], source[key], options);
      } else {
        output[key] = source[key];
      }
    });
  }

  return output;
}
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/utils",file:"node_modules\\@material-ui\\utils\\deepmerge.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\elementAcceptingRef.js", {"./chainPropTypes":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\chainPropTypes.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cutils%5CelementAcceptingRef.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _chainPropTypes = _interopRequireDefault(require("./chainPropTypes"));

function isClassComponent(elementType) {
  // elementType.prototype?.isReactComponent
  var _elementType$prototyp = elementType.prototype,
      prototype = _elementType$prototyp === void 0 ? {} : _elementType$prototyp;
  return Boolean(prototype.isReactComponent);
}

function acceptingRef(props, propName, componentName, location, propFullName) {
  var element = props[propName];
  var safePropName = propFullName || propName;

  if (element == null) {
    return null;
  }

  var warningHint;
  var elementType = element.type;
  /**
   * Blacklisting instead of whitelisting
   *
   * Blacklisting will miss some components, such as React.Fragment. Those will at least
   * trigger a warning in React.
   * We can't whitelist because there is no safe way to detect React.forwardRef
   * or class components. "Safe" means there's no public API.
   *
   */

  if (typeof elementType === 'function' && !isClassComponent(elementType)) {
    warningHint = 'Did you accidentally use a plain function component for an element instead?';
  }

  if (warningHint !== undefined) {
    return new Error("Invalid ".concat(location, " `").concat(safePropName, "` supplied to `").concat(componentName, "`. ") + "Expected an element that can hold a ref. ".concat(warningHint, " ") + 'For more information see https://mui.com/r/caveat-with-refs-guide');
  }

  return null;
}

var elementAcceptingRef = (0, _chainPropTypes.default)(_propTypes.default.element, acceptingRef);
elementAcceptingRef.isRequired = (0, _chainPropTypes.default)(_propTypes.default.element.isRequired, acceptingRef);
var _default = elementAcceptingRef;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/utils",file:"node_modules\\@material-ui\\utils\\elementAcceptingRef.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\elementTypeAcceptingRef.js", {"./chainPropTypes":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\chainPropTypes.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/interopRequireWildcard":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireWildcard.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cutils%5CelementTypeAcceptingRef.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var PropTypes = _interopRequireWildcard(require("prop-types"));

var _chainPropTypes = _interopRequireDefault(require("./chainPropTypes"));

function isClassComponent(elementType) {
  // elementType.prototype?.isReactComponent
  var _elementType$prototyp = elementType.prototype,
      prototype = _elementType$prototyp === void 0 ? {} : _elementType$prototyp;
  return Boolean(prototype.isReactComponent);
}

function elementTypeAcceptingRef(props, propName, componentName, location, propFullName) {
  var propValue = props[propName];
  var safePropName = propFullName || propName;

  if (propValue == null) {
    return null;
  }

  var warningHint;
  /**
   * Blacklisting instead of whitelisting
   *
   * Blacklisting will miss some components, such as React.Fragment. Those will at least
   * trigger a warning in React.
   * We can't whitelist because there is no safe way to detect React.forwardRef
   * or class components. "Safe" means there's no public API.
   *
   */

  if (typeof propValue === 'function' && !isClassComponent(propValue)) {
    warningHint = 'Did you accidentally provide a plain function component instead?';
  }

  if (warningHint !== undefined) {
    return new Error("Invalid ".concat(location, " `").concat(safePropName, "` supplied to `").concat(componentName, "`. ") + "Expected an element type that can hold a ref. ".concat(warningHint, " ") + 'For more information see https://mui.com/r/caveat-with-refs-guide');
  }

  return null;
}

var _default = (0, _chainPropTypes.default)(PropTypes.elementType, elementTypeAcceptingRef);

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/utils",file:"node_modules\\@material-ui\\utils\\elementTypeAcceptingRef.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\exactProp.js", {"@babel/runtime/helpers/defineProperty":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\defineProperty.js","@babel/runtime/helpers/extends":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\extends.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cutils%5CexactProp.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exactProp;
exports.specialProperty = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _extends3 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

// This module is based on https://github.com/airbnb/prop-types-exact repository.
// However, in order to reduce the number of dependencies and to remove some extra safe checks
// the module was forked.
// Only exported for test purposes.
var specialProperty = "exact-prop: \u200B";
exports.specialProperty = specialProperty;

function exactProp(propTypes) {
  if ("development" === 'production') {
    return propTypes;
  }

  return (0, _extends3.default)({}, propTypes, (0, _defineProperty2.default)({}, specialProperty, function (props) {
    var unsupportedProps = Object.keys(props).filter(function (prop) {
      return !propTypes.hasOwnProperty(prop);
    });

    if (unsupportedProps.length > 0) {
      return new Error("The following props are not supported: ".concat(unsupportedProps.map(function (prop) {
        return "`".concat(prop, "`");
      }).join(', '), ". Please remove them."));
    }

    return null;
  }));
}
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/utils",file:"node_modules\\@material-ui\\utils\\exactProp.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\formatMuiErrorMessage.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cutils%5CformatMuiErrorMessage.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = formatMuiErrorMessage;

/**
 * WARNING: Don't import this directly.
 * Use `MuiError` from `@material-ui/utils/macros/MuiError.macro` instead.
 * @param {number} code
 */
function formatMuiErrorMessage(code) {
  // Apply babel-plugin-transform-template-literals in loose mode
  // loose mode is safe iff we're concatenating primitives
  // see https://babeljs.io/docs/en/babel-plugin-transform-template-literals#loose

  /* eslint-disable prefer-template */
  var url = 'https://mui.com/production-error/?code=' + code;

  for (var i = 1; i < arguments.length; i += 1) {
    // rest params over-transpile for this case
    // eslint-disable-next-line prefer-rest-params
    url += '&args[]=' + encodeURIComponent(arguments[i]);
  }

  return 'Minified Material-UI error #' + code + '; visit ' + url + ' for the full message.';
  /* eslint-enable prefer-template */
}
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/utils",file:"node_modules\\@material-ui\\utils\\formatMuiErrorMessage.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\getDisplayName.js", {"@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/typeof":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\typeof.js","react-is":"D:\\code\\v\\metamask-extension\\node_modules\\react-is\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cutils%5CgetDisplayName.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFunctionName = getFunctionName;
exports.default = getDisplayName;

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _reactIs = require("react-is");

// Simplified polyfill for IE 11 support
// https://github.com/JamesMGreene/Function.name/blob/58b314d4a983110c3682f1228f845d39ccca1817/Function.name.js#L3
var fnNameMatchRegex = /^\s*function(?:\s|\s*\/\*.*\*\/\s*)+([^(\s/]*)\s*/;

function getFunctionName(fn) {
  var match = "".concat(fn).match(fnNameMatchRegex);
  var name = match && match[1];
  return name || '';
}
/**
 * @param {function} Component
 * @param {string} fallback
 * @returns {string | undefined}
 */


function getFunctionComponentName(Component) {
  var fallback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  return Component.displayName || Component.name || getFunctionName(Component) || fallback;
}

function getWrappedName(outerType, innerType, wrapperName) {
  var functionName = getFunctionComponentName(innerType);
  return outerType.displayName || (functionName !== '' ? "".concat(wrapperName, "(").concat(functionName, ")") : wrapperName);
}
/**
 * cherry-pick from
 * https://github.com/facebook/react/blob/769b1f270e1251d9dbdce0fcbd9e92e502d059b8/packages/shared/getComponentName.js
 * originally forked from recompose/getDisplayName with added IE 11 support
 *
 * @param {React.ReactType} Component
 * @returns {string | undefined}
 */


function getDisplayName(Component) {
  if (Component == null) {
    return undefined;
  }

  if (typeof Component === 'string') {
    return Component;
  }

  if (typeof Component === 'function') {
    return getFunctionComponentName(Component, 'Component');
  }

  if ((0, _typeof2.default)(Component) === 'object') {
    switch (Component.$$typeof) {
      case _reactIs.ForwardRef:
        return getWrappedName(Component, Component.render, 'ForwardRef');

      case _reactIs.Memo:
        return getWrappedName(Component, Component.type, 'memo');

      default:
        return undefined;
    }
  }

  return undefined;
}
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/utils",file:"node_modules\\@material-ui\\utils\\getDisplayName.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\index.js", {"./HTMLElementType":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\HTMLElementType.js","./chainPropTypes":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\chainPropTypes.js","./deepmerge":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\deepmerge.js","./elementAcceptingRef":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\elementAcceptingRef.js","./elementTypeAcceptingRef":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\elementTypeAcceptingRef.js","./exactProp":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\exactProp.js","./formatMuiErrorMessage":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\formatMuiErrorMessage.js","./getDisplayName":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\getDisplayName.js","./ponyfillGlobal":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\ponyfillGlobal.js","./refType":"D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\refType.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cutils%5Cindex.js
      return function (require, module, exports) {
/** @license Material-UI v4.11.3
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "chainPropTypes", {
  enumerable: true,
  get: function get() {
    return _chainPropTypes.default;
  }
});
Object.defineProperty(exports, "deepmerge", {
  enumerable: true,
  get: function get() {
    return _deepmerge.default;
  }
});
Object.defineProperty(exports, "elementAcceptingRef", {
  enumerable: true,
  get: function get() {
    return _elementAcceptingRef.default;
  }
});
Object.defineProperty(exports, "elementTypeAcceptingRef", {
  enumerable: true,
  get: function get() {
    return _elementTypeAcceptingRef.default;
  }
});
Object.defineProperty(exports, "exactProp", {
  enumerable: true,
  get: function get() {
    return _exactProp.default;
  }
});
Object.defineProperty(exports, "formatMuiErrorMessage", {
  enumerable: true,
  get: function get() {
    return _formatMuiErrorMessage.default;
  }
});
Object.defineProperty(exports, "getDisplayName", {
  enumerable: true,
  get: function get() {
    return _getDisplayName.default;
  }
});
Object.defineProperty(exports, "HTMLElementType", {
  enumerable: true,
  get: function get() {
    return _HTMLElementType.default;
  }
});
Object.defineProperty(exports, "ponyfillGlobal", {
  enumerable: true,
  get: function get() {
    return _ponyfillGlobal.default;
  }
});
Object.defineProperty(exports, "refType", {
  enumerable: true,
  get: function get() {
    return _refType.default;
  }
});

var _chainPropTypes = _interopRequireDefault(require("./chainPropTypes"));

var _deepmerge = _interopRequireDefault(require("./deepmerge"));

var _elementAcceptingRef = _interopRequireDefault(require("./elementAcceptingRef"));

var _elementTypeAcceptingRef = _interopRequireDefault(require("./elementTypeAcceptingRef"));

var _exactProp = _interopRequireDefault(require("./exactProp"));

var _formatMuiErrorMessage = _interopRequireDefault(require("./formatMuiErrorMessage"));

var _getDisplayName = _interopRequireDefault(require("./getDisplayName"));

var _HTMLElementType = _interopRequireDefault(require("./HTMLElementType"));

var _ponyfillGlobal = _interopRequireDefault(require("./ponyfillGlobal"));

var _refType = _interopRequireDefault(require("./refType"));
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/utils",file:"node_modules\\@material-ui\\utils\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\ponyfillGlobal.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cutils%5CponyfillGlobal.js
      return function (require, module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

/* eslint-disable */
// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
var _default = typeof window != 'undefined' && window.Math == Math ? window : typeof self != 'undefined' && self.Math == Math ? self : Function('return this')();

exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/utils",file:"node_modules\\@material-ui\\utils\\ponyfillGlobal.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@material-ui\\utils\\refType.js", {"@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","prop-types":"D:\\code\\v\\metamask-extension\\node_modules\\prop-types\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@material-ui%5Cutils%5CrefType.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var refType = _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]);

var _default = refType;
exports.default = _default;
      };
    };
  }
  }
}, {package:"@material-ui/core>@material-ui/utils",file:"node_modules\\@material-ui\\utils\\refType.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\index.cjs", {"./js/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cdesign-tokens%5Cdist%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fontFamilies = exports.typography = exports.darkTheme = exports.lightTheme = exports.brandColor = exports.colors = void 0;
var js_1 = require("./js/index.cjs");
Object.defineProperty(exports, "colors", { enumerable: true, get: function () { return js_1.colors; } });
Object.defineProperty(exports, "brandColor", { enumerable: true, get: function () { return js_1.brandColor; } });
Object.defineProperty(exports, "lightTheme", { enumerable: true, get: function () { return js_1.lightTheme; } });
Object.defineProperty(exports, "darkTheme", { enumerable: true, get: function () { return js_1.darkTheme; } });
Object.defineProperty(exports, "typography", { enumerable: true, get: function () { return js_1.typography; } });
Object.defineProperty(exports, "fontFamilies", { enumerable: true, get: function () { return js_1.fontFamilies; } });

      };
    };
  }
  }
}, {package:"@metamask/design-tokens",file:"node_modules\\@metamask\\design-tokens\\dist\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\brandColor\\brandColor.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cdesign-tokens%5Cdist%5Cjs%5CbrandColor%5CbrandColor.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.brandColor = void 0;
exports.brandColor = {
    // Grey
    grey100: '#dadce5',
    // Grey
    grey200: '#b7bbc8',
    // Grey
    grey300: '#9ca1af',
    // Grey
    grey400: '#858b9a',
    // Grey
    grey500: '#686e7d',
    // Grey
    grey600: '#4b505c',
    // Grey
    grey700: '#2a2c32',
    // Grey
    grey800: '#232426',
    // Grey
    grey900: '#121314',
    // Grey
    grey1000: '#000000',
    // Grey
    grey050: '#f3f5f9',
    // Grey
    grey000: '#ffffff',
    // Grey
    grey025: '#f7f9fc',
    // Blue
    blue100: '#d6dbff',
    // Blue
    blue200: '#adb6fe',
    // Blue
    blue300: '#8b99ff',
    // Blue
    blue400: '#6f7eff',
    // Blue
    blue500: '#4459ff',
    // Blue
    blue600: '#2c3dc5',
    // Blue
    blue700: '#1c277f',
    // Blue
    blue800: '#131b59',
    // Blue
    blue900: '#0b0f32',
    // Blue
    blue050: '#f4f5ff',
    // Blue
    blue025: '#f8f9ff',
    // Green
    green100: '#c1e6c9',
    // Green
    green200: '#80cb91',
    // Green
    green300: '#4cb564',
    // Green
    green400: '#279f41',
    // Green
    green500: '#1c7e33',
    // Green
    green600: '#145d25',
    // Green
    green700: '#0d3b18',
    // Green
    green800: '#092912',
    // Green
    green900: '#051709',
    // Green
    green050: '#ebf7ee',
    // Green
    green025: '#f1faf4',
    // Red
    red100: '#ffd2d5',
    // Red
    red200: '#ffa1aa',
    // Red
    red300: '#ff7584',
    // Red
    red400: '#f74d5e',
    // Red
    red500: '#ca3542',
    // Red
    red600: '#952731',
    // Red
    red700: '#611a20',
    // Red
    red800: '#431216',
    // Red
    red900: '#3b0f13',
    // Red
    red050: '#fff2f3',
    // Red
    red025: '#fff6f7',
    // Yellow
    yellow100: '#ffd957',
    // Yellow
    yellow200: '#f0b034',
    // Yellow
    yellow300: '#e18f01',
    // Yellow
    yellow400: '#c37b02',
    // Yellow
    yellow500: '#9a6300',
    // Yellow
    yellow600: '#714802',
    // Yellow
    yellow700: '#482d01',
    // Yellow
    yellow800: '#321f00',
    // Yellow
    yellow900: '#1c1100',
    // Yellow
    yellow050: '#fff5d5',
    // Yellow
    yellow025: '#fff9e6',
    // Orange
    orange100: '#ffd4c1',
    // Orange
    orange200: '#ffa680',
    // Orange
    orange300: '#ff7940',
    // Orange
    orange400: '#ff5c16',
    // Orange
    orange500: '#c3420d',
    // Orange
    orange600: '#932d06',
    // Orange
    orange700: '#661800',
    // Orange
    orange800: '#451100',
    // Orange
    orange900: '#280a00',
    // Orange
    orange050: '#fff0ea',
    // Orange
    orange025: '#fff8f5',
    // Purple
    purple100: '#eac2ff',
    // Purple
    purple200: '#dfa4ff',
    // Purple
    purple300: '#d075ff',
    // Purple
    purple400: '#b864f5',
    // Purple
    purple500: '#8f44e4',
    // Purple
    purple600: '#6c2ab2',
    // Purple
    purple700: '#6c2ab2',
    // Purple
    purple800: '#3d065f',
    // Purple
    purple900: '#280a00',
    // Purple
    purple050: '#fbf2ff',
    // Purple
    purple025: '#fcf6ff',
    // Lime
    lime100: '#baf24a',
    // Lime
    lime200: '#95ca45',
    // Lime
    lime300: '#7ab040',
    // Lime
    lime400: '#64993d',
    // Lime
    lime500: '#457a39',
    // Lime
    lime600: '#275b35',
    // Lime
    lime700: '#013330',
    // Lime
    lime800: '#012826',
    // Lime
    lime900: '#011515',
    // Lime
    lime025: '#effed9',
    // Lime
    lime050: '#e5ffc3',
    // Indigo
    indigo025: '#f3faff',
    // Indigo
    indigo050: '#ebf5ff',
    // Indigo
    indigo100: '#cce7ff',
    // Indigo
    indigo200: '#89b0ff',
    // Indigo
    indigo300: '#7e9ff0',
    // Indigo
    indigo400: '#6f87db',
    // Indigo
    indigo500: '#5b66bf',
    // Indigo
    indigo600: '#4544a1',
    // Indigo
    indigo700: '#2e2082',
    // Indigo
    indigo800: '#190066',
    // Indigo
    indigo900: '#13004a',
    // White
    white: '#ffffff',
    // Black
    black: '#000000',
};

      };
    };
  }
  }
}, {package:"@metamask/design-tokens",file:"node_modules\\@metamask\\design-tokens\\dist\\js\\brandColor\\brandColor.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\brandColor\\index.cjs", {"./brandColor.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\brandColor\\brandColor.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cdesign-tokens%5Cdist%5Cjs%5CbrandColor%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.brandColor = void 0;
var brandColor_1 = require("./brandColor.cjs");
Object.defineProperty(exports, "brandColor", { enumerable: true, get: function () { return brandColor_1.brandColor; } });

      };
    };
  }
  }
}, {package:"@metamask/design-tokens",file:"node_modules\\@metamask\\design-tokens\\dist\\js\\brandColor\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\colors\\colors.cjs", {"../themes/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cdesign-tokens%5Cdist%5Cjs%5Ccolors%5Ccolors.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.colors = void 0;
const themes_1 = require("../themes/index.cjs");
/**
 * This object is DEPRECATED in favour of the theme objects
 * jest ignores this file when testing coverage
 */
exports.colors = {
    light: {
        ...themes_1.lightTheme.colors,
    },
    dark: {
        ...themes_1.darkTheme.colors,
    },
};

      };
    };
  }
  }
}, {package:"@metamask/design-tokens",file:"node_modules\\@metamask\\design-tokens\\dist\\js\\colors\\colors.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\colors\\index.cjs", {"./colors.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\colors\\colors.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cdesign-tokens%5Cdist%5Cjs%5Ccolors%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.colors = exports.default = void 0;
var colors_1 = require("./colors.cjs");
Object.defineProperty(exports, "default", { enumerable: true, get: function () { return colors_1.colors; } });
var colors_2 = require("./colors.cjs");
Object.defineProperty(exports, "colors", { enumerable: true, get: function () { return colors_2.colors; } });

      };
    };
  }
  }
}, {package:"@metamask/design-tokens",file:"node_modules\\@metamask\\design-tokens\\dist\\js\\colors\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\index.cjs", {"./brandColor/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\brandColor\\index.cjs","./colors/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\colors\\index.cjs","./themes/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\index.cjs","./typography/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cdesign-tokens%5Cdist%5Cjs%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fontFamilies = exports.typography = exports.darkTheme = exports.lightTheme = exports.brandColor = exports.colors = void 0;
// DEPRECATED in favor of importing lightTheme and darkTheme
var colors_1 = require("./colors/index.cjs");
Object.defineProperty(exports, "colors", { enumerable: true, get: function () { return colors_1.colors; } });
// Brand Color
var brandColor_1 = require("./brandColor/index.cjs");
Object.defineProperty(exports, "brandColor", { enumerable: true, get: function () { return brandColor_1.brandColor; } });
// Themes
var themes_1 = require("./themes/index.cjs");
Object.defineProperty(exports, "lightTheme", { enumerable: true, get: function () { return themes_1.lightTheme; } });
Object.defineProperty(exports, "darkTheme", { enumerable: true, get: function () { return themes_1.darkTheme; } });
// Typography
var typography_1 = require("./typography/index.cjs");
Object.defineProperty(exports, "typography", { enumerable: true, get: function () { return typography_1.typography; } });
Object.defineProperty(exports, "fontFamilies", { enumerable: true, get: function () { return typography_1.fontFamilies; } });

      };
    };
  }
  }
}, {package:"@metamask/design-tokens",file:"node_modules\\@metamask\\design-tokens\\dist\\js\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\darkTheme\\colors.cjs", {"../../brandColor/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\brandColor\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cdesign-tokens%5Cdist%5Cjs%5Cthemes%5CdarkTheme%5Ccolors.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.colors = void 0;
const brandColor_1 = require("../../brandColor/index.cjs");
exports.colors = {
    background: {
        /** For default neutral surface (#222325) */
        default: brandColor_1.brandColor.grey900,
        /** For sunken neutral surface below background/default. (#121314) */
        alternative: brandColor_1.brandColor.grey1000,
        /** For section bg usually over background/default (#31333A) */
        section: brandColor_1.brandColor.grey800,
        /** For subsection bg usually over background/section (#222325) */
        subsection: brandColor_1.brandColor.grey700,
        /** For muted neutral surface (#e0e5ff14) */
        muted: '#e0e5ff14',
        /** Hover state surface for background/default (#1a1b1c) */
        defaultHover: '#1a1b1c',
        /** Pressed state surface for background/default (#222424) */
        defaultPressed: '#222424',
        /** Hover state surface for background/alternative (#0d0d0e) */
        alternativeHover: '#0d0d0e',
        /** Pressed state surface for background/alternative (#161617) */
        alternativePressed: '#161617',
        /** Hover state surface for background/muted (#e0e5ff26) */
        mutedHover: '#e0e5ff26',
        /** Pressed state surface for background/muted (#e0e5ff33) */
        mutedPressed: '#e0e5ff33',
        /** General purpose hover state tint (#dadce50a) */
        hover: '#dadce50a',
        /** General purpose pressed state tint (#dadce514) */
        pressed: '#dadce514',
    },
    text: {
        /** Default color for text (#FFFFFF) */
        default: brandColor_1.brandColor.grey000,
        /** Softer color for text (#858B9A) */
        alternative: brandColor_1.brandColor.grey300,
        /** Muted color for text (Not accessible) (#686E7D) */
        muted: brandColor_1.brandColor.grey600,
    },
    icon: {
        /** Default color for icons (#FFFFFF) */
        default: brandColor_1.brandColor.grey000,
        /** Hover state surface for icon.default (#F0F0F0) */
        defaultHover: '#f0f0f0',
        /** Pressed state surface for icon.default (#D0D0D0) */
        defaultPressed: '#d0d0d0',
        /** Softer color for icons (#858B9A) */
        alternative: brandColor_1.brandColor.grey300,
        /** Muted color for icons (Not accessible) (#686E7D) */
        muted: brandColor_1.brandColor.grey600,
        /** For elements placed on top of icon.default fill (#121314) */
        inverse: brandColor_1.brandColor.grey900,
    },
    border: {
        /** Default color for borders (#9CA1AF) */
        default: brandColor_1.brandColor.grey400,
        /** Muted color for borders (#858B9A33) */
        muted: '#858b9a33',
    },
    overlay: {
        /** Default color for overlays (scrim) (#00000099) */
        default: '#00000099',
        /** Dimmer color for overlays (scrim) (#000000CC) */
        alternative: '#000000cc',
        /** For elements placed on top of overlay/alternative (#FFFFFF) */
        inverse: brandColor_1.brandColor.grey000,
    },
    primary: {
        /** For primary semantic elements: interactive, active, selected (#8b99ff) */
        default: brandColor_1.brandColor.blue300,
        /** Stronger color for primary semantic elements (#adb6fe) */
        alternative: brandColor_1.brandColor.blue200,
        /** Muted color for primary semantic elements (#8b99ff26) */
        muted: '#8b99ff26',
        /** For elements placed on top of primary/default (#121314) */
        inverse: brandColor_1.brandColor.grey900,
        /** Hover state surface for primary/default (#9eaaff) */
        defaultHover: '#9eaaff',
        /** Pressed state surface for primary/default (#c7ceff) */
        defaultPressed: '#c7ceff',
        /** Hover state surface for primary/muted (#8b99ff33) */
        mutedHover: '#8b99ff33',
        /** Pressed state surface for primary/muted (#8b99ff40) */
        mutedPressed: '#8b99ff40',
    },
    error: {
        /** For danger semantic elements: error, critical, destructive (#FF7584) */
        default: brandColor_1.brandColor.red300,
        /** Stronger color for error semantic (#FFA1AA) */
        alternative: brandColor_1.brandColor.red200,
        /** Muted color for error semantic (#FF758426) */
        muted: '#ff758426',
        /** For elements placed on top of error/default fill (#121314) */
        inverse: brandColor_1.brandColor.grey900,
        /** Hover state surface for error/default (#ff8a96) */
        defaultHover: '#ff8a96',
        /** Pressed state surface for error/default (#FFB2BB) */
        defaultPressed: '#ffb2bb',
        /** Hover state surface for error/muted (#FF758433) */
        mutedHover: '#ff758433',
        /** Pressed state surface for error/muted (#FF758440) */
        mutedPressed: '#ff758440',
    },
    warning: {
        /** For warning semantic elements: caution, attention, precaution (#F0B034) */
        default: brandColor_1.brandColor.yellow200,
        /** Muted color option for warning semantic (#f0b03426) */
        muted: '#f0b03426',
        /** For elements placed on top of warning/default fill (#121314) */
        inverse: brandColor_1.brandColor.grey900,
        /** Hover state surface for warning/default (#f3be59) */
        defaultHover: '#f3be59',
        /** Pressed state surface for warning/default (#f6cd7f) */
        defaultPressed: '#f6cd7f',
        /** Hover state surface for warning/muted (#f0b03433) */
        mutedHover: '#f0b03433',
        /** Pressed state surface for warning/muted (#f0b03440) */
        mutedPressed: '#f0b03440',
    },
    success: {
        /** For positive semantic elements: success, confirm, complete, safe (#BAF24A) */
        default: brandColor_1.brandColor.lime100,
        /** Muted color for positive semantic (#baf24a26) */
        muted: '#baf24a26',
        /** For elements placed on top of success/default fill (#121314) */
        inverse: brandColor_1.brandColor.grey900,
        /** Hover state surface for success/default (#c9f570) */
        defaultHover: '#c9f570',
        /** Pressed state surface for success/default (#d7f796) */
        defaultPressed: '#d7f796',
        /** Hover state surface for success/muted (#baf24a33) */
        mutedHover: '#baf24a33',
        /** Pressed state surface for success/muted (#baf24a40) */
        mutedPressed: '#baf24a40',
    },
    info: {
        /** For informational read-only elements: info, reminder, hint (#8b99ff) */
        default: brandColor_1.brandColor.blue300,
        /** Muted color for informational semantic (#8b99ff26) */
        muted: '#8b99ff26',
        /** For elements placed on top of info/default (#121314) */
        inverse: brandColor_1.brandColor.grey900,
    },
    accent01: {
        /** Expressive color in light orange (#ffa680) */
        light: brandColor_1.brandColor.orange200,
        /** Expressive color in orange (#ff5c16) */
        normal: brandColor_1.brandColor.orange400,
        /** Expressive color in dark orange (#661800) */
        dark: brandColor_1.brandColor.orange700,
    },
    accent02: {
        /** Expressive color in light purple (#eac2ff) */
        light: brandColor_1.brandColor.purple100,
        /** Expressive color in purple (#d075ff) */
        normal: brandColor_1.brandColor.purple300,
        /** Expressive color in dark purple (#3d065f) */
        dark: brandColor_1.brandColor.purple800,
    },
    accent03: {
        /** Expressive color in light lime (#e5ffc3) */
        light: brandColor_1.brandColor.lime050,
        /** Expressive color in lime (#baf24a) */
        normal: brandColor_1.brandColor.lime100,
        /** Expressive color in dark lime (#013330) */
        dark: brandColor_1.brandColor.lime700,
    },
    accent04: {
        /** Expressive color in light indigo (#cce7ff) */
        light: brandColor_1.brandColor.indigo100,
        /** Expressive color in indigo (#89b0ff) */
        normal: brandColor_1.brandColor.indigo200,
        /** Expressive color in dark indigo (#190066) */
        dark: brandColor_1.brandColor.indigo800,
    },
    flask: {
        /** For Flask primary accent color (#D27DFF) */
        default: brandColor_1.brandColor.purple300,
        /** For elements placed on top of flask/default fill (#121314) */
        inverse: brandColor_1.brandColor.grey900,
    },
    shadow: {
        /** For neutral drop shadow color (#00000066) */
        default: '#00000066',
        /** For primary drop shadow color (#8b99ff33) */
        primary: '#8b99ff33',
        /** For critical/danger drop shadow color (#ff758433) */
        error: '#ff758433',
    },
};

      };
    };
  }
  }
}, {package:"@metamask/design-tokens",file:"node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\darkTheme\\colors.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\darkTheme\\darkTheme.cjs", {"../../typography/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\index.cjs","./colors.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\darkTheme\\colors.cjs","./shadows.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\darkTheme\\shadows.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cdesign-tokens%5Cdist%5Cjs%5Cthemes%5CdarkTheme%5CdarkTheme.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.darkTheme = void 0;
const typography_1 = require("../../typography/index.cjs");
const colors_1 = require("./colors.cjs");
const shadows_1 = require("./shadows.cjs");
exports.darkTheme = {
    colors: colors_1.colors,
    typography: typography_1.typography,
    shadows: shadows_1.shadows,
};

      };
    };
  }
  }
}, {package:"@metamask/design-tokens",file:"node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\darkTheme\\darkTheme.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\darkTheme\\index.cjs", {"./darkTheme.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\darkTheme\\darkTheme.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cdesign-tokens%5Cdist%5Cjs%5Cthemes%5CdarkTheme%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.darkTheme = void 0;
var darkTheme_1 = require("./darkTheme.cjs");
Object.defineProperty(exports, "darkTheme", { enumerable: true, get: function () { return darkTheme_1.darkTheme; } });

      };
    };
  }
  }
}, {package:"@metamask/design-tokens",file:"node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\darkTheme\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\darkTheme\\shadows.cjs", {"./colors.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\darkTheme\\colors.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cdesign-tokens%5Cdist%5Cjs%5Cthemes%5CdarkTheme%5Cshadows.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.shadows = void 0;
const colors_1 = require("./colors.cjs");
exports.shadows = {
    size: {
        xs: {
            shadowColor: colors_1.colors.shadow.default,
            shadowOffset: {
                width: 0,
                height: 2,
            },
            shadowOpacity: 1,
            shadowRadius: 4,
        },
        sm: {
            shadowColor: colors_1.colors.shadow.default,
            shadowOffset: {
                width: 0,
                height: 2,
            },
            shadowOpacity: 1,
            shadowRadius: 8,
        },
        md: {
            shadowColor: colors_1.colors.shadow.default,
            shadowOffset: {
                width: 0,
                height: 2,
            },
            shadowOpacity: 1,
            shadowRadius: 16,
        },
        lg: {
            shadowColor: colors_1.colors.shadow.default,
            shadowOffset: {
                width: 0,
                height: 2,
            },
            shadowOpacity: 1,
            shadowRadius: 40,
        },
    },
};

      };
    };
  }
  }
}, {package:"@metamask/design-tokens",file:"node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\darkTheme\\shadows.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\index.cjs", {"./darkTheme/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\darkTheme\\index.cjs","./lightTheme/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\lightTheme\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cdesign-tokens%5Cdist%5Cjs%5Cthemes%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.darkTheme = exports.lightTheme = void 0;
var lightTheme_1 = require("./lightTheme/index.cjs");
Object.defineProperty(exports, "lightTheme", { enumerable: true, get: function () { return lightTheme_1.lightTheme; } });
var darkTheme_1 = require("./darkTheme/index.cjs");
Object.defineProperty(exports, "darkTheme", { enumerable: true, get: function () { return darkTheme_1.darkTheme; } });

      };
    };
  }
  }
}, {package:"@metamask/design-tokens",file:"node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\lightTheme\\colors.cjs", {"../../brandColor/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\brandColor\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cdesign-tokens%5Cdist%5Cjs%5Cthemes%5ClightTheme%5Ccolors.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.colors = void 0;
const brandColor_1 = require("../../brandColor/index.cjs");
exports.colors = {
    background: {
        /** For default neutral surface (#FFFFFF) */
        default: brandColor_1.brandColor.grey000,
        /** For sunken neutral surface below background/default (#F3F5F9) */
        alternative: brandColor_1.brandColor.grey050,
        /** For section bg usually over background/default (#F3F5F9) */
        section: brandColor_1.brandColor.grey050,
        /** For subsection bg usually over background/section (#FFFFFF) */
        subsection: brandColor_1.brandColor.grey000,
        /** For muted neutral surface (#3c4d9d0f) */
        muted: '#3c4d9d0f',
        /** Hover state surface for background/default (#f6f6f7) */
        defaultHover: '#f6f6f7',
        /** Pressed state surface for background/default (#ebecef) */
        defaultPressed: '#ebecef',
        /** Hover state surface for background/alternative (#ebedf1) */
        alternativeHover: '#ebedf1',
        /** Pressed state surface for background/alternative (#e1e4ea) */
        alternativePressed: '#e1e4ea',
        /** Hover state surface for background/muted (#3c4d9d1a) */
        mutedHover: '#3c4d9d1a',
        /** Pressed state surface for background/muted (#3c4d9d26) */
        mutedPressed: '#3c4d9d26',
        /** General purpose hover state tint (#858b9a14) */
        hover: '#858b9a14',
        /** General purpose pressed state tint (#858b9a29) */
        pressed: '#858b9a29',
    },
    text: {
        /** Default color for text (#121314) */
        default: brandColor_1.brandColor.grey900,
        /** Softer color for text (#686E7D) */
        alternative: brandColor_1.brandColor.grey500,
        /** Muted color for text (Not accessible) (#9CA1AF) */
        muted: brandColor_1.brandColor.grey200,
    },
    icon: {
        /** Default color for icons (#121314) */
        default: brandColor_1.brandColor.grey900,
        /** Softer color for icons (#686E7D) */
        /** Hover state surface for icon.default (#2a2b2c) */
        defaultHover: '#2a2b2c',
        /** Pressed state surface for icon.default (#414243) */
        defaultPressed: '#414243',
        alternative: brandColor_1.brandColor.grey500,
        /** Muted color for icons (Not accessible) (#9CA1AF) */
        muted: brandColor_1.brandColor.grey200,
        /** For elements placed on top of icon.default fill (#FFFFFF) */
        inverse: brandColor_1.brandColor.grey000,
    },
    border: {
        /** Default color for borders (#B7BBC8) */
        default: brandColor_1.brandColor.grey200,
        /** Muted color for borders (#B7BBC866) */
        muted: '#b7bbc866',
    },
    overlay: {
        /** Default color for overlays (scrim) (#3f434a66) */
        default: '#3f434a66',
        /** Dimmer color for overlays (scrim) (#000000CC) */
        alternative: '#000000cc',
        /** For elements placed on top of overlay/alternative (#FFFFFF) */
        inverse: brandColor_1.brandColor.grey000,
    },
    primary: {
        /** For primary semantic elements: interactive, active, selected (#4459ff) */
        default: brandColor_1.brandColor.blue500,
        /** Stronger color for primary semantic elements (#2c3dc5) */
        alternative: brandColor_1.brandColor.blue600,
        /** Muted color for primary semantic elements (#4459ff1a) */
        muted: '#4459ff1a',
        /** For elements placed on top of primary/default (#ffffff) */
        inverse: brandColor_1.brandColor.grey000,
        /** Hover state surface for primary/default (#384df5) */
        defaultHover: '#384df5',
        /** Pressed state surface for primary/default (#2b3eda) */
        defaultPressed: '#2b3eda',
        /** Hover state surface for primary/muted (#4459ff26) */
        mutedHover: '#4459ff26',
        /** Pressed state surface for primary/muted (#4459ff33) */
        mutedPressed: '#4459ff33',
    },
    error: {
        /** For danger semantic elements: error, critical, destructive (#CA3542) */
        default: brandColor_1.brandColor.red500,
        /** Stronger color for error semantic (#952731) */
        alternative: brandColor_1.brandColor.red600,
        /** Muted color for error semantic (#CA35421A) */
        muted: '#ca35421a',
        /** For elements placed on top of error/default fill (#FFFFFF) */
        inverse: brandColor_1.brandColor.grey000,
        /** Hover state surface for error/default (#ba313d) */
        defaultHover: '#ba313d',
        /** Pressed state surface for error/default (#9A2832) */
        defaultPressed: '#9a2832',
        /** Hover state surface for error/muted (#CA354226) */
        mutedHover: '#ca354226',
        /** Pressed state surface for error/muted (#CA354233) */
        mutedPressed: '#ca354233',
    },
    warning: {
        /** For warning semantic elements: caution, attention, precaution (#9A6300) */
        default: brandColor_1.brandColor.yellow500,
        /** Muted color option for warning semantic (#9A63001A) */
        muted: '#9a63001a',
        /** For elements placed on top of warning/default fill (#FFFFFF) */
        inverse: brandColor_1.brandColor.grey000,
        /** Hover state surface for warning/default (#855500) */
        defaultHover: '#855500',
        /** Pressed state surface for warning/default (#5C3B00) */
        defaultPressed: '#5c3b00',
        /** Hover state surface for warning/muted (#9A630026) */
        mutedHover: '#9a630026',
        /** Pressed state surface for warning/muted (#9A630033) */
        mutedPressed: '#9a630033',
    },
    success: {
        /** For positive semantic elements: success, confirm, complete, safe (#457A39) */
        default: brandColor_1.brandColor.lime500,
        /** Muted color for positive semantic (#457a391a) */
        muted: '#457a391a',
        /** For elements placed on top of success/default fill (#FFFFFF) */
        inverse: brandColor_1.brandColor.grey000,
        /** Hover state surface for success/default (#3d6c32) */
        defaultHover: '#3d6c32',
        /** Pressed state surface for success/default (#2d5025) */
        defaultPressed: '#2d5025',
        /** Hover state surface for success/muted (#457a3926) */
        mutedHover: '#457a3926',
        /** Pressed state surface for success/muted (#457a3933) */
        mutedPressed: '#457a3933',
    },
    info: {
        /** For informational read-only elements: info, reminder, hint (#4459ff) */
        default: brandColor_1.brandColor.blue500,
        /** Muted color for informational semantic (#4459ff1a) */
        muted: '#4459ff1a',
        /** For elements placed on top of info/default (#FFFFFF) */
        inverse: brandColor_1.brandColor.grey000,
    },
    accent01: {
        /** Expressive color in light orange (#ffa680) */
        light: brandColor_1.brandColor.orange200,
        /** Expressive color in orange (#ff5c16) */
        normal: brandColor_1.brandColor.orange400,
        /** Expressive color in dark orange (#661800) */
        dark: brandColor_1.brandColor.orange700,
    },
    accent02: {
        /** Expressive color in light purple (#eac2ff) */
        light: brandColor_1.brandColor.purple100,
        /** Expressive color in purple (#d075ff) */
        normal: brandColor_1.brandColor.purple300,
        /** Expressive color in dark purple (#3d065f) */
        dark: brandColor_1.brandColor.purple800,
    },
    accent03: {
        /** Expressive color in light lime (#e5ffc3) */
        light: brandColor_1.brandColor.lime050,
        /** Expressive color in lime (#baf24a) */
        normal: brandColor_1.brandColor.lime100,
        /** Expressive color in dark lime (#013330) */
        dark: brandColor_1.brandColor.lime700,
    },
    accent04: {
        /** Expressive color in light indigo (#cce7ff) */
        light: brandColor_1.brandColor.indigo100,
        /** Expressive color in indigo (#89b0ff) */
        normal: brandColor_1.brandColor.indigo200,
        /** Expressive color in dark indigo (#190066) */
        dark: brandColor_1.brandColor.indigo800,
    },
    flask: {
        /** For Flask primary accent color (#8F44E4) */
        default: brandColor_1.brandColor.purple500,
        /** For elements placed on top of flask/default (#FFFFFF) */
        inverse: brandColor_1.brandColor.grey000,
    },
    shadow: {
        /** For neutral drop shadow color (#0000001A) */
        default: '#0000001a',
        /** For primary drop shadow color (#4459ff33) */
        primary: '#4459ff33',
        /** For critical/danger drop shadow color (#CA354266) */
        error: '#ca354266',
    },
};

      };
    };
  }
  }
}, {package:"@metamask/design-tokens",file:"node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\lightTheme\\colors.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\lightTheme\\index.cjs", {"./lightTheme.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\lightTheme\\lightTheme.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cdesign-tokens%5Cdist%5Cjs%5Cthemes%5ClightTheme%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.lightTheme = void 0;
var lightTheme_1 = require("./lightTheme.cjs");
Object.defineProperty(exports, "lightTheme", { enumerable: true, get: function () { return lightTheme_1.lightTheme; } });

      };
    };
  }
  }
}, {package:"@metamask/design-tokens",file:"node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\lightTheme\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\lightTheme\\lightTheme.cjs", {"../../typography/index.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\index.cjs","./colors.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\lightTheme\\colors.cjs","./shadows.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\lightTheme\\shadows.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cdesign-tokens%5Cdist%5Cjs%5Cthemes%5ClightTheme%5ClightTheme.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.lightTheme = void 0;
const typography_1 = require("../../typography/index.cjs");
const colors_1 = require("./colors.cjs");
const shadows_1 = require("./shadows.cjs");
exports.lightTheme = {
    colors: colors_1.colors,
    typography: typography_1.typography,
    shadows: shadows_1.shadows,
};

      };
    };
  }
  }
}, {package:"@metamask/design-tokens",file:"node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\lightTheme\\lightTheme.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\lightTheme\\shadows.cjs", {"./colors.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\lightTheme\\colors.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cdesign-tokens%5Cdist%5Cjs%5Cthemes%5ClightTheme%5Cshadows.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.shadows = void 0;
const colors_1 = require("./colors.cjs");
exports.shadows = {
    size: {
        xs: {
            shadowColor: colors_1.colors.shadow.default,
            shadowOffset: {
                width: 0,
                height: 2,
            },
            shadowOpacity: 1,
            shadowRadius: 4,
        },
        sm: {
            shadowColor: colors_1.colors.shadow.default,
            shadowOffset: {
                width: 0,
                height: 2,
            },
            shadowOpacity: 1,
            shadowRadius: 8,
        },
        md: {
            shadowColor: colors_1.colors.shadow.default,
            shadowOffset: {
                width: 0,
                height: 2,
            },
            shadowOpacity: 1,
            shadowRadius: 16,
        },
        lg: {
            shadowColor: colors_1.colors.shadow.default,
            shadowOffset: {
                width: 0,
                height: 2,
            },
            shadowOpacity: 1,
            shadowRadius: 40,
        },
    },
};

      };
    };
  }
  }
}, {package:"@metamask/design-tokens",file:"node_modules\\@metamask\\design-tokens\\dist\\js\\themes\\lightTheme\\shadows.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\fontFamilies.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cdesign-tokens%5Cdist%5Cjs%5Ctypography%5CfontFamilies.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fontFamilies = void 0;
exports.fontFamilies = {
    default: 'Geist',
    accent: 'MMSans',
    hero: 'MMPoly',
};

      };
    };
  }
  }
}, {package:"@metamask/design-tokens",file:"node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\fontFamilies.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\fontSizes.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cdesign-tokens%5Cdist%5Cjs%5Ctypography%5CfontSizes.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fontSizes = void 0;
exports.fontSizes = {
    fontSize1: 10,
    fontSize2: 12,
    fontSize3: 14,
    fontSize4: 16,
    fontSize5: 18,
    fontSize6: 24,
    fontSize7: 32,
    fontSize8: 40,
    fontSize9: 48,
    fontSize10: 60,
};

      };
    };
  }
  }
}, {package:"@metamask/design-tokens",file:"node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\fontSizes.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\fontWeights.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cdesign-tokens%5Cdist%5Cjs%5Ctypography%5CfontWeights.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fontWeights = void 0;
exports.fontWeights = {
    regular: '400',
    medium: '500',
    bold: '700',
};

      };
    };
  }
  }
}, {package:"@metamask/design-tokens",file:"node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\fontWeights.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\index.cjs", {"./fontFamilies.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\fontFamilies.cjs","./typography.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\typography.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cdesign-tokens%5Cdist%5Cjs%5Ctypography%5Cindex.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.typography = exports.fontFamilies = void 0;
var fontFamilies_1 = require("./fontFamilies.cjs");
Object.defineProperty(exports, "fontFamilies", { enumerable: true, get: function () { return fontFamilies_1.fontFamilies; } });
var typography_1 = require("./typography.cjs");
Object.defineProperty(exports, "typography", { enumerable: true, get: function () { return typography_1.typography; } });

      };
    };
  }
  }
}, {package:"@metamask/design-tokens",file:"node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\index.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\letterSpacing.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cdesign-tokens%5Cdist%5Cjs%5Ctypography%5CletterSpacing.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.letterSpacing = void 0;
exports.letterSpacing = {
    letterSpacing0: 0,
    letterSpacing1: 0.25,
};

      };
    };
  }
  }
}, {package:"@metamask/design-tokens",file:"node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\letterSpacing.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\lineHeights.cjs", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cdesign-tokens%5Cdist%5Cjs%5Ctypography%5ClineHeights.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.lineHeights = void 0;
exports.lineHeights = {
    lineHeight1: 16,
    lineHeight2: 20,
    lineHeight3: 22,
    lineHeight4: 24,
    lineHeight5: 32,
    lineHeight6: 40,
    lineHeight7: 50,
    lineHeight8: 56,
    lineHeight9: 75,
};

      };
    };
  }
  }
}, {package:"@metamask/design-tokens",file:"node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\lineHeights.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\typography.cjs", {"./fontSizes.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\fontSizes.cjs","./fontWeights.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\fontWeights.cjs","./letterSpacing.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\letterSpacing.cjs","./lineHeights.cjs":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\lineHeights.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Cdesign-tokens%5Cdist%5Cjs%5Ctypography%5Ctypography.cjs
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.typography = void 0;
const fontSizes_1 = require("./fontSizes.cjs");
const fontWeights_1 = require("./fontWeights.cjs");
const letterSpacing_1 = require("./letterSpacing.cjs");
const lineHeights_1 = require("./lineHeights.cjs");
exports.typography = {
    sDisplayLG: {
        fontWeight: fontWeights_1.fontWeights.bold,
        fontSize: fontSizes_1.fontSizes.fontSize8,
        lineHeight: lineHeights_1.lineHeights.lineHeight7,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    sDisplayMD: {
        fontWeight: fontWeights_1.fontWeights.bold,
        fontSize: fontSizes_1.fontSizes.fontSize7,
        lineHeight: lineHeights_1.lineHeights.lineHeight6,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    sHeadingLG: {
        fontWeight: fontWeights_1.fontWeights.bold,
        fontSize: fontSizes_1.fontSizes.fontSize6,
        lineHeight: lineHeights_1.lineHeights.lineHeight5,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    sHeadingMD: {
        fontWeight: fontWeights_1.fontWeights.bold,
        fontSize: fontSizes_1.fontSizes.fontSize5,
        lineHeight: lineHeights_1.lineHeights.lineHeight4,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    sHeadingSM: {
        fontWeight: fontWeights_1.fontWeights.bold,
        fontSize: fontSizes_1.fontSizes.fontSize4,
        lineHeight: lineHeights_1.lineHeights.lineHeight4,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    sBodyLGMedium: {
        fontWeight: fontWeights_1.fontWeights.medium,
        fontSize: fontSizes_1.fontSizes.fontSize5,
        lineHeight: lineHeights_1.lineHeights.lineHeight4,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    sBodyMD: {
        fontWeight: fontWeights_1.fontWeights.regular,
        fontSize: fontSizes_1.fontSizes.fontSize4,
        lineHeight: lineHeights_1.lineHeights.lineHeight4,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    sBodyMDMedium: {
        fontWeight: fontWeights_1.fontWeights.medium,
        fontSize: fontSizes_1.fontSizes.fontSize4,
        lineHeight: lineHeights_1.lineHeights.lineHeight4,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    sBodyMDBold: {
        fontWeight: fontWeights_1.fontWeights.bold,
        fontSize: fontSizes_1.fontSizes.fontSize4,
        lineHeight: lineHeights_1.lineHeights.lineHeight4,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    sBodySM: {
        fontWeight: fontWeights_1.fontWeights.regular,
        fontSize: fontSizes_1.fontSizes.fontSize3,
        lineHeight: lineHeights_1.lineHeights.lineHeight3,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    sBodySMMedium: {
        fontWeight: fontWeights_1.fontWeights.medium,
        fontSize: fontSizes_1.fontSizes.fontSize3,
        lineHeight: lineHeights_1.lineHeights.lineHeight3,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    sBodySMBold: {
        fontWeight: fontWeights_1.fontWeights.bold,
        fontSize: fontSizes_1.fontSizes.fontSize3,
        lineHeight: lineHeights_1.lineHeights.lineHeight3,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    sBodyXS: {
        fontWeight: fontWeights_1.fontWeights.regular,
        fontSize: fontSizes_1.fontSizes.fontSize2,
        lineHeight: lineHeights_1.lineHeights.lineHeight2,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing1,
    },
    sBodyXSMedium: {
        fontWeight: fontWeights_1.fontWeights.medium,
        fontSize: fontSizes_1.fontSizes.fontSize2,
        lineHeight: lineHeights_1.lineHeights.lineHeight2,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing1,
    },
    sPageHeading: {
        fontWeight: fontWeights_1.fontWeights.bold,
        fontSize: fontSizes_1.fontSizes.fontSize6,
        lineHeight: lineHeights_1.lineHeights.lineHeight5,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    sSectionHeading: {
        fontWeight: fontWeights_1.fontWeights.bold,
        fontSize: fontSizes_1.fontSizes.fontSize4,
        lineHeight: lineHeights_1.lineHeights.lineHeight4,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    sButtonLabelMd: {
        fontWeight: fontWeights_1.fontWeights.medium,
        fontSize: fontSizes_1.fontSizes.fontSize4,
        lineHeight: lineHeights_1.lineHeights.lineHeight4,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    sButtonLabelLg: {
        fontWeight: fontWeights_1.fontWeights.medium,
        fontSize: fontSizes_1.fontSizes.fontSize5,
        lineHeight: lineHeights_1.lineHeights.lineHeight4,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    sAmountDisplayLg: {
        fontWeight: fontWeights_1.fontWeights.bold,
        fontSize: fontSizes_1.fontSizes.fontSize8,
        lineHeight: lineHeights_1.lineHeights.lineHeight7,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    lDisplayLG: {
        fontWeight: fontWeights_1.fontWeights.medium,
        fontSize: fontSizes_1.fontSizes.fontSize10,
        lineHeight: lineHeights_1.lineHeights.lineHeight9,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    lDisplayMD: {
        fontWeight: fontWeights_1.fontWeights.medium,
        fontSize: fontSizes_1.fontSizes.fontSize9,
        lineHeight: lineHeights_1.lineHeights.lineHeight8,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    lHeadingLG: {
        fontWeight: fontWeights_1.fontWeights.bold,
        fontSize: fontSizes_1.fontSizes.fontSize7,
        lineHeight: lineHeights_1.lineHeights.lineHeight6,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    lHeadingMD: {
        fontWeight: fontWeights_1.fontWeights.bold,
        fontSize: fontSizes_1.fontSizes.fontSize6,
        lineHeight: lineHeights_1.lineHeights.lineHeight5,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    lHeadingSM: {
        fontWeight: fontWeights_1.fontWeights.bold,
        fontSize: fontSizes_1.fontSizes.fontSize5,
        lineHeight: lineHeights_1.lineHeights.lineHeight4,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    lBodyLGMedium: {
        fontWeight: fontWeights_1.fontWeights.medium,
        fontSize: fontSizes_1.fontSizes.fontSize5,
        lineHeight: lineHeights_1.lineHeights.lineHeight4,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    lBodyMD: {
        fontWeight: fontWeights_1.fontWeights.regular,
        fontSize: fontSizes_1.fontSizes.fontSize4,
        lineHeight: lineHeights_1.lineHeights.lineHeight4,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    lBodyMDMedium: {
        fontWeight: fontWeights_1.fontWeights.medium,
        fontSize: fontSizes_1.fontSizes.fontSize4,
        lineHeight: lineHeights_1.lineHeights.lineHeight4,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    lBodyMDBold: {
        fontWeight: fontWeights_1.fontWeights.bold,
        fontSize: fontSizes_1.fontSizes.fontSize4,
        lineHeight: lineHeights_1.lineHeights.lineHeight4,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    lBodySM: {
        fontWeight: fontWeights_1.fontWeights.regular,
        fontSize: fontSizes_1.fontSizes.fontSize3,
        lineHeight: lineHeights_1.lineHeights.lineHeight3,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    lBodySMMedium: {
        fontWeight: fontWeights_1.fontWeights.medium,
        fontSize: fontSizes_1.fontSizes.fontSize3,
        lineHeight: lineHeights_1.lineHeights.lineHeight3,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    lBodySMBold: {
        fontWeight: fontWeights_1.fontWeights.bold,
        fontSize: fontSizes_1.fontSizes.fontSize3,
        lineHeight: lineHeights_1.lineHeights.lineHeight3,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    lBodyXS: {
        fontWeight: fontWeights_1.fontWeights.regular,
        fontSize: fontSizes_1.fontSizes.fontSize2,
        lineHeight: lineHeights_1.lineHeights.lineHeight2,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing1,
    },
    lBodyXSMedium: {
        fontWeight: fontWeights_1.fontWeights.medium,
        fontSize: fontSizes_1.fontSizes.fontSize2,
        lineHeight: lineHeights_1.lineHeights.lineHeight2,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing1,
    },
    lPageHeading: {
        fontWeight: fontWeights_1.fontWeights.bold,
        fontSize: fontSizes_1.fontSizes.fontSize7,
        lineHeight: lineHeights_1.lineHeights.lineHeight6,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    lSectionHeading: {
        fontWeight: fontWeights_1.fontWeights.bold,
        fontSize: fontSizes_1.fontSizes.fontSize5,
        lineHeight: lineHeights_1.lineHeights.lineHeight4,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    lButtonLabelMd: {
        fontWeight: fontWeights_1.fontWeights.medium,
        fontSize: fontSizes_1.fontSizes.fontSize4,
        lineHeight: lineHeights_1.lineHeights.lineHeight4,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    lButtonLabelLg: {
        fontWeight: fontWeights_1.fontWeights.medium,
        fontSize: fontSizes_1.fontSizes.fontSize5,
        lineHeight: lineHeights_1.lineHeights.lineHeight4,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
    lAmountDisplayLg: {
        fontWeight: fontWeights_1.fontWeights.medium,
        fontSize: fontSizes_1.fontSizes.fontSize10,
        lineHeight: lineHeights_1.lineHeights.lineHeight9,
        letterSpacing: letterSpacing_1.letterSpacing.letterSpacing0,
    },
};

      };
    };
  }
  }
}, {package:"@metamask/design-tokens",file:"node_modules\\@metamask\\design-tokens\\dist\\js\\typography\\typography.cjs",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-token-tracker\\dist\\index.js", {"./token":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-token-tracker\\dist\\token.js","@babel/runtime/helpers/assertThisInitialized":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\assertThisInitialized.js","@babel/runtime/helpers/asyncToGenerator":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\asyncToGenerator.js","@babel/runtime/helpers/classCallCheck":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\classCallCheck.js","@babel/runtime/helpers/createClass":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\createClass.js","@babel/runtime/helpers/getPrototypeOf":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\getPrototypeOf.js","@babel/runtime/helpers/inherits":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\inherits.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/possibleConstructorReturn":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\possibleConstructorReturn.js","@babel/runtime/regenerator":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\regenerator\\index.js","@ethersproject/contracts":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\contracts\\lib\\index.js","@ethersproject/providers":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\providers\\lib\\index.js","@metamask/eth-block-tracker":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-token-tracker\\node_modules\\@metamask\\eth-block-tracker\\dist\\index.js","@metamask/safe-event-emitter":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\safe-event-emitter\\dist\\cjs\\index.js","deep-equal":"D:\\code\\v\\metamask-extension\\node_modules\\deep-equal\\index.js","human-standard-token-abi":"D:\\code\\v\\metamask-extension\\node_modules\\human-standard-token-abi\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-token-tracker%5Cdist%5Cindex.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var _require = require('@metamask/eth-block-tracker'),
  PollingBlockTracker = _require.PollingBlockTracker;
var _require2 = require('@ethersproject/providers'),
  Web3Provider = _require2.Web3Provider;
var _require3 = require('@ethersproject/contracts'),
  Contract = _require3.Contract;
var Token = require('./token');
var abi = require('human-standard-token-abi');
var SafeEventEmitter = require('@metamask/safe-event-emitter')["default"];
var deepEqual = require('deep-equal');
var TokenTracker = /*#__PURE__*/function (_SafeEventEmitter) {
  (0, _inherits2["default"])(TokenTracker, _SafeEventEmitter);
  var _super = _createSuper(TokenTracker);
  function TokenTracker() {
    var _this;
    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    (0, _classCallCheck2["default"])(this, TokenTracker);
    _this = _super.call(this);
    _this.includeFailedTokens = opts.includeFailedTokens || false;
    _this.userAddress = opts.userAddress || '0x0';
    var pollingInterval = opts.pollingInterval || 4000;
    _this.blockTracker = new PollingBlockTracker({
      provider: opts.provider,
      pollingInterval: pollingInterval
    });
    _this.provider = opts.provider;
    var tokens = opts.tokens || [];
    _this.balanceDecimals = opts.balanceDecimals;
    _this.tokens = tokens.map(function (tokenOpts) {
      return _this.createTokenFrom(tokenOpts, _this.balanceDecimals);
    });

    // initialize to empty array to ensure a tracker initialized
    // with zero tokens doesn't emit an update until a token is added.
    _this._oldBalances = [];
    Promise.all(_this.tokens.map(function (token) {
      return token.update();
    })).then(function (newBalances) {
      _this._update(newBalances);
    })["catch"](function (error) {
      _this.emit('error', error);
    });
    _this.updateBalances = _this.updateBalances.bind((0, _assertThisInitialized2["default"])(_this));
    _this.running = true;
    _this.blockTracker.on('latest', _this.updateBalances);
    return _this;
  }
  (0, _createClass2["default"])(TokenTracker, [{
    key: "serialize",
    value: function serialize() {
      return this.tokens.map(function (token) {
        return token.serialize();
      });
    }
  }, {
    key: "getContractAtAddress",
    value: function getContractAtAddress(tokenAddress) {
      return new Contract(tokenAddress, abi, new Web3Provider(this.provider));
    }
  }, {
    key: "updateBalances",
    value: function () {
      var _updateBalances = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee() {
        var newBalances;
        return _regenerator["default"].wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.prev = 0;
              _context.next = 3;
              return Promise.all(this.tokens.map(function (token) {
                return token.updateBalance();
              }));
            case 3:
              newBalances = this.serialize();
              this._update(newBalances);
              _context.next = 10;
              break;
            case 7:
              _context.prev = 7;
              _context.t0 = _context["catch"](0);
              this.emit('error', _context.t0);
            case 10:
            case "end":
              return _context.stop();
          }
        }, _callee, this, [[0, 7]]);
      }));
      function updateBalances() {
        return _updateBalances.apply(this, arguments);
      }
      return updateBalances;
    }()
  }, {
    key: "createTokenFrom",
    value: function createTokenFrom(opts, balanceDecimals) {
      var owner = this.userAddress;
      var address = opts.address,
        symbol = opts.symbol,
        balance = opts.balance,
        decimals = opts.decimals;
      var contract = this.getContractAtAddress(address);
      return new Token({
        address: address,
        symbol: symbol,
        balance: balance,
        decimals: decimals,
        contract: contract,
        owner: owner,
        throwOnBalanceError: this.includeFailedTokens === false,
        balanceDecimals: balanceDecimals
      });
    }
  }, {
    key: "add",
    value: function add(opts) {
      var _this2 = this;
      var token = this.createTokenFrom(opts);
      this.tokens.push(token);
      token.update().then(function () {
        _this2._update(_this2.serialize());
      })["catch"](function (error) {
        _this2.emit('error', error);
      });
    }
  }, {
    key: "stop",
    value: function stop() {
      this.running = false;
      this.blockTracker.removeListener('latest', this.updateBalances);
    }
  }, {
    key: "_update",
    value: function _update(newBalances) {
      if (!this.running || deepEqual(newBalances, this._oldBalances)) {
        return;
      }
      this._oldBalances = newBalances;
      this.emit('update', newBalances);
    }
  }]);
  return TokenTracker;
}(SafeEventEmitter);
module.exports = TokenTracker;
      };
    };
  }
  }
}, {package:"@metamask/eth-token-tracker",file:"node_modules\\@metamask\\eth-token-tracker\\dist\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-token-tracker\\dist\\token.js", {"./util":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-token-tracker\\dist\\util.js","@babel/runtime/helpers/asyncToGenerator":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\asyncToGenerator.js","@babel/runtime/helpers/classCallCheck":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\classCallCheck.js","@babel/runtime/helpers/createClass":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\createClass.js","@babel/runtime/helpers/interopRequireDefault":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\interopRequireDefault.js","@babel/runtime/helpers/toConsumableArray":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\helpers\\toConsumableArray.js","@babel/runtime/regenerator":"D:\\code\\v\\metamask-extension\\node_modules\\@babel\\runtime\\regenerator\\index.js","@ethersproject/bignumber":"D:\\code\\v\\metamask-extension\\node_modules\\@ethersproject\\bignumber\\lib\\index.js","bn.js":"D:\\code\\v\\metamask-extension\\node_modules\\bn.js\\lib\\bn.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-token-tracker%5Cdist%5Ctoken.js
      return function (require, module, exports) {
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var BN = require('bn.js');
var _require = require("@ethersproject/bignumber"),
  BigNumber = _require.BigNumber;
var util = require('./util');

/**
 * Checks whether the given input and base will produce an invalid bn instance.
 *
 * bn.js requires extra validation to safely use, so this function allows
 * us to typecheck the params we pass to it.
 *
 * @see {@link https://github.com/indutny/bn.js/issues/151}
 * @param {any} input - the bn.js input
 * @param {number} base - the bn.js base argument
 * @returns {boolean}
 */
function _isInvalidBnInput(input, base) {
  return typeof input === 'string' && (input.startsWith('0x') || Number.isNaN(parseInt(input, base)));
}
var Token = /*#__PURE__*/function () {
  function Token() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      address = _ref.address,
      symbol = _ref.symbol,
      balance = _ref.balance,
      decimals = _ref.decimals,
      contract = _ref.contract,
      owner = _ref.owner,
      throwOnBalanceError = _ref.throwOnBalanceError,
      balanceDecimals = _ref.balanceDecimals;
    (0, _classCallCheck2["default"])(this, Token);
    if (!contract) {
      throw new Error('Missing requried \'contract\' parameter');
    } else if (!owner) {
      throw new Error('Missing requried \'owner\' parameter');
    }
    this.isLoading = !address || !symbol || !balance || !decimals;
    this.address = address || '0x0';
    this.symbol = symbol;
    this.throwOnBalanceError = throwOnBalanceError;
    this.balanceDecimals = balanceDecimals;
    if (!balance) {
      balance = '0';
    } else if (_isInvalidBnInput(balance, 16)) {
      throw new Error('Invalid \'balance\' option provided; must be non-prefixed hex string if given as string');
    }
    if (decimals && _isInvalidBnInput(decimals, 10)) {
      throw new Error('Invalid \'decimals\' option provided; must be non-prefixed hex string if given as string');
    }
    this.balance = new BN(balance, 16);
    this.decimals = decimals ? new BN(decimals) : undefined;
    this.owner = owner;
    this.contract = contract;
  }
  (0, _createClass2["default"])(Token, [{
    key: "update",
    value: function () {
      var _update = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee() {
        return _regenerator["default"].wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return Promise.all([this.symbol || this.updateSymbol(), this.updateBalance(), this.decimals || this.updateDecimals()]);
            case 2:
              this.isLoading = false;
              return _context.abrupt("return", this.serialize());
            case 4:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function update() {
        return _update.apply(this, arguments);
      }
      return update;
    }()
  }, {
    key: "serialize",
    value: function serialize() {
      return {
        address: this.address,
        symbol: this.symbol,
        balance: this.balance.toString(10),
        decimals: this.decimals ? parseInt(this.decimals.toString()) : 0,
        string: this.stringify(),
        balanceError: this.balanceError ? this.balanceError : null
      };
    }
  }, {
    key: "stringify",
    value: function stringify() {
      return util.stringifyBalance(this.balance, this.decimals || new BN(0), this.balanceDecimals);
    }
  }, {
    key: "updateSymbol",
    value: function () {
      var _updateSymbol = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2() {
        var symbol;
        return _regenerator["default"].wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              _context2.next = 2;
              return this.updateValue('symbol');
            case 2:
              symbol = _context2.sent;
              this.symbol = symbol || 'TKN';
              return _context2.abrupt("return", this.symbol);
            case 5:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this);
      }));
      function updateSymbol() {
        return _updateSymbol.apply(this, arguments);
      }
      return updateSymbol;
    }()
  }, {
    key: "updateBalance",
    value: function () {
      var _updateBalance = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3() {
        var balance;
        return _regenerator["default"].wrap(function _callee3$(_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              _context3.next = 2;
              return this.updateValue('balance');
            case 2:
              balance = _context3.sent;
              this.balance = balance;
              return _context3.abrupt("return", this.balance);
            case 5:
            case "end":
              return _context3.stop();
          }
        }, _callee3, this);
      }));
      function updateBalance() {
        return _updateBalance.apply(this, arguments);
      }
      return updateBalance;
    }()
  }, {
    key: "updateDecimals",
    value: function () {
      var _updateDecimals = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4() {
        var decimals;
        return _regenerator["default"].wrap(function _callee4$(_context4) {
          while (1) switch (_context4.prev = _context4.next) {
            case 0:
              if (!(this.decimals !== undefined)) {
                _context4.next = 2;
                break;
              }
              return _context4.abrupt("return", this.decimals);
            case 2:
              _context4.next = 4;
              return this.updateValue('decimals');
            case 4:
              decimals = _context4.sent;
              if (decimals) {
                this.decimals = decimals;
              }
              return _context4.abrupt("return", this.decimals);
            case 7:
            case "end":
              return _context4.stop();
          }
        }, _callee4, this);
      }));
      function updateDecimals() {
        return _updateDecimals.apply(this, arguments);
      }
      return updateDecimals;
    }()
  }, {
    key: "updateValue",
    value: function () {
      var _updateValue = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee5(key) {
        var methodName, args, result, _this$contract, val;
        return _regenerator["default"].wrap(function _callee5$(_context5) {
          while (1) switch (_context5.prev = _context5.next) {
            case 0:
              args = [];
              _context5.t0 = key;
              _context5.next = _context5.t0 === 'balance' ? 4 : 7;
              break;
            case 4:
              methodName = 'balanceOf';
              args = [this.owner];
              return _context5.abrupt("break", 8);
            case 7:
              methodName = key;
            case 8:
              _context5.prev = 8;
              _context5.next = 11;
              return (_this$contract = this.contract)[methodName].apply(_this$contract, (0, _toConsumableArray2["default"])(args));
            case 11:
              result = _context5.sent;
              if (key === 'balance') {
                this.balanceError = null;
              }
              _context5.next = 22;
              break;
            case 15:
              _context5.prev = 15;
              _context5.t1 = _context5["catch"](8);
              console.warn("failed to load ".concat(key, " for token at ").concat(this.address));
              if (!(key === 'balance')) {
                _context5.next = 22;
                break;
              }
              this.balanceError = _context5.t1;
              if (!this.throwOnBalanceError) {
                _context5.next = 22;
                break;
              }
              throw _context5.t1;
            case 22:
              if (!result) {
                _context5.next = 27;
                break;
              }
              val = result;
              if (BigNumber.isBigNumber(result)) {
                val = new BN(result.toString());
              }
              this[key] = val;
              return _context5.abrupt("return", val);
            case 27:
              return _context5.abrupt("return", this[key]);
            case 28:
            case "end":
              return _context5.stop();
          }
        }, _callee5, this, [[8, 15]]);
      }));
      function updateValue(_x) {
        return _updateValue.apply(this, arguments);
      }
      return updateValue;
    }()
  }]);
  return Token;
}();
module.exports = Token;
      };
    };
  }
  }
}, {package:"@metamask/eth-token-tracker",file:"node_modules\\@metamask\\eth-token-tracker\\dist\\token.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-token-tracker\\dist\\util.js", {"bn.js":"D:\\code\\v\\metamask-extension\\node_modules\\bn.js\\lib\\bn.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-token-tracker%5Cdist%5Cutil.js
      return function (require, module, exports) {
"use strict";

var BN = require('bn.js');
var zero = new BN(0);
module.exports = {
  stringifyBalance: function stringifyBalance(balance, bnDecimals) {
    var balanceDecimals = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 3;
    if (balance.eq(zero)) {
      return '0';
    }
    var decimals = parseInt(bnDecimals.toString());
    if (decimals === 0) {
      return balance.toString();
    }
    var bal = balance.toString();
    var len = bal.length;
    var decimalIndex = len - decimals;
    var prefix = '';
    if (decimalIndex <= 0) {
      while (prefix.length <= decimalIndex * -1) {
        prefix += '0';
        len++;
      }
      bal = prefix + bal;
      decimalIndex = 1;
    }
    var whole = bal.substr(0, len - decimals);
    if (balanceDecimals === 0) {
      return whole;
    }
    var fractional = bal.substr(decimalIndex, balanceDecimals);
    if (/0+$/.test(fractional)) {
      var withOnlySigZeroes = bal.substr(decimalIndex).replace(/0+$/, '');
      if (withOnlySigZeroes.length > 0) withOnlySigZeroes = ".".concat(withOnlySigZeroes);
      return "".concat(whole).concat(withOnlySigZeroes);
    }
    return "".concat(whole, ".").concat(fractional);
  }
};
      };
    };
  }
  }
}, {package:"@metamask/eth-token-tracker",file:"node_modules\\@metamask\\eth-token-tracker\\dist\\util.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-token-tracker\\node_modules\\@metamask\\eth-block-tracker\\dist\\BlockTracker.js", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-token-tracker%5Cnode_modules%5C@metamask%5Ceth-block-tracker%5Cdist%5CBlockTracker.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });

      };
    };
  }
  }
}, {package:"@metamask/eth-token-tracker>@metamask/eth-block-tracker",file:"node_modules\\@metamask\\eth-token-tracker\\node_modules\\@metamask\\eth-block-tracker\\dist\\BlockTracker.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-token-tracker\\node_modules\\@metamask\\eth-block-tracker\\dist\\PollingBlockTracker.js", {"./logging-utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-token-tracker\\node_modules\\@metamask\\eth-block-tracker\\dist\\logging-utils.js","@metamask/safe-event-emitter":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\safe-event-emitter\\dist\\cjs\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","json-rpc-random-id":"D:\\code\\v\\metamask-extension\\node_modules\\json-rpc-random-id\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-token-tracker%5Cnode_modules%5C@metamask%5Ceth-block-tracker%5Cdist%5CPollingBlockTracker.js
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _PollingBlockTracker_instances, _PollingBlockTracker_internalEventListeners, _PollingBlockTracker_pendingLatestBlock, _PollingBlockTracker_addInternalListener, _PollingBlockTracker_removeInternalListener, _PollingBlockTracker_rejectPendingLatestBlock;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PollingBlockTracker = void 0;
const safe_event_emitter_1 = __importDefault(require("@metamask/safe-event-emitter"));
const utils_1 = require("@metamask/utils");
const json_rpc_random_id_1 = __importDefault(require("json-rpc-random-id"));
const logging_utils_1 = require("./logging-utils");
const log = (0, logging_utils_1.createModuleLogger)(logging_utils_1.projectLogger, 'polling-block-tracker');
const createRandomId = (0, json_rpc_random_id_1.default)();
const sec = 1000;
const blockTrackerEvents = ['sync', 'latest'];
class PollingBlockTracker extends safe_event_emitter_1.default {
    constructor(opts = {}) {
        // parse + validate args
        if (!opts.provider) {
            throw new Error('PollingBlockTracker - no provider specified.');
        }
        super();
        _PollingBlockTracker_instances.add(this);
        _PollingBlockTracker_internalEventListeners.set(this, []);
        _PollingBlockTracker_pendingLatestBlock.set(this, void 0);
        // config
        this._blockResetDuration = opts.blockResetDuration || 20 * sec;
        this._usePastBlocks = opts.usePastBlocks || false;
        // state
        this._currentBlock = null;
        this._isRunning = false;
        // bind functions for internal use
        this._onNewListener = this._onNewListener.bind(this);
        this._onRemoveListener = this._onRemoveListener.bind(this);
        this._resetCurrentBlock = this._resetCurrentBlock.bind(this);
        // listen for handler changes
        this._setupInternalEvents();
        // config
        this._provider = opts.provider;
        this._pollingInterval = opts.pollingInterval || 20 * sec;
        this._retryTimeout = opts.retryTimeout || this._pollingInterval / 10;
        this._keepEventLoopActive =
            opts.keepEventLoopActive === undefined ? true : opts.keepEventLoopActive;
        this._setSkipCacheFlag = opts.setSkipCacheFlag || false;
    }
    async destroy() {
        this._cancelBlockResetTimeout();
        this._maybeEnd();
        super.removeAllListeners();
        __classPrivateFieldGet(this, _PollingBlockTracker_instances, "m", _PollingBlockTracker_rejectPendingLatestBlock).call(this, new Error('Block tracker destroyed'));
    }
    isRunning() {
        return this._isRunning;
    }
    getCurrentBlock() {
        return this._currentBlock;
    }
    async getLatestBlock() {
        // return if available
        if (this._currentBlock) {
            return this._currentBlock;
        }
        else if (__classPrivateFieldGet(this, _PollingBlockTracker_pendingLatestBlock, "f")) {
            return await __classPrivateFieldGet(this, _PollingBlockTracker_pendingLatestBlock, "f").promise;
        }
        const { promise, resolve, reject } = (0, utils_1.createDeferredPromise)({
            suppressUnhandledRejection: true,
        });
        __classPrivateFieldSet(this, _PollingBlockTracker_pendingLatestBlock, { reject, promise }, "f");
        // wait for a new latest block
        const onLatestBlock = (value) => {
            __classPrivateFieldGet(this, _PollingBlockTracker_instances, "m", _PollingBlockTracker_removeInternalListener).call(this, onLatestBlock);
            resolve(value);
            __classPrivateFieldSet(this, _PollingBlockTracker_pendingLatestBlock, undefined, "f");
        };
        __classPrivateFieldGet(this, _PollingBlockTracker_instances, "m", _PollingBlockTracker_addInternalListener).call(this, onLatestBlock);
        this.once('latest', onLatestBlock);
        return await promise;
    }
    // dont allow module consumer to remove our internal event listeners
    removeAllListeners(eventName) {
        // perform default behavior, preserve fn arity
        if (eventName) {
            super.removeAllListeners(eventName);
        }
        else {
            super.removeAllListeners();
        }
        // re-add internal events
        this._setupInternalEvents();
        // trigger stop check just in case
        this._onRemoveListener();
        return this;
    }
    _setupInternalEvents() {
        // first remove listeners for idempotence
        this.removeListener('newListener', this._onNewListener);
        this.removeListener('removeListener', this._onRemoveListener);
        // then add them
        this.on('newListener', this._onNewListener);
        this.on('removeListener', this._onRemoveListener);
    }
    _onNewListener(eventName) {
        // `newListener` is called *before* the listener is added
        if (blockTrackerEvents.includes(eventName)) {
            // TODO: Handle dangling promise
            this._maybeStart();
        }
    }
    _onRemoveListener() {
        // `removeListener` is called *after* the listener is removed
        if (this._getBlockTrackerEventCount() > 0) {
            return;
        }
        this._maybeEnd();
    }
    _maybeStart() {
        if (this._isRunning) {
            return;
        }
        this._isRunning = true;
        // cancel setting latest block to stale
        this._cancelBlockResetTimeout();
        this._start();
        this.emit('_started');
    }
    _maybeEnd() {
        if (!this._isRunning) {
            return;
        }
        this._isRunning = false;
        this._setupBlockResetTimeout();
        this._end();
        this.emit('_ended');
    }
    _getBlockTrackerEventCount() {
        return (blockTrackerEvents
            .map((eventName) => this.listeners(eventName))
            .flat()
            // internal listeners are not included in the count
            .filter((listener) => __classPrivateFieldGet(this, _PollingBlockTracker_internalEventListeners, "f").every((internalListener) => !Object.is(internalListener, listener))).length);
    }
    _shouldUseNewBlock(newBlock) {
        const currentBlock = this._currentBlock;
        if (!currentBlock) {
            return true;
        }
        const newBlockInt = hexToInt(newBlock);
        const currentBlockInt = hexToInt(currentBlock);
        return ((this._usePastBlocks && newBlockInt < currentBlockInt) ||
            newBlockInt > currentBlockInt);
    }
    _newPotentialLatest(newBlock) {
        if (!this._shouldUseNewBlock(newBlock)) {
            return;
        }
        this._setCurrentBlock(newBlock);
    }
    _setCurrentBlock(newBlock) {
        const oldBlock = this._currentBlock;
        this._currentBlock = newBlock;
        this.emit('latest', newBlock);
        this.emit('sync', { oldBlock, newBlock });
    }
    _setupBlockResetTimeout() {
        // clear any existing timeout
        this._cancelBlockResetTimeout();
        // clear latest block when stale
        this._blockResetTimeout = setTimeout(this._resetCurrentBlock, this._blockResetDuration);
        // nodejs - dont hold process open
        if (this._blockResetTimeout.unref) {
            this._blockResetTimeout.unref();
        }
    }
    _cancelBlockResetTimeout() {
        if (this._blockResetTimeout) {
            clearTimeout(this._blockResetTimeout);
        }
    }
    _resetCurrentBlock() {
        this._currentBlock = null;
    }
    // trigger block polling
    async checkForLatestBlock() {
        await this._updateLatestBlock();
        return await this.getLatestBlock();
    }
    _start() {
        // Intentionally not awaited as this starts the polling via a timeout chain.
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this._updateAndQueue();
    }
    _end() {
        this._clearPollingTimeout();
    }
    async _updateLatestBlock() {
        // fetch + set latest block
        const latestBlock = await this._fetchLatestBlock();
        this._newPotentialLatest(latestBlock);
    }
    async _fetchLatestBlock() {
        const req = {
            jsonrpc: '2.0',
            id: createRandomId(),
            method: 'eth_blockNumber',
            params: [],
        };
        if (this._setSkipCacheFlag) {
            req.skipCache = true;
        }
        log('Making request', req);
        try {
            const result = await this._provider.request(req);
            log('Got result', result);
            return result;
        }
        catch (error) {
            log('Encountered error fetching block', (0, utils_1.getErrorMessage)(error));
            throw error;
        }
    }
    /**
     * The core polling function that runs after each interval.
     * Updates the latest block and then queues the next update.
     */
    async _updateAndQueue() {
        var _a;
        let interval = this._pollingInterval;
        try {
            await this._updateLatestBlock();
        }
        catch (err) {
            const newErr = new Error(`PollingBlockTracker - encountered an error while attempting to update latest block:\n${(_a = err.stack) !== null && _a !== void 0 ? _a : err}`);
            try {
                this.emit('error', newErr);
            }
            catch (emitErr) {
                console.error(newErr);
            }
            interval = this._retryTimeout;
        }
        if (!this._isRunning) {
            return;
        }
        this._clearPollingTimeout();
        const timeoutRef = setTimeout(() => {
            // Intentionally not awaited as this just continues the polling loop.
            // eslint-disable-next-line @typescript-eslint/no-floating-promises
            this._updateAndQueue();
        }, interval);
        if (timeoutRef.unref && !this._keepEventLoopActive) {
            timeoutRef.unref();
        }
        this._pollingTimeout = timeoutRef;
        this.emit('_waitingForNextIteration');
    }
    _clearPollingTimeout() {
        if (this._pollingTimeout) {
            clearTimeout(this._pollingTimeout);
            this._pollingTimeout = undefined;
        }
    }
}
exports.PollingBlockTracker = PollingBlockTracker;
_PollingBlockTracker_internalEventListeners = new WeakMap(), _PollingBlockTracker_pendingLatestBlock = new WeakMap(), _PollingBlockTracker_instances = new WeakSet(), _PollingBlockTracker_addInternalListener = function _PollingBlockTracker_addInternalListener(listener) {
    __classPrivateFieldGet(this, _PollingBlockTracker_internalEventListeners, "f").push(listener);
}, _PollingBlockTracker_removeInternalListener = function _PollingBlockTracker_removeInternalListener(listener) {
    __classPrivateFieldGet(this, _PollingBlockTracker_internalEventListeners, "f").splice(__classPrivateFieldGet(this, _PollingBlockTracker_internalEventListeners, "f").indexOf(listener), 1);
}, _PollingBlockTracker_rejectPendingLatestBlock = function _PollingBlockTracker_rejectPendingLatestBlock(error) {
    var _a;
    (_a = __classPrivateFieldGet(this, _PollingBlockTracker_pendingLatestBlock, "f")) === null || _a === void 0 ? void 0 : _a.reject(error);
    __classPrivateFieldSet(this, _PollingBlockTracker_pendingLatestBlock, undefined, "f");
};
/**
 * Converts a number represented as a string in hexadecimal format into a native
 * number.
 *
 * @param hexInt - The hex string.
 * @returns The number.
 */
function hexToInt(hexInt) {
    return Number.parseInt(hexInt, 16);
}

      };
    };
  }
  }
}, {package:"@metamask/eth-token-tracker>@metamask/eth-block-tracker",file:"node_modules\\@metamask\\eth-token-tracker\\node_modules\\@metamask\\eth-block-tracker\\dist\\PollingBlockTracker.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-token-tracker\\node_modules\\@metamask\\eth-block-tracker\\dist\\SubscribeBlockTracker.js", {"@metamask/safe-event-emitter":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\safe-event-emitter\\dist\\cjs\\index.js","@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs","json-rpc-random-id":"D:\\code\\v\\metamask-extension\\node_modules\\json-rpc-random-id\\index.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-token-tracker%5Cnode_modules%5C@metamask%5Ceth-block-tracker%5Cdist%5CSubscribeBlockTracker.js
      return function (require, module, exports) {
"use strict";
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _SubscribeBlockTracker_instances, _SubscribeBlockTracker_internalEventListeners, _SubscribeBlockTracker_pendingLatestBlock, _SubscribeBlockTracker_addInternalListener, _SubscribeBlockTracker_removeInternalListener, _SubscribeBlockTracker_rejectPendingLatestBlock;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscribeBlockTracker = void 0;
const safe_event_emitter_1 = __importDefault(require("@metamask/safe-event-emitter"));
const utils_1 = require("@metamask/utils");
const json_rpc_random_id_1 = __importDefault(require("json-rpc-random-id"));
const createRandomId = (0, json_rpc_random_id_1.default)();
const sec = 1000;
const blockTrackerEvents = ['sync', 'latest'];
class SubscribeBlockTracker extends safe_event_emitter_1.default {
    constructor(opts = {}) {
        // parse + validate args
        if (!opts.provider) {
            throw new Error('SubscribeBlockTracker - no provider specified.');
        }
        super();
        _SubscribeBlockTracker_instances.add(this);
        _SubscribeBlockTracker_internalEventListeners.set(this, []);
        _SubscribeBlockTracker_pendingLatestBlock.set(this, void 0);
        // config
        this._blockResetDuration = opts.blockResetDuration || 20 * sec;
        this._usePastBlocks = opts.usePastBlocks || false;
        // state
        this._currentBlock = null;
        this._isRunning = false;
        // bind functions for internal use
        this._onNewListener = this._onNewListener.bind(this);
        this._onRemoveListener = this._onRemoveListener.bind(this);
        this._resetCurrentBlock = this._resetCurrentBlock.bind(this);
        // listen for handler changes
        this._setupInternalEvents();
        // config
        this._provider = opts.provider;
        this._subscriptionId = null;
    }
    async destroy() {
        this._cancelBlockResetTimeout();
        await this._maybeEnd();
        super.removeAllListeners();
        __classPrivateFieldGet(this, _SubscribeBlockTracker_instances, "m", _SubscribeBlockTracker_rejectPendingLatestBlock).call(this, new Error('Block tracker destroyed'));
    }
    isRunning() {
        return this._isRunning;
    }
    getCurrentBlock() {
        return this._currentBlock;
    }
    async getLatestBlock() {
        // return if available
        if (this._currentBlock) {
            return this._currentBlock;
        }
        else if (__classPrivateFieldGet(this, _SubscribeBlockTracker_pendingLatestBlock, "f")) {
            return await __classPrivateFieldGet(this, _SubscribeBlockTracker_pendingLatestBlock, "f").promise;
        }
        const { resolve, reject, promise } = (0, utils_1.createDeferredPromise)({
            suppressUnhandledRejection: true,
        });
        __classPrivateFieldSet(this, _SubscribeBlockTracker_pendingLatestBlock, { reject, promise }, "f");
        // wait for a new latest block
        const onLatestBlock = (value) => {
            __classPrivateFieldGet(this, _SubscribeBlockTracker_instances, "m", _SubscribeBlockTracker_removeInternalListener).call(this, onLatestBlock);
            resolve(value);
            __classPrivateFieldSet(this, _SubscribeBlockTracker_pendingLatestBlock, undefined, "f");
        };
        __classPrivateFieldGet(this, _SubscribeBlockTracker_instances, "m", _SubscribeBlockTracker_addInternalListener).call(this, onLatestBlock);
        this.once('latest', onLatestBlock);
        return await promise;
    }
    // dont allow module consumer to remove our internal event listeners
    removeAllListeners(eventName) {
        // perform default behavior, preserve fn arity
        if (eventName) {
            super.removeAllListeners(eventName);
        }
        else {
            super.removeAllListeners();
        }
        // re-add internal events
        this._setupInternalEvents();
        // trigger stop check just in case
        this._onRemoveListener();
        return this;
    }
    _setupInternalEvents() {
        // first remove listeners for idempotence
        this.removeListener('newListener', this._onNewListener);
        this.removeListener('removeListener', this._onRemoveListener);
        // then add them
        this.on('newListener', this._onNewListener);
        this.on('removeListener', this._onRemoveListener);
    }
    _onNewListener(eventName) {
        // `newListener` is called *before* the listener is added
        if (blockTrackerEvents.includes(eventName)) {
            // TODO: Handle dangling promise
            this._maybeStart();
        }
    }
    _onRemoveListener() {
        // `removeListener` is called *after* the listener is removed
        if (this._getBlockTrackerEventCount() > 0) {
            return;
        }
        this._maybeEnd();
    }
    async _maybeStart() {
        if (this._isRunning) {
            return;
        }
        this._isRunning = true;
        // cancel setting latest block to stale
        this._cancelBlockResetTimeout();
        await this._start();
        this.emit('_started');
    }
    async _maybeEnd() {
        if (!this._isRunning) {
            return;
        }
        this._isRunning = false;
        this._setupBlockResetTimeout();
        await this._end();
        this.emit('_ended');
    }
    _getBlockTrackerEventCount() {
        return (blockTrackerEvents
            .map((eventName) => this.listeners(eventName))
            .flat()
            // internal listeners are not included in the count
            .filter((listener) => __classPrivateFieldGet(this, _SubscribeBlockTracker_internalEventListeners, "f").every((internalListener) => !Object.is(internalListener, listener))).length);
    }
    _shouldUseNewBlock(newBlock) {
        const currentBlock = this._currentBlock;
        if (!currentBlock) {
            return true;
        }
        const newBlockInt = hexToInt(newBlock);
        const currentBlockInt = hexToInt(currentBlock);
        return ((this._usePastBlocks && newBlockInt < currentBlockInt) ||
            newBlockInt > currentBlockInt);
    }
    _newPotentialLatest(newBlock) {
        if (!this._shouldUseNewBlock(newBlock)) {
            return;
        }
        this._setCurrentBlock(newBlock);
    }
    _setCurrentBlock(newBlock) {
        const oldBlock = this._currentBlock;
        this._currentBlock = newBlock;
        this.emit('latest', newBlock);
        this.emit('sync', { oldBlock, newBlock });
    }
    _setupBlockResetTimeout() {
        // clear any existing timeout
        this._cancelBlockResetTimeout();
        // clear latest block when stale
        this._blockResetTimeout = setTimeout(this._resetCurrentBlock, this._blockResetDuration);
        // nodejs - dont hold process open
        if (this._blockResetTimeout.unref) {
            this._blockResetTimeout.unref();
        }
    }
    _cancelBlockResetTimeout() {
        if (this._blockResetTimeout) {
            clearTimeout(this._blockResetTimeout);
        }
    }
    _resetCurrentBlock() {
        this._currentBlock = null;
    }
    async checkForLatestBlock() {
        return await this.getLatestBlock();
    }
    async _start() {
        if (this._subscriptionId === undefined || this._subscriptionId === null) {
            try {
                const blockNumber = (await this._call('eth_blockNumber'));
                this._subscriptionId = (await this._call('eth_subscribe', 'newHeads'));
                this._provider.on('data', this._handleSubData.bind(this));
                this._newPotentialLatest(blockNumber);
            }
            catch (e) {
                this.emit('error', e);
                __classPrivateFieldGet(this, _SubscribeBlockTracker_instances, "m", _SubscribeBlockTracker_rejectPendingLatestBlock).call(this, e);
            }
        }
    }
    async _end() {
        if (this._subscriptionId !== null && this._subscriptionId !== undefined) {
            try {
                await this._call('eth_unsubscribe', this._subscriptionId);
                this._subscriptionId = null;
            }
            catch (e) {
                this.emit('error', e);
                __classPrivateFieldGet(this, _SubscribeBlockTracker_instances, "m", _SubscribeBlockTracker_rejectPendingLatestBlock).call(this, e);
            }
        }
    }
    async _call(method, ...params) {
        return this._provider.request({
            id: createRandomId(),
            method,
            params,
            jsonrpc: '2.0',
        });
    }
    _handleSubData(_, response) {
        var _a;
        if (response.method === 'eth_subscription' &&
            ((_a = response.params) === null || _a === void 0 ? void 0 : _a.subscription) === this._subscriptionId) {
            this._newPotentialLatest(response.params.result.number);
        }
    }
}
exports.SubscribeBlockTracker = SubscribeBlockTracker;
_SubscribeBlockTracker_internalEventListeners = new WeakMap(), _SubscribeBlockTracker_pendingLatestBlock = new WeakMap(), _SubscribeBlockTracker_instances = new WeakSet(), _SubscribeBlockTracker_addInternalListener = function _SubscribeBlockTracker_addInternalListener(listener) {
    __classPrivateFieldGet(this, _SubscribeBlockTracker_internalEventListeners, "f").push(listener);
}, _SubscribeBlockTracker_removeInternalListener = function _SubscribeBlockTracker_removeInternalListener(listener) {
    __classPrivateFieldGet(this, _SubscribeBlockTracker_internalEventListeners, "f").splice(__classPrivateFieldGet(this, _SubscribeBlockTracker_internalEventListeners, "f").indexOf(listener), 1);
}, _SubscribeBlockTracker_rejectPendingLatestBlock = function _SubscribeBlockTracker_rejectPendingLatestBlock(error) {
    var _a;
    (_a = __classPrivateFieldGet(this, _SubscribeBlockTracker_pendingLatestBlock, "f")) === null || _a === void 0 ? void 0 : _a.reject(error);
    __classPrivateFieldSet(this, _SubscribeBlockTracker_pendingLatestBlock, undefined, "f");
};
/**
 * Converts a number represented as a string in hexadecimal format into a native
 * number.
 *
 * @param hexInt - The hex string.
 * @returns The number.
 */
function hexToInt(hexInt) {
    return Number.parseInt(hexInt, 16);
}

      };
    };
  }
  }
}, {package:"@metamask/eth-token-tracker>@metamask/eth-block-tracker",file:"node_modules\\@metamask\\eth-token-tracker\\node_modules\\@metamask\\eth-block-tracker\\dist\\SubscribeBlockTracker.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-token-tracker\\node_modules\\@metamask\\eth-block-tracker\\dist\\index.js", {"./BlockTracker":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-token-tracker\\node_modules\\@metamask\\eth-block-tracker\\dist\\BlockTracker.js","./PollingBlockTracker":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-token-tracker\\node_modules\\@metamask\\eth-block-tracker\\dist\\PollingBlockTracker.js","./SubscribeBlockTracker":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-token-tracker\\node_modules\\@metamask\\eth-block-tracker\\dist\\SubscribeBlockTracker.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-token-tracker%5Cnode_modules%5C@metamask%5Ceth-block-tracker%5Cdist%5Cindex.js
      return function (require, module, exports) {
"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(require("./PollingBlockTracker"), exports);
__exportStar(require("./SubscribeBlockTracker"), exports);
__exportStar(require("./BlockTracker"), exports);

      };
    };
  }
  }
}, {package:"@metamask/eth-token-tracker>@metamask/eth-block-tracker",file:"node_modules\\@metamask\\eth-token-tracker\\node_modules\\@metamask\\eth-block-tracker\\dist\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\eth-token-tracker\\node_modules\\@metamask\\eth-block-tracker\\dist\\logging-utils.js", {"@metamask/utils":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\utils\\dist\\index.cjs"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Ceth-token-tracker%5Cnode_modules%5C@metamask%5Ceth-block-tracker%5Cdist%5Clogging-utils.js
      return function (require, module, exports) {
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createModuleLogger = exports.projectLogger = void 0;
const utils_1 = require("@metamask/utils");
Object.defineProperty(exports, "createModuleLogger", { enumerable: true, get: function () { return utils_1.createModuleLogger; } });
exports.projectLogger = (0, utils_1.createProjectLogger)('eth-block-tracker');

      };
    };
  }
  }
}, {package:"@metamask/eth-token-tracker>@metamask/eth-block-tracker",file:"node_modules\\@metamask\\eth-token-tracker\\node_modules\\@metamask\\eth-block-tracker\\dist\\logging-utils.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\logo\\data\\fox.json", {}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Clogo%5Cdata%5Cfox.json
      return function (require, module, exports) {
module.exports={
  "positions": [
    [111.024597, 52.604599, 46.225899],
    [114.025002, 87.673302, 58.9818],
    [66.192001, 80.898003, 55.394299],
    [72.113297, 35.491798, 30.871401],
    [97.804497, 116.560997, 73.978798],
    [16.7623, 58.010899, 58.078201],
    [52.608898, 30.3641, 42.556099],
    [106.881401, 31.945499, 46.9133],
    [113.484596, 38.6049, 49.121498],
    [108.6633, 43.2332, 46.315399],
    [101.216599, 15.9822, 46.308201],
    [16.6605, -16.2883, 93.618698],
    [40.775002, -10.2288, 85.276398],
    [23.926901, -2.5103, 86.736504],
    [11.1691, -7.0037, 99.377602],
    [9.5692, -34.393902, 141.671997],
    [12.596, 7.1655, 88.740997],
    [61.180901, 8.8142, 76.996803],
    [39.719501, -28.927099, 88.963799],
    [13.7962, -68.575699, 132.057007],
    [15.2674, -62.32, 129.688004],
    [14.8446, -52.6096, 140.113007],
    [12.8917, -49.771599, 144.740997],
    [35.604198, -71.758003, 81.063904],
    [47.462502, -68.606102, 63.369701],
    [38.2486, -64.730202, 38.909901],
    [-12.8917, -49.771599, 144.740997],
    [-13.7962, -68.575699, 132.057007],
    [17.802099, -71.758003, 81.063904],
    [19.1243, -69.0168, 49.420101],
    [38.2486, -66.275597, 17.776199],
    [12.8928, -36.703499, 141.671997],
    [109.283997, -93.589897, 27.824301],
    [122.117996, -36.8894, 35.025002],
    [67.7668, -30.197001, 78.417801],
    [33.180698, 101.851997, 25.3186],
    [9.4063, -35.589802, 150.722],
    [-9.5692, -34.393902, 141.671997],
    [-9.4063, -35.589802, 150.722],
    [11.4565, -37.899399, 150.722],
    [-12.596, 7.1655, 88.740997],
    [-11.1691, -7.0037, 99.377602],
    [70.236504, 62.836201, -3.9475],
    [47.263401, 54.293999, -27.414801],
    [28.7302, 91.731102, -24.972601],
    [69.167603, 6.5862, -12.7757],
    [28.7302, 49.1003, -48.3596],
    [31.903, 5.692, -47.821999],
    [35.075802, -34.432899, -16.280899],
    [115.284103, 48.681499, 48.684101],
    [110.842796, 28.4821, 49.176201],
    [-19.1243, -69.0168, 49.420101],
    [-38.2486, -66.275597, 17.776199],
    [-111.024597, 52.604599, 46.225899],
    [-72.113297, 35.491798, 30.871401],
    [-66.192001, 80.898003, 55.394299],
    [-114.025002, 87.673302, 58.9818],
    [-97.804497, 116.560997, 73.978798],
    [-52.608898, 30.3641, 42.556099],
    [-16.7623, 58.010899, 58.078201],
    [-106.881401, 31.945499, 46.9133],
    [-108.6633, 43.2332, 46.315399],
    [-113.484596, 38.6049, 49.121498],
    [-101.216599, 15.9822, 46.308201],
    [-16.6605, -16.2883, 93.618698],
    [-23.926901, -2.5103, 86.736504],
    [-40.775002, -10.2288, 85.276398],
    [-61.180901, 8.8142, 76.996803],
    [-39.719501, -28.927099, 88.963799],
    [-14.8446, -52.6096, 140.113007],
    [-15.2674, -62.32, 129.688004],
    [-47.462502, -68.606102, 63.369701],
    [-35.604198, -71.758003, 81.063904],
    [-38.2486, -64.730202, 38.909901],
    [-17.802099, -71.758003, 81.063904],
    [-12.8928, -36.703499, 141.671997],
    [-67.7668, -30.197001, 78.417801],
    [-122.117996, -36.8894, 35.025002],
    [-109.283997, -93.589897, 27.824301],
    [-33.180698, 101.851997, 25.3186],
    [-11.4565, -37.899399, 150.722],
    [-70.236504, 62.836201, -3.9475],
    [-28.7302, 91.731102, -24.972601],
    [-47.263401, 54.293999, -27.414801],
    [-69.167603, 6.5862, -12.7757],
    [-28.7302, 49.1003, -48.3596],
    [-31.903, 5.692, -47.821999],
    [-35.075802, -34.432899, -16.280899],
    [-115.284103, 48.681499, 48.684101],
    [-110.842796, 28.4821, 49.176201]
  ],
  "chunks": [
    {
      "color": [119, 57, 0],
      "faces": [
        [0, 1, 2],
        [2, 3, 0],
        [4, 5, 2],
        [6, 3, 2],
        [2, 5, 6],
        [7, 8, 9],
        [10, 3, 6],
        [10, 50, 7],
        [7, 3, 10],
        [7, 9, 3],
        [49, 0, 9],
        [3, 9, 0],
        [53, 54, 55],
        [55, 56, 53],
        [57, 56, 55],
        [58, 59, 55],
        [55, 54, 58],
        [60, 61, 62],
        [63, 58, 54],
        [63, 60, 89],
        [60, 63, 54],
        [60, 54, 61],
        [88, 61, 53],
        [54, 53, 61],
        [2, 1, 4],
        [55, 59, 57]
      ],
      "materialName": "fox:ears"
    },
    {
      "color": [36, 51, 67],
      "faces": [
        [11, 12, 13],
        [64, 65, 66]
      ],
      "materialName": "fox:eyes"
    },
    {
      "color": [228, 116, 36],
      "faces": [
        [14, 15, 11],
        [11, 16, 14],
        [17, 12, 18],
        [41, 64, 37],
        [67, 68, 66]
      ],
      "materialName": "fox:orange_shade_light"
    },
    {
      "color": [192, 172, 157],
      "faces": [
        [19, 20, 21],
        [21, 22, 19],
        [20, 19, 23],
        [23, 24, 20],
        [23, 25, 24],
        [19, 22, 26],
        [26, 27, 19],
        [23, 28, 29],
        [23, 29, 30],
        [25, 23, 30],
        [29, 51, 52],
        [52, 30, 29],
        [27, 26, 69],
        [69, 70, 27],
        [70, 71, 72],
        [72, 27, 70],
        [72, 71, 73],
        [51, 74, 72],
        [52, 51, 72],
        [73, 52, 72],
        [19, 27, 74],
        [74, 28, 19],
        [51, 29, 28],
        [28, 74, 51],
        [74, 27, 72],
        [28, 23, 19]
      ],
      "materialName": "fox:white_underside"
    },
    {
      "color": [214, 194, 178],
      "faces": [
        [21, 20, 24],
        [24, 31, 21],
        [69, 71, 70],
        [71, 69, 75]
      ],
      "materialName": "fox:white_side"
    },
    {
      "color": [228, 119, 25],
      "faces": [
        [31, 24, 18],
        [6, 5, 16],
        [16, 17, 6],
        [24, 32, 33],
        [33, 34, 24],
        [5, 4, 35],
        [75, 68, 71],
        [58, 67, 40],
        [40, 59, 58],
        [71, 76, 77],
        [77, 78, 71]
      ],
      "materialName": "fox:orange_mid_1"
    },
    {
      "color": [205, 98, 0],
      "faces": [
        [24, 34, 18],
        [16, 13, 12],
        [12, 17, 16],
        [13, 16, 11],
        [71, 68, 76],
        [40, 67, 66],
        [66, 65, 40],
        [65, 64, 40]
      ],
      "materialName": "fox:orange_shade_dark"
    },
    {
      "color": [0, 0, 0],
      "faces": [
        [36, 15, 37],
        [37, 38, 36],
        [31, 39, 22],
        [22, 21, 31],
        [31, 15, 36],
        [36, 39, 31],
        [75, 69, 26],
        [26, 80, 75],
        [75, 80, 38],
        [38, 37, 75],
        [38, 80, 39],
        [39, 36, 38],
        [39, 80, 26],
        [26, 22, 39]
      ],
      "materialName": "fox:nose"
    },
    {
      "color": [247, 132, 25],
      "faces": [
        [17, 33, 10],
        [17, 18, 34],
        [34, 33, 17],
        [10, 6, 17],
        [11, 15, 31],
        [31, 18, 11],
        [18, 12, 11],
        [14, 16, 40],
        [40, 41, 14],
        [59, 5, 35],
        [35, 79, 59],
        [67, 63, 77],
        [67, 77, 76],
        [76, 68, 67],
        [63, 67, 58],
        [64, 68, 75],
        [75, 37, 64],
        [68, 64, 66],
        [14, 41, 37],
        [37, 15, 14],
        [5, 59, 40],
        [40, 16, 5]
      ],
      "materialName": "fox:orange_light"
    },
    {
      "color": [225, 119, 25],
      "faces": [
        [35, 4, 42],
        [4, 1, 42],
        [42, 43, 44],
        [44, 35, 42],
        [45, 43, 42],
        [42, 10, 45],
        [30, 32, 24],
        [24, 25, 30],
        [30, 33, 32],
        [33, 30, 10],
        [44, 43, 46],
        [43, 45, 47],
        [47, 46, 43],
        [48, 47, 45],
        [45, 30, 48],
        [30, 45, 10],
        [49, 42, 0],
        [8, 7, 42],
        [50, 42, 7],
        [50, 10, 42],
        [1, 0, 42],
        [42, 9, 8],
        [42, 49, 9],
        [64, 41, 40],
        [57, 59, 79],
        [79, 81, 57],
        [57, 81, 56],
        [82, 79, 35],
        [35, 44, 82],
        [81, 79, 82],
        [82, 83, 81],
        [84, 63, 81],
        [81, 83, 84],
        [44, 46, 85],
        [85, 82, 44],
        [52, 73, 71],
        [71, 78, 52],
        [52, 78, 77],
        [77, 63, 52],
        [82, 85, 83],
        [83, 85, 86],
        [86, 84, 83],
        [87, 52, 84],
        [84, 86, 87],
        [52, 63, 84],
        [88, 53, 81],
        [62, 81, 60],
        [89, 60, 81],
        [89, 81, 63],
        [56, 81, 53],
        [81, 62, 61],
        [81, 61, 88],
        [48, 87, 86],
        [86, 47, 48],
        [47, 86, 85],
        [85, 46, 47],
        [48, 30, 52],
        [52, 87, 48]
      ],
      "materialName": "fox:orange_mid_2"
    }
  ]
}

      };
    };
  }
  }
}, {package:"@metamask/logo",file:"node_modules\\@metamask\\logo\\data\\fox.json",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\logo\\src\\index.js", {"../data/fox.json":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\logo\\data\\fox.json","./util":"D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\logo\\src\\util.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Clogo%5Csrc%5Cindex.js
      return function (require, module, exports) {
const foxJson = require('../data/fox.json');
const {
  calculateSizingOptions,
  createLogoViewer,
  defaultCameraDistance,
  loadModelFromJson,
  createModelRenderer,
  createNode,
  setAttribute,
  setGradientDefinitions,
  setMaskDefinitions,
} = require('./util');

module.exports = createLogo;

/**
 * Create an animated SVG logo.
 *
 * The size defaults to 25% of the screen size, or 400x400px if `pxNotRatio` is true.
 *
 * @param {object} [options] - Options.
 * @param {ModelJson} [options.meshJson] - The 3D model.
 * @param {boolean} [options.followMouse] - The model looks at the mouse.
 * @param {boolean} [options.followMotion] - The model moves in response to device movement.
 * @param {boolean} [options.slowDrift] - The model slowly rotates.
 * @param {boolean} [options.lazyRender] - Determines whether to render each animation frame, or
 * just when requested (e.g. by mouse/device movement).
 * @param {number} [options.cameraDistance] - The distance between the model and the camera.
 * @param {number} [options.verticalFieldOfView] - Vertical field of view (in radians).
 * @param {number} [options.near] - Near bound of the frustrum.
 * @param {number} [options.far] - Far bound of the frustrum.
 * @param {number} [options.width] - Width, either in pixels or as a ratio of window width.
 * @param {number} [options.height] - Height, either in pixels or as a ratio of window height.
 * @param {number} [options.minWidth] - Minimum width (in pixels), used as a lower bound if the
 * width is specified as a ratio.
 * @param {boolean} [options.pxNotRatio] - True indicates the width and height are in pixels, false
 * indicates they are a ratio.
 * @returns {LogoViewer} An animated SVG logo.
 */
function createLogo({
  meshJson = foxJson,
  // animation options
  followMouse = false,
  followMotion = false,
  slowDrift = false,
  // render options
  lazyRender = true,
  cameraDistance = defaultCameraDistance,
  verticalFieldOfView = Math.PI / 4.0,
  near = 100,
  far = 1000,
  // size options
  width: specifiedWidth,
  height: specifiedHeight,
  minWidth,
  pxNotRatio = false,
} = {}) {
  const { height, width } = calculateSizingOptions({
    width: specifiedWidth,
    height: specifiedHeight,
    minWidth,
    pxNotRatio,
  });

  const container = createNode('svg');
  setAttribute(container, 'width', `${width}px`);
  setAttribute(container, 'height', `${height}px`);
  document.body.appendChild(container);

  setGradientDefinitions(container, meshJson.gradients);
  setMaskDefinitions({ container, masks: meshJson.masks, height, width });

  const modelObj = loadModelFromJson(meshJson);
  const renderFox = createModelRenderer(container, cameraDistance, modelObj, {
    verticalFieldOfView,
    near,
    far,
  });
  const renderScene = (lookCurrent, _slowDrift) => {
    const rect = container.getBoundingClientRect();
    renderFox(rect, lookCurrent, _slowDrift);
  };

  return createLogoViewer(container, renderScene, {
    cameraDistance,
    followMouse,
    followMotion,
    lazyRender,
    slowDrift,
  });
}

      };
    };
  }
  }
}, {package:"@metamask/logo",file:"node_modules\\@metamask\\logo\\src\\index.js",}],
["D:\\code\\v\\metamask-extension\\node_modules\\@metamask\\logo\\src\\util.js", {"gl-mat4/invert":"D:\\code\\v\\metamask-extension\\node_modules\\gl-mat4\\invert.js","gl-mat4/lookAt":"D:\\code\\v\\metamask-extension\\node_modules\\gl-mat4\\lookAt.js","gl-mat4/multiply":"D:\\code\\v\\metamask-extension\\node_modules\\gl-mat4\\multiply.js","gl-mat4/perspective":"D:\\code\\v\\metamask-extension\\node_modules\\gl-mat4\\perspective.js","gl-mat4/rotate":"D:\\code\\v\\metamask-extension\\node_modules\\gl-mat4\\rotate.js","gl-vec3/transformMat4":"D:\\code\\v\\metamask-extension\\node_modules\\gl-vec3\\transformMat4.js"}, function(){
  with (this.scopeTerminator) {
  with (this.globalThis) {
    return function() {
      'use strict';
      // source: D:%5Ccode%5Cv%5Cmetamask-extension%5Cnode_modules%5C@metamask%5Clogo%5Csrc%5Cutil.js
      return function (require, module, exports) {
const perspective = require('gl-mat4/perspective');
const multiply = require('gl-mat4/multiply');
const lookAt = require('gl-mat4/lookAt');
const invert = require('gl-mat4/invert');
const rotate = require('gl-mat4/rotate');
const transform = require('gl-vec3/transformMat4');

const SVG_NS = 'http://www.w3.org/2000/svg';

const defaultCameraDistance = 400;

// Taken from https://github.com/yuzhe-han/ParentNode-replaceChildren
// This is to support browsers that do not yet support `replaceChildren`
const replaceChildrenPonyfill = function (...addNodes) {
  while (this.lastChild) {
    this.removeChild(this.lastChild);
  }

  if (addNodes.length > 0) {
    this.append(...addNodes);
  }
};

module.exports = {
  calculateSizingOptions,
  createLogoViewer,
  createModelRenderer,
  defaultCameraDistance,
  loadModelFromJson,
  positionsFromModel,
  createPolygonsFromModelJson,
  createStandardModelPolygon,
  createMatrixComputer,
  compareZ,
  createFaceUpdater,
  createNode,
  setAttribute,
  setGradientDefinitions,
  setMaskDefinitions,
  svgElementToSvgImageContent,
  Polygon,
};

/**
 * A distance measurement used for SVG attributes. A length is specified as a number followed by a
 * unit identifier.
 *
 * See {@link https://developer.mozilla.org/en-US/docs/Web/SVG/Content_type#length} for further
 * information.
 *
 * @typedef {`${number}${'em' | 'ex' | 'px' | 'in' | 'cm' | 'mm' | 'pt' | 'pc' | '%'}`} SvgLength
 */

/**
 * A definition for a `<stop>` SVG element, which defines a color and the position for that color
 * on a gradient. This element is always a child of either a `<linearGradient>` or
 * `<radialGradient>` element.
 *
 * See {@link https://developer.mozilla.org/en-US/docs/Web/SVG/Element/stop} for more information
 * about the `<stop>` element.
 *
 * @typedef {object} StopDefinition
 * @property {number | `${number}%`} [offset] - The location of the gradient stop along the
 * gradient vector.
 * @property {string} [stop-color] - The color of the gradient stop. See {@link https://developer.mozilla.org/en-US/docs/Web/SVG/Element/stop}.
 * @property {number} [stop-opacity] - The opacity of the gradient stop. See {@link https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stop-opacity}.
 */

/**
 * A definition for a `<linearGradient>` SVG element. This definition includes all supported
 * `<linearGradient>` attributes, and it includes a `stops` property which is an array of
 * definitions for each `<stop>` child node.
 *
 * See {@link https://developer.mozilla.org/en-US/docs/Web/SVG/Element/linearGradient} for more
 * information about the `<linearGradient>` element.
 *
 * @typedef {object} LinearGradientDefinition
 * @property {string} [gradientTransform] - A transform from the gradient coordinate system to the
 * target coordinate system. See {@link https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/gradientTransform}.
 * @property {'userSpaceOnUse' | 'objectBoundingBox'} [gradientUnits] - The coordinate system used.
 * for the coordinate attributes. See {@link https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/gradientUnits}.
 * @property {'pad' | 'reflect' | 'repeat'} [spreadMethod] - The method used to fill a shape beyond
 * the defined edges of a gradient. See {@link https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/spreadMethod}.
 * @property {StopDefinition[]} [stops] - The colors of the gradient, and the position of each
 * color along the gradient vector.
 * @property {'linear'} type - The type of the gradient.
 * @property {SvgLength} [x1] - The x coordinate of the starting point of the vector gradient.
 * @property {SvgLength} [x2] - The x coordinate of the ending point of the vector gradient.
 * @property {SvgLength} [y1] - The y coordinate of the starting point of the vector gradient.
 * @property {SvgLength} [y2] - The y coordinate of the ending point of the vector gradient.
 */

/**
 * A definition for a `<radialGradient>` SVG element. This definition includes all supported
 * `<radialGradient>` attributes, and it includes a `stops` property which is an array of
 * definitions for each `<stop>` child node.
 *
 * See {@link https://developer.mozilla.org/en-US/docs/Web/SVG/Element/radialGradient} for more
 * information about the `<radialGradient>` element.
 *
 * @typedef {object} RadialGradientDefinition
 * @property {SvgLength} [cx] - The x coordinate of the end circle of the radial gradiant.
 * @property {SvgLength} [cy] - The y coordinate of the end circle of the radial gradient.
 * @property {SvgLength} [fr] - The radius of the start circle of the radial gradient.
 * @property {SvgLength} [fx] - The x coordinate of the start circle of the radial gradient.
 * @property {SvgLength} [fy] - The y coordinate of the start circle of the radial gradient.
 * @property {string} [gradientTransform] - A transform from the gradient coordinate system to the
 * target coordinate system. See {@link https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/gradientTransform}.
 * @property {'userSpaceOnUse' | 'objectBoundingBox'} [gradientUnits] - The coordinate system used
 * for the coordinate attributes. See {@link https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/gradientUnits}.
 * @property {SvgLength} [r] - The radius of the end circle of the radial gradient.
 * @property {'pad' | 'reflect' | 'repeat'} [spreadMethod] - The method used to fill a shape beyond
 * the defined edges of a gradient. See {@link https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/spreadMethod}.
 * @property {StopDefinition[]} [stops] - The colors of the gradient, and the position of each
 * color along the gradient vector.
 * @property {'radial'} type - The type of the gradient.
 */

/**
 * A color, specified as three numbers (RGB) where each number is between 0-255 (inclusive).
 *
 * @typedef {[number, number, number]} RgbColor
 */

/**
 * Three vertex indices, representing the vertices of a single three-sided polygon. Each vertex
 * index corresponds to the index of the vertex in the `positions` array of {@link ModelJson}.
 *
 * @typedef {[number, number, number]} PolygonVertices
 */

/**
 * A JSON specification for a set of polygons with the same color/texture.
 *
 * @typedef {object} ChunkJson
 * @property {RgbColor} color - The color of the current chunk, specified as RGB.
 * values (from 0-255 inclusive).
 * @property {PolygonVertices[]} faces - A collection of polygon vertices.
 * @property {string} [mask] - The ID of the mask to apply to this chunk.
 */

/**
 * The properties of a single SVG mask.
 *
 * @typedef MaskDefinition
 * @property {string} color - The color or gradient to apply to the mask.
 */

/**
 * A JSON specification for the logo model.
 *
 * @typedef {object} ModelJson
 * @property {[number, number, number][]} positions - A list of vertex positions. Each entry includes
 * an X, Y, and X coordinate for a single vertex.
 * @property {ChunkJson[]} chunks - Sets of polygons with the same color/texture.
 * @property {Record<string, MaskDefinition>} [masks] - Mask definitions.
 */

/**
 * The width and height of the SVG container.
 *
 * @typedef {object} SvgSize
 * @property {number} width - The width of the SVG container.
 * @property {number} height - The height of the SVG container.
 */

/**
 * This object contains a reference to the SVG element where the logo is rendered, and it includes
 * a set of functions for controlling the logo animation.
 *
 * @typedef {object} LogoViewer
 * @property {SVGSVGElement} container - The SVG element containing the animation.
 * @property {(target: [number, number]) => void} lookAt - Update the model to look at the given
 * target.
 * @property {(followMouse: boolean) => void} setFollowMouse - Set the `followMouse` option.
 * @property {(followMotion: boolean) => void} setFollowMotion - Set the `followMotion` option.
 * @property {() => void} startAnimation - Start the animation.
 * @property {() => void} stopAnimation - Stop the animation.
 * @property {(target: [number, number]) => void} lookAtAndRender - Update the model to look at the
 * given target, and manually trigger the animation to be rendered.
 * @property {() => void} renderCurrentScene - Render the animation manually. This can be useful if
 * `lazyRender` is enabled, and some model change happens outside of mouse/device movement.
 */

/**
 * Create an animated logo and return a set of functions for controlling the animation.
 *
 * @param {SVGSVGElement} container - The SVG element to render within.
 * @param {(lookCurrent: [number, number], slowDrift: boolean) => void} renderScene - A function
 * that renders the model.
 * @param {object} options - Options.
 * @param {boolean} [options.followMouse] - The model looks at the mouse.
 * @param {boolean} [options.followMotion] - The model moves in response to device movement.
 * @param {boolean} [options.slowDrift] - The model slowly rotates.
 * @param {boolean} [options.lazyRender] - Determines whether to render each animation frame, or
 * just when requested (e.g. by mouse/device movement).
 * @returns {LogoViewer} A collection of functions for controlling the animation.
 */
function createLogoViewer(
  container,
  renderScene,
  {
    followMouse = false,
    followMotion = false,
    slowDrift = false,
    lazyRender = true,
  } = {},
) {
  let shouldRender = true;
  const mouse = {
    x: 0,
    y: 0,
  };
  const lookCurrent = [0, 0];
  const lookRate = 0.3;

  // closes over scene state
  const renderCurrentScene = () => {
    updateLookCurrent();
    renderScene(lookCurrent, slowDrift);
  };

  function setLookAtTarget(target) {
    const bounds = container.getBoundingClientRect();
    mouse.x = 1.0 - (2.0 * (target.x - bounds.left)) / bounds.width;
    mouse.y = 1.0 - (2.0 * (target.y - bounds.top)) / bounds.height;
  }

  function stopAnimation() {
    shouldRender = false;
  }

  function startAnimation() {
    shouldRender = true;
  }

  function setFollowMouse(state) {
    // eslint-disable-next-line no-param-reassign
    followMouse = state;
  }

  function setFollowMotion(state) {
    // eslint-disable-next-line no-param-reassign
    followMotion = state;
  }

  window.addEventListener('mousemove', function (ev) {
    if (!shouldRender) {
      startAnimation();
    }

    if (followMouse) {
      setLookAtTarget({
        x: ev.clientX,
        y: ev.clientY,
      });
      renderCurrentScene();
    }
  });

  window.addEventListener('deviceorientation', function (event) {
    if (!shouldRender) {
      startAnimation();
    }

    if (followMotion) {
      // gamma: left to right
      const leftToRight = event.gamma;
      // beta: front back motion
      const frontToBack = event.beta;
      // x offset: needed to correct the intial position
      const xOffset = 200;
      // y offset: needed to correct the intial position
      const yOffset = -300;
      // acceleration
      const acceleration = 10;

      setLookAtTarget({
        x: xOffset + leftToRight * acceleration,
        y: yOffset + frontToBack * acceleration,
      });
      renderCurrentScene();
    }
  });

  function lookAtAndRender(target) {
    // update look target
    setLookAtTarget(target);
    // this should prolly just call updateLookCurrent or set lookCurrent values to eaxactly lookTarget
    // but im not really sure why its different, so im leaving it alone
    lookCurrent[0] = mouse.x;
    lookCurrent[1] = mouse.y + 0.085 / lookRate;
    renderCurrentScene();
  }

  function renderLoop() {
    if (!shouldRender) {
      return;
    }
    window.requestAnimationFrame(renderLoop);
    renderCurrentScene();
  }

  function updateLookCurrent() {
    const li = 1.0 - lookRate;
    lookCurrent[0] = li * lookCurrent[0] + lookRate * mouse.x;
    lookCurrent[1] = li * lookCurrent[1] + lookRate * mouse.y + 0.085;
  }

  if (lazyRender) {
    renderCurrentScene();
  } else {
    renderLoop();
  }

  return {
    container,
    lookAt: setLookAtTarget,
    setFollowMouse,
    setFollowMotion,
    stopAnimation,
    startAnimation,
    lookAtAndRender,
    renderCurrentScene,
  };
}

/**
 * An object representing the model.
 *
 * @typedef {object} ModelObject
 * @property {(M: Float32Array) => void} updatePositions - A function that updates model vertex
 * positions with the given set of transformations.
 * @property {Float32Array} positions - All vertex position coordinates. Each vertex position is
 * stored in this array as adjacent X, Y, Z coordinates.
 * @property {Float32Array} transformed - Transformations to be applied to each vertex position
 * coordinate on render.
 * @property {Polygon[]} polygons - A list of all model polygons.
 * @property {Polygon[][]} polygonsByChunk - A list of all model polygons, sorted by chunk.
 */

/**
 * Load the model object from the model JSON specification.
 *
 * @param {ModelJson} modelJson - The model JSON specification.
 * @param {typeof createStandardModelPolygon} [createSvgPolygon] - A function for creating an SVG
 * polygon node.
 * @returns {ModelObject} The model object.
 */
function loadModelFromJson(
  modelJson,
  createSvgPolygon = createStandardModelPolygon,
) {
  const vertCount = modelJson.positions.length;
  const positions = new Float32Array(3 * vertCount);
  const transformed = new Float32Array(3 * vertCount);
  const { polygons, polygonsByChunk } = createPolygonsFromModelJson(
    modelJson,
    createSvgPolygon,
  );
  positionsFromModel(positions, modelJson);
  const updatePositions = createPositionUpdater(
    positions,
    transformed,
    vertCount,
  );
  const modelObj = {
    updatePositions,
    positions,
    transformed,
    polygons,
    polygonsByChunk,
  };
  return modelObj;
}

/**
 * Create a model renderer.
 *
 * @param {SVGSVGElement} container - The SVG element to render within.
 * @param {number} cameraDistance - The distance between the model and the camera.
 * @param {ModelObject} modelObj - The model to render.
 * @param {object} options - Options.
 * @param {number} options.verticalFieldOfView - Vertical field of view (in radians).
 * @param {number} options.near - Near bound of the frustrum.
 * @param {number} options.far - Far bound of the frustrum.
 * @returns {(rect: SvgSize, lookPos: [number, number], slowDrift: boolean) => void}
 * A function for rendering the model.
 */
function createModelRenderer(
  container,
  cameraDistance,
  modelObj,
  { verticalFieldOfView, near, far },
) {
  const { updatePositions, transformed, polygons } = modelObj;

  for (const polygon of polygons) {
    container.appendChild(polygon.svg);
  }

  const computeMatrix = createMatrixComputer(cameraDistance, {
    verticalFieldOfView,
    near,
    far,
  });
  const updateFaces = createFaceUpdater(container, polygons, transformed);

  return (rect, lookPos, slowDrift) => {
    const matrix = computeMatrix(rect, lookPos, slowDrift);
    updatePositions(matrix);
    updateFaces(rect, container, polygons, transformed);
  };
}

/**
 * Populate vertex positions from the model JSON specification.
 *
 * @param {Float32Array} positions - The positions array to populate (this is the output).
 * @param {ModelJson} modelJson - The model JSON specification.
 */
function positionsFromModel(positions, modelJson) {
  const pp = modelJson.positions;
  let ptr = 0;
  for (let i = 0; i < pp.length; ++i) {
    const p = pp[i];
    for (let j = 0; j < 3; ++j) {
      positions[ptr] = p[j];
      ptr += 1;
    }
  }
}

/**
 * Create polygons from model.
 *
 * @param {ModelJson} modelJson - The model.
 * @param {typeof createStandardModelPolygon} createSvgPolygon - A function for creating an SVG
 * polygon node.
 * @returns {{ polygons: Polygon[], polygonsByChunk: Polygon[][]}} All model polygons, returned
 * both as a flat list, and sorted by chunk.
 */
function createPolygonsFromModelJson(modelJson, createSvgPolygon) {
  const polygons = [];
  const polygonsByChunk = modelJson.chunks.map((chunk, index) => {
    const { faces } = chunk;
    return faces.map((face) => {
      const svgPolygon = createSvgPolygon(chunk, {
        gradients: modelJson.gradients,
        index,
        masks: modelJson.masks,
      });
      const polygon = new Polygon(svgPolygon, face);
      polygons.push(polygon);
      return polygon;
    });
  });
  return { polygons, polygonsByChunk };
}

/**
 * Create an SVG `<polygon> element.
 *
 * This polygon is assigned the correct `fill` and `stroke` attributes, according to the chunk
 * definition provided. But the `points` attribute is always set to a dummy value, as it gets reset
 * later to the correct position during each render loop.
 *
 * @param {ChunkJson} chunk - The definition for the chunk of the model this polygon is a part of.
 * This includes the color or gradient to apply to the polygon.
 * @param {object} options - Polygon options.
 * @param {(LinearGradientDefinition | RadialGradientDefinition)[]} [options.gradients] - The set
 * of all gradient definitions used in this model.
 * @param {number} options.index - The index for the chunk this polygon is found in.
 * @param {ModelJson['masks']} [options.masks] - The set of all mask definitions.
 * @returns {SVGPolygonElement} The `<polygon>` SVG element.
 */
function createStandardModelPolygon(chunk, { gradients = {}, index, masks }) {
  const svgPolygon = createNode('polygon');

  if (chunk.gradient && chunk.color) {
    throw new Error(
      `Both gradient and color for chunk '${index}'. These options are mutually exclusive.`,
    );
  } else if (chunk.gradient) {
    const gradientId = chunk.gradient;
    if (!gradients[gradientId]) {
      throw new Error(`Gradient ID not found: '${gradientId}'`);
    }

    setAttribute(svgPolygon, 'fill', `url('#${gradientId}')`);
    setAttribute(svgPolygon, 'stroke', `url('#${gradientId}')`);
  } else {
    const fill =
      typeof chunk.color === 'string' ? chunk.color : `rgb(${chunk.color})`;
    setAttribute(svgPolygon, 'fill', fill);
    setAttribute(svgPolygon, 'stroke', fill);
  }

  if (chunk.mask) {
    if (!masks[chunk.mask]) {
      throw new Error(`Mask ID not found: '${chunk.mask}'`);
    }
    setAttribute(svgPolygon, 'mask', `url('#${chunk.mask}')`);
  }

  setAttribute(svgPolygon, 'points', '0,0, 10,0, 0,10');
  return svgPolygon;
}

/**
 * Create function for computing transformation matrix for rendering. This transformation matrix
 * renders the model at the given distance from the camera, and it adjusts the model to look at
 * the given position on each render.
 *
 * @param {number} distance - The distance between the model and the camera
 * @param {object} options - Options.
 * @param {number} options.verticalFieldOfView - Vertical field of view (in radians).
 * @param {number} options.near - Near bound of the frustrum.
 * @param {number} options.far - Far bound of the frustrum.
 * @returns {(rect: SvgSize, lookPos: [number, number], slowDrift: boolean) => Float32Array} A
 * function for computing the transformation matrix.
 */
function createMatrixComputer(distance, { verticalFieldOfView, near, far }) {
  const objectCenter = new Float32Array(3);
  const up = new Float32Array([0, 1, 0]);
  const projection = new Float32Array(16);
  const model = new Float32Array(16);
  const view = lookAt(
    new Float32Array(16),
    new Float32Array([0, 0, distance]),
    objectCenter,
    up,
  );
  const invView = invert(new Float32Array(16), view);
  const invProjection = new Float32Array(16);
  const target = new Float32Array(3);
  const transformedMatrix = new Float32Array(16);

  const X = new Float32Array([1, 0, 0]);
  const Y = new Float32Array([0, 1, 0]);
  const Z = new Float32Array([0, 0, 1]);

  return (rect, lookPos, slowDrift) => {
    const viewportWidth = rect.width;
    const viewportHeight = rect.height;
    perspective(
      projection,
      verticalFieldOfView,
      viewportWidth / viewportHeight,
      near,
      far,
    );
    invert(invProjection, projection);
    target[0] = lookPos[0];
    target[1] = lookPos[1];
    target[2] = 1.2;
    transform(target, target, invProjection);
    transform(target, target, invView);
    lookAt(model, objectCenter, target, up);

    // this shouldnt operate directly on the matrix/model,
    // it should likely operate on the lookPos
    // if we do want to operate on the matrix/model, it shouldnt happen here
    if (slowDrift) {
      const time = Date.now() / 1000.0;
      rotate(model, model, 0.1 + Math.sin(time / 3) * 0.2, X);
      rotate(model, model, -0.1 + Math.sin(time / 2) * 0.03, Z);
      rotate(model, model, 0.5 + Math.sin(time / 3) * 0.2, Y);
    }

    multiply(transformedMatrix, projection, view);
    multiply(transformedMatrix, transformedMatrix, model);

    return transformedMatrix;
  };
}

/**
 * Create a function that updates the positions of each vertex.
 *
 * @param {number[]} positions - Vertex positions.
 * @param {number[]} transformed - Vertex transformations (this is the output of the returned
 * function).
 * @param {number} vertCount - The number of vertices.
 * @returns {(M: Float32Array) => void} A function that updates vertex positions.
 */
function createPositionUpdater(positions, transformed, vertCount) {
  return (M) => {
    const m00 = M[0];
    const m01 = M[1];
    const m02 = M[2];
    const m03 = M[3];
    const m10 = M[4];
    const m11 = M[5];
    const m12 = M[6];
    const m13 = M[7];
    const m20 = M[8];
    const m21 = M[9];
    const m22 = M[10];
    const m23 = M[11];
    const m30 = M[12];
    const m31 = M[13];
    const m32 = M[14];
    const m33 = M[15];

    for (let i = 0; i < vertCount; ++i) {
      const x = positions[3 * i];
      const y = positions[3 * i + 1];
      const z = positions[3 * i + 2];

      const tw = x * m03 + y * m13 + z * m23 + m33;
      transformed[3 * i] = (x * m00 + y * m10 + z * m20 + m30) / tw;
      transformed[3 * i + 1] = (x * m01 + y * m11 + z * m21 + m31) / tw;
      transformed[3 * i + 2] = (x * m02 + y * m12 + z * m22 + m32) / tw;
    }
  };
}

/**
 * A sort comparison function for comparing the z-index of two polygons.
 *
 * @param {Polygon} a - The first polygon.
 * @param {Polygon} b - The second polygon.
 * @returns {number} A number indicating whether the sort order should change; a positive number
 * indicates that b comes first.
 */
function compareZ(a, b) {
  return b.zIndex - a.zIndex;
}

/**
 * Create a function for updating positions of each polygon.
 *
 * @param {SVGSVGElement} container - The SVG element that the model is rendered within.
 * @param {Polygon[]} polygons - The polygons to update.
 * @param {number[]} transformed - Vertex transformations.
 * @returns {(rect: SvgSize) => void} A function that updates the position of each polygon in the
 * model.
 */
function createFaceUpdater(container, polygons, transformed) {
  const toDraw = [];
  return (rect) => {
    let i;
    const w = rect.width;
    const h = rect.height;
    toDraw.length = 0;
    for (i = 0; i < polygons.length; ++i) {
      const poly = polygons[i];
      const { indices } = poly;

      const i0 = indices[0];
      const i1 = indices[1];
      const i2 = indices[2];
      const ax = transformed[3 * i0];
      const ay = transformed[3 * i0 + 1];
      const bx = transformed[3 * i1];
      const by = transformed[3 * i1 + 1];
      const cx = transformed[3 * i2];
      const cy = transformed[3 * i2 + 1];
      const det = (bx - ax) * (cy - ay) - (by - ay) * (cx - ax);
      if (det < 0) {
        continue;
      }

      const points = [];
      let zmax = -Infinity;
      let zmin = Infinity;
      const element = poly.svg;
      for (let j = 0; j < 3; ++j) {
        const idx = indices[j];
        points.push(
          `${0.5 * w * (1.0 - transformed[3 * idx])},${
            0.5 * h * (1.0 - transformed[3 * idx + 1])
          }`,
        );
        const z = transformed[3 * idx + 2];
        zmax = Math.max(zmax, z);
        zmin = Math.min(zmin, z);
      }
      poly.zIndex = zmax + 0.25 * zmin;
      const joinedPoints = points.join(' ');

      if (joinedPoints.indexOf('NaN') === -1) {
        setAttribute(element, 'points', joinedPoints);
      }

      toDraw.push(poly);
    }
    toDraw.sort(compareZ);

    const newPolygons = toDraw.map((poly) => poly.svg);
    const defs = container.getElementsByTagName('defs');
    const maskChildren = container.getElementsByTagName('mask');
    if (container.replaceChildren) {
      container.replaceChildren(...defs, ...maskChildren, ...newPolygons);
    } else {
      replaceChildrenPonyfill.bind(container)(
        ...defs,
        ...maskChildren,
        ...newPolygons,
      );
    }
  };
}

/**
 * Calculate wigth and height of SVG. Width and height can be specified either as a ratio of window
 * size, or in pixels.
 *
 * @param {object} [options] - Options.
 * @param {number} [options.width] - Width, either in pixels or as a ratio of window width.
 * @param {number} [options.height] - Height, either in pixels or as a ratio of window height.
 * @param {number} [options.minWidth] - Minimum width (in pixels), used as a lower bound if the
 * width is specified as a ratio.
 * @param {boolean} [options.pxNotRatio] - True indicates the width and height are in pixels, false
 * indicates they are a ratio.
 * @returns {SvgSize} Calculated width and height.
 */
function calculateSizingOptions(options = {}) {
  let width = options.width || 400;
  let height = options.height || 400;

  if (!options.pxNotRatio) {
    width = Math.floor(window.innerWidth * (options.width || 0.25));
    height = Math.floor(window.innerHeight * options.height || width);

    if ('minWidth' in options && width < options.minWidth) {
      width = options.minWidth;
      height = Math.floor((options.minWidth * options.height) / options.width);
    }
  }
  return { width, height };
}

/**
 * Create SVG node.
 *
 * @param {keyof SVGElementEventMap} type - The SVG node type.
 * @returns {SVGElement} The created SVG node.
 */
function createNode(type) {
  return document.createElementNS(SVG_NS, type);
}

/**
 * Set an attribute on the given SVG node.
 *
 * @param {SVGElement} node - The SVG node.
 * @param {string} attribute - The name of the attribute to set.
 * @param {unknown} value - The attribute value to set.
 */
function setAttribute(node, attribute, value) {
  node.setAttributeNS(null, attribute, value);
}

/**
 * Capture the given SVG element as a string.
 *
 * @param {SVGSVGElement} svgElement - The SVG element to capture.
 * @returns {string} A snapshot of the SVG.
 */
function svgElementToSvgImageContent(svgElement) {
  const inner = svgElement.innerHTML;
  const head =
    `<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd"> ` +
    `<svg width="521px" height="521px" version="1.1" baseProfile="full" xmlns="${SVG_NS}" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:ev="http://www.w3.org/2001/xml-events">`;
  const foot = '</svg>';
  const content = head + inner + foot;
  return content;
}

/**
 * A three-sided polygon.
 *
 * @param {SVGPolygonElement} svg - The SVG polygon element.
 * @param {[number, number, number]} indices - The indices of each vertex of the polygon.
 */
function Polygon(svg, indices) {
  this.svg = svg;
  this.indices = indices;
  this.zIndex = 0;
}

/**
 * Parse gradient definitions and construct them in the DOM.
 *
 * Both `<linearGradient>` and `<radialGradient>` are supported. All gradients get added to a
 * `<defs>` element that is added as a direct child of the container element.
 *
 * @param {SVGSVGElement} container - The `<svg>` HTML element that the definitions should be added
 * to.
 * @param {(LinearGradientDefinition | RadialGradientDefinition)[]} [gradients] - The gradient
 * definitions.
 */
function setGradientDefinitions(container, gradients) {
  if (!gradients || Object.keys(gradients).length === 0) {
    return;
  }

  const defsContainer = createNode('defs');

  const linearCoordinateAttributes = ['x1', 'x2', 'y1', 'y2'];
  const radialCoordinateAttributes = ['cx', 'cy', 'fr', 'fx', 'fy', 'r'];
  const commonAttributes = [
    'gradientTransform',
    'gradientUnits',
    'spreadMethod',
    'stops',
    'type',
  ];
  const allLinearAttributes = [
    ...linearCoordinateAttributes,
    ...commonAttributes,
  ];
  const allRadialAttributes = [
    ...radialCoordinateAttributes,
    ...commonAttributes,
  ];

  for (const [gradientId, gradientDefinition] of Object.entries(gradients)) {
    let gradient;
    if (gradientDefinition.type === 'linear') {
      gradient = createNode('linearGradient');

      const unsupportedLinearAttribute = Object.keys(gradientDefinition).find(
        (attribute) => !allLinearAttributes.includes(attribute),
      );
      if (unsupportedLinearAttribute) {
        throw new Error(
          `Unsupported linear gradient attribute: '${unsupportedLinearAttribute}'`,
        );
      } else if (
        linearCoordinateAttributes.some(
          (attributeName) => gradientDefinition[attributeName] !== undefined,
        )
      ) {
        const missingAttributes = linearCoordinateAttributes.filter(
          (attributeName) => gradientDefinition[attributeName] === undefined,
        );
        if (missingAttributes.length > 0) {
          throw new Error(
            `Missing coordinate attributes: '${missingAttributes.join(', ')}'`,
          );
        }

        for (const attribute of linearCoordinateAttributes) {
          if (typeof gradientDefinition[attribute] !== 'string') {
            throw new Error(
              `Type of '${attribute}' option expected to be 'string'. Instead received type '${typeof gradientDefinition[
                attribute
              ]}'`,
            );
          }
          setAttribute(gradient, attribute, gradientDefinition[attribute]);
        }
      }
    } else if (gradientDefinition.type === 'radial') {
      gradient = createNode('radialGradient');

      const presentCoordinateAttributes = radialCoordinateAttributes.filter(
        (attributeName) => gradientDefinition[attributeName] !== undefined,
      );
      const unsupportedRadialAttribute = Object.keys(gradientDefinition).find(
        (attribute) => !allRadialAttributes.includes(attribute),
      );
      if (unsupportedRadialAttribute) {
        throw new Error(
          `Unsupported radial gradient attribute: '${unsupportedRadialAttribute}'`,
        );
      } else if (presentCoordinateAttributes.length > 0) {
        for (const attribute of presentCoordinateAttributes) {
          if (typeof gradientDefinition[attribute] !== 'string') {
            throw new Error(
              `Type of '${attribute}' option expected to be 'string'. Instead received type '${typeof gradientDefinition[
                attribute
              ]}'`,
            );
          }
          setAttribute(gradient, attribute, gradientDefinition[attribute]);
        }
      }
    } else {
      throw new Error(
        `Unsupported gradient type: '${gradientDefinition.type}'`,
      );
    }

    // Set common attributes
    setAttribute(gradient, 'id', gradientId);
    if (gradientDefinition.gradientUnits !== undefined) {
      if (
        !['userSpaceOnUse', 'objectBoundingBox'].includes(
          gradientDefinition.gradientUnits,
        )
      ) {
        throw new Error(
          `Unrecognized value for 'gradientUnits' attribute: '${gradientDefinition.gradientUnits}'`,
        );
      }
      setAttribute(gradient, 'gradientUnits', gradientDefinition.gradientUnits);
    }

    if (gradientDefinition.gradientTransform !== undefined) {
      if (typeof gradientDefinition.gradientTransform !== 'string') {
        throw new Error(
          `Type of 'gradientTransform' option expected to be 'string'. Instead received type '${typeof gradientDefinition.gradientTransform}'`,
        );
      }

      setAttribute(
        gradient,
        'gradientTransform',
        gradientDefinition.gradientTransform,
      );
    }

    if (gradientDefinition.spreadMethod !== undefined) {
      if (
        !['pad', 'reflect', 'repeat'].includes(gradientDefinition.spreadMethod)
      ) {
        throw new Error(
          `Unrecognized value for 'spreadMethod' attribute: '${gradientDefinition.spreadMethod}'`,
        );
      }
      setAttribute(gradient, 'spreadMethod', gradientDefinition.spreadMethod);
    }

    if (gradientDefinition.stops !== undefined) {
      if (!Array.isArray(gradientDefinition.stops)) {
        throw new Error(`The 'stop' attribute must be an array`);
      }

      for (const stopDefinition of gradientDefinition.stops) {
        if (typeof stopDefinition !== 'object') {
          throw new Error(
            `Each entry in the 'stop' attribute must be an object. Instead received type '${typeof stopDefinition}'`,
          );
        }
        const stop = createNode('stop');

        if (stopDefinition.offset !== undefined) {
          setAttribute(stop, 'offset', stopDefinition.offset);
        }

        if (stopDefinition['stop-color'] !== undefined) {
          setAttribute(stop, 'stop-color', stopDefinition['stop-color']);
        }

        if (stopDefinition['stop-opacity'] !== undefined) {
          setAttribute(stop, 'stop-opacity', stopDefinition['stop-opacity']);
        }

        gradient.appendChild(stop);
      }
    }

    defsContainer.appendChild(gradient);
  }

  container.appendChild(defsContainer);
}

/**
 * Parse mask definitions and construct them in the DOM.
 *
 * The `<mask>` element contains a single rectangle that should cover the full extent of the SVG
 * model. The color of this rectangle can be set to single color or a gradient. Anything the mask
 * is applied to will be invisible if under a black pixel, visible if under a white pixel, and
 * partially translucent if under a pixel that is between white and black.
 *
 * Later this could be extended to include custom paths and other shapes, rather than just a single
 * rectangle.
 *
 * @param options - The mask options.
 * @param {SVGSVGElement} options.container - The `<svg>` HTML element that the mask should be added
 * to.
 * @param {ModelJson['masks']} [options.masks] - The gradient definitions.
 * @param {number